%------------------------------------------------------------------------------
% File     : HWV097+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 8 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop8_cone5_b20 [Kha14]

% Status   : Theorem
% Rating   : 1.00 v6.1.0
% Syntax   : Number of formulae    : 16858 (8023 unt;   0 def)
%            Number of atoms       : 49851 ( 795 equ)
%            Maximal formula atoms :   78 (   2 avg)
%            Number of connectives : 40210 (7217   ~;1592   |;10169   &)
%                                         (18365 <=>;2865  =>;   0  <=;   2 <~>)
%            Maximal formula depth :   70 (   3 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 5164 (5161 usr;   2 prp; 0-3 aty)
%            Number of functors    :  256 ( 256 usr; 256 con; 0-0 aty)
%            Number of variables   : 9983 (9983   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(transient_address_definition_125,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_20,B)
    <=> v2709(constB20,B) ) ).

fof(is_address_141,axiom,
    address(v2709_range_3_to_0_address_term_bound_20) ).

fof(address_association_125,axiom,
    v2709_range_3_to_0_address_association(constB20,v2709_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_124,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_19,B)
    <=> v2709(constB19,B) ) ).

fof(is_address_140,axiom,
    address(v2709_range_3_to_0_address_term_bound_19) ).

fof(address_association_124,axiom,
    v2709_range_3_to_0_address_association(constB19,v2709_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_123,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_18,B)
    <=> v2709(constB18,B) ) ).

fof(is_address_139,axiom,
    address(v2709_range_3_to_0_address_term_bound_18) ).

fof(address_association_123,axiom,
    v2709_range_3_to_0_address_association(constB18,v2709_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_122,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_17,B)
    <=> v2709(constB17,B) ) ).

fof(is_address_138,axiom,
    address(v2709_range_3_to_0_address_term_bound_17) ).

fof(address_association_122,axiom,
    v2709_range_3_to_0_address_association(constB17,v2709_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_121,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_16,B)
    <=> v2709(constB16,B) ) ).

fof(is_address_137,axiom,
    address(v2709_range_3_to_0_address_term_bound_16) ).

fof(address_association_121,axiom,
    v2709_range_3_to_0_address_association(constB16,v2709_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_120,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_15,B)
    <=> v2709(constB15,B) ) ).

fof(is_address_136,axiom,
    address(v2709_range_3_to_0_address_term_bound_15) ).

fof(address_association_120,axiom,
    v2709_range_3_to_0_address_association(constB15,v2709_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_119,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_14,B)
    <=> v2709(constB14,B) ) ).

fof(is_address_135,axiom,
    address(v2709_range_3_to_0_address_term_bound_14) ).

fof(address_association_119,axiom,
    v2709_range_3_to_0_address_association(constB14,v2709_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_118,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_13,B)
    <=> v2709(constB13,B) ) ).

fof(is_address_134,axiom,
    address(v2709_range_3_to_0_address_term_bound_13) ).

fof(address_association_118,axiom,
    v2709_range_3_to_0_address_association(constB13,v2709_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_117,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_12,B)
    <=> v2709(constB12,B) ) ).

fof(is_address_133,axiom,
    address(v2709_range_3_to_0_address_term_bound_12) ).

fof(address_association_117,axiom,
    v2709_range_3_to_0_address_association(constB12,v2709_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_116,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_11,B)
    <=> v2709(constB11,B) ) ).

fof(is_address_132,axiom,
    address(v2709_range_3_to_0_address_term_bound_11) ).

fof(address_association_116,axiom,
    v2709_range_3_to_0_address_association(constB11,v2709_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_115,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_10,B)
    <=> v2709(constB10,B) ) ).

fof(is_address_131,axiom,
    address(v2709_range_3_to_0_address_term_bound_10) ).

fof(address_association_115,axiom,
    v2709_range_3_to_0_address_association(constB10,v2709_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_114,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_9,B)
    <=> v2709(constB9,B) ) ).

fof(is_address_130,axiom,
    address(v2709_range_3_to_0_address_term_bound_9) ).

fof(address_association_114,axiom,
    v2709_range_3_to_0_address_association(constB9,v2709_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_113,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_8,B)
    <=> v2709(constB8,B) ) ).

fof(is_address_129,axiom,
    address(v2709_range_3_to_0_address_term_bound_8) ).

fof(address_association_113,axiom,
    v2709_range_3_to_0_address_association(constB8,v2709_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_112,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_7,B)
    <=> v2709(constB7,B) ) ).

fof(is_address_128,axiom,
    address(v2709_range_3_to_0_address_term_bound_7) ).

fof(address_association_112,axiom,
    v2709_range_3_to_0_address_association(constB7,v2709_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_111,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_6,B)
    <=> v2709(constB6,B) ) ).

fof(is_address_127,axiom,
    address(v2709_range_3_to_0_address_term_bound_6) ).

fof(address_association_111,axiom,
    v2709_range_3_to_0_address_association(constB6,v2709_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_110,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_5,B)
    <=> v2709(constB5,B) ) ).

fof(is_address_126,axiom,
    address(v2709_range_3_to_0_address_term_bound_5) ).

fof(address_association_110,axiom,
    v2709_range_3_to_0_address_association(constB5,v2709_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_109,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_4,B)
    <=> v2709(constB4,B) ) ).

fof(is_address_125,axiom,
    address(v2709_range_3_to_0_address_term_bound_4) ).

fof(address_association_109,axiom,
    v2709_range_3_to_0_address_association(constB4,v2709_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_108,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_3,B)
    <=> v2709(constB3,B) ) ).

fof(is_address_124,axiom,
    address(v2709_range_3_to_0_address_term_bound_3) ).

fof(address_association_108,axiom,
    v2709_range_3_to_0_address_association(constB3,v2709_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_107,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_2,B)
    <=> v2709(constB2,B) ) ).

fof(is_address_123,axiom,
    address(v2709_range_3_to_0_address_term_bound_2) ).

fof(address_association_107,axiom,
    v2709_range_3_to_0_address_association(constB2,v2709_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_106,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_1,B)
    <=> v2709(constB1,B) ) ).

fof(is_address_122,axiom,
    address(v2709_range_3_to_0_address_term_bound_1) ).

fof(address_association_106,axiom,
    v2709_range_3_to_0_address_association(constB1,v2709_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_105,axiom,
    ! [B] :
      ( addressVal(v2709_range_3_to_0_address_term_bound_0,B)
    <=> v2709(constB0,B) ) ).

fof(is_address_121,axiom,
    address(v2709_range_3_to_0_address_term_bound_0) ).

fof(address_association_105,axiom,
    v2709_range_3_to_0_address_association(constB0,v2709_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_104,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_20,B)
    <=> v2643(constB20,B) ) ).

fof(is_address_120,axiom,
    address(v2643_range_3_to_0_address_term_bound_20) ).

fof(address_association_104,axiom,
    v2643_range_3_to_0_address_association(constB20,v2643_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_103,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_19,B)
    <=> v2643(constB19,B) ) ).

fof(is_address_119,axiom,
    address(v2643_range_3_to_0_address_term_bound_19) ).

fof(address_association_103,axiom,
    v2643_range_3_to_0_address_association(constB19,v2643_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_102,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_18,B)
    <=> v2643(constB18,B) ) ).

fof(is_address_118,axiom,
    address(v2643_range_3_to_0_address_term_bound_18) ).

fof(address_association_102,axiom,
    v2643_range_3_to_0_address_association(constB18,v2643_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_101,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_17,B)
    <=> v2643(constB17,B) ) ).

fof(is_address_117,axiom,
    address(v2643_range_3_to_0_address_term_bound_17) ).

fof(address_association_101,axiom,
    v2643_range_3_to_0_address_association(constB17,v2643_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_100,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_16,B)
    <=> v2643(constB16,B) ) ).

fof(is_address_116,axiom,
    address(v2643_range_3_to_0_address_term_bound_16) ).

fof(address_association_100,axiom,
    v2643_range_3_to_0_address_association(constB16,v2643_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_99,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_15,B)
    <=> v2643(constB15,B) ) ).

fof(is_address_115,axiom,
    address(v2643_range_3_to_0_address_term_bound_15) ).

fof(address_association_99,axiom,
    v2643_range_3_to_0_address_association(constB15,v2643_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_98,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_14,B)
    <=> v2643(constB14,B) ) ).

fof(is_address_114,axiom,
    address(v2643_range_3_to_0_address_term_bound_14) ).

fof(address_association_98,axiom,
    v2643_range_3_to_0_address_association(constB14,v2643_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_97,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_13,B)
    <=> v2643(constB13,B) ) ).

fof(is_address_113,axiom,
    address(v2643_range_3_to_0_address_term_bound_13) ).

fof(address_association_97,axiom,
    v2643_range_3_to_0_address_association(constB13,v2643_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_96,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_12,B)
    <=> v2643(constB12,B) ) ).

fof(is_address_112,axiom,
    address(v2643_range_3_to_0_address_term_bound_12) ).

fof(address_association_96,axiom,
    v2643_range_3_to_0_address_association(constB12,v2643_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_95,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_11,B)
    <=> v2643(constB11,B) ) ).

fof(is_address_111,axiom,
    address(v2643_range_3_to_0_address_term_bound_11) ).

fof(address_association_95,axiom,
    v2643_range_3_to_0_address_association(constB11,v2643_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_94,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_10,B)
    <=> v2643(constB10,B) ) ).

fof(is_address_110,axiom,
    address(v2643_range_3_to_0_address_term_bound_10) ).

fof(address_association_94,axiom,
    v2643_range_3_to_0_address_association(constB10,v2643_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_93,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_9,B)
    <=> v2643(constB9,B) ) ).

fof(is_address_109,axiom,
    address(v2643_range_3_to_0_address_term_bound_9) ).

fof(address_association_93,axiom,
    v2643_range_3_to_0_address_association(constB9,v2643_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_92,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_8,B)
    <=> v2643(constB8,B) ) ).

fof(is_address_108,axiom,
    address(v2643_range_3_to_0_address_term_bound_8) ).

fof(address_association_92,axiom,
    v2643_range_3_to_0_address_association(constB8,v2643_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_91,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_7,B)
    <=> v2643(constB7,B) ) ).

fof(is_address_107,axiom,
    address(v2643_range_3_to_0_address_term_bound_7) ).

fof(address_association_91,axiom,
    v2643_range_3_to_0_address_association(constB7,v2643_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_90,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_6,B)
    <=> v2643(constB6,B) ) ).

fof(is_address_106,axiom,
    address(v2643_range_3_to_0_address_term_bound_6) ).

fof(address_association_90,axiom,
    v2643_range_3_to_0_address_association(constB6,v2643_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_89,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_5,B)
    <=> v2643(constB5,B) ) ).

fof(is_address_105,axiom,
    address(v2643_range_3_to_0_address_term_bound_5) ).

fof(address_association_89,axiom,
    v2643_range_3_to_0_address_association(constB5,v2643_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_88,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_4,B)
    <=> v2643(constB4,B) ) ).

fof(is_address_104,axiom,
    address(v2643_range_3_to_0_address_term_bound_4) ).

fof(address_association_88,axiom,
    v2643_range_3_to_0_address_association(constB4,v2643_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_87,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_3,B)
    <=> v2643(constB3,B) ) ).

fof(is_address_103,axiom,
    address(v2643_range_3_to_0_address_term_bound_3) ).

fof(address_association_87,axiom,
    v2643_range_3_to_0_address_association(constB3,v2643_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_86,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_2,B)
    <=> v2643(constB2,B) ) ).

fof(is_address_102,axiom,
    address(v2643_range_3_to_0_address_term_bound_2) ).

fof(address_association_86,axiom,
    v2643_range_3_to_0_address_association(constB2,v2643_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_85,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_1,B)
    <=> v2643(constB1,B) ) ).

fof(is_address_101,axiom,
    address(v2643_range_3_to_0_address_term_bound_1) ).

fof(address_association_85,axiom,
    v2643_range_3_to_0_address_association(constB1,v2643_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_84,axiom,
    ! [B] :
      ( addressVal(v2643_range_3_to_0_address_term_bound_0,B)
    <=> v2643(constB0,B) ) ).

fof(is_address_100,axiom,
    address(v2643_range_3_to_0_address_term_bound_0) ).

fof(address_association_84,axiom,
    v2643_range_3_to_0_address_association(constB0,v2643_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_83,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_20,B)
    <=> v2559(constB20,B) ) ).

fof(is_address_99,axiom,
    address(v2559_range_3_to_0_address_term_bound_20) ).

fof(address_association_83,axiom,
    v2559_range_3_to_0_address_association(constB20,v2559_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_82,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_19,B)
    <=> v2559(constB19,B) ) ).

fof(is_address_98,axiom,
    address(v2559_range_3_to_0_address_term_bound_19) ).

fof(address_association_82,axiom,
    v2559_range_3_to_0_address_association(constB19,v2559_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_81,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_18,B)
    <=> v2559(constB18,B) ) ).

fof(is_address_97,axiom,
    address(v2559_range_3_to_0_address_term_bound_18) ).

fof(address_association_81,axiom,
    v2559_range_3_to_0_address_association(constB18,v2559_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_80,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_17,B)
    <=> v2559(constB17,B) ) ).

fof(is_address_96,axiom,
    address(v2559_range_3_to_0_address_term_bound_17) ).

fof(address_association_80,axiom,
    v2559_range_3_to_0_address_association(constB17,v2559_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_79,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_16,B)
    <=> v2559(constB16,B) ) ).

fof(is_address_95,axiom,
    address(v2559_range_3_to_0_address_term_bound_16) ).

fof(address_association_79,axiom,
    v2559_range_3_to_0_address_association(constB16,v2559_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_78,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_15,B)
    <=> v2559(constB15,B) ) ).

fof(is_address_94,axiom,
    address(v2559_range_3_to_0_address_term_bound_15) ).

fof(address_association_78,axiom,
    v2559_range_3_to_0_address_association(constB15,v2559_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_77,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_14,B)
    <=> v2559(constB14,B) ) ).

fof(is_address_93,axiom,
    address(v2559_range_3_to_0_address_term_bound_14) ).

fof(address_association_77,axiom,
    v2559_range_3_to_0_address_association(constB14,v2559_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_76,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_13,B)
    <=> v2559(constB13,B) ) ).

fof(is_address_92,axiom,
    address(v2559_range_3_to_0_address_term_bound_13) ).

fof(address_association_76,axiom,
    v2559_range_3_to_0_address_association(constB13,v2559_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_75,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_12,B)
    <=> v2559(constB12,B) ) ).

fof(is_address_91,axiom,
    address(v2559_range_3_to_0_address_term_bound_12) ).

fof(address_association_75,axiom,
    v2559_range_3_to_0_address_association(constB12,v2559_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_74,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_11,B)
    <=> v2559(constB11,B) ) ).

fof(is_address_90,axiom,
    address(v2559_range_3_to_0_address_term_bound_11) ).

fof(address_association_74,axiom,
    v2559_range_3_to_0_address_association(constB11,v2559_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_73,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_10,B)
    <=> v2559(constB10,B) ) ).

fof(is_address_89,axiom,
    address(v2559_range_3_to_0_address_term_bound_10) ).

fof(address_association_73,axiom,
    v2559_range_3_to_0_address_association(constB10,v2559_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_72,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_9,B)
    <=> v2559(constB9,B) ) ).

fof(is_address_88,axiom,
    address(v2559_range_3_to_0_address_term_bound_9) ).

fof(address_association_72,axiom,
    v2559_range_3_to_0_address_association(constB9,v2559_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_71,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_8,B)
    <=> v2559(constB8,B) ) ).

fof(is_address_87,axiom,
    address(v2559_range_3_to_0_address_term_bound_8) ).

fof(address_association_71,axiom,
    v2559_range_3_to_0_address_association(constB8,v2559_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_70,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_7,B)
    <=> v2559(constB7,B) ) ).

fof(is_address_86,axiom,
    address(v2559_range_3_to_0_address_term_bound_7) ).

fof(address_association_70,axiom,
    v2559_range_3_to_0_address_association(constB7,v2559_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_69,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_6,B)
    <=> v2559(constB6,B) ) ).

fof(is_address_85,axiom,
    address(v2559_range_3_to_0_address_term_bound_6) ).

fof(address_association_69,axiom,
    v2559_range_3_to_0_address_association(constB6,v2559_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_68,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_5,B)
    <=> v2559(constB5,B) ) ).

fof(is_address_84,axiom,
    address(v2559_range_3_to_0_address_term_bound_5) ).

fof(address_association_68,axiom,
    v2559_range_3_to_0_address_association(constB5,v2559_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_67,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_4,B)
    <=> v2559(constB4,B) ) ).

fof(is_address_83,axiom,
    address(v2559_range_3_to_0_address_term_bound_4) ).

fof(address_association_67,axiom,
    v2559_range_3_to_0_address_association(constB4,v2559_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_66,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_3,B)
    <=> v2559(constB3,B) ) ).

fof(is_address_82,axiom,
    address(v2559_range_3_to_0_address_term_bound_3) ).

fof(address_association_66,axiom,
    v2559_range_3_to_0_address_association(constB3,v2559_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_65,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_2,B)
    <=> v2559(constB2,B) ) ).

fof(is_address_81,axiom,
    address(v2559_range_3_to_0_address_term_bound_2) ).

fof(address_association_65,axiom,
    v2559_range_3_to_0_address_association(constB2,v2559_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_64,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_1,B)
    <=> v2559(constB1,B) ) ).

fof(is_address_80,axiom,
    address(v2559_range_3_to_0_address_term_bound_1) ).

fof(address_association_64,axiom,
    v2559_range_3_to_0_address_association(constB1,v2559_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_63,axiom,
    ! [B] :
      ( addressVal(v2559_range_3_to_0_address_term_bound_0,B)
    <=> v2559(constB0,B) ) ).

fof(is_address_79,axiom,
    address(v2559_range_3_to_0_address_term_bound_0) ).

fof(address_association_63,axiom,
    v2559_range_3_to_0_address_association(constB0,v2559_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_62,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_20,B)
    <=> v2493(constB20,B) ) ).

fof(is_address_78,axiom,
    address(v2493_range_3_to_0_address_term_bound_20) ).

fof(address_association_62,axiom,
    v2493_range_3_to_0_address_association(constB20,v2493_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_61,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_19,B)
    <=> v2493(constB19,B) ) ).

fof(is_address_77,axiom,
    address(v2493_range_3_to_0_address_term_bound_19) ).

fof(address_association_61,axiom,
    v2493_range_3_to_0_address_association(constB19,v2493_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_60,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_18,B)
    <=> v2493(constB18,B) ) ).

fof(is_address_76,axiom,
    address(v2493_range_3_to_0_address_term_bound_18) ).

fof(address_association_60,axiom,
    v2493_range_3_to_0_address_association(constB18,v2493_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_59,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_17,B)
    <=> v2493(constB17,B) ) ).

fof(is_address_75,axiom,
    address(v2493_range_3_to_0_address_term_bound_17) ).

fof(address_association_59,axiom,
    v2493_range_3_to_0_address_association(constB17,v2493_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_58,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_16,B)
    <=> v2493(constB16,B) ) ).

fof(is_address_74,axiom,
    address(v2493_range_3_to_0_address_term_bound_16) ).

fof(address_association_58,axiom,
    v2493_range_3_to_0_address_association(constB16,v2493_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_57,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_15,B)
    <=> v2493(constB15,B) ) ).

fof(is_address_73,axiom,
    address(v2493_range_3_to_0_address_term_bound_15) ).

fof(address_association_57,axiom,
    v2493_range_3_to_0_address_association(constB15,v2493_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_56,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_14,B)
    <=> v2493(constB14,B) ) ).

fof(is_address_72,axiom,
    address(v2493_range_3_to_0_address_term_bound_14) ).

fof(address_association_56,axiom,
    v2493_range_3_to_0_address_association(constB14,v2493_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_55,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_13,B)
    <=> v2493(constB13,B) ) ).

fof(is_address_71,axiom,
    address(v2493_range_3_to_0_address_term_bound_13) ).

fof(address_association_55,axiom,
    v2493_range_3_to_0_address_association(constB13,v2493_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_54,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_12,B)
    <=> v2493(constB12,B) ) ).

fof(is_address_70,axiom,
    address(v2493_range_3_to_0_address_term_bound_12) ).

fof(address_association_54,axiom,
    v2493_range_3_to_0_address_association(constB12,v2493_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_53,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_11,B)
    <=> v2493(constB11,B) ) ).

fof(is_address_69,axiom,
    address(v2493_range_3_to_0_address_term_bound_11) ).

fof(address_association_53,axiom,
    v2493_range_3_to_0_address_association(constB11,v2493_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_52,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_10,B)
    <=> v2493(constB10,B) ) ).

fof(is_address_68,axiom,
    address(v2493_range_3_to_0_address_term_bound_10) ).

fof(address_association_52,axiom,
    v2493_range_3_to_0_address_association(constB10,v2493_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_51,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_9,B)
    <=> v2493(constB9,B) ) ).

fof(is_address_67,axiom,
    address(v2493_range_3_to_0_address_term_bound_9) ).

fof(address_association_51,axiom,
    v2493_range_3_to_0_address_association(constB9,v2493_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_50,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_8,B)
    <=> v2493(constB8,B) ) ).

fof(is_address_66,axiom,
    address(v2493_range_3_to_0_address_term_bound_8) ).

fof(address_association_50,axiom,
    v2493_range_3_to_0_address_association(constB8,v2493_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_49,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_7,B)
    <=> v2493(constB7,B) ) ).

fof(is_address_65,axiom,
    address(v2493_range_3_to_0_address_term_bound_7) ).

fof(address_association_49,axiom,
    v2493_range_3_to_0_address_association(constB7,v2493_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_48,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_6,B)
    <=> v2493(constB6,B) ) ).

fof(is_address_64,axiom,
    address(v2493_range_3_to_0_address_term_bound_6) ).

fof(address_association_48,axiom,
    v2493_range_3_to_0_address_association(constB6,v2493_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_47,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_5,B)
    <=> v2493(constB5,B) ) ).

fof(is_address_63,axiom,
    address(v2493_range_3_to_0_address_term_bound_5) ).

fof(address_association_47,axiom,
    v2493_range_3_to_0_address_association(constB5,v2493_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_46,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_4,B)
    <=> v2493(constB4,B) ) ).

fof(is_address_62,axiom,
    address(v2493_range_3_to_0_address_term_bound_4) ).

fof(address_association_46,axiom,
    v2493_range_3_to_0_address_association(constB4,v2493_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_45,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_3,B)
    <=> v2493(constB3,B) ) ).

fof(is_address_61,axiom,
    address(v2493_range_3_to_0_address_term_bound_3) ).

fof(address_association_45,axiom,
    v2493_range_3_to_0_address_association(constB3,v2493_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_44,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_2,B)
    <=> v2493(constB2,B) ) ).

fof(is_address_60,axiom,
    address(v2493_range_3_to_0_address_term_bound_2) ).

fof(address_association_44,axiom,
    v2493_range_3_to_0_address_association(constB2,v2493_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_43,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_1,B)
    <=> v2493(constB1,B) ) ).

fof(is_address_59,axiom,
    address(v2493_range_3_to_0_address_term_bound_1) ).

fof(address_association_43,axiom,
    v2493_range_3_to_0_address_association(constB1,v2493_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_42,axiom,
    ! [B] :
      ( addressVal(v2493_range_3_to_0_address_term_bound_0,B)
    <=> v2493(constB0,B) ) ).

fof(is_address_58,axiom,
    address(v2493_range_3_to_0_address_term_bound_0) ).

fof(address_association_42,axiom,
    v2493_range_3_to_0_address_association(constB0,v2493_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_20,B)
    <=> v556(constB20,B) ) ).

fof(is_address_57,axiom,
    address(v556_range_3_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v556_range_3_to_0_address_association(constB20,v556_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_19,B)
    <=> v556(constB19,B) ) ).

fof(is_address_56,axiom,
    address(v556_range_3_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v556_range_3_to_0_address_association(constB19,v556_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_18,B)
    <=> v556(constB18,B) ) ).

fof(is_address_55,axiom,
    address(v556_range_3_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v556_range_3_to_0_address_association(constB18,v556_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_17,B)
    <=> v556(constB17,B) ) ).

fof(is_address_54,axiom,
    address(v556_range_3_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v556_range_3_to_0_address_association(constB17,v556_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_16,B)
    <=> v556(constB16,B) ) ).

fof(is_address_53,axiom,
    address(v556_range_3_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v556_range_3_to_0_address_association(constB16,v556_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_15,B)
    <=> v556(constB15,B) ) ).

fof(is_address_52,axiom,
    address(v556_range_3_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v556_range_3_to_0_address_association(constB15,v556_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_14,B)
    <=> v556(constB14,B) ) ).

fof(is_address_51,axiom,
    address(v556_range_3_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v556_range_3_to_0_address_association(constB14,v556_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_13,B)
    <=> v556(constB13,B) ) ).

fof(is_address_50,axiom,
    address(v556_range_3_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v556_range_3_to_0_address_association(constB13,v556_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_12,B)
    <=> v556(constB12,B) ) ).

fof(is_address_49,axiom,
    address(v556_range_3_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v556_range_3_to_0_address_association(constB12,v556_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_11,B)
    <=> v556(constB11,B) ) ).

fof(is_address_48,axiom,
    address(v556_range_3_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v556_range_3_to_0_address_association(constB11,v556_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_10,B)
    <=> v556(constB10,B) ) ).

fof(is_address_47,axiom,
    address(v556_range_3_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v556_range_3_to_0_address_association(constB10,v556_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_9,B)
    <=> v556(constB9,B) ) ).

fof(is_address_46,axiom,
    address(v556_range_3_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v556_range_3_to_0_address_association(constB9,v556_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_8,B)
    <=> v556(constB8,B) ) ).

fof(is_address_45,axiom,
    address(v556_range_3_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v556_range_3_to_0_address_association(constB8,v556_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_7,B)
    <=> v556(constB7,B) ) ).

fof(is_address_44,axiom,
    address(v556_range_3_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v556_range_3_to_0_address_association(constB7,v556_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_6,B)
    <=> v556(constB6,B) ) ).

fof(is_address_43,axiom,
    address(v556_range_3_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v556_range_3_to_0_address_association(constB6,v556_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_5,B)
    <=> v556(constB5,B) ) ).

fof(is_address_42,axiom,
    address(v556_range_3_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v556_range_3_to_0_address_association(constB5,v556_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_4,B)
    <=> v556(constB4,B) ) ).

fof(is_address_41,axiom,
    address(v556_range_3_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v556_range_3_to_0_address_association(constB4,v556_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_3,B)
    <=> v556(constB3,B) ) ).

fof(is_address_40,axiom,
    address(v556_range_3_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v556_range_3_to_0_address_association(constB3,v556_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_2,B)
    <=> v556(constB2,B) ) ).

fof(is_address_39,axiom,
    address(v556_range_3_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v556_range_3_to_0_address_association(constB2,v556_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_1,B)
    <=> v556(constB1,B) ) ).

fof(is_address_38,axiom,
    address(v556_range_3_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v556_range_3_to_0_address_association(constB1,v556_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v556_range_3_to_0_address_term_bound_0,B)
    <=> v556(constB0,B) ) ).

fof(is_address_37,axiom,
    address(v556_range_3_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v556_range_3_to_0_address_association(constB0,v556_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_20,B)
    <=> v528(constB20,B) ) ).

fof(is_address_36,axiom,
    address(v528_range_3_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v528_range_3_to_0_address_association(constB20,v528_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_19,B)
    <=> v528(constB19,B) ) ).

fof(is_address_35,axiom,
    address(v528_range_3_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v528_range_3_to_0_address_association(constB19,v528_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_18,B)
    <=> v528(constB18,B) ) ).

fof(is_address_34,axiom,
    address(v528_range_3_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v528_range_3_to_0_address_association(constB18,v528_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_17,B)
    <=> v528(constB17,B) ) ).

fof(is_address_33,axiom,
    address(v528_range_3_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v528_range_3_to_0_address_association(constB17,v528_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_16,B)
    <=> v528(constB16,B) ) ).

fof(is_address_32,axiom,
    address(v528_range_3_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v528_range_3_to_0_address_association(constB16,v528_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_15,B)
    <=> v528(constB15,B) ) ).

fof(is_address_31,axiom,
    address(v528_range_3_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v528_range_3_to_0_address_association(constB15,v528_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_14,B)
    <=> v528(constB14,B) ) ).

fof(is_address_30,axiom,
    address(v528_range_3_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v528_range_3_to_0_address_association(constB14,v528_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_13,B)
    <=> v528(constB13,B) ) ).

fof(is_address_29,axiom,
    address(v528_range_3_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v528_range_3_to_0_address_association(constB13,v528_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_12,B)
    <=> v528(constB12,B) ) ).

fof(is_address_28,axiom,
    address(v528_range_3_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v528_range_3_to_0_address_association(constB12,v528_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_11,B)
    <=> v528(constB11,B) ) ).

fof(is_address_27,axiom,
    address(v528_range_3_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v528_range_3_to_0_address_association(constB11,v528_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_10,B)
    <=> v528(constB10,B) ) ).

fof(is_address_26,axiom,
    address(v528_range_3_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v528_range_3_to_0_address_association(constB10,v528_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_9,B)
    <=> v528(constB9,B) ) ).

fof(is_address_25,axiom,
    address(v528_range_3_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v528_range_3_to_0_address_association(constB9,v528_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_8,B)
    <=> v528(constB8,B) ) ).

fof(is_address_24,axiom,
    address(v528_range_3_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v528_range_3_to_0_address_association(constB8,v528_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_7,B)
    <=> v528(constB7,B) ) ).

fof(is_address_23,axiom,
    address(v528_range_3_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v528_range_3_to_0_address_association(constB7,v528_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_6,B)
    <=> v528(constB6,B) ) ).

fof(is_address_22,axiom,
    address(v528_range_3_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v528_range_3_to_0_address_association(constB6,v528_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_5,B)
    <=> v528(constB5,B) ) ).

fof(is_address_21,axiom,
    address(v528_range_3_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v528_range_3_to_0_address_association(constB5,v528_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_4,B)
    <=> v528(constB4,B) ) ).

fof(is_address_20,axiom,
    address(v528_range_3_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v528_range_3_to_0_address_association(constB4,v528_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_3,B)
    <=> v528(constB3,B) ) ).

fof(is_address_19,axiom,
    address(v528_range_3_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v528_range_3_to_0_address_association(constB3,v528_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_2,B)
    <=> v528(constB2,B) ) ).

fof(is_address_18,axiom,
    address(v528_range_3_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v528_range_3_to_0_address_association(constB2,v528_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_1,B)
    <=> v528(constB1,B) ) ).

fof(is_address_17,axiom,
    address(v528_range_3_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v528_range_3_to_0_address_association(constB1,v528_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v528_range_3_to_0_address_term_bound_0,B)
    <=> v528(constB0,B) ) ).

fof(is_address_16,axiom,
    address(v528_range_3_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v528_range_3_to_0_address_association(constB0,v528_range_3_to_0_address_term_bound_0) ).

fof(is_address_15,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_15,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(is_address_14,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_14,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(is_address_13,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_13,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(is_address_12,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_12,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(is_address_11,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_11,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(is_address_10,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_10,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(is_address_9,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_9,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(is_address_8,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_8,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(is_address_7,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(is_address_6,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(is_address_5,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(is_address_4,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(is_address_3,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(is_address_2,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(is_address_1,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(is_address,axiom,
    address(b0000_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b0000_address_term,B)
    <=> b0000(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_495,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v7441(VarCurr) ) ).

fof(writeUnaryOperator_494,axiom,
    ! [VarCurr] :
      ( ~ v7441(VarCurr)
    <=> v7442(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1224,axiom,
    ! [VarCurr] :
      ( v7442(VarCurr)
    <=> ( v7444(VarCurr)
        & v7501(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_652,axiom,
    ! [VarCurr] :
      ( v7501(VarCurr)
    <=> ( v7502(VarCurr)
        | v6(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_651,axiom,
    ! [VarCurr] :
      ( v7502(VarCurr)
    <=> ( v7503(VarCurr)
        | v6(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_650,axiom,
    ! [VarCurr] :
      ( v7503(VarCurr)
    <=> ( v7504(VarCurr)
        | v6(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_649,axiom,
    ! [VarCurr] :
      ( v7504(VarCurr)
    <=> ( v7505(VarCurr)
        | v6(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_648,axiom,
    ! [VarCurr] :
      ( v7505(VarCurr)
    <=> ( v7506(VarCurr)
        | v6(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_647,axiom,
    ! [VarCurr] :
      ( v7506(VarCurr)
    <=> ( v7507(VarCurr)
        | v6(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_646,axiom,
    ! [VarCurr] :
      ( v7507(VarCurr)
    <=> ( v7508(VarCurr)
        | v6(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_645,axiom,
    ! [VarCurr] :
      ( v7508(VarCurr)
    <=> ( v7509(VarCurr)
        | v6(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_644,axiom,
    ! [VarCurr] :
      ( v7509(VarCurr)
    <=> ( v7510(VarCurr)
        | v6(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_643,axiom,
    ! [VarCurr] :
      ( v7510(VarCurr)
    <=> ( v7511(VarCurr)
        | v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_642,axiom,
    ! [VarCurr] :
      ( v7511(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1223,axiom,
    ! [VarCurr] :
      ( v7444(VarCurr)
    <=> ( v7445(VarCurr)
        | v7468(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1222,axiom,
    ! [VarCurr] :
      ( v7468(VarCurr)
    <=> ( v7469(VarCurr)
        | v7470(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1221,axiom,
    ! [VarCurr] :
      ( v7470(VarCurr)
    <=> ( v7446(VarCurr)
        & v7471(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1220,axiom,
    ! [VarCurr] :
      ( v7471(VarCurr)
    <=> ( v7472(VarCurr)
        | v7473(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1219,axiom,
    ! [VarCurr] :
      ( v7473(VarCurr)
    <=> ( v7448(VarCurr)
        & v7474(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1218,axiom,
    ! [VarCurr] :
      ( v7474(VarCurr)
    <=> ( v7475(VarCurr)
        | v7476(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1217,axiom,
    ! [VarCurr] :
      ( v7476(VarCurr)
    <=> ( v7450(VarCurr)
        & v7477(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1216,axiom,
    ! [VarCurr] :
      ( v7477(VarCurr)
    <=> ( v7478(VarCurr)
        | v7479(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1215,axiom,
    ! [VarCurr] :
      ( v7479(VarCurr)
    <=> ( v7452(VarCurr)
        & v7480(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1214,axiom,
    ! [VarCurr] :
      ( v7480(VarCurr)
    <=> ( v7481(VarCurr)
        | v7482(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1213,axiom,
    ! [VarCurr] :
      ( v7482(VarCurr)
    <=> ( v7454(VarCurr)
        & v7483(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1212,axiom,
    ! [VarCurr] :
      ( v7483(VarCurr)
    <=> ( v7484(VarCurr)
        | v7485(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1211,axiom,
    ! [VarCurr] :
      ( v7485(VarCurr)
    <=> ( v7456(VarCurr)
        & v7486(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1210,axiom,
    ! [VarCurr] :
      ( v7486(VarCurr)
    <=> ( v7487(VarCurr)
        | v7488(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1209,axiom,
    ! [VarCurr] :
      ( v7488(VarCurr)
    <=> ( v7458(VarCurr)
        & v7489(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1208,axiom,
    ! [VarCurr] :
      ( v7489(VarCurr)
    <=> ( v7490(VarCurr)
        | v7491(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1207,axiom,
    ! [VarCurr] :
      ( v7491(VarCurr)
    <=> ( v7460(VarCurr)
        & v7492(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1206,axiom,
    ! [VarCurr] :
      ( v7492(VarCurr)
    <=> ( v7493(VarCurr)
        | v7494(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1205,axiom,
    ! [VarCurr] :
      ( v7494(VarCurr)
    <=> ( v7462(VarCurr)
        & v7495(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1204,axiom,
    ! [VarCurr] :
      ( v7495(VarCurr)
    <=> ( v7496(VarCurr)
        | v7497(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1203,axiom,
    ! [VarCurr] :
      ( v7497(VarCurr)
    <=> ( v7464(VarCurr)
        & v7498(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1202,axiom,
    ! [VarCurr] :
      ( v7498(VarCurr)
    <=> ( v7499(VarCurr)
        | v7500(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1201,axiom,
    ! [VarCurr] :
      ( v7500(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v7467(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_641,axiom,
    ! [VarCurr] :
      ( v7499(VarCurr)
    <=> ( v7466(VarCurr)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_640,axiom,
    ! [VarCurr] :
      ( v7496(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        & v7465(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_639,axiom,
    ! [VarCurr] :
      ( v7493(VarCurr)
    <=> ( v6(VarCurr,bitIndex3)
        & v7463(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_638,axiom,
    ! [VarCurr] :
      ( v7490(VarCurr)
    <=> ( v6(VarCurr,bitIndex4)
        & v7461(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_637,axiom,
    ! [VarCurr] :
      ( v7487(VarCurr)
    <=> ( v6(VarCurr,bitIndex5)
        & v7459(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_636,axiom,
    ! [VarCurr] :
      ( v7484(VarCurr)
    <=> ( v6(VarCurr,bitIndex6)
        & v7457(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_635,axiom,
    ! [VarCurr] :
      ( v7481(VarCurr)
    <=> ( v6(VarCurr,bitIndex7)
        & v7455(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_634,axiom,
    ! [VarCurr] :
      ( v7478(VarCurr)
    <=> ( v6(VarCurr,bitIndex8)
        & v7453(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_633,axiom,
    ! [VarCurr] :
      ( v7475(VarCurr)
    <=> ( v6(VarCurr,bitIndex9)
        & v7451(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_632,axiom,
    ! [VarCurr] :
      ( v7472(VarCurr)
    <=> ( v6(VarCurr,bitIndex10)
        & v7449(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_631,axiom,
    ! [VarCurr] :
      ( v7469(VarCurr)
    <=> ( v6(VarCurr,bitIndex11)
        & v7447(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1200,axiom,
    ! [VarCurr] :
      ( v7445(VarCurr)
    <=> ( v7446(VarCurr)
        & v7447(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1199,axiom,
    ! [VarCurr] :
      ( v7447(VarCurr)
    <=> ( v7448(VarCurr)
        & v7449(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1198,axiom,
    ! [VarCurr] :
      ( v7449(VarCurr)
    <=> ( v7450(VarCurr)
        & v7451(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1197,axiom,
    ! [VarCurr] :
      ( v7451(VarCurr)
    <=> ( v7452(VarCurr)
        & v7453(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1196,axiom,
    ! [VarCurr] :
      ( v7453(VarCurr)
    <=> ( v7454(VarCurr)
        & v7455(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1195,axiom,
    ! [VarCurr] :
      ( v7455(VarCurr)
    <=> ( v7456(VarCurr)
        & v7457(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1194,axiom,
    ! [VarCurr] :
      ( v7457(VarCurr)
    <=> ( v7458(VarCurr)
        & v7459(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1193,axiom,
    ! [VarCurr] :
      ( v7459(VarCurr)
    <=> ( v7460(VarCurr)
        & v7461(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1192,axiom,
    ! [VarCurr] :
      ( v7461(VarCurr)
    <=> ( v7462(VarCurr)
        & v7463(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1191,axiom,
    ! [VarCurr] :
      ( v7463(VarCurr)
    <=> ( v7464(VarCurr)
        & v7465(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1190,axiom,
    ! [VarCurr] :
      ( v7465(VarCurr)
    <=> ( v7466(VarCurr)
        & v7467(VarCurr) ) ) ).

fof(writeUnaryOperator_493,axiom,
    ! [VarCurr] :
      ( ~ v7467(VarCurr)
    <=> v6(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_492,axiom,
    ! [VarCurr] :
      ( ~ v7466(VarCurr)
    <=> v6(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_491,axiom,
    ! [VarCurr] :
      ( ~ v7464(VarCurr)
    <=> v6(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_490,axiom,
    ! [VarCurr] :
      ( ~ v7462(VarCurr)
    <=> v6(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_489,axiom,
    ! [VarCurr] :
      ( ~ v7460(VarCurr)
    <=> v6(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_488,axiom,
    ! [VarCurr] :
      ( ~ v7458(VarCurr)
    <=> v6(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_487,axiom,
    ! [VarCurr] :
      ( ~ v7456(VarCurr)
    <=> v6(VarCurr,bitIndex6) ) ).

fof(writeUnaryOperator_486,axiom,
    ! [VarCurr] :
      ( ~ v7454(VarCurr)
    <=> v6(VarCurr,bitIndex7) ) ).

fof(writeUnaryOperator_485,axiom,
    ! [VarCurr] :
      ( ~ v7452(VarCurr)
    <=> v6(VarCurr,bitIndex8) ) ).

fof(writeUnaryOperator_484,axiom,
    ! [VarCurr] :
      ( ~ v7450(VarCurr)
    <=> v6(VarCurr,bitIndex9) ) ).

fof(writeUnaryOperator_483,axiom,
    ! [VarCurr] :
      ( ~ v7448(VarCurr)
    <=> v6(VarCurr,bitIndex10) ) ).

fof(writeUnaryOperator_482,axiom,
    ! [VarCurr] :
      ( ~ v7446(VarCurr)
    <=> v6(VarCurr,bitIndex11) ) ).

fof(addCaseBooleanConditionEqualRanges1_68,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7429(VarNext)
       => ! [B] :
            ( range_11_1(B)
           => ( v6(VarNext,B)
            <=> v6(VarCurr,B) ) ) ) ) ).

fof(range_axiom_41,axiom,
    ! [B] :
      ( range_11_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_1,axiom,
    ! [VarNext] :
      ( v7429(VarNext)
     => ( ( v6(VarNext,bitIndex11)
        <=> v7437(VarNext,bitIndex10) )
        & ( v6(VarNext,bitIndex10)
        <=> v7437(VarNext,bitIndex9) )
        & ( v6(VarNext,bitIndex9)
        <=> v7437(VarNext,bitIndex8) )
        & ( v6(VarNext,bitIndex8)
        <=> v7437(VarNext,bitIndex7) )
        & ( v6(VarNext,bitIndex7)
        <=> v7437(VarNext,bitIndex6) )
        & ( v6(VarNext,bitIndex6)
        <=> v7437(VarNext,bitIndex5) )
        & ( v6(VarNext,bitIndex5)
        <=> v7437(VarNext,bitIndex4) )
        & ( v6(VarNext,bitIndex4)
        <=> v7437(VarNext,bitIndex3) )
        & ( v6(VarNext,bitIndex3)
        <=> v7437(VarNext,bitIndex2) )
        & ( v6(VarNext,bitIndex2)
        <=> v7437(VarNext,bitIndex1) )
        & ( v6(VarNext,bitIndex1)
        <=> v7437(VarNext,bitIndex0) ) ) ) ).

fof(addAssignment_3506,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_10_0(B)
         => ( v7437(VarNext,B)
          <=> v7435(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_121,axiom,
    ! [VarCurr] :
      ( ~ v7424(VarCurr)
     => ( ( v7435(VarCurr,bitIndex10)
        <=> v19(VarCurr,bitIndex11) )
        & ( v7435(VarCurr,bitIndex9)
        <=> v19(VarCurr,bitIndex10) )
        & ( v7435(VarCurr,bitIndex8)
        <=> v19(VarCurr,bitIndex9) )
        & ( v7435(VarCurr,bitIndex7)
        <=> v19(VarCurr,bitIndex8) )
        & ( v7435(VarCurr,bitIndex6)
        <=> v19(VarCurr,bitIndex7) )
        & ( v7435(VarCurr,bitIndex5)
        <=> v19(VarCurr,bitIndex6) )
        & ( v7435(VarCurr,bitIndex4)
        <=> v19(VarCurr,bitIndex5) )
        & ( v7435(VarCurr,bitIndex3)
        <=> v19(VarCurr,bitIndex4) )
        & ( v7435(VarCurr,bitIndex2)
        <=> v19(VarCurr,bitIndex3) )
        & ( v7435(VarCurr,bitIndex1)
        <=> v19(VarCurr,bitIndex2) )
        & ( v7435(VarCurr,bitIndex0)
        <=> v19(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_291,axiom,
    ! [VarCurr] :
      ( v7424(VarCurr)
     => ! [B] :
          ( range_10_0(B)
         => ( v7435(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1189,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7429(VarNext)
      <=> v7430(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1188,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7430(VarNext)
      <=> ( v7432(VarNext)
          & v6339(VarNext) ) ) ) ).

fof(writeUnaryOperator_481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7432(VarNext)
      <=> v6346(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_67,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7415(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_74,axiom,
    ! [VarNext] :
      ( v7415(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v7423(VarNext) ) ) ).

fof(addAssignment_3505,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7423(VarNext)
      <=> v7421(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_287,axiom,
    ! [VarCurr] :
      ( ~ v7424(VarCurr)
     => ( v7421(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_290,axiom,
    ! [VarCurr] :
      ( v7424(VarCurr)
     => ( v7421(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_480,axiom,
    ! [VarCurr] :
      ( ~ v7424(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1187,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7415(VarNext)
      <=> v7416(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1186,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7416(VarNext)
      <=> ( v7417(VarNext)
          & v6339(VarNext) ) ) ) ).

fof(writeUnaryOperator_479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7417(VarNext)
      <=> v6346(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_286,axiom,
    ! [VarCurr] :
      ( ~ v7368(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_289,axiom,
    ! [VarCurr] :
      ( v7368(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1185,axiom,
    ! [VarCurr] :
      ( v7368(VarCurr)
    <=> ( v7369(VarCurr)
        | v7409(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1184,axiom,
    ! [VarCurr] :
      ( v7409(VarCurr)
    <=> ( v7410(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1183,axiom,
    ! [VarCurr] :
      ( v7410(VarCurr)
    <=> ( v7411(VarCurr)
        | v7412(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1182,axiom,
    ! [VarCurr] :
      ( v7412(VarCurr)
    <=> ( v5821(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(addAssignment_3504,axiom,
    ! [VarCurr] :
      ( v7411(VarCurr)
    <=> v7379(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1181,axiom,
    ! [VarCurr] :
      ( v7369(VarCurr)
    <=> ( v7370(VarCurr)
        | v7405(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1180,axiom,
    ! [VarCurr] :
      ( v7405(VarCurr)
    <=> ( v7406(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1179,axiom,
    ! [VarCurr] :
      ( v7406(VarCurr)
    <=> ( v7407(VarCurr)
        | v7408(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1178,axiom,
    ! [VarCurr] :
      ( v7408(VarCurr)
    <=> ( v5830(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1177,axiom,
    ! [VarCurr] :
      ( v7407(VarCurr)
    <=> ( v7379(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1176,axiom,
    ! [VarCurr] :
      ( v7370(VarCurr)
    <=> ( v7371(VarCurr)
        | v7399(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1175,axiom,
    ! [VarCurr] :
      ( v7399(VarCurr)
    <=> ( v7400(VarCurr)
        & v2927(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1174,axiom,
    ! [VarCurr] :
      ( v7400(VarCurr)
    <=> ( v7401(VarCurr)
        | v7404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1173,axiom,
    ! [VarCurr] :
      ( v7404(VarCurr)
    <=> ( v5821(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1172,axiom,
    ! [VarCurr] :
      ( v7401(VarCurr)
    <=> ( v7402(VarCurr)
        | v7403(VarCurr) ) ) ).

fof(addAssignment_3503,axiom,
    ! [VarCurr] :
      ( v7403(VarCurr)
    <=> v7379(VarCurr) ) ).

fof(addAssignment_3502,axiom,
    ! [VarCurr] :
      ( v7402(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1171,axiom,
    ! [VarCurr] :
      ( v7371(VarCurr)
    <=> ( v7372(VarCurr)
        | v7395(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1170,axiom,
    ! [VarCurr] :
      ( v7395(VarCurr)
    <=> ( v7396(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1169,axiom,
    ! [VarCurr] :
      ( v7396(VarCurr)
    <=> ( v7397(VarCurr)
        | v7398(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1168,axiom,
    ! [VarCurr] :
      ( v7398(VarCurr)
    <=> ( v5830(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1167,axiom,
    ! [VarCurr] :
      ( v7397(VarCurr)
    <=> ( v7379(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1166,axiom,
    ! [VarCurr] :
      ( v7372(VarCurr)
    <=> ( v7373(VarCurr)
        | v7389(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1165,axiom,
    ! [VarCurr] :
      ( v7389(VarCurr)
    <=> ( v7390(VarCurr)
        & v2924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1164,axiom,
    ! [VarCurr] :
      ( v7390(VarCurr)
    <=> ( v7391(VarCurr)
        | v7394(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1163,axiom,
    ! [VarCurr] :
      ( v7394(VarCurr)
    <=> ( v5821(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1162,axiom,
    ! [VarCurr] :
      ( v7391(VarCurr)
    <=> ( v7392(VarCurr)
        | v7393(VarCurr) ) ) ).

fof(addAssignment_3501,axiom,
    ! [VarCurr] :
      ( v7393(VarCurr)
    <=> v7379(VarCurr) ) ).

fof(addAssignment_3500,axiom,
    ! [VarCurr] :
      ( v7392(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1161,axiom,
    ! [VarCurr] :
      ( v7373(VarCurr)
    <=> ( v7374(VarCurr)
        | v7383(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1160,axiom,
    ! [VarCurr] :
      ( v7383(VarCurr)
    <=> ( v7384(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1159,axiom,
    ! [VarCurr] :
      ( v7384(VarCurr)
    <=> ( v7385(VarCurr)
        | v7387(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1158,axiom,
    ! [VarCurr] :
      ( v7387(VarCurr)
    <=> ( v5830(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1157,axiom,
    ! [VarCurr] :
      ( v7385(VarCurr)
    <=> ( v7379(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1156,axiom,
    ! [VarCurr] :
      ( v7379(VarCurr)
    <=> ( v7380(VarCurr)
        & v2919(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1155,axiom,
    ! [VarCurr] :
      ( v7374(VarCurr)
    <=> ( v7375(VarCurr)
        & v2921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1154,axiom,
    ! [VarCurr] :
      ( v7375(VarCurr)
    <=> ( v7376(VarCurr)
        | v7381(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1153,axiom,
    ! [VarCurr] :
      ( v7381(VarCurr)
    <=> ( v5821(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1152,axiom,
    ! [VarCurr] :
      ( v7376(VarCurr)
    <=> ( v7377(VarCurr)
        | v7378(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1151,axiom,
    ! [VarCurr] :
      ( v7378(VarCurr)
    <=> ( v7380(VarCurr)
        & v2919(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1150,axiom,
    ! [VarCurr] :
      ( v7380(VarCurr)
    <=> ( v5885(VarCurr)
        & v2918(VarCurr) ) ) ).

fof(addAssignment_3499,axiom,
    ! [VarCurr] :
      ( v7377(VarCurr)
    <=> v21(VarCurr) ) ).

fof(addAssignment_3498,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
    <=> v23(VarCurr) ) ).

fof(addAssignment_3497,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
    <=> v25(VarCurr) ) ).

fof(addAssignment_3496,axiom,
    ! [VarCurr] :
      ( v25(VarCurr)
    <=> v27(VarCurr) ) ).

fof(addAssignment_3495,axiom,
    ! [VarCurr] :
      ( v27(VarCurr)
    <=> v29(VarCurr) ) ).

fof(addAssignment_3494,axiom,
    ! [VarCurr] :
      ( v29(VarCurr)
    <=> v31(VarCurr) ) ).

fof(addAssignment_3493,axiom,
    ! [VarCurr] :
      ( v31(VarCurr)
    <=> v33(VarCurr) ) ).

fof(addAssignment_3492,axiom,
    ! [VarCurr] :
      ( v33(VarCurr)
    <=> v35(VarCurr) ) ).

fof(addAssignment_3491,axiom,
    ! [VarCurr] :
      ( v35(VarCurr)
    <=> v37(VarCurr) ) ).

fof(addAssignment_3490,axiom,
    ! [VarCurr] :
      ( v37(VarCurr)
    <=> v39(VarCurr,bitIndex2) ) ).

fof(addAssignment_3489,axiom,
    ! [VarNext] :
      ( v39(VarNext,bitIndex2)
    <=> v7356(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionEqualRanges1_66,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7357(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v7356(VarNext,B)
            <=> v39(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_73,axiom,
    ! [VarNext] :
      ( v7357(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v7356(VarNext,B)
          <=> v6419(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7357(VarNext)
      <=> v7358(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7358(VarNext)
      <=> ( v7360(VarNext)
          & v6400(VarNext) ) ) ) ).

fof(writeUnaryOperator_478,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7360(VarNext)
      <=> v6413(VarNext) ) ) ).

fof(addAssignment_3488,axiom,
    ! [VarCurr] :
      ( v50(VarCurr,bitIndex2)
    <=> v6385(VarCurr,bitIndex2) ) ).

fof(addAssignment_3487,axiom,
    ! [VarCurr] :
      ( v6384(VarCurr,bitIndex2)
    <=> v6423(VarCurr,bitIndex2) ) ).

fof(addAssignment_3486,axiom,
    ! [VarNext] :
      ( v39(VarNext,bitIndex3)
    <=> v7348(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_65,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7349(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v7348(VarNext,B)
            <=> v39(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_72,axiom,
    ! [VarNext] :
      ( v7349(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v7348(VarNext,B)
          <=> v6419(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7349(VarNext)
      <=> v7350(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7350(VarNext)
      <=> ( v7352(VarNext)
          & v6400(VarNext) ) ) ) ).

fof(writeUnaryOperator_477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7352(VarNext)
      <=> v6413(VarNext) ) ) ).

fof(addAssignment_3485,axiom,
    ! [VarCurr] :
      ( v50(VarCurr,bitIndex3)
    <=> v6385(VarCurr,bitIndex3) ) ).

fof(addAssignment_3484,axiom,
    ! [VarCurr] :
      ( v6384(VarCurr,bitIndex3)
    <=> v6423(VarCurr,bitIndex3) ) ).

fof(addAssignment_3483,axiom,
    ! [VarCurr] :
      ( v6365(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3482,axiom,
    ! [VarCurr] :
      ( v6367(VarCurr)
    <=> v6369(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_158,axiom,
    ! [VarCurr] :
      ( ( ~ v6959(VarCurr)
        & ~ v6968(VarCurr) )
     => ( v6369(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_212,axiom,
    ! [VarCurr] :
      ( v6968(VarCurr)
     => ( v6369(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_215,axiom,
    ! [VarCurr] :
      ( v6959(VarCurr)
     => ( v6369(VarCurr)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7334(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v6371(VarNext,B)
            <=> v6371(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_71,axiom,
    ! [VarNext] :
      ( v7334(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v6371(VarNext,B)
          <=> v7342(VarNext,B) ) ) ) ).

fof(addAssignment_3481,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v7342(VarNext,B)
          <=> v7340(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_285,axiom,
    ! [VarCurr] :
      ( ~ v7343(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v7340(VarCurr,B)
          <=> v6373(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_288,axiom,
    ! [VarCurr] :
      ( v7343(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v7340(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_762,axiom,
    ! [VarCurr] :
      ( v7343(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7334(VarNext)
      <=> v7335(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7335(VarNext)
      <=> ( v7336(VarNext)
          & v6404(VarNext) ) ) ) ).

fof(writeUnaryOperator_476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7336(VarNext)
      <=> v7308(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_157,axiom,
    ! [VarCurr] :
      ( ( ~ v7322(VarCurr)
        & ~ v7331(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v6373(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_211,axiom,
    ! [VarCurr] :
      ( v7331(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6373(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_214,axiom,
    ! [VarCurr] :
      ( v7322(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6373(VarCurr,B)
          <=> v7323(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_761,axiom,
    ! [VarCurr] :
      ( v7331(VarCurr)
    <=> ( ( v6371(VarCurr,bitIndex1)
        <=> $false )
        & ( v6371(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_210,axiom,
    ! [VarCurr] :
      ( ~ v7324(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v7323(VarCurr,B)
          <=> v7326(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_213,axiom,
    ! [VarCurr] :
      ( v7324(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v7323(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_209,axiom,
    ! [VarCurr] :
      ( ~ v7327(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v7326(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_212,axiom,
    ! [VarCurr] :
      ( v7327(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v7326(VarCurr,B)
          <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_760,axiom,
    ! [VarCurr] :
      ( v7329(VarCurr)
    <=> ( v7330(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1143,axiom,
    ! [VarCurr] :
      ( v7330(VarCurr)
    <=> ( v6785(VarCurr)
        | v6789(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_759,axiom,
    ! [VarCurr] :
      ( v7327(VarCurr)
    <=> ( v7328(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1142,axiom,
    ! [VarCurr] :
      ( v7328(VarCurr)
    <=> ( v6785(VarCurr)
        | v6789(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_758,axiom,
    ! [VarCurr] :
      ( v7325(VarCurr)
    <=> ( v6375(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_757,axiom,
    ! [VarCurr] :
      ( v7324(VarCurr)
    <=> ( v6375(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_756,axiom,
    ! [VarCurr] :
      ( v7322(VarCurr)
    <=> ( ( v6371(VarCurr,bitIndex1)
        <=> $false )
        & ( v6371(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7304(VarNext)
       => ( v6785(VarNext)
        <=> v6785(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_70,axiom,
    ! [VarNext] :
      ( v7304(VarNext)
     => ( v6785(VarNext)
      <=> v7314(VarNext) ) ) ).

fof(addAssignment_3480,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7314(VarNext)
      <=> v7312(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_284,axiom,
    ! [VarCurr] :
      ( ~ v7315(VarCurr)
     => ( v7312(VarCurr)
      <=> v7316(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_287,axiom,
    ! [VarCurr] :
      ( v7315(VarCurr)
     => ( v7312(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_283,axiom,
    ! [VarCurr] :
      ( ~ v6787(VarCurr)
     => ( v7316(VarCurr)
      <=> v7317(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_286,axiom,
    ! [VarCurr] :
      ( v6787(VarCurr)
     => ( v7316(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1141,axiom,
    ! [VarCurr] :
      ( v7317(VarCurr)
    <=> ( v7318(VarCurr)
        & v6785(VarCurr) ) ) ).

fof(writeUnaryOperator_475,axiom,
    ! [VarCurr] :
      ( ~ v7318(VarCurr)
    <=> v6970(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_755,axiom,
    ! [VarCurr] :
      ( v7315(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7304(VarNext)
      <=> v7305(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7305(VarNext)
      <=> ( v7306(VarNext)
          & v6404(VarNext) ) ) ) ).

fof(writeUnaryOperator_474,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v7306(VarNext)
      <=> v7308(VarNext) ) ) ).

fof(addAssignment_3479,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v7308(VarNext)
      <=> v6404(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_23,axiom,
    ! [VarCurr] :
      ( ( ~ v7263(VarCurr)
        & ~ v7264(VarCurr)
        & ~ v7298(VarCurr) )
     => ( v6970(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_156,axiom,
    ! [VarCurr] :
      ( v7298(VarCurr)
     => ( v6970(VarCurr)
      <=> v7299(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_208,axiom,
    ! [VarCurr] :
      ( v7264(VarCurr)
     => ( v6970(VarCurr)
      <=> v7265(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_211,axiom,
    ! [VarCurr] :
      ( v7263(VarCurr)
     => ( v6970(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_207,axiom,
    ! [VarCurr] :
      ( ~ v7300(VarCurr)
     => ( v7299(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_210,axiom,
    ! [VarCurr] :
      ( v7300(VarCurr)
     => ( v7299(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_754,axiom,
    ! [VarCurr] :
      ( v7301(VarCurr)
    <=> ( v6789(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_753,axiom,
    ! [VarCurr] :
      ( v7300(VarCurr)
    <=> ( v6789(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_752,axiom,
    ! [VarCurr] :
      ( v7298(VarCurr)
    <=> ( ( v6972(VarCurr,bitIndex2)
        <=> $false )
        & ( v6972(VarCurr,bitIndex1)
        <=> $true )
        & ( v6972(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_206,axiom,
    ! [VarCurr] :
      ( ~ v7266(VarCurr)
     => ( v7265(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_209,axiom,
    ! [VarCurr] :
      ( v7266(VarCurr)
     => ( v7265(VarCurr)
      <=> v7267(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_751,axiom,
    ! [VarCurr] :
      ( v7297(VarCurr)
    <=> ( v6789(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_22,axiom,
    ! [VarCurr] :
      ( ( ~ v7268(VarCurr)
        & ~ v7273(VarCurr)
        & ~ v7287(VarCurr) )
     => ( v7267(VarCurr)
      <=> v7291(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_155,axiom,
    ! [VarCurr] :
      ( v7287(VarCurr)
     => ( v7267(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_205,axiom,
    ! [VarCurr] :
      ( v7273(VarCurr)
     => ( v7267(VarCurr)
      <=> v7275(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_208,axiom,
    ! [VarCurr] :
      ( v7268(VarCurr)
     => ( v7267(VarCurr)
      <=> v7270(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_204,axiom,
    ! [VarCurr] :
      ( ~ v7292(VarCurr)
     => ( v7291(VarCurr)
      <=> v7294(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_207,axiom,
    ! [VarCurr] :
      ( v7292(VarCurr)
     => ( v7291(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_203,axiom,
    ! [VarCurr] :
      ( ~ v7295(VarCurr)
     => ( v7294(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_206,axiom,
    ! [VarCurr] :
      ( v7295(VarCurr)
     => ( v7294(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_750,axiom,
    ! [VarCurr] :
      ( v7296(VarCurr)
    <=> ( v7234(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_749,axiom,
    ! [VarCurr] :
      ( v7295(VarCurr)
    <=> ( v7234(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_748,axiom,
    ! [VarCurr] :
      ( v7293(VarCurr)
    <=> ( v7236(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_747,axiom,
    ! [VarCurr] :
      ( v7292(VarCurr)
    <=> ( v7236(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_746,axiom,
    ! [VarCurr] :
      ( v7289(VarCurr)
    <=> ( ( v7290(VarCurr,bitIndex1)
        <=> $true )
        & ( v7290(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3478,axiom,
    ! [VarCurr] :
      ( v7290(VarCurr,bitIndex0)
    <=> v6976(VarCurr) ) ).

fof(addAssignment_3477,axiom,
    ! [VarCurr] :
      ( v7290(VarCurr,bitIndex1)
    <=> v6974(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_745,axiom,
    ! [VarCurr] :
      ( v7287(VarCurr)
    <=> ( ( v7288(VarCurr,bitIndex1)
        <=> $true )
        & ( v7288(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3476,axiom,
    ! [VarCurr] :
      ( v7288(VarCurr,bitIndex0)
    <=> v6976(VarCurr) ) ).

fof(addAssignment_3475,axiom,
    ! [VarCurr] :
      ( v7288(VarCurr,bitIndex1)
    <=> v6974(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_202,axiom,
    ! [VarCurr] :
      ( ~ v7276(VarCurr)
     => ( v7275(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_205,axiom,
    ! [VarCurr] :
      ( v7276(VarCurr)
     => ( v7275(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1138,axiom,
    ! [VarCurr] :
      ( v7276(VarCurr)
    <=> ( v7277(VarCurr)
        | v7282(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1137,axiom,
    ! [VarCurr] :
      ( v7282(VarCurr)
    <=> ( v7283(VarCurr)
        | v7285(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_744,axiom,
    ! [VarCurr] :
      ( v7285(VarCurr)
    <=> ( ( v7286(VarCurr,bitIndex3)
        <=> $false )
        & ( v7286(VarCurr,bitIndex2)
        <=> $true )
        & ( v7286(VarCurr,bitIndex1)
        <=> $false )
        & ( v7286(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3474,axiom,
    ! [VarCurr] :
      ( v7286(VarCurr,bitIndex0)
    <=> v7238(VarCurr) ) ).

fof(addAssignment_3473,axiom,
    ! [VarCurr] :
      ( ( v7286(VarCurr,bitIndex3)
      <=> v6982(VarCurr,bitIndex2) )
      & ( v7286(VarCurr,bitIndex2)
      <=> v6982(VarCurr,bitIndex1) )
      & ( v7286(VarCurr,bitIndex1)
      <=> v6982(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_743,axiom,
    ! [VarCurr] :
      ( v7283(VarCurr)
    <=> ( ( v7284(VarCurr,bitIndex3)
        <=> $false )
        & ( v7284(VarCurr,bitIndex2)
        <=> $false )
        & ( v7284(VarCurr,bitIndex1)
        <=> $true )
        & ( v7284(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3472,axiom,
    ! [VarCurr] :
      ( v7284(VarCurr,bitIndex0)
    <=> v7238(VarCurr) ) ).

fof(addAssignment_3471,axiom,
    ! [VarCurr] :
      ( ( v7284(VarCurr,bitIndex3)
      <=> v6982(VarCurr,bitIndex2) )
      & ( v7284(VarCurr,bitIndex2)
      <=> v6982(VarCurr,bitIndex1) )
      & ( v7284(VarCurr,bitIndex1)
      <=> v6982(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1136,axiom,
    ! [VarCurr] :
      ( v7277(VarCurr)
    <=> ( v7278(VarCurr)
        | v7280(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_742,axiom,
    ! [VarCurr] :
      ( v7280(VarCurr)
    <=> ( ( v7281(VarCurr,bitIndex3)
        <=> $false )
        & ( v7281(VarCurr,bitIndex2)
        <=> $true )
        & ( v7281(VarCurr,bitIndex1)
        <=> $false )
        & ( v7281(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3470,axiom,
    ! [VarCurr] :
      ( v7281(VarCurr,bitIndex0)
    <=> v7238(VarCurr) ) ).

fof(addAssignment_3469,axiom,
    ! [VarCurr] :
      ( ( v7281(VarCurr,bitIndex3)
      <=> v6982(VarCurr,bitIndex2) )
      & ( v7281(VarCurr,bitIndex2)
      <=> v6982(VarCurr,bitIndex1) )
      & ( v7281(VarCurr,bitIndex1)
      <=> v6982(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_741,axiom,
    ! [VarCurr] :
      ( v7278(VarCurr)
    <=> ( ( v7279(VarCurr,bitIndex3)
        <=> $false )
        & ( v7279(VarCurr,bitIndex2)
        <=> $false )
        & ( v7279(VarCurr,bitIndex1)
        <=> $true )
        & ( v7279(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3468,axiom,
    ! [VarCurr] :
      ( v7279(VarCurr,bitIndex0)
    <=> v7238(VarCurr) ) ).

fof(addAssignment_3467,axiom,
    ! [VarCurr] :
      ( ( v7279(VarCurr,bitIndex3)
      <=> v6982(VarCurr,bitIndex2) )
      & ( v7279(VarCurr,bitIndex2)
      <=> v6982(VarCurr,bitIndex1) )
      & ( v7279(VarCurr,bitIndex1)
      <=> v6982(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_740,axiom,
    ! [VarCurr] :
      ( v7273(VarCurr)
    <=> ( ( v7274(VarCurr,bitIndex1)
        <=> $false )
        & ( v7274(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3466,axiom,
    ! [VarCurr] :
      ( v7274(VarCurr,bitIndex0)
    <=> v6976(VarCurr) ) ).

fof(addAssignment_3465,axiom,
    ! [VarCurr] :
      ( v7274(VarCurr,bitIndex1)
    <=> v6974(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_201,axiom,
    ! [VarCurr] :
      ( ~ v7271(VarCurr)
     => ( v7270(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_204,axiom,
    ! [VarCurr] :
      ( v7271(VarCurr)
     => ( v7270(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_739,axiom,
    ! [VarCurr] :
      ( v7272(VarCurr)
    <=> ( v7234(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_738,axiom,
    ! [VarCurr] :
      ( v7271(VarCurr)
    <=> ( v7234(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_737,axiom,
    ! [VarCurr] :
      ( v7268(VarCurr)
    <=> ( ( v7269(VarCurr,bitIndex1)
        <=> $false )
        & ( v7269(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3464,axiom,
    ! [VarCurr] :
      ( v7269(VarCurr,bitIndex0)
    <=> v6976(VarCurr) ) ).

fof(addAssignment_3463,axiom,
    ! [VarCurr] :
      ( v7269(VarCurr,bitIndex1)
    <=> v6974(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_736,axiom,
    ! [VarCurr] :
      ( v7266(VarCurr)
    <=> ( v6789(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_735,axiom,
    ! [VarCurr] :
      ( v7264(VarCurr)
    <=> ( ( v6972(VarCurr,bitIndex2)
        <=> $false )
        & ( v6972(VarCurr,bitIndex1)
        <=> $true )
        & ( v6972(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_734,axiom,
    ! [VarCurr] :
      ( v7263(VarCurr)
    <=> ( ( v6972(VarCurr,bitIndex2)
        <=> $false )
        & ( v6972(VarCurr,bitIndex1)
        <=> $false )
        & ( v6972(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_4,axiom,
    ! [VarCurr] :
      ( ( ~ v7078(VarCurr)
        & ~ v7079(VarCurr)
        & ~ v7083(VarCurr)
        & ~ v7084(VarCurr)
        & ~ v7094(VarCurr) )
     => ( v7234(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_6,axiom,
    ! [VarCurr] :
      ( v7094(VarCurr)
     => ( v7234(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_21,axiom,
    ! [VarCurr] :
      ( v7084(VarCurr)
     => ( v7234(VarCurr)
      <=> v7253(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_154,axiom,
    ! [VarCurr] :
      ( v7083(VarCurr)
     => ( v7234(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_200,axiom,
    ! [VarCurr] :
      ( v7079(VarCurr)
     => ( v7234(VarCurr)
      <=> v7249(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_203,axiom,
    ! [VarCurr] :
      ( v7078(VarCurr)
     => ( v7234(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_199,axiom,
    ! [VarCurr] :
      ( ~ v7086(VarCurr)
     => ( v7253(VarCurr)
      <=> v7261(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_202,axiom,
    ! [VarCurr] :
      ( v7086(VarCurr)
     => ( v7253(VarCurr)
      <=> v7254(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_198,axiom,
    ! [VarCurr] :
      ( ~ v7089(VarCurr)
     => ( v7261(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_201,axiom,
    ! [VarCurr] :
      ( v7089(VarCurr)
     => ( v7261(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_153,axiom,
    ! [VarCurr] :
      ( ( ~ v7228(VarCurr)
        & ~ v7230(VarCurr) )
     => ( v7254(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_197,axiom,
    ! [VarCurr] :
      ( v7230(VarCurr)
     => ( v7254(VarCurr)
      <=> v7258(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_200,axiom,
    ! [VarCurr] :
      ( v7228(VarCurr)
     => ( v7254(VarCurr)
      <=> v7255(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_196,axiom,
    ! [VarCurr] :
      ( ~ v7259(VarCurr)
     => ( v7258(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_199,axiom,
    ! [VarCurr] :
      ( v7259(VarCurr)
     => ( v7258(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_733,axiom,
    ! [VarCurr] :
      ( v7260(VarCurr)
    <=> ( v7240(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_732,axiom,
    ! [VarCurr] :
      ( v7259(VarCurr)
    <=> ( v7240(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_195,axiom,
    ! [VarCurr] :
      ( ~ v7256(VarCurr)
     => ( v7255(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_198,axiom,
    ! [VarCurr] :
      ( v7256(VarCurr)
     => ( v7255(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_731,axiom,
    ! [VarCurr] :
      ( v7257(VarCurr)
    <=> ( v7238(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_730,axiom,
    ! [VarCurr] :
      ( v7256(VarCurr)
    <=> ( v7238(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_194,axiom,
    ! [VarCurr] :
      ( ~ v7081(VarCurr)
     => ( v7249(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_197,axiom,
    ! [VarCurr] :
      ( v7081(VarCurr)
     => ( v7249(VarCurr)
      <=> v7250(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_193,axiom,
    ! [VarCurr] :
      ( ~ v7251(VarCurr)
     => ( v7250(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_196,axiom,
    ! [VarCurr] :
      ( v7251(VarCurr)
     => ( v7250(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_729,axiom,
    ! [VarCurr] :
      ( v7252(VarCurr)
    <=> ( v7236(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_728,axiom,
    ! [VarCurr] :
      ( v7251(VarCurr)
    <=> ( v7236(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_152,axiom,
    ! [VarCurr] :
      ( ( ~ v7244(VarCurr)
        & ~ v7247(VarCurr) )
     => ( v7240(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_192,axiom,
    ! [VarCurr] :
      ( v7247(VarCurr)
     => ( v7240(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_195,axiom,
    ! [VarCurr] :
      ( v7244(VarCurr)
     => ( v7240(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_727,axiom,
    ! [VarCurr] :
      ( v7247(VarCurr)
    <=> ( ( v7242(VarCurr,bitIndex1)
        <=> $true )
        & ( v7242(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1135,axiom,
    ! [VarCurr] :
      ( v7244(VarCurr)
    <=> ( v7245(VarCurr)
        | v7246(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_726,axiom,
    ! [VarCurr] :
      ( v7246(VarCurr)
    <=> ( ( v7242(VarCurr,bitIndex1)
        <=> $false )
        & ( v7242(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_725,axiom,
    ! [VarCurr] :
      ( v7245(VarCurr)
    <=> ( ( v7242(VarCurr,bitIndex1)
        <=> $false )
        & ( v7242(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_20,axiom,
    ! [VarCurr] :
      ( ( ~ v7223(VarCurr)
        & ~ v7084(VarCurr)
        & ~ v7094(VarCurr) )
     => ( v6976(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_151,axiom,
    ! [VarCurr] :
      ( v7094(VarCurr)
     => ( v6976(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_191,axiom,
    ! [VarCurr] :
      ( v7084(VarCurr)
     => ( v6976(VarCurr)
      <=> v7226(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_194,axiom,
    ! [VarCurr] :
      ( v7223(VarCurr)
     => ( v6976(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_190,axiom,
    ! [VarCurr] :
      ( ~ v7086(VarCurr)
     => ( v7226(VarCurr)
      <=> v7232(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_193,axiom,
    ! [VarCurr] :
      ( v7086(VarCurr)
     => ( v7226(VarCurr)
      <=> v7227(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_189,axiom,
    ! [VarCurr] :
      ( ~ v7089(VarCurr)
     => ( v7232(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_192,axiom,
    ! [VarCurr] :
      ( v7089(VarCurr)
     => ( v7232(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_150,axiom,
    ! [VarCurr] :
      ( ( ~ v7228(VarCurr)
        & ~ v7230(VarCurr) )
     => ( v7227(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_188,axiom,
    ! [VarCurr] :
      ( v7230(VarCurr)
     => ( v7227(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_191,axiom,
    ! [VarCurr] :
      ( v7228(VarCurr)
     => ( v7227(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_724,axiom,
    ! [VarCurr] :
      ( v7230(VarCurr)
    <=> ( ( v7231(VarCurr,bitIndex1)
        <=> $true )
        & ( v7231(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3462,axiom,
    ! [VarCurr] :
      ( v7231(VarCurr,bitIndex0)
    <=> v7217(VarCurr) ) ).

fof(addAssignment_3461,axiom,
    ! [VarCurr] :
      ( v7231(VarCurr,bitIndex1)
    <=> v6980(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_723,axiom,
    ! [VarCurr] :
      ( v7228(VarCurr)
    <=> ( ( v7229(VarCurr,bitIndex1)
        <=> $false )
        & ( v7229(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3460,axiom,
    ! [VarCurr] :
      ( v7229(VarCurr,bitIndex0)
    <=> v7217(VarCurr) ) ).

fof(addAssignment_3459,axiom,
    ! [VarCurr] :
      ( v7229(VarCurr,bitIndex1)
    <=> v6980(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1134,axiom,
    ! [VarCurr] :
      ( v7223(VarCurr)
    <=> ( v7225(VarCurr)
        | v7083(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1133,axiom,
    ! [VarCurr] :
      ( v7225(VarCurr)
    <=> ( v7078(VarCurr)
        | v7079(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_282,axiom,
    ! [VarCurr] :
      ( ~ v7107(VarCurr)
     => ( v7217(VarCurr)
      <=> v7219(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_285,axiom,
    ! [VarCurr] :
      ( v7107(VarCurr)
     => ( v7217(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_187,axiom,
    ! [VarCurr] :
      ( ~ v7109(VarCurr)
     => ( v7219(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_190,axiom,
    ! [VarCurr] :
      ( v7109(VarCurr)
     => ( v7219(VarCurr)
      <=> v7220(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_281,axiom,
    ! [VarCurr] :
      ( ~ v7115(VarCurr)
     => ( v7220(VarCurr)
      <=> v7221(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_284,axiom,
    ! [VarCurr] :
      ( v7115(VarCurr)
     => ( v7220(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_280,axiom,
    ! [VarCurr] :
      ( ~ v7117(VarCurr)
     => ( v7221(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_283,axiom,
    ! [VarCurr] :
      ( v7117(VarCurr)
     => ( v7221(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_279,axiom,
    ! [VarCurr] :
      ( ~ v7107(VarCurr)
     => ( v6980(VarCurr)
      <=> v7108(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_282,axiom,
    ! [VarCurr] :
      ( v7107(VarCurr)
     => ( v6980(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_186,axiom,
    ! [VarCurr] :
      ( ~ v7109(VarCurr)
     => ( v7108(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_189,axiom,
    ! [VarCurr] :
      ( v7109(VarCurr)
     => ( v7108(VarCurr)
      <=> v7114(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_278,axiom,
    ! [VarCurr] :
      ( ~ v7115(VarCurr)
     => ( v7114(VarCurr)
      <=> v7116(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_281,axiom,
    ! [VarCurr] :
      ( v7115(VarCurr)
     => ( v7114(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_277,axiom,
    ! [VarCurr] :
      ( ~ v7117(VarCurr)
     => ( v7116(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_280,axiom,
    ! [VarCurr] :
      ( v7117(VarCurr)
     => ( v7116(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1132,axiom,
    ! [VarCurr] :
      ( v7117(VarCurr)
    <=> ( v7118(VarCurr)
        & v7153(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_722,axiom,
    ! [VarCurr] :
      ( v7153(VarCurr)
    <=> ( v7154(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31_1,axiom,
    ! [VarCurr] :
      ( ( ~ v7184(VarCurr)
        & ~ v7185(VarCurr)
        & ~ v7186(VarCurr)
        & ~ v7187(VarCurr)
        & ~ v7188(VarCurr)
        & ~ v7189(VarCurr)
        & ~ v7190(VarCurr)
        & ~ v7191(VarCurr)
        & ~ v7192(VarCurr)
        & ~ v7193(VarCurr)
        & ~ v7194(VarCurr)
        & ~ v7195(VarCurr)
        & ~ v7196(VarCurr)
        & ~ v7197(VarCurr)
        & ~ v7198(VarCurr)
        & ~ v7199(VarCurr)
        & ~ v7200(VarCurr)
        & ~ v7201(VarCurr)
        & ~ v7202(VarCurr)
        & ~ v7203(VarCurr)
        & ~ v7204(VarCurr)
        & ~ v7205(VarCurr)
        & ~ v7206(VarCurr)
        & ~ v7207(VarCurr)
        & ~ v7208(VarCurr)
        & ~ v7209(VarCurr)
        & ~ v7210(VarCurr)
        & ~ v7211(VarCurr)
        & ~ v7212(VarCurr)
        & ~ v7213(VarCurr)
        & ~ v7214(VarCurr) )
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30_1,axiom,
    ! [VarCurr] :
      ( v7214(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29_1,axiom,
    ! [VarCurr] :
      ( v7213(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28_1,axiom,
    ! [VarCurr] :
      ( v7212(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27_1,axiom,
    ! [VarCurr] :
      ( v7211(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26_1,axiom,
    ! [VarCurr] :
      ( v7210(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25_1,axiom,
    ! [VarCurr] :
      ( v7209(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24_1,axiom,
    ! [VarCurr] :
      ( v7208(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23_1,axiom,
    ! [VarCurr] :
      ( v7207(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22_1,axiom,
    ! [VarCurr] :
      ( v7206(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21_1,axiom,
    ! [VarCurr] :
      ( v7205(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20_1,axiom,
    ! [VarCurr] :
      ( v7204(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19_1,axiom,
    ! [VarCurr] :
      ( v7203(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18_1,axiom,
    ! [VarCurr] :
      ( v7202(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17_1,axiom,
    ! [VarCurr] :
      ( v7201(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16_1,axiom,
    ! [VarCurr] :
      ( v7200(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15_1,axiom,
    ! [VarCurr] :
      ( v7199(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14_1,axiom,
    ! [VarCurr] :
      ( v7198(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13_1,axiom,
    ! [VarCurr] :
      ( v7197(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12_1,axiom,
    ! [VarCurr] :
      ( v7196(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11_1,axiom,
    ! [VarCurr] :
      ( v7195(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10_1,axiom,
    ! [VarCurr] :
      ( v7194(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9_1,axiom,
    ! [VarCurr] :
      ( v7193(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8_1,axiom,
    ! [VarCurr] :
      ( v7192(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7_1,axiom,
    ! [VarCurr] :
      ( v7191(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6_1,axiom,
    ! [VarCurr] :
      ( v7190(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5_1,axiom,
    ! [VarCurr] :
      ( v7189(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4_1,axiom,
    ! [VarCurr] :
      ( v7188(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3_1,axiom,
    ! [VarCurr] :
      ( v7187(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2_1,axiom,
    ! [VarCurr] :
      ( v7186(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_2,axiom,
    ! [VarCurr] :
      ( v7185(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_188,axiom,
    ! [VarCurr] :
      ( v7184(VarCurr)
     => ( v7154(VarCurr)
      <=> v6988(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_721,axiom,
    ! [VarCurr] :
      ( v7215(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_720,axiom,
    ! [VarCurr] :
      ( v7214(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_719,axiom,
    ! [VarCurr] :
      ( v7213(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_718,axiom,
    ! [VarCurr] :
      ( v7212(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_717,axiom,
    ! [VarCurr] :
      ( v7211(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_716,axiom,
    ! [VarCurr] :
      ( v7210(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_715,axiom,
    ! [VarCurr] :
      ( v7209(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_714,axiom,
    ! [VarCurr] :
      ( v7208(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_713,axiom,
    ! [VarCurr] :
      ( v7207(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_712,axiom,
    ! [VarCurr] :
      ( v7206(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_711,axiom,
    ! [VarCurr] :
      ( v7205(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_710,axiom,
    ! [VarCurr] :
      ( v7204(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_709,axiom,
    ! [VarCurr] :
      ( v7203(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_708,axiom,
    ! [VarCurr] :
      ( v7202(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_707,axiom,
    ! [VarCurr] :
      ( v7201(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_706,axiom,
    ! [VarCurr] :
      ( v7200(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $true )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_705,axiom,
    ! [VarCurr] :
      ( v7199(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_704,axiom,
    ! [VarCurr] :
      ( v7198(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_703,axiom,
    ! [VarCurr] :
      ( v7197(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_702,axiom,
    ! [VarCurr] :
      ( v7196(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_701,axiom,
    ! [VarCurr] :
      ( v7195(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_700,axiom,
    ! [VarCurr] :
      ( v7194(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_699,axiom,
    ! [VarCurr] :
      ( v7193(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_698,axiom,
    ! [VarCurr] :
      ( v7192(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $true )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_697,axiom,
    ! [VarCurr] :
      ( v7191(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_696,axiom,
    ! [VarCurr] :
      ( v7190(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_695,axiom,
    ! [VarCurr] :
      ( v7189(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_694,axiom,
    ! [VarCurr] :
      ( v7188(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $true )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_693,axiom,
    ! [VarCurr] :
      ( v7187(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_692,axiom,
    ! [VarCurr] :
      ( v7186(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $true )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_691,axiom,
    ! [VarCurr] :
      ( v7185(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_690,axiom,
    ! [VarCurr] :
      ( v7184(VarCurr)
    <=> ( ( v7156(VarCurr,bitIndex4)
        <=> $false )
        & ( v7156(VarCurr,bitIndex3)
        <=> $false )
        & ( v7156(VarCurr,bitIndex2)
        <=> $false )
        & ( v7156(VarCurr,bitIndex1)
        <=> $false )
        & ( v7156(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3458,axiom,
    ! [VarCurr] :
      ( v7156(VarCurr,bitIndex0)
    <=> v7182(VarCurr) ) ).

fof(addAssignment_3457,axiom,
    ! [VarCurr] :
      ( v7156(VarCurr,bitIndex1)
    <=> v7180(VarCurr) ) ).

fof(addAssignment_3456,axiom,
    ! [VarCurr] :
      ( v7156(VarCurr,bitIndex2)
    <=> v7176(VarCurr) ) ).

fof(addAssignment_3455,axiom,
    ! [VarCurr] :
      ( v7156(VarCurr,bitIndex3)
    <=> v7172(VarCurr) ) ).

fof(addAssignment_3454,axiom,
    ! [VarCurr] :
      ( v7156(VarCurr,bitIndex4)
    <=> v7158(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1131,axiom,
    ! [VarCurr] :
      ( v7180(VarCurr)
    <=> ( v7181(VarCurr)
        & v7183(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1130,axiom,
    ! [VarCurr] :
      ( v7183(VarCurr)
    <=> ( v6986(VarCurr,bitIndex0)
        | v7167(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_630,axiom,
    ! [VarCurr] :
      ( v7181(VarCurr)
    <=> ( v7182(VarCurr)
        | v6986(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_473,axiom,
    ! [VarCurr] :
      ( ~ v7182(VarCurr)
    <=> v6986(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1129,axiom,
    ! [VarCurr] :
      ( v7176(VarCurr)
    <=> ( v7177(VarCurr)
        & v7179(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1128,axiom,
    ! [VarCurr] :
      ( v7179(VarCurr)
    <=> ( v7165(VarCurr)
        | v7168(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_629,axiom,
    ! [VarCurr] :
      ( v7177(VarCurr)
    <=> ( v7178(VarCurr)
        | v6986(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_472,axiom,
    ! [VarCurr] :
      ( ~ v7178(VarCurr)
    <=> v7165(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1127,axiom,
    ! [VarCurr] :
      ( v7172(VarCurr)
    <=> ( v7173(VarCurr)
        & v7175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1126,axiom,
    ! [VarCurr] :
      ( v7175(VarCurr)
    <=> ( v7163(VarCurr)
        | v7169(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_628,axiom,
    ! [VarCurr] :
      ( v7173(VarCurr)
    <=> ( v7174(VarCurr)
        | v6986(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_471,axiom,
    ! [VarCurr] :
      ( ~ v7174(VarCurr)
    <=> v7163(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1125,axiom,
    ! [VarCurr] :
      ( v7158(VarCurr)
    <=> ( v7159(VarCurr)
        & v7170(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1124,axiom,
    ! [VarCurr] :
      ( v7170(VarCurr)
    <=> ( v7161(VarCurr)
        | v7171(VarCurr) ) ) ).

fof(writeUnaryOperator_470,axiom,
    ! [VarCurr] :
      ( ~ v7171(VarCurr)
    <=> v6986(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_627,axiom,
    ! [VarCurr] :
      ( v7159(VarCurr)
    <=> ( v7160(VarCurr)
        | v6986(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_469,axiom,
    ! [VarCurr] :
      ( ~ v7160(VarCurr)
    <=> v7161(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_626,axiom,
    ! [VarCurr] :
      ( v7161(VarCurr)
    <=> ( v6986(VarCurr,bitIndex3)
        | v7162(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1123,axiom,
    ! [VarCurr] :
      ( v7162(VarCurr)
    <=> ( v7163(VarCurr)
        & v7169(VarCurr) ) ) ).

fof(writeUnaryOperator_468,axiom,
    ! [VarCurr] :
      ( ~ v7169(VarCurr)
    <=> v6986(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_625,axiom,
    ! [VarCurr] :
      ( v7163(VarCurr)
    <=> ( v6986(VarCurr,bitIndex2)
        | v7164(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1122,axiom,
    ! [VarCurr] :
      ( v7164(VarCurr)
    <=> ( v7165(VarCurr)
        & v7168(VarCurr) ) ) ).

fof(writeUnaryOperator_467,axiom,
    ! [VarCurr] :
      ( ~ v7168(VarCurr)
    <=> v6986(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_624,axiom,
    ! [VarCurr] :
      ( v7165(VarCurr)
    <=> ( v6986(VarCurr,bitIndex1)
        | v7166(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1121,axiom,
    ! [VarCurr] :
      ( v7166(VarCurr)
    <=> ( v6986(VarCurr,bitIndex0)
        & v7167(VarCurr) ) ) ).

fof(writeUnaryOperator_466,axiom,
    ! [VarCurr] :
      ( ~ v7167(VarCurr)
    <=> v6986(VarCurr,bitIndex1) ) ).

fof(addBitVectorEqualityBitBlasted_689,axiom,
    ! [VarCurr] :
      ( v7118(VarCurr)
    <=> ( v7119(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges31,axiom,
    ! [VarCurr] :
      ( ( ~ v7121(VarCurr)
        & ~ v7122(VarCurr)
        & ~ v7123(VarCurr)
        & ~ v7124(VarCurr)
        & ~ v7125(VarCurr)
        & ~ v7126(VarCurr)
        & ~ v7127(VarCurr)
        & ~ v7128(VarCurr)
        & ~ v7129(VarCurr)
        & ~ v7130(VarCurr)
        & ~ v7131(VarCurr)
        & ~ v7132(VarCurr)
        & ~ v7133(VarCurr)
        & ~ v7134(VarCurr)
        & ~ v7135(VarCurr)
        & ~ v7136(VarCurr)
        & ~ v7137(VarCurr)
        & ~ v7138(VarCurr)
        & ~ v7139(VarCurr)
        & ~ v7140(VarCurr)
        & ~ v7141(VarCurr)
        & ~ v7142(VarCurr)
        & ~ v7143(VarCurr)
        & ~ v7144(VarCurr)
        & ~ v7145(VarCurr)
        & ~ v7146(VarCurr)
        & ~ v7147(VarCurr)
        & ~ v7148(VarCurr)
        & ~ v7149(VarCurr)
        & ~ v7150(VarCurr)
        & ~ v7151(VarCurr) )
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex31) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges30,axiom,
    ! [VarCurr] :
      ( v7151(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex30) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges29,axiom,
    ! [VarCurr] :
      ( v7150(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges28,axiom,
    ! [VarCurr] :
      ( v7149(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex28) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges27,axiom,
    ! [VarCurr] :
      ( v7148(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex27) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges26,axiom,
    ! [VarCurr] :
      ( v7147(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex26) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges25,axiom,
    ! [VarCurr] :
      ( v7146(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex25) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges24,axiom,
    ! [VarCurr] :
      ( v7145(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex24) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges23,axiom,
    ! [VarCurr] :
      ( v7144(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex23) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges22,axiom,
    ! [VarCurr] :
      ( v7143(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex22) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges21,axiom,
    ! [VarCurr] :
      ( v7142(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges20,axiom,
    ! [VarCurr] :
      ( v7141(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex20) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges19,axiom,
    ! [VarCurr] :
      ( v7140(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex19) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges18,axiom,
    ! [VarCurr] :
      ( v7139(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex18) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges17,axiom,
    ! [VarCurr] :
      ( v7138(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex17) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges16,axiom,
    ! [VarCurr] :
      ( v7137(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex16) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges15,axiom,
    ! [VarCurr] :
      ( v7136(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex15) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges14,axiom,
    ! [VarCurr] :
      ( v7135(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex14) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges13,axiom,
    ! [VarCurr] :
      ( v7134(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex13) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges12,axiom,
    ! [VarCurr] :
      ( v7133(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex12) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges11,axiom,
    ! [VarCurr] :
      ( v7132(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex11) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges10,axiom,
    ! [VarCurr] :
      ( v7131(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex10) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges9,axiom,
    ! [VarCurr] :
      ( v7130(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex9) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges8,axiom,
    ! [VarCurr] :
      ( v7129(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex8) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges7,axiom,
    ! [VarCurr] :
      ( v7128(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex7) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges6,axiom,
    ! [VarCurr] :
      ( v7127(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex6) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges5,axiom,
    ! [VarCurr] :
      ( v7126(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex5) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges4,axiom,
    ! [VarCurr] :
      ( v7125(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges3,axiom,
    ! [VarCurr] :
      ( v7124(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex3) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges2,axiom,
    ! [VarCurr] :
      ( v7123(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex2) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarCurr] :
      ( v7122(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex1) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_187,axiom,
    ! [VarCurr] :
      ( v7121(VarCurr)
     => ( v7119(VarCurr)
      <=> v6988(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_688,axiom,
    ! [VarCurr] :
      ( v7152(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_687,axiom,
    ! [VarCurr] :
      ( v7151(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_686,axiom,
    ! [VarCurr] :
      ( v7150(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_685,axiom,
    ! [VarCurr] :
      ( v7149(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_684,axiom,
    ! [VarCurr] :
      ( v7148(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_683,axiom,
    ! [VarCurr] :
      ( v7147(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_682,axiom,
    ! [VarCurr] :
      ( v7146(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_681,axiom,
    ! [VarCurr] :
      ( v7145(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_680,axiom,
    ! [VarCurr] :
      ( v7144(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_679,axiom,
    ! [VarCurr] :
      ( v7143(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_678,axiom,
    ! [VarCurr] :
      ( v7142(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_677,axiom,
    ! [VarCurr] :
      ( v7141(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_676,axiom,
    ! [VarCurr] :
      ( v7140(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_675,axiom,
    ! [VarCurr] :
      ( v7139(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_674,axiom,
    ! [VarCurr] :
      ( v7138(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_673,axiom,
    ! [VarCurr] :
      ( v7137(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $true )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_672,axiom,
    ! [VarCurr] :
      ( v7136(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_671,axiom,
    ! [VarCurr] :
      ( v7135(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_670,axiom,
    ! [VarCurr] :
      ( v7134(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_669,axiom,
    ! [VarCurr] :
      ( v7133(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_668,axiom,
    ! [VarCurr] :
      ( v7132(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_667,axiom,
    ! [VarCurr] :
      ( v7131(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_666,axiom,
    ! [VarCurr] :
      ( v7130(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_665,axiom,
    ! [VarCurr] :
      ( v7129(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $true )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_664,axiom,
    ! [VarCurr] :
      ( v7128(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_663,axiom,
    ! [VarCurr] :
      ( v7127(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_662,axiom,
    ! [VarCurr] :
      ( v7126(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_661,axiom,
    ! [VarCurr] :
      ( v7125(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $true )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_660,axiom,
    ! [VarCurr] :
      ( v7124(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_659,axiom,
    ! [VarCurr] :
      ( v7123(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $true )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_658,axiom,
    ! [VarCurr] :
      ( v7122(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_657,axiom,
    ! [VarCurr] :
      ( v7121(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_656,axiom,
    ! [VarCurr] :
      ( v7115(VarCurr)
    <=> ( ( v6986(VarCurr,bitIndex4)
        <=> $false )
        & ( v6986(VarCurr,bitIndex3)
        <=> $false )
        & ( v6986(VarCurr,bitIndex2)
        <=> $false )
        & ( v6986(VarCurr,bitIndex1)
        <=> $false )
        & ( v6986(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1120,axiom,
    ! [VarCurr] :
      ( v7109(VarCurr)
    <=> ( v7110(VarCurr)
        | v7112(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_655,axiom,
    ! [VarCurr] :
      ( v7112(VarCurr)
    <=> ( ( v7113(VarCurr,bitIndex3)
        <=> $false )
        & ( v7113(VarCurr,bitIndex2)
        <=> $true )
        & ( v7113(VarCurr,bitIndex1)
        <=> $false )
        & ( v7113(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3453,axiom,
    ! [VarCurr] :
      ( v7113(VarCurr,bitIndex0)
    <=> v6984(VarCurr) ) ).

fof(addAssignment_3452,axiom,
    ! [VarCurr] :
      ( ( v7113(VarCurr,bitIndex3)
      <=> v6982(VarCurr,bitIndex2) )
      & ( v7113(VarCurr,bitIndex2)
      <=> v6982(VarCurr,bitIndex1) )
      & ( v7113(VarCurr,bitIndex1)
      <=> v6982(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_654,axiom,
    ! [VarCurr] :
      ( v7110(VarCurr)
    <=> ( ( v7111(VarCurr,bitIndex3)
        <=> $false )
        & ( v7111(VarCurr,bitIndex2)
        <=> $false )
        & ( v7111(VarCurr,bitIndex1)
        <=> $true )
        & ( v7111(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3451,axiom,
    ! [VarCurr] :
      ( v7111(VarCurr,bitIndex0)
    <=> v6984(VarCurr) ) ).

fof(addAssignment_3450,axiom,
    ! [VarCurr] :
      ( ( v7111(VarCurr,bitIndex3)
      <=> v6982(VarCurr,bitIndex2) )
      & ( v7111(VarCurr,bitIndex2)
      <=> v6982(VarCurr,bitIndex1) )
      & ( v7111(VarCurr,bitIndex1)
      <=> v6982(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_653,axiom,
    ! [VarCurr] :
      ( v7107(VarCurr)
    <=> ( v45(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_3449,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex31)
    <=> v6990(VarCurr,bitIndex31) ) ).

fof(addAssignment_3448,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex31)
    <=> v6992(VarCurr,bitIndex31) ) ).

fof(addAssignment_3447,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex31)
    <=> v6994(VarCurr,bitIndex31) ) ).

fof(addAssignment_3446,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex31)
    <=> v6996(VarCurr,bitIndex31) ) ).

fof(addAssignment_3445,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex31)
    <=> v7105(VarCurr,bitIndex31) ) ).

fof(addAssignment_3444,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex30)
    <=> v6990(VarCurr,bitIndex30) ) ).

fof(addAssignment_3443,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex30)
    <=> v6992(VarCurr,bitIndex30) ) ).

fof(addAssignment_3442,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex30)
    <=> v6994(VarCurr,bitIndex30) ) ).

fof(addAssignment_3441,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex30)
    <=> v6996(VarCurr,bitIndex30) ) ).

fof(addAssignment_3440,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex30)
    <=> v7105(VarCurr,bitIndex30) ) ).

fof(addAssignment_3439,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex29)
    <=> v6990(VarCurr,bitIndex29) ) ).

fof(addAssignment_3438,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex29)
    <=> v6992(VarCurr,bitIndex29) ) ).

fof(addAssignment_3437,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex29)
    <=> v6994(VarCurr,bitIndex29) ) ).

fof(addAssignment_3436,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex29)
    <=> v6996(VarCurr,bitIndex29) ) ).

fof(addAssignment_3435,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex29)
    <=> v7105(VarCurr,bitIndex29) ) ).

fof(addAssignment_3434,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex28)
    <=> v6990(VarCurr,bitIndex28) ) ).

fof(addAssignment_3433,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex28)
    <=> v6992(VarCurr,bitIndex28) ) ).

fof(addAssignment_3432,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex28)
    <=> v6994(VarCurr,bitIndex28) ) ).

fof(addAssignment_3431,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex28)
    <=> v6996(VarCurr,bitIndex28) ) ).

fof(addAssignment_3430,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex28)
    <=> v7105(VarCurr,bitIndex28) ) ).

fof(addAssignment_3429,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex27)
    <=> v6990(VarCurr,bitIndex27) ) ).

fof(addAssignment_3428,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex27)
    <=> v6992(VarCurr,bitIndex27) ) ).

fof(addAssignment_3427,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex27)
    <=> v6994(VarCurr,bitIndex27) ) ).

fof(addAssignment_3426,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex27)
    <=> v6996(VarCurr,bitIndex27) ) ).

fof(addAssignment_3425,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex27)
    <=> v7105(VarCurr,bitIndex27) ) ).

fof(addAssignment_3424,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex26)
    <=> v6990(VarCurr,bitIndex26) ) ).

fof(addAssignment_3423,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex26)
    <=> v6992(VarCurr,bitIndex26) ) ).

fof(addAssignment_3422,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex26)
    <=> v6994(VarCurr,bitIndex26) ) ).

fof(addAssignment_3421,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex26)
    <=> v6996(VarCurr,bitIndex26) ) ).

fof(addAssignment_3420,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex26)
    <=> v7105(VarCurr,bitIndex26) ) ).

fof(addAssignment_3419,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex25)
    <=> v6990(VarCurr,bitIndex25) ) ).

fof(addAssignment_3418,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex25)
    <=> v6992(VarCurr,bitIndex25) ) ).

fof(addAssignment_3417,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex25)
    <=> v6994(VarCurr,bitIndex25) ) ).

fof(addAssignment_3416,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex25)
    <=> v6996(VarCurr,bitIndex25) ) ).

fof(addAssignment_3415,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex25)
    <=> v7105(VarCurr,bitIndex25) ) ).

fof(addAssignment_3414,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex24)
    <=> v6990(VarCurr,bitIndex24) ) ).

fof(addAssignment_3413,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex24)
    <=> v6992(VarCurr,bitIndex24) ) ).

fof(addAssignment_3412,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex24)
    <=> v6994(VarCurr,bitIndex24) ) ).

fof(addAssignment_3411,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex24)
    <=> v6996(VarCurr,bitIndex24) ) ).

fof(addAssignment_3410,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex24)
    <=> v7105(VarCurr,bitIndex24) ) ).

fof(addAssignment_3409,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex23)
    <=> v6990(VarCurr,bitIndex23) ) ).

fof(addAssignment_3408,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex23)
    <=> v6992(VarCurr,bitIndex23) ) ).

fof(addAssignment_3407,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex23)
    <=> v6994(VarCurr,bitIndex23) ) ).

fof(addAssignment_3406,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex23)
    <=> v6996(VarCurr,bitIndex23) ) ).

fof(addAssignment_3405,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex23)
    <=> v7105(VarCurr,bitIndex23) ) ).

fof(addAssignment_3404,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex22)
    <=> v6990(VarCurr,bitIndex22) ) ).

fof(addAssignment_3403,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex22)
    <=> v6992(VarCurr,bitIndex22) ) ).

fof(addAssignment_3402,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex22)
    <=> v6994(VarCurr,bitIndex22) ) ).

fof(addAssignment_3401,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex22)
    <=> v6996(VarCurr,bitIndex22) ) ).

fof(addAssignment_3400,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex22)
    <=> v7105(VarCurr,bitIndex22) ) ).

fof(addAssignment_3399,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex21)
    <=> v6990(VarCurr,bitIndex21) ) ).

fof(addAssignment_3398,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex21)
    <=> v6992(VarCurr,bitIndex21) ) ).

fof(addAssignment_3397,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex21)
    <=> v6994(VarCurr,bitIndex21) ) ).

fof(addAssignment_3396,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex21)
    <=> v6996(VarCurr,bitIndex21) ) ).

fof(addAssignment_3395,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex21)
    <=> v7105(VarCurr,bitIndex21) ) ).

fof(addAssignment_3394,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex20)
    <=> v6990(VarCurr,bitIndex20) ) ).

fof(addAssignment_3393,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex20)
    <=> v6992(VarCurr,bitIndex20) ) ).

fof(addAssignment_3392,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex20)
    <=> v6994(VarCurr,bitIndex20) ) ).

fof(addAssignment_3391,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex20)
    <=> v6996(VarCurr,bitIndex20) ) ).

fof(addAssignment_3390,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex20)
    <=> v7105(VarCurr,bitIndex20) ) ).

fof(addAssignment_3389,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex19)
    <=> v6990(VarCurr,bitIndex19) ) ).

fof(addAssignment_3388,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex19)
    <=> v6992(VarCurr,bitIndex19) ) ).

fof(addAssignment_3387,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex19)
    <=> v6994(VarCurr,bitIndex19) ) ).

fof(addAssignment_3386,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex19)
    <=> v6996(VarCurr,bitIndex19) ) ).

fof(addAssignment_3385,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex19)
    <=> v7105(VarCurr,bitIndex19) ) ).

fof(addAssignment_3384,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex18)
    <=> v6990(VarCurr,bitIndex18) ) ).

fof(addAssignment_3383,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex18)
    <=> v6992(VarCurr,bitIndex18) ) ).

fof(addAssignment_3382,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex18)
    <=> v6994(VarCurr,bitIndex18) ) ).

fof(addAssignment_3381,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex18)
    <=> v6996(VarCurr,bitIndex18) ) ).

fof(addAssignment_3380,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex18)
    <=> v7105(VarCurr,bitIndex18) ) ).

fof(addAssignment_3379,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex17)
    <=> v6990(VarCurr,bitIndex17) ) ).

fof(addAssignment_3378,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex17)
    <=> v6992(VarCurr,bitIndex17) ) ).

fof(addAssignment_3377,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex17)
    <=> v6994(VarCurr,bitIndex17) ) ).

fof(addAssignment_3376,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex17)
    <=> v6996(VarCurr,bitIndex17) ) ).

fof(addAssignment_3375,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex17)
    <=> v7105(VarCurr,bitIndex17) ) ).

fof(addAssignment_3374,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex16)
    <=> v6990(VarCurr,bitIndex16) ) ).

fof(addAssignment_3373,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex16)
    <=> v6992(VarCurr,bitIndex16) ) ).

fof(addAssignment_3372,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex16)
    <=> v6994(VarCurr,bitIndex16) ) ).

fof(addAssignment_3371,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex16)
    <=> v6996(VarCurr,bitIndex16) ) ).

fof(addAssignment_3370,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex16)
    <=> v7105(VarCurr,bitIndex16) ) ).

fof(addAssignment_3369,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex15)
    <=> v6990(VarCurr,bitIndex15) ) ).

fof(addAssignment_3368,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex15)
    <=> v6992(VarCurr,bitIndex15) ) ).

fof(addAssignment_3367,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex15)
    <=> v6994(VarCurr,bitIndex15) ) ).

fof(addAssignment_3366,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex15)
    <=> v6996(VarCurr,bitIndex15) ) ).

fof(addAssignment_3365,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex15)
    <=> v7105(VarCurr,bitIndex15) ) ).

fof(addAssignment_3364,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex14)
    <=> v6990(VarCurr,bitIndex14) ) ).

fof(addAssignment_3363,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex14)
    <=> v6992(VarCurr,bitIndex14) ) ).

fof(addAssignment_3362,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex14)
    <=> v6994(VarCurr,bitIndex14) ) ).

fof(addAssignment_3361,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex14)
    <=> v6996(VarCurr,bitIndex14) ) ).

fof(addAssignment_3360,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex14)
    <=> v7105(VarCurr,bitIndex14) ) ).

fof(addAssignment_3359,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex13)
    <=> v6990(VarCurr,bitIndex13) ) ).

fof(addAssignment_3358,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex13)
    <=> v6992(VarCurr,bitIndex13) ) ).

fof(addAssignment_3357,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex13)
    <=> v6994(VarCurr,bitIndex13) ) ).

fof(addAssignment_3356,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex13)
    <=> v6996(VarCurr,bitIndex13) ) ).

fof(addAssignment_3355,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex13)
    <=> v7105(VarCurr,bitIndex13) ) ).

fof(addAssignment_3354,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex12)
    <=> v6990(VarCurr,bitIndex12) ) ).

fof(addAssignment_3353,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex12)
    <=> v6992(VarCurr,bitIndex12) ) ).

fof(addAssignment_3352,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex12)
    <=> v6994(VarCurr,bitIndex12) ) ).

fof(addAssignment_3351,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex12)
    <=> v6996(VarCurr,bitIndex12) ) ).

fof(addAssignment_3350,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex12)
    <=> v7105(VarCurr,bitIndex12) ) ).

fof(addAssignment_3349,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex11)
    <=> v6990(VarCurr,bitIndex11) ) ).

fof(addAssignment_3348,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex11)
    <=> v6992(VarCurr,bitIndex11) ) ).

fof(addAssignment_3347,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex11)
    <=> v6994(VarCurr,bitIndex11) ) ).

fof(addAssignment_3346,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex11)
    <=> v6996(VarCurr,bitIndex11) ) ).

fof(addAssignment_3345,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex11)
    <=> v7105(VarCurr,bitIndex11) ) ).

fof(addAssignment_3344,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex10)
    <=> v6990(VarCurr,bitIndex10) ) ).

fof(addAssignment_3343,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex10)
    <=> v6992(VarCurr,bitIndex10) ) ).

fof(addAssignment_3342,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex10)
    <=> v6994(VarCurr,bitIndex10) ) ).

fof(addAssignment_3341,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex10)
    <=> v6996(VarCurr,bitIndex10) ) ).

fof(addAssignment_3340,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex10)
    <=> v7105(VarCurr,bitIndex10) ) ).

fof(addAssignment_3339,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex9)
    <=> v6990(VarCurr,bitIndex9) ) ).

fof(addAssignment_3338,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex9)
    <=> v6992(VarCurr,bitIndex9) ) ).

fof(addAssignment_3337,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex9)
    <=> v6994(VarCurr,bitIndex9) ) ).

fof(addAssignment_3336,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex9)
    <=> v6996(VarCurr,bitIndex9) ) ).

fof(addAssignment_3335,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex9)
    <=> v7105(VarCurr,bitIndex9) ) ).

fof(addAssignment_3334,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex8)
    <=> v6990(VarCurr,bitIndex8) ) ).

fof(addAssignment_3333,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex8)
    <=> v6992(VarCurr,bitIndex8) ) ).

fof(addAssignment_3332,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex8)
    <=> v6994(VarCurr,bitIndex8) ) ).

fof(addAssignment_3331,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex8)
    <=> v6996(VarCurr,bitIndex8) ) ).

fof(addAssignment_3330,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex8)
    <=> v7105(VarCurr,bitIndex8) ) ).

fof(addAssignment_3329,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex7)
    <=> v6990(VarCurr,bitIndex7) ) ).

fof(addAssignment_3328,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex7)
    <=> v6992(VarCurr,bitIndex7) ) ).

fof(addAssignment_3327,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex7)
    <=> v6994(VarCurr,bitIndex7) ) ).

fof(addAssignment_3326,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex7)
    <=> v6996(VarCurr,bitIndex7) ) ).

fof(addAssignment_3325,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex7)
    <=> v7105(VarCurr,bitIndex7) ) ).

fof(addAssignment_3324,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex6)
    <=> v6990(VarCurr,bitIndex6) ) ).

fof(addAssignment_3323,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex6)
    <=> v6992(VarCurr,bitIndex6) ) ).

fof(addAssignment_3322,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex6)
    <=> v6994(VarCurr,bitIndex6) ) ).

fof(addAssignment_3321,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex6)
    <=> v6996(VarCurr,bitIndex6) ) ).

fof(addAssignment_3320,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex6)
    <=> v7105(VarCurr,bitIndex6) ) ).

fof(addAssignment_3319,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex5)
    <=> v6990(VarCurr,bitIndex5) ) ).

fof(addAssignment_3318,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex5)
    <=> v6992(VarCurr,bitIndex5) ) ).

fof(addAssignment_3317,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex5)
    <=> v6994(VarCurr,bitIndex5) ) ).

fof(addAssignment_3316,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex5)
    <=> v6996(VarCurr,bitIndex5) ) ).

fof(addAssignment_3315,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex5)
    <=> v7105(VarCurr,bitIndex5) ) ).

fof(addAssignment_3314,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex4)
    <=> v6990(VarCurr,bitIndex4) ) ).

fof(addAssignment_3313,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex4)
    <=> v6992(VarCurr,bitIndex4) ) ).

fof(addAssignment_3312,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex4)
    <=> v6994(VarCurr,bitIndex4) ) ).

fof(addAssignment_3311,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex4)
    <=> v6996(VarCurr,bitIndex4) ) ).

fof(addAssignment_3310,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex4)
    <=> v7105(VarCurr,bitIndex4) ) ).

fof(addAssignment_3309,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex3)
    <=> v6990(VarCurr,bitIndex3) ) ).

fof(addAssignment_3308,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex3)
    <=> v6992(VarCurr,bitIndex3) ) ).

fof(addAssignment_3307,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex3)
    <=> v6994(VarCurr,bitIndex3) ) ).

fof(addAssignment_3306,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex3)
    <=> v6996(VarCurr,bitIndex3) ) ).

fof(addAssignment_3305,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex3)
    <=> v7105(VarCurr,bitIndex3) ) ).

fof(addAssignment_3304,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex2)
    <=> v6990(VarCurr,bitIndex2) ) ).

fof(addAssignment_3303,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex2)
    <=> v6992(VarCurr,bitIndex2) ) ).

fof(addAssignment_3302,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex2)
    <=> v6994(VarCurr,bitIndex2) ) ).

fof(addAssignment_3301,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex2)
    <=> v6996(VarCurr,bitIndex2) ) ).

fof(addAssignment_3300,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex2)
    <=> v7105(VarCurr,bitIndex2) ) ).

fof(addAssignment_3299,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex1)
    <=> v6990(VarCurr,bitIndex1) ) ).

fof(addAssignment_3298,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex1)
    <=> v6992(VarCurr,bitIndex1) ) ).

fof(addAssignment_3297,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex1)
    <=> v6994(VarCurr,bitIndex1) ) ).

fof(addAssignment_3296,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex1)
    <=> v6996(VarCurr,bitIndex1) ) ).

fof(addAssignment_3295,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex1)
    <=> v7105(VarCurr,bitIndex1) ) ).

fof(addAssignment_3294,axiom,
    ! [VarCurr] :
      ( v6988(VarCurr,bitIndex0)
    <=> v6990(VarCurr,bitIndex0) ) ).

fof(addAssignment_3293,axiom,
    ! [VarCurr] :
      ( v6990(VarCurr,bitIndex0)
    <=> v6992(VarCurr,bitIndex0) ) ).

fof(addAssignment_3292,axiom,
    ! [VarCurr] :
      ( v6992(VarCurr,bitIndex0)
    <=> v6994(VarCurr,bitIndex0) ) ).

fof(addAssignment_3291,axiom,
    ! [VarCurr] :
      ( v6994(VarCurr,bitIndex0)
    <=> v6996(VarCurr,bitIndex0) ) ).

fof(addAssignment_3290,axiom,
    ! [VarCurr] :
      ( v6996(VarCurr,bitIndex0)
    <=> v7105(VarCurr,bitIndex0) ) ).

fof(addAssignment_3289,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v7000(VarCurr,B)
      <=> v7002(VarCurr,B) ) ) ).

fof(addAssignment_3288,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v7002(VarCurr,B)
      <=> v7004(VarCurr,B) ) ) ).

fof(addAssignment_3287,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v7004(VarCurr,B)
      <=> v7006(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_276,axiom,
    ! [VarCurr] :
      ( ~ v7100(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v7006(VarCurr,B)
          <=> v7098(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_279,axiom,
    ! [VarCurr] :
      ( v7100(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v7006(VarCurr,B)
          <=> v7096(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1119,axiom,
    ! [VarCurr] :
      ( v7100(VarCurr)
    <=> ( v7101(VarCurr)
        & v7075(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1118,axiom,
    ! [VarCurr] :
      ( v7101(VarCurr)
    <=> ( v7008(VarCurr)
        & v7102(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1117,axiom,
    ! [VarCurr] :
      ( v7102(VarCurr)
    <=> ( v7103(VarCurr)
        | v7104(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_652,axiom,
    ! [VarCurr] :
      ( v7104(VarCurr)
    <=> ( ( v6982(VarCurr,bitIndex2)
        <=> $false )
        & ( v6982(VarCurr,bitIndex1)
        <=> $true )
        & ( v6982(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_651,axiom,
    ! [VarCurr] :
      ( v7103(VarCurr)
    <=> ( ( v6982(VarCurr,bitIndex2)
        <=> $false )
        & ( v6982(VarCurr,bitIndex1)
        <=> $false )
        & ( v6982(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_3,axiom,
    ! [VarCurr] :
      ( ( ~ v7078(VarCurr)
        & ~ v7079(VarCurr)
        & ~ v7083(VarCurr)
        & ~ v7084(VarCurr)
        & ~ v7094(VarCurr) )
     => ( v7008(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_5,axiom,
    ! [VarCurr] :
      ( v7094(VarCurr)
     => ( v7008(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_19,axiom,
    ! [VarCurr] :
      ( v7084(VarCurr)
     => ( v7008(VarCurr)
      <=> v7085(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_149,axiom,
    ! [VarCurr] :
      ( v7083(VarCurr)
     => ( v7008(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_185,axiom,
    ! [VarCurr] :
      ( v7079(VarCurr)
     => ( v7008(VarCurr)
      <=> v7080(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_186,axiom,
    ! [VarCurr] :
      ( v7078(VarCurr)
     => ( v7008(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_650,axiom,
    ! [VarCurr] :
      ( v7094(VarCurr)
    <=> ( ( v6978(VarCurr,bitIndex2)
        <=> $true )
        & ( v6978(VarCurr,bitIndex1)
        <=> $false )
        & ( v6978(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_184,axiom,
    ! [VarCurr] :
      ( ~ v7086(VarCurr)
     => ( v7085(VarCurr)
      <=> v7088(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_185,axiom,
    ! [VarCurr] :
      ( v7086(VarCurr)
     => ( v7085(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_183,axiom,
    ! [VarCurr] :
      ( ~ v7089(VarCurr)
     => ( v7088(VarCurr)
      <=> v7091(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_184,axiom,
    ! [VarCurr] :
      ( v7089(VarCurr)
     => ( v7088(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_182,axiom,
    ! [VarCurr] :
      ( ~ v7092(VarCurr)
     => ( v7091(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_183,axiom,
    ! [VarCurr] :
      ( v7092(VarCurr)
     => ( v7091(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_649,axiom,
    ! [VarCurr] :
      ( v7093(VarCurr)
    <=> ( v7012(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_648,axiom,
    ! [VarCurr] :
      ( v7092(VarCurr)
    <=> ( v7012(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_647,axiom,
    ! [VarCurr] :
      ( v7090(VarCurr)
    <=> ( v7010(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_646,axiom,
    ! [VarCurr] :
      ( v7089(VarCurr)
    <=> ( v7010(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_645,axiom,
    ! [VarCurr] :
      ( v7087(VarCurr)
    <=> ( v6974(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_644,axiom,
    ! [VarCurr] :
      ( v7086(VarCurr)
    <=> ( v6974(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_643,axiom,
    ! [VarCurr] :
      ( v7084(VarCurr)
    <=> ( ( v6978(VarCurr,bitIndex2)
        <=> $false )
        & ( v6978(VarCurr,bitIndex1)
        <=> $true )
        & ( v6978(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_642,axiom,
    ! [VarCurr] :
      ( v7083(VarCurr)
    <=> ( ( v6978(VarCurr,bitIndex2)
        <=> $false )
        & ( v6978(VarCurr,bitIndex1)
        <=> $true )
        & ( v6978(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_181,axiom,
    ! [VarCurr] :
      ( ~ v7081(VarCurr)
     => ( v7080(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_182,axiom,
    ! [VarCurr] :
      ( v7081(VarCurr)
     => ( v7080(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_641,axiom,
    ! [VarCurr] :
      ( v7082(VarCurr)
    <=> ( v6974(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_640,axiom,
    ! [VarCurr] :
      ( v7081(VarCurr)
    <=> ( v6974(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_639,axiom,
    ! [VarCurr] :
      ( v7079(VarCurr)
    <=> ( ( v6978(VarCurr,bitIndex2)
        <=> $false )
        & ( v6978(VarCurr,bitIndex1)
        <=> $false )
        & ( v6978(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_638,axiom,
    ! [VarCurr] :
      ( v7078(VarCurr)
    <=> ( ( v6978(VarCurr,bitIndex2)
        <=> $false )
        & ( v6978(VarCurr,bitIndex1)
        <=> $false )
        & ( v6978(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1116,axiom,
    ! [VarCurr] :
      ( v7012(VarCurr)
    <=> ( v7014(VarCurr)
        | v7075(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_148,axiom,
    ! [VarCurr] :
      ( ( ~ v6959(VarCurr)
        & ~ v6968(VarCurr) )
     => ( v7014(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_180,axiom,
    ! [VarCurr] :
      ( v6968(VarCurr)
     => ( v7014(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_181,axiom,
    ! [VarCurr] :
      ( v6959(VarCurr)
     => ( v7014(VarCurr)
      <=> v7063(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_179,axiom,
    ! [VarCurr] :
      ( ~ v6961(VarCurr)
     => ( v7063(VarCurr)
      <=> v7064(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_180,axiom,
    ! [VarCurr] :
      ( v6961(VarCurr)
     => ( v7063(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_178,axiom,
    ! [VarCurr] :
      ( ~ v6964(VarCurr)
     => ( v7064(VarCurr)
      <=> v7065(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_179,axiom,
    ! [VarCurr] :
      ( v6964(VarCurr)
     => ( v7064(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_147,axiom,
    ! [VarCurr] :
      ( ( ~ v7066(VarCurr)
        & ~ v7071(VarCurr) )
     => ( v7065(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_177,axiom,
    ! [VarCurr] :
      ( v7071(VarCurr)
     => ( v7065(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_178,axiom,
    ! [VarCurr] :
      ( v7066(VarCurr)
     => ( v7065(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1115,axiom,
    ! [VarCurr] :
      ( v7071(VarCurr)
    <=> ( v7072(VarCurr)
        | v7073(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_637,axiom,
    ! [VarCurr] :
      ( v7073(VarCurr)
    <=> ( ( v7016(VarCurr,bitIndex2)
        <=> $false )
        & ( v7016(VarCurr,bitIndex1)
        <=> $true )
        & ( v7016(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_636,axiom,
    ! [VarCurr] :
      ( v7072(VarCurr)
    <=> ( ( v7016(VarCurr,bitIndex2)
        <=> $false )
        & ( v7016(VarCurr,bitIndex1)
        <=> $false )
        & ( v7016(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1114,axiom,
    ! [VarCurr] :
      ( v7066(VarCurr)
    <=> ( v7067(VarCurr)
        | v7070(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_635,axiom,
    ! [VarCurr] :
      ( v7070(VarCurr)
    <=> ( ( v7016(VarCurr,bitIndex2)
        <=> $true )
        & ( v7016(VarCurr,bitIndex1)
        <=> $false )
        & ( v7016(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1113,axiom,
    ! [VarCurr] :
      ( v7067(VarCurr)
    <=> ( v7068(VarCurr)
        | v7069(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_634,axiom,
    ! [VarCurr] :
      ( v7069(VarCurr)
    <=> ( ( v7016(VarCurr,bitIndex2)
        <=> $false )
        & ( v7016(VarCurr,bitIndex1)
        <=> $true )
        & ( v7016(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_633,axiom,
    ! [VarCurr] :
      ( v7068(VarCurr)
    <=> ( ( v7016(VarCurr,bitIndex2)
        <=> $true )
        & ( v7016(VarCurr,bitIndex1)
        <=> $false )
        & ( v7016(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_4,axiom,
    ! [VarCurr] :
      ( ( ~ v7036(VarCurr)
        & ~ v7055(VarCurr)
        & ~ v7056(VarCurr)
        & ~ v7061(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v7016(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_18,axiom,
    ! [VarCurr] :
      ( v7061(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v7016(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_146,axiom,
    ! [VarCurr] :
      ( v7056(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v7016(VarCurr,B)
          <=> v7059(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_176,axiom,
    ! [VarCurr] :
      ( v7055(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v7016(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_177,axiom,
    ! [VarCurr] :
      ( v7036(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v7016(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_632,axiom,
    ! [VarCurr] :
      ( v7061(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $true )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $true )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_175,axiom,
    ! [VarCurr] :
      ( ~ v7060(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v7059(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_176,axiom,
    ! [VarCurr] :
      ( v7060(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v7059(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_631,axiom,
    ! [VarCurr] :
      ( v7060(VarCurr)
    <=> ( ( v7026(VarCurr,bitIndex2)
        <=> $false )
        & ( v7026(VarCurr,bitIndex1)
        <=> $false )
        & ( v7026(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1112,axiom,
    ! [VarCurr] :
      ( v7056(VarCurr)
    <=> ( v7057(VarCurr)
        | v7058(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_630,axiom,
    ! [VarCurr] :
      ( v7058(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $true )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $true )
        & ( v7018(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_629,axiom,
    ! [VarCurr] :
      ( v7057(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $true )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $true )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_628,axiom,
    ! [VarCurr] :
      ( v7055(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $true )
        & ( v7018(VarCurr,bitIndex4)
        <=> $true )
        & ( v7018(VarCurr,bitIndex3)
        <=> $true )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $true )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1111,axiom,
    ! [VarCurr] :
      ( v7036(VarCurr)
    <=> ( v7037(VarCurr)
        | v7054(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_627,axiom,
    ! [VarCurr] :
      ( v7054(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $true )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1110,axiom,
    ! [VarCurr] :
      ( v7037(VarCurr)
    <=> ( v7038(VarCurr)
        | v7053(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_626,axiom,
    ! [VarCurr] :
      ( v7053(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $true )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1109,axiom,
    ! [VarCurr] :
      ( v7038(VarCurr)
    <=> ( v7039(VarCurr)
        | v7052(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_625,axiom,
    ! [VarCurr] :
      ( v7052(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $true )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1108,axiom,
    ! [VarCurr] :
      ( v7039(VarCurr)
    <=> ( v7040(VarCurr)
        | v7051(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_624,axiom,
    ! [VarCurr] :
      ( v7051(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $true )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1107,axiom,
    ! [VarCurr] :
      ( v7040(VarCurr)
    <=> ( v7041(VarCurr)
        | v7050(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_623,axiom,
    ! [VarCurr] :
      ( v7050(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $true )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1106,axiom,
    ! [VarCurr] :
      ( v7041(VarCurr)
    <=> ( v7042(VarCurr)
        | v7049(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_622,axiom,
    ! [VarCurr] :
      ( v7049(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $true )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1105,axiom,
    ! [VarCurr] :
      ( v7042(VarCurr)
    <=> ( v7043(VarCurr)
        | v7048(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_621,axiom,
    ! [VarCurr] :
      ( v7048(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $true )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1104,axiom,
    ! [VarCurr] :
      ( v7043(VarCurr)
    <=> ( v7044(VarCurr)
        | v7047(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_620,axiom,
    ! [VarCurr] :
      ( v7047(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $true )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1103,axiom,
    ! [VarCurr] :
      ( v7044(VarCurr)
    <=> ( v7045(VarCurr)
        | v7046(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_619,axiom,
    ! [VarCurr] :
      ( v7046(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $true )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_618,axiom,
    ! [VarCurr] :
      ( v7045(VarCurr)
    <=> ( ( v7018(VarCurr,bitIndex6)
        <=> $false )
        & ( v7018(VarCurr,bitIndex5)
        <=> $false )
        & ( v7018(VarCurr,bitIndex4)
        <=> $false )
        & ( v7018(VarCurr,bitIndex3)
        <=> $false )
        & ( v7018(VarCurr,bitIndex2)
        <=> $false )
        & ( v7018(VarCurr,bitIndex1)
        <=> $false )
        & ( v7018(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3286,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v7026(VarCurr,B)
      <=> v7028(VarCurr,B) ) ) ).

fof(addAssignment_3285,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v7028(VarCurr,B)
      <=> v7030(VarCurr,B) ) ) ).

fof(addAssignment_3284,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v7030(VarCurr,B)
      <=> v7032(VarCurr,B) ) ) ).

fof(addAssignment_3283,axiom,
    ! [VarCurr] :
      ( ( v7032(VarCurr,bitIndex2)
      <=> v7034(VarCurr,bitIndex26) )
      & ( v7032(VarCurr,bitIndex1)
      <=> v7034(VarCurr,bitIndex25) )
      & ( v7032(VarCurr,bitIndex0)
      <=> v7034(VarCurr,bitIndex24) ) ) ).

fof(addAssignment_3282,axiom,
    ! [VarCurr,B] :
      ( range_6_0(B)
     => ( v7018(VarCurr,B)
      <=> v7020(VarCurr,B) ) ) ).

fof(addAssignment_3281,axiom,
    ! [VarCurr,B] :
      ( range_6_0(B)
     => ( v7020(VarCurr,B)
      <=> v7022(VarCurr,B) ) ) ).

fof(addAssignment_3280,axiom,
    ! [VarCurr] :
      ( ( v7022(VarCurr,bitIndex6)
      <=> v7024(VarCurr,bitIndex27) )
      & ( v7022(VarCurr,bitIndex5)
      <=> v7024(VarCurr,bitIndex26) )
      & ( v7022(VarCurr,bitIndex4)
      <=> v7024(VarCurr,bitIndex25) )
      & ( v7022(VarCurr,bitIndex3)
      <=> v7024(VarCurr,bitIndex24) )
      & ( v7022(VarCurr,bitIndex2)
      <=> v7024(VarCurr,bitIndex23) )
      & ( v7022(VarCurr,bitIndex1)
      <=> v7024(VarCurr,bitIndex22) )
      & ( v7022(VarCurr,bitIndex0)
      <=> v7024(VarCurr,bitIndex21) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_145,axiom,
    ! [VarCurr] :
      ( ( ~ v6959(VarCurr)
        & ~ v6968(VarCurr) )
     => ( v6787(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_174,axiom,
    ! [VarCurr] :
      ( v6968(VarCurr)
     => ( v6787(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_175,axiom,
    ! [VarCurr] :
      ( v6959(VarCurr)
     => ( v6787(VarCurr)
      <=> v6960(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_617,axiom,
    ! [VarCurr] :
      ( v6968(VarCurr)
    <=> ( ( v6371(VarCurr,bitIndex1)
        <=> $false )
        & ( v6371(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_173,axiom,
    ! [VarCurr] :
      ( ~ v6961(VarCurr)
     => ( v6960(VarCurr)
      <=> v6963(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_174,axiom,
    ! [VarCurr] :
      ( v6961(VarCurr)
     => ( v6960(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_172,axiom,
    ! [VarCurr] :
      ( ~ v6964(VarCurr)
     => ( v6963(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_173,axiom,
    ! [VarCurr] :
      ( v6964(VarCurr)
     => ( v6963(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_616,axiom,
    ! [VarCurr] :
      ( v6966(VarCurr)
    <=> ( v6967(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1102,axiom,
    ! [VarCurr] :
      ( v6967(VarCurr)
    <=> ( v6785(VarCurr)
        | v6789(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_615,axiom,
    ! [VarCurr] :
      ( v6964(VarCurr)
    <=> ( v6965(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1101,axiom,
    ! [VarCurr] :
      ( v6965(VarCurr)
    <=> ( v6785(VarCurr)
        | v6789(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_56,axiom,
    ( v6785(constB0)
  <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_614,axiom,
    ! [VarCurr] :
      ( v6962(VarCurr)
    <=> ( v6375(VarCurr)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_613,axiom,
    ! [VarCurr] :
      ( v6961(VarCurr)
    <=> ( v6375(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_612,axiom,
    ! [VarCurr] :
      ( v6959(VarCurr)
    <=> ( ( v6371(VarCurr,bitIndex1)
        <=> $false )
        & ( v6371(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_55,axiom,
    ! [B] :
      ( range_1_0(B)
     => ( v6371(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_3279,axiom,
    ! [VarCurr] :
      ( v6789(VarCurr)
    <=> v6791(VarCurr) ) ).

fof(addAssignment_3278,axiom,
    ! [VarCurr] :
      ( v6791(VarCurr)
    <=> v6793(VarCurr) ) ).

fof(addAssignment_3277,axiom,
    ! [VarCurr] :
      ( v6793(VarCurr)
    <=> v6795(VarCurr) ) ).

fof(addAssignment_3276,axiom,
    ! [VarCurr] :
      ( v6795(VarCurr)
    <=> v6797(VarCurr) ) ).

fof(addAssignment_3275,axiom,
    ! [VarCurr] :
      ( v6797(VarCurr)
    <=> v6799(VarCurr) ) ).

fof(addAssignment_3274,axiom,
    ! [VarCurr] :
      ( v6799(VarCurr)
    <=> v6801(VarCurr) ) ).

fof(addAssignment_3273,axiom,
    ! [VarCurr] :
      ( v6801(VarCurr)
    <=> v6803(VarCurr,bitIndex6) ) ).

fof(addAssignment_3272,axiom,
    ! [VarNext] :
      ( v6803(VarNext,bitIndex6)
    <=> v6943(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionEqualRanges1_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6944(VarNext)
       => ! [B] :
            ( range_7_0(B)
           => ( v6943(VarNext,B)
            <=> v6803(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_69,axiom,
    ! [VarNext] :
      ( v6944(VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v6943(VarNext,B)
          <=> v6954(VarNext,B) ) ) ) ).

fof(addAssignment_3271,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_7_0(B)
         => ( v6954(VarNext,B)
          <=> v6952(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_275,axiom,
    ! [VarCurr] :
      ( ~ v6955(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6952(VarCurr,B)
          <=> v6809(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_278,axiom,
    ! [VarCurr] :
      ( v6955(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6952(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_465,axiom,
    ! [VarCurr] :
      ( ~ v6955(VarCurr)
    <=> v6805(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6944(VarNext)
      <=> v6945(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1099,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6945(VarNext)
      <=> ( v6946(VarNext)
          & v6939(VarNext) ) ) ) ).

fof(writeUnaryOperator_464,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6946(VarNext)
      <=> v6948(VarNext) ) ) ).

fof(addAssignment_3270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6948(VarNext)
      <=> v6939(VarCurr) ) ) ).

fof(addAssignment_3269,axiom,
    ! [VarCurr] :
      ( v6939(VarCurr)
    <=> v6941(VarCurr) ) ).

fof(addAssignment_3268,axiom,
    ! [VarCurr] :
      ( v6941(VarCurr)
    <=> v2190(VarCurr) ) ).

fof(addAssignment_3267,axiom,
    ! [VarCurr] :
      ( v6809(VarCurr,bitIndex6)
    <=> v6924(VarCurr,bitIndex6) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_274,axiom,
    ! [VarCurr] :
      ( ~ v6925(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6924(VarCurr,B)
          <=> v6926(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_277,axiom,
    ! [VarCurr] :
      ( v6925(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6924(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_17,axiom,
    ! [VarCurr] :
      ( ( ~ v6927(VarCurr)
        & ~ v6929(VarCurr)
        & ~ v6933(VarCurr) )
     => ! [B] :
          ( range_7_0(B)
         => ( v6926(VarCurr,B)
          <=> v6803(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_144,axiom,
    ! [VarCurr] :
      ( v6933(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6926(VarCurr,B)
          <=> v6935(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_171,axiom,
    ! [VarCurr] :
      ( v6929(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6926(VarCurr,B)
          <=> v6931(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_172,axiom,
    ! [VarCurr] :
      ( v6927(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v6926(VarCurr,B)
          <=> v6803(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_611,axiom,
    ! [VarCurr] :
      ( v6936(VarCurr)
    <=> ( ( v6937(VarCurr,bitIndex1)
        <=> $true )
        & ( v6937(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3266,axiom,
    ! [VarCurr] :
      ( v6937(VarCurr,bitIndex0)
    <=> v6825(VarCurr) ) ).

fof(addAssignment_3265,axiom,
    ! [VarCurr] :
      ( v6937(VarCurr,bitIndex1)
    <=> v6811(VarCurr) ) ).

fof(addAssignment_3264,axiom,
    ! [VarCurr] :
      ( v6935(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3263,axiom,
    ! [VarCurr,B] :
      ( range_7_1(B)
     => ( v6935(VarCurr,B)
      <=> v6919(VarCurr,B) ) ) ).

fof(range_axiom_40,axiom,
    ! [B] :
      ( range_7_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_610,axiom,
    ! [VarCurr] :
      ( v6933(VarCurr)
    <=> ( ( v6934(VarCurr,bitIndex1)
        <=> $true )
        & ( v6934(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3262,axiom,
    ! [VarCurr] :
      ( v6934(VarCurr,bitIndex0)
    <=> v6825(VarCurr) ) ).

fof(addAssignment_3261,axiom,
    ! [VarCurr] :
      ( v6934(VarCurr,bitIndex1)
    <=> v6811(VarCurr) ) ).

fof(addAssignment_3260,axiom,
    ! [VarCurr] :
      ( ( v6931(VarCurr,bitIndex6)
      <=> v6803(VarCurr,bitIndex7) )
      & ( v6931(VarCurr,bitIndex5)
      <=> v6803(VarCurr,bitIndex6) )
      & ( v6931(VarCurr,bitIndex4)
      <=> v6803(VarCurr,bitIndex5) )
      & ( v6931(VarCurr,bitIndex3)
      <=> v6803(VarCurr,bitIndex4) )
      & ( v6931(VarCurr,bitIndex2)
      <=> v6803(VarCurr,bitIndex3) )
      & ( v6931(VarCurr,bitIndex1)
      <=> v6803(VarCurr,bitIndex2) )
      & ( v6931(VarCurr,bitIndex0)
      <=> v6803(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_3259,axiom,
    ! [VarCurr] :
      ( v6931(VarCurr,bitIndex7)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_609,axiom,
    ! [VarCurr] :
      ( v6929(VarCurr)
    <=> ( ( v6930(VarCurr,bitIndex1)
        <=> $false )
        & ( v6930(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3258,axiom,
    ! [VarCurr] :
      ( v6930(VarCurr,bitIndex0)
    <=> v6825(VarCurr) ) ).

fof(addAssignment_3257,axiom,
    ! [VarCurr] :
      ( v6930(VarCurr,bitIndex1)
    <=> v6811(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_608,axiom,
    ! [VarCurr] :
      ( v6927(VarCurr)
    <=> ( ( v6928(VarCurr,bitIndex1)
        <=> $false )
        & ( v6928(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3256,axiom,
    ! [VarCurr] :
      ( v6928(VarCurr,bitIndex0)
    <=> v6825(VarCurr) ) ).

fof(addAssignment_3255,axiom,
    ! [VarCurr] :
      ( v6928(VarCurr,bitIndex1)
    <=> v6811(VarCurr) ) ).

fof(writeUnaryOperator_463,axiom,
    ! [VarCurr] :
      ( ~ v6925(VarCurr)
    <=> v6805(VarCurr) ) ).

fof(addAssignment_3254,axiom,
    ! [VarCurr] :
      ( v6919(VarCurr,bitIndex6)
    <=> v6920(VarCurr,bitIndex6) ) ).

fof(addAssignment_3253,axiom,
    ! [VarCurr] :
      ( v6920(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_3252,axiom,
    ! [VarCurr] :
      ( ( v6920(VarCurr,bitIndex7)
      <=> v6803(VarCurr,bitIndex6) )
      & ( v6920(VarCurr,bitIndex6)
      <=> v6803(VarCurr,bitIndex5) )
      & ( v6920(VarCurr,bitIndex5)
      <=> v6803(VarCurr,bitIndex4) )
      & ( v6920(VarCurr,bitIndex4)
      <=> v6803(VarCurr,bitIndex3) )
      & ( v6920(VarCurr,bitIndex3)
      <=> v6803(VarCurr,bitIndex2) )
      & ( v6920(VarCurr,bitIndex2)
      <=> v6803(VarCurr,bitIndex1) )
      & ( v6920(VarCurr,bitIndex1)
      <=> v6803(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValue_43,axiom,
    ~ v6803(constB0,bitIndex6) ).

fof(bitBlastConstant_7411,axiom,
    ~ bx0xxxxxx(bitIndex6) ).

fof(addAssignment_3251,axiom,
    ! [VarCurr] :
      ( v6825(VarCurr)
    <=> v6827(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1098,axiom,
    ! [VarCurr] :
      ( v6827(VarCurr)
    <=> ( v6917(VarCurr)
        | v6911(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1097,axiom,
    ! [VarCurr] :
      ( v6917(VarCurr)
    <=> ( v6829(VarCurr)
        | v6889(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_273,axiom,
    ! [VarCurr] :
      ( ~ v6913(VarCurr)
     => ( v6911(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_276,axiom,
    ! [VarCurr] :
      ( v6913(VarCurr)
     => ( v6911(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1096,axiom,
    ! [VarCurr] :
      ( v6913(VarCurr)
    <=> ( v6914(VarCurr)
        & v6887(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1095,axiom,
    ! [VarCurr] :
      ( v6914(VarCurr)
    <=> ( v6915(VarCurr)
        & v6886(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_607,axiom,
    ! [VarCurr] :
      ( v6915(VarCurr)
    <=> ( ( v6831(VarCurr,bitIndex1)
        <=> $false )
        & ( v6831(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3250,axiom,
    ! [VarCurr] :
      ( v6889(VarCurr)
    <=> v6891(VarCurr) ) ).

fof(addAssignment_3249,axiom,
    ! [VarCurr] :
      ( v6891(VarCurr)
    <=> v6893(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1094,axiom,
    ! [VarCurr] :
      ( v6893(VarCurr)
    <=> ( v6909(VarCurr)
        & v6897(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_623,axiom,
    ! [VarCurr] :
      ( v6909(VarCurr)
    <=> ( v6895(VarCurr,bitIndex2)
        | v6895(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_3248,axiom,
    ! [VarCurr] :
      ( v6897(VarCurr)
    <=> v6899(VarCurr) ) ).

fof(addAssignment_3247,axiom,
    ! [VarCurr] :
      ( v6899(VarCurr)
    <=> v6901(VarCurr) ) ).

fof(addAssignment_3246,axiom,
    ! [VarCurr] :
      ( v6901(VarCurr)
    <=> v6903(VarCurr) ) ).

fof(addAssignment_3245,axiom,
    ! [VarCurr] :
      ( v6903(VarCurr)
    <=> v6905(VarCurr) ) ).

fof(addAssignment_3244,axiom,
    ! [VarCurr] :
      ( v6905(VarCurr)
    <=> v6907(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_272,axiom,
    ! [VarCurr] :
      ( ~ v6883(VarCurr)
     => ( v6829(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_275,axiom,
    ! [VarCurr] :
      ( v6883(VarCurr)
     => ( v6829(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1093,axiom,
    ! [VarCurr] :
      ( v6883(VarCurr)
    <=> ( v6884(VarCurr)
        & v6887(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_606,axiom,
    ! [VarCurr] :
      ( v6887(VarCurr)
    <=> ( $true
      <=> v6881(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1092,axiom,
    ! [VarCurr] :
      ( v6884(VarCurr)
    <=> ( v6885(VarCurr)
        & v6886(VarCurr) ) ) ).

fof(writeUnaryOperator_462,axiom,
    ! [VarCurr] :
      ( ~ v6886(VarCurr)
    <=> v6833(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_605,axiom,
    ! [VarCurr] :
      ( v6885(VarCurr)
    <=> ( ( v6831(VarCurr,bitIndex1)
        <=> $false )
        & ( v6831(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_271,axiom,
    ! [VarCurr] :
      ( ~ v6833(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6831(VarCurr,B)
          <=> v6852(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_274,axiom,
    ! [VarCurr] :
      ( v6833(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6831(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_16,axiom,
    ! [VarCurr] :
      ( ( ~ v6853(VarCurr)
        & ~ v6873(VarCurr)
        & ~ v6874(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v6852(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_143,axiom,
    ! [VarCurr] :
      ( v6874(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6852(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_170,axiom,
    ! [VarCurr] :
      ( v6873(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6852(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_171,axiom,
    ! [VarCurr] :
      ( v6853(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v6852(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1091,axiom,
    ! [VarCurr] :
      ( v6874(VarCurr)
    <=> ( v6876(VarCurr)
        | v6879(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_604,axiom,
    ! [VarCurr] :
      ( v6879(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $true )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $true )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1090,axiom,
    ! [VarCurr] :
      ( v6876(VarCurr)
    <=> ( v6877(VarCurr)
        | v6878(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_603,axiom,
    ! [VarCurr] :
      ( v6878(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $true )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $true )
        & ( v6837(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7410,axiom,
    ~ b0001011(bitIndex6) ).

fof(bitBlastConstant_7409,axiom,
    ~ b0001011(bitIndex5) ).

fof(bitBlastConstant_7408,axiom,
    ~ b0001011(bitIndex4) ).

fof(bitBlastConstant_7407,axiom,
    b0001011(bitIndex3) ).

fof(bitBlastConstant_7406,axiom,
    ~ b0001011(bitIndex2) ).

fof(bitBlastConstant_7405,axiom,
    b0001011(bitIndex1) ).

fof(bitBlastConstant_7404,axiom,
    b0001011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_602,axiom,
    ! [VarCurr] :
      ( v6877(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $true )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $true )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_601,axiom,
    ! [VarCurr] :
      ( v6873(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $true )
        & ( v6837(VarCurr,bitIndex4)
        <=> $true )
        & ( v6837(VarCurr,bitIndex3)
        <=> $true )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $true )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1089,axiom,
    ! [VarCurr] :
      ( v6853(VarCurr)
    <=> ( v6855(VarCurr)
        | v6872(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_600,axiom,
    ! [VarCurr] :
      ( v6872(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $true )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7403,axiom,
    b1000101(bitIndex6) ).

fof(bitBlastConstant_7402,axiom,
    ~ b1000101(bitIndex5) ).

fof(bitBlastConstant_7401,axiom,
    ~ b1000101(bitIndex4) ).

fof(bitBlastConstant_7400,axiom,
    ~ b1000101(bitIndex3) ).

fof(bitBlastConstant_7399,axiom,
    b1000101(bitIndex2) ).

fof(bitBlastConstant_7398,axiom,
    ~ b1000101(bitIndex1) ).

fof(bitBlastConstant_7397,axiom,
    b1000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1088,axiom,
    ! [VarCurr] :
      ( v6855(VarCurr)
    <=> ( v6856(VarCurr)
        | v6871(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_599,axiom,
    ! [VarCurr] :
      ( v6871(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $true )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7396,axiom,
    b1000100(bitIndex6) ).

fof(bitBlastConstant_7395,axiom,
    ~ b1000100(bitIndex5) ).

fof(bitBlastConstant_7394,axiom,
    ~ b1000100(bitIndex4) ).

fof(bitBlastConstant_7393,axiom,
    ~ b1000100(bitIndex3) ).

fof(bitBlastConstant_7392,axiom,
    b1000100(bitIndex2) ).

fof(bitBlastConstant_7391,axiom,
    ~ b1000100(bitIndex1) ).

fof(bitBlastConstant_7390,axiom,
    ~ b1000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1087,axiom,
    ! [VarCurr] :
      ( v6856(VarCurr)
    <=> ( v6857(VarCurr)
        | v6870(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_598,axiom,
    ! [VarCurr] :
      ( v6870(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $true )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1086,axiom,
    ! [VarCurr] :
      ( v6857(VarCurr)
    <=> ( v6858(VarCurr)
        | v6869(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_597,axiom,
    ! [VarCurr] :
      ( v6869(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1085,axiom,
    ! [VarCurr] :
      ( v6858(VarCurr)
    <=> ( v6859(VarCurr)
        | v6868(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_596,axiom,
    ! [VarCurr] :
      ( v6868(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $true )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $true )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7389,axiom,
    b1000010(bitIndex6) ).

fof(bitBlastConstant_7388,axiom,
    ~ b1000010(bitIndex5) ).

fof(bitBlastConstant_7387,axiom,
    ~ b1000010(bitIndex4) ).

fof(bitBlastConstant_7386,axiom,
    ~ b1000010(bitIndex3) ).

fof(bitBlastConstant_7385,axiom,
    ~ b1000010(bitIndex2) ).

fof(bitBlastConstant_7384,axiom,
    b1000010(bitIndex1) ).

fof(bitBlastConstant_7383,axiom,
    ~ b1000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1084,axiom,
    ! [VarCurr] :
      ( v6859(VarCurr)
    <=> ( v6860(VarCurr)
        | v6867(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_595,axiom,
    ! [VarCurr] :
      ( v6867(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $true )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7382,axiom,
    ~ b0000101(bitIndex6) ).

fof(bitBlastConstant_7381,axiom,
    ~ b0000101(bitIndex5) ).

fof(bitBlastConstant_7380,axiom,
    ~ b0000101(bitIndex4) ).

fof(bitBlastConstant_7379,axiom,
    ~ b0000101(bitIndex3) ).

fof(bitBlastConstant_7378,axiom,
    b0000101(bitIndex2) ).

fof(bitBlastConstant_7377,axiom,
    ~ b0000101(bitIndex1) ).

fof(bitBlastConstant_7376,axiom,
    b0000101(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1083,axiom,
    ! [VarCurr] :
      ( v6860(VarCurr)
    <=> ( v6861(VarCurr)
        | v6866(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_594,axiom,
    ! [VarCurr] :
      ( v6866(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $true )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7375,axiom,
    ~ b0000100(bitIndex6) ).

fof(bitBlastConstant_7374,axiom,
    ~ b0000100(bitIndex5) ).

fof(bitBlastConstant_7373,axiom,
    ~ b0000100(bitIndex4) ).

fof(bitBlastConstant_7372,axiom,
    ~ b0000100(bitIndex3) ).

fof(bitBlastConstant_7371,axiom,
    b0000100(bitIndex2) ).

fof(bitBlastConstant_7370,axiom,
    ~ b0000100(bitIndex1) ).

fof(bitBlastConstant_7369,axiom,
    ~ b0000100(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1082,axiom,
    ! [VarCurr] :
      ( v6861(VarCurr)
    <=> ( v6862(VarCurr)
        | v6865(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_593,axiom,
    ! [VarCurr] :
      ( v6865(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $true )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7368,axiom,
    ~ b0000010(bitIndex6) ).

fof(bitBlastConstant_7367,axiom,
    ~ b0000010(bitIndex5) ).

fof(bitBlastConstant_7366,axiom,
    ~ b0000010(bitIndex4) ).

fof(bitBlastConstant_7365,axiom,
    ~ b0000010(bitIndex3) ).

fof(bitBlastConstant_7364,axiom,
    ~ b0000010(bitIndex2) ).

fof(bitBlastConstant_7363,axiom,
    b0000010(bitIndex1) ).

fof(bitBlastConstant_7362,axiom,
    ~ b0000010(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1081,axiom,
    ! [VarCurr] :
      ( v6862(VarCurr)
    <=> ( v6863(VarCurr)
        | v6864(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_592,axiom,
    ! [VarCurr] :
      ( v6864(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $true )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_591,axiom,
    ! [VarCurr] :
      ( v6863(VarCurr)
    <=> ( ( v6837(VarCurr,bitIndex6)
        <=> $false )
        & ( v6837(VarCurr,bitIndex5)
        <=> $false )
        & ( v6837(VarCurr,bitIndex4)
        <=> $false )
        & ( v6837(VarCurr,bitIndex3)
        <=> $false )
        & ( v6837(VarCurr,bitIndex2)
        <=> $false )
        & ( v6837(VarCurr,bitIndex1)
        <=> $false )
        & ( v6837(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3243,axiom,
    ! [VarCurr] :
      ( ( v6837(VarCurr,bitIndex6)
      <=> v6839(VarCurr,bitIndex69) )
      & ( v6837(VarCurr,bitIndex5)
      <=> v6839(VarCurr,bitIndex68) )
      & ( v6837(VarCurr,bitIndex4)
      <=> v6839(VarCurr,bitIndex67) )
      & ( v6837(VarCurr,bitIndex3)
      <=> v6839(VarCurr,bitIndex66) )
      & ( v6837(VarCurr,bitIndex2)
      <=> v6839(VarCurr,bitIndex65) )
      & ( v6837(VarCurr,bitIndex1)
      <=> v6839(VarCurr,bitIndex64) )
      & ( v6837(VarCurr,bitIndex0)
      <=> v6839(VarCurr,bitIndex63) ) ) ).

fof(addAssignment_3242,axiom,
    ! [VarCurr,B] :
      ( range_69_63(B)
     => ( v6839(VarCurr,B)
      <=> v6841(VarCurr,B) ) ) ).

fof(range_axiom_39,axiom,
    ! [B] :
      ( range_69_63(B)
    <=> ( $false
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B ) ) ).

fof(addAssignment_3241,axiom,
    ! [VarCurr] :
      ( ( v6841(VarCurr,bitIndex69)
      <=> v6843(VarCurr,bitIndex559) )
      & ( v6841(VarCurr,bitIndex68)
      <=> v6843(VarCurr,bitIndex558) )
      & ( v6841(VarCurr,bitIndex67)
      <=> v6843(VarCurr,bitIndex557) )
      & ( v6841(VarCurr,bitIndex66)
      <=> v6843(VarCurr,bitIndex556) )
      & ( v6841(VarCurr,bitIndex65)
      <=> v6843(VarCurr,bitIndex555) )
      & ( v6841(VarCurr,bitIndex64)
      <=> v6843(VarCurr,bitIndex554) )
      & ( v6841(VarCurr,bitIndex63)
      <=> v6843(VarCurr,bitIndex553) ) ) ).

fof(addAssignment_3240,axiom,
    ! [VarCurr] :
      ( v6833(VarCurr)
    <=> v6835(VarCurr) ) ).

fof(addAssignment_3239,axiom,
    ! [VarCurr] :
      ( v6811(VarCurr)
    <=> v6813(VarCurr) ) ).

fof(addAssignment_3238,axiom,
    ! [VarCurr] :
      ( v6813(VarCurr)
    <=> v6815(VarCurr) ) ).

fof(addAssignment_3237,axiom,
    ! [VarCurr] :
      ( v6815(VarCurr)
    <=> v6817(VarCurr) ) ).

fof(addAssignment_3236,axiom,
    ! [VarCurr] :
      ( v6817(VarCurr)
    <=> v6819(VarCurr) ) ).

fof(addAssignment_3235,axiom,
    ! [VarCurr] :
      ( v6819(VarCurr)
    <=> v6821(VarCurr) ) ).

fof(addAssignment_3234,axiom,
    ! [VarCurr] :
      ( v6821(VarCurr)
    <=> v6823(VarCurr) ) ).

fof(addAssignment_3233,axiom,
    ! [VarCurr] :
      ( v6805(VarCurr)
    <=> v6807(VarCurr) ) ).

fof(addAssignment_3232,axiom,
    ! [VarCurr] :
      ( v6807(VarCurr)
    <=> v1903(VarCurr) ) ).

fof(addAssignment_3231,axiom,
    ! [VarCurr] :
      ( v6375(VarCurr)
    <=> v6377(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1080,axiom,
    ! [VarCurr] :
      ( v6377(VarCurr)
    <=> ( v6778(VarCurr)
        & v6733(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1079,axiom,
    ! [VarCurr] :
      ( v6778(VarCurr)
    <=> ( v6779(VarCurr)
        & v6688(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1078,axiom,
    ! [VarCurr] :
      ( v6779(VarCurr)
    <=> ( v6780(VarCurr)
        & v6643(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1077,axiom,
    ! [VarCurr] :
      ( v6780(VarCurr)
    <=> ( v6781(VarCurr)
        & v6598(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1076,axiom,
    ! [VarCurr] :
      ( v6781(VarCurr)
    <=> ( v6782(VarCurr)
        & v6553(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1075,axiom,
    ! [VarCurr] :
      ( v6782(VarCurr)
    <=> ( v6783(VarCurr)
        & v6508(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1074,axiom,
    ! [VarCurr] :
      ( v6783(VarCurr)
    <=> ( v6379(VarCurr)
        & v6463(VarCurr) ) ) ).

fof(addAssignment_3230,axiom,
    ! [VarCurr] :
      ( v6733(VarCurr)
    <=> v6735(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_61,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6753(VarNext)
       => ( v6735(VarNext)
        <=> v6735(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_68,axiom,
    ! [VarNext] :
      ( v6753(VarNext)
     => ( v6735(VarNext)
      <=> v6773(VarNext) ) ) ).

fof(addAssignment_3229,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6773(VarNext)
      <=> v6771(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_270,axiom,
    ! [VarCurr] :
      ( ~ v6770(VarCurr)
     => ( v6771(VarCurr)
      <=> v6774(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_273,axiom,
    ! [VarCurr] :
      ( v6770(VarCurr)
     => ( v6771(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_269,axiom,
    ! [VarCurr] :
      ( ~ v6739(VarCurr)
     => ( v6774(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_272,axiom,
    ! [VarCurr] :
      ( v6739(VarCurr)
     => ( v6774(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1073,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6753(VarNext)
      <=> ( v6754(VarNext)
          & v6763(VarNext) ) ) ) ).

fof(addAssignment_3228,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6763(VarNext)
      <=> v6761(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1072,axiom,
    ! [VarCurr] :
      ( v6761(VarCurr)
    <=> ( v6764(VarCurr)
        | v6770(VarCurr) ) ) ).

fof(writeUnaryOperator_461,axiom,
    ! [VarCurr] :
      ( ~ v6770(VarCurr)
    <=> v6737(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1071,axiom,
    ! [VarCurr] :
      ( v6764(VarCurr)
    <=> ( v6765(VarCurr)
        | v6739(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1070,axiom,
    ! [VarCurr] :
      ( v6765(VarCurr)
    <=> ( v6766(VarCurr)
        & v6769(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_590,axiom,
    ! [VarCurr] :
      ( v6769(VarCurr)
    <=> ( v6745(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1069,axiom,
    ! [VarCurr] :
      ( v6766(VarCurr)
    <=> ( v6767(VarCurr)
        & v6768(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_589,axiom,
    ! [VarCurr] :
      ( v6768(VarCurr)
    <=> ( v6743(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_588,axiom,
    ! [VarCurr] :
      ( v6767(VarCurr)
    <=> ( v6741(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1068,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6754(VarNext)
      <=> ( v6755(VarNext)
          & v6750(VarNext) ) ) ) ).

fof(writeUnaryOperator_460,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6755(VarNext)
      <=> v6757(VarNext) ) ) ).

fof(addAssignment_3227,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6757(VarNext)
      <=> v6750(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_54,axiom,
    ( v6735(constB0)
  <=> $true ) ).

fof(addAssignment_3226,axiom,
    ! [VarCurr] :
      ( v6750(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3225,axiom,
    ! [VarCurr] :
      ( v6745(VarCurr,bitIndex0)
    <=> v6746(VarCurr,bitIndex0) ) ).

fof(addAssignment_3224,axiom,
    ! [VarCurr] :
      ( v6746(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3223,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6746(VarCurr,B)
      <=> v6747(VarCurr,B) ) ) ).

fof(addAssignment_3222,axiom,
    ! [VarCurr] :
      ( v6741(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3221,axiom,
    ! [VarCurr] :
      ( v6739(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3220,axiom,
    ! [VarCurr] :
      ( v6737(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3219,axiom,
    ! [VarCurr] :
      ( v6688(VarCurr)
    <=> v6690(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_60,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6708(VarNext)
       => ( v6690(VarNext)
        <=> v6690(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_67,axiom,
    ! [VarNext] :
      ( v6708(VarNext)
     => ( v6690(VarNext)
      <=> v6728(VarNext) ) ) ).

fof(addAssignment_3218,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6728(VarNext)
      <=> v6726(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_268,axiom,
    ! [VarCurr] :
      ( ~ v6725(VarCurr)
     => ( v6726(VarCurr)
      <=> v6729(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_271,axiom,
    ! [VarCurr] :
      ( v6725(VarCurr)
     => ( v6726(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_267,axiom,
    ! [VarCurr] :
      ( ~ v6694(VarCurr)
     => ( v6729(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_270,axiom,
    ! [VarCurr] :
      ( v6694(VarCurr)
     => ( v6729(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1067,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6708(VarNext)
      <=> ( v6709(VarNext)
          & v6718(VarNext) ) ) ) ).

fof(addAssignment_3217,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6718(VarNext)
      <=> v6716(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1066,axiom,
    ! [VarCurr] :
      ( v6716(VarCurr)
    <=> ( v6719(VarCurr)
        | v6725(VarCurr) ) ) ).

fof(writeUnaryOperator_459,axiom,
    ! [VarCurr] :
      ( ~ v6725(VarCurr)
    <=> v6692(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1065,axiom,
    ! [VarCurr] :
      ( v6719(VarCurr)
    <=> ( v6720(VarCurr)
        | v6694(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1064,axiom,
    ! [VarCurr] :
      ( v6720(VarCurr)
    <=> ( v6721(VarCurr)
        & v6724(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_587,axiom,
    ! [VarCurr] :
      ( v6724(VarCurr)
    <=> ( v6700(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1063,axiom,
    ! [VarCurr] :
      ( v6721(VarCurr)
    <=> ( v6722(VarCurr)
        & v6723(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_586,axiom,
    ! [VarCurr] :
      ( v6723(VarCurr)
    <=> ( v6698(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_585,axiom,
    ! [VarCurr] :
      ( v6722(VarCurr)
    <=> ( v6696(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1062,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6709(VarNext)
      <=> ( v6710(VarNext)
          & v6705(VarNext) ) ) ) ).

fof(writeUnaryOperator_458,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6710(VarNext)
      <=> v6712(VarNext) ) ) ).

fof(addAssignment_3216,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6712(VarNext)
      <=> v6705(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_53,axiom,
    ( v6690(constB0)
  <=> $true ) ).

fof(addAssignment_3215,axiom,
    ! [VarCurr] :
      ( v6705(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3214,axiom,
    ! [VarCurr] :
      ( v6700(VarCurr,bitIndex0)
    <=> v6701(VarCurr,bitIndex0) ) ).

fof(addAssignment_3213,axiom,
    ! [VarCurr] :
      ( v6701(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3212,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6701(VarCurr,B)
      <=> v6702(VarCurr,B) ) ) ).

fof(addAssignment_3211,axiom,
    ! [VarCurr] :
      ( v6696(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3210,axiom,
    ! [VarCurr] :
      ( v6694(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3209,axiom,
    ! [VarCurr] :
      ( v6692(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3208,axiom,
    ! [VarCurr] :
      ( v6643(VarCurr)
    <=> v6645(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_59,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6663(VarNext)
       => ( v6645(VarNext)
        <=> v6645(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_66,axiom,
    ! [VarNext] :
      ( v6663(VarNext)
     => ( v6645(VarNext)
      <=> v6683(VarNext) ) ) ).

fof(addAssignment_3207,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6683(VarNext)
      <=> v6681(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_266,axiom,
    ! [VarCurr] :
      ( ~ v6680(VarCurr)
     => ( v6681(VarCurr)
      <=> v6684(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_269,axiom,
    ! [VarCurr] :
      ( v6680(VarCurr)
     => ( v6681(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_265,axiom,
    ! [VarCurr] :
      ( ~ v6649(VarCurr)
     => ( v6684(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_268,axiom,
    ! [VarCurr] :
      ( v6649(VarCurr)
     => ( v6684(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1061,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6663(VarNext)
      <=> ( v6664(VarNext)
          & v6673(VarNext) ) ) ) ).

fof(addAssignment_3206,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6673(VarNext)
      <=> v6671(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1060,axiom,
    ! [VarCurr] :
      ( v6671(VarCurr)
    <=> ( v6674(VarCurr)
        | v6680(VarCurr) ) ) ).

fof(writeUnaryOperator_457,axiom,
    ! [VarCurr] :
      ( ~ v6680(VarCurr)
    <=> v6647(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1059,axiom,
    ! [VarCurr] :
      ( v6674(VarCurr)
    <=> ( v6675(VarCurr)
        | v6649(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1058,axiom,
    ! [VarCurr] :
      ( v6675(VarCurr)
    <=> ( v6676(VarCurr)
        & v6679(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_584,axiom,
    ! [VarCurr] :
      ( v6679(VarCurr)
    <=> ( v6655(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1057,axiom,
    ! [VarCurr] :
      ( v6676(VarCurr)
    <=> ( v6677(VarCurr)
        & v6678(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_583,axiom,
    ! [VarCurr] :
      ( v6678(VarCurr)
    <=> ( v6653(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_582,axiom,
    ! [VarCurr] :
      ( v6677(VarCurr)
    <=> ( v6651(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1056,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6664(VarNext)
      <=> ( v6665(VarNext)
          & v6660(VarNext) ) ) ) ).

fof(writeUnaryOperator_456,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6665(VarNext)
      <=> v6667(VarNext) ) ) ).

fof(addAssignment_3205,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6667(VarNext)
      <=> v6660(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_52,axiom,
    ( v6645(constB0)
  <=> $true ) ).

fof(addAssignment_3204,axiom,
    ! [VarCurr] :
      ( v6660(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3203,axiom,
    ! [VarCurr] :
      ( v6655(VarCurr,bitIndex0)
    <=> v6656(VarCurr,bitIndex0) ) ).

fof(addAssignment_3202,axiom,
    ! [VarCurr] :
      ( v6656(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3201,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6656(VarCurr,B)
      <=> v6657(VarCurr,B) ) ) ).

fof(addAssignment_3200,axiom,
    ! [VarCurr] :
      ( v6651(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3199,axiom,
    ! [VarCurr] :
      ( v6649(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3198,axiom,
    ! [VarCurr] :
      ( v6647(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3197,axiom,
    ! [VarCurr] :
      ( v6598(VarCurr)
    <=> v6600(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_58,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6618(VarNext)
       => ( v6600(VarNext)
        <=> v6600(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_65,axiom,
    ! [VarNext] :
      ( v6618(VarNext)
     => ( v6600(VarNext)
      <=> v6638(VarNext) ) ) ).

fof(addAssignment_3196,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6638(VarNext)
      <=> v6636(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_264,axiom,
    ! [VarCurr] :
      ( ~ v6635(VarCurr)
     => ( v6636(VarCurr)
      <=> v6639(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_267,axiom,
    ! [VarCurr] :
      ( v6635(VarCurr)
     => ( v6636(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_263,axiom,
    ! [VarCurr] :
      ( ~ v6604(VarCurr)
     => ( v6639(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_266,axiom,
    ! [VarCurr] :
      ( v6604(VarCurr)
     => ( v6639(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1055,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6618(VarNext)
      <=> ( v6619(VarNext)
          & v6628(VarNext) ) ) ) ).

fof(addAssignment_3195,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6628(VarNext)
      <=> v6626(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1054,axiom,
    ! [VarCurr] :
      ( v6626(VarCurr)
    <=> ( v6629(VarCurr)
        | v6635(VarCurr) ) ) ).

fof(writeUnaryOperator_455,axiom,
    ! [VarCurr] :
      ( ~ v6635(VarCurr)
    <=> v6602(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1053,axiom,
    ! [VarCurr] :
      ( v6629(VarCurr)
    <=> ( v6630(VarCurr)
        | v6604(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1052,axiom,
    ! [VarCurr] :
      ( v6630(VarCurr)
    <=> ( v6631(VarCurr)
        & v6634(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_581,axiom,
    ! [VarCurr] :
      ( v6634(VarCurr)
    <=> ( v6610(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1051,axiom,
    ! [VarCurr] :
      ( v6631(VarCurr)
    <=> ( v6632(VarCurr)
        & v6633(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_580,axiom,
    ! [VarCurr] :
      ( v6633(VarCurr)
    <=> ( v6608(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_579,axiom,
    ! [VarCurr] :
      ( v6632(VarCurr)
    <=> ( v6606(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1050,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6619(VarNext)
      <=> ( v6620(VarNext)
          & v6615(VarNext) ) ) ) ).

fof(writeUnaryOperator_454,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6620(VarNext)
      <=> v6622(VarNext) ) ) ).

fof(addAssignment_3194,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6622(VarNext)
      <=> v6615(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_51,axiom,
    ( v6600(constB0)
  <=> $true ) ).

fof(addAssignment_3193,axiom,
    ! [VarCurr] :
      ( v6615(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3192,axiom,
    ! [VarCurr] :
      ( v6610(VarCurr,bitIndex0)
    <=> v6611(VarCurr,bitIndex0) ) ).

fof(addAssignment_3191,axiom,
    ! [VarCurr] :
      ( v6611(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3190,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6611(VarCurr,B)
      <=> v6612(VarCurr,B) ) ) ).

fof(addAssignment_3189,axiom,
    ! [VarCurr] :
      ( v6606(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3188,axiom,
    ! [VarCurr] :
      ( v6604(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3187,axiom,
    ! [VarCurr] :
      ( v6602(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3186,axiom,
    ! [VarCurr] :
      ( v6553(VarCurr)
    <=> v6555(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_57,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6573(VarNext)
       => ( v6555(VarNext)
        <=> v6555(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_64,axiom,
    ! [VarNext] :
      ( v6573(VarNext)
     => ( v6555(VarNext)
      <=> v6593(VarNext) ) ) ).

fof(addAssignment_3185,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6593(VarNext)
      <=> v6591(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_262,axiom,
    ! [VarCurr] :
      ( ~ v6590(VarCurr)
     => ( v6591(VarCurr)
      <=> v6594(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_265,axiom,
    ! [VarCurr] :
      ( v6590(VarCurr)
     => ( v6591(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_261,axiom,
    ! [VarCurr] :
      ( ~ v6559(VarCurr)
     => ( v6594(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_264,axiom,
    ! [VarCurr] :
      ( v6559(VarCurr)
     => ( v6594(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1049,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6573(VarNext)
      <=> ( v6574(VarNext)
          & v6583(VarNext) ) ) ) ).

fof(addAssignment_3184,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6583(VarNext)
      <=> v6581(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1048,axiom,
    ! [VarCurr] :
      ( v6581(VarCurr)
    <=> ( v6584(VarCurr)
        | v6590(VarCurr) ) ) ).

fof(writeUnaryOperator_453,axiom,
    ! [VarCurr] :
      ( ~ v6590(VarCurr)
    <=> v6557(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1047,axiom,
    ! [VarCurr] :
      ( v6584(VarCurr)
    <=> ( v6585(VarCurr)
        | v6559(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1046,axiom,
    ! [VarCurr] :
      ( v6585(VarCurr)
    <=> ( v6586(VarCurr)
        & v6589(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_578,axiom,
    ! [VarCurr] :
      ( v6589(VarCurr)
    <=> ( v6565(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1045,axiom,
    ! [VarCurr] :
      ( v6586(VarCurr)
    <=> ( v6587(VarCurr)
        & v6588(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_577,axiom,
    ! [VarCurr] :
      ( v6588(VarCurr)
    <=> ( v6563(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_576,axiom,
    ! [VarCurr] :
      ( v6587(VarCurr)
    <=> ( v6561(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1044,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6574(VarNext)
      <=> ( v6575(VarNext)
          & v6570(VarNext) ) ) ) ).

fof(writeUnaryOperator_452,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6575(VarNext)
      <=> v6577(VarNext) ) ) ).

fof(addAssignment_3183,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6577(VarNext)
      <=> v6570(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_50,axiom,
    ( v6555(constB0)
  <=> $true ) ).

fof(addAssignment_3182,axiom,
    ! [VarCurr] :
      ( v6570(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3181,axiom,
    ! [VarCurr] :
      ( v6565(VarCurr,bitIndex0)
    <=> v6566(VarCurr,bitIndex0) ) ).

fof(addAssignment_3180,axiom,
    ! [VarCurr] :
      ( v6566(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3179,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6566(VarCurr,B)
      <=> v6567(VarCurr,B) ) ) ).

fof(addAssignment_3178,axiom,
    ! [VarCurr] :
      ( v6561(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3177,axiom,
    ! [VarCurr] :
      ( v6559(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3176,axiom,
    ! [VarCurr] :
      ( v6557(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3175,axiom,
    ! [VarCurr] :
      ( v6508(VarCurr)
    <=> v6510(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_56,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6528(VarNext)
       => ( v6510(VarNext)
        <=> v6510(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_63,axiom,
    ! [VarNext] :
      ( v6528(VarNext)
     => ( v6510(VarNext)
      <=> v6548(VarNext) ) ) ).

fof(addAssignment_3174,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6548(VarNext)
      <=> v6546(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_260,axiom,
    ! [VarCurr] :
      ( ~ v6545(VarCurr)
     => ( v6546(VarCurr)
      <=> v6549(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_263,axiom,
    ! [VarCurr] :
      ( v6545(VarCurr)
     => ( v6546(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_259,axiom,
    ! [VarCurr] :
      ( ~ v6514(VarCurr)
     => ( v6549(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_262,axiom,
    ! [VarCurr] :
      ( v6514(VarCurr)
     => ( v6549(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1043,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6528(VarNext)
      <=> ( v6529(VarNext)
          & v6538(VarNext) ) ) ) ).

fof(addAssignment_3173,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6538(VarNext)
      <=> v6536(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1042,axiom,
    ! [VarCurr] :
      ( v6536(VarCurr)
    <=> ( v6539(VarCurr)
        | v6545(VarCurr) ) ) ).

fof(writeUnaryOperator_451,axiom,
    ! [VarCurr] :
      ( ~ v6545(VarCurr)
    <=> v6512(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1041,axiom,
    ! [VarCurr] :
      ( v6539(VarCurr)
    <=> ( v6540(VarCurr)
        | v6514(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1040,axiom,
    ! [VarCurr] :
      ( v6540(VarCurr)
    <=> ( v6541(VarCurr)
        & v6544(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_575,axiom,
    ! [VarCurr] :
      ( v6544(VarCurr)
    <=> ( v6520(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1039,axiom,
    ! [VarCurr] :
      ( v6541(VarCurr)
    <=> ( v6542(VarCurr)
        & v6543(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_574,axiom,
    ! [VarCurr] :
      ( v6543(VarCurr)
    <=> ( v6518(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_573,axiom,
    ! [VarCurr] :
      ( v6542(VarCurr)
    <=> ( v6516(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1038,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6529(VarNext)
      <=> ( v6530(VarNext)
          & v6525(VarNext) ) ) ) ).

fof(writeUnaryOperator_450,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6530(VarNext)
      <=> v6532(VarNext) ) ) ).

fof(addAssignment_3172,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6532(VarNext)
      <=> v6525(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_49,axiom,
    ( v6510(constB0)
  <=> $true ) ).

fof(addAssignment_3171,axiom,
    ! [VarCurr] :
      ( v6525(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3170,axiom,
    ! [VarCurr] :
      ( v6520(VarCurr,bitIndex0)
    <=> v6521(VarCurr,bitIndex0) ) ).

fof(addAssignment_3169,axiom,
    ! [VarCurr] :
      ( v6521(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3168,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6521(VarCurr,B)
      <=> v6522(VarCurr,B) ) ) ).

fof(addAssignment_3167,axiom,
    ! [VarCurr] :
      ( v6516(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3166,axiom,
    ! [VarCurr] :
      ( v6514(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3165,axiom,
    ! [VarCurr] :
      ( v6512(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3164,axiom,
    ! [VarCurr] :
      ( v6463(VarCurr)
    <=> v6465(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6483(VarNext)
       => ( v6465(VarNext)
        <=> v6465(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_62,axiom,
    ! [VarNext] :
      ( v6483(VarNext)
     => ( v6465(VarNext)
      <=> v6503(VarNext) ) ) ).

fof(addAssignment_3163,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6503(VarNext)
      <=> v6501(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_258,axiom,
    ! [VarCurr] :
      ( ~ v6500(VarCurr)
     => ( v6501(VarCurr)
      <=> v6504(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_261,axiom,
    ! [VarCurr] :
      ( v6500(VarCurr)
     => ( v6501(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_257,axiom,
    ! [VarCurr] :
      ( ~ v6469(VarCurr)
     => ( v6504(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_260,axiom,
    ! [VarCurr] :
      ( v6469(VarCurr)
     => ( v6504(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1037,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6483(VarNext)
      <=> ( v6484(VarNext)
          & v6493(VarNext) ) ) ) ).

fof(addAssignment_3162,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6493(VarNext)
      <=> v6491(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1036,axiom,
    ! [VarCurr] :
      ( v6491(VarCurr)
    <=> ( v6494(VarCurr)
        | v6500(VarCurr) ) ) ).

fof(writeUnaryOperator_449,axiom,
    ! [VarCurr] :
      ( ~ v6500(VarCurr)
    <=> v6467(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1035,axiom,
    ! [VarCurr] :
      ( v6494(VarCurr)
    <=> ( v6495(VarCurr)
        | v6469(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1034,axiom,
    ! [VarCurr] :
      ( v6495(VarCurr)
    <=> ( v6496(VarCurr)
        & v6499(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_572,axiom,
    ! [VarCurr] :
      ( v6499(VarCurr)
    <=> ( v6475(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1033,axiom,
    ! [VarCurr] :
      ( v6496(VarCurr)
    <=> ( v6497(VarCurr)
        & v6498(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_571,axiom,
    ! [VarCurr] :
      ( v6498(VarCurr)
    <=> ( v6473(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_570,axiom,
    ! [VarCurr] :
      ( v6497(VarCurr)
    <=> ( v6471(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1032,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6484(VarNext)
      <=> ( v6485(VarNext)
          & v6480(VarNext) ) ) ) ).

fof(writeUnaryOperator_448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6485(VarNext)
      <=> v6487(VarNext) ) ) ).

fof(addAssignment_3161,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6487(VarNext)
      <=> v6480(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_48,axiom,
    ( v6465(constB0)
  <=> $true ) ).

fof(addAssignment_3160,axiom,
    ! [VarCurr] :
      ( v6480(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3159,axiom,
    ! [VarCurr] :
      ( v6475(VarCurr,bitIndex0)
    <=> v6476(VarCurr,bitIndex0) ) ).

fof(addAssignment_3158,axiom,
    ! [VarCurr] :
      ( v6476(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3157,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6476(VarCurr,B)
      <=> v6477(VarCurr,B) ) ) ).

fof(addAssignment_3156,axiom,
    ! [VarCurr] :
      ( v6471(VarCurr)
    <=> v6367(VarCurr) ) ).

fof(addAssignment_3155,axiom,
    ! [VarCurr] :
      ( v6469(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3154,axiom,
    ! [VarCurr] :
      ( v6467(VarCurr)
    <=> v43(VarCurr) ) ).

fof(addAssignment_3153,axiom,
    ! [VarCurr] :
      ( v6379(VarCurr)
    <=> v6381(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6440(VarNext)
       => ( v6381(VarNext)
        <=> v6381(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_61,axiom,
    ! [VarNext] :
      ( v6440(VarNext)
     => ( v6381(VarNext)
      <=> v6458(VarNext) ) ) ).

fof(addAssignment_3152,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6458(VarNext)
      <=> v6456(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_256,axiom,
    ! [VarCurr] :
      ( ~ v6455(VarCurr)
     => ( v6456(VarCurr)
      <=> v6459(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_259,axiom,
    ! [VarCurr] :
      ( v6455(VarCurr)
     => ( v6456(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_255,axiom,
    ! [VarCurr] :
      ( ~ v52(VarCurr)
     => ( v6459(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_258,axiom,
    ! [VarCurr] :
      ( v52(VarCurr)
     => ( v6459(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1031,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6440(VarNext)
      <=> ( v6441(VarNext)
          & v6448(VarNext) ) ) ) ).

fof(addAssignment_3151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6448(VarNext)
      <=> v6446(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1030,axiom,
    ! [VarCurr] :
      ( v6446(VarCurr)
    <=> ( v6449(VarCurr)
        | v6455(VarCurr) ) ) ).

fof(writeUnaryOperator_447,axiom,
    ! [VarCurr] :
      ( ~ v6455(VarCurr)
    <=> v41(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1029,axiom,
    ! [VarCurr] :
      ( v6449(VarCurr)
    <=> ( v6450(VarCurr)
        | v52(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1028,axiom,
    ! [VarCurr] :
      ( v6450(VarCurr)
    <=> ( v6451(VarCurr)
        & v6454(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_569,axiom,
    ! [VarCurr] :
      ( v6454(VarCurr)
    <=> ( v6434(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1027,axiom,
    ! [VarCurr] :
      ( v6451(VarCurr)
    <=> ( v6452(VarCurr)
        & v6453(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_568,axiom,
    ! [VarCurr] :
      ( v6453(VarCurr)
    <=> ( v39(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_567,axiom,
    ! [VarCurr] :
      ( v6452(VarCurr)
    <=> ( v6365(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1026,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6441(VarNext)
      <=> ( v6442(VarNext)
          & v6400(VarNext) ) ) ) ).

fof(writeUnaryOperator_446,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6442(VarNext)
      <=> v6413(VarNext) ) ) ).

fof(addAssignmentInitValueVector_47,axiom,
    ( v6381(constB0)
  <=> $true ) ).

fof(addAssignment_3150,axiom,
    ! [VarCurr] :
      ( v6434(VarCurr,bitIndex0)
    <=> v6435(VarCurr,bitIndex0) ) ).

fof(addAssignment_3149,axiom,
    ! [VarCurr] :
      ( v6435(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3148,axiom,
    ! [VarCurr,B] :
      ( range_6_1(B)
     => ( v6435(VarCurr,B)
      <=> v6436(VarCurr,B) ) ) ).

fof(range_axiom_38,axiom,
    ! [B] :
      ( range_6_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B ) ) ).

fof(addAssignment_3147,axiom,
    ! [VarNext] :
      ( v39(VarNext,bitIndex1)
    <=> v6426(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_53,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6427(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v6426(VarNext,B)
            <=> v39(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_60,axiom,
    ! [VarNext] :
      ( v6427(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6426(VarNext,B)
          <=> v6419(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1025,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6427(VarNext)
      <=> v6428(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1024,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6428(VarNext)
      <=> ( v6430(VarNext)
          & v6400(VarNext) ) ) ) ).

fof(writeUnaryOperator_445,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6430(VarNext)
      <=> v6413(VarNext) ) ) ).

fof(addAssignment_3146,axiom,
    ! [VarCurr] :
      ( v50(VarCurr,bitIndex1)
    <=> v6385(VarCurr,bitIndex1) ) ).

fof(addAssignment_3145,axiom,
    ! [VarCurr] :
      ( v6384(VarCurr,bitIndex1)
    <=> v6423(VarCurr,bitIndex1) ) ).

fof(addAssignment_3144,axiom,
    ! [VarCurr] :
      ( v6423(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_3143,axiom,
    ! [VarCurr] :
      ( ( v6423(VarCurr,bitIndex3)
      <=> v39(VarCurr,bitIndex2) )
      & ( v6423(VarCurr,bitIndex2)
      <=> v39(VarCurr,bitIndex1) )
      & ( v6423(VarCurr,bitIndex1)
      <=> v39(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_3142,axiom,
    ! [VarNext] :
      ( v39(VarNext,bitIndex0)
    <=> v6408(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_52,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6409(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v6408(VarNext,B)
            <=> v39(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_59,axiom,
    ! [VarNext] :
      ( v6409(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6408(VarNext,B)
          <=> v6419(VarNext,B) ) ) ) ).

fof(addAssignment_3141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6419(VarNext,B)
          <=> v6417(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_254,axiom,
    ! [VarCurr] :
      ( ~ v6420(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6417(VarCurr,B)
          <=> v50(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_257,axiom,
    ! [VarCurr] :
      ( v6420(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6417(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_444,axiom,
    ! [VarCurr] :
      ( ~ v6420(VarCurr)
    <=> v41(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1023,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6409(VarNext)
      <=> v6410(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1022,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6410(VarNext)
      <=> ( v6411(VarNext)
          & v6400(VarNext) ) ) ) ).

fof(writeUnaryOperator_443,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6411(VarNext)
      <=> v6413(VarNext) ) ) ).

fof(addAssignment_3140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6413(VarNext)
      <=> v6400(VarCurr) ) ) ).

fof(addAssignment_3139,axiom,
    ! [VarCurr] :
      ( v6400(VarCurr)
    <=> v6402(VarCurr) ) ).

fof(addAssignment_3138,axiom,
    ! [VarCurr] :
      ( v6402(VarCurr)
    <=> v6404(VarCurr) ) ).

fof(addAssignment_3137,axiom,
    ! [VarCurr] :
      ( v6404(VarCurr)
    <=> v6406(VarCurr) ) ).

fof(addAssignment_3136,axiom,
    ! [VarCurr] :
      ( v6406(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_3135,axiom,
    ! [VarCurr] :
      ( v50(VarCurr,bitIndex0)
    <=> v6385(VarCurr,bitIndex0) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_253,axiom,
    ! [VarCurr] :
      ( ~ v6386(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6385(VarCurr,B)
          <=> v6387(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_256,axiom,
    ! [VarCurr] :
      ( v6386(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6385(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_15,axiom,
    ! [VarCurr] :
      ( ( ~ v6388(VarCurr)
        & ~ v6390(VarCurr)
        & ~ v6394(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v6387(VarCurr,B)
          <=> v39(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_142,axiom,
    ! [VarCurr] :
      ( v6394(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6387(VarCurr,B)
          <=> v6396(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_169,axiom,
    ! [VarCurr] :
      ( v6390(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6387(VarCurr,B)
          <=> v6392(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_170,axiom,
    ! [VarCurr] :
      ( v6388(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6387(VarCurr,B)
          <=> v39(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_566,axiom,
    ! [VarCurr] :
      ( v6397(VarCurr)
    <=> ( ( v6398(VarCurr,bitIndex1)
        <=> $true )
        & ( v6398(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3134,axiom,
    ! [VarCurr] :
      ( v6398(VarCurr,bitIndex0)
    <=> v6365(VarCurr) ) ).

fof(addAssignment_3133,axiom,
    ! [VarCurr] :
      ( v6398(VarCurr,bitIndex1)
    <=> v52(VarCurr) ) ).

fof(addAssignment_3132,axiom,
    ! [VarCurr] :
      ( v6396(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_3131,axiom,
    ! [VarCurr,B] :
      ( range_3_1(B)
     => ( v6396(VarCurr,B)
      <=> v6384(VarCurr,B) ) ) ).

fof(range_axiom_37,axiom,
    ! [B] :
      ( range_3_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_565,axiom,
    ! [VarCurr] :
      ( v6394(VarCurr)
    <=> ( ( v6395(VarCurr,bitIndex1)
        <=> $true )
        & ( v6395(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3130,axiom,
    ! [VarCurr] :
      ( v6395(VarCurr,bitIndex0)
    <=> v6365(VarCurr) ) ).

fof(addAssignment_3129,axiom,
    ! [VarCurr] :
      ( v6395(VarCurr,bitIndex1)
    <=> v52(VarCurr) ) ).

fof(addAssignment_3128,axiom,
    ! [VarCurr] :
      ( ( v6392(VarCurr,bitIndex2)
      <=> v39(VarCurr,bitIndex3) )
      & ( v6392(VarCurr,bitIndex1)
      <=> v39(VarCurr,bitIndex2) )
      & ( v6392(VarCurr,bitIndex0)
      <=> v39(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_3127,axiom,
    ! [VarCurr] :
      ( v6392(VarCurr,bitIndex3)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_564,axiom,
    ! [VarCurr] :
      ( v6390(VarCurr)
    <=> ( ( v6391(VarCurr,bitIndex1)
        <=> $false )
        & ( v6391(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3126,axiom,
    ! [VarCurr] :
      ( v6391(VarCurr,bitIndex0)
    <=> v6365(VarCurr) ) ).

fof(addAssignment_3125,axiom,
    ! [VarCurr] :
      ( v6391(VarCurr,bitIndex1)
    <=> v52(VarCurr) ) ).

fof(addAssignmentInitValueVector_46,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v39(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_563,axiom,
    ! [VarCurr] :
      ( v6388(VarCurr)
    <=> ( ( v6389(VarCurr,bitIndex1)
        <=> $false )
        & ( v6389(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3124,axiom,
    ! [VarCurr] :
      ( v6389(VarCurr,bitIndex0)
    <=> v6365(VarCurr) ) ).

fof(addAssignment_3123,axiom,
    ! [VarCurr] :
      ( v6389(VarCurr,bitIndex1)
    <=> v52(VarCurr) ) ).

fof(writeUnaryOperator_442,axiom,
    ! [VarCurr] :
      ( ~ v6386(VarCurr)
    <=> v41(VarCurr) ) ).

fof(addAssignment_3122,axiom,
    ! [VarCurr] :
      ( v52(VarCurr)
    <=> v54(VarCurr) ) ).

fof(addAssignment_3121,axiom,
    ! [VarCurr] :
      ( v54(VarCurr)
    <=> v56(VarCurr) ) ).

fof(addAssignment_3120,axiom,
    ! [VarCurr] :
      ( v56(VarCurr)
    <=> v58(VarCurr) ) ).

fof(addAssignment_3119,axiom,
    ! [VarCurr] :
      ( v58(VarCurr)
    <=> v60(VarCurr) ) ).

fof(addAssignment_3118,axiom,
    ! [VarCurr] :
      ( v60(VarCurr)
    <=> v62(VarCurr) ) ).

fof(addAssignment_3117,axiom,
    ! [VarCurr] :
      ( v62(VarCurr)
    <=> v64(VarCurr) ) ).

fof(addAssignment_3116,axiom,
    ! [VarCurr] :
      ( v64(VarCurr)
    <=> v66(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6342(VarNext)
       => ( v66(VarNext)
        <=> v66(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_58,axiom,
    ! [VarNext] :
      ( v6342(VarNext)
     => ( v66(VarNext)
      <=> v6352(VarNext) ) ) ).

fof(addAssignment_3115,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6352(VarNext)
      <=> v6350(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_252,axiom,
    ! [VarCurr] :
      ( ~ v6353(VarCurr)
     => ( v6350(VarCurr)
      <=> v6354(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_255,axiom,
    ! [VarCurr] :
      ( v6353(VarCurr)
     => ( v6350(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_251,axiom,
    ! [VarCurr] :
      ( ~ v6355(VarCurr)
     => ( v6354(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_254,axiom,
    ! [VarCurr] :
      ( v6355(VarCurr)
     => ( v6354(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1021,axiom,
    ! [VarCurr] :
      ( v6355(VarCurr)
    <=> ( v6356(VarCurr)
        | v6360(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_622,axiom,
    ! [VarCurr] :
      ( v6360(VarCurr)
    <=> ( v6(VarCurr,bitIndex9)
        & v6361(VarCurr) ) ) ).

fof(writeUnaryOperator_441,axiom,
    ! [VarCurr] :
      ( ~ v6361(VarCurr)
    <=> v19(VarCurr,bitIndex9) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1020,axiom,
    ! [VarCurr] :
      ( v6356(VarCurr)
    <=> ( v6357(VarCurr)
        | v6334(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1019,axiom,
    ! [VarCurr] :
      ( v6357(VarCurr)
    <=> ( v6358(VarCurr)
        | v6329(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1018,axiom,
    ! [VarCurr] :
      ( v6358(VarCurr)
    <=> ( v6359(VarCurr)
        | v2569(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1017,axiom,
    ! [VarCurr] :
      ( v6359(VarCurr)
    <=> ( v69(VarCurr)
        | v6324(VarCurr) ) ) ).

fof(writeUnaryOperator_440,axiom,
    ! [VarCurr] :
      ( ~ v6353(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1016,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6342(VarNext)
      <=> v6343(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1015,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6343(VarNext)
      <=> ( v6344(VarNext)
          & v6339(VarNext) ) ) ) ).

fof(writeUnaryOperator_439,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6344(VarNext)
      <=> v6346(VarNext) ) ) ).

fof(addAssignment_3114,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6346(VarNext)
      <=> v6339(VarCurr) ) ) ).

fof(addAssignment_3113,axiom,
    ! [VarCurr] :
      ( v6339(VarCurr)
    <=> v1853(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_621,axiom,
    ! [VarCurr] :
      ( v6334(VarCurr)
    <=> ( v6(VarCurr,bitIndex8)
        & v6336(VarCurr) ) ) ).

fof(writeUnaryOperator_438,axiom,
    ! [VarCurr] :
      ( ~ v6336(VarCurr)
    <=> v6337(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_620,axiom,
    ! [VarCurr] :
      ( v6337(VarCurr)
    <=> ( v19(VarCurr,bitIndex8)
        | v19(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_619,axiom,
    ! [VarCurr] :
      ( v6329(VarCurr)
    <=> ( v6(VarCurr,bitIndex5)
        & v6331(VarCurr) ) ) ).

fof(writeUnaryOperator_437,axiom,
    ! [VarCurr] :
      ( ~ v6331(VarCurr)
    <=> v6332(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_618,axiom,
    ! [VarCurr] :
      ( v6332(VarCurr)
    <=> ( v19(VarCurr,bitIndex5)
        | v19(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_617,axiom,
    ! [VarCurr] :
      ( v6324(VarCurr)
    <=> ( v6(VarCurr,bitIndex2)
        & v6326(VarCurr) ) ) ).

fof(writeUnaryOperator_436,axiom,
    ! [VarCurr] :
      ( ~ v6326(VarCurr)
    <=> v6327(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_616,axiom,
    ! [VarCurr] :
      ( v6327(VarCurr)
    <=> ( v19(VarCurr,bitIndex2)
        | v19(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_3112,axiom,
    ! [VarCurr] :
      ( v69(VarCurr)
    <=> v19(VarCurr,bitIndex3) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_120,axiom,
    ! [VarCurr] :
      ( ~ v6312(VarCurr)
     => ( v19(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_117,axiom,
    ! [VarCurr] :
      ( v6312(VarCurr)
     => ( v19(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1014,axiom,
    ! [VarCurr] :
      ( v6312(VarCurr)
    <=> ( v6313(VarCurr)
        | v6321(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1013,axiom,
    ! [VarCurr] :
      ( v6321(VarCurr)
    <=> ( v6322(VarCurr)
        & v6246(VarCurr) ) ) ).

fof(writeUnaryOperator_435,axiom,
    ! [VarCurr] :
      ( ~ v6322(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1012,axiom,
    ! [VarCurr] :
      ( v6313(VarCurr)
    <=> ( v6314(VarCurr)
        | v6319(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1011,axiom,
    ! [VarCurr] :
      ( v6319(VarCurr)
    <=> ( v6320(VarCurr)
        & v2927(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1010,axiom,
    ! [VarCurr] :
      ( v6320(VarCurr)
    <=> ( v6244(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1009,axiom,
    ! [VarCurr] :
      ( v6314(VarCurr)
    <=> ( v6315(VarCurr)
        | v6317(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1008,axiom,
    ! [VarCurr] :
      ( v6317(VarCurr)
    <=> ( v6318(VarCurr)
        & v2924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1007,axiom,
    ! [VarCurr] :
      ( v6318(VarCurr)
    <=> ( v6244(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1006,axiom,
    ! [VarCurr] :
      ( v6315(VarCurr)
    <=> ( v6316(VarCurr)
        & v2921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1005,axiom,
    ! [VarCurr] :
      ( v6316(VarCurr)
    <=> ( v6244(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(addAssignment_3111,axiom,
    ! [VarCurr] :
      ( v71(VarCurr)
    <=> v73(VarCurr) ) ).

fof(addAssignment_3110,axiom,
    ! [VarCurr] :
      ( v73(VarCurr)
    <=> v75(VarCurr,bitIndex0) ) ).

fof(addAssignment_3109,axiom,
    ! [VarCurr] :
      ( v75(VarCurr,bitIndex0)
    <=> v2588(VarCurr,bitIndex0) ) ).

fof(addAssignment_3108,axiom,
    ! [VarCurr] :
      ( v2582(VarCurr,bitIndex0)
    <=> v2586(VarCurr,bitIndex0) ) ).

fof(addAssignment_3107,axiom,
    ! [VarCurr] :
      ( v2575(VarCurr,bitIndex0)
    <=> v2579(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_434,axiom,
    ! [VarCurr] :
      ( ~ v77(VarCurr)
    <=> v6310(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_615,axiom,
    ! [VarCurr] :
      ( v6310(VarCurr)
    <=> ( v6272(VarCurr)
        | v79(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_108,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v79(VarCurr,B)
      <=> ( v81(VarCurr,B)
          & v5748(VarCurr,B) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_50,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6285(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v5748(VarNext,B)
            <=> v5748(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_57,axiom,
    ! [VarNext] :
      ( v6285(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v5748(VarNext,B)
          <=> v6304(VarNext,B) ) ) ) ).

fof(addAssignment_3106,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v6304(VarNext,B)
          <=> v6302(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_168,axiom,
    ! [VarCurr] :
      ( ~ v6296(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v6302(VarCurr,B)
          <=> v6305(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_169,axiom,
    ! [VarCurr] :
      ( v6296(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v6302(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_167,axiom,
    ! [VarCurr] :
      ( ~ v5752(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v6305(VarCurr,B)
          <=> v2577(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_168,axiom,
    ! [VarCurr] :
      ( v5752(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v6305(VarCurr,B)
          <=> v2584(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1004,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6285(VarNext)
      <=> ( v6286(VarNext)
          & v6295(VarNext) ) ) ) ).

fof(addAssignment_3105,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6295(VarNext)
      <=> v6293(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1003,axiom,
    ! [VarCurr] :
      ( v6293(VarCurr)
    <=> ( v6296(VarCurr)
        | v6297(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1002,axiom,
    ! [VarCurr] :
      ( v6297(VarCurr)
    <=> ( v6298(VarCurr)
        & v6301(VarCurr) ) ) ).

fof(writeUnaryOperator_433,axiom,
    ! [VarCurr] :
      ( ~ v6301(VarCurr)
    <=> v6296(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1001,axiom,
    ! [VarCurr] :
      ( v6298(VarCurr)
    <=> ( v5752(VarCurr)
        | v6299(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1000,axiom,
    ! [VarCurr] :
      ( v6299(VarCurr)
    <=> ( v6275(VarCurr)
        & v6300(VarCurr) ) ) ).

fof(writeUnaryOperator_432,axiom,
    ! [VarCurr] :
      ( ~ v6300(VarCurr)
    <=> v5752(VarCurr) ) ).

fof(writeUnaryOperator_431,axiom,
    ! [VarCurr] :
      ( ~ v6296(VarCurr)
    <=> v5750(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_999,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6286(VarNext)
      <=> ( v6287(VarNext)
          & v6282(VarNext) ) ) ) ).

fof(writeUnaryOperator_430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6287(VarNext)
      <=> v6289(VarNext) ) ) ).

fof(addAssignment_3104,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6289(VarNext)
      <=> v6282(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_45,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v5748(constB0,B)
      <=> $true ) ) ).

fof(addAssignment_3103,axiom,
    ! [VarCurr] :
      ( v6282(VarCurr)
    <=> v1853(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_998,axiom,
    ! [VarCurr] :
      ( v6275(VarCurr)
    <=> ( v6277(VarCurr)
        & v6280(VarCurr) ) ) ).

fof(writeUnaryOperator_429,axiom,
    ! [VarCurr] :
      ( ~ v6280(VarCurr)
    <=> v5754(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_614,axiom,
    ! [VarCurr] :
      ( v6277(VarCurr)
    <=> ( v6279(VarCurr)
        | v81(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_613,axiom,
    ! [VarCurr] :
      ( v6279(VarCurr)
    <=> ( v81(VarCurr,bitIndex0)
        | v81(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_997,axiom,
    ! [VarCurr] :
      ( v5752(VarCurr)
    <=> ( v6270(VarCurr)
        & v6273(VarCurr) ) ) ).

fof(writeUnaryOperator_428,axiom,
    ! [VarCurr] :
      ( ~ v6273(VarCurr)
    <=> v5754(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_612,axiom,
    ! [VarCurr] :
      ( v6270(VarCurr)
    <=> ( v6272(VarCurr)
        | v79(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_611,axiom,
    ! [VarCurr] :
      ( v6272(VarCurr)
    <=> ( v79(VarCurr,bitIndex0)
        | v79(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_3102,axiom,
    ! [VarCurr] :
      ( v5754(VarCurr)
    <=> v5756(VarCurr) ) ).

fof(addAssignment_3101,axiom,
    ! [VarCurr] :
      ( v5756(VarCurr)
    <=> v5758(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_996,axiom,
    ! [VarCurr] :
      ( v5758(VarCurr)
    <=> ( v6264(VarCurr)
        | v21(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_610,axiom,
    ! [VarCurr] :
      ( v6264(VarCurr)
    <=> ( v6265(VarCurr)
        | v19(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_609,axiom,
    ! [VarCurr] :
      ( v6265(VarCurr)
    <=> ( v6266(VarCurr)
        | v19(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_608,axiom,
    ! [VarCurr] :
      ( v6266(VarCurr)
    <=> ( v6267(VarCurr)
        | v19(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_607,axiom,
    ! [VarCurr] :
      ( v6267(VarCurr)
    <=> ( v6268(VarCurr)
        | v19(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_606,axiom,
    ! [VarCurr] :
      ( v6268(VarCurr)
    <=> ( v19(VarCurr,bitIndex2)
        | v19(VarCurr,bitIndex5) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_119,axiom,
    ! [VarCurr] :
      ( ~ v6249(VarCurr)
     => ( v19(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_116,axiom,
    ! [VarCurr] :
      ( v6249(VarCurr)
     => ( v19(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_995,axiom,
    ! [VarCurr] :
      ( v6249(VarCurr)
    <=> ( v6250(VarCurr)
        | v6262(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_994,axiom,
    ! [VarCurr] :
      ( v6262(VarCurr)
    <=> ( v21(VarCurr)
        & v2930(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_993,axiom,
    ! [VarCurr] :
      ( v6250(VarCurr)
    <=> ( v6251(VarCurr)
        | v6260(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_992,axiom,
    ! [VarCurr] :
      ( v6260(VarCurr)
    <=> ( v6261(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_991,axiom,
    ! [VarCurr] :
      ( v6261(VarCurr)
    <=> ( v2914(VarCurr)
        & v2920(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_990,axiom,
    ! [VarCurr] :
      ( v6251(VarCurr)
    <=> ( v6252(VarCurr)
        | v6258(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_989,axiom,
    ! [VarCurr] :
      ( v6258(VarCurr)
    <=> ( v6259(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_988,axiom,
    ! [VarCurr] :
      ( v6259(VarCurr)
    <=> ( v5861(VarCurr)
        & v2920(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_987,axiom,
    ! [VarCurr] :
      ( v6252(VarCurr)
    <=> ( v6253(VarCurr)
        | v6256(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_986,axiom,
    ! [VarCurr] :
      ( v6256(VarCurr)
    <=> ( v6257(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_985,axiom,
    ! [VarCurr] :
      ( v6257(VarCurr)
    <=> ( v5861(VarCurr)
        & v2920(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_984,axiom,
    ! [VarCurr] :
      ( v6253(VarCurr)
    <=> ( v6254(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_983,axiom,
    ! [VarCurr] :
      ( v6254(VarCurr)
    <=> ( v5861(VarCurr)
        & v2920(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_118,axiom,
    ! [VarCurr] :
      ( ~ v6228(VarCurr)
     => ( v19(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_115,axiom,
    ! [VarCurr] :
      ( v6228(VarCurr)
     => ( v19(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_982,axiom,
    ! [VarCurr] :
      ( v6228(VarCurr)
    <=> ( v6229(VarCurr)
        | v6245(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_981,axiom,
    ! [VarCurr] :
      ( v6245(VarCurr)
    <=> ( v21(VarCurr)
        & v6246(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_562,axiom,
    ! [VarCurr] :
      ( v6246(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_980,axiom,
    ! [VarCurr] :
      ( v6229(VarCurr)
    <=> ( v6230(VarCurr)
        | v6241(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_979,axiom,
    ! [VarCurr] :
      ( v6241(VarCurr)
    <=> ( v6242(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_978,axiom,
    ! [VarCurr] :
      ( v6242(VarCurr)
    <=> ( v6244(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_977,axiom,
    ! [VarCurr] :
      ( v6244(VarCurr)
    <=> ( v5822(VarCurr)
        & v2893(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_976,axiom,
    ! [VarCurr] :
      ( v6230(VarCurr)
    <=> ( v6231(VarCurr)
        | v6239(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_975,axiom,
    ! [VarCurr] :
      ( v6239(VarCurr)
    <=> ( v6240(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_974,axiom,
    ! [VarCurr] :
      ( v6240(VarCurr)
    <=> ( v6235(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_973,axiom,
    ! [VarCurr] :
      ( v6231(VarCurr)
    <=> ( v6232(VarCurr)
        | v6237(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_972,axiom,
    ! [VarCurr] :
      ( v6237(VarCurr)
    <=> ( v6238(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_971,axiom,
    ! [VarCurr] :
      ( v6238(VarCurr)
    <=> ( v6235(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_970,axiom,
    ! [VarCurr] :
      ( v6232(VarCurr)
    <=> ( v6233(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_969,axiom,
    ! [VarCurr] :
      ( v6233(VarCurr)
    <=> ( v6235(VarCurr)
        & v6236(VarCurr) ) ) ).

fof(writeUnaryOperator_427,axiom,
    ! [VarCurr] :
      ( ~ v6236(VarCurr)
    <=> v2597(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_968,axiom,
    ! [VarCurr] :
      ( v6235(VarCurr)
    <=> ( v5831(VarCurr)
        & v2893(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_117,axiom,
    ! [VarCurr] :
      ( ~ v6213(VarCurr)
     => ( v19(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_114,axiom,
    ! [VarCurr] :
      ( v6213(VarCurr)
     => ( v19(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_967,axiom,
    ! [VarCurr] :
      ( v6213(VarCurr)
    <=> ( v6214(VarCurr)
        | v6223(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_966,axiom,
    ! [VarCurr] :
      ( v6223(VarCurr)
    <=> ( v6224(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(addAssignment_3100,axiom,
    ! [VarCurr] :
      ( v6224(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_965,axiom,
    ! [VarCurr] :
      ( v6214(VarCurr)
    <=> ( v6215(VarCurr)
        | v6221(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_964,axiom,
    ! [VarCurr] :
      ( v6221(VarCurr)
    <=> ( v6222(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_963,axiom,
    ! [VarCurr] :
      ( v6222(VarCurr)
    <=> ( v21(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_962,axiom,
    ! [VarCurr] :
      ( v6215(VarCurr)
    <=> ( v6216(VarCurr)
        | v6219(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_961,axiom,
    ! [VarCurr] :
      ( v6219(VarCurr)
    <=> ( v6220(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_960,axiom,
    ! [VarCurr] :
      ( v6220(VarCurr)
    <=> ( v21(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_959,axiom,
    ! [VarCurr] :
      ( v6216(VarCurr)
    <=> ( v6217(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_958,axiom,
    ! [VarCurr] :
      ( v6217(VarCurr)
    <=> ( v21(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_116,axiom,
    ! [VarCurr] :
      ( ~ v6206(VarCurr)
     => ( v19(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_113,axiom,
    ! [VarCurr] :
      ( v6206(VarCurr)
     => ( v19(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_957,axiom,
    ! [VarCurr] :
      ( v6206(VarCurr)
    <=> ( v6207(VarCurr)
        | v6208(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_956,axiom,
    ! [VarCurr] :
      ( v6208(VarCurr)
    <=> ( v6209(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeUnaryOperator_426,axiom,
    ! [VarCurr] :
      ( ~ v6209(VarCurr)
    <=> v5760(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_561,axiom,
    ! [VarCurr] :
      ( v6207(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex7) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_115,axiom,
    ! [VarCurr] :
      ( ~ v6201(VarCurr)
     => ( v19(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_112,axiom,
    ! [VarCurr] :
      ( v6201(VarCurr)
     => ( v19(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_955,axiom,
    ! [VarCurr] :
      ( v6201(VarCurr)
    <=> ( v6202(VarCurr)
        | v6203(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_954,axiom,
    ! [VarCurr] :
      ( v6203(VarCurr)
    <=> ( v6204(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeUnaryOperator_425,axiom,
    ! [VarCurr] :
      ( ~ v6204(VarCurr)
    <=> v5760(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_560,axiom,
    ! [VarCurr] :
      ( v6202(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex4) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_114,axiom,
    ! [VarCurr] :
      ( ~ v6195(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_111,axiom,
    ! [VarCurr] :
      ( v6195(VarCurr)
     => ( v19(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_953,axiom,
    ! [VarCurr] :
      ( v6195(VarCurr)
    <=> ( v6196(VarCurr)
        | v6197(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_952,axiom,
    ! [VarCurr] :
      ( v6197(VarCurr)
    <=> ( v6198(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeUnaryOperator_424,axiom,
    ! [VarCurr] :
      ( ~ v6198(VarCurr)
    <=> v5760(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_559,axiom,
    ! [VarCurr] :
      ( v6196(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_3099,axiom,
    ! [VarCurr] :
      ( v5760(VarCurr)
    <=> v5762(VarCurr) ) ).

fof(addAssignment_3098,axiom,
    ! [VarCurr] :
      ( v5762(VarCurr)
    <=> v5764(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_951,axiom,
    ! [VarCurr] :
      ( v5764(VarCurr)
    <=> ( v5766(VarCurr)
        & v6192(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_605,axiom,
    ! [VarCurr] :
      ( v6192(VarCurr)
    <=> ( v5911(VarCurr,bitIndex2)
        | v5911(VarCurr,bitIndex4) ) ) ).

fof(addAssignment_3097,axiom,
    ! [VarCurr] :
      ( v5766(VarCurr)
    <=> v5768(VarCurr) ) ).

fof(addAssignment_3096,axiom,
    ! [VarCurr] :
      ( v5768(VarCurr)
    <=> v5770(VarCurr) ) ).

fof(addAssignment_3095,axiom,
    ! [VarCurr] :
      ( v5770(VarCurr)
    <=> v5772(VarCurr) ) ).

fof(addAssignment_3094,axiom,
    ! [VarCurr] :
      ( v5772(VarCurr)
    <=> v5774(VarCurr) ) ).

fof(addAssignment_3093,axiom,
    ! [VarCurr] :
      ( v5774(VarCurr)
    <=> v5776(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6179(VarNext)
       => ( v5776(VarNext)
        <=> v5776(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_56,axiom,
    ! [VarNext] :
      ( v6179(VarNext)
     => ( v5776(VarNext)
      <=> v6187(VarNext) ) ) ).

fof(addAssignment_3092,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6187(VarNext)
      <=> v6185(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_250,axiom,
    ! [VarCurr] :
      ( ~ v6188(VarCurr)
     => ( v6185(VarCurr)
      <=> v5782(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_253,axiom,
    ! [VarCurr] :
      ( v6188(VarCurr)
     => ( v6185(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_423,axiom,
    ! [VarCurr] :
      ( ~ v6188(VarCurr)
    <=> v5778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_950,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6179(VarNext)
      <=> v6180(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_949,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6180(VarNext)
      <=> ( v6181(VarNext)
          & v6079(VarNext) ) ) ) ).

fof(writeUnaryOperator_422,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6181(VarNext)
      <=> v6088(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_249,axiom,
    ! [VarCurr] :
      ( ~ v6138(VarCurr)
     => ( v5782(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_252,axiom,
    ! [VarCurr] :
      ( v6138(VarCurr)
     => ( v5782(VarCurr)
      <=> v6162(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_166,axiom,
    ! [VarCurr] :
      ( ~ v6099(VarCurr)
     => ( v6162(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_167,axiom,
    ! [VarCurr] :
      ( v6099(VarCurr)
     => ( v6162(VarCurr)
      <=> v6163(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_948,axiom,
    ! [VarCurr] :
      ( v6169(VarCurr)
    <=> ( v6171(VarCurr)
        | v6151(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_947,axiom,
    ! [VarCurr] :
      ( v6171(VarCurr)
    <=> ( v6172(VarCurr)
        | v6150(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_946,axiom,
    ! [VarCurr] :
      ( v6172(VarCurr)
    <=> ( v6173(VarCurr)
        | v6149(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_945,axiom,
    ! [VarCurr] :
      ( v6173(VarCurr)
    <=> ( v6174(VarCurr)
        | v6119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_944,axiom,
    ! [VarCurr] :
      ( v6174(VarCurr)
    <=> ( v6175(VarCurr)
        | v6118(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_943,axiom,
    ! [VarCurr] :
      ( v6175(VarCurr)
    <=> ( v6176(VarCurr)
        | v6117(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_942,axiom,
    ! [VarCurr] :
      ( v6176(VarCurr)
    <=> ( v6102(VarCurr)
        | v6116(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_941,axiom,
    ! [VarCurr] :
      ( v6102(VarCurr)
    <=> ( v6103(VarCurr)
        | v6108(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_248,axiom,
    ! [VarCurr] :
      ( ~ v5788(VarCurr)
     => ( v6163(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_251,axiom,
    ! [VarCurr] :
      ( v5788(VarCurr)
     => ( v6163(VarCurr)
      <=> v6164(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_247,axiom,
    ! [VarCurr] :
      ( ~ v6165(VarCurr)
     => ( v6164(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_250,axiom,
    ! [VarCurr] :
      ( v6165(VarCurr)
     => ( v6164(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_940,axiom,
    ! [VarCurr] :
      ( v6165(VarCurr)
    <=> ( v6166(VarCurr)
        & v6077(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_939,axiom,
    ! [VarCurr] :
      ( v6166(VarCurr)
    <=> ( v6167(VarCurr)
        | v6168(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_558,axiom,
    ! [VarCurr] :
      ( v6168(VarCurr)
    <=> ( ( v6040(VarCurr,bitIndex3)
        <=> $true )
        & ( v6040(VarCurr,bitIndex2)
        <=> $true )
        & ( v6040(VarCurr,bitIndex1)
        <=> $false )
        & ( v6040(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_557,axiom,
    ! [VarCurr] :
      ( v6167(VarCurr)
    <=> ( ( v6040(VarCurr,bitIndex3)
        <=> $false )
        & ( v6040(VarCurr,bitIndex2)
        <=> $true )
        & ( v6040(VarCurr,bitIndex1)
        <=> $false )
        & ( v6040(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_938,axiom,
    ! [VarCurr] :
      ( v6138(VarCurr)
    <=> ( v6139(VarCurr)
        | v6151(VarCurr) ) ) ).

fof(writeUnaryOperator_421,axiom,
    ! [VarCurr] :
      ( ~ v6151(VarCurr)
    <=> v6152(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_937,axiom,
    ! [VarCurr] :
      ( v6152(VarCurr)
    <=> ( v6153(VarCurr)
        | v6120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_936,axiom,
    ! [VarCurr] :
      ( v6153(VarCurr)
    <=> ( v6154(VarCurr)
        | v6119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_935,axiom,
    ! [VarCurr] :
      ( v6154(VarCurr)
    <=> ( v6155(VarCurr)
        | v6118(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_934,axiom,
    ! [VarCurr] :
      ( v6155(VarCurr)
    <=> ( v6156(VarCurr)
        | v6117(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_933,axiom,
    ! [VarCurr] :
      ( v6156(VarCurr)
    <=> ( v6157(VarCurr)
        | v6116(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_932,axiom,
    ! [VarCurr] :
      ( v6157(VarCurr)
    <=> ( v6158(VarCurr)
        | v6109(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_931,axiom,
    ! [VarCurr] :
      ( v6158(VarCurr)
    <=> ( v6159(VarCurr)
        | v6108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_930,axiom,
    ! [VarCurr] :
      ( v6159(VarCurr)
    <=> ( v6160(VarCurr)
        | v6107(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_929,axiom,
    ! [VarCurr] :
      ( v6160(VarCurr)
    <=> ( v6161(VarCurr)
        | v6106(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_928,axiom,
    ! [VarCurr] :
      ( v6161(VarCurr)
    <=> ( v6099(VarCurr)
        | v6105(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_927,axiom,
    ! [VarCurr] :
      ( v6139(VarCurr)
    <=> ( v6140(VarCurr)
        | v6150(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_926,axiom,
    ! [VarCurr] :
      ( v6150(VarCurr)
    <=> ( v6122(VarCurr)
        & v6120(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_925,axiom,
    ! [VarCurr] :
      ( v6140(VarCurr)
    <=> ( v6141(VarCurr)
        | v6119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_924,axiom,
    ! [VarCurr] :
      ( v6141(VarCurr)
    <=> ( v6142(VarCurr)
        | v6118(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_923,axiom,
    ! [VarCurr] :
      ( v6142(VarCurr)
    <=> ( v6143(VarCurr)
        | v6117(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_922,axiom,
    ! [VarCurr] :
      ( v6143(VarCurr)
    <=> ( v6144(VarCurr)
        | v6116(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_921,axiom,
    ! [VarCurr] :
      ( v6144(VarCurr)
    <=> ( v6145(VarCurr)
        | v6149(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_920,axiom,
    ! [VarCurr] :
      ( v6149(VarCurr)
    <=> ( v6111(VarCurr)
        & v6109(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_919,axiom,
    ! [VarCurr] :
      ( v6145(VarCurr)
    <=> ( v6146(VarCurr)
        | v6108(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_918,axiom,
    ! [VarCurr] :
      ( v6146(VarCurr)
    <=> ( v6147(VarCurr)
        | v6107(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_917,axiom,
    ! [VarCurr] :
      ( v6147(VarCurr)
    <=> ( v6148(VarCurr)
        | v6106(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_916,axiom,
    ! [VarCurr] :
      ( v6148(VarCurr)
    <=> ( v6099(VarCurr)
        | v6105(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_48,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6125(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v5784(VarNext,B)
            <=> v5784(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_55,axiom,
    ! [VarNext] :
      ( v6125(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5784(VarNext,B)
          <=> v6133(VarNext,B) ) ) ) ).

fof(addAssignment_3091,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6133(VarNext,B)
          <=> v6131(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_246,axiom,
    ! [VarCurr] :
      ( ~ v6134(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6131(VarCurr,B)
          <=> v5786(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_249,axiom,
    ! [VarCurr] :
      ( v6134(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6131(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_420,axiom,
    ! [VarCurr] :
      ( ~ v6134(VarCurr)
    <=> v5778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_915,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6125(VarNext)
      <=> v6126(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_914,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6126(VarNext)
      <=> ( v6127(VarNext)
          & v6079(VarNext) ) ) ) ).

fof(writeUnaryOperator_419,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6127(VarNext)
      <=> v6088(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_2,axiom,
    ! [VarCurr] :
      ( ( ~ v6099(VarCurr)
        & ~ v6101(VarCurr)
        & ~ v6109(VarCurr)
        & ~ v6112(VarCurr)
        & ~ v6120(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v5786(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_3,axiom,
    ! [VarCurr] :
      ( v6120(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5786(VarCurr,B)
          <=> v6121(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_14,axiom,
    ! [VarCurr] :
      ( v6112(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5786(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_141,axiom,
    ! [VarCurr] :
      ( v6109(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5786(VarCurr,B)
          <=> v6110(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_165,axiom,
    ! [VarCurr] :
      ( v6101(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5786(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_166,axiom,
    ! [VarCurr] :
      ( v6099(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5786(VarCurr,B)
          <=> v6100(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_245,axiom,
    ! [VarCurr] :
      ( ~ v6122(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6121(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_248,axiom,
    ! [VarCurr] :
      ( v6122(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6121(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_418,axiom,
    ! [VarCurr] :
      ( ~ v6122(VarCurr)
    <=> v6075(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_556,axiom,
    ! [VarCurr] :
      ( v6120(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $true )
        & ( v5784(VarCurr,bitIndex2)
        <=> $true )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_913,axiom,
    ! [VarCurr] :
      ( v6112(VarCurr)
    <=> ( v6114(VarCurr)
        | v6119(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_555,axiom,
    ! [VarCurr] :
      ( v6119(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $true )
        & ( v5784(VarCurr,bitIndex2)
        <=> $true )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_912,axiom,
    ! [VarCurr] :
      ( v6114(VarCurr)
    <=> ( v6115(VarCurr)
        | v6118(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_554,axiom,
    ! [VarCurr] :
      ( v6118(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $true )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $true )
        & ( v5784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_911,axiom,
    ! [VarCurr] :
      ( v6115(VarCurr)
    <=> ( v6116(VarCurr)
        | v6117(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_553,axiom,
    ! [VarCurr] :
      ( v6117(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $true )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $true )
        & ( v5784(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_552,axiom,
    ! [VarCurr] :
      ( v6116(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $true )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_244,axiom,
    ! [VarCurr] :
      ( ~ v6111(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6110(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_247,axiom,
    ! [VarCurr] :
      ( v6111(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6110(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_417,axiom,
    ! [VarCurr] :
      ( ~ v6111(VarCurr)
    <=> v6075(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_551,axiom,
    ! [VarCurr] :
      ( v6109(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $false )
        & ( v5784(VarCurr,bitIndex2)
        <=> $true )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_910,axiom,
    ! [VarCurr] :
      ( v6101(VarCurr)
    <=> ( v6103(VarCurr)
        | v6108(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_550,axiom,
    ! [VarCurr] :
      ( v6108(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $false )
        & ( v5784(VarCurr,bitIndex2)
        <=> $true )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_909,axiom,
    ! [VarCurr] :
      ( v6103(VarCurr)
    <=> ( v6104(VarCurr)
        | v6107(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_549,axiom,
    ! [VarCurr] :
      ( v6107(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $false )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $true )
        & ( v5784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_908,axiom,
    ! [VarCurr] :
      ( v6104(VarCurr)
    <=> ( v6105(VarCurr)
        | v6106(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_548,axiom,
    ! [VarCurr] :
      ( v6106(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $false )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $true )
        & ( v5784(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_547,axiom,
    ! [VarCurr] :
      ( v6105(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $false )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_243,axiom,
    ! [VarCurr] :
      ( ~ v5788(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6100(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_246,axiom,
    ! [VarCurr] :
      ( v5788(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6100(VarCurr,B)
          <=> v6040(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_546,axiom,
    ! [VarCurr] :
      ( v6099(VarCurr)
    <=> ( ( v5784(VarCurr,bitIndex3)
        <=> $false )
        & ( v5784(VarCurr,bitIndex2)
        <=> $false )
        & ( v5784(VarCurr,bitIndex1)
        <=> $false )
        & ( v5784(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignmentInitValueVector_44,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v5784(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_47,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6084(VarNext)
       => ( v6075(VarNext)
        <=> v6075(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_54,axiom,
    ! [VarNext] :
      ( v6084(VarNext)
     => ( v6075(VarNext)
      <=> v6094(VarNext) ) ) ).

fof(addAssignment_3090,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6094(VarNext)
      <=> v6092(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_242,axiom,
    ! [VarCurr] :
      ( ~ v6095(VarCurr)
     => ( v6092(VarCurr)
      <=> v6077(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_245,axiom,
    ! [VarCurr] :
      ( v6095(VarCurr)
     => ( v6092(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_416,axiom,
    ! [VarCurr] :
      ( ~ v6095(VarCurr)
    <=> v5778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_907,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6084(VarNext)
      <=> v6085(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_906,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6085(VarNext)
      <=> ( v6086(VarNext)
          & v6079(VarNext) ) ) ) ).

fof(writeUnaryOperator_415,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6086(VarNext)
      <=> v6088(VarNext) ) ) ).

fof(addAssignment_3089,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6088(VarNext)
      <=> v6079(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_43,axiom,
    ( v6075(constB0)
  <=> $false ) ).

fof(addAssignment_3088,axiom,
    ! [VarCurr] :
      ( v6079(VarCurr)
    <=> v6081(VarCurr) ) ).

fof(addAssignment_3087,axiom,
    ! [VarCurr] :
      ( v6081(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addAssignment_3086,axiom,
    ! [VarCurr] :
      ( v6077(VarCurr)
    <=> $false ) ).

fof(addAssignment_3085,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v6040(VarCurr,B)
      <=> v6042(VarCurr,B) ) ) ).

fof(addAssignment_3084,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v6042(VarCurr,B)
      <=> v6044(VarCurr,B) ) ) ).

fof(addAssignment_3083,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v6044(VarCurr,B)
      <=> v6046(VarCurr,B) ) ) ).

fof(addAssignment_3082,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v6046(VarCurr,B)
      <=> v6048(VarCurr,B) ) ) ).

fof(addAssignment_3081,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v6048(VarCurr,B)
      <=> v6050(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_46,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6053(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v6050(VarNext,B)
            <=> v6050(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_53,axiom,
    ! [VarNext] :
      ( v6053(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6050(VarNext,B)
          <=> v6070(VarNext,B) ) ) ) ).

fof(addAssignment_3080,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6070(VarNext,B)
          <=> v6068(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_164,axiom,
    ! [VarCurr] :
      ( ~ v6062(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6068(VarCurr,B)
          <=> v6071(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_165,axiom,
    ! [VarCurr] :
      ( v6062(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v6068(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_163,axiom,
    ! [VarCurr] :
      ( ~ v5802(VarCurr,bitIndex3)
     => ! [B] :
          ( range_3_0(B)
         => ( v6071(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_164,axiom,
    ! [VarCurr] :
      ( v5802(VarCurr,bitIndex3)
     => ! [B] :
          ( range_3_0(B)
         => ( v6071(VarCurr,B)
          <=> b1100(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_905,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6053(VarNext)
      <=> ( v6054(VarNext)
          & v6061(VarNext) ) ) ) ).

fof(addAssignment_3079,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6061(VarNext)
      <=> v6059(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_904,axiom,
    ! [VarCurr] :
      ( v6059(VarCurr)
    <=> ( v6062(VarCurr)
        | v6063(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_903,axiom,
    ! [VarCurr] :
      ( v6063(VarCurr)
    <=> ( v6064(VarCurr)
        & v6067(VarCurr) ) ) ).

fof(writeUnaryOperator_414,axiom,
    ! [VarCurr] :
      ( ~ v6067(VarCurr)
    <=> v6062(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_604,axiom,
    ! [VarCurr] :
      ( v6064(VarCurr)
    <=> ( v5802(VarCurr,bitIndex3)
        | v6065(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_603,axiom,
    ! [VarCurr] :
      ( v6065(VarCurr)
    <=> ( v5802(VarCurr,bitIndex1)
        & v6066(VarCurr) ) ) ).

fof(writeUnaryOperator_413,axiom,
    ! [VarCurr] :
      ( ~ v6066(VarCurr)
    <=> v5802(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_412,axiom,
    ! [VarCurr] :
      ( ~ v6062(VarCurr)
    <=> v5800(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_902,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6054(VarNext)
      <=> ( v6055(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_411,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6055(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(addAssignment_3078,axiom,
    ! [VarCurr] :
      ( v5788(VarCurr)
    <=> v5790(VarCurr) ) ).

fof(addAssignment_3077,axiom,
    ! [VarCurr] :
      ( v5790(VarCurr)
    <=> v5792(VarCurr) ) ).

fof(addAssignment_3076,axiom,
    ! [VarCurr] :
      ( v5792(VarCurr)
    <=> v5794(VarCurr) ) ).

fof(addAssignment_3075,axiom,
    ! [VarCurr] :
      ( v5794(VarCurr)
    <=> v5796(VarCurr) ) ).

fof(addAssignment_3074,axiom,
    ! [VarCurr] :
      ( v5796(VarCurr)
    <=> v5798(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_45,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6025(VarNext)
       => ( v5798(VarNext)
        <=> v5798(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_52,axiom,
    ! [VarNext] :
      ( v6025(VarNext)
     => ( v5798(VarNext)
      <=> v6033(VarNext) ) ) ).

fof(addAssignment_3073,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6033(VarNext)
      <=> v6031(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_241,axiom,
    ! [VarCurr] :
      ( ~ v6034(VarCurr)
     => ( v6031(VarCurr)
      <=> v6035(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_244,axiom,
    ! [VarCurr] :
      ( v6034(VarCurr)
     => ( v6031(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_240,axiom,
    ! [VarCurr] :
      ( ~ v6036(VarCurr)
     => ( v6035(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_243,axiom,
    ! [VarCurr] :
      ( v6036(VarCurr)
     => ( v6035(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_410,axiom,
    ! [VarCurr] :
      ( ~ v6036(VarCurr)
    <=> v5802(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_409,axiom,
    ! [VarCurr] :
      ( ~ v6034(VarCurr)
    <=> v5800(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_901,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6025(VarNext)
      <=> v6026(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_900,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6026(VarNext)
      <=> ( v6027(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_408,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6027(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_239,axiom,
    ! [VarCurr] :
      ( ~ v6013(VarCurr)
     => ( v5802(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_242,axiom,
    ! [VarCurr] :
      ( v6013(VarCurr)
     => ( v5802(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_899,axiom,
    ! [VarCurr] :
      ( v6013(VarCurr)
    <=> ( v6014(VarCurr)
        | v6021(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_898,axiom,
    ! [VarCurr] :
      ( v6021(VarCurr)
    <=> ( v6022(VarCurr)
        & v5948(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_897,axiom,
    ! [VarCurr] :
      ( v6022(VarCurr)
    <=> ( v6017(VarCurr)
        & v5766(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_896,axiom,
    ! [VarCurr] :
      ( v6014(VarCurr)
    <=> ( v6015(VarCurr)
        | v6018(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_895,axiom,
    ! [VarCurr] :
      ( v6018(VarCurr)
    <=> ( v6019(VarCurr)
        & v5945(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_894,axiom,
    ! [VarCurr] :
      ( v6019(VarCurr)
    <=> ( v6017(VarCurr)
        & v5766(VarCurr) ) ) ).

fof(writeUnaryOperator_407,axiom,
    ! [VarCurr] :
      ( ~ v6017(VarCurr)
    <=> v5804(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_893,axiom,
    ! [VarCurr] :
      ( v6015(VarCurr)
    <=> ( v6016(VarCurr)
        & v5939(VarCurr) ) ) ).

fof(writeUnaryOperator_406,axiom,
    ! [VarCurr] :
      ( ~ v6016(VarCurr)
    <=> v5804(VarCurr) ) ).

fof(addAssignment_3072,axiom,
    ! [VarNext] :
      ( v5911(VarNext,bitIndex2)
    <=> v6005(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6006(VarNext)
       => ( ( v6005(VarNext,bitIndex3)
          <=> v5911(VarCurr,bitIndex4) )
          & ( v6005(VarNext,bitIndex2)
          <=> v5911(VarCurr,bitIndex3) )
          & ( v6005(VarNext,bitIndex1)
          <=> v5911(VarCurr,bitIndex2) )
          & ( v6005(VarNext,bitIndex0)
          <=> v5911(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_51,axiom,
    ! [VarNext] :
      ( v6006(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v6005(VarNext,B)
          <=> v5959(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_892,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6006(VarNext)
      <=> v6007(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v6007(VarNext)
      <=> ( v6009(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_405,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v6009(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_113,axiom,
    ! [VarCurr] :
      ( ~ v6000(VarCurr)
     => ( v5802(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_110,axiom,
    ! [VarCurr] :
      ( v6000(VarCurr)
     => ( v5802(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_890,axiom,
    ! [VarCurr] :
      ( v6000(VarCurr)
    <=> ( v6001(VarCurr)
        | v6002(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_889,axiom,
    ! [VarCurr] :
      ( v6002(VarCurr)
    <=> ( v6003(VarCurr)
        & v5945(VarCurr) ) ) ).

fof(writeUnaryOperator_404,axiom,
    ! [VarCurr] :
      ( ~ v6003(VarCurr)
    <=> v5766(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_545,axiom,
    ! [VarCurr] :
      ( v6001(VarCurr)
    <=> ( $true
      <=> v5911(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_3071,axiom,
    ! [VarNext] :
      ( v5911(VarNext,bitIndex1)
    <=> v5992(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5993(VarNext)
       => ( ( v5992(VarNext,bitIndex3)
          <=> v5911(VarCurr,bitIndex4) )
          & ( v5992(VarNext,bitIndex2)
          <=> v5911(VarCurr,bitIndex3) )
          & ( v5992(VarNext,bitIndex1)
          <=> v5911(VarCurr,bitIndex2) )
          & ( v5992(VarNext,bitIndex0)
          <=> v5911(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_50,axiom,
    ! [VarNext] :
      ( v5993(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5992(VarNext,B)
          <=> v5959(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_888,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5993(VarNext)
      <=> v5994(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_887,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5994(VarNext)
      <=> ( v5996(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_403,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5996(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_112,axiom,
    ! [VarCurr] :
      ( ~ v5978(VarCurr)
     => ( v5802(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_109,axiom,
    ! [VarCurr] :
      ( v5978(VarCurr)
     => ( v5802(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_886,axiom,
    ! [VarCurr] :
      ( v5978(VarCurr)
    <=> ( v5979(VarCurr)
        | v5989(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_885,axiom,
    ! [VarCurr] :
      ( v5989(VarCurr)
    <=> ( v5990(VarCurr)
        & v5948(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_602,axiom,
    ! [VarCurr] :
      ( v5990(VarCurr)
    <=> ( v5988(VarCurr)
        & v5902(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_884,axiom,
    ! [VarCurr] :
      ( v5979(VarCurr)
    <=> ( v5980(VarCurr)
        | v5985(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_883,axiom,
    ! [VarCurr] :
      ( v5985(VarCurr)
    <=> ( v5986(VarCurr)
        & v5945(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_601,axiom,
    ! [VarCurr] :
      ( v5986(VarCurr)
    <=> ( v5988(VarCurr)
        & v5902(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_882,axiom,
    ! [VarCurr] :
      ( v5988(VarCurr)
    <=> ( v5944(VarCurr)
        & v5984(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_881,axiom,
    ! [VarCurr] :
      ( v5980(VarCurr)
    <=> ( v5981(VarCurr)
        & v5939(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_600,axiom,
    ! [VarCurr] :
      ( v5981(VarCurr)
    <=> ( v5983(VarCurr)
        & v5902(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_880,axiom,
    ! [VarCurr] :
      ( v5983(VarCurr)
    <=> ( v5804(VarCurr)
        & v5984(VarCurr) ) ) ).

fof(writeUnaryOperator_402,axiom,
    ! [VarCurr] :
      ( ~ v5984(VarCurr)
    <=> v5902(VarCurr,bitIndex0) ) ).

fof(addAssignment_3070,axiom,
    ! [VarNext] :
      ( v5911(VarNext,bitIndex4)
    <=> v5970(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionShiftedRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5971(VarNext)
       => ( ( v5970(VarNext,bitIndex3)
          <=> v5911(VarCurr,bitIndex4) )
          & ( v5970(VarNext,bitIndex2)
          <=> v5911(VarCurr,bitIndex3) )
          & ( v5970(VarNext,bitIndex1)
          <=> v5911(VarCurr,bitIndex2) )
          & ( v5970(VarNext,bitIndex0)
          <=> v5911(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_49,axiom,
    ! [VarNext] :
      ( v5971(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5970(VarNext,B)
          <=> v5959(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_879,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5971(VarNext)
      <=> v5972(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_878,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5972(VarNext)
      <=> ( v5974(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_401,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5974(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_111,axiom,
    ! [VarCurr] :
      ( ~ v5964(VarCurr)
     => ( v5802(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_108,axiom,
    ! [VarCurr] :
      ( v5964(VarCurr)
     => ( v5802(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_877,axiom,
    ! [VarCurr] :
      ( v5964(VarCurr)
    <=> ( v5965(VarCurr)
        | v5966(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_876,axiom,
    ! [VarCurr] :
      ( v5966(VarCurr)
    <=> ( v5967(VarCurr)
        & v5948(VarCurr) ) ) ).

fof(writeUnaryOperator_400,axiom,
    ! [VarCurr] :
      ( ~ v5967(VarCurr)
    <=> v5766(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_544,axiom,
    ! [VarCurr] :
      ( v5965(VarCurr)
    <=> ( $true
      <=> v5911(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_3069,axiom,
    ! [VarNext] :
      ( v5911(VarNext,bitIndex3)
    <=> v5950(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionShiftedRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5951(VarNext)
       => ( ( v5950(VarNext,bitIndex3)
          <=> v5911(VarCurr,bitIndex4) )
          & ( v5950(VarNext,bitIndex2)
          <=> v5911(VarCurr,bitIndex3) )
          & ( v5950(VarNext,bitIndex1)
          <=> v5911(VarCurr,bitIndex2) )
          & ( v5950(VarNext,bitIndex0)
          <=> v5911(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_48,axiom,
    ! [VarNext] :
      ( v5951(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5950(VarNext,B)
          <=> v5959(VarNext,B) ) ) ) ).

fof(addAssignment_3068,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5959(VarNext,B)
          <=> v5957(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_110,axiom,
    ! [VarCurr] :
      ( ~ v5927(VarCurr)
     => ( ( v5957(VarCurr,bitIndex3)
        <=> v5802(VarCurr,bitIndex4) )
        & ( v5957(VarCurr,bitIndex2)
        <=> v5802(VarCurr,bitIndex3) )
        & ( v5957(VarCurr,bitIndex1)
        <=> v5802(VarCurr,bitIndex2) )
        & ( v5957(VarCurr,bitIndex0)
        <=> v5802(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_241,axiom,
    ! [VarCurr] :
      ( v5927(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5957(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_875,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5951(VarNext)
      <=> v5952(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_874,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5952(VarNext)
      <=> ( v5954(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_399,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5954(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_109,axiom,
    ! [VarCurr] :
      ( ~ v5932(VarCurr)
     => ( v5802(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_107,axiom,
    ! [VarCurr] :
      ( v5932(VarCurr)
     => ( v5802(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_873,axiom,
    ! [VarCurr] :
      ( v5932(VarCurr)
    <=> ( v5933(VarCurr)
        | v5946(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_872,axiom,
    ! [VarCurr] :
      ( v5946(VarCurr)
    <=> ( v5947(VarCurr)
        & v5948(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_543,axiom,
    ! [VarCurr] :
      ( v5948(VarCurr)
    <=> ( $true
      <=> v5911(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_871,axiom,
    ! [VarCurr] :
      ( v5947(VarCurr)
    <=> ( v5943(VarCurr)
        & v5938(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_870,axiom,
    ! [VarCurr] :
      ( v5933(VarCurr)
    <=> ( v5934(VarCurr)
        | v5940(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_869,axiom,
    ! [VarCurr] :
      ( v5940(VarCurr)
    <=> ( v5941(VarCurr)
        & v5945(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_542,axiom,
    ! [VarCurr] :
      ( v5945(VarCurr)
    <=> ( $true
      <=> v5911(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_868,axiom,
    ! [VarCurr] :
      ( v5941(VarCurr)
    <=> ( v5943(VarCurr)
        & v5938(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_867,axiom,
    ! [VarCurr] :
      ( v5943(VarCurr)
    <=> ( v5944(VarCurr)
        & v5902(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_866,axiom,
    ! [VarCurr] :
      ( v5944(VarCurr)
    <=> ( v5804(VarCurr)
        & v5766(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_865,axiom,
    ! [VarCurr] :
      ( v5934(VarCurr)
    <=> ( v5935(VarCurr)
        & v5939(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_541,axiom,
    ! [VarCurr] :
      ( v5939(VarCurr)
    <=> ( $true
      <=> v5911(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_864,axiom,
    ! [VarCurr] :
      ( v5935(VarCurr)
    <=> ( v5937(VarCurr)
        & v5938(VarCurr) ) ) ).

fof(writeUnaryOperator_398,axiom,
    ! [VarCurr] :
      ( ~ v5938(VarCurr)
    <=> v5902(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_863,axiom,
    ! [VarCurr] :
      ( v5937(VarCurr)
    <=> ( v5804(VarCurr)
        & v5902(VarCurr,bitIndex0) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_44,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5916(VarNext)
       => ( v5911(VarNext,bitIndex0)
        <=> v5911(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_47,axiom,
    ! [VarNext] :
      ( v5916(VarNext)
     => ( v5911(VarNext,bitIndex0)
      <=> v5926(VarNext) ) ) ).

fof(addAssignment_3067,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5926(VarNext)
      <=> v5924(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_238,axiom,
    ! [VarCurr] :
      ( ~ v5927(VarCurr)
     => ( v5924(VarCurr)
      <=> v5802(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_240,axiom,
    ! [VarCurr] :
      ( v5927(VarCurr)
     => ( v5924(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_397,axiom,
    ! [VarCurr] :
      ( ~ v5927(VarCurr)
    <=> v5800(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_862,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5916(VarNext)
      <=> v5917(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_861,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5917(VarNext)
      <=> ( v5918(VarNext)
          & v5913(VarNext) ) ) ) ).

fof(writeUnaryOperator_396,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5918(VarNext)
      <=> v5920(VarNext) ) ) ).

fof(addAssignment_3066,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5920(VarNext)
      <=> v5913(VarCurr) ) ) ).

fof(addAssignmentInitValueVector_42,axiom,
    ( ( v5911(constB0,bitIndex4)
    <=> $false )
    & ( v5911(constB0,bitIndex3)
    <=> $false )
    & ( v5911(constB0,bitIndex2)
    <=> $false )
    & ( v5911(constB0,bitIndex1)
    <=> $false ) ) ).

fof(addAssignment_3065,axiom,
    ! [VarCurr] :
      ( v5913(VarCurr)
    <=> v1853(VarCurr) ) ).

fof(addAssignment_3064,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v5902(VarCurr,B)
      <=> v5904(VarCurr,B) ) ) ).

fof(addAssignment_3063,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v5904(VarCurr,B)
      <=> v5906(VarCurr,B) ) ) ).

fof(addAssignment_3062,axiom,
    ! [VarCurr] :
      ( v5906(VarCurr,bitIndex0)
    <=> v19(VarCurr,bitIndex4) ) ).

fof(addAssignment_3061,axiom,
    ! [VarCurr] :
      ( v5906(VarCurr,bitIndex1)
    <=> v5908(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_599,axiom,
    ! [VarCurr] :
      ( v5908(VarCurr)
    <=> ( v19(VarCurr,bitIndex1)
        | v19(VarCurr,bitIndex7) ) ) ).

fof(addAssignment_3060,axiom,
    ! [VarCurr] :
      ( v5804(VarCurr)
    <=> v5806(VarCurr) ) ).

fof(addAssignment_3059,axiom,
    ! [VarCurr] :
      ( v5806(VarCurr)
    <=> v5808(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_598,axiom,
    ! [VarCurr] :
      ( v5808(VarCurr)
    <=> ( v5900(VarCurr)
        | v19(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_597,axiom,
    ! [VarCurr] :
      ( v5900(VarCurr)
    <=> ( v19(VarCurr,bitIndex1)
        | v19(VarCurr,bitIndex4) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_108,axiom,
    ! [VarCurr] :
      ( ~ v5875(VarCurr)
     => ( v19(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_106,axiom,
    ! [VarCurr] :
      ( v5875(VarCurr)
     => ( v19(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_860,axiom,
    ! [VarCurr] :
      ( v5875(VarCurr)
    <=> ( v5876(VarCurr)
        | v5897(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_859,axiom,
    ! [VarCurr] :
      ( v5897(VarCurr)
    <=> ( v5898(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(addAssignment_3058,axiom,
    ! [VarCurr] :
      ( v5898(VarCurr)
    <=> v5883(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_858,axiom,
    ! [VarCurr] :
      ( v5876(VarCurr)
    <=> ( v5877(VarCurr)
        | v5895(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_857,axiom,
    ! [VarCurr] :
      ( v5895(VarCurr)
    <=> ( v5896(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_856,axiom,
    ! [VarCurr] :
      ( v5896(VarCurr)
    <=> ( v5883(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_855,axiom,
    ! [VarCurr] :
      ( v5877(VarCurr)
    <=> ( v5878(VarCurr)
        | v5893(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_854,axiom,
    ! [VarCurr] :
      ( v5893(VarCurr)
    <=> ( v5894(VarCurr)
        & v2927(VarCurr) ) ) ).

fof(addAssignment_3057,axiom,
    ! [VarCurr] :
      ( v5894(VarCurr)
    <=> v5883(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_853,axiom,
    ! [VarCurr] :
      ( v5878(VarCurr)
    <=> ( v5879(VarCurr)
        | v5891(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_852,axiom,
    ! [VarCurr] :
      ( v5891(VarCurr)
    <=> ( v5892(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_851,axiom,
    ! [VarCurr] :
      ( v5892(VarCurr)
    <=> ( v5883(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_850,axiom,
    ! [VarCurr] :
      ( v5879(VarCurr)
    <=> ( v5880(VarCurr)
        | v5889(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_849,axiom,
    ! [VarCurr] :
      ( v5889(VarCurr)
    <=> ( v5890(VarCurr)
        & v2924(VarCurr) ) ) ).

fof(addAssignment_3056,axiom,
    ! [VarCurr] :
      ( v5890(VarCurr)
    <=> v5883(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_848,axiom,
    ! [VarCurr] :
      ( v5880(VarCurr)
    <=> ( v5881(VarCurr)
        | v5886(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_847,axiom,
    ! [VarCurr] :
      ( v5886(VarCurr)
    <=> ( v5887(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_846,axiom,
    ! [VarCurr] :
      ( v5887(VarCurr)
    <=> ( v5883(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_845,axiom,
    ! [VarCurr] :
      ( v5883(VarCurr)
    <=> ( v5884(VarCurr)
        & v2919(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_844,axiom,
    ! [VarCurr] :
      ( v5881(VarCurr)
    <=> ( v5882(VarCurr)
        & v2921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_843,axiom,
    ! [VarCurr] :
      ( v5882(VarCurr)
    <=> ( v5884(VarCurr)
        & v2919(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_842,axiom,
    ! [VarCurr] :
      ( v5884(VarCurr)
    <=> ( v5885(VarCurr)
        & v2593(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_841,axiom,
    ! [VarCurr] :
      ( v5885(VarCurr)
    <=> ( v2917(VarCurr)
        & v5825(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_107,axiom,
    ! [VarCurr] :
      ( ~ v5849(VarCurr)
     => ( v19(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_105,axiom,
    ! [VarCurr] :
      ( v5849(VarCurr)
     => ( v19(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_840,axiom,
    ! [VarCurr] :
      ( v5849(VarCurr)
    <=> ( v5850(VarCurr)
        | v5870(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_839,axiom,
    ! [VarCurr] :
      ( v5870(VarCurr)
    <=> ( v5871(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_838,axiom,
    ! [VarCurr] :
      ( v5871(VarCurr)
    <=> ( v2914(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_837,axiom,
    ! [VarCurr] :
      ( v5850(VarCurr)
    <=> ( v5851(VarCurr)
        | v5868(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_836,axiom,
    ! [VarCurr] :
      ( v5868(VarCurr)
    <=> ( v5869(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_835,axiom,
    ! [VarCurr] :
      ( v5869(VarCurr)
    <=> ( v5861(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_834,axiom,
    ! [VarCurr] :
      ( v5851(VarCurr)
    <=> ( v5852(VarCurr)
        | v5866(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_833,axiom,
    ! [VarCurr] :
      ( v5866(VarCurr)
    <=> ( v5867(VarCurr)
        & v2927(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_832,axiom,
    ! [VarCurr] :
      ( v5867(VarCurr)
    <=> ( v2914(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_831,axiom,
    ! [VarCurr] :
      ( v5852(VarCurr)
    <=> ( v5853(VarCurr)
        | v5864(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_830,axiom,
    ! [VarCurr] :
      ( v5864(VarCurr)
    <=> ( v5865(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_829,axiom,
    ! [VarCurr] :
      ( v5865(VarCurr)
    <=> ( v5861(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_828,axiom,
    ! [VarCurr] :
      ( v5853(VarCurr)
    <=> ( v5854(VarCurr)
        | v5862(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_827,axiom,
    ! [VarCurr] :
      ( v5862(VarCurr)
    <=> ( v5863(VarCurr)
        & v2924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_826,axiom,
    ! [VarCurr] :
      ( v5863(VarCurr)
    <=> ( v2914(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_825,axiom,
    ! [VarCurr] :
      ( v5854(VarCurr)
    <=> ( v5855(VarCurr)
        | v5858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_824,axiom,
    ! [VarCurr] :
      ( v5858(VarCurr)
    <=> ( v5859(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_823,axiom,
    ! [VarCurr] :
      ( v5859(VarCurr)
    <=> ( v5861(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_822,axiom,
    ! [VarCurr] :
      ( v5861(VarCurr)
    <=> ( v2914(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_821,axiom,
    ! [VarCurr] :
      ( v5855(VarCurr)
    <=> ( v5856(VarCurr)
        & v2921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_820,axiom,
    ! [VarCurr] :
      ( v5856(VarCurr)
    <=> ( v2914(VarCurr)
        & v2899(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_106,axiom,
    ! [VarCurr] :
      ( ~ v5812(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_104,axiom,
    ! [VarCurr] :
      ( v5812(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_819,axiom,
    ! [VarCurr] :
      ( v5812(VarCurr)
    <=> ( v5813(VarCurr)
        | v5843(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_818,axiom,
    ! [VarCurr] :
      ( v5843(VarCurr)
    <=> ( v5844(VarCurr)
        & v5845(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_540,axiom,
    ! [VarCurr] :
      ( v5845(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_817,axiom,
    ! [VarCurr] :
      ( v5844(VarCurr)
    <=> ( v5821(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_816,axiom,
    ! [VarCurr] :
      ( v5813(VarCurr)
    <=> ( v5814(VarCurr)
        | v5840(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_815,axiom,
    ! [VarCurr] :
      ( v5840(VarCurr)
    <=> ( v5841(VarCurr)
        & v5842(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_539,axiom,
    ! [VarCurr] :
      ( v5842(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_814,axiom,
    ! [VarCurr] :
      ( v5841(VarCurr)
    <=> ( v5830(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_813,axiom,
    ! [VarCurr] :
      ( v5814(VarCurr)
    <=> ( v5815(VarCurr)
        | v5838(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_812,axiom,
    ! [VarCurr] :
      ( v5838(VarCurr)
    <=> ( v5839(VarCurr)
        & v2927(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_811,axiom,
    ! [VarCurr] :
      ( v5839(VarCurr)
    <=> ( v5821(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_810,axiom,
    ! [VarCurr] :
      ( v5815(VarCurr)
    <=> ( v5816(VarCurr)
        | v5835(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_809,axiom,
    ! [VarCurr] :
      ( v5835(VarCurr)
    <=> ( v5836(VarCurr)
        & v5837(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_538,axiom,
    ! [VarCurr] :
      ( v5837(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_808,axiom,
    ! [VarCurr] :
      ( v5836(VarCurr)
    <=> ( v5830(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_807,axiom,
    ! [VarCurr] :
      ( v5816(VarCurr)
    <=> ( v5817(VarCurr)
        | v5833(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_806,axiom,
    ! [VarCurr] :
      ( v5833(VarCurr)
    <=> ( v5834(VarCurr)
        & v2924(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_805,axiom,
    ! [VarCurr] :
      ( v5834(VarCurr)
    <=> ( v5821(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_804,axiom,
    ! [VarCurr] :
      ( v5817(VarCurr)
    <=> ( v5818(VarCurr)
        | v5827(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_803,axiom,
    ! [VarCurr] :
      ( v5827(VarCurr)
    <=> ( v5828(VarCurr)
        & v5832(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_537,axiom,
    ! [VarCurr] :
      ( v5832(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_802,axiom,
    ! [VarCurr] :
      ( v5828(VarCurr)
    <=> ( v5830(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_801,axiom,
    ! [VarCurr] :
      ( v5830(VarCurr)
    <=> ( v5831(VarCurr)
        & v5826(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_800,axiom,
    ! [VarCurr] :
      ( v5831(VarCurr)
    <=> ( v5822(VarCurr)
        & v5760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_799,axiom,
    ! [VarCurr] :
      ( v5818(VarCurr)
    <=> ( v5819(VarCurr)
        & v2921(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_798,axiom,
    ! [VarCurr] :
      ( v5819(VarCurr)
    <=> ( v5821(VarCurr)
        & v2597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_797,axiom,
    ! [VarCurr] :
      ( v5821(VarCurr)
    <=> ( v5822(VarCurr)
        & v5826(VarCurr) ) ) ).

fof(writeUnaryOperator_395,axiom,
    ! [VarCurr] :
      ( ~ v5826(VarCurr)
    <=> v2893(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_796,axiom,
    ! [VarCurr] :
      ( v5822(VarCurr)
    <=> ( v5823(VarCurr)
        & v2919(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_795,axiom,
    ! [VarCurr] :
      ( v5823(VarCurr)
    <=> ( v5824(VarCurr)
        & v2918(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_794,axiom,
    ! [VarCurr] :
      ( v5824(VarCurr)
    <=> ( v71(VarCurr)
        & v5825(VarCurr) ) ) ).

fof(writeUnaryOperator_394,axiom,
    ! [VarCurr] :
      ( ~ v5825(VarCurr)
    <=> v2571(VarCurr) ) ).

fof(addAssignment_3055,axiom,
    ! [VarCurr] :
      ( v5800(VarCurr)
    <=> v10(VarCurr) ) ).

fof(addAssignment_3054,axiom,
    ! [VarCurr] :
      ( v5778(VarCurr)
    <=> v5780(VarCurr) ) ).

fof(addAssignment_3053,axiom,
    ! [VarCurr] :
      ( v5780(VarCurr)
    <=> v14(VarCurr) ) ).

fof(addAssignment_3052,axiom,
    ! [VarCurr] :
      ( v5750(VarCurr)
    <=> v10(VarCurr) ) ).

fof(addAssignment_3051,axiom,
    ! [VarCurr] :
      ( v81(VarCurr,bitIndex0)
    <=> v5740(VarCurr) ) ).

fof(addAssignment_3050,axiom,
    ! [VarCurr] :
      ( v81(VarCurr,bitIndex1)
    <=> v1873(VarCurr) ) ).

fof(addAssignment_3049,axiom,
    ! [VarCurr] :
      ( v81(VarCurr,bitIndex2)
    <=> v83(VarCurr) ) ).

fof(addAssignment_3048,axiom,
    ! [VarCurr] :
      ( v5740(VarCurr)
    <=> v5742(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_793,axiom,
    ! [VarCurr] :
      ( v5742(VarCurr)
    <=> ( v5744(VarCurr)
        & v5745(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_792,axiom,
    ! [VarCurr] :
      ( v5745(VarCurr)
    <=> ( v2893(VarCurr)
        | v2597(VarCurr) ) ) ).

fof(writeUnaryOperator_393,axiom,
    ! [VarCurr] :
      ( ~ v5744(VarCurr)
    <=> v2721(VarCurr) ) ).

fof(addAssignment_3047,axiom,
    ! [VarCurr] :
      ( v1873(VarCurr)
    <=> v1875(VarCurr) ) ).

fof(writeUnaryOperator_392,axiom,
    ! [VarCurr] :
      ( ~ v1875(VarCurr)
    <=> v1877(VarCurr) ) ).

fof(addAssignment_3046,axiom,
    ! [VarCurr] :
      ( v1877(VarCurr)
    <=> v1879(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_791,axiom,
    ! [VarCurr] :
      ( v1879(VarCurr)
    <=> ( v1881(VarCurr)
        | v5640(VarCurr) ) ) ).

fof(addAssignment_3045,axiom,
    ! [VarCurr] :
      ( v5640(VarCurr)
    <=> v5642(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_536,axiom,
    ! [VarCurr] :
      ( v5642(VarCurr)
    <=> ( ( v5644(VarCurr,bitIndex4)
        <=> $false )
        & ( v5644(VarCurr,bitIndex3)
        <=> $false )
        & ( v5644(VarCurr,bitIndex2)
        <=> $false )
        & ( v5644(VarCurr,bitIndex1)
        <=> $false )
        & ( v5644(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5724(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v5644(VarNext,B)
            <=> v5644(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_46,axiom,
    ! [VarNext] :
      ( v5724(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5644(VarNext,B)
          <=> v5732(VarNext,B) ) ) ) ).

fof(addAssignment_3044,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5732(VarNext,B)
          <=> v5730(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_237,axiom,
    ! [VarCurr] :
      ( ~ v5733(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5730(VarCurr,B)
          <=> v5646(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_239,axiom,
    ! [VarCurr] :
      ( v5733(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5730(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_391,axiom,
    ! [VarCurr] :
      ( ~ v5733(VarCurr)
    <=> v2456(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_790,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5724(VarNext)
      <=> v5725(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_789,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5725(VarNext)
      <=> ( v5726(VarNext)
          & v2453(VarNext) ) ) ) ).

fof(writeUnaryOperator_390,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5726(VarNext)
      <=> v2524(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_13,axiom,
    ! [VarCurr] :
      ( ( ~ v5648(VarCurr)
        & ~ v5650(VarCurr)
        & ~ v5691(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v5646(VarCurr,B)
          <=> v5644(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_140,axiom,
    ! [VarCurr] :
      ( v5691(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5646(VarCurr,B)
          <=> v5693(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_162,axiom,
    ! [VarCurr] :
      ( v5650(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5646(VarCurr,B)
          <=> v5652(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_163,axiom,
    ! [VarCurr] :
      ( v5648(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5646(VarCurr,B)
          <=> v5644(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_535,axiom,
    ! [VarCurr] :
      ( v5720(VarCurr)
    <=> ( ( v5721(VarCurr,bitIndex1)
        <=> $true )
        & ( v5721(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3043,axiom,
    ! [VarCurr] :
      ( v5721(VarCurr,bitIndex0)
    <=> v2563(VarCurr) ) ).

fof(addAssignment_3042,axiom,
    ! [VarCurr] :
      ( v5721(VarCurr,bitIndex1)
    <=> v2485(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_236,axiom,
    ! [VarCurr] :
      ( ~ v5694(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5693(VarCurr,B)
          <=> v5695(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_238,axiom,
    ! [VarCurr] :
      ( v5694(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5693(VarCurr,B)
          <=> b10000(B) ) ) ) ).

fof(addAssignment_3041,axiom,
    ! [VarCurr] :
      ( v5695(VarCurr,bitIndex0)
    <=> v5717(VarCurr) ) ).

fof(addAssignment_3040,axiom,
    ! [VarCurr] :
      ( v5695(VarCurr,bitIndex1)
    <=> v5715(VarCurr) ) ).

fof(addAssignment_3039,axiom,
    ! [VarCurr] :
      ( v5695(VarCurr,bitIndex2)
    <=> v5710(VarCurr) ) ).

fof(addAssignment_3038,axiom,
    ! [VarCurr] :
      ( v5695(VarCurr,bitIndex3)
    <=> v5705(VarCurr) ) ).

fof(addAssignment_3037,axiom,
    ! [VarCurr] :
      ( v5695(VarCurr,bitIndex4)
    <=> v5697(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_788,axiom,
    ! [VarCurr] :
      ( v5715(VarCurr)
    <=> ( v5716(VarCurr)
        & v5719(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_596,axiom,
    ! [VarCurr] :
      ( v5719(VarCurr)
    <=> ( v5644(VarCurr,bitIndex0)
        | v5644(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_787,axiom,
    ! [VarCurr] :
      ( v5716(VarCurr)
    <=> ( v5717(VarCurr)
        | v5718(VarCurr) ) ) ).

fof(writeUnaryOperator_389,axiom,
    ! [VarCurr] :
      ( ~ v5718(VarCurr)
    <=> v5644(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_388,axiom,
    ! [VarCurr] :
      ( ~ v5717(VarCurr)
    <=> v5644(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_786,axiom,
    ! [VarCurr] :
      ( v5710(VarCurr)
    <=> ( v5711(VarCurr)
        & v5714(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_595,axiom,
    ! [VarCurr] :
      ( v5714(VarCurr)
    <=> ( v5702(VarCurr)
        | v5644(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_785,axiom,
    ! [VarCurr] :
      ( v5711(VarCurr)
    <=> ( v5712(VarCurr)
        | v5713(VarCurr) ) ) ).

fof(writeUnaryOperator_387,axiom,
    ! [VarCurr] :
      ( ~ v5713(VarCurr)
    <=> v5644(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_386,axiom,
    ! [VarCurr] :
      ( ~ v5712(VarCurr)
    <=> v5702(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_784,axiom,
    ! [VarCurr] :
      ( v5705(VarCurr)
    <=> ( v5706(VarCurr)
        & v5709(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_594,axiom,
    ! [VarCurr] :
      ( v5709(VarCurr)
    <=> ( v5701(VarCurr)
        | v5644(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_783,axiom,
    ! [VarCurr] :
      ( v5706(VarCurr)
    <=> ( v5707(VarCurr)
        | v5708(VarCurr) ) ) ).

fof(writeUnaryOperator_385,axiom,
    ! [VarCurr] :
      ( ~ v5708(VarCurr)
    <=> v5644(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_384,axiom,
    ! [VarCurr] :
      ( ~ v5707(VarCurr)
    <=> v5701(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_782,axiom,
    ! [VarCurr] :
      ( v5697(VarCurr)
    <=> ( v5698(VarCurr)
        & v5704(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_593,axiom,
    ! [VarCurr] :
      ( v5704(VarCurr)
    <=> ( v5700(VarCurr)
        | v5644(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_781,axiom,
    ! [VarCurr] :
      ( v5698(VarCurr)
    <=> ( v5699(VarCurr)
        | v5703(VarCurr) ) ) ).

fof(writeUnaryOperator_383,axiom,
    ! [VarCurr] :
      ( ~ v5703(VarCurr)
    <=> v5644(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_382,axiom,
    ! [VarCurr] :
      ( ~ v5699(VarCurr)
    <=> v5700(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_592,axiom,
    ! [VarCurr] :
      ( v5700(VarCurr)
    <=> ( v5701(VarCurr)
        & v5644(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_591,axiom,
    ! [VarCurr] :
      ( v5701(VarCurr)
    <=> ( v5702(VarCurr)
        & v5644(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_590,axiom,
    ! [VarCurr] :
      ( v5702(VarCurr)
    <=> ( v5644(VarCurr,bitIndex0)
        & v5644(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_534,axiom,
    ! [VarCurr] :
      ( v5694(VarCurr)
    <=> ( ( v5644(VarCurr,bitIndex4)
        <=> $true )
        & ( v5644(VarCurr,bitIndex3)
        <=> $false )
        & ( v5644(VarCurr,bitIndex2)
        <=> $false )
        & ( v5644(VarCurr,bitIndex1)
        <=> $false )
        & ( v5644(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_533,axiom,
    ! [VarCurr] :
      ( v5691(VarCurr)
    <=> ( ( v5692(VarCurr,bitIndex1)
        <=> $true )
        & ( v5692(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3036,axiom,
    ! [VarCurr] :
      ( v5692(VarCurr,bitIndex0)
    <=> v2563(VarCurr) ) ).

fof(addAssignment_3035,axiom,
    ! [VarCurr] :
      ( v5692(VarCurr,bitIndex1)
    <=> v2485(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_235,axiom,
    ! [VarCurr] :
      ( ~ v5653(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v5652(VarCurr,B)
          <=> v5654(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_237,axiom,
    ! [VarCurr] :
      ( v5653(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v5652(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_156,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex6)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_155,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex7)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_154,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex8)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_153,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex9)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_152,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex10)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_151,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex11)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_150,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex12)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_149,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex13)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_148,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex14)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_147,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex15)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_146,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex16)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_145,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex17)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_144,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex18)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_143,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex19)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_142,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex20)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_141,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex21)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_140,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex22)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_139,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex23)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_138,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex24)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_137,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex25)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_136,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex26)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_135,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex27)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_134,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex28)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_133,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex29)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_132,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex30)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_131,axiom,
    ! [VarCurr] :
      ( v5654(VarCurr,bitIndex31)
    <=> v5655(VarCurr,bitIndex5) ) ).

fof(addAssignment_3034,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v5654(VarCurr,B)
      <=> v5655(VarCurr,B) ) ) ).

fof(addAssignment_3033,axiom,
    ! [VarCurr] :
      ( v5655(VarCurr,bitIndex0)
    <=> v5689(VarCurr) ) ).

fof(addAssignment_3032,axiom,
    ! [VarCurr] :
      ( v5655(VarCurr,bitIndex1)
    <=> v5687(VarCurr) ) ).

fof(addAssignment_3031,axiom,
    ! [VarCurr] :
      ( v5655(VarCurr,bitIndex2)
    <=> v5683(VarCurr) ) ).

fof(addAssignment_3030,axiom,
    ! [VarCurr] :
      ( v5655(VarCurr,bitIndex3)
    <=> v5679(VarCurr) ) ).

fof(addAssignment_3029,axiom,
    ! [VarCurr] :
      ( v5655(VarCurr,bitIndex4)
    <=> v5675(VarCurr) ) ).

fof(addAssignment_3028,axiom,
    ! [VarCurr] :
      ( v5655(VarCurr,bitIndex5)
    <=> v5657(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_780,axiom,
    ! [VarCurr] :
      ( v5687(VarCurr)
    <=> ( v5688(VarCurr)
        & v5690(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_779,axiom,
    ! [VarCurr] :
      ( v5690(VarCurr)
    <=> ( v5661(VarCurr,bitIndex0)
        | v5669(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_589,axiom,
    ! [VarCurr] :
      ( v5688(VarCurr)
    <=> ( v5689(VarCurr)
        | v5661(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_381,axiom,
    ! [VarCurr] :
      ( ~ v5689(VarCurr)
    <=> v5661(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_778,axiom,
    ! [VarCurr] :
      ( v5683(VarCurr)
    <=> ( v5684(VarCurr)
        & v5686(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_777,axiom,
    ! [VarCurr] :
      ( v5686(VarCurr)
    <=> ( v5667(VarCurr)
        | v5670(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_588,axiom,
    ! [VarCurr] :
      ( v5684(VarCurr)
    <=> ( v5685(VarCurr)
        | v5661(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_380,axiom,
    ! [VarCurr] :
      ( ~ v5685(VarCurr)
    <=> v5667(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_776,axiom,
    ! [VarCurr] :
      ( v5679(VarCurr)
    <=> ( v5680(VarCurr)
        & v5682(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_775,axiom,
    ! [VarCurr] :
      ( v5682(VarCurr)
    <=> ( v5665(VarCurr)
        | v5671(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_587,axiom,
    ! [VarCurr] :
      ( v5680(VarCurr)
    <=> ( v5681(VarCurr)
        | v5661(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_379,axiom,
    ! [VarCurr] :
      ( ~ v5681(VarCurr)
    <=> v5665(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_774,axiom,
    ! [VarCurr] :
      ( v5675(VarCurr)
    <=> ( v5676(VarCurr)
        & v5678(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_773,axiom,
    ! [VarCurr] :
      ( v5678(VarCurr)
    <=> ( v5663(VarCurr)
        | v5672(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_586,axiom,
    ! [VarCurr] :
      ( v5676(VarCurr)
    <=> ( v5677(VarCurr)
        | v5661(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_378,axiom,
    ! [VarCurr] :
      ( ~ v5677(VarCurr)
    <=> v5663(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_772,axiom,
    ! [VarCurr] :
      ( v5657(VarCurr)
    <=> ( v5658(VarCurr)
        & v5673(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_771,axiom,
    ! [VarCurr] :
      ( v5673(VarCurr)
    <=> ( v5660(VarCurr)
        | v5674(VarCurr) ) ) ).

fof(writeUnaryOperator_377,axiom,
    ! [VarCurr] :
      ( ~ v5674(VarCurr)
    <=> v5661(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_585,axiom,
    ! [VarCurr] :
      ( v5658(VarCurr)
    <=> ( v5659(VarCurr)
        | v5661(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_376,axiom,
    ! [VarCurr] :
      ( ~ v5659(VarCurr)
    <=> v5660(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_584,axiom,
    ! [VarCurr] :
      ( v5660(VarCurr)
    <=> ( v5661(VarCurr,bitIndex4)
        | v5662(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_770,axiom,
    ! [VarCurr] :
      ( v5662(VarCurr)
    <=> ( v5663(VarCurr)
        & v5672(VarCurr) ) ) ).

fof(writeUnaryOperator_375,axiom,
    ! [VarCurr] :
      ( ~ v5672(VarCurr)
    <=> v5661(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_583,axiom,
    ! [VarCurr] :
      ( v5663(VarCurr)
    <=> ( v5661(VarCurr,bitIndex3)
        | v5664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_769,axiom,
    ! [VarCurr] :
      ( v5664(VarCurr)
    <=> ( v5665(VarCurr)
        & v5671(VarCurr) ) ) ).

fof(writeUnaryOperator_374,axiom,
    ! [VarCurr] :
      ( ~ v5671(VarCurr)
    <=> v5661(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_582,axiom,
    ! [VarCurr] :
      ( v5665(VarCurr)
    <=> ( v5661(VarCurr,bitIndex2)
        | v5666(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_768,axiom,
    ! [VarCurr] :
      ( v5666(VarCurr)
    <=> ( v5667(VarCurr)
        & v5670(VarCurr) ) ) ).

fof(writeUnaryOperator_373,axiom,
    ! [VarCurr] :
      ( ~ v5670(VarCurr)
    <=> v5661(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_581,axiom,
    ! [VarCurr] :
      ( v5667(VarCurr)
    <=> ( v5661(VarCurr,bitIndex1)
        | v5668(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_767,axiom,
    ! [VarCurr] :
      ( v5668(VarCurr)
    <=> ( v5661(VarCurr,bitIndex0)
        & v5669(VarCurr) ) ) ).

fof(writeUnaryOperator_372,axiom,
    ! [VarCurr] :
      ( ~ v5669(VarCurr)
    <=> v5661(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_5,axiom,
    ! [VarCurr] : ~ v5661(VarCurr,bitIndex5) ).

fof(addAssignment_3027,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v5661(VarCurr,B)
      <=> v5644(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_532,axiom,
    ! [VarCurr] :
      ( v5653(VarCurr)
    <=> ( ( v5644(VarCurr,bitIndex4)
        <=> $false )
        & ( v5644(VarCurr,bitIndex3)
        <=> $false )
        & ( v5644(VarCurr,bitIndex2)
        <=> $false )
        & ( v5644(VarCurr,bitIndex1)
        <=> $false )
        & ( v5644(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_531,axiom,
    ! [VarCurr] :
      ( v5650(VarCurr)
    <=> ( ( v5651(VarCurr,bitIndex1)
        <=> $false )
        & ( v5651(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_3026,axiom,
    ! [VarCurr] :
      ( v5651(VarCurr,bitIndex0)
    <=> v2563(VarCurr) ) ).

fof(addAssignment_3025,axiom,
    ! [VarCurr] :
      ( v5651(VarCurr,bitIndex1)
    <=> v2485(VarCurr) ) ).

fof(addAssignmentInitValue_42,axiom,
    ~ v5644(constB0,bitIndex4) ).

fof(addAssignmentInitValue_41,axiom,
    ~ v5644(constB0,bitIndex3) ).

fof(addAssignmentInitValue_40,axiom,
    ~ v5644(constB0,bitIndex2) ).

fof(addAssignmentInitValue_39,axiom,
    ~ v5644(constB0,bitIndex1) ).

fof(addAssignmentInitValue_38,axiom,
    v5644(constB0,bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_530,axiom,
    ! [VarCurr] :
      ( v5648(VarCurr)
    <=> ( ( v5649(VarCurr,bitIndex1)
        <=> $false )
        & ( v5649(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3024,axiom,
    ! [VarCurr] :
      ( v5649(VarCurr,bitIndex0)
    <=> v2563(VarCurr) ) ).

fof(addAssignment_3023,axiom,
    ! [VarCurr] :
      ( v5649(VarCurr,bitIndex1)
    <=> v2485(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_766,axiom,
    ! [VarCurr] :
      ( v1881(VarCurr)
    <=> ( v5634(VarCurr)
        | v5638(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_765,axiom,
    ! [VarCurr] :
      ( v5638(VarCurr)
    <=> ( v5534(VarCurr)
        & v5540(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_764,axiom,
    ! [VarCurr] :
      ( v5634(VarCurr)
    <=> ( v5635(VarCurr)
        | v5172(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_763,axiom,
    ! [VarCurr] :
      ( v5635(VarCurr)
    <=> ( v5636(VarCurr)
        & v5637(VarCurr) ) ) ).

fof(writeUnaryOperator_371,axiom,
    ! [VarCurr] :
      ( ~ v5637(VarCurr)
    <=> v2996(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_762,axiom,
    ! [VarCurr] :
      ( v5636(VarCurr)
    <=> ( v1883(VarCurr)
        & v2366(VarCurr) ) ) ).

fof(addAssignment_3022,axiom,
    ! [VarCurr] :
      ( v5540(VarCurr)
    <=> v5542(VarCurr) ) ).

fof(addAssignment_3021,axiom,
    ! [VarCurr] :
      ( v5542(VarCurr)
    <=> v5544(VarCurr) ) ).

fof(addAssignment_3020,axiom,
    ! [VarCurr] :
      ( v5544(VarCurr)
    <=> v5546(VarCurr) ) ).

fof(addAssignment_3019,axiom,
    ! [VarCurr] :
      ( v5546(VarCurr)
    <=> v5548(VarCurr) ) ).

fof(addAssignment_3018,axiom,
    ! [VarCurr] :
      ( v5548(VarCurr)
    <=> v3006(VarCurr,bitIndex1) ) ).

fof(addAssignment_3017,axiom,
    ! [VarCurr] :
      ( v3006(VarCurr,bitIndex1)
    <=> v3008(VarCurr,bitIndex1) ) ).

fof(addAssignment_3016,axiom,
    ! [VarCurr] :
      ( v3008(VarCurr,bitIndex1)
    <=> v3010(VarCurr,bitIndex1) ) ).

fof(addAssignment_3015,axiom,
    ! [VarCurr] :
      ( v3010(VarCurr,bitIndex1)
    <=> v3012(VarCurr,bitIndex1) ) ).

fof(addAssignment_3014,axiom,
    ! [VarCurr] :
      ( v3012(VarCurr,bitIndex1)
    <=> v3014(VarCurr,bitIndex1) ) ).

fof(addAssignment_3013,axiom,
    ! [VarCurr] :
      ( v3014(VarCurr,bitIndex1)
    <=> v3016(VarCurr,bitIndex1) ) ).

fof(addAssignment_3012,axiom,
    ! [VarCurr] :
      ( v3016(VarCurr,bitIndex1)
    <=> v5550(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5589(VarNext)
       => ( v5550(VarNext)
        <=> v5550(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_45,axiom,
    ! [VarNext] :
      ( v5589(VarNext)
     => ( v5550(VarNext)
      <=> v5624(VarNext) ) ) ).

fof(addAssignment_3011,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5624(VarNext)
      <=> v5622(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_161,axiom,
    ! [VarCurr] :
      ( ~ v5552(VarCurr)
     => ( v5622(VarCurr)
      <=> v5625(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_162,axiom,
    ! [VarCurr] :
      ( v5552(VarCurr)
     => ( v5622(VarCurr)
      <=> v5554(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_160,axiom,
    ! [VarCurr] :
      ( ~ v5602(VarCurr)
     => ( v5625(VarCurr)
      <=> v5584(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_161,axiom,
    ! [VarCurr] :
      ( v5602(VarCurr)
     => ( v5625(VarCurr)
      <=> v5626(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_139,axiom,
    ! [VarCurr] :
      ( ( ~ v5605(VarCurr)
        & ~ v5607(VarCurr) )
     => ( v5626(VarCurr)
      <=> v5630(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_159,axiom,
    ! [VarCurr] :
      ( v5607(VarCurr)
     => ( v5626(VarCurr)
      <=> v5629(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_160,axiom,
    ! [VarCurr] :
      ( v5605(VarCurr)
     => ( v5626(VarCurr)
      <=> v5627(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_158,axiom,
    ! [VarCurr] :
      ( ~ v5615(VarCurr)
     => ( v5630(VarCurr)
      <=> v5584(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_159,axiom,
    ! [VarCurr] :
      ( v5615(VarCurr)
     => ( v5630(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_157,axiom,
    ! [VarCurr] :
      ( ~ v5609(VarCurr)
     => ( v5629(VarCurr)
      <=> v5584(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_158,axiom,
    ! [VarCurr] :
      ( v5609(VarCurr)
     => ( v5629(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_234,axiom,
    ! [VarCurr] :
      ( ~ v5628(VarCurr)
     => ( v5627(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_236,axiom,
    ! [VarCurr] :
      ( v5628(VarCurr)
     => ( v5627(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_529,axiom,
    ! [VarCurr] :
      ( v5628(VarCurr)
    <=> ( v5562(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_761,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5589(VarNext)
      <=> ( v5590(VarNext)
          & v5599(VarNext) ) ) ) ).

fof(addAssignment_3010,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5599(VarNext)
      <=> v5597(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_760,axiom,
    ! [VarCurr] :
      ( v5597(VarCurr)
    <=> ( v5552(VarCurr)
        | v5600(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_759,axiom,
    ! [VarCurr] :
      ( v5600(VarCurr)
    <=> ( v5601(VarCurr)
        & v5621(VarCurr) ) ) ).

fof(writeUnaryOperator_370,axiom,
    ! [VarCurr] :
      ( ~ v5621(VarCurr)
    <=> v5552(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_758,axiom,
    ! [VarCurr] :
      ( v5601(VarCurr)
    <=> ( v5602(VarCurr)
        | v5619(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_757,axiom,
    ! [VarCurr] :
      ( v5619(VarCurr)
    <=> ( v5580(VarCurr)
        & v5620(VarCurr) ) ) ).

fof(writeUnaryOperator_369,axiom,
    ! [VarCurr] :
      ( ~ v5620(VarCurr)
    <=> v5582(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_756,axiom,
    ! [VarCurr] :
      ( v5602(VarCurr)
    <=> ( v5603(VarCurr)
        & v5582(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_755,axiom,
    ! [VarCurr] :
      ( v5603(VarCurr)
    <=> ( v5604(VarCurr)
        | v5613(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_754,axiom,
    ! [VarCurr] :
      ( v5613(VarCurr)
    <=> ( v5614(VarCurr)
        & v5618(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_528,axiom,
    ! [VarCurr] :
      ( v5618(VarCurr)
    <=> ( ( v5606(VarCurr,bitIndex2)
        <=> $false )
        & ( v5606(VarCurr,bitIndex1)
        <=> $false )
        & ( v5606(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_753,axiom,
    ! [VarCurr] :
      ( v5614(VarCurr)
    <=> ( v5615(VarCurr)
        | v5616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_752,axiom,
    ! [VarCurr] :
      ( v5616(VarCurr)
    <=> ( v5580(VarCurr)
        & v5617(VarCurr) ) ) ).

fof(writeUnaryOperator_368,axiom,
    ! [VarCurr] :
      ( ~ v5617(VarCurr)
    <=> v5615(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_527,axiom,
    ! [VarCurr] :
      ( v5615(VarCurr)
    <=> ( v5562(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_751,axiom,
    ! [VarCurr] :
      ( v5604(VarCurr)
    <=> ( v5605(VarCurr)
        | v5607(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_750,axiom,
    ! [VarCurr] :
      ( v5607(VarCurr)
    <=> ( v5608(VarCurr)
        & v5612(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_526,axiom,
    ! [VarCurr] :
      ( v5612(VarCurr)
    <=> ( ( v5606(VarCurr,bitIndex2)
        <=> $false )
        & ( v5606(VarCurr,bitIndex1)
        <=> $true )
        & ( v5606(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_749,axiom,
    ! [VarCurr] :
      ( v5608(VarCurr)
    <=> ( v5609(VarCurr)
        | v5610(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_748,axiom,
    ! [VarCurr] :
      ( v5610(VarCurr)
    <=> ( v5580(VarCurr)
        & v5611(VarCurr) ) ) ).

fof(writeUnaryOperator_367,axiom,
    ! [VarCurr] :
      ( ~ v5611(VarCurr)
    <=> v5609(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_525,axiom,
    ! [VarCurr] :
      ( v5609(VarCurr)
    <=> ( v5562(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_524,axiom,
    ! [VarCurr] :
      ( v5605(VarCurr)
    <=> ( ( v5606(VarCurr,bitIndex2)
        <=> $true )
        & ( v5606(VarCurr,bitIndex1)
        <=> $false )
        & ( v5606(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_3009,axiom,
    ! [VarCurr] :
      ( v5606(VarCurr,bitIndex0)
    <=> v5560(VarCurr) ) ).

fof(addAssignment_3008,axiom,
    ! [VarCurr] :
      ( v5606(VarCurr,bitIndex1)
    <=> v5558(VarCurr) ) ).

fof(addAssignment_3007,axiom,
    ! [VarCurr] :
      ( v5606(VarCurr,bitIndex2)
    <=> v5556(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_747,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5590(VarNext)
      <=> ( v5591(VarNext)
          & v5586(VarNext) ) ) ) ).

fof(writeUnaryOperator_366,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5591(VarNext)
      <=> v5593(VarNext) ) ) ).

fof(addAssignment_3006,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5593(VarNext)
      <=> v5586(VarCurr) ) ) ).

fof(addAssignment_3005,axiom,
    ! [VarCurr] :
      ( v5586(VarCurr)
    <=> v5120(VarCurr) ) ).

fof(addAssignment_3004,axiom,
    ! [VarCurr] :
      ( v5584(VarCurr)
    <=> $false ) ).

fof(addAssignment_3003,axiom,
    ! [VarCurr] :
      ( v5582(VarCurr)
    <=> v5012(VarCurr) ) ).

fof(addAssignment_3002,axiom,
    ! [VarCurr] :
      ( v5580(VarCurr)
    <=> $false ) ).

fof(addAssignment_3001,axiom,
    ! [VarCurr] :
      ( v5562(VarCurr)
    <=> v3054(VarCurr,bitIndex1) ) ).

fof(addAssignment_3000,axiom,
    ! [VarCurr] :
      ( v3054(VarCurr,bitIndex1)
    <=> v3056(VarCurr,bitIndex1) ) ).

fof(addAssignment_2999,axiom,
    ! [VarCurr] :
      ( v3056(VarCurr,bitIndex1)
    <=> v3058(VarCurr,bitIndex1) ) ).

fof(addAssignment_2998,axiom,
    ! [VarCurr] :
      ( v3058(VarCurr,bitIndex1)
    <=> v3060(VarCurr,bitIndex1) ) ).

fof(addAssignment_2997,axiom,
    ! [VarCurr] :
      ( v3060(VarCurr,bitIndex1)
    <=> v3062(VarCurr,bitIndex1) ) ).

fof(addAssignment_2996,axiom,
    ! [VarCurr] :
      ( v3062(VarCurr,bitIndex1)
    <=> v3064(VarCurr,bitIndex1) ) ).

fof(addAssignment_2995,axiom,
    ! [VarCurr] :
      ( v3064(VarCurr,bitIndex1)
    <=> v3066(VarCurr,bitIndex1) ) ).

fof(addAssignment_2994,axiom,
    ! [VarCurr] :
      ( v3066(VarCurr,bitIndex1)
    <=> v3068(VarCurr,bitIndex1) ) ).

fof(addAssignment_2993,axiom,
    ! [VarCurr] :
      ( v3068(VarCurr,bitIndex1)
    <=> v3070(VarCurr,bitIndex1) ) ).

fof(addAssignment_2992,axiom,
    ! [VarNext] :
      ( v3070(VarNext,bitIndex1)
    <=> v5572(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5573(VarNext)
       => ! [B] :
            ( range_63_0(B)
           => ( v5572(VarNext,B)
            <=> v3070(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_44,axiom,
    ! [VarNext] :
      ( v5573(VarNext)
     => ! [B] :
          ( range_63_0(B)
         => ( v5572(VarNext,B)
          <=> v5003(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_746,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5573(VarNext)
      <=> v5574(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_745,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5574(VarNext)
      <=> ( v5576(VarNext)
          & v3679(VarNext) ) ) ) ).

fof(writeUnaryOperator_365,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5576(VarNext)
      <=> v3692(VarNext) ) ) ).

fof(addAssignment_2991,axiom,
    ! [VarCurr] :
      ( v3075(VarCurr,bitIndex1)
    <=> v3077(VarCurr,bitIndex1) ) ).

fof(addAssignment_2990,axiom,
    ! [VarCurr] :
      ( v3077(VarCurr,bitIndex1)
    <=> v3079(VarCurr,bitIndex1) ) ).

fof(addAssignment_2989,axiom,
    ! [VarCurr] :
      ( v3079(VarCurr,bitIndex1)
    <=> v3081(VarCurr,bitIndex1) ) ).

fof(addAssignment_2988,axiom,
    ! [VarCurr] :
      ( v3081(VarCurr,bitIndex1)
    <=> v3083(VarCurr,bitIndex1) ) ).

fof(addAssignment_2987,axiom,
    ! [VarCurr] :
      ( v3083(VarCurr,bitIndex1)
    <=> v3085(VarCurr,bitIndex1) ) ).

fof(addAssignment_2986,axiom,
    ! [VarCurr] :
      ( v3085(VarCurr,bitIndex1)
    <=> v3087(VarCurr,bitIndex1) ) ).

fof(addAssignment_2985,axiom,
    ! [VarCurr] :
      ( v3087(VarCurr,bitIndex1)
    <=> v3089(VarCurr,bitIndex1) ) ).

fof(addAssignment_2984,axiom,
    ! [VarCurr] :
      ( v3089(VarCurr,bitIndex1)
    <=> v3091(VarCurr,bitIndex1) ) ).

fof(addAssignment_2983,axiom,
    ! [VarCurr] :
      ( v3091(VarCurr,bitIndex1)
    <=> v3093(VarCurr,bitIndex1) ) ).

fof(addAssignment_2982,axiom,
    ! [VarCurr] :
      ( v3093(VarCurr,bitIndex1)
    <=> v3095(VarCurr,bitIndex1) ) ).

fof(addAssignment_2981,axiom,
    ! [VarCurr] :
      ( v3095(VarCurr,bitIndex1)
    <=> v3097(VarCurr,bitIndex1) ) ).

fof(addAssignment_2980,axiom,
    ! [VarNext] :
      ( v3097(VarNext,bitIndex1)
    <=> v5564(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionEqualRanges1_40,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5566(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v5564(VarNext,B)
            <=> v3097(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_43,axiom,
    ! [VarNext] :
      ( v5566(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v5564(VarNext,B)
          <=> v4988(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_744,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5566(VarNext)
      <=> ( v5567(VarNext)
          & v4982(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_743,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5567(VarNext)
      <=> ( v5569(VarNext)
          & v3202(VarNext) ) ) ) ).

fof(writeUnaryOperator_364,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5569(VarNext)
      <=> v3211(VarNext) ) ) ).

fof(addAssignment_2979,axiom,
    ! [VarCurr] :
      ( v5560(VarCurr)
    <=> $false ) ).

fof(addAssignment_2978,axiom,
    ! [VarCurr] :
      ( v5558(VarCurr)
    <=> $false ) ).

fof(addAssignment_2977,axiom,
    ! [VarCurr] :
      ( v5556(VarCurr)
    <=> $true ) ).

fof(addAssignment_2976,axiom,
    ! [VarCurr] :
      ( v5554(VarCurr)
    <=> $false ) ).

fof(addAssignment_2975,axiom,
    ! [VarCurr] :
      ( v5552(VarCurr)
    <=> v3022(VarCurr) ) ).

fof(addAssignment_2974,axiom,
    ! [VarCurr] :
      ( v5534(VarCurr)
    <=> v5536(VarCurr) ) ).

fof(addAssignment_2973,axiom,
    ! [VarCurr] :
      ( v5536(VarCurr)
    <=> v5538(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_742,axiom,
    ! [VarCurr] :
      ( v5172(VarCurr)
    <=> ( v5525(VarCurr)
        & v2996(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_741,axiom,
    ! [VarCurr] :
      ( v5525(VarCurr)
    <=> ( v5526(VarCurr)
        | v5529(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_740,axiom,
    ! [VarCurr] :
      ( v5529(VarCurr)
    <=> ( v5530(VarCurr)
        & v5531(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_523,axiom,
    ! [VarCurr] :
      ( v5531(VarCurr)
    <=> ( ( v5532(VarCurr,bitIndex4)
        <=> $true )
        & ( v5532(VarCurr,bitIndex3)
        <=> $true )
        & ( v5532(VarCurr,bitIndex2)
        <=> $true )
        & ( v5532(VarCurr,bitIndex1)
        <=> $true )
        & ( v5532(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2972,axiom,
    ! [VarCurr] :
      ( v5532(VarCurr,bitIndex0)
    <=> v5485(VarCurr) ) ).

fof(addAssignment_2971,axiom,
    ! [VarCurr] :
      ( v5532(VarCurr,bitIndex1)
    <=> v5480(VarCurr) ) ).

fof(addAssignment_2970,axiom,
    ! [VarCurr] :
      ( v5532(VarCurr,bitIndex2)
    <=> v5475(VarCurr) ) ).

fof(addAssignment_2969,axiom,
    ! [VarCurr] :
      ( v5532(VarCurr,bitIndex3)
    <=> v5470(VarCurr) ) ).

fof(addAssignment_2968,axiom,
    ! [VarCurr] :
      ( v5532(VarCurr,bitIndex4)
    <=> v5443(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_522,axiom,
    ! [VarCurr] :
      ( v5530(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_739,axiom,
    ! [VarCurr] :
      ( v5526(VarCurr)
    <=> ( v5527(VarCurr)
        | v5528(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_521,axiom,
    ! [VarCurr] :
      ( v5528(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_520,axiom,
    ! [VarCurr] :
      ( v5527(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $false )
        & ( v5174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_39,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5510(VarNext)
       => ! [B] :
            ( range_1_0(B)
           => ( v5174(VarNext,B)
            <=> v5174(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_42,axiom,
    ! [VarNext] :
      ( v5510(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v5174(VarNext,B)
          <=> v5518(VarNext,B) ) ) ) ).

fof(addAssignment_2967,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v5518(VarNext,B)
          <=> v5516(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_233,axiom,
    ! [VarCurr] :
      ( ~ v5519(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5516(VarCurr,B)
          <=> v5176(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_235,axiom,
    ! [VarCurr] :
      ( v5519(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5516(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_738,axiom,
    ! [VarCurr] :
      ( v5519(VarCurr)
    <=> ( v5520(VarCurr)
        | v5521(VarCurr) ) ) ).

fof(writeUnaryOperator_363,axiom,
    ! [VarCurr] :
      ( ~ v5521(VarCurr)
    <=> v2996(VarCurr) ) ).

fof(writeUnaryOperator_362,axiom,
    ! [VarCurr] :
      ( ~ v5520(VarCurr)
    <=> v10(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_737,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5510(VarNext)
      <=> v5511(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_736,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5511(VarNext)
      <=> ( v5512(VarNext)
          & v1853(VarNext) ) ) ) ).

fof(writeUnaryOperator_361,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5512(VarNext)
      <=> v2979(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_12,axiom,
    ! [VarCurr] :
      ( ( ~ v5419(VarCurr)
        & ~ v5423(VarCurr)
        & ~ v5435(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v5176(VarCurr,B)
          <=> v5489(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_138,axiom,
    ! [VarCurr] :
      ( v5435(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5176(VarCurr,B)
          <=> v5436(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_156,axiom,
    ! [VarCurr] :
      ( v5423(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5176(VarCurr,B)
          <=> v5424(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_157,axiom,
    ! [VarCurr] :
      ( v5419(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5176(VarCurr,B)
          <=> v5420(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_232,axiom,
    ! [VarCurr] :
      ( ~ v2443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5489(VarCurr,B)
          <=> v5490(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_234,axiom,
    ! [VarCurr] :
      ( v2443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5489(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_231,axiom,
    ! [VarCurr] :
      ( ~ v5491(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5490(VarCurr,B)
          <=> v5492(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_233,axiom,
    ! [VarCurr] :
      ( v5491(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5490(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_230,axiom,
    ! [VarCurr] :
      ( ~ v5493(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5492(VarCurr,B)
          <=> $true ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_232,axiom,
    ! [VarCurr] :
      ( v5493(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5492(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_735,axiom,
    ! [VarCurr] :
      ( v5493(VarCurr)
    <=> ( v5495(VarCurr)
        | v5497(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_580,axiom,
    ! [VarCurr] :
      ( v5497(VarCurr)
    <=> ( v5498(VarCurr)
        & v5496(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_734,axiom,
    ! [VarCurr] :
      ( v5498(VarCurr)
    <=> ( v5499(VarCurr)
        | v5500(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_579,axiom,
    ! [VarCurr] :
      ( v5500(VarCurr)
    <=> ( v5501(VarCurr)
        & v5496(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_733,axiom,
    ! [VarCurr] :
      ( v5501(VarCurr)
    <=> ( v5502(VarCurr)
        | v5503(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_578,axiom,
    ! [VarCurr] :
      ( v5503(VarCurr)
    <=> ( v5504(VarCurr)
        & v5496(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_732,axiom,
    ! [VarCurr] :
      ( v5504(VarCurr)
    <=> ( v5505(VarCurr)
        | v5506(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_577,axiom,
    ! [VarCurr] :
      ( v5506(VarCurr)
    <=> ( v5507(VarCurr)
        & v5496(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_360,axiom,
    ! [VarCurr] :
      ( ~ v5507(VarCurr)
    <=> v5496(VarCurr,bitIndex0) ) ).

fof(writeUnaryOperator_359,axiom,
    ! [VarCurr] :
      ( ~ v5505(VarCurr)
    <=> v5496(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_358,axiom,
    ! [VarCurr] :
      ( ~ v5502(VarCurr)
    <=> v5496(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_357,axiom,
    ! [VarCurr] :
      ( ~ v5499(VarCurr)
    <=> v5496(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_356,axiom,
    ! [VarCurr] :
      ( ~ v5495(VarCurr)
    <=> v5496(VarCurr,bitIndex4) ) ).

fof(addAssignment_2966,axiom,
    ! [VarCurr] :
      ( v5496(VarCurr,bitIndex0)
    <=> v5485(VarCurr) ) ).

fof(addAssignment_2965,axiom,
    ! [VarCurr] :
      ( v5496(VarCurr,bitIndex1)
    <=> v5480(VarCurr) ) ).

fof(addAssignment_2964,axiom,
    ! [VarCurr] :
      ( v5496(VarCurr,bitIndex2)
    <=> v5475(VarCurr) ) ).

fof(addAssignment_2963,axiom,
    ! [VarCurr] :
      ( v5496(VarCurr,bitIndex3)
    <=> v5470(VarCurr) ) ).

fof(addAssignment_2962,axiom,
    ! [VarCurr] :
      ( v5496(VarCurr,bitIndex4)
    <=> v5443(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_519,axiom,
    ! [VarCurr] :
      ( v5491(VarCurr)
    <=> ( ( v5202(VarCurr,bitIndex4)
        <=> $false )
        & ( v5202(VarCurr,bitIndex3)
        <=> $false )
        & ( v5202(VarCurr,bitIndex2)
        <=> $false )
        & ( v5202(VarCurr,bitIndex1)
        <=> $false )
        & ( v5202(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_518,axiom,
    ! [VarCurr] :
      ( v5488(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_229,axiom,
    ! [VarCurr] :
      ( ~ v2443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5436(VarCurr,B)
          <=> v5437(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_231,axiom,
    ! [VarCurr] :
      ( v2443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5436(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_228,axiom,
    ! [VarCurr] :
      ( ~ v5438(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5437(VarCurr,B)
          <=> v5439(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_230,axiom,
    ! [VarCurr] :
      ( v5438(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5437(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_227,axiom,
    ! [VarCurr] :
      ( ~ v5440(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5439(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_229,axiom,
    ! [VarCurr] :
      ( v5440(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5439(VarCurr,B)
          <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_517,axiom,
    ! [VarCurr] :
      ( v5440(VarCurr)
    <=> ( ( v5441(VarCurr,bitIndex4)
        <=> $true )
        & ( v5441(VarCurr,bitIndex3)
        <=> $true )
        & ( v5441(VarCurr,bitIndex2)
        <=> $true )
        & ( v5441(VarCurr,bitIndex1)
        <=> $true )
        & ( v5441(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2961,axiom,
    ! [VarCurr] :
      ( v5441(VarCurr,bitIndex0)
    <=> v5485(VarCurr) ) ).

fof(addAssignment_2960,axiom,
    ! [VarCurr] :
      ( v5441(VarCurr,bitIndex1)
    <=> v5480(VarCurr) ) ).

fof(addAssignment_2959,axiom,
    ! [VarCurr] :
      ( v5441(VarCurr,bitIndex2)
    <=> v5475(VarCurr) ) ).

fof(addAssignment_2958,axiom,
    ! [VarCurr] :
      ( v5441(VarCurr,bitIndex3)
    <=> v5470(VarCurr) ) ).

fof(addAssignment_2957,axiom,
    ! [VarCurr] :
      ( v5441(VarCurr,bitIndex4)
    <=> v5443(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_731,axiom,
    ! [VarCurr] :
      ( v5485(VarCurr)
    <=> ( v5486(VarCurr)
        & v5487(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_730,axiom,
    ! [VarCurr] :
      ( v5487(VarCurr)
    <=> ( v5202(VarCurr,bitIndex0)
        | v5359(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_729,axiom,
    ! [VarCurr] :
      ( v5486(VarCurr)
    <=> ( v5330(VarCurr)
        | v5413(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_728,axiom,
    ! [VarCurr] :
      ( v5480(VarCurr)
    <=> ( v5481(VarCurr)
        & v5484(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_727,axiom,
    ! [VarCurr] :
      ( v5484(VarCurr)
    <=> ( v5452(VarCurr)
        | v5453(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_726,axiom,
    ! [VarCurr] :
      ( v5481(VarCurr)
    <=> ( v5482(VarCurr)
        | v5483(VarCurr) ) ) ).

fof(writeUnaryOperator_355,axiom,
    ! [VarCurr] :
      ( ~ v5483(VarCurr)
    <=> v5453(VarCurr) ) ).

fof(writeUnaryOperator_354,axiom,
    ! [VarCurr] :
      ( ~ v5482(VarCurr)
    <=> v5452(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_725,axiom,
    ! [VarCurr] :
      ( v5475(VarCurr)
    <=> ( v5476(VarCurr)
        & v5479(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_724,axiom,
    ! [VarCurr] :
      ( v5479(VarCurr)
    <=> ( v5450(VarCurr)
        | v5457(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_723,axiom,
    ! [VarCurr] :
      ( v5476(VarCurr)
    <=> ( v5477(VarCurr)
        | v5478(VarCurr) ) ) ).

fof(writeUnaryOperator_353,axiom,
    ! [VarCurr] :
      ( ~ v5478(VarCurr)
    <=> v5457(VarCurr) ) ).

fof(writeUnaryOperator_352,axiom,
    ! [VarCurr] :
      ( ~ v5477(VarCurr)
    <=> v5450(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_722,axiom,
    ! [VarCurr] :
      ( v5470(VarCurr)
    <=> ( v5471(VarCurr)
        & v5474(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_721,axiom,
    ! [VarCurr] :
      ( v5474(VarCurr)
    <=> ( v5448(VarCurr)
        | v5461(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_720,axiom,
    ! [VarCurr] :
      ( v5471(VarCurr)
    <=> ( v5472(VarCurr)
        | v5473(VarCurr) ) ) ).

fof(writeUnaryOperator_351,axiom,
    ! [VarCurr] :
      ( ~ v5473(VarCurr)
    <=> v5461(VarCurr) ) ).

fof(writeUnaryOperator_350,axiom,
    ! [VarCurr] :
      ( ~ v5472(VarCurr)
    <=> v5448(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_719,axiom,
    ! [VarCurr] :
      ( v5443(VarCurr)
    <=> ( v5444(VarCurr)
        & v5469(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_718,axiom,
    ! [VarCurr] :
      ( v5469(VarCurr)
    <=> ( v5446(VarCurr)
        | v5466(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_717,axiom,
    ! [VarCurr] :
      ( v5444(VarCurr)
    <=> ( v5445(VarCurr)
        | v5465(VarCurr) ) ) ).

fof(writeUnaryOperator_349,axiom,
    ! [VarCurr] :
      ( ~ v5465(VarCurr)
    <=> v5466(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_716,axiom,
    ! [VarCurr] :
      ( v5466(VarCurr)
    <=> ( v5467(VarCurr)
        & v5468(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_576,axiom,
    ! [VarCurr] :
      ( v5468(VarCurr)
    <=> ( v5202(VarCurr,bitIndex4)
        | v5359(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_715,axiom,
    ! [VarCurr] :
      ( v5467(VarCurr)
    <=> ( v5316(VarCurr)
        | v5399(VarCurr) ) ) ).

fof(writeUnaryOperator_348,axiom,
    ! [VarCurr] :
      ( ~ v5445(VarCurr)
    <=> v5446(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_714,axiom,
    ! [VarCurr] :
      ( v5446(VarCurr)
    <=> ( v5447(VarCurr)
        | v5464(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_575,axiom,
    ! [VarCurr] :
      ( v5464(VarCurr)
    <=> ( v5202(VarCurr,bitIndex3)
        & v5359(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_713,axiom,
    ! [VarCurr] :
      ( v5447(VarCurr)
    <=> ( v5448(VarCurr)
        & v5461(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_712,axiom,
    ! [VarCurr] :
      ( v5461(VarCurr)
    <=> ( v5462(VarCurr)
        & v5463(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_574,axiom,
    ! [VarCurr] :
      ( v5463(VarCurr)
    <=> ( v5202(VarCurr,bitIndex3)
        | v5359(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_711,axiom,
    ! [VarCurr] :
      ( v5462(VarCurr)
    <=> ( v5321(VarCurr)
        | v5404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_710,axiom,
    ! [VarCurr] :
      ( v5448(VarCurr)
    <=> ( v5449(VarCurr)
        | v5460(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_573,axiom,
    ! [VarCurr] :
      ( v5460(VarCurr)
    <=> ( v5202(VarCurr,bitIndex2)
        & v5359(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_709,axiom,
    ! [VarCurr] :
      ( v5449(VarCurr)
    <=> ( v5450(VarCurr)
        & v5457(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_708,axiom,
    ! [VarCurr] :
      ( v5457(VarCurr)
    <=> ( v5458(VarCurr)
        & v5459(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_572,axiom,
    ! [VarCurr] :
      ( v5459(VarCurr)
    <=> ( v5202(VarCurr,bitIndex2)
        | v5359(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_707,axiom,
    ! [VarCurr] :
      ( v5458(VarCurr)
    <=> ( v5326(VarCurr)
        | v5409(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_706,axiom,
    ! [VarCurr] :
      ( v5450(VarCurr)
    <=> ( v5451(VarCurr)
        | v5456(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_571,axiom,
    ! [VarCurr] :
      ( v5456(VarCurr)
    <=> ( v5202(VarCurr,bitIndex1)
        & v5359(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_705,axiom,
    ! [VarCurr] :
      ( v5451(VarCurr)
    <=> ( v5452(VarCurr)
        & v5453(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_704,axiom,
    ! [VarCurr] :
      ( v5453(VarCurr)
    <=> ( v5454(VarCurr)
        & v5455(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_570,axiom,
    ! [VarCurr] :
      ( v5455(VarCurr)
    <=> ( v5202(VarCurr,bitIndex1)
        | v5359(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_703,axiom,
    ! [VarCurr] :
      ( v5454(VarCurr)
    <=> ( v5331(VarCurr)
        | v5414(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_702,axiom,
    ! [VarCurr] :
      ( v5452(VarCurr)
    <=> ( v5202(VarCurr,bitIndex0)
        & v5359(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_516,axiom,
    ! [VarCurr] :
      ( v5438(VarCurr)
    <=> ( ( v5202(VarCurr,bitIndex4)
        <=> $false )
        & ( v5202(VarCurr,bitIndex3)
        <=> $false )
        & ( v5202(VarCurr,bitIndex2)
        <=> $false )
        & ( v5202(VarCurr,bitIndex1)
        <=> $false )
        & ( v5202(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_515,axiom,
    ! [VarCurr] :
      ( v5435(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_226,axiom,
    ! [VarCurr] :
      ( ~ v5425(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5424(VarCurr,B)
          <=> v5427(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_228,axiom,
    ! [VarCurr] :
      ( v5425(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5424(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_225,axiom,
    ! [VarCurr] :
      ( ~ v5428(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5427(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_227,axiom,
    ! [VarCurr] :
      ( v5428(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5427(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_701,axiom,
    ! [VarCurr] :
      ( v5428(VarCurr)
    <=> ( v1885(VarCurr)
        & v5429(VarCurr) ) ) ).

fof(writeUnaryOperator_347,axiom,
    ! [VarCurr] :
      ( ~ v5429(VarCurr)
    <=> v5431(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_700,axiom,
    ! [VarCurr] :
      ( v5431(VarCurr)
    <=> ( v5432(VarCurr)
        & v5316(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_699,axiom,
    ! [VarCurr] :
      ( v5432(VarCurr)
    <=> ( v5433(VarCurr)
        & v5321(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_698,axiom,
    ! [VarCurr] :
      ( v5433(VarCurr)
    <=> ( v5434(VarCurr)
        & v5326(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_697,axiom,
    ! [VarCurr] :
      ( v5434(VarCurr)
    <=> ( v5330(VarCurr)
        & v5331(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_696,axiom,
    ! [VarCurr] :
      ( v5425(VarCurr)
    <=> ( v1885(VarCurr)
        & v5426(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_514,axiom,
    ! [VarCurr] :
      ( v5426(VarCurr)
    <=> ( ( v5202(VarCurr,bitIndex4)
        <=> $false )
        & ( v5202(VarCurr,bitIndex3)
        <=> $false )
        & ( v5202(VarCurr,bitIndex2)
        <=> $false )
        & ( v5202(VarCurr,bitIndex1)
        <=> $false )
        & ( v5202(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_513,axiom,
    ! [VarCurr] :
      ( v5423(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $false )
        & ( v5174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_224,axiom,
    ! [VarCurr] :
      ( ~ v5178(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5420(VarCurr,B)
          <=> v5421(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_226,axiom,
    ! [VarCurr] :
      ( v5178(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5420(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_223,axiom,
    ! [VarCurr] :
      ( ~ v2443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5421(VarCurr,B)
          <=> v5422(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_225,axiom,
    ! [VarCurr] :
      ( v2443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5421(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_222,axiom,
    ! [VarCurr] :
      ( ~ v5188(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5422(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_224,axiom,
    ! [VarCurr] :
      ( v5188(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v5422(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_512,axiom,
    ! [VarCurr] :
      ( v5419(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $false )
        & ( v5174(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_38,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5372(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v5359(VarNext,B)
            <=> v5359(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_41,axiom,
    ! [VarNext] :
      ( v5372(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5359(VarNext,B)
          <=> v5389(VarNext,B) ) ) ) ).

fof(addAssignment_2956,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5389(VarNext,B)
          <=> v5387(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_221,axiom,
    ! [VarCurr] :
      ( ~ v5384(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5387(VarCurr,B)
          <=> v5390(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_223,axiom,
    ! [VarCurr] :
      ( v5384(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5387(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_220,axiom,
    ! [VarCurr] :
      ( ~ v5361(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5390(VarCurr,B)
          <=> v5391(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_222,axiom,
    ! [VarCurr] :
      ( v5361(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5390(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_2955,axiom,
    ! [VarCurr] :
      ( v5391(VarCurr,bitIndex0)
    <=> v5413(VarCurr) ) ).

fof(addAssignment_2954,axiom,
    ! [VarCurr] :
      ( v5391(VarCurr,bitIndex1)
    <=> v5411(VarCurr) ) ).

fof(addAssignment_2953,axiom,
    ! [VarCurr] :
      ( v5391(VarCurr,bitIndex2)
    <=> v5406(VarCurr) ) ).

fof(addAssignment_2952,axiom,
    ! [VarCurr] :
      ( v5391(VarCurr,bitIndex3)
    <=> v5401(VarCurr) ) ).

fof(addAssignment_2951,axiom,
    ! [VarCurr] :
      ( v5391(VarCurr,bitIndex4)
    <=> v5393(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_695,axiom,
    ! [VarCurr] :
      ( v5411(VarCurr)
    <=> ( v5412(VarCurr)
        & v5415(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_569,axiom,
    ! [VarCurr] :
      ( v5415(VarCurr)
    <=> ( v5359(VarCurr,bitIndex0)
        | v5359(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_694,axiom,
    ! [VarCurr] :
      ( v5412(VarCurr)
    <=> ( v5413(VarCurr)
        | v5414(VarCurr) ) ) ).

fof(writeUnaryOperator_346,axiom,
    ! [VarCurr] :
      ( ~ v5414(VarCurr)
    <=> v5359(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_345,axiom,
    ! [VarCurr] :
      ( ~ v5413(VarCurr)
    <=> v5359(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_693,axiom,
    ! [VarCurr] :
      ( v5406(VarCurr)
    <=> ( v5407(VarCurr)
        & v5410(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_568,axiom,
    ! [VarCurr] :
      ( v5410(VarCurr)
    <=> ( v5398(VarCurr)
        | v5359(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_692,axiom,
    ! [VarCurr] :
      ( v5407(VarCurr)
    <=> ( v5408(VarCurr)
        | v5409(VarCurr) ) ) ).

fof(writeUnaryOperator_344,axiom,
    ! [VarCurr] :
      ( ~ v5409(VarCurr)
    <=> v5359(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_343,axiom,
    ! [VarCurr] :
      ( ~ v5408(VarCurr)
    <=> v5398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_691,axiom,
    ! [VarCurr] :
      ( v5401(VarCurr)
    <=> ( v5402(VarCurr)
        & v5405(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_567,axiom,
    ! [VarCurr] :
      ( v5405(VarCurr)
    <=> ( v5397(VarCurr)
        | v5359(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_690,axiom,
    ! [VarCurr] :
      ( v5402(VarCurr)
    <=> ( v5403(VarCurr)
        | v5404(VarCurr) ) ) ).

fof(writeUnaryOperator_342,axiom,
    ! [VarCurr] :
      ( ~ v5404(VarCurr)
    <=> v5359(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_341,axiom,
    ! [VarCurr] :
      ( ~ v5403(VarCurr)
    <=> v5397(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_689,axiom,
    ! [VarCurr] :
      ( v5393(VarCurr)
    <=> ( v5394(VarCurr)
        & v5400(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_566,axiom,
    ! [VarCurr] :
      ( v5400(VarCurr)
    <=> ( v5396(VarCurr)
        | v5359(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_688,axiom,
    ! [VarCurr] :
      ( v5394(VarCurr)
    <=> ( v5395(VarCurr)
        | v5399(VarCurr) ) ) ).

fof(writeUnaryOperator_340,axiom,
    ! [VarCurr] :
      ( ~ v5399(VarCurr)
    <=> v5359(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_339,axiom,
    ! [VarCurr] :
      ( ~ v5395(VarCurr)
    <=> v5396(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_565,axiom,
    ! [VarCurr] :
      ( v5396(VarCurr)
    <=> ( v5397(VarCurr)
        & v5359(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_564,axiom,
    ! [VarCurr] :
      ( v5397(VarCurr)
    <=> ( v5398(VarCurr)
        & v5359(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_563,axiom,
    ! [VarCurr] :
      ( v5398(VarCurr)
    <=> ( v5359(VarCurr,bitIndex0)
        & v5359(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_687,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5372(VarNext)
      <=> ( v5373(VarNext)
          & v5380(VarNext) ) ) ) ).

fof(addAssignment_2950,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5380(VarNext)
      <=> v5378(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_686,axiom,
    ! [VarCurr] :
      ( v5378(VarCurr)
    <=> ( v5381(VarCurr)
        | v5384(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_685,axiom,
    ! [VarCurr] :
      ( v5384(VarCurr)
    <=> ( v5385(VarCurr)
        | v5386(VarCurr) ) ) ).

fof(writeUnaryOperator_338,axiom,
    ! [VarCurr] :
      ( ~ v5386(VarCurr)
    <=> v2996(VarCurr) ) ).

fof(writeUnaryOperator_337,axiom,
    ! [VarCurr] :
      ( ~ v5385(VarCurr)
    <=> v10(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_684,axiom,
    ! [VarCurr] :
      ( v5381(VarCurr)
    <=> ( v5382(VarCurr)
        | v5361(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_683,axiom,
    ! [VarCurr] :
      ( v5382(VarCurr)
    <=> ( v5178(VarCurr)
        & v5383(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_511,axiom,
    ! [VarCurr] :
      ( v5383(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_682,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5373(VarNext)
      <=> ( v5374(VarNext)
          & v1853(VarNext) ) ) ) ).

fof(writeUnaryOperator_336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5374(VarNext)
      <=> v2979(VarNext) ) ) ).

fof(addAssignmentInitValueVector_41,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v5359(constB0,B)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_681,axiom,
    ! [VarCurr] :
      ( v5361(VarCurr)
    <=> ( v5363(VarCurr)
        | v5365(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_680,axiom,
    ! [VarCurr] :
      ( v5365(VarCurr)
    <=> ( v5366(VarCurr)
        & v5369(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_510,axiom,
    ! [VarCurr] :
      ( v5369(VarCurr)
    <=> ( ( v5202(VarCurr,bitIndex4)
        <=> $false )
        & ( v5202(VarCurr,bitIndex3)
        <=> $false )
        & ( v5202(VarCurr,bitIndex2)
        <=> $false )
        & ( v5202(VarCurr,bitIndex1)
        <=> $false )
        & ( v5202(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_679,axiom,
    ! [VarCurr] :
      ( v5366(VarCurr)
    <=> ( v5367(VarCurr)
        | v5368(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_509,axiom,
    ! [VarCurr] :
      ( v5368(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_508,axiom,
    ! [VarCurr] :
      ( v5367(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $true )
        & ( v5174(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_678,axiom,
    ! [VarCurr] :
      ( v5363(VarCurr)
    <=> ( v5364(VarCurr)
        & v1885(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_507,axiom,
    ! [VarCurr] :
      ( v5364(VarCurr)
    <=> ( ( v5174(VarCurr,bitIndex1)
        <=> $false )
        & ( v5174(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignmentInitValueVector_40,axiom,
    ! [B] :
      ( range_1_0(B)
     => ( v5174(constB0,B)
      <=> $false ) ) ).

fof(addCaseBooleanConditionEqualRanges1_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5287(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v5202(VarNext,B)
            <=> v5202(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_40,axiom,
    ! [VarNext] :
      ( v5287(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5202(VarNext,B)
          <=> v5306(VarNext,B) ) ) ) ).

fof(addAssignment_2949,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v5306(VarNext,B)
          <=> v5304(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_219,axiom,
    ! [VarCurr] :
      ( ~ v5301(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5304(VarCurr,B)
          <=> v5307(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_221,axiom,
    ! [VarCurr] :
      ( v5301(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5304(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_218,axiom,
    ! [VarCurr] :
      ( ~ v5299(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5307(VarCurr,B)
          <=> v5333(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_220,axiom,
    ! [VarCurr] :
      ( v5299(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v5307(VarCurr,B)
          <=> v5308(VarCurr,B) ) ) ) ).

fof(addAssignment_2948,axiom,
    ! [VarCurr] :
      ( v5333(VarCurr,bitIndex0)
    <=> v5330(VarCurr) ) ).

fof(addAssignment_2947,axiom,
    ! [VarCurr] :
      ( v5333(VarCurr,bitIndex1)
    <=> v5353(VarCurr) ) ).

fof(addAssignment_2946,axiom,
    ! [VarCurr] :
      ( v5333(VarCurr,bitIndex2)
    <=> v5349(VarCurr) ) ).

fof(addAssignment_2945,axiom,
    ! [VarCurr] :
      ( v5333(VarCurr,bitIndex3)
    <=> v5345(VarCurr) ) ).

fof(addAssignment_2944,axiom,
    ! [VarCurr] :
      ( v5333(VarCurr,bitIndex4)
    <=> v5335(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_677,axiom,
    ! [VarCurr] :
      ( v5353(VarCurr)
    <=> ( v5354(VarCurr)
        & v5355(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_676,axiom,
    ! [VarCurr] :
      ( v5355(VarCurr)
    <=> ( v5202(VarCurr,bitIndex0)
        | v5331(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_562,axiom,
    ! [VarCurr] :
      ( v5354(VarCurr)
    <=> ( v5330(VarCurr)
        | v5202(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_675,axiom,
    ! [VarCurr] :
      ( v5349(VarCurr)
    <=> ( v5350(VarCurr)
        & v5352(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_674,axiom,
    ! [VarCurr] :
      ( v5352(VarCurr)
    <=> ( v5326(VarCurr)
        | v5342(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_561,axiom,
    ! [VarCurr] :
      ( v5350(VarCurr)
    <=> ( v5202(VarCurr,bitIndex2)
        | v5351(VarCurr) ) ) ).

fof(writeUnaryOperator_335,axiom,
    ! [VarCurr] :
      ( ~ v5351(VarCurr)
    <=> v5342(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_673,axiom,
    ! [VarCurr] :
      ( v5345(VarCurr)
    <=> ( v5346(VarCurr)
        & v5348(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_672,axiom,
    ! [VarCurr] :
      ( v5348(VarCurr)
    <=> ( v5321(VarCurr)
        | v5340(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_560,axiom,
    ! [VarCurr] :
      ( v5346(VarCurr)
    <=> ( v5202(VarCurr,bitIndex3)
        | v5347(VarCurr) ) ) ).

fof(writeUnaryOperator_334,axiom,
    ! [VarCurr] :
      ( ~ v5347(VarCurr)
    <=> v5340(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_671,axiom,
    ! [VarCurr] :
      ( v5335(VarCurr)
    <=> ( v5336(VarCurr)
        & v5344(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_670,axiom,
    ! [VarCurr] :
      ( v5344(VarCurr)
    <=> ( v5316(VarCurr)
        | v5338(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_559,axiom,
    ! [VarCurr] :
      ( v5336(VarCurr)
    <=> ( v5202(VarCurr,bitIndex4)
        | v5337(VarCurr) ) ) ).

fof(writeUnaryOperator_333,axiom,
    ! [VarCurr] :
      ( ~ v5337(VarCurr)
    <=> v5338(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_558,axiom,
    ! [VarCurr] :
      ( v5338(VarCurr)
    <=> ( v5202(VarCurr,bitIndex3)
        | v5339(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_669,axiom,
    ! [VarCurr] :
      ( v5339(VarCurr)
    <=> ( v5321(VarCurr)
        & v5340(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_557,axiom,
    ! [VarCurr] :
      ( v5340(VarCurr)
    <=> ( v5202(VarCurr,bitIndex2)
        | v5341(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_668,axiom,
    ! [VarCurr] :
      ( v5341(VarCurr)
    <=> ( v5326(VarCurr)
        & v5342(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_556,axiom,
    ! [VarCurr] :
      ( v5342(VarCurr)
    <=> ( v5202(VarCurr,bitIndex1)
        | v5343(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_667,axiom,
    ! [VarCurr] :
      ( v5343(VarCurr)
    <=> ( v5202(VarCurr,bitIndex0)
        & v5331(VarCurr) ) ) ).

fof(addAssignment_2943,axiom,
    ! [VarCurr] :
      ( v5308(VarCurr,bitIndex0)
    <=> v5330(VarCurr) ) ).

fof(addAssignment_2942,axiom,
    ! [VarCurr] :
      ( v5308(VarCurr,bitIndex1)
    <=> v5328(VarCurr) ) ).

fof(addAssignment_2941,axiom,
    ! [VarCurr] :
      ( v5308(VarCurr,bitIndex2)
    <=> v5323(VarCurr) ) ).

fof(addAssignment_2940,axiom,
    ! [VarCurr] :
      ( v5308(VarCurr,bitIndex3)
    <=> v5318(VarCurr) ) ).

fof(addAssignment_2939,axiom,
    ! [VarCurr] :
      ( v5308(VarCurr,bitIndex4)
    <=> v5310(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_666,axiom,
    ! [VarCurr] :
      ( v5328(VarCurr)
    <=> ( v5329(VarCurr)
        & v5332(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_555,axiom,
    ! [VarCurr] :
      ( v5332(VarCurr)
    <=> ( v5202(VarCurr,bitIndex0)
        | v5202(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_665,axiom,
    ! [VarCurr] :
      ( v5329(VarCurr)
    <=> ( v5330(VarCurr)
        | v5331(VarCurr) ) ) ).

fof(writeUnaryOperator_332,axiom,
    ! [VarCurr] :
      ( ~ v5331(VarCurr)
    <=> v5202(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_331,axiom,
    ! [VarCurr] :
      ( ~ v5330(VarCurr)
    <=> v5202(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_664,axiom,
    ! [VarCurr] :
      ( v5323(VarCurr)
    <=> ( v5324(VarCurr)
        & v5327(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_554,axiom,
    ! [VarCurr] :
      ( v5327(VarCurr)
    <=> ( v5315(VarCurr)
        | v5202(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_663,axiom,
    ! [VarCurr] :
      ( v5324(VarCurr)
    <=> ( v5325(VarCurr)
        | v5326(VarCurr) ) ) ).

fof(writeUnaryOperator_330,axiom,
    ! [VarCurr] :
      ( ~ v5326(VarCurr)
    <=> v5202(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_329,axiom,
    ! [VarCurr] :
      ( ~ v5325(VarCurr)
    <=> v5315(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_662,axiom,
    ! [VarCurr] :
      ( v5318(VarCurr)
    <=> ( v5319(VarCurr)
        & v5322(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_553,axiom,
    ! [VarCurr] :
      ( v5322(VarCurr)
    <=> ( v5314(VarCurr)
        | v5202(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_661,axiom,
    ! [VarCurr] :
      ( v5319(VarCurr)
    <=> ( v5320(VarCurr)
        | v5321(VarCurr) ) ) ).

fof(writeUnaryOperator_328,axiom,
    ! [VarCurr] :
      ( ~ v5321(VarCurr)
    <=> v5202(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_327,axiom,
    ! [VarCurr] :
      ( ~ v5320(VarCurr)
    <=> v5314(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_660,axiom,
    ! [VarCurr] :
      ( v5310(VarCurr)
    <=> ( v5311(VarCurr)
        & v5317(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_552,axiom,
    ! [VarCurr] :
      ( v5317(VarCurr)
    <=> ( v5313(VarCurr)
        | v5202(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_659,axiom,
    ! [VarCurr] :
      ( v5311(VarCurr)
    <=> ( v5312(VarCurr)
        | v5316(VarCurr) ) ) ).

fof(writeUnaryOperator_326,axiom,
    ! [VarCurr] :
      ( ~ v5316(VarCurr)
    <=> v5202(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_325,axiom,
    ! [VarCurr] :
      ( ~ v5312(VarCurr)
    <=> v5313(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_551,axiom,
    ! [VarCurr] :
      ( v5313(VarCurr)
    <=> ( v5314(VarCurr)
        & v5202(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_550,axiom,
    ! [VarCurr] :
      ( v5314(VarCurr)
    <=> ( v5315(VarCurr)
        & v5202(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_549,axiom,
    ! [VarCurr] :
      ( v5315(VarCurr)
    <=> ( v5202(VarCurr,bitIndex0)
        & v5202(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_658,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5287(VarNext)
      <=> ( v5288(VarNext)
          & v5295(VarNext) ) ) ) ).

fof(addAssignment_2938,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5295(VarNext)
      <=> v5293(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_657,axiom,
    ! [VarCurr] :
      ( v5293(VarCurr)
    <=> ( v5296(VarCurr)
        | v5301(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_656,axiom,
    ! [VarCurr] :
      ( v5301(VarCurr)
    <=> ( v5302(VarCurr)
        | v5303(VarCurr) ) ) ).

fof(writeUnaryOperator_324,axiom,
    ! [VarCurr] :
      ( ~ v5303(VarCurr)
    <=> v2996(VarCurr) ) ).

fof(writeUnaryOperator_323,axiom,
    ! [VarCurr] :
      ( ~ v5302(VarCurr)
    <=> v10(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_655,axiom,
    ! [VarCurr] :
      ( v5296(VarCurr)
    <=> ( v5297(VarCurr)
        | v5299(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_654,axiom,
    ! [VarCurr] :
      ( v5299(VarCurr)
    <=> ( v5188(VarCurr)
        & v5300(VarCurr) ) ) ).

fof(writeUnaryOperator_322,axiom,
    ! [VarCurr] :
      ( ~ v5300(VarCurr)
    <=> v5204(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_653,axiom,
    ! [VarCurr] :
      ( v5297(VarCurr)
    <=> ( v5298(VarCurr)
        & v5204(VarCurr) ) ) ).

fof(writeUnaryOperator_321,axiom,
    ! [VarCurr] :
      ( ~ v5298(VarCurr)
    <=> v5188(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_652,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5288(VarNext)
      <=> ( v5289(VarNext)
          & v1853(VarNext) ) ) ) ).

fof(writeUnaryOperator_320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5289(VarNext)
      <=> v2979(VarNext) ) ) ).

fof(addAssignmentInitValueVector_39,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v5202(constB0,B)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_651,axiom,
    ! [VarCurr] :
      ( v5204(VarCurr)
    <=> ( v5206(VarCurr)
        & v5284(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_506,axiom,
    ! [VarCurr] :
      ( v5284(VarCurr)
    <=> ( v5234(VarCurr)
      <=> $true ) ) ).

fof(addAssignment_2937,axiom,
    ! [VarCurr] :
      ( v5234(VarCurr)
    <=> v5236(VarCurr,bitIndex3) ) ).

fof(addAssignment_2936,axiom,
    ! [VarCurr] :
      ( v5236(VarCurr,bitIndex3)
    <=> v5238(VarCurr,bitIndex3) ) ).

fof(addAssignment_2935,axiom,
    ! [VarCurr] :
      ( v5238(VarCurr,bitIndex3)
    <=> v5240(VarCurr,bitIndex3) ) ).

fof(addAssignment_2934,axiom,
    ! [VarNext] :
      ( v5240(VarNext,bitIndex3)
    <=> v5270(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionEqualRanges1_36,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5271(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v5270(VarNext,B)
            <=> v5240(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_39,axiom,
    ! [VarNext] :
      ( v5271(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5270(VarNext,B)
          <=> v5279(VarNext,B) ) ) ) ).

fof(addAssignment_2933,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v5279(VarNext,B)
          <=> v5277(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_217,axiom,
    ! [VarCurr] :
      ( ~ v5280(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5277(VarCurr,B)
          <=> v5242(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_219,axiom,
    ! [VarCurr] :
      ( v5280(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5277(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_319,axiom,
    ! [VarCurr] :
      ( ~ v5280(VarCurr)
    <=> v1690(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_650,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5271(VarNext)
      <=> v5272(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_649,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5272(VarNext)
      <=> ( v5273(VarNext)
          & v1738(VarNext) ) ) ) ).

fof(writeUnaryOperator_318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5273(VarNext)
      <=> v1745(VarNext) ) ) ).

fof(addAssignment_2932,axiom,
    ! [VarCurr] :
      ( v5242(VarCurr,bitIndex3)
    <=> v5268(VarCurr,bitIndex3) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_216,axiom,
    ! [VarCurr] :
      ( ~ v5244(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5268(VarCurr,B)
          <=> v5250(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_218,axiom,
    ! [VarCurr] :
      ( v5244(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5268(VarCurr,B)
          <=> b0011(B) ) ) ) ).

fof(addAssignment_2931,axiom,
    ! [VarCurr] :
      ( v5250(VarCurr,bitIndex3)
    <=> v5251(VarCurr,bitIndex3) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_215,axiom,
    ! [VarCurr] :
      ( ~ v5252(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5251(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_217,axiom,
    ! [VarCurr] :
      ( v5252(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5251(VarCurr,B)
          <=> v5264(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5_1,axiom,
    ! [VarCurr] :
      ( ( ~ v5257(VarCurr)
        & ~ v1375(VarCurr)
        & ~ v1421(VarCurr)
        & ~ v1437(VarCurr)
        & ~ v5259(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v5264(VarCurr,B)
          <=> v5267(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_2,axiom,
    ! [VarCurr] :
      ( v5259(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5264(VarCurr,B)
          <=> v5266(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_11,axiom,
    ! [VarCurr] :
      ( v1437(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5264(VarCurr,B)
          <=> b0100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_137,axiom,
    ! [VarCurr] :
      ( v1421(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5264(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_155,axiom,
    ! [VarCurr] :
      ( v1375(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5264(VarCurr,B)
          <=> v5265(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_156,axiom,
    ! [VarCurr] :
      ( v5257(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5264(VarCurr,B)
          <=> b0010(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_214,axiom,
    ! [VarCurr] :
      ( ~ v1447(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5267(VarCurr,B)
          <=> b1001(B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_216,axiom,
    ! [VarCurr] :
      ( v1447(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5267(VarCurr,B)
          <=> b1000(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_154,axiom,
    ! [VarCurr] :
      ( ~ v5261(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5266(VarCurr,B)
          <=> b1010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_155,axiom,
    ! [VarCurr] :
      ( v5261(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5266(VarCurr,B)
          <=> b1011(B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_213,axiom,
    ! [VarCurr] :
      ( ~ v1447(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5265(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_215,axiom,
    ! [VarCurr] :
      ( v1447(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v5265(VarCurr,B)
          <=> b0001(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_648,axiom,
    ! [VarCurr] :
      ( v5252(VarCurr)
    <=> ( v5253(VarCurr)
        | v5263(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_505,axiom,
    ! [VarCurr] :
      ( v5263(VarCurr)
    <=> ( ( v608(VarCurr,bitIndex6)
        <=> $true )
        & ( v608(VarCurr,bitIndex5)
        <=> $false )
        & ( v608(VarCurr,bitIndex4)
        <=> $false )
        & ( v608(VarCurr,bitIndex3)
        <=> $true )
        & ( v608(VarCurr,bitIndex2)
        <=> $false )
        & ( v608(VarCurr,bitIndex1)
        <=> $true )
        & ( v608(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_647,axiom,
    ! [VarCurr] :
      ( v5253(VarCurr)
    <=> ( v5254(VarCurr)
        | v5259(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_646,axiom,
    ! [VarCurr] :
      ( v5259(VarCurr)
    <=> ( v5260(VarCurr)
        & v1306(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_645,axiom,
    ! [VarCurr] :
      ( v5260(VarCurr)
    <=> ( v5261(VarCurr)
        | v5262(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_504,axiom,
    ! [VarCurr] :
      ( v5262(VarCurr)
    <=> ( ( v604(VarCurr,bitIndex2)
        <=> $true )
        & ( v604(VarCurr,bitIndex1)
        <=> $true )
        & ( v604(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_503,axiom,
    ! [VarCurr] :
      ( v5261(VarCurr)
    <=> ( ( v604(VarCurr,bitIndex2)
        <=> $false )
        & ( v604(VarCurr,bitIndex1)
        <=> $false )
        & ( v604(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_644,axiom,
    ! [VarCurr] :
      ( v5254(VarCurr)
    <=> ( v5255(VarCurr)
        | v1437(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_643,axiom,
    ! [VarCurr] :
      ( v5255(VarCurr)
    <=> ( v5256(VarCurr)
        | v1421(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_642,axiom,
    ! [VarCurr] :
      ( v5256(VarCurr)
    <=> ( v5257(VarCurr)
        | v1375(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_641,axiom,
    ! [VarCurr] :
      ( v5257(VarCurr)
    <=> ( v5258(VarCurr)
        & v615(VarCurr) ) ) ).

fof(writeUnaryOperator_317,axiom,
    ! [VarCurr] :
      ( ~ v5258(VarCurr)
    <=> v604(VarCurr,bitIndex0) ) ).

fof(addAssignment_2930,axiom,
    ! [VarCurr,B] :
      ( range_2_1(B)
     => ( v604(VarCurr,B)
      <=> v606(VarCurr,B) ) ) ).

fof(range_axiom_36,axiom,
    ! [B] :
      ( range_2_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B ) ) ).

fof(addAssignment_2929,axiom,
    ! [VarCurr] :
      ( ( v606(VarCurr,bitIndex2)
      <=> v488(VarCurr,bitIndex14) )
      & ( v606(VarCurr,bitIndex1)
      <=> v488(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_2928,axiom,
    ! [VarCurr,B] :
      ( range_14_13(B)
     => ( v488(VarCurr,B)
      <=> v490(VarCurr,B) ) ) ).

fof(addAssignment_2927,axiom,
    ! [VarCurr,B] :
      ( range_14_13(B)
     => ( v490(VarCurr,B)
      <=> v554(VarCurr,B) ) ) ).

fof(range_axiom_35,axiom,
    ! [B] :
      ( range_14_13(B)
    <=> ( $false
        | bitIndex13 = B
        | bitIndex14 = B ) ) ).

fof(addAssignment_2926,axiom,
    ! [VarCurr] :
      ( v5244(VarCurr)
    <=> v5246(VarCurr) ) ).

fof(addAssignment_2925,axiom,
    ! [VarCurr] :
      ( v5246(VarCurr)
    <=> v5248(VarCurr) ) ).

fof(addAssignment_2924,axiom,
    ! [VarCurr] :
      ( v5248(VarCurr)
    <=> v379(VarCurr) ) ).

fof(addAssignment_2923,axiom,
    ! [VarCurr] :
      ( v5206(VarCurr)
    <=> v5208(VarCurr) ) ).

fof(addAssignment_2922,axiom,
    ! [VarCurr] :
      ( v5208(VarCurr)
    <=> v5210(VarCurr) ) ).

fof(addAssignment_2921,axiom,
    ! [VarCurr] :
      ( v5210(VarCurr)
    <=> v5212(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_35,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5215(VarNext)
       => ( v5212(VarNext)
        <=> v5212(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_38,axiom,
    ! [VarNext] :
      ( v5215(VarNext)
     => ( v5212(VarNext)
      <=> v5223(VarNext) ) ) ).

fof(addAssignment_2920,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5223(VarNext)
      <=> v5221(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_212,axiom,
    ! [VarCurr] :
      ( ~ v5224(VarCurr)
     => ( v5221(VarCurr)
      <=> v5225(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_214,axiom,
    ! [VarCurr] :
      ( v5224(VarCurr)
     => ( v5221(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_640,axiom,
    ! [VarCurr] :
      ( v5225(VarCurr)
    <=> ( v5226(VarCurr)
        | v1297(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_548,axiom,
    ! [VarCurr] :
      ( v5226(VarCurr)
    <=> ( v5227(VarCurr)
        | v146(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_639,axiom,
    ! [VarCurr] :
      ( v5227(VarCurr)
    <=> ( v5228(VarCurr)
        | v480(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_638,axiom,
    ! [VarCurr] :
      ( v5228(VarCurr)
    <=> ( v5229(VarCurr)
        | v379(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_547,axiom,
    ! [VarCurr] :
      ( v5229(VarCurr)
    <=> ( v5230(VarCurr)
        | v146(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_546,axiom,
    ! [VarCurr] :
      ( v5230(VarCurr)
    <=> ( v146(VarCurr,bitIndex3)
        | v146(VarCurr,bitIndex6) ) ) ).

fof(writeUnaryOperator_316,axiom,
    ! [VarCurr] :
      ( ~ v5224(VarCurr)
    <=> v109(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_637,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5215(VarNext)
      <=> v5216(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_636,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5216(VarNext)
      <=> ( v5217(VarNext)
          & v179(VarNext) ) ) ) ).

fof(writeUnaryOperator_315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5217(VarNext)
      <=> v190(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_635,axiom,
    ! [VarCurr] :
      ( v5188(VarCurr)
    <=> ( v5190(VarCurr)
        & v2565(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_634,axiom,
    ! [VarCurr] :
      ( v5190(VarCurr)
    <=> ( v5191(VarCurr)
        | v5200(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_502,axiom,
    ! [VarCurr] :
      ( v5200(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $true )
        & ( v2445(VarCurr,bitIndex2)
        <=> $true )
        & ( v2445(VarCurr,bitIndex1)
        <=> $true )
        & ( v2445(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_633,axiom,
    ! [VarCurr] :
      ( v5191(VarCurr)
    <=> ( v5192(VarCurr)
        | v5199(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_501,axiom,
    ! [VarCurr] :
      ( v5199(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $true )
        & ( v2445(VarCurr,bitIndex2)
        <=> $true )
        & ( v2445(VarCurr,bitIndex1)
        <=> $true )
        & ( v2445(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_632,axiom,
    ! [VarCurr] :
      ( v5192(VarCurr)
    <=> ( v5193(VarCurr)
        | v5198(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_500,axiom,
    ! [VarCurr] :
      ( v5198(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $true )
        & ( v2445(VarCurr,bitIndex2)
        <=> $true )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_631,axiom,
    ! [VarCurr] :
      ( v5193(VarCurr)
    <=> ( v5194(VarCurr)
        | v5197(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_499,axiom,
    ! [VarCurr] :
      ( v5197(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $true )
        & ( v2445(VarCurr,bitIndex2)
        <=> $true )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_630,axiom,
    ! [VarCurr] :
      ( v5194(VarCurr)
    <=> ( v5195(VarCurr)
        | v5196(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_498,axiom,
    ! [VarCurr] :
      ( v5196(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $true )
        & ( v2445(VarCurr,bitIndex2)
        <=> $false )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_497,axiom,
    ! [VarCurr] :
      ( v5195(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $true )
        & ( v2445(VarCurr,bitIndex2)
        <=> $false )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_629,axiom,
    ! [VarCurr] :
      ( v5178(VarCurr)
    <=> ( v5180(VarCurr)
        & v2565(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_628,axiom,
    ! [VarCurr] :
      ( v5180(VarCurr)
    <=> ( v5181(VarCurr)
        | v5186(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_496,axiom,
    ! [VarCurr] :
      ( v5186(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $false )
        & ( v2445(VarCurr,bitIndex2)
        <=> $true )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_627,axiom,
    ! [VarCurr] :
      ( v5181(VarCurr)
    <=> ( v5182(VarCurr)
        | v5185(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_495,axiom,
    ! [VarCurr] :
      ( v5185(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $false )
        & ( v2445(VarCurr,bitIndex2)
        <=> $true )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_626,axiom,
    ! [VarCurr] :
      ( v5182(VarCurr)
    <=> ( v5183(VarCurr)
        | v5184(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_494,axiom,
    ! [VarCurr] :
      ( v5184(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $false )
        & ( v2445(VarCurr,bitIndex2)
        <=> $false )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_493,axiom,
    ! [VarCurr] :
      ( v5183(VarCurr)
    <=> ( ( v2445(VarCurr,bitIndex3)
        <=> $false )
        & ( v2445(VarCurr,bitIndex2)
        <=> $false )
        & ( v2445(VarCurr,bitIndex1)
        <=> $false )
        & ( v2445(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2919,axiom,
    ! [VarCurr] :
      ( v2996(VarCurr)
    <=> v2998(VarCurr) ) ).

fof(addAssignment_2918,axiom,
    ! [VarCurr] :
      ( v2998(VarCurr)
    <=> v3000(VarCurr) ) ).

fof(addAssignment_2917,axiom,
    ! [VarCurr] :
      ( v3000(VarCurr)
    <=> v3002(VarCurr) ) ).

fof(addAssignment_2916,axiom,
    ! [VarCurr] :
      ( v3002(VarCurr)
    <=> v3004(VarCurr) ) ).

fof(addAssignment_2915,axiom,
    ! [VarCurr] :
      ( v3004(VarCurr)
    <=> v3006(VarCurr,bitIndex0) ) ).

fof(addAssignment_2914,axiom,
    ! [VarCurr] :
      ( v3006(VarCurr,bitIndex0)
    <=> v3008(VarCurr,bitIndex0) ) ).

fof(addAssignment_2913,axiom,
    ! [VarCurr] :
      ( v3008(VarCurr,bitIndex0)
    <=> v3010(VarCurr,bitIndex0) ) ).

fof(addAssignment_2912,axiom,
    ! [VarCurr] :
      ( v3010(VarCurr,bitIndex0)
    <=> v3012(VarCurr,bitIndex0) ) ).

fof(addAssignment_2911,axiom,
    ! [VarCurr] :
      ( v3012(VarCurr,bitIndex0)
    <=> v3014(VarCurr,bitIndex0) ) ).

fof(addAssignment_2910,axiom,
    ! [VarCurr] :
      ( v3014(VarCurr,bitIndex0)
    <=> v3016(VarCurr,bitIndex0) ) ).

fof(addAssignment_2909,axiom,
    ! [VarCurr] :
      ( v3016(VarCurr,bitIndex0)
    <=> v3018(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5127(VarNext)
       => ( v3018(VarNext)
        <=> v3018(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_37,axiom,
    ! [VarNext] :
      ( v5127(VarNext)
     => ( v3018(VarNext)
      <=> v5162(VarNext) ) ) ).

fof(addAssignment_2908,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5162(VarNext)
      <=> v5160(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_153,axiom,
    ! [VarCurr] :
      ( ~ v3020(VarCurr)
     => ( v5160(VarCurr)
      <=> v5163(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_154,axiom,
    ! [VarCurr] :
      ( v3020(VarCurr)
     => ( v5160(VarCurr)
      <=> v3043(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_152,axiom,
    ! [VarCurr] :
      ( ~ v5140(VarCurr)
     => ( v5163(VarCurr)
      <=> v5116(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_153,axiom,
    ! [VarCurr] :
      ( v5140(VarCurr)
     => ( v5163(VarCurr)
      <=> v5164(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_136,axiom,
    ! [VarCurr] :
      ( ( ~ v5143(VarCurr)
        & ~ v5145(VarCurr) )
     => ( v5164(VarCurr)
      <=> v5168(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_151,axiom,
    ! [VarCurr] :
      ( v5145(VarCurr)
     => ( v5164(VarCurr)
      <=> v5167(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_152,axiom,
    ! [VarCurr] :
      ( v5143(VarCurr)
     => ( v5164(VarCurr)
      <=> v5165(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_150,axiom,
    ! [VarCurr] :
      ( ~ v5153(VarCurr)
     => ( v5168(VarCurr)
      <=> v5116(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_151,axiom,
    ! [VarCurr] :
      ( v5153(VarCurr)
     => ( v5168(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_149,axiom,
    ! [VarCurr] :
      ( ~ v5147(VarCurr)
     => ( v5167(VarCurr)
      <=> v5116(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_150,axiom,
    ! [VarCurr] :
      ( v5147(VarCurr)
     => ( v5167(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_211,axiom,
    ! [VarCurr] :
      ( ~ v5166(VarCurr)
     => ( v5165(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_213,axiom,
    ! [VarCurr] :
      ( v5166(VarCurr)
     => ( v5165(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_492,axiom,
    ! [VarCurr] :
      ( v5166(VarCurr)
    <=> ( v3052(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_625,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5127(VarNext)
      <=> ( v5128(VarNext)
          & v5137(VarNext) ) ) ) ).

fof(addAssignment_2907,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5137(VarNext)
      <=> v5135(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_624,axiom,
    ! [VarCurr] :
      ( v5135(VarCurr)
    <=> ( v3020(VarCurr)
        | v5138(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_623,axiom,
    ! [VarCurr] :
      ( v5138(VarCurr)
    <=> ( v5139(VarCurr)
        & v5159(VarCurr) ) ) ).

fof(writeUnaryOperator_314,axiom,
    ! [VarCurr] :
      ( ~ v5159(VarCurr)
    <=> v3020(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_622,axiom,
    ! [VarCurr] :
      ( v5139(VarCurr)
    <=> ( v5140(VarCurr)
        | v5157(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_621,axiom,
    ! [VarCurr] :
      ( v5157(VarCurr)
    <=> ( v5008(VarCurr)
        & v5158(VarCurr) ) ) ).

fof(writeUnaryOperator_313,axiom,
    ! [VarCurr] :
      ( ~ v5158(VarCurr)
    <=> v5010(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_620,axiom,
    ! [VarCurr] :
      ( v5140(VarCurr)
    <=> ( v5141(VarCurr)
        & v5010(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_619,axiom,
    ! [VarCurr] :
      ( v5141(VarCurr)
    <=> ( v5142(VarCurr)
        | v5151(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_618,axiom,
    ! [VarCurr] :
      ( v5151(VarCurr)
    <=> ( v5152(VarCurr)
        & v5156(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_491,axiom,
    ! [VarCurr] :
      ( v5156(VarCurr)
    <=> ( ( v5144(VarCurr,bitIndex2)
        <=> $false )
        & ( v5144(VarCurr,bitIndex1)
        <=> $false )
        & ( v5144(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_617,axiom,
    ! [VarCurr] :
      ( v5152(VarCurr)
    <=> ( v5153(VarCurr)
        | v5154(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_616,axiom,
    ! [VarCurr] :
      ( v5154(VarCurr)
    <=> ( v5008(VarCurr)
        & v5155(VarCurr) ) ) ).

fof(writeUnaryOperator_312,axiom,
    ! [VarCurr] :
      ( ~ v5155(VarCurr)
    <=> v5153(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_490,axiom,
    ! [VarCurr] :
      ( v5153(VarCurr)
    <=> ( v3052(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_615,axiom,
    ! [VarCurr] :
      ( v5142(VarCurr)
    <=> ( v5143(VarCurr)
        | v5145(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_614,axiom,
    ! [VarCurr] :
      ( v5145(VarCurr)
    <=> ( v5146(VarCurr)
        & v5150(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_489,axiom,
    ! [VarCurr] :
      ( v5150(VarCurr)
    <=> ( ( v5144(VarCurr,bitIndex2)
        <=> $false )
        & ( v5144(VarCurr,bitIndex1)
        <=> $true )
        & ( v5144(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_613,axiom,
    ! [VarCurr] :
      ( v5146(VarCurr)
    <=> ( v5147(VarCurr)
        | v5148(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_612,axiom,
    ! [VarCurr] :
      ( v5148(VarCurr)
    <=> ( v5008(VarCurr)
        & v5149(VarCurr) ) ) ).

fof(writeUnaryOperator_311,axiom,
    ! [VarCurr] :
      ( ~ v5149(VarCurr)
    <=> v5147(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_488,axiom,
    ! [VarCurr] :
      ( v5147(VarCurr)
    <=> ( v3052(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_487,axiom,
    ! [VarCurr] :
      ( v5143(VarCurr)
    <=> ( ( v5144(VarCurr,bitIndex2)
        <=> $true )
        & ( v5144(VarCurr,bitIndex1)
        <=> $false )
        & ( v5144(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2906,axiom,
    ! [VarCurr] :
      ( v5144(VarCurr,bitIndex0)
    <=> v3049(VarCurr) ) ).

fof(addAssignment_2905,axiom,
    ! [VarCurr] :
      ( v5144(VarCurr,bitIndex1)
    <=> v3047(VarCurr) ) ).

fof(addAssignment_2904,axiom,
    ! [VarCurr] :
      ( v5144(VarCurr,bitIndex2)
    <=> v3045(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_611,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5128(VarNext)
      <=> ( v5129(VarNext)
          & v5118(VarNext) ) ) ) ).

fof(writeUnaryOperator_310,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5129(VarNext)
      <=> v5131(VarNext) ) ) ).

fof(addAssignment_2903,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5131(VarNext)
      <=> v5118(VarCurr) ) ) ).

fof(addAssignment_2902,axiom,
    ! [VarCurr] :
      ( v5118(VarCurr)
    <=> v5120(VarCurr) ) ).

fof(addAssignment_2901,axiom,
    ! [VarCurr] :
      ( v5120(VarCurr)
    <=> v5122(VarCurr) ) ).

fof(addAssignment_2900,axiom,
    ! [VarCurr] :
      ( v5122(VarCurr)
    <=> v5124(VarCurr) ) ).

fof(addAssignment_2899,axiom,
    ! [VarCurr] :
      ( v5124(VarCurr)
    <=> v3681(VarCurr) ) ).

fof(addAssignment_2898,axiom,
    ! [VarCurr] :
      ( v5116(VarCurr)
    <=> $false ) ).

fof(addAssignment_2897,axiom,
    ! [VarCurr] :
      ( v5010(VarCurr)
    <=> v5012(VarCurr) ) ).

fof(addAssignment_2896,axiom,
    ! [VarCurr] :
      ( v5012(VarCurr)
    <=> v5014(VarCurr) ) ).

fof(addAssignment_2895,axiom,
    ! [VarCurr] :
      ( v5014(VarCurr)
    <=> v5016(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_610,axiom,
    ! [VarCurr] :
      ( v5016(VarCurr)
    <=> ( v5018(VarCurr)
        & v5046(VarCurr) ) ) ).

fof(addAssignment_2894,axiom,
    ! [VarCurr] :
      ( v5046(VarCurr)
    <=> v5048(VarCurr) ) ).

fof(addAssignment_2893,axiom,
    ! [VarCurr] :
      ( v5048(VarCurr)
    <=> v5050(VarCurr) ) ).

fof(addAssignment_2892,axiom,
    ! [VarCurr] :
      ( v5050(VarCurr)
    <=> v5052(VarCurr) ) ).

fof(addAssignment_2891,axiom,
    ! [VarCurr] :
      ( v5052(VarCurr)
    <=> v5054(VarCurr) ) ).

fof(addAssignment_2890,axiom,
    ! [VarCurr] :
      ( v5054(VarCurr)
    <=> v5056(VarCurr) ) ).

fof(addAssignment_2889,axiom,
    ! [VarCurr] :
      ( v5056(VarCurr)
    <=> v5058(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_33,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5103(VarNext)
       => ( v5058(VarNext)
        <=> v5058(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_36,axiom,
    ! [VarNext] :
      ( v5103(VarNext)
     => ( v5058(VarNext)
      <=> v5111(VarNext) ) ) ).

fof(addAssignment_2888,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5111(VarNext)
      <=> v5109(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_210,axiom,
    ! [VarCurr] :
      ( ~ v5004(VarCurr)
     => ( v5109(VarCurr)
      <=> v5060(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_212,axiom,
    ! [VarCurr] :
      ( v5004(VarCurr)
     => ( v5109(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_609,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5103(VarNext)
      <=> v5104(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_608,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5104(VarNext)
      <=> ( v5106(VarNext)
          & v3679(VarNext) ) ) ) ).

fof(writeUnaryOperator_309,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5106(VarNext)
      <=> v3692(VarNext) ) ) ).

fof(addAssignmentInitValueVector_38,axiom,
    ( v5058(constB0)
  <=> $false ) ).

fof(addAssignment_2887,axiom,
    ! [VarCurr] :
      ( v5060(VarCurr)
    <=> v5062(VarCurr) ) ).

fof(addAssignment_2886,axiom,
    ! [VarCurr] :
      ( v5062(VarCurr)
    <=> v5064(VarCurr) ) ).

fof(addAssignment_2885,axiom,
    ! [VarCurr] :
      ( v5064(VarCurr)
    <=> v5066(VarCurr) ) ).

fof(addAssignment_2884,axiom,
    ! [VarCurr] :
      ( v5066(VarCurr)
    <=> v5068(VarCurr) ) ).

fof(addAssignment_2883,axiom,
    ! [VarCurr] :
      ( v5068(VarCurr)
    <=> v5070(VarCurr) ) ).

fof(addAssignment_2882,axiom,
    ! [VarCurr] :
      ( v5070(VarCurr)
    <=> v5072(VarCurr) ) ).

fof(addAssignment_2881,axiom,
    ! [VarCurr] :
      ( v5072(VarCurr)
    <=> v5074(VarCurr) ) ).

fof(addAssignment_2880,axiom,
    ! [VarCurr] :
      ( v5074(VarCurr)
    <=> v5076(VarCurr) ) ).

fof(addAssignment_2879,axiom,
    ! [VarCurr] :
      ( v5076(VarCurr)
    <=> v5078(VarCurr) ) ).

fof(addAssignment_2878,axiom,
    ! [VarCurr] :
      ( v5078(VarCurr)
    <=> v5080(VarCurr) ) ).

fof(addAssignment_2877,axiom,
    ! [VarCurr] :
      ( v5080(VarCurr)
    <=> v5082(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_32,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5085(VarNext)
       => ( v5082(VarNext)
        <=> v5082(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_35,axiom,
    ! [VarNext] :
      ( v5085(VarNext)
     => ( v5082(VarNext)
      <=> v5098(VarNext) ) ) ).

fof(addAssignment_2876,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5098(VarNext)
      <=> v5096(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarCurr] :
      ( ~ v3278(VarCurr)
     => ( v5096(VarCurr)
      <=> v3112(VarCurr,bitIndex29) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_149,axiom,
    ! [VarCurr] :
      ( v3278(VarCurr)
     => ( v5096(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_607,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5085(VarNext)
      <=> ( v5086(VarNext)
          & v5093(VarNext) ) ) ) ).

fof(addAssignment_2875,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5093(VarNext)
      <=> v5091(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_606,axiom,
    ! [VarCurr] :
      ( v5091(VarCurr)
    <=> ( v3278(VarCurr)
        | v5094(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_545,axiom,
    ! [VarCurr] :
      ( v5094(VarCurr)
    <=> ( v3103(VarCurr,bitIndex2)
        & v5095(VarCurr) ) ) ).

fof(writeUnaryOperator_308,axiom,
    ! [VarCurr] :
      ( ~ v5095(VarCurr)
    <=> v3278(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_605,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5086(VarNext)
      <=> ( v5088(VarNext)
          & v3202(VarNext) ) ) ) ).

fof(writeUnaryOperator_307,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5088(VarNext)
      <=> v3211(VarNext) ) ) ).

fof(addAssignmentInitValueVector_37,axiom,
    ( v5082(constB0)
  <=> $false ) ).

fof(addAssignment_2874,axiom,
    ! [VarCurr] :
      ( v5018(VarCurr)
    <=> v5020(VarCurr) ) ).

fof(addAssignment_2873,axiom,
    ! [VarCurr] :
      ( v5020(VarCurr)
    <=> v5022(VarCurr) ) ).

fof(addAssignment_2872,axiom,
    ! [VarCurr] :
      ( v5022(VarCurr)
    <=> v5024(VarCurr) ) ).

fof(addAssignment_2871,axiom,
    ! [VarCurr] :
      ( v5024(VarCurr)
    <=> v5026(VarCurr) ) ).

fof(addAssignment_2870,axiom,
    ! [VarCurr] :
      ( v5026(VarCurr)
    <=> v5028(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_31,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5031(VarNext)
       => ( v5028(VarNext)
        <=> v5028(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_34,axiom,
    ! [VarNext] :
      ( v5031(VarNext)
     => ( v5028(VarNext)
      <=> v5039(VarNext) ) ) ).

fof(addAssignment_2869,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5039(VarNext)
      <=> v5037(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_209,axiom,
    ! [VarCurr] :
      ( ~ v5040(VarCurr)
     => ( v5037(VarCurr)
      <=> v5041(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_211,axiom,
    ! [VarCurr] :
      ( v5040(VarCurr)
     => ( v5037(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_604,axiom,
    ! [VarCurr] :
      ( v5041(VarCurr)
    <=> ( v5042(VarCurr)
        & v3846(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_603,axiom,
    ! [VarCurr] :
      ( v5042(VarCurr)
    <=> ( $true
        & v3663(VarCurr) ) ) ).

fof(writeUnaryOperator_306,axiom,
    ! [VarCurr] :
      ( ~ v5040(VarCurr)
    <=> v3072(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5031(VarNext)
      <=> v5032(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_601,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v5032(VarNext)
      <=> ( v5033(VarNext)
          & v3679(VarNext) ) ) ) ).

fof(writeUnaryOperator_305,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v5033(VarNext)
      <=> v3692(VarNext) ) ) ).

fof(addAssignmentInitValueVector_36,axiom,
    ( v5028(constB0)
  <=> $false ) ).

fof(addAssignment_2868,axiom,
    ! [VarCurr] :
      ( v5008(VarCurr)
    <=> $false ) ).

fof(addAssignment_2867,axiom,
    ! [VarCurr] :
      ( v3052(VarCurr)
    <=> v3054(VarCurr,bitIndex0) ) ).

fof(addAssignment_2866,axiom,
    ! [VarCurr] :
      ( v3054(VarCurr,bitIndex0)
    <=> v3056(VarCurr,bitIndex0) ) ).

fof(addAssignment_2865,axiom,
    ! [VarCurr] :
      ( v3056(VarCurr,bitIndex0)
    <=> v3058(VarCurr,bitIndex0) ) ).

fof(addAssignment_2864,axiom,
    ! [VarCurr] :
      ( v3058(VarCurr,bitIndex0)
    <=> v3060(VarCurr,bitIndex0) ) ).

fof(addAssignment_2863,axiom,
    ! [VarCurr] :
      ( v3060(VarCurr,bitIndex0)
    <=> v3062(VarCurr,bitIndex0) ) ).

fof(addAssignment_2862,axiom,
    ! [VarCurr] :
      ( v3062(VarCurr,bitIndex0)
    <=> v3064(VarCurr,bitIndex0) ) ).

fof(addAssignment_2861,axiom,
    ! [VarCurr] :
      ( v3064(VarCurr,bitIndex0)
    <=> v3066(VarCurr,bitIndex0) ) ).

fof(addAssignment_2860,axiom,
    ! [VarCurr] :
      ( v3066(VarCurr,bitIndex0)
    <=> v3068(VarCurr,bitIndex0) ) ).

fof(addAssignment_2859,axiom,
    ! [VarCurr] :
      ( v3068(VarCurr,bitIndex0)
    <=> v3070(VarCurr,bitIndex0) ) ).

fof(addAssignment_2858,axiom,
    ! [VarNext] :
      ( v3070(VarNext,bitIndex0)
    <=> v4994(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4995(VarNext)
       => ! [B] :
            ( range_63_0(B)
           => ( v4994(VarNext,B)
            <=> v3070(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_33,axiom,
    ! [VarNext] :
      ( v4995(VarNext)
     => ! [B] :
          ( range_63_0(B)
         => ( v4994(VarNext,B)
          <=> v5003(VarNext,B) ) ) ) ).

fof(addAssignment_2857,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_63_0(B)
         => ( v5003(VarNext,B)
          <=> v5001(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_208,axiom,
    ! [VarCurr] :
      ( ~ v5004(VarCurr)
     => ! [B] :
          ( range_63_0(B)
         => ( v5001(VarCurr,B)
          <=> v3075(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_210,axiom,
    ! [VarCurr] :
      ( v5004(VarCurr)
     => ! [B] :
          ( range_63_0(B)
         => ( v5001(VarCurr,B)
          <=> $false ) ) ) ).

fof(range_axiom_34,axiom,
    ! [B] :
      ( range_63_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B ) ) ).

fof(bitBlastConstant_7361,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_7360,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_7359,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_7358,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_7357,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_7356,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_7355,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_7354,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_7353,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_7352,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_7351,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_7350,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_7349,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_7348,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_7347,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_7346,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_7345,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_7344,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_7343,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_7342,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_7341,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_7340,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_7339,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_7338,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_7337,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_7336,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_7335,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_7334,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_7333,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_7332,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_7331,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_7330,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_7329,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_7328,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_7327,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_7326,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_7325,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_7324,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_7323,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_7322,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_7321,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_7320,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_7319,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_7318,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_7317,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_7316,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_7315,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_7314,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_7313,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_7312,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_7311,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_7310,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_7309,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_7308,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_7307,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_7306,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_7305,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_7304,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_7303,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_7302,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_7301,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_7300,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_7299,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_7298,axiom,
    ~ b0000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(writeUnaryOperator_304,axiom,
    ! [VarCurr] :
      ( ~ v5004(VarCurr)
    <=> v3072(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_600,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4995(VarNext)
      <=> v4996(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_599,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4996(VarNext)
      <=> ( v4997(VarNext)
          & v3679(VarNext) ) ) ) ).

fof(writeUnaryOperator_303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4997(VarNext)
      <=> v3692(VarNext) ) ) ).

fof(addAssignmentInitValue_37,axiom,
    ~ v3070(constB0,bitIndex1) ).

fof(addAssignmentInitValue_36,axiom,
    ~ v3070(constB0,bitIndex0) ).

fof(bitBlastConstant_7297,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00(bitIndex1) ).

fof(bitBlastConstant_7296,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00(bitIndex0) ).

fof(addAssignment_2856,axiom,
    ! [VarCurr] :
      ( v3075(VarCurr,bitIndex0)
    <=> v3077(VarCurr,bitIndex0) ) ).

fof(addAssignment_2855,axiom,
    ! [VarCurr] :
      ( v3077(VarCurr,bitIndex0)
    <=> v3079(VarCurr,bitIndex0) ) ).

fof(addAssignment_2854,axiom,
    ! [VarCurr] :
      ( v3079(VarCurr,bitIndex0)
    <=> v3081(VarCurr,bitIndex0) ) ).

fof(addAssignment_2853,axiom,
    ! [VarCurr] :
      ( v3081(VarCurr,bitIndex0)
    <=> v3083(VarCurr,bitIndex0) ) ).

fof(addAssignment_2852,axiom,
    ! [VarCurr] :
      ( v3083(VarCurr,bitIndex0)
    <=> v3085(VarCurr,bitIndex0) ) ).

fof(addAssignment_2851,axiom,
    ! [VarCurr] :
      ( v3085(VarCurr,bitIndex0)
    <=> v3087(VarCurr,bitIndex0) ) ).

fof(addAssignment_2850,axiom,
    ! [VarCurr] :
      ( v3087(VarCurr,bitIndex0)
    <=> v3089(VarCurr,bitIndex0) ) ).

fof(addAssignment_2849,axiom,
    ! [VarCurr] :
      ( v3089(VarCurr,bitIndex0)
    <=> v3091(VarCurr,bitIndex0) ) ).

fof(addAssignment_2848,axiom,
    ! [VarCurr] :
      ( v3091(VarCurr,bitIndex0)
    <=> v3093(VarCurr,bitIndex0) ) ).

fof(addAssignment_2847,axiom,
    ! [VarCurr] :
      ( v3093(VarCurr,bitIndex0)
    <=> v3095(VarCurr,bitIndex0) ) ).

fof(addAssignment_2846,axiom,
    ! [VarCurr] :
      ( v3095(VarCurr,bitIndex0)
    <=> v3097(VarCurr,bitIndex0) ) ).

fof(addAssignment_2845,axiom,
    ! [VarNext] :
      ( v3097(VarNext,bitIndex0)
    <=> v4973(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionEqualRanges1_29,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4974(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v4973(VarNext,B)
            <=> v3097(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_32,axiom,
    ! [VarNext] :
      ( v4974(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v4973(VarNext,B)
          <=> v4988(VarNext,B) ) ) ) ).

fof(addAssignment_2844,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v4988(VarNext,B)
          <=> v4986(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_148,axiom,
    ! [VarCurr] :
      ( ~ v4983(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v4986(VarCurr,B)
          <=> v3112(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_148,axiom,
    ! [VarCurr] :
      ( v4983(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v4986(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_598,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4974(VarNext)
      <=> ( v4975(VarNext)
          & v4982(VarNext) ) ) ) ).

fof(addAssignment_2843,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4982(VarNext)
      <=> v4980(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_597,axiom,
    ! [VarCurr] :
      ( v4980(VarCurr)
    <=> ( v4983(VarCurr)
        | v4984(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_596,axiom,
    ! [VarCurr] :
      ( v4984(VarCurr)
    <=> ( v3103(VarCurr,bitIndex0)
        & v4985(VarCurr) ) ) ).

fof(writeUnaryOperator_302,axiom,
    ! [VarCurr] :
      ( ~ v4985(VarCurr)
    <=> v4983(VarCurr) ) ).

fof(writeUnaryOperator_301,axiom,
    ! [VarCurr] :
      ( ~ v4983(VarCurr)
    <=> v3099(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_595,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v4975(VarNext)
      <=> ( v4976(VarNext)
          & v3202(VarNext) ) ) ) ).

fof(writeUnaryOperator_300,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v4976(VarNext)
      <=> v3211(VarNext) ) ) ).

fof(addAssignmentInitValue_35,axiom,
    ~ v3097(constB0,bitIndex1) ).

fof(addAssignmentInitValue_34,axiom,
    ~ v3097(constB0,bitIndex0) ).

fof(bitBlastConstant_7295,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00(bitIndex1) ).

fof(bitBlastConstant_7294,axiom,
    ~ bxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx00(bitIndex0) ).

fof(addAssignment_2842,axiom,
    ! [VarCurr] :
      ( v3103(VarCurr,bitIndex0)
    <=> v3256(VarCurr,bitIndex0) ) ).

fof(addParallelCaseBooleanConditionEqualRanges7,axiom,
    ! [VarCurr] :
      ( ( ~ v4889(VarCurr)
        & ~ v4902(VarCurr)
        & ~ v4903(VarCurr)
        & ~ v4904(VarCurr)
        & ~ v4941(VarCurr)
        & ~ v4967(VarCurr)
        & ~ v4968(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges6,axiom,
    ! [VarCurr] :
      ( v4968(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges5,axiom,
    ! [VarCurr] :
      ( v4967(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_1,axiom,
    ! [VarCurr] :
      ( v4941(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> v4942(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_10,axiom,
    ! [VarCurr] :
      ( v4904(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> v4905(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_135,axiom,
    ! [VarCurr] :
      ( v4903(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_147,axiom,
    ! [VarCurr] :
      ( v4902(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> b010(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_147,axiom,
    ! [VarCurr] :
      ( v4889(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v3108(VarCurr,B)
          <=> v4890(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_486,axiom,
    ! [VarCurr] :
      ( v4969(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $true )
        & ( v3105(VarCurr,bitIndex1)
        <=> $true )
        & ( v3105(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_485,axiom,
    ! [VarCurr] :
      ( v4968(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $true )
        & ( v3105(VarCurr,bitIndex1)
        <=> $true )
        & ( v3105(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_484,axiom,
    ! [VarCurr] :
      ( v4967(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $true )
        & ( v3105(VarCurr,bitIndex1)
        <=> $false )
        & ( v3105(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_9,axiom,
    ! [VarCurr] :
      ( ( ~ v4943(VarCurr)
        & ~ v4944(VarCurr)
        & ~ v4947(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v4942(VarCurr,B)
          <=> v4955(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_134,axiom,
    ! [VarCurr] :
      ( v4947(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4942(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_146,axiom,
    ! [VarCurr] :
      ( v4944(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4942(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_146,axiom,
    ! [VarCurr] :
      ( v4943(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4942(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_145,axiom,
    ! [VarCurr] :
      ( ~ v4956(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4955(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_145,axiom,
    ! [VarCurr] :
      ( v4956(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4955(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_594,axiom,
    ! [VarCurr] :
      ( v4958(VarCurr)
    <=> ( v4960(VarCurr)
        | v4965(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_483,axiom,
    ! [VarCurr] :
      ( v4965(VarCurr)
    <=> ( ( v4966(VarCurr,bitIndex1)
        <=> $true )
        & ( v4966(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2841,axiom,
    ! [VarCurr] :
      ( v4966(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2840,axiom,
    ! [VarCurr] :
      ( v4966(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_593,axiom,
    ! [VarCurr] :
      ( v4960(VarCurr)
    <=> ( v4961(VarCurr)
        | v4963(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_482,axiom,
    ! [VarCurr] :
      ( v4963(VarCurr)
    <=> ( ( v4964(VarCurr,bitIndex1)
        <=> $true )
        & ( v4964(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2839,axiom,
    ! [VarCurr] :
      ( v4964(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2838,axiom,
    ! [VarCurr] :
      ( v4964(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_481,axiom,
    ! [VarCurr] :
      ( v4961(VarCurr)
    <=> ( ( v4962(VarCurr,bitIndex1)
        <=> $false )
        & ( v4962(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2837,axiom,
    ! [VarCurr] :
      ( v4962(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2836,axiom,
    ! [VarCurr] :
      ( v4962(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_480,axiom,
    ! [VarCurr] :
      ( v4956(VarCurr)
    <=> ( ( v4957(VarCurr,bitIndex1)
        <=> $false )
        & ( v4957(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2835,axiom,
    ! [VarCurr] :
      ( v4957(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2834,axiom,
    ! [VarCurr] :
      ( v4957(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_592,axiom,
    ! [VarCurr] :
      ( v4947(VarCurr)
    <=> ( v4949(VarCurr)
        | v4954(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_479,axiom,
    ! [VarCurr] :
      ( v4954(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_591,axiom,
    ! [VarCurr] :
      ( v4949(VarCurr)
    <=> ( v4950(VarCurr)
        | v4953(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_478,axiom,
    ! [VarCurr] :
      ( v4953(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_590,axiom,
    ! [VarCurr] :
      ( v4950(VarCurr)
    <=> ( v4951(VarCurr)
        | v4952(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_477,axiom,
    ! [VarCurr] :
      ( v4952(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_476,axiom,
    ! [VarCurr] :
      ( v4951(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_589,axiom,
    ! [VarCurr] :
      ( v4944(VarCurr)
    <=> ( v4945(VarCurr)
        | v4946(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_475,axiom,
    ! [VarCurr] :
      ( v4946(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_474,axiom,
    ! [VarCurr] :
      ( v4945(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_473,axiom,
    ! [VarCurr] :
      ( v4943(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_472,axiom,
    ! [VarCurr] :
      ( v4941(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $true )
        & ( v3105(VarCurr,bitIndex1)
        <=> $false )
        & ( v3105(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_8,axiom,
    ! [VarCurr] :
      ( ( ~ v4906(VarCurr)
        & ~ v4907(VarCurr)
        & ~ v4910(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v4905(VarCurr,B)
          <=> v4918(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_133,axiom,
    ! [VarCurr] :
      ( v4910(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4905(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_144,axiom,
    ! [VarCurr] :
      ( v4907(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4905(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_144,axiom,
    ! [VarCurr] :
      ( v4906(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4905(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_7,axiom,
    ! [VarCurr] :
      ( ( ~ v4919(VarCurr)
        & ~ v4921(VarCurr)
        & ~ v4930(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v4918(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_132,axiom,
    ! [VarCurr] :
      ( v4930(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4918(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_143,axiom,
    ! [VarCurr] :
      ( v4921(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4918(VarCurr,B)
          <=> b101(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_143,axiom,
    ! [VarCurr] :
      ( v4919(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4918(VarCurr,B)
          <=> b011(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_588,axiom,
    ! [VarCurr] :
      ( v4932(VarCurr)
    <=> ( v4934(VarCurr)
        | v4939(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_471,axiom,
    ! [VarCurr] :
      ( v4939(VarCurr)
    <=> ( ( v4940(VarCurr,bitIndex2)
        <=> $true )
        & ( v4940(VarCurr,bitIndex1)
        <=> $true )
        & ( v4940(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2833,axiom,
    ! [VarCurr] :
      ( v4940(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2832,axiom,
    ! [VarCurr] :
      ( v4940(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2831,axiom,
    ! [VarCurr] :
      ( v4940(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_587,axiom,
    ! [VarCurr] :
      ( v4934(VarCurr)
    <=> ( v4935(VarCurr)
        | v4937(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_470,axiom,
    ! [VarCurr] :
      ( v4937(VarCurr)
    <=> ( ( v4938(VarCurr,bitIndex2)
        <=> $true )
        & ( v4938(VarCurr,bitIndex1)
        <=> $true )
        & ( v4938(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2830,axiom,
    ! [VarCurr] :
      ( v4938(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2829,axiom,
    ! [VarCurr] :
      ( v4938(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2828,axiom,
    ! [VarCurr] :
      ( v4938(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_469,axiom,
    ! [VarCurr] :
      ( v4935(VarCurr)
    <=> ( ( v4936(VarCurr,bitIndex2)
        <=> $true )
        & ( v4936(VarCurr,bitIndex1)
        <=> $false )
        & ( v4936(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2827,axiom,
    ! [VarCurr] :
      ( v4936(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2826,axiom,
    ! [VarCurr] :
      ( v4936(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2825,axiom,
    ! [VarCurr] :
      ( v4936(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_468,axiom,
    ! [VarCurr] :
      ( v4930(VarCurr)
    <=> ( ( v4931(VarCurr,bitIndex2)
        <=> $true )
        & ( v4931(VarCurr,bitIndex1)
        <=> $false )
        & ( v4931(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2824,axiom,
    ! [VarCurr] :
      ( v4931(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2823,axiom,
    ! [VarCurr] :
      ( v4931(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2822,axiom,
    ! [VarCurr] :
      ( v4931(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_586,axiom,
    ! [VarCurr] :
      ( v4921(VarCurr)
    <=> ( v4923(VarCurr)
        | v4928(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_467,axiom,
    ! [VarCurr] :
      ( v4928(VarCurr)
    <=> ( ( v4929(VarCurr,bitIndex2)
        <=> $false )
        & ( v4929(VarCurr,bitIndex1)
        <=> $true )
        & ( v4929(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2821,axiom,
    ! [VarCurr] :
      ( v4929(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2820,axiom,
    ! [VarCurr] :
      ( v4929(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2819,axiom,
    ! [VarCurr] :
      ( v4929(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_585,axiom,
    ! [VarCurr] :
      ( v4923(VarCurr)
    <=> ( v4924(VarCurr)
        | v4926(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_466,axiom,
    ! [VarCurr] :
      ( v4926(VarCurr)
    <=> ( ( v4927(VarCurr,bitIndex2)
        <=> $false )
        & ( v4927(VarCurr,bitIndex1)
        <=> $true )
        & ( v4927(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2818,axiom,
    ! [VarCurr] :
      ( v4927(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2817,axiom,
    ! [VarCurr] :
      ( v4927(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2816,axiom,
    ! [VarCurr] :
      ( v4927(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_465,axiom,
    ! [VarCurr] :
      ( v4924(VarCurr)
    <=> ( ( v4925(VarCurr,bitIndex2)
        <=> $false )
        & ( v4925(VarCurr,bitIndex1)
        <=> $false )
        & ( v4925(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_2815,axiom,
    ! [VarCurr] :
      ( v4925(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2814,axiom,
    ! [VarCurr] :
      ( v4925(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2813,axiom,
    ! [VarCurr] :
      ( v4925(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_464,axiom,
    ! [VarCurr] :
      ( v4919(VarCurr)
    <=> ( ( v4920(VarCurr,bitIndex2)
        <=> $false )
        & ( v4920(VarCurr,bitIndex1)
        <=> $false )
        & ( v4920(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2812,axiom,
    ! [VarCurr] :
      ( v4920(VarCurr,bitIndex0)
    <=> v4824(VarCurr) ) ).

fof(addAssignment_2811,axiom,
    ! [VarCurr] :
      ( v4920(VarCurr,bitIndex1)
    <=> v4705(VarCurr) ) ).

fof(addAssignment_2810,axiom,
    ! [VarCurr] :
      ( v4920(VarCurr,bitIndex2)
    <=> v3121(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_584,axiom,
    ! [VarCurr] :
      ( v4910(VarCurr)
    <=> ( v4912(VarCurr)
        | v4917(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_463,axiom,
    ! [VarCurr] :
      ( v4917(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_583,axiom,
    ! [VarCurr] :
      ( v4912(VarCurr)
    <=> ( v4913(VarCurr)
        | v4916(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_462,axiom,
    ! [VarCurr] :
      ( v4916(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_582,axiom,
    ! [VarCurr] :
      ( v4913(VarCurr)
    <=> ( v4914(VarCurr)
        | v4915(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_461,axiom,
    ! [VarCurr] :
      ( v4915(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_460,axiom,
    ! [VarCurr] :
      ( v4914(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_581,axiom,
    ! [VarCurr] :
      ( v4907(VarCurr)
    <=> ( v4908(VarCurr)
        | v4909(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_459,axiom,
    ! [VarCurr] :
      ( v4909(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_458,axiom,
    ! [VarCurr] :
      ( v4908(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_457,axiom,
    ! [VarCurr] :
      ( v4906(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_456,axiom,
    ! [VarCurr] :
      ( v4904(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $false )
        & ( v3105(VarCurr,bitIndex1)
        <=> $true )
        & ( v3105(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_455,axiom,
    ! [VarCurr] :
      ( v4903(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $false )
        & ( v3105(VarCurr,bitIndex1)
        <=> $true )
        & ( v3105(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_454,axiom,
    ! [VarCurr] :
      ( v4902(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $false )
        & ( v3105(VarCurr,bitIndex1)
        <=> $false )
        & ( v3105(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_131,axiom,
    ! [VarCurr] :
      ( ( ~ v4891(VarCurr)
        & ~ v4894(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v4890(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_142,axiom,
    ! [VarCurr] :
      ( v4894(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4890(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_142,axiom,
    ! [VarCurr] :
      ( v4891(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v4890(VarCurr,B)
          <=> b001(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_580,axiom,
    ! [VarCurr] :
      ( v4894(VarCurr)
    <=> ( v4896(VarCurr)
        | v4901(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_453,axiom,
    ! [VarCurr] :
      ( v4901(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_579,axiom,
    ! [VarCurr] :
      ( v4896(VarCurr)
    <=> ( v4897(VarCurr)
        | v4900(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_452,axiom,
    ! [VarCurr] :
      ( v4900(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_578,axiom,
    ! [VarCurr] :
      ( v4897(VarCurr)
    <=> ( v4898(VarCurr)
        | v4899(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_451,axiom,
    ! [VarCurr] :
      ( v4899(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_450,axiom,
    ! [VarCurr] :
      ( v4898(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $true )
        & ( v3110(VarCurr,bitIndex1)
        <=> $false )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_577,axiom,
    ! [VarCurr] :
      ( v4891(VarCurr)
    <=> ( v4892(VarCurr)
        | v4893(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_449,axiom,
    ! [VarCurr] :
      ( v4893(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_448,axiom,
    ! [VarCurr] :
      ( v4892(VarCurr)
    <=> ( ( v3110(VarCurr,bitIndex2)
        <=> $false )
        & ( v3110(VarCurr,bitIndex1)
        <=> $true )
        & ( v3110(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_447,axiom,
    ! [VarCurr] :
      ( v4889(VarCurr)
    <=> ( ( v3105(VarCurr,bitIndex2)
        <=> $false )
        & ( v3105(VarCurr,bitIndex1)
        <=> $false )
        & ( v3105(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_2809,axiom,
    ! [VarCurr] :
      ( v4824(VarCurr)
    <=> v4826(VarCurr) ) ).

fof(addAssignment_2808,axiom,
    ! [VarCurr] :
      ( v4826(VarCurr)
    <=> v4828(VarCurr) ) ).

fof(addAssignment_2807,axiom,
    ! [VarCurr] :
      ( v4828(VarCurr)
    <=> v4830(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_576,axiom,
    ! [VarCurr] :
      ( v4830(VarCurr)
    <=> ( v4886(VarCurr)
        | v4878(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_575,axiom,
    ! [VarCurr] :
      ( v4886(VarCurr)
    <=> ( v4887(VarCurr)
        | v4870(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_574,axiom,
    ! [VarCurr] :
      ( v4887(VarCurr)
    <=> ( v4832(VarCurr)
        | v4840(VarCurr) ) ) ).

fof(addAssignment_2806,axiom,
    ! [VarCurr] :
      ( v4878(VarCurr)
    <=> v4880(VarCurr) ) ).

fof(addAssignment_2805,axiom,
    ! [VarCurr] :
      ( v4880(VarCurr)
    <=> v4882(VarCurr) ) ).

fof(addAssignment_2804,axiom,
    ! [VarCurr] :
      ( v4882(VarCurr)
    <=> v4884(VarCurr) ) ).

fof(addAssignment_2803,axiom,
    ! [VarCurr] :
      ( v4884(VarCurr)
    <=> $false ) ).

fof(addAssignment_2802,axiom,
    ! [VarCurr] :
      ( v4870(VarCurr)
    <=> v4872(VarCurr) ) ).

fof(addAssignment_2801,axiom,
    ! [VarCurr] :
      ( v4872(VarCurr)
    <=> v4874(VarCurr) ) ).

fof(addAssignment_2800,axiom,
    ! [VarCurr] :
      ( v4874(VarCurr)
    <=> v4876(VarCurr) ) ).

fof(addAssignment_2799,axiom,
    ! [VarCurr] :
      ( v4876(VarCurr)
    <=> $false ) ).

fof(addAssignment_2798,axiom,
    ! [VarCurr] :
      ( v4840(VarCurr)
    <=> v4842(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_573,axiom,
    ! [VarCurr] :
      ( v4842(VarCurr)
    <=> ( v4868(VarCurr)
        | v4860(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_572,axiom,
    ! [VarCurr] :
      ( v4868(VarCurr)
    <=> ( v4844(VarCurr)
        | v4852(VarCurr) ) ) ).

fof(addAssignment_2797,axiom,
    ! [VarCurr] :
      ( v4860(VarCurr)
    <=> v4862(VarCurr) ) ).

fof(addAssignment_2796,axiom,
    ! [VarCurr] :
      ( v4862(VarCurr)
    <=> v4864(VarCurr) ) ).

fof(addAssignment_2795,axiom,
    ! [VarCurr] :
      ( v4864(VarCurr)
    <=> v4866(VarCurr) ) ).

fof(addAssignment_2794,axiom,
    ! [VarCurr] :
      ( v4866(VarCurr)
    <=> $false ) ).

fof(addAssignment_2793,axiom,
    ! [VarCurr] :
      ( v4852(VarCurr)
    <=> v4854(VarCurr) ) ).

fof(addAssignment_2792,axiom,
    ! [VarCurr] :
      ( v4854(VarCurr)
    <=> v4856(VarCurr) ) ).

fof(addAssignment_2791,axiom,
    ! [VarCurr] :
      ( v4856(VarCurr)
    <=> v4858(VarCurr) ) ).

fof(addAssignment_2790,axiom,
    ! [VarCurr] :
      ( v4858(VarCurr)
    <=> $false ) ).

fof(addAssignment_2789,axiom,
    ! [VarCurr] :
      ( v4844(VarCurr)
    <=> v4846(VarCurr) ) ).

fof(addAssignment_2788,axiom,
    ! [VarCurr] :
      ( v4846(VarCurr)
    <=> v4848(VarCurr) ) ).

fof(addAssignment_2787,axiom,
    ! [VarCurr] :
      ( v4848(VarCurr)
    <=> v4850(VarCurr) ) ).

fof(addAssignment_2786,axiom,
    ! [VarCurr] :
      ( v4850(VarCurr)
    <=> $false ) ).

fof(addAssignment_2785,axiom,
    ! [VarCurr] :
      ( v4832(VarCurr)
    <=> v4834(VarCurr) ) ).

fof(addAssignment_2784,axiom,
    ! [VarCurr] :
      ( v4834(VarCurr)
    <=> v4836(VarCurr) ) ).

fof(addAssignment_2783,axiom,
    ! [VarCurr] :
      ( v4836(VarCurr)
    <=> v4838(VarCurr) ) ).

fof(addAssignment_2782,axiom,
    ! [VarCurr] :
      ( v4838(VarCurr)
    <=> $false ) ).

fof(addAssignment_2781,axiom,
    ! [VarCurr] :
      ( v4705(VarCurr)
    <=> v4707(VarCurr) ) ).

fof(addAssignment_2780,axiom,
    ! [VarCurr] :
      ( v4707(VarCurr)
    <=> v4709(VarCurr) ) ).

fof(addAssignment_2779,axiom,
    ! [VarCurr] :
      ( v4709(VarCurr)
    <=> v4711(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_571,axiom,
    ! [VarCurr] :
      ( v4711(VarCurr)
    <=> ( v4821(VarCurr)
        | v4804(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_570,axiom,
    ! [VarCurr] :
      ( v4821(VarCurr)
    <=> ( v4822(VarCurr)
        | v4787(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_569,axiom,
    ! [VarCurr] :
      ( v4822(VarCurr)
    <=> ( v4713(VarCurr)
        | v4730(VarCurr) ) ) ).

fof(addAssignment_2778,axiom,
    ! [VarCurr] :
      ( v4804(VarCurr)
    <=> v4806(VarCurr) ) ).

fof(addAssignment_2777,axiom,
    ! [VarCurr] :
      ( v4806(VarCurr)
    <=> v4808(VarCurr) ) ).

fof(addAssignment_2776,axiom,
    ! [VarCurr] :
      ( v4808(VarCurr)
    <=> v4810(VarCurr) ) ).

fof(addAssignment_2775,axiom,
    ! [VarCurr] :
      ( v4810(VarCurr)
    <=> v4812(VarCurr) ) ).

fof(addAssignment_2774,axiom,
    ! [VarCurr] :
      ( v4812(VarCurr)
    <=> v4814(VarCurr) ) ).

fof(addAssignment_2773,axiom,
    ! [VarCurr] :
      ( v4814(VarCurr)
    <=> v4816(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_568,axiom,
    ! [VarCurr] :
      ( v4816(VarCurr)
    <=> ( v3888(VarCurr)
        & v4818(VarCurr) ) ) ).

fof(addAssignment_2772,axiom,
    ! [VarCurr] :
      ( v4787(VarCurr)
    <=> v4789(VarCurr) ) ).

fof(addAssignment_2771,axiom,
    ! [VarCurr] :
      ( v4789(VarCurr)
    <=> v4791(VarCurr) ) ).

fof(addAssignment_2770,axiom,
    ! [VarCurr] :
      ( v4791(VarCurr)
    <=> v4793(VarCurr) ) ).

fof(addAssignment_2769,axiom,
    ! [VarCurr] :
      ( v4793(VarCurr)
    <=> v4795(VarCurr) ) ).

fof(addAssignment_2768,axiom,
    ! [VarCurr] :
      ( v4795(VarCurr)
    <=> v4797(VarCurr) ) ).

fof(addAssignment_2767,axiom,
    ! [VarCurr] :
      ( v4797(VarCurr)
    <=> v4799(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_567,axiom,
    ! [VarCurr] :
      ( v4799(VarCurr)
    <=> ( v3665(VarCurr)
        & v4801(VarCurr) ) ) ).

fof(addAssignment_2766,axiom,
    ! [VarCurr] :
      ( v4730(VarCurr)
    <=> v4732(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_566,axiom,
    ! [VarCurr] :
      ( v4732(VarCurr)
    <=> ( v4785(VarCurr)
        | v4768(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_565,axiom,
    ! [VarCurr] :
      ( v4785(VarCurr)
    <=> ( v4734(VarCurr)
        | v4751(VarCurr) ) ) ).

fof(addAssignment_2765,axiom,
    ! [VarCurr] :
      ( v4768(VarCurr)
    <=> v4770(VarCurr) ) ).

fof(addAssignment_2764,axiom,
    ! [VarCurr] :
      ( v4770(VarCurr)
    <=> v4772(VarCurr) ) ).

fof(addAssignment_2763,axiom,
    ! [VarCurr] :
      ( v4772(VarCurr)
    <=> v4774(VarCurr) ) ).

fof(addAssignment_2762,axiom,
    ! [VarCurr] :
      ( v4774(VarCurr)
    <=> v4776(VarCurr) ) ).

fof(addAssignment_2761,axiom,
    ! [VarCurr] :
      ( v4776(VarCurr)
    <=> v4778(VarCurr) ) ).

fof(addAssignment_2760,axiom,
    ! [VarCurr] :
      ( v4778(VarCurr)
    <=> v4780(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_564,axiom,
    ! [VarCurr] :
      ( v4780(VarCurr)
    <=> ( v3571(VarCurr)
        & v4782(VarCurr) ) ) ).

fof(addAssignment_2759,axiom,
    ! [VarCurr] :
      ( v4751(VarCurr)
    <=> v4753(VarCurr) ) ).

fof(addAssignment_2758,axiom,
    ! [VarCurr] :
      ( v4753(VarCurr)
    <=> v4755(VarCurr) ) ).

fof(addAssignment_2757,axiom,
    ! [VarCurr] :
      ( v4755(VarCurr)
    <=> v4757(VarCurr) ) ).

fof(addAssignment_2756,axiom,
    ! [VarCurr] :
      ( v4757(VarCurr)
    <=> v4759(VarCurr) ) ).

fof(addAssignment_2755,axiom,
    ! [VarCurr] :
      ( v4759(VarCurr)
    <=> v4761(VarCurr) ) ).

fof(addAssignment_2754,axiom,
    ! [VarCurr] :
      ( v4761(VarCurr)
    <=> v4763(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_563,axiom,
    ! [VarCurr] :
      ( v4763(VarCurr)
    <=> ( v3477(VarCurr)
        & v4765(VarCurr) ) ) ).

fof(addAssignment_2753,axiom,
    ! [VarCurr] :
      ( v4734(VarCurr)
    <=> v4736(VarCurr) ) ).

fof(addAssignment_2752,axiom,
    ! [VarCurr] :
      ( v4736(VarCurr)
    <=> v4738(VarCurr) ) ).

fof(addAssignment_2751,axiom,
    ! [VarCurr] :
      ( v4738(VarCurr)
    <=> v4740(VarCurr) ) ).

fof(addAssignment_2750,axiom,
    ! [VarCurr] :
      ( v4740(VarCurr)
    <=> v4742(VarCurr) ) ).

fof(addAssignment_2749,axiom,
    ! [VarCurr] :
      ( v4742(VarCurr)
    <=> v4744(VarCurr) ) ).

fof(addAssignment_2748,axiom,
    ! [VarCurr] :
      ( v4744(VarCurr)
    <=> v4746(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_562,axiom,
    ! [VarCurr] :
      ( v4746(VarCurr)
    <=> ( v3374(VarCurr)
        & v4748(VarCurr) ) ) ).

fof(addAssignment_2747,axiom,
    ! [VarCurr] :
      ( v4713(VarCurr)
    <=> v4715(VarCurr) ) ).

fof(addAssignment_2746,axiom,
    ! [VarCurr] :
      ( v4715(VarCurr)
    <=> v4717(VarCurr) ) ).

fof(addAssignment_2745,axiom,
    ! [VarCurr] :
      ( v4717(VarCurr)
    <=> v4719(VarCurr) ) ).

fof(addAssignment_2744,axiom,
    ! [VarCurr] :
      ( v4719(VarCurr)
    <=> v4721(VarCurr) ) ).

fof(addAssignment_2743,axiom,
    ! [VarCurr] :
      ( v4721(VarCurr)
    <=> v4723(VarCurr) ) ).

fof(addAssignment_2742,axiom,
    ! [VarCurr] :
      ( v4723(VarCurr)
    <=> v4725(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_561,axiom,
    ! [VarCurr] :
      ( v4725(VarCurr)
    <=> ( v3147(VarCurr)
        & v4727(VarCurr) ) ) ).

fof(addAssignment_2741,axiom,
    ! [VarCurr] :
      ( v3121(VarCurr)
    <=> v3123(VarCurr) ) ).

fof(addAssignment_2740,axiom,
    ! [VarCurr] :
      ( v3123(VarCurr)
    <=> v3125(VarCurr) ) ).

fof(addAssignment_2739,axiom,
    ! [VarCurr] :
      ( v3125(VarCurr)
    <=> v3127(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_560,axiom,
    ! [VarCurr] :
      ( v3127(VarCurr)
    <=> ( v4702(VarCurr)
        | v3870(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_559,axiom,
    ! [VarCurr] :
      ( v4702(VarCurr)
    <=> ( v4703(VarCurr)
        | v3649(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_558,axiom,
    ! [VarCurr] :
      ( v4703(VarCurr)
    <=> ( v3129(VarCurr)
        | v3352(VarCurr) ) ) ).

fof(addAssignment_2738,axiom,
    ! [VarCurr] :
      ( v3870(VarCurr)
    <=> v3872(VarCurr) ) ).

fof(addAssignment_2737,axiom,
    ! [VarCurr] :
      ( v3872(VarCurr)
    <=> v3874(VarCurr) ) ).

fof(addAssignment_2736,axiom,
    ! [VarCurr] :
      ( v3874(VarCurr)
    <=> v3876(VarCurr) ) ).

fof(addAssignment_2735,axiom,
    ! [VarCurr] :
      ( v3876(VarCurr)
    <=> v3878(VarCurr) ) ).

fof(addAssignment_2734,axiom,
    ! [VarCurr] :
      ( v3878(VarCurr)
    <=> v3880(VarCurr) ) ).

fof(addAssignment_2733,axiom,
    ! [VarCurr] :
      ( v3880(VarCurr)
    <=> v3882(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_557,axiom,
    ! [VarCurr] :
      ( v3882(VarCurr)
    <=> ( v3884(VarCurr)
        & v4615(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_556,axiom,
    ! [VarCurr] :
      ( v4615(VarCurr)
    <=> ( v4616(VarCurr)
        | v4607(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_555,axiom,
    ! [VarCurr] :
      ( v4616(VarCurr)
    <=> ( v4617(VarCurr)
        | v4599(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_554,axiom,
    ! [VarCurr] :
      ( v4617(VarCurr)
    <=> ( v4618(VarCurr)
        | v4591(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_553,axiom,
    ! [VarCurr] :
      ( v4618(VarCurr)
    <=> ( v4619(VarCurr)
        | v4583(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_552,axiom,
    ! [VarCurr] :
      ( v4619(VarCurr)
    <=> ( v4620(VarCurr)
        | v4575(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_551,axiom,
    ! [VarCurr] :
      ( v4620(VarCurr)
    <=> ( v4621(VarCurr)
        | v4567(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_550,axiom,
    ! [VarCurr] :
      ( v4621(VarCurr)
    <=> ( v4622(VarCurr)
        | v4559(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_549,axiom,
    ! [VarCurr] :
      ( v4622(VarCurr)
    <=> ( v4623(VarCurr)
        | v4551(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_548,axiom,
    ! [VarCurr] :
      ( v4623(VarCurr)
    <=> ( v4624(VarCurr)
        | v4543(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_547,axiom,
    ! [VarCurr] :
      ( v4624(VarCurr)
    <=> ( v4625(VarCurr)
        | v4535(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_546,axiom,
    ! [VarCurr] :
      ( v4625(VarCurr)
    <=> ( v4626(VarCurr)
        | v4527(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_545,axiom,
    ! [VarCurr] :
      ( v4626(VarCurr)
    <=> ( v4627(VarCurr)
        | v4519(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_544,axiom,
    ! [VarCurr] :
      ( v4627(VarCurr)
    <=> ( v4628(VarCurr)
        | v4511(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_543,axiom,
    ! [VarCurr] :
      ( v4628(VarCurr)
    <=> ( v4629(VarCurr)
        | v4503(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_542,axiom,
    ! [VarCurr] :
      ( v4629(VarCurr)
    <=> ( v4630(VarCurr)
        | v4495(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_541,axiom,
    ! [VarCurr] :
      ( v4630(VarCurr)
    <=> ( v4631(VarCurr)
        | v4487(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_540,axiom,
    ! [VarCurr] :
      ( v4631(VarCurr)
    <=> ( v4632(VarCurr)
        | v4479(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_539,axiom,
    ! [VarCurr] :
      ( v4632(VarCurr)
    <=> ( v4633(VarCurr)
        | v4471(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_538,axiom,
    ! [VarCurr] :
      ( v4633(VarCurr)
    <=> ( v4634(VarCurr)
        | v4463(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_537,axiom,
    ! [VarCurr] :
      ( v4634(VarCurr)
    <=> ( v4635(VarCurr)
        | v4455(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_536,axiom,
    ! [VarCurr] :
      ( v4635(VarCurr)
    <=> ( v4636(VarCurr)
        | v4447(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_535,axiom,
    ! [VarCurr] :
      ( v4636(VarCurr)
    <=> ( v4637(VarCurr)
        | v4439(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_534,axiom,
    ! [VarCurr] :
      ( v4637(VarCurr)
    <=> ( v4638(VarCurr)
        | v4431(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_533,axiom,
    ! [VarCurr] :
      ( v4638(VarCurr)
    <=> ( v4639(VarCurr)
        | v4423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_532,axiom,
    ! [VarCurr] :
      ( v4639(VarCurr)
    <=> ( v4640(VarCurr)
        | v4415(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_531,axiom,
    ! [VarCurr] :
      ( v4640(VarCurr)
    <=> ( v4641(VarCurr)
        | v4407(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_530,axiom,
    ! [VarCurr] :
      ( v4641(VarCurr)
    <=> ( v4642(VarCurr)
        | v4399(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_529,axiom,
    ! [VarCurr] :
      ( v4642(VarCurr)
    <=> ( v4643(VarCurr)
        | v4391(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_528,axiom,
    ! [VarCurr] :
      ( v4643(VarCurr)
    <=> ( v4644(VarCurr)
        | v4383(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_527,axiom,
    ! [VarCurr] :
      ( v4644(VarCurr)
    <=> ( v4645(VarCurr)
        | v4375(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_526,axiom,
    ! [VarCurr] :
      ( v4645(VarCurr)
    <=> ( v4646(VarCurr)
        | v4367(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_525,axiom,
    ! [VarCurr] :
      ( v4646(VarCurr)
    <=> ( v4647(VarCurr)
        | v4359(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_524,axiom,
    ! [VarCurr] :
      ( v4647(VarCurr)
    <=> ( v4648(VarCurr)
        | v4351(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_523,axiom,
    ! [VarCurr] :
      ( v4648(VarCurr)
    <=> ( v4649(VarCurr)
        | v4343(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_522,axiom,
    ! [VarCurr] :
      ( v4649(VarCurr)
    <=> ( v4650(VarCurr)
        | v4335(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_521,axiom,
    ! [VarCurr] :
      ( v4650(VarCurr)
    <=> ( v4651(VarCurr)
        | v4327(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_520,axiom,
    ! [VarCurr] :
      ( v4651(VarCurr)
    <=> ( v4652(VarCurr)
        | v4319(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_519,axiom,
    ! [VarCurr] :
      ( v4652(VarCurr)
    <=> ( v4653(VarCurr)
        | v4311(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_518,axiom,
    ! [VarCurr] :
      ( v4653(VarCurr)
    <=> ( v4654(VarCurr)
        | v4303(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_517,axiom,
    ! [VarCurr] :
      ( v4654(VarCurr)
    <=> ( v4655(VarCurr)
        | v4295(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_516,axiom,
    ! [VarCurr] :
      ( v4655(VarCurr)
    <=> ( v4656(VarCurr)
        | v4287(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_515,axiom,
    ! [VarCurr] :
      ( v4656(VarCurr)
    <=> ( v4657(VarCurr)
        | v4279(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_514,axiom,
    ! [VarCurr] :
      ( v4657(VarCurr)
    <=> ( v4658(VarCurr)
        | v4271(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_513,axiom,
    ! [VarCurr] :
      ( v4658(VarCurr)
    <=> ( v4659(VarCurr)
        | v4263(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_512,axiom,
    ! [VarCurr] :
      ( v4659(VarCurr)
    <=> ( v4660(VarCurr)
        | v4255(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_511,axiom,
    ! [VarCurr] :
      ( v4660(VarCurr)
    <=> ( v4661(VarCurr)
        | v4247(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_510,axiom,
    ! [VarCurr] :
      ( v4661(VarCurr)
    <=> ( v4662(VarCurr)
        | v4239(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_509,axiom,
    ! [VarCurr] :
      ( v4662(VarCurr)
    <=> ( v4663(VarCurr)
        | v4231(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_508,axiom,
    ! [VarCurr] :
      ( v4663(VarCurr)
    <=> ( v4664(VarCurr)
        | v4223(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_507,axiom,
    ! [VarCurr] :
      ( v4664(VarCurr)
    <=> ( v4665(VarCurr)
        | v4215(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_506,axiom,
    ! [VarCurr] :
      ( v4665(VarCurr)
    <=> ( v4666(VarCurr)
        | v4207(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_505,axiom,
    ! [VarCurr] :
      ( v4666(VarCurr)
    <=> ( v4667(VarCurr)
        | v4199(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_504,axiom,
    ! [VarCurr] :
      ( v4667(VarCurr)
    <=> ( v4668(VarCurr)
        | v4191(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_503,axiom,
    ! [VarCurr] :
      ( v4668(VarCurr)
    <=> ( v4669(VarCurr)
        | v4183(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_502,axiom,
    ! [VarCurr] :
      ( v4669(VarCurr)
    <=> ( v4670(VarCurr)
        | v4175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_501,axiom,
    ! [VarCurr] :
      ( v4670(VarCurr)
    <=> ( v4671(VarCurr)
        | v4167(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_500,axiom,
    ! [VarCurr] :
      ( v4671(VarCurr)
    <=> ( v4672(VarCurr)
        | v4159(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_499,axiom,
    ! [VarCurr] :
      ( v4672(VarCurr)
    <=> ( v4673(VarCurr)
        | v4151(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_498,axiom,
    ! [VarCurr] :
      ( v4673(VarCurr)
    <=> ( v4674(VarCurr)
        | v4143(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_497,axiom,
    ! [VarCurr] :
      ( v4674(VarCurr)
    <=> ( v4675(VarCurr)
        | v4135(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_496,axiom,
    ! [VarCurr] :
      ( v4675(VarCurr)
    <=> ( v4676(VarCurr)
        | v4127(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_495,axiom,
    ! [VarCurr] :
      ( v4676(VarCurr)
    <=> ( v4677(VarCurr)
        | v4119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_494,axiom,
    ! [VarCurr] :
      ( v4677(VarCurr)
    <=> ( v4678(VarCurr)
        | v4111(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_493,axiom,
    ! [VarCurr] :
      ( v4678(VarCurr)
    <=> ( v4679(VarCurr)
        | v4103(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_492,axiom,
    ! [VarCurr] :
      ( v4679(VarCurr)
    <=> ( v4680(VarCurr)
        | v4095(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_491,axiom,
    ! [VarCurr] :
      ( v4680(VarCurr)
    <=> ( v4681(VarCurr)
        | v4087(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_490,axiom,
    ! [VarCurr] :
      ( v4681(VarCurr)
    <=> ( v4682(VarCurr)
        | v4079(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_489,axiom,
    ! [VarCurr] :
      ( v4682(VarCurr)
    <=> ( v4683(VarCurr)
        | v4071(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_488,axiom,
    ! [VarCurr] :
      ( v4683(VarCurr)
    <=> ( v4684(VarCurr)
        | v4063(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_487,axiom,
    ! [VarCurr] :
      ( v4684(VarCurr)
    <=> ( v4685(VarCurr)
        | v4055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_486,axiom,
    ! [VarCurr] :
      ( v4685(VarCurr)
    <=> ( v4686(VarCurr)
        | v4047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_485,axiom,
    ! [VarCurr] :
      ( v4686(VarCurr)
    <=> ( v4687(VarCurr)
        | v4039(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_484,axiom,
    ! [VarCurr] :
      ( v4687(VarCurr)
    <=> ( v4688(VarCurr)
        | v4031(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_483,axiom,
    ! [VarCurr] :
      ( v4688(VarCurr)
    <=> ( v4689(VarCurr)
        | v4023(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_482,axiom,
    ! [VarCurr] :
      ( v4689(VarCurr)
    <=> ( v4690(VarCurr)
        | v4015(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_481,axiom,
    ! [VarCurr] :
      ( v4690(VarCurr)
    <=> ( v4691(VarCurr)
        | v4007(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_480,axiom,
    ! [VarCurr] :
      ( v4691(VarCurr)
    <=> ( v4692(VarCurr)
        | v3999(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_479,axiom,
    ! [VarCurr] :
      ( v4692(VarCurr)
    <=> ( v4693(VarCurr)
        | v3991(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_478,axiom,
    ! [VarCurr] :
      ( v4693(VarCurr)
    <=> ( v4694(VarCurr)
        | v3983(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_477,axiom,
    ! [VarCurr] :
      ( v4694(VarCurr)
    <=> ( v4695(VarCurr)
        | v3975(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_476,axiom,
    ! [VarCurr] :
      ( v4695(VarCurr)
    <=> ( v4696(VarCurr)
        | v3967(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_475,axiom,
    ! [VarCurr] :
      ( v4696(VarCurr)
    <=> ( v4697(VarCurr)
        | v3959(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_474,axiom,
    ! [VarCurr] :
      ( v4697(VarCurr)
    <=> ( v4698(VarCurr)
        | v3951(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_473,axiom,
    ! [VarCurr] :
      ( v4698(VarCurr)
    <=> ( v4699(VarCurr)
        | v3943(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_472,axiom,
    ! [VarCurr] :
      ( v4699(VarCurr)
    <=> ( v4700(VarCurr)
        | v3935(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_471,axiom,
    ! [VarCurr] :
      ( v4700(VarCurr)
    <=> ( v3886(VarCurr)
        | v3927(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_207,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4607(VarCurr)
      <=> v4611(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_209,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4607(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_130,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4611(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_141,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4611(VarCurr)
      <=> v4613(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_141,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4611(VarCurr)
      <=> v4612(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_446,axiom,
    ! [VarCurr] :
      ( v4613(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $true )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $true )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7293,axiom,
    ~ b000000011100000001101000011(bitIndex26) ).

fof(bitBlastConstant_7292,axiom,
    ~ b000000011100000001101000011(bitIndex25) ).

fof(bitBlastConstant_7291,axiom,
    ~ b000000011100000001101000011(bitIndex24) ).

fof(bitBlastConstant_7290,axiom,
    ~ b000000011100000001101000011(bitIndex23) ).

fof(bitBlastConstant_7289,axiom,
    ~ b000000011100000001101000011(bitIndex22) ).

fof(bitBlastConstant_7288,axiom,
    ~ b000000011100000001101000011(bitIndex21) ).

fof(bitBlastConstant_7287,axiom,
    ~ b000000011100000001101000011(bitIndex20) ).

fof(bitBlastConstant_7286,axiom,
    b000000011100000001101000011(bitIndex19) ).

fof(bitBlastConstant_7285,axiom,
    b000000011100000001101000011(bitIndex18) ).

fof(bitBlastConstant_7284,axiom,
    b000000011100000001101000011(bitIndex17) ).

fof(bitBlastConstant_7283,axiom,
    ~ b000000011100000001101000011(bitIndex16) ).

fof(bitBlastConstant_7282,axiom,
    ~ b000000011100000001101000011(bitIndex15) ).

fof(bitBlastConstant_7281,axiom,
    ~ b000000011100000001101000011(bitIndex14) ).

fof(bitBlastConstant_7280,axiom,
    ~ b000000011100000001101000011(bitIndex13) ).

fof(bitBlastConstant_7279,axiom,
    ~ b000000011100000001101000011(bitIndex12) ).

fof(bitBlastConstant_7278,axiom,
    ~ b000000011100000001101000011(bitIndex11) ).

fof(bitBlastConstant_7277,axiom,
    ~ b000000011100000001101000011(bitIndex10) ).

fof(bitBlastConstant_7276,axiom,
    b000000011100000001101000011(bitIndex9) ).

fof(bitBlastConstant_7275,axiom,
    b000000011100000001101000011(bitIndex8) ).

fof(bitBlastConstant_7274,axiom,
    ~ b000000011100000001101000011(bitIndex7) ).

fof(bitBlastConstant_7273,axiom,
    b000000011100000001101000011(bitIndex6) ).

fof(bitBlastConstant_7272,axiom,
    ~ b000000011100000001101000011(bitIndex5) ).

fof(bitBlastConstant_7271,axiom,
    ~ b000000011100000001101000011(bitIndex4) ).

fof(bitBlastConstant_7270,axiom,
    ~ b000000011100000001101000011(bitIndex3) ).

fof(bitBlastConstant_7269,axiom,
    ~ b000000011100000001101000011(bitIndex2) ).

fof(bitBlastConstant_7268,axiom,
    b000000011100000001101000011(bitIndex1) ).

fof(bitBlastConstant_7267,axiom,
    b000000011100000001101000011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_445,axiom,
    ! [VarCurr] :
      ( v4612(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $true )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $true )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7266,axiom,
    ~ b000000011000000001101000011(bitIndex26) ).

fof(bitBlastConstant_7265,axiom,
    ~ b000000011000000001101000011(bitIndex25) ).

fof(bitBlastConstant_7264,axiom,
    ~ b000000011000000001101000011(bitIndex24) ).

fof(bitBlastConstant_7263,axiom,
    ~ b000000011000000001101000011(bitIndex23) ).

fof(bitBlastConstant_7262,axiom,
    ~ b000000011000000001101000011(bitIndex22) ).

fof(bitBlastConstant_7261,axiom,
    ~ b000000011000000001101000011(bitIndex21) ).

fof(bitBlastConstant_7260,axiom,
    ~ b000000011000000001101000011(bitIndex20) ).

fof(bitBlastConstant_7259,axiom,
    b000000011000000001101000011(bitIndex19) ).

fof(bitBlastConstant_7258,axiom,
    b000000011000000001101000011(bitIndex18) ).

fof(bitBlastConstant_7257,axiom,
    ~ b000000011000000001101000011(bitIndex17) ).

fof(bitBlastConstant_7256,axiom,
    ~ b000000011000000001101000011(bitIndex16) ).

fof(bitBlastConstant_7255,axiom,
    ~ b000000011000000001101000011(bitIndex15) ).

fof(bitBlastConstant_7254,axiom,
    ~ b000000011000000001101000011(bitIndex14) ).

fof(bitBlastConstant_7253,axiom,
    ~ b000000011000000001101000011(bitIndex13) ).

fof(bitBlastConstant_7252,axiom,
    ~ b000000011000000001101000011(bitIndex12) ).

fof(bitBlastConstant_7251,axiom,
    ~ b000000011000000001101000011(bitIndex11) ).

fof(bitBlastConstant_7250,axiom,
    ~ b000000011000000001101000011(bitIndex10) ).

fof(bitBlastConstant_7249,axiom,
    b000000011000000001101000011(bitIndex9) ).

fof(bitBlastConstant_7248,axiom,
    b000000011000000001101000011(bitIndex8) ).

fof(bitBlastConstant_7247,axiom,
    ~ b000000011000000001101000011(bitIndex7) ).

fof(bitBlastConstant_7246,axiom,
    b000000011000000001101000011(bitIndex6) ).

fof(bitBlastConstant_7245,axiom,
    ~ b000000011000000001101000011(bitIndex5) ).

fof(bitBlastConstant_7244,axiom,
    ~ b000000011000000001101000011(bitIndex4) ).

fof(bitBlastConstant_7243,axiom,
    ~ b000000011000000001101000011(bitIndex3) ).

fof(bitBlastConstant_7242,axiom,
    ~ b000000011000000001101000011(bitIndex2) ).

fof(bitBlastConstant_7241,axiom,
    b000000011000000001101000011(bitIndex1) ).

fof(bitBlastConstant_7240,axiom,
    b000000011000000001101000011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_206,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4599(VarCurr)
      <=> v4603(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_208,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4599(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_129,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4603(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_140,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4603(VarCurr)
      <=> v4605(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_140,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4603(VarCurr)
      <=> v4604(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_444,axiom,
    ! [VarCurr] :
      ( v4605(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $true )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $true )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7239,axiom,
    ~ b000000011100000001101000010(bitIndex26) ).

fof(bitBlastConstant_7238,axiom,
    ~ b000000011100000001101000010(bitIndex25) ).

fof(bitBlastConstant_7237,axiom,
    ~ b000000011100000001101000010(bitIndex24) ).

fof(bitBlastConstant_7236,axiom,
    ~ b000000011100000001101000010(bitIndex23) ).

fof(bitBlastConstant_7235,axiom,
    ~ b000000011100000001101000010(bitIndex22) ).

fof(bitBlastConstant_7234,axiom,
    ~ b000000011100000001101000010(bitIndex21) ).

fof(bitBlastConstant_7233,axiom,
    ~ b000000011100000001101000010(bitIndex20) ).

fof(bitBlastConstant_7232,axiom,
    b000000011100000001101000010(bitIndex19) ).

fof(bitBlastConstant_7231,axiom,
    b000000011100000001101000010(bitIndex18) ).

fof(bitBlastConstant_7230,axiom,
    b000000011100000001101000010(bitIndex17) ).

fof(bitBlastConstant_7229,axiom,
    ~ b000000011100000001101000010(bitIndex16) ).

fof(bitBlastConstant_7228,axiom,
    ~ b000000011100000001101000010(bitIndex15) ).

fof(bitBlastConstant_7227,axiom,
    ~ b000000011100000001101000010(bitIndex14) ).

fof(bitBlastConstant_7226,axiom,
    ~ b000000011100000001101000010(bitIndex13) ).

fof(bitBlastConstant_7225,axiom,
    ~ b000000011100000001101000010(bitIndex12) ).

fof(bitBlastConstant_7224,axiom,
    ~ b000000011100000001101000010(bitIndex11) ).

fof(bitBlastConstant_7223,axiom,
    ~ b000000011100000001101000010(bitIndex10) ).

fof(bitBlastConstant_7222,axiom,
    b000000011100000001101000010(bitIndex9) ).

fof(bitBlastConstant_7221,axiom,
    b000000011100000001101000010(bitIndex8) ).

fof(bitBlastConstant_7220,axiom,
    ~ b000000011100000001101000010(bitIndex7) ).

fof(bitBlastConstant_7219,axiom,
    b000000011100000001101000010(bitIndex6) ).

fof(bitBlastConstant_7218,axiom,
    ~ b000000011100000001101000010(bitIndex5) ).

fof(bitBlastConstant_7217,axiom,
    ~ b000000011100000001101000010(bitIndex4) ).

fof(bitBlastConstant_7216,axiom,
    ~ b000000011100000001101000010(bitIndex3) ).

fof(bitBlastConstant_7215,axiom,
    ~ b000000011100000001101000010(bitIndex2) ).

fof(bitBlastConstant_7214,axiom,
    b000000011100000001101000010(bitIndex1) ).

fof(bitBlastConstant_7213,axiom,
    ~ b000000011100000001101000010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_443,axiom,
    ! [VarCurr] :
      ( v4604(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $true )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $true )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7212,axiom,
    ~ b000000011000000001101000010(bitIndex26) ).

fof(bitBlastConstant_7211,axiom,
    ~ b000000011000000001101000010(bitIndex25) ).

fof(bitBlastConstant_7210,axiom,
    ~ b000000011000000001101000010(bitIndex24) ).

fof(bitBlastConstant_7209,axiom,
    ~ b000000011000000001101000010(bitIndex23) ).

fof(bitBlastConstant_7208,axiom,
    ~ b000000011000000001101000010(bitIndex22) ).

fof(bitBlastConstant_7207,axiom,
    ~ b000000011000000001101000010(bitIndex21) ).

fof(bitBlastConstant_7206,axiom,
    ~ b000000011000000001101000010(bitIndex20) ).

fof(bitBlastConstant_7205,axiom,
    b000000011000000001101000010(bitIndex19) ).

fof(bitBlastConstant_7204,axiom,
    b000000011000000001101000010(bitIndex18) ).

fof(bitBlastConstant_7203,axiom,
    ~ b000000011000000001101000010(bitIndex17) ).

fof(bitBlastConstant_7202,axiom,
    ~ b000000011000000001101000010(bitIndex16) ).

fof(bitBlastConstant_7201,axiom,
    ~ b000000011000000001101000010(bitIndex15) ).

fof(bitBlastConstant_7200,axiom,
    ~ b000000011000000001101000010(bitIndex14) ).

fof(bitBlastConstant_7199,axiom,
    ~ b000000011000000001101000010(bitIndex13) ).

fof(bitBlastConstant_7198,axiom,
    ~ b000000011000000001101000010(bitIndex12) ).

fof(bitBlastConstant_7197,axiom,
    ~ b000000011000000001101000010(bitIndex11) ).

fof(bitBlastConstant_7196,axiom,
    ~ b000000011000000001101000010(bitIndex10) ).

fof(bitBlastConstant_7195,axiom,
    b000000011000000001101000010(bitIndex9) ).

fof(bitBlastConstant_7194,axiom,
    b000000011000000001101000010(bitIndex8) ).

fof(bitBlastConstant_7193,axiom,
    ~ b000000011000000001101000010(bitIndex7) ).

fof(bitBlastConstant_7192,axiom,
    b000000011000000001101000010(bitIndex6) ).

fof(bitBlastConstant_7191,axiom,
    ~ b000000011000000001101000010(bitIndex5) ).

fof(bitBlastConstant_7190,axiom,
    ~ b000000011000000001101000010(bitIndex4) ).

fof(bitBlastConstant_7189,axiom,
    ~ b000000011000000001101000010(bitIndex3) ).

fof(bitBlastConstant_7188,axiom,
    ~ b000000011000000001101000010(bitIndex2) ).

fof(bitBlastConstant_7187,axiom,
    b000000011000000001101000010(bitIndex1) ).

fof(bitBlastConstant_7186,axiom,
    ~ b000000011000000001101000010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_205,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4591(VarCurr)
      <=> v4595(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_207,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4591(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_128,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4595(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_139,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4595(VarCurr)
      <=> v4597(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_139,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4595(VarCurr)
      <=> v4596(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_442,axiom,
    ! [VarCurr] :
      ( v4597(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $true )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $true )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7185,axiom,
    ~ b000000011100000001101000000(bitIndex26) ).

fof(bitBlastConstant_7184,axiom,
    ~ b000000011100000001101000000(bitIndex25) ).

fof(bitBlastConstant_7183,axiom,
    ~ b000000011100000001101000000(bitIndex24) ).

fof(bitBlastConstant_7182,axiom,
    ~ b000000011100000001101000000(bitIndex23) ).

fof(bitBlastConstant_7181,axiom,
    ~ b000000011100000001101000000(bitIndex22) ).

fof(bitBlastConstant_7180,axiom,
    ~ b000000011100000001101000000(bitIndex21) ).

fof(bitBlastConstant_7179,axiom,
    ~ b000000011100000001101000000(bitIndex20) ).

fof(bitBlastConstant_7178,axiom,
    b000000011100000001101000000(bitIndex19) ).

fof(bitBlastConstant_7177,axiom,
    b000000011100000001101000000(bitIndex18) ).

fof(bitBlastConstant_7176,axiom,
    b000000011100000001101000000(bitIndex17) ).

fof(bitBlastConstant_7175,axiom,
    ~ b000000011100000001101000000(bitIndex16) ).

fof(bitBlastConstant_7174,axiom,
    ~ b000000011100000001101000000(bitIndex15) ).

fof(bitBlastConstant_7173,axiom,
    ~ b000000011100000001101000000(bitIndex14) ).

fof(bitBlastConstant_7172,axiom,
    ~ b000000011100000001101000000(bitIndex13) ).

fof(bitBlastConstant_7171,axiom,
    ~ b000000011100000001101000000(bitIndex12) ).

fof(bitBlastConstant_7170,axiom,
    ~ b000000011100000001101000000(bitIndex11) ).

fof(bitBlastConstant_7169,axiom,
    ~ b000000011100000001101000000(bitIndex10) ).

fof(bitBlastConstant_7168,axiom,
    b000000011100000001101000000(bitIndex9) ).

fof(bitBlastConstant_7167,axiom,
    b000000011100000001101000000(bitIndex8) ).

fof(bitBlastConstant_7166,axiom,
    ~ b000000011100000001101000000(bitIndex7) ).

fof(bitBlastConstant_7165,axiom,
    b000000011100000001101000000(bitIndex6) ).

fof(bitBlastConstant_7164,axiom,
    ~ b000000011100000001101000000(bitIndex5) ).

fof(bitBlastConstant_7163,axiom,
    ~ b000000011100000001101000000(bitIndex4) ).

fof(bitBlastConstant_7162,axiom,
    ~ b000000011100000001101000000(bitIndex3) ).

fof(bitBlastConstant_7161,axiom,
    ~ b000000011100000001101000000(bitIndex2) ).

fof(bitBlastConstant_7160,axiom,
    ~ b000000011100000001101000000(bitIndex1) ).

fof(bitBlastConstant_7159,axiom,
    ~ b000000011100000001101000000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_441,axiom,
    ! [VarCurr] :
      ( v4596(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $true )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $true )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7158,axiom,
    ~ b000000011000000001101000000(bitIndex26) ).

fof(bitBlastConstant_7157,axiom,
    ~ b000000011000000001101000000(bitIndex25) ).

fof(bitBlastConstant_7156,axiom,
    ~ b000000011000000001101000000(bitIndex24) ).

fof(bitBlastConstant_7155,axiom,
    ~ b000000011000000001101000000(bitIndex23) ).

fof(bitBlastConstant_7154,axiom,
    ~ b000000011000000001101000000(bitIndex22) ).

fof(bitBlastConstant_7153,axiom,
    ~ b000000011000000001101000000(bitIndex21) ).

fof(bitBlastConstant_7152,axiom,
    ~ b000000011000000001101000000(bitIndex20) ).

fof(bitBlastConstant_7151,axiom,
    b000000011000000001101000000(bitIndex19) ).

fof(bitBlastConstant_7150,axiom,
    b000000011000000001101000000(bitIndex18) ).

fof(bitBlastConstant_7149,axiom,
    ~ b000000011000000001101000000(bitIndex17) ).

fof(bitBlastConstant_7148,axiom,
    ~ b000000011000000001101000000(bitIndex16) ).

fof(bitBlastConstant_7147,axiom,
    ~ b000000011000000001101000000(bitIndex15) ).

fof(bitBlastConstant_7146,axiom,
    ~ b000000011000000001101000000(bitIndex14) ).

fof(bitBlastConstant_7145,axiom,
    ~ b000000011000000001101000000(bitIndex13) ).

fof(bitBlastConstant_7144,axiom,
    ~ b000000011000000001101000000(bitIndex12) ).

fof(bitBlastConstant_7143,axiom,
    ~ b000000011000000001101000000(bitIndex11) ).

fof(bitBlastConstant_7142,axiom,
    ~ b000000011000000001101000000(bitIndex10) ).

fof(bitBlastConstant_7141,axiom,
    b000000011000000001101000000(bitIndex9) ).

fof(bitBlastConstant_7140,axiom,
    b000000011000000001101000000(bitIndex8) ).

fof(bitBlastConstant_7139,axiom,
    ~ b000000011000000001101000000(bitIndex7) ).

fof(bitBlastConstant_7138,axiom,
    b000000011000000001101000000(bitIndex6) ).

fof(bitBlastConstant_7137,axiom,
    ~ b000000011000000001101000000(bitIndex5) ).

fof(bitBlastConstant_7136,axiom,
    ~ b000000011000000001101000000(bitIndex4) ).

fof(bitBlastConstant_7135,axiom,
    ~ b000000011000000001101000000(bitIndex3) ).

fof(bitBlastConstant_7134,axiom,
    ~ b000000011000000001101000000(bitIndex2) ).

fof(bitBlastConstant_7133,axiom,
    ~ b000000011000000001101000000(bitIndex1) ).

fof(bitBlastConstant_7132,axiom,
    ~ b000000011000000001101000000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_204,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4583(VarCurr)
      <=> v4587(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_206,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4583(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_127,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4587(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_138,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4587(VarCurr)
      <=> v4589(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_138,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4587(VarCurr)
      <=> v4588(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_440,axiom,
    ! [VarCurr] :
      ( v4589(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7131,axiom,
    ~ b000000011100000001010111111(bitIndex26) ).

fof(bitBlastConstant_7130,axiom,
    ~ b000000011100000001010111111(bitIndex25) ).

fof(bitBlastConstant_7129,axiom,
    ~ b000000011100000001010111111(bitIndex24) ).

fof(bitBlastConstant_7128,axiom,
    ~ b000000011100000001010111111(bitIndex23) ).

fof(bitBlastConstant_7127,axiom,
    ~ b000000011100000001010111111(bitIndex22) ).

fof(bitBlastConstant_7126,axiom,
    ~ b000000011100000001010111111(bitIndex21) ).

fof(bitBlastConstant_7125,axiom,
    ~ b000000011100000001010111111(bitIndex20) ).

fof(bitBlastConstant_7124,axiom,
    b000000011100000001010111111(bitIndex19) ).

fof(bitBlastConstant_7123,axiom,
    b000000011100000001010111111(bitIndex18) ).

fof(bitBlastConstant_7122,axiom,
    b000000011100000001010111111(bitIndex17) ).

fof(bitBlastConstant_7121,axiom,
    ~ b000000011100000001010111111(bitIndex16) ).

fof(bitBlastConstant_7120,axiom,
    ~ b000000011100000001010111111(bitIndex15) ).

fof(bitBlastConstant_7119,axiom,
    ~ b000000011100000001010111111(bitIndex14) ).

fof(bitBlastConstant_7118,axiom,
    ~ b000000011100000001010111111(bitIndex13) ).

fof(bitBlastConstant_7117,axiom,
    ~ b000000011100000001010111111(bitIndex12) ).

fof(bitBlastConstant_7116,axiom,
    ~ b000000011100000001010111111(bitIndex11) ).

fof(bitBlastConstant_7115,axiom,
    ~ b000000011100000001010111111(bitIndex10) ).

fof(bitBlastConstant_7114,axiom,
    b000000011100000001010111111(bitIndex9) ).

fof(bitBlastConstant_7113,axiom,
    ~ b000000011100000001010111111(bitIndex8) ).

fof(bitBlastConstant_7112,axiom,
    b000000011100000001010111111(bitIndex7) ).

fof(bitBlastConstant_7111,axiom,
    ~ b000000011100000001010111111(bitIndex6) ).

fof(bitBlastConstant_7110,axiom,
    b000000011100000001010111111(bitIndex5) ).

fof(bitBlastConstant_7109,axiom,
    b000000011100000001010111111(bitIndex4) ).

fof(bitBlastConstant_7108,axiom,
    b000000011100000001010111111(bitIndex3) ).

fof(bitBlastConstant_7107,axiom,
    b000000011100000001010111111(bitIndex2) ).

fof(bitBlastConstant_7106,axiom,
    b000000011100000001010111111(bitIndex1) ).

fof(bitBlastConstant_7105,axiom,
    b000000011100000001010111111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_439,axiom,
    ! [VarCurr] :
      ( v4588(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7104,axiom,
    ~ b000000011000000001010111111(bitIndex26) ).

fof(bitBlastConstant_7103,axiom,
    ~ b000000011000000001010111111(bitIndex25) ).

fof(bitBlastConstant_7102,axiom,
    ~ b000000011000000001010111111(bitIndex24) ).

fof(bitBlastConstant_7101,axiom,
    ~ b000000011000000001010111111(bitIndex23) ).

fof(bitBlastConstant_7100,axiom,
    ~ b000000011000000001010111111(bitIndex22) ).

fof(bitBlastConstant_7099,axiom,
    ~ b000000011000000001010111111(bitIndex21) ).

fof(bitBlastConstant_7098,axiom,
    ~ b000000011000000001010111111(bitIndex20) ).

fof(bitBlastConstant_7097,axiom,
    b000000011000000001010111111(bitIndex19) ).

fof(bitBlastConstant_7096,axiom,
    b000000011000000001010111111(bitIndex18) ).

fof(bitBlastConstant_7095,axiom,
    ~ b000000011000000001010111111(bitIndex17) ).

fof(bitBlastConstant_7094,axiom,
    ~ b000000011000000001010111111(bitIndex16) ).

fof(bitBlastConstant_7093,axiom,
    ~ b000000011000000001010111111(bitIndex15) ).

fof(bitBlastConstant_7092,axiom,
    ~ b000000011000000001010111111(bitIndex14) ).

fof(bitBlastConstant_7091,axiom,
    ~ b000000011000000001010111111(bitIndex13) ).

fof(bitBlastConstant_7090,axiom,
    ~ b000000011000000001010111111(bitIndex12) ).

fof(bitBlastConstant_7089,axiom,
    ~ b000000011000000001010111111(bitIndex11) ).

fof(bitBlastConstant_7088,axiom,
    ~ b000000011000000001010111111(bitIndex10) ).

fof(bitBlastConstant_7087,axiom,
    b000000011000000001010111111(bitIndex9) ).

fof(bitBlastConstant_7086,axiom,
    ~ b000000011000000001010111111(bitIndex8) ).

fof(bitBlastConstant_7085,axiom,
    b000000011000000001010111111(bitIndex7) ).

fof(bitBlastConstant_7084,axiom,
    ~ b000000011000000001010111111(bitIndex6) ).

fof(bitBlastConstant_7083,axiom,
    b000000011000000001010111111(bitIndex5) ).

fof(bitBlastConstant_7082,axiom,
    b000000011000000001010111111(bitIndex4) ).

fof(bitBlastConstant_7081,axiom,
    b000000011000000001010111111(bitIndex3) ).

fof(bitBlastConstant_7080,axiom,
    b000000011000000001010111111(bitIndex2) ).

fof(bitBlastConstant_7079,axiom,
    b000000011000000001010111111(bitIndex1) ).

fof(bitBlastConstant_7078,axiom,
    b000000011000000001010111111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_203,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4575(VarCurr)
      <=> v4579(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_205,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4575(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_126,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4579(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_137,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4579(VarCurr)
      <=> v4581(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_137,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4579(VarCurr)
      <=> v4580(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_438,axiom,
    ! [VarCurr] :
      ( v4581(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7077,axiom,
    ~ b000000011100000001010111110(bitIndex26) ).

fof(bitBlastConstant_7076,axiom,
    ~ b000000011100000001010111110(bitIndex25) ).

fof(bitBlastConstant_7075,axiom,
    ~ b000000011100000001010111110(bitIndex24) ).

fof(bitBlastConstant_7074,axiom,
    ~ b000000011100000001010111110(bitIndex23) ).

fof(bitBlastConstant_7073,axiom,
    ~ b000000011100000001010111110(bitIndex22) ).

fof(bitBlastConstant_7072,axiom,
    ~ b000000011100000001010111110(bitIndex21) ).

fof(bitBlastConstant_7071,axiom,
    ~ b000000011100000001010111110(bitIndex20) ).

fof(bitBlastConstant_7070,axiom,
    b000000011100000001010111110(bitIndex19) ).

fof(bitBlastConstant_7069,axiom,
    b000000011100000001010111110(bitIndex18) ).

fof(bitBlastConstant_7068,axiom,
    b000000011100000001010111110(bitIndex17) ).

fof(bitBlastConstant_7067,axiom,
    ~ b000000011100000001010111110(bitIndex16) ).

fof(bitBlastConstant_7066,axiom,
    ~ b000000011100000001010111110(bitIndex15) ).

fof(bitBlastConstant_7065,axiom,
    ~ b000000011100000001010111110(bitIndex14) ).

fof(bitBlastConstant_7064,axiom,
    ~ b000000011100000001010111110(bitIndex13) ).

fof(bitBlastConstant_7063,axiom,
    ~ b000000011100000001010111110(bitIndex12) ).

fof(bitBlastConstant_7062,axiom,
    ~ b000000011100000001010111110(bitIndex11) ).

fof(bitBlastConstant_7061,axiom,
    ~ b000000011100000001010111110(bitIndex10) ).

fof(bitBlastConstant_7060,axiom,
    b000000011100000001010111110(bitIndex9) ).

fof(bitBlastConstant_7059,axiom,
    ~ b000000011100000001010111110(bitIndex8) ).

fof(bitBlastConstant_7058,axiom,
    b000000011100000001010111110(bitIndex7) ).

fof(bitBlastConstant_7057,axiom,
    ~ b000000011100000001010111110(bitIndex6) ).

fof(bitBlastConstant_7056,axiom,
    b000000011100000001010111110(bitIndex5) ).

fof(bitBlastConstant_7055,axiom,
    b000000011100000001010111110(bitIndex4) ).

fof(bitBlastConstant_7054,axiom,
    b000000011100000001010111110(bitIndex3) ).

fof(bitBlastConstant_7053,axiom,
    b000000011100000001010111110(bitIndex2) ).

fof(bitBlastConstant_7052,axiom,
    b000000011100000001010111110(bitIndex1) ).

fof(bitBlastConstant_7051,axiom,
    ~ b000000011100000001010111110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_437,axiom,
    ! [VarCurr] :
      ( v4580(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_7050,axiom,
    ~ b000000011000000001010111110(bitIndex26) ).

fof(bitBlastConstant_7049,axiom,
    ~ b000000011000000001010111110(bitIndex25) ).

fof(bitBlastConstant_7048,axiom,
    ~ b000000011000000001010111110(bitIndex24) ).

fof(bitBlastConstant_7047,axiom,
    ~ b000000011000000001010111110(bitIndex23) ).

fof(bitBlastConstant_7046,axiom,
    ~ b000000011000000001010111110(bitIndex22) ).

fof(bitBlastConstant_7045,axiom,
    ~ b000000011000000001010111110(bitIndex21) ).

fof(bitBlastConstant_7044,axiom,
    ~ b000000011000000001010111110(bitIndex20) ).

fof(bitBlastConstant_7043,axiom,
    b000000011000000001010111110(bitIndex19) ).

fof(bitBlastConstant_7042,axiom,
    b000000011000000001010111110(bitIndex18) ).

fof(bitBlastConstant_7041,axiom,
    ~ b000000011000000001010111110(bitIndex17) ).

fof(bitBlastConstant_7040,axiom,
    ~ b000000011000000001010111110(bitIndex16) ).

fof(bitBlastConstant_7039,axiom,
    ~ b000000011000000001010111110(bitIndex15) ).

fof(bitBlastConstant_7038,axiom,
    ~ b000000011000000001010111110(bitIndex14) ).

fof(bitBlastConstant_7037,axiom,
    ~ b000000011000000001010111110(bitIndex13) ).

fof(bitBlastConstant_7036,axiom,
    ~ b000000011000000001010111110(bitIndex12) ).

fof(bitBlastConstant_7035,axiom,
    ~ b000000011000000001010111110(bitIndex11) ).

fof(bitBlastConstant_7034,axiom,
    ~ b000000011000000001010111110(bitIndex10) ).

fof(bitBlastConstant_7033,axiom,
    b000000011000000001010111110(bitIndex9) ).

fof(bitBlastConstant_7032,axiom,
    ~ b000000011000000001010111110(bitIndex8) ).

fof(bitBlastConstant_7031,axiom,
    b000000011000000001010111110(bitIndex7) ).

fof(bitBlastConstant_7030,axiom,
    ~ b000000011000000001010111110(bitIndex6) ).

fof(bitBlastConstant_7029,axiom,
    b000000011000000001010111110(bitIndex5) ).

fof(bitBlastConstant_7028,axiom,
    b000000011000000001010111110(bitIndex4) ).

fof(bitBlastConstant_7027,axiom,
    b000000011000000001010111110(bitIndex3) ).

fof(bitBlastConstant_7026,axiom,
    b000000011000000001010111110(bitIndex2) ).

fof(bitBlastConstant_7025,axiom,
    b000000011000000001010111110(bitIndex1) ).

fof(bitBlastConstant_7024,axiom,
    ~ b000000011000000001010111110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_202,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4567(VarCurr)
      <=> v4571(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_204,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4567(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_125,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4571(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_136,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4571(VarCurr)
      <=> v4573(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_136,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4571(VarCurr)
      <=> v4572(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_436,axiom,
    ! [VarCurr] :
      ( v4573(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_7023,axiom,
    ~ b000000011100000001010111011(bitIndex26) ).

fof(bitBlastConstant_7022,axiom,
    ~ b000000011100000001010111011(bitIndex25) ).

fof(bitBlastConstant_7021,axiom,
    ~ b000000011100000001010111011(bitIndex24) ).

fof(bitBlastConstant_7020,axiom,
    ~ b000000011100000001010111011(bitIndex23) ).

fof(bitBlastConstant_7019,axiom,
    ~ b000000011100000001010111011(bitIndex22) ).

fof(bitBlastConstant_7018,axiom,
    ~ b000000011100000001010111011(bitIndex21) ).

fof(bitBlastConstant_7017,axiom,
    ~ b000000011100000001010111011(bitIndex20) ).

fof(bitBlastConstant_7016,axiom,
    b000000011100000001010111011(bitIndex19) ).

fof(bitBlastConstant_7015,axiom,
    b000000011100000001010111011(bitIndex18) ).

fof(bitBlastConstant_7014,axiom,
    b000000011100000001010111011(bitIndex17) ).

fof(bitBlastConstant_7013,axiom,
    ~ b000000011100000001010111011(bitIndex16) ).

fof(bitBlastConstant_7012,axiom,
    ~ b000000011100000001010111011(bitIndex15) ).

fof(bitBlastConstant_7011,axiom,
    ~ b000000011100000001010111011(bitIndex14) ).

fof(bitBlastConstant_7010,axiom,
    ~ b000000011100000001010111011(bitIndex13) ).

fof(bitBlastConstant_7009,axiom,
    ~ b000000011100000001010111011(bitIndex12) ).

fof(bitBlastConstant_7008,axiom,
    ~ b000000011100000001010111011(bitIndex11) ).

fof(bitBlastConstant_7007,axiom,
    ~ b000000011100000001010111011(bitIndex10) ).

fof(bitBlastConstant_7006,axiom,
    b000000011100000001010111011(bitIndex9) ).

fof(bitBlastConstant_7005,axiom,
    ~ b000000011100000001010111011(bitIndex8) ).

fof(bitBlastConstant_7004,axiom,
    b000000011100000001010111011(bitIndex7) ).

fof(bitBlastConstant_7003,axiom,
    ~ b000000011100000001010111011(bitIndex6) ).

fof(bitBlastConstant_7002,axiom,
    b000000011100000001010111011(bitIndex5) ).

fof(bitBlastConstant_7001,axiom,
    b000000011100000001010111011(bitIndex4) ).

fof(bitBlastConstant_7000,axiom,
    b000000011100000001010111011(bitIndex3) ).

fof(bitBlastConstant_6999,axiom,
    ~ b000000011100000001010111011(bitIndex2) ).

fof(bitBlastConstant_6998,axiom,
    b000000011100000001010111011(bitIndex1) ).

fof(bitBlastConstant_6997,axiom,
    b000000011100000001010111011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_435,axiom,
    ! [VarCurr] :
      ( v4572(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6996,axiom,
    ~ b000000011000000001010111011(bitIndex26) ).

fof(bitBlastConstant_6995,axiom,
    ~ b000000011000000001010111011(bitIndex25) ).

fof(bitBlastConstant_6994,axiom,
    ~ b000000011000000001010111011(bitIndex24) ).

fof(bitBlastConstant_6993,axiom,
    ~ b000000011000000001010111011(bitIndex23) ).

fof(bitBlastConstant_6992,axiom,
    ~ b000000011000000001010111011(bitIndex22) ).

fof(bitBlastConstant_6991,axiom,
    ~ b000000011000000001010111011(bitIndex21) ).

fof(bitBlastConstant_6990,axiom,
    ~ b000000011000000001010111011(bitIndex20) ).

fof(bitBlastConstant_6989,axiom,
    b000000011000000001010111011(bitIndex19) ).

fof(bitBlastConstant_6988,axiom,
    b000000011000000001010111011(bitIndex18) ).

fof(bitBlastConstant_6987,axiom,
    ~ b000000011000000001010111011(bitIndex17) ).

fof(bitBlastConstant_6986,axiom,
    ~ b000000011000000001010111011(bitIndex16) ).

fof(bitBlastConstant_6985,axiom,
    ~ b000000011000000001010111011(bitIndex15) ).

fof(bitBlastConstant_6984,axiom,
    ~ b000000011000000001010111011(bitIndex14) ).

fof(bitBlastConstant_6983,axiom,
    ~ b000000011000000001010111011(bitIndex13) ).

fof(bitBlastConstant_6982,axiom,
    ~ b000000011000000001010111011(bitIndex12) ).

fof(bitBlastConstant_6981,axiom,
    ~ b000000011000000001010111011(bitIndex11) ).

fof(bitBlastConstant_6980,axiom,
    ~ b000000011000000001010111011(bitIndex10) ).

fof(bitBlastConstant_6979,axiom,
    b000000011000000001010111011(bitIndex9) ).

fof(bitBlastConstant_6978,axiom,
    ~ b000000011000000001010111011(bitIndex8) ).

fof(bitBlastConstant_6977,axiom,
    b000000011000000001010111011(bitIndex7) ).

fof(bitBlastConstant_6976,axiom,
    ~ b000000011000000001010111011(bitIndex6) ).

fof(bitBlastConstant_6975,axiom,
    b000000011000000001010111011(bitIndex5) ).

fof(bitBlastConstant_6974,axiom,
    b000000011000000001010111011(bitIndex4) ).

fof(bitBlastConstant_6973,axiom,
    b000000011000000001010111011(bitIndex3) ).

fof(bitBlastConstant_6972,axiom,
    ~ b000000011000000001010111011(bitIndex2) ).

fof(bitBlastConstant_6971,axiom,
    b000000011000000001010111011(bitIndex1) ).

fof(bitBlastConstant_6970,axiom,
    b000000011000000001010111011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_201,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4559(VarCurr)
      <=> v4563(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_203,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4559(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_124,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4563(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_135,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4563(VarCurr)
      <=> v4565(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_135,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4563(VarCurr)
      <=> v4564(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_434,axiom,
    ! [VarCurr] :
      ( v4565(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6969,axiom,
    ~ b000000011100000001010111010(bitIndex26) ).

fof(bitBlastConstant_6968,axiom,
    ~ b000000011100000001010111010(bitIndex25) ).

fof(bitBlastConstant_6967,axiom,
    ~ b000000011100000001010111010(bitIndex24) ).

fof(bitBlastConstant_6966,axiom,
    ~ b000000011100000001010111010(bitIndex23) ).

fof(bitBlastConstant_6965,axiom,
    ~ b000000011100000001010111010(bitIndex22) ).

fof(bitBlastConstant_6964,axiom,
    ~ b000000011100000001010111010(bitIndex21) ).

fof(bitBlastConstant_6963,axiom,
    ~ b000000011100000001010111010(bitIndex20) ).

fof(bitBlastConstant_6962,axiom,
    b000000011100000001010111010(bitIndex19) ).

fof(bitBlastConstant_6961,axiom,
    b000000011100000001010111010(bitIndex18) ).

fof(bitBlastConstant_6960,axiom,
    b000000011100000001010111010(bitIndex17) ).

fof(bitBlastConstant_6959,axiom,
    ~ b000000011100000001010111010(bitIndex16) ).

fof(bitBlastConstant_6958,axiom,
    ~ b000000011100000001010111010(bitIndex15) ).

fof(bitBlastConstant_6957,axiom,
    ~ b000000011100000001010111010(bitIndex14) ).

fof(bitBlastConstant_6956,axiom,
    ~ b000000011100000001010111010(bitIndex13) ).

fof(bitBlastConstant_6955,axiom,
    ~ b000000011100000001010111010(bitIndex12) ).

fof(bitBlastConstant_6954,axiom,
    ~ b000000011100000001010111010(bitIndex11) ).

fof(bitBlastConstant_6953,axiom,
    ~ b000000011100000001010111010(bitIndex10) ).

fof(bitBlastConstant_6952,axiom,
    b000000011100000001010111010(bitIndex9) ).

fof(bitBlastConstant_6951,axiom,
    ~ b000000011100000001010111010(bitIndex8) ).

fof(bitBlastConstant_6950,axiom,
    b000000011100000001010111010(bitIndex7) ).

fof(bitBlastConstant_6949,axiom,
    ~ b000000011100000001010111010(bitIndex6) ).

fof(bitBlastConstant_6948,axiom,
    b000000011100000001010111010(bitIndex5) ).

fof(bitBlastConstant_6947,axiom,
    b000000011100000001010111010(bitIndex4) ).

fof(bitBlastConstant_6946,axiom,
    b000000011100000001010111010(bitIndex3) ).

fof(bitBlastConstant_6945,axiom,
    ~ b000000011100000001010111010(bitIndex2) ).

fof(bitBlastConstant_6944,axiom,
    b000000011100000001010111010(bitIndex1) ).

fof(bitBlastConstant_6943,axiom,
    ~ b000000011100000001010111010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_433,axiom,
    ! [VarCurr] :
      ( v4564(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6942,axiom,
    ~ b000000011000000001010111010(bitIndex26) ).

fof(bitBlastConstant_6941,axiom,
    ~ b000000011000000001010111010(bitIndex25) ).

fof(bitBlastConstant_6940,axiom,
    ~ b000000011000000001010111010(bitIndex24) ).

fof(bitBlastConstant_6939,axiom,
    ~ b000000011000000001010111010(bitIndex23) ).

fof(bitBlastConstant_6938,axiom,
    ~ b000000011000000001010111010(bitIndex22) ).

fof(bitBlastConstant_6937,axiom,
    ~ b000000011000000001010111010(bitIndex21) ).

fof(bitBlastConstant_6936,axiom,
    ~ b000000011000000001010111010(bitIndex20) ).

fof(bitBlastConstant_6935,axiom,
    b000000011000000001010111010(bitIndex19) ).

fof(bitBlastConstant_6934,axiom,
    b000000011000000001010111010(bitIndex18) ).

fof(bitBlastConstant_6933,axiom,
    ~ b000000011000000001010111010(bitIndex17) ).

fof(bitBlastConstant_6932,axiom,
    ~ b000000011000000001010111010(bitIndex16) ).

fof(bitBlastConstant_6931,axiom,
    ~ b000000011000000001010111010(bitIndex15) ).

fof(bitBlastConstant_6930,axiom,
    ~ b000000011000000001010111010(bitIndex14) ).

fof(bitBlastConstant_6929,axiom,
    ~ b000000011000000001010111010(bitIndex13) ).

fof(bitBlastConstant_6928,axiom,
    ~ b000000011000000001010111010(bitIndex12) ).

fof(bitBlastConstant_6927,axiom,
    ~ b000000011000000001010111010(bitIndex11) ).

fof(bitBlastConstant_6926,axiom,
    ~ b000000011000000001010111010(bitIndex10) ).

fof(bitBlastConstant_6925,axiom,
    b000000011000000001010111010(bitIndex9) ).

fof(bitBlastConstant_6924,axiom,
    ~ b000000011000000001010111010(bitIndex8) ).

fof(bitBlastConstant_6923,axiom,
    b000000011000000001010111010(bitIndex7) ).

fof(bitBlastConstant_6922,axiom,
    ~ b000000011000000001010111010(bitIndex6) ).

fof(bitBlastConstant_6921,axiom,
    b000000011000000001010111010(bitIndex5) ).

fof(bitBlastConstant_6920,axiom,
    b000000011000000001010111010(bitIndex4) ).

fof(bitBlastConstant_6919,axiom,
    b000000011000000001010111010(bitIndex3) ).

fof(bitBlastConstant_6918,axiom,
    ~ b000000011000000001010111010(bitIndex2) ).

fof(bitBlastConstant_6917,axiom,
    b000000011000000001010111010(bitIndex1) ).

fof(bitBlastConstant_6916,axiom,
    ~ b000000011000000001010111010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_200,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4551(VarCurr)
      <=> v4555(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_202,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4551(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_123,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4555(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_134,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4555(VarCurr)
      <=> v4557(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_134,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4555(VarCurr)
      <=> v4556(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_432,axiom,
    ! [VarCurr] :
      ( v4557(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6915,axiom,
    ~ b000000011100000001010111001(bitIndex26) ).

fof(bitBlastConstant_6914,axiom,
    ~ b000000011100000001010111001(bitIndex25) ).

fof(bitBlastConstant_6913,axiom,
    ~ b000000011100000001010111001(bitIndex24) ).

fof(bitBlastConstant_6912,axiom,
    ~ b000000011100000001010111001(bitIndex23) ).

fof(bitBlastConstant_6911,axiom,
    ~ b000000011100000001010111001(bitIndex22) ).

fof(bitBlastConstant_6910,axiom,
    ~ b000000011100000001010111001(bitIndex21) ).

fof(bitBlastConstant_6909,axiom,
    ~ b000000011100000001010111001(bitIndex20) ).

fof(bitBlastConstant_6908,axiom,
    b000000011100000001010111001(bitIndex19) ).

fof(bitBlastConstant_6907,axiom,
    b000000011100000001010111001(bitIndex18) ).

fof(bitBlastConstant_6906,axiom,
    b000000011100000001010111001(bitIndex17) ).

fof(bitBlastConstant_6905,axiom,
    ~ b000000011100000001010111001(bitIndex16) ).

fof(bitBlastConstant_6904,axiom,
    ~ b000000011100000001010111001(bitIndex15) ).

fof(bitBlastConstant_6903,axiom,
    ~ b000000011100000001010111001(bitIndex14) ).

fof(bitBlastConstant_6902,axiom,
    ~ b000000011100000001010111001(bitIndex13) ).

fof(bitBlastConstant_6901,axiom,
    ~ b000000011100000001010111001(bitIndex12) ).

fof(bitBlastConstant_6900,axiom,
    ~ b000000011100000001010111001(bitIndex11) ).

fof(bitBlastConstant_6899,axiom,
    ~ b000000011100000001010111001(bitIndex10) ).

fof(bitBlastConstant_6898,axiom,
    b000000011100000001010111001(bitIndex9) ).

fof(bitBlastConstant_6897,axiom,
    ~ b000000011100000001010111001(bitIndex8) ).

fof(bitBlastConstant_6896,axiom,
    b000000011100000001010111001(bitIndex7) ).

fof(bitBlastConstant_6895,axiom,
    ~ b000000011100000001010111001(bitIndex6) ).

fof(bitBlastConstant_6894,axiom,
    b000000011100000001010111001(bitIndex5) ).

fof(bitBlastConstant_6893,axiom,
    b000000011100000001010111001(bitIndex4) ).

fof(bitBlastConstant_6892,axiom,
    b000000011100000001010111001(bitIndex3) ).

fof(bitBlastConstant_6891,axiom,
    ~ b000000011100000001010111001(bitIndex2) ).

fof(bitBlastConstant_6890,axiom,
    ~ b000000011100000001010111001(bitIndex1) ).

fof(bitBlastConstant_6889,axiom,
    b000000011100000001010111001(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_431,axiom,
    ! [VarCurr] :
      ( v4556(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6888,axiom,
    ~ b000000011000000001010111001(bitIndex26) ).

fof(bitBlastConstant_6887,axiom,
    ~ b000000011000000001010111001(bitIndex25) ).

fof(bitBlastConstant_6886,axiom,
    ~ b000000011000000001010111001(bitIndex24) ).

fof(bitBlastConstant_6885,axiom,
    ~ b000000011000000001010111001(bitIndex23) ).

fof(bitBlastConstant_6884,axiom,
    ~ b000000011000000001010111001(bitIndex22) ).

fof(bitBlastConstant_6883,axiom,
    ~ b000000011000000001010111001(bitIndex21) ).

fof(bitBlastConstant_6882,axiom,
    ~ b000000011000000001010111001(bitIndex20) ).

fof(bitBlastConstant_6881,axiom,
    b000000011000000001010111001(bitIndex19) ).

fof(bitBlastConstant_6880,axiom,
    b000000011000000001010111001(bitIndex18) ).

fof(bitBlastConstant_6879,axiom,
    ~ b000000011000000001010111001(bitIndex17) ).

fof(bitBlastConstant_6878,axiom,
    ~ b000000011000000001010111001(bitIndex16) ).

fof(bitBlastConstant_6877,axiom,
    ~ b000000011000000001010111001(bitIndex15) ).

fof(bitBlastConstant_6876,axiom,
    ~ b000000011000000001010111001(bitIndex14) ).

fof(bitBlastConstant_6875,axiom,
    ~ b000000011000000001010111001(bitIndex13) ).

fof(bitBlastConstant_6874,axiom,
    ~ b000000011000000001010111001(bitIndex12) ).

fof(bitBlastConstant_6873,axiom,
    ~ b000000011000000001010111001(bitIndex11) ).

fof(bitBlastConstant_6872,axiom,
    ~ b000000011000000001010111001(bitIndex10) ).

fof(bitBlastConstant_6871,axiom,
    b000000011000000001010111001(bitIndex9) ).

fof(bitBlastConstant_6870,axiom,
    ~ b000000011000000001010111001(bitIndex8) ).

fof(bitBlastConstant_6869,axiom,
    b000000011000000001010111001(bitIndex7) ).

fof(bitBlastConstant_6868,axiom,
    ~ b000000011000000001010111001(bitIndex6) ).

fof(bitBlastConstant_6867,axiom,
    b000000011000000001010111001(bitIndex5) ).

fof(bitBlastConstant_6866,axiom,
    b000000011000000001010111001(bitIndex4) ).

fof(bitBlastConstant_6865,axiom,
    b000000011000000001010111001(bitIndex3) ).

fof(bitBlastConstant_6864,axiom,
    ~ b000000011000000001010111001(bitIndex2) ).

fof(bitBlastConstant_6863,axiom,
    ~ b000000011000000001010111001(bitIndex1) ).

fof(bitBlastConstant_6862,axiom,
    b000000011000000001010111001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_199,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4543(VarCurr)
      <=> v4547(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_201,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4543(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_122,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4547(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_133,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4547(VarCurr)
      <=> v4549(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_133,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4547(VarCurr)
      <=> v4548(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_430,axiom,
    ! [VarCurr] :
      ( v4549(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6861,axiom,
    ~ b000000011100000001010111000(bitIndex26) ).

fof(bitBlastConstant_6860,axiom,
    ~ b000000011100000001010111000(bitIndex25) ).

fof(bitBlastConstant_6859,axiom,
    ~ b000000011100000001010111000(bitIndex24) ).

fof(bitBlastConstant_6858,axiom,
    ~ b000000011100000001010111000(bitIndex23) ).

fof(bitBlastConstant_6857,axiom,
    ~ b000000011100000001010111000(bitIndex22) ).

fof(bitBlastConstant_6856,axiom,
    ~ b000000011100000001010111000(bitIndex21) ).

fof(bitBlastConstant_6855,axiom,
    ~ b000000011100000001010111000(bitIndex20) ).

fof(bitBlastConstant_6854,axiom,
    b000000011100000001010111000(bitIndex19) ).

fof(bitBlastConstant_6853,axiom,
    b000000011100000001010111000(bitIndex18) ).

fof(bitBlastConstant_6852,axiom,
    b000000011100000001010111000(bitIndex17) ).

fof(bitBlastConstant_6851,axiom,
    ~ b000000011100000001010111000(bitIndex16) ).

fof(bitBlastConstant_6850,axiom,
    ~ b000000011100000001010111000(bitIndex15) ).

fof(bitBlastConstant_6849,axiom,
    ~ b000000011100000001010111000(bitIndex14) ).

fof(bitBlastConstant_6848,axiom,
    ~ b000000011100000001010111000(bitIndex13) ).

fof(bitBlastConstant_6847,axiom,
    ~ b000000011100000001010111000(bitIndex12) ).

fof(bitBlastConstant_6846,axiom,
    ~ b000000011100000001010111000(bitIndex11) ).

fof(bitBlastConstant_6845,axiom,
    ~ b000000011100000001010111000(bitIndex10) ).

fof(bitBlastConstant_6844,axiom,
    b000000011100000001010111000(bitIndex9) ).

fof(bitBlastConstant_6843,axiom,
    ~ b000000011100000001010111000(bitIndex8) ).

fof(bitBlastConstant_6842,axiom,
    b000000011100000001010111000(bitIndex7) ).

fof(bitBlastConstant_6841,axiom,
    ~ b000000011100000001010111000(bitIndex6) ).

fof(bitBlastConstant_6840,axiom,
    b000000011100000001010111000(bitIndex5) ).

fof(bitBlastConstant_6839,axiom,
    b000000011100000001010111000(bitIndex4) ).

fof(bitBlastConstant_6838,axiom,
    b000000011100000001010111000(bitIndex3) ).

fof(bitBlastConstant_6837,axiom,
    ~ b000000011100000001010111000(bitIndex2) ).

fof(bitBlastConstant_6836,axiom,
    ~ b000000011100000001010111000(bitIndex1) ).

fof(bitBlastConstant_6835,axiom,
    ~ b000000011100000001010111000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_429,axiom,
    ! [VarCurr] :
      ( v4548(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6834,axiom,
    ~ b000000011000000001010111000(bitIndex26) ).

fof(bitBlastConstant_6833,axiom,
    ~ b000000011000000001010111000(bitIndex25) ).

fof(bitBlastConstant_6832,axiom,
    ~ b000000011000000001010111000(bitIndex24) ).

fof(bitBlastConstant_6831,axiom,
    ~ b000000011000000001010111000(bitIndex23) ).

fof(bitBlastConstant_6830,axiom,
    ~ b000000011000000001010111000(bitIndex22) ).

fof(bitBlastConstant_6829,axiom,
    ~ b000000011000000001010111000(bitIndex21) ).

fof(bitBlastConstant_6828,axiom,
    ~ b000000011000000001010111000(bitIndex20) ).

fof(bitBlastConstant_6827,axiom,
    b000000011000000001010111000(bitIndex19) ).

fof(bitBlastConstant_6826,axiom,
    b000000011000000001010111000(bitIndex18) ).

fof(bitBlastConstant_6825,axiom,
    ~ b000000011000000001010111000(bitIndex17) ).

fof(bitBlastConstant_6824,axiom,
    ~ b000000011000000001010111000(bitIndex16) ).

fof(bitBlastConstant_6823,axiom,
    ~ b000000011000000001010111000(bitIndex15) ).

fof(bitBlastConstant_6822,axiom,
    ~ b000000011000000001010111000(bitIndex14) ).

fof(bitBlastConstant_6821,axiom,
    ~ b000000011000000001010111000(bitIndex13) ).

fof(bitBlastConstant_6820,axiom,
    ~ b000000011000000001010111000(bitIndex12) ).

fof(bitBlastConstant_6819,axiom,
    ~ b000000011000000001010111000(bitIndex11) ).

fof(bitBlastConstant_6818,axiom,
    ~ b000000011000000001010111000(bitIndex10) ).

fof(bitBlastConstant_6817,axiom,
    b000000011000000001010111000(bitIndex9) ).

fof(bitBlastConstant_6816,axiom,
    ~ b000000011000000001010111000(bitIndex8) ).

fof(bitBlastConstant_6815,axiom,
    b000000011000000001010111000(bitIndex7) ).

fof(bitBlastConstant_6814,axiom,
    ~ b000000011000000001010111000(bitIndex6) ).

fof(bitBlastConstant_6813,axiom,
    b000000011000000001010111000(bitIndex5) ).

fof(bitBlastConstant_6812,axiom,
    b000000011000000001010111000(bitIndex4) ).

fof(bitBlastConstant_6811,axiom,
    b000000011000000001010111000(bitIndex3) ).

fof(bitBlastConstant_6810,axiom,
    ~ b000000011000000001010111000(bitIndex2) ).

fof(bitBlastConstant_6809,axiom,
    ~ b000000011000000001010111000(bitIndex1) ).

fof(bitBlastConstant_6808,axiom,
    ~ b000000011000000001010111000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_198,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4535(VarCurr)
      <=> v4539(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_200,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4535(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_121,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4539(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_132,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4539(VarCurr)
      <=> v4541(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_132,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4539(VarCurr)
      <=> v4540(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_428,axiom,
    ! [VarCurr] :
      ( v4541(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6807,axiom,
    ~ b000000011100000001010110111(bitIndex26) ).

fof(bitBlastConstant_6806,axiom,
    ~ b000000011100000001010110111(bitIndex25) ).

fof(bitBlastConstant_6805,axiom,
    ~ b000000011100000001010110111(bitIndex24) ).

fof(bitBlastConstant_6804,axiom,
    ~ b000000011100000001010110111(bitIndex23) ).

fof(bitBlastConstant_6803,axiom,
    ~ b000000011100000001010110111(bitIndex22) ).

fof(bitBlastConstant_6802,axiom,
    ~ b000000011100000001010110111(bitIndex21) ).

fof(bitBlastConstant_6801,axiom,
    ~ b000000011100000001010110111(bitIndex20) ).

fof(bitBlastConstant_6800,axiom,
    b000000011100000001010110111(bitIndex19) ).

fof(bitBlastConstant_6799,axiom,
    b000000011100000001010110111(bitIndex18) ).

fof(bitBlastConstant_6798,axiom,
    b000000011100000001010110111(bitIndex17) ).

fof(bitBlastConstant_6797,axiom,
    ~ b000000011100000001010110111(bitIndex16) ).

fof(bitBlastConstant_6796,axiom,
    ~ b000000011100000001010110111(bitIndex15) ).

fof(bitBlastConstant_6795,axiom,
    ~ b000000011100000001010110111(bitIndex14) ).

fof(bitBlastConstant_6794,axiom,
    ~ b000000011100000001010110111(bitIndex13) ).

fof(bitBlastConstant_6793,axiom,
    ~ b000000011100000001010110111(bitIndex12) ).

fof(bitBlastConstant_6792,axiom,
    ~ b000000011100000001010110111(bitIndex11) ).

fof(bitBlastConstant_6791,axiom,
    ~ b000000011100000001010110111(bitIndex10) ).

fof(bitBlastConstant_6790,axiom,
    b000000011100000001010110111(bitIndex9) ).

fof(bitBlastConstant_6789,axiom,
    ~ b000000011100000001010110111(bitIndex8) ).

fof(bitBlastConstant_6788,axiom,
    b000000011100000001010110111(bitIndex7) ).

fof(bitBlastConstant_6787,axiom,
    ~ b000000011100000001010110111(bitIndex6) ).

fof(bitBlastConstant_6786,axiom,
    b000000011100000001010110111(bitIndex5) ).

fof(bitBlastConstant_6785,axiom,
    b000000011100000001010110111(bitIndex4) ).

fof(bitBlastConstant_6784,axiom,
    ~ b000000011100000001010110111(bitIndex3) ).

fof(bitBlastConstant_6783,axiom,
    b000000011100000001010110111(bitIndex2) ).

fof(bitBlastConstant_6782,axiom,
    b000000011100000001010110111(bitIndex1) ).

fof(bitBlastConstant_6781,axiom,
    b000000011100000001010110111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_427,axiom,
    ! [VarCurr] :
      ( v4540(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6780,axiom,
    ~ b000000011000000001010110111(bitIndex26) ).

fof(bitBlastConstant_6779,axiom,
    ~ b000000011000000001010110111(bitIndex25) ).

fof(bitBlastConstant_6778,axiom,
    ~ b000000011000000001010110111(bitIndex24) ).

fof(bitBlastConstant_6777,axiom,
    ~ b000000011000000001010110111(bitIndex23) ).

fof(bitBlastConstant_6776,axiom,
    ~ b000000011000000001010110111(bitIndex22) ).

fof(bitBlastConstant_6775,axiom,
    ~ b000000011000000001010110111(bitIndex21) ).

fof(bitBlastConstant_6774,axiom,
    ~ b000000011000000001010110111(bitIndex20) ).

fof(bitBlastConstant_6773,axiom,
    b000000011000000001010110111(bitIndex19) ).

fof(bitBlastConstant_6772,axiom,
    b000000011000000001010110111(bitIndex18) ).

fof(bitBlastConstant_6771,axiom,
    ~ b000000011000000001010110111(bitIndex17) ).

fof(bitBlastConstant_6770,axiom,
    ~ b000000011000000001010110111(bitIndex16) ).

fof(bitBlastConstant_6769,axiom,
    ~ b000000011000000001010110111(bitIndex15) ).

fof(bitBlastConstant_6768,axiom,
    ~ b000000011000000001010110111(bitIndex14) ).

fof(bitBlastConstant_6767,axiom,
    ~ b000000011000000001010110111(bitIndex13) ).

fof(bitBlastConstant_6766,axiom,
    ~ b000000011000000001010110111(bitIndex12) ).

fof(bitBlastConstant_6765,axiom,
    ~ b000000011000000001010110111(bitIndex11) ).

fof(bitBlastConstant_6764,axiom,
    ~ b000000011000000001010110111(bitIndex10) ).

fof(bitBlastConstant_6763,axiom,
    b000000011000000001010110111(bitIndex9) ).

fof(bitBlastConstant_6762,axiom,
    ~ b000000011000000001010110111(bitIndex8) ).

fof(bitBlastConstant_6761,axiom,
    b000000011000000001010110111(bitIndex7) ).

fof(bitBlastConstant_6760,axiom,
    ~ b000000011000000001010110111(bitIndex6) ).

fof(bitBlastConstant_6759,axiom,
    b000000011000000001010110111(bitIndex5) ).

fof(bitBlastConstant_6758,axiom,
    b000000011000000001010110111(bitIndex4) ).

fof(bitBlastConstant_6757,axiom,
    ~ b000000011000000001010110111(bitIndex3) ).

fof(bitBlastConstant_6756,axiom,
    b000000011000000001010110111(bitIndex2) ).

fof(bitBlastConstant_6755,axiom,
    b000000011000000001010110111(bitIndex1) ).

fof(bitBlastConstant_6754,axiom,
    b000000011000000001010110111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_197,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4527(VarCurr)
      <=> v4531(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_199,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4527(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_120,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4531(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_131,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4531(VarCurr)
      <=> v4533(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_131,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4531(VarCurr)
      <=> v4532(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_426,axiom,
    ! [VarCurr] :
      ( v4533(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6753,axiom,
    ~ b000000011100000001010110110(bitIndex26) ).

fof(bitBlastConstant_6752,axiom,
    ~ b000000011100000001010110110(bitIndex25) ).

fof(bitBlastConstant_6751,axiom,
    ~ b000000011100000001010110110(bitIndex24) ).

fof(bitBlastConstant_6750,axiom,
    ~ b000000011100000001010110110(bitIndex23) ).

fof(bitBlastConstant_6749,axiom,
    ~ b000000011100000001010110110(bitIndex22) ).

fof(bitBlastConstant_6748,axiom,
    ~ b000000011100000001010110110(bitIndex21) ).

fof(bitBlastConstant_6747,axiom,
    ~ b000000011100000001010110110(bitIndex20) ).

fof(bitBlastConstant_6746,axiom,
    b000000011100000001010110110(bitIndex19) ).

fof(bitBlastConstant_6745,axiom,
    b000000011100000001010110110(bitIndex18) ).

fof(bitBlastConstant_6744,axiom,
    b000000011100000001010110110(bitIndex17) ).

fof(bitBlastConstant_6743,axiom,
    ~ b000000011100000001010110110(bitIndex16) ).

fof(bitBlastConstant_6742,axiom,
    ~ b000000011100000001010110110(bitIndex15) ).

fof(bitBlastConstant_6741,axiom,
    ~ b000000011100000001010110110(bitIndex14) ).

fof(bitBlastConstant_6740,axiom,
    ~ b000000011100000001010110110(bitIndex13) ).

fof(bitBlastConstant_6739,axiom,
    ~ b000000011100000001010110110(bitIndex12) ).

fof(bitBlastConstant_6738,axiom,
    ~ b000000011100000001010110110(bitIndex11) ).

fof(bitBlastConstant_6737,axiom,
    ~ b000000011100000001010110110(bitIndex10) ).

fof(bitBlastConstant_6736,axiom,
    b000000011100000001010110110(bitIndex9) ).

fof(bitBlastConstant_6735,axiom,
    ~ b000000011100000001010110110(bitIndex8) ).

fof(bitBlastConstant_6734,axiom,
    b000000011100000001010110110(bitIndex7) ).

fof(bitBlastConstant_6733,axiom,
    ~ b000000011100000001010110110(bitIndex6) ).

fof(bitBlastConstant_6732,axiom,
    b000000011100000001010110110(bitIndex5) ).

fof(bitBlastConstant_6731,axiom,
    b000000011100000001010110110(bitIndex4) ).

fof(bitBlastConstant_6730,axiom,
    ~ b000000011100000001010110110(bitIndex3) ).

fof(bitBlastConstant_6729,axiom,
    b000000011100000001010110110(bitIndex2) ).

fof(bitBlastConstant_6728,axiom,
    b000000011100000001010110110(bitIndex1) ).

fof(bitBlastConstant_6727,axiom,
    ~ b000000011100000001010110110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_425,axiom,
    ! [VarCurr] :
      ( v4532(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6726,axiom,
    ~ b000000011000000001010110110(bitIndex26) ).

fof(bitBlastConstant_6725,axiom,
    ~ b000000011000000001010110110(bitIndex25) ).

fof(bitBlastConstant_6724,axiom,
    ~ b000000011000000001010110110(bitIndex24) ).

fof(bitBlastConstant_6723,axiom,
    ~ b000000011000000001010110110(bitIndex23) ).

fof(bitBlastConstant_6722,axiom,
    ~ b000000011000000001010110110(bitIndex22) ).

fof(bitBlastConstant_6721,axiom,
    ~ b000000011000000001010110110(bitIndex21) ).

fof(bitBlastConstant_6720,axiom,
    ~ b000000011000000001010110110(bitIndex20) ).

fof(bitBlastConstant_6719,axiom,
    b000000011000000001010110110(bitIndex19) ).

fof(bitBlastConstant_6718,axiom,
    b000000011000000001010110110(bitIndex18) ).

fof(bitBlastConstant_6717,axiom,
    ~ b000000011000000001010110110(bitIndex17) ).

fof(bitBlastConstant_6716,axiom,
    ~ b000000011000000001010110110(bitIndex16) ).

fof(bitBlastConstant_6715,axiom,
    ~ b000000011000000001010110110(bitIndex15) ).

fof(bitBlastConstant_6714,axiom,
    ~ b000000011000000001010110110(bitIndex14) ).

fof(bitBlastConstant_6713,axiom,
    ~ b000000011000000001010110110(bitIndex13) ).

fof(bitBlastConstant_6712,axiom,
    ~ b000000011000000001010110110(bitIndex12) ).

fof(bitBlastConstant_6711,axiom,
    ~ b000000011000000001010110110(bitIndex11) ).

fof(bitBlastConstant_6710,axiom,
    ~ b000000011000000001010110110(bitIndex10) ).

fof(bitBlastConstant_6709,axiom,
    b000000011000000001010110110(bitIndex9) ).

fof(bitBlastConstant_6708,axiom,
    ~ b000000011000000001010110110(bitIndex8) ).

fof(bitBlastConstant_6707,axiom,
    b000000011000000001010110110(bitIndex7) ).

fof(bitBlastConstant_6706,axiom,
    ~ b000000011000000001010110110(bitIndex6) ).

fof(bitBlastConstant_6705,axiom,
    b000000011000000001010110110(bitIndex5) ).

fof(bitBlastConstant_6704,axiom,
    b000000011000000001010110110(bitIndex4) ).

fof(bitBlastConstant_6703,axiom,
    ~ b000000011000000001010110110(bitIndex3) ).

fof(bitBlastConstant_6702,axiom,
    b000000011000000001010110110(bitIndex2) ).

fof(bitBlastConstant_6701,axiom,
    b000000011000000001010110110(bitIndex1) ).

fof(bitBlastConstant_6700,axiom,
    ~ b000000011000000001010110110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_196,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4519(VarCurr)
      <=> v4523(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_198,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4519(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_119,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4523(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_130,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4523(VarCurr)
      <=> v4525(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_130,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4523(VarCurr)
      <=> v4524(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_424,axiom,
    ! [VarCurr] :
      ( v4525(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6699,axiom,
    ~ b000000011100000001010110101(bitIndex26) ).

fof(bitBlastConstant_6698,axiom,
    ~ b000000011100000001010110101(bitIndex25) ).

fof(bitBlastConstant_6697,axiom,
    ~ b000000011100000001010110101(bitIndex24) ).

fof(bitBlastConstant_6696,axiom,
    ~ b000000011100000001010110101(bitIndex23) ).

fof(bitBlastConstant_6695,axiom,
    ~ b000000011100000001010110101(bitIndex22) ).

fof(bitBlastConstant_6694,axiom,
    ~ b000000011100000001010110101(bitIndex21) ).

fof(bitBlastConstant_6693,axiom,
    ~ b000000011100000001010110101(bitIndex20) ).

fof(bitBlastConstant_6692,axiom,
    b000000011100000001010110101(bitIndex19) ).

fof(bitBlastConstant_6691,axiom,
    b000000011100000001010110101(bitIndex18) ).

fof(bitBlastConstant_6690,axiom,
    b000000011100000001010110101(bitIndex17) ).

fof(bitBlastConstant_6689,axiom,
    ~ b000000011100000001010110101(bitIndex16) ).

fof(bitBlastConstant_6688,axiom,
    ~ b000000011100000001010110101(bitIndex15) ).

fof(bitBlastConstant_6687,axiom,
    ~ b000000011100000001010110101(bitIndex14) ).

fof(bitBlastConstant_6686,axiom,
    ~ b000000011100000001010110101(bitIndex13) ).

fof(bitBlastConstant_6685,axiom,
    ~ b000000011100000001010110101(bitIndex12) ).

fof(bitBlastConstant_6684,axiom,
    ~ b000000011100000001010110101(bitIndex11) ).

fof(bitBlastConstant_6683,axiom,
    ~ b000000011100000001010110101(bitIndex10) ).

fof(bitBlastConstant_6682,axiom,
    b000000011100000001010110101(bitIndex9) ).

fof(bitBlastConstant_6681,axiom,
    ~ b000000011100000001010110101(bitIndex8) ).

fof(bitBlastConstant_6680,axiom,
    b000000011100000001010110101(bitIndex7) ).

fof(bitBlastConstant_6679,axiom,
    ~ b000000011100000001010110101(bitIndex6) ).

fof(bitBlastConstant_6678,axiom,
    b000000011100000001010110101(bitIndex5) ).

fof(bitBlastConstant_6677,axiom,
    b000000011100000001010110101(bitIndex4) ).

fof(bitBlastConstant_6676,axiom,
    ~ b000000011100000001010110101(bitIndex3) ).

fof(bitBlastConstant_6675,axiom,
    b000000011100000001010110101(bitIndex2) ).

fof(bitBlastConstant_6674,axiom,
    ~ b000000011100000001010110101(bitIndex1) ).

fof(bitBlastConstant_6673,axiom,
    b000000011100000001010110101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_423,axiom,
    ! [VarCurr] :
      ( v4524(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6672,axiom,
    ~ b000000011000000001010110101(bitIndex26) ).

fof(bitBlastConstant_6671,axiom,
    ~ b000000011000000001010110101(bitIndex25) ).

fof(bitBlastConstant_6670,axiom,
    ~ b000000011000000001010110101(bitIndex24) ).

fof(bitBlastConstant_6669,axiom,
    ~ b000000011000000001010110101(bitIndex23) ).

fof(bitBlastConstant_6668,axiom,
    ~ b000000011000000001010110101(bitIndex22) ).

fof(bitBlastConstant_6667,axiom,
    ~ b000000011000000001010110101(bitIndex21) ).

fof(bitBlastConstant_6666,axiom,
    ~ b000000011000000001010110101(bitIndex20) ).

fof(bitBlastConstant_6665,axiom,
    b000000011000000001010110101(bitIndex19) ).

fof(bitBlastConstant_6664,axiom,
    b000000011000000001010110101(bitIndex18) ).

fof(bitBlastConstant_6663,axiom,
    ~ b000000011000000001010110101(bitIndex17) ).

fof(bitBlastConstant_6662,axiom,
    ~ b000000011000000001010110101(bitIndex16) ).

fof(bitBlastConstant_6661,axiom,
    ~ b000000011000000001010110101(bitIndex15) ).

fof(bitBlastConstant_6660,axiom,
    ~ b000000011000000001010110101(bitIndex14) ).

fof(bitBlastConstant_6659,axiom,
    ~ b000000011000000001010110101(bitIndex13) ).

fof(bitBlastConstant_6658,axiom,
    ~ b000000011000000001010110101(bitIndex12) ).

fof(bitBlastConstant_6657,axiom,
    ~ b000000011000000001010110101(bitIndex11) ).

fof(bitBlastConstant_6656,axiom,
    ~ b000000011000000001010110101(bitIndex10) ).

fof(bitBlastConstant_6655,axiom,
    b000000011000000001010110101(bitIndex9) ).

fof(bitBlastConstant_6654,axiom,
    ~ b000000011000000001010110101(bitIndex8) ).

fof(bitBlastConstant_6653,axiom,
    b000000011000000001010110101(bitIndex7) ).

fof(bitBlastConstant_6652,axiom,
    ~ b000000011000000001010110101(bitIndex6) ).

fof(bitBlastConstant_6651,axiom,
    b000000011000000001010110101(bitIndex5) ).

fof(bitBlastConstant_6650,axiom,
    b000000011000000001010110101(bitIndex4) ).

fof(bitBlastConstant_6649,axiom,
    ~ b000000011000000001010110101(bitIndex3) ).

fof(bitBlastConstant_6648,axiom,
    b000000011000000001010110101(bitIndex2) ).

fof(bitBlastConstant_6647,axiom,
    ~ b000000011000000001010110101(bitIndex1) ).

fof(bitBlastConstant_6646,axiom,
    b000000011000000001010110101(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_195,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4511(VarCurr)
      <=> v4515(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_197,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4511(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_118,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4515(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_129,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4515(VarCurr)
      <=> v4517(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_129,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4515(VarCurr)
      <=> v4516(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_422,axiom,
    ! [VarCurr] :
      ( v4517(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6645,axiom,
    ~ b000000011100000001010110100(bitIndex26) ).

fof(bitBlastConstant_6644,axiom,
    ~ b000000011100000001010110100(bitIndex25) ).

fof(bitBlastConstant_6643,axiom,
    ~ b000000011100000001010110100(bitIndex24) ).

fof(bitBlastConstant_6642,axiom,
    ~ b000000011100000001010110100(bitIndex23) ).

fof(bitBlastConstant_6641,axiom,
    ~ b000000011100000001010110100(bitIndex22) ).

fof(bitBlastConstant_6640,axiom,
    ~ b000000011100000001010110100(bitIndex21) ).

fof(bitBlastConstant_6639,axiom,
    ~ b000000011100000001010110100(bitIndex20) ).

fof(bitBlastConstant_6638,axiom,
    b000000011100000001010110100(bitIndex19) ).

fof(bitBlastConstant_6637,axiom,
    b000000011100000001010110100(bitIndex18) ).

fof(bitBlastConstant_6636,axiom,
    b000000011100000001010110100(bitIndex17) ).

fof(bitBlastConstant_6635,axiom,
    ~ b000000011100000001010110100(bitIndex16) ).

fof(bitBlastConstant_6634,axiom,
    ~ b000000011100000001010110100(bitIndex15) ).

fof(bitBlastConstant_6633,axiom,
    ~ b000000011100000001010110100(bitIndex14) ).

fof(bitBlastConstant_6632,axiom,
    ~ b000000011100000001010110100(bitIndex13) ).

fof(bitBlastConstant_6631,axiom,
    ~ b000000011100000001010110100(bitIndex12) ).

fof(bitBlastConstant_6630,axiom,
    ~ b000000011100000001010110100(bitIndex11) ).

fof(bitBlastConstant_6629,axiom,
    ~ b000000011100000001010110100(bitIndex10) ).

fof(bitBlastConstant_6628,axiom,
    b000000011100000001010110100(bitIndex9) ).

fof(bitBlastConstant_6627,axiom,
    ~ b000000011100000001010110100(bitIndex8) ).

fof(bitBlastConstant_6626,axiom,
    b000000011100000001010110100(bitIndex7) ).

fof(bitBlastConstant_6625,axiom,
    ~ b000000011100000001010110100(bitIndex6) ).

fof(bitBlastConstant_6624,axiom,
    b000000011100000001010110100(bitIndex5) ).

fof(bitBlastConstant_6623,axiom,
    b000000011100000001010110100(bitIndex4) ).

fof(bitBlastConstant_6622,axiom,
    ~ b000000011100000001010110100(bitIndex3) ).

fof(bitBlastConstant_6621,axiom,
    b000000011100000001010110100(bitIndex2) ).

fof(bitBlastConstant_6620,axiom,
    ~ b000000011100000001010110100(bitIndex1) ).

fof(bitBlastConstant_6619,axiom,
    ~ b000000011100000001010110100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_421,axiom,
    ! [VarCurr] :
      ( v4516(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6618,axiom,
    ~ b000000011000000001010110100(bitIndex26) ).

fof(bitBlastConstant_6617,axiom,
    ~ b000000011000000001010110100(bitIndex25) ).

fof(bitBlastConstant_6616,axiom,
    ~ b000000011000000001010110100(bitIndex24) ).

fof(bitBlastConstant_6615,axiom,
    ~ b000000011000000001010110100(bitIndex23) ).

fof(bitBlastConstant_6614,axiom,
    ~ b000000011000000001010110100(bitIndex22) ).

fof(bitBlastConstant_6613,axiom,
    ~ b000000011000000001010110100(bitIndex21) ).

fof(bitBlastConstant_6612,axiom,
    ~ b000000011000000001010110100(bitIndex20) ).

fof(bitBlastConstant_6611,axiom,
    b000000011000000001010110100(bitIndex19) ).

fof(bitBlastConstant_6610,axiom,
    b000000011000000001010110100(bitIndex18) ).

fof(bitBlastConstant_6609,axiom,
    ~ b000000011000000001010110100(bitIndex17) ).

fof(bitBlastConstant_6608,axiom,
    ~ b000000011000000001010110100(bitIndex16) ).

fof(bitBlastConstant_6607,axiom,
    ~ b000000011000000001010110100(bitIndex15) ).

fof(bitBlastConstant_6606,axiom,
    ~ b000000011000000001010110100(bitIndex14) ).

fof(bitBlastConstant_6605,axiom,
    ~ b000000011000000001010110100(bitIndex13) ).

fof(bitBlastConstant_6604,axiom,
    ~ b000000011000000001010110100(bitIndex12) ).

fof(bitBlastConstant_6603,axiom,
    ~ b000000011000000001010110100(bitIndex11) ).

fof(bitBlastConstant_6602,axiom,
    ~ b000000011000000001010110100(bitIndex10) ).

fof(bitBlastConstant_6601,axiom,
    b000000011000000001010110100(bitIndex9) ).

fof(bitBlastConstant_6600,axiom,
    ~ b000000011000000001010110100(bitIndex8) ).

fof(bitBlastConstant_6599,axiom,
    b000000011000000001010110100(bitIndex7) ).

fof(bitBlastConstant_6598,axiom,
    ~ b000000011000000001010110100(bitIndex6) ).

fof(bitBlastConstant_6597,axiom,
    b000000011000000001010110100(bitIndex5) ).

fof(bitBlastConstant_6596,axiom,
    b000000011000000001010110100(bitIndex4) ).

fof(bitBlastConstant_6595,axiom,
    ~ b000000011000000001010110100(bitIndex3) ).

fof(bitBlastConstant_6594,axiom,
    b000000011000000001010110100(bitIndex2) ).

fof(bitBlastConstant_6593,axiom,
    ~ b000000011000000001010110100(bitIndex1) ).

fof(bitBlastConstant_6592,axiom,
    ~ b000000011000000001010110100(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_194,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4503(VarCurr)
      <=> v4507(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_196,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4503(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_117,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4507(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_128,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4507(VarCurr)
      <=> v4509(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_128,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4507(VarCurr)
      <=> v4508(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_420,axiom,
    ! [VarCurr] :
      ( v4509(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6591,axiom,
    ~ b000000011100000001010110011(bitIndex26) ).

fof(bitBlastConstant_6590,axiom,
    ~ b000000011100000001010110011(bitIndex25) ).

fof(bitBlastConstant_6589,axiom,
    ~ b000000011100000001010110011(bitIndex24) ).

fof(bitBlastConstant_6588,axiom,
    ~ b000000011100000001010110011(bitIndex23) ).

fof(bitBlastConstant_6587,axiom,
    ~ b000000011100000001010110011(bitIndex22) ).

fof(bitBlastConstant_6586,axiom,
    ~ b000000011100000001010110011(bitIndex21) ).

fof(bitBlastConstant_6585,axiom,
    ~ b000000011100000001010110011(bitIndex20) ).

fof(bitBlastConstant_6584,axiom,
    b000000011100000001010110011(bitIndex19) ).

fof(bitBlastConstant_6583,axiom,
    b000000011100000001010110011(bitIndex18) ).

fof(bitBlastConstant_6582,axiom,
    b000000011100000001010110011(bitIndex17) ).

fof(bitBlastConstant_6581,axiom,
    ~ b000000011100000001010110011(bitIndex16) ).

fof(bitBlastConstant_6580,axiom,
    ~ b000000011100000001010110011(bitIndex15) ).

fof(bitBlastConstant_6579,axiom,
    ~ b000000011100000001010110011(bitIndex14) ).

fof(bitBlastConstant_6578,axiom,
    ~ b000000011100000001010110011(bitIndex13) ).

fof(bitBlastConstant_6577,axiom,
    ~ b000000011100000001010110011(bitIndex12) ).

fof(bitBlastConstant_6576,axiom,
    ~ b000000011100000001010110011(bitIndex11) ).

fof(bitBlastConstant_6575,axiom,
    ~ b000000011100000001010110011(bitIndex10) ).

fof(bitBlastConstant_6574,axiom,
    b000000011100000001010110011(bitIndex9) ).

fof(bitBlastConstant_6573,axiom,
    ~ b000000011100000001010110011(bitIndex8) ).

fof(bitBlastConstant_6572,axiom,
    b000000011100000001010110011(bitIndex7) ).

fof(bitBlastConstant_6571,axiom,
    ~ b000000011100000001010110011(bitIndex6) ).

fof(bitBlastConstant_6570,axiom,
    b000000011100000001010110011(bitIndex5) ).

fof(bitBlastConstant_6569,axiom,
    b000000011100000001010110011(bitIndex4) ).

fof(bitBlastConstant_6568,axiom,
    ~ b000000011100000001010110011(bitIndex3) ).

fof(bitBlastConstant_6567,axiom,
    ~ b000000011100000001010110011(bitIndex2) ).

fof(bitBlastConstant_6566,axiom,
    b000000011100000001010110011(bitIndex1) ).

fof(bitBlastConstant_6565,axiom,
    b000000011100000001010110011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_419,axiom,
    ! [VarCurr] :
      ( v4508(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6564,axiom,
    ~ b000000011000000001010110011(bitIndex26) ).

fof(bitBlastConstant_6563,axiom,
    ~ b000000011000000001010110011(bitIndex25) ).

fof(bitBlastConstant_6562,axiom,
    ~ b000000011000000001010110011(bitIndex24) ).

fof(bitBlastConstant_6561,axiom,
    ~ b000000011000000001010110011(bitIndex23) ).

fof(bitBlastConstant_6560,axiom,
    ~ b000000011000000001010110011(bitIndex22) ).

fof(bitBlastConstant_6559,axiom,
    ~ b000000011000000001010110011(bitIndex21) ).

fof(bitBlastConstant_6558,axiom,
    ~ b000000011000000001010110011(bitIndex20) ).

fof(bitBlastConstant_6557,axiom,
    b000000011000000001010110011(bitIndex19) ).

fof(bitBlastConstant_6556,axiom,
    b000000011000000001010110011(bitIndex18) ).

fof(bitBlastConstant_6555,axiom,
    ~ b000000011000000001010110011(bitIndex17) ).

fof(bitBlastConstant_6554,axiom,
    ~ b000000011000000001010110011(bitIndex16) ).

fof(bitBlastConstant_6553,axiom,
    ~ b000000011000000001010110011(bitIndex15) ).

fof(bitBlastConstant_6552,axiom,
    ~ b000000011000000001010110011(bitIndex14) ).

fof(bitBlastConstant_6551,axiom,
    ~ b000000011000000001010110011(bitIndex13) ).

fof(bitBlastConstant_6550,axiom,
    ~ b000000011000000001010110011(bitIndex12) ).

fof(bitBlastConstant_6549,axiom,
    ~ b000000011000000001010110011(bitIndex11) ).

fof(bitBlastConstant_6548,axiom,
    ~ b000000011000000001010110011(bitIndex10) ).

fof(bitBlastConstant_6547,axiom,
    b000000011000000001010110011(bitIndex9) ).

fof(bitBlastConstant_6546,axiom,
    ~ b000000011000000001010110011(bitIndex8) ).

fof(bitBlastConstant_6545,axiom,
    b000000011000000001010110011(bitIndex7) ).

fof(bitBlastConstant_6544,axiom,
    ~ b000000011000000001010110011(bitIndex6) ).

fof(bitBlastConstant_6543,axiom,
    b000000011000000001010110011(bitIndex5) ).

fof(bitBlastConstant_6542,axiom,
    b000000011000000001010110011(bitIndex4) ).

fof(bitBlastConstant_6541,axiom,
    ~ b000000011000000001010110011(bitIndex3) ).

fof(bitBlastConstant_6540,axiom,
    ~ b000000011000000001010110011(bitIndex2) ).

fof(bitBlastConstant_6539,axiom,
    b000000011000000001010110011(bitIndex1) ).

fof(bitBlastConstant_6538,axiom,
    b000000011000000001010110011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_193,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4495(VarCurr)
      <=> v4499(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_195,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4495(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_116,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4499(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_127,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4499(VarCurr)
      <=> v4501(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_127,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4499(VarCurr)
      <=> v4500(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_418,axiom,
    ! [VarCurr] :
      ( v4501(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6537,axiom,
    ~ b000000011100000001010110010(bitIndex26) ).

fof(bitBlastConstant_6536,axiom,
    ~ b000000011100000001010110010(bitIndex25) ).

fof(bitBlastConstant_6535,axiom,
    ~ b000000011100000001010110010(bitIndex24) ).

fof(bitBlastConstant_6534,axiom,
    ~ b000000011100000001010110010(bitIndex23) ).

fof(bitBlastConstant_6533,axiom,
    ~ b000000011100000001010110010(bitIndex22) ).

fof(bitBlastConstant_6532,axiom,
    ~ b000000011100000001010110010(bitIndex21) ).

fof(bitBlastConstant_6531,axiom,
    ~ b000000011100000001010110010(bitIndex20) ).

fof(bitBlastConstant_6530,axiom,
    b000000011100000001010110010(bitIndex19) ).

fof(bitBlastConstant_6529,axiom,
    b000000011100000001010110010(bitIndex18) ).

fof(bitBlastConstant_6528,axiom,
    b000000011100000001010110010(bitIndex17) ).

fof(bitBlastConstant_6527,axiom,
    ~ b000000011100000001010110010(bitIndex16) ).

fof(bitBlastConstant_6526,axiom,
    ~ b000000011100000001010110010(bitIndex15) ).

fof(bitBlastConstant_6525,axiom,
    ~ b000000011100000001010110010(bitIndex14) ).

fof(bitBlastConstant_6524,axiom,
    ~ b000000011100000001010110010(bitIndex13) ).

fof(bitBlastConstant_6523,axiom,
    ~ b000000011100000001010110010(bitIndex12) ).

fof(bitBlastConstant_6522,axiom,
    ~ b000000011100000001010110010(bitIndex11) ).

fof(bitBlastConstant_6521,axiom,
    ~ b000000011100000001010110010(bitIndex10) ).

fof(bitBlastConstant_6520,axiom,
    b000000011100000001010110010(bitIndex9) ).

fof(bitBlastConstant_6519,axiom,
    ~ b000000011100000001010110010(bitIndex8) ).

fof(bitBlastConstant_6518,axiom,
    b000000011100000001010110010(bitIndex7) ).

fof(bitBlastConstant_6517,axiom,
    ~ b000000011100000001010110010(bitIndex6) ).

fof(bitBlastConstant_6516,axiom,
    b000000011100000001010110010(bitIndex5) ).

fof(bitBlastConstant_6515,axiom,
    b000000011100000001010110010(bitIndex4) ).

fof(bitBlastConstant_6514,axiom,
    ~ b000000011100000001010110010(bitIndex3) ).

fof(bitBlastConstant_6513,axiom,
    ~ b000000011100000001010110010(bitIndex2) ).

fof(bitBlastConstant_6512,axiom,
    b000000011100000001010110010(bitIndex1) ).

fof(bitBlastConstant_6511,axiom,
    ~ b000000011100000001010110010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_417,axiom,
    ! [VarCurr] :
      ( v4500(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6510,axiom,
    ~ b000000011000000001010110010(bitIndex26) ).

fof(bitBlastConstant_6509,axiom,
    ~ b000000011000000001010110010(bitIndex25) ).

fof(bitBlastConstant_6508,axiom,
    ~ b000000011000000001010110010(bitIndex24) ).

fof(bitBlastConstant_6507,axiom,
    ~ b000000011000000001010110010(bitIndex23) ).

fof(bitBlastConstant_6506,axiom,
    ~ b000000011000000001010110010(bitIndex22) ).

fof(bitBlastConstant_6505,axiom,
    ~ b000000011000000001010110010(bitIndex21) ).

fof(bitBlastConstant_6504,axiom,
    ~ b000000011000000001010110010(bitIndex20) ).

fof(bitBlastConstant_6503,axiom,
    b000000011000000001010110010(bitIndex19) ).

fof(bitBlastConstant_6502,axiom,
    b000000011000000001010110010(bitIndex18) ).

fof(bitBlastConstant_6501,axiom,
    ~ b000000011000000001010110010(bitIndex17) ).

fof(bitBlastConstant_6500,axiom,
    ~ b000000011000000001010110010(bitIndex16) ).

fof(bitBlastConstant_6499,axiom,
    ~ b000000011000000001010110010(bitIndex15) ).

fof(bitBlastConstant_6498,axiom,
    ~ b000000011000000001010110010(bitIndex14) ).

fof(bitBlastConstant_6497,axiom,
    ~ b000000011000000001010110010(bitIndex13) ).

fof(bitBlastConstant_6496,axiom,
    ~ b000000011000000001010110010(bitIndex12) ).

fof(bitBlastConstant_6495,axiom,
    ~ b000000011000000001010110010(bitIndex11) ).

fof(bitBlastConstant_6494,axiom,
    ~ b000000011000000001010110010(bitIndex10) ).

fof(bitBlastConstant_6493,axiom,
    b000000011000000001010110010(bitIndex9) ).

fof(bitBlastConstant_6492,axiom,
    ~ b000000011000000001010110010(bitIndex8) ).

fof(bitBlastConstant_6491,axiom,
    b000000011000000001010110010(bitIndex7) ).

fof(bitBlastConstant_6490,axiom,
    ~ b000000011000000001010110010(bitIndex6) ).

fof(bitBlastConstant_6489,axiom,
    b000000011000000001010110010(bitIndex5) ).

fof(bitBlastConstant_6488,axiom,
    b000000011000000001010110010(bitIndex4) ).

fof(bitBlastConstant_6487,axiom,
    ~ b000000011000000001010110010(bitIndex3) ).

fof(bitBlastConstant_6486,axiom,
    ~ b000000011000000001010110010(bitIndex2) ).

fof(bitBlastConstant_6485,axiom,
    b000000011000000001010110010(bitIndex1) ).

fof(bitBlastConstant_6484,axiom,
    ~ b000000011000000001010110010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_192,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4487(VarCurr)
      <=> v4491(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_194,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4487(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_115,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4491(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_126,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4491(VarCurr)
      <=> v4493(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_126,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4491(VarCurr)
      <=> v4492(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_416,axiom,
    ! [VarCurr] :
      ( v4493(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6483,axiom,
    ~ b000000011100000001010110001(bitIndex26) ).

fof(bitBlastConstant_6482,axiom,
    ~ b000000011100000001010110001(bitIndex25) ).

fof(bitBlastConstant_6481,axiom,
    ~ b000000011100000001010110001(bitIndex24) ).

fof(bitBlastConstant_6480,axiom,
    ~ b000000011100000001010110001(bitIndex23) ).

fof(bitBlastConstant_6479,axiom,
    ~ b000000011100000001010110001(bitIndex22) ).

fof(bitBlastConstant_6478,axiom,
    ~ b000000011100000001010110001(bitIndex21) ).

fof(bitBlastConstant_6477,axiom,
    ~ b000000011100000001010110001(bitIndex20) ).

fof(bitBlastConstant_6476,axiom,
    b000000011100000001010110001(bitIndex19) ).

fof(bitBlastConstant_6475,axiom,
    b000000011100000001010110001(bitIndex18) ).

fof(bitBlastConstant_6474,axiom,
    b000000011100000001010110001(bitIndex17) ).

fof(bitBlastConstant_6473,axiom,
    ~ b000000011100000001010110001(bitIndex16) ).

fof(bitBlastConstant_6472,axiom,
    ~ b000000011100000001010110001(bitIndex15) ).

fof(bitBlastConstant_6471,axiom,
    ~ b000000011100000001010110001(bitIndex14) ).

fof(bitBlastConstant_6470,axiom,
    ~ b000000011100000001010110001(bitIndex13) ).

fof(bitBlastConstant_6469,axiom,
    ~ b000000011100000001010110001(bitIndex12) ).

fof(bitBlastConstant_6468,axiom,
    ~ b000000011100000001010110001(bitIndex11) ).

fof(bitBlastConstant_6467,axiom,
    ~ b000000011100000001010110001(bitIndex10) ).

fof(bitBlastConstant_6466,axiom,
    b000000011100000001010110001(bitIndex9) ).

fof(bitBlastConstant_6465,axiom,
    ~ b000000011100000001010110001(bitIndex8) ).

fof(bitBlastConstant_6464,axiom,
    b000000011100000001010110001(bitIndex7) ).

fof(bitBlastConstant_6463,axiom,
    ~ b000000011100000001010110001(bitIndex6) ).

fof(bitBlastConstant_6462,axiom,
    b000000011100000001010110001(bitIndex5) ).

fof(bitBlastConstant_6461,axiom,
    b000000011100000001010110001(bitIndex4) ).

fof(bitBlastConstant_6460,axiom,
    ~ b000000011100000001010110001(bitIndex3) ).

fof(bitBlastConstant_6459,axiom,
    ~ b000000011100000001010110001(bitIndex2) ).

fof(bitBlastConstant_6458,axiom,
    ~ b000000011100000001010110001(bitIndex1) ).

fof(bitBlastConstant_6457,axiom,
    b000000011100000001010110001(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_415,axiom,
    ! [VarCurr] :
      ( v4492(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6456,axiom,
    ~ b000000011000000001010110001(bitIndex26) ).

fof(bitBlastConstant_6455,axiom,
    ~ b000000011000000001010110001(bitIndex25) ).

fof(bitBlastConstant_6454,axiom,
    ~ b000000011000000001010110001(bitIndex24) ).

fof(bitBlastConstant_6453,axiom,
    ~ b000000011000000001010110001(bitIndex23) ).

fof(bitBlastConstant_6452,axiom,
    ~ b000000011000000001010110001(bitIndex22) ).

fof(bitBlastConstant_6451,axiom,
    ~ b000000011000000001010110001(bitIndex21) ).

fof(bitBlastConstant_6450,axiom,
    ~ b000000011000000001010110001(bitIndex20) ).

fof(bitBlastConstant_6449,axiom,
    b000000011000000001010110001(bitIndex19) ).

fof(bitBlastConstant_6448,axiom,
    b000000011000000001010110001(bitIndex18) ).

fof(bitBlastConstant_6447,axiom,
    ~ b000000011000000001010110001(bitIndex17) ).

fof(bitBlastConstant_6446,axiom,
    ~ b000000011000000001010110001(bitIndex16) ).

fof(bitBlastConstant_6445,axiom,
    ~ b000000011000000001010110001(bitIndex15) ).

fof(bitBlastConstant_6444,axiom,
    ~ b000000011000000001010110001(bitIndex14) ).

fof(bitBlastConstant_6443,axiom,
    ~ b000000011000000001010110001(bitIndex13) ).

fof(bitBlastConstant_6442,axiom,
    ~ b000000011000000001010110001(bitIndex12) ).

fof(bitBlastConstant_6441,axiom,
    ~ b000000011000000001010110001(bitIndex11) ).

fof(bitBlastConstant_6440,axiom,
    ~ b000000011000000001010110001(bitIndex10) ).

fof(bitBlastConstant_6439,axiom,
    b000000011000000001010110001(bitIndex9) ).

fof(bitBlastConstant_6438,axiom,
    ~ b000000011000000001010110001(bitIndex8) ).

fof(bitBlastConstant_6437,axiom,
    b000000011000000001010110001(bitIndex7) ).

fof(bitBlastConstant_6436,axiom,
    ~ b000000011000000001010110001(bitIndex6) ).

fof(bitBlastConstant_6435,axiom,
    b000000011000000001010110001(bitIndex5) ).

fof(bitBlastConstant_6434,axiom,
    b000000011000000001010110001(bitIndex4) ).

fof(bitBlastConstant_6433,axiom,
    ~ b000000011000000001010110001(bitIndex3) ).

fof(bitBlastConstant_6432,axiom,
    ~ b000000011000000001010110001(bitIndex2) ).

fof(bitBlastConstant_6431,axiom,
    ~ b000000011000000001010110001(bitIndex1) ).

fof(bitBlastConstant_6430,axiom,
    b000000011000000001010110001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_191,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4479(VarCurr)
      <=> v4483(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_193,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4479(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_114,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4483(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_125,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4483(VarCurr)
      <=> v4485(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_125,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4483(VarCurr)
      <=> v4484(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_414,axiom,
    ! [VarCurr] :
      ( v4485(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6429,axiom,
    ~ b000000011100000001010110000(bitIndex26) ).

fof(bitBlastConstant_6428,axiom,
    ~ b000000011100000001010110000(bitIndex25) ).

fof(bitBlastConstant_6427,axiom,
    ~ b000000011100000001010110000(bitIndex24) ).

fof(bitBlastConstant_6426,axiom,
    ~ b000000011100000001010110000(bitIndex23) ).

fof(bitBlastConstant_6425,axiom,
    ~ b000000011100000001010110000(bitIndex22) ).

fof(bitBlastConstant_6424,axiom,
    ~ b000000011100000001010110000(bitIndex21) ).

fof(bitBlastConstant_6423,axiom,
    ~ b000000011100000001010110000(bitIndex20) ).

fof(bitBlastConstant_6422,axiom,
    b000000011100000001010110000(bitIndex19) ).

fof(bitBlastConstant_6421,axiom,
    b000000011100000001010110000(bitIndex18) ).

fof(bitBlastConstant_6420,axiom,
    b000000011100000001010110000(bitIndex17) ).

fof(bitBlastConstant_6419,axiom,
    ~ b000000011100000001010110000(bitIndex16) ).

fof(bitBlastConstant_6418,axiom,
    ~ b000000011100000001010110000(bitIndex15) ).

fof(bitBlastConstant_6417,axiom,
    ~ b000000011100000001010110000(bitIndex14) ).

fof(bitBlastConstant_6416,axiom,
    ~ b000000011100000001010110000(bitIndex13) ).

fof(bitBlastConstant_6415,axiom,
    ~ b000000011100000001010110000(bitIndex12) ).

fof(bitBlastConstant_6414,axiom,
    ~ b000000011100000001010110000(bitIndex11) ).

fof(bitBlastConstant_6413,axiom,
    ~ b000000011100000001010110000(bitIndex10) ).

fof(bitBlastConstant_6412,axiom,
    b000000011100000001010110000(bitIndex9) ).

fof(bitBlastConstant_6411,axiom,
    ~ b000000011100000001010110000(bitIndex8) ).

fof(bitBlastConstant_6410,axiom,
    b000000011100000001010110000(bitIndex7) ).

fof(bitBlastConstant_6409,axiom,
    ~ b000000011100000001010110000(bitIndex6) ).

fof(bitBlastConstant_6408,axiom,
    b000000011100000001010110000(bitIndex5) ).

fof(bitBlastConstant_6407,axiom,
    b000000011100000001010110000(bitIndex4) ).

fof(bitBlastConstant_6406,axiom,
    ~ b000000011100000001010110000(bitIndex3) ).

fof(bitBlastConstant_6405,axiom,
    ~ b000000011100000001010110000(bitIndex2) ).

fof(bitBlastConstant_6404,axiom,
    ~ b000000011100000001010110000(bitIndex1) ).

fof(bitBlastConstant_6403,axiom,
    ~ b000000011100000001010110000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_413,axiom,
    ! [VarCurr] :
      ( v4484(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6402,axiom,
    ~ b000000011000000001010110000(bitIndex26) ).

fof(bitBlastConstant_6401,axiom,
    ~ b000000011000000001010110000(bitIndex25) ).

fof(bitBlastConstant_6400,axiom,
    ~ b000000011000000001010110000(bitIndex24) ).

fof(bitBlastConstant_6399,axiom,
    ~ b000000011000000001010110000(bitIndex23) ).

fof(bitBlastConstant_6398,axiom,
    ~ b000000011000000001010110000(bitIndex22) ).

fof(bitBlastConstant_6397,axiom,
    ~ b000000011000000001010110000(bitIndex21) ).

fof(bitBlastConstant_6396,axiom,
    ~ b000000011000000001010110000(bitIndex20) ).

fof(bitBlastConstant_6395,axiom,
    b000000011000000001010110000(bitIndex19) ).

fof(bitBlastConstant_6394,axiom,
    b000000011000000001010110000(bitIndex18) ).

fof(bitBlastConstant_6393,axiom,
    ~ b000000011000000001010110000(bitIndex17) ).

fof(bitBlastConstant_6392,axiom,
    ~ b000000011000000001010110000(bitIndex16) ).

fof(bitBlastConstant_6391,axiom,
    ~ b000000011000000001010110000(bitIndex15) ).

fof(bitBlastConstant_6390,axiom,
    ~ b000000011000000001010110000(bitIndex14) ).

fof(bitBlastConstant_6389,axiom,
    ~ b000000011000000001010110000(bitIndex13) ).

fof(bitBlastConstant_6388,axiom,
    ~ b000000011000000001010110000(bitIndex12) ).

fof(bitBlastConstant_6387,axiom,
    ~ b000000011000000001010110000(bitIndex11) ).

fof(bitBlastConstant_6386,axiom,
    ~ b000000011000000001010110000(bitIndex10) ).

fof(bitBlastConstant_6385,axiom,
    b000000011000000001010110000(bitIndex9) ).

fof(bitBlastConstant_6384,axiom,
    ~ b000000011000000001010110000(bitIndex8) ).

fof(bitBlastConstant_6383,axiom,
    b000000011000000001010110000(bitIndex7) ).

fof(bitBlastConstant_6382,axiom,
    ~ b000000011000000001010110000(bitIndex6) ).

fof(bitBlastConstant_6381,axiom,
    b000000011000000001010110000(bitIndex5) ).

fof(bitBlastConstant_6380,axiom,
    b000000011000000001010110000(bitIndex4) ).

fof(bitBlastConstant_6379,axiom,
    ~ b000000011000000001010110000(bitIndex3) ).

fof(bitBlastConstant_6378,axiom,
    ~ b000000011000000001010110000(bitIndex2) ).

fof(bitBlastConstant_6377,axiom,
    ~ b000000011000000001010110000(bitIndex1) ).

fof(bitBlastConstant_6376,axiom,
    ~ b000000011000000001010110000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_190,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4471(VarCurr)
      <=> v4475(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_192,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4471(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_113,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4475(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_124,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4475(VarCurr)
      <=> v4477(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_124,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4475(VarCurr)
      <=> v4476(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_412,axiom,
    ! [VarCurr] :
      ( v4477(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6375,axiom,
    ~ b000000011100000001010101111(bitIndex26) ).

fof(bitBlastConstant_6374,axiom,
    ~ b000000011100000001010101111(bitIndex25) ).

fof(bitBlastConstant_6373,axiom,
    ~ b000000011100000001010101111(bitIndex24) ).

fof(bitBlastConstant_6372,axiom,
    ~ b000000011100000001010101111(bitIndex23) ).

fof(bitBlastConstant_6371,axiom,
    ~ b000000011100000001010101111(bitIndex22) ).

fof(bitBlastConstant_6370,axiom,
    ~ b000000011100000001010101111(bitIndex21) ).

fof(bitBlastConstant_6369,axiom,
    ~ b000000011100000001010101111(bitIndex20) ).

fof(bitBlastConstant_6368,axiom,
    b000000011100000001010101111(bitIndex19) ).

fof(bitBlastConstant_6367,axiom,
    b000000011100000001010101111(bitIndex18) ).

fof(bitBlastConstant_6366,axiom,
    b000000011100000001010101111(bitIndex17) ).

fof(bitBlastConstant_6365,axiom,
    ~ b000000011100000001010101111(bitIndex16) ).

fof(bitBlastConstant_6364,axiom,
    ~ b000000011100000001010101111(bitIndex15) ).

fof(bitBlastConstant_6363,axiom,
    ~ b000000011100000001010101111(bitIndex14) ).

fof(bitBlastConstant_6362,axiom,
    ~ b000000011100000001010101111(bitIndex13) ).

fof(bitBlastConstant_6361,axiom,
    ~ b000000011100000001010101111(bitIndex12) ).

fof(bitBlastConstant_6360,axiom,
    ~ b000000011100000001010101111(bitIndex11) ).

fof(bitBlastConstant_6359,axiom,
    ~ b000000011100000001010101111(bitIndex10) ).

fof(bitBlastConstant_6358,axiom,
    b000000011100000001010101111(bitIndex9) ).

fof(bitBlastConstant_6357,axiom,
    ~ b000000011100000001010101111(bitIndex8) ).

fof(bitBlastConstant_6356,axiom,
    b000000011100000001010101111(bitIndex7) ).

fof(bitBlastConstant_6355,axiom,
    ~ b000000011100000001010101111(bitIndex6) ).

fof(bitBlastConstant_6354,axiom,
    b000000011100000001010101111(bitIndex5) ).

fof(bitBlastConstant_6353,axiom,
    ~ b000000011100000001010101111(bitIndex4) ).

fof(bitBlastConstant_6352,axiom,
    b000000011100000001010101111(bitIndex3) ).

fof(bitBlastConstant_6351,axiom,
    b000000011100000001010101111(bitIndex2) ).

fof(bitBlastConstant_6350,axiom,
    b000000011100000001010101111(bitIndex1) ).

fof(bitBlastConstant_6349,axiom,
    b000000011100000001010101111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_411,axiom,
    ! [VarCurr] :
      ( v4476(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6348,axiom,
    ~ b000000011000000001010101111(bitIndex26) ).

fof(bitBlastConstant_6347,axiom,
    ~ b000000011000000001010101111(bitIndex25) ).

fof(bitBlastConstant_6346,axiom,
    ~ b000000011000000001010101111(bitIndex24) ).

fof(bitBlastConstant_6345,axiom,
    ~ b000000011000000001010101111(bitIndex23) ).

fof(bitBlastConstant_6344,axiom,
    ~ b000000011000000001010101111(bitIndex22) ).

fof(bitBlastConstant_6343,axiom,
    ~ b000000011000000001010101111(bitIndex21) ).

fof(bitBlastConstant_6342,axiom,
    ~ b000000011000000001010101111(bitIndex20) ).

fof(bitBlastConstant_6341,axiom,
    b000000011000000001010101111(bitIndex19) ).

fof(bitBlastConstant_6340,axiom,
    b000000011000000001010101111(bitIndex18) ).

fof(bitBlastConstant_6339,axiom,
    ~ b000000011000000001010101111(bitIndex17) ).

fof(bitBlastConstant_6338,axiom,
    ~ b000000011000000001010101111(bitIndex16) ).

fof(bitBlastConstant_6337,axiom,
    ~ b000000011000000001010101111(bitIndex15) ).

fof(bitBlastConstant_6336,axiom,
    ~ b000000011000000001010101111(bitIndex14) ).

fof(bitBlastConstant_6335,axiom,
    ~ b000000011000000001010101111(bitIndex13) ).

fof(bitBlastConstant_6334,axiom,
    ~ b000000011000000001010101111(bitIndex12) ).

fof(bitBlastConstant_6333,axiom,
    ~ b000000011000000001010101111(bitIndex11) ).

fof(bitBlastConstant_6332,axiom,
    ~ b000000011000000001010101111(bitIndex10) ).

fof(bitBlastConstant_6331,axiom,
    b000000011000000001010101111(bitIndex9) ).

fof(bitBlastConstant_6330,axiom,
    ~ b000000011000000001010101111(bitIndex8) ).

fof(bitBlastConstant_6329,axiom,
    b000000011000000001010101111(bitIndex7) ).

fof(bitBlastConstant_6328,axiom,
    ~ b000000011000000001010101111(bitIndex6) ).

fof(bitBlastConstant_6327,axiom,
    b000000011000000001010101111(bitIndex5) ).

fof(bitBlastConstant_6326,axiom,
    ~ b000000011000000001010101111(bitIndex4) ).

fof(bitBlastConstant_6325,axiom,
    b000000011000000001010101111(bitIndex3) ).

fof(bitBlastConstant_6324,axiom,
    b000000011000000001010101111(bitIndex2) ).

fof(bitBlastConstant_6323,axiom,
    b000000011000000001010101111(bitIndex1) ).

fof(bitBlastConstant_6322,axiom,
    b000000011000000001010101111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_189,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4463(VarCurr)
      <=> v4467(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_191,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4463(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_112,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4467(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_123,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4467(VarCurr)
      <=> v4469(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_123,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4467(VarCurr)
      <=> v4468(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_410,axiom,
    ! [VarCurr] :
      ( v4469(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6321,axiom,
    ~ b000000011100000001010101110(bitIndex26) ).

fof(bitBlastConstant_6320,axiom,
    ~ b000000011100000001010101110(bitIndex25) ).

fof(bitBlastConstant_6319,axiom,
    ~ b000000011100000001010101110(bitIndex24) ).

fof(bitBlastConstant_6318,axiom,
    ~ b000000011100000001010101110(bitIndex23) ).

fof(bitBlastConstant_6317,axiom,
    ~ b000000011100000001010101110(bitIndex22) ).

fof(bitBlastConstant_6316,axiom,
    ~ b000000011100000001010101110(bitIndex21) ).

fof(bitBlastConstant_6315,axiom,
    ~ b000000011100000001010101110(bitIndex20) ).

fof(bitBlastConstant_6314,axiom,
    b000000011100000001010101110(bitIndex19) ).

fof(bitBlastConstant_6313,axiom,
    b000000011100000001010101110(bitIndex18) ).

fof(bitBlastConstant_6312,axiom,
    b000000011100000001010101110(bitIndex17) ).

fof(bitBlastConstant_6311,axiom,
    ~ b000000011100000001010101110(bitIndex16) ).

fof(bitBlastConstant_6310,axiom,
    ~ b000000011100000001010101110(bitIndex15) ).

fof(bitBlastConstant_6309,axiom,
    ~ b000000011100000001010101110(bitIndex14) ).

fof(bitBlastConstant_6308,axiom,
    ~ b000000011100000001010101110(bitIndex13) ).

fof(bitBlastConstant_6307,axiom,
    ~ b000000011100000001010101110(bitIndex12) ).

fof(bitBlastConstant_6306,axiom,
    ~ b000000011100000001010101110(bitIndex11) ).

fof(bitBlastConstant_6305,axiom,
    ~ b000000011100000001010101110(bitIndex10) ).

fof(bitBlastConstant_6304,axiom,
    b000000011100000001010101110(bitIndex9) ).

fof(bitBlastConstant_6303,axiom,
    ~ b000000011100000001010101110(bitIndex8) ).

fof(bitBlastConstant_6302,axiom,
    b000000011100000001010101110(bitIndex7) ).

fof(bitBlastConstant_6301,axiom,
    ~ b000000011100000001010101110(bitIndex6) ).

fof(bitBlastConstant_6300,axiom,
    b000000011100000001010101110(bitIndex5) ).

fof(bitBlastConstant_6299,axiom,
    ~ b000000011100000001010101110(bitIndex4) ).

fof(bitBlastConstant_6298,axiom,
    b000000011100000001010101110(bitIndex3) ).

fof(bitBlastConstant_6297,axiom,
    b000000011100000001010101110(bitIndex2) ).

fof(bitBlastConstant_6296,axiom,
    b000000011100000001010101110(bitIndex1) ).

fof(bitBlastConstant_6295,axiom,
    ~ b000000011100000001010101110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_409,axiom,
    ! [VarCurr] :
      ( v4468(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6294,axiom,
    ~ b000000011000000001010101110(bitIndex26) ).

fof(bitBlastConstant_6293,axiom,
    ~ b000000011000000001010101110(bitIndex25) ).

fof(bitBlastConstant_6292,axiom,
    ~ b000000011000000001010101110(bitIndex24) ).

fof(bitBlastConstant_6291,axiom,
    ~ b000000011000000001010101110(bitIndex23) ).

fof(bitBlastConstant_6290,axiom,
    ~ b000000011000000001010101110(bitIndex22) ).

fof(bitBlastConstant_6289,axiom,
    ~ b000000011000000001010101110(bitIndex21) ).

fof(bitBlastConstant_6288,axiom,
    ~ b000000011000000001010101110(bitIndex20) ).

fof(bitBlastConstant_6287,axiom,
    b000000011000000001010101110(bitIndex19) ).

fof(bitBlastConstant_6286,axiom,
    b000000011000000001010101110(bitIndex18) ).

fof(bitBlastConstant_6285,axiom,
    ~ b000000011000000001010101110(bitIndex17) ).

fof(bitBlastConstant_6284,axiom,
    ~ b000000011000000001010101110(bitIndex16) ).

fof(bitBlastConstant_6283,axiom,
    ~ b000000011000000001010101110(bitIndex15) ).

fof(bitBlastConstant_6282,axiom,
    ~ b000000011000000001010101110(bitIndex14) ).

fof(bitBlastConstant_6281,axiom,
    ~ b000000011000000001010101110(bitIndex13) ).

fof(bitBlastConstant_6280,axiom,
    ~ b000000011000000001010101110(bitIndex12) ).

fof(bitBlastConstant_6279,axiom,
    ~ b000000011000000001010101110(bitIndex11) ).

fof(bitBlastConstant_6278,axiom,
    ~ b000000011000000001010101110(bitIndex10) ).

fof(bitBlastConstant_6277,axiom,
    b000000011000000001010101110(bitIndex9) ).

fof(bitBlastConstant_6276,axiom,
    ~ b000000011000000001010101110(bitIndex8) ).

fof(bitBlastConstant_6275,axiom,
    b000000011000000001010101110(bitIndex7) ).

fof(bitBlastConstant_6274,axiom,
    ~ b000000011000000001010101110(bitIndex6) ).

fof(bitBlastConstant_6273,axiom,
    b000000011000000001010101110(bitIndex5) ).

fof(bitBlastConstant_6272,axiom,
    ~ b000000011000000001010101110(bitIndex4) ).

fof(bitBlastConstant_6271,axiom,
    b000000011000000001010101110(bitIndex3) ).

fof(bitBlastConstant_6270,axiom,
    b000000011000000001010101110(bitIndex2) ).

fof(bitBlastConstant_6269,axiom,
    b000000011000000001010101110(bitIndex1) ).

fof(bitBlastConstant_6268,axiom,
    ~ b000000011000000001010101110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_188,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4455(VarCurr)
      <=> v4459(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_190,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4455(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_111,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4459(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_122,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4459(VarCurr)
      <=> v4461(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_122,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4459(VarCurr)
      <=> v4460(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_408,axiom,
    ! [VarCurr] :
      ( v4461(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6267,axiom,
    ~ b000000011100000001010101101(bitIndex26) ).

fof(bitBlastConstant_6266,axiom,
    ~ b000000011100000001010101101(bitIndex25) ).

fof(bitBlastConstant_6265,axiom,
    ~ b000000011100000001010101101(bitIndex24) ).

fof(bitBlastConstant_6264,axiom,
    ~ b000000011100000001010101101(bitIndex23) ).

fof(bitBlastConstant_6263,axiom,
    ~ b000000011100000001010101101(bitIndex22) ).

fof(bitBlastConstant_6262,axiom,
    ~ b000000011100000001010101101(bitIndex21) ).

fof(bitBlastConstant_6261,axiom,
    ~ b000000011100000001010101101(bitIndex20) ).

fof(bitBlastConstant_6260,axiom,
    b000000011100000001010101101(bitIndex19) ).

fof(bitBlastConstant_6259,axiom,
    b000000011100000001010101101(bitIndex18) ).

fof(bitBlastConstant_6258,axiom,
    b000000011100000001010101101(bitIndex17) ).

fof(bitBlastConstant_6257,axiom,
    ~ b000000011100000001010101101(bitIndex16) ).

fof(bitBlastConstant_6256,axiom,
    ~ b000000011100000001010101101(bitIndex15) ).

fof(bitBlastConstant_6255,axiom,
    ~ b000000011100000001010101101(bitIndex14) ).

fof(bitBlastConstant_6254,axiom,
    ~ b000000011100000001010101101(bitIndex13) ).

fof(bitBlastConstant_6253,axiom,
    ~ b000000011100000001010101101(bitIndex12) ).

fof(bitBlastConstant_6252,axiom,
    ~ b000000011100000001010101101(bitIndex11) ).

fof(bitBlastConstant_6251,axiom,
    ~ b000000011100000001010101101(bitIndex10) ).

fof(bitBlastConstant_6250,axiom,
    b000000011100000001010101101(bitIndex9) ).

fof(bitBlastConstant_6249,axiom,
    ~ b000000011100000001010101101(bitIndex8) ).

fof(bitBlastConstant_6248,axiom,
    b000000011100000001010101101(bitIndex7) ).

fof(bitBlastConstant_6247,axiom,
    ~ b000000011100000001010101101(bitIndex6) ).

fof(bitBlastConstant_6246,axiom,
    b000000011100000001010101101(bitIndex5) ).

fof(bitBlastConstant_6245,axiom,
    ~ b000000011100000001010101101(bitIndex4) ).

fof(bitBlastConstant_6244,axiom,
    b000000011100000001010101101(bitIndex3) ).

fof(bitBlastConstant_6243,axiom,
    b000000011100000001010101101(bitIndex2) ).

fof(bitBlastConstant_6242,axiom,
    ~ b000000011100000001010101101(bitIndex1) ).

fof(bitBlastConstant_6241,axiom,
    b000000011100000001010101101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_407,axiom,
    ! [VarCurr] :
      ( v4460(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6240,axiom,
    ~ b000000011000000001010101101(bitIndex26) ).

fof(bitBlastConstant_6239,axiom,
    ~ b000000011000000001010101101(bitIndex25) ).

fof(bitBlastConstant_6238,axiom,
    ~ b000000011000000001010101101(bitIndex24) ).

fof(bitBlastConstant_6237,axiom,
    ~ b000000011000000001010101101(bitIndex23) ).

fof(bitBlastConstant_6236,axiom,
    ~ b000000011000000001010101101(bitIndex22) ).

fof(bitBlastConstant_6235,axiom,
    ~ b000000011000000001010101101(bitIndex21) ).

fof(bitBlastConstant_6234,axiom,
    ~ b000000011000000001010101101(bitIndex20) ).

fof(bitBlastConstant_6233,axiom,
    b000000011000000001010101101(bitIndex19) ).

fof(bitBlastConstant_6232,axiom,
    b000000011000000001010101101(bitIndex18) ).

fof(bitBlastConstant_6231,axiom,
    ~ b000000011000000001010101101(bitIndex17) ).

fof(bitBlastConstant_6230,axiom,
    ~ b000000011000000001010101101(bitIndex16) ).

fof(bitBlastConstant_6229,axiom,
    ~ b000000011000000001010101101(bitIndex15) ).

fof(bitBlastConstant_6228,axiom,
    ~ b000000011000000001010101101(bitIndex14) ).

fof(bitBlastConstant_6227,axiom,
    ~ b000000011000000001010101101(bitIndex13) ).

fof(bitBlastConstant_6226,axiom,
    ~ b000000011000000001010101101(bitIndex12) ).

fof(bitBlastConstant_6225,axiom,
    ~ b000000011000000001010101101(bitIndex11) ).

fof(bitBlastConstant_6224,axiom,
    ~ b000000011000000001010101101(bitIndex10) ).

fof(bitBlastConstant_6223,axiom,
    b000000011000000001010101101(bitIndex9) ).

fof(bitBlastConstant_6222,axiom,
    ~ b000000011000000001010101101(bitIndex8) ).

fof(bitBlastConstant_6221,axiom,
    b000000011000000001010101101(bitIndex7) ).

fof(bitBlastConstant_6220,axiom,
    ~ b000000011000000001010101101(bitIndex6) ).

fof(bitBlastConstant_6219,axiom,
    b000000011000000001010101101(bitIndex5) ).

fof(bitBlastConstant_6218,axiom,
    ~ b000000011000000001010101101(bitIndex4) ).

fof(bitBlastConstant_6217,axiom,
    b000000011000000001010101101(bitIndex3) ).

fof(bitBlastConstant_6216,axiom,
    b000000011000000001010101101(bitIndex2) ).

fof(bitBlastConstant_6215,axiom,
    ~ b000000011000000001010101101(bitIndex1) ).

fof(bitBlastConstant_6214,axiom,
    b000000011000000001010101101(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_187,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4447(VarCurr)
      <=> v4451(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_189,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4447(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_110,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4451(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_121,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4451(VarCurr)
      <=> v4453(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_121,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4451(VarCurr)
      <=> v4452(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_406,axiom,
    ! [VarCurr] :
      ( v4453(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6213,axiom,
    ~ b000000011100000001010101100(bitIndex26) ).

fof(bitBlastConstant_6212,axiom,
    ~ b000000011100000001010101100(bitIndex25) ).

fof(bitBlastConstant_6211,axiom,
    ~ b000000011100000001010101100(bitIndex24) ).

fof(bitBlastConstant_6210,axiom,
    ~ b000000011100000001010101100(bitIndex23) ).

fof(bitBlastConstant_6209,axiom,
    ~ b000000011100000001010101100(bitIndex22) ).

fof(bitBlastConstant_6208,axiom,
    ~ b000000011100000001010101100(bitIndex21) ).

fof(bitBlastConstant_6207,axiom,
    ~ b000000011100000001010101100(bitIndex20) ).

fof(bitBlastConstant_6206,axiom,
    b000000011100000001010101100(bitIndex19) ).

fof(bitBlastConstant_6205,axiom,
    b000000011100000001010101100(bitIndex18) ).

fof(bitBlastConstant_6204,axiom,
    b000000011100000001010101100(bitIndex17) ).

fof(bitBlastConstant_6203,axiom,
    ~ b000000011100000001010101100(bitIndex16) ).

fof(bitBlastConstant_6202,axiom,
    ~ b000000011100000001010101100(bitIndex15) ).

fof(bitBlastConstant_6201,axiom,
    ~ b000000011100000001010101100(bitIndex14) ).

fof(bitBlastConstant_6200,axiom,
    ~ b000000011100000001010101100(bitIndex13) ).

fof(bitBlastConstant_6199,axiom,
    ~ b000000011100000001010101100(bitIndex12) ).

fof(bitBlastConstant_6198,axiom,
    ~ b000000011100000001010101100(bitIndex11) ).

fof(bitBlastConstant_6197,axiom,
    ~ b000000011100000001010101100(bitIndex10) ).

fof(bitBlastConstant_6196,axiom,
    b000000011100000001010101100(bitIndex9) ).

fof(bitBlastConstant_6195,axiom,
    ~ b000000011100000001010101100(bitIndex8) ).

fof(bitBlastConstant_6194,axiom,
    b000000011100000001010101100(bitIndex7) ).

fof(bitBlastConstant_6193,axiom,
    ~ b000000011100000001010101100(bitIndex6) ).

fof(bitBlastConstant_6192,axiom,
    b000000011100000001010101100(bitIndex5) ).

fof(bitBlastConstant_6191,axiom,
    ~ b000000011100000001010101100(bitIndex4) ).

fof(bitBlastConstant_6190,axiom,
    b000000011100000001010101100(bitIndex3) ).

fof(bitBlastConstant_6189,axiom,
    b000000011100000001010101100(bitIndex2) ).

fof(bitBlastConstant_6188,axiom,
    ~ b000000011100000001010101100(bitIndex1) ).

fof(bitBlastConstant_6187,axiom,
    ~ b000000011100000001010101100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_405,axiom,
    ! [VarCurr] :
      ( v4452(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6186,axiom,
    ~ b000000011000000001010101100(bitIndex26) ).

fof(bitBlastConstant_6185,axiom,
    ~ b000000011000000001010101100(bitIndex25) ).

fof(bitBlastConstant_6184,axiom,
    ~ b000000011000000001010101100(bitIndex24) ).

fof(bitBlastConstant_6183,axiom,
    ~ b000000011000000001010101100(bitIndex23) ).

fof(bitBlastConstant_6182,axiom,
    ~ b000000011000000001010101100(bitIndex22) ).

fof(bitBlastConstant_6181,axiom,
    ~ b000000011000000001010101100(bitIndex21) ).

fof(bitBlastConstant_6180,axiom,
    ~ b000000011000000001010101100(bitIndex20) ).

fof(bitBlastConstant_6179,axiom,
    b000000011000000001010101100(bitIndex19) ).

fof(bitBlastConstant_6178,axiom,
    b000000011000000001010101100(bitIndex18) ).

fof(bitBlastConstant_6177,axiom,
    ~ b000000011000000001010101100(bitIndex17) ).

fof(bitBlastConstant_6176,axiom,
    ~ b000000011000000001010101100(bitIndex16) ).

fof(bitBlastConstant_6175,axiom,
    ~ b000000011000000001010101100(bitIndex15) ).

fof(bitBlastConstant_6174,axiom,
    ~ b000000011000000001010101100(bitIndex14) ).

fof(bitBlastConstant_6173,axiom,
    ~ b000000011000000001010101100(bitIndex13) ).

fof(bitBlastConstant_6172,axiom,
    ~ b000000011000000001010101100(bitIndex12) ).

fof(bitBlastConstant_6171,axiom,
    ~ b000000011000000001010101100(bitIndex11) ).

fof(bitBlastConstant_6170,axiom,
    ~ b000000011000000001010101100(bitIndex10) ).

fof(bitBlastConstant_6169,axiom,
    b000000011000000001010101100(bitIndex9) ).

fof(bitBlastConstant_6168,axiom,
    ~ b000000011000000001010101100(bitIndex8) ).

fof(bitBlastConstant_6167,axiom,
    b000000011000000001010101100(bitIndex7) ).

fof(bitBlastConstant_6166,axiom,
    ~ b000000011000000001010101100(bitIndex6) ).

fof(bitBlastConstant_6165,axiom,
    b000000011000000001010101100(bitIndex5) ).

fof(bitBlastConstant_6164,axiom,
    ~ b000000011000000001010101100(bitIndex4) ).

fof(bitBlastConstant_6163,axiom,
    b000000011000000001010101100(bitIndex3) ).

fof(bitBlastConstant_6162,axiom,
    b000000011000000001010101100(bitIndex2) ).

fof(bitBlastConstant_6161,axiom,
    ~ b000000011000000001010101100(bitIndex1) ).

fof(bitBlastConstant_6160,axiom,
    ~ b000000011000000001010101100(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_186,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4439(VarCurr)
      <=> v4443(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_188,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4439(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_109,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4443(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_120,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4443(VarCurr)
      <=> v4445(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_120,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4443(VarCurr)
      <=> v4444(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_404,axiom,
    ! [VarCurr] :
      ( v4445(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6159,axiom,
    ~ b000000011100000001010101011(bitIndex26) ).

fof(bitBlastConstant_6158,axiom,
    ~ b000000011100000001010101011(bitIndex25) ).

fof(bitBlastConstant_6157,axiom,
    ~ b000000011100000001010101011(bitIndex24) ).

fof(bitBlastConstant_6156,axiom,
    ~ b000000011100000001010101011(bitIndex23) ).

fof(bitBlastConstant_6155,axiom,
    ~ b000000011100000001010101011(bitIndex22) ).

fof(bitBlastConstant_6154,axiom,
    ~ b000000011100000001010101011(bitIndex21) ).

fof(bitBlastConstant_6153,axiom,
    ~ b000000011100000001010101011(bitIndex20) ).

fof(bitBlastConstant_6152,axiom,
    b000000011100000001010101011(bitIndex19) ).

fof(bitBlastConstant_6151,axiom,
    b000000011100000001010101011(bitIndex18) ).

fof(bitBlastConstant_6150,axiom,
    b000000011100000001010101011(bitIndex17) ).

fof(bitBlastConstant_6149,axiom,
    ~ b000000011100000001010101011(bitIndex16) ).

fof(bitBlastConstant_6148,axiom,
    ~ b000000011100000001010101011(bitIndex15) ).

fof(bitBlastConstant_6147,axiom,
    ~ b000000011100000001010101011(bitIndex14) ).

fof(bitBlastConstant_6146,axiom,
    ~ b000000011100000001010101011(bitIndex13) ).

fof(bitBlastConstant_6145,axiom,
    ~ b000000011100000001010101011(bitIndex12) ).

fof(bitBlastConstant_6144,axiom,
    ~ b000000011100000001010101011(bitIndex11) ).

fof(bitBlastConstant_6143,axiom,
    ~ b000000011100000001010101011(bitIndex10) ).

fof(bitBlastConstant_6142,axiom,
    b000000011100000001010101011(bitIndex9) ).

fof(bitBlastConstant_6141,axiom,
    ~ b000000011100000001010101011(bitIndex8) ).

fof(bitBlastConstant_6140,axiom,
    b000000011100000001010101011(bitIndex7) ).

fof(bitBlastConstant_6139,axiom,
    ~ b000000011100000001010101011(bitIndex6) ).

fof(bitBlastConstant_6138,axiom,
    b000000011100000001010101011(bitIndex5) ).

fof(bitBlastConstant_6137,axiom,
    ~ b000000011100000001010101011(bitIndex4) ).

fof(bitBlastConstant_6136,axiom,
    b000000011100000001010101011(bitIndex3) ).

fof(bitBlastConstant_6135,axiom,
    ~ b000000011100000001010101011(bitIndex2) ).

fof(bitBlastConstant_6134,axiom,
    b000000011100000001010101011(bitIndex1) ).

fof(bitBlastConstant_6133,axiom,
    b000000011100000001010101011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_403,axiom,
    ! [VarCurr] :
      ( v4444(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6132,axiom,
    ~ b000000011000000001010101011(bitIndex26) ).

fof(bitBlastConstant_6131,axiom,
    ~ b000000011000000001010101011(bitIndex25) ).

fof(bitBlastConstant_6130,axiom,
    ~ b000000011000000001010101011(bitIndex24) ).

fof(bitBlastConstant_6129,axiom,
    ~ b000000011000000001010101011(bitIndex23) ).

fof(bitBlastConstant_6128,axiom,
    ~ b000000011000000001010101011(bitIndex22) ).

fof(bitBlastConstant_6127,axiom,
    ~ b000000011000000001010101011(bitIndex21) ).

fof(bitBlastConstant_6126,axiom,
    ~ b000000011000000001010101011(bitIndex20) ).

fof(bitBlastConstant_6125,axiom,
    b000000011000000001010101011(bitIndex19) ).

fof(bitBlastConstant_6124,axiom,
    b000000011000000001010101011(bitIndex18) ).

fof(bitBlastConstant_6123,axiom,
    ~ b000000011000000001010101011(bitIndex17) ).

fof(bitBlastConstant_6122,axiom,
    ~ b000000011000000001010101011(bitIndex16) ).

fof(bitBlastConstant_6121,axiom,
    ~ b000000011000000001010101011(bitIndex15) ).

fof(bitBlastConstant_6120,axiom,
    ~ b000000011000000001010101011(bitIndex14) ).

fof(bitBlastConstant_6119,axiom,
    ~ b000000011000000001010101011(bitIndex13) ).

fof(bitBlastConstant_6118,axiom,
    ~ b000000011000000001010101011(bitIndex12) ).

fof(bitBlastConstant_6117,axiom,
    ~ b000000011000000001010101011(bitIndex11) ).

fof(bitBlastConstant_6116,axiom,
    ~ b000000011000000001010101011(bitIndex10) ).

fof(bitBlastConstant_6115,axiom,
    b000000011000000001010101011(bitIndex9) ).

fof(bitBlastConstant_6114,axiom,
    ~ b000000011000000001010101011(bitIndex8) ).

fof(bitBlastConstant_6113,axiom,
    b000000011000000001010101011(bitIndex7) ).

fof(bitBlastConstant_6112,axiom,
    ~ b000000011000000001010101011(bitIndex6) ).

fof(bitBlastConstant_6111,axiom,
    b000000011000000001010101011(bitIndex5) ).

fof(bitBlastConstant_6110,axiom,
    ~ b000000011000000001010101011(bitIndex4) ).

fof(bitBlastConstant_6109,axiom,
    b000000011000000001010101011(bitIndex3) ).

fof(bitBlastConstant_6108,axiom,
    ~ b000000011000000001010101011(bitIndex2) ).

fof(bitBlastConstant_6107,axiom,
    b000000011000000001010101011(bitIndex1) ).

fof(bitBlastConstant_6106,axiom,
    b000000011000000001010101011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_185,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4431(VarCurr)
      <=> v4435(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_187,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4431(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_108,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4435(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_119,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4435(VarCurr)
      <=> v4437(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_119,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4435(VarCurr)
      <=> v4436(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_402,axiom,
    ! [VarCurr] :
      ( v4437(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6105,axiom,
    ~ b000000011100000001010101010(bitIndex26) ).

fof(bitBlastConstant_6104,axiom,
    ~ b000000011100000001010101010(bitIndex25) ).

fof(bitBlastConstant_6103,axiom,
    ~ b000000011100000001010101010(bitIndex24) ).

fof(bitBlastConstant_6102,axiom,
    ~ b000000011100000001010101010(bitIndex23) ).

fof(bitBlastConstant_6101,axiom,
    ~ b000000011100000001010101010(bitIndex22) ).

fof(bitBlastConstant_6100,axiom,
    ~ b000000011100000001010101010(bitIndex21) ).

fof(bitBlastConstant_6099,axiom,
    ~ b000000011100000001010101010(bitIndex20) ).

fof(bitBlastConstant_6098,axiom,
    b000000011100000001010101010(bitIndex19) ).

fof(bitBlastConstant_6097,axiom,
    b000000011100000001010101010(bitIndex18) ).

fof(bitBlastConstant_6096,axiom,
    b000000011100000001010101010(bitIndex17) ).

fof(bitBlastConstant_6095,axiom,
    ~ b000000011100000001010101010(bitIndex16) ).

fof(bitBlastConstant_6094,axiom,
    ~ b000000011100000001010101010(bitIndex15) ).

fof(bitBlastConstant_6093,axiom,
    ~ b000000011100000001010101010(bitIndex14) ).

fof(bitBlastConstant_6092,axiom,
    ~ b000000011100000001010101010(bitIndex13) ).

fof(bitBlastConstant_6091,axiom,
    ~ b000000011100000001010101010(bitIndex12) ).

fof(bitBlastConstant_6090,axiom,
    ~ b000000011100000001010101010(bitIndex11) ).

fof(bitBlastConstant_6089,axiom,
    ~ b000000011100000001010101010(bitIndex10) ).

fof(bitBlastConstant_6088,axiom,
    b000000011100000001010101010(bitIndex9) ).

fof(bitBlastConstant_6087,axiom,
    ~ b000000011100000001010101010(bitIndex8) ).

fof(bitBlastConstant_6086,axiom,
    b000000011100000001010101010(bitIndex7) ).

fof(bitBlastConstant_6085,axiom,
    ~ b000000011100000001010101010(bitIndex6) ).

fof(bitBlastConstant_6084,axiom,
    b000000011100000001010101010(bitIndex5) ).

fof(bitBlastConstant_6083,axiom,
    ~ b000000011100000001010101010(bitIndex4) ).

fof(bitBlastConstant_6082,axiom,
    b000000011100000001010101010(bitIndex3) ).

fof(bitBlastConstant_6081,axiom,
    ~ b000000011100000001010101010(bitIndex2) ).

fof(bitBlastConstant_6080,axiom,
    b000000011100000001010101010(bitIndex1) ).

fof(bitBlastConstant_6079,axiom,
    ~ b000000011100000001010101010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_401,axiom,
    ! [VarCurr] :
      ( v4436(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_6078,axiom,
    ~ b000000011000000001010101010(bitIndex26) ).

fof(bitBlastConstant_6077,axiom,
    ~ b000000011000000001010101010(bitIndex25) ).

fof(bitBlastConstant_6076,axiom,
    ~ b000000011000000001010101010(bitIndex24) ).

fof(bitBlastConstant_6075,axiom,
    ~ b000000011000000001010101010(bitIndex23) ).

fof(bitBlastConstant_6074,axiom,
    ~ b000000011000000001010101010(bitIndex22) ).

fof(bitBlastConstant_6073,axiom,
    ~ b000000011000000001010101010(bitIndex21) ).

fof(bitBlastConstant_6072,axiom,
    ~ b000000011000000001010101010(bitIndex20) ).

fof(bitBlastConstant_6071,axiom,
    b000000011000000001010101010(bitIndex19) ).

fof(bitBlastConstant_6070,axiom,
    b000000011000000001010101010(bitIndex18) ).

fof(bitBlastConstant_6069,axiom,
    ~ b000000011000000001010101010(bitIndex17) ).

fof(bitBlastConstant_6068,axiom,
    ~ b000000011000000001010101010(bitIndex16) ).

fof(bitBlastConstant_6067,axiom,
    ~ b000000011000000001010101010(bitIndex15) ).

fof(bitBlastConstant_6066,axiom,
    ~ b000000011000000001010101010(bitIndex14) ).

fof(bitBlastConstant_6065,axiom,
    ~ b000000011000000001010101010(bitIndex13) ).

fof(bitBlastConstant_6064,axiom,
    ~ b000000011000000001010101010(bitIndex12) ).

fof(bitBlastConstant_6063,axiom,
    ~ b000000011000000001010101010(bitIndex11) ).

fof(bitBlastConstant_6062,axiom,
    ~ b000000011000000001010101010(bitIndex10) ).

fof(bitBlastConstant_6061,axiom,
    b000000011000000001010101010(bitIndex9) ).

fof(bitBlastConstant_6060,axiom,
    ~ b000000011000000001010101010(bitIndex8) ).

fof(bitBlastConstant_6059,axiom,
    b000000011000000001010101010(bitIndex7) ).

fof(bitBlastConstant_6058,axiom,
    ~ b000000011000000001010101010(bitIndex6) ).

fof(bitBlastConstant_6057,axiom,
    b000000011000000001010101010(bitIndex5) ).

fof(bitBlastConstant_6056,axiom,
    ~ b000000011000000001010101010(bitIndex4) ).

fof(bitBlastConstant_6055,axiom,
    b000000011000000001010101010(bitIndex3) ).

fof(bitBlastConstant_6054,axiom,
    ~ b000000011000000001010101010(bitIndex2) ).

fof(bitBlastConstant_6053,axiom,
    b000000011000000001010101010(bitIndex1) ).

fof(bitBlastConstant_6052,axiom,
    ~ b000000011000000001010101010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_184,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4423(VarCurr)
      <=> v4427(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_186,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4423(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_107,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4427(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_118,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4427(VarCurr)
      <=> v4429(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_118,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4427(VarCurr)
      <=> v4428(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_400,axiom,
    ! [VarCurr] :
      ( v4429(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6051,axiom,
    ~ b000000011100000001010101001(bitIndex26) ).

fof(bitBlastConstant_6050,axiom,
    ~ b000000011100000001010101001(bitIndex25) ).

fof(bitBlastConstant_6049,axiom,
    ~ b000000011100000001010101001(bitIndex24) ).

fof(bitBlastConstant_6048,axiom,
    ~ b000000011100000001010101001(bitIndex23) ).

fof(bitBlastConstant_6047,axiom,
    ~ b000000011100000001010101001(bitIndex22) ).

fof(bitBlastConstant_6046,axiom,
    ~ b000000011100000001010101001(bitIndex21) ).

fof(bitBlastConstant_6045,axiom,
    ~ b000000011100000001010101001(bitIndex20) ).

fof(bitBlastConstant_6044,axiom,
    b000000011100000001010101001(bitIndex19) ).

fof(bitBlastConstant_6043,axiom,
    b000000011100000001010101001(bitIndex18) ).

fof(bitBlastConstant_6042,axiom,
    b000000011100000001010101001(bitIndex17) ).

fof(bitBlastConstant_6041,axiom,
    ~ b000000011100000001010101001(bitIndex16) ).

fof(bitBlastConstant_6040,axiom,
    ~ b000000011100000001010101001(bitIndex15) ).

fof(bitBlastConstant_6039,axiom,
    ~ b000000011100000001010101001(bitIndex14) ).

fof(bitBlastConstant_6038,axiom,
    ~ b000000011100000001010101001(bitIndex13) ).

fof(bitBlastConstant_6037,axiom,
    ~ b000000011100000001010101001(bitIndex12) ).

fof(bitBlastConstant_6036,axiom,
    ~ b000000011100000001010101001(bitIndex11) ).

fof(bitBlastConstant_6035,axiom,
    ~ b000000011100000001010101001(bitIndex10) ).

fof(bitBlastConstant_6034,axiom,
    b000000011100000001010101001(bitIndex9) ).

fof(bitBlastConstant_6033,axiom,
    ~ b000000011100000001010101001(bitIndex8) ).

fof(bitBlastConstant_6032,axiom,
    b000000011100000001010101001(bitIndex7) ).

fof(bitBlastConstant_6031,axiom,
    ~ b000000011100000001010101001(bitIndex6) ).

fof(bitBlastConstant_6030,axiom,
    b000000011100000001010101001(bitIndex5) ).

fof(bitBlastConstant_6029,axiom,
    ~ b000000011100000001010101001(bitIndex4) ).

fof(bitBlastConstant_6028,axiom,
    b000000011100000001010101001(bitIndex3) ).

fof(bitBlastConstant_6027,axiom,
    ~ b000000011100000001010101001(bitIndex2) ).

fof(bitBlastConstant_6026,axiom,
    ~ b000000011100000001010101001(bitIndex1) ).

fof(bitBlastConstant_6025,axiom,
    b000000011100000001010101001(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_399,axiom,
    ! [VarCurr] :
      ( v4428(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_6024,axiom,
    ~ b000000011000000001010101001(bitIndex26) ).

fof(bitBlastConstant_6023,axiom,
    ~ b000000011000000001010101001(bitIndex25) ).

fof(bitBlastConstant_6022,axiom,
    ~ b000000011000000001010101001(bitIndex24) ).

fof(bitBlastConstant_6021,axiom,
    ~ b000000011000000001010101001(bitIndex23) ).

fof(bitBlastConstant_6020,axiom,
    ~ b000000011000000001010101001(bitIndex22) ).

fof(bitBlastConstant_6019,axiom,
    ~ b000000011000000001010101001(bitIndex21) ).

fof(bitBlastConstant_6018,axiom,
    ~ b000000011000000001010101001(bitIndex20) ).

fof(bitBlastConstant_6017,axiom,
    b000000011000000001010101001(bitIndex19) ).

fof(bitBlastConstant_6016,axiom,
    b000000011000000001010101001(bitIndex18) ).

fof(bitBlastConstant_6015,axiom,
    ~ b000000011000000001010101001(bitIndex17) ).

fof(bitBlastConstant_6014,axiom,
    ~ b000000011000000001010101001(bitIndex16) ).

fof(bitBlastConstant_6013,axiom,
    ~ b000000011000000001010101001(bitIndex15) ).

fof(bitBlastConstant_6012,axiom,
    ~ b000000011000000001010101001(bitIndex14) ).

fof(bitBlastConstant_6011,axiom,
    ~ b000000011000000001010101001(bitIndex13) ).

fof(bitBlastConstant_6010,axiom,
    ~ b000000011000000001010101001(bitIndex12) ).

fof(bitBlastConstant_6009,axiom,
    ~ b000000011000000001010101001(bitIndex11) ).

fof(bitBlastConstant_6008,axiom,
    ~ b000000011000000001010101001(bitIndex10) ).

fof(bitBlastConstant_6007,axiom,
    b000000011000000001010101001(bitIndex9) ).

fof(bitBlastConstant_6006,axiom,
    ~ b000000011000000001010101001(bitIndex8) ).

fof(bitBlastConstant_6005,axiom,
    b000000011000000001010101001(bitIndex7) ).

fof(bitBlastConstant_6004,axiom,
    ~ b000000011000000001010101001(bitIndex6) ).

fof(bitBlastConstant_6003,axiom,
    b000000011000000001010101001(bitIndex5) ).

fof(bitBlastConstant_6002,axiom,
    ~ b000000011000000001010101001(bitIndex4) ).

fof(bitBlastConstant_6001,axiom,
    b000000011000000001010101001(bitIndex3) ).

fof(bitBlastConstant_6000,axiom,
    ~ b000000011000000001010101001(bitIndex2) ).

fof(bitBlastConstant_5999,axiom,
    ~ b000000011000000001010101001(bitIndex1) ).

fof(bitBlastConstant_5998,axiom,
    b000000011000000001010101001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_183,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4415(VarCurr)
      <=> v4419(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_185,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4415(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_106,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4419(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_117,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4419(VarCurr)
      <=> v4421(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_117,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4419(VarCurr)
      <=> v4420(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_398,axiom,
    ! [VarCurr] :
      ( v4421(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5997,axiom,
    ~ b000000011100000001010101000(bitIndex26) ).

fof(bitBlastConstant_5996,axiom,
    ~ b000000011100000001010101000(bitIndex25) ).

fof(bitBlastConstant_5995,axiom,
    ~ b000000011100000001010101000(bitIndex24) ).

fof(bitBlastConstant_5994,axiom,
    ~ b000000011100000001010101000(bitIndex23) ).

fof(bitBlastConstant_5993,axiom,
    ~ b000000011100000001010101000(bitIndex22) ).

fof(bitBlastConstant_5992,axiom,
    ~ b000000011100000001010101000(bitIndex21) ).

fof(bitBlastConstant_5991,axiom,
    ~ b000000011100000001010101000(bitIndex20) ).

fof(bitBlastConstant_5990,axiom,
    b000000011100000001010101000(bitIndex19) ).

fof(bitBlastConstant_5989,axiom,
    b000000011100000001010101000(bitIndex18) ).

fof(bitBlastConstant_5988,axiom,
    b000000011100000001010101000(bitIndex17) ).

fof(bitBlastConstant_5987,axiom,
    ~ b000000011100000001010101000(bitIndex16) ).

fof(bitBlastConstant_5986,axiom,
    ~ b000000011100000001010101000(bitIndex15) ).

fof(bitBlastConstant_5985,axiom,
    ~ b000000011100000001010101000(bitIndex14) ).

fof(bitBlastConstant_5984,axiom,
    ~ b000000011100000001010101000(bitIndex13) ).

fof(bitBlastConstant_5983,axiom,
    ~ b000000011100000001010101000(bitIndex12) ).

fof(bitBlastConstant_5982,axiom,
    ~ b000000011100000001010101000(bitIndex11) ).

fof(bitBlastConstant_5981,axiom,
    ~ b000000011100000001010101000(bitIndex10) ).

fof(bitBlastConstant_5980,axiom,
    b000000011100000001010101000(bitIndex9) ).

fof(bitBlastConstant_5979,axiom,
    ~ b000000011100000001010101000(bitIndex8) ).

fof(bitBlastConstant_5978,axiom,
    b000000011100000001010101000(bitIndex7) ).

fof(bitBlastConstant_5977,axiom,
    ~ b000000011100000001010101000(bitIndex6) ).

fof(bitBlastConstant_5976,axiom,
    b000000011100000001010101000(bitIndex5) ).

fof(bitBlastConstant_5975,axiom,
    ~ b000000011100000001010101000(bitIndex4) ).

fof(bitBlastConstant_5974,axiom,
    b000000011100000001010101000(bitIndex3) ).

fof(bitBlastConstant_5973,axiom,
    ~ b000000011100000001010101000(bitIndex2) ).

fof(bitBlastConstant_5972,axiom,
    ~ b000000011100000001010101000(bitIndex1) ).

fof(bitBlastConstant_5971,axiom,
    ~ b000000011100000001010101000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_397,axiom,
    ! [VarCurr] :
      ( v4420(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5970,axiom,
    ~ b000000011000000001010101000(bitIndex26) ).

fof(bitBlastConstant_5969,axiom,
    ~ b000000011000000001010101000(bitIndex25) ).

fof(bitBlastConstant_5968,axiom,
    ~ b000000011000000001010101000(bitIndex24) ).

fof(bitBlastConstant_5967,axiom,
    ~ b000000011000000001010101000(bitIndex23) ).

fof(bitBlastConstant_5966,axiom,
    ~ b000000011000000001010101000(bitIndex22) ).

fof(bitBlastConstant_5965,axiom,
    ~ b000000011000000001010101000(bitIndex21) ).

fof(bitBlastConstant_5964,axiom,
    ~ b000000011000000001010101000(bitIndex20) ).

fof(bitBlastConstant_5963,axiom,
    b000000011000000001010101000(bitIndex19) ).

fof(bitBlastConstant_5962,axiom,
    b000000011000000001010101000(bitIndex18) ).

fof(bitBlastConstant_5961,axiom,
    ~ b000000011000000001010101000(bitIndex17) ).

fof(bitBlastConstant_5960,axiom,
    ~ b000000011000000001010101000(bitIndex16) ).

fof(bitBlastConstant_5959,axiom,
    ~ b000000011000000001010101000(bitIndex15) ).

fof(bitBlastConstant_5958,axiom,
    ~ b000000011000000001010101000(bitIndex14) ).

fof(bitBlastConstant_5957,axiom,
    ~ b000000011000000001010101000(bitIndex13) ).

fof(bitBlastConstant_5956,axiom,
    ~ b000000011000000001010101000(bitIndex12) ).

fof(bitBlastConstant_5955,axiom,
    ~ b000000011000000001010101000(bitIndex11) ).

fof(bitBlastConstant_5954,axiom,
    ~ b000000011000000001010101000(bitIndex10) ).

fof(bitBlastConstant_5953,axiom,
    b000000011000000001010101000(bitIndex9) ).

fof(bitBlastConstant_5952,axiom,
    ~ b000000011000000001010101000(bitIndex8) ).

fof(bitBlastConstant_5951,axiom,
    b000000011000000001010101000(bitIndex7) ).

fof(bitBlastConstant_5950,axiom,
    ~ b000000011000000001010101000(bitIndex6) ).

fof(bitBlastConstant_5949,axiom,
    b000000011000000001010101000(bitIndex5) ).

fof(bitBlastConstant_5948,axiom,
    ~ b000000011000000001010101000(bitIndex4) ).

fof(bitBlastConstant_5947,axiom,
    b000000011000000001010101000(bitIndex3) ).

fof(bitBlastConstant_5946,axiom,
    ~ b000000011000000001010101000(bitIndex2) ).

fof(bitBlastConstant_5945,axiom,
    ~ b000000011000000001010101000(bitIndex1) ).

fof(bitBlastConstant_5944,axiom,
    ~ b000000011000000001010101000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_182,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4407(VarCurr)
      <=> v4411(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_184,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4407(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_105,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4411(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_116,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4411(VarCurr)
      <=> v4413(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_116,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4411(VarCurr)
      <=> v4412(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_396,axiom,
    ! [VarCurr] :
      ( v4413(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5943,axiom,
    ~ b000000011100000001010100111(bitIndex26) ).

fof(bitBlastConstant_5942,axiom,
    ~ b000000011100000001010100111(bitIndex25) ).

fof(bitBlastConstant_5941,axiom,
    ~ b000000011100000001010100111(bitIndex24) ).

fof(bitBlastConstant_5940,axiom,
    ~ b000000011100000001010100111(bitIndex23) ).

fof(bitBlastConstant_5939,axiom,
    ~ b000000011100000001010100111(bitIndex22) ).

fof(bitBlastConstant_5938,axiom,
    ~ b000000011100000001010100111(bitIndex21) ).

fof(bitBlastConstant_5937,axiom,
    ~ b000000011100000001010100111(bitIndex20) ).

fof(bitBlastConstant_5936,axiom,
    b000000011100000001010100111(bitIndex19) ).

fof(bitBlastConstant_5935,axiom,
    b000000011100000001010100111(bitIndex18) ).

fof(bitBlastConstant_5934,axiom,
    b000000011100000001010100111(bitIndex17) ).

fof(bitBlastConstant_5933,axiom,
    ~ b000000011100000001010100111(bitIndex16) ).

fof(bitBlastConstant_5932,axiom,
    ~ b000000011100000001010100111(bitIndex15) ).

fof(bitBlastConstant_5931,axiom,
    ~ b000000011100000001010100111(bitIndex14) ).

fof(bitBlastConstant_5930,axiom,
    ~ b000000011100000001010100111(bitIndex13) ).

fof(bitBlastConstant_5929,axiom,
    ~ b000000011100000001010100111(bitIndex12) ).

fof(bitBlastConstant_5928,axiom,
    ~ b000000011100000001010100111(bitIndex11) ).

fof(bitBlastConstant_5927,axiom,
    ~ b000000011100000001010100111(bitIndex10) ).

fof(bitBlastConstant_5926,axiom,
    b000000011100000001010100111(bitIndex9) ).

fof(bitBlastConstant_5925,axiom,
    ~ b000000011100000001010100111(bitIndex8) ).

fof(bitBlastConstant_5924,axiom,
    b000000011100000001010100111(bitIndex7) ).

fof(bitBlastConstant_5923,axiom,
    ~ b000000011100000001010100111(bitIndex6) ).

fof(bitBlastConstant_5922,axiom,
    b000000011100000001010100111(bitIndex5) ).

fof(bitBlastConstant_5921,axiom,
    ~ b000000011100000001010100111(bitIndex4) ).

fof(bitBlastConstant_5920,axiom,
    ~ b000000011100000001010100111(bitIndex3) ).

fof(bitBlastConstant_5919,axiom,
    b000000011100000001010100111(bitIndex2) ).

fof(bitBlastConstant_5918,axiom,
    b000000011100000001010100111(bitIndex1) ).

fof(bitBlastConstant_5917,axiom,
    b000000011100000001010100111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_395,axiom,
    ! [VarCurr] :
      ( v4412(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5916,axiom,
    ~ b000000011000000001010100111(bitIndex26) ).

fof(bitBlastConstant_5915,axiom,
    ~ b000000011000000001010100111(bitIndex25) ).

fof(bitBlastConstant_5914,axiom,
    ~ b000000011000000001010100111(bitIndex24) ).

fof(bitBlastConstant_5913,axiom,
    ~ b000000011000000001010100111(bitIndex23) ).

fof(bitBlastConstant_5912,axiom,
    ~ b000000011000000001010100111(bitIndex22) ).

fof(bitBlastConstant_5911,axiom,
    ~ b000000011000000001010100111(bitIndex21) ).

fof(bitBlastConstant_5910,axiom,
    ~ b000000011000000001010100111(bitIndex20) ).

fof(bitBlastConstant_5909,axiom,
    b000000011000000001010100111(bitIndex19) ).

fof(bitBlastConstant_5908,axiom,
    b000000011000000001010100111(bitIndex18) ).

fof(bitBlastConstant_5907,axiom,
    ~ b000000011000000001010100111(bitIndex17) ).

fof(bitBlastConstant_5906,axiom,
    ~ b000000011000000001010100111(bitIndex16) ).

fof(bitBlastConstant_5905,axiom,
    ~ b000000011000000001010100111(bitIndex15) ).

fof(bitBlastConstant_5904,axiom,
    ~ b000000011000000001010100111(bitIndex14) ).

fof(bitBlastConstant_5903,axiom,
    ~ b000000011000000001010100111(bitIndex13) ).

fof(bitBlastConstant_5902,axiom,
    ~ b000000011000000001010100111(bitIndex12) ).

fof(bitBlastConstant_5901,axiom,
    ~ b000000011000000001010100111(bitIndex11) ).

fof(bitBlastConstant_5900,axiom,
    ~ b000000011000000001010100111(bitIndex10) ).

fof(bitBlastConstant_5899,axiom,
    b000000011000000001010100111(bitIndex9) ).

fof(bitBlastConstant_5898,axiom,
    ~ b000000011000000001010100111(bitIndex8) ).

fof(bitBlastConstant_5897,axiom,
    b000000011000000001010100111(bitIndex7) ).

fof(bitBlastConstant_5896,axiom,
    ~ b000000011000000001010100111(bitIndex6) ).

fof(bitBlastConstant_5895,axiom,
    b000000011000000001010100111(bitIndex5) ).

fof(bitBlastConstant_5894,axiom,
    ~ b000000011000000001010100111(bitIndex4) ).

fof(bitBlastConstant_5893,axiom,
    ~ b000000011000000001010100111(bitIndex3) ).

fof(bitBlastConstant_5892,axiom,
    b000000011000000001010100111(bitIndex2) ).

fof(bitBlastConstant_5891,axiom,
    b000000011000000001010100111(bitIndex1) ).

fof(bitBlastConstant_5890,axiom,
    b000000011000000001010100111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_181,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4399(VarCurr)
      <=> v4403(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_183,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4399(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_104,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4403(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_115,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4403(VarCurr)
      <=> v4405(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_115,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4403(VarCurr)
      <=> v4404(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_394,axiom,
    ! [VarCurr] :
      ( v4405(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5889,axiom,
    ~ b000000011100000001010100110(bitIndex26) ).

fof(bitBlastConstant_5888,axiom,
    ~ b000000011100000001010100110(bitIndex25) ).

fof(bitBlastConstant_5887,axiom,
    ~ b000000011100000001010100110(bitIndex24) ).

fof(bitBlastConstant_5886,axiom,
    ~ b000000011100000001010100110(bitIndex23) ).

fof(bitBlastConstant_5885,axiom,
    ~ b000000011100000001010100110(bitIndex22) ).

fof(bitBlastConstant_5884,axiom,
    ~ b000000011100000001010100110(bitIndex21) ).

fof(bitBlastConstant_5883,axiom,
    ~ b000000011100000001010100110(bitIndex20) ).

fof(bitBlastConstant_5882,axiom,
    b000000011100000001010100110(bitIndex19) ).

fof(bitBlastConstant_5881,axiom,
    b000000011100000001010100110(bitIndex18) ).

fof(bitBlastConstant_5880,axiom,
    b000000011100000001010100110(bitIndex17) ).

fof(bitBlastConstant_5879,axiom,
    ~ b000000011100000001010100110(bitIndex16) ).

fof(bitBlastConstant_5878,axiom,
    ~ b000000011100000001010100110(bitIndex15) ).

fof(bitBlastConstant_5877,axiom,
    ~ b000000011100000001010100110(bitIndex14) ).

fof(bitBlastConstant_5876,axiom,
    ~ b000000011100000001010100110(bitIndex13) ).

fof(bitBlastConstant_5875,axiom,
    ~ b000000011100000001010100110(bitIndex12) ).

fof(bitBlastConstant_5874,axiom,
    ~ b000000011100000001010100110(bitIndex11) ).

fof(bitBlastConstant_5873,axiom,
    ~ b000000011100000001010100110(bitIndex10) ).

fof(bitBlastConstant_5872,axiom,
    b000000011100000001010100110(bitIndex9) ).

fof(bitBlastConstant_5871,axiom,
    ~ b000000011100000001010100110(bitIndex8) ).

fof(bitBlastConstant_5870,axiom,
    b000000011100000001010100110(bitIndex7) ).

fof(bitBlastConstant_5869,axiom,
    ~ b000000011100000001010100110(bitIndex6) ).

fof(bitBlastConstant_5868,axiom,
    b000000011100000001010100110(bitIndex5) ).

fof(bitBlastConstant_5867,axiom,
    ~ b000000011100000001010100110(bitIndex4) ).

fof(bitBlastConstant_5866,axiom,
    ~ b000000011100000001010100110(bitIndex3) ).

fof(bitBlastConstant_5865,axiom,
    b000000011100000001010100110(bitIndex2) ).

fof(bitBlastConstant_5864,axiom,
    b000000011100000001010100110(bitIndex1) ).

fof(bitBlastConstant_5863,axiom,
    ~ b000000011100000001010100110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_393,axiom,
    ! [VarCurr] :
      ( v4404(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5862,axiom,
    ~ b000000011000000001010100110(bitIndex26) ).

fof(bitBlastConstant_5861,axiom,
    ~ b000000011000000001010100110(bitIndex25) ).

fof(bitBlastConstant_5860,axiom,
    ~ b000000011000000001010100110(bitIndex24) ).

fof(bitBlastConstant_5859,axiom,
    ~ b000000011000000001010100110(bitIndex23) ).

fof(bitBlastConstant_5858,axiom,
    ~ b000000011000000001010100110(bitIndex22) ).

fof(bitBlastConstant_5857,axiom,
    ~ b000000011000000001010100110(bitIndex21) ).

fof(bitBlastConstant_5856,axiom,
    ~ b000000011000000001010100110(bitIndex20) ).

fof(bitBlastConstant_5855,axiom,
    b000000011000000001010100110(bitIndex19) ).

fof(bitBlastConstant_5854,axiom,
    b000000011000000001010100110(bitIndex18) ).

fof(bitBlastConstant_5853,axiom,
    ~ b000000011000000001010100110(bitIndex17) ).

fof(bitBlastConstant_5852,axiom,
    ~ b000000011000000001010100110(bitIndex16) ).

fof(bitBlastConstant_5851,axiom,
    ~ b000000011000000001010100110(bitIndex15) ).

fof(bitBlastConstant_5850,axiom,
    ~ b000000011000000001010100110(bitIndex14) ).

fof(bitBlastConstant_5849,axiom,
    ~ b000000011000000001010100110(bitIndex13) ).

fof(bitBlastConstant_5848,axiom,
    ~ b000000011000000001010100110(bitIndex12) ).

fof(bitBlastConstant_5847,axiom,
    ~ b000000011000000001010100110(bitIndex11) ).

fof(bitBlastConstant_5846,axiom,
    ~ b000000011000000001010100110(bitIndex10) ).

fof(bitBlastConstant_5845,axiom,
    b000000011000000001010100110(bitIndex9) ).

fof(bitBlastConstant_5844,axiom,
    ~ b000000011000000001010100110(bitIndex8) ).

fof(bitBlastConstant_5843,axiom,
    b000000011000000001010100110(bitIndex7) ).

fof(bitBlastConstant_5842,axiom,
    ~ b000000011000000001010100110(bitIndex6) ).

fof(bitBlastConstant_5841,axiom,
    b000000011000000001010100110(bitIndex5) ).

fof(bitBlastConstant_5840,axiom,
    ~ b000000011000000001010100110(bitIndex4) ).

fof(bitBlastConstant_5839,axiom,
    ~ b000000011000000001010100110(bitIndex3) ).

fof(bitBlastConstant_5838,axiom,
    b000000011000000001010100110(bitIndex2) ).

fof(bitBlastConstant_5837,axiom,
    b000000011000000001010100110(bitIndex1) ).

fof(bitBlastConstant_5836,axiom,
    ~ b000000011000000001010100110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_180,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4391(VarCurr)
      <=> v4395(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_182,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4391(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_103,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4395(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_114,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4395(VarCurr)
      <=> v4397(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_114,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4395(VarCurr)
      <=> v4396(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_392,axiom,
    ! [VarCurr] :
      ( v4397(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5835,axiom,
    ~ b000000011100000001010100101(bitIndex26) ).

fof(bitBlastConstant_5834,axiom,
    ~ b000000011100000001010100101(bitIndex25) ).

fof(bitBlastConstant_5833,axiom,
    ~ b000000011100000001010100101(bitIndex24) ).

fof(bitBlastConstant_5832,axiom,
    ~ b000000011100000001010100101(bitIndex23) ).

fof(bitBlastConstant_5831,axiom,
    ~ b000000011100000001010100101(bitIndex22) ).

fof(bitBlastConstant_5830,axiom,
    ~ b000000011100000001010100101(bitIndex21) ).

fof(bitBlastConstant_5829,axiom,
    ~ b000000011100000001010100101(bitIndex20) ).

fof(bitBlastConstant_5828,axiom,
    b000000011100000001010100101(bitIndex19) ).

fof(bitBlastConstant_5827,axiom,
    b000000011100000001010100101(bitIndex18) ).

fof(bitBlastConstant_5826,axiom,
    b000000011100000001010100101(bitIndex17) ).

fof(bitBlastConstant_5825,axiom,
    ~ b000000011100000001010100101(bitIndex16) ).

fof(bitBlastConstant_5824,axiom,
    ~ b000000011100000001010100101(bitIndex15) ).

fof(bitBlastConstant_5823,axiom,
    ~ b000000011100000001010100101(bitIndex14) ).

fof(bitBlastConstant_5822,axiom,
    ~ b000000011100000001010100101(bitIndex13) ).

fof(bitBlastConstant_5821,axiom,
    ~ b000000011100000001010100101(bitIndex12) ).

fof(bitBlastConstant_5820,axiom,
    ~ b000000011100000001010100101(bitIndex11) ).

fof(bitBlastConstant_5819,axiom,
    ~ b000000011100000001010100101(bitIndex10) ).

fof(bitBlastConstant_5818,axiom,
    b000000011100000001010100101(bitIndex9) ).

fof(bitBlastConstant_5817,axiom,
    ~ b000000011100000001010100101(bitIndex8) ).

fof(bitBlastConstant_5816,axiom,
    b000000011100000001010100101(bitIndex7) ).

fof(bitBlastConstant_5815,axiom,
    ~ b000000011100000001010100101(bitIndex6) ).

fof(bitBlastConstant_5814,axiom,
    b000000011100000001010100101(bitIndex5) ).

fof(bitBlastConstant_5813,axiom,
    ~ b000000011100000001010100101(bitIndex4) ).

fof(bitBlastConstant_5812,axiom,
    ~ b000000011100000001010100101(bitIndex3) ).

fof(bitBlastConstant_5811,axiom,
    b000000011100000001010100101(bitIndex2) ).

fof(bitBlastConstant_5810,axiom,
    ~ b000000011100000001010100101(bitIndex1) ).

fof(bitBlastConstant_5809,axiom,
    b000000011100000001010100101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_391,axiom,
    ! [VarCurr] :
      ( v4396(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5808,axiom,
    ~ b000000011000000001010100101(bitIndex26) ).

fof(bitBlastConstant_5807,axiom,
    ~ b000000011000000001010100101(bitIndex25) ).

fof(bitBlastConstant_5806,axiom,
    ~ b000000011000000001010100101(bitIndex24) ).

fof(bitBlastConstant_5805,axiom,
    ~ b000000011000000001010100101(bitIndex23) ).

fof(bitBlastConstant_5804,axiom,
    ~ b000000011000000001010100101(bitIndex22) ).

fof(bitBlastConstant_5803,axiom,
    ~ b000000011000000001010100101(bitIndex21) ).

fof(bitBlastConstant_5802,axiom,
    ~ b000000011000000001010100101(bitIndex20) ).

fof(bitBlastConstant_5801,axiom,
    b000000011000000001010100101(bitIndex19) ).

fof(bitBlastConstant_5800,axiom,
    b000000011000000001010100101(bitIndex18) ).

fof(bitBlastConstant_5799,axiom,
    ~ b000000011000000001010100101(bitIndex17) ).

fof(bitBlastConstant_5798,axiom,
    ~ b000000011000000001010100101(bitIndex16) ).

fof(bitBlastConstant_5797,axiom,
    ~ b000000011000000001010100101(bitIndex15) ).

fof(bitBlastConstant_5796,axiom,
    ~ b000000011000000001010100101(bitIndex14) ).

fof(bitBlastConstant_5795,axiom,
    ~ b000000011000000001010100101(bitIndex13) ).

fof(bitBlastConstant_5794,axiom,
    ~ b000000011000000001010100101(bitIndex12) ).

fof(bitBlastConstant_5793,axiom,
    ~ b000000011000000001010100101(bitIndex11) ).

fof(bitBlastConstant_5792,axiom,
    ~ b000000011000000001010100101(bitIndex10) ).

fof(bitBlastConstant_5791,axiom,
    b000000011000000001010100101(bitIndex9) ).

fof(bitBlastConstant_5790,axiom,
    ~ b000000011000000001010100101(bitIndex8) ).

fof(bitBlastConstant_5789,axiom,
    b000000011000000001010100101(bitIndex7) ).

fof(bitBlastConstant_5788,axiom,
    ~ b000000011000000001010100101(bitIndex6) ).

fof(bitBlastConstant_5787,axiom,
    b000000011000000001010100101(bitIndex5) ).

fof(bitBlastConstant_5786,axiom,
    ~ b000000011000000001010100101(bitIndex4) ).

fof(bitBlastConstant_5785,axiom,
    ~ b000000011000000001010100101(bitIndex3) ).

fof(bitBlastConstant_5784,axiom,
    b000000011000000001010100101(bitIndex2) ).

fof(bitBlastConstant_5783,axiom,
    ~ b000000011000000001010100101(bitIndex1) ).

fof(bitBlastConstant_5782,axiom,
    b000000011000000001010100101(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_179,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4383(VarCurr)
      <=> v4387(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_181,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4383(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_102,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4387(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_113,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4387(VarCurr)
      <=> v4389(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_113,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4387(VarCurr)
      <=> v4388(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_390,axiom,
    ! [VarCurr] :
      ( v4389(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5781,axiom,
    ~ b000000011100000001010100100(bitIndex26) ).

fof(bitBlastConstant_5780,axiom,
    ~ b000000011100000001010100100(bitIndex25) ).

fof(bitBlastConstant_5779,axiom,
    ~ b000000011100000001010100100(bitIndex24) ).

fof(bitBlastConstant_5778,axiom,
    ~ b000000011100000001010100100(bitIndex23) ).

fof(bitBlastConstant_5777,axiom,
    ~ b000000011100000001010100100(bitIndex22) ).

fof(bitBlastConstant_5776,axiom,
    ~ b000000011100000001010100100(bitIndex21) ).

fof(bitBlastConstant_5775,axiom,
    ~ b000000011100000001010100100(bitIndex20) ).

fof(bitBlastConstant_5774,axiom,
    b000000011100000001010100100(bitIndex19) ).

fof(bitBlastConstant_5773,axiom,
    b000000011100000001010100100(bitIndex18) ).

fof(bitBlastConstant_5772,axiom,
    b000000011100000001010100100(bitIndex17) ).

fof(bitBlastConstant_5771,axiom,
    ~ b000000011100000001010100100(bitIndex16) ).

fof(bitBlastConstant_5770,axiom,
    ~ b000000011100000001010100100(bitIndex15) ).

fof(bitBlastConstant_5769,axiom,
    ~ b000000011100000001010100100(bitIndex14) ).

fof(bitBlastConstant_5768,axiom,
    ~ b000000011100000001010100100(bitIndex13) ).

fof(bitBlastConstant_5767,axiom,
    ~ b000000011100000001010100100(bitIndex12) ).

fof(bitBlastConstant_5766,axiom,
    ~ b000000011100000001010100100(bitIndex11) ).

fof(bitBlastConstant_5765,axiom,
    ~ b000000011100000001010100100(bitIndex10) ).

fof(bitBlastConstant_5764,axiom,
    b000000011100000001010100100(bitIndex9) ).

fof(bitBlastConstant_5763,axiom,
    ~ b000000011100000001010100100(bitIndex8) ).

fof(bitBlastConstant_5762,axiom,
    b000000011100000001010100100(bitIndex7) ).

fof(bitBlastConstant_5761,axiom,
    ~ b000000011100000001010100100(bitIndex6) ).

fof(bitBlastConstant_5760,axiom,
    b000000011100000001010100100(bitIndex5) ).

fof(bitBlastConstant_5759,axiom,
    ~ b000000011100000001010100100(bitIndex4) ).

fof(bitBlastConstant_5758,axiom,
    ~ b000000011100000001010100100(bitIndex3) ).

fof(bitBlastConstant_5757,axiom,
    b000000011100000001010100100(bitIndex2) ).

fof(bitBlastConstant_5756,axiom,
    ~ b000000011100000001010100100(bitIndex1) ).

fof(bitBlastConstant_5755,axiom,
    ~ b000000011100000001010100100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_389,axiom,
    ! [VarCurr] :
      ( v4388(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5754,axiom,
    ~ b000000011000000001010100100(bitIndex26) ).

fof(bitBlastConstant_5753,axiom,
    ~ b000000011000000001010100100(bitIndex25) ).

fof(bitBlastConstant_5752,axiom,
    ~ b000000011000000001010100100(bitIndex24) ).

fof(bitBlastConstant_5751,axiom,
    ~ b000000011000000001010100100(bitIndex23) ).

fof(bitBlastConstant_5750,axiom,
    ~ b000000011000000001010100100(bitIndex22) ).

fof(bitBlastConstant_5749,axiom,
    ~ b000000011000000001010100100(bitIndex21) ).

fof(bitBlastConstant_5748,axiom,
    ~ b000000011000000001010100100(bitIndex20) ).

fof(bitBlastConstant_5747,axiom,
    b000000011000000001010100100(bitIndex19) ).

fof(bitBlastConstant_5746,axiom,
    b000000011000000001010100100(bitIndex18) ).

fof(bitBlastConstant_5745,axiom,
    ~ b000000011000000001010100100(bitIndex17) ).

fof(bitBlastConstant_5744,axiom,
    ~ b000000011000000001010100100(bitIndex16) ).

fof(bitBlastConstant_5743,axiom,
    ~ b000000011000000001010100100(bitIndex15) ).

fof(bitBlastConstant_5742,axiom,
    ~ b000000011000000001010100100(bitIndex14) ).

fof(bitBlastConstant_5741,axiom,
    ~ b000000011000000001010100100(bitIndex13) ).

fof(bitBlastConstant_5740,axiom,
    ~ b000000011000000001010100100(bitIndex12) ).

fof(bitBlastConstant_5739,axiom,
    ~ b000000011000000001010100100(bitIndex11) ).

fof(bitBlastConstant_5738,axiom,
    ~ b000000011000000001010100100(bitIndex10) ).

fof(bitBlastConstant_5737,axiom,
    b000000011000000001010100100(bitIndex9) ).

fof(bitBlastConstant_5736,axiom,
    ~ b000000011000000001010100100(bitIndex8) ).

fof(bitBlastConstant_5735,axiom,
    b000000011000000001010100100(bitIndex7) ).

fof(bitBlastConstant_5734,axiom,
    ~ b000000011000000001010100100(bitIndex6) ).

fof(bitBlastConstant_5733,axiom,
    b000000011000000001010100100(bitIndex5) ).

fof(bitBlastConstant_5732,axiom,
    ~ b000000011000000001010100100(bitIndex4) ).

fof(bitBlastConstant_5731,axiom,
    ~ b000000011000000001010100100(bitIndex3) ).

fof(bitBlastConstant_5730,axiom,
    b000000011000000001010100100(bitIndex2) ).

fof(bitBlastConstant_5729,axiom,
    ~ b000000011000000001010100100(bitIndex1) ).

fof(bitBlastConstant_5728,axiom,
    ~ b000000011000000001010100100(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_178,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4375(VarCurr)
      <=> v4379(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_180,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4375(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_101,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4379(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_112,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4379(VarCurr)
      <=> v4381(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_112,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4379(VarCurr)
      <=> v4380(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_388,axiom,
    ! [VarCurr] :
      ( v4381(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5727,axiom,
    ~ b000000011100000001010100011(bitIndex26) ).

fof(bitBlastConstant_5726,axiom,
    ~ b000000011100000001010100011(bitIndex25) ).

fof(bitBlastConstant_5725,axiom,
    ~ b000000011100000001010100011(bitIndex24) ).

fof(bitBlastConstant_5724,axiom,
    ~ b000000011100000001010100011(bitIndex23) ).

fof(bitBlastConstant_5723,axiom,
    ~ b000000011100000001010100011(bitIndex22) ).

fof(bitBlastConstant_5722,axiom,
    ~ b000000011100000001010100011(bitIndex21) ).

fof(bitBlastConstant_5721,axiom,
    ~ b000000011100000001010100011(bitIndex20) ).

fof(bitBlastConstant_5720,axiom,
    b000000011100000001010100011(bitIndex19) ).

fof(bitBlastConstant_5719,axiom,
    b000000011100000001010100011(bitIndex18) ).

fof(bitBlastConstant_5718,axiom,
    b000000011100000001010100011(bitIndex17) ).

fof(bitBlastConstant_5717,axiom,
    ~ b000000011100000001010100011(bitIndex16) ).

fof(bitBlastConstant_5716,axiom,
    ~ b000000011100000001010100011(bitIndex15) ).

fof(bitBlastConstant_5715,axiom,
    ~ b000000011100000001010100011(bitIndex14) ).

fof(bitBlastConstant_5714,axiom,
    ~ b000000011100000001010100011(bitIndex13) ).

fof(bitBlastConstant_5713,axiom,
    ~ b000000011100000001010100011(bitIndex12) ).

fof(bitBlastConstant_5712,axiom,
    ~ b000000011100000001010100011(bitIndex11) ).

fof(bitBlastConstant_5711,axiom,
    ~ b000000011100000001010100011(bitIndex10) ).

fof(bitBlastConstant_5710,axiom,
    b000000011100000001010100011(bitIndex9) ).

fof(bitBlastConstant_5709,axiom,
    ~ b000000011100000001010100011(bitIndex8) ).

fof(bitBlastConstant_5708,axiom,
    b000000011100000001010100011(bitIndex7) ).

fof(bitBlastConstant_5707,axiom,
    ~ b000000011100000001010100011(bitIndex6) ).

fof(bitBlastConstant_5706,axiom,
    b000000011100000001010100011(bitIndex5) ).

fof(bitBlastConstant_5705,axiom,
    ~ b000000011100000001010100011(bitIndex4) ).

fof(bitBlastConstant_5704,axiom,
    ~ b000000011100000001010100011(bitIndex3) ).

fof(bitBlastConstant_5703,axiom,
    ~ b000000011100000001010100011(bitIndex2) ).

fof(bitBlastConstant_5702,axiom,
    b000000011100000001010100011(bitIndex1) ).

fof(bitBlastConstant_5701,axiom,
    b000000011100000001010100011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_387,axiom,
    ! [VarCurr] :
      ( v4380(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5700,axiom,
    ~ b000000011000000001010100011(bitIndex26) ).

fof(bitBlastConstant_5699,axiom,
    ~ b000000011000000001010100011(bitIndex25) ).

fof(bitBlastConstant_5698,axiom,
    ~ b000000011000000001010100011(bitIndex24) ).

fof(bitBlastConstant_5697,axiom,
    ~ b000000011000000001010100011(bitIndex23) ).

fof(bitBlastConstant_5696,axiom,
    ~ b000000011000000001010100011(bitIndex22) ).

fof(bitBlastConstant_5695,axiom,
    ~ b000000011000000001010100011(bitIndex21) ).

fof(bitBlastConstant_5694,axiom,
    ~ b000000011000000001010100011(bitIndex20) ).

fof(bitBlastConstant_5693,axiom,
    b000000011000000001010100011(bitIndex19) ).

fof(bitBlastConstant_5692,axiom,
    b000000011000000001010100011(bitIndex18) ).

fof(bitBlastConstant_5691,axiom,
    ~ b000000011000000001010100011(bitIndex17) ).

fof(bitBlastConstant_5690,axiom,
    ~ b000000011000000001010100011(bitIndex16) ).

fof(bitBlastConstant_5689,axiom,
    ~ b000000011000000001010100011(bitIndex15) ).

fof(bitBlastConstant_5688,axiom,
    ~ b000000011000000001010100011(bitIndex14) ).

fof(bitBlastConstant_5687,axiom,
    ~ b000000011000000001010100011(bitIndex13) ).

fof(bitBlastConstant_5686,axiom,
    ~ b000000011000000001010100011(bitIndex12) ).

fof(bitBlastConstant_5685,axiom,
    ~ b000000011000000001010100011(bitIndex11) ).

fof(bitBlastConstant_5684,axiom,
    ~ b000000011000000001010100011(bitIndex10) ).

fof(bitBlastConstant_5683,axiom,
    b000000011000000001010100011(bitIndex9) ).

fof(bitBlastConstant_5682,axiom,
    ~ b000000011000000001010100011(bitIndex8) ).

fof(bitBlastConstant_5681,axiom,
    b000000011000000001010100011(bitIndex7) ).

fof(bitBlastConstant_5680,axiom,
    ~ b000000011000000001010100011(bitIndex6) ).

fof(bitBlastConstant_5679,axiom,
    b000000011000000001010100011(bitIndex5) ).

fof(bitBlastConstant_5678,axiom,
    ~ b000000011000000001010100011(bitIndex4) ).

fof(bitBlastConstant_5677,axiom,
    ~ b000000011000000001010100011(bitIndex3) ).

fof(bitBlastConstant_5676,axiom,
    ~ b000000011000000001010100011(bitIndex2) ).

fof(bitBlastConstant_5675,axiom,
    b000000011000000001010100011(bitIndex1) ).

fof(bitBlastConstant_5674,axiom,
    b000000011000000001010100011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_177,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4367(VarCurr)
      <=> v4371(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_179,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4367(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_100,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4371(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_111,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4371(VarCurr)
      <=> v4373(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_111,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4371(VarCurr)
      <=> v4372(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_386,axiom,
    ! [VarCurr] :
      ( v4373(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5673,axiom,
    ~ b000000011100000001010100010(bitIndex26) ).

fof(bitBlastConstant_5672,axiom,
    ~ b000000011100000001010100010(bitIndex25) ).

fof(bitBlastConstant_5671,axiom,
    ~ b000000011100000001010100010(bitIndex24) ).

fof(bitBlastConstant_5670,axiom,
    ~ b000000011100000001010100010(bitIndex23) ).

fof(bitBlastConstant_5669,axiom,
    ~ b000000011100000001010100010(bitIndex22) ).

fof(bitBlastConstant_5668,axiom,
    ~ b000000011100000001010100010(bitIndex21) ).

fof(bitBlastConstant_5667,axiom,
    ~ b000000011100000001010100010(bitIndex20) ).

fof(bitBlastConstant_5666,axiom,
    b000000011100000001010100010(bitIndex19) ).

fof(bitBlastConstant_5665,axiom,
    b000000011100000001010100010(bitIndex18) ).

fof(bitBlastConstant_5664,axiom,
    b000000011100000001010100010(bitIndex17) ).

fof(bitBlastConstant_5663,axiom,
    ~ b000000011100000001010100010(bitIndex16) ).

fof(bitBlastConstant_5662,axiom,
    ~ b000000011100000001010100010(bitIndex15) ).

fof(bitBlastConstant_5661,axiom,
    ~ b000000011100000001010100010(bitIndex14) ).

fof(bitBlastConstant_5660,axiom,
    ~ b000000011100000001010100010(bitIndex13) ).

fof(bitBlastConstant_5659,axiom,
    ~ b000000011100000001010100010(bitIndex12) ).

fof(bitBlastConstant_5658,axiom,
    ~ b000000011100000001010100010(bitIndex11) ).

fof(bitBlastConstant_5657,axiom,
    ~ b000000011100000001010100010(bitIndex10) ).

fof(bitBlastConstant_5656,axiom,
    b000000011100000001010100010(bitIndex9) ).

fof(bitBlastConstant_5655,axiom,
    ~ b000000011100000001010100010(bitIndex8) ).

fof(bitBlastConstant_5654,axiom,
    b000000011100000001010100010(bitIndex7) ).

fof(bitBlastConstant_5653,axiom,
    ~ b000000011100000001010100010(bitIndex6) ).

fof(bitBlastConstant_5652,axiom,
    b000000011100000001010100010(bitIndex5) ).

fof(bitBlastConstant_5651,axiom,
    ~ b000000011100000001010100010(bitIndex4) ).

fof(bitBlastConstant_5650,axiom,
    ~ b000000011100000001010100010(bitIndex3) ).

fof(bitBlastConstant_5649,axiom,
    ~ b000000011100000001010100010(bitIndex2) ).

fof(bitBlastConstant_5648,axiom,
    b000000011100000001010100010(bitIndex1) ).

fof(bitBlastConstant_5647,axiom,
    ~ b000000011100000001010100010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_385,axiom,
    ! [VarCurr] :
      ( v4372(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5646,axiom,
    ~ b000000011000000001010100010(bitIndex26) ).

fof(bitBlastConstant_5645,axiom,
    ~ b000000011000000001010100010(bitIndex25) ).

fof(bitBlastConstant_5644,axiom,
    ~ b000000011000000001010100010(bitIndex24) ).

fof(bitBlastConstant_5643,axiom,
    ~ b000000011000000001010100010(bitIndex23) ).

fof(bitBlastConstant_5642,axiom,
    ~ b000000011000000001010100010(bitIndex22) ).

fof(bitBlastConstant_5641,axiom,
    ~ b000000011000000001010100010(bitIndex21) ).

fof(bitBlastConstant_5640,axiom,
    ~ b000000011000000001010100010(bitIndex20) ).

fof(bitBlastConstant_5639,axiom,
    b000000011000000001010100010(bitIndex19) ).

fof(bitBlastConstant_5638,axiom,
    b000000011000000001010100010(bitIndex18) ).

fof(bitBlastConstant_5637,axiom,
    ~ b000000011000000001010100010(bitIndex17) ).

fof(bitBlastConstant_5636,axiom,
    ~ b000000011000000001010100010(bitIndex16) ).

fof(bitBlastConstant_5635,axiom,
    ~ b000000011000000001010100010(bitIndex15) ).

fof(bitBlastConstant_5634,axiom,
    ~ b000000011000000001010100010(bitIndex14) ).

fof(bitBlastConstant_5633,axiom,
    ~ b000000011000000001010100010(bitIndex13) ).

fof(bitBlastConstant_5632,axiom,
    ~ b000000011000000001010100010(bitIndex12) ).

fof(bitBlastConstant_5631,axiom,
    ~ b000000011000000001010100010(bitIndex11) ).

fof(bitBlastConstant_5630,axiom,
    ~ b000000011000000001010100010(bitIndex10) ).

fof(bitBlastConstant_5629,axiom,
    b000000011000000001010100010(bitIndex9) ).

fof(bitBlastConstant_5628,axiom,
    ~ b000000011000000001010100010(bitIndex8) ).

fof(bitBlastConstant_5627,axiom,
    b000000011000000001010100010(bitIndex7) ).

fof(bitBlastConstant_5626,axiom,
    ~ b000000011000000001010100010(bitIndex6) ).

fof(bitBlastConstant_5625,axiom,
    b000000011000000001010100010(bitIndex5) ).

fof(bitBlastConstant_5624,axiom,
    ~ b000000011000000001010100010(bitIndex4) ).

fof(bitBlastConstant_5623,axiom,
    ~ b000000011000000001010100010(bitIndex3) ).

fof(bitBlastConstant_5622,axiom,
    ~ b000000011000000001010100010(bitIndex2) ).

fof(bitBlastConstant_5621,axiom,
    b000000011000000001010100010(bitIndex1) ).

fof(bitBlastConstant_5620,axiom,
    ~ b000000011000000001010100010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_176,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4359(VarCurr)
      <=> v4363(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_178,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4359(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_99,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4363(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_110,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4363(VarCurr)
      <=> v4365(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_110,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4363(VarCurr)
      <=> v4364(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_384,axiom,
    ! [VarCurr] :
      ( v4365(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5619,axiom,
    ~ b000000011100000001010100001(bitIndex26) ).

fof(bitBlastConstant_5618,axiom,
    ~ b000000011100000001010100001(bitIndex25) ).

fof(bitBlastConstant_5617,axiom,
    ~ b000000011100000001010100001(bitIndex24) ).

fof(bitBlastConstant_5616,axiom,
    ~ b000000011100000001010100001(bitIndex23) ).

fof(bitBlastConstant_5615,axiom,
    ~ b000000011100000001010100001(bitIndex22) ).

fof(bitBlastConstant_5614,axiom,
    ~ b000000011100000001010100001(bitIndex21) ).

fof(bitBlastConstant_5613,axiom,
    ~ b000000011100000001010100001(bitIndex20) ).

fof(bitBlastConstant_5612,axiom,
    b000000011100000001010100001(bitIndex19) ).

fof(bitBlastConstant_5611,axiom,
    b000000011100000001010100001(bitIndex18) ).

fof(bitBlastConstant_5610,axiom,
    b000000011100000001010100001(bitIndex17) ).

fof(bitBlastConstant_5609,axiom,
    ~ b000000011100000001010100001(bitIndex16) ).

fof(bitBlastConstant_5608,axiom,
    ~ b000000011100000001010100001(bitIndex15) ).

fof(bitBlastConstant_5607,axiom,
    ~ b000000011100000001010100001(bitIndex14) ).

fof(bitBlastConstant_5606,axiom,
    ~ b000000011100000001010100001(bitIndex13) ).

fof(bitBlastConstant_5605,axiom,
    ~ b000000011100000001010100001(bitIndex12) ).

fof(bitBlastConstant_5604,axiom,
    ~ b000000011100000001010100001(bitIndex11) ).

fof(bitBlastConstant_5603,axiom,
    ~ b000000011100000001010100001(bitIndex10) ).

fof(bitBlastConstant_5602,axiom,
    b000000011100000001010100001(bitIndex9) ).

fof(bitBlastConstant_5601,axiom,
    ~ b000000011100000001010100001(bitIndex8) ).

fof(bitBlastConstant_5600,axiom,
    b000000011100000001010100001(bitIndex7) ).

fof(bitBlastConstant_5599,axiom,
    ~ b000000011100000001010100001(bitIndex6) ).

fof(bitBlastConstant_5598,axiom,
    b000000011100000001010100001(bitIndex5) ).

fof(bitBlastConstant_5597,axiom,
    ~ b000000011100000001010100001(bitIndex4) ).

fof(bitBlastConstant_5596,axiom,
    ~ b000000011100000001010100001(bitIndex3) ).

fof(bitBlastConstant_5595,axiom,
    ~ b000000011100000001010100001(bitIndex2) ).

fof(bitBlastConstant_5594,axiom,
    ~ b000000011100000001010100001(bitIndex1) ).

fof(bitBlastConstant_5593,axiom,
    b000000011100000001010100001(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_383,axiom,
    ! [VarCurr] :
      ( v4364(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5592,axiom,
    ~ b000000011000000001010100001(bitIndex26) ).

fof(bitBlastConstant_5591,axiom,
    ~ b000000011000000001010100001(bitIndex25) ).

fof(bitBlastConstant_5590,axiom,
    ~ b000000011000000001010100001(bitIndex24) ).

fof(bitBlastConstant_5589,axiom,
    ~ b000000011000000001010100001(bitIndex23) ).

fof(bitBlastConstant_5588,axiom,
    ~ b000000011000000001010100001(bitIndex22) ).

fof(bitBlastConstant_5587,axiom,
    ~ b000000011000000001010100001(bitIndex21) ).

fof(bitBlastConstant_5586,axiom,
    ~ b000000011000000001010100001(bitIndex20) ).

fof(bitBlastConstant_5585,axiom,
    b000000011000000001010100001(bitIndex19) ).

fof(bitBlastConstant_5584,axiom,
    b000000011000000001010100001(bitIndex18) ).

fof(bitBlastConstant_5583,axiom,
    ~ b000000011000000001010100001(bitIndex17) ).

fof(bitBlastConstant_5582,axiom,
    ~ b000000011000000001010100001(bitIndex16) ).

fof(bitBlastConstant_5581,axiom,
    ~ b000000011000000001010100001(bitIndex15) ).

fof(bitBlastConstant_5580,axiom,
    ~ b000000011000000001010100001(bitIndex14) ).

fof(bitBlastConstant_5579,axiom,
    ~ b000000011000000001010100001(bitIndex13) ).

fof(bitBlastConstant_5578,axiom,
    ~ b000000011000000001010100001(bitIndex12) ).

fof(bitBlastConstant_5577,axiom,
    ~ b000000011000000001010100001(bitIndex11) ).

fof(bitBlastConstant_5576,axiom,
    ~ b000000011000000001010100001(bitIndex10) ).

fof(bitBlastConstant_5575,axiom,
    b000000011000000001010100001(bitIndex9) ).

fof(bitBlastConstant_5574,axiom,
    ~ b000000011000000001010100001(bitIndex8) ).

fof(bitBlastConstant_5573,axiom,
    b000000011000000001010100001(bitIndex7) ).

fof(bitBlastConstant_5572,axiom,
    ~ b000000011000000001010100001(bitIndex6) ).

fof(bitBlastConstant_5571,axiom,
    b000000011000000001010100001(bitIndex5) ).

fof(bitBlastConstant_5570,axiom,
    ~ b000000011000000001010100001(bitIndex4) ).

fof(bitBlastConstant_5569,axiom,
    ~ b000000011000000001010100001(bitIndex3) ).

fof(bitBlastConstant_5568,axiom,
    ~ b000000011000000001010100001(bitIndex2) ).

fof(bitBlastConstant_5567,axiom,
    ~ b000000011000000001010100001(bitIndex1) ).

fof(bitBlastConstant_5566,axiom,
    b000000011000000001010100001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_175,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4351(VarCurr)
      <=> v4355(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_177,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4351(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_98,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4355(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_109,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4355(VarCurr)
      <=> v4357(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_109,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4355(VarCurr)
      <=> v4356(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_382,axiom,
    ! [VarCurr] :
      ( v4357(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5565,axiom,
    ~ b000000011100000001010100000(bitIndex26) ).

fof(bitBlastConstant_5564,axiom,
    ~ b000000011100000001010100000(bitIndex25) ).

fof(bitBlastConstant_5563,axiom,
    ~ b000000011100000001010100000(bitIndex24) ).

fof(bitBlastConstant_5562,axiom,
    ~ b000000011100000001010100000(bitIndex23) ).

fof(bitBlastConstant_5561,axiom,
    ~ b000000011100000001010100000(bitIndex22) ).

fof(bitBlastConstant_5560,axiom,
    ~ b000000011100000001010100000(bitIndex21) ).

fof(bitBlastConstant_5559,axiom,
    ~ b000000011100000001010100000(bitIndex20) ).

fof(bitBlastConstant_5558,axiom,
    b000000011100000001010100000(bitIndex19) ).

fof(bitBlastConstant_5557,axiom,
    b000000011100000001010100000(bitIndex18) ).

fof(bitBlastConstant_5556,axiom,
    b000000011100000001010100000(bitIndex17) ).

fof(bitBlastConstant_5555,axiom,
    ~ b000000011100000001010100000(bitIndex16) ).

fof(bitBlastConstant_5554,axiom,
    ~ b000000011100000001010100000(bitIndex15) ).

fof(bitBlastConstant_5553,axiom,
    ~ b000000011100000001010100000(bitIndex14) ).

fof(bitBlastConstant_5552,axiom,
    ~ b000000011100000001010100000(bitIndex13) ).

fof(bitBlastConstant_5551,axiom,
    ~ b000000011100000001010100000(bitIndex12) ).

fof(bitBlastConstant_5550,axiom,
    ~ b000000011100000001010100000(bitIndex11) ).

fof(bitBlastConstant_5549,axiom,
    ~ b000000011100000001010100000(bitIndex10) ).

fof(bitBlastConstant_5548,axiom,
    b000000011100000001010100000(bitIndex9) ).

fof(bitBlastConstant_5547,axiom,
    ~ b000000011100000001010100000(bitIndex8) ).

fof(bitBlastConstant_5546,axiom,
    b000000011100000001010100000(bitIndex7) ).

fof(bitBlastConstant_5545,axiom,
    ~ b000000011100000001010100000(bitIndex6) ).

fof(bitBlastConstant_5544,axiom,
    b000000011100000001010100000(bitIndex5) ).

fof(bitBlastConstant_5543,axiom,
    ~ b000000011100000001010100000(bitIndex4) ).

fof(bitBlastConstant_5542,axiom,
    ~ b000000011100000001010100000(bitIndex3) ).

fof(bitBlastConstant_5541,axiom,
    ~ b000000011100000001010100000(bitIndex2) ).

fof(bitBlastConstant_5540,axiom,
    ~ b000000011100000001010100000(bitIndex1) ).

fof(bitBlastConstant_5539,axiom,
    ~ b000000011100000001010100000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_381,axiom,
    ! [VarCurr] :
      ( v4356(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $false )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5538,axiom,
    ~ b000000011000000001010100000(bitIndex26) ).

fof(bitBlastConstant_5537,axiom,
    ~ b000000011000000001010100000(bitIndex25) ).

fof(bitBlastConstant_5536,axiom,
    ~ b000000011000000001010100000(bitIndex24) ).

fof(bitBlastConstant_5535,axiom,
    ~ b000000011000000001010100000(bitIndex23) ).

fof(bitBlastConstant_5534,axiom,
    ~ b000000011000000001010100000(bitIndex22) ).

fof(bitBlastConstant_5533,axiom,
    ~ b000000011000000001010100000(bitIndex21) ).

fof(bitBlastConstant_5532,axiom,
    ~ b000000011000000001010100000(bitIndex20) ).

fof(bitBlastConstant_5531,axiom,
    b000000011000000001010100000(bitIndex19) ).

fof(bitBlastConstant_5530,axiom,
    b000000011000000001010100000(bitIndex18) ).

fof(bitBlastConstant_5529,axiom,
    ~ b000000011000000001010100000(bitIndex17) ).

fof(bitBlastConstant_5528,axiom,
    ~ b000000011000000001010100000(bitIndex16) ).

fof(bitBlastConstant_5527,axiom,
    ~ b000000011000000001010100000(bitIndex15) ).

fof(bitBlastConstant_5526,axiom,
    ~ b000000011000000001010100000(bitIndex14) ).

fof(bitBlastConstant_5525,axiom,
    ~ b000000011000000001010100000(bitIndex13) ).

fof(bitBlastConstant_5524,axiom,
    ~ b000000011000000001010100000(bitIndex12) ).

fof(bitBlastConstant_5523,axiom,
    ~ b000000011000000001010100000(bitIndex11) ).

fof(bitBlastConstant_5522,axiom,
    ~ b000000011000000001010100000(bitIndex10) ).

fof(bitBlastConstant_5521,axiom,
    b000000011000000001010100000(bitIndex9) ).

fof(bitBlastConstant_5520,axiom,
    ~ b000000011000000001010100000(bitIndex8) ).

fof(bitBlastConstant_5519,axiom,
    b000000011000000001010100000(bitIndex7) ).

fof(bitBlastConstant_5518,axiom,
    ~ b000000011000000001010100000(bitIndex6) ).

fof(bitBlastConstant_5517,axiom,
    b000000011000000001010100000(bitIndex5) ).

fof(bitBlastConstant_5516,axiom,
    ~ b000000011000000001010100000(bitIndex4) ).

fof(bitBlastConstant_5515,axiom,
    ~ b000000011000000001010100000(bitIndex3) ).

fof(bitBlastConstant_5514,axiom,
    ~ b000000011000000001010100000(bitIndex2) ).

fof(bitBlastConstant_5513,axiom,
    ~ b000000011000000001010100000(bitIndex1) ).

fof(bitBlastConstant_5512,axiom,
    ~ b000000011000000001010100000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_174,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4343(VarCurr)
      <=> v4347(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_176,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4343(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_97,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4347(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_108,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4347(VarCurr)
      <=> v4349(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_108,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4347(VarCurr)
      <=> v4348(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_380,axiom,
    ! [VarCurr] :
      ( v4349(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5511,axiom,
    ~ b000000011100000001010011111(bitIndex26) ).

fof(bitBlastConstant_5510,axiom,
    ~ b000000011100000001010011111(bitIndex25) ).

fof(bitBlastConstant_5509,axiom,
    ~ b000000011100000001010011111(bitIndex24) ).

fof(bitBlastConstant_5508,axiom,
    ~ b000000011100000001010011111(bitIndex23) ).

fof(bitBlastConstant_5507,axiom,
    ~ b000000011100000001010011111(bitIndex22) ).

fof(bitBlastConstant_5506,axiom,
    ~ b000000011100000001010011111(bitIndex21) ).

fof(bitBlastConstant_5505,axiom,
    ~ b000000011100000001010011111(bitIndex20) ).

fof(bitBlastConstant_5504,axiom,
    b000000011100000001010011111(bitIndex19) ).

fof(bitBlastConstant_5503,axiom,
    b000000011100000001010011111(bitIndex18) ).

fof(bitBlastConstant_5502,axiom,
    b000000011100000001010011111(bitIndex17) ).

fof(bitBlastConstant_5501,axiom,
    ~ b000000011100000001010011111(bitIndex16) ).

fof(bitBlastConstant_5500,axiom,
    ~ b000000011100000001010011111(bitIndex15) ).

fof(bitBlastConstant_5499,axiom,
    ~ b000000011100000001010011111(bitIndex14) ).

fof(bitBlastConstant_5498,axiom,
    ~ b000000011100000001010011111(bitIndex13) ).

fof(bitBlastConstant_5497,axiom,
    ~ b000000011100000001010011111(bitIndex12) ).

fof(bitBlastConstant_5496,axiom,
    ~ b000000011100000001010011111(bitIndex11) ).

fof(bitBlastConstant_5495,axiom,
    ~ b000000011100000001010011111(bitIndex10) ).

fof(bitBlastConstant_5494,axiom,
    b000000011100000001010011111(bitIndex9) ).

fof(bitBlastConstant_5493,axiom,
    ~ b000000011100000001010011111(bitIndex8) ).

fof(bitBlastConstant_5492,axiom,
    b000000011100000001010011111(bitIndex7) ).

fof(bitBlastConstant_5491,axiom,
    ~ b000000011100000001010011111(bitIndex6) ).

fof(bitBlastConstant_5490,axiom,
    ~ b000000011100000001010011111(bitIndex5) ).

fof(bitBlastConstant_5489,axiom,
    b000000011100000001010011111(bitIndex4) ).

fof(bitBlastConstant_5488,axiom,
    b000000011100000001010011111(bitIndex3) ).

fof(bitBlastConstant_5487,axiom,
    b000000011100000001010011111(bitIndex2) ).

fof(bitBlastConstant_5486,axiom,
    b000000011100000001010011111(bitIndex1) ).

fof(bitBlastConstant_5485,axiom,
    b000000011100000001010011111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_379,axiom,
    ! [VarCurr] :
      ( v4348(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5484,axiom,
    ~ b000000011000000001010011111(bitIndex26) ).

fof(bitBlastConstant_5483,axiom,
    ~ b000000011000000001010011111(bitIndex25) ).

fof(bitBlastConstant_5482,axiom,
    ~ b000000011000000001010011111(bitIndex24) ).

fof(bitBlastConstant_5481,axiom,
    ~ b000000011000000001010011111(bitIndex23) ).

fof(bitBlastConstant_5480,axiom,
    ~ b000000011000000001010011111(bitIndex22) ).

fof(bitBlastConstant_5479,axiom,
    ~ b000000011000000001010011111(bitIndex21) ).

fof(bitBlastConstant_5478,axiom,
    ~ b000000011000000001010011111(bitIndex20) ).

fof(bitBlastConstant_5477,axiom,
    b000000011000000001010011111(bitIndex19) ).

fof(bitBlastConstant_5476,axiom,
    b000000011000000001010011111(bitIndex18) ).

fof(bitBlastConstant_5475,axiom,
    ~ b000000011000000001010011111(bitIndex17) ).

fof(bitBlastConstant_5474,axiom,
    ~ b000000011000000001010011111(bitIndex16) ).

fof(bitBlastConstant_5473,axiom,
    ~ b000000011000000001010011111(bitIndex15) ).

fof(bitBlastConstant_5472,axiom,
    ~ b000000011000000001010011111(bitIndex14) ).

fof(bitBlastConstant_5471,axiom,
    ~ b000000011000000001010011111(bitIndex13) ).

fof(bitBlastConstant_5470,axiom,
    ~ b000000011000000001010011111(bitIndex12) ).

fof(bitBlastConstant_5469,axiom,
    ~ b000000011000000001010011111(bitIndex11) ).

fof(bitBlastConstant_5468,axiom,
    ~ b000000011000000001010011111(bitIndex10) ).

fof(bitBlastConstant_5467,axiom,
    b000000011000000001010011111(bitIndex9) ).

fof(bitBlastConstant_5466,axiom,
    ~ b000000011000000001010011111(bitIndex8) ).

fof(bitBlastConstant_5465,axiom,
    b000000011000000001010011111(bitIndex7) ).

fof(bitBlastConstant_5464,axiom,
    ~ b000000011000000001010011111(bitIndex6) ).

fof(bitBlastConstant_5463,axiom,
    ~ b000000011000000001010011111(bitIndex5) ).

fof(bitBlastConstant_5462,axiom,
    b000000011000000001010011111(bitIndex4) ).

fof(bitBlastConstant_5461,axiom,
    b000000011000000001010011111(bitIndex3) ).

fof(bitBlastConstant_5460,axiom,
    b000000011000000001010011111(bitIndex2) ).

fof(bitBlastConstant_5459,axiom,
    b000000011000000001010011111(bitIndex1) ).

fof(bitBlastConstant_5458,axiom,
    b000000011000000001010011111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_173,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4335(VarCurr)
      <=> v4339(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_175,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4335(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_96,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4339(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_107,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4339(VarCurr)
      <=> v4341(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_107,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4339(VarCurr)
      <=> v4340(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_378,axiom,
    ! [VarCurr] :
      ( v4341(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5457,axiom,
    ~ b000000011100000001010011110(bitIndex26) ).

fof(bitBlastConstant_5456,axiom,
    ~ b000000011100000001010011110(bitIndex25) ).

fof(bitBlastConstant_5455,axiom,
    ~ b000000011100000001010011110(bitIndex24) ).

fof(bitBlastConstant_5454,axiom,
    ~ b000000011100000001010011110(bitIndex23) ).

fof(bitBlastConstant_5453,axiom,
    ~ b000000011100000001010011110(bitIndex22) ).

fof(bitBlastConstant_5452,axiom,
    ~ b000000011100000001010011110(bitIndex21) ).

fof(bitBlastConstant_5451,axiom,
    ~ b000000011100000001010011110(bitIndex20) ).

fof(bitBlastConstant_5450,axiom,
    b000000011100000001010011110(bitIndex19) ).

fof(bitBlastConstant_5449,axiom,
    b000000011100000001010011110(bitIndex18) ).

fof(bitBlastConstant_5448,axiom,
    b000000011100000001010011110(bitIndex17) ).

fof(bitBlastConstant_5447,axiom,
    ~ b000000011100000001010011110(bitIndex16) ).

fof(bitBlastConstant_5446,axiom,
    ~ b000000011100000001010011110(bitIndex15) ).

fof(bitBlastConstant_5445,axiom,
    ~ b000000011100000001010011110(bitIndex14) ).

fof(bitBlastConstant_5444,axiom,
    ~ b000000011100000001010011110(bitIndex13) ).

fof(bitBlastConstant_5443,axiom,
    ~ b000000011100000001010011110(bitIndex12) ).

fof(bitBlastConstant_5442,axiom,
    ~ b000000011100000001010011110(bitIndex11) ).

fof(bitBlastConstant_5441,axiom,
    ~ b000000011100000001010011110(bitIndex10) ).

fof(bitBlastConstant_5440,axiom,
    b000000011100000001010011110(bitIndex9) ).

fof(bitBlastConstant_5439,axiom,
    ~ b000000011100000001010011110(bitIndex8) ).

fof(bitBlastConstant_5438,axiom,
    b000000011100000001010011110(bitIndex7) ).

fof(bitBlastConstant_5437,axiom,
    ~ b000000011100000001010011110(bitIndex6) ).

fof(bitBlastConstant_5436,axiom,
    ~ b000000011100000001010011110(bitIndex5) ).

fof(bitBlastConstant_5435,axiom,
    b000000011100000001010011110(bitIndex4) ).

fof(bitBlastConstant_5434,axiom,
    b000000011100000001010011110(bitIndex3) ).

fof(bitBlastConstant_5433,axiom,
    b000000011100000001010011110(bitIndex2) ).

fof(bitBlastConstant_5432,axiom,
    b000000011100000001010011110(bitIndex1) ).

fof(bitBlastConstant_5431,axiom,
    ~ b000000011100000001010011110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_377,axiom,
    ! [VarCurr] :
      ( v4340(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5430,axiom,
    ~ b000000011000000001010011110(bitIndex26) ).

fof(bitBlastConstant_5429,axiom,
    ~ b000000011000000001010011110(bitIndex25) ).

fof(bitBlastConstant_5428,axiom,
    ~ b000000011000000001010011110(bitIndex24) ).

fof(bitBlastConstant_5427,axiom,
    ~ b000000011000000001010011110(bitIndex23) ).

fof(bitBlastConstant_5426,axiom,
    ~ b000000011000000001010011110(bitIndex22) ).

fof(bitBlastConstant_5425,axiom,
    ~ b000000011000000001010011110(bitIndex21) ).

fof(bitBlastConstant_5424,axiom,
    ~ b000000011000000001010011110(bitIndex20) ).

fof(bitBlastConstant_5423,axiom,
    b000000011000000001010011110(bitIndex19) ).

fof(bitBlastConstant_5422,axiom,
    b000000011000000001010011110(bitIndex18) ).

fof(bitBlastConstant_5421,axiom,
    ~ b000000011000000001010011110(bitIndex17) ).

fof(bitBlastConstant_5420,axiom,
    ~ b000000011000000001010011110(bitIndex16) ).

fof(bitBlastConstant_5419,axiom,
    ~ b000000011000000001010011110(bitIndex15) ).

fof(bitBlastConstant_5418,axiom,
    ~ b000000011000000001010011110(bitIndex14) ).

fof(bitBlastConstant_5417,axiom,
    ~ b000000011000000001010011110(bitIndex13) ).

fof(bitBlastConstant_5416,axiom,
    ~ b000000011000000001010011110(bitIndex12) ).

fof(bitBlastConstant_5415,axiom,
    ~ b000000011000000001010011110(bitIndex11) ).

fof(bitBlastConstant_5414,axiom,
    ~ b000000011000000001010011110(bitIndex10) ).

fof(bitBlastConstant_5413,axiom,
    b000000011000000001010011110(bitIndex9) ).

fof(bitBlastConstant_5412,axiom,
    ~ b000000011000000001010011110(bitIndex8) ).

fof(bitBlastConstant_5411,axiom,
    b000000011000000001010011110(bitIndex7) ).

fof(bitBlastConstant_5410,axiom,
    ~ b000000011000000001010011110(bitIndex6) ).

fof(bitBlastConstant_5409,axiom,
    ~ b000000011000000001010011110(bitIndex5) ).

fof(bitBlastConstant_5408,axiom,
    b000000011000000001010011110(bitIndex4) ).

fof(bitBlastConstant_5407,axiom,
    b000000011000000001010011110(bitIndex3) ).

fof(bitBlastConstant_5406,axiom,
    b000000011000000001010011110(bitIndex2) ).

fof(bitBlastConstant_5405,axiom,
    b000000011000000001010011110(bitIndex1) ).

fof(bitBlastConstant_5404,axiom,
    ~ b000000011000000001010011110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_172,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4327(VarCurr)
      <=> v4331(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_174,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4327(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_95,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4331(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_106,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4331(VarCurr)
      <=> v4333(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_106,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4331(VarCurr)
      <=> v4332(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_376,axiom,
    ! [VarCurr] :
      ( v4333(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5403,axiom,
    ~ b000000011100000001010011101(bitIndex26) ).

fof(bitBlastConstant_5402,axiom,
    ~ b000000011100000001010011101(bitIndex25) ).

fof(bitBlastConstant_5401,axiom,
    ~ b000000011100000001010011101(bitIndex24) ).

fof(bitBlastConstant_5400,axiom,
    ~ b000000011100000001010011101(bitIndex23) ).

fof(bitBlastConstant_5399,axiom,
    ~ b000000011100000001010011101(bitIndex22) ).

fof(bitBlastConstant_5398,axiom,
    ~ b000000011100000001010011101(bitIndex21) ).

fof(bitBlastConstant_5397,axiom,
    ~ b000000011100000001010011101(bitIndex20) ).

fof(bitBlastConstant_5396,axiom,
    b000000011100000001010011101(bitIndex19) ).

fof(bitBlastConstant_5395,axiom,
    b000000011100000001010011101(bitIndex18) ).

fof(bitBlastConstant_5394,axiom,
    b000000011100000001010011101(bitIndex17) ).

fof(bitBlastConstant_5393,axiom,
    ~ b000000011100000001010011101(bitIndex16) ).

fof(bitBlastConstant_5392,axiom,
    ~ b000000011100000001010011101(bitIndex15) ).

fof(bitBlastConstant_5391,axiom,
    ~ b000000011100000001010011101(bitIndex14) ).

fof(bitBlastConstant_5390,axiom,
    ~ b000000011100000001010011101(bitIndex13) ).

fof(bitBlastConstant_5389,axiom,
    ~ b000000011100000001010011101(bitIndex12) ).

fof(bitBlastConstant_5388,axiom,
    ~ b000000011100000001010011101(bitIndex11) ).

fof(bitBlastConstant_5387,axiom,
    ~ b000000011100000001010011101(bitIndex10) ).

fof(bitBlastConstant_5386,axiom,
    b000000011100000001010011101(bitIndex9) ).

fof(bitBlastConstant_5385,axiom,
    ~ b000000011100000001010011101(bitIndex8) ).

fof(bitBlastConstant_5384,axiom,
    b000000011100000001010011101(bitIndex7) ).

fof(bitBlastConstant_5383,axiom,
    ~ b000000011100000001010011101(bitIndex6) ).

fof(bitBlastConstant_5382,axiom,
    ~ b000000011100000001010011101(bitIndex5) ).

fof(bitBlastConstant_5381,axiom,
    b000000011100000001010011101(bitIndex4) ).

fof(bitBlastConstant_5380,axiom,
    b000000011100000001010011101(bitIndex3) ).

fof(bitBlastConstant_5379,axiom,
    b000000011100000001010011101(bitIndex2) ).

fof(bitBlastConstant_5378,axiom,
    ~ b000000011100000001010011101(bitIndex1) ).

fof(bitBlastConstant_5377,axiom,
    b000000011100000001010011101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_375,axiom,
    ! [VarCurr] :
      ( v4332(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5376,axiom,
    ~ b000000011000000001010011101(bitIndex26) ).

fof(bitBlastConstant_5375,axiom,
    ~ b000000011000000001010011101(bitIndex25) ).

fof(bitBlastConstant_5374,axiom,
    ~ b000000011000000001010011101(bitIndex24) ).

fof(bitBlastConstant_5373,axiom,
    ~ b000000011000000001010011101(bitIndex23) ).

fof(bitBlastConstant_5372,axiom,
    ~ b000000011000000001010011101(bitIndex22) ).

fof(bitBlastConstant_5371,axiom,
    ~ b000000011000000001010011101(bitIndex21) ).

fof(bitBlastConstant_5370,axiom,
    ~ b000000011000000001010011101(bitIndex20) ).

fof(bitBlastConstant_5369,axiom,
    b000000011000000001010011101(bitIndex19) ).

fof(bitBlastConstant_5368,axiom,
    b000000011000000001010011101(bitIndex18) ).

fof(bitBlastConstant_5367,axiom,
    ~ b000000011000000001010011101(bitIndex17) ).

fof(bitBlastConstant_5366,axiom,
    ~ b000000011000000001010011101(bitIndex16) ).

fof(bitBlastConstant_5365,axiom,
    ~ b000000011000000001010011101(bitIndex15) ).

fof(bitBlastConstant_5364,axiom,
    ~ b000000011000000001010011101(bitIndex14) ).

fof(bitBlastConstant_5363,axiom,
    ~ b000000011000000001010011101(bitIndex13) ).

fof(bitBlastConstant_5362,axiom,
    ~ b000000011000000001010011101(bitIndex12) ).

fof(bitBlastConstant_5361,axiom,
    ~ b000000011000000001010011101(bitIndex11) ).

fof(bitBlastConstant_5360,axiom,
    ~ b000000011000000001010011101(bitIndex10) ).

fof(bitBlastConstant_5359,axiom,
    b000000011000000001010011101(bitIndex9) ).

fof(bitBlastConstant_5358,axiom,
    ~ b000000011000000001010011101(bitIndex8) ).

fof(bitBlastConstant_5357,axiom,
    b000000011000000001010011101(bitIndex7) ).

fof(bitBlastConstant_5356,axiom,
    ~ b000000011000000001010011101(bitIndex6) ).

fof(bitBlastConstant_5355,axiom,
    ~ b000000011000000001010011101(bitIndex5) ).

fof(bitBlastConstant_5354,axiom,
    b000000011000000001010011101(bitIndex4) ).

fof(bitBlastConstant_5353,axiom,
    b000000011000000001010011101(bitIndex3) ).

fof(bitBlastConstant_5352,axiom,
    b000000011000000001010011101(bitIndex2) ).

fof(bitBlastConstant_5351,axiom,
    ~ b000000011000000001010011101(bitIndex1) ).

fof(bitBlastConstant_5350,axiom,
    b000000011000000001010011101(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_171,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4319(VarCurr)
      <=> v4323(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_173,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4319(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_94,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4323(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_105,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4323(VarCurr)
      <=> v4325(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_105,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4323(VarCurr)
      <=> v4324(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_374,axiom,
    ! [VarCurr] :
      ( v4325(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5349,axiom,
    ~ b000000011100000001010011100(bitIndex26) ).

fof(bitBlastConstant_5348,axiom,
    ~ b000000011100000001010011100(bitIndex25) ).

fof(bitBlastConstant_5347,axiom,
    ~ b000000011100000001010011100(bitIndex24) ).

fof(bitBlastConstant_5346,axiom,
    ~ b000000011100000001010011100(bitIndex23) ).

fof(bitBlastConstant_5345,axiom,
    ~ b000000011100000001010011100(bitIndex22) ).

fof(bitBlastConstant_5344,axiom,
    ~ b000000011100000001010011100(bitIndex21) ).

fof(bitBlastConstant_5343,axiom,
    ~ b000000011100000001010011100(bitIndex20) ).

fof(bitBlastConstant_5342,axiom,
    b000000011100000001010011100(bitIndex19) ).

fof(bitBlastConstant_5341,axiom,
    b000000011100000001010011100(bitIndex18) ).

fof(bitBlastConstant_5340,axiom,
    b000000011100000001010011100(bitIndex17) ).

fof(bitBlastConstant_5339,axiom,
    ~ b000000011100000001010011100(bitIndex16) ).

fof(bitBlastConstant_5338,axiom,
    ~ b000000011100000001010011100(bitIndex15) ).

fof(bitBlastConstant_5337,axiom,
    ~ b000000011100000001010011100(bitIndex14) ).

fof(bitBlastConstant_5336,axiom,
    ~ b000000011100000001010011100(bitIndex13) ).

fof(bitBlastConstant_5335,axiom,
    ~ b000000011100000001010011100(bitIndex12) ).

fof(bitBlastConstant_5334,axiom,
    ~ b000000011100000001010011100(bitIndex11) ).

fof(bitBlastConstant_5333,axiom,
    ~ b000000011100000001010011100(bitIndex10) ).

fof(bitBlastConstant_5332,axiom,
    b000000011100000001010011100(bitIndex9) ).

fof(bitBlastConstant_5331,axiom,
    ~ b000000011100000001010011100(bitIndex8) ).

fof(bitBlastConstant_5330,axiom,
    b000000011100000001010011100(bitIndex7) ).

fof(bitBlastConstant_5329,axiom,
    ~ b000000011100000001010011100(bitIndex6) ).

fof(bitBlastConstant_5328,axiom,
    ~ b000000011100000001010011100(bitIndex5) ).

fof(bitBlastConstant_5327,axiom,
    b000000011100000001010011100(bitIndex4) ).

fof(bitBlastConstant_5326,axiom,
    b000000011100000001010011100(bitIndex3) ).

fof(bitBlastConstant_5325,axiom,
    b000000011100000001010011100(bitIndex2) ).

fof(bitBlastConstant_5324,axiom,
    ~ b000000011100000001010011100(bitIndex1) ).

fof(bitBlastConstant_5323,axiom,
    ~ b000000011100000001010011100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_373,axiom,
    ! [VarCurr] :
      ( v4324(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5322,axiom,
    ~ b000000011000000001010011100(bitIndex26) ).

fof(bitBlastConstant_5321,axiom,
    ~ b000000011000000001010011100(bitIndex25) ).

fof(bitBlastConstant_5320,axiom,
    ~ b000000011000000001010011100(bitIndex24) ).

fof(bitBlastConstant_5319,axiom,
    ~ b000000011000000001010011100(bitIndex23) ).

fof(bitBlastConstant_5318,axiom,
    ~ b000000011000000001010011100(bitIndex22) ).

fof(bitBlastConstant_5317,axiom,
    ~ b000000011000000001010011100(bitIndex21) ).

fof(bitBlastConstant_5316,axiom,
    ~ b000000011000000001010011100(bitIndex20) ).

fof(bitBlastConstant_5315,axiom,
    b000000011000000001010011100(bitIndex19) ).

fof(bitBlastConstant_5314,axiom,
    b000000011000000001010011100(bitIndex18) ).

fof(bitBlastConstant_5313,axiom,
    ~ b000000011000000001010011100(bitIndex17) ).

fof(bitBlastConstant_5312,axiom,
    ~ b000000011000000001010011100(bitIndex16) ).

fof(bitBlastConstant_5311,axiom,
    ~ b000000011000000001010011100(bitIndex15) ).

fof(bitBlastConstant_5310,axiom,
    ~ b000000011000000001010011100(bitIndex14) ).

fof(bitBlastConstant_5309,axiom,
    ~ b000000011000000001010011100(bitIndex13) ).

fof(bitBlastConstant_5308,axiom,
    ~ b000000011000000001010011100(bitIndex12) ).

fof(bitBlastConstant_5307,axiom,
    ~ b000000011000000001010011100(bitIndex11) ).

fof(bitBlastConstant_5306,axiom,
    ~ b000000011000000001010011100(bitIndex10) ).

fof(bitBlastConstant_5305,axiom,
    b000000011000000001010011100(bitIndex9) ).

fof(bitBlastConstant_5304,axiom,
    ~ b000000011000000001010011100(bitIndex8) ).

fof(bitBlastConstant_5303,axiom,
    b000000011000000001010011100(bitIndex7) ).

fof(bitBlastConstant_5302,axiom,
    ~ b000000011000000001010011100(bitIndex6) ).

fof(bitBlastConstant_5301,axiom,
    ~ b000000011000000001010011100(bitIndex5) ).

fof(bitBlastConstant_5300,axiom,
    b000000011000000001010011100(bitIndex4) ).

fof(bitBlastConstant_5299,axiom,
    b000000011000000001010011100(bitIndex3) ).

fof(bitBlastConstant_5298,axiom,
    b000000011000000001010011100(bitIndex2) ).

fof(bitBlastConstant_5297,axiom,
    ~ b000000011000000001010011100(bitIndex1) ).

fof(bitBlastConstant_5296,axiom,
    ~ b000000011000000001010011100(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_170,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4311(VarCurr)
      <=> v4315(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_172,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4311(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_93,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4315(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_104,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4315(VarCurr)
      <=> v4317(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_104,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4315(VarCurr)
      <=> v4316(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_372,axiom,
    ! [VarCurr] :
      ( v4317(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5295,axiom,
    ~ b000000011100000001010011011(bitIndex26) ).

fof(bitBlastConstant_5294,axiom,
    ~ b000000011100000001010011011(bitIndex25) ).

fof(bitBlastConstant_5293,axiom,
    ~ b000000011100000001010011011(bitIndex24) ).

fof(bitBlastConstant_5292,axiom,
    ~ b000000011100000001010011011(bitIndex23) ).

fof(bitBlastConstant_5291,axiom,
    ~ b000000011100000001010011011(bitIndex22) ).

fof(bitBlastConstant_5290,axiom,
    ~ b000000011100000001010011011(bitIndex21) ).

fof(bitBlastConstant_5289,axiom,
    ~ b000000011100000001010011011(bitIndex20) ).

fof(bitBlastConstant_5288,axiom,
    b000000011100000001010011011(bitIndex19) ).

fof(bitBlastConstant_5287,axiom,
    b000000011100000001010011011(bitIndex18) ).

fof(bitBlastConstant_5286,axiom,
    b000000011100000001010011011(bitIndex17) ).

fof(bitBlastConstant_5285,axiom,
    ~ b000000011100000001010011011(bitIndex16) ).

fof(bitBlastConstant_5284,axiom,
    ~ b000000011100000001010011011(bitIndex15) ).

fof(bitBlastConstant_5283,axiom,
    ~ b000000011100000001010011011(bitIndex14) ).

fof(bitBlastConstant_5282,axiom,
    ~ b000000011100000001010011011(bitIndex13) ).

fof(bitBlastConstant_5281,axiom,
    ~ b000000011100000001010011011(bitIndex12) ).

fof(bitBlastConstant_5280,axiom,
    ~ b000000011100000001010011011(bitIndex11) ).

fof(bitBlastConstant_5279,axiom,
    ~ b000000011100000001010011011(bitIndex10) ).

fof(bitBlastConstant_5278,axiom,
    b000000011100000001010011011(bitIndex9) ).

fof(bitBlastConstant_5277,axiom,
    ~ b000000011100000001010011011(bitIndex8) ).

fof(bitBlastConstant_5276,axiom,
    b000000011100000001010011011(bitIndex7) ).

fof(bitBlastConstant_5275,axiom,
    ~ b000000011100000001010011011(bitIndex6) ).

fof(bitBlastConstant_5274,axiom,
    ~ b000000011100000001010011011(bitIndex5) ).

fof(bitBlastConstant_5273,axiom,
    b000000011100000001010011011(bitIndex4) ).

fof(bitBlastConstant_5272,axiom,
    b000000011100000001010011011(bitIndex3) ).

fof(bitBlastConstant_5271,axiom,
    ~ b000000011100000001010011011(bitIndex2) ).

fof(bitBlastConstant_5270,axiom,
    b000000011100000001010011011(bitIndex1) ).

fof(bitBlastConstant_5269,axiom,
    b000000011100000001010011011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_371,axiom,
    ! [VarCurr] :
      ( v4316(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5268,axiom,
    ~ b000000011000000001010011011(bitIndex26) ).

fof(bitBlastConstant_5267,axiom,
    ~ b000000011000000001010011011(bitIndex25) ).

fof(bitBlastConstant_5266,axiom,
    ~ b000000011000000001010011011(bitIndex24) ).

fof(bitBlastConstant_5265,axiom,
    ~ b000000011000000001010011011(bitIndex23) ).

fof(bitBlastConstant_5264,axiom,
    ~ b000000011000000001010011011(bitIndex22) ).

fof(bitBlastConstant_5263,axiom,
    ~ b000000011000000001010011011(bitIndex21) ).

fof(bitBlastConstant_5262,axiom,
    ~ b000000011000000001010011011(bitIndex20) ).

fof(bitBlastConstant_5261,axiom,
    b000000011000000001010011011(bitIndex19) ).

fof(bitBlastConstant_5260,axiom,
    b000000011000000001010011011(bitIndex18) ).

fof(bitBlastConstant_5259,axiom,
    ~ b000000011000000001010011011(bitIndex17) ).

fof(bitBlastConstant_5258,axiom,
    ~ b000000011000000001010011011(bitIndex16) ).

fof(bitBlastConstant_5257,axiom,
    ~ b000000011000000001010011011(bitIndex15) ).

fof(bitBlastConstant_5256,axiom,
    ~ b000000011000000001010011011(bitIndex14) ).

fof(bitBlastConstant_5255,axiom,
    ~ b000000011000000001010011011(bitIndex13) ).

fof(bitBlastConstant_5254,axiom,
    ~ b000000011000000001010011011(bitIndex12) ).

fof(bitBlastConstant_5253,axiom,
    ~ b000000011000000001010011011(bitIndex11) ).

fof(bitBlastConstant_5252,axiom,
    ~ b000000011000000001010011011(bitIndex10) ).

fof(bitBlastConstant_5251,axiom,
    b000000011000000001010011011(bitIndex9) ).

fof(bitBlastConstant_5250,axiom,
    ~ b000000011000000001010011011(bitIndex8) ).

fof(bitBlastConstant_5249,axiom,
    b000000011000000001010011011(bitIndex7) ).

fof(bitBlastConstant_5248,axiom,
    ~ b000000011000000001010011011(bitIndex6) ).

fof(bitBlastConstant_5247,axiom,
    ~ b000000011000000001010011011(bitIndex5) ).

fof(bitBlastConstant_5246,axiom,
    b000000011000000001010011011(bitIndex4) ).

fof(bitBlastConstant_5245,axiom,
    b000000011000000001010011011(bitIndex3) ).

fof(bitBlastConstant_5244,axiom,
    ~ b000000011000000001010011011(bitIndex2) ).

fof(bitBlastConstant_5243,axiom,
    b000000011000000001010011011(bitIndex1) ).

fof(bitBlastConstant_5242,axiom,
    b000000011000000001010011011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_169,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4303(VarCurr)
      <=> v4307(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_171,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4303(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_92,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4307(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_103,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4307(VarCurr)
      <=> v4309(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_103,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4307(VarCurr)
      <=> v4308(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_370,axiom,
    ! [VarCurr] :
      ( v4309(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5241,axiom,
    ~ b000000011100000001010011010(bitIndex26) ).

fof(bitBlastConstant_5240,axiom,
    ~ b000000011100000001010011010(bitIndex25) ).

fof(bitBlastConstant_5239,axiom,
    ~ b000000011100000001010011010(bitIndex24) ).

fof(bitBlastConstant_5238,axiom,
    ~ b000000011100000001010011010(bitIndex23) ).

fof(bitBlastConstant_5237,axiom,
    ~ b000000011100000001010011010(bitIndex22) ).

fof(bitBlastConstant_5236,axiom,
    ~ b000000011100000001010011010(bitIndex21) ).

fof(bitBlastConstant_5235,axiom,
    ~ b000000011100000001010011010(bitIndex20) ).

fof(bitBlastConstant_5234,axiom,
    b000000011100000001010011010(bitIndex19) ).

fof(bitBlastConstant_5233,axiom,
    b000000011100000001010011010(bitIndex18) ).

fof(bitBlastConstant_5232,axiom,
    b000000011100000001010011010(bitIndex17) ).

fof(bitBlastConstant_5231,axiom,
    ~ b000000011100000001010011010(bitIndex16) ).

fof(bitBlastConstant_5230,axiom,
    ~ b000000011100000001010011010(bitIndex15) ).

fof(bitBlastConstant_5229,axiom,
    ~ b000000011100000001010011010(bitIndex14) ).

fof(bitBlastConstant_5228,axiom,
    ~ b000000011100000001010011010(bitIndex13) ).

fof(bitBlastConstant_5227,axiom,
    ~ b000000011100000001010011010(bitIndex12) ).

fof(bitBlastConstant_5226,axiom,
    ~ b000000011100000001010011010(bitIndex11) ).

fof(bitBlastConstant_5225,axiom,
    ~ b000000011100000001010011010(bitIndex10) ).

fof(bitBlastConstant_5224,axiom,
    b000000011100000001010011010(bitIndex9) ).

fof(bitBlastConstant_5223,axiom,
    ~ b000000011100000001010011010(bitIndex8) ).

fof(bitBlastConstant_5222,axiom,
    b000000011100000001010011010(bitIndex7) ).

fof(bitBlastConstant_5221,axiom,
    ~ b000000011100000001010011010(bitIndex6) ).

fof(bitBlastConstant_5220,axiom,
    ~ b000000011100000001010011010(bitIndex5) ).

fof(bitBlastConstant_5219,axiom,
    b000000011100000001010011010(bitIndex4) ).

fof(bitBlastConstant_5218,axiom,
    b000000011100000001010011010(bitIndex3) ).

fof(bitBlastConstant_5217,axiom,
    ~ b000000011100000001010011010(bitIndex2) ).

fof(bitBlastConstant_5216,axiom,
    b000000011100000001010011010(bitIndex1) ).

fof(bitBlastConstant_5215,axiom,
    ~ b000000011100000001010011010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_369,axiom,
    ! [VarCurr] :
      ( v4308(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5214,axiom,
    ~ b000000011000000001010011010(bitIndex26) ).

fof(bitBlastConstant_5213,axiom,
    ~ b000000011000000001010011010(bitIndex25) ).

fof(bitBlastConstant_5212,axiom,
    ~ b000000011000000001010011010(bitIndex24) ).

fof(bitBlastConstant_5211,axiom,
    ~ b000000011000000001010011010(bitIndex23) ).

fof(bitBlastConstant_5210,axiom,
    ~ b000000011000000001010011010(bitIndex22) ).

fof(bitBlastConstant_5209,axiom,
    ~ b000000011000000001010011010(bitIndex21) ).

fof(bitBlastConstant_5208,axiom,
    ~ b000000011000000001010011010(bitIndex20) ).

fof(bitBlastConstant_5207,axiom,
    b000000011000000001010011010(bitIndex19) ).

fof(bitBlastConstant_5206,axiom,
    b000000011000000001010011010(bitIndex18) ).

fof(bitBlastConstant_5205,axiom,
    ~ b000000011000000001010011010(bitIndex17) ).

fof(bitBlastConstant_5204,axiom,
    ~ b000000011000000001010011010(bitIndex16) ).

fof(bitBlastConstant_5203,axiom,
    ~ b000000011000000001010011010(bitIndex15) ).

fof(bitBlastConstant_5202,axiom,
    ~ b000000011000000001010011010(bitIndex14) ).

fof(bitBlastConstant_5201,axiom,
    ~ b000000011000000001010011010(bitIndex13) ).

fof(bitBlastConstant_5200,axiom,
    ~ b000000011000000001010011010(bitIndex12) ).

fof(bitBlastConstant_5199,axiom,
    ~ b000000011000000001010011010(bitIndex11) ).

fof(bitBlastConstant_5198,axiom,
    ~ b000000011000000001010011010(bitIndex10) ).

fof(bitBlastConstant_5197,axiom,
    b000000011000000001010011010(bitIndex9) ).

fof(bitBlastConstant_5196,axiom,
    ~ b000000011000000001010011010(bitIndex8) ).

fof(bitBlastConstant_5195,axiom,
    b000000011000000001010011010(bitIndex7) ).

fof(bitBlastConstant_5194,axiom,
    ~ b000000011000000001010011010(bitIndex6) ).

fof(bitBlastConstant_5193,axiom,
    ~ b000000011000000001010011010(bitIndex5) ).

fof(bitBlastConstant_5192,axiom,
    b000000011000000001010011010(bitIndex4) ).

fof(bitBlastConstant_5191,axiom,
    b000000011000000001010011010(bitIndex3) ).

fof(bitBlastConstant_5190,axiom,
    ~ b000000011000000001010011010(bitIndex2) ).

fof(bitBlastConstant_5189,axiom,
    b000000011000000001010011010(bitIndex1) ).

fof(bitBlastConstant_5188,axiom,
    ~ b000000011000000001010011010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_168,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4295(VarCurr)
      <=> v4299(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_170,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4295(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_91,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4299(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_102,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4299(VarCurr)
      <=> v4301(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_102,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4299(VarCurr)
      <=> v4300(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_368,axiom,
    ! [VarCurr] :
      ( v4301(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5187,axiom,
    ~ b000000011100000001010011001(bitIndex26) ).

fof(bitBlastConstant_5186,axiom,
    ~ b000000011100000001010011001(bitIndex25) ).

fof(bitBlastConstant_5185,axiom,
    ~ b000000011100000001010011001(bitIndex24) ).

fof(bitBlastConstant_5184,axiom,
    ~ b000000011100000001010011001(bitIndex23) ).

fof(bitBlastConstant_5183,axiom,
    ~ b000000011100000001010011001(bitIndex22) ).

fof(bitBlastConstant_5182,axiom,
    ~ b000000011100000001010011001(bitIndex21) ).

fof(bitBlastConstant_5181,axiom,
    ~ b000000011100000001010011001(bitIndex20) ).

fof(bitBlastConstant_5180,axiom,
    b000000011100000001010011001(bitIndex19) ).

fof(bitBlastConstant_5179,axiom,
    b000000011100000001010011001(bitIndex18) ).

fof(bitBlastConstant_5178,axiom,
    b000000011100000001010011001(bitIndex17) ).

fof(bitBlastConstant_5177,axiom,
    ~ b000000011100000001010011001(bitIndex16) ).

fof(bitBlastConstant_5176,axiom,
    ~ b000000011100000001010011001(bitIndex15) ).

fof(bitBlastConstant_5175,axiom,
    ~ b000000011100000001010011001(bitIndex14) ).

fof(bitBlastConstant_5174,axiom,
    ~ b000000011100000001010011001(bitIndex13) ).

fof(bitBlastConstant_5173,axiom,
    ~ b000000011100000001010011001(bitIndex12) ).

fof(bitBlastConstant_5172,axiom,
    ~ b000000011100000001010011001(bitIndex11) ).

fof(bitBlastConstant_5171,axiom,
    ~ b000000011100000001010011001(bitIndex10) ).

fof(bitBlastConstant_5170,axiom,
    b000000011100000001010011001(bitIndex9) ).

fof(bitBlastConstant_5169,axiom,
    ~ b000000011100000001010011001(bitIndex8) ).

fof(bitBlastConstant_5168,axiom,
    b000000011100000001010011001(bitIndex7) ).

fof(bitBlastConstant_5167,axiom,
    ~ b000000011100000001010011001(bitIndex6) ).

fof(bitBlastConstant_5166,axiom,
    ~ b000000011100000001010011001(bitIndex5) ).

fof(bitBlastConstant_5165,axiom,
    b000000011100000001010011001(bitIndex4) ).

fof(bitBlastConstant_5164,axiom,
    b000000011100000001010011001(bitIndex3) ).

fof(bitBlastConstant_5163,axiom,
    ~ b000000011100000001010011001(bitIndex2) ).

fof(bitBlastConstant_5162,axiom,
    ~ b000000011100000001010011001(bitIndex1) ).

fof(bitBlastConstant_5161,axiom,
    b000000011100000001010011001(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_367,axiom,
    ! [VarCurr] :
      ( v4300(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5160,axiom,
    ~ b000000011000000001010011001(bitIndex26) ).

fof(bitBlastConstant_5159,axiom,
    ~ b000000011000000001010011001(bitIndex25) ).

fof(bitBlastConstant_5158,axiom,
    ~ b000000011000000001010011001(bitIndex24) ).

fof(bitBlastConstant_5157,axiom,
    ~ b000000011000000001010011001(bitIndex23) ).

fof(bitBlastConstant_5156,axiom,
    ~ b000000011000000001010011001(bitIndex22) ).

fof(bitBlastConstant_5155,axiom,
    ~ b000000011000000001010011001(bitIndex21) ).

fof(bitBlastConstant_5154,axiom,
    ~ b000000011000000001010011001(bitIndex20) ).

fof(bitBlastConstant_5153,axiom,
    b000000011000000001010011001(bitIndex19) ).

fof(bitBlastConstant_5152,axiom,
    b000000011000000001010011001(bitIndex18) ).

fof(bitBlastConstant_5151,axiom,
    ~ b000000011000000001010011001(bitIndex17) ).

fof(bitBlastConstant_5150,axiom,
    ~ b000000011000000001010011001(bitIndex16) ).

fof(bitBlastConstant_5149,axiom,
    ~ b000000011000000001010011001(bitIndex15) ).

fof(bitBlastConstant_5148,axiom,
    ~ b000000011000000001010011001(bitIndex14) ).

fof(bitBlastConstant_5147,axiom,
    ~ b000000011000000001010011001(bitIndex13) ).

fof(bitBlastConstant_5146,axiom,
    ~ b000000011000000001010011001(bitIndex12) ).

fof(bitBlastConstant_5145,axiom,
    ~ b000000011000000001010011001(bitIndex11) ).

fof(bitBlastConstant_5144,axiom,
    ~ b000000011000000001010011001(bitIndex10) ).

fof(bitBlastConstant_5143,axiom,
    b000000011000000001010011001(bitIndex9) ).

fof(bitBlastConstant_5142,axiom,
    ~ b000000011000000001010011001(bitIndex8) ).

fof(bitBlastConstant_5141,axiom,
    b000000011000000001010011001(bitIndex7) ).

fof(bitBlastConstant_5140,axiom,
    ~ b000000011000000001010011001(bitIndex6) ).

fof(bitBlastConstant_5139,axiom,
    ~ b000000011000000001010011001(bitIndex5) ).

fof(bitBlastConstant_5138,axiom,
    b000000011000000001010011001(bitIndex4) ).

fof(bitBlastConstant_5137,axiom,
    b000000011000000001010011001(bitIndex3) ).

fof(bitBlastConstant_5136,axiom,
    ~ b000000011000000001010011001(bitIndex2) ).

fof(bitBlastConstant_5135,axiom,
    ~ b000000011000000001010011001(bitIndex1) ).

fof(bitBlastConstant_5134,axiom,
    b000000011000000001010011001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_167,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4287(VarCurr)
      <=> v4291(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_169,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4287(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_90,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4291(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_101,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4291(VarCurr)
      <=> v4293(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_101,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4291(VarCurr)
      <=> v4292(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_366,axiom,
    ! [VarCurr] :
      ( v4293(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5133,axiom,
    ~ b000000011100000001010011000(bitIndex26) ).

fof(bitBlastConstant_5132,axiom,
    ~ b000000011100000001010011000(bitIndex25) ).

fof(bitBlastConstant_5131,axiom,
    ~ b000000011100000001010011000(bitIndex24) ).

fof(bitBlastConstant_5130,axiom,
    ~ b000000011100000001010011000(bitIndex23) ).

fof(bitBlastConstant_5129,axiom,
    ~ b000000011100000001010011000(bitIndex22) ).

fof(bitBlastConstant_5128,axiom,
    ~ b000000011100000001010011000(bitIndex21) ).

fof(bitBlastConstant_5127,axiom,
    ~ b000000011100000001010011000(bitIndex20) ).

fof(bitBlastConstant_5126,axiom,
    b000000011100000001010011000(bitIndex19) ).

fof(bitBlastConstant_5125,axiom,
    b000000011100000001010011000(bitIndex18) ).

fof(bitBlastConstant_5124,axiom,
    b000000011100000001010011000(bitIndex17) ).

fof(bitBlastConstant_5123,axiom,
    ~ b000000011100000001010011000(bitIndex16) ).

fof(bitBlastConstant_5122,axiom,
    ~ b000000011100000001010011000(bitIndex15) ).

fof(bitBlastConstant_5121,axiom,
    ~ b000000011100000001010011000(bitIndex14) ).

fof(bitBlastConstant_5120,axiom,
    ~ b000000011100000001010011000(bitIndex13) ).

fof(bitBlastConstant_5119,axiom,
    ~ b000000011100000001010011000(bitIndex12) ).

fof(bitBlastConstant_5118,axiom,
    ~ b000000011100000001010011000(bitIndex11) ).

fof(bitBlastConstant_5117,axiom,
    ~ b000000011100000001010011000(bitIndex10) ).

fof(bitBlastConstant_5116,axiom,
    b000000011100000001010011000(bitIndex9) ).

fof(bitBlastConstant_5115,axiom,
    ~ b000000011100000001010011000(bitIndex8) ).

fof(bitBlastConstant_5114,axiom,
    b000000011100000001010011000(bitIndex7) ).

fof(bitBlastConstant_5113,axiom,
    ~ b000000011100000001010011000(bitIndex6) ).

fof(bitBlastConstant_5112,axiom,
    ~ b000000011100000001010011000(bitIndex5) ).

fof(bitBlastConstant_5111,axiom,
    b000000011100000001010011000(bitIndex4) ).

fof(bitBlastConstant_5110,axiom,
    b000000011100000001010011000(bitIndex3) ).

fof(bitBlastConstant_5109,axiom,
    ~ b000000011100000001010011000(bitIndex2) ).

fof(bitBlastConstant_5108,axiom,
    ~ b000000011100000001010011000(bitIndex1) ).

fof(bitBlastConstant_5107,axiom,
    ~ b000000011100000001010011000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_365,axiom,
    ! [VarCurr] :
      ( v4292(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5106,axiom,
    ~ b000000011000000001010011000(bitIndex26) ).

fof(bitBlastConstant_5105,axiom,
    ~ b000000011000000001010011000(bitIndex25) ).

fof(bitBlastConstant_5104,axiom,
    ~ b000000011000000001010011000(bitIndex24) ).

fof(bitBlastConstant_5103,axiom,
    ~ b000000011000000001010011000(bitIndex23) ).

fof(bitBlastConstant_5102,axiom,
    ~ b000000011000000001010011000(bitIndex22) ).

fof(bitBlastConstant_5101,axiom,
    ~ b000000011000000001010011000(bitIndex21) ).

fof(bitBlastConstant_5100,axiom,
    ~ b000000011000000001010011000(bitIndex20) ).

fof(bitBlastConstant_5099,axiom,
    b000000011000000001010011000(bitIndex19) ).

fof(bitBlastConstant_5098,axiom,
    b000000011000000001010011000(bitIndex18) ).

fof(bitBlastConstant_5097,axiom,
    ~ b000000011000000001010011000(bitIndex17) ).

fof(bitBlastConstant_5096,axiom,
    ~ b000000011000000001010011000(bitIndex16) ).

fof(bitBlastConstant_5095,axiom,
    ~ b000000011000000001010011000(bitIndex15) ).

fof(bitBlastConstant_5094,axiom,
    ~ b000000011000000001010011000(bitIndex14) ).

fof(bitBlastConstant_5093,axiom,
    ~ b000000011000000001010011000(bitIndex13) ).

fof(bitBlastConstant_5092,axiom,
    ~ b000000011000000001010011000(bitIndex12) ).

fof(bitBlastConstant_5091,axiom,
    ~ b000000011000000001010011000(bitIndex11) ).

fof(bitBlastConstant_5090,axiom,
    ~ b000000011000000001010011000(bitIndex10) ).

fof(bitBlastConstant_5089,axiom,
    b000000011000000001010011000(bitIndex9) ).

fof(bitBlastConstant_5088,axiom,
    ~ b000000011000000001010011000(bitIndex8) ).

fof(bitBlastConstant_5087,axiom,
    b000000011000000001010011000(bitIndex7) ).

fof(bitBlastConstant_5086,axiom,
    ~ b000000011000000001010011000(bitIndex6) ).

fof(bitBlastConstant_5085,axiom,
    ~ b000000011000000001010011000(bitIndex5) ).

fof(bitBlastConstant_5084,axiom,
    b000000011000000001010011000(bitIndex4) ).

fof(bitBlastConstant_5083,axiom,
    b000000011000000001010011000(bitIndex3) ).

fof(bitBlastConstant_5082,axiom,
    ~ b000000011000000001010011000(bitIndex2) ).

fof(bitBlastConstant_5081,axiom,
    ~ b000000011000000001010011000(bitIndex1) ).

fof(bitBlastConstant_5080,axiom,
    ~ b000000011000000001010011000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_166,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4279(VarCurr)
      <=> v4283(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_168,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4279(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_89,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4283(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_100,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4283(VarCurr)
      <=> v4285(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_100,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4283(VarCurr)
      <=> v4284(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_364,axiom,
    ! [VarCurr] :
      ( v4285(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5079,axiom,
    ~ b000000011100000001010010111(bitIndex26) ).

fof(bitBlastConstant_5078,axiom,
    ~ b000000011100000001010010111(bitIndex25) ).

fof(bitBlastConstant_5077,axiom,
    ~ b000000011100000001010010111(bitIndex24) ).

fof(bitBlastConstant_5076,axiom,
    ~ b000000011100000001010010111(bitIndex23) ).

fof(bitBlastConstant_5075,axiom,
    ~ b000000011100000001010010111(bitIndex22) ).

fof(bitBlastConstant_5074,axiom,
    ~ b000000011100000001010010111(bitIndex21) ).

fof(bitBlastConstant_5073,axiom,
    ~ b000000011100000001010010111(bitIndex20) ).

fof(bitBlastConstant_5072,axiom,
    b000000011100000001010010111(bitIndex19) ).

fof(bitBlastConstant_5071,axiom,
    b000000011100000001010010111(bitIndex18) ).

fof(bitBlastConstant_5070,axiom,
    b000000011100000001010010111(bitIndex17) ).

fof(bitBlastConstant_5069,axiom,
    ~ b000000011100000001010010111(bitIndex16) ).

fof(bitBlastConstant_5068,axiom,
    ~ b000000011100000001010010111(bitIndex15) ).

fof(bitBlastConstant_5067,axiom,
    ~ b000000011100000001010010111(bitIndex14) ).

fof(bitBlastConstant_5066,axiom,
    ~ b000000011100000001010010111(bitIndex13) ).

fof(bitBlastConstant_5065,axiom,
    ~ b000000011100000001010010111(bitIndex12) ).

fof(bitBlastConstant_5064,axiom,
    ~ b000000011100000001010010111(bitIndex11) ).

fof(bitBlastConstant_5063,axiom,
    ~ b000000011100000001010010111(bitIndex10) ).

fof(bitBlastConstant_5062,axiom,
    b000000011100000001010010111(bitIndex9) ).

fof(bitBlastConstant_5061,axiom,
    ~ b000000011100000001010010111(bitIndex8) ).

fof(bitBlastConstant_5060,axiom,
    b000000011100000001010010111(bitIndex7) ).

fof(bitBlastConstant_5059,axiom,
    ~ b000000011100000001010010111(bitIndex6) ).

fof(bitBlastConstant_5058,axiom,
    ~ b000000011100000001010010111(bitIndex5) ).

fof(bitBlastConstant_5057,axiom,
    b000000011100000001010010111(bitIndex4) ).

fof(bitBlastConstant_5056,axiom,
    ~ b000000011100000001010010111(bitIndex3) ).

fof(bitBlastConstant_5055,axiom,
    b000000011100000001010010111(bitIndex2) ).

fof(bitBlastConstant_5054,axiom,
    b000000011100000001010010111(bitIndex1) ).

fof(bitBlastConstant_5053,axiom,
    b000000011100000001010010111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_363,axiom,
    ! [VarCurr] :
      ( v4284(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_5052,axiom,
    ~ b000000011000000001010010111(bitIndex26) ).

fof(bitBlastConstant_5051,axiom,
    ~ b000000011000000001010010111(bitIndex25) ).

fof(bitBlastConstant_5050,axiom,
    ~ b000000011000000001010010111(bitIndex24) ).

fof(bitBlastConstant_5049,axiom,
    ~ b000000011000000001010010111(bitIndex23) ).

fof(bitBlastConstant_5048,axiom,
    ~ b000000011000000001010010111(bitIndex22) ).

fof(bitBlastConstant_5047,axiom,
    ~ b000000011000000001010010111(bitIndex21) ).

fof(bitBlastConstant_5046,axiom,
    ~ b000000011000000001010010111(bitIndex20) ).

fof(bitBlastConstant_5045,axiom,
    b000000011000000001010010111(bitIndex19) ).

fof(bitBlastConstant_5044,axiom,
    b000000011000000001010010111(bitIndex18) ).

fof(bitBlastConstant_5043,axiom,
    ~ b000000011000000001010010111(bitIndex17) ).

fof(bitBlastConstant_5042,axiom,
    ~ b000000011000000001010010111(bitIndex16) ).

fof(bitBlastConstant_5041,axiom,
    ~ b000000011000000001010010111(bitIndex15) ).

fof(bitBlastConstant_5040,axiom,
    ~ b000000011000000001010010111(bitIndex14) ).

fof(bitBlastConstant_5039,axiom,
    ~ b000000011000000001010010111(bitIndex13) ).

fof(bitBlastConstant_5038,axiom,
    ~ b000000011000000001010010111(bitIndex12) ).

fof(bitBlastConstant_5037,axiom,
    ~ b000000011000000001010010111(bitIndex11) ).

fof(bitBlastConstant_5036,axiom,
    ~ b000000011000000001010010111(bitIndex10) ).

fof(bitBlastConstant_5035,axiom,
    b000000011000000001010010111(bitIndex9) ).

fof(bitBlastConstant_5034,axiom,
    ~ b000000011000000001010010111(bitIndex8) ).

fof(bitBlastConstant_5033,axiom,
    b000000011000000001010010111(bitIndex7) ).

fof(bitBlastConstant_5032,axiom,
    ~ b000000011000000001010010111(bitIndex6) ).

fof(bitBlastConstant_5031,axiom,
    ~ b000000011000000001010010111(bitIndex5) ).

fof(bitBlastConstant_5030,axiom,
    b000000011000000001010010111(bitIndex4) ).

fof(bitBlastConstant_5029,axiom,
    ~ b000000011000000001010010111(bitIndex3) ).

fof(bitBlastConstant_5028,axiom,
    b000000011000000001010010111(bitIndex2) ).

fof(bitBlastConstant_5027,axiom,
    b000000011000000001010010111(bitIndex1) ).

fof(bitBlastConstant_5026,axiom,
    b000000011000000001010010111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_165,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4271(VarCurr)
      <=> v4275(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_167,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4271(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_88,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4275(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_99,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4275(VarCurr)
      <=> v4277(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_99,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4275(VarCurr)
      <=> v4276(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_362,axiom,
    ! [VarCurr] :
      ( v4277(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5025,axiom,
    ~ b000000011100000001010010110(bitIndex26) ).

fof(bitBlastConstant_5024,axiom,
    ~ b000000011100000001010010110(bitIndex25) ).

fof(bitBlastConstant_5023,axiom,
    ~ b000000011100000001010010110(bitIndex24) ).

fof(bitBlastConstant_5022,axiom,
    ~ b000000011100000001010010110(bitIndex23) ).

fof(bitBlastConstant_5021,axiom,
    ~ b000000011100000001010010110(bitIndex22) ).

fof(bitBlastConstant_5020,axiom,
    ~ b000000011100000001010010110(bitIndex21) ).

fof(bitBlastConstant_5019,axiom,
    ~ b000000011100000001010010110(bitIndex20) ).

fof(bitBlastConstant_5018,axiom,
    b000000011100000001010010110(bitIndex19) ).

fof(bitBlastConstant_5017,axiom,
    b000000011100000001010010110(bitIndex18) ).

fof(bitBlastConstant_5016,axiom,
    b000000011100000001010010110(bitIndex17) ).

fof(bitBlastConstant_5015,axiom,
    ~ b000000011100000001010010110(bitIndex16) ).

fof(bitBlastConstant_5014,axiom,
    ~ b000000011100000001010010110(bitIndex15) ).

fof(bitBlastConstant_5013,axiom,
    ~ b000000011100000001010010110(bitIndex14) ).

fof(bitBlastConstant_5012,axiom,
    ~ b000000011100000001010010110(bitIndex13) ).

fof(bitBlastConstant_5011,axiom,
    ~ b000000011100000001010010110(bitIndex12) ).

fof(bitBlastConstant_5010,axiom,
    ~ b000000011100000001010010110(bitIndex11) ).

fof(bitBlastConstant_5009,axiom,
    ~ b000000011100000001010010110(bitIndex10) ).

fof(bitBlastConstant_5008,axiom,
    b000000011100000001010010110(bitIndex9) ).

fof(bitBlastConstant_5007,axiom,
    ~ b000000011100000001010010110(bitIndex8) ).

fof(bitBlastConstant_5006,axiom,
    b000000011100000001010010110(bitIndex7) ).

fof(bitBlastConstant_5005,axiom,
    ~ b000000011100000001010010110(bitIndex6) ).

fof(bitBlastConstant_5004,axiom,
    ~ b000000011100000001010010110(bitIndex5) ).

fof(bitBlastConstant_5003,axiom,
    b000000011100000001010010110(bitIndex4) ).

fof(bitBlastConstant_5002,axiom,
    ~ b000000011100000001010010110(bitIndex3) ).

fof(bitBlastConstant_5001,axiom,
    b000000011100000001010010110(bitIndex2) ).

fof(bitBlastConstant_5000,axiom,
    b000000011100000001010010110(bitIndex1) ).

fof(bitBlastConstant_4999,axiom,
    ~ b000000011100000001010010110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_361,axiom,
    ! [VarCurr] :
      ( v4276(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4998,axiom,
    ~ b000000011000000001010010110(bitIndex26) ).

fof(bitBlastConstant_4997,axiom,
    ~ b000000011000000001010010110(bitIndex25) ).

fof(bitBlastConstant_4996,axiom,
    ~ b000000011000000001010010110(bitIndex24) ).

fof(bitBlastConstant_4995,axiom,
    ~ b000000011000000001010010110(bitIndex23) ).

fof(bitBlastConstant_4994,axiom,
    ~ b000000011000000001010010110(bitIndex22) ).

fof(bitBlastConstant_4993,axiom,
    ~ b000000011000000001010010110(bitIndex21) ).

fof(bitBlastConstant_4992,axiom,
    ~ b000000011000000001010010110(bitIndex20) ).

fof(bitBlastConstant_4991,axiom,
    b000000011000000001010010110(bitIndex19) ).

fof(bitBlastConstant_4990,axiom,
    b000000011000000001010010110(bitIndex18) ).

fof(bitBlastConstant_4989,axiom,
    ~ b000000011000000001010010110(bitIndex17) ).

fof(bitBlastConstant_4988,axiom,
    ~ b000000011000000001010010110(bitIndex16) ).

fof(bitBlastConstant_4987,axiom,
    ~ b000000011000000001010010110(bitIndex15) ).

fof(bitBlastConstant_4986,axiom,
    ~ b000000011000000001010010110(bitIndex14) ).

fof(bitBlastConstant_4985,axiom,
    ~ b000000011000000001010010110(bitIndex13) ).

fof(bitBlastConstant_4984,axiom,
    ~ b000000011000000001010010110(bitIndex12) ).

fof(bitBlastConstant_4983,axiom,
    ~ b000000011000000001010010110(bitIndex11) ).

fof(bitBlastConstant_4982,axiom,
    ~ b000000011000000001010010110(bitIndex10) ).

fof(bitBlastConstant_4981,axiom,
    b000000011000000001010010110(bitIndex9) ).

fof(bitBlastConstant_4980,axiom,
    ~ b000000011000000001010010110(bitIndex8) ).

fof(bitBlastConstant_4979,axiom,
    b000000011000000001010010110(bitIndex7) ).

fof(bitBlastConstant_4978,axiom,
    ~ b000000011000000001010010110(bitIndex6) ).

fof(bitBlastConstant_4977,axiom,
    ~ b000000011000000001010010110(bitIndex5) ).

fof(bitBlastConstant_4976,axiom,
    b000000011000000001010010110(bitIndex4) ).

fof(bitBlastConstant_4975,axiom,
    ~ b000000011000000001010010110(bitIndex3) ).

fof(bitBlastConstant_4974,axiom,
    b000000011000000001010010110(bitIndex2) ).

fof(bitBlastConstant_4973,axiom,
    b000000011000000001010010110(bitIndex1) ).

fof(bitBlastConstant_4972,axiom,
    ~ b000000011000000001010010110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_164,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4263(VarCurr)
      <=> v4267(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_166,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4263(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_87,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4267(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_98,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4267(VarCurr)
      <=> v4269(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_98,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4267(VarCurr)
      <=> v4268(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_360,axiom,
    ! [VarCurr] :
      ( v4269(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4971,axiom,
    ~ b000000011100000001010010101(bitIndex26) ).

fof(bitBlastConstant_4970,axiom,
    ~ b000000011100000001010010101(bitIndex25) ).

fof(bitBlastConstant_4969,axiom,
    ~ b000000011100000001010010101(bitIndex24) ).

fof(bitBlastConstant_4968,axiom,
    ~ b000000011100000001010010101(bitIndex23) ).

fof(bitBlastConstant_4967,axiom,
    ~ b000000011100000001010010101(bitIndex22) ).

fof(bitBlastConstant_4966,axiom,
    ~ b000000011100000001010010101(bitIndex21) ).

fof(bitBlastConstant_4965,axiom,
    ~ b000000011100000001010010101(bitIndex20) ).

fof(bitBlastConstant_4964,axiom,
    b000000011100000001010010101(bitIndex19) ).

fof(bitBlastConstant_4963,axiom,
    b000000011100000001010010101(bitIndex18) ).

fof(bitBlastConstant_4962,axiom,
    b000000011100000001010010101(bitIndex17) ).

fof(bitBlastConstant_4961,axiom,
    ~ b000000011100000001010010101(bitIndex16) ).

fof(bitBlastConstant_4960,axiom,
    ~ b000000011100000001010010101(bitIndex15) ).

fof(bitBlastConstant_4959,axiom,
    ~ b000000011100000001010010101(bitIndex14) ).

fof(bitBlastConstant_4958,axiom,
    ~ b000000011100000001010010101(bitIndex13) ).

fof(bitBlastConstant_4957,axiom,
    ~ b000000011100000001010010101(bitIndex12) ).

fof(bitBlastConstant_4956,axiom,
    ~ b000000011100000001010010101(bitIndex11) ).

fof(bitBlastConstant_4955,axiom,
    ~ b000000011100000001010010101(bitIndex10) ).

fof(bitBlastConstant_4954,axiom,
    b000000011100000001010010101(bitIndex9) ).

fof(bitBlastConstant_4953,axiom,
    ~ b000000011100000001010010101(bitIndex8) ).

fof(bitBlastConstant_4952,axiom,
    b000000011100000001010010101(bitIndex7) ).

fof(bitBlastConstant_4951,axiom,
    ~ b000000011100000001010010101(bitIndex6) ).

fof(bitBlastConstant_4950,axiom,
    ~ b000000011100000001010010101(bitIndex5) ).

fof(bitBlastConstant_4949,axiom,
    b000000011100000001010010101(bitIndex4) ).

fof(bitBlastConstant_4948,axiom,
    ~ b000000011100000001010010101(bitIndex3) ).

fof(bitBlastConstant_4947,axiom,
    b000000011100000001010010101(bitIndex2) ).

fof(bitBlastConstant_4946,axiom,
    ~ b000000011100000001010010101(bitIndex1) ).

fof(bitBlastConstant_4945,axiom,
    b000000011100000001010010101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_359,axiom,
    ! [VarCurr] :
      ( v4268(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4944,axiom,
    ~ b000000011000000001010010101(bitIndex26) ).

fof(bitBlastConstant_4943,axiom,
    ~ b000000011000000001010010101(bitIndex25) ).

fof(bitBlastConstant_4942,axiom,
    ~ b000000011000000001010010101(bitIndex24) ).

fof(bitBlastConstant_4941,axiom,
    ~ b000000011000000001010010101(bitIndex23) ).

fof(bitBlastConstant_4940,axiom,
    ~ b000000011000000001010010101(bitIndex22) ).

fof(bitBlastConstant_4939,axiom,
    ~ b000000011000000001010010101(bitIndex21) ).

fof(bitBlastConstant_4938,axiom,
    ~ b000000011000000001010010101(bitIndex20) ).

fof(bitBlastConstant_4937,axiom,
    b000000011000000001010010101(bitIndex19) ).

fof(bitBlastConstant_4936,axiom,
    b000000011000000001010010101(bitIndex18) ).

fof(bitBlastConstant_4935,axiom,
    ~ b000000011000000001010010101(bitIndex17) ).

fof(bitBlastConstant_4934,axiom,
    ~ b000000011000000001010010101(bitIndex16) ).

fof(bitBlastConstant_4933,axiom,
    ~ b000000011000000001010010101(bitIndex15) ).

fof(bitBlastConstant_4932,axiom,
    ~ b000000011000000001010010101(bitIndex14) ).

fof(bitBlastConstant_4931,axiom,
    ~ b000000011000000001010010101(bitIndex13) ).

fof(bitBlastConstant_4930,axiom,
    ~ b000000011000000001010010101(bitIndex12) ).

fof(bitBlastConstant_4929,axiom,
    ~ b000000011000000001010010101(bitIndex11) ).

fof(bitBlastConstant_4928,axiom,
    ~ b000000011000000001010010101(bitIndex10) ).

fof(bitBlastConstant_4927,axiom,
    b000000011000000001010010101(bitIndex9) ).

fof(bitBlastConstant_4926,axiom,
    ~ b000000011000000001010010101(bitIndex8) ).

fof(bitBlastConstant_4925,axiom,
    b000000011000000001010010101(bitIndex7) ).

fof(bitBlastConstant_4924,axiom,
    ~ b000000011000000001010010101(bitIndex6) ).

fof(bitBlastConstant_4923,axiom,
    ~ b000000011000000001010010101(bitIndex5) ).

fof(bitBlastConstant_4922,axiom,
    b000000011000000001010010101(bitIndex4) ).

fof(bitBlastConstant_4921,axiom,
    ~ b000000011000000001010010101(bitIndex3) ).

fof(bitBlastConstant_4920,axiom,
    b000000011000000001010010101(bitIndex2) ).

fof(bitBlastConstant_4919,axiom,
    ~ b000000011000000001010010101(bitIndex1) ).

fof(bitBlastConstant_4918,axiom,
    b000000011000000001010010101(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_163,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4255(VarCurr)
      <=> v4259(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_165,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4255(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_86,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4259(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_97,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4259(VarCurr)
      <=> v4261(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_97,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4259(VarCurr)
      <=> v4260(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_358,axiom,
    ! [VarCurr] :
      ( v4261(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4917,axiom,
    ~ b000000011100000001010010100(bitIndex26) ).

fof(bitBlastConstant_4916,axiom,
    ~ b000000011100000001010010100(bitIndex25) ).

fof(bitBlastConstant_4915,axiom,
    ~ b000000011100000001010010100(bitIndex24) ).

fof(bitBlastConstant_4914,axiom,
    ~ b000000011100000001010010100(bitIndex23) ).

fof(bitBlastConstant_4913,axiom,
    ~ b000000011100000001010010100(bitIndex22) ).

fof(bitBlastConstant_4912,axiom,
    ~ b000000011100000001010010100(bitIndex21) ).

fof(bitBlastConstant_4911,axiom,
    ~ b000000011100000001010010100(bitIndex20) ).

fof(bitBlastConstant_4910,axiom,
    b000000011100000001010010100(bitIndex19) ).

fof(bitBlastConstant_4909,axiom,
    b000000011100000001010010100(bitIndex18) ).

fof(bitBlastConstant_4908,axiom,
    b000000011100000001010010100(bitIndex17) ).

fof(bitBlastConstant_4907,axiom,
    ~ b000000011100000001010010100(bitIndex16) ).

fof(bitBlastConstant_4906,axiom,
    ~ b000000011100000001010010100(bitIndex15) ).

fof(bitBlastConstant_4905,axiom,
    ~ b000000011100000001010010100(bitIndex14) ).

fof(bitBlastConstant_4904,axiom,
    ~ b000000011100000001010010100(bitIndex13) ).

fof(bitBlastConstant_4903,axiom,
    ~ b000000011100000001010010100(bitIndex12) ).

fof(bitBlastConstant_4902,axiom,
    ~ b000000011100000001010010100(bitIndex11) ).

fof(bitBlastConstant_4901,axiom,
    ~ b000000011100000001010010100(bitIndex10) ).

fof(bitBlastConstant_4900,axiom,
    b000000011100000001010010100(bitIndex9) ).

fof(bitBlastConstant_4899,axiom,
    ~ b000000011100000001010010100(bitIndex8) ).

fof(bitBlastConstant_4898,axiom,
    b000000011100000001010010100(bitIndex7) ).

fof(bitBlastConstant_4897,axiom,
    ~ b000000011100000001010010100(bitIndex6) ).

fof(bitBlastConstant_4896,axiom,
    ~ b000000011100000001010010100(bitIndex5) ).

fof(bitBlastConstant_4895,axiom,
    b000000011100000001010010100(bitIndex4) ).

fof(bitBlastConstant_4894,axiom,
    ~ b000000011100000001010010100(bitIndex3) ).

fof(bitBlastConstant_4893,axiom,
    b000000011100000001010010100(bitIndex2) ).

fof(bitBlastConstant_4892,axiom,
    ~ b000000011100000001010010100(bitIndex1) ).

fof(bitBlastConstant_4891,axiom,
    ~ b000000011100000001010010100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_357,axiom,
    ! [VarCurr] :
      ( v4260(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $true )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $false )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4890,axiom,
    ~ b000000011000000001010010100(bitIndex26) ).

fof(bitBlastConstant_4889,axiom,
    ~ b000000011000000001010010100(bitIndex25) ).

fof(bitBlastConstant_4888,axiom,
    ~ b000000011000000001010010100(bitIndex24) ).

fof(bitBlastConstant_4887,axiom,
    ~ b000000011000000001010010100(bitIndex23) ).

fof(bitBlastConstant_4886,axiom,
    ~ b000000011000000001010010100(bitIndex22) ).

fof(bitBlastConstant_4885,axiom,
    ~ b000000011000000001010010100(bitIndex21) ).

fof(bitBlastConstant_4884,axiom,
    ~ b000000011000000001010010100(bitIndex20) ).

fof(bitBlastConstant_4883,axiom,
    b000000011000000001010010100(bitIndex19) ).

fof(bitBlastConstant_4882,axiom,
    b000000011000000001010010100(bitIndex18) ).

fof(bitBlastConstant_4881,axiom,
    ~ b000000011000000001010010100(bitIndex17) ).

fof(bitBlastConstant_4880,axiom,
    ~ b000000011000000001010010100(bitIndex16) ).

fof(bitBlastConstant_4879,axiom,
    ~ b000000011000000001010010100(bitIndex15) ).

fof(bitBlastConstant_4878,axiom,
    ~ b000000011000000001010010100(bitIndex14) ).

fof(bitBlastConstant_4877,axiom,
    ~ b000000011000000001010010100(bitIndex13) ).

fof(bitBlastConstant_4876,axiom,
    ~ b000000011000000001010010100(bitIndex12) ).

fof(bitBlastConstant_4875,axiom,
    ~ b000000011000000001010010100(bitIndex11) ).

fof(bitBlastConstant_4874,axiom,
    ~ b000000011000000001010010100(bitIndex10) ).

fof(bitBlastConstant_4873,axiom,
    b000000011000000001010010100(bitIndex9) ).

fof(bitBlastConstant_4872,axiom,
    ~ b000000011000000001010010100(bitIndex8) ).

fof(bitBlastConstant_4871,axiom,
    b000000011000000001010010100(bitIndex7) ).

fof(bitBlastConstant_4870,axiom,
    ~ b000000011000000001010010100(bitIndex6) ).

fof(bitBlastConstant_4869,axiom,
    ~ b000000011000000001010010100(bitIndex5) ).

fof(bitBlastConstant_4868,axiom,
    b000000011000000001010010100(bitIndex4) ).

fof(bitBlastConstant_4867,axiom,
    ~ b000000011000000001010010100(bitIndex3) ).

fof(bitBlastConstant_4866,axiom,
    b000000011000000001010010100(bitIndex2) ).

fof(bitBlastConstant_4865,axiom,
    ~ b000000011000000001010010100(bitIndex1) ).

fof(bitBlastConstant_4864,axiom,
    ~ b000000011000000001010010100(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_162,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4247(VarCurr)
      <=> v4251(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_164,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4247(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_85,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4251(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_96,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4251(VarCurr)
      <=> v4253(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_96,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4251(VarCurr)
      <=> v4252(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_356,axiom,
    ! [VarCurr] :
      ( v4253(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4863,axiom,
    ~ b000000011100000001000111111(bitIndex26) ).

fof(bitBlastConstant_4862,axiom,
    ~ b000000011100000001000111111(bitIndex25) ).

fof(bitBlastConstant_4861,axiom,
    ~ b000000011100000001000111111(bitIndex24) ).

fof(bitBlastConstant_4860,axiom,
    ~ b000000011100000001000111111(bitIndex23) ).

fof(bitBlastConstant_4859,axiom,
    ~ b000000011100000001000111111(bitIndex22) ).

fof(bitBlastConstant_4858,axiom,
    ~ b000000011100000001000111111(bitIndex21) ).

fof(bitBlastConstant_4857,axiom,
    ~ b000000011100000001000111111(bitIndex20) ).

fof(bitBlastConstant_4856,axiom,
    b000000011100000001000111111(bitIndex19) ).

fof(bitBlastConstant_4855,axiom,
    b000000011100000001000111111(bitIndex18) ).

fof(bitBlastConstant_4854,axiom,
    b000000011100000001000111111(bitIndex17) ).

fof(bitBlastConstant_4853,axiom,
    ~ b000000011100000001000111111(bitIndex16) ).

fof(bitBlastConstant_4852,axiom,
    ~ b000000011100000001000111111(bitIndex15) ).

fof(bitBlastConstant_4851,axiom,
    ~ b000000011100000001000111111(bitIndex14) ).

fof(bitBlastConstant_4850,axiom,
    ~ b000000011100000001000111111(bitIndex13) ).

fof(bitBlastConstant_4849,axiom,
    ~ b000000011100000001000111111(bitIndex12) ).

fof(bitBlastConstant_4848,axiom,
    ~ b000000011100000001000111111(bitIndex11) ).

fof(bitBlastConstant_4847,axiom,
    ~ b000000011100000001000111111(bitIndex10) ).

fof(bitBlastConstant_4846,axiom,
    b000000011100000001000111111(bitIndex9) ).

fof(bitBlastConstant_4845,axiom,
    ~ b000000011100000001000111111(bitIndex8) ).

fof(bitBlastConstant_4844,axiom,
    ~ b000000011100000001000111111(bitIndex7) ).

fof(bitBlastConstant_4843,axiom,
    ~ b000000011100000001000111111(bitIndex6) ).

fof(bitBlastConstant_4842,axiom,
    b000000011100000001000111111(bitIndex5) ).

fof(bitBlastConstant_4841,axiom,
    b000000011100000001000111111(bitIndex4) ).

fof(bitBlastConstant_4840,axiom,
    b000000011100000001000111111(bitIndex3) ).

fof(bitBlastConstant_4839,axiom,
    b000000011100000001000111111(bitIndex2) ).

fof(bitBlastConstant_4838,axiom,
    b000000011100000001000111111(bitIndex1) ).

fof(bitBlastConstant_4837,axiom,
    b000000011100000001000111111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_355,axiom,
    ! [VarCurr] :
      ( v4252(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4836,axiom,
    ~ b000000011000000001000111111(bitIndex26) ).

fof(bitBlastConstant_4835,axiom,
    ~ b000000011000000001000111111(bitIndex25) ).

fof(bitBlastConstant_4834,axiom,
    ~ b000000011000000001000111111(bitIndex24) ).

fof(bitBlastConstant_4833,axiom,
    ~ b000000011000000001000111111(bitIndex23) ).

fof(bitBlastConstant_4832,axiom,
    ~ b000000011000000001000111111(bitIndex22) ).

fof(bitBlastConstant_4831,axiom,
    ~ b000000011000000001000111111(bitIndex21) ).

fof(bitBlastConstant_4830,axiom,
    ~ b000000011000000001000111111(bitIndex20) ).

fof(bitBlastConstant_4829,axiom,
    b000000011000000001000111111(bitIndex19) ).

fof(bitBlastConstant_4828,axiom,
    b000000011000000001000111111(bitIndex18) ).

fof(bitBlastConstant_4827,axiom,
    ~ b000000011000000001000111111(bitIndex17) ).

fof(bitBlastConstant_4826,axiom,
    ~ b000000011000000001000111111(bitIndex16) ).

fof(bitBlastConstant_4825,axiom,
    ~ b000000011000000001000111111(bitIndex15) ).

fof(bitBlastConstant_4824,axiom,
    ~ b000000011000000001000111111(bitIndex14) ).

fof(bitBlastConstant_4823,axiom,
    ~ b000000011000000001000111111(bitIndex13) ).

fof(bitBlastConstant_4822,axiom,
    ~ b000000011000000001000111111(bitIndex12) ).

fof(bitBlastConstant_4821,axiom,
    ~ b000000011000000001000111111(bitIndex11) ).

fof(bitBlastConstant_4820,axiom,
    ~ b000000011000000001000111111(bitIndex10) ).

fof(bitBlastConstant_4819,axiom,
    b000000011000000001000111111(bitIndex9) ).

fof(bitBlastConstant_4818,axiom,
    ~ b000000011000000001000111111(bitIndex8) ).

fof(bitBlastConstant_4817,axiom,
    ~ b000000011000000001000111111(bitIndex7) ).

fof(bitBlastConstant_4816,axiom,
    ~ b000000011000000001000111111(bitIndex6) ).

fof(bitBlastConstant_4815,axiom,
    b000000011000000001000111111(bitIndex5) ).

fof(bitBlastConstant_4814,axiom,
    b000000011000000001000111111(bitIndex4) ).

fof(bitBlastConstant_4813,axiom,
    b000000011000000001000111111(bitIndex3) ).

fof(bitBlastConstant_4812,axiom,
    b000000011000000001000111111(bitIndex2) ).

fof(bitBlastConstant_4811,axiom,
    b000000011000000001000111111(bitIndex1) ).

fof(bitBlastConstant_4810,axiom,
    b000000011000000001000111111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_161,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4239(VarCurr)
      <=> v4243(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_163,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4239(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_84,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4243(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_95,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4243(VarCurr)
      <=> v4245(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_95,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4243(VarCurr)
      <=> v4244(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_354,axiom,
    ! [VarCurr] :
      ( v4245(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4809,axiom,
    ~ b000000011100000001000111110(bitIndex26) ).

fof(bitBlastConstant_4808,axiom,
    ~ b000000011100000001000111110(bitIndex25) ).

fof(bitBlastConstant_4807,axiom,
    ~ b000000011100000001000111110(bitIndex24) ).

fof(bitBlastConstant_4806,axiom,
    ~ b000000011100000001000111110(bitIndex23) ).

fof(bitBlastConstant_4805,axiom,
    ~ b000000011100000001000111110(bitIndex22) ).

fof(bitBlastConstant_4804,axiom,
    ~ b000000011100000001000111110(bitIndex21) ).

fof(bitBlastConstant_4803,axiom,
    ~ b000000011100000001000111110(bitIndex20) ).

fof(bitBlastConstant_4802,axiom,
    b000000011100000001000111110(bitIndex19) ).

fof(bitBlastConstant_4801,axiom,
    b000000011100000001000111110(bitIndex18) ).

fof(bitBlastConstant_4800,axiom,
    b000000011100000001000111110(bitIndex17) ).

fof(bitBlastConstant_4799,axiom,
    ~ b000000011100000001000111110(bitIndex16) ).

fof(bitBlastConstant_4798,axiom,
    ~ b000000011100000001000111110(bitIndex15) ).

fof(bitBlastConstant_4797,axiom,
    ~ b000000011100000001000111110(bitIndex14) ).

fof(bitBlastConstant_4796,axiom,
    ~ b000000011100000001000111110(bitIndex13) ).

fof(bitBlastConstant_4795,axiom,
    ~ b000000011100000001000111110(bitIndex12) ).

fof(bitBlastConstant_4794,axiom,
    ~ b000000011100000001000111110(bitIndex11) ).

fof(bitBlastConstant_4793,axiom,
    ~ b000000011100000001000111110(bitIndex10) ).

fof(bitBlastConstant_4792,axiom,
    b000000011100000001000111110(bitIndex9) ).

fof(bitBlastConstant_4791,axiom,
    ~ b000000011100000001000111110(bitIndex8) ).

fof(bitBlastConstant_4790,axiom,
    ~ b000000011100000001000111110(bitIndex7) ).

fof(bitBlastConstant_4789,axiom,
    ~ b000000011100000001000111110(bitIndex6) ).

fof(bitBlastConstant_4788,axiom,
    b000000011100000001000111110(bitIndex5) ).

fof(bitBlastConstant_4787,axiom,
    b000000011100000001000111110(bitIndex4) ).

fof(bitBlastConstant_4786,axiom,
    b000000011100000001000111110(bitIndex3) ).

fof(bitBlastConstant_4785,axiom,
    b000000011100000001000111110(bitIndex2) ).

fof(bitBlastConstant_4784,axiom,
    b000000011100000001000111110(bitIndex1) ).

fof(bitBlastConstant_4783,axiom,
    ~ b000000011100000001000111110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_353,axiom,
    ! [VarCurr] :
      ( v4244(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4782,axiom,
    ~ b000000011000000001000111110(bitIndex26) ).

fof(bitBlastConstant_4781,axiom,
    ~ b000000011000000001000111110(bitIndex25) ).

fof(bitBlastConstant_4780,axiom,
    ~ b000000011000000001000111110(bitIndex24) ).

fof(bitBlastConstant_4779,axiom,
    ~ b000000011000000001000111110(bitIndex23) ).

fof(bitBlastConstant_4778,axiom,
    ~ b000000011000000001000111110(bitIndex22) ).

fof(bitBlastConstant_4777,axiom,
    ~ b000000011000000001000111110(bitIndex21) ).

fof(bitBlastConstant_4776,axiom,
    ~ b000000011000000001000111110(bitIndex20) ).

fof(bitBlastConstant_4775,axiom,
    b000000011000000001000111110(bitIndex19) ).

fof(bitBlastConstant_4774,axiom,
    b000000011000000001000111110(bitIndex18) ).

fof(bitBlastConstant_4773,axiom,
    ~ b000000011000000001000111110(bitIndex17) ).

fof(bitBlastConstant_4772,axiom,
    ~ b000000011000000001000111110(bitIndex16) ).

fof(bitBlastConstant_4771,axiom,
    ~ b000000011000000001000111110(bitIndex15) ).

fof(bitBlastConstant_4770,axiom,
    ~ b000000011000000001000111110(bitIndex14) ).

fof(bitBlastConstant_4769,axiom,
    ~ b000000011000000001000111110(bitIndex13) ).

fof(bitBlastConstant_4768,axiom,
    ~ b000000011000000001000111110(bitIndex12) ).

fof(bitBlastConstant_4767,axiom,
    ~ b000000011000000001000111110(bitIndex11) ).

fof(bitBlastConstant_4766,axiom,
    ~ b000000011000000001000111110(bitIndex10) ).

fof(bitBlastConstant_4765,axiom,
    b000000011000000001000111110(bitIndex9) ).

fof(bitBlastConstant_4764,axiom,
    ~ b000000011000000001000111110(bitIndex8) ).

fof(bitBlastConstant_4763,axiom,
    ~ b000000011000000001000111110(bitIndex7) ).

fof(bitBlastConstant_4762,axiom,
    ~ b000000011000000001000111110(bitIndex6) ).

fof(bitBlastConstant_4761,axiom,
    b000000011000000001000111110(bitIndex5) ).

fof(bitBlastConstant_4760,axiom,
    b000000011000000001000111110(bitIndex4) ).

fof(bitBlastConstant_4759,axiom,
    b000000011000000001000111110(bitIndex3) ).

fof(bitBlastConstant_4758,axiom,
    b000000011000000001000111110(bitIndex2) ).

fof(bitBlastConstant_4757,axiom,
    b000000011000000001000111110(bitIndex1) ).

fof(bitBlastConstant_4756,axiom,
    ~ b000000011000000001000111110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_160,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4231(VarCurr)
      <=> v4235(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_162,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4231(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_83,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4235(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_94,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4235(VarCurr)
      <=> v4237(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_94,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4235(VarCurr)
      <=> v4236(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_352,axiom,
    ! [VarCurr] :
      ( v4237(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4755,axiom,
    ~ b000000011100000001000111011(bitIndex26) ).

fof(bitBlastConstant_4754,axiom,
    ~ b000000011100000001000111011(bitIndex25) ).

fof(bitBlastConstant_4753,axiom,
    ~ b000000011100000001000111011(bitIndex24) ).

fof(bitBlastConstant_4752,axiom,
    ~ b000000011100000001000111011(bitIndex23) ).

fof(bitBlastConstant_4751,axiom,
    ~ b000000011100000001000111011(bitIndex22) ).

fof(bitBlastConstant_4750,axiom,
    ~ b000000011100000001000111011(bitIndex21) ).

fof(bitBlastConstant_4749,axiom,
    ~ b000000011100000001000111011(bitIndex20) ).

fof(bitBlastConstant_4748,axiom,
    b000000011100000001000111011(bitIndex19) ).

fof(bitBlastConstant_4747,axiom,
    b000000011100000001000111011(bitIndex18) ).

fof(bitBlastConstant_4746,axiom,
    b000000011100000001000111011(bitIndex17) ).

fof(bitBlastConstant_4745,axiom,
    ~ b000000011100000001000111011(bitIndex16) ).

fof(bitBlastConstant_4744,axiom,
    ~ b000000011100000001000111011(bitIndex15) ).

fof(bitBlastConstant_4743,axiom,
    ~ b000000011100000001000111011(bitIndex14) ).

fof(bitBlastConstant_4742,axiom,
    ~ b000000011100000001000111011(bitIndex13) ).

fof(bitBlastConstant_4741,axiom,
    ~ b000000011100000001000111011(bitIndex12) ).

fof(bitBlastConstant_4740,axiom,
    ~ b000000011100000001000111011(bitIndex11) ).

fof(bitBlastConstant_4739,axiom,
    ~ b000000011100000001000111011(bitIndex10) ).

fof(bitBlastConstant_4738,axiom,
    b000000011100000001000111011(bitIndex9) ).

fof(bitBlastConstant_4737,axiom,
    ~ b000000011100000001000111011(bitIndex8) ).

fof(bitBlastConstant_4736,axiom,
    ~ b000000011100000001000111011(bitIndex7) ).

fof(bitBlastConstant_4735,axiom,
    ~ b000000011100000001000111011(bitIndex6) ).

fof(bitBlastConstant_4734,axiom,
    b000000011100000001000111011(bitIndex5) ).

fof(bitBlastConstant_4733,axiom,
    b000000011100000001000111011(bitIndex4) ).

fof(bitBlastConstant_4732,axiom,
    b000000011100000001000111011(bitIndex3) ).

fof(bitBlastConstant_4731,axiom,
    ~ b000000011100000001000111011(bitIndex2) ).

fof(bitBlastConstant_4730,axiom,
    b000000011100000001000111011(bitIndex1) ).

fof(bitBlastConstant_4729,axiom,
    b000000011100000001000111011(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_351,axiom,
    ! [VarCurr] :
      ( v4236(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4728,axiom,
    ~ b000000011000000001000111011(bitIndex26) ).

fof(bitBlastConstant_4727,axiom,
    ~ b000000011000000001000111011(bitIndex25) ).

fof(bitBlastConstant_4726,axiom,
    ~ b000000011000000001000111011(bitIndex24) ).

fof(bitBlastConstant_4725,axiom,
    ~ b000000011000000001000111011(bitIndex23) ).

fof(bitBlastConstant_4724,axiom,
    ~ b000000011000000001000111011(bitIndex22) ).

fof(bitBlastConstant_4723,axiom,
    ~ b000000011000000001000111011(bitIndex21) ).

fof(bitBlastConstant_4722,axiom,
    ~ b000000011000000001000111011(bitIndex20) ).

fof(bitBlastConstant_4721,axiom,
    b000000011000000001000111011(bitIndex19) ).

fof(bitBlastConstant_4720,axiom,
    b000000011000000001000111011(bitIndex18) ).

fof(bitBlastConstant_4719,axiom,
    ~ b000000011000000001000111011(bitIndex17) ).

fof(bitBlastConstant_4718,axiom,
    ~ b000000011000000001000111011(bitIndex16) ).

fof(bitBlastConstant_4717,axiom,
    ~ b000000011000000001000111011(bitIndex15) ).

fof(bitBlastConstant_4716,axiom,
    ~ b000000011000000001000111011(bitIndex14) ).

fof(bitBlastConstant_4715,axiom,
    ~ b000000011000000001000111011(bitIndex13) ).

fof(bitBlastConstant_4714,axiom,
    ~ b000000011000000001000111011(bitIndex12) ).

fof(bitBlastConstant_4713,axiom,
    ~ b000000011000000001000111011(bitIndex11) ).

fof(bitBlastConstant_4712,axiom,
    ~ b000000011000000001000111011(bitIndex10) ).

fof(bitBlastConstant_4711,axiom,
    b000000011000000001000111011(bitIndex9) ).

fof(bitBlastConstant_4710,axiom,
    ~ b000000011000000001000111011(bitIndex8) ).

fof(bitBlastConstant_4709,axiom,
    ~ b000000011000000001000111011(bitIndex7) ).

fof(bitBlastConstant_4708,axiom,
    ~ b000000011000000001000111011(bitIndex6) ).

fof(bitBlastConstant_4707,axiom,
    b000000011000000001000111011(bitIndex5) ).

fof(bitBlastConstant_4706,axiom,
    b000000011000000001000111011(bitIndex4) ).

fof(bitBlastConstant_4705,axiom,
    b000000011000000001000111011(bitIndex3) ).

fof(bitBlastConstant_4704,axiom,
    ~ b000000011000000001000111011(bitIndex2) ).

fof(bitBlastConstant_4703,axiom,
    b000000011000000001000111011(bitIndex1) ).

fof(bitBlastConstant_4702,axiom,
    b000000011000000001000111011(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_159,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4223(VarCurr)
      <=> v4227(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_161,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4223(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_82,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4227(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_93,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4227(VarCurr)
      <=> v4229(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_93,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4227(VarCurr)
      <=> v4228(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_350,axiom,
    ! [VarCurr] :
      ( v4229(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4701,axiom,
    ~ b000000011100000001000111010(bitIndex26) ).

fof(bitBlastConstant_4700,axiom,
    ~ b000000011100000001000111010(bitIndex25) ).

fof(bitBlastConstant_4699,axiom,
    ~ b000000011100000001000111010(bitIndex24) ).

fof(bitBlastConstant_4698,axiom,
    ~ b000000011100000001000111010(bitIndex23) ).

fof(bitBlastConstant_4697,axiom,
    ~ b000000011100000001000111010(bitIndex22) ).

fof(bitBlastConstant_4696,axiom,
    ~ b000000011100000001000111010(bitIndex21) ).

fof(bitBlastConstant_4695,axiom,
    ~ b000000011100000001000111010(bitIndex20) ).

fof(bitBlastConstant_4694,axiom,
    b000000011100000001000111010(bitIndex19) ).

fof(bitBlastConstant_4693,axiom,
    b000000011100000001000111010(bitIndex18) ).

fof(bitBlastConstant_4692,axiom,
    b000000011100000001000111010(bitIndex17) ).

fof(bitBlastConstant_4691,axiom,
    ~ b000000011100000001000111010(bitIndex16) ).

fof(bitBlastConstant_4690,axiom,
    ~ b000000011100000001000111010(bitIndex15) ).

fof(bitBlastConstant_4689,axiom,
    ~ b000000011100000001000111010(bitIndex14) ).

fof(bitBlastConstant_4688,axiom,
    ~ b000000011100000001000111010(bitIndex13) ).

fof(bitBlastConstant_4687,axiom,
    ~ b000000011100000001000111010(bitIndex12) ).

fof(bitBlastConstant_4686,axiom,
    ~ b000000011100000001000111010(bitIndex11) ).

fof(bitBlastConstant_4685,axiom,
    ~ b000000011100000001000111010(bitIndex10) ).

fof(bitBlastConstant_4684,axiom,
    b000000011100000001000111010(bitIndex9) ).

fof(bitBlastConstant_4683,axiom,
    ~ b000000011100000001000111010(bitIndex8) ).

fof(bitBlastConstant_4682,axiom,
    ~ b000000011100000001000111010(bitIndex7) ).

fof(bitBlastConstant_4681,axiom,
    ~ b000000011100000001000111010(bitIndex6) ).

fof(bitBlastConstant_4680,axiom,
    b000000011100000001000111010(bitIndex5) ).

fof(bitBlastConstant_4679,axiom,
    b000000011100000001000111010(bitIndex4) ).

fof(bitBlastConstant_4678,axiom,
    b000000011100000001000111010(bitIndex3) ).

fof(bitBlastConstant_4677,axiom,
    ~ b000000011100000001000111010(bitIndex2) ).

fof(bitBlastConstant_4676,axiom,
    b000000011100000001000111010(bitIndex1) ).

fof(bitBlastConstant_4675,axiom,
    ~ b000000011100000001000111010(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_349,axiom,
    ! [VarCurr] :
      ( v4228(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4674,axiom,
    ~ b000000011000000001000111010(bitIndex26) ).

fof(bitBlastConstant_4673,axiom,
    ~ b000000011000000001000111010(bitIndex25) ).

fof(bitBlastConstant_4672,axiom,
    ~ b000000011000000001000111010(bitIndex24) ).

fof(bitBlastConstant_4671,axiom,
    ~ b000000011000000001000111010(bitIndex23) ).

fof(bitBlastConstant_4670,axiom,
    ~ b000000011000000001000111010(bitIndex22) ).

fof(bitBlastConstant_4669,axiom,
    ~ b000000011000000001000111010(bitIndex21) ).

fof(bitBlastConstant_4668,axiom,
    ~ b000000011000000001000111010(bitIndex20) ).

fof(bitBlastConstant_4667,axiom,
    b000000011000000001000111010(bitIndex19) ).

fof(bitBlastConstant_4666,axiom,
    b000000011000000001000111010(bitIndex18) ).

fof(bitBlastConstant_4665,axiom,
    ~ b000000011000000001000111010(bitIndex17) ).

fof(bitBlastConstant_4664,axiom,
    ~ b000000011000000001000111010(bitIndex16) ).

fof(bitBlastConstant_4663,axiom,
    ~ b000000011000000001000111010(bitIndex15) ).

fof(bitBlastConstant_4662,axiom,
    ~ b000000011000000001000111010(bitIndex14) ).

fof(bitBlastConstant_4661,axiom,
    ~ b000000011000000001000111010(bitIndex13) ).

fof(bitBlastConstant_4660,axiom,
    ~ b000000011000000001000111010(bitIndex12) ).

fof(bitBlastConstant_4659,axiom,
    ~ b000000011000000001000111010(bitIndex11) ).

fof(bitBlastConstant_4658,axiom,
    ~ b000000011000000001000111010(bitIndex10) ).

fof(bitBlastConstant_4657,axiom,
    b000000011000000001000111010(bitIndex9) ).

fof(bitBlastConstant_4656,axiom,
    ~ b000000011000000001000111010(bitIndex8) ).

fof(bitBlastConstant_4655,axiom,
    ~ b000000011000000001000111010(bitIndex7) ).

fof(bitBlastConstant_4654,axiom,
    ~ b000000011000000001000111010(bitIndex6) ).

fof(bitBlastConstant_4653,axiom,
    b000000011000000001000111010(bitIndex5) ).

fof(bitBlastConstant_4652,axiom,
    b000000011000000001000111010(bitIndex4) ).

fof(bitBlastConstant_4651,axiom,
    b000000011000000001000111010(bitIndex3) ).

fof(bitBlastConstant_4650,axiom,
    ~ b000000011000000001000111010(bitIndex2) ).

fof(bitBlastConstant_4649,axiom,
    b000000011000000001000111010(bitIndex1) ).

fof(bitBlastConstant_4648,axiom,
    ~ b000000011000000001000111010(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_158,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4215(VarCurr)
      <=> v4219(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_160,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4215(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_81,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4219(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_92,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4219(VarCurr)
      <=> v4221(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_92,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4219(VarCurr)
      <=> v4220(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_348,axiom,
    ! [VarCurr] :
      ( v4221(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4647,axiom,
    ~ b000000011100000001000111001(bitIndex26) ).

fof(bitBlastConstant_4646,axiom,
    ~ b000000011100000001000111001(bitIndex25) ).

fof(bitBlastConstant_4645,axiom,
    ~ b000000011100000001000111001(bitIndex24) ).

fof(bitBlastConstant_4644,axiom,
    ~ b000000011100000001000111001(bitIndex23) ).

fof(bitBlastConstant_4643,axiom,
    ~ b000000011100000001000111001(bitIndex22) ).

fof(bitBlastConstant_4642,axiom,
    ~ b000000011100000001000111001(bitIndex21) ).

fof(bitBlastConstant_4641,axiom,
    ~ b000000011100000001000111001(bitIndex20) ).

fof(bitBlastConstant_4640,axiom,
    b000000011100000001000111001(bitIndex19) ).

fof(bitBlastConstant_4639,axiom,
    b000000011100000001000111001(bitIndex18) ).

fof(bitBlastConstant_4638,axiom,
    b000000011100000001000111001(bitIndex17) ).

fof(bitBlastConstant_4637,axiom,
    ~ b000000011100000001000111001(bitIndex16) ).

fof(bitBlastConstant_4636,axiom,
    ~ b000000011100000001000111001(bitIndex15) ).

fof(bitBlastConstant_4635,axiom,
    ~ b000000011100000001000111001(bitIndex14) ).

fof(bitBlastConstant_4634,axiom,
    ~ b000000011100000001000111001(bitIndex13) ).

fof(bitBlastConstant_4633,axiom,
    ~ b000000011100000001000111001(bitIndex12) ).

fof(bitBlastConstant_4632,axiom,
    ~ b000000011100000001000111001(bitIndex11) ).

fof(bitBlastConstant_4631,axiom,
    ~ b000000011100000001000111001(bitIndex10) ).

fof(bitBlastConstant_4630,axiom,
    b000000011100000001000111001(bitIndex9) ).

fof(bitBlastConstant_4629,axiom,
    ~ b000000011100000001000111001(bitIndex8) ).

fof(bitBlastConstant_4628,axiom,
    ~ b000000011100000001000111001(bitIndex7) ).

fof(bitBlastConstant_4627,axiom,
    ~ b000000011100000001000111001(bitIndex6) ).

fof(bitBlastConstant_4626,axiom,
    b000000011100000001000111001(bitIndex5) ).

fof(bitBlastConstant_4625,axiom,
    b000000011100000001000111001(bitIndex4) ).

fof(bitBlastConstant_4624,axiom,
    b000000011100000001000111001(bitIndex3) ).

fof(bitBlastConstant_4623,axiom,
    ~ b000000011100000001000111001(bitIndex2) ).

fof(bitBlastConstant_4622,axiom,
    ~ b000000011100000001000111001(bitIndex1) ).

fof(bitBlastConstant_4621,axiom,
    b000000011100000001000111001(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_347,axiom,
    ! [VarCurr] :
      ( v4220(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4620,axiom,
    ~ b000000011000000001000111001(bitIndex26) ).

fof(bitBlastConstant_4619,axiom,
    ~ b000000011000000001000111001(bitIndex25) ).

fof(bitBlastConstant_4618,axiom,
    ~ b000000011000000001000111001(bitIndex24) ).

fof(bitBlastConstant_4617,axiom,
    ~ b000000011000000001000111001(bitIndex23) ).

fof(bitBlastConstant_4616,axiom,
    ~ b000000011000000001000111001(bitIndex22) ).

fof(bitBlastConstant_4615,axiom,
    ~ b000000011000000001000111001(bitIndex21) ).

fof(bitBlastConstant_4614,axiom,
    ~ b000000011000000001000111001(bitIndex20) ).

fof(bitBlastConstant_4613,axiom,
    b000000011000000001000111001(bitIndex19) ).

fof(bitBlastConstant_4612,axiom,
    b000000011000000001000111001(bitIndex18) ).

fof(bitBlastConstant_4611,axiom,
    ~ b000000011000000001000111001(bitIndex17) ).

fof(bitBlastConstant_4610,axiom,
    ~ b000000011000000001000111001(bitIndex16) ).

fof(bitBlastConstant_4609,axiom,
    ~ b000000011000000001000111001(bitIndex15) ).

fof(bitBlastConstant_4608,axiom,
    ~ b000000011000000001000111001(bitIndex14) ).

fof(bitBlastConstant_4607,axiom,
    ~ b000000011000000001000111001(bitIndex13) ).

fof(bitBlastConstant_4606,axiom,
    ~ b000000011000000001000111001(bitIndex12) ).

fof(bitBlastConstant_4605,axiom,
    ~ b000000011000000001000111001(bitIndex11) ).

fof(bitBlastConstant_4604,axiom,
    ~ b000000011000000001000111001(bitIndex10) ).

fof(bitBlastConstant_4603,axiom,
    b000000011000000001000111001(bitIndex9) ).

fof(bitBlastConstant_4602,axiom,
    ~ b000000011000000001000111001(bitIndex8) ).

fof(bitBlastConstant_4601,axiom,
    ~ b000000011000000001000111001(bitIndex7) ).

fof(bitBlastConstant_4600,axiom,
    ~ b000000011000000001000111001(bitIndex6) ).

fof(bitBlastConstant_4599,axiom,
    b000000011000000001000111001(bitIndex5) ).

fof(bitBlastConstant_4598,axiom,
    b000000011000000001000111001(bitIndex4) ).

fof(bitBlastConstant_4597,axiom,
    b000000011000000001000111001(bitIndex3) ).

fof(bitBlastConstant_4596,axiom,
    ~ b000000011000000001000111001(bitIndex2) ).

fof(bitBlastConstant_4595,axiom,
    ~ b000000011000000001000111001(bitIndex1) ).

fof(bitBlastConstant_4594,axiom,
    b000000011000000001000111001(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_157,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4207(VarCurr)
      <=> v4211(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_159,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4207(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_80,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4211(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_91,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4211(VarCurr)
      <=> v4213(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_91,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4211(VarCurr)
      <=> v4212(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_346,axiom,
    ! [VarCurr] :
      ( v4213(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4593,axiom,
    ~ b000000011100000001000111000(bitIndex26) ).

fof(bitBlastConstant_4592,axiom,
    ~ b000000011100000001000111000(bitIndex25) ).

fof(bitBlastConstant_4591,axiom,
    ~ b000000011100000001000111000(bitIndex24) ).

fof(bitBlastConstant_4590,axiom,
    ~ b000000011100000001000111000(bitIndex23) ).

fof(bitBlastConstant_4589,axiom,
    ~ b000000011100000001000111000(bitIndex22) ).

fof(bitBlastConstant_4588,axiom,
    ~ b000000011100000001000111000(bitIndex21) ).

fof(bitBlastConstant_4587,axiom,
    ~ b000000011100000001000111000(bitIndex20) ).

fof(bitBlastConstant_4586,axiom,
    b000000011100000001000111000(bitIndex19) ).

fof(bitBlastConstant_4585,axiom,
    b000000011100000001000111000(bitIndex18) ).

fof(bitBlastConstant_4584,axiom,
    b000000011100000001000111000(bitIndex17) ).

fof(bitBlastConstant_4583,axiom,
    ~ b000000011100000001000111000(bitIndex16) ).

fof(bitBlastConstant_4582,axiom,
    ~ b000000011100000001000111000(bitIndex15) ).

fof(bitBlastConstant_4581,axiom,
    ~ b000000011100000001000111000(bitIndex14) ).

fof(bitBlastConstant_4580,axiom,
    ~ b000000011100000001000111000(bitIndex13) ).

fof(bitBlastConstant_4579,axiom,
    ~ b000000011100000001000111000(bitIndex12) ).

fof(bitBlastConstant_4578,axiom,
    ~ b000000011100000001000111000(bitIndex11) ).

fof(bitBlastConstant_4577,axiom,
    ~ b000000011100000001000111000(bitIndex10) ).

fof(bitBlastConstant_4576,axiom,
    b000000011100000001000111000(bitIndex9) ).

fof(bitBlastConstant_4575,axiom,
    ~ b000000011100000001000111000(bitIndex8) ).

fof(bitBlastConstant_4574,axiom,
    ~ b000000011100000001000111000(bitIndex7) ).

fof(bitBlastConstant_4573,axiom,
    ~ b000000011100000001000111000(bitIndex6) ).

fof(bitBlastConstant_4572,axiom,
    b000000011100000001000111000(bitIndex5) ).

fof(bitBlastConstant_4571,axiom,
    b000000011100000001000111000(bitIndex4) ).

fof(bitBlastConstant_4570,axiom,
    b000000011100000001000111000(bitIndex3) ).

fof(bitBlastConstant_4569,axiom,
    ~ b000000011100000001000111000(bitIndex2) ).

fof(bitBlastConstant_4568,axiom,
    ~ b000000011100000001000111000(bitIndex1) ).

fof(bitBlastConstant_4567,axiom,
    ~ b000000011100000001000111000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_345,axiom,
    ! [VarCurr] :
      ( v4212(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $true )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4566,axiom,
    ~ b000000011000000001000111000(bitIndex26) ).

fof(bitBlastConstant_4565,axiom,
    ~ b000000011000000001000111000(bitIndex25) ).

fof(bitBlastConstant_4564,axiom,
    ~ b000000011000000001000111000(bitIndex24) ).

fof(bitBlastConstant_4563,axiom,
    ~ b000000011000000001000111000(bitIndex23) ).

fof(bitBlastConstant_4562,axiom,
    ~ b000000011000000001000111000(bitIndex22) ).

fof(bitBlastConstant_4561,axiom,
    ~ b000000011000000001000111000(bitIndex21) ).

fof(bitBlastConstant_4560,axiom,
    ~ b000000011000000001000111000(bitIndex20) ).

fof(bitBlastConstant_4559,axiom,
    b000000011000000001000111000(bitIndex19) ).

fof(bitBlastConstant_4558,axiom,
    b000000011000000001000111000(bitIndex18) ).

fof(bitBlastConstant_4557,axiom,
    ~ b000000011000000001000111000(bitIndex17) ).

fof(bitBlastConstant_4556,axiom,
    ~ b000000011000000001000111000(bitIndex16) ).

fof(bitBlastConstant_4555,axiom,
    ~ b000000011000000001000111000(bitIndex15) ).

fof(bitBlastConstant_4554,axiom,
    ~ b000000011000000001000111000(bitIndex14) ).

fof(bitBlastConstant_4553,axiom,
    ~ b000000011000000001000111000(bitIndex13) ).

fof(bitBlastConstant_4552,axiom,
    ~ b000000011000000001000111000(bitIndex12) ).

fof(bitBlastConstant_4551,axiom,
    ~ b000000011000000001000111000(bitIndex11) ).

fof(bitBlastConstant_4550,axiom,
    ~ b000000011000000001000111000(bitIndex10) ).

fof(bitBlastConstant_4549,axiom,
    b000000011000000001000111000(bitIndex9) ).

fof(bitBlastConstant_4548,axiom,
    ~ b000000011000000001000111000(bitIndex8) ).

fof(bitBlastConstant_4547,axiom,
    ~ b000000011000000001000111000(bitIndex7) ).

fof(bitBlastConstant_4546,axiom,
    ~ b000000011000000001000111000(bitIndex6) ).

fof(bitBlastConstant_4545,axiom,
    b000000011000000001000111000(bitIndex5) ).

fof(bitBlastConstant_4544,axiom,
    b000000011000000001000111000(bitIndex4) ).

fof(bitBlastConstant_4543,axiom,
    b000000011000000001000111000(bitIndex3) ).

fof(bitBlastConstant_4542,axiom,
    ~ b000000011000000001000111000(bitIndex2) ).

fof(bitBlastConstant_4541,axiom,
    ~ b000000011000000001000111000(bitIndex1) ).

fof(bitBlastConstant_4540,axiom,
    ~ b000000011000000001000111000(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_156,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4199(VarCurr)
      <=> v4203(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_158,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4199(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_79,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4203(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_90,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4203(VarCurr)
      <=> v4205(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_90,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4203(VarCurr)
      <=> v4204(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_344,axiom,
    ! [VarCurr] :
      ( v4205(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4539,axiom,
    ~ b000000011100000001000110111(bitIndex26) ).

fof(bitBlastConstant_4538,axiom,
    ~ b000000011100000001000110111(bitIndex25) ).

fof(bitBlastConstant_4537,axiom,
    ~ b000000011100000001000110111(bitIndex24) ).

fof(bitBlastConstant_4536,axiom,
    ~ b000000011100000001000110111(bitIndex23) ).

fof(bitBlastConstant_4535,axiom,
    ~ b000000011100000001000110111(bitIndex22) ).

fof(bitBlastConstant_4534,axiom,
    ~ b000000011100000001000110111(bitIndex21) ).

fof(bitBlastConstant_4533,axiom,
    ~ b000000011100000001000110111(bitIndex20) ).

fof(bitBlastConstant_4532,axiom,
    b000000011100000001000110111(bitIndex19) ).

fof(bitBlastConstant_4531,axiom,
    b000000011100000001000110111(bitIndex18) ).

fof(bitBlastConstant_4530,axiom,
    b000000011100000001000110111(bitIndex17) ).

fof(bitBlastConstant_4529,axiom,
    ~ b000000011100000001000110111(bitIndex16) ).

fof(bitBlastConstant_4528,axiom,
    ~ b000000011100000001000110111(bitIndex15) ).

fof(bitBlastConstant_4527,axiom,
    ~ b000000011100000001000110111(bitIndex14) ).

fof(bitBlastConstant_4526,axiom,
    ~ b000000011100000001000110111(bitIndex13) ).

fof(bitBlastConstant_4525,axiom,
    ~ b000000011100000001000110111(bitIndex12) ).

fof(bitBlastConstant_4524,axiom,
    ~ b000000011100000001000110111(bitIndex11) ).

fof(bitBlastConstant_4523,axiom,
    ~ b000000011100000001000110111(bitIndex10) ).

fof(bitBlastConstant_4522,axiom,
    b000000011100000001000110111(bitIndex9) ).

fof(bitBlastConstant_4521,axiom,
    ~ b000000011100000001000110111(bitIndex8) ).

fof(bitBlastConstant_4520,axiom,
    ~ b000000011100000001000110111(bitIndex7) ).

fof(bitBlastConstant_4519,axiom,
    ~ b000000011100000001000110111(bitIndex6) ).

fof(bitBlastConstant_4518,axiom,
    b000000011100000001000110111(bitIndex5) ).

fof(bitBlastConstant_4517,axiom,
    b000000011100000001000110111(bitIndex4) ).

fof(bitBlastConstant_4516,axiom,
    ~ b000000011100000001000110111(bitIndex3) ).

fof(bitBlastConstant_4515,axiom,
    b000000011100000001000110111(bitIndex2) ).

fof(bitBlastConstant_4514,axiom,
    b000000011100000001000110111(bitIndex1) ).

fof(bitBlastConstant_4513,axiom,
    b000000011100000001000110111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_343,axiom,
    ! [VarCurr] :
      ( v4204(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4512,axiom,
    ~ b000000011000000001000110111(bitIndex26) ).

fof(bitBlastConstant_4511,axiom,
    ~ b000000011000000001000110111(bitIndex25) ).

fof(bitBlastConstant_4510,axiom,
    ~ b000000011000000001000110111(bitIndex24) ).

fof(bitBlastConstant_4509,axiom,
    ~ b000000011000000001000110111(bitIndex23) ).

fof(bitBlastConstant_4508,axiom,
    ~ b000000011000000001000110111(bitIndex22) ).

fof(bitBlastConstant_4507,axiom,
    ~ b000000011000000001000110111(bitIndex21) ).

fof(bitBlastConstant_4506,axiom,
    ~ b000000011000000001000110111(bitIndex20) ).

fof(bitBlastConstant_4505,axiom,
    b000000011000000001000110111(bitIndex19) ).

fof(bitBlastConstant_4504,axiom,
    b000000011000000001000110111(bitIndex18) ).

fof(bitBlastConstant_4503,axiom,
    ~ b000000011000000001000110111(bitIndex17) ).

fof(bitBlastConstant_4502,axiom,
    ~ b000000011000000001000110111(bitIndex16) ).

fof(bitBlastConstant_4501,axiom,
    ~ b000000011000000001000110111(bitIndex15) ).

fof(bitBlastConstant_4500,axiom,
    ~ b000000011000000001000110111(bitIndex14) ).

fof(bitBlastConstant_4499,axiom,
    ~ b000000011000000001000110111(bitIndex13) ).

fof(bitBlastConstant_4498,axiom,
    ~ b000000011000000001000110111(bitIndex12) ).

fof(bitBlastConstant_4497,axiom,
    ~ b000000011000000001000110111(bitIndex11) ).

fof(bitBlastConstant_4496,axiom,
    ~ b000000011000000001000110111(bitIndex10) ).

fof(bitBlastConstant_4495,axiom,
    b000000011000000001000110111(bitIndex9) ).

fof(bitBlastConstant_4494,axiom,
    ~ b000000011000000001000110111(bitIndex8) ).

fof(bitBlastConstant_4493,axiom,
    ~ b000000011000000001000110111(bitIndex7) ).

fof(bitBlastConstant_4492,axiom,
    ~ b000000011000000001000110111(bitIndex6) ).

fof(bitBlastConstant_4491,axiom,
    b000000011000000001000110111(bitIndex5) ).

fof(bitBlastConstant_4490,axiom,
    b000000011000000001000110111(bitIndex4) ).

fof(bitBlastConstant_4489,axiom,
    ~ b000000011000000001000110111(bitIndex3) ).

fof(bitBlastConstant_4488,axiom,
    b000000011000000001000110111(bitIndex2) ).

fof(bitBlastConstant_4487,axiom,
    b000000011000000001000110111(bitIndex1) ).

fof(bitBlastConstant_4486,axiom,
    b000000011000000001000110111(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_155,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4191(VarCurr)
      <=> v4195(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_157,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4191(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_78,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4195(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_89,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4195(VarCurr)
      <=> v4197(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_89,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4195(VarCurr)
      <=> v4196(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_342,axiom,
    ! [VarCurr] :
      ( v4197(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4485,axiom,
    ~ b000000011100000001000110110(bitIndex26) ).

fof(bitBlastConstant_4484,axiom,
    ~ b000000011100000001000110110(bitIndex25) ).

fof(bitBlastConstant_4483,axiom,
    ~ b000000011100000001000110110(bitIndex24) ).

fof(bitBlastConstant_4482,axiom,
    ~ b000000011100000001000110110(bitIndex23) ).

fof(bitBlastConstant_4481,axiom,
    ~ b000000011100000001000110110(bitIndex22) ).

fof(bitBlastConstant_4480,axiom,
    ~ b000000011100000001000110110(bitIndex21) ).

fof(bitBlastConstant_4479,axiom,
    ~ b000000011100000001000110110(bitIndex20) ).

fof(bitBlastConstant_4478,axiom,
    b000000011100000001000110110(bitIndex19) ).

fof(bitBlastConstant_4477,axiom,
    b000000011100000001000110110(bitIndex18) ).

fof(bitBlastConstant_4476,axiom,
    b000000011100000001000110110(bitIndex17) ).

fof(bitBlastConstant_4475,axiom,
    ~ b000000011100000001000110110(bitIndex16) ).

fof(bitBlastConstant_4474,axiom,
    ~ b000000011100000001000110110(bitIndex15) ).

fof(bitBlastConstant_4473,axiom,
    ~ b000000011100000001000110110(bitIndex14) ).

fof(bitBlastConstant_4472,axiom,
    ~ b000000011100000001000110110(bitIndex13) ).

fof(bitBlastConstant_4471,axiom,
    ~ b000000011100000001000110110(bitIndex12) ).

fof(bitBlastConstant_4470,axiom,
    ~ b000000011100000001000110110(bitIndex11) ).

fof(bitBlastConstant_4469,axiom,
    ~ b000000011100000001000110110(bitIndex10) ).

fof(bitBlastConstant_4468,axiom,
    b000000011100000001000110110(bitIndex9) ).

fof(bitBlastConstant_4467,axiom,
    ~ b000000011100000001000110110(bitIndex8) ).

fof(bitBlastConstant_4466,axiom,
    ~ b000000011100000001000110110(bitIndex7) ).

fof(bitBlastConstant_4465,axiom,
    ~ b000000011100000001000110110(bitIndex6) ).

fof(bitBlastConstant_4464,axiom,
    b000000011100000001000110110(bitIndex5) ).

fof(bitBlastConstant_4463,axiom,
    b000000011100000001000110110(bitIndex4) ).

fof(bitBlastConstant_4462,axiom,
    ~ b000000011100000001000110110(bitIndex3) ).

fof(bitBlastConstant_4461,axiom,
    b000000011100000001000110110(bitIndex2) ).

fof(bitBlastConstant_4460,axiom,
    b000000011100000001000110110(bitIndex1) ).

fof(bitBlastConstant_4459,axiom,
    ~ b000000011100000001000110110(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_341,axiom,
    ! [VarCurr] :
      ( v4196(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4458,axiom,
    ~ b000000011000000001000110110(bitIndex26) ).

fof(bitBlastConstant_4457,axiom,
    ~ b000000011000000001000110110(bitIndex25) ).

fof(bitBlastConstant_4456,axiom,
    ~ b000000011000000001000110110(bitIndex24) ).

fof(bitBlastConstant_4455,axiom,
    ~ b000000011000000001000110110(bitIndex23) ).

fof(bitBlastConstant_4454,axiom,
    ~ b000000011000000001000110110(bitIndex22) ).

fof(bitBlastConstant_4453,axiom,
    ~ b000000011000000001000110110(bitIndex21) ).

fof(bitBlastConstant_4452,axiom,
    ~ b000000011000000001000110110(bitIndex20) ).

fof(bitBlastConstant_4451,axiom,
    b000000011000000001000110110(bitIndex19) ).

fof(bitBlastConstant_4450,axiom,
    b000000011000000001000110110(bitIndex18) ).

fof(bitBlastConstant_4449,axiom,
    ~ b000000011000000001000110110(bitIndex17) ).

fof(bitBlastConstant_4448,axiom,
    ~ b000000011000000001000110110(bitIndex16) ).

fof(bitBlastConstant_4447,axiom,
    ~ b000000011000000001000110110(bitIndex15) ).

fof(bitBlastConstant_4446,axiom,
    ~ b000000011000000001000110110(bitIndex14) ).

fof(bitBlastConstant_4445,axiom,
    ~ b000000011000000001000110110(bitIndex13) ).

fof(bitBlastConstant_4444,axiom,
    ~ b000000011000000001000110110(bitIndex12) ).

fof(bitBlastConstant_4443,axiom,
    ~ b000000011000000001000110110(bitIndex11) ).

fof(bitBlastConstant_4442,axiom,
    ~ b000000011000000001000110110(bitIndex10) ).

fof(bitBlastConstant_4441,axiom,
    b000000011000000001000110110(bitIndex9) ).

fof(bitBlastConstant_4440,axiom,
    ~ b000000011000000001000110110(bitIndex8) ).

fof(bitBlastConstant_4439,axiom,
    ~ b000000011000000001000110110(bitIndex7) ).

fof(bitBlastConstant_4438,axiom,
    ~ b000000011000000001000110110(bitIndex6) ).

fof(bitBlastConstant_4437,axiom,
    b000000011000000001000110110(bitIndex5) ).

fof(bitBlastConstant_4436,axiom,
    b000000011000000001000110110(bitIndex4) ).

fof(bitBlastConstant_4435,axiom,
    ~ b000000011000000001000110110(bitIndex3) ).

fof(bitBlastConstant_4434,axiom,
    b000000011000000001000110110(bitIndex2) ).

fof(bitBlastConstant_4433,axiom,
    b000000011000000001000110110(bitIndex1) ).

fof(bitBlastConstant_4432,axiom,
    ~ b000000011000000001000110110(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_154,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4183(VarCurr)
      <=> v4187(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_156,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4183(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_77,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4187(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_88,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4187(VarCurr)
      <=> v4189(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_88,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4187(VarCurr)
      <=> v4188(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_340,axiom,
    ! [VarCurr] :
      ( v4189(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4431,axiom,
    ~ b000000011100000001000110101(bitIndex26) ).

fof(bitBlastConstant_4430,axiom,
    ~ b000000011100000001000110101(bitIndex25) ).

fof(bitBlastConstant_4429,axiom,
    ~ b000000011100000001000110101(bitIndex24) ).

fof(bitBlastConstant_4428,axiom,
    ~ b000000011100000001000110101(bitIndex23) ).

fof(bitBlastConstant_4427,axiom,
    ~ b000000011100000001000110101(bitIndex22) ).

fof(bitBlastConstant_4426,axiom,
    ~ b000000011100000001000110101(bitIndex21) ).

fof(bitBlastConstant_4425,axiom,
    ~ b000000011100000001000110101(bitIndex20) ).

fof(bitBlastConstant_4424,axiom,
    b000000011100000001000110101(bitIndex19) ).

fof(bitBlastConstant_4423,axiom,
    b000000011100000001000110101(bitIndex18) ).

fof(bitBlastConstant_4422,axiom,
    b000000011100000001000110101(bitIndex17) ).

fof(bitBlastConstant_4421,axiom,
    ~ b000000011100000001000110101(bitIndex16) ).

fof(bitBlastConstant_4420,axiom,
    ~ b000000011100000001000110101(bitIndex15) ).

fof(bitBlastConstant_4419,axiom,
    ~ b000000011100000001000110101(bitIndex14) ).

fof(bitBlastConstant_4418,axiom,
    ~ b000000011100000001000110101(bitIndex13) ).

fof(bitBlastConstant_4417,axiom,
    ~ b000000011100000001000110101(bitIndex12) ).

fof(bitBlastConstant_4416,axiom,
    ~ b000000011100000001000110101(bitIndex11) ).

fof(bitBlastConstant_4415,axiom,
    ~ b000000011100000001000110101(bitIndex10) ).

fof(bitBlastConstant_4414,axiom,
    b000000011100000001000110101(bitIndex9) ).

fof(bitBlastConstant_4413,axiom,
    ~ b000000011100000001000110101(bitIndex8) ).

fof(bitBlastConstant_4412,axiom,
    ~ b000000011100000001000110101(bitIndex7) ).

fof(bitBlastConstant_4411,axiom,
    ~ b000000011100000001000110101(bitIndex6) ).

fof(bitBlastConstant_4410,axiom,
    b000000011100000001000110101(bitIndex5) ).

fof(bitBlastConstant_4409,axiom,
    b000000011100000001000110101(bitIndex4) ).

fof(bitBlastConstant_4408,axiom,
    ~ b000000011100000001000110101(bitIndex3) ).

fof(bitBlastConstant_4407,axiom,
    b000000011100000001000110101(bitIndex2) ).

fof(bitBlastConstant_4406,axiom,
    ~ b000000011100000001000110101(bitIndex1) ).

fof(bitBlastConstant_4405,axiom,
    b000000011100000001000110101(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_339,axiom,
    ! [VarCurr] :
      ( v4188(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4404,axiom,
    ~ b000000011000000001000110101(bitIndex26) ).

fof(bitBlastConstant_4403,axiom,
    ~ b000000011000000001000110101(bitIndex25) ).

fof(bitBlastConstant_4402,axiom,
    ~ b000000011000000001000110101(bitIndex24) ).

fof(bitBlastConstant_4401,axiom,
    ~ b000000011000000001000110101(bitIndex23) ).

fof(bitBlastConstant_4400,axiom,
    ~ b000000011000000001000110101(bitIndex22) ).

fof(bitBlastConstant_4399,axiom,
    ~ b000000011000000001000110101(bitIndex21) ).

fof(bitBlastConstant_4398,axiom,
    ~ b000000011000000001000110101(bitIndex20) ).

fof(bitBlastConstant_4397,axiom,
    b000000011000000001000110101(bitIndex19) ).

fof(bitBlastConstant_4396,axiom,
    b000000011000000001000110101(bitIndex18) ).

fof(bitBlastConstant_4395,axiom,
    ~ b000000011000000001000110101(bitIndex17) ).

fof(bitBlastConstant_4394,axiom,
    ~ b000000011000000001000110101(bitIndex16) ).

fof(bitBlastConstant_4393,axiom,
    ~ b000000011000000001000110101(bitIndex15) ).

fof(bitBlastConstant_4392,axiom,
    ~ b000000011000000001000110101(bitIndex14) ).

fof(bitBlastConstant_4391,axiom,
    ~ b000000011000000001000110101(bitIndex13) ).

fof(bitBlastConstant_4390,axiom,
    ~ b000000011000000001000110101(bitIndex12) ).

fof(bitBlastConstant_4389,axiom,
    ~ b000000011000000001000110101(bitIndex11) ).

fof(bitBlastConstant_4388,axiom,
    ~ b000000011000000001000110101(bitIndex10) ).

fof(bitBlastConstant_4387,axiom,
    b000000011000000001000110101(bitIndex9) ).

fof(bitBlastConstant_4386,axiom,
    ~ b000000011000000001000110101(bitIndex8) ).

fof(bitBlastConstant_4385,axiom,
    ~ b000000011000000001000110101(bitIndex7) ).

fof(bitBlastConstant_4384,axiom,
    ~ b000000011000000001000110101(bitIndex6) ).

fof(bitBlastConstant_4383,axiom,
    b000000011000000001000110101(bitIndex5) ).

fof(bitBlastConstant_4382,axiom,
    b000000011000000001000110101(bitIndex4) ).

fof(bitBlastConstant_4381,axiom,
    ~ b000000011000000001000110101(bitIndex3) ).

fof(bitBlastConstant_4380,axiom,
    b000000011000000001000110101(bitIndex2) ).

fof(bitBlastConstant_4379,axiom,
    ~ b000000011000000001000110101(bitIndex1) ).

fof(bitBlastConstant_4378,axiom,
    b000000011000000001000110101(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_153,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4175(VarCurr)
      <=> v4179(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_155,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4175(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_76,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4179(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_87,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4179(VarCurr)
      <=> v4181(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_87,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4179(VarCurr)
      <=> v4180(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_338,axiom,
    ! [VarCurr] :
      ( v4181(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4377,axiom,
    ~ b000000011100000001000110100(bitIndex26) ).

fof(bitBlastConstant_4376,axiom,
    ~ b000000011100000001000110100(bitIndex25) ).

fof(bitBlastConstant_4375,axiom,
    ~ b000000011100000001000110100(bitIndex24) ).

fof(bitBlastConstant_4374,axiom,
    ~ b000000011100000001000110100(bitIndex23) ).

fof(bitBlastConstant_4373,axiom,
    ~ b000000011100000001000110100(bitIndex22) ).

fof(bitBlastConstant_4372,axiom,
    ~ b000000011100000001000110100(bitIndex21) ).

fof(bitBlastConstant_4371,axiom,
    ~ b000000011100000001000110100(bitIndex20) ).

fof(bitBlastConstant_4370,axiom,
    b000000011100000001000110100(bitIndex19) ).

fof(bitBlastConstant_4369,axiom,
    b000000011100000001000110100(bitIndex18) ).

fof(bitBlastConstant_4368,axiom,
    b000000011100000001000110100(bitIndex17) ).

fof(bitBlastConstant_4367,axiom,
    ~ b000000011100000001000110100(bitIndex16) ).

fof(bitBlastConstant_4366,axiom,
    ~ b000000011100000001000110100(bitIndex15) ).

fof(bitBlastConstant_4365,axiom,
    ~ b000000011100000001000110100(bitIndex14) ).

fof(bitBlastConstant_4364,axiom,
    ~ b000000011100000001000110100(bitIndex13) ).

fof(bitBlastConstant_4363,axiom,
    ~ b000000011100000001000110100(bitIndex12) ).

fof(bitBlastConstant_4362,axiom,
    ~ b000000011100000001000110100(bitIndex11) ).

fof(bitBlastConstant_4361,axiom,
    ~ b000000011100000001000110100(bitIndex10) ).

fof(bitBlastConstant_4360,axiom,
    b000000011100000001000110100(bitIndex9) ).

fof(bitBlastConstant_4359,axiom,
    ~ b000000011100000001000110100(bitIndex8) ).

fof(bitBlastConstant_4358,axiom,
    ~ b000000011100000001000110100(bitIndex7) ).

fof(bitBlastConstant_4357,axiom,
    ~ b000000011100000001000110100(bitIndex6) ).

fof(bitBlastConstant_4356,axiom,
    b000000011100000001000110100(bitIndex5) ).

fof(bitBlastConstant_4355,axiom,
    b000000011100000001000110100(bitIndex4) ).

fof(bitBlastConstant_4354,axiom,
    ~ b000000011100000001000110100(bitIndex3) ).

fof(bitBlastConstant_4353,axiom,
    b000000011100000001000110100(bitIndex2) ).

fof(bitBlastConstant_4352,axiom,
    ~ b000000011100000001000110100(bitIndex1) ).

fof(bitBlastConstant_4351,axiom,
    ~ b000000011100000001000110100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_337,axiom,
    ! [VarCurr] :
      ( v4180(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $false )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $true )
        & ( v3906(VarCurr,bitIndex1)
        <=> $false )
        & ( v3906(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_4350,axiom,
    ~ b000000011000000001000110100(bitIndex26) ).

fof(bitBlastConstant_4349,axiom,
    ~ b000000011000000001000110100(bitIndex25) ).

fof(bitBlastConstant_4348,axiom,
    ~ b000000011000000001000110100(bitIndex24) ).

fof(bitBlastConstant_4347,axiom,
    ~ b000000011000000001000110100(bitIndex23) ).

fof(bitBlastConstant_4346,axiom,
    ~ b000000011000000001000110100(bitIndex22) ).

fof(bitBlastConstant_4345,axiom,
    ~ b000000011000000001000110100(bitIndex21) ).

fof(bitBlastConstant_4344,axiom,
    ~ b000000011000000001000110100(bitIndex20) ).

fof(bitBlastConstant_4343,axiom,
    b000000011000000001000110100(bitIndex19) ).

fof(bitBlastConstant_4342,axiom,
    b000000011000000001000110100(bitIndex18) ).

fof(bitBlastConstant_4341,axiom,
    ~ b000000011000000001000110100(bitIndex17) ).

fof(bitBlastConstant_4340,axiom,
    ~ b000000011000000001000110100(bitIndex16) ).

fof(bitBlastConstant_4339,axiom,
    ~ b000000011000000001000110100(bitIndex15) ).

fof(bitBlastConstant_4338,axiom,
    ~ b000000011000000001000110100(bitIndex14) ).

fof(bitBlastConstant_4337,axiom,
    ~ b000000011000000001000110100(bitIndex13) ).

fof(bitBlastConstant_4336,axiom,
    ~ b000000011000000001000110100(bitIndex12) ).

fof(bitBlastConstant_4335,axiom,
    ~ b000000011000000001000110100(bitIndex11) ).

fof(bitBlastConstant_4334,axiom,
    ~ b000000011000000001000110100(bitIndex10) ).

fof(bitBlastConstant_4333,axiom,
    b000000011000000001000110100(bitIndex9) ).

fof(bitBlastConstant_4332,axiom,
    ~ b000000011000000001000110100(bitIndex8) ).

fof(bitBlastConstant_4331,axiom,
    ~ b000000011000000001000110100(bitIndex7) ).

fof(bitBlastConstant_4330,axiom,
    ~ b000000011000000001000110100(bitIndex6) ).

fof(bitBlastConstant_4329,axiom,
    b000000011000000001000110100(bitIndex5) ).

fof(bitBlastConstant_4328,axiom,
    b000000011000000001000110100(bitIndex4) ).

fof(bitBlastConstant_4327,axiom,
    ~ b000000011000000001000110100(bitIndex3) ).

fof(bitBlastConstant_4326,axiom,
    b000000011000000001000110100(bitIndex2) ).

fof(bitBlastConstant_4325,axiom,
    ~ b000000011000000001000110100(bitIndex1) ).

fof(bitBlastConstant_4324,axiom,
    ~ b000000011000000001000110100(bitIndex0) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_152,axiom,
    ! [VarCurr] :
      ( ~ v3920(VarCurr)
     => ( v4167(VarCurr)
      <=> v4171(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_154,axiom,
    ! [VarCurr] :
      ( v3920(VarCurr)
     => ( v4167(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_75,axiom,
    ! [VarCurr] :
      ( ( ~ v3922(VarCurr)
        & ~ v3924(VarCurr) )
     => ( v4171(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_86,axiom,
    ! [VarCurr] :
      ( v3924(VarCurr)
     => ( v4171(VarCurr)
      <=> v4173(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_86,axiom,
    ! [VarCurr] :
      ( v3922(VarCurr)
     => ( v4171(VarCurr)
      <=> v4172(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_336,axiom,
    ! [VarCurr] :
      ( v4173(VarCurr)
    <=> ( ( v3906(VarCurr,bitIndex26)
        <=> $false )
        & ( v3906(VarCurr,bitIndex25)
        <=> $false )
        & ( v3906(VarCurr,bitIndex24)
        <=> $false )
        & ( v3906(VarCurr,bitIndex23)
        <=> $false )
        & ( v3906(VarCurr,bitIndex22)
        <=> $false )
        & ( v3906(VarCurr,bitIndex21)
        <=> $false )
        & ( v3906(VarCurr,bitIndex20)
        <=> $false )
        & ( v3906(VarCurr,bitIndex19)
        <=> $true )
        & ( v3906(VarCurr,bitIndex18)
        <=> $true )
        & ( v3906(VarCurr,bitIndex17)
        <=> $true )
        & ( v3906(VarCurr,bitIndex16)
        <=> $false )
        & ( v3906(VarCurr,bitIndex15)
        <=> $false )
        & ( v3906(VarCurr,bitIndex14)
        <=> $false )
        & ( v3906(VarCurr,bitIndex13)
        <=> $false )
        & ( v3906(VarCurr,bitIndex12)
        <=> $false )
        & ( v3906(VarCurr,bitIndex11)
        <=> $false )
        & ( v3906(VarCurr,bitIndex10)
        <=> $false )
        & ( v3906(VarCurr,bitIndex9)
        <=> $true )
        & ( v3906(VarCurr,bitIndex8)
        <=> $false )
        & ( v3906(VarCurr,bitIndex7)
        <=> $false )
        & ( v3906(VarCurr,bitIndex6)
        <=> $false )
        & ( v3906(VarCurr,bitIndex5)
        <=> $true )
        & ( v3906(VarCurr,bitIndex4)
        <=> $true )
        & ( v3906(VarCurr,bitIndex3)
        <=> $false )
        & ( v3906(VarCurr,bitIndex2)
        <=> $false )
        & ( v3906(VarCurr,bitIndex1)
        <=> $true )
        & ( v3906(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_4323,axiom,
    ~ b000000011100000001000110011(bitIndex26) ).

fof(bitBlastConstant_4322,axiom,
    ~ b000000011100000001000110011(bitIndex25) ).

fof(bitBlastConstant_4321,axiom,
    ~ b000000011100000001000110011(bitIndex24) ).

fof(bitBlastConstant_4320,axiom,
    ~ b000000011100000001000110011(bitIndex23) ).

fof(bitBlastConstant_4319,axiom,
    ~ b000000011100000001000110011(bitIndex22) ).

fof(bitBlastConstant_4318,axiom,
    ~ b000000011100000001000110011(bitIndex21) ).

fof(bitBlastConstant_4317,axiom,
    ~ b00000001110000000100011