%------------------------------------------------------------------------------
% File     : HWV096+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 7 cone of influence 10_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop7_cone10_b20 [Kha14]

% Status   : Theorem
% Rating   : 0.85 v9.0.0, 0.83 v8.2.0, 0.86 v8.1.0, 0.78 v7.5.0, 0.72 v7.4.0, 0.93 v7.1.0, 0.87 v7.0.0, 0.83 v6.4.0, 0.81 v6.3.0, 0.83 v6.2.0, 0.88 v6.1.0
% Syntax   : Number of formulae    : 134641 (13461 unt;   0 def)
%            Number of atoms       : 467404 (5092 equ)
%            Maximal formula atoms :  264 (   3 avg)
%            Number of connectives : 378116 (45353   ~;16542   |;84323   &)
%                                         (184223 <=>;47660  =>;   0  <=;  15 <~>)
%            Maximal formula depth :  258 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 86928 (86925 usr;   2 prp; 0-3 aty)
%            Number of functors    : 2317 (2317 usr;2317 con; 0-0 aty)
%            Number of variables   : 142464 (142464   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(address_false_msb_41,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_167,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v104038(constB20,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v104038(constB20,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v104038(constB20,bitIndex2) ) ) ).

fof(is_address_183,axiom,
    address(v104038_range_2_to_0_address_term_bound_20) ).

fof(address_association_167,axiom,
    v104038_range_2_to_0_address_association(constB20,v104038_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_40,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_166,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v104038(constB19,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v104038(constB19,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v104038(constB19,bitIndex2) ) ) ).

fof(is_address_182,axiom,
    address(v104038_range_2_to_0_address_term_bound_19) ).

fof(address_association_166,axiom,
    v104038_range_2_to_0_address_association(constB19,v104038_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_39,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_165,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v104038(constB18,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v104038(constB18,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v104038(constB18,bitIndex2) ) ) ).

fof(is_address_181,axiom,
    address(v104038_range_2_to_0_address_term_bound_18) ).

fof(address_association_165,axiom,
    v104038_range_2_to_0_address_association(constB18,v104038_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_38,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_164,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v104038(constB17,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v104038(constB17,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v104038(constB17,bitIndex2) ) ) ).

fof(is_address_180,axiom,
    address(v104038_range_2_to_0_address_term_bound_17) ).

fof(address_association_164,axiom,
    v104038_range_2_to_0_address_association(constB17,v104038_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_37,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_163,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v104038(constB16,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v104038(constB16,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v104038(constB16,bitIndex2) ) ) ).

fof(is_address_179,axiom,
    address(v104038_range_2_to_0_address_term_bound_16) ).

fof(address_association_163,axiom,
    v104038_range_2_to_0_address_association(constB16,v104038_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_36,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_162,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v104038(constB15,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v104038(constB15,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v104038(constB15,bitIndex2) ) ) ).

fof(is_address_178,axiom,
    address(v104038_range_2_to_0_address_term_bound_15) ).

fof(address_association_162,axiom,
    v104038_range_2_to_0_address_association(constB15,v104038_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_35,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_161,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v104038(constB14,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v104038(constB14,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v104038(constB14,bitIndex2) ) ) ).

fof(is_address_177,axiom,
    address(v104038_range_2_to_0_address_term_bound_14) ).

fof(address_association_161,axiom,
    v104038_range_2_to_0_address_association(constB14,v104038_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_34,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_160,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v104038(constB13,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v104038(constB13,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v104038(constB13,bitIndex2) ) ) ).

fof(is_address_176,axiom,
    address(v104038_range_2_to_0_address_term_bound_13) ).

fof(address_association_160,axiom,
    v104038_range_2_to_0_address_association(constB13,v104038_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_33,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_159,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v104038(constB12,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v104038(constB12,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v104038(constB12,bitIndex2) ) ) ).

fof(is_address_175,axiom,
    address(v104038_range_2_to_0_address_term_bound_12) ).

fof(address_association_159,axiom,
    v104038_range_2_to_0_address_association(constB12,v104038_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_32,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_158,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v104038(constB11,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v104038(constB11,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v104038(constB11,bitIndex2) ) ) ).

fof(is_address_174,axiom,
    address(v104038_range_2_to_0_address_term_bound_11) ).

fof(address_association_158,axiom,
    v104038_range_2_to_0_address_association(constB11,v104038_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_31,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_157,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v104038(constB10,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v104038(constB10,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v104038(constB10,bitIndex2) ) ) ).

fof(is_address_173,axiom,
    address(v104038_range_2_to_0_address_term_bound_10) ).

fof(address_association_157,axiom,
    v104038_range_2_to_0_address_association(constB10,v104038_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_30,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_156,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v104038(constB9,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v104038(constB9,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v104038(constB9,bitIndex2) ) ) ).

fof(is_address_172,axiom,
    address(v104038_range_2_to_0_address_term_bound_9) ).

fof(address_association_156,axiom,
    v104038_range_2_to_0_address_association(constB9,v104038_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_29,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_155,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v104038(constB8,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v104038(constB8,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v104038(constB8,bitIndex2) ) ) ).

fof(is_address_171,axiom,
    address(v104038_range_2_to_0_address_term_bound_8) ).

fof(address_association_155,axiom,
    v104038_range_2_to_0_address_association(constB8,v104038_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_28,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_154,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v104038(constB7,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v104038(constB7,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v104038(constB7,bitIndex2) ) ) ).

fof(is_address_170,axiom,
    address(v104038_range_2_to_0_address_term_bound_7) ).

fof(address_association_154,axiom,
    v104038_range_2_to_0_address_association(constB7,v104038_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_27,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_153,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v104038(constB6,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v104038(constB6,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v104038(constB6,bitIndex2) ) ) ).

fof(is_address_169,axiom,
    address(v104038_range_2_to_0_address_term_bound_6) ).

fof(address_association_153,axiom,
    v104038_range_2_to_0_address_association(constB6,v104038_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_26,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_152,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v104038(constB5,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v104038(constB5,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v104038(constB5,bitIndex2) ) ) ).

fof(is_address_168,axiom,
    address(v104038_range_2_to_0_address_term_bound_5) ).

fof(address_association_152,axiom,
    v104038_range_2_to_0_address_association(constB5,v104038_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_25,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_151,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v104038(constB4,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v104038(constB4,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v104038(constB4,bitIndex2) ) ) ).

fof(is_address_167,axiom,
    address(v104038_range_2_to_0_address_term_bound_4) ).

fof(address_association_151,axiom,
    v104038_range_2_to_0_address_association(constB4,v104038_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_24,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_150,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v104038(constB3,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v104038(constB3,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v104038(constB3,bitIndex2) ) ) ).

fof(is_address_166,axiom,
    address(v104038_range_2_to_0_address_term_bound_3) ).

fof(address_association_150,axiom,
    v104038_range_2_to_0_address_association(constB3,v104038_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_23,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_149,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v104038(constB2,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v104038(constB2,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v104038(constB2,bitIndex2) ) ) ).

fof(is_address_165,axiom,
    address(v104038_range_2_to_0_address_term_bound_2) ).

fof(address_association_149,axiom,
    v104038_range_2_to_0_address_association(constB2,v104038_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_22,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_148,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v104038(constB1,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v104038(constB1,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v104038(constB1,bitIndex2) ) ) ).

fof(is_address_164,axiom,
    address(v104038_range_2_to_0_address_term_bound_1) ).

fof(address_association_148,axiom,
    v104038_range_2_to_0_address_association(constB1,v104038_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_21,axiom,
    ~ addressVal(v104038_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_147,axiom,
    ( $true
    & ( addressVal(v104038_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v104038(constB0,bitIndex0) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v104038(constB0,bitIndex1) )
    & ( addressVal(v104038_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v104038(constB0,bitIndex2) ) ) ).

fof(is_address_163,axiom,
    address(v104038_range_2_to_0_address_term_bound_0) ).

fof(address_association_147,axiom,
    v104038_range_2_to_0_address_association(constB0,v104038_range_2_to_0_address_term_bound_0) ).

fof(address_false_msb_20,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_146,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v103978(constB20,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v103978(constB20,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v103978(constB20,bitIndex2) ) ) ).

fof(is_address_162,axiom,
    address(v103978_range_2_to_0_address_term_bound_20) ).

fof(address_association_146,axiom,
    v103978_range_2_to_0_address_association(constB20,v103978_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_19,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_145,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v103978(constB19,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v103978(constB19,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v103978(constB19,bitIndex2) ) ) ).

fof(is_address_161,axiom,
    address(v103978_range_2_to_0_address_term_bound_19) ).

fof(address_association_145,axiom,
    v103978_range_2_to_0_address_association(constB19,v103978_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_18,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_144,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v103978(constB18,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v103978(constB18,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v103978(constB18,bitIndex2) ) ) ).

fof(is_address_160,axiom,
    address(v103978_range_2_to_0_address_term_bound_18) ).

fof(address_association_144,axiom,
    v103978_range_2_to_0_address_association(constB18,v103978_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_17,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_143,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v103978(constB17,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v103978(constB17,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v103978(constB17,bitIndex2) ) ) ).

fof(is_address_159,axiom,
    address(v103978_range_2_to_0_address_term_bound_17) ).

fof(address_association_143,axiom,
    v103978_range_2_to_0_address_association(constB17,v103978_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_16,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_142,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v103978(constB16,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v103978(constB16,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v103978(constB16,bitIndex2) ) ) ).

fof(is_address_158,axiom,
    address(v103978_range_2_to_0_address_term_bound_16) ).

fof(address_association_142,axiom,
    v103978_range_2_to_0_address_association(constB16,v103978_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_15,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_141,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v103978(constB15,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v103978(constB15,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v103978(constB15,bitIndex2) ) ) ).

fof(is_address_157,axiom,
    address(v103978_range_2_to_0_address_term_bound_15) ).

fof(address_association_141,axiom,
    v103978_range_2_to_0_address_association(constB15,v103978_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_14,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_140,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v103978(constB14,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v103978(constB14,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v103978(constB14,bitIndex2) ) ) ).

fof(is_address_156,axiom,
    address(v103978_range_2_to_0_address_term_bound_14) ).

fof(address_association_140,axiom,
    v103978_range_2_to_0_address_association(constB14,v103978_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_13,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_139,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v103978(constB13,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v103978(constB13,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v103978(constB13,bitIndex2) ) ) ).

fof(is_address_155,axiom,
    address(v103978_range_2_to_0_address_term_bound_13) ).

fof(address_association_139,axiom,
    v103978_range_2_to_0_address_association(constB13,v103978_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_12,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_138,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v103978(constB12,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v103978(constB12,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v103978(constB12,bitIndex2) ) ) ).

fof(is_address_154,axiom,
    address(v103978_range_2_to_0_address_term_bound_12) ).

fof(address_association_138,axiom,
    v103978_range_2_to_0_address_association(constB12,v103978_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_11,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_137,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v103978(constB11,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v103978(constB11,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v103978(constB11,bitIndex2) ) ) ).

fof(is_address_153,axiom,
    address(v103978_range_2_to_0_address_term_bound_11) ).

fof(address_association_137,axiom,
    v103978_range_2_to_0_address_association(constB11,v103978_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_10,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_136,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v103978(constB10,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v103978(constB10,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v103978(constB10,bitIndex2) ) ) ).

fof(is_address_152,axiom,
    address(v103978_range_2_to_0_address_term_bound_10) ).

fof(address_association_136,axiom,
    v103978_range_2_to_0_address_association(constB10,v103978_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_9,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_135,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v103978(constB9,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v103978(constB9,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v103978(constB9,bitIndex2) ) ) ).

fof(is_address_151,axiom,
    address(v103978_range_2_to_0_address_term_bound_9) ).

fof(address_association_135,axiom,
    v103978_range_2_to_0_address_association(constB9,v103978_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_8,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_134,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v103978(constB8,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v103978(constB8,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v103978(constB8,bitIndex2) ) ) ).

fof(is_address_150,axiom,
    address(v103978_range_2_to_0_address_term_bound_8) ).

fof(address_association_134,axiom,
    v103978_range_2_to_0_address_association(constB8,v103978_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_7,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_133,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v103978(constB7,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v103978(constB7,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v103978(constB7,bitIndex2) ) ) ).

fof(is_address_149,axiom,
    address(v103978_range_2_to_0_address_term_bound_7) ).

fof(address_association_133,axiom,
    v103978_range_2_to_0_address_association(constB7,v103978_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_6,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_132,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v103978(constB6,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v103978(constB6,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v103978(constB6,bitIndex2) ) ) ).

fof(is_address_148,axiom,
    address(v103978_range_2_to_0_address_term_bound_6) ).

fof(address_association_132,axiom,
    v103978_range_2_to_0_address_association(constB6,v103978_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_5,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_131,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v103978(constB5,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v103978(constB5,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v103978(constB5,bitIndex2) ) ) ).

fof(is_address_147,axiom,
    address(v103978_range_2_to_0_address_term_bound_5) ).

fof(address_association_131,axiom,
    v103978_range_2_to_0_address_association(constB5,v103978_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_4,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_130,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v103978(constB4,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v103978(constB4,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v103978(constB4,bitIndex2) ) ) ).

fof(is_address_146,axiom,
    address(v103978_range_2_to_0_address_term_bound_4) ).

fof(address_association_130,axiom,
    v103978_range_2_to_0_address_association(constB4,v103978_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_3,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_129,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v103978(constB3,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v103978(constB3,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v103978(constB3,bitIndex2) ) ) ).

fof(is_address_145,axiom,
    address(v103978_range_2_to_0_address_term_bound_3) ).

fof(address_association_129,axiom,
    v103978_range_2_to_0_address_association(constB3,v103978_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_2,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_128,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v103978(constB2,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v103978(constB2,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v103978(constB2,bitIndex2) ) ) ).

fof(is_address_144,axiom,
    address(v103978_range_2_to_0_address_term_bound_2) ).

fof(address_association_128,axiom,
    v103978_range_2_to_0_address_association(constB2,v103978_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_1,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_127,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v103978(constB1,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v103978(constB1,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v103978(constB1,bitIndex2) ) ) ).

fof(is_address_143,axiom,
    address(v103978_range_2_to_0_address_term_bound_1) ).

fof(address_association_127,axiom,
    v103978_range_2_to_0_address_association(constB1,v103978_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb,axiom,
    ~ addressVal(v103978_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_126,axiom,
    ( $true
    & ( addressVal(v103978_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v103978(constB0,bitIndex0) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v103978(constB0,bitIndex1) )
    & ( addressVal(v103978_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v103978(constB0,bitIndex2) ) ) ).

fof(is_address_142,axiom,
    address(v103978_range_2_to_0_address_term_bound_0) ).

fof(address_association_126,axiom,
    v103978_range_2_to_0_address_association(constB0,v103978_range_2_to_0_address_term_bound_0) ).

fof(transient_address_definition_125,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_20,B)
    <=> v15235(constB20,B) ) ).

fof(is_address_141,axiom,
    address(v15235_range_3_to_0_address_term_bound_20) ).

fof(address_association_125,axiom,
    v15235_range_3_to_0_address_association(constB20,v15235_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_124,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_19,B)
    <=> v15235(constB19,B) ) ).

fof(is_address_140,axiom,
    address(v15235_range_3_to_0_address_term_bound_19) ).

fof(address_association_124,axiom,
    v15235_range_3_to_0_address_association(constB19,v15235_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_123,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_18,B)
    <=> v15235(constB18,B) ) ).

fof(is_address_139,axiom,
    address(v15235_range_3_to_0_address_term_bound_18) ).

fof(address_association_123,axiom,
    v15235_range_3_to_0_address_association(constB18,v15235_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_122,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_17,B)
    <=> v15235(constB17,B) ) ).

fof(is_address_138,axiom,
    address(v15235_range_3_to_0_address_term_bound_17) ).

fof(address_association_122,axiom,
    v15235_range_3_to_0_address_association(constB17,v15235_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_121,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_16,B)
    <=> v15235(constB16,B) ) ).

fof(is_address_137,axiom,
    address(v15235_range_3_to_0_address_term_bound_16) ).

fof(address_association_121,axiom,
    v15235_range_3_to_0_address_association(constB16,v15235_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_120,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_15,B)
    <=> v15235(constB15,B) ) ).

fof(is_address_136,axiom,
    address(v15235_range_3_to_0_address_term_bound_15) ).

fof(address_association_120,axiom,
    v15235_range_3_to_0_address_association(constB15,v15235_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_119,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_14,B)
    <=> v15235(constB14,B) ) ).

fof(is_address_135,axiom,
    address(v15235_range_3_to_0_address_term_bound_14) ).

fof(address_association_119,axiom,
    v15235_range_3_to_0_address_association(constB14,v15235_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_118,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_13,B)
    <=> v15235(constB13,B) ) ).

fof(is_address_134,axiom,
    address(v15235_range_3_to_0_address_term_bound_13) ).

fof(address_association_118,axiom,
    v15235_range_3_to_0_address_association(constB13,v15235_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_117,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_12,B)
    <=> v15235(constB12,B) ) ).

fof(is_address_133,axiom,
    address(v15235_range_3_to_0_address_term_bound_12) ).

fof(address_association_117,axiom,
    v15235_range_3_to_0_address_association(constB12,v15235_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_116,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_11,B)
    <=> v15235(constB11,B) ) ).

fof(is_address_132,axiom,
    address(v15235_range_3_to_0_address_term_bound_11) ).

fof(address_association_116,axiom,
    v15235_range_3_to_0_address_association(constB11,v15235_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_115,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_10,B)
    <=> v15235(constB10,B) ) ).

fof(is_address_131,axiom,
    address(v15235_range_3_to_0_address_term_bound_10) ).

fof(address_association_115,axiom,
    v15235_range_3_to_0_address_association(constB10,v15235_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_114,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_9,B)
    <=> v15235(constB9,B) ) ).

fof(is_address_130,axiom,
    address(v15235_range_3_to_0_address_term_bound_9) ).

fof(address_association_114,axiom,
    v15235_range_3_to_0_address_association(constB9,v15235_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_113,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_8,B)
    <=> v15235(constB8,B) ) ).

fof(is_address_129,axiom,
    address(v15235_range_3_to_0_address_term_bound_8) ).

fof(address_association_113,axiom,
    v15235_range_3_to_0_address_association(constB8,v15235_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_112,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_7,B)
    <=> v15235(constB7,B) ) ).

fof(is_address_128,axiom,
    address(v15235_range_3_to_0_address_term_bound_7) ).

fof(address_association_112,axiom,
    v15235_range_3_to_0_address_association(constB7,v15235_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_111,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_6,B)
    <=> v15235(constB6,B) ) ).

fof(is_address_127,axiom,
    address(v15235_range_3_to_0_address_term_bound_6) ).

fof(address_association_111,axiom,
    v15235_range_3_to_0_address_association(constB6,v15235_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_110,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_5,B)
    <=> v15235(constB5,B) ) ).

fof(is_address_126,axiom,
    address(v15235_range_3_to_0_address_term_bound_5) ).

fof(address_association_110,axiom,
    v15235_range_3_to_0_address_association(constB5,v15235_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_109,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_4,B)
    <=> v15235(constB4,B) ) ).

fof(is_address_125,axiom,
    address(v15235_range_3_to_0_address_term_bound_4) ).

fof(address_association_109,axiom,
    v15235_range_3_to_0_address_association(constB4,v15235_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_108,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_3,B)
    <=> v15235(constB3,B) ) ).

fof(is_address_124,axiom,
    address(v15235_range_3_to_0_address_term_bound_3) ).

fof(address_association_108,axiom,
    v15235_range_3_to_0_address_association(constB3,v15235_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_107,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_2,B)
    <=> v15235(constB2,B) ) ).

fof(is_address_123,axiom,
    address(v15235_range_3_to_0_address_term_bound_2) ).

fof(address_association_107,axiom,
    v15235_range_3_to_0_address_association(constB2,v15235_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_106,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_1,B)
    <=> v15235(constB1,B) ) ).

fof(is_address_122,axiom,
    address(v15235_range_3_to_0_address_term_bound_1) ).

fof(address_association_106,axiom,
    v15235_range_3_to_0_address_association(constB1,v15235_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_105,axiom,
    ! [B] :
      ( addressVal(v15235_range_3_to_0_address_term_bound_0,B)
    <=> v15235(constB0,B) ) ).

fof(is_address_121,axiom,
    address(v15235_range_3_to_0_address_term_bound_0) ).

fof(address_association_105,axiom,
    v15235_range_3_to_0_address_association(constB0,v15235_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_104,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_20,B)
    <=> v15169(constB20,B) ) ).

fof(is_address_120,axiom,
    address(v15169_range_3_to_0_address_term_bound_20) ).

fof(address_association_104,axiom,
    v15169_range_3_to_0_address_association(constB20,v15169_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_103,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_19,B)
    <=> v15169(constB19,B) ) ).

fof(is_address_119,axiom,
    address(v15169_range_3_to_0_address_term_bound_19) ).

fof(address_association_103,axiom,
    v15169_range_3_to_0_address_association(constB19,v15169_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_102,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_18,B)
    <=> v15169(constB18,B) ) ).

fof(is_address_118,axiom,
    address(v15169_range_3_to_0_address_term_bound_18) ).

fof(address_association_102,axiom,
    v15169_range_3_to_0_address_association(constB18,v15169_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_101,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_17,B)
    <=> v15169(constB17,B) ) ).

fof(is_address_117,axiom,
    address(v15169_range_3_to_0_address_term_bound_17) ).

fof(address_association_101,axiom,
    v15169_range_3_to_0_address_association(constB17,v15169_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_100,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_16,B)
    <=> v15169(constB16,B) ) ).

fof(is_address_116,axiom,
    address(v15169_range_3_to_0_address_term_bound_16) ).

fof(address_association_100,axiom,
    v15169_range_3_to_0_address_association(constB16,v15169_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_99,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_15,B)
    <=> v15169(constB15,B) ) ).

fof(is_address_115,axiom,
    address(v15169_range_3_to_0_address_term_bound_15) ).

fof(address_association_99,axiom,
    v15169_range_3_to_0_address_association(constB15,v15169_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_98,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_14,B)
    <=> v15169(constB14,B) ) ).

fof(is_address_114,axiom,
    address(v15169_range_3_to_0_address_term_bound_14) ).

fof(address_association_98,axiom,
    v15169_range_3_to_0_address_association(constB14,v15169_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_97,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_13,B)
    <=> v15169(constB13,B) ) ).

fof(is_address_113,axiom,
    address(v15169_range_3_to_0_address_term_bound_13) ).

fof(address_association_97,axiom,
    v15169_range_3_to_0_address_association(constB13,v15169_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_96,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_12,B)
    <=> v15169(constB12,B) ) ).

fof(is_address_112,axiom,
    address(v15169_range_3_to_0_address_term_bound_12) ).

fof(address_association_96,axiom,
    v15169_range_3_to_0_address_association(constB12,v15169_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_95,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_11,B)
    <=> v15169(constB11,B) ) ).

fof(is_address_111,axiom,
    address(v15169_range_3_to_0_address_term_bound_11) ).

fof(address_association_95,axiom,
    v15169_range_3_to_0_address_association(constB11,v15169_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_94,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_10,B)
    <=> v15169(constB10,B) ) ).

fof(is_address_110,axiom,
    address(v15169_range_3_to_0_address_term_bound_10) ).

fof(address_association_94,axiom,
    v15169_range_3_to_0_address_association(constB10,v15169_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_93,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_9,B)
    <=> v15169(constB9,B) ) ).

fof(is_address_109,axiom,
    address(v15169_range_3_to_0_address_term_bound_9) ).

fof(address_association_93,axiom,
    v15169_range_3_to_0_address_association(constB9,v15169_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_92,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_8,B)
    <=> v15169(constB8,B) ) ).

fof(is_address_108,axiom,
    address(v15169_range_3_to_0_address_term_bound_8) ).

fof(address_association_92,axiom,
    v15169_range_3_to_0_address_association(constB8,v15169_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_91,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_7,B)
    <=> v15169(constB7,B) ) ).

fof(is_address_107,axiom,
    address(v15169_range_3_to_0_address_term_bound_7) ).

fof(address_association_91,axiom,
    v15169_range_3_to_0_address_association(constB7,v15169_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_90,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_6,B)
    <=> v15169(constB6,B) ) ).

fof(is_address_106,axiom,
    address(v15169_range_3_to_0_address_term_bound_6) ).

fof(address_association_90,axiom,
    v15169_range_3_to_0_address_association(constB6,v15169_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_89,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_5,B)
    <=> v15169(constB5,B) ) ).

fof(is_address_105,axiom,
    address(v15169_range_3_to_0_address_term_bound_5) ).

fof(address_association_89,axiom,
    v15169_range_3_to_0_address_association(constB5,v15169_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_88,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_4,B)
    <=> v15169(constB4,B) ) ).

fof(is_address_104,axiom,
    address(v15169_range_3_to_0_address_term_bound_4) ).

fof(address_association_88,axiom,
    v15169_range_3_to_0_address_association(constB4,v15169_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_87,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_3,B)
    <=> v15169(constB3,B) ) ).

fof(is_address_103,axiom,
    address(v15169_range_3_to_0_address_term_bound_3) ).

fof(address_association_87,axiom,
    v15169_range_3_to_0_address_association(constB3,v15169_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_86,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_2,B)
    <=> v15169(constB2,B) ) ).

fof(is_address_102,axiom,
    address(v15169_range_3_to_0_address_term_bound_2) ).

fof(address_association_86,axiom,
    v15169_range_3_to_0_address_association(constB2,v15169_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_85,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_1,B)
    <=> v15169(constB1,B) ) ).

fof(is_address_101,axiom,
    address(v15169_range_3_to_0_address_term_bound_1) ).

fof(address_association_85,axiom,
    v15169_range_3_to_0_address_association(constB1,v15169_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_84,axiom,
    ! [B] :
      ( addressVal(v15169_range_3_to_0_address_term_bound_0,B)
    <=> v15169(constB0,B) ) ).

fof(is_address_100,axiom,
    address(v15169_range_3_to_0_address_term_bound_0) ).

fof(address_association_84,axiom,
    v15169_range_3_to_0_address_association(constB0,v15169_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_83,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_20,B)
    <=> v11990(constB20,B) ) ).

fof(is_address_99,axiom,
    address(v11990_range_3_to_0_address_term_bound_20) ).

fof(address_association_83,axiom,
    v11990_range_3_to_0_address_association(constB20,v11990_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_82,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_19,B)
    <=> v11990(constB19,B) ) ).

fof(is_address_98,axiom,
    address(v11990_range_3_to_0_address_term_bound_19) ).

fof(address_association_82,axiom,
    v11990_range_3_to_0_address_association(constB19,v11990_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_81,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_18,B)
    <=> v11990(constB18,B) ) ).

fof(is_address_97,axiom,
    address(v11990_range_3_to_0_address_term_bound_18) ).

fof(address_association_81,axiom,
    v11990_range_3_to_0_address_association(constB18,v11990_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_80,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_17,B)
    <=> v11990(constB17,B) ) ).

fof(is_address_96,axiom,
    address(v11990_range_3_to_0_address_term_bound_17) ).

fof(address_association_80,axiom,
    v11990_range_3_to_0_address_association(constB17,v11990_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_79,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_16,B)
    <=> v11990(constB16,B) ) ).

fof(is_address_95,axiom,
    address(v11990_range_3_to_0_address_term_bound_16) ).

fof(address_association_79,axiom,
    v11990_range_3_to_0_address_association(constB16,v11990_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_78,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_15,B)
    <=> v11990(constB15,B) ) ).

fof(is_address_94,axiom,
    address(v11990_range_3_to_0_address_term_bound_15) ).

fof(address_association_78,axiom,
    v11990_range_3_to_0_address_association(constB15,v11990_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_77,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_14,B)
    <=> v11990(constB14,B) ) ).

fof(is_address_93,axiom,
    address(v11990_range_3_to_0_address_term_bound_14) ).

fof(address_association_77,axiom,
    v11990_range_3_to_0_address_association(constB14,v11990_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_76,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_13,B)
    <=> v11990(constB13,B) ) ).

fof(is_address_92,axiom,
    address(v11990_range_3_to_0_address_term_bound_13) ).

fof(address_association_76,axiom,
    v11990_range_3_to_0_address_association(constB13,v11990_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_75,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_12,B)
    <=> v11990(constB12,B) ) ).

fof(is_address_91,axiom,
    address(v11990_range_3_to_0_address_term_bound_12) ).

fof(address_association_75,axiom,
    v11990_range_3_to_0_address_association(constB12,v11990_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_74,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_11,B)
    <=> v11990(constB11,B) ) ).

fof(is_address_90,axiom,
    address(v11990_range_3_to_0_address_term_bound_11) ).

fof(address_association_74,axiom,
    v11990_range_3_to_0_address_association(constB11,v11990_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_73,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_10,B)
    <=> v11990(constB10,B) ) ).

fof(is_address_89,axiom,
    address(v11990_range_3_to_0_address_term_bound_10) ).

fof(address_association_73,axiom,
    v11990_range_3_to_0_address_association(constB10,v11990_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_72,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_9,B)
    <=> v11990(constB9,B) ) ).

fof(is_address_88,axiom,
    address(v11990_range_3_to_0_address_term_bound_9) ).

fof(address_association_72,axiom,
    v11990_range_3_to_0_address_association(constB9,v11990_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_71,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_8,B)
    <=> v11990(constB8,B) ) ).

fof(is_address_87,axiom,
    address(v11990_range_3_to_0_address_term_bound_8) ).

fof(address_association_71,axiom,
    v11990_range_3_to_0_address_association(constB8,v11990_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_70,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_7,B)
    <=> v11990(constB7,B) ) ).

fof(is_address_86,axiom,
    address(v11990_range_3_to_0_address_term_bound_7) ).

fof(address_association_70,axiom,
    v11990_range_3_to_0_address_association(constB7,v11990_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_69,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_6,B)
    <=> v11990(constB6,B) ) ).

fof(is_address_85,axiom,
    address(v11990_range_3_to_0_address_term_bound_6) ).

fof(address_association_69,axiom,
    v11990_range_3_to_0_address_association(constB6,v11990_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_68,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_5,B)
    <=> v11990(constB5,B) ) ).

fof(is_address_84,axiom,
    address(v11990_range_3_to_0_address_term_bound_5) ).

fof(address_association_68,axiom,
    v11990_range_3_to_0_address_association(constB5,v11990_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_67,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_4,B)
    <=> v11990(constB4,B) ) ).

fof(is_address_83,axiom,
    address(v11990_range_3_to_0_address_term_bound_4) ).

fof(address_association_67,axiom,
    v11990_range_3_to_0_address_association(constB4,v11990_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_66,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_3,B)
    <=> v11990(constB3,B) ) ).

fof(is_address_82,axiom,
    address(v11990_range_3_to_0_address_term_bound_3) ).

fof(address_association_66,axiom,
    v11990_range_3_to_0_address_association(constB3,v11990_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_65,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_2,B)
    <=> v11990(constB2,B) ) ).

fof(is_address_81,axiom,
    address(v11990_range_3_to_0_address_term_bound_2) ).

fof(address_association_65,axiom,
    v11990_range_3_to_0_address_association(constB2,v11990_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_64,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_1,B)
    <=> v11990(constB1,B) ) ).

fof(is_address_80,axiom,
    address(v11990_range_3_to_0_address_term_bound_1) ).

fof(address_association_64,axiom,
    v11990_range_3_to_0_address_association(constB1,v11990_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_63,axiom,
    ! [B] :
      ( addressVal(v11990_range_3_to_0_address_term_bound_0,B)
    <=> v11990(constB0,B) ) ).

fof(is_address_79,axiom,
    address(v11990_range_3_to_0_address_term_bound_0) ).

fof(address_association_63,axiom,
    v11990_range_3_to_0_address_association(constB0,v11990_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_62,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_20,B)
    <=> v11962(constB20,B) ) ).

fof(is_address_78,axiom,
    address(v11962_range_3_to_0_address_term_bound_20) ).

fof(address_association_62,axiom,
    v11962_range_3_to_0_address_association(constB20,v11962_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_61,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_19,B)
    <=> v11962(constB19,B) ) ).

fof(is_address_77,axiom,
    address(v11962_range_3_to_0_address_term_bound_19) ).

fof(address_association_61,axiom,
    v11962_range_3_to_0_address_association(constB19,v11962_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_60,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_18,B)
    <=> v11962(constB18,B) ) ).

fof(is_address_76,axiom,
    address(v11962_range_3_to_0_address_term_bound_18) ).

fof(address_association_60,axiom,
    v11962_range_3_to_0_address_association(constB18,v11962_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_59,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_17,B)
    <=> v11962(constB17,B) ) ).

fof(is_address_75,axiom,
    address(v11962_range_3_to_0_address_term_bound_17) ).

fof(address_association_59,axiom,
    v11962_range_3_to_0_address_association(constB17,v11962_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_58,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_16,B)
    <=> v11962(constB16,B) ) ).

fof(is_address_74,axiom,
    address(v11962_range_3_to_0_address_term_bound_16) ).

fof(address_association_58,axiom,
    v11962_range_3_to_0_address_association(constB16,v11962_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_57,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_15,B)
    <=> v11962(constB15,B) ) ).

fof(is_address_73,axiom,
    address(v11962_range_3_to_0_address_term_bound_15) ).

fof(address_association_57,axiom,
    v11962_range_3_to_0_address_association(constB15,v11962_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_56,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_14,B)
    <=> v11962(constB14,B) ) ).

fof(is_address_72,axiom,
    address(v11962_range_3_to_0_address_term_bound_14) ).

fof(address_association_56,axiom,
    v11962_range_3_to_0_address_association(constB14,v11962_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_55,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_13,B)
    <=> v11962(constB13,B) ) ).

fof(is_address_71,axiom,
    address(v11962_range_3_to_0_address_term_bound_13) ).

fof(address_association_55,axiom,
    v11962_range_3_to_0_address_association(constB13,v11962_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_54,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_12,B)
    <=> v11962(constB12,B) ) ).

fof(is_address_70,axiom,
    address(v11962_range_3_to_0_address_term_bound_12) ).

fof(address_association_54,axiom,
    v11962_range_3_to_0_address_association(constB12,v11962_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_53,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_11,B)
    <=> v11962(constB11,B) ) ).

fof(is_address_69,axiom,
    address(v11962_range_3_to_0_address_term_bound_11) ).

fof(address_association_53,axiom,
    v11962_range_3_to_0_address_association(constB11,v11962_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_52,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_10,B)
    <=> v11962(constB10,B) ) ).

fof(is_address_68,axiom,
    address(v11962_range_3_to_0_address_term_bound_10) ).

fof(address_association_52,axiom,
    v11962_range_3_to_0_address_association(constB10,v11962_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_51,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_9,B)
    <=> v11962(constB9,B) ) ).

fof(is_address_67,axiom,
    address(v11962_range_3_to_0_address_term_bound_9) ).

fof(address_association_51,axiom,
    v11962_range_3_to_0_address_association(constB9,v11962_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_50,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_8,B)
    <=> v11962(constB8,B) ) ).

fof(is_address_66,axiom,
    address(v11962_range_3_to_0_address_term_bound_8) ).

fof(address_association_50,axiom,
    v11962_range_3_to_0_address_association(constB8,v11962_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_49,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_7,B)
    <=> v11962(constB7,B) ) ).

fof(is_address_65,axiom,
    address(v11962_range_3_to_0_address_term_bound_7) ).

fof(address_association_49,axiom,
    v11962_range_3_to_0_address_association(constB7,v11962_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_48,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_6,B)
    <=> v11962(constB6,B) ) ).

fof(is_address_64,axiom,
    address(v11962_range_3_to_0_address_term_bound_6) ).

fof(address_association_48,axiom,
    v11962_range_3_to_0_address_association(constB6,v11962_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_47,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_5,B)
    <=> v11962(constB5,B) ) ).

fof(is_address_63,axiom,
    address(v11962_range_3_to_0_address_term_bound_5) ).

fof(address_association_47,axiom,
    v11962_range_3_to_0_address_association(constB5,v11962_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_46,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_4,B)
    <=> v11962(constB4,B) ) ).

fof(is_address_62,axiom,
    address(v11962_range_3_to_0_address_term_bound_4) ).

fof(address_association_46,axiom,
    v11962_range_3_to_0_address_association(constB4,v11962_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_45,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_3,B)
    <=> v11962(constB3,B) ) ).

fof(is_address_61,axiom,
    address(v11962_range_3_to_0_address_term_bound_3) ).

fof(address_association_45,axiom,
    v11962_range_3_to_0_address_association(constB3,v11962_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_44,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_2,B)
    <=> v11962(constB2,B) ) ).

fof(is_address_60,axiom,
    address(v11962_range_3_to_0_address_term_bound_2) ).

fof(address_association_44,axiom,
    v11962_range_3_to_0_address_association(constB2,v11962_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_43,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_1,B)
    <=> v11962(constB1,B) ) ).

fof(is_address_59,axiom,
    address(v11962_range_3_to_0_address_term_bound_1) ).

fof(address_association_43,axiom,
    v11962_range_3_to_0_address_association(constB1,v11962_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_42,axiom,
    ! [B] :
      ( addressVal(v11962_range_3_to_0_address_term_bound_0,B)
    <=> v11962(constB0,B) ) ).

fof(is_address_58,axiom,
    address(v11962_range_3_to_0_address_term_bound_0) ).

fof(address_association_42,axiom,
    v11962_range_3_to_0_address_association(constB0,v11962_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_20,B)
    <=> v11462(constB20,B) ) ).

fof(is_address_57,axiom,
    address(v11462_range_3_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v11462_range_3_to_0_address_association(constB20,v11462_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_19,B)
    <=> v11462(constB19,B) ) ).

fof(is_address_56,axiom,
    address(v11462_range_3_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v11462_range_3_to_0_address_association(constB19,v11462_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_18,B)
    <=> v11462(constB18,B) ) ).

fof(is_address_55,axiom,
    address(v11462_range_3_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v11462_range_3_to_0_address_association(constB18,v11462_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_17,B)
    <=> v11462(constB17,B) ) ).

fof(is_address_54,axiom,
    address(v11462_range_3_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v11462_range_3_to_0_address_association(constB17,v11462_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_16,B)
    <=> v11462(constB16,B) ) ).

fof(is_address_53,axiom,
    address(v11462_range_3_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v11462_range_3_to_0_address_association(constB16,v11462_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_15,B)
    <=> v11462(constB15,B) ) ).

fof(is_address_52,axiom,
    address(v11462_range_3_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v11462_range_3_to_0_address_association(constB15,v11462_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_14,B)
    <=> v11462(constB14,B) ) ).

fof(is_address_51,axiom,
    address(v11462_range_3_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v11462_range_3_to_0_address_association(constB14,v11462_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_13,B)
    <=> v11462(constB13,B) ) ).

fof(is_address_50,axiom,
    address(v11462_range_3_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v11462_range_3_to_0_address_association(constB13,v11462_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_12,B)
    <=> v11462(constB12,B) ) ).

fof(is_address_49,axiom,
    address(v11462_range_3_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v11462_range_3_to_0_address_association(constB12,v11462_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_11,B)
    <=> v11462(constB11,B) ) ).

fof(is_address_48,axiom,
    address(v11462_range_3_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v11462_range_3_to_0_address_association(constB11,v11462_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_10,B)
    <=> v11462(constB10,B) ) ).

fof(is_address_47,axiom,
    address(v11462_range_3_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v11462_range_3_to_0_address_association(constB10,v11462_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_9,B)
    <=> v11462(constB9,B) ) ).

fof(is_address_46,axiom,
    address(v11462_range_3_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v11462_range_3_to_0_address_association(constB9,v11462_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_8,B)
    <=> v11462(constB8,B) ) ).

fof(is_address_45,axiom,
    address(v11462_range_3_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v11462_range_3_to_0_address_association(constB8,v11462_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_7,B)
    <=> v11462(constB7,B) ) ).

fof(is_address_44,axiom,
    address(v11462_range_3_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v11462_range_3_to_0_address_association(constB7,v11462_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_6,B)
    <=> v11462(constB6,B) ) ).

fof(is_address_43,axiom,
    address(v11462_range_3_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v11462_range_3_to_0_address_association(constB6,v11462_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_5,B)
    <=> v11462(constB5,B) ) ).

fof(is_address_42,axiom,
    address(v11462_range_3_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v11462_range_3_to_0_address_association(constB5,v11462_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_4,B)
    <=> v11462(constB4,B) ) ).

fof(is_address_41,axiom,
    address(v11462_range_3_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v11462_range_3_to_0_address_association(constB4,v11462_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_3,B)
    <=> v11462(constB3,B) ) ).

fof(is_address_40,axiom,
    address(v11462_range_3_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v11462_range_3_to_0_address_association(constB3,v11462_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_2,B)
    <=> v11462(constB2,B) ) ).

fof(is_address_39,axiom,
    address(v11462_range_3_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v11462_range_3_to_0_address_association(constB2,v11462_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_1,B)
    <=> v11462(constB1,B) ) ).

fof(is_address_38,axiom,
    address(v11462_range_3_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v11462_range_3_to_0_address_association(constB1,v11462_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v11462_range_3_to_0_address_term_bound_0,B)
    <=> v11462(constB0,B) ) ).

fof(is_address_37,axiom,
    address(v11462_range_3_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v11462_range_3_to_0_address_association(constB0,v11462_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_20,B)
    <=> v11434(constB20,B) ) ).

fof(is_address_36,axiom,
    address(v11434_range_3_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v11434_range_3_to_0_address_association(constB20,v11434_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_19,B)
    <=> v11434(constB19,B) ) ).

fof(is_address_35,axiom,
    address(v11434_range_3_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v11434_range_3_to_0_address_association(constB19,v11434_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_18,B)
    <=> v11434(constB18,B) ) ).

fof(is_address_34,axiom,
    address(v11434_range_3_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v11434_range_3_to_0_address_association(constB18,v11434_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_17,B)
    <=> v11434(constB17,B) ) ).

fof(is_address_33,axiom,
    address(v11434_range_3_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v11434_range_3_to_0_address_association(constB17,v11434_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_16,B)
    <=> v11434(constB16,B) ) ).

fof(is_address_32,axiom,
    address(v11434_range_3_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v11434_range_3_to_0_address_association(constB16,v11434_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_15,B)
    <=> v11434(constB15,B) ) ).

fof(is_address_31,axiom,
    address(v11434_range_3_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v11434_range_3_to_0_address_association(constB15,v11434_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_14,B)
    <=> v11434(constB14,B) ) ).

fof(is_address_30,axiom,
    address(v11434_range_3_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v11434_range_3_to_0_address_association(constB14,v11434_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_13,B)
    <=> v11434(constB13,B) ) ).

fof(is_address_29,axiom,
    address(v11434_range_3_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v11434_range_3_to_0_address_association(constB13,v11434_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_12,B)
    <=> v11434(constB12,B) ) ).

fof(is_address_28,axiom,
    address(v11434_range_3_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v11434_range_3_to_0_address_association(constB12,v11434_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_11,B)
    <=> v11434(constB11,B) ) ).

fof(is_address_27,axiom,
    address(v11434_range_3_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v11434_range_3_to_0_address_association(constB11,v11434_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_10,B)
    <=> v11434(constB10,B) ) ).

fof(is_address_26,axiom,
    address(v11434_range_3_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v11434_range_3_to_0_address_association(constB10,v11434_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_9,B)
    <=> v11434(constB9,B) ) ).

fof(is_address_25,axiom,
    address(v11434_range_3_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v11434_range_3_to_0_address_association(constB9,v11434_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_8,B)
    <=> v11434(constB8,B) ) ).

fof(is_address_24,axiom,
    address(v11434_range_3_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v11434_range_3_to_0_address_association(constB8,v11434_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_7,B)
    <=> v11434(constB7,B) ) ).

fof(is_address_23,axiom,
    address(v11434_range_3_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v11434_range_3_to_0_address_association(constB7,v11434_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_6,B)
    <=> v11434(constB6,B) ) ).

fof(is_address_22,axiom,
    address(v11434_range_3_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v11434_range_3_to_0_address_association(constB6,v11434_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_5,B)
    <=> v11434(constB5,B) ) ).

fof(is_address_21,axiom,
    address(v11434_range_3_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v11434_range_3_to_0_address_association(constB5,v11434_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_4,B)
    <=> v11434(constB4,B) ) ).

fof(is_address_20,axiom,
    address(v11434_range_3_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v11434_range_3_to_0_address_association(constB4,v11434_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_3,B)
    <=> v11434(constB3,B) ) ).

fof(is_address_19,axiom,
    address(v11434_range_3_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v11434_range_3_to_0_address_association(constB3,v11434_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_2,B)
    <=> v11434(constB2,B) ) ).

fof(is_address_18,axiom,
    address(v11434_range_3_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v11434_range_3_to_0_address_association(constB2,v11434_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_1,B)
    <=> v11434(constB1,B) ) ).

fof(is_address_17,axiom,
    address(v11434_range_3_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v11434_range_3_to_0_address_association(constB1,v11434_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v11434_range_3_to_0_address_term_bound_0,B)
    <=> v11434(constB0,B) ) ).

fof(is_address_16,axiom,
    address(v11434_range_3_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v11434_range_3_to_0_address_association(constB0,v11434_range_3_to_0_address_term_bound_0) ).

fof(is_address_15,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_15,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(is_address_14,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_14,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(is_address_13,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_13,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(is_address_12,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_12,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(is_address_11,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_11,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(is_address_10,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_10,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(is_address_9,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_9,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(is_address_8,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_8,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(is_address_7,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(is_address_6,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(is_address_5,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(is_address_4,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(is_address_3,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(is_address_2,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(is_address_1,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(is_address,axiom,
    address(b0000_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b0000_address_term,B)
    <=> b0000(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_11138,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v133774(VarCurr) ) ).

fof(writeUnaryOperator_11137,axiom,
    ! [VarCurr] :
      ( ~ v133774(VarCurr)
    <=> v133775(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26827,axiom,
    ! [VarCurr] :
      ( v133775(VarCurr)
    <=> ( v133777(VarCurr)
        & v133789(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3137,axiom,
    ! [VarCurr] :
      ( v133789(VarCurr)
    <=> ( v133779(VarCurr,bitIndex0)
        | v133779(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11136,axiom,
    ! [VarCurr] :
      ( ~ v133777(VarCurr)
    <=> v133778(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3136,axiom,
    ! [VarCurr] :
      ( v133778(VarCurr)
    <=> ( v133779(VarCurr,bitIndex0)
        & v133779(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43639,axiom,
    ! [VarCurr] :
      ( v133779(VarCurr,bitIndex0)
    <=> v133780(VarCurr) ) ).

fof(addAssignment_43638,axiom,
    ! [VarCurr] :
      ( v133779(VarCurr,bitIndex1)
    <=> $true ) ).

fof(writeBinaryOperatorShiftedRanges_3135,axiom,
    ! [VarCurr] :
      ( v133780(VarCurr)
    <=> ( v133782(VarCurr)
        & v133786(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3134,axiom,
    ! [VarCurr] :
      ( v133782(VarCurr)
    <=> ( v133783(VarCurr)
        & v133786(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3133,axiom,
    ! [VarCurr] :
      ( v133783(VarCurr)
    <=> ( v133784(VarCurr)
        & v133786(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3132,axiom,
    ! [VarCurr] :
      ( v133784(VarCurr)
    <=> ( v133785(VarCurr)
        & v133786(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3131,axiom,
    ! [VarCurr] :
      ( v133785(VarCurr)
    <=> ( v133786(VarCurr,bitIndex1)
        | v133787(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26826,axiom,
    ! [VarCurr] :
      ( v133787(VarCurr)
    <=> ( v133786(VarCurr,bitIndex0)
        & v133788(VarCurr) ) ) ).

fof(writeUnaryOperator_11135,axiom,
    ! [VarCurr] :
      ( ~ v133788(VarCurr)
    <=> v133786(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_16,axiom,
    ! [VarCurr] : ~ v133786(VarCurr,bitIndex4) ).

fof(addZeroExtensionConstraint_15,axiom,
    ! [VarCurr] : ~ v133786(VarCurr,bitIndex5) ).

fof(addAssignment_43637,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133786(VarCurr,B)
      <=> v8(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2344,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133761(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v8(VarNext,B)
            <=> v8(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2480,axiom,
    ! [VarNext] :
      ( v133761(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v8(VarNext,B)
          <=> v133769(VarNext,B) ) ) ) ).

fof(addAssignment_43636,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133769(VarNext,B)
          <=> v133767(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3214,axiom,
    ! [VarCurr] :
      ( ~ v133770(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133767(VarCurr,B)
          <=> v23(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3019,axiom,
    ! [VarCurr] :
      ( v133770(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133767(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_11134,axiom,
    ! [VarCurr] :
      ( ~ v133770(VarCurr)
    <=> v10(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26825,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133761(VarNext)
      <=> v133762(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26824,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133762(VarNext)
      <=> ( v133763(VarNext)
          & v133564(VarNext) ) ) ) ).

fof(writeUnaryOperator_11133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133763(VarNext)
      <=> v133571(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3213,axiom,
    ! [VarCurr] :
      ( ~ v25(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v23(VarCurr,B)
          <=> v8(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3018,axiom,
    ! [VarCurr] :
      ( v25(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v23(VarCurr,B)
          <=> v133738(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3212,axiom,
    ! [VarCurr] :
      ( ~ v133739(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133738(VarCurr,B)
          <=> v133740(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3017,axiom,
    ! [VarCurr] :
      ( v133739(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133738(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43635,axiom,
    ! [VarCurr] :
      ( v133740(VarCurr,bitIndex0)
    <=> v133756(VarCurr) ) ).

fof(addAssignment_43634,axiom,
    ! [VarCurr] :
      ( v133740(VarCurr,bitIndex1)
    <=> v133754(VarCurr) ) ).

fof(addAssignment_43633,axiom,
    ! [VarCurr] :
      ( v133740(VarCurr,bitIndex2)
    <=> v133749(VarCurr) ) ).

fof(addAssignment_43632,axiom,
    ! [VarCurr] :
      ( v133740(VarCurr,bitIndex3)
    <=> v133742(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26823,axiom,
    ! [VarCurr] :
      ( v133754(VarCurr)
    <=> ( v133755(VarCurr)
        & v133758(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3130,axiom,
    ! [VarCurr] :
      ( v133758(VarCurr)
    <=> ( v8(VarCurr,bitIndex0)
        | v8(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26822,axiom,
    ! [VarCurr] :
      ( v133755(VarCurr)
    <=> ( v133756(VarCurr)
        | v133757(VarCurr) ) ) ).

fof(writeUnaryOperator_11132,axiom,
    ! [VarCurr] :
      ( ~ v133757(VarCurr)
    <=> v8(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11131,axiom,
    ! [VarCurr] :
      ( ~ v133756(VarCurr)
    <=> v8(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26821,axiom,
    ! [VarCurr] :
      ( v133749(VarCurr)
    <=> ( v133750(VarCurr)
        & v133753(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3129,axiom,
    ! [VarCurr] :
      ( v133753(VarCurr)
    <=> ( v133746(VarCurr)
        | v8(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26820,axiom,
    ! [VarCurr] :
      ( v133750(VarCurr)
    <=> ( v133751(VarCurr)
        | v133752(VarCurr) ) ) ).

fof(writeUnaryOperator_11130,axiom,
    ! [VarCurr] :
      ( ~ v133752(VarCurr)
    <=> v8(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11129,axiom,
    ! [VarCurr] :
      ( ~ v133751(VarCurr)
    <=> v133746(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26819,axiom,
    ! [VarCurr] :
      ( v133742(VarCurr)
    <=> ( v133743(VarCurr)
        & v133748(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3128,axiom,
    ! [VarCurr] :
      ( v133748(VarCurr)
    <=> ( v133745(VarCurr)
        | v8(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26818,axiom,
    ! [VarCurr] :
      ( v133743(VarCurr)
    <=> ( v133744(VarCurr)
        | v133747(VarCurr) ) ) ).

fof(writeUnaryOperator_11128,axiom,
    ! [VarCurr] :
      ( ~ v133747(VarCurr)
    <=> v8(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11127,axiom,
    ! [VarCurr] :
      ( ~ v133744(VarCurr)
    <=> v133745(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3127,axiom,
    ! [VarCurr] :
      ( v133745(VarCurr)
    <=> ( v133746(VarCurr)
        & v8(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3126,axiom,
    ! [VarCurr] :
      ( v133746(VarCurr)
    <=> ( v8(VarCurr,bitIndex0)
        & v8(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9325,axiom,
    ! [VarCurr] :
      ( v133739(VarCurr)
    <=> ( ( v8(VarCurr,bitIndex3)
        <=> $true )
        & ( v8(VarCurr,bitIndex2)
        <=> $true )
        & ( v8(VarCurr,bitIndex1)
        <=> $true )
        & ( v8(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43631,axiom,
    ! [VarCurr] :
      ( v25(VarCurr)
    <=> v27(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3211,axiom,
    ! [VarCurr] :
      ( ~ v133731(VarCurr)
     => ( v27(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3016,axiom,
    ! [VarCurr] :
      ( v133731(VarCurr)
     => ( v27(VarCurr)
      <=> v133732(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5416,axiom,
    ! [VarCurr] :
      ( ~ v133586(VarCurr)
     => ( v133732(VarCurr)
      <=> v133735(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5405,axiom,
    ! [VarCurr] :
      ( v133586(VarCurr)
     => ( v133732(VarCurr)
      <=> v133733(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3210,axiom,
    ! [VarCurr] :
      ( ~ v133589(VarCurr)
     => ( v133735(VarCurr)
      <=> v133736(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3015,axiom,
    ! [VarCurr] :
      ( v133589(VarCurr)
     => ( v133735(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3209,axiom,
    ! [VarCurr] :
      ( ~ v133593(VarCurr)
     => ( v133736(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3014,axiom,
    ! [VarCurr] :
      ( v133593(VarCurr)
     => ( v133736(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3208,axiom,
    ! [VarCurr] :
      ( ~ v133585(VarCurr)
     => ( v133733(VarCurr)
      <=> v133734(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3013,axiom,
    ! [VarCurr] :
      ( v133585(VarCurr)
     => ( v133733(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3207,axiom,
    ! [VarCurr] :
      ( ~ v133613(VarCurr)
     => ( v133734(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3012,axiom,
    ! [VarCurr] :
      ( v133613(VarCurr)
     => ( v133734(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26817,axiom,
    ! [VarCurr] :
      ( v133731(VarCurr)
    <=> ( v133586(VarCurr)
        | v133590(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2343,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133719(VarNext)
       => ( v29(VarNext,bitIndex0)
        <=> v29(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2479,axiom,
    ! [VarNext] :
      ( v133719(VarNext)
     => ( v29(VarNext,bitIndex0)
      <=> v133727(VarNext) ) ) ).

fof(addAssignment_43630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133727(VarNext)
      <=> v133725(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3206,axiom,
    ! [VarCurr] :
      ( ~ v133605(VarCurr)
     => ( v133725(VarCurr)
      <=> v31(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3011,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr)
     => ( v133725(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26816,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133719(VarNext)
      <=> v133720(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26815,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133720(VarNext)
      <=> ( v133722(VarNext)
          & v131918(VarNext) ) ) ) ).

fof(writeUnaryOperator_11126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133722(VarNext)
      <=> v131925(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3205,axiom,
    ! [VarCurr] :
      ( ~ v133711(VarCurr)
     => ( v31(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3010,axiom,
    ! [VarCurr] :
      ( v133711(VarCurr)
     => ( v31(VarCurr,bitIndex0)
      <=> v133715(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5415,axiom,
    ! [VarCurr] :
      ( ~ v133712(VarCurr)
     => ( v133715(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5404,axiom,
    ! [VarCurr] :
      ( v133712(VarCurr)
     => ( v133715(VarCurr)
      <=> v133716(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3204,axiom,
    ! [VarCurr] :
      ( ~ v133613(VarCurr)
     => ( v133716(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3009,axiom,
    ! [VarCurr] :
      ( v133613(VarCurr)
     => ( v133716(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26814,axiom,
    ! [VarCurr] :
      ( v133711(VarCurr)
    <=> ( v133712(VarCurr)
        | v133714(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26813,axiom,
    ! [VarCurr] :
      ( v133714(VarCurr)
    <=> ( v133589(VarCurr)
        & v133590(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26812,axiom,
    ! [VarCurr] :
      ( v133712(VarCurr)
    <=> ( v133713(VarCurr)
        & v133586(VarCurr) ) ) ).

fof(writeUnaryOperator_11125,axiom,
    ! [VarCurr] :
      ( ~ v133713(VarCurr)
    <=> v133585(VarCurr) ) ).

fof(addAssignment_43629,axiom,
    ! [VarCurr] :
      ( v33(VarCurr)
    <=> v35(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9324,axiom,
    ! [VarCurr] :
      ( v35(VarCurr)
    <=> ( ( v37(VarCurr,bitIndex4)
        <=> $false )
        & ( v37(VarCurr,bitIndex3)
        <=> $false )
        & ( v37(VarCurr,bitIndex2)
        <=> $false )
        & ( v37(VarCurr,bitIndex1)
        <=> $false )
        & ( v37(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2342,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133695(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v37(VarNext,B)
            <=> v37(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2478,axiom,
    ! [VarNext] :
      ( v133695(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v37(VarNext,B)
          <=> v133705(VarNext,B) ) ) ) ).

fof(addAssignment_43628,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v133705(VarNext,B)
          <=> v133703(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3203,axiom,
    ! [VarCurr] :
      ( ~ v133706(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133703(VarCurr,B)
          <=> v42(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3008,axiom,
    ! [VarCurr] :
      ( v133706(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133703(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_11124,axiom,
    ! [VarCurr] :
      ( ~ v133706(VarCurr)
    <=> v39(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26811,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133695(VarNext)
      <=> v133696(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133696(VarNext)
      <=> ( v133697(VarNext)
          & v133692(VarNext) ) ) ) ).

fof(writeUnaryOperator_11123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133697(VarNext)
      <=> v133699(VarNext) ) ) ).

fof(addAssignment_43627,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133699(VarNext)
      <=> v133692(VarCurr) ) ) ).

fof(addAssignment_43626,axiom,
    ! [VarCurr] :
      ( v133692(VarCurr)
    <=> v131918(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_188,axiom,
    ! [VarCurr] :
      ( ( ~ v133617(VarCurr)
        & ~ v133619(VarCurr)
        & ~ v133660(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v42(VarCurr,B)
          <=> v37(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1319,axiom,
    ! [VarCurr] :
      ( v133660(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v42(VarCurr,B)
          <=> v133662(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5414,axiom,
    ! [VarCurr] :
      ( v133619(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v42(VarCurr,B)
          <=> v133621(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5403,axiom,
    ! [VarCurr] :
      ( v133617(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v42(VarCurr,B)
          <=> v37(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9323,axiom,
    ! [VarCurr] :
      ( v133689(VarCurr)
    <=> ( ( v133690(VarCurr,bitIndex1)
        <=> $true )
        & ( v133690(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43625,axiom,
    ! [VarCurr] :
      ( v133690(VarCurr,bitIndex0)
    <=> v67(VarCurr) ) ).

fof(addAssignment_43624,axiom,
    ! [VarCurr] :
      ( v133690(VarCurr,bitIndex1)
    <=> v44(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3202,axiom,
    ! [VarCurr] :
      ( ~ v133663(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133662(VarCurr,B)
          <=> v133664(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3007,axiom,
    ! [VarCurr] :
      ( v133663(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133662(VarCurr,B)
          <=> b01111(B) ) ) ) ).

fof(addAssignment_43623,axiom,
    ! [VarCurr] :
      ( v133664(VarCurr,bitIndex0)
    <=> v133686(VarCurr) ) ).

fof(addAssignment_43622,axiom,
    ! [VarCurr] :
      ( v133664(VarCurr,bitIndex1)
    <=> v133684(VarCurr) ) ).

fof(addAssignment_43621,axiom,
    ! [VarCurr] :
      ( v133664(VarCurr,bitIndex2)
    <=> v133679(VarCurr) ) ).

fof(addAssignment_43620,axiom,
    ! [VarCurr] :
      ( v133664(VarCurr,bitIndex3)
    <=> v133674(VarCurr) ) ).

fof(addAssignment_43619,axiom,
    ! [VarCurr] :
      ( v133664(VarCurr,bitIndex4)
    <=> v133666(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26809,axiom,
    ! [VarCurr] :
      ( v133684(VarCurr)
    <=> ( v133685(VarCurr)
        & v133688(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3125,axiom,
    ! [VarCurr] :
      ( v133688(VarCurr)
    <=> ( v37(VarCurr,bitIndex0)
        | v37(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26808,axiom,
    ! [VarCurr] :
      ( v133685(VarCurr)
    <=> ( v133686(VarCurr)
        | v133687(VarCurr) ) ) ).

fof(writeUnaryOperator_11122,axiom,
    ! [VarCurr] :
      ( ~ v133687(VarCurr)
    <=> v37(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11121,axiom,
    ! [VarCurr] :
      ( ~ v133686(VarCurr)
    <=> v37(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26807,axiom,
    ! [VarCurr] :
      ( v133679(VarCurr)
    <=> ( v133680(VarCurr)
        & v133683(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3124,axiom,
    ! [VarCurr] :
      ( v133683(VarCurr)
    <=> ( v133671(VarCurr)
        | v37(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26806,axiom,
    ! [VarCurr] :
      ( v133680(VarCurr)
    <=> ( v133681(VarCurr)
        | v133682(VarCurr) ) ) ).

fof(writeUnaryOperator_11120,axiom,
    ! [VarCurr] :
      ( ~ v133682(VarCurr)
    <=> v37(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11119,axiom,
    ! [VarCurr] :
      ( ~ v133681(VarCurr)
    <=> v133671(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26805,axiom,
    ! [VarCurr] :
      ( v133674(VarCurr)
    <=> ( v133675(VarCurr)
        & v133678(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3123,axiom,
    ! [VarCurr] :
      ( v133678(VarCurr)
    <=> ( v133670(VarCurr)
        | v37(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26804,axiom,
    ! [VarCurr] :
      ( v133675(VarCurr)
    <=> ( v133676(VarCurr)
        | v133677(VarCurr) ) ) ).

fof(writeUnaryOperator_11118,axiom,
    ! [VarCurr] :
      ( ~ v133677(VarCurr)
    <=> v37(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11117,axiom,
    ! [VarCurr] :
      ( ~ v133676(VarCurr)
    <=> v133670(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26803,axiom,
    ! [VarCurr] :
      ( v133666(VarCurr)
    <=> ( v133667(VarCurr)
        & v133673(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3122,axiom,
    ! [VarCurr] :
      ( v133673(VarCurr)
    <=> ( v133669(VarCurr)
        | v37(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26802,axiom,
    ! [VarCurr] :
      ( v133667(VarCurr)
    <=> ( v133668(VarCurr)
        | v133672(VarCurr) ) ) ).

fof(writeUnaryOperator_11116,axiom,
    ! [VarCurr] :
      ( ~ v133672(VarCurr)
    <=> v37(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11115,axiom,
    ! [VarCurr] :
      ( ~ v133668(VarCurr)
    <=> v133669(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3121,axiom,
    ! [VarCurr] :
      ( v133669(VarCurr)
    <=> ( v133670(VarCurr)
        & v37(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3120,axiom,
    ! [VarCurr] :
      ( v133670(VarCurr)
    <=> ( v133671(VarCurr)
        & v37(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3119,axiom,
    ! [VarCurr] :
      ( v133671(VarCurr)
    <=> ( v37(VarCurr,bitIndex0)
        & v37(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9322,axiom,
    ! [VarCurr] :
      ( v133663(VarCurr)
    <=> ( ( v37(VarCurr,bitIndex4)
        <=> $false )
        & ( v37(VarCurr,bitIndex3)
        <=> $true )
        & ( v37(VarCurr,bitIndex2)
        <=> $true )
        & ( v37(VarCurr,bitIndex1)
        <=> $true )
        & ( v37(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9321,axiom,
    ! [VarCurr] :
      ( v133660(VarCurr)
    <=> ( ( v133661(VarCurr,bitIndex1)
        <=> $true )
        & ( v133661(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43618,axiom,
    ! [VarCurr] :
      ( v133661(VarCurr,bitIndex0)
    <=> v67(VarCurr) ) ).

fof(addAssignment_43617,axiom,
    ! [VarCurr] :
      ( v133661(VarCurr,bitIndex1)
    <=> v44(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3201,axiom,
    ! [VarCurr] :
      ( ~ v133622(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133621(VarCurr,B)
          <=> v133623(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3006,axiom,
    ! [VarCurr] :
      ( v133622(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133621(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_211,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex6)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_210,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex7)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_209,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex8)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_208,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex9)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_207,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex10)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_206,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex11)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_205,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex12)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_204,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex13)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_203,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex14)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_202,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex15)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_201,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex16)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_200,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex17)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_199,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex18)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_198,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex19)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_197,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex20)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_196,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex21)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_195,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex22)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_194,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex23)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_193,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex24)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_192,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex25)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_191,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex26)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_190,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex27)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_189,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex28)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_188,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex29)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_187,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex30)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_186,axiom,
    ! [VarCurr] :
      ( v133623(VarCurr,bitIndex31)
    <=> v133624(VarCurr,bitIndex5) ) ).

fof(addAssignment_43616,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v133623(VarCurr,B)
      <=> v133624(VarCurr,B) ) ) ).

fof(addAssignment_43615,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr,bitIndex0)
    <=> v133658(VarCurr) ) ).

fof(addAssignment_43614,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr,bitIndex1)
    <=> v133656(VarCurr) ) ).

fof(addAssignment_43613,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr,bitIndex2)
    <=> v133652(VarCurr) ) ).

fof(addAssignment_43612,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr,bitIndex3)
    <=> v133648(VarCurr) ) ).

fof(addAssignment_43611,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr,bitIndex4)
    <=> v133644(VarCurr) ) ).

fof(addAssignment_43610,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr,bitIndex5)
    <=> v133626(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26801,axiom,
    ! [VarCurr] :
      ( v133656(VarCurr)
    <=> ( v133657(VarCurr)
        & v133659(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26800,axiom,
    ! [VarCurr] :
      ( v133659(VarCurr)
    <=> ( v133630(VarCurr,bitIndex0)
        | v133638(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3118,axiom,
    ! [VarCurr] :
      ( v133657(VarCurr)
    <=> ( v133658(VarCurr)
        | v133630(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11114,axiom,
    ! [VarCurr] :
      ( ~ v133658(VarCurr)
    <=> v133630(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26799,axiom,
    ! [VarCurr] :
      ( v133652(VarCurr)
    <=> ( v133653(VarCurr)
        & v133655(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26798,axiom,
    ! [VarCurr] :
      ( v133655(VarCurr)
    <=> ( v133636(VarCurr)
        | v133639(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3117,axiom,
    ! [VarCurr] :
      ( v133653(VarCurr)
    <=> ( v133654(VarCurr)
        | v133630(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_11113,axiom,
    ! [VarCurr] :
      ( ~ v133654(VarCurr)
    <=> v133636(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26797,axiom,
    ! [VarCurr] :
      ( v133648(VarCurr)
    <=> ( v133649(VarCurr)
        & v133651(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26796,axiom,
    ! [VarCurr] :
      ( v133651(VarCurr)
    <=> ( v133634(VarCurr)
        | v133640(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3116,axiom,
    ! [VarCurr] :
      ( v133649(VarCurr)
    <=> ( v133650(VarCurr)
        | v133630(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_11112,axiom,
    ! [VarCurr] :
      ( ~ v133650(VarCurr)
    <=> v133634(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26795,axiom,
    ! [VarCurr] :
      ( v133644(VarCurr)
    <=> ( v133645(VarCurr)
        & v133647(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26794,axiom,
    ! [VarCurr] :
      ( v133647(VarCurr)
    <=> ( v133632(VarCurr)
        | v133641(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3115,axiom,
    ! [VarCurr] :
      ( v133645(VarCurr)
    <=> ( v133646(VarCurr)
        | v133630(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_11111,axiom,
    ! [VarCurr] :
      ( ~ v133646(VarCurr)
    <=> v133632(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26793,axiom,
    ! [VarCurr] :
      ( v133626(VarCurr)
    <=> ( v133627(VarCurr)
        & v133642(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26792,axiom,
    ! [VarCurr] :
      ( v133642(VarCurr)
    <=> ( v133629(VarCurr)
        | v133643(VarCurr) ) ) ).

fof(writeUnaryOperator_11110,axiom,
    ! [VarCurr] :
      ( ~ v133643(VarCurr)
    <=> v133630(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_3114,axiom,
    ! [VarCurr] :
      ( v133627(VarCurr)
    <=> ( v133628(VarCurr)
        | v133630(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_11109,axiom,
    ! [VarCurr] :
      ( ~ v133628(VarCurr)
    <=> v133629(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3113,axiom,
    ! [VarCurr] :
      ( v133629(VarCurr)
    <=> ( v133630(VarCurr,bitIndex4)
        | v133631(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26791,axiom,
    ! [VarCurr] :
      ( v133631(VarCurr)
    <=> ( v133632(VarCurr)
        & v133641(VarCurr) ) ) ).

fof(writeUnaryOperator_11108,axiom,
    ! [VarCurr] :
      ( ~ v133641(VarCurr)
    <=> v133630(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3112,axiom,
    ! [VarCurr] :
      ( v133632(VarCurr)
    <=> ( v133630(VarCurr,bitIndex3)
        | v133633(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26790,axiom,
    ! [VarCurr] :
      ( v133633(VarCurr)
    <=> ( v133634(VarCurr)
        & v133640(VarCurr) ) ) ).

fof(writeUnaryOperator_11107,axiom,
    ! [VarCurr] :
      ( ~ v133640(VarCurr)
    <=> v133630(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_3111,axiom,
    ! [VarCurr] :
      ( v133634(VarCurr)
    <=> ( v133630(VarCurr,bitIndex2)
        | v133635(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26789,axiom,
    ! [VarCurr] :
      ( v133635(VarCurr)
    <=> ( v133636(VarCurr)
        & v133639(VarCurr) ) ) ).

fof(writeUnaryOperator_11106,axiom,
    ! [VarCurr] :
      ( ~ v133639(VarCurr)
    <=> v133630(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3110,axiom,
    ! [VarCurr] :
      ( v133636(VarCurr)
    <=> ( v133630(VarCurr,bitIndex1)
        | v133637(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26788,axiom,
    ! [VarCurr] :
      ( v133637(VarCurr)
    <=> ( v133630(VarCurr,bitIndex0)
        & v133638(VarCurr) ) ) ).

fof(writeUnaryOperator_11105,axiom,
    ! [VarCurr] :
      ( ~ v133638(VarCurr)
    <=> v133630(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_14,axiom,
    ! [VarCurr] : ~ v133630(VarCurr,bitIndex5) ).

fof(addAssignment_43609,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v133630(VarCurr,B)
      <=> v37(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_9320,axiom,
    ! [VarCurr] :
      ( v133622(VarCurr)
    <=> ( ( v37(VarCurr,bitIndex4)
        <=> $false )
        & ( v37(VarCurr,bitIndex3)
        <=> $false )
        & ( v37(VarCurr,bitIndex2)
        <=> $false )
        & ( v37(VarCurr,bitIndex1)
        <=> $false )
        & ( v37(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9319,axiom,
    ! [VarCurr] :
      ( v133619(VarCurr)
    <=> ( ( v133620(VarCurr,bitIndex1)
        <=> $false )
        & ( v133620(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43608,axiom,
    ! [VarCurr] :
      ( v133620(VarCurr,bitIndex0)
    <=> v67(VarCurr) ) ).

fof(addAssignment_43607,axiom,
    ! [VarCurr] :
      ( v133620(VarCurr,bitIndex1)
    <=> v44(VarCurr) ) ).

fof(addAssignmentInitValueVector_45,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v37(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_9318,axiom,
    ! [VarCurr] :
      ( v133617(VarCurr)
    <=> ( ( v133618(VarCurr,bitIndex1)
        <=> $false )
        & ( v133618(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43606,axiom,
    ! [VarCurr] :
      ( v133618(VarCurr,bitIndex0)
    <=> v67(VarCurr) ) ).

fof(addAssignment_43605,axiom,
    ! [VarCurr] :
      ( v133618(VarCurr,bitIndex1)
    <=> v44(VarCurr) ) ).

fof(addAssignment_43604,axiom,
    ! [VarCurr] :
      ( v67(VarCurr)
    <=> v69(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3200,axiom,
    ! [VarCurr] :
      ( ~ v133609(VarCurr)
     => ( v69(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3005,axiom,
    ! [VarCurr] :
      ( v133609(VarCurr)
     => ( v69(VarCurr)
      <=> v133610(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5413,axiom,
    ! [VarCurr] :
      ( ~ v133586(VarCurr)
     => ( v133610(VarCurr)
      <=> v133614(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5402,axiom,
    ! [VarCurr] :
      ( v133586(VarCurr)
     => ( v133610(VarCurr)
      <=> v133611(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3199,axiom,
    ! [VarCurr] :
      ( ~ v133589(VarCurr)
     => ( v133614(VarCurr)
      <=> v133615(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3004,axiom,
    ! [VarCurr] :
      ( v133589(VarCurr)
     => ( v133614(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3198,axiom,
    ! [VarCurr] :
      ( ~ v133593(VarCurr)
     => ( v133615(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3003,axiom,
    ! [VarCurr] :
      ( v133593(VarCurr)
     => ( v133615(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3197,axiom,
    ! [VarCurr] :
      ( ~ v133585(VarCurr)
     => ( v133611(VarCurr)
      <=> v133612(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3002,axiom,
    ! [VarCurr] :
      ( v133585(VarCurr)
     => ( v133611(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3196,axiom,
    ! [VarCurr] :
      ( ~ v133613(VarCurr)
     => ( v133612(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3001,axiom,
    ! [VarCurr] :
      ( v133613(VarCurr)
     => ( v133612(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_11104,axiom,
    ! [VarCurr] :
      ( ~ v133613(VarCurr)
    <=> v71(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26787,axiom,
    ! [VarCurr] :
      ( v133609(VarCurr)
    <=> ( v133586(VarCurr)
        | v133590(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2341,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133596(VarNext)
       => ( v29(VarNext,bitIndex1)
        <=> v29(VarCurr,bitIndex1) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_17,axiom,
    ! [VarNext] :
      ( v133596(VarNext)
     => ( v29(VarNext,bitIndex1)
      <=> v133604(VarNext) ) ) ).

fof(addAssignment_43603,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133604(VarNext)
      <=> v133602(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_588,axiom,
    ! [VarCurr] :
      ( ~ v133605(VarCurr)
     => ( v133602(VarCurr)
      <=> v31(VarCurr,bitIndex1) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3000,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr)
     => ( v133602(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_11103,axiom,
    ! [VarCurr] :
      ( ~ v133605(VarCurr)
    <=> v12(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26786,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133596(VarNext)
      <=> v133597(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26785,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133597(VarNext)
      <=> ( v133598(VarNext)
          & v131918(VarNext) ) ) ) ).

fof(writeUnaryOperator_11102,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133598(VarNext)
      <=> v131925(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_587,axiom,
    ! [VarCurr] :
      ( ~ v133583(VarCurr)
     => ( v31(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_783,axiom,
    ! [VarCurr] :
      ( v133583(VarCurr)
     => ( v31(VarCurr,bitIndex1)
      <=> v133591(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5412,axiom,
    ! [VarCurr] :
      ( ~ v133584(VarCurr)
     => ( v133591(VarCurr)
      <=> v133592(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5401,axiom,
    ! [VarCurr] :
      ( v133584(VarCurr)
     => ( v133591(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3195,axiom,
    ! [VarCurr] :
      ( ~ v133593(VarCurr)
     => ( v133592(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2999,axiom,
    ! [VarCurr] :
      ( v133593(VarCurr)
     => ( v133592(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_11101,axiom,
    ! [VarCurr] :
      ( ~ v133593(VarCurr)
    <=> v33(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26784,axiom,
    ! [VarCurr] :
      ( v133583(VarCurr)
    <=> ( v133584(VarCurr)
        | v133587(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26783,axiom,
    ! [VarCurr] :
      ( v133587(VarCurr)
    <=> ( v133588(VarCurr)
        & v133590(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9317,axiom,
    ! [VarCurr] :
      ( v133590(VarCurr)
    <=> ( $true
      <=> v29(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11100,axiom,
    ! [VarCurr] :
      ( ~ v133588(VarCurr)
    <=> v133589(VarCurr) ) ).

fof(writeUnaryOperator_11099,axiom,
    ! [VarCurr] :
      ( ~ v133589(VarCurr)
    <=> v71(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26782,axiom,
    ! [VarCurr] :
      ( v133584(VarCurr)
    <=> ( v133585(VarCurr)
        & v133586(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9316,axiom,
    ! [VarCurr] :
      ( v133586(VarCurr)
    <=> ( $true
      <=> v29(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_44,axiom,
    ( v29(constB0,bitIndex1)
  <=> $false ) ).

fof(addAssignmentInitValueVector_43,axiom,
    ( v29(constB0,bitIndex0)
  <=> $true ) ).

fof(writeUnaryOperator_11098,axiom,
    ! [VarCurr] :
      ( ~ v133585(VarCurr)
    <=> v33(VarCurr) ) ).

fof(addAssignment_43602,axiom,
    ! [VarCurr] :
      ( v71(VarCurr)
    <=> v73(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9315,axiom,
    ! [VarCurr] :
      ( v73(VarCurr)
    <=> ( ( v75(VarCurr,bitIndex4)
        <=> $false )
        & ( v75(VarCurr,bitIndex3)
        <=> $false )
        & ( v75(VarCurr,bitIndex2)
        <=> $false )
        & ( v75(VarCurr,bitIndex1)
        <=> $false )
        & ( v75(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2340,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133567(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v75(VarNext,B)
            <=> v75(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2477,axiom,
    ! [VarNext] :
      ( v133567(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v75(VarNext,B)
          <=> v133577(VarNext,B) ) ) ) ).

fof(addAssignment_43601,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v133577(VarNext,B)
          <=> v133575(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3194,axiom,
    ! [VarCurr] :
      ( ~ v133578(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133575(VarCurr,B)
          <=> v77(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2998,axiom,
    ! [VarCurr] :
      ( v133578(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133575(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_11097,axiom,
    ! [VarCurr] :
      ( ~ v133578(VarCurr)
    <=> v10(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133567(VarNext)
      <=> v133568(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26780,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133568(VarNext)
      <=> ( v133569(VarNext)
          & v133564(VarNext) ) ) ) ).

fof(writeUnaryOperator_11096,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133569(VarNext)
      <=> v133571(VarNext) ) ) ).

fof(addAssignment_43600,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133571(VarNext)
      <=> v133564(VarCurr) ) ) ).

fof(addAssignment_43599,axiom,
    ! [VarCurr] :
      ( v133564(VarCurr)
    <=> v131918(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_187,axiom,
    ! [VarCurr] :
      ( ( ~ v133489(VarCurr)
        & ~ v133491(VarCurr)
        & ~ v133532(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v77(VarCurr,B)
          <=> v75(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1318,axiom,
    ! [VarCurr] :
      ( v133532(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v77(VarCurr,B)
          <=> v133534(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5411,axiom,
    ! [VarCurr] :
      ( v133491(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v77(VarCurr,B)
          <=> v133493(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5400,axiom,
    ! [VarCurr] :
      ( v133489(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v77(VarCurr,B)
          <=> v75(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9314,axiom,
    ! [VarCurr] :
      ( v133561(VarCurr)
    <=> ( ( v133562(VarCurr,bitIndex1)
        <=> $true )
        & ( v133562(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43598,axiom,
    ! [VarCurr] :
      ( v133562(VarCurr,bitIndex0)
    <=> v25(VarCurr) ) ).

fof(addAssignment_43597,axiom,
    ! [VarCurr] :
      ( v133562(VarCurr,bitIndex1)
    <=> v79(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3193,axiom,
    ! [VarCurr] :
      ( ~ v133535(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133534(VarCurr,B)
          <=> v133536(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2997,axiom,
    ! [VarCurr] :
      ( v133535(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133534(VarCurr,B)
          <=> b01111(B) ) ) ) ).

fof(addAssignment_43596,axiom,
    ! [VarCurr] :
      ( v133536(VarCurr,bitIndex0)
    <=> v133558(VarCurr) ) ).

fof(addAssignment_43595,axiom,
    ! [VarCurr] :
      ( v133536(VarCurr,bitIndex1)
    <=> v133556(VarCurr) ) ).

fof(addAssignment_43594,axiom,
    ! [VarCurr] :
      ( v133536(VarCurr,bitIndex2)
    <=> v133551(VarCurr) ) ).

fof(addAssignment_43593,axiom,
    ! [VarCurr] :
      ( v133536(VarCurr,bitIndex3)
    <=> v133546(VarCurr) ) ).

fof(addAssignment_43592,axiom,
    ! [VarCurr] :
      ( v133536(VarCurr,bitIndex4)
    <=> v133538(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26779,axiom,
    ! [VarCurr] :
      ( v133556(VarCurr)
    <=> ( v133557(VarCurr)
        & v133560(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3109,axiom,
    ! [VarCurr] :
      ( v133560(VarCurr)
    <=> ( v75(VarCurr,bitIndex0)
        | v75(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26778,axiom,
    ! [VarCurr] :
      ( v133557(VarCurr)
    <=> ( v133558(VarCurr)
        | v133559(VarCurr) ) ) ).

fof(writeUnaryOperator_11095,axiom,
    ! [VarCurr] :
      ( ~ v133559(VarCurr)
    <=> v75(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11094,axiom,
    ! [VarCurr] :
      ( ~ v133558(VarCurr)
    <=> v75(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26777,axiom,
    ! [VarCurr] :
      ( v133551(VarCurr)
    <=> ( v133552(VarCurr)
        & v133555(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3108,axiom,
    ! [VarCurr] :
      ( v133555(VarCurr)
    <=> ( v133543(VarCurr)
        | v75(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26776,axiom,
    ! [VarCurr] :
      ( v133552(VarCurr)
    <=> ( v133553(VarCurr)
        | v133554(VarCurr) ) ) ).

fof(writeUnaryOperator_11093,axiom,
    ! [VarCurr] :
      ( ~ v133554(VarCurr)
    <=> v75(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11092,axiom,
    ! [VarCurr] :
      ( ~ v133553(VarCurr)
    <=> v133543(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26775,axiom,
    ! [VarCurr] :
      ( v133546(VarCurr)
    <=> ( v133547(VarCurr)
        & v133550(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3107,axiom,
    ! [VarCurr] :
      ( v133550(VarCurr)
    <=> ( v133542(VarCurr)
        | v75(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26774,axiom,
    ! [VarCurr] :
      ( v133547(VarCurr)
    <=> ( v133548(VarCurr)
        | v133549(VarCurr) ) ) ).

fof(writeUnaryOperator_11091,axiom,
    ! [VarCurr] :
      ( ~ v133549(VarCurr)
    <=> v75(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11090,axiom,
    ! [VarCurr] :
      ( ~ v133548(VarCurr)
    <=> v133542(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26773,axiom,
    ! [VarCurr] :
      ( v133538(VarCurr)
    <=> ( v133539(VarCurr)
        & v133545(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3106,axiom,
    ! [VarCurr] :
      ( v133545(VarCurr)
    <=> ( v133541(VarCurr)
        | v75(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26772,axiom,
    ! [VarCurr] :
      ( v133539(VarCurr)
    <=> ( v133540(VarCurr)
        | v133544(VarCurr) ) ) ).

fof(writeUnaryOperator_11089,axiom,
    ! [VarCurr] :
      ( ~ v133544(VarCurr)
    <=> v75(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11088,axiom,
    ! [VarCurr] :
      ( ~ v133540(VarCurr)
    <=> v133541(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3105,axiom,
    ! [VarCurr] :
      ( v133541(VarCurr)
    <=> ( v133542(VarCurr)
        & v75(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3104,axiom,
    ! [VarCurr] :
      ( v133542(VarCurr)
    <=> ( v133543(VarCurr)
        & v75(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3103,axiom,
    ! [VarCurr] :
      ( v133543(VarCurr)
    <=> ( v75(VarCurr,bitIndex0)
        & v75(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9313,axiom,
    ! [VarCurr] :
      ( v133535(VarCurr)
    <=> ( ( v75(VarCurr,bitIndex4)
        <=> $false )
        & ( v75(VarCurr,bitIndex3)
        <=> $true )
        & ( v75(VarCurr,bitIndex2)
        <=> $true )
        & ( v75(VarCurr,bitIndex1)
        <=> $true )
        & ( v75(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9312,axiom,
    ! [VarCurr] :
      ( v133532(VarCurr)
    <=> ( ( v133533(VarCurr,bitIndex1)
        <=> $true )
        & ( v133533(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43591,axiom,
    ! [VarCurr] :
      ( v133533(VarCurr,bitIndex0)
    <=> v25(VarCurr) ) ).

fof(addAssignment_43590,axiom,
    ! [VarCurr] :
      ( v133533(VarCurr,bitIndex1)
    <=> v79(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3192,axiom,
    ! [VarCurr] :
      ( ~ v133494(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133493(VarCurr,B)
          <=> v133495(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2996,axiom,
    ! [VarCurr] :
      ( v133494(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133493(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_185,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex6)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_184,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex7)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_183,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex8)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_182,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex9)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_181,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex10)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_180,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex11)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_179,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex12)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_178,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex13)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_177,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex14)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_176,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex15)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_175,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex16)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_174,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex17)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_173,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex18)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_172,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex19)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_171,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex20)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_170,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex21)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_169,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex22)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_168,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex23)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_167,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex24)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_166,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex25)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_165,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex26)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_164,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex27)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_163,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex28)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_162,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex29)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_161,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex30)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_160,axiom,
    ! [VarCurr] :
      ( v133495(VarCurr,bitIndex31)
    <=> v133496(VarCurr,bitIndex5) ) ).

fof(addAssignment_43589,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v133495(VarCurr,B)
      <=> v133496(VarCurr,B) ) ) ).

fof(addAssignment_43588,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr,bitIndex0)
    <=> v133530(VarCurr) ) ).

fof(addAssignment_43587,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr,bitIndex1)
    <=> v133528(VarCurr) ) ).

fof(addAssignment_43586,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr,bitIndex2)
    <=> v133524(VarCurr) ) ).

fof(addAssignment_43585,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr,bitIndex3)
    <=> v133520(VarCurr) ) ).

fof(addAssignment_43584,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr,bitIndex4)
    <=> v133516(VarCurr) ) ).

fof(addAssignment_43583,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr,bitIndex5)
    <=> v133498(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26771,axiom,
    ! [VarCurr] :
      ( v133528(VarCurr)
    <=> ( v133529(VarCurr)
        & v133531(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26770,axiom,
    ! [VarCurr] :
      ( v133531(VarCurr)
    <=> ( v133502(VarCurr,bitIndex0)
        | v133510(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3102,axiom,
    ! [VarCurr] :
      ( v133529(VarCurr)
    <=> ( v133530(VarCurr)
        | v133502(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11087,axiom,
    ! [VarCurr] :
      ( ~ v133530(VarCurr)
    <=> v133502(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26769,axiom,
    ! [VarCurr] :
      ( v133524(VarCurr)
    <=> ( v133525(VarCurr)
        & v133527(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26768,axiom,
    ! [VarCurr] :
      ( v133527(VarCurr)
    <=> ( v133508(VarCurr)
        | v133511(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3101,axiom,
    ! [VarCurr] :
      ( v133525(VarCurr)
    <=> ( v133526(VarCurr)
        | v133502(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_11086,axiom,
    ! [VarCurr] :
      ( ~ v133526(VarCurr)
    <=> v133508(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26767,axiom,
    ! [VarCurr] :
      ( v133520(VarCurr)
    <=> ( v133521(VarCurr)
        & v133523(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26766,axiom,
    ! [VarCurr] :
      ( v133523(VarCurr)
    <=> ( v133506(VarCurr)
        | v133512(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3100,axiom,
    ! [VarCurr] :
      ( v133521(VarCurr)
    <=> ( v133522(VarCurr)
        | v133502(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_11085,axiom,
    ! [VarCurr] :
      ( ~ v133522(VarCurr)
    <=> v133506(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26765,axiom,
    ! [VarCurr] :
      ( v133516(VarCurr)
    <=> ( v133517(VarCurr)
        & v133519(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26764,axiom,
    ! [VarCurr] :
      ( v133519(VarCurr)
    <=> ( v133504(VarCurr)
        | v133513(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3099,axiom,
    ! [VarCurr] :
      ( v133517(VarCurr)
    <=> ( v133518(VarCurr)
        | v133502(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_11084,axiom,
    ! [VarCurr] :
      ( ~ v133518(VarCurr)
    <=> v133504(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26763,axiom,
    ! [VarCurr] :
      ( v133498(VarCurr)
    <=> ( v133499(VarCurr)
        & v133514(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26762,axiom,
    ! [VarCurr] :
      ( v133514(VarCurr)
    <=> ( v133501(VarCurr)
        | v133515(VarCurr) ) ) ).

fof(writeUnaryOperator_11083,axiom,
    ! [VarCurr] :
      ( ~ v133515(VarCurr)
    <=> v133502(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_3098,axiom,
    ! [VarCurr] :
      ( v133499(VarCurr)
    <=> ( v133500(VarCurr)
        | v133502(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_11082,axiom,
    ! [VarCurr] :
      ( ~ v133500(VarCurr)
    <=> v133501(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3097,axiom,
    ! [VarCurr] :
      ( v133501(VarCurr)
    <=> ( v133502(VarCurr,bitIndex4)
        | v133503(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26761,axiom,
    ! [VarCurr] :
      ( v133503(VarCurr)
    <=> ( v133504(VarCurr)
        & v133513(VarCurr) ) ) ).

fof(writeUnaryOperator_11081,axiom,
    ! [VarCurr] :
      ( ~ v133513(VarCurr)
    <=> v133502(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3096,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr)
    <=> ( v133502(VarCurr,bitIndex3)
        | v133505(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26760,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr)
    <=> ( v133506(VarCurr)
        & v133512(VarCurr) ) ) ).

fof(writeUnaryOperator_11080,axiom,
    ! [VarCurr] :
      ( ~ v133512(VarCurr)
    <=> v133502(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_3095,axiom,
    ! [VarCurr] :
      ( v133506(VarCurr)
    <=> ( v133502(VarCurr,bitIndex2)
        | v133507(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26759,axiom,
    ! [VarCurr] :
      ( v133507(VarCurr)
    <=> ( v133508(VarCurr)
        & v133511(VarCurr) ) ) ).

fof(writeUnaryOperator_11079,axiom,
    ! [VarCurr] :
      ( ~ v133511(VarCurr)
    <=> v133502(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3094,axiom,
    ! [VarCurr] :
      ( v133508(VarCurr)
    <=> ( v133502(VarCurr,bitIndex1)
        | v133509(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26758,axiom,
    ! [VarCurr] :
      ( v133509(VarCurr)
    <=> ( v133502(VarCurr,bitIndex0)
        & v133510(VarCurr) ) ) ).

fof(writeUnaryOperator_11078,axiom,
    ! [VarCurr] :
      ( ~ v133510(VarCurr)
    <=> v133502(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_13,axiom,
    ! [VarCurr] : ~ v133502(VarCurr,bitIndex5) ).

fof(addAssignment_43582,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v133502(VarCurr,B)
      <=> v75(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_9311,axiom,
    ! [VarCurr] :
      ( v133494(VarCurr)
    <=> ( ( v75(VarCurr,bitIndex4)
        <=> $false )
        & ( v75(VarCurr,bitIndex3)
        <=> $false )
        & ( v75(VarCurr,bitIndex2)
        <=> $false )
        & ( v75(VarCurr,bitIndex1)
        <=> $false )
        & ( v75(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9310,axiom,
    ! [VarCurr] :
      ( v133491(VarCurr)
    <=> ( ( v133492(VarCurr,bitIndex1)
        <=> $false )
        & ( v133492(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43581,axiom,
    ! [VarCurr] :
      ( v133492(VarCurr,bitIndex0)
    <=> v25(VarCurr) ) ).

fof(addAssignment_43580,axiom,
    ! [VarCurr] :
      ( v133492(VarCurr,bitIndex1)
    <=> v79(VarCurr) ) ).

fof(addAssignmentInitValueVector_42,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v75(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_9309,axiom,
    ! [VarCurr] :
      ( v133489(VarCurr)
    <=> ( ( v133490(VarCurr,bitIndex1)
        <=> $false )
        & ( v133490(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43579,axiom,
    ! [VarCurr] :
      ( v133490(VarCurr,bitIndex0)
    <=> v25(VarCurr) ) ).

fof(addAssignment_43578,axiom,
    ! [VarCurr] :
      ( v133490(VarCurr,bitIndex1)
    <=> v79(VarCurr) ) ).

fof(addAssignment_43577,axiom,
    ! [VarCurr] :
      ( v79(VarCurr)
    <=> v81(VarCurr) ) ).

fof(addAssignment_43576,axiom,
    ! [VarCurr] :
      ( v81(VarCurr)
    <=> v83(VarCurr) ) ).

fof(addAssignment_43575,axiom,
    ! [VarCurr] :
      ( v83(VarCurr)
    <=> v85(VarCurr) ) ).

fof(addAssignment_43574,axiom,
    ! [VarCurr] :
      ( v85(VarCurr)
    <=> v87(VarCurr) ) ).

fof(addAssignment_43573,axiom,
    ! [VarCurr] :
      ( v87(VarCurr)
    <=> v89(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2339,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133476(VarNext)
       => ( v89(VarNext)
        <=> v89(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2476,axiom,
    ! [VarNext] :
      ( v133476(VarNext)
     => ( v89(VarNext)
      <=> v133484(VarNext) ) ) ).

fof(addAssignment_43572,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133484(VarNext)
      <=> v133482(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3191,axiom,
    ! [VarCurr] :
      ( ~ v133485(VarCurr)
     => ( v133482(VarCurr)
      <=> v95(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2995,axiom,
    ! [VarCurr] :
      ( v133485(VarCurr)
     => ( v133482(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_11077,axiom,
    ! [VarCurr] :
      ( ~ v133485(VarCurr)
    <=> v91(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26757,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133476(VarNext)
      <=> v133477(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26756,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133477(VarNext)
      <=> ( v133478(VarNext)
          & v104983(VarNext) ) ) ) ).

fof(writeUnaryOperator_11076,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133478(VarNext)
      <=> v104990(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3190,axiom,
    ! [VarCurr] :
      ( ~ v133468(VarCurr)
     => ( v95(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2994,axiom,
    ! [VarCurr] :
      ( v133468(VarCurr)
     => ( v95(VarCurr)
      <=> v133473(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5410,axiom,
    ! [VarCurr] :
      ( ~ v133470(VarCurr)
     => ( v133473(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5399,axiom,
    ! [VarCurr] :
      ( v133470(VarCurr)
     => ( v133473(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26755,axiom,
    ! [VarCurr] :
      ( v133468(VarCurr)
    <=> ( v133469(VarCurr)
        & v133472(VarCurr) ) ) ).

fof(writeUnaryOperator_11075,axiom,
    ! [VarCurr] :
      ( ~ v133472(VarCurr)
    <=> v105010(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26754,axiom,
    ! [VarCurr] :
      ( v133469(VarCurr)
    <=> ( v133470(VarCurr)
        | v133471(VarCurr) ) ) ).

fof(writeUnaryOperator_11074,axiom,
    ! [VarCurr] :
      ( ~ v133471(VarCurr)
    <=> v105007(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26753,axiom,
    ! [VarCurr] :
      ( v133470(VarCurr)
    <=> ( v129287(VarCurr)
        & v105007(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3189,axiom,
    ! [VarCurr] :
      ( ~ v99(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v97(VarCurr,B)
          <=> v133398(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2993,axiom,
    ! [VarCurr] :
      ( v99(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v97(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_26,axiom,
    ! [VarCurr] :
      ( ( ~ v133399(VarCurr)
        & ~ v133436(VarCurr)
        & ~ v133444(VarCurr)
        & ~ v133452(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v133398(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_186,axiom,
    ! [VarCurr] :
      ( v133452(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133398(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1317,axiom,
    ! [VarCurr] :
      ( v133444(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133398(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5409,axiom,
    ! [VarCurr] :
      ( v133436(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133398(VarCurr,B)
          <=> v133443(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5398,axiom,
    ! [VarCurr] :
      ( v133399(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133398(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26752,axiom,
    ! [VarCurr] :
      ( v133452(VarCurr)
    <=> ( v133454(VarCurr)
        | v133463(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26751,axiom,
    ! [VarCurr] :
      ( v133463(VarCurr)
    <=> ( v133465(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3093,axiom,
    ! [VarCurr] :
      ( v133465(VarCurr)
    <=> ( v133466(VarCurr)
        & v133239(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3092,axiom,
    ! [VarCurr] :
      ( v133466(VarCurr)
    <=> ( v133415(VarCurr)
        & v133239(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26750,axiom,
    ! [VarCurr] :
      ( v133454(VarCurr)
    <=> ( v133455(VarCurr)
        | v133460(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3091,axiom,
    ! [VarCurr] :
      ( v133460(VarCurr)
    <=> ( v133462(VarCurr)
        & v133239(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3090,axiom,
    ! [VarCurr] :
      ( v133462(VarCurr)
    <=> ( v133458(VarCurr)
        & v133239(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3089,axiom,
    ! [VarCurr] :
      ( v133455(VarCurr)
    <=> ( v133457(VarCurr)
        & v133239(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26749,axiom,
    ! [VarCurr] :
      ( v133457(VarCurr)
    <=> ( v133458(VarCurr)
        & v133417(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3088,axiom,
    ! [VarCurr] :
      ( v133458(VarCurr)
    <=> ( v133459(VarCurr)
        & v133239(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3087,axiom,
    ! [VarCurr] :
      ( v133459(VarCurr)
    <=> ( v133410(VarCurr)
        & v133239(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26748,axiom,
    ! [VarCurr] :
      ( v133444(VarCurr)
    <=> ( v133445(VarCurr)
        | v133447(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26747,axiom,
    ! [VarCurr] :
      ( v133447(VarCurr)
    <=> ( v133449(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26746,axiom,
    ! [VarCurr] :
      ( v133449(VarCurr)
    <=> ( v133450(VarCurr)
        & v133417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26745,axiom,
    ! [VarCurr] :
      ( v133450(VarCurr)
    <=> ( v133451(VarCurr)
        & v133416(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3086,axiom,
    ! [VarCurr] :
      ( v133451(VarCurr)
    <=> ( v133427(VarCurr)
        & v133239(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3085,axiom,
    ! [VarCurr] :
      ( v133445(VarCurr)
    <=> ( v133438(VarCurr)
        & v133239(VarCurr,bitIndex6) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3188,axiom,
    ! [VarCurr] :
      ( ~ v133241(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133443(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2992,axiom,
    ! [VarCurr] :
      ( v133241(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133443(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26744,axiom,
    ! [VarCurr] :
      ( v133436(VarCurr)
    <=> ( v133438(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26743,axiom,
    ! [VarCurr] :
      ( v133438(VarCurr)
    <=> ( v133439(VarCurr)
        & v133417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26742,axiom,
    ! [VarCurr] :
      ( v133439(VarCurr)
    <=> ( v133440(VarCurr)
        & v133416(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3084,axiom,
    ! [VarCurr] :
      ( v133440(VarCurr)
    <=> ( v133441(VarCurr)
        & v133239(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26741,axiom,
    ! [VarCurr] :
      ( v133441(VarCurr)
    <=> ( v133442(VarCurr)
        & v133414(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3083,axiom,
    ! [VarCurr] :
      ( v133442(VarCurr)
    <=> ( v133412(VarCurr)
        & v133239(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26740,axiom,
    ! [VarCurr] :
      ( v133399(VarCurr)
    <=> ( v133401(VarCurr)
        | v133434(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3082,axiom,
    ! [VarCurr] :
      ( v133434(VarCurr)
    <=> ( v133421(VarCurr)
        & v133239(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26739,axiom,
    ! [VarCurr] :
      ( v133401(VarCurr)
    <=> ( v133402(VarCurr)
        | v133432(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3081,axiom,
    ! [VarCurr] :
      ( v133432(VarCurr)
    <=> ( v133407(VarCurr)
        & v133239(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26738,axiom,
    ! [VarCurr] :
      ( v133402(VarCurr)
    <=> ( v133403(VarCurr)
        | v133429(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26737,axiom,
    ! [VarCurr] :
      ( v133429(VarCurr)
    <=> ( v133431(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3080,axiom,
    ! [VarCurr] :
      ( v133431(VarCurr)
    <=> ( v133425(VarCurr)
        & v133239(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26736,axiom,
    ! [VarCurr] :
      ( v133403(VarCurr)
    <=> ( v133404(VarCurr)
        | v133422(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26735,axiom,
    ! [VarCurr] :
      ( v133422(VarCurr)
    <=> ( v133424(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26734,axiom,
    ! [VarCurr] :
      ( v133424(VarCurr)
    <=> ( v133425(VarCurr)
        & v133417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26733,axiom,
    ! [VarCurr] :
      ( v133425(VarCurr)
    <=> ( v133426(VarCurr)
        & v133416(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26732,axiom,
    ! [VarCurr] :
      ( v133426(VarCurr)
    <=> ( v133427(VarCurr)
        & v133415(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26731,axiom,
    ! [VarCurr] :
      ( v133427(VarCurr)
    <=> ( v133428(VarCurr)
        & v133414(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26730,axiom,
    ! [VarCurr] :
      ( v133428(VarCurr)
    <=> ( v133239(VarCurr,bitIndex0)
        & v133413(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26729,axiom,
    ! [VarCurr] :
      ( v133404(VarCurr)
    <=> ( v133405(VarCurr)
        | v133419(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26728,axiom,
    ! [VarCurr] :
      ( v133419(VarCurr)
    <=> ( v133421(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3079,axiom,
    ! [VarCurr] :
      ( v133421(VarCurr)
    <=> ( v133408(VarCurr)
        & v133239(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26727,axiom,
    ! [VarCurr] :
      ( v133405(VarCurr)
    <=> ( v133407(VarCurr)
        & v133418(VarCurr) ) ) ).

fof(writeUnaryOperator_11073,axiom,
    ! [VarCurr] :
      ( ~ v133418(VarCurr)
    <=> v133239(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26726,axiom,
    ! [VarCurr] :
      ( v133407(VarCurr)
    <=> ( v133408(VarCurr)
        & v133417(VarCurr) ) ) ).

fof(writeUnaryOperator_11072,axiom,
    ! [VarCurr] :
      ( ~ v133417(VarCurr)
    <=> v133239(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26725,axiom,
    ! [VarCurr] :
      ( v133408(VarCurr)
    <=> ( v133409(VarCurr)
        & v133416(VarCurr) ) ) ).

fof(writeUnaryOperator_11071,axiom,
    ! [VarCurr] :
      ( ~ v133416(VarCurr)
    <=> v133239(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26724,axiom,
    ! [VarCurr] :
      ( v133409(VarCurr)
    <=> ( v133410(VarCurr)
        & v133415(VarCurr) ) ) ).

fof(writeUnaryOperator_11070,axiom,
    ! [VarCurr] :
      ( ~ v133415(VarCurr)
    <=> v133239(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26723,axiom,
    ! [VarCurr] :
      ( v133410(VarCurr)
    <=> ( v133411(VarCurr)
        & v133414(VarCurr) ) ) ).

fof(writeUnaryOperator_11069,axiom,
    ! [VarCurr] :
      ( ~ v133414(VarCurr)
    <=> v133239(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26722,axiom,
    ! [VarCurr] :
      ( v133411(VarCurr)
    <=> ( v133412(VarCurr)
        & v133413(VarCurr) ) ) ).

fof(writeUnaryOperator_11068,axiom,
    ! [VarCurr] :
      ( ~ v133413(VarCurr)
    <=> v133239(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11067,axiom,
    ! [VarCurr] :
      ( ~ v133412(VarCurr)
    <=> v133239(VarCurr,bitIndex0) ) ).

fof(addAssignment_43571,axiom,
    ! [VarCurr] :
      ( v133241(VarCurr)
    <=> v105126(VarCurr,bitIndex81) ) ).

fof(addAssignment_43570,axiom,
    ! [VarCurr] :
      ( v105126(VarCurr,bitIndex81)
    <=> v105128(VarCurr,bitIndex81) ) ).

fof(addAssignment_43569,axiom,
    ! [VarCurr] :
      ( v105128(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex696) ) ).

fof(addAssignment_43568,axiom,
    ! [VarNext] :
      ( v105130(VarNext,bitIndex696)
    <=> v133390(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133392(VarNext)
       => ( ( v133390(VarNext,bitIndex122)
          <=> v105130(VarCurr,bitIndex737) )
          & ( v133390(VarNext,bitIndex121)
          <=> v105130(VarCurr,bitIndex736) )
          & ( v133390(VarNext,bitIndex120)
          <=> v105130(VarCurr,bitIndex735) )
          & ( v133390(VarNext,bitIndex119)
          <=> v105130(VarCurr,bitIndex734) )
          & ( v133390(VarNext,bitIndex118)
          <=> v105130(VarCurr,bitIndex733) )
          & ( v133390(VarNext,bitIndex117)
          <=> v105130(VarCurr,bitIndex732) )
          & ( v133390(VarNext,bitIndex116)
          <=> v105130(VarCurr,bitIndex731) )
          & ( v133390(VarNext,bitIndex115)
          <=> v105130(VarCurr,bitIndex730) )
          & ( v133390(VarNext,bitIndex114)
          <=> v105130(VarCurr,bitIndex729) )
          & ( v133390(VarNext,bitIndex113)
          <=> v105130(VarCurr,bitIndex728) )
          & ( v133390(VarNext,bitIndex112)
          <=> v105130(VarCurr,bitIndex727) )
          & ( v133390(VarNext,bitIndex111)
          <=> v105130(VarCurr,bitIndex726) )
          & ( v133390(VarNext,bitIndex110)
          <=> v105130(VarCurr,bitIndex725) )
          & ( v133390(VarNext,bitIndex109)
          <=> v105130(VarCurr,bitIndex724) )
          & ( v133390(VarNext,bitIndex108)
          <=> v105130(VarCurr,bitIndex723) )
          & ( v133390(VarNext,bitIndex107)
          <=> v105130(VarCurr,bitIndex722) )
          & ( v133390(VarNext,bitIndex106)
          <=> v105130(VarCurr,bitIndex721) )
          & ( v133390(VarNext,bitIndex105)
          <=> v105130(VarCurr,bitIndex720) )
          & ( v133390(VarNext,bitIndex104)
          <=> v105130(VarCurr,bitIndex719) )
          & ( v133390(VarNext,bitIndex103)
          <=> v105130(VarCurr,bitIndex718) )
          & ( v133390(VarNext,bitIndex102)
          <=> v105130(VarCurr,bitIndex717) )
          & ( v133390(VarNext,bitIndex101)
          <=> v105130(VarCurr,bitIndex716) )
          & ( v133390(VarNext,bitIndex100)
          <=> v105130(VarCurr,bitIndex715) )
          & ( v133390(VarNext,bitIndex99)
          <=> v105130(VarCurr,bitIndex714) )
          & ( v133390(VarNext,bitIndex98)
          <=> v105130(VarCurr,bitIndex713) )
          & ( v133390(VarNext,bitIndex97)
          <=> v105130(VarCurr,bitIndex712) )
          & ( v133390(VarNext,bitIndex96)
          <=> v105130(VarCurr,bitIndex711) )
          & ( v133390(VarNext,bitIndex95)
          <=> v105130(VarCurr,bitIndex710) )
          & ( v133390(VarNext,bitIndex94)
          <=> v105130(VarCurr,bitIndex709) )
          & ( v133390(VarNext,bitIndex93)
          <=> v105130(VarCurr,bitIndex708) )
          & ( v133390(VarNext,bitIndex92)
          <=> v105130(VarCurr,bitIndex707) )
          & ( v133390(VarNext,bitIndex91)
          <=> v105130(VarCurr,bitIndex706) )
          & ( v133390(VarNext,bitIndex90)
          <=> v105130(VarCurr,bitIndex705) )
          & ( v133390(VarNext,bitIndex89)
          <=> v105130(VarCurr,bitIndex704) )
          & ( v133390(VarNext,bitIndex88)
          <=> v105130(VarCurr,bitIndex703) )
          & ( v133390(VarNext,bitIndex87)
          <=> v105130(VarCurr,bitIndex702) )
          & ( v133390(VarNext,bitIndex86)
          <=> v105130(VarCurr,bitIndex701) )
          & ( v133390(VarNext,bitIndex85)
          <=> v105130(VarCurr,bitIndex700) )
          & ( v133390(VarNext,bitIndex84)
          <=> v105130(VarCurr,bitIndex699) )
          & ( v133390(VarNext,bitIndex83)
          <=> v105130(VarCurr,bitIndex698) )
          & ( v133390(VarNext,bitIndex82)
          <=> v105130(VarCurr,bitIndex697) )
          & ( v133390(VarNext,bitIndex81)
          <=> v105130(VarCurr,bitIndex696) )
          & ( v133390(VarNext,bitIndex80)
          <=> v105130(VarCurr,bitIndex695) )
          & ( v133390(VarNext,bitIndex79)
          <=> v105130(VarCurr,bitIndex694) )
          & ( v133390(VarNext,bitIndex78)
          <=> v105130(VarCurr,bitIndex693) )
          & ( v133390(VarNext,bitIndex77)
          <=> v105130(VarCurr,bitIndex692) )
          & ( v133390(VarNext,bitIndex76)
          <=> v105130(VarCurr,bitIndex691) )
          & ( v133390(VarNext,bitIndex75)
          <=> v105130(VarCurr,bitIndex690) )
          & ( v133390(VarNext,bitIndex74)
          <=> v105130(VarCurr,bitIndex689) )
          & ( v133390(VarNext,bitIndex73)
          <=> v105130(VarCurr,bitIndex688) )
          & ( v133390(VarNext,bitIndex72)
          <=> v105130(VarCurr,bitIndex687) )
          & ( v133390(VarNext,bitIndex71)
          <=> v105130(VarCurr,bitIndex686) )
          & ( v133390(VarNext,bitIndex70)
          <=> v105130(VarCurr,bitIndex685) )
          & ( v133390(VarNext,bitIndex69)
          <=> v105130(VarCurr,bitIndex684) )
          & ( v133390(VarNext,bitIndex68)
          <=> v105130(VarCurr,bitIndex683) )
          & ( v133390(VarNext,bitIndex67)
          <=> v105130(VarCurr,bitIndex682) )
          & ( v133390(VarNext,bitIndex66)
          <=> v105130(VarCurr,bitIndex681) )
          & ( v133390(VarNext,bitIndex65)
          <=> v105130(VarCurr,bitIndex680) )
          & ( v133390(VarNext,bitIndex64)
          <=> v105130(VarCurr,bitIndex679) )
          & ( v133390(VarNext,bitIndex63)
          <=> v105130(VarCurr,bitIndex678) )
          & ( v133390(VarNext,bitIndex62)
          <=> v105130(VarCurr,bitIndex677) )
          & ( v133390(VarNext,bitIndex61)
          <=> v105130(VarCurr,bitIndex676) )
          & ( v133390(VarNext,bitIndex60)
          <=> v105130(VarCurr,bitIndex675) )
          & ( v133390(VarNext,bitIndex59)
          <=> v105130(VarCurr,bitIndex674) )
          & ( v133390(VarNext,bitIndex58)
          <=> v105130(VarCurr,bitIndex673) )
          & ( v133390(VarNext,bitIndex57)
          <=> v105130(VarCurr,bitIndex672) )
          & ( v133390(VarNext,bitIndex56)
          <=> v105130(VarCurr,bitIndex671) )
          & ( v133390(VarNext,bitIndex55)
          <=> v105130(VarCurr,bitIndex670) )
          & ( v133390(VarNext,bitIndex54)
          <=> v105130(VarCurr,bitIndex669) )
          & ( v133390(VarNext,bitIndex53)
          <=> v105130(VarCurr,bitIndex668) )
          & ( v133390(VarNext,bitIndex52)
          <=> v105130(VarCurr,bitIndex667) )
          & ( v133390(VarNext,bitIndex51)
          <=> v105130(VarCurr,bitIndex666) )
          & ( v133390(VarNext,bitIndex50)
          <=> v105130(VarCurr,bitIndex665) )
          & ( v133390(VarNext,bitIndex49)
          <=> v105130(VarCurr,bitIndex664) )
          & ( v133390(VarNext,bitIndex48)
          <=> v105130(VarCurr,bitIndex663) )
          & ( v133390(VarNext,bitIndex47)
          <=> v105130(VarCurr,bitIndex662) )
          & ( v133390(VarNext,bitIndex46)
          <=> v105130(VarCurr,bitIndex661) )
          & ( v133390(VarNext,bitIndex45)
          <=> v105130(VarCurr,bitIndex660) )
          & ( v133390(VarNext,bitIndex44)
          <=> v105130(VarCurr,bitIndex659) )
          & ( v133390(VarNext,bitIndex43)
          <=> v105130(VarCurr,bitIndex658) )
          & ( v133390(VarNext,bitIndex42)
          <=> v105130(VarCurr,bitIndex657) )
          & ( v133390(VarNext,bitIndex41)
          <=> v105130(VarCurr,bitIndex656) )
          & ( v133390(VarNext,bitIndex40)
          <=> v105130(VarCurr,bitIndex655) )
          & ( v133390(VarNext,bitIndex39)
          <=> v105130(VarCurr,bitIndex654) )
          & ( v133390(VarNext,bitIndex38)
          <=> v105130(VarCurr,bitIndex653) )
          & ( v133390(VarNext,bitIndex37)
          <=> v105130(VarCurr,bitIndex652) )
          & ( v133390(VarNext,bitIndex36)
          <=> v105130(VarCurr,bitIndex651) )
          & ( v133390(VarNext,bitIndex35)
          <=> v105130(VarCurr,bitIndex650) )
          & ( v133390(VarNext,bitIndex34)
          <=> v105130(VarCurr,bitIndex649) )
          & ( v133390(VarNext,bitIndex33)
          <=> v105130(VarCurr,bitIndex648) )
          & ( v133390(VarNext,bitIndex32)
          <=> v105130(VarCurr,bitIndex647) )
          & ( v133390(VarNext,bitIndex31)
          <=> v105130(VarCurr,bitIndex646) )
          & ( v133390(VarNext,bitIndex30)
          <=> v105130(VarCurr,bitIndex645) )
          & ( v133390(VarNext,bitIndex29)
          <=> v105130(VarCurr,bitIndex644) )
          & ( v133390(VarNext,bitIndex28)
          <=> v105130(VarCurr,bitIndex643) )
          & ( v133390(VarNext,bitIndex27)
          <=> v105130(VarCurr,bitIndex642) )
          & ( v133390(VarNext,bitIndex26)
          <=> v105130(VarCurr,bitIndex641) )
          & ( v133390(VarNext,bitIndex25)
          <=> v105130(VarCurr,bitIndex640) )
          & ( v133390(VarNext,bitIndex24)
          <=> v105130(VarCurr,bitIndex639) )
          & ( v133390(VarNext,bitIndex23)
          <=> v105130(VarCurr,bitIndex638) )
          & ( v133390(VarNext,bitIndex22)
          <=> v105130(VarCurr,bitIndex637) )
          & ( v133390(VarNext,bitIndex21)
          <=> v105130(VarCurr,bitIndex636) )
          & ( v133390(VarNext,bitIndex20)
          <=> v105130(VarCurr,bitIndex635) )
          & ( v133390(VarNext,bitIndex19)
          <=> v105130(VarCurr,bitIndex634) )
          & ( v133390(VarNext,bitIndex18)
          <=> v105130(VarCurr,bitIndex633) )
          & ( v133390(VarNext,bitIndex17)
          <=> v105130(VarCurr,bitIndex632) )
          & ( v133390(VarNext,bitIndex16)
          <=> v105130(VarCurr,bitIndex631) )
          & ( v133390(VarNext,bitIndex15)
          <=> v105130(VarCurr,bitIndex630) )
          & ( v133390(VarNext,bitIndex14)
          <=> v105130(VarCurr,bitIndex629) )
          & ( v133390(VarNext,bitIndex13)
          <=> v105130(VarCurr,bitIndex628) )
          & ( v133390(VarNext,bitIndex12)
          <=> v105130(VarCurr,bitIndex627) )
          & ( v133390(VarNext,bitIndex11)
          <=> v105130(VarCurr,bitIndex626) )
          & ( v133390(VarNext,bitIndex10)
          <=> v105130(VarCurr,bitIndex625) )
          & ( v133390(VarNext,bitIndex9)
          <=> v105130(VarCurr,bitIndex624) )
          & ( v133390(VarNext,bitIndex8)
          <=> v105130(VarCurr,bitIndex623) )
          & ( v133390(VarNext,bitIndex7)
          <=> v105130(VarCurr,bitIndex622) )
          & ( v133390(VarNext,bitIndex6)
          <=> v105130(VarCurr,bitIndex621) )
          & ( v133390(VarNext,bitIndex5)
          <=> v105130(VarCurr,bitIndex620) )
          & ( v133390(VarNext,bitIndex4)
          <=> v105130(VarCurr,bitIndex619) )
          & ( v133390(VarNext,bitIndex3)
          <=> v105130(VarCurr,bitIndex618) )
          & ( v133390(VarNext,bitIndex2)
          <=> v105130(VarCurr,bitIndex617) )
          & ( v133390(VarNext,bitIndex1)
          <=> v105130(VarCurr,bitIndex616) )
          & ( v133390(VarNext,bitIndex0)
          <=> v105130(VarCurr,bitIndex615) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2475,axiom,
    ! [VarNext] :
      ( v133392(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133390(VarNext,B)
          <=> v105546(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26721,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133392(VarNext)
      <=> ( v133393(VarNext)
          & v105528(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26720,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133393(VarNext)
      <=> ( v133395(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11066,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133395(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43567,axiom,
    ! [VarCurr] :
      ( v105512(VarCurr,bitIndex81)
    <=> v105517(VarCurr,bitIndex81) ) ).

fof(addAssignment_43566,axiom,
    ! [VarCurr] :
      ( v105516(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex573) ) ).

fof(addAssignment_43565,axiom,
    ! [VarCurr] :
      ( v105505(VarCurr,bitIndex81)
    <=> v105510(VarCurr,bitIndex81) ) ).

fof(addAssignment_43564,axiom,
    ! [VarCurr] :
      ( v105509(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex696) ) ).

fof(addAssignment_43563,axiom,
    ! [VarNext] :
      ( v105130(VarNext,bitIndex573)
    <=> v133382(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_152,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133384(VarNext)
       => ( ( v133382(VarNext,bitIndex122)
          <=> v105130(VarCurr,bitIndex614) )
          & ( v133382(VarNext,bitIndex121)
          <=> v105130(VarCurr,bitIndex613) )
          & ( v133382(VarNext,bitIndex120)
          <=> v105130(VarCurr,bitIndex612) )
          & ( v133382(VarNext,bitIndex119)
          <=> v105130(VarCurr,bitIndex611) )
          & ( v133382(VarNext,bitIndex118)
          <=> v105130(VarCurr,bitIndex610) )
          & ( v133382(VarNext,bitIndex117)
          <=> v105130(VarCurr,bitIndex609) )
          & ( v133382(VarNext,bitIndex116)
          <=> v105130(VarCurr,bitIndex608) )
          & ( v133382(VarNext,bitIndex115)
          <=> v105130(VarCurr,bitIndex607) )
          & ( v133382(VarNext,bitIndex114)
          <=> v105130(VarCurr,bitIndex606) )
          & ( v133382(VarNext,bitIndex113)
          <=> v105130(VarCurr,bitIndex605) )
          & ( v133382(VarNext,bitIndex112)
          <=> v105130(VarCurr,bitIndex604) )
          & ( v133382(VarNext,bitIndex111)
          <=> v105130(VarCurr,bitIndex603) )
          & ( v133382(VarNext,bitIndex110)
          <=> v105130(VarCurr,bitIndex602) )
          & ( v133382(VarNext,bitIndex109)
          <=> v105130(VarCurr,bitIndex601) )
          & ( v133382(VarNext,bitIndex108)
          <=> v105130(VarCurr,bitIndex600) )
          & ( v133382(VarNext,bitIndex107)
          <=> v105130(VarCurr,bitIndex599) )
          & ( v133382(VarNext,bitIndex106)
          <=> v105130(VarCurr,bitIndex598) )
          & ( v133382(VarNext,bitIndex105)
          <=> v105130(VarCurr,bitIndex597) )
          & ( v133382(VarNext,bitIndex104)
          <=> v105130(VarCurr,bitIndex596) )
          & ( v133382(VarNext,bitIndex103)
          <=> v105130(VarCurr,bitIndex595) )
          & ( v133382(VarNext,bitIndex102)
          <=> v105130(VarCurr,bitIndex594) )
          & ( v133382(VarNext,bitIndex101)
          <=> v105130(VarCurr,bitIndex593) )
          & ( v133382(VarNext,bitIndex100)
          <=> v105130(VarCurr,bitIndex592) )
          & ( v133382(VarNext,bitIndex99)
          <=> v105130(VarCurr,bitIndex591) )
          & ( v133382(VarNext,bitIndex98)
          <=> v105130(VarCurr,bitIndex590) )
          & ( v133382(VarNext,bitIndex97)
          <=> v105130(VarCurr,bitIndex589) )
          & ( v133382(VarNext,bitIndex96)
          <=> v105130(VarCurr,bitIndex588) )
          & ( v133382(VarNext,bitIndex95)
          <=> v105130(VarCurr,bitIndex587) )
          & ( v133382(VarNext,bitIndex94)
          <=> v105130(VarCurr,bitIndex586) )
          & ( v133382(VarNext,bitIndex93)
          <=> v105130(VarCurr,bitIndex585) )
          & ( v133382(VarNext,bitIndex92)
          <=> v105130(VarCurr,bitIndex584) )
          & ( v133382(VarNext,bitIndex91)
          <=> v105130(VarCurr,bitIndex583) )
          & ( v133382(VarNext,bitIndex90)
          <=> v105130(VarCurr,bitIndex582) )
          & ( v133382(VarNext,bitIndex89)
          <=> v105130(VarCurr,bitIndex581) )
          & ( v133382(VarNext,bitIndex88)
          <=> v105130(VarCurr,bitIndex580) )
          & ( v133382(VarNext,bitIndex87)
          <=> v105130(VarCurr,bitIndex579) )
          & ( v133382(VarNext,bitIndex86)
          <=> v105130(VarCurr,bitIndex578) )
          & ( v133382(VarNext,bitIndex85)
          <=> v105130(VarCurr,bitIndex577) )
          & ( v133382(VarNext,bitIndex84)
          <=> v105130(VarCurr,bitIndex576) )
          & ( v133382(VarNext,bitIndex83)
          <=> v105130(VarCurr,bitIndex575) )
          & ( v133382(VarNext,bitIndex82)
          <=> v105130(VarCurr,bitIndex574) )
          & ( v133382(VarNext,bitIndex81)
          <=> v105130(VarCurr,bitIndex573) )
          & ( v133382(VarNext,bitIndex80)
          <=> v105130(VarCurr,bitIndex572) )
          & ( v133382(VarNext,bitIndex79)
          <=> v105130(VarCurr,bitIndex571) )
          & ( v133382(VarNext,bitIndex78)
          <=> v105130(VarCurr,bitIndex570) )
          & ( v133382(VarNext,bitIndex77)
          <=> v105130(VarCurr,bitIndex569) )
          & ( v133382(VarNext,bitIndex76)
          <=> v105130(VarCurr,bitIndex568) )
          & ( v133382(VarNext,bitIndex75)
          <=> v105130(VarCurr,bitIndex567) )
          & ( v133382(VarNext,bitIndex74)
          <=> v105130(VarCurr,bitIndex566) )
          & ( v133382(VarNext,bitIndex73)
          <=> v105130(VarCurr,bitIndex565) )
          & ( v133382(VarNext,bitIndex72)
          <=> v105130(VarCurr,bitIndex564) )
          & ( v133382(VarNext,bitIndex71)
          <=> v105130(VarCurr,bitIndex563) )
          & ( v133382(VarNext,bitIndex70)
          <=> v105130(VarCurr,bitIndex562) )
          & ( v133382(VarNext,bitIndex69)
          <=> v105130(VarCurr,bitIndex561) )
          & ( v133382(VarNext,bitIndex68)
          <=> v105130(VarCurr,bitIndex560) )
          & ( v133382(VarNext,bitIndex67)
          <=> v105130(VarCurr,bitIndex559) )
          & ( v133382(VarNext,bitIndex66)
          <=> v105130(VarCurr,bitIndex558) )
          & ( v133382(VarNext,bitIndex65)
          <=> v105130(VarCurr,bitIndex557) )
          & ( v133382(VarNext,bitIndex64)
          <=> v105130(VarCurr,bitIndex556) )
          & ( v133382(VarNext,bitIndex63)
          <=> v105130(VarCurr,bitIndex555) )
          & ( v133382(VarNext,bitIndex62)
          <=> v105130(VarCurr,bitIndex554) )
          & ( v133382(VarNext,bitIndex61)
          <=> v105130(VarCurr,bitIndex553) )
          & ( v133382(VarNext,bitIndex60)
          <=> v105130(VarCurr,bitIndex552) )
          & ( v133382(VarNext,bitIndex59)
          <=> v105130(VarCurr,bitIndex551) )
          & ( v133382(VarNext,bitIndex58)
          <=> v105130(VarCurr,bitIndex550) )
          & ( v133382(VarNext,bitIndex57)
          <=> v105130(VarCurr,bitIndex549) )
          & ( v133382(VarNext,bitIndex56)
          <=> v105130(VarCurr,bitIndex548) )
          & ( v133382(VarNext,bitIndex55)
          <=> v105130(VarCurr,bitIndex547) )
          & ( v133382(VarNext,bitIndex54)
          <=> v105130(VarCurr,bitIndex546) )
          & ( v133382(VarNext,bitIndex53)
          <=> v105130(VarCurr,bitIndex545) )
          & ( v133382(VarNext,bitIndex52)
          <=> v105130(VarCurr,bitIndex544) )
          & ( v133382(VarNext,bitIndex51)
          <=> v105130(VarCurr,bitIndex543) )
          & ( v133382(VarNext,bitIndex50)
          <=> v105130(VarCurr,bitIndex542) )
          & ( v133382(VarNext,bitIndex49)
          <=> v105130(VarCurr,bitIndex541) )
          & ( v133382(VarNext,bitIndex48)
          <=> v105130(VarCurr,bitIndex540) )
          & ( v133382(VarNext,bitIndex47)
          <=> v105130(VarCurr,bitIndex539) )
          & ( v133382(VarNext,bitIndex46)
          <=> v105130(VarCurr,bitIndex538) )
          & ( v133382(VarNext,bitIndex45)
          <=> v105130(VarCurr,bitIndex537) )
          & ( v133382(VarNext,bitIndex44)
          <=> v105130(VarCurr,bitIndex536) )
          & ( v133382(VarNext,bitIndex43)
          <=> v105130(VarCurr,bitIndex535) )
          & ( v133382(VarNext,bitIndex42)
          <=> v105130(VarCurr,bitIndex534) )
          & ( v133382(VarNext,bitIndex41)
          <=> v105130(VarCurr,bitIndex533) )
          & ( v133382(VarNext,bitIndex40)
          <=> v105130(VarCurr,bitIndex532) )
          & ( v133382(VarNext,bitIndex39)
          <=> v105130(VarCurr,bitIndex531) )
          & ( v133382(VarNext,bitIndex38)
          <=> v105130(VarCurr,bitIndex530) )
          & ( v133382(VarNext,bitIndex37)
          <=> v105130(VarCurr,bitIndex529) )
          & ( v133382(VarNext,bitIndex36)
          <=> v105130(VarCurr,bitIndex528) )
          & ( v133382(VarNext,bitIndex35)
          <=> v105130(VarCurr,bitIndex527) )
          & ( v133382(VarNext,bitIndex34)
          <=> v105130(VarCurr,bitIndex526) )
          & ( v133382(VarNext,bitIndex33)
          <=> v105130(VarCurr,bitIndex525) )
          & ( v133382(VarNext,bitIndex32)
          <=> v105130(VarCurr,bitIndex524) )
          & ( v133382(VarNext,bitIndex31)
          <=> v105130(VarCurr,bitIndex523) )
          & ( v133382(VarNext,bitIndex30)
          <=> v105130(VarCurr,bitIndex522) )
          & ( v133382(VarNext,bitIndex29)
          <=> v105130(VarCurr,bitIndex521) )
          & ( v133382(VarNext,bitIndex28)
          <=> v105130(VarCurr,bitIndex520) )
          & ( v133382(VarNext,bitIndex27)
          <=> v105130(VarCurr,bitIndex519) )
          & ( v133382(VarNext,bitIndex26)
          <=> v105130(VarCurr,bitIndex518) )
          & ( v133382(VarNext,bitIndex25)
          <=> v105130(VarCurr,bitIndex517) )
          & ( v133382(VarNext,bitIndex24)
          <=> v105130(VarCurr,bitIndex516) )
          & ( v133382(VarNext,bitIndex23)
          <=> v105130(VarCurr,bitIndex515) )
          & ( v133382(VarNext,bitIndex22)
          <=> v105130(VarCurr,bitIndex514) )
          & ( v133382(VarNext,bitIndex21)
          <=> v105130(VarCurr,bitIndex513) )
          & ( v133382(VarNext,bitIndex20)
          <=> v105130(VarCurr,bitIndex512) )
          & ( v133382(VarNext,bitIndex19)
          <=> v105130(VarCurr,bitIndex511) )
          & ( v133382(VarNext,bitIndex18)
          <=> v105130(VarCurr,bitIndex510) )
          & ( v133382(VarNext,bitIndex17)
          <=> v105130(VarCurr,bitIndex509) )
          & ( v133382(VarNext,bitIndex16)
          <=> v105130(VarCurr,bitIndex508) )
          & ( v133382(VarNext,bitIndex15)
          <=> v105130(VarCurr,bitIndex507) )
          & ( v133382(VarNext,bitIndex14)
          <=> v105130(VarCurr,bitIndex506) )
          & ( v133382(VarNext,bitIndex13)
          <=> v105130(VarCurr,bitIndex505) )
          & ( v133382(VarNext,bitIndex12)
          <=> v105130(VarCurr,bitIndex504) )
          & ( v133382(VarNext,bitIndex11)
          <=> v105130(VarCurr,bitIndex503) )
          & ( v133382(VarNext,bitIndex10)
          <=> v105130(VarCurr,bitIndex502) )
          & ( v133382(VarNext,bitIndex9)
          <=> v105130(VarCurr,bitIndex501) )
          & ( v133382(VarNext,bitIndex8)
          <=> v105130(VarCurr,bitIndex500) )
          & ( v133382(VarNext,bitIndex7)
          <=> v105130(VarCurr,bitIndex499) )
          & ( v133382(VarNext,bitIndex6)
          <=> v105130(VarCurr,bitIndex498) )
          & ( v133382(VarNext,bitIndex5)
          <=> v105130(VarCurr,bitIndex497) )
          & ( v133382(VarNext,bitIndex4)
          <=> v105130(VarCurr,bitIndex496) )
          & ( v133382(VarNext,bitIndex3)
          <=> v105130(VarCurr,bitIndex495) )
          & ( v133382(VarNext,bitIndex2)
          <=> v105130(VarCurr,bitIndex494) )
          & ( v133382(VarNext,bitIndex1)
          <=> v105130(VarCurr,bitIndex493) )
          & ( v133382(VarNext,bitIndex0)
          <=> v105130(VarCurr,bitIndex492) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2474,axiom,
    ! [VarNext] :
      ( v133384(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133382(VarNext,B)
          <=> v105500(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26719,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133384(VarNext)
      <=> ( v133385(VarNext)
          & v105482(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26718,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133385(VarNext)
      <=> ( v133387(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11065,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133387(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43562,axiom,
    ! [VarCurr] :
      ( v105466(VarCurr,bitIndex81)
    <=> v105471(VarCurr,bitIndex81) ) ).

fof(addAssignment_43561,axiom,
    ! [VarCurr] :
      ( v105470(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex450) ) ).

fof(addAssignment_43560,axiom,
    ! [VarCurr] :
      ( v105459(VarCurr,bitIndex81)
    <=> v105464(VarCurr,bitIndex81) ) ).

fof(addAssignment_43559,axiom,
    ! [VarCurr] :
      ( v105463(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex573) ) ).

fof(addAssignment_43558,axiom,
    ! [VarNext] :
      ( v105130(VarNext,bitIndex450)
    <=> v133374(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133376(VarNext)
       => ( ( v133374(VarNext,bitIndex122)
          <=> v105130(VarCurr,bitIndex491) )
          & ( v133374(VarNext,bitIndex121)
          <=> v105130(VarCurr,bitIndex490) )
          & ( v133374(VarNext,bitIndex120)
          <=> v105130(VarCurr,bitIndex489) )
          & ( v133374(VarNext,bitIndex119)
          <=> v105130(VarCurr,bitIndex488) )
          & ( v133374(VarNext,bitIndex118)
          <=> v105130(VarCurr,bitIndex487) )
          & ( v133374(VarNext,bitIndex117)
          <=> v105130(VarCurr,bitIndex486) )
          & ( v133374(VarNext,bitIndex116)
          <=> v105130(VarCurr,bitIndex485) )
          & ( v133374(VarNext,bitIndex115)
          <=> v105130(VarCurr,bitIndex484) )
          & ( v133374(VarNext,bitIndex114)
          <=> v105130(VarCurr,bitIndex483) )
          & ( v133374(VarNext,bitIndex113)
          <=> v105130(VarCurr,bitIndex482) )
          & ( v133374(VarNext,bitIndex112)
          <=> v105130(VarCurr,bitIndex481) )
          & ( v133374(VarNext,bitIndex111)
          <=> v105130(VarCurr,bitIndex480) )
          & ( v133374(VarNext,bitIndex110)
          <=> v105130(VarCurr,bitIndex479) )
          & ( v133374(VarNext,bitIndex109)
          <=> v105130(VarCurr,bitIndex478) )
          & ( v133374(VarNext,bitIndex108)
          <=> v105130(VarCurr,bitIndex477) )
          & ( v133374(VarNext,bitIndex107)
          <=> v105130(VarCurr,bitIndex476) )
          & ( v133374(VarNext,bitIndex106)
          <=> v105130(VarCurr,bitIndex475) )
          & ( v133374(VarNext,bitIndex105)
          <=> v105130(VarCurr,bitIndex474) )
          & ( v133374(VarNext,bitIndex104)
          <=> v105130(VarCurr,bitIndex473) )
          & ( v133374(VarNext,bitIndex103)
          <=> v105130(VarCurr,bitIndex472) )
          & ( v133374(VarNext,bitIndex102)
          <=> v105130(VarCurr,bitIndex471) )
          & ( v133374(VarNext,bitIndex101)
          <=> v105130(VarCurr,bitIndex470) )
          & ( v133374(VarNext,bitIndex100)
          <=> v105130(VarCurr,bitIndex469) )
          & ( v133374(VarNext,bitIndex99)
          <=> v105130(VarCurr,bitIndex468) )
          & ( v133374(VarNext,bitIndex98)
          <=> v105130(VarCurr,bitIndex467) )
          & ( v133374(VarNext,bitIndex97)
          <=> v105130(VarCurr,bitIndex466) )
          & ( v133374(VarNext,bitIndex96)
          <=> v105130(VarCurr,bitIndex465) )
          & ( v133374(VarNext,bitIndex95)
          <=> v105130(VarCurr,bitIndex464) )
          & ( v133374(VarNext,bitIndex94)
          <=> v105130(VarCurr,bitIndex463) )
          & ( v133374(VarNext,bitIndex93)
          <=> v105130(VarCurr,bitIndex462) )
          & ( v133374(VarNext,bitIndex92)
          <=> v105130(VarCurr,bitIndex461) )
          & ( v133374(VarNext,bitIndex91)
          <=> v105130(VarCurr,bitIndex460) )
          & ( v133374(VarNext,bitIndex90)
          <=> v105130(VarCurr,bitIndex459) )
          & ( v133374(VarNext,bitIndex89)
          <=> v105130(VarCurr,bitIndex458) )
          & ( v133374(VarNext,bitIndex88)
          <=> v105130(VarCurr,bitIndex457) )
          & ( v133374(VarNext,bitIndex87)
          <=> v105130(VarCurr,bitIndex456) )
          & ( v133374(VarNext,bitIndex86)
          <=> v105130(VarCurr,bitIndex455) )
          & ( v133374(VarNext,bitIndex85)
          <=> v105130(VarCurr,bitIndex454) )
          & ( v133374(VarNext,bitIndex84)
          <=> v105130(VarCurr,bitIndex453) )
          & ( v133374(VarNext,bitIndex83)
          <=> v105130(VarCurr,bitIndex452) )
          & ( v133374(VarNext,bitIndex82)
          <=> v105130(VarCurr,bitIndex451) )
          & ( v133374(VarNext,bitIndex81)
          <=> v105130(VarCurr,bitIndex450) )
          & ( v133374(VarNext,bitIndex80)
          <=> v105130(VarCurr,bitIndex449) )
          & ( v133374(VarNext,bitIndex79)
          <=> v105130(VarCurr,bitIndex448) )
          & ( v133374(VarNext,bitIndex78)
          <=> v105130(VarCurr,bitIndex447) )
          & ( v133374(VarNext,bitIndex77)
          <=> v105130(VarCurr,bitIndex446) )
          & ( v133374(VarNext,bitIndex76)
          <=> v105130(VarCurr,bitIndex445) )
          & ( v133374(VarNext,bitIndex75)
          <=> v105130(VarCurr,bitIndex444) )
          & ( v133374(VarNext,bitIndex74)
          <=> v105130(VarCurr,bitIndex443) )
          & ( v133374(VarNext,bitIndex73)
          <=> v105130(VarCurr,bitIndex442) )
          & ( v133374(VarNext,bitIndex72)
          <=> v105130(VarCurr,bitIndex441) )
          & ( v133374(VarNext,bitIndex71)
          <=> v105130(VarCurr,bitIndex440) )
          & ( v133374(VarNext,bitIndex70)
          <=> v105130(VarCurr,bitIndex439) )
          & ( v133374(VarNext,bitIndex69)
          <=> v105130(VarCurr,bitIndex438) )
          & ( v133374(VarNext,bitIndex68)
          <=> v105130(VarCurr,bitIndex437) )
          & ( v133374(VarNext,bitIndex67)
          <=> v105130(VarCurr,bitIndex436) )
          & ( v133374(VarNext,bitIndex66)
          <=> v105130(VarCurr,bitIndex435) )
          & ( v133374(VarNext,bitIndex65)
          <=> v105130(VarCurr,bitIndex434) )
          & ( v133374(VarNext,bitIndex64)
          <=> v105130(VarCurr,bitIndex433) )
          & ( v133374(VarNext,bitIndex63)
          <=> v105130(VarCurr,bitIndex432) )
          & ( v133374(VarNext,bitIndex62)
          <=> v105130(VarCurr,bitIndex431) )
          & ( v133374(VarNext,bitIndex61)
          <=> v105130(VarCurr,bitIndex430) )
          & ( v133374(VarNext,bitIndex60)
          <=> v105130(VarCurr,bitIndex429) )
          & ( v133374(VarNext,bitIndex59)
          <=> v105130(VarCurr,bitIndex428) )
          & ( v133374(VarNext,bitIndex58)
          <=> v105130(VarCurr,bitIndex427) )
          & ( v133374(VarNext,bitIndex57)
          <=> v105130(VarCurr,bitIndex426) )
          & ( v133374(VarNext,bitIndex56)
          <=> v105130(VarCurr,bitIndex425) )
          & ( v133374(VarNext,bitIndex55)
          <=> v105130(VarCurr,bitIndex424) )
          & ( v133374(VarNext,bitIndex54)
          <=> v105130(VarCurr,bitIndex423) )
          & ( v133374(VarNext,bitIndex53)
          <=> v105130(VarCurr,bitIndex422) )
          & ( v133374(VarNext,bitIndex52)
          <=> v105130(VarCurr,bitIndex421) )
          & ( v133374(VarNext,bitIndex51)
          <=> v105130(VarCurr,bitIndex420) )
          & ( v133374(VarNext,bitIndex50)
          <=> v105130(VarCurr,bitIndex419) )
          & ( v133374(VarNext,bitIndex49)
          <=> v105130(VarCurr,bitIndex418) )
          & ( v133374(VarNext,bitIndex48)
          <=> v105130(VarCurr,bitIndex417) )
          & ( v133374(VarNext,bitIndex47)
          <=> v105130(VarCurr,bitIndex416) )
          & ( v133374(VarNext,bitIndex46)
          <=> v105130(VarCurr,bitIndex415) )
          & ( v133374(VarNext,bitIndex45)
          <=> v105130(VarCurr,bitIndex414) )
          & ( v133374(VarNext,bitIndex44)
          <=> v105130(VarCurr,bitIndex413) )
          & ( v133374(VarNext,bitIndex43)
          <=> v105130(VarCurr,bitIndex412) )
          & ( v133374(VarNext,bitIndex42)
          <=> v105130(VarCurr,bitIndex411) )
          & ( v133374(VarNext,bitIndex41)
          <=> v105130(VarCurr,bitIndex410) )
          & ( v133374(VarNext,bitIndex40)
          <=> v105130(VarCurr,bitIndex409) )
          & ( v133374(VarNext,bitIndex39)
          <=> v105130(VarCurr,bitIndex408) )
          & ( v133374(VarNext,bitIndex38)
          <=> v105130(VarCurr,bitIndex407) )
          & ( v133374(VarNext,bitIndex37)
          <=> v105130(VarCurr,bitIndex406) )
          & ( v133374(VarNext,bitIndex36)
          <=> v105130(VarCurr,bitIndex405) )
          & ( v133374(VarNext,bitIndex35)
          <=> v105130(VarCurr,bitIndex404) )
          & ( v133374(VarNext,bitIndex34)
          <=> v105130(VarCurr,bitIndex403) )
          & ( v133374(VarNext,bitIndex33)
          <=> v105130(VarCurr,bitIndex402) )
          & ( v133374(VarNext,bitIndex32)
          <=> v105130(VarCurr,bitIndex401) )
          & ( v133374(VarNext,bitIndex31)
          <=> v105130(VarCurr,bitIndex400) )
          & ( v133374(VarNext,bitIndex30)
          <=> v105130(VarCurr,bitIndex399) )
          & ( v133374(VarNext,bitIndex29)
          <=> v105130(VarCurr,bitIndex398) )
          & ( v133374(VarNext,bitIndex28)
          <=> v105130(VarCurr,bitIndex397) )
          & ( v133374(VarNext,bitIndex27)
          <=> v105130(VarCurr,bitIndex396) )
          & ( v133374(VarNext,bitIndex26)
          <=> v105130(VarCurr,bitIndex395) )
          & ( v133374(VarNext,bitIndex25)
          <=> v105130(VarCurr,bitIndex394) )
          & ( v133374(VarNext,bitIndex24)
          <=> v105130(VarCurr,bitIndex393) )
          & ( v133374(VarNext,bitIndex23)
          <=> v105130(VarCurr,bitIndex392) )
          & ( v133374(VarNext,bitIndex22)
          <=> v105130(VarCurr,bitIndex391) )
          & ( v133374(VarNext,bitIndex21)
          <=> v105130(VarCurr,bitIndex390) )
          & ( v133374(VarNext,bitIndex20)
          <=> v105130(VarCurr,bitIndex389) )
          & ( v133374(VarNext,bitIndex19)
          <=> v105130(VarCurr,bitIndex388) )
          & ( v133374(VarNext,bitIndex18)
          <=> v105130(VarCurr,bitIndex387) )
          & ( v133374(VarNext,bitIndex17)
          <=> v105130(VarCurr,bitIndex386) )
          & ( v133374(VarNext,bitIndex16)
          <=> v105130(VarCurr,bitIndex385) )
          & ( v133374(VarNext,bitIndex15)
          <=> v105130(VarCurr,bitIndex384) )
          & ( v133374(VarNext,bitIndex14)
          <=> v105130(VarCurr,bitIndex383) )
          & ( v133374(VarNext,bitIndex13)
          <=> v105130(VarCurr,bitIndex382) )
          & ( v133374(VarNext,bitIndex12)
          <=> v105130(VarCurr,bitIndex381) )
          & ( v133374(VarNext,bitIndex11)
          <=> v105130(VarCurr,bitIndex380) )
          & ( v133374(VarNext,bitIndex10)
          <=> v105130(VarCurr,bitIndex379) )
          & ( v133374(VarNext,bitIndex9)
          <=> v105130(VarCurr,bitIndex378) )
          & ( v133374(VarNext,bitIndex8)
          <=> v105130(VarCurr,bitIndex377) )
          & ( v133374(VarNext,bitIndex7)
          <=> v105130(VarCurr,bitIndex376) )
          & ( v133374(VarNext,bitIndex6)
          <=> v105130(VarCurr,bitIndex375) )
          & ( v133374(VarNext,bitIndex5)
          <=> v105130(VarCurr,bitIndex374) )
          & ( v133374(VarNext,bitIndex4)
          <=> v105130(VarCurr,bitIndex373) )
          & ( v133374(VarNext,bitIndex3)
          <=> v105130(VarCurr,bitIndex372) )
          & ( v133374(VarNext,bitIndex2)
          <=> v105130(VarCurr,bitIndex371) )
          & ( v133374(VarNext,bitIndex1)
          <=> v105130(VarCurr,bitIndex370) )
          & ( v133374(VarNext,bitIndex0)
          <=> v105130(VarCurr,bitIndex369) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2473,axiom,
    ! [VarNext] :
      ( v133376(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133374(VarNext,B)
          <=> v105454(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26717,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133376(VarNext)
      <=> ( v133377(VarNext)
          & v105436(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26716,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133377(VarNext)
      <=> ( v133379(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11064,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133379(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43557,axiom,
    ! [VarCurr] :
      ( v105420(VarCurr,bitIndex81)
    <=> v105425(VarCurr,bitIndex81) ) ).

fof(addAssignment_43556,axiom,
    ! [VarCurr] :
      ( v105424(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex327) ) ).

fof(addAssignment_43555,axiom,
    ! [VarCurr] :
      ( v105413(VarCurr,bitIndex81)
    <=> v105418(VarCurr,bitIndex81) ) ).

fof(addAssignment_43554,axiom,
    ! [VarCurr] :
      ( v105417(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex450) ) ).

fof(addAssignment_43553,axiom,
    ! [VarNext] :
      ( v105130(VarNext,bitIndex327)
    <=> v133366(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133368(VarNext)
       => ( ( v133366(VarNext,bitIndex122)
          <=> v105130(VarCurr,bitIndex368) )
          & ( v133366(VarNext,bitIndex121)
          <=> v105130(VarCurr,bitIndex367) )
          & ( v133366(VarNext,bitIndex120)
          <=> v105130(VarCurr,bitIndex366) )
          & ( v133366(VarNext,bitIndex119)
          <=> v105130(VarCurr,bitIndex365) )
          & ( v133366(VarNext,bitIndex118)
          <=> v105130(VarCurr,bitIndex364) )
          & ( v133366(VarNext,bitIndex117)
          <=> v105130(VarCurr,bitIndex363) )
          & ( v133366(VarNext,bitIndex116)
          <=> v105130(VarCurr,bitIndex362) )
          & ( v133366(VarNext,bitIndex115)
          <=> v105130(VarCurr,bitIndex361) )
          & ( v133366(VarNext,bitIndex114)
          <=> v105130(VarCurr,bitIndex360) )
          & ( v133366(VarNext,bitIndex113)
          <=> v105130(VarCurr,bitIndex359) )
          & ( v133366(VarNext,bitIndex112)
          <=> v105130(VarCurr,bitIndex358) )
          & ( v133366(VarNext,bitIndex111)
          <=> v105130(VarCurr,bitIndex357) )
          & ( v133366(VarNext,bitIndex110)
          <=> v105130(VarCurr,bitIndex356) )
          & ( v133366(VarNext,bitIndex109)
          <=> v105130(VarCurr,bitIndex355) )
          & ( v133366(VarNext,bitIndex108)
          <=> v105130(VarCurr,bitIndex354) )
          & ( v133366(VarNext,bitIndex107)
          <=> v105130(VarCurr,bitIndex353) )
          & ( v133366(VarNext,bitIndex106)
          <=> v105130(VarCurr,bitIndex352) )
          & ( v133366(VarNext,bitIndex105)
          <=> v105130(VarCurr,bitIndex351) )
          & ( v133366(VarNext,bitIndex104)
          <=> v105130(VarCurr,bitIndex350) )
          & ( v133366(VarNext,bitIndex103)
          <=> v105130(VarCurr,bitIndex349) )
          & ( v133366(VarNext,bitIndex102)
          <=> v105130(VarCurr,bitIndex348) )
          & ( v133366(VarNext,bitIndex101)
          <=> v105130(VarCurr,bitIndex347) )
          & ( v133366(VarNext,bitIndex100)
          <=> v105130(VarCurr,bitIndex346) )
          & ( v133366(VarNext,bitIndex99)
          <=> v105130(VarCurr,bitIndex345) )
          & ( v133366(VarNext,bitIndex98)
          <=> v105130(VarCurr,bitIndex344) )
          & ( v133366(VarNext,bitIndex97)
          <=> v105130(VarCurr,bitIndex343) )
          & ( v133366(VarNext,bitIndex96)
          <=> v105130(VarCurr,bitIndex342) )
          & ( v133366(VarNext,bitIndex95)
          <=> v105130(VarCurr,bitIndex341) )
          & ( v133366(VarNext,bitIndex94)
          <=> v105130(VarCurr,bitIndex340) )
          & ( v133366(VarNext,bitIndex93)
          <=> v105130(VarCurr,bitIndex339) )
          & ( v133366(VarNext,bitIndex92)
          <=> v105130(VarCurr,bitIndex338) )
          & ( v133366(VarNext,bitIndex91)
          <=> v105130(VarCurr,bitIndex337) )
          & ( v133366(VarNext,bitIndex90)
          <=> v105130(VarCurr,bitIndex336) )
          & ( v133366(VarNext,bitIndex89)
          <=> v105130(VarCurr,bitIndex335) )
          & ( v133366(VarNext,bitIndex88)
          <=> v105130(VarCurr,bitIndex334) )
          & ( v133366(VarNext,bitIndex87)
          <=> v105130(VarCurr,bitIndex333) )
          & ( v133366(VarNext,bitIndex86)
          <=> v105130(VarCurr,bitIndex332) )
          & ( v133366(VarNext,bitIndex85)
          <=> v105130(VarCurr,bitIndex331) )
          & ( v133366(VarNext,bitIndex84)
          <=> v105130(VarCurr,bitIndex330) )
          & ( v133366(VarNext,bitIndex83)
          <=> v105130(VarCurr,bitIndex329) )
          & ( v133366(VarNext,bitIndex82)
          <=> v105130(VarCurr,bitIndex328) )
          & ( v133366(VarNext,bitIndex81)
          <=> v105130(VarCurr,bitIndex327) )
          & ( v133366(VarNext,bitIndex80)
          <=> v105130(VarCurr,bitIndex326) )
          & ( v133366(VarNext,bitIndex79)
          <=> v105130(VarCurr,bitIndex325) )
          & ( v133366(VarNext,bitIndex78)
          <=> v105130(VarCurr,bitIndex324) )
          & ( v133366(VarNext,bitIndex77)
          <=> v105130(VarCurr,bitIndex323) )
          & ( v133366(VarNext,bitIndex76)
          <=> v105130(VarCurr,bitIndex322) )
          & ( v133366(VarNext,bitIndex75)
          <=> v105130(VarCurr,bitIndex321) )
          & ( v133366(VarNext,bitIndex74)
          <=> v105130(VarCurr,bitIndex320) )
          & ( v133366(VarNext,bitIndex73)
          <=> v105130(VarCurr,bitIndex319) )
          & ( v133366(VarNext,bitIndex72)
          <=> v105130(VarCurr,bitIndex318) )
          & ( v133366(VarNext,bitIndex71)
          <=> v105130(VarCurr,bitIndex317) )
          & ( v133366(VarNext,bitIndex70)
          <=> v105130(VarCurr,bitIndex316) )
          & ( v133366(VarNext,bitIndex69)
          <=> v105130(VarCurr,bitIndex315) )
          & ( v133366(VarNext,bitIndex68)
          <=> v105130(VarCurr,bitIndex314) )
          & ( v133366(VarNext,bitIndex67)
          <=> v105130(VarCurr,bitIndex313) )
          & ( v133366(VarNext,bitIndex66)
          <=> v105130(VarCurr,bitIndex312) )
          & ( v133366(VarNext,bitIndex65)
          <=> v105130(VarCurr,bitIndex311) )
          & ( v133366(VarNext,bitIndex64)
          <=> v105130(VarCurr,bitIndex310) )
          & ( v133366(VarNext,bitIndex63)
          <=> v105130(VarCurr,bitIndex309) )
          & ( v133366(VarNext,bitIndex62)
          <=> v105130(VarCurr,bitIndex308) )
          & ( v133366(VarNext,bitIndex61)
          <=> v105130(VarCurr,bitIndex307) )
          & ( v133366(VarNext,bitIndex60)
          <=> v105130(VarCurr,bitIndex306) )
          & ( v133366(VarNext,bitIndex59)
          <=> v105130(VarCurr,bitIndex305) )
          & ( v133366(VarNext,bitIndex58)
          <=> v105130(VarCurr,bitIndex304) )
          & ( v133366(VarNext,bitIndex57)
          <=> v105130(VarCurr,bitIndex303) )
          & ( v133366(VarNext,bitIndex56)
          <=> v105130(VarCurr,bitIndex302) )
          & ( v133366(VarNext,bitIndex55)
          <=> v105130(VarCurr,bitIndex301) )
          & ( v133366(VarNext,bitIndex54)
          <=> v105130(VarCurr,bitIndex300) )
          & ( v133366(VarNext,bitIndex53)
          <=> v105130(VarCurr,bitIndex299) )
          & ( v133366(VarNext,bitIndex52)
          <=> v105130(VarCurr,bitIndex298) )
          & ( v133366(VarNext,bitIndex51)
          <=> v105130(VarCurr,bitIndex297) )
          & ( v133366(VarNext,bitIndex50)
          <=> v105130(VarCurr,bitIndex296) )
          & ( v133366(VarNext,bitIndex49)
          <=> v105130(VarCurr,bitIndex295) )
          & ( v133366(VarNext,bitIndex48)
          <=> v105130(VarCurr,bitIndex294) )
          & ( v133366(VarNext,bitIndex47)
          <=> v105130(VarCurr,bitIndex293) )
          & ( v133366(VarNext,bitIndex46)
          <=> v105130(VarCurr,bitIndex292) )
          & ( v133366(VarNext,bitIndex45)
          <=> v105130(VarCurr,bitIndex291) )
          & ( v133366(VarNext,bitIndex44)
          <=> v105130(VarCurr,bitIndex290) )
          & ( v133366(VarNext,bitIndex43)
          <=> v105130(VarCurr,bitIndex289) )
          & ( v133366(VarNext,bitIndex42)
          <=> v105130(VarCurr,bitIndex288) )
          & ( v133366(VarNext,bitIndex41)
          <=> v105130(VarCurr,bitIndex287) )
          & ( v133366(VarNext,bitIndex40)
          <=> v105130(VarCurr,bitIndex286) )
          & ( v133366(VarNext,bitIndex39)
          <=> v105130(VarCurr,bitIndex285) )
          & ( v133366(VarNext,bitIndex38)
          <=> v105130(VarCurr,bitIndex284) )
          & ( v133366(VarNext,bitIndex37)
          <=> v105130(VarCurr,bitIndex283) )
          & ( v133366(VarNext,bitIndex36)
          <=> v105130(VarCurr,bitIndex282) )
          & ( v133366(VarNext,bitIndex35)
          <=> v105130(VarCurr,bitIndex281) )
          & ( v133366(VarNext,bitIndex34)
          <=> v105130(VarCurr,bitIndex280) )
          & ( v133366(VarNext,bitIndex33)
          <=> v105130(VarCurr,bitIndex279) )
          & ( v133366(VarNext,bitIndex32)
          <=> v105130(VarCurr,bitIndex278) )
          & ( v133366(VarNext,bitIndex31)
          <=> v105130(VarCurr,bitIndex277) )
          & ( v133366(VarNext,bitIndex30)
          <=> v105130(VarCurr,bitIndex276) )
          & ( v133366(VarNext,bitIndex29)
          <=> v105130(VarCurr,bitIndex275) )
          & ( v133366(VarNext,bitIndex28)
          <=> v105130(VarCurr,bitIndex274) )
          & ( v133366(VarNext,bitIndex27)
          <=> v105130(VarCurr,bitIndex273) )
          & ( v133366(VarNext,bitIndex26)
          <=> v105130(VarCurr,bitIndex272) )
          & ( v133366(VarNext,bitIndex25)
          <=> v105130(VarCurr,bitIndex271) )
          & ( v133366(VarNext,bitIndex24)
          <=> v105130(VarCurr,bitIndex270) )
          & ( v133366(VarNext,bitIndex23)
          <=> v105130(VarCurr,bitIndex269) )
          & ( v133366(VarNext,bitIndex22)
          <=> v105130(VarCurr,bitIndex268) )
          & ( v133366(VarNext,bitIndex21)
          <=> v105130(VarCurr,bitIndex267) )
          & ( v133366(VarNext,bitIndex20)
          <=> v105130(VarCurr,bitIndex266) )
          & ( v133366(VarNext,bitIndex19)
          <=> v105130(VarCurr,bitIndex265) )
          & ( v133366(VarNext,bitIndex18)
          <=> v105130(VarCurr,bitIndex264) )
          & ( v133366(VarNext,bitIndex17)
          <=> v105130(VarCurr,bitIndex263) )
          & ( v133366(VarNext,bitIndex16)
          <=> v105130(VarCurr,bitIndex262) )
          & ( v133366(VarNext,bitIndex15)
          <=> v105130(VarCurr,bitIndex261) )
          & ( v133366(VarNext,bitIndex14)
          <=> v105130(VarCurr,bitIndex260) )
          & ( v133366(VarNext,bitIndex13)
          <=> v105130(VarCurr,bitIndex259) )
          & ( v133366(VarNext,bitIndex12)
          <=> v105130(VarCurr,bitIndex258) )
          & ( v133366(VarNext,bitIndex11)
          <=> v105130(VarCurr,bitIndex257) )
          & ( v133366(VarNext,bitIndex10)
          <=> v105130(VarCurr,bitIndex256) )
          & ( v133366(VarNext,bitIndex9)
          <=> v105130(VarCurr,bitIndex255) )
          & ( v133366(VarNext,bitIndex8)
          <=> v105130(VarCurr,bitIndex254) )
          & ( v133366(VarNext,bitIndex7)
          <=> v105130(VarCurr,bitIndex253) )
          & ( v133366(VarNext,bitIndex6)
          <=> v105130(VarCurr,bitIndex252) )
          & ( v133366(VarNext,bitIndex5)
          <=> v105130(VarCurr,bitIndex251) )
          & ( v133366(VarNext,bitIndex4)
          <=> v105130(VarCurr,bitIndex250) )
          & ( v133366(VarNext,bitIndex3)
          <=> v105130(VarCurr,bitIndex249) )
          & ( v133366(VarNext,bitIndex2)
          <=> v105130(VarCurr,bitIndex248) )
          & ( v133366(VarNext,bitIndex1)
          <=> v105130(VarCurr,bitIndex247) )
          & ( v133366(VarNext,bitIndex0)
          <=> v105130(VarCurr,bitIndex246) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2472,axiom,
    ! [VarNext] :
      ( v133368(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133366(VarNext,B)
          <=> v105408(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26715,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133368(VarNext)
      <=> ( v133369(VarNext)
          & v105390(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26714,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133369(VarNext)
      <=> ( v133371(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11063,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133371(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43552,axiom,
    ! [VarCurr] :
      ( v105374(VarCurr,bitIndex81)
    <=> v105379(VarCurr,bitIndex81) ) ).

fof(addAssignment_43551,axiom,
    ! [VarCurr] :
      ( v105378(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex204) ) ).

fof(addAssignment_43550,axiom,
    ! [VarCurr] :
      ( v105367(VarCurr,bitIndex81)
    <=> v105372(VarCurr,bitIndex81) ) ).

fof(addAssignment_43549,axiom,
    ! [VarCurr] :
      ( v105371(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex327) ) ).

fof(addAssignment_43548,axiom,
    ! [VarNext] :
      ( v105130(VarNext,bitIndex204)
    <=> v133358(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133360(VarNext)
       => ( ( v133358(VarNext,bitIndex122)
          <=> v105130(VarCurr,bitIndex245) )
          & ( v133358(VarNext,bitIndex121)
          <=> v105130(VarCurr,bitIndex244) )
          & ( v133358(VarNext,bitIndex120)
          <=> v105130(VarCurr,bitIndex243) )
          & ( v133358(VarNext,bitIndex119)
          <=> v105130(VarCurr,bitIndex242) )
          & ( v133358(VarNext,bitIndex118)
          <=> v105130(VarCurr,bitIndex241) )
          & ( v133358(VarNext,bitIndex117)
          <=> v105130(VarCurr,bitIndex240) )
          & ( v133358(VarNext,bitIndex116)
          <=> v105130(VarCurr,bitIndex239) )
          & ( v133358(VarNext,bitIndex115)
          <=> v105130(VarCurr,bitIndex238) )
          & ( v133358(VarNext,bitIndex114)
          <=> v105130(VarCurr,bitIndex237) )
          & ( v133358(VarNext,bitIndex113)
          <=> v105130(VarCurr,bitIndex236) )
          & ( v133358(VarNext,bitIndex112)
          <=> v105130(VarCurr,bitIndex235) )
          & ( v133358(VarNext,bitIndex111)
          <=> v105130(VarCurr,bitIndex234) )
          & ( v133358(VarNext,bitIndex110)
          <=> v105130(VarCurr,bitIndex233) )
          & ( v133358(VarNext,bitIndex109)
          <=> v105130(VarCurr,bitIndex232) )
          & ( v133358(VarNext,bitIndex108)
          <=> v105130(VarCurr,bitIndex231) )
          & ( v133358(VarNext,bitIndex107)
          <=> v105130(VarCurr,bitIndex230) )
          & ( v133358(VarNext,bitIndex106)
          <=> v105130(VarCurr,bitIndex229) )
          & ( v133358(VarNext,bitIndex105)
          <=> v105130(VarCurr,bitIndex228) )
          & ( v133358(VarNext,bitIndex104)
          <=> v105130(VarCurr,bitIndex227) )
          & ( v133358(VarNext,bitIndex103)
          <=> v105130(VarCurr,bitIndex226) )
          & ( v133358(VarNext,bitIndex102)
          <=> v105130(VarCurr,bitIndex225) )
          & ( v133358(VarNext,bitIndex101)
          <=> v105130(VarCurr,bitIndex224) )
          & ( v133358(VarNext,bitIndex100)
          <=> v105130(VarCurr,bitIndex223) )
          & ( v133358(VarNext,bitIndex99)
          <=> v105130(VarCurr,bitIndex222) )
          & ( v133358(VarNext,bitIndex98)
          <=> v105130(VarCurr,bitIndex221) )
          & ( v133358(VarNext,bitIndex97)
          <=> v105130(VarCurr,bitIndex220) )
          & ( v133358(VarNext,bitIndex96)
          <=> v105130(VarCurr,bitIndex219) )
          & ( v133358(VarNext,bitIndex95)
          <=> v105130(VarCurr,bitIndex218) )
          & ( v133358(VarNext,bitIndex94)
          <=> v105130(VarCurr,bitIndex217) )
          & ( v133358(VarNext,bitIndex93)
          <=> v105130(VarCurr,bitIndex216) )
          & ( v133358(VarNext,bitIndex92)
          <=> v105130(VarCurr,bitIndex215) )
          & ( v133358(VarNext,bitIndex91)
          <=> v105130(VarCurr,bitIndex214) )
          & ( v133358(VarNext,bitIndex90)
          <=> v105130(VarCurr,bitIndex213) )
          & ( v133358(VarNext,bitIndex89)
          <=> v105130(VarCurr,bitIndex212) )
          & ( v133358(VarNext,bitIndex88)
          <=> v105130(VarCurr,bitIndex211) )
          & ( v133358(VarNext,bitIndex87)
          <=> v105130(VarCurr,bitIndex210) )
          & ( v133358(VarNext,bitIndex86)
          <=> v105130(VarCurr,bitIndex209) )
          & ( v133358(VarNext,bitIndex85)
          <=> v105130(VarCurr,bitIndex208) )
          & ( v133358(VarNext,bitIndex84)
          <=> v105130(VarCurr,bitIndex207) )
          & ( v133358(VarNext,bitIndex83)
          <=> v105130(VarCurr,bitIndex206) )
          & ( v133358(VarNext,bitIndex82)
          <=> v105130(VarCurr,bitIndex205) )
          & ( v133358(VarNext,bitIndex81)
          <=> v105130(VarCurr,bitIndex204) )
          & ( v133358(VarNext,bitIndex80)
          <=> v105130(VarCurr,bitIndex203) )
          & ( v133358(VarNext,bitIndex79)
          <=> v105130(VarCurr,bitIndex202) )
          & ( v133358(VarNext,bitIndex78)
          <=> v105130(VarCurr,bitIndex201) )
          & ( v133358(VarNext,bitIndex77)
          <=> v105130(VarCurr,bitIndex200) )
          & ( v133358(VarNext,bitIndex76)
          <=> v105130(VarCurr,bitIndex199) )
          & ( v133358(VarNext,bitIndex75)
          <=> v105130(VarCurr,bitIndex198) )
          & ( v133358(VarNext,bitIndex74)
          <=> v105130(VarCurr,bitIndex197) )
          & ( v133358(VarNext,bitIndex73)
          <=> v105130(VarCurr,bitIndex196) )
          & ( v133358(VarNext,bitIndex72)
          <=> v105130(VarCurr,bitIndex195) )
          & ( v133358(VarNext,bitIndex71)
          <=> v105130(VarCurr,bitIndex194) )
          & ( v133358(VarNext,bitIndex70)
          <=> v105130(VarCurr,bitIndex193) )
          & ( v133358(VarNext,bitIndex69)
          <=> v105130(VarCurr,bitIndex192) )
          & ( v133358(VarNext,bitIndex68)
          <=> v105130(VarCurr,bitIndex191) )
          & ( v133358(VarNext,bitIndex67)
          <=> v105130(VarCurr,bitIndex190) )
          & ( v133358(VarNext,bitIndex66)
          <=> v105130(VarCurr,bitIndex189) )
          & ( v133358(VarNext,bitIndex65)
          <=> v105130(VarCurr,bitIndex188) )
          & ( v133358(VarNext,bitIndex64)
          <=> v105130(VarCurr,bitIndex187) )
          & ( v133358(VarNext,bitIndex63)
          <=> v105130(VarCurr,bitIndex186) )
          & ( v133358(VarNext,bitIndex62)
          <=> v105130(VarCurr,bitIndex185) )
          & ( v133358(VarNext,bitIndex61)
          <=> v105130(VarCurr,bitIndex184) )
          & ( v133358(VarNext,bitIndex60)
          <=> v105130(VarCurr,bitIndex183) )
          & ( v133358(VarNext,bitIndex59)
          <=> v105130(VarCurr,bitIndex182) )
          & ( v133358(VarNext,bitIndex58)
          <=> v105130(VarCurr,bitIndex181) )
          & ( v133358(VarNext,bitIndex57)
          <=> v105130(VarCurr,bitIndex180) )
          & ( v133358(VarNext,bitIndex56)
          <=> v105130(VarCurr,bitIndex179) )
          & ( v133358(VarNext,bitIndex55)
          <=> v105130(VarCurr,bitIndex178) )
          & ( v133358(VarNext,bitIndex54)
          <=> v105130(VarCurr,bitIndex177) )
          & ( v133358(VarNext,bitIndex53)
          <=> v105130(VarCurr,bitIndex176) )
          & ( v133358(VarNext,bitIndex52)
          <=> v105130(VarCurr,bitIndex175) )
          & ( v133358(VarNext,bitIndex51)
          <=> v105130(VarCurr,bitIndex174) )
          & ( v133358(VarNext,bitIndex50)
          <=> v105130(VarCurr,bitIndex173) )
          & ( v133358(VarNext,bitIndex49)
          <=> v105130(VarCurr,bitIndex172) )
          & ( v133358(VarNext,bitIndex48)
          <=> v105130(VarCurr,bitIndex171) )
          & ( v133358(VarNext,bitIndex47)
          <=> v105130(VarCurr,bitIndex170) )
          & ( v133358(VarNext,bitIndex46)
          <=> v105130(VarCurr,bitIndex169) )
          & ( v133358(VarNext,bitIndex45)
          <=> v105130(VarCurr,bitIndex168) )
          & ( v133358(VarNext,bitIndex44)
          <=> v105130(VarCurr,bitIndex167) )
          & ( v133358(VarNext,bitIndex43)
          <=> v105130(VarCurr,bitIndex166) )
          & ( v133358(VarNext,bitIndex42)
          <=> v105130(VarCurr,bitIndex165) )
          & ( v133358(VarNext,bitIndex41)
          <=> v105130(VarCurr,bitIndex164) )
          & ( v133358(VarNext,bitIndex40)
          <=> v105130(VarCurr,bitIndex163) )
          & ( v133358(VarNext,bitIndex39)
          <=> v105130(VarCurr,bitIndex162) )
          & ( v133358(VarNext,bitIndex38)
          <=> v105130(VarCurr,bitIndex161) )
          & ( v133358(VarNext,bitIndex37)
          <=> v105130(VarCurr,bitIndex160) )
          & ( v133358(VarNext,bitIndex36)
          <=> v105130(VarCurr,bitIndex159) )
          & ( v133358(VarNext,bitIndex35)
          <=> v105130(VarCurr,bitIndex158) )
          & ( v133358(VarNext,bitIndex34)
          <=> v105130(VarCurr,bitIndex157) )
          & ( v133358(VarNext,bitIndex33)
          <=> v105130(VarCurr,bitIndex156) )
          & ( v133358(VarNext,bitIndex32)
          <=> v105130(VarCurr,bitIndex155) )
          & ( v133358(VarNext,bitIndex31)
          <=> v105130(VarCurr,bitIndex154) )
          & ( v133358(VarNext,bitIndex30)
          <=> v105130(VarCurr,bitIndex153) )
          & ( v133358(VarNext,bitIndex29)
          <=> v105130(VarCurr,bitIndex152) )
          & ( v133358(VarNext,bitIndex28)
          <=> v105130(VarCurr,bitIndex151) )
          & ( v133358(VarNext,bitIndex27)
          <=> v105130(VarCurr,bitIndex150) )
          & ( v133358(VarNext,bitIndex26)
          <=> v105130(VarCurr,bitIndex149) )
          & ( v133358(VarNext,bitIndex25)
          <=> v105130(VarCurr,bitIndex148) )
          & ( v133358(VarNext,bitIndex24)
          <=> v105130(VarCurr,bitIndex147) )
          & ( v133358(VarNext,bitIndex23)
          <=> v105130(VarCurr,bitIndex146) )
          & ( v133358(VarNext,bitIndex22)
          <=> v105130(VarCurr,bitIndex145) )
          & ( v133358(VarNext,bitIndex21)
          <=> v105130(VarCurr,bitIndex144) )
          & ( v133358(VarNext,bitIndex20)
          <=> v105130(VarCurr,bitIndex143) )
          & ( v133358(VarNext,bitIndex19)
          <=> v105130(VarCurr,bitIndex142) )
          & ( v133358(VarNext,bitIndex18)
          <=> v105130(VarCurr,bitIndex141) )
          & ( v133358(VarNext,bitIndex17)
          <=> v105130(VarCurr,bitIndex140) )
          & ( v133358(VarNext,bitIndex16)
          <=> v105130(VarCurr,bitIndex139) )
          & ( v133358(VarNext,bitIndex15)
          <=> v105130(VarCurr,bitIndex138) )
          & ( v133358(VarNext,bitIndex14)
          <=> v105130(VarCurr,bitIndex137) )
          & ( v133358(VarNext,bitIndex13)
          <=> v105130(VarCurr,bitIndex136) )
          & ( v133358(VarNext,bitIndex12)
          <=> v105130(VarCurr,bitIndex135) )
          & ( v133358(VarNext,bitIndex11)
          <=> v105130(VarCurr,bitIndex134) )
          & ( v133358(VarNext,bitIndex10)
          <=> v105130(VarCurr,bitIndex133) )
          & ( v133358(VarNext,bitIndex9)
          <=> v105130(VarCurr,bitIndex132) )
          & ( v133358(VarNext,bitIndex8)
          <=> v105130(VarCurr,bitIndex131) )
          & ( v133358(VarNext,bitIndex7)
          <=> v105130(VarCurr,bitIndex130) )
          & ( v133358(VarNext,bitIndex6)
          <=> v105130(VarCurr,bitIndex129) )
          & ( v133358(VarNext,bitIndex5)
          <=> v105130(VarCurr,bitIndex128) )
          & ( v133358(VarNext,bitIndex4)
          <=> v105130(VarCurr,bitIndex127) )
          & ( v133358(VarNext,bitIndex3)
          <=> v105130(VarCurr,bitIndex126) )
          & ( v133358(VarNext,bitIndex2)
          <=> v105130(VarCurr,bitIndex125) )
          & ( v133358(VarNext,bitIndex1)
          <=> v105130(VarCurr,bitIndex124) )
          & ( v133358(VarNext,bitIndex0)
          <=> v105130(VarCurr,bitIndex123) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2471,axiom,
    ! [VarNext] :
      ( v133360(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133358(VarNext,B)
          <=> v105362(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26713,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133360(VarNext)
      <=> ( v133361(VarNext)
          & v105344(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26712,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133361(VarNext)
      <=> ( v133363(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11062,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133363(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43547,axiom,
    ! [VarCurr] :
      ( v105328(VarCurr,bitIndex81)
    <=> v105333(VarCurr,bitIndex81) ) ).

fof(addAssignment_43546,axiom,
    ! [VarCurr] :
      ( v105332(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex81) ) ).

fof(addAssignment_43545,axiom,
    ! [VarCurr] :
      ( v105321(VarCurr,bitIndex81)
    <=> v105326(VarCurr,bitIndex81) ) ).

fof(addAssignment_43544,axiom,
    ! [VarCurr] :
      ( v105325(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex204) ) ).

fof(addAssignment_43543,axiom,
    ! [VarNext] :
      ( v105130(VarNext,bitIndex81)
    <=> v133350(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionEqualRanges1_2338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133352(VarNext)
       => ! [B] :
            ( range_122_0(B)
           => ( v133350(VarNext,B)
            <=> v105130(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2470,axiom,
    ! [VarNext] :
      ( v133352(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133350(VarNext,B)
          <=> v105316(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26711,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133352(VarNext)
      <=> ( v133353(VarNext)
          & v105297(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26710,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133353(VarNext)
      <=> ( v133355(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11061,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133355(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43542,axiom,
    ! [VarCurr] :
      ( v105281(VarCurr,bitIndex81)
    <=> v105286(VarCurr,bitIndex81) ) ).

fof(addAssignment_43541,axiom,
    ! [VarCurr] :
      ( v105285(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex81) ) ).

fof(addAssignment_43540,axiom,
    ! [VarCurr] :
      ( v105184(VarCurr,bitIndex81)
    <=> v105279(VarCurr,bitIndex81) ) ).

fof(addAssignment_43539,axiom,
    ! [VarCurr] :
      ( v105278(VarCurr,bitIndex81)
    <=> v105130(VarCurr,bitIndex81) ) ).

fof(addAssignment_43538,axiom,
    ! [VarCurr] :
      ( v105133(VarCurr,bitIndex81)
    <=> v105135(VarCurr,bitIndex81) ) ).

fof(addAssignment_43537,axiom,
    ! [VarCurr] :
      ( v105135(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex81) ) ).

fof(addAssignment_43536,axiom,
    ! [VarCurr] :
      ( v105137(VarCurr,bitIndex81)
    <=> v105139(VarCurr,bitIndex81) ) ).

fof(addAssignment_43535,axiom,
    ! [VarCurr] :
      ( v105139(VarCurr,bitIndex81)
    <=> v105141(VarCurr,bitIndex81) ) ).

fof(addAssignment_43534,axiom,
    ! [VarCurr] :
      ( v105141(VarCurr,bitIndex81)
    <=> v105143(VarCurr,bitIndex81) ) ).

fof(addAssignment_43533,axiom,
    ! [VarCurr] :
      ( v105143(VarCurr,bitIndex81)
    <=> v105145(VarCurr,bitIndex81) ) ).

fof(addAssignment_43532,axiom,
    ! [VarCurr] :
      ( v105145(VarCurr,bitIndex81)
    <=> v105147(VarCurr,bitIndex81) ) ).

fof(addAssignment_43531,axiom,
    ! [VarNext] :
      ( v105147(VarNext,bitIndex81)
    <=> v133342(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionEqualRanges1_2337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133343(VarNext)
       => ! [B] :
            ( range_122_0(B)
           => ( v133342(VarNext,B)
            <=> v105147(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2469,axiom,
    ! [VarNext] :
      ( v133343(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133342(VarNext,B)
          <=> v105179(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26709,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133343(VarNext)
      <=> v133344(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26708,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133344(VarNext)
      <=> ( v133346(VarNext)
          & v197(VarNext) ) ) ) ).

fof(writeUnaryOperator_11060,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133346(VarNext)
      <=> v105173(VarNext) ) ) ).

fof(addAssignment_43530,axiom,
    ! [VarCurr] :
      ( v105149(VarCurr,bitIndex81)
    <=> v105157(VarCurr,bitIndex81) ) ).

fof(addAssignment_43529,axiom,
    ! [VarCurr] :
      ( v105162(VarCurr,bitIndex4)
    <=> v133339(VarCurr,bitIndex4) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3187,axiom,
    ! [VarCurr] :
      ( ~ v133340(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v133339(VarCurr,B)
          <=> v133306(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_782,axiom,
    ! [VarCurr] :
      ( v133340(VarCurr)
     => ( ( v133339(VarCurr,bitIndex7)
        <=> v254(VarCurr,bitIndex13) )
        & ( v133339(VarCurr,bitIndex6)
        <=> v254(VarCurr,bitIndex12) )
        & ( v133339(VarCurr,bitIndex5)
        <=> v254(VarCurr,bitIndex11) )
        & ( v133339(VarCurr,bitIndex4)
        <=> v254(VarCurr,bitIndex10) )
        & ( v133339(VarCurr,bitIndex3)
        <=> v254(VarCurr,bitIndex9) )
        & ( v133339(VarCurr,bitIndex2)
        <=> v254(VarCurr,bitIndex8) )
        & ( v133339(VarCurr,bitIndex1)
        <=> v254(VarCurr,bitIndex7) )
        & ( v133339(VarCurr,bitIndex0)
        <=> v254(VarCurr,bitIndex6) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26707,axiom,
    ! [VarCurr] :
      ( v133340(VarCurr)
    <=> ( v133244(VarCurr)
        | v15432(VarCurr) ) ) ).

fof(addAssignment_43528,axiom,
    ! [VarCurr] :
      ( v133306(VarCurr,bitIndex4)
    <=> v256(VarCurr,bitIndex74) ) ).

fof(addAssignment_43527,axiom,
    ! [VarCurr] :
      ( v256(VarCurr,bitIndex74)
    <=> v258(VarCurr,bitIndex74) ) ).

fof(addAssignment_43526,axiom,
    ! [VarCurr] :
      ( v258(VarCurr,bitIndex74)
    <=> v260(VarCurr,bitIndex74) ) ).

fof(addAssignment_43525,axiom,
    ! [VarCurr] :
      ( v260(VarCurr,bitIndex74)
    <=> v262(VarCurr,bitIndex654) ) ).

fof(addAssignment_43524,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex654)
    <=> v133332(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133334(VarNext)
       => ( ( v133332(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex695) )
          & ( v133332(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex694) )
          & ( v133332(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex693) )
          & ( v133332(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex692) )
          & ( v133332(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex691) )
          & ( v133332(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex690) )
          & ( v133332(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex689) )
          & ( v133332(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex688) )
          & ( v133332(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex687) )
          & ( v133332(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex686) )
          & ( v133332(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex685) )
          & ( v133332(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex684) )
          & ( v133332(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex683) )
          & ( v133332(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex682) )
          & ( v133332(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex681) )
          & ( v133332(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex680) )
          & ( v133332(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex679) )
          & ( v133332(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex678) )
          & ( v133332(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex677) )
          & ( v133332(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex676) )
          & ( v133332(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex675) )
          & ( v133332(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex674) )
          & ( v133332(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex673) )
          & ( v133332(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex672) )
          & ( v133332(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex671) )
          & ( v133332(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex670) )
          & ( v133332(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex669) )
          & ( v133332(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex668) )
          & ( v133332(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex667) )
          & ( v133332(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex666) )
          & ( v133332(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex665) )
          & ( v133332(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex664) )
          & ( v133332(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex663) )
          & ( v133332(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex662) )
          & ( v133332(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex661) )
          & ( v133332(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex660) )
          & ( v133332(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex659) )
          & ( v133332(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex658) )
          & ( v133332(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex657) )
          & ( v133332(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex656) )
          & ( v133332(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex655) )
          & ( v133332(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex654) )
          & ( v133332(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex653) )
          & ( v133332(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex652) )
          & ( v133332(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex651) )
          & ( v133332(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex650) )
          & ( v133332(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex649) )
          & ( v133332(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex648) )
          & ( v133332(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex647) )
          & ( v133332(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex646) )
          & ( v133332(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex645) )
          & ( v133332(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex644) )
          & ( v133332(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex643) )
          & ( v133332(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex642) )
          & ( v133332(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex641) )
          & ( v133332(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex640) )
          & ( v133332(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex639) )
          & ( v133332(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex638) )
          & ( v133332(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex637) )
          & ( v133332(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex636) )
          & ( v133332(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex635) )
          & ( v133332(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex634) )
          & ( v133332(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex633) )
          & ( v133332(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex632) )
          & ( v133332(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex631) )
          & ( v133332(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex630) )
          & ( v133332(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex629) )
          & ( v133332(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex628) )
          & ( v133332(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex627) )
          & ( v133332(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex626) )
          & ( v133332(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex625) )
          & ( v133332(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex624) )
          & ( v133332(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex623) )
          & ( v133332(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex622) )
          & ( v133332(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex621) )
          & ( v133332(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex620) )
          & ( v133332(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex619) )
          & ( v133332(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex618) )
          & ( v133332(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex617) )
          & ( v133332(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex616) )
          & ( v133332(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex615) )
          & ( v133332(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex614) )
          & ( v133332(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex613) )
          & ( v133332(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex612) )
          & ( v133332(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex611) )
          & ( v133332(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex610) )
          & ( v133332(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex609) )
          & ( v133332(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex608) )
          & ( v133332(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex607) )
          & ( v133332(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex606) )
          & ( v133332(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex605) )
          & ( v133332(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex604) )
          & ( v133332(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex603) )
          & ( v133332(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex602) )
          & ( v133332(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex601) )
          & ( v133332(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex600) )
          & ( v133332(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex599) )
          & ( v133332(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex598) )
          & ( v133332(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex597) )
          & ( v133332(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex596) )
          & ( v133332(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex595) )
          & ( v133332(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex594) )
          & ( v133332(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex593) )
          & ( v133332(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex592) )
          & ( v133332(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex591) )
          & ( v133332(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex590) )
          & ( v133332(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex589) )
          & ( v133332(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex588) )
          & ( v133332(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex587) )
          & ( v133332(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex586) )
          & ( v133332(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex585) )
          & ( v133332(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex584) )
          & ( v133332(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex583) )
          & ( v133332(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex582) )
          & ( v133332(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex581) )
          & ( v133332(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex580) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2468,axiom,
    ! [VarNext] :
      ( v133334(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133332(VarNext,B)
          <=> v380(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26706,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133334(VarNext)
      <=> ( v133335(VarNext)
          & v375(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26705,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133335(VarNext)
      <=> ( v133337(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11059,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133337(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43523,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex538)
    <=> v133324(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133326(VarNext)
       => ( ( v133324(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex579) )
          & ( v133324(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex578) )
          & ( v133324(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex577) )
          & ( v133324(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex576) )
          & ( v133324(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex575) )
          & ( v133324(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex574) )
          & ( v133324(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex573) )
          & ( v133324(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex572) )
          & ( v133324(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex571) )
          & ( v133324(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex570) )
          & ( v133324(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex569) )
          & ( v133324(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex568) )
          & ( v133324(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex567) )
          & ( v133324(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex566) )
          & ( v133324(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex565) )
          & ( v133324(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex564) )
          & ( v133324(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex563) )
          & ( v133324(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex562) )
          & ( v133324(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex561) )
          & ( v133324(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex560) )
          & ( v133324(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex559) )
          & ( v133324(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex558) )
          & ( v133324(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex557) )
          & ( v133324(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex556) )
          & ( v133324(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex555) )
          & ( v133324(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex554) )
          & ( v133324(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex553) )
          & ( v133324(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex552) )
          & ( v133324(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex551) )
          & ( v133324(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex550) )
          & ( v133324(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex549) )
          & ( v133324(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex548) )
          & ( v133324(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex547) )
          & ( v133324(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex546) )
          & ( v133324(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex545) )
          & ( v133324(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex544) )
          & ( v133324(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex543) )
          & ( v133324(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex542) )
          & ( v133324(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex541) )
          & ( v133324(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex540) )
          & ( v133324(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex539) )
          & ( v133324(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex538) )
          & ( v133324(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex537) )
          & ( v133324(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex536) )
          & ( v133324(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex535) )
          & ( v133324(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex534) )
          & ( v133324(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex533) )
          & ( v133324(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex532) )
          & ( v133324(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex531) )
          & ( v133324(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex530) )
          & ( v133324(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex529) )
          & ( v133324(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex528) )
          & ( v133324(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex527) )
          & ( v133324(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex526) )
          & ( v133324(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex525) )
          & ( v133324(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex524) )
          & ( v133324(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex523) )
          & ( v133324(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex522) )
          & ( v133324(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex521) )
          & ( v133324(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex520) )
          & ( v133324(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex519) )
          & ( v133324(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex518) )
          & ( v133324(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex517) )
          & ( v133324(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex516) )
          & ( v133324(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex515) )
          & ( v133324(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex514) )
          & ( v133324(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex513) )
          & ( v133324(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex512) )
          & ( v133324(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex511) )
          & ( v133324(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex510) )
          & ( v133324(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex509) )
          & ( v133324(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex508) )
          & ( v133324(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex507) )
          & ( v133324(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex506) )
          & ( v133324(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex505) )
          & ( v133324(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex504) )
          & ( v133324(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex503) )
          & ( v133324(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex502) )
          & ( v133324(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex501) )
          & ( v133324(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex500) )
          & ( v133324(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex499) )
          & ( v133324(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex498) )
          & ( v133324(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex497) )
          & ( v133324(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex496) )
          & ( v133324(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex495) )
          & ( v133324(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex494) )
          & ( v133324(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex493) )
          & ( v133324(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex492) )
          & ( v133324(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex491) )
          & ( v133324(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex490) )
          & ( v133324(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex489) )
          & ( v133324(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex488) )
          & ( v133324(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex487) )
          & ( v133324(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex486) )
          & ( v133324(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex485) )
          & ( v133324(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex484) )
          & ( v133324(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex483) )
          & ( v133324(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex482) )
          & ( v133324(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex481) )
          & ( v133324(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex480) )
          & ( v133324(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex479) )
          & ( v133324(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex478) )
          & ( v133324(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex477) )
          & ( v133324(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex476) )
          & ( v133324(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex475) )
          & ( v133324(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex474) )
          & ( v133324(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex473) )
          & ( v133324(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex472) )
          & ( v133324(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex471) )
          & ( v133324(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex470) )
          & ( v133324(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex469) )
          & ( v133324(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex468) )
          & ( v133324(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex467) )
          & ( v133324(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex466) )
          & ( v133324(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex465) )
          & ( v133324(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex464) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2467,axiom,
    ! [VarNext] :
      ( v133326(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133324(VarNext,B)
          <=> v361(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26704,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133326(VarNext)
      <=> ( v133327(VarNext)
          & v356(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26703,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133327(VarNext)
      <=> ( v133329(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11058,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133329(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43522,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex422)
    <=> v133316(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133318(VarNext)
       => ( ( v133316(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex463) )
          & ( v133316(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex462) )
          & ( v133316(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex461) )
          & ( v133316(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex460) )
          & ( v133316(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex459) )
          & ( v133316(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex458) )
          & ( v133316(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex457) )
          & ( v133316(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex456) )
          & ( v133316(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex455) )
          & ( v133316(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex454) )
          & ( v133316(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex453) )
          & ( v133316(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex452) )
          & ( v133316(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex451) )
          & ( v133316(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex450) )
          & ( v133316(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex449) )
          & ( v133316(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex448) )
          & ( v133316(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex447) )
          & ( v133316(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex446) )
          & ( v133316(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex445) )
          & ( v133316(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex444) )
          & ( v133316(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex443) )
          & ( v133316(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex442) )
          & ( v133316(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex441) )
          & ( v133316(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex440) )
          & ( v133316(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex439) )
          & ( v133316(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex438) )
          & ( v133316(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex437) )
          & ( v133316(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex436) )
          & ( v133316(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex435) )
          & ( v133316(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex434) )
          & ( v133316(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex433) )
          & ( v133316(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex432) )
          & ( v133316(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex431) )
          & ( v133316(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex430) )
          & ( v133316(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex429) )
          & ( v133316(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex428) )
          & ( v133316(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex427) )
          & ( v133316(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex426) )
          & ( v133316(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex425) )
          & ( v133316(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex424) )
          & ( v133316(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex423) )
          & ( v133316(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex422) )
          & ( v133316(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex421) )
          & ( v133316(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex420) )
          & ( v133316(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex419) )
          & ( v133316(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex418) )
          & ( v133316(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex417) )
          & ( v133316(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex416) )
          & ( v133316(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex415) )
          & ( v133316(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex414) )
          & ( v133316(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex413) )
          & ( v133316(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex412) )
          & ( v133316(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex411) )
          & ( v133316(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex410) )
          & ( v133316(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex409) )
          & ( v133316(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex408) )
          & ( v133316(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex407) )
          & ( v133316(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex406) )
          & ( v133316(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex405) )
          & ( v133316(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex404) )
          & ( v133316(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex403) )
          & ( v133316(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex402) )
          & ( v133316(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex401) )
          & ( v133316(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex400) )
          & ( v133316(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex399) )
          & ( v133316(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex398) )
          & ( v133316(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex397) )
          & ( v133316(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex396) )
          & ( v133316(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex395) )
          & ( v133316(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex394) )
          & ( v133316(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex393) )
          & ( v133316(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex392) )
          & ( v133316(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex391) )
          & ( v133316(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex390) )
          & ( v133316(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex389) )
          & ( v133316(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex388) )
          & ( v133316(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex387) )
          & ( v133316(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex386) )
          & ( v133316(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex385) )
          & ( v133316(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex384) )
          & ( v133316(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex383) )
          & ( v133316(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex382) )
          & ( v133316(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex381) )
          & ( v133316(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex380) )
          & ( v133316(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex379) )
          & ( v133316(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex378) )
          & ( v133316(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex377) )
          & ( v133316(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex376) )
          & ( v133316(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex375) )
          & ( v133316(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex374) )
          & ( v133316(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex373) )
          & ( v133316(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex372) )
          & ( v133316(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex371) )
          & ( v133316(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex370) )
          & ( v133316(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex369) )
          & ( v133316(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex368) )
          & ( v133316(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex367) )
          & ( v133316(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex366) )
          & ( v133316(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex365) )
          & ( v133316(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex364) )
          & ( v133316(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex363) )
          & ( v133316(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex362) )
          & ( v133316(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex361) )
          & ( v133316(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex360) )
          & ( v133316(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex359) )
          & ( v133316(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex358) )
          & ( v133316(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex357) )
          & ( v133316(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex356) )
          & ( v133316(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex355) )
          & ( v133316(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex354) )
          & ( v133316(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex353) )
          & ( v133316(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex352) )
          & ( v133316(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex351) )
          & ( v133316(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex350) )
          & ( v133316(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex349) )
          & ( v133316(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex348) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2466,axiom,
    ! [VarNext] :
      ( v133318(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133316(VarNext,B)
          <=> v342(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26702,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133318(VarNext)
      <=> ( v133319(VarNext)
          & v337(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26701,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133319(VarNext)
      <=> ( v133321(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11057,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133321(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43521,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex306)
    <=> v133308(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133310(VarNext)
       => ( ( v133308(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex347) )
          & ( v133308(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex346) )
          & ( v133308(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex345) )
          & ( v133308(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex344) )
          & ( v133308(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex343) )
          & ( v133308(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex342) )
          & ( v133308(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex341) )
          & ( v133308(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex340) )
          & ( v133308(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex339) )
          & ( v133308(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex338) )
          & ( v133308(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex337) )
          & ( v133308(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex336) )
          & ( v133308(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex335) )
          & ( v133308(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex334) )
          & ( v133308(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex333) )
          & ( v133308(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex332) )
          & ( v133308(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex331) )
          & ( v133308(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex330) )
          & ( v133308(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex329) )
          & ( v133308(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex328) )
          & ( v133308(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex327) )
          & ( v133308(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex326) )
          & ( v133308(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex325) )
          & ( v133308(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex324) )
          & ( v133308(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex323) )
          & ( v133308(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex322) )
          & ( v133308(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex321) )
          & ( v133308(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex320) )
          & ( v133308(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex319) )
          & ( v133308(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex318) )
          & ( v133308(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex317) )
          & ( v133308(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex316) )
          & ( v133308(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex315) )
          & ( v133308(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex314) )
          & ( v133308(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex313) )
          & ( v133308(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex312) )
          & ( v133308(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex311) )
          & ( v133308(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex310) )
          & ( v133308(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex309) )
          & ( v133308(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex308) )
          & ( v133308(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex307) )
          & ( v133308(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex306) )
          & ( v133308(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex305) )
          & ( v133308(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex304) )
          & ( v133308(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex303) )
          & ( v133308(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex302) )
          & ( v133308(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex301) )
          & ( v133308(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex300) )
          & ( v133308(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex299) )
          & ( v133308(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex298) )
          & ( v133308(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex297) )
          & ( v133308(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex296) )
          & ( v133308(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex295) )
          & ( v133308(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex294) )
          & ( v133308(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex293) )
          & ( v133308(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex292) )
          & ( v133308(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex291) )
          & ( v133308(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex290) )
          & ( v133308(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex289) )
          & ( v133308(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex288) )
          & ( v133308(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex287) )
          & ( v133308(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex286) )
          & ( v133308(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex285) )
          & ( v133308(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex284) )
          & ( v133308(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex283) )
          & ( v133308(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex282) )
          & ( v133308(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex281) )
          & ( v133308(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex280) )
          & ( v133308(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex279) )
          & ( v133308(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex278) )
          & ( v133308(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex277) )
          & ( v133308(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex276) )
          & ( v133308(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex275) )
          & ( v133308(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex274) )
          & ( v133308(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex273) )
          & ( v133308(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex272) )
          & ( v133308(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex271) )
          & ( v133308(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex270) )
          & ( v133308(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex269) )
          & ( v133308(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex268) )
          & ( v133308(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex267) )
          & ( v133308(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex266) )
          & ( v133308(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex265) )
          & ( v133308(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex264) )
          & ( v133308(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex263) )
          & ( v133308(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex262) )
          & ( v133308(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex261) )
          & ( v133308(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex260) )
          & ( v133308(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex259) )
          & ( v133308(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex258) )
          & ( v133308(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex257) )
          & ( v133308(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex256) )
          & ( v133308(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex255) )
          & ( v133308(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex254) )
          & ( v133308(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex253) )
          & ( v133308(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex252) )
          & ( v133308(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex251) )
          & ( v133308(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex250) )
          & ( v133308(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex249) )
          & ( v133308(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex248) )
          & ( v133308(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex247) )
          & ( v133308(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex246) )
          & ( v133308(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex245) )
          & ( v133308(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex244) )
          & ( v133308(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex243) )
          & ( v133308(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex242) )
          & ( v133308(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex241) )
          & ( v133308(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex240) )
          & ( v133308(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex239) )
          & ( v133308(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex238) )
          & ( v133308(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex237) )
          & ( v133308(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex236) )
          & ( v133308(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex235) )
          & ( v133308(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex234) )
          & ( v133308(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex233) )
          & ( v133308(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex232) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2465,axiom,
    ! [VarNext] :
      ( v133310(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133308(VarNext,B)
          <=> v323(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26700,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133310(VarNext)
      <=> ( v133311(VarNext)
          & v317(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133311(VarNext)
      <=> ( v133313(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11056,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133313(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43520,axiom,
    ! [VarCurr] :
      ( v292(VarCurr,bitIndex74)
    <=> v294(VarCurr,bitIndex74) ) ).

fof(addAssignment_43519,axiom,
    ! [VarCurr] :
      ( v294(VarCurr,bitIndex74)
    <=> v296(VarCurr,bitIndex74) ) ).

fof(addAssignment_43518,axiom,
    ! [VarCurr] :
      ( v296(VarCurr,bitIndex74)
    <=> v298(VarCurr,bitIndex74) ) ).

fof(addAssignment_43517,axiom,
    ! [VarCurr] :
      ( v298(VarCurr,bitIndex74)
    <=> v300(VarCurr,bitIndex74) ) ).

fof(addAssignment_43516,axiom,
    ! [VarCurr] :
      ( v300(VarCurr,bitIndex74)
    <=> v302(VarCurr,bitIndex74) ) ).

fof(addAssignment_43515,axiom,
    ! [VarCurr] :
      ( v254(VarCurr,bitIndex10)
    <=> v256(VarCurr,bitIndex10) ) ).

fof(addAssignment_43514,axiom,
    ! [VarCurr] :
      ( v256(VarCurr,bitIndex10)
    <=> v258(VarCurr,bitIndex10) ) ).

fof(addAssignment_43513,axiom,
    ! [VarCurr] :
      ( v258(VarCurr,bitIndex10)
    <=> v260(VarCurr,bitIndex10) ) ).

fof(addAssignment_43512,axiom,
    ! [VarCurr] :
      ( v260(VarCurr,bitIndex10)
    <=> v262(VarCurr,bitIndex590) ) ).

fof(addAssignment_43511,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex590)
    <=> v133298(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133300(VarNext)
       => ( ( v133298(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex695) )
          & ( v133298(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex694) )
          & ( v133298(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex693) )
          & ( v133298(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex692) )
          & ( v133298(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex691) )
          & ( v133298(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex690) )
          & ( v133298(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex689) )
          & ( v133298(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex688) )
          & ( v133298(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex687) )
          & ( v133298(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex686) )
          & ( v133298(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex685) )
          & ( v133298(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex684) )
          & ( v133298(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex683) )
          & ( v133298(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex682) )
          & ( v133298(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex681) )
          & ( v133298(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex680) )
          & ( v133298(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex679) )
          & ( v133298(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex678) )
          & ( v133298(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex677) )
          & ( v133298(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex676) )
          & ( v133298(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex675) )
          & ( v133298(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex674) )
          & ( v133298(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex673) )
          & ( v133298(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex672) )
          & ( v133298(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex671) )
          & ( v133298(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex670) )
          & ( v133298(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex669) )
          & ( v133298(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex668) )
          & ( v133298(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex667) )
          & ( v133298(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex666) )
          & ( v133298(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex665) )
          & ( v133298(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex664) )
          & ( v133298(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex663) )
          & ( v133298(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex662) )
          & ( v133298(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex661) )
          & ( v133298(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex660) )
          & ( v133298(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex659) )
          & ( v133298(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex658) )
          & ( v133298(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex657) )
          & ( v133298(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex656) )
          & ( v133298(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex655) )
          & ( v133298(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex654) )
          & ( v133298(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex653) )
          & ( v133298(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex652) )
          & ( v133298(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex651) )
          & ( v133298(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex650) )
          & ( v133298(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex649) )
          & ( v133298(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex648) )
          & ( v133298(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex647) )
          & ( v133298(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex646) )
          & ( v133298(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex645) )
          & ( v133298(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex644) )
          & ( v133298(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex643) )
          & ( v133298(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex642) )
          & ( v133298(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex641) )
          & ( v133298(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex640) )
          & ( v133298(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex639) )
          & ( v133298(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex638) )
          & ( v133298(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex637) )
          & ( v133298(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex636) )
          & ( v133298(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex635) )
          & ( v133298(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex634) )
          & ( v133298(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex633) )
          & ( v133298(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex632) )
          & ( v133298(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex631) )
          & ( v133298(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex630) )
          & ( v133298(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex629) )
          & ( v133298(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex628) )
          & ( v133298(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex627) )
          & ( v133298(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex626) )
          & ( v133298(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex625) )
          & ( v133298(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex624) )
          & ( v133298(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex623) )
          & ( v133298(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex622) )
          & ( v133298(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex621) )
          & ( v133298(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex620) )
          & ( v133298(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex619) )
          & ( v133298(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex618) )
          & ( v133298(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex617) )
          & ( v133298(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex616) )
          & ( v133298(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex615) )
          & ( v133298(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex614) )
          & ( v133298(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex613) )
          & ( v133298(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex612) )
          & ( v133298(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex611) )
          & ( v133298(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex610) )
          & ( v133298(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex609) )
          & ( v133298(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex608) )
          & ( v133298(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex607) )
          & ( v133298(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex606) )
          & ( v133298(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex605) )
          & ( v133298(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex604) )
          & ( v133298(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex603) )
          & ( v133298(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex602) )
          & ( v133298(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex601) )
          & ( v133298(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex600) )
          & ( v133298(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex599) )
          & ( v133298(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex598) )
          & ( v133298(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex597) )
          & ( v133298(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex596) )
          & ( v133298(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex595) )
          & ( v133298(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex594) )
          & ( v133298(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex593) )
          & ( v133298(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex592) )
          & ( v133298(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex591) )
          & ( v133298(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex590) )
          & ( v133298(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex589) )
          & ( v133298(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex588) )
          & ( v133298(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex587) )
          & ( v133298(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex586) )
          & ( v133298(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex585) )
          & ( v133298(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex584) )
          & ( v133298(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex583) )
          & ( v133298(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex582) )
          & ( v133298(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex581) )
          & ( v133298(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex580) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2464,axiom,
    ! [VarNext] :
      ( v133300(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133298(VarNext,B)
          <=> v380(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26698,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133300(VarNext)
      <=> ( v133301(VarNext)
          & v375(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26697,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133301(VarNext)
      <=> ( v133303(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11055,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133303(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43510,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex474)
    <=> v133290(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133292(VarNext)
       => ( ( v133290(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex579) )
          & ( v133290(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex578) )
          & ( v133290(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex577) )
          & ( v133290(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex576) )
          & ( v133290(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex575) )
          & ( v133290(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex574) )
          & ( v133290(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex573) )
          & ( v133290(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex572) )
          & ( v133290(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex571) )
          & ( v133290(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex570) )
          & ( v133290(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex569) )
          & ( v133290(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex568) )
          & ( v133290(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex567) )
          & ( v133290(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex566) )
          & ( v133290(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex565) )
          & ( v133290(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex564) )
          & ( v133290(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex563) )
          & ( v133290(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex562) )
          & ( v133290(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex561) )
          & ( v133290(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex560) )
          & ( v133290(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex559) )
          & ( v133290(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex558) )
          & ( v133290(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex557) )
          & ( v133290(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex556) )
          & ( v133290(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex555) )
          & ( v133290(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex554) )
          & ( v133290(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex553) )
          & ( v133290(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex552) )
          & ( v133290(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex551) )
          & ( v133290(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex550) )
          & ( v133290(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex549) )
          & ( v133290(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex548) )
          & ( v133290(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex547) )
          & ( v133290(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex546) )
          & ( v133290(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex545) )
          & ( v133290(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex544) )
          & ( v133290(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex543) )
          & ( v133290(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex542) )
          & ( v133290(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex541) )
          & ( v133290(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex540) )
          & ( v133290(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex539) )
          & ( v133290(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex538) )
          & ( v133290(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex537) )
          & ( v133290(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex536) )
          & ( v133290(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex535) )
          & ( v133290(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex534) )
          & ( v133290(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex533) )
          & ( v133290(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex532) )
          & ( v133290(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex531) )
          & ( v133290(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex530) )
          & ( v133290(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex529) )
          & ( v133290(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex528) )
          & ( v133290(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex527) )
          & ( v133290(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex526) )
          & ( v133290(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex525) )
          & ( v133290(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex524) )
          & ( v133290(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex523) )
          & ( v133290(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex522) )
          & ( v133290(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex521) )
          & ( v133290(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex520) )
          & ( v133290(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex519) )
          & ( v133290(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex518) )
          & ( v133290(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex517) )
          & ( v133290(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex516) )
          & ( v133290(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex515) )
          & ( v133290(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex514) )
          & ( v133290(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex513) )
          & ( v133290(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex512) )
          & ( v133290(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex511) )
          & ( v133290(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex510) )
          & ( v133290(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex509) )
          & ( v133290(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex508) )
          & ( v133290(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex507) )
          & ( v133290(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex506) )
          & ( v133290(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex505) )
          & ( v133290(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex504) )
          & ( v133290(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex503) )
          & ( v133290(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex502) )
          & ( v133290(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex501) )
          & ( v133290(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex500) )
          & ( v133290(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex499) )
          & ( v133290(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex498) )
          & ( v133290(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex497) )
          & ( v133290(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex496) )
          & ( v133290(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex495) )
          & ( v133290(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex494) )
          & ( v133290(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex493) )
          & ( v133290(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex492) )
          & ( v133290(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex491) )
          & ( v133290(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex490) )
          & ( v133290(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex489) )
          & ( v133290(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex488) )
          & ( v133290(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex487) )
          & ( v133290(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex486) )
          & ( v133290(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex485) )
          & ( v133290(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex484) )
          & ( v133290(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex483) )
          & ( v133290(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex482) )
          & ( v133290(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex481) )
          & ( v133290(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex480) )
          & ( v133290(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex479) )
          & ( v133290(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex478) )
          & ( v133290(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex477) )
          & ( v133290(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex476) )
          & ( v133290(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex475) )
          & ( v133290(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex474) )
          & ( v133290(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex473) )
          & ( v133290(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex472) )
          & ( v133290(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex471) )
          & ( v133290(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex470) )
          & ( v133290(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex469) )
          & ( v133290(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex468) )
          & ( v133290(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex467) )
          & ( v133290(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex466) )
          & ( v133290(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex465) )
          & ( v133290(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex464) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2463,axiom,
    ! [VarNext] :
      ( v133292(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133290(VarNext,B)
          <=> v361(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26696,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133292(VarNext)
      <=> ( v133293(VarNext)
          & v356(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26695,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133293(VarNext)
      <=> ( v133295(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11054,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133295(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43509,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex358)
    <=> v133282(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133284(VarNext)
       => ( ( v133282(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex463) )
          & ( v133282(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex462) )
          & ( v133282(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex461) )
          & ( v133282(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex460) )
          & ( v133282(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex459) )
          & ( v133282(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex458) )
          & ( v133282(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex457) )
          & ( v133282(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex456) )
          & ( v133282(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex455) )
          & ( v133282(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex454) )
          & ( v133282(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex453) )
          & ( v133282(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex452) )
          & ( v133282(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex451) )
          & ( v133282(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex450) )
          & ( v133282(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex449) )
          & ( v133282(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex448) )
          & ( v133282(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex447) )
          & ( v133282(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex446) )
          & ( v133282(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex445) )
          & ( v133282(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex444) )
          & ( v133282(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex443) )
          & ( v133282(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex442) )
          & ( v133282(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex441) )
          & ( v133282(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex440) )
          & ( v133282(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex439) )
          & ( v133282(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex438) )
          & ( v133282(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex437) )
          & ( v133282(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex436) )
          & ( v133282(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex435) )
          & ( v133282(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex434) )
          & ( v133282(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex433) )
          & ( v133282(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex432) )
          & ( v133282(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex431) )
          & ( v133282(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex430) )
          & ( v133282(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex429) )
          & ( v133282(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex428) )
          & ( v133282(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex427) )
          & ( v133282(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex426) )
          & ( v133282(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex425) )
          & ( v133282(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex424) )
          & ( v133282(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex423) )
          & ( v133282(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex422) )
          & ( v133282(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex421) )
          & ( v133282(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex420) )
          & ( v133282(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex419) )
          & ( v133282(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex418) )
          & ( v133282(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex417) )
          & ( v133282(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex416) )
          & ( v133282(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex415) )
          & ( v133282(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex414) )
          & ( v133282(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex413) )
          & ( v133282(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex412) )
          & ( v133282(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex411) )
          & ( v133282(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex410) )
          & ( v133282(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex409) )
          & ( v133282(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex408) )
          & ( v133282(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex407) )
          & ( v133282(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex406) )
          & ( v133282(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex405) )
          & ( v133282(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex404) )
          & ( v133282(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex403) )
          & ( v133282(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex402) )
          & ( v133282(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex401) )
          & ( v133282(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex400) )
          & ( v133282(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex399) )
          & ( v133282(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex398) )
          & ( v133282(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex397) )
          & ( v133282(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex396) )
          & ( v133282(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex395) )
          & ( v133282(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex394) )
          & ( v133282(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex393) )
          & ( v133282(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex392) )
          & ( v133282(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex391) )
          & ( v133282(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex390) )
          & ( v133282(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex389) )
          & ( v133282(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex388) )
          & ( v133282(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex387) )
          & ( v133282(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex386) )
          & ( v133282(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex385) )
          & ( v133282(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex384) )
          & ( v133282(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex383) )
          & ( v133282(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex382) )
          & ( v133282(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex381) )
          & ( v133282(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex380) )
          & ( v133282(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex379) )
          & ( v133282(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex378) )
          & ( v133282(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex377) )
          & ( v133282(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex376) )
          & ( v133282(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex375) )
          & ( v133282(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex374) )
          & ( v133282(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex373) )
          & ( v133282(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex372) )
          & ( v133282(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex371) )
          & ( v133282(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex370) )
          & ( v133282(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex369) )
          & ( v133282(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex368) )
          & ( v133282(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex367) )
          & ( v133282(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex366) )
          & ( v133282(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex365) )
          & ( v133282(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex364) )
          & ( v133282(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex363) )
          & ( v133282(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex362) )
          & ( v133282(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex361) )
          & ( v133282(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex360) )
          & ( v133282(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex359) )
          & ( v133282(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex358) )
          & ( v133282(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex357) )
          & ( v133282(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex356) )
          & ( v133282(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex355) )
          & ( v133282(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex354) )
          & ( v133282(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex353) )
          & ( v133282(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex352) )
          & ( v133282(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex351) )
          & ( v133282(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex350) )
          & ( v133282(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex349) )
          & ( v133282(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex348) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2462,axiom,
    ! [VarNext] :
      ( v133284(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133282(VarNext,B)
          <=> v342(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26694,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133284(VarNext)
      <=> ( v133285(VarNext)
          & v337(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26693,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133285(VarNext)
      <=> ( v133287(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11053,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133287(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43508,axiom,
    ! [VarNext] :
      ( v262(VarNext,bitIndex242)
    <=> v133274(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133276(VarNext)
       => ( ( v133274(VarNext,bitIndex115)
          <=> v262(VarCurr,bitIndex347) )
          & ( v133274(VarNext,bitIndex114)
          <=> v262(VarCurr,bitIndex346) )
          & ( v133274(VarNext,bitIndex113)
          <=> v262(VarCurr,bitIndex345) )
          & ( v133274(VarNext,bitIndex112)
          <=> v262(VarCurr,bitIndex344) )
          & ( v133274(VarNext,bitIndex111)
          <=> v262(VarCurr,bitIndex343) )
          & ( v133274(VarNext,bitIndex110)
          <=> v262(VarCurr,bitIndex342) )
          & ( v133274(VarNext,bitIndex109)
          <=> v262(VarCurr,bitIndex341) )
          & ( v133274(VarNext,bitIndex108)
          <=> v262(VarCurr,bitIndex340) )
          & ( v133274(VarNext,bitIndex107)
          <=> v262(VarCurr,bitIndex339) )
          & ( v133274(VarNext,bitIndex106)
          <=> v262(VarCurr,bitIndex338) )
          & ( v133274(VarNext,bitIndex105)
          <=> v262(VarCurr,bitIndex337) )
          & ( v133274(VarNext,bitIndex104)
          <=> v262(VarCurr,bitIndex336) )
          & ( v133274(VarNext,bitIndex103)
          <=> v262(VarCurr,bitIndex335) )
          & ( v133274(VarNext,bitIndex102)
          <=> v262(VarCurr,bitIndex334) )
          & ( v133274(VarNext,bitIndex101)
          <=> v262(VarCurr,bitIndex333) )
          & ( v133274(VarNext,bitIndex100)
          <=> v262(VarCurr,bitIndex332) )
          & ( v133274(VarNext,bitIndex99)
          <=> v262(VarCurr,bitIndex331) )
          & ( v133274(VarNext,bitIndex98)
          <=> v262(VarCurr,bitIndex330) )
          & ( v133274(VarNext,bitIndex97)
          <=> v262(VarCurr,bitIndex329) )
          & ( v133274(VarNext,bitIndex96)
          <=> v262(VarCurr,bitIndex328) )
          & ( v133274(VarNext,bitIndex95)
          <=> v262(VarCurr,bitIndex327) )
          & ( v133274(VarNext,bitIndex94)
          <=> v262(VarCurr,bitIndex326) )
          & ( v133274(VarNext,bitIndex93)
          <=> v262(VarCurr,bitIndex325) )
          & ( v133274(VarNext,bitIndex92)
          <=> v262(VarCurr,bitIndex324) )
          & ( v133274(VarNext,bitIndex91)
          <=> v262(VarCurr,bitIndex323) )
          & ( v133274(VarNext,bitIndex90)
          <=> v262(VarCurr,bitIndex322) )
          & ( v133274(VarNext,bitIndex89)
          <=> v262(VarCurr,bitIndex321) )
          & ( v133274(VarNext,bitIndex88)
          <=> v262(VarCurr,bitIndex320) )
          & ( v133274(VarNext,bitIndex87)
          <=> v262(VarCurr,bitIndex319) )
          & ( v133274(VarNext,bitIndex86)
          <=> v262(VarCurr,bitIndex318) )
          & ( v133274(VarNext,bitIndex85)
          <=> v262(VarCurr,bitIndex317) )
          & ( v133274(VarNext,bitIndex84)
          <=> v262(VarCurr,bitIndex316) )
          & ( v133274(VarNext,bitIndex83)
          <=> v262(VarCurr,bitIndex315) )
          & ( v133274(VarNext,bitIndex82)
          <=> v262(VarCurr,bitIndex314) )
          & ( v133274(VarNext,bitIndex81)
          <=> v262(VarCurr,bitIndex313) )
          & ( v133274(VarNext,bitIndex80)
          <=> v262(VarCurr,bitIndex312) )
          & ( v133274(VarNext,bitIndex79)
          <=> v262(VarCurr,bitIndex311) )
          & ( v133274(VarNext,bitIndex78)
          <=> v262(VarCurr,bitIndex310) )
          & ( v133274(VarNext,bitIndex77)
          <=> v262(VarCurr,bitIndex309) )
          & ( v133274(VarNext,bitIndex76)
          <=> v262(VarCurr,bitIndex308) )
          & ( v133274(VarNext,bitIndex75)
          <=> v262(VarCurr,bitIndex307) )
          & ( v133274(VarNext,bitIndex74)
          <=> v262(VarCurr,bitIndex306) )
          & ( v133274(VarNext,bitIndex73)
          <=> v262(VarCurr,bitIndex305) )
          & ( v133274(VarNext,bitIndex72)
          <=> v262(VarCurr,bitIndex304) )
          & ( v133274(VarNext,bitIndex71)
          <=> v262(VarCurr,bitIndex303) )
          & ( v133274(VarNext,bitIndex70)
          <=> v262(VarCurr,bitIndex302) )
          & ( v133274(VarNext,bitIndex69)
          <=> v262(VarCurr,bitIndex301) )
          & ( v133274(VarNext,bitIndex68)
          <=> v262(VarCurr,bitIndex300) )
          & ( v133274(VarNext,bitIndex67)
          <=> v262(VarCurr,bitIndex299) )
          & ( v133274(VarNext,bitIndex66)
          <=> v262(VarCurr,bitIndex298) )
          & ( v133274(VarNext,bitIndex65)
          <=> v262(VarCurr,bitIndex297) )
          & ( v133274(VarNext,bitIndex64)
          <=> v262(VarCurr,bitIndex296) )
          & ( v133274(VarNext,bitIndex63)
          <=> v262(VarCurr,bitIndex295) )
          & ( v133274(VarNext,bitIndex62)
          <=> v262(VarCurr,bitIndex294) )
          & ( v133274(VarNext,bitIndex61)
          <=> v262(VarCurr,bitIndex293) )
          & ( v133274(VarNext,bitIndex60)
          <=> v262(VarCurr,bitIndex292) )
          & ( v133274(VarNext,bitIndex59)
          <=> v262(VarCurr,bitIndex291) )
          & ( v133274(VarNext,bitIndex58)
          <=> v262(VarCurr,bitIndex290) )
          & ( v133274(VarNext,bitIndex57)
          <=> v262(VarCurr,bitIndex289) )
          & ( v133274(VarNext,bitIndex56)
          <=> v262(VarCurr,bitIndex288) )
          & ( v133274(VarNext,bitIndex55)
          <=> v262(VarCurr,bitIndex287) )
          & ( v133274(VarNext,bitIndex54)
          <=> v262(VarCurr,bitIndex286) )
          & ( v133274(VarNext,bitIndex53)
          <=> v262(VarCurr,bitIndex285) )
          & ( v133274(VarNext,bitIndex52)
          <=> v262(VarCurr,bitIndex284) )
          & ( v133274(VarNext,bitIndex51)
          <=> v262(VarCurr,bitIndex283) )
          & ( v133274(VarNext,bitIndex50)
          <=> v262(VarCurr,bitIndex282) )
          & ( v133274(VarNext,bitIndex49)
          <=> v262(VarCurr,bitIndex281) )
          & ( v133274(VarNext,bitIndex48)
          <=> v262(VarCurr,bitIndex280) )
          & ( v133274(VarNext,bitIndex47)
          <=> v262(VarCurr,bitIndex279) )
          & ( v133274(VarNext,bitIndex46)
          <=> v262(VarCurr,bitIndex278) )
          & ( v133274(VarNext,bitIndex45)
          <=> v262(VarCurr,bitIndex277) )
          & ( v133274(VarNext,bitIndex44)
          <=> v262(VarCurr,bitIndex276) )
          & ( v133274(VarNext,bitIndex43)
          <=> v262(VarCurr,bitIndex275) )
          & ( v133274(VarNext,bitIndex42)
          <=> v262(VarCurr,bitIndex274) )
          & ( v133274(VarNext,bitIndex41)
          <=> v262(VarCurr,bitIndex273) )
          & ( v133274(VarNext,bitIndex40)
          <=> v262(VarCurr,bitIndex272) )
          & ( v133274(VarNext,bitIndex39)
          <=> v262(VarCurr,bitIndex271) )
          & ( v133274(VarNext,bitIndex38)
          <=> v262(VarCurr,bitIndex270) )
          & ( v133274(VarNext,bitIndex37)
          <=> v262(VarCurr,bitIndex269) )
          & ( v133274(VarNext,bitIndex36)
          <=> v262(VarCurr,bitIndex268) )
          & ( v133274(VarNext,bitIndex35)
          <=> v262(VarCurr,bitIndex267) )
          & ( v133274(VarNext,bitIndex34)
          <=> v262(VarCurr,bitIndex266) )
          & ( v133274(VarNext,bitIndex33)
          <=> v262(VarCurr,bitIndex265) )
          & ( v133274(VarNext,bitIndex32)
          <=> v262(VarCurr,bitIndex264) )
          & ( v133274(VarNext,bitIndex31)
          <=> v262(VarCurr,bitIndex263) )
          & ( v133274(VarNext,bitIndex30)
          <=> v262(VarCurr,bitIndex262) )
          & ( v133274(VarNext,bitIndex29)
          <=> v262(VarCurr,bitIndex261) )
          & ( v133274(VarNext,bitIndex28)
          <=> v262(VarCurr,bitIndex260) )
          & ( v133274(VarNext,bitIndex27)
          <=> v262(VarCurr,bitIndex259) )
          & ( v133274(VarNext,bitIndex26)
          <=> v262(VarCurr,bitIndex258) )
          & ( v133274(VarNext,bitIndex25)
          <=> v262(VarCurr,bitIndex257) )
          & ( v133274(VarNext,bitIndex24)
          <=> v262(VarCurr,bitIndex256) )
          & ( v133274(VarNext,bitIndex23)
          <=> v262(VarCurr,bitIndex255) )
          & ( v133274(VarNext,bitIndex22)
          <=> v262(VarCurr,bitIndex254) )
          & ( v133274(VarNext,bitIndex21)
          <=> v262(VarCurr,bitIndex253) )
          & ( v133274(VarNext,bitIndex20)
          <=> v262(VarCurr,bitIndex252) )
          & ( v133274(VarNext,bitIndex19)
          <=> v262(VarCurr,bitIndex251) )
          & ( v133274(VarNext,bitIndex18)
          <=> v262(VarCurr,bitIndex250) )
          & ( v133274(VarNext,bitIndex17)
          <=> v262(VarCurr,bitIndex249) )
          & ( v133274(VarNext,bitIndex16)
          <=> v262(VarCurr,bitIndex248) )
          & ( v133274(VarNext,bitIndex15)
          <=> v262(VarCurr,bitIndex247) )
          & ( v133274(VarNext,bitIndex14)
          <=> v262(VarCurr,bitIndex246) )
          & ( v133274(VarNext,bitIndex13)
          <=> v262(VarCurr,bitIndex245) )
          & ( v133274(VarNext,bitIndex12)
          <=> v262(VarCurr,bitIndex244) )
          & ( v133274(VarNext,bitIndex11)
          <=> v262(VarCurr,bitIndex243) )
          & ( v133274(VarNext,bitIndex10)
          <=> v262(VarCurr,bitIndex242) )
          & ( v133274(VarNext,bitIndex9)
          <=> v262(VarCurr,bitIndex241) )
          & ( v133274(VarNext,bitIndex8)
          <=> v262(VarCurr,bitIndex240) )
          & ( v133274(VarNext,bitIndex7)
          <=> v262(VarCurr,bitIndex239) )
          & ( v133274(VarNext,bitIndex6)
          <=> v262(VarCurr,bitIndex238) )
          & ( v133274(VarNext,bitIndex5)
          <=> v262(VarCurr,bitIndex237) )
          & ( v133274(VarNext,bitIndex4)
          <=> v262(VarCurr,bitIndex236) )
          & ( v133274(VarNext,bitIndex3)
          <=> v262(VarCurr,bitIndex235) )
          & ( v133274(VarNext,bitIndex2)
          <=> v262(VarCurr,bitIndex234) )
          & ( v133274(VarNext,bitIndex1)
          <=> v262(VarCurr,bitIndex233) )
          & ( v133274(VarNext,bitIndex0)
          <=> v262(VarCurr,bitIndex232) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2461,axiom,
    ! [VarNext] :
      ( v133276(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133274(VarNext,B)
          <=> v323(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26692,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133276(VarNext)
      <=> ( v133277(VarNext)
          & v317(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26691,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133277(VarNext)
      <=> ( v133279(VarNext)
          & v304(VarNext) ) ) ) ).

fof(writeUnaryOperator_11052,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133279(VarNext)
      <=> v311(VarNext) ) ) ).

fof(addAssignment_43507,axiom,
    ! [VarCurr] :
      ( v292(VarCurr,bitIndex10)
    <=> v294(VarCurr,bitIndex10) ) ).

fof(addAssignment_43506,axiom,
    ! [VarCurr] :
      ( v294(VarCurr,bitIndex10)
    <=> v296(VarCurr,bitIndex10) ) ).

fof(addAssignment_43505,axiom,
    ! [VarCurr] :
      ( v296(VarCurr,bitIndex10)
    <=> v298(VarCurr,bitIndex10) ) ).

fof(addAssignment_43504,axiom,
    ! [VarCurr] :
      ( v298(VarCurr,bitIndex10)
    <=> v300(VarCurr,bitIndex10) ) ).

fof(addAssignment_43503,axiom,
    ! [VarCurr] :
      ( v300(VarCurr,bitIndex10)
    <=> v302(VarCurr,bitIndex10) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3186,axiom,
    ! [VarCurr] :
      ( ~ v133246(VarCurr)
     => ( v133244(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2991,axiom,
    ! [VarCurr] :
      ( v133246(VarCurr)
     => ( v133244(VarCurr)
      <=> v133272(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5408,axiom,
    ! [VarCurr] :
      ( ~ v133247(VarCurr)
     => ( v133272(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5397,axiom,
    ! [VarCurr] :
      ( v133247(VarCurr)
     => ( v133272(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26690,axiom,
    ! [VarCurr] :
      ( v133246(VarCurr)
    <=> ( v133247(VarCurr)
        | v133249(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26689,axiom,
    ! [VarCurr] :
      ( v133249(VarCurr)
    <=> ( v133250(VarCurr)
        | v133267(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26688,axiom,
    ! [VarCurr] :
      ( v133267(VarCurr)
    <=> ( v133269(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26687,axiom,
    ! [VarCurr] :
      ( v133269(VarCurr)
    <=> ( v133270(VarCurr)
        & v10062(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26686,axiom,
    ! [VarCurr] :
      ( v133270(VarCurr)
    <=> ( v133271(VarCurr)
        & v10061(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3078,axiom,
    ! [VarCurr] :
      ( v133271(VarCurr)
    <=> ( v133262(VarCurr)
        & v4209(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26685,axiom,
    ! [VarCurr] :
      ( v133250(VarCurr)
    <=> ( v133251(VarCurr)
        | v133264(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26684,axiom,
    ! [VarCurr] :
      ( v133264(VarCurr)
    <=> ( v133266(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3077,axiom,
    ! [VarCurr] :
      ( v133266(VarCurr)
    <=> ( v133260(VarCurr)
        & v4209(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26683,axiom,
    ! [VarCurr] :
      ( v133251(VarCurr)
    <=> ( v133252(VarCurr)
        | v133257(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26682,axiom,
    ! [VarCurr] :
      ( v133257(VarCurr)
    <=> ( v133259(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26681,axiom,
    ! [VarCurr] :
      ( v133259(VarCurr)
    <=> ( v133260(VarCurr)
        & v10062(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26680,axiom,
    ! [VarCurr] :
      ( v133260(VarCurr)
    <=> ( v133261(VarCurr)
        & v10061(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26679,axiom,
    ! [VarCurr] :
      ( v133261(VarCurr)
    <=> ( v133262(VarCurr)
        & v10060(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26678,axiom,
    ! [VarCurr] :
      ( v133262(VarCurr)
    <=> ( v133263(VarCurr)
        & v10059(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26677,axiom,
    ! [VarCurr] :
      ( v133263(VarCurr)
    <=> ( v4209(VarCurr,bitIndex0)
        & v10058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26676,axiom,
    ! [VarCurr] :
      ( v133252(VarCurr)
    <=> ( v133253(VarCurr)
        | v133255(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26675,axiom,
    ! [VarCurr] :
      ( v133255(VarCurr)
    <=> ( v10067(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26674,axiom,
    ! [VarCurr] :
      ( v133253(VarCurr)
    <=> ( v10052(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26673,axiom,
    ! [VarCurr] :
      ( v133247(VarCurr)
    <=> ( v15436(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(addAssignment_43502,axiom,
    ! [VarCurr] :
      ( ( v133239(VarCurr,bitIndex6)
      <=> v105126(VarCurr,bitIndex122) )
      & ( v133239(VarCurr,bitIndex5)
      <=> v105126(VarCurr,bitIndex121) )
      & ( v133239(VarCurr,bitIndex4)
      <=> v105126(VarCurr,bitIndex120) )
      & ( v133239(VarCurr,bitIndex3)
      <=> v105126(VarCurr,bitIndex119) )
      & ( v133239(VarCurr,bitIndex2)
      <=> v105126(VarCurr,bitIndex118) )
      & ( v133239(VarCurr,bitIndex1)
      <=> v105126(VarCurr,bitIndex117) )
      & ( v133239(VarCurr,bitIndex0)
      <=> v105126(VarCurr,bitIndex116) ) ) ).

fof(addAssignment_43501,axiom,
    ! [VarCurr] :
      ( v99(VarCurr)
    <=> v101(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133216(VarNext)
       => ( v101(VarNext)
        <=> v101(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2460,axiom,
    ! [VarNext] :
      ( v133216(VarNext)
     => ( v101(VarNext)
      <=> v133234(VarNext) ) ) ).

fof(addAssignment_43500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133234(VarNext)
      <=> v133232(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3185,axiom,
    ! [VarCurr] :
      ( ~ v133231(VarCurr)
     => ( v133232(VarCurr)
      <=> v133235(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2990,axiom,
    ! [VarCurr] :
      ( v133231(VarCurr)
     => ( v133232(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3184,axiom,
    ! [VarCurr] :
      ( ~ v105(VarCurr)
     => ( v133235(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2989,axiom,
    ! [VarCurr] :
      ( v105(VarCurr)
     => ( v133235(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26672,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133216(VarNext)
      <=> ( v133217(VarNext)
          & v133224(VarNext) ) ) ) ).

fof(addAssignment_43499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133224(VarNext)
      <=> v133222(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26671,axiom,
    ! [VarCurr] :
      ( v133222(VarCurr)
    <=> ( v133225(VarCurr)
        | v133231(VarCurr) ) ) ).

fof(writeUnaryOperator_11051,axiom,
    ! [VarCurr] :
      ( ~ v133231(VarCurr)
    <=> v103(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26670,axiom,
    ! [VarCurr] :
      ( v133225(VarCurr)
    <=> ( v133226(VarCurr)
        | v105(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26669,axiom,
    ! [VarCurr] :
      ( v133226(VarCurr)
    <=> ( v133227(VarCurr)
        & v133230(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9308,axiom,
    ! [VarCurr] :
      ( v133230(VarCurr)
    <=> ( v105190(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26668,axiom,
    ! [VarCurr] :
      ( v133227(VarCurr)
    <=> ( v133228(VarCurr)
        & v133229(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9307,axiom,
    ! [VarCurr] :
      ( v133229(VarCurr)
    <=> ( v15460(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_9306,axiom,
    ! [VarCurr] :
      ( v133228(VarCurr)
    <=> ( v15464(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26667,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133217(VarNext)
      <=> ( v133218(VarNext)
          & v105195(VarNext) ) ) ) ).

fof(writeUnaryOperator_11050,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133218(VarNext)
      <=> v105202(VarNext) ) ) ).

fof(addAssignment_43498,axiom,
    ! [VarCurr] :
      ( v105190(VarCurr,bitIndex0)
    <=> v105212(VarCurr,bitIndex0) ) ).

fof(addAssignment_43497,axiom,
    ! [VarCurr] :
      ( v105(VarCurr)
    <=> v107(VarCurr) ) ).

fof(addAssignment_43496,axiom,
    ! [VarCurr] :
      ( v107(VarCurr)
    <=> v109(VarCurr) ) ).

fof(addAssignment_43495,axiom,
    ! [VarCurr] :
      ( v109(VarCurr)
    <=> v111(VarCurr) ) ).

fof(addAssignment_43494,axiom,
    ! [VarCurr] :
      ( v111(VarCurr)
    <=> v113(VarCurr) ) ).

fof(addAssignment_43493,axiom,
    ! [VarCurr] :
      ( v113(VarCurr)
    <=> v115(VarCurr) ) ).

fof(addAssignment_43492,axiom,
    ! [VarCurr] :
      ( v115(VarCurr)
    <=> v117(VarCurr) ) ).

fof(addAssignment_43491,axiom,
    ! [VarCurr] :
      ( v117(VarCurr)
    <=> v119(VarCurr) ) ).

fof(addAssignment_43490,axiom,
    ! [VarCurr] :
      ( v119(VarCurr)
    <=> v121(VarCurr,bitIndex1) ) ).

fof(addAssignment_43489,axiom,
    ! [VarNext] :
      ( v121(VarNext,bitIndex1)
    <=> v133207(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133208(VarNext)
       => ( ( v133207(VarNext,bitIndex1)
          <=> v121(VarCurr,bitIndex2) )
          & ( v133207(VarNext,bitIndex0)
          <=> v121(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2459,axiom,
    ! [VarNext] :
      ( v133208(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v133207(VarNext,B)
          <=> v131285(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26666,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133208(VarNext)
      <=> v133209(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26665,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133209(VarNext)
      <=> ( v133211(VarNext)
          & v131193(VarNext) ) ) ) ).

fof(writeUnaryOperator_11049,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133211(VarNext)
      <=> v131200(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_586,axiom,
    ! [VarCurr] :
      ( ~ v133192(VarCurr)
     => ( v130(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_781,axiom,
    ! [VarCurr] :
      ( v133192(VarCurr)
     => ( v130(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26664,axiom,
    ! [VarCurr] :
      ( v133192(VarCurr)
    <=> ( v133193(VarCurr)
        | v133202(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26663,axiom,
    ! [VarCurr] :
      ( v133202(VarCurr)
    <=> ( v133203(VarCurr)
        & v133204(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26662,axiom,
    ! [VarCurr] :
      ( v133204(VarCurr)
    <=> ( v133205(VarCurr)
        & v131274(VarCurr) ) ) ).

fof(writeUnaryOperator_11048,axiom,
    ! [VarCurr] :
      ( ~ v133205(VarCurr)
    <=> v15444(VarCurr) ) ).

fof(writeUnaryOperator_11047,axiom,
    ! [VarCurr] :
      ( ~ v133203(VarCurr)
    <=> v131246(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26661,axiom,
    ! [VarCurr] :
      ( v133193(VarCurr)
    <=> ( v133194(VarCurr)
        & v131246(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26660,axiom,
    ! [VarCurr] :
      ( v133194(VarCurr)
    <=> ( v133195(VarCurr)
        | v133199(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26659,axiom,
    ! [VarCurr] :
      ( v133199(VarCurr)
    <=> ( v133201(VarCurr)
        & v131235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26658,axiom,
    ! [VarCurr] :
      ( v133201(VarCurr)
    <=> ( v131244(VarCurr)
        & v131239(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26657,axiom,
    ! [VarCurr] :
      ( v133195(VarCurr)
    <=> ( v133197(VarCurr)
        & v131235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26656,axiom,
    ! [VarCurr] :
      ( v133197(VarCurr)
    <=> ( v133198(VarCurr)
        & v15416(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26655,axiom,
    ! [VarCurr] :
      ( v133198(VarCurr)
    <=> ( v131244(VarCurr)
        & v131270(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26654,axiom,
    ! [VarCurr] :
      ( v244(VarCurr)
    <=> ( v133187(VarCurr)
        | v133188(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26653,axiom,
    ! [VarCurr] :
      ( v133188(VarCurr)
    <=> ( v133189(VarCurr)
        & v133007(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26652,axiom,
    ! [VarCurr] :
      ( v133189(VarCurr)
    <=> ( v132994(VarCurr)
        | v15418(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26651,axiom,
    ! [VarCurr] :
      ( v133187(VarCurr)
    <=> ( v246(VarCurr)
        & v10069(VarCurr) ) ) ).

fof(addAssignment_43488,axiom,
    ! [VarCurr] :
      ( v133007(VarCurr)
    <=> v133009(VarCurr) ) ).

fof(addAssignment_43487,axiom,
    ! [VarCurr] :
      ( v133009(VarCurr)
    <=> v133011(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26650,axiom,
    ! [VarCurr] :
      ( v133011(VarCurr)
    <=> ( v133184(VarCurr)
        & v133185(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3076,axiom,
    ! [VarCurr] :
      ( v133185(VarCurr)
    <=> ( v133013(VarCurr,bitIndex4)
      <~> v133095(VarCurr,bitIndex4) ) ) ).

fof(addBitVectorEqualityBitBlasted_9305,axiom,
    ! [VarCurr] :
      ( v133184(VarCurr)
    <=> ( ( v133013(VarCurr,bitIndex3)
        <=> v133095(VarCurr,bitIndex3) )
        & ( v133013(VarCurr,bitIndex2)
        <=> v133095(VarCurr,bitIndex2) )
        & ( v133013(VarCurr,bitIndex1)
        <=> v133095(VarCurr,bitIndex1) )
        & ( v133013(VarCurr,bitIndex0)
        <=> v133095(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133165(VarNext)
       => ( v133095(VarNext,bitIndex4)
        <=> v133095(VarCurr,bitIndex4) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_16,axiom,
    ! [VarNext] :
      ( v133165(VarNext)
     => ( v133095(VarNext,bitIndex4)
      <=> v133179(VarNext) ) ) ).

fof(addAssignment_43486,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133179(VarNext)
      <=> v133177(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5407,axiom,
    ! [VarCurr] :
      ( ~ v133115(VarCurr)
     => ( v133177(VarCurr)
      <=> v133180(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5396,axiom,
    ! [VarCurr] :
      ( v133115(VarCurr)
     => ( v133177(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_11046,axiom,
    ! [VarCurr] :
      ( ~ v133180(VarCurr)
    <=> v133095(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26649,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133165(VarNext)
      <=> ( v133166(VarNext)
          & v133173(VarNext) ) ) ) ).

fof(addAssignment_43485,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133173(VarNext)
      <=> v133171(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26648,axiom,
    ! [VarCurr] :
      ( v133171(VarCurr)
    <=> ( v133115(VarCurr)
        | v133174(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26647,axiom,
    ! [VarCurr] :
      ( v133174(VarCurr)
    <=> ( v133175(VarCurr)
        & v133176(VarCurr) ) ) ).

fof(writeUnaryOperator_11045,axiom,
    ! [VarCurr] :
      ( ~ v133176(VarCurr)
    <=> v133115(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26646,axiom,
    ! [VarCurr] :
      ( v133175(VarCurr)
    <=> ( v133122(VarCurr)
        & v133097(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26645,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133166(VarNext)
      <=> ( v133168(VarNext)
          & v131318(VarNext) ) ) ) ).

fof(writeUnaryOperator_11044,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133168(VarNext)
      <=> v131325(VarNext) ) ) ).

fof(addAssignment_43484,axiom,
    ! [VarCurr] :
      ( v133013(VarCurr,bitIndex4)
    <=> v133015(VarCurr,bitIndex4) ) ).

fof(addAssignment_43483,axiom,
    ! [VarCurr] :
      ( v133015(VarCurr,bitIndex4)
    <=> v133017(VarCurr,bitIndex4) ) ).

fof(addAssignment_43482,axiom,
    ! [VarCurr] :
      ( v133017(VarCurr,bitIndex4)
    <=> v133019(VarCurr,bitIndex4) ) ).

fof(addAssignment_43481,axiom,
    ! [VarCurr] :
      ( v133019(VarCurr,bitIndex4)
    <=> v133021(VarCurr,bitIndex4) ) ).

fof(addAssignment_43480,axiom,
    ! [VarCurr] :
      ( v133021(VarCurr,bitIndex4)
    <=> v133023(VarCurr,bitIndex4) ) ).

fof(addAssignment_43479,axiom,
    ! [VarCurr] :
      ( v133023(VarCurr,bitIndex4)
    <=> v133025(VarCurr,bitIndex4) ) ).

fof(addAssignment_43478,axiom,
    ! [VarCurr] :
      ( v133025(VarCurr,bitIndex4)
    <=> v133091(VarCurr,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_2334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133146(VarNext)
       => ( v133092(VarNext)
        <=> v133092(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2458,axiom,
    ! [VarNext] :
      ( v133146(VarNext)
     => ( v133092(VarNext)
      <=> v133159(VarNext) ) ) ).

fof(addAssignment_43477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133159(VarNext)
      <=> v133157(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5406,axiom,
    ! [VarCurr] :
      ( ~ v133060(VarCurr)
     => ( v133157(VarCurr)
      <=> v133160(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5395,axiom,
    ! [VarCurr] :
      ( v133060(VarCurr)
     => ( v133157(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26644,axiom,
    ! [VarCurr] :
      ( v133160(VarCurr)
    <=> ( v133092(VarCurr)
      <~> v133047(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26643,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133146(VarNext)
      <=> ( v133147(VarNext)
          & v133154(VarNext) ) ) ) ).

fof(addAssignment_43476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133154(VarNext)
      <=> v133152(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26642,axiom,
    ! [VarCurr] :
      ( v133152(VarCurr)
    <=> ( v133060(VarCurr)
        | v133155(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26641,axiom,
    ! [VarCurr] :
      ( v133155(VarCurr)
    <=> ( v133029(VarCurr)
        & v133156(VarCurr) ) ) ).

fof(writeUnaryOperator_11043,axiom,
    ! [VarCurr] :
      ( ~ v133156(VarCurr)
    <=> v133060(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26640,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133147(VarNext)
      <=> ( v133149(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_11042,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133149(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2333,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133106(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v133095(VarNext,B)
            <=> v133095(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2457,axiom,
    ! [VarNext] :
      ( v133106(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133095(VarNext,B)
          <=> v133120(VarNext,B) ) ) ) ).

fof(addAssignment_43475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133120(VarNext,B)
          <=> v133118(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5405,axiom,
    ! [VarCurr] :
      ( ~ v133115(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133118(VarCurr,B)
          <=> v133121(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5394,axiom,
    ! [VarCurr] :
      ( v133115(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133118(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3183,axiom,
    ! [VarCurr] :
      ( ~ v133122(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133121(VarCurr,B)
          <=> v133123(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2988,axiom,
    ! [VarCurr] :
      ( v133122(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133121(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43474,axiom,
    ! [VarCurr] :
      ( v133123(VarCurr,bitIndex0)
    <=> v133139(VarCurr) ) ).

fof(addAssignment_43473,axiom,
    ! [VarCurr] :
      ( v133123(VarCurr,bitIndex1)
    <=> v133137(VarCurr) ) ).

fof(addAssignment_43472,axiom,
    ! [VarCurr] :
      ( v133123(VarCurr,bitIndex2)
    <=> v133132(VarCurr) ) ).

fof(addAssignment_43471,axiom,
    ! [VarCurr] :
      ( v133123(VarCurr,bitIndex3)
    <=> v133125(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26639,axiom,
    ! [VarCurr] :
      ( v133137(VarCurr)
    <=> ( v133138(VarCurr)
        & v133141(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3075,axiom,
    ! [VarCurr] :
      ( v133141(VarCurr)
    <=> ( v133095(VarCurr,bitIndex0)
        | v133095(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26638,axiom,
    ! [VarCurr] :
      ( v133138(VarCurr)
    <=> ( v133139(VarCurr)
        | v133140(VarCurr) ) ) ).

fof(writeUnaryOperator_11041,axiom,
    ! [VarCurr] :
      ( ~ v133140(VarCurr)
    <=> v133095(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11040,axiom,
    ! [VarCurr] :
      ( ~ v133139(VarCurr)
    <=> v133095(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26637,axiom,
    ! [VarCurr] :
      ( v133132(VarCurr)
    <=> ( v133133(VarCurr)
        & v133136(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3074,axiom,
    ! [VarCurr] :
      ( v133136(VarCurr)
    <=> ( v133129(VarCurr)
        | v133095(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26636,axiom,
    ! [VarCurr] :
      ( v133133(VarCurr)
    <=> ( v133134(VarCurr)
        | v133135(VarCurr) ) ) ).

fof(writeUnaryOperator_11039,axiom,
    ! [VarCurr] :
      ( ~ v133135(VarCurr)
    <=> v133095(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11038,axiom,
    ! [VarCurr] :
      ( ~ v133134(VarCurr)
    <=> v133129(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26635,axiom,
    ! [VarCurr] :
      ( v133125(VarCurr)
    <=> ( v133126(VarCurr)
        & v133131(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3073,axiom,
    ! [VarCurr] :
      ( v133131(VarCurr)
    <=> ( v133128(VarCurr)
        | v133095(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26634,axiom,
    ! [VarCurr] :
      ( v133126(VarCurr)
    <=> ( v133127(VarCurr)
        | v133130(VarCurr) ) ) ).

fof(writeUnaryOperator_11037,axiom,
    ! [VarCurr] :
      ( ~ v133130(VarCurr)
    <=> v133095(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11036,axiom,
    ! [VarCurr] :
      ( ~ v133127(VarCurr)
    <=> v133128(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3072,axiom,
    ! [VarCurr] :
      ( v133128(VarCurr)
    <=> ( v133129(VarCurr)
        & v133095(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3071,axiom,
    ! [VarCurr] :
      ( v133129(VarCurr)
    <=> ( v133095(VarCurr,bitIndex0)
        & v133095(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9304,axiom,
    ! [VarCurr] :
      ( v133122(VarCurr)
    <=> ( ( v133095(VarCurr,bitIndex3)
        <=> $true )
        & ( v133095(VarCurr,bitIndex2)
        <=> $false )
        & ( v133095(VarCurr,bitIndex1)
        <=> $true )
        & ( v133095(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26633,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133106(VarNext)
      <=> ( v133107(VarNext)
          & v133114(VarNext) ) ) ) ).

fof(addAssignment_43470,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133114(VarNext)
      <=> v133112(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26632,axiom,
    ! [VarCurr] :
      ( v133112(VarCurr)
    <=> ( v133115(VarCurr)
        | v133116(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26631,axiom,
    ! [VarCurr] :
      ( v133116(VarCurr)
    <=> ( v133097(VarCurr)
        & v133117(VarCurr) ) ) ).

fof(writeUnaryOperator_11035,axiom,
    ! [VarCurr] :
      ( ~ v133117(VarCurr)
    <=> v133115(VarCurr) ) ).

fof(writeUnaryOperator_11034,axiom,
    ! [VarCurr] :
      ( ~ v133115(VarCurr)
    <=> v15398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133107(VarNext)
      <=> ( v133108(VarNext)
          & v131318(VarNext) ) ) ) ).

fof(writeUnaryOperator_11033,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133108(VarNext)
      <=> v131325(VarNext) ) ) ).

fof(addAssignment_43469,axiom,
    ! [VarCurr] :
      ( v133097(VarCurr)
    <=> v133099(VarCurr) ) ).

fof(addAssignment_43468,axiom,
    ! [VarCurr] :
      ( v133099(VarCurr)
    <=> v133101(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3070,axiom,
    ! [VarCurr] :
      ( v133101(VarCurr)
    <=> ( v130(VarCurr,bitIndex1)
        & v133103(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26629,axiom,
    ! [VarCurr] :
      ( v133103(VarCurr)
    <=> ( v15418(VarCurr)
        | v132994(VarCurr) ) ) ).

fof(addAssignment_43467,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133013(VarCurr,B)
      <=> v133015(VarCurr,B) ) ) ).

fof(addAssignment_43466,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133015(VarCurr,B)
      <=> v133017(VarCurr,B) ) ) ).

fof(addAssignment_43465,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133017(VarCurr,B)
      <=> v133019(VarCurr,B) ) ) ).

fof(addAssignment_43464,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133019(VarCurr,B)
      <=> v133021(VarCurr,B) ) ) ).

fof(addAssignment_43463,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133021(VarCurr,B)
      <=> v133023(VarCurr,B) ) ) ).

fof(addAssignment_43462,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133023(VarCurr,B)
      <=> v133025(VarCurr,B) ) ) ).

fof(addAssignment_43461,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133025(VarCurr,B)
      <=> v133091(VarCurr,B) ) ) ).

fof(addAssignment_43460,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133091(VarCurr,B)
      <=> v133027(VarCurr,B) ) ) ).

fof(addAssignment_43459,axiom,
    ! [VarCurr] :
      ( v133091(VarCurr,bitIndex4)
    <=> v133092(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2332,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133051(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v133027(VarNext,B)
            <=> v133027(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2456,axiom,
    ! [VarNext] :
      ( v133051(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133027(VarNext,B)
          <=> v133065(VarNext,B) ) ) ) ).

fof(addAssignment_43458,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133065(VarNext,B)
          <=> v133063(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5404,axiom,
    ! [VarCurr] :
      ( ~ v133060(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133063(VarCurr,B)
          <=> v133066(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5393,axiom,
    ! [VarCurr] :
      ( v133060(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133063(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_141,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133066(VarCurr,B)
      <=> ( v133067(VarCurr,B)
          & v133086(VarCurr,B) ) ) ) ).

fof(addAssignment_43457,axiom,
    ! [VarCurr] :
      ( v133086(VarCurr,bitIndex0)
    <=> v133087(VarCurr) ) ).

fof(addAssignment_43456,axiom,
    ! [VarCurr] :
      ( v133086(VarCurr,bitIndex1)
    <=> v133087(VarCurr) ) ).

fof(addAssignment_43455,axiom,
    ! [VarCurr] :
      ( v133086(VarCurr,bitIndex2)
    <=> v133087(VarCurr) ) ).

fof(addAssignment_43454,axiom,
    ! [VarCurr] :
      ( v133086(VarCurr,bitIndex3)
    <=> v133087(VarCurr) ) ).

fof(addAssignment_43453,axiom,
    ! [VarCurr] :
      ( v133087(VarCurr)
    <=> v133088(VarCurr) ) ).

fof(writeUnaryOperator_11032,axiom,
    ! [VarCurr] :
      ( ~ v133088(VarCurr)
    <=> v133047(VarCurr) ) ).

fof(addAssignment_43452,axiom,
    ! [VarCurr] :
      ( v133067(VarCurr,bitIndex0)
    <=> v133083(VarCurr) ) ).

fof(addAssignment_43451,axiom,
    ! [VarCurr] :
      ( v133067(VarCurr,bitIndex1)
    <=> v133081(VarCurr) ) ).

fof(addAssignment_43450,axiom,
    ! [VarCurr] :
      ( v133067(VarCurr,bitIndex2)
    <=> v133076(VarCurr) ) ).

fof(addAssignment_43449,axiom,
    ! [VarCurr] :
      ( v133067(VarCurr,bitIndex3)
    <=> v133069(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26628,axiom,
    ! [VarCurr] :
      ( v133081(VarCurr)
    <=> ( v133082(VarCurr)
        & v133085(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3069,axiom,
    ! [VarCurr] :
      ( v133085(VarCurr)
    <=> ( v133027(VarCurr,bitIndex0)
        | v133027(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26627,axiom,
    ! [VarCurr] :
      ( v133082(VarCurr)
    <=> ( v133083(VarCurr)
        | v133084(VarCurr) ) ) ).

fof(writeUnaryOperator_11031,axiom,
    ! [VarCurr] :
      ( ~ v133084(VarCurr)
    <=> v133027(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11030,axiom,
    ! [VarCurr] :
      ( ~ v133083(VarCurr)
    <=> v133027(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26626,axiom,
    ! [VarCurr] :
      ( v133076(VarCurr)
    <=> ( v133077(VarCurr)
        & v133080(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3068,axiom,
    ! [VarCurr] :
      ( v133080(VarCurr)
    <=> ( v133073(VarCurr)
        | v133027(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26625,axiom,
    ! [VarCurr] :
      ( v133077(VarCurr)
    <=> ( v133078(VarCurr)
        | v133079(VarCurr) ) ) ).

fof(writeUnaryOperator_11029,axiom,
    ! [VarCurr] :
      ( ~ v133079(VarCurr)
    <=> v133027(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11028,axiom,
    ! [VarCurr] :
      ( ~ v133078(VarCurr)
    <=> v133073(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26624,axiom,
    ! [VarCurr] :
      ( v133069(VarCurr)
    <=> ( v133070(VarCurr)
        & v133075(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3067,axiom,
    ! [VarCurr] :
      ( v133075(VarCurr)
    <=> ( v133072(VarCurr)
        | v133027(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26623,axiom,
    ! [VarCurr] :
      ( v133070(VarCurr)
    <=> ( v133071(VarCurr)
        | v133074(VarCurr) ) ) ).

fof(writeUnaryOperator_11027,axiom,
    ! [VarCurr] :
      ( ~ v133074(VarCurr)
    <=> v133027(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11026,axiom,
    ! [VarCurr] :
      ( ~ v133071(VarCurr)
    <=> v133072(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3066,axiom,
    ! [VarCurr] :
      ( v133072(VarCurr)
    <=> ( v133073(VarCurr)
        & v133027(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3065,axiom,
    ! [VarCurr] :
      ( v133073(VarCurr)
    <=> ( v133027(VarCurr,bitIndex0)
        & v133027(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26622,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133051(VarNext)
      <=> ( v133052(VarNext)
          & v133059(VarNext) ) ) ) ).

fof(addAssignment_43448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133059(VarNext)
      <=> v133057(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26621,axiom,
    ! [VarCurr] :
      ( v133057(VarCurr)
    <=> ( v133060(VarCurr)
        | v133061(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26620,axiom,
    ! [VarCurr] :
      ( v133061(VarCurr)
    <=> ( v133029(VarCurr)
        & v133062(VarCurr) ) ) ).

fof(writeUnaryOperator_11025,axiom,
    ! [VarCurr] :
      ( ~ v133062(VarCurr)
    <=> v133060(VarCurr) ) ).

fof(writeUnaryOperator_11024,axiom,
    ! [VarCurr] :
      ( ~ v133060(VarCurr)
    <=> v10091(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26619,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133052(VarNext)
      <=> ( v133053(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_11023,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133053(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(addBitVectorEqualityBitBlasted_9303,axiom,
    ! [VarCurr] :
      ( v133047(VarCurr)
    <=> ( ( v133027(VarCurr,bitIndex3)
        <=> $true )
        & ( v133027(VarCurr,bitIndex2)
        <=> $false )
        & ( v133027(VarCurr,bitIndex1)
        <=> $true )
        & ( v133027(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43447,axiom,
    ! [VarCurr] :
      ( v133029(VarCurr)
    <=> v133031(VarCurr) ) ).

fof(addAssignment_43446,axiom,
    ! [VarCurr] :
      ( v133031(VarCurr)
    <=> v133033(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3064,axiom,
    ! [VarCurr] :
      ( v133033(VarCurr)
    <=> ( v10103(VarCurr,bitIndex7)
        | v133035(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26618,axiom,
    ! [VarCurr] :
      ( v133035(VarCurr)
    <=> ( v133041(VarCurr)
        & v133044(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26617,axiom,
    ! [VarCurr] :
      ( v133044(VarCurr)
    <=> ( v133037(VarCurr)
        | v133039(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26616,axiom,
    ! [VarCurr] :
      ( v133041(VarCurr)
    <=> ( v133042(VarCurr)
        & v133043(VarCurr) ) ) ).

fof(writeUnaryOperator_11022,axiom,
    ! [VarCurr] :
      ( ~ v133043(VarCurr)
    <=> v132679(VarCurr) ) ).

fof(writeUnaryOperator_11021,axiom,
    ! [VarCurr] :
      ( ~ v133042(VarCurr)
    <=> v15300(VarCurr) ) ).

fof(addAssignment_43445,axiom,
    ! [VarCurr] :
      ( v133039(VarCurr)
    <=> v132690(VarCurr) ) ).

fof(addAssignment_43444,axiom,
    ! [VarCurr] :
      ( v133037(VarCurr)
    <=> v132683(VarCurr) ) ).

fof(addAssignment_43443,axiom,
    ! [VarCurr] :
      ( v132994(VarCurr)
    <=> v132996(VarCurr) ) ).

fof(addAssignment_43442,axiom,
    ! [VarCurr] :
      ( v132996(VarCurr)
    <=> v132998(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3182,axiom,
    ! [VarCurr] :
      ( ~ v133001(VarCurr)
     => ( v132998(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2987,axiom,
    ! [VarCurr] :
      ( v133001(VarCurr)
     => ( v132998(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26615,axiom,
    ! [VarCurr] :
      ( v133001(VarCurr)
    <=> ( v133003(VarCurr)
        & v133005(VarCurr) ) ) ).

fof(writeUnaryOperator_11020,axiom,
    ! [VarCurr] :
      ( ~ v133005(VarCurr)
    <=> v4209(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorShiftedRanges_3063,axiom,
    ! [VarCurr] :
      ( v133003(VarCurr)
    <=> ( v133004(VarCurr)
        & v4209(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3062,axiom,
    ! [VarCurr] :
      ( v133004(VarCurr)
    <=> ( v10060(VarCurr)
        & v4209(VarCurr,bitIndex4) ) ) ).

fof(addAssignment_43441,axiom,
    ! [VarCurr] :
      ( v10069(VarCurr)
    <=> v10071(VarCurr) ) ).

fof(addAssignment_43440,axiom,
    ! [VarCurr] :
      ( v10071(VarCurr)
    <=> v10073(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26614,axiom,
    ! [VarCurr] :
      ( v10073(VarCurr)
    <=> ( v132991(VarCurr)
        & v132992(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3061,axiom,
    ! [VarCurr] :
      ( v132992(VarCurr)
    <=> ( v10075(VarCurr,bitIndex5)
      <~> v132920(VarCurr,bitIndex5) ) ) ).

fof(addBitVectorEqualityBitBlasted_9302,axiom,
    ! [VarCurr] :
      ( v132991(VarCurr)
    <=> ( ( v10075(VarCurr,bitIndex4)
        <=> v132920(VarCurr,bitIndex4) )
        & ( v10075(VarCurr,bitIndex3)
        <=> v132920(VarCurr,bitIndex3) )
        & ( v10075(VarCurr,bitIndex2)
        <=> v132920(VarCurr,bitIndex2) )
        & ( v10075(VarCurr,bitIndex1)
        <=> v132920(VarCurr,bitIndex1) )
        & ( v10075(VarCurr,bitIndex0)
        <=> v132920(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_43439,axiom,
    ! [VarNext] :
      ( v132920(VarNext,bitIndex5)
    <=> v132983(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_2331,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132985(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v132983(VarNext,B)
            <=> v132920(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2455,axiom,
    ! [VarNext] :
      ( v132985(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v132983(VarNext,B)
          <=> v132948(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26613,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132985(VarNext)
      <=> ( v132986(VarNext)
          & v132942(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26612,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132986(VarNext)
      <=> ( v132988(VarNext)
          & v131318(VarNext) ) ) ) ).

fof(writeUnaryOperator_11019,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132988(VarNext)
      <=> v131325(VarNext) ) ) ).

fof(addAssignment_43438,axiom,
    ! [VarCurr] :
      ( v10075(VarCurr,bitIndex5)
    <=> v10077(VarCurr,bitIndex5) ) ).

fof(addAssignment_43437,axiom,
    ! [VarCurr] :
      ( v10077(VarCurr,bitIndex5)
    <=> v10079(VarCurr,bitIndex5) ) ).

fof(addAssignment_43436,axiom,
    ! [VarCurr] :
      ( v10079(VarCurr,bitIndex5)
    <=> v10081(VarCurr,bitIndex5) ) ).

fof(addAssignment_43435,axiom,
    ! [VarCurr] :
      ( v10081(VarCurr,bitIndex5)
    <=> v10083(VarCurr,bitIndex5) ) ).

fof(addAssignment_43434,axiom,
    ! [VarCurr] :
      ( v10083(VarCurr,bitIndex5)
    <=> v10085(VarCurr,bitIndex5) ) ).

fof(addAssignment_43433,axiom,
    ! [VarCurr] :
      ( v10085(VarCurr,bitIndex5)
    <=> v10087(VarCurr,bitIndex5) ) ).

fof(addAssignment_43432,axiom,
    ! [VarCurr] :
      ( v10087(VarCurr,bitIndex5)
    <=> v132918(VarCurr,bitIndex5) ) ).

fof(addAssignment_43431,axiom,
    ! [VarNext,B] :
      ( range_4_0(B)
     => ( v132920(VarNext,B)
      <=> v132933(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2330,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132934(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v132933(VarNext,B)
            <=> v132920(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2454,axiom,
    ! [VarNext] :
      ( v132934(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v132933(VarNext,B)
          <=> v132948(VarNext,B) ) ) ) ).

fof(addAssignment_43430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v132948(VarNext,B)
          <=> v132946(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5403,axiom,
    ! [VarCurr] :
      ( ~ v132943(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v132946(VarCurr,B)
          <=> v132949(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5392,axiom,
    ! [VarCurr] :
      ( v132943(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v132946(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43429,axiom,
    ! [VarCurr] :
      ( v132949(VarCurr,bitIndex0)
    <=> v132977(VarCurr) ) ).

fof(addAssignment_43428,axiom,
    ! [VarCurr] :
      ( v132949(VarCurr,bitIndex1)
    <=> v132975(VarCurr) ) ).

fof(addAssignment_43427,axiom,
    ! [VarCurr] :
      ( v132949(VarCurr,bitIndex2)
    <=> v132970(VarCurr) ) ).

fof(addAssignment_43426,axiom,
    ! [VarCurr] :
      ( v132949(VarCurr,bitIndex3)
    <=> v132965(VarCurr) ) ).

fof(addAssignment_43425,axiom,
    ! [VarCurr] :
      ( v132949(VarCurr,bitIndex4)
    <=> v132960(VarCurr) ) ).

fof(addAssignment_43424,axiom,
    ! [VarCurr] :
      ( v132949(VarCurr,bitIndex5)
    <=> v132951(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26611,axiom,
    ! [VarCurr] :
      ( v132975(VarCurr)
    <=> ( v132976(VarCurr)
        & v132979(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3060,axiom,
    ! [VarCurr] :
      ( v132979(VarCurr)
    <=> ( v132920(VarCurr,bitIndex0)
        | v132920(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26610,axiom,
    ! [VarCurr] :
      ( v132976(VarCurr)
    <=> ( v132977(VarCurr)
        | v132978(VarCurr) ) ) ).

fof(writeUnaryOperator_11018,axiom,
    ! [VarCurr] :
      ( ~ v132978(VarCurr)
    <=> v132920(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11017,axiom,
    ! [VarCurr] :
      ( ~ v132977(VarCurr)
    <=> v132920(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26609,axiom,
    ! [VarCurr] :
      ( v132970(VarCurr)
    <=> ( v132971(VarCurr)
        & v132974(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3059,axiom,
    ! [VarCurr] :
      ( v132974(VarCurr)
    <=> ( v132957(VarCurr)
        | v132920(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26608,axiom,
    ! [VarCurr] :
      ( v132971(VarCurr)
    <=> ( v132972(VarCurr)
        | v132973(VarCurr) ) ) ).

fof(writeUnaryOperator_11016,axiom,
    ! [VarCurr] :
      ( ~ v132973(VarCurr)
    <=> v132920(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11015,axiom,
    ! [VarCurr] :
      ( ~ v132972(VarCurr)
    <=> v132957(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26607,axiom,
    ! [VarCurr] :
      ( v132965(VarCurr)
    <=> ( v132966(VarCurr)
        & v132969(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3058,axiom,
    ! [VarCurr] :
      ( v132969(VarCurr)
    <=> ( v132956(VarCurr)
        | v132920(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26606,axiom,
    ! [VarCurr] :
      ( v132966(VarCurr)
    <=> ( v132967(VarCurr)
        | v132968(VarCurr) ) ) ).

fof(writeUnaryOperator_11014,axiom,
    ! [VarCurr] :
      ( ~ v132968(VarCurr)
    <=> v132920(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11013,axiom,
    ! [VarCurr] :
      ( ~ v132967(VarCurr)
    <=> v132956(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26605,axiom,
    ! [VarCurr] :
      ( v132960(VarCurr)
    <=> ( v132961(VarCurr)
        & v132964(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3057,axiom,
    ! [VarCurr] :
      ( v132964(VarCurr)
    <=> ( v132955(VarCurr)
        | v132920(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26604,axiom,
    ! [VarCurr] :
      ( v132961(VarCurr)
    <=> ( v132962(VarCurr)
        | v132963(VarCurr) ) ) ).

fof(writeUnaryOperator_11012,axiom,
    ! [VarCurr] :
      ( ~ v132963(VarCurr)
    <=> v132920(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11011,axiom,
    ! [VarCurr] :
      ( ~ v132962(VarCurr)
    <=> v132955(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26603,axiom,
    ! [VarCurr] :
      ( v132951(VarCurr)
    <=> ( v132952(VarCurr)
        & v132959(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3056,axiom,
    ! [VarCurr] :
      ( v132959(VarCurr)
    <=> ( v132954(VarCurr)
        | v132920(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26602,axiom,
    ! [VarCurr] :
      ( v132952(VarCurr)
    <=> ( v132953(VarCurr)
        | v132958(VarCurr) ) ) ).

fof(writeUnaryOperator_11010,axiom,
    ! [VarCurr] :
      ( ~ v132958(VarCurr)
    <=> v132920(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_11009,axiom,
    ! [VarCurr] :
      ( ~ v132953(VarCurr)
    <=> v132954(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3055,axiom,
    ! [VarCurr] :
      ( v132954(VarCurr)
    <=> ( v132955(VarCurr)
        & v132920(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3054,axiom,
    ! [VarCurr] :
      ( v132955(VarCurr)
    <=> ( v132956(VarCurr)
        & v132920(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3053,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr)
    <=> ( v132957(VarCurr)
        & v132920(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3052,axiom,
    ! [VarCurr] :
      ( v132957(VarCurr)
    <=> ( v132920(VarCurr,bitIndex0)
        & v132920(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26601,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132934(VarNext)
      <=> ( v132935(VarNext)
          & v132942(VarNext) ) ) ) ).

fof(addAssignment_43423,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132942(VarNext)
      <=> v132940(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26600,axiom,
    ! [VarCurr] :
      ( v132940(VarCurr)
    <=> ( v132943(VarCurr)
        | v132944(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26599,axiom,
    ! [VarCurr] :
      ( v132944(VarCurr)
    <=> ( v132922(VarCurr)
        & v132945(VarCurr) ) ) ).

fof(writeUnaryOperator_11008,axiom,
    ! [VarCurr] :
      ( ~ v132945(VarCurr)
    <=> v132943(VarCurr) ) ).

fof(writeUnaryOperator_11007,axiom,
    ! [VarCurr] :
      ( ~ v132943(VarCurr)
    <=> v15398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26598,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132935(VarNext)
      <=> ( v132936(VarNext)
          & v131318(VarNext) ) ) ) ).

fof(writeUnaryOperator_11006,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132936(VarNext)
      <=> v131325(VarNext) ) ) ).

fof(addAssignment_43422,axiom,
    ! [VarCurr] :
      ( v132922(VarCurr)
    <=> v132924(VarCurr) ) ).

fof(addAssignment_43421,axiom,
    ! [VarCurr] :
      ( v132924(VarCurr)
    <=> v132926(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26597,axiom,
    ! [VarCurr] :
      ( v132926(VarCurr)
    <=> ( v132931(VarCurr)
        & v132928(VarCurr) ) ) ).

fof(writeUnaryOperator_11005,axiom,
    ! [VarCurr] :
      ( ~ v132931(VarCurr)
    <=> v15406(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9301,axiom,
    ! [VarCurr] :
      ( v132928(VarCurr)
    <=> ( ( v129436(VarCurr,bitIndex1)
        <=> $false )
        & ( v129436(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43420,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10075(VarCurr,B)
      <=> v10077(VarCurr,B) ) ) ).

fof(addAssignment_43419,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10077(VarCurr,B)
      <=> v10079(VarCurr,B) ) ) ).

fof(addAssignment_43418,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10079(VarCurr,B)
      <=> v10081(VarCurr,B) ) ) ).

fof(addAssignment_43417,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10081(VarCurr,B)
      <=> v10083(VarCurr,B) ) ) ).

fof(addAssignment_43416,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10083(VarCurr,B)
      <=> v10085(VarCurr,B) ) ) ).

fof(addAssignment_43415,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10085(VarCurr,B)
      <=> v10087(VarCurr,B) ) ) ).

fof(addAssignment_43414,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10087(VarCurr,B)
      <=> v132918(VarCurr,B) ) ) ).

fof(addAssignment_43413,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v132918(VarCurr,B)
      <=> v10089(VarCurr,B) ) ) ).

fof(addAssignment_43412,axiom,
    ! [VarCurr] :
      ( v132918(VarCurr,bitIndex5)
    <=> v15325(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132877(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v10089(VarNext,B)
            <=> v10089(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2453,axiom,
    ! [VarNext] :
      ( v132877(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v10089(VarNext,B)
          <=> v132890(VarNext,B) ) ) ) ).

fof(addAssignment_43411,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132890(VarNext,B)
          <=> v132888(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5402,axiom,
    ! [VarCurr] :
      ( ~ v15341(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132888(VarCurr,B)
          <=> v132891(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5391,axiom,
    ! [VarCurr] :
      ( v15341(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132888(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43410,axiom,
    ! [VarCurr] :
      ( v132891(VarCurr,bitIndex0)
    <=> v132913(VarCurr) ) ).

fof(addAssignment_43409,axiom,
    ! [VarCurr] :
      ( v132891(VarCurr,bitIndex1)
    <=> v132911(VarCurr) ) ).

fof(addAssignment_43408,axiom,
    ! [VarCurr] :
      ( v132891(VarCurr,bitIndex2)
    <=> v132906(VarCurr) ) ).

fof(addAssignment_43407,axiom,
    ! [VarCurr] :
      ( v132891(VarCurr,bitIndex3)
    <=> v132901(VarCurr) ) ).

fof(addAssignment_43406,axiom,
    ! [VarCurr] :
      ( v132891(VarCurr,bitIndex4)
    <=> v132893(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26596,axiom,
    ! [VarCurr] :
      ( v132911(VarCurr)
    <=> ( v132912(VarCurr)
        & v132915(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3051,axiom,
    ! [VarCurr] :
      ( v132915(VarCurr)
    <=> ( v10089(VarCurr,bitIndex0)
        | v10089(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26595,axiom,
    ! [VarCurr] :
      ( v132912(VarCurr)
    <=> ( v132913(VarCurr)
        | v132914(VarCurr) ) ) ).

fof(writeUnaryOperator_11004,axiom,
    ! [VarCurr] :
      ( ~ v132914(VarCurr)
    <=> v10089(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11003,axiom,
    ! [VarCurr] :
      ( ~ v132913(VarCurr)
    <=> v10089(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26594,axiom,
    ! [VarCurr] :
      ( v132906(VarCurr)
    <=> ( v132907(VarCurr)
        & v132910(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3050,axiom,
    ! [VarCurr] :
      ( v132910(VarCurr)
    <=> ( v132898(VarCurr)
        | v10089(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26593,axiom,
    ! [VarCurr] :
      ( v132907(VarCurr)
    <=> ( v132908(VarCurr)
        | v132909(VarCurr) ) ) ).

fof(writeUnaryOperator_11002,axiom,
    ! [VarCurr] :
      ( ~ v132909(VarCurr)
    <=> v10089(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11001,axiom,
    ! [VarCurr] :
      ( ~ v132908(VarCurr)
    <=> v132898(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26592,axiom,
    ! [VarCurr] :
      ( v132901(VarCurr)
    <=> ( v132902(VarCurr)
        & v132905(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3049,axiom,
    ! [VarCurr] :
      ( v132905(VarCurr)
    <=> ( v132897(VarCurr)
        | v10089(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26591,axiom,
    ! [VarCurr] :
      ( v132902(VarCurr)
    <=> ( v132903(VarCurr)
        | v132904(VarCurr) ) ) ).

fof(writeUnaryOperator_11000,axiom,
    ! [VarCurr] :
      ( ~ v132904(VarCurr)
    <=> v10089(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10999,axiom,
    ! [VarCurr] :
      ( ~ v132903(VarCurr)
    <=> v132897(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26590,axiom,
    ! [VarCurr] :
      ( v132893(VarCurr)
    <=> ( v132894(VarCurr)
        & v132900(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3048,axiom,
    ! [VarCurr] :
      ( v132900(VarCurr)
    <=> ( v132896(VarCurr)
        | v10089(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26589,axiom,
    ! [VarCurr] :
      ( v132894(VarCurr)
    <=> ( v132895(VarCurr)
        | v132899(VarCurr) ) ) ).

fof(writeUnaryOperator_10998,axiom,
    ! [VarCurr] :
      ( ~ v132899(VarCurr)
    <=> v10089(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10997,axiom,
    ! [VarCurr] :
      ( ~ v132895(VarCurr)
    <=> v132896(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3047,axiom,
    ! [VarCurr] :
      ( v132896(VarCurr)
    <=> ( v132897(VarCurr)
        & v10089(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3046,axiom,
    ! [VarCurr] :
      ( v132897(VarCurr)
    <=> ( v132898(VarCurr)
        & v10089(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3045,axiom,
    ! [VarCurr] :
      ( v132898(VarCurr)
    <=> ( v10089(VarCurr,bitIndex0)
        & v10089(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26588,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132877(VarNext)
      <=> ( v132878(VarNext)
          & v132885(VarNext) ) ) ) ).

fof(addAssignment_43405,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132885(VarNext)
      <=> v132883(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26587,axiom,
    ! [VarCurr] :
      ( v132883(VarCurr)
    <=> ( v15341(VarCurr)
        | v132886(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26586,axiom,
    ! [VarCurr] :
      ( v132886(VarCurr)
    <=> ( v10097(VarCurr)
        & v132887(VarCurr) ) ) ).

fof(writeUnaryOperator_10996,axiom,
    ! [VarCurr] :
      ( ~ v132887(VarCurr)
    <=> v15341(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26585,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132878(VarNext)
      <=> ( v132880(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_10995,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132880(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(addAssignment_43404,axiom,
    ! [VarCurr] :
      ( v10097(VarCurr)
    <=> v10099(VarCurr) ) ).

fof(addAssignment_43403,axiom,
    ! [VarCurr] :
      ( v10099(VarCurr)
    <=> v10101(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3044,axiom,
    ! [VarCurr] :
      ( v10101(VarCurr)
    <=> ( v10103(VarCurr,bitIndex3)
        | v132867(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26584,axiom,
    ! [VarCurr] :
      ( v132867(VarCurr)
    <=> ( v132871(VarCurr)
        & v132869(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26583,axiom,
    ! [VarCurr] :
      ( v132871(VarCurr)
    <=> ( v132872(VarCurr)
        & v132873(VarCurr) ) ) ).

fof(writeUnaryOperator_10994,axiom,
    ! [VarCurr] :
      ( ~ v132873(VarCurr)
    <=> v132639(VarCurr) ) ).

fof(writeUnaryOperator_10993,axiom,
    ! [VarCurr] :
      ( ~ v132872(VarCurr)
    <=> v15300(VarCurr) ) ).

fof(addAssignment_43402,axiom,
    ! [VarCurr] :
      ( v132869(VarCurr)
    <=> v132670(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_585,axiom,
    ! [VarCurr] :
      ( ~ v132861(VarCurr)
     => ( v10103(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_780,axiom,
    ! [VarCurr] :
      ( v132861(VarCurr)
     => ( v10103(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26582,axiom,
    ! [VarCurr] :
      ( v132861(VarCurr)
    <=> ( v132862(VarCurr)
        | v132864(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26581,axiom,
    ! [VarCurr] :
      ( v132864(VarCurr)
    <=> ( v132865(VarCurr)
        & v132851(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26580,axiom,
    ! [VarCurr] :
      ( v132865(VarCurr)
    <=> ( v10105(VarCurr)
        & v131415(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26579,axiom,
    ! [VarCurr] :
      ( v132862(VarCurr)
    <=> ( v132863(VarCurr)
        & v132846(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26578,axiom,
    ! [VarCurr] :
      ( v132863(VarCurr)
    <=> ( v10105(VarCurr)
        & v131415(VarCurr) ) ) ).

fof(addAssignment_43401,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex4)
    <=> v132853(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionShiftedRanges1_139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132854(VarNext)
       => ( ( v132853(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v132853(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v132853(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v132853(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v132853(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v132853(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v132853(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v132853(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v132853(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v132853(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v132853(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v132853(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v132853(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v132853(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v132853(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v132853(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v132853(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v132853(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v132853(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v132853(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2452,axiom,
    ! [VarNext] :
      ( v132854(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v132853(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132854(VarNext)
      <=> v132855(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26576,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132855(VarNext)
      <=> ( v132857(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10992,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132857(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_584,axiom,
    ! [VarCurr] :
      ( ~ v132841(VarCurr)
     => ( v10103(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_779,axiom,
    ! [VarCurr] :
      ( v132841(VarCurr)
     => ( v10103(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26575,axiom,
    ! [VarCurr] :
      ( v132841(VarCurr)
    <=> ( v132842(VarCurr)
        | v132847(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26574,axiom,
    ! [VarCurr] :
      ( v132847(VarCurr)
    <=> ( v132848(VarCurr)
        & v132851(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9300,axiom,
    ! [VarCurr] :
      ( v132851(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26573,axiom,
    ! [VarCurr] :
      ( v132848(VarCurr)
    <=> ( v132849(VarCurr)
        | v132850(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26572,axiom,
    ! [VarCurr] :
      ( v132850(VarCurr)
    <=> ( v10105(VarCurr)
        & v131456(VarCurr) ) ) ).

fof(writeUnaryOperator_10991,axiom,
    ! [VarCurr] :
      ( ~ v132849(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26571,axiom,
    ! [VarCurr] :
      ( v132842(VarCurr)
    <=> ( v132843(VarCurr)
        & v132846(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9299,axiom,
    ! [VarCurr] :
      ( v132846(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26570,axiom,
    ! [VarCurr] :
      ( v132843(VarCurr)
    <=> ( v132844(VarCurr)
        | v132845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26569,axiom,
    ! [VarCurr] :
      ( v132845(VarCurr)
    <=> ( v10105(VarCurr)
        & v131456(VarCurr) ) ) ).

fof(writeUnaryOperator_10990,axiom,
    ! [VarCurr] :
      ( ~ v132844(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(addAssignment_43400,axiom,
    ! [VarCurr] :
      ( v10105(VarCurr)
    <=> v10107(VarCurr) ) ).

fof(addAssignment_43399,axiom,
    ! [VarCurr] :
      ( v10107(VarCurr)
    <=> v10109(VarCurr) ) ).

fof(addAssignment_43398,axiom,
    ! [VarCurr] :
      ( v10109(VarCurr)
    <=> v10111(VarCurr,bitIndex1) ) ).

fof(addAssignment_43397,axiom,
    ! [VarCurr] :
      ( v10111(VarCurr,bitIndex1)
    <=> v114173(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorShiftedRanges_3043,axiom,
    ! [VarCurr] :
      ( v114172(VarCurr,bitIndex1)
    <=> ( v114172(VarCurr,bitIndex0)
        | v10113(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43396,axiom,
    ! [VarCurr] :
      ( v10113(VarCurr,bitIndex1)
    <=> v114170(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26568,axiom,
    ! [VarCurr] :
      ( v10115(VarCurr)
    <=> ( v132835(VarCurr)
        & v132838(VarCurr) ) ) ).

fof(writeUnaryOperator_10989,axiom,
    ! [VarCurr] :
      ( ~ v132838(VarCurr)
    <=> v132830(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26567,axiom,
    ! [VarCurr] :
      ( v132835(VarCurr)
    <=> ( v132836(VarCurr)
        & v132837(VarCurr) ) ) ).

fof(writeUnaryOperator_10988,axiom,
    ! [VarCurr] :
      ( ~ v132837(VarCurr)
    <=> v114159(VarCurr) ) ).

fof(writeUnaryOperator_10987,axiom,
    ! [VarCurr] :
      ( ~ v132836(VarCurr)
    <=> v10117(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26566,axiom,
    ! [VarCurr] :
      ( v132830(VarCurr)
    <=> ( v132832(VarCurr)
        | v132704(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26565,axiom,
    ! [VarCurr] :
      ( v132832(VarCurr)
    <=> ( v114176(VarCurr)
        & v132833(VarCurr) ) ) ).

fof(writeUnaryOperator_10986,axiom,
    ! [VarCurr] :
      ( ~ v132833(VarCurr)
    <=> v114308(VarCurr) ) ).

fof(addAssignment_43395,axiom,
    ! [VarCurr] :
      ( v10117(VarCurr)
    <=> v10119(VarCurr) ) ).

fof(addAssignment_43394,axiom,
    ! [VarCurr] :
      ( v10119(VarCurr)
    <=> v10121(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9298,axiom,
    ! [VarCurr] :
      ( v10121(VarCurr)
    <=> ( ( v10123(VarCurr,bitIndex4)
        <=> $false )
        & ( v10123(VarCurr,bitIndex3)
        <=> $false )
        & ( v10123(VarCurr,bitIndex2)
        <=> $false )
        & ( v10123(VarCurr,bitIndex1)
        <=> $false )
        & ( v10123(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2328,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132816(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v10123(VarNext,B)
            <=> v10123(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2451,axiom,
    ! [VarNext] :
      ( v132816(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v10123(VarNext,B)
          <=> v132824(VarNext,B) ) ) ) ).

fof(addAssignment_43393,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132824(VarNext,B)
          <=> v132822(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3181,axiom,
    ! [VarCurr] :
      ( ~ v132825(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132822(VarCurr,B)
          <=> v10127(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2986,axiom,
    ! [VarCurr] :
      ( v132825(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132822(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_10985,axiom,
    ! [VarCurr] :
      ( ~ v132825(VarCurr)
    <=> v10125(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26564,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132816(VarNext)
      <=> v132817(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26563,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132817(VarNext)
      <=> ( v132818(VarNext)
          & v13226(VarNext) ) ) ) ).

fof(writeUnaryOperator_10984,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132818(VarNext)
      <=> v15200(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_185,axiom,
    ! [VarCurr] :
      ( ( ~ v132740(VarCurr)
        & ~ v132742(VarCurr)
        & ~ v132783(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v10127(VarCurr,B)
          <=> v10123(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1316,axiom,
    ! [VarCurr] :
      ( v132783(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v10127(VarCurr,B)
          <=> v132785(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5401,axiom,
    ! [VarCurr] :
      ( v132742(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v10127(VarCurr,B)
          <=> v132744(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5390,axiom,
    ! [VarCurr] :
      ( v132740(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v10127(VarCurr,B)
          <=> v10123(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9297,axiom,
    ! [VarCurr] :
      ( v132812(VarCurr)
    <=> ( ( v132813(VarCurr,bitIndex1)
        <=> $true )
        & ( v132813(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43392,axiom,
    ! [VarCurr] :
      ( v132813(VarCurr,bitIndex0)
    <=> v11293(VarCurr) ) ).

fof(addAssignment_43391,axiom,
    ! [VarCurr] :
      ( v132813(VarCurr,bitIndex1)
    <=> v10129(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3180,axiom,
    ! [VarCurr] :
      ( ~ v132786(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132785(VarCurr,B)
          <=> v132787(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2985,axiom,
    ! [VarCurr] :
      ( v132786(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132785(VarCurr,B)
          <=> b01010(B) ) ) ) ).

fof(addAssignment_43390,axiom,
    ! [VarCurr] :
      ( v132787(VarCurr,bitIndex0)
    <=> v132809(VarCurr) ) ).

fof(addAssignment_43389,axiom,
    ! [VarCurr] :
      ( v132787(VarCurr,bitIndex1)
    <=> v132807(VarCurr) ) ).

fof(addAssignment_43388,axiom,
    ! [VarCurr] :
      ( v132787(VarCurr,bitIndex2)
    <=> v132802(VarCurr) ) ).

fof(addAssignment_43387,axiom,
    ! [VarCurr] :
      ( v132787(VarCurr,bitIndex3)
    <=> v132797(VarCurr) ) ).

fof(addAssignment_43386,axiom,
    ! [VarCurr] :
      ( v132787(VarCurr,bitIndex4)
    <=> v132789(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26562,axiom,
    ! [VarCurr] :
      ( v132807(VarCurr)
    <=> ( v132808(VarCurr)
        & v132811(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3042,axiom,
    ! [VarCurr] :
      ( v132811(VarCurr)
    <=> ( v10123(VarCurr,bitIndex0)
        | v10123(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26561,axiom,
    ! [VarCurr] :
      ( v132808(VarCurr)
    <=> ( v132809(VarCurr)
        | v132810(VarCurr) ) ) ).

fof(writeUnaryOperator_10983,axiom,
    ! [VarCurr] :
      ( ~ v132810(VarCurr)
    <=> v10123(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10982,axiom,
    ! [VarCurr] :
      ( ~ v132809(VarCurr)
    <=> v10123(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26560,axiom,
    ! [VarCurr] :
      ( v132802(VarCurr)
    <=> ( v132803(VarCurr)
        & v132806(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3041,axiom,
    ! [VarCurr] :
      ( v132806(VarCurr)
    <=> ( v132794(VarCurr)
        | v10123(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26559,axiom,
    ! [VarCurr] :
      ( v132803(VarCurr)
    <=> ( v132804(VarCurr)
        | v132805(VarCurr) ) ) ).

fof(writeUnaryOperator_10981,axiom,
    ! [VarCurr] :
      ( ~ v132805(VarCurr)
    <=> v10123(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10980,axiom,
    ! [VarCurr] :
      ( ~ v132804(VarCurr)
    <=> v132794(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26558,axiom,
    ! [VarCurr] :
      ( v132797(VarCurr)
    <=> ( v132798(VarCurr)
        & v132801(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3040,axiom,
    ! [VarCurr] :
      ( v132801(VarCurr)
    <=> ( v132793(VarCurr)
        | v10123(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26557,axiom,
    ! [VarCurr] :
      ( v132798(VarCurr)
    <=> ( v132799(VarCurr)
        | v132800(VarCurr) ) ) ).

fof(writeUnaryOperator_10979,axiom,
    ! [VarCurr] :
      ( ~ v132800(VarCurr)
    <=> v10123(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10978,axiom,
    ! [VarCurr] :
      ( ~ v132799(VarCurr)
    <=> v132793(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26556,axiom,
    ! [VarCurr] :
      ( v132789(VarCurr)
    <=> ( v132790(VarCurr)
        & v132796(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3039,axiom,
    ! [VarCurr] :
      ( v132796(VarCurr)
    <=> ( v132792(VarCurr)
        | v10123(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26555,axiom,
    ! [VarCurr] :
      ( v132790(VarCurr)
    <=> ( v132791(VarCurr)
        | v132795(VarCurr) ) ) ).

fof(writeUnaryOperator_10977,axiom,
    ! [VarCurr] :
      ( ~ v132795(VarCurr)
    <=> v10123(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10976,axiom,
    ! [VarCurr] :
      ( ~ v132791(VarCurr)
    <=> v132792(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3038,axiom,
    ! [VarCurr] :
      ( v132792(VarCurr)
    <=> ( v132793(VarCurr)
        & v10123(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3037,axiom,
    ! [VarCurr] :
      ( v132793(VarCurr)
    <=> ( v132794(VarCurr)
        & v10123(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3036,axiom,
    ! [VarCurr] :
      ( v132794(VarCurr)
    <=> ( v10123(VarCurr,bitIndex0)
        & v10123(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9296,axiom,
    ! [VarCurr] :
      ( v132786(VarCurr)
    <=> ( ( v10123(VarCurr,bitIndex4)
        <=> $false )
        & ( v10123(VarCurr,bitIndex3)
        <=> $true )
        & ( v10123(VarCurr,bitIndex2)
        <=> $false )
        & ( v10123(VarCurr,bitIndex1)
        <=> $true )
        & ( v10123(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9295,axiom,
    ! [VarCurr] :
      ( v132783(VarCurr)
    <=> ( ( v132784(VarCurr,bitIndex1)
        <=> $true )
        & ( v132784(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43385,axiom,
    ! [VarCurr] :
      ( v132784(VarCurr,bitIndex0)
    <=> v11293(VarCurr) ) ).

fof(addAssignment_43384,axiom,
    ! [VarCurr] :
      ( v132784(VarCurr,bitIndex1)
    <=> v10129(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3179,axiom,
    ! [VarCurr] :
      ( ~ v132745(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132744(VarCurr,B)
          <=> v132746(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2984,axiom,
    ! [VarCurr] :
      ( v132745(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132744(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_159,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex6)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_158,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex7)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_157,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex8)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_156,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex9)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_155,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex10)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_154,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex11)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_153,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex12)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_152,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex13)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_151,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex14)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_150,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex15)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_149,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex16)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_148,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex17)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_147,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex18)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_146,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex19)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_145,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex20)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_144,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex21)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_143,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex22)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_142,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex23)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_141,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex24)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_140,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex25)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_139,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex26)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_138,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex27)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_137,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex28)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_136,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex29)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_135,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex30)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_134,axiom,
    ! [VarCurr] :
      ( v132746(VarCurr,bitIndex31)
    <=> v132747(VarCurr,bitIndex5) ) ).

fof(addAssignment_43383,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v132746(VarCurr,B)
      <=> v132747(VarCurr,B) ) ) ).

fof(addAssignment_43382,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr,bitIndex0)
    <=> v132781(VarCurr) ) ).

fof(addAssignment_43381,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr,bitIndex1)
    <=> v132779(VarCurr) ) ).

fof(addAssignment_43380,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr,bitIndex2)
    <=> v132775(VarCurr) ) ).

fof(addAssignment_43379,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr,bitIndex3)
    <=> v132771(VarCurr) ) ).

fof(addAssignment_43378,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr,bitIndex4)
    <=> v132767(VarCurr) ) ).

fof(addAssignment_43377,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr,bitIndex5)
    <=> v132749(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26554,axiom,
    ! [VarCurr] :
      ( v132779(VarCurr)
    <=> ( v132780(VarCurr)
        & v132782(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26553,axiom,
    ! [VarCurr] :
      ( v132782(VarCurr)
    <=> ( v132753(VarCurr,bitIndex0)
        | v132761(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3035,axiom,
    ! [VarCurr] :
      ( v132780(VarCurr)
    <=> ( v132781(VarCurr)
        | v132753(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_10975,axiom,
    ! [VarCurr] :
      ( ~ v132781(VarCurr)
    <=> v132753(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26552,axiom,
    ! [VarCurr] :
      ( v132775(VarCurr)
    <=> ( v132776(VarCurr)
        & v132778(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26551,axiom,
    ! [VarCurr] :
      ( v132778(VarCurr)
    <=> ( v132759(VarCurr)
        | v132762(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3034,axiom,
    ! [VarCurr] :
      ( v132776(VarCurr)
    <=> ( v132777(VarCurr)
        | v132753(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10974,axiom,
    ! [VarCurr] :
      ( ~ v132777(VarCurr)
    <=> v132759(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26550,axiom,
    ! [VarCurr] :
      ( v132771(VarCurr)
    <=> ( v132772(VarCurr)
        & v132774(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26549,axiom,
    ! [VarCurr] :
      ( v132774(VarCurr)
    <=> ( v132757(VarCurr)
        | v132763(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3033,axiom,
    ! [VarCurr] :
      ( v132772(VarCurr)
    <=> ( v132773(VarCurr)
        | v132753(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_10973,axiom,
    ! [VarCurr] :
      ( ~ v132773(VarCurr)
    <=> v132757(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26548,axiom,
    ! [VarCurr] :
      ( v132767(VarCurr)
    <=> ( v132768(VarCurr)
        & v132770(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26547,axiom,
    ! [VarCurr] :
      ( v132770(VarCurr)
    <=> ( v132755(VarCurr)
        | v132764(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3032,axiom,
    ! [VarCurr] :
      ( v132768(VarCurr)
    <=> ( v132769(VarCurr)
        | v132753(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_10972,axiom,
    ! [VarCurr] :
      ( ~ v132769(VarCurr)
    <=> v132755(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26546,axiom,
    ! [VarCurr] :
      ( v132749(VarCurr)
    <=> ( v132750(VarCurr)
        & v132765(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26545,axiom,
    ! [VarCurr] :
      ( v132765(VarCurr)
    <=> ( v132752(VarCurr)
        | v132766(VarCurr) ) ) ).

fof(writeUnaryOperator_10971,axiom,
    ! [VarCurr] :
      ( ~ v132766(VarCurr)
    <=> v132753(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_3031,axiom,
    ! [VarCurr] :
      ( v132750(VarCurr)
    <=> ( v132751(VarCurr)
        | v132753(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_10970,axiom,
    ! [VarCurr] :
      ( ~ v132751(VarCurr)
    <=> v132752(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3030,axiom,
    ! [VarCurr] :
      ( v132752(VarCurr)
    <=> ( v132753(VarCurr,bitIndex4)
        | v132754(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26544,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr)
    <=> ( v132755(VarCurr)
        & v132764(VarCurr) ) ) ).

fof(writeUnaryOperator_10969,axiom,
    ! [VarCurr] :
      ( ~ v132764(VarCurr)
    <=> v132753(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3029,axiom,
    ! [VarCurr] :
      ( v132755(VarCurr)
    <=> ( v132753(VarCurr,bitIndex3)
        | v132756(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26543,axiom,
    ! [VarCurr] :
      ( v132756(VarCurr)
    <=> ( v132757(VarCurr)
        & v132763(VarCurr) ) ) ).

fof(writeUnaryOperator_10968,axiom,
    ! [VarCurr] :
      ( ~ v132763(VarCurr)
    <=> v132753(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_3028,axiom,
    ! [VarCurr] :
      ( v132757(VarCurr)
    <=> ( v132753(VarCurr,bitIndex2)
        | v132758(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26542,axiom,
    ! [VarCurr] :
      ( v132758(VarCurr)
    <=> ( v132759(VarCurr)
        & v132762(VarCurr) ) ) ).

fof(writeUnaryOperator_10967,axiom,
    ! [VarCurr] :
      ( ~ v132762(VarCurr)
    <=> v132753(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3027,axiom,
    ! [VarCurr] :
      ( v132759(VarCurr)
    <=> ( v132753(VarCurr,bitIndex1)
        | v132760(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26541,axiom,
    ! [VarCurr] :
      ( v132760(VarCurr)
    <=> ( v132753(VarCurr,bitIndex0)
        & v132761(VarCurr) ) ) ).

fof(writeUnaryOperator_10966,axiom,
    ! [VarCurr] :
      ( ~ v132761(VarCurr)
    <=> v132753(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_12,axiom,
    ! [VarCurr] : ~ v132753(VarCurr,bitIndex5) ).

fof(addAssignment_43376,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v132753(VarCurr,B)
      <=> v10123(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_9294,axiom,
    ! [VarCurr] :
      ( v132745(VarCurr)
    <=> ( ( v10123(VarCurr,bitIndex4)
        <=> $false )
        & ( v10123(VarCurr,bitIndex3)
        <=> $false )
        & ( v10123(VarCurr,bitIndex2)
        <=> $false )
        & ( v10123(VarCurr,bitIndex1)
        <=> $false )
        & ( v10123(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9293,axiom,
    ! [VarCurr] :
      ( v132742(VarCurr)
    <=> ( ( v132743(VarCurr,bitIndex1)
        <=> $false )
        & ( v132743(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43375,axiom,
    ! [VarCurr] :
      ( v132743(VarCurr,bitIndex0)
    <=> v11293(VarCurr) ) ).

fof(addAssignment_43374,axiom,
    ! [VarCurr] :
      ( v132743(VarCurr,bitIndex1)
    <=> v10129(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9292,axiom,
    ! [VarCurr] :
      ( v132740(VarCurr)
    <=> ( ( v132741(VarCurr,bitIndex1)
        <=> $false )
        & ( v132741(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43373,axiom,
    ! [VarCurr] :
      ( v132741(VarCurr,bitIndex0)
    <=> v11293(VarCurr) ) ).

fof(addAssignment_43372,axiom,
    ! [VarCurr] :
      ( v132741(VarCurr,bitIndex1)
    <=> v10129(VarCurr) ) ).

fof(addAssignment_43371,axiom,
    ! [VarCurr] :
      ( v11293(VarCurr)
    <=> v11295(VarCurr) ) ).

fof(addAssignment_43370,axiom,
    ! [VarCurr] :
      ( v11295(VarCurr)
    <=> v11297(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26540,axiom,
    ! [VarCurr] :
      ( v11297(VarCurr)
    <=> ( v132733(VarCurr)
        | v132704(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26539,axiom,
    ! [VarCurr] :
      ( v132733(VarCurr)
    <=> ( v132734(VarCurr)
        | v132633(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3026,axiom,
    ! [VarCurr] :
      ( v132734(VarCurr)
    <=> ( v132735(VarCurr)
        | v11299(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26538,axiom,
    ! [VarCurr] :
      ( v132735(VarCurr)
    <=> ( v132736(VarCurr)
        | v131859(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26537,axiom,
    ! [VarCurr] :
      ( v132736(VarCurr)
    <=> ( v132737(VarCurr)
        | v132521(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3025,axiom,
    ! [VarCurr] :
      ( v132737(VarCurr)
    <=> ( v132738(VarCurr)
        | v11299(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3024,axiom,
    ! [VarCurr] :
      ( v132738(VarCurr)
    <=> ( v11299(VarCurr,bitIndex3)
        | v11299(VarCurr,bitIndex6) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132720(VarNext)
       => ( v132704(VarNext)
        <=> v132704(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2450,axiom,
    ! [VarNext] :
      ( v132720(VarNext)
     => ( v132704(VarNext)
      <=> v132728(VarNext) ) ) ).

fof(addAssignment_43369,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132728(VarNext)
      <=> v132726(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3178,axiom,
    ! [VarCurr] :
      ( ~ v132729(VarCurr)
     => ( v132726(VarCurr)
      <=> v132706(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2983,axiom,
    ! [VarCurr] :
      ( v132729(VarCurr)
     => ( v132726(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_10965,axiom,
    ! [VarCurr] :
      ( ~ v132729(VarCurr)
    <=> v13205(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132720(VarNext)
      <=> v132721(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26535,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132721(VarNext)
      <=> ( v132722(VarNext)
          & v114242(VarNext) ) ) ) ).

fof(writeUnaryOperator_10964,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132722(VarNext)
      <=> v114249(VarNext) ) ) ).

fof(addAssignmentInitValueVector_41,axiom,
    ( v132704(constB0)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26534,axiom,
    ! [VarCurr] :
      ( v132706(VarCurr)
    <=> ( v132716(VarCurr)
        & v132717(VarCurr) ) ) ).

fof(writeUnaryOperator_10963,axiom,
    ! [VarCurr] :
      ( ~ v132717(VarCurr)
    <=> v114176(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26533,axiom,
    ! [VarCurr] :
      ( v132716(VarCurr)
    <=> ( v10109(VarCurr)
        & v132708(VarCurr) ) ) ).

fof(addAssignment_43368,axiom,
    ! [VarCurr] :
      ( v132708(VarCurr)
    <=> v132710(VarCurr) ) ).

fof(addAssignment_43367,axiom,
    ! [VarCurr] :
      ( v132710(VarCurr)
    <=> v132712(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3177,axiom,
    ! [VarCurr] :
      ( ~ v132714(VarCurr)
     => ( v132712(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2982,axiom,
    ! [VarCurr] :
      ( v132714(VarCurr)
     => ( v132712(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9291,axiom,
    ! [VarCurr] :
      ( v132714(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $false )
        & ( v15274(VarCurr,bitIndex5)
        <=> $false )
        & ( v15274(VarCurr,bitIndex4)
        <=> $false )
        & ( v15274(VarCurr,bitIndex3)
        <=> $true )
        & ( v15274(VarCurr,bitIndex2)
        <=> $false )
        & ( v15274(VarCurr,bitIndex1)
        <=> $true )
        & ( v15274(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26532,axiom,
    ! [VarCurr] :
      ( v132633(VarCurr)
    <=> ( v132696(VarCurr)
        & v132697(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26531,axiom,
    ! [VarCurr] :
      ( v132697(VarCurr)
    <=> ( v132698(VarCurr)
        | v132700(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26530,axiom,
    ! [VarCurr] :
      ( v132700(VarCurr)
    <=> ( v132701(VarCurr)
        & v132702(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26529,axiom,
    ! [VarCurr] :
      ( v132702(VarCurr)
    <=> ( v132681(VarCurr)
        | v132688(VarCurr) ) ) ).

fof(writeUnaryOperator_10962,axiom,
    ! [VarCurr] :
      ( ~ v132701(VarCurr)
    <=> v132675(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26528,axiom,
    ! [VarCurr] :
      ( v132698(VarCurr)
    <=> ( v132699(VarCurr)
        & v132668(VarCurr) ) ) ).

fof(writeUnaryOperator_10961,axiom,
    ! [VarCurr] :
      ( ~ v132699(VarCurr)
    <=> v132635(VarCurr) ) ).

fof(writeUnaryOperator_10960,axiom,
    ! [VarCurr] :
      ( ~ v132696(VarCurr)
    <=> v10117(VarCurr) ) ).

fof(addAssignment_43366,axiom,
    ! [VarCurr] :
      ( v132688(VarCurr)
    <=> v132690(VarCurr) ) ).

fof(addAssignment_43365,axiom,
    ! [VarCurr] :
      ( v132690(VarCurr)
    <=> v132692(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3176,axiom,
    ! [VarCurr] :
      ( ~ v132694(VarCurr)
     => ( v132692(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2981,axiom,
    ! [VarCurr] :
      ( v132694(VarCurr)
     => ( v132692(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9290,axiom,
    ! [VarCurr] :
      ( v132694(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $true )
        & ( v15274(VarCurr,bitIndex5)
        <=> $true )
        & ( v15274(VarCurr,bitIndex4)
        <=> $true )
        & ( v15274(VarCurr,bitIndex3)
        <=> $true )
        & ( v15274(VarCurr,bitIndex2)
        <=> $true )
        & ( v15274(VarCurr,bitIndex1)
        <=> $false )
        & ( v15274(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43364,axiom,
    ! [VarCurr] :
      ( v132681(VarCurr)
    <=> v132683(VarCurr) ) ).

fof(addAssignment_43363,axiom,
    ! [VarCurr] :
      ( v132683(VarCurr)
    <=> v132685(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3175,axiom,
    ! [VarCurr] :
      ( ~ v114208(VarCurr)
     => ( v132685(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2980,axiom,
    ! [VarCurr] :
      ( v114208(VarCurr)
     => ( v132685(VarCurr)
      <=> v15310(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43362,axiom,
    ! [VarCurr] :
      ( v132675(VarCurr)
    <=> v132677(VarCurr) ) ).

fof(addAssignment_43361,axiom,
    ! [VarCurr] :
      ( v132677(VarCurr)
    <=> v132679(VarCurr) ) ).

fof(addAssignment_43360,axiom,
    ! [VarCurr] :
      ( v132679(VarCurr)
    <=> v10103(VarCurr,bitIndex5) ) ).

fof(addAssignment_43359,axiom,
    ! [VarCurr] :
      ( v132668(VarCurr)
    <=> v132670(VarCurr) ) ).

fof(addAssignment_43358,axiom,
    ! [VarCurr] :
      ( v132670(VarCurr)
    <=> v132672(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3174,axiom,
    ! [VarCurr] :
      ( ~ v15314(VarCurr)
     => ( v132672(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2979,axiom,
    ! [VarCurr] :
      ( v15314(VarCurr)
     => ( v132672(VarCurr)
      <=> v15310(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43357,axiom,
    ! [VarCurr] :
      ( v132635(VarCurr)
    <=> v132637(VarCurr) ) ).

fof(addAssignment_43356,axiom,
    ! [VarCurr] :
      ( v132637(VarCurr)
    <=> v132639(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3023,axiom,
    ! [VarCurr] :
      ( v132639(VarCurr)
    <=> ( v132665(VarCurr)
        | v15295(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3022,axiom,
    ! [VarCurr] :
      ( v132665(VarCurr)
    <=> ( v132666(VarCurr)
        | v15295(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3021,axiom,
    ! [VarCurr] :
      ( v132666(VarCurr)
    <=> ( v10103(VarCurr,bitIndex1)
        | v15295(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43355,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex2)
    <=> v132657(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_138,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132658(VarNext)
       => ( ( v132657(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v132657(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v132657(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v132657(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v132657(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v132657(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v132657(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v132657(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v132657(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v132657(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v132657(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v132657(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v132657(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v132657(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v132657(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v132657(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v132657(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v132657(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v132657(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v132657(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2449,axiom,
    ! [VarNext] :
      ( v132658(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v132657(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132658(VarNext)
      <=> v132659(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26526,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132659(VarNext)
      <=> ( v132661(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10959,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132661(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_583,axiom,
    ! [VarCurr] :
      ( ~ v132655(VarCurr)
     => ( v10103(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_778,axiom,
    ! [VarCurr] :
      ( v132655(VarCurr)
     => ( v10103(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9289,axiom,
    ! [VarCurr] :
      ( v132655(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43354,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex1)
    <=> v132647(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132648(VarNext)
       => ( ( v132647(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v132647(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v132647(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v132647(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v132647(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v132647(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v132647(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v132647(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v132647(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v132647(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v132647(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v132647(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v132647(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v132647(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v132647(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v132647(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v132647(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v132647(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v132647(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v132647(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2448,axiom,
    ! [VarNext] :
      ( v132648(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v132647(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26525,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132648(VarNext)
      <=> v132649(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26524,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132649(VarNext)
      <=> ( v132651(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10958,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132651(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_582,axiom,
    ! [VarCurr] :
      ( ~ v132641(VarCurr)
     => ( v10103(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_777,axiom,
    ! [VarCurr] :
      ( v132641(VarCurr)
     => ( v10103(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26523,axiom,
    ! [VarCurr] :
      ( v132641(VarCurr)
    <=> ( v132642(VarCurr)
        & v131429(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26522,axiom,
    ! [VarCurr] :
      ( v132642(VarCurr)
    <=> ( v132644(VarCurr)
        & v131428(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26521,axiom,
    ! [VarCurr] :
      ( v132644(VarCurr)
    <=> ( v132645(VarCurr)
        & v131427(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26520,axiom,
    ! [VarCurr] :
      ( v132645(VarCurr)
    <=> ( v131544(VarCurr)
        & v15302(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26519,axiom,
    ! [VarCurr] :
      ( v132521(VarCurr)
    <=> ( v132630(VarCurr)
        & v132537(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26518,axiom,
    ! [VarCurr] :
      ( v132630(VarCurr)
    <=> ( v132631(VarCurr)
        & v132523(VarCurr) ) ) ).

fof(writeUnaryOperator_10957,axiom,
    ! [VarCurr] :
      ( ~ v132631(VarCurr)
    <=> v10117(VarCurr) ) ).

fof(addAssignment_43353,axiom,
    ! [VarCurr] :
      ( v132537(VarCurr)
    <=> v132539(VarCurr) ) ).

fof(addAssignment_43352,axiom,
    ! [VarCurr] :
      ( v132539(VarCurr)
    <=> v132541(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3020,axiom,
    ! [VarCurr] :
      ( v132541(VarCurr)
    <=> ( v132603(VarCurr)
        | v132543(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132608(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v132543(VarNext,B)
            <=> v132543(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2447,axiom,
    ! [VarNext] :
      ( v132608(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v132543(VarNext,B)
          <=> v132624(VarNext,B) ) ) ) ).

fof(addAssignment_43351,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v132624(VarNext,B)
          <=> v132622(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5400,axiom,
    ! [VarCurr] :
      ( ~ v132619(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132622(VarCurr,B)
          <=> v132578(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5389,axiom,
    ! [VarCurr] :
      ( v132619(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132622(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26517,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132608(VarNext)
      <=> ( v132609(VarNext)
          & v132618(VarNext) ) ) ) ).

fof(addAssignment_43350,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132618(VarNext)
      <=> v132616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26516,axiom,
    ! [VarCurr] :
      ( v132616(VarCurr)
    <=> ( v132619(VarCurr)
        | v132620(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26515,axiom,
    ! [VarCurr] :
      ( v132620(VarCurr)
    <=> ( v132547(VarCurr)
        & v132621(VarCurr) ) ) ).

fof(writeUnaryOperator_10956,axiom,
    ! [VarCurr] :
      ( ~ v132621(VarCurr)
    <=> v132619(VarCurr) ) ).

fof(writeUnaryOperator_10955,axiom,
    ! [VarCurr] :
      ( ~ v132619(VarCurr)
    <=> v132545(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26514,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132609(VarNext)
      <=> ( v132610(VarNext)
          & v132605(VarNext) ) ) ) ).

fof(writeUnaryOperator_10954,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132610(VarNext)
      <=> v132612(VarNext) ) ) ).

fof(addAssignment_43349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132612(VarNext)
      <=> v132605(VarCurr) ) ) ).

fof(addAssignment_43348,axiom,
    ! [VarCurr] :
      ( v132605(VarCurr)
    <=> v13228(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3173,axiom,
    ! [VarCurr] :
      ( ~ v132573(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132578(VarCurr,B)
          <=> v132594(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2978,axiom,
    ! [VarCurr] :
      ( v132573(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132578(VarCurr,B)
          <=> v132580(VarCurr,B) ) ) ) ).

fof(addAssignment_43347,axiom,
    ! [VarCurr] :
      ( v132594(VarCurr,bitIndex0)
    <=> v132592(VarCurr) ) ).

fof(addAssignment_43346,axiom,
    ! [VarCurr] :
      ( v132594(VarCurr,bitIndex1)
    <=> v132601(VarCurr) ) ).

fof(addAssignment_43345,axiom,
    ! [VarCurr] :
      ( v132594(VarCurr,bitIndex2)
    <=> v132596(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26513,axiom,
    ! [VarCurr] :
      ( v132601(VarCurr)
    <=> ( v132602(VarCurr)
        & v132603(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3019,axiom,
    ! [VarCurr] :
      ( v132603(VarCurr)
    <=> ( v132543(VarCurr,bitIndex0)
        | v132543(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26512,axiom,
    ! [VarCurr] :
      ( v132602(VarCurr)
    <=> ( v132592(VarCurr)
        | v132587(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26511,axiom,
    ! [VarCurr] :
      ( v132596(VarCurr)
    <=> ( v132597(VarCurr)
        & v132600(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3018,axiom,
    ! [VarCurr] :
      ( v132600(VarCurr)
    <=> ( v132543(VarCurr,bitIndex2)
        | v132599(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26510,axiom,
    ! [VarCurr] :
      ( v132597(VarCurr)
    <=> ( v132589(VarCurr)
        | v132598(VarCurr) ) ) ).

fof(writeUnaryOperator_10953,axiom,
    ! [VarCurr] :
      ( ~ v132598(VarCurr)
    <=> v132599(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3017,axiom,
    ! [VarCurr] :
      ( v132599(VarCurr)
    <=> ( v132543(VarCurr,bitIndex0)
        & v132543(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43344,axiom,
    ! [VarCurr] :
      ( v132580(VarCurr,bitIndex0)
    <=> v132592(VarCurr) ) ).

fof(addAssignment_43343,axiom,
    ! [VarCurr] :
      ( v132580(VarCurr,bitIndex1)
    <=> v132590(VarCurr) ) ).

fof(addAssignment_43342,axiom,
    ! [VarCurr] :
      ( v132580(VarCurr,bitIndex2)
    <=> v132582(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26509,axiom,
    ! [VarCurr] :
      ( v132590(VarCurr)
    <=> ( v132591(VarCurr)
        & v132593(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26508,axiom,
    ! [VarCurr] :
      ( v132593(VarCurr)
    <=> ( v132543(VarCurr,bitIndex0)
        | v132587(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3016,axiom,
    ! [VarCurr] :
      ( v132591(VarCurr)
    <=> ( v132592(VarCurr)
        | v132543(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_10952,axiom,
    ! [VarCurr] :
      ( ~ v132592(VarCurr)
    <=> v132543(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26507,axiom,
    ! [VarCurr] :
      ( v132582(VarCurr)
    <=> ( v132583(VarCurr)
        & v132588(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26506,axiom,
    ! [VarCurr] :
      ( v132588(VarCurr)
    <=> ( v132585(VarCurr)
        | v132589(VarCurr) ) ) ).

fof(writeUnaryOperator_10951,axiom,
    ! [VarCurr] :
      ( ~ v132589(VarCurr)
    <=> v132543(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3015,axiom,
    ! [VarCurr] :
      ( v132583(VarCurr)
    <=> ( v132584(VarCurr)
        | v132543(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10950,axiom,
    ! [VarCurr] :
      ( ~ v132584(VarCurr)
    <=> v132585(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3014,axiom,
    ! [VarCurr] :
      ( v132585(VarCurr)
    <=> ( v132543(VarCurr,bitIndex1)
        | v132586(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26505,axiom,
    ! [VarCurr] :
      ( v132586(VarCurr)
    <=> ( v132543(VarCurr,bitIndex0)
        & v132587(VarCurr) ) ) ).

fof(writeUnaryOperator_10949,axiom,
    ! [VarCurr] :
      ( ~ v132587(VarCurr)
    <=> v132543(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValueVector_40,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v132543(constB0,B)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26504,axiom,
    ! [VarCurr] :
      ( v132547(VarCurr)
    <=> ( v132549(VarCurr)
      <~> v132573(VarCurr) ) ) ).

fof(addAssignment_43341,axiom,
    ! [VarCurr] :
      ( v132573(VarCurr)
    <=> v132575(VarCurr) ) ).

fof(addAssignment_43340,axiom,
    ! [VarCurr] :
      ( v132575(VarCurr)
    <=> v132521(VarCurr) ) ).

fof(addAssignment_43339,axiom,
    ! [VarCurr] :
      ( v132549(VarCurr)
    <=> v132551(VarCurr) ) ).

fof(addAssignment_43338,axiom,
    ! [VarCurr] :
      ( v132551(VarCurr)
    <=> v132553(VarCurr) ) ).

fof(addAssignment_43337,axiom,
    ! [VarCurr] :
      ( v132553(VarCurr)
    <=> v132555(VarCurr) ) ).

fof(addAssignment_43336,axiom,
    ! [VarCurr] :
      ( v132555(VarCurr)
    <=> v132557(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2325,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132560(VarNext)
       => ( v132557(VarNext)
        <=> v132557(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2446,axiom,
    ! [VarNext] :
      ( v132560(VarNext)
     => ( v132557(VarNext)
      <=> v132568(VarNext) ) ) ).

fof(addAssignment_43335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132568(VarNext)
      <=> v132566(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3172,axiom,
    ! [VarCurr] :
      ( ~ v13179(VarCurr)
     => ( v132566(VarCurr)
      <=> v132569(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2977,axiom,
    ! [VarCurr] :
      ( v13179(VarCurr)
     => ( v132566(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3171,axiom,
    ! [VarCurr] :
      ( ~ v11756(VarCurr)
     => ( v132569(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2976,axiom,
    ! [VarCurr] :
      ( v11756(VarCurr)
     => ( v132569(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26503,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132560(VarNext)
      <=> v132561(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26502,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132561(VarNext)
      <=> ( v132563(VarNext)
          & v12075(VarNext) ) ) ) ).

fof(writeUnaryOperator_10948,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132563(VarNext)
      <=> v12082(VarNext) ) ) ).

fof(addAssignment_43334,axiom,
    ! [VarCurr] :
      ( v132545(VarCurr)
    <=> v10093(VarCurr) ) ).

fof(addAssignment_43333,axiom,
    ! [VarCurr] :
      ( v132523(VarCurr)
    <=> v132525(VarCurr) ) ).

fof(addAssignment_43332,axiom,
    ! [VarCurr] :
      ( v132525(VarCurr)
    <=> v132527(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3170,axiom,
    ! [VarCurr] :
      ( ~ v132529(VarCurr)
     => ( v132527(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2975,axiom,
    ! [VarCurr] :
      ( v132529(VarCurr)
     => ( v132527(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26501,axiom,
    ! [VarCurr] :
      ( v132529(VarCurr)
    <=> ( v132530(VarCurr)
        | v132535(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9288,axiom,
    ! [VarCurr] :
      ( v132535(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $false )
        & ( v15274(VarCurr,bitIndex5)
        <=> $false )
        & ( v15274(VarCurr,bitIndex4)
        <=> $false )
        & ( v15274(VarCurr,bitIndex3)
        <=> $true )
        & ( v15274(VarCurr,bitIndex2)
        <=> $false )
        & ( v15274(VarCurr,bitIndex1)
        <=> $false )
        & ( v15274(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26500,axiom,
    ! [VarCurr] :
      ( v132530(VarCurr)
    <=> ( v132531(VarCurr)
        | v132532(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26499,axiom,
    ! [VarCurr] :
      ( v132532(VarCurr)
    <=> ( v132533(VarCurr)
        | v132534(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9287,axiom,
    ! [VarCurr] :
      ( v132534(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $false )
        & ( v15274(VarCurr,bitIndex5)
        <=> $true )
        & ( v15274(VarCurr,bitIndex4)
        <=> $false )
        & ( v15274(VarCurr,bitIndex3)
        <=> $false )
        & ( v15274(VarCurr,bitIndex2)
        <=> $false )
        & ( v15274(VarCurr,bitIndex1)
        <=> $false )
        & ( v15274(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9286,axiom,
    ! [VarCurr] :
      ( v132533(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $false )
        & ( v15274(VarCurr,bitIndex5)
        <=> $false )
        & ( v15274(VarCurr,bitIndex4)
        <=> $false )
        & ( v15274(VarCurr,bitIndex3)
        <=> $false )
        & ( v15274(VarCurr,bitIndex2)
        <=> $false )
        & ( v15274(VarCurr,bitIndex1)
        <=> $false )
        & ( v15274(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26498,axiom,
    ! [VarCurr] :
      ( v132531(VarCurr)
    <=> ( v15310(VarCurr,bitIndex0)
        & v131875(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_581,axiom,
    ! [VarCurr] :
      ( ~ v132518(VarCurr)
     => ( v11299(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_776,axiom,
    ! [VarCurr] :
      ( v132518(VarCurr)
     => ( v11299(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26497,axiom,
    ! [VarCurr] :
      ( v132518(VarCurr)
    <=> ( v132519(VarCurr)
        & v132508(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26496,axiom,
    ! [VarCurr] :
      ( v132519(VarCurr)
    <=> ( v11301(VarCurr)
        & v10109(VarCurr) ) ) ).

fof(addAssignment_43331,axiom,
    ! [VarNext] :
      ( v13203(VarNext,bitIndex2)
    <=> v132510(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132511(VarNext)
       => ( ( v132510(VarNext,bitIndex11)
          <=> v13203(VarCurr,bitIndex12) )
          & ( v132510(VarNext,bitIndex10)
          <=> v13203(VarCurr,bitIndex11) )
          & ( v132510(VarNext,bitIndex9)
          <=> v13203(VarCurr,bitIndex10) )
          & ( v132510(VarNext,bitIndex8)
          <=> v13203(VarCurr,bitIndex9) )
          & ( v132510(VarNext,bitIndex7)
          <=> v13203(VarCurr,bitIndex8) )
          & ( v132510(VarNext,bitIndex6)
          <=> v13203(VarCurr,bitIndex7) )
          & ( v132510(VarNext,bitIndex5)
          <=> v13203(VarCurr,bitIndex6) )
          & ( v132510(VarNext,bitIndex4)
          <=> v13203(VarCurr,bitIndex5) )
          & ( v132510(VarNext,bitIndex3)
          <=> v13203(VarCurr,bitIndex4) )
          & ( v132510(VarNext,bitIndex2)
          <=> v13203(VarCurr,bitIndex3) )
          & ( v132510(VarNext,bitIndex1)
          <=> v13203(VarCurr,bitIndex2) )
          & ( v132510(VarNext,bitIndex0)
          <=> v13203(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2445,axiom,
    ! [VarNext] :
      ( v132511(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v132510(VarNext,B)
          <=> v114255(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132511(VarNext)
      <=> v132512(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26494,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132512(VarNext)
      <=> ( v132514(VarNext)
          & v114242(VarNext) ) ) ) ).

fof(writeUnaryOperator_10947,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132514(VarNext)
      <=> v114249(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_580,axiom,
    ! [VarCurr] :
      ( ~ v132502(VarCurr)
     => ( v11299(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_775,axiom,
    ! [VarCurr] :
      ( v132502(VarCurr)
     => ( v11299(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26493,axiom,
    ! [VarCurr] :
      ( v132502(VarCurr)
    <=> ( v132503(VarCurr)
        | v132504(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26492,axiom,
    ! [VarCurr] :
      ( v132504(VarCurr)
    <=> ( v132505(VarCurr)
        & v132508(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9285,axiom,
    ! [VarCurr] :
      ( v132508(VarCurr)
    <=> ( $true
      <=> v13203(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26491,axiom,
    ! [VarCurr] :
      ( v132505(VarCurr)
    <=> ( v132506(VarCurr)
        | v132507(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26490,axiom,
    ! [VarCurr] :
      ( v132507(VarCurr)
    <=> ( v131844(VarCurr)
        & v10109(VarCurr) ) ) ).

fof(writeUnaryOperator_10946,axiom,
    ! [VarCurr] :
      ( ~ v132506(VarCurr)
    <=> v10109(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9284,axiom,
    ! [VarCurr] :
      ( v132503(VarCurr)
    <=> ( $true
      <=> v13203(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43330,axiom,
    ! [VarNext] :
      ( v13203(VarNext,bitIndex1)
    <=> v132494(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_135,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132495(VarNext)
       => ( ( v132494(VarNext,bitIndex11)
          <=> v13203(VarCurr,bitIndex12) )
          & ( v132494(VarNext,bitIndex10)
          <=> v13203(VarCurr,bitIndex11) )
          & ( v132494(VarNext,bitIndex9)
          <=> v13203(VarCurr,bitIndex10) )
          & ( v132494(VarNext,bitIndex8)
          <=> v13203(VarCurr,bitIndex9) )
          & ( v132494(VarNext,bitIndex7)
          <=> v13203(VarCurr,bitIndex8) )
          & ( v132494(VarNext,bitIndex6)
          <=> v13203(VarCurr,bitIndex7) )
          & ( v132494(VarNext,bitIndex5)
          <=> v13203(VarCurr,bitIndex6) )
          & ( v132494(VarNext,bitIndex4)
          <=> v13203(VarCurr,bitIndex5) )
          & ( v132494(VarNext,bitIndex3)
          <=> v13203(VarCurr,bitIndex4) )
          & ( v132494(VarNext,bitIndex2)
          <=> v13203(VarCurr,bitIndex3) )
          & ( v132494(VarNext,bitIndex1)
          <=> v13203(VarCurr,bitIndex2) )
          & ( v132494(VarNext,bitIndex0)
          <=> v13203(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2444,axiom,
    ! [VarNext] :
      ( v132495(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v132494(VarNext,B)
          <=> v114255(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26489,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132495(VarNext)
      <=> v132496(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26488,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132496(VarNext)
      <=> ( v132498(VarNext)
          & v114242(VarNext) ) ) ) ).

fof(writeUnaryOperator_10945,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132498(VarNext)
      <=> v114249(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_579,axiom,
    ! [VarCurr] :
      ( ~ v132489(VarCurr)
     => ( v11299(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_774,axiom,
    ! [VarCurr] :
      ( v132489(VarCurr)
     => ( v11299(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26487,axiom,
    ! [VarCurr] :
      ( v132489(VarCurr)
    <=> ( v132490(VarCurr)
        & v114238(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26486,axiom,
    ! [VarCurr] :
      ( v132490(VarCurr)
    <=> ( v132492(VarCurr)
        & v114237(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26485,axiom,
    ! [VarCurr] :
      ( v132492(VarCurr)
    <=> ( v131826(VarCurr)
        & v114192(VarCurr) ) ) ).

fof(addAssignment_43329,axiom,
    ! [VarCurr] :
      ( v11301(VarCurr)
    <=> v11303(VarCurr) ) ).

fof(addAssignment_43328,axiom,
    ! [VarCurr] :
      ( v11303(VarCurr)
    <=> v11305(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3013,axiom,
    ! [VarCurr] :
      ( v11305(VarCurr)
    <=> ( v132474(VarCurr)
        | v11307(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3012,axiom,
    ! [VarCurr] :
      ( v132474(VarCurr)
    <=> ( v132475(VarCurr)
        | v11307(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3011,axiom,
    ! [VarCurr] :
      ( v132475(VarCurr)
    <=> ( v132476(VarCurr)
        | v11307(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3010,axiom,
    ! [VarCurr] :
      ( v132476(VarCurr)
    <=> ( v132477(VarCurr)
        | v11307(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3009,axiom,
    ! [VarCurr] :
      ( v132477(VarCurr)
    <=> ( v132478(VarCurr)
        | v11307(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3008,axiom,
    ! [VarCurr] :
      ( v132478(VarCurr)
    <=> ( v132479(VarCurr)
        | v11307(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3007,axiom,
    ! [VarCurr] :
      ( v132479(VarCurr)
    <=> ( v132480(VarCurr)
        | v11307(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3006,axiom,
    ! [VarCurr] :
      ( v132480(VarCurr)
    <=> ( v132481(VarCurr)
        | v11307(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3005,axiom,
    ! [VarCurr] :
      ( v132481(VarCurr)
    <=> ( v132482(VarCurr)
        | v11307(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3004,axiom,
    ! [VarCurr] :
      ( v132482(VarCurr)
    <=> ( v132483(VarCurr)
        | v11307(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3003,axiom,
    ! [VarCurr] :
      ( v132483(VarCurr)
    <=> ( v132484(VarCurr)
        | v11307(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3002,axiom,
    ! [VarCurr] :
      ( v132484(VarCurr)
    <=> ( v132485(VarCurr)
        | v11307(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3001,axiom,
    ! [VarCurr] :
      ( v132485(VarCurr)
    <=> ( v132486(VarCurr)
        | v11307(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3000,axiom,
    ! [VarCurr] :
      ( v132486(VarCurr)
    <=> ( v132487(VarCurr)
        | v11307(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2999,axiom,
    ! [VarCurr] :
      ( v132487(VarCurr)
    <=> ( v11307(VarCurr,bitIndex0)
        | v11307(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2324,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132458(VarNext)
       => ! [B] :
            ( range_15_0(B)
           => ( v11307(VarNext,B)
            <=> v11307(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2443,axiom,
    ! [VarNext] :
      ( v132458(VarNext)
     => ! [B] :
          ( range_15_0(B)
         => ( v11307(VarNext,B)
          <=> v132468(VarNext,B) ) ) ) ).

fof(addAssignment_43327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_15_0(B)
         => ( v132468(VarNext,B)
          <=> v132466(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3169,axiom,
    ! [VarCurr] :
      ( ~ v132469(VarCurr)
     => ! [B] :
          ( range_15_0(B)
         => ( v132466(VarCurr,B)
          <=> v11312(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2974,axiom,
    ! [VarCurr] :
      ( v132469(VarCurr)
     => ! [B] :
          ( range_15_0(B)
         => ( v132466(VarCurr,B)
          <=> $true ) ) ) ).

fof(writeUnaryOperator_10944,axiom,
    ! [VarCurr] :
      ( ~ v132469(VarCurr)
    <=> v11309(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26484,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132458(VarNext)
      <=> v132459(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26483,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132459(VarNext)
      <=> ( v132460(VarNext)
          & v132455(VarNext) ) ) ) ).

fof(writeUnaryOperator_10943,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132460(VarNext)
      <=> v132462(VarNext) ) ) ).

fof(addAssignment_43326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132462(VarNext)
      <=> v132455(VarCurr) ) ) ).

fof(addAssignment_43325,axiom,
    ! [VarCurr] :
      ( v132455(VarCurr)
    <=> v13228(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_140,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v11312(VarCurr,B)
      <=> ( v132452(VarCurr,B)
          & v132453(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_10942,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132453(VarCurr,B)
      <=> ~ v13188(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_139,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132452(VarCurr,B)
      <=> ( v11314(VarCurr,B)
          | v11307(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_138,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v13188(VarCurr,B)
      <=> ( v13190(VarCurr,B)
          & v132449(VarCurr,B) ) ) ) ).

fof(addAssignment_43324,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex0)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43323,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex1)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43322,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex2)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43321,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex3)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43320,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex4)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43319,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex5)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43318,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex6)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43317,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex7)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43316,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex8)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43315,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex9)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43314,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex10)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43313,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex11)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43312,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex12)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43311,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex13)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43310,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex14)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43309,axiom,
    ! [VarCurr] :
      ( v132449(VarCurr,bitIndex15)
    <=> v132450(VarCurr) ) ).

fof(addAssignment_43308,axiom,
    ! [VarCurr] :
      ( v132450(VarCurr)
    <=> v13197(VarCurr) ) ).

fof(addAssignment_43307,axiom,
    ! [VarCurr] :
      ( v13197(VarCurr)
    <=> v13199(VarCurr) ) ).

fof(addAssignment_43306,axiom,
    ! [VarCurr] :
      ( v13199(VarCurr)
    <=> v13201(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26482,axiom,
    ! [VarCurr] :
      ( v13201(VarCurr)
    <=> ( v132446(VarCurr)
        | v131859(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26481,axiom,
    ! [VarCurr] :
      ( v132446(VarCurr)
    <=> ( v132447(VarCurr)
        | v114133(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2998,axiom,
    ! [VarCurr] :
      ( v132447(VarCurr)
    <=> ( v11299(VarCurr,bitIndex3)
        | v11299(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26480,axiom,
    ! [VarCurr] :
      ( v131859(VarCurr)
    <=> ( v131861(VarCurr)
        | v132441(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26479,axiom,
    ! [VarCurr] :
      ( v132441(VarCurr)
    <=> ( v132443(VarCurr)
        & v131865(VarCurr) ) ) ).

fof(writeUnaryOperator_10941,axiom,
    ! [VarCurr] :
      ( ~ v132443(VarCurr)
    <=> v131863(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26478,axiom,
    ! [VarCurr] :
      ( v131861(VarCurr)
    <=> ( v132439(VarCurr)
        & v131883(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26477,axiom,
    ! [VarCurr] :
      ( v132439(VarCurr)
    <=> ( v131863(VarCurr)
        & v131865(VarCurr) ) ) ).

fof(addAssignment_43305,axiom,
    ! [VarCurr] :
      ( v131883(VarCurr)
    <=> v131885(VarCurr) ) ).

fof(addAssignment_43304,axiom,
    ! [VarCurr] :
      ( v131885(VarCurr)
    <=> v131887(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2997,axiom,
    ! [VarCurr] :
      ( v131887(VarCurr)
    <=> ( v132431(VarCurr)
        & v131889(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2996,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr)
    <=> ( v132432(VarCurr)
        & v131889(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2995,axiom,
    ! [VarCurr] :
      ( v132432(VarCurr)
    <=> ( v132433(VarCurr)
        & v131889(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2994,axiom,
    ! [VarCurr] :
      ( v132433(VarCurr)
    <=> ( v132434(VarCurr)
        & v131889(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2993,axiom,
    ! [VarCurr] :
      ( v132434(VarCurr)
    <=> ( v132435(VarCurr)
        & v131889(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2992,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr)
    <=> ( v132436(VarCurr)
        & v131889(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2991,axiom,
    ! [VarCurr] :
      ( v132436(VarCurr)
    <=> ( v132437(VarCurr)
        & v131889(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2990,axiom,
    ! [VarCurr] :
      ( v132437(VarCurr)
    <=> ( v131889(VarCurr,bitIndex0)
        & v131889(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43303,axiom,
    ! [VarCurr] :
      ( ( v131889(VarCurr,bitIndex8)
      <=> v132364(VarCurr,bitIndex16) )
      & ( v131889(VarCurr,bitIndex7)
      <=> v132364(VarCurr,bitIndex15) )
      & ( v131889(VarCurr,bitIndex6)
      <=> v132364(VarCurr,bitIndex14) )
      & ( v131889(VarCurr,bitIndex5)
      <=> v132364(VarCurr,bitIndex13) )
      & ( v131889(VarCurr,bitIndex4)
      <=> v132364(VarCurr,bitIndex12) )
      & ( v131889(VarCurr,bitIndex3)
      <=> v132364(VarCurr,bitIndex11) )
      & ( v131889(VarCurr,bitIndex2)
      <=> v132364(VarCurr,bitIndex10) )
      & ( v131889(VarCurr,bitIndex1)
      <=> v132364(VarCurr,bitIndex9) )
      & ( v131889(VarCurr,bitIndex0)
      <=> v132364(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_137,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132364(VarCurr,B)
      <=> ( v132366(VarCurr,B)
          | v132426(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_136,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132426(VarCurr,B)
      <=> ( v132427(VarCurr,B)
          & v132428(VarCurr,B) ) ) ) ).

fof(addAssignment_43302,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex0)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43301,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex1)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43300,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex2)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43299,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex3)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43298,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex4)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43297,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex5)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43296,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex6)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43295,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex7)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43294,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex8)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43293,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex9)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43292,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex10)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43291,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex11)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43290,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex12)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43289,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex13)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43288,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex14)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43287,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex15)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43286,axiom,
    ! [VarCurr] :
      ( v132428(VarCurr,bitIndex16)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(addAssignment_43285,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v132427(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_43284,axiom,
    ! [VarCurr] :
      ( ( v132427(VarCurr,bitIndex16)
      <=> v132367(VarCurr,bitIndex8) )
      & ( v132427(VarCurr,bitIndex15)
      <=> v132367(VarCurr,bitIndex7) )
      & ( v132427(VarCurr,bitIndex14)
      <=> v132367(VarCurr,bitIndex6) )
      & ( v132427(VarCurr,bitIndex13)
      <=> v132367(VarCurr,bitIndex5) )
      & ( v132427(VarCurr,bitIndex12)
      <=> v132367(VarCurr,bitIndex4) )
      & ( v132427(VarCurr,bitIndex11)
      <=> v132367(VarCurr,bitIndex3) )
      & ( v132427(VarCurr,bitIndex10)
      <=> v132367(VarCurr,bitIndex2) )
      & ( v132427(VarCurr,bitIndex9)
      <=> v132367(VarCurr,bitIndex1) )
      & ( v132427(VarCurr,bitIndex8)
      <=> v132367(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_135,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132366(VarCurr,B)
      <=> ( v132367(VarCurr,B)
          & v132424(VarCurr,B) ) ) ) ).

fof(addAssignment_43283,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex0)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43282,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex1)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43281,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex2)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43280,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex3)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43279,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex4)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43278,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex5)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43277,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex6)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43276,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex7)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43275,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex8)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43274,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex9)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43273,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex10)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43272,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex11)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43271,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex12)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43270,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex13)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43269,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex14)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43268,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex15)
    <=> v132425(VarCurr) ) ).

fof(addAssignment_43267,axiom,
    ! [VarCurr] :
      ( v132424(VarCurr,bitIndex16)
    <=> v132425(VarCurr) ) ).

fof(writeUnaryOperator_10940,axiom,
    ! [VarCurr] :
      ( ~ v132425(VarCurr)
    <=> v132376(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_134,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132367(VarCurr,B)
      <=> ( v132368(VarCurr,B)
          | v132421(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_133,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132421(VarCurr,B)
      <=> ( v132422(VarCurr,B)
          & v132423(VarCurr,B) ) ) ) ).

fof(addAssignment_43266,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex0)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43265,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex1)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43264,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex2)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43263,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex3)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43262,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex4)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43261,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex5)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43260,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex6)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43259,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex7)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43258,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex8)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43257,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex9)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43256,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex10)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43255,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex11)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43254,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex12)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43253,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex13)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43252,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex14)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43251,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex15)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43250,axiom,
    ! [VarCurr] :
      ( v132423(VarCurr,bitIndex16)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(addAssignment_43249,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v132422(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_43248,axiom,
    ! [VarCurr] :
      ( ( v132422(VarCurr,bitIndex16)
      <=> v132369(VarCurr,bitIndex12) )
      & ( v132422(VarCurr,bitIndex15)
      <=> v132369(VarCurr,bitIndex11) )
      & ( v132422(VarCurr,bitIndex14)
      <=> v132369(VarCurr,bitIndex10) )
      & ( v132422(VarCurr,bitIndex13)
      <=> v132369(VarCurr,bitIndex9) )
      & ( v132422(VarCurr,bitIndex12)
      <=> v132369(VarCurr,bitIndex8) )
      & ( v132422(VarCurr,bitIndex11)
      <=> v132369(VarCurr,bitIndex7) )
      & ( v132422(VarCurr,bitIndex10)
      <=> v132369(VarCurr,bitIndex6) )
      & ( v132422(VarCurr,bitIndex9)
      <=> v132369(VarCurr,bitIndex5) )
      & ( v132422(VarCurr,bitIndex8)
      <=> v132369(VarCurr,bitIndex4) )
      & ( v132422(VarCurr,bitIndex7)
      <=> v132369(VarCurr,bitIndex3) )
      & ( v132422(VarCurr,bitIndex6)
      <=> v132369(VarCurr,bitIndex2) )
      & ( v132422(VarCurr,bitIndex5)
      <=> v132369(VarCurr,bitIndex1) )
      & ( v132422(VarCurr,bitIndex4)
      <=> v132369(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_132,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132368(VarCurr,B)
      <=> ( v132369(VarCurr,B)
          & v132419(VarCurr,B) ) ) ) ).

fof(addAssignment_43247,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex0)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43246,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex1)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43245,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex2)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43244,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex3)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43243,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex4)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43242,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex5)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43241,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex6)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43240,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex7)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43239,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex8)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43238,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex9)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43237,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex10)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43236,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex11)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43235,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex12)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43234,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex13)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43233,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex14)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43232,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex15)
    <=> v132420(VarCurr) ) ).

fof(addAssignment_43231,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex16)
    <=> v132420(VarCurr) ) ).

fof(writeUnaryOperator_10939,axiom,
    ! [VarCurr] :
      ( ~ v132420(VarCurr)
    <=> v132376(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_131,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132369(VarCurr,B)
      <=> ( v132370(VarCurr,B)
          | v132416(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_130,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132416(VarCurr,B)
      <=> ( v132417(VarCurr,B)
          & v132418(VarCurr,B) ) ) ) ).

fof(addAssignment_43230,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex0)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43229,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex1)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43228,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex2)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43227,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex3)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43226,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex4)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43225,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex5)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43224,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex6)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43223,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex7)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43222,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex8)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43221,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex9)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43220,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex10)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43219,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex11)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43218,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex12)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43217,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex13)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43216,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex14)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43215,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex15)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43214,axiom,
    ! [VarCurr] :
      ( v132418(VarCurr,bitIndex16)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(addAssignment_43213,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v132417(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_43212,axiom,
    ! [VarCurr] :
      ( ( v132417(VarCurr,bitIndex16)
      <=> v132371(VarCurr,bitIndex14) )
      & ( v132417(VarCurr,bitIndex15)
      <=> v132371(VarCurr,bitIndex13) )
      & ( v132417(VarCurr,bitIndex14)
      <=> v132371(VarCurr,bitIndex12) )
      & ( v132417(VarCurr,bitIndex13)
      <=> v132371(VarCurr,bitIndex11) )
      & ( v132417(VarCurr,bitIndex12)
      <=> v132371(VarCurr,bitIndex10) )
      & ( v132417(VarCurr,bitIndex11)
      <=> v132371(VarCurr,bitIndex9) )
      & ( v132417(VarCurr,bitIndex10)
      <=> v132371(VarCurr,bitIndex8) )
      & ( v132417(VarCurr,bitIndex9)
      <=> v132371(VarCurr,bitIndex7) )
      & ( v132417(VarCurr,bitIndex8)
      <=> v132371(VarCurr,bitIndex6) )
      & ( v132417(VarCurr,bitIndex7)
      <=> v132371(VarCurr,bitIndex5) )
      & ( v132417(VarCurr,bitIndex6)
      <=> v132371(VarCurr,bitIndex4) )
      & ( v132417(VarCurr,bitIndex5)
      <=> v132371(VarCurr,bitIndex3) )
      & ( v132417(VarCurr,bitIndex4)
      <=> v132371(VarCurr,bitIndex2) )
      & ( v132417(VarCurr,bitIndex3)
      <=> v132371(VarCurr,bitIndex1) )
      & ( v132417(VarCurr,bitIndex2)
      <=> v132371(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_129,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132370(VarCurr,B)
      <=> ( v132371(VarCurr,B)
          & v132414(VarCurr,B) ) ) ) ).

fof(addAssignment_43211,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex0)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43210,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex1)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43209,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex2)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43208,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex3)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43207,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex4)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43206,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex5)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43205,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex6)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43204,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex7)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43203,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex8)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43202,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex9)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43201,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex10)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43200,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex11)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43199,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex12)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43198,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex13)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43197,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex14)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43196,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex15)
    <=> v132415(VarCurr) ) ).

fof(addAssignment_43195,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr,bitIndex16)
    <=> v132415(VarCurr) ) ).

fof(writeUnaryOperator_10938,axiom,
    ! [VarCurr] :
      ( ~ v132415(VarCurr)
    <=> v132376(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_128,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132371(VarCurr,B)
      <=> ( v132372(VarCurr,B)
          | v132411(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_127,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132411(VarCurr,B)
      <=> ( v132412(VarCurr,B)
          & v132413(VarCurr,B) ) ) ) ).

fof(addAssignment_43194,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex0)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43193,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex1)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43192,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex2)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43191,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex3)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43190,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex4)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43189,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex5)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43188,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex6)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43187,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex7)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43186,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex8)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43185,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex9)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43184,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex10)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43183,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex11)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43182,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex12)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43181,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex13)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43180,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex14)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43179,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex15)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43178,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr,bitIndex16)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43177,axiom,
    ! [VarCurr] :
      ( v132412(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_43176,axiom,
    ! [VarCurr] :
      ( ( v132412(VarCurr,bitIndex16)
      <=> v132373(VarCurr,bitIndex15) )
      & ( v132412(VarCurr,bitIndex15)
      <=> v132373(VarCurr,bitIndex14) )
      & ( v132412(VarCurr,bitIndex14)
      <=> v132373(VarCurr,bitIndex13) )
      & ( v132412(VarCurr,bitIndex13)
      <=> v132373(VarCurr,bitIndex12) )
      & ( v132412(VarCurr,bitIndex12)
      <=> v132373(VarCurr,bitIndex11) )
      & ( v132412(VarCurr,bitIndex11)
      <=> v132373(VarCurr,bitIndex10) )
      & ( v132412(VarCurr,bitIndex10)
      <=> v132373(VarCurr,bitIndex9) )
      & ( v132412(VarCurr,bitIndex9)
      <=> v132373(VarCurr,bitIndex8) )
      & ( v132412(VarCurr,bitIndex8)
      <=> v132373(VarCurr,bitIndex7) )
      & ( v132412(VarCurr,bitIndex7)
      <=> v132373(VarCurr,bitIndex6) )
      & ( v132412(VarCurr,bitIndex6)
      <=> v132373(VarCurr,bitIndex5) )
      & ( v132412(VarCurr,bitIndex5)
      <=> v132373(VarCurr,bitIndex4) )
      & ( v132412(VarCurr,bitIndex4)
      <=> v132373(VarCurr,bitIndex3) )
      & ( v132412(VarCurr,bitIndex3)
      <=> v132373(VarCurr,bitIndex2) )
      & ( v132412(VarCurr,bitIndex2)
      <=> v132373(VarCurr,bitIndex1) )
      & ( v132412(VarCurr,bitIndex1)
      <=> v132373(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_126,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132372(VarCurr,B)
      <=> ( v132373(VarCurr,B)
          & v132374(VarCurr,B) ) ) ) ).

fof(addAssignment_43175,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex0)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43174,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex1)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43173,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex2)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43172,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex3)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43171,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex4)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43170,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex5)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43169,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex6)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43168,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex7)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43167,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex8)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43166,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex9)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43165,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex10)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43164,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex11)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43163,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex12)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43162,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex13)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43161,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex14)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43160,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex15)
    <=> v132375(VarCurr) ) ).

fof(addAssignment_43159,axiom,
    ! [VarCurr] :
      ( v132374(VarCurr,bitIndex16)
    <=> v132375(VarCurr) ) ).

fof(writeUnaryOperator_10937,axiom,
    ! [VarCurr] :
      ( ~ v132375(VarCurr)
    <=> v132376(VarCurr,bitIndex0) ) ).

fof(addAssignment_43158,axiom,
    ! [VarCurr] :
      ( v132376(VarCurr,bitIndex0)
    <=> v132385(VarCurr) ) ).

fof(addAssignment_43157,axiom,
    ! [VarCurr] :
      ( v132376(VarCurr,bitIndex1)
    <=> v132407(VarCurr) ) ).

fof(addAssignment_43156,axiom,
    ! [VarCurr] :
      ( v132376(VarCurr,bitIndex2)
    <=> v132402(VarCurr) ) ).

fof(addAssignment_43155,axiom,
    ! [VarCurr] :
      ( v132376(VarCurr,bitIndex3)
    <=> v132378(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26476,axiom,
    ! [VarCurr] :
      ( v132407(VarCurr)
    <=> ( v132408(VarCurr)
        & v132410(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26475,axiom,
    ! [VarCurr] :
      ( v132410(VarCurr)
    <=> ( v132361(VarCurr,bitIndex0)
        | v132397(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26474,axiom,
    ! [VarCurr] :
      ( v132408(VarCurr)
    <=> ( v132385(VarCurr)
        | v132409(VarCurr) ) ) ).

fof(writeUnaryOperator_10936,axiom,
    ! [VarCurr] :
      ( ~ v132409(VarCurr)
    <=> v132397(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26473,axiom,
    ! [VarCurr] :
      ( v132402(VarCurr)
    <=> ( v132403(VarCurr)
        & v132406(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26472,axiom,
    ! [VarCurr] :
      ( v132406(VarCurr)
    <=> ( v132392(VarCurr)
        | v132396(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26471,axiom,
    ! [VarCurr] :
      ( v132403(VarCurr)
    <=> ( v132404(VarCurr)
        | v132405(VarCurr) ) ) ).

fof(writeUnaryOperator_10935,axiom,
    ! [VarCurr] :
      ( ~ v132405(VarCurr)
    <=> v132396(VarCurr) ) ).

fof(writeUnaryOperator_10934,axiom,
    ! [VarCurr] :
      ( ~ v132404(VarCurr)
    <=> v132392(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26470,axiom,
    ! [VarCurr] :
      ( v132378(VarCurr)
    <=> ( v132379(VarCurr)
        & v132400(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26469,axiom,
    ! [VarCurr] :
      ( v132400(VarCurr)
    <=> ( v132401(VarCurr)
        | v132391(VarCurr) ) ) ).

fof(writeUnaryOperator_10933,axiom,
    ! [VarCurr] :
      ( ~ v132401(VarCurr)
    <=> v132380(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26468,axiom,
    ! [VarCurr] :
      ( v132379(VarCurr)
    <=> ( v132380(VarCurr)
        | v132390(VarCurr) ) ) ).

fof(writeUnaryOperator_10932,axiom,
    ! [VarCurr] :
      ( ~ v132390(VarCurr)
    <=> v132391(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26467,axiom,
    ! [VarCurr] :
      ( v132391(VarCurr)
    <=> ( v132392(VarCurr)
        & v132396(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26466,axiom,
    ! [VarCurr] :
      ( v132396(VarCurr)
    <=> ( v132361(VarCurr,bitIndex0)
        & v132397(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26465,axiom,
    ! [VarCurr] :
      ( v132397(VarCurr)
    <=> ( v132398(VarCurr)
        & v132399(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26464,axiom,
    ! [VarCurr] :
      ( v132399(VarCurr)
    <=> ( v132385(VarCurr)
        | v132386(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2989,axiom,
    ! [VarCurr] :
      ( v132398(VarCurr)
    <=> ( v132361(VarCurr,bitIndex0)
        | v132361(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26463,axiom,
    ! [VarCurr] :
      ( v132392(VarCurr)
    <=> ( v132393(VarCurr)
        & v132395(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26462,axiom,
    ! [VarCurr] :
      ( v132395(VarCurr)
    <=> ( v132384(VarCurr)
        | v132387(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2988,axiom,
    ! [VarCurr] :
      ( v132393(VarCurr)
    <=> ( v132394(VarCurr)
        | v132361(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10931,axiom,
    ! [VarCurr] :
      ( ~ v132394(VarCurr)
    <=> v132384(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26461,axiom,
    ! [VarCurr] :
      ( v132380(VarCurr)
    <=> ( v132381(VarCurr)
        & v132388(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26460,axiom,
    ! [VarCurr] :
      ( v132388(VarCurr)
    <=> ( v132383(VarCurr)
        | v132389(VarCurr) ) ) ).

fof(writeUnaryOperator_10930,axiom,
    ! [VarCurr] :
      ( ~ v132389(VarCurr)
    <=> v132361(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_2987,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr)
    <=> ( v132382(VarCurr)
        | v132361(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_10929,axiom,
    ! [VarCurr] :
      ( ~ v132382(VarCurr)
    <=> v132383(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26459,axiom,
    ! [VarCurr] :
      ( v132383(VarCurr)
    <=> ( v132384(VarCurr)
        & v132387(VarCurr) ) ) ).

fof(writeUnaryOperator_10928,axiom,
    ! [VarCurr] :
      ( ~ v132387(VarCurr)
    <=> v132361(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26458,axiom,
    ! [VarCurr] :
      ( v132384(VarCurr)
    <=> ( v132385(VarCurr)
        & v132386(VarCurr) ) ) ).

fof(writeUnaryOperator_10927,axiom,
    ! [VarCurr] :
      ( ~ v132386(VarCurr)
    <=> v132361(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10926,axiom,
    ! [VarCurr] :
      ( ~ v132385(VarCurr)
    <=> v132361(VarCurr,bitIndex0) ) ).

fof(addAssignment_43154,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v132373(VarCurr,B)
      <=> $true ) ) ).

fof(addAssignment_43153,axiom,
    ! [VarCurr] :
      ( ( v132373(VarCurr,bitIndex16)
      <=> v131891(VarCurr,bitIndex8) )
      & ( v132373(VarCurr,bitIndex15)
      <=> v131891(VarCurr,bitIndex7) )
      & ( v132373(VarCurr,bitIndex14)
      <=> v131891(VarCurr,bitIndex6) )
      & ( v132373(VarCurr,bitIndex13)
      <=> v131891(VarCurr,bitIndex5) )
      & ( v132373(VarCurr,bitIndex12)
      <=> v131891(VarCurr,bitIndex4) )
      & ( v132373(VarCurr,bitIndex11)
      <=> v131891(VarCurr,bitIndex3) )
      & ( v132373(VarCurr,bitIndex10)
      <=> v131891(VarCurr,bitIndex2) )
      & ( v132373(VarCurr,bitIndex9)
      <=> v131891(VarCurr,bitIndex1) )
      & ( v132373(VarCurr,bitIndex8)
      <=> v131891(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43152,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v132361(VarCurr,B)
      <=> v132363(VarCurr,B) ) ) ).

fof(addAssignment_43151,axiom,
    ! [VarCurr] :
      ( ( v132363(VarCurr,bitIndex3)
      <=> v13220(VarCurr,bitIndex8) )
      & ( v132363(VarCurr,bitIndex2)
      <=> v13220(VarCurr,bitIndex7) )
      & ( v132363(VarCurr,bitIndex1)
      <=> v13220(VarCurr,bitIndex6) )
      & ( v132363(VarCurr,bitIndex0)
      <=> v13220(VarCurr,bitIndex5) ) ) ).

fof(addAssignment_43150,axiom,
    ! [VarCurr,B] :
      ( range_8_5(B)
     => ( v13220(VarCurr,B)
      <=> v13222(VarCurr,B) ) ) ).

fof(addAssignment_43149,axiom,
    ! [VarCurr,B] :
      ( range_8_5(B)
     => ( v13222(VarCurr,B)
      <=> v15233(VarCurr,B) ) ) ).

fof(range_axiom_197,axiom,
    ! [B] :
      ( range_8_5(B)
    <=> ( $false
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B ) ) ).

fof(addAssignment_43148,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex8)
    <=> v132171(VarCurr,bitIndex8) ) ).

fof(addAssignment_43147,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex7)
    <=> v132171(VarCurr,bitIndex7) ) ).

fof(addAssignment_43146,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex6)
    <=> v132171(VarCurr,bitIndex6) ) ).

fof(addAssignment_43145,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex5)
    <=> v132171(VarCurr,bitIndex5) ) ).

fof(addAssignment_43144,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex4)
    <=> v132171(VarCurr,bitIndex4) ) ).

fof(addAssignment_43143,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex3)
    <=> v132171(VarCurr,bitIndex3) ) ).

fof(addAssignment_43142,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex2)
    <=> v132171(VarCurr,bitIndex2) ) ).

fof(addAssignment_43141,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex1)
    <=> v132171(VarCurr,bitIndex1) ) ).

fof(addAssignment_43140,axiom,
    ! [VarCurr] :
      ( v131891(VarCurr,bitIndex0)
    <=> v132171(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_125,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132171(VarCurr,B)
      <=> ( v132173(VarCurr,B)
          | v132266(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_124,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132266(VarCurr,B)
      <=> ( v132267(VarCurr,B)
          & v132359(VarCurr,B) ) ) ) ).

fof(addAssignment_43139,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43138,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43137,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43136,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43135,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43134,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43133,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43132,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43131,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43130,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43129,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43128,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43127,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43126,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43125,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43124,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43123,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43122,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43121,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43120,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43119,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43118,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43117,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43116,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43115,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43114,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43113,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43112,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43111,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43110,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43109,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43108,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43107,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43106,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43105,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43104,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43103,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex36)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43102,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex37)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43101,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex38)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43100,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex39)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(addAssignment_43099,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132267(VarCurr,B)
      <=> v132269(VarCurr,B) ) ) ).

fof(addAssignment_43098,axiom,
    ! [VarCurr] :
      ( ( v132267(VarCurr,bitIndex39)
      <=> $false )
      & ( v132267(VarCurr,bitIndex38)
      <=> $false )
      & ( v132267(VarCurr,bitIndex37)
      <=> $false )
      & ( v132267(VarCurr,bitIndex36)
      <=> $false )
      & ( v132267(VarCurr,bitIndex35)
      <=> $false )
      & ( v132267(VarCurr,bitIndex34)
      <=> $false )
      & ( v132267(VarCurr,bitIndex33)
      <=> $false )
      & ( v132267(VarCurr,bitIndex32)
      <=> $false )
      & ( v132267(VarCurr,bitIndex31)
      <=> $false )
      & ( v132267(VarCurr,bitIndex30)
      <=> $false )
      & ( v132267(VarCurr,bitIndex29)
      <=> $false )
      & ( v132267(VarCurr,bitIndex28)
      <=> $false )
      & ( v132267(VarCurr,bitIndex27)
      <=> $false )
      & ( v132267(VarCurr,bitIndex26)
      <=> $false )
      & ( v132267(VarCurr,bitIndex25)
      <=> $false )
      & ( v132267(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(bitBlastConstant_12712,axiom,
    ~ b0000000000000000(bitIndex15) ).

fof(bitBlastConstant_12711,axiom,
    ~ b0000000000000000(bitIndex14) ).

fof(bitBlastConstant_12710,axiom,
    ~ b0000000000000000(bitIndex13) ).

fof(bitBlastConstant_12709,axiom,
    ~ b0000000000000000(bitIndex12) ).

fof(bitBlastConstant_12708,axiom,
    ~ b0000000000000000(bitIndex11) ).

fof(bitBlastConstant_12707,axiom,
    ~ b0000000000000000(bitIndex10) ).

fof(bitBlastConstant_12706,axiom,
    ~ b0000000000000000(bitIndex9) ).

fof(bitBlastConstant_12705,axiom,
    ~ b0000000000000000(bitIndex8) ).

fof(bitBlastConstant_12704,axiom,
    ~ b0000000000000000(bitIndex7) ).

fof(bitBlastConstant_12703,axiom,
    ~ b0000000000000000(bitIndex6) ).

fof(bitBlastConstant_12702,axiom,
    ~ b0000000000000000(bitIndex5) ).

fof(bitBlastConstant_12701,axiom,
    ~ b0000000000000000(bitIndex4) ).

fof(bitBlastConstant_12700,axiom,
    ~ b0000000000000000(bitIndex3) ).

fof(bitBlastConstant_12699,axiom,
    ~ b0000000000000000(bitIndex2) ).

fof(bitBlastConstant_12698,axiom,
    ~ b0000000000000000(bitIndex1) ).

fof(bitBlastConstant_12697,axiom,
    ~ b0000000000000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_123,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132269(VarCurr,B)
      <=> ( v132270(VarCurr,B)
          | v132314(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_122,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132314(VarCurr,B)
      <=> ( v132315(VarCurr,B)
          & v132358(VarCurr,B) ) ) ) ).

fof(addAssignment_43097,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43096,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43095,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43094,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43093,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43092,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43091,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43090,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43089,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43088,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43087,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43086,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43085,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43084,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43083,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43082,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43081,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43080,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43079,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43078,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43077,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43076,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43075,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43074,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_43073,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132315(VarCurr,B)
      <=> v132316(VarCurr,B) ) ) ).

fof(addAssignment_43072,axiom,
    ! [VarCurr] :
      ( ( v132315(VarCurr,bitIndex23)
      <=> $false )
      & ( v132315(VarCurr,bitIndex22)
      <=> $false )
      & ( v132315(VarCurr,bitIndex21)
      <=> $false )
      & ( v132315(VarCurr,bitIndex20)
      <=> $false )
      & ( v132315(VarCurr,bitIndex19)
      <=> $false )
      & ( v132315(VarCurr,bitIndex18)
      <=> $false )
      & ( v132315(VarCurr,bitIndex17)
      <=> $false )
      & ( v132315(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_121,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132316(VarCurr,B)
      <=> ( v132317(VarCurr,B)
          | v132337(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_120,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132337(VarCurr,B)
      <=> ( v132338(VarCurr,B)
          & v132357(VarCurr,B) ) ) ) ).

fof(addAssignment_43071,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43070,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43069,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43068,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43067,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43066,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43065,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43064,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43063,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43062,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43061,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43060,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43059,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43058,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43057,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43056,axiom,
    ! [VarCurr] :
      ( v132357(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_43055,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132338(VarCurr,B)
      <=> v132339(VarCurr,B) ) ) ).

fof(addAssignment_43054,axiom,
    ! [VarCurr] :
      ( ( v132338(VarCurr,bitIndex15)
      <=> $false )
      & ( v132338(VarCurr,bitIndex14)
      <=> $false )
      & ( v132338(VarCurr,bitIndex13)
      <=> $false )
      & ( v132338(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_119,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132339(VarCurr,B)
      <=> ( v132340(VarCurr,B)
          | v132348(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_118,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132348(VarCurr,B)
      <=> ( v132349(VarCurr,B)
          & v132356(VarCurr,B) ) ) ) ).

fof(addAssignment_43053,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43052,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43051,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43050,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43049,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43048,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43047,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43046,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43045,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43044,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43043,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43042,axiom,
    ! [VarCurr] :
      ( v132356(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_43041,axiom,
    ! [VarCurr,B] :
      ( range_9_0(B)
     => ( v132349(VarCurr,B)
      <=> v132350(VarCurr,B) ) ) ).

fof(addAssignment_43040,axiom,
    ! [VarCurr] :
      ( ( v132349(VarCurr,bitIndex11)
      <=> $false )
      & ( v132349(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_117,axiom,
    ! [VarCurr,B] :
      ( range_9_0(B)
     => ( v132350(VarCurr,B)
      <=> ( v132351(VarCurr,B)
          | v132353(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_116,axiom,
    ! [VarCurr,B] :
      ( range_9_0(B)
     => ( v132353(VarCurr,B)
      <=> ( v132354(VarCurr,B)
          & v132355(VarCurr,B) ) ) ) ).

fof(addAssignment_43039,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43038,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43037,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43036,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43035,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43034,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43033,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43032,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43031,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43030,axiom,
    ! [VarCurr] :
      ( v132355(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43029,axiom,
    ! [VarCurr] :
      ( ( v132354(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132354(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132354(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132354(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132354(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132354(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132354(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132354(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132354(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_43028,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex9)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2986,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132352(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2985,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132352(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2984,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132352(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2983,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132352(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2982,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132352(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2981,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132352(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2980,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132352(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2979,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132352(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2978,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132352(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2977,axiom,
    ! [VarCurr] :
      ( v132351(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132352(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_43027,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43026,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43025,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43024,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43023,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43022,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43021,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43020,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43019,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_43018,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_115,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132340(VarCurr,B)
      <=> ( v132341(VarCurr,B)
          & v132347(VarCurr,B) ) ) ) ).

fof(addAssignment_43017,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43016,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43015,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43014,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43013,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43012,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43011,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43010,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43009,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43008,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43007,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_43006,axiom,
    ! [VarCurr] :
      ( v132347(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_114,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132341(VarCurr,B)
      <=> ( v132342(VarCurr,B)
          | v132344(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_113,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132344(VarCurr,B)
      <=> ( v132345(VarCurr,B)
          & v132346(VarCurr,B) ) ) ) ).

fof(addAssignment_43005,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43004,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43003,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43002,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43001,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_43000,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42999,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42998,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42997,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42996,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42995,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42994,axiom,
    ! [VarCurr] :
      ( v132346(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42993,axiom,
    ! [VarCurr] :
      ( ( v132345(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132345(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132345(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132345(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132345(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132345(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132345(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132345(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132345(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132345(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132345(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex29) ) ) ).

fof(addAssignment_42992,axiom,
    ! [VarCurr] :
      ( v132345(VarCurr,bitIndex11)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2976,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132343(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2975,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132343(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2974,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132343(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2973,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132343(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2972,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132343(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2971,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132343(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2970,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132343(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2969,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132343(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2968,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132343(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2967,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132343(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2966,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132343(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2965,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132343(VarCurr,bitIndex11) ) ) ).

fof(addAssignment_42991,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42990,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42989,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42988,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42987,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42986,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42985,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42984,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42983,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42982,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42981,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42980,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_112,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132317(VarCurr,B)
      <=> ( v132318(VarCurr,B)
          & v132336(VarCurr,B) ) ) ) ).

fof(addAssignment_42979,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex0)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42978,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex1)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42977,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex2)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42976,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex3)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42975,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex4)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42974,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex5)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42973,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex6)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42972,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex7)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42971,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex8)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42970,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex9)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42969,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex10)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42968,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex11)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42967,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex12)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42966,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex13)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42965,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex14)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42964,axiom,
    ! [VarCurr] :
      ( v132336(VarCurr,bitIndex15)
    <=> v132078(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_111,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132318(VarCurr,B)
      <=> ( v132319(VarCurr,B)
          | v132327(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_110,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132327(VarCurr,B)
      <=> ( v132328(VarCurr,B)
          & v132335(VarCurr,B) ) ) ) ).

fof(addAssignment_42963,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42962,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42961,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42960,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42959,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42958,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42957,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42956,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42955,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42954,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42953,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42952,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42951,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42950,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42949,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42948,axiom,
    ! [VarCurr] :
      ( v132335(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42947,axiom,
    ! [VarCurr,B] :
      ( range_13_0(B)
     => ( v132328(VarCurr,B)
      <=> v132329(VarCurr,B) ) ) ).

fof(addAssignment_42946,axiom,
    ! [VarCurr] :
      ( ( v132328(VarCurr,bitIndex15)
      <=> $false )
      & ( v132328(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_109,axiom,
    ! [VarCurr,B] :
      ( range_13_0(B)
     => ( v132329(VarCurr,B)
      <=> ( v132330(VarCurr,B)
          | v132332(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_108,axiom,
    ! [VarCurr,B] :
      ( range_13_0(B)
     => ( v132332(VarCurr,B)
      <=> ( v132333(VarCurr,B)
          & v132334(VarCurr,B) ) ) ) ).

fof(addAssignment_42945,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42944,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42943,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42942,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42941,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42940,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42939,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42938,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42937,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42936,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42935,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42934,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42933,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42932,axiom,
    ! [VarCurr] :
      ( v132334(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42931,axiom,
    ! [VarCurr] :
      ( ( v132333(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132333(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132333(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132333(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132333(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132333(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132333(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132333(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132333(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132333(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132333(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132333(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132333(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex27) ) ) ).

fof(addAssignment_42930,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex13)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2964,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132331(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2963,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132331(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2962,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132331(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2961,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132331(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2960,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132331(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2959,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132331(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2958,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132331(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2957,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132331(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2956,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132331(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2955,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132331(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2954,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132331(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2953,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132331(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2952,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132331(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2951,axiom,
    ! [VarCurr] :
      ( v132330(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132331(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_42929,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42928,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42927,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42926,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42925,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42924,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42923,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42922,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42921,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42920,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42919,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42918,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42917,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42916,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_107,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132319(VarCurr,B)
      <=> ( v132320(VarCurr,B)
          & v132326(VarCurr,B) ) ) ) ).

fof(addAssignment_42915,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42914,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42913,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42912,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42911,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42910,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42909,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42908,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42907,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42906,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42905,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42904,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42903,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42902,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42901,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42900,axiom,
    ! [VarCurr] :
      ( v132326(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_106,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132320(VarCurr,B)
      <=> ( v132321(VarCurr,B)
          | v132323(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_105,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132323(VarCurr,B)
      <=> ( v132324(VarCurr,B)
          & v132325(VarCurr,B) ) ) ) ).

fof(addAssignment_42899,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42898,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42897,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42896,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42895,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42894,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42893,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42892,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42891,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42890,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42889,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42888,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42887,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42886,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42885,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42884,axiom,
    ! [VarCurr] :
      ( v132325(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42883,axiom,
    ! [VarCurr] :
      ( ( v132324(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132324(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132324(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132324(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132324(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132324(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132324(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132324(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132324(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132324(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132324(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132324(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132324(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132324(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132324(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex25) ) ) ).

fof(addAssignment_42882,axiom,
    ! [VarCurr] :
      ( v132324(VarCurr,bitIndex15)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2950,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132322(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2949,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132322(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2948,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132322(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2947,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132322(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2946,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132322(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2945,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132322(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2944,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132322(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2943,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132322(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2942,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132322(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2941,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132322(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2940,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132322(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2939,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132322(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2938,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132322(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2937,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132322(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2936,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132322(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2935,axiom,
    ! [VarCurr] :
      ( v132321(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132322(VarCurr,bitIndex15) ) ) ).

fof(addAssignment_42881,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42880,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42879,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42878,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42877,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42876,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42875,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42874,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42873,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42872,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42871,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42870,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42869,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42868,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42867,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42866,axiom,
    ! [VarCurr] :
      ( v132322(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_104,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132270(VarCurr,B)
      <=> ( v132271(VarCurr,B)
          & v132313(VarCurr,B) ) ) ) ).

fof(addAssignment_42865,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex0)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42864,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex1)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42863,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex2)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42862,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex3)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42861,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex4)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42860,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex5)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42859,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex6)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42858,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex7)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42857,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex8)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42856,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex9)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42855,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex10)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42854,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex11)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42853,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex12)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42852,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex13)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42851,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex14)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42850,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex15)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42849,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex16)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42848,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex17)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42847,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex18)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42846,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex19)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42845,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex20)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42844,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex21)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42843,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex22)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42842,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex23)
    <=> v132073(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_103,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132271(VarCurr,B)
      <=> ( v132272(VarCurr,B)
          | v132292(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_102,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132292(VarCurr,B)
      <=> ( v132293(VarCurr,B)
          & v132312(VarCurr,B) ) ) ) ).

fof(addAssignment_42841,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42840,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42839,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42838,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42837,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42836,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42835,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42834,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42833,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42832,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42831,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42830,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42829,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42828,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42827,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42826,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42825,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42824,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42823,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42822,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42821,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42820,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42819,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42818,axiom,
    ! [VarCurr] :
      ( v132312(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42817,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132293(VarCurr,B)
      <=> v132294(VarCurr,B) ) ) ).

fof(addAssignment_42816,axiom,
    ! [VarCurr] :
      ( ( v132293(VarCurr,bitIndex23)
      <=> $false )
      & ( v132293(VarCurr,bitIndex22)
      <=> $false )
      & ( v132293(VarCurr,bitIndex21)
      <=> $false )
      & ( v132293(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_101,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132294(VarCurr,B)
      <=> ( v132295(VarCurr,B)
          | v132303(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_100,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132303(VarCurr,B)
      <=> ( v132304(VarCurr,B)
          & v132311(VarCurr,B) ) ) ) ).

fof(addAssignment_42815,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42814,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42813,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42812,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42811,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42810,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42809,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42808,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42807,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42806,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42805,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42804,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42803,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42802,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42801,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42800,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42799,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42798,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42797,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42796,axiom,
    ! [VarCurr] :
      ( v132311(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42795,axiom,
    ! [VarCurr,B] :
      ( range_17_0(B)
     => ( v132304(VarCurr,B)
      <=> v132305(VarCurr,B) ) ) ).

fof(addAssignment_42794,axiom,
    ! [VarCurr] :
      ( ( v132304(VarCurr,bitIndex19)
      <=> $false )
      & ( v132304(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_99,axiom,
    ! [VarCurr,B] :
      ( range_17_0(B)
     => ( v132305(VarCurr,B)
      <=> ( v132306(VarCurr,B)
          | v132308(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_98,axiom,
    ! [VarCurr,B] :
      ( range_17_0(B)
     => ( v132308(VarCurr,B)
      <=> ( v132309(VarCurr,B)
          & v132310(VarCurr,B) ) ) ) ).

fof(addAssignment_42793,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42792,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42791,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42790,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42789,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42788,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42787,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42786,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42785,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42784,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42783,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42782,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42781,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42780,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42779,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42778,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42777,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42776,axiom,
    ! [VarCurr] :
      ( v132310(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42775,axiom,
    ! [VarCurr] :
      ( ( v132309(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132309(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132309(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132309(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132309(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132309(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132309(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132309(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132309(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132309(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132309(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132309(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132309(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132309(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132309(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132309(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132309(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex23) ) ) ).

fof(addAssignment_42774,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex17)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2934,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132307(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2933,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132307(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2932,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132307(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2931,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132307(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2930,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132307(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2929,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132307(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2928,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132307(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2927,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132307(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2926,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132307(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2925,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132307(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2924,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132307(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2923,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132307(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2922,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132307(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2921,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132307(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2920,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132307(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2919,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132307(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2918,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132307(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2917,axiom,
    ! [VarCurr] :
      ( v132306(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132307(VarCurr,bitIndex17) ) ) ).

fof(addAssignment_42773,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42772,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42771,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42770,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42769,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42768,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42767,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42766,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42765,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42764,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42763,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42762,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42761,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42760,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42759,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42758,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42757,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42756,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_97,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132295(VarCurr,B)
      <=> ( v132296(VarCurr,B)
          & v132302(VarCurr,B) ) ) ) ).

fof(addAssignment_42755,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42754,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42753,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42752,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42751,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42750,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42749,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42748,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42747,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42746,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42745,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42744,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42743,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42742,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42741,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42740,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42739,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex16)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42738,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex17)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42737,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex18)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42736,axiom,
    ! [VarCurr] :
      ( v132302(VarCurr,bitIndex19)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_96,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132296(VarCurr,B)
      <=> ( v132297(VarCurr,B)
          | v132299(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_95,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132299(VarCurr,B)
      <=> ( v132300(VarCurr,B)
          & v132301(VarCurr,B) ) ) ) ).

fof(addAssignment_42735,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42734,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42733,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42732,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42731,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42730,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42729,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42728,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42727,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42726,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42725,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42724,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42723,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42722,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42721,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42720,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42719,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42718,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42717,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42716,axiom,
    ! [VarCurr] :
      ( v132301(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42715,axiom,
    ! [VarCurr] :
      ( ( v132300(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132300(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132300(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132300(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132300(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132300(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132300(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132300(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132300(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132300(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132300(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132300(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132300(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132300(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132300(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132300(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132300(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132300(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132300(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex21) ) ) ).

fof(addAssignment_42714,axiom,
    ! [VarCurr] :
      ( v132300(VarCurr,bitIndex19)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2916,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132298(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2915,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132298(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2914,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132298(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2913,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132298(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2912,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132298(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2911,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132298(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2910,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132298(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2909,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132298(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2908,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132298(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2907,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132298(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2906,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132298(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2905,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132298(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2904,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132298(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2903,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132298(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2902,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132298(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2901,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132298(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2900,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132298(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2899,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132298(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2898,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132298(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2897,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132298(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_42713,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42712,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42711,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42710,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42709,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42708,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42707,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42706,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42705,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42704,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42703,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42702,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42701,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42700,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42699,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42698,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42697,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42696,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42695,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42694,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_94,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132272(VarCurr,B)
      <=> ( v132273(VarCurr,B)
          & v132291(VarCurr,B) ) ) ) ).

fof(addAssignment_42693,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex0)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42692,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex1)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42691,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex2)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42690,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex3)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42689,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex4)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42688,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex5)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42687,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex6)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42686,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex7)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42685,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex8)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42684,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex9)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42683,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex10)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42682,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex11)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42681,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex12)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42680,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex13)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42679,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex14)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42678,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex15)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42677,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex16)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42676,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex17)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42675,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex18)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42674,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex19)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42673,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex20)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42672,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex21)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42671,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex22)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42670,axiom,
    ! [VarCurr] :
      ( v132291(VarCurr,bitIndex23)
    <=> v132078(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_93,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132273(VarCurr,B)
      <=> ( v132274(VarCurr,B)
          | v132282(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_92,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132282(VarCurr,B)
      <=> ( v132283(VarCurr,B)
          & v132290(VarCurr,B) ) ) ) ).

fof(addAssignment_42669,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42668,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42667,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42666,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42665,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42664,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42663,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42662,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42661,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42660,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42659,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42658,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42657,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42656,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42655,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42654,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42653,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42652,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42651,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42650,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42649,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42648,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42647,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42646,axiom,
    ! [VarCurr] :
      ( v132290(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42645,axiom,
    ! [VarCurr,B] :
      ( range_21_0(B)
     => ( v132283(VarCurr,B)
      <=> v132284(VarCurr,B) ) ) ).

fof(addAssignment_42644,axiom,
    ! [VarCurr] :
      ( ( v132283(VarCurr,bitIndex23)
      <=> $false )
      & ( v132283(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_91,axiom,
    ! [VarCurr,B] :
      ( range_21_0(B)
     => ( v132284(VarCurr,B)
      <=> ( v132285(VarCurr,B)
          | v132287(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_90,axiom,
    ! [VarCurr,B] :
      ( range_21_0(B)
     => ( v132287(VarCurr,B)
      <=> ( v132288(VarCurr,B)
          & v132289(VarCurr,B) ) ) ) ).

fof(range_axiom_196,axiom,
    ! [B] :
      ( range_21_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B ) ) ).

fof(addAssignment_42643,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42642,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42641,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42640,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42639,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42638,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42637,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42636,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42635,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42634,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42633,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42632,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42631,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42630,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42629,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42628,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42627,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42626,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42625,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42624,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42623,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42622,axiom,
    ! [VarCurr] :
      ( v132289(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42621,axiom,
    ! [VarCurr] :
      ( ( v132288(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132288(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132288(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132288(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132288(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132288(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132288(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132288(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132288(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132288(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132288(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132288(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132288(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132288(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132288(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132288(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132288(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132288(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132288(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132288(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132288(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_42620,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex21)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2896,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132286(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2895,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132286(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2894,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132286(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2893,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132286(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2892,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132286(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2891,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132286(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2890,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132286(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2889,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132286(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2888,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132286(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2887,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132286(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2886,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132286(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2885,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132286(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2884,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132286(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2883,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132286(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2882,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132286(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2881,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132286(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2880,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132286(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2879,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132286(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2878,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132286(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2877,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132286(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2876,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132286(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2875,axiom,
    ! [VarCurr] :
      ( v132285(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132286(VarCurr,bitIndex21) ) ) ).

fof(addAssignment_42619,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42618,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42617,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42616,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42615,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42614,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42613,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42612,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42611,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42610,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42609,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42608,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42607,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42606,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42605,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42604,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42603,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42602,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42601,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42600,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42599,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42598,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_89,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132274(VarCurr,B)
      <=> ( v132275(VarCurr,B)
          & v132281(VarCurr,B) ) ) ) ).

fof(addAssignment_42597,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42596,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42595,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42594,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42593,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42592,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42591,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42590,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42589,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42588,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42587,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42586,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42585,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42584,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42583,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42582,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42581,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex16)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42580,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex17)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42579,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex18)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42578,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex19)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42577,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex20)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42576,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex21)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42575,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex22)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42574,axiom,
    ! [VarCurr] :
      ( v132281(VarCurr,bitIndex23)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_88,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132275(VarCurr,B)
      <=> ( v132276(VarCurr,B)
          | v132278(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_87,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132278(VarCurr,B)
      <=> ( v132279(VarCurr,B)
          & v132280(VarCurr,B) ) ) ) ).

fof(addAssignment_42573,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42572,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42571,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42570,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42569,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42568,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42567,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42566,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42565,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42564,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42563,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42562,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42561,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42560,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42559,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42558,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42557,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42556,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42555,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42554,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42553,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42552,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42551,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42550,axiom,
    ! [VarCurr] :
      ( v132280(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42549,axiom,
    ! [VarCurr] :
      ( ( v132279(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132279(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132279(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132279(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132279(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132279(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132279(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132279(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132279(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132279(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132279(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132279(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132279(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132279(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132279(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132279(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132279(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132279(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132279(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132279(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132279(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132279(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132279(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex17) ) ) ).

fof(addAssignment_42548,axiom,
    ! [VarCurr] :
      ( v132279(VarCurr,bitIndex23)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2874,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132277(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2873,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132277(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2872,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132277(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2871,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132277(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2870,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132277(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2869,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132277(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2868,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132277(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2867,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132277(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2866,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132277(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2865,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132277(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2864,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132277(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2863,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132277(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2862,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132277(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2861,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132277(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2860,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132277(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2859,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132277(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2858,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132277(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2857,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132277(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2856,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132277(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2855,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132277(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2854,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132277(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2853,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132277(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2852,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132277(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2851,axiom,
    ! [VarCurr] :
      ( v132276(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132277(VarCurr,bitIndex23) ) ) ).

fof(addAssignment_42547,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42546,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42545,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42544,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42543,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42542,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42541,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42540,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42539,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42538,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42537,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42536,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42535,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42534,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42533,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42532,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42531,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42530,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42529,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42528,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42527,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42526,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42525,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42524,axiom,
    ! [VarCurr] :
      ( v132277(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_86,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132173(VarCurr,B)
      <=> ( v132174(VarCurr,B)
          & v132265(VarCurr,B) ) ) ) ).

fof(addAssignment_42523,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex0)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42522,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex1)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42521,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex2)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42520,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex3)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42519,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex4)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42518,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex5)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42517,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex6)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42516,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex7)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42515,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex8)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42514,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex9)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42513,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex10)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42512,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex11)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42511,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex12)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42510,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex13)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42509,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex14)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42508,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex15)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42507,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex16)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42506,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex17)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42505,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex18)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42504,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex19)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42503,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex20)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42502,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex21)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42501,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex22)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42500,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex23)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42499,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex24)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42498,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex25)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42497,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex26)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42496,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex27)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42495,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex28)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42494,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex29)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42493,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex30)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42492,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex31)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42491,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex32)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42490,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex33)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42489,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex34)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42488,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex35)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42487,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex36)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42486,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex37)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42485,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex38)
    <=> v132068(VarCurr) ) ).

fof(addAssignment_42484,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex39)
    <=> v132068(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_85,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132174(VarCurr,B)
      <=> ( v132175(VarCurr,B)
          | v132220(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_84,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132220(VarCurr,B)
      <=> ( v132221(VarCurr,B)
          & v132264(VarCurr,B) ) ) ) ).

fof(addAssignment_42483,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42482,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42481,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42480,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42479,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42478,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42477,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42476,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42475,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42474,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42473,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42472,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42471,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42470,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42469,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42468,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42467,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42466,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42465,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42464,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42463,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42462,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42461,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42460,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42459,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42458,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42457,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42456,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42455,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42454,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42453,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42452,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42451,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42450,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42449,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42448,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42447,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex36)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42446,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex37)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42445,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex38)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42444,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex39)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(addAssignment_42443,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132221(VarCurr,B)
      <=> v132222(VarCurr,B) ) ) ).

fof(addAssignment_42442,axiom,
    ! [VarCurr] :
      ( ( v132221(VarCurr,bitIndex39)
      <=> $false )
      & ( v132221(VarCurr,bitIndex38)
      <=> $false )
      & ( v132221(VarCurr,bitIndex37)
      <=> $false )
      & ( v132221(VarCurr,bitIndex36)
      <=> $false )
      & ( v132221(VarCurr,bitIndex35)
      <=> $false )
      & ( v132221(VarCurr,bitIndex34)
      <=> $false )
      & ( v132221(VarCurr,bitIndex33)
      <=> $false )
      & ( v132221(VarCurr,bitIndex32)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_83,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132222(VarCurr,B)
      <=> ( v132223(VarCurr,B)
          | v132243(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_82,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132243(VarCurr,B)
      <=> ( v132244(VarCurr,B)
          & v132263(VarCurr,B) ) ) ) ).

fof(addAssignment_42441,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42440,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42439,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42438,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42437,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42436,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42435,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42434,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42433,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42432,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42431,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42430,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42429,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42428,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42427,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42426,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42425,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42424,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42423,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42422,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42421,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42420,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42419,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42418,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42417,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42416,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42415,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42414,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42413,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42412,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42411,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42410,axiom,
    ! [VarCurr] :
      ( v132263(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_42409,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132244(VarCurr,B)
      <=> v132245(VarCurr,B) ) ) ).

fof(addAssignment_42408,axiom,
    ! [VarCurr] :
      ( ( v132244(VarCurr,bitIndex31)
      <=> $false )
      & ( v132244(VarCurr,bitIndex30)
      <=> $false )
      & ( v132244(VarCurr,bitIndex29)
      <=> $false )
      & ( v132244(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_81,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132245(VarCurr,B)
      <=> ( v132246(VarCurr,B)
          | v132254(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_80,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132254(VarCurr,B)
      <=> ( v132255(VarCurr,B)
          & v132262(VarCurr,B) ) ) ) ).

fof(addAssignment_42407,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42406,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42405,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42404,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42403,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42402,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42401,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42400,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42399,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42398,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42397,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42396,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42395,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42394,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42393,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42392,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42391,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42390,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42389,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42388,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42387,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42386,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42385,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42384,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42383,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42382,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42381,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42380,axiom,
    ! [VarCurr] :
      ( v132262(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42379,axiom,
    ! [VarCurr,B] :
      ( range_25_0(B)
     => ( v132255(VarCurr,B)
      <=> v132256(VarCurr,B) ) ) ).

fof(addAssignment_42378,axiom,
    ! [VarCurr] :
      ( ( v132255(VarCurr,bitIndex27)
      <=> $false )
      & ( v132255(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_79,axiom,
    ! [VarCurr,B] :
      ( range_25_0(B)
     => ( v132256(VarCurr,B)
      <=> ( v132257(VarCurr,B)
          | v132259(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_78,axiom,
    ! [VarCurr,B] :
      ( range_25_0(B)
     => ( v132259(VarCurr,B)
      <=> ( v132260(VarCurr,B)
          & v132261(VarCurr,B) ) ) ) ).

fof(addAssignment_42377,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42376,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42375,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42374,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42373,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42372,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42371,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42370,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42369,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42368,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42367,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42366,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42365,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42364,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42363,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42362,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42361,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42360,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42359,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42358,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42357,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42356,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42355,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42354,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42353,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42352,axiom,
    ! [VarCurr] :
      ( v132261(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42351,axiom,
    ! [VarCurr] :
      ( ( v132260(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132260(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132260(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132260(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132260(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132260(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132260(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132260(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132260(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132260(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132260(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132260(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132260(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132260(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132260(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132260(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132260(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132260(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132260(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132260(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132260(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132260(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132260(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132260(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132260(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex15) ) ) ).

fof(addAssignment_42350,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex25)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2850,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132258(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2849,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132258(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2848,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132258(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2847,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132258(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2846,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132258(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2845,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132258(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2844,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132258(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2843,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132258(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2842,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132258(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2841,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132258(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2840,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132258(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2839,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132258(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2838,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132258(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2837,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132258(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2836,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132258(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2835,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132258(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2834,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132258(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2833,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132258(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2832,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132258(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2831,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132258(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2830,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132258(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2829,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132258(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2828,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132258(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2827,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132258(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2826,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132258(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2825,axiom,
    ! [VarCurr] :
      ( v132257(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132258(VarCurr,bitIndex25) ) ) ).

fof(addAssignment_42349,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42348,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42347,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42346,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42345,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42344,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42343,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42342,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42341,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42340,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42339,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42338,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42337,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42336,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42335,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42334,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42333,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42332,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42331,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42330,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42329,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42328,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42327,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42326,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42325,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42324,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_77,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132246(VarCurr,B)
      <=> ( v132247(VarCurr,B)
          & v132253(VarCurr,B) ) ) ) ).

fof(addAssignment_42323,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42322,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42321,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42320,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42319,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42318,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42317,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42316,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42315,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42314,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42313,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42312,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42311,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42310,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42309,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42308,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42307,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex16)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42306,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex17)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42305,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex18)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42304,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex19)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42303,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex20)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42302,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex21)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42301,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex22)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42300,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex23)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42299,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex24)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42298,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex25)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42297,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex26)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42296,axiom,
    ! [VarCurr] :
      ( v132253(VarCurr,bitIndex27)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_76,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132247(VarCurr,B)
      <=> ( v132248(VarCurr,B)
          | v132250(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_75,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132250(VarCurr,B)
      <=> ( v132251(VarCurr,B)
          & v132252(VarCurr,B) ) ) ) ).

fof(addAssignment_42295,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42294,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42293,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42292,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42291,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42290,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42289,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42288,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42287,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42286,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42285,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42284,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42283,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42282,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42281,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42280,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42279,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42278,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42277,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42276,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42275,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42274,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42273,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42272,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42271,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42270,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42269,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42268,axiom,
    ! [VarCurr] :
      ( v132252(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42267,axiom,
    ! [VarCurr] :
      ( ( v132251(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132251(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132251(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132251(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132251(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132251(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132251(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132251(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132251(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132251(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132251(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132251(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132251(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132251(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132251(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132251(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132251(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132251(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132251(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132251(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132251(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132251(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132251(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132251(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132251(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132251(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132251(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_42266,axiom,
    ! [VarCurr] :
      ( v132251(VarCurr,bitIndex27)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2824,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex12)
        & v132249(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2823,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex13)
        & v132249(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2822,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132249(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2821,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132249(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2820,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132249(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2819,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132249(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2818,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132249(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2817,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132249(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2816,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132249(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2815,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132249(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2814,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132249(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2813,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132249(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2812,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132249(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2811,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132249(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2810,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132249(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2809,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132249(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2808,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132249(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2807,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132249(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2806,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132249(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2805,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132249(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2804,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132249(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2803,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132249(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2802,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132249(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2801,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132249(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2800,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132249(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2799,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132249(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2798,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex26)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132249(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2797,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex27)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132249(VarCurr,bitIndex27) ) ) ).

fof(addAssignment_42265,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42264,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42263,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42262,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42261,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42260,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42259,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42258,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42257,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42256,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42255,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42254,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42253,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42252,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42251,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42250,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42249,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42248,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42247,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42246,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42245,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42244,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42243,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42242,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42241,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42240,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42239,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42238,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_74,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132223(VarCurr,B)
      <=> ( v132224(VarCurr,B)
          & v132242(VarCurr,B) ) ) ) ).

fof(addAssignment_42237,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex0)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42236,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex1)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42235,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex2)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42234,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex3)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42233,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex4)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42232,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex5)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42231,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex6)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42230,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex7)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42229,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex8)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42228,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex9)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42227,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex10)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42226,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex11)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42225,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex12)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42224,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex13)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42223,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex14)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42222,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex15)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42221,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex16)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42220,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex17)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42219,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex18)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42218,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex19)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42217,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex20)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42216,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex21)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42215,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex22)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42214,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex23)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42213,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex24)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42212,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex25)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42211,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex26)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42210,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex27)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42209,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex28)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42208,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex29)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42207,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex30)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_42206,axiom,
    ! [VarCurr] :
      ( v132242(VarCurr,bitIndex31)
    <=> v132078(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_73,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132224(VarCurr,B)
      <=> ( v132225(VarCurr,B)
          | v132233(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_72,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132233(VarCurr,B)
      <=> ( v132234(VarCurr,B)
          & v132241(VarCurr,B) ) ) ) ).

fof(addAssignment_42205,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42204,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42203,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42202,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42201,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42200,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42199,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42198,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42197,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42196,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42195,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42194,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42193,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42192,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42191,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42190,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42189,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42188,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42187,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42186,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42185,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42184,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42183,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42182,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42181,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42180,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42179,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42178,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42177,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42176,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42175,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42174,axiom,
    ! [VarCurr] :
      ( v132241(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_42173,axiom,
    ! [VarCurr,B] :
      ( range_29_0(B)
     => ( v132234(VarCurr,B)
      <=> v132235(VarCurr,B) ) ) ).

fof(addAssignment_42172,axiom,
    ! [VarCurr] :
      ( ( v132234(VarCurr,bitIndex31)
      <=> $false )
      & ( v132234(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_71,axiom,
    ! [VarCurr,B] :
      ( range_29_0(B)
     => ( v132235(VarCurr,B)
      <=> ( v132236(VarCurr,B)
          | v132238(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_70,axiom,
    ! [VarCurr,B] :
      ( range_29_0(B)
     => ( v132238(VarCurr,B)
      <=> ( v132239(VarCurr,B)
          & v132240(VarCurr,B) ) ) ) ).

fof(range_axiom_195,axiom,
    ! [B] :
      ( range_29_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B ) ) ).

fof(addAssignment_42171,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42170,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42169,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42168,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42167,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42166,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42165,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42164,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42163,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42162,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42161,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42160,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42159,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42158,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42157,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42156,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42155,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42154,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42153,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42152,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42151,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42150,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42149,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42148,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42147,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42146,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42145,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42144,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42143,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42142,axiom,
    ! [VarCurr] :
      ( v132240(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42141,axiom,
    ! [VarCurr] :
      ( ( v132239(VarCurr,bitIndex28)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132239(VarCurr,bitIndex27)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132239(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132239(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132239(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132239(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132239(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132239(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132239(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132239(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132239(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132239(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132239(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132239(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132239(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132239(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132239(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132239(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132239(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132239(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132239(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132239(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132239(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132239(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132239(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132239(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132239(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex13) )
      & ( v132239(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex12) )
      & ( v132239(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex11) ) ) ).

fof(addAssignment_42140,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex29)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2796,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex10)
        & v132237(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2795,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex11)
        & v132237(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2794,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex12)
        & v132237(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2793,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex13)
        & v132237(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2792,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132237(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2791,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132237(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2790,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132237(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2789,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132237(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2788,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132237(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2787,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132237(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2786,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132237(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2785,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132237(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2784,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132237(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2783,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132237(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2782,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132237(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2781,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132237(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2780,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132237(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2779,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132237(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2778,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132237(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2777,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132237(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2776,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132237(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2775,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132237(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2774,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132237(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2773,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132237(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2772,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132237(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2771,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132237(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2770,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex26)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132237(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2769,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex27)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132237(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2768,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex28)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132237(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2767,axiom,
    ! [VarCurr] :
      ( v132236(VarCurr,bitIndex29)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132237(VarCurr,bitIndex29) ) ) ).

fof(addAssignment_42139,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42138,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42137,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42136,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42135,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42134,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42133,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42132,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42131,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42130,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42129,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42128,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42127,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42126,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42125,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42124,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42123,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42122,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42121,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42120,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42119,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42118,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42117,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42116,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42115,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42114,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42113,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42112,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42111,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex28)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42110,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex29)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_69,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132225(VarCurr,B)
      <=> ( v132226(VarCurr,B)
          & v132232(VarCurr,B) ) ) ) ).

fof(addAssignment_42109,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42108,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42107,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42106,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42105,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42104,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42103,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42102,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42101,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42100,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42099,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42098,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42097,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42096,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42095,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42094,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42093,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex16)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42092,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex17)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42091,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex18)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42090,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex19)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42089,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex20)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42088,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex21)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42087,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex22)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42086,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex23)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42085,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex24)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42084,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex25)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42083,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex26)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42082,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex27)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42081,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex28)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42080,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex29)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42079,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex30)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_42078,axiom,
    ! [VarCurr] :
      ( v132232(VarCurr,bitIndex31)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_68,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132226(VarCurr,B)
      <=> ( v132227(VarCurr,B)
          | v132229(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_67,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132229(VarCurr,B)
      <=> ( v132230(VarCurr,B)
          & v132231(VarCurr,B) ) ) ) ).

fof(addAssignment_42077,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42076,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42075,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42074,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42073,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42072,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42071,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42070,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42069,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42068,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42067,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42066,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42065,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42064,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42063,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42062,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42061,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42060,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42059,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42058,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42057,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42056,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42055,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42054,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42053,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42052,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42051,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42050,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42049,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42048,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42047,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42046,axiom,
    ! [VarCurr] :
      ( v132231(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_42045,axiom,
    ! [VarCurr] :
      ( ( v132230(VarCurr,bitIndex30)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132230(VarCurr,bitIndex29)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132230(VarCurr,bitIndex28)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132230(VarCurr,bitIndex27)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132230(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132230(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132230(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132230(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132230(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132230(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132230(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132230(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132230(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132230(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132230(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132230(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132230(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132230(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132230(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132230(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132230(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132230(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132230(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132230(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132230(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132230(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132230(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex13) )
      & ( v132230(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex12) )
      & ( v132230(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex11) )
      & ( v132230(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex10) )
      & ( v132230(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_42044,axiom,
    ! [VarCurr] :
      ( v132230(VarCurr,bitIndex31)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2766,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex8)
        & v132228(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2765,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex9)
        & v132228(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2764,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex10)
        & v132228(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2763,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex11)
        & v132228(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2762,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex12)
        & v132228(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2761,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex13)
        & v132228(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2760,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132228(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2759,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132228(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2758,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132228(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2757,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132228(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2756,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132228(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2755,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132228(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2754,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132228(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2753,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132228(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2752,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132228(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2751,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132228(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2750,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132228(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2749,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132228(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2748,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132228(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2747,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132228(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2746,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132228(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2745,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132228(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2744,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132228(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2743,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132228(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2742,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132228(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2741,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132228(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2740,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex26)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132228(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2739,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex27)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132228(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2738,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex28)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132228(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2737,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex29)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132228(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2736,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex30)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132228(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2735,axiom,
    ! [VarCurr] :
      ( v132227(VarCurr,bitIndex31)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132228(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_42043,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42042,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42041,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42040,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42039,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42038,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42037,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42036,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42035,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42034,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42033,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42032,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42031,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42030,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42029,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42028,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42027,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42026,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42025,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42024,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42023,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42022,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42021,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42020,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42019,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42018,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42017,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42016,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42015,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex28)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42014,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex29)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42013,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex30)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_42012,axiom,
    ! [VarCurr] :
      ( v132228(VarCurr,bitIndex31)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_66,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132175(VarCurr,B)
      <=> ( v132176(VarCurr,B)
          & v132219(VarCurr,B) ) ) ) ).

fof(addAssignment_42011,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex0)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42010,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex1)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42009,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex2)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42008,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex3)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42007,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex4)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42006,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex5)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42005,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex6)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42004,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex7)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42003,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex8)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42002,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex9)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42001,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex10)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_42000,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex11)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41999,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex12)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41998,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex13)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41997,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex14)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41996,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex15)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41995,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex16)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41994,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex17)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41993,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex18)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41992,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex19)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41991,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex20)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41990,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex21)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41989,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex22)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41988,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex23)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41987,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex24)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41986,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex25)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41985,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex26)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41984,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex27)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41983,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex28)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41982,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex29)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41981,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex30)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41980,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex31)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41979,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex32)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41978,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex33)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41977,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex34)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41976,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex35)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41975,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex36)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41974,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex37)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41973,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex38)
    <=> v132073(VarCurr) ) ).

fof(addAssignment_41972,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex39)
    <=> v132073(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_65,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132176(VarCurr,B)
      <=> ( v132177(VarCurr,B)
          | v132198(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_64,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132198(VarCurr,B)
      <=> ( v132199(VarCurr,B)
          & v132218(VarCurr,B) ) ) ) ).

fof(addAssignment_41971,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41970,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41969,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41968,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41967,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41966,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41965,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41964,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41963,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41962,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41961,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41960,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41959,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41958,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41957,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41956,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41955,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41954,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41953,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41952,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41951,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41950,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41949,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41948,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41947,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41946,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41945,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41944,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41943,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41942,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41941,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41940,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41939,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41938,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41937,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41936,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41935,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex36)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41934,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex37)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41933,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex38)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41932,axiom,
    ! [VarCurr] :
      ( v132218(VarCurr,bitIndex39)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(addAssignment_41931,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132199(VarCurr,B)
      <=> v132200(VarCurr,B) ) ) ).

fof(addAssignment_41930,axiom,
    ! [VarCurr] :
      ( ( v132199(VarCurr,bitIndex39)
      <=> $false )
      & ( v132199(VarCurr,bitIndex38)
      <=> $false )
      & ( v132199(VarCurr,bitIndex37)
      <=> $false )
      & ( v132199(VarCurr,bitIndex36)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_63,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132200(VarCurr,B)
      <=> ( v132201(VarCurr,B)
          | v132209(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_62,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132209(VarCurr,B)
      <=> ( v132210(VarCurr,B)
          & v132217(VarCurr,B) ) ) ) ).

fof(addAssignment_41929,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41928,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41927,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41926,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41925,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41924,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41923,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41922,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41921,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41920,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41919,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41918,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41917,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41916,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41915,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41914,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41913,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41912,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41911,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41910,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41909,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41908,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41907,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41906,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41905,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41904,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41903,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41902,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41901,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41900,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41899,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41898,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41897,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41896,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41895,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41894,axiom,
    ! [VarCurr] :
      ( v132217(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41893,axiom,
    ! [VarCurr,B] :
      ( range_33_0(B)
     => ( v132210(VarCurr,B)
      <=> v132211(VarCurr,B) ) ) ).

fof(addAssignment_41892,axiom,
    ! [VarCurr] :
      ( ( v132210(VarCurr,bitIndex35)
      <=> $false )
      & ( v132210(VarCurr,bitIndex34)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_61,axiom,
    ! [VarCurr,B] :
      ( range_33_0(B)
     => ( v132211(VarCurr,B)
      <=> ( v132212(VarCurr,B)
          | v132214(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_60,axiom,
    ! [VarCurr,B] :
      ( range_33_0(B)
     => ( v132214(VarCurr,B)
      <=> ( v132215(VarCurr,B)
          & v132216(VarCurr,B) ) ) ) ).

fof(range_axiom_194,axiom,
    ! [B] :
      ( range_33_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B ) ) ).

fof(addAssignment_41891,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41890,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41889,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41888,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41887,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41886,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41885,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41884,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41883,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41882,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41881,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41880,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41879,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41878,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41877,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41876,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41875,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41874,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41873,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41872,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41871,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41870,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41869,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41868,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41867,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41866,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41865,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41864,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41863,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41862,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41861,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41860,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41859,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41858,axiom,
    ! [VarCurr] :
      ( v132216(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41857,axiom,
    ! [VarCurr] :
      ( ( v132215(VarCurr,bitIndex32)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132215(VarCurr,bitIndex31)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132215(VarCurr,bitIndex30)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132215(VarCurr,bitIndex29)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132215(VarCurr,bitIndex28)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132215(VarCurr,bitIndex27)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132215(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132215(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132215(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132215(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132215(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132215(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132215(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132215(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132215(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132215(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132215(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132215(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132215(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132215(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132215(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132215(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132215(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132215(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132215(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132215(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132215(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex13) )
      & ( v132215(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex12) )
      & ( v132215(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex11) )
      & ( v132215(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex10) )
      & ( v132215(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex9) )
      & ( v132215(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex8) )
      & ( v132215(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex7) ) ) ).

fof(addAssignment_41856,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex33)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2734,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex6)
        & v132213(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2733,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex7)
        & v132213(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2732,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex8)
        & v132213(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2731,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex9)
        & v132213(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2730,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex10)
        & v132213(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2729,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex11)
        & v132213(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2728,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex12)
        & v132213(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2727,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex13)
        & v132213(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2726,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132213(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2725,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132213(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2724,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132213(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2723,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132213(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2722,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132213(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2721,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132213(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2720,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132213(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2719,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132213(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2718,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132213(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2717,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132213(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2716,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132213(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2715,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132213(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2714,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132213(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2713,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132213(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2712,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132213(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2711,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132213(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2710,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132213(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2709,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132213(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2708,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex26)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132213(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2707,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex27)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132213(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2706,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex28)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132213(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2705,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex29)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132213(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2704,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex30)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132213(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2703,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex31)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132213(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2702,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex32)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132213(VarCurr,bitIndex32) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2701,axiom,
    ! [VarCurr] :
      ( v132212(VarCurr,bitIndex33)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132213(VarCurr,bitIndex33) ) ) ).

fof(addAssignment_41855,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41854,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41853,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41852,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41851,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41850,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41849,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41848,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41847,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41846,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41845,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41844,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41843,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41842,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41841,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41840,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41839,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41838,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41837,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41836,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41835,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41834,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41833,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41832,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41831,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41830,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41829,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41828,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41827,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex28)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41826,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex29)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41825,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex30)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41824,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex31)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41823,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex32)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41822,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex33)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_59,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132201(VarCurr,B)
      <=> ( v132202(VarCurr,B)
          & v132208(VarCurr,B) ) ) ) ).

fof(addAssignment_41821,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41820,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41819,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41818,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41817,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41816,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41815,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41814,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41813,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41812,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41811,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41810,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41809,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41808,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41807,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41806,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41805,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex16)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41804,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex17)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41803,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex18)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41802,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex19)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41801,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex20)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41800,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex21)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41799,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex22)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41798,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex23)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41797,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex24)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41796,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex25)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41795,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex26)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41794,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex27)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41793,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex28)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41792,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex29)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41791,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex30)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41790,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex31)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41789,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex32)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41788,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex33)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41787,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex34)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41786,axiom,
    ! [VarCurr] :
      ( v132208(VarCurr,bitIndex35)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_58,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132202(VarCurr,B)
      <=> ( v132203(VarCurr,B)
          | v132205(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_57,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132205(VarCurr,B)
      <=> ( v132206(VarCurr,B)
          & v132207(VarCurr,B) ) ) ) ).

fof(addAssignment_41785,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41784,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41783,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41782,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41781,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41780,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41779,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41778,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41777,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41776,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41775,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41774,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41773,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41772,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41771,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41770,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41769,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41768,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41767,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41766,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41765,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41764,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41763,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41762,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41761,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41760,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41759,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41758,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41757,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41756,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41755,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41754,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41753,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41752,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41751,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41750,axiom,
    ! [VarCurr] :
      ( v132207(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41749,axiom,
    ! [VarCurr] :
      ( ( v132206(VarCurr,bitIndex34)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132206(VarCurr,bitIndex33)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132206(VarCurr,bitIndex32)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132206(VarCurr,bitIndex31)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132206(VarCurr,bitIndex30)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132206(VarCurr,bitIndex29)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132206(VarCurr,bitIndex28)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132206(VarCurr,bitIndex27)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132206(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132206(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132206(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132206(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132206(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132206(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132206(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132206(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132206(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132206(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132206(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132206(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132206(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132206(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132206(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132206(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132206(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132206(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132206(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex13) )
      & ( v132206(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex12) )
      & ( v132206(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex11) )
      & ( v132206(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex10) )
      & ( v132206(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex9) )
      & ( v132206(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex8) )
      & ( v132206(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex7) )
      & ( v132206(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex6) )
      & ( v132206(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex5) ) ) ).

fof(addAssignment_41748,axiom,
    ! [VarCurr] :
      ( v132206(VarCurr,bitIndex35)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2700,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex4)
        & v132204(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2699,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex5)
        & v132204(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2698,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex6)
        & v132204(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2697,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex7)
        & v132204(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2696,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex8)
        & v132204(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2695,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex9)
        & v132204(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2694,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex10)
        & v132204(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2693,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex11)
        & v132204(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2692,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex12)
        & v132204(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2691,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex13)
        & v132204(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2690,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132204(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2689,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132204(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2688,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132204(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2687,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132204(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2686,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132204(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2685,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132204(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2684,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132204(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2683,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132204(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2682,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132204(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2681,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132204(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2680,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132204(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2679,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132204(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2678,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132204(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2677,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132204(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2676,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132204(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2675,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132204(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2674,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex26)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132204(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2673,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex27)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132204(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2672,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex28)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132204(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2671,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex29)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132204(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2670,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex30)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132204(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2669,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex31)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132204(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2668,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex32)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132204(VarCurr,bitIndex32) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2667,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex33)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132204(VarCurr,bitIndex33) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2666,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex34)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132204(VarCurr,bitIndex34) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2665,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex35)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132204(VarCurr,bitIndex35) ) ) ).

fof(addAssignment_41747,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41746,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41745,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41744,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41743,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41742,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41741,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41740,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41739,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41738,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41737,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41736,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41735,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41734,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41733,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41732,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41731,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41730,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41729,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41728,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41727,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41726,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41725,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41724,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41723,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41722,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41721,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41720,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41719,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex28)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41718,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex29)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41717,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex30)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41716,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex31)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41715,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex32)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41714,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex33)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41713,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex34)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41712,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex35)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_56,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132177(VarCurr,B)
      <=> ( v132178(VarCurr,B)
          & v132197(VarCurr,B) ) ) ) ).

fof(addAssignment_41711,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex0)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41710,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex1)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41709,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex2)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41708,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex3)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41707,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex4)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41706,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex5)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41705,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex6)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41704,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex7)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41703,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex8)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41702,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex9)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41701,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex10)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41700,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex11)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41699,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex12)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41698,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex13)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41697,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex14)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41696,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex15)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41695,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex16)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41694,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex17)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41693,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex18)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41692,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex19)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41691,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex20)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41690,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex21)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41689,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex22)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41688,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex23)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41687,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex24)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41686,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex25)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41685,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex26)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41684,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex27)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41683,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex28)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41682,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex29)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41681,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex30)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41680,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex31)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41679,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex32)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41678,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex33)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41677,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex34)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41676,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex35)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41675,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex36)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41674,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex37)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41673,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex38)
    <=> v132078(VarCurr) ) ).

fof(addAssignment_41672,axiom,
    ! [VarCurr] :
      ( v132197(VarCurr,bitIndex39)
    <=> v132078(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_55,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132178(VarCurr,B)
      <=> ( v132179(VarCurr,B)
          | v132188(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_54,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132188(VarCurr,B)
      <=> ( v132189(VarCurr,B)
          & v132196(VarCurr,B) ) ) ) ).

fof(addAssignment_41671,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41670,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41669,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41668,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41667,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41666,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41665,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41664,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41663,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41662,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41661,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41660,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41659,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41658,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41657,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41656,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41655,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41654,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41653,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41652,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41651,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41650,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41649,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41648,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41647,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41646,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41645,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41644,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41643,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41642,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41641,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41640,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41639,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41638,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41637,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41636,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41635,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex36)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41634,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex37)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41633,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex38)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41632,axiom,
    ! [VarCurr] :
      ( v132196(VarCurr,bitIndex39)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(addAssignment_41631,axiom,
    ! [VarCurr,B] :
      ( range_37_0(B)
     => ( v132189(VarCurr,B)
      <=> v132190(VarCurr,B) ) ) ).

fof(addAssignment_41630,axiom,
    ! [VarCurr] :
      ( ( v132189(VarCurr,bitIndex39)
      <=> $false )
      & ( v132189(VarCurr,bitIndex38)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_53,axiom,
    ! [VarCurr,B] :
      ( range_37_0(B)
     => ( v132190(VarCurr,B)
      <=> ( v132191(VarCurr,B)
          | v132193(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_52,axiom,
    ! [VarCurr,B] :
      ( range_37_0(B)
     => ( v132193(VarCurr,B)
      <=> ( v132194(VarCurr,B)
          & v132195(VarCurr,B) ) ) ) ).

fof(range_axiom_193,axiom,
    ! [B] :
      ( range_37_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B ) ) ).

fof(addAssignment_41629,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41628,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41627,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41626,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41625,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41624,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41623,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41622,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41621,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41620,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41619,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41618,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41617,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41616,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41615,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41614,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41613,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41612,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41611,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41610,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41609,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41608,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41607,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41606,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41605,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41604,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41603,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41602,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41601,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41600,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41599,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41598,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41597,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41596,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41595,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41594,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41593,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex36)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41592,axiom,
    ! [VarCurr] :
      ( v132195(VarCurr,bitIndex37)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41591,axiom,
    ! [VarCurr] :
      ( ( v132194(VarCurr,bitIndex36)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132194(VarCurr,bitIndex35)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132194(VarCurr,bitIndex34)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132194(VarCurr,bitIndex33)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132194(VarCurr,bitIndex32)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132194(VarCurr,bitIndex31)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132194(VarCurr,bitIndex30)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132194(VarCurr,bitIndex29)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132194(VarCurr,bitIndex28)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132194(VarCurr,bitIndex27)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132194(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132194(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132194(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132194(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132194(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132194(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132194(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132194(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132194(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132194(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132194(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132194(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132194(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132194(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132194(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132194(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132194(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex13) )
      & ( v132194(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex12) )
      & ( v132194(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex11) )
      & ( v132194(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex10) )
      & ( v132194(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex9) )
      & ( v132194(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex8) )
      & ( v132194(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex7) )
      & ( v132194(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex6) )
      & ( v132194(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex5) )
      & ( v132194(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex4) )
      & ( v132194(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_41590,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex37)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2664,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex0)
    <=> ( v132182(VarCurr,bitIndex2)
        & v132192(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2663,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex1)
    <=> ( v132182(VarCurr,bitIndex3)
        & v132192(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2662,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex2)
    <=> ( v132182(VarCurr,bitIndex4)
        & v132192(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2661,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex3)
    <=> ( v132182(VarCurr,bitIndex5)
        & v132192(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2660,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex4)
    <=> ( v132182(VarCurr,bitIndex6)
        & v132192(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2659,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex5)
    <=> ( v132182(VarCurr,bitIndex7)
        & v132192(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2658,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex6)
    <=> ( v132182(VarCurr,bitIndex8)
        & v132192(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2657,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex7)
    <=> ( v132182(VarCurr,bitIndex9)
        & v132192(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2656,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex8)
    <=> ( v132182(VarCurr,bitIndex10)
        & v132192(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2655,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex9)
    <=> ( v132182(VarCurr,bitIndex11)
        & v132192(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2654,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex10)
    <=> ( v132182(VarCurr,bitIndex12)
        & v132192(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2653,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex11)
    <=> ( v132182(VarCurr,bitIndex13)
        & v132192(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2652,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex12)
    <=> ( v132182(VarCurr,bitIndex14)
        & v132192(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2651,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex13)
    <=> ( v132182(VarCurr,bitIndex15)
        & v132192(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2650,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex14)
    <=> ( v132182(VarCurr,bitIndex16)
        & v132192(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2649,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex15)
    <=> ( v132182(VarCurr,bitIndex17)
        & v132192(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2648,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex16)
    <=> ( v132182(VarCurr,bitIndex18)
        & v132192(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2647,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex17)
    <=> ( v132182(VarCurr,bitIndex19)
        & v132192(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2646,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex18)
    <=> ( v132182(VarCurr,bitIndex20)
        & v132192(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2645,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex19)
    <=> ( v132182(VarCurr,bitIndex21)
        & v132192(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2644,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex20)
    <=> ( v132182(VarCurr,bitIndex22)
        & v132192(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2643,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex21)
    <=> ( v132182(VarCurr,bitIndex23)
        & v132192(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2642,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex22)
    <=> ( v132182(VarCurr,bitIndex24)
        & v132192(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2641,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex23)
    <=> ( v132182(VarCurr,bitIndex25)
        & v132192(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2640,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex24)
    <=> ( v132182(VarCurr,bitIndex26)
        & v132192(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2639,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex25)
    <=> ( v132182(VarCurr,bitIndex27)
        & v132192(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2638,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex26)
    <=> ( v132182(VarCurr,bitIndex28)
        & v132192(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2637,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex27)
    <=> ( v132182(VarCurr,bitIndex29)
        & v132192(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2636,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex28)
    <=> ( v132182(VarCurr,bitIndex30)
        & v132192(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2635,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex29)
    <=> ( v132182(VarCurr,bitIndex31)
        & v132192(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2634,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex30)
    <=> ( v132182(VarCurr,bitIndex32)
        & v132192(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2633,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex31)
    <=> ( v132182(VarCurr,bitIndex33)
        & v132192(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2632,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex32)
    <=> ( v132182(VarCurr,bitIndex34)
        & v132192(VarCurr,bitIndex32) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2631,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex33)
    <=> ( v132182(VarCurr,bitIndex35)
        & v132192(VarCurr,bitIndex33) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2630,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex34)
    <=> ( v132182(VarCurr,bitIndex36)
        & v132192(VarCurr,bitIndex34) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2629,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex35)
    <=> ( v132182(VarCurr,bitIndex37)
        & v132192(VarCurr,bitIndex35) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2628,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex36)
    <=> ( v132182(VarCurr,bitIndex38)
        & v132192(VarCurr,bitIndex36) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2627,axiom,
    ! [VarCurr] :
      ( v132191(VarCurr,bitIndex37)
    <=> ( v132182(VarCurr,bitIndex39)
        & v132192(VarCurr,bitIndex37) ) ) ).

fof(addAssignment_41589,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41588,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41587,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41586,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41585,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41584,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41583,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41582,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41581,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41580,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41579,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41578,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41577,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41576,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41575,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41574,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41573,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41572,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41571,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41570,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41569,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41568,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41567,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41566,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41565,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41564,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41563,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41562,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41561,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex28)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41560,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex29)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41559,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex30)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41558,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex31)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41557,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex32)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41556,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex33)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41555,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex34)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41554,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex35)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41553,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex36)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41552,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex37)
    <=> v132082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_51,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132179(VarCurr,B)
      <=> ( v132180(VarCurr,B)
          & v132187(VarCurr,B) ) ) ) ).

fof(addAssignment_41551,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex0)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41550,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex1)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41549,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex2)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41548,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex3)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41547,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex4)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41546,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex5)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41545,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex6)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41544,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex7)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41543,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex8)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41542,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex9)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41541,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex10)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41540,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex11)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41539,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex12)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41538,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex13)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41537,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex14)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41536,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex15)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41535,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex16)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41534,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex17)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41533,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex18)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41532,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex19)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41531,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex20)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41530,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex21)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41529,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex22)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41528,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex23)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41527,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex24)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41526,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex25)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41525,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex26)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41524,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex27)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41523,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex28)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41522,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex29)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41521,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex30)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41520,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex31)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41519,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex32)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41518,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex33)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41517,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex34)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41516,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex35)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41515,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex36)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41514,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex37)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41513,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex38)
    <=> v132083(VarCurr) ) ).

fof(addAssignment_41512,axiom,
    ! [VarCurr] :
      ( v132187(VarCurr,bitIndex39)
    <=> v132083(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_50,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132180(VarCurr,B)
      <=> ( v132181(VarCurr,B)
          | v132184(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_49,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132184(VarCurr,B)
      <=> ( v132185(VarCurr,B)
          & v132186(VarCurr,B) ) ) ) ).

fof(addAssignment_41511,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex0)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41510,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex1)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41509,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex2)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41508,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex3)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41507,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex4)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41506,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex5)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41505,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex6)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41504,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex7)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41503,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex8)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41502,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex9)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41501,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex10)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41500,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex11)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41499,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex12)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41498,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex13)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41497,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex14)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41496,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex15)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41495,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex16)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41494,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex17)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41493,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex18)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41492,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex19)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41491,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex20)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41490,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex21)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41489,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex22)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41488,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex23)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41487,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex24)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41486,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex25)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41485,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex26)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41484,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex27)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41483,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex28)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41482,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex29)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41481,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex30)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41480,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex31)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41479,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex32)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41478,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex33)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41477,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex34)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41476,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex35)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41475,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex36)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41474,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex37)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41473,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex38)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41472,axiom,
    ! [VarCurr] :
      ( v132186(VarCurr,bitIndex39)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(addAssignment_41471,axiom,
    ! [VarCurr] :
      ( ( v132185(VarCurr,bitIndex38)
      <=> v132182(VarCurr,bitIndex39) )
      & ( v132185(VarCurr,bitIndex37)
      <=> v132182(VarCurr,bitIndex38) )
      & ( v132185(VarCurr,bitIndex36)
      <=> v132182(VarCurr,bitIndex37) )
      & ( v132185(VarCurr,bitIndex35)
      <=> v132182(VarCurr,bitIndex36) )
      & ( v132185(VarCurr,bitIndex34)
      <=> v132182(VarCurr,bitIndex35) )
      & ( v132185(VarCurr,bitIndex33)
      <=> v132182(VarCurr,bitIndex34) )
      & ( v132185(VarCurr,bitIndex32)
      <=> v132182(VarCurr,bitIndex33) )
      & ( v132185(VarCurr,bitIndex31)
      <=> v132182(VarCurr,bitIndex32) )
      & ( v132185(VarCurr,bitIndex30)
      <=> v132182(VarCurr,bitIndex31) )
      & ( v132185(VarCurr,bitIndex29)
      <=> v132182(VarCurr,bitIndex30) )
      & ( v132185(VarCurr,bitIndex28)
      <=> v132182(VarCurr,bitIndex29) )
      & ( v132185(VarCurr,bitIndex27)
      <=> v132182(VarCurr,bitIndex28) )
      & ( v132185(VarCurr,bitIndex26)
      <=> v132182(VarCurr,bitIndex27) )
      & ( v132185(VarCurr,bitIndex25)
      <=> v132182(VarCurr,bitIndex26) )
      & ( v132185(VarCurr,bitIndex24)
      <=> v132182(VarCurr,bitIndex25) )
      & ( v132185(VarCurr,bitIndex23)
      <=> v132182(VarCurr,bitIndex24) )
      & ( v132185(VarCurr,bitIndex22)
      <=> v132182(VarCurr,bitIndex23) )
      & ( v132185(VarCurr,bitIndex21)
      <=> v132182(VarCurr,bitIndex22) )
      & ( v132185(VarCurr,bitIndex20)
      <=> v132182(VarCurr,bitIndex21) )
      & ( v132185(VarCurr,bitIndex19)
      <=> v132182(VarCurr,bitIndex20) )
      & ( v132185(VarCurr,bitIndex18)
      <=> v132182(VarCurr,bitIndex19) )
      & ( v132185(VarCurr,bitIndex17)
      <=> v132182(VarCurr,bitIndex18) )
      & ( v132185(VarCurr,bitIndex16)
      <=> v132182(VarCurr,bitIndex17) )
      & ( v132185(VarCurr,bitIndex15)
      <=> v132182(VarCurr,bitIndex16) )
      & ( v132185(VarCurr,bitIndex14)
      <=> v132182(VarCurr,bitIndex15) )
      & ( v132185(VarCurr,bitIndex13)
      <=> v132182(VarCurr,bitIndex14) )
      & ( v132185(VarCurr,bitIndex12)
      <=> v132182(VarCurr,bitIndex13) )
      & ( v132185(VarCurr,bitIndex11)
      <=> v132182(VarCurr,bitIndex12) )
      & ( v132185(VarCurr,bitIndex10)
      <=> v132182(VarCurr,bitIndex11) )
      & ( v132185(VarCurr,bitIndex9)
      <=> v132182(VarCurr,bitIndex10) )
      & ( v132185(VarCurr,bitIndex8)
      <=> v132182(VarCurr,bitIndex9) )
      & ( v132185(VarCurr,bitIndex7)
      <=> v132182(VarCurr,bitIndex8) )
      & ( v132185(VarCurr,bitIndex6)
      <=> v132182(VarCurr,bitIndex7) )
      & ( v132185(VarCurr,bitIndex5)
      <=> v132182(VarCurr,bitIndex6) )
      & ( v132185(VarCurr,bitIndex4)
      <=> v132182(VarCurr,bitIndex5) )
      & ( v132185(VarCurr,bitIndex3)
      <=> v132182(VarCurr,bitIndex4) )
      & ( v132185(VarCurr,bitIndex2)
      <=> v132182(VarCurr,bitIndex3) )
      & ( v132185(VarCurr,bitIndex1)
      <=> v132182(VarCurr,bitIndex2) )
      & ( v132185(VarCurr,bitIndex0)
      <=> v132182(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_41470,axiom,
    ! [VarCurr] :
      ( v132185(VarCurr,bitIndex39)
    <=> $false ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_48,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132181(VarCurr,B)
      <=> ( v132182(VarCurr,B)
          & v132183(VarCurr,B) ) ) ) ).

fof(range_axiom_192,axiom,
    ! [B] :
      ( range_39_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B ) ) ).

fof(addAssignment_41469,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41468,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex1)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41467,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41466,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex3)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41465,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex4)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41464,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex5)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41463,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex6)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41462,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex7)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41461,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex8)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41460,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex9)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41459,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex10)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41458,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex11)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41457,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex12)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41456,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex13)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41455,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex14)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41454,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex15)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41453,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex16)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41452,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex17)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41451,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex18)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41450,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex19)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41449,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex20)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41448,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex21)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41447,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex22)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41446,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex23)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41445,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex24)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41444,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex25)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41443,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex26)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41442,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex27)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41441,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex28)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41440,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex29)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41439,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex30)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41438,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex31)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41437,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex32)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41436,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex33)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41435,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex34)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41434,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex35)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41433,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex36)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41432,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex37)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41431,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex38)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41430,axiom,
    ! [VarCurr] :
      ( v132183(VarCurr,bitIndex39)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41429,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132182(VarCurr,B)
      <=> v131893(VarCurr,B) ) ) ).

fof(addAssignment_41428,axiom,
    ! [VarCurr] :
      ( ( v132182(VarCurr,bitIndex39)
      <=> v131893(VarCurr,bitIndex7) )
      & ( v132182(VarCurr,bitIndex38)
      <=> v131893(VarCurr,bitIndex6) )
      & ( v132182(VarCurr,bitIndex37)
      <=> v131893(VarCurr,bitIndex5) )
      & ( v132182(VarCurr,bitIndex36)
      <=> v131893(VarCurr,bitIndex4) )
      & ( v132182(VarCurr,bitIndex35)
      <=> v131893(VarCurr,bitIndex3) )
      & ( v132182(VarCurr,bitIndex34)
      <=> v131893(VarCurr,bitIndex2) )
      & ( v132182(VarCurr,bitIndex33)
      <=> v131893(VarCurr,bitIndex1) )
      & ( v132182(VarCurr,bitIndex32)
      <=> v131893(VarCurr,bitIndex0) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2323,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132159(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v131893(VarNext,B)
            <=> v131893(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2442,axiom,
    ! [VarNext] :
      ( v132159(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v131893(VarNext,B)
          <=> v132167(VarNext,B) ) ) ) ).

fof(addAssignment_41427,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v132167(VarNext,B)
          <=> v132165(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3168,axiom,
    ! [VarCurr] :
      ( ~ v132168(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132165(VarCurr,B)
          <=> v131896(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2973,axiom,
    ! [VarCurr] :
      ( v132168(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132165(VarCurr,B)
          <=> $true ) ) ) ).

fof(writeUnaryOperator_10925,axiom,
    ! [VarCurr] :
      ( ~ v132168(VarCurr)
    <=> v10091(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26457,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132159(VarNext)
      <=> v132160(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26456,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132160(VarNext)
      <=> ( v132161(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_10924,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132161(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_47,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v131896(VarCurr,B)
      <=> ( v132155(VarCurr,B)
          & v132156(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_10923,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132156(VarCurr,B)
      <=> ~ v132034(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_46,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132155(VarCurr,B)
      <=> ( v131898(VarCurr,B)
          | v131893(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValueVector_39,axiom,
    ! [B] :
      ( range_31_0(B)
     => ( v131893(constB0,B)
      <=> $true ) ) ).

fof(bitBlastConstant_12696,axiom,
    b11111111111111111111111111111111(bitIndex31) ).

fof(bitBlastConstant_12695,axiom,
    b11111111111111111111111111111111(bitIndex30) ).

fof(bitBlastConstant_12694,axiom,
    b11111111111111111111111111111111(bitIndex29) ).

fof(bitBlastConstant_12693,axiom,
    b11111111111111111111111111111111(bitIndex28) ).

fof(bitBlastConstant_12692,axiom,
    b11111111111111111111111111111111(bitIndex27) ).

fof(bitBlastConstant_12691,axiom,
    b11111111111111111111111111111111(bitIndex26) ).

fof(bitBlastConstant_12690,axiom,
    b11111111111111111111111111111111(bitIndex25) ).

fof(bitBlastConstant_12689,axiom,
    b11111111111111111111111111111111(bitIndex24) ).

fof(bitBlastConstant_12688,axiom,
    b11111111111111111111111111111111(bitIndex23) ).

fof(bitBlastConstant_12687,axiom,
    b11111111111111111111111111111111(bitIndex22) ).

fof(bitBlastConstant_12686,axiom,
    b11111111111111111111111111111111(bitIndex21) ).

fof(bitBlastConstant_12685,axiom,
    b11111111111111111111111111111111(bitIndex20) ).

fof(bitBlastConstant_12684,axiom,
    b11111111111111111111111111111111(bitIndex19) ).

fof(bitBlastConstant_12683,axiom,
    b11111111111111111111111111111111(bitIndex18) ).

fof(bitBlastConstant_12682,axiom,
    b11111111111111111111111111111111(bitIndex17) ).

fof(bitBlastConstant_12681,axiom,
    b11111111111111111111111111111111(bitIndex16) ).

fof(bitBlastConstant_12680,axiom,
    b11111111111111111111111111111111(bitIndex15) ).

fof(bitBlastConstant_12679,axiom,
    b11111111111111111111111111111111(bitIndex14) ).

fof(bitBlastConstant_12678,axiom,
    b11111111111111111111111111111111(bitIndex13) ).

fof(bitBlastConstant_12677,axiom,
    b11111111111111111111111111111111(bitIndex12) ).

fof(bitBlastConstant_12676,axiom,
    b11111111111111111111111111111111(bitIndex11) ).

fof(bitBlastConstant_12675,axiom,
    b11111111111111111111111111111111(bitIndex10) ).

fof(bitBlastConstant_12674,axiom,
    b11111111111111111111111111111111(bitIndex9) ).

fof(bitBlastConstant_12673,axiom,
    b11111111111111111111111111111111(bitIndex8) ).

fof(bitBlastConstant_12672,axiom,
    b11111111111111111111111111111111(bitIndex7) ).

fof(bitBlastConstant_12671,axiom,
    b11111111111111111111111111111111(bitIndex6) ).

fof(bitBlastConstant_12670,axiom,
    b11111111111111111111111111111111(bitIndex5) ).

fof(bitBlastConstant_12669,axiom,
    b11111111111111111111111111111111(bitIndex4) ).

fof(bitBlastConstant_12668,axiom,
    b11111111111111111111111111111111(bitIndex3) ).

fof(bitBlastConstant_12667,axiom,
    b11111111111111111111111111111111(bitIndex2) ).

fof(bitBlastConstant_12666,axiom,
    b11111111111111111111111111111111(bitIndex1) ).

fof(bitBlastConstant_12665,axiom,
    b11111111111111111111111111111111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_45,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132034(VarCurr,B)
      <=> ( v132036(VarCurr,B)
          & v132152(VarCurr,B) ) ) ) ).

fof(addAssignment_41426,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex0)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41425,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex1)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41424,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex2)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41423,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex3)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41422,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex4)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41421,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex5)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41420,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex6)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41419,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex7)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41418,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex8)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41417,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex9)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41416,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex10)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41415,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex11)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41414,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex12)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41413,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex13)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41412,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex14)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41411,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex15)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41410,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex16)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41409,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex17)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41408,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex18)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41407,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex19)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41406,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex20)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41405,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex21)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41404,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex22)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41403,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex23)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41402,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex24)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41401,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex25)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41400,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex26)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41399,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex27)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41398,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex28)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41397,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex29)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41396,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex30)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41395,axiom,
    ! [VarCurr] :
      ( v132152(VarCurr,bitIndex31)
    <=> v132153(VarCurr) ) ).

fof(addAssignment_41394,axiom,
    ! [VarCurr] :
      ( v132153(VarCurr)
    <=> v132040(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_578,axiom,
    ! [VarCurr] :
      ( ~ v132150(VarCurr)
     => ( v132036(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_773,axiom,
    ! [VarCurr] :
      ( v132150(VarCurr)
     => ( v132036(VarCurr,bitIndex31)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9283,axiom,
    ! [VarCurr] :
      ( v132150(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_577,axiom,
    ! [VarCurr] :
      ( ~ v132148(VarCurr)
     => ( v132036(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_772,axiom,
    ! [VarCurr] :
      ( v132148(VarCurr)
     => ( v132036(VarCurr,bitIndex30)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9282,axiom,
    ! [VarCurr] :
      ( v132148(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_576,axiom,
    ! [VarCurr] :
      ( ~ v132146(VarCurr)
     => ( v132036(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_771,axiom,
    ! [VarCurr] :
      ( v132146(VarCurr)
     => ( v132036(VarCurr,bitIndex29)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9281,axiom,
    ! [VarCurr] :
      ( v132146(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_575,axiom,
    ! [VarCurr] :
      ( ~ v132144(VarCurr)
     => ( v132036(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_770,axiom,
    ! [VarCurr] :
      ( v132144(VarCurr)
     => ( v132036(VarCurr,bitIndex28)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9280,axiom,
    ! [VarCurr] :
      ( v132144(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_574,axiom,
    ! [VarCurr] :
      ( ~ v132142(VarCurr)
     => ( v132036(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_769,axiom,
    ! [VarCurr] :
      ( v132142(VarCurr)
     => ( v132036(VarCurr,bitIndex27)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9279,axiom,
    ! [VarCurr] :
      ( v132142(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_573,axiom,
    ! [VarCurr] :
      ( ~ v132140(VarCurr)
     => ( v132036(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_768,axiom,
    ! [VarCurr] :
      ( v132140(VarCurr)
     => ( v132036(VarCurr,bitIndex26)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9278,axiom,
    ! [VarCurr] :
      ( v132140(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_572,axiom,
    ! [VarCurr] :
      ( ~ v132138(VarCurr)
     => ( v132036(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_767,axiom,
    ! [VarCurr] :
      ( v132138(VarCurr)
     => ( v132036(VarCurr,bitIndex25)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9277,axiom,
    ! [VarCurr] :
      ( v132138(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_571,axiom,
    ! [VarCurr] :
      ( ~ v132136(VarCurr)
     => ( v132036(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_766,axiom,
    ! [VarCurr] :
      ( v132136(VarCurr)
     => ( v132036(VarCurr,bitIndex24)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9276,axiom,
    ! [VarCurr] :
      ( v132136(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_570,axiom,
    ! [VarCurr] :
      ( ~ v132134(VarCurr)
     => ( v132036(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_765,axiom,
    ! [VarCurr] :
      ( v132134(VarCurr)
     => ( v132036(VarCurr,bitIndex23)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9275,axiom,
    ! [VarCurr] :
      ( v132134(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_569,axiom,
    ! [VarCurr] :
      ( ~ v132132(VarCurr)
     => ( v132036(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_764,axiom,
    ! [VarCurr] :
      ( v132132(VarCurr)
     => ( v132036(VarCurr,bitIndex22)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9274,axiom,
    ! [VarCurr] :
      ( v132132(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_568,axiom,
    ! [VarCurr] :
      ( ~ v132130(VarCurr)
     => ( v132036(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_763,axiom,
    ! [VarCurr] :
      ( v132130(VarCurr)
     => ( v132036(VarCurr,bitIndex21)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9273,axiom,
    ! [VarCurr] :
      ( v132130(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_567,axiom,
    ! [VarCurr] :
      ( ~ v132128(VarCurr)
     => ( v132036(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_762,axiom,
    ! [VarCurr] :
      ( v132128(VarCurr)
     => ( v132036(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9272,axiom,
    ! [VarCurr] :
      ( v132128(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_566,axiom,
    ! [VarCurr] :
      ( ~ v132126(VarCurr)
     => ( v132036(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_761,axiom,
    ! [VarCurr] :
      ( v132126(VarCurr)
     => ( v132036(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9271,axiom,
    ! [VarCurr] :
      ( v132126(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_565,axiom,
    ! [VarCurr] :
      ( ~ v132124(VarCurr)
     => ( v132036(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_760,axiom,
    ! [VarCurr] :
      ( v132124(VarCurr)
     => ( v132036(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9270,axiom,
    ! [VarCurr] :
      ( v132124(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_564,axiom,
    ! [VarCurr] :
      ( ~ v132122(VarCurr)
     => ( v132036(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_759,axiom,
    ! [VarCurr] :
      ( v132122(VarCurr)
     => ( v132036(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9269,axiom,
    ! [VarCurr] :
      ( v132122(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_563,axiom,
    ! [VarCurr] :
      ( ~ v132120(VarCurr)
     => ( v132036(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_758,axiom,
    ! [VarCurr] :
      ( v132120(VarCurr)
     => ( v132036(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9268,axiom,
    ! [VarCurr] :
      ( v132120(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $true )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_562,axiom,
    ! [VarCurr] :
      ( ~ v132118(VarCurr)
     => ( v132036(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_757,axiom,
    ! [VarCurr] :
      ( v132118(VarCurr)
     => ( v132036(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9267,axiom,
    ! [VarCurr] :
      ( v132118(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_561,axiom,
    ! [VarCurr] :
      ( ~ v132116(VarCurr)
     => ( v132036(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_756,axiom,
    ! [VarCurr] :
      ( v132116(VarCurr)
     => ( v132036(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9266,axiom,
    ! [VarCurr] :
      ( v132116(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_560,axiom,
    ! [VarCurr] :
      ( ~ v132114(VarCurr)
     => ( v132036(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_755,axiom,
    ! [VarCurr] :
      ( v132114(VarCurr)
     => ( v132036(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9265,axiom,
    ! [VarCurr] :
      ( v132114(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_559,axiom,
    ! [VarCurr] :
      ( ~ v132112(VarCurr)
     => ( v132036(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_754,axiom,
    ! [VarCurr] :
      ( v132112(VarCurr)
     => ( v132036(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9264,axiom,
    ! [VarCurr] :
      ( v132112(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_558,axiom,
    ! [VarCurr] :
      ( ~ v132110(VarCurr)
     => ( v132036(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_753,axiom,
    ! [VarCurr] :
      ( v132110(VarCurr)
     => ( v132036(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9263,axiom,
    ! [VarCurr] :
      ( v132110(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_557,axiom,
    ! [VarCurr] :
      ( ~ v132108(VarCurr)
     => ( v132036(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_752,axiom,
    ! [VarCurr] :
      ( v132108(VarCurr)
     => ( v132036(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9262,axiom,
    ! [VarCurr] :
      ( v132108(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_556,axiom,
    ! [VarCurr] :
      ( ~ v132106(VarCurr)
     => ( v132036(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_751,axiom,
    ! [VarCurr] :
      ( v132106(VarCurr)
     => ( v132036(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9261,axiom,
    ! [VarCurr] :
      ( v132106(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_555,axiom,
    ! [VarCurr] :
      ( ~ v132104(VarCurr)
     => ( v132036(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_750,axiom,
    ! [VarCurr] :
      ( v132104(VarCurr)
     => ( v132036(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9260,axiom,
    ! [VarCurr] :
      ( v132104(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $true )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_554,axiom,
    ! [VarCurr] :
      ( ~ v132102(VarCurr)
     => ( v132036(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_749,axiom,
    ! [VarCurr] :
      ( v132102(VarCurr)
     => ( v132036(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9259,axiom,
    ! [VarCurr] :
      ( v132102(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_553,axiom,
    ! [VarCurr] :
      ( ~ v132100(VarCurr)
     => ( v132036(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_748,axiom,
    ! [VarCurr] :
      ( v132100(VarCurr)
     => ( v132036(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9258,axiom,
    ! [VarCurr] :
      ( v132100(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_552,axiom,
    ! [VarCurr] :
      ( ~ v132098(VarCurr)
     => ( v132036(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_747,axiom,
    ! [VarCurr] :
      ( v132098(VarCurr)
     => ( v132036(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9257,axiom,
    ! [VarCurr] :
      ( v132098(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_551,axiom,
    ! [VarCurr] :
      ( ~ v132096(VarCurr)
     => ( v132036(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_746,axiom,
    ! [VarCurr] :
      ( v132096(VarCurr)
     => ( v132036(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9256,axiom,
    ! [VarCurr] :
      ( v132096(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $true )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_550,axiom,
    ! [VarCurr] :
      ( ~ v132094(VarCurr)
     => ( v132036(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_745,axiom,
    ! [VarCurr] :
      ( v132094(VarCurr)
     => ( v132036(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9255,axiom,
    ! [VarCurr] :
      ( v132094(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_549,axiom,
    ! [VarCurr] :
      ( ~ v132092(VarCurr)
     => ( v132036(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_744,axiom,
    ! [VarCurr] :
      ( v132092(VarCurr)
     => ( v132036(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9254,axiom,
    ! [VarCurr] :
      ( v132092(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $true )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_548,axiom,
    ! [VarCurr] :
      ( ~ v132090(VarCurr)
     => ( v132036(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_743,axiom,
    ! [VarCurr] :
      ( v132090(VarCurr)
     => ( v132036(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9253,axiom,
    ! [VarCurr] :
      ( v132090(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3167,axiom,
    ! [VarCurr] :
      ( ~ v132088(VarCurr)
     => ( v132036(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2972,axiom,
    ! [VarCurr] :
      ( v132088(VarCurr)
     => ( v132036(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9252,axiom,
    ! [VarCurr] :
      ( v132088(VarCurr)
    <=> ( ( v132038(VarCurr,bitIndex4)
        <=> $false )
        & ( v132038(VarCurr,bitIndex3)
        <=> $false )
        & ( v132038(VarCurr,bitIndex2)
        <=> $false )
        & ( v132038(VarCurr,bitIndex1)
        <=> $false )
        & ( v132038(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2322,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132045(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v132038(VarNext,B)
            <=> v132038(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2441,axiom,
    ! [VarNext] :
      ( v132045(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132038(VarNext,B)
          <=> v132059(VarNext,B) ) ) ) ).

fof(addAssignment_41393,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132059(VarNext,B)
          <=> v132057(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5399,axiom,
    ! [VarCurr] :
      ( ~ v132054(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132057(VarCurr,B)
          <=> v132060(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5388,axiom,
    ! [VarCurr] :
      ( v132054(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132057(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41392,axiom,
    ! [VarCurr] :
      ( v132060(VarCurr,bitIndex0)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41391,axiom,
    ! [VarCurr] :
      ( v132060(VarCurr,bitIndex1)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41390,axiom,
    ! [VarCurr] :
      ( v132060(VarCurr,bitIndex2)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_41389,axiom,
    ! [VarCurr] :
      ( v132060(VarCurr,bitIndex3)
    <=> v132070(VarCurr) ) ).

fof(addAssignment_41388,axiom,
    ! [VarCurr] :
      ( v132060(VarCurr,bitIndex4)
    <=> v132062(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26455,axiom,
    ! [VarCurr] :
      ( v132080(VarCurr)
    <=> ( v132081(VarCurr)
        & v132084(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2626,axiom,
    ! [VarCurr] :
      ( v132084(VarCurr)
    <=> ( v132038(VarCurr,bitIndex0)
        | v132038(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26454,axiom,
    ! [VarCurr] :
      ( v132081(VarCurr)
    <=> ( v132082(VarCurr)
        | v132083(VarCurr) ) ) ).

fof(writeUnaryOperator_10922,axiom,
    ! [VarCurr] :
      ( ~ v132083(VarCurr)
    <=> v132038(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10921,axiom,
    ! [VarCurr] :
      ( ~ v132082(VarCurr)
    <=> v132038(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26453,axiom,
    ! [VarCurr] :
      ( v132075(VarCurr)
    <=> ( v132076(VarCurr)
        & v132079(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2625,axiom,
    ! [VarCurr] :
      ( v132079(VarCurr)
    <=> ( v132067(VarCurr)
        | v132038(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26452,axiom,
    ! [VarCurr] :
      ( v132076(VarCurr)
    <=> ( v132077(VarCurr)
        | v132078(VarCurr) ) ) ).

fof(writeUnaryOperator_10920,axiom,
    ! [VarCurr] :
      ( ~ v132078(VarCurr)
    <=> v132038(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10919,axiom,
    ! [VarCurr] :
      ( ~ v132077(VarCurr)
    <=> v132067(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26451,axiom,
    ! [VarCurr] :
      ( v132070(VarCurr)
    <=> ( v132071(VarCurr)
        & v132074(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2624,axiom,
    ! [VarCurr] :
      ( v132074(VarCurr)
    <=> ( v132066(VarCurr)
        | v132038(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26450,axiom,
    ! [VarCurr] :
      ( v132071(VarCurr)
    <=> ( v132072(VarCurr)
        | v132073(VarCurr) ) ) ).

fof(writeUnaryOperator_10918,axiom,
    ! [VarCurr] :
      ( ~ v132073(VarCurr)
    <=> v132038(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10917,axiom,
    ! [VarCurr] :
      ( ~ v132072(VarCurr)
    <=> v132066(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26449,axiom,
    ! [VarCurr] :
      ( v132062(VarCurr)
    <=> ( v132063(VarCurr)
        & v132069(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2623,axiom,
    ! [VarCurr] :
      ( v132069(VarCurr)
    <=> ( v132065(VarCurr)
        | v132038(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26448,axiom,
    ! [VarCurr] :
      ( v132063(VarCurr)
    <=> ( v132064(VarCurr)
        | v132068(VarCurr) ) ) ).

fof(writeUnaryOperator_10916,axiom,
    ! [VarCurr] :
      ( ~ v132068(VarCurr)
    <=> v132038(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10915,axiom,
    ! [VarCurr] :
      ( ~ v132064(VarCurr)
    <=> v132065(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2622,axiom,
    ! [VarCurr] :
      ( v132065(VarCurr)
    <=> ( v132066(VarCurr)
        & v132038(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2621,axiom,
    ! [VarCurr] :
      ( v132066(VarCurr)
    <=> ( v132067(VarCurr)
        & v132038(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2620,axiom,
    ! [VarCurr] :
      ( v132067(VarCurr)
    <=> ( v132038(VarCurr,bitIndex0)
        & v132038(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26447,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132045(VarNext)
      <=> ( v132046(VarNext)
          & v132053(VarNext) ) ) ) ).

fof(addAssignment_41387,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132053(VarNext)
      <=> v132051(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26446,axiom,
    ! [VarCurr] :
      ( v132051(VarCurr)
    <=> ( v132054(VarCurr)
        | v132055(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26445,axiom,
    ! [VarCurr] :
      ( v132055(VarCurr)
    <=> ( v132040(VarCurr)
        & v132056(VarCurr) ) ) ).

fof(writeUnaryOperator_10914,axiom,
    ! [VarCurr] :
      ( ~ v132056(VarCurr)
    <=> v132054(VarCurr) ) ).

fof(writeUnaryOperator_10913,axiom,
    ! [VarCurr] :
      ( ~ v132054(VarCurr)
    <=> v10091(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26444,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132046(VarNext)
      <=> ( v132047(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_10912,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132047(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(addAssignmentInitValueVector_38,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v132038(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_41386,axiom,
    ! [VarCurr] :
      ( v132040(VarCurr)
    <=> v132042(VarCurr) ) ).

fof(addAssignment_41385,axiom,
    ! [VarCurr] :
      ( v132042(VarCurr)
    <=> v131859(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_44,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v131898(VarCurr,B)
      <=> ( v131900(VarCurr,B)
          & v132031(VarCurr,B) ) ) ) ).

fof(addAssignment_41384,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex0)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41383,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex1)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41382,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex2)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41381,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex3)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41380,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex4)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41379,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex5)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41378,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex6)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41377,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex7)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41376,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex8)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41375,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex9)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41374,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex10)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41373,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex11)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41372,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex12)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41371,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex13)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41370,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex14)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41369,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex15)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41368,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex16)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41367,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex17)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41366,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex18)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41365,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex19)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41364,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex20)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41363,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex21)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41362,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex22)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41361,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex23)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41360,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex24)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41359,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex25)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41358,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex26)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41357,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex27)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41356,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex28)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41355,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex29)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41354,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex30)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41353,axiom,
    ! [VarCurr] :
      ( v132031(VarCurr,bitIndex31)
    <=> v132032(VarCurr) ) ).

fof(addAssignment_41352,axiom,
    ! [VarCurr] :
      ( v132032(VarCurr)
    <=> v132000(VarCurr) ) ).

fof(addAssignment_41351,axiom,
    ! [VarCurr] :
      ( v132000(VarCurr)
    <=> v132002(VarCurr) ) ).

fof(addAssignment_41350,axiom,
    ! [VarCurr] :
      ( v132002(VarCurr)
    <=> v132004(VarCurr) ) ).

fof(addAssignment_41349,axiom,
    ! [VarCurr] :
      ( v132004(VarCurr)
    <=> v132006(VarCurr) ) ).

fof(addAssignment_41348,axiom,
    ! [VarCurr] :
      ( v132006(VarCurr)
    <=> v132008(VarCurr) ) ).

fof(addAssignment_41347,axiom,
    ! [VarCurr] :
      ( v132008(VarCurr)
    <=> v132010(VarCurr) ) ).

fof(addAssignment_41346,axiom,
    ! [VarCurr] :
      ( v132010(VarCurr)
    <=> v132012(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2321,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132019(VarNext)
       => ( v132012(VarNext)
        <=> v132012(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2440,axiom,
    ! [VarNext] :
      ( v132019(VarNext)
     => ( v132012(VarNext)
      <=> v132027(VarNext) ) ) ).

fof(addAssignment_41345,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132027(VarNext)
      <=> v132025(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3166,axiom,
    ! [VarCurr] :
      ( ~ v131932(VarCurr)
     => ( v132025(VarCurr)
      <=> v132014(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2971,axiom,
    ! [VarCurr] :
      ( v131932(VarCurr)
     => ( v132025(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26443,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132019(VarNext)
      <=> v132020(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26442,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132020(VarNext)
      <=> ( v132022(VarNext)
          & v131918(VarNext) ) ) ) ).

fof(writeUnaryOperator_10911,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132022(VarNext)
      <=> v131925(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3165,axiom,
    ! [VarCurr] :
      ( ~ v132016(VarCurr)
     => ( v132014(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2970,axiom,
    ! [VarCurr] :
      ( v132016(VarCurr)
     => ( v132014(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorShiftedRanges_2619,axiom,
    ! [VarCurr] :
      ( v132016(VarCurr)
    <=> ( v48(VarCurr,bitIndex8)
        & v56(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_547,axiom,
    ! [VarCurr] :
      ( ~ v131998(VarCurr)
     => ( v131900(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_742,axiom,
    ! [VarCurr] :
      ( v131998(VarCurr)
     => ( v131900(VarCurr,bitIndex31)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9251,axiom,
    ! [VarCurr] :
      ( v131998(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_546,axiom,
    ! [VarCurr] :
      ( ~ v131996(VarCurr)
     => ( v131900(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_741,axiom,
    ! [VarCurr] :
      ( v131996(VarCurr)
     => ( v131900(VarCurr,bitIndex30)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9250,axiom,
    ! [VarCurr] :
      ( v131996(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_545,axiom,
    ! [VarCurr] :
      ( ~ v131994(VarCurr)
     => ( v131900(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_740,axiom,
    ! [VarCurr] :
      ( v131994(VarCurr)
     => ( v131900(VarCurr,bitIndex29)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9249,axiom,
    ! [VarCurr] :
      ( v131994(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_544,axiom,
    ! [VarCurr] :
      ( ~ v131992(VarCurr)
     => ( v131900(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_739,axiom,
    ! [VarCurr] :
      ( v131992(VarCurr)
     => ( v131900(VarCurr,bitIndex28)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9248,axiom,
    ! [VarCurr] :
      ( v131992(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_543,axiom,
    ! [VarCurr] :
      ( ~ v131990(VarCurr)
     => ( v131900(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_738,axiom,
    ! [VarCurr] :
      ( v131990(VarCurr)
     => ( v131900(VarCurr,bitIndex27)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9247,axiom,
    ! [VarCurr] :
      ( v131990(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_542,axiom,
    ! [VarCurr] :
      ( ~ v131988(VarCurr)
     => ( v131900(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_737,axiom,
    ! [VarCurr] :
      ( v131988(VarCurr)
     => ( v131900(VarCurr,bitIndex26)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9246,axiom,
    ! [VarCurr] :
      ( v131988(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_541,axiom,
    ! [VarCurr] :
      ( ~ v131986(VarCurr)
     => ( v131900(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_736,axiom,
    ! [VarCurr] :
      ( v131986(VarCurr)
     => ( v131900(VarCurr,bitIndex25)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9245,axiom,
    ! [VarCurr] :
      ( v131986(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_540,axiom,
    ! [VarCurr] :
      ( ~ v131984(VarCurr)
     => ( v131900(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_735,axiom,
    ! [VarCurr] :
      ( v131984(VarCurr)
     => ( v131900(VarCurr,bitIndex24)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9244,axiom,
    ! [VarCurr] :
      ( v131984(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_539,axiom,
    ! [VarCurr] :
      ( ~ v131982(VarCurr)
     => ( v131900(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_734,axiom,
    ! [VarCurr] :
      ( v131982(VarCurr)
     => ( v131900(VarCurr,bitIndex23)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9243,axiom,
    ! [VarCurr] :
      ( v131982(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_538,axiom,
    ! [VarCurr] :
      ( ~ v131980(VarCurr)
     => ( v131900(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_733,axiom,
    ! [VarCurr] :
      ( v131980(VarCurr)
     => ( v131900(VarCurr,bitIndex22)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9242,axiom,
    ! [VarCurr] :
      ( v131980(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_537,axiom,
    ! [VarCurr] :
      ( ~ v131978(VarCurr)
     => ( v131900(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_732,axiom,
    ! [VarCurr] :
      ( v131978(VarCurr)
     => ( v131900(VarCurr,bitIndex21)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9241,axiom,
    ! [VarCurr] :
      ( v131978(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_536,axiom,
    ! [VarCurr] :
      ( ~ v131976(VarCurr)
     => ( v131900(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_731,axiom,
    ! [VarCurr] :
      ( v131976(VarCurr)
     => ( v131900(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9240,axiom,
    ! [VarCurr] :
      ( v131976(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_535,axiom,
    ! [VarCurr] :
      ( ~ v131974(VarCurr)
     => ( v131900(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_730,axiom,
    ! [VarCurr] :
      ( v131974(VarCurr)
     => ( v131900(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9239,axiom,
    ! [VarCurr] :
      ( v131974(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_534,axiom,
    ! [VarCurr] :
      ( ~ v131972(VarCurr)
     => ( v131900(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_729,axiom,
    ! [VarCurr] :
      ( v131972(VarCurr)
     => ( v131900(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9238,axiom,
    ! [VarCurr] :
      ( v131972(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_533,axiom,
    ! [VarCurr] :
      ( ~ v131970(VarCurr)
     => ( v131900(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_728,axiom,
    ! [VarCurr] :
      ( v131970(VarCurr)
     => ( v131900(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9237,axiom,
    ! [VarCurr] :
      ( v131970(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_532,axiom,
    ! [VarCurr] :
      ( ~ v131968(VarCurr)
     => ( v131900(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_727,axiom,
    ! [VarCurr] :
      ( v131968(VarCurr)
     => ( v131900(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9236,axiom,
    ! [VarCurr] :
      ( v131968(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $true )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_531,axiom,
    ! [VarCurr] :
      ( ~ v131966(VarCurr)
     => ( v131900(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_726,axiom,
    ! [VarCurr] :
      ( v131966(VarCurr)
     => ( v131900(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9235,axiom,
    ! [VarCurr] :
      ( v131966(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_530,axiom,
    ! [VarCurr] :
      ( ~ v131964(VarCurr)
     => ( v131900(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_725,axiom,
    ! [VarCurr] :
      ( v131964(VarCurr)
     => ( v131900(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9234,axiom,
    ! [VarCurr] :
      ( v131964(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_529,axiom,
    ! [VarCurr] :
      ( ~ v131962(VarCurr)
     => ( v131900(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_724,axiom,
    ! [VarCurr] :
      ( v131962(VarCurr)
     => ( v131900(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9233,axiom,
    ! [VarCurr] :
      ( v131962(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_528,axiom,
    ! [VarCurr] :
      ( ~ v131960(VarCurr)
     => ( v131900(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_723,axiom,
    ! [VarCurr] :
      ( v131960(VarCurr)
     => ( v131900(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9232,axiom,
    ! [VarCurr] :
      ( v131960(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_527,axiom,
    ! [VarCurr] :
      ( ~ v131958(VarCurr)
     => ( v131900(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_722,axiom,
    ! [VarCurr] :
      ( v131958(VarCurr)
     => ( v131900(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9231,axiom,
    ! [VarCurr] :
      ( v131958(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_526,axiom,
    ! [VarCurr] :
      ( ~ v131956(VarCurr)
     => ( v131900(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_721,axiom,
    ! [VarCurr] :
      ( v131956(VarCurr)
     => ( v131900(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9230,axiom,
    ! [VarCurr] :
      ( v131956(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_525,axiom,
    ! [VarCurr] :
      ( ~ v131954(VarCurr)
     => ( v131900(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_720,axiom,
    ! [VarCurr] :
      ( v131954(VarCurr)
     => ( v131900(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9229,axiom,
    ! [VarCurr] :
      ( v131954(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_524,axiom,
    ! [VarCurr] :
      ( ~ v131952(VarCurr)
     => ( v131900(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_719,axiom,
    ! [VarCurr] :
      ( v131952(VarCurr)
     => ( v131900(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9228,axiom,
    ! [VarCurr] :
      ( v131952(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $true )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_523,axiom,
    ! [VarCurr] :
      ( ~ v131950(VarCurr)
     => ( v131900(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_718,axiom,
    ! [VarCurr] :
      ( v131950(VarCurr)
     => ( v131900(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9227,axiom,
    ! [VarCurr] :
      ( v131950(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_522,axiom,
    ! [VarCurr] :
      ( ~ v131948(VarCurr)
     => ( v131900(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_717,axiom,
    ! [VarCurr] :
      ( v131948(VarCurr)
     => ( v131900(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9226,axiom,
    ! [VarCurr] :
      ( v131948(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_521,axiom,
    ! [VarCurr] :
      ( ~ v131946(VarCurr)
     => ( v131900(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_716,axiom,
    ! [VarCurr] :
      ( v131946(VarCurr)
     => ( v131900(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9225,axiom,
    ! [VarCurr] :
      ( v131946(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_520,axiom,
    ! [VarCurr] :
      ( ~ v131944(VarCurr)
     => ( v131900(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_715,axiom,
    ! [VarCurr] :
      ( v131944(VarCurr)
     => ( v131900(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9224,axiom,
    ! [VarCurr] :
      ( v131944(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $true )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_519,axiom,
    ! [VarCurr] :
      ( ~ v131942(VarCurr)
     => ( v131900(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_714,axiom,
    ! [VarCurr] :
      ( v131942(VarCurr)
     => ( v131900(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9223,axiom,
    ! [VarCurr] :
      ( v131942(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_518,axiom,
    ! [VarCurr] :
      ( ~ v131940(VarCurr)
     => ( v131900(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_713,axiom,
    ! [VarCurr] :
      ( v131940(VarCurr)
     => ( v131900(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9222,axiom,
    ! [VarCurr] :
      ( v131940(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $true )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_517,axiom,
    ! [VarCurr] :
      ( ~ v131938(VarCurr)
     => ( v131900(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_712,axiom,
    ! [VarCurr] :
      ( v131938(VarCurr)
     => ( v131900(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9221,axiom,
    ! [VarCurr] :
      ( v131938(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3164,axiom,
    ! [VarCurr] :
      ( ~ v131936(VarCurr)
     => ( v131900(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2969,axiom,
    ! [VarCurr] :
      ( v131936(VarCurr)
     => ( v131900(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9220,axiom,
    ! [VarCurr] :
      ( v131936(VarCurr)
    <=> ( ( v131902(VarCurr,bitIndex4)
        <=> $false )
        & ( v131902(VarCurr,bitIndex3)
        <=> $false )
        & ( v131902(VarCurr,bitIndex2)
        <=> $false )
        & ( v131902(VarCurr,bitIndex1)
        <=> $false )
        & ( v131902(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_41344,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131902(VarCurr,B)
      <=> v131904(VarCurr,B) ) ) ).

fof(addAssignment_41343,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131904(VarCurr,B)
      <=> v131906(VarCurr,B) ) ) ).

fof(addAssignment_41342,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131906(VarCurr,B)
      <=> v131908(VarCurr,B) ) ) ).

fof(addAssignment_41341,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131908(VarCurr,B)
      <=> v131910(VarCurr,B) ) ) ).

fof(addAssignment_41340,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131910(VarCurr,B)
      <=> v131912(VarCurr,B) ) ) ).

fof(addAssignment_41339,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131912(VarCurr,B)
      <=> v131914(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131921(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v131914(VarNext,B)
            <=> v131914(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2439,axiom,
    ! [VarNext] :
      ( v131921(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131914(VarNext,B)
          <=> v131931(VarNext,B) ) ) ) ).

fof(addAssignment_41338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131931(VarNext,B)
          <=> v131929(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3163,axiom,
    ! [VarCurr] :
      ( ~ v131932(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131929(VarCurr,B)
          <=> v131916(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2968,axiom,
    ! [VarCurr] :
      ( v131932(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131929(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_10910,axiom,
    ! [VarCurr] :
      ( ~ v131932(VarCurr)
    <=> v12(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26441,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131921(VarNext)
      <=> v131922(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26440,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131922(VarNext)
      <=> ( v131923(VarNext)
          & v131918(VarNext) ) ) ) ).

fof(writeUnaryOperator_10909,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131923(VarNext)
      <=> v131925(VarNext) ) ) ).

fof(addAssignment_41337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131925(VarNext)
      <=> v131918(VarCurr) ) ) ).

fof(addAssignment_41336,axiom,
    ! [VarCurr] :
      ( v131918(VarCurr)
    <=> v87019(VarCurr) ) ).

fof(addAssignment_41335,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131916(VarCurr,B)
      <=> v48(VarCurr,B) ) ) ).

fof(addAssignment_41334,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v48(VarCurr,B)
      <=> v50(VarCurr,B) ) ) ).

fof(addAssignment_41333,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v50(VarCurr,B)
      <=> v52(VarCurr,B) ) ) ).

fof(addAssignment_41332,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v52(VarCurr,B)
      <=> v54(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26439,axiom,
    ! [VarCurr] :
      ( v131865(VarCurr)
    <=> ( v131879(VarCurr)
        & v131881(VarCurr) ) ) ).

fof(writeUnaryOperator_10908,axiom,
    ! [VarCurr] :
      ( ~ v131881(VarCurr)
    <=> v114176(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26438,axiom,
    ! [VarCurr] :
      ( v131879(VarCurr)
    <=> ( v131880(VarCurr)
        & v11301(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26437,axiom,
    ! [VarCurr] :
      ( v131880(VarCurr)
    <=> ( v10109(VarCurr)
        & v131867(VarCurr) ) ) ).

fof(addAssignment_41331,axiom,
    ! [VarCurr] :
      ( v131867(VarCurr)
    <=> v131869(VarCurr) ) ).

fof(addAssignment_41330,axiom,
    ! [VarCurr] :
      ( v131869(VarCurr)
    <=> v131871(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3162,axiom,
    ! [VarCurr] :
      ( ~ v131873(VarCurr)
     => ( v131871(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2967,axiom,
    ! [VarCurr] :
      ( v131873(VarCurr)
     => ( v131871(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26436,axiom,
    ! [VarCurr] :
      ( v131873(VarCurr)
    <=> ( v131874(VarCurr)
        & v131875(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26435,axiom,
    ! [VarCurr] :
      ( v131875(VarCurr)
    <=> ( v131876(VarCurr)
        | v131877(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9219,axiom,
    ! [VarCurr] :
      ( v131877(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $false )
        & ( v15274(VarCurr,bitIndex5)
        <=> $true )
        & ( v15274(VarCurr,bitIndex4)
        <=> $false )
        & ( v15274(VarCurr,bitIndex3)
        <=> $false )
        & ( v15274(VarCurr,bitIndex2)
        <=> $false )
        & ( v15274(VarCurr,bitIndex1)
        <=> $false )
        & ( v15274(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9218,axiom,
    ! [VarCurr] :
      ( v131876(VarCurr)
    <=> ( ( v15274(VarCurr,bitIndex6)
        <=> $false )
        & ( v15274(VarCurr,bitIndex5)
        <=> $false )
        & ( v15274(VarCurr,bitIndex4)
        <=> $false )
        & ( v15274(VarCurr,bitIndex3)
        <=> $false )
        & ( v15274(VarCurr,bitIndex2)
        <=> $false )
        & ( v15274(VarCurr,bitIndex1)
        <=> $false )
        & ( v15274(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_10907,axiom,
    ! [VarCurr] :
      ( ~ v131874(VarCurr)
    <=> v15310(VarCurr,bitIndex0) ) ).

fof(addAssignment_41329,axiom,
    ! [VarCurr] :
      ( v131863(VarCurr)
    <=> v13218(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_516,axiom,
    ! [VarCurr] :
      ( ~ v131855(VarCurr)
     => ( v11299(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_711,axiom,
    ! [VarCurr] :
      ( v131855(VarCurr)
     => ( v11299(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26434,axiom,
    ! [VarCurr] :
      ( v131855(VarCurr)
    <=> ( v131856(VarCurr)
        & v131845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26433,axiom,
    ! [VarCurr] :
      ( v131856(VarCurr)
    <=> ( v11301(VarCurr)
        & v10109(VarCurr) ) ) ).

fof(addAssignment_41328,axiom,
    ! [VarNext] :
      ( v13203(VarNext,bitIndex11)
    <=> v131847(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_134,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131848(VarNext)
       => ( ( v131847(VarNext,bitIndex11)
          <=> v13203(VarCurr,bitIndex12) )
          & ( v131847(VarNext,bitIndex10)
          <=> v13203(VarCurr,bitIndex11) )
          & ( v131847(VarNext,bitIndex9)
          <=> v13203(VarCurr,bitIndex10) )
          & ( v131847(VarNext,bitIndex8)
          <=> v13203(VarCurr,bitIndex9) )
          & ( v131847(VarNext,bitIndex7)
          <=> v13203(VarCurr,bitIndex8) )
          & ( v131847(VarNext,bitIndex6)
          <=> v13203(VarCurr,bitIndex7) )
          & ( v131847(VarNext,bitIndex5)
          <=> v13203(VarCurr,bitIndex6) )
          & ( v131847(VarNext,bitIndex4)
          <=> v13203(VarCurr,bitIndex5) )
          & ( v131847(VarNext,bitIndex3)
          <=> v13203(VarCurr,bitIndex4) )
          & ( v131847(VarNext,bitIndex2)
          <=> v13203(VarCurr,bitIndex3) )
          & ( v131847(VarNext,bitIndex1)
          <=> v13203(VarCurr,bitIndex2) )
          & ( v131847(VarNext,bitIndex0)
          <=> v13203(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2438,axiom,
    ! [VarNext] :
      ( v131848(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v131847(VarNext,B)
          <=> v114255(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26432,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131848(VarNext)
      <=> v131849(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26431,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131849(VarNext)
      <=> ( v131851(VarNext)
          & v114242(VarNext) ) ) ) ).

fof(writeUnaryOperator_10906,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131851(VarNext)
      <=> v114249(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_515,axiom,
    ! [VarCurr] :
      ( ~ v131836(VarCurr)
     => ( v11299(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_710,axiom,
    ! [VarCurr] :
      ( v131836(VarCurr)
     => ( v11299(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26430,axiom,
    ! [VarCurr] :
      ( v131836(VarCurr)
    <=> ( v131837(VarCurr)
        | v131838(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26429,axiom,
    ! [VarCurr] :
      ( v131838(VarCurr)
    <=> ( v131839(VarCurr)
        & v131845(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9217,axiom,
    ! [VarCurr] :
      ( v131845(VarCurr)
    <=> ( $true
      <=> v13203(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26428,axiom,
    ! [VarCurr] :
      ( v131839(VarCurr)
    <=> ( v131840(VarCurr)
        | v131842(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26427,axiom,
    ! [VarCurr] :
      ( v131842(VarCurr)
    <=> ( v131844(VarCurr)
        & v10109(VarCurr) ) ) ).

fof(writeUnaryOperator_10905,axiom,
    ! [VarCurr] :
      ( ~ v131844(VarCurr)
    <=> v11301(VarCurr) ) ).

fof(writeUnaryOperator_10904,axiom,
    ! [VarCurr] :
      ( ~ v131840(VarCurr)
    <=> v10109(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9216,axiom,
    ! [VarCurr] :
      ( v131837(VarCurr)
    <=> ( $true
      <=> v13203(VarCurr,bitIndex10) ) ) ).

fof(addAssignment_41327,axiom,
    ! [VarNext] :
      ( v13203(VarNext,bitIndex10)
    <=> v131828(VarNext,bitIndex9) ) ).

fof(addCaseBooleanConditionShiftedRanges1_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131829(VarNext)
       => ( ( v131828(VarNext,bitIndex11)
          <=> v13203(VarCurr,bitIndex12) )
          & ( v131828(VarNext,bitIndex10)
          <=> v13203(VarCurr,bitIndex11) )
          & ( v131828(VarNext,bitIndex9)
          <=> v13203(VarCurr,bitIndex10) )
          & ( v131828(VarNext,bitIndex8)
          <=> v13203(VarCurr,bitIndex9) )
          & ( v131828(VarNext,bitIndex7)
          <=> v13203(VarCurr,bitIndex8) )
          & ( v131828(VarNext,bitIndex6)
          <=> v13203(VarCurr,bitIndex7) )
          & ( v131828(VarNext,bitIndex5)
          <=> v13203(VarCurr,bitIndex6) )
          & ( v131828(VarNext,bitIndex4)
          <=> v13203(VarCurr,bitIndex5) )
          & ( v131828(VarNext,bitIndex3)
          <=> v13203(VarCurr,bitIndex4) )
          & ( v131828(VarNext,bitIndex2)
          <=> v13203(VarCurr,bitIndex3) )
          & ( v131828(VarNext,bitIndex1)
          <=> v13203(VarCurr,bitIndex2) )
          & ( v131828(VarNext,bitIndex0)
          <=> v13203(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2437,axiom,
    ! [VarNext] :
      ( v131829(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v131828(VarNext,B)
          <=> v114255(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26426,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131829(VarNext)
      <=> v131830(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26425,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131830(VarNext)
      <=> ( v131832(VarNext)
          & v114242(VarNext) ) ) ) ).

fof(writeUnaryOperator_10903,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131832(VarNext)
      <=> v114249(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_514,axiom,
    ! [VarCurr] :
      ( ~ v131822(VarCurr)
     => ( v11299(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_709,axiom,
    ! [VarCurr] :
      ( v131822(VarCurr)
     => ( v11299(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26424,axiom,
    ! [VarCurr] :
      ( v131822(VarCurr)
    <=> ( v131823(VarCurr)
        & v114238(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26423,axiom,
    ! [VarCurr] :
      ( v131823(VarCurr)
    <=> ( v131825(VarCurr)
        & v114218(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26422,axiom,
    ! [VarCurr] :
      ( v131825(VarCurr)
    <=> ( v131826(VarCurr)
        & v114236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26421,axiom,
    ! [VarCurr] :
      ( v131826(VarCurr)
    <=> ( v114233(VarCurr)
        & v114282(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26420,axiom,
    ! [VarCurr] :
      ( v13208(VarCurr)
    <=> ( v13210(VarCurr)
        & v131820(VarCurr) ) ) ).

fof(writeUnaryOperator_10902,axiom,
    ! [VarCurr] :
      ( ~ v131820(VarCurr)
    <=> v15281(VarCurr) ) ).

fof(addAssignment_41326,axiom,
    ! [VarCurr] :
      ( v15281(VarCurr)
    <=> v15283(VarCurr) ) ).

fof(addAssignment_41325,axiom,
    ! [VarCurr] :
      ( v15283(VarCurr)
    <=> v15285(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9215,axiom,
    ! [VarCurr] :
      ( v15285(VarCurr)
    <=> ( ( v131818(VarCurr,bitIndex4)
        <=> v131751(VarCurr,bitIndex4) )
        & ( v131818(VarCurr,bitIndex3)
        <=> v131751(VarCurr,bitIndex3) )
        & ( v131818(VarCurr,bitIndex2)
        <=> v131751(VarCurr,bitIndex2) )
        & ( v131818(VarCurr,bitIndex1)
        <=> v131751(VarCurr,bitIndex1) )
        & ( v131818(VarCurr,bitIndex0)
        <=> v131751(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_41324,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v131818(VarCurr,B)
      <=> v131667(VarCurr,B) ) ) ).

fof(addAssignment_41323,axiom,
    ! [VarCurr] :
      ( v131818(VarCurr,bitIndex4)
    <=> v15287(VarCurr) ) ).

fof(addAssignment_41322,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131751(VarCurr,B)
      <=> v131753(VarCurr,B) ) ) ).

fof(addAssignment_41321,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131753(VarCurr,B)
      <=> v131755(VarCurr,B) ) ) ).

fof(addAssignment_41320,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131755(VarCurr,B)
      <=> v131757(VarCurr,B) ) ) ).

fof(addAssignment_41319,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131757(VarCurr,B)
      <=> v131759(VarCurr,B) ) ) ).

fof(addAssignment_41318,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131759(VarCurr,B)
      <=> v131761(VarCurr,B) ) ) ).

fof(addAssignment_41317,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131761(VarCurr,B)
      <=> v131763(VarCurr,B) ) ) ).

fof(addAssignment_41316,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131763(VarCurr,B)
      <=> v131765(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131775(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v131765(VarNext,B)
            <=> v131765(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2436,axiom,
    ! [VarNext] :
      ( v131775(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131765(VarNext,B)
          <=> v131789(VarNext,B) ) ) ) ).

fof(addAssignment_41315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131789(VarNext,B)
          <=> v131787(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5398,axiom,
    ! [VarCurr] :
      ( ~ v131784(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131787(VarCurr,B)
          <=> v131790(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5387,axiom,
    ! [VarCurr] :
      ( v131784(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131787(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41314,axiom,
    ! [VarCurr] :
      ( v131790(VarCurr,bitIndex0)
    <=> v131812(VarCurr) ) ).

fof(addAssignment_41313,axiom,
    ! [VarCurr] :
      ( v131790(VarCurr,bitIndex1)
    <=> v131810(VarCurr) ) ).

fof(addAssignment_41312,axiom,
    ! [VarCurr] :
      ( v131790(VarCurr,bitIndex2)
    <=> v131805(VarCurr) ) ).

fof(addAssignment_41311,axiom,
    ! [VarCurr] :
      ( v131790(VarCurr,bitIndex3)
    <=> v131800(VarCurr) ) ).

fof(addAssignment_41310,axiom,
    ! [VarCurr] :
      ( v131790(VarCurr,bitIndex4)
    <=> v131792(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26419,axiom,
    ! [VarCurr] :
      ( v131810(VarCurr)
    <=> ( v131811(VarCurr)
        & v131814(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2618,axiom,
    ! [VarCurr] :
      ( v131814(VarCurr)
    <=> ( v131765(VarCurr,bitIndex0)
        | v131765(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26418,axiom,
    ! [VarCurr] :
      ( v131811(VarCurr)
    <=> ( v131812(VarCurr)
        | v131813(VarCurr) ) ) ).

fof(writeUnaryOperator_10901,axiom,
    ! [VarCurr] :
      ( ~ v131813(VarCurr)
    <=> v131765(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10900,axiom,
    ! [VarCurr] :
      ( ~ v131812(VarCurr)
    <=> v131765(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26417,axiom,
    ! [VarCurr] :
      ( v131805(VarCurr)
    <=> ( v131806(VarCurr)
        & v131809(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2617,axiom,
    ! [VarCurr] :
      ( v131809(VarCurr)
    <=> ( v131797(VarCurr)
        | v131765(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26416,axiom,
    ! [VarCurr] :
      ( v131806(VarCurr)
    <=> ( v131807(VarCurr)
        | v131808(VarCurr) ) ) ).

fof(writeUnaryOperator_10899,axiom,
    ! [VarCurr] :
      ( ~ v131808(VarCurr)
    <=> v131765(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10898,axiom,
    ! [VarCurr] :
      ( ~ v131807(VarCurr)
    <=> v131797(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26415,axiom,
    ! [VarCurr] :
      ( v131800(VarCurr)
    <=> ( v131801(VarCurr)
        & v131804(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2616,axiom,
    ! [VarCurr] :
      ( v131804(VarCurr)
    <=> ( v131796(VarCurr)
        | v131765(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26414,axiom,
    ! [VarCurr] :
      ( v131801(VarCurr)
    <=> ( v131802(VarCurr)
        | v131803(VarCurr) ) ) ).

fof(writeUnaryOperator_10897,axiom,
    ! [VarCurr] :
      ( ~ v131803(VarCurr)
    <=> v131765(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10896,axiom,
    ! [VarCurr] :
      ( ~ v131802(VarCurr)
    <=> v131796(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26413,axiom,
    ! [VarCurr] :
      ( v131792(VarCurr)
    <=> ( v131793(VarCurr)
        & v131799(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2615,axiom,
    ! [VarCurr] :
      ( v131799(VarCurr)
    <=> ( v131795(VarCurr)
        | v131765(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26412,axiom,
    ! [VarCurr] :
      ( v131793(VarCurr)
    <=> ( v131794(VarCurr)
        | v131798(VarCurr) ) ) ).

fof(writeUnaryOperator_10895,axiom,
    ! [VarCurr] :
      ( ~ v131798(VarCurr)
    <=> v131765(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10894,axiom,
    ! [VarCurr] :
      ( ~ v131794(VarCurr)
    <=> v131795(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2614,axiom,
    ! [VarCurr] :
      ( v131795(VarCurr)
    <=> ( v131796(VarCurr)
        & v131765(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2613,axiom,
    ! [VarCurr] :
      ( v131796(VarCurr)
    <=> ( v131797(VarCurr)
        & v131765(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2612,axiom,
    ! [VarCurr] :
      ( v131797(VarCurr)
    <=> ( v131765(VarCurr,bitIndex0)
        & v131765(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26411,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131775(VarNext)
      <=> ( v131776(VarNext)
          & v131783(VarNext) ) ) ) ).

fof(addAssignment_41309,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131783(VarNext)
      <=> v131781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26410,axiom,
    ! [VarCurr] :
      ( v131781(VarCurr)
    <=> ( v131784(VarCurr)
        | v131785(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26409,axiom,
    ! [VarCurr] :
      ( v131785(VarCurr)
    <=> ( v131767(VarCurr)
        & v131786(VarCurr) ) ) ).

fof(writeUnaryOperator_10893,axiom,
    ! [VarCurr] :
      ( ~ v131786(VarCurr)
    <=> v131784(VarCurr) ) ).

fof(writeUnaryOperator_10892,axiom,
    ! [VarCurr] :
      ( ~ v131784(VarCurr)
    <=> v15398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26408,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131776(VarNext)
      <=> ( v131777(VarNext)
          & v131318(VarNext) ) ) ) ).

fof(writeUnaryOperator_10891,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131777(VarNext)
      <=> v131325(VarNext) ) ) ).

fof(addAssignmentInitValueVector_37,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v131765(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_41308,axiom,
    ! [VarCurr] :
      ( v131767(VarCurr)
    <=> v131769(VarCurr) ) ).

fof(addAssignment_41307,axiom,
    ! [VarCurr] :
      ( v131769(VarCurr)
    <=> v131771(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26407,axiom,
    ! [VarCurr] :
      ( v131771(VarCurr)
    <=> ( v129789(VarCurr)
        & v15410(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131708(VarNext)
       => ( v15287(VarNext)
        <=> v15287(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2435,axiom,
    ! [VarNext] :
      ( v131708(VarNext)
     => ( v15287(VarNext)
      <=> v131721(VarNext) ) ) ).

fof(addAssignment_41306,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131721(VarNext)
      <=> v131719(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_26,axiom,
    ! [VarCurr] :
      ( ~ v131679(VarCurr)
     => ( v131719(VarCurr)
      <=> v131722(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5386,axiom,
    ! [VarCurr] :
      ( v131679(VarCurr)
     => ( v131719(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_41305,axiom,
    ! [VarCurr] :
      ( v131722(VarCurr,bitIndex0)
    <=> v131745(VarCurr) ) ).

fof(addAssignment_41304,axiom,
    ! [VarCurr] :
      ( v131722(VarCurr,bitIndex1)
    <=> v131743(VarCurr) ) ).

fof(addAssignment_41303,axiom,
    ! [VarCurr] :
      ( v131722(VarCurr,bitIndex2)
    <=> v131738(VarCurr) ) ).

fof(addAssignment_41302,axiom,
    ! [VarCurr] :
      ( v131722(VarCurr,bitIndex3)
    <=> v131733(VarCurr) ) ).

fof(addAssignment_41301,axiom,
    ! [VarCurr] :
      ( v131722(VarCurr,bitIndex4)
    <=> v131724(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26406,axiom,
    ! [VarCurr] :
      ( v131743(VarCurr)
    <=> ( v131744(VarCurr)
        & v131747(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2611,axiom,
    ! [VarCurr] :
      ( v131747(VarCurr)
    <=> ( v131730(VarCurr,bitIndex0)
        | v131730(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26405,axiom,
    ! [VarCurr] :
      ( v131744(VarCurr)
    <=> ( v131745(VarCurr)
        | v131746(VarCurr) ) ) ).

fof(writeUnaryOperator_10890,axiom,
    ! [VarCurr] :
      ( ~ v131746(VarCurr)
    <=> v131730(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10889,axiom,
    ! [VarCurr] :
      ( ~ v131745(VarCurr)
    <=> v131730(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26404,axiom,
    ! [VarCurr] :
      ( v131738(VarCurr)
    <=> ( v131739(VarCurr)
        & v131742(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2610,axiom,
    ! [VarCurr] :
      ( v131742(VarCurr)
    <=> ( v131729(VarCurr)
        | v131730(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26403,axiom,
    ! [VarCurr] :
      ( v131739(VarCurr)
    <=> ( v131740(VarCurr)
        | v131741(VarCurr) ) ) ).

fof(writeUnaryOperator_10888,axiom,
    ! [VarCurr] :
      ( ~ v131741(VarCurr)
    <=> v131730(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10887,axiom,
    ! [VarCurr] :
      ( ~ v131740(VarCurr)
    <=> v131729(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26402,axiom,
    ! [VarCurr] :
      ( v131733(VarCurr)
    <=> ( v131734(VarCurr)
        & v131737(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2609,axiom,
    ! [VarCurr] :
      ( v131737(VarCurr)
    <=> ( v131728(VarCurr)
        | v131730(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26401,axiom,
    ! [VarCurr] :
      ( v131734(VarCurr)
    <=> ( v131735(VarCurr)
        | v131736(VarCurr) ) ) ).

fof(writeUnaryOperator_10886,axiom,
    ! [VarCurr] :
      ( ~ v131736(VarCurr)
    <=> v131730(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10885,axiom,
    ! [VarCurr] :
      ( ~ v131735(VarCurr)
    <=> v131728(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26400,axiom,
    ! [VarCurr] :
      ( v131724(VarCurr)
    <=> ( v131725(VarCurr)
        & v131732(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2608,axiom,
    ! [VarCurr] :
      ( v131732(VarCurr)
    <=> ( v131727(VarCurr)
        | v131730(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26399,axiom,
    ! [VarCurr] :
      ( v131725(VarCurr)
    <=> ( v131726(VarCurr)
        | v131731(VarCurr) ) ) ).

fof(writeUnaryOperator_10884,axiom,
    ! [VarCurr] :
      ( ~ v131731(VarCurr)
    <=> v131730(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10883,axiom,
    ! [VarCurr] :
      ( ~ v131726(VarCurr)
    <=> v131727(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2607,axiom,
    ! [VarCurr] :
      ( v131727(VarCurr)
    <=> ( v131728(VarCurr)
        & v131730(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2606,axiom,
    ! [VarCurr] :
      ( v131728(VarCurr)
    <=> ( v131729(VarCurr)
        & v131730(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2605,axiom,
    ! [VarCurr] :
      ( v131729(VarCurr)
    <=> ( v131730(VarCurr,bitIndex0)
        & v131730(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_41300,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v131730(VarCurr,B)
      <=> v131667(VarCurr,B) ) ) ).

fof(addAssignment_41299,axiom,
    ! [VarCurr] :
      ( v131730(VarCurr,bitIndex4)
    <=> v15287(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26398,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131708(VarNext)
      <=> ( v131709(VarNext)
          & v131716(VarNext) ) ) ) ).

fof(addAssignment_41298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131716(VarNext)
      <=> v131714(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26397,axiom,
    ! [VarCurr] :
      ( v131714(VarCurr)
    <=> ( v131679(VarCurr)
        | v131717(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26396,axiom,
    ! [VarCurr] :
      ( v131717(VarCurr)
    <=> ( v15289(VarCurr)
        & v131718(VarCurr) ) ) ).

fof(writeUnaryOperator_10882,axiom,
    ! [VarCurr] :
      ( ~ v131718(VarCurr)
    <=> v131679(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26395,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131709(VarNext)
      <=> ( v131711(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_10881,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131711(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(addAssignmentInitValueVector_36,axiom,
    ( v15287(constB0)
  <=> $false ) ).

fof(addCaseBooleanConditionEqualRanges1_2317,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131670(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v131667(VarNext,B)
            <=> v131667(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2434,axiom,
    ! [VarNext] :
      ( v131670(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v131667(VarNext,B)
          <=> v131684(VarNext,B) ) ) ) ).

fof(addAssignment_41297,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v131684(VarNext,B)
          <=> v131682(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5397,axiom,
    ! [VarCurr] :
      ( ~ v131679(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v131682(VarCurr,B)
          <=> v131685(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5385,axiom,
    ! [VarCurr] :
      ( v131679(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v131682(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41296,axiom,
    ! [VarCurr] :
      ( v131685(VarCurr,bitIndex0)
    <=> v131701(VarCurr) ) ).

fof(addAssignment_41295,axiom,
    ! [VarCurr] :
      ( v131685(VarCurr,bitIndex1)
    <=> v131699(VarCurr) ) ).

fof(addAssignment_41294,axiom,
    ! [VarCurr] :
      ( v131685(VarCurr,bitIndex2)
    <=> v131694(VarCurr) ) ).

fof(addAssignment_41293,axiom,
    ! [VarCurr] :
      ( v131685(VarCurr,bitIndex3)
    <=> v131687(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26394,axiom,
    ! [VarCurr] :
      ( v131699(VarCurr)
    <=> ( v131700(VarCurr)
        & v131703(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2604,axiom,
    ! [VarCurr] :
      ( v131703(VarCurr)
    <=> ( v131667(VarCurr,bitIndex0)
        | v131667(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26393,axiom,
    ! [VarCurr] :
      ( v131700(VarCurr)
    <=> ( v131701(VarCurr)
        | v131702(VarCurr) ) ) ).

fof(writeUnaryOperator_10880,axiom,
    ! [VarCurr] :
      ( ~ v131702(VarCurr)
    <=> v131667(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10879,axiom,
    ! [VarCurr] :
      ( ~ v131701(VarCurr)
    <=> v131667(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26392,axiom,
    ! [VarCurr] :
      ( v131694(VarCurr)
    <=> ( v131695(VarCurr)
        & v131698(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2603,axiom,
    ! [VarCurr] :
      ( v131698(VarCurr)
    <=> ( v131691(VarCurr)
        | v131667(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26391,axiom,
    ! [VarCurr] :
      ( v131695(VarCurr)
    <=> ( v131696(VarCurr)
        | v131697(VarCurr) ) ) ).

fof(writeUnaryOperator_10878,axiom,
    ! [VarCurr] :
      ( ~ v131697(VarCurr)
    <=> v131667(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10877,axiom,
    ! [VarCurr] :
      ( ~ v131696(VarCurr)
    <=> v131691(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26390,axiom,
    ! [VarCurr] :
      ( v131687(VarCurr)
    <=> ( v131688(VarCurr)
        & v131693(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2602,axiom,
    ! [VarCurr] :
      ( v131693(VarCurr)
    <=> ( v131690(VarCurr)
        | v131667(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26389,axiom,
    ! [VarCurr] :
      ( v131688(VarCurr)
    <=> ( v131689(VarCurr)
        | v131692(VarCurr) ) ) ).

fof(writeUnaryOperator_10876,axiom,
    ! [VarCurr] :
      ( ~ v131692(VarCurr)
    <=> v131667(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10875,axiom,
    ! [VarCurr] :
      ( ~ v131689(VarCurr)
    <=> v131690(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2601,axiom,
    ! [VarCurr] :
      ( v131690(VarCurr)
    <=> ( v131691(VarCurr)
        & v131667(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2600,axiom,
    ! [VarCurr] :
      ( v131691(VarCurr)
    <=> ( v131667(VarCurr,bitIndex0)
        & v131667(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26388,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131670(VarNext)
      <=> ( v131671(VarNext)
          & v131678(VarNext) ) ) ) ).

fof(addAssignment_41292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131678(VarNext)
      <=> v131676(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26387,axiom,
    ! [VarCurr] :
      ( v131676(VarCurr)
    <=> ( v131679(VarCurr)
        | v131680(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26386,axiom,
    ! [VarCurr] :
      ( v131680(VarCurr)
    <=> ( v15289(VarCurr)
        & v131681(VarCurr) ) ) ).

fof(writeUnaryOperator_10874,axiom,
    ! [VarCurr] :
      ( ~ v131681(VarCurr)
    <=> v131679(VarCurr) ) ).

fof(writeUnaryOperator_10873,axiom,
    ! [VarCurr] :
      ( ~ v131679(VarCurr)
    <=> v10091(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26385,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131671(VarNext)
      <=> ( v131672(VarNext)
          & v15327(VarNext) ) ) ) ).

fof(writeUnaryOperator_10872,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131672(VarNext)
      <=> v15334(VarNext) ) ) ).

fof(addAssignmentInitValueVector_35,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v131667(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_41291,axiom,
    ! [VarCurr] :
      ( v15289(VarCurr)
    <=> v15291(VarCurr) ) ).

fof(addAssignment_41290,axiom,
    ! [VarCurr] :
      ( v15291(VarCurr)
    <=> v15293(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2599,axiom,
    ! [VarCurr] :
      ( v15293(VarCurr)
    <=> ( v10103(VarCurr,bitIndex15)
        | v10103(VarCurr,bitIndex19) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_513,axiom,
    ! [VarCurr] :
      ( ~ v131662(VarCurr)
     => ( v10103(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_708,axiom,
    ! [VarCurr] :
      ( v131662(VarCurr)
     => ( v10103(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26384,axiom,
    ! [VarCurr] :
      ( v131662(VarCurr)
    <=> ( v131663(VarCurr)
        | v131664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26383,axiom,
    ! [VarCurr] :
      ( v131664(VarCurr)
    <=> ( v10105(VarCurr)
        & v131652(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26382,axiom,
    ! [VarCurr] :
      ( v131663(VarCurr)
    <=> ( v10105(VarCurr)
        & v131649(VarCurr) ) ) ).

fof(addAssignment_41289,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex16)
    <=> v131654(VarNext,bitIndex15) ) ).

fof(addCaseBooleanConditionShiftedRanges1_132,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131655(VarNext)
       => ( ( v131654(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131654(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131654(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131654(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131654(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131654(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131654(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131654(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131654(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131654(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131654(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131654(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131654(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131654(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131654(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131654(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131654(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131654(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131654(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131654(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2433,axiom,
    ! [VarNext] :
      ( v131655(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131654(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26381,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131655(VarNext)
      <=> v131656(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26380,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131656(VarNext)
      <=> ( v131658(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10871,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131658(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_512,axiom,
    ! [VarCurr] :
      ( ~ v131646(VarCurr)
     => ( v10103(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_707,axiom,
    ! [VarCurr] :
      ( v131646(VarCurr)
     => ( v10103(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26379,axiom,
    ! [VarCurr] :
      ( v131646(VarCurr)
    <=> ( v131647(VarCurr)
        | v131650(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26378,axiom,
    ! [VarCurr] :
      ( v131650(VarCurr)
    <=> ( v131651(VarCurr)
        & v131652(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9214,axiom,
    ! [VarCurr] :
      ( v131652(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex16) ) ) ).

fof(writeUnaryOperator_10870,axiom,
    ! [VarCurr] :
      ( ~ v131651(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26377,axiom,
    ! [VarCurr] :
      ( v131647(VarCurr)
    <=> ( v131648(VarCurr)
        & v131649(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9213,axiom,
    ! [VarCurr] :
      ( v131649(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex14) ) ) ).

fof(writeUnaryOperator_10869,axiom,
    ! [VarCurr] :
      ( ~ v131648(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(addAssignment_41288,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex14)
    <=> v131638(VarNext,bitIndex13) ) ).

fof(addCaseBooleanConditionShiftedRanges1_131,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131639(VarNext)
       => ( ( v131638(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131638(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131638(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131638(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131638(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131638(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131638(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131638(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131638(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131638(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131638(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131638(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131638(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131638(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131638(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131638(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131638(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131638(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131638(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131638(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2432,axiom,
    ! [VarNext] :
      ( v131639(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131638(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26376,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131639(VarNext)
      <=> v131640(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26375,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131640(VarNext)
      <=> ( v131642(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10868,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131642(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_511,axiom,
    ! [VarCurr] :
      ( ~ v131636(VarCurr)
     => ( v10103(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_706,axiom,
    ! [VarCurr] :
      ( v131636(VarCurr)
     => ( v10103(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9212,axiom,
    ! [VarCurr] :
      ( v131636(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_41287,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex13)
    <=> v131628(VarNext,bitIndex12) ) ).

fof(addCaseBooleanConditionShiftedRanges1_130,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131629(VarNext)
       => ( ( v131628(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131628(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131628(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131628(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131628(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131628(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131628(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131628(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131628(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131628(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131628(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131628(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131628(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131628(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131628(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131628(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131628(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131628(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131628(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131628(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2431,axiom,
    ! [VarNext] :
      ( v131629(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131628(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131629(VarNext)
      <=> v131630(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26373,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131630(VarNext)
      <=> ( v131632(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10867,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131632(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_510,axiom,
    ! [VarCurr] :
      ( ~ v131623(VarCurr)
     => ( v10103(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_705,axiom,
    ! [VarCurr] :
      ( v131623(VarCurr)
     => ( v10103(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26372,axiom,
    ! [VarCurr] :
      ( v131623(VarCurr)
    <=> ( v131624(VarCurr)
        & v131429(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26371,axiom,
    ! [VarCurr] :
      ( v131624(VarCurr)
    <=> ( v131626(VarCurr)
        & v131428(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26370,axiom,
    ! [VarCurr] :
      ( v131626(VarCurr)
    <=> ( v131543(VarCurr)
        & v131380(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2316,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131611(VarNext)
       => ( v15295(VarNext,bitIndex0)
        <=> v15295(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2430,axiom,
    ! [VarNext] :
      ( v131611(VarNext)
     => ( v15295(VarNext,bitIndex0)
      <=> v131619(VarNext) ) ) ).

fof(addAssignment_41286,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131619(VarNext)
      <=> v131617(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3161,axiom,
    ! [VarCurr] :
      ( ~ v131411(VarCurr)
     => ( v131617(VarCurr)
      <=> v10103(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2966,axiom,
    ! [VarCurr] :
      ( v131411(VarCurr)
     => ( v131617(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26369,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131611(VarNext)
      <=> v131612(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26368,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131612(VarNext)
      <=> ( v131614(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10866,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131614(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3160,axiom,
    ! [VarCurr] :
      ( ~ v131594(VarCurr)
     => ( v10103(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2965,axiom,
    ! [VarCurr] :
      ( v131594(VarCurr)
     => ( v10103(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26367,axiom,
    ! [VarCurr] :
      ( v131594(VarCurr)
    <=> ( v131595(VarCurr)
        | v131608(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9211,axiom,
    ! [VarCurr] :
      ( v131608(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26366,axiom,
    ! [VarCurr] :
      ( v131595(VarCurr)
    <=> ( v131596(VarCurr)
        | v131607(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9210,axiom,
    ! [VarCurr] :
      ( v131607(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26365,axiom,
    ! [VarCurr] :
      ( v131596(VarCurr)
    <=> ( v131597(VarCurr)
        | v131606(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9209,axiom,
    ! [VarCurr] :
      ( v131606(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26364,axiom,
    ! [VarCurr] :
      ( v131597(VarCurr)
    <=> ( v131598(VarCurr)
        | v131605(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9208,axiom,
    ! [VarCurr] :
      ( v131605(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26363,axiom,
    ! [VarCurr] :
      ( v131598(VarCurr)
    <=> ( v131599(VarCurr)
        | v131604(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9207,axiom,
    ! [VarCurr] :
      ( v131604(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26362,axiom,
    ! [VarCurr] :
      ( v131599(VarCurr)
    <=> ( v131600(VarCurr)
        & v131429(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26361,axiom,
    ! [VarCurr] :
      ( v131600(VarCurr)
    <=> ( v131601(VarCurr)
        | v131602(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26360,axiom,
    ! [VarCurr] :
      ( v131602(VarCurr)
    <=> ( v131542(VarCurr)
        & v131428(VarCurr) ) ) ).

fof(addAssignment_41285,axiom,
    ! [VarCurr] :
      ( v131601(VarCurr)
    <=> v15300(VarCurr) ) ).

fof(addAssignment_41284,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex19)
    <=> v131586(VarNext,bitIndex18) ) ).

fof(addCaseBooleanConditionShiftedRanges1_129,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131587(VarNext)
       => ( ( v131586(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131586(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131586(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131586(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131586(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131586(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131586(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131586(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131586(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131586(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131586(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131586(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131586(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131586(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131586(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131586(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131586(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131586(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131586(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131586(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2429,axiom,
    ! [VarNext] :
      ( v131587(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131586(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26359,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131587(VarNext)
      <=> v131588(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26358,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131588(VarNext)
      <=> ( v131590(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10865,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131590(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_509,axiom,
    ! [VarCurr] :
      ( ~ v131582(VarCurr)
     => ( v10103(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_704,axiom,
    ! [VarCurr] :
      ( v131582(VarCurr)
     => ( v10103(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26357,axiom,
    ! [VarCurr] :
      ( v131582(VarCurr)
    <=> ( v131583(VarCurr)
        | v131584(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26356,axiom,
    ! [VarCurr] :
      ( v131584(VarCurr)
    <=> ( v10105(VarCurr)
        & v131572(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26355,axiom,
    ! [VarCurr] :
      ( v131583(VarCurr)
    <=> ( v10105(VarCurr)
        & v131569(VarCurr) ) ) ).

fof(addAssignment_41283,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex20)
    <=> v131574(VarNext,bitIndex19) ) ).

fof(addCaseBooleanConditionShiftedRanges1_128,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131575(VarNext)
       => ( ( v131574(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131574(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131574(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131574(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131574(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131574(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131574(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131574(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131574(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131574(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131574(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131574(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131574(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131574(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131574(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131574(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131574(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131574(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131574(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131574(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2428,axiom,
    ! [VarNext] :
      ( v131575(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131574(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26354,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131575(VarNext)
      <=> v131576(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26353,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131576(VarNext)
      <=> ( v131578(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10864,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131578(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_508,axiom,
    ! [VarCurr] :
      ( ~ v131566(VarCurr)
     => ( v10103(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_703,axiom,
    ! [VarCurr] :
      ( v131566(VarCurr)
     => ( v10103(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26352,axiom,
    ! [VarCurr] :
      ( v131566(VarCurr)
    <=> ( v131567(VarCurr)
        | v131570(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26351,axiom,
    ! [VarCurr] :
      ( v131570(VarCurr)
    <=> ( v131571(VarCurr)
        & v131572(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9206,axiom,
    ! [VarCurr] :
      ( v131572(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex20) ) ) ).

fof(writeUnaryOperator_10863,axiom,
    ! [VarCurr] :
      ( ~ v131571(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26350,axiom,
    ! [VarCurr] :
      ( v131567(VarCurr)
    <=> ( v131568(VarCurr)
        & v131569(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9205,axiom,
    ! [VarCurr] :
      ( v131569(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex18) ) ) ).

fof(writeUnaryOperator_10862,axiom,
    ! [VarCurr] :
      ( ~ v131568(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(addAssignment_41282,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex18)
    <=> v131558(VarNext,bitIndex17) ) ).

fof(addCaseBooleanConditionShiftedRanges1_127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131559(VarNext)
       => ( ( v131558(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131558(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131558(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131558(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131558(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131558(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131558(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131558(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131558(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131558(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131558(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131558(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131558(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131558(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131558(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131558(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131558(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131558(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131558(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131558(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2427,axiom,
    ! [VarNext] :
      ( v131559(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131558(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131559(VarNext)
      <=> v131560(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26348,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131560(VarNext)
      <=> ( v131562(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10861,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131562(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_507,axiom,
    ! [VarCurr] :
      ( ~ v131556(VarCurr)
     => ( v10103(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_702,axiom,
    ! [VarCurr] :
      ( v131556(VarCurr)
     => ( v10103(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9204,axiom,
    ! [VarCurr] :
      ( v131556(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex17) ) ) ).

fof(addAssignment_41281,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex17)
    <=> v131548(VarNext,bitIndex16) ) ).

fof(addCaseBooleanConditionShiftedRanges1_126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131549(VarNext)
       => ( ( v131548(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131548(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131548(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131548(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131548(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131548(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131548(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131548(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131548(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131548(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131548(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131548(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131548(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131548(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131548(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131548(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131548(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131548(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131548(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131548(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2426,axiom,
    ! [VarNext] :
      ( v131549(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131548(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26347,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131549(VarNext)
      <=> v131550(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26346,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131550(VarNext)
      <=> ( v131552(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10860,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131552(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_506,axiom,
    ! [VarCurr] :
      ( ~ v131539(VarCurr)
     => ( v10103(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_701,axiom,
    ! [VarCurr] :
      ( v131539(VarCurr)
     => ( v10103(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26345,axiom,
    ! [VarCurr] :
      ( v131539(VarCurr)
    <=> ( v131540(VarCurr)
        & v131429(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26344,axiom,
    ! [VarCurr] :
      ( v131540(VarCurr)
    <=> ( v131542(VarCurr)
        & v131388(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26343,axiom,
    ! [VarCurr] :
      ( v131542(VarCurr)
    <=> ( v131543(VarCurr)
        & v131427(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26342,axiom,
    ! [VarCurr] :
      ( v131543(VarCurr)
    <=> ( v131544(VarCurr)
        & v131426(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26341,axiom,
    ! [VarCurr] :
      ( v131544(VarCurr)
    <=> ( v131545(VarCurr)
        & v131425(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26340,axiom,
    ! [VarCurr] :
      ( v131545(VarCurr)
    <=> ( v131424(VarCurr)
        & v131546(VarCurr) ) ) ).

fof(writeUnaryOperator_10859,axiom,
    ! [VarCurr] :
      ( ~ v131546(VarCurr)
    <=> v131376(VarCurr) ) ).

fof(addAssignment_41280,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex15)
    <=> v131531(VarNext,bitIndex14) ) ).

fof(addCaseBooleanConditionShiftedRanges1_125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131532(VarNext)
       => ( ( v131531(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131531(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131531(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131531(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131531(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131531(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131531(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131531(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131531(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131531(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131531(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131531(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131531(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131531(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131531(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131531(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131531(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131531(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131531(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131531(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2425,axiom,
    ! [VarNext] :
      ( v131532(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131531(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26339,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131532(VarNext)
      <=> v131533(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131533(VarNext)
      <=> ( v131535(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10858,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131535(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addAssignment_41279,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex11)
    <=> v131523(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131524(VarNext)
       => ( ( v131523(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131523(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131523(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131523(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131523(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131523(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131523(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131523(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131523(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131523(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131523(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131523(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131523(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131523(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131523(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131523(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131523(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131523(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131523(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131523(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2424,axiom,
    ! [VarNext] :
      ( v131524(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131523(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131524(VarNext)
      <=> v131525(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131525(VarNext)
      <=> ( v131527(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10857,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131527(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_505,axiom,
    ! [VarCurr] :
      ( ~ v131517(VarCurr)
     => ( v10103(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_700,axiom,
    ! [VarCurr] :
      ( v131517(VarCurr)
     => ( v10103(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26335,axiom,
    ! [VarCurr] :
      ( v131517(VarCurr)
    <=> ( v131518(VarCurr)
        | v131520(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26334,axiom,
    ! [VarCurr] :
      ( v131520(VarCurr)
    <=> ( v131521(VarCurr)
        & v131507(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26333,axiom,
    ! [VarCurr] :
      ( v131521(VarCurr)
    <=> ( v10105(VarCurr)
        & v131415(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26332,axiom,
    ! [VarCurr] :
      ( v131518(VarCurr)
    <=> ( v131519(VarCurr)
        & v131502(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26331,axiom,
    ! [VarCurr] :
      ( v131519(VarCurr)
    <=> ( v10105(VarCurr)
        & v131415(VarCurr) ) ) ).

fof(addAssignment_41278,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex12)
    <=> v131509(VarNext,bitIndex11) ) ).

fof(addCaseBooleanConditionShiftedRanges1_123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131510(VarNext)
       => ( ( v131509(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131509(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131509(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131509(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131509(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131509(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131509(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131509(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131509(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131509(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131509(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131509(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131509(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131509(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131509(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131509(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131509(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131509(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131509(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131509(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2423,axiom,
    ! [VarNext] :
      ( v131510(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131509(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26330,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131510(VarNext)
      <=> v131511(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131511(VarNext)
      <=> ( v131513(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10856,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131513(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_504,axiom,
    ! [VarCurr] :
      ( ~ v131497(VarCurr)
     => ( v10103(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_699,axiom,
    ! [VarCurr] :
      ( v131497(VarCurr)
     => ( v10103(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26328,axiom,
    ! [VarCurr] :
      ( v131497(VarCurr)
    <=> ( v131498(VarCurr)
        | v131503(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26327,axiom,
    ! [VarCurr] :
      ( v131503(VarCurr)
    <=> ( v131504(VarCurr)
        & v131507(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9203,axiom,
    ! [VarCurr] :
      ( v131507(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26326,axiom,
    ! [VarCurr] :
      ( v131504(VarCurr)
    <=> ( v131505(VarCurr)
        | v131506(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26325,axiom,
    ! [VarCurr] :
      ( v131506(VarCurr)
    <=> ( v10105(VarCurr)
        & v131456(VarCurr) ) ) ).

fof(writeUnaryOperator_10855,axiom,
    ! [VarCurr] :
      ( ~ v131505(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26324,axiom,
    ! [VarCurr] :
      ( v131498(VarCurr)
    <=> ( v131499(VarCurr)
        & v131502(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9202,axiom,
    ! [VarCurr] :
      ( v131502(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26323,axiom,
    ! [VarCurr] :
      ( v131499(VarCurr)
    <=> ( v131500(VarCurr)
        | v131501(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26322,axiom,
    ! [VarCurr] :
      ( v131501(VarCurr)
    <=> ( v10105(VarCurr)
        & v131456(VarCurr) ) ) ).

fof(writeUnaryOperator_10854,axiom,
    ! [VarCurr] :
      ( ~ v131500(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(addAssignment_41277,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex10)
    <=> v131489(VarNext,bitIndex9) ) ).

fof(addCaseBooleanConditionShiftedRanges1_122,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131490(VarNext)
       => ( ( v131489(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131489(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131489(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131489(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131489(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131489(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131489(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131489(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131489(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131489(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131489(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131489(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131489(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131489(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131489(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131489(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131489(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131489(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131489(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131489(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2422,axiom,
    ! [VarNext] :
      ( v131490(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131489(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26321,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131490(VarNext)
      <=> v131491(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131491(VarNext)
      <=> ( v131493(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10853,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131493(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_503,axiom,
    ! [VarCurr] :
      ( ~ v131487(VarCurr)
     => ( v10103(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_698,axiom,
    ! [VarCurr] :
      ( v131487(VarCurr)
     => ( v10103(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9201,axiom,
    ! [VarCurr] :
      ( v131487(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_41276,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex7)
    <=> v131479(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionShiftedRanges1_121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131480(VarNext)
       => ( ( v131479(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131479(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131479(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131479(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131479(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131479(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131479(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131479(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131479(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131479(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131479(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131479(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131479(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131479(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131479(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131479(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131479(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131479(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131479(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131479(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2421,axiom,
    ! [VarNext] :
      ( v131480(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131479(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131480(VarNext)
      <=> v131481(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131481(VarNext)
      <=> ( v131483(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10852,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131483(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_502,axiom,
    ! [VarCurr] :
      ( ~ v131472(VarCurr)
     => ( v10103(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_697,axiom,
    ! [VarCurr] :
      ( v131472(VarCurr)
     => ( v10103(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26317,axiom,
    ! [VarCurr] :
      ( v131472(VarCurr)
    <=> ( v131473(VarCurr)
        | v131476(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26316,axiom,
    ! [VarCurr] :
      ( v131476(VarCurr)
    <=> ( v131477(VarCurr)
        & v131462(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26315,axiom,
    ! [VarCurr] :
      ( v131477(VarCurr)
    <=> ( v10105(VarCurr)
        & v131415(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26314,axiom,
    ! [VarCurr] :
      ( v131473(VarCurr)
    <=> ( v131474(VarCurr)
        & v131457(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26313,axiom,
    ! [VarCurr] :
      ( v131474(VarCurr)
    <=> ( v10105(VarCurr)
        & v131415(VarCurr) ) ) ).

fof(addAssignment_41275,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex8)
    <=> v131464(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionShiftedRanges1_120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131465(VarNext)
       => ( ( v131464(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131464(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131464(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131464(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131464(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131464(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131464(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131464(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131464(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131464(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131464(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131464(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131464(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131464(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131464(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131464(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131464(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131464(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131464(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131464(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2420,axiom,
    ! [VarNext] :
      ( v131465(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131464(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26312,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131465(VarNext)
      <=> v131466(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26311,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131466(VarNext)
      <=> ( v131468(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10851,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131468(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_501,axiom,
    ! [VarCurr] :
      ( ~ v131449(VarCurr)
     => ( v10103(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_696,axiom,
    ! [VarCurr] :
      ( v131449(VarCurr)
     => ( v10103(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26310,axiom,
    ! [VarCurr] :
      ( v131449(VarCurr)
    <=> ( v131450(VarCurr)
        | v131458(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26309,axiom,
    ! [VarCurr] :
      ( v131458(VarCurr)
    <=> ( v131459(VarCurr)
        & v131462(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9200,axiom,
    ! [VarCurr] :
      ( v131462(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26308,axiom,
    ! [VarCurr] :
      ( v131459(VarCurr)
    <=> ( v131460(VarCurr)
        | v131461(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26307,axiom,
    ! [VarCurr] :
      ( v131461(VarCurr)
    <=> ( v10105(VarCurr)
        & v131456(VarCurr) ) ) ).

fof(writeUnaryOperator_10850,axiom,
    ! [VarCurr] :
      ( ~ v131460(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26306,axiom,
    ! [VarCurr] :
      ( v131450(VarCurr)
    <=> ( v131451(VarCurr)
        & v131457(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9199,axiom,
    ! [VarCurr] :
      ( v131457(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26305,axiom,
    ! [VarCurr] :
      ( v131451(VarCurr)
    <=> ( v131452(VarCurr)
        | v131454(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26304,axiom,
    ! [VarCurr] :
      ( v131454(VarCurr)
    <=> ( v10105(VarCurr)
        & v131456(VarCurr) ) ) ).

fof(writeUnaryOperator_10849,axiom,
    ! [VarCurr] :
      ( ~ v131456(VarCurr)
    <=> v131415(VarCurr) ) ).

fof(writeUnaryOperator_10848,axiom,
    ! [VarCurr] :
      ( ~ v131452(VarCurr)
    <=> v10105(VarCurr) ) ).

fof(addAssignment_41274,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex6)
    <=> v131441(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionShiftedRanges1_119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131442(VarNext)
       => ( ( v131441(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131441(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131441(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131441(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131441(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131441(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131441(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131441(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131441(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131441(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131441(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131441(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131441(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131441(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131441(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131441(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131441(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131441(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131441(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131441(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2419,axiom,
    ! [VarNext] :
      ( v131442(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131441(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131442(VarNext)
      <=> v131443(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26302,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131443(VarNext)
      <=> ( v131445(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10847,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131445(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_500,axiom,
    ! [VarCurr] :
      ( ~ v131439(VarCurr)
     => ( v10103(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_695,axiom,
    ! [VarCurr] :
      ( v131439(VarCurr)
     => ( v10103(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9198,axiom,
    ! [VarCurr] :
      ( v131439(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex5) ) ) ).

fof(addAssignment_41273,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex5)
    <=> v131431(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionShiftedRanges1_118,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131432(VarNext)
       => ( ( v131431(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131431(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131431(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131431(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131431(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131431(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131431(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131431(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131431(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131431(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131431(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131431(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131431(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131431(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131431(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131431(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131431(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131431(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131431(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131431(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2418,axiom,
    ! [VarNext] :
      ( v131432(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131431(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26301,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131432(VarNext)
      <=> v131433(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26300,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131433(VarNext)
      <=> ( v131435(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10846,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131435(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_499,axiom,
    ! [VarCurr] :
      ( ~ v131417(VarCurr)
     => ( v10103(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_694,axiom,
    ! [VarCurr] :
      ( v131417(VarCurr)
     => ( v10103(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26299,axiom,
    ! [VarCurr] :
      ( v131417(VarCurr)
    <=> ( v131418(VarCurr)
        & v131429(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9197,axiom,
    ! [VarCurr] :
      ( v131429(VarCurr)
    <=> ( $true
      <=> v15295(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26298,axiom,
    ! [VarCurr] :
      ( v131418(VarCurr)
    <=> ( v131420(VarCurr)
        & v131428(VarCurr) ) ) ).

fof(writeUnaryOperator_10845,axiom,
    ! [VarCurr] :
      ( ~ v131428(VarCurr)
    <=> v131388(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26297,axiom,
    ! [VarCurr] :
      ( v131420(VarCurr)
    <=> ( v131421(VarCurr)
        & v131427(VarCurr) ) ) ).

fof(writeUnaryOperator_10844,axiom,
    ! [VarCurr] :
      ( ~ v131427(VarCurr)
    <=> v131380(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26296,axiom,
    ! [VarCurr] :
      ( v131421(VarCurr)
    <=> ( v131422(VarCurr)
        & v131426(VarCurr) ) ) ).

fof(writeUnaryOperator_10843,axiom,
    ! [VarCurr] :
      ( ~ v131426(VarCurr)
    <=> v15302(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26295,axiom,
    ! [VarCurr] :
      ( v131422(VarCurr)
    <=> ( v131423(VarCurr)
        & v131425(VarCurr) ) ) ).

fof(writeUnaryOperator_10842,axiom,
    ! [VarCurr] :
      ( ~ v131425(VarCurr)
    <=> v131378(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26294,axiom,
    ! [VarCurr] :
      ( v131423(VarCurr)
    <=> ( v131424(VarCurr)
        & v131376(VarCurr) ) ) ).

fof(writeUnaryOperator_10841,axiom,
    ! [VarCurr] :
      ( ~ v131424(VarCurr)
    <=> v15300(VarCurr) ) ).

fof(addAssignment_41272,axiom,
    ! [VarCurr] :
      ( v131415(VarCurr)
    <=> v11303(VarCurr) ) ).

fof(addAssignment_41271,axiom,
    ! [VarNext] :
      ( v15295(VarNext,bitIndex3)
    <=> v131399(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionShiftedRanges1_117,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131400(VarNext)
       => ( ( v131399(VarNext,bitIndex19)
          <=> v15295(VarCurr,bitIndex20) )
          & ( v131399(VarNext,bitIndex18)
          <=> v15295(VarCurr,bitIndex19) )
          & ( v131399(VarNext,bitIndex17)
          <=> v15295(VarCurr,bitIndex18) )
          & ( v131399(VarNext,bitIndex16)
          <=> v15295(VarCurr,bitIndex17) )
          & ( v131399(VarNext,bitIndex15)
          <=> v15295(VarCurr,bitIndex16) )
          & ( v131399(VarNext,bitIndex14)
          <=> v15295(VarCurr,bitIndex15) )
          & ( v131399(VarNext,bitIndex13)
          <=> v15295(VarCurr,bitIndex14) )
          & ( v131399(VarNext,bitIndex12)
          <=> v15295(VarCurr,bitIndex13) )
          & ( v131399(VarNext,bitIndex11)
          <=> v15295(VarCurr,bitIndex12) )
          & ( v131399(VarNext,bitIndex10)
          <=> v15295(VarCurr,bitIndex11) )
          & ( v131399(VarNext,bitIndex9)
          <=> v15295(VarCurr,bitIndex10) )
          & ( v131399(VarNext,bitIndex8)
          <=> v15295(VarCurr,bitIndex9) )
          & ( v131399(VarNext,bitIndex7)
          <=> v15295(VarCurr,bitIndex8) )
          & ( v131399(VarNext,bitIndex6)
          <=> v15295(VarCurr,bitIndex7) )
          & ( v131399(VarNext,bitIndex5)
          <=> v15295(VarCurr,bitIndex6) )
          & ( v131399(VarNext,bitIndex4)
          <=> v15295(VarCurr,bitIndex5) )
          & ( v131399(VarNext,bitIndex3)
          <=> v15295(VarCurr,bitIndex4) )
          & ( v131399(VarNext,bitIndex2)
          <=> v15295(VarCurr,bitIndex3) )
          & ( v131399(VarNext,bitIndex1)
          <=> v15295(VarCurr,bitIndex2) )
          & ( v131399(VarNext,bitIndex0)
          <=> v15295(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2417,axiom,
    ! [VarNext] :
      ( v131400(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131399(VarNext,B)
          <=> v131410(VarNext,B) ) ) ) ).

fof(addAssignment_41270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131410(VarNext,B)
          <=> v131408(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_498,axiom,
    ! [VarCurr] :
      ( ~ v131411(VarCurr)
     => ( ( v131408(VarCurr,bitIndex19)
        <=> v10103(VarCurr,bitIndex20) )
        & ( v131408(VarCurr,bitIndex18)
        <=> v10103(VarCurr,bitIndex19) )
        & ( v131408(VarCurr,bitIndex17)
        <=> v10103(VarCurr,bitIndex18) )
        & ( v131408(VarCurr,bitIndex16)
        <=> v10103(VarCurr,bitIndex17) )
        & ( v131408(VarCurr,bitIndex15)
        <=> v10103(VarCurr,bitIndex16) )
        & ( v131408(VarCurr,bitIndex14)
        <=> v10103(VarCurr,bitIndex15) )
        & ( v131408(VarCurr,bitIndex13)
        <=> v10103(VarCurr,bitIndex14) )
        & ( v131408(VarCurr,bitIndex12)
        <=> v10103(VarCurr,bitIndex13) )
        & ( v131408(VarCurr,bitIndex11)
        <=> v10103(VarCurr,bitIndex12) )
        & ( v131408(VarCurr,bitIndex10)
        <=> v10103(VarCurr,bitIndex11) )
        & ( v131408(VarCurr,bitIndex9)
        <=> v10103(VarCurr,bitIndex10) )
        & ( v131408(VarCurr,bitIndex8)
        <=> v10103(VarCurr,bitIndex9) )
        & ( v131408(VarCurr,bitIndex7)
        <=> v10103(VarCurr,bitIndex8) )
        & ( v131408(VarCurr,bitIndex6)
        <=> v10103(VarCurr,bitIndex7) )
        & ( v131408(VarCurr,bitIndex5)
        <=> v10103(VarCurr,bitIndex6) )
        & ( v131408(VarCurr,bitIndex4)
        <=> v10103(VarCurr,bitIndex5) )
        & ( v131408(VarCurr,bitIndex3)
        <=> v10103(VarCurr,bitIndex4) )
        & ( v131408(VarCurr,bitIndex2)
        <=> v10103(VarCurr,bitIndex3) )
        & ( v131408(VarCurr,bitIndex1)
        <=> v10103(VarCurr,bitIndex2) )
        & ( v131408(VarCurr,bitIndex0)
        <=> v10103(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2964,axiom,
    ! [VarCurr] :
      ( v131411(VarCurr)
     => ! [B] :
          ( range_19_0(B)
         => ( v131408(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_10840,axiom,
    ! [VarCurr] :
      ( ~ v131411(VarCurr)
    <=> v15297(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26293,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131400(VarNext)
      <=> v131401(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131401(VarNext)
      <=> ( v131402(VarNext)
          & v131395(VarNext) ) ) ) ).

fof(writeUnaryOperator_10839,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131402(VarNext)
      <=> v131404(VarNext) ) ) ).

fof(addAssignment_41269,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131404(VarNext)
      <=> v131395(VarCurr) ) ) ).

fof(addAssignmentInitValue_43,axiom,
    ~ v15295(constB0,bitIndex3) ).

fof(addAssignmentInitValue_42,axiom,
    ~ v15295(constB0,bitIndex2) ).

fof(addAssignmentInitValue_41,axiom,
    ~ v15295(constB0,bitIndex1) ).

fof(bitBlastConstant_12664,axiom,
    ~ bxxxxxxxxxxxxxxxxx000(bitIndex2) ).

fof(bitBlastConstant_12663,axiom,
    ~ bxxxxxxxxxxxxxxxxx000(bitIndex1) ).

fof(bitBlastConstant_12662,axiom,
    ~ bxxxxxxxxxxxxxxxxx000(bitIndex0) ).

fof(addAssignmentInitValueVector_34,axiom,
    ( v15295(constB0,bitIndex0)
  <=> $true ) ).

fof(addAssignment_41268,axiom,
    ! [VarCurr] :
      ( v131395(VarCurr)
    <=> v13228(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26291,axiom,
    ! [VarCurr] :
      ( v131388(VarCurr)
    <=> ( v131390(VarCurr)
        & v131392(VarCurr) ) ) ).

fof(writeUnaryOperator_10838,axiom,
    ! [VarCurr] :
      ( ~ v131392(VarCurr)
    <=> v131384(VarCurr) ) ).

fof(addAssignment_41267,axiom,
    ! [VarCurr] :
      ( v131390(VarCurr)
    <=> v114182(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26290,axiom,
    ! [VarCurr] :
      ( v131380(VarCurr)
    <=> ( v131382(VarCurr)
        & v131386(VarCurr) ) ) ).

fof(writeUnaryOperator_10837,axiom,
    ! [VarCurr] :
      ( ~ v131386(VarCurr)
    <=> v131384(VarCurr) ) ).

fof(addAssignment_41266,axiom,
    ! [VarCurr] :
      ( v131384(VarCurr)
    <=> v15283(VarCurr) ) ).

fof(addAssignment_41265,axiom,
    ! [VarCurr] :
      ( v131382(VarCurr)
    <=> v13212(VarCurr) ) ).

fof(addAssignment_41264,axiom,
    ! [VarCurr] :
      ( v131378(VarCurr)
    <=> v114222(VarCurr) ) ).

fof(addAssignment_41263,axiom,
    ! [VarCurr] :
      ( v131376(VarCurr)
    <=> v114204(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26289,axiom,
    ! [VarCurr] :
      ( v15302(VarCurr)
    <=> ( v15304(VarCurr)
        & v131374(VarCurr) ) ) ).

fof(writeUnaryOperator_10836,axiom,
    ! [VarCurr] :
      ( ~ v131374(VarCurr)
    <=> v15319(VarCurr) ) ).

fof(addAssignment_41262,axiom,
    ! [VarCurr] :
      ( v15319(VarCurr)
    <=> v15321(VarCurr) ) ).

fof(addAssignment_41261,axiom,
    ! [VarCurr] :
      ( v15321(VarCurr)
    <=> v15323(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9196,axiom,
    ! [VarCurr] :
      ( v15323(VarCurr)
    <=> ( ( v131372(VarCurr,bitIndex5)
        <=> v15382(VarCurr,bitIndex5) )
        & ( v131372(VarCurr,bitIndex4)
        <=> v15382(VarCurr,bitIndex4) )
        & ( v131372(VarCurr,bitIndex3)
        <=> v15382(VarCurr,bitIndex3) )
        & ( v131372(VarCurr,bitIndex2)
        <=> v15382(VarCurr,bitIndex2) )
        & ( v131372(VarCurr,bitIndex1)
        <=> v15382(VarCurr,bitIndex1) )
        & ( v131372(VarCurr,bitIndex0)
        <=> v15382(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_41260,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131372(VarCurr,B)
      <=> v10089(VarCurr,B) ) ) ).

fof(addAssignment_41259,axiom,
    ! [VarCurr] :
      ( v131372(VarCurr,bitIndex5)
    <=> v15325(VarCurr) ) ).

fof(addAssignment_41258,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15382(VarCurr,B)
      <=> v15384(VarCurr,B) ) ) ).

fof(addAssignment_41257,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15384(VarCurr,B)
      <=> v15386(VarCurr,B) ) ) ).

fof(addAssignment_41256,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15386(VarCurr,B)
      <=> v15388(VarCurr,B) ) ) ).

fof(addAssignment_41255,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15388(VarCurr,B)
      <=> v15390(VarCurr,B) ) ) ).

fof(addAssignment_41254,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15390(VarCurr,B)
      <=> v15392(VarCurr,B) ) ) ).

fof(addAssignment_41253,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15392(VarCurr,B)
      <=> v15394(VarCurr,B) ) ) ).

fof(addAssignment_41252,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15394(VarCurr,B)
      <=> v15396(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131321(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v15396(VarNext,B)
            <=> v15396(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2416,axiom,
    ! [VarNext] :
      ( v131321(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v15396(VarNext,B)
          <=> v131337(VarNext,B) ) ) ) ).

fof(addAssignment_41251,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v131337(VarNext,B)
          <=> v131335(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5396,axiom,
    ! [VarCurr] :
      ( ~ v131332(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v131335(VarCurr,B)
          <=> v131338(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5384,axiom,
    ! [VarCurr] :
      ( v131332(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v131335(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41250,axiom,
    ! [VarCurr] :
      ( v131338(VarCurr,bitIndex0)
    <=> v131366(VarCurr) ) ).

fof(addAssignment_41249,axiom,
    ! [VarCurr] :
      ( v131338(VarCurr,bitIndex1)
    <=> v131364(VarCurr) ) ).

fof(addAssignment_41248,axiom,
    ! [VarCurr] :
      ( v131338(VarCurr,bitIndex2)
    <=> v131359(VarCurr) ) ).

fof(addAssignment_41247,axiom,
    ! [VarCurr] :
      ( v131338(VarCurr,bitIndex3)
    <=> v131354(VarCurr) ) ).

fof(addAssignment_41246,axiom,
    ! [VarCurr] :
      ( v131338(VarCurr,bitIndex4)
    <=> v131349(VarCurr) ) ).

fof(addAssignment_41245,axiom,
    ! [VarCurr] :
      ( v131338(VarCurr,bitIndex5)
    <=> v131340(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26288,axiom,
    ! [VarCurr] :
      ( v131364(VarCurr)
    <=> ( v131365(VarCurr)
        & v131368(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2598,axiom,
    ! [VarCurr] :
      ( v131368(VarCurr)
    <=> ( v15396(VarCurr,bitIndex0)
        | v15396(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26287,axiom,
    ! [VarCurr] :
      ( v131365(VarCurr)
    <=> ( v131366(VarCurr)
        | v131367(VarCurr) ) ) ).

fof(writeUnaryOperator_10835,axiom,
    ! [VarCurr] :
      ( ~ v131367(VarCurr)
    <=> v15396(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10834,axiom,
    ! [VarCurr] :
      ( ~ v131366(VarCurr)
    <=> v15396(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26286,axiom,
    ! [VarCurr] :
      ( v131359(VarCurr)
    <=> ( v131360(VarCurr)
        & v131363(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2597,axiom,
    ! [VarCurr] :
      ( v131363(VarCurr)
    <=> ( v131346(VarCurr)
        | v15396(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26285,axiom,
    ! [VarCurr] :
      ( v131360(VarCurr)
    <=> ( v131361(VarCurr)
        | v131362(VarCurr) ) ) ).

fof(writeUnaryOperator_10833,axiom,
    ! [VarCurr] :
      ( ~ v131362(VarCurr)
    <=> v15396(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10832,axiom,
    ! [VarCurr] :
      ( ~ v131361(VarCurr)
    <=> v131346(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26284,axiom,
    ! [VarCurr] :
      ( v131354(VarCurr)
    <=> ( v131355(VarCurr)
        & v131358(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2596,axiom,
    ! [VarCurr] :
      ( v131358(VarCurr)
    <=> ( v131345(VarCurr)
        | v15396(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26283,axiom,
    ! [VarCurr] :
      ( v131355(VarCurr)
    <=> ( v131356(VarCurr)
        | v131357(VarCurr) ) ) ).

fof(writeUnaryOperator_10831,axiom,
    ! [VarCurr] :
      ( ~ v131357(VarCurr)
    <=> v15396(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10830,axiom,
    ! [VarCurr] :
      ( ~ v131356(VarCurr)
    <=> v131345(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26282,axiom,
    ! [VarCurr] :
      ( v131349(VarCurr)
    <=> ( v131350(VarCurr)
        & v131353(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2595,axiom,
    ! [VarCurr] :
      ( v131353(VarCurr)
    <=> ( v131344(VarCurr)
        | v15396(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26281,axiom,
    ! [VarCurr] :
      ( v131350(VarCurr)
    <=> ( v131351(VarCurr)
        | v131352(VarCurr) ) ) ).

fof(writeUnaryOperator_10829,axiom,
    ! [VarCurr] :
      ( ~ v131352(VarCurr)
    <=> v15396(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10828,axiom,
    ! [VarCurr] :
      ( ~ v131351(VarCurr)
    <=> v131344(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26280,axiom,
    ! [VarCurr] :
      ( v131340(VarCurr)
    <=> ( v131341(VarCurr)
        & v131348(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2594,axiom,
    ! [VarCurr] :
      ( v131348(VarCurr)
    <=> ( v131343(VarCurr)
        | v15396(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26279,axiom,
    ! [VarCurr] :
      ( v131341(VarCurr)
    <=> ( v131342(VarCurr)
        | v131347(VarCurr) ) ) ).

fof(writeUnaryOperator_10827,axiom,
    ! [VarCurr] :
      ( ~ v131347(VarCurr)
    <=> v15396(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_10826,axiom,
    ! [VarCurr] :
      ( ~ v131342(VarCurr)
    <=> v131343(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2593,axiom,
    ! [VarCurr] :
      ( v131343(VarCurr)
    <=> ( v131344(VarCurr)
        & v15396(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2592,axiom,
    ! [VarCurr] :
      ( v131344(VarCurr)
    <=> ( v131345(VarCurr)
        & v15396(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2591,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr)
    <=> ( v131346(VarCurr)
        & v15396(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2590,axiom,
    ! [VarCurr] :
      ( v131346(VarCurr)
    <=> ( v15396(VarCurr,bitIndex0)
        & v15396(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26278,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131321(VarNext)
      <=> ( v131322(VarNext)
          & v131331(VarNext) ) ) ) ).

fof(addAssignment_41244,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131331(VarNext)
      <=> v131329(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26277,axiom,
    ! [VarCurr] :
      ( v131329(VarCurr)
    <=> ( v131332(VarCurr)
        | v131333(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26276,axiom,
    ! [VarCurr] :
      ( v131333(VarCurr)
    <=> ( v15400(VarCurr)
        & v131334(VarCurr) ) ) ).

fof(writeUnaryOperator_10825,axiom,
    ! [VarCurr] :
      ( ~ v131334(VarCurr)
    <=> v131332(VarCurr) ) ).

fof(writeUnaryOperator_10824,axiom,
    ! [VarCurr] :
      ( ~ v131332(VarCurr)
    <=> v15398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26275,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131322(VarNext)
      <=> ( v131323(VarNext)
          & v131318(VarNext) ) ) ) ).

fof(writeUnaryOperator_10823,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131323(VarNext)
      <=> v131325(VarNext) ) ) ).

fof(addAssignment_41243,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131325(VarNext)
      <=> v131318(VarCurr) ) ) ).

fof(addAssignmentInitValue_40,axiom,
    ~ v15396(constB0,bitIndex5) ).

fof(addAssignmentInitValue_39,axiom,
    ~ v15396(constB0,bitIndex4) ).

fof(addAssignmentInitValue_38,axiom,
    ~ v15396(constB0,bitIndex3) ).

fof(addAssignmentInitValue_37,axiom,
    ~ v15396(constB0,bitIndex2) ).

fof(addAssignmentInitValue_36,axiom,
    ~ v15396(constB0,bitIndex1) ).

fof(addAssignmentInitValue_35,axiom,
    v15396(constB0,bitIndex0) ).

fof(addAssignment_41242,axiom,
    ! [VarCurr] :
      ( v131318(VarCurr)
    <=> v199(VarCurr) ) ).

fof(addAssignment_41241,axiom,
    ! [VarCurr] :
      ( v15400(VarCurr)
    <=> v15402(VarCurr) ) ).

fof(addAssignment_41240,axiom,
    ! [VarCurr] :
      ( v15402(VarCurr)
    <=> v15404(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26274,axiom,
    ! [VarCurr] :
      ( v15404(VarCurr)
    <=> ( v131316(VarCurr)
        & v131313(VarCurr) ) ) ).

fof(writeUnaryOperator_10822,axiom,
    ! [VarCurr] :
      ( ~ v131316(VarCurr)
    <=> v15406(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9195,axiom,
    ! [VarCurr] :
      ( v131313(VarCurr)
    <=> ( ( v129436(VarCurr,bitIndex1)
        <=> $true )
        & ( v129436(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2314,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131296(VarNext)
       => ( v15406(VarNext)
        <=> v15406(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2415,axiom,
    ! [VarNext] :
      ( v131296(VarNext)
     => ( v15406(VarNext)
      <=> v131309(VarNext) ) ) ).

fof(addAssignment_41239,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131309(VarNext)
      <=> v131307(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5395,axiom,
    ! [VarCurr] :
      ( ~ v129426(VarCurr)
     => ( v131307(VarCurr)
      <=> v129789(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5383,axiom,
    ! [VarCurr] :
      ( v129426(VarCurr)
     => ( v131307(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26273,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131296(VarNext)
      <=> ( v131297(VarNext)
          & v131304(VarNext) ) ) ) ).

fof(addAssignment_41238,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131304(VarNext)
      <=> v131302(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26272,axiom,
    ! [VarCurr] :
      ( v131302(VarCurr)
    <=> ( v129426(VarCurr)
        | v131305(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26271,axiom,
    ! [VarCurr] :
      ( v131305(VarCurr)
    <=> ( v15410(VarCurr)
        & v131306(VarCurr) ) ) ).

fof(writeUnaryOperator_10821,axiom,
    ! [VarCurr] :
      ( ~ v131306(VarCurr)
    <=> v129426(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131297(VarNext)
      <=> ( v131299(VarNext)
          & v129412(VarNext) ) ) ) ).

fof(writeUnaryOperator_10820,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131299(VarNext)
      <=> v129419(VarNext) ) ) ).

fof(addAssignment_41237,axiom,
    ! [VarCurr] :
      ( v15410(VarCurr)
    <=> v15412(VarCurr) ) ).

fof(addAssignment_41236,axiom,
    ! [VarCurr] :
      ( v15412(VarCurr)
    <=> v15414(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26269,axiom,
    ! [VarCurr] :
      ( v15414(VarCurr)
    <=> ( v131289(VarCurr)
        | v131292(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2589,axiom,
    ! [VarCurr] :
      ( v131292(VarCurr)
    <=> ( v130(VarCurr,bitIndex2)
        & v131293(VarCurr) ) ) ).

fof(writeUnaryOperator_10819,axiom,
    ! [VarCurr] :
      ( ~ v131293(VarCurr)
    <=> v121(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26268,axiom,
    ! [VarCurr] :
      ( v131289(VarCurr)
    <=> ( v131290(VarCurr)
        & v131291(VarCurr) ) ) ).

fof(writeUnaryOperator_10818,axiom,
    ! [VarCurr] :
      ( ~ v131291(VarCurr)
    <=> v121(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_2588,axiom,
    ! [VarCurr] :
      ( v131290(VarCurr)
    <=> ( v15416(VarCurr)
        & v130(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_41235,axiom,
    ! [VarNext] :
      ( v121(VarNext,bitIndex2)
    <=> v131276(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_116,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131277(VarNext)
       => ( ( v131276(VarNext,bitIndex1)
          <=> v121(VarCurr,bitIndex2) )
          & ( v131276(VarNext,bitIndex0)
          <=> v121(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2414,axiom,
    ! [VarNext] :
      ( v131277(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v131276(VarNext,B)
          <=> v131285(VarNext,B) ) ) ) ).

fof(addAssignment_41234,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v131285(VarNext,B)
          <=> v131283(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_497,axiom,
    ! [VarCurr] :
      ( ~ v131260(VarCurr)
     => ( ( v131283(VarCurr,bitIndex1)
        <=> v130(VarCurr,bitIndex2) )
        & ( v131283(VarCurr,bitIndex0)
        <=> v130(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2963,axiom,
    ! [VarCurr] :
      ( v131260(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v131283(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26267,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131277(VarNext)
      <=> v131278(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26266,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131278(VarNext)
      <=> ( v131280(VarNext)
          & v131193(VarNext) ) ) ) ).

fof(writeUnaryOperator_10817,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131280(VarNext)
      <=> v131200(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_496,axiom,
    ! [VarCurr] :
      ( ~ v131264(VarCurr)
     => ( v130(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_693,axiom,
    ! [VarCurr] :
      ( v131264(VarCurr)
     => ( v130(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26265,axiom,
    ! [VarCurr] :
      ( v131264(VarCurr)
    <=> ( v131265(VarCurr)
        | v131271(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26264,axiom,
    ! [VarCurr] :
      ( v131271(VarCurr)
    <=> ( v131272(VarCurr)
        & v131273(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26263,axiom,
    ! [VarCurr] :
      ( v131273(VarCurr)
    <=> ( v15444(VarCurr)
        & v131274(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9194,axiom,
    ! [VarCurr] :
      ( v131274(VarCurr)
    <=> ( $true
      <=> v121(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10816,axiom,
    ! [VarCurr] :
      ( ~ v131272(VarCurr)
    <=> v131246(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26262,axiom,
    ! [VarCurr] :
      ( v131265(VarCurr)
    <=> ( v131266(VarCurr)
        & v131246(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26261,axiom,
    ! [VarCurr] :
      ( v131266(VarCurr)
    <=> ( v131268(VarCurr)
        & v131235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26260,axiom,
    ! [VarCurr] :
      ( v131268(VarCurr)
    <=> ( v131269(VarCurr)
        & v15416(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26259,axiom,
    ! [VarCurr] :
      ( v131269(VarCurr)
    <=> ( v131234(VarCurr)
        & v131270(VarCurr) ) ) ).

fof(writeUnaryOperator_10815,axiom,
    ! [VarCurr] :
      ( ~ v131270(VarCurr)
    <=> v129366(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2313,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131251(VarNext)
       => ( v121(VarNext,bitIndex0)
        <=> v121(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2413,axiom,
    ! [VarNext] :
      ( v131251(VarNext)
     => ( v121(VarNext,bitIndex0)
      <=> v131259(VarNext) ) ) ).

fof(addAssignment_41233,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131259(VarNext)
      <=> v131257(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3159,axiom,
    ! [VarCurr] :
      ( ~ v131260(VarCurr)
     => ( v131257(VarCurr)
      <=> v130(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2962,axiom,
    ! [VarCurr] :
      ( v131260(VarCurr)
     => ( v131257(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_10814,axiom,
    ! [VarCurr] :
      ( ~ v131260(VarCurr)
    <=> v123(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26258,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131251(VarNext)
      <=> v131252(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26257,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131252(VarNext)
      <=> ( v131253(VarNext)
          & v131193(VarNext) ) ) ) ).

fof(writeUnaryOperator_10813,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131253(VarNext)
      <=> v131200(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3158,axiom,
    ! [VarCurr] :
      ( ~ v131221(VarCurr)
     => ( v130(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2961,axiom,
    ! [VarCurr] :
      ( v131221(VarCurr)
     => ( v130(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26256,axiom,
    ! [VarCurr] :
      ( v131221(VarCurr)
    <=> ( v131222(VarCurr)
        & v131246(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26255,axiom,
    ! [VarCurr] :
      ( v131246(VarCurr)
    <=> ( v131247(VarCurr)
        | v131248(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9193,axiom,
    ! [VarCurr] :
      ( v131248(VarCurr)
    <=> ( $true
      <=> v121(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9192,axiom,
    ! [VarCurr] :
      ( v131247(VarCurr)
    <=> ( $true
      <=> v121(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26254,axiom,
    ! [VarCurr] :
      ( v131222(VarCurr)
    <=> ( v131223(VarCurr)
        | v131240(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26253,axiom,
    ! [VarCurr] :
      ( v131240(VarCurr)
    <=> ( v131242(VarCurr)
        & v131235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26252,axiom,
    ! [VarCurr] :
      ( v131242(VarCurr)
    <=> ( v131243(VarCurr)
        & v15416(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26251,axiom,
    ! [VarCurr] :
      ( v131243(VarCurr)
    <=> ( v131244(VarCurr)
        & v129366(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26250,axiom,
    ! [VarCurr] :
      ( v131244(VarCurr)
    <=> ( v131245(VarCurr)
        & v131229(VarCurr) ) ) ).

fof(writeUnaryOperator_10812,axiom,
    ! [VarCurr] :
      ( ~ v131245(VarCurr)
    <=> v15444(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26249,axiom,
    ! [VarCurr] :
      ( v131223(VarCurr)
    <=> ( v131224(VarCurr)
        | v131236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26248,axiom,
    ! [VarCurr] :
      ( v131236(VarCurr)
    <=> ( v131238(VarCurr)
        & v131235(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26247,axiom,
    ! [VarCurr] :
      ( v131238(VarCurr)
    <=> ( v131234(VarCurr)
        & v131239(VarCurr) ) ) ).

fof(writeUnaryOperator_10811,axiom,
    ! [VarCurr] :
      ( ~ v131239(VarCurr)
    <=> v15416(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26246,axiom,
    ! [VarCurr] :
      ( v131224(VarCurr)
    <=> ( v131225(VarCurr)
        | v131230(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26245,axiom,
    ! [VarCurr] :
      ( v131230(VarCurr)
    <=> ( v131232(VarCurr)
        & v131235(VarCurr) ) 