%------------------------------------------------------------------------------
% File     : HWV088+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 3 cone of influence 10_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop3_cone10_b20 [Kha14]

% Status   : Theorem
% Rating   : 1.00 v6.1.0
% Syntax   : Number of formulae    : 134594 (13459 unt;   0 def)
%            Number of atoms       : 467264 (5092 equ)
%            Maximal formula atoms :  264 (   3 avg)
%            Number of connectives : 378008 (45338   ~;16535   |;84309   &)
%                                         (184174 <=>;47637  =>;   0  <=;  15 <~>)
%            Maximal formula depth :  258 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 86891 (86888 usr;   2 prp; 0-3 aty)
%            Number of functors    : 2317 (2317 usr;2317 con; 0-0 aty)
%            Number of variables   : 142402 (142402   !;   0   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(address_false_msb_41,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_167,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v104045(constB20,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v104045(constB20,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v104045(constB20,bitIndex2) ) ) ).

fof(is_address_183,axiom,
    address(v104045_range_2_to_0_address_term_bound_20) ).

fof(address_association_167,axiom,
    v104045_range_2_to_0_address_association(constB20,v104045_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_40,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_166,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v104045(constB19,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v104045(constB19,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v104045(constB19,bitIndex2) ) ) ).

fof(is_address_182,axiom,
    address(v104045_range_2_to_0_address_term_bound_19) ).

fof(address_association_166,axiom,
    v104045_range_2_to_0_address_association(constB19,v104045_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_39,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_165,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v104045(constB18,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v104045(constB18,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v104045(constB18,bitIndex2) ) ) ).

fof(is_address_181,axiom,
    address(v104045_range_2_to_0_address_term_bound_18) ).

fof(address_association_165,axiom,
    v104045_range_2_to_0_address_association(constB18,v104045_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_38,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_164,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v104045(constB17,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v104045(constB17,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v104045(constB17,bitIndex2) ) ) ).

fof(is_address_180,axiom,
    address(v104045_range_2_to_0_address_term_bound_17) ).

fof(address_association_164,axiom,
    v104045_range_2_to_0_address_association(constB17,v104045_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_37,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_163,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v104045(constB16,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v104045(constB16,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v104045(constB16,bitIndex2) ) ) ).

fof(is_address_179,axiom,
    address(v104045_range_2_to_0_address_term_bound_16) ).

fof(address_association_163,axiom,
    v104045_range_2_to_0_address_association(constB16,v104045_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_36,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_162,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v104045(constB15,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v104045(constB15,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v104045(constB15,bitIndex2) ) ) ).

fof(is_address_178,axiom,
    address(v104045_range_2_to_0_address_term_bound_15) ).

fof(address_association_162,axiom,
    v104045_range_2_to_0_address_association(constB15,v104045_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_35,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_161,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v104045(constB14,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v104045(constB14,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v104045(constB14,bitIndex2) ) ) ).

fof(is_address_177,axiom,
    address(v104045_range_2_to_0_address_term_bound_14) ).

fof(address_association_161,axiom,
    v104045_range_2_to_0_address_association(constB14,v104045_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_34,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_160,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v104045(constB13,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v104045(constB13,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v104045(constB13,bitIndex2) ) ) ).

fof(is_address_176,axiom,
    address(v104045_range_2_to_0_address_term_bound_13) ).

fof(address_association_160,axiom,
    v104045_range_2_to_0_address_association(constB13,v104045_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_33,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_159,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v104045(constB12,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v104045(constB12,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v104045(constB12,bitIndex2) ) ) ).

fof(is_address_175,axiom,
    address(v104045_range_2_to_0_address_term_bound_12) ).

fof(address_association_159,axiom,
    v104045_range_2_to_0_address_association(constB12,v104045_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_32,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_158,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v104045(constB11,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v104045(constB11,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v104045(constB11,bitIndex2) ) ) ).

fof(is_address_174,axiom,
    address(v104045_range_2_to_0_address_term_bound_11) ).

fof(address_association_158,axiom,
    v104045_range_2_to_0_address_association(constB11,v104045_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_31,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_157,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v104045(constB10,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v104045(constB10,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v104045(constB10,bitIndex2) ) ) ).

fof(is_address_173,axiom,
    address(v104045_range_2_to_0_address_term_bound_10) ).

fof(address_association_157,axiom,
    v104045_range_2_to_0_address_association(constB10,v104045_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_30,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_156,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v104045(constB9,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v104045(constB9,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v104045(constB9,bitIndex2) ) ) ).

fof(is_address_172,axiom,
    address(v104045_range_2_to_0_address_term_bound_9) ).

fof(address_association_156,axiom,
    v104045_range_2_to_0_address_association(constB9,v104045_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_29,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_155,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v104045(constB8,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v104045(constB8,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v104045(constB8,bitIndex2) ) ) ).

fof(is_address_171,axiom,
    address(v104045_range_2_to_0_address_term_bound_8) ).

fof(address_association_155,axiom,
    v104045_range_2_to_0_address_association(constB8,v104045_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_28,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_154,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v104045(constB7,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v104045(constB7,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v104045(constB7,bitIndex2) ) ) ).

fof(is_address_170,axiom,
    address(v104045_range_2_to_0_address_term_bound_7) ).

fof(address_association_154,axiom,
    v104045_range_2_to_0_address_association(constB7,v104045_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_27,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_153,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v104045(constB6,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v104045(constB6,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v104045(constB6,bitIndex2) ) ) ).

fof(is_address_169,axiom,
    address(v104045_range_2_to_0_address_term_bound_6) ).

fof(address_association_153,axiom,
    v104045_range_2_to_0_address_association(constB6,v104045_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_26,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_152,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v104045(constB5,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v104045(constB5,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v104045(constB5,bitIndex2) ) ) ).

fof(is_address_168,axiom,
    address(v104045_range_2_to_0_address_term_bound_5) ).

fof(address_association_152,axiom,
    v104045_range_2_to_0_address_association(constB5,v104045_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_25,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_151,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v104045(constB4,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v104045(constB4,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v104045(constB4,bitIndex2) ) ) ).

fof(is_address_167,axiom,
    address(v104045_range_2_to_0_address_term_bound_4) ).

fof(address_association_151,axiom,
    v104045_range_2_to_0_address_association(constB4,v104045_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_24,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_150,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v104045(constB3,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v104045(constB3,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v104045(constB3,bitIndex2) ) ) ).

fof(is_address_166,axiom,
    address(v104045_range_2_to_0_address_term_bound_3) ).

fof(address_association_150,axiom,
    v104045_range_2_to_0_address_association(constB3,v104045_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_23,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_149,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v104045(constB2,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v104045(constB2,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v104045(constB2,bitIndex2) ) ) ).

fof(is_address_165,axiom,
    address(v104045_range_2_to_0_address_term_bound_2) ).

fof(address_association_149,axiom,
    v104045_range_2_to_0_address_association(constB2,v104045_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_22,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_148,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v104045(constB1,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v104045(constB1,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v104045(constB1,bitIndex2) ) ) ).

fof(is_address_164,axiom,
    address(v104045_range_2_to_0_address_term_bound_1) ).

fof(address_association_148,axiom,
    v104045_range_2_to_0_address_association(constB1,v104045_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb_21,axiom,
    ~ addressVal(v104045_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_147,axiom,
    ( $true
    & ( addressVal(v104045_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v104045(constB0,bitIndex0) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v104045(constB0,bitIndex1) )
    & ( addressVal(v104045_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v104045(constB0,bitIndex2) ) ) ).

fof(is_address_163,axiom,
    address(v104045_range_2_to_0_address_term_bound_0) ).

fof(address_association_147,axiom,
    v104045_range_2_to_0_address_association(constB0,v104045_range_2_to_0_address_term_bound_0) ).

fof(address_false_msb_20,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_20,bitIndex3) ).

fof(transient_address_definition_146,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_20,bitIndex0)
    <=> v103985(constB20,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_20,bitIndex1)
    <=> v103985(constB20,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_20,bitIndex2)
    <=> v103985(constB20,bitIndex2) ) ) ).

fof(is_address_162,axiom,
    address(v103985_range_2_to_0_address_term_bound_20) ).

fof(address_association_146,axiom,
    v103985_range_2_to_0_address_association(constB20,v103985_range_2_to_0_address_term_bound_20) ).

fof(address_false_msb_19,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_19,bitIndex3) ).

fof(transient_address_definition_145,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_19,bitIndex0)
    <=> v103985(constB19,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_19,bitIndex1)
    <=> v103985(constB19,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_19,bitIndex2)
    <=> v103985(constB19,bitIndex2) ) ) ).

fof(is_address_161,axiom,
    address(v103985_range_2_to_0_address_term_bound_19) ).

fof(address_association_145,axiom,
    v103985_range_2_to_0_address_association(constB19,v103985_range_2_to_0_address_term_bound_19) ).

fof(address_false_msb_18,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_18,bitIndex3) ).

fof(transient_address_definition_144,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_18,bitIndex0)
    <=> v103985(constB18,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_18,bitIndex1)
    <=> v103985(constB18,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_18,bitIndex2)
    <=> v103985(constB18,bitIndex2) ) ) ).

fof(is_address_160,axiom,
    address(v103985_range_2_to_0_address_term_bound_18) ).

fof(address_association_144,axiom,
    v103985_range_2_to_0_address_association(constB18,v103985_range_2_to_0_address_term_bound_18) ).

fof(address_false_msb_17,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_17,bitIndex3) ).

fof(transient_address_definition_143,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_17,bitIndex0)
    <=> v103985(constB17,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_17,bitIndex1)
    <=> v103985(constB17,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_17,bitIndex2)
    <=> v103985(constB17,bitIndex2) ) ) ).

fof(is_address_159,axiom,
    address(v103985_range_2_to_0_address_term_bound_17) ).

fof(address_association_143,axiom,
    v103985_range_2_to_0_address_association(constB17,v103985_range_2_to_0_address_term_bound_17) ).

fof(address_false_msb_16,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_16,bitIndex3) ).

fof(transient_address_definition_142,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_16,bitIndex0)
    <=> v103985(constB16,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_16,bitIndex1)
    <=> v103985(constB16,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_16,bitIndex2)
    <=> v103985(constB16,bitIndex2) ) ) ).

fof(is_address_158,axiom,
    address(v103985_range_2_to_0_address_term_bound_16) ).

fof(address_association_142,axiom,
    v103985_range_2_to_0_address_association(constB16,v103985_range_2_to_0_address_term_bound_16) ).

fof(address_false_msb_15,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_15,bitIndex3) ).

fof(transient_address_definition_141,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_15,bitIndex0)
    <=> v103985(constB15,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_15,bitIndex1)
    <=> v103985(constB15,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_15,bitIndex2)
    <=> v103985(constB15,bitIndex2) ) ) ).

fof(is_address_157,axiom,
    address(v103985_range_2_to_0_address_term_bound_15) ).

fof(address_association_141,axiom,
    v103985_range_2_to_0_address_association(constB15,v103985_range_2_to_0_address_term_bound_15) ).

fof(address_false_msb_14,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_14,bitIndex3) ).

fof(transient_address_definition_140,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_14,bitIndex0)
    <=> v103985(constB14,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_14,bitIndex1)
    <=> v103985(constB14,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_14,bitIndex2)
    <=> v103985(constB14,bitIndex2) ) ) ).

fof(is_address_156,axiom,
    address(v103985_range_2_to_0_address_term_bound_14) ).

fof(address_association_140,axiom,
    v103985_range_2_to_0_address_association(constB14,v103985_range_2_to_0_address_term_bound_14) ).

fof(address_false_msb_13,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_13,bitIndex3) ).

fof(transient_address_definition_139,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_13,bitIndex0)
    <=> v103985(constB13,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_13,bitIndex1)
    <=> v103985(constB13,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_13,bitIndex2)
    <=> v103985(constB13,bitIndex2) ) ) ).

fof(is_address_155,axiom,
    address(v103985_range_2_to_0_address_term_bound_13) ).

fof(address_association_139,axiom,
    v103985_range_2_to_0_address_association(constB13,v103985_range_2_to_0_address_term_bound_13) ).

fof(address_false_msb_12,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_12,bitIndex3) ).

fof(transient_address_definition_138,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_12,bitIndex0)
    <=> v103985(constB12,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_12,bitIndex1)
    <=> v103985(constB12,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_12,bitIndex2)
    <=> v103985(constB12,bitIndex2) ) ) ).

fof(is_address_154,axiom,
    address(v103985_range_2_to_0_address_term_bound_12) ).

fof(address_association_138,axiom,
    v103985_range_2_to_0_address_association(constB12,v103985_range_2_to_0_address_term_bound_12) ).

fof(address_false_msb_11,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_11,bitIndex3) ).

fof(transient_address_definition_137,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_11,bitIndex0)
    <=> v103985(constB11,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_11,bitIndex1)
    <=> v103985(constB11,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_11,bitIndex2)
    <=> v103985(constB11,bitIndex2) ) ) ).

fof(is_address_153,axiom,
    address(v103985_range_2_to_0_address_term_bound_11) ).

fof(address_association_137,axiom,
    v103985_range_2_to_0_address_association(constB11,v103985_range_2_to_0_address_term_bound_11) ).

fof(address_false_msb_10,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_10,bitIndex3) ).

fof(transient_address_definition_136,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_10,bitIndex0)
    <=> v103985(constB10,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_10,bitIndex1)
    <=> v103985(constB10,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_10,bitIndex2)
    <=> v103985(constB10,bitIndex2) ) ) ).

fof(is_address_152,axiom,
    address(v103985_range_2_to_0_address_term_bound_10) ).

fof(address_association_136,axiom,
    v103985_range_2_to_0_address_association(constB10,v103985_range_2_to_0_address_term_bound_10) ).

fof(address_false_msb_9,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_9,bitIndex3) ).

fof(transient_address_definition_135,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_9,bitIndex0)
    <=> v103985(constB9,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_9,bitIndex1)
    <=> v103985(constB9,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_9,bitIndex2)
    <=> v103985(constB9,bitIndex2) ) ) ).

fof(is_address_151,axiom,
    address(v103985_range_2_to_0_address_term_bound_9) ).

fof(address_association_135,axiom,
    v103985_range_2_to_0_address_association(constB9,v103985_range_2_to_0_address_term_bound_9) ).

fof(address_false_msb_8,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_8,bitIndex3) ).

fof(transient_address_definition_134,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_8,bitIndex0)
    <=> v103985(constB8,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_8,bitIndex1)
    <=> v103985(constB8,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_8,bitIndex2)
    <=> v103985(constB8,bitIndex2) ) ) ).

fof(is_address_150,axiom,
    address(v103985_range_2_to_0_address_term_bound_8) ).

fof(address_association_134,axiom,
    v103985_range_2_to_0_address_association(constB8,v103985_range_2_to_0_address_term_bound_8) ).

fof(address_false_msb_7,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_7,bitIndex3) ).

fof(transient_address_definition_133,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_7,bitIndex0)
    <=> v103985(constB7,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_7,bitIndex1)
    <=> v103985(constB7,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_7,bitIndex2)
    <=> v103985(constB7,bitIndex2) ) ) ).

fof(is_address_149,axiom,
    address(v103985_range_2_to_0_address_term_bound_7) ).

fof(address_association_133,axiom,
    v103985_range_2_to_0_address_association(constB7,v103985_range_2_to_0_address_term_bound_7) ).

fof(address_false_msb_6,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_6,bitIndex3) ).

fof(transient_address_definition_132,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_6,bitIndex0)
    <=> v103985(constB6,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_6,bitIndex1)
    <=> v103985(constB6,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_6,bitIndex2)
    <=> v103985(constB6,bitIndex2) ) ) ).

fof(is_address_148,axiom,
    address(v103985_range_2_to_0_address_term_bound_6) ).

fof(address_association_132,axiom,
    v103985_range_2_to_0_address_association(constB6,v103985_range_2_to_0_address_term_bound_6) ).

fof(address_false_msb_5,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_5,bitIndex3) ).

fof(transient_address_definition_131,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_5,bitIndex0)
    <=> v103985(constB5,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_5,bitIndex1)
    <=> v103985(constB5,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_5,bitIndex2)
    <=> v103985(constB5,bitIndex2) ) ) ).

fof(is_address_147,axiom,
    address(v103985_range_2_to_0_address_term_bound_5) ).

fof(address_association_131,axiom,
    v103985_range_2_to_0_address_association(constB5,v103985_range_2_to_0_address_term_bound_5) ).

fof(address_false_msb_4,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_4,bitIndex3) ).

fof(transient_address_definition_130,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_4,bitIndex0)
    <=> v103985(constB4,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_4,bitIndex1)
    <=> v103985(constB4,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_4,bitIndex2)
    <=> v103985(constB4,bitIndex2) ) ) ).

fof(is_address_146,axiom,
    address(v103985_range_2_to_0_address_term_bound_4) ).

fof(address_association_130,axiom,
    v103985_range_2_to_0_address_association(constB4,v103985_range_2_to_0_address_term_bound_4) ).

fof(address_false_msb_3,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_3,bitIndex3) ).

fof(transient_address_definition_129,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_3,bitIndex0)
    <=> v103985(constB3,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_3,bitIndex1)
    <=> v103985(constB3,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_3,bitIndex2)
    <=> v103985(constB3,bitIndex2) ) ) ).

fof(is_address_145,axiom,
    address(v103985_range_2_to_0_address_term_bound_3) ).

fof(address_association_129,axiom,
    v103985_range_2_to_0_address_association(constB3,v103985_range_2_to_0_address_term_bound_3) ).

fof(address_false_msb_2,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_2,bitIndex3) ).

fof(transient_address_definition_128,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_2,bitIndex0)
    <=> v103985(constB2,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_2,bitIndex1)
    <=> v103985(constB2,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_2,bitIndex2)
    <=> v103985(constB2,bitIndex2) ) ) ).

fof(is_address_144,axiom,
    address(v103985_range_2_to_0_address_term_bound_2) ).

fof(address_association_128,axiom,
    v103985_range_2_to_0_address_association(constB2,v103985_range_2_to_0_address_term_bound_2) ).

fof(address_false_msb_1,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_1,bitIndex3) ).

fof(transient_address_definition_127,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_1,bitIndex0)
    <=> v103985(constB1,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_1,bitIndex1)
    <=> v103985(constB1,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_1,bitIndex2)
    <=> v103985(constB1,bitIndex2) ) ) ).

fof(is_address_143,axiom,
    address(v103985_range_2_to_0_address_term_bound_1) ).

fof(address_association_127,axiom,
    v103985_range_2_to_0_address_association(constB1,v103985_range_2_to_0_address_term_bound_1) ).

fof(address_false_msb,axiom,
    ~ addressVal(v103985_range_2_to_0_address_term_bound_0,bitIndex3) ).

fof(transient_address_definition_126,axiom,
    ( $true
    & ( addressVal(v103985_range_2_to_0_address_term_bound_0,bitIndex0)
    <=> v103985(constB0,bitIndex0) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_0,bitIndex1)
    <=> v103985(constB0,bitIndex1) )
    & ( addressVal(v103985_range_2_to_0_address_term_bound_0,bitIndex2)
    <=> v103985(constB0,bitIndex2) ) ) ).

fof(is_address_142,axiom,
    address(v103985_range_2_to_0_address_term_bound_0) ).

fof(address_association_126,axiom,
    v103985_range_2_to_0_address_association(constB0,v103985_range_2_to_0_address_term_bound_0) ).

fof(transient_address_definition_125,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_20,B)
    <=> v15242(constB20,B) ) ).

fof(is_address_141,axiom,
    address(v15242_range_3_to_0_address_term_bound_20) ).

fof(address_association_125,axiom,
    v15242_range_3_to_0_address_association(constB20,v15242_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_124,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_19,B)
    <=> v15242(constB19,B) ) ).

fof(is_address_140,axiom,
    address(v15242_range_3_to_0_address_term_bound_19) ).

fof(address_association_124,axiom,
    v15242_range_3_to_0_address_association(constB19,v15242_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_123,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_18,B)
    <=> v15242(constB18,B) ) ).

fof(is_address_139,axiom,
    address(v15242_range_3_to_0_address_term_bound_18) ).

fof(address_association_123,axiom,
    v15242_range_3_to_0_address_association(constB18,v15242_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_122,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_17,B)
    <=> v15242(constB17,B) ) ).

fof(is_address_138,axiom,
    address(v15242_range_3_to_0_address_term_bound_17) ).

fof(address_association_122,axiom,
    v15242_range_3_to_0_address_association(constB17,v15242_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_121,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_16,B)
    <=> v15242(constB16,B) ) ).

fof(is_address_137,axiom,
    address(v15242_range_3_to_0_address_term_bound_16) ).

fof(address_association_121,axiom,
    v15242_range_3_to_0_address_association(constB16,v15242_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_120,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_15,B)
    <=> v15242(constB15,B) ) ).

fof(is_address_136,axiom,
    address(v15242_range_3_to_0_address_term_bound_15) ).

fof(address_association_120,axiom,
    v15242_range_3_to_0_address_association(constB15,v15242_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_119,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_14,B)
    <=> v15242(constB14,B) ) ).

fof(is_address_135,axiom,
    address(v15242_range_3_to_0_address_term_bound_14) ).

fof(address_association_119,axiom,
    v15242_range_3_to_0_address_association(constB14,v15242_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_118,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_13,B)
    <=> v15242(constB13,B) ) ).

fof(is_address_134,axiom,
    address(v15242_range_3_to_0_address_term_bound_13) ).

fof(address_association_118,axiom,
    v15242_range_3_to_0_address_association(constB13,v15242_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_117,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_12,B)
    <=> v15242(constB12,B) ) ).

fof(is_address_133,axiom,
    address(v15242_range_3_to_0_address_term_bound_12) ).

fof(address_association_117,axiom,
    v15242_range_3_to_0_address_association(constB12,v15242_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_116,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_11,B)
    <=> v15242(constB11,B) ) ).

fof(is_address_132,axiom,
    address(v15242_range_3_to_0_address_term_bound_11) ).

fof(address_association_116,axiom,
    v15242_range_3_to_0_address_association(constB11,v15242_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_115,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_10,B)
    <=> v15242(constB10,B) ) ).

fof(is_address_131,axiom,
    address(v15242_range_3_to_0_address_term_bound_10) ).

fof(address_association_115,axiom,
    v15242_range_3_to_0_address_association(constB10,v15242_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_114,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_9,B)
    <=> v15242(constB9,B) ) ).

fof(is_address_130,axiom,
    address(v15242_range_3_to_0_address_term_bound_9) ).

fof(address_association_114,axiom,
    v15242_range_3_to_0_address_association(constB9,v15242_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_113,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_8,B)
    <=> v15242(constB8,B) ) ).

fof(is_address_129,axiom,
    address(v15242_range_3_to_0_address_term_bound_8) ).

fof(address_association_113,axiom,
    v15242_range_3_to_0_address_association(constB8,v15242_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_112,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_7,B)
    <=> v15242(constB7,B) ) ).

fof(is_address_128,axiom,
    address(v15242_range_3_to_0_address_term_bound_7) ).

fof(address_association_112,axiom,
    v15242_range_3_to_0_address_association(constB7,v15242_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_111,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_6,B)
    <=> v15242(constB6,B) ) ).

fof(is_address_127,axiom,
    address(v15242_range_3_to_0_address_term_bound_6) ).

fof(address_association_111,axiom,
    v15242_range_3_to_0_address_association(constB6,v15242_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_110,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_5,B)
    <=> v15242(constB5,B) ) ).

fof(is_address_126,axiom,
    address(v15242_range_3_to_0_address_term_bound_5) ).

fof(address_association_110,axiom,
    v15242_range_3_to_0_address_association(constB5,v15242_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_109,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_4,B)
    <=> v15242(constB4,B) ) ).

fof(is_address_125,axiom,
    address(v15242_range_3_to_0_address_term_bound_4) ).

fof(address_association_109,axiom,
    v15242_range_3_to_0_address_association(constB4,v15242_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_108,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_3,B)
    <=> v15242(constB3,B) ) ).

fof(is_address_124,axiom,
    address(v15242_range_3_to_0_address_term_bound_3) ).

fof(address_association_108,axiom,
    v15242_range_3_to_0_address_association(constB3,v15242_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_107,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_2,B)
    <=> v15242(constB2,B) ) ).

fof(is_address_123,axiom,
    address(v15242_range_3_to_0_address_term_bound_2) ).

fof(address_association_107,axiom,
    v15242_range_3_to_0_address_association(constB2,v15242_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_106,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_1,B)
    <=> v15242(constB1,B) ) ).

fof(is_address_122,axiom,
    address(v15242_range_3_to_0_address_term_bound_1) ).

fof(address_association_106,axiom,
    v15242_range_3_to_0_address_association(constB1,v15242_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_105,axiom,
    ! [B] :
      ( addressVal(v15242_range_3_to_0_address_term_bound_0,B)
    <=> v15242(constB0,B) ) ).

fof(is_address_121,axiom,
    address(v15242_range_3_to_0_address_term_bound_0) ).

fof(address_association_105,axiom,
    v15242_range_3_to_0_address_association(constB0,v15242_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_104,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_20,B)
    <=> v15176(constB20,B) ) ).

fof(is_address_120,axiom,
    address(v15176_range_3_to_0_address_term_bound_20) ).

fof(address_association_104,axiom,
    v15176_range_3_to_0_address_association(constB20,v15176_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_103,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_19,B)
    <=> v15176(constB19,B) ) ).

fof(is_address_119,axiom,
    address(v15176_range_3_to_0_address_term_bound_19) ).

fof(address_association_103,axiom,
    v15176_range_3_to_0_address_association(constB19,v15176_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_102,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_18,B)
    <=> v15176(constB18,B) ) ).

fof(is_address_118,axiom,
    address(v15176_range_3_to_0_address_term_bound_18) ).

fof(address_association_102,axiom,
    v15176_range_3_to_0_address_association(constB18,v15176_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_101,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_17,B)
    <=> v15176(constB17,B) ) ).

fof(is_address_117,axiom,
    address(v15176_range_3_to_0_address_term_bound_17) ).

fof(address_association_101,axiom,
    v15176_range_3_to_0_address_association(constB17,v15176_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_100,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_16,B)
    <=> v15176(constB16,B) ) ).

fof(is_address_116,axiom,
    address(v15176_range_3_to_0_address_term_bound_16) ).

fof(address_association_100,axiom,
    v15176_range_3_to_0_address_association(constB16,v15176_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_99,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_15,B)
    <=> v15176(constB15,B) ) ).

fof(is_address_115,axiom,
    address(v15176_range_3_to_0_address_term_bound_15) ).

fof(address_association_99,axiom,
    v15176_range_3_to_0_address_association(constB15,v15176_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_98,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_14,B)
    <=> v15176(constB14,B) ) ).

fof(is_address_114,axiom,
    address(v15176_range_3_to_0_address_term_bound_14) ).

fof(address_association_98,axiom,
    v15176_range_3_to_0_address_association(constB14,v15176_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_97,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_13,B)
    <=> v15176(constB13,B) ) ).

fof(is_address_113,axiom,
    address(v15176_range_3_to_0_address_term_bound_13) ).

fof(address_association_97,axiom,
    v15176_range_3_to_0_address_association(constB13,v15176_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_96,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_12,B)
    <=> v15176(constB12,B) ) ).

fof(is_address_112,axiom,
    address(v15176_range_3_to_0_address_term_bound_12) ).

fof(address_association_96,axiom,
    v15176_range_3_to_0_address_association(constB12,v15176_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_95,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_11,B)
    <=> v15176(constB11,B) ) ).

fof(is_address_111,axiom,
    address(v15176_range_3_to_0_address_term_bound_11) ).

fof(address_association_95,axiom,
    v15176_range_3_to_0_address_association(constB11,v15176_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_94,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_10,B)
    <=> v15176(constB10,B) ) ).

fof(is_address_110,axiom,
    address(v15176_range_3_to_0_address_term_bound_10) ).

fof(address_association_94,axiom,
    v15176_range_3_to_0_address_association(constB10,v15176_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_93,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_9,B)
    <=> v15176(constB9,B) ) ).

fof(is_address_109,axiom,
    address(v15176_range_3_to_0_address_term_bound_9) ).

fof(address_association_93,axiom,
    v15176_range_3_to_0_address_association(constB9,v15176_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_92,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_8,B)
    <=> v15176(constB8,B) ) ).

fof(is_address_108,axiom,
    address(v15176_range_3_to_0_address_term_bound_8) ).

fof(address_association_92,axiom,
    v15176_range_3_to_0_address_association(constB8,v15176_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_91,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_7,B)
    <=> v15176(constB7,B) ) ).

fof(is_address_107,axiom,
    address(v15176_range_3_to_0_address_term_bound_7) ).

fof(address_association_91,axiom,
    v15176_range_3_to_0_address_association(constB7,v15176_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_90,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_6,B)
    <=> v15176(constB6,B) ) ).

fof(is_address_106,axiom,
    address(v15176_range_3_to_0_address_term_bound_6) ).

fof(address_association_90,axiom,
    v15176_range_3_to_0_address_association(constB6,v15176_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_89,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_5,B)
    <=> v15176(constB5,B) ) ).

fof(is_address_105,axiom,
    address(v15176_range_3_to_0_address_term_bound_5) ).

fof(address_association_89,axiom,
    v15176_range_3_to_0_address_association(constB5,v15176_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_88,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_4,B)
    <=> v15176(constB4,B) ) ).

fof(is_address_104,axiom,
    address(v15176_range_3_to_0_address_term_bound_4) ).

fof(address_association_88,axiom,
    v15176_range_3_to_0_address_association(constB4,v15176_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_87,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_3,B)
    <=> v15176(constB3,B) ) ).

fof(is_address_103,axiom,
    address(v15176_range_3_to_0_address_term_bound_3) ).

fof(address_association_87,axiom,
    v15176_range_3_to_0_address_association(constB3,v15176_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_86,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_2,B)
    <=> v15176(constB2,B) ) ).

fof(is_address_102,axiom,
    address(v15176_range_3_to_0_address_term_bound_2) ).

fof(address_association_86,axiom,
    v15176_range_3_to_0_address_association(constB2,v15176_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_85,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_1,B)
    <=> v15176(constB1,B) ) ).

fof(is_address_101,axiom,
    address(v15176_range_3_to_0_address_term_bound_1) ).

fof(address_association_85,axiom,
    v15176_range_3_to_0_address_association(constB1,v15176_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_84,axiom,
    ! [B] :
      ( addressVal(v15176_range_3_to_0_address_term_bound_0,B)
    <=> v15176(constB0,B) ) ).

fof(is_address_100,axiom,
    address(v15176_range_3_to_0_address_term_bound_0) ).

fof(address_association_84,axiom,
    v15176_range_3_to_0_address_association(constB0,v15176_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_83,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_20,B)
    <=> v11997(constB20,B) ) ).

fof(is_address_99,axiom,
    address(v11997_range_3_to_0_address_term_bound_20) ).

fof(address_association_83,axiom,
    v11997_range_3_to_0_address_association(constB20,v11997_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_82,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_19,B)
    <=> v11997(constB19,B) ) ).

fof(is_address_98,axiom,
    address(v11997_range_3_to_0_address_term_bound_19) ).

fof(address_association_82,axiom,
    v11997_range_3_to_0_address_association(constB19,v11997_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_81,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_18,B)
    <=> v11997(constB18,B) ) ).

fof(is_address_97,axiom,
    address(v11997_range_3_to_0_address_term_bound_18) ).

fof(address_association_81,axiom,
    v11997_range_3_to_0_address_association(constB18,v11997_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_80,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_17,B)
    <=> v11997(constB17,B) ) ).

fof(is_address_96,axiom,
    address(v11997_range_3_to_0_address_term_bound_17) ).

fof(address_association_80,axiom,
    v11997_range_3_to_0_address_association(constB17,v11997_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_79,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_16,B)
    <=> v11997(constB16,B) ) ).

fof(is_address_95,axiom,
    address(v11997_range_3_to_0_address_term_bound_16) ).

fof(address_association_79,axiom,
    v11997_range_3_to_0_address_association(constB16,v11997_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_78,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_15,B)
    <=> v11997(constB15,B) ) ).

fof(is_address_94,axiom,
    address(v11997_range_3_to_0_address_term_bound_15) ).

fof(address_association_78,axiom,
    v11997_range_3_to_0_address_association(constB15,v11997_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_77,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_14,B)
    <=> v11997(constB14,B) ) ).

fof(is_address_93,axiom,
    address(v11997_range_3_to_0_address_term_bound_14) ).

fof(address_association_77,axiom,
    v11997_range_3_to_0_address_association(constB14,v11997_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_76,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_13,B)
    <=> v11997(constB13,B) ) ).

fof(is_address_92,axiom,
    address(v11997_range_3_to_0_address_term_bound_13) ).

fof(address_association_76,axiom,
    v11997_range_3_to_0_address_association(constB13,v11997_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_75,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_12,B)
    <=> v11997(constB12,B) ) ).

fof(is_address_91,axiom,
    address(v11997_range_3_to_0_address_term_bound_12) ).

fof(address_association_75,axiom,
    v11997_range_3_to_0_address_association(constB12,v11997_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_74,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_11,B)
    <=> v11997(constB11,B) ) ).

fof(is_address_90,axiom,
    address(v11997_range_3_to_0_address_term_bound_11) ).

fof(address_association_74,axiom,
    v11997_range_3_to_0_address_association(constB11,v11997_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_73,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_10,B)
    <=> v11997(constB10,B) ) ).

fof(is_address_89,axiom,
    address(v11997_range_3_to_0_address_term_bound_10) ).

fof(address_association_73,axiom,
    v11997_range_3_to_0_address_association(constB10,v11997_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_72,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_9,B)
    <=> v11997(constB9,B) ) ).

fof(is_address_88,axiom,
    address(v11997_range_3_to_0_address_term_bound_9) ).

fof(address_association_72,axiom,
    v11997_range_3_to_0_address_association(constB9,v11997_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_71,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_8,B)
    <=> v11997(constB8,B) ) ).

fof(is_address_87,axiom,
    address(v11997_range_3_to_0_address_term_bound_8) ).

fof(address_association_71,axiom,
    v11997_range_3_to_0_address_association(constB8,v11997_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_70,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_7,B)
    <=> v11997(constB7,B) ) ).

fof(is_address_86,axiom,
    address(v11997_range_3_to_0_address_term_bound_7) ).

fof(address_association_70,axiom,
    v11997_range_3_to_0_address_association(constB7,v11997_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_69,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_6,B)
    <=> v11997(constB6,B) ) ).

fof(is_address_85,axiom,
    address(v11997_range_3_to_0_address_term_bound_6) ).

fof(address_association_69,axiom,
    v11997_range_3_to_0_address_association(constB6,v11997_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_68,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_5,B)
    <=> v11997(constB5,B) ) ).

fof(is_address_84,axiom,
    address(v11997_range_3_to_0_address_term_bound_5) ).

fof(address_association_68,axiom,
    v11997_range_3_to_0_address_association(constB5,v11997_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_67,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_4,B)
    <=> v11997(constB4,B) ) ).

fof(is_address_83,axiom,
    address(v11997_range_3_to_0_address_term_bound_4) ).

fof(address_association_67,axiom,
    v11997_range_3_to_0_address_association(constB4,v11997_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_66,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_3,B)
    <=> v11997(constB3,B) ) ).

fof(is_address_82,axiom,
    address(v11997_range_3_to_0_address_term_bound_3) ).

fof(address_association_66,axiom,
    v11997_range_3_to_0_address_association(constB3,v11997_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_65,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_2,B)
    <=> v11997(constB2,B) ) ).

fof(is_address_81,axiom,
    address(v11997_range_3_to_0_address_term_bound_2) ).

fof(address_association_65,axiom,
    v11997_range_3_to_0_address_association(constB2,v11997_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_64,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_1,B)
    <=> v11997(constB1,B) ) ).

fof(is_address_80,axiom,
    address(v11997_range_3_to_0_address_term_bound_1) ).

fof(address_association_64,axiom,
    v11997_range_3_to_0_address_association(constB1,v11997_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_63,axiom,
    ! [B] :
      ( addressVal(v11997_range_3_to_0_address_term_bound_0,B)
    <=> v11997(constB0,B) ) ).

fof(is_address_79,axiom,
    address(v11997_range_3_to_0_address_term_bound_0) ).

fof(address_association_63,axiom,
    v11997_range_3_to_0_address_association(constB0,v11997_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_62,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_20,B)
    <=> v11969(constB20,B) ) ).

fof(is_address_78,axiom,
    address(v11969_range_3_to_0_address_term_bound_20) ).

fof(address_association_62,axiom,
    v11969_range_3_to_0_address_association(constB20,v11969_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_61,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_19,B)
    <=> v11969(constB19,B) ) ).

fof(is_address_77,axiom,
    address(v11969_range_3_to_0_address_term_bound_19) ).

fof(address_association_61,axiom,
    v11969_range_3_to_0_address_association(constB19,v11969_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_60,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_18,B)
    <=> v11969(constB18,B) ) ).

fof(is_address_76,axiom,
    address(v11969_range_3_to_0_address_term_bound_18) ).

fof(address_association_60,axiom,
    v11969_range_3_to_0_address_association(constB18,v11969_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_59,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_17,B)
    <=> v11969(constB17,B) ) ).

fof(is_address_75,axiom,
    address(v11969_range_3_to_0_address_term_bound_17) ).

fof(address_association_59,axiom,
    v11969_range_3_to_0_address_association(constB17,v11969_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_58,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_16,B)
    <=> v11969(constB16,B) ) ).

fof(is_address_74,axiom,
    address(v11969_range_3_to_0_address_term_bound_16) ).

fof(address_association_58,axiom,
    v11969_range_3_to_0_address_association(constB16,v11969_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_57,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_15,B)
    <=> v11969(constB15,B) ) ).

fof(is_address_73,axiom,
    address(v11969_range_3_to_0_address_term_bound_15) ).

fof(address_association_57,axiom,
    v11969_range_3_to_0_address_association(constB15,v11969_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_56,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_14,B)
    <=> v11969(constB14,B) ) ).

fof(is_address_72,axiom,
    address(v11969_range_3_to_0_address_term_bound_14) ).

fof(address_association_56,axiom,
    v11969_range_3_to_0_address_association(constB14,v11969_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_55,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_13,B)
    <=> v11969(constB13,B) ) ).

fof(is_address_71,axiom,
    address(v11969_range_3_to_0_address_term_bound_13) ).

fof(address_association_55,axiom,
    v11969_range_3_to_0_address_association(constB13,v11969_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_54,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_12,B)
    <=> v11969(constB12,B) ) ).

fof(is_address_70,axiom,
    address(v11969_range_3_to_0_address_term_bound_12) ).

fof(address_association_54,axiom,
    v11969_range_3_to_0_address_association(constB12,v11969_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_53,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_11,B)
    <=> v11969(constB11,B) ) ).

fof(is_address_69,axiom,
    address(v11969_range_3_to_0_address_term_bound_11) ).

fof(address_association_53,axiom,
    v11969_range_3_to_0_address_association(constB11,v11969_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_52,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_10,B)
    <=> v11969(constB10,B) ) ).

fof(is_address_68,axiom,
    address(v11969_range_3_to_0_address_term_bound_10) ).

fof(address_association_52,axiom,
    v11969_range_3_to_0_address_association(constB10,v11969_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_51,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_9,B)
    <=> v11969(constB9,B) ) ).

fof(is_address_67,axiom,
    address(v11969_range_3_to_0_address_term_bound_9) ).

fof(address_association_51,axiom,
    v11969_range_3_to_0_address_association(constB9,v11969_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_50,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_8,B)
    <=> v11969(constB8,B) ) ).

fof(is_address_66,axiom,
    address(v11969_range_3_to_0_address_term_bound_8) ).

fof(address_association_50,axiom,
    v11969_range_3_to_0_address_association(constB8,v11969_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_49,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_7,B)
    <=> v11969(constB7,B) ) ).

fof(is_address_65,axiom,
    address(v11969_range_3_to_0_address_term_bound_7) ).

fof(address_association_49,axiom,
    v11969_range_3_to_0_address_association(constB7,v11969_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_48,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_6,B)
    <=> v11969(constB6,B) ) ).

fof(is_address_64,axiom,
    address(v11969_range_3_to_0_address_term_bound_6) ).

fof(address_association_48,axiom,
    v11969_range_3_to_0_address_association(constB6,v11969_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_47,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_5,B)
    <=> v11969(constB5,B) ) ).

fof(is_address_63,axiom,
    address(v11969_range_3_to_0_address_term_bound_5) ).

fof(address_association_47,axiom,
    v11969_range_3_to_0_address_association(constB5,v11969_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_46,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_4,B)
    <=> v11969(constB4,B) ) ).

fof(is_address_62,axiom,
    address(v11969_range_3_to_0_address_term_bound_4) ).

fof(address_association_46,axiom,
    v11969_range_3_to_0_address_association(constB4,v11969_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_45,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_3,B)
    <=> v11969(constB3,B) ) ).

fof(is_address_61,axiom,
    address(v11969_range_3_to_0_address_term_bound_3) ).

fof(address_association_45,axiom,
    v11969_range_3_to_0_address_association(constB3,v11969_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_44,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_2,B)
    <=> v11969(constB2,B) ) ).

fof(is_address_60,axiom,
    address(v11969_range_3_to_0_address_term_bound_2) ).

fof(address_association_44,axiom,
    v11969_range_3_to_0_address_association(constB2,v11969_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_43,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_1,B)
    <=> v11969(constB1,B) ) ).

fof(is_address_59,axiom,
    address(v11969_range_3_to_0_address_term_bound_1) ).

fof(address_association_43,axiom,
    v11969_range_3_to_0_address_association(constB1,v11969_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_42,axiom,
    ! [B] :
      ( addressVal(v11969_range_3_to_0_address_term_bound_0,B)
    <=> v11969(constB0,B) ) ).

fof(is_address_58,axiom,
    address(v11969_range_3_to_0_address_term_bound_0) ).

fof(address_association_42,axiom,
    v11969_range_3_to_0_address_association(constB0,v11969_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_41,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_20,B)
    <=> v11454(constB20,B) ) ).

fof(is_address_57,axiom,
    address(v11454_range_3_to_0_address_term_bound_20) ).

fof(address_association_41,axiom,
    v11454_range_3_to_0_address_association(constB20,v11454_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_40,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_19,B)
    <=> v11454(constB19,B) ) ).

fof(is_address_56,axiom,
    address(v11454_range_3_to_0_address_term_bound_19) ).

fof(address_association_40,axiom,
    v11454_range_3_to_0_address_association(constB19,v11454_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_39,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_18,B)
    <=> v11454(constB18,B) ) ).

fof(is_address_55,axiom,
    address(v11454_range_3_to_0_address_term_bound_18) ).

fof(address_association_39,axiom,
    v11454_range_3_to_0_address_association(constB18,v11454_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_38,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_17,B)
    <=> v11454(constB17,B) ) ).

fof(is_address_54,axiom,
    address(v11454_range_3_to_0_address_term_bound_17) ).

fof(address_association_38,axiom,
    v11454_range_3_to_0_address_association(constB17,v11454_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_37,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_16,B)
    <=> v11454(constB16,B) ) ).

fof(is_address_53,axiom,
    address(v11454_range_3_to_0_address_term_bound_16) ).

fof(address_association_37,axiom,
    v11454_range_3_to_0_address_association(constB16,v11454_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_36,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_15,B)
    <=> v11454(constB15,B) ) ).

fof(is_address_52,axiom,
    address(v11454_range_3_to_0_address_term_bound_15) ).

fof(address_association_36,axiom,
    v11454_range_3_to_0_address_association(constB15,v11454_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_35,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_14,B)
    <=> v11454(constB14,B) ) ).

fof(is_address_51,axiom,
    address(v11454_range_3_to_0_address_term_bound_14) ).

fof(address_association_35,axiom,
    v11454_range_3_to_0_address_association(constB14,v11454_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_34,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_13,B)
    <=> v11454(constB13,B) ) ).

fof(is_address_50,axiom,
    address(v11454_range_3_to_0_address_term_bound_13) ).

fof(address_association_34,axiom,
    v11454_range_3_to_0_address_association(constB13,v11454_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_33,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_12,B)
    <=> v11454(constB12,B) ) ).

fof(is_address_49,axiom,
    address(v11454_range_3_to_0_address_term_bound_12) ).

fof(address_association_33,axiom,
    v11454_range_3_to_0_address_association(constB12,v11454_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_32,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_11,B)
    <=> v11454(constB11,B) ) ).

fof(is_address_48,axiom,
    address(v11454_range_3_to_0_address_term_bound_11) ).

fof(address_association_32,axiom,
    v11454_range_3_to_0_address_association(constB11,v11454_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_31,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_10,B)
    <=> v11454(constB10,B) ) ).

fof(is_address_47,axiom,
    address(v11454_range_3_to_0_address_term_bound_10) ).

fof(address_association_31,axiom,
    v11454_range_3_to_0_address_association(constB10,v11454_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_30,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_9,B)
    <=> v11454(constB9,B) ) ).

fof(is_address_46,axiom,
    address(v11454_range_3_to_0_address_term_bound_9) ).

fof(address_association_30,axiom,
    v11454_range_3_to_0_address_association(constB9,v11454_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_29,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_8,B)
    <=> v11454(constB8,B) ) ).

fof(is_address_45,axiom,
    address(v11454_range_3_to_0_address_term_bound_8) ).

fof(address_association_29,axiom,
    v11454_range_3_to_0_address_association(constB8,v11454_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_28,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_7,B)
    <=> v11454(constB7,B) ) ).

fof(is_address_44,axiom,
    address(v11454_range_3_to_0_address_term_bound_7) ).

fof(address_association_28,axiom,
    v11454_range_3_to_0_address_association(constB7,v11454_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_27,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_6,B)
    <=> v11454(constB6,B) ) ).

fof(is_address_43,axiom,
    address(v11454_range_3_to_0_address_term_bound_6) ).

fof(address_association_27,axiom,
    v11454_range_3_to_0_address_association(constB6,v11454_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_26,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_5,B)
    <=> v11454(constB5,B) ) ).

fof(is_address_42,axiom,
    address(v11454_range_3_to_0_address_term_bound_5) ).

fof(address_association_26,axiom,
    v11454_range_3_to_0_address_association(constB5,v11454_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_25,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_4,B)
    <=> v11454(constB4,B) ) ).

fof(is_address_41,axiom,
    address(v11454_range_3_to_0_address_term_bound_4) ).

fof(address_association_25,axiom,
    v11454_range_3_to_0_address_association(constB4,v11454_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_24,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_3,B)
    <=> v11454(constB3,B) ) ).

fof(is_address_40,axiom,
    address(v11454_range_3_to_0_address_term_bound_3) ).

fof(address_association_24,axiom,
    v11454_range_3_to_0_address_association(constB3,v11454_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_23,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_2,B)
    <=> v11454(constB2,B) ) ).

fof(is_address_39,axiom,
    address(v11454_range_3_to_0_address_term_bound_2) ).

fof(address_association_23,axiom,
    v11454_range_3_to_0_address_association(constB2,v11454_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_22,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_1,B)
    <=> v11454(constB1,B) ) ).

fof(is_address_38,axiom,
    address(v11454_range_3_to_0_address_term_bound_1) ).

fof(address_association_22,axiom,
    v11454_range_3_to_0_address_association(constB1,v11454_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition_21,axiom,
    ! [B] :
      ( addressVal(v11454_range_3_to_0_address_term_bound_0,B)
    <=> v11454(constB0,B) ) ).

fof(is_address_37,axiom,
    address(v11454_range_3_to_0_address_term_bound_0) ).

fof(address_association_21,axiom,
    v11454_range_3_to_0_address_association(constB0,v11454_range_3_to_0_address_term_bound_0) ).

fof(transient_address_definition_20,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_20,B)
    <=> v11426(constB20,B) ) ).

fof(is_address_36,axiom,
    address(v11426_range_3_to_0_address_term_bound_20) ).

fof(address_association_20,axiom,
    v11426_range_3_to_0_address_association(constB20,v11426_range_3_to_0_address_term_bound_20) ).

fof(transient_address_definition_19,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_19,B)
    <=> v11426(constB19,B) ) ).

fof(is_address_35,axiom,
    address(v11426_range_3_to_0_address_term_bound_19) ).

fof(address_association_19,axiom,
    v11426_range_3_to_0_address_association(constB19,v11426_range_3_to_0_address_term_bound_19) ).

fof(transient_address_definition_18,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_18,B)
    <=> v11426(constB18,B) ) ).

fof(is_address_34,axiom,
    address(v11426_range_3_to_0_address_term_bound_18) ).

fof(address_association_18,axiom,
    v11426_range_3_to_0_address_association(constB18,v11426_range_3_to_0_address_term_bound_18) ).

fof(transient_address_definition_17,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_17,B)
    <=> v11426(constB17,B) ) ).

fof(is_address_33,axiom,
    address(v11426_range_3_to_0_address_term_bound_17) ).

fof(address_association_17,axiom,
    v11426_range_3_to_0_address_association(constB17,v11426_range_3_to_0_address_term_bound_17) ).

fof(transient_address_definition_16,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_16,B)
    <=> v11426(constB16,B) ) ).

fof(is_address_32,axiom,
    address(v11426_range_3_to_0_address_term_bound_16) ).

fof(address_association_16,axiom,
    v11426_range_3_to_0_address_association(constB16,v11426_range_3_to_0_address_term_bound_16) ).

fof(transient_address_definition_15,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_15,B)
    <=> v11426(constB15,B) ) ).

fof(is_address_31,axiom,
    address(v11426_range_3_to_0_address_term_bound_15) ).

fof(address_association_15,axiom,
    v11426_range_3_to_0_address_association(constB15,v11426_range_3_to_0_address_term_bound_15) ).

fof(transient_address_definition_14,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_14,B)
    <=> v11426(constB14,B) ) ).

fof(is_address_30,axiom,
    address(v11426_range_3_to_0_address_term_bound_14) ).

fof(address_association_14,axiom,
    v11426_range_3_to_0_address_association(constB14,v11426_range_3_to_0_address_term_bound_14) ).

fof(transient_address_definition_13,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_13,B)
    <=> v11426(constB13,B) ) ).

fof(is_address_29,axiom,
    address(v11426_range_3_to_0_address_term_bound_13) ).

fof(address_association_13,axiom,
    v11426_range_3_to_0_address_association(constB13,v11426_range_3_to_0_address_term_bound_13) ).

fof(transient_address_definition_12,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_12,B)
    <=> v11426(constB12,B) ) ).

fof(is_address_28,axiom,
    address(v11426_range_3_to_0_address_term_bound_12) ).

fof(address_association_12,axiom,
    v11426_range_3_to_0_address_association(constB12,v11426_range_3_to_0_address_term_bound_12) ).

fof(transient_address_definition_11,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_11,B)
    <=> v11426(constB11,B) ) ).

fof(is_address_27,axiom,
    address(v11426_range_3_to_0_address_term_bound_11) ).

fof(address_association_11,axiom,
    v11426_range_3_to_0_address_association(constB11,v11426_range_3_to_0_address_term_bound_11) ).

fof(transient_address_definition_10,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_10,B)
    <=> v11426(constB10,B) ) ).

fof(is_address_26,axiom,
    address(v11426_range_3_to_0_address_term_bound_10) ).

fof(address_association_10,axiom,
    v11426_range_3_to_0_address_association(constB10,v11426_range_3_to_0_address_term_bound_10) ).

fof(transient_address_definition_9,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_9,B)
    <=> v11426(constB9,B) ) ).

fof(is_address_25,axiom,
    address(v11426_range_3_to_0_address_term_bound_9) ).

fof(address_association_9,axiom,
    v11426_range_3_to_0_address_association(constB9,v11426_range_3_to_0_address_term_bound_9) ).

fof(transient_address_definition_8,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_8,B)
    <=> v11426(constB8,B) ) ).

fof(is_address_24,axiom,
    address(v11426_range_3_to_0_address_term_bound_8) ).

fof(address_association_8,axiom,
    v11426_range_3_to_0_address_association(constB8,v11426_range_3_to_0_address_term_bound_8) ).

fof(transient_address_definition_7,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_7,B)
    <=> v11426(constB7,B) ) ).

fof(is_address_23,axiom,
    address(v11426_range_3_to_0_address_term_bound_7) ).

fof(address_association_7,axiom,
    v11426_range_3_to_0_address_association(constB7,v11426_range_3_to_0_address_term_bound_7) ).

fof(transient_address_definition_6,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_6,B)
    <=> v11426(constB6,B) ) ).

fof(is_address_22,axiom,
    address(v11426_range_3_to_0_address_term_bound_6) ).

fof(address_association_6,axiom,
    v11426_range_3_to_0_address_association(constB6,v11426_range_3_to_0_address_term_bound_6) ).

fof(transient_address_definition_5,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_5,B)
    <=> v11426(constB5,B) ) ).

fof(is_address_21,axiom,
    address(v11426_range_3_to_0_address_term_bound_5) ).

fof(address_association_5,axiom,
    v11426_range_3_to_0_address_association(constB5,v11426_range_3_to_0_address_term_bound_5) ).

fof(transient_address_definition_4,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_4,B)
    <=> v11426(constB4,B) ) ).

fof(is_address_20,axiom,
    address(v11426_range_3_to_0_address_term_bound_4) ).

fof(address_association_4,axiom,
    v11426_range_3_to_0_address_association(constB4,v11426_range_3_to_0_address_term_bound_4) ).

fof(transient_address_definition_3,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_3,B)
    <=> v11426(constB3,B) ) ).

fof(is_address_19,axiom,
    address(v11426_range_3_to_0_address_term_bound_3) ).

fof(address_association_3,axiom,
    v11426_range_3_to_0_address_association(constB3,v11426_range_3_to_0_address_term_bound_3) ).

fof(transient_address_definition_2,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_2,B)
    <=> v11426(constB2,B) ) ).

fof(is_address_18,axiom,
    address(v11426_range_3_to_0_address_term_bound_2) ).

fof(address_association_2,axiom,
    v11426_range_3_to_0_address_association(constB2,v11426_range_3_to_0_address_term_bound_2) ).

fof(transient_address_definition_1,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_1,B)
    <=> v11426(constB1,B) ) ).

fof(is_address_17,axiom,
    address(v11426_range_3_to_0_address_term_bound_1) ).

fof(address_association_1,axiom,
    v11426_range_3_to_0_address_association(constB1,v11426_range_3_to_0_address_term_bound_1) ).

fof(transient_address_definition,axiom,
    ! [B] :
      ( addressVal(v11426_range_3_to_0_address_term_bound_0,B)
    <=> v11426(constB0,B) ) ).

fof(is_address_16,axiom,
    address(v11426_range_3_to_0_address_term_bound_0) ).

fof(address_association,axiom,
    v11426_range_3_to_0_address_association(constB0,v11426_range_3_to_0_address_term_bound_0) ).

fof(is_address_15,axiom,
    address(b1011_address_term) ).

fof(constant_address_definition_15,axiom,
    ! [B] :
      ( addressVal(b1011_address_term,B)
    <=> b1011(B) ) ).

fof(is_address_14,axiom,
    address(b1101_address_term) ).

fof(constant_address_definition_14,axiom,
    ! [B] :
      ( addressVal(b1101_address_term,B)
    <=> b1101(B) ) ).

fof(is_address_13,axiom,
    address(b1110_address_term) ).

fof(constant_address_definition_13,axiom,
    ! [B] :
      ( addressVal(b1110_address_term,B)
    <=> b1110(B) ) ).

fof(is_address_12,axiom,
    address(b1100_address_term) ).

fof(constant_address_definition_12,axiom,
    ! [B] :
      ( addressVal(b1100_address_term,B)
    <=> b1100(B) ) ).

fof(is_address_11,axiom,
    address(b1010_address_term) ).

fof(constant_address_definition_11,axiom,
    ! [B] :
      ( addressVal(b1010_address_term,B)
    <=> b1010(B) ) ).

fof(is_address_10,axiom,
    address(b1001_address_term) ).

fof(constant_address_definition_10,axiom,
    ! [B] :
      ( addressVal(b1001_address_term,B)
    <=> b1001(B) ) ).

fof(is_address_9,axiom,
    address(b1111_address_term) ).

fof(constant_address_definition_9,axiom,
    ! [B] :
      ( addressVal(b1111_address_term,B)
    <=> b1111(B) ) ).

fof(is_address_8,axiom,
    address(b0011_address_term) ).

fof(constant_address_definition_8,axiom,
    ! [B] :
      ( addressVal(b0011_address_term,B)
    <=> b0011(B) ) ).

fof(is_address_7,axiom,
    address(b0111_address_term) ).

fof(constant_address_definition_7,axiom,
    ! [B] :
      ( addressVal(b0111_address_term,B)
    <=> b0111(B) ) ).

fof(is_address_6,axiom,
    address(b1000_address_term) ).

fof(constant_address_definition_6,axiom,
    ! [B] :
      ( addressVal(b1000_address_term,B)
    <=> b1000(B) ) ).

fof(is_address_5,axiom,
    address(b0101_address_term) ).

fof(constant_address_definition_5,axiom,
    ! [B] :
      ( addressVal(b0101_address_term,B)
    <=> b0101(B) ) ).

fof(is_address_4,axiom,
    address(b0110_address_term) ).

fof(constant_address_definition_4,axiom,
    ! [B] :
      ( addressVal(b0110_address_term,B)
    <=> b0110(B) ) ).

fof(is_address_3,axiom,
    address(b0001_address_term) ).

fof(constant_address_definition_3,axiom,
    ! [B] :
      ( addressVal(b0001_address_term,B)
    <=> b0001(B) ) ).

fof(is_address_2,axiom,
    address(b0100_address_term) ).

fof(constant_address_definition_2,axiom,
    ! [B] :
      ( addressVal(b0100_address_term,B)
    <=> b0100(B) ) ).

fof(is_address_1,axiom,
    address(b0010_address_term) ).

fof(constant_address_definition_1,axiom,
    ! [B] :
      ( addressVal(b0010_address_term,B)
    <=> b0010(B) ) ).

fof(is_address,axiom,
    address(b0000_address_term) ).

fof(constant_address_definition,axiom,
    ! [B] :
      ( addressVal(b0000_address_term,B)
    <=> b0000(B) ) ).

fof(addressDiff,axiom,
    ! [B,A2,A1] :
      ( ( address(A1)
        & address(A2)
        & addressDiff(A1,A2,B) )
     => ( A1 = A2
        | ( addressVal(A1,B)
        <=> ~ addressVal(A2,B) ) ) ) ).

fof(addressDomain,axiom,
    ! [A1,A2] :
      ( addressDiff(A1,A2,bitIndex0)
      | addressDiff(A1,A2,bitIndex1)
      | addressDiff(A1,A2,bitIndex2)
      | addressDiff(A1,A2,bitIndex3) ) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_11129,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v133734(VarCurr) ) ).

fof(writeUnaryOperator_11128,axiom,
    ! [VarCurr] :
      ( ~ v133734(VarCurr)
    <=> v133735(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26818,axiom,
    ! [VarCurr] :
      ( v133735(VarCurr)
    <=> ( v133737(VarCurr)
        & v133739(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3127,axiom,
    ! [VarCurr] :
      ( v133739(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11127,axiom,
    ! [VarCurr] :
      ( ~ v133737(VarCurr)
    <=> v133738(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3126,axiom,
    ! [VarCurr] :
      ( v133738(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2343,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133722(VarNext)
       => ( v6(VarNext,bitIndex1)
        <=> v6(VarCurr,bitIndex1) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_17,axiom,
    ! [VarNext] :
      ( v133722(VarNext)
     => ( v6(VarNext,bitIndex1)
      <=> v133730(VarNext) ) ) ).

fof(addAssignment_43631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133730(VarNext)
      <=> v133728(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_588,axiom,
    ! [VarCurr] :
      ( ~ v133717(VarCurr)
     => ( v133728(VarCurr)
      <=> v19(VarCurr,bitIndex1) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3016,axiom,
    ! [VarCurr] :
      ( v133717(VarCurr)
     => ( v133728(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26817,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133722(VarNext)
      <=> v133723(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26816,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133723(VarNext)
      <=> ( v133725(VarNext)
          & v131925(VarNext) ) ) ) ).

fof(writeUnaryOperator_11126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133725(VarNext)
      <=> v131932(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2342,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133708(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2479,axiom,
    ! [VarNext] :
      ( v133708(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v133716(VarNext) ) ) ).

fof(addAssignment_43630,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133716(VarNext)
      <=> v133714(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3211,axiom,
    ! [VarCurr] :
      ( ~ v133717(VarCurr)
     => ( v133714(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3015,axiom,
    ! [VarCurr] :
      ( v133717(VarCurr)
     => ( v133714(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_11125,axiom,
    ! [VarCurr] :
      ( ~ v133717(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26815,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133708(VarNext)
      <=> v133709(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26814,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133709(VarNext)
      <=> ( v133710(VarNext)
          & v131925(VarNext) ) ) ) ).

fof(writeUnaryOperator_11124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133710(VarNext)
      <=> v131932(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_587,axiom,
    ! [VarCurr] :
      ( ~ v133700(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_783,axiom,
    ! [VarCurr] :
      ( v133700(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> v133704(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5416,axiom,
    ! [VarCurr] :
      ( ~ v133701(VarCurr)
     => ( v133704(VarCurr)
      <=> v133705(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5405,axiom,
    ! [VarCurr] :
      ( v133701(VarCurr)
     => ( v133704(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3210,axiom,
    ! [VarCurr] :
      ( ~ v11874(VarCurr)
     => ( v133705(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3014,axiom,
    ! [VarCurr] :
      ( v11874(VarCurr)
     => ( v133705(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26813,axiom,
    ! [VarCurr] :
      ( v133700(VarCurr)
    <=> ( v133701(VarCurr)
        | v133702(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26812,axiom,
    ! [VarCurr] :
      ( v133702(VarCurr)
    <=> ( v133703(VarCurr)
        & v11865(VarCurr) ) ) ).

fof(writeUnaryOperator_11123,axiom,
    ! [VarCurr] :
      ( ~ v133703(VarCurr)
    <=> v11872(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26811,axiom,
    ! [VarCurr] :
      ( v133701(VarCurr)
    <=> ( v11868(VarCurr)
        & v11864(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3209,axiom,
    ! [VarCurr] :
      ( ~ v133693(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3013,axiom,
    ! [VarCurr] :
      ( v133693(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> v133697(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5415,axiom,
    ! [VarCurr] :
      ( ~ v133694(VarCurr)
     => ( v133697(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5404,axiom,
    ! [VarCurr] :
      ( v133694(VarCurr)
     => ( v133697(VarCurr)
      <=> v133698(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3208,axiom,
    ! [VarCurr] :
      ( ~ v11870(VarCurr)
     => ( v133698(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3012,axiom,
    ! [VarCurr] :
      ( v11870(VarCurr)
     => ( v133698(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26810,axiom,
    ! [VarCurr] :
      ( v133693(VarCurr)
    <=> ( v133694(VarCurr)
        | v133696(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26809,axiom,
    ! [VarCurr] :
      ( v133696(VarCurr)
    <=> ( v11872(VarCurr)
        & v11865(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26808,axiom,
    ! [VarCurr] :
      ( v133694(VarCurr)
    <=> ( v133695(VarCurr)
        & v11864(VarCurr) ) ) ).

fof(writeUnaryOperator_11122,axiom,
    ! [VarCurr] :
      ( ~ v133695(VarCurr)
    <=> v11868(VarCurr) ) ).

fof(addAssignment_43629,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
    <=> v23(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9324,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
    <=> ( ( v25(VarCurr,bitIndex4)
        <=> $false )
        & ( v25(VarCurr,bitIndex3)
        <=> $false )
        & ( v25(VarCurr,bitIndex2)
        <=> $false )
        & ( v25(VarCurr,bitIndex1)
        <=> $false )
        & ( v25(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2341,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133677(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v25(VarNext,B)
            <=> v25(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2478,axiom,
    ! [VarNext] :
      ( v133677(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v25(VarNext,B)
          <=> v133687(VarNext,B) ) ) ) ).

fof(addAssignment_43628,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v133687(VarNext,B)
          <=> v133685(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3207,axiom,
    ! [VarCurr] :
      ( ~ v133688(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133685(VarCurr,B)
          <=> v30(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3011,axiom,
    ! [VarCurr] :
      ( v133688(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133685(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_11121,axiom,
    ! [VarCurr] :
      ( ~ v133688(VarCurr)
    <=> v27(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26807,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133677(VarNext)
      <=> v133678(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26806,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133678(VarNext)
      <=> ( v133679(VarNext)
          & v133674(VarNext) ) ) ) ).

fof(writeUnaryOperator_11120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133679(VarNext)
      <=> v133681(VarNext) ) ) ).

fof(addAssignment_43627,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133681(VarNext)
      <=> v133674(VarCurr) ) ) ).

fof(addAssignment_43626,axiom,
    ! [VarCurr] :
      ( v133674(VarCurr)
    <=> v131925(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_188,axiom,
    ! [VarCurr] :
      ( ( ~ v133599(VarCurr)
        & ~ v133601(VarCurr)
        & ~ v133642(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v25(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1319,axiom,
    ! [VarCurr] :
      ( v133642(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v133644(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5414,axiom,
    ! [VarCurr] :
      ( v133601(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v133603(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5403,axiom,
    ! [VarCurr] :
      ( v133599(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v25(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9323,axiom,
    ! [VarCurr] :
      ( v133671(VarCurr)
    <=> ( ( v133672(VarCurr,bitIndex1)
        <=> $true )
        & ( v133672(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43625,axiom,
    ! [VarCurr] :
      ( v133672(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_43624,axiom,
    ! [VarCurr] :
      ( v133672(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3206,axiom,
    ! [VarCurr] :
      ( ~ v133645(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133644(VarCurr,B)
          <=> v133646(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3010,axiom,
    ! [VarCurr] :
      ( v133645(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133644(VarCurr,B)
          <=> b01111(B) ) ) ) ).

fof(addAssignment_43623,axiom,
    ! [VarCurr] :
      ( v133646(VarCurr,bitIndex0)
    <=> v133668(VarCurr) ) ).

fof(addAssignment_43622,axiom,
    ! [VarCurr] :
      ( v133646(VarCurr,bitIndex1)
    <=> v133666(VarCurr) ) ).

fof(addAssignment_43621,axiom,
    ! [VarCurr] :
      ( v133646(VarCurr,bitIndex2)
    <=> v133661(VarCurr) ) ).

fof(addAssignment_43620,axiom,
    ! [VarCurr] :
      ( v133646(VarCurr,bitIndex3)
    <=> v133656(VarCurr) ) ).

fof(addAssignment_43619,axiom,
    ! [VarCurr] :
      ( v133646(VarCurr,bitIndex4)
    <=> v133648(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26805,axiom,
    ! [VarCurr] :
      ( v133666(VarCurr)
    <=> ( v133667(VarCurr)
        & v133670(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3125,axiom,
    ! [VarCurr] :
      ( v133670(VarCurr)
    <=> ( v25(VarCurr,bitIndex0)
        | v25(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26804,axiom,
    ! [VarCurr] :
      ( v133667(VarCurr)
    <=> ( v133668(VarCurr)
        | v133669(VarCurr) ) ) ).

fof(writeUnaryOperator_11119,axiom,
    ! [VarCurr] :
      ( ~ v133669(VarCurr)
    <=> v25(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11118,axiom,
    ! [VarCurr] :
      ( ~ v133668(VarCurr)
    <=> v25(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26803,axiom,
    ! [VarCurr] :
      ( v133661(VarCurr)
    <=> ( v133662(VarCurr)
        & v133665(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3124,axiom,
    ! [VarCurr] :
      ( v133665(VarCurr)
    <=> ( v133653(VarCurr)
        | v25(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26802,axiom,
    ! [VarCurr] :
      ( v133662(VarCurr)
    <=> ( v133663(VarCurr)
        | v133664(VarCurr) ) ) ).

fof(writeUnaryOperator_11117,axiom,
    ! [VarCurr] :
      ( ~ v133664(VarCurr)
    <=> v25(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11116,axiom,
    ! [VarCurr] :
      ( ~ v133663(VarCurr)
    <=> v133653(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26801,axiom,
    ! [VarCurr] :
      ( v133656(VarCurr)
    <=> ( v133657(VarCurr)
        & v133660(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3123,axiom,
    ! [VarCurr] :
      ( v133660(VarCurr)
    <=> ( v133652(VarCurr)
        | v25(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26800,axiom,
    ! [VarCurr] :
      ( v133657(VarCurr)
    <=> ( v133658(VarCurr)
        | v133659(VarCurr) ) ) ).

fof(writeUnaryOperator_11115,axiom,
    ! [VarCurr] :
      ( ~ v133659(VarCurr)
    <=> v25(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11114,axiom,
    ! [VarCurr] :
      ( ~ v133658(VarCurr)
    <=> v133652(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26799,axiom,
    ! [VarCurr] :
      ( v133648(VarCurr)
    <=> ( v133649(VarCurr)
        & v133655(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3122,axiom,
    ! [VarCurr] :
      ( v133655(VarCurr)
    <=> ( v133651(VarCurr)
        | v25(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26798,axiom,
    ! [VarCurr] :
      ( v133649(VarCurr)
    <=> ( v133650(VarCurr)
        | v133654(VarCurr) ) ) ).

fof(writeUnaryOperator_11113,axiom,
    ! [VarCurr] :
      ( ~ v133654(VarCurr)
    <=> v25(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11112,axiom,
    ! [VarCurr] :
      ( ~ v133650(VarCurr)
    <=> v133651(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3121,axiom,
    ! [VarCurr] :
      ( v133651(VarCurr)
    <=> ( v133652(VarCurr)
        & v25(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3120,axiom,
    ! [VarCurr] :
      ( v133652(VarCurr)
    <=> ( v133653(VarCurr)
        & v25(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3119,axiom,
    ! [VarCurr] :
      ( v133653(VarCurr)
    <=> ( v25(VarCurr,bitIndex0)
        & v25(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9322,axiom,
    ! [VarCurr] :
      ( v133645(VarCurr)
    <=> ( ( v25(VarCurr,bitIndex4)
        <=> $false )
        & ( v25(VarCurr,bitIndex3)
        <=> $true )
        & ( v25(VarCurr,bitIndex2)
        <=> $true )
        & ( v25(VarCurr,bitIndex1)
        <=> $true )
        & ( v25(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9321,axiom,
    ! [VarCurr] :
      ( v133642(VarCurr)
    <=> ( ( v133643(VarCurr,bitIndex1)
        <=> $true )
        & ( v133643(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43618,axiom,
    ! [VarCurr] :
      ( v133643(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_43617,axiom,
    ! [VarCurr] :
      ( v133643(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3205,axiom,
    ! [VarCurr] :
      ( ~ v133604(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133603(VarCurr,B)
          <=> v133605(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3009,axiom,
    ! [VarCurr] :
      ( v133604(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133603(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_211,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex6)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_210,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex7)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_209,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex8)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_208,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex9)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_207,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex10)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_206,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex11)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_205,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex12)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_204,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex13)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_203,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex14)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_202,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex15)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_201,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex16)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_200,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex17)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_199,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex18)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_198,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex19)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_197,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex20)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_196,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex21)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_195,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex22)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_194,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex23)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_193,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex24)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_192,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex25)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_191,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex26)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_190,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex27)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_189,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex28)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_188,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex29)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_187,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex30)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_186,axiom,
    ! [VarCurr] :
      ( v133605(VarCurr,bitIndex31)
    <=> v133606(VarCurr,bitIndex5) ) ).

fof(addAssignment_43616,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v133605(VarCurr,B)
      <=> v133606(VarCurr,B) ) ) ).

fof(addAssignment_43615,axiom,
    ! [VarCurr] :
      ( v133606(VarCurr,bitIndex0)
    <=> v133640(VarCurr) ) ).

fof(addAssignment_43614,axiom,
    ! [VarCurr] :
      ( v133606(VarCurr,bitIndex1)
    <=> v133638(VarCurr) ) ).

fof(addAssignment_43613,axiom,
    ! [VarCurr] :
      ( v133606(VarCurr,bitIndex2)
    <=> v133634(VarCurr) ) ).

fof(addAssignment_43612,axiom,
    ! [VarCurr] :
      ( v133606(VarCurr,bitIndex3)
    <=> v133630(VarCurr) ) ).

fof(addAssignment_43611,axiom,
    ! [VarCurr] :
      ( v133606(VarCurr,bitIndex4)
    <=> v133626(VarCurr) ) ).

fof(addAssignment_43610,axiom,
    ! [VarCurr] :
      ( v133606(VarCurr,bitIndex5)
    <=> v133608(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26797,axiom,
    ! [VarCurr] :
      ( v133638(VarCurr)
    <=> ( v133639(VarCurr)
        & v133641(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26796,axiom,
    ! [VarCurr] :
      ( v133641(VarCurr)
    <=> ( v133612(VarCurr,bitIndex0)
        | v133620(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3118,axiom,
    ! [VarCurr] :
      ( v133639(VarCurr)
    <=> ( v133640(VarCurr)
        | v133612(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11111,axiom,
    ! [VarCurr] :
      ( ~ v133640(VarCurr)
    <=> v133612(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26795,axiom,
    ! [VarCurr] :
      ( v133634(VarCurr)
    <=> ( v133635(VarCurr)
        & v133637(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26794,axiom,
    ! [VarCurr] :
      ( v133637(VarCurr)
    <=> ( v133618(VarCurr)
        | v133621(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3117,axiom,
    ! [VarCurr] :
      ( v133635(VarCurr)
    <=> ( v133636(VarCurr)
        | v133612(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_11110,axiom,
    ! [VarCurr] :
      ( ~ v133636(VarCurr)
    <=> v133618(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26793,axiom,
    ! [VarCurr] :
      ( v133630(VarCurr)
    <=> ( v133631(VarCurr)
        & v133633(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26792,axiom,
    ! [VarCurr] :
      ( v133633(VarCurr)
    <=> ( v133616(VarCurr)
        | v133622(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3116,axiom,
    ! [VarCurr] :
      ( v133631(VarCurr)
    <=> ( v133632(VarCurr)
        | v133612(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_11109,axiom,
    ! [VarCurr] :
      ( ~ v133632(VarCurr)
    <=> v133616(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26791,axiom,
    ! [VarCurr] :
      ( v133626(VarCurr)
    <=> ( v133627(VarCurr)
        & v133629(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26790,axiom,
    ! [VarCurr] :
      ( v133629(VarCurr)
    <=> ( v133614(VarCurr)
        | v133623(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3115,axiom,
    ! [VarCurr] :
      ( v133627(VarCurr)
    <=> ( v133628(VarCurr)
        | v133612(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_11108,axiom,
    ! [VarCurr] :
      ( ~ v133628(VarCurr)
    <=> v133614(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26789,axiom,
    ! [VarCurr] :
      ( v133608(VarCurr)
    <=> ( v133609(VarCurr)
        & v133624(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26788,axiom,
    ! [VarCurr] :
      ( v133624(VarCurr)
    <=> ( v133611(VarCurr)
        | v133625(VarCurr) ) ) ).

fof(writeUnaryOperator_11107,axiom,
    ! [VarCurr] :
      ( ~ v133625(VarCurr)
    <=> v133612(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_3114,axiom,
    ! [VarCurr] :
      ( v133609(VarCurr)
    <=> ( v133610(VarCurr)
        | v133612(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_11106,axiom,
    ! [VarCurr] :
      ( ~ v133610(VarCurr)
    <=> v133611(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3113,axiom,
    ! [VarCurr] :
      ( v133611(VarCurr)
    <=> ( v133612(VarCurr,bitIndex4)
        | v133613(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26787,axiom,
    ! [VarCurr] :
      ( v133613(VarCurr)
    <=> ( v133614(VarCurr)
        & v133623(VarCurr) ) ) ).

fof(writeUnaryOperator_11105,axiom,
    ! [VarCurr] :
      ( ~ v133623(VarCurr)
    <=> v133612(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3112,axiom,
    ! [VarCurr] :
      ( v133614(VarCurr)
    <=> ( v133612(VarCurr,bitIndex3)
        | v133615(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26786,axiom,
    ! [VarCurr] :
      ( v133615(VarCurr)
    <=> ( v133616(VarCurr)
        & v133622(VarCurr) ) ) ).

fof(writeUnaryOperator_11104,axiom,
    ! [VarCurr] :
      ( ~ v133622(VarCurr)
    <=> v133612(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_3111,axiom,
    ! [VarCurr] :
      ( v133616(VarCurr)
    <=> ( v133612(VarCurr,bitIndex2)
        | v133617(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26785,axiom,
    ! [VarCurr] :
      ( v133617(VarCurr)
    <=> ( v133618(VarCurr)
        & v133621(VarCurr) ) ) ).

fof(writeUnaryOperator_11103,axiom,
    ! [VarCurr] :
      ( ~ v133621(VarCurr)
    <=> v133612(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3110,axiom,
    ! [VarCurr] :
      ( v133618(VarCurr)
    <=> ( v133612(VarCurr,bitIndex1)
        | v133619(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26784,axiom,
    ! [VarCurr] :
      ( v133619(VarCurr)
    <=> ( v133612(VarCurr,bitIndex0)
        & v133620(VarCurr) ) ) ).

fof(writeUnaryOperator_11102,axiom,
    ! [VarCurr] :
      ( ~ v133620(VarCurr)
    <=> v133612(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_14,axiom,
    ! [VarCurr] : ~ v133612(VarCurr,bitIndex5) ).

fof(addAssignment_43609,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v133612(VarCurr,B)
      <=> v25(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_9320,axiom,
    ! [VarCurr] :
      ( v133604(VarCurr)
    <=> ( ( v25(VarCurr,bitIndex4)
        <=> $false )
        & ( v25(VarCurr,bitIndex3)
        <=> $false )
        & ( v25(VarCurr,bitIndex2)
        <=> $false )
        & ( v25(VarCurr,bitIndex1)
        <=> $false )
        & ( v25(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9319,axiom,
    ! [VarCurr] :
      ( v133601(VarCurr)
    <=> ( ( v133602(VarCurr,bitIndex1)
        <=> $false )
        & ( v133602(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43608,axiom,
    ! [VarCurr] :
      ( v133602(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_43607,axiom,
    ! [VarCurr] :
      ( v133602(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(addAssignmentInitValueVector_45,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v25(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_9318,axiom,
    ! [VarCurr] :
      ( v133599(VarCurr)
    <=> ( ( v133600(VarCurr,bitIndex1)
        <=> $false )
        & ( v133600(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43606,axiom,
    ! [VarCurr] :
      ( v133600(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_43605,axiom,
    ! [VarCurr] :
      ( v133600(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(addAssignment_43604,axiom,
    ! [VarCurr] :
      ( v56(VarCurr)
    <=> v58(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3204,axiom,
    ! [VarCurr] :
      ( ~ v133592(VarCurr)
     => ( v58(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3008,axiom,
    ! [VarCurr] :
      ( v133592(VarCurr)
     => ( v58(VarCurr)
      <=> v133593(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5413,axiom,
    ! [VarCurr] :
      ( ~ v11864(VarCurr)
     => ( v133593(VarCurr)
      <=> v133596(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5402,axiom,
    ! [VarCurr] :
      ( v11864(VarCurr)
     => ( v133593(VarCurr)
      <=> v133594(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3203,axiom,
    ! [VarCurr] :
      ( ~ v11872(VarCurr)
     => ( v133596(VarCurr)
      <=> v133597(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3007,axiom,
    ! [VarCurr] :
      ( v11872(VarCurr)
     => ( v133596(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3202,axiom,
    ! [VarCurr] :
      ( ~ v11874(VarCurr)
     => ( v133597(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3006,axiom,
    ! [VarCurr] :
      ( v11874(VarCurr)
     => ( v133597(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3201,axiom,
    ! [VarCurr] :
      ( ~ v11868(VarCurr)
     => ( v133594(VarCurr)
      <=> v133595(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3005,axiom,
    ! [VarCurr] :
      ( v11868(VarCurr)
     => ( v133594(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3200,axiom,
    ! [VarCurr] :
      ( ~ v11870(VarCurr)
     => ( v133595(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3004,axiom,
    ! [VarCurr] :
      ( v11870(VarCurr)
     => ( v133595(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26783,axiom,
    ! [VarCurr] :
      ( v133592(VarCurr)
    <=> ( v11864(VarCurr)
        | v11865(VarCurr) ) ) ).

fof(addAssignment_43603,axiom,
    ! [VarCurr] :
      ( v60(VarCurr)
    <=> v62(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9317,axiom,
    ! [VarCurr] :
      ( v62(VarCurr)
    <=> ( ( v64(VarCurr,bitIndex4)
        <=> $false )
        & ( v64(VarCurr,bitIndex3)
        <=> $false )
        & ( v64(VarCurr,bitIndex2)
        <=> $false )
        & ( v64(VarCurr,bitIndex1)
        <=> $false )
        & ( v64(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2340,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133576(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v64(VarNext,B)
            <=> v64(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2477,axiom,
    ! [VarNext] :
      ( v133576(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v64(VarNext,B)
          <=> v133586(VarNext,B) ) ) ) ).

fof(addAssignment_43602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v133586(VarNext,B)
          <=> v133584(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3199,axiom,
    ! [VarCurr] :
      ( ~ v133587(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133584(VarCurr,B)
          <=> v68(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3003,axiom,
    ! [VarCurr] :
      ( v133587(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133584(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_11101,axiom,
    ! [VarCurr] :
      ( ~ v133587(VarCurr)
    <=> v66(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26782,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133576(VarNext)
      <=> v133577(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26781,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133577(VarNext)
      <=> ( v133578(VarNext)
          & v133573(VarNext) ) ) ) ).

fof(writeUnaryOperator_11100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133578(VarNext)
      <=> v133580(VarNext) ) ) ).

fof(addAssignment_43601,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133580(VarNext)
      <=> v133573(VarCurr) ) ) ).

fof(addAssignment_43600,axiom,
    ! [VarCurr] :
      ( v133573(VarCurr)
    <=> v131925(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_187,axiom,
    ! [VarCurr] :
      ( ( ~ v133498(VarCurr)
        & ~ v133500(VarCurr)
        & ~ v133541(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v64(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1318,axiom,
    ! [VarCurr] :
      ( v133541(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v133543(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5412,axiom,
    ! [VarCurr] :
      ( v133500(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v133502(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5401,axiom,
    ! [VarCurr] :
      ( v133498(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v64(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9316,axiom,
    ! [VarCurr] :
      ( v133570(VarCurr)
    <=> ( ( v133571(VarCurr,bitIndex1)
        <=> $true )
        & ( v133571(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43599,axiom,
    ! [VarCurr] :
      ( v133571(VarCurr,bitIndex0)
    <=> v133496(VarCurr) ) ).

fof(addAssignment_43598,axiom,
    ! [VarCurr] :
      ( v133571(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3198,axiom,
    ! [VarCurr] :
      ( ~ v133544(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133543(VarCurr,B)
          <=> v133545(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3002,axiom,
    ! [VarCurr] :
      ( v133544(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v133543(VarCurr,B)
          <=> b01111(B) ) ) ) ).

fof(addAssignment_43597,axiom,
    ! [VarCurr] :
      ( v133545(VarCurr,bitIndex0)
    <=> v133567(VarCurr) ) ).

fof(addAssignment_43596,axiom,
    ! [VarCurr] :
      ( v133545(VarCurr,bitIndex1)
    <=> v133565(VarCurr) ) ).

fof(addAssignment_43595,axiom,
    ! [VarCurr] :
      ( v133545(VarCurr,bitIndex2)
    <=> v133560(VarCurr) ) ).

fof(addAssignment_43594,axiom,
    ! [VarCurr] :
      ( v133545(VarCurr,bitIndex3)
    <=> v133555(VarCurr) ) ).

fof(addAssignment_43593,axiom,
    ! [VarCurr] :
      ( v133545(VarCurr,bitIndex4)
    <=> v133547(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26780,axiom,
    ! [VarCurr] :
      ( v133565(VarCurr)
    <=> ( v133566(VarCurr)
        & v133569(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3109,axiom,
    ! [VarCurr] :
      ( v133569(VarCurr)
    <=> ( v64(VarCurr,bitIndex0)
        | v64(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26779,axiom,
    ! [VarCurr] :
      ( v133566(VarCurr)
    <=> ( v133567(VarCurr)
        | v133568(VarCurr) ) ) ).

fof(writeUnaryOperator_11099,axiom,
    ! [VarCurr] :
      ( ~ v133568(VarCurr)
    <=> v64(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11098,axiom,
    ! [VarCurr] :
      ( ~ v133567(VarCurr)
    <=> v64(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26778,axiom,
    ! [VarCurr] :
      ( v133560(VarCurr)
    <=> ( v133561(VarCurr)
        & v133564(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3108,axiom,
    ! [VarCurr] :
      ( v133564(VarCurr)
    <=> ( v133552(VarCurr)
        | v64(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26777,axiom,
    ! [VarCurr] :
      ( v133561(VarCurr)
    <=> ( v133562(VarCurr)
        | v133563(VarCurr) ) ) ).

fof(writeUnaryOperator_11097,axiom,
    ! [VarCurr] :
      ( ~ v133563(VarCurr)
    <=> v64(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11096,axiom,
    ! [VarCurr] :
      ( ~ v133562(VarCurr)
    <=> v133552(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26776,axiom,
    ! [VarCurr] :
      ( v133555(VarCurr)
    <=> ( v133556(VarCurr)
        & v133559(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3107,axiom,
    ! [VarCurr] :
      ( v133559(VarCurr)
    <=> ( v133551(VarCurr)
        | v64(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26775,axiom,
    ! [VarCurr] :
      ( v133556(VarCurr)
    <=> ( v133557(VarCurr)
        | v133558(VarCurr) ) ) ).

fof(writeUnaryOperator_11095,axiom,
    ! [VarCurr] :
      ( ~ v133558(VarCurr)
    <=> v64(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11094,axiom,
    ! [VarCurr] :
      ( ~ v133557(VarCurr)
    <=> v133551(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26774,axiom,
    ! [VarCurr] :
      ( v133547(VarCurr)
    <=> ( v133548(VarCurr)
        & v133554(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3106,axiom,
    ! [VarCurr] :
      ( v133554(VarCurr)
    <=> ( v133550(VarCurr)
        | v64(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26773,axiom,
    ! [VarCurr] :
      ( v133548(VarCurr)
    <=> ( v133549(VarCurr)
        | v133553(VarCurr) ) ) ).

fof(writeUnaryOperator_11093,axiom,
    ! [VarCurr] :
      ( ~ v133553(VarCurr)
    <=> v64(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11092,axiom,
    ! [VarCurr] :
      ( ~ v133549(VarCurr)
    <=> v133550(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3105,axiom,
    ! [VarCurr] :
      ( v133550(VarCurr)
    <=> ( v133551(VarCurr)
        & v64(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3104,axiom,
    ! [VarCurr] :
      ( v133551(VarCurr)
    <=> ( v133552(VarCurr)
        & v64(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3103,axiom,
    ! [VarCurr] :
      ( v133552(VarCurr)
    <=> ( v64(VarCurr,bitIndex0)
        & v64(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9315,axiom,
    ! [VarCurr] :
      ( v133544(VarCurr)
    <=> ( ( v64(VarCurr,bitIndex4)
        <=> $false )
        & ( v64(VarCurr,bitIndex3)
        <=> $true )
        & ( v64(VarCurr,bitIndex2)
        <=> $true )
        & ( v64(VarCurr,bitIndex1)
        <=> $true )
        & ( v64(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9314,axiom,
    ! [VarCurr] :
      ( v133541(VarCurr)
    <=> ( ( v133542(VarCurr,bitIndex1)
        <=> $true )
        & ( v133542(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43592,axiom,
    ! [VarCurr] :
      ( v133542(VarCurr,bitIndex0)
    <=> v133496(VarCurr) ) ).

fof(addAssignment_43591,axiom,
    ! [VarCurr] :
      ( v133542(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3197,axiom,
    ! [VarCurr] :
      ( ~ v133503(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133502(VarCurr,B)
          <=> v133504(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3001,axiom,
    ! [VarCurr] :
      ( v133503(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v133502(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_185,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex6)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_184,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex7)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_183,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex8)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_182,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex9)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_181,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex10)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_180,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex11)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_179,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex12)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_178,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex13)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_177,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex14)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_176,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex15)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_175,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex16)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_174,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex17)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_173,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex18)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_172,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex19)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_171,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex20)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_170,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex21)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_169,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex22)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_168,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex23)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_167,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex24)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_166,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex25)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_165,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex26)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_164,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex27)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_163,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex28)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_162,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex29)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_161,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex30)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_160,axiom,
    ! [VarCurr] :
      ( v133504(VarCurr,bitIndex31)
    <=> v133505(VarCurr,bitIndex5) ) ).

fof(addAssignment_43590,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v133504(VarCurr,B)
      <=> v133505(VarCurr,B) ) ) ).

fof(addAssignment_43589,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr,bitIndex0)
    <=> v133539(VarCurr) ) ).

fof(addAssignment_43588,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr,bitIndex1)
    <=> v133537(VarCurr) ) ).

fof(addAssignment_43587,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr,bitIndex2)
    <=> v133533(VarCurr) ) ).

fof(addAssignment_43586,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr,bitIndex3)
    <=> v133529(VarCurr) ) ).

fof(addAssignment_43585,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr,bitIndex4)
    <=> v133525(VarCurr) ) ).

fof(addAssignment_43584,axiom,
    ! [VarCurr] :
      ( v133505(VarCurr,bitIndex5)
    <=> v133507(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26772,axiom,
    ! [VarCurr] :
      ( v133537(VarCurr)
    <=> ( v133538(VarCurr)
        & v133540(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26771,axiom,
    ! [VarCurr] :
      ( v133540(VarCurr)
    <=> ( v133511(VarCurr,bitIndex0)
        | v133519(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3102,axiom,
    ! [VarCurr] :
      ( v133538(VarCurr)
    <=> ( v133539(VarCurr)
        | v133511(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_11091,axiom,
    ! [VarCurr] :
      ( ~ v133539(VarCurr)
    <=> v133511(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26770,axiom,
    ! [VarCurr] :
      ( v133533(VarCurr)
    <=> ( v133534(VarCurr)
        & v133536(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26769,axiom,
    ! [VarCurr] :
      ( v133536(VarCurr)
    <=> ( v133517(VarCurr)
        | v133520(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3101,axiom,
    ! [VarCurr] :
      ( v133534(VarCurr)
    <=> ( v133535(VarCurr)
        | v133511(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_11090,axiom,
    ! [VarCurr] :
      ( ~ v133535(VarCurr)
    <=> v133517(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26768,axiom,
    ! [VarCurr] :
      ( v133529(VarCurr)
    <=> ( v133530(VarCurr)
        & v133532(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26767,axiom,
    ! [VarCurr] :
      ( v133532(VarCurr)
    <=> ( v133515(VarCurr)
        | v133521(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3100,axiom,
    ! [VarCurr] :
      ( v133530(VarCurr)
    <=> ( v133531(VarCurr)
        | v133511(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_11089,axiom,
    ! [VarCurr] :
      ( ~ v133531(VarCurr)
    <=> v133515(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26766,axiom,
    ! [VarCurr] :
      ( v133525(VarCurr)
    <=> ( v133526(VarCurr)
        & v133528(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26765,axiom,
    ! [VarCurr] :
      ( v133528(VarCurr)
    <=> ( v133513(VarCurr)
        | v133522(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3099,axiom,
    ! [VarCurr] :
      ( v133526(VarCurr)
    <=> ( v133527(VarCurr)
        | v133511(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_11088,axiom,
    ! [VarCurr] :
      ( ~ v133527(VarCurr)
    <=> v133513(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26764,axiom,
    ! [VarCurr] :
      ( v133507(VarCurr)
    <=> ( v133508(VarCurr)
        & v133523(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26763,axiom,
    ! [VarCurr] :
      ( v133523(VarCurr)
    <=> ( v133510(VarCurr)
        | v133524(VarCurr) ) ) ).

fof(writeUnaryOperator_11087,axiom,
    ! [VarCurr] :
      ( ~ v133524(VarCurr)
    <=> v133511(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_3098,axiom,
    ! [VarCurr] :
      ( v133508(VarCurr)
    <=> ( v133509(VarCurr)
        | v133511(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_11086,axiom,
    ! [VarCurr] :
      ( ~ v133509(VarCurr)
    <=> v133510(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3097,axiom,
    ! [VarCurr] :
      ( v133510(VarCurr)
    <=> ( v133511(VarCurr,bitIndex4)
        | v133512(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26762,axiom,
    ! [VarCurr] :
      ( v133512(VarCurr)
    <=> ( v133513(VarCurr)
        & v133522(VarCurr) ) ) ).

fof(writeUnaryOperator_11085,axiom,
    ! [VarCurr] :
      ( ~ v133522(VarCurr)
    <=> v133511(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3096,axiom,
    ! [VarCurr] :
      ( v133513(VarCurr)
    <=> ( v133511(VarCurr,bitIndex3)
        | v133514(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26761,axiom,
    ! [VarCurr] :
      ( v133514(VarCurr)
    <=> ( v133515(VarCurr)
        & v133521(VarCurr) ) ) ).

fof(writeUnaryOperator_11084,axiom,
    ! [VarCurr] :
      ( ~ v133521(VarCurr)
    <=> v133511(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_3095,axiom,
    ! [VarCurr] :
      ( v133515(VarCurr)
    <=> ( v133511(VarCurr,bitIndex2)
        | v133516(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26760,axiom,
    ! [VarCurr] :
      ( v133516(VarCurr)
    <=> ( v133517(VarCurr)
        & v133520(VarCurr) ) ) ).

fof(writeUnaryOperator_11083,axiom,
    ! [VarCurr] :
      ( ~ v133520(VarCurr)
    <=> v133511(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3094,axiom,
    ! [VarCurr] :
      ( v133517(VarCurr)
    <=> ( v133511(VarCurr,bitIndex1)
        | v133518(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26759,axiom,
    ! [VarCurr] :
      ( v133518(VarCurr)
    <=> ( v133511(VarCurr,bitIndex0)
        & v133519(VarCurr) ) ) ).

fof(writeUnaryOperator_11082,axiom,
    ! [VarCurr] :
      ( ~ v133519(VarCurr)
    <=> v133511(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_13,axiom,
    ! [VarCurr] : ~ v133511(VarCurr,bitIndex5) ).

fof(addAssignment_43583,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v133511(VarCurr,B)
      <=> v64(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_9313,axiom,
    ! [VarCurr] :
      ( v133503(VarCurr)
    <=> ( ( v64(VarCurr,bitIndex4)
        <=> $false )
        & ( v64(VarCurr,bitIndex3)
        <=> $false )
        & ( v64(VarCurr,bitIndex2)
        <=> $false )
        & ( v64(VarCurr,bitIndex1)
        <=> $false )
        & ( v64(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9312,axiom,
    ! [VarCurr] :
      ( v133500(VarCurr)
    <=> ( ( v133501(VarCurr,bitIndex1)
        <=> $false )
        & ( v133501(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43582,axiom,
    ! [VarCurr] :
      ( v133501(VarCurr,bitIndex0)
    <=> v133496(VarCurr) ) ).

fof(addAssignment_43581,axiom,
    ! [VarCurr] :
      ( v133501(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(addAssignmentInitValueVector_44,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v64(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_9311,axiom,
    ! [VarCurr] :
      ( v133498(VarCurr)
    <=> ( ( v133499(VarCurr,bitIndex1)
        <=> $false )
        & ( v133499(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43580,axiom,
    ! [VarCurr] :
      ( v133499(VarCurr,bitIndex0)
    <=> v133496(VarCurr) ) ).

fof(addAssignment_43579,axiom,
    ! [VarCurr] :
      ( v133499(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(addAssignment_43578,axiom,
    ! [VarCurr] :
      ( v133496(VarCurr)
    <=> v11861(VarCurr) ) ).

fof(addAssignment_43577,axiom,
    ! [VarCurr] :
      ( v70(VarCurr)
    <=> v72(VarCurr) ) ).

fof(addAssignment_43576,axiom,
    ! [VarCurr] :
      ( v72(VarCurr)
    <=> v74(VarCurr) ) ).

fof(addAssignment_43575,axiom,
    ! [VarCurr] :
      ( v74(VarCurr)
    <=> v76(VarCurr) ) ).

fof(addAssignment_43574,axiom,
    ! [VarCurr] :
      ( v76(VarCurr)
    <=> v78(VarCurr) ) ).

fof(addAssignment_43573,axiom,
    ! [VarCurr] :
      ( v78(VarCurr)
    <=> v80(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2339,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133483(VarNext)
       => ( v80(VarNext)
        <=> v80(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2476,axiom,
    ! [VarNext] :
      ( v133483(VarNext)
     => ( v80(VarNext)
      <=> v133491(VarNext) ) ) ).

fof(addAssignment_43572,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133491(VarNext)
      <=> v133489(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3196,axiom,
    ! [VarCurr] :
      ( ~ v133492(VarCurr)
     => ( v133489(VarCurr)
      <=> v86(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3000,axiom,
    ! [VarCurr] :
      ( v133492(VarCurr)
     => ( v133489(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_11081,axiom,
    ! [VarCurr] :
      ( ~ v133492(VarCurr)
    <=> v82(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26758,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133483(VarNext)
      <=> v133484(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26757,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133484(VarNext)
      <=> ( v133485(VarNext)
          & v104990(VarNext) ) ) ) ).

fof(writeUnaryOperator_11080,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133485(VarNext)
      <=> v104997(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3195,axiom,
    ! [VarCurr] :
      ( ~ v133475(VarCurr)
     => ( v86(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2999,axiom,
    ! [VarCurr] :
      ( v133475(VarCurr)
     => ( v86(VarCurr)
      <=> v133480(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5411,axiom,
    ! [VarCurr] :
      ( ~ v133477(VarCurr)
     => ( v133480(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5400,axiom,
    ! [VarCurr] :
      ( v133477(VarCurr)
     => ( v133480(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26756,axiom,
    ! [VarCurr] :
      ( v133475(VarCurr)
    <=> ( v133476(VarCurr)
        & v133479(VarCurr) ) ) ).

fof(writeUnaryOperator_11079,axiom,
    ! [VarCurr] :
      ( ~ v133479(VarCurr)
    <=> v105017(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26755,axiom,
    ! [VarCurr] :
      ( v133476(VarCurr)
    <=> ( v133477(VarCurr)
        | v133478(VarCurr) ) ) ).

fof(writeUnaryOperator_11078,axiom,
    ! [VarCurr] :
      ( ~ v133478(VarCurr)
    <=> v105014(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26754,axiom,
    ! [VarCurr] :
      ( v133477(VarCurr)
    <=> ( v129294(VarCurr)
        & v105014(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3194,axiom,
    ! [VarCurr] :
      ( ~ v90(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v88(VarCurr,B)
          <=> v133405(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2998,axiom,
    ! [VarCurr] :
      ( v90(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v88(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4_26,axiom,
    ! [VarCurr] :
      ( ( ~ v133406(VarCurr)
        & ~ v133443(VarCurr)
        & ~ v133451(VarCurr)
        & ~ v133459(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v133405(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_186,axiom,
    ! [VarCurr] :
      ( v133459(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133405(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1317,axiom,
    ! [VarCurr] :
      ( v133451(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133405(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5410,axiom,
    ! [VarCurr] :
      ( v133443(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133405(VarCurr,B)
          <=> v133450(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5399,axiom,
    ! [VarCurr] :
      ( v133406(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133405(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26753,axiom,
    ! [VarCurr] :
      ( v133459(VarCurr)
    <=> ( v133461(VarCurr)
        | v133470(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26752,axiom,
    ! [VarCurr] :
      ( v133470(VarCurr)
    <=> ( v133472(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3093,axiom,
    ! [VarCurr] :
      ( v133472(VarCurr)
    <=> ( v133473(VarCurr)
        & v133246(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3092,axiom,
    ! [VarCurr] :
      ( v133473(VarCurr)
    <=> ( v133422(VarCurr)
        & v133246(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26751,axiom,
    ! [VarCurr] :
      ( v133461(VarCurr)
    <=> ( v133462(VarCurr)
        | v133467(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3091,axiom,
    ! [VarCurr] :
      ( v133467(VarCurr)
    <=> ( v133469(VarCurr)
        & v133246(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3090,axiom,
    ! [VarCurr] :
      ( v133469(VarCurr)
    <=> ( v133465(VarCurr)
        & v133246(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3089,axiom,
    ! [VarCurr] :
      ( v133462(VarCurr)
    <=> ( v133464(VarCurr)
        & v133246(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26750,axiom,
    ! [VarCurr] :
      ( v133464(VarCurr)
    <=> ( v133465(VarCurr)
        & v133424(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3088,axiom,
    ! [VarCurr] :
      ( v133465(VarCurr)
    <=> ( v133466(VarCurr)
        & v133246(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3087,axiom,
    ! [VarCurr] :
      ( v133466(VarCurr)
    <=> ( v133417(VarCurr)
        & v133246(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26749,axiom,
    ! [VarCurr] :
      ( v133451(VarCurr)
    <=> ( v133452(VarCurr)
        | v133454(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26748,axiom,
    ! [VarCurr] :
      ( v133454(VarCurr)
    <=> ( v133456(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26747,axiom,
    ! [VarCurr] :
      ( v133456(VarCurr)
    <=> ( v133457(VarCurr)
        & v133424(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26746,axiom,
    ! [VarCurr] :
      ( v133457(VarCurr)
    <=> ( v133458(VarCurr)
        & v133423(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3086,axiom,
    ! [VarCurr] :
      ( v133458(VarCurr)
    <=> ( v133434(VarCurr)
        & v133246(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3085,axiom,
    ! [VarCurr] :
      ( v133452(VarCurr)
    <=> ( v133445(VarCurr)
        & v133246(VarCurr,bitIndex6) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3193,axiom,
    ! [VarCurr] :
      ( ~ v133248(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133450(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2997,axiom,
    ! [VarCurr] :
      ( v133248(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v133450(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26745,axiom,
    ! [VarCurr] :
      ( v133443(VarCurr)
    <=> ( v133445(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26744,axiom,
    ! [VarCurr] :
      ( v133445(VarCurr)
    <=> ( v133446(VarCurr)
        & v133424(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26743,axiom,
    ! [VarCurr] :
      ( v133446(VarCurr)
    <=> ( v133447(VarCurr)
        & v133423(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3084,axiom,
    ! [VarCurr] :
      ( v133447(VarCurr)
    <=> ( v133448(VarCurr)
        & v133246(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26742,axiom,
    ! [VarCurr] :
      ( v133448(VarCurr)
    <=> ( v133449(VarCurr)
        & v133421(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3083,axiom,
    ! [VarCurr] :
      ( v133449(VarCurr)
    <=> ( v133419(VarCurr)
        & v133246(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26741,axiom,
    ! [VarCurr] :
      ( v133406(VarCurr)
    <=> ( v133408(VarCurr)
        | v133441(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3082,axiom,
    ! [VarCurr] :
      ( v133441(VarCurr)
    <=> ( v133428(VarCurr)
        & v133246(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26740,axiom,
    ! [VarCurr] :
      ( v133408(VarCurr)
    <=> ( v133409(VarCurr)
        | v133439(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3081,axiom,
    ! [VarCurr] :
      ( v133439(VarCurr)
    <=> ( v133414(VarCurr)
        & v133246(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26739,axiom,
    ! [VarCurr] :
      ( v133409(VarCurr)
    <=> ( v133410(VarCurr)
        | v133436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26738,axiom,
    ! [VarCurr] :
      ( v133436(VarCurr)
    <=> ( v133438(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3080,axiom,
    ! [VarCurr] :
      ( v133438(VarCurr)
    <=> ( v133432(VarCurr)
        & v133246(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26737,axiom,
    ! [VarCurr] :
      ( v133410(VarCurr)
    <=> ( v133411(VarCurr)
        | v133429(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26736,axiom,
    ! [VarCurr] :
      ( v133429(VarCurr)
    <=> ( v133431(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26735,axiom,
    ! [VarCurr] :
      ( v133431(VarCurr)
    <=> ( v133432(VarCurr)
        & v133424(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26734,axiom,
    ! [VarCurr] :
      ( v133432(VarCurr)
    <=> ( v133433(VarCurr)
        & v133423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26733,axiom,
    ! [VarCurr] :
      ( v133433(VarCurr)
    <=> ( v133434(VarCurr)
        & v133422(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26732,axiom,
    ! [VarCurr] :
      ( v133434(VarCurr)
    <=> ( v133435(VarCurr)
        & v133421(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26731,axiom,
    ! [VarCurr] :
      ( v133435(VarCurr)
    <=> ( v133246(VarCurr,bitIndex0)
        & v133420(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26730,axiom,
    ! [VarCurr] :
      ( v133411(VarCurr)
    <=> ( v133412(VarCurr)
        | v133426(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26729,axiom,
    ! [VarCurr] :
      ( v133426(VarCurr)
    <=> ( v133428(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3079,axiom,
    ! [VarCurr] :
      ( v133428(VarCurr)
    <=> ( v133415(VarCurr)
        & v133246(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26728,axiom,
    ! [VarCurr] :
      ( v133412(VarCurr)
    <=> ( v133414(VarCurr)
        & v133425(VarCurr) ) ) ).

fof(writeUnaryOperator_11077,axiom,
    ! [VarCurr] :
      ( ~ v133425(VarCurr)
    <=> v133246(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26727,axiom,
    ! [VarCurr] :
      ( v133414(VarCurr)
    <=> ( v133415(VarCurr)
        & v133424(VarCurr) ) ) ).

fof(writeUnaryOperator_11076,axiom,
    ! [VarCurr] :
      ( ~ v133424(VarCurr)
    <=> v133246(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26726,axiom,
    ! [VarCurr] :
      ( v133415(VarCurr)
    <=> ( v133416(VarCurr)
        & v133423(VarCurr) ) ) ).

fof(writeUnaryOperator_11075,axiom,
    ! [VarCurr] :
      ( ~ v133423(VarCurr)
    <=> v133246(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26725,axiom,
    ! [VarCurr] :
      ( v133416(VarCurr)
    <=> ( v133417(VarCurr)
        & v133422(VarCurr) ) ) ).

fof(writeUnaryOperator_11074,axiom,
    ! [VarCurr] :
      ( ~ v133422(VarCurr)
    <=> v133246(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26724,axiom,
    ! [VarCurr] :
      ( v133417(VarCurr)
    <=> ( v133418(VarCurr)
        & v133421(VarCurr) ) ) ).

fof(writeUnaryOperator_11073,axiom,
    ! [VarCurr] :
      ( ~ v133421(VarCurr)
    <=> v133246(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26723,axiom,
    ! [VarCurr] :
      ( v133418(VarCurr)
    <=> ( v133419(VarCurr)
        & v133420(VarCurr) ) ) ).

fof(writeUnaryOperator_11072,axiom,
    ! [VarCurr] :
      ( ~ v133420(VarCurr)
    <=> v133246(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11071,axiom,
    ! [VarCurr] :
      ( ~ v133419(VarCurr)
    <=> v133246(VarCurr,bitIndex0) ) ).

fof(addAssignment_43571,axiom,
    ! [VarCurr] :
      ( v133248(VarCurr)
    <=> v105133(VarCurr,bitIndex81) ) ).

fof(addAssignment_43570,axiom,
    ! [VarCurr] :
      ( v105133(VarCurr,bitIndex81)
    <=> v105135(VarCurr,bitIndex81) ) ).

fof(addAssignment_43569,axiom,
    ! [VarCurr] :
      ( v105135(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex696) ) ).

fof(addAssignment_43568,axiom,
    ! [VarNext] :
      ( v105137(VarNext,bitIndex696)
    <=> v133397(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_153,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133399(VarNext)
       => ( ( v133397(VarNext,bitIndex122)
          <=> v105137(VarCurr,bitIndex737) )
          & ( v133397(VarNext,bitIndex121)
          <=> v105137(VarCurr,bitIndex736) )
          & ( v133397(VarNext,bitIndex120)
          <=> v105137(VarCurr,bitIndex735) )
          & ( v133397(VarNext,bitIndex119)
          <=> v105137(VarCurr,bitIndex734) )
          & ( v133397(VarNext,bitIndex118)
          <=> v105137(VarCurr,bitIndex733) )
          & ( v133397(VarNext,bitIndex117)
          <=> v105137(VarCurr,bitIndex732) )
          & ( v133397(VarNext,bitIndex116)
          <=> v105137(VarCurr,bitIndex731) )
          & ( v133397(VarNext,bitIndex115)
          <=> v105137(VarCurr,bitIndex730) )
          & ( v133397(VarNext,bitIndex114)
          <=> v105137(VarCurr,bitIndex729) )
          & ( v133397(VarNext,bitIndex113)
          <=> v105137(VarCurr,bitIndex728) )
          & ( v133397(VarNext,bitIndex112)
          <=> v105137(VarCurr,bitIndex727) )
          & ( v133397(VarNext,bitIndex111)
          <=> v105137(VarCurr,bitIndex726) )
          & ( v133397(VarNext,bitIndex110)
          <=> v105137(VarCurr,bitIndex725) )
          & ( v133397(VarNext,bitIndex109)
          <=> v105137(VarCurr,bitIndex724) )
          & ( v133397(VarNext,bitIndex108)
          <=> v105137(VarCurr,bitIndex723) )
          & ( v133397(VarNext,bitIndex107)
          <=> v105137(VarCurr,bitIndex722) )
          & ( v133397(VarNext,bitIndex106)
          <=> v105137(VarCurr,bitIndex721) )
          & ( v133397(VarNext,bitIndex105)
          <=> v105137(VarCurr,bitIndex720) )
          & ( v133397(VarNext,bitIndex104)
          <=> v105137(VarCurr,bitIndex719) )
          & ( v133397(VarNext,bitIndex103)
          <=> v105137(VarCurr,bitIndex718) )
          & ( v133397(VarNext,bitIndex102)
          <=> v105137(VarCurr,bitIndex717) )
          & ( v133397(VarNext,bitIndex101)
          <=> v105137(VarCurr,bitIndex716) )
          & ( v133397(VarNext,bitIndex100)
          <=> v105137(VarCurr,bitIndex715) )
          & ( v133397(VarNext,bitIndex99)
          <=> v105137(VarCurr,bitIndex714) )
          & ( v133397(VarNext,bitIndex98)
          <=> v105137(VarCurr,bitIndex713) )
          & ( v133397(VarNext,bitIndex97)
          <=> v105137(VarCurr,bitIndex712) )
          & ( v133397(VarNext,bitIndex96)
          <=> v105137(VarCurr,bitIndex711) )
          & ( v133397(VarNext,bitIndex95)
          <=> v105137(VarCurr,bitIndex710) )
          & ( v133397(VarNext,bitIndex94)
          <=> v105137(VarCurr,bitIndex709) )
          & ( v133397(VarNext,bitIndex93)
          <=> v105137(VarCurr,bitIndex708) )
          & ( v133397(VarNext,bitIndex92)
          <=> v105137(VarCurr,bitIndex707) )
          & ( v133397(VarNext,bitIndex91)
          <=> v105137(VarCurr,bitIndex706) )
          & ( v133397(VarNext,bitIndex90)
          <=> v105137(VarCurr,bitIndex705) )
          & ( v133397(VarNext,bitIndex89)
          <=> v105137(VarCurr,bitIndex704) )
          & ( v133397(VarNext,bitIndex88)
          <=> v105137(VarCurr,bitIndex703) )
          & ( v133397(VarNext,bitIndex87)
          <=> v105137(VarCurr,bitIndex702) )
          & ( v133397(VarNext,bitIndex86)
          <=> v105137(VarCurr,bitIndex701) )
          & ( v133397(VarNext,bitIndex85)
          <=> v105137(VarCurr,bitIndex700) )
          & ( v133397(VarNext,bitIndex84)
          <=> v105137(VarCurr,bitIndex699) )
          & ( v133397(VarNext,bitIndex83)
          <=> v105137(VarCurr,bitIndex698) )
          & ( v133397(VarNext,bitIndex82)
          <=> v105137(VarCurr,bitIndex697) )
          & ( v133397(VarNext,bitIndex81)
          <=> v105137(VarCurr,bitIndex696) )
          & ( v133397(VarNext,bitIndex80)
          <=> v105137(VarCurr,bitIndex695) )
          & ( v133397(VarNext,bitIndex79)
          <=> v105137(VarCurr,bitIndex694) )
          & ( v133397(VarNext,bitIndex78)
          <=> v105137(VarCurr,bitIndex693) )
          & ( v133397(VarNext,bitIndex77)
          <=> v105137(VarCurr,bitIndex692) )
          & ( v133397(VarNext,bitIndex76)
          <=> v105137(VarCurr,bitIndex691) )
          & ( v133397(VarNext,bitIndex75)
          <=> v105137(VarCurr,bitIndex690) )
          & ( v133397(VarNext,bitIndex74)
          <=> v105137(VarCurr,bitIndex689) )
          & ( v133397(VarNext,bitIndex73)
          <=> v105137(VarCurr,bitIndex688) )
          & ( v133397(VarNext,bitIndex72)
          <=> v105137(VarCurr,bitIndex687) )
          & ( v133397(VarNext,bitIndex71)
          <=> v105137(VarCurr,bitIndex686) )
          & ( v133397(VarNext,bitIndex70)
          <=> v105137(VarCurr,bitIndex685) )
          & ( v133397(VarNext,bitIndex69)
          <=> v105137(VarCurr,bitIndex684) )
          & ( v133397(VarNext,bitIndex68)
          <=> v105137(VarCurr,bitIndex683) )
          & ( v133397(VarNext,bitIndex67)
          <=> v105137(VarCurr,bitIndex682) )
          & ( v133397(VarNext,bitIndex66)
          <=> v105137(VarCurr,bitIndex681) )
          & ( v133397(VarNext,bitIndex65)
          <=> v105137(VarCurr,bitIndex680) )
          & ( v133397(VarNext,bitIndex64)
          <=> v105137(VarCurr,bitIndex679) )
          & ( v133397(VarNext,bitIndex63)
          <=> v105137(VarCurr,bitIndex678) )
          & ( v133397(VarNext,bitIndex62)
          <=> v105137(VarCurr,bitIndex677) )
          & ( v133397(VarNext,bitIndex61)
          <=> v105137(VarCurr,bitIndex676) )
          & ( v133397(VarNext,bitIndex60)
          <=> v105137(VarCurr,bitIndex675) )
          & ( v133397(VarNext,bitIndex59)
          <=> v105137(VarCurr,bitIndex674) )
          & ( v133397(VarNext,bitIndex58)
          <=> v105137(VarCurr,bitIndex673) )
          & ( v133397(VarNext,bitIndex57)
          <=> v105137(VarCurr,bitIndex672) )
          & ( v133397(VarNext,bitIndex56)
          <=> v105137(VarCurr,bitIndex671) )
          & ( v133397(VarNext,bitIndex55)
          <=> v105137(VarCurr,bitIndex670) )
          & ( v133397(VarNext,bitIndex54)
          <=> v105137(VarCurr,bitIndex669) )
          & ( v133397(VarNext,bitIndex53)
          <=> v105137(VarCurr,bitIndex668) )
          & ( v133397(VarNext,bitIndex52)
          <=> v105137(VarCurr,bitIndex667) )
          & ( v133397(VarNext,bitIndex51)
          <=> v105137(VarCurr,bitIndex666) )
          & ( v133397(VarNext,bitIndex50)
          <=> v105137(VarCurr,bitIndex665) )
          & ( v133397(VarNext,bitIndex49)
          <=> v105137(VarCurr,bitIndex664) )
          & ( v133397(VarNext,bitIndex48)
          <=> v105137(VarCurr,bitIndex663) )
          & ( v133397(VarNext,bitIndex47)
          <=> v105137(VarCurr,bitIndex662) )
          & ( v133397(VarNext,bitIndex46)
          <=> v105137(VarCurr,bitIndex661) )
          & ( v133397(VarNext,bitIndex45)
          <=> v105137(VarCurr,bitIndex660) )
          & ( v133397(VarNext,bitIndex44)
          <=> v105137(VarCurr,bitIndex659) )
          & ( v133397(VarNext,bitIndex43)
          <=> v105137(VarCurr,bitIndex658) )
          & ( v133397(VarNext,bitIndex42)
          <=> v105137(VarCurr,bitIndex657) )
          & ( v133397(VarNext,bitIndex41)
          <=> v105137(VarCurr,bitIndex656) )
          & ( v133397(VarNext,bitIndex40)
          <=> v105137(VarCurr,bitIndex655) )
          & ( v133397(VarNext,bitIndex39)
          <=> v105137(VarCurr,bitIndex654) )
          & ( v133397(VarNext,bitIndex38)
          <=> v105137(VarCurr,bitIndex653) )
          & ( v133397(VarNext,bitIndex37)
          <=> v105137(VarCurr,bitIndex652) )
          & ( v133397(VarNext,bitIndex36)
          <=> v105137(VarCurr,bitIndex651) )
          & ( v133397(VarNext,bitIndex35)
          <=> v105137(VarCurr,bitIndex650) )
          & ( v133397(VarNext,bitIndex34)
          <=> v105137(VarCurr,bitIndex649) )
          & ( v133397(VarNext,bitIndex33)
          <=> v105137(VarCurr,bitIndex648) )
          & ( v133397(VarNext,bitIndex32)
          <=> v105137(VarCurr,bitIndex647) )
          & ( v133397(VarNext,bitIndex31)
          <=> v105137(VarCurr,bitIndex646) )
          & ( v133397(VarNext,bitIndex30)
          <=> v105137(VarCurr,bitIndex645) )
          & ( v133397(VarNext,bitIndex29)
          <=> v105137(VarCurr,bitIndex644) )
          & ( v133397(VarNext,bitIndex28)
          <=> v105137(VarCurr,bitIndex643) )
          & ( v133397(VarNext,bitIndex27)
          <=> v105137(VarCurr,bitIndex642) )
          & ( v133397(VarNext,bitIndex26)
          <=> v105137(VarCurr,bitIndex641) )
          & ( v133397(VarNext,bitIndex25)
          <=> v105137(VarCurr,bitIndex640) )
          & ( v133397(VarNext,bitIndex24)
          <=> v105137(VarCurr,bitIndex639) )
          & ( v133397(VarNext,bitIndex23)
          <=> v105137(VarCurr,bitIndex638) )
          & ( v133397(VarNext,bitIndex22)
          <=> v105137(VarCurr,bitIndex637) )
          & ( v133397(VarNext,bitIndex21)
          <=> v105137(VarCurr,bitIndex636) )
          & ( v133397(VarNext,bitIndex20)
          <=> v105137(VarCurr,bitIndex635) )
          & ( v133397(VarNext,bitIndex19)
          <=> v105137(VarCurr,bitIndex634) )
          & ( v133397(VarNext,bitIndex18)
          <=> v105137(VarCurr,bitIndex633) )
          & ( v133397(VarNext,bitIndex17)
          <=> v105137(VarCurr,bitIndex632) )
          & ( v133397(VarNext,bitIndex16)
          <=> v105137(VarCurr,bitIndex631) )
          & ( v133397(VarNext,bitIndex15)
          <=> v105137(VarCurr,bitIndex630) )
          & ( v133397(VarNext,bitIndex14)
          <=> v105137(VarCurr,bitIndex629) )
          & ( v133397(VarNext,bitIndex13)
          <=> v105137(VarCurr,bitIndex628) )
          & ( v133397(VarNext,bitIndex12)
          <=> v105137(VarCurr,bitIndex627) )
          & ( v133397(VarNext,bitIndex11)
          <=> v105137(VarCurr,bitIndex626) )
          & ( v133397(VarNext,bitIndex10)
          <=> v105137(VarCurr,bitIndex625) )
          & ( v133397(VarNext,bitIndex9)
          <=> v105137(VarCurr,bitIndex624) )
          & ( v133397(VarNext,bitIndex8)
          <=> v105137(VarCurr,bitIndex623) )
          & ( v133397(VarNext,bitIndex7)
          <=> v105137(VarCurr,bitIndex622) )
          & ( v133397(VarNext,bitIndex6)
          <=> v105137(VarCurr,bitIndex621) )
          & ( v133397(VarNext,bitIndex5)
          <=> v105137(VarCurr,bitIndex620) )
          & ( v133397(VarNext,bitIndex4)
          <=> v105137(VarCurr,bitIndex619) )
          & ( v133397(VarNext,bitIndex3)
          <=> v105137(VarCurr,bitIndex618) )
          & ( v133397(VarNext,bitIndex2)
          <=> v105137(VarCurr,bitIndex617) )
          & ( v133397(VarNext,bitIndex1)
          <=> v105137(VarCurr,bitIndex616) )
          & ( v133397(VarNext,bitIndex0)
          <=> v105137(VarCurr,bitIndex615) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2475,axiom,
    ! [VarNext] :
      ( v133399(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133397(VarNext,B)
          <=> v105553(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26722,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133399(VarNext)
      <=> ( v133400(VarNext)
          & v105535(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26721,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133400(VarNext)
      <=> ( v133402(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11070,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133402(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43567,axiom,
    ! [VarCurr] :
      ( v105519(VarCurr,bitIndex81)
    <=> v105524(VarCurr,bitIndex81) ) ).

fof(addAssignment_43566,axiom,
    ! [VarCurr] :
      ( v105523(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex573) ) ).

fof(addAssignment_43565,axiom,
    ! [VarCurr] :
      ( v105512(VarCurr,bitIndex81)
    <=> v105517(VarCurr,bitIndex81) ) ).

fof(addAssignment_43564,axiom,
    ! [VarCurr] :
      ( v105516(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex696) ) ).

fof(addAssignment_43563,axiom,
    ! [VarNext] :
      ( v105137(VarNext,bitIndex573)
    <=> v133389(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_152,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133391(VarNext)
       => ( ( v133389(VarNext,bitIndex122)
          <=> v105137(VarCurr,bitIndex614) )
          & ( v133389(VarNext,bitIndex121)
          <=> v105137(VarCurr,bitIndex613) )
          & ( v133389(VarNext,bitIndex120)
          <=> v105137(VarCurr,bitIndex612) )
          & ( v133389(VarNext,bitIndex119)
          <=> v105137(VarCurr,bitIndex611) )
          & ( v133389(VarNext,bitIndex118)
          <=> v105137(VarCurr,bitIndex610) )
          & ( v133389(VarNext,bitIndex117)
          <=> v105137(VarCurr,bitIndex609) )
          & ( v133389(VarNext,bitIndex116)
          <=> v105137(VarCurr,bitIndex608) )
          & ( v133389(VarNext,bitIndex115)
          <=> v105137(VarCurr,bitIndex607) )
          & ( v133389(VarNext,bitIndex114)
          <=> v105137(VarCurr,bitIndex606) )
          & ( v133389(VarNext,bitIndex113)
          <=> v105137(VarCurr,bitIndex605) )
          & ( v133389(VarNext,bitIndex112)
          <=> v105137(VarCurr,bitIndex604) )
          & ( v133389(VarNext,bitIndex111)
          <=> v105137(VarCurr,bitIndex603) )
          & ( v133389(VarNext,bitIndex110)
          <=> v105137(VarCurr,bitIndex602) )
          & ( v133389(VarNext,bitIndex109)
          <=> v105137(VarCurr,bitIndex601) )
          & ( v133389(VarNext,bitIndex108)
          <=> v105137(VarCurr,bitIndex600) )
          & ( v133389(VarNext,bitIndex107)
          <=> v105137(VarCurr,bitIndex599) )
          & ( v133389(VarNext,bitIndex106)
          <=> v105137(VarCurr,bitIndex598) )
          & ( v133389(VarNext,bitIndex105)
          <=> v105137(VarCurr,bitIndex597) )
          & ( v133389(VarNext,bitIndex104)
          <=> v105137(VarCurr,bitIndex596) )
          & ( v133389(VarNext,bitIndex103)
          <=> v105137(VarCurr,bitIndex595) )
          & ( v133389(VarNext,bitIndex102)
          <=> v105137(VarCurr,bitIndex594) )
          & ( v133389(VarNext,bitIndex101)
          <=> v105137(VarCurr,bitIndex593) )
          & ( v133389(VarNext,bitIndex100)
          <=> v105137(VarCurr,bitIndex592) )
          & ( v133389(VarNext,bitIndex99)
          <=> v105137(VarCurr,bitIndex591) )
          & ( v133389(VarNext,bitIndex98)
          <=> v105137(VarCurr,bitIndex590) )
          & ( v133389(VarNext,bitIndex97)
          <=> v105137(VarCurr,bitIndex589) )
          & ( v133389(VarNext,bitIndex96)
          <=> v105137(VarCurr,bitIndex588) )
          & ( v133389(VarNext,bitIndex95)
          <=> v105137(VarCurr,bitIndex587) )
          & ( v133389(VarNext,bitIndex94)
          <=> v105137(VarCurr,bitIndex586) )
          & ( v133389(VarNext,bitIndex93)
          <=> v105137(VarCurr,bitIndex585) )
          & ( v133389(VarNext,bitIndex92)
          <=> v105137(VarCurr,bitIndex584) )
          & ( v133389(VarNext,bitIndex91)
          <=> v105137(VarCurr,bitIndex583) )
          & ( v133389(VarNext,bitIndex90)
          <=> v105137(VarCurr,bitIndex582) )
          & ( v133389(VarNext,bitIndex89)
          <=> v105137(VarCurr,bitIndex581) )
          & ( v133389(VarNext,bitIndex88)
          <=> v105137(VarCurr,bitIndex580) )
          & ( v133389(VarNext,bitIndex87)
          <=> v105137(VarCurr,bitIndex579) )
          & ( v133389(VarNext,bitIndex86)
          <=> v105137(VarCurr,bitIndex578) )
          & ( v133389(VarNext,bitIndex85)
          <=> v105137(VarCurr,bitIndex577) )
          & ( v133389(VarNext,bitIndex84)
          <=> v105137(VarCurr,bitIndex576) )
          & ( v133389(VarNext,bitIndex83)
          <=> v105137(VarCurr,bitIndex575) )
          & ( v133389(VarNext,bitIndex82)
          <=> v105137(VarCurr,bitIndex574) )
          & ( v133389(VarNext,bitIndex81)
          <=> v105137(VarCurr,bitIndex573) )
          & ( v133389(VarNext,bitIndex80)
          <=> v105137(VarCurr,bitIndex572) )
          & ( v133389(VarNext,bitIndex79)
          <=> v105137(VarCurr,bitIndex571) )
          & ( v133389(VarNext,bitIndex78)
          <=> v105137(VarCurr,bitIndex570) )
          & ( v133389(VarNext,bitIndex77)
          <=> v105137(VarCurr,bitIndex569) )
          & ( v133389(VarNext,bitIndex76)
          <=> v105137(VarCurr,bitIndex568) )
          & ( v133389(VarNext,bitIndex75)
          <=> v105137(VarCurr,bitIndex567) )
          & ( v133389(VarNext,bitIndex74)
          <=> v105137(VarCurr,bitIndex566) )
          & ( v133389(VarNext,bitIndex73)
          <=> v105137(VarCurr,bitIndex565) )
          & ( v133389(VarNext,bitIndex72)
          <=> v105137(VarCurr,bitIndex564) )
          & ( v133389(VarNext,bitIndex71)
          <=> v105137(VarCurr,bitIndex563) )
          & ( v133389(VarNext,bitIndex70)
          <=> v105137(VarCurr,bitIndex562) )
          & ( v133389(VarNext,bitIndex69)
          <=> v105137(VarCurr,bitIndex561) )
          & ( v133389(VarNext,bitIndex68)
          <=> v105137(VarCurr,bitIndex560) )
          & ( v133389(VarNext,bitIndex67)
          <=> v105137(VarCurr,bitIndex559) )
          & ( v133389(VarNext,bitIndex66)
          <=> v105137(VarCurr,bitIndex558) )
          & ( v133389(VarNext,bitIndex65)
          <=> v105137(VarCurr,bitIndex557) )
          & ( v133389(VarNext,bitIndex64)
          <=> v105137(VarCurr,bitIndex556) )
          & ( v133389(VarNext,bitIndex63)
          <=> v105137(VarCurr,bitIndex555) )
          & ( v133389(VarNext,bitIndex62)
          <=> v105137(VarCurr,bitIndex554) )
          & ( v133389(VarNext,bitIndex61)
          <=> v105137(VarCurr,bitIndex553) )
          & ( v133389(VarNext,bitIndex60)
          <=> v105137(VarCurr,bitIndex552) )
          & ( v133389(VarNext,bitIndex59)
          <=> v105137(VarCurr,bitIndex551) )
          & ( v133389(VarNext,bitIndex58)
          <=> v105137(VarCurr,bitIndex550) )
          & ( v133389(VarNext,bitIndex57)
          <=> v105137(VarCurr,bitIndex549) )
          & ( v133389(VarNext,bitIndex56)
          <=> v105137(VarCurr,bitIndex548) )
          & ( v133389(VarNext,bitIndex55)
          <=> v105137(VarCurr,bitIndex547) )
          & ( v133389(VarNext,bitIndex54)
          <=> v105137(VarCurr,bitIndex546) )
          & ( v133389(VarNext,bitIndex53)
          <=> v105137(VarCurr,bitIndex545) )
          & ( v133389(VarNext,bitIndex52)
          <=> v105137(VarCurr,bitIndex544) )
          & ( v133389(VarNext,bitIndex51)
          <=> v105137(VarCurr,bitIndex543) )
          & ( v133389(VarNext,bitIndex50)
          <=> v105137(VarCurr,bitIndex542) )
          & ( v133389(VarNext,bitIndex49)
          <=> v105137(VarCurr,bitIndex541) )
          & ( v133389(VarNext,bitIndex48)
          <=> v105137(VarCurr,bitIndex540) )
          & ( v133389(VarNext,bitIndex47)
          <=> v105137(VarCurr,bitIndex539) )
          & ( v133389(VarNext,bitIndex46)
          <=> v105137(VarCurr,bitIndex538) )
          & ( v133389(VarNext,bitIndex45)
          <=> v105137(VarCurr,bitIndex537) )
          & ( v133389(VarNext,bitIndex44)
          <=> v105137(VarCurr,bitIndex536) )
          & ( v133389(VarNext,bitIndex43)
          <=> v105137(VarCurr,bitIndex535) )
          & ( v133389(VarNext,bitIndex42)
          <=> v105137(VarCurr,bitIndex534) )
          & ( v133389(VarNext,bitIndex41)
          <=> v105137(VarCurr,bitIndex533) )
          & ( v133389(VarNext,bitIndex40)
          <=> v105137(VarCurr,bitIndex532) )
          & ( v133389(VarNext,bitIndex39)
          <=> v105137(VarCurr,bitIndex531) )
          & ( v133389(VarNext,bitIndex38)
          <=> v105137(VarCurr,bitIndex530) )
          & ( v133389(VarNext,bitIndex37)
          <=> v105137(VarCurr,bitIndex529) )
          & ( v133389(VarNext,bitIndex36)
          <=> v105137(VarCurr,bitIndex528) )
          & ( v133389(VarNext,bitIndex35)
          <=> v105137(VarCurr,bitIndex527) )
          & ( v133389(VarNext,bitIndex34)
          <=> v105137(VarCurr,bitIndex526) )
          & ( v133389(VarNext,bitIndex33)
          <=> v105137(VarCurr,bitIndex525) )
          & ( v133389(VarNext,bitIndex32)
          <=> v105137(VarCurr,bitIndex524) )
          & ( v133389(VarNext,bitIndex31)
          <=> v105137(VarCurr,bitIndex523) )
          & ( v133389(VarNext,bitIndex30)
          <=> v105137(VarCurr,bitIndex522) )
          & ( v133389(VarNext,bitIndex29)
          <=> v105137(VarCurr,bitIndex521) )
          & ( v133389(VarNext,bitIndex28)
          <=> v105137(VarCurr,bitIndex520) )
          & ( v133389(VarNext,bitIndex27)
          <=> v105137(VarCurr,bitIndex519) )
          & ( v133389(VarNext,bitIndex26)
          <=> v105137(VarCurr,bitIndex518) )
          & ( v133389(VarNext,bitIndex25)
          <=> v105137(VarCurr,bitIndex517) )
          & ( v133389(VarNext,bitIndex24)
          <=> v105137(VarCurr,bitIndex516) )
          & ( v133389(VarNext,bitIndex23)
          <=> v105137(VarCurr,bitIndex515) )
          & ( v133389(VarNext,bitIndex22)
          <=> v105137(VarCurr,bitIndex514) )
          & ( v133389(VarNext,bitIndex21)
          <=> v105137(VarCurr,bitIndex513) )
          & ( v133389(VarNext,bitIndex20)
          <=> v105137(VarCurr,bitIndex512) )
          & ( v133389(VarNext,bitIndex19)
          <=> v105137(VarCurr,bitIndex511) )
          & ( v133389(VarNext,bitIndex18)
          <=> v105137(VarCurr,bitIndex510) )
          & ( v133389(VarNext,bitIndex17)
          <=> v105137(VarCurr,bitIndex509) )
          & ( v133389(VarNext,bitIndex16)
          <=> v105137(VarCurr,bitIndex508) )
          & ( v133389(VarNext,bitIndex15)
          <=> v105137(VarCurr,bitIndex507) )
          & ( v133389(VarNext,bitIndex14)
          <=> v105137(VarCurr,bitIndex506) )
          & ( v133389(VarNext,bitIndex13)
          <=> v105137(VarCurr,bitIndex505) )
          & ( v133389(VarNext,bitIndex12)
          <=> v105137(VarCurr,bitIndex504) )
          & ( v133389(VarNext,bitIndex11)
          <=> v105137(VarCurr,bitIndex503) )
          & ( v133389(VarNext,bitIndex10)
          <=> v105137(VarCurr,bitIndex502) )
          & ( v133389(VarNext,bitIndex9)
          <=> v105137(VarCurr,bitIndex501) )
          & ( v133389(VarNext,bitIndex8)
          <=> v105137(VarCurr,bitIndex500) )
          & ( v133389(VarNext,bitIndex7)
          <=> v105137(VarCurr,bitIndex499) )
          & ( v133389(VarNext,bitIndex6)
          <=> v105137(VarCurr,bitIndex498) )
          & ( v133389(VarNext,bitIndex5)
          <=> v105137(VarCurr,bitIndex497) )
          & ( v133389(VarNext,bitIndex4)
          <=> v105137(VarCurr,bitIndex496) )
          & ( v133389(VarNext,bitIndex3)
          <=> v105137(VarCurr,bitIndex495) )
          & ( v133389(VarNext,bitIndex2)
          <=> v105137(VarCurr,bitIndex494) )
          & ( v133389(VarNext,bitIndex1)
          <=> v105137(VarCurr,bitIndex493) )
          & ( v133389(VarNext,bitIndex0)
          <=> v105137(VarCurr,bitIndex492) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2474,axiom,
    ! [VarNext] :
      ( v133391(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133389(VarNext,B)
          <=> v105507(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26720,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133391(VarNext)
      <=> ( v133392(VarNext)
          & v105489(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26719,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133392(VarNext)
      <=> ( v133394(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11069,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133394(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43562,axiom,
    ! [VarCurr] :
      ( v105473(VarCurr,bitIndex81)
    <=> v105478(VarCurr,bitIndex81) ) ).

fof(addAssignment_43561,axiom,
    ! [VarCurr] :
      ( v105477(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex450) ) ).

fof(addAssignment_43560,axiom,
    ! [VarCurr] :
      ( v105466(VarCurr,bitIndex81)
    <=> v105471(VarCurr,bitIndex81) ) ).

fof(addAssignment_43559,axiom,
    ! [VarCurr] :
      ( v105470(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex573) ) ).

fof(addAssignment_43558,axiom,
    ! [VarNext] :
      ( v105137(VarNext,bitIndex450)
    <=> v133381(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_151,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133383(VarNext)
       => ( ( v133381(VarNext,bitIndex122)
          <=> v105137(VarCurr,bitIndex491) )
          & ( v133381(VarNext,bitIndex121)
          <=> v105137(VarCurr,bitIndex490) )
          & ( v133381(VarNext,bitIndex120)
          <=> v105137(VarCurr,bitIndex489) )
          & ( v133381(VarNext,bitIndex119)
          <=> v105137(VarCurr,bitIndex488) )
          & ( v133381(VarNext,bitIndex118)
          <=> v105137(VarCurr,bitIndex487) )
          & ( v133381(VarNext,bitIndex117)
          <=> v105137(VarCurr,bitIndex486) )
          & ( v133381(VarNext,bitIndex116)
          <=> v105137(VarCurr,bitIndex485) )
          & ( v133381(VarNext,bitIndex115)
          <=> v105137(VarCurr,bitIndex484) )
          & ( v133381(VarNext,bitIndex114)
          <=> v105137(VarCurr,bitIndex483) )
          & ( v133381(VarNext,bitIndex113)
          <=> v105137(VarCurr,bitIndex482) )
          & ( v133381(VarNext,bitIndex112)
          <=> v105137(VarCurr,bitIndex481) )
          & ( v133381(VarNext,bitIndex111)
          <=> v105137(VarCurr,bitIndex480) )
          & ( v133381(VarNext,bitIndex110)
          <=> v105137(VarCurr,bitIndex479) )
          & ( v133381(VarNext,bitIndex109)
          <=> v105137(VarCurr,bitIndex478) )
          & ( v133381(VarNext,bitIndex108)
          <=> v105137(VarCurr,bitIndex477) )
          & ( v133381(VarNext,bitIndex107)
          <=> v105137(VarCurr,bitIndex476) )
          & ( v133381(VarNext,bitIndex106)
          <=> v105137(VarCurr,bitIndex475) )
          & ( v133381(VarNext,bitIndex105)
          <=> v105137(VarCurr,bitIndex474) )
          & ( v133381(VarNext,bitIndex104)
          <=> v105137(VarCurr,bitIndex473) )
          & ( v133381(VarNext,bitIndex103)
          <=> v105137(VarCurr,bitIndex472) )
          & ( v133381(VarNext,bitIndex102)
          <=> v105137(VarCurr,bitIndex471) )
          & ( v133381(VarNext,bitIndex101)
          <=> v105137(VarCurr,bitIndex470) )
          & ( v133381(VarNext,bitIndex100)
          <=> v105137(VarCurr,bitIndex469) )
          & ( v133381(VarNext,bitIndex99)
          <=> v105137(VarCurr,bitIndex468) )
          & ( v133381(VarNext,bitIndex98)
          <=> v105137(VarCurr,bitIndex467) )
          & ( v133381(VarNext,bitIndex97)
          <=> v105137(VarCurr,bitIndex466) )
          & ( v133381(VarNext,bitIndex96)
          <=> v105137(VarCurr,bitIndex465) )
          & ( v133381(VarNext,bitIndex95)
          <=> v105137(VarCurr,bitIndex464) )
          & ( v133381(VarNext,bitIndex94)
          <=> v105137(VarCurr,bitIndex463) )
          & ( v133381(VarNext,bitIndex93)
          <=> v105137(VarCurr,bitIndex462) )
          & ( v133381(VarNext,bitIndex92)
          <=> v105137(VarCurr,bitIndex461) )
          & ( v133381(VarNext,bitIndex91)
          <=> v105137(VarCurr,bitIndex460) )
          & ( v133381(VarNext,bitIndex90)
          <=> v105137(VarCurr,bitIndex459) )
          & ( v133381(VarNext,bitIndex89)
          <=> v105137(VarCurr,bitIndex458) )
          & ( v133381(VarNext,bitIndex88)
          <=> v105137(VarCurr,bitIndex457) )
          & ( v133381(VarNext,bitIndex87)
          <=> v105137(VarCurr,bitIndex456) )
          & ( v133381(VarNext,bitIndex86)
          <=> v105137(VarCurr,bitIndex455) )
          & ( v133381(VarNext,bitIndex85)
          <=> v105137(VarCurr,bitIndex454) )
          & ( v133381(VarNext,bitIndex84)
          <=> v105137(VarCurr,bitIndex453) )
          & ( v133381(VarNext,bitIndex83)
          <=> v105137(VarCurr,bitIndex452) )
          & ( v133381(VarNext,bitIndex82)
          <=> v105137(VarCurr,bitIndex451) )
          & ( v133381(VarNext,bitIndex81)
          <=> v105137(VarCurr,bitIndex450) )
          & ( v133381(VarNext,bitIndex80)
          <=> v105137(VarCurr,bitIndex449) )
          & ( v133381(VarNext,bitIndex79)
          <=> v105137(VarCurr,bitIndex448) )
          & ( v133381(VarNext,bitIndex78)
          <=> v105137(VarCurr,bitIndex447) )
          & ( v133381(VarNext,bitIndex77)
          <=> v105137(VarCurr,bitIndex446) )
          & ( v133381(VarNext,bitIndex76)
          <=> v105137(VarCurr,bitIndex445) )
          & ( v133381(VarNext,bitIndex75)
          <=> v105137(VarCurr,bitIndex444) )
          & ( v133381(VarNext,bitIndex74)
          <=> v105137(VarCurr,bitIndex443) )
          & ( v133381(VarNext,bitIndex73)
          <=> v105137(VarCurr,bitIndex442) )
          & ( v133381(VarNext,bitIndex72)
          <=> v105137(VarCurr,bitIndex441) )
          & ( v133381(VarNext,bitIndex71)
          <=> v105137(VarCurr,bitIndex440) )
          & ( v133381(VarNext,bitIndex70)
          <=> v105137(VarCurr,bitIndex439) )
          & ( v133381(VarNext,bitIndex69)
          <=> v105137(VarCurr,bitIndex438) )
          & ( v133381(VarNext,bitIndex68)
          <=> v105137(VarCurr,bitIndex437) )
          & ( v133381(VarNext,bitIndex67)
          <=> v105137(VarCurr,bitIndex436) )
          & ( v133381(VarNext,bitIndex66)
          <=> v105137(VarCurr,bitIndex435) )
          & ( v133381(VarNext,bitIndex65)
          <=> v105137(VarCurr,bitIndex434) )
          & ( v133381(VarNext,bitIndex64)
          <=> v105137(VarCurr,bitIndex433) )
          & ( v133381(VarNext,bitIndex63)
          <=> v105137(VarCurr,bitIndex432) )
          & ( v133381(VarNext,bitIndex62)
          <=> v105137(VarCurr,bitIndex431) )
          & ( v133381(VarNext,bitIndex61)
          <=> v105137(VarCurr,bitIndex430) )
          & ( v133381(VarNext,bitIndex60)
          <=> v105137(VarCurr,bitIndex429) )
          & ( v133381(VarNext,bitIndex59)
          <=> v105137(VarCurr,bitIndex428) )
          & ( v133381(VarNext,bitIndex58)
          <=> v105137(VarCurr,bitIndex427) )
          & ( v133381(VarNext,bitIndex57)
          <=> v105137(VarCurr,bitIndex426) )
          & ( v133381(VarNext,bitIndex56)
          <=> v105137(VarCurr,bitIndex425) )
          & ( v133381(VarNext,bitIndex55)
          <=> v105137(VarCurr,bitIndex424) )
          & ( v133381(VarNext,bitIndex54)
          <=> v105137(VarCurr,bitIndex423) )
          & ( v133381(VarNext,bitIndex53)
          <=> v105137(VarCurr,bitIndex422) )
          & ( v133381(VarNext,bitIndex52)
          <=> v105137(VarCurr,bitIndex421) )
          & ( v133381(VarNext,bitIndex51)
          <=> v105137(VarCurr,bitIndex420) )
          & ( v133381(VarNext,bitIndex50)
          <=> v105137(VarCurr,bitIndex419) )
          & ( v133381(VarNext,bitIndex49)
          <=> v105137(VarCurr,bitIndex418) )
          & ( v133381(VarNext,bitIndex48)
          <=> v105137(VarCurr,bitIndex417) )
          & ( v133381(VarNext,bitIndex47)
          <=> v105137(VarCurr,bitIndex416) )
          & ( v133381(VarNext,bitIndex46)
          <=> v105137(VarCurr,bitIndex415) )
          & ( v133381(VarNext,bitIndex45)
          <=> v105137(VarCurr,bitIndex414) )
          & ( v133381(VarNext,bitIndex44)
          <=> v105137(VarCurr,bitIndex413) )
          & ( v133381(VarNext,bitIndex43)
          <=> v105137(VarCurr,bitIndex412) )
          & ( v133381(VarNext,bitIndex42)
          <=> v105137(VarCurr,bitIndex411) )
          & ( v133381(VarNext,bitIndex41)
          <=> v105137(VarCurr,bitIndex410) )
          & ( v133381(VarNext,bitIndex40)
          <=> v105137(VarCurr,bitIndex409) )
          & ( v133381(VarNext,bitIndex39)
          <=> v105137(VarCurr,bitIndex408) )
          & ( v133381(VarNext,bitIndex38)
          <=> v105137(VarCurr,bitIndex407) )
          & ( v133381(VarNext,bitIndex37)
          <=> v105137(VarCurr,bitIndex406) )
          & ( v133381(VarNext,bitIndex36)
          <=> v105137(VarCurr,bitIndex405) )
          & ( v133381(VarNext,bitIndex35)
          <=> v105137(VarCurr,bitIndex404) )
          & ( v133381(VarNext,bitIndex34)
          <=> v105137(VarCurr,bitIndex403) )
          & ( v133381(VarNext,bitIndex33)
          <=> v105137(VarCurr,bitIndex402) )
          & ( v133381(VarNext,bitIndex32)
          <=> v105137(VarCurr,bitIndex401) )
          & ( v133381(VarNext,bitIndex31)
          <=> v105137(VarCurr,bitIndex400) )
          & ( v133381(VarNext,bitIndex30)
          <=> v105137(VarCurr,bitIndex399) )
          & ( v133381(VarNext,bitIndex29)
          <=> v105137(VarCurr,bitIndex398) )
          & ( v133381(VarNext,bitIndex28)
          <=> v105137(VarCurr,bitIndex397) )
          & ( v133381(VarNext,bitIndex27)
          <=> v105137(VarCurr,bitIndex396) )
          & ( v133381(VarNext,bitIndex26)
          <=> v105137(VarCurr,bitIndex395) )
          & ( v133381(VarNext,bitIndex25)
          <=> v105137(VarCurr,bitIndex394) )
          & ( v133381(VarNext,bitIndex24)
          <=> v105137(VarCurr,bitIndex393) )
          & ( v133381(VarNext,bitIndex23)
          <=> v105137(VarCurr,bitIndex392) )
          & ( v133381(VarNext,bitIndex22)
          <=> v105137(VarCurr,bitIndex391) )
          & ( v133381(VarNext,bitIndex21)
          <=> v105137(VarCurr,bitIndex390) )
          & ( v133381(VarNext,bitIndex20)
          <=> v105137(VarCurr,bitIndex389) )
          & ( v133381(VarNext,bitIndex19)
          <=> v105137(VarCurr,bitIndex388) )
          & ( v133381(VarNext,bitIndex18)
          <=> v105137(VarCurr,bitIndex387) )
          & ( v133381(VarNext,bitIndex17)
          <=> v105137(VarCurr,bitIndex386) )
          & ( v133381(VarNext,bitIndex16)
          <=> v105137(VarCurr,bitIndex385) )
          & ( v133381(VarNext,bitIndex15)
          <=> v105137(VarCurr,bitIndex384) )
          & ( v133381(VarNext,bitIndex14)
          <=> v105137(VarCurr,bitIndex383) )
          & ( v133381(VarNext,bitIndex13)
          <=> v105137(VarCurr,bitIndex382) )
          & ( v133381(VarNext,bitIndex12)
          <=> v105137(VarCurr,bitIndex381) )
          & ( v133381(VarNext,bitIndex11)
          <=> v105137(VarCurr,bitIndex380) )
          & ( v133381(VarNext,bitIndex10)
          <=> v105137(VarCurr,bitIndex379) )
          & ( v133381(VarNext,bitIndex9)
          <=> v105137(VarCurr,bitIndex378) )
          & ( v133381(VarNext,bitIndex8)
          <=> v105137(VarCurr,bitIndex377) )
          & ( v133381(VarNext,bitIndex7)
          <=> v105137(VarCurr,bitIndex376) )
          & ( v133381(VarNext,bitIndex6)
          <=> v105137(VarCurr,bitIndex375) )
          & ( v133381(VarNext,bitIndex5)
          <=> v105137(VarCurr,bitIndex374) )
          & ( v133381(VarNext,bitIndex4)
          <=> v105137(VarCurr,bitIndex373) )
          & ( v133381(VarNext,bitIndex3)
          <=> v105137(VarCurr,bitIndex372) )
          & ( v133381(VarNext,bitIndex2)
          <=> v105137(VarCurr,bitIndex371) )
          & ( v133381(VarNext,bitIndex1)
          <=> v105137(VarCurr,bitIndex370) )
          & ( v133381(VarNext,bitIndex0)
          <=> v105137(VarCurr,bitIndex369) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2473,axiom,
    ! [VarNext] :
      ( v133383(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133381(VarNext,B)
          <=> v105461(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26718,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133383(VarNext)
      <=> ( v133384(VarNext)
          & v105443(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26717,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133384(VarNext)
      <=> ( v133386(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11068,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133386(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43557,axiom,
    ! [VarCurr] :
      ( v105427(VarCurr,bitIndex81)
    <=> v105432(VarCurr,bitIndex81) ) ).

fof(addAssignment_43556,axiom,
    ! [VarCurr] :
      ( v105431(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex327) ) ).

fof(addAssignment_43555,axiom,
    ! [VarCurr] :
      ( v105420(VarCurr,bitIndex81)
    <=> v105425(VarCurr,bitIndex81) ) ).

fof(addAssignment_43554,axiom,
    ! [VarCurr] :
      ( v105424(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex450) ) ).

fof(addAssignment_43553,axiom,
    ! [VarNext] :
      ( v105137(VarNext,bitIndex327)
    <=> v133373(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133375(VarNext)
       => ( ( v133373(VarNext,bitIndex122)
          <=> v105137(VarCurr,bitIndex368) )
          & ( v133373(VarNext,bitIndex121)
          <=> v105137(VarCurr,bitIndex367) )
          & ( v133373(VarNext,bitIndex120)
          <=> v105137(VarCurr,bitIndex366) )
          & ( v133373(VarNext,bitIndex119)
          <=> v105137(VarCurr,bitIndex365) )
          & ( v133373(VarNext,bitIndex118)
          <=> v105137(VarCurr,bitIndex364) )
          & ( v133373(VarNext,bitIndex117)
          <=> v105137(VarCurr,bitIndex363) )
          & ( v133373(VarNext,bitIndex116)
          <=> v105137(VarCurr,bitIndex362) )
          & ( v133373(VarNext,bitIndex115)
          <=> v105137(VarCurr,bitIndex361) )
          & ( v133373(VarNext,bitIndex114)
          <=> v105137(VarCurr,bitIndex360) )
          & ( v133373(VarNext,bitIndex113)
          <=> v105137(VarCurr,bitIndex359) )
          & ( v133373(VarNext,bitIndex112)
          <=> v105137(VarCurr,bitIndex358) )
          & ( v133373(VarNext,bitIndex111)
          <=> v105137(VarCurr,bitIndex357) )
          & ( v133373(VarNext,bitIndex110)
          <=> v105137(VarCurr,bitIndex356) )
          & ( v133373(VarNext,bitIndex109)
          <=> v105137(VarCurr,bitIndex355) )
          & ( v133373(VarNext,bitIndex108)
          <=> v105137(VarCurr,bitIndex354) )
          & ( v133373(VarNext,bitIndex107)
          <=> v105137(VarCurr,bitIndex353) )
          & ( v133373(VarNext,bitIndex106)
          <=> v105137(VarCurr,bitIndex352) )
          & ( v133373(VarNext,bitIndex105)
          <=> v105137(VarCurr,bitIndex351) )
          & ( v133373(VarNext,bitIndex104)
          <=> v105137(VarCurr,bitIndex350) )
          & ( v133373(VarNext,bitIndex103)
          <=> v105137(VarCurr,bitIndex349) )
          & ( v133373(VarNext,bitIndex102)
          <=> v105137(VarCurr,bitIndex348) )
          & ( v133373(VarNext,bitIndex101)
          <=> v105137(VarCurr,bitIndex347) )
          & ( v133373(VarNext,bitIndex100)
          <=> v105137(VarCurr,bitIndex346) )
          & ( v133373(VarNext,bitIndex99)
          <=> v105137(VarCurr,bitIndex345) )
          & ( v133373(VarNext,bitIndex98)
          <=> v105137(VarCurr,bitIndex344) )
          & ( v133373(VarNext,bitIndex97)
          <=> v105137(VarCurr,bitIndex343) )
          & ( v133373(VarNext,bitIndex96)
          <=> v105137(VarCurr,bitIndex342) )
          & ( v133373(VarNext,bitIndex95)
          <=> v105137(VarCurr,bitIndex341) )
          & ( v133373(VarNext,bitIndex94)
          <=> v105137(VarCurr,bitIndex340) )
          & ( v133373(VarNext,bitIndex93)
          <=> v105137(VarCurr,bitIndex339) )
          & ( v133373(VarNext,bitIndex92)
          <=> v105137(VarCurr,bitIndex338) )
          & ( v133373(VarNext,bitIndex91)
          <=> v105137(VarCurr,bitIndex337) )
          & ( v133373(VarNext,bitIndex90)
          <=> v105137(VarCurr,bitIndex336) )
          & ( v133373(VarNext,bitIndex89)
          <=> v105137(VarCurr,bitIndex335) )
          & ( v133373(VarNext,bitIndex88)
          <=> v105137(VarCurr,bitIndex334) )
          & ( v133373(VarNext,bitIndex87)
          <=> v105137(VarCurr,bitIndex333) )
          & ( v133373(VarNext,bitIndex86)
          <=> v105137(VarCurr,bitIndex332) )
          & ( v133373(VarNext,bitIndex85)
          <=> v105137(VarCurr,bitIndex331) )
          & ( v133373(VarNext,bitIndex84)
          <=> v105137(VarCurr,bitIndex330) )
          & ( v133373(VarNext,bitIndex83)
          <=> v105137(VarCurr,bitIndex329) )
          & ( v133373(VarNext,bitIndex82)
          <=> v105137(VarCurr,bitIndex328) )
          & ( v133373(VarNext,bitIndex81)
          <=> v105137(VarCurr,bitIndex327) )
          & ( v133373(VarNext,bitIndex80)
          <=> v105137(VarCurr,bitIndex326) )
          & ( v133373(VarNext,bitIndex79)
          <=> v105137(VarCurr,bitIndex325) )
          & ( v133373(VarNext,bitIndex78)
          <=> v105137(VarCurr,bitIndex324) )
          & ( v133373(VarNext,bitIndex77)
          <=> v105137(VarCurr,bitIndex323) )
          & ( v133373(VarNext,bitIndex76)
          <=> v105137(VarCurr,bitIndex322) )
          & ( v133373(VarNext,bitIndex75)
          <=> v105137(VarCurr,bitIndex321) )
          & ( v133373(VarNext,bitIndex74)
          <=> v105137(VarCurr,bitIndex320) )
          & ( v133373(VarNext,bitIndex73)
          <=> v105137(VarCurr,bitIndex319) )
          & ( v133373(VarNext,bitIndex72)
          <=> v105137(VarCurr,bitIndex318) )
          & ( v133373(VarNext,bitIndex71)
          <=> v105137(VarCurr,bitIndex317) )
          & ( v133373(VarNext,bitIndex70)
          <=> v105137(VarCurr,bitIndex316) )
          & ( v133373(VarNext,bitIndex69)
          <=> v105137(VarCurr,bitIndex315) )
          & ( v133373(VarNext,bitIndex68)
          <=> v105137(VarCurr,bitIndex314) )
          & ( v133373(VarNext,bitIndex67)
          <=> v105137(VarCurr,bitIndex313) )
          & ( v133373(VarNext,bitIndex66)
          <=> v105137(VarCurr,bitIndex312) )
          & ( v133373(VarNext,bitIndex65)
          <=> v105137(VarCurr,bitIndex311) )
          & ( v133373(VarNext,bitIndex64)
          <=> v105137(VarCurr,bitIndex310) )
          & ( v133373(VarNext,bitIndex63)
          <=> v105137(VarCurr,bitIndex309) )
          & ( v133373(VarNext,bitIndex62)
          <=> v105137(VarCurr,bitIndex308) )
          & ( v133373(VarNext,bitIndex61)
          <=> v105137(VarCurr,bitIndex307) )
          & ( v133373(VarNext,bitIndex60)
          <=> v105137(VarCurr,bitIndex306) )
          & ( v133373(VarNext,bitIndex59)
          <=> v105137(VarCurr,bitIndex305) )
          & ( v133373(VarNext,bitIndex58)
          <=> v105137(VarCurr,bitIndex304) )
          & ( v133373(VarNext,bitIndex57)
          <=> v105137(VarCurr,bitIndex303) )
          & ( v133373(VarNext,bitIndex56)
          <=> v105137(VarCurr,bitIndex302) )
          & ( v133373(VarNext,bitIndex55)
          <=> v105137(VarCurr,bitIndex301) )
          & ( v133373(VarNext,bitIndex54)
          <=> v105137(VarCurr,bitIndex300) )
          & ( v133373(VarNext,bitIndex53)
          <=> v105137(VarCurr,bitIndex299) )
          & ( v133373(VarNext,bitIndex52)
          <=> v105137(VarCurr,bitIndex298) )
          & ( v133373(VarNext,bitIndex51)
          <=> v105137(VarCurr,bitIndex297) )
          & ( v133373(VarNext,bitIndex50)
          <=> v105137(VarCurr,bitIndex296) )
          & ( v133373(VarNext,bitIndex49)
          <=> v105137(VarCurr,bitIndex295) )
          & ( v133373(VarNext,bitIndex48)
          <=> v105137(VarCurr,bitIndex294) )
          & ( v133373(VarNext,bitIndex47)
          <=> v105137(VarCurr,bitIndex293) )
          & ( v133373(VarNext,bitIndex46)
          <=> v105137(VarCurr,bitIndex292) )
          & ( v133373(VarNext,bitIndex45)
          <=> v105137(VarCurr,bitIndex291) )
          & ( v133373(VarNext,bitIndex44)
          <=> v105137(VarCurr,bitIndex290) )
          & ( v133373(VarNext,bitIndex43)
          <=> v105137(VarCurr,bitIndex289) )
          & ( v133373(VarNext,bitIndex42)
          <=> v105137(VarCurr,bitIndex288) )
          & ( v133373(VarNext,bitIndex41)
          <=> v105137(VarCurr,bitIndex287) )
          & ( v133373(VarNext,bitIndex40)
          <=> v105137(VarCurr,bitIndex286) )
          & ( v133373(VarNext,bitIndex39)
          <=> v105137(VarCurr,bitIndex285) )
          & ( v133373(VarNext,bitIndex38)
          <=> v105137(VarCurr,bitIndex284) )
          & ( v133373(VarNext,bitIndex37)
          <=> v105137(VarCurr,bitIndex283) )
          & ( v133373(VarNext,bitIndex36)
          <=> v105137(VarCurr,bitIndex282) )
          & ( v133373(VarNext,bitIndex35)
          <=> v105137(VarCurr,bitIndex281) )
          & ( v133373(VarNext,bitIndex34)
          <=> v105137(VarCurr,bitIndex280) )
          & ( v133373(VarNext,bitIndex33)
          <=> v105137(VarCurr,bitIndex279) )
          & ( v133373(VarNext,bitIndex32)
          <=> v105137(VarCurr,bitIndex278) )
          & ( v133373(VarNext,bitIndex31)
          <=> v105137(VarCurr,bitIndex277) )
          & ( v133373(VarNext,bitIndex30)
          <=> v105137(VarCurr,bitIndex276) )
          & ( v133373(VarNext,bitIndex29)
          <=> v105137(VarCurr,bitIndex275) )
          & ( v133373(VarNext,bitIndex28)
          <=> v105137(VarCurr,bitIndex274) )
          & ( v133373(VarNext,bitIndex27)
          <=> v105137(VarCurr,bitIndex273) )
          & ( v133373(VarNext,bitIndex26)
          <=> v105137(VarCurr,bitIndex272) )
          & ( v133373(VarNext,bitIndex25)
          <=> v105137(VarCurr,bitIndex271) )
          & ( v133373(VarNext,bitIndex24)
          <=> v105137(VarCurr,bitIndex270) )
          & ( v133373(VarNext,bitIndex23)
          <=> v105137(VarCurr,bitIndex269) )
          & ( v133373(VarNext,bitIndex22)
          <=> v105137(VarCurr,bitIndex268) )
          & ( v133373(VarNext,bitIndex21)
          <=> v105137(VarCurr,bitIndex267) )
          & ( v133373(VarNext,bitIndex20)
          <=> v105137(VarCurr,bitIndex266) )
          & ( v133373(VarNext,bitIndex19)
          <=> v105137(VarCurr,bitIndex265) )
          & ( v133373(VarNext,bitIndex18)
          <=> v105137(VarCurr,bitIndex264) )
          & ( v133373(VarNext,bitIndex17)
          <=> v105137(VarCurr,bitIndex263) )
          & ( v133373(VarNext,bitIndex16)
          <=> v105137(VarCurr,bitIndex262) )
          & ( v133373(VarNext,bitIndex15)
          <=> v105137(VarCurr,bitIndex261) )
          & ( v133373(VarNext,bitIndex14)
          <=> v105137(VarCurr,bitIndex260) )
          & ( v133373(VarNext,bitIndex13)
          <=> v105137(VarCurr,bitIndex259) )
          & ( v133373(VarNext,bitIndex12)
          <=> v105137(VarCurr,bitIndex258) )
          & ( v133373(VarNext,bitIndex11)
          <=> v105137(VarCurr,bitIndex257) )
          & ( v133373(VarNext,bitIndex10)
          <=> v105137(VarCurr,bitIndex256) )
          & ( v133373(VarNext,bitIndex9)
          <=> v105137(VarCurr,bitIndex255) )
          & ( v133373(VarNext,bitIndex8)
          <=> v105137(VarCurr,bitIndex254) )
          & ( v133373(VarNext,bitIndex7)
          <=> v105137(VarCurr,bitIndex253) )
          & ( v133373(VarNext,bitIndex6)
          <=> v105137(VarCurr,bitIndex252) )
          & ( v133373(VarNext,bitIndex5)
          <=> v105137(VarCurr,bitIndex251) )
          & ( v133373(VarNext,bitIndex4)
          <=> v105137(VarCurr,bitIndex250) )
          & ( v133373(VarNext,bitIndex3)
          <=> v105137(VarCurr,bitIndex249) )
          & ( v133373(VarNext,bitIndex2)
          <=> v105137(VarCurr,bitIndex248) )
          & ( v133373(VarNext,bitIndex1)
          <=> v105137(VarCurr,bitIndex247) )
          & ( v133373(VarNext,bitIndex0)
          <=> v105137(VarCurr,bitIndex246) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2472,axiom,
    ! [VarNext] :
      ( v133375(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133373(VarNext,B)
          <=> v105415(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26716,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133375(VarNext)
      <=> ( v133376(VarNext)
          & v105397(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26715,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133376(VarNext)
      <=> ( v133378(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11067,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133378(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43552,axiom,
    ! [VarCurr] :
      ( v105381(VarCurr,bitIndex81)
    <=> v105386(VarCurr,bitIndex81) ) ).

fof(addAssignment_43551,axiom,
    ! [VarCurr] :
      ( v105385(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex204) ) ).

fof(addAssignment_43550,axiom,
    ! [VarCurr] :
      ( v105374(VarCurr,bitIndex81)
    <=> v105379(VarCurr,bitIndex81) ) ).

fof(addAssignment_43549,axiom,
    ! [VarCurr] :
      ( v105378(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex327) ) ).

fof(addAssignment_43548,axiom,
    ! [VarNext] :
      ( v105137(VarNext,bitIndex204)
    <=> v133365(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133367(VarNext)
       => ( ( v133365(VarNext,bitIndex122)
          <=> v105137(VarCurr,bitIndex245) )
          & ( v133365(VarNext,bitIndex121)
          <=> v105137(VarCurr,bitIndex244) )
          & ( v133365(VarNext,bitIndex120)
          <=> v105137(VarCurr,bitIndex243) )
          & ( v133365(VarNext,bitIndex119)
          <=> v105137(VarCurr,bitIndex242) )
          & ( v133365(VarNext,bitIndex118)
          <=> v105137(VarCurr,bitIndex241) )
          & ( v133365(VarNext,bitIndex117)
          <=> v105137(VarCurr,bitIndex240) )
          & ( v133365(VarNext,bitIndex116)
          <=> v105137(VarCurr,bitIndex239) )
          & ( v133365(VarNext,bitIndex115)
          <=> v105137(VarCurr,bitIndex238) )
          & ( v133365(VarNext,bitIndex114)
          <=> v105137(VarCurr,bitIndex237) )
          & ( v133365(VarNext,bitIndex113)
          <=> v105137(VarCurr,bitIndex236) )
          & ( v133365(VarNext,bitIndex112)
          <=> v105137(VarCurr,bitIndex235) )
          & ( v133365(VarNext,bitIndex111)
          <=> v105137(VarCurr,bitIndex234) )
          & ( v133365(VarNext,bitIndex110)
          <=> v105137(VarCurr,bitIndex233) )
          & ( v133365(VarNext,bitIndex109)
          <=> v105137(VarCurr,bitIndex232) )
          & ( v133365(VarNext,bitIndex108)
          <=> v105137(VarCurr,bitIndex231) )
          & ( v133365(VarNext,bitIndex107)
          <=> v105137(VarCurr,bitIndex230) )
          & ( v133365(VarNext,bitIndex106)
          <=> v105137(VarCurr,bitIndex229) )
          & ( v133365(VarNext,bitIndex105)
          <=> v105137(VarCurr,bitIndex228) )
          & ( v133365(VarNext,bitIndex104)
          <=> v105137(VarCurr,bitIndex227) )
          & ( v133365(VarNext,bitIndex103)
          <=> v105137(VarCurr,bitIndex226) )
          & ( v133365(VarNext,bitIndex102)
          <=> v105137(VarCurr,bitIndex225) )
          & ( v133365(VarNext,bitIndex101)
          <=> v105137(VarCurr,bitIndex224) )
          & ( v133365(VarNext,bitIndex100)
          <=> v105137(VarCurr,bitIndex223) )
          & ( v133365(VarNext,bitIndex99)
          <=> v105137(VarCurr,bitIndex222) )
          & ( v133365(VarNext,bitIndex98)
          <=> v105137(VarCurr,bitIndex221) )
          & ( v133365(VarNext,bitIndex97)
          <=> v105137(VarCurr,bitIndex220) )
          & ( v133365(VarNext,bitIndex96)
          <=> v105137(VarCurr,bitIndex219) )
          & ( v133365(VarNext,bitIndex95)
          <=> v105137(VarCurr,bitIndex218) )
          & ( v133365(VarNext,bitIndex94)
          <=> v105137(VarCurr,bitIndex217) )
          & ( v133365(VarNext,bitIndex93)
          <=> v105137(VarCurr,bitIndex216) )
          & ( v133365(VarNext,bitIndex92)
          <=> v105137(VarCurr,bitIndex215) )
          & ( v133365(VarNext,bitIndex91)
          <=> v105137(VarCurr,bitIndex214) )
          & ( v133365(VarNext,bitIndex90)
          <=> v105137(VarCurr,bitIndex213) )
          & ( v133365(VarNext,bitIndex89)
          <=> v105137(VarCurr,bitIndex212) )
          & ( v133365(VarNext,bitIndex88)
          <=> v105137(VarCurr,bitIndex211) )
          & ( v133365(VarNext,bitIndex87)
          <=> v105137(VarCurr,bitIndex210) )
          & ( v133365(VarNext,bitIndex86)
          <=> v105137(VarCurr,bitIndex209) )
          & ( v133365(VarNext,bitIndex85)
          <=> v105137(VarCurr,bitIndex208) )
          & ( v133365(VarNext,bitIndex84)
          <=> v105137(VarCurr,bitIndex207) )
          & ( v133365(VarNext,bitIndex83)
          <=> v105137(VarCurr,bitIndex206) )
          & ( v133365(VarNext,bitIndex82)
          <=> v105137(VarCurr,bitIndex205) )
          & ( v133365(VarNext,bitIndex81)
          <=> v105137(VarCurr,bitIndex204) )
          & ( v133365(VarNext,bitIndex80)
          <=> v105137(VarCurr,bitIndex203) )
          & ( v133365(VarNext,bitIndex79)
          <=> v105137(VarCurr,bitIndex202) )
          & ( v133365(VarNext,bitIndex78)
          <=> v105137(VarCurr,bitIndex201) )
          & ( v133365(VarNext,bitIndex77)
          <=> v105137(VarCurr,bitIndex200) )
          & ( v133365(VarNext,bitIndex76)
          <=> v105137(VarCurr,bitIndex199) )
          & ( v133365(VarNext,bitIndex75)
          <=> v105137(VarCurr,bitIndex198) )
          & ( v133365(VarNext,bitIndex74)
          <=> v105137(VarCurr,bitIndex197) )
          & ( v133365(VarNext,bitIndex73)
          <=> v105137(VarCurr,bitIndex196) )
          & ( v133365(VarNext,bitIndex72)
          <=> v105137(VarCurr,bitIndex195) )
          & ( v133365(VarNext,bitIndex71)
          <=> v105137(VarCurr,bitIndex194) )
          & ( v133365(VarNext,bitIndex70)
          <=> v105137(VarCurr,bitIndex193) )
          & ( v133365(VarNext,bitIndex69)
          <=> v105137(VarCurr,bitIndex192) )
          & ( v133365(VarNext,bitIndex68)
          <=> v105137(VarCurr,bitIndex191) )
          & ( v133365(VarNext,bitIndex67)
          <=> v105137(VarCurr,bitIndex190) )
          & ( v133365(VarNext,bitIndex66)
          <=> v105137(VarCurr,bitIndex189) )
          & ( v133365(VarNext,bitIndex65)
          <=> v105137(VarCurr,bitIndex188) )
          & ( v133365(VarNext,bitIndex64)
          <=> v105137(VarCurr,bitIndex187) )
          & ( v133365(VarNext,bitIndex63)
          <=> v105137(VarCurr,bitIndex186) )
          & ( v133365(VarNext,bitIndex62)
          <=> v105137(VarCurr,bitIndex185) )
          & ( v133365(VarNext,bitIndex61)
          <=> v105137(VarCurr,bitIndex184) )
          & ( v133365(VarNext,bitIndex60)
          <=> v105137(VarCurr,bitIndex183) )
          & ( v133365(VarNext,bitIndex59)
          <=> v105137(VarCurr,bitIndex182) )
          & ( v133365(VarNext,bitIndex58)
          <=> v105137(VarCurr,bitIndex181) )
          & ( v133365(VarNext,bitIndex57)
          <=> v105137(VarCurr,bitIndex180) )
          & ( v133365(VarNext,bitIndex56)
          <=> v105137(VarCurr,bitIndex179) )
          & ( v133365(VarNext,bitIndex55)
          <=> v105137(VarCurr,bitIndex178) )
          & ( v133365(VarNext,bitIndex54)
          <=> v105137(VarCurr,bitIndex177) )
          & ( v133365(VarNext,bitIndex53)
          <=> v105137(VarCurr,bitIndex176) )
          & ( v133365(VarNext,bitIndex52)
          <=> v105137(VarCurr,bitIndex175) )
          & ( v133365(VarNext,bitIndex51)
          <=> v105137(VarCurr,bitIndex174) )
          & ( v133365(VarNext,bitIndex50)
          <=> v105137(VarCurr,bitIndex173) )
          & ( v133365(VarNext,bitIndex49)
          <=> v105137(VarCurr,bitIndex172) )
          & ( v133365(VarNext,bitIndex48)
          <=> v105137(VarCurr,bitIndex171) )
          & ( v133365(VarNext,bitIndex47)
          <=> v105137(VarCurr,bitIndex170) )
          & ( v133365(VarNext,bitIndex46)
          <=> v105137(VarCurr,bitIndex169) )
          & ( v133365(VarNext,bitIndex45)
          <=> v105137(VarCurr,bitIndex168) )
          & ( v133365(VarNext,bitIndex44)
          <=> v105137(VarCurr,bitIndex167) )
          & ( v133365(VarNext,bitIndex43)
          <=> v105137(VarCurr,bitIndex166) )
          & ( v133365(VarNext,bitIndex42)
          <=> v105137(VarCurr,bitIndex165) )
          & ( v133365(VarNext,bitIndex41)
          <=> v105137(VarCurr,bitIndex164) )
          & ( v133365(VarNext,bitIndex40)
          <=> v105137(VarCurr,bitIndex163) )
          & ( v133365(VarNext,bitIndex39)
          <=> v105137(VarCurr,bitIndex162) )
          & ( v133365(VarNext,bitIndex38)
          <=> v105137(VarCurr,bitIndex161) )
          & ( v133365(VarNext,bitIndex37)
          <=> v105137(VarCurr,bitIndex160) )
          & ( v133365(VarNext,bitIndex36)
          <=> v105137(VarCurr,bitIndex159) )
          & ( v133365(VarNext,bitIndex35)
          <=> v105137(VarCurr,bitIndex158) )
          & ( v133365(VarNext,bitIndex34)
          <=> v105137(VarCurr,bitIndex157) )
          & ( v133365(VarNext,bitIndex33)
          <=> v105137(VarCurr,bitIndex156) )
          & ( v133365(VarNext,bitIndex32)
          <=> v105137(VarCurr,bitIndex155) )
          & ( v133365(VarNext,bitIndex31)
          <=> v105137(VarCurr,bitIndex154) )
          & ( v133365(VarNext,bitIndex30)
          <=> v105137(VarCurr,bitIndex153) )
          & ( v133365(VarNext,bitIndex29)
          <=> v105137(VarCurr,bitIndex152) )
          & ( v133365(VarNext,bitIndex28)
          <=> v105137(VarCurr,bitIndex151) )
          & ( v133365(VarNext,bitIndex27)
          <=> v105137(VarCurr,bitIndex150) )
          & ( v133365(VarNext,bitIndex26)
          <=> v105137(VarCurr,bitIndex149) )
          & ( v133365(VarNext,bitIndex25)
          <=> v105137(VarCurr,bitIndex148) )
          & ( v133365(VarNext,bitIndex24)
          <=> v105137(VarCurr,bitIndex147) )
          & ( v133365(VarNext,bitIndex23)
          <=> v105137(VarCurr,bitIndex146) )
          & ( v133365(VarNext,bitIndex22)
          <=> v105137(VarCurr,bitIndex145) )
          & ( v133365(VarNext,bitIndex21)
          <=> v105137(VarCurr,bitIndex144) )
          & ( v133365(VarNext,bitIndex20)
          <=> v105137(VarCurr,bitIndex143) )
          & ( v133365(VarNext,bitIndex19)
          <=> v105137(VarCurr,bitIndex142) )
          & ( v133365(VarNext,bitIndex18)
          <=> v105137(VarCurr,bitIndex141) )
          & ( v133365(VarNext,bitIndex17)
          <=> v105137(VarCurr,bitIndex140) )
          & ( v133365(VarNext,bitIndex16)
          <=> v105137(VarCurr,bitIndex139) )
          & ( v133365(VarNext,bitIndex15)
          <=> v105137(VarCurr,bitIndex138) )
          & ( v133365(VarNext,bitIndex14)
          <=> v105137(VarCurr,bitIndex137) )
          & ( v133365(VarNext,bitIndex13)
          <=> v105137(VarCurr,bitIndex136) )
          & ( v133365(VarNext,bitIndex12)
          <=> v105137(VarCurr,bitIndex135) )
          & ( v133365(VarNext,bitIndex11)
          <=> v105137(VarCurr,bitIndex134) )
          & ( v133365(VarNext,bitIndex10)
          <=> v105137(VarCurr,bitIndex133) )
          & ( v133365(VarNext,bitIndex9)
          <=> v105137(VarCurr,bitIndex132) )
          & ( v133365(VarNext,bitIndex8)
          <=> v105137(VarCurr,bitIndex131) )
          & ( v133365(VarNext,bitIndex7)
          <=> v105137(VarCurr,bitIndex130) )
          & ( v133365(VarNext,bitIndex6)
          <=> v105137(VarCurr,bitIndex129) )
          & ( v133365(VarNext,bitIndex5)
          <=> v105137(VarCurr,bitIndex128) )
          & ( v133365(VarNext,bitIndex4)
          <=> v105137(VarCurr,bitIndex127) )
          & ( v133365(VarNext,bitIndex3)
          <=> v105137(VarCurr,bitIndex126) )
          & ( v133365(VarNext,bitIndex2)
          <=> v105137(VarCurr,bitIndex125) )
          & ( v133365(VarNext,bitIndex1)
          <=> v105137(VarCurr,bitIndex124) )
          & ( v133365(VarNext,bitIndex0)
          <=> v105137(VarCurr,bitIndex123) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2471,axiom,
    ! [VarNext] :
      ( v133367(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133365(VarNext,B)
          <=> v105369(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26714,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133367(VarNext)
      <=> ( v133368(VarNext)
          & v105351(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26713,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133368(VarNext)
      <=> ( v133370(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11066,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133370(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43547,axiom,
    ! [VarCurr] :
      ( v105335(VarCurr,bitIndex81)
    <=> v105340(VarCurr,bitIndex81) ) ).

fof(addAssignment_43546,axiom,
    ! [VarCurr] :
      ( v105339(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex81) ) ).

fof(addAssignment_43545,axiom,
    ! [VarCurr] :
      ( v105328(VarCurr,bitIndex81)
    <=> v105333(VarCurr,bitIndex81) ) ).

fof(addAssignment_43544,axiom,
    ! [VarCurr] :
      ( v105332(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex204) ) ).

fof(addAssignment_43543,axiom,
    ! [VarNext] :
      ( v105137(VarNext,bitIndex81)
    <=> v133357(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionEqualRanges1_2338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133359(VarNext)
       => ! [B] :
            ( range_122_0(B)
           => ( v133357(VarNext,B)
            <=> v105137(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2470,axiom,
    ! [VarNext] :
      ( v133359(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133357(VarNext,B)
          <=> v105323(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26712,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133359(VarNext)
      <=> ( v133360(VarNext)
          & v105304(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26711,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133360(VarNext)
      <=> ( v133362(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11065,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133362(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43542,axiom,
    ! [VarCurr] :
      ( v105288(VarCurr,bitIndex81)
    <=> v105293(VarCurr,bitIndex81) ) ).

fof(addAssignment_43541,axiom,
    ! [VarCurr] :
      ( v105292(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex81) ) ).

fof(addAssignment_43540,axiom,
    ! [VarCurr] :
      ( v105191(VarCurr,bitIndex81)
    <=> v105286(VarCurr,bitIndex81) ) ).

fof(addAssignment_43539,axiom,
    ! [VarCurr] :
      ( v105285(VarCurr,bitIndex81)
    <=> v105137(VarCurr,bitIndex81) ) ).

fof(addAssignment_43538,axiom,
    ! [VarCurr] :
      ( v105140(VarCurr,bitIndex81)
    <=> v105142(VarCurr,bitIndex81) ) ).

fof(addAssignment_43537,axiom,
    ! [VarCurr] :
      ( v105142(VarCurr,bitIndex81)
    <=> v105144(VarCurr,bitIndex81) ) ).

fof(addAssignment_43536,axiom,
    ! [VarCurr] :
      ( v105144(VarCurr,bitIndex81)
    <=> v105146(VarCurr,bitIndex81) ) ).

fof(addAssignment_43535,axiom,
    ! [VarCurr] :
      ( v105146(VarCurr,bitIndex81)
    <=> v105148(VarCurr,bitIndex81) ) ).

fof(addAssignment_43534,axiom,
    ! [VarCurr] :
      ( v105148(VarCurr,bitIndex81)
    <=> v105150(VarCurr,bitIndex81) ) ).

fof(addAssignment_43533,axiom,
    ! [VarCurr] :
      ( v105150(VarCurr,bitIndex81)
    <=> v105152(VarCurr,bitIndex81) ) ).

fof(addAssignment_43532,axiom,
    ! [VarCurr] :
      ( v105152(VarCurr,bitIndex81)
    <=> v105154(VarCurr,bitIndex81) ) ).

fof(addAssignment_43531,axiom,
    ! [VarNext] :
      ( v105154(VarNext,bitIndex81)
    <=> v133349(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionEqualRanges1_2337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133350(VarNext)
       => ! [B] :
            ( range_122_0(B)
           => ( v133349(VarNext,B)
            <=> v105154(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2469,axiom,
    ! [VarNext] :
      ( v133350(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v133349(VarNext,B)
          <=> v105186(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26710,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133350(VarNext)
      <=> v133351(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26709,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133351(VarNext)
      <=> ( v133353(VarNext)
          & v188(VarNext) ) ) ) ).

fof(writeUnaryOperator_11064,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133353(VarNext)
      <=> v105180(VarNext) ) ) ).

fof(addAssignment_43530,axiom,
    ! [VarCurr] :
      ( v105156(VarCurr,bitIndex81)
    <=> v105164(VarCurr,bitIndex81) ) ).

fof(addAssignment_43529,axiom,
    ! [VarCurr] :
      ( v105169(VarCurr,bitIndex4)
    <=> v133346(VarCurr,bitIndex4) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3192,axiom,
    ! [VarCurr] :
      ( ~ v133347(VarCurr)
     => ! [B] :
          ( range_7_0(B)
         => ( v133346(VarCurr,B)
          <=> v133313(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_782,axiom,
    ! [VarCurr] :
      ( v133347(VarCurr)
     => ( ( v133346(VarCurr,bitIndex7)
        <=> v245(VarCurr,bitIndex13) )
        & ( v133346(VarCurr,bitIndex6)
        <=> v245(VarCurr,bitIndex12) )
        & ( v133346(VarCurr,bitIndex5)
        <=> v245(VarCurr,bitIndex11) )
        & ( v133346(VarCurr,bitIndex4)
        <=> v245(VarCurr,bitIndex10) )
        & ( v133346(VarCurr,bitIndex3)
        <=> v245(VarCurr,bitIndex9) )
        & ( v133346(VarCurr,bitIndex2)
        <=> v245(VarCurr,bitIndex8) )
        & ( v133346(VarCurr,bitIndex1)
        <=> v245(VarCurr,bitIndex7) )
        & ( v133346(VarCurr,bitIndex0)
        <=> v245(VarCurr,bitIndex6) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26708,axiom,
    ! [VarCurr] :
      ( v133347(VarCurr)
    <=> ( v133251(VarCurr)
        | v15439(VarCurr) ) ) ).

fof(addAssignment_43528,axiom,
    ! [VarCurr] :
      ( v133313(VarCurr,bitIndex4)
    <=> v247(VarCurr,bitIndex74) ) ).

fof(addAssignment_43527,axiom,
    ! [VarCurr] :
      ( v247(VarCurr,bitIndex74)
    <=> v249(VarCurr,bitIndex74) ) ).

fof(addAssignment_43526,axiom,
    ! [VarCurr] :
      ( v249(VarCurr,bitIndex74)
    <=> v251(VarCurr,bitIndex74) ) ).

fof(addAssignment_43525,axiom,
    ! [VarCurr] :
      ( v251(VarCurr,bitIndex74)
    <=> v253(VarCurr,bitIndex654) ) ).

fof(addAssignment_43524,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex654)
    <=> v133339(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_148,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133341(VarNext)
       => ( ( v133339(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex695) )
          & ( v133339(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex694) )
          & ( v133339(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex693) )
          & ( v133339(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex692) )
          & ( v133339(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex691) )
          & ( v133339(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex690) )
          & ( v133339(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex689) )
          & ( v133339(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex688) )
          & ( v133339(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex687) )
          & ( v133339(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex686) )
          & ( v133339(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex685) )
          & ( v133339(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex684) )
          & ( v133339(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex683) )
          & ( v133339(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex682) )
          & ( v133339(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex681) )
          & ( v133339(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex680) )
          & ( v133339(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex679) )
          & ( v133339(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex678) )
          & ( v133339(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex677) )
          & ( v133339(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex676) )
          & ( v133339(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex675) )
          & ( v133339(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex674) )
          & ( v133339(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex673) )
          & ( v133339(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex672) )
          & ( v133339(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex671) )
          & ( v133339(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex670) )
          & ( v133339(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex669) )
          & ( v133339(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex668) )
          & ( v133339(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex667) )
          & ( v133339(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex666) )
          & ( v133339(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex665) )
          & ( v133339(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex664) )
          & ( v133339(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex663) )
          & ( v133339(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex662) )
          & ( v133339(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex661) )
          & ( v133339(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex660) )
          & ( v133339(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex659) )
          & ( v133339(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex658) )
          & ( v133339(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex657) )
          & ( v133339(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex656) )
          & ( v133339(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex655) )
          & ( v133339(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex654) )
          & ( v133339(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex653) )
          & ( v133339(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex652) )
          & ( v133339(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex651) )
          & ( v133339(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex650) )
          & ( v133339(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex649) )
          & ( v133339(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex648) )
          & ( v133339(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex647) )
          & ( v133339(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex646) )
          & ( v133339(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex645) )
          & ( v133339(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex644) )
          & ( v133339(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex643) )
          & ( v133339(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex642) )
          & ( v133339(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex641) )
          & ( v133339(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex640) )
          & ( v133339(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex639) )
          & ( v133339(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex638) )
          & ( v133339(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex637) )
          & ( v133339(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex636) )
          & ( v133339(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex635) )
          & ( v133339(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex634) )
          & ( v133339(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex633) )
          & ( v133339(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex632) )
          & ( v133339(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex631) )
          & ( v133339(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex630) )
          & ( v133339(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex629) )
          & ( v133339(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex628) )
          & ( v133339(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex627) )
          & ( v133339(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex626) )
          & ( v133339(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex625) )
          & ( v133339(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex624) )
          & ( v133339(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex623) )
          & ( v133339(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex622) )
          & ( v133339(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex621) )
          & ( v133339(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex620) )
          & ( v133339(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex619) )
          & ( v133339(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex618) )
          & ( v133339(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex617) )
          & ( v133339(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex616) )
          & ( v133339(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex615) )
          & ( v133339(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex614) )
          & ( v133339(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex613) )
          & ( v133339(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex612) )
          & ( v133339(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex611) )
          & ( v133339(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex610) )
          & ( v133339(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex609) )
          & ( v133339(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex608) )
          & ( v133339(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex607) )
          & ( v133339(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex606) )
          & ( v133339(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex605) )
          & ( v133339(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex604) )
          & ( v133339(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex603) )
          & ( v133339(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex602) )
          & ( v133339(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex601) )
          & ( v133339(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex600) )
          & ( v133339(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex599) )
          & ( v133339(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex598) )
          & ( v133339(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex597) )
          & ( v133339(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex596) )
          & ( v133339(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex595) )
          & ( v133339(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex594) )
          & ( v133339(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex593) )
          & ( v133339(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex592) )
          & ( v133339(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex591) )
          & ( v133339(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex590) )
          & ( v133339(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex589) )
          & ( v133339(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex588) )
          & ( v133339(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex587) )
          & ( v133339(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex586) )
          & ( v133339(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex585) )
          & ( v133339(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex584) )
          & ( v133339(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex583) )
          & ( v133339(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex582) )
          & ( v133339(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex581) )
          & ( v133339(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex580) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2468,axiom,
    ! [VarNext] :
      ( v133341(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133339(VarNext,B)
          <=> v371(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26707,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133341(VarNext)
      <=> ( v133342(VarNext)
          & v366(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26706,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133342(VarNext)
      <=> ( v133344(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11063,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133344(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43523,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex538)
    <=> v133331(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_147,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133333(VarNext)
       => ( ( v133331(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex579) )
          & ( v133331(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex578) )
          & ( v133331(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex577) )
          & ( v133331(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex576) )
          & ( v133331(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex575) )
          & ( v133331(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex574) )
          & ( v133331(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex573) )
          & ( v133331(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex572) )
          & ( v133331(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex571) )
          & ( v133331(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex570) )
          & ( v133331(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex569) )
          & ( v133331(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex568) )
          & ( v133331(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex567) )
          & ( v133331(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex566) )
          & ( v133331(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex565) )
          & ( v133331(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex564) )
          & ( v133331(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex563) )
          & ( v133331(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex562) )
          & ( v133331(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex561) )
          & ( v133331(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex560) )
          & ( v133331(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex559) )
          & ( v133331(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex558) )
          & ( v133331(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex557) )
          & ( v133331(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex556) )
          & ( v133331(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex555) )
          & ( v133331(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex554) )
          & ( v133331(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex553) )
          & ( v133331(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex552) )
          & ( v133331(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex551) )
          & ( v133331(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex550) )
          & ( v133331(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex549) )
          & ( v133331(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex548) )
          & ( v133331(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex547) )
          & ( v133331(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex546) )
          & ( v133331(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex545) )
          & ( v133331(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex544) )
          & ( v133331(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex543) )
          & ( v133331(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex542) )
          & ( v133331(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex541) )
          & ( v133331(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex540) )
          & ( v133331(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex539) )
          & ( v133331(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex538) )
          & ( v133331(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex537) )
          & ( v133331(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex536) )
          & ( v133331(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex535) )
          & ( v133331(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex534) )
          & ( v133331(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex533) )
          & ( v133331(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex532) )
          & ( v133331(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex531) )
          & ( v133331(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex530) )
          & ( v133331(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex529) )
          & ( v133331(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex528) )
          & ( v133331(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex527) )
          & ( v133331(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex526) )
          & ( v133331(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex525) )
          & ( v133331(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex524) )
          & ( v133331(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex523) )
          & ( v133331(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex522) )
          & ( v133331(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex521) )
          & ( v133331(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex520) )
          & ( v133331(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex519) )
          & ( v133331(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex518) )
          & ( v133331(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex517) )
          & ( v133331(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex516) )
          & ( v133331(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex515) )
          & ( v133331(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex514) )
          & ( v133331(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex513) )
          & ( v133331(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex512) )
          & ( v133331(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex511) )
          & ( v133331(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex510) )
          & ( v133331(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex509) )
          & ( v133331(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex508) )
          & ( v133331(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex507) )
          & ( v133331(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex506) )
          & ( v133331(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex505) )
          & ( v133331(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex504) )
          & ( v133331(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex503) )
          & ( v133331(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex502) )
          & ( v133331(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex501) )
          & ( v133331(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex500) )
          & ( v133331(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex499) )
          & ( v133331(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex498) )
          & ( v133331(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex497) )
          & ( v133331(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex496) )
          & ( v133331(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex495) )
          & ( v133331(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex494) )
          & ( v133331(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex493) )
          & ( v133331(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex492) )
          & ( v133331(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex491) )
          & ( v133331(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex490) )
          & ( v133331(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex489) )
          & ( v133331(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex488) )
          & ( v133331(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex487) )
          & ( v133331(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex486) )
          & ( v133331(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex485) )
          & ( v133331(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex484) )
          & ( v133331(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex483) )
          & ( v133331(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex482) )
          & ( v133331(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex481) )
          & ( v133331(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex480) )
          & ( v133331(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex479) )
          & ( v133331(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex478) )
          & ( v133331(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex477) )
          & ( v133331(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex476) )
          & ( v133331(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex475) )
          & ( v133331(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex474) )
          & ( v133331(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex473) )
          & ( v133331(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex472) )
          & ( v133331(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex471) )
          & ( v133331(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex470) )
          & ( v133331(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex469) )
          & ( v133331(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex468) )
          & ( v133331(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex467) )
          & ( v133331(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex466) )
          & ( v133331(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex465) )
          & ( v133331(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex464) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2467,axiom,
    ! [VarNext] :
      ( v133333(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133331(VarNext,B)
          <=> v352(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26705,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133333(VarNext)
      <=> ( v133334(VarNext)
          & v347(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26704,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133334(VarNext)
      <=> ( v133336(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11062,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133336(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43522,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex422)
    <=> v133323(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_146,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133325(VarNext)
       => ( ( v133323(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex463) )
          & ( v133323(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex462) )
          & ( v133323(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex461) )
          & ( v133323(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex460) )
          & ( v133323(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex459) )
          & ( v133323(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex458) )
          & ( v133323(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex457) )
          & ( v133323(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex456) )
          & ( v133323(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex455) )
          & ( v133323(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex454) )
          & ( v133323(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex453) )
          & ( v133323(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex452) )
          & ( v133323(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex451) )
          & ( v133323(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex450) )
          & ( v133323(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex449) )
          & ( v133323(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex448) )
          & ( v133323(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex447) )
          & ( v133323(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex446) )
          & ( v133323(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex445) )
          & ( v133323(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex444) )
          & ( v133323(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex443) )
          & ( v133323(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex442) )
          & ( v133323(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex441) )
          & ( v133323(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex440) )
          & ( v133323(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex439) )
          & ( v133323(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex438) )
          & ( v133323(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex437) )
          & ( v133323(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex436) )
          & ( v133323(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex435) )
          & ( v133323(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex434) )
          & ( v133323(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex433) )
          & ( v133323(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex432) )
          & ( v133323(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex431) )
          & ( v133323(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex430) )
          & ( v133323(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex429) )
          & ( v133323(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex428) )
          & ( v133323(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex427) )
          & ( v133323(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex426) )
          & ( v133323(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex425) )
          & ( v133323(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex424) )
          & ( v133323(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex423) )
          & ( v133323(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex422) )
          & ( v133323(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex421) )
          & ( v133323(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex420) )
          & ( v133323(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex419) )
          & ( v133323(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex418) )
          & ( v133323(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex417) )
          & ( v133323(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex416) )
          & ( v133323(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex415) )
          & ( v133323(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex414) )
          & ( v133323(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex413) )
          & ( v133323(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex412) )
          & ( v133323(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex411) )
          & ( v133323(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex410) )
          & ( v133323(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex409) )
          & ( v133323(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex408) )
          & ( v133323(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex407) )
          & ( v133323(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex406) )
          & ( v133323(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex405) )
          & ( v133323(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex404) )
          & ( v133323(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex403) )
          & ( v133323(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex402) )
          & ( v133323(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex401) )
          & ( v133323(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex400) )
          & ( v133323(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex399) )
          & ( v133323(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex398) )
          & ( v133323(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex397) )
          & ( v133323(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex396) )
          & ( v133323(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex395) )
          & ( v133323(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex394) )
          & ( v133323(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex393) )
          & ( v133323(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex392) )
          & ( v133323(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex391) )
          & ( v133323(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex390) )
          & ( v133323(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex389) )
          & ( v133323(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex388) )
          & ( v133323(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex387) )
          & ( v133323(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex386) )
          & ( v133323(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex385) )
          & ( v133323(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex384) )
          & ( v133323(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex383) )
          & ( v133323(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex382) )
          & ( v133323(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex381) )
          & ( v133323(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex380) )
          & ( v133323(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex379) )
          & ( v133323(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex378) )
          & ( v133323(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex377) )
          & ( v133323(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex376) )
          & ( v133323(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex375) )
          & ( v133323(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex374) )
          & ( v133323(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex373) )
          & ( v133323(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex372) )
          & ( v133323(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex371) )
          & ( v133323(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex370) )
          & ( v133323(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex369) )
          & ( v133323(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex368) )
          & ( v133323(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex367) )
          & ( v133323(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex366) )
          & ( v133323(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex365) )
          & ( v133323(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex364) )
          & ( v133323(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex363) )
          & ( v133323(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex362) )
          & ( v133323(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex361) )
          & ( v133323(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex360) )
          & ( v133323(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex359) )
          & ( v133323(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex358) )
          & ( v133323(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex357) )
          & ( v133323(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex356) )
          & ( v133323(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex355) )
          & ( v133323(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex354) )
          & ( v133323(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex353) )
          & ( v133323(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex352) )
          & ( v133323(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex351) )
          & ( v133323(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex350) )
          & ( v133323(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex349) )
          & ( v133323(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex348) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2466,axiom,
    ! [VarNext] :
      ( v133325(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133323(VarNext,B)
          <=> v333(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26703,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133325(VarNext)
      <=> ( v133326(VarNext)
          & v328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26702,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133326(VarNext)
      <=> ( v133328(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11061,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133328(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43521,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex306)
    <=> v133315(VarNext,bitIndex74) ) ).

fof(addCaseBooleanConditionShiftedRanges1_145,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133317(VarNext)
       => ( ( v133315(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex347) )
          & ( v133315(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex346) )
          & ( v133315(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex345) )
          & ( v133315(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex344) )
          & ( v133315(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex343) )
          & ( v133315(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex342) )
          & ( v133315(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex341) )
          & ( v133315(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex340) )
          & ( v133315(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex339) )
          & ( v133315(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex338) )
          & ( v133315(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex337) )
          & ( v133315(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex336) )
          & ( v133315(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex335) )
          & ( v133315(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex334) )
          & ( v133315(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex333) )
          & ( v133315(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex332) )
          & ( v133315(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex331) )
          & ( v133315(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex330) )
          & ( v133315(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex329) )
          & ( v133315(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex328) )
          & ( v133315(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex327) )
          & ( v133315(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex326) )
          & ( v133315(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex325) )
          & ( v133315(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex324) )
          & ( v133315(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex323) )
          & ( v133315(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex322) )
          & ( v133315(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex321) )
          & ( v133315(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex320) )
          & ( v133315(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex319) )
          & ( v133315(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex318) )
          & ( v133315(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex317) )
          & ( v133315(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex316) )
          & ( v133315(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex315) )
          & ( v133315(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex314) )
          & ( v133315(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex313) )
          & ( v133315(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex312) )
          & ( v133315(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex311) )
          & ( v133315(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex310) )
          & ( v133315(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex309) )
          & ( v133315(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex308) )
          & ( v133315(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex307) )
          & ( v133315(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex306) )
          & ( v133315(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex305) )
          & ( v133315(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex304) )
          & ( v133315(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex303) )
          & ( v133315(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex302) )
          & ( v133315(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex301) )
          & ( v133315(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex300) )
          & ( v133315(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex299) )
          & ( v133315(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex298) )
          & ( v133315(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex297) )
          & ( v133315(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex296) )
          & ( v133315(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex295) )
          & ( v133315(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex294) )
          & ( v133315(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex293) )
          & ( v133315(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex292) )
          & ( v133315(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex291) )
          & ( v133315(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex290) )
          & ( v133315(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex289) )
          & ( v133315(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex288) )
          & ( v133315(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex287) )
          & ( v133315(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex286) )
          & ( v133315(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex285) )
          & ( v133315(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex284) )
          & ( v133315(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex283) )
          & ( v133315(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex282) )
          & ( v133315(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex281) )
          & ( v133315(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex280) )
          & ( v133315(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex279) )
          & ( v133315(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex278) )
          & ( v133315(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex277) )
          & ( v133315(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex276) )
          & ( v133315(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex275) )
          & ( v133315(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex274) )
          & ( v133315(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex273) )
          & ( v133315(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex272) )
          & ( v133315(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex271) )
          & ( v133315(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex270) )
          & ( v133315(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex269) )
          & ( v133315(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex268) )
          & ( v133315(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex267) )
          & ( v133315(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex266) )
          & ( v133315(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex265) )
          & ( v133315(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex264) )
          & ( v133315(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex263) )
          & ( v133315(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex262) )
          & ( v133315(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex261) )
          & ( v133315(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex260) )
          & ( v133315(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex259) )
          & ( v133315(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex258) )
          & ( v133315(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex257) )
          & ( v133315(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex256) )
          & ( v133315(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex255) )
          & ( v133315(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex254) )
          & ( v133315(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex253) )
          & ( v133315(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex252) )
          & ( v133315(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex251) )
          & ( v133315(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex250) )
          & ( v133315(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex249) )
          & ( v133315(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex248) )
          & ( v133315(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex247) )
          & ( v133315(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex246) )
          & ( v133315(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex245) )
          & ( v133315(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex244) )
          & ( v133315(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex243) )
          & ( v133315(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex242) )
          & ( v133315(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex241) )
          & ( v133315(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex240) )
          & ( v133315(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex239) )
          & ( v133315(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex238) )
          & ( v133315(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex237) )
          & ( v133315(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex236) )
          & ( v133315(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex235) )
          & ( v133315(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex234) )
          & ( v133315(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex233) )
          & ( v133315(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex232) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2465,axiom,
    ! [VarNext] :
      ( v133317(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133315(VarNext,B)
          <=> v314(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26701,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133317(VarNext)
      <=> ( v133318(VarNext)
          & v308(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26700,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133318(VarNext)
      <=> ( v133320(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11060,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133320(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43520,axiom,
    ! [VarCurr] :
      ( v283(VarCurr,bitIndex74)
    <=> v285(VarCurr,bitIndex74) ) ).

fof(addAssignment_43519,axiom,
    ! [VarCurr] :
      ( v285(VarCurr,bitIndex74)
    <=> v287(VarCurr,bitIndex74) ) ).

fof(addAssignment_43518,axiom,
    ! [VarCurr] :
      ( v287(VarCurr,bitIndex74)
    <=> v289(VarCurr,bitIndex74) ) ).

fof(addAssignment_43517,axiom,
    ! [VarCurr] :
      ( v289(VarCurr,bitIndex74)
    <=> v291(VarCurr,bitIndex74) ) ).

fof(addAssignment_43516,axiom,
    ! [VarCurr] :
      ( v291(VarCurr,bitIndex74)
    <=> v293(VarCurr,bitIndex74) ) ).

fof(addAssignment_43515,axiom,
    ! [VarCurr] :
      ( v245(VarCurr,bitIndex10)
    <=> v247(VarCurr,bitIndex10) ) ).

fof(addAssignment_43514,axiom,
    ! [VarCurr] :
      ( v247(VarCurr,bitIndex10)
    <=> v249(VarCurr,bitIndex10) ) ).

fof(addAssignment_43513,axiom,
    ! [VarCurr] :
      ( v249(VarCurr,bitIndex10)
    <=> v251(VarCurr,bitIndex10) ) ).

fof(addAssignment_43512,axiom,
    ! [VarCurr] :
      ( v251(VarCurr,bitIndex10)
    <=> v253(VarCurr,bitIndex590) ) ).

fof(addAssignment_43511,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex590)
    <=> v133305(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_144,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133307(VarNext)
       => ( ( v133305(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex695) )
          & ( v133305(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex694) )
          & ( v133305(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex693) )
          & ( v133305(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex692) )
          & ( v133305(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex691) )
          & ( v133305(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex690) )
          & ( v133305(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex689) )
          & ( v133305(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex688) )
          & ( v133305(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex687) )
          & ( v133305(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex686) )
          & ( v133305(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex685) )
          & ( v133305(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex684) )
          & ( v133305(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex683) )
          & ( v133305(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex682) )
          & ( v133305(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex681) )
          & ( v133305(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex680) )
          & ( v133305(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex679) )
          & ( v133305(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex678) )
          & ( v133305(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex677) )
          & ( v133305(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex676) )
          & ( v133305(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex675) )
          & ( v133305(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex674) )
          & ( v133305(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex673) )
          & ( v133305(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex672) )
          & ( v133305(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex671) )
          & ( v133305(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex670) )
          & ( v133305(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex669) )
          & ( v133305(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex668) )
          & ( v133305(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex667) )
          & ( v133305(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex666) )
          & ( v133305(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex665) )
          & ( v133305(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex664) )
          & ( v133305(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex663) )
          & ( v133305(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex662) )
          & ( v133305(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex661) )
          & ( v133305(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex660) )
          & ( v133305(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex659) )
          & ( v133305(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex658) )
          & ( v133305(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex657) )
          & ( v133305(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex656) )
          & ( v133305(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex655) )
          & ( v133305(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex654) )
          & ( v133305(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex653) )
          & ( v133305(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex652) )
          & ( v133305(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex651) )
          & ( v133305(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex650) )
          & ( v133305(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex649) )
          & ( v133305(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex648) )
          & ( v133305(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex647) )
          & ( v133305(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex646) )
          & ( v133305(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex645) )
          & ( v133305(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex644) )
          & ( v133305(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex643) )
          & ( v133305(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex642) )
          & ( v133305(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex641) )
          & ( v133305(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex640) )
          & ( v133305(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex639) )
          & ( v133305(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex638) )
          & ( v133305(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex637) )
          & ( v133305(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex636) )
          & ( v133305(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex635) )
          & ( v133305(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex634) )
          & ( v133305(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex633) )
          & ( v133305(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex632) )
          & ( v133305(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex631) )
          & ( v133305(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex630) )
          & ( v133305(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex629) )
          & ( v133305(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex628) )
          & ( v133305(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex627) )
          & ( v133305(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex626) )
          & ( v133305(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex625) )
          & ( v133305(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex624) )
          & ( v133305(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex623) )
          & ( v133305(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex622) )
          & ( v133305(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex621) )
          & ( v133305(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex620) )
          & ( v133305(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex619) )
          & ( v133305(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex618) )
          & ( v133305(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex617) )
          & ( v133305(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex616) )
          & ( v133305(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex615) )
          & ( v133305(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex614) )
          & ( v133305(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex613) )
          & ( v133305(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex612) )
          & ( v133305(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex611) )
          & ( v133305(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex610) )
          & ( v133305(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex609) )
          & ( v133305(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex608) )
          & ( v133305(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex607) )
          & ( v133305(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex606) )
          & ( v133305(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex605) )
          & ( v133305(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex604) )
          & ( v133305(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex603) )
          & ( v133305(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex602) )
          & ( v133305(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex601) )
          & ( v133305(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex600) )
          & ( v133305(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex599) )
          & ( v133305(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex598) )
          & ( v133305(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex597) )
          & ( v133305(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex596) )
          & ( v133305(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex595) )
          & ( v133305(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex594) )
          & ( v133305(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex593) )
          & ( v133305(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex592) )
          & ( v133305(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex591) )
          & ( v133305(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex590) )
          & ( v133305(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex589) )
          & ( v133305(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex588) )
          & ( v133305(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex587) )
          & ( v133305(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex586) )
          & ( v133305(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex585) )
          & ( v133305(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex584) )
          & ( v133305(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex583) )
          & ( v133305(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex582) )
          & ( v133305(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex581) )
          & ( v133305(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex580) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2464,axiom,
    ! [VarNext] :
      ( v133307(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133305(VarNext,B)
          <=> v371(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26699,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133307(VarNext)
      <=> ( v133308(VarNext)
          & v366(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26698,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133308(VarNext)
      <=> ( v133310(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11059,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133310(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43510,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex474)
    <=> v133297(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_143,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133299(VarNext)
       => ( ( v133297(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex579) )
          & ( v133297(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex578) )
          & ( v133297(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex577) )
          & ( v133297(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex576) )
          & ( v133297(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex575) )
          & ( v133297(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex574) )
          & ( v133297(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex573) )
          & ( v133297(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex572) )
          & ( v133297(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex571) )
          & ( v133297(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex570) )
          & ( v133297(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex569) )
          & ( v133297(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex568) )
          & ( v133297(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex567) )
          & ( v133297(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex566) )
          & ( v133297(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex565) )
          & ( v133297(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex564) )
          & ( v133297(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex563) )
          & ( v133297(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex562) )
          & ( v133297(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex561) )
          & ( v133297(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex560) )
          & ( v133297(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex559) )
          & ( v133297(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex558) )
          & ( v133297(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex557) )
          & ( v133297(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex556) )
          & ( v133297(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex555) )
          & ( v133297(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex554) )
          & ( v133297(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex553) )
          & ( v133297(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex552) )
          & ( v133297(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex551) )
          & ( v133297(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex550) )
          & ( v133297(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex549) )
          & ( v133297(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex548) )
          & ( v133297(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex547) )
          & ( v133297(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex546) )
          & ( v133297(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex545) )
          & ( v133297(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex544) )
          & ( v133297(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex543) )
          & ( v133297(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex542) )
          & ( v133297(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex541) )
          & ( v133297(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex540) )
          & ( v133297(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex539) )
          & ( v133297(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex538) )
          & ( v133297(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex537) )
          & ( v133297(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex536) )
          & ( v133297(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex535) )
          & ( v133297(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex534) )
          & ( v133297(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex533) )
          & ( v133297(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex532) )
          & ( v133297(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex531) )
          & ( v133297(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex530) )
          & ( v133297(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex529) )
          & ( v133297(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex528) )
          & ( v133297(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex527) )
          & ( v133297(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex526) )
          & ( v133297(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex525) )
          & ( v133297(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex524) )
          & ( v133297(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex523) )
          & ( v133297(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex522) )
          & ( v133297(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex521) )
          & ( v133297(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex520) )
          & ( v133297(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex519) )
          & ( v133297(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex518) )
          & ( v133297(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex517) )
          & ( v133297(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex516) )
          & ( v133297(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex515) )
          & ( v133297(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex514) )
          & ( v133297(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex513) )
          & ( v133297(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex512) )
          & ( v133297(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex511) )
          & ( v133297(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex510) )
          & ( v133297(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex509) )
          & ( v133297(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex508) )
          & ( v133297(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex507) )
          & ( v133297(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex506) )
          & ( v133297(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex505) )
          & ( v133297(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex504) )
          & ( v133297(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex503) )
          & ( v133297(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex502) )
          & ( v133297(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex501) )
          & ( v133297(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex500) )
          & ( v133297(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex499) )
          & ( v133297(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex498) )
          & ( v133297(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex497) )
          & ( v133297(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex496) )
          & ( v133297(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex495) )
          & ( v133297(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex494) )
          & ( v133297(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex493) )
          & ( v133297(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex492) )
          & ( v133297(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex491) )
          & ( v133297(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex490) )
          & ( v133297(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex489) )
          & ( v133297(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex488) )
          & ( v133297(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex487) )
          & ( v133297(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex486) )
          & ( v133297(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex485) )
          & ( v133297(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex484) )
          & ( v133297(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex483) )
          & ( v133297(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex482) )
          & ( v133297(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex481) )
          & ( v133297(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex480) )
          & ( v133297(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex479) )
          & ( v133297(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex478) )
          & ( v133297(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex477) )
          & ( v133297(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex476) )
          & ( v133297(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex475) )
          & ( v133297(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex474) )
          & ( v133297(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex473) )
          & ( v133297(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex472) )
          & ( v133297(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex471) )
          & ( v133297(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex470) )
          & ( v133297(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex469) )
          & ( v133297(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex468) )
          & ( v133297(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex467) )
          & ( v133297(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex466) )
          & ( v133297(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex465) )
          & ( v133297(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex464) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2463,axiom,
    ! [VarNext] :
      ( v133299(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133297(VarNext,B)
          <=> v352(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26697,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133299(VarNext)
      <=> ( v133300(VarNext)
          & v347(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26696,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133300(VarNext)
      <=> ( v133302(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11058,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133302(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43509,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex358)
    <=> v133289(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_142,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133291(VarNext)
       => ( ( v133289(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex463) )
          & ( v133289(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex462) )
          & ( v133289(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex461) )
          & ( v133289(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex460) )
          & ( v133289(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex459) )
          & ( v133289(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex458) )
          & ( v133289(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex457) )
          & ( v133289(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex456) )
          & ( v133289(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex455) )
          & ( v133289(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex454) )
          & ( v133289(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex453) )
          & ( v133289(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex452) )
          & ( v133289(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex451) )
          & ( v133289(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex450) )
          & ( v133289(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex449) )
          & ( v133289(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex448) )
          & ( v133289(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex447) )
          & ( v133289(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex446) )
          & ( v133289(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex445) )
          & ( v133289(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex444) )
          & ( v133289(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex443) )
          & ( v133289(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex442) )
          & ( v133289(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex441) )
          & ( v133289(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex440) )
          & ( v133289(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex439) )
          & ( v133289(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex438) )
          & ( v133289(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex437) )
          & ( v133289(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex436) )
          & ( v133289(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex435) )
          & ( v133289(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex434) )
          & ( v133289(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex433) )
          & ( v133289(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex432) )
          & ( v133289(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex431) )
          & ( v133289(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex430) )
          & ( v133289(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex429) )
          & ( v133289(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex428) )
          & ( v133289(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex427) )
          & ( v133289(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex426) )
          & ( v133289(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex425) )
          & ( v133289(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex424) )
          & ( v133289(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex423) )
          & ( v133289(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex422) )
          & ( v133289(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex421) )
          & ( v133289(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex420) )
          & ( v133289(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex419) )
          & ( v133289(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex418) )
          & ( v133289(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex417) )
          & ( v133289(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex416) )
          & ( v133289(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex415) )
          & ( v133289(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex414) )
          & ( v133289(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex413) )
          & ( v133289(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex412) )
          & ( v133289(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex411) )
          & ( v133289(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex410) )
          & ( v133289(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex409) )
          & ( v133289(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex408) )
          & ( v133289(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex407) )
          & ( v133289(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex406) )
          & ( v133289(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex405) )
          & ( v133289(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex404) )
          & ( v133289(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex403) )
          & ( v133289(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex402) )
          & ( v133289(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex401) )
          & ( v133289(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex400) )
          & ( v133289(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex399) )
          & ( v133289(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex398) )
          & ( v133289(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex397) )
          & ( v133289(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex396) )
          & ( v133289(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex395) )
          & ( v133289(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex394) )
          & ( v133289(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex393) )
          & ( v133289(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex392) )
          & ( v133289(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex391) )
          & ( v133289(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex390) )
          & ( v133289(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex389) )
          & ( v133289(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex388) )
          & ( v133289(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex387) )
          & ( v133289(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex386) )
          & ( v133289(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex385) )
          & ( v133289(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex384) )
          & ( v133289(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex383) )
          & ( v133289(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex382) )
          & ( v133289(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex381) )
          & ( v133289(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex380) )
          & ( v133289(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex379) )
          & ( v133289(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex378) )
          & ( v133289(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex377) )
          & ( v133289(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex376) )
          & ( v133289(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex375) )
          & ( v133289(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex374) )
          & ( v133289(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex373) )
          & ( v133289(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex372) )
          & ( v133289(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex371) )
          & ( v133289(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex370) )
          & ( v133289(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex369) )
          & ( v133289(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex368) )
          & ( v133289(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex367) )
          & ( v133289(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex366) )
          & ( v133289(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex365) )
          & ( v133289(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex364) )
          & ( v133289(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex363) )
          & ( v133289(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex362) )
          & ( v133289(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex361) )
          & ( v133289(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex360) )
          & ( v133289(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex359) )
          & ( v133289(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex358) )
          & ( v133289(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex357) )
          & ( v133289(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex356) )
          & ( v133289(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex355) )
          & ( v133289(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex354) )
          & ( v133289(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex353) )
          & ( v133289(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex352) )
          & ( v133289(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex351) )
          & ( v133289(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex350) )
          & ( v133289(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex349) )
          & ( v133289(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex348) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2462,axiom,
    ! [VarNext] :
      ( v133291(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133289(VarNext,B)
          <=> v333(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26695,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133291(VarNext)
      <=> ( v133292(VarNext)
          & v328(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26694,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133292(VarNext)
      <=> ( v133294(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11057,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133294(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43508,axiom,
    ! [VarNext] :
      ( v253(VarNext,bitIndex242)
    <=> v133281(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_141,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133283(VarNext)
       => ( ( v133281(VarNext,bitIndex115)
          <=> v253(VarCurr,bitIndex347) )
          & ( v133281(VarNext,bitIndex114)
          <=> v253(VarCurr,bitIndex346) )
          & ( v133281(VarNext,bitIndex113)
          <=> v253(VarCurr,bitIndex345) )
          & ( v133281(VarNext,bitIndex112)
          <=> v253(VarCurr,bitIndex344) )
          & ( v133281(VarNext,bitIndex111)
          <=> v253(VarCurr,bitIndex343) )
          & ( v133281(VarNext,bitIndex110)
          <=> v253(VarCurr,bitIndex342) )
          & ( v133281(VarNext,bitIndex109)
          <=> v253(VarCurr,bitIndex341) )
          & ( v133281(VarNext,bitIndex108)
          <=> v253(VarCurr,bitIndex340) )
          & ( v133281(VarNext,bitIndex107)
          <=> v253(VarCurr,bitIndex339) )
          & ( v133281(VarNext,bitIndex106)
          <=> v253(VarCurr,bitIndex338) )
          & ( v133281(VarNext,bitIndex105)
          <=> v253(VarCurr,bitIndex337) )
          & ( v133281(VarNext,bitIndex104)
          <=> v253(VarCurr,bitIndex336) )
          & ( v133281(VarNext,bitIndex103)
          <=> v253(VarCurr,bitIndex335) )
          & ( v133281(VarNext,bitIndex102)
          <=> v253(VarCurr,bitIndex334) )
          & ( v133281(VarNext,bitIndex101)
          <=> v253(VarCurr,bitIndex333) )
          & ( v133281(VarNext,bitIndex100)
          <=> v253(VarCurr,bitIndex332) )
          & ( v133281(VarNext,bitIndex99)
          <=> v253(VarCurr,bitIndex331) )
          & ( v133281(VarNext,bitIndex98)
          <=> v253(VarCurr,bitIndex330) )
          & ( v133281(VarNext,bitIndex97)
          <=> v253(VarCurr,bitIndex329) )
          & ( v133281(VarNext,bitIndex96)
          <=> v253(VarCurr,bitIndex328) )
          & ( v133281(VarNext,bitIndex95)
          <=> v253(VarCurr,bitIndex327) )
          & ( v133281(VarNext,bitIndex94)
          <=> v253(VarCurr,bitIndex326) )
          & ( v133281(VarNext,bitIndex93)
          <=> v253(VarCurr,bitIndex325) )
          & ( v133281(VarNext,bitIndex92)
          <=> v253(VarCurr,bitIndex324) )
          & ( v133281(VarNext,bitIndex91)
          <=> v253(VarCurr,bitIndex323) )
          & ( v133281(VarNext,bitIndex90)
          <=> v253(VarCurr,bitIndex322) )
          & ( v133281(VarNext,bitIndex89)
          <=> v253(VarCurr,bitIndex321) )
          & ( v133281(VarNext,bitIndex88)
          <=> v253(VarCurr,bitIndex320) )
          & ( v133281(VarNext,bitIndex87)
          <=> v253(VarCurr,bitIndex319) )
          & ( v133281(VarNext,bitIndex86)
          <=> v253(VarCurr,bitIndex318) )
          & ( v133281(VarNext,bitIndex85)
          <=> v253(VarCurr,bitIndex317) )
          & ( v133281(VarNext,bitIndex84)
          <=> v253(VarCurr,bitIndex316) )
          & ( v133281(VarNext,bitIndex83)
          <=> v253(VarCurr,bitIndex315) )
          & ( v133281(VarNext,bitIndex82)
          <=> v253(VarCurr,bitIndex314) )
          & ( v133281(VarNext,bitIndex81)
          <=> v253(VarCurr,bitIndex313) )
          & ( v133281(VarNext,bitIndex80)
          <=> v253(VarCurr,bitIndex312) )
          & ( v133281(VarNext,bitIndex79)
          <=> v253(VarCurr,bitIndex311) )
          & ( v133281(VarNext,bitIndex78)
          <=> v253(VarCurr,bitIndex310) )
          & ( v133281(VarNext,bitIndex77)
          <=> v253(VarCurr,bitIndex309) )
          & ( v133281(VarNext,bitIndex76)
          <=> v253(VarCurr,bitIndex308) )
          & ( v133281(VarNext,bitIndex75)
          <=> v253(VarCurr,bitIndex307) )
          & ( v133281(VarNext,bitIndex74)
          <=> v253(VarCurr,bitIndex306) )
          & ( v133281(VarNext,bitIndex73)
          <=> v253(VarCurr,bitIndex305) )
          & ( v133281(VarNext,bitIndex72)
          <=> v253(VarCurr,bitIndex304) )
          & ( v133281(VarNext,bitIndex71)
          <=> v253(VarCurr,bitIndex303) )
          & ( v133281(VarNext,bitIndex70)
          <=> v253(VarCurr,bitIndex302) )
          & ( v133281(VarNext,bitIndex69)
          <=> v253(VarCurr,bitIndex301) )
          & ( v133281(VarNext,bitIndex68)
          <=> v253(VarCurr,bitIndex300) )
          & ( v133281(VarNext,bitIndex67)
          <=> v253(VarCurr,bitIndex299) )
          & ( v133281(VarNext,bitIndex66)
          <=> v253(VarCurr,bitIndex298) )
          & ( v133281(VarNext,bitIndex65)
          <=> v253(VarCurr,bitIndex297) )
          & ( v133281(VarNext,bitIndex64)
          <=> v253(VarCurr,bitIndex296) )
          & ( v133281(VarNext,bitIndex63)
          <=> v253(VarCurr,bitIndex295) )
          & ( v133281(VarNext,bitIndex62)
          <=> v253(VarCurr,bitIndex294) )
          & ( v133281(VarNext,bitIndex61)
          <=> v253(VarCurr,bitIndex293) )
          & ( v133281(VarNext,bitIndex60)
          <=> v253(VarCurr,bitIndex292) )
          & ( v133281(VarNext,bitIndex59)
          <=> v253(VarCurr,bitIndex291) )
          & ( v133281(VarNext,bitIndex58)
          <=> v253(VarCurr,bitIndex290) )
          & ( v133281(VarNext,bitIndex57)
          <=> v253(VarCurr,bitIndex289) )
          & ( v133281(VarNext,bitIndex56)
          <=> v253(VarCurr,bitIndex288) )
          & ( v133281(VarNext,bitIndex55)
          <=> v253(VarCurr,bitIndex287) )
          & ( v133281(VarNext,bitIndex54)
          <=> v253(VarCurr,bitIndex286) )
          & ( v133281(VarNext,bitIndex53)
          <=> v253(VarCurr,bitIndex285) )
          & ( v133281(VarNext,bitIndex52)
          <=> v253(VarCurr,bitIndex284) )
          & ( v133281(VarNext,bitIndex51)
          <=> v253(VarCurr,bitIndex283) )
          & ( v133281(VarNext,bitIndex50)
          <=> v253(VarCurr,bitIndex282) )
          & ( v133281(VarNext,bitIndex49)
          <=> v253(VarCurr,bitIndex281) )
          & ( v133281(VarNext,bitIndex48)
          <=> v253(VarCurr,bitIndex280) )
          & ( v133281(VarNext,bitIndex47)
          <=> v253(VarCurr,bitIndex279) )
          & ( v133281(VarNext,bitIndex46)
          <=> v253(VarCurr,bitIndex278) )
          & ( v133281(VarNext,bitIndex45)
          <=> v253(VarCurr,bitIndex277) )
          & ( v133281(VarNext,bitIndex44)
          <=> v253(VarCurr,bitIndex276) )
          & ( v133281(VarNext,bitIndex43)
          <=> v253(VarCurr,bitIndex275) )
          & ( v133281(VarNext,bitIndex42)
          <=> v253(VarCurr,bitIndex274) )
          & ( v133281(VarNext,bitIndex41)
          <=> v253(VarCurr,bitIndex273) )
          & ( v133281(VarNext,bitIndex40)
          <=> v253(VarCurr,bitIndex272) )
          & ( v133281(VarNext,bitIndex39)
          <=> v253(VarCurr,bitIndex271) )
          & ( v133281(VarNext,bitIndex38)
          <=> v253(VarCurr,bitIndex270) )
          & ( v133281(VarNext,bitIndex37)
          <=> v253(VarCurr,bitIndex269) )
          & ( v133281(VarNext,bitIndex36)
          <=> v253(VarCurr,bitIndex268) )
          & ( v133281(VarNext,bitIndex35)
          <=> v253(VarCurr,bitIndex267) )
          & ( v133281(VarNext,bitIndex34)
          <=> v253(VarCurr,bitIndex266) )
          & ( v133281(VarNext,bitIndex33)
          <=> v253(VarCurr,bitIndex265) )
          & ( v133281(VarNext,bitIndex32)
          <=> v253(VarCurr,bitIndex264) )
          & ( v133281(VarNext,bitIndex31)
          <=> v253(VarCurr,bitIndex263) )
          & ( v133281(VarNext,bitIndex30)
          <=> v253(VarCurr,bitIndex262) )
          & ( v133281(VarNext,bitIndex29)
          <=> v253(VarCurr,bitIndex261) )
          & ( v133281(VarNext,bitIndex28)
          <=> v253(VarCurr,bitIndex260) )
          & ( v133281(VarNext,bitIndex27)
          <=> v253(VarCurr,bitIndex259) )
          & ( v133281(VarNext,bitIndex26)
          <=> v253(VarCurr,bitIndex258) )
          & ( v133281(VarNext,bitIndex25)
          <=> v253(VarCurr,bitIndex257) )
          & ( v133281(VarNext,bitIndex24)
          <=> v253(VarCurr,bitIndex256) )
          & ( v133281(VarNext,bitIndex23)
          <=> v253(VarCurr,bitIndex255) )
          & ( v133281(VarNext,bitIndex22)
          <=> v253(VarCurr,bitIndex254) )
          & ( v133281(VarNext,bitIndex21)
          <=> v253(VarCurr,bitIndex253) )
          & ( v133281(VarNext,bitIndex20)
          <=> v253(VarCurr,bitIndex252) )
          & ( v133281(VarNext,bitIndex19)
          <=> v253(VarCurr,bitIndex251) )
          & ( v133281(VarNext,bitIndex18)
          <=> v253(VarCurr,bitIndex250) )
          & ( v133281(VarNext,bitIndex17)
          <=> v253(VarCurr,bitIndex249) )
          & ( v133281(VarNext,bitIndex16)
          <=> v253(VarCurr,bitIndex248) )
          & ( v133281(VarNext,bitIndex15)
          <=> v253(VarCurr,bitIndex247) )
          & ( v133281(VarNext,bitIndex14)
          <=> v253(VarCurr,bitIndex246) )
          & ( v133281(VarNext,bitIndex13)
          <=> v253(VarCurr,bitIndex245) )
          & ( v133281(VarNext,bitIndex12)
          <=> v253(VarCurr,bitIndex244) )
          & ( v133281(VarNext,bitIndex11)
          <=> v253(VarCurr,bitIndex243) )
          & ( v133281(VarNext,bitIndex10)
          <=> v253(VarCurr,bitIndex242) )
          & ( v133281(VarNext,bitIndex9)
          <=> v253(VarCurr,bitIndex241) )
          & ( v133281(VarNext,bitIndex8)
          <=> v253(VarCurr,bitIndex240) )
          & ( v133281(VarNext,bitIndex7)
          <=> v253(VarCurr,bitIndex239) )
          & ( v133281(VarNext,bitIndex6)
          <=> v253(VarCurr,bitIndex238) )
          & ( v133281(VarNext,bitIndex5)
          <=> v253(VarCurr,bitIndex237) )
          & ( v133281(VarNext,bitIndex4)
          <=> v253(VarCurr,bitIndex236) )
          & ( v133281(VarNext,bitIndex3)
          <=> v253(VarCurr,bitIndex235) )
          & ( v133281(VarNext,bitIndex2)
          <=> v253(VarCurr,bitIndex234) )
          & ( v133281(VarNext,bitIndex1)
          <=> v253(VarCurr,bitIndex233) )
          & ( v133281(VarNext,bitIndex0)
          <=> v253(VarCurr,bitIndex232) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2461,axiom,
    ! [VarNext] :
      ( v133283(VarNext)
     => ! [B] :
          ( range_115_0(B)
         => ( v133281(VarNext,B)
          <=> v314(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26693,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133283(VarNext)
      <=> ( v133284(VarNext)
          & v308(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26692,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133284(VarNext)
      <=> ( v133286(VarNext)
          & v295(VarNext) ) ) ) ).

fof(writeUnaryOperator_11056,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133286(VarNext)
      <=> v302(VarNext) ) ) ).

fof(addAssignment_43507,axiom,
    ! [VarCurr] :
      ( v283(VarCurr,bitIndex10)
    <=> v285(VarCurr,bitIndex10) ) ).

fof(addAssignment_43506,axiom,
    ! [VarCurr] :
      ( v285(VarCurr,bitIndex10)
    <=> v287(VarCurr,bitIndex10) ) ).

fof(addAssignment_43505,axiom,
    ! [VarCurr] :
      ( v287(VarCurr,bitIndex10)
    <=> v289(VarCurr,bitIndex10) ) ).

fof(addAssignment_43504,axiom,
    ! [VarCurr] :
      ( v289(VarCurr,bitIndex10)
    <=> v291(VarCurr,bitIndex10) ) ).

fof(addAssignment_43503,axiom,
    ! [VarCurr] :
      ( v291(VarCurr,bitIndex10)
    <=> v293(VarCurr,bitIndex10) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3191,axiom,
    ! [VarCurr] :
      ( ~ v133253(VarCurr)
     => ( v133251(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2996,axiom,
    ! [VarCurr] :
      ( v133253(VarCurr)
     => ( v133251(VarCurr)
      <=> v133279(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5409,axiom,
    ! [VarCurr] :
      ( ~ v133254(VarCurr)
     => ( v133279(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5398,axiom,
    ! [VarCurr] :
      ( v133254(VarCurr)
     => ( v133279(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26691,axiom,
    ! [VarCurr] :
      ( v133253(VarCurr)
    <=> ( v133254(VarCurr)
        | v133256(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26690,axiom,
    ! [VarCurr] :
      ( v133256(VarCurr)
    <=> ( v133257(VarCurr)
        | v133274(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26689,axiom,
    ! [VarCurr] :
      ( v133274(VarCurr)
    <=> ( v133276(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26688,axiom,
    ! [VarCurr] :
      ( v133276(VarCurr)
    <=> ( v133277(VarCurr)
        & v10053(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26687,axiom,
    ! [VarCurr] :
      ( v133277(VarCurr)
    <=> ( v133278(VarCurr)
        & v10052(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3078,axiom,
    ! [VarCurr] :
      ( v133278(VarCurr)
    <=> ( v133269(VarCurr)
        & v4200(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26686,axiom,
    ! [VarCurr] :
      ( v133257(VarCurr)
    <=> ( v133258(VarCurr)
        | v133271(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26685,axiom,
    ! [VarCurr] :
      ( v133271(VarCurr)
    <=> ( v133273(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3077,axiom,
    ! [VarCurr] :
      ( v133273(VarCurr)
    <=> ( v133267(VarCurr)
        & v4200(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26684,axiom,
    ! [VarCurr] :
      ( v133258(VarCurr)
    <=> ( v133259(VarCurr)
        | v133264(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26683,axiom,
    ! [VarCurr] :
      ( v133264(VarCurr)
    <=> ( v133266(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26682,axiom,
    ! [VarCurr] :
      ( v133266(VarCurr)
    <=> ( v133267(VarCurr)
        & v10053(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26681,axiom,
    ! [VarCurr] :
      ( v133267(VarCurr)
    <=> ( v133268(VarCurr)
        & v10052(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26680,axiom,
    ! [VarCurr] :
      ( v133268(VarCurr)
    <=> ( v133269(VarCurr)
        & v10051(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26679,axiom,
    ! [VarCurr] :
      ( v133269(VarCurr)
    <=> ( v133270(VarCurr)
        & v10050(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26678,axiom,
    ! [VarCurr] :
      ( v133270(VarCurr)
    <=> ( v4200(VarCurr,bitIndex0)
        & v10049(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26677,axiom,
    ! [VarCurr] :
      ( v133259(VarCurr)
    <=> ( v133260(VarCurr)
        | v133262(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26676,axiom,
    ! [VarCurr] :
      ( v133262(VarCurr)
    <=> ( v10058(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26675,axiom,
    ! [VarCurr] :
      ( v133260(VarCurr)
    <=> ( v10043(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26674,axiom,
    ! [VarCurr] :
      ( v133254(VarCurr)
    <=> ( v15443(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(addAssignment_43502,axiom,
    ! [VarCurr] :
      ( ( v133246(VarCurr,bitIndex6)
      <=> v105133(VarCurr,bitIndex122) )
      & ( v133246(VarCurr,bitIndex5)
      <=> v105133(VarCurr,bitIndex121) )
      & ( v133246(VarCurr,bitIndex4)
      <=> v105133(VarCurr,bitIndex120) )
      & ( v133246(VarCurr,bitIndex3)
      <=> v105133(VarCurr,bitIndex119) )
      & ( v133246(VarCurr,bitIndex2)
      <=> v105133(VarCurr,bitIndex118) )
      & ( v133246(VarCurr,bitIndex1)
      <=> v105133(VarCurr,bitIndex117) )
      & ( v133246(VarCurr,bitIndex0)
      <=> v105133(VarCurr,bitIndex116) ) ) ).

fof(addAssignment_43501,axiom,
    ! [VarCurr] :
      ( v90(VarCurr)
    <=> v92(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2336,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133223(VarNext)
       => ( v92(VarNext)
        <=> v92(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2460,axiom,
    ! [VarNext] :
      ( v133223(VarNext)
     => ( v92(VarNext)
      <=> v133241(VarNext) ) ) ).

fof(addAssignment_43500,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133241(VarNext)
      <=> v133239(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3190,axiom,
    ! [VarCurr] :
      ( ~ v133238(VarCurr)
     => ( v133239(VarCurr)
      <=> v133242(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2995,axiom,
    ! [VarCurr] :
      ( v133238(VarCurr)
     => ( v133239(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3189,axiom,
    ! [VarCurr] :
      ( ~ v96(VarCurr)
     => ( v133242(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2994,axiom,
    ! [VarCurr] :
      ( v96(VarCurr)
     => ( v133242(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26673,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133223(VarNext)
      <=> ( v133224(VarNext)
          & v133231(VarNext) ) ) ) ).

fof(addAssignment_43499,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133231(VarNext)
      <=> v133229(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26672,axiom,
    ! [VarCurr] :
      ( v133229(VarCurr)
    <=> ( v133232(VarCurr)
        | v133238(VarCurr) ) ) ).

fof(writeUnaryOperator_11055,axiom,
    ! [VarCurr] :
      ( ~ v133238(VarCurr)
    <=> v94(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26671,axiom,
    ! [VarCurr] :
      ( v133232(VarCurr)
    <=> ( v133233(VarCurr)
        | v96(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26670,axiom,
    ! [VarCurr] :
      ( v133233(VarCurr)
    <=> ( v133234(VarCurr)
        & v133237(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9310,axiom,
    ! [VarCurr] :
      ( v133237(VarCurr)
    <=> ( v105197(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26669,axiom,
    ! [VarCurr] :
      ( v133234(VarCurr)
    <=> ( v133235(VarCurr)
        & v133236(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9309,axiom,
    ! [VarCurr] :
      ( v133236(VarCurr)
    <=> ( v15467(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_9308,axiom,
    ! [VarCurr] :
      ( v133235(VarCurr)
    <=> ( v15471(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26668,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133224(VarNext)
      <=> ( v133225(VarNext)
          & v105202(VarNext) ) ) ) ).

fof(writeUnaryOperator_11054,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133225(VarNext)
      <=> v105209(VarNext) ) ) ).

fof(addAssignment_43498,axiom,
    ! [VarCurr] :
      ( v105197(VarCurr,bitIndex0)
    <=> v105219(VarCurr,bitIndex0) ) ).

fof(addAssignment_43497,axiom,
    ! [VarCurr] :
      ( v96(VarCurr)
    <=> v98(VarCurr) ) ).

fof(addAssignment_43496,axiom,
    ! [VarCurr] :
      ( v98(VarCurr)
    <=> v100(VarCurr) ) ).

fof(addAssignment_43495,axiom,
    ! [VarCurr] :
      ( v100(VarCurr)
    <=> v102(VarCurr) ) ).

fof(addAssignment_43494,axiom,
    ! [VarCurr] :
      ( v102(VarCurr)
    <=> v104(VarCurr) ) ).

fof(addAssignment_43493,axiom,
    ! [VarCurr] :
      ( v104(VarCurr)
    <=> v106(VarCurr) ) ).

fof(addAssignment_43492,axiom,
    ! [VarCurr] :
      ( v106(VarCurr)
    <=> v108(VarCurr) ) ).

fof(addAssignment_43491,axiom,
    ! [VarCurr] :
      ( v108(VarCurr)
    <=> v110(VarCurr) ) ).

fof(addAssignment_43490,axiom,
    ! [VarCurr] :
      ( v110(VarCurr)
    <=> v112(VarCurr,bitIndex1) ) ).

fof(addAssignment_43489,axiom,
    ! [VarNext] :
      ( v112(VarNext,bitIndex1)
    <=> v133214(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_140,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133215(VarNext)
       => ( ( v133214(VarNext,bitIndex1)
          <=> v112(VarCurr,bitIndex2) )
          & ( v133214(VarNext,bitIndex0)
          <=> v112(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2459,axiom,
    ! [VarNext] :
      ( v133215(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v133214(VarNext,B)
          <=> v131292(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26667,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133215(VarNext)
      <=> v133216(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26666,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133216(VarNext)
      <=> ( v133218(VarNext)
          & v131200(VarNext) ) ) ) ).

fof(writeUnaryOperator_11053,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133218(VarNext)
      <=> v131207(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_586,axiom,
    ! [VarCurr] :
      ( ~ v133199(VarCurr)
     => ( v121(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_781,axiom,
    ! [VarCurr] :
      ( v133199(VarCurr)
     => ( v121(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26665,axiom,
    ! [VarCurr] :
      ( v133199(VarCurr)
    <=> ( v133200(VarCurr)
        | v133209(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26664,axiom,
    ! [VarCurr] :
      ( v133209(VarCurr)
    <=> ( v133210(VarCurr)
        & v133211(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26663,axiom,
    ! [VarCurr] :
      ( v133211(VarCurr)
    <=> ( v133212(VarCurr)
        & v131281(VarCurr) ) ) ).

fof(writeUnaryOperator_11052,axiom,
    ! [VarCurr] :
      ( ~ v133212(VarCurr)
    <=> v15451(VarCurr) ) ).

fof(writeUnaryOperator_11051,axiom,
    ! [VarCurr] :
      ( ~ v133210(VarCurr)
    <=> v131253(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26662,axiom,
    ! [VarCurr] :
      ( v133200(VarCurr)
    <=> ( v133201(VarCurr)
        & v131253(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26661,axiom,
    ! [VarCurr] :
      ( v133201(VarCurr)
    <=> ( v133202(VarCurr)
        | v133206(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26660,axiom,
    ! [VarCurr] :
      ( v133206(VarCurr)
    <=> ( v133208(VarCurr)
        & v131242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26659,axiom,
    ! [VarCurr] :
      ( v133208(VarCurr)
    <=> ( v131251(VarCurr)
        & v131246(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26658,axiom,
    ! [VarCurr] :
      ( v133202(VarCurr)
    <=> ( v133204(VarCurr)
        & v131242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26657,axiom,
    ! [VarCurr] :
      ( v133204(VarCurr)
    <=> ( v133205(VarCurr)
        & v15423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26656,axiom,
    ! [VarCurr] :
      ( v133205(VarCurr)
    <=> ( v131251(VarCurr)
        & v131277(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26655,axiom,
    ! [VarCurr] :
      ( v235(VarCurr)
    <=> ( v133194(VarCurr)
        | v133195(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26654,axiom,
    ! [VarCurr] :
      ( v133195(VarCurr)
    <=> ( v133196(VarCurr)
        & v133014(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26653,axiom,
    ! [VarCurr] :
      ( v133196(VarCurr)
    <=> ( v133001(VarCurr)
        | v15425(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26652,axiom,
    ! [VarCurr] :
      ( v133194(VarCurr)
    <=> ( v237(VarCurr)
        & v10060(VarCurr) ) ) ).

fof(addAssignment_43488,axiom,
    ! [VarCurr] :
      ( v133014(VarCurr)
    <=> v133016(VarCurr) ) ).

fof(addAssignment_43487,axiom,
    ! [VarCurr] :
      ( v133016(VarCurr)
    <=> v133018(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26651,axiom,
    ! [VarCurr] :
      ( v133018(VarCurr)
    <=> ( v133191(VarCurr)
        & v133192(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3076,axiom,
    ! [VarCurr] :
      ( v133192(VarCurr)
    <=> ( v133020(VarCurr,bitIndex4)
      <~> v133102(VarCurr,bitIndex4) ) ) ).

fof(addBitVectorEqualityBitBlasted_9307,axiom,
    ! [VarCurr] :
      ( v133191(VarCurr)
    <=> ( ( v133020(VarCurr,bitIndex3)
        <=> v133102(VarCurr,bitIndex3) )
        & ( v133020(VarCurr,bitIndex2)
        <=> v133102(VarCurr,bitIndex2) )
        & ( v133020(VarCurr,bitIndex1)
        <=> v133102(VarCurr,bitIndex1) )
        & ( v133020(VarCurr,bitIndex0)
        <=> v133102(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133172(VarNext)
       => ( v133102(VarNext,bitIndex4)
        <=> v133102(VarCurr,bitIndex4) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0_16,axiom,
    ! [VarNext] :
      ( v133172(VarNext)
     => ( v133102(VarNext,bitIndex4)
      <=> v133186(VarNext) ) ) ).

fof(addAssignment_43486,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133186(VarNext)
      <=> v133184(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5408,axiom,
    ! [VarCurr] :
      ( ~ v133122(VarCurr)
     => ( v133184(VarCurr)
      <=> v133187(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5397,axiom,
    ! [VarCurr] :
      ( v133122(VarCurr)
     => ( v133184(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_11050,axiom,
    ! [VarCurr] :
      ( ~ v133187(VarCurr)
    <=> v133102(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26650,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133172(VarNext)
      <=> ( v133173(VarNext)
          & v133180(VarNext) ) ) ) ).

fof(addAssignment_43485,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133180(VarNext)
      <=> v133178(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26649,axiom,
    ! [VarCurr] :
      ( v133178(VarCurr)
    <=> ( v133122(VarCurr)
        | v133181(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26648,axiom,
    ! [VarCurr] :
      ( v133181(VarCurr)
    <=> ( v133182(VarCurr)
        & v133183(VarCurr) ) ) ).

fof(writeUnaryOperator_11049,axiom,
    ! [VarCurr] :
      ( ~ v133183(VarCurr)
    <=> v133122(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26647,axiom,
    ! [VarCurr] :
      ( v133182(VarCurr)
    <=> ( v133129(VarCurr)
        & v133104(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26646,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133173(VarNext)
      <=> ( v133175(VarNext)
          & v131325(VarNext) ) ) ) ).

fof(writeUnaryOperator_11048,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133175(VarNext)
      <=> v131332(VarNext) ) ) ).

fof(addAssignment_43484,axiom,
    ! [VarCurr] :
      ( v133020(VarCurr,bitIndex4)
    <=> v133022(VarCurr,bitIndex4) ) ).

fof(addAssignment_43483,axiom,
    ! [VarCurr] :
      ( v133022(VarCurr,bitIndex4)
    <=> v133024(VarCurr,bitIndex4) ) ).

fof(addAssignment_43482,axiom,
    ! [VarCurr] :
      ( v133024(VarCurr,bitIndex4)
    <=> v133026(VarCurr,bitIndex4) ) ).

fof(addAssignment_43481,axiom,
    ! [VarCurr] :
      ( v133026(VarCurr,bitIndex4)
    <=> v133028(VarCurr,bitIndex4) ) ).

fof(addAssignment_43480,axiom,
    ! [VarCurr] :
      ( v133028(VarCurr,bitIndex4)
    <=> v133030(VarCurr,bitIndex4) ) ).

fof(addAssignment_43479,axiom,
    ! [VarCurr] :
      ( v133030(VarCurr,bitIndex4)
    <=> v133032(VarCurr,bitIndex4) ) ).

fof(addAssignment_43478,axiom,
    ! [VarCurr] :
      ( v133032(VarCurr,bitIndex4)
    <=> v133098(VarCurr,bitIndex4) ) ).

fof(addCaseBooleanConditionEqualRanges1_2334,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133153(VarNext)
       => ( v133099(VarNext)
        <=> v133099(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2458,axiom,
    ! [VarNext] :
      ( v133153(VarNext)
     => ( v133099(VarNext)
      <=> v133166(VarNext) ) ) ).

fof(addAssignment_43477,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133166(VarNext)
      <=> v133164(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5407,axiom,
    ! [VarCurr] :
      ( ~ v133067(VarCurr)
     => ( v133164(VarCurr)
      <=> v133167(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5396,axiom,
    ! [VarCurr] :
      ( v133067(VarCurr)
     => ( v133164(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26645,axiom,
    ! [VarCurr] :
      ( v133167(VarCurr)
    <=> ( v133099(VarCurr)
      <~> v133054(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26644,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133153(VarNext)
      <=> ( v133154(VarNext)
          & v133161(VarNext) ) ) ) ).

fof(addAssignment_43476,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133161(VarNext)
      <=> v133159(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26643,axiom,
    ! [VarCurr] :
      ( v133159(VarCurr)
    <=> ( v133067(VarCurr)
        | v133162(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26642,axiom,
    ! [VarCurr] :
      ( v133162(VarCurr)
    <=> ( v133036(VarCurr)
        & v133163(VarCurr) ) ) ).

fof(writeUnaryOperator_11047,axiom,
    ! [VarCurr] :
      ( ~ v133163(VarCurr)
    <=> v133067(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26641,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133154(VarNext)
      <=> ( v133156(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_11046,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133156(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2333,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133113(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v133102(VarNext,B)
            <=> v133102(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2457,axiom,
    ! [VarNext] :
      ( v133113(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133102(VarNext,B)
          <=> v133127(VarNext,B) ) ) ) ).

fof(addAssignment_43475,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133127(VarNext,B)
          <=> v133125(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5406,axiom,
    ! [VarCurr] :
      ( ~ v133122(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133125(VarCurr,B)
          <=> v133128(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5395,axiom,
    ! [VarCurr] :
      ( v133122(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133125(VarCurr,B)
          <=> $false ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3188,axiom,
    ! [VarCurr] :
      ( ~ v133129(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133128(VarCurr,B)
          <=> v133130(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2993,axiom,
    ! [VarCurr] :
      ( v133129(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133128(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43474,axiom,
    ! [VarCurr] :
      ( v133130(VarCurr,bitIndex0)
    <=> v133146(VarCurr) ) ).

fof(addAssignment_43473,axiom,
    ! [VarCurr] :
      ( v133130(VarCurr,bitIndex1)
    <=> v133144(VarCurr) ) ).

fof(addAssignment_43472,axiom,
    ! [VarCurr] :
      ( v133130(VarCurr,bitIndex2)
    <=> v133139(VarCurr) ) ).

fof(addAssignment_43471,axiom,
    ! [VarCurr] :
      ( v133130(VarCurr,bitIndex3)
    <=> v133132(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26640,axiom,
    ! [VarCurr] :
      ( v133144(VarCurr)
    <=> ( v133145(VarCurr)
        & v133148(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3075,axiom,
    ! [VarCurr] :
      ( v133148(VarCurr)
    <=> ( v133102(VarCurr,bitIndex0)
        | v133102(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26639,axiom,
    ! [VarCurr] :
      ( v133145(VarCurr)
    <=> ( v133146(VarCurr)
        | v133147(VarCurr) ) ) ).

fof(writeUnaryOperator_11045,axiom,
    ! [VarCurr] :
      ( ~ v133147(VarCurr)
    <=> v133102(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11044,axiom,
    ! [VarCurr] :
      ( ~ v133146(VarCurr)
    <=> v133102(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26638,axiom,
    ! [VarCurr] :
      ( v133139(VarCurr)
    <=> ( v133140(VarCurr)
        & v133143(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3074,axiom,
    ! [VarCurr] :
      ( v133143(VarCurr)
    <=> ( v133136(VarCurr)
        | v133102(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26637,axiom,
    ! [VarCurr] :
      ( v133140(VarCurr)
    <=> ( v133141(VarCurr)
        | v133142(VarCurr) ) ) ).

fof(writeUnaryOperator_11043,axiom,
    ! [VarCurr] :
      ( ~ v133142(VarCurr)
    <=> v133102(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11042,axiom,
    ! [VarCurr] :
      ( ~ v133141(VarCurr)
    <=> v133136(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26636,axiom,
    ! [VarCurr] :
      ( v133132(VarCurr)
    <=> ( v133133(VarCurr)
        & v133138(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3073,axiom,
    ! [VarCurr] :
      ( v133138(VarCurr)
    <=> ( v133135(VarCurr)
        | v133102(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26635,axiom,
    ! [VarCurr] :
      ( v133133(VarCurr)
    <=> ( v133134(VarCurr)
        | v133137(VarCurr) ) ) ).

fof(writeUnaryOperator_11041,axiom,
    ! [VarCurr] :
      ( ~ v133137(VarCurr)
    <=> v133102(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11040,axiom,
    ! [VarCurr] :
      ( ~ v133134(VarCurr)
    <=> v133135(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3072,axiom,
    ! [VarCurr] :
      ( v133135(VarCurr)
    <=> ( v133136(VarCurr)
        & v133102(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3071,axiom,
    ! [VarCurr] :
      ( v133136(VarCurr)
    <=> ( v133102(VarCurr,bitIndex0)
        & v133102(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9306,axiom,
    ! [VarCurr] :
      ( v133129(VarCurr)
    <=> ( ( v133102(VarCurr,bitIndex3)
        <=> $true )
        & ( v133102(VarCurr,bitIndex2)
        <=> $false )
        & ( v133102(VarCurr,bitIndex1)
        <=> $true )
        & ( v133102(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26634,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133113(VarNext)
      <=> ( v133114(VarNext)
          & v133121(VarNext) ) ) ) ).

fof(addAssignment_43470,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133121(VarNext)
      <=> v133119(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26633,axiom,
    ! [VarCurr] :
      ( v133119(VarCurr)
    <=> ( v133122(VarCurr)
        | v133123(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26632,axiom,
    ! [VarCurr] :
      ( v133123(VarCurr)
    <=> ( v133104(VarCurr)
        & v133124(VarCurr) ) ) ).

fof(writeUnaryOperator_11039,axiom,
    ! [VarCurr] :
      ( ~ v133124(VarCurr)
    <=> v133122(VarCurr) ) ).

fof(writeUnaryOperator_11038,axiom,
    ! [VarCurr] :
      ( ~ v133122(VarCurr)
    <=> v15405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26631,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133114(VarNext)
      <=> ( v133115(VarNext)
          & v131325(VarNext) ) ) ) ).

fof(writeUnaryOperator_11037,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133115(VarNext)
      <=> v131332(VarNext) ) ) ).

fof(addAssignment_43469,axiom,
    ! [VarCurr] :
      ( v133104(VarCurr)
    <=> v133106(VarCurr) ) ).

fof(addAssignment_43468,axiom,
    ! [VarCurr] :
      ( v133106(VarCurr)
    <=> v133108(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3070,axiom,
    ! [VarCurr] :
      ( v133108(VarCurr)
    <=> ( v121(VarCurr,bitIndex1)
        & v133110(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26630,axiom,
    ! [VarCurr] :
      ( v133110(VarCurr)
    <=> ( v15425(VarCurr)
        | v133001(VarCurr) ) ) ).

fof(addAssignment_43467,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133020(VarCurr,B)
      <=> v133022(VarCurr,B) ) ) ).

fof(addAssignment_43466,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133022(VarCurr,B)
      <=> v133024(VarCurr,B) ) ) ).

fof(addAssignment_43465,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133024(VarCurr,B)
      <=> v133026(VarCurr,B) ) ) ).

fof(addAssignment_43464,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133026(VarCurr,B)
      <=> v133028(VarCurr,B) ) ) ).

fof(addAssignment_43463,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133028(VarCurr,B)
      <=> v133030(VarCurr,B) ) ) ).

fof(addAssignment_43462,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133030(VarCurr,B)
      <=> v133032(VarCurr,B) ) ) ).

fof(addAssignment_43461,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133032(VarCurr,B)
      <=> v133098(VarCurr,B) ) ) ).

fof(addAssignment_43460,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133098(VarCurr,B)
      <=> v133034(VarCurr,B) ) ) ).

fof(addAssignment_43459,axiom,
    ! [VarCurr] :
      ( v133098(VarCurr,bitIndex4)
    <=> v133099(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2332,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133058(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v133034(VarNext,B)
            <=> v133034(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2456,axiom,
    ! [VarNext] :
      ( v133058(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133034(VarNext,B)
          <=> v133072(VarNext,B) ) ) ) ).

fof(addAssignment_43458,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v133072(VarNext,B)
          <=> v133070(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5405,axiom,
    ! [VarCurr] :
      ( ~ v133067(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133070(VarCurr,B)
          <=> v133073(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5394,axiom,
    ! [VarCurr] :
      ( v133067(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v133070(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_141,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v133073(VarCurr,B)
      <=> ( v133074(VarCurr,B)
          & v133093(VarCurr,B) ) ) ) ).

fof(addAssignment_43457,axiom,
    ! [VarCurr] :
      ( v133093(VarCurr,bitIndex0)
    <=> v133094(VarCurr) ) ).

fof(addAssignment_43456,axiom,
    ! [VarCurr] :
      ( v133093(VarCurr,bitIndex1)
    <=> v133094(VarCurr) ) ).

fof(addAssignment_43455,axiom,
    ! [VarCurr] :
      ( v133093(VarCurr,bitIndex2)
    <=> v133094(VarCurr) ) ).

fof(addAssignment_43454,axiom,
    ! [VarCurr] :
      ( v133093(VarCurr,bitIndex3)
    <=> v133094(VarCurr) ) ).

fof(addAssignment_43453,axiom,
    ! [VarCurr] :
      ( v133094(VarCurr)
    <=> v133095(VarCurr) ) ).

fof(writeUnaryOperator_11036,axiom,
    ! [VarCurr] :
      ( ~ v133095(VarCurr)
    <=> v133054(VarCurr) ) ).

fof(addAssignment_43452,axiom,
    ! [VarCurr] :
      ( v133074(VarCurr,bitIndex0)
    <=> v133090(VarCurr) ) ).

fof(addAssignment_43451,axiom,
    ! [VarCurr] :
      ( v133074(VarCurr,bitIndex1)
    <=> v133088(VarCurr) ) ).

fof(addAssignment_43450,axiom,
    ! [VarCurr] :
      ( v133074(VarCurr,bitIndex2)
    <=> v133083(VarCurr) ) ).

fof(addAssignment_43449,axiom,
    ! [VarCurr] :
      ( v133074(VarCurr,bitIndex3)
    <=> v133076(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26629,axiom,
    ! [VarCurr] :
      ( v133088(VarCurr)
    <=> ( v133089(VarCurr)
        & v133092(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3069,axiom,
    ! [VarCurr] :
      ( v133092(VarCurr)
    <=> ( v133034(VarCurr,bitIndex0)
        | v133034(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26628,axiom,
    ! [VarCurr] :
      ( v133089(VarCurr)
    <=> ( v133090(VarCurr)
        | v133091(VarCurr) ) ) ).

fof(writeUnaryOperator_11035,axiom,
    ! [VarCurr] :
      ( ~ v133091(VarCurr)
    <=> v133034(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11034,axiom,
    ! [VarCurr] :
      ( ~ v133090(VarCurr)
    <=> v133034(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26627,axiom,
    ! [VarCurr] :
      ( v133083(VarCurr)
    <=> ( v133084(VarCurr)
        & v133087(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3068,axiom,
    ! [VarCurr] :
      ( v133087(VarCurr)
    <=> ( v133080(VarCurr)
        | v133034(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26626,axiom,
    ! [VarCurr] :
      ( v133084(VarCurr)
    <=> ( v133085(VarCurr)
        | v133086(VarCurr) ) ) ).

fof(writeUnaryOperator_11033,axiom,
    ! [VarCurr] :
      ( ~ v133086(VarCurr)
    <=> v133034(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11032,axiom,
    ! [VarCurr] :
      ( ~ v133085(VarCurr)
    <=> v133080(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26625,axiom,
    ! [VarCurr] :
      ( v133076(VarCurr)
    <=> ( v133077(VarCurr)
        & v133082(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3067,axiom,
    ! [VarCurr] :
      ( v133082(VarCurr)
    <=> ( v133079(VarCurr)
        | v133034(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26624,axiom,
    ! [VarCurr] :
      ( v133077(VarCurr)
    <=> ( v133078(VarCurr)
        | v133081(VarCurr) ) ) ).

fof(writeUnaryOperator_11031,axiom,
    ! [VarCurr] :
      ( ~ v133081(VarCurr)
    <=> v133034(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11030,axiom,
    ! [VarCurr] :
      ( ~ v133078(VarCurr)
    <=> v133079(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3066,axiom,
    ! [VarCurr] :
      ( v133079(VarCurr)
    <=> ( v133080(VarCurr)
        & v133034(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3065,axiom,
    ! [VarCurr] :
      ( v133080(VarCurr)
    <=> ( v133034(VarCurr,bitIndex0)
        & v133034(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26623,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133058(VarNext)
      <=> ( v133059(VarNext)
          & v133066(VarNext) ) ) ) ).

fof(addAssignment_43448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133066(VarNext)
      <=> v133064(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26622,axiom,
    ! [VarCurr] :
      ( v133064(VarCurr)
    <=> ( v133067(VarCurr)
        | v133068(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26621,axiom,
    ! [VarCurr] :
      ( v133068(VarCurr)
    <=> ( v133036(VarCurr)
        & v133069(VarCurr) ) ) ).

fof(writeUnaryOperator_11029,axiom,
    ! [VarCurr] :
      ( ~ v133069(VarCurr)
    <=> v133067(VarCurr) ) ).

fof(writeUnaryOperator_11028,axiom,
    ! [VarCurr] :
      ( ~ v133067(VarCurr)
    <=> v10082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26620,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v133059(VarNext)
      <=> ( v133060(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_11027,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v133060(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(addBitVectorEqualityBitBlasted_9305,axiom,
    ! [VarCurr] :
      ( v133054(VarCurr)
    <=> ( ( v133034(VarCurr,bitIndex3)
        <=> $true )
        & ( v133034(VarCurr,bitIndex2)
        <=> $false )
        & ( v133034(VarCurr,bitIndex1)
        <=> $true )
        & ( v133034(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43447,axiom,
    ! [VarCurr] :
      ( v133036(VarCurr)
    <=> v133038(VarCurr) ) ).

fof(addAssignment_43446,axiom,
    ! [VarCurr] :
      ( v133038(VarCurr)
    <=> v133040(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3064,axiom,
    ! [VarCurr] :
      ( v133040(VarCurr)
    <=> ( v10094(VarCurr,bitIndex7)
        | v133042(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26619,axiom,
    ! [VarCurr] :
      ( v133042(VarCurr)
    <=> ( v133048(VarCurr)
        & v133051(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26618,axiom,
    ! [VarCurr] :
      ( v133051(VarCurr)
    <=> ( v133044(VarCurr)
        | v133046(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26617,axiom,
    ! [VarCurr] :
      ( v133048(VarCurr)
    <=> ( v133049(VarCurr)
        & v133050(VarCurr) ) ) ).

fof(writeUnaryOperator_11026,axiom,
    ! [VarCurr] :
      ( ~ v133050(VarCurr)
    <=> v132686(VarCurr) ) ).

fof(writeUnaryOperator_11025,axiom,
    ! [VarCurr] :
      ( ~ v133049(VarCurr)
    <=> v15307(VarCurr) ) ).

fof(addAssignment_43445,axiom,
    ! [VarCurr] :
      ( v133046(VarCurr)
    <=> v132697(VarCurr) ) ).

fof(addAssignment_43444,axiom,
    ! [VarCurr] :
      ( v133044(VarCurr)
    <=> v132690(VarCurr) ) ).

fof(addAssignment_43443,axiom,
    ! [VarCurr] :
      ( v133001(VarCurr)
    <=> v133003(VarCurr) ) ).

fof(addAssignment_43442,axiom,
    ! [VarCurr] :
      ( v133003(VarCurr)
    <=> v133005(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3187,axiom,
    ! [VarCurr] :
      ( ~ v133008(VarCurr)
     => ( v133005(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2992,axiom,
    ! [VarCurr] :
      ( v133008(VarCurr)
     => ( v133005(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26616,axiom,
    ! [VarCurr] :
      ( v133008(VarCurr)
    <=> ( v133010(VarCurr)
        & v133012(VarCurr) ) ) ).

fof(writeUnaryOperator_11024,axiom,
    ! [VarCurr] :
      ( ~ v133012(VarCurr)
    <=> v4200(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorShiftedRanges_3063,axiom,
    ! [VarCurr] :
      ( v133010(VarCurr)
    <=> ( v133011(VarCurr)
        & v4200(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3062,axiom,
    ! [VarCurr] :
      ( v133011(VarCurr)
    <=> ( v10051(VarCurr)
        & v4200(VarCurr,bitIndex4) ) ) ).

fof(addAssignment_43441,axiom,
    ! [VarCurr] :
      ( v10060(VarCurr)
    <=> v10062(VarCurr) ) ).

fof(addAssignment_43440,axiom,
    ! [VarCurr] :
      ( v10062(VarCurr)
    <=> v10064(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26615,axiom,
    ! [VarCurr] :
      ( v10064(VarCurr)
    <=> ( v132998(VarCurr)
        & v132999(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3061,axiom,
    ! [VarCurr] :
      ( v132999(VarCurr)
    <=> ( v10066(VarCurr,bitIndex5)
      <~> v132927(VarCurr,bitIndex5) ) ) ).

fof(addBitVectorEqualityBitBlasted_9304,axiom,
    ! [VarCurr] :
      ( v132998(VarCurr)
    <=> ( ( v10066(VarCurr,bitIndex4)
        <=> v132927(VarCurr,bitIndex4) )
        & ( v10066(VarCurr,bitIndex3)
        <=> v132927(VarCurr,bitIndex3) )
        & ( v10066(VarCurr,bitIndex2)
        <=> v132927(VarCurr,bitIndex2) )
        & ( v10066(VarCurr,bitIndex1)
        <=> v132927(VarCurr,bitIndex1) )
        & ( v10066(VarCurr,bitIndex0)
        <=> v132927(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_43439,axiom,
    ! [VarNext] :
      ( v132927(VarNext,bitIndex5)
    <=> v132990(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionEqualRanges1_2331,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132992(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v132990(VarNext,B)
            <=> v132927(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2455,axiom,
    ! [VarNext] :
      ( v132992(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v132990(VarNext,B)
          <=> v132955(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26614,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132992(VarNext)
      <=> ( v132993(VarNext)
          & v132949(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26613,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132993(VarNext)
      <=> ( v132995(VarNext)
          & v131325(VarNext) ) ) ) ).

fof(writeUnaryOperator_11023,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132995(VarNext)
      <=> v131332(VarNext) ) ) ).

fof(addAssignment_43438,axiom,
    ! [VarCurr] :
      ( v10066(VarCurr,bitIndex5)
    <=> v10068(VarCurr,bitIndex5) ) ).

fof(addAssignment_43437,axiom,
    ! [VarCurr] :
      ( v10068(VarCurr,bitIndex5)
    <=> v10070(VarCurr,bitIndex5) ) ).

fof(addAssignment_43436,axiom,
    ! [VarCurr] :
      ( v10070(VarCurr,bitIndex5)
    <=> v10072(VarCurr,bitIndex5) ) ).

fof(addAssignment_43435,axiom,
    ! [VarCurr] :
      ( v10072(VarCurr,bitIndex5)
    <=> v10074(VarCurr,bitIndex5) ) ).

fof(addAssignment_43434,axiom,
    ! [VarCurr] :
      ( v10074(VarCurr,bitIndex5)
    <=> v10076(VarCurr,bitIndex5) ) ).

fof(addAssignment_43433,axiom,
    ! [VarCurr] :
      ( v10076(VarCurr,bitIndex5)
    <=> v10078(VarCurr,bitIndex5) ) ).

fof(addAssignment_43432,axiom,
    ! [VarCurr] :
      ( v10078(VarCurr,bitIndex5)
    <=> v132925(VarCurr,bitIndex5) ) ).

fof(addAssignment_43431,axiom,
    ! [VarNext,B] :
      ( range_4_0(B)
     => ( v132927(VarNext,B)
      <=> v132940(VarNext,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2330,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132941(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v132940(VarNext,B)
            <=> v132927(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2454,axiom,
    ! [VarNext] :
      ( v132941(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v132940(VarNext,B)
          <=> v132955(VarNext,B) ) ) ) ).

fof(addAssignment_43430,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v132955(VarNext,B)
          <=> v132953(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5404,axiom,
    ! [VarCurr] :
      ( ~ v132950(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v132953(VarCurr,B)
          <=> v132956(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5393,axiom,
    ! [VarCurr] :
      ( v132950(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v132953(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43429,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr,bitIndex0)
    <=> v132984(VarCurr) ) ).

fof(addAssignment_43428,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr,bitIndex1)
    <=> v132982(VarCurr) ) ).

fof(addAssignment_43427,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr,bitIndex2)
    <=> v132977(VarCurr) ) ).

fof(addAssignment_43426,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr,bitIndex3)
    <=> v132972(VarCurr) ) ).

fof(addAssignment_43425,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr,bitIndex4)
    <=> v132967(VarCurr) ) ).

fof(addAssignment_43424,axiom,
    ! [VarCurr] :
      ( v132956(VarCurr,bitIndex5)
    <=> v132958(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26612,axiom,
    ! [VarCurr] :
      ( v132982(VarCurr)
    <=> ( v132983(VarCurr)
        & v132986(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3060,axiom,
    ! [VarCurr] :
      ( v132986(VarCurr)
    <=> ( v132927(VarCurr,bitIndex0)
        | v132927(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26611,axiom,
    ! [VarCurr] :
      ( v132983(VarCurr)
    <=> ( v132984(VarCurr)
        | v132985(VarCurr) ) ) ).

fof(writeUnaryOperator_11022,axiom,
    ! [VarCurr] :
      ( ~ v132985(VarCurr)
    <=> v132927(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11021,axiom,
    ! [VarCurr] :
      ( ~ v132984(VarCurr)
    <=> v132927(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26610,axiom,
    ! [VarCurr] :
      ( v132977(VarCurr)
    <=> ( v132978(VarCurr)
        & v132981(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3059,axiom,
    ! [VarCurr] :
      ( v132981(VarCurr)
    <=> ( v132964(VarCurr)
        | v132927(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26609,axiom,
    ! [VarCurr] :
      ( v132978(VarCurr)
    <=> ( v132979(VarCurr)
        | v132980(VarCurr) ) ) ).

fof(writeUnaryOperator_11020,axiom,
    ! [VarCurr] :
      ( ~ v132980(VarCurr)
    <=> v132927(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11019,axiom,
    ! [VarCurr] :
      ( ~ v132979(VarCurr)
    <=> v132964(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26608,axiom,
    ! [VarCurr] :
      ( v132972(VarCurr)
    <=> ( v132973(VarCurr)
        & v132976(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3058,axiom,
    ! [VarCurr] :
      ( v132976(VarCurr)
    <=> ( v132963(VarCurr)
        | v132927(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26607,axiom,
    ! [VarCurr] :
      ( v132973(VarCurr)
    <=> ( v132974(VarCurr)
        | v132975(VarCurr) ) ) ).

fof(writeUnaryOperator_11018,axiom,
    ! [VarCurr] :
      ( ~ v132975(VarCurr)
    <=> v132927(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11017,axiom,
    ! [VarCurr] :
      ( ~ v132974(VarCurr)
    <=> v132963(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26606,axiom,
    ! [VarCurr] :
      ( v132967(VarCurr)
    <=> ( v132968(VarCurr)
        & v132971(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3057,axiom,
    ! [VarCurr] :
      ( v132971(VarCurr)
    <=> ( v132962(VarCurr)
        | v132927(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26605,axiom,
    ! [VarCurr] :
      ( v132968(VarCurr)
    <=> ( v132969(VarCurr)
        | v132970(VarCurr) ) ) ).

fof(writeUnaryOperator_11016,axiom,
    ! [VarCurr] :
      ( ~ v132970(VarCurr)
    <=> v132927(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11015,axiom,
    ! [VarCurr] :
      ( ~ v132969(VarCurr)
    <=> v132962(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26604,axiom,
    ! [VarCurr] :
      ( v132958(VarCurr)
    <=> ( v132959(VarCurr)
        & v132966(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3056,axiom,
    ! [VarCurr] :
      ( v132966(VarCurr)
    <=> ( v132961(VarCurr)
        | v132927(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26603,axiom,
    ! [VarCurr] :
      ( v132959(VarCurr)
    <=> ( v132960(VarCurr)
        | v132965(VarCurr) ) ) ).

fof(writeUnaryOperator_11014,axiom,
    ! [VarCurr] :
      ( ~ v132965(VarCurr)
    <=> v132927(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_11013,axiom,
    ! [VarCurr] :
      ( ~ v132960(VarCurr)
    <=> v132961(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3055,axiom,
    ! [VarCurr] :
      ( v132961(VarCurr)
    <=> ( v132962(VarCurr)
        & v132927(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3054,axiom,
    ! [VarCurr] :
      ( v132962(VarCurr)
    <=> ( v132963(VarCurr)
        & v132927(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3053,axiom,
    ! [VarCurr] :
      ( v132963(VarCurr)
    <=> ( v132964(VarCurr)
        & v132927(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3052,axiom,
    ! [VarCurr] :
      ( v132964(VarCurr)
    <=> ( v132927(VarCurr,bitIndex0)
        & v132927(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26602,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132941(VarNext)
      <=> ( v132942(VarNext)
          & v132949(VarNext) ) ) ) ).

fof(addAssignment_43423,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132949(VarNext)
      <=> v132947(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26601,axiom,
    ! [VarCurr] :
      ( v132947(VarCurr)
    <=> ( v132950(VarCurr)
        | v132951(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26600,axiom,
    ! [VarCurr] :
      ( v132951(VarCurr)
    <=> ( v132929(VarCurr)
        & v132952(VarCurr) ) ) ).

fof(writeUnaryOperator_11012,axiom,
    ! [VarCurr] :
      ( ~ v132952(VarCurr)
    <=> v132950(VarCurr) ) ).

fof(writeUnaryOperator_11011,axiom,
    ! [VarCurr] :
      ( ~ v132950(VarCurr)
    <=> v15405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26599,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132942(VarNext)
      <=> ( v132943(VarNext)
          & v131325(VarNext) ) ) ) ).

fof(writeUnaryOperator_11010,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132943(VarNext)
      <=> v131332(VarNext) ) ) ).

fof(addAssignment_43422,axiom,
    ! [VarCurr] :
      ( v132929(VarCurr)
    <=> v132931(VarCurr) ) ).

fof(addAssignment_43421,axiom,
    ! [VarCurr] :
      ( v132931(VarCurr)
    <=> v132933(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26598,axiom,
    ! [VarCurr] :
      ( v132933(VarCurr)
    <=> ( v132938(VarCurr)
        & v132935(VarCurr) ) ) ).

fof(writeUnaryOperator_11009,axiom,
    ! [VarCurr] :
      ( ~ v132938(VarCurr)
    <=> v15413(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9303,axiom,
    ! [VarCurr] :
      ( v132935(VarCurr)
    <=> ( ( v129443(VarCurr,bitIndex1)
        <=> $false )
        & ( v129443(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43420,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10066(VarCurr,B)
      <=> v10068(VarCurr,B) ) ) ).

fof(addAssignment_43419,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10068(VarCurr,B)
      <=> v10070(VarCurr,B) ) ) ).

fof(addAssignment_43418,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10070(VarCurr,B)
      <=> v10072(VarCurr,B) ) ) ).

fof(addAssignment_43417,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10072(VarCurr,B)
      <=> v10074(VarCurr,B) ) ) ).

fof(addAssignment_43416,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10074(VarCurr,B)
      <=> v10076(VarCurr,B) ) ) ).

fof(addAssignment_43415,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10076(VarCurr,B)
      <=> v10078(VarCurr,B) ) ) ).

fof(addAssignment_43414,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v10078(VarCurr,B)
      <=> v132925(VarCurr,B) ) ) ).

fof(addAssignment_43413,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v132925(VarCurr,B)
      <=> v10080(VarCurr,B) ) ) ).

fof(addAssignment_43412,axiom,
    ! [VarCurr] :
      ( v132925(VarCurr,bitIndex5)
    <=> v15332(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2329,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132884(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v10080(VarNext,B)
            <=> v10080(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2453,axiom,
    ! [VarNext] :
      ( v132884(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v10080(VarNext,B)
          <=> v132897(VarNext,B) ) ) ) ).

fof(addAssignment_43411,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132897(VarNext,B)
          <=> v132895(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5403,axiom,
    ! [VarCurr] :
      ( ~ v15348(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132895(VarCurr,B)
          <=> v132898(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5392,axiom,
    ! [VarCurr] :
      ( v15348(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132895(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_43410,axiom,
    ! [VarCurr] :
      ( v132898(VarCurr,bitIndex0)
    <=> v132920(VarCurr) ) ).

fof(addAssignment_43409,axiom,
    ! [VarCurr] :
      ( v132898(VarCurr,bitIndex1)
    <=> v132918(VarCurr) ) ).

fof(addAssignment_43408,axiom,
    ! [VarCurr] :
      ( v132898(VarCurr,bitIndex2)
    <=> v132913(VarCurr) ) ).

fof(addAssignment_43407,axiom,
    ! [VarCurr] :
      ( v132898(VarCurr,bitIndex3)
    <=> v132908(VarCurr) ) ).

fof(addAssignment_43406,axiom,
    ! [VarCurr] :
      ( v132898(VarCurr,bitIndex4)
    <=> v132900(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26597,axiom,
    ! [VarCurr] :
      ( v132918(VarCurr)
    <=> ( v132919(VarCurr)
        & v132922(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3051,axiom,
    ! [VarCurr] :
      ( v132922(VarCurr)
    <=> ( v10080(VarCurr,bitIndex0)
        | v10080(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26596,axiom,
    ! [VarCurr] :
      ( v132919(VarCurr)
    <=> ( v132920(VarCurr)
        | v132921(VarCurr) ) ) ).

fof(writeUnaryOperator_11008,axiom,
    ! [VarCurr] :
      ( ~ v132921(VarCurr)
    <=> v10080(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_11007,axiom,
    ! [VarCurr] :
      ( ~ v132920(VarCurr)
    <=> v10080(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26595,axiom,
    ! [VarCurr] :
      ( v132913(VarCurr)
    <=> ( v132914(VarCurr)
        & v132917(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3050,axiom,
    ! [VarCurr] :
      ( v132917(VarCurr)
    <=> ( v132905(VarCurr)
        | v10080(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26594,axiom,
    ! [VarCurr] :
      ( v132914(VarCurr)
    <=> ( v132915(VarCurr)
        | v132916(VarCurr) ) ) ).

fof(writeUnaryOperator_11006,axiom,
    ! [VarCurr] :
      ( ~ v132916(VarCurr)
    <=> v10080(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_11005,axiom,
    ! [VarCurr] :
      ( ~ v132915(VarCurr)
    <=> v132905(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26593,axiom,
    ! [VarCurr] :
      ( v132908(VarCurr)
    <=> ( v132909(VarCurr)
        & v132912(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3049,axiom,
    ! [VarCurr] :
      ( v132912(VarCurr)
    <=> ( v132904(VarCurr)
        | v10080(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26592,axiom,
    ! [VarCurr] :
      ( v132909(VarCurr)
    <=> ( v132910(VarCurr)
        | v132911(VarCurr) ) ) ).

fof(writeUnaryOperator_11004,axiom,
    ! [VarCurr] :
      ( ~ v132911(VarCurr)
    <=> v10080(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_11003,axiom,
    ! [VarCurr] :
      ( ~ v132910(VarCurr)
    <=> v132904(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26591,axiom,
    ! [VarCurr] :
      ( v132900(VarCurr)
    <=> ( v132901(VarCurr)
        & v132907(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3048,axiom,
    ! [VarCurr] :
      ( v132907(VarCurr)
    <=> ( v132903(VarCurr)
        | v10080(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26590,axiom,
    ! [VarCurr] :
      ( v132901(VarCurr)
    <=> ( v132902(VarCurr)
        | v132906(VarCurr) ) ) ).

fof(writeUnaryOperator_11002,axiom,
    ! [VarCurr] :
      ( ~ v132906(VarCurr)
    <=> v10080(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_11001,axiom,
    ! [VarCurr] :
      ( ~ v132902(VarCurr)
    <=> v132903(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3047,axiom,
    ! [VarCurr] :
      ( v132903(VarCurr)
    <=> ( v132904(VarCurr)
        & v10080(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3046,axiom,
    ! [VarCurr] :
      ( v132904(VarCurr)
    <=> ( v132905(VarCurr)
        & v10080(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3045,axiom,
    ! [VarCurr] :
      ( v132905(VarCurr)
    <=> ( v10080(VarCurr,bitIndex0)
        & v10080(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26589,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132884(VarNext)
      <=> ( v132885(VarNext)
          & v132892(VarNext) ) ) ) ).

fof(addAssignment_43405,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132892(VarNext)
      <=> v132890(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26588,axiom,
    ! [VarCurr] :
      ( v132890(VarCurr)
    <=> ( v15348(VarCurr)
        | v132893(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26587,axiom,
    ! [VarCurr] :
      ( v132893(VarCurr)
    <=> ( v10088(VarCurr)
        & v132894(VarCurr) ) ) ).

fof(writeUnaryOperator_11000,axiom,
    ! [VarCurr] :
      ( ~ v132894(VarCurr)
    <=> v15348(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26586,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132885(VarNext)
      <=> ( v132887(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_10999,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132887(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(addAssignment_43404,axiom,
    ! [VarCurr] :
      ( v10088(VarCurr)
    <=> v10090(VarCurr) ) ).

fof(addAssignment_43403,axiom,
    ! [VarCurr] :
      ( v10090(VarCurr)
    <=> v10092(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3044,axiom,
    ! [VarCurr] :
      ( v10092(VarCurr)
    <=> ( v10094(VarCurr,bitIndex3)
        | v132874(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26585,axiom,
    ! [VarCurr] :
      ( v132874(VarCurr)
    <=> ( v132878(VarCurr)
        & v132876(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26584,axiom,
    ! [VarCurr] :
      ( v132878(VarCurr)
    <=> ( v132879(VarCurr)
        & v132880(VarCurr) ) ) ).

fof(writeUnaryOperator_10998,axiom,
    ! [VarCurr] :
      ( ~ v132880(VarCurr)
    <=> v132646(VarCurr) ) ).

fof(writeUnaryOperator_10997,axiom,
    ! [VarCurr] :
      ( ~ v132879(VarCurr)
    <=> v15307(VarCurr) ) ).

fof(addAssignment_43402,axiom,
    ! [VarCurr] :
      ( v132876(VarCurr)
    <=> v132677(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_585,axiom,
    ! [VarCurr] :
      ( ~ v132868(VarCurr)
     => ( v10094(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_780,axiom,
    ! [VarCurr] :
      ( v132868(VarCurr)
     => ( v10094(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26583,axiom,
    ! [VarCurr] :
      ( v132868(VarCurr)
    <=> ( v132869(VarCurr)
        | v132871(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26582,axiom,
    ! [VarCurr] :
      ( v132871(VarCurr)
    <=> ( v132872(VarCurr)
        & v132858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26581,axiom,
    ! [VarCurr] :
      ( v132872(VarCurr)
    <=> ( v10096(VarCurr)
        & v131422(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26580,axiom,
    ! [VarCurr] :
      ( v132869(VarCurr)
    <=> ( v132870(VarCurr)
        & v132853(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26579,axiom,
    ! [VarCurr] :
      ( v132870(VarCurr)
    <=> ( v10096(VarCurr)
        & v131422(VarCurr) ) ) ).

fof(addAssignment_43401,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex4)
    <=> v132860(VarNext,bitIndex3) ) ).

fof(addCaseBooleanConditionShiftedRanges1_139,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132861(VarNext)
       => ( ( v132860(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v132860(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v132860(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v132860(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v132860(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v132860(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v132860(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v132860(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v132860(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v132860(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v132860(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v132860(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v132860(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v132860(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v132860(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v132860(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v132860(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v132860(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v132860(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v132860(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2452,axiom,
    ! [VarNext] :
      ( v132861(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v132860(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26578,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132861(VarNext)
      <=> v132862(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26577,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132862(VarNext)
      <=> ( v132864(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10996,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132864(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_584,axiom,
    ! [VarCurr] :
      ( ~ v132848(VarCurr)
     => ( v10094(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_779,axiom,
    ! [VarCurr] :
      ( v132848(VarCurr)
     => ( v10094(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26576,axiom,
    ! [VarCurr] :
      ( v132848(VarCurr)
    <=> ( v132849(VarCurr)
        | v132854(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26575,axiom,
    ! [VarCurr] :
      ( v132854(VarCurr)
    <=> ( v132855(VarCurr)
        & v132858(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9302,axiom,
    ! [VarCurr] :
      ( v132858(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26574,axiom,
    ! [VarCurr] :
      ( v132855(VarCurr)
    <=> ( v132856(VarCurr)
        | v132857(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26573,axiom,
    ! [VarCurr] :
      ( v132857(VarCurr)
    <=> ( v10096(VarCurr)
        & v131463(VarCurr) ) ) ).

fof(writeUnaryOperator_10995,axiom,
    ! [VarCurr] :
      ( ~ v132856(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26572,axiom,
    ! [VarCurr] :
      ( v132849(VarCurr)
    <=> ( v132850(VarCurr)
        & v132853(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9301,axiom,
    ! [VarCurr] :
      ( v132853(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26571,axiom,
    ! [VarCurr] :
      ( v132850(VarCurr)
    <=> ( v132851(VarCurr)
        | v132852(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26570,axiom,
    ! [VarCurr] :
      ( v132852(VarCurr)
    <=> ( v10096(VarCurr)
        & v131463(VarCurr) ) ) ).

fof(writeUnaryOperator_10994,axiom,
    ! [VarCurr] :
      ( ~ v132851(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(addAssignment_43400,axiom,
    ! [VarCurr] :
      ( v10096(VarCurr)
    <=> v10098(VarCurr) ) ).

fof(addAssignment_43399,axiom,
    ! [VarCurr] :
      ( v10098(VarCurr)
    <=> v10100(VarCurr) ) ).

fof(addAssignment_43398,axiom,
    ! [VarCurr] :
      ( v10100(VarCurr)
    <=> v10102(VarCurr,bitIndex1) ) ).

fof(addAssignment_43397,axiom,
    ! [VarCurr] :
      ( v10102(VarCurr,bitIndex1)
    <=> v114180(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorShiftedRanges_3043,axiom,
    ! [VarCurr] :
      ( v114179(VarCurr,bitIndex1)
    <=> ( v114179(VarCurr,bitIndex0)
        | v10104(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43396,axiom,
    ! [VarCurr] :
      ( v10104(VarCurr,bitIndex1)
    <=> v114177(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26569,axiom,
    ! [VarCurr] :
      ( v10106(VarCurr)
    <=> ( v132842(VarCurr)
        & v132845(VarCurr) ) ) ).

fof(writeUnaryOperator_10993,axiom,
    ! [VarCurr] :
      ( ~ v132845(VarCurr)
    <=> v132837(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26568,axiom,
    ! [VarCurr] :
      ( v132842(VarCurr)
    <=> ( v132843(VarCurr)
        & v132844(VarCurr) ) ) ).

fof(writeUnaryOperator_10992,axiom,
    ! [VarCurr] :
      ( ~ v132844(VarCurr)
    <=> v114166(VarCurr) ) ).

fof(writeUnaryOperator_10991,axiom,
    ! [VarCurr] :
      ( ~ v132843(VarCurr)
    <=> v10108(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26567,axiom,
    ! [VarCurr] :
      ( v132837(VarCurr)
    <=> ( v132839(VarCurr)
        | v132711(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26566,axiom,
    ! [VarCurr] :
      ( v132839(VarCurr)
    <=> ( v114183(VarCurr)
        & v132840(VarCurr) ) ) ).

fof(writeUnaryOperator_10990,axiom,
    ! [VarCurr] :
      ( ~ v132840(VarCurr)
    <=> v114315(VarCurr) ) ).

fof(addAssignment_43395,axiom,
    ! [VarCurr] :
      ( v10108(VarCurr)
    <=> v10110(VarCurr) ) ).

fof(addAssignment_43394,axiom,
    ! [VarCurr] :
      ( v10110(VarCurr)
    <=> v10112(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9300,axiom,
    ! [VarCurr] :
      ( v10112(VarCurr)
    <=> ( ( v10114(VarCurr,bitIndex4)
        <=> $false )
        & ( v10114(VarCurr,bitIndex3)
        <=> $false )
        & ( v10114(VarCurr,bitIndex2)
        <=> $false )
        & ( v10114(VarCurr,bitIndex1)
        <=> $false )
        & ( v10114(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2328,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132823(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v10114(VarNext,B)
            <=> v10114(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2451,axiom,
    ! [VarNext] :
      ( v132823(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v10114(VarNext,B)
          <=> v132831(VarNext,B) ) ) ) ).

fof(addAssignment_43393,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132831(VarNext,B)
          <=> v132829(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3186,axiom,
    ! [VarCurr] :
      ( ~ v132832(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132829(VarCurr,B)
          <=> v10118(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2991,axiom,
    ! [VarCurr] :
      ( v132832(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132829(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_10989,axiom,
    ! [VarCurr] :
      ( ~ v132832(VarCurr)
    <=> v10116(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26565,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132823(VarNext)
      <=> v132824(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26564,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132824(VarNext)
      <=> ( v132825(VarNext)
          & v13233(VarNext) ) ) ) ).

fof(writeUnaryOperator_10988,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132825(VarNext)
      <=> v15207(VarNext) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_185,axiom,
    ! [VarCurr] :
      ( ( ~ v132747(VarCurr)
        & ~ v132749(VarCurr)
        & ~ v132790(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v10118(VarCurr,B)
          <=> v10114(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1316,axiom,
    ! [VarCurr] :
      ( v132790(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v10118(VarCurr,B)
          <=> v132792(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5402,axiom,
    ! [VarCurr] :
      ( v132749(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v10118(VarCurr,B)
          <=> v132751(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5391,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v10118(VarCurr,B)
          <=> v10114(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9299,axiom,
    ! [VarCurr] :
      ( v132819(VarCurr)
    <=> ( ( v132820(VarCurr,bitIndex1)
        <=> $true )
        & ( v132820(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43392,axiom,
    ! [VarCurr] :
      ( v132820(VarCurr,bitIndex0)
    <=> v11285(VarCurr) ) ).

fof(addAssignment_43391,axiom,
    ! [VarCurr] :
      ( v132820(VarCurr,bitIndex1)
    <=> v10120(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3185,axiom,
    ! [VarCurr] :
      ( ~ v132793(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132792(VarCurr,B)
          <=> v132794(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2990,axiom,
    ! [VarCurr] :
      ( v132793(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132792(VarCurr,B)
          <=> b01010(B) ) ) ) ).

fof(addAssignment_43390,axiom,
    ! [VarCurr] :
      ( v132794(VarCurr,bitIndex0)
    <=> v132816(VarCurr) ) ).

fof(addAssignment_43389,axiom,
    ! [VarCurr] :
      ( v132794(VarCurr,bitIndex1)
    <=> v132814(VarCurr) ) ).

fof(addAssignment_43388,axiom,
    ! [VarCurr] :
      ( v132794(VarCurr,bitIndex2)
    <=> v132809(VarCurr) ) ).

fof(addAssignment_43387,axiom,
    ! [VarCurr] :
      ( v132794(VarCurr,bitIndex3)
    <=> v132804(VarCurr) ) ).

fof(addAssignment_43386,axiom,
    ! [VarCurr] :
      ( v132794(VarCurr,bitIndex4)
    <=> v132796(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26563,axiom,
    ! [VarCurr] :
      ( v132814(VarCurr)
    <=> ( v132815(VarCurr)
        & v132818(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3042,axiom,
    ! [VarCurr] :
      ( v132818(VarCurr)
    <=> ( v10114(VarCurr,bitIndex0)
        | v10114(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26562,axiom,
    ! [VarCurr] :
      ( v132815(VarCurr)
    <=> ( v132816(VarCurr)
        | v132817(VarCurr) ) ) ).

fof(writeUnaryOperator_10987,axiom,
    ! [VarCurr] :
      ( ~ v132817(VarCurr)
    <=> v10114(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10986,axiom,
    ! [VarCurr] :
      ( ~ v132816(VarCurr)
    <=> v10114(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26561,axiom,
    ! [VarCurr] :
      ( v132809(VarCurr)
    <=> ( v132810(VarCurr)
        & v132813(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3041,axiom,
    ! [VarCurr] :
      ( v132813(VarCurr)
    <=> ( v132801(VarCurr)
        | v10114(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26560,axiom,
    ! [VarCurr] :
      ( v132810(VarCurr)
    <=> ( v132811(VarCurr)
        | v132812(VarCurr) ) ) ).

fof(writeUnaryOperator_10985,axiom,
    ! [VarCurr] :
      ( ~ v132812(VarCurr)
    <=> v10114(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10984,axiom,
    ! [VarCurr] :
      ( ~ v132811(VarCurr)
    <=> v132801(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26559,axiom,
    ! [VarCurr] :
      ( v132804(VarCurr)
    <=> ( v132805(VarCurr)
        & v132808(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3040,axiom,
    ! [VarCurr] :
      ( v132808(VarCurr)
    <=> ( v132800(VarCurr)
        | v10114(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26558,axiom,
    ! [VarCurr] :
      ( v132805(VarCurr)
    <=> ( v132806(VarCurr)
        | v132807(VarCurr) ) ) ).

fof(writeUnaryOperator_10983,axiom,
    ! [VarCurr] :
      ( ~ v132807(VarCurr)
    <=> v10114(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10982,axiom,
    ! [VarCurr] :
      ( ~ v132806(VarCurr)
    <=> v132800(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26557,axiom,
    ! [VarCurr] :
      ( v132796(VarCurr)
    <=> ( v132797(VarCurr)
        & v132803(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3039,axiom,
    ! [VarCurr] :
      ( v132803(VarCurr)
    <=> ( v132799(VarCurr)
        | v10114(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26556,axiom,
    ! [VarCurr] :
      ( v132797(VarCurr)
    <=> ( v132798(VarCurr)
        | v132802(VarCurr) ) ) ).

fof(writeUnaryOperator_10981,axiom,
    ! [VarCurr] :
      ( ~ v132802(VarCurr)
    <=> v10114(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10980,axiom,
    ! [VarCurr] :
      ( ~ v132798(VarCurr)
    <=> v132799(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3038,axiom,
    ! [VarCurr] :
      ( v132799(VarCurr)
    <=> ( v132800(VarCurr)
        & v10114(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3037,axiom,
    ! [VarCurr] :
      ( v132800(VarCurr)
    <=> ( v132801(VarCurr)
        & v10114(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3036,axiom,
    ! [VarCurr] :
      ( v132801(VarCurr)
    <=> ( v10114(VarCurr,bitIndex0)
        & v10114(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9298,axiom,
    ! [VarCurr] :
      ( v132793(VarCurr)
    <=> ( ( v10114(VarCurr,bitIndex4)
        <=> $false )
        & ( v10114(VarCurr,bitIndex3)
        <=> $true )
        & ( v10114(VarCurr,bitIndex2)
        <=> $false )
        & ( v10114(VarCurr,bitIndex1)
        <=> $true )
        & ( v10114(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9297,axiom,
    ! [VarCurr] :
      ( v132790(VarCurr)
    <=> ( ( v132791(VarCurr,bitIndex1)
        <=> $true )
        & ( v132791(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43385,axiom,
    ! [VarCurr] :
      ( v132791(VarCurr,bitIndex0)
    <=> v11285(VarCurr) ) ).

fof(addAssignment_43384,axiom,
    ! [VarCurr] :
      ( v132791(VarCurr,bitIndex1)
    <=> v10120(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3184,axiom,
    ! [VarCurr] :
      ( ~ v132752(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132751(VarCurr,B)
          <=> v132753(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2989,axiom,
    ! [VarCurr] :
      ( v132752(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132751(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_159,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex6)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_158,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex7)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_157,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex8)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_156,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex9)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_155,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex10)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_154,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex11)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_153,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex12)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_152,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex13)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_151,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex14)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_150,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex15)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_149,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex16)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_148,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex17)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_147,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex18)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_146,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex19)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_145,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex20)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_144,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex21)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_143,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex22)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_142,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex23)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_141,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex24)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_140,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex25)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_139,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex26)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_138,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex27)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_137,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex28)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_136,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex29)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_135,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex30)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_134,axiom,
    ! [VarCurr] :
      ( v132753(VarCurr,bitIndex31)
    <=> v132754(VarCurr,bitIndex5) ) ).

fof(addAssignment_43383,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v132753(VarCurr,B)
      <=> v132754(VarCurr,B) ) ) ).

fof(addAssignment_43382,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr,bitIndex0)
    <=> v132788(VarCurr) ) ).

fof(addAssignment_43381,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr,bitIndex1)
    <=> v132786(VarCurr) ) ).

fof(addAssignment_43380,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr,bitIndex2)
    <=> v132782(VarCurr) ) ).

fof(addAssignment_43379,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr,bitIndex3)
    <=> v132778(VarCurr) ) ).

fof(addAssignment_43378,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr,bitIndex4)
    <=> v132774(VarCurr) ) ).

fof(addAssignment_43377,axiom,
    ! [VarCurr] :
      ( v132754(VarCurr,bitIndex5)
    <=> v132756(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26555,axiom,
    ! [VarCurr] :
      ( v132786(VarCurr)
    <=> ( v132787(VarCurr)
        & v132789(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26554,axiom,
    ! [VarCurr] :
      ( v132789(VarCurr)
    <=> ( v132760(VarCurr,bitIndex0)
        | v132768(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3035,axiom,
    ! [VarCurr] :
      ( v132787(VarCurr)
    <=> ( v132788(VarCurr)
        | v132760(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_10979,axiom,
    ! [VarCurr] :
      ( ~ v132788(VarCurr)
    <=> v132760(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26553,axiom,
    ! [VarCurr] :
      ( v132782(VarCurr)
    <=> ( v132783(VarCurr)
        & v132785(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26552,axiom,
    ! [VarCurr] :
      ( v132785(VarCurr)
    <=> ( v132766(VarCurr)
        | v132769(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3034,axiom,
    ! [VarCurr] :
      ( v132783(VarCurr)
    <=> ( v132784(VarCurr)
        | v132760(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10978,axiom,
    ! [VarCurr] :
      ( ~ v132784(VarCurr)
    <=> v132766(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26551,axiom,
    ! [VarCurr] :
      ( v132778(VarCurr)
    <=> ( v132779(VarCurr)
        & v132781(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26550,axiom,
    ! [VarCurr] :
      ( v132781(VarCurr)
    <=> ( v132764(VarCurr)
        | v132770(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3033,axiom,
    ! [VarCurr] :
      ( v132779(VarCurr)
    <=> ( v132780(VarCurr)
        | v132760(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_10977,axiom,
    ! [VarCurr] :
      ( ~ v132780(VarCurr)
    <=> v132764(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26549,axiom,
    ! [VarCurr] :
      ( v132774(VarCurr)
    <=> ( v132775(VarCurr)
        & v132777(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26548,axiom,
    ! [VarCurr] :
      ( v132777(VarCurr)
    <=> ( v132762(VarCurr)
        | v132771(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3032,axiom,
    ! [VarCurr] :
      ( v132775(VarCurr)
    <=> ( v132776(VarCurr)
        | v132760(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_10976,axiom,
    ! [VarCurr] :
      ( ~ v132776(VarCurr)
    <=> v132762(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26547,axiom,
    ! [VarCurr] :
      ( v132756(VarCurr)
    <=> ( v132757(VarCurr)
        & v132772(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26546,axiom,
    ! [VarCurr] :
      ( v132772(VarCurr)
    <=> ( v132759(VarCurr)
        | v132773(VarCurr) ) ) ).

fof(writeUnaryOperator_10975,axiom,
    ! [VarCurr] :
      ( ~ v132773(VarCurr)
    <=> v132760(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_3031,axiom,
    ! [VarCurr] :
      ( v132757(VarCurr)
    <=> ( v132758(VarCurr)
        | v132760(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_10974,axiom,
    ! [VarCurr] :
      ( ~ v132758(VarCurr)
    <=> v132759(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3030,axiom,
    ! [VarCurr] :
      ( v132759(VarCurr)
    <=> ( v132760(VarCurr,bitIndex4)
        | v132761(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26545,axiom,
    ! [VarCurr] :
      ( v132761(VarCurr)
    <=> ( v132762(VarCurr)
        & v132771(VarCurr) ) ) ).

fof(writeUnaryOperator_10973,axiom,
    ! [VarCurr] :
      ( ~ v132771(VarCurr)
    <=> v132760(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_3029,axiom,
    ! [VarCurr] :
      ( v132762(VarCurr)
    <=> ( v132760(VarCurr,bitIndex3)
        | v132763(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26544,axiom,
    ! [VarCurr] :
      ( v132763(VarCurr)
    <=> ( v132764(VarCurr)
        & v132770(VarCurr) ) ) ).

fof(writeUnaryOperator_10972,axiom,
    ! [VarCurr] :
      ( ~ v132770(VarCurr)
    <=> v132760(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_3028,axiom,
    ! [VarCurr] :
      ( v132764(VarCurr)
    <=> ( v132760(VarCurr,bitIndex2)
        | v132765(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26543,axiom,
    ! [VarCurr] :
      ( v132765(VarCurr)
    <=> ( v132766(VarCurr)
        & v132769(VarCurr) ) ) ).

fof(writeUnaryOperator_10971,axiom,
    ! [VarCurr] :
      ( ~ v132769(VarCurr)
    <=> v132760(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3027,axiom,
    ! [VarCurr] :
      ( v132766(VarCurr)
    <=> ( v132760(VarCurr,bitIndex1)
        | v132767(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26542,axiom,
    ! [VarCurr] :
      ( v132767(VarCurr)
    <=> ( v132760(VarCurr,bitIndex0)
        & v132768(VarCurr) ) ) ).

fof(writeUnaryOperator_10970,axiom,
    ! [VarCurr] :
      ( ~ v132768(VarCurr)
    <=> v132760(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_12,axiom,
    ! [VarCurr] : ~ v132760(VarCurr,bitIndex5) ).

fof(addAssignment_43376,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v132760(VarCurr,B)
      <=> v10114(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_9296,axiom,
    ! [VarCurr] :
      ( v132752(VarCurr)
    <=> ( ( v10114(VarCurr,bitIndex4)
        <=> $false )
        & ( v10114(VarCurr,bitIndex3)
        <=> $false )
        & ( v10114(VarCurr,bitIndex2)
        <=> $false )
        & ( v10114(VarCurr,bitIndex1)
        <=> $false )
        & ( v10114(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9295,axiom,
    ! [VarCurr] :
      ( v132749(VarCurr)
    <=> ( ( v132750(VarCurr,bitIndex1)
        <=> $false )
        & ( v132750(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_43375,axiom,
    ! [VarCurr] :
      ( v132750(VarCurr,bitIndex0)
    <=> v11285(VarCurr) ) ).

fof(addAssignment_43374,axiom,
    ! [VarCurr] :
      ( v132750(VarCurr,bitIndex1)
    <=> v10120(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9294,axiom,
    ! [VarCurr] :
      ( v132747(VarCurr)
    <=> ( ( v132748(VarCurr,bitIndex1)
        <=> $false )
        & ( v132748(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43373,axiom,
    ! [VarCurr] :
      ( v132748(VarCurr,bitIndex0)
    <=> v11285(VarCurr) ) ).

fof(addAssignment_43372,axiom,
    ! [VarCurr] :
      ( v132748(VarCurr,bitIndex1)
    <=> v10120(VarCurr) ) ).

fof(addAssignment_43371,axiom,
    ! [VarCurr] :
      ( v11285(VarCurr)
    <=> v11287(VarCurr) ) ).

fof(addAssignment_43370,axiom,
    ! [VarCurr] :
      ( v11287(VarCurr)
    <=> v11289(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26541,axiom,
    ! [VarCurr] :
      ( v11289(VarCurr)
    <=> ( v132740(VarCurr)
        | v132711(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26540,axiom,
    ! [VarCurr] :
      ( v132740(VarCurr)
    <=> ( v132741(VarCurr)
        | v132640(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3026,axiom,
    ! [VarCurr] :
      ( v132741(VarCurr)
    <=> ( v132742(VarCurr)
        | v11291(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26539,axiom,
    ! [VarCurr] :
      ( v132742(VarCurr)
    <=> ( v132743(VarCurr)
        | v131866(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26538,axiom,
    ! [VarCurr] :
      ( v132743(VarCurr)
    <=> ( v132744(VarCurr)
        | v132528(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3025,axiom,
    ! [VarCurr] :
      ( v132744(VarCurr)
    <=> ( v132745(VarCurr)
        | v11291(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3024,axiom,
    ! [VarCurr] :
      ( v132745(VarCurr)
    <=> ( v11291(VarCurr,bitIndex3)
        | v11291(VarCurr,bitIndex6) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132727(VarNext)
       => ( v132711(VarNext)
        <=> v132711(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2450,axiom,
    ! [VarNext] :
      ( v132727(VarNext)
     => ( v132711(VarNext)
      <=> v132735(VarNext) ) ) ).

fof(addAssignment_43369,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132735(VarNext)
      <=> v132733(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3183,axiom,
    ! [VarCurr] :
      ( ~ v132736(VarCurr)
     => ( v132733(VarCurr)
      <=> v132713(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2988,axiom,
    ! [VarCurr] :
      ( v132736(VarCurr)
     => ( v132733(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_10969,axiom,
    ! [VarCurr] :
      ( ~ v132736(VarCurr)
    <=> v13212(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26537,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132727(VarNext)
      <=> v132728(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26536,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132728(VarNext)
      <=> ( v132729(VarNext)
          & v114249(VarNext) ) ) ) ).

fof(writeUnaryOperator_10968,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132729(VarNext)
      <=> v114256(VarNext) ) ) ).

fof(addAssignmentInitValueVector_43,axiom,
    ( v132711(constB0)
  <=> $false ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26535,axiom,
    ! [VarCurr] :
      ( v132713(VarCurr)
    <=> ( v132723(VarCurr)
        & v132724(VarCurr) ) ) ).

fof(writeUnaryOperator_10967,axiom,
    ! [VarCurr] :
      ( ~ v132724(VarCurr)
    <=> v114183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26534,axiom,
    ! [VarCurr] :
      ( v132723(VarCurr)
    <=> ( v10100(VarCurr)
        & v132715(VarCurr) ) ) ).

fof(addAssignment_43368,axiom,
    ! [VarCurr] :
      ( v132715(VarCurr)
    <=> v132717(VarCurr) ) ).

fof(addAssignment_43367,axiom,
    ! [VarCurr] :
      ( v132717(VarCurr)
    <=> v132719(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3182,axiom,
    ! [VarCurr] :
      ( ~ v132721(VarCurr)
     => ( v132719(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2987,axiom,
    ! [VarCurr] :
      ( v132721(VarCurr)
     => ( v132719(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9293,axiom,
    ! [VarCurr] :
      ( v132721(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $false )
        & ( v15281(VarCurr,bitIndex5)
        <=> $false )
        & ( v15281(VarCurr,bitIndex4)
        <=> $false )
        & ( v15281(VarCurr,bitIndex3)
        <=> $true )
        & ( v15281(VarCurr,bitIndex2)
        <=> $false )
        & ( v15281(VarCurr,bitIndex1)
        <=> $true )
        & ( v15281(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26533,axiom,
    ! [VarCurr] :
      ( v132640(VarCurr)
    <=> ( v132703(VarCurr)
        & v132704(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26532,axiom,
    ! [VarCurr] :
      ( v132704(VarCurr)
    <=> ( v132705(VarCurr)
        | v132707(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26531,axiom,
    ! [VarCurr] :
      ( v132707(VarCurr)
    <=> ( v132708(VarCurr)
        & v132709(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26530,axiom,
    ! [VarCurr] :
      ( v132709(VarCurr)
    <=> ( v132688(VarCurr)
        | v132695(VarCurr) ) ) ).

fof(writeUnaryOperator_10966,axiom,
    ! [VarCurr] :
      ( ~ v132708(VarCurr)
    <=> v132682(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26529,axiom,
    ! [VarCurr] :
      ( v132705(VarCurr)
    <=> ( v132706(VarCurr)
        & v132675(VarCurr) ) ) ).

fof(writeUnaryOperator_10965,axiom,
    ! [VarCurr] :
      ( ~ v132706(VarCurr)
    <=> v132642(VarCurr) ) ).

fof(writeUnaryOperator_10964,axiom,
    ! [VarCurr] :
      ( ~ v132703(VarCurr)
    <=> v10108(VarCurr) ) ).

fof(addAssignment_43366,axiom,
    ! [VarCurr] :
      ( v132695(VarCurr)
    <=> v132697(VarCurr) ) ).

fof(addAssignment_43365,axiom,
    ! [VarCurr] :
      ( v132697(VarCurr)
    <=> v132699(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3181,axiom,
    ! [VarCurr] :
      ( ~ v132701(VarCurr)
     => ( v132699(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2986,axiom,
    ! [VarCurr] :
      ( v132701(VarCurr)
     => ( v132699(VarCurr)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9292,axiom,
    ! [VarCurr] :
      ( v132701(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $true )
        & ( v15281(VarCurr,bitIndex5)
        <=> $true )
        & ( v15281(VarCurr,bitIndex4)
        <=> $true )
        & ( v15281(VarCurr,bitIndex3)
        <=> $true )
        & ( v15281(VarCurr,bitIndex2)
        <=> $true )
        & ( v15281(VarCurr,bitIndex1)
        <=> $false )
        & ( v15281(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_43364,axiom,
    ! [VarCurr] :
      ( v132688(VarCurr)
    <=> v132690(VarCurr) ) ).

fof(addAssignment_43363,axiom,
    ! [VarCurr] :
      ( v132690(VarCurr)
    <=> v132692(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3180,axiom,
    ! [VarCurr] :
      ( ~ v114215(VarCurr)
     => ( v132692(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2985,axiom,
    ! [VarCurr] :
      ( v114215(VarCurr)
     => ( v132692(VarCurr)
      <=> v15317(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43362,axiom,
    ! [VarCurr] :
      ( v132682(VarCurr)
    <=> v132684(VarCurr) ) ).

fof(addAssignment_43361,axiom,
    ! [VarCurr] :
      ( v132684(VarCurr)
    <=> v132686(VarCurr) ) ).

fof(addAssignment_43360,axiom,
    ! [VarCurr] :
      ( v132686(VarCurr)
    <=> v10094(VarCurr,bitIndex5) ) ).

fof(addAssignment_43359,axiom,
    ! [VarCurr] :
      ( v132675(VarCurr)
    <=> v132677(VarCurr) ) ).

fof(addAssignment_43358,axiom,
    ! [VarCurr] :
      ( v132677(VarCurr)
    <=> v132679(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3179,axiom,
    ! [VarCurr] :
      ( ~ v15321(VarCurr)
     => ( v132679(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2984,axiom,
    ! [VarCurr] :
      ( v15321(VarCurr)
     => ( v132679(VarCurr)
      <=> v15317(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43357,axiom,
    ! [VarCurr] :
      ( v132642(VarCurr)
    <=> v132644(VarCurr) ) ).

fof(addAssignment_43356,axiom,
    ! [VarCurr] :
      ( v132644(VarCurr)
    <=> v132646(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3023,axiom,
    ! [VarCurr] :
      ( v132646(VarCurr)
    <=> ( v132672(VarCurr)
        | v15302(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3022,axiom,
    ! [VarCurr] :
      ( v132672(VarCurr)
    <=> ( v132673(VarCurr)
        | v15302(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3021,axiom,
    ! [VarCurr] :
      ( v132673(VarCurr)
    <=> ( v10094(VarCurr,bitIndex1)
        | v15302(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43355,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex2)
    <=> v132664(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_138,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132665(VarNext)
       => ( ( v132664(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v132664(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v132664(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v132664(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v132664(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v132664(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v132664(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v132664(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v132664(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v132664(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v132664(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v132664(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v132664(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v132664(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v132664(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v132664(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v132664(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v132664(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v132664(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v132664(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2449,axiom,
    ! [VarNext] :
      ( v132665(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v132664(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26528,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132665(VarNext)
      <=> v132666(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26527,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132666(VarNext)
      <=> ( v132668(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10963,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132668(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_583,axiom,
    ! [VarCurr] :
      ( ~ v132662(VarCurr)
     => ( v10094(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_778,axiom,
    ! [VarCurr] :
      ( v132662(VarCurr)
     => ( v10094(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9291,axiom,
    ! [VarCurr] :
      ( v132662(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43354,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex1)
    <=> v132654(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_137,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132655(VarNext)
       => ( ( v132654(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v132654(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v132654(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v132654(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v132654(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v132654(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v132654(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v132654(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v132654(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v132654(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v132654(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v132654(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v132654(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v132654(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v132654(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v132654(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v132654(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v132654(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v132654(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v132654(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2448,axiom,
    ! [VarNext] :
      ( v132655(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v132654(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26526,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132655(VarNext)
      <=> v132656(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26525,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132656(VarNext)
      <=> ( v132658(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10962,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132658(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_582,axiom,
    ! [VarCurr] :
      ( ~ v132648(VarCurr)
     => ( v10094(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_777,axiom,
    ! [VarCurr] :
      ( v132648(VarCurr)
     => ( v10094(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26524,axiom,
    ! [VarCurr] :
      ( v132648(VarCurr)
    <=> ( v132649(VarCurr)
        & v131436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26523,axiom,
    ! [VarCurr] :
      ( v132649(VarCurr)
    <=> ( v132651(VarCurr)
        & v131435(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26522,axiom,
    ! [VarCurr] :
      ( v132651(VarCurr)
    <=> ( v132652(VarCurr)
        & v131434(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26521,axiom,
    ! [VarCurr] :
      ( v132652(VarCurr)
    <=> ( v131551(VarCurr)
        & v15309(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26520,axiom,
    ! [VarCurr] :
      ( v132528(VarCurr)
    <=> ( v132637(VarCurr)
        & v132544(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26519,axiom,
    ! [VarCurr] :
      ( v132637(VarCurr)
    <=> ( v132638(VarCurr)
        & v132530(VarCurr) ) ) ).

fof(writeUnaryOperator_10961,axiom,
    ! [VarCurr] :
      ( ~ v132638(VarCurr)
    <=> v10108(VarCurr) ) ).

fof(addAssignment_43353,axiom,
    ! [VarCurr] :
      ( v132544(VarCurr)
    <=> v132546(VarCurr) ) ).

fof(addAssignment_43352,axiom,
    ! [VarCurr] :
      ( v132546(VarCurr)
    <=> v132548(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3020,axiom,
    ! [VarCurr] :
      ( v132548(VarCurr)
    <=> ( v132610(VarCurr)
        | v132550(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132615(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v132550(VarNext,B)
            <=> v132550(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2447,axiom,
    ! [VarNext] :
      ( v132615(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v132550(VarNext,B)
          <=> v132631(VarNext,B) ) ) ) ).

fof(addAssignment_43351,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v132631(VarNext,B)
          <=> v132629(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5401,axiom,
    ! [VarCurr] :
      ( ~ v132626(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132629(VarCurr,B)
          <=> v132585(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5390,axiom,
    ! [VarCurr] :
      ( v132626(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132629(VarCurr,B)
          <=> b110(B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26518,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132615(VarNext)
      <=> ( v132616(VarNext)
          & v132625(VarNext) ) ) ) ).

fof(addAssignment_43350,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132625(VarNext)
      <=> v132623(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26517,axiom,
    ! [VarCurr] :
      ( v132623(VarCurr)
    <=> ( v132626(VarCurr)
        | v132627(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26516,axiom,
    ! [VarCurr] :
      ( v132627(VarCurr)
    <=> ( v132554(VarCurr)
        & v132628(VarCurr) ) ) ).

fof(writeUnaryOperator_10960,axiom,
    ! [VarCurr] :
      ( ~ v132628(VarCurr)
    <=> v132626(VarCurr) ) ).

fof(writeUnaryOperator_10959,axiom,
    ! [VarCurr] :
      ( ~ v132626(VarCurr)
    <=> v132552(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26515,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132616(VarNext)
      <=> ( v132617(VarNext)
          & v132612(VarNext) ) ) ) ).

fof(writeUnaryOperator_10958,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132617(VarNext)
      <=> v132619(VarNext) ) ) ).

fof(addAssignment_43349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132619(VarNext)
      <=> v132612(VarCurr) ) ) ).

fof(addAssignment_43348,axiom,
    ! [VarCurr] :
      ( v132612(VarCurr)
    <=> v13235(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3178,axiom,
    ! [VarCurr] :
      ( ~ v132580(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132585(VarCurr,B)
          <=> v132601(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2983,axiom,
    ! [VarCurr] :
      ( v132580(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v132585(VarCurr,B)
          <=> v132587(VarCurr,B) ) ) ) ).

fof(addAssignment_43347,axiom,
    ! [VarCurr] :
      ( v132601(VarCurr,bitIndex0)
    <=> v132599(VarCurr) ) ).

fof(addAssignment_43346,axiom,
    ! [VarCurr] :
      ( v132601(VarCurr,bitIndex1)
    <=> v132608(VarCurr) ) ).

fof(addAssignment_43345,axiom,
    ! [VarCurr] :
      ( v132601(VarCurr,bitIndex2)
    <=> v132603(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26514,axiom,
    ! [VarCurr] :
      ( v132608(VarCurr)
    <=> ( v132609(VarCurr)
        & v132610(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3019,axiom,
    ! [VarCurr] :
      ( v132610(VarCurr)
    <=> ( v132550(VarCurr,bitIndex0)
        | v132550(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26513,axiom,
    ! [VarCurr] :
      ( v132609(VarCurr)
    <=> ( v132599(VarCurr)
        | v132594(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26512,axiom,
    ! [VarCurr] :
      ( v132603(VarCurr)
    <=> ( v132604(VarCurr)
        & v132607(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3018,axiom,
    ! [VarCurr] :
      ( v132607(VarCurr)
    <=> ( v132550(VarCurr,bitIndex2)
        | v132606(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26511,axiom,
    ! [VarCurr] :
      ( v132604(VarCurr)
    <=> ( v132596(VarCurr)
        | v132605(VarCurr) ) ) ).

fof(writeUnaryOperator_10957,axiom,
    ! [VarCurr] :
      ( ~ v132605(VarCurr)
    <=> v132606(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3017,axiom,
    ! [VarCurr] :
      ( v132606(VarCurr)
    <=> ( v132550(VarCurr,bitIndex0)
        & v132550(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43344,axiom,
    ! [VarCurr] :
      ( v132587(VarCurr,bitIndex0)
    <=> v132599(VarCurr) ) ).

fof(addAssignment_43343,axiom,
    ! [VarCurr] :
      ( v132587(VarCurr,bitIndex1)
    <=> v132597(VarCurr) ) ).

fof(addAssignment_43342,axiom,
    ! [VarCurr] :
      ( v132587(VarCurr,bitIndex2)
    <=> v132589(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26510,axiom,
    ! [VarCurr] :
      ( v132597(VarCurr)
    <=> ( v132598(VarCurr)
        & v132600(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26509,axiom,
    ! [VarCurr] :
      ( v132600(VarCurr)
    <=> ( v132550(VarCurr,bitIndex0)
        | v132594(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3016,axiom,
    ! [VarCurr] :
      ( v132598(VarCurr)
    <=> ( v132599(VarCurr)
        | v132550(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_10956,axiom,
    ! [VarCurr] :
      ( ~ v132599(VarCurr)
    <=> v132550(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26508,axiom,
    ! [VarCurr] :
      ( v132589(VarCurr)
    <=> ( v132590(VarCurr)
        & v132595(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26507,axiom,
    ! [VarCurr] :
      ( v132595(VarCurr)
    <=> ( v132592(VarCurr)
        | v132596(VarCurr) ) ) ).

fof(writeUnaryOperator_10955,axiom,
    ! [VarCurr] :
      ( ~ v132596(VarCurr)
    <=> v132550(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_3015,axiom,
    ! [VarCurr] :
      ( v132590(VarCurr)
    <=> ( v132591(VarCurr)
        | v132550(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10954,axiom,
    ! [VarCurr] :
      ( ~ v132591(VarCurr)
    <=> v132592(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3014,axiom,
    ! [VarCurr] :
      ( v132592(VarCurr)
    <=> ( v132550(VarCurr,bitIndex1)
        | v132593(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26506,axiom,
    ! [VarCurr] :
      ( v132593(VarCurr)
    <=> ( v132550(VarCurr,bitIndex0)
        & v132594(VarCurr) ) ) ).

fof(writeUnaryOperator_10953,axiom,
    ! [VarCurr] :
      ( ~ v132594(VarCurr)
    <=> v132550(VarCurr,bitIndex1) ) ).

fof(addAssignmentInitValueVector_42,axiom,
    ! [B] :
      ( range_2_0(B)
     => ( v132550(constB0,B)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26505,axiom,
    ! [VarCurr] :
      ( v132554(VarCurr)
    <=> ( v132556(VarCurr)
      <~> v132580(VarCurr) ) ) ).

fof(addAssignment_43341,axiom,
    ! [VarCurr] :
      ( v132580(VarCurr)
    <=> v132582(VarCurr) ) ).

fof(addAssignment_43340,axiom,
    ! [VarCurr] :
      ( v132582(VarCurr)
    <=> v132528(VarCurr) ) ).

fof(addAssignment_43339,axiom,
    ! [VarCurr] :
      ( v132556(VarCurr)
    <=> v132558(VarCurr) ) ).

fof(addAssignment_43338,axiom,
    ! [VarCurr] :
      ( v132558(VarCurr)
    <=> v132560(VarCurr) ) ).

fof(addAssignment_43337,axiom,
    ! [VarCurr] :
      ( v132560(VarCurr)
    <=> v132562(VarCurr) ) ).

fof(addAssignment_43336,axiom,
    ! [VarCurr] :
      ( v132562(VarCurr)
    <=> v132564(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2325,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132567(VarNext)
       => ( v132564(VarNext)
        <=> v132564(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2446,axiom,
    ! [VarNext] :
      ( v132567(VarNext)
     => ( v132564(VarNext)
      <=> v132575(VarNext) ) ) ).

fof(addAssignment_43335,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132575(VarNext)
      <=> v132573(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3177,axiom,
    ! [VarCurr] :
      ( ~ v13186(VarCurr)
     => ( v132573(VarCurr)
      <=> v132576(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2982,axiom,
    ! [VarCurr] :
      ( v13186(VarCurr)
     => ( v132573(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3176,axiom,
    ! [VarCurr] :
      ( ~ v11748(VarCurr)
     => ( v132576(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2981,axiom,
    ! [VarCurr] :
      ( v11748(VarCurr)
     => ( v132576(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26504,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132567(VarNext)
      <=> v132568(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26503,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132568(VarNext)
      <=> ( v132570(VarNext)
          & v12082(VarNext) ) ) ) ).

fof(writeUnaryOperator_10952,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132570(VarNext)
      <=> v12089(VarNext) ) ) ).

fof(addAssignment_43334,axiom,
    ! [VarCurr] :
      ( v132552(VarCurr)
    <=> v10084(VarCurr) ) ).

fof(addAssignment_43333,axiom,
    ! [VarCurr] :
      ( v132530(VarCurr)
    <=> v132532(VarCurr) ) ).

fof(addAssignment_43332,axiom,
    ! [VarCurr] :
      ( v132532(VarCurr)
    <=> v132534(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3175,axiom,
    ! [VarCurr] :
      ( ~ v132536(VarCurr)
     => ( v132534(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2980,axiom,
    ! [VarCurr] :
      ( v132536(VarCurr)
     => ( v132534(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26502,axiom,
    ! [VarCurr] :
      ( v132536(VarCurr)
    <=> ( v132537(VarCurr)
        | v132542(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9290,axiom,
    ! [VarCurr] :
      ( v132542(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $false )
        & ( v15281(VarCurr,bitIndex5)
        <=> $false )
        & ( v15281(VarCurr,bitIndex4)
        <=> $false )
        & ( v15281(VarCurr,bitIndex3)
        <=> $true )
        & ( v15281(VarCurr,bitIndex2)
        <=> $false )
        & ( v15281(VarCurr,bitIndex1)
        <=> $false )
        & ( v15281(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26501,axiom,
    ! [VarCurr] :
      ( v132537(VarCurr)
    <=> ( v132538(VarCurr)
        | v132539(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26500,axiom,
    ! [VarCurr] :
      ( v132539(VarCurr)
    <=> ( v132540(VarCurr)
        | v132541(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9289,axiom,
    ! [VarCurr] :
      ( v132541(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $false )
        & ( v15281(VarCurr,bitIndex5)
        <=> $true )
        & ( v15281(VarCurr,bitIndex4)
        <=> $false )
        & ( v15281(VarCurr,bitIndex3)
        <=> $false )
        & ( v15281(VarCurr,bitIndex2)
        <=> $false )
        & ( v15281(VarCurr,bitIndex1)
        <=> $false )
        & ( v15281(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9288,axiom,
    ! [VarCurr] :
      ( v132540(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $false )
        & ( v15281(VarCurr,bitIndex5)
        <=> $false )
        & ( v15281(VarCurr,bitIndex4)
        <=> $false )
        & ( v15281(VarCurr,bitIndex3)
        <=> $false )
        & ( v15281(VarCurr,bitIndex2)
        <=> $false )
        & ( v15281(VarCurr,bitIndex1)
        <=> $false )
        & ( v15281(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26499,axiom,
    ! [VarCurr] :
      ( v132538(VarCurr)
    <=> ( v15317(VarCurr,bitIndex0)
        & v131882(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_581,axiom,
    ! [VarCurr] :
      ( ~ v132525(VarCurr)
     => ( v11291(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_776,axiom,
    ! [VarCurr] :
      ( v132525(VarCurr)
     => ( v11291(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26498,axiom,
    ! [VarCurr] :
      ( v132525(VarCurr)
    <=> ( v132526(VarCurr)
        & v132515(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26497,axiom,
    ! [VarCurr] :
      ( v132526(VarCurr)
    <=> ( v11293(VarCurr)
        & v10100(VarCurr) ) ) ).

fof(addAssignment_43331,axiom,
    ! [VarNext] :
      ( v13210(VarNext,bitIndex2)
    <=> v132517(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_136,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132518(VarNext)
       => ( ( v132517(VarNext,bitIndex11)
          <=> v13210(VarCurr,bitIndex12) )
          & ( v132517(VarNext,bitIndex10)
          <=> v13210(VarCurr,bitIndex11) )
          & ( v132517(VarNext,bitIndex9)
          <=> v13210(VarCurr,bitIndex10) )
          & ( v132517(VarNext,bitIndex8)
          <=> v13210(VarCurr,bitIndex9) )
          & ( v132517(VarNext,bitIndex7)
          <=> v13210(VarCurr,bitIndex8) )
          & ( v132517(VarNext,bitIndex6)
          <=> v13210(VarCurr,bitIndex7) )
          & ( v132517(VarNext,bitIndex5)
          <=> v13210(VarCurr,bitIndex6) )
          & ( v132517(VarNext,bitIndex4)
          <=> v13210(VarCurr,bitIndex5) )
          & ( v132517(VarNext,bitIndex3)
          <=> v13210(VarCurr,bitIndex4) )
          & ( v132517(VarNext,bitIndex2)
          <=> v13210(VarCurr,bitIndex3) )
          & ( v132517(VarNext,bitIndex1)
          <=> v13210(VarCurr,bitIndex2) )
          & ( v132517(VarNext,bitIndex0)
          <=> v13210(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2445,axiom,
    ! [VarNext] :
      ( v132518(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v132517(VarNext,B)
          <=> v114262(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26496,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132518(VarNext)
      <=> v132519(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26495,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132519(VarNext)
      <=> ( v132521(VarNext)
          & v114249(VarNext) ) ) ) ).

fof(writeUnaryOperator_10951,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132521(VarNext)
      <=> v114256(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_580,axiom,
    ! [VarCurr] :
      ( ~ v132509(VarCurr)
     => ( v11291(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_775,axiom,
    ! [VarCurr] :
      ( v132509(VarCurr)
     => ( v11291(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26494,axiom,
    ! [VarCurr] :
      ( v132509(VarCurr)
    <=> ( v132510(VarCurr)
        | v132511(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26493,axiom,
    ! [VarCurr] :
      ( v132511(VarCurr)
    <=> ( v132512(VarCurr)
        & v132515(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9287,axiom,
    ! [VarCurr] :
      ( v132515(VarCurr)
    <=> ( $true
      <=> v13210(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26492,axiom,
    ! [VarCurr] :
      ( v132512(VarCurr)
    <=> ( v132513(VarCurr)
        | v132514(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26491,axiom,
    ! [VarCurr] :
      ( v132514(VarCurr)
    <=> ( v131851(VarCurr)
        & v10100(VarCurr) ) ) ).

fof(writeUnaryOperator_10950,axiom,
    ! [VarCurr] :
      ( ~ v132513(VarCurr)
    <=> v10100(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9286,axiom,
    ! [VarCurr] :
      ( v132510(VarCurr)
    <=> ( $true
      <=> v13210(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43330,axiom,
    ! [VarNext] :
      ( v13210(VarNext,bitIndex1)
    <=> v132501(VarNext,bitIndex0) ) ).

fof(addCaseBooleanConditionShiftedRanges1_135,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132502(VarNext)
       => ( ( v132501(VarNext,bitIndex11)
          <=> v13210(VarCurr,bitIndex12) )
          & ( v132501(VarNext,bitIndex10)
          <=> v13210(VarCurr,bitIndex11) )
          & ( v132501(VarNext,bitIndex9)
          <=> v13210(VarCurr,bitIndex10) )
          & ( v132501(VarNext,bitIndex8)
          <=> v13210(VarCurr,bitIndex9) )
          & ( v132501(VarNext,bitIndex7)
          <=> v13210(VarCurr,bitIndex8) )
          & ( v132501(VarNext,bitIndex6)
          <=> v13210(VarCurr,bitIndex7) )
          & ( v132501(VarNext,bitIndex5)
          <=> v13210(VarCurr,bitIndex6) )
          & ( v132501(VarNext,bitIndex4)
          <=> v13210(VarCurr,bitIndex5) )
          & ( v132501(VarNext,bitIndex3)
          <=> v13210(VarCurr,bitIndex4) )
          & ( v132501(VarNext,bitIndex2)
          <=> v13210(VarCurr,bitIndex3) )
          & ( v132501(VarNext,bitIndex1)
          <=> v13210(VarCurr,bitIndex2) )
          & ( v132501(VarNext,bitIndex0)
          <=> v13210(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2444,axiom,
    ! [VarNext] :
      ( v132502(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v132501(VarNext,B)
          <=> v114262(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26490,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132502(VarNext)
      <=> v132503(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26489,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132503(VarNext)
      <=> ( v132505(VarNext)
          & v114249(VarNext) ) ) ) ).

fof(writeUnaryOperator_10949,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132505(VarNext)
      <=> v114256(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_579,axiom,
    ! [VarCurr] :
      ( ~ v132496(VarCurr)
     => ( v11291(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_774,axiom,
    ! [VarCurr] :
      ( v132496(VarCurr)
     => ( v11291(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26488,axiom,
    ! [VarCurr] :
      ( v132496(VarCurr)
    <=> ( v132497(VarCurr)
        & v114245(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26487,axiom,
    ! [VarCurr] :
      ( v132497(VarCurr)
    <=> ( v132499(VarCurr)
        & v114244(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26486,axiom,
    ! [VarCurr] :
      ( v132499(VarCurr)
    <=> ( v131833(VarCurr)
        & v114199(VarCurr) ) ) ).

fof(addAssignment_43329,axiom,
    ! [VarCurr] :
      ( v11293(VarCurr)
    <=> v11295(VarCurr) ) ).

fof(addAssignment_43328,axiom,
    ! [VarCurr] :
      ( v11295(VarCurr)
    <=> v11297(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_3013,axiom,
    ! [VarCurr] :
      ( v11297(VarCurr)
    <=> ( v132481(VarCurr)
        | v11299(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3012,axiom,
    ! [VarCurr] :
      ( v132481(VarCurr)
    <=> ( v132482(VarCurr)
        | v11299(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3011,axiom,
    ! [VarCurr] :
      ( v132482(VarCurr)
    <=> ( v132483(VarCurr)
        | v11299(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3010,axiom,
    ! [VarCurr] :
      ( v132483(VarCurr)
    <=> ( v132484(VarCurr)
        | v11299(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3009,axiom,
    ! [VarCurr] :
      ( v132484(VarCurr)
    <=> ( v132485(VarCurr)
        | v11299(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3008,axiom,
    ! [VarCurr] :
      ( v132485(VarCurr)
    <=> ( v132486(VarCurr)
        | v11299(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3007,axiom,
    ! [VarCurr] :
      ( v132486(VarCurr)
    <=> ( v132487(VarCurr)
        | v11299(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3006,axiom,
    ! [VarCurr] :
      ( v132487(VarCurr)
    <=> ( v132488(VarCurr)
        | v11299(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3005,axiom,
    ! [VarCurr] :
      ( v132488(VarCurr)
    <=> ( v132489(VarCurr)
        | v11299(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3004,axiom,
    ! [VarCurr] :
      ( v132489(VarCurr)
    <=> ( v132490(VarCurr)
        | v11299(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3003,axiom,
    ! [VarCurr] :
      ( v132490(VarCurr)
    <=> ( v132491(VarCurr)
        | v11299(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3002,axiom,
    ! [VarCurr] :
      ( v132491(VarCurr)
    <=> ( v132492(VarCurr)
        | v11299(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3001,axiom,
    ! [VarCurr] :
      ( v132492(VarCurr)
    <=> ( v132493(VarCurr)
        | v11299(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3000,axiom,
    ! [VarCurr] :
      ( v132493(VarCurr)
    <=> ( v132494(VarCurr)
        | v11299(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2999,axiom,
    ! [VarCurr] :
      ( v132494(VarCurr)
    <=> ( v11299(VarCurr,bitIndex0)
        | v11299(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2324,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132465(VarNext)
       => ! [B] :
            ( range_15_0(B)
           => ( v11299(VarNext,B)
            <=> v11299(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2443,axiom,
    ! [VarNext] :
      ( v132465(VarNext)
     => ! [B] :
          ( range_15_0(B)
         => ( v11299(VarNext,B)
          <=> v132475(VarNext,B) ) ) ) ).

fof(addAssignment_43327,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_15_0(B)
         => ( v132475(VarNext,B)
          <=> v132473(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3174,axiom,
    ! [VarCurr] :
      ( ~ v132476(VarCurr)
     => ! [B] :
          ( range_15_0(B)
         => ( v132473(VarCurr,B)
          <=> v11304(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2979,axiom,
    ! [VarCurr] :
      ( v132476(VarCurr)
     => ! [B] :
          ( range_15_0(B)
         => ( v132473(VarCurr,B)
          <=> $true ) ) ) ).

fof(writeUnaryOperator_10948,axiom,
    ! [VarCurr] :
      ( ~ v132476(VarCurr)
    <=> v11301(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26485,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132465(VarNext)
      <=> v132466(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26484,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132466(VarNext)
      <=> ( v132467(VarNext)
          & v132462(VarNext) ) ) ) ).

fof(writeUnaryOperator_10947,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132467(VarNext)
      <=> v132469(VarNext) ) ) ).

fof(addAssignment_43326,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132469(VarNext)
      <=> v132462(VarCurr) ) ) ).

fof(addAssignment_43325,axiom,
    ! [VarCurr] :
      ( v132462(VarCurr)
    <=> v13235(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_140,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v11304(VarCurr,B)
      <=> ( v132459(VarCurr,B)
          & v132460(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_10946,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132460(VarCurr,B)
      <=> ~ v13195(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_139,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132459(VarCurr,B)
      <=> ( v11306(VarCurr,B)
          | v11299(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_138,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v13195(VarCurr,B)
      <=> ( v13197(VarCurr,B)
          & v132456(VarCurr,B) ) ) ) ).

fof(addAssignment_43324,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex0)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43323,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex1)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43322,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex2)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43321,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex3)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43320,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex4)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43319,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex5)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43318,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex6)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43317,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex7)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43316,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex8)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43315,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex9)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43314,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex10)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43313,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex11)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43312,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex12)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43311,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex13)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43310,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex14)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43309,axiom,
    ! [VarCurr] :
      ( v132456(VarCurr,bitIndex15)
    <=> v132457(VarCurr) ) ).

fof(addAssignment_43308,axiom,
    ! [VarCurr] :
      ( v132457(VarCurr)
    <=> v13204(VarCurr) ) ).

fof(addAssignment_43307,axiom,
    ! [VarCurr] :
      ( v13204(VarCurr)
    <=> v13206(VarCurr) ) ).

fof(addAssignment_43306,axiom,
    ! [VarCurr] :
      ( v13206(VarCurr)
    <=> v13208(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26483,axiom,
    ! [VarCurr] :
      ( v13208(VarCurr)
    <=> ( v132453(VarCurr)
        | v131866(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26482,axiom,
    ! [VarCurr] :
      ( v132453(VarCurr)
    <=> ( v132454(VarCurr)
        | v114140(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2998,axiom,
    ! [VarCurr] :
      ( v132454(VarCurr)
    <=> ( v11291(VarCurr,bitIndex3)
        | v11291(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26481,axiom,
    ! [VarCurr] :
      ( v131866(VarCurr)
    <=> ( v131868(VarCurr)
        | v132448(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26480,axiom,
    ! [VarCurr] :
      ( v132448(VarCurr)
    <=> ( v132450(VarCurr)
        & v131872(VarCurr) ) ) ).

fof(writeUnaryOperator_10945,axiom,
    ! [VarCurr] :
      ( ~ v132450(VarCurr)
    <=> v131870(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26479,axiom,
    ! [VarCurr] :
      ( v131868(VarCurr)
    <=> ( v132446(VarCurr)
        & v131890(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26478,axiom,
    ! [VarCurr] :
      ( v132446(VarCurr)
    <=> ( v131870(VarCurr)
        & v131872(VarCurr) ) ) ).

fof(addAssignment_43305,axiom,
    ! [VarCurr] :
      ( v131890(VarCurr)
    <=> v131892(VarCurr) ) ).

fof(addAssignment_43304,axiom,
    ! [VarCurr] :
      ( v131892(VarCurr)
    <=> v131894(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2997,axiom,
    ! [VarCurr] :
      ( v131894(VarCurr)
    <=> ( v132438(VarCurr)
        & v131896(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2996,axiom,
    ! [VarCurr] :
      ( v132438(VarCurr)
    <=> ( v132439(VarCurr)
        & v131896(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2995,axiom,
    ! [VarCurr] :
      ( v132439(VarCurr)
    <=> ( v132440(VarCurr)
        & v131896(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2994,axiom,
    ! [VarCurr] :
      ( v132440(VarCurr)
    <=> ( v132441(VarCurr)
        & v131896(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2993,axiom,
    ! [VarCurr] :
      ( v132441(VarCurr)
    <=> ( v132442(VarCurr)
        & v131896(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2992,axiom,
    ! [VarCurr] :
      ( v132442(VarCurr)
    <=> ( v132443(VarCurr)
        & v131896(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2991,axiom,
    ! [VarCurr] :
      ( v132443(VarCurr)
    <=> ( v132444(VarCurr)
        & v131896(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2990,axiom,
    ! [VarCurr] :
      ( v132444(VarCurr)
    <=> ( v131896(VarCurr,bitIndex0)
        & v131896(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_43303,axiom,
    ! [VarCurr] :
      ( ( v131896(VarCurr,bitIndex8)
      <=> v132371(VarCurr,bitIndex16) )
      & ( v131896(VarCurr,bitIndex7)
      <=> v132371(VarCurr,bitIndex15) )
      & ( v131896(VarCurr,bitIndex6)
      <=> v132371(VarCurr,bitIndex14) )
      & ( v131896(VarCurr,bitIndex5)
      <=> v132371(VarCurr,bitIndex13) )
      & ( v131896(VarCurr,bitIndex4)
      <=> v132371(VarCurr,bitIndex12) )
      & ( v131896(VarCurr,bitIndex3)
      <=> v132371(VarCurr,bitIndex11) )
      & ( v131896(VarCurr,bitIndex2)
      <=> v132371(VarCurr,bitIndex10) )
      & ( v131896(VarCurr,bitIndex1)
      <=> v132371(VarCurr,bitIndex9) )
      & ( v131896(VarCurr,bitIndex0)
      <=> v132371(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_137,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132371(VarCurr,B)
      <=> ( v132373(VarCurr,B)
          | v132433(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_136,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132433(VarCurr,B)
      <=> ( v132434(VarCurr,B)
          & v132435(VarCurr,B) ) ) ) ).

fof(addAssignment_43302,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex0)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43301,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex1)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43300,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex2)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43299,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex3)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43298,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex4)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43297,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex5)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43296,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex6)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43295,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex7)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43294,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex8)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43293,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex9)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43292,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex10)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43291,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex11)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43290,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex12)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43289,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex13)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43288,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex14)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43287,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex15)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43286,axiom,
    ! [VarCurr] :
      ( v132435(VarCurr,bitIndex16)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(addAssignment_43285,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v132434(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_43284,axiom,
    ! [VarCurr] :
      ( ( v132434(VarCurr,bitIndex16)
      <=> v132374(VarCurr,bitIndex8) )
      & ( v132434(VarCurr,bitIndex15)
      <=> v132374(VarCurr,bitIndex7) )
      & ( v132434(VarCurr,bitIndex14)
      <=> v132374(VarCurr,bitIndex6) )
      & ( v132434(VarCurr,bitIndex13)
      <=> v132374(VarCurr,bitIndex5) )
      & ( v132434(VarCurr,bitIndex12)
      <=> v132374(VarCurr,bitIndex4) )
      & ( v132434(VarCurr,bitIndex11)
      <=> v132374(VarCurr,bitIndex3) )
      & ( v132434(VarCurr,bitIndex10)
      <=> v132374(VarCurr,bitIndex2) )
      & ( v132434(VarCurr,bitIndex9)
      <=> v132374(VarCurr,bitIndex1) )
      & ( v132434(VarCurr,bitIndex8)
      <=> v132374(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_135,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132373(VarCurr,B)
      <=> ( v132374(VarCurr,B)
          & v132431(VarCurr,B) ) ) ) ).

fof(addAssignment_43283,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex0)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43282,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex1)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43281,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex2)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43280,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex3)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43279,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex4)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43278,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex5)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43277,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex6)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43276,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex7)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43275,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex8)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43274,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex9)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43273,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex10)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43272,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex11)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43271,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex12)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43270,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex13)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43269,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex14)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43268,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex15)
    <=> v132432(VarCurr) ) ).

fof(addAssignment_43267,axiom,
    ! [VarCurr] :
      ( v132431(VarCurr,bitIndex16)
    <=> v132432(VarCurr) ) ).

fof(writeUnaryOperator_10944,axiom,
    ! [VarCurr] :
      ( ~ v132432(VarCurr)
    <=> v132383(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_134,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132374(VarCurr,B)
      <=> ( v132375(VarCurr,B)
          | v132428(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_133,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132428(VarCurr,B)
      <=> ( v132429(VarCurr,B)
          & v132430(VarCurr,B) ) ) ) ).

fof(addAssignment_43266,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex0)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43265,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex1)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43264,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex2)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43263,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex3)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43262,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex4)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43261,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex5)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43260,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex6)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43259,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex7)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43258,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex8)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43257,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex9)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43256,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex10)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43255,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex11)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43254,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex12)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43253,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex13)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43252,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex14)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43251,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex15)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43250,axiom,
    ! [VarCurr] :
      ( v132430(VarCurr,bitIndex16)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(addAssignment_43249,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v132429(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_43248,axiom,
    ! [VarCurr] :
      ( ( v132429(VarCurr,bitIndex16)
      <=> v132376(VarCurr,bitIndex12) )
      & ( v132429(VarCurr,bitIndex15)
      <=> v132376(VarCurr,bitIndex11) )
      & ( v132429(VarCurr,bitIndex14)
      <=> v132376(VarCurr,bitIndex10) )
      & ( v132429(VarCurr,bitIndex13)
      <=> v132376(VarCurr,bitIndex9) )
      & ( v132429(VarCurr,bitIndex12)
      <=> v132376(VarCurr,bitIndex8) )
      & ( v132429(VarCurr,bitIndex11)
      <=> v132376(VarCurr,bitIndex7) )
      & ( v132429(VarCurr,bitIndex10)
      <=> v132376(VarCurr,bitIndex6) )
      & ( v132429(VarCurr,bitIndex9)
      <=> v132376(VarCurr,bitIndex5) )
      & ( v132429(VarCurr,bitIndex8)
      <=> v132376(VarCurr,bitIndex4) )
      & ( v132429(VarCurr,bitIndex7)
      <=> v132376(VarCurr,bitIndex3) )
      & ( v132429(VarCurr,bitIndex6)
      <=> v132376(VarCurr,bitIndex2) )
      & ( v132429(VarCurr,bitIndex5)
      <=> v132376(VarCurr,bitIndex1) )
      & ( v132429(VarCurr,bitIndex4)
      <=> v132376(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_132,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132375(VarCurr,B)
      <=> ( v132376(VarCurr,B)
          & v132426(VarCurr,B) ) ) ) ).

fof(addAssignment_43247,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex0)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43246,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex1)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43245,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex2)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43244,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex3)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43243,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex4)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43242,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex5)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43241,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex6)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43240,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex7)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43239,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex8)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43238,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex9)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43237,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex10)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43236,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex11)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43235,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex12)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43234,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex13)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43233,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex14)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43232,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex15)
    <=> v132427(VarCurr) ) ).

fof(addAssignment_43231,axiom,
    ! [VarCurr] :
      ( v132426(VarCurr,bitIndex16)
    <=> v132427(VarCurr) ) ).

fof(writeUnaryOperator_10943,axiom,
    ! [VarCurr] :
      ( ~ v132427(VarCurr)
    <=> v132383(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_131,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132376(VarCurr,B)
      <=> ( v132377(VarCurr,B)
          | v132423(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_130,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132423(VarCurr,B)
      <=> ( v132424(VarCurr,B)
          & v132425(VarCurr,B) ) ) ) ).

fof(addAssignment_43230,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex0)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43229,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex1)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43228,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex2)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43227,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex3)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43226,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex4)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43225,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex5)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43224,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex6)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43223,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex7)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43222,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex8)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43221,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex9)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43220,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex10)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43219,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex11)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43218,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex12)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43217,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex13)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43216,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex14)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43215,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex15)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43214,axiom,
    ! [VarCurr] :
      ( v132425(VarCurr,bitIndex16)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(addAssignment_43213,axiom,
    ! [VarCurr,B] :
      ( range_1_0(B)
     => ( v132424(VarCurr,B)
      <=> $false ) ) ).

fof(addAssignment_43212,axiom,
    ! [VarCurr] :
      ( ( v132424(VarCurr,bitIndex16)
      <=> v132378(VarCurr,bitIndex14) )
      & ( v132424(VarCurr,bitIndex15)
      <=> v132378(VarCurr,bitIndex13) )
      & ( v132424(VarCurr,bitIndex14)
      <=> v132378(VarCurr,bitIndex12) )
      & ( v132424(VarCurr,bitIndex13)
      <=> v132378(VarCurr,bitIndex11) )
      & ( v132424(VarCurr,bitIndex12)
      <=> v132378(VarCurr,bitIndex10) )
      & ( v132424(VarCurr,bitIndex11)
      <=> v132378(VarCurr,bitIndex9) )
      & ( v132424(VarCurr,bitIndex10)
      <=> v132378(VarCurr,bitIndex8) )
      & ( v132424(VarCurr,bitIndex9)
      <=> v132378(VarCurr,bitIndex7) )
      & ( v132424(VarCurr,bitIndex8)
      <=> v132378(VarCurr,bitIndex6) )
      & ( v132424(VarCurr,bitIndex7)
      <=> v132378(VarCurr,bitIndex5) )
      & ( v132424(VarCurr,bitIndex6)
      <=> v132378(VarCurr,bitIndex4) )
      & ( v132424(VarCurr,bitIndex5)
      <=> v132378(VarCurr,bitIndex3) )
      & ( v132424(VarCurr,bitIndex4)
      <=> v132378(VarCurr,bitIndex2) )
      & ( v132424(VarCurr,bitIndex3)
      <=> v132378(VarCurr,bitIndex1) )
      & ( v132424(VarCurr,bitIndex2)
      <=> v132378(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_129,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132377(VarCurr,B)
      <=> ( v132378(VarCurr,B)
          & v132421(VarCurr,B) ) ) ) ).

fof(addAssignment_43211,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex0)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43210,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex1)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43209,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex2)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43208,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex3)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43207,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex4)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43206,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex5)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43205,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex6)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43204,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex7)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43203,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex8)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43202,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex9)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43201,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex10)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43200,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex11)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43199,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex12)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43198,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex13)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43197,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex14)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43196,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex15)
    <=> v132422(VarCurr) ) ).

fof(addAssignment_43195,axiom,
    ! [VarCurr] :
      ( v132421(VarCurr,bitIndex16)
    <=> v132422(VarCurr) ) ).

fof(writeUnaryOperator_10942,axiom,
    ! [VarCurr] :
      ( ~ v132422(VarCurr)
    <=> v132383(VarCurr,bitIndex1) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_128,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132378(VarCurr,B)
      <=> ( v132379(VarCurr,B)
          | v132418(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_127,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132418(VarCurr,B)
      <=> ( v132419(VarCurr,B)
          & v132420(VarCurr,B) ) ) ) ).

fof(addAssignment_43194,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex0)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43193,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex1)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43192,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex2)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43191,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex3)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43190,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex4)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43189,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex5)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43188,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex6)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43187,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex7)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43186,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex8)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43185,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex9)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43184,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex10)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43183,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex11)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43182,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex12)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43181,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex13)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43180,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex14)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43179,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex15)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43178,axiom,
    ! [VarCurr] :
      ( v132420(VarCurr,bitIndex16)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43177,axiom,
    ! [VarCurr] :
      ( v132419(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_43176,axiom,
    ! [VarCurr] :
      ( ( v132419(VarCurr,bitIndex16)
      <=> v132380(VarCurr,bitIndex15) )
      & ( v132419(VarCurr,bitIndex15)
      <=> v132380(VarCurr,bitIndex14) )
      & ( v132419(VarCurr,bitIndex14)
      <=> v132380(VarCurr,bitIndex13) )
      & ( v132419(VarCurr,bitIndex13)
      <=> v132380(VarCurr,bitIndex12) )
      & ( v132419(VarCurr,bitIndex12)
      <=> v132380(VarCurr,bitIndex11) )
      & ( v132419(VarCurr,bitIndex11)
      <=> v132380(VarCurr,bitIndex10) )
      & ( v132419(VarCurr,bitIndex10)
      <=> v132380(VarCurr,bitIndex9) )
      & ( v132419(VarCurr,bitIndex9)
      <=> v132380(VarCurr,bitIndex8) )
      & ( v132419(VarCurr,bitIndex8)
      <=> v132380(VarCurr,bitIndex7) )
      & ( v132419(VarCurr,bitIndex7)
      <=> v132380(VarCurr,bitIndex6) )
      & ( v132419(VarCurr,bitIndex6)
      <=> v132380(VarCurr,bitIndex5) )
      & ( v132419(VarCurr,bitIndex5)
      <=> v132380(VarCurr,bitIndex4) )
      & ( v132419(VarCurr,bitIndex4)
      <=> v132380(VarCurr,bitIndex3) )
      & ( v132419(VarCurr,bitIndex3)
      <=> v132380(VarCurr,bitIndex2) )
      & ( v132419(VarCurr,bitIndex2)
      <=> v132380(VarCurr,bitIndex1) )
      & ( v132419(VarCurr,bitIndex1)
      <=> v132380(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_126,axiom,
    ! [VarCurr,B] :
      ( range_16_0(B)
     => ( v132379(VarCurr,B)
      <=> ( v132380(VarCurr,B)
          & v132381(VarCurr,B) ) ) ) ).

fof(addAssignment_43175,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex0)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43174,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex1)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43173,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex2)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43172,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex3)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43171,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex4)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43170,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex5)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43169,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex6)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43168,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex7)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43167,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex8)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43166,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex9)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43165,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex10)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43164,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex11)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43163,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex12)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43162,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex13)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43161,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex14)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43160,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex15)
    <=> v132382(VarCurr) ) ).

fof(addAssignment_43159,axiom,
    ! [VarCurr] :
      ( v132381(VarCurr,bitIndex16)
    <=> v132382(VarCurr) ) ).

fof(writeUnaryOperator_10941,axiom,
    ! [VarCurr] :
      ( ~ v132382(VarCurr)
    <=> v132383(VarCurr,bitIndex0) ) ).

fof(addAssignment_43158,axiom,
    ! [VarCurr] :
      ( v132383(VarCurr,bitIndex0)
    <=> v132392(VarCurr) ) ).

fof(addAssignment_43157,axiom,
    ! [VarCurr] :
      ( v132383(VarCurr,bitIndex1)
    <=> v132414(VarCurr) ) ).

fof(addAssignment_43156,axiom,
    ! [VarCurr] :
      ( v132383(VarCurr,bitIndex2)
    <=> v132409(VarCurr) ) ).

fof(addAssignment_43155,axiom,
    ! [VarCurr] :
      ( v132383(VarCurr,bitIndex3)
    <=> v132385(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26477,axiom,
    ! [VarCurr] :
      ( v132414(VarCurr)
    <=> ( v132415(VarCurr)
        & v132417(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26476,axiom,
    ! [VarCurr] :
      ( v132417(VarCurr)
    <=> ( v132368(VarCurr,bitIndex0)
        | v132404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26475,axiom,
    ! [VarCurr] :
      ( v132415(VarCurr)
    <=> ( v132392(VarCurr)
        | v132416(VarCurr) ) ) ).

fof(writeUnaryOperator_10940,axiom,
    ! [VarCurr] :
      ( ~ v132416(VarCurr)
    <=> v132404(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26474,axiom,
    ! [VarCurr] :
      ( v132409(VarCurr)
    <=> ( v132410(VarCurr)
        & v132413(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26473,axiom,
    ! [VarCurr] :
      ( v132413(VarCurr)
    <=> ( v132399(VarCurr)
        | v132403(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26472,axiom,
    ! [VarCurr] :
      ( v132410(VarCurr)
    <=> ( v132411(VarCurr)
        | v132412(VarCurr) ) ) ).

fof(writeUnaryOperator_10939,axiom,
    ! [VarCurr] :
      ( ~ v132412(VarCurr)
    <=> v132403(VarCurr) ) ).

fof(writeUnaryOperator_10938,axiom,
    ! [VarCurr] :
      ( ~ v132411(VarCurr)
    <=> v132399(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26471,axiom,
    ! [VarCurr] :
      ( v132385(VarCurr)
    <=> ( v132386(VarCurr)
        & v132407(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26470,axiom,
    ! [VarCurr] :
      ( v132407(VarCurr)
    <=> ( v132408(VarCurr)
        | v132398(VarCurr) ) ) ).

fof(writeUnaryOperator_10937,axiom,
    ! [VarCurr] :
      ( ~ v132408(VarCurr)
    <=> v132387(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26469,axiom,
    ! [VarCurr] :
      ( v132386(VarCurr)
    <=> ( v132387(VarCurr)
        | v132397(VarCurr) ) ) ).

fof(writeUnaryOperator_10936,axiom,
    ! [VarCurr] :
      ( ~ v132397(VarCurr)
    <=> v132398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26468,axiom,
    ! [VarCurr] :
      ( v132398(VarCurr)
    <=> ( v132399(VarCurr)
        & v132403(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26467,axiom,
    ! [VarCurr] :
      ( v132403(VarCurr)
    <=> ( v132368(VarCurr,bitIndex0)
        & v132404(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26466,axiom,
    ! [VarCurr] :
      ( v132404(VarCurr)
    <=> ( v132405(VarCurr)
        & v132406(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26465,axiom,
    ! [VarCurr] :
      ( v132406(VarCurr)
    <=> ( v132392(VarCurr)
        | v132393(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2989,axiom,
    ! [VarCurr] :
      ( v132405(VarCurr)
    <=> ( v132368(VarCurr,bitIndex0)
        | v132368(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26464,axiom,
    ! [VarCurr] :
      ( v132399(VarCurr)
    <=> ( v132400(VarCurr)
        & v132402(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26463,axiom,
    ! [VarCurr] :
      ( v132402(VarCurr)
    <=> ( v132391(VarCurr)
        | v132394(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2988,axiom,
    ! [VarCurr] :
      ( v132400(VarCurr)
    <=> ( v132401(VarCurr)
        | v132368(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10935,axiom,
    ! [VarCurr] :
      ( ~ v132401(VarCurr)
    <=> v132391(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26462,axiom,
    ! [VarCurr] :
      ( v132387(VarCurr)
    <=> ( v132388(VarCurr)
        & v132395(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26461,axiom,
    ! [VarCurr] :
      ( v132395(VarCurr)
    <=> ( v132390(VarCurr)
        | v132396(VarCurr) ) ) ).

fof(writeUnaryOperator_10934,axiom,
    ! [VarCurr] :
      ( ~ v132396(VarCurr)
    <=> v132368(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_2987,axiom,
    ! [VarCurr] :
      ( v132388(VarCurr)
    <=> ( v132389(VarCurr)
        | v132368(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_10933,axiom,
    ! [VarCurr] :
      ( ~ v132389(VarCurr)
    <=> v132390(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26460,axiom,
    ! [VarCurr] :
      ( v132390(VarCurr)
    <=> ( v132391(VarCurr)
        & v132394(VarCurr) ) ) ).

fof(writeUnaryOperator_10932,axiom,
    ! [VarCurr] :
      ( ~ v132394(VarCurr)
    <=> v132368(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26459,axiom,
    ! [VarCurr] :
      ( v132391(VarCurr)
    <=> ( v132392(VarCurr)
        & v132393(VarCurr) ) ) ).

fof(writeUnaryOperator_10931,axiom,
    ! [VarCurr] :
      ( ~ v132393(VarCurr)
    <=> v132368(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10930,axiom,
    ! [VarCurr] :
      ( ~ v132392(VarCurr)
    <=> v132368(VarCurr,bitIndex0) ) ).

fof(addAssignment_43154,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v132380(VarCurr,B)
      <=> $true ) ) ).

fof(addAssignment_43153,axiom,
    ! [VarCurr] :
      ( ( v132380(VarCurr,bitIndex16)
      <=> v131898(VarCurr,bitIndex8) )
      & ( v132380(VarCurr,bitIndex15)
      <=> v131898(VarCurr,bitIndex7) )
      & ( v132380(VarCurr,bitIndex14)
      <=> v131898(VarCurr,bitIndex6) )
      & ( v132380(VarCurr,bitIndex13)
      <=> v131898(VarCurr,bitIndex5) )
      & ( v132380(VarCurr,bitIndex12)
      <=> v131898(VarCurr,bitIndex4) )
      & ( v132380(VarCurr,bitIndex11)
      <=> v131898(VarCurr,bitIndex3) )
      & ( v132380(VarCurr,bitIndex10)
      <=> v131898(VarCurr,bitIndex2) )
      & ( v132380(VarCurr,bitIndex9)
      <=> v131898(VarCurr,bitIndex1) )
      & ( v132380(VarCurr,bitIndex8)
      <=> v131898(VarCurr,bitIndex0) ) ) ).

fof(addAssignment_43152,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v132368(VarCurr,B)
      <=> v132370(VarCurr,B) ) ) ).

fof(addAssignment_43151,axiom,
    ! [VarCurr] :
      ( ( v132370(VarCurr,bitIndex3)
      <=> v13227(VarCurr,bitIndex8) )
      & ( v132370(VarCurr,bitIndex2)
      <=> v13227(VarCurr,bitIndex7) )
      & ( v132370(VarCurr,bitIndex1)
      <=> v13227(VarCurr,bitIndex6) )
      & ( v132370(VarCurr,bitIndex0)
      <=> v13227(VarCurr,bitIndex5) ) ) ).

fof(addAssignment_43150,axiom,
    ! [VarCurr,B] :
      ( range_8_5(B)
     => ( v13227(VarCurr,B)
      <=> v13229(VarCurr,B) ) ) ).

fof(addAssignment_43149,axiom,
    ! [VarCurr,B] :
      ( range_8_5(B)
     => ( v13229(VarCurr,B)
      <=> v15240(VarCurr,B) ) ) ).

fof(range_axiom_197,axiom,
    ! [B] :
      ( range_8_5(B)
    <=> ( $false
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B ) ) ).

fof(addAssignment_43148,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex8)
    <=> v132178(VarCurr,bitIndex8) ) ).

fof(addAssignment_43147,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex7)
    <=> v132178(VarCurr,bitIndex7) ) ).

fof(addAssignment_43146,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex6)
    <=> v132178(VarCurr,bitIndex6) ) ).

fof(addAssignment_43145,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex5)
    <=> v132178(VarCurr,bitIndex5) ) ).

fof(addAssignment_43144,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex4)
    <=> v132178(VarCurr,bitIndex4) ) ).

fof(addAssignment_43143,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex3)
    <=> v132178(VarCurr,bitIndex3) ) ).

fof(addAssignment_43142,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex2)
    <=> v132178(VarCurr,bitIndex2) ) ).

fof(addAssignment_43141,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex1)
    <=> v132178(VarCurr,bitIndex1) ) ).

fof(addAssignment_43140,axiom,
    ! [VarCurr] :
      ( v131898(VarCurr,bitIndex0)
    <=> v132178(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_125,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132178(VarCurr,B)
      <=> ( v132180(VarCurr,B)
          | v132273(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_124,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132273(VarCurr,B)
      <=> ( v132274(VarCurr,B)
          & v132366(VarCurr,B) ) ) ) ).

fof(addAssignment_43139,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43138,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43137,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43136,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43135,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43134,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43133,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43132,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43131,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43130,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43129,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43128,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43127,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43126,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43125,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43124,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43123,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43122,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43121,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43120,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43119,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43118,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43117,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43116,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43115,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43114,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43113,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43112,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43111,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43110,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43109,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43108,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43107,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43106,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43105,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43104,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43103,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex36)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43102,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex37)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43101,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex38)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43100,axiom,
    ! [VarCurr] :
      ( v132366(VarCurr,bitIndex39)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(addAssignment_43099,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132274(VarCurr,B)
      <=> v132276(VarCurr,B) ) ) ).

fof(addAssignment_43098,axiom,
    ! [VarCurr] :
      ( ( v132274(VarCurr,bitIndex39)
      <=> $false )
      & ( v132274(VarCurr,bitIndex38)
      <=> $false )
      & ( v132274(VarCurr,bitIndex37)
      <=> $false )
      & ( v132274(VarCurr,bitIndex36)
      <=> $false )
      & ( v132274(VarCurr,bitIndex35)
      <=> $false )
      & ( v132274(VarCurr,bitIndex34)
      <=> $false )
      & ( v132274(VarCurr,bitIndex33)
      <=> $false )
      & ( v132274(VarCurr,bitIndex32)
      <=> $false )
      & ( v132274(VarCurr,bitIndex31)
      <=> $false )
      & ( v132274(VarCurr,bitIndex30)
      <=> $false )
      & ( v132274(VarCurr,bitIndex29)
      <=> $false )
      & ( v132274(VarCurr,bitIndex28)
      <=> $false )
      & ( v132274(VarCurr,bitIndex27)
      <=> $false )
      & ( v132274(VarCurr,bitIndex26)
      <=> $false )
      & ( v132274(VarCurr,bitIndex25)
      <=> $false )
      & ( v132274(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(bitBlastConstant_12712,axiom,
    ~ b0000000000000000(bitIndex15) ).

fof(bitBlastConstant_12711,axiom,
    ~ b0000000000000000(bitIndex14) ).

fof(bitBlastConstant_12710,axiom,
    ~ b0000000000000000(bitIndex13) ).

fof(bitBlastConstant_12709,axiom,
    ~ b0000000000000000(bitIndex12) ).

fof(bitBlastConstant_12708,axiom,
    ~ b0000000000000000(bitIndex11) ).

fof(bitBlastConstant_12707,axiom,
    ~ b0000000000000000(bitIndex10) ).

fof(bitBlastConstant_12706,axiom,
    ~ b0000000000000000(bitIndex9) ).

fof(bitBlastConstant_12705,axiom,
    ~ b0000000000000000(bitIndex8) ).

fof(bitBlastConstant_12704,axiom,
    ~ b0000000000000000(bitIndex7) ).

fof(bitBlastConstant_12703,axiom,
    ~ b0000000000000000(bitIndex6) ).

fof(bitBlastConstant_12702,axiom,
    ~ b0000000000000000(bitIndex5) ).

fof(bitBlastConstant_12701,axiom,
    ~ b0000000000000000(bitIndex4) ).

fof(bitBlastConstant_12700,axiom,
    ~ b0000000000000000(bitIndex3) ).

fof(bitBlastConstant_12699,axiom,
    ~ b0000000000000000(bitIndex2) ).

fof(bitBlastConstant_12698,axiom,
    ~ b0000000000000000(bitIndex1) ).

fof(bitBlastConstant_12697,axiom,
    ~ b0000000000000000(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_123,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132276(VarCurr,B)
      <=> ( v132277(VarCurr,B)
          | v132321(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_122,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132321(VarCurr,B)
      <=> ( v132322(VarCurr,B)
          & v132365(VarCurr,B) ) ) ) ).

fof(addAssignment_43097,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43096,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43095,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43094,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43093,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43092,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43091,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43090,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43089,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43088,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43087,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43086,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43085,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43084,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43083,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43082,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43081,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43080,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43079,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43078,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43077,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43076,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43075,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43074,axiom,
    ! [VarCurr] :
      ( v132365(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_43073,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132322(VarCurr,B)
      <=> v132323(VarCurr,B) ) ) ).

fof(addAssignment_43072,axiom,
    ! [VarCurr] :
      ( ( v132322(VarCurr,bitIndex23)
      <=> $false )
      & ( v132322(VarCurr,bitIndex22)
      <=> $false )
      & ( v132322(VarCurr,bitIndex21)
      <=> $false )
      & ( v132322(VarCurr,bitIndex20)
      <=> $false )
      & ( v132322(VarCurr,bitIndex19)
      <=> $false )
      & ( v132322(VarCurr,bitIndex18)
      <=> $false )
      & ( v132322(VarCurr,bitIndex17)
      <=> $false )
      & ( v132322(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_121,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132323(VarCurr,B)
      <=> ( v132324(VarCurr,B)
          | v132344(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_120,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132344(VarCurr,B)
      <=> ( v132345(VarCurr,B)
          & v132364(VarCurr,B) ) ) ) ).

fof(addAssignment_43071,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43070,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43069,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43068,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43067,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43066,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43065,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43064,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43063,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43062,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43061,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43060,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43059,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43058,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43057,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43056,axiom,
    ! [VarCurr] :
      ( v132364(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_43055,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132345(VarCurr,B)
      <=> v132346(VarCurr,B) ) ) ).

fof(addAssignment_43054,axiom,
    ! [VarCurr] :
      ( ( v132345(VarCurr,bitIndex15)
      <=> $false )
      & ( v132345(VarCurr,bitIndex14)
      <=> $false )
      & ( v132345(VarCurr,bitIndex13)
      <=> $false )
      & ( v132345(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_119,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132346(VarCurr,B)
      <=> ( v132347(VarCurr,B)
          | v132355(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_118,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132355(VarCurr,B)
      <=> ( v132356(VarCurr,B)
          & v132363(VarCurr,B) ) ) ) ).

fof(addAssignment_43053,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43052,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43051,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43050,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43049,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43048,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43047,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43046,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43045,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43044,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43043,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43042,axiom,
    ! [VarCurr] :
      ( v132363(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_43041,axiom,
    ! [VarCurr,B] :
      ( range_9_0(B)
     => ( v132356(VarCurr,B)
      <=> v132357(VarCurr,B) ) ) ).

fof(addAssignment_43040,axiom,
    ! [VarCurr] :
      ( ( v132356(VarCurr,bitIndex11)
      <=> $false )
      & ( v132356(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_117,axiom,
    ! [VarCurr,B] :
      ( range_9_0(B)
     => ( v132357(VarCurr,B)
      <=> ( v132358(VarCurr,B)
          | v132360(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_116,axiom,
    ! [VarCurr,B] :
      ( range_9_0(B)
     => ( v132360(VarCurr,B)
      <=> ( v132361(VarCurr,B)
          & v132362(VarCurr,B) ) ) ) ).

fof(addAssignment_43039,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43038,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43037,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43036,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43035,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43034,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43033,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43032,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43031,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43030,axiom,
    ! [VarCurr] :
      ( v132362(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43029,axiom,
    ! [VarCurr] :
      ( ( v132361(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132361(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132361(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132361(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132361(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132361(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132361(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132361(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132361(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_43028,axiom,
    ! [VarCurr] :
      ( v132361(VarCurr,bitIndex9)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2986,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132359(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2985,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132359(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2984,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132359(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2983,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132359(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2982,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132359(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2981,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132359(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2980,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132359(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2979,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132359(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2978,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132359(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2977,axiom,
    ! [VarCurr] :
      ( v132358(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132359(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_43027,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43026,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43025,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43024,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43023,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43022,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43021,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43020,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43019,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_43018,axiom,
    ! [VarCurr] :
      ( v132359(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_115,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132347(VarCurr,B)
      <=> ( v132348(VarCurr,B)
          & v132354(VarCurr,B) ) ) ) ).

fof(addAssignment_43017,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43016,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43015,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43014,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43013,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43012,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43011,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43010,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43009,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43008,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43007,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_43006,axiom,
    ! [VarCurr] :
      ( v132354(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_114,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132348(VarCurr,B)
      <=> ( v132349(VarCurr,B)
          | v132351(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_113,axiom,
    ! [VarCurr,B] :
      ( range_11_0(B)
     => ( v132351(VarCurr,B)
      <=> ( v132352(VarCurr,B)
          & v132353(VarCurr,B) ) ) ) ).

fof(addAssignment_43005,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43004,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43003,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43002,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43001,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_43000,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42999,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42998,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42997,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42996,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42995,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42994,axiom,
    ! [VarCurr] :
      ( v132353(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42993,axiom,
    ! [VarCurr] :
      ( ( v132352(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132352(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132352(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132352(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132352(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132352(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132352(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132352(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132352(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132352(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132352(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex29) ) ) ).

fof(addAssignment_42992,axiom,
    ! [VarCurr] :
      ( v132352(VarCurr,bitIndex11)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2976,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132350(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2975,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132350(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2974,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132350(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2973,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132350(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2972,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132350(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2971,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132350(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2970,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132350(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2969,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132350(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2968,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132350(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2967,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132350(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2966,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132350(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2965,axiom,
    ! [VarCurr] :
      ( v132349(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132350(VarCurr,bitIndex11) ) ) ).

fof(addAssignment_42991,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42990,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42989,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42988,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42987,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42986,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42985,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42984,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42983,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42982,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42981,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42980,axiom,
    ! [VarCurr] :
      ( v132350(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_112,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132324(VarCurr,B)
      <=> ( v132325(VarCurr,B)
          & v132343(VarCurr,B) ) ) ) ).

fof(addAssignment_42979,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex0)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42978,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex1)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42977,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex2)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42976,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex3)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42975,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex4)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42974,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex5)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42973,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex6)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42972,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex7)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42971,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex8)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42970,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex9)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42969,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex10)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42968,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex11)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42967,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex12)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42966,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex13)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42965,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex14)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42964,axiom,
    ! [VarCurr] :
      ( v132343(VarCurr,bitIndex15)
    <=> v132085(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_111,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132325(VarCurr,B)
      <=> ( v132326(VarCurr,B)
          | v132334(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_110,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132334(VarCurr,B)
      <=> ( v132335(VarCurr,B)
          & v132342(VarCurr,B) ) ) ) ).

fof(addAssignment_42963,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42962,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42961,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42960,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42959,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42958,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42957,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42956,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42955,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42954,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42953,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42952,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42951,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42950,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42949,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42948,axiom,
    ! [VarCurr] :
      ( v132342(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42947,axiom,
    ! [VarCurr,B] :
      ( range_13_0(B)
     => ( v132335(VarCurr,B)
      <=> v132336(VarCurr,B) ) ) ).

fof(addAssignment_42946,axiom,
    ! [VarCurr] :
      ( ( v132335(VarCurr,bitIndex15)
      <=> $false )
      & ( v132335(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_109,axiom,
    ! [VarCurr,B] :
      ( range_13_0(B)
     => ( v132336(VarCurr,B)
      <=> ( v132337(VarCurr,B)
          | v132339(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_108,axiom,
    ! [VarCurr,B] :
      ( range_13_0(B)
     => ( v132339(VarCurr,B)
      <=> ( v132340(VarCurr,B)
          & v132341(VarCurr,B) ) ) ) ).

fof(addAssignment_42945,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42944,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42943,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42942,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42941,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42940,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42939,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42938,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42937,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42936,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42935,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42934,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42933,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42932,axiom,
    ! [VarCurr] :
      ( v132341(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42931,axiom,
    ! [VarCurr] :
      ( ( v132340(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132340(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132340(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132340(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132340(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132340(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132340(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132340(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132340(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132340(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132340(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132340(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132340(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex27) ) ) ).

fof(addAssignment_42930,axiom,
    ! [VarCurr] :
      ( v132340(VarCurr,bitIndex13)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2964,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132338(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2963,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132338(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2962,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132338(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2961,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132338(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2960,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132338(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2959,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132338(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2958,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132338(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2957,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132338(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2956,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132338(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2955,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132338(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2954,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132338(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2953,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132338(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2952,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132338(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2951,axiom,
    ! [VarCurr] :
      ( v132337(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132338(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_42929,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42928,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42927,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42926,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42925,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42924,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42923,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42922,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42921,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42920,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42919,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42918,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42917,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42916,axiom,
    ! [VarCurr] :
      ( v132338(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_107,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132326(VarCurr,B)
      <=> ( v132327(VarCurr,B)
          & v132333(VarCurr,B) ) ) ) ).

fof(addAssignment_42915,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42914,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42913,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42912,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42911,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42910,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42909,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42908,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42907,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42906,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42905,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42904,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42903,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42902,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42901,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42900,axiom,
    ! [VarCurr] :
      ( v132333(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_106,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132327(VarCurr,B)
      <=> ( v132328(VarCurr,B)
          | v132330(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_105,axiom,
    ! [VarCurr,B] :
      ( range_15_0(B)
     => ( v132330(VarCurr,B)
      <=> ( v132331(VarCurr,B)
          & v132332(VarCurr,B) ) ) ) ).

fof(addAssignment_42899,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42898,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42897,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42896,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42895,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42894,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42893,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42892,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42891,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42890,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42889,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42888,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42887,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42886,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42885,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42884,axiom,
    ! [VarCurr] :
      ( v132332(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42883,axiom,
    ! [VarCurr] :
      ( ( v132331(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132331(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132331(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132331(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132331(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132331(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132331(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132331(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132331(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132331(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132331(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132331(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132331(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132331(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132331(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex25) ) ) ).

fof(addAssignment_42882,axiom,
    ! [VarCurr] :
      ( v132331(VarCurr,bitIndex15)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2950,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132329(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2949,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132329(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2948,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132329(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2947,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132329(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2946,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132329(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2945,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132329(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2944,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132329(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2943,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132329(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2942,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132329(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2941,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132329(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2940,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132329(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2939,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132329(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2938,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132329(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2937,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132329(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2936,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132329(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2935,axiom,
    ! [VarCurr] :
      ( v132328(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132329(VarCurr,bitIndex15) ) ) ).

fof(addAssignment_42881,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42880,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42879,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42878,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42877,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42876,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42875,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42874,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42873,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42872,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42871,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42870,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42869,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42868,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42867,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42866,axiom,
    ! [VarCurr] :
      ( v132329(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_104,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132277(VarCurr,B)
      <=> ( v132278(VarCurr,B)
          & v132320(VarCurr,B) ) ) ) ).

fof(addAssignment_42865,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex0)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42864,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex1)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42863,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex2)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42862,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex3)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42861,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex4)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42860,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex5)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42859,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex6)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42858,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex7)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42857,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex8)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42856,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex9)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42855,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex10)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42854,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex11)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42853,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex12)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42852,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex13)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42851,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex14)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42850,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex15)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42849,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex16)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42848,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex17)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42847,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex18)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42846,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex19)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42845,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex20)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42844,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex21)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42843,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex22)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42842,axiom,
    ! [VarCurr] :
      ( v132320(VarCurr,bitIndex23)
    <=> v132080(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_103,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132278(VarCurr,B)
      <=> ( v132279(VarCurr,B)
          | v132299(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_102,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132299(VarCurr,B)
      <=> ( v132300(VarCurr,B)
          & v132319(VarCurr,B) ) ) ) ).

fof(addAssignment_42841,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42840,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42839,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42838,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42837,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42836,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42835,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42834,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42833,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42832,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42831,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42830,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42829,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42828,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42827,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42826,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42825,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42824,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42823,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42822,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42821,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42820,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42819,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42818,axiom,
    ! [VarCurr] :
      ( v132319(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42817,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132300(VarCurr,B)
      <=> v132301(VarCurr,B) ) ) ).

fof(addAssignment_42816,axiom,
    ! [VarCurr] :
      ( ( v132300(VarCurr,bitIndex23)
      <=> $false )
      & ( v132300(VarCurr,bitIndex22)
      <=> $false )
      & ( v132300(VarCurr,bitIndex21)
      <=> $false )
      & ( v132300(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_101,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132301(VarCurr,B)
      <=> ( v132302(VarCurr,B)
          | v132310(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_100,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132310(VarCurr,B)
      <=> ( v132311(VarCurr,B)
          & v132318(VarCurr,B) ) ) ) ).

fof(addAssignment_42815,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42814,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42813,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42812,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42811,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42810,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42809,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42808,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42807,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42806,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42805,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42804,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42803,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42802,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42801,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42800,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42799,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42798,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42797,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42796,axiom,
    ! [VarCurr] :
      ( v132318(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42795,axiom,
    ! [VarCurr,B] :
      ( range_17_0(B)
     => ( v132311(VarCurr,B)
      <=> v132312(VarCurr,B) ) ) ).

fof(addAssignment_42794,axiom,
    ! [VarCurr] :
      ( ( v132311(VarCurr,bitIndex19)
      <=> $false )
      & ( v132311(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_99,axiom,
    ! [VarCurr,B] :
      ( range_17_0(B)
     => ( v132312(VarCurr,B)
      <=> ( v132313(VarCurr,B)
          | v132315(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_98,axiom,
    ! [VarCurr,B] :
      ( range_17_0(B)
     => ( v132315(VarCurr,B)
      <=> ( v132316(VarCurr,B)
          & v132317(VarCurr,B) ) ) ) ).

fof(addAssignment_42793,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42792,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42791,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42790,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42789,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42788,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42787,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42786,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42785,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42784,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42783,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42782,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42781,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42780,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42779,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42778,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42777,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42776,axiom,
    ! [VarCurr] :
      ( v132317(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42775,axiom,
    ! [VarCurr] :
      ( ( v132316(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132316(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132316(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132316(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132316(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132316(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132316(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132316(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132316(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132316(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132316(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132316(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132316(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132316(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132316(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132316(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132316(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex23) ) ) ).

fof(addAssignment_42774,axiom,
    ! [VarCurr] :
      ( v132316(VarCurr,bitIndex17)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2934,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132314(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2933,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132314(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2932,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132314(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2931,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132314(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2930,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132314(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2929,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132314(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2928,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132314(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2927,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132314(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2926,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132314(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2925,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132314(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2924,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132314(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2923,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132314(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2922,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132314(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2921,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132314(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2920,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132314(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2919,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132314(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2918,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132314(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2917,axiom,
    ! [VarCurr] :
      ( v132313(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132314(VarCurr,bitIndex17) ) ) ).

fof(addAssignment_42773,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42772,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42771,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42770,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42769,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42768,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42767,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42766,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42765,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42764,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42763,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42762,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42761,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42760,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42759,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42758,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42757,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42756,axiom,
    ! [VarCurr] :
      ( v132314(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_97,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132302(VarCurr,B)
      <=> ( v132303(VarCurr,B)
          & v132309(VarCurr,B) ) ) ) ).

fof(addAssignment_42755,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42754,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42753,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42752,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42751,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42750,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42749,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42748,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42747,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42746,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42745,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42744,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42743,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42742,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42741,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42740,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42739,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex16)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42738,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex17)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42737,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex18)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42736,axiom,
    ! [VarCurr] :
      ( v132309(VarCurr,bitIndex19)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_96,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132303(VarCurr,B)
      <=> ( v132304(VarCurr,B)
          | v132306(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_95,axiom,
    ! [VarCurr,B] :
      ( range_19_0(B)
     => ( v132306(VarCurr,B)
      <=> ( v132307(VarCurr,B)
          & v132308(VarCurr,B) ) ) ) ).

fof(addAssignment_42735,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42734,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42733,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42732,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42731,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42730,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42729,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42728,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42727,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42726,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42725,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42724,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42723,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42722,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42721,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42720,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42719,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42718,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42717,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42716,axiom,
    ! [VarCurr] :
      ( v132308(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42715,axiom,
    ! [VarCurr] :
      ( ( v132307(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132307(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132307(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132307(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132307(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132307(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132307(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132307(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132307(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132307(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132307(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132307(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132307(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132307(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132307(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132307(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132307(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132307(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132307(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex21) ) ) ).

fof(addAssignment_42714,axiom,
    ! [VarCurr] :
      ( v132307(VarCurr,bitIndex19)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2916,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132305(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2915,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132305(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2914,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132305(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2913,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132305(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2912,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132305(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2911,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132305(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2910,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132305(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2909,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132305(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2908,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132305(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2907,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132305(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2906,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132305(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2905,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132305(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2904,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132305(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2903,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132305(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2902,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132305(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2901,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132305(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2900,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132305(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2899,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132305(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2898,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132305(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2897,axiom,
    ! [VarCurr] :
      ( v132304(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132305(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_42713,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42712,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42711,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42710,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42709,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42708,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42707,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42706,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42705,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42704,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42703,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42702,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42701,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42700,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42699,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42698,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42697,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42696,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42695,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42694,axiom,
    ! [VarCurr] :
      ( v132305(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_94,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132279(VarCurr,B)
      <=> ( v132280(VarCurr,B)
          & v132298(VarCurr,B) ) ) ) ).

fof(addAssignment_42693,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex0)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42692,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex1)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42691,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex2)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42690,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex3)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42689,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex4)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42688,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex5)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42687,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex6)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42686,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex7)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42685,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex8)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42684,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex9)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42683,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex10)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42682,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex11)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42681,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex12)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42680,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex13)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42679,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex14)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42678,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex15)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42677,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex16)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42676,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex17)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42675,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex18)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42674,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex19)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42673,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex20)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42672,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex21)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42671,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex22)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42670,axiom,
    ! [VarCurr] :
      ( v132298(VarCurr,bitIndex23)
    <=> v132085(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_93,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132280(VarCurr,B)
      <=> ( v132281(VarCurr,B)
          | v132289(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_92,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132289(VarCurr,B)
      <=> ( v132290(VarCurr,B)
          & v132297(VarCurr,B) ) ) ) ).

fof(addAssignment_42669,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42668,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42667,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42666,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42665,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42664,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42663,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42662,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42661,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42660,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42659,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42658,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42657,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42656,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42655,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42654,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42653,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42652,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42651,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42650,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42649,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42648,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42647,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42646,axiom,
    ! [VarCurr] :
      ( v132297(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42645,axiom,
    ! [VarCurr,B] :
      ( range_21_0(B)
     => ( v132290(VarCurr,B)
      <=> v132291(VarCurr,B) ) ) ).

fof(addAssignment_42644,axiom,
    ! [VarCurr] :
      ( ( v132290(VarCurr,bitIndex23)
      <=> $false )
      & ( v132290(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_91,axiom,
    ! [VarCurr,B] :
      ( range_21_0(B)
     => ( v132291(VarCurr,B)
      <=> ( v132292(VarCurr,B)
          | v132294(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_90,axiom,
    ! [VarCurr,B] :
      ( range_21_0(B)
     => ( v132294(VarCurr,B)
      <=> ( v132295(VarCurr,B)
          & v132296(VarCurr,B) ) ) ) ).

fof(range_axiom_196,axiom,
    ! [B] :
      ( range_21_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B ) ) ).

fof(addAssignment_42643,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42642,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42641,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42640,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42639,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42638,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42637,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42636,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42635,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42634,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42633,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42632,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42631,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42630,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42629,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42628,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42627,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42626,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42625,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42624,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42623,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42622,axiom,
    ! [VarCurr] :
      ( v132296(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42621,axiom,
    ! [VarCurr] :
      ( ( v132295(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132295(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132295(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132295(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132295(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132295(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132295(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132295(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132295(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132295(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132295(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132295(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132295(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132295(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132295(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132295(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132295(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132295(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132295(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132295(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132295(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex19) ) ) ).

fof(addAssignment_42620,axiom,
    ! [VarCurr] :
      ( v132295(VarCurr,bitIndex21)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2896,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132293(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2895,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132293(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2894,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132293(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2893,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132293(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2892,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132293(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2891,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132293(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2890,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132293(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2889,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132293(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2888,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132293(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2887,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132293(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2886,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132293(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2885,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132293(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2884,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132293(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2883,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132293(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2882,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132293(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2881,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132293(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2880,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132293(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2879,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132293(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2878,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132293(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2877,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132293(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2876,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132293(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2875,axiom,
    ! [VarCurr] :
      ( v132292(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132293(VarCurr,bitIndex21) ) ) ).

fof(addAssignment_42619,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42618,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42617,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42616,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42615,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42614,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42613,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42612,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42611,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42610,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42609,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42608,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42607,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42606,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42605,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42604,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42603,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42602,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42601,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42600,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42599,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42598,axiom,
    ! [VarCurr] :
      ( v132293(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_89,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132281(VarCurr,B)
      <=> ( v132282(VarCurr,B)
          & v132288(VarCurr,B) ) ) ) ).

fof(addAssignment_42597,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42596,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42595,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42594,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42593,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42592,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42591,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42590,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42589,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42588,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42587,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42586,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42585,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42584,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42583,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42582,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42581,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex16)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42580,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex17)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42579,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex18)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42578,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex19)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42577,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex20)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42576,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex21)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42575,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex22)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42574,axiom,
    ! [VarCurr] :
      ( v132288(VarCurr,bitIndex23)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_88,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132282(VarCurr,B)
      <=> ( v132283(VarCurr,B)
          | v132285(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_87,axiom,
    ! [VarCurr,B] :
      ( range_23_0(B)
     => ( v132285(VarCurr,B)
      <=> ( v132286(VarCurr,B)
          & v132287(VarCurr,B) ) ) ) ).

fof(addAssignment_42573,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42572,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42571,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42570,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42569,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42568,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42567,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42566,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42565,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42564,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42563,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42562,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42561,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42560,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42559,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42558,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42557,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42556,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42555,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42554,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42553,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42552,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42551,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42550,axiom,
    ! [VarCurr] :
      ( v132287(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42549,axiom,
    ! [VarCurr] :
      ( ( v132286(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132286(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132286(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132286(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132286(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132286(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132286(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132286(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132286(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132286(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132286(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132286(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132286(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132286(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132286(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132286(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132286(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132286(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132286(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132286(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132286(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132286(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132286(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex17) ) ) ).

fof(addAssignment_42548,axiom,
    ! [VarCurr] :
      ( v132286(VarCurr,bitIndex23)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2874,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132284(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2873,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132284(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2872,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132284(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2871,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132284(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2870,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132284(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2869,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132284(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2868,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132284(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2867,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132284(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2866,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132284(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2865,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132284(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2864,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132284(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2863,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132284(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2862,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132284(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2861,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132284(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2860,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132284(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2859,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132284(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2858,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132284(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2857,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132284(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2856,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132284(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2855,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132284(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2854,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132284(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2853,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132284(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2852,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132284(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2851,axiom,
    ! [VarCurr] :
      ( v132283(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132284(VarCurr,bitIndex23) ) ) ).

fof(addAssignment_42547,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42546,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42545,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42544,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42543,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42542,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42541,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42540,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42539,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42538,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42537,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42536,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42535,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42534,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42533,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42532,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42531,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42530,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42529,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42528,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42527,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42526,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42525,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42524,axiom,
    ! [VarCurr] :
      ( v132284(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_86,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132180(VarCurr,B)
      <=> ( v132181(VarCurr,B)
          & v132272(VarCurr,B) ) ) ) ).

fof(addAssignment_42523,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex0)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42522,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex1)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42521,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex2)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42520,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex3)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42519,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex4)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42518,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex5)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42517,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex6)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42516,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex7)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42515,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex8)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42514,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex9)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42513,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex10)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42512,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex11)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42511,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex12)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42510,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex13)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42509,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex14)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42508,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex15)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42507,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex16)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42506,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex17)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42505,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex18)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42504,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex19)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42503,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex20)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42502,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex21)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42501,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex22)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42500,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex23)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42499,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex24)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42498,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex25)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42497,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex26)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42496,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex27)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42495,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex28)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42494,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex29)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42493,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex30)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42492,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex31)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42491,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex32)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42490,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex33)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42489,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex34)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42488,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex35)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42487,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex36)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42486,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex37)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42485,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex38)
    <=> v132075(VarCurr) ) ).

fof(addAssignment_42484,axiom,
    ! [VarCurr] :
      ( v132272(VarCurr,bitIndex39)
    <=> v132075(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_85,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132181(VarCurr,B)
      <=> ( v132182(VarCurr,B)
          | v132227(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_84,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132227(VarCurr,B)
      <=> ( v132228(VarCurr,B)
          & v132271(VarCurr,B) ) ) ) ).

fof(addAssignment_42483,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42482,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42481,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42480,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42479,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42478,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42477,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42476,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42475,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42474,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42473,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42472,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42471,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42470,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42469,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42468,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42467,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42466,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42465,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42464,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42463,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42462,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42461,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42460,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42459,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42458,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42457,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42456,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42455,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42454,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42453,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42452,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42451,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42450,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42449,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42448,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42447,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex36)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42446,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex37)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42445,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex38)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42444,axiom,
    ! [VarCurr] :
      ( v132271(VarCurr,bitIndex39)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(addAssignment_42443,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132228(VarCurr,B)
      <=> v132229(VarCurr,B) ) ) ).

fof(addAssignment_42442,axiom,
    ! [VarCurr] :
      ( ( v132228(VarCurr,bitIndex39)
      <=> $false )
      & ( v132228(VarCurr,bitIndex38)
      <=> $false )
      & ( v132228(VarCurr,bitIndex37)
      <=> $false )
      & ( v132228(VarCurr,bitIndex36)
      <=> $false )
      & ( v132228(VarCurr,bitIndex35)
      <=> $false )
      & ( v132228(VarCurr,bitIndex34)
      <=> $false )
      & ( v132228(VarCurr,bitIndex33)
      <=> $false )
      & ( v132228(VarCurr,bitIndex32)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_83,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132229(VarCurr,B)
      <=> ( v132230(VarCurr,B)
          | v132250(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_82,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132250(VarCurr,B)
      <=> ( v132251(VarCurr,B)
          & v132270(VarCurr,B) ) ) ) ).

fof(addAssignment_42441,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42440,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42439,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42438,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42437,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42436,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42435,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42434,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42433,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42432,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42431,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42430,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42429,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42428,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42427,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42426,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42425,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42424,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42423,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42422,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42421,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42420,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42419,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42418,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42417,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42416,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42415,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42414,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42413,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42412,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42411,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42410,axiom,
    ! [VarCurr] :
      ( v132270(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_42409,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132251(VarCurr,B)
      <=> v132252(VarCurr,B) ) ) ).

fof(addAssignment_42408,axiom,
    ! [VarCurr] :
      ( ( v132251(VarCurr,bitIndex31)
      <=> $false )
      & ( v132251(VarCurr,bitIndex30)
      <=> $false )
      & ( v132251(VarCurr,bitIndex29)
      <=> $false )
      & ( v132251(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_81,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132252(VarCurr,B)
      <=> ( v132253(VarCurr,B)
          | v132261(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_80,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132261(VarCurr,B)
      <=> ( v132262(VarCurr,B)
          & v132269(VarCurr,B) ) ) ) ).

fof(addAssignment_42407,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42406,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42405,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42404,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42403,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42402,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42401,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42400,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42399,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42398,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42397,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42396,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42395,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42394,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42393,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42392,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42391,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42390,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42389,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42388,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42387,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42386,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42385,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42384,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42383,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42382,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42381,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42380,axiom,
    ! [VarCurr] :
      ( v132269(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42379,axiom,
    ! [VarCurr,B] :
      ( range_25_0(B)
     => ( v132262(VarCurr,B)
      <=> v132263(VarCurr,B) ) ) ).

fof(addAssignment_42378,axiom,
    ! [VarCurr] :
      ( ( v132262(VarCurr,bitIndex27)
      <=> $false )
      & ( v132262(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_79,axiom,
    ! [VarCurr,B] :
      ( range_25_0(B)
     => ( v132263(VarCurr,B)
      <=> ( v132264(VarCurr,B)
          | v132266(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_78,axiom,
    ! [VarCurr,B] :
      ( range_25_0(B)
     => ( v132266(VarCurr,B)
      <=> ( v132267(VarCurr,B)
          & v132268(VarCurr,B) ) ) ) ).

fof(addAssignment_42377,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42376,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42375,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42374,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42373,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42372,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42371,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42370,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42369,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42368,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42367,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42366,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42365,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42364,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42363,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42362,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42361,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42360,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42359,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42358,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42357,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42356,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42355,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42354,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42353,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42352,axiom,
    ! [VarCurr] :
      ( v132268(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42351,axiom,
    ! [VarCurr] :
      ( ( v132267(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132267(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132267(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132267(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132267(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132267(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132267(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132267(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132267(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132267(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132267(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132267(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132267(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132267(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132267(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132267(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132267(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132267(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132267(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132267(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132267(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132267(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132267(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132267(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132267(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex15) ) ) ).

fof(addAssignment_42350,axiom,
    ! [VarCurr] :
      ( v132267(VarCurr,bitIndex25)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2850,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132265(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2849,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132265(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2848,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132265(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2847,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132265(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2846,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132265(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2845,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132265(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2844,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132265(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2843,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132265(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2842,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132265(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2841,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132265(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2840,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132265(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2839,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132265(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2838,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132265(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2837,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132265(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2836,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132265(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2835,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132265(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2834,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132265(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2833,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132265(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2832,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132265(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2831,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132265(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2830,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132265(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2829,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132265(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2828,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132265(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2827,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132265(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2826,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132265(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2825,axiom,
    ! [VarCurr] :
      ( v132264(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132265(VarCurr,bitIndex25) ) ) ).

fof(addAssignment_42349,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42348,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42347,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42346,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42345,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42344,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42343,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42342,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42341,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42340,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42339,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42338,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42337,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42336,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42335,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42334,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42333,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42332,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42331,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42330,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42329,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42328,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42327,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42326,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42325,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42324,axiom,
    ! [VarCurr] :
      ( v132265(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_77,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132253(VarCurr,B)
      <=> ( v132254(VarCurr,B)
          & v132260(VarCurr,B) ) ) ) ).

fof(addAssignment_42323,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42322,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42321,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42320,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42319,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42318,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42317,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42316,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42315,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42314,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42313,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42312,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42311,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42310,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42309,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42308,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42307,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex16)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42306,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex17)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42305,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex18)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42304,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex19)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42303,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex20)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42302,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex21)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42301,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex22)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42300,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex23)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42299,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex24)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42298,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex25)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42297,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex26)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42296,axiom,
    ! [VarCurr] :
      ( v132260(VarCurr,bitIndex27)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_76,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132254(VarCurr,B)
      <=> ( v132255(VarCurr,B)
          | v132257(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_75,axiom,
    ! [VarCurr,B] :
      ( range_27_0(B)
     => ( v132257(VarCurr,B)
      <=> ( v132258(VarCurr,B)
          & v132259(VarCurr,B) ) ) ) ).

fof(addAssignment_42295,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42294,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42293,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42292,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42291,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42290,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42289,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42288,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42287,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42286,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42285,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42284,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42283,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42282,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42281,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42280,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42279,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42278,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42277,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42276,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42275,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42274,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42273,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42272,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42271,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42270,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42269,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42268,axiom,
    ! [VarCurr] :
      ( v132259(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42267,axiom,
    ! [VarCurr] :
      ( ( v132258(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132258(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132258(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132258(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132258(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132258(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132258(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132258(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132258(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132258(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132258(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132258(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132258(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132258(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132258(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132258(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132258(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132258(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132258(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132258(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132258(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132258(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132258(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132258(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132258(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132258(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132258(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_42266,axiom,
    ! [VarCurr] :
      ( v132258(VarCurr,bitIndex27)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2824,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex12)
        & v132256(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2823,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex13)
        & v132256(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2822,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132256(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2821,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132256(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2820,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132256(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2819,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132256(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2818,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132256(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2817,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132256(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2816,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132256(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2815,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132256(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2814,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132256(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2813,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132256(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2812,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132256(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2811,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132256(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2810,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132256(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2809,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132256(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2808,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132256(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2807,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132256(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2806,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132256(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2805,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132256(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2804,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132256(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2803,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132256(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2802,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132256(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2801,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132256(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2800,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132256(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2799,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132256(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2798,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex26)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132256(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2797,axiom,
    ! [VarCurr] :
      ( v132255(VarCurr,bitIndex27)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132256(VarCurr,bitIndex27) ) ) ).

fof(addAssignment_42265,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42264,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42263,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42262,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42261,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42260,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42259,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42258,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42257,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42256,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42255,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42254,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42253,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42252,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42251,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42250,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42249,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42248,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42247,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42246,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42245,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42244,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42243,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42242,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42241,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42240,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42239,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42238,axiom,
    ! [VarCurr] :
      ( v132256(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_74,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132230(VarCurr,B)
      <=> ( v132231(VarCurr,B)
          & v132249(VarCurr,B) ) ) ) ).

fof(addAssignment_42237,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex0)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42236,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex1)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42235,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex2)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42234,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex3)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42233,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex4)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42232,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex5)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42231,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex6)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42230,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex7)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42229,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex8)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42228,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex9)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42227,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex10)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42226,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex11)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42225,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex12)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42224,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex13)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42223,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex14)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42222,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex15)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42221,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex16)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42220,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex17)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42219,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex18)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42218,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex19)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42217,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex20)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42216,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex21)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42215,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex22)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42214,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex23)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42213,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex24)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42212,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex25)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42211,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex26)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42210,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex27)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42209,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex28)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42208,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex29)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42207,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex30)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_42206,axiom,
    ! [VarCurr] :
      ( v132249(VarCurr,bitIndex31)
    <=> v132085(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_73,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132231(VarCurr,B)
      <=> ( v132232(VarCurr,B)
          | v132240(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_72,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132240(VarCurr,B)
      <=> ( v132241(VarCurr,B)
          & v132248(VarCurr,B) ) ) ) ).

fof(addAssignment_42205,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42204,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42203,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42202,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42201,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42200,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42199,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42198,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42197,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42196,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42195,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42194,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42193,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42192,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42191,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42190,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42189,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42188,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42187,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42186,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42185,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42184,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42183,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42182,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42181,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42180,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42179,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42178,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42177,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42176,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42175,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42174,axiom,
    ! [VarCurr] :
      ( v132248(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_42173,axiom,
    ! [VarCurr,B] :
      ( range_29_0(B)
     => ( v132241(VarCurr,B)
      <=> v132242(VarCurr,B) ) ) ).

fof(addAssignment_42172,axiom,
    ! [VarCurr] :
      ( ( v132241(VarCurr,bitIndex31)
      <=> $false )
      & ( v132241(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_71,axiom,
    ! [VarCurr,B] :
      ( range_29_0(B)
     => ( v132242(VarCurr,B)
      <=> ( v132243(VarCurr,B)
          | v132245(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_70,axiom,
    ! [VarCurr,B] :
      ( range_29_0(B)
     => ( v132245(VarCurr,B)
      <=> ( v132246(VarCurr,B)
          & v132247(VarCurr,B) ) ) ) ).

fof(range_axiom_195,axiom,
    ! [B] :
      ( range_29_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B ) ) ).

fof(addAssignment_42171,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42170,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42169,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42168,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42167,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42166,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42165,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42164,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42163,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42162,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42161,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42160,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42159,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42158,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42157,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42156,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42155,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42154,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42153,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42152,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42151,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42150,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42149,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42148,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42147,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42146,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42145,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42144,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42143,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42142,axiom,
    ! [VarCurr] :
      ( v132247(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42141,axiom,
    ! [VarCurr] :
      ( ( v132246(VarCurr,bitIndex28)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132246(VarCurr,bitIndex27)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132246(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132246(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132246(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132246(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132246(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132246(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132246(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132246(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132246(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132246(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132246(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132246(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132246(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132246(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132246(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132246(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132246(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132246(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132246(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132246(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132246(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132246(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132246(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132246(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132246(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex13) )
      & ( v132246(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex12) )
      & ( v132246(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex11) ) ) ).

fof(addAssignment_42140,axiom,
    ! [VarCurr] :
      ( v132246(VarCurr,bitIndex29)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2796,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex10)
        & v132244(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2795,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex11)
        & v132244(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2794,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex12)
        & v132244(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2793,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex13)
        & v132244(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2792,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132244(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2791,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132244(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2790,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132244(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2789,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132244(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2788,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132244(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2787,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132244(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2786,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132244(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2785,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132244(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2784,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132244(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2783,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132244(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2782,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132244(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2781,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132244(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2780,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132244(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2779,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132244(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2778,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132244(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2777,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132244(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2776,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132244(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2775,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132244(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2774,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132244(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2773,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132244(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2772,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132244(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2771,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132244(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2770,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex26)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132244(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2769,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex27)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132244(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2768,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex28)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132244(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2767,axiom,
    ! [VarCurr] :
      ( v132243(VarCurr,bitIndex29)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132244(VarCurr,bitIndex29) ) ) ).

fof(addAssignment_42139,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42138,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42137,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42136,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42135,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42134,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42133,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42132,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42131,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42130,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42129,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42128,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42127,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42126,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42125,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42124,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42123,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42122,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42121,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42120,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42119,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42118,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42117,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42116,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42115,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42114,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42113,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42112,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42111,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex28)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42110,axiom,
    ! [VarCurr] :
      ( v132244(VarCurr,bitIndex29)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_69,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132232(VarCurr,B)
      <=> ( v132233(VarCurr,B)
          & v132239(VarCurr,B) ) ) ) ).

fof(addAssignment_42109,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42108,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42107,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42106,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42105,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42104,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42103,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42102,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42101,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42100,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42099,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42098,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42097,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42096,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42095,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42094,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42093,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex16)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42092,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex17)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42091,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex18)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42090,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex19)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42089,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex20)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42088,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex21)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42087,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex22)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42086,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex23)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42085,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex24)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42084,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex25)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42083,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex26)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42082,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex27)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42081,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex28)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42080,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex29)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42079,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex30)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_42078,axiom,
    ! [VarCurr] :
      ( v132239(VarCurr,bitIndex31)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_68,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132233(VarCurr,B)
      <=> ( v132234(VarCurr,B)
          | v132236(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_67,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132236(VarCurr,B)
      <=> ( v132237(VarCurr,B)
          & v132238(VarCurr,B) ) ) ) ).

fof(addAssignment_42077,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42076,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42075,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42074,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42073,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42072,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42071,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42070,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42069,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42068,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42067,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42066,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42065,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42064,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42063,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42062,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42061,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42060,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42059,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42058,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42057,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42056,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42055,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42054,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42053,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42052,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42051,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42050,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42049,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42048,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42047,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42046,axiom,
    ! [VarCurr] :
      ( v132238(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_42045,axiom,
    ! [VarCurr] :
      ( ( v132237(VarCurr,bitIndex30)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132237(VarCurr,bitIndex29)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132237(VarCurr,bitIndex28)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132237(VarCurr,bitIndex27)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132237(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132237(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132237(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132237(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132237(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132237(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132237(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132237(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132237(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132237(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132237(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132237(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132237(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132237(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132237(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132237(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132237(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132237(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132237(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132237(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132237(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132237(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132237(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex13) )
      & ( v132237(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex12) )
      & ( v132237(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex11) )
      & ( v132237(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex10) )
      & ( v132237(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_42044,axiom,
    ! [VarCurr] :
      ( v132237(VarCurr,bitIndex31)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2766,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex8)
        & v132235(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2765,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex9)
        & v132235(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2764,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex10)
        & v132235(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2763,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex11)
        & v132235(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2762,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex12)
        & v132235(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2761,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex13)
        & v132235(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2760,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132235(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2759,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132235(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2758,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132235(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2757,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132235(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2756,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132235(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2755,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132235(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2754,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132235(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2753,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132235(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2752,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132235(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2751,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132235(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2750,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132235(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2749,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132235(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2748,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132235(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2747,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132235(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2746,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132235(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2745,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132235(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2744,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132235(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2743,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132235(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2742,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132235(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2741,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132235(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2740,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex26)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132235(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2739,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex27)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132235(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2738,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex28)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132235(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2737,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex29)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132235(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2736,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex30)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132235(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2735,axiom,
    ! [VarCurr] :
      ( v132234(VarCurr,bitIndex31)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132235(VarCurr,bitIndex31) ) ) ).

fof(addAssignment_42043,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42042,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42041,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42040,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42039,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42038,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42037,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42036,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42035,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42034,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42033,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42032,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42031,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42030,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42029,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42028,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42027,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42026,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42025,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42024,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42023,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42022,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42021,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42020,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42019,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42018,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42017,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42016,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42015,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex28)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42014,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex29)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42013,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex30)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_42012,axiom,
    ! [VarCurr] :
      ( v132235(VarCurr,bitIndex31)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_66,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132182(VarCurr,B)
      <=> ( v132183(VarCurr,B)
          & v132226(VarCurr,B) ) ) ) ).

fof(addAssignment_42011,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex0)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42010,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex1)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42009,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex2)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42008,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex3)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42007,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex4)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42006,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex5)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42005,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex6)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42004,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex7)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42003,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex8)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42002,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex9)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42001,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex10)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_42000,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex11)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41999,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex12)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41998,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex13)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41997,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex14)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41996,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex15)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41995,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex16)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41994,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex17)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41993,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex18)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41992,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex19)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41991,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex20)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41990,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex21)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41989,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex22)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41988,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex23)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41987,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex24)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41986,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex25)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41985,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex26)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41984,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex27)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41983,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex28)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41982,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex29)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41981,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex30)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41980,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex31)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41979,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex32)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41978,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex33)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41977,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex34)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41976,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex35)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41975,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex36)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41974,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex37)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41973,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex38)
    <=> v132080(VarCurr) ) ).

fof(addAssignment_41972,axiom,
    ! [VarCurr] :
      ( v132226(VarCurr,bitIndex39)
    <=> v132080(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_65,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132183(VarCurr,B)
      <=> ( v132184(VarCurr,B)
          | v132205(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_64,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132205(VarCurr,B)
      <=> ( v132206(VarCurr,B)
          & v132225(VarCurr,B) ) ) ) ).

fof(addAssignment_41971,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41970,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41969,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41968,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41967,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41966,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41965,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41964,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41963,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41962,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41961,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41960,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41959,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41958,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41957,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41956,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41955,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41954,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41953,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41952,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41951,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41950,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41949,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41948,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41947,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41946,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41945,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41944,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41943,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41942,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41941,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41940,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41939,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41938,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41937,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41936,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41935,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex36)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41934,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex37)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41933,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex38)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41932,axiom,
    ! [VarCurr] :
      ( v132225(VarCurr,bitIndex39)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(addAssignment_41931,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132206(VarCurr,B)
      <=> v132207(VarCurr,B) ) ) ).

fof(addAssignment_41930,axiom,
    ! [VarCurr] :
      ( ( v132206(VarCurr,bitIndex39)
      <=> $false )
      & ( v132206(VarCurr,bitIndex38)
      <=> $false )
      & ( v132206(VarCurr,bitIndex37)
      <=> $false )
      & ( v132206(VarCurr,bitIndex36)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_63,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132207(VarCurr,B)
      <=> ( v132208(VarCurr,B)
          | v132216(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_62,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132216(VarCurr,B)
      <=> ( v132217(VarCurr,B)
          & v132224(VarCurr,B) ) ) ) ).

fof(addAssignment_41929,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41928,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41927,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41926,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41925,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41924,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41923,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41922,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41921,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41920,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41919,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41918,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41917,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41916,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41915,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41914,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41913,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41912,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41911,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41910,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41909,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41908,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41907,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41906,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41905,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41904,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41903,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41902,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41901,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41900,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41899,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41898,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41897,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41896,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41895,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41894,axiom,
    ! [VarCurr] :
      ( v132224(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41893,axiom,
    ! [VarCurr,B] :
      ( range_33_0(B)
     => ( v132217(VarCurr,B)
      <=> v132218(VarCurr,B) ) ) ).

fof(addAssignment_41892,axiom,
    ! [VarCurr] :
      ( ( v132217(VarCurr,bitIndex35)
      <=> $false )
      & ( v132217(VarCurr,bitIndex34)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_61,axiom,
    ! [VarCurr,B] :
      ( range_33_0(B)
     => ( v132218(VarCurr,B)
      <=> ( v132219(VarCurr,B)
          | v132221(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_60,axiom,
    ! [VarCurr,B] :
      ( range_33_0(B)
     => ( v132221(VarCurr,B)
      <=> ( v132222(VarCurr,B)
          & v132223(VarCurr,B) ) ) ) ).

fof(range_axiom_194,axiom,
    ! [B] :
      ( range_33_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B ) ) ).

fof(addAssignment_41891,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41890,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41889,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41888,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41887,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41886,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41885,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41884,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41883,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41882,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41881,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41880,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41879,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41878,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41877,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41876,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41875,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41874,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41873,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41872,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41871,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41870,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41869,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41868,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41867,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41866,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41865,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41864,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41863,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41862,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41861,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41860,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41859,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41858,axiom,
    ! [VarCurr] :
      ( v132223(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41857,axiom,
    ! [VarCurr] :
      ( ( v132222(VarCurr,bitIndex32)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132222(VarCurr,bitIndex31)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132222(VarCurr,bitIndex30)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132222(VarCurr,bitIndex29)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132222(VarCurr,bitIndex28)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132222(VarCurr,bitIndex27)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132222(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132222(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132222(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132222(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132222(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132222(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132222(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132222(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132222(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132222(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132222(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132222(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132222(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132222(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132222(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132222(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132222(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132222(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132222(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132222(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132222(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex13) )
      & ( v132222(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex12) )
      & ( v132222(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex11) )
      & ( v132222(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex10) )
      & ( v132222(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex9) )
      & ( v132222(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex8) )
      & ( v132222(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex7) ) ) ).

fof(addAssignment_41856,axiom,
    ! [VarCurr] :
      ( v132222(VarCurr,bitIndex33)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2734,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex6)
        & v132220(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2733,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex7)
        & v132220(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2732,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex8)
        & v132220(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2731,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex9)
        & v132220(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2730,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex10)
        & v132220(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2729,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex11)
        & v132220(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2728,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex12)
        & v132220(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2727,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex13)
        & v132220(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2726,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132220(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2725,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132220(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2724,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132220(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2723,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132220(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2722,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132220(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2721,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132220(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2720,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132220(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2719,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132220(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2718,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132220(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2717,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132220(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2716,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132220(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2715,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132220(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2714,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132220(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2713,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132220(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2712,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132220(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2711,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132220(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2710,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132220(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2709,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132220(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2708,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex26)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132220(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2707,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex27)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132220(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2706,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex28)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132220(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2705,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex29)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132220(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2704,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex30)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132220(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2703,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex31)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132220(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2702,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex32)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132220(VarCurr,bitIndex32) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2701,axiom,
    ! [VarCurr] :
      ( v132219(VarCurr,bitIndex33)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132220(VarCurr,bitIndex33) ) ) ).

fof(addAssignment_41855,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41854,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41853,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41852,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41851,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41850,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41849,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41848,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41847,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41846,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41845,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41844,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41843,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41842,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41841,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41840,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41839,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41838,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41837,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41836,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41835,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41834,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41833,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41832,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41831,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41830,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41829,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41828,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41827,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex28)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41826,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex29)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41825,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex30)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41824,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex31)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41823,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex32)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41822,axiom,
    ! [VarCurr] :
      ( v132220(VarCurr,bitIndex33)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_59,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132208(VarCurr,B)
      <=> ( v132209(VarCurr,B)
          & v132215(VarCurr,B) ) ) ) ).

fof(addAssignment_41821,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41820,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41819,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41818,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41817,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41816,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41815,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41814,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41813,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41812,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41811,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41810,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41809,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41808,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41807,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41806,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41805,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex16)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41804,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex17)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41803,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex18)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41802,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex19)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41801,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex20)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41800,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex21)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41799,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex22)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41798,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex23)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41797,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex24)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41796,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex25)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41795,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex26)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41794,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex27)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41793,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex28)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41792,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex29)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41791,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex30)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41790,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex31)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41789,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex32)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41788,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex33)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41787,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex34)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41786,axiom,
    ! [VarCurr] :
      ( v132215(VarCurr,bitIndex35)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_58,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132209(VarCurr,B)
      <=> ( v132210(VarCurr,B)
          | v132212(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_57,axiom,
    ! [VarCurr,B] :
      ( range_35_0(B)
     => ( v132212(VarCurr,B)
      <=> ( v132213(VarCurr,B)
          & v132214(VarCurr,B) ) ) ) ).

fof(addAssignment_41785,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41784,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41783,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41782,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41781,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41780,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41779,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41778,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41777,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41776,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41775,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41774,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41773,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41772,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41771,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41770,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41769,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41768,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41767,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41766,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41765,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41764,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41763,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41762,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41761,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41760,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41759,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41758,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41757,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41756,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41755,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41754,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41753,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41752,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41751,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41750,axiom,
    ! [VarCurr] :
      ( v132214(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41749,axiom,
    ! [VarCurr] :
      ( ( v132213(VarCurr,bitIndex34)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132213(VarCurr,bitIndex33)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132213(VarCurr,bitIndex32)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132213(VarCurr,bitIndex31)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132213(VarCurr,bitIndex30)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132213(VarCurr,bitIndex29)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132213(VarCurr,bitIndex28)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132213(VarCurr,bitIndex27)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132213(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132213(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132213(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132213(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132213(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132213(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132213(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132213(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132213(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132213(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132213(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132213(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132213(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132213(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132213(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132213(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132213(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132213(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132213(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex13) )
      & ( v132213(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex12) )
      & ( v132213(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex11) )
      & ( v132213(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex10) )
      & ( v132213(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex9) )
      & ( v132213(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex8) )
      & ( v132213(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex7) )
      & ( v132213(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex6) )
      & ( v132213(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex5) ) ) ).

fof(addAssignment_41748,axiom,
    ! [VarCurr] :
      ( v132213(VarCurr,bitIndex35)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2700,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex4)
        & v132211(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2699,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex5)
        & v132211(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2698,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex6)
        & v132211(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2697,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex7)
        & v132211(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2696,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex8)
        & v132211(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2695,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex9)
        & v132211(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2694,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex10)
        & v132211(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2693,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex11)
        & v132211(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2692,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex12)
        & v132211(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2691,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex13)
        & v132211(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2690,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132211(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2689,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132211(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2688,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132211(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2687,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132211(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2686,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132211(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2685,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132211(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2684,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132211(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2683,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132211(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2682,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132211(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2681,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132211(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2680,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132211(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2679,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132211(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2678,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132211(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2677,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132211(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2676,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132211(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2675,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132211(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2674,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex26)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132211(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2673,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex27)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132211(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2672,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex28)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132211(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2671,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex29)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132211(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2670,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex30)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132211(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2669,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex31)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132211(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2668,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex32)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132211(VarCurr,bitIndex32) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2667,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex33)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132211(VarCurr,bitIndex33) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2666,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex34)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132211(VarCurr,bitIndex34) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2665,axiom,
    ! [VarCurr] :
      ( v132210(VarCurr,bitIndex35)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132211(VarCurr,bitIndex35) ) ) ).

fof(addAssignment_41747,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41746,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41745,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41744,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41743,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41742,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41741,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41740,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41739,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41738,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41737,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41736,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41735,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41734,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41733,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41732,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41731,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41730,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41729,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41728,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41727,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41726,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41725,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41724,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41723,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41722,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41721,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41720,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41719,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex28)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41718,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex29)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41717,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex30)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41716,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex31)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41715,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex32)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41714,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex33)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41713,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex34)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41712,axiom,
    ! [VarCurr] :
      ( v132211(VarCurr,bitIndex35)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_56,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132184(VarCurr,B)
      <=> ( v132185(VarCurr,B)
          & v132204(VarCurr,B) ) ) ) ).

fof(addAssignment_41711,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex0)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41710,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex1)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41709,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex2)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41708,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex3)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41707,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex4)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41706,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex5)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41705,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex6)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41704,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex7)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41703,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex8)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41702,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex9)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41701,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex10)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41700,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex11)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41699,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex12)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41698,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex13)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41697,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex14)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41696,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex15)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41695,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex16)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41694,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex17)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41693,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex18)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41692,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex19)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41691,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex20)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41690,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex21)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41689,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex22)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41688,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex23)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41687,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex24)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41686,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex25)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41685,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex26)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41684,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex27)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41683,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex28)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41682,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex29)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41681,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex30)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41680,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex31)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41679,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex32)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41678,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex33)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41677,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex34)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41676,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex35)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41675,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex36)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41674,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex37)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41673,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex38)
    <=> v132085(VarCurr) ) ).

fof(addAssignment_41672,axiom,
    ! [VarCurr] :
      ( v132204(VarCurr,bitIndex39)
    <=> v132085(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_55,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132185(VarCurr,B)
      <=> ( v132186(VarCurr,B)
          | v132195(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_54,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132195(VarCurr,B)
      <=> ( v132196(VarCurr,B)
          & v132203(VarCurr,B) ) ) ) ).

fof(addAssignment_41671,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41670,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41669,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41668,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41667,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41666,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41665,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41664,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41663,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41662,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41661,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41660,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41659,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41658,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41657,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41656,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41655,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41654,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41653,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41652,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41651,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41650,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41649,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41648,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41647,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41646,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41645,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41644,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41643,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41642,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41641,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41640,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41639,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41638,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41637,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41636,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41635,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex36)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41634,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex37)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41633,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex38)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41632,axiom,
    ! [VarCurr] :
      ( v132203(VarCurr,bitIndex39)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(addAssignment_41631,axiom,
    ! [VarCurr,B] :
      ( range_37_0(B)
     => ( v132196(VarCurr,B)
      <=> v132197(VarCurr,B) ) ) ).

fof(addAssignment_41630,axiom,
    ! [VarCurr] :
      ( ( v132196(VarCurr,bitIndex39)
      <=> $false )
      & ( v132196(VarCurr,bitIndex38)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_53,axiom,
    ! [VarCurr,B] :
      ( range_37_0(B)
     => ( v132197(VarCurr,B)
      <=> ( v132198(VarCurr,B)
          | v132200(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_52,axiom,
    ! [VarCurr,B] :
      ( range_37_0(B)
     => ( v132200(VarCurr,B)
      <=> ( v132201(VarCurr,B)
          & v132202(VarCurr,B) ) ) ) ).

fof(range_axiom_193,axiom,
    ! [B] :
      ( range_37_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B ) ) ).

fof(addAssignment_41629,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41628,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41627,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41626,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41625,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41624,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41623,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41622,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41621,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41620,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41619,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41618,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41617,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41616,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41615,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41614,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41613,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41612,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41611,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41610,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41609,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41608,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41607,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41606,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41605,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41604,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41603,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41602,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41601,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41600,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41599,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41598,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41597,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41596,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41595,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41594,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41593,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex36)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41592,axiom,
    ! [VarCurr] :
      ( v132202(VarCurr,bitIndex37)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41591,axiom,
    ! [VarCurr] :
      ( ( v132201(VarCurr,bitIndex36)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132201(VarCurr,bitIndex35)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132201(VarCurr,bitIndex34)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132201(VarCurr,bitIndex33)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132201(VarCurr,bitIndex32)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132201(VarCurr,bitIndex31)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132201(VarCurr,bitIndex30)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132201(VarCurr,bitIndex29)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132201(VarCurr,bitIndex28)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132201(VarCurr,bitIndex27)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132201(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132201(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132201(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132201(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132201(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132201(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132201(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132201(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132201(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132201(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132201(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132201(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132201(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132201(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132201(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132201(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132201(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex13) )
      & ( v132201(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex12) )
      & ( v132201(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex11) )
      & ( v132201(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex10) )
      & ( v132201(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex9) )
      & ( v132201(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex8) )
      & ( v132201(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex7) )
      & ( v132201(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex6) )
      & ( v132201(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex5) )
      & ( v132201(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex4) )
      & ( v132201(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex3) ) ) ).

fof(addAssignment_41590,axiom,
    ! [VarCurr] :
      ( v132201(VarCurr,bitIndex37)
    <=> $false ) ).

fof(writeBinaryOperatorShiftedRanges_2664,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex0)
    <=> ( v132189(VarCurr,bitIndex2)
        & v132199(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2663,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex1)
    <=> ( v132189(VarCurr,bitIndex3)
        & v132199(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2662,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex2)
    <=> ( v132189(VarCurr,bitIndex4)
        & v132199(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2661,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex3)
    <=> ( v132189(VarCurr,bitIndex5)
        & v132199(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2660,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex4)
    <=> ( v132189(VarCurr,bitIndex6)
        & v132199(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2659,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex5)
    <=> ( v132189(VarCurr,bitIndex7)
        & v132199(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2658,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex6)
    <=> ( v132189(VarCurr,bitIndex8)
        & v132199(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2657,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex7)
    <=> ( v132189(VarCurr,bitIndex9)
        & v132199(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2656,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex8)
    <=> ( v132189(VarCurr,bitIndex10)
        & v132199(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2655,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex9)
    <=> ( v132189(VarCurr,bitIndex11)
        & v132199(VarCurr,bitIndex9) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2654,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex10)
    <=> ( v132189(VarCurr,bitIndex12)
        & v132199(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2653,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex11)
    <=> ( v132189(VarCurr,bitIndex13)
        & v132199(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2652,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex12)
    <=> ( v132189(VarCurr,bitIndex14)
        & v132199(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2651,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex13)
    <=> ( v132189(VarCurr,bitIndex15)
        & v132199(VarCurr,bitIndex13) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2650,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex14)
    <=> ( v132189(VarCurr,bitIndex16)
        & v132199(VarCurr,bitIndex14) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2649,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex15)
    <=> ( v132189(VarCurr,bitIndex17)
        & v132199(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2648,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex16)
    <=> ( v132189(VarCurr,bitIndex18)
        & v132199(VarCurr,bitIndex16) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2647,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex17)
    <=> ( v132189(VarCurr,bitIndex19)
        & v132199(VarCurr,bitIndex17) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2646,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex18)
    <=> ( v132189(VarCurr,bitIndex20)
        & v132199(VarCurr,bitIndex18) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2645,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex19)
    <=> ( v132189(VarCurr,bitIndex21)
        & v132199(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2644,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex20)
    <=> ( v132189(VarCurr,bitIndex22)
        & v132199(VarCurr,bitIndex20) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2643,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex21)
    <=> ( v132189(VarCurr,bitIndex23)
        & v132199(VarCurr,bitIndex21) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2642,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex22)
    <=> ( v132189(VarCurr,bitIndex24)
        & v132199(VarCurr,bitIndex22) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2641,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex23)
    <=> ( v132189(VarCurr,bitIndex25)
        & v132199(VarCurr,bitIndex23) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2640,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex24)
    <=> ( v132189(VarCurr,bitIndex26)
        & v132199(VarCurr,bitIndex24) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2639,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex25)
    <=> ( v132189(VarCurr,bitIndex27)
        & v132199(VarCurr,bitIndex25) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2638,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex26)
    <=> ( v132189(VarCurr,bitIndex28)
        & v132199(VarCurr,bitIndex26) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2637,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex27)
    <=> ( v132189(VarCurr,bitIndex29)
        & v132199(VarCurr,bitIndex27) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2636,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex28)
    <=> ( v132189(VarCurr,bitIndex30)
        & v132199(VarCurr,bitIndex28) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2635,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex29)
    <=> ( v132189(VarCurr,bitIndex31)
        & v132199(VarCurr,bitIndex29) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2634,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex30)
    <=> ( v132189(VarCurr,bitIndex32)
        & v132199(VarCurr,bitIndex30) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2633,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex31)
    <=> ( v132189(VarCurr,bitIndex33)
        & v132199(VarCurr,bitIndex31) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2632,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex32)
    <=> ( v132189(VarCurr,bitIndex34)
        & v132199(VarCurr,bitIndex32) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2631,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex33)
    <=> ( v132189(VarCurr,bitIndex35)
        & v132199(VarCurr,bitIndex33) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2630,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex34)
    <=> ( v132189(VarCurr,bitIndex36)
        & v132199(VarCurr,bitIndex34) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2629,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex35)
    <=> ( v132189(VarCurr,bitIndex37)
        & v132199(VarCurr,bitIndex35) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2628,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex36)
    <=> ( v132189(VarCurr,bitIndex38)
        & v132199(VarCurr,bitIndex36) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2627,axiom,
    ! [VarCurr] :
      ( v132198(VarCurr,bitIndex37)
    <=> ( v132189(VarCurr,bitIndex39)
        & v132199(VarCurr,bitIndex37) ) ) ).

fof(addAssignment_41589,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41588,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41587,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41586,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41585,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41584,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41583,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41582,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41581,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41580,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41579,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41578,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41577,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41576,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41575,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41574,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41573,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41572,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41571,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41570,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41569,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41568,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41567,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41566,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41565,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41564,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41563,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41562,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41561,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex28)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41560,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex29)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41559,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex30)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41558,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex31)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41557,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex32)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41556,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex33)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41555,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex34)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41554,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex35)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41553,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex36)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41552,axiom,
    ! [VarCurr] :
      ( v132199(VarCurr,bitIndex37)
    <=> v132089(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_51,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132186(VarCurr,B)
      <=> ( v132187(VarCurr,B)
          & v132194(VarCurr,B) ) ) ) ).

fof(addAssignment_41551,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex0)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41550,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex1)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41549,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex2)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41548,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex3)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41547,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex4)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41546,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex5)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41545,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex6)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41544,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex7)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41543,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex8)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41542,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex9)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41541,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex10)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41540,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex11)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41539,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex12)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41538,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex13)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41537,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex14)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41536,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex15)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41535,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex16)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41534,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex17)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41533,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex18)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41532,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex19)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41531,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex20)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41530,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex21)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41529,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex22)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41528,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex23)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41527,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex24)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41526,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex25)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41525,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex26)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41524,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex27)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41523,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex28)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41522,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex29)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41521,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex30)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41520,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex31)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41519,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex32)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41518,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex33)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41517,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex34)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41516,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex35)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41515,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex36)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41514,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex37)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41513,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex38)
    <=> v132090(VarCurr) ) ).

fof(addAssignment_41512,axiom,
    ! [VarCurr] :
      ( v132194(VarCurr,bitIndex39)
    <=> v132090(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_50,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132187(VarCurr,B)
      <=> ( v132188(VarCurr,B)
          | v132191(VarCurr,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_49,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132191(VarCurr,B)
      <=> ( v132192(VarCurr,B)
          & v132193(VarCurr,B) ) ) ) ).

fof(addAssignment_41511,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex0)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41510,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex1)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41509,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex2)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41508,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex3)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41507,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex4)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41506,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex5)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41505,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex6)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41504,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex7)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41503,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex8)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41502,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex9)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41501,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex10)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41500,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex11)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41499,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex12)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41498,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex13)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41497,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex14)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41496,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex15)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41495,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex16)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41494,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex17)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41493,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex18)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41492,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex19)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41491,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex20)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41490,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex21)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41489,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex22)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41488,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex23)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41487,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex24)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41486,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex25)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41485,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex26)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41484,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex27)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41483,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex28)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41482,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex29)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41481,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex30)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41480,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex31)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41479,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex32)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41478,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex33)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41477,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex34)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41476,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex35)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41475,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex36)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41474,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex37)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41473,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex38)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41472,axiom,
    ! [VarCurr] :
      ( v132193(VarCurr,bitIndex39)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(addAssignment_41471,axiom,
    ! [VarCurr] :
      ( ( v132192(VarCurr,bitIndex38)
      <=> v132189(VarCurr,bitIndex39) )
      & ( v132192(VarCurr,bitIndex37)
      <=> v132189(VarCurr,bitIndex38) )
      & ( v132192(VarCurr,bitIndex36)
      <=> v132189(VarCurr,bitIndex37) )
      & ( v132192(VarCurr,bitIndex35)
      <=> v132189(VarCurr,bitIndex36) )
      & ( v132192(VarCurr,bitIndex34)
      <=> v132189(VarCurr,bitIndex35) )
      & ( v132192(VarCurr,bitIndex33)
      <=> v132189(VarCurr,bitIndex34) )
      & ( v132192(VarCurr,bitIndex32)
      <=> v132189(VarCurr,bitIndex33) )
      & ( v132192(VarCurr,bitIndex31)
      <=> v132189(VarCurr,bitIndex32) )
      & ( v132192(VarCurr,bitIndex30)
      <=> v132189(VarCurr,bitIndex31) )
      & ( v132192(VarCurr,bitIndex29)
      <=> v132189(VarCurr,bitIndex30) )
      & ( v132192(VarCurr,bitIndex28)
      <=> v132189(VarCurr,bitIndex29) )
      & ( v132192(VarCurr,bitIndex27)
      <=> v132189(VarCurr,bitIndex28) )
      & ( v132192(VarCurr,bitIndex26)
      <=> v132189(VarCurr,bitIndex27) )
      & ( v132192(VarCurr,bitIndex25)
      <=> v132189(VarCurr,bitIndex26) )
      & ( v132192(VarCurr,bitIndex24)
      <=> v132189(VarCurr,bitIndex25) )
      & ( v132192(VarCurr,bitIndex23)
      <=> v132189(VarCurr,bitIndex24) )
      & ( v132192(VarCurr,bitIndex22)
      <=> v132189(VarCurr,bitIndex23) )
      & ( v132192(VarCurr,bitIndex21)
      <=> v132189(VarCurr,bitIndex22) )
      & ( v132192(VarCurr,bitIndex20)
      <=> v132189(VarCurr,bitIndex21) )
      & ( v132192(VarCurr,bitIndex19)
      <=> v132189(VarCurr,bitIndex20) )
      & ( v132192(VarCurr,bitIndex18)
      <=> v132189(VarCurr,bitIndex19) )
      & ( v132192(VarCurr,bitIndex17)
      <=> v132189(VarCurr,bitIndex18) )
      & ( v132192(VarCurr,bitIndex16)
      <=> v132189(VarCurr,bitIndex17) )
      & ( v132192(VarCurr,bitIndex15)
      <=> v132189(VarCurr,bitIndex16) )
      & ( v132192(VarCurr,bitIndex14)
      <=> v132189(VarCurr,bitIndex15) )
      & ( v132192(VarCurr,bitIndex13)
      <=> v132189(VarCurr,bitIndex14) )
      & ( v132192(VarCurr,bitIndex12)
      <=> v132189(VarCurr,bitIndex13) )
      & ( v132192(VarCurr,bitIndex11)
      <=> v132189(VarCurr,bitIndex12) )
      & ( v132192(VarCurr,bitIndex10)
      <=> v132189(VarCurr,bitIndex11) )
      & ( v132192(VarCurr,bitIndex9)
      <=> v132189(VarCurr,bitIndex10) )
      & ( v132192(VarCurr,bitIndex8)
      <=> v132189(VarCurr,bitIndex9) )
      & ( v132192(VarCurr,bitIndex7)
      <=> v132189(VarCurr,bitIndex8) )
      & ( v132192(VarCurr,bitIndex6)
      <=> v132189(VarCurr,bitIndex7) )
      & ( v132192(VarCurr,bitIndex5)
      <=> v132189(VarCurr,bitIndex6) )
      & ( v132192(VarCurr,bitIndex4)
      <=> v132189(VarCurr,bitIndex5) )
      & ( v132192(VarCurr,bitIndex3)
      <=> v132189(VarCurr,bitIndex4) )
      & ( v132192(VarCurr,bitIndex2)
      <=> v132189(VarCurr,bitIndex3) )
      & ( v132192(VarCurr,bitIndex1)
      <=> v132189(VarCurr,bitIndex2) )
      & ( v132192(VarCurr,bitIndex0)
      <=> v132189(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_41470,axiom,
    ! [VarCurr] :
      ( v132192(VarCurr,bitIndex39)
    <=> $false ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_48,axiom,
    ! [VarCurr,B] :
      ( range_39_0(B)
     => ( v132188(VarCurr,B)
      <=> ( v132189(VarCurr,B)
          & v132190(VarCurr,B) ) ) ) ).

fof(range_axiom_192,axiom,
    ! [B] :
      ( range_39_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B ) ) ).

fof(addAssignment_41469,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41468,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex1)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41467,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex2)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41466,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex3)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41465,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex4)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41464,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex5)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41463,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex6)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41462,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex7)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41461,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex8)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41460,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex9)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41459,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex10)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41458,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex11)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41457,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex12)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41456,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex13)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41455,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex14)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41454,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex15)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41453,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex16)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41452,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex17)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41451,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex18)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41450,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex19)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41449,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex20)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41448,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex21)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41447,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex22)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41446,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex23)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41445,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex24)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41444,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex25)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41443,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex26)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41442,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex27)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41441,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex28)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41440,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex29)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41439,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex30)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41438,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex31)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41437,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex32)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41436,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex33)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41435,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex34)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41434,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex35)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41433,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex36)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41432,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex37)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41431,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex38)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41430,axiom,
    ! [VarCurr] :
      ( v132190(VarCurr,bitIndex39)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41429,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132189(VarCurr,B)
      <=> v131900(VarCurr,B) ) ) ).

fof(addAssignment_41428,axiom,
    ! [VarCurr] :
      ( ( v132189(VarCurr,bitIndex39)
      <=> v131900(VarCurr,bitIndex7) )
      & ( v132189(VarCurr,bitIndex38)
      <=> v131900(VarCurr,bitIndex6) )
      & ( v132189(VarCurr,bitIndex37)
      <=> v131900(VarCurr,bitIndex5) )
      & ( v132189(VarCurr,bitIndex36)
      <=> v131900(VarCurr,bitIndex4) )
      & ( v132189(VarCurr,bitIndex35)
      <=> v131900(VarCurr,bitIndex3) )
      & ( v132189(VarCurr,bitIndex34)
      <=> v131900(VarCurr,bitIndex2) )
      & ( v132189(VarCurr,bitIndex33)
      <=> v131900(VarCurr,bitIndex1) )
      & ( v132189(VarCurr,bitIndex32)
      <=> v131900(VarCurr,bitIndex0) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2323,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132166(VarNext)
       => ! [B] :
            ( range_31_0(B)
           => ( v131900(VarNext,B)
            <=> v131900(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2442,axiom,
    ! [VarNext] :
      ( v132166(VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v131900(VarNext,B)
          <=> v132174(VarNext,B) ) ) ) ).

fof(addAssignment_41427,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_31_0(B)
         => ( v132174(VarNext,B)
          <=> v132172(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3173,axiom,
    ! [VarCurr] :
      ( ~ v132175(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132172(VarCurr,B)
          <=> v131903(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2978,axiom,
    ! [VarCurr] :
      ( v132175(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v132172(VarCurr,B)
          <=> $true ) ) ) ).

fof(writeUnaryOperator_10929,axiom,
    ! [VarCurr] :
      ( ~ v132175(VarCurr)
    <=> v10082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26458,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132166(VarNext)
      <=> v132167(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26457,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132167(VarNext)
      <=> ( v132168(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_10928,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132168(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_47,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v131903(VarCurr,B)
      <=> ( v132162(VarCurr,B)
          & v132163(VarCurr,B) ) ) ) ).

fof(writeUnaryOperator_10927,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132163(VarCurr,B)
      <=> ~ v132041(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_46,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132162(VarCurr,B)
      <=> ( v131905(VarCurr,B)
          | v131900(VarCurr,B) ) ) ) ).

fof(addAssignmentInitValueVector_41,axiom,
    ! [B] :
      ( range_31_0(B)
     => ( v131900(constB0,B)
      <=> $true ) ) ).

fof(bitBlastConstant_12696,axiom,
    b11111111111111111111111111111111(bitIndex31) ).

fof(bitBlastConstant_12695,axiom,
    b11111111111111111111111111111111(bitIndex30) ).

fof(bitBlastConstant_12694,axiom,
    b11111111111111111111111111111111(bitIndex29) ).

fof(bitBlastConstant_12693,axiom,
    b11111111111111111111111111111111(bitIndex28) ).

fof(bitBlastConstant_12692,axiom,
    b11111111111111111111111111111111(bitIndex27) ).

fof(bitBlastConstant_12691,axiom,
    b11111111111111111111111111111111(bitIndex26) ).

fof(bitBlastConstant_12690,axiom,
    b11111111111111111111111111111111(bitIndex25) ).

fof(bitBlastConstant_12689,axiom,
    b11111111111111111111111111111111(bitIndex24) ).

fof(bitBlastConstant_12688,axiom,
    b11111111111111111111111111111111(bitIndex23) ).

fof(bitBlastConstant_12687,axiom,
    b11111111111111111111111111111111(bitIndex22) ).

fof(bitBlastConstant_12686,axiom,
    b11111111111111111111111111111111(bitIndex21) ).

fof(bitBlastConstant_12685,axiom,
    b11111111111111111111111111111111(bitIndex20) ).

fof(bitBlastConstant_12684,axiom,
    b11111111111111111111111111111111(bitIndex19) ).

fof(bitBlastConstant_12683,axiom,
    b11111111111111111111111111111111(bitIndex18) ).

fof(bitBlastConstant_12682,axiom,
    b11111111111111111111111111111111(bitIndex17) ).

fof(bitBlastConstant_12681,axiom,
    b11111111111111111111111111111111(bitIndex16) ).

fof(bitBlastConstant_12680,axiom,
    b11111111111111111111111111111111(bitIndex15) ).

fof(bitBlastConstant_12679,axiom,
    b11111111111111111111111111111111(bitIndex14) ).

fof(bitBlastConstant_12678,axiom,
    b11111111111111111111111111111111(bitIndex13) ).

fof(bitBlastConstant_12677,axiom,
    b11111111111111111111111111111111(bitIndex12) ).

fof(bitBlastConstant_12676,axiom,
    b11111111111111111111111111111111(bitIndex11) ).

fof(bitBlastConstant_12675,axiom,
    b11111111111111111111111111111111(bitIndex10) ).

fof(bitBlastConstant_12674,axiom,
    b11111111111111111111111111111111(bitIndex9) ).

fof(bitBlastConstant_12673,axiom,
    b11111111111111111111111111111111(bitIndex8) ).

fof(bitBlastConstant_12672,axiom,
    b11111111111111111111111111111111(bitIndex7) ).

fof(bitBlastConstant_12671,axiom,
    b11111111111111111111111111111111(bitIndex6) ).

fof(bitBlastConstant_12670,axiom,
    b11111111111111111111111111111111(bitIndex5) ).

fof(bitBlastConstant_12669,axiom,
    b11111111111111111111111111111111(bitIndex4) ).

fof(bitBlastConstant_12668,axiom,
    b11111111111111111111111111111111(bitIndex3) ).

fof(bitBlastConstant_12667,axiom,
    b11111111111111111111111111111111(bitIndex2) ).

fof(bitBlastConstant_12666,axiom,
    b11111111111111111111111111111111(bitIndex1) ).

fof(bitBlastConstant_12665,axiom,
    b11111111111111111111111111111111(bitIndex0) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_45,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v132041(VarCurr,B)
      <=> ( v132043(VarCurr,B)
          & v132159(VarCurr,B) ) ) ) ).

fof(addAssignment_41426,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex0)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41425,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex1)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41424,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex2)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41423,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex3)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41422,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex4)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41421,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex5)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41420,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex6)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41419,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex7)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41418,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex8)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41417,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex9)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41416,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex10)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41415,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex11)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41414,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex12)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41413,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex13)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41412,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex14)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41411,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex15)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41410,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex16)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41409,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex17)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41408,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex18)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41407,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex19)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41406,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex20)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41405,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex21)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41404,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex22)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41403,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex23)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41402,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex24)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41401,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex25)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41400,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex26)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41399,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex27)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41398,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex28)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41397,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex29)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41396,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex30)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41395,axiom,
    ! [VarCurr] :
      ( v132159(VarCurr,bitIndex31)
    <=> v132160(VarCurr) ) ).

fof(addAssignment_41394,axiom,
    ! [VarCurr] :
      ( v132160(VarCurr)
    <=> v132047(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_578,axiom,
    ! [VarCurr] :
      ( ~ v132157(VarCurr)
     => ( v132043(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_773,axiom,
    ! [VarCurr] :
      ( v132157(VarCurr)
     => ( v132043(VarCurr,bitIndex31)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9285,axiom,
    ! [VarCurr] :
      ( v132157(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_577,axiom,
    ! [VarCurr] :
      ( ~ v132155(VarCurr)
     => ( v132043(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_772,axiom,
    ! [VarCurr] :
      ( v132155(VarCurr)
     => ( v132043(VarCurr,bitIndex30)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9284,axiom,
    ! [VarCurr] :
      ( v132155(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_576,axiom,
    ! [VarCurr] :
      ( ~ v132153(VarCurr)
     => ( v132043(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_771,axiom,
    ! [VarCurr] :
      ( v132153(VarCurr)
     => ( v132043(VarCurr,bitIndex29)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9283,axiom,
    ! [VarCurr] :
      ( v132153(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_575,axiom,
    ! [VarCurr] :
      ( ~ v132151(VarCurr)
     => ( v132043(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_770,axiom,
    ! [VarCurr] :
      ( v132151(VarCurr)
     => ( v132043(VarCurr,bitIndex28)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9282,axiom,
    ! [VarCurr] :
      ( v132151(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_574,axiom,
    ! [VarCurr] :
      ( ~ v132149(VarCurr)
     => ( v132043(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_769,axiom,
    ! [VarCurr] :
      ( v132149(VarCurr)
     => ( v132043(VarCurr,bitIndex27)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9281,axiom,
    ! [VarCurr] :
      ( v132149(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_573,axiom,
    ! [VarCurr] :
      ( ~ v132147(VarCurr)
     => ( v132043(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_768,axiom,
    ! [VarCurr] :
      ( v132147(VarCurr)
     => ( v132043(VarCurr,bitIndex26)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9280,axiom,
    ! [VarCurr] :
      ( v132147(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_572,axiom,
    ! [VarCurr] :
      ( ~ v132145(VarCurr)
     => ( v132043(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_767,axiom,
    ! [VarCurr] :
      ( v132145(VarCurr)
     => ( v132043(VarCurr,bitIndex25)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9279,axiom,
    ! [VarCurr] :
      ( v132145(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_571,axiom,
    ! [VarCurr] :
      ( ~ v132143(VarCurr)
     => ( v132043(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_766,axiom,
    ! [VarCurr] :
      ( v132143(VarCurr)
     => ( v132043(VarCurr,bitIndex24)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9278,axiom,
    ! [VarCurr] :
      ( v132143(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_570,axiom,
    ! [VarCurr] :
      ( ~ v132141(VarCurr)
     => ( v132043(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_765,axiom,
    ! [VarCurr] :
      ( v132141(VarCurr)
     => ( v132043(VarCurr,bitIndex23)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9277,axiom,
    ! [VarCurr] :
      ( v132141(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_569,axiom,
    ! [VarCurr] :
      ( ~ v132139(VarCurr)
     => ( v132043(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_764,axiom,
    ! [VarCurr] :
      ( v132139(VarCurr)
     => ( v132043(VarCurr,bitIndex22)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9276,axiom,
    ! [VarCurr] :
      ( v132139(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_568,axiom,
    ! [VarCurr] :
      ( ~ v132137(VarCurr)
     => ( v132043(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_763,axiom,
    ! [VarCurr] :
      ( v132137(VarCurr)
     => ( v132043(VarCurr,bitIndex21)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9275,axiom,
    ! [VarCurr] :
      ( v132137(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_567,axiom,
    ! [VarCurr] :
      ( ~ v132135(VarCurr)
     => ( v132043(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_762,axiom,
    ! [VarCurr] :
      ( v132135(VarCurr)
     => ( v132043(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9274,axiom,
    ! [VarCurr] :
      ( v132135(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_566,axiom,
    ! [VarCurr] :
      ( ~ v132133(VarCurr)
     => ( v132043(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_761,axiom,
    ! [VarCurr] :
      ( v132133(VarCurr)
     => ( v132043(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9273,axiom,
    ! [VarCurr] :
      ( v132133(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_565,axiom,
    ! [VarCurr] :
      ( ~ v132131(VarCurr)
     => ( v132043(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_760,axiom,
    ! [VarCurr] :
      ( v132131(VarCurr)
     => ( v132043(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9272,axiom,
    ! [VarCurr] :
      ( v132131(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_564,axiom,
    ! [VarCurr] :
      ( ~ v132129(VarCurr)
     => ( v132043(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_759,axiom,
    ! [VarCurr] :
      ( v132129(VarCurr)
     => ( v132043(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9271,axiom,
    ! [VarCurr] :
      ( v132129(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_563,axiom,
    ! [VarCurr] :
      ( ~ v132127(VarCurr)
     => ( v132043(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_758,axiom,
    ! [VarCurr] :
      ( v132127(VarCurr)
     => ( v132043(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9270,axiom,
    ! [VarCurr] :
      ( v132127(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $true )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_562,axiom,
    ! [VarCurr] :
      ( ~ v132125(VarCurr)
     => ( v132043(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_757,axiom,
    ! [VarCurr] :
      ( v132125(VarCurr)
     => ( v132043(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9269,axiom,
    ! [VarCurr] :
      ( v132125(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_561,axiom,
    ! [VarCurr] :
      ( ~ v132123(VarCurr)
     => ( v132043(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_756,axiom,
    ! [VarCurr] :
      ( v132123(VarCurr)
     => ( v132043(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9268,axiom,
    ! [VarCurr] :
      ( v132123(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_560,axiom,
    ! [VarCurr] :
      ( ~ v132121(VarCurr)
     => ( v132043(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_755,axiom,
    ! [VarCurr] :
      ( v132121(VarCurr)
     => ( v132043(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9267,axiom,
    ! [VarCurr] :
      ( v132121(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_559,axiom,
    ! [VarCurr] :
      ( ~ v132119(VarCurr)
     => ( v132043(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_754,axiom,
    ! [VarCurr] :
      ( v132119(VarCurr)
     => ( v132043(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9266,axiom,
    ! [VarCurr] :
      ( v132119(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_558,axiom,
    ! [VarCurr] :
      ( ~ v132117(VarCurr)
     => ( v132043(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_753,axiom,
    ! [VarCurr] :
      ( v132117(VarCurr)
     => ( v132043(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9265,axiom,
    ! [VarCurr] :
      ( v132117(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_557,axiom,
    ! [VarCurr] :
      ( ~ v132115(VarCurr)
     => ( v132043(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_752,axiom,
    ! [VarCurr] :
      ( v132115(VarCurr)
     => ( v132043(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9264,axiom,
    ! [VarCurr] :
      ( v132115(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_556,axiom,
    ! [VarCurr] :
      ( ~ v132113(VarCurr)
     => ( v132043(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_751,axiom,
    ! [VarCurr] :
      ( v132113(VarCurr)
     => ( v132043(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9263,axiom,
    ! [VarCurr] :
      ( v132113(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_555,axiom,
    ! [VarCurr] :
      ( ~ v132111(VarCurr)
     => ( v132043(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_750,axiom,
    ! [VarCurr] :
      ( v132111(VarCurr)
     => ( v132043(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9262,axiom,
    ! [VarCurr] :
      ( v132111(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $true )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_554,axiom,
    ! [VarCurr] :
      ( ~ v132109(VarCurr)
     => ( v132043(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_749,axiom,
    ! [VarCurr] :
      ( v132109(VarCurr)
     => ( v132043(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9261,axiom,
    ! [VarCurr] :
      ( v132109(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_553,axiom,
    ! [VarCurr] :
      ( ~ v132107(VarCurr)
     => ( v132043(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_748,axiom,
    ! [VarCurr] :
      ( v132107(VarCurr)
     => ( v132043(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9260,axiom,
    ! [VarCurr] :
      ( v132107(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_552,axiom,
    ! [VarCurr] :
      ( ~ v132105(VarCurr)
     => ( v132043(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_747,axiom,
    ! [VarCurr] :
      ( v132105(VarCurr)
     => ( v132043(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9259,axiom,
    ! [VarCurr] :
      ( v132105(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_551,axiom,
    ! [VarCurr] :
      ( ~ v132103(VarCurr)
     => ( v132043(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_746,axiom,
    ! [VarCurr] :
      ( v132103(VarCurr)
     => ( v132043(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9258,axiom,
    ! [VarCurr] :
      ( v132103(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $true )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_550,axiom,
    ! [VarCurr] :
      ( ~ v132101(VarCurr)
     => ( v132043(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_745,axiom,
    ! [VarCurr] :
      ( v132101(VarCurr)
     => ( v132043(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9257,axiom,
    ! [VarCurr] :
      ( v132101(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_549,axiom,
    ! [VarCurr] :
      ( ~ v132099(VarCurr)
     => ( v132043(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_744,axiom,
    ! [VarCurr] :
      ( v132099(VarCurr)
     => ( v132043(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9256,axiom,
    ! [VarCurr] :
      ( v132099(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $true )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_548,axiom,
    ! [VarCurr] :
      ( ~ v132097(VarCurr)
     => ( v132043(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_743,axiom,
    ! [VarCurr] :
      ( v132097(VarCurr)
     => ( v132043(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9255,axiom,
    ! [VarCurr] :
      ( v132097(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3172,axiom,
    ! [VarCurr] :
      ( ~ v132095(VarCurr)
     => ( v132043(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2977,axiom,
    ! [VarCurr] :
      ( v132095(VarCurr)
     => ( v132043(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9254,axiom,
    ! [VarCurr] :
      ( v132095(VarCurr)
    <=> ( ( v132045(VarCurr,bitIndex4)
        <=> $false )
        & ( v132045(VarCurr,bitIndex3)
        <=> $false )
        & ( v132045(VarCurr,bitIndex2)
        <=> $false )
        & ( v132045(VarCurr,bitIndex1)
        <=> $false )
        & ( v132045(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2322,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132052(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v132045(VarNext,B)
            <=> v132045(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2441,axiom,
    ! [VarNext] :
      ( v132052(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132045(VarNext,B)
          <=> v132066(VarNext,B) ) ) ) ).

fof(addAssignment_41393,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v132066(VarNext,B)
          <=> v132064(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5400,axiom,
    ! [VarCurr] :
      ( ~ v132061(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132064(VarCurr,B)
          <=> v132067(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5389,axiom,
    ! [VarCurr] :
      ( v132061(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v132064(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41392,axiom,
    ! [VarCurr] :
      ( v132067(VarCurr,bitIndex0)
    <=> v132089(VarCurr) ) ).

fof(addAssignment_41391,axiom,
    ! [VarCurr] :
      ( v132067(VarCurr,bitIndex1)
    <=> v132087(VarCurr) ) ).

fof(addAssignment_41390,axiom,
    ! [VarCurr] :
      ( v132067(VarCurr,bitIndex2)
    <=> v132082(VarCurr) ) ).

fof(addAssignment_41389,axiom,
    ! [VarCurr] :
      ( v132067(VarCurr,bitIndex3)
    <=> v132077(VarCurr) ) ).

fof(addAssignment_41388,axiom,
    ! [VarCurr] :
      ( v132067(VarCurr,bitIndex4)
    <=> v132069(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26456,axiom,
    ! [VarCurr] :
      ( v132087(VarCurr)
    <=> ( v132088(VarCurr)
        & v132091(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2626,axiom,
    ! [VarCurr] :
      ( v132091(VarCurr)
    <=> ( v132045(VarCurr,bitIndex0)
        | v132045(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26455,axiom,
    ! [VarCurr] :
      ( v132088(VarCurr)
    <=> ( v132089(VarCurr)
        | v132090(VarCurr) ) ) ).

fof(writeUnaryOperator_10926,axiom,
    ! [VarCurr] :
      ( ~ v132090(VarCurr)
    <=> v132045(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10925,axiom,
    ! [VarCurr] :
      ( ~ v132089(VarCurr)
    <=> v132045(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26454,axiom,
    ! [VarCurr] :
      ( v132082(VarCurr)
    <=> ( v132083(VarCurr)
        & v132086(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2625,axiom,
    ! [VarCurr] :
      ( v132086(VarCurr)
    <=> ( v132074(VarCurr)
        | v132045(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26453,axiom,
    ! [VarCurr] :
      ( v132083(VarCurr)
    <=> ( v132084(VarCurr)
        | v132085(VarCurr) ) ) ).

fof(writeUnaryOperator_10924,axiom,
    ! [VarCurr] :
      ( ~ v132085(VarCurr)
    <=> v132045(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10923,axiom,
    ! [VarCurr] :
      ( ~ v132084(VarCurr)
    <=> v132074(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26452,axiom,
    ! [VarCurr] :
      ( v132077(VarCurr)
    <=> ( v132078(VarCurr)
        & v132081(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2624,axiom,
    ! [VarCurr] :
      ( v132081(VarCurr)
    <=> ( v132073(VarCurr)
        | v132045(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26451,axiom,
    ! [VarCurr] :
      ( v132078(VarCurr)
    <=> ( v132079(VarCurr)
        | v132080(VarCurr) ) ) ).

fof(writeUnaryOperator_10922,axiom,
    ! [VarCurr] :
      ( ~ v132080(VarCurr)
    <=> v132045(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10921,axiom,
    ! [VarCurr] :
      ( ~ v132079(VarCurr)
    <=> v132073(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26450,axiom,
    ! [VarCurr] :
      ( v132069(VarCurr)
    <=> ( v132070(VarCurr)
        & v132076(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2623,axiom,
    ! [VarCurr] :
      ( v132076(VarCurr)
    <=> ( v132072(VarCurr)
        | v132045(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26449,axiom,
    ! [VarCurr] :
      ( v132070(VarCurr)
    <=> ( v132071(VarCurr)
        | v132075(VarCurr) ) ) ).

fof(writeUnaryOperator_10920,axiom,
    ! [VarCurr] :
      ( ~ v132075(VarCurr)
    <=> v132045(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10919,axiom,
    ! [VarCurr] :
      ( ~ v132071(VarCurr)
    <=> v132072(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2622,axiom,
    ! [VarCurr] :
      ( v132072(VarCurr)
    <=> ( v132073(VarCurr)
        & v132045(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2621,axiom,
    ! [VarCurr] :
      ( v132073(VarCurr)
    <=> ( v132074(VarCurr)
        & v132045(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2620,axiom,
    ! [VarCurr] :
      ( v132074(VarCurr)
    <=> ( v132045(VarCurr,bitIndex0)
        & v132045(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26448,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132052(VarNext)
      <=> ( v132053(VarNext)
          & v132060(VarNext) ) ) ) ).

fof(addAssignment_41387,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132060(VarNext)
      <=> v132058(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26447,axiom,
    ! [VarCurr] :
      ( v132058(VarCurr)
    <=> ( v132061(VarCurr)
        | v132062(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26446,axiom,
    ! [VarCurr] :
      ( v132062(VarCurr)
    <=> ( v132047(VarCurr)
        & v132063(VarCurr) ) ) ).

fof(writeUnaryOperator_10918,axiom,
    ! [VarCurr] :
      ( ~ v132063(VarCurr)
    <=> v132061(VarCurr) ) ).

fof(writeUnaryOperator_10917,axiom,
    ! [VarCurr] :
      ( ~ v132061(VarCurr)
    <=> v10082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26445,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132053(VarNext)
      <=> ( v132054(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_10916,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132054(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(addAssignmentInitValueVector_40,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v132045(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_41386,axiom,
    ! [VarCurr] :
      ( v132047(VarCurr)
    <=> v132049(VarCurr) ) ).

fof(addAssignment_41385,axiom,
    ! [VarCurr] :
      ( v132049(VarCurr)
    <=> v131866(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesMultipleBits_44,axiom,
    ! [VarCurr,B] :
      ( range_31_0(B)
     => ( v131905(VarCurr,B)
      <=> ( v131907(VarCurr,B)
          & v132038(VarCurr,B) ) ) ) ).

fof(addAssignment_41384,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex0)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41383,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex1)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41382,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex2)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41381,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex3)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41380,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex4)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41379,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex5)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41378,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex6)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41377,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex7)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41376,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex8)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41375,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex9)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41374,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex10)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41373,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex11)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41372,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex12)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41371,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex13)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41370,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex14)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41369,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex15)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41368,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex16)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41367,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex17)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41366,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex18)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41365,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex19)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41364,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex20)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41363,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex21)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41362,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex22)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41361,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex23)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41360,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex24)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41359,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex25)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41358,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex26)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41357,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex27)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41356,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex28)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41355,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex29)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41354,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex30)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41353,axiom,
    ! [VarCurr] :
      ( v132038(VarCurr,bitIndex31)
    <=> v132039(VarCurr) ) ).

fof(addAssignment_41352,axiom,
    ! [VarCurr] :
      ( v132039(VarCurr)
    <=> v132007(VarCurr) ) ).

fof(addAssignment_41351,axiom,
    ! [VarCurr] :
      ( v132007(VarCurr)
    <=> v132009(VarCurr) ) ).

fof(addAssignment_41350,axiom,
    ! [VarCurr] :
      ( v132009(VarCurr)
    <=> v132011(VarCurr) ) ).

fof(addAssignment_41349,axiom,
    ! [VarCurr] :
      ( v132011(VarCurr)
    <=> v132013(VarCurr) ) ).

fof(addAssignment_41348,axiom,
    ! [VarCurr] :
      ( v132013(VarCurr)
    <=> v132015(VarCurr) ) ).

fof(addAssignment_41347,axiom,
    ! [VarCurr] :
      ( v132015(VarCurr)
    <=> v132017(VarCurr) ) ).

fof(addAssignment_41346,axiom,
    ! [VarCurr] :
      ( v132017(VarCurr)
    <=> v132019(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2321,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132026(VarNext)
       => ( v132019(VarNext)
        <=> v132019(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2440,axiom,
    ! [VarNext] :
      ( v132026(VarNext)
     => ( v132019(VarNext)
      <=> v132034(VarNext) ) ) ).

fof(addAssignment_41345,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132034(VarNext)
      <=> v132032(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3171,axiom,
    ! [VarCurr] :
      ( ~ v131939(VarCurr)
     => ( v132032(VarCurr)
      <=> v132021(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2976,axiom,
    ! [VarCurr] :
      ( v131939(VarCurr)
     => ( v132032(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26444,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132026(VarNext)
      <=> v132027(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26443,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v132027(VarNext)
      <=> ( v132029(VarNext)
          & v131925(VarNext) ) ) ) ).

fof(writeUnaryOperator_10915,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v132029(VarNext)
      <=> v131932(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3170,axiom,
    ! [VarCurr] :
      ( ~ v132023(VarCurr)
     => ( v132021(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2975,axiom,
    ! [VarCurr] :
      ( v132023(VarCurr)
     => ( v132021(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorShiftedRanges_2619,axiom,
    ! [VarCurr] :
      ( v132023(VarCurr)
    <=> ( v36(VarCurr,bitIndex8)
        & v44(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_547,axiom,
    ! [VarCurr] :
      ( ~ v132005(VarCurr)
     => ( v131907(VarCurr,bitIndex31)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_742,axiom,
    ! [VarCurr] :
      ( v132005(VarCurr)
     => ( v131907(VarCurr,bitIndex31)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9253,axiom,
    ! [VarCurr] :
      ( v132005(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_546,axiom,
    ! [VarCurr] :
      ( ~ v132003(VarCurr)
     => ( v131907(VarCurr,bitIndex30)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_741,axiom,
    ! [VarCurr] :
      ( v132003(VarCurr)
     => ( v131907(VarCurr,bitIndex30)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9252,axiom,
    ! [VarCurr] :
      ( v132003(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_545,axiom,
    ! [VarCurr] :
      ( ~ v132001(VarCurr)
     => ( v131907(VarCurr,bitIndex29)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_740,axiom,
    ! [VarCurr] :
      ( v132001(VarCurr)
     => ( v131907(VarCurr,bitIndex29)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9251,axiom,
    ! [VarCurr] :
      ( v132001(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_544,axiom,
    ! [VarCurr] :
      ( ~ v131999(VarCurr)
     => ( v131907(VarCurr,bitIndex28)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_739,axiom,
    ! [VarCurr] :
      ( v131999(VarCurr)
     => ( v131907(VarCurr,bitIndex28)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9250,axiom,
    ! [VarCurr] :
      ( v131999(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_543,axiom,
    ! [VarCurr] :
      ( ~ v131997(VarCurr)
     => ( v131907(VarCurr,bitIndex27)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_738,axiom,
    ! [VarCurr] :
      ( v131997(VarCurr)
     => ( v131907(VarCurr,bitIndex27)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9249,axiom,
    ! [VarCurr] :
      ( v131997(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_542,axiom,
    ! [VarCurr] :
      ( ~ v131995(VarCurr)
     => ( v131907(VarCurr,bitIndex26)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_737,axiom,
    ! [VarCurr] :
      ( v131995(VarCurr)
     => ( v131907(VarCurr,bitIndex26)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9248,axiom,
    ! [VarCurr] :
      ( v131995(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_541,axiom,
    ! [VarCurr] :
      ( ~ v131993(VarCurr)
     => ( v131907(VarCurr,bitIndex25)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_736,axiom,
    ! [VarCurr] :
      ( v131993(VarCurr)
     => ( v131907(VarCurr,bitIndex25)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9247,axiom,
    ! [VarCurr] :
      ( v131993(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_540,axiom,
    ! [VarCurr] :
      ( ~ v131991(VarCurr)
     => ( v131907(VarCurr,bitIndex24)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_735,axiom,
    ! [VarCurr] :
      ( v131991(VarCurr)
     => ( v131907(VarCurr,bitIndex24)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9246,axiom,
    ! [VarCurr] :
      ( v131991(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_539,axiom,
    ! [VarCurr] :
      ( ~ v131989(VarCurr)
     => ( v131907(VarCurr,bitIndex23)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_734,axiom,
    ! [VarCurr] :
      ( v131989(VarCurr)
     => ( v131907(VarCurr,bitIndex23)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9245,axiom,
    ! [VarCurr] :
      ( v131989(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_538,axiom,
    ! [VarCurr] :
      ( ~ v131987(VarCurr)
     => ( v131907(VarCurr,bitIndex22)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_733,axiom,
    ! [VarCurr] :
      ( v131987(VarCurr)
     => ( v131907(VarCurr,bitIndex22)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9244,axiom,
    ! [VarCurr] :
      ( v131987(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_537,axiom,
    ! [VarCurr] :
      ( ~ v131985(VarCurr)
     => ( v131907(VarCurr,bitIndex21)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_732,axiom,
    ! [VarCurr] :
      ( v131985(VarCurr)
     => ( v131907(VarCurr,bitIndex21)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9243,axiom,
    ! [VarCurr] :
      ( v131985(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_536,axiom,
    ! [VarCurr] :
      ( ~ v131983(VarCurr)
     => ( v131907(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_731,axiom,
    ! [VarCurr] :
      ( v131983(VarCurr)
     => ( v131907(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9242,axiom,
    ! [VarCurr] :
      ( v131983(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_535,axiom,
    ! [VarCurr] :
      ( ~ v131981(VarCurr)
     => ( v131907(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_730,axiom,
    ! [VarCurr] :
      ( v131981(VarCurr)
     => ( v131907(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9241,axiom,
    ! [VarCurr] :
      ( v131981(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_534,axiom,
    ! [VarCurr] :
      ( ~ v131979(VarCurr)
     => ( v131907(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_729,axiom,
    ! [VarCurr] :
      ( v131979(VarCurr)
     => ( v131907(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9240,axiom,
    ! [VarCurr] :
      ( v131979(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_533,axiom,
    ! [VarCurr] :
      ( ~ v131977(VarCurr)
     => ( v131907(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_728,axiom,
    ! [VarCurr] :
      ( v131977(VarCurr)
     => ( v131907(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9239,axiom,
    ! [VarCurr] :
      ( v131977(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_532,axiom,
    ! [VarCurr] :
      ( ~ v131975(VarCurr)
     => ( v131907(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_727,axiom,
    ! [VarCurr] :
      ( v131975(VarCurr)
     => ( v131907(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9238,axiom,
    ! [VarCurr] :
      ( v131975(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $true )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_531,axiom,
    ! [VarCurr] :
      ( ~ v131973(VarCurr)
     => ( v131907(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_726,axiom,
    ! [VarCurr] :
      ( v131973(VarCurr)
     => ( v131907(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9237,axiom,
    ! [VarCurr] :
      ( v131973(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_530,axiom,
    ! [VarCurr] :
      ( ~ v131971(VarCurr)
     => ( v131907(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_725,axiom,
    ! [VarCurr] :
      ( v131971(VarCurr)
     => ( v131907(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9236,axiom,
    ! [VarCurr] :
      ( v131971(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_529,axiom,
    ! [VarCurr] :
      ( ~ v131969(VarCurr)
     => ( v131907(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_724,axiom,
    ! [VarCurr] :
      ( v131969(VarCurr)
     => ( v131907(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9235,axiom,
    ! [VarCurr] :
      ( v131969(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_528,axiom,
    ! [VarCurr] :
      ( ~ v131967(VarCurr)
     => ( v131907(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_723,axiom,
    ! [VarCurr] :
      ( v131967(VarCurr)
     => ( v131907(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9234,axiom,
    ! [VarCurr] :
      ( v131967(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_527,axiom,
    ! [VarCurr] :
      ( ~ v131965(VarCurr)
     => ( v131907(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_722,axiom,
    ! [VarCurr] :
      ( v131965(VarCurr)
     => ( v131907(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9233,axiom,
    ! [VarCurr] :
      ( v131965(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_526,axiom,
    ! [VarCurr] :
      ( ~ v131963(VarCurr)
     => ( v131907(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_721,axiom,
    ! [VarCurr] :
      ( v131963(VarCurr)
     => ( v131907(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9232,axiom,
    ! [VarCurr] :
      ( v131963(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_525,axiom,
    ! [VarCurr] :
      ( ~ v131961(VarCurr)
     => ( v131907(VarCurr,bitIndex9)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_720,axiom,
    ! [VarCurr] :
      ( v131961(VarCurr)
     => ( v131907(VarCurr,bitIndex9)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9231,axiom,
    ! [VarCurr] :
      ( v131961(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_524,axiom,
    ! [VarCurr] :
      ( ~ v131959(VarCurr)
     => ( v131907(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_719,axiom,
    ! [VarCurr] :
      ( v131959(VarCurr)
     => ( v131907(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9230,axiom,
    ! [VarCurr] :
      ( v131959(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $true )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_523,axiom,
    ! [VarCurr] :
      ( ~ v131957(VarCurr)
     => ( v131907(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_718,axiom,
    ! [VarCurr] :
      ( v131957(VarCurr)
     => ( v131907(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9229,axiom,
    ! [VarCurr] :
      ( v131957(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_522,axiom,
    ! [VarCurr] :
      ( ~ v131955(VarCurr)
     => ( v131907(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_717,axiom,
    ! [VarCurr] :
      ( v131955(VarCurr)
     => ( v131907(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9228,axiom,
    ! [VarCurr] :
      ( v131955(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_521,axiom,
    ! [VarCurr] :
      ( ~ v131953(VarCurr)
     => ( v131907(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_716,axiom,
    ! [VarCurr] :
      ( v131953(VarCurr)
     => ( v131907(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9227,axiom,
    ! [VarCurr] :
      ( v131953(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_520,axiom,
    ! [VarCurr] :
      ( ~ v131951(VarCurr)
     => ( v131907(VarCurr,bitIndex4)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_715,axiom,
    ! [VarCurr] :
      ( v131951(VarCurr)
     => ( v131907(VarCurr,bitIndex4)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9226,axiom,
    ! [VarCurr] :
      ( v131951(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $true )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_519,axiom,
    ! [VarCurr] :
      ( ~ v131949(VarCurr)
     => ( v131907(VarCurr,bitIndex3)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_714,axiom,
    ! [VarCurr] :
      ( v131949(VarCurr)
     => ( v131907(VarCurr,bitIndex3)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9225,axiom,
    ! [VarCurr] :
      ( v131949(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_518,axiom,
    ! [VarCurr] :
      ( ~ v131947(VarCurr)
     => ( v131907(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_713,axiom,
    ! [VarCurr] :
      ( v131947(VarCurr)
     => ( v131907(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9224,axiom,
    ! [VarCurr] :
      ( v131947(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $true )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_517,axiom,
    ! [VarCurr] :
      ( ~ v131945(VarCurr)
     => ( v131907(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_712,axiom,
    ! [VarCurr] :
      ( v131945(VarCurr)
     => ( v131907(VarCurr,bitIndex1)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9223,axiom,
    ! [VarCurr] :
      ( v131945(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3169,axiom,
    ! [VarCurr] :
      ( ~ v131943(VarCurr)
     => ( v131907(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2974,axiom,
    ! [VarCurr] :
      ( v131943(VarCurr)
     => ( v131907(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9222,axiom,
    ! [VarCurr] :
      ( v131943(VarCurr)
    <=> ( ( v131909(VarCurr,bitIndex4)
        <=> $false )
        & ( v131909(VarCurr,bitIndex3)
        <=> $false )
        & ( v131909(VarCurr,bitIndex2)
        <=> $false )
        & ( v131909(VarCurr,bitIndex1)
        <=> $false )
        & ( v131909(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_41344,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131909(VarCurr,B)
      <=> v131911(VarCurr,B) ) ) ).

fof(addAssignment_41343,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131911(VarCurr,B)
      <=> v131913(VarCurr,B) ) ) ).

fof(addAssignment_41342,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131913(VarCurr,B)
      <=> v131915(VarCurr,B) ) ) ).

fof(addAssignment_41341,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131915(VarCurr,B)
      <=> v131917(VarCurr,B) ) ) ).

fof(addAssignment_41340,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131917(VarCurr,B)
      <=> v131919(VarCurr,B) ) ) ).

fof(addAssignment_41339,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131919(VarCurr,B)
      <=> v131921(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131928(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v131921(VarNext,B)
            <=> v131921(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2439,axiom,
    ! [VarNext] :
      ( v131928(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131921(VarNext,B)
          <=> v131938(VarNext,B) ) ) ) ).

fof(addAssignment_41338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131938(VarNext,B)
          <=> v131936(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3168,axiom,
    ! [VarCurr] :
      ( ~ v131939(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131936(VarCurr,B)
          <=> v131923(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2973,axiom,
    ! [VarCurr] :
      ( v131939(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131936(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_10914,axiom,
    ! [VarCurr] :
      ( ~ v131939(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26442,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131928(VarNext)
      <=> v131929(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26441,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131929(VarNext)
      <=> ( v131930(VarNext)
          & v131925(VarNext) ) ) ) ).

fof(writeUnaryOperator_10913,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131930(VarNext)
      <=> v131932(VarNext) ) ) ).

fof(addAssignment_41337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131932(VarNext)
      <=> v131925(VarCurr) ) ) ).

fof(addAssignment_41336,axiom,
    ! [VarCurr] :
      ( v131925(VarCurr)
    <=> v87026(VarCurr) ) ).

fof(addAssignment_41335,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131923(VarCurr,B)
      <=> v36(VarCurr,B) ) ) ).

fof(addAssignment_41334,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v36(VarCurr,B)
      <=> v38(VarCurr,B) ) ) ).

fof(addAssignment_41333,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v38(VarCurr,B)
      <=> v40(VarCurr,B) ) ) ).

fof(addAssignment_41332,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v40(VarCurr,B)
      <=> v42(VarCurr,B) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26440,axiom,
    ! [VarCurr] :
      ( v131872(VarCurr)
    <=> ( v131886(VarCurr)
        & v131888(VarCurr) ) ) ).

fof(writeUnaryOperator_10912,axiom,
    ! [VarCurr] :
      ( ~ v131888(VarCurr)
    <=> v114183(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26439,axiom,
    ! [VarCurr] :
      ( v131886(VarCurr)
    <=> ( v131887(VarCurr)
        & v11293(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26438,axiom,
    ! [VarCurr] :
      ( v131887(VarCurr)
    <=> ( v10100(VarCurr)
        & v131874(VarCurr) ) ) ).

fof(addAssignment_41331,axiom,
    ! [VarCurr] :
      ( v131874(VarCurr)
    <=> v131876(VarCurr) ) ).

fof(addAssignment_41330,axiom,
    ! [VarCurr] :
      ( v131876(VarCurr)
    <=> v131878(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3167,axiom,
    ! [VarCurr] :
      ( ~ v131880(VarCurr)
     => ( v131878(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2972,axiom,
    ! [VarCurr] :
      ( v131880(VarCurr)
     => ( v131878(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26437,axiom,
    ! [VarCurr] :
      ( v131880(VarCurr)
    <=> ( v131881(VarCurr)
        & v131882(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26436,axiom,
    ! [VarCurr] :
      ( v131882(VarCurr)
    <=> ( v131883(VarCurr)
        | v131884(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9221,axiom,
    ! [VarCurr] :
      ( v131884(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $false )
        & ( v15281(VarCurr,bitIndex5)
        <=> $true )
        & ( v15281(VarCurr,bitIndex4)
        <=> $false )
        & ( v15281(VarCurr,bitIndex3)
        <=> $false )
        & ( v15281(VarCurr,bitIndex2)
        <=> $false )
        & ( v15281(VarCurr,bitIndex1)
        <=> $false )
        & ( v15281(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_9220,axiom,
    ! [VarCurr] :
      ( v131883(VarCurr)
    <=> ( ( v15281(VarCurr,bitIndex6)
        <=> $false )
        & ( v15281(VarCurr,bitIndex5)
        <=> $false )
        & ( v15281(VarCurr,bitIndex4)
        <=> $false )
        & ( v15281(VarCurr,bitIndex3)
        <=> $false )
        & ( v15281(VarCurr,bitIndex2)
        <=> $false )
        & ( v15281(VarCurr,bitIndex1)
        <=> $false )
        & ( v15281(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeUnaryOperator_10911,axiom,
    ! [VarCurr] :
      ( ~ v131881(VarCurr)
    <=> v15317(VarCurr,bitIndex0) ) ).

fof(addAssignment_41329,axiom,
    ! [VarCurr] :
      ( v131870(VarCurr)
    <=> v13225(VarCurr) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_516,axiom,
    ! [VarCurr] :
      ( ~ v131862(VarCurr)
     => ( v11291(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_711,axiom,
    ! [VarCurr] :
      ( v131862(VarCurr)
     => ( v11291(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26435,axiom,
    ! [VarCurr] :
      ( v131862(VarCurr)
    <=> ( v131863(VarCurr)
        & v131852(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26434,axiom,
    ! [VarCurr] :
      ( v131863(VarCurr)
    <=> ( v11293(VarCurr)
        & v10100(VarCurr) ) ) ).

fof(addAssignment_41328,axiom,
    ! [VarNext] :
      ( v13210(VarNext,bitIndex11)
    <=> v131854(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_134,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131855(VarNext)
       => ( ( v131854(VarNext,bitIndex11)
          <=> v13210(VarCurr,bitIndex12) )
          & ( v131854(VarNext,bitIndex10)
          <=> v13210(VarCurr,bitIndex11) )
          & ( v131854(VarNext,bitIndex9)
          <=> v13210(VarCurr,bitIndex10) )
          & ( v131854(VarNext,bitIndex8)
          <=> v13210(VarCurr,bitIndex9) )
          & ( v131854(VarNext,bitIndex7)
          <=> v13210(VarCurr,bitIndex8) )
          & ( v131854(VarNext,bitIndex6)
          <=> v13210(VarCurr,bitIndex7) )
          & ( v131854(VarNext,bitIndex5)
          <=> v13210(VarCurr,bitIndex6) )
          & ( v131854(VarNext,bitIndex4)
          <=> v13210(VarCurr,bitIndex5) )
          & ( v131854(VarNext,bitIndex3)
          <=> v13210(VarCurr,bitIndex4) )
          & ( v131854(VarNext,bitIndex2)
          <=> v13210(VarCurr,bitIndex3) )
          & ( v131854(VarNext,bitIndex1)
          <=> v13210(VarCurr,bitIndex2) )
          & ( v131854(VarNext,bitIndex0)
          <=> v13210(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2438,axiom,
    ! [VarNext] :
      ( v131855(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v131854(VarNext,B)
          <=> v114262(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26433,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131855(VarNext)
      <=> v131856(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26432,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131856(VarNext)
      <=> ( v131858(VarNext)
          & v114249(VarNext) ) ) ) ).

fof(writeUnaryOperator_10910,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131858(VarNext)
      <=> v114256(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_515,axiom,
    ! [VarCurr] :
      ( ~ v131843(VarCurr)
     => ( v11291(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_710,axiom,
    ! [VarCurr] :
      ( v131843(VarCurr)
     => ( v11291(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26431,axiom,
    ! [VarCurr] :
      ( v131843(VarCurr)
    <=> ( v131844(VarCurr)
        | v131845(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26430,axiom,
    ! [VarCurr] :
      ( v131845(VarCurr)
    <=> ( v131846(VarCurr)
        & v131852(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9219,axiom,
    ! [VarCurr] :
      ( v131852(VarCurr)
    <=> ( $true
      <=> v13210(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26429,axiom,
    ! [VarCurr] :
      ( v131846(VarCurr)
    <=> ( v131847(VarCurr)
        | v131849(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26428,axiom,
    ! [VarCurr] :
      ( v131849(VarCurr)
    <=> ( v131851(VarCurr)
        & v10100(VarCurr) ) ) ).

fof(writeUnaryOperator_10909,axiom,
    ! [VarCurr] :
      ( ~ v131851(VarCurr)
    <=> v11293(VarCurr) ) ).

fof(writeUnaryOperator_10908,axiom,
    ! [VarCurr] :
      ( ~ v131847(VarCurr)
    <=> v10100(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9218,axiom,
    ! [VarCurr] :
      ( v131844(VarCurr)
    <=> ( $true
      <=> v13210(VarCurr,bitIndex10) ) ) ).

fof(addAssignment_41327,axiom,
    ! [VarNext] :
      ( v13210(VarNext,bitIndex10)
    <=> v131835(VarNext,bitIndex9) ) ).

fof(addCaseBooleanConditionShiftedRanges1_133,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131836(VarNext)
       => ( ( v131835(VarNext,bitIndex11)
          <=> v13210(VarCurr,bitIndex12) )
          & ( v131835(VarNext,bitIndex10)
          <=> v13210(VarCurr,bitIndex11) )
          & ( v131835(VarNext,bitIndex9)
          <=> v13210(VarCurr,bitIndex10) )
          & ( v131835(VarNext,bitIndex8)
          <=> v13210(VarCurr,bitIndex9) )
          & ( v131835(VarNext,bitIndex7)
          <=> v13210(VarCurr,bitIndex8) )
          & ( v131835(VarNext,bitIndex6)
          <=> v13210(VarCurr,bitIndex7) )
          & ( v131835(VarNext,bitIndex5)
          <=> v13210(VarCurr,bitIndex6) )
          & ( v131835(VarNext,bitIndex4)
          <=> v13210(VarCurr,bitIndex5) )
          & ( v131835(VarNext,bitIndex3)
          <=> v13210(VarCurr,bitIndex4) )
          & ( v131835(VarNext,bitIndex2)
          <=> v13210(VarCurr,bitIndex3) )
          & ( v131835(VarNext,bitIndex1)
          <=> v13210(VarCurr,bitIndex2) )
          & ( v131835(VarNext,bitIndex0)
          <=> v13210(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2437,axiom,
    ! [VarNext] :
      ( v131836(VarNext)
     => ! [B] :
          ( range_11_0(B)
         => ( v131835(VarNext,B)
          <=> v114262(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26427,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131836(VarNext)
      <=> v131837(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26426,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131837(VarNext)
      <=> ( v131839(VarNext)
          & v114249(VarNext) ) ) ) ).

fof(writeUnaryOperator_10907,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131839(VarNext)
      <=> v114256(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_514,axiom,
    ! [VarCurr] :
      ( ~ v131829(VarCurr)
     => ( v11291(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_709,axiom,
    ! [VarCurr] :
      ( v131829(VarCurr)
     => ( v11291(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26425,axiom,
    ! [VarCurr] :
      ( v131829(VarCurr)
    <=> ( v131830(VarCurr)
        & v114245(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26424,axiom,
    ! [VarCurr] :
      ( v131830(VarCurr)
    <=> ( v131832(VarCurr)
        & v114225(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26423,axiom,
    ! [VarCurr] :
      ( v131832(VarCurr)
    <=> ( v131833(VarCurr)
        & v114243(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26422,axiom,
    ! [VarCurr] :
      ( v131833(VarCurr)
    <=> ( v114240(VarCurr)
        & v114289(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26421,axiom,
    ! [VarCurr] :
      ( v13215(VarCurr)
    <=> ( v13217(VarCurr)
        & v131827(VarCurr) ) ) ).

fof(writeUnaryOperator_10906,axiom,
    ! [VarCurr] :
      ( ~ v131827(VarCurr)
    <=> v15288(VarCurr) ) ).

fof(addAssignment_41326,axiom,
    ! [VarCurr] :
      ( v15288(VarCurr)
    <=> v15290(VarCurr) ) ).

fof(addAssignment_41325,axiom,
    ! [VarCurr] :
      ( v15290(VarCurr)
    <=> v15292(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9217,axiom,
    ! [VarCurr] :
      ( v15292(VarCurr)
    <=> ( ( v131825(VarCurr,bitIndex4)
        <=> v131758(VarCurr,bitIndex4) )
        & ( v131825(VarCurr,bitIndex3)
        <=> v131758(VarCurr,bitIndex3) )
        & ( v131825(VarCurr,bitIndex2)
        <=> v131758(VarCurr,bitIndex2) )
        & ( v131825(VarCurr,bitIndex1)
        <=> v131758(VarCurr,bitIndex1) )
        & ( v131825(VarCurr,bitIndex0)
        <=> v131758(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_41324,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v131825(VarCurr,B)
      <=> v131674(VarCurr,B) ) ) ).

fof(addAssignment_41323,axiom,
    ! [VarCurr] :
      ( v131825(VarCurr,bitIndex4)
    <=> v15294(VarCurr) ) ).

fof(addAssignment_41322,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131758(VarCurr,B)
      <=> v131760(VarCurr,B) ) ) ).

fof(addAssignment_41321,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131760(VarCurr,B)
      <=> v131762(VarCurr,B) ) ) ).

fof(addAssignment_41320,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131762(VarCurr,B)
      <=> v131764(VarCurr,B) ) ) ).

fof(addAssignment_41319,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131764(VarCurr,B)
      <=> v131766(VarCurr,B) ) ) ).

fof(addAssignment_41318,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131766(VarCurr,B)
      <=> v131768(VarCurr,B) ) ) ).

fof(addAssignment_41317,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131768(VarCurr,B)
      <=> v131770(VarCurr,B) ) ) ).

fof(addAssignment_41316,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131770(VarCurr,B)
      <=> v131772(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131782(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v131772(VarNext,B)
            <=> v131772(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2436,axiom,
    ! [VarNext] :
      ( v131782(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131772(VarNext,B)
          <=> v131796(VarNext,B) ) ) ) ).

fof(addAssignment_41315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v131796(VarNext,B)
          <=> v131794(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5399,axiom,
    ! [VarCurr] :
      ( ~ v131791(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131794(VarCurr,B)
          <=> v131797(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5388,axiom,
    ! [VarCurr] :
      ( v131791(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v131794(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41314,axiom,
    ! [VarCurr] :
      ( v131797(VarCurr,bitIndex0)
    <=> v131819(VarCurr) ) ).

fof(addAssignment_41313,axiom,
    ! [VarCurr] :
      ( v131797(VarCurr,bitIndex1)
    <=> v131817(VarCurr) ) ).

fof(addAssignment_41312,axiom,
    ! [VarCurr] :
      ( v131797(VarCurr,bitIndex2)
    <=> v131812(VarCurr) ) ).

fof(addAssignment_41311,axiom,
    ! [VarCurr] :
      ( v131797(VarCurr,bitIndex3)
    <=> v131807(VarCurr) ) ).

fof(addAssignment_41310,axiom,
    ! [VarCurr] :
      ( v131797(VarCurr,bitIndex4)
    <=> v131799(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26420,axiom,
    ! [VarCurr] :
      ( v131817(VarCurr)
    <=> ( v131818(VarCurr)
        & v131821(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2618,axiom,
    ! [VarCurr] :
      ( v131821(VarCurr)
    <=> ( v131772(VarCurr,bitIndex0)
        | v131772(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26419,axiom,
    ! [VarCurr] :
      ( v131818(VarCurr)
    <=> ( v131819(VarCurr)
        | v131820(VarCurr) ) ) ).

fof(writeUnaryOperator_10905,axiom,
    ! [VarCurr] :
      ( ~ v131820(VarCurr)
    <=> v131772(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10904,axiom,
    ! [VarCurr] :
      ( ~ v131819(VarCurr)
    <=> v131772(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26418,axiom,
    ! [VarCurr] :
      ( v131812(VarCurr)
    <=> ( v131813(VarCurr)
        & v131816(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2617,axiom,
    ! [VarCurr] :
      ( v131816(VarCurr)
    <=> ( v131804(VarCurr)
        | v131772(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26417,axiom,
    ! [VarCurr] :
      ( v131813(VarCurr)
    <=> ( v131814(VarCurr)
        | v131815(VarCurr) ) ) ).

fof(writeUnaryOperator_10903,axiom,
    ! [VarCurr] :
      ( ~ v131815(VarCurr)
    <=> v131772(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10902,axiom,
    ! [VarCurr] :
      ( ~ v131814(VarCurr)
    <=> v131804(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26416,axiom,
    ! [VarCurr] :
      ( v131807(VarCurr)
    <=> ( v131808(VarCurr)
        & v131811(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2616,axiom,
    ! [VarCurr] :
      ( v131811(VarCurr)
    <=> ( v131803(VarCurr)
        | v131772(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26415,axiom,
    ! [VarCurr] :
      ( v131808(VarCurr)
    <=> ( v131809(VarCurr)
        | v131810(VarCurr) ) ) ).

fof(writeUnaryOperator_10901,axiom,
    ! [VarCurr] :
      ( ~ v131810(VarCurr)
    <=> v131772(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10900,axiom,
    ! [VarCurr] :
      ( ~ v131809(VarCurr)
    <=> v131803(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26414,axiom,
    ! [VarCurr] :
      ( v131799(VarCurr)
    <=> ( v131800(VarCurr)
        & v131806(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2615,axiom,
    ! [VarCurr] :
      ( v131806(VarCurr)
    <=> ( v131802(VarCurr)
        | v131772(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26413,axiom,
    ! [VarCurr] :
      ( v131800(VarCurr)
    <=> ( v131801(VarCurr)
        | v131805(VarCurr) ) ) ).

fof(writeUnaryOperator_10899,axiom,
    ! [VarCurr] :
      ( ~ v131805(VarCurr)
    <=> v131772(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10898,axiom,
    ! [VarCurr] :
      ( ~ v131801(VarCurr)
    <=> v131802(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2614,axiom,
    ! [VarCurr] :
      ( v131802(VarCurr)
    <=> ( v131803(VarCurr)
        & v131772(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2613,axiom,
    ! [VarCurr] :
      ( v131803(VarCurr)
    <=> ( v131804(VarCurr)
        & v131772(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2612,axiom,
    ! [VarCurr] :
      ( v131804(VarCurr)
    <=> ( v131772(VarCurr,bitIndex0)
        & v131772(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26412,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131782(VarNext)
      <=> ( v131783(VarNext)
          & v131790(VarNext) ) ) ) ).

fof(addAssignment_41309,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131790(VarNext)
      <=> v131788(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26411,axiom,
    ! [VarCurr] :
      ( v131788(VarCurr)
    <=> ( v131791(VarCurr)
        | v131792(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26410,axiom,
    ! [VarCurr] :
      ( v131792(VarCurr)
    <=> ( v131774(VarCurr)
        & v131793(VarCurr) ) ) ).

fof(writeUnaryOperator_10897,axiom,
    ! [VarCurr] :
      ( ~ v131793(VarCurr)
    <=> v131791(VarCurr) ) ).

fof(writeUnaryOperator_10896,axiom,
    ! [VarCurr] :
      ( ~ v131791(VarCurr)
    <=> v15405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26409,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131783(VarNext)
      <=> ( v131784(VarNext)
          & v131325(VarNext) ) ) ) ).

fof(writeUnaryOperator_10895,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131784(VarNext)
      <=> v131332(VarNext) ) ) ).

fof(addAssignmentInitValueVector_39,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v131772(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_41308,axiom,
    ! [VarCurr] :
      ( v131774(VarCurr)
    <=> v131776(VarCurr) ) ).

fof(addAssignment_41307,axiom,
    ! [VarCurr] :
      ( v131776(VarCurr)
    <=> v131778(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26408,axiom,
    ! [VarCurr] :
      ( v131778(VarCurr)
    <=> ( v129796(VarCurr)
        & v15417(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2318,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131715(VarNext)
       => ( v15294(VarNext)
        <=> v15294(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2435,axiom,
    ! [VarNext] :
      ( v131715(VarNext)
     => ( v15294(VarNext)
      <=> v131728(VarNext) ) ) ).

fof(addAssignment_41306,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131728(VarNext)
      <=> v131726(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges1_26,axiom,
    ! [VarCurr] :
      ( ~ v131686(VarCurr)
     => ( v131726(VarCurr)
      <=> v131729(VarCurr,bitIndex4) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5387,axiom,
    ! [VarCurr] :
      ( v131686(VarCurr)
     => ( v131726(VarCurr)
      <=> $false ) ) ).

fof(addAssignment_41305,axiom,
    ! [VarCurr] :
      ( v131729(VarCurr,bitIndex0)
    <=> v131752(VarCurr) ) ).

fof(addAssignment_41304,axiom,
    ! [VarCurr] :
      ( v131729(VarCurr,bitIndex1)
    <=> v131750(VarCurr) ) ).

fof(addAssignment_41303,axiom,
    ! [VarCurr] :
      ( v131729(VarCurr,bitIndex2)
    <=> v131745(VarCurr) ) ).

fof(addAssignment_41302,axiom,
    ! [VarCurr] :
      ( v131729(VarCurr,bitIndex3)
    <=> v131740(VarCurr) ) ).

fof(addAssignment_41301,axiom,
    ! [VarCurr] :
      ( v131729(VarCurr,bitIndex4)
    <=> v131731(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26407,axiom,
    ! [VarCurr] :
      ( v131750(VarCurr)
    <=> ( v131751(VarCurr)
        & v131754(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2611,axiom,
    ! [VarCurr] :
      ( v131754(VarCurr)
    <=> ( v131737(VarCurr,bitIndex0)
        | v131737(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26406,axiom,
    ! [VarCurr] :
      ( v131751(VarCurr)
    <=> ( v131752(VarCurr)
        | v131753(VarCurr) ) ) ).

fof(writeUnaryOperator_10894,axiom,
    ! [VarCurr] :
      ( ~ v131753(VarCurr)
    <=> v131737(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10893,axiom,
    ! [VarCurr] :
      ( ~ v131752(VarCurr)
    <=> v131737(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26405,axiom,
    ! [VarCurr] :
      ( v131745(VarCurr)
    <=> ( v131746(VarCurr)
        & v131749(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2610,axiom,
    ! [VarCurr] :
      ( v131749(VarCurr)
    <=> ( v131736(VarCurr)
        | v131737(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26404,axiom,
    ! [VarCurr] :
      ( v131746(VarCurr)
    <=> ( v131747(VarCurr)
        | v131748(VarCurr) ) ) ).

fof(writeUnaryOperator_10892,axiom,
    ! [VarCurr] :
      ( ~ v131748(VarCurr)
    <=> v131737(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10891,axiom,
    ! [VarCurr] :
      ( ~ v131747(VarCurr)
    <=> v131736(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26403,axiom,
    ! [VarCurr] :
      ( v131740(VarCurr)
    <=> ( v131741(VarCurr)
        & v131744(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2609,axiom,
    ! [VarCurr] :
      ( v131744(VarCurr)
    <=> ( v131735(VarCurr)
        | v131737(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26402,axiom,
    ! [VarCurr] :
      ( v131741(VarCurr)
    <=> ( v131742(VarCurr)
        | v131743(VarCurr) ) ) ).

fof(writeUnaryOperator_10890,axiom,
    ! [VarCurr] :
      ( ~ v131743(VarCurr)
    <=> v131737(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10889,axiom,
    ! [VarCurr] :
      ( ~ v131742(VarCurr)
    <=> v131735(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26401,axiom,
    ! [VarCurr] :
      ( v131731(VarCurr)
    <=> ( v131732(VarCurr)
        & v131739(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2608,axiom,
    ! [VarCurr] :
      ( v131739(VarCurr)
    <=> ( v131734(VarCurr)
        | v131737(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26400,axiom,
    ! [VarCurr] :
      ( v131732(VarCurr)
    <=> ( v131733(VarCurr)
        | v131738(VarCurr) ) ) ).

fof(writeUnaryOperator_10888,axiom,
    ! [VarCurr] :
      ( ~ v131738(VarCurr)
    <=> v131737(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10887,axiom,
    ! [VarCurr] :
      ( ~ v131733(VarCurr)
    <=> v131734(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2607,axiom,
    ! [VarCurr] :
      ( v131734(VarCurr)
    <=> ( v131735(VarCurr)
        & v131737(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2606,axiom,
    ! [VarCurr] :
      ( v131735(VarCurr)
    <=> ( v131736(VarCurr)
        & v131737(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2605,axiom,
    ! [VarCurr] :
      ( v131736(VarCurr)
    <=> ( v131737(VarCurr,bitIndex0)
        & v131737(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_41300,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v131737(VarCurr,B)
      <=> v131674(VarCurr,B) ) ) ).

fof(addAssignment_41299,axiom,
    ! [VarCurr] :
      ( v131737(VarCurr,bitIndex4)
    <=> v15294(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26399,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131715(VarNext)
      <=> ( v131716(VarNext)
          & v131723(VarNext) ) ) ) ).

fof(addAssignment_41298,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131723(VarNext)
      <=> v131721(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26398,axiom,
    ! [VarCurr] :
      ( v131721(VarCurr)
    <=> ( v131686(VarCurr)
        | v131724(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26397,axiom,
    ! [VarCurr] :
      ( v131724(VarCurr)
    <=> ( v15296(VarCurr)
        & v131725(VarCurr) ) ) ).

fof(writeUnaryOperator_10886,axiom,
    ! [VarCurr] :
      ( ~ v131725(VarCurr)
    <=> v131686(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26396,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131716(VarNext)
      <=> ( v131718(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_10885,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131718(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(addAssignmentInitValueVector_38,axiom,
    ( v15294(constB0)
  <=> $false ) ).

fof(addCaseBooleanConditionEqualRanges1_2317,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131677(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v131674(VarNext,B)
            <=> v131674(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2434,axiom,
    ! [VarNext] :
      ( v131677(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v131674(VarNext,B)
          <=> v131691(VarNext,B) ) ) ) ).

fof(addAssignment_41297,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v131691(VarNext,B)
          <=> v131689(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5398,axiom,
    ! [VarCurr] :
      ( ~ v131686(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v131689(VarCurr,B)
          <=> v131692(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5386,axiom,
    ! [VarCurr] :
      ( v131686(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v131689(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41296,axiom,
    ! [VarCurr] :
      ( v131692(VarCurr,bitIndex0)
    <=> v131708(VarCurr) ) ).

fof(addAssignment_41295,axiom,
    ! [VarCurr] :
      ( v131692(VarCurr,bitIndex1)
    <=> v131706(VarCurr) ) ).

fof(addAssignment_41294,axiom,
    ! [VarCurr] :
      ( v131692(VarCurr,bitIndex2)
    <=> v131701(VarCurr) ) ).

fof(addAssignment_41293,axiom,
    ! [VarCurr] :
      ( v131692(VarCurr,bitIndex3)
    <=> v131694(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26395,axiom,
    ! [VarCurr] :
      ( v131706(VarCurr)
    <=> ( v131707(VarCurr)
        & v131710(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2604,axiom,
    ! [VarCurr] :
      ( v131710(VarCurr)
    <=> ( v131674(VarCurr,bitIndex0)
        | v131674(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26394,axiom,
    ! [VarCurr] :
      ( v131707(VarCurr)
    <=> ( v131708(VarCurr)
        | v131709(VarCurr) ) ) ).

fof(writeUnaryOperator_10884,axiom,
    ! [VarCurr] :
      ( ~ v131709(VarCurr)
    <=> v131674(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10883,axiom,
    ! [VarCurr] :
      ( ~ v131708(VarCurr)
    <=> v131674(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26393,axiom,
    ! [VarCurr] :
      ( v131701(VarCurr)
    <=> ( v131702(VarCurr)
        & v131705(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2603,axiom,
    ! [VarCurr] :
      ( v131705(VarCurr)
    <=> ( v131698(VarCurr)
        | v131674(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26392,axiom,
    ! [VarCurr] :
      ( v131702(VarCurr)
    <=> ( v131703(VarCurr)
        | v131704(VarCurr) ) ) ).

fof(writeUnaryOperator_10882,axiom,
    ! [VarCurr] :
      ( ~ v131704(VarCurr)
    <=> v131674(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10881,axiom,
    ! [VarCurr] :
      ( ~ v131703(VarCurr)
    <=> v131698(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26391,axiom,
    ! [VarCurr] :
      ( v131694(VarCurr)
    <=> ( v131695(VarCurr)
        & v131700(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2602,axiom,
    ! [VarCurr] :
      ( v131700(VarCurr)
    <=> ( v131697(VarCurr)
        | v131674(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26390,axiom,
    ! [VarCurr] :
      ( v131695(VarCurr)
    <=> ( v131696(VarCurr)
        | v131699(VarCurr) ) ) ).

fof(writeUnaryOperator_10880,axiom,
    ! [VarCurr] :
      ( ~ v131699(VarCurr)
    <=> v131674(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10879,axiom,
    ! [VarCurr] :
      ( ~ v131696(VarCurr)
    <=> v131697(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2601,axiom,
    ! [VarCurr] :
      ( v131697(VarCurr)
    <=> ( v131698(VarCurr)
        & v131674(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2600,axiom,
    ! [VarCurr] :
      ( v131698(VarCurr)
    <=> ( v131674(VarCurr,bitIndex0)
        & v131674(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26389,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131677(VarNext)
      <=> ( v131678(VarNext)
          & v131685(VarNext) ) ) ) ).

fof(addAssignment_41292,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131685(VarNext)
      <=> v131683(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26388,axiom,
    ! [VarCurr] :
      ( v131683(VarCurr)
    <=> ( v131686(VarCurr)
        | v131687(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26387,axiom,
    ! [VarCurr] :
      ( v131687(VarCurr)
    <=> ( v15296(VarCurr)
        & v131688(VarCurr) ) ) ).

fof(writeUnaryOperator_10878,axiom,
    ! [VarCurr] :
      ( ~ v131688(VarCurr)
    <=> v131686(VarCurr) ) ).

fof(writeUnaryOperator_10877,axiom,
    ! [VarCurr] :
      ( ~ v131686(VarCurr)
    <=> v10082(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26386,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131678(VarNext)
      <=> ( v131679(VarNext)
          & v15334(VarNext) ) ) ) ).

fof(writeUnaryOperator_10876,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131679(VarNext)
      <=> v15341(VarNext) ) ) ).

fof(addAssignmentInitValueVector_37,axiom,
    ! [B] :
      ( range_3_0(B)
     => ( v131674(constB0,B)
      <=> $false ) ) ).

fof(addAssignment_41291,axiom,
    ! [VarCurr] :
      ( v15296(VarCurr)
    <=> v15298(VarCurr) ) ).

fof(addAssignment_41290,axiom,
    ! [VarCurr] :
      ( v15298(VarCurr)
    <=> v15300(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2599,axiom,
    ! [VarCurr] :
      ( v15300(VarCurr)
    <=> ( v10094(VarCurr,bitIndex15)
        | v10094(VarCurr,bitIndex19) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_513,axiom,
    ! [VarCurr] :
      ( ~ v131669(VarCurr)
     => ( v10094(VarCurr,bitIndex15)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_708,axiom,
    ! [VarCurr] :
      ( v131669(VarCurr)
     => ( v10094(VarCurr,bitIndex15)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26385,axiom,
    ! [VarCurr] :
      ( v131669(VarCurr)
    <=> ( v131670(VarCurr)
        | v131671(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26384,axiom,
    ! [VarCurr] :
      ( v131671(VarCurr)
    <=> ( v10096(VarCurr)
        & v131659(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26383,axiom,
    ! [VarCurr] :
      ( v131670(VarCurr)
    <=> ( v10096(VarCurr)
        & v131656(VarCurr) ) ) ).

fof(addAssignment_41289,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex16)
    <=> v131661(VarNext,bitIndex15) ) ).

fof(addCaseBooleanConditionShiftedRanges1_132,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131662(VarNext)
       => ( ( v131661(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131661(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131661(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131661(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131661(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131661(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131661(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131661(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131661(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131661(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131661(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131661(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131661(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131661(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131661(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131661(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131661(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131661(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131661(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131661(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2433,axiom,
    ! [VarNext] :
      ( v131662(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131661(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26382,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131662(VarNext)
      <=> v131663(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26381,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131663(VarNext)
      <=> ( v131665(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10875,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131665(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_512,axiom,
    ! [VarCurr] :
      ( ~ v131653(VarCurr)
     => ( v10094(VarCurr,bitIndex16)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_707,axiom,
    ! [VarCurr] :
      ( v131653(VarCurr)
     => ( v10094(VarCurr,bitIndex16)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26380,axiom,
    ! [VarCurr] :
      ( v131653(VarCurr)
    <=> ( v131654(VarCurr)
        | v131657(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26379,axiom,
    ! [VarCurr] :
      ( v131657(VarCurr)
    <=> ( v131658(VarCurr)
        & v131659(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9216,axiom,
    ! [VarCurr] :
      ( v131659(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex16) ) ) ).

fof(writeUnaryOperator_10874,axiom,
    ! [VarCurr] :
      ( ~ v131658(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26378,axiom,
    ! [VarCurr] :
      ( v131654(VarCurr)
    <=> ( v131655(VarCurr)
        & v131656(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9215,axiom,
    ! [VarCurr] :
      ( v131656(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex14) ) ) ).

fof(writeUnaryOperator_10873,axiom,
    ! [VarCurr] :
      ( ~ v131655(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(addAssignment_41288,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex14)
    <=> v131645(VarNext,bitIndex13) ) ).

fof(addCaseBooleanConditionShiftedRanges1_131,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131646(VarNext)
       => ( ( v131645(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131645(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131645(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131645(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131645(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131645(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131645(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131645(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131645(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131645(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131645(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131645(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131645(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131645(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131645(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131645(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131645(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131645(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131645(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131645(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2432,axiom,
    ! [VarNext] :
      ( v131646(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131645(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26377,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131646(VarNext)
      <=> v131647(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26376,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131647(VarNext)
      <=> ( v131649(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10872,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131649(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_511,axiom,
    ! [VarCurr] :
      ( ~ v131643(VarCurr)
     => ( v10094(VarCurr,bitIndex14)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_706,axiom,
    ! [VarCurr] :
      ( v131643(VarCurr)
     => ( v10094(VarCurr,bitIndex14)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9214,axiom,
    ! [VarCurr] :
      ( v131643(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex13) ) ) ).

fof(addAssignment_41287,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex13)
    <=> v131635(VarNext,bitIndex12) ) ).

fof(addCaseBooleanConditionShiftedRanges1_130,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131636(VarNext)
       => ( ( v131635(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131635(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131635(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131635(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131635(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131635(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131635(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131635(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131635(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131635(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131635(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131635(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131635(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131635(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131635(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131635(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131635(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131635(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131635(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131635(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2431,axiom,
    ! [VarNext] :
      ( v131636(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131635(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26375,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131636(VarNext)
      <=> v131637(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26374,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131637(VarNext)
      <=> ( v131639(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10871,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131639(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_510,axiom,
    ! [VarCurr] :
      ( ~ v131630(VarCurr)
     => ( v10094(VarCurr,bitIndex13)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_705,axiom,
    ! [VarCurr] :
      ( v131630(VarCurr)
     => ( v10094(VarCurr,bitIndex13)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26373,axiom,
    ! [VarCurr] :
      ( v131630(VarCurr)
    <=> ( v131631(VarCurr)
        & v131436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26372,axiom,
    ! [VarCurr] :
      ( v131631(VarCurr)
    <=> ( v131633(VarCurr)
        & v131435(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26371,axiom,
    ! [VarCurr] :
      ( v131633(VarCurr)
    <=> ( v131550(VarCurr)
        & v131387(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2316,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131618(VarNext)
       => ( v15302(VarNext,bitIndex0)
        <=> v15302(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2430,axiom,
    ! [VarNext] :
      ( v131618(VarNext)
     => ( v15302(VarNext,bitIndex0)
      <=> v131626(VarNext) ) ) ).

fof(addAssignment_41286,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131626(VarNext)
      <=> v131624(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3166,axiom,
    ! [VarCurr] :
      ( ~ v131418(VarCurr)
     => ( v131624(VarCurr)
      <=> v10094(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2971,axiom,
    ! [VarCurr] :
      ( v131418(VarCurr)
     => ( v131624(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26370,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131618(VarNext)
      <=> v131619(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26369,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131619(VarNext)
      <=> ( v131621(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10870,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131621(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3165,axiom,
    ! [VarCurr] :
      ( ~ v131601(VarCurr)
     => ( v10094(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2970,axiom,
    ! [VarCurr] :
      ( v131601(VarCurr)
     => ( v10094(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26368,axiom,
    ! [VarCurr] :
      ( v131601(VarCurr)
    <=> ( v131602(VarCurr)
        | v131615(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9213,axiom,
    ! [VarCurr] :
      ( v131615(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex19) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26367,axiom,
    ! [VarCurr] :
      ( v131602(VarCurr)
    <=> ( v131603(VarCurr)
        | v131614(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9212,axiom,
    ! [VarCurr] :
      ( v131614(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex15) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26366,axiom,
    ! [VarCurr] :
      ( v131603(VarCurr)
    <=> ( v131604(VarCurr)
        | v131613(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9211,axiom,
    ! [VarCurr] :
      ( v131613(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex11) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26365,axiom,
    ! [VarCurr] :
      ( v131604(VarCurr)
    <=> ( v131605(VarCurr)
        | v131612(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9210,axiom,
    ! [VarCurr] :
      ( v131612(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex7) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26364,axiom,
    ! [VarCurr] :
      ( v131605(VarCurr)
    <=> ( v131606(VarCurr)
        | v131611(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9209,axiom,
    ! [VarCurr] :
      ( v131611(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26363,axiom,
    ! [VarCurr] :
      ( v131606(VarCurr)
    <=> ( v131607(VarCurr)
        & v131436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26362,axiom,
    ! [VarCurr] :
      ( v131607(VarCurr)
    <=> ( v131608(VarCurr)
        | v131609(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26361,axiom,
    ! [VarCurr] :
      ( v131609(VarCurr)
    <=> ( v131549(VarCurr)
        & v131435(VarCurr) ) ) ).

fof(addAssignment_41285,axiom,
    ! [VarCurr] :
      ( v131608(VarCurr)
    <=> v15307(VarCurr) ) ).

fof(addAssignment_41284,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex19)
    <=> v131593(VarNext,bitIndex18) ) ).

fof(addCaseBooleanConditionShiftedRanges1_129,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131594(VarNext)
       => ( ( v131593(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131593(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131593(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131593(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131593(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131593(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131593(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131593(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131593(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131593(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131593(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131593(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131593(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131593(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131593(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131593(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131593(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131593(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131593(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131593(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2429,axiom,
    ! [VarNext] :
      ( v131594(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131593(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26360,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131594(VarNext)
      <=> v131595(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26359,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131595(VarNext)
      <=> ( v131597(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10869,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131597(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_509,axiom,
    ! [VarCurr] :
      ( ~ v131589(VarCurr)
     => ( v10094(VarCurr,bitIndex19)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_704,axiom,
    ! [VarCurr] :
      ( v131589(VarCurr)
     => ( v10094(VarCurr,bitIndex19)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26358,axiom,
    ! [VarCurr] :
      ( v131589(VarCurr)
    <=> ( v131590(VarCurr)
        | v131591(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26357,axiom,
    ! [VarCurr] :
      ( v131591(VarCurr)
    <=> ( v10096(VarCurr)
        & v131579(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26356,axiom,
    ! [VarCurr] :
      ( v131590(VarCurr)
    <=> ( v10096(VarCurr)
        & v131576(VarCurr) ) ) ).

fof(addAssignment_41283,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex20)
    <=> v131581(VarNext,bitIndex19) ) ).

fof(addCaseBooleanConditionShiftedRanges1_128,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131582(VarNext)
       => ( ( v131581(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131581(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131581(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131581(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131581(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131581(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131581(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131581(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131581(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131581(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131581(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131581(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131581(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131581(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131581(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131581(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131581(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131581(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131581(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131581(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2428,axiom,
    ! [VarNext] :
      ( v131582(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131581(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26355,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131582(VarNext)
      <=> v131583(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26354,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131583(VarNext)
      <=> ( v131585(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10868,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131585(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_508,axiom,
    ! [VarCurr] :
      ( ~ v131573(VarCurr)
     => ( v10094(VarCurr,bitIndex20)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_703,axiom,
    ! [VarCurr] :
      ( v131573(VarCurr)
     => ( v10094(VarCurr,bitIndex20)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26353,axiom,
    ! [VarCurr] :
      ( v131573(VarCurr)
    <=> ( v131574(VarCurr)
        | v131577(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26352,axiom,
    ! [VarCurr] :
      ( v131577(VarCurr)
    <=> ( v131578(VarCurr)
        & v131579(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9208,axiom,
    ! [VarCurr] :
      ( v131579(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex20) ) ) ).

fof(writeUnaryOperator_10867,axiom,
    ! [VarCurr] :
      ( ~ v131578(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26351,axiom,
    ! [VarCurr] :
      ( v131574(VarCurr)
    <=> ( v131575(VarCurr)
        & v131576(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9207,axiom,
    ! [VarCurr] :
      ( v131576(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex18) ) ) ).

fof(writeUnaryOperator_10866,axiom,
    ! [VarCurr] :
      ( ~ v131575(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(addAssignment_41282,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex18)
    <=> v131565(VarNext,bitIndex17) ) ).

fof(addCaseBooleanConditionShiftedRanges1_127,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131566(VarNext)
       => ( ( v131565(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131565(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131565(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131565(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131565(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131565(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131565(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131565(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131565(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131565(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131565(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131565(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131565(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131565(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131565(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131565(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131565(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131565(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131565(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131565(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2427,axiom,
    ! [VarNext] :
      ( v131566(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131565(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26350,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131566(VarNext)
      <=> v131567(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26349,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131567(VarNext)
      <=> ( v131569(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10865,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131569(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_507,axiom,
    ! [VarCurr] :
      ( ~ v131563(VarCurr)
     => ( v10094(VarCurr,bitIndex18)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_702,axiom,
    ! [VarCurr] :
      ( v131563(VarCurr)
     => ( v10094(VarCurr,bitIndex18)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9206,axiom,
    ! [VarCurr] :
      ( v131563(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex17) ) ) ).

fof(addAssignment_41281,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex17)
    <=> v131555(VarNext,bitIndex16) ) ).

fof(addCaseBooleanConditionShiftedRanges1_126,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131556(VarNext)
       => ( ( v131555(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131555(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131555(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131555(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131555(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131555(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131555(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131555(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131555(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131555(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131555(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131555(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131555(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131555(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131555(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131555(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131555(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131555(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131555(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131555(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2426,axiom,
    ! [VarNext] :
      ( v131556(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131555(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26348,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131556(VarNext)
      <=> v131557(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26347,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131557(VarNext)
      <=> ( v131559(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10864,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131559(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_506,axiom,
    ! [VarCurr] :
      ( ~ v131546(VarCurr)
     => ( v10094(VarCurr,bitIndex17)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_701,axiom,
    ! [VarCurr] :
      ( v131546(VarCurr)
     => ( v10094(VarCurr,bitIndex17)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26346,axiom,
    ! [VarCurr] :
      ( v131546(VarCurr)
    <=> ( v131547(VarCurr)
        & v131436(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26345,axiom,
    ! [VarCurr] :
      ( v131547(VarCurr)
    <=> ( v131549(VarCurr)
        & v131395(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26344,axiom,
    ! [VarCurr] :
      ( v131549(VarCurr)
    <=> ( v131550(VarCurr)
        & v131434(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26343,axiom,
    ! [VarCurr] :
      ( v131550(VarCurr)
    <=> ( v131551(VarCurr)
        & v131433(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26342,axiom,
    ! [VarCurr] :
      ( v131551(VarCurr)
    <=> ( v131552(VarCurr)
        & v131432(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26341,axiom,
    ! [VarCurr] :
      ( v131552(VarCurr)
    <=> ( v131431(VarCurr)
        & v131553(VarCurr) ) ) ).

fof(writeUnaryOperator_10863,axiom,
    ! [VarCurr] :
      ( ~ v131553(VarCurr)
    <=> v131383(VarCurr) ) ).

fof(addAssignment_41280,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex15)
    <=> v131538(VarNext,bitIndex14) ) ).

fof(addCaseBooleanConditionShiftedRanges1_125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131539(VarNext)
       => ( ( v131538(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131538(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131538(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131538(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131538(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131538(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131538(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131538(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131538(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131538(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131538(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131538(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131538(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131538(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131538(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131538(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131538(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131538(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131538(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131538(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2425,axiom,
    ! [VarNext] :
      ( v131539(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131538(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26340,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131539(VarNext)
      <=> v131540(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26339,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131540(VarNext)
      <=> ( v131542(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10862,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131542(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addAssignment_41279,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex11)
    <=> v131530(VarNext,bitIndex10) ) ).

fof(addCaseBooleanConditionShiftedRanges1_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131531(VarNext)
       => ( ( v131530(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131530(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131530(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131530(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131530(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131530(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131530(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131530(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131530(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131530(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131530(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131530(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131530(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131530(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131530(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131530(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131530(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131530(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131530(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131530(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2424,axiom,
    ! [VarNext] :
      ( v131531(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131530(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26338,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131531(VarNext)
      <=> v131532(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26337,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131532(VarNext)
      <=> ( v131534(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10861,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131534(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_505,axiom,
    ! [VarCurr] :
      ( ~ v131524(VarCurr)
     => ( v10094(VarCurr,bitIndex11)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_700,axiom,
    ! [VarCurr] :
      ( v131524(VarCurr)
     => ( v10094(VarCurr,bitIndex11)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26336,axiom,
    ! [VarCurr] :
      ( v131524(VarCurr)
    <=> ( v131525(VarCurr)
        | v131527(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26335,axiom,
    ! [VarCurr] :
      ( v131527(VarCurr)
    <=> ( v131528(VarCurr)
        & v131514(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26334,axiom,
    ! [VarCurr] :
      ( v131528(VarCurr)
    <=> ( v10096(VarCurr)
        & v131422(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26333,axiom,
    ! [VarCurr] :
      ( v131525(VarCurr)
    <=> ( v131526(VarCurr)
        & v131509(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26332,axiom,
    ! [VarCurr] :
      ( v131526(VarCurr)
    <=> ( v10096(VarCurr)
        & v131422(VarCurr) ) ) ).

fof(addAssignment_41278,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex12)
    <=> v131516(VarNext,bitIndex11) ) ).

fof(addCaseBooleanConditionShiftedRanges1_123,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131517(VarNext)
       => ( ( v131516(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131516(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131516(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131516(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131516(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131516(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131516(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131516(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131516(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131516(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131516(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131516(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131516(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131516(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131516(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131516(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131516(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131516(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131516(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131516(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2423,axiom,
    ! [VarNext] :
      ( v131517(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131516(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26331,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131517(VarNext)
      <=> v131518(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26330,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131518(VarNext)
      <=> ( v131520(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10860,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131520(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_504,axiom,
    ! [VarCurr] :
      ( ~ v131504(VarCurr)
     => ( v10094(VarCurr,bitIndex12)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_699,axiom,
    ! [VarCurr] :
      ( v131504(VarCurr)
     => ( v10094(VarCurr,bitIndex12)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26329,axiom,
    ! [VarCurr] :
      ( v131504(VarCurr)
    <=> ( v131505(VarCurr)
        | v131510(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26328,axiom,
    ! [VarCurr] :
      ( v131510(VarCurr)
    <=> ( v131511(VarCurr)
        & v131514(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9205,axiom,
    ! [VarCurr] :
      ( v131514(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex12) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26327,axiom,
    ! [VarCurr] :
      ( v131511(VarCurr)
    <=> ( v131512(VarCurr)
        | v131513(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26326,axiom,
    ! [VarCurr] :
      ( v131513(VarCurr)
    <=> ( v10096(VarCurr)
        & v131463(VarCurr) ) ) ).

fof(writeUnaryOperator_10859,axiom,
    ! [VarCurr] :
      ( ~ v131512(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26325,axiom,
    ! [VarCurr] :
      ( v131505(VarCurr)
    <=> ( v131506(VarCurr)
        & v131509(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9204,axiom,
    ! [VarCurr] :
      ( v131509(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex10) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26324,axiom,
    ! [VarCurr] :
      ( v131506(VarCurr)
    <=> ( v131507(VarCurr)
        | v131508(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26323,axiom,
    ! [VarCurr] :
      ( v131508(VarCurr)
    <=> ( v10096(VarCurr)
        & v131463(VarCurr) ) ) ).

fof(writeUnaryOperator_10858,axiom,
    ! [VarCurr] :
      ( ~ v131507(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(addAssignment_41277,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex10)
    <=> v131496(VarNext,bitIndex9) ) ).

fof(addCaseBooleanConditionShiftedRanges1_122,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131497(VarNext)
       => ( ( v131496(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131496(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131496(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131496(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131496(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131496(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131496(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131496(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131496(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131496(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131496(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131496(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131496(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131496(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131496(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131496(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131496(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131496(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131496(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131496(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2422,axiom,
    ! [VarNext] :
      ( v131497(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131496(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26322,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131497(VarNext)
      <=> v131498(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26321,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131498(VarNext)
      <=> ( v131500(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10857,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131500(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_503,axiom,
    ! [VarCurr] :
      ( ~ v131494(VarCurr)
     => ( v10094(VarCurr,bitIndex10)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_698,axiom,
    ! [VarCurr] :
      ( v131494(VarCurr)
     => ( v10094(VarCurr,bitIndex10)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9203,axiom,
    ! [VarCurr] :
      ( v131494(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex9) ) ) ).

fof(addAssignment_41276,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex7)
    <=> v131486(VarNext,bitIndex6) ) ).

fof(addCaseBooleanConditionShiftedRanges1_121,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131487(VarNext)
       => ( ( v131486(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131486(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131486(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131486(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131486(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131486(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131486(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131486(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131486(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131486(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131486(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131486(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131486(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131486(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131486(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131486(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131486(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131486(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131486(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131486(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2421,axiom,
    ! [VarNext] :
      ( v131487(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131486(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26320,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131487(VarNext)
      <=> v131488(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26319,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131488(VarNext)
      <=> ( v131490(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10856,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131490(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_502,axiom,
    ! [VarCurr] :
      ( ~ v131479(VarCurr)
     => ( v10094(VarCurr,bitIndex7)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_697,axiom,
    ! [VarCurr] :
      ( v131479(VarCurr)
     => ( v10094(VarCurr,bitIndex7)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26318,axiom,
    ! [VarCurr] :
      ( v131479(VarCurr)
    <=> ( v131480(VarCurr)
        | v131483(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26317,axiom,
    ! [VarCurr] :
      ( v131483(VarCurr)
    <=> ( v131484(VarCurr)
        & v131469(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26316,axiom,
    ! [VarCurr] :
      ( v131484(VarCurr)
    <=> ( v10096(VarCurr)
        & v131422(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26315,axiom,
    ! [VarCurr] :
      ( v131480(VarCurr)
    <=> ( v131481(VarCurr)
        & v131464(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26314,axiom,
    ! [VarCurr] :
      ( v131481(VarCurr)
    <=> ( v10096(VarCurr)
        & v131422(VarCurr) ) ) ).

fof(addAssignment_41275,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex8)
    <=> v131471(VarNext,bitIndex7) ) ).

fof(addCaseBooleanConditionShiftedRanges1_120,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131472(VarNext)
       => ( ( v131471(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131471(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131471(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131471(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131471(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131471(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131471(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131471(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131471(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131471(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131471(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131471(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131471(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131471(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131471(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131471(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131471(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131471(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131471(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131471(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2420,axiom,
    ! [VarNext] :
      ( v131472(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131471(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26313,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131472(VarNext)
      <=> v131473(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26312,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131473(VarNext)
      <=> ( v131475(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10855,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131475(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_501,axiom,
    ! [VarCurr] :
      ( ~ v131456(VarCurr)
     => ( v10094(VarCurr,bitIndex8)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_696,axiom,
    ! [VarCurr] :
      ( v131456(VarCurr)
     => ( v10094(VarCurr,bitIndex8)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26311,axiom,
    ! [VarCurr] :
      ( v131456(VarCurr)
    <=> ( v131457(VarCurr)
        | v131465(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26310,axiom,
    ! [VarCurr] :
      ( v131465(VarCurr)
    <=> ( v131466(VarCurr)
        & v131469(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9202,axiom,
    ! [VarCurr] :
      ( v131469(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex8) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26309,axiom,
    ! [VarCurr] :
      ( v131466(VarCurr)
    <=> ( v131467(VarCurr)
        | v131468(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26308,axiom,
    ! [VarCurr] :
      ( v131468(VarCurr)
    <=> ( v10096(VarCurr)
        & v131463(VarCurr) ) ) ).

fof(writeUnaryOperator_10854,axiom,
    ! [VarCurr] :
      ( ~ v131467(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26307,axiom,
    ! [VarCurr] :
      ( v131457(VarCurr)
    <=> ( v131458(VarCurr)
        & v131464(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9201,axiom,
    ! [VarCurr] :
      ( v131464(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26306,axiom,
    ! [VarCurr] :
      ( v131458(VarCurr)
    <=> ( v131459(VarCurr)
        | v131461(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26305,axiom,
    ! [VarCurr] :
      ( v131461(VarCurr)
    <=> ( v10096(VarCurr)
        & v131463(VarCurr) ) ) ).

fof(writeUnaryOperator_10853,axiom,
    ! [VarCurr] :
      ( ~ v131463(VarCurr)
    <=> v131422(VarCurr) ) ).

fof(writeUnaryOperator_10852,axiom,
    ! [VarCurr] :
      ( ~ v131459(VarCurr)
    <=> v10096(VarCurr) ) ).

fof(addAssignment_41274,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex6)
    <=> v131448(VarNext,bitIndex5) ) ).

fof(addCaseBooleanConditionShiftedRanges1_119,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131449(VarNext)
       => ( ( v131448(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131448(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131448(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131448(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131448(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131448(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131448(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131448(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131448(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131448(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131448(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131448(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131448(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131448(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131448(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131448(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131448(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131448(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131448(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131448(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2419,axiom,
    ! [VarNext] :
      ( v131449(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131448(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26304,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131449(VarNext)
      <=> v131450(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26303,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131450(VarNext)
      <=> ( v131452(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10851,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131452(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_500,axiom,
    ! [VarCurr] :
      ( ~ v131446(VarCurr)
     => ( v10094(VarCurr,bitIndex6)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_695,axiom,
    ! [VarCurr] :
      ( v131446(VarCurr)
     => ( v10094(VarCurr,bitIndex6)
      <=> $true ) ) ).

fof(addBitVectorEqualityBitBlasted_9200,axiom,
    ! [VarCurr] :
      ( v131446(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex5) ) ) ).

fof(addAssignment_41273,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex5)
    <=> v131438(VarNext,bitIndex4) ) ).

fof(addCaseBooleanConditionShiftedRanges1_118,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131439(VarNext)
       => ( ( v131438(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131438(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131438(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131438(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131438(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131438(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131438(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131438(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131438(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131438(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131438(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131438(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131438(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131438(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131438(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131438(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131438(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131438(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131438(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131438(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2418,axiom,
    ! [VarNext] :
      ( v131439(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131438(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26302,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131439(VarNext)
      <=> v131440(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26301,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131440(VarNext)
      <=> ( v131442(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10850,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131442(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_499,axiom,
    ! [VarCurr] :
      ( ~ v131424(VarCurr)
     => ( v10094(VarCurr,bitIndex5)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_694,axiom,
    ! [VarCurr] :
      ( v131424(VarCurr)
     => ( v10094(VarCurr,bitIndex5)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26300,axiom,
    ! [VarCurr] :
      ( v131424(VarCurr)
    <=> ( v131425(VarCurr)
        & v131436(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9199,axiom,
    ! [VarCurr] :
      ( v131436(VarCurr)
    <=> ( $true
      <=> v15302(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26299,axiom,
    ! [VarCurr] :
      ( v131425(VarCurr)
    <=> ( v131427(VarCurr)
        & v131435(VarCurr) ) ) ).

fof(writeUnaryOperator_10849,axiom,
    ! [VarCurr] :
      ( ~ v131435(VarCurr)
    <=> v131395(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26298,axiom,
    ! [VarCurr] :
      ( v131427(VarCurr)
    <=> ( v131428(VarCurr)
        & v131434(VarCurr) ) ) ).

fof(writeUnaryOperator_10848,axiom,
    ! [VarCurr] :
      ( ~ v131434(VarCurr)
    <=> v131387(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26297,axiom,
    ! [VarCurr] :
      ( v131428(VarCurr)
    <=> ( v131429(VarCurr)
        & v131433(VarCurr) ) ) ).

fof(writeUnaryOperator_10847,axiom,
    ! [VarCurr] :
      ( ~ v131433(VarCurr)
    <=> v15309(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26296,axiom,
    ! [VarCurr] :
      ( v131429(VarCurr)
    <=> ( v131430(VarCurr)
        & v131432(VarCurr) ) ) ).

fof(writeUnaryOperator_10846,axiom,
    ! [VarCurr] :
      ( ~ v131432(VarCurr)
    <=> v131385(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26295,axiom,
    ! [VarCurr] :
      ( v131430(VarCurr)
    <=> ( v131431(VarCurr)
        & v131383(VarCurr) ) ) ).

fof(writeUnaryOperator_10845,axiom,
    ! [VarCurr] :
      ( ~ v131431(VarCurr)
    <=> v15307(VarCurr) ) ).

fof(addAssignment_41272,axiom,
    ! [VarCurr] :
      ( v131422(VarCurr)
    <=> v11295(VarCurr) ) ).

fof(addAssignment_41271,axiom,
    ! [VarNext] :
      ( v15302(VarNext,bitIndex3)
    <=> v131406(VarNext,bitIndex2) ) ).

fof(addCaseBooleanConditionShiftedRanges1_117,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131407(VarNext)
       => ( ( v131406(VarNext,bitIndex19)
          <=> v15302(VarCurr,bitIndex20) )
          & ( v131406(VarNext,bitIndex18)
          <=> v15302(VarCurr,bitIndex19) )
          & ( v131406(VarNext,bitIndex17)
          <=> v15302(VarCurr,bitIndex18) )
          & ( v131406(VarNext,bitIndex16)
          <=> v15302(VarCurr,bitIndex17) )
          & ( v131406(VarNext,bitIndex15)
          <=> v15302(VarCurr,bitIndex16) )
          & ( v131406(VarNext,bitIndex14)
          <=> v15302(VarCurr,bitIndex15) )
          & ( v131406(VarNext,bitIndex13)
          <=> v15302(VarCurr,bitIndex14) )
          & ( v131406(VarNext,bitIndex12)
          <=> v15302(VarCurr,bitIndex13) )
          & ( v131406(VarNext,bitIndex11)
          <=> v15302(VarCurr,bitIndex12) )
          & ( v131406(VarNext,bitIndex10)
          <=> v15302(VarCurr,bitIndex11) )
          & ( v131406(VarNext,bitIndex9)
          <=> v15302(VarCurr,bitIndex10) )
          & ( v131406(VarNext,bitIndex8)
          <=> v15302(VarCurr,bitIndex9) )
          & ( v131406(VarNext,bitIndex7)
          <=> v15302(VarCurr,bitIndex8) )
          & ( v131406(VarNext,bitIndex6)
          <=> v15302(VarCurr,bitIndex7) )
          & ( v131406(VarNext,bitIndex5)
          <=> v15302(VarCurr,bitIndex6) )
          & ( v131406(VarNext,bitIndex4)
          <=> v15302(VarCurr,bitIndex5) )
          & ( v131406(VarNext,bitIndex3)
          <=> v15302(VarCurr,bitIndex4) )
          & ( v131406(VarNext,bitIndex2)
          <=> v15302(VarCurr,bitIndex3) )
          & ( v131406(VarNext,bitIndex1)
          <=> v15302(VarCurr,bitIndex2) )
          & ( v131406(VarNext,bitIndex0)
          <=> v15302(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2417,axiom,
    ! [VarNext] :
      ( v131407(VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131406(VarNext,B)
          <=> v131417(VarNext,B) ) ) ) ).

fof(addAssignment_41270,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_19_0(B)
         => ( v131417(VarNext,B)
          <=> v131415(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_498,axiom,
    ! [VarCurr] :
      ( ~ v131418(VarCurr)
     => ( ( v131415(VarCurr,bitIndex19)
        <=> v10094(VarCurr,bitIndex20) )
        & ( v131415(VarCurr,bitIndex18)
        <=> v10094(VarCurr,bitIndex19) )
        & ( v131415(VarCurr,bitIndex17)
        <=> v10094(VarCurr,bitIndex18) )
        & ( v131415(VarCurr,bitIndex16)
        <=> v10094(VarCurr,bitIndex17) )
        & ( v131415(VarCurr,bitIndex15)
        <=> v10094(VarCurr,bitIndex16) )
        & ( v131415(VarCurr,bitIndex14)
        <=> v10094(VarCurr,bitIndex15) )
        & ( v131415(VarCurr,bitIndex13)
        <=> v10094(VarCurr,bitIndex14) )
        & ( v131415(VarCurr,bitIndex12)
        <=> v10094(VarCurr,bitIndex13) )
        & ( v131415(VarCurr,bitIndex11)
        <=> v10094(VarCurr,bitIndex12) )
        & ( v131415(VarCurr,bitIndex10)
        <=> v10094(VarCurr,bitIndex11) )
        & ( v131415(VarCurr,bitIndex9)
        <=> v10094(VarCurr,bitIndex10) )
        & ( v131415(VarCurr,bitIndex8)
        <=> v10094(VarCurr,bitIndex9) )
        & ( v131415(VarCurr,bitIndex7)
        <=> v10094(VarCurr,bitIndex8) )
        & ( v131415(VarCurr,bitIndex6)
        <=> v10094(VarCurr,bitIndex7) )
        & ( v131415(VarCurr,bitIndex5)
        <=> v10094(VarCurr,bitIndex6) )
        & ( v131415(VarCurr,bitIndex4)
        <=> v10094(VarCurr,bitIndex5) )
        & ( v131415(VarCurr,bitIndex3)
        <=> v10094(VarCurr,bitIndex4) )
        & ( v131415(VarCurr,bitIndex2)
        <=> v10094(VarCurr,bitIndex3) )
        & ( v131415(VarCurr,bitIndex1)
        <=> v10094(VarCurr,bitIndex2) )
        & ( v131415(VarCurr,bitIndex0)
        <=> v10094(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2969,axiom,
    ! [VarCurr] :
      ( v131418(VarCurr)
     => ! [B] :
          ( range_19_0(B)
         => ( v131415(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_10844,axiom,
    ! [VarCurr] :
      ( ~ v131418(VarCurr)
    <=> v15304(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26294,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131407(VarNext)
      <=> v131408(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26293,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131408(VarNext)
      <=> ( v131409(VarNext)
          & v131402(VarNext) ) ) ) ).

fof(writeUnaryOperator_10843,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131409(VarNext)
      <=> v131411(VarNext) ) ) ).

fof(addAssignment_41269,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131411(VarNext)
      <=> v131402(VarCurr) ) ) ).

fof(addAssignmentInitValue_43,axiom,
    ~ v15302(constB0,bitIndex3) ).

fof(addAssignmentInitValue_42,axiom,
    ~ v15302(constB0,bitIndex2) ).

fof(addAssignmentInitValue_41,axiom,
    ~ v15302(constB0,bitIndex1) ).

fof(bitBlastConstant_12664,axiom,
    ~ bxxxxxxxxxxxxxxxxx000(bitIndex2) ).

fof(bitBlastConstant_12663,axiom,
    ~ bxxxxxxxxxxxxxxxxx000(bitIndex1) ).

fof(bitBlastConstant_12662,axiom,
    ~ bxxxxxxxxxxxxxxxxx000(bitIndex0) ).

fof(addAssignmentInitValueVector_36,axiom,
    ( v15302(constB0,bitIndex0)
  <=> $true ) ).

fof(addAssignment_41268,axiom,
    ! [VarCurr] :
      ( v131402(VarCurr)
    <=> v13235(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26292,axiom,
    ! [VarCurr] :
      ( v131395(VarCurr)
    <=> ( v131397(VarCurr)
        & v131399(VarCurr) ) ) ).

fof(writeUnaryOperator_10842,axiom,
    ! [VarCurr] :
      ( ~ v131399(VarCurr)
    <=> v131391(VarCurr) ) ).

fof(addAssignment_41267,axiom,
    ! [VarCurr] :
      ( v131397(VarCurr)
    <=> v114189(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26291,axiom,
    ! [VarCurr] :
      ( v131387(VarCurr)
    <=> ( v131389(VarCurr)
        & v131393(VarCurr) ) ) ).

fof(writeUnaryOperator_10841,axiom,
    ! [VarCurr] :
      ( ~ v131393(VarCurr)
    <=> v131391(VarCurr) ) ).

fof(addAssignment_41266,axiom,
    ! [VarCurr] :
      ( v131391(VarCurr)
    <=> v15290(VarCurr) ) ).

fof(addAssignment_41265,axiom,
    ! [VarCurr] :
      ( v131389(VarCurr)
    <=> v13219(VarCurr) ) ).

fof(addAssignment_41264,axiom,
    ! [VarCurr] :
      ( v131385(VarCurr)
    <=> v114229(VarCurr) ) ).

fof(addAssignment_41263,axiom,
    ! [VarCurr] :
      ( v131383(VarCurr)
    <=> v114211(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26290,axiom,
    ! [VarCurr] :
      ( v15309(VarCurr)
    <=> ( v15311(VarCurr)
        & v131381(VarCurr) ) ) ).

fof(writeUnaryOperator_10840,axiom,
    ! [VarCurr] :
      ( ~ v131381(VarCurr)
    <=> v15326(VarCurr) ) ).

fof(addAssignment_41262,axiom,
    ! [VarCurr] :
      ( v15326(VarCurr)
    <=> v15328(VarCurr) ) ).

fof(addAssignment_41261,axiom,
    ! [VarCurr] :
      ( v15328(VarCurr)
    <=> v15330(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9198,axiom,
    ! [VarCurr] :
      ( v15330(VarCurr)
    <=> ( ( v131379(VarCurr,bitIndex5)
        <=> v15389(VarCurr,bitIndex5) )
        & ( v131379(VarCurr,bitIndex4)
        <=> v15389(VarCurr,bitIndex4) )
        & ( v131379(VarCurr,bitIndex3)
        <=> v15389(VarCurr,bitIndex3) )
        & ( v131379(VarCurr,bitIndex2)
        <=> v15389(VarCurr,bitIndex2) )
        & ( v131379(VarCurr,bitIndex1)
        <=> v15389(VarCurr,bitIndex1) )
        & ( v131379(VarCurr,bitIndex0)
        <=> v15389(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_41260,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v131379(VarCurr,B)
      <=> v10080(VarCurr,B) ) ) ).

fof(addAssignment_41259,axiom,
    ! [VarCurr] :
      ( v131379(VarCurr,bitIndex5)
    <=> v15332(VarCurr) ) ).

fof(addAssignment_41258,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15389(VarCurr,B)
      <=> v15391(VarCurr,B) ) ) ).

fof(addAssignment_41257,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15391(VarCurr,B)
      <=> v15393(VarCurr,B) ) ) ).

fof(addAssignment_41256,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15393(VarCurr,B)
      <=> v15395(VarCurr,B) ) ) ).

fof(addAssignment_41255,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15395(VarCurr,B)
      <=> v15397(VarCurr,B) ) ) ).

fof(addAssignment_41254,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15397(VarCurr,B)
      <=> v15399(VarCurr,B) ) ) ).

fof(addAssignment_41253,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15399(VarCurr,B)
      <=> v15401(VarCurr,B) ) ) ).

fof(addAssignment_41252,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v15401(VarCurr,B)
      <=> v15403(VarCurr,B) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2315,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131328(VarNext)
       => ! [B] :
            ( range_5_0(B)
           => ( v15403(VarNext,B)
            <=> v15403(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2416,axiom,
    ! [VarNext] :
      ( v131328(VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v15403(VarNext,B)
          <=> v131344(VarNext,B) ) ) ) ).

fof(addAssignment_41251,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_5_0(B)
         => ( v131344(VarNext,B)
          <=> v131342(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5397,axiom,
    ! [VarCurr] :
      ( ~ v131339(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v131342(VarCurr,B)
          <=> v131345(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5385,axiom,
    ! [VarCurr] :
      ( v131339(VarCurr)
     => ! [B] :
          ( range_5_0(B)
         => ( v131342(VarCurr,B)
          <=> $false ) ) ) ).

fof(addAssignment_41250,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr,bitIndex0)
    <=> v131373(VarCurr) ) ).

fof(addAssignment_41249,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr,bitIndex1)
    <=> v131371(VarCurr) ) ).

fof(addAssignment_41248,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr,bitIndex2)
    <=> v131366(VarCurr) ) ).

fof(addAssignment_41247,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr,bitIndex3)
    <=> v131361(VarCurr) ) ).

fof(addAssignment_41246,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr,bitIndex4)
    <=> v131356(VarCurr) ) ).

fof(addAssignment_41245,axiom,
    ! [VarCurr] :
      ( v131345(VarCurr,bitIndex5)
    <=> v131347(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26289,axiom,
    ! [VarCurr] :
      ( v131371(VarCurr)
    <=> ( v131372(VarCurr)
        & v131375(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2598,axiom,
    ! [VarCurr] :
      ( v131375(VarCurr)
    <=> ( v15403(VarCurr,bitIndex0)
        | v15403(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26288,axiom,
    ! [VarCurr] :
      ( v131372(VarCurr)
    <=> ( v131373(VarCurr)
        | v131374(VarCurr) ) ) ).

fof(writeUnaryOperator_10839,axiom,
    ! [VarCurr] :
      ( ~ v131374(VarCurr)
    <=> v15403(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_10838,axiom,
    ! [VarCurr] :
      ( ~ v131373(VarCurr)
    <=> v15403(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26287,axiom,
    ! [VarCurr] :
      ( v131366(VarCurr)
    <=> ( v131367(VarCurr)
        & v131370(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2597,axiom,
    ! [VarCurr] :
      ( v131370(VarCurr)
    <=> ( v131353(VarCurr)
        | v15403(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26286,axiom,
    ! [VarCurr] :
      ( v131367(VarCurr)
    <=> ( v131368(VarCurr)
        | v131369(VarCurr) ) ) ).

fof(writeUnaryOperator_10837,axiom,
    ! [VarCurr] :
      ( ~ v131369(VarCurr)
    <=> v15403(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_10836,axiom,
    ! [VarCurr] :
      ( ~ v131368(VarCurr)
    <=> v131353(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26285,axiom,
    ! [VarCurr] :
      ( v131361(VarCurr)
    <=> ( v131362(VarCurr)
        & v131365(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2596,axiom,
    ! [VarCurr] :
      ( v131365(VarCurr)
    <=> ( v131352(VarCurr)
        | v15403(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26284,axiom,
    ! [VarCurr] :
      ( v131362(VarCurr)
    <=> ( v131363(VarCurr)
        | v131364(VarCurr) ) ) ).

fof(writeUnaryOperator_10835,axiom,
    ! [VarCurr] :
      ( ~ v131364(VarCurr)
    <=> v15403(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_10834,axiom,
    ! [VarCurr] :
      ( ~ v131363(VarCurr)
    <=> v131352(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26283,axiom,
    ! [VarCurr] :
      ( v131356(VarCurr)
    <=> ( v131357(VarCurr)
        & v131360(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2595,axiom,
    ! [VarCurr] :
      ( v131360(VarCurr)
    <=> ( v131351(VarCurr)
        | v15403(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26282,axiom,
    ! [VarCurr] :
      ( v131357(VarCurr)
    <=> ( v131358(VarCurr)
        | v131359(VarCurr) ) ) ).

fof(writeUnaryOperator_10833,axiom,
    ! [VarCurr] :
      ( ~ v131359(VarCurr)
    <=> v15403(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_10832,axiom,
    ! [VarCurr] :
      ( ~ v131358(VarCurr)
    <=> v131351(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26281,axiom,
    ! [VarCurr] :
      ( v131347(VarCurr)
    <=> ( v131348(VarCurr)
        & v131355(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2594,axiom,
    ! [VarCurr] :
      ( v131355(VarCurr)
    <=> ( v131350(VarCurr)
        | v15403(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26280,axiom,
    ! [VarCurr] :
      ( v131348(VarCurr)
    <=> ( v131349(VarCurr)
        | v131354(VarCurr) ) ) ).

fof(writeUnaryOperator_10831,axiom,
    ! [VarCurr] :
      ( ~ v131354(VarCurr)
    <=> v15403(VarCurr,bitIndex5) ) ).

fof(writeUnaryOperator_10830,axiom,
    ! [VarCurr] :
      ( ~ v131349(VarCurr)
    <=> v131350(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_2593,axiom,
    ! [VarCurr] :
      ( v131350(VarCurr)
    <=> ( v131351(VarCurr)
        & v15403(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2592,axiom,
    ! [VarCurr] :
      ( v131351(VarCurr)
    <=> ( v131352(VarCurr)
        & v15403(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2591,axiom,
    ! [VarCurr] :
      ( v131352(VarCurr)
    <=> ( v131353(VarCurr)
        & v15403(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2590,axiom,
    ! [VarCurr] :
      ( v131353(VarCurr)
    <=> ( v15403(VarCurr,bitIndex0)
        & v15403(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26279,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131328(VarNext)
      <=> ( v131329(VarNext)
          & v131338(VarNext) ) ) ) ).

fof(addAssignment_41244,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131338(VarNext)
      <=> v131336(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26278,axiom,
    ! [VarCurr] :
      ( v131336(VarCurr)
    <=> ( v131339(VarCurr)
        | v131340(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26277,axiom,
    ! [VarCurr] :
      ( v131340(VarCurr)
    <=> ( v15407(VarCurr)
        & v131341(VarCurr) ) ) ).

fof(writeUnaryOperator_10829,axiom,
    ! [VarCurr] :
      ( ~ v131341(VarCurr)
    <=> v131339(VarCurr) ) ).

fof(writeUnaryOperator_10828,axiom,
    ! [VarCurr] :
      ( ~ v131339(VarCurr)
    <=> v15405(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26276,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131329(VarNext)
      <=> ( v131330(VarNext)
          & v131325(VarNext) ) ) ) ).

fof(writeUnaryOperator_10827,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131330(VarNext)
      <=> v131332(VarNext) ) ) ).

fof(addAssignment_41243,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131332(VarNext)
      <=> v131325(VarCurr) ) ) ).

fof(addAssignmentInitValue_40,axiom,
    ~ v15403(constB0,bitIndex5) ).

fof(addAssignmentInitValue_39,axiom,
    ~ v15403(constB0,bitIndex4) ).

fof(addAssignmentInitValue_38,axiom,
    ~ v15403(constB0,bitIndex3) ).

fof(addAssignmentInitValue_37,axiom,
    ~ v15403(constB0,bitIndex2) ).

fof(addAssignmentInitValue_36,axiom,
    ~ v15403(constB0,bitIndex1) ).

fof(addAssignmentInitValue_35,axiom,
    v15403(constB0,bitIndex0) ).

fof(addAssignment_41242,axiom,
    ! [VarCurr] :
      ( v131325(VarCurr)
    <=> v190(VarCurr) ) ).

fof(addAssignment_41241,axiom,
    ! [VarCurr] :
      ( v15407(VarCurr)
    <=> v15409(VarCurr) ) ).

fof(addAssignment_41240,axiom,
    ! [VarCurr] :
      ( v15409(VarCurr)
    <=> v15411(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26275,axiom,
    ! [VarCurr] :
      ( v15411(VarCurr)
    <=> ( v131323(VarCurr)
        & v131320(VarCurr) ) ) ).

fof(writeUnaryOperator_10826,axiom,
    ! [VarCurr] :
      ( ~ v131323(VarCurr)
    <=> v15413(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9197,axiom,
    ! [VarCurr] :
      ( v131320(VarCurr)
    <=> ( ( v129443(VarCurr,bitIndex1)
        <=> $true )
        & ( v129443(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2314,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131303(VarNext)
       => ( v15413(VarNext)
        <=> v15413(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2415,axiom,
    ! [VarNext] :
      ( v131303(VarNext)
     => ( v15413(VarNext)
      <=> v131316(VarNext) ) ) ).

fof(addAssignment_41239,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131316(VarNext)
      <=> v131314(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5396,axiom,
    ! [VarCurr] :
      ( ~ v129433(VarCurr)
     => ( v131314(VarCurr)
      <=> v129796(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5384,axiom,
    ! [VarCurr] :
      ( v129433(VarCurr)
     => ( v131314(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26274,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131303(VarNext)
      <=> ( v131304(VarNext)
          & v131311(VarNext) ) ) ) ).

fof(addAssignment_41238,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131311(VarNext)
      <=> v131309(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26273,axiom,
    ! [VarCurr] :
      ( v131309(VarCurr)
    <=> ( v129433(VarCurr)
        | v131312(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26272,axiom,
    ! [VarCurr] :
      ( v131312(VarCurr)
    <=> ( v15417(VarCurr)
        & v131313(VarCurr) ) ) ).

fof(writeUnaryOperator_10825,axiom,
    ! [VarCurr] :
      ( ~ v131313(VarCurr)
    <=> v129433(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26271,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131304(VarNext)
      <=> ( v131306(VarNext)
          & v129419(VarNext) ) ) ) ).

fof(writeUnaryOperator_10824,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131306(VarNext)
      <=> v129426(VarNext) ) ) ).

fof(addAssignment_41237,axiom,
    ! [VarCurr] :
      ( v15417(VarCurr)
    <=> v15419(VarCurr) ) ).

fof(addAssignment_41236,axiom,
    ! [VarCurr] :
      ( v15419(VarCurr)
    <=> v15421(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26270,axiom,
    ! [VarCurr] :
      ( v15421(VarCurr)
    <=> ( v131296(VarCurr)
        | v131299(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_2589,axiom,
    ! [VarCurr] :
      ( v131299(VarCurr)
    <=> ( v121(VarCurr,bitIndex2)
        & v131300(VarCurr) ) ) ).

fof(writeUnaryOperator_10823,axiom,
    ! [VarCurr] :
      ( ~ v131300(VarCurr)
    <=> v112(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26269,axiom,
    ! [VarCurr] :
      ( v131296(VarCurr)
    <=> ( v131297(VarCurr)
        & v131298(VarCurr) ) ) ).

fof(writeUnaryOperator_10822,axiom,
    ! [VarCurr] :
      ( ~ v131298(VarCurr)
    <=> v112(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_2588,axiom,
    ! [VarCurr] :
      ( v131297(VarCurr)
    <=> ( v15423(VarCurr)
        & v121(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_41235,axiom,
    ! [VarNext] :
      ( v112(VarNext,bitIndex2)
    <=> v131283(VarNext,bitIndex1) ) ).

fof(addCaseBooleanConditionShiftedRanges1_116,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131284(VarNext)
       => ( ( v131283(VarNext,bitIndex1)
          <=> v112(VarCurr,bitIndex2) )
          & ( v131283(VarNext,bitIndex0)
          <=> v112(VarCurr,bitIndex1) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2414,axiom,
    ! [VarNext] :
      ( v131284(VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v131283(VarNext,B)
          <=> v131292(VarNext,B) ) ) ) ).

fof(addAssignment_41234,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_1_0(B)
         => ( v131292(VarNext,B)
          <=> v131290(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_497,axiom,
    ! [VarCurr] :
      ( ~ v131267(VarCurr)
     => ( ( v131290(VarCurr,bitIndex1)
        <=> v121(VarCurr,bitIndex2) )
        & ( v131290(VarCurr,bitIndex0)
        <=> v121(VarCurr,bitIndex1) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2968,axiom,
    ! [VarCurr] :
      ( v131267(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v131290(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26268,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131284(VarNext)
      <=> v131285(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26267,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131285(VarNext)
      <=> ( v131287(VarNext)
          & v131200(VarNext) ) ) ) ).

fof(writeUnaryOperator_10821,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131287(VarNext)
      <=> v131207(VarNext) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_496,axiom,
    ! [VarCurr] :
      ( ~ v131271(VarCurr)
     => ( v121(VarCurr,bitIndex2)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch_693,axiom,
    ! [VarCurr] :
      ( v131271(VarCurr)
     => ( v121(VarCurr,bitIndex2)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26266,axiom,
    ! [VarCurr] :
      ( v131271(VarCurr)
    <=> ( v131272(VarCurr)
        | v131278(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26265,axiom,
    ! [VarCurr] :
      ( v131278(VarCurr)
    <=> ( v131279(VarCurr)
        & v131280(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26264,axiom,
    ! [VarCurr] :
      ( v131280(VarCurr)
    <=> ( v15451(VarCurr)
        & v131281(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9196,axiom,
    ! [VarCurr] :
      ( v131281(VarCurr)
    <=> ( $true
      <=> v112(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_10820,axiom,
    ! [VarCurr] :
      ( ~ v131279(VarCurr)
    <=> v131253(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26263,axiom,
    ! [VarCurr] :
      ( v131272(VarCurr)
    <=> ( v131273(VarCurr)
        & v131253(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26262,axiom,
    ! [VarCurr] :
      ( v131273(VarCurr)
    <=> ( v131275(VarCurr)
        & v131242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26261,axiom,
    ! [VarCurr] :
      ( v131275(VarCurr)
    <=> ( v131276(VarCurr)
        & v15423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26260,axiom,
    ! [VarCurr] :
      ( v131276(VarCurr)
    <=> ( v131241(VarCurr)
        & v131277(VarCurr) ) ) ).

fof(writeUnaryOperator_10819,axiom,
    ! [VarCurr] :
      ( ~ v131277(VarCurr)
    <=> v129373(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2313,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131258(VarNext)
       => ( v112(VarNext,bitIndex0)
        <=> v112(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2413,axiom,
    ! [VarNext] :
      ( v131258(VarNext)
     => ( v112(VarNext,bitIndex0)
      <=> v131266(VarNext) ) ) ).

fof(addAssignment_41233,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131266(VarNext)
      <=> v131264(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3164,axiom,
    ! [VarCurr] :
      ( ~ v131267(VarCurr)
     => ( v131264(VarCurr)
      <=> v121(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2967,axiom,
    ! [VarCurr] :
      ( v131267(VarCurr)
     => ( v131264(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_10818,axiom,
    ! [VarCurr] :
      ( ~ v131267(VarCurr)
    <=> v114(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26259,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131258(VarNext)
      <=> v131259(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26258,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131259(VarNext)
      <=> ( v131260(VarNext)
          & v131200(VarNext) ) ) ) ).

fof(writeUnaryOperator_10817,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131260(VarNext)
      <=> v131207(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3163,axiom,
    ! [VarCurr] :
      ( ~ v131228(VarCurr)
     => ( v121(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2966,axiom,
    ! [VarCurr] :
      ( v131228(VarCurr)
     => ( v121(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26257,axiom,
    ! [VarCurr] :
      ( v131228(VarCurr)
    <=> ( v131229(VarCurr)
        & v131253(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26256,axiom,
    ! [VarCurr] :
      ( v131253(VarCurr)
    <=> ( v131254(VarCurr)
        | v131255(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_9195,axiom,
    ! [VarCurr] :
      ( v131255(VarCurr)
    <=> ( $true
      <=> v112(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_9194,axiom,
    ! [VarCurr] :
      ( v131254(VarCurr)
    <=> ( $true
      <=> v112(VarCurr,bitIndex0) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26255,axiom,
    ! [VarCurr] :
      ( v131229(VarCurr)
    <=> ( v131230(VarCurr)
        | v131247(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26254,axiom,
    ! [VarCurr] :
      ( v131247(VarCurr)
    <=> ( v131249(VarCurr)
        & v131242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26253,axiom,
    ! [VarCurr] :
      ( v131249(VarCurr)
    <=> ( v131250(VarCurr)
        & v15423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26252,axiom,
    ! [VarCurr] :
      ( v131250(VarCurr)
    <=> ( v131251(VarCurr)
        & v129373(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26251,axiom,
    ! [VarCurr] :
      ( v131251(VarCurr)
    <=> ( v131252(VarCurr)
        & v131236(VarCurr) ) ) ).

fof(writeUnaryOperator_10816,axiom,
    ! [VarCurr] :
      ( ~ v131252(VarCurr)
    <=> v15451(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26250,axiom,
    ! [VarCurr] :
      ( v131230(VarCurr)
    <=> ( v131231(VarCurr)
        | v131243(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26249,axiom,
    ! [VarCurr] :
      ( v131243(VarCurr)
    <=> ( v131245(VarCurr)
        & v131242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26248,axiom,
    ! [VarCurr] :
      ( v131245(VarCurr)
    <=> ( v131241(VarCurr)
        & v131246(VarCurr) ) ) ).

fof(writeUnaryOperator_10815,axiom,
    ! [VarCurr] :
      ( ~ v131246(VarCurr)
    <=> v15423(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26247,axiom,
    ! [VarCurr] :
      ( v131231(VarCurr)
    <=> ( v131232(VarCurr)
        | v131237(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26246,axiom,
    ! [VarCurr] :
      ( v131237(VarCurr)
    <=> ( v131239(VarCurr)
        & v131242(VarCurr) ) ) ).

fof(writeUnaryOperator_10814,axiom,
    ! [VarCurr] :
      ( ~ v131242(VarCurr)
    <=> v235(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26245,axiom,
    ! [VarCurr] :
      ( v131239(VarCurr)
    <=> ( v131240(VarCurr)
        & v15423(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26244,axiom,
    ! [VarCurr] :
      ( v131240(VarCurr)
    <=> ( v131241(VarCurr)
        & v129373(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26243,axiom,
    ! [VarCurr] :
      ( v131241(VarCurr)
    <=> ( v15451(VarCurr)
        & v131236(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26242,axiom,
    ! [VarCurr] :
      ( v131232(VarCurr)
    <=> ( v131233(VarCurr)
        | v131234(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26241,axiom,
    ! [VarCurr] :
      ( v131234(VarCurr)
    <=> ( v131236(VarCurr)
        & v235(VarCurr) ) ) ).

fof(writeUnaryOperator_10813,axiom,
    ! [VarCurr] :
      ( ~ v131236(VarCurr)
    <=> v123(VarCurr) ) ).

fof(addAssignment_41232,axiom,
    ! [VarCurr] :
      ( v131233(VarCurr)
    <=> v123(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2312,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131203(VarNext)
       => ( v129373(VarNext)
        <=> v129373(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2412,axiom,
    ! [VarNext] :
      ( v131203(VarNext)
     => ( v129373(VarNext)
      <=> v131220(VarNext) ) ) ).

fof(addAssignment_41231,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131220(VarNext)
      <=> v131218(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5395,axiom,
    ! [VarCurr] :
      ( ~ v131214(VarCurr)
     => ( v131218(VarCurr)
      <=> v131221(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5383,axiom,
    ! [VarCurr] :
      ( v131214(VarCurr)
     => ( v131218(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3162,axiom,
    ! [VarCurr] :
      ( ~ v15421(VarCurr)
     => ( v131221(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2965,axiom,
    ! [VarCurr] :
      ( v15421(VarCurr)
     => ( v131221(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26240,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131203(VarNext)
      <=> ( v131204(VarNext)
          & v131213(VarNext) ) ) ) ).

fof(addAssignment_41230,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131213(VarNext)
      <=> v131211(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26239,axiom,
    ! [VarCurr] :
      ( v131211(VarCurr)
    <=> ( v131214(VarCurr)
        | v131215(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26238,axiom,
    ! [VarCurr] :
      ( v131215(VarCurr)
    <=> ( v131216(VarCurr)
        & v131217(VarCurr) ) ) ).

fof(writeUnaryOperator_10812,axiom,
    ! [VarCurr] :
      ( ~ v131217(VarCurr)
    <=> v131214(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26237,axiom,
    ! [VarCurr] :
      ( v131216(VarCurr)
    <=> ( v15421(VarCurr)
      <~> v129375(VarCurr) ) ) ).

fof(writeUnaryOperator_10811,axiom,
    ! [VarCurr] :
      ( ~ v131214(VarCurr)
    <=> v114(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26236,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131204(VarNext)
      <=> ( v131205(VarNext)
          & v131200(VarNext) ) ) ) ).

fof(writeUnaryOperator_10810,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v131205(VarNext)
      <=> v131207(VarNext) ) ) ).

fof(addAssignment_41229,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v131207(VarNext)
      <=> v131200(VarCurr) ) ) ).

fof(addAssignment_41228,axiom,
    ! [VarCurr] :
      ( v131200(VarCurr)
    <=> v190(VarCurr) ) ).

fof(addAssignment_41227,axiom,
    ! [VarCurr] :
      ( v129375(VarCurr)
    <=> v129377(VarCurr) ) ).

fof(addAssignment_41226,axiom,
    ! [VarCurr] :
      ( v129377(VarCurr)
    <=> v129379(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3161,axiom,
    ! [VarCurr] :
      ( ~ v131150(VarCurr)
     => ( v129379(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2964,axiom,
    ! [VarCurr] :
      ( v131150(VarCurr)
     => ( v129379(VarCurr)
      <=> v131188(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges6_8,axiom,
    ! [VarCurr] :
      ( ( ~ v131156(VarCurr)
        & ~ v131157(VarCurr)
        & ~ v131160(VarCurr)
        & ~ v131163(VarCurr)
        & ~ v131166(VarCurr)
        & ~ v131171(VarCurr)
        & v131179(VarCurr) )
     => ( v131188(VarCurr)
      <=> v131198(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges5_9,axiom,
    ! [VarCurr] :
      ( ( ~ v131156(VarCurr)
        & ~ v131157(VarCurr)
        & ~ v131160(VarCurr)
        & ~ v131163(VarCurr)
        & ~ v131166(VarCurr)
        & v131171(VarCurr) )
     => ( v131188(VarCurr)
      <=> v131197(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges4_7,axiom,
    ! [VarCurr] :
      ( ( ~ v131156(VarCurr)
        & ~ v131157(VarCurr)
        & ~ v131160(VarCurr)
        & ~ v131163(VarCurr)
        & v131166(VarCurr) )
     => ( v131188(VarCurr)
      <=> v131126(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges3_10,axiom,
    ! [VarCurr] :
      ( ( ~ v131156(VarCurr)
        & ~ v131157(VarCurr)
        & ~ v131160(VarCurr)
        & v131163(VarCurr) )
     => ( v131188(VarCurr)
      <=> v131189(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges2_15,axiom,
    ! [VarCurr] :
      ( ( ~ v131156(VarCurr)
        & ~ v131157(VarCurr)
        & v131160(VarCurr) )
     => ( v131188(VarCurr)
      <=> v131126(VarCurr) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_2311,axiom,
    ! [VarCurr] :
      ( ( ~ v131156(VarCurr)
        & v131157(VarCurr) )
     => ( v131188(VarCurr)
      <=> $true ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2411,axiom,
    ! [VarCurr] :
      ( v131156(VarCurr)
     => ( v131188(VarCurr)
      <=> v130159(VarCurr,bitIndex0) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5394,axiom,
    ! [VarCurr] :
      ( ~ v15417(VarCurr)
     => ( v131198(VarCurr)
      <=> v131126(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5382,axiom,
    ! [VarCurr] :
      ( v15417(VarCurr)
     => ( v131198(VarCurr)
      <=> v130204(VarCurr,bitIndex0) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5393,axiom,
    ! [VarCurr] :
      ( ~ v15417(VarCurr)
     => ( v131197(VarCurr)
      <=> v131126(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5381,axiom,
    ! [VarCurr] :
      ( v15417(VarCurr)
     => ( v131197(VarCurr)
      <=> v130189(VarCurr,bitIndex0) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3160,axiom,
    ! [VarCurr] :
      ( ~ v15417(VarCurr)
     => ( v131189(VarCurr)
      <=> v131190(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2963,axiom,
    ! [VarCurr] :
      ( v15417(VarCurr)
     => ( v131189(VarCurr)
      <=> v130174(VarCurr,bitIndex0) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3159,axiom,
    ! [VarCurr] :
      ( ~ v131191(VarCurr)
     => ( v131190(VarCurr)
      <=> v131126(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2962,axiom,
    ! [VarCurr] :
      ( v131191(VarCurr)
     => ( v131190(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26235,axiom,
    ! [VarCurr] :
      ( v131191(VarCurr)
    <=> ( v131192(VarCurr)
        & v131196(VarCurr) ) ) ).

fof(writeUnaryOperator_10809,axiom,
    ! [VarCurr] :
      ( ~ v131196(VarCurr)
    <=> v130236(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26234,axiom,
    ! [VarCurr] :
      ( v131192(VarCurr)
    <=> ( v131193(VarCurr)
        & v131195(VarCurr) ) ) ).

fof(writeUnaryOperator_10808,axiom,
    ! [VarCurr] :
      ( ~ v131195(VarCurr)
    <=> v129453(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26233,axiom,
    ! [VarCurr] :
      ( v131193(VarCurr)
    <=> ( v129798(VarCurr)
        & v131194(VarCurr) ) ) ).

fof(writeUnaryOperator_10807,axiom,
    ! [VarCurr] :
      ( ~ v131194(VarCurr)
    <=> v130232(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26232,axiom,
    ! [VarCurr] :
      ( v131150(VarCurr)
    <=> ( v131151(VarCurr)
        | v131179(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26231,axiom,
    ! [VarCurr] :
      ( v131179(VarCurr)
    <=> ( v131180(VarCurr)
        & v131184(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26230,axiom,
    ! [VarCurr] :
      ( v131184(VarCurr)
    <=> ( v131185(VarCurr)
        & v130265(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26229,axiom,
    ! [VarCurr] :
      ( v131185(VarCurr)
    <=> ( v15417(VarCurr)
        | v131186(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26228,axiom,
    ! [VarCurr] :
      ( v131186(VarCurr)
    <=> ( v129792(VarCurr)
        & v131187(VarCurr) ) ) ).

fof(writeUnaryOperator_10806,axiom,
    ! [VarCurr] :
      ( ~ v131187(VarCurr)
    <=> v15417(VarCurr) ) ).

fof(writeUnaryOperator_10805,axiom,
    ! [VarCurr] :
      ( ~ v131180(VarCurr)
    <=> v131181(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26227,axiom,
    ! [VarCurr] :
      ( v131181(VarCurr)
    <=> ( v131182(VarCurr)
        | v130252(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26226,axiom,
    ! [VarCurr] :
      ( v131182(VarCurr)
    <=> ( v131183(VarCurr)
        | v130255(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26225,axiom,
    ! [VarCurr] :
      ( v131183(VarCurr)
    <=> ( v130223(VarCurr)
        | v130242(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26224,axiom,
    ! [VarCurr] :
      ( v131151(VarCurr)
    <=> ( v131152(VarCurr)
        | v131171(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26223,axiom,
    ! [VarCurr] :
      ( v131171(VarCurr)
    <=> ( v131172(VarCurr)
        & v131175(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26222,axiom,
    ! [VarCurr] :
      ( v131175(VarCurr)
    <=> ( v131176(VarCurr)
        & v130252(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26221,axiom,
    ! [VarCurr] :
      ( v131176(VarCurr)
    <=> ( v15417(VarCurr)
        | v131177(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26220,axiom,
    ! [VarCurr] :
      ( v131177(