%------------------------------------------------------------------------------
% File     : HWV087+1 : TPTP v9.2.0. Released v6.1.0.
% Domain   : Hardware Verification
% Problem  : dmu_dmc property 3 cone of influence 5_b20
% Version  : Especial.
% English  : Verification of a property of the SPARCT2 RTL hardware design.

% Refs     : [Kha14] Khasidashvili (2014), Email to Geoff Sutcliffe
% Source   : [Kha14]
% Names    : dmu_dmc_prop3_cone5_b20 [Kha14]

% Status   : CounterSatisfiable
% Rating   : 0.00 v6.3.0, 0.25 v6.2.0, 0.67 v6.1.0
% Syntax   : Number of formulae    : 1105 ( 227 unt;   0 def)
%            Number of atoms       : 3802 ( 228 equ)
%            Maximal formula atoms :  248 (   3 avg)
%            Number of connectives : 3073 ( 376   ~; 331   |; 633   &)
%                                         (1418 <=>; 315  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  128 (   4 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :  663 ( 660 usr;   2 prp; 0-2 aty)
%            Number of functors    :  398 ( 398 usr; 398 con; 0-0 aty)
%            Number of variables   : 1034 (1034   !;   0   ?)
% SPC      : FOF_CSA_RFO_SEQ

% Comments : Copyright 2013 Moshe Emmer and Zurab Khasidashvili
%            Licensed under the Apache License, Version 2.0 (the "License");
%            you may not use this file except in compliance with the License.
%            You may obtain a copy of the License at
%                http://www.apache.org/licenses/LICENSE-2.0
%            Unless required by applicable law or agreed to in writing,
%            software distributed under the License is distributed on an "AS
%            IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
%            express or implied. See the License for the specific language
%            governing permissions and limitations under the License.
%------------------------------------------------------------------------------
fof(pathAxiom_8,axiom,
    nextState(constB8,constB9) ).

fof(pathAxiom_7,axiom,
    nextState(constB7,constB8) ).

fof(pathAxiom_6,axiom,
    nextState(constB6,constB7) ).

fof(pathAxiom_5,axiom,
    nextState(constB5,constB6) ).

fof(pathAxiom_4,axiom,
    nextState(constB4,constB5) ).

fof(pathAxiom_3,axiom,
    nextState(constB3,constB4) ).

fof(pathAxiom_2,axiom,
    nextState(constB2,constB3) ).

fof(pathAxiom_1,axiom,
    nextState(constB1,constB2) ).

fof(pathAxiom,axiom,
    nextState(constB0,constB1) ).

fof(reachableStateAxiom_22,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( reachableState(VarCurr)
        & reachableState(VarNext) ) ) ).

fof(reachableStateAxiom_21,axiom,
    ! [VarState] :
      ( reachableState(VarState)
     => ( constB0 = VarState
        | constB1 = VarState
        | constB2 = VarState
        | constB3 = VarState
        | constB4 = VarState
        | constB5 = VarState
        | constB6 = VarState
        | constB7 = VarState
        | constB8 = VarState
        | constB9 = VarState
        | constB10 = VarState
        | constB11 = VarState
        | constB12 = VarState
        | constB13 = VarState
        | constB14 = VarState
        | constB15 = VarState
        | constB16 = VarState
        | constB17 = VarState
        | constB18 = VarState
        | constB19 = VarState
        | constB20 = VarState ) ) ).

fof(reachableStateAxiom_20,axiom,
    reachableState(constB20) ).

fof(reachableStateAxiom_19,axiom,
    reachableState(constB19) ).

fof(reachableStateAxiom_18,axiom,
    reachableState(constB18) ).

fof(reachableStateAxiom_17,axiom,
    reachableState(constB17) ).

fof(reachableStateAxiom_16,axiom,
    reachableState(constB16) ).

fof(reachableStateAxiom_15,axiom,
    reachableState(constB15) ).

fof(reachableStateAxiom_14,axiom,
    reachableState(constB14) ).

fof(reachableStateAxiom_13,axiom,
    reachableState(constB13) ).

fof(reachableStateAxiom_12,axiom,
    reachableState(constB12) ).

fof(reachableStateAxiom_11,axiom,
    reachableState(constB11) ).

fof(reachableStateAxiom_10,axiom,
    reachableState(constB10) ).

fof(reachableStateAxiom_9,axiom,
    reachableState(constB9) ).

fof(reachableStateAxiom_8,axiom,
    reachableState(constB8) ).

fof(reachableStateAxiom_7,axiom,
    reachableState(constB7) ).

fof(reachableStateAxiom_6,axiom,
    reachableState(constB6) ).

fof(reachableStateAxiom_5,axiom,
    reachableState(constB5) ).

fof(reachableStateAxiom_4,axiom,
    reachableState(constB4) ).

fof(reachableStateAxiom_3,axiom,
    reachableState(constB3) ).

fof(reachableStateAxiom_2,axiom,
    reachableState(constB2) ).

fof(reachableStateAxiom_1,axiom,
    reachableState(constB1) ).

fof(reachableStateAxiom,axiom,
    reachableState(constB0) ).

fof(clock_toggling,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v1(VarCurr)
      <=> ~ v1(VarNext) ) ) ).

fof(clock_pattern,axiom,
    ~ v1(constB0) ).

fof(addAssertion,conjecture,
    ! [VarCurr] :
      ( reachableState(VarCurr)
     => v4(VarCurr) ) ).

fof(writeUnaryOperator_104,axiom,
    ! [VarCurr] :
      ( ~ v4(VarCurr)
    <=> v953(VarCurr) ) ).

fof(writeUnaryOperator_103,axiom,
    ! [VarCurr] :
      ( ~ v953(VarCurr)
    <=> v954(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_161,axiom,
    ! [VarCurr] :
      ( v954(VarCurr)
    <=> ( v956(VarCurr)
        & v958(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_70,axiom,
    ! [VarCurr] :
      ( v958(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        | v6(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_102,axiom,
    ! [VarCurr] :
      ( ~ v956(VarCurr)
    <=> v957(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_69,axiom,
    ! [VarCurr] :
      ( v957(VarCurr)
    <=> ( v6(VarCurr,bitIndex0)
        & v6(VarCurr,bitIndex1) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v941(VarNext)
       => ( v6(VarNext,bitIndex1)
        <=> v6(VarCurr,bitIndex1) ) ) ) ).

fof(addCaseBooleanConditionShiftedRanges0,axiom,
    ! [VarNext] :
      ( v941(VarNext)
     => ( v6(VarNext,bitIndex1)
      <=> v949(VarNext) ) ) ).

fof(addAssignment_237,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v949(VarNext)
      <=> v947(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch_1,axiom,
    ! [VarCurr] :
      ( ~ v936(VarCurr)
     => ( v947(VarCurr)
      <=> v19(VarCurr,bitIndex1) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_41,axiom,
    ! [VarCurr] :
      ( v936(VarCurr)
     => ( v947(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_160,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v941(VarNext)
      <=> v942(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_159,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v942(VarNext)
      <=> ( v944(VarNext)
          & v788(VarNext) ) ) ) ).

fof(writeUnaryOperator_101,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v944(VarNext)
      <=> v929(VarNext) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v925(VarNext)
       => ( v6(VarNext,bitIndex0)
        <=> v6(VarCurr,bitIndex0) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarNext] :
      ( v925(VarNext)
     => ( v6(VarNext,bitIndex0)
      <=> v935(VarNext) ) ) ).

fof(addAssignment_236,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v935(VarNext)
      <=> v933(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_40,axiom,
    ! [VarCurr] :
      ( ~ v936(VarCurr)
     => ( v933(VarCurr)
      <=> v19(VarCurr,bitIndex0) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_40,axiom,
    ! [VarCurr] :
      ( v936(VarCurr)
     => ( v933(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_100,axiom,
    ! [VarCurr] :
      ( ~ v936(VarCurr)
    <=> v8(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_158,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v925(VarNext)
      <=> v926(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_157,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v926(VarNext)
      <=> ( v927(VarNext)
          & v788(VarNext) ) ) ) ).

fof(writeUnaryOperator_99,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v927(VarNext)
      <=> v929(VarNext) ) ) ).

fof(addAssignment_235,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v929(VarNext)
      <=> v788(VarCurr) ) ) ).

fof(addConditionBooleanCondShiftedRangesElseBranch,axiom,
    ! [VarCurr] :
      ( ~ v917(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addConditionBooleanCondShiftedRangesThenBranch,axiom,
    ! [VarCurr] :
      ( v917(VarCurr)
     => ( v19(VarCurr,bitIndex1)
      <=> v921(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_17,axiom,
    ! [VarCurr] :
      ( ~ v918(VarCurr)
     => ( v921(VarCurr)
      <=> v922(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_16,axiom,
    ! [VarCurr] :
      ( v918(VarCurr)
     => ( v921(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_39,axiom,
    ! [VarCurr] :
      ( ~ v705(VarCurr)
     => ( v922(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_39,axiom,
    ! [VarCurr] :
      ( v705(VarCurr)
     => ( v922(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_156,axiom,
    ! [VarCurr] :
      ( v917(VarCurr)
    <=> ( v918(VarCurr)
        | v919(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_155,axiom,
    ! [VarCurr] :
      ( v919(VarCurr)
    <=> ( v920(VarCurr)
        & v696(VarCurr) ) ) ).

fof(writeUnaryOperator_98,axiom,
    ! [VarCurr] :
      ( ~ v920(VarCurr)
    <=> v703(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_154,axiom,
    ! [VarCurr] :
      ( v918(VarCurr)
    <=> ( v699(VarCurr)
        & v695(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_38,axiom,
    ! [VarCurr] :
      ( ~ v910(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_38,axiom,
    ! [VarCurr] :
      ( v910(VarCurr)
     => ( v19(VarCurr,bitIndex0)
      <=> v914(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_16,axiom,
    ! [VarCurr] :
      ( ~ v911(VarCurr)
     => ( v914(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_15,axiom,
    ! [VarCurr] :
      ( v911(VarCurr)
     => ( v914(VarCurr)
      <=> v915(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_37,axiom,
    ! [VarCurr] :
      ( ~ v701(VarCurr)
     => ( v915(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_37,axiom,
    ! [VarCurr] :
      ( v701(VarCurr)
     => ( v915(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_153,axiom,
    ! [VarCurr] :
      ( v910(VarCurr)
    <=> ( v911(VarCurr)
        | v913(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_152,axiom,
    ! [VarCurr] :
      ( v913(VarCurr)
    <=> ( v703(VarCurr)
        & v696(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_151,axiom,
    ! [VarCurr] :
      ( v911(VarCurr)
    <=> ( v912(VarCurr)
        & v695(VarCurr) ) ) ).

fof(writeUnaryOperator_97,axiom,
    ! [VarCurr] :
      ( ~ v912(VarCurr)
    <=> v699(VarCurr) ) ).

fof(addAssignment_234,axiom,
    ! [VarCurr] :
      ( v21(VarCurr)
    <=> v23(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_46,axiom,
    ! [VarCurr] :
      ( v23(VarCurr)
    <=> ( ( v25(VarCurr,bitIndex4)
        <=> $false )
        & ( v25(VarCurr,bitIndex3)
        <=> $false )
        & ( v25(VarCurr,bitIndex2)
        <=> $false )
        & ( v25(VarCurr,bitIndex1)
        <=> $false )
        & ( v25(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v894(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v25(VarNext,B)
            <=> v25(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarNext] :
      ( v894(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v25(VarNext,B)
          <=> v904(VarNext,B) ) ) ) ).

fof(addAssignment_233,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v904(VarNext,B)
          <=> v902(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_36,axiom,
    ! [VarCurr] :
      ( ~ v905(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v902(VarCurr,B)
          <=> v30(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_36,axiom,
    ! [VarCurr] :
      ( v905(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v902(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_96,axiom,
    ! [VarCurr] :
      ( ~ v905(VarCurr)
    <=> v27(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_150,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v894(VarNext)
      <=> v895(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_149,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v895(VarNext)
      <=> ( v896(VarNext)
          & v891(VarNext) ) ) ) ).

fof(writeUnaryOperator_95,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v896(VarNext)
      <=> v898(VarNext) ) ) ).

fof(addAssignment_232,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v898(VarNext)
      <=> v891(VarCurr) ) ) ).

fof(addAssignment_231,axiom,
    ! [VarCurr] :
      ( v891(VarCurr)
    <=> v788(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_4,axiom,
    ! [VarCurr] :
      ( ( ~ v816(VarCurr)
        & ~ v818(VarCurr)
        & ~ v859(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v25(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_7,axiom,
    ! [VarCurr] :
      ( v859(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v861(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_15,axiom,
    ! [VarCurr] :
      ( v818(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v820(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_14,axiom,
    ! [VarCurr] :
      ( v816(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v30(VarCurr,B)
          <=> v25(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_45,axiom,
    ! [VarCurr] :
      ( v888(VarCurr)
    <=> ( ( v889(VarCurr,bitIndex1)
        <=> $true )
        & ( v889(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_230,axiom,
    ! [VarCurr] :
      ( v889(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_229,axiom,
    ! [VarCurr] :
      ( v889(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_35,axiom,
    ! [VarCurr] :
      ( ~ v862(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v861(VarCurr,B)
          <=> v863(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_35,axiom,
    ! [VarCurr] :
      ( v862(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v861(VarCurr,B)
          <=> b01111(B) ) ) ) ).

fof(addAssignment_228,axiom,
    ! [VarCurr] :
      ( v863(VarCurr,bitIndex0)
    <=> v885(VarCurr) ) ).

fof(addAssignment_227,axiom,
    ! [VarCurr] :
      ( v863(VarCurr,bitIndex1)
    <=> v883(VarCurr) ) ).

fof(addAssignment_226,axiom,
    ! [VarCurr] :
      ( v863(VarCurr,bitIndex2)
    <=> v878(VarCurr) ) ).

fof(addAssignment_225,axiom,
    ! [VarCurr] :
      ( v863(VarCurr,bitIndex3)
    <=> v873(VarCurr) ) ).

fof(addAssignment_224,axiom,
    ! [VarCurr] :
      ( v863(VarCurr,bitIndex4)
    <=> v865(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_148,axiom,
    ! [VarCurr] :
      ( v883(VarCurr)
    <=> ( v884(VarCurr)
        & v887(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_68,axiom,
    ! [VarCurr] :
      ( v887(VarCurr)
    <=> ( v25(VarCurr,bitIndex0)
        | v25(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_147,axiom,
    ! [VarCurr] :
      ( v884(VarCurr)
    <=> ( v885(VarCurr)
        | v886(VarCurr) ) ) ).

fof(writeUnaryOperator_94,axiom,
    ! [VarCurr] :
      ( ~ v886(VarCurr)
    <=> v25(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_93,axiom,
    ! [VarCurr] :
      ( ~ v885(VarCurr)
    <=> v25(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_146,axiom,
    ! [VarCurr] :
      ( v878(VarCurr)
    <=> ( v879(VarCurr)
        & v882(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_67,axiom,
    ! [VarCurr] :
      ( v882(VarCurr)
    <=> ( v870(VarCurr)
        | v25(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_145,axiom,
    ! [VarCurr] :
      ( v879(VarCurr)
    <=> ( v880(VarCurr)
        | v881(VarCurr) ) ) ).

fof(writeUnaryOperator_92,axiom,
    ! [VarCurr] :
      ( ~ v881(VarCurr)
    <=> v25(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_91,axiom,
    ! [VarCurr] :
      ( ~ v880(VarCurr)
    <=> v870(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_144,axiom,
    ! [VarCurr] :
      ( v873(VarCurr)
    <=> ( v874(VarCurr)
        & v877(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_66,axiom,
    ! [VarCurr] :
      ( v877(VarCurr)
    <=> ( v869(VarCurr)
        | v25(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_143,axiom,
    ! [VarCurr] :
      ( v874(VarCurr)
    <=> ( v875(VarCurr)
        | v876(VarCurr) ) ) ).

fof(writeUnaryOperator_90,axiom,
    ! [VarCurr] :
      ( ~ v876(VarCurr)
    <=> v25(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_89,axiom,
    ! [VarCurr] :
      ( ~ v875(VarCurr)
    <=> v869(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_142,axiom,
    ! [VarCurr] :
      ( v865(VarCurr)
    <=> ( v866(VarCurr)
        & v872(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_65,axiom,
    ! [VarCurr] :
      ( v872(VarCurr)
    <=> ( v868(VarCurr)
        | v25(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_141,axiom,
    ! [VarCurr] :
      ( v866(VarCurr)
    <=> ( v867(VarCurr)
        | v871(VarCurr) ) ) ).

fof(writeUnaryOperator_88,axiom,
    ! [VarCurr] :
      ( ~ v871(VarCurr)
    <=> v25(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_87,axiom,
    ! [VarCurr] :
      ( ~ v867(VarCurr)
    <=> v868(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_64,axiom,
    ! [VarCurr] :
      ( v868(VarCurr)
    <=> ( v869(VarCurr)
        & v25(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_63,axiom,
    ! [VarCurr] :
      ( v869(VarCurr)
    <=> ( v870(VarCurr)
        & v25(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_62,axiom,
    ! [VarCurr] :
      ( v870(VarCurr)
    <=> ( v25(VarCurr,bitIndex0)
        & v25(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_44,axiom,
    ! [VarCurr] :
      ( v862(VarCurr)
    <=> ( ( v25(VarCurr,bitIndex4)
        <=> $false )
        & ( v25(VarCurr,bitIndex3)
        <=> $true )
        & ( v25(VarCurr,bitIndex2)
        <=> $true )
        & ( v25(VarCurr,bitIndex1)
        <=> $true )
        & ( v25(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addBitVectorEqualityBitBlasted_43,axiom,
    ! [VarCurr] :
      ( v859(VarCurr)
    <=> ( ( v860(VarCurr,bitIndex1)
        <=> $true )
        & ( v860(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_223,axiom,
    ! [VarCurr] :
      ( v860(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_222,axiom,
    ! [VarCurr] :
      ( v860(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_34,axiom,
    ! [VarCurr] :
      ( ~ v821(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v820(VarCurr,B)
          <=> v822(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_34,axiom,
    ! [VarCurr] :
      ( v821(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v820(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_79,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex6)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_78,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex7)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_77,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex8)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_76,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex9)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_75,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex10)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_74,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex11)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_73,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex12)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_72,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex13)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_71,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex14)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_70,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex15)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_69,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex16)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_68,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex17)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_67,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex18)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_66,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex19)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_65,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex20)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_64,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex21)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_63,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex22)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_62,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex23)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_61,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex24)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_60,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex25)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_59,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex26)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_58,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex27)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_57,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex28)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_56,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex29)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_55,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex30)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_54,axiom,
    ! [VarCurr] :
      ( v822(VarCurr,bitIndex31)
    <=> v823(VarCurr,bitIndex5) ) ).

fof(addAssignment_221,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v822(VarCurr,B)
      <=> v823(VarCurr,B) ) ) ).

fof(addAssignment_220,axiom,
    ! [VarCurr] :
      ( v823(VarCurr,bitIndex0)
    <=> v857(VarCurr) ) ).

fof(addAssignment_219,axiom,
    ! [VarCurr] :
      ( v823(VarCurr,bitIndex1)
    <=> v855(VarCurr) ) ).

fof(addAssignment_218,axiom,
    ! [VarCurr] :
      ( v823(VarCurr,bitIndex2)
    <=> v851(VarCurr) ) ).

fof(addAssignment_217,axiom,
    ! [VarCurr] :
      ( v823(VarCurr,bitIndex3)
    <=> v847(VarCurr) ) ).

fof(addAssignment_216,axiom,
    ! [VarCurr] :
      ( v823(VarCurr,bitIndex4)
    <=> v843(VarCurr) ) ).

fof(addAssignment_215,axiom,
    ! [VarCurr] :
      ( v823(VarCurr,bitIndex5)
    <=> v825(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_140,axiom,
    ! [VarCurr] :
      ( v855(VarCurr)
    <=> ( v856(VarCurr)
        & v858(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_139,axiom,
    ! [VarCurr] :
      ( v858(VarCurr)
    <=> ( v829(VarCurr,bitIndex0)
        | v837(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_61,axiom,
    ! [VarCurr] :
      ( v856(VarCurr)
    <=> ( v857(VarCurr)
        | v829(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_86,axiom,
    ! [VarCurr] :
      ( ~ v857(VarCurr)
    <=> v829(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_138,axiom,
    ! [VarCurr] :
      ( v851(VarCurr)
    <=> ( v852(VarCurr)
        & v854(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_137,axiom,
    ! [VarCurr] :
      ( v854(VarCurr)
    <=> ( v835(VarCurr)
        | v838(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_60,axiom,
    ! [VarCurr] :
      ( v852(VarCurr)
    <=> ( v853(VarCurr)
        | v829(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_85,axiom,
    ! [VarCurr] :
      ( ~ v853(VarCurr)
    <=> v835(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_136,axiom,
    ! [VarCurr] :
      ( v847(VarCurr)
    <=> ( v848(VarCurr)
        & v850(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_135,axiom,
    ! [VarCurr] :
      ( v850(VarCurr)
    <=> ( v833(VarCurr)
        | v839(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_59,axiom,
    ! [VarCurr] :
      ( v848(VarCurr)
    <=> ( v849(VarCurr)
        | v829(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_84,axiom,
    ! [VarCurr] :
      ( ~ v849(VarCurr)
    <=> v833(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_134,axiom,
    ! [VarCurr] :
      ( v843(VarCurr)
    <=> ( v844(VarCurr)
        & v846(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_133,axiom,
    ! [VarCurr] :
      ( v846(VarCurr)
    <=> ( v831(VarCurr)
        | v840(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_58,axiom,
    ! [VarCurr] :
      ( v844(VarCurr)
    <=> ( v845(VarCurr)
        | v829(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_83,axiom,
    ! [VarCurr] :
      ( ~ v845(VarCurr)
    <=> v831(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_132,axiom,
    ! [VarCurr] :
      ( v825(VarCurr)
    <=> ( v826(VarCurr)
        & v841(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_131,axiom,
    ! [VarCurr] :
      ( v841(VarCurr)
    <=> ( v828(VarCurr)
        | v842(VarCurr) ) ) ).

fof(writeUnaryOperator_82,axiom,
    ! [VarCurr] :
      ( ~ v842(VarCurr)
    <=> v829(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_57,axiom,
    ! [VarCurr] :
      ( v826(VarCurr)
    <=> ( v827(VarCurr)
        | v829(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_81,axiom,
    ! [VarCurr] :
      ( ~ v827(VarCurr)
    <=> v828(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_56,axiom,
    ! [VarCurr] :
      ( v828(VarCurr)
    <=> ( v829(VarCurr,bitIndex4)
        | v830(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_130,axiom,
    ! [VarCurr] :
      ( v830(VarCurr)
    <=> ( v831(VarCurr)
        & v840(VarCurr) ) ) ).

fof(writeUnaryOperator_80,axiom,
    ! [VarCurr] :
      ( ~ v840(VarCurr)
    <=> v829(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_55,axiom,
    ! [VarCurr] :
      ( v831(VarCurr)
    <=> ( v829(VarCurr,bitIndex3)
        | v832(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_129,axiom,
    ! [VarCurr] :
      ( v832(VarCurr)
    <=> ( v833(VarCurr)
        & v839(VarCurr) ) ) ).

fof(writeUnaryOperator_79,axiom,
    ! [VarCurr] :
      ( ~ v839(VarCurr)
    <=> v829(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_54,axiom,
    ! [VarCurr] :
      ( v833(VarCurr)
    <=> ( v829(VarCurr,bitIndex2)
        | v834(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_128,axiom,
    ! [VarCurr] :
      ( v834(VarCurr)
    <=> ( v835(VarCurr)
        & v838(VarCurr) ) ) ).

fof(writeUnaryOperator_78,axiom,
    ! [VarCurr] :
      ( ~ v838(VarCurr)
    <=> v829(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_53,axiom,
    ! [VarCurr] :
      ( v835(VarCurr)
    <=> ( v829(VarCurr,bitIndex1)
        | v836(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_127,axiom,
    ! [VarCurr] :
      ( v836(VarCurr)
    <=> ( v829(VarCurr,bitIndex0)
        & v837(VarCurr) ) ) ).

fof(writeUnaryOperator_77,axiom,
    ! [VarCurr] :
      ( ~ v837(VarCurr)
    <=> v829(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_2,axiom,
    ! [VarCurr] : ~ v829(VarCurr,bitIndex5) ).

fof(addAssignment_214,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v829(VarCurr,B)
      <=> v25(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_42,axiom,
    ! [VarCurr] :
      ( v821(VarCurr)
    <=> ( ( v25(VarCurr,bitIndex4)
        <=> $false )
        & ( v25(VarCurr,bitIndex3)
        <=> $false )
        & ( v25(VarCurr,bitIndex2)
        <=> $false )
        & ( v25(VarCurr,bitIndex1)
        <=> $false )
        & ( v25(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_41,axiom,
    ! [VarCurr] :
      ( v818(VarCurr)
    <=> ( ( v819(VarCurr,bitIndex1)
        <=> $false )
        & ( v819(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_213,axiom,
    ! [VarCurr] :
      ( v819(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_212,axiom,
    ! [VarCurr] :
      ( v819(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(addAssignmentInitValueVector_3,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v25(constB0,B)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_40,axiom,
    ! [VarCurr] :
      ( v816(VarCurr)
    <=> ( ( v817(VarCurr,bitIndex1)
        <=> $false )
        & ( v817(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_211,axiom,
    ! [VarCurr] :
      ( v817(VarCurr,bitIndex0)
    <=> v56(VarCurr) ) ).

fof(addAssignment_210,axiom,
    ! [VarCurr] :
      ( v817(VarCurr,bitIndex1)
    <=> v32(VarCurr) ) ).

fof(addAssignment_209,axiom,
    ! [VarCurr] :
      ( v56(VarCurr)
    <=> v58(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_33,axiom,
    ! [VarCurr] :
      ( ~ v809(VarCurr)
     => ( v58(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_33,axiom,
    ! [VarCurr] :
      ( v809(VarCurr)
     => ( v58(VarCurr)
      <=> v810(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_14,axiom,
    ! [VarCurr] :
      ( ~ v695(VarCurr)
     => ( v810(VarCurr)
      <=> v813(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_13,axiom,
    ! [VarCurr] :
      ( v695(VarCurr)
     => ( v810(VarCurr)
      <=> v811(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_32,axiom,
    ! [VarCurr] :
      ( ~ v703(VarCurr)
     => ( v813(VarCurr)
      <=> v814(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_32,axiom,
    ! [VarCurr] :
      ( v703(VarCurr)
     => ( v813(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_31,axiom,
    ! [VarCurr] :
      ( ~ v705(VarCurr)
     => ( v814(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_31,axiom,
    ! [VarCurr] :
      ( v705(VarCurr)
     => ( v814(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_30,axiom,
    ! [VarCurr] :
      ( ~ v699(VarCurr)
     => ( v811(VarCurr)
      <=> v812(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_30,axiom,
    ! [VarCurr] :
      ( v699(VarCurr)
     => ( v811(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_29,axiom,
    ! [VarCurr] :
      ( ~ v701(VarCurr)
     => ( v812(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_29,axiom,
    ! [VarCurr] :
      ( v701(VarCurr)
     => ( v812(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_126,axiom,
    ! [VarCurr] :
      ( v809(VarCurr)
    <=> ( v695(VarCurr)
        | v696(VarCurr) ) ) ).

fof(addAssignment_208,axiom,
    ! [VarCurr] :
      ( v60(VarCurr)
    <=> v62(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_39,axiom,
    ! [VarCurr] :
      ( v62(VarCurr)
    <=> ( ( v64(VarCurr,bitIndex4)
        <=> $false )
        & ( v64(VarCurr,bitIndex3)
        <=> $false )
        & ( v64(VarCurr,bitIndex2)
        <=> $false )
        & ( v64(VarCurr,bitIndex1)
        <=> $false )
        & ( v64(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v793(VarNext)
       => ! [B] :
            ( range_4_0(B)
           => ( v64(VarNext,B)
            <=> v64(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarNext] :
      ( v793(VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v64(VarNext,B)
          <=> v803(VarNext,B) ) ) ) ).

fof(addAssignment_207,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_4_0(B)
         => ( v803(VarNext,B)
          <=> v801(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_28,axiom,
    ! [VarCurr] :
      ( ~ v804(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v801(VarCurr,B)
          <=> v68(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_28,axiom,
    ! [VarCurr] :
      ( v804(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v801(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_76,axiom,
    ! [VarCurr] :
      ( ~ v804(VarCurr)
    <=> v66(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_125,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v793(VarNext)
      <=> v794(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_124,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v794(VarNext)
      <=> ( v795(VarNext)
          & v786(VarNext) ) ) ) ).

fof(writeUnaryOperator_75,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v795(VarNext)
      <=> v797(VarNext) ) ) ).

fof(addAssignment_206,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v797(VarNext)
      <=> v786(VarCurr) ) ) ).

fof(addAssignment_205,axiom,
    ! [VarCurr] :
      ( v786(VarCurr)
    <=> v788(VarCurr) ) ).

fof(addAssignment_204,axiom,
    ! [VarCurr] :
      ( v788(VarCurr)
    <=> v790(VarCurr) ) ).

fof(addAssignment_203,axiom,
    ! [VarCurr] :
      ( v790(VarCurr)
    <=> v332(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_3,axiom,
    ! [VarCurr] :
      ( ( ~ v710(VarCurr)
        & ~ v712(VarCurr)
        & ~ v754(VarCurr) )
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v64(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_6,axiom,
    ! [VarCurr] :
      ( v754(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v756(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_13,axiom,
    ! [VarCurr] :
      ( v712(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v714(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_12,axiom,
    ! [VarCurr] :
      ( v710(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v68(VarCurr,B)
          <=> v64(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_38,axiom,
    ! [VarCurr] :
      ( v783(VarCurr)
    <=> ( ( v784(VarCurr,bitIndex1)
        <=> $true )
        & ( v784(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_202,axiom,
    ! [VarCurr] :
      ( v784(VarCurr,bitIndex0)
    <=> v690(VarCurr) ) ).

fof(addAssignment_201,axiom,
    ! [VarCurr] :
      ( v784(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_27,axiom,
    ! [VarCurr] :
      ( ~ v757(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v756(VarCurr,B)
          <=> v758(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_27,axiom,
    ! [VarCurr] :
      ( v757(VarCurr)
     => ! [B] :
          ( range_4_0(B)
         => ( v756(VarCurr,B)
          <=> b01111(B) ) ) ) ).

fof(addAssignment_200,axiom,
    ! [VarCurr] :
      ( v758(VarCurr,bitIndex0)
    <=> v780(VarCurr) ) ).

fof(addAssignment_199,axiom,
    ! [VarCurr] :
      ( v758(VarCurr,bitIndex1)
    <=> v778(VarCurr) ) ).

fof(addAssignment_198,axiom,
    ! [VarCurr] :
      ( v758(VarCurr,bitIndex2)
    <=> v773(VarCurr) ) ).

fof(addAssignment_197,axiom,
    ! [VarCurr] :
      ( v758(VarCurr,bitIndex3)
    <=> v768(VarCurr) ) ).

fof(addAssignment_196,axiom,
    ! [VarCurr] :
      ( v758(VarCurr,bitIndex4)
    <=> v760(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_123,axiom,
    ! [VarCurr] :
      ( v778(VarCurr)
    <=> ( v779(VarCurr)
        & v782(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_52,axiom,
    ! [VarCurr] :
      ( v782(VarCurr)
    <=> ( v64(VarCurr,bitIndex0)
        | v64(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_122,axiom,
    ! [VarCurr] :
      ( v779(VarCurr)
    <=> ( v780(VarCurr)
        | v781(VarCurr) ) ) ).

fof(writeUnaryOperator_74,axiom,
    ! [VarCurr] :
      ( ~ v781(VarCurr)
    <=> v64(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_73,axiom,
    ! [VarCurr] :
      ( ~ v780(VarCurr)
    <=> v64(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_121,axiom,
    ! [VarCurr] :
      ( v773(VarCurr)
    <=> ( v774(VarCurr)
        & v777(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_51,axiom,
    ! [VarCurr] :
      ( v777(VarCurr)
    <=> ( v765(VarCurr)
        | v64(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_120,axiom,
    ! [VarCurr] :
      ( v774(VarCurr)
    <=> ( v775(VarCurr)
        | v776(VarCurr) ) ) ).

fof(writeUnaryOperator_72,axiom,
    ! [VarCurr] :
      ( ~ v776(VarCurr)
    <=> v64(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_71,axiom,
    ! [VarCurr] :
      ( ~ v775(VarCurr)
    <=> v765(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_119,axiom,
    ! [VarCurr] :
      ( v768(VarCurr)
    <=> ( v769(VarCurr)
        & v772(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_50,axiom,
    ! [VarCurr] :
      ( v772(VarCurr)
    <=> ( v764(VarCurr)
        | v64(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_118,axiom,
    ! [VarCurr] :
      ( v769(VarCurr)
    <=> ( v770(VarCurr)
        | v771(VarCurr) ) ) ).

fof(writeUnaryOperator_70,axiom,
    ! [VarCurr] :
      ( ~ v771(VarCurr)
    <=> v64(VarCurr,bitIndex3) ) ).

fof(writeUnaryOperator_69,axiom,
    ! [VarCurr] :
      ( ~ v770(VarCurr)
    <=> v764(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_117,axiom,
    ! [VarCurr] :
      ( v760(VarCurr)
    <=> ( v761(VarCurr)
        & v767(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_49,axiom,
    ! [VarCurr] :
      ( v767(VarCurr)
    <=> ( v763(VarCurr)
        | v64(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_116,axiom,
    ! [VarCurr] :
      ( v761(VarCurr)
    <=> ( v762(VarCurr)
        | v766(VarCurr) ) ) ).

fof(writeUnaryOperator_68,axiom,
    ! [VarCurr] :
      ( ~ v766(VarCurr)
    <=> v64(VarCurr,bitIndex4) ) ).

fof(writeUnaryOperator_67,axiom,
    ! [VarCurr] :
      ( ~ v762(VarCurr)
    <=> v763(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_48,axiom,
    ! [VarCurr] :
      ( v763(VarCurr)
    <=> ( v764(VarCurr)
        & v64(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_47,axiom,
    ! [VarCurr] :
      ( v764(VarCurr)
    <=> ( v765(VarCurr)
        & v64(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_46,axiom,
    ! [VarCurr] :
      ( v765(VarCurr)
    <=> ( v64(VarCurr,bitIndex0)
        & v64(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_37,axiom,
    ! [VarCurr] :
      ( v757(VarCurr)
    <=> ( ( v64(VarCurr,bitIndex4)
        <=> $false )
        & ( v64(VarCurr,bitIndex3)
        <=> $true )
        & ( v64(VarCurr,bitIndex2)
        <=> $true )
        & ( v64(VarCurr,bitIndex1)
        <=> $true )
        & ( v64(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_192,axiom,
    ~ b01111(bitIndex4) ).

fof(bitBlastConstant_191,axiom,
    b01111(bitIndex3) ).

fof(bitBlastConstant_190,axiom,
    b01111(bitIndex2) ).

fof(bitBlastConstant_189,axiom,
    b01111(bitIndex1) ).

fof(bitBlastConstant_188,axiom,
    b01111(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_36,axiom,
    ! [VarCurr] :
      ( v754(VarCurr)
    <=> ( ( v755(VarCurr,bitIndex1)
        <=> $true )
        & ( v755(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_195,axiom,
    ! [VarCurr] :
      ( v755(VarCurr,bitIndex0)
    <=> v690(VarCurr) ) ).

fof(addAssignment_194,axiom,
    ! [VarCurr] :
      ( v755(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_26,axiom,
    ! [VarCurr] :
      ( ~ v715(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v714(VarCurr,B)
          <=> v716(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_26,axiom,
    ! [VarCurr] :
      ( v715(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v714(VarCurr,B)
          <=> $false ) ) ) ).

fof(addSignExtensionConstraint_53,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex6)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_52,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex7)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_51,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex8)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_50,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex9)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_49,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex10)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_48,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex11)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_47,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex12)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_46,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex13)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_45,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex14)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_44,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex15)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_43,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex16)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_42,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex17)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_41,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex18)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_40,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex19)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_39,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex20)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_38,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex21)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_37,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex22)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_36,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex23)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_35,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex24)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_34,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex25)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_33,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex26)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_32,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex27)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_31,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex28)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_30,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex29)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_29,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex30)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addSignExtensionConstraint_28,axiom,
    ! [VarCurr] :
      ( v716(VarCurr,bitIndex31)
    <=> v717(VarCurr,bitIndex5) ) ).

fof(addAssignment_193,axiom,
    ! [VarCurr,B] :
      ( range_5_0(B)
     => ( v716(VarCurr,B)
      <=> v717(VarCurr,B) ) ) ).

fof(range_axiom_10,axiom,
    ! [B] :
      ( range_5_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B ) ) ).

fof(addAssignment_192,axiom,
    ! [VarCurr] :
      ( v717(VarCurr,bitIndex0)
    <=> v752(VarCurr) ) ).

fof(addAssignment_191,axiom,
    ! [VarCurr] :
      ( v717(VarCurr,bitIndex1)
    <=> v750(VarCurr) ) ).

fof(addAssignment_190,axiom,
    ! [VarCurr] :
      ( v717(VarCurr,bitIndex2)
    <=> v746(VarCurr) ) ).

fof(addAssignment_189,axiom,
    ! [VarCurr] :
      ( v717(VarCurr,bitIndex3)
    <=> v742(VarCurr) ) ).

fof(addAssignment_188,axiom,
    ! [VarCurr] :
      ( v717(VarCurr,bitIndex4)
    <=> v738(VarCurr) ) ).

fof(addAssignment_187,axiom,
    ! [VarCurr] :
      ( v717(VarCurr,bitIndex5)
    <=> v719(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_115,axiom,
    ! [VarCurr] :
      ( v750(VarCurr)
    <=> ( v751(VarCurr)
        & v753(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_114,axiom,
    ! [VarCurr] :
      ( v753(VarCurr)
    <=> ( v723(VarCurr,bitIndex0)
        | v732(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_45,axiom,
    ! [VarCurr] :
      ( v751(VarCurr)
    <=> ( v752(VarCurr)
        | v723(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_66,axiom,
    ! [VarCurr] :
      ( ~ v752(VarCurr)
    <=> v723(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_113,axiom,
    ! [VarCurr] :
      ( v746(VarCurr)
    <=> ( v747(VarCurr)
        & v749(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_112,axiom,
    ! [VarCurr] :
      ( v749(VarCurr)
    <=> ( v730(VarCurr)
        | v733(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_44,axiom,
    ! [VarCurr] :
      ( v747(VarCurr)
    <=> ( v748(VarCurr)
        | v723(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_65,axiom,
    ! [VarCurr] :
      ( ~ v748(VarCurr)
    <=> v730(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_111,axiom,
    ! [VarCurr] :
      ( v742(VarCurr)
    <=> ( v743(VarCurr)
        & v745(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_110,axiom,
    ! [VarCurr] :
      ( v745(VarCurr)
    <=> ( v728(VarCurr)
        | v734(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_43,axiom,
    ! [VarCurr] :
      ( v743(VarCurr)
    <=> ( v744(VarCurr)
        | v723(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_64,axiom,
    ! [VarCurr] :
      ( ~ v744(VarCurr)
    <=> v728(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_109,axiom,
    ! [VarCurr] :
      ( v738(VarCurr)
    <=> ( v739(VarCurr)
        & v741(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_108,axiom,
    ! [VarCurr] :
      ( v741(VarCurr)
    <=> ( v726(VarCurr)
        | v735(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_42,axiom,
    ! [VarCurr] :
      ( v739(VarCurr)
    <=> ( v740(VarCurr)
        | v723(VarCurr,bitIndex4) ) ) ).

fof(writeUnaryOperator_63,axiom,
    ! [VarCurr] :
      ( ~ v740(VarCurr)
    <=> v726(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_107,axiom,
    ! [VarCurr] :
      ( v719(VarCurr)
    <=> ( v720(VarCurr)
        & v736(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_106,axiom,
    ! [VarCurr] :
      ( v736(VarCurr)
    <=> ( v722(VarCurr)
        | v737(VarCurr) ) ) ).

fof(writeUnaryOperator_62,axiom,
    ! [VarCurr] :
      ( ~ v737(VarCurr)
    <=> v723(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorShiftedRanges_41,axiom,
    ! [VarCurr] :
      ( v720(VarCurr)
    <=> ( v721(VarCurr)
        | v723(VarCurr,bitIndex5) ) ) ).

fof(writeUnaryOperator_61,axiom,
    ! [VarCurr] :
      ( ~ v721(VarCurr)
    <=> v722(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_40,axiom,
    ! [VarCurr] :
      ( v722(VarCurr)
    <=> ( v723(VarCurr,bitIndex4)
        | v725(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_105,axiom,
    ! [VarCurr] :
      ( v725(VarCurr)
    <=> ( v726(VarCurr)
        & v735(VarCurr) ) ) ).

fof(writeUnaryOperator_60,axiom,
    ! [VarCurr] :
      ( ~ v735(VarCurr)
    <=> v723(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorShiftedRanges_39,axiom,
    ! [VarCurr] :
      ( v726(VarCurr)
    <=> ( v723(VarCurr,bitIndex3)
        | v727(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_104,axiom,
    ! [VarCurr] :
      ( v727(VarCurr)
    <=> ( v728(VarCurr)
        & v734(VarCurr) ) ) ).

fof(writeUnaryOperator_59,axiom,
    ! [VarCurr] :
      ( ~ v734(VarCurr)
    <=> v723(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_38,axiom,
    ! [VarCurr] :
      ( v728(VarCurr)
    <=> ( v723(VarCurr,bitIndex2)
        | v729(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_103,axiom,
    ! [VarCurr] :
      ( v729(VarCurr)
    <=> ( v730(VarCurr)
        & v733(VarCurr) ) ) ).

fof(writeUnaryOperator_58,axiom,
    ! [VarCurr] :
      ( ~ v733(VarCurr)
    <=> v723(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_37,axiom,
    ! [VarCurr] :
      ( v730(VarCurr)
    <=> ( v723(VarCurr,bitIndex1)
        | v731(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_102,axiom,
    ! [VarCurr] :
      ( v731(VarCurr)
    <=> ( v723(VarCurr,bitIndex0)
        & v732(VarCurr) ) ) ).

fof(writeUnaryOperator_57,axiom,
    ! [VarCurr] :
      ( ~ v732(VarCurr)
    <=> v723(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint_1,axiom,
    ! [VarCurr] : ~ v723(VarCurr,bitIndex5) ).

fof(addAssignment_186,axiom,
    ! [VarCurr,B] :
      ( range_4_0(B)
     => ( v723(VarCurr,B)
      <=> v64(VarCurr,B) ) ) ).

fof(addBitVectorEqualityBitBlasted_35,axiom,
    ! [VarCurr] :
      ( v715(VarCurr)
    <=> ( ( v64(VarCurr,bitIndex4)
        <=> $false )
        & ( v64(VarCurr,bitIndex3)
        <=> $false )
        & ( v64(VarCurr,bitIndex2)
        <=> $false )
        & ( v64(VarCurr,bitIndex1)
        <=> $false )
        & ( v64(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addBitVectorEqualityBitBlasted_34,axiom,
    ! [VarCurr] :
      ( v712(VarCurr)
    <=> ( ( v713(VarCurr,bitIndex1)
        <=> $false )
        & ( v713(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_185,axiom,
    ! [VarCurr] :
      ( v713(VarCurr,bitIndex0)
    <=> v690(VarCurr) ) ).

fof(addAssignment_184,axiom,
    ! [VarCurr] :
      ( v713(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(addAssignmentInitValueVector_2,axiom,
    ! [B] :
      ( range_4_0(B)
     => ( v64(constB0,B)
      <=> $false ) ) ).

fof(range_axiom_9,axiom,
    ! [B] :
      ( range_4_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B ) ) ).

fof(bitBlastConstant_187,axiom,
    ~ b00000(bitIndex4) ).

fof(bitBlastConstant_186,axiom,
    ~ b00000(bitIndex3) ).

fof(bitBlastConstant_185,axiom,
    ~ b00000(bitIndex2) ).

fof(bitBlastConstant_184,axiom,
    ~ b00000(bitIndex1) ).

fof(bitBlastConstant_183,axiom,
    ~ b00000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_33,axiom,
    ! [VarCurr] :
      ( v710(VarCurr)
    <=> ( ( v711(VarCurr,bitIndex1)
        <=> $false )
        & ( v711(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_183,axiom,
    ! [VarCurr] :
      ( v711(VarCurr,bitIndex0)
    <=> v690(VarCurr) ) ).

fof(addAssignment_182,axiom,
    ! [VarCurr] :
      ( v711(VarCurr,bitIndex1)
    <=> v70(VarCurr) ) ).

fof(addAssignment_181,axiom,
    ! [VarCurr] :
      ( v690(VarCurr)
    <=> v692(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_25,axiom,
    ! [VarCurr] :
      ( ~ v694(VarCurr)
     => ( v692(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_25,axiom,
    ! [VarCurr] :
      ( v694(VarCurr)
     => ( v692(VarCurr)
      <=> v697(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_12,axiom,
    ! [VarCurr] :
      ( ~ v695(VarCurr)
     => ( v697(VarCurr)
      <=> v702(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_11,axiom,
    ! [VarCurr] :
      ( v695(VarCurr)
     => ( v697(VarCurr)
      <=> v698(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_24,axiom,
    ! [VarCurr] :
      ( ~ v703(VarCurr)
     => ( v702(VarCurr)
      <=> v704(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_24,axiom,
    ! [VarCurr] :
      ( v703(VarCurr)
     => ( v702(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_23,axiom,
    ! [VarCurr] :
      ( ~ v705(VarCurr)
     => ( v704(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_23,axiom,
    ! [VarCurr] :
      ( v705(VarCurr)
     => ( v704(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_56,axiom,
    ! [VarCurr] :
      ( ~ v705(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeUnaryOperator_55,axiom,
    ! [VarCurr] :
      ( ~ v703(VarCurr)
    <=> v60(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_22,axiom,
    ! [VarCurr] :
      ( ~ v699(VarCurr)
     => ( v698(VarCurr)
      <=> v700(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_22,axiom,
    ! [VarCurr] :
      ( v699(VarCurr)
     => ( v698(VarCurr)
      <=> $false ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_21,axiom,
    ! [VarCurr] :
      ( ~ v701(VarCurr)
     => ( v700(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_21,axiom,
    ! [VarCurr] :
      ( v701(VarCurr)
     => ( v700(VarCurr)
      <=> $true ) ) ).

fof(writeUnaryOperator_54,axiom,
    ! [VarCurr] :
      ( ~ v701(VarCurr)
    <=> v60(VarCurr) ) ).

fof(writeUnaryOperator_53,axiom,
    ! [VarCurr] :
      ( ~ v699(VarCurr)
    <=> v21(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_101,axiom,
    ! [VarCurr] :
      ( v694(VarCurr)
    <=> ( v695(VarCurr)
        | v696(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_32,axiom,
    ! [VarCurr] :
      ( v696(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_31,axiom,
    ! [VarCurr] :
      ( v695(VarCurr)
    <=> ( $true
      <=> v6(VarCurr,bitIndex0) ) ) ).

fof(addAssignmentInitValueVector_1,axiom,
    ( v6(constB0,bitIndex1)
  <=> $false ) ).

fof(addAssignmentInitValueVector,axiom,
    ( v6(constB0,bitIndex0)
  <=> $true ) ).

fof(addAssignment_180,axiom,
    ! [VarCurr] :
      ( v70(VarCurr)
    <=> v72(VarCurr) ) ).

fof(addAssignment_179,axiom,
    ! [VarCurr] :
      ( v72(VarCurr)
    <=> v74(VarCurr) ) ).

fof(addAssignment_178,axiom,
    ! [VarCurr] :
      ( v74(VarCurr)
    <=> v76(VarCurr) ) ).

fof(addAssignment_177,axiom,
    ! [VarCurr] :
      ( v76(VarCurr)
    <=> v78(VarCurr) ) ).

fof(addAssignment_176,axiom,
    ! [VarCurr] :
      ( v78(VarCurr)
    <=> v80(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v677(VarNext)
       => ( v80(VarNext)
        <=> v80(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarNext] :
      ( v677(VarNext)
     => ( v80(VarNext)
      <=> v685(VarNext) ) ) ).

fof(addAssignment_175,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v685(VarNext)
      <=> v683(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_20,axiom,
    ! [VarCurr] :
      ( ~ v686(VarCurr)
     => ( v683(VarCurr)
      <=> v86(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_20,axiom,
    ! [VarCurr] :
      ( v686(VarCurr)
     => ( v683(VarCurr)
      <=> $false ) ) ).

fof(writeUnaryOperator_52,axiom,
    ! [VarCurr] :
      ( ~ v686(VarCurr)
    <=> v82(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_100,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v677(VarNext)
      <=> v678(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_99,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v678(VarNext)
      <=> ( v679(VarNext)
          & v328(VarNext) ) ) ) ).

fof(writeUnaryOperator_51,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v679(VarNext)
      <=> v339(VarNext) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_19,axiom,
    ! [VarCurr] :
      ( ~ v669(VarCurr)
     => ( v86(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_19,axiom,
    ! [VarCurr] :
      ( v669(VarCurr)
     => ( v86(VarCurr)
      <=> v674(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_11,axiom,
    ! [VarCurr] :
      ( ~ v671(VarCurr)
     => ( v674(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_10,axiom,
    ! [VarCurr] :
      ( v671(VarCurr)
     => ( v674(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_98,axiom,
    ! [VarCurr] :
      ( v669(VarCurr)
    <=> ( v670(VarCurr)
        & v673(VarCurr) ) ) ).

fof(writeUnaryOperator_50,axiom,
    ! [VarCurr] :
      ( ~ v673(VarCurr)
    <=> v275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_97,axiom,
    ! [VarCurr] :
      ( v670(VarCurr)
    <=> ( v671(VarCurr)
        | v672(VarCurr) ) ) ).

fof(writeUnaryOperator_49,axiom,
    ! [VarCurr] :
      ( ~ v672(VarCurr)
    <=> v272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_96,axiom,
    ! [VarCurr] :
      ( v671(VarCurr)
    <=> ( v444(VarCurr)
        & v272(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_18,axiom,
    ! [VarCurr] :
      ( ~ v90(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v88(VarCurr,B)
          <=> v599(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_18,axiom,
    ! [VarCurr] :
      ( v90(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v88(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges4,axiom,
    ! [VarCurr] :
      ( ( ~ v600(VarCurr)
        & ~ v637(VarCurr)
        & ~ v645(VarCurr)
        & ~ v653(VarCurr) )
     => ! [B] :
          ( range_1_0(B)
         => ( v599(VarCurr,B)
          <=> $true ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_2,axiom,
    ! [VarCurr] :
      ( v653(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v599(VarCurr,B)
          <=> b01(B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_5,axiom,
    ! [VarCurr] :
      ( v645(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v599(VarCurr,B)
          <=> $false ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_10,axiom,
    ! [VarCurr] :
      ( v637(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v599(VarCurr,B)
          <=> v644(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_9,axiom,
    ! [VarCurr] :
      ( v600(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v599(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_95,axiom,
    ! [VarCurr] :
      ( v653(VarCurr)
    <=> ( v655(VarCurr)
        | v664(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_94,axiom,
    ! [VarCurr] :
      ( v664(VarCurr)
    <=> ( v666(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_36,axiom,
    ! [VarCurr] :
      ( v666(VarCurr)
    <=> ( v667(VarCurr)
        & v487(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_35,axiom,
    ! [VarCurr] :
      ( v667(VarCurr)
    <=> ( v616(VarCurr)
        & v487(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_93,axiom,
    ! [VarCurr] :
      ( v655(VarCurr)
    <=> ( v656(VarCurr)
        | v661(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_34,axiom,
    ! [VarCurr] :
      ( v661(VarCurr)
    <=> ( v663(VarCurr)
        & v487(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorShiftedRanges_33,axiom,
    ! [VarCurr] :
      ( v663(VarCurr)
    <=> ( v659(VarCurr)
        & v487(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorShiftedRanges_32,axiom,
    ! [VarCurr] :
      ( v656(VarCurr)
    <=> ( v658(VarCurr)
        & v487(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_92,axiom,
    ! [VarCurr] :
      ( v658(VarCurr)
    <=> ( v659(VarCurr)
        & v618(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_31,axiom,
    ! [VarCurr] :
      ( v659(VarCurr)
    <=> ( v660(VarCurr)
        & v487(VarCurr,bitIndex4) ) ) ).

fof(writeBinaryOperatorShiftedRanges_30,axiom,
    ! [VarCurr] :
      ( v660(VarCurr)
    <=> ( v611(VarCurr)
        & v487(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_91,axiom,
    ! [VarCurr] :
      ( v645(VarCurr)
    <=> ( v646(VarCurr)
        | v648(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_90,axiom,
    ! [VarCurr] :
      ( v648(VarCurr)
    <=> ( v650(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_89,axiom,
    ! [VarCurr] :
      ( v650(VarCurr)
    <=> ( v651(VarCurr)
        & v618(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_88,axiom,
    ! [VarCurr] :
      ( v651(VarCurr)
    <=> ( v652(VarCurr)
        & v617(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_29,axiom,
    ! [VarCurr] :
      ( v652(VarCurr)
    <=> ( v628(VarCurr)
        & v487(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_28,axiom,
    ! [VarCurr] :
      ( v646(VarCurr)
    <=> ( v639(VarCurr)
        & v487(VarCurr,bitIndex6) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_17,axiom,
    ! [VarCurr] :
      ( ~ v584(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v644(VarCurr,B)
          <=> $false ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_17,axiom,
    ! [VarCurr] :
      ( v584(VarCurr)
     => ! [B] :
          ( range_1_0(B)
         => ( v644(VarCurr,B)
          <=> b10(B) ) ) ) ).

fof(range_axiom_8,axiom,
    ! [B] :
      ( range_1_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_87,axiom,
    ! [VarCurr] :
      ( v637(VarCurr)
    <=> ( v639(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_86,axiom,
    ! [VarCurr] :
      ( v639(VarCurr)
    <=> ( v640(VarCurr)
        & v618(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_85,axiom,
    ! [VarCurr] :
      ( v640(VarCurr)
    <=> ( v641(VarCurr)
        & v617(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_27,axiom,
    ! [VarCurr] :
      ( v641(VarCurr)
    <=> ( v642(VarCurr)
        & v487(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_84,axiom,
    ! [VarCurr] :
      ( v642(VarCurr)
    <=> ( v643(VarCurr)
        & v615(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_26,axiom,
    ! [VarCurr] :
      ( v643(VarCurr)
    <=> ( v613(VarCurr)
        & v487(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_83,axiom,
    ! [VarCurr] :
      ( v600(VarCurr)
    <=> ( v602(VarCurr)
        | v635(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_25,axiom,
    ! [VarCurr] :
      ( v635(VarCurr)
    <=> ( v622(VarCurr)
        & v487(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_82,axiom,
    ! [VarCurr] :
      ( v602(VarCurr)
    <=> ( v603(VarCurr)
        | v633(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_24,axiom,
    ! [VarCurr] :
      ( v633(VarCurr)
    <=> ( v608(VarCurr)
        & v487(VarCurr,bitIndex6) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_81,axiom,
    ! [VarCurr] :
      ( v603(VarCurr)
    <=> ( v604(VarCurr)
        | v630(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_80,axiom,
    ! [VarCurr] :
      ( v630(VarCurr)
    <=> ( v632(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_23,axiom,
    ! [VarCurr] :
      ( v632(VarCurr)
    <=> ( v626(VarCurr)
        & v487(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_79,axiom,
    ! [VarCurr] :
      ( v604(VarCurr)
    <=> ( v605(VarCurr)
        | v623(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_78,axiom,
    ! [VarCurr] :
      ( v623(VarCurr)
    <=> ( v625(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_77,axiom,
    ! [VarCurr] :
      ( v625(VarCurr)
    <=> ( v626(VarCurr)
        & v618(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_76,axiom,
    ! [VarCurr] :
      ( v626(VarCurr)
    <=> ( v627(VarCurr)
        & v617(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_75,axiom,
    ! [VarCurr] :
      ( v627(VarCurr)
    <=> ( v628(VarCurr)
        & v616(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_74,axiom,
    ! [VarCurr] :
      ( v628(VarCurr)
    <=> ( v629(VarCurr)
        & v615(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_73,axiom,
    ! [VarCurr] :
      ( v629(VarCurr)
    <=> ( v487(VarCurr,bitIndex0)
        & v614(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_72,axiom,
    ! [VarCurr] :
      ( v605(VarCurr)
    <=> ( v606(VarCurr)
        | v620(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_71,axiom,
    ! [VarCurr] :
      ( v620(VarCurr)
    <=> ( v622(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_22,axiom,
    ! [VarCurr] :
      ( v622(VarCurr)
    <=> ( v609(VarCurr)
        & v487(VarCurr,bitIndex5) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_70,axiom,
    ! [VarCurr] :
      ( v606(VarCurr)
    <=> ( v608(VarCurr)
        & v619(VarCurr) ) ) ).

fof(writeUnaryOperator_48,axiom,
    ! [VarCurr] :
      ( ~ v619(VarCurr)
    <=> v487(VarCurr,bitIndex6) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_69,axiom,
    ! [VarCurr] :
      ( v608(VarCurr)
    <=> ( v609(VarCurr)
        & v618(VarCurr) ) ) ).

fof(writeUnaryOperator_47,axiom,
    ! [VarCurr] :
      ( ~ v618(VarCurr)
    <=> v487(VarCurr,bitIndex5) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_68,axiom,
    ! [VarCurr] :
      ( v609(VarCurr)
    <=> ( v610(VarCurr)
        & v617(VarCurr) ) ) ).

fof(writeUnaryOperator_46,axiom,
    ! [VarCurr] :
      ( ~ v617(VarCurr)
    <=> v487(VarCurr,bitIndex4) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_67,axiom,
    ! [VarCurr] :
      ( v610(VarCurr)
    <=> ( v611(VarCurr)
        & v616(VarCurr) ) ) ).

fof(writeUnaryOperator_45,axiom,
    ! [VarCurr] :
      ( ~ v616(VarCurr)
    <=> v487(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_66,axiom,
    ! [VarCurr] :
      ( v611(VarCurr)
    <=> ( v612(VarCurr)
        & v615(VarCurr) ) ) ).

fof(writeUnaryOperator_44,axiom,
    ! [VarCurr] :
      ( ~ v615(VarCurr)
    <=> v487(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_65,axiom,
    ! [VarCurr] :
      ( v612(VarCurr)
    <=> ( v613(VarCurr)
        & v614(VarCurr) ) ) ).

fof(writeUnaryOperator_43,axiom,
    ! [VarCurr] :
      ( ~ v614(VarCurr)
    <=> v487(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_42,axiom,
    ! [VarCurr] :
      ( ~ v613(VarCurr)
    <=> v487(VarCurr,bitIndex0) ) ).

fof(addAssignment_174,axiom,
    ! [VarCurr] :
      ( v584(VarCurr)
    <=> v489(VarCurr,bitIndex81) ) ).

fof(addAssignment_173,axiom,
    ! [VarCurr] :
      ( v489(VarCurr,bitIndex81)
    <=> v491(VarCurr,bitIndex81) ) ).

fof(addAssignment_172,axiom,
    ! [VarCurr] :
      ( v491(VarCurr,bitIndex81)
    <=> v493(VarCurr,bitIndex696) ) ).

fof(addAssignment_171,axiom,
    ! [VarNext] :
      ( v493(VarNext,bitIndex696)
    <=> v586(VarNext,bitIndex81) ) ).

fof(addCaseBooleanConditionShiftedRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v588(VarNext)
       => ( ( v586(VarNext,bitIndex122)
          <=> v493(VarCurr,bitIndex737) )
          & ( v586(VarNext,bitIndex121)
          <=> v493(VarCurr,bitIndex736) )
          & ( v586(VarNext,bitIndex120)
          <=> v493(VarCurr,bitIndex735) )
          & ( v586(VarNext,bitIndex119)
          <=> v493(VarCurr,bitIndex734) )
          & ( v586(VarNext,bitIndex118)
          <=> v493(VarCurr,bitIndex733) )
          & ( v586(VarNext,bitIndex117)
          <=> v493(VarCurr,bitIndex732) )
          & ( v586(VarNext,bitIndex116)
          <=> v493(VarCurr,bitIndex731) )
          & ( v586(VarNext,bitIndex115)
          <=> v493(VarCurr,bitIndex730) )
          & ( v586(VarNext,bitIndex114)
          <=> v493(VarCurr,bitIndex729) )
          & ( v586(VarNext,bitIndex113)
          <=> v493(VarCurr,bitIndex728) )
          & ( v586(VarNext,bitIndex112)
          <=> v493(VarCurr,bitIndex727) )
          & ( v586(VarNext,bitIndex111)
          <=> v493(VarCurr,bitIndex726) )
          & ( v586(VarNext,bitIndex110)
          <=> v493(VarCurr,bitIndex725) )
          & ( v586(VarNext,bitIndex109)
          <=> v493(VarCurr,bitIndex724) )
          & ( v586(VarNext,bitIndex108)
          <=> v493(VarCurr,bitIndex723) )
          & ( v586(VarNext,bitIndex107)
          <=> v493(VarCurr,bitIndex722) )
          & ( v586(VarNext,bitIndex106)
          <=> v493(VarCurr,bitIndex721) )
          & ( v586(VarNext,bitIndex105)
          <=> v493(VarCurr,bitIndex720) )
          & ( v586(VarNext,bitIndex104)
          <=> v493(VarCurr,bitIndex719) )
          & ( v586(VarNext,bitIndex103)
          <=> v493(VarCurr,bitIndex718) )
          & ( v586(VarNext,bitIndex102)
          <=> v493(VarCurr,bitIndex717) )
          & ( v586(VarNext,bitIndex101)
          <=> v493(VarCurr,bitIndex716) )
          & ( v586(VarNext,bitIndex100)
          <=> v493(VarCurr,bitIndex715) )
          & ( v586(VarNext,bitIndex99)
          <=> v493(VarCurr,bitIndex714) )
          & ( v586(VarNext,bitIndex98)
          <=> v493(VarCurr,bitIndex713) )
          & ( v586(VarNext,bitIndex97)
          <=> v493(VarCurr,bitIndex712) )
          & ( v586(VarNext,bitIndex96)
          <=> v493(VarCurr,bitIndex711) )
          & ( v586(VarNext,bitIndex95)
          <=> v493(VarCurr,bitIndex710) )
          & ( v586(VarNext,bitIndex94)
          <=> v493(VarCurr,bitIndex709) )
          & ( v586(VarNext,bitIndex93)
          <=> v493(VarCurr,bitIndex708) )
          & ( v586(VarNext,bitIndex92)
          <=> v493(VarCurr,bitIndex707) )
          & ( v586(VarNext,bitIndex91)
          <=> v493(VarCurr,bitIndex706) )
          & ( v586(VarNext,bitIndex90)
          <=> v493(VarCurr,bitIndex705) )
          & ( v586(VarNext,bitIndex89)
          <=> v493(VarCurr,bitIndex704) )
          & ( v586(VarNext,bitIndex88)
          <=> v493(VarCurr,bitIndex703) )
          & ( v586(VarNext,bitIndex87)
          <=> v493(VarCurr,bitIndex702) )
          & ( v586(VarNext,bitIndex86)
          <=> v493(VarCurr,bitIndex701) )
          & ( v586(VarNext,bitIndex85)
          <=> v493(VarCurr,bitIndex700) )
          & ( v586(VarNext,bitIndex84)
          <=> v493(VarCurr,bitIndex699) )
          & ( v586(VarNext,bitIndex83)
          <=> v493(VarCurr,bitIndex698) )
          & ( v586(VarNext,bitIndex82)
          <=> v493(VarCurr,bitIndex697) )
          & ( v586(VarNext,bitIndex81)
          <=> v493(VarCurr,bitIndex696) )
          & ( v586(VarNext,bitIndex80)
          <=> v493(VarCurr,bitIndex695) )
          & ( v586(VarNext,bitIndex79)
          <=> v493(VarCurr,bitIndex694) )
          & ( v586(VarNext,bitIndex78)
          <=> v493(VarCurr,bitIndex693) )
          & ( v586(VarNext,bitIndex77)
          <=> v493(VarCurr,bitIndex692) )
          & ( v586(VarNext,bitIndex76)
          <=> v493(VarCurr,bitIndex691) )
          & ( v586(VarNext,bitIndex75)
          <=> v493(VarCurr,bitIndex690) )
          & ( v586(VarNext,bitIndex74)
          <=> v493(VarCurr,bitIndex689) )
          & ( v586(VarNext,bitIndex73)
          <=> v493(VarCurr,bitIndex688) )
          & ( v586(VarNext,bitIndex72)
          <=> v493(VarCurr,bitIndex687) )
          & ( v586(VarNext,bitIndex71)
          <=> v493(VarCurr,bitIndex686) )
          & ( v586(VarNext,bitIndex70)
          <=> v493(VarCurr,bitIndex685) )
          & ( v586(VarNext,bitIndex69)
          <=> v493(VarCurr,bitIndex684) )
          & ( v586(VarNext,bitIndex68)
          <=> v493(VarCurr,bitIndex683) )
          & ( v586(VarNext,bitIndex67)
          <=> v493(VarCurr,bitIndex682) )
          & ( v586(VarNext,bitIndex66)
          <=> v493(VarCurr,bitIndex681) )
          & ( v586(VarNext,bitIndex65)
          <=> v493(VarCurr,bitIndex680) )
          & ( v586(VarNext,bitIndex64)
          <=> v493(VarCurr,bitIndex679) )
          & ( v586(VarNext,bitIndex63)
          <=> v493(VarCurr,bitIndex678) )
          & ( v586(VarNext,bitIndex62)
          <=> v493(VarCurr,bitIndex677) )
          & ( v586(VarNext,bitIndex61)
          <=> v493(VarCurr,bitIndex676) )
          & ( v586(VarNext,bitIndex60)
          <=> v493(VarCurr,bitIndex675) )
          & ( v586(VarNext,bitIndex59)
          <=> v493(VarCurr,bitIndex674) )
          & ( v586(VarNext,bitIndex58)
          <=> v493(VarCurr,bitIndex673) )
          & ( v586(VarNext,bitIndex57)
          <=> v493(VarCurr,bitIndex672) )
          & ( v586(VarNext,bitIndex56)
          <=> v493(VarCurr,bitIndex671) )
          & ( v586(VarNext,bitIndex55)
          <=> v493(VarCurr,bitIndex670) )
          & ( v586(VarNext,bitIndex54)
          <=> v493(VarCurr,bitIndex669) )
          & ( v586(VarNext,bitIndex53)
          <=> v493(VarCurr,bitIndex668) )
          & ( v586(VarNext,bitIndex52)
          <=> v493(VarCurr,bitIndex667) )
          & ( v586(VarNext,bitIndex51)
          <=> v493(VarCurr,bitIndex666) )
          & ( v586(VarNext,bitIndex50)
          <=> v493(VarCurr,bitIndex665) )
          & ( v586(VarNext,bitIndex49)
          <=> v493(VarCurr,bitIndex664) )
          & ( v586(VarNext,bitIndex48)
          <=> v493(VarCurr,bitIndex663) )
          & ( v586(VarNext,bitIndex47)
          <=> v493(VarCurr,bitIndex662) )
          & ( v586(VarNext,bitIndex46)
          <=> v493(VarCurr,bitIndex661) )
          & ( v586(VarNext,bitIndex45)
          <=> v493(VarCurr,bitIndex660) )
          & ( v586(VarNext,bitIndex44)
          <=> v493(VarCurr,bitIndex659) )
          & ( v586(VarNext,bitIndex43)
          <=> v493(VarCurr,bitIndex658) )
          & ( v586(VarNext,bitIndex42)
          <=> v493(VarCurr,bitIndex657) )
          & ( v586(VarNext,bitIndex41)
          <=> v493(VarCurr,bitIndex656) )
          & ( v586(VarNext,bitIndex40)
          <=> v493(VarCurr,bitIndex655) )
          & ( v586(VarNext,bitIndex39)
          <=> v493(VarCurr,bitIndex654) )
          & ( v586(VarNext,bitIndex38)
          <=> v493(VarCurr,bitIndex653) )
          & ( v586(VarNext,bitIndex37)
          <=> v493(VarCurr,bitIndex652) )
          & ( v586(VarNext,bitIndex36)
          <=> v493(VarCurr,bitIndex651) )
          & ( v586(VarNext,bitIndex35)
          <=> v493(VarCurr,bitIndex650) )
          & ( v586(VarNext,bitIndex34)
          <=> v493(VarCurr,bitIndex649) )
          & ( v586(VarNext,bitIndex33)
          <=> v493(VarCurr,bitIndex648) )
          & ( v586(VarNext,bitIndex32)
          <=> v493(VarCurr,bitIndex647) )
          & ( v586(VarNext,bitIndex31)
          <=> v493(VarCurr,bitIndex646) )
          & ( v586(VarNext,bitIndex30)
          <=> v493(VarCurr,bitIndex645) )
          & ( v586(VarNext,bitIndex29)
          <=> v493(VarCurr,bitIndex644) )
          & ( v586(VarNext,bitIndex28)
          <=> v493(VarCurr,bitIndex643) )
          & ( v586(VarNext,bitIndex27)
          <=> v493(VarCurr,bitIndex642) )
          & ( v586(VarNext,bitIndex26)
          <=> v493(VarCurr,bitIndex641) )
          & ( v586(VarNext,bitIndex25)
          <=> v493(VarCurr,bitIndex640) )
          & ( v586(VarNext,bitIndex24)
          <=> v493(VarCurr,bitIndex639) )
          & ( v586(VarNext,bitIndex23)
          <=> v493(VarCurr,bitIndex638) )
          & ( v586(VarNext,bitIndex22)
          <=> v493(VarCurr,bitIndex637) )
          & ( v586(VarNext,bitIndex21)
          <=> v493(VarCurr,bitIndex636) )
          & ( v586(VarNext,bitIndex20)
          <=> v493(VarCurr,bitIndex635) )
          & ( v586(VarNext,bitIndex19)
          <=> v493(VarCurr,bitIndex634) )
          & ( v586(VarNext,bitIndex18)
          <=> v493(VarCurr,bitIndex633) )
          & ( v586(VarNext,bitIndex17)
          <=> v493(VarCurr,bitIndex632) )
          & ( v586(VarNext,bitIndex16)
          <=> v493(VarCurr,bitIndex631) )
          & ( v586(VarNext,bitIndex15)
          <=> v493(VarCurr,bitIndex630) )
          & ( v586(VarNext,bitIndex14)
          <=> v493(VarCurr,bitIndex629) )
          & ( v586(VarNext,bitIndex13)
          <=> v493(VarCurr,bitIndex628) )
          & ( v586(VarNext,bitIndex12)
          <=> v493(VarCurr,bitIndex627) )
          & ( v586(VarNext,bitIndex11)
          <=> v493(VarCurr,bitIndex626) )
          & ( v586(VarNext,bitIndex10)
          <=> v493(VarCurr,bitIndex625) )
          & ( v586(VarNext,bitIndex9)
          <=> v493(VarCurr,bitIndex624) )
          & ( v586(VarNext,bitIndex8)
          <=> v493(VarCurr,bitIndex623) )
          & ( v586(VarNext,bitIndex7)
          <=> v493(VarCurr,bitIndex622) )
          & ( v586(VarNext,bitIndex6)
          <=> v493(VarCurr,bitIndex621) )
          & ( v586(VarNext,bitIndex5)
          <=> v493(VarCurr,bitIndex620) )
          & ( v586(VarNext,bitIndex4)
          <=> v493(VarCurr,bitIndex619) )
          & ( v586(VarNext,bitIndex3)
          <=> v493(VarCurr,bitIndex618) )
          & ( v586(VarNext,bitIndex2)
          <=> v493(VarCurr,bitIndex617) )
          & ( v586(VarNext,bitIndex1)
          <=> v493(VarCurr,bitIndex616) )
          & ( v586(VarNext,bitIndex0)
          <=> v493(VarCurr,bitIndex615) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarNext] :
      ( v588(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v586(VarNext,B)
          <=> v573(VarNext,B) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_64,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v588(VarNext)
      <=> ( v589(VarNext)
          & v554(VarNext) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_63,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v589(VarNext)
      <=> ( v591(VarNext)
          & v459(VarNext) ) ) ) ).

fof(writeUnaryOperator_41,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v591(VarNext)
      <=> v466(VarNext) ) ) ).

fof(addAssignment_170,axiom,
    ! [VarCurr] :
      ( v538(VarCurr,bitIndex81)
    <=> v543(VarCurr,bitIndex81) ) ).

fof(addAssignment_169,axiom,
    ! [VarCurr] :
      ( v542(VarCurr,bitIndex81)
    <=> v493(VarCurr,bitIndex573) ) ).

fof(addAssignment_168,axiom,
    ! [VarCurr] :
      ( v496(VarCurr,bitIndex81)
    <=> v536(VarCurr,bitIndex81) ) ).

fof(addAssignment_167,axiom,
    ! [VarCurr] :
      ( v535(VarCurr,bitIndex81)
    <=> v493(VarCurr,bitIndex696) ) ).

fof(addAssignment_166,axiom,
    ! [VarCurr] :
      ( v519(VarCurr,bitIndex81)
    <=> v521(VarCurr,bitIndex81) ) ).

fof(addAssignment_165,axiom,
    ! [VarCurr] :
      ( v521(VarCurr,bitIndex81)
    <=> v523(VarCurr,bitIndex81) ) ).

fof(addAssignment_164,axiom,
    ! [VarCurr] :
      ( v523(VarCurr,bitIndex81)
    <=> v525(VarCurr,bitIndex81) ) ).

fof(addAssignment_163,axiom,
    ! [VarCurr] :
      ( v525(VarCurr,bitIndex81)
    <=> v527(VarCurr,bitIndex81) ) ).

fof(addAssignment_162,axiom,
    ! [VarCurr] :
      ( v527(VarCurr,bitIndex81)
    <=> v529(VarCurr,bitIndex81) ) ).

fof(addAssignment_161,axiom,
    ! [VarCurr] :
      ( v529(VarCurr,bitIndex81)
    <=> v531(VarCurr,bitIndex81) ) ).

fof(addAssignment_160,axiom,
    ! [VarCurr] :
      ( v531(VarCurr,bitIndex81)
    <=> v533(VarCurr,bitIndex81) ) ).

fof(addAssignment_159,axiom,
    ! [VarCurr] :
      ( ( v487(VarCurr,bitIndex6)
      <=> v489(VarCurr,bitIndex122) )
      & ( v487(VarCurr,bitIndex5)
      <=> v489(VarCurr,bitIndex121) )
      & ( v487(VarCurr,bitIndex4)
      <=> v489(VarCurr,bitIndex120) )
      & ( v487(VarCurr,bitIndex3)
      <=> v489(VarCurr,bitIndex119) )
      & ( v487(VarCurr,bitIndex2)
      <=> v489(VarCurr,bitIndex118) )
      & ( v487(VarCurr,bitIndex1)
      <=> v489(VarCurr,bitIndex117) )
      & ( v487(VarCurr,bitIndex0)
      <=> v489(VarCurr,bitIndex116) ) ) ).

fof(addAssignment_158,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v489(VarCurr,B)
      <=> v491(VarCurr,B) ) ) ).

fof(addAssignment_157,axiom,
    ! [VarCurr] :
      ( ( v491(VarCurr,bitIndex122)
      <=> v493(VarCurr,bitIndex737) )
      & ( v491(VarCurr,bitIndex121)
      <=> v493(VarCurr,bitIndex736) )
      & ( v491(VarCurr,bitIndex120)
      <=> v493(VarCurr,bitIndex735) )
      & ( v491(VarCurr,bitIndex119)
      <=> v493(VarCurr,bitIndex734) )
      & ( v491(VarCurr,bitIndex118)
      <=> v493(VarCurr,bitIndex733) )
      & ( v491(VarCurr,bitIndex117)
      <=> v493(VarCurr,bitIndex732) )
      & ( v491(VarCurr,bitIndex116)
      <=> v493(VarCurr,bitIndex731) ) ) ).

fof(addAssignment_156,axiom,
    ! [VarNext] :
      ( ( v493(VarNext,bitIndex737)
      <=> v545(VarNext,bitIndex122) )
      & ( v493(VarNext,bitIndex736)
      <=> v545(VarNext,bitIndex121) )
      & ( v493(VarNext,bitIndex735)
      <=> v545(VarNext,bitIndex120) )
      & ( v493(VarNext,bitIndex734)
      <=> v545(VarNext,bitIndex119) )
      & ( v493(VarNext,bitIndex733)
      <=> v545(VarNext,bitIndex118) )
      & ( v493(VarNext,bitIndex732)
      <=> v545(VarNext,bitIndex117) )
      & ( v493(VarNext,bitIndex731)
      <=> v545(VarNext,bitIndex116) ) ) ).

fof(addCaseBooleanConditionShiftedRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v546(VarNext)
       => ( ( v545(VarNext,bitIndex122)
          <=> v493(VarCurr,bitIndex737) )
          & ( v545(VarNext,bitIndex121)
          <=> v493(VarCurr,bitIndex736) )
          & ( v545(VarNext,bitIndex120)
          <=> v493(VarCurr,bitIndex735) )
          & ( v545(VarNext,bitIndex119)
          <=> v493(VarCurr,bitIndex734) )
          & ( v545(VarNext,bitIndex118)
          <=> v493(VarCurr,bitIndex733) )
          & ( v545(VarNext,bitIndex117)
          <=> v493(VarCurr,bitIndex732) )
          & ( v545(VarNext,bitIndex116)
          <=> v493(VarCurr,bitIndex731) )
          & ( v545(VarNext,bitIndex115)
          <=> v493(VarCurr,bitIndex730) )
          & ( v545(VarNext,bitIndex114)
          <=> v493(VarCurr,bitIndex729) )
          & ( v545(VarNext,bitIndex113)
          <=> v493(VarCurr,bitIndex728) )
          & ( v545(VarNext,bitIndex112)
          <=> v493(VarCurr,bitIndex727) )
          & ( v545(VarNext,bitIndex111)
          <=> v493(VarCurr,bitIndex726) )
          & ( v545(VarNext,bitIndex110)
          <=> v493(VarCurr,bitIndex725) )
          & ( v545(VarNext,bitIndex109)
          <=> v493(VarCurr,bitIndex724) )
          & ( v545(VarNext,bitIndex108)
          <=> v493(VarCurr,bitIndex723) )
          & ( v545(VarNext,bitIndex107)
          <=> v493(VarCurr,bitIndex722) )
          & ( v545(VarNext,bitIndex106)
          <=> v493(VarCurr,bitIndex721) )
          & ( v545(VarNext,bitIndex105)
          <=> v493(VarCurr,bitIndex720) )
          & ( v545(VarNext,bitIndex104)
          <=> v493(VarCurr,bitIndex719) )
          & ( v545(VarNext,bitIndex103)
          <=> v493(VarCurr,bitIndex718) )
          & ( v545(VarNext,bitIndex102)
          <=> v493(VarCurr,bitIndex717) )
          & ( v545(VarNext,bitIndex101)
          <=> v493(VarCurr,bitIndex716) )
          & ( v545(VarNext,bitIndex100)
          <=> v493(VarCurr,bitIndex715) )
          & ( v545(VarNext,bitIndex99)
          <=> v493(VarCurr,bitIndex714) )
          & ( v545(VarNext,bitIndex98)
          <=> v493(VarCurr,bitIndex713) )
          & ( v545(VarNext,bitIndex97)
          <=> v493(VarCurr,bitIndex712) )
          & ( v545(VarNext,bitIndex96)
          <=> v493(VarCurr,bitIndex711) )
          & ( v545(VarNext,bitIndex95)
          <=> v493(VarCurr,bitIndex710) )
          & ( v545(VarNext,bitIndex94)
          <=> v493(VarCurr,bitIndex709) )
          & ( v545(VarNext,bitIndex93)
          <=> v493(VarCurr,bitIndex708) )
          & ( v545(VarNext,bitIndex92)
          <=> v493(VarCurr,bitIndex707) )
          & ( v545(VarNext,bitIndex91)
          <=> v493(VarCurr,bitIndex706) )
          & ( v545(VarNext,bitIndex90)
          <=> v493(VarCurr,bitIndex705) )
          & ( v545(VarNext,bitIndex89)
          <=> v493(VarCurr,bitIndex704) )
          & ( v545(VarNext,bitIndex88)
          <=> v493(VarCurr,bitIndex703) )
          & ( v545(VarNext,bitIndex87)
          <=> v493(VarCurr,bitIndex702) )
          & ( v545(VarNext,bitIndex86)
          <=> v493(VarCurr,bitIndex701) )
          & ( v545(VarNext,bitIndex85)
          <=> v493(VarCurr,bitIndex700) )
          & ( v545(VarNext,bitIndex84)
          <=> v493(VarCurr,bitIndex699) )
          & ( v545(VarNext,bitIndex83)
          <=> v493(VarCurr,bitIndex698) )
          & ( v545(VarNext,bitIndex82)
          <=> v493(VarCurr,bitIndex697) )
          & ( v545(VarNext,bitIndex81)
          <=> v493(VarCurr,bitIndex696) )
          & ( v545(VarNext,bitIndex80)
          <=> v493(VarCurr,bitIndex695) )
          & ( v545(VarNext,bitIndex79)
          <=> v493(VarCurr,bitIndex694) )
          & ( v545(VarNext,bitIndex78)
          <=> v493(VarCurr,bitIndex693) )
          & ( v545(VarNext,bitIndex77)
          <=> v493(VarCurr,bitIndex692) )
          & ( v545(VarNext,bitIndex76)
          <=> v493(VarCurr,bitIndex691) )
          & ( v545(VarNext,bitIndex75)
          <=> v493(VarCurr,bitIndex690) )
          & ( v545(VarNext,bitIndex74)
          <=> v493(VarCurr,bitIndex689) )
          & ( v545(VarNext,bitIndex73)
          <=> v493(VarCurr,bitIndex688) )
          & ( v545(VarNext,bitIndex72)
          <=> v493(VarCurr,bitIndex687) )
          & ( v545(VarNext,bitIndex71)
          <=> v493(VarCurr,bitIndex686) )
          & ( v545(VarNext,bitIndex70)
          <=> v493(VarCurr,bitIndex685) )
          & ( v545(VarNext,bitIndex69)
          <=> v493(VarCurr,bitIndex684) )
          & ( v545(VarNext,bitIndex68)
          <=> v493(VarCurr,bitIndex683) )
          & ( v545(VarNext,bitIndex67)
          <=> v493(VarCurr,bitIndex682) )
          & ( v545(VarNext,bitIndex66)
          <=> v493(VarCurr,bitIndex681) )
          & ( v545(VarNext,bitIndex65)
          <=> v493(VarCurr,bitIndex680) )
          & ( v545(VarNext,bitIndex64)
          <=> v493(VarCurr,bitIndex679) )
          & ( v545(VarNext,bitIndex63)
          <=> v493(VarCurr,bitIndex678) )
          & ( v545(VarNext,bitIndex62)
          <=> v493(VarCurr,bitIndex677) )
          & ( v545(VarNext,bitIndex61)
          <=> v493(VarCurr,bitIndex676) )
          & ( v545(VarNext,bitIndex60)
          <=> v493(VarCurr,bitIndex675) )
          & ( v545(VarNext,bitIndex59)
          <=> v493(VarCurr,bitIndex674) )
          & ( v545(VarNext,bitIndex58)
          <=> v493(VarCurr,bitIndex673) )
          & ( v545(VarNext,bitIndex57)
          <=> v493(VarCurr,bitIndex672) )
          & ( v545(VarNext,bitIndex56)
          <=> v493(VarCurr,bitIndex671) )
          & ( v545(VarNext,bitIndex55)
          <=> v493(VarCurr,bitIndex670) )
          & ( v545(VarNext,bitIndex54)
          <=> v493(VarCurr,bitIndex669) )
          & ( v545(VarNext,bitIndex53)
          <=> v493(VarCurr,bitIndex668) )
          & ( v545(VarNext,bitIndex52)
          <=> v493(VarCurr,bitIndex667) )
          & ( v545(VarNext,bitIndex51)
          <=> v493(VarCurr,bitIndex666) )
          & ( v545(VarNext,bitIndex50)
          <=> v493(VarCurr,bitIndex665) )
          & ( v545(VarNext,bitIndex49)
          <=> v493(VarCurr,bitIndex664) )
          & ( v545(VarNext,bitIndex48)
          <=> v493(VarCurr,bitIndex663) )
          & ( v545(VarNext,bitIndex47)
          <=> v493(VarCurr,bitIndex662) )
          & ( v545(VarNext,bitIndex46)
          <=> v493(VarCurr,bitIndex661) )
          & ( v545(VarNext,bitIndex45)
          <=> v493(VarCurr,bitIndex660) )
          & ( v545(VarNext,bitIndex44)
          <=> v493(VarCurr,bitIndex659) )
          & ( v545(VarNext,bitIndex43)
          <=> v493(VarCurr,bitIndex658) )
          & ( v545(VarNext,bitIndex42)
          <=> v493(VarCurr,bitIndex657) )
          & ( v545(VarNext,bitIndex41)
          <=> v493(VarCurr,bitIndex656) )
          & ( v545(VarNext,bitIndex40)
          <=> v493(VarCurr,bitIndex655) )
          & ( v545(VarNext,bitIndex39)
          <=> v493(VarCurr,bitIndex654) )
          & ( v545(VarNext,bitIndex38)
          <=> v493(VarCurr,bitIndex653) )
          & ( v545(VarNext,bitIndex37)
          <=> v493(VarCurr,bitIndex652) )
          & ( v545(VarNext,bitIndex36)
          <=> v493(VarCurr,bitIndex651) )
          & ( v545(VarNext,bitIndex35)
          <=> v493(VarCurr,bitIndex650) )
          & ( v545(VarNext,bitIndex34)
          <=> v493(VarCurr,bitIndex649) )
          & ( v545(VarNext,bitIndex33)
          <=> v493(VarCurr,bitIndex648) )
          & ( v545(VarNext,bitIndex32)
          <=> v493(VarCurr,bitIndex647) )
          & ( v545(VarNext,bitIndex31)
          <=> v493(VarCurr,bitIndex646) )
          & ( v545(VarNext,bitIndex30)
          <=> v493(VarCurr,bitIndex645) )
          & ( v545(VarNext,bitIndex29)
          <=> v493(VarCurr,bitIndex644) )
          & ( v545(VarNext,bitIndex28)
          <=> v493(VarCurr,bitIndex643) )
          & ( v545(VarNext,bitIndex27)
          <=> v493(VarCurr,bitIndex642) )
          & ( v545(VarNext,bitIndex26)
          <=> v493(VarCurr,bitIndex641) )
          & ( v545(VarNext,bitIndex25)
          <=> v493(VarCurr,bitIndex640) )
          & ( v545(VarNext,bitIndex24)
          <=> v493(VarCurr,bitIndex639) )
          & ( v545(VarNext,bitIndex23)
          <=> v493(VarCurr,bitIndex638) )
          & ( v545(VarNext,bitIndex22)
          <=> v493(VarCurr,bitIndex637) )
          & ( v545(VarNext,bitIndex21)
          <=> v493(VarCurr,bitIndex636) )
          & ( v545(VarNext,bitIndex20)
          <=> v493(VarCurr,bitIndex635) )
          & ( v545(VarNext,bitIndex19)
          <=> v493(VarCurr,bitIndex634) )
          & ( v545(VarNext,bitIndex18)
          <=> v493(VarCurr,bitIndex633) )
          & ( v545(VarNext,bitIndex17)
          <=> v493(VarCurr,bitIndex632) )
          & ( v545(VarNext,bitIndex16)
          <=> v493(VarCurr,bitIndex631) )
          & ( v545(VarNext,bitIndex15)
          <=> v493(VarCurr,bitIndex630) )
          & ( v545(VarNext,bitIndex14)
          <=> v493(VarCurr,bitIndex629) )
          & ( v545(VarNext,bitIndex13)
          <=> v493(VarCurr,bitIndex628) )
          & ( v545(VarNext,bitIndex12)
          <=> v493(VarCurr,bitIndex627) )
          & ( v545(VarNext,bitIndex11)
          <=> v493(VarCurr,bitIndex626) )
          & ( v545(VarNext,bitIndex10)
          <=> v493(VarCurr,bitIndex625) )
          & ( v545(VarNext,bitIndex9)
          <=> v493(VarCurr,bitIndex624) )
          & ( v545(VarNext,bitIndex8)
          <=> v493(VarCurr,bitIndex623) )
          & ( v545(VarNext,bitIndex7)
          <=> v493(VarCurr,bitIndex622) )
          & ( v545(VarNext,bitIndex6)
          <=> v493(VarCurr,bitIndex621) )
          & ( v545(VarNext,bitIndex5)
          <=> v493(VarCurr,bitIndex620) )
          & ( v545(VarNext,bitIndex4)
          <=> v493(VarCurr,bitIndex619) )
          & ( v545(VarNext,bitIndex3)
          <=> v493(VarCurr,bitIndex618) )
          & ( v545(VarNext,bitIndex2)
          <=> v493(VarCurr,bitIndex617) )
          & ( v545(VarNext,bitIndex1)
          <=> v493(VarCurr,bitIndex616) )
          & ( v545(VarNext,bitIndex0)
          <=> v493(VarCurr,bitIndex615) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarNext] :
      ( v546(VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v545(VarNext,B)
          <=> v573(VarNext,B) ) ) ) ).

fof(addAssignment_155,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_122_0(B)
         => ( v573(VarNext,B)
          <=> v571(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_9,axiom,
    ! [VarCurr] :
      ( ~ v556(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v571(VarCurr,B)
          <=> v574(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_8,axiom,
    ! [VarCurr] :
      ( v556(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v571(VarCurr,B)
          <=> $false ) ) ) ).

fof(bitBlastConstant_182,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex122) ).

fof(bitBlastConstant_181,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex121) ).

fof(bitBlastConstant_180,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex120) ).

fof(bitBlastConstant_179,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex119) ).

fof(bitBlastConstant_178,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex118) ).

fof(bitBlastConstant_177,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex117) ).

fof(bitBlastConstant_176,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex116) ).

fof(bitBlastConstant_175,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex115) ).

fof(bitBlastConstant_174,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex114) ).

fof(bitBlastConstant_173,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex113) ).

fof(bitBlastConstant_172,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex112) ).

fof(bitBlastConstant_171,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex111) ).

fof(bitBlastConstant_170,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex110) ).

fof(bitBlastConstant_169,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex109) ).

fof(bitBlastConstant_168,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex108) ).

fof(bitBlastConstant_167,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex107) ).

fof(bitBlastConstant_166,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex106) ).

fof(bitBlastConstant_165,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex105) ).

fof(bitBlastConstant_164,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex104) ).

fof(bitBlastConstant_163,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex103) ).

fof(bitBlastConstant_162,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex102) ).

fof(bitBlastConstant_161,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex101) ).

fof(bitBlastConstant_160,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex100) ).

fof(bitBlastConstant_159,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex99) ).

fof(bitBlastConstant_158,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex98) ).

fof(bitBlastConstant_157,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex97) ).

fof(bitBlastConstant_156,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex96) ).

fof(bitBlastConstant_155,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex95) ).

fof(bitBlastConstant_154,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex94) ).

fof(bitBlastConstant_153,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex93) ).

fof(bitBlastConstant_152,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex92) ).

fof(bitBlastConstant_151,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex91) ).

fof(bitBlastConstant_150,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex90) ).

fof(bitBlastConstant_149,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex89) ).

fof(bitBlastConstant_148,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex88) ).

fof(bitBlastConstant_147,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex87) ).

fof(bitBlastConstant_146,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex86) ).

fof(bitBlastConstant_145,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex85) ).

fof(bitBlastConstant_144,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex84) ).

fof(bitBlastConstant_143,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex83) ).

fof(bitBlastConstant_142,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex82) ).

fof(bitBlastConstant_141,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex81) ).

fof(bitBlastConstant_140,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex80) ).

fof(bitBlastConstant_139,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex79) ).

fof(bitBlastConstant_138,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex78) ).

fof(bitBlastConstant_137,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex77) ).

fof(bitBlastConstant_136,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex76) ).

fof(bitBlastConstant_135,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex75) ).

fof(bitBlastConstant_134,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex74) ).

fof(bitBlastConstant_133,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex73) ).

fof(bitBlastConstant_132,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex72) ).

fof(bitBlastConstant_131,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex71) ).

fof(bitBlastConstant_130,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex70) ).

fof(bitBlastConstant_129,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex69) ).

fof(bitBlastConstant_128,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex68) ).

fof(bitBlastConstant_127,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex67) ).

fof(bitBlastConstant_126,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex66) ).

fof(bitBlastConstant_125,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex65) ).

fof(bitBlastConstant_124,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex64) ).

fof(bitBlastConstant_123,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex63) ).

fof(bitBlastConstant_122,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex62) ).

fof(bitBlastConstant_121,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex61) ).

fof(bitBlastConstant_120,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex60) ).

fof(bitBlastConstant_119,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex59) ).

fof(bitBlastConstant_118,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex58) ).

fof(bitBlastConstant_117,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex57) ).

fof(bitBlastConstant_116,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex56) ).

fof(bitBlastConstant_115,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex55) ).

fof(bitBlastConstant_114,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex54) ).

fof(bitBlastConstant_113,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex53) ).

fof(bitBlastConstant_112,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex52) ).

fof(bitBlastConstant_111,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex51) ).

fof(bitBlastConstant_110,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex50) ).

fof(bitBlastConstant_109,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex49) ).

fof(bitBlastConstant_108,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex48) ).

fof(bitBlastConstant_107,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex47) ).

fof(bitBlastConstant_106,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex46) ).

fof(bitBlastConstant_105,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex45) ).

fof(bitBlastConstant_104,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex44) ).

fof(bitBlastConstant_103,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex43) ).

fof(bitBlastConstant_102,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex42) ).

fof(bitBlastConstant_101,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex41) ).

fof(bitBlastConstant_100,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex40) ).

fof(bitBlastConstant_99,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex39) ).

fof(bitBlastConstant_98,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex38) ).

fof(bitBlastConstant_97,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex37) ).

fof(bitBlastConstant_96,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex36) ).

fof(bitBlastConstant_95,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex35) ).

fof(bitBlastConstant_94,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex34) ).

fof(bitBlastConstant_93,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex33) ).

fof(bitBlastConstant_92,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex32) ).

fof(bitBlastConstant_91,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_90,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_89,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_88,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_87,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_86,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_85,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_84,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_83,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_82,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_81,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_80,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_79,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_78,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_77,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_76,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_75,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_74,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_73,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_72,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_71,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_70,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_69,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_68,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_67,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_66,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_65,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_64,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_63,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_62,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_61,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_60,axiom,
    ~ b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000(bitIndex0) ).

fof(addParallelCaseBooleanConditionEqualRanges2_4,axiom,
    ! [VarCurr] :
      ( ( ~ v560(VarCurr)
        & ~ v562(VarCurr) )
     => ! [B] :
          ( range_122_0(B)
         => ( v574(VarCurr,B)
          <=> v538(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_8,axiom,
    ! [VarCurr] :
      ( v562(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v574(VarCurr,B)
          <=> v496(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionShiftedRanges0,axiom,
    ! [VarCurr] :
      ( v560(VarCurr)
     => ( ( v574(VarCurr,bitIndex122)
        <=> v493(VarCurr,bitIndex614) )
        & ( v574(VarCurr,bitIndex121)
        <=> v493(VarCurr,bitIndex613) )
        & ( v574(VarCurr,bitIndex120)
        <=> v493(VarCurr,bitIndex612) )
        & ( v574(VarCurr,bitIndex119)
        <=> v493(VarCurr,bitIndex611) )
        & ( v574(VarCurr,bitIndex118)
        <=> v493(VarCurr,bitIndex610) )
        & ( v574(VarCurr,bitIndex117)
        <=> v493(VarCurr,bitIndex609) )
        & ( v574(VarCurr,bitIndex116)
        <=> v493(VarCurr,bitIndex608) )
        & ( v574(VarCurr,bitIndex115)
        <=> v493(VarCurr,bitIndex607) )
        & ( v574(VarCurr,bitIndex114)
        <=> v493(VarCurr,bitIndex606) )
        & ( v574(VarCurr,bitIndex113)
        <=> v493(VarCurr,bitIndex605) )
        & ( v574(VarCurr,bitIndex112)
        <=> v493(VarCurr,bitIndex604) )
        & ( v574(VarCurr,bitIndex111)
        <=> v493(VarCurr,bitIndex603) )
        & ( v574(VarCurr,bitIndex110)
        <=> v493(VarCurr,bitIndex602) )
        & ( v574(VarCurr,bitIndex109)
        <=> v493(VarCurr,bitIndex601) )
        & ( v574(VarCurr,bitIndex108)
        <=> v493(VarCurr,bitIndex600) )
        & ( v574(VarCurr,bitIndex107)
        <=> v493(VarCurr,bitIndex599) )
        & ( v574(VarCurr,bitIndex106)
        <=> v493(VarCurr,bitIndex598) )
        & ( v574(VarCurr,bitIndex105)
        <=> v493(VarCurr,bitIndex597) )
        & ( v574(VarCurr,bitIndex104)
        <=> v493(VarCurr,bitIndex596) )
        & ( v574(VarCurr,bitIndex103)
        <=> v493(VarCurr,bitIndex595) )
        & ( v574(VarCurr,bitIndex102)
        <=> v493(VarCurr,bitIndex594) )
        & ( v574(VarCurr,bitIndex101)
        <=> v493(VarCurr,bitIndex593) )
        & ( v574(VarCurr,bitIndex100)
        <=> v493(VarCurr,bitIndex592) )
        & ( v574(VarCurr,bitIndex99)
        <=> v493(VarCurr,bitIndex591) )
        & ( v574(VarCurr,bitIndex98)
        <=> v493(VarCurr,bitIndex590) )
        & ( v574(VarCurr,bitIndex97)
        <=> v493(VarCurr,bitIndex589) )
        & ( v574(VarCurr,bitIndex96)
        <=> v493(VarCurr,bitIndex588) )
        & ( v574(VarCurr,bitIndex95)
        <=> v493(VarCurr,bitIndex587) )
        & ( v574(VarCurr,bitIndex94)
        <=> v493(VarCurr,bitIndex586) )
        & ( v574(VarCurr,bitIndex93)
        <=> v493(VarCurr,bitIndex585) )
        & ( v574(VarCurr,bitIndex92)
        <=> v493(VarCurr,bitIndex584) )
        & ( v574(VarCurr,bitIndex91)
        <=> v493(VarCurr,bitIndex583) )
        & ( v574(VarCurr,bitIndex90)
        <=> v493(VarCurr,bitIndex582) )
        & ( v574(VarCurr,bitIndex89)
        <=> v493(VarCurr,bitIndex581) )
        & ( v574(VarCurr,bitIndex88)
        <=> v493(VarCurr,bitIndex580) )
        & ( v574(VarCurr,bitIndex87)
        <=> v493(VarCurr,bitIndex579) )
        & ( v574(VarCurr,bitIndex86)
        <=> v493(VarCurr,bitIndex578) )
        & ( v574(VarCurr,bitIndex85)
        <=> v493(VarCurr,bitIndex577) )
        & ( v574(VarCurr,bitIndex84)
        <=> v493(VarCurr,bitIndex576) )
        & ( v574(VarCurr,bitIndex83)
        <=> v493(VarCurr,bitIndex575) )
        & ( v574(VarCurr,bitIndex82)
        <=> v493(VarCurr,bitIndex574) )
        & ( v574(VarCurr,bitIndex81)
        <=> v493(VarCurr,bitIndex573) )
        & ( v574(VarCurr,bitIndex80)
        <=> v493(VarCurr,bitIndex572) )
        & ( v574(VarCurr,bitIndex79)
        <=> v493(VarCurr,bitIndex571) )
        & ( v574(VarCurr,bitIndex78)
        <=> v493(VarCurr,bitIndex570) )
        & ( v574(VarCurr,bitIndex77)
        <=> v493(VarCurr,bitIndex569) )
        & ( v574(VarCurr,bitIndex76)
        <=> v493(VarCurr,bitIndex568) )
        & ( v574(VarCurr,bitIndex75)
        <=> v493(VarCurr,bitIndex567) )
        & ( v574(VarCurr,bitIndex74)
        <=> v493(VarCurr,bitIndex566) )
        & ( v574(VarCurr,bitIndex73)
        <=> v493(VarCurr,bitIndex565) )
        & ( v574(VarCurr,bitIndex72)
        <=> v493(VarCurr,bitIndex564) )
        & ( v574(VarCurr,bitIndex71)
        <=> v493(VarCurr,bitIndex563) )
        & ( v574(VarCurr,bitIndex70)
        <=> v493(VarCurr,bitIndex562) )
        & ( v574(VarCurr,bitIndex69)
        <=> v493(VarCurr,bitIndex561) )
        & ( v574(VarCurr,bitIndex68)
        <=> v493(VarCurr,bitIndex560) )
        & ( v574(VarCurr,bitIndex67)
        <=> v493(VarCurr,bitIndex559) )
        & ( v574(VarCurr,bitIndex66)
        <=> v493(VarCurr,bitIndex558) )
        & ( v574(VarCurr,bitIndex65)
        <=> v493(VarCurr,bitIndex557) )
        & ( v574(VarCurr,bitIndex64)
        <=> v493(VarCurr,bitIndex556) )
        & ( v574(VarCurr,bitIndex63)
        <=> v493(VarCurr,bitIndex555) )
        & ( v574(VarCurr,bitIndex62)
        <=> v493(VarCurr,bitIndex554) )
        & ( v574(VarCurr,bitIndex61)
        <=> v493(VarCurr,bitIndex553) )
        & ( v574(VarCurr,bitIndex60)
        <=> v493(VarCurr,bitIndex552) )
        & ( v574(VarCurr,bitIndex59)
        <=> v493(VarCurr,bitIndex551) )
        & ( v574(VarCurr,bitIndex58)
        <=> v493(VarCurr,bitIndex550) )
        & ( v574(VarCurr,bitIndex57)
        <=> v493(VarCurr,bitIndex549) )
        & ( v574(VarCurr,bitIndex56)
        <=> v493(VarCurr,bitIndex548) )
        & ( v574(VarCurr,bitIndex55)
        <=> v493(VarCurr,bitIndex547) )
        & ( v574(VarCurr,bitIndex54)
        <=> v493(VarCurr,bitIndex546) )
        & ( v574(VarCurr,bitIndex53)
        <=> v493(VarCurr,bitIndex545) )
        & ( v574(VarCurr,bitIndex52)
        <=> v493(VarCurr,bitIndex544) )
        & ( v574(VarCurr,bitIndex51)
        <=> v493(VarCurr,bitIndex543) )
        & ( v574(VarCurr,bitIndex50)
        <=> v493(VarCurr,bitIndex542) )
        & ( v574(VarCurr,bitIndex49)
        <=> v493(VarCurr,bitIndex541) )
        & ( v574(VarCurr,bitIndex48)
        <=> v493(VarCurr,bitIndex540) )
        & ( v574(VarCurr,bitIndex47)
        <=> v493(VarCurr,bitIndex539) )
        & ( v574(VarCurr,bitIndex46)
        <=> v493(VarCurr,bitIndex538) )
        & ( v574(VarCurr,bitIndex45)
        <=> v493(VarCurr,bitIndex537) )
        & ( v574(VarCurr,bitIndex44)
        <=> v493(VarCurr,bitIndex536) )
        & ( v574(VarCurr,bitIndex43)
        <=> v493(VarCurr,bitIndex535) )
        & ( v574(VarCurr,bitIndex42)
        <=> v493(VarCurr,bitIndex534) )
        & ( v574(VarCurr,bitIndex41)
        <=> v493(VarCurr,bitIndex533) )
        & ( v574(VarCurr,bitIndex40)
        <=> v493(VarCurr,bitIndex532) )
        & ( v574(VarCurr,bitIndex39)
        <=> v493(VarCurr,bitIndex531) )
        & ( v574(VarCurr,bitIndex38)
        <=> v493(VarCurr,bitIndex530) )
        & ( v574(VarCurr,bitIndex37)
        <=> v493(VarCurr,bitIndex529) )
        & ( v574(VarCurr,bitIndex36)
        <=> v493(VarCurr,bitIndex528) )
        & ( v574(VarCurr,bitIndex35)
        <=> v493(VarCurr,bitIndex527) )
        & ( v574(VarCurr,bitIndex34)
        <=> v493(VarCurr,bitIndex526) )
        & ( v574(VarCurr,bitIndex33)
        <=> v493(VarCurr,bitIndex525) )
        & ( v574(VarCurr,bitIndex32)
        <=> v493(VarCurr,bitIndex524) )
        & ( v574(VarCurr,bitIndex31)
        <=> v493(VarCurr,bitIndex523) )
        & ( v574(VarCurr,bitIndex30)
        <=> v493(VarCurr,bitIndex522) )
        & ( v574(VarCurr,bitIndex29)
        <=> v493(VarCurr,bitIndex521) )
        & ( v574(VarCurr,bitIndex28)
        <=> v493(VarCurr,bitIndex520) )
        & ( v574(VarCurr,bitIndex27)
        <=> v493(VarCurr,bitIndex519) )
        & ( v574(VarCurr,bitIndex26)
        <=> v493(VarCurr,bitIndex518) )
        & ( v574(VarCurr,bitIndex25)
        <=> v493(VarCurr,bitIndex517) )
        & ( v574(VarCurr,bitIndex24)
        <=> v493(VarCurr,bitIndex516) )
        & ( v574(VarCurr,bitIndex23)
        <=> v493(VarCurr,bitIndex515) )
        & ( v574(VarCurr,bitIndex22)
        <=> v493(VarCurr,bitIndex514) )
        & ( v574(VarCurr,bitIndex21)
        <=> v493(VarCurr,bitIndex513) )
        & ( v574(VarCurr,bitIndex20)
        <=> v493(VarCurr,bitIndex512) )
        & ( v574(VarCurr,bitIndex19)
        <=> v493(VarCurr,bitIndex511) )
        & ( v574(VarCurr,bitIndex18)
        <=> v493(VarCurr,bitIndex510) )
        & ( v574(VarCurr,bitIndex17)
        <=> v493(VarCurr,bitIndex509) )
        & ( v574(VarCurr,bitIndex16)
        <=> v493(VarCurr,bitIndex508) )
        & ( v574(VarCurr,bitIndex15)
        <=> v493(VarCurr,bitIndex507) )
        & ( v574(VarCurr,bitIndex14)
        <=> v493(VarCurr,bitIndex506) )
        & ( v574(VarCurr,bitIndex13)
        <=> v493(VarCurr,bitIndex505) )
        & ( v574(VarCurr,bitIndex12)
        <=> v493(VarCurr,bitIndex504) )
        & ( v574(VarCurr,bitIndex11)
        <=> v493(VarCurr,bitIndex503) )
        & ( v574(VarCurr,bitIndex10)
        <=> v493(VarCurr,bitIndex502) )
        & ( v574(VarCurr,bitIndex9)
        <=> v493(VarCurr,bitIndex501) )
        & ( v574(VarCurr,bitIndex8)
        <=> v493(VarCurr,bitIndex500) )
        & ( v574(VarCurr,bitIndex7)
        <=> v493(VarCurr,bitIndex499) )
        & ( v574(VarCurr,bitIndex6)
        <=> v493(VarCurr,bitIndex498) )
        & ( v574(VarCurr,bitIndex5)
        <=> v493(VarCurr,bitIndex497) )
        & ( v574(VarCurr,bitIndex4)
        <=> v493(VarCurr,bitIndex496) )
        & ( v574(VarCurr,bitIndex3)
        <=> v493(VarCurr,bitIndex495) )
        & ( v574(VarCurr,bitIndex2)
        <=> v493(VarCurr,bitIndex494) )
        & ( v574(VarCurr,bitIndex1)
        <=> v493(VarCurr,bitIndex493) )
        & ( v574(VarCurr,bitIndex0)
        <=> v493(VarCurr,bitIndex492) ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_62,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v546(VarNext)
      <=> ( v547(VarNext)
          & v554(VarNext) ) ) ) ).

fof(addAssignment_154,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v554(VarNext)
      <=> v552(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_61,axiom,
    ! [VarCurr] :
      ( v552(VarCurr)
    <=> ( v555(VarCurr)
        & v567(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_60,axiom,
    ! [VarCurr] :
      ( v567(VarCurr)
    <=> ( v568(VarCurr)
        | v556(VarCurr) ) ) ).

fof(writeUnaryOperator_40,axiom,
    ! [VarCurr] :
      ( ~ v568(VarCurr)
    <=> v569(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_30,axiom,
    ! [VarCurr] :
      ( v569(VarCurr)
    <=> ( ( v570(VarCurr,bitIndex1)
        <=> $false )
        & ( v570(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_153,axiom,
    ! [VarCurr] :
      ( v570(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_152,axiom,
    ! [VarCurr] :
      ( v570(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_59,axiom,
    ! [VarCurr] :
      ( v555(VarCurr)
    <=> ( v556(VarCurr)
        | v557(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_58,axiom,
    ! [VarCurr] :
      ( v557(VarCurr)
    <=> ( v558(VarCurr)
        & v566(VarCurr) ) ) ).

fof(writeUnaryOperator_39,axiom,
    ! [VarCurr] :
      ( ~ v566(VarCurr)
    <=> v556(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_57,axiom,
    ! [VarCurr] :
      ( v558(VarCurr)
    <=> ( v559(VarCurr)
        | v564(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_29,axiom,
    ! [VarCurr] :
      ( v564(VarCurr)
    <=> ( ( v565(VarCurr,bitIndex1)
        <=> $true )
        & ( v565(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_151,axiom,
    ! [VarCurr] :
      ( v565(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_150,axiom,
    ! [VarCurr] :
      ( v565(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_56,axiom,
    ! [VarCurr] :
      ( v559(VarCurr)
    <=> ( v560(VarCurr)
        | v562(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_28,axiom,
    ! [VarCurr] :
      ( v562(VarCurr)
    <=> ( ( v563(VarCurr,bitIndex1)
        <=> $true )
        & ( v563(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_149,axiom,
    ! [VarCurr] :
      ( v563(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_148,axiom,
    ! [VarCurr] :
      ( v563(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_27,axiom,
    ! [VarCurr] :
      ( v560(VarCurr)
    <=> ( ( v561(VarCurr,bitIndex1)
        <=> $false )
        & ( v561(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_147,axiom,
    ! [VarCurr] :
      ( v561(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_146,axiom,
    ! [VarCurr] :
      ( v561(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(writeUnaryOperator_38,axiom,
    ! [VarCurr] :
      ( ~ v556(VarCurr)
    <=> v94(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_55,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v547(VarNext)
      <=> ( v548(VarNext)
          & v459(VarNext) ) ) ) ).

fof(writeUnaryOperator_37,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v548(VarNext)
      <=> v466(VarNext) ) ) ).

fof(addAssignment_145,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v538(VarCurr,B)
      <=> v543(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_16,axiom,
    ! [VarCurr] :
      ( ~ v540(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v543(VarCurr,B)
          <=> v542(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_16,axiom,
    ! [VarCurr] :
      ( v540(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v543(VarCurr,B)
          <=> v519(VarCurr,B) ) ) ) ).

fof(addAssignment_144,axiom,
    ! [VarCurr] :
      ( ( v542(VarCurr,bitIndex122)
      <=> v493(VarCurr,bitIndex614) )
      & ( v542(VarCurr,bitIndex121)
      <=> v493(VarCurr,bitIndex613) )
      & ( v542(VarCurr,bitIndex120)
      <=> v493(VarCurr,bitIndex612) )
      & ( v542(VarCurr,bitIndex119)
      <=> v493(VarCurr,bitIndex611) )
      & ( v542(VarCurr,bitIndex118)
      <=> v493(VarCurr,bitIndex610) )
      & ( v542(VarCurr,bitIndex117)
      <=> v493(VarCurr,bitIndex609) )
      & ( v542(VarCurr,bitIndex116)
      <=> v493(VarCurr,bitIndex608) ) ) ).

fof(addAssignment_143,axiom,
    ! [VarCurr] :
      ( v540(VarCurr)
    <=> v500(VarCurr,bitIndex1) ) ).

fof(addAssignment_142,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v496(VarCurr,B)
      <=> v536(VarCurr,B) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_15,axiom,
    ! [VarCurr] :
      ( ~ v498(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v536(VarCurr,B)
          <=> v535(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_15,axiom,
    ! [VarCurr] :
      ( v498(VarCurr)
     => ! [B] :
          ( range_122_0(B)
         => ( v536(VarCurr,B)
          <=> v519(VarCurr,B) ) ) ) ).

fof(range_axiom_7,axiom,
    ! [B] :
      ( range_122_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B
        | bitIndex32 = B
        | bitIndex33 = B
        | bitIndex34 = B
        | bitIndex35 = B
        | bitIndex36 = B
        | bitIndex37 = B
        | bitIndex38 = B
        | bitIndex39 = B
        | bitIndex40 = B
        | bitIndex41 = B
        | bitIndex42 = B
        | bitIndex43 = B
        | bitIndex44 = B
        | bitIndex45 = B
        | bitIndex46 = B
        | bitIndex47 = B
        | bitIndex48 = B
        | bitIndex49 = B
        | bitIndex50 = B
        | bitIndex51 = B
        | bitIndex52 = B
        | bitIndex53 = B
        | bitIndex54 = B
        | bitIndex55 = B
        | bitIndex56 = B
        | bitIndex57 = B
        | bitIndex58 = B
        | bitIndex59 = B
        | bitIndex60 = B
        | bitIndex61 = B
        | bitIndex62 = B
        | bitIndex63 = B
        | bitIndex64 = B
        | bitIndex65 = B
        | bitIndex66 = B
        | bitIndex67 = B
        | bitIndex68 = B
        | bitIndex69 = B
        | bitIndex70 = B
        | bitIndex71 = B
        | bitIndex72 = B
        | bitIndex73 = B
        | bitIndex74 = B
        | bitIndex75 = B
        | bitIndex76 = B
        | bitIndex77 = B
        | bitIndex78 = B
        | bitIndex79 = B
        | bitIndex80 = B
        | bitIndex81 = B
        | bitIndex82 = B
        | bitIndex83 = B
        | bitIndex84 = B
        | bitIndex85 = B
        | bitIndex86 = B
        | bitIndex87 = B
        | bitIndex88 = B
        | bitIndex89 = B
        | bitIndex90 = B
        | bitIndex91 = B
        | bitIndex92 = B
        | bitIndex93 = B
        | bitIndex94 = B
        | bitIndex95 = B
        | bitIndex96 = B
        | bitIndex97 = B
        | bitIndex98 = B
        | bitIndex99 = B
        | bitIndex100 = B
        | bitIndex101 = B
        | bitIndex102 = B
        | bitIndex103 = B
        | bitIndex104 = B
        | bitIndex105 = B
        | bitIndex106 = B
        | bitIndex107 = B
        | bitIndex108 = B
        | bitIndex109 = B
        | bitIndex110 = B
        | bitIndex111 = B
        | bitIndex112 = B
        | bitIndex113 = B
        | bitIndex114 = B
        | bitIndex115 = B
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B ) ) ).

fof(addAssignment_141,axiom,
    ! [VarCurr] :
      ( ( v535(VarCurr,bitIndex122)
      <=> v493(VarCurr,bitIndex737) )
      & ( v535(VarCurr,bitIndex121)
      <=> v493(VarCurr,bitIndex736) )
      & ( v535(VarCurr,bitIndex120)
      <=> v493(VarCurr,bitIndex735) )
      & ( v535(VarCurr,bitIndex119)
      <=> v493(VarCurr,bitIndex734) )
      & ( v535(VarCurr,bitIndex118)
      <=> v493(VarCurr,bitIndex733) )
      & ( v535(VarCurr,bitIndex117)
      <=> v493(VarCurr,bitIndex732) )
      & ( v535(VarCurr,bitIndex116)
      <=> v493(VarCurr,bitIndex731) ) ) ).

fof(addAssignment_140,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v519(VarCurr,B)
      <=> v521(VarCurr,B) ) ) ).

fof(addAssignment_139,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v521(VarCurr,B)
      <=> v523(VarCurr,B) ) ) ).

fof(addAssignment_138,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v523(VarCurr,B)
      <=> v525(VarCurr,B) ) ) ).

fof(addAssignment_137,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v525(VarCurr,B)
      <=> v527(VarCurr,B) ) ) ).

fof(addAssignment_136,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v527(VarCurr,B)
      <=> v529(VarCurr,B) ) ) ).

fof(addAssignment_135,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v529(VarCurr,B)
      <=> v531(VarCurr,B) ) ) ).

fof(addAssignment_134,axiom,
    ! [VarCurr,B] :
      ( range_122_116(B)
     => ( v531(VarCurr,B)
      <=> v533(VarCurr,B) ) ) ).

fof(range_axiom_6,axiom,
    ! [B] :
      ( range_122_116(B)
    <=> ( $false
        | bitIndex116 = B
        | bitIndex117 = B
        | bitIndex118 = B
        | bitIndex119 = B
        | bitIndex120 = B
        | bitIndex121 = B
        | bitIndex122 = B ) ) ).

fof(addAssignment_133,axiom,
    ! [VarCurr] :
      ( v498(VarCurr)
    <=> v500(VarCurr,bitIndex1) ) ).

fof(addAssignment_132,axiom,
    ! [VarCurr] :
      ( v500(VarCurr,bitIndex1)
    <=> v502(VarCurr,bitIndex1) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_14,axiom,
    ! [VarCurr] :
      ( ~ v503(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v502(VarCurr,B)
          <=> v505(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_14,axiom,
    ! [VarCurr] :
      ( v503(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v502(VarCurr,B)
          <=> v504(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3_1,axiom,
    ! [VarCurr] :
      ( ( ~ v506(VarCurr)
        & ~ v508(VarCurr)
        & ~ v512(VarCurr) )
     => ! [B] :
          ( range_8_0(B)
         => ( v505(VarCurr,B)
          <=> v456(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_3,axiom,
    ! [VarCurr] :
      ( v512(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v505(VarCurr,B)
          <=> v514(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_7,axiom,
    ! [VarCurr] :
      ( v508(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v505(VarCurr,B)
          <=> v510(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_7,axiom,
    ! [VarCurr] :
      ( v506(VarCurr)
     => ! [B] :
          ( range_8_0(B)
         => ( v505(VarCurr,B)
          <=> v456(VarCurr,B) ) ) ) ).

fof(range_axiom_5,axiom,
    ! [B] :
      ( range_8_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_26,axiom,
    ! [VarCurr] :
      ( v516(VarCurr)
    <=> ( ( v517(VarCurr,bitIndex1)
        <=> $true )
        & ( v517(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_131,axiom,
    ! [VarCurr] :
      ( v517(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_130,axiom,
    ! [VarCurr] :
      ( v517(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(addAssignment_129,axiom,
    ! [VarCurr] :
      ( v514(VarCurr,bitIndex0)
    <=> $false ) ).

fof(addAssignment_128,axiom,
    ! [VarCurr] :
      ( ( v514(VarCurr,bitIndex8)
      <=> v456(VarCurr,bitIndex7) )
      & ( v514(VarCurr,bitIndex7)
      <=> v456(VarCurr,bitIndex6) )
      & ( v514(VarCurr,bitIndex6)
      <=> v456(VarCurr,bitIndex5) )
      & ( v514(VarCurr,bitIndex5)
      <=> v456(VarCurr,bitIndex4) )
      & ( v514(VarCurr,bitIndex4)
      <=> v456(VarCurr,bitIndex3) )
      & ( v514(VarCurr,bitIndex3)
      <=> v456(VarCurr,bitIndex2) )
      & ( v514(VarCurr,bitIndex2)
      <=> v456(VarCurr,bitIndex1) )
      & ( v514(VarCurr,bitIndex1)
      <=> v456(VarCurr,bitIndex0) ) ) ).

fof(addBitVectorEqualityBitBlasted_25,axiom,
    ! [VarCurr] :
      ( v512(VarCurr)
    <=> ( ( v513(VarCurr,bitIndex1)
        <=> $true )
        & ( v513(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_127,axiom,
    ! [VarCurr] :
      ( v513(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_126,axiom,
    ! [VarCurr] :
      ( v513(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(addAssignment_125,axiom,
    ! [VarCurr] :
      ( ( v510(VarCurr,bitIndex7)
      <=> v456(VarCurr,bitIndex8) )
      & ( v510(VarCurr,bitIndex6)
      <=> v456(VarCurr,bitIndex7) )
      & ( v510(VarCurr,bitIndex5)
      <=> v456(VarCurr,bitIndex6) )
      & ( v510(VarCurr,bitIndex4)
      <=> v456(VarCurr,bitIndex5) )
      & ( v510(VarCurr,bitIndex3)
      <=> v456(VarCurr,bitIndex4) )
      & ( v510(VarCurr,bitIndex2)
      <=> v456(VarCurr,bitIndex3) )
      & ( v510(VarCurr,bitIndex1)
      <=> v456(VarCurr,bitIndex2) )
      & ( v510(VarCurr,bitIndex0)
      <=> v456(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_124,axiom,
    ! [VarCurr] :
      ( v510(VarCurr,bitIndex8)
    <=> $false ) ).

fof(addBitVectorEqualityBitBlasted_24,axiom,
    ! [VarCurr] :
      ( v508(VarCurr)
    <=> ( ( v509(VarCurr,bitIndex1)
        <=> $false )
        & ( v509(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_123,axiom,
    ! [VarCurr] :
      ( v509(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_122,axiom,
    ! [VarCurr] :
      ( v509(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_23,axiom,
    ! [VarCurr] :
      ( v506(VarCurr)
    <=> ( ( v507(VarCurr,bitIndex1)
        <=> $false )
        & ( v507(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_121,axiom,
    ! [VarCurr] :
      ( v507(VarCurr,bitIndex0)
    <=> v114(VarCurr) ) ).

fof(addAssignment_120,axiom,
    ! [VarCurr] :
      ( v507(VarCurr,bitIndex1)
    <=> v96(VarCurr) ) ).

fof(addAssignment_119,axiom,
    ! [VarCurr] :
      ( v504(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_118,axiom,
    ! [VarCurr,B] :
      ( range_8_1(B)
     => ( v504(VarCurr,B)
      <=> v454(VarCurr,B) ) ) ).

fof(writeUnaryOperator_36,axiom,
    ! [VarCurr] :
      ( ~ v503(VarCurr)
    <=> v94(VarCurr) ) ).

fof(addAssignment_117,axiom,
    ! [VarCurr] :
      ( v454(VarCurr,bitIndex1)
    <=> v455(VarCurr,bitIndex1) ) ).

fof(addAssignment_116,axiom,
    ! [VarCurr] :
      ( v90(VarCurr)
    <=> v92(VarCurr) ) ).

fof(addCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v462(VarNext)
       => ( v92(VarNext)
        <=> v92(VarCurr) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarNext] :
      ( v462(VarNext)
     => ( v92(VarNext)
      <=> v482(VarNext) ) ) ).

fof(addAssignment_115,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v482(VarNext)
      <=> v480(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_13,axiom,
    ! [VarCurr] :
      ( ~ v479(VarCurr)
     => ( v480(VarCurr)
      <=> v483(VarCurr) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_13,axiom,
    ! [VarCurr] :
      ( v479(VarCurr)
     => ( v480(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_12,axiom,
    ! [VarCurr] :
      ( ~ v96(VarCurr)
     => ( v483(VarCurr)
      <=> $true ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_12,axiom,
    ! [VarCurr] :
      ( v96(VarCurr)
     => ( v483(VarCurr)
      <=> $false ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_54,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v462(VarNext)
      <=> ( v463(VarNext)
          & v472(VarNext) ) ) ) ).

fof(addAssignment_114,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v472(VarNext)
      <=> v470(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_53,axiom,
    ! [VarCurr] :
      ( v470(VarCurr)
    <=> ( v473(VarCurr)
        | v479(VarCurr) ) ) ).

fof(writeUnaryOperator_35,axiom,
    ! [VarCurr] :
      ( ~ v479(VarCurr)
    <=> v94(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_52,axiom,
    ! [VarCurr] :
      ( v473(VarCurr)
    <=> ( v474(VarCurr)
        | v96(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_51,axiom,
    ! [VarCurr] :
      ( v474(VarCurr)
    <=> ( v475(VarCurr)
        & v478(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_22,axiom,
    ! [VarCurr] :
      ( v478(VarCurr)
    <=> ( v454(VarCurr,bitIndex0)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_50,axiom,
    ! [VarCurr] :
      ( v475(VarCurr)
    <=> ( v476(VarCurr)
        & v477(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_21,axiom,
    ! [VarCurr] :
      ( v477(VarCurr)
    <=> ( v452(VarCurr,bitIndex1)
      <=> $false ) ) ).

fof(addBitVectorEqualityBitBlasted_20,axiom,
    ! [VarCurr] :
      ( v476(VarCurr)
    <=> ( v114(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_49,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v463(VarNext)
      <=> ( v464(VarNext)
          & v459(VarNext) ) ) ) ).

fof(writeUnaryOperator_34,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v464(VarNext)
      <=> v466(VarNext) ) ) ).

fof(addAssignment_113,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v466(VarNext)
      <=> v459(VarCurr) ) ) ).

fof(addAssignment_112,axiom,
    ! [VarCurr] :
      ( v459(VarCurr)
    <=> v328(VarCurr) ) ).

fof(addAssignment_111,axiom,
    ! [VarCurr] :
      ( v454(VarCurr,bitIndex0)
    <=> v455(VarCurr,bitIndex0) ) ).

fof(addAssignment_110,axiom,
    ! [VarCurr] :
      ( v455(VarCurr,bitIndex0)
    <=> $true ) ).

fof(addAssignment_109,axiom,
    ! [VarCurr,B] :
      ( range_8_1(B)
     => ( v455(VarCurr,B)
      <=> v456(VarCurr,B) ) ) ).

fof(range_axiom_4,axiom,
    ! [B] :
      ( range_8_1(B)
    <=> ( $false
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B ) ) ).

fof(addAssignment_108,axiom,
    ! [VarCurr] :
      ( v114(VarCurr)
    <=> v116(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_11,axiom,
    ! [VarCurr] :
      ( ~ v438(VarCurr)
     => ( v116(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_11,axiom,
    ! [VarCurr] :
      ( v438(VarCurr)
     => ( v116(VarCurr)
      <=> v447(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_6,axiom,
    ! [VarCurr] :
      ( ~ v440(VarCurr)
     => ( v447(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_6,axiom,
    ! [VarCurr] :
      ( v440(VarCurr)
     => ( v447(VarCurr)
      <=> v448(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_2,axiom,
    ! [VarCurr] :
      ( ( ~ v443(VarCurr)
        & ~ v271(VarCurr) )
     => ( v448(VarCurr)
      <=> $true ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_5,axiom,
    ! [VarCurr] :
      ( v271(VarCurr)
     => ( v448(VarCurr)
      <=> v450(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_5,axiom,
    ! [VarCurr] :
      ( v443(VarCurr)
     => ( v448(VarCurr)
      <=> v449(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_10,axiom,
    ! [VarCurr] :
      ( ~ v158(VarCurr)
     => ( v450(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_10,axiom,
    ! [VarCurr] :
      ( v158(VarCurr)
     => ( v450(VarCurr)
      <=> $true ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_9,axiom,
    ! [VarCurr] :
      ( ~ v431(VarCurr)
     => ( v449(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_9,axiom,
    ! [VarCurr] :
      ( v431(VarCurr)
     => ( v449(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_48,axiom,
    ! [VarCurr] :
      ( v438(VarCurr)
    <=> ( v439(VarCurr)
        & v446(VarCurr) ) ) ).

fof(writeUnaryOperator_33,axiom,
    ! [VarCurr] :
      ( ~ v446(VarCurr)
    <=> v275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_47,axiom,
    ! [VarCurr] :
      ( v439(VarCurr)
    <=> ( v440(VarCurr)
        | v445(VarCurr) ) ) ).

fof(writeUnaryOperator_32,axiom,
    ! [VarCurr] :
      ( ~ v445(VarCurr)
    <=> v272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_46,axiom,
    ! [VarCurr] :
      ( v440(VarCurr)
    <=> ( v441(VarCurr)
        & v272(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_45,axiom,
    ! [VarCurr] :
      ( v441(VarCurr)
    <=> ( v442(VarCurr)
        | v444(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_19,axiom,
    ! [VarCurr] :
      ( v444(VarCurr)
    <=> ( ( v88(VarCurr,bitIndex1)
        <=> $true )
        & ( v88(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_44,axiom,
    ! [VarCurr] :
      ( v442(VarCurr)
    <=> ( v443(VarCurr)
        | v271(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_18,axiom,
    ! [VarCurr] :
      ( v443(VarCurr)
    <=> ( ( v88(VarCurr,bitIndex1)
        <=> $false )
        & ( v88(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(writeBinaryOperatorShiftedRanges_21,axiom,
    ! [VarCurr] :
      ( v431(VarCurr)
    <=> ( v436(VarCurr)
        | v433(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorShiftedRanges_20,axiom,
    ! [VarCurr] :
      ( v436(VarCurr)
    <=> ( v433(VarCurr,bitIndex0)
        | v433(VarCurr,bitIndex1) ) ) ).

fof(addAssignment_107,axiom,
    ! [VarCurr] :
      ( v121(VarCurr)
    <=> v123(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_17,axiom,
    ! [VarCurr] :
      ( v123(VarCurr)
    <=> ( ( v125(VarCurr,bitIndex2)
        <=> $false )
        & ( v125(VarCurr,bitIndex1)
        <=> $false )
        & ( v125(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v415(VarNext)
       => ! [B] :
            ( range_2_0(B)
           => ( v125(VarNext,B)
            <=> v125(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarNext] :
      ( v415(VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v125(VarNext,B)
          <=> v425(VarNext,B) ) ) ) ).

fof(addAssignment_106,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_2_0(B)
         => ( v425(VarNext,B)
          <=> v423(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_8,axiom,
    ! [VarCurr] :
      ( ~ v426(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v423(VarCurr,B)
          <=> v130(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_8,axiom,
    ! [VarCurr] :
      ( v426(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v423(VarCurr,B)
          <=> $false ) ) ) ).

fof(writeUnaryOperator_31,axiom,
    ! [VarCurr] :
      ( ~ v426(VarCurr)
    <=> v127(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_43,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v415(VarNext)
      <=> v416(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_42,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v416(VarNext)
      <=> ( v417(VarNext)
          & v412(VarNext) ) ) ) ).

fof(writeUnaryOperator_30,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v417(VarNext)
      <=> v419(VarNext) ) ) ).

fof(addAssignment_105,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v419(VarNext)
      <=> v412(VarCurr) ) ) ).

fof(addAssignment_104,axiom,
    ! [VarCurr] :
      ( v412(VarCurr)
    <=> v328(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges3,axiom,
    ! [VarCurr] :
      ( ( ~ v361(VarCurr)
        & ~ v363(VarCurr)
        & ~ v392(VarCurr) )
     => ! [B] :
          ( range_2_0(B)
         => ( v130(VarCurr,B)
          <=> v125(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2_1,axiom,
    ! [VarCurr] :
      ( v392(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v130(VarCurr,B)
          <=> v394(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_4,axiom,
    ! [VarCurr] :
      ( v363(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v130(VarCurr,B)
          <=> v365(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_4,axiom,
    ! [VarCurr] :
      ( v361(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v130(VarCurr,B)
          <=> v125(VarCurr,B) ) ) ) ).

fof(addBitVectorEqualityBitBlasted_16,axiom,
    ! [VarCurr] :
      ( v409(VarCurr)
    <=> ( ( v410(VarCurr,bitIndex1)
        <=> $true )
        & ( v410(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_103,axiom,
    ! [VarCurr] :
      ( v410(VarCurr,bitIndex0)
    <=> v152(VarCurr) ) ).

fof(addAssignment_102,axiom,
    ! [VarCurr] :
      ( v410(VarCurr,bitIndex1)
    <=> v132(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_7,axiom,
    ! [VarCurr] :
      ( ~ v395(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v394(VarCurr,B)
          <=> v396(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_7,axiom,
    ! [VarCurr] :
      ( v395(VarCurr)
     => ! [B] :
          ( range_2_0(B)
         => ( v394(VarCurr,B)
          <=> b100(B) ) ) ) ).

fof(addAssignment_101,axiom,
    ! [VarCurr] :
      ( v396(VarCurr,bitIndex0)
    <=> v406(VarCurr) ) ).

fof(addAssignment_100,axiom,
    ! [VarCurr] :
      ( v396(VarCurr,bitIndex1)
    <=> v404(VarCurr) ) ).

fof(addAssignment_99,axiom,
    ! [VarCurr] :
      ( v396(VarCurr,bitIndex2)
    <=> v398(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_41,axiom,
    ! [VarCurr] :
      ( v404(VarCurr)
    <=> ( v405(VarCurr)
        & v408(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_19,axiom,
    ! [VarCurr] :
      ( v408(VarCurr)
    <=> ( v125(VarCurr,bitIndex0)
        | v125(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_40,axiom,
    ! [VarCurr] :
      ( v405(VarCurr)
    <=> ( v406(VarCurr)
        | v407(VarCurr) ) ) ).

fof(writeUnaryOperator_29,axiom,
    ! [VarCurr] :
      ( ~ v407(VarCurr)
    <=> v125(VarCurr,bitIndex1) ) ).

fof(writeUnaryOperator_28,axiom,
    ! [VarCurr] :
      ( ~ v406(VarCurr)
    <=> v125(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_39,axiom,
    ! [VarCurr] :
      ( v398(VarCurr)
    <=> ( v399(VarCurr)
        & v403(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_18,axiom,
    ! [VarCurr] :
      ( v403(VarCurr)
    <=> ( v401(VarCurr)
        | v125(VarCurr,bitIndex2) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_38,axiom,
    ! [VarCurr] :
      ( v399(VarCurr)
    <=> ( v400(VarCurr)
        | v402(VarCurr) ) ) ).

fof(writeUnaryOperator_27,axiom,
    ! [VarCurr] :
      ( ~ v402(VarCurr)
    <=> v125(VarCurr,bitIndex2) ) ).

fof(writeUnaryOperator_26,axiom,
    ! [VarCurr] :
      ( ~ v400(VarCurr)
    <=> v401(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_17,axiom,
    ! [VarCurr] :
      ( v401(VarCurr)
    <=> ( v125(VarCurr,bitIndex0)
        & v125(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_15,axiom,
    ! [VarCurr] :
      ( v395(VarCurr)
    <=> ( ( v125(VarCurr,bitIndex2)
        <=> $true )
        & ( v125(VarCurr,bitIndex1)
        <=> $false )
        & ( v125(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_59,axiom,
    b100(bitIndex2) ).

fof(bitBlastConstant_58,axiom,
    ~ b100(bitIndex1) ).

fof(bitBlastConstant_57,axiom,
    ~ b100(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_14,axiom,
    ! [VarCurr] :
      ( v392(VarCurr)
    <=> ( ( v393(VarCurr,bitIndex1)
        <=> $true )
        & ( v393(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_98,axiom,
    ! [VarCurr] :
      ( v393(VarCurr,bitIndex0)
    <=> v152(VarCurr) ) ).

fof(addAssignment_97,axiom,
    ! [VarCurr] :
      ( v393(VarCurr,bitIndex1)
    <=> v132(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_6,axiom,
    ! [VarCurr] :
      ( ~ v366(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v365(VarCurr,B)
          <=> v367(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_6,axiom,
    ! [VarCurr] :
      ( v366(VarCurr)
     => ! [B] :
          ( range_31_0(B)
         => ( v365(VarCurr,B)
          <=> $false ) ) ) ).

fof(range_axiom_3,axiom,
    ! [B] :
      ( range_31_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B
        | bitIndex8 = B
        | bitIndex9 = B
        | bitIndex10 = B
        | bitIndex11 = B
        | bitIndex12 = B
        | bitIndex13 = B
        | bitIndex14 = B
        | bitIndex15 = B
        | bitIndex16 = B
        | bitIndex17 = B
        | bitIndex18 = B
        | bitIndex19 = B
        | bitIndex20 = B
        | bitIndex21 = B
        | bitIndex22 = B
        | bitIndex23 = B
        | bitIndex24 = B
        | bitIndex25 = B
        | bitIndex26 = B
        | bitIndex27 = B
        | bitIndex28 = B
        | bitIndex29 = B
        | bitIndex30 = B
        | bitIndex31 = B ) ) ).

fof(bitBlastConstant_56,axiom,
    ~ b00000000000000000000000000000000(bitIndex31) ).

fof(bitBlastConstant_55,axiom,
    ~ b00000000000000000000000000000000(bitIndex30) ).

fof(bitBlastConstant_54,axiom,
    ~ b00000000000000000000000000000000(bitIndex29) ).

fof(bitBlastConstant_53,axiom,
    ~ b00000000000000000000000000000000(bitIndex28) ).

fof(bitBlastConstant_52,axiom,
    ~ b00000000000000000000000000000000(bitIndex27) ).

fof(bitBlastConstant_51,axiom,
    ~ b00000000000000000000000000000000(bitIndex26) ).

fof(bitBlastConstant_50,axiom,
    ~ b00000000000000000000000000000000(bitIndex25) ).

fof(bitBlastConstant_49,axiom,
    ~ b00000000000000000000000000000000(bitIndex24) ).

fof(bitBlastConstant_48,axiom,
    ~ b00000000000000000000000000000000(bitIndex23) ).

fof(bitBlastConstant_47,axiom,
    ~ b00000000000000000000000000000000(bitIndex22) ).

fof(bitBlastConstant_46,axiom,
    ~ b00000000000000000000000000000000(bitIndex21) ).

fof(bitBlastConstant_45,axiom,
    ~ b00000000000000000000000000000000(bitIndex20) ).

fof(bitBlastConstant_44,axiom,
    ~ b00000000000000000000000000000000(bitIndex19) ).

fof(bitBlastConstant_43,axiom,
    ~ b00000000000000000000000000000000(bitIndex18) ).

fof(bitBlastConstant_42,axiom,
    ~ b00000000000000000000000000000000(bitIndex17) ).

fof(bitBlastConstant_41,axiom,
    ~ b00000000000000000000000000000000(bitIndex16) ).

fof(bitBlastConstant_40,axiom,
    ~ b00000000000000000000000000000000(bitIndex15) ).

fof(bitBlastConstant_39,axiom,
    ~ b00000000000000000000000000000000(bitIndex14) ).

fof(bitBlastConstant_38,axiom,
    ~ b00000000000000000000000000000000(bitIndex13) ).

fof(bitBlastConstant_37,axiom,
    ~ b00000000000000000000000000000000(bitIndex12) ).

fof(bitBlastConstant_36,axiom,
    ~ b00000000000000000000000000000000(bitIndex11) ).

fof(bitBlastConstant_35,axiom,
    ~ b00000000000000000000000000000000(bitIndex10) ).

fof(bitBlastConstant_34,axiom,
    ~ b00000000000000000000000000000000(bitIndex9) ).

fof(bitBlastConstant_33,axiom,
    ~ b00000000000000000000000000000000(bitIndex8) ).

fof(bitBlastConstant_32,axiom,
    ~ b00000000000000000000000000000000(bitIndex7) ).

fof(bitBlastConstant_31,axiom,
    ~ b00000000000000000000000000000000(bitIndex6) ).

fof(bitBlastConstant_30,axiom,
    ~ b00000000000000000000000000000000(bitIndex5) ).

fof(bitBlastConstant_29,axiom,
    ~ b00000000000000000000000000000000(bitIndex4) ).

fof(bitBlastConstant_28,axiom,
    ~ b00000000000000000000000000000000(bitIndex3) ).

fof(bitBlastConstant_27,axiom,
    ~ b00000000000000000000000000000000(bitIndex2) ).

fof(bitBlastConstant_26,axiom,
    ~ b00000000000000000000000000000000(bitIndex1) ).

fof(bitBlastConstant_25,axiom,
    ~ b00000000000000000000000000000000(bitIndex0) ).

fof(addSignExtensionConstraint_27,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex4)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_26,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex5)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_25,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex6)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_24,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex7)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_23,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex8)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_22,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex9)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_21,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex10)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_20,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex11)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_19,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex12)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_18,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex13)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_17,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex14)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_16,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex15)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_15,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex16)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_14,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex17)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_13,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex18)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_12,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex19)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_11,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex20)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_10,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex21)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_9,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex22)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_8,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex23)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_7,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex24)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_6,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex25)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_5,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex26)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_4,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex27)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_3,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex28)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_2,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex29)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint_1,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex30)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addSignExtensionConstraint,axiom,
    ! [VarCurr] :
      ( v367(VarCurr,bitIndex31)
    <=> v368(VarCurr,bitIndex3) ) ).

fof(addAssignment_96,axiom,
    ! [VarCurr,B] :
      ( range_3_0(B)
     => ( v367(VarCurr,B)
      <=> v368(VarCurr,B) ) ) ).

fof(addAssignment_95,axiom,
    ! [VarCurr] :
      ( v368(VarCurr,bitIndex0)
    <=> v389(VarCurr) ) ).

fof(addAssignment_94,axiom,
    ! [VarCurr] :
      ( v368(VarCurr,bitIndex1)
    <=> v387(VarCurr) ) ).

fof(addAssignment_93,axiom,
    ! [VarCurr] :
      ( v368(VarCurr,bitIndex2)
    <=> v383(VarCurr) ) ).

fof(addAssignment_92,axiom,
    ! [VarCurr] :
      ( v368(VarCurr,bitIndex3)
    <=> v370(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_37,axiom,
    ! [VarCurr] :
      ( v387(VarCurr)
    <=> ( v388(VarCurr)
        & v390(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_36,axiom,
    ! [VarCurr] :
      ( v390(VarCurr)
    <=> ( v374(VarCurr,bitIndex0)
        | v379(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_16,axiom,
    ! [VarCurr] :
      ( v388(VarCurr)
    <=> ( v389(VarCurr)
        | v374(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_25,axiom,
    ! [VarCurr] :
      ( ~ v389(VarCurr)
    <=> v374(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_35,axiom,
    ! [VarCurr] :
      ( v383(VarCurr)
    <=> ( v384(VarCurr)
        & v386(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_34,axiom,
    ! [VarCurr] :
      ( v386(VarCurr)
    <=> ( v377(VarCurr)
        | v380(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_15,axiom,
    ! [VarCurr] :
      ( v384(VarCurr)
    <=> ( v385(VarCurr)
        | v374(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_24,axiom,
    ! [VarCurr] :
      ( ~ v385(VarCurr)
    <=> v377(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_33,axiom,
    ! [VarCurr] :
      ( v370(VarCurr)
    <=> ( v371(VarCurr)
        & v381(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_32,axiom,
    ! [VarCurr] :
      ( v381(VarCurr)
    <=> ( v373(VarCurr)
        | v382(VarCurr) ) ) ).

fof(writeUnaryOperator_23,axiom,
    ! [VarCurr] :
      ( ~ v382(VarCurr)
    <=> v374(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_14,axiom,
    ! [VarCurr] :
      ( v371(VarCurr)
    <=> ( v372(VarCurr)
        | v374(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_22,axiom,
    ! [VarCurr] :
      ( ~ v372(VarCurr)
    <=> v373(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_13,axiom,
    ! [VarCurr] :
      ( v373(VarCurr)
    <=> ( v374(VarCurr,bitIndex2)
        | v376(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_31,axiom,
    ! [VarCurr] :
      ( v376(VarCurr)
    <=> ( v377(VarCurr)
        & v380(VarCurr) ) ) ).

fof(writeUnaryOperator_21,axiom,
    ! [VarCurr] :
      ( ~ v380(VarCurr)
    <=> v374(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges_12,axiom,
    ! [VarCurr] :
      ( v377(VarCurr)
    <=> ( v374(VarCurr,bitIndex1)
        | v378(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_30,axiom,
    ! [VarCurr] :
      ( v378(VarCurr)
    <=> ( v374(VarCurr,bitIndex0)
        & v379(VarCurr) ) ) ).

fof(writeUnaryOperator_20,axiom,
    ! [VarCurr] :
      ( ~ v379(VarCurr)
    <=> v374(VarCurr,bitIndex1) ) ).

fof(addZeroExtensionConstraint,axiom,
    ! [VarCurr] : ~ v374(VarCurr,bitIndex3) ).

fof(addAssignment_91,axiom,
    ! [VarCurr,B] :
      ( range_2_0(B)
     => ( v374(VarCurr,B)
      <=> v125(VarCurr,B) ) ) ).

fof(range_axiom_2,axiom,
    ! [B] :
      ( range_2_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B ) ) ).

fof(addBitVectorEqualityBitBlasted_13,axiom,
    ! [VarCurr] :
      ( v366(VarCurr)
    <=> ( ( v125(VarCurr,bitIndex2)
        <=> $false )
        & ( v125(VarCurr,bitIndex1)
        <=> $false )
        & ( v125(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_24,axiom,
    ~ b000(bitIndex2) ).

fof(bitBlastConstant_23,axiom,
    ~ b000(bitIndex1) ).

fof(bitBlastConstant_22,axiom,
    ~ b000(bitIndex0) ).

fof(addBitVectorEqualityBitBlasted_12,axiom,
    ! [VarCurr] :
      ( v363(VarCurr)
    <=> ( ( v364(VarCurr,bitIndex1)
        <=> $false )
        & ( v364(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_90,axiom,
    ! [VarCurr] :
      ( v364(VarCurr,bitIndex0)
    <=> v152(VarCurr) ) ).

fof(addAssignment_89,axiom,
    ! [VarCurr] :
      ( v364(VarCurr,bitIndex1)
    <=> v132(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_11,axiom,
    ! [VarCurr] :
      ( v361(VarCurr)
    <=> ( ( v362(VarCurr,bitIndex1)
        <=> $false )
        & ( v362(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(addAssignment_88,axiom,
    ! [VarCurr] :
      ( v362(VarCurr,bitIndex0)
    <=> v152(VarCurr) ) ).

fof(addAssignment_87,axiom,
    ! [VarCurr] :
      ( v362(VarCurr,bitIndex1)
    <=> v132(VarCurr) ) ).

fof(addAssignment_86,axiom,
    ! [VarCurr] :
      ( v152(VarCurr)
    <=> v154(VarCurr) ) ).

fof(addAssignment_85,axiom,
    ! [VarCurr] :
      ( v154(VarCurr)
    <=> v156(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_5,axiom,
    ! [VarCurr] :
      ( ~ v353(VarCurr)
     => ( v156(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_5,axiom,
    ! [VarCurr] :
      ( v353(VarCurr)
     => ( v156(VarCurr)
      <=> v357(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_3,axiom,
    ! [VarCurr] :
      ( ~ v275(VarCurr)
     => ( v357(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_3,axiom,
    ! [VarCurr] :
      ( v275(VarCurr)
     => ( v357(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_29,axiom,
    ! [VarCurr] :
      ( v353(VarCurr)
    <=> ( v275(VarCurr)
        | v354(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_28,axiom,
    ! [VarCurr] :
      ( v354(VarCurr)
    <=> ( v355(VarCurr)
        & v356(VarCurr) ) ) ).

fof(writeUnaryOperator_19,axiom,
    ! [VarCurr] :
      ( ~ v356(VarCurr)
    <=> v275(VarCurr) ) ).

fof(writeUnaryOperator_18,axiom,
    ! [VarCurr] :
      ( ~ v355(VarCurr)
    <=> v272(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_11,axiom,
    ! [VarCurr] :
      ( v158(VarCurr)
    <=> ( v351(VarCurr)
        | v160(VarCurr,bitIndex3) ) ) ).

fof(writeBinaryOperatorShiftedRanges_10,axiom,
    ! [VarCurr] :
      ( v351(VarCurr)
    <=> ( v321(VarCurr)
        | v160(VarCurr,bitIndex2) ) ) ).

fof(addCaseBooleanConditionEqualRanges1,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v335(VarNext)
       => ! [B] :
            ( range_3_0(B)
           => ( v160(VarNext,B)
            <=> v160(VarCurr,B) ) ) ) ) ).

fof(addCaseBooleanConditionEqualRanges0,axiom,
    ! [VarNext] :
      ( v335(VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v160(VarNext,B)
          <=> v345(VarNext,B) ) ) ) ).

fof(addAssignment_84,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ! [B] :
          ( range_3_0(B)
         => ( v345(VarNext,B)
          <=> v343(VarCurr,B) ) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_4,axiom,
    ! [VarCurr] :
      ( ~ v346(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v343(VarCurr,B)
          <=> v163(VarCurr,B) ) ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_4,axiom,
    ! [VarCurr] :
      ( v346(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v343(VarCurr,B)
          <=> b1000(B) ) ) ) ).

fof(bitBlastConstant_21,axiom,
    b1000(bitIndex3) ).

fof(bitBlastConstant_20,axiom,
    ~ b1000(bitIndex2) ).

fof(bitBlastConstant_19,axiom,
    ~ b1000(bitIndex1) ).

fof(bitBlastConstant_18,axiom,
    ~ b1000(bitIndex0) ).

fof(writeUnaryOperator_17,axiom,
    ! [VarCurr] :
      ( ~ v346(VarCurr)
    <=> v82(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_27,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v335(VarNext)
      <=> v336(VarNext) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_26,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v336(VarNext)
      <=> ( v337(VarNext)
          & v328(VarNext) ) ) ) ).

fof(writeUnaryOperator_16,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( ~ v337(VarNext)
      <=> v339(VarNext) ) ) ).

fof(addAssignment_83,axiom,
    ! [VarNext,VarCurr] :
      ( nextState(VarCurr,VarNext)
     => ( v339(VarNext)
      <=> v328(VarCurr) ) ) ).

fof(addAssignment_82,axiom,
    ! [VarCurr] :
      ( v328(VarCurr)
    <=> v330(VarCurr) ) ).

fof(addAssignment_81,axiom,
    ! [VarCurr] :
      ( v330(VarCurr)
    <=> v332(VarCurr) ) ).

fof(addAssignment_80,axiom,
    ! [VarCurr] :
      ( v332(VarCurr)
    <=> v1(VarCurr) ) ).

fof(addParallelCaseBooleanConditionEqualRanges2,axiom,
    ! [VarCurr] :
      ( ( ~ v282(VarCurr)
        & ~ v305(VarCurr) )
     => ! [B] :
          ( range_3_0(B)
         => ( v163(VarCurr,B)
          <=> v160(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_2,axiom,
    ! [VarCurr] :
      ( v305(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v163(VarCurr,B)
          <=> v307(VarCurr,B) ) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_2,axiom,
    ! [VarCurr] :
      ( v282(VarCurr)
     => ! [B] :
          ( range_3_0(B)
         => ( v163(VarCurr,B)
          <=> v284(VarCurr,B) ) ) ) ).

fof(range_axiom_1,axiom,
    ! [B] :
      ( range_3_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_25,axiom,
    ! [VarCurr] :
      ( v322(VarCurr)
    <=> ( v323(VarCurr)
        | v325(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_10,axiom,
    ! [VarCurr] :
      ( v325(VarCurr)
    <=> ( ( v326(VarCurr,bitIndex1)
        <=> $true )
        & ( v326(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_79,axiom,
    ! [VarCurr] :
      ( v326(VarCurr,bitIndex0)
    <=> v264(VarCurr) ) ).

fof(addAssignment_78,axiom,
    ! [VarCurr] :
      ( v326(VarCurr,bitIndex1)
    <=> v165(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_9,axiom,
    ! [VarCurr] :
      ( v323(VarCurr)
    <=> ( ( v324(VarCurr,bitIndex1)
        <=> $false )
        & ( v324(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_17,axiom,
    ~ b00(bitIndex1) ).

fof(bitBlastConstant_16,axiom,
    ~ b00(bitIndex0) ).

fof(addAssignment_77,axiom,
    ! [VarCurr] :
      ( v324(VarCurr,bitIndex0)
    <=> v264(VarCurr) ) ).

fof(addAssignment_76,axiom,
    ! [VarCurr] :
      ( v324(VarCurr,bitIndex1)
    <=> v165(VarCurr) ) ).

fof(addAssignment_75,axiom,
    ! [VarCurr] :
      ( v307(VarCurr,bitIndex0)
    <=> v303(VarCurr) ) ).

fof(addAssignment_74,axiom,
    ! [VarCurr] :
      ( v307(VarCurr,bitIndex1)
    <=> v319(VarCurr) ) ).

fof(addAssignment_73,axiom,
    ! [VarCurr] :
      ( v307(VarCurr,bitIndex2)
    <=> v315(VarCurr) ) ).

fof(addAssignment_72,axiom,
    ! [VarCurr] :
      ( v307(VarCurr,bitIndex3)
    <=> v309(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_24,axiom,
    ! [VarCurr] :
      ( v319(VarCurr)
    <=> ( v320(VarCurr)
        & v321(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_9,axiom,
    ! [VarCurr] :
      ( v321(VarCurr)
    <=> ( v160(VarCurr,bitIndex0)
        | v160(VarCurr,bitIndex1) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_23,axiom,
    ! [VarCurr] :
      ( v320(VarCurr)
    <=> ( v303(VarCurr)
        | v293(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_22,axiom,
    ! [VarCurr] :
      ( v315(VarCurr)
    <=> ( v316(VarCurr)
        & v318(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_8,axiom,
    ! [VarCurr] :
      ( v318(VarCurr)
    <=> ( v160(VarCurr,bitIndex2)
        | v313(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_21,axiom,
    ! [VarCurr] :
      ( v316(VarCurr)
    <=> ( v294(VarCurr)
        | v317(VarCurr) ) ) ).

fof(writeUnaryOperator_15,axiom,
    ! [VarCurr] :
      ( ~ v317(VarCurr)
    <=> v313(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_20,axiom,
    ! [VarCurr] :
      ( v309(VarCurr)
    <=> ( v310(VarCurr)
        & v314(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_7,axiom,
    ! [VarCurr] :
      ( v314(VarCurr)
    <=> ( v160(VarCurr,bitIndex3)
        | v312(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_19,axiom,
    ! [VarCurr] :
      ( v310(VarCurr)
    <=> ( v296(VarCurr)
        | v311(VarCurr) ) ) ).

fof(writeUnaryOperator_14,axiom,
    ! [VarCurr] :
      ( ~ v311(VarCurr)
    <=> v312(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_6,axiom,
    ! [VarCurr] :
      ( v312(VarCurr)
    <=> ( v160(VarCurr,bitIndex2)
        & v313(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_5,axiom,
    ! [VarCurr] :
      ( v313(VarCurr)
    <=> ( v160(VarCurr,bitIndex0)
        & v160(VarCurr,bitIndex1) ) ) ).

fof(addBitVectorEqualityBitBlasted_8,axiom,
    ! [VarCurr] :
      ( v305(VarCurr)
    <=> ( ( v306(VarCurr,bitIndex1)
        <=> $true )
        & ( v306(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_15,axiom,
    b10(bitIndex1) ).

fof(bitBlastConstant_14,axiom,
    ~ b10(bitIndex0) ).

fof(addAssignment_71,axiom,
    ! [VarCurr] :
      ( v306(VarCurr,bitIndex0)
    <=> v264(VarCurr) ) ).

fof(addAssignment_70,axiom,
    ! [VarCurr] :
      ( v306(VarCurr,bitIndex1)
    <=> v165(VarCurr) ) ).

fof(addAssignment_69,axiom,
    ! [VarCurr] :
      ( v284(VarCurr,bitIndex0)
    <=> v303(VarCurr) ) ).

fof(addAssignment_68,axiom,
    ! [VarCurr] :
      ( v284(VarCurr,bitIndex1)
    <=> v301(VarCurr) ) ).

fof(addAssignment_67,axiom,
    ! [VarCurr] :
      ( v284(VarCurr,bitIndex2)
    <=> v297(VarCurr) ) ).

fof(addAssignment_66,axiom,
    ! [VarCurr] :
      ( v284(VarCurr,bitIndex3)
    <=> v286(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_18,axiom,
    ! [VarCurr] :
      ( v301(VarCurr)
    <=> ( v302(VarCurr)
        & v304(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_17,axiom,
    ! [VarCurr] :
      ( v304(VarCurr)
    <=> ( v160(VarCurr,bitIndex0)
        | v293(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_4,axiom,
    ! [VarCurr] :
      ( v302(VarCurr)
    <=> ( v303(VarCurr)
        | v160(VarCurr,bitIndex1) ) ) ).

fof(writeUnaryOperator_13,axiom,
    ! [VarCurr] :
      ( ~ v303(VarCurr)
    <=> v160(VarCurr,bitIndex0) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_16,axiom,
    ! [VarCurr] :
      ( v297(VarCurr)
    <=> ( v298(VarCurr)
        & v300(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_15,axiom,
    ! [VarCurr] :
      ( v300(VarCurr)
    <=> ( v291(VarCurr)
        | v294(VarCurr) ) ) ).

fof(writeBinaryOperatorShiftedRanges_3,axiom,
    ! [VarCurr] :
      ( v298(VarCurr)
    <=> ( v299(VarCurr)
        | v160(VarCurr,bitIndex2) ) ) ).

fof(writeUnaryOperator_12,axiom,
    ! [VarCurr] :
      ( ~ v299(VarCurr)
    <=> v291(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_14,axiom,
    ! [VarCurr] :
      ( v286(VarCurr)
    <=> ( v287(VarCurr)
        & v295(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_13,axiom,
    ! [VarCurr] :
      ( v295(VarCurr)
    <=> ( v289(VarCurr)
        | v296(VarCurr) ) ) ).

fof(writeUnaryOperator_11,axiom,
    ! [VarCurr] :
      ( ~ v296(VarCurr)
    <=> v160(VarCurr,bitIndex3) ) ).

fof(writeBinaryOperatorShiftedRanges_2,axiom,
    ! [VarCurr] :
      ( v287(VarCurr)
    <=> ( v288(VarCurr)
        | v160(VarCurr,bitIndex3) ) ) ).

fof(writeUnaryOperator_10,axiom,
    ! [VarCurr] :
      ( ~ v288(VarCurr)
    <=> v289(VarCurr) ) ).

fof(writeBinaryOperatorShiftedRanges_1,axiom,
    ! [VarCurr] :
      ( v289(VarCurr)
    <=> ( v160(VarCurr,bitIndex2)
        | v290(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_12,axiom,
    ! [VarCurr] :
      ( v290(VarCurr)
    <=> ( v291(VarCurr)
        & v294(VarCurr) ) ) ).

fof(writeUnaryOperator_9,axiom,
    ! [VarCurr] :
      ( ~ v294(VarCurr)
    <=> v160(VarCurr,bitIndex2) ) ).

fof(writeBinaryOperatorShiftedRanges,axiom,
    ! [VarCurr] :
      ( v291(VarCurr)
    <=> ( v160(VarCurr,bitIndex1)
        | v292(VarCurr) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_11,axiom,
    ! [VarCurr] :
      ( v292(VarCurr)
    <=> ( v160(VarCurr,bitIndex0)
        & v293(VarCurr) ) ) ).

fof(writeUnaryOperator_8,axiom,
    ! [VarCurr] :
      ( ~ v293(VarCurr)
    <=> v160(VarCurr,bitIndex1) ) ).

fof(addBitVectorEqualityBitBlasted_7,axiom,
    ! [VarCurr] :
      ( v282(VarCurr)
    <=> ( ( v283(VarCurr,bitIndex1)
        <=> $false )
        & ( v283(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(addAssignment_65,axiom,
    ! [VarCurr] :
      ( v283(VarCurr,bitIndex0)
    <=> v264(VarCurr) ) ).

fof(addAssignment_64,axiom,
    ! [VarCurr] :
      ( v283(VarCurr,bitIndex1)
    <=> v165(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_10,axiom,
    ! [VarCurr] :
      ( v264(VarCurr)
    <=> ( v156(VarCurr)
        | v266(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_3,axiom,
    ! [VarCurr] :
      ( ~ v268(VarCurr)
     => ( v266(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_3,axiom,
    ! [VarCurr] :
      ( v268(VarCurr)
     => ( v266(VarCurr)
      <=> v277(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1_1,axiom,
    ! [VarCurr] :
      ( ~ v270(VarCurr)
     => ( v277(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0_1,axiom,
    ! [VarCurr] :
      ( v270(VarCurr)
     => ( v277(VarCurr)
      <=> v278(VarCurr) ) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_2,axiom,
    ! [VarCurr] :
      ( ~ v158(VarCurr)
     => ( v278(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_2,axiom,
    ! [VarCurr] :
      ( v158(VarCurr)
     => ( v278(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_9,axiom,
    ! [VarCurr] :
      ( v268(VarCurr)
    <=> ( v269(VarCurr)
        & v274(VarCurr) ) ) ).

fof(writeUnaryOperator_7,axiom,
    ! [VarCurr] :
      ( ~ v274(VarCurr)
    <=> v275(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_8,axiom,
    ! [VarCurr] :
      ( v275(VarCurr)
    <=> ( v276(VarCurr)
        & v158(VarCurr) ) ) ).

fof(writeUnaryOperator_6,axiom,
    ! [VarCurr] :
      ( ~ v276(VarCurr)
    <=> v121(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_7,axiom,
    ! [VarCurr] :
      ( v269(VarCurr)
    <=> ( v270(VarCurr)
        | v273(VarCurr) ) ) ).

fof(writeUnaryOperator_5,axiom,
    ! [VarCurr] :
      ( ~ v273(VarCurr)
    <=> v272(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_6,axiom,
    ! [VarCurr] :
      ( v270(VarCurr)
    <=> ( v271(VarCurr)
        & v272(VarCurr) ) ) ).

fof(writeUnaryOperator_4,axiom,
    ! [VarCurr] :
      ( ~ v272(VarCurr)
    <=> v90(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_6,axiom,
    ! [VarCurr] :
      ( v271(VarCurr)
    <=> ( ( v88(VarCurr,bitIndex1)
        <=> $false )
        & ( v88(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_13,axiom,
    ~ b01(bitIndex1) ).

fof(bitBlastConstant_12,axiom,
    b01(bitIndex0) ).

fof(addAssignment_63,axiom,
    ! [VarCurr] :
      ( v165(VarCurr)
    <=> v167(VarCurr) ) ).

fof(addAssignment_62,axiom,
    ! [VarCurr] :
      ( v167(VarCurr)
    <=> v169(VarCurr) ) ).

fof(addAssignment_61,axiom,
    ! [VarCurr] :
      ( v169(VarCurr)
    <=> v171(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch_1,axiom,
    ! [VarCurr] :
      ( ~ v255(VarCurr)
     => ( v171(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch_1,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
     => ( v171(VarCurr)
      <=> v262(VarCurr) ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges1,axiom,
    ! [VarCurr] :
      ( ~ v256(VarCurr)
     => ( v262(VarCurr)
      <=> $false ) ) ).

fof(addParallelCaseBooleanConditionEqualRanges0,axiom,
    ! [VarCurr] :
      ( v256(VarCurr)
     => ( v262(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_5,axiom,
    ! [VarCurr] :
      ( v255(VarCurr)
    <=> ( v256(VarCurr)
        | v258(VarCurr) ) ) ).

fof(writeUnaryOperator_3,axiom,
    ! [VarCurr] :
      ( ~ v258(VarCurr)
    <=> v259(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_4,axiom,
    ! [VarCurr] :
      ( v259(VarCurr)
    <=> ( v260(VarCurr)
        | v256(VarCurr) ) ) ).

fof(addBitVectorEqualityBitBlasted_5,axiom,
    ! [VarCurr] :
      ( v260(VarCurr)
    <=> ( ( v261(VarCurr,bitIndex2)
        <=> $false )
        & ( v261(VarCurr,bitIndex1)
        <=> $false )
        & ( v261(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_11,axiom,
    ~ b001(bitIndex2) ).

fof(bitBlastConstant_10,axiom,
    ~ b001(bitIndex1) ).

fof(bitBlastConstant_9,axiom,
    b001(bitIndex0) ).

fof(addAssignment_60,axiom,
    ! [VarCurr] :
      ( v261(VarCurr,bitIndex0)
    <=> v236(VarCurr) ) ).

fof(addAssignment_59,axiom,
    ! [VarCurr] :
      ( v261(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(addAssignment_58,axiom,
    ! [VarCurr] :
      ( v261(VarCurr,bitIndex2)
    <=> v173(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_4,axiom,
    ! [VarCurr] :
      ( v256(VarCurr)
    <=> ( ( v257(VarCurr,bitIndex2)
        <=> $false )
        & ( v257(VarCurr,bitIndex1)
        <=> $true )
        & ( v257(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_8,axiom,
    ~ b010(bitIndex2) ).

fof(bitBlastConstant_7,axiom,
    b010(bitIndex1) ).

fof(bitBlastConstant_6,axiom,
    ~ b010(bitIndex0) ).

fof(addAssignment_57,axiom,
    ! [VarCurr] :
      ( v257(VarCurr,bitIndex0)
    <=> v236(VarCurr) ) ).

fof(addAssignment_56,axiom,
    ! [VarCurr] :
      ( v257(VarCurr,bitIndex1)
    <=> v210(VarCurr) ) ).

fof(addAssignment_55,axiom,
    ! [VarCurr] :
      ( v257(VarCurr,bitIndex2)
    <=> v173(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_3,axiom,
    ! [VarCurr] :
      ( v236(VarCurr)
    <=> ( v250(VarCurr)
        & v251(VarCurr) ) ) ).

fof(writeUnaryOperator_2,axiom,
    ! [VarCurr] :
      ( ~ v251(VarCurr)
    <=> v246(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_3,axiom,
    ! [VarCurr] :
      ( v250(VarCurr)
    <=> ( ( v212(VarCurr,bitIndex7)
        <=> v238(VarCurr,bitIndex7) )
        & ( v212(VarCurr,bitIndex6)
        <=> v238(VarCurr,bitIndex6) )
        & ( v212(VarCurr,bitIndex5)
        <=> v238(VarCurr,bitIndex5) )
        & ( v212(VarCurr,bitIndex4)
        <=> v238(VarCurr,bitIndex4) )
        & ( v212(VarCurr,bitIndex3)
        <=> v238(VarCurr,bitIndex3) )
        & ( v212(VarCurr,bitIndex2)
        <=> v238(VarCurr,bitIndex2) )
        & ( v212(VarCurr,bitIndex1)
        <=> v238(VarCurr,bitIndex1) )
        & ( v212(VarCurr,bitIndex0)
        <=> v238(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_54,axiom,
    ! [VarCurr] :
      ( v246(VarCurr)
    <=> v248(VarCurr) ) ).

fof(addAssignment_53,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v238(VarCurr,B)
      <=> v240(VarCurr,B) ) ) ).

fof(addAssignment_52,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v240(VarCurr,B)
      <=> v242(VarCurr,B) ) ) ).

fof(addAssignment_51,axiom,
    ! [VarCurr] :
      ( ( v242(VarCurr,bitIndex7)
      <=> v244(VarCurr,bitIndex400) )
      & ( v242(VarCurr,bitIndex6)
      <=> v244(VarCurr,bitIndex399) )
      & ( v242(VarCurr,bitIndex5)
      <=> v244(VarCurr,bitIndex398) )
      & ( v242(VarCurr,bitIndex4)
      <=> v244(VarCurr,bitIndex397) )
      & ( v242(VarCurr,bitIndex3)
      <=> v244(VarCurr,bitIndex396) )
      & ( v242(VarCurr,bitIndex2)
      <=> v244(VarCurr,bitIndex395) )
      & ( v242(VarCurr,bitIndex1)
      <=> v244(VarCurr,bitIndex394) )
      & ( v242(VarCurr,bitIndex0)
      <=> v244(VarCurr,bitIndex393) ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_2,axiom,
    ! [VarCurr] :
      ( v210(VarCurr)
    <=> ( v233(VarCurr)
        & v234(VarCurr) ) ) ).

fof(writeUnaryOperator_1,axiom,
    ! [VarCurr] :
      ( ~ v234(VarCurr)
    <=> v225(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_2,axiom,
    ! [VarCurr] :
      ( v233(VarCurr)
    <=> ( ( v212(VarCurr,bitIndex7)
        <=> v214(VarCurr,bitIndex7) )
        & ( v212(VarCurr,bitIndex6)
        <=> v214(VarCurr,bitIndex6) )
        & ( v212(VarCurr,bitIndex5)
        <=> v214(VarCurr,bitIndex5) )
        & ( v212(VarCurr,bitIndex4)
        <=> v214(VarCurr,bitIndex4) )
        & ( v212(VarCurr,bitIndex3)
        <=> v214(VarCurr,bitIndex3) )
        & ( v212(VarCurr,bitIndex2)
        <=> v214(VarCurr,bitIndex2) )
        & ( v212(VarCurr,bitIndex1)
        <=> v214(VarCurr,bitIndex1) )
        & ( v212(VarCurr,bitIndex0)
        <=> v214(VarCurr,bitIndex0) ) ) ) ).

fof(addAssignment_50,axiom,
    ! [VarCurr] :
      ( v225(VarCurr)
    <=> v227(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted_1,axiom,
    ! [VarCurr] :
      ( v227(VarCurr)
    <=> ( ( v229(VarCurr,bitIndex3)
        <=> $false )
        & ( v229(VarCurr,bitIndex2)
        <=> $false )
        & ( v229(VarCurr,bitIndex1)
        <=> $false )
        & ( v229(VarCurr,bitIndex0)
        <=> $false ) ) ) ).

fof(bitBlastConstant_5,axiom,
    ~ b0000(bitIndex3) ).

fof(bitBlastConstant_4,axiom,
    ~ b0000(bitIndex2) ).

fof(bitBlastConstant_3,axiom,
    ~ b0000(bitIndex1) ).

fof(bitBlastConstant_2,axiom,
    ~ b0000(bitIndex0) ).

fof(addAssignment_49,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v214(VarCurr,B)
      <=> v216(VarCurr,B) ) ) ).

fof(addAssignment_48,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v216(VarCurr,B)
      <=> v218(VarCurr,B) ) ) ).

fof(addAssignment_47,axiom,
    ! [VarCurr,B] :
      ( range_7_0(B)
     => ( v218(VarCurr,B)
      <=> v223(VarCurr,B) ) ) ).

fof(range_axiom,axiom,
    ! [B] :
      ( range_7_0(B)
    <=> ( $false
        | bitIndex0 = B
        | bitIndex1 = B
        | bitIndex2 = B
        | bitIndex3 = B
        | bitIndex4 = B
        | bitIndex5 = B
        | bitIndex6 = B
        | bitIndex7 = B ) ) ).

fof(addAssignment_46,axiom,
    ! [VarCurr] :
      ( v173(VarCurr)
    <=> v175(VarCurr) ) ).

fof(addAssignment_45,axiom,
    ! [VarCurr] :
      ( v175(VarCurr)
    <=> v177(VarCurr) ) ).

fof(addAssignment_44,axiom,
    ! [VarCurr] :
      ( v177(VarCurr)
    <=> v179(VarCurr) ) ).

fof(addAssignment_43,axiom,
    ! [VarCurr] :
      ( v179(VarCurr)
    <=> v181(VarCurr) ) ).

fof(addAssignment_42,axiom,
    ! [VarCurr] :
      ( v181(VarCurr)
    <=> v183(VarCurr) ) ).

fof(addAssignment_41,axiom,
    ! [VarCurr] :
      ( v183(VarCurr)
    <=> v185(VarCurr) ) ).

fof(addAssignment_40,axiom,
    ! [VarCurr] :
      ( v185(VarCurr)
    <=> v187(VarCurr) ) ).

fof(addAssignment_39,axiom,
    ! [VarCurr] :
      ( v187(VarCurr)
    <=> v189(VarCurr) ) ).

fof(addAssignment_38,axiom,
    ! [VarCurr] :
      ( v189(VarCurr)
    <=> v191(VarCurr) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits_1,axiom,
    ! [VarCurr] :
      ( v191(VarCurr)
    <=> ( v193(VarCurr)
        | v201(VarCurr) ) ) ).

fof(addAssignment_37,axiom,
    ! [VarCurr] :
      ( v201(VarCurr)
    <=> v203(VarCurr,bitIndex6) ) ).

fof(addAssignment_36,axiom,
    ! [VarCurr] :
      ( v203(VarCurr,bitIndex6)
    <=> v205(VarCurr,bitIndex6) ) ).

fof(addAssignment_35,axiom,
    ! [VarCurr] :
      ( v205(VarCurr,bitIndex6)
    <=> v207(VarCurr,bitIndex6) ) ).

fof(addAssignment_34,axiom,
    ! [VarCurr] :
      ( v193(VarCurr)
    <=> v195(VarCurr,bitIndex2) ) ).

fof(addAssignment_33,axiom,
    ! [VarCurr] :
      ( v195(VarCurr,bitIndex2)
    <=> v197(VarCurr,bitIndex2) ) ).

fof(addAssignment_32,axiom,
    ! [VarCurr] :
      ( v197(VarCurr,bitIndex2)
    <=> v199(VarCurr,bitIndex2) ) ).

fof(addAssignment_31,axiom,
    ! [VarCurr] :
      ( v132(VarCurr)
    <=> v134(VarCurr) ) ).

fof(addAssignment_30,axiom,
    ! [VarCurr] :
      ( v134(VarCurr)
    <=> v136(VarCurr) ) ).

fof(addAssignment_29,axiom,
    ! [VarCurr] :
      ( v136(VarCurr)
    <=> v138(VarCurr) ) ).

fof(addAssignment_28,axiom,
    ! [VarCurr] :
      ( v138(VarCurr)
    <=> v140(VarCurr) ) ).

fof(addAssignment_27,axiom,
    ! [VarCurr] :
      ( v140(VarCurr)
    <=> v142(VarCurr) ) ).

fof(addAssignment_26,axiom,
    ! [VarCurr] :
      ( v142(VarCurr)
    <=> v144(VarCurr) ) ).

fof(addAssignment_25,axiom,
    ! [VarCurr] :
      ( v144(VarCurr)
    <=> v146(VarCurr) ) ).

fof(addBitVectorEqualityBitBlasted,axiom,
    ! [VarCurr] :
      ( v146(VarCurr)
    <=> ( ( v148(VarCurr,bitIndex1)
        <=> $true )
        & ( v148(VarCurr,bitIndex0)
        <=> $true ) ) ) ).

fof(bitBlastConstant_1,axiom,
    b11(bitIndex1) ).

fof(bitBlastConstant,axiom,
    b11(bitIndex0) ).

fof(addAssignment_24,axiom,
    ! [VarCurr] :
      ( v127(VarCurr)
    <=> v82(VarCurr) ) ).

fof(addAssignment_23,axiom,
    ! [VarCurr] :
      ( v96(VarCurr)
    <=> v98(VarCurr) ) ).

fof(addAssignment_22,axiom,
    ! [VarCurr] :
      ( v98(VarCurr)
    <=> v100(VarCurr) ) ).

fof(addAssignment_21,axiom,
    ! [VarCurr] :
      ( v100(VarCurr)
    <=> v102(VarCurr) ) ).

fof(addAssignment_20,axiom,
    ! [VarCurr] :
      ( v102(VarCurr)
    <=> v104(VarCurr) ) ).

fof(addAssignment_19,axiom,
    ! [VarCurr] :
      ( v104(VarCurr)
    <=> v106(VarCurr) ) ).

fof(addAssignment_18,axiom,
    ! [VarCurr] :
      ( v106(VarCurr)
    <=> v108(VarCurr) ) ).

fof(addAssignment_17,axiom,
    ! [VarCurr] :
      ( v108(VarCurr)
    <=> v110(VarCurr) ) ).

fof(addAssignment_16,axiom,
    ! [VarCurr] :
      ( v110(VarCurr)
    <=> v112(VarCurr,bitIndex1) ) ).

fof(addAssignment_15,axiom,
    ! [VarCurr] :
      ( v94(VarCurr)
    <=> v82(VarCurr) ) ).

fof(addAssignment_14,axiom,
    ! [VarCurr] :
      ( v82(VarCurr)
    <=> v84(VarCurr) ) ).

fof(addAssignment_13,axiom,
    ! [VarCurr] :
      ( v84(VarCurr)
    <=> v12(VarCurr) ) ).

fof(addAssignment_12,axiom,
    ! [VarCurr] :
      ( v66(VarCurr)
    <=> v8(VarCurr) ) ).

fof(addAssignment_11,axiom,
    ! [VarCurr] :
      ( v32(VarCurr)
    <=> v34(VarCurr) ) ).

fof(aaddConditionBooleanCondEqualRangesElseBranch,axiom,
    ! [VarCurr] :
      ( ~ v53(VarCurr)
     => ( v34(VarCurr)
      <=> $false ) ) ).

fof(addConditionBooleanCondEqualRangesThenBranch,axiom,
    ! [VarCurr] :
      ( v53(VarCurr)
     => ( v34(VarCurr)
      <=> $true ) ) ).

fof(writeBinaryOperatorEqualRangesSingleBits,axiom,
    ! [VarCurr] :
      ( v53(VarCurr)
    <=> ( v54(VarCurr)
        & v44(VarCurr) ) ) ).

fof(writeUnaryOperator,axiom,
    ! [VarCurr] :
      ( ~ v54(VarCurr)
    <=> v36(VarCurr,bitIndex8) ) ).

fof(addAssignment_10,axiom,
    ! [VarCurr] :
      ( v44(VarCurr)
    <=> v46(VarCurr) ) ).

fof(addAssignment_9,axiom,
    ! [VarCurr] :
      ( v46(VarCurr)
    <=> v48(VarCurr) ) ).

fof(addAssignment_8,axiom,
    ! [VarCurr] :
      ( v48(VarCurr)
    <=> v50(VarCurr) ) ).

fof(addAssignment_7,axiom,
    ! [VarCurr] :
      ( v36(VarCurr,bitIndex8)
    <=> v38(VarCurr,bitIndex8) ) ).

fof(addAssignment_6,axiom,
    ! [VarCurr] :
      ( v38(VarCurr,bitIndex8)
    <=> v40(VarCurr,bitIndex8) ) ).

fof(addAssignment_5,axiom,
    ! [VarCurr] :
      ( v40(VarCurr,bitIndex8)
    <=> v42(VarCurr,bitIndex8) ) ).

fof(addAssignment_4,axiom,
    ! [VarCurr] :
      ( v27(VarCurr)
    <=> v8(VarCurr) ) ).

fof(addAssignment_3,axiom,
    ! [VarCurr] :
      ( v8(VarCurr)
    <=> v10(VarCurr) ) ).

fof(addAssignment_2,axiom,
    ! [VarCurr] :
      ( v10(VarCurr)
    <=> v12(VarCurr) ) ).

fof(addAssignment_1,axiom,
    ! [VarCurr] :
      ( v12(VarCurr)
    <=> v14(VarCurr) ) ).

fof(addAssignment,axiom,
    ! [VarCurr] :
      ( v14(VarCurr)
    <=> v16(VarCurr) ) ).

%------------------------------------------------------------------------------
