%------------------------------------------------------------------------------
% File     : HWV072+1 : TPTP v9.2.0. Bugfixed v5.5.1.
% Domain   : Hardware Verification
% Problem  : QBFLib problem from the Counter family
% Version  : Especial.
% English  : A generator for the following problem. Given an n-bit-counter
%            with optional reset r and enable e signals, check whether it is
%            possible to reach the state where all n bits are set to 1
%            starting from the initial state where all bits are set to 0.

% Refs     : [Sei12] Seidl (2012), Email to Geoff Sutcliffe
%          : [SLB12] Seidl et al. (2012), Tool for Generating EPR Formulas
% Source   : [Sei12]
% Names    : counter_e_8-shuffled [Sei12]

% Status   : Satisfiable
% Rating   : 0.50 v9.0.0, 0.40 v8.2.0, 0.33 v8.1.0, 0.50 v7.5.0, 0.33 v7.1.0, 0.75 v7.0.0, 0.67 v6.4.0, 1.00 v6.0.0
% Syntax   : Number of formulae    :    2 (   1 unt;   0 def)
%            Number of atoms       : 3748 (   1 equ)
%            Maximal formula atoms : 3747 (1874 avg)
%            Number of connectives : 5638 (1892   ~;2488   |;1258   &)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%            Maximal formula depth : 1738 ( 870 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :    2 (   1 usr;   0 prp; 1-2 aty)
%            Number of functors    :    2 (   2 usr;   2 con; 0-0 aty)
%            Number of variables   :  476 (   8   !; 468   ?)
% SPC      : FOF_SAT_RFO_SEQ

% Comments :
% Bugfixes : v5.5.1 - Added true_not_false.
%------------------------------------------------------------------------------
fof(quant,axiom,
    ? [V289,V290,V291,V292,V293,V294,V295,V296,V297,V298,V299,V300,V301,V302,V303,V304,V305,V306,V307,V308,V309,V310,V311,V312,V313,V314,V315,V316,V317,V318,V319,V320,V321,V322,V323,V324,V451,V452,V453,V454,V455,V456,V457,V458,V459,V460,V461,V462,V463,V464,V465,V466,V467,V468] :
    ! [V476] :
    ? [V253,V254,V255,V256,V257,V258,V259,V260,V261,V262,V263,V264,V265,V266,V267,V268,V269,V270,V271,V272,V273,V274,V275,V276,V277,V278,V279,V280,V281,V282,V283,V284,V285,V286,V287,V288,V433,V434,V435,V436,V437,V438,V439,V440,V441,V442,V443,V444,V445,V446,V447,V448,V449,V450] :
    ! [V475] :
    ? [V217,V218,V219,V220,V221,V222,V223,V224,V225,V226,V227,V228,V229,V230,V231,V232,V233,V234,V235,V236,V237,V238,V239,V240,V241,V242,V243,V244,V245,V246,V247,V248,V249,V250,V251,V252,V415,V416,V417,V418,V419,V420,V421,V422,V423,V424,V425,V426,V427,V428,V429,V430,V431,V432] :
    ! [V474] :
    ? [V181,V182,V183,V184,V185,V186,V187,V188,V189,V190,V191,V192,V193,V194,V195,V196,V197,V198,V199,V200,V201,V202,V203,V204,V205,V206,V207,V208,V209,V210,V211,V212,V213,V214,V215,V216,V397,V398,V399,V400,V401,V402,V403,V404,V405,V406,V407,V408,V409,V410,V411,V412,V413,V414] :
    ! [V473] :
    ? [V145,V146,V147,V148,V149,V150,V151,V152,V153,V154,V155,V156,V157,V158,V159,V160,V161,V162,V163,V164,V165,V166,V167,V168,V169,V170,V171,V172,V173,V174,V175,V176,V177,V178,V179,V180,V379,V380,V381,V382,V383,V384,V385,V386,V387,V388,V389,V390,V391,V392,V393,V394,V395,V396] :
    ! [V472] :
    ? [V109,V110,V111,V112,V113,V114,V115,V116,V117,V118,V119,V120,V121,V122,V123,V124,V125,V126,V127,V128,V129,V130,V131,V132,V133,V134,V135,V136,V137,V138,V139,V140,V141,V142,V143,V144,V361,V362,V363,V364,V365,V366,V367,V368,V369,V370,V371,V372,V373,V374,V375,V376,V377,V378] :
    ! [V471] :
    ? [V73,V74,V75,V76,V77,V78,V79,V80,V81,V82,V83,V84,V85,V86,V87,V88,V89,V90,V91,V92,V93,V94,V95,V96,V97,V98,V99,V100,V101,V102,V103,V104,V105,V106,V107,V108,V343,V344,V345,V346,V347,V348,V349,V350,V351,V352,V353,V354,V355,V356,V357,V358,V359,V360] :
    ! [V470] :
    ? [V37,V38,V39,V40,V41,V42,V43,V44,V45,V46,V47,V48,V49,V50,V51,V52,V53,V54,V55,V56,V57,V58,V59,V60,V61,V62,V63,V64,V65,V66,V67,V68,V69,V70,V71,V72,V325,V326,V327,V328,V329,V330,V331,V332,V333,V334,V335,V336,V337,V338,V339,V340,V341,V342] :
    ! [V469] :
    ? [V1,V2,V3,V4,V5,V6,V7,V8,V9,V10,V11,V12,V13,V14,V15,V16,V17,V18,V19,V20,V21,V22,V23,V24,V25,V26,V27,V28,V29,V30,V31,V32,V33,V34,V35,V36] :
      ( p(true)
      & ~ p(false)
      & ( ~ p(V31)
        | p(V4)
        | ~ p(V1)
        | p(V13) )
      & ( ~ p(V17)
        | p(V35)
        | ~ p(V1)
        | p(V8) )
      & ( ~ p(V171)
        | p(V135)
        | p(V472) )
      & ( ~ p(V476)
        | ~ p(V467)
        | p(V287) )
      & ( p(V26)
        | ~ p(V469)
        | ~ p(V332) )
      & ( ~ p(V163)
        | ~ p(V473)
        | p(V397) )
      & ( p(V472)
        | p(V174)
        | ~ p(V138) )
      & ( p(V469)
        | ~ p(V62)
        | p(V26) )
      & ( ~ p(V227)
        | ~ p(V475)
        | p(V263) )
      & ( ~ p(V1)
        | ~ p(V7)
        | p(V16)
        | p(V34) )
      & ( p(V29)
        | p(V11)
        | ~ p(V1) )
      & ( p(V11)
        | ~ p(V469)
        | ~ p(V47) )
      & ( p(V474)
        | ~ p(V415)
        | p(V181) )
      & ( ~ p(V254)
        | p(V290)
        | ~ p(V476) )
      & ( p(V9)
        | ~ p(V8)
        | ~ p(V17) )
      & ( p(V471)
        | p(V361)
        | ~ p(V73) )
      & ( ~ p(V330)
        | p(V6)
        | p(V469) )
      & ( p(V34)
        | p(V7)
        | ~ p(V1)
        | ~ p(V16) )
      & ( ~ p(V472)
        | p(V142)
        | ~ p(V394) )
      & ( ~ p(V471)
        | ~ p(V73)
        | p(V109) )
      & ( ~ p(V472)
        | ~ p(V151)
        | p(V115) )
      & ( p(V378)
        | p(V471)
        | ~ p(V90) )
      & ( p(V474)
        | p(V247)
        | ~ p(V211) )
      & ( ~ p(V110)
        | p(V146)
        | ~ p(V472) )
      & ( ~ p(V18)
        | ~ p(V1)
        | ~ p(V9)
        | ~ p(V36) )
      & ( ~ p(V475)
        | ~ p(V241)
        | p(V439) )
      & ( p(V168)
        | ~ p(V204)
        | p(V473) )
      & ( ~ p(V103)
        | p(V471)
        | p(V139) )
      & ( ~ p(V360)
        | p(V470)
        | p(V54) )
      & ( ~ p(V470)
        | p(V66)
        | ~ p(V354) )
      & ( p(V429)
        | ~ p(V474)
        | ~ p(V213) )
      & ( ~ p(V61)
        | p(V349)
        | ~ p(V470) )
      & ( p(V164)
        | p(V473)
        | ~ p(V200) )
      & ( p(V113)
        | ~ p(V149)
        | ~ p(V472) )
      & ( p(V235)
        | p(V474)
        | ~ p(V199) )
      & ( p(V476)
        | ~ p(V274)
        | p(V310) )
      & ( p(V140)
        | ~ p(V472)
        | ~ p(V392) )
      & ( p(V31)
        | p(V13)
        | ~ p(V1)
        | ~ p(V4) )
      & ( p(V245)
        | ~ p(V475)
        | ~ p(V443) )
      & ( p(V475)
        | p(V285)
        | ~ p(V249) )
      & ( ~ p(V476)
        | p(V466)
        | ~ p(V286) )
      & ( p(V391)
        | ~ p(V121)
        | p(V472) )
      & ( p(V2)
        | ~ p(V38)
        | ~ p(V469) )
      & ( ~ p(V350)
        | p(V44)
        | p(V470) )
      & ( p(V44)
        | ~ p(V470)
        | ~ p(V80) )
      & ( ~ p(V14)
        | p(V6)
        | ~ p(V5) )
      & ( p(V476)
        | ~ p(V270)
        | p(V468) )
      & ( ~ p(V76)
        | p(V471)
        | p(V364) )
      & ( ~ p(V46)
        | ~ p(V470)
        | p(V82) )
      & ( p(V280)
        | ~ p(V244)
        | p(V475) )
      & ( ~ p(V469)
        | ~ p(V336)
        | p(V30) )
      & ( p(V227)
        | ~ p(V263)
        | ~ p(V475) )
      & ( ~ p(V471)
        | p(V124)
        | ~ p(V88) )
      & ( ~ p(V454)
        | ~ p(V476)
        | p(V274) )
      & ( p(V196)
        | p(V474)
        | ~ p(V430) )
      & ( p(V444)
        | ~ p(V246)
        | ~ p(V475) )
      & ( p(V277)
        | ~ p(V457)
        | ~ p(V476) )
      & ( p(V269)
        | p(V476)
        | ~ p(V467) )
      & ( ~ p(V470)
        | p(V348)
        | ~ p(V60) )
      & ( ~ p(V474)
        | p(V232)
        | ~ p(V196) )
      & ( ~ p(V428)
        | p(V474)
        | p(V194) )
      & ( p(V474)
        | p(V195)
        | ~ p(V429) )
      & ( ~ p(V323)
        | p(V287)
        | p(V476) )
      & ( p(V474)
        | p(V241)
        | ~ p(V205) )
      & ( ~ p(V473)
        | ~ p(V172)
        | p(V406) )
      & ( ~ p(V471)
        | p(V119)
        | ~ p(V83) )
      & ( ~ p(V179)
        | p(V143)
        | p(V472) )
      & ( ~ p(V305)
        | p(V269)
        | ~ p(V476) )
      & ( p(V473)
        | p(V171)
        | ~ p(V207) )
      & ( p(V172)
        | ~ p(V136)
        | p(V472) )
      & ( p(V265)
        | ~ p(V301)
        | ~ p(V476) )
      & ( ~ p(V471)
        | p(V103)
        | ~ p(V373) )
      & ( p(V176)
        | ~ p(V140)
        | p(V472) )
      & ( ~ p(V357)
        | p(V470)
        | p(V51) )
      & ( p(V476)
        | ~ p(V258)
        | p(V456) )
      & ( ~ p(V146)
        | ~ p(V473)
        | p(V182) )
      & ( p(V200)
        | p(V473)
        | ~ p(V164) )
      & ( ~ p(V139)
        | p(V472)
        | p(V175) )
      & ( p(V236)
        | p(V475)
        | ~ p(V272) )
      & ( p(V475)
        | p(V252)
        | ~ p(V288) )
      & ( ~ p(V1)
        | ~ p(V7)
        | ~ p(V16)
        | ~ p(V34) )
      & ( p(V178)
        | p(V473)
        | ~ p(V214) )
      & ( ~ p(V32)
        | p(V14)
        | p(V1) )
      & ( ~ p(V476)
        | p(V262)
        | ~ p(V298) )
      & ( p(V356)
        | p(V470)
        | ~ p(V50) )
      & ( ~ p(V275)
        | ~ p(V476)
        | p(V455) )
      & ( p(V472)
        | p(V170)
        | ~ p(V134) )
      & ( p(V476)
        | p(V282)
        | ~ p(V318) )
      & ( ~ p(V77)
        | p(V41)
        | ~ p(V470) )
      & ~ p(V290)
      & ( ~ p(V228)
        | p(V444)
        | p(V475) )
      & ( p(V475)
        | p(V277)
        | ~ p(V241) )
      & ( ~ p(V470)
        | ~ p(V66)
        | p(V354) )
      & ( p(V333)
        | ~ p(V27)
        | ~ p(V469) )
      & ( ~ p(V475)
        | ~ p(V259)
        | p(V223) )
      & ( p(V170)
        | ~ p(V206)
        | p(V473) )
      & ( ~ p(V123)
        | ~ p(V471)
        | p(V87) )
      & ( p(V344)
        | p(V470)
        | ~ p(V38) )
      & ( ~ p(V18)
        | p(V36)
        | p(V1) )
      & ( p(V347)
        | ~ p(V470)
        | ~ p(V59) )
      & ( p(V473)
        | p(V413)
        | ~ p(V161) )
      & ( p(V130)
        | ~ p(V472)
        | ~ p(V382) )
      & ( p(V433)
        | ~ p(V235)
        | ~ p(V475) )
      & ( p(V8)
        | ~ p(V44)
        | ~ p(V469) )
      & ( ~ p(V422)
        | ~ p(V474)
        | p(V206) )
      & ( p(V409)
        | ~ p(V473)
        | ~ p(V175) )
      & ( p(V474)
        | ~ p(V432)
        | p(V198) )
      & ( ~ p(V408)
        | p(V174)
        | ~ p(V473) )
      & ( ~ p(V140)
        | ~ p(V472)
        | p(V392) )
      & ( p(V96)
        | p(V471)
        | ~ p(V132) )
      & ( ~ p(V52)
        | ~ p(V469)
        | p(V16) )
      & ( ~ p(V476)
        | ~ p(V277)
        | p(V457) )
      & ( ~ p(V476)
        | p(V283)
        | ~ p(V463) )
      & ( ~ p(V146)
        | p(V473)
        | p(V398) )
      & ( ~ p(V475)
        | p(V438)
        | ~ p(V240) )
      & ( ~ p(V476)
        | ~ p(V466)
        | p(V286) )
      & ( p(V5)
        | ~ p(V1)
        | ~ p(V32)
        | p(V14) )
      & ( ~ p(V164)
        | p(V472)
        | p(V128) )
      & ( p(V36)
        | ~ p(V72)
        | p(V469) )
      & ( ~ p(V9)
        | p(V333)
        | p(V469) )
      & ( p(V169)
        | ~ p(V133)
        | p(V472) )
      & ( p(V201)
        | p(V473)
        | ~ p(V165) )
      & ( ~ p(V22)
        | p(V30) )
      & ( ~ p(V364)
        | p(V471)
        | p(V76) )
      & ( p(V473)
        | p(V173)
        | ~ p(V209) )
      & ( ~ p(V471)
        | p(V73)
        | ~ p(V109) )
      & ( p(V46)
        | ~ p(V469)
        | ~ p(V10) )
      & ( p(V379)
        | ~ p(V127)
        | ~ p(V472) )
      & ( p(V474)
        | ~ p(V246)
        | p(V210) )
      & ( p(V23)
        | p(V469)
        | ~ p(V59) )
      & ( p(V326)
        | p(V469)
        | ~ p(V2) )
      & ( ~ p(V104)
        | p(V374)
        | ~ p(V471) )
      & ( ~ p(V44)
        | ~ p(V470)
        | p(V80) )
      & ( ~ p(V177)
        | p(V411)
        | ~ p(V473) )
      & ( p(V238)
        | ~ p(V436)
        | ~ p(V475) )
      & ( p(V25)
        | ~ p(V26) )
      & ( p(V470)
        | ~ p(V70)
        | p(V106) )
      & ( ~ p(V81)
        | p(V369)
        | p(V471) )
      & ( ~ p(V31)
        | p(V13)
        | p(V1) )
      & ( ~ p(V5)
        | p(V13) )
      & ( p(V95)
        | ~ p(V365)
        | ~ p(V471) )
      & ( p(V157)
        | ~ p(V193)
        | ~ p(V473) )
      & ( p(V163)
        | ~ p(V127)
        | p(V472) )
      & ( ~ p(V471)
        | ~ p(V367)
        | p(V97) )
      & ( p(V12)
        | p(V1)
        | ~ p(V30) )
      & ( p(V410)
        | ~ p(V473)
        | ~ p(V176) )
      & ( p(V349)
        | p(V470)
        | ~ p(V43) )
      & ( ~ p(V32)
        | ~ p(V1)
        | ~ p(V5)
        | ~ p(V14) )
      & ( p(V115)
        | ~ p(V79)
        | ~ p(V471) )
      & ( p(V7)
        | p(V469)
        | ~ p(V331) )
      & ( p(V106)
        | ~ p(V142)
        | p(V471) )
      & ( ~ p(V327)
        | ~ p(V469)
        | p(V21) )
      & ( ~ p(V242)
        | p(V278)
        | p(V475) )
      & ( ~ p(V159)
        | p(V411)
        | p(V473) )
      & ( ~ p(V475)
        | ~ p(V250)
        | p(V448) )
      & ( ~ p(V261)
        | ~ p(V475)
        | p(V225) )
      & ( ~ p(V16)
        | ~ p(V469)
        | p(V52) )
      & ( p(V376)
        | ~ p(V88)
        | p(V471) )
      & ( p(V472)
        | p(V136)
        | ~ p(V172) )
      & ( p(V476)
        | p(V454)
        | ~ p(V256) )
      & ( p(V259)
        | ~ p(V457)
        | p(V476) )
      & ( p(V284)
        | ~ p(V320)
        | p(V476) )
      & ( ~ p(V472)
        | ~ p(V388)
        | p(V136) )
      & ( ~ p(V474)
        | p(V431)
        | ~ p(V215) )
      & ( p(V199)
        | p(V474)
        | ~ p(V235) )
      & ( ~ p(V121)
        | p(V85)
        | ~ p(V471) )
      & ( p(V283)
        | ~ p(V247)
        | p(V475) )
      & ( ~ p(V98)
        | p(V368)
        | ~ p(V471) )
      & ( ~ p(V208)
        | p(V244)
        | p(V474) )
      & ( ~ p(V55)
        | p(V470)
        | p(V91) )
      & ( ~ p(V476)
        | ~ p(V264)
        | p(V300) )
      & ( ~ p(V303)
        | p(V267)
        | ~ p(V476) )
      & ( ~ p(V470)
        | p(V64)
        | ~ p(V352) )
      & ( ~ p(V39)
        | p(V75)
        | ~ p(V470) )
      & ( p(V450)
        | ~ p(V234)
        | p(V475) )
      & ( p(V4)
        | p(V469)
        | ~ p(V328) )
      & ( ~ p(V197)
        | ~ p(V474)
        | p(V233) )
      & ( ~ p(V205)
        | p(V169)
        | p(V473) )
      & ( p(V337)
        | p(V469)
        | ~ p(V13) )
      & ( p(V426)
        | ~ p(V192)
        | p(V474) )
      & ( p(V4)
        | ~ p(V469)
        | ~ p(V40) )
      & ( p(V472)
        | ~ p(V169)
        | p(V133) )
      & ( ~ p(V210)
        | p(V426)
        | ~ p(V474) )
      & ( p(V125)
        | ~ p(V89)
        | ~ p(V471) )
      & ( p(V217)
        | p(V475)
        | ~ p(V433) )
      & ( ~ p(V474)
        | ~ p(V420)
        | p(V204) )
      & ( ~ p(V313)
        | p(V277)
        | p(V476) )
      & ( p(V470)
        | p(V41)
        | ~ p(V347) )
      & ( p(V475)
        | p(V284)
        | ~ p(V248) )
      & ( p(V281)
        | p(V475)
        | ~ p(V245) )
      & ( ~ p(V117)
        | p(V472)
        | p(V387) )
      & ( p(V160)
        | ~ p(V473)
        | ~ p(V196) )
      & ( p(V470)
        | ~ p(V42)
        | p(V348) )
      & ( ~ p(V473)
        | p(V181)
        | ~ p(V145) )
      & ( ~ p(V470)
        | ~ p(V89)
        | p(V53) )
      & ( ~ p(V475)
        | ~ p(V249)
        | p(V447) )
      & ( p(V468)
        | ~ p(V476)
        | ~ p(V288) )
      & ( ~ p(V137)
        | p(V472)
        | p(V173) )
      & ( p(V472)
        | ~ p(V387)
        | p(V117) )
      & ( ~ p(V102)
        | ~ p(V471)
        | p(V372) )
      & ( ~ p(V470)
        | ~ p(V343)
        | p(V55) )
      & ( p(V257)
        | ~ p(V476)
        | ~ p(V293) )
      & ( p(V463)
        | ~ p(V283)
        | ~ p(V476) )
      & ( ~ p(V53)
        | p(V359)
        | p(V470) )
      & ( p(V252)
        | ~ p(V216)
        | p(V474) )
      & ( ~ p(V373)
        | p(V471)
        | p(V85) )
      & ( ~ p(V471)
        | ~ p(V82)
        | p(V118) )
      & ( ~ p(V197)
        | ~ p(V473)
        | p(V161) )
      & ( p(V471)
        | ~ p(V127)
        | p(V91) )
      & ( p(V95)
        | ~ p(V59)
        | p(V470) )
      & ( p(V473)
        | p(V155)
        | ~ p(V407) )
      & ( p(V5)
        | p(V32)
        | ~ p(V14)
        | ~ p(V1) )
      & ( p(V159)
        | ~ p(V195)
        | ~ p(V473) )
      & ( ~ p(V284)
        | p(V475)
        | p(V248) )
      & ( ~ p(V5)
        | p(V469)
        | p(V329) )
      & ( ~ p(V473)
        | ~ p(V168)
        | p(V402) )
      & ( p(V474)
        | p(V202)
        | ~ p(V238) )
      & ( p(V275)
        | ~ p(V455)
        | ~ p(V476) )
      & ( p(V469)
        | p(V332)
        | ~ p(V8) )
      & ( ~ p(V24)
        | p(V23) )
      & ( ~ p(V431)
        | p(V197)
        | p(V474) )
      & ( ~ p(V43)
        | ~ p(V470)
        | p(V79) )
      & ( p(V99)
        | p(V470)
        | ~ p(V63) )
      & ( p(V258)
        | p(V476)
        | ~ p(V456) )
      & ( p(V261)
        | ~ p(V475)
        | ~ p(V225) )
      & ( ~ p(V244)
        | ~ p(V475)
        | p(V442) )
      & ( p(V268)
        | p(V476)
        | ~ p(V466) )
      & ( p(V117)
        | ~ p(V153)
        | ~ p(V472) )
      & ( ~ p(V255)
        | p(V453)
        | p(V476) )
      & ( p(V160)
        | ~ p(V124)
        | ~ p(V472) )
      & ( p(V414)
        | ~ p(V180)
        | ~ p(V473) )
      & ( ~ p(V218)
        | p(V182)
        | ~ p(V474) )
      & ( p(V252)
        | ~ p(V475)
        | ~ p(V450) )
      & ( ~ p(V47)
        | p(V353)
        | p(V470) )
      & ( ~ p(V108)
        | p(V471)
        | p(V144) )
      & ( p(V118)
        | p(V472)
        | ~ p(V388) )
      & ( p(V472)
        | p(V110)
        | ~ p(V380) )
      & ( ~ p(V473)
        | p(V167)
        | ~ p(V401) )
      & ( p(V475)
        | p(V436)
        | ~ p(V220) )
      & ( ~ p(V95)
        | ~ p(V471)
        | p(V365) )
      & ( ~ p(V190)
        | ~ p(V473)
        | p(V154) )
      & ( p(V450)
        | ~ p(V252)
        | ~ p(V475) )
      & ( p(V331)
        | ~ p(V469)
        | ~ p(V25) )
      & ( p(V197)
        | ~ p(V473)
        | ~ p(V161) )
      & ( p(V148)
        | ~ p(V400)
        | p(V473) )
      & ( ~ p(V456)
        | ~ p(V476)
        | p(V276) )
      & ( p(V210)
        | ~ p(V474)
        | ~ p(V426) )
      & ( p(V22)
        | p(V469)
        | ~ p(V58) )
      & ( ~ p(V475)
        | ~ p(V219)
        | p(V255) )
      & ( ~ p(V25)
        | p(V24) )
      & ( ~ p(V470)
        | p(V358)
        | ~ p(V70) )
      & ( ~ p(V88)
        | ~ p(V470)
        | p(V52) )
      & ( p(V92)
        | ~ p(V471)
        | ~ p(V362) )
      & ( p(V471)
        | ~ p(V141)
        | p(V105) )
      & ( ~ p(V1)
        | ~ p(V9)
        | p(V18)
        | p(V36) )
      & ( ~ p(V31)
        | ~ p(V4)
        | ~ p(V1)
        | ~ p(V13) )
      & ( ~ p(V476)
        | p(V270)
        | ~ p(V306) )
      & ( p(V146)
        | ~ p(V398)
        | p(V473) )
      & ( p(V462)
        | ~ p(V282)
        | ~ p(V476) )
      & ( p(V213)
        | ~ p(V429)
        | ~ p(V474) )
      & ( ~ p(V380)
        | p(V128)
        | ~ p(V472) )
      & ( p(V476)
        | p(V262)
        | ~ p(V460) )
      & ~ p(V305)
      & ( ~ p(V474)
        | p(V418)
        | ~ p(V202) )
      & ( ~ p(V399)
        | ~ p(V473)
        | p(V165) )
      & ( ~ p(V393)
        | p(V123)
        | p(V472) )
      & ( p(V320)
        | ~ p(V284)
        | p(V476) )
      & ( ~ p(V230)
        | p(V194)
        | ~ p(V474) )
      & ( ~ p(V48)
        | p(V354)
        | p(V470) )
      & ( ~ p(V23)
        | p(V22) )
      & ( p(V141)
        | p(V471)
        | ~ p(V105) )
      & ( p(V476)
        | p(V264)
        | ~ p(V462) )
      & ( p(V420)
        | p(V474)
        | ~ p(V186) )
      & ( ~ p(V469)
        | p(V20)
        | ~ p(V326) )
      & ( ~ p(V36)
        | p(V28)
        | ~ p(V27) )
      & ( ~ p(V25)
        | p(V33) )
      & ( p(V28)
        | ~ p(V469)
        | ~ p(V334) )
      & ( ~ p(V226)
        | p(V190)
        | ~ p(V474) )
      & ( p(V228)
        | p(V475)
        | ~ p(V444) )
      & ( p(V475)
        | ~ p(V238)
        | p(V274) )
      & ( ~ p(V469)
        | ~ p(V331)
        | p(V25) )
      & ( ~ p(V281)
        | p(V461)
        | ~ p(V476) )
      & ( p(V65)
        | ~ p(V353)
        | ~ p(V470) )
      & ( p(V470)
        | ~ p(V343)
        | p(V37) )
      & ( p(V195)
        | ~ p(V474)
        | ~ p(V231) )
      & ( p(V15)
        | ~ p(V7) )
      & ( ~ p(V78)
        | p(V366)
        | p(V471) )
      & ( p(V275)
        | ~ p(V311)
        | p(V476) )
      & ( ~ p(V476)
        | ~ p(V287)
        | p(V467) )
      & ~ p(V303)
      & ( ~ p(V458)
        | p(V278)
        | ~ p(V476) )
      & ( p(V476)
        | p(V270)
        | ~ p(V468) )
      & ( ~ p(V351)
        | p(V63)
        | ~ p(V470) )
      & ( ~ p(V211)
        | ~ p(V474)
        | p(V427) )
      & ( p(V59)
        | p(V469)
        | ~ p(V23) )
      & ( ~ p(V471)
        | p(V86)
        | ~ p(V122) )
      & ( p(V336)
        | ~ p(V469)
        | ~ p(V30) )
      & ( ~ p(V38)
        | ~ p(V470)
        | p(V74) )
      & ( p(V97)
        | ~ p(V61)
        | p(V470) )
      & ( ~ p(V475)
        | ~ p(V437)
        | p(V239) )
      & ( ~ p(V419)
        | p(V203)
        | ~ p(V474) )
      & ( ~ p(V151)
        | p(V403)
        | p(V473) )
      & ( ~ p(V472)
        | ~ p(V119)
        | p(V155) )
      & ( p(V42)
        | ~ p(V470)
        | ~ p(V78) )
      & ( ~ p(V472)
        | ~ p(V144)
        | p(V396) )
      & ( p(V1)
        | ~ p(V14)
        | p(V32) )
      & ( ~ p(V221)
        | ~ p(V475)
        | p(V257) )
      & ( ~ p(V475)
        | ~ p(V267)
        | p(V231) )
      & ( ~ p(V473)
        | ~ p(V148)
        | p(V184) )
      & ( ~ p(V470)
        | p(V56)
        | ~ p(V344) )
      & ( p(V260)
        | ~ p(V296)
        | ~ p(V476) )
      & ( ~ p(V401)
        | p(V473)
        | p(V149) )
      & ( ~ p(V472)
        | ~ p(V114)
        | p(V150) )
      & ( p(V472)
        | p(V383)
        | ~ p(V113) )
      & ( p(V100)
        | ~ p(V136)
        | p(V471) )
      & ( p(V473)
        | ~ p(V199)
        | p(V163) )
      & ( ~ p(V24)
        | p(V32) )
      & ( ~ p(V222)
        | ~ p(V474)
        | p(V186) )
      & ( p(V150)
        | p(V473)
        | ~ p(V402) )
      & ( p(V102)
        | ~ p(V471)
        | ~ p(V372) )
      & ( p(V188)
        | ~ p(V224)
        | ~ p(V474) )
      & ( p(V286)
        | ~ p(V322)
        | p(V476) )
      & ( ~ p(V473)
        | p(V155)
        | ~ p(V191) )
      & ( p(V473)
        | p(V161)
        | ~ p(V413) )
      & ( ~ p(V476)
        | p(V299)
        | ~ p(V263) )
      & ( p(V63)
        | ~ p(V99)
        | p(V470) )
      & ( ~ p(V471)
        | p(V100)
        | ~ p(V370) )
      & ( ~ p(V49)
        | ~ p(V469)
        | p(V13) )
      & ( p(V475)
        | ~ p(V287)
        | p(V251) )
      & ( p(V191)
        | p(V474)
        | ~ p(V425) )
      & ( ~ p(V117)
        | ~ p(V471)
        | p(V81) )
      & ( p(V449)
        | p(V475)
        | ~ p(V233) )
      & ( p(V388)
        | ~ p(V118)
        | p(V472) )
      & ( ~ p(V472)
        | ~ p(V161)
        | p(V125) )
      & ( p(V246)
        | ~ p(V444)
        | ~ p(V475) )
      & ( p(V206)
        | ~ p(V242)
        | p(V474) )
      & ( ~ p(V107)
        | p(V377)
        | ~ p(V471) )
      & ( ~ p(V195)
        | p(V474)
        | p(V429) )
      & ( ~ p(V356)
        | p(V68)
        | ~ p(V470) )
      & ( p(V394)
        | ~ p(V142)
        | ~ p(V472) )
      & ( ~ p(V439)
        | p(V475)
        | p(V223) )
      & ( ~ p(V471)
        | p(V363)
        | ~ p(V93) )
      & ( p(V185)
        | ~ p(V419)
        | p(V474) )
      & ( ~ p(V118)
        | p(V154)
        | ~ p(V472) )
      & ( ~ p(V64)
        | p(V469)
        | p(V28) )
      & ~ p(V306)
      & ( p(V474)
        | ~ p(V244)
        | p(V208) )
      & ( ~ p(V102)
        | p(V471)
        | p(V138) )
      & ( p(V65)
        | p(V470)
        | ~ p(V101) )
      & ( ~ p(V262)
        | p(V476)
        | p(V460) )
      & ( ~ p(V469)
        | p(V43)
        | ~ p(V7) )
      & ( p(V470)
        | ~ p(V348)
        | p(V42) )
      & ( ~ p(V473)
        | ~ p(V182)
        | p(V146) )
      & ( ~ p(V474)
        | ~ p(V185)
        | p(V221) )
      & ( p(V475)
        | ~ p(V250)
        | p(V286) )
      & ( p(V338)
        | ~ p(V14)
        | p(V469) )
      & ( ~ p(V91)
        | p(V127)
        | p(V471) )
      & ( ~ p(V476)
        | p(V453)
        | ~ p(V273) )
      & ( p(V178)
        | ~ p(V142)
        | p(V472) )
      & ( ~ p(V470)
        | ~ p(V86)
        | p(V50) )
      & ( p(V298)
        | ~ p(V476)
        | ~ p(V262) )
      & ( p(V471)
        | ~ p(V139)
        | p(V103) )
      & ( ~ p(V242)
        | p(V440)
        | ~ p(V475) )
      & ( ~ p(V34)
        | p(V1)
        | p(V16) )
      & ( ~ p(V389)
        | p(V119)
        | p(V472) )
      & ( p(V162)
        | ~ p(V126)
        | ~ p(V472) )
      & ( ~ p(V442)
        | ~ p(V475)
        | p(V244) )
      & ( ~ p(V35)
        | ~ p(V26)
        | p(V27) )
      & ( p(V223)
        | ~ p(V187)
        | ~ p(V474) )
      & ( p(V471)
        | ~ p(V370)
        | p(V82) )
      & ( ~ p(V474)
        | ~ p(V199)
        | p(V415) )
      & ( p(V472)
        | ~ p(V125)
        | p(V395) )
      & ( ~ p(V475)
        | ~ p(V239)
        | p(V437) )
      & ( p(V84)
        | ~ p(V471)
        | ~ p(V120) )
      & ( p(V425)
        | ~ p(V474)
        | ~ p(V209) )
      & ( p(V12)
        | ~ p(V1)
        | p(V30)
        | ~ p(V3) )
      & ( p(V471)
        | p(V101)
        | ~ p(V137) )
      & ( p(V404)
        | p(V473)
        | ~ p(V152) )
      & ( p(V130)
        | p(V472)
        | ~ p(V166) )
      & ( ~ p(V107)
        | p(V471)
        | p(V143) )
      & ( ~ p(V103)
        | p(V373)
        | ~ p(V471) )
      & ( p(V476)
        | ~ p(V260)
        | p(V458) )
      & ( p(V68)
        | ~ p(V104)
        | p(V470) )
      & ( p(V469)
        | ~ p(V65)
        | p(V29) )
      & ( ~ p(V76)
        | ~ p(V470)
        | p(V40) )
      & ( p(V228)
        | ~ p(V474)
        | ~ p(V192) )
      & ( ~ p(V473)
        | p(V176)
        | ~ p(V410) )
      & ( ~ p(V266)
        | ~ p(V475)
        | p(V230) )
      & ( ~ p(V191)
        | p(V425)
        | p(V474) )
      & ( ~ p(V449)
        | p(V475)
        | p(V233) )
      & ( ~ p(V472)
        | p(V147)
        | ~ p(V111) )
      & ( ~ p(V476)
        | p(V297)
        | ~ p(V261) )
      & ( p(V398)
        | ~ p(V164)
        | ~ p(V473) )
      & ( ~ p(V472)
        | p(V122)
        | ~ p(V158) )
      & ( ~ p(V49)
        | ~ p(V470)
        | p(V85) )
      & ( ~ p(V470)
        | p(V86)
        | ~ p(V50) )
      & ( p(V271)
        | p(V475)
        | ~ p(V235) )
      & ( p(V57)
        | ~ p(V345)
        | ~ p(V470) )
      & ( ~ p(V365)
        | p(V77)
        | p(V471) )
      & ( p(V189)
        | p(V474)
        | ~ p(V423) )
      & ( ~ p(V476)
        | ~ p(V462)
        | p(V282) )
      & ( p(V44)
        | ~ p(V8)
        | ~ p(V469) )
      & ( ~ p(V476)
        | ~ p(V460)
        | p(V280) )
      & ( ~ p(V470)
        | p(V87)
        | ~ p(V51) )
      & ( ~ p(V473)
        | ~ p(V166)
        | p(V400) )
      & ( ~ p(V51)
        | ~ p(V469)
        | p(V15) )
      & ( p(V470)
        | p(V64)
        | ~ p(V100) )
      & ( p(V81)
        | ~ p(V45)
        | ~ p(V470) )
      & ( p(V475)
        | ~ p(V443)
        | p(V227) )
      & ( p(V14)
        | ~ p(V6) )
      & ( ~ p(V472)
        | p(V393)
        | ~ p(V141) )
      & ( p(V73)
        | ~ p(V37)
        | ~ p(V470) )
      & ( ~ p(V115)
        | p(V151)
        | ~ p(V472) )
      & ( p(V33)
        | ~ p(V469)
        | ~ p(V339) )
      & ( ~ p(V471)
        | p(V75)
        | ~ p(V111) )
      & ( p(V421)
        | ~ p(V474)
        | ~ p(V205) )
      & ( ~ p(V474)
        | ~ p(V424)
        | p(V208) )
      & ( p(V243)
        | ~ p(V207)
        | p(V474) )
      & ( p(V473)
        | p(V151)
        | ~ p(V403) )
      & ( p(V473)
        | p(V206)
        | ~ p(V170) )
      & ( ~ p(V476)
        | ~ p(V461)
        | p(V281) )
      & ( ~ p(V163)
        | p(V472)
        | p(V127) )
      & ( ~ p(V33)
        | p(V25)
        | ~ p(V24) )
      & ( p(V469)
        | ~ p(V63)
        | p(V27) )
      & ( ~ p(V473)
        | p(V404)
        | ~ p(V170) )
      & ( p(V55)
        | ~ p(V19)
        | p(V469) )
      & ( p(V273)
        | ~ p(V237)
        | p(V475) )
      & ( p(V463)
        | ~ p(V265)
        | p(V476) )
      & ( ~ p(V4)
        | p(V3) )
      & ( ~ p(V471)
        | ~ p(V87)
        | p(V123) )
      & ( ~ p(V226)
        | p(V262)
        | ~ p(V475) )
      & ( p(V160)
        | p(V473)
        | ~ p(V412) )
      & ( ~ p(V184)
        | p(V220)
        | ~ p(V474) )
      & ( ~ p(V269)
        | ~ p(V475)
        | p(V233) )
      & ( ~ p(V169)
        | p(V473)
        | p(V205) )
      & ( p(V473)
        | ~ p(V160)
        | p(V412) )
      & ( p(V378)
        | ~ p(V471)
        | ~ p(V108) )
      & ( ~ p(V475)
        | ~ p(V439)
        | p(V241) )
      & ( ~ p(V473)
        | p(V170)
        | ~ p(V404) )
      & ( ~ p(V472)
        | ~ p(V148)
        | p(V112) )
      & ( ~ p(V85)
        | ~ p(V471)
        | p(V121) )
      & ( p(V465)
        | ~ p(V285)
        | ~ p(V476) )
      & ( p(V408)
        | ~ p(V473)
        | ~ p(V174) )
      & ( ~ p(V473)
        | ~ p(V413)
        | p(V179) )
      & ( p(V248)
        | p(V474)
        | ~ p(V212) )
      & ( p(V471)
        | ~ p(V368)
        | p(V80) )
      & ( p(V94)
        | ~ p(V130)
        | p(V471) )
      & ( ~ p(V474)
        | p(V199)
        | ~ p(V415) )
      & ( p(V131)
        | ~ p(V472)
        | ~ p(V383) )
      & ( p(V358)
        | p(V470)
        | ~ p(V52) )
      & ( p(V473)
        | ~ p(V399)
        | p(V147) )
      & ( ~ p(V133)
        | ~ p(V472)
        | p(V385) )
      & ( p(V36)
        | ~ p(V28) )
      & ( p(V471)
        | p(V372)
        | ~ p(V84) )
      & ( p(V474)
        | ~ p(V189)
        | p(V423) )
      & ( ~ p(V470)
        | ~ p(V347)
        | p(V59) )
      & ( p(V470)
        | p(V58)
        | ~ p(V94) )
      & ( ~ p(V30)
        | p(V66)
        | p(V469) )
      & ( ~ p(V471)
        | p(V111)
        | ~ p(V75) )
      & ( ~ p(V405)
        | p(V153)
        | p(V473) )
      & p(V308)
      & ( ~ p(V473)
        | ~ p(V160)
        | p(V196) )
      & ( p(V389)
        | ~ p(V119)
        | p(V472) )
      & ( p(V472)
        | p(V386)
        | ~ p(V116) )
      & ( ~ p(V335)
        | p(V469)
        | p(V11) )
      & ( ~ p(V367)
        | p(V79)
        | p(V471) )
      & ( p(V3)
        | p(V30)
        | ~ p(V12)
        | ~ p(V1) )
      & ( p(V254)
        | ~ p(V475)
        | ~ p(V218) )
      & ( p(V61)
        | p(V469)
        | ~ p(V25) )
      & ( ~ p(V15)
        | p(V469)
        | p(V339) )
      & ( ~ p(V82)
        | p(V471)
        | p(V370) )
      & ( p(V399)
        | ~ p(V165)
        | ~ p(V473) )
      & ( ~ p(V474)
        | p(V189)
        | ~ p(V225) )
      & ( ~ p(V280)
        | p(V475)
        | p(V244) )
      & ( p(V469)
        | p(V1)
        | ~ p(V325) )
      & ( ~ p(V28)
        | p(V27) )
      & ( p(V446)
        | p(V475)
        | ~ p(V230) )
      & ( p(V472)
        | ~ p(V379)
        | p(V109) )
      & ( p(V471)
        | ~ p(V99)
        | p(V135) )
      & ( p(V470)
        | ~ p(V107)
        | p(V71) )
      & ( p(V472)
        | p(V385)
        | ~ p(V115) )
      & ( ~ p(V468)
        | p(V288)
        | ~ p(V476) )
      & ( p(V470)
        | p(V60)
        | ~ p(V96) )
      & ( p(V475)
        | ~ p(V246)
        | p(V282) )
      & ( ~ p(V276)
        | p(V475)
        | p(V240) )
      & ( p(V192)
        | ~ p(V228)
        | ~ p(V474) )
      & ( p(V251)
        | p(V474)
        | ~ p(V215) )
      & ( p(V202)
        | ~ p(V474)
        | ~ p(V418) )
      & ( ~ p(V472)
        | p(V389)
        | ~ p(V137) )
      & ( ~ p(V425)
        | p(V209)
        | ~ p(V474) )
      & ( ~ p(V475)
        | p(V237)
        | ~ p(V435) )
      & ( p(V422)
        | ~ p(V206)
        | ~ p(V474) )
      & ( ~ p(V450)
        | p(V475)
        | p(V234) )
      & ~ p(V302)
      & ( ~ p(V43)
        | p(V7)
        | ~ p(V469) )
      & ( ~ p(V155)
        | p(V119)
        | ~ p(V472) )
      & ( ~ p(V247)
        | ~ p(V475)
        | p(V445) )
      & ( p(V470)
        | p(V38)
        | ~ p(V344) )
      & ( p(V34)
        | ~ p(V469)
        | ~ p(V340) )
      & ( ~ p(V474)
        | p(V230)
        | ~ p(V194) )
      & ( p(V475)
        | p(V437)
        | ~ p(V221) )
      & ( ~ p(V21)
        | p(V469)
        | p(V57) )
      & ( ~ p(V475)
        | p(V228)
        | ~ p(V264) )
      & ( ~ p(V382)
        | p(V112)
        | p(V472) )
      & ( ~ p(V75)
        | p(V471)
        | p(V363) )
      & ( ~ p(V325)
        | ~ p(V469)
        | p(V19) )
      & ( p(V67)
        | p(V470)
        | ~ p(V103) )
      & ( ~ p(V190)
        | p(V226)
        | ~ p(V474) )
      & ( p(V175)
        | ~ p(V211)
        | p(V473) )
      & ( p(V1)
        | ~ p(V11)
        | p(V29) )
      & ( ~ p(V195)
        | ~ p(V474)
        | p(V231) )
      & ( p(V276)
        | p(V475)
        | ~ p(V240) )
      & ( ~ p(V469)
        | p(V341)
        | ~ p(V35) )
      & ( p(V430)
        | p(V474)
        | ~ p(V196) )
      & ( p(V380)
        | ~ p(V110)
        | p(V472) )
      & ( ~ p(V471)
        | ~ p(V105)
        | p(V375) )
      & ( p(V33)
        | ~ p(V69)
        | p(V469) )
      & ( p(V49)
        | ~ p(V470)
        | ~ p(V85) )
      & ( p(V438)
        | ~ p(V222)
        | p(V475) )
      & ( ~ p(V22)
        | p(V328)
        | ~ p(V469) )
      & ( p(V149)
        | ~ p(V473)
        | ~ p(V185) )
      & ( p(V471)
        | p(V98)
        | ~ p(V134) )
      & ( p(V476)
        | p(V276)
        | ~ p(V312) )
      & ( ~ p(V427)
        | p(V211)
        | ~ p(V474) )
      & ( ~ p(V291)
        | ~ p(V476)
        | p(V255) )
      & ( ~ p(V275)
        | p(V475)
        | p(V239) )
      & ( p(V101)
        | ~ p(V65)
        | p(V470) )
      & ( ~ p(V209)
        | p(V474)
        | p(V245) )
      & ( ~ p(V473)
        | ~ p(V397)
        | p(V163) )
      & ( p(V469)
        | ~ p(V32)
        | p(V68) )
      & ( p(V142)
        | p(V471)
        | ~ p(V106) )
      & ( p(V355)
        | p(V470)
        | ~ p(V49) )
      & ( p(V471)
        | ~ p(V377)
        | p(V89) )
      & ( ~ p(V341)
        | p(V35)
        | ~ p(V469) )
      & ( p(V471)
        | ~ p(V144)
        | p(V108) )
      & ( p(V92)
        | p(V470)
        | ~ p(V56) )
      & ( ~ p(V277)
        | p(V475)
        | p(V241) )
      & ( p(V472)
        | p(V139)
        | ~ p(V175) )
      & ( ~ p(V471)
        | ~ p(V374)
        | p(V104) )
      & ( p(V472)
        | p(V393)
        | ~ p(V123) )
      & ( p(V471)
        | p(V129)
        | ~ p(V93) )
      & ( p(V257)
        | p(V476)
        | ~ p(V455) )
      & ( ~ p(V248)
        | p(V474)
        | p(V212) )
      & ( p(V341)
        | p(V469)
        | ~ p(V17) )
      & ( ~ p(V57)
        | p(V469)
        | p(V21) )
      & ( p(V475)
        | ~ p(V436)
        | p(V220) )
      & ( ~ p(V475)
        | ~ p(V224)
        | p(V260) )
      & ( ~ p(V271)
        | p(V475)
        | p(V235) )
      & ( ~ p(V198)
        | p(V474)
        | p(V432) )
      & ( p(V473)
        | ~ p(V411)
        | p(V159) )
      & ( ~ p(V3)
        | p(V39)
        | ~ p(V469) )
      & ( p(V8)
        | ~ p(V9) )
      & ( ~ p(V475)
        | ~ p(V251)
        | p(V449) )
      & ( ~ p(V469)
        | ~ p(V18)
        | p(V54) )
      & ( ~ p(V159)
        | ~ p(V473)
        | p(V195) )
      & ( ~ p(V147)
        | ~ p(V473)
        | p(V183) )
      & ( p(V49)
        | ~ p(V355)
        | p(V470) )
      & ( p(V334)
        | ~ p(V28)
        | ~ p(V469) )
      & ( p(V274)
        | ~ p(V310)
        | p(V476) )
      & ( p(V168)
        | p(V472)
        | ~ p(V132) )
      & ( ~ p(V378)
        | p(V108)
        | ~ p(V471) )
      & ( ~ p(V470)
        | p(V46)
        | ~ p(V82) )
      & ( ~ p(V418)
        | p(V184)
        | p(V474) )
      & ( p(V236)
        | ~ p(V200)
        | p(V474) )
      & ( ~ p(V476)
        | p(V271)
        | ~ p(V451) )
      & ( ~ p(V375)
        | p(V471)
        | p(V87) )
      & ( ~ p(V282)
        | p(V476)
        | p(V318) )
      & ( ~ p(V472)
        | ~ p(V139)
        | p(V391) )
      & ( p(V97)
        | p(V471)
        | ~ p(V133) )
      & ( ~ p(V33)
        | p(V469)
        | p(V69) )
      & ( ~ p(V473)
        | p(V407)
        | ~ p(V173) )
      & ( p(V83)
        | ~ p(V371)
        | p(V471) )
      & ( ~ p(V473)
        | ~ p(V192)
        | p(V156) )
      & ( p(V16)
        | ~ p(V340)
        | p(V469) )
      & ( p(V256)
        | ~ p(V454)
        | p(V476) )
      & ( p(V3)
        | ~ p(V30)
        | p(V12)
        | ~ p(V1) )
      & ( p(V387)
        | ~ p(V472)
        | ~ p(V135) )
      & ( ~ p(V154)
        | p(V190)
        | ~ p(V473) )
      & ( ~ p(V22)
        | p(V21) )
      & ( p(V472)
        | p(V114)
        | ~ p(V384) )
      & ( ~ p(V472)
        | p(V381)
        | ~ p(V129) )
      & ( ~ p(V191)
        | p(V227)
        | ~ p(V474) )
      & ( p(V476)
        | ~ p(V452)
        | p(V254) )
      & ( p(V476)
        | p(V315)
        | ~ p(V279) )
      & ( ~ p(V475)
        | p(V436)
        | ~ p(V238) )
      & ( ~ p(V181)
        | p(V217)
        | ~ p(V474) )
      & ( p(V287)
        | p(V475)
        | ~ p(V251) )
      & ( p(V474)
        | ~ p(V206)
        | p(V242) )
      & ( p(V17)
        | ~ p(V9) )
      & ( ~ p(V324)
        | p(V476)
        | p(V288) )
      & ( ~ p(V92)
        | p(V128)
        | p(V471) )
      & ( p(V153)
        | ~ p(V189)
        | ~ p(V473) )
      & ( p(V12)
        | p(V469)
        | ~ p(V336) )
      & ( p(V473)
        | ~ p(V174)
        | p(V210) )
      & ( ~ p(V190)
        | p(V474)
        | p(V424) )
      & ( p(V20)
        | ~ p(V56)
        | p(V469) )
      & ( ~ p(V167)
        | p(V473)
        | p(V203) )
      & ( p(V476)
        | ~ p(V461)
        | p(V263) )
      & ( p(V473)
        | p(V215)
        | ~ p(V179) )
      & ( p(V434)
        | ~ p(V218)
        | p(V475) )
      & ( p(V392)
        | ~ p(V122)
        | p(V472) )
      & ( p(V196)
        | ~ p(V474)
        | ~ p(V232) )
      & ( p(V237)
        | ~ p(V201)
        | p(V474) )
      & ( p(V77)
        | ~ p(V113)
        | ~ p(V471) )
      & ( ~ p(V279)
        | p(V243)
        | p(V475) )
      & ( ~ p(V267)
        | p(V465)
        | p(V476) )
      & ( p(V32)
        | p(V14)
        | ~ p(V1)
        | ~ p(V5) )
      & ( p(V6)
        | ~ p(V1)
        | p(V33)
        | ~ p(V15) )
      & ( ~ p(V472)
        | p(V159)
        | ~ p(V123) )
      & ( ~ p(V471)
        | ~ p(V77)
        | p(V113) )
      & ( ~ p(V41)
        | p(V470)
        | p(V347) )
      & ( ~ p(V228)
        | ~ p(V475)
        | p(V264) )
      & ( p(V420)
        | ~ p(V204)
        | ~ p(V474) )
      & ( p(V173)
        | ~ p(V407)
        | ~ p(V473) )
      & ( ~ p(V276)
        | p(V476)
        | p(V312) )
      & ( ~ p(V473)
        | p(V191)
        | ~ p(V155) )
      & ( p(V65)
        | p(V469)
        | ~ p(V29) )
      & ( p(V474)
        | ~ p(V188)
        | p(V422) )
      & ( p(V131)
        | ~ p(V95)
        | p(V471) )
      & ( ~ p(V400)
        | p(V166)
        | ~ p(V473) )
      & ( p(V476)
        | ~ p(V464)
        | p(V266) )
      & ( p(V253)
        | ~ p(V289)
        | ~ p(V476) )
      & ( ~ p(V472)
        | p(V145)
        | ~ p(V109) )
      & ( ~ p(V230)
        | p(V266)
        | ~ p(V475) )
      & ( ~ p(V183)
        | p(V417)
        | p(V474) )
      & ( ~ p(V469)
        | p(V326)
        | ~ p(V20) )
      & ( ~ p(V470)
        | p(V76)
        | ~ p(V40) )
      & ( p(V475)
        | ~ p(V226)
        | p(V442) )
      & ( ~ p(V14)
        | p(V50)
        | ~ p(V469) )
      & ( p(V24)
        | ~ p(V23)
        | ~ p(V32) )
      & ( ~ p(V3)
        | ~ p(V12)
        | ~ p(V1)
        | ~ p(V30) )
      & ( p(V473)
        | ~ p(V203)
        | p(V167) )
      & ( ~ p(V171)
        | p(V207)
        | p(V473) )
      & ( ~ p(V31)
        | p(V67)
        | p(V469) )
      & ( p(V254)
        | ~ p(V476)
        | ~ p(V290) )
      & ( p(V121)
        | ~ p(V391)
        | p(V472) )
      & ( ~ p(V152)
        | p(V188)
        | ~ p(V473) )
      & ( ~ p(V476)
        | p(V296)
        | ~ p(V260) )
      & ( p(V470)
        | ~ p(V98)
        | p(V62) )
      & ( p(V340)
        | ~ p(V469)
        | ~ p(V34) )
      & ( ~ p(V83)
        | p(V471)
        | p(V371) )
      & ( ~ p(V474)
        | p(V184)
        | ~ p(V220) )
      & ( p(V357)
        | p(V470)
        | ~ p(V51) )
      & ( ~ p(V154)
        | ~ p(V472)
        | p(V118) )
      & ( p(V221)
        | ~ p(V437)
        | p(V475) )
      & ( p(V18)
        | ~ p(V10) )
      & ( ~ p(V27)
        | p(V35) )
      & ( ~ p(V23)
        | p(V31) )
      & ( ~ p(V62)
        | p(V350)
        | ~ p(V470) )
      & ( ~ p(V54)
        | p(V90)
        | ~ p(V470) )
      & ( p(V360)
        | ~ p(V72)
        | ~ p(V470) )
      & ( ~ p(V475)
        | ~ p(V441)
        | p(V243) )
      & ( p(V19)
        | ~ p(V55)
        | p(V469) )
      & ( p(V469)
        | p(V58)
        | ~ p(V22) )
      & ( ~ p(V406)
        | p(V172)
        | ~ p(V473) )
      & ( p(V469)
        | ~ p(V334)
        | p(V10) )
      & ( p(V474)
        | ~ p(V181)
        | p(V415) )
      & ( p(V125)
        | p(V472)
        | ~ p(V395) )
      & ( p(V133)
        | ~ p(V385)
        | ~ p(V472) )
      & ( ~ p(V476)
        | ~ p(V304)
        | p(V268) )
      & ( p(V399)
        | p(V473)
        | ~ p(V147) )
      & ( p(V36)
        | ~ p(V1)
        | ~ p(V18)
        | p(V9) )
      & ( p(V278)
        | p(V476)
        | ~ p(V314) )
      & ( ~ p(V106)
        | p(V376)
        | ~ p(V471) )
      & ( ~ p(V143)
        | p(V471)
        | p(V107) )
      & ( ~ p(V108)
        | p(V72)
        | p(V470) )
      & ( p(V90)
        | ~ p(V126)
        | ~ p(V471) )
      & ( ~ p(V157)
        | ~ p(V473)
        | p(V193) )
      & ( p(V124)
        | ~ p(V472)
        | ~ p(V160) )
      & ( p(V272)
        | ~ p(V236)
        | p(V475) )
      & ( p(V166)
        | ~ p(V202)
        | p(V473) )
      & ( ~ p(V247)
        | p(V474)
        | p(V211) )
      & ( ~ p(V438)
        | p(V475)
        | p(V222) )
      & ( ~ p(V292)
        | ~ p(V476)
        | p(V256) )
      & ( ~ p(V97)
        | ~ p(V471)
        | p(V367) )
      & ( p(V224)
        | ~ p(V188)
        | ~ p(V474) )
      & ( p(V129)
        | ~ p(V165)
        | p(V472) )
      & ( ~ p(V74)
        | p(V110)
        | ~ p(V471) )
      & ( ~ p(V471)
        | ~ p(V92)
        | p(V362) )
      & ( ~ p(V469)
        | p(V3)
        | ~ p(V39) )
      & ( ~ p(V414)
        | p(V473)
        | p(V162) )
      & ( p(V469)
        | ~ p(V332)
        | p(V8) )
      & ( ~ p(V472)
        | ~ p(V145)
        | p(V109) )
      & ( p(V1)
        | p(V35)
        | ~ p(V17) )
      & ( ~ p(V433)
        | p(V235)
        | ~ p(V475) )
      & ( ~ p(V129)
        | p(V165)
        | p(V472) )
      & ( ~ p(V93)
        | p(V470)
        | p(V57) )
      & ( p(V148)
        | ~ p(V184)
        | ~ p(V473) )
      & ( ~ p(V229)
        | ~ p(V475)
        | p(V265) )
      & ( p(V99)
        | p(V471)
        | ~ p(V135) )
      & ( ~ p(V67)
        | p(V355)
        | ~ p(V470) )
      & ( p(V400)
        | p(V473)
        | ~ p(V148) )
      & ( ~ p(V474)
        | p(V201)
        | ~ p(V417) )
      & ( p(V311)
        | ~ p(V275)
        | p(V476) )
      & ( p(V157)
        | ~ p(V472)
        | ~ p(V121) )
      & ( p(V165)
        | ~ p(V201)
        | p(V473) )
      & ( p(V6)
        | p(V15)
        | ~ p(V33)
        | ~ p(V1) )
      & ( ~ p(V442)
        | p(V226)
        | p(V475) )
      & ( p(V313)
        | p(V476)
        | ~ p(V277) )
      & ( p(V473)
        | ~ p(V168)
        | p(V204) )
      & ( ~ p(V8)
        | p(V17)
        | ~ p(V1)
        | p(V35) )
      & ( ~ p(V337)
        | p(V13)
        | p(V469) )
      & ( ~ p(V1)
        | p(V9)
        | p(V18)
        | ~ p(V36) )
      & ( ~ p(V435)
        | p(V475)
        | p(V219) )
      & ( p(V100)
        | p(V470)
        | ~ p(V64) )
      & ( p(V141)
        | ~ p(V472)
        | ~ p(V393) )
      & ( ~ p(V84)
        | ~ p(V470)
        | p(V48) )
      & ( p(V476)
        | ~ p(V273)
        | p(V309) )
      & ( p(V471)
        | ~ p(V89)
        | p(V377) )
      & ( ~ p(V472)
        | ~ p(V136)
        | p(V388) )
      & ( ~ p(V243)
        | ~ p(V475)
        | p(V441) )
      & ( ~ p(V475)
        | ~ p(V445)
        | p(V247) )
      & ( ~ p(V408)
        | p(V473)
        | p(V156) )
      & ( ~ p(V12)
        | p(V469)
        | p(V336) )
      & ( p(V224)
        | p(V475)
        | ~ p(V440) )
      & ( p(V327)
        | ~ p(V469)
        | ~ p(V21) )
      & ( ~ p(V475)
        | p(V443)
        | ~ p(V245) )
      & ( ~ p(V476)
        | p(V293)
        | ~ p(V257) )
      & ( ~ p(V405)
        | ~ p(V473)
        | p(V171) )
      & ( ~ p(V183)
        | ~ p(V473)
        | p(V147) )
      & ( p(V131)
        | ~ p(V167)
        | p(V472) )
      & ( ~ p(V471)
        | p(V88)
        | ~ p(V124) )
      & ( ~ p(V178)
        | p(V214)
        | p(V473) )
      & ( ~ p(V128)
        | p(V164)
        | p(V472) )
      & ( p(V183)
        | p(V474)
        | ~ p(V417) )
      & ( p(V55)
        | p(V470)
        | ~ p(V91) )
      & ( p(V334)
        | p(V469)
        | ~ p(V10) )
      & ( p(V346)
        | p(V470)
        | ~ p(V40) )
      & ( p(V464)
        | ~ p(V476)
        | ~ p(V284) )
      & ( p(V247)
        | p(V475)
        | ~ p(V283) )
      & ( p(V331)
        | ~ p(V7)
        | p(V469) )
      & ( ~ p(V338)
        | p(V14)
        | p(V469) )
      & ( p(V445)
        | ~ p(V229)
        | p(V475) )
      & ( p(V474)
        | p(V193)
        | ~ p(V427) )
      & ( ~ p(V278)
        | p(V476)
        | p(V314) )
      & ( p(V375)
        | ~ p(V87)
        | p(V471) )
      & ( ~ p(V33)
        | p(V15)
        | p(V1) )
      & ( ~ p(V469)
        | p(V339)
        | ~ p(V33) )
      & ( ~ p(V24)
        | p(V60)
        | p(V469) )
      & ( ~ p(V342)
        | p(V18)
        | p(V469) )
      & ( p(V357)
        | ~ p(V470)
        | ~ p(V69) )
      & ( p(V27)
        | ~ p(V333)
        | ~ p(V469) )
      & ( ~ p(V349)
        | p(V61)
        | ~ p(V470) )
      & ( p(V469)
        | ~ p(V327)
        | p(V3) )
      & ( p(V260)
        | ~ p(V458)
        | p(V476) )
      & ( p(V31)
        | p(V1)
        | ~ p(V13) )
      & ( ~ p(V222)
        | ~ p(V475)
        | p(V258) )
      & ( ~ p(V261)
        | p(V459)
        | p(V476) )
      & ( ~ p(V157)
        | p(V473)
        | p(V409) )
      & ( p(V471)
        | p(V73)
        | ~ p(V361) )
      & ( ~ p(V262)
        | p(V226)
        | ~ p(V475) )
      & ( ~ p(V4)
        | ~ p(V13)
        | p(V5) )
      & ( p(V401)
        | ~ p(V167)
        | ~ p(V473) )
      & ( ~ p(V395)
        | ~ p(V472)
        | p(V143) )
      & ( ~ p(V36)
        | p(V72)
        | p(V469) )
      & ( p(V416)
        | p(V474)
        | ~ p(V182) )
      & ( ~ p(V33)
        | ~ p(V15)
        | ~ p(V1)
        | ~ p(V6) )
      & ( ~ p(V308)
        | p(V476)
        | p(V272) )
      & ( p(V464)
        | p(V476)
        | ~ p(V266) )
      & ( ~ p(V176)
        | p(V212)
        | p(V473) )
      & ( ~ p(V15)
        | p(V51)
        | ~ p(V469) )
      & ( p(V267)
        | ~ p(V475)
        | ~ p(V231) )
      & ( p(V451)
        | ~ p(V271)
        | ~ p(V476) )
      & ( p(V271)
        | p(V476)
        | ~ p(V307) )
      & ( ~ p(V475)
        | ~ p(V232)
        | p(V268) )
      & ( p(V380)
        | ~ p(V128)
        | ~ p(V472) )
      & ( ~ p(V221)
        | p(V185)
        | ~ p(V474) )
      & ( p(V216)
        | ~ p(V252)
        | p(V474) )
      & ( ~ p(V471)
        | p(V105)
        | ~ p(V375) )
      & ( ~ p(V471)
        | p(V114)
        | ~ p(V78) )
      & ( ~ p(V470)
        | p(V62)
        | ~ p(V350) )
      & ( p(V230)
        | p(V475)
        | ~ p(V446) )
      & ( p(V408)
        | ~ p(V156)
        | p(V473) )
      & ( ~ p(V469)
        | p(V335)
        | ~ p(V29) )
      & ( p(V1)
        | ~ p(V469)
        | ~ p(V37) )
      & ( p(V335)
        | p(V469)
        | ~ p(V11) )
      & ( p(V250)
        | p(V474)
        | ~ p(V214) )
      & ( p(V88)
        | ~ p(V52)
        | ~ p(V470) )
      & ( ~ p(V58)
        | p(V94)
        | p(V470) )
      & ( ~ p(V124)
        | p(V472)
        | p(V394) )
      & ( ~ p(V473)
        | p(V152)
        | ~ p(V188) )
      & ( p(V472)
        | p(V180)
        | ~ p(V144) )
      & ( ~ p(V315)
        | p(V476)
        | p(V279) )
      & ( p(V473)
        | ~ p(V166)
        | p(V202) )
      & ( p(V473)
        | ~ p(V215)
        | p(V179) )
      & ( p(V470)
        | p(V69)
        | ~ p(V105) )
      & ( ~ p(V3)
        | p(V11) )
      & ( p(V472)
        | p(V132)
        | ~ p(V168) )
      & ( ~ p(V151)
        | p(V187)
        | ~ p(V473) )
      & ( ~ p(V473)
        | ~ p(V186)
        | p(V150) )
      & ( p(V469)
        | p(V328)
        | ~ p(V4) )
      & ( p(V33)
        | ~ p(V15)
        | p(V1) )
      & ( p(V132)
        | p(V471)
        | ~ p(V96) )
      & ( ~ p(V469)
        | ~ p(V36)
        | p(V342) )
      & ( ~ p(V120)
        | p(V472)
        | p(V390) )
      & ( p(V469)
        | ~ p(V18)
        | p(V342) )
      & ( p(V217)
        | ~ p(V253)
        | ~ p(V475) )
      & ( ~ p(V475)
        | p(V251)
        | ~ p(V449) )
      & ( ~ p(V369)
        | ~ p(V471)
        | p(V99) )
      & ( ~ p(V474)
        | p(V205)
        | ~ p(V421) )
      & ( ~ p(V41)
        | ~ p(V469)
        | p(V5) )
      & ~ p(V304)
      & ( ~ p(V95)
        | p(V470)
        | p(V59) )
      & ( ~ p(V204)
        | p(V240)
        | p(V474) )
      & ( ~ p(V441)
        | p(V475)
        | p(V225) )
      & ( ~ p(V473)
        | ~ p(V149)
        | p(V185) )
      & ( ~ p(V420)
        | p(V474)
        | p(V186) )
      & ( ~ p(V438)
        | p(V240)
        | ~ p(V475) )
      & ( ~ p(V57)
        | p(V470)
        | p(V93) )
      & ( ~ p(V471)
        | p(V93)
        | ~ p(V363) )
      & ( p(V8)
        | ~ p(V7)
        | ~ p(V16) )
      & ( p(V323)
        | ~ p(V287)
        | p(V476) )
      & ( ~ p(V463)
        | p(V476)
        | p(V265) )
      & ( ~ p(V80)
        | p(V116)
        | ~ p(V471) )
      & ( ~ p(V452)
        | ~ p(V476)
        | p(V272) )
      & ( ~ p(V26)
        | p(V332)
        | ~ p(V469) )
      & ( p(V367)
        | p(V471)
        | ~ p(V79) )
      & ( ~ p(V372)
        | p(V84)
        | p(V471) )
      & ( ~ p(V283)
        | p(V476)
        | p(V319) )
      & ( p(V171)
        | p(V472)
        | ~ p(V135) )
      & ( ~ p(V81)
        | ~ p(V470)
        | p(V45) )
      & ( p(V126)
        | ~ p(V471)
        | ~ p(V90) )
      & ( p(V330)
        | ~ p(V24)
        | ~ p(V469) )
      & ( p(V470)
        | ~ p(V346)
        | p(V40) )
      & ( ~ p(V474)
        | ~ p(V216)
        | p(V432) )
      & ( ~ p(V476)
        | ~ p(V269)
        | p(V305) )
      & ( p(V167)
        | p(V472)
        | ~ p(V131) )
      & ( ~ p(V448)
        | p(V475)
        | p(V232) )
      & ( p(V459)
        | ~ p(V476)
        | ~ p(V279) )
      & ( p(V34)
        | p(V1)
        | ~ p(V16) )
      & ( p(V214)
        | ~ p(V474)
        | ~ p(V430) )
      & ( ~ p(V141)
        | p(V177)
        | p(V472) )
      & ( p(V471)
        | ~ p(V128)
        | p(V92) )
      & ( ~ p(V475)
        | ~ p(V270)
        | p(V234) )
      & ( p(V440)
        | p(V475)
        | ~ p(V224) )
      & ( p(V148)
        | ~ p(V112)
        | ~ p(V472) )
      & ( ~ p(V366)
        | ~ p(V471)
        | p(V96) )
      & ( ~ p(V470)
        | ~ p(V65)
        | p(V353) )
      & ( ~ p(V285)
        | p(V249)
        | p(V475) )
      & ( p(V6)
        | ~ p(V42)
        | ~ p(V469) )
      & ( p(V472)
        | ~ p(V109)
        | p(V379) )
      & ( ~ p(V470)
        | p(V39)
        | ~ p(V75) )
      & ( p(V475)
        | ~ p(V447)
        | p(V231) )
      & ( ~ p(V321)
        | p(V476)
        | p(V285) )
      & ( p(V471)
        | p(V104)
        | ~ p(V140) )
      & ( p(V288)
        | ~ p(V252)
        | p(V475) )
      & ( ~ p(V422)
        | p(V188)
        | p(V474) )
      & ( ~ p(V80)
        | p(V471)
        | p(V368) )
      & ( ~ p(V474)
        | p(V207)
        | ~ p(V423) )
      & ( p(V9)
        | ~ p(V10) )
      & ( ~ p(V473)
        | ~ p(V162)
        | p(V198) )
      & ( p(V50)
        | ~ p(V356)
        | p(V470) )
      & ( p(V24)
        | ~ p(V469)
        | ~ p(V330) )
      & ( p(V474)
        | p(V192)
        | ~ p(V426) )
      & ( ~ p(V30)
        | ~ p(V21)
        | p(V22) )
      & ( p(V14)
        | ~ p(V469)
        | ~ p(V50) )
      & ( p(V427)
        | ~ p(V193)
        | p(V474) )
      & ( ~ p(V177)
        | p(V472)
        | p(V141) )
      & ( p(V18)
        | p(V1)
        | ~ p(V36) )
      & ( p(V20)
        | ~ p(V2) )
      & ( p(V414)
        | ~ p(V162)
        | p(V473) )
      & ( ~ p(V475)
        | p(V248)
        | ~ p(V446) )
      & ( ~ p(V154)
        | p(V473)
        | p(V406) )
      & ( p(V473)
        | p(V401)
        | ~ p(V149) )
      & ( p(V435)
        | ~ p(V219)
        | p(V475) )
      & ( ~ p(V394)
        | p(V472)
        | p(V124) )
      & ( p(V474)
        | p(V418)
        | ~ p(V184) )
      & ( ~ p(V189)
        | p(V225)
        | ~ p(V474) )
      & ( p(V412)
        | ~ p(V473)
        | ~ p(V178) )
      & ( ~ p(V471)
        | p(V369)
        | ~ p(V99) )
      & ( p(V137)
        | p(V471)
        | ~ p(V101) )
      & ( p(V471)
        | ~ p(V94)
        | p(V130) )
      & ( p(V289)
        | ~ p(V476)
        | ~ p(V253) )
      & ( p(V419)
        | ~ p(V474)
        | ~ p(V203) )
      & ( ~ p(V469)
        | ~ p(V12)
        | p(V48) )
      & ( p(V475)
        | ~ p(V278)
        | p(V242) )
      & ( ~ p(V421)
        | p(V474)
        | p(V187) )
      & ( p(V203)
        | p(V474)
        | ~ p(V239) )
      & ( ~ p(V240)
        | p(V474)
        | p(V204) )
      & ( p(V475)
        | p(V238)
        | ~ p(V274) )
      & ( ~ p(V6)
        | p(V5) )
      & ( ~ p(V476)
        | ~ p(V267)
        | p(V303) )
      & ( ~ p(V474)
        | ~ p(V201)
        | p(V417) )
      & ( ~ p(V256)
        | p(V220)
        | ~ p(V475) )
      & ( p(V435)
        | ~ p(V237)
        | ~ p(V475) )
      & ( p(V168)
        | ~ p(V402)
        | ~ p(V473) )
      & ( ~ p(V170)
        | p(V472)
        | p(V134) )
      & ( ~ p(V469)
        | ~ p(V17)
        | p(V53) )
      & ( ~ p(V476)
        | p(V263)
        | ~ p(V299) )
      & ( p(V205)
        | p(V474)
        | ~ p(V241) )
      & ( ~ p(V187)
        | p(V474)
        | p(V421) )
      & ( ~ p(V37)
        | p(V343)
        | p(V470) )
      & ( p(V215)
        | p(V474)
        | ~ p(V251) )
      & ( p(V472)
        | p(V116)
        | ~ p(V386) )
      & ( p(V16)
        | ~ p(V8) )
      & ( p(V123)
        | ~ p(V159)
        | ~ p(V472) )
      & ( p(V183)
        | ~ p(V219)
        | ~ p(V474) )
      & ( p(V158)
        | ~ p(V410)
        | p(V473) )
      & ( ~ p(V117)
        | ~ p(V472)
        | p(V153) )
      & ( p(V186)
        | ~ p(V150)
        | ~ p(V473) )
      & ( ~ p(V131)
        | p(V95)
        | p(V471) )
      & ( ~ p(V473)
        | p(V413)
        | ~ p(V179) )
      & ( ~ p(V53)
        | ~ p(V469)
        | p(V17) )
      & ( p(V301)
        | ~ p(V265)
        | ~ p(V476) )
      & ( ~ p(V337)
        | ~ p(V469)
        | p(V31) )
      & ( p(V78)
        | ~ p(V114)
        | ~ p(V471) )
      & ( p(V474)
        | p(V428)
        | ~ p(V194) )
      & ( ~ p(V268)
        | p(V466)
        | p(V476) )
      & ( p(V470)
        | ~ p(V351)
        | p(V45) )
      & ( p(V113)
        | p(V472)
        | ~ p(V383) )
      & ( p(V219)
        | ~ p(V475)
        | ~ p(V255) )
      & ( ~ p(V116)
        | ~ p(V471)
        | p(V80) )
      & ( p(V214)
        | ~ p(V250)
        | p(V474) )
      & ( ~ p(V245)
        | p(V474)
        | p(V209) )
      & ( p(V5)
        | p(V469)
        | ~ p(V329) )
      & ( ~ p(V45)
        | p(V9)
        | ~ p(V469) )
      & ( p(V294)
        | ~ p(V476)
        | ~ p(V258) )
      & ( ~ p(V339)
        | p(V469)
        | p(V15) )
      & ( p(V471)
        | p(V75)
        | ~ p(V363) )
      & ( p(V11)
        | ~ p(V29)
        | p(V1) )
      & ( p(V279)
        | ~ p(V476)
        | ~ p(V459) )
      & ( ~ p(V223)
        | p(V439)
        | p(V475) )
      & ( ~ p(V473)
        | ~ p(V156)
        | p(V192) )
      & ( p(V469)
        | p(V34)
        | ~ p(V70) )
      & ( ~ p(V71)
        | p(V469)
        | p(V35) )
      & ( ~ p(V115)
        | ~ p(V471)
        | p(V79) )
      & ( ~ p(V474)
        | p(V428)
        | ~ p(V212) )
      & ( ~ p(V470)
        | p(V351)
        | ~ p(V63) )
      & ( ~ p(V68)
        | p(V469)
        | p(V32) )
      & ( p(V471)
        | ~ p(V100)
        | p(V136) )
      & ( p(V423)
        | ~ p(V474)
        | ~ p(V207) )
      & ( ~ p(V391)
        | ~ p(V472)
        | p(V139) )
      & ( ~ p(V366)
        | p(V78)
        | p(V471) )
      & ( p(V264)
        | ~ p(V476)
        | ~ p(V300) )
      & ( ~ p(V471)
        | p(V98)
        | ~ p(V368) )
      & ( ~ p(V181)
        | ~ p(V473)
        | p(V145) )
      & ( ~ p(V392)
        | p(V122)
        | p(V472) )
      & ( ~ p(V469)
        | ~ p(V338)
        | p(V32) )
      & ( p(V472)
        | ~ p(V180)
        | p(V144) )
      & ( ~ p(V72)
        | p(V470)
        | p(V108) )
      & ( ~ p(V473)
        | p(V180)
        | ~ p(V414) )
      & ( ~ p(V138)
        | ~ p(V472)
        | p(V390) )
      & ( ~ p(V285)
        | p(V476)
        | p(V321) )
      & ( ~ p(V396)
        | p(V144)
        | ~ p(V472) )
      & ( p(V382)
        | ~ p(V130)
        | ~ p(V472) )
      & ( p(V462)
        | ~ p(V264)
        | p(V476) )
      & ( ~ p(V475)
        | ~ p(V220)
        | p(V256) )
      & ~ p(V301)
      & ( ~ p(V131)
        | p(V383)
        | ~ p(V472) )
      & ( ~ p(V472)
        | p(V129)
        | ~ p(V381) )
      & ( p(V174)
        | p(V473)
        | ~ p(V210) )
      & ( p(V469)
        | p(V9)
        | ~ p(V333) )
      & ( ~ p(V469)
        | ~ p(V13)
        | p(V49) )
      & ( p(V471)
        | ~ p(V129)
        | p(V93) )
      & ( p(V164)
        | ~ p(V398)
        | ~ p(V473) )
      & ( p(V384)
        | ~ p(V132)
        | ~ p(V472) )
      & ( p(V475)
        | ~ p(V434)
        | p(V218) )
      & ( ~ p(V472)
        | ~ p(V157)
        | p(V121) )
      & ( p(V471)
        | p(V88)
        | ~ p(V376) )
      & ( ~ p(V27)
        | p(V26) )
      & ( p(V10)
        | ~ p(V18)
        | ~ p(V9) )
      & ( p(V138)
        | ~ p(V472)
        | ~ p(V390) )
      & ( p(V316)
        | p(V476)
        | ~ p(V280) )
      & ( ~ p(V470)
        | ~ p(V56)
        | p(V344) )
      & ( ~ p(V474)
        | p(V424)
        | ~ p(V208) )
      & ( ~ p(V48)
        | ~ p(V469)
        | p(V12) )
      & ( p(V180)
        | ~ p(V216)
        | p(V473) )
      & ( p(V4)
        | ~ p(V3)
        | ~ p(V12) )
      & ( ~ p(V475)
        | p(V232)
        | ~ p(V268) )
      & ( ~ p(V8)
        | p(V7) )
      & ( ~ p(V3)
        | p(V469)
        | p(V327) )
      & ( p(V476)
        | ~ p(V269)
        | p(V467) )
      & ( ~ p(V471)
        | p(V101)
        | ~ p(V371) )
      & ( ~ p(V472)
        | ~ p(V387)
        | p(V135) )
      & ( p(V175)
        | ~ p(V473)
        | ~ p(V409) )
      & ( ~ p(V125)
        | ~ p(V471)
        | p(V89) )
      & ( p(V471)
        | p(V86)
        | ~ p(V374) )
      & ( ~ p(V152)
        | p(V116)
        | ~ p(V472) )
      & ( ~ p(V476)
        | p(V292)
        | ~ p(V256) )
      & ( p(V107)
        | ~ p(V71)
        | p(V470) )
      & ( ~ p(V474)
        | ~ p(V217)
        | p(V181) )
      & ( ~ p(V470)
        | ~ p(V346)
        | p(V58) )
      & ( ~ p(V469)
        | ~ p(V5)
        | p(V41) )
      & ( ~ p(V475)
        | p(V250)
        | ~ p(V448) )
      & ( p(V94)
        | ~ p(V364)
        | ~ p(V471) )
      & ( p(V471)
        | ~ p(V97)
        | p(V133) )
      & ( p(V416)
        | ~ p(V200)
        | ~ p(V474) )
      & ( p(V106)
        | ~ p(V376)
        | ~ p(V471) )
      & ( ~ p(V471)
        | ~ p(V100)
        | p(V370) )
      & ( ~ p(V280)
        | p(V460)
        | ~ p(V476) )
      & ( ~ p(V259)
        | p(V457)
        | p(V476) )
      & ( p(V200)
        | ~ p(V236)
        | p(V474) )
      & ( p(V475)
        | ~ p(V286)
        | p(V250) )
      & ( p(V239)
        | p(V474)
        | ~ p(V203) )
      & ( p(V470)
        | p(V103)
        | ~ p(V67) )
      & ( ~ p(V475)
        | ~ p(V254)
        | p(V218) )
      & ( p(V126)
        | ~ p(V472)
        | ~ p(V162) )
      & ( ~ p(V77)
        | p(V471)
        | p(V365) )
      & ( ~ p(V386)
        | ~ p(V472)
        | p(V134) )
      & ( p(V470)
        | p(V105)
        | ~ p(V69) )
      & ( ~ p(V44)
        | p(V470)
        | p(V350) )
      & ( p(V472)
        | p(V166)
        | ~ p(V130) )
      & ( ~ p(V185)
        | p(V419)
        | p(V474) )
      & ( ~ p(V476)
        | p(V302)
        | ~ p(V266) )
      & ( ~ p(V92)
        | p(V470)
        | p(V56) )
      & ( ~ p(V471)
        | ~ p(V86)
        | p(V122) )
      & ( p(V237)
        | p(V475)
        | ~ p(V273) )
      & ( p(V149)
        | ~ p(V113)
        | ~ p(V472) )
      & ( p(V104)
        | p(V470)
        | ~ p(V68) )
      & ( ~ p(V74)
        | p(V38)
        | ~ p(V470) )
      & ( p(V261)
        | p(V476)
        | ~ p(V459) )
      & ( p(V359)
        | ~ p(V71)
        | ~ p(V470) )
      & ( p(V47)
        | p(V470)
        | ~ p(V353) )
      & ( p(V475)
        | ~ p(V243)
        | p(V279) )
      & ( p(V7)
        | ~ p(V6)
        | ~ p(V15) )
      & ( ~ p(V153)
        | p(V473)
        | p(V405) )
      & ( p(V470)
        | ~ p(V359)
        | p(V53) )
      & ( ~ p(V11)
        | p(V3) )
      & ( ~ p(V475)
        | ~ p(V434)
        | p(V236) )
      & ( ~ p(V309)
        | p(V476)
        | p(V273) )
      & ( p(V476)
        | p(V267)
        | ~ p(V465) )
      & ( ~ p(V259)
        | ~ p(V476)
        | p(V295) )
      & ( ~ p(V469)
        | p(V337)
        | ~ p(V31) )
      & ( p(V382)
        | ~ p(V112)
        | p(V472) )
      & ( p(V473)
        | p(V177)
        | ~ p(V213) )
      & ( p(V2)
        | p(V10)
        | ~ p(V20) )
      & ( ~ p(V169)
        | p(V403)
        | ~ p(V473) )
      & ( ~ p(V186)
        | p(V222)
        | ~ p(V474) )
      & ( ~ p(V476)
        | ~ p(V453)
        | p(V273) )
      & ( ~ p(V198)
        | p(V234)
        | ~ p(V474) )
      & ( ~ p(V198)
        | p(V162)
        | ~ p(V473) )
      & ( p(V137)
        | ~ p(V389)
        | ~ p(V472) )
      & ( ~ p(V475)
        | ~ p(V234)
        | p(V270) )
      & ( p(V275)
        | ~ p(V239)
        | p(V475) )
      & ( ~ p(V11)
        | p(V47)
        | ~ p(V469) )
      & ( p(V476)
        | ~ p(V286)
        | p(V322) )
      & ( ~ p(V403)
        | ~ p(V473)
        | p(V169) )
      & ( ~ p(V81)
        | ~ p(V471)
        | p(V117) )
      & ( p(V259)
        | ~ p(V475)
        | ~ p(V223) )
      & ( ~ p(V263)
        | p(V476)
        | p(V461) )
      & ( p(V261)
        | ~ p(V297)
        | ~ p(V476) )
      & ( ~ p(V469)
        | ~ p(V19)
        | p(V325) )
      & ( p(V12)
        | ~ p(V4) )
      & ( p(V386)
        | ~ p(V134)
        | ~ p(V472) )
      & ( p(V473)
        | ~ p(V150)
        | p(V402) )
      & ( ~ p(V453)
        | p(V255)
        | p(V476) )
      & ( ~ p(V158)
        | ~ p(V473)
        | p(V194) )
      & ( ~ p(V295)
        | p(V259)
        | ~ p(V476) )
      & ( p(V474)
        | p(V207)
        | ~ p(V243) )
      & ( ~ p(V369)
        | p(V471)
        | p(V81) )
      & ( ~ p(V175)
        | p(V473)
        | p(V211) )
      & ( ~ p(V47)
        | ~ p(V470)
        | p(V83) )
      & ( p(V471)
        | ~ p(V138)
        | p(V102) )
      & ( p(V469)
        | ~ p(V60)
        | p(V24) )
      & ( p(V470)
        | ~ p(V45)
        | p(V351) )
      & ( ~ p(V208)
        | p(V172)
        | p(V473) )
      & ( p(V138)
        | ~ p(V174)
        | p(V472) )
      & ( ~ p(V79)
        | p(V43)
        | ~ p(V470) )
      & ( ~ p(V281)
        | p(V476)
        | p(V317) )
      & ( p(V209)
        | ~ p(V173)
        | p(V473) )
      & ( ~ p(V156)
        | p(V120)
        | ~ p(V472) )
      & ( ~ p(V27)
        | p(V63)
        | p(V469) )
      & ( p(V472)
        | p(V120)
        | ~ p(V390) )
      & ( p(V193)
        | ~ p(V229)
        | ~ p(V474) )
      & ( p(V77)
        | ~ p(V470)
        | ~ p(V41) )
      & ( ~ p(V85)
        | p(V471)
        | p(V373) )
      & ( p(V38)
        | ~ p(V469)
        | ~ p(V2) )
      & ( ~ p(V110)
        | ~ p(V471)
        | p(V74) )
      & ( ~ p(V276)
        | p(V456)
        | ~ p(V476) )
      & ( ~ p(V329)
        | p(V23)
        | ~ p(V469) )
      & ( p(V474)
        | ~ p(V202)
        | p(V238) )
      & ( p(V469)
        | ~ p(V67)
        | p(V31) )
      & ( ~ p(V474)
        | p(V215)
        | ~ p(V431) )
      & ( p(V98)
        | p(V470)
        | ~ p(V62) )
      & ( p(V473)
        | ~ p(V409)
        | p(V157) )
      & ( p(V474)
        | p(V246)
        | ~ p(V210) )
      & ( ~ p(V476)
        | p(V304)
        | ~ p(V268) )
      & ( p(V397)
        | p(V473)
        | ~ p(V145) )
      & ( p(V395)
        | ~ p(V143)
        | ~ p(V472) )
      & ( ~ p(V469)
        | ~ p(V1)
        | p(V37) )
      & ( p(V200)
        | ~ p(V474)
        | ~ p(V416) )
      & ( p(V10)
        | ~ p(V469)
        | ~ p(V46) )
      & ( ~ p(V474)
        | ~ p(V223)
        | p(V187) )
      & ( ~ p(V470)
        | ~ p(V357)
        | p(V69) )
      & ( p(V151)
        | ~ p(V473)
        | ~ p(V187) )
      & ( p(V7)
        | ~ p(V1)
        | ~ p(V34)
        | p(V16) )
      & ( ~ p(V155)
        | p(V407)
        | p(V473) )
      & ( ~ p(V471)
        | p(V364)
        | ~ p(V94) )
      & ( p(V134)
        | ~ p(V98)
        | p(V471) )
      & ( ~ p(V470)
        | ~ p(V358)
        | p(V70) )
      & ( ~ p(V470)
        | p(V60)
        | ~ p(V348) )
      & ( ~ p(V122)
        | ~ p(V472)
        | p(V158) )
      & ( ~ p(V83)
        | ~ p(V470)
        | p(V47) )
      & ( p(V470)
        | ~ p(V102)
        | p(V66) )
      & ( ~ p(V10)
        | p(V20) )
      & ( p(V469)
        | ~ p(V34)
        | p(V70) )
      & ( ~ p(V22)
        | p(V23)
        | ~ p(V31) )
      & ~ p(V300)
      & ( ~ p(V87)
        | ~ p(V470)
        | p(V51) )
      & ( p(V431)
        | ~ p(V197)
        | p(V474) )
      & ( ~ p(V473)
        | p(V178)
        | ~ p(V412) )
      & ( ~ p(V475)
        | ~ p(V248)
        | p(V446) )
      & ( p(V48)
        | p(V470)
        | ~ p(V354) )
      & ( ~ p(V469)
        | ~ p(V328)
        | p(V22) )
      & ( ~ p(V440)
        | ~ p(V475)
        | p(V242) )
      & ( p(V140)
        | p(V471)
        | ~ p(V104) )
      & ( p(V115)
        | p(V472)
        | ~ p(V385) )
      & ( ~ p(V213)
        | p(V249)
        | p(V474) )
      & ( p(V451)
        | p(V476)
        | ~ p(V253) )
      & ( p(V154)
        | ~ p(V406)
        | p(V473) )
      & ( ~ p(V55)
        | p(V343)
        | ~ p(V470) )
      & ( p(V374)
        | p(V471)
        | ~ p(V86) )
      & ( p(V475)
        | ~ p(V281)
        | p(V245) )
      & ( ~ p(V474)
        | ~ p(V428)
        | p(V212) )
      & ( p(V473)
        | ~ p(V172)
        | p(V208) )
      & ( p(V473)
        | p(V145)
        | ~ p(V397) )
      & ( ~ p(V249)
        | p(V213)
        | p(V474) )
      & ( ~ p(V7)
        | p(V6) )
      & ( ~ p(V352)
        | p(V46)
        | p(V470) )
      & ( ~ p(V257)
        | p(V221)
        | ~ p(V475) )
      & ( ~ p(V469)
        | p(V40)
        | ~ p(V4) )
      & ( ~ p(V475)
        | p(V224)
        | ~ p(V260) )
      & ( p(V470)
        | p(V360)
        | ~ p(V54) )
      & ( p(V91)
        | ~ p(V361)
        | ~ p(V471) )
      & ( p(V199)
        | p(V473)
        | ~ p(V163) )
      & ( ~ p(V1)
        | ~ p(V11)
        | ~ p(V29) )
      & ( p(V476)
        | p(V281)
        | ~ p(V317) )
      & ( ~ p(V465)
        | ~ p(V476)
        | p(V285) )
      & ( ~ p(V288)
        | p(V476)
        | p(V324) )
      & ( ~ p(V8)
        | ~ p(V17)
        | ~ p(V35)
        | ~ p(V1) )
      & ( p(V280)
        | ~ p(V316)
        | p(V476) )
      & ( p(V89)
        | ~ p(V470)
        | ~ p(V53) )
      & ( ~ p(V111)
        | p(V381)
        | p(V472) )
      & ( ~ p(V378)
        | p(V90)
        | p(V471) )
      & ( p(V120)
        | ~ p(V471)
        | ~ p(V84) )
      & ( ~ p(V476)
        | ~ p(V272)
        | p(V452) )
      & ( p(V72)
        | ~ p(V470)
        | ~ p(V360) )
      & ( p(V307)
        | p(V476)
        | ~ p(V271) )
      & ( ~ p(V176)
        | p(V472)
        | p(V140) )
      & ( ~ p(V9)
        | ~ p(V469)
        | p(V45) )
      & ( ~ p(V472)
        | p(V110)
        | ~ p(V146) )
      & ~ p(V299)
      & ( ~ p(V54)
        | ~ p(V469)
        | p(V18) )
      & ( ~ p(V214)
        | p(V430)
        | ~ p(V474) )
      & ( ~ p(V451)
        | p(V476)
        | p(V253) )
      & ( p(V470)
        | p(V39)
        | ~ p(V345) )
      & ( ~ p(V42)
        | ~ p(V470)
        | p(V78) )
      & ( ~ p(V64)
        | p(V352)
        | ~ p(V470) )
      & ( ~ p(V319)
        | p(V283)
        | p(V476) )
      & ( p(V475)
        | p(V246)
        | ~ p(V282) )
      & ( ~ p(V471)
        | ~ p(V119)
        | p(V83) )
      & ( ~ p(V116)
        | ~ p(V472)
        | p(V152) )
      & ( ~ p(V473)
        | p(V189)
        | ~ p(V153) )
      & ( ~ p(V358)
        | p(V52)
        | p(V470) )
      & ( ~ p(V180)
        | p(V473)
        | p(V216) )
      & ( p(V96)
        | p(V470)
        | ~ p(V60) )
      & ( ~ p(V28)
        | p(V64)
        | p(V469) )
      & ( ~ p(V342)
        | ~ p(V469)
        | p(V36) )
      & ( ~ p(V217)
        | p(V253)
        | ~ p(V475) )
      & ( p(V84)
        | ~ p(V470)
        | ~ p(V48) )
      & ( p(V82)
        | ~ p(V471)
        | ~ p(V118) )
      & ( ~ p(V101)
        | p(V371)
        | ~ p(V471) )
      & ( ~ p(V255)
        | ~ p(V476)
        | p(V291) )
      & ( ~ p(V150)
        | ~ p(V472)
        | p(V114) )
      & ( ~ p(V471)
        | p(V112)
        | ~ p(V76) )
      & ( ~ p(V302)
        | ~ p(V476)
        | p(V266) )
      & ( p(V176)
        | p(V473)
        | ~ p(V212) )
      & ( p(V470)
        | p(V61)
        | ~ p(V97) )
      & ( p(V229)
        | ~ p(V265)
        | ~ p(V475) )
      & ( ~ p(V396)
        | p(V126)
        | p(V472) )
      & ( ~ p(V473)
        | ~ p(V411)
        | p(V177) )
      & ( p(V472)
        | ~ p(V143)
        | p(V179) )
      & ( ~ p(V475)
        | ~ p(V258)
        | p(V222) )
      & ( ~ p(V34)
        | ~ p(V25)
        | p(V26) )
      & ( ~ p(V158)
        | p(V473)
        | p(V410) )
      & ( ~ p(V233)
        | p(V269)
        | ~ p(V475) )
      & ( ~ p(V472)
        | p(V132)
        | ~ p(V384) )
      & ( ~ p(V469)
        | p(V329)
        | ~ p(V23) )
      & ( p(V384)
        | p(V472)
        | ~ p(V114) )
      & ( ~ p(V470)
        | p(V37)
        | ~ p(V73) )
      & ( p(V340)
        | p(V469)
        | ~ p(V16) )
      & ( ~ p(V472)
        | ~ p(V120)
        | p(V156) )
      & ( p(V111)
        | ~ p(V381)
        | p(V472) )
      & ( p(V469)
        | ~ p(V26)
        | p(V62) )
      & ( ~ p(V355)
        | p(V67)
        | ~ p(V470) )
      & ( p(V474)
        | p(V182)
        | ~ p(V416) )
      & ( ~ p(V26)
        | p(V34) )
      & ( ~ p(V474)
        | p(V229)
        | ~ p(V193) )
      & ( p(V201)
        | ~ p(V237)
        | p(V474) )
      & ( ~ p(V476)
        | p(V284)
        | ~ p(V464) )
      & ( ~ p(V182)
        | p(V218)
        | ~ p(V474) )
      & ( p(V213)
        | ~ p(V177)
        | p(V473) )
      & ( ~ p(V470)
        | p(V346)
        | ~ p(V58) )
      & ( ~ p(V470)
        | p(V71)
        | ~ p(V359) )
      & ( p(V469)
        | ~ p(V326)
        | p(V2) )
      & ( p(V356)
        | ~ p(V470)
        | ~ p(V68) )
      & ( p(V345)
        | ~ p(V39)
        | p(V470) )
      & ( ~ p(V6)
        | p(V42)
        | ~ p(V469) )
      & ( p(V229)
        | p(V475)
        | ~ p(V445) )
      & ( p(V29)
        | ~ p(V21) )
      & ( p(V405)
        | ~ p(V473)
        | ~ p(V171) )
      & ( p(V475)
        | ~ p(V227)
        | p(V443) )
      & ( p(V470)
        | p(V70)
        | ~ p(V106) )
      & ( ~ p(V66)
        | p(V469)
        | p(V30) )
      & ( ~ p(V272)
        | p(V476)
        | p(V308) )
      & ( ~ p(V13)
        | p(V4)
        | p(V31)
        | ~ p(V1) )
      & ( ~ p(V474)
        | ~ p(V183)
        | p(V219) )
      & ( p(V142)
        | ~ p(V178)
        | p(V472) )
      & ( p(V434)
        | ~ p(V236)
        | ~ p(V475) )
      & ( ~ p(V469)
        | p(V338)
        | ~ p(V32) )
      & ( ~ p(V12)
        | p(V1)
        | p(V30) )
      & ( ~ p(V66)
        | p(V102)
        | p(V470) )
      & ( p(V191)
        | ~ p(V474)
        | ~ p(V227) )
      & ( p(V74)
        | p(V471)
        | ~ p(V362) )
      & ( ~ p(V46)
        | p(V470)
        | p(V352) )
      & ( p(V107)
        | ~ p(V377)
        | ~ p(V471) )
      & ( ~ p(V476)
        | ~ p(V278)
        | p(V458) )
      & ( p(V190)
        | ~ p(V424)
        | p(V474) )
      & ( p(V17)
        | ~ p(V341)
        | p(V469) )
      & ( p(V158)
        | ~ p(V194)
        | ~ p(V473) )
      & ( p(V197)
        | ~ p(V474)
        | ~ p(V233) )
      & ( ~ p(V475)
        | p(V249)
        | ~ p(V447) )
      & ( ~ p(V379)
        | ~ p(V472)
        | p(V127) )
      & ( ~ p(V6)
        | p(V15)
        | ~ p(V1)
        | p(V33) )
      & ( p(V447)
        | p(V475)
        | ~ p(V231) )
      & ( p(V472)
        | ~ p(V126)
        | p(V396) )
      & ( p(V17)
        | p(V8)
        | ~ p(V1)
        | ~ p(V35) )
      & ( ~ p(V29)
        | p(V21) )
      & ( p(V306)
        | ~ p(V270)
        | ~ p(V476) )
      & ( p(V330)
        | p(V469)
        | ~ p(V6) )
      & ( ~ p(V20)
        | p(V56)
        | p(V469) )
      & ( p(V29)
        | ~ p(V469)
        | ~ p(V335) )
      & ( p(V216)
        | ~ p(V432)
        | ~ p(V474) )
      & ( p(V454)
        | ~ p(V476)
        | ~ p(V274) )
      & ( p(V441)
        | p(V475)
        | ~ p(V225) )
      & ( ~ p(V471)
        | p(V361)
        | ~ p(V91) )
      & ( p(V161)
        | ~ p(V472)
        | ~ p(V125) )
      & ( ~ p(V474)
        | p(V198)
        | ~ p(V234) )
      & ( ~ p(V257)
        | p(V476)
        | p(V455) )
      & ( p(V25)
        | ~ p(V61)
        | p(V469) )
      & ( p(V17)
        | p(V1)
        | ~ p(V35) )
      & ( ~ p(V470)
        | ~ p(V90)
        | p(V54) )
      & ( ~ p(V471)
        | ~ p(V112)
        | p(V76) )
      & ( p(V111)
        | ~ p(V147)
        | ~ p(V472) )
      & ( p(V472)
        | ~ p(V173)
        | p(V137) )
      & ( ~ p(V470)
        | p(V345)
        | ~ p(V57) )
      & ( ~ p(V1)
        | p(V469)
        | p(V325) )
      & ( p(V473)
        | ~ p(V404)
        | p(V152) )
      & ( ~ p(V74)
        | p(V471)
        | p(V362) )
      & ( p(V43)
        | p(V470)
        | ~ p(V349) )
      & ( ~ p(V5)
        | p(V4) )
      & ( p(V452)
        | p(V476)
        | ~ p(V254) )
      & ( p(V469)
        | ~ p(V35)
        | p(V71) )
      & ( ~ p(V476)
        | ~ p(V294)
        | p(V258) )
      & ( ~ p(V232)
        | p(V475)
        | p(V448) )
      & ( p(V475)
        | p(V433)
        | ~ p(V217) )
      & ( ~ p(V96)
        | p(V366)
        | ~ p(V471) ) ) ).

fof(true_not_false,axiom,
    true != false ).

%------------------------------------------------------------------------------
