%------------------------------------------------------------------------------
% File     : HWV071-1 : TPTP v9.2.0. Bugfixed v5.5.1.
% Domain   : Hardware Verification
% Problem  : QBFLib problem from the Counter family
% Version  : Especial.
% English  : A generator for the following problem. Given an n-bit-counter
%            with optional reset r and enable e signals, check whether it is
%            possible to reach the state where all n bits are set to 1
%            starting from the initial state where all bits are set to 0.

% Refs     : [Sei12] Seidl (2012), Email to Geoff Sutcliffe
%          : [SLB12] Seidl et al. (2012), Tool for Generating EPR Formulas
% Source   : [Sei12]
% Names    : counter_8-shuffled [Sei12]

% Status   : Satisfiable
% Rating   : 0.43 v9.1.0, 0.25 v9.0.0, 0.17 v8.2.0, 0.20 v7.5.0, 0.25 v7.0.0, 0.20 v6.4.0, 0.00 v6.3.0, 0.25 v6.2.0, 0.67 v6.1.0, 0.60 v6.0.0
% Syntax   : Number of clauses     : 1180 (  13 unt; 567 nHn; 907 RR)
%            Number of literals    : 3478 (   1 equ;1750 neg)
%            Maximal clause size   :    3 (   2 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  :  444 ( 443 usr;  51 prp; 0-8 aty)
%            Number of functors    :    2 (   2 usr;   2 con; 0-0 aty)
%            Number of variables   : 5528 (   0 sgn)
% SPC      : CNF_SAT_EPR_EQU_NUE

% Comments :
% Bugfixes : v5.5.1 - Fixed rule_true and rule_false, added true_not_false
%------------------------------------------------------------------------------
cnf(i_0_1,axiom,
    ( p(X1)
    | ~ esk73_1(X1)
    | esk22_0 ) ).

cnf(i_0_2,axiom,
    ( ~ p(X3)
    | ~ esk163_3(X1,X2,X3)
    | esk112_2(X1,X2) ) ).

cnf(i_0_3,axiom,
    ( ~ p(X6)
    | ~ esk266_5(X1,X2,X3,X4,X5)
    | esk317_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4,axiom,
    ( ~ esk35_0
    | esk52_1(X1)
    | p(X1) ) ).

cnf(i_0_5,axiom,
    ( esk428_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk377_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_6,axiom,
    ( ~ p(X4)
    | esk201_3(X1,X2,X3)
    | ~ esk235_4(X1,X2,X3,X4) ) ).

cnf(i_0_7,axiom,
    ( esk269_5(X1,X2,X3,X4,X5)
    | ~ esk320_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_8,axiom,
    ( esk440_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk423_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_9,axiom,
    ( ~ p(X2)
    | ~ esk117_2(X1,X2)
    | esk66_1(X1) ) ).

cnf(i_0_10,axiom,
    ( ~ esk379_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk328_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_11,axiom,
    ( esk330_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk279_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_12,axiom,
    ( ~ esk396_7(X1,X2,X3,X4,X5,X6,X7)
    | esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_13,axiom,
    ( p(X3)
    | ~ esk147_2(X1,X2)
    | esk164_3(X1,X2,X3) ) ).

cnf(i_0_14,axiom,
    ( ~ p(X1)
    | ~ esk53_1(X1)
    | esk2_0 ) ).

cnf(i_0_15,axiom,
    ( esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk430_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_16,axiom,
    ( ~ esk329_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk278_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_17,axiom,
    ~ esk12_0 ).

cnf(i_0_18,axiom,
    ( ~ esk389_7(X1,X2,X3,X4,X5,X6,X7)
    | esk440_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_19,axiom,
    ( ~ esk254_4(X1,X2,X3,X4)
    | esk271_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_20,axiom,
    ( esk293_5(X1,X2,X3,X4,X5)
    | ~ esk327_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_21,axiom,
    ( ~ p(X5)
    | esk278_5(X1,X2,X3,X4,X5)
    | ~ esk244_4(X1,X2,X3,X4) ) ).

cnf(i_0_22,axiom,
    ( ~ p(X7)
    | esk312_6(X1,X2,X3,X4,X5,X6)
    | ~ esk363_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_23,axiom,
    ( ~ p(X4)
    | esk160_3(X1,X2,X3)
    | ~ esk211_4(X1,X2,X3,X4) ) ).

cnf(i_0_24,axiom,
    ( ~ p(X5)
    | esk239_4(X1,X2,X3,X4)
    | ~ esk273_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_25,axiom,
    ( esk165_3(X1,X2,X3)
    | p(X3)
    | ~ esk148_2(X1,X2) ) ).

cnf(i_0_26,axiom,
    ( esk97_1(X1)
    | ~ esk131_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_27,axiom,
    ( esk259_5(X1,X2,X3,X4,X5)
    | ~ esk208_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_28,axiom,
    ( esk342_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk376_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_29,axiom,
    ( esk418_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk367_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_30,axiom,
    ( ~ esk326_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk377_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_31,axiom,
    ( p(X3)
    | ~ esk160_3(X1,X2,X3)
    | esk143_2(X1,X2) ) ).

cnf(i_0_32,axiom,
    ( esk355_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk372_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_33,axiom,
    ( ~ esk187_3(X1,X2,X3)
    | esk238_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_34,axiom,
    ( ~ p(X5)
    | ~ esk242_4(X1,X2,X3,X4)
    | esk276_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_35,axiom,
    ( ~ esk182_3(X1,X2,X3)
    | esk131_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_36,axiom,
    ( esk24_0
    | p(X1)
    | ~ esk75_1(X1) ) ).

cnf(i_0_37,axiom,
    ( p(X5)
    | esk269_5(X1,X2,X3,X4,X5)
    | ~ esk252_4(X1,X2,X3,X4) ) ).

cnf(i_0_38,axiom,
    ( ~ p(X6)
    | ~ esk290_5(X1,X2,X3,X4,X5)
    | esk324_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_39,axiom,
    ( ~ esk101_1(X1)
    | ~ p(X2)
    | esk135_2(X1,X2) ) ).

cnf(i_0_40,axiom,
    ( ~ p(X3)
    | esk107_2(X1,X2)
    | ~ esk158_3(X1,X2,X3) ) ).

cnf(i_0_41,axiom,
    ( ~ esk85_1(X1)
    | ~ p(X1)
    | esk51_0 ) ).

cnf(i_0_42,axiom,
    ( esk235_4(X1,X2,X3,X4)
    | ~ esk286_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_43,axiom,
    ( ~ p(X8)
    | ~ esk404_7(X1,X2,X3,X4,X5,X6,X7)
    | esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_44,axiom,
    ( p(X7)
    | esk391_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk340_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_45,axiom,
    ( ~ p(X7)
    | esk389_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk355_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_46,axiom,
    ( esk427_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk435_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_47,axiom,
    ( p(X1)
    | ~ esk71_1(X1)
    | esk20_0 ) ).

cnf(i_0_48,axiom,
    ( esk281_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk332_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_49,axiom,
    ( ~ esk391_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk357_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_50,axiom,
    ( esk85_1(X1)
    | p(X2)
    | ~ esk136_2(X1,X2) ) ).

cnf(i_0_51,axiom,
    ( p(X8)
    | ~ esk381_7(X1,X2,X3,X4,X5,X6,X7)
    | esk432_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_52,axiom,
    ( ~ p(X2)
    | ~ esk66_1(X1)
    | esk117_2(X1,X2) ) ).

cnf(i_0_53,axiom,
    ( ~ esk308_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk291_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_54,axiom,
    ( esk73_1(X1)
    | ~ esk39_0
    | ~ p(X1) ) ).

cnf(i_0_55,axiom,
    ( esk179_3(X1,X2,X3)
    | ~ esk128_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_56,axiom,
    ( esk102_1(X1)
    | ~ p(X2)
    | ~ esk136_2(X1,X2) ) ).

cnf(i_0_57,axiom,
    ( esk76_1(X1)
    | ~ p(X1)
    | ~ esk42_0 ) ).

cnf(i_0_58,axiom,
    ( esk70_1(X1)
    | p(X1)
    | ~ esk19_0 ) ).

cnf(i_0_59,axiom,
    ( p(X7)
    | ~ esk371_7(X1,X2,X3,X4,X5,X6,X7)
    | esk354_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_60,axiom,
    ( esk143_2(X1,X2)
    | ~ p(X3)
    | ~ esk177_3(X1,X2,X3) ) ).

cnf(i_0_61,axiom,
    ( ~ esk126_2(X1,X2)
    | esk177_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_62,axiom,
    ( ~ esk127_2(X1,X2)
    | p(X3)
    | esk178_3(X1,X2,X3) ) ).

cnf(i_0_63,axiom,
    ( ~ esk54_1(X1)
    | esk105_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_64,axiom,
    ( ~ esk205_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk154_3(X1,X2,X3) ) ).

cnf(i_0_65,axiom,
    ( ~ esk210_4(X1,X2,X3,X4)
    | p(X4)
    | esk193_3(X1,X2,X3) ) ).

cnf(i_0_66,axiom,
    ( esk303_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk337_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_67,axiom,
    ( esk325_6(X1,X2,X3,X4,X5,X6)
    | ~ esk291_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_68,axiom,
    ( ~ p(X1)
    | esk68_1(X1)
    | ~ esk17_0 ) ).

cnf(i_0_69,axiom,
    ( ~ p(X5)
    | esk262_5(X1,X2,X3,X4,X5)
    | ~ esk211_4(X1,X2,X3,X4) ) ).

cnf(i_0_70,axiom,
    ( esk267_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk318_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_71,axiom,
    ( esk64_1(X1)
    | ~ esk13_0
    | ~ p(X1) ) ).

cnf(i_0_72,axiom,
    ( p(X6)
    | esk323_6(X1,X2,X3,X4,X5,X6)
    | ~ esk306_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_73,axiom,
    ( ~ esk322_6(X1,X2,X3,X4,X5,X6)
    | esk271_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_74,axiom,
    ( ~ p(X8)
    | esk415_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk364_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_75,axiom,
    ( esk42_0
    | p(X1)
    | ~ esk59_1(X1) ) ).

cnf(i_0_76,axiom,
    ( esk167_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk218_4(X1,X2,X3,X4) ) ).

cnf(i_0_77,axiom,
    ( esk187_3(X1,X2,X3)
    | p(X4)
    | ~ esk238_4(X1,X2,X3,X4) ) ).

cnf(i_0_78,axiom,
    ( ~ esk321_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk270_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_79,axiom,
    ( p(X2)
    | esk128_2(X1,X2)
    | ~ esk77_1(X1) ) ).

cnf(i_0_80,axiom,
    ( ~ esk110_2(X1,X2)
    | esk161_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_81,axiom,
    ( ~ esk331_6(X1,X2,X3,X4,X5,X6)
    | esk382_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_82,axiom,
    ( esk269_5(X1,X2,X3,X4,X5)
    | ~ esk218_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_83,axiom,
    ( p(X5)
    | esk256_5(X1,X2,X3,X4,X5)
    | ~ esk239_4(X1,X2,X3,X4) ) ).

cnf(i_0_84,axiom,
    ( esk61_1(X1)
    | ~ esk10_0
    | ~ p(X1) ) ).

cnf(i_0_85,axiom,
    ( esk363_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_86,axiom,
    ( ~ p(X1)
    | esk40_0
    | ~ esk74_1(X1) ) ).

cnf(i_0_87,axiom,
    ( ~ p(X6)
    | ~ esk316_6(X1,X2,X3,X4,X5,X6)
    | esk265_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_88,axiom,
    ( p(X1)
    | esk83_1(X1)
    | ~ esk32_0 ) ).

cnf(i_0_89,axiom,
    ( ~ p(X7)
    | ~ esk352_6(X1,X2,X3,X4,X5,X6)
    | esk386_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_90,axiom,
    ( esk426_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk417_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_91,axiom,
    ( ~ esk120_2(X1,X2)
    | esk69_1(X1)
    | p(X2) ) ).

cnf(i_0_92,axiom,
    ( ~ esk133_2(X1,X2)
    | esk82_1(X1)
    | p(X2) ) ).

cnf(i_0_93,axiom,
    ( p(X7)
    | esk326_6(X1,X2,X3,X4,X5,X6)
    | ~ esk377_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_94,axiom,
    ( esk378_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_95,axiom,
    ( ~ p(X2)
    | esk113_2(X1,X2)
    | ~ esk62_1(X1) ) ).

cnf(i_0_96,axiom,
    ( ~ esk210_4(X1,X2,X3,X4)
    | esk261_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_97,axiom,
    ( esk307_6(X1,X2,X3,X4,X5,X6)
    | ~ esk290_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_98,axiom,
    ( esk334_6(X1,X2,X3,X4,X5,X6)
    | ~ esk385_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_99,axiom,
    ( p(X6)
    | esk327_6(X1,X2,X3,X4,X5,X6)
    | ~ esk276_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_100,axiom,
    ( esk353_6(X1,X2,X3,X4,X5,X6)
    | ~ esk370_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_101,axiom,
    ( p(X4)
    | esk184_3(X1,X2,X3)
    | ~ esk235_4(X1,X2,X3,X4) ) ).

cnf(i_0_102,axiom,
    ( esk259_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk242_4(X1,X2,X3,X4) ) ).

cnf(i_0_103,axiom,
    ( ~ esk125_2(X1,X2)
    | ~ p(X2)
    | esk91_1(X1) ) ).

cnf(i_0_104,axiom,
    ( p(X8)
    | ~ esk393_7(X1,X2,X3,X4,X5,X6,X7)
    | esk410_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_105,axiom,
    ( esk187_3(X1,X2,X3)
    | ~ esk153_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_106,axiom,
    ( esk196_3(X1,X2,X3)
    | ~ esk213_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_107,axiom,
    ( p(X3)
    | esk181_3(X1,X2,X3)
    | ~ esk130_2(X1,X2) ) ).

cnf(i_0_108,axiom,
    ( esk212_4(X1,X2,X3,X4)
    | ~ esk195_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_109,axiom,
    ( p(X5)
    | ~ esk269_5(X1,X2,X3,X4,X5)
    | esk252_4(X1,X2,X3,X4) ) ).

cnf(i_0_110,axiom,
    ( ~ p(X7)
    | esk369_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk318_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_111,axiom,
    ( p(X8)
    | ~ esk401_7(X1,X2,X3,X4,X5,X6,X7)
    | esk418_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_112,axiom,
    ( ~ esk76_1(X1)
    | esk42_0
    | ~ p(X1) ) ).

cnf(i_0_113,axiom,
    ( ~ p(X1)
    | esk82_1(X1)
    | ~ esk48_0 ) ).

cnf(i_0_114,axiom,
    ( esk203_3(X1,X2,X3)
    | p(X4)
    | ~ esk220_4(X1,X2,X3,X4) ) ).

cnf(i_0_115,axiom,
    ( ~ esk130_2(X1,X2)
    | ~ p(X2)
    | esk96_1(X1) ) ).

cnf(i_0_116,axiom,
    ( esk85_1(X1)
    | ~ esk51_0
    | ~ p(X1) ) ).

cnf(i_0_117,axiom,
    ( p(X4)
    | ~ esk209_4(X1,X2,X3,X4)
    | esk192_3(X1,X2,X3) ) ).

cnf(i_0_118,axiom,
    ( esk310_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk259_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_119,axiom,
    ( ~ esk409_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk426_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_120,axiom,
    ~ esk17_0 ).

cnf(i_0_121,axiom,
    ( ~ esk315_6(X1,X2,X3,X4,X5,X6)
    | esk264_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_122,axiom,
    ( esk205_4(X1,X2,X3,X4)
    | ~ esk256_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_123,axiom,
    ( ~ esk55_1(X1)
    | p(X1)
    | esk38_0 ) ).

cnf(i_0_124,axiom,
    ( p(X6)
    | esk332_6(X1,X2,X3,X4,X5,X6)
    | ~ esk281_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_125,axiom,
    ( ~ p(X5)
    | esk264_5(X1,X2,X3,X4,X5)
    | ~ esk213_4(X1,X2,X3,X4) ) ).

cnf(i_0_126,axiom,
    ( ~ esk293_5(X1,X2,X3,X4,X5)
    | esk327_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_127,axiom,
    ( esk395_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_128,axiom,
    ( esk239_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk256_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_129,axiom,
    ( esk210_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk159_3(X1,X2,X3) ) ).

cnf(i_0_130,axiom,
    ( ~ esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk424_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_131,axiom,
    ( esk389_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk440_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_132,axiom,
    ( ~ esk324_6(X1,X2,X3,X4,X5,X6)
    | esk273_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_133,axiom,
    ( ~ p(X7)
    | esk355_6(X1,X2,X3,X4,X5,X6)
    | ~ esk389_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_134,axiom,
    ( ~ esk215_4(X1,X2,X3,X4)
    | p(X4)
    | esk198_3(X1,X2,X3) ) ).

cnf(i_0_135,axiom,
    ( ~ esk94_1(X1)
    | esk128_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_136,axiom,
    ( ~ p(X1)
    | ~ esk77_1(X1)
    | esk43_0 ) ).

cnf(i_0_137,axiom,
    ( ~ esk434_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk400_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_138,axiom,
    ( esk286_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk337_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_139,axiom,
    ( esk72_1(X1)
    | p(X2)
    | ~ esk123_2(X1,X2) ) ).

cnf(i_0_140,axiom,
    esk18_0 ).

cnf(i_0_141,axiom,
    ( ~ esk298_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk315_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_142,axiom,
    ( esk229_4(X1,X2,X3,X4)
    | ~ esk195_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_143,axiom,
    ( esk258_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk309_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_144,axiom,
    ( p(X6)
    | ~ esk300_5(X1,X2,X3,X4,X5)
    | esk317_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_145,axiom,
    ( p(X3)
    | esk184_3(X1,X2,X3)
    | ~ esk133_2(X1,X2) ) ).

cnf(i_0_146,axiom,
    ( p(X4)
    | esk197_3(X1,X2,X3)
    | ~ esk214_4(X1,X2,X3,X4) ) ).

cnf(i_0_147,axiom,
    ( ~ esk390_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk339_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_148,axiom,
    ( esk102_1(X1)
    | ~ esk119_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_149,axiom,
    ( ~ p(X6)
    | ~ esk333_6(X1,X2,X3,X4,X5,X6)
    | esk299_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_150,axiom,
    ~ esk14_0 ).

cnf(i_0_151,axiom,
    ( ~ p(X7)
    | ~ esk345_6(X1,X2,X3,X4,X5,X6)
    | esk379_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_152,axiom,
    ( p(X8)
    | ~ esk406_7(X1,X2,X3,X4,X5,X6,X7)
    | esk423_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_153,axiom,
    ( ~ esk134_2(X1,X2)
    | esk83_1(X1)
    | p(X2) ) ).

cnf(i_0_154,axiom,
    ( p(X4)
    | esk182_3(X1,X2,X3)
    | ~ esk233_4(X1,X2,X3,X4) ) ).

cnf(i_0_155,axiom,
    ( esk89_1(X1)
    | ~ esk106_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_156,axiom,
    ( esk115_2(X1,X2)
    | ~ esk64_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_157,axiom,
    ( ~ esk418_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk401_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_158,axiom,
    ( esk310_6(X1,X2,X3,X4,X5,X6)
    | ~ esk361_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_159,axiom,
    ( ~ p(X6)
    | esk318_6(X1,X2,X3,X4,X5,X6)
    | ~ esk267_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_160,axiom,
    ( p(X1)
    | esk40_0
    | ~ esk57_1(X1) ) ).

cnf(i_0_161,axiom,
    ( ~ esk43_0
    | p(X1)
    | esk60_1(X1) ) ).

cnf(i_0_162,axiom,
    ( esk85_1(X1)
    | ~ esk34_0
    | p(X1) ) ).

cnf(i_0_163,axiom,
    ( ~ esk248_4(X1,X2,X3,X4)
    | esk265_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_164,axiom,
    ( esk145_2(X1,X2)
    | p(X3)
    | ~ esk162_3(X1,X2,X3) ) ).

cnf(i_0_165,axiom,
    ( p(X3)
    | ~ esk131_2(X1,X2)
    | esk182_3(X1,X2,X3) ) ).

cnf(i_0_166,axiom,
    ( ~ p(X6)
    | esk339_6(X1,X2,X3,X4,X5,X6)
    | ~ esk305_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_167,axiom,
    ( ~ esk156_3(X1,X2,X3)
    | esk105_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_168,axiom,
    ( p(X6)
    | ~ esk318_6(X1,X2,X3,X4,X5,X6)
    | esk301_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_169,axiom,
    ( ~ esk208_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk157_3(X1,X2,X3) ) ).

cnf(i_0_170,axiom,
    ( esk368_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk419_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_171,axiom,
    ( esk12_0
    | ~ p(X1)
    | ~ esk63_1(X1) ) ).

cnf(i_0_172,axiom,
    ( ~ esk15_0
    | esk66_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_173,axiom,
    ( ~ esk324_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk375_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_174,axiom,
    ( esk350_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk384_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_175,axiom,
    ( ~ esk126_2(X1,X2)
    | p(X2)
    | esk75_1(X1) ) ).

cnf(i_0_176,axiom,
    ( esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk391_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_177,axiom,
    ( esk144_2(X1,X2)
    | ~ p(X3)
    | ~ esk178_3(X1,X2,X3) ) ).

cnf(i_0_178,axiom,
    ( esk260_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk209_4(X1,X2,X3,X4) ) ).

cnf(i_0_179,axiom,
    ( esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_180,axiom,
    ( p(X3)
    | esk124_2(X1,X2)
    | ~ esk175_3(X1,X2,X3) ) ).

cnf(i_0_181,axiom,
    ( ~ p(X8)
    | esk440_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk406_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_182,axiom,
    ( ~ p(X6)
    | ~ esk264_5(X1,X2,X3,X4,X5)
    | esk315_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_183,axiom,
    ( ~ esk157_3(X1,X2,X3)
    | esk140_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_184,axiom,
    ( esk292_5(X1,X2,X3,X4,X5)
    | ~ esk309_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_185,axiom,
    ( p(X2)
    | ~ esk92_1(X1)
    | esk109_2(X1,X2) ) ).

cnf(i_0_186,axiom,
    ( ~ p(X3)
    | esk185_3(X1,X2,X3)
    | ~ esk151_2(X1,X2) ) ).

cnf(i_0_187,axiom,
    ( esk78_1(X1)
    | p(X1)
    | ~ esk27_0 ) ).

cnf(i_0_188,axiom,
    ( p(X7)
    | esk388_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk337_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_189,axiom,
    ( esk106_2(X1,X2)
    | ~ esk157_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_190,axiom,
    ( esk103_2(X1,X2)
    | ~ p(X3)
    | ~ esk154_3(X1,X2,X3) ) ).

cnf(i_0_191,axiom,
    ( esk231_4(X1,X2,X3,X4)
    | ~ esk282_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_192,axiom,
    ( ~ esk198_3(X1,X2,X3)
    | ~ p(X4)
    | esk232_4(X1,X2,X3,X4) ) ).

cnf(i_0_193,axiom,
    ( p(X7)
    | esk338_6(X1,X2,X3,X4,X5,X6)
    | ~ esk389_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_194,axiom,
    ( esk166_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk217_4(X1,X2,X3,X4) ) ).

cnf(i_0_195,axiom,
    ( esk364_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk347_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_196,axiom,
    ( ~ esk105_2(X1,X2)
    | esk88_1(X1)
    | p(X2) ) ).

cnf(i_0_197,axiom,
    ( p(X1)
    | ~ esk53_1(X1)
    | esk36_0 ) ).

cnf(i_0_198,axiom,
    ( ~ esk319_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk268_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_199,axiom,
    ( p(X5)
    | ~ esk231_4(X1,X2,X3,X4)
    | esk282_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_200,axiom,
    ( ~ esk322_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk305_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_201,axiom,
    ( p(X7)
    | ~ esk349_6(X1,X2,X3,X4,X5,X6)
    | esk366_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_202,axiom,
    ( ~ p(X1)
    | esk56_1(X1)
    | ~ esk5_0 ) ).

cnf(i_0_203,axiom,
    ( esk48_0
    | ~ p(X1)
    | ~ esk82_1(X1) ) ).

cnf(i_0_204,axiom,
    ( ~ esk417_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk366_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_205,axiom,
    ( ~ esk216_4(X1,X2,X3,X4)
    | esk165_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_206,axiom,
    ( esk358_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk307_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_207,axiom,
    ( ~ esk336_6(X1,X2,X3,X4,X5,X6)
    | esk302_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_208,axiom,
    ( ~ esk199_3(X1,X2,X3)
    | esk233_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_209,axiom,
    ( ~ esk313_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk364_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_210,axiom,
    ( ~ p(X8)
    | esk372_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk423_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_211,axiom,
    ( ~ esk178_3(X1,X2,X3)
    | p(X4)
    | esk229_4(X1,X2,X3,X4) ) ).

cnf(i_0_212,axiom,
    ( esk434_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk400_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_213,axiom,
    ( esk231_4(X1,X2,X3,X4)
    | ~ esk197_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_214,axiom,
    ( ~ esk106_2(X1,X2)
    | ~ p(X3)
    | esk157_3(X1,X2,X3) ) ).

cnf(i_0_215,axiom,
    ~ esk1_0 ).

cnf(i_0_216,axiom,
    ( esk189_3(X1,X2,X3)
    | ~ esk206_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_217,axiom,
    ( p(X3)
    | esk185_3(X1,X2,X3)
    | ~ esk134_2(X1,X2) ) ).

cnf(i_0_218,axiom,
    ( ~ p(X1)
    | esk74_1(X1)
    | ~ esk40_0 ) ).

cnf(i_0_219,axiom,
    ~ esk15_0 ).

cnf(i_0_220,axiom,
    ( p(X8)
    | ~ esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk388_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_221,axiom,
    ( esk180_3(X1,X2,X3)
    | ~ esk129_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_222,axiom,
    ( esk354_6(X1,X2,X3,X4,X5,X6)
    | ~ esk388_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_223,axiom,
    ( esk393_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk427_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_224,axiom,
    ( esk59_1(X1)
    | ~ esk42_0
    | p(X1) ) ).

cnf(i_0_225,axiom,
    ( ~ esk115_2(X1,X2)
    | esk64_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_226,axiom,
    ( ~ esk134_2(X1,X2)
    | ~ p(X2)
    | esk100_1(X1) ) ).

cnf(i_0_227,axiom,
    ( ~ esk18_0
    | esk69_1(X1)
    | p(X1) ) ).

cnf(i_0_228,axiom,
    ( ~ p(X5)
    | ~ esk246_4(X1,X2,X3,X4)
    | esk280_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_229,axiom,
    ( esk39_0
    | ~ esk56_1(X1)
    | p(X1) ) ).

cnf(i_0_230,axiom,
    ( esk253_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk287_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_231,axiom,
    ( p(X4)
    | esk201_3(X1,X2,X3)
    | ~ esk218_4(X1,X2,X3,X4) ) ).

cnf(i_0_232,axiom,
    ( ~ p(X3)
    | esk163_3(X1,X2,X3)
    | ~ esk112_2(X1,X2) ) ).

cnf(i_0_233,axiom,
    ( ~ esk91_1(X1)
    | esk108_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_234,axiom,
    ( ~ p(X8)
    | ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk360_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_235,axiom,
    ( ~ esk381_7(X1,X2,X3,X4,X5,X6,X7)
    | esk347_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_236,axiom,
    ( esk283_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk232_4(X1,X2,X3,X4) ) ).

cnf(i_0_237,axiom,
    ( esk275_5(X1,X2,X3,X4,X5)
    | ~ esk224_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_238,axiom,
    ( ~ esk188_3(X1,X2,X3)
    | esk205_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_239,axiom,
    ( p(X2)
    | ~ esk112_2(X1,X2)
    | esk95_1(X1) ) ).

cnf(i_0_240,axiom,
    ( ~ esk315_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk298_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_241,axiom,
    ( ~ esk192_3(X1,X2,X3)
    | ~ p(X4)
    | esk226_4(X1,X2,X3,X4) ) ).

cnf(i_0_242,axiom,
    ( p(X2)
    | ~ esk108_2(X1,X2)
    | esk91_1(X1) ) ).

cnf(i_0_243,axiom,
    ( esk376_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk427_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_244,axiom,
    ( ~ p(X4)
    | ~ esk233_4(X1,X2,X3,X4)
    | esk199_3(X1,X2,X3) ) ).

cnf(i_0_245,axiom,
    ( p(X4)
    | ~ esk171_3(X1,X2,X3)
    | esk222_4(X1,X2,X3,X4) ) ).

cnf(i_0_246,axiom,
    ( ~ esk41_0
    | esk75_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_247,axiom,
    ( esk157_3(X1,X2,X3)
    | p(X3)
    | ~ esk140_2(X1,X2) ) ).

cnf(i_0_248,axiom,
    ( ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk425_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_249,axiom,
    ( esk58_1(X1)
    | ~ p(X2)
    | ~ esk109_2(X1,X2) ) ).

cnf(i_0_250,axiom,
    ( esk274_5(X1,X2,X3,X4,X5)
    | ~ esk240_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_251,axiom,
    ( esk330_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk381_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_252,axiom,
    ( p(X7)
    | esk363_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk346_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_253,axiom,
    ( p(X6)
    | esk312_6(X1,X2,X3,X4,X5,X6)
    | ~ esk295_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_254,axiom,
    ( esk378_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk344_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_255,axiom,
    ( ~ esk174_3(X1,X2,X3)
    | esk140_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_256,axiom,
    ( esk113_2(X1,X2)
    | ~ p(X3)
    | ~ esk164_3(X1,X2,X3) ) ).

cnf(i_0_257,axiom,
    ( ~ p(X1)
    | ~ esk35_0
    | esk69_1(X1) ) ).

cnf(i_0_258,axiom,
    ( p(X4)
    | ~ esk203_3(X1,X2,X3)
    | esk220_4(X1,X2,X3,X4) ) ).

cnf(i_0_259,axiom,
    ( ~ esk81_1(X1)
    | ~ p(X1)
    | esk47_0 ) ).

cnf(i_0_260,axiom,
    ( ~ esk143_2(X1,X2)
    | esk160_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_261,axiom,
    ( esk257_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk240_4(X1,X2,X3,X4) ) ).

cnf(i_0_262,axiom,
    ( ~ esk46_0
    | esk63_1(X1)
    | p(X1) ) ).

cnf(i_0_263,axiom,
    ( ~ esk432_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk440_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_264,axiom,
    ( ~ p(X3)
    | ~ esk183_3(X1,X2,X3)
    | esk149_2(X1,X2) ) ).

cnf(i_0_265,axiom,
    ( ~ p(X4)
    | ~ esk203_3(X1,X2,X3)
    | esk237_4(X1,X2,X3,X4) ) ).

cnf(i_0_266,axiom,
    ( esk288_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk237_4(X1,X2,X3,X4) ) ).

cnf(i_0_267,axiom,
    ( esk34_0
    | p(X1)
    | ~ esk85_1(X1) ) ).

cnf(i_0_268,axiom,
    ( ~ p(X3)
    | ~ esk141_2(X1,X2)
    | esk175_3(X1,X2,X3) ) ).

cnf(i_0_269,axiom,
    ( ~ p(X8)
    | ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk361_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_270,axiom,
    ( ~ esk339_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk390_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_271,axiom,
    ( esk344_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk378_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_272,axiom,
    ( ~ esk48_0
    | esk65_1(X1)
    | p(X1) ) ).

cnf(i_0_273,axiom,
    ( ~ esk169_3(X1,X2,X3)
    | p(X3)
    | esk152_2(X1,X2) ) ).

cnf(i_0_274,axiom,
    ( p(X8)
    | esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk405_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_275,axiom,
    ( p(X6)
    | esk294_5(X1,X2,X3,X4,X5)
    | ~ esk311_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_276,axiom,
    ( esk330_6(X1,X2,X3,X4,X5,X6)
    | ~ esk296_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_277,axiom,
    ( ~ esk379_7(X1,X2,X3,X4,X5,X6,X7)
    | esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_278,axiom,
    ( ~ esk137_2(X1,X2)
    | esk171_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_279,axiom,
    ( p(X2)
    | esk120_2(X1,X2)
    | ~ esk69_1(X1) ) ).

cnf(i_0_280,axiom,
    ( ~ esk130_2(X1,X2)
    | p(X2)
    | esk79_1(X1) ) ).

cnf(i_0_281,axiom,
    ( p(X8)
    | ~ esk376_7(X1,X2,X3,X4,X5,X6,X7)
    | esk427_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_282,axiom,
    ( esk46_0
    | ~ esk80_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_283,axiom,
    ( esk376_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk325_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_284,axiom,
    ( p(X7)
    | ~ esk333_6(X1,X2,X3,X4,X5,X6)
    | esk384_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_285,axiom,
    ( ~ p(X3)
    | ~ esk142_2(X1,X2)
    | esk176_3(X1,X2,X3) ) ).

cnf(i_0_286,axiom,
    ( ~ esk437_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk428_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_287,axiom,
    ( p(X6)
    | esk283_5(X1,X2,X3,X4,X5)
    | ~ esk334_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_288,axiom,
    ( p(X1)
    | esk76_1(X1)
    | ~ esk25_0 ) ).

cnf(i_0_289,axiom,
    ( p(X1)
    | esk35_0
    | ~ esk52_1(X1) ) ).

cnf(i_0_290,axiom,
    ( esk432_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk433_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_291,axiom,
    ( ~ esk43_0
    | esk77_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_292,axiom,
    ( esk71_1(X1)
    | p(X1)
    | ~ esk20_0 ) ).

cnf(i_0_293,axiom,
    ( p(X7)
    | ~ esk357_6(X1,X2,X3,X4,X5,X6)
    | esk374_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_294,axiom,
    ( p(X3)
    | ~ esk158_3(X1,X2,X3)
    | esk141_2(X1,X2) ) ).

cnf(i_0_295,axiom,
    ( esk424_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_296,axiom,
    ( esk340_6(X1,X2,X3,X4,X5,X6)
    | ~ esk306_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_297,axiom,
    ( p(X8)
    | ~ esk432_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk381_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_298,axiom,
    ( ~ esk383_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk349_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_299,axiom,
    ( esk374_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_300,axiom,
    ( ~ esk95_1(X1)
    | ~ p(X2)
    | esk129_2(X1,X2) ) ).

cnf(i_0_301,axiom,
    ( esk184_3(X1,X2,X3)
    | ~ p(X3)
    | ~ esk150_2(X1,X2) ) ).

cnf(i_0_302,axiom,
    ( p(X4)
    | esk174_3(X1,X2,X3)
    | ~ esk225_4(X1,X2,X3,X4) ) ).

cnf(i_0_303,axiom,
    ( ~ p(X5)
    | ~ esk282_5(X1,X2,X3,X4,X5)
    | esk248_4(X1,X2,X3,X4) ) ).

cnf(i_0_304,axiom,
    ( esk387_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk353_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_305,axiom,
    ( esk222_4(X1,X2,X3,X4)
    | ~ esk273_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_306,axiom,
    ( ~ esk124_2(X1,X2)
    | p(X2)
    | esk73_1(X1) ) ).

cnf(i_0_307,axiom,
    ( ~ esk111_2(X1,X2)
    | ~ p(X2)
    | esk60_1(X1) ) ).

cnf(i_0_308,axiom,
    ( esk121_2(X1,X2)
    | ~ esk87_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_309,axiom,
    ( ~ esk220_4(X1,X2,X3,X4)
    | esk169_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_310,axiom,
    ( esk367_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk350_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_311,axiom,
    ( esk59_1(X1)
    | ~ p(X1)
    | ~ esk8_0 ) ).

cnf(i_0_312,axiom,
    ( p(X4)
    | ~ esk172_3(X1,X2,X3)
    | esk223_4(X1,X2,X3,X4) ) ).

cnf(i_0_313,axiom,
    ( ~ esk277_5(X1,X2,X3,X4,X5)
    | esk243_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_314,axiom,
    ( esk227_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk278_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_315,axiom,
    ( ~ esk322_6(X1,X2,X3,X4,X5,X6)
    | esk373_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_316,axiom,
    ( ~ esk186_3(X1,X2,X3)
    | esk237_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_317,axiom,
    ( ~ esk368_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk351_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_318,axiom,
    ( ~ esk116_2(X1,X2)
    | ~ p(X3)
    | esk167_3(X1,X2,X3) ) ).

cnf(i_0_319,axiom,
    ( esk224_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk173_3(X1,X2,X3) ) ).

cnf(i_0_320,axiom,
    ( ~ esk305_5(X1,X2,X3,X4,X5)
    | esk322_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_321,axiom,
    ( ~ esk118_2(X1,X2)
    | esk169_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_322,axiom,
    ( esk104_2(X1,X2)
    | ~ esk53_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_323,axiom,
    ( esk227_4(X1,X2,X3,X4)
    | ~ esk193_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_324,axiom,
    ( esk235_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk184_3(X1,X2,X3) ) ).

cnf(i_0_325,axiom,
    ( ~ p(X1)
    | ~ esk62_1(X1)
    | esk11_0 ) ).

cnf(i_0_326,axiom,
    ( ~ esk393_7(X1,X2,X3,X4,X5,X6,X7)
    | esk427_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_327,axiom,
    ( p(X6)
    | esk320_6(X1,X2,X3,X4,X5,X6)
    | ~ esk303_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_328,axiom,
    ( esk415_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk398_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_329,axiom,
    ( ~ esk109_2(X1,X2)
    | esk160_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_330,axiom,
    ( esk174_3(X1,X2,X3)
    | ~ esk123_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_331,axiom,
    ( ~ esk301_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk335_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_332,axiom,
    ( ~ esk125_2(X1,X2)
    | esk74_1(X1)
    | p(X2) ) ).

cnf(i_0_333,axiom,
    ( esk232_4(X1,X2,X3,X4)
    | ~ esk283_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_334,axiom,
    ( esk288_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk254_4(X1,X2,X3,X4) ) ).

cnf(i_0_335,axiom,
    ( esk136_2(X1,X2)
    | ~ p(X2)
    | ~ esk102_1(X1) ) ).

cnf(i_0_336,axiom,
    ( esk206_4(X1,X2,X3,X4)
    | ~ esk155_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_337,axiom,
    ( p(X6)
    | ~ esk327_6(X1,X2,X3,X4,X5,X6)
    | esk276_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_338,axiom,
    ( ~ esk178_3(X1,X2,X3)
    | esk127_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_339,axiom,
    ( p(X7)
    | ~ esk328_6(X1,X2,X3,X4,X5,X6)
    | esk379_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_340,axiom,
    ( p(X5)
    | ~ esk271_5(X1,X2,X3,X4,X5)
    | esk254_4(X1,X2,X3,X4) ) ).

cnf(i_0_341,axiom,
    ( ~ esk98_1(X1)
    | p(X2)
    | esk115_2(X1,X2) ) ).

cnf(i_0_342,axiom,
    ( esk296_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk313_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_343,axiom,
    ( esk168_3(X1,X2,X3)
    | ~ esk151_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_344,axiom,
    ( ~ p(X5)
    | ~ esk281_5(X1,X2,X3,X4,X5)
    | esk247_4(X1,X2,X3,X4) ) ).

cnf(i_0_345,axiom,
    ( esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_346,axiom,
    ( ~ esk432_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk431_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_347,axiom,
    ( ~ p(X4)
    | ~ esk157_3(X1,X2,X3)
    | esk208_4(X1,X2,X3,X4) ) ).

cnf(i_0_348,axiom,
    ( esk341_6(X1,X2,X3,X4,X5,X6)
    | ~ esk375_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_349,axiom,
    ( ~ esk395_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk429_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_350,axiom,
    ( ~ esk63_1(X1)
    | esk46_0
    | p(X1) ) ).

cnf(i_0_351,axiom,
    ( ~ esk409_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk392_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_352,axiom,
    ( esk389_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk338_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_353,axiom,
    ( esk218_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk167_3(X1,X2,X3) ) ).

cnf(i_0_354,axiom,
    ( ~ p(X3)
    | ~ esk166_3(X1,X2,X3)
    | esk115_2(X1,X2) ) ).

cnf(i_0_355,axiom,
    ( esk108_2(X1,X2)
    | ~ esk159_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_356,axiom,
    ( esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_357,axiom,
    ( esk313_6(X1,X2,X3,X4,X5,X6)
    | ~ esk364_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_358,axiom,
    ( ~ esk72_1(X1)
    | esk38_0
    | ~ p(X1) ) ).

cnf(i_0_359,axiom,
    ( esk290_5(X1,X2,X3,X4,X5)
    | ~ esk324_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_360,axiom,
    ( ~ esk344_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk361_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_361,axiom,
    ( ~ esk61_1(X1)
    | esk10_0
    | ~ p(X1) ) ).

cnf(i_0_362,axiom,
    ( ~ esk342_6(X1,X2,X3,X4,X5,X6)
    | esk376_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_363,axiom,
    ( ~ esk132_2(X1,X2)
    | ~ p(X2)
    | esk98_1(X1) ) ).

cnf(i_0_364,axiom,
    ( esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_365,axiom,
    ( esk284_5(X1,X2,X3,X4,X5)
    | ~ esk233_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_366,axiom,
    ( esk255_4(X1,X2,X3,X4)
    | ~ esk289_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_367,axiom,
    ( ~ p(X2)
    | esk134_2(X1,X2)
    | ~ esk100_1(X1) ) ).

cnf(i_0_368,axiom,
    ( p(X1)
    | esk41_0
    | ~ esk58_1(X1) ) ).

cnf(i_0_369,axiom,
    ( ~ p(X3)
    | esk117_2(X1,X2)
    | ~ esk168_3(X1,X2,X3) ) ).

cnf(i_0_370,axiom,
    ( p(X6)
    | esk338_6(X1,X2,X3,X4,X5,X6)
    | ~ esk287_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_371,axiom,
    ( ~ esk180_3(X1,X2,X3)
    | ~ p(X3)
    | esk146_2(X1,X2) ) ).

cnf(i_0_372,axiom,
    ( ~ p(X6)
    | ~ esk307_6(X1,X2,X3,X4,X5,X6)
    | esk256_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_373,axiom,
    ( ~ esk129_2(X1,X2)
    | ~ p(X2)
    | esk95_1(X1) ) ).

cnf(i_0_374,axiom,
    ( ~ esk304_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk338_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_375,axiom,
    ( ~ esk156_3(X1,X2,X3)
    | esk139_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_376,axiom,
    ( ~ p(X8)
    | ~ esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk396_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_377,axiom,
    ( ~ esk323_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk374_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_378,axiom,
    ( p(X4)
    | esk175_3(X1,X2,X3)
    | ~ esk226_4(X1,X2,X3,X4) ) ).

cnf(i_0_379,axiom,
    ( ~ p(X6)
    | esk312_6(X1,X2,X3,X4,X5,X6)
    | ~ esk261_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_380,axiom,
    ( ~ esk380_7(X1,X2,X3,X4,X5,X6,X7)
    | esk346_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_381,axiom,
    ( p(X6)
    | ~ esk323_6(X1,X2,X3,X4,X5,X6)
    | esk306_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_382,axiom,
    ( ~ esk61_1(X1)
    | p(X1)
    | esk44_0 ) ).

cnf(i_0_383,axiom,
    ( ~ esk398_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk432_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_384,axiom,
    ( ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk438_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk421_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_385,axiom,
    ( ~ p(X7)
    | ~ esk351_6(X1,X2,X3,X4,X5,X6)
    | esk385_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_386,axiom,
    ( ~ p(X3)
    | ~ esk173_3(X1,X2,X3)
    | esk139_2(X1,X2) ) ).

cnf(i_0_387,axiom,
    ( ~ esk197_3(X1,X2,X3)
    | p(X4)
    | esk214_4(X1,X2,X3,X4) ) ).

cnf(i_0_388,axiom,
    ( ~ esk86_1(X1)
    | esk120_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_389,axiom,
    ( ~ esk174_3(X1,X2,X3)
    | p(X3)
    | esk123_2(X1,X2) ) ).

cnf(i_0_390,axiom,
    ( esk125_2(X1,X2)
    | ~ esk74_1(X1)
    | p(X2) ) ).

cnf(i_0_391,axiom,
    ( esk240_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk274_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_392,axiom,
    ( ~ p(X1)
    | ~ esk60_1(X1)
    | esk9_0 ) ).

cnf(i_0_393,axiom,
    ( ~ esk236_4(X1,X2,X3,X4)
    | esk202_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_394,axiom,
    ( ~ p(X5)
    | ~ esk251_4(X1,X2,X3,X4)
    | esk285_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_395,axiom,
    ( p(X7)
    | esk343_6(X1,X2,X3,X4,X5,X6)
    | ~ esk360_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_396,axiom,
    ( esk344_6(X1,X2,X3,X4,X5,X6)
    | ~ esk361_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_397,axiom,
    ( esk76_1(X1)
    | ~ esk127_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_398,axiom,
    ( ~ esk351_6(X1,X2,X3,X4,X5,X6)
    | esk368_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_399,axiom,
    ( ~ esk282_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk333_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_400,axiom,
    ( p(X3)
    | esk172_3(X1,X2,X3)
    | ~ esk121_2(X1,X2) ) ).

cnf(i_0_401,axiom,
    ( ~ p(X1)
    | esk81_1(X1)
    | ~ esk47_0 ) ).

cnf(i_0_402,axiom,
    ( esk393_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk410_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_403,axiom,
    ( esk79_1(X1)
    | ~ p(X1)
    | ~ esk45_0 ) ).

cnf(i_0_404,axiom,
    ( p(X7)
    | esk345_6(X1,X2,X3,X4,X5,X6)
    | ~ esk362_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_405,axiom,
    ( ~ p(X4)
    | esk204_3(X1,X2,X3)
    | ~ esk238_4(X1,X2,X3,X4) ) ).

cnf(i_0_406,axiom,
    ( ~ esk400_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk417_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_407,axiom,
    ( ~ esk394_7(X1,X2,X3,X4,X5,X6,X7)
    | esk428_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_408,axiom,
    ( ~ p(X7)
    | esk356_6(X1,X2,X3,X4,X5,X6)
    | ~ esk390_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_409,axiom,
    ( p(X2)
    | ~ esk102_1(X1)
    | esk119_2(X1,X2) ) ).

cnf(i_0_410,axiom,
    ( esk428_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk427_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_411,axiom,
    ( p(X5)
    | ~ esk270_5(X1,X2,X3,X4,X5)
    | esk253_4(X1,X2,X3,X4) ) ).

cnf(i_0_412,axiom,
    ( ~ esk382_7(X1,X2,X3,X4,X5,X6,X7)
    | esk348_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_413,axiom,
    ( ~ esk278_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk244_4(X1,X2,X3,X4) ) ).

cnf(i_0_414,axiom,
    ( esk435_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk384_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_415,axiom,
    ( esk329_6(X1,X2,X3,X4,X5,X6)
    | ~ esk295_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_416,axiom,
    ( ~ p(X3)
    | esk152_2(X1,X2)
    | ~ esk186_3(X1,X2,X3) ) ).

cnf(i_0_417,axiom,
    ( ~ esk138_2(X1,X2)
    | p(X3)
    | esk155_3(X1,X2,X3) ) ).

cnf(i_0_418,axiom,
    ( esk156_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk207_4(X1,X2,X3,X4) ) ).

cnf(i_0_419,axiom,
    ( esk225_4(X1,X2,X3,X4)
    | ~ esk174_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_420,axiom,
    ( esk210_4(X1,X2,X3,X4)
    | ~ esk261_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_421,axiom,
    ( ~ esk46_0
    | esk80_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_422,axiom,
    ( esk309_6(X1,X2,X3,X4,X5,X6)
    | ~ esk258_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_423,axiom,
    ( ~ esk268_5(X1,X2,X3,X4,X5)
    | esk319_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_424,axiom,
    ( ~ esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk439_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_425,axiom,
    ( p(X4)
    | esk191_3(X1,X2,X3)
    | ~ esk208_4(X1,X2,X3,X4) ) ).

cnf(i_0_426,axiom,
    ( esk410_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_427,axiom,
    ( p(X2)
    | ~ esk129_2(X1,X2)
    | esk78_1(X1) ) ).

cnf(i_0_428,axiom,
    ( ~ esk66_1(X1)
    | p(X1)
    | esk49_0 ) ).

cnf(i_0_429,axiom,
    ( esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_430,axiom,
    ( ~ esk307_6(X1,X2,X3,X4,X5,X6)
    | esk290_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_431,axiom,
    ( ~ esk116_2(X1,X2)
    | esk65_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_432,axiom,
    ( p(X4)
    | ~ esk183_3(X1,X2,X3)
    | esk234_4(X1,X2,X3,X4) ) ).

cnf(i_0_433,axiom,
    ( ~ p(X3)
    | ~ esk165_3(X1,X2,X3)
    | esk114_2(X1,X2) ) ).

cnf(i_0_434,axiom,
    ( esk123_2(X1,X2)
    | ~ p(X2)
    | ~ esk89_1(X1) ) ).

cnf(i_0_435,axiom,
    ( ~ p(X5)
    | ~ esk260_5(X1,X2,X3,X4,X5)
    | esk209_4(X1,X2,X3,X4) ) ).

cnf(i_0_436,axiom,
    ( esk183_3(X1,X2,X3)
    | p(X4)
    | ~ esk234_4(X1,X2,X3,X4) ) ).

cnf(i_0_437,axiom,
    ( p(X6)
    | esk277_5(X1,X2,X3,X4,X5)
    | ~ esk328_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_438,axiom,
    ( ~ esk97_1(X1)
    | ~ p(X2)
    | esk131_2(X1,X2) ) ).

cnf(i_0_439,axiom,
    ( ~ esk191_3(X1,X2,X3)
    | esk208_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_440,axiom,
    ( ~ p(X5)
    | esk275_5(X1,X2,X3,X4,X5)
    | ~ esk241_4(X1,X2,X3,X4) ) ).

cnf(i_0_441,axiom,
    ( ~ p(X6)
    | esk305_5(X1,X2,X3,X4,X5)
    | ~ esk339_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_442,axiom,
    ( ~ p(X1)
    | esk50_0
    | ~ esk84_1(X1) ) ).

cnf(i_0_443,axiom,
    ( esk195_3(X1,X2,X3)
    | ~ esk212_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_444,axiom,
    ( ~ esk200_3(X1,X2,X3)
    | p(X4)
    | esk217_4(X1,X2,X3,X4) ) ).

cnf(i_0_445,axiom,
    ( ~ esk212_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk161_3(X1,X2,X3) ) ).

cnf(i_0_446,axiom,
    ( esk336_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk285_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_447,axiom,
    ( esk367_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk316_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_448,axiom,
    ( esk180_3(X1,X2,X3)
    | ~ p(X3)
    | ~ esk146_2(X1,X2) ) ).

cnf(i_0_449,axiom,
    ( ~ esk243_4(X1,X2,X3,X4)
    | esk260_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_450,axiom,
    ( ~ p(X8)
    | esk365_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_451,axiom,
    ( esk221_4(X1,X2,X3,X4)
    | ~ esk204_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_452,axiom,
    ( esk245_4(X1,X2,X3,X4)
    | ~ esk262_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_453,axiom,
    ( ~ p(X1)
    | ~ esk73_1(X1)
    | esk39_0 ) ).

cnf(i_0_454,axiom,
    ( p(X6)
    | esk289_5(X1,X2,X3,X4,X5)
    | ~ esk340_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_455,axiom,
    ( p(X3)
    | ~ esk172_3(X1,X2,X3)
    | esk121_2(X1,X2) ) ).

cnf(i_0_456,axiom,
    ( esk370_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk353_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_457,axiom,
    ( esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk371_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_458,axiom,
    ( esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_459,axiom,
    ( esk295_5(X1,X2,X3,X4,X5)
    | ~ esk329_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_460,axiom,
    ( p(X4)
    | ~ esk176_3(X1,X2,X3)
    | esk227_4(X1,X2,X3,X4) ) ).

cnf(i_0_461,axiom,
    ( ~ esk316_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk299_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_462,axiom,
    ( ~ esk232_4(X1,X2,X3,X4)
    | esk198_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_463,axiom,
    ( esk233_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk284_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_464,axiom,
    ( ~ esk281_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk230_4(X1,X2,X3,X4) ) ).

cnf(i_0_465,axiom,
    ( ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_466,axiom,
    ( p(X6)
    | esk335_6(X1,X2,X3,X4,X5,X6)
    | ~ esk284_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_467,axiom,
    ( p(X2)
    | ~ esk109_2(X1,X2)
    | esk92_1(X1) ) ).

cnf(i_0_468,axiom,
    ( esk57_1(X1)
    | ~ esk108_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_469,axiom,
    ( esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk423_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk440_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_470,axiom,
    ( ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk422_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_471,axiom,
    ( p(X6)
    | ~ esk338_6(X1,X2,X3,X4,X5,X6)
    | esk287_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_472,axiom,
    ( ~ esk237_4(X1,X2,X3,X4)
    | esk203_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_473,axiom,
    ( ~ p(X3)
    | esk170_3(X1,X2,X3)
    | ~ esk119_2(X1,X2) ) ).

cnf(i_0_474,axiom,
    ( p(X2)
    | ~ esk85_1(X1)
    | esk136_2(X1,X2) ) ).

cnf(i_0_475,axiom,
    ( esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk388_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_476,axiom,
    ( esk100_1(X1)
    | ~ esk117_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_477,axiom,
    ( esk71_1(X1)
    | ~ esk122_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_478,axiom,
    ( esk274_5(X1,X2,X3,X4,X5)
    | ~ esk223_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_479,axiom,
    ( ~ esk372_7(X1,X2,X3,X4,X5,X6,X7)
    | esk321_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_480,axiom,
    ( ~ esk401_7(X1,X2,X3,X4,X5,X6,X7)
    | esk435_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_481,axiom,
    ( p(X5)
    | esk229_4(X1,X2,X3,X4)
    | ~ esk280_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_482,axiom,
    ( ~ esk36_0
    | esk53_1(X1)
    | p(X1) ) ).

cnf(i_0_483,axiom,
    ( ~ p(X8)
    | ~ esk373_7(X1,X2,X3,X4,X5,X6,X7)
    | esk424_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_484,axiom,
    ( ~ p(X3)
    | ~ esk155_3(X1,X2,X3)
    | esk104_2(X1,X2) ) ).

cnf(i_0_485,axiom,
    ( p(X2)
    | ~ esk81_1(X1)
    | esk132_2(X1,X2) ) ).

cnf(i_0_486,axiom,
    ( ~ p(X3)
    | ~ esk139_2(X1,X2)
    | esk173_3(X1,X2,X3) ) ).

cnf(i_0_487,axiom,
    ( ~ p(X4)
    | ~ esk215_4(X1,X2,X3,X4)
    | esk164_3(X1,X2,X3) ) ).

cnf(i_0_488,axiom,
    ( ~ esk149_2(X1,X2)
    | esk183_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_489,axiom,
    ( esk249_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk266_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_490,axiom,
    ( esk156_3(X1,X2,X3)
    | p(X3)
    | ~ esk139_2(X1,X2) ) ).

cnf(i_0_491,axiom,
    ( ~ p(X2)
    | esk127_2(X1,X2)
    | ~ esk93_1(X1) ) ).

cnf(i_0_492,axiom,
    ( esk153_2(X1,X2)
    | ~ esk187_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_493,axiom,
    ( esk126_2(X1,X2)
    | ~ esk75_1(X1)
    | p(X2) ) ).

cnf(i_0_494,axiom,
    ( esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk433_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_495,axiom,
    ( esk409_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk392_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_496,axiom,
    ( esk282_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk248_4(X1,X2,X3,X4) ) ).

cnf(i_0_497,axiom,
    ( p(X2)
    | ~ esk103_2(X1,X2)
    | esk86_1(X1) ) ).

cnf(i_0_498,axiom,
    ( esk385_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk334_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_499,axiom,
    ( p(X8)
    | esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk385_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_500,axiom,
    ( ~ p(X3)
    | esk141_2(X1,X2)
    | ~ esk175_3(X1,X2,X3) ) ).

cnf(i_0_501,axiom,
    ( esk96_1(X1)
    | ~ esk113_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_502,axiom,
    ( ~ esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk416_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_503,axiom,
    ( esk118_2(X1,X2)
    | ~ p(X2)
    | ~ esk67_1(X1) ) ).

cnf(i_0_504,axiom,
    ( ~ esk226_4(X1,X2,X3,X4)
    | esk277_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_505,axiom,
    ( p(X6)
    | esk280_5(X1,X2,X3,X4,X5)
    | ~ esk331_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_506,axiom,
    ( p(X8)
    | ~ esk404_7(X1,X2,X3,X4,X5,X6,X7)
    | esk421_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_507,axiom,
    ( ~ p(X8)
    | esk431_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk397_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_508,axiom,
    ( esk137_2(X1,X2)
    | ~ p(X3)
    | ~ esk171_3(X1,X2,X3) ) ).

cnf(i_0_509,axiom,
    ( esk266_5(X1,X2,X3,X4,X5)
    | ~ esk215_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_510,axiom,
    ~ esk11_0 ).

cnf(i_0_511,axiom,
    ( esk142_2(X1,X2)
    | ~ p(X3)
    | ~ esk176_3(X1,X2,X3) ) ).

cnf(i_0_512,axiom,
    ( ~ esk132_2(X1,X2)
    | p(X2)
    | esk81_1(X1) ) ).

cnf(i_0_513,axiom,
    ( ~ esk437_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk386_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_514,axiom,
    ( ~ esk179_3(X1,X2,X3)
    | esk128_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_515,axiom,
    ( ~ esk275_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk224_4(X1,X2,X3,X4) ) ).

cnf(i_0_516,axiom,
    ( esk274_5(X1,X2,X3,X4,X5)
    | ~ esk325_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_517,axiom,
    ( ~ esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk419_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk410_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_518,axiom,
    ( p(X7)
    | esk360_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk343_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_519,axiom,
    ( esk97_1(X1)
    | p(X2)
    | ~ esk114_2(X1,X2) ) ).

cnf(i_0_520,axiom,
    ( ~ esk424_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk407_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_521,axiom,
    ( ~ p(X4)
    | esk221_4(X1,X2,X3,X4)
    | ~ esk170_3(X1,X2,X3) ) ).

cnf(i_0_522,axiom,
    ( esk371_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk320_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_523,axiom,
    ( ~ esk26_0
    | p(X1)
    | esk77_1(X1) ) ).

cnf(i_0_524,axiom,
    ( ~ esk141_2(X1,X2)
    | p(X3)
    | esk158_3(X1,X2,X3) ) ).

cnf(i_0_525,axiom,
    ( esk54_1(X1)
    | ~ esk3_0
    | ~ p(X1) ) ).

cnf(i_0_526,axiom,
    ( ~ esk80_1(X1)
    | p(X2)
    | esk131_2(X1,X2) ) ).

cnf(i_0_527,axiom,
    ( ~ esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk395_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_528,axiom,
    ( ~ esk209_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk158_3(X1,X2,X3) ) ).

cnf(i_0_529,axiom,
    ( ~ esk201_3(X1,X2,X3)
    | ~ p(X4)
    | esk235_4(X1,X2,X3,X4) ) ).

cnf(i_0_530,axiom,
    ( esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk437_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_531,axiom,
    ( ~ p(X7)
    | esk345_6(X1,X2,X3,X4,X5,X6)
    | ~ esk379_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_532,axiom,
    ( ~ p(X8)
    | ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk362_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_533,axiom,
    ( ~ p(X7)
    | esk362_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk311_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_534,axiom,
    ( p(X8)
    | ~ esk386_7(X1,X2,X3,X4,X5,X6,X7)
    | esk437_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_535,axiom,
    ( ~ p(X7)
    | esk381_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk347_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_536,axiom,
    ( ~ p(X8)
    | ~ esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk369_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_537,axiom,
    ( ~ esk82_1(X1)
    | p(X2)
    | esk133_2(X1,X2) ) ).

cnf(i_0_538,axiom,
    ( ~ p(X6)
    | ~ esk270_5(X1,X2,X3,X4,X5)
    | esk321_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_539,axiom,
    ( p(X6)
    | esk324_6(X1,X2,X3,X4,X5,X6)
    | ~ esk273_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_540,axiom,
    ( esk237_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk288_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_541,axiom,
    ( ~ esk366_7(X1,X2,X3,X4,X5,X6,X7)
    | esk315_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_542,axiom,
    ( p(X1)
    | ~ esk41_0
    | esk58_1(X1) ) ).

cnf(i_0_543,axiom,
    ( ~ p(X4)
    | esk212_4(X1,X2,X3,X4)
    | ~ esk161_3(X1,X2,X3) ) ).

cnf(i_0_544,axiom,
    ( ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk420_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_545,axiom,
    ( ~ esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk442_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_546,axiom,
    ( ~ esk95_1(X1)
    | esk112_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_547,axiom,
    ( esk63_1(X1)
    | ~ p(X2)
    | ~ esk114_2(X1,X2) ) ).

cnf(i_0_548,axiom,
    ( p(X2)
    | esk127_2(X1,X2)
    | ~ esk76_1(X1) ) ).

cnf(i_0_549,axiom,
    ( p(X3)
    | esk130_2(X1,X2)
    | ~ esk181_3(X1,X2,X3) ) ).

cnf(i_0_550,axiom,
    ( p(X4)
    | esk233_4(X1,X2,X3,X4)
    | ~ esk182_3(X1,X2,X3) ) ).

cnf(i_0_551,axiom,
    ( ~ esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk405_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_552,axiom,
    ( ~ esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_553,axiom,
    ( ~ esk107_2(X1,X2)
    | p(X2)
    | esk90_1(X1) ) ).

cnf(i_0_554,axiom,
    ( ~ esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk403_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_555,axiom,
    ( esk197_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk231_4(X1,X2,X3,X4) ) ).

cnf(i_0_556,axiom,
    ( ~ esk219_4(X1,X2,X3,X4)
    | esk168_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_557,axiom,
    ( ~ p(X8)
    | ~ esk362_7(X1,X2,X3,X4,X5,X6,X7)
    | esk413_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_558,axiom,
    ( esk379_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_559,axiom,
    ( esk75_1(X1)
    | ~ esk24_0
    | p(X1) ) ).

cnf(i_0_560,axiom,
    ( ~ p(X6)
    | ~ esk314_6(X1,X2,X3,X4,X5,X6)
    | esk263_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_561,axiom,
    ( ~ esk277_5(X1,X2,X3,X4,X5)
    | esk328_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_562,axiom,
    ( ~ esk357_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk391_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_563,axiom,
    ( ~ esk150_2(X1,X2)
    | p(X3)
    | esk167_3(X1,X2,X3) ) ).

cnf(i_0_564,axiom,
    ( esk132_2(X1,X2)
    | p(X3)
    | ~ esk183_3(X1,X2,X3) ) ).

cnf(i_0_565,axiom,
    ( ~ esk36_0
    | ~ p(X1)
    | esk70_1(X1) ) ).

cnf(i_0_566,axiom,
    ( ~ p(X7)
    | esk360_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk309_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_567,axiom,
    ( esk32_0
    | ~ esk83_1(X1)
    | p(X1) ) ).

cnf(i_0_568,axiom,
    ( p(X5)
    | esk251_4(X1,X2,X3,X4)
    | ~ esk268_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_569,axiom,
    ( ~ esk319_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk370_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_570,axiom,
    ( esk410_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk419_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_571,axiom,
    ( esk194_3(X1,X2,X3)
    | ~ esk211_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_572,axiom,
    ( p(X6)
    | esk339_6(X1,X2,X3,X4,X5,X6)
    | ~ esk288_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_573,axiom,
    ( ~ p(X4)
    | esk228_4(X1,X2,X3,X4)
    | ~ esk194_3(X1,X2,X3) ) ).

cnf(i_0_574,axiom,
    ( esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_575,axiom,
    ( ~ esk40_0
    | esk57_1(X1)
    | p(X1) ) ).

cnf(i_0_576,axiom,
    ( esk92_1(X1)
    | ~ p(X2)
    | ~ esk126_2(X1,X2) ) ).

cnf(i_0_577,axiom,
    ( ~ esk264_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk247_4(X1,X2,X3,X4) ) ).

cnf(i_0_578,axiom,
    ( ~ p(X4)
    | ~ esk226_4(X1,X2,X3,X4)
    | esk192_3(X1,X2,X3) ) ).

cnf(i_0_579,axiom,
    ( ~ esk435_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk418_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_580,axiom,
    ( p(X5)
    | ~ esk228_4(X1,X2,X3,X4)
    | esk279_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_581,axiom,
    ( p(X5)
    | esk241_4(X1,X2,X3,X4)
    | ~ esk258_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_582,axiom,
    ( ~ p(X3)
    | esk138_2(X1,X2)
    | ~ esk172_3(X1,X2,X3) ) ).

cnf(i_0_583,axiom,
    ( p(X1)
    | ~ esk38_0
    | esk55_1(X1) ) ).

cnf(i_0_584,axiom,
    ( ~ esk80_1(X1)
    | esk29_0
    | p(X1) ) ).

cnf(i_0_585,axiom,
    ( esk94_1(X1)
    | ~ esk128_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_586,axiom,
    ( esk111_2(X1,X2)
    | ~ p(X3)
    | ~ esk162_3(X1,X2,X3) ) ).

cnf(i_0_587,axiom,
    ( ~ esk160_3(X1,X2,X3)
    | esk109_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_588,axiom,
    ( esk155_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk206_4(X1,X2,X3,X4) ) ).

cnf(i_0_589,axiom,
    ( ~ esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk431_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_590,axiom,
    ( esk106_2(X1,X2)
    | ~ esk55_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_591,axiom,
    ( ~ p(X7)
    | esk314_6(X1,X2,X3,X4,X5,X6)
    | ~ esk365_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_592,axiom,
    ( ~ esk191_3(X1,X2,X3)
    | esk225_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_593,axiom,
    ( ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk423_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_594,axiom,
    ( ~ esk265_5(X1,X2,X3,X4,X5)
    | esk214_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_595,axiom,
    ( p(X3)
    | ~ esk173_3(X1,X2,X3)
    | esk122_2(X1,X2) ) ).

cnf(i_0_596,axiom,
    ( ~ esk418_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk410_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_597,axiom,
    ( esk207_4(X1,X2,X3,X4)
    | ~ esk258_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_598,axiom,
    ( esk64_1(X1)
    | ~ esk47_0
    | p(X1) ) ).

cnf(i_0_599,axiom,
    ( ~ esk270_5(X1,X2,X3,X4,X5)
    | esk219_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_600,axiom,
    ( ~ esk110_2(X1,X2)
    | p(X2)
    | esk93_1(X1) ) ).

cnf(i_0_601,axiom,
    ( esk236_4(X1,X2,X3,X4)
    | ~ esk287_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_602,axiom,
    ( ~ p(X3)
    | esk177_3(X1,X2,X3)
    | ~ esk143_2(X1,X2) ) ).

cnf(i_0_603,axiom,
    ( esk133_2(X1,X2)
    | ~ esk184_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_604,axiom,
    ( ~ p(X6)
    | ~ esk297_5(X1,X2,X3,X4,X5)
    | esk331_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_605,axiom,
    ( esk135_2(X1,X2)
    | ~ esk84_1(X1)
    | p(X2) ) ).

cnf(i_0_606,axiom,
    ( p(X1)
    | esk51_0
    | ~ esk68_1(X1) ) ).

cnf(i_0_607,axiom,
    ( ~ esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_608,axiom,
    ( esk121_2(X1,X2)
    | ~ esk70_1(X1)
    | p(X2) ) ).

cnf(i_0_609,axiom,
    ( esk252_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk286_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_610,axiom,
    ( esk297_5(X1,X2,X3,X4,X5)
    | ~ esk331_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_611,axiom,
    ( esk337_6(X1,X2,X3,X4,X5,X6)
    | ~ esk388_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_612,axiom,
    ( esk67_1(X1)
    | ~ esk118_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_613,axiom,
    ( ~ p(X3)
    | esk151_2(X1,X2)
    | ~ esk185_3(X1,X2,X3) ) ).

cnf(i_0_614,axiom,
    ( p(X4)
    | esk211_4(X1,X2,X3,X4)
    | ~ esk194_3(X1,X2,X3) ) ).

cnf(i_0_615,axiom,
    ( ~ esk77_1(X1)
    | p(X1)
    | esk26_0 ) ).

cnf(i_0_616,axiom,
    ( ~ p(X4)
    | esk193_3(X1,X2,X3)
    | ~ esk227_4(X1,X2,X3,X4) ) ).

cnf(i_0_617,axiom,
    ( ~ esk438_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk412_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_618,axiom,
    ( esk120_2(X1,X2)
    | ~ esk171_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_619,axiom,
    ( ~ p(X7)
    | esk317_6(X1,X2,X3,X4,X5,X6)
    | ~ esk368_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_620,axiom,
    ( ~ esk204_3(X1,X2,X3)
    | esk238_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_621,axiom,
    ( p(X1)
    | esk67_1(X1)
    | ~ esk50_0 ) ).

cnf(i_0_622,axiom,
    ( esk52_1(X1)
    | ~ esk1_0
    | ~ p(X1) ) ).

cnf(i_0_623,axiom,
    ( esk221_4(X1,X2,X3,X4)
    | ~ esk272_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_624,axiom,
    ( esk86_1(X1)
    | ~ p(X2)
    | ~ esk120_2(X1,X2) ) ).

cnf(i_0_625,axiom,
    ( p(X3)
    | esk149_2(X1,X2)
    | ~ esk166_3(X1,X2,X3) ) ).

cnf(i_0_626,axiom,
    ( esk405_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_627,axiom,
    ( ~ p(X7)
    | ~ esk385_7(X1,X2,X3,X4,X5,X6,X7)
    | esk351_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_628,axiom,
    ( esk101_1(X1)
    | p(X2)
    | ~ esk118_2(X1,X2) ) ).

cnf(i_0_629,axiom,
    ( ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk399_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_630,axiom,
    ( esk226_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk175_3(X1,X2,X3) ) ).

cnf(i_0_631,axiom,
    ( ~ esk434_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk383_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_632,axiom,
    ( ~ esk207_4(X1,X2,X3,X4)
    | esk258_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_633,axiom,
    ( ~ esk262_5(X1,X2,X3,X4,X5)
    | esk211_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_634,axiom,
    ( esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk437_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_635,axiom,
    ( ~ p(X1)
    | ~ esk2_0
    | esk53_1(X1) ) ).

cnf(i_0_636,axiom,
    ( ~ esk235_4(X1,X2,X3,X4)
    | esk286_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_637,axiom,
    ( esk190_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk224_4(X1,X2,X3,X4) ) ).

cnf(i_0_638,axiom,
    ( ~ p(X1)
    | esk8_0
    | ~ esk59_1(X1) ) ).

cnf(i_0_639,axiom,
    ( ~ p(X8)
    | esk426_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk392_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_640,axiom,
    ( ~ esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk385_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_641,axiom,
    ( ~ esk339_6(X1,X2,X3,X4,X5,X6)
    | esk288_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_642,axiom,
    ( esk165_3(X1,X2,X3)
    | ~ esk114_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_643,axiom,
    ( ~ p(X8)
    | esk364_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_644,axiom,
    ( esk281_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk247_4(X1,X2,X3,X4) ) ).

cnf(i_0_645,axiom,
    ( ~ esk96_1(X1)
    | p(X2)
    | esk113_2(X1,X2) ) ).

cnf(i_0_646,axiom,
    ( ~ esk431_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk440_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk432_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_647,axiom,
    ( ~ esk288_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk254_4(X1,X2,X3,X4) ) ).

cnf(i_0_648,axiom,
    ( esk279_5(X1,X2,X3,X4,X5)
    | ~ esk330_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_649,axiom,
    ( esk356_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk373_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_650,axiom,
    ( p(X7)
    | ~ esk365_7(X1,X2,X3,X4,X5,X6,X7)
    | esk348_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_651,axiom,
    ( p(X7)
    | ~ esk383_7(X1,X2,X3,X4,X5,X6,X7)
    | esk332_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_652,axiom,
    ( esk133_2(X1,X2)
    | ~ p(X2)
    | ~ esk99_1(X1) ) ).

cnf(i_0_653,axiom,
    ( esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk419_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk410_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_654,axiom,
    ( esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk425_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_655,axiom,
    ( ~ esk193_3(X1,X2,X3)
    | esk210_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_656,axiom,
    ( ~ esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk417_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_657,axiom,
    ( p(X3)
    | esk147_2(X1,X2)
    | ~ esk164_3(X1,X2,X3) ) ).

cnf(i_0_658,axiom,
    ( esk307_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk256_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_659,axiom,
    ( esk262_5(X1,X2,X3,X4,X5)
    | ~ esk245_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_660,axiom,
    ( ~ esk16_0
    | esk67_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_661,axiom,
    ( p(X4)
    | ~ esk221_4(X1,X2,X3,X4)
    | esk204_3(X1,X2,X3) ) ).

cnf(i_0_662,axiom,
    ( ~ esk440_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk423_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_663,axiom,
    ( ~ esk28_0
    | esk79_1(X1)
    | p(X1) ) ).

cnf(i_0_664,axiom,
    ( esk275_5(X1,X2,X3,X4,X5)
    | ~ esk326_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_665,axiom,
    ( esk380_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk346_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_666,axiom,
    ( ~ p(X8)
    | ~ esk402_7(X1,X2,X3,X4,X5,X6,X7)
    | esk436_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_667,axiom,
    ( esk310_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk293_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_668,axiom,
    ( ~ p(X4)
    | esk195_3(X1,X2,X3)
    | ~ esk229_4(X1,X2,X3,X4) ) ).

cnf(i_0_669,axiom,
    ( esk287_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk253_4(X1,X2,X3,X4) ) ).

cnf(i_0_670,axiom,
    ( esk77_1(X1)
    | ~ esk128_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_671,axiom,
    ( ~ p(X5)
    | esk257_5(X1,X2,X3,X4,X5)
    | ~ esk206_4(X1,X2,X3,X4) ) ).

cnf(i_0_672,axiom,
    ( esk211_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk160_3(X1,X2,X3) ) ).

cnf(i_0_673,axiom,
    ( p(X2)
    | esk114_2(X1,X2)
    | ~ esk97_1(X1) ) ).

cnf(i_0_674,axiom,
    ( ~ esk4_0
    | esk55_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_675,axiom,
    ( ~ esk317_6(X1,X2,X3,X4,X5,X6)
    | esk300_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_676,axiom,
    ( ~ esk169_3(X1,X2,X3)
    | ~ p(X3)
    | esk118_2(X1,X2) ) ).

cnf(i_0_677,axiom,
    ( ~ esk260_5(X1,X2,X3,X4,X5)
    | esk311_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_678,axiom,
    ( ~ p(X6)
    | esk294_5(X1,X2,X3,X4,X5)
    | ~ esk328_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_679,axiom,
    ( esk295_5(X1,X2,X3,X4,X5)
    | ~ esk312_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_680,axiom,
    ( ~ p(X8)
    | esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk405_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_681,axiom,
    ( p(X4)
    | esk236_4(X1,X2,X3,X4)
    | ~ esk185_3(X1,X2,X3) ) ).

cnf(i_0_682,axiom,
    ~ esk16_0 ).

cnf(i_0_683,axiom,
    ( ~ esk221_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk272_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_684,axiom,
    ( p(X3)
    | esk173_3(X1,X2,X3)
    | ~ esk122_2(X1,X2) ) ).

cnf(i_0_685,axiom,
    ( ~ p(X2)
    | esk125_2(X1,X2)
    | ~ esk91_1(X1) ) ).

cnf(i_0_686,axiom,
    ( ~ esk311_6(X1,X2,X3,X4,X5,X6)
    | esk260_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_687,axiom,
    ( esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk370_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_688,axiom,
    ( ~ esk169_3(X1,X2,X3)
    | ~ p(X4)
    | esk220_4(X1,X2,X3,X4) ) ).

cnf(i_0_689,axiom,
    ( ~ p(X2)
    | esk68_1(X1)
    | ~ esk119_2(X1,X2) ) ).

cnf(i_0_690,axiom,
    ( ~ p(X7)
    | ~ esk321_6(X1,X2,X3,X4,X5,X6)
    | esk372_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_691,axiom,
    ( p(X7)
    | ~ esk378_7(X1,X2,X3,X4,X5,X6,X7)
    | esk327_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_692,axiom,
    ( ~ esk222_4(X1,X2,X3,X4)
    | esk171_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_693,axiom,
    ( ~ p(X3)
    | esk182_3(X1,X2,X3)
    | ~ esk148_2(X1,X2) ) ).

cnf(i_0_694,axiom,
    ( ~ esk76_1(X1)
    | esk25_0
    | p(X1) ) ).

cnf(i_0_695,axiom,
    ( ~ p(X5)
    | ~ esk284_5(X1,X2,X3,X4,X5)
    | esk250_4(X1,X2,X3,X4) ) ).

cnf(i_0_696,axiom,
    ( ~ esk205_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk256_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_697,axiom,
    ( ~ esk386_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk335_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_698,axiom,
    ( ~ esk101_1(X1)
    | esk118_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_699,axiom,
    ( ~ esk78_1(X1)
    | esk27_0
    | p(X1) ) ).

cnf(i_0_700,axiom,
    ( ~ esk259_5(X1,X2,X3,X4,X5)
    | esk208_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_701,axiom,
    ( ~ esk268_5(X1,X2,X3,X4,X5)
    | esk217_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_702,axiom,
    ( esk415_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk423_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_703,axiom,
    ( esk378_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk327_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_704,axiom,
    ( esk111_2(X1,X2)
    | ~ esk94_1(X1)
    | p(X2) ) ).

cnf(i_0_705,axiom,
    ( ~ p(X8)
    | esk394_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk428_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_706,axiom,
    ( ~ esk253_4(X1,X2,X3,X4)
    | p(X5)
    | esk270_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_707,axiom,
    ( p(X7)
    | ~ esk342_6(X1,X2,X3,X4,X5,X6)
    | esk359_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_708,axiom,
    ( esk23_0
    | ~ esk74_1(X1)
    | p(X1) ) ).

cnf(i_0_709,axiom,
    ( ~ p(X7)
    | esk311_6(X1,X2,X3,X4,X5,X6)
    | ~ esk362_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_710,axiom,
    ( esk248_4(X1,X2,X3,X4)
    | ~ esk265_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_711,axiom,
    ( ~ esk133_2(X1,X2)
    | ~ p(X2)
    | esk99_1(X1) ) ).

cnf(i_0_712,axiom,
    ( esk103_2(X1,X2)
    | p(X2)
    | ~ esk86_1(X1) ) ).

cnf(i_0_713,axiom,
    ( esk230_4(X1,X2,X3,X4)
    | ~ esk179_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_714,axiom,
    ( ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk424_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_715,axiom,
    ( p(X2)
    | esk116_2(X1,X2)
    | ~ esk99_1(X1) ) ).

cnf(i_0_716,axiom,
    ( p(X8)
    | ~ esk423_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk406_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_717,axiom,
    ( esk101_1(X1)
    | ~ esk135_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_718,axiom,
    ( esk5_0
    | ~ esk56_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_719,axiom,
    ( p(X4)
    | ~ esk192_3(X1,X2,X3)
    | esk209_4(X1,X2,X3,X4) ) ).

cnf(i_0_720,axiom,
    ( esk219_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk168_3(X1,X2,X3) ) ).

cnf(i_0_721,axiom,
    ( ~ p(X6)
    | ~ esk262_5(X1,X2,X3,X4,X5)
    | esk313_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_722,axiom,
    ( p(X6)
    | ~ esk291_5(X1,X2,X3,X4,X5)
    | esk308_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_723,axiom,
    ( ~ esk269_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk218_4(X1,X2,X3,X4) ) ).

cnf(i_0_724,axiom,
    ( ~ esk310_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk259_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_725,axiom,
    ( esk166_3(X1,X2,X3)
    | p(X3)
    | ~ esk149_2(X1,X2) ) ).

cnf(i_0_726,axiom,
    ( ~ esk368_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk419_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_727,axiom,
    ( ~ esk417_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk416_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_728,axiom,
    ( esk336_6(X1,X2,X3,X4,X5,X6)
    | ~ esk387_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_729,axiom,
    ( ~ p(X1)
    | ~ esk83_1(X1)
    | esk49_0 ) ).

cnf(i_0_730,axiom,
    ( ~ p(X3)
    | esk156_3(X1,X2,X3)
    | ~ esk105_2(X1,X2) ) ).

cnf(i_0_731,axiom,
    ~ esk13_0 ).

cnf(i_0_732,axiom,
    ( ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk413_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_733,axiom,
    ( p(X2)
    | ~ esk121_2(X1,X2)
    | esk70_1(X1) ) ).

cnf(i_0_734,axiom,
    ( ~ esk125_2(X1,X2)
    | p(X3)
    | esk176_3(X1,X2,X3) ) ).

cnf(i_0_735,axiom,
    ( ~ esk79_1(X1)
    | esk28_0
    | p(X1) ) ).

cnf(i_0_736,axiom,
    ( ~ esk360_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk309_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_737,axiom,
    ( esk178_3(X1,X2,X3)
    | ~ esk144_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_738,axiom,
    ( esk384_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk435_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_739,axiom,
    ( esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk424_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_740,axiom,
    ( ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk419_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_741,axiom,
    ( ~ esk380_7(X1,X2,X3,X4,X5,X6,X7)
    | esk329_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_742,axiom,
    ( p(X8)
    | esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk378_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_743,axiom,
    ( ~ esk355_6(X1,X2,X3,X4,X5,X6)
    | esk372_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_744,axiom,
    ( esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk390_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_745,axiom,
    ( ~ esk44_0
    | p(X1)
    | esk61_1(X1) ) ).

cnf(i_0_746,axiom,
    ( ~ p(X6)
    | esk257_5(X1,X2,X3,X4,X5)
    | ~ esk308_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_747,axiom,
    ( ~ p(X2)
    | esk61_1(X1)
    | ~ esk112_2(X1,X2) ) ).

cnf(i_0_748,axiom,
    ( esk45_0
    | ~ esk62_1(X1)
    | p(X1) ) ).

cnf(i_0_749,axiom,
    ( esk180_3(X1,X2,X3)
    | p(X4)
    | ~ esk231_4(X1,X2,X3,X4) ) ).

cnf(i_0_750,axiom,
    ( esk329_6(X1,X2,X3,X4,X5,X6)
    | ~ esk278_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_751,axiom,
    ( esk116_2(X1,X2)
    | ~ esk65_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_752,axiom,
    ( p(X5)
    | esk228_4(X1,X2,X3,X4)
    | ~ esk279_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_753,axiom,
    ( ~ esk205_4(X1,X2,X3,X4)
    | esk188_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_754,axiom,
    ( esk272_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk255_4(X1,X2,X3,X4) ) ).

cnf(i_0_755,axiom,
    ( esk417_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk426_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk409_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_756,axiom,
    ( ~ esk165_3(X1,X2,X3)
    | esk148_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_757,axiom,
    ( ~ esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk408_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_758,axiom,
    ( ~ esk22_0
    | p(X1)
    | esk73_1(X1) ) ).

cnf(i_0_759,axiom,
    ( esk50_0
    | ~ esk67_1(X1)
    | p(X1) ) ).

cnf(i_0_760,axiom,
    ( ~ esk267_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk216_4(X1,X2,X3,X4) ) ).

cnf(i_0_761,axiom,
    ( p(X8)
    | ~ esk417_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk400_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_762,axiom,
    ( esk87_1(X1)
    | ~ p(X2)
    | ~ esk121_2(X1,X2) ) ).

cnf(i_0_763,axiom,
    ( ~ p(X1)
    | ~ esk70_1(X1)
    | esk36_0 ) ).

cnf(i_0_764,axiom,
    ( ~ esk21_0
    | p(X1)
    | esk72_1(X1) ) ).

cnf(i_0_765,axiom,
    ( ~ esk122_2(X1,X2)
    | esk88_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_766,axiom,
    ( p(X5)
    | esk240_4(X1,X2,X3,X4)
    | ~ esk257_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_767,axiom,
    ( esk166_3(X1,X2,X3)
    | ~ esk115_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_768,axiom,
    ( ~ esk165_3(X1,X2,X3)
    | ~ p(X4)
    | esk216_4(X1,X2,X3,X4) ) ).

cnf(i_0_769,axiom,
    ( ~ esk274_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk325_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_770,axiom,
    ( ~ p(X6)
    | esk298_5(X1,X2,X3,X4,X5)
    | ~ esk332_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_771,axiom,
    ( p(X7)
    | ~ esk356_6(X1,X2,X3,X4,X5,X6)
    | esk373_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_772,axiom,
    ( esk122_2(X1,X2)
    | ~ esk71_1(X1)
    | p(X2) ) ).

cnf(i_0_773,axiom,
    ( p(X4)
    | esk179_3(X1,X2,X3)
    | ~ esk230_4(X1,X2,X3,X4) ) ).

cnf(i_0_774,axiom,
    ( ~ esk431_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk380_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_775,axiom,
    ( ~ p(X8)
    | esk437_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk403_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_776,axiom,
    ( ~ esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk424_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_777,axiom,
    ( ~ p(X4)
    | ~ esk214_4(X1,X2,X3,X4)
    | esk163_3(X1,X2,X3) ) ).

cnf(i_0_778,axiom,
    ( ~ esk363_7(X1,X2,X3,X4,X5,X6,X7)
    | esk346_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_779,axiom,
    ( ~ esk422_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk371_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_780,axiom,
    ( ~ esk289_5(X1,X2,X3,X4,X5)
    | esk238_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_781,axiom,
    ( ~ esk190_3(X1,X2,X3)
    | esk224_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_782,axiom,
    ( ~ p(X6)
    | esk292_5(X1,X2,X3,X4,X5)
    | ~ esk326_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_783,axiom,
    ( esk80_1(X1)
    | p(X1)
    | ~ esk29_0 ) ).

cnf(i_0_784,axiom,
    ( ~ p(X5)
    | esk206_4(X1,X2,X3,X4)
    | ~ esk257_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_785,axiom,
    ( esk270_5(X1,X2,X3,X4,X5)
    | ~ esk219_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_786,axiom,
    ( ~ esk399_7(X1,X2,X3,X4,X5,X6,X7)
    | esk433_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_787,axiom,
    ( esk276_5(X1,X2,X3,X4,X5)
    | ~ esk225_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_788,axiom,
    ( ~ p(X6)
    | ~ esk263_5(X1,X2,X3,X4,X5)
    | esk314_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_789,axiom,
    ( ~ p(X4)
    | ~ esk223_4(X1,X2,X3,X4)
    | esk189_3(X1,X2,X3) ) ).

cnf(i_0_790,axiom,
    ( esk222_4(X1,X2,X3,X4)
    | ~ esk188_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_791,axiom,
    ( ~ esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk391_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_792,axiom,
    ( esk105_2(X1,X2)
    | ~ esk88_1(X1)
    | p(X2) ) ).

cnf(i_0_793,axiom,
    ( ~ esk369_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk318_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_794,axiom,
    ( p(X8)
    | esk387_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_795,axiom,
    ( ~ esk285_5(X1,X2,X3,X4,X5)
    | esk234_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_796,axiom,
    ( ~ esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk412_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_797,axiom,
    ( esk107_2(X1,X2)
    | ~ esk56_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_798,axiom,
    ( p(X2)
    | ~ esk90_1(X1)
    | esk107_2(X1,X2) ) ).

cnf(i_0_799,axiom,
    ( ~ esk302_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk319_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_800,axiom,
    ( esk186_3(X1,X2,X3)
    | ~ p(X3)
    | ~ esk152_2(X1,X2) ) ).

cnf(i_0_801,axiom,
    ( ~ esk407_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk441_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_802,axiom,
    ( ~ esk432_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk433_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk441_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_803,axiom,
    ( ~ p(X8)
    | ~ esk372_7(X1,X2,X3,X4,X5,X6,X7)
    | esk423_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_804,axiom,
    ( ~ esk187_3(X1,X2,X3)
    | p(X3)
    | esk136_2(X1,X2) ) ).

cnf(i_0_805,axiom,
    ( ~ esk100_1(X1)
    | p(X2)
    | esk117_2(X1,X2) ) ).

cnf(i_0_806,axiom,
    ( esk170_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk221_4(X1,X2,X3,X4) ) ).

cnf(i_0_807,axiom,
    ( esk169_3(X1,X2,X3)
    | p(X3)
    | ~ esk152_2(X1,X2) ) ).

cnf(i_0_808,axiom,
    ( ~ esk96_1(X1)
    | ~ p(X2)
    | esk130_2(X1,X2) ) ).

cnf(i_0_809,axiom,
    ( esk370_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_810,axiom,
    ( ~ esk296_5(X1,X2,X3,X4,X5)
    | esk313_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_811,axiom,
    ( esk428_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk429_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_812,axiom,
    ( ~ p(X2)
    | ~ esk105_2(X1,X2)
    | esk54_1(X1) ) ).

cnf(i_0_813,axiom,
    ( p(X1)
    | ~ esk49_0
    | esk66_1(X1) ) ).

cnf(i_0_814,axiom,
    ( ~ esk334_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk300_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_815,axiom,
    ( ~ p(X1)
    | esk71_1(X1)
    | ~ esk37_0 ) ).

cnf(i_0_816,axiom,
    ( p(X8)
    | esk377_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk428_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_817,axiom,
    ( ~ esk335_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk284_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_818,axiom,
    ( ~ esk289_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk340_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_819,axiom,
    ( esk33_0
    | p(X1)
    | ~ esk84_1(X1) ) ).

cnf(i_0_820,axiom,
    ( esk266_5(X1,X2,X3,X4,X5)
    | ~ esk317_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_821,axiom,
    ( ~ esk356_6(X1,X2,X3,X4,X5,X6)
    | esk390_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_822,axiom,
    ( p(X6)
    | ~ esk310_6(X1,X2,X3,X4,X5,X6)
    | esk293_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_823,axiom,
    ( esk375_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk426_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_824,axiom,
    ( esk387_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk336_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_825,axiom,
    ( p(X3)
    | ~ esk163_3(X1,X2,X3)
    | esk146_2(X1,X2) ) ).

cnf(i_0_826,axiom,
    ( ~ p(X1)
    | esk17_0
    | ~ esk68_1(X1) ) ).

cnf(i_0_827,axiom,
    ( ~ p(X6)
    | esk262_5(X1,X2,X3,X4,X5)
    | ~ esk313_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_828,axiom,
    ( esk124_2(X1,X2)
    | p(X2)
    | ~ esk73_1(X1) ) ).

cnf(i_0_829,axiom,
    ( ~ p(X1)
    | esk44_0
    | ~ esk78_1(X1) ) ).

cnf(i_0_830,axiom,
    ( ~ esk196_3(X1,X2,X3)
    | ~ p(X4)
    | esk230_4(X1,X2,X3,X4) ) ).

cnf(i_0_831,axiom,
    ( esk161_3(X1,X2,X3)
    | p(X3)
    | ~ esk144_2(X1,X2) ) ).

cnf(i_0_832,axiom,
    ( esk272_5(X1,X2,X3,X4,X5)
    | ~ esk323_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_833,axiom,
    ( ~ esk314_6(X1,X2,X3,X4,X5,X6)
    | esk365_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_834,axiom,
    ( ~ esk90_1(X1)
    | esk124_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_835,axiom,
    ( esk99_1(X1)
    | ~ esk116_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_836,axiom,
    ( ~ esk275_5(X1,X2,X3,X4,X5)
    | esk241_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_837,axiom,
    ( ~ esk299_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk316_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_838,axiom,
    ( ~ esk376_7(X1,X2,X3,X4,X5,X6,X7)
    | esk325_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_839,axiom,
    ( esk158_3(X1,X2,X3)
    | ~ esk107_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_840,axiom,
    ( ~ p(X8)
    | esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk408_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_841,axiom,
    ( p(X5)
    | ~ esk274_5(X1,X2,X3,X4,X5)
    | esk223_4(X1,X2,X3,X4) ) ).

cnf(i_0_842,axiom,
    ( esk384_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk350_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_843,axiom,
    ( p(X2)
    | esk123_2(X1,X2)
    | ~ esk72_1(X1) ) ).

cnf(i_0_844,axiom,
    ( ~ esk52_1(X1)
    | ~ p(X2)
    | esk103_2(X1,X2) ) ).

cnf(i_0_845,axiom,
    ( ~ p(X7)
    | esk377_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk343_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_846,axiom,
    ( ~ esk161_3(X1,X2,X3)
    | esk110_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_847,axiom,
    ( esk171_3(X1,X2,X3)
    | ~ esk120_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_848,axiom,
    ( ~ esk336_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk285_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_849,axiom,
    ( p(X3)
    | esk154_3(X1,X2,X3)
    | ~ esk137_2(X1,X2) ) ).

cnf(i_0_850,axiom,
    ( esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk431_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_851,axiom,
    ( ~ p(X4)
    | ~ esk234_4(X1,X2,X3,X4)
    | esk200_3(X1,X2,X3) ) ).

cnf(i_0_852,axiom,
    ( ~ p(X8)
    | esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk363_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_853,axiom,
    ( esk426_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk375_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_854,axiom,
    ( p(X3)
    | esk175_3(X1,X2,X3)
    | ~ esk124_2(X1,X2) ) ).

cnf(i_0_855,axiom,
    ( ~ esk6_0
    | esk57_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_856,axiom,
    ( ~ esk399_7(X1,X2,X3,X4,X5,X6,X7)
    | esk416_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_857,axiom,
    ( p(X3)
    | esk125_2(X1,X2)
    | ~ esk176_3(X1,X2,X3) ) ).

cnf(i_0_858,axiom,
    ( ~ esk272_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk323_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_859,axiom,
    ( ~ esk410_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk359_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_860,axiom,
    ( ~ esk380_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk431_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_861,axiom,
    ( ~ esk236_4(X1,X2,X3,X4)
    | esk185_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_862,axiom,
    ( esk104_2(X1,X2)
    | ~ esk87_1(X1)
    | p(X2) ) ).

cnf(i_0_863,axiom,
    ( ~ esk228_4(X1,X2,X3,X4)
    | esk177_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_864,axiom,
    ( ~ esk223_4(X1,X2,X3,X4)
    | esk172_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_865,axiom,
    ( ~ esk111_2(X1,X2)
    | p(X2)
    | esk94_1(X1) ) ).

cnf(i_0_866,axiom,
    ( esk289_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk238_4(X1,X2,X3,X4) ) ).

cnf(i_0_867,axiom,
    ( esk150_2(X1,X2)
    | p(X3)
    | ~ esk167_3(X1,X2,X3) ) ).

cnf(i_0_868,axiom,
    ( ~ p(X3)
    | ~ esk170_3(X1,X2,X3)
    | esk119_2(X1,X2) ) ).

cnf(i_0_869,axiom,
    ( ~ esk216_4(X1,X2,X3,X4)
    | esk199_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_870,axiom,
    ( ~ esk319_6(X1,X2,X3,X4,X5,X6)
    | esk302_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_871,axiom,
    ( ~ esk374_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk323_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_872,axiom,
    ( ~ esk367_7(X1,X2,X3,X4,X5,X6,X7)
    | esk316_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_873,axiom,
    ( ~ p(X1)
    | esk1_0
    | ~ esk52_1(X1) ) ).

cnf(i_0_874,axiom,
    ( ~ esk184_3(X1,X2,X3)
    | ~ p(X3)
    | esk150_2(X1,X2) ) ).

cnf(i_0_875,axiom,
    ( ~ esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk397_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_876,axiom,
    ( p(X2)
    | esk134_2(X1,X2)
    | ~ esk83_1(X1) ) ).

cnf(i_0_877,axiom,
    ( esk170_3(X1,X2,X3)
    | ~ esk153_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_878,axiom,
    ( p(X3)
    | esk186_3(X1,X2,X3)
    | ~ esk135_2(X1,X2) ) ).

cnf(i_0_879,axiom,
    ( p(X3)
    | ~ esk136_2(X1,X2)
    | esk187_3(X1,X2,X3) ) ).

cnf(i_0_880,axiom,
    ( p(X2)
    | ~ esk79_1(X1)
    | esk130_2(X1,X2) ) ).

cnf(i_0_881,axiom,
    ( ~ esk427_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk435_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_882,axiom,
    ( esk15_0
    | ~ esk66_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_883,axiom,
    ( ~ esk182_3(X1,X2,X3)
    | ~ p(X3)
    | esk148_2(X1,X2) ) ).

cnf(i_0_884,axiom,
    ( ~ p(X2)
    | esk110_2(X1,X2)
    | ~ esk59_1(X1) ) ).

cnf(i_0_885,axiom,
    ( ~ esk127_2(X1,X2)
    | esk93_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_886,axiom,
    ( ~ esk189_3(X1,X2,X3)
    | p(X4)
    | esk206_4(X1,X2,X3,X4) ) ).

cnf(i_0_887,axiom,
    ( ~ esk265_5(X1,X2,X3,X4,X5)
    | esk316_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_888,axiom,
    ( ~ esk419_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk402_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_889,axiom,
    ( ~ esk11_0
    | esk62_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_890,axiom,
    ( ~ p(X4)
    | esk205_4(X1,X2,X3,X4)
    | ~ esk154_3(X1,X2,X3) ) ).

cnf(i_0_891,axiom,
    ( esk153_2(X1,X2)
    | p(X3)
    | ~ esk170_3(X1,X2,X3) ) ).

cnf(i_0_892,axiom,
    ( p(X7)
    | esk333_6(X1,X2,X3,X4,X5,X6)
    | ~ esk384_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_893,axiom,
    ( esk215_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk164_3(X1,X2,X3) ) ).

cnf(i_0_894,axiom,
    ( ~ esk230_4(X1,X2,X3,X4)
    | p(X5)
    | esk281_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_895,axiom,
    ( esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_896,axiom,
    ( esk286_5(X1,X2,X3,X4,X5)
    | ~ esk252_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_897,axiom,
    ( esk164_3(X1,X2,X3)
    | ~ esk113_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_898,axiom,
    ( p(X4)
    | ~ esk181_3(X1,X2,X3)
    | esk232_4(X1,X2,X3,X4) ) ).

cnf(i_0_899,axiom,
    ( ~ esk280_5(X1,X2,X3,X4,X5)
    | esk246_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_900,axiom,
    ( ~ esk222_4(X1,X2,X3,X4)
    | esk188_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_901,axiom,
    ( ~ esk317_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk368_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_902,axiom,
    ( ~ esk217_4(X1,X2,X3,X4)
    | p(X4)
    | esk200_3(X1,X2,X3) ) ).

cnf(i_0_903,axiom,
    ( esk419_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk402_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_904,axiom,
    ( esk13_0
    | ~ esk64_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_905,axiom,
    ( ~ esk382_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk433_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_906,axiom,
    ( esk332_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk298_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_907,axiom,
    ( p(X3)
    | ~ esk177_3(X1,X2,X3)
    | esk126_2(X1,X2) ) ).

cnf(i_0_908,axiom,
    ( p(X1)
    | ~ esk69_1(X1)
    | esk18_0 ) ).

cnf(i_0_909,axiom,
    ( esk409_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk358_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_910,axiom,
    ( p(X5)
    | esk278_5(X1,X2,X3,X4,X5)
    | ~ esk227_4(X1,X2,X3,X4) ) ).

cnf(i_0_911,axiom,
    ( ~ p(X2)
    | ~ esk58_1(X1)
    | esk109_2(X1,X2) ) ).

cnf(i_0_912,axiom,
    ( esk334_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk300_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_913,axiom,
    ( ~ esk163_3(X1,X2,X3)
    | ~ p(X4)
    | esk214_4(X1,X2,X3,X4) ) ).

cnf(i_0_914,axiom,
    ( ~ p(X4)
    | esk209_4(X1,X2,X3,X4)
    | ~ esk158_3(X1,X2,X3) ) ).

cnf(i_0_915,axiom,
    ~ esk10_0 ).

cnf(i_0_916,axiom,
    ( esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk394_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_917,axiom,
    ( esk6_0
    | ~ p(X1)
    | ~ esk57_1(X1) ) ).

cnf(i_0_918,axiom,
    ( ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk421_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_919,axiom,
    ( esk331_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk280_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_920,axiom,
    ( ~ esk69_1(X1)
    | esk35_0
    | ~ p(X1) ) ).

cnf(i_0_921,axiom,
    ( esk78_1(X1)
    | ~ esk44_0
    | ~ p(X1) ) ).

cnf(i_0_922,axiom,
    ( p(X2)
    | ~ esk115_2(X1,X2)
    | esk98_1(X1) ) ).

cnf(i_0_923,axiom,
    ( ~ esk228_4(X1,X2,X3,X4)
    | esk194_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_924,axiom,
    ( esk419_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk410_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_925,axiom,
    ( esk435_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk418_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_926,axiom,
    ( ~ p(X6)
    | ~ esk299_5(X1,X2,X3,X4,X5)
    | esk333_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_927,axiom,
    ( p(X3)
    | esk142_2(X1,X2)
    | ~ esk159_3(X1,X2,X3) ) ).

cnf(i_0_928,axiom,
    ( ~ esk374_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk357_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_929,axiom,
    ( esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk437_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_930,axiom,
    ( ~ esk373_7(X1,X2,X3,X4,X5,X6,X7)
    | esk322_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_931,axiom,
    ( esk137_2(X1,X2)
    | p(X3)
    | ~ esk154_3(X1,X2,X3) ) ).

cnf(i_0_932,axiom,
    ( esk268_5(X1,X2,X3,X4,X5)
    | ~ esk251_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_933,axiom,
    ( esk334_6(X1,X2,X3,X4,X5,X6)
    | ~ esk283_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_934,axiom,
    ( esk63_1(X1)
    | ~ esk12_0
    | ~ p(X1) ) ).

cnf(i_0_935,axiom,
    ( p(X6)
    | ~ esk301_5(X1,X2,X3,X4,X5)
    | esk318_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_936,axiom,
    ( ~ p(X4)
    | esk217_4(X1,X2,X3,X4)
    | ~ esk166_3(X1,X2,X3) ) ).

cnf(i_0_937,axiom,
    ( p(X5)
    | esk287_5(X1,X2,X3,X4,X5)
    | ~ esk236_4(X1,X2,X3,X4) ) ).

cnf(i_0_938,axiom,
    ( esk434_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk383_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_939,axiom,
    ( ~ esk292_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk326_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_940,axiom,
    ( ~ p(X8)
    | ~ esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk402_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_941,axiom,
    ( esk218_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk201_3(X1,X2,X3) ) ).

cnf(i_0_942,axiom,
    ( esk250_4(X1,X2,X3,X4)
    | ~ esk267_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_943,axiom,
    ( esk52_1(X1)
    | ~ esk103_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_944,axiom,
    ( ~ esk222_4(X1,X2,X3,X4)
    | p(X5)
    | esk273_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_945,axiom,
    ( p(X5)
    | ~ esk259_5(X1,X2,X3,X4,X5)
    | esk242_4(X1,X2,X3,X4) ) ).

cnf(i_0_946,axiom,
    ( ~ esk65_1(X1)
    | esk48_0
    | p(X1) ) ).

cnf(i_0_947,axiom,
    ( ~ p(X2)
    | esk59_1(X1)
    | ~ esk110_2(X1,X2) ) ).

cnf(i_0_948,axiom,
    ( ~ esk433_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk434_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk442_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_949,axiom,
    ( ~ esk260_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk243_4(X1,X2,X3,X4) ) ).

cnf(i_0_950,axiom,
    ( esk258_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk241_4(X1,X2,X3,X4) ) ).

cnf(i_0_951,axiom,
    ( esk265_5(X1,X2,X3,X4,X5)
    | ~ esk214_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_952,axiom,
    ( esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk417_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_953,axiom,
    ( esk398_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_954,axiom,
    ( esk366_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk315_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_955,axiom,
    ( ~ esk202_3(X1,X2,X3)
    | ~ p(X4)
    | esk236_4(X1,X2,X3,X4) ) ).

cnf(i_0_956,axiom,
    ( ~ esk261_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk244_4(X1,X2,X3,X4) ) ).

cnf(i_0_957,axiom,
    ( p(X2)
    | ~ esk93_1(X1)
    | esk110_2(X1,X2) ) ).

cnf(i_0_958,axiom,
    ( ~ p(X5)
    | ~ esk250_4(X1,X2,X3,X4)
    | esk284_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_959,axiom,
    ( ~ esk310_6(X1,X2,X3,X4,X5,X6)
    | esk361_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_960,axiom,
    ( ~ esk145_2(X1,X2)
    | ~ p(X3)
    | esk179_3(X1,X2,X3) ) ).

cnf(i_0_961,axiom,
    ( esk430_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk431_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_962,axiom,
    ( p(X5)
    | ~ esk250_4(X1,X2,X3,X4)
    | esk267_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_963,axiom,
    ( esk30_0
    | p(X1)
    | ~ esk81_1(X1) ) ).

cnf(i_0_964,axiom,
    ( p(X7)
    | esk350_6(X1,X2,X3,X4,X5,X6)
    | ~ esk367_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_965,axiom,
    ( esk138_2(X1,X2)
    | ~ esk155_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_966,axiom,
    ( esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk397_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_967,axiom,
    ( ~ esk220_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk271_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_968,axiom,
    ( ~ p(X5)
    | ~ esk283_5(X1,X2,X3,X4,X5)
    | esk249_4(X1,X2,X3,X4) ) ).

cnf(i_0_969,axiom,
    ( esk122_2(X1,X2)
    | ~ esk88_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_970,axiom,
    ( ~ esk429_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk437_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_971,axiom,
    ( p(X8)
    | ~ esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk390_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_972,axiom,
    ( ~ esk70_1(X1)
    | esk19_0
    | p(X1) ) ).

cnf(i_0_973,axiom,
    ( esk321_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk304_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_974,axiom,
    ( esk264_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk247_4(X1,X2,X3,X4) ) ).

cnf(i_0_975,axiom,
    ( p(X4)
    | esk213_4(X1,X2,X3,X4)
    | ~ esk196_3(X1,X2,X3) ) ).

cnf(i_0_976,axiom,
    ( ~ esk292_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk309_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_977,axiom,
    ( esk359_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk308_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_978,axiom,
    ( esk279_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk245_4(X1,X2,X3,X4) ) ).

cnf(i_0_979,axiom,
    ( esk4_0
    | ~ p(X1)
    | ~ esk55_1(X1) ) ).

cnf(i_0_980,axiom,
    ( ~ esk435_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk401_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_981,axiom,
    ( ~ esk111_2(X1,X2)
    | ~ p(X3)
    | esk162_3(X1,X2,X3) ) ).

cnf(i_0_982,axiom,
    ( p(X7)
    | esk369_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk352_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_983,axiom,
    ( ~ esk441_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk407_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_984,axiom,
    ( esk106_2(X1,X2)
    | ~ esk89_1(X1)
    | p(X2) ) ).

cnf(i_0_985,axiom,
    ( esk314_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk297_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_986,axiom,
    ( ~ p(X7)
    | esk319_6(X1,X2,X3,X4,X5,X6)
    | ~ esk370_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_987,axiom,
    ( ~ esk181_3(X1,X2,X3)
    | esk147_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_988,axiom,
    ( esk326_6(X1,X2,X3,X4,X5,X6)
    | ~ esk275_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_989,axiom,
    ( esk303_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk320_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_990,axiom,
    ( ~ esk79_1(X1)
    | ~ p(X1)
    | esk45_0 ) ).

cnf(i_0_991,axiom,
    ( ~ esk60_1(X1)
    | p(X1)
    | esk43_0 ) ).

cnf(i_0_992,axiom,
    ( p(X3)
    | ~ esk132_2(X1,X2)
    | esk183_3(X1,X2,X3) ) ).

cnf(i_0_993,axiom,
    ( ~ esk108_2(X1,X2)
    | esk159_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_994,axiom,
    ( p(X3)
    | ~ esk186_3(X1,X2,X3)
    | esk135_2(X1,X2) ) ).

cnf(i_0_995,axiom,
    ( ~ esk431_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk397_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_996,axiom,
    ( ~ esk57_1(X1)
    | ~ p(X2)
    | esk108_2(X1,X2) ) ).

cnf(i_0_997,axiom,
    ( esk289_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk255_4(X1,X2,X3,X4) ) ).

cnf(i_0_998,axiom,
    ( ~ esk333_6(X1,X2,X3,X4,X5,X6)
    | esk282_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_999,axiom,
    ( ~ esk246_4(X1,X2,X3,X4)
    | p(X5)
    | esk263_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1000,axiom,
    ( ~ esk433_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk399_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1001,axiom,
    ( ~ esk391_7(X1,X2,X3,X4,X5,X6,X7)
    | esk340_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1002,axiom,
    ( ~ p(X6)
    | esk261_5(X1,X2,X3,X4,X5)
    | ~ esk312_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1003,axiom,
    ( esk151_2(X1,X2)
    | ~ esk168_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_1004,axiom,
    ( ~ p(X1)
    | ~ esk65_1(X1)
    | esk14_0 ) ).

cnf(i_0_1005,axiom,
    ( ~ esk369_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk420_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1006,axiom,
    ( ~ esk340_6(X1,X2,X3,X4,X5,X6)
    | esk306_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1007,axiom,
    ( esk129_2(X1,X2)
    | p(X2)
    | ~ esk78_1(X1) ) ).

cnf(i_0_1008,axiom,
    ( ~ p(X5)
    | esk242_4(X1,X2,X3,X4)
    | ~ esk276_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1009,axiom,
    ( esk398_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk432_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1010,axiom,
    ( ~ esk349_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk383_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1011,axiom,
    ( p(X1)
    | ~ esk45_0
    | esk62_1(X1) ) ).

cnf(i_0_1012,axiom,
    ( esk331_6(X1,X2,X3,X4,X5,X6)
    | ~ esk382_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_1013,axiom,
    ( esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | ~ esk360_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1014,axiom,
    ( esk84_1(X1)
    | ~ esk135_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_1015,axiom,
    ( esk427_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk428_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1016,axiom,
    ( p(X4)
    | ~ esk227_4(X1,X2,X3,X4)
    | esk176_3(X1,X2,X3) ) ).

cnf(i_0_1017,axiom,
    ( esk417_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk366_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1018,axiom,
    ( esk414_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk423_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk440_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1019,axiom,
    ( esk126_2(X1,X2)
    | ~ esk92_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_1020,axiom,
    ( p(X1)
    | esk74_1(X1)
    | ~ esk23_0 ) ).

cnf(i_0_1021,axiom,
    ( esk68_1(X1)
    | ~ esk51_0
    | p(X1) ) ).

cnf(i_0_1022,axiom,
    ( ~ p(X1)
    | esk7_0
    | ~ esk58_1(X1) ) ).

cnf(i_0_1023,axiom,
    ( p(X8)
    | ~ esk433_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk382_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1024,axiom,
    ( p(X5)
    | ~ esk277_5(X1,X2,X3,X4,X5)
    | esk226_4(X1,X2,X3,X4) ) ).

cnf(i_0_1025,axiom,
    ( esk268_5(X1,X2,X3,X4,X5)
    | ~ esk217_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_1026,axiom,
    ( ~ esk410_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk418_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1027,axiom,
    ( ~ esk207_4(X1,X2,X3,X4)
    | esk190_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1028,axiom,
    ( ~ esk167_3(X1,X2,X3)
    | esk116_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1029,axiom,
    ( esk72_1(X1)
    | ~ p(X1)
    | ~ esk38_0 ) ).

cnf(i_0_1030,axiom,
    ( ~ p(X3)
    | esk145_2(X1,X2)
    | ~ esk179_3(X1,X2,X3) ) ).

cnf(i_0_1031,axiom,
    ( ~ esk200_3(X1,X2,X3)
    | ~ p(X4)
    | esk234_4(X1,X2,X3,X4) ) ).

cnf(i_0_1032,axiom,
    ( p(X5)
    | esk266_5(X1,X2,X3,X4,X5)
    | ~ esk249_4(X1,X2,X3,X4) ) ).

cnf(i_0_1033,axiom,
    ( ~ p(X2)
    | ~ esk124_2(X1,X2)
    | esk90_1(X1) ) ).

cnf(i_0_1034,axiom,
    ( esk80_1(X1)
    | p(X2)
    | ~ esk131_2(X1,X2) ) ).

cnf(i_0_1035,axiom,
    ( p(X8)
    | esk396_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk413_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1036,axiom,
    ( ~ p(X2)
    | esk53_1(X1)
    | ~ esk104_2(X1,X2) ) ).

cnf(i_0_1037,axiom,
    ( esk207_4(X1,X2,X3,X4)
    | ~ esk190_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1038,axiom,
    ( ~ esk335_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk301_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1039,axiom,
    ( ~ p(X2)
    | ~ esk113_2(X1,X2)
    | esk62_1(X1) ) ).

cnf(i_0_1040,axiom,
    ( p(X1)
    | ~ esk64_1(X1)
    | esk47_0 ) ).

cnf(i_0_1041,axiom,
    ( ~ esk9_0
    | esk60_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_1042,axiom,
    ( esk404_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk421_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_1043,axiom,
    ( ~ esk348_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk382_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1044,axiom,
    ( esk246_4(X1,X2,X3,X4)
    | ~ esk263_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_1045,axiom,
    ( esk173_3(X1,X2,X3)
    | ~ esk224_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_1046,axiom,
    ( esk56_1(X1)
    | ~ esk39_0
    | p(X1) ) ).

cnf(i_0_1047,axiom,
    ( ~ esk230_4(X1,X2,X3,X4)
    | esk196_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_1048,axiom,
    ( ~ p(X1)
    | ~ esk7_0
    | esk58_1(X1) ) ).

cnf(i_0_1049,axiom,
    ( ~ esk156_3(X1,X2,X3)
    | ~ p(X4)
    | esk207_4(X1,X2,X3,X4) ) ).

cnf(i_0_1050,axiom,
    ( p(X6)
    | ~ esk286_5(X1,X2,X3,X4,X5)
    | esk337_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1051,axiom,
    ( esk215_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk266_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1052,axiom,
    ( esk341_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk358_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1053,axiom,
    ( ~ p(X7)
    | ~ esk341_6(X1,X2,X3,X4,X5,X6)
    | esk375_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1054,axiom,
    ( esk424_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk415_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk441_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1055,axiom,
    ( ~ esk409_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk358_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1056,axiom,
    ( ~ p(X5)
    | ~ esk212_4(X1,X2,X3,X4)
    | esk263_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1057,axiom,
    ( esk320_6(X1,X2,X3,X4,X5,X6)
    | ~ esk269_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1058,axiom,
    ( ~ p(X7)
    | esk388_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk354_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1059,axiom,
    ( p(X1)
    | esk31_0
    | ~ esk82_1(X1) ) ).

cnf(i_0_1060,axiom,
    ( ~ esk264_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk213_4(X1,X2,X3,X4) ) ).

cnf(i_0_1061,axiom,
    ( ~ esk249_4(X1,X2,X3,X4)
    | esk283_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_1062,axiom,
    ( ~ esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk422_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1063,axiom,
    ( esk285_5(X1,X2,X3,X4,X5)
    | ~ esk234_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_1064,axiom,
    ( ~ esk140_2(X1,X2)
    | esk174_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_1065,axiom,
    ( esk352_6(X1,X2,X3,X4,X5,X6)
    | ~ esk386_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_1066,axiom,
    ( ~ p(X7)
    | esk307_6(X1,X2,X3,X4,X5,X6)
    | ~ esk358_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1067,axiom,
    ( ~ p(X8)
    | esk404_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk438_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1068,axiom,
    ( ~ esk294_5(X1,X2,X3,X4,X5)
    | esk328_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_1069,axiom,
    ( esk41_0
    | ~ esk75_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_1070,axiom,
    ( esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk408_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1071,axiom,
    ( p(X3)
    | ~ esk185_3(X1,X2,X3)
    | esk134_2(X1,X2) ) ).

cnf(i_0_1072,axiom,
    ( ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk420_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk437_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1073,axiom,
    ( ~ esk145_2(X1,X2)
    | p(X3)
    | esk162_3(X1,X2,X3) ) ).

cnf(i_0_1074,axiom,
    ( esk392_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk426_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_1075,axiom,
    ( esk231_4(X1,X2,X3,X4)
    | ~ esk180_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1076,axiom,
    ( esk159_3(X1,X2,X3)
    | ~ esk210_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_1077,axiom,
    ( ~ esk67_1(X1)
    | ~ p(X1)
    | esk16_0 ) ).

cnf(i_0_1078,axiom,
    ( ~ esk219_4(X1,X2,X3,X4)
    | esk202_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1079,axiom,
    ( ~ esk272_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk255_4(X1,X2,X3,X4) ) ).

cnf(i_0_1080,axiom,
    ( ~ esk437_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk403_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1081,axiom,
    ( esk181_3(X1,X2,X3)
    | ~ esk147_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1082,axiom,
    ( ~ esk395_7(X1,X2,X3,X4,X5,X6,X7)
    | esk412_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_1083,axiom,
    ( esk168_3(X1,X2,X3)
    | ~ p(X3)
    | ~ esk117_2(X1,X2) ) ).

cnf(i_0_1084,axiom,
    ( esk380_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk329_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1085,axiom,
    ( ~ esk189_3(X1,X2,X3)
    | ~ p(X4)
    | esk223_4(X1,X2,X3,X4) ) ).

cnf(i_0_1086,axiom,
    ( esk352_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk369_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1087,axiom,
    ( esk178_3(X1,X2,X3)
    | ~ esk229_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_1088,axiom,
    ( esk297_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk314_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1089,axiom,
    ( ~ esk371_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk320_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1090,axiom,
    ( p(X7)
    | esk381_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk330_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1091,axiom,
    ( esk371_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk354_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1092,axiom,
    ( esk251_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk285_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1093,axiom,
    ( esk358_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk341_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1094,axiom,
    ( ~ esk396_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk430_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1095,axiom,
    ( ~ esk146_2(X1,X2)
    | esk163_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_1096,axiom,
    ( esk410_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk419_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1097,axiom,
    ( esk408_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk425_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1098,axiom,
    ( esk433_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk434_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1099,axiom,
    ( esk362_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk345_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1100,axiom,
    ( ~ esk180_3(X1,X2,X3)
    | p(X3)
    | esk129_2(X1,X2) ) ).

cnf(i_0_1101,axiom,
    ( p(X4)
    | ~ esk199_3(X1,X2,X3)
    | esk216_4(X1,X2,X3,X4) ) ).

cnf(i_0_1102,axiom,
    ( p(X2)
    | ~ esk104_2(X1,X2)
    | esk87_1(X1) ) ).

cnf(i_0_1103,axiom,
    ( ~ p(X8)
    | ~ esk361_7(X1,X2,X3,X4,X5,X6,X7)
    | esk412_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1104,axiom,
    ( ~ esk407_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk424_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1105,axiom,
    ( ~ esk98_1(X1)
    | esk132_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1106,axiom,
    ( ~ p(X7)
    | esk343_6(X1,X2,X3,X4,X5,X6)
    | ~ esk377_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1107,axiom,
    ( p(X5)
    | ~ esk229_4(X1,X2,X3,X4)
    | esk280_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1108,axiom,
    ( esk162_3(X1,X2,X3)
    | ~ esk213_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_1109,axiom,
    ( ~ esk54_1(X1)
    | esk37_0
    | p(X1) ) ).

cnf(i_0_1110,axiom,
    ( p(X4)
    | ~ esk177_3(X1,X2,X3)
    | esk228_4(X1,X2,X3,X4) ) ).

cnf(i_0_1111,axiom,
    ( p(X7)
    | esk349_6(X1,X2,X3,X4,X5,X6)
    | ~ esk366_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1112,axiom,
    ( esk308_6(X1,X2,X3,X4,X5,X6)
    | ~ esk359_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_1113,axiom,
    ( ~ esk103_2(X1,X2)
    | ~ p(X3)
    | esk154_3(X1,X2,X3) ) ).

cnf(i_0_1114,axiom,
    ( ~ esk142_2(X1,X2)
    | p(X3)
    | esk159_3(X1,X2,X3) ) ).

cnf(i_0_1115,axiom,
    ( esk212_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk263_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1116,axiom,
    ( p(X4)
    | ~ esk202_3(X1,X2,X3)
    | esk219_4(X1,X2,X3,X4) ) ).

cnf(i_0_1117,axiom,
    ( ~ p(X4)
    | ~ esk162_3(X1,X2,X3)
    | esk213_4(X1,X2,X3,X4) ) ).

cnf(i_0_1118,axiom,
    ( esk436_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk428_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1119,axiom,
    ( ~ p(X8)
    | esk410_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk359_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1120,axiom,
    ( esk111_2(X1,X2)
    | ~ esk60_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_1121,axiom,
    ( esk406_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk440_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1122,axiom,
    ( esk114_2(X1,X2)
    | ~ esk63_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_1123,axiom,
    ( ~ esk418_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk367_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1124,axiom,
    ( p(X6)
    | esk311_6(X1,X2,X3,X4,X5,X6)
    | ~ esk294_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1125,axiom,
    ( p(X4)
    | ~ esk237_4(X1,X2,X3,X4)
    | esk186_3(X1,X2,X3) ) ).

cnf(i_0_1126,axiom,
    ( ~ p(X3)
    | esk172_3(X1,X2,X3)
    | ~ esk138_2(X1,X2) ) ).

cnf(i_0_1127,axiom,
    ( ~ esk31_0
    | p(X1)
    | esk82_1(X1) ) ).

cnf(i_0_1128,axiom,
    ( ~ esk50_0
    | ~ p(X1)
    | esk84_1(X1) ) ).

cnf(i_0_1129,axiom,
    ( esk55_1(X1)
    | ~ esk106_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1130,axiom,
    ( ~ esk49_0
    | esk83_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_1131,axiom,
    ( p(X1)
    | esk81_1(X1)
    | ~ esk30_0 ) ).

cnf(i_0_1132,axiom,
    ( esk347_6(X1,X2,X3,X4,X5,X6)
    | ~ esk364_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_1133,axiom,
    ( esk225_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk276_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1134,axiom,
    ( ~ esk312_6(X1,X2,X3,X4,X5,X6)
    | esk363_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_1135,axiom,
    ( ~ p(X6)
    | esk304_5(X1,X2,X3,X4,X5)
    | ~ esk338_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1136,axiom,
    ( esk37_0
    | ~ esk71_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_1137,axiom,
    ( esk383_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk332_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1138,axiom,
    ( esk21_0
    | p(X1)
    | ~ esk72_1(X1) ) ).

cnf(i_0_1139,axiom,
    ( esk322_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk271_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1140,axiom,
    ( ~ esk411_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk394_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1141,axiom,
    ( ~ esk239_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk273_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1142,axiom,
    ( esk442_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk434_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1143,axiom,
    ( p(X8)
    | ~ esk403_7(X1,X2,X3,X4,X5,X6,X7)
    | esk420_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1144,axiom,
    ( esk144_2(X1,X2)
    | p(X3)
    | ~ esk161_3(X1,X2,X3) ) ).

cnf(i_0_1145,axiom,
    ( ~ esk37_0
    | esk54_1(X1)
    | p(X1) ) ).

cnf(i_0_1146,axiom,
    ( esk386_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk335_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1147,axiom,
    ( esk353_6(X1,X2,X3,X4,X5,X6)
    | ~ esk387_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_1148,axiom,
    ( p(X7)
    | ~ esk375_7(X1,X2,X3,X4,X5,X6,X7)
    | esk324_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1149,axiom,
    ( esk84_1(X1)
    | p(X1)
    | ~ esk33_0 ) ).

cnf(i_0_1150,axiom,
    ( ~ p(X3)
    | ~ esk104_2(X1,X2)
    | esk155_3(X1,X2,X3) ) ).

cnf(i_0_1151,axiom,
    ( ~ esk303_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk337_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1152,axiom,
    ( esk245_4(X1,X2,X3,X4)
    | ~ esk279_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_1153,axiom,
    ( ~ esk225_4(X1,X2,X3,X4)
    | esk191_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_1154,axiom,
    ( ~ esk365_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk416_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1155,axiom,
    ( ~ esk271_5(X1,X2,X3,X4,X5)
    | esk220_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_1156,axiom,
    ( ~ esk424_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk373_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1157,axiom,
    ( esk413_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk439_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk422_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1158,axiom,
    ( p(X8)
    | esk438_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk387_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1159,axiom,
    ( esk56_1(X1)
    | ~ esk107_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1160,axiom,
    ( p(X7)
    | ~ esk359_7(X1,X2,X3,X4,X5,X6,X7)
    | esk342_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1161,axiom,
    ( ~ p(X6)
    | esk336_6(X1,X2,X3,X4,X5,X6)
    | ~ esk302_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1162,axiom,
    ( esk304_5(X1,X2,X3,X4,X5)
    | ~ esk321_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_1163,axiom,
    ( ~ esk54_1(X1)
    | ~ p(X1)
    | esk3_0 ) ).

cnf(i_0_1164,axiom,
    ( esk277_5(X1,X2,X3,X4,X5)
    | ~ esk243_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_1165,axiom,
    ( ~ p(X6)
    | ~ esk330_6(X1,X2,X3,X4,X5,X6)
    | esk296_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1166,axiom,
    ( ~ p(X1)
    | ~ esk14_0
    | esk65_1(X1) ) ).

cnf(i_0_1167,axiom,
    ( ~ esk216_4(X1,X2,X3,X4)
    | esk267_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_1168,axiom,
    ( esk425_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk374_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1169,axiom,
    ( esk119_2(X1,X2)
    | ~ p(X2)
    | ~ esk68_1(X1) ) ).

cnf(i_0_1170,axiom,
    ( ~ p(X6)
    | esk308_6(X1,X2,X3,X4,X5,X6)
    | ~ esk257_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1171,axiom,
    ( p(X4)
    | esk215_4(X1,X2,X3,X4)
    | ~ esk198_3(X1,X2,X3) ) ).

cnf(i_0_1172,axiom,
    ( ~ esk325_6(X1,X2,X3,X4,X5,X6)
    | esk291_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1173,axiom,
    ( ~ esk61_1(X1)
    | ~ p(X2)
    | esk112_2(X1,X2) ) ).

cnf(i_0_1174,axiom,
    ( esk365_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk348_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1175,axiom,
    ( ~ esk232_4(X1,X2,X3,X4)
    | p(X4)
    | esk181_3(X1,X2,X3) ) ).

cnf(i_0_1176,axiom,
    ( ~ p(X2)
    | esk89_1(X1)
    | ~ esk123_2(X1,X2) ) ).

cnf(i_0_1177,axiom,
    ( esk261_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk244_4(X1,X2,X3,X4) ) ).

cnf(rule_true,axiom,
    p(true) ).

cnf(rule_false,axiom,
    ~ p(false) ).

cnf(true_not_false,axiom,
    true != false ).

%------------------------------------------------------------------------------
