%------------------------------------------------------------------------------
% File     : HWV070-1 : TPTP v9.2.0. Bugfixed v5.5.1.
% Domain   : Hardware Verification
% Problem  : QBFLib problem from the Counter family
% Version  : Especial.
% English  : A generator for the following problem. Given an n-bit-counter 
%            with optional reset r and enable e signals, check whether it is 
%            possible to reach the state where all n bits are set to 1 
%            starting from the initial state where all bits are set to 0.

% Refs     : [Sei12] Seidl (2012), Email to Geoff Sutcliffe
%          : [SLB12] Seidl et al. (2012), Tool for Generating EPR Formulas
% Source   : [Sei12]
% Names    : counter_32-shuffled [Sei12]

% Status   : Satisfiable
% Rating   : 1.00 v6.1.0, 0.80 v6.0.0
% Syntax   : Number of clauses     : 16996 (  37 unt;8415 nHn;12835 RR)
%            Number of literals    : 50782 (   1 equ;25438 neg)
%            Maximal clause size   :    3 (   2 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 6372 (6371 usr; 195 prp; 0-32 aty)
%            Number of functors    :    2 (   2 usr;   2 con; 0-0 aty)
%            Number of variables   : 284768 (   0 sgn)
% SPC      : CNF_SAT_EPR_EQU_NUE

% Comments :
% Bugfixes : v5.5.1 - Fixed rule_true and rule_false, added true_not_false
%------------------------------------------------------------------------------
cnf(i_0_1,axiom,
    ( ~ esk6118_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6313_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_2,axiom,
    ( ~ p(X3)
    | ~ esk661_3(X1,X2,X3)
    | esk531_2(X1,X2) ) ).

cnf(i_0_3,axiom,
    ( esk1472_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1277_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4,axiom,
    ( ~ esk2931_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2866_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_5,axiom,
    ( ~ p(X30)
    | esk5948_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5818_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_6,axiom,
    ( esk105_0
    | ~ esk300_1(X1)
    | p(X1) ) ).

cnf(i_0_7,axiom,
    ( esk354_1(X1)
    | ~ esk484_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_8,axiom,
    ( esk1423_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1618_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_9,axiom,
    ( esk148_0
    | ~ esk278_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_10,axiom,
    ( ~ esk3179_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2984_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_11,axiom,
    ( esk1680_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1550_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_12,axiom,
    ( esk1843_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1713_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_13,axiom,
    ( ~ esk181_0
    | p(X1)
    | esk246_1(X1) ) ).

cnf(i_0_14,axiom,
    ( p(X12)
    | ~ esk2249_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2444_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_15,axiom,
    ( ~ p(X18)
    | ~ esk3572_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3377_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_16,axiom,
    ( ~ esk4455_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4520_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_17,axiom,
    ( ~ esk644_3(X1,X2,X3)
    | p(X3)
    | esk579_2(X1,X2) ) ).

cnf(i_0_18,axiom,
    ( esk3356_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3291_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_19,axiom,
    ( esk1944_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2009_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_20,axiom,
    ( esk6177_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6242_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_21,axiom,
    ( ~ esk3086_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3216_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_22,axiom,
    ( esk2785_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk2980_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_23,axiom,
    ( ~ esk276_1(X1)
    | esk81_0
    | p(X1) ) ).

cnf(i_0_24,axiom,
    ( ~ esk1095_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk965_4(X1,X2,X3,X4) ) ).

cnf(i_0_25,axiom,
    ( ~ esk5111_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4916_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_26,axiom,
    ( p(X4)
    | esk667_3(X1,X2,X3)
    | ~ esk862_4(X1,X2,X3,X4) ) ).

cnf(i_0_27,axiom,
    ( ~ esk1376_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1181_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_28,axiom,
    ( ~ p(X4)
    | esk844_4(X1,X2,X3,X4)
    | ~ esk649_3(X1,X2,X3) ) ).

cnf(i_0_29,axiom,
    ( ~ p(X20)
    | esk3963_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3768_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_30,axiom,
    ( esk3175_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3370_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_31,axiom,
    ( ~ esk2724_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2854_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_32,axiom,
    ( p(X24)
    | esk4793_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4598_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_33,axiom,
    ( esk2315_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2380_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_34,axiom,
    ( ~ p(X5)
    | ~ esk933_4(X1,X2,X3,X4)
    | esk1063_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_35,axiom,
    ( ~ esk3407_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3212_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_36,axiom,
    ( esk1576_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | ~ esk1381_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_37,axiom,
    ( ~ esk4568_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4763_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_38,axiom,
    ( esk3743_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3938_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_39,axiom,
    ( p(X6)
    | ~ esk1072_5(X1,X2,X3,X4,X5)
    | esk1267_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_40,axiom,
    ( ~ esk2816_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2686_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_41,axiom,
    ( esk34_0
    | ~ esk229_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_42,axiom,
    ( ~ esk5585_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5780_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_43,axiom,
    ( esk1310_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1440_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_44,axiom,
    ( esk4746_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4941_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_45,axiom,
    ( ~ esk5020_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | esk5150_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_46,axiom,
    ( p(X26)
    | esk5060_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5125_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_47,axiom,
    ( p(X10)
    | esk2056_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1861_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_48,axiom,
    ( ~ esk2048_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1853_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_49,axiom,
    ( p(X8)
    | esk1496_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1561_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_50,axiom,
    ( esk136_0
    | p(X1)
    | ~ esk201_1(X1) ) ).

cnf(i_0_51,axiom,
    ( ~ p(X3)
    | esk570_2(X1,X2)
    | ~ esk700_3(X1,X2,X3) ) ).

cnf(i_0_52,axiom,
    ( ~ esk526_2(X1,X2)
    | p(X3)
    | esk591_3(X1,X2,X3) ) ).

cnf(i_0_53,axiom,
    ( ~ p(X26)
    | esk5030_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5160_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_54,axiom,
    ( esk3796_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk3991_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_55,axiom,
    ( esk3356_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3161_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_56,axiom,
    ( ~ esk3174_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3109_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_57,axiom,
    ( esk4064_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4194_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_58,axiom,
    ( ~ esk2653_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2523_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_59,axiom,
    ( ~ p(X14)
    | esk2858_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2728_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_60,axiom,
    ( ~ p(X25)
    | esk4911_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4716_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_61,axiom,
    ( esk4754_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4949_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_62,axiom,
    ( ~ esk3351_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3546_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_63,axiom,
    ( esk3319_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3514_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_64,axiom,
    ( esk5691_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5626_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_65,axiom,
    ( ~ esk6160_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6355_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_66,axiom,
    ( ~ esk2045_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1850_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_67,axiom,
    ( esk489_2(X1,X2)
    | ~ esk359_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_68,axiom,
    ( esk212_1(X1)
    | ~ p(X1)
    | ~ esk17_0 ) ).

cnf(i_0_69,axiom,
    ( esk5851_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5786_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_70,axiom,
    ( ~ esk4543_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4738_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_71,axiom,
    ( esk5325_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5130_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_72,axiom,
    ( esk2999_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2804_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_73,axiom,
    ( esk5554_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5749_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_74,axiom,
    ( ~ p(X4)
    | ~ esk624_3(X1,X2,X3)
    | esk819_4(X1,X2,X3,X4) ) ).

cnf(i_0_75,axiom,
    ( ~ esk5342_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5537_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_76,axiom,
    ( ~ esk4881_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | esk5076_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_77,axiom,
    ( esk4928_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5123_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_78,axiom,
    ( esk4633_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4698_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_79,axiom,
    ( ~ esk1969_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1904_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_80,axiom,
    ( esk2144_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2209_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_81,axiom,
    ( esk5665_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5600_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_82,axiom,
    ( esk572_2(X1,X2)
    | ~ esk702_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_83,axiom,
    ( ~ p(X25)
    | esk4693_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4888_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_84,axiom,
    ( ~ esk2644_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | esk2449_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_85,axiom,
    ( ~ esk5924_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | esk5794_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_86,axiom,
    ( esk23_0
    | ~ p(X1)
    | ~ esk218_1(X1) ) ).

cnf(i_0_87,axiom,
    ( p(X22)
    | ~ esk4323_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4258_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_88,axiom,
    ( esk2815_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | ~ esk3010_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_89,axiom,
    ( p(X9)
    | ~ esk1668_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1863_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_90,axiom,
    ( esk1120_5(X1,X2,X3,X4,X5)
    | ~ esk1250_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_91,axiom,
    ( esk4571_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4766_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_92,axiom,
    ( ~ p(X14)
    | ~ esk2792_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2597_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_93,axiom,
    ( ~ esk1201_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk1006_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_94,axiom,
    ( ~ esk5344_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5149_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_95,axiom,
    ( esk3481_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3611_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_96,axiom,
    ( esk408_2(X1,X2)
    | ~ esk213_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_97,axiom,
    ( esk2786_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2721_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_98,axiom,
    ( ~ esk945_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk1075_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_99,axiom,
    ( ~ esk2665_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2860_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_100,axiom,
    ( esk6209_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6274_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_101,axiom,
    ( p(X30)
    | esk5886_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5821_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_102,axiom,
    ( esk2146_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2341_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_103,axiom,
    ( ~ esk1346_6(X1,X2,X3,X4,X5,X6)
    | esk1411_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_104,axiom,
    ( ~ esk2222_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2092_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_105,axiom,
    ( esk3932_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3867_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_106,axiom,
    ( esk2099_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2164_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_107,axiom,
    ( ~ esk4493_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4688_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_108,axiom,
    ( ~ esk1440_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk1635_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_109,axiom,
    ( esk255_1(X1)
    | ~ p(X2)
    | ~ esk450_2(X1,X2) ) ).

cnf(i_0_110,axiom,
    ( ~ esk2396_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2591_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_111,axiom,
    ( p(X25)
    | esk4962_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4767_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_112,axiom,
    ( ~ esk4191_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4386_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_113,axiom,
    ( esk226_1(X1)
    | ~ p(X1)
    | ~ esk31_0 ) ).

cnf(i_0_114,axiom,
    ( esk4913_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4718_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_115,axiom,
    ( ~ esk1644_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1449_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_116,axiom,
    ( p(X32)
    | ~ esk6219_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6284_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_117,axiom,
    ( ~ esk1302_6(X1,X2,X3,X4,X5,X6)
    | esk1367_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_118,axiom,
    ( ~ esk5976_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5781_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_119,axiom,
    ( esk3842_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3907_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_120,axiom,
    ( ~ esk614_3(X1,X2,X3)
    | ~ p(X3)
    | esk419_2(X1,X2) ) ).

cnf(i_0_121,axiom,
    ( esk5246_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5311_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_122,axiom,
    ( ~ esk2059_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | esk1929_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_123,axiom,
    ( ~ esk3197_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3002_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_124,axiom,
    ( esk2203_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2008_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_125,axiom,
    ( ~ p(X26)
    | esk4930_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5125_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_126,axiom,
    ( ~ esk6055_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | esk5860_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_127,axiom,
    ( ~ esk660_3(X1,X2,X3)
    | p(X3)
    | esk465_2(X1,X2) ) ).

cnf(i_0_128,axiom,
    ( esk6071_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | ~ esk5876_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_129,axiom,
    ( ~ p(X16)
    | ~ esk2973_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3168_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_130,axiom,
    ( esk3903_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4098_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_131,axiom,
    ( ~ p(X30)
    | ~ esk5890_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5695_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_132,axiom,
    ( esk6094_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6029_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_133,axiom,
    ( ~ esk5475_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | esk5410_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_134,axiom,
    ( ~ p(X11)
    | esk2212_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2082_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_135,axiom,
    ( ~ p(X28)
    | esk5517_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5322_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_136,axiom,
    ( p(X26)
    | ~ esk5165_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4970_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_137,axiom,
    ( ~ p(X15)
    | ~ esk3029_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2899_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_138,axiom,
    ( ~ esk4115_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4310_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_139,axiom,
    ( esk802_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk997_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_140,axiom,
    ( ~ esk1878_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2073_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_141,axiom,
    ( ~ p(X8)
    | ~ esk1566_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1371_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_142,axiom,
    ( ~ esk3867_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3997_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_143,axiom,
    ( ~ esk2227_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | esk2097_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_144,axiom,
    ( ~ p(X2)
    | ~ esk385_1(X1)
    | esk515_2(X1,X2) ) ).

cnf(i_0_145,axiom,
    ( ~ esk6090_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5895_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_146,axiom,
    ( ~ p(X27)
    | esk5366_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5236_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_147,axiom,
    ( ~ esk3464_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3529_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_148,axiom,
    ( ~ esk536_2(X1,X2)
    | esk666_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_149,axiom,
    ( p(X25)
    | esk4861_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4926_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_150,axiom,
    ( p(X32)
    | esk6228_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6293_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_151,axiom,
    ( esk1668_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1538_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_152,axiom,
    ( p(X5)
    | ~ esk901_4(X1,X2,X3,X4)
    | esk1096_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_153,axiom,
    ( esk1177_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk982_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_154,axiom,
    ( ~ esk2006_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1811_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_155,axiom,
    ( esk4698_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | ~ esk4633_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_156,axiom,
    ( esk276_1(X1)
    | ~ p(X1)
    | ~ esk146_0 ) ).

cnf(i_0_157,axiom,
    ( p(X8)
    | esk1455_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1650_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_158,axiom,
    ( esk6300_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6268_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_159,axiom,
    ( esk2054_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1924_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_160,axiom,
    ( ~ esk5418_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5483_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_161,axiom,
    ( ~ p(X24)
    | esk4700_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4505_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_162,axiom,
    ( ~ p(X1)
    | esk263_1(X1)
    | ~ esk133_0 ) ).

cnf(i_0_163,axiom,
    ( esk807_4(X1,X2,X3,X4)
    | ~ esk742_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_164,axiom,
    ( ~ esk2835_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk3030_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_165,axiom,
    ( ~ esk4389_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4259_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_166,axiom,
    ( p(X22)
    | esk4387_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4192_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_167,axiom,
    ( p(X1)
    | esk139_0
    | ~ esk204_1(X1) ) ).

cnf(i_0_168,axiom,
    ( ~ p(X18)
    | ~ esk3317_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3512_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_169,axiom,
    ( p(X1)
    | esk78_0
    | ~ esk273_1(X1) ) ).

cnf(i_0_170,axiom,
    ( ~ esk1464_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1659_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_171,axiom,
    ( esk2791_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2596_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_172,axiom,
    ( ~ esk5613_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5743_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_173,axiom,
    ( ~ esk5926_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5796_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_174,axiom,
    ( p(X30)
    | ~ esk5824_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5889_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_175,axiom,
    ( esk742_3(X1,X2,X3)
    | p(X4)
    | ~ esk807_4(X1,X2,X3,X4) ) ).

cnf(i_0_176,axiom,
    ( esk4926_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5121_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_177,axiom,
    ( ~ esk1063_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk868_4(X1,X2,X3,X4) ) ).

cnf(i_0_178,axiom,
    ( ~ esk2930_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | esk2735_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_179,axiom,
    ( esk2743_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2548_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_180,axiom,
    ( ~ esk6059_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_181,axiom,
    ( ~ esk2964_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2899_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_182,axiom,
    ( ~ esk1043_5(X1,X2,X3,X4,X5)
    | esk1238_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_183,axiom,
    ( esk174_0
    | p(X1)
    | ~ esk239_1(X1) ) ).

cnf(i_0_184,axiom,
    ( ~ p(X31)
    | esk5890_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6085_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_185,axiom,
    ( esk1345_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1410_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_186,axiom,
    ( ~ esk4675_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4805_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_187,axiom,
    ( esk5790_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5855_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_188,axiom,
    ( esk1746_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1876_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_189,axiom,
    ( ~ p(X13)
    | esk2481_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2611_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_190,axiom,
    ( ~ p(X8)
    | ~ esk1687_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1557_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_191,axiom,
    ( esk779_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk909_4(X1,X2,X3,X4) ) ).

cnf(i_0_192,axiom,
    ( esk3403_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | ~ esk3273_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_193,axiom,
    ( esk3260_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | ~ esk3325_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_194,axiom,
    ( esk1673_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1868_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_195,axiom,
    ( ~ esk6144_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6339_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_196,axiom,
    ( p(X11)
    | esk2112_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2177_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_197,axiom,
    ( ~ p(X19)
    | esk3573_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3768_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_198,axiom,
    ( esk2771_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2576_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_199,axiom,
    ( ~ p(X32)
    | esk6101_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6296_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_200,axiom,
    ( p(X13)
    | ~ esk2579_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2514_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_201,axiom,
    ( p(X15)
    | ~ esk2938_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2873_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_202,axiom,
    ( ~ p(X5)
    | ~ esk983_5(X1,X2,X3,X4,X5)
    | esk788_4(X1,X2,X3,X4) ) ).

cnf(i_0_203,axiom,
    ( p(X19)
    | ~ esk3832_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3637_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_204,axiom,
    ( ~ p(X18)
    | esk3544_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3349_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_205,axiom,
    ( esk4001_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3806_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_206,axiom,
    ( esk3981_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | ~ esk4176_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_207,axiom,
    ( p(X4)
    | esk728_3(X1,X2,X3)
    | ~ esk793_4(X1,X2,X3,X4) ) ).

cnf(i_0_208,axiom,
    ( ~ esk5608_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5738_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_209,axiom,
    ( esk1582_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1387_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_210,axiom,
    ( ~ p(X22)
    | esk4368_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4238_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_211,axiom,
    ( ~ p(X18)
    | esk3341_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3536_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_212,axiom,
    ( esk537_2(X1,X2)
    | ~ p(X3)
    | ~ esk667_3(X1,X2,X3) ) ).

cnf(i_0_213,axiom,
    ( ~ esk5666_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | esk5471_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_214,axiom,
    ( esk4058_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4188_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_215,axiom,
    ( ~ esk6248_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6247_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_216,axiom,
    ( ~ esk2856_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2726_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_217,axiom,
    ( ~ esk72_0
    | p(X1)
    | esk267_1(X1) ) ).

cnf(i_0_218,axiom,
    ( ~ esk3180_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3375_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_219,axiom,
    ( p(X23)
    | esk4498_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4433_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_220,axiom,
    ( p(X12)
    | ~ esk2470_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2275_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_221,axiom,
    ( esk4306_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4501_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_222,axiom,
    ( ~ esk3132_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2937_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_223,axiom,
    ( ~ esk3884_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4014_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_224,axiom,
    ( ~ esk2870_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3000_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_225,axiom,
    ( p(X22)
    | esk4389_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4194_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_226,axiom,
    ( ~ esk4620_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4685_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_227,axiom,
    ( ~ esk2164_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | esk2359_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_228,axiom,
    ( ~ esk4607_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4477_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_229,axiom,
    ( esk5998_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6128_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_230,axiom,
    ( ~ p(X27)
    | esk5205_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5335_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_231,axiom,
    ( esk5161_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4966_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_232,axiom,
    ( ~ esk1815_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | esk1750_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_233,axiom,
    ( ~ esk1033_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk838_4(X1,X2,X3,X4) ) ).

cnf(i_0_234,axiom,
    ( esk2089_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2154_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_235,axiom,
    ( ~ esk5942_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | esk6137_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_236,axiom,
    ( p(X14)
    | esk2646_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2841_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_237,axiom,
    ( esk4046_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4176_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_238,axiom,
    ( esk304_1(X1)
    | p(X1)
    | ~ esk109_0 ) ).

cnf(i_0_239,axiom,
    ( ~ p(X29)
    | esk5670_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5475_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_240,axiom,
    ( p(X23)
    | esk4501_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4436_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_241,axiom,
    ( esk291_1(X1)
    | ~ esk96_0
    | p(X1) ) ).

cnf(i_0_242,axiom,
    ( ~ esk6012_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | esk6077_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_243,axiom,
    ( esk1257_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1062_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_244,axiom,
    ( p(X12)
    | ~ esk2296_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2361_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_245,axiom,
    ( p(X18)
    | ~ esk3524_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3459_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_246,axiom,
    ( esk4156_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | ~ esk4091_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_247,axiom,
    ( esk1170_5(X1,X2,X3,X4,X5)
    | ~ esk1300_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_248,axiom,
    ( esk2750_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2685_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_249,axiom,
    ( p(X25)
    | esk4867_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4932_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_250,axiom,
    ( p(X16)
    | ~ esk3120_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3185_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_251,axiom,
    ( ~ esk5080_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | esk5275_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_252,axiom,
    ( esk448_2(X1,X2)
    | ~ esk383_1(X1)
    | p(X2) ) ).

cnf(i_0_253,axiom,
    ( esk6100_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6035_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_254,axiom,
    ( ~ p(X29)
    | esk5610_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5740_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_255,axiom,
    ( esk2803_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2608_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_256,axiom,
    ( ~ esk4535_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | esk4730_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_257,axiom,
    ( esk5773_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5968_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_258,axiom,
    ( esk4437_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4567_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_259,axiom,
    ( p(X27)
    | esk5185_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5380_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_260,axiom,
    ( ~ p(X3)
    | ~ esk709_3(X1,X2,X3)
    | esk579_2(X1,X2) ) ).

cnf(i_0_261,axiom,
    ( ~ p(X5)
    | ~ esk956_4(X1,X2,X3,X4)
    | esk1086_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_262,axiom,
    ( esk4744_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4939_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_263,axiom,
    ( ~ esk1452_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1322_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_264,axiom,
    ( esk5277_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5212_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_265,axiom,
    ( esk612_3(X1,X2,X3)
    | ~ esk547_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_266,axiom,
    ( esk469_2(X1,X2)
    | ~ p(X2)
    | ~ esk339_1(X1) ) ).

cnf(i_0_267,axiom,
    ( ~ esk2855_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3050_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_268,axiom,
    ( esk808_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk613_3(X1,X2,X3) ) ).

cnf(i_0_269,axiom,
    ( ~ esk4148_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4343_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_270,axiom,
    ( esk2130_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2195_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_271,axiom,
    ( p(X29)
    | esk5653_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5718_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_272,axiom,
    ( p(X20)
    | esk3814_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4009_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_273,axiom,
    ( esk186_0
    | p(X1)
    | ~ esk251_1(X1) ) ).

cnf(i_0_274,axiom,
    ( ~ p(X31)
    | esk6035_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6165_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_275,axiom,
    ( ~ esk2590_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2785_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_276,axiom,
    ( ~ p(X13)
    | esk2502_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2632_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_277,axiom,
    ( p(X5)
    | esk1082_5(X1,X2,X3,X4,X5)
    | ~ esk887_4(X1,X2,X3,X4) ) ).

cnf(i_0_278,axiom,
    ( ~ esk3722_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3657_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_279,axiom,
    ( ~ esk3745_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3680_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_280,axiom,
    ( ~ p(X32)
    | ~ esk6226_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6356_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_281,axiom,
    ( ~ esk399_2(X1,X2)
    | esk594_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_282,axiom,
    ( esk4938_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | ~ esk4743_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_283,axiom,
    ( p(X10)
    | esk2077_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1882_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_284,axiom,
    ( ~ esk3891_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3956_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_285,axiom,
    ( ~ esk5134_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | esk5069_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_286,axiom,
    ( esk5861_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5666_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_287,axiom,
    ( ~ esk4525_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4460_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_288,axiom,
    ( esk1102_5(X1,X2,X3,X4,X5)
    | ~ esk1297_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_289,axiom,
    ( esk4461_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4526_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_290,axiom,
    ( esk3816_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk4011_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_291,axiom,
    ( ~ esk4584_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4779_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_292,axiom,
    ( esk5487_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5292_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_293,axiom,
    ( ~ esk6258_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6291_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6259_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_294,axiom,
    ( ~ esk3814_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | esk3684_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_295,axiom,
    ( esk2578_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2513_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_296,axiom,
    ( ~ esk4879_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | esk5074_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_297,axiom,
    ( ~ esk4755_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | esk4560_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_298,axiom,
    ( ~ esk821_4(X1,X2,X3,X4)
    | esk1016_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_299,axiom,
    ( esk6268_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6073_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_300,axiom,
    ( esk6128_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6323_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_301,axiom,
    ( ~ p(X21)
    | ~ esk4208_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4078_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_302,axiom,
    ( ~ esk2273_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2078_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_303,axiom,
    ( esk3058_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3188_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_304,axiom,
    ( ~ esk5808_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5938_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_305,axiom,
    ( ~ esk663_3(X1,X2,X3)
    | esk468_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_306,axiom,
    ~ esk54_0 ).

cnf(i_0_307,axiom,
    ( ~ esk1465_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk1270_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_308,axiom,
    ( esk6263_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6264_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_309,axiom,
    ( ~ esk4265_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4395_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_310,axiom,
    ( ~ esk715_3(X1,X2,X3)
    | p(X4)
    | esk910_4(X1,X2,X3,X4) ) ).

cnf(i_0_311,axiom,
    ( esk4221_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4416_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_312,axiom,
    ( ~ esk2477_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | esk2542_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_313,axiom,
    ( p(X32)
    | esk6138_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6333_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_314,axiom,
    ( p(X29)
    | ~ esk5664_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5599_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_315,axiom,
    ( ~ esk4797_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4992_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_316,axiom,
    ( ~ esk4631_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4696_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_317,axiom,
    ( esk4226_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4356_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_318,axiom,
    ( esk4442_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | ~ esk4572_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_319,axiom,
    ( ~ p(X16)
    | ~ esk2962_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3157_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_320,axiom,
    ( ~ esk963_4(X1,X2,X3,X4)
    | esk1093_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_321,axiom,
    ( esk3143_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3078_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_322,axiom,
    ( ~ esk1808_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1613_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_323,axiom,
    ( esk2121_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | ~ esk2251_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_324,axiom,
    ( ~ esk6255_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6287_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_325,axiom,
    ( ~ esk3830_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3635_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_326,axiom,
    ( ~ p(X31)
    | ~ esk6042_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6172_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_327,axiom,
    ( p(X16)
    | ~ esk3014_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3209_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_328,axiom,
    ( p(X30)
    | esk5797_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5862_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_329,axiom,
    ( ~ esk4296_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | esk4231_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_330,axiom,
    ( ~ esk6285_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6350_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6252_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_331,axiom,
    ( ~ p(X2)
    | esk499_2(X1,X2)
    | ~ esk369_1(X1) ) ).

cnf(i_0_332,axiom,
    ( ~ p(X1)
    | esk190_0
    | ~ esk320_1(X1) ) ).

cnf(i_0_333,axiom,
    ( ~ p(X15)
    | ~ esk2908_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3038_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_334,axiom,
    ( p(X16)
    | esk3250_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3055_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_335,axiom,
    ( ~ p(X1)
    | ~ esk167_0
    | esk297_1(X1) ) ).

cnf(i_0_336,axiom,
    ( ~ esk2271_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2076_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_337,axiom,
    ( ~ esk3719_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3914_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_338,axiom,
    ( esk2525_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2590_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_339,axiom,
    ( ~ esk549_2(X1,X2)
    | esk614_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_340,axiom,
    ( ~ esk985_5(X1,X2,X3,X4,X5)
    | esk1180_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_341,axiom,
    ( ~ esk2741_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2546_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_342,axiom,
    ( esk1282_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1477_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_343,axiom,
    ( esk3717_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3652_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_344,axiom,
    ( esk1905_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2035_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_345,axiom,
    ( ~ esk2342_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2537_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_346,axiom,
    ( ~ esk5381_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5186_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_347,axiom,
    ( p(X18)
    | ~ esk3580_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3385_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_348,axiom,
    ( p(X12)
    | ~ esk2431_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2236_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_349,axiom,
    ( ~ esk1818_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1623_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_350,axiom,
    ( p(X18)
    | ~ esk3614_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3419_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_351,axiom,
    ( ~ esk6288_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | esk6223_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_352,axiom,
    ( ~ p(X21)
    | esk4059_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4189_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_353,axiom,
    ( ~ esk1482_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk1287_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_354,axiom,
    ( esk2079_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2274_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_355,axiom,
    ( ~ esk1059_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk1254_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_356,axiom,
    ( esk2454_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2649_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_357,axiom,
    ( ~ esk2705_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2835_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_358,axiom,
    ( ~ esk2476_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | esk2541_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_359,axiom,
    ( ~ p(X25)
    | ~ esk4708_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4903_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_360,axiom,
    ( esk2534_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2599_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_361,axiom,
    ( ~ esk3315_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3380_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_362,axiom,
    ( esk1841_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2036_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_363,axiom,
    ( ~ p(X3)
    | esk710_3(X1,X2,X3)
    | ~ esk580_2(X1,X2) ) ).

cnf(i_0_364,axiom,
    ( esk1964_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1769_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_365,axiom,
    ( ~ esk5489_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5294_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_366,axiom,
    ( esk5734_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5539_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_367,axiom,
    ( ~ esk2392_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2327_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_368,axiom,
    ( ~ p(X29)
    | ~ esk5627_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5757_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_369,axiom,
    ( ~ esk2035_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2230_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_370,axiom,
    ( ~ p(X31)
    | ~ esk5910_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6105_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_371,axiom,
    ( esk3777_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3582_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_372,axiom,
    ( esk4798_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | ~ esk4603_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_373,axiom,
    ( esk4605_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | ~ esk4800_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_374,axiom,
    ( ~ p(X27)
    | ~ esk5295_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5100_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_375,axiom,
    ( p(X31)
    | esk5965_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6160_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_376,axiom,
    ( ~ esk4007_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3877_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_377,axiom,
    ( esk5831_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5961_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_378,axiom,
    ( ~ esk5369_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5564_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_379,axiom,
    ( ~ esk1167_5(X1,X2,X3,X4,X5)
    | esk1297_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_380,axiom,
    ( ~ p(X12)
    | esk2312_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2442_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_381,axiom,
    ( ~ p(X26)
    | ~ esk5159_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5029_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_382,axiom,
    ( p(X13)
    | ~ esk2633_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2438_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_383,axiom,
    ( ~ esk1867_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1737_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_384,axiom,
    ( esk2585_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2780_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_385,axiom,
    ( ~ esk4118_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4053_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_386,axiom,
    ( ~ esk6345_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6247_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6280_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_387,axiom,
    ( ~ esk2534_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2664_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_388,axiom,
    ( ~ esk151_0
    | esk281_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_389,axiom,
    ( esk722_3(X1,X2,X3)
    | p(X4)
    | ~ esk787_4(X1,X2,X3,X4) ) ).

cnf(i_0_390,axiom,
    ( ~ p(X20)
    | esk3707_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3902_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_391,axiom,
    ( ~ p(X2)
    | esk226_1(X1)
    | ~ esk421_2(X1,X2) ) ).

cnf(i_0_392,axiom,
    ( ~ esk3747_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3682_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_393,axiom,
    ( ~ p(X21)
    | ~ esk4187_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4057_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_394,axiom,
    ( ~ p(X5)
    | esk1091_5(X1,X2,X3,X4,X5)
    | ~ esk961_4(X1,X2,X3,X4) ) ).

cnf(i_0_395,axiom,
    ( ~ esk445_2(X1,X2)
    | p(X2)
    | esk380_1(X1) ) ).

cnf(i_0_396,axiom,
    ( esk381_1(X1)
    | p(X2)
    | ~ esk446_2(X1,X2) ) ).

cnf(i_0_397,axiom,
    ( p(X26)
    | esk4975_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5170_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_398,axiom,
    ( ~ esk5753_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5948_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_399,axiom,
    ( esk986_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk1181_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_400,axiom,
    ( ~ esk2829_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2699_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_401,axiom,
    ( esk3246_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3051_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_402,axiom,
    ( esk6268_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6300_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6267_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_403,axiom,
    ( esk223_1(X1)
    | ~ p(X1)
    | ~ esk28_0 ) ).

cnf(i_0_404,axiom,
    ( ~ esk5044_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | esk5174_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_405,axiom,
    ( esk4217_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | ~ esk4022_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_406,axiom,
    ( ~ esk4751_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4621_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_407,axiom,
    ( p(X20)
    | esk3947_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3882_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_408,axiom,
    ( p(X2)
    | esk376_1(X1)
    | ~ esk441_2(X1,X2) ) ).

cnf(i_0_409,axiom,
    ( ~ esk2939_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3134_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_410,axiom,
    ( esk5973_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6168_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31) ) ).

cnf(i_0_411,axiom,
    ( p(X27)
    | ~ esk5279_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5214_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_412,axiom,
    ( ~ esk3933_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3738_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_413,axiom,
    ( ~ esk1060_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk865_4(X1,X2,X3,X4) ) ).

cnf(i_0_414,axiom,
    ( p(X18)
    | esk3542_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3477_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_415,axiom,
    ( p(X28)
    | ~ esk5391_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5586_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_416,axiom,
    ( esk169_0
    | ~ esk234_1(X1)
    | p(X1) ) ).

cnf(i_0_417,axiom,
    ( esk5595_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5660_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_418,axiom,
    ( ~ p(X12)
    | esk2352_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2157_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_419,axiom,
    ( ~ esk839_4(X1,X2,X3,X4)
    | p(X4)
    | esk774_3(X1,X2,X3) ) ).

cnf(i_0_420,axiom,
    ( ~ esk3776_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3971_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_421,axiom,
    ( ~ esk3169_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3364_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_422,axiom,
    ( esk5289_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5484_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_423,axiom,
    ( ~ p(X9)
    | ~ esk1823_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1693_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_424,axiom,
    ( p(X18)
    | ~ esk3523_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3458_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_425,axiom,
    ( ~ esk4134_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4329_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_426,axiom,
    ( ~ p(X7)
    | esk1323_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1453_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_427,axiom,
    ( ~ esk3588_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | esk3393_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_428,axiom,
    ( p(X15)
    | ~ esk3037_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2842_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_429,axiom,
    ( ~ p(X31)
    | ~ esk5900_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6095_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_430,axiom,
    ( p(X22)
    | ~ esk4246_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4311_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_431,axiom,
    ( ~ p(X7)
    | ~ esk1361_6(X1,X2,X3,X4,X5,X6)
    | esk1491_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_432,axiom,
    ( esk5294_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5229_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_433,axiom,
    ( esk4545_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4350_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_434,axiom,
    ( esk599_3(X1,X2,X3)
    | ~ esk794_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_435,axiom,
    ( esk4034_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4164_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_436,axiom,
    ( ~ esk3788_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3983_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_437,axiom,
    ( esk6150_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5955_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_438,axiom,
    ( ~ p(X5)
    | ~ esk952_4(X1,X2,X3,X4)
    | esk1082_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_439,axiom,
    ( p(X1)
    | ~ esk112_0
    | esk307_1(X1) ) ).

cnf(i_0_440,axiom,
    ( ~ esk5274_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5079_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_441,axiom,
    ( p(X27)
    | esk5148_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5343_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_442,axiom,
    ( esk2255_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2125_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_443,axiom,
    ( ~ esk2454_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2324_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_444,axiom,
    ( esk4405_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | ~ esk4275_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_445,axiom,
    ( p(X28)
    | esk5358_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5553_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_446,axiom,
    ( esk1239_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk1044_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_447,axiom,
    ( esk1155_5(X1,X2,X3,X4,X5)
    | ~ esk1220_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_448,axiom,
    ( esk228_1(X1)
    | ~ esk163_0
    | p(X1) ) ).

cnf(i_0_449,axiom,
    ( esk5590_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5395_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_450,axiom,
    ( ~ esk1777_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1582_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_451,axiom,
    ( ~ esk2532_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2662_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_452,axiom,
    ( esk5421_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5486_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_453,axiom,
    ( ~ p(X6)
    | ~ esk1271_6(X1,X2,X3,X4,X5,X6)
    | esk1141_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_454,axiom,
    ( esk5082_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5017_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_455,axiom,
    ( ~ esk2456_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2651_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_456,axiom,
    ( p(X19)
    | esk3703_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3768_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_457,axiom,
    ( esk5405_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5470_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_458,axiom,
    ( esk6091_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6026_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_459,axiom,
    ( ~ esk5748_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5618_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_460,axiom,
    ( esk2246_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2441_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_461,axiom,
    ( ~ esk3221_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3416_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_462,axiom,
    ( ~ esk967_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk1097_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_463,axiom,
    ( ~ esk5905_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5710_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_464,axiom,
    ( p(X11)
    | esk2233_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2038_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_465,axiom,
    ( esk3391_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3261_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_466,axiom,
    ( ~ esk5470_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5665_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_467,axiom,
    ( p(X13)
    | ~ esk2643_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2448_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_468,axiom,
    ( esk990_5(X1,X2,X3,X4,X5)
    | ~ esk925_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_469,axiom,
    ( p(X9)
    | esk1684_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1879_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_470,axiom,
    ( esk5195_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk5065_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_471,axiom,
    ( p(X32)
    | ~ esk6285_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6220_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_472,axiom,
    ( esk2608_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2478_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_473,axiom,
    ( ~ p(X21)
    | ~ esk4149_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3954_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_474,axiom,
    ( p(X1)
    | ~ esk136_0
    | esk201_1(X1) ) ).

cnf(i_0_475,axiom,
    ( esk1092_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk962_4(X1,X2,X3,X4) ) ).

cnf(i_0_476,axiom,
    ( esk708_3(X1,X2,X3)
    | ~ esk513_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_477,axiom,
    ( p(X31)
    | esk6135_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5940_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_478,axiom,
    ( ~ esk3206_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk3076_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_479,axiom,
    ( esk3563_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3758_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_480,axiom,
    ( ~ p(X18)
    | esk3466_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3596_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_481,axiom,
    ( ~ esk5094_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5029_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_482,axiom,
    ( esk3036_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2841_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_483,axiom,
    ( ~ p(X23)
    | esk4529_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4334_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_484,axiom,
    ( ~ esk5250_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5315_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_485,axiom,
    ( esk1281_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1476_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_486,axiom,
    ( esk2006_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | ~ esk1941_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_487,axiom,
    ( esk4656_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4786_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_488,axiom,
    ( esk1937_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk2067_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_489,axiom,
    ( ~ esk2412_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2217_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_490,axiom,
    ( ~ p(X25)
    | ~ esk4719_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4914_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_491,axiom,
    ( esk3243_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3048_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_492,axiom,
    ( esk4634_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4764_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_493,axiom,
    ( esk4919_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | ~ esk5114_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_494,axiom,
    ( esk4529_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4724_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_495,axiom,
    ( p(X11)
    | ~ esk2023_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2218_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_496,axiom,
    ( ~ p(X24)
    | esk4806_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4676_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_497,axiom,
    ( esk1328_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1458_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_498,axiom,
    ( esk549_2(X1,X2)
    | p(X3)
    | ~ esk614_3(X1,X2,X3) ) ).

cnf(i_0_499,axiom,
    ( esk1805_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | ~ esk1740_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_500,axiom,
    ( ~ p(X29)
    | ~ esk5641_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5771_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_501,axiom,
    ( p(X31)
    | esk6151_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5956_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_502,axiom,
    ( p(X15)
    | ~ esk2845_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3040_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_503,axiom,
    ( ~ esk1074_5(X1,X2,X3,X4,X5)
    | esk944_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_504,axiom,
    ( ~ esk3151_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk2956_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_505,axiom,
    ( p(X32)
    | esk6247_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6182_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_506,axiom,
    ( ~ p(X8)
    | ~ esk1533_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1663_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_507,axiom,
    ( ~ esk6313_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6312_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_508,axiom,
    ( esk154_0
    | p(X1)
    | ~ esk219_1(X1) ) ).

cnf(i_0_509,axiom,
    ( ~ esk4316_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4251_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_510,axiom,
    ( ~ esk1098_5(X1,X2,X3,X4,X5)
    | esk903_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_511,axiom,
    ( ~ esk1675_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk1545_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_512,axiom,
    ( esk6304_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6369_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6271_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_513,axiom,
    ( ~ esk2236_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2041_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_514,axiom,
    ( esk1418_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk1353_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_515,axiom,
    ( ~ esk1835_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1640_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_516,axiom,
    ( ~ esk2433_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | esk2628_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_517,axiom,
    ( ~ esk4897_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4702_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_518,axiom,
    ( ~ esk6329_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6362_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6330_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_519,axiom,
    ( ~ esk309_1(X1)
    | ~ p(X1)
    | esk179_0 ) ).

cnf(i_0_520,axiom,
    ( ~ p(X3)
    | esk396_2(X1,X2)
    | ~ esk591_3(X1,X2,X3) ) ).

cnf(i_0_521,axiom,
    ( ~ esk4945_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4750_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_522,axiom,
    ( ~ esk6281_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6346_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6248_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_523,axiom,
    ( ~ esk5290_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | esk5485_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_524,axiom,
    ( esk4383_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4188_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_525,axiom,
    ( ~ p(X5)
    | esk798_4(X1,X2,X3,X4)
    | ~ esk993_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_526,axiom,
    ( esk5815_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | ~ esk5880_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_527,axiom,
    ( esk6278_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6246_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_528,axiom,
    ( p(X1)
    | ~ esk274_1(X1)
    | esk79_0 ) ).

cnf(i_0_529,axiom,
    ( ~ esk3022_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2827_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_530,axiom,
    ( ~ esk3792_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | esk3662_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_531,axiom,
    ( esk626_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk821_4(X1,X2,X3,X4) ) ).

cnf(i_0_532,axiom,
    ( ~ esk6102_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | esk6297_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_533,axiom,
    ( ~ esk5886_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5691_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_534,axiom,
    ( ~ p(X3)
    | ~ esk409_2(X1,X2)
    | esk604_3(X1,X2,X3) ) ).

cnf(i_0_535,axiom,
    ( esk5340_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5535_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_536,axiom,
    ( esk1595_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1530_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_537,axiom,
    ( esk4388_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4583_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_538,axiom,
    ( ~ p(X2)
    | ~ esk355_1(X1)
    | esk485_2(X1,X2) ) ).

cnf(i_0_539,axiom,
    ( esk3936_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4131_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_540,axiom,
    ( ~ esk5913_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5718_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_541,axiom,
    ( ~ esk2185_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | esk1990_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_542,axiom,
    ( ~ esk2305_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | esk2435_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_543,axiom,
    ( p(X24)
    | esk4666_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4731_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_544,axiom,
    ( esk5282_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5217_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_545,axiom,
    ( ~ esk769_3(X1,X2,X3)
    | p(X4)
    | esk834_4(X1,X2,X3,X4) ) ).

cnf(i_0_546,axiom,
    ( ~ p(X4)
    | ~ esk863_4(X1,X2,X3,X4)
    | esk733_3(X1,X2,X3) ) ).

cnf(i_0_547,axiom,
    ( ~ esk4036_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | esk4101_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_548,axiom,
    ( ~ p(X1)
    | ~ esk192_0
    | esk322_1(X1) ) ).

cnf(i_0_549,axiom,
    ( esk540_2(X1,X2)
    | p(X3)
    | ~ esk605_3(X1,X2,X3) ) ).

cnf(i_0_550,axiom,
    ( ~ p(X21)
    | esk4195_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4065_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_551,axiom,
    ( ~ p(X24)
    | ~ esk4692_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4497_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_552,axiom,
    ( ~ esk1454_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1259_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_553,axiom,
    ( esk4811_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4876_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_554,axiom,
    ( p(X23)
    | ~ esk4600_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4405_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_555,axiom,
    ( esk101_0
    | ~ esk296_1(X1)
    | p(X1) ) ).

cnf(i_0_556,axiom,
    ( esk1357_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1422_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_557,axiom,
    ( p(X12)
    | ~ esk2451_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2256_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_558,axiom,
    ( ~ esk2791_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2596_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_559,axiom,
    ( p(X19)
    | ~ esk3633_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3828_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_560,axiom,
    ( ~ esk1615_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1810_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_561,axiom,
    ( p(X5)
    | ~ esk937_4(X1,X2,X3,X4)
    | esk1002_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_562,axiom,
    ( ~ esk5033_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5163_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_563,axiom,
    ( esk249_1(X1)
    | ~ esk184_0
    | p(X1) ) ).

cnf(i_0_564,axiom,
    ( ~ esk1188_6(X1,X2,X3,X4,X5,X6)
    | esk1123_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_565,axiom,
    ( esk5594_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | ~ esk5724_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_566,axiom,
    ( ~ esk346_1(X1)
    | p(X2)
    | esk411_2(X1,X2) ) ).

cnf(i_0_567,axiom,
    ( ~ esk3037_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | esk2907_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_568,axiom,
    ( ~ esk1276_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk1146_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_569,axiom,
    ( esk3151_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3086_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_570,axiom,
    ( ~ esk4459_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4589_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_571,axiom,
    ( p(X8)
    | esk1641_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1446_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_572,axiom,
    ( esk3343_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3538_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_573,axiom,
    ( esk3821_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3691_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_574,axiom,
    ( ~ p(X31)
    | esk5903_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6098_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_575,axiom,
    ( ~ esk3538_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3733_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_576,axiom,
    ( ~ p(X11)
    | esk1996_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2191_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_577,axiom,
    ( p(X23)
    | esk4441_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4506_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_578,axiom,
    ( ~ esk1423_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1228_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_579,axiom,
    ( ~ esk4918_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4853_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_580,axiom,
    ( ~ esk2859_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2729_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_581,axiom,
    ( p(X29)
    | esk5533_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5728_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_582,axiom,
    ( ~ p(X7)
    | esk1307_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1437_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_583,axiom,
    ( ~ esk3526_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3721_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_584,axiom,
    ( ~ p(X18)
    | esk3496_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3626_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_585,axiom,
    ( ~ esk3793_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3598_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_586,axiom,
    ( esk5984_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6049_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_587,axiom,
    ( ~ esk4704_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4899_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_588,axiom,
    ( esk4369_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4174_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_589,axiom,
    ( ~ p(X17)
    | esk3275_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3405_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_590,axiom,
    ( esk267_1(X1)
    | ~ p(X1)
    | ~ esk137_0 ) ).

cnf(i_0_591,axiom,
    ( ~ esk1133_5(X1,X2,X3,X4,X5)
    | esk1263_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_592,axiom,
    ( ~ p(X16)
    | ~ esk2983_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3178_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_593,axiom,
    ( ~ esk4761_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4956_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_594,axiom,
    ( p(X8)
    | ~ esk1493_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1688_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_595,axiom,
    ( ~ esk5791_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | esk5921_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_596,axiom,
    ( esk5147_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | ~ esk4952_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_597,axiom,
    ( p(X14)
    | esk2714_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2779_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_598,axiom,
    ( p(X9)
    | esk1865_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1670_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_599,axiom,
    ( p(X25)
    | esk4976_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4781_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_600,axiom,
    ( ~ esk4574_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4769_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_601,axiom,
    ( ~ p(X11)
    | esk2270_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2140_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_602,axiom,
    ( esk1458_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1263_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_603,axiom,
    ( p(X8)
    | ~ esk1450_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1645_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_604,axiom,
    ( ~ esk5731_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | esk5601_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_605,axiom,
    ( ~ esk2153_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2088_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_606,axiom,
    ( esk2411_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2281_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_607,axiom,
    ( ~ esk3170_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | esk3105_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_608,axiom,
    ( esk4988_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5183_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_609,axiom,
    ( esk4948_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5143_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_610,axiom,
    ( ~ esk5316_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5511_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_611,axiom,
    ( esk6245_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | ~ esk6050_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_612,axiom,
    ( ~ p(X19)
    | esk3514_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3709_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_613,axiom,
    ( esk3723_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3658_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_614,axiom,
    ( esk4914_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25)
    | ~ esk4849_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_615,axiom,
    ( ~ p(X9)
    | ~ esk1784_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1589_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_616,axiom,
    ( ~ esk3275_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3340_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_617,axiom,
    ( ~ p(X25)
    | esk4706_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4901_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_618,axiom,
    ( esk1344_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1474_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_619,axiom,
    ( ~ esk3612_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3482_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_620,axiom,
    ( p(X10)
    | ~ esk2053_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1858_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_621,axiom,
    ( ~ esk6151_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5956_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_622,axiom,
    ( esk3327_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3522_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_623,axiom,
    ( ~ esk2223_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2418_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_624,axiom,
    ( esk2185_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk1990_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_625,axiom,
    ( ~ p(X13)
    | ~ esk2640_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2510_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_626,axiom,
    ( esk3424_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | ~ esk3619_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_627,axiom,
    ( ~ esk3026_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2831_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_628,axiom,
    ( ~ esk5945_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | esk6140_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_629,axiom,
    ( esk5100_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk4905_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_630,axiom,
    ( ~ esk3162_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3357_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_631,axiom,
    ( ~ esk4232_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4297_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_632,axiom,
    ( ~ p(X14)
    | ~ esk2671_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2801_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_633,axiom,
    ( ~ p(X24)
    | ~ esk4631_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4761_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_634,axiom,
    ( esk3233_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | ~ esk3428_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_635,axiom,
    ( p(X12)
    | esk2274_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2469_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_636,axiom,
    ( ~ esk337_1(X1)
    | esk467_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_637,axiom,
    ( esk4253_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4318_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_638,axiom,
    ( ~ esk4923_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | esk4728_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_639,axiom,
    ( p(X27)
    | esk5257_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5322_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_640,axiom,
    ( ~ esk3258_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3323_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_641,axiom,
    ( esk6290_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6258_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_642,axiom,
    ( ~ p(X9)
    | esk1761_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1566_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_643,axiom,
    ( ~ esk5873_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | esk6068_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_644,axiom,
    ( esk4676_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4806_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_645,axiom,
    ( p(X11)
    | ~ esk2045_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2240_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_646,axiom,
    ( p(X26)
    | esk5158_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4963_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_647,axiom,
    ( p(X5)
    | ~ esk1072_5(X1,X2,X3,X4,X5)
    | esk877_4(X1,X2,X3,X4) ) ).

cnf(i_0_648,axiom,
    ( esk5277_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5082_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_649,axiom,
    ( p(X31)
    | ~ esk6119_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5924_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_650,axiom,
    ( ~ esk2462_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2267_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_651,axiom,
    ( ~ esk3082_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3212_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_652,axiom,
    ( ~ esk1977_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | esk1782_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_653,axiom,
    ( esk3342_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3277_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_654,axiom,
    ( p(X27)
    | ~ esk5349_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5154_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_655,axiom,
    ( ~ p(X31)
    | esk6037_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6167_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_656,axiom,
    ( ~ p(X15)
    | ~ esk2897_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3027_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_657,axiom,
    ( esk6172_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | ~ esk5977_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_658,axiom,
    ( p(X25)
    | esk4824_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4889_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_659,axiom,
    ( esk3635_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | ~ esk3440_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_660,axiom,
    ( ~ esk1801_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk1996_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_661,axiom,
    ( ~ esk4308_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4113_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_662,axiom,
    ( esk4267_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4332_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_663,axiom,
    ( esk5783_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5978_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_664,axiom,
    ( esk5881_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5686_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_665,axiom,
    ( ~ esk5299_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5104_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_666,axiom,
    ( ~ esk4872_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4937_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_667,axiom,
    ( ~ esk2096_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2161_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_668,axiom,
    ( esk3147_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk2952_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_669,axiom,
    ( ~ p(X16)
    | ~ esk2940_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3135_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_670,axiom,
    ( ~ esk2875_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | esk3005_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_671,axiom,
    ( ~ esk209_1(X1)
    | ~ p(X2)
    | esk404_2(X1,X2) ) ).

cnf(i_0_672,axiom,
    ( p(X1)
    | esk276_1(X1)
    | ~ esk81_0 ) ).

cnf(i_0_673,axiom,
    ( esk5352_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5157_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_674,axiom,
    ( p(X22)
    | esk4192_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4387_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_675,axiom,
    ( p(X5)
    | esk934_4(X1,X2,X3,X4)
    | ~ esk999_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_676,axiom,
    ( ~ p(X28)
    | esk5306_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5501_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_677,axiom,
    ( esk3955_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3890_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_678,axiom,
    ( ~ esk4791_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4596_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_679,axiom,
    ( ~ esk3350_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3285_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_680,axiom,
    ( p(X32)
    | esk6123_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6318_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_681,axiom,
    ( p(X18)
    | esk3553_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3488_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_682,axiom,
    ( p(X6)
    | ~ esk1116_5(X1,X2,X3,X4,X5)
    | esk1181_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_683,axiom,
    ( ~ p(X23)
    | ~ esk4580_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4450_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_684,axiom,
    ( esk5855_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5790_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_685,axiom,
    ( esk2036_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2231_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_686,axiom,
    ( esk345_1(X1)
    | ~ esk475_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_687,axiom,
    ( esk3034_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | ~ esk3229_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_688,axiom,
    ( ~ esk6188_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6253_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_689,axiom,
    ( p(X3)
    | esk689_3(X1,X2,X3)
    | ~ esk494_2(X1,X2) ) ).

cnf(i_0_690,axiom,
    ( p(X5)
    | esk911_4(X1,X2,X3,X4)
    | ~ esk976_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_691,axiom,
    ( esk3480_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3610_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_692,axiom,
    ( ~ esk2322_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2452_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_693,axiom,
    ( p(X32)
    | ~ esk6203_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6268_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_694,axiom,
    ( ~ esk3240_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3045_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_695,axiom,
    ( ~ esk1073_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk878_4(X1,X2,X3,X4) ) ).

cnf(i_0_696,axiom,
    ( esk6324_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6323_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6356_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_697,axiom,
    ( ~ esk2122_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2252_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_698,axiom,
    ( ~ esk183_0
    | ~ p(X1)
    | esk313_1(X1) ) ).

cnf(i_0_699,axiom,
    ( ~ esk2523_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2653_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_700,axiom,
    ( p(X28)
    | ~ esk5496_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5431_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_701,axiom,
    ( ~ p(X29)
    | esk5519_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5714_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_702,axiom,
    ( esk1778_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk1973_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_703,axiom,
    ( esk1201_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1006_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_704,axiom,
    ( p(X23)
    | ~ esk4392_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4587_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_705,axiom,
    ( esk1495_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1365_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_706,axiom,
    ( esk2941_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2876_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_707,axiom,
    ( p(X24)
    | esk4737_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4672_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_708,axiom,
    ( ~ esk3237_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3042_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_709,axiom,
    ( ~ esk5374_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5569_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_710,axiom,
    ( ~ esk3803_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3998_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_711,axiom,
    ( esk3127_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3322_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_712,axiom,
    ( esk2018_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1823_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_713,axiom,
    ( esk4449_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | ~ esk4579_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_714,axiom,
    ( ~ esk2317_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2447_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_715,axiom,
    ( p(X5)
    | ~ esk932_4(X1,X2,X3,X4)
    | esk997_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_716,axiom,
    ( ~ esk3598_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3468_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_717,axiom,
    ( ~ esk3157_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3352_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_718,axiom,
    ( ~ esk3866_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3931_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_719,axiom,
    ( ~ esk2149_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2084_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_720,axiom,
    ( esk5189_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk5059_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_721,axiom,
    ( ~ esk1473_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1343_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_722,axiom,
    ( ~ esk5859_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5794_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_723,axiom,
    ( ~ esk2589_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2524_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_724,axiom,
    ( ~ esk1191_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk1126_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_725,axiom,
    ( esk5061_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5126_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_726,axiom,
    ( esk6086_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | ~ esk6021_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_727,axiom,
    ( ~ esk1509_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1639_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_728,axiom,
    ( ~ esk4403_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4273_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_729,axiom,
    ( ~ p(X30)
    | esk5686_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5881_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_730,axiom,
    ( p(X1)
    | ~ esk139_0
    | esk204_1(X1) ) ).

cnf(i_0_731,axiom,
    ( ~ p(X31)
    | ~ esk6024_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6154_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_732,axiom,
    ( ~ p(X3)
    | esk619_3(X1,X2,X3)
    | ~ esk424_2(X1,X2) ) ).

cnf(i_0_733,axiom,
    ( esk5840_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5970_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_734,axiom,
    ( ~ esk2475_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2605_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_735,axiom,
    ( ~ esk1651_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk1521_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_736,axiom,
    ( esk346_1(X1)
    | p(X2)
    | ~ esk411_2(X1,X2) ) ).

cnf(i_0_737,axiom,
    ( esk5115_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5310_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_738,axiom,
    ( esk4434_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4564_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_739,axiom,
    ( ~ p(X28)
    | ~ esk5538_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5408_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_740,axiom,
    ( esk4526_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4721_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_741,axiom,
    ( esk270_1(X1)
    | ~ esk465_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_742,axiom,
    ( esk4403_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4598_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_743,axiom,
    ( ~ esk1289_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk1094_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_744,axiom,
    ( ~ esk3521_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3326_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_745,axiom,
    ( esk3944_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4139_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_746,axiom,
    ( p(X29)
    | esk5635_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5700_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_747,axiom,
    ( p(X26)
    | esk5138_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4943_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_748,axiom,
    ( ~ p(X1)
    | ~ esk240_1(X1)
    | esk45_0 ) ).

cnf(i_0_749,axiom,
    ( esk1804_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1999_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_750,axiom,
    ( ~ p(X23)
    | esk4552_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4422_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_751,axiom,
    ( ~ esk3406_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3211_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_752,axiom,
    ( ~ esk5464_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5269_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_753,axiom,
    ( ~ esk4335_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4140_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_754,axiom,
    ( esk1576_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1771_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_755,axiom,
    ( ~ esk4680_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4745_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_756,axiom,
    ( ~ esk5645_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5710_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_757,axiom,
    ( ~ esk3006_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2811_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_758,axiom,
    ( p(X20)
    | ~ esk4003_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3808_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_759,axiom,
    ( ~ esk2948_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2883_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_760,axiom,
    ( ~ esk836_4(X1,X2,X3,X4)
    | esk1031_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_761,axiom,
    ( ~ p(X12)
    | esk2322_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2452_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_762,axiom,
    ( esk3255_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3320_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_763,axiom,
    ( ~ esk5113_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk4918_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_764,axiom,
    ( ~ p(X1)
    | esk250_1(X1)
    | ~ esk55_0 ) ).

cnf(i_0_765,axiom,
    ( ~ esk2345_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2280_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_766,axiom,
    ( esk4518_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4453_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_767,axiom,
    ( esk3712_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | ~ esk3907_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_768,axiom,
    ( esk6200_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6330_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_769,axiom,
    ( ~ esk2877_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2942_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_770,axiom,
    ( esk5292_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5227_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_771,axiom,
    ( ~ esk6306_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | esk6176_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_772,axiom,
    ( ~ esk187_0
    | esk317_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_773,axiom,
    ( esk3464_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3594_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_774,axiom,
    ( ~ esk1578_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1513_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_775,axiom,
    ( ~ p(X8)
    | esk1532_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1662_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_776,axiom,
    ( esk6215_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6345_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_777,axiom,
    ( p(X15)
    | esk2888_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2953_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_778,axiom,
    ( esk3865_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3930_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_779,axiom,
    ( ~ esk4536_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4471_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_780,axiom,
    ( ~ esk470_2(X1,X2)
    | ~ p(X2)
    | esk340_1(X1) ) ).

cnf(i_0_781,axiom,
    ( ~ p(X31)
    | esk6162_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6032_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_782,axiom,
    ( ~ p(X17)
    | esk3359_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3164_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_783,axiom,
    ( ~ esk2108_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2238_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_784,axiom,
    ( esk1163_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1228_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_785,axiom,
    ( esk3424_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | ~ esk3294_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_786,axiom,
    ( ~ esk5927_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6122_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31) ) ).

cnf(i_0_787,axiom,
    ( esk2029_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1899_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_788,axiom,
    ( ~ esk2833_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3028_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_789,axiom,
    ( ~ esk1961_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1896_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_790,axiom,
    ( esk1084_5(X1,X2,X3,X4,X5)
    | ~ esk954_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_791,axiom,
    ( esk5177_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5047_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_792,axiom,
    ( ~ esk2455_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2650_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_793,axiom,
    ( ~ esk5612_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5677_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_794,axiom,
    ( ~ esk2352_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2547_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_795,axiom,
    ( ~ esk2820_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3015_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_796,axiom,
    ( ~ esk1849_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1719_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_797,axiom,
    ( ~ esk3613_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3418_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_798,axiom,
    ( esk2070_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | ~ esk1875_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_799,axiom,
    ( ~ esk3795_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3600_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_800,axiom,
    ( ~ esk5190_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5060_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_801,axiom,
    ( esk4128_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | ~ esk4323_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_802,axiom,
    ( ~ p(X16)
    | ~ esk3120_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3250_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_803,axiom,
    ( esk1083_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk888_4(X1,X2,X3,X4) ) ).

cnf(i_0_804,axiom,
    ( ~ p(X30)
    | ~ esk5903_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5708_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_805,axiom,
    ( p(X9)
    | esk1653_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1848_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_806,axiom,
    ( ~ esk4606_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4411_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_807,axiom,
    ( esk6078_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | ~ esk5883_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_808,axiom,
    ( esk3467_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3597_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_809,axiom,
    ( esk3269_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | ~ esk3399_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_810,axiom,
    ( esk6110_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6045_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_811,axiom,
    ( ~ esk4858_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4923_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_812,axiom,
    ( ~ esk266_1(X1)
    | esk136_0
    | ~ p(X1) ) ).

cnf(i_0_813,axiom,
    ( ~ esk1892_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | esk1957_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_814,axiom,
    ( ~ esk2049_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2244_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_815,axiom,
    ( ~ esk5942_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | esk5747_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_816,axiom,
    ( ~ esk4942_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5137_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_817,axiom,
    ( p(X7)
    | esk1488_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1293_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_818,axiom,
    ( ~ esk1869_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1739_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_819,axiom,
    ( ~ esk1828_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1698_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_820,axiom,
    ( p(X6)
    | ~ esk1077_5(X1,X2,X3,X4,X5)
    | esk1272_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_821,axiom,
    ( ~ esk606_3(X1,X2,X3)
    | esk801_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_822,axiom,
    ( ~ esk2506_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | esk2571_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_823,axiom,
    ( ~ esk6246_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6279_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6344_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_824,axiom,
    ( esk3311_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3441_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_825,axiom,
    ( ~ esk4001_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3806_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_826,axiom,
    ( ~ esk5399_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5529_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_827,axiom,
    ( ~ esk4169_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk3974_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_828,axiom,
    ( ~ esk1271_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk1076_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_829,axiom,
    ( p(X4)
    | esk777_3(X1,X2,X3)
    | ~ esk842_4(X1,X2,X3,X4) ) ).

cnf(i_0_830,axiom,
    ( ~ p(X16)
    | esk3223_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3093_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_831,axiom,
    ( esk243_1(X1)
    | ~ esk178_0
    | p(X1) ) ).

cnf(i_0_832,axiom,
    ( ~ esk4763_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4633_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_833,axiom,
    ( ~ esk5433_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5563_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_834,axiom,
    ( ~ esk655_3(X1,X2,X3)
    | p(X4)
    | esk850_4(X1,X2,X3,X4) ) ).

cnf(i_0_835,axiom,
    ( esk1676_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1481_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_836,axiom,
    ( esk5496_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5691_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_837,axiom,
    ( ~ p(X19)
    | esk3692_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3822_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_838,axiom,
    ( esk3327_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3262_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_839,axiom,
    ( esk4505_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4700_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_840,axiom,
    ( ~ p(X18)
    | ~ esk3525_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3330_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_841,axiom,
    ( esk4409_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4214_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_842,axiom,
    ( esk1135_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1200_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_843,axiom,
    ( ~ esk3940_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | esk4135_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_844,axiom,
    ( ~ esk4795_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4990_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_845,axiom,
    ( ~ esk5083_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4888_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_846,axiom,
    ( ~ esk4957_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5152_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_847,axiom,
    ( ~ esk1350_6(X1,X2,X3,X4,X5,X6)
    | esk1480_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_848,axiom,
    ( ~ p(X17)
    | ~ esk3331_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3136_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_849,axiom,
    ( esk1153_5(X1,X2,X3,X4,X5)
    | ~ esk1283_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_850,axiom,
    ( esk4093_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4223_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_851,axiom,
    ( esk1468_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk1338_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_852,axiom,
    ( esk1115_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk1245_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_853,axiom,
    ( ~ esk5552_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5747_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_854,axiom,
    ( ~ esk192_0
    | p(X1)
    | esk257_1(X1) ) ).

cnf(i_0_855,axiom,
    ( esk5106_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk4911_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_856,axiom,
    ( esk5588_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5783_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_857,axiom,
    ( ~ p(X3)
    | ~ esk714_3(X1,X2,X3)
    | esk584_2(X1,X2) ) ).

cnf(i_0_858,axiom,
    ( esk3479_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3609_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_859,axiom,
    ( ~ esk5050_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5180_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_860,axiom,
    ( esk6120_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5925_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_861,axiom,
    ( ~ esk841_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk1036_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_862,axiom,
    ( ~ esk1017_5(X1,X2,X3,X4,X5)
    | esk1212_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_863,axiom,
    ( esk1625_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1820_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_864,axiom,
    ( ~ esk6320_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6352_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_865,axiom,
    ( ~ esk1195_6(X1,X2,X3,X4,X5,X6)
    | esk1390_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_866,axiom,
    ( esk5185_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk5055_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_867,axiom,
    ( esk3183_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2988_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_868,axiom,
    ( ~ esk6162_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6357_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_869,axiom,
    ( p(X1)
    | ~ esk315_1(X1)
    | esk120_0 ) ).

cnf(i_0_870,axiom,
    ( ~ esk2324_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2454_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_871,axiom,
    ( ~ p(X13)
    | ~ esk2548_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2353_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_872,axiom,
    ( esk2749_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2554_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_873,axiom,
    ( ~ p(X20)
    | esk3966_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3836_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_874,axiom,
    ( p(X20)
    | esk3794_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3989_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_875,axiom,
    ( esk4762_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4567_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_876,axiom,
    ( esk4683_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4878_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_877,axiom,
    ( ~ esk5294_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5489_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_878,axiom,
    ( p(X22)
    | esk4289_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4354_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_879,axiom,
    ( esk1113_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk1243_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_880,axiom,
    ( ~ esk3270_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3400_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_881,axiom,
    ( ~ esk1522_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1587_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_882,axiom,
    ( ~ p(X15)
    | ~ esk3053_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2923_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_883,axiom,
    ( p(X1)
    | ~ esk230_1(X1)
    | esk165_0 ) ).

cnf(i_0_884,axiom,
    ( ~ esk6068_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk6003_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_885,axiom,
    ( p(X20)
    | esk3934_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3869_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_886,axiom,
    ( ~ p(X12)
    | esk2302_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2432_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_887,axiom,
    ( p(X32)
    | ~ esk6362_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6167_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_888,axiom,
    ( ~ p(X27)
    | ~ esk5340_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5210_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_889,axiom,
    ( ~ esk4749_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4944_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_890,axiom,
    ( ~ esk6138_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6333_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_891,axiom,
    ( esk2819_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2689_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_892,axiom,
    ( p(X8)
    | esk1602_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1537_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_893,axiom,
    ( ~ p(X25)
    | ~ esk4896_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4701_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_894,axiom,
    ( ~ p(X15)
    | ~ esk2761_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2956_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_895,axiom,
    ( p(X25)
    | esk4925_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4860_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_896,axiom,
    ( ~ esk2282_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2347_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_897,axiom,
    ( esk3885_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4015_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_898,axiom,
    ( esk5181_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4986_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_899,axiom,
    ( ~ esk4316_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | esk4511_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_900,axiom,
    ( esk1403_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1598_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_901,axiom,
    ( esk6200_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6265_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_902,axiom,
    ( esk5905_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | ~ esk5840_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_903,axiom,
    ( esk4700_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4895_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_904,axiom,
    ( p(X26)
    | ~ esk4987_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5182_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_905,axiom,
    ( ~ p(X15)
    | ~ esk2942_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2747_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_906,axiom,
    ( ~ p(X22)
    | ~ esk4411_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4281_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_907,axiom,
    ( ~ esk1603_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1798_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_908,axiom,
    ( esk4138_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4073_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_909,axiom,
    ( ~ esk4640_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4705_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_910,axiom,
    ( esk459_2(X1,X2)
    | ~ esk329_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_911,axiom,
    ( ~ esk140_0
    | esk270_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_912,axiom,
    ( esk2789_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2594_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_913,axiom,
    ( p(X22)
    | esk4381_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4186_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_914,axiom,
    ( esk1782_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1587_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_915,axiom,
    ( p(X13)
    | esk2478_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2543_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_916,axiom,
    ( p(X20)
    | ~ esk4024_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3829_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_917,axiom,
    ( ~ esk4921_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5116_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_918,axiom,
    ( esk2225_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | ~ esk2030_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_919,axiom,
    ( p(X6)
    | esk1219_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1154_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_920,axiom,
    ( esk5302_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5107_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_921,axiom,
    ( ~ p(X26)
    | esk5056_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5186_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_922,axiom,
    ( ~ p(X4)
    | ~ esk789_4(X1,X2,X3,X4)
    | esk594_3(X1,X2,X3) ) ).

cnf(i_0_923,axiom,
    ( esk4562_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4757_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_924,axiom,
    ( esk3764_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3699_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_925,axiom,
    ( esk2592_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | ~ esk2397_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_926,axiom,
    ( ~ esk4353_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4288_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_927,axiom,
    ( ~ p(X17)
    | ~ esk3281_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3411_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_928,axiom,
    ( p(X29)
    | esk5627_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5692_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_929,axiom,
    ( esk4521_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4326_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_930,axiom,
    ( esk5906_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6101_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_931,axiom,
    ( ~ esk236_1(X1)
    | esk171_0
    | p(X1) ) ).

cnf(i_0_932,axiom,
    ( ~ esk6114_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5919_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_933,axiom,
    ( p(X19)
    | ~ esk3579_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3774_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_934,axiom,
    ( esk3828_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4023_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_935,axiom,
    ( ~ esk386_1(X1)
    | ~ p(X2)
    | esk516_2(X1,X2) ) ).

cnf(i_0_936,axiom,
    ( ~ esk6083_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6018_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_937,axiom,
    ( ~ esk3213_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk3083_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_938,axiom,
    ( ~ p(X25)
    | ~ esk4739_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4934_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_939,axiom,
    ( esk490_2(X1,X2)
    | ~ esk360_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_940,axiom,
    ( ~ p(X18)
    | ~ esk3501_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3631_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_941,axiom,
    ( ~ p(X31)
    | esk6058_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5863_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_942,axiom,
    ( esk2554_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | ~ esk2359_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_943,axiom,
    ( p(X29)
    | ~ esk5609_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5674_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_944,axiom,
    ( ~ esk1907_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1972_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_945,axiom,
    ( esk245_1(X1)
    | ~ esk440_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_946,axiom,
    ( ~ p(X32)
    | esk6062_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6257_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_947,axiom,
    ( ~ p(X5)
    | esk823_4(X1,X2,X3,X4)
    | ~ esk1018_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_948,axiom,
    ( p(X25)
    | ~ esk4884_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4819_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_949,axiom,
    ( ~ p(X2)
    | ~ esk441_2(X1,X2)
    | esk246_1(X1) ) ).

cnf(i_0_950,axiom,
    ( ~ esk3439_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3244_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_951,axiom,
    ( esk3745_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | ~ esk3940_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_952,axiom,
    ( ~ esk3809_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3679_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_953,axiom,
    ( ~ esk5579_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5774_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_954,axiom,
    ( esk3655_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3720_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_955,axiom,
    ( esk3786_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3591_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_956,axiom,
    ( ~ p(X11)
    | esk2269_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2139_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_957,axiom,
    ( esk6157_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6352_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_958,axiom,
    ( ~ esk5927_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5797_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_959,axiom,
    ( esk3316_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3251_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_960,axiom,
    ( p(X27)
    | esk5235_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5300_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_961,axiom,
    ( ~ esk1820_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2015_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_962,axiom,
    ( esk4882_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25)
    | ~ esk4817_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_963,axiom,
    ( esk3108_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3173_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_964,axiom,
    ( ~ esk2252_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2447_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_965,axiom,
    ( esk6354_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6322_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_966,axiom,
    ( ~ esk321_1(X1)
    | p(X2)
    | esk516_2(X1,X2) ) ).

cnf(i_0_967,axiom,
    ( ~ esk2418_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | esk2613_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_968,axiom,
    ( esk1083_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk953_4(X1,X2,X3,X4) ) ).

cnf(i_0_969,axiom,
    ( esk3945_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3750_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_970,axiom,
    ( ~ p(X13)
    | esk2571_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2376_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_971,axiom,
    ( ~ esk3467_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3597_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_972,axiom,
    ( ~ esk5116_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk4921_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_973,axiom,
    ( p(X19)
    | ~ esk3623_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3818_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_974,axiom,
    ( ~ esk4334_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4139_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_975,axiom,
    ( esk2843_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2713_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_976,axiom,
    ( esk5683_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5618_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_977,axiom,
    ( p(X20)
    | ~ esk3981_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3786_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_978,axiom,
    ( ~ p(X15)
    | esk2976_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2781_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_979,axiom,
    ( ~ esk792_4(X1,X2,X3,X4)
    | esk987_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_980,axiom,
    ( ~ esk5035_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | esk5100_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_981,axiom,
    ( ~ p(X22)
    | ~ esk4126_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4321_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_982,axiom,
    ( p(X5)
    | ~ esk1043_5(X1,X2,X3,X4,X5)
    | esk848_4(X1,X2,X3,X4) ) ).

cnf(i_0_983,axiom,
    ( p(X26)
    | esk5186_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4991_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_984,axiom,
    ( ~ p(X10)
    | ~ esk1887_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2017_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_985,axiom,
    ( p(X8)
    | esk1525_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1590_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_986,axiom,
    ( ~ p(X32)
    | esk6320_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6190_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_987,axiom,
    ( esk946_4(X1,X2,X3,X4)
    | ~ esk1011_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_988,axiom,
    ( p(X8)
    | ~ esk1458_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1653_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_989,axiom,
    ( ~ p(X2)
    | ~ esk518_2(X1,X2)
    | esk388_1(X1) ) ).

cnf(i_0_990,axiom,
    ( esk4601_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4796_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_991,axiom,
    ( ~ esk4783_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4978_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_992,axiom,
    ( esk3390_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | ~ esk3585_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_993,axiom,
    ( esk1839_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2034_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_994,axiom,
    ( esk3714_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | ~ esk3519_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_995,axiom,
    ( ~ esk1258_6(X1,X2,X3,X4,X5,X6)
    | esk1453_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_996,axiom,
    ( ~ esk3160_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3095_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_997,axiom,
    ( ~ esk2936_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2871_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_998,axiom,
    ( ~ esk3833_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | esk3703_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_999,axiom,
    ( p(X24)
    | ~ esk4785_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4590_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1000,axiom,
    ( p(X2)
    | esk306_1(X1)
    | ~ esk501_2(X1,X2) ) ).

cnf(i_0_1001,axiom,
    ( ~ p(X6)
    | esk1152_5(X1,X2,X3,X4,X5)
    | ~ esk1282_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1002,axiom,
    ( ~ esk1578_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1383_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1003,axiom,
    ( ~ esk250_1(X1)
    | esk185_0
    | p(X1) ) ).

cnf(i_0_1004,axiom,
    ( ~ p(X28)
    | esk5488_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5293_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1005,axiom,
    ( esk4799_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4669_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1006,axiom,
    ( ~ esk3802_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3607_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1007,axiom,
    ( ~ esk5381_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | esk5251_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1008,axiom,
    ( esk3637_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3507_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_1009,axiom,
    ( ~ p(X14)
    | esk2757_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2562_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1010,axiom,
    ( esk5130_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5065_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_1011,axiom,
    ( esk888_4(X1,X2,X3,X4)
    | ~ esk693_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1012,axiom,
    ( ~ esk4174_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | esk4044_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1013,axiom,
    ( esk5017_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5082_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1014,axiom,
    ( ~ esk4879_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4814_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_1015,axiom,
    ( ~ esk1890_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk2020_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1016,axiom,
    ( ~ p(X2)
    | esk196_1(X1)
    | ~ esk391_2(X1,X2) ) ).

cnf(i_0_1017,axiom,
    ( ~ p(X28)
    | ~ esk5539_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5409_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1018,axiom,
    ( esk3478_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3543_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_1019,axiom,
    ( ~ p(X26)
    | ~ esk4917_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5112_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1020,axiom,
    ( ~ p(X1)
    | esk252_1(X1)
    | ~ esk57_0 ) ).

cnf(i_0_1021,axiom,
    ( esk5652_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5782_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_1022,axiom,
    ( ~ esk1528_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1658_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_1023,axiom,
    ( esk2803_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2673_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_1024,axiom,
    ( esk328_1(X1)
    | ~ esk458_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1025,axiom,
    ( ~ esk2197_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2392_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_1026,axiom,
    ( p(X23)
    | ~ esk4537_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4472_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1027,axiom,
    ( ~ p(X9)
    | esk1596_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1791_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1028,axiom,
    ( ~ esk5296_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5231_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1029,axiom,
    ( esk2268_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | ~ esk2463_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1030,axiom,
    ( ~ esk3110_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | esk3175_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1031,axiom,
    ( esk6138_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | ~ esk6008_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1032,axiom,
    ( ~ p(X28)
    | ~ esk5528_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5398_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1033,axiom,
    ( ~ p(X24)
    | esk4500_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4695_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1034,axiom,
    ( esk131_0
    | ~ esk196_1(X1)
    | p(X1) ) ).

cnf(i_0_1035,axiom,
    ( esk3869_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | ~ esk3999_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1036,axiom,
    ( ~ esk3109_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | esk3174_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1037,axiom,
    ( esk1837_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1707_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1038,axiom,
    ( esk1146_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1211_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1039,axiom,
    ( ~ esk1001_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk1196_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1040,axiom,
    ( p(X9)
    | ~ esk1788_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1723_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1041,axiom,
    ( ~ esk3432_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3302_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_1042,axiom,
    ( ~ esk3224_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3094_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_1043,axiom,
    ( esk1214_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk1019_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1044,axiom,
    ( ~ esk3194_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk3064_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1045,axiom,
    ( ~ p(X8)
    | ~ esk1384_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1579_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1046,axiom,
    ( ~ esk6164_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6359_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1047,axiom,
    ( p(X16)
    | esk3089_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3154_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1048,axiom,
    ( ~ esk3246_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3116_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_1049,axiom,
    ( ~ esk588_3(X1,X2,X3)
    | esk783_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_1050,axiom,
    ( esk2789_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2724_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1051,axiom,
    ( esk5262_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5392_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1052,axiom,
    ( p(X30)
    | esk5946_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5751_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1053,axiom,
    ( p(X18)
    | ~ esk3478_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3543_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1054,axiom,
    ( esk1446_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1251_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1055,axiom,
    ( esk1880_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1750_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1056,axiom,
    ( ~ esk1862_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1732_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1057,axiom,
    ( ~ esk5480_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5285_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1058,axiom,
    ( ~ p(X25)
    | esk4745_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4940_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1059,axiom,
    ( ~ esk1628_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1433_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1060,axiom,
    ( ~ p(X2)
    | esk216_1(X1)
    | ~ esk411_2(X1,X2) ) ).

cnf(i_0_1061,axiom,
    ( ~ esk3594_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3789_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1062,axiom,
    ( ~ esk5521_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5716_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1063,axiom,
    ( ~ esk5415_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5545_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_1064,axiom,
    ( ~ esk2966_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2771_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_1065,axiom,
    ( esk1988_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1793_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1066,axiom,
    ( ~ esk4425_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | esk4490_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1067,axiom,
    ( ~ esk3073_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3203_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1068,axiom,
    ( ~ esk5069_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5134_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_1069,axiom,
    ( ~ esk4940_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4875_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_1070,axiom,
    ( p(X29)
    | ~ esk5638_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5703_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1071,axiom,
    ( p(X26)
    | esk4978_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5173_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1072,axiom,
    ( esk1524_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1654_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1073,axiom,
    ( esk4527_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4722_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_1074,axiom,
    ( esk1611_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1806_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1075,axiom,
    ( ~ p(X28)
    | ~ esk5274_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5469_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1076,axiom,
    ( ~ p(X6)
    | esk1296_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1166_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1077,axiom,
    ( ~ esk4192_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3997_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_1078,axiom,
    ( esk2225_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2095_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1079,axiom,
    ( ~ esk5167_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | esk4972_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1080,axiom,
    ( p(X2)
    | ~ esk505_2(X1,X2)
    | esk310_1(X1) ) ).

cnf(i_0_1081,axiom,
    ( p(X26)
    | esk5144_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4949_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1082,axiom,
    ( p(X2)
    | esk514_2(X1,X2)
    | ~ esk319_1(X1) ) ).

cnf(i_0_1083,axiom,
    ( ~ esk4028_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3898_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_1084,axiom,
    ( esk4315_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4510_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_1085,axiom,
    ( ~ esk3129_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3064_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_1086,axiom,
    ( ~ esk3634_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3504_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1087,axiom,
    ( ~ esk2653_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2848_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_1088,axiom,
    ( esk1642_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1512_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1089,axiom,
    ( esk1311_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1441_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1090,axiom,
    ( esk1256_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1451_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1091,axiom,
    ( p(X17)
    | ~ esk3390_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3195_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1092,axiom,
    ( esk820_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk755_3(X1,X2,X3) ) ).

cnf(i_0_1093,axiom,
    ( esk719_3(X1,X2,X3)
    | p(X4)
    | ~ esk784_4(X1,X2,X3,X4) ) ).

cnf(i_0_1094,axiom,
    ( ~ esk1155_5(X1,X2,X3,X4,X5)
    | esk1285_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_1095,axiom,
    ( ~ esk1600_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1795_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_1096,axiom,
    ( ~ p(X14)
    | ~ esk2834_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2704_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1097,axiom,
    ( esk2844_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3039_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_1098,axiom,
    ( esk4535_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4340_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_1099,axiom,
    ( ~ esk3168_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3103_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_1100,axiom,
    ( ~ esk900_4(X1,X2,X3,X4)
    | p(X5)
    | esk1095_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1101,axiom,
    ( esk6366_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6236_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_1102,axiom,
    ( ~ esk3891_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4021_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_1103,axiom,
    ( ~ esk1583_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1778_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1104,axiom,
    ( ~ p(X26)
    | ~ esk5199_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5069_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1105,axiom,
    ( ~ p(X1)
    | ~ esk163_0
    | esk293_1(X1) ) ).

cnf(i_0_1106,axiom,
    ( ~ esk2316_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2446_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_1107,axiom,
    ( esk461_2(X1,X2)
    | ~ p(X2)
    | ~ esk331_1(X1) ) ).

cnf(i_0_1108,axiom,
    ( esk1725_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1790_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1109,axiom,
    ( ~ p(X12)
    | esk2424_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2294_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1110,axiom,
    ( p(X11)
    | ~ esk2248_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2053_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1111,axiom,
    ( ~ esk2211_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2016_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_1112,axiom,
    ( ~ esk1390_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1325_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1113,axiom,
    ( ~ esk2247_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2052_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1114,axiom,
    ( esk241_1(X1)
    | p(X1)
    | ~ esk176_0 ) ).

cnf(i_0_1115,axiom,
    ( esk2026_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1896_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_1116,axiom,
    ( ~ esk3532_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3727_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_1117,axiom,
    ( ~ p(X11)
    | esk1991_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2186_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1118,axiom,
    ( ~ esk4484_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4614_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_1119,axiom,
    ( p(X24)
    | esk4716_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4651_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1120,axiom,
    ( ~ esk2109_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2239_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_1121,axiom,
    ( ~ esk3411_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3216_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_1122,axiom,
    ( esk5527_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5397_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_1123,axiom,
    ( esk3801_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3606_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_1124,axiom,
    ( ~ esk2018_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1823_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1125,axiom,
    ( ~ esk2555_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2750_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_1126,axiom,
    ( ~ esk5371_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5176_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_1127,axiom,
    ( ~ esk2907_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2972_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1128,axiom,
    ( esk2636_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | ~ esk2506_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1129,axiom,
    ( ~ p(X16)
    | ~ esk3096_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3226_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1130,axiom,
    ( ~ esk3398_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | esk3268_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1131,axiom,
    ( ~ p(X11)
    | ~ esk2248_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2118_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1132,axiom,
    ( ~ esk2541_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2736_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1133,axiom,
    ( ~ esk4908_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4843_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_1134,axiom,
    ( esk4491_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4426_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_1135,axiom,
    ( esk6033_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6163_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1136,axiom,
    ( ~ p(X1)
    | ~ esk215_1(X1)
    | esk20_0 ) ).

cnf(i_0_1137,axiom,
    ( esk5099_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5034_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_1138,axiom,
    ( ~ esk2242_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | esk2112_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1139,axiom,
    ( esk4454_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | ~ esk4584_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1140,axiom,
    ( ~ esk1163_5(X1,X2,X3,X4,X5)
    | esk1293_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_1141,axiom,
    ( esk420_2(X1,X2)
    | ~ esk225_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_1142,axiom,
    ( esk642_3(X1,X2,X3)
    | ~ esk447_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1143,axiom,
    ( ~ p(X28)
    | esk5566_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5436_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1144,axiom,
    ( ~ esk3566_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3371_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1145,axiom,
    ( ~ p(X9)
    | esk1842_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1712_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1146,axiom,
    ( ~ p(X12)
    | esk2173_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2368_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1147,axiom,
    ( p(X7)
    | esk1337_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1402_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1148,axiom,
    ( ~ p(X25)
    | ~ esk4821_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4951_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1149,axiom,
    ( ~ esk3799_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3669_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_1150,axiom,
    ( ~ esk6165_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6360_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_1151,axiom,
    ( esk2237_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2107_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1152,axiom,
    ( ~ p(X14)
    | ~ esk2771_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2576_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1153,axiom,
    ( ~ p(X32)
    | esk6098_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6293_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1154,axiom,
    ( ~ p(X16)
    | esk3236_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3106_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1155,axiom,
    ( ~ p(X32)
    | esk6350_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6220_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1156,axiom,
    ( ~ p(X26)
    | esk5138_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5008_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1157,axiom,
    ( esk3138_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3073_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1158,axiom,
    ( ~ esk2799_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2994_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1159,axiom,
    ( esk2964_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2899_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_1160,axiom,
    ( ~ esk444_2(X1,X2)
    | esk379_1(X1)
    | p(X2) ) ).

cnf(i_0_1161,axiom,
    ( ~ p(X30)
    | ~ esk5906_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5711_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1162,axiom,
    ( ~ p(X27)
    | esk5263_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5393_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1163,axiom,
    ( p(X23)
    | esk4525_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4460_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1164,axiom,
    ( ~ esk229_1(X1)
    | ~ p(X2)
    | esk424_2(X1,X2) ) ).

cnf(i_0_1165,axiom,
    ( ~ esk4902_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4837_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_1166,axiom,
    ( ~ esk1709_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1774_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9) ) ).

cnf(i_0_1167,axiom,
    ( ~ esk3179_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | esk3114_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1168,axiom,
    ( p(X17)
    | ~ esk3369_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3304_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1169,axiom,
    ( esk1391_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk1196_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1170,axiom,
    ( ~ esk4694_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4889_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1171,axiom,
    ( esk4121_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | ~ esk4056_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1172,axiom,
    ( ~ p(X20)
    | ~ esk3857_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3987_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1173,axiom,
    ( esk6116_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6311_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1174,axiom,
    ( ~ esk556_2(X1,X2)
    | ~ p(X3)
    | esk686_3(X1,X2,X3) ) ).

cnf(i_0_1175,axiom,
    ( ~ p(X16)
    | ~ esk3170_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2975_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1176,axiom,
    ( esk4581_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4386_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1177,axiom,
    ( ~ esk1958_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | esk1763_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1178,axiom,
    ( esk821_4(X1,X2,X3,X4)
    | ~ esk1016_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_1179,axiom,
    ( p(X31)
    | ~ esk5966_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6161_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1180,axiom,
    ( p(X2)
    | esk433_2(X1,X2)
    | ~ esk368_1(X1) ) ).

cnf(i_0_1181,axiom,
    ( esk5930_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6125_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1182,axiom,
    ( esk6182_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6247_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1183,axiom,
    ( ~ esk1766_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk1961_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1184,axiom,
    ( p(X11)
    | esk2040_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2235_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1185,axiom,
    ( ~ esk268_1(X1)
    | esk463_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_1186,axiom,
    ( esk6350_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6252_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6285_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1187,axiom,
    ( ~ p(X26)
    | ~ esk5120_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4925_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1188,axiom,
    ( esk5116_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | ~ esk5051_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1189,axiom,
    ( p(X1)
    | esk266_1(X1)
    | ~ esk71_0 ) ).

cnf(i_0_1190,axiom,
    ( ~ p(X5)
    | esk1025_5(X1,X2,X3,X4,X5)
    | ~ esk830_4(X1,X2,X3,X4) ) ).

cnf(i_0_1191,axiom,
    ( esk6265_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6266_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1192,axiom,
    ( ~ p(X2)
    | esk220_1(X1)
    | ~ esk415_2(X1,X2) ) ).

cnf(i_0_1193,axiom,
    ( p(X16)
    | ~ esk3184_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3119_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1194,axiom,
    ( p(X12)
    | esk2381_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2316_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1195,axiom,
    ( esk2746_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2681_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_1196,axiom,
    ( esk4323_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4258_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1197,axiom,
    ( ~ esk3343_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3148_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_1198,axiom,
    ( ~ p(X26)
    | ~ esk5034_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5164_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1199,axiom,
    ( esk3131_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk2936_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1200,axiom,
    ( ~ p(X21)
    | ~ esk4033_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4163_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1201,axiom,
    ( ~ esk4656_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4721_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_1202,axiom,
    ( esk3854_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | ~ esk3984_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1203,axiom,
    ( p(X2)
    | ~ esk307_1(X1)
    | esk502_2(X1,X2) ) ).

cnf(i_0_1204,axiom,
    ( esk2992_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2862_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1205,axiom,
    ( p(X24)
    | esk4720_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4655_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1206,axiom,
    ( ~ esk3191_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3386_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1207,axiom,
    ( ~ p(X26)
    | esk5128_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4933_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1208,axiom,
    ( p(X19)
    | esk3734_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3669_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1209,axiom,
    ( ~ esk3994_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3864_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_1210,axiom,
    ( esk406_2(X1,X2)
    | ~ esk601_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_1211,axiom,
    ( p(X15)
    | esk3041_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2846_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1212,axiom,
    ( ~ esk4046_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4176_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_1213,axiom,
    ( esk3514_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3449_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_1214,axiom,
    ( esk1829_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | ~ esk2024_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1215,axiom,
    ( p(X29)
    | esk5675_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5610_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1216,axiom,
    ( esk4586_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4456_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_1217,axiom,
    ( ~ esk3716_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3911_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_1218,axiom,
    ( esk703_3(X1,X2,X3)
    | ~ esk573_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1219,axiom,
    ( ~ esk2803_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2998_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1220,axiom,
    ( ~ esk3050_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3245_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_1221,axiom,
    ( ~ esk1060_5(X1,X2,X3,X4,X5)
    | esk930_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_1222,axiom,
    ( esk4283_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | ~ esk4348_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1223,axiom,
    ( ~ esk3353_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3158_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_1224,axiom,
    ( esk5925_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6120_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1225,axiom,
    ( esk6187_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6317_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_1226,axiom,
    ( ~ esk2922_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2987_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1227,axiom,
    ( ~ esk5884_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5689_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_1228,axiom,
    ( ~ p(X7)
    | esk1312_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1442_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1229,axiom,
    ( ~ esk6052_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5857_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_1230,axiom,
    ( esk416_2(X1,X2)
    | ~ p(X3)
    | ~ esk611_3(X1,X2,X3) ) ).

cnf(i_0_1231,axiom,
    ( ~ p(X8)
    | esk1647_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1517_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1232,axiom,
    ( ~ p(X24)
    | esk4639_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4769_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1233,axiom,
    ( esk4182_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | ~ esk3987_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1234,axiom,
    ( esk850_4(X1,X2,X3,X4)
    | ~ esk720_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_1235,axiom,
    ( p(X13)
    | ~ esk2499_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2564_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1236,axiom,
    ( ~ esk5781_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5976_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1237,axiom,
    ( ~ esk435_2(X1,X2)
    | esk240_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_1238,axiom,
    ( ~ p(X29)
    | ~ esk5499_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5694_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1239,axiom,
    ( ~ esk5991_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | esk6121_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1240,axiom,
    ( p(X18)
    | esk3468_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3533_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1241,axiom,
    ( ~ esk2351_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2546_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_1242,axiom,
    ( ~ esk2286_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2351_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1243,axiom,
    ( ~ esk4653_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4783_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_1244,axiom,
    ( esk4210_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | ~ esk4080_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1245,axiom,
    ( esk2442_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2247_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1246,axiom,
    ( ~ p(X26)
    | ~ esk5089_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4894_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1247,axiom,
    ( ~ esk3564_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | esk3499_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1248,axiom,
    ( esk964_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk1094_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1249,axiom,
    ( p(X31)
    | esk6099_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6034_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1250,axiom,
    ( esk6144_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | ~ esk5949_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1251,axiom,
    ( esk6242_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6275_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6340_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1252,axiom,
    ( p(X15)
    | esk2891_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2956_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1253,axiom,
    ( esk6347_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6315_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1254,axiom,
    ( ~ esk5433_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | esk5498_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1255,axiom,
    ( ~ p(X1)
    | esk189_0
    | ~ esk319_1(X1) ) ).

cnf(i_0_1256,axiom,
    ( ~ p(X1)
    | esk174_0
    | ~ esk304_1(X1) ) ).

cnf(i_0_1257,axiom,
    ( esk5648_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5778_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_1258,axiom,
    ( ~ esk167_0
    | esk232_1(X1)
    | p(X1) ) ).

cnf(i_0_1259,axiom,
    ( esk223_1(X1)
    | p(X1)
    | ~ esk158_0 ) ).

cnf(i_0_1260,axiom,
    ( ~ p(X8)
    | ~ esk1372_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1567_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1261,axiom,
    ( ~ esk3505_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3635_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_1262,axiom,
    ( esk1537_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1667_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1263,axiom,
    ( ~ esk4543_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4478_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1264,axiom,
    ( esk2230_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | ~ esk2425_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1265,axiom,
    ( p(X13)
    | ~ esk2454_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2649_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1266,axiom,
    ( esk3021_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2891_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1267,axiom,
    ( ~ esk1826_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | esk1631_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1268,axiom,
    ( p(X32)
    | ~ esk6342_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6147_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1269,axiom,
    ( p(X31)
    | ~ esk5922_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6117_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1270,axiom,
    ( esk876_4(X1,X2,X3,X4)
    | ~ esk1071_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_1271,axiom,
    ( ~ esk4361_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | esk4556_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1272,axiom,
    ( esk1805_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2000_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_1273,axiom,
    ( ~ esk1480_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1350_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_1274,axiom,
    ( esk5136_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5331_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1275,axiom,
    ( p(X18)
    | esk3410_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3605_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1276,axiom,
    ( esk255_1(X1)
    | ~ esk190_0
    | p(X1) ) ).

cnf(i_0_1277,axiom,
    ( p(X23)
    | ~ esk4476_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4541_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1278,axiom,
    ( esk397_2(X1,X2)
    | ~ p(X3)
    | ~ esk592_3(X1,X2,X3) ) ).

cnf(i_0_1279,axiom,
    ( esk2587_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2782_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1280,axiom,
    ( esk2631_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2501_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_1281,axiom,
    ( ~ p(X14)
    | esk2815_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2685_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1282,axiom,
    ( ~ esk855_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk725_3(X1,X2,X3) ) ).

cnf(i_0_1283,axiom,
    ( ~ esk2800_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2995_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1284,axiom,
    ( p(X29)
    | ~ esk5673_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5608_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1285,axiom,
    ( ~ p(X31)
    | ~ esk6141_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6011_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1286,axiom,
    ( p(X13)
    | esk2620_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2425_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1287,axiom,
    ( ~ esk3239_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3434_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_1288,axiom,
    ( ~ p(X23)
    | ~ esk4298_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4493_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1289,axiom,
    ( ~ esk5042_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5172_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_1290,axiom,
    ( esk2258_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2128_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_1291,axiom,
    ( ~ p(X4)
    | esk793_4(X1,X2,X3,X4)
    | ~ esk598_3(X1,X2,X3) ) ).

cnf(i_0_1292,axiom,
    ( p(X7)
    | esk1394_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1329_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1293,axiom,
    ( p(X15)
    | esk2938_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2873_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1294,axiom,
    ( ~ esk2968_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3163_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1295,axiom,
    ( ~ esk5620_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5685_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_1296,axiom,
    ( p(X6)
    | esk1208_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1143_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1297,axiom,
    ( ~ esk6311_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6310_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1298,axiom,
    ( ~ esk4246_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4376_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_1299,axiom,
    ( ~ p(X30)
    | ~ esk5953_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5823_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1300,axiom,
    ( ~ esk2995_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2865_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_1301,axiom,
    ( ~ esk4892_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25)
    | esk4827_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1302,axiom,
    ( esk6278_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6083_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_1303,axiom,
    ( ~ p(X28)
    | ~ esk5545_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5415_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1304,axiom,
    ( esk6102_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5907_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_1305,axiom,
    ( ~ esk5791_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5856_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_1306,axiom,
    ( ~ p(X9)
    | ~ esk1746_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1876_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1307,axiom,
    ( ~ p(X32)
    | ~ esk6326_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6196_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1308,axiom,
    ( esk5530_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5335_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_1309,axiom,
    ( esk3904_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4099_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_1310,axiom,
    ( ~ p(X2)
    | esk250_1(X1)
    | ~ esk445_2(X1,X2) ) ).

cnf(i_0_1311,axiom,
    ( p(X9)
    | ~ esk1864_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1669_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1312,axiom,
    ( esk5582_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5387_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_1313,axiom,
    ( p(X31)
    | esk6124_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5929_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1314,axiom,
    ( ~ esk5562_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5432_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_1315,axiom,
    ( p(X12)
    | esk2448_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2253_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1316,axiom,
    ( ~ p(X24)
    | esk4716_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4521_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1317,axiom,
    ( ~ p(X31)
    | ~ esk6009_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6139_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1318,axiom,
    ( ~ p(X8)
    | ~ esk1559_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1689_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1319,axiom,
    ( ~ p(X10)
    | esk1910_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2040_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1320,axiom,
    ( ~ esk3360_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3555_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_1321,axiom,
    ( esk5190_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5060_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_1322,axiom,
    ( ~ esk5784_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | esk5589_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1323,axiom,
    ( esk6273_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6208_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_1324,axiom,
    ( ~ esk5091_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk4896_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1325,axiom,
    ( ~ esk6054_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5859_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_1326,axiom,
    ( esk4741_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4936_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1327,axiom,
    ( esk4034_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | ~ esk4099_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1328,axiom,
    ( esk5389_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5259_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_1329,axiom,
    ( ~ p(X17)
    | ~ esk3292_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3422_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1330,axiom,
    ( esk1392_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk1327_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1331,axiom,
    ( esk1607_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | ~ esk1412_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1332,axiom,
    ( ~ esk5865_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | esk6060_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1333,axiom,
    ( esk2940_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2745_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1334,axiom,
    ( esk474_2(X1,X2)
    | ~ esk279_1(X1)
    | p(X2) ) ).

cnf(i_0_1335,axiom,
    ( esk1826_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1631_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_1336,axiom,
    ( ~ p(X17)
    | esk3432_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3302_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1337,axiom,
    ( ~ p(X18)
    | esk3493_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3623_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1338,axiom,
    ( ~ p(X10)
    | esk1786_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1981_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1339,axiom,
    ( p(X3)
    | esk462_2(X1,X2)
    | ~ esk657_3(X1,X2,X3) ) ).

cnf(i_0_1340,axiom,
    ( ~ p(X16)
    | esk2968_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3163_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1341,axiom,
    ( ~ esk328_1(X1)
    | esk458_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1342,axiom,
    ( esk2423_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2618_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1343,axiom,
    ( ~ esk3862_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3992_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1344,axiom,
    ( esk1817_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk2012_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1345,axiom,
    ( p(X14)
    | esk2800_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2605_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1346,axiom,
    ( esk1155_5(X1,X2,X3,X4,X5)
    | ~ esk1285_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_1347,axiom,
    ( p(X13)
    | ~ esk2511_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2576_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1348,axiom,
    ( ~ p(X20)
    | ~ esk3970_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3840_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1349,axiom,
    ( ~ esk4240_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4305_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_1350,axiom,
    ( p(X22)
    | esk4287_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4352_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1351,axiom,
    ( ~ esk6295_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | esk6230_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1352,axiom,
    ( ~ p(X2)
    | ~ esk478_2(X1,X2)
    | esk348_1(X1) ) ).

cnf(i_0_1353,axiom,
    ( ~ p(X9)
    | ~ esk1792_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1597_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1354,axiom,
    ( ~ esk4256_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4386_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1355,axiom,
    ( esk4495_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4430_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_1356,axiom,
    ( esk2804_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2999_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_1357,axiom,
    ( p(X24)
    | ~ esk4562_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4757_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1358,axiom,
    ( ~ esk4499_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4304_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1359,axiom,
    ( ~ p(X32)
    | ~ esk6235_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6365_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1360,axiom,
    ( ~ esk3982_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3852_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_1361,axiom,
    ( ~ esk4014_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3819_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_1362,axiom,
    ( esk889_4(X1,X2,X3,X4)
    | ~ esk694_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1363,axiom,
    ( ~ esk1588_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1783_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1364,axiom,
    ( ~ esk5714_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5909_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_1365,axiom,
    ( ~ p(X25)
    | esk4862_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4992_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1366,axiom,
    ( p(X9)
    | ~ esk1833_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1638_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1367,axiom,
    ( p(X8)
    | esk1520_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1585_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1368,axiom,
    ( ~ esk3323_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3128_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_1369,axiom,
    ( esk5779_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | ~ esk5649_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1370,axiom,
    ( esk620_3(X1,X2,X3)
    | ~ p(X3)
    | ~ esk425_2(X1,X2) ) ).

cnf(i_0_1371,axiom,
    ( ~ esk1264_6(X1,X2,X3,X4,X5,X6)
    | esk1134_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1372,axiom,
    ( p(X2)
    | ~ esk497_2(X1,X2)
    | esk302_1(X1) ) ).

cnf(i_0_1373,axiom,
    ( esk6112_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6307_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_1374,axiom,
    ( esk724_3(X1,X2,X3)
    | p(X4)
    | ~ esk789_4(X1,X2,X3,X4) ) ).

cnf(i_0_1375,axiom,
    ( p(X3)
    | ~ esk566_2(X1,X2)
    | esk631_3(X1,X2,X3) ) ).

cnf(i_0_1376,axiom,
    ( ~ esk736_3(X1,X2,X3)
    | esk801_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_1377,axiom,
    ( ~ esk2443_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2313_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1378,axiom,
    ( ~ esk707_3(X1,X2,X3)
    | ~ p(X3)
    | esk577_2(X1,X2) ) ).

cnf(i_0_1379,axiom,
    ( esk2703_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2833_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1380,axiom,
    ( esk232_1(X1)
    | ~ p(X1)
    | ~ esk37_0 ) ).

cnf(i_0_1381,axiom,
    ( p(X10)
    | ~ esk1909_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1974_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1382,axiom,
    ( ~ esk5852_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | esk5657_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1383,axiom,
    ( esk495_2(X1,X2)
    | ~ esk690_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_1384,axiom,
    ( ~ esk2135_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2200_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_1385,axiom,
    ( esk5662_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5597_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_1386,axiom,
    ( ~ p(X27)
    | ~ esk5326_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5131_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1387,axiom,
    ( ~ esk590_3(X1,X2,X3)
    | ~ p(X4)
    | esk785_4(X1,X2,X3,X4) ) ).

cnf(i_0_1388,axiom,
    ( esk4019_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3889_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_1389,axiom,
    ( ~ p(X5)
    | esk947_4(X1,X2,X3,X4)
    | ~ esk1077_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1390,axiom,
    ( esk1850_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1720_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1391,axiom,
    ( esk884_4(X1,X2,X3,X4)
    | ~ esk754_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_1392,axiom,
    ( esk1742_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1872_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1393,axiom,
    ( esk4986_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5181_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_1394,axiom,
    ( ~ p(X8)
    | esk1549_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1679_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1395,axiom,
    ( ~ esk2213_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2083_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_1396,axiom,
    ( p(X17)
    | ~ esk3231_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3426_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1397,axiom,
    ( esk4245_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4310_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_1398,axiom,
    ( esk1424_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1359_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1399,axiom,
    ( esk6344_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6312_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1400,axiom,
    ( ~ p(X4)
    | ~ esk820_4(X1,X2,X3,X4)
    | esk625_3(X1,X2,X3) ) ).

cnf(i_0_1401,axiom,
    ( esk149_0
    | ~ p(X1)
    | ~ esk279_1(X1) ) ).

cnf(i_0_1402,axiom,
    ( esk5543_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | ~ esk5738_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1403,axiom,
    ( ~ esk5304_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5239_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_1404,axiom,
    ( ~ esk2358_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2163_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_1405,axiom,
    ( ~ p(X30)
    | ~ esk5705_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5900_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1406,axiom,
    ( ~ p(X22)
    | esk4410_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4280_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1407,axiom,
    ( ~ esk853_4(X1,X2,X3,X4)
    | p(X4)
    | esk658_3(X1,X2,X3) ) ).

cnf(i_0_1408,axiom,
    ( ~ p(X12)
    | esk2337_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2467_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1409,axiom,
    ( ~ esk2775_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2580_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1410,axiom,
    ( esk5380_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | ~ esk5575_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1411,axiom,
    ( p(X16)
    | ~ esk2994_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3189_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1412,axiom,
    ( p(X31)
    | esk6139_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5944_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1413,axiom,
    ( esk5462_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | ~ esk5657_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1414,axiom,
    ( ~ esk3480_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3545_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1415,axiom,
    ( ~ esk4212_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4017_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_1416,axiom,
    ( p(X25)
    | ~ esk4998_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4803_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1417,axiom,
    ( ~ esk5445_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5510_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_1418,axiom,
    ( p(X9)
    | ~ esk1756_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1691_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1419,axiom,
    ( ~ p(X14)
    | esk2809_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2679_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1420,axiom,
    ( ~ p(X19)
    | ~ esk3782_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3652_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1421,axiom,
    ( p(X1)
    | ~ esk144_0
    | esk209_1(X1) ) ).

cnf(i_0_1422,axiom,
    ( p(X31)
    | esk6081_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6016_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1423,axiom,
    ( p(X22)
    | esk4349_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4284_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1424,axiom,
    ( esk5564_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | ~ esk5434_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1425,axiom,
    ( ~ p(X29)
    | esk5774_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5644_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1426,axiom,
    ( ~ p(X13)
    | ~ esk2606_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2476_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1427,axiom,
    ( ~ esk1685_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1555_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1428,axiom,
    ( esk2221_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2091_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_1429,axiom,
    ( p(X8)
    | ~ esk1435_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1630_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1430,axiom,
    ( ~ esk427_2(X1,X2)
    | esk362_1(X1)
    | p(X2) ) ).

cnf(i_0_1431,axiom,
    ( p(X30)
    | esk5787_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5852_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1432,axiom,
    ( ~ esk3191_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2996_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_1433,axiom,
    ( ~ p(X31)
    | esk6118_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5988_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1434,axiom,
    ( ~ p(X2)
    | ~ esk503_2(X1,X2)
    | esk373_1(X1) ) ).

cnf(i_0_1435,axiom,
    ( esk4424_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4554_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_1436,axiom,
    ( esk4379_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4574_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1437,axiom,
    ( esk2413_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2283_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_1438,axiom,
    ( esk1024_5(X1,X2,X3,X4,X5)
    | ~ esk829_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_1439,axiom,
    ( esk3427_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3232_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1440,axiom,
    ( ~ esk2276_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2406_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_1441,axiom,
    ( esk147_0
    | ~ p(X1)
    | ~ esk277_1(X1) ) ).

cnf(i_0_1442,axiom,
    ( ~ esk53_0
    | esk248_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_1443,axiom,
    ( ~ p(X26)
    | ~ esk5031_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5161_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1444,axiom,
    ( ~ esk5857_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | esk5662_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1445,axiom,
    ( esk3405_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3600_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_1446,axiom,
    ( esk4013_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3818_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_1447,axiom,
    ( ~ esk2720_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2785_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_1448,axiom,
    ( ~ esk4061_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4126_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_1449,axiom,
    ( ~ p(X10)
    | esk2070_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1940_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1450,axiom,
    ( ~ p(X6)
    | ~ esk980_5(X1,X2,X3,X4,X5)
    | esk1175_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1451,axiom,
    ( p(X32)
    | esk6365_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6170_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1452,axiom,
    ( esk6013_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6143_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_1453,axiom,
    ( p(X24)
    | esk4758_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4563_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1454,axiom,
    ( p(X29)
    | ~ esk5526_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5721_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1455,axiom,
    ( ~ p(X9)
    | ~ esk1585_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1780_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1456,axiom,
    ( ~ esk2780_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2975_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_1457,axiom,
    ( esk4523_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4458_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1458,axiom,
    ( esk2209_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2144_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_1459,axiom,
    ( ~ p(X11)
    | ~ esk2190_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1995_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1460,axiom,
    ( ~ esk5632_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5762_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1461,axiom,
    ( ~ p(X17)
    | ~ esk3429_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3299_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1462,axiom,
    ( esk3239_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3109_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1463,axiom,
    ( esk3822_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4017_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_1464,axiom,
    ( p(X18)
    | ~ esk3563_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3498_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1465,axiom,
    ( ~ p(X32)
    | esk6333_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6203_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1466,axiom,
    ( esk827_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk632_3(X1,X2,X3) ) ).

cnf(i_0_1467,axiom,
    ( p(X12)
    | esk2450_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2255_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1468,axiom,
    ( ~ esk3770_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3705_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_1469,axiom,
    ( esk4096_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4291_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_1470,axiom,
    ( ~ p(X29)
    | esk5517_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5712_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1471,axiom,
    ( esk5035_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | ~ esk5165_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1472,axiom,
    ( esk2589_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2524_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1473,axiom,
    ( esk1650_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1845_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9) ) ).

cnf(i_0_1474,axiom,
    ( ~ p(X15)
    | ~ esk2768_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2963_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1475,axiom,
    ( ~ esk1300_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk1495_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1476,axiom,
    ( p(X12)
    | esk2427_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2232_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1477,axiom,
    ( ~ esk347_1(X1)
    | esk477_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1478,axiom,
    ( ~ esk4534_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4339_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1479,axiom,
    ( esk2876_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk3006_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1480,axiom,
    ( ~ esk3555_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | esk3490_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1481,axiom,
    ( esk773_3(X1,X2,X3)
    | ~ esk903_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_1482,axiom,
    ( esk1606_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1411_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1483,axiom,
    ( p(X30)
    | ~ esk5898_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5833_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1484,axiom,
    ( ~ esk4751_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4946_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_1485,axiom,
    ( ~ p(X26)
    | esk5075_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4880_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1486,axiom,
    ( ~ p(X30)
    | ~ esk5909_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5714_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1487,axiom,
    ( ~ esk3363_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3558_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1488,axiom,
    ( ~ esk5606_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5736_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_1489,axiom,
    ( ~ esk4324_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | esk4519_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1490,axiom,
    ( ~ esk1017_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk822_4(X1,X2,X3,X4) ) ).

cnf(i_0_1491,axiom,
    ( ~ esk4348_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4153_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_1492,axiom,
    ( ~ p(X25)
    | esk4845_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4975_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1493,axiom,
    ( esk6044_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6109_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1494,axiom,
    ( esk1839_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | ~ esk1644_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1495,axiom,
    ( p(X13)
    | esk2427_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2622_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1496,axiom,
    ( p(X4)
    | ~ esk802_4(X1,X2,X3,X4)
    | esk737_3(X1,X2,X3) ) ).

cnf(i_0_1497,axiom,
    ( ~ esk1641_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1446_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1498,axiom,
    ( esk2988_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2923_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_1499,axiom,
    ( p(X1)
    | ~ esk182_0
    | esk247_1(X1) ) ).

cnf(i_0_1500,axiom,
    ( ~ esk2851_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2721_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1501,axiom,
    ( p(X5)
    | esk980_5(X1,X2,X3,X4,X5)
    | ~ esk915_4(X1,X2,X3,X4) ) ).

cnf(i_0_1502,axiom,
    ( p(X2)
    | esk404_2(X1,X2)
    | ~ esk339_1(X1) ) ).

cnf(i_0_1503,axiom,
    ( esk5147_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5342_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1504,axiom,
    ( p(X9)
    | esk1717_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1782_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1505,axiom,
    ( esk1664_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1534_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1506,axiom,
    ( ~ esk5995_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | esk6060_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1507,axiom,
    ( p(X11)
    | ~ esk2255_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2060_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1508,axiom,
    ( esk883_4(X1,X2,X3,X4)
    | ~ esk753_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_1509,axiom,
    ( ~ esk6367_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6334_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6335_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1510,axiom,
    ( ~ p(X6)
    | esk1010_5(X1,X2,X3,X4,X5)
    | ~ esk1205_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1511,axiom,
    ( ~ esk2991_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | esk2861_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1512,axiom,
    ( esk3772_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3642_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_1513,axiom,
    ( esk3886_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3951_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_1514,axiom,
    ( ~ esk4532_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4337_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1515,axiom,
    ( ~ esk3981_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | esk4176_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1516,axiom,
    ( ~ esk1838_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1708_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1517,axiom,
    ( ~ esk669_3(X1,X2,X3)
    | esk539_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1518,axiom,
    ( esk483_2(X1,X2)
    | ~ esk288_1(X1)
    | p(X2) ) ).

cnf(i_0_1519,axiom,
    ( ~ esk6358_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6163_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_1520,axiom,
    ( p(X21)
    | ~ esk4223_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4028_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1521,axiom,
    ( p(X13)
    | ~ esk2629_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2434_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1522,axiom,
    ( ~ esk4161_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3966_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_1523,axiom,
    ( ~ esk5082_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk4887_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1524,axiom,
    ( p(X10)
    | ~ esk1968_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1903_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1525,axiom,
    ( p(X8)
    | esk1650_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1455_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1526,axiom,
    ( esk1413_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1218_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_1527,axiom,
    ( ~ esk4554_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4749_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1528,axiom,
    ( esk3602_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3472_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1529,axiom,
    ( esk4951_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5146_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1530,axiom,
    ( esk6267_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6202_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_1531,axiom,
    ( esk5199_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5004_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_1532,axiom,
    ( ~ esk5966_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5836_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_1533,axiom,
    ( ~ esk5509_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5704_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1534,axiom,
    ( ~ p(X29)
    | esk5763_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5633_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1535,axiom,
    ( ~ esk2411_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2216_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1536,axiom,
    ( ~ p(X19)
    | esk3528_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3723_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1537,axiom,
    ( esk1039_5(X1,X2,X3,X4,X5)
    | ~ esk1234_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_1538,axiom,
    ( esk991_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk926_4(X1,X2,X3,X4) ) ).

cnf(i_0_1539,axiom,
    ( esk1757_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1562_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_1540,axiom,
    ( ~ esk6148_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6343_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1541,axiom,
    ( p(X11)
    | esk2017_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2212_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1542,axiom,
    ( ~ esk5949_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | esk5754_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1543,axiom,
    ( ~ esk4655_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4785_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_1544,axiom,
    ( esk369_1(X1)
    | ~ esk499_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_1545,axiom,
    ( esk5841_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5906_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_1546,axiom,
    ( ~ esk5694_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | esk5629_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1547,axiom,
    ( ~ esk4607_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4802_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_1548,axiom,
    ( esk1399_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1204_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_1549,axiom,
    ( ~ p(X25)
    | ~ esk4947_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4817_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1550,axiom,
    ( esk4487_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4682_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1551,axiom,
    ( ~ p(X7)
    | ~ esk1304_6(X1,X2,X3,X4,X5,X6)
    | esk1434_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1552,axiom,
    ( ~ esk4340_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4275_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_1553,axiom,
    ( esk5266_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5071_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_1554,axiom,
    ( ~ esk384_1(X1)
    | p(X2)
    | esk449_2(X1,X2) ) ).

cnf(i_0_1555,axiom,
    ( p(X9)
    | esk1682_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1877_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1556,axiom,
    ( p(X18)
    | esk3557_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3492_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1557,axiom,
    ( ~ p(X29)
    | ~ esk5524_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5719_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1558,axiom,
    ( ~ p(X12)
    | esk2387_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2192_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1559,axiom,
    ( ~ p(X25)
    | ~ esk4832_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4962_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1560,axiom,
    ( ~ esk2180_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | esk1985_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1561,axiom,
    ( ~ esk4498_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4433_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_1562,axiom,
    ( ~ esk310_1(X1)
    | p(X2)
    | esk505_2(X1,X2) ) ).

cnf(i_0_1563,axiom,
    ( p(X22)
    | esk4408_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4213_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1564,axiom,
    ( ~ p(X31)
    | ~ esk6078_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5883_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1565,axiom,
    ( esk4306_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4241_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_1566,axiom,
    ( esk3281_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | ~ esk3411_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1567,axiom,
    ( esk212_1(X1)
    | ~ esk147_0
    | p(X1) ) ).

cnf(i_0_1568,axiom,
    ( p(X7)
    | ~ esk1418_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1353_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1569,axiom,
    ( ~ esk3253_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3383_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1570,axiom,
    ( esk3955_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4150_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_1571,axiom,
    ( ~ p(X27)
    | esk5239_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5369_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1572,axiom,
    ( ~ esk3154_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3349_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_1573,axiom,
    ( esk5180_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4985_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_1574,axiom,
    ( esk3807_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3677_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_1575,axiom,
    ( esk2528_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2593_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1576,axiom,
    ( ~ p(X23)
    | esk4608_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4478_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1577,axiom,
    ( ~ esk310_1(X1)
    | esk180_0
    | ~ p(X1) ) ).

cnf(i_0_1578,axiom,
    ( esk550_2(X1,X2)
    | p(X3)
    | ~ esk615_3(X1,X2,X3) ) ).

cnf(i_0_1579,axiom,
    ( ~ p(X3)
    | ~ esk715_3(X1,X2,X3)
    | esk585_2(X1,X2) ) ).

cnf(i_0_1580,axiom,
    ( ~ esk4007_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3812_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_1581,axiom,
    ( ~ esk500_2(X1,X2)
    | ~ p(X2)
    | esk370_1(X1) ) ).

cnf(i_0_1582,axiom,
    ( ~ p(X6)
    | ~ esk1252_6(X1,X2,X3,X4,X5,X6)
    | esk1122_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1583,axiom,
    ( ~ esk4893_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4698_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_1584,axiom,
    ( ~ p(X18)
    | esk3324_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3519_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1585,axiom,
    ( ~ esk2184_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | esk2379_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1586,axiom,
    ( esk3256_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | ~ esk3321_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1587,axiom,
    ( esk3869_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk3934_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1588,axiom,
    ( esk1970_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1905_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_1589,axiom,
    ( ~ esk5262_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5327_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1590,axiom,
    ( p(X30)
    | ~ esk5749_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5944_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1591,axiom,
    ( esk1567_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1502_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1592,axiom,
    ( esk3731_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | ~ esk3926_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1593,axiom,
    ( ~ esk2519_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2584_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_1594,axiom,
    ( p(X5)
    | ~ esk1080_5(X1,X2,X3,X4,X5)
    | esk885_4(X1,X2,X3,X4) ) ).

cnf(i_0_1595,axiom,
    ( esk275_1(X1)
    | ~ esk80_0
    | p(X1) ) ).

cnf(i_0_1596,axiom,
    ( ~ p(X27)
    | esk5133_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5328_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1597,axiom,
    ( ~ p(X25)
    | ~ esk4984_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4854_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1598,axiom,
    ( esk1808_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk2003_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1599,axiom,
    ( esk2404_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2209_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_1600,axiom,
    ( ~ esk3139_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | esk3074_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1601,axiom,
    ( esk5929_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6124_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31) ) ).

cnf(i_0_1602,axiom,
    ( esk5592_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | ~ esk5722_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1603,axiom,
    ( esk2001_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1936_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_1604,axiom,
    ( esk2780_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk2975_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1605,axiom,
    ( ~ esk4014_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20)
    | esk3884_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1606,axiom,
    ( ~ esk2089_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2154_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_1607,axiom,
    ( ~ p(X25)
    | ~ esk4973_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4843_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1608,axiom,
    ( esk3792_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3662_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_1609,axiom,
    ( esk3422_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3617_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_1610,axiom,
    ( p(X21)
    | esk4187_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3992_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1611,axiom,
    ( esk6186_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6316_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_1612,axiom,
    ( esk3794_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | ~ esk3664_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1613,axiom,
    ( ~ esk4397_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | esk4592_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1614,axiom,
    ( esk1876_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | ~ esk2071_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1615,axiom,
    ( ~ esk425_2(X1,X2)
    | esk230_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_1616,axiom,
    ( esk1382_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk1187_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1617,axiom,
    ( esk4066_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | ~ esk4131_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1618,axiom,
    ( ~ esk3532_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3337_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1619,axiom,
    ( ~ p(X17)
    | ~ esk3320_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3125_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1620,axiom,
    ( esk3420_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3225_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1621,axiom,
    ( ~ esk703_3(X1,X2,X3)
    | esk508_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_1622,axiom,
    ( esk496_2(X1,X2)
    | ~ esk301_1(X1)
    | p(X2) ) ).

cnf(i_0_1623,axiom,
    ( ~ esk5340_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5145_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_1624,axiom,
    ( p(X20)
    | ~ esk4020_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3825_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1625,axiom,
    ( esk2986_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2791_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1626,axiom,
    ( p(X26)
    | esk4955_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5150_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1627,axiom,
    ( ~ esk114_0
    | esk309_1(X1)
    | p(X1) ) ).

cnf(i_0_1628,axiom,
    ( esk3148_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3083_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_1629,axiom,
    ( ~ p(X30)
    | esk5852_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5657_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1630,axiom,
    ( esk2432_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2627_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_1631,axiom,
    ( ~ p(X5)
    | esk1103_5(X1,X2,X3,X4,X5)
    | ~ esk973_4(X1,X2,X3,X4) ) ).

cnf(i_0_1632,axiom,
    ( esk5177_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | ~ esk4982_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1633,axiom,
    ( esk4256_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | ~ esk4386_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1634,axiom,
    ( ~ p(X7)
    | esk1483_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1353_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1635,axiom,
    ( ~ p(X14)
    | esk2592_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2787_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1636,axiom,
    ( ~ p(X28)
    | esk5542_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5412_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1637,axiom,
    ( ~ esk5551_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5746_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1638,axiom,
    ( esk3831_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk4026_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1639,axiom,
    ( p(X13)
    | esk2533_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2598_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1640,axiom,
    ( p(X9)
    | esk1810_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1745_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1641,axiom,
    ( p(X24)
    | esk4620_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4685_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1642,axiom,
    ( p(X1)
    | ~ esk88_0
    | esk283_1(X1) ) ).

cnf(i_0_1643,axiom,
    ( ~ esk765_3(X1,X2,X3)
    | p(X4)
    | esk830_4(X1,X2,X3,X4) ) ).

cnf(i_0_1644,axiom,
    ( ~ esk1953_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1758_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_1645,axiom,
    ( esk1386_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1581_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_1646,axiom,
    ( esk1250_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1445_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_1647,axiom,
    ( p(X2)
    | ~ esk473_2(X1,X2)
    | esk278_1(X1) ) ).

cnf(i_0_1648,axiom,
    ( p(X26)
    | ~ esk4969_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5164_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1649,axiom,
    ( ~ p(X8)
    | ~ esk1583_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1388_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1650,axiom,
    ( ~ esk3751_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3686_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1651,axiom,
    ( ~ esk6223_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6288_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_1652,axiom,
    ( p(X8)
    | esk1619_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1554_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1653,axiom,
    ( ~ p(X32)
    | esk6184_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6314_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1654,axiom,
    ( esk4754_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4624_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_1655,axiom,
    ( esk621_3(X1,X2,X3)
    | ~ esk426_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1656,axiom,
    ( esk4593_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4463_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1657,axiom,
    ( ~ esk2734_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | esk2669_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1658,axiom,
    ( ~ p(X20)
    | ~ esk3852_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3982_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1659,axiom,
    ( ~ esk2639_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2834_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_1660,axiom,
    ( esk4697_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4892_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1661,axiom,
    ( ~ esk3169_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2974_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_1662,axiom,
    ( ~ esk2229_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | esk2099_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1663,axiom,
    ( p(X29)
    | esk5651_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5716_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1664,axiom,
    ( ~ esk2924_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2989_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_1665,axiom,
    ( ~ esk4997_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | esk4867_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1666,axiom,
    ( esk3194_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2999_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_1667,axiom,
    ( esk264_1(X1)
    | ~ p(X1)
    | ~ esk134_0 ) ).

cnf(i_0_1668,axiom,
    ( esk1804_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1609_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_1669,axiom,
    ( p(X20)
    | esk3928_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3863_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1670,axiom,
    ( ~ p(X28)
    | ~ esk5554_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5424_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1671,axiom,
    ( ~ esk4736_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | esk4671_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1672,axiom,
    ( ~ p(X2)
    | ~ esk410_2(X1,X2)
    | esk215_1(X1) ) ).

cnf(i_0_1673,axiom,
    ( esk3227_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3032_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1674,axiom,
    ( ~ p(X8)
    | ~ esk1394_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1589_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1675,axiom,
    ( ~ p(X25)
    | esk4703_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4898_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1676,axiom,
    ( esk161_0
    | ~ esk226_1(X1)
    | p(X1) ) ).

cnf(i_0_1677,axiom,
    ( ~ esk5291_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5486_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_1678,axiom,
    ( ~ esk4356_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4161_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_1679,axiom,
    ( esk3207_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3012_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_1680,axiom,
    ( p(X22)
    | esk4340_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4275_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1681,axiom,
    ( ~ esk3328_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3523_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1682,axiom,
    ( ~ esk1212_6(X1,X2,X3,X4,X5,X6)
    | esk1017_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1683,axiom,
    ( esk1865_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2060_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_1684,axiom,
    ( p(X1)
    | esk87_0
    | ~ esk282_1(X1) ) ).

cnf(i_0_1685,axiom,
    ( esk5895_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5700_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_1686,axiom,
    ( esk2266_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2136_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1687,axiom,
    ( ~ p(X11)
    | esk2219_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2089_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1688,axiom,
    ( ~ esk5917_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6112_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31) ) ).

cnf(i_0_1689,axiom,
    ( ~ esk5112_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5047_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_1690,axiom,
    ( ~ p(X1)
    | ~ esk32_0
    | esk227_1(X1) ) ).

cnf(i_0_1691,axiom,
    ( esk2987_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3182_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1692,axiom,
    ( ~ p(X8)
    | esk1629_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1499_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1693,axiom,
    ( ~ esk1414_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1349_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1694,axiom,
    ( esk3938_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4133_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1695,axiom,
    ( ~ esk773_3(X1,X2,X3)
    | esk903_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_1696,axiom,
    ( esk4186_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | ~ esk3991_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1697,axiom,
    ( ~ esk2490_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2620_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1698,axiom,
    ( esk5024_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5089_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_1699,axiom,
    ( ~ esk3172_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3367_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_1700,axiom,
    ( esk22_0
    | ~ p(X1)
    | ~ esk217_1(X1) ) ).

cnf(i_0_1701,axiom,
    ( ~ esk1640_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1445_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1702,axiom,
    ( esk795_4(X1,X2,X3,X4)
    | ~ esk730_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1703,axiom,
    ( ~ esk4456_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4521_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_1704,axiom,
    ( esk3642_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3772_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_1705,axiom,
    ( p(X18)
    | ~ esk3638_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3443_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1706,axiom,
    ( ~ esk5803_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5933_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_1707,axiom,
    ( ~ esk1666_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1536_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1708,axiom,
    ( esk2241_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2046_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_1709,axiom,
    ( ~ p(X21)
    | ~ esk4166_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4036_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1710,axiom,
    ( ~ p(X18)
    | ~ esk3534_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3339_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1711,axiom,
    ( ~ esk5533_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5403_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1712,axiom,
    ( p(X24)
    | esk4753_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4558_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1713,axiom,
    ( p(X18)
    | ~ esk3407_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3602_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1714,axiom,
    ( ~ esk5249_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5314_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_1715,axiom,
    ( p(X19)
    | ~ esk3675_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3740_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1716,axiom,
    ( esk3631_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3436_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_1717,axiom,
    ( ~ esk3419_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3224_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_1718,axiom,
    ( p(X27)
    | ~ esk5189_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5384_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1719,axiom,
    ( esk3926_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3731_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_1720,axiom,
    ( p(X27)
    | esk5361_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5166_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1721,axiom,
    ( ~ esk4596_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4791_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_1722,axiom,
    ( ~ p(X29)
    | ~ esk5486_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5681_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1723,axiom,
    ( ~ esk5629_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5759_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1724,axiom,
    ( ~ esk2338_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2403_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1725,axiom,
    ( ~ esk2290_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2355_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1726,axiom,
    ( ~ esk2267_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2462_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1727,axiom,
    ( ~ p(X20)
    | esk4006_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3876_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1728,axiom,
    ( ~ esk5660_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | esk5465_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1729,axiom,
    ( ~ esk1417_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1612_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_1730,axiom,
    ( ~ p(X12)
    | esk2358_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2163_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1731,axiom,
    ( esk4383_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4578_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_1732,axiom,
    ( ~ p(X4)
    | esk746_3(X1,X2,X3)
    | ~ esk876_4(X1,X2,X3,X4) ) ).

cnf(i_0_1733,axiom,
    ( ~ esk6143_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5948_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_1734,axiom,
    ( ~ esk2073_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1878_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1735,axiom,
    ( ~ p(X31)
    | ~ esk5996_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6126_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1736,axiom,
    ( p(X10)
    | esk1980_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1915_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1737,axiom,
    ( ~ esk3621_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3426_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_1738,axiom,
    ( esk5409_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5474_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_1739,axiom,
    ( p(X7)
    | esk1483_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1288_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1740,axiom,
    ( ~ esk821_4(X1,X2,X3,X4)
    | p(X4)
    | esk756_3(X1,X2,X3) ) ).

cnf(i_0_1741,axiom,
    ( esk4352_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4287_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_1742,axiom,
    ( ~ p(X14)
    | esk2564_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2759_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1743,axiom,
    ( ~ p(X12)
    | ~ esk2401_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2206_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1744,axiom,
    ( esk5254_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5384_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1745,axiom,
    ( ~ esk1688_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1493_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1746,axiom,
    ( p(X19)
    | ~ esk3605_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3800_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1747,axiom,
    ( p(X12)
    | ~ esk2275_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2470_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1748,axiom,
    ( esk2723_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2788_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_1749,axiom,
    ( ~ esk3981_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20)
    | esk3851_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1750,axiom,
    ( ~ p(X2)
    | esk214_1(X1)
    | ~ esk409_2(X1,X2) ) ).

cnf(i_0_1751,axiom,
    ( ~ p(X23)
    | ~ esk4571_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4441_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1752,axiom,
    ( ~ p(X15)
    | ~ esk2751_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2946_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1753,axiom,
    ( p(X9)
    | esk1645_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1840_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1754,axiom,
    ( ~ esk4253_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4383_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1755,axiom,
    ( ~ esk4740_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4935_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1756,axiom,
    ( p(X9)
    | esk1696_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1761_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1757,axiom,
    ( p(X20)
    | esk3964_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3899_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1758,axiom,
    ( ~ p(X1)
    | esk303_1(X1)
    | ~ esk173_0 ) ).

cnf(i_0_1759,axiom,
    ( p(X28)
    | ~ esk5415_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5480_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1760,axiom,
    ( ~ esk3812_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3617_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1761,axiom,
    ( esk6366_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6268_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6301_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1762,axiom,
    ( ~ esk1983_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1918_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1763,axiom,
    ( p(X10)
    | esk2051_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1856_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1764,axiom,
    ( ~ p(X31)
    | ~ esk5995_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6125_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1765,axiom,
    ( ~ esk466_2(X1,X2)
    | p(X2)
    | esk271_1(X1) ) ).

cnf(i_0_1766,axiom,
    ( esk4085_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | ~ esk4150_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1767,axiom,
    ( ~ esk2476_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2606_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1768,axiom,
    ( ~ p(X20)
    | ~ esk3980_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3850_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1769,axiom,
    ( esk5481_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5416_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_1770,axiom,
    ( esk1681_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1551_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_1771,axiom,
    ( esk711_3(X1,X2,X3)
    | ~ esk516_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_1772,axiom,
    ( p(X9)
    | esk1869_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1674_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1773,axiom,
    ( p(X3)
    | ~ esk548_2(X1,X2)
    | esk613_3(X1,X2,X3) ) ).

cnf(i_0_1774,axiom,
    ( ~ esk6278_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6245_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6343_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1775,axiom,
    ( esk2821_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2626_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1776,axiom,
    ( p(X1)
    | ~ esk174_0
    | esk239_1(X1) ) ).

cnf(i_0_1777,axiom,
    ( ~ esk6369_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | esk6174_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1778,axiom,
    ( p(X21)
    | esk4103_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4038_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1779,axiom,
    ( esk2788_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2983_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_1780,axiom,
    ( esk2641_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | ~ esk2836_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1781,axiom,
    ( ~ esk2762_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2697_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_1782,axiom,
    ( ~ p(X1)
    | esk304_1(X1)
    | ~ esk174_0 ) ).

cnf(i_0_1783,axiom,
    ( ~ esk1965_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2160_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1784,axiom,
    ( ~ esk2087_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2152_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1785,axiom,
    ( ~ esk2061_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1866_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1786,axiom,
    ( ~ esk4196_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4391_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_1787,axiom,
    ( p(X32)
    | esk6302_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6237_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1788,axiom,
    ( esk5960_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5830_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1789,axiom,
    ( ~ esk1908_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2038_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_1790,axiom,
    ( p(X15)
    | esk2836_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3031_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1791,axiom,
    ( ~ esk1572_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1507_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_1792,axiom,
    ( p(X9)
    | ~ esk1669_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1864_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1793,axiom,
    ( p(X24)
    | ~ esk4706_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4641_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1794,axiom,
    ( esk5565_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5435_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_1795,axiom,
    ( ~ p(X19)
    | esk3711_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3516_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1796,axiom,
    ( ~ esk5176_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5371_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1797,axiom,
    ( p(X15)
    | esk2855_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3050_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1798,axiom,
    ( esk2935_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2870_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1799,axiom,
    ( esk3054_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2924_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1800,axiom,
    ( ~ esk3610_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3415_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_1801,axiom,
    ( esk1371_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk1306_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1802,axiom,
    ( ~ p(X32)
    | esk6260_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6065_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1803,axiom,
    ( esk5003_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5198_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1804,axiom,
    ( esk775_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk905_4(X1,X2,X3,X4) ) ).

cnf(i_0_1805,axiom,
    ( ~ p(X13)
    | ~ esk2389_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2584_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1806,axiom,
    ( ~ esk1095_5(X1,X2,X3,X4,X5)
    | p(X5)
    | esk900_4(X1,X2,X3,X4) ) ).

cnf(i_0_1807,axiom,
    ( ~ esk1933_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk2063_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1808,axiom,
    ( esk1382_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk1317_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1809,axiom,
    ( esk6294_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6229_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_1810,axiom,
    ( ~ esk6148_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5953_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1811,axiom,
    ( ~ esk5271_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | esk5466_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1812,axiom,
    ( ~ esk2272_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2467_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_1813,axiom,
    ( esk760_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk890_4(X1,X2,X3,X4) ) ).

cnf(i_0_1814,axiom,
    ( ~ esk1470_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1275_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1815,axiom,
    ( p(X25)
    | ~ esk4887_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4822_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1816,axiom,
    ( ~ p(X13)
    | esk2578_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2383_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1817,axiom,
    ( ~ esk840_4(X1,X2,X3,X4)
    | esk775_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_1818,axiom,
    ( ~ p(X3)
    | ~ esk431_2(X1,X2)
    | esk626_3(X1,X2,X3) ) ).

cnf(i_0_1819,axiom,
    ( p(X18)
    | ~ esk3432_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3627_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1820,axiom,
    ( ~ esk2233_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2428_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_1821,axiom,
    ( p(X1)
    | esk296_1(X1)
    | ~ esk101_0 ) ).

cnf(i_0_1822,axiom,
    ( ~ esk1937_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk2067_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_1823,axiom,
    ( esk3889_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | ~ esk4019_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1824,axiom,
    ( p(X9)
    | esk1767_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1702_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1825,axiom,
    ( esk2023_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1828_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_1826,axiom,
    ( ~ esk3626_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3821_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_1827,axiom,
    ( p(X30)
    | esk5756_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5951_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1828,axiom,
    ( p(X26)
    | ~ esk5161_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4966_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1829,axiom,
    ( p(X7)
    | esk1484_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1289_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1830,axiom,
    ( ~ esk3707_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3642_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1831,axiom,
    ( ~ esk887_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk757_3(X1,X2,X3) ) ).

cnf(i_0_1832,axiom,
    ( p(X3)
    | ~ esk604_3(X1,X2,X3)
    | esk539_2(X1,X2) ) ).

cnf(i_0_1833,axiom,
    ( ~ esk4742_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4937_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_1834,axiom,
    ( ~ esk1218_6(X1,X2,X3,X4,X5,X6)
    | esk1023_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1835,axiom,
    ( esk1562_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1757_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1836,axiom,
    ( esk2362_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2167_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1837,axiom,
    ( p(X24)
    | ~ esk4779_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4584_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1838,axiom,
    ( esk3011_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3206_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_1839,axiom,
    ( ~ p(X27)
    | ~ esk5210_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5340_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1840,axiom,
    ( ~ esk150_0
    | ~ p(X1)
    | esk280_1(X1) ) ).

cnf(i_0_1841,axiom,
    ( p(X2)
    | ~ esk399_2(X1,X2)
    | esk334_1(X1) ) ).

cnf(i_0_1842,axiom,
    ( ~ esk197_1(X1)
    | ~ p(X1)
    | esk2_0 ) ).

cnf(i_0_1843,axiom,
    ( esk1788_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1593_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1844,axiom,
    ( ~ esk6332_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6333_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6365_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1845,axiom,
    ( ~ esk791_4(X1,X2,X3,X4)
    | esk596_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_1846,axiom,
    ( esk1132_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1197_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1847,axiom,
    ( esk1380_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1575_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_1848,axiom,
    ( p(X14)
    | esk2693_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2758_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1849,axiom,
    ( ~ esk871_4(X1,X2,X3,X4)
    | esk1066_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_1850,axiom,
    ( esk5467_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | ~ esk5662_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1851,axiom,
    ( esk2267_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2137_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_1852,axiom,
    ( esk749_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk879_4(X1,X2,X3,X4) ) ).

cnf(i_0_1853,axiom,
    ( esk4659_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4789_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1854,axiom,
    ( ~ esk1014_5(X1,X2,X3,X4,X5)
    | esk949_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_1855,axiom,
    ( ~ esk713_3(X1,X2,X3)
    | esk583_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_1856,axiom,
    ( ~ esk1975_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1910_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_1857,axiom,
    ( p(X26)
    | ~ esk5154_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4959_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1858,axiom,
    ( p(X4)
    | ~ esk785_4(X1,X2,X3,X4)
    | esk720_3(X1,X2,X3) ) ).

cnf(i_0_1859,axiom,
    ( ~ esk4366_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4236_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1860,axiom,
    ( esk1913_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1978_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_1861,axiom,
    ( ~ p(X9)
    | esk1717_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1847_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1862,axiom,
    ( ~ esk4129_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4324_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1863,axiom,
    ( p(X23)
    | esk4573_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4378_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1864,axiom,
    ( ~ p(X23)
    | esk4303_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4498_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1865,axiom,
    ( esk1056_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk861_4(X1,X2,X3,X4) ) ).

cnf(i_0_1866,axiom,
    ( ~ esk1568_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1763_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1867,axiom,
    ( ~ esk4710_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4905_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_1868,axiom,
    ( p(X29)
    | esk5775_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5580_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1869,axiom,
    ( esk2908_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk3038_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1870,axiom,
    ( ~ esk6344_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6214_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_1871,axiom,
    ( ~ esk5756_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5951_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_1872,axiom,
    ( esk2985_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2790_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_1873,axiom,
    ( ~ esk3037_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | esk3232_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1874,axiom,
    ( esk4924_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4729_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_1875,axiom,
    ( ~ p(X28)
    | ~ esk5488_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5293_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1876,axiom,
    ( ~ esk4115_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk4050_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1877,axiom,
    ( ~ p(X27)
    | ~ esk5235_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5365_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1878,axiom,
    ( esk3185_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2990_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_1879,axiom,
    ( esk6253_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6286_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6351_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1880,axiom,
    ~ esk41_0 ).

cnf(i_0_1881,axiom,
    ( ~ esk4487_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4422_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_1882,axiom,
    ( ~ p(X6)
    | ~ esk1029_5(X1,X2,X3,X4,X5)
    | esk1224_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1883,axiom,
    ( ~ esk4497_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4432_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_1884,axiom,
    ( ~ esk3762_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | esk3567_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1885,axiom,
    ( esk2940_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3135_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1886,axiom,
    ( p(X23)
    | ~ esk4463_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4528_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_1887,axiom,
    ( ~ esk3530_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3725_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_1888,axiom,
    ( ~ p(X27)
    | esk5256_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5386_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1889,axiom,
    ( ~ esk2412_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2282_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1890,axiom,
    ( ~ esk1733_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1863_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_1891,axiom,
    ( ~ p(X32)
    | esk6368_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6238_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1892,axiom,
    ( esk2245_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | ~ esk2440_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1893,axiom,
    ( ~ esk3316_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3251_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1894,axiom,
    ( ~ esk6310_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6309_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1895,axiom,
    ( ~ esk5103_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5038_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_1896,axiom,
    ( ~ esk5698_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | esk5503_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1897,axiom,
    ( ~ esk3631_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3436_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_1898,axiom,
    ( esk2895_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2960_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_1899,axiom,
    ( ~ esk3128_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2933_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_1900,axiom,
    ( ~ p(X4)
    | esk830_4(X1,X2,X3,X4)
    | ~ esk635_3(X1,X2,X3) ) ).

cnf(i_0_1901,axiom,
    ( ~ esk3852_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3917_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_1902,axiom,
    ( ~ esk4818_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4883_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_1903,axiom,
    ( ~ esk289_1(X1)
    | esk159_0
    | ~ p(X1) ) ).

cnf(i_0_1904,axiom,
    ( esk4684_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4879_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1905,axiom,
    ( esk5033_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5098_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1906,axiom,
    ( p(X7)
    | ~ esk1266_6(X1,X2,X3,X4,X5,X6)
    | esk1461_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1907,axiom,
    ( ~ esk2865_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2995_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_1908,axiom,
    ( esk5355_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5225_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1909,axiom,
    ( ~ esk262_1(X1)
    | ~ p(X1)
    | esk132_0 ) ).

cnf(i_0_1910,axiom,
    ( esk2162_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | ~ esk2357_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1911,axiom,
    ( p(X8)
    | ~ esk1668_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1473_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1912,axiom,
    ( p(X30)
    | esk5954_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5759_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1913,axiom,
    ( esk5309_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5244_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_1914,axiom,
    ( p(X2)
    | esk372_1(X1)
    | ~ esk437_2(X1,X2) ) ).

cnf(i_0_1915,axiom,
    ( esk403_2(X1,X2)
    | ~ esk598_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_1916,axiom,
    ( ~ esk760_3(X1,X2,X3)
    | p(X4)
    | esk825_4(X1,X2,X3,X4) ) ).

cnf(i_0_1917,axiom,
    ( p(X32)
    | esk6210_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6275_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1918,axiom,
    ( ~ p(X24)
    | esk4506_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4701_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1919,axiom,
    ( ~ esk5932_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5737_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_1920,axiom,
    ( esk4750_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4555_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_1921,axiom,
    ( ~ esk4715_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4650_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_1922,axiom,
    ( ~ esk3455_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3520_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1923,axiom,
    ( p(X30)
    | esk5968_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5773_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1924,axiom,
    ( esk4592_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4462_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1925,axiom,
    ( p(X7)
    | ~ esk1355_6(X1,X2,X3,X4,X5,X6)
    | esk1420_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1926,axiom,
    ( esk2116_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | ~ esk2246_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1927,axiom,
    ( esk1504_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1634_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1928,axiom,
    ( ~ esk5500_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | esk5435_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1929,axiom,
    ( ~ p(X11)
    | ~ esk2015_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2210_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1930,axiom,
    ( esk3434_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | ~ esk3629_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1931,axiom,
    ( ~ p(X32)
    | ~ esk6188_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6318_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_1932,axiom,
    ( p(X29)
    | esk5732_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5537_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_1933,axiom,
    ( p(X13)
    | esk2605_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2410_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1934,axiom,
    ( esk5244_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5309_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_1935,axiom,
    ( ~ esk4727_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4922_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_1936,axiom,
    ( ~ esk1328_6(X1,X2,X3,X4,X5,X6)
    | esk1393_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_1937,axiom,
    ( esk4825_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4955_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1938,axiom,
    ( ~ esk4227_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4292_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1939,axiom,
    ( esk1395_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1330_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_1940,axiom,
    ( esk4610_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4480_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1941,axiom,
    ( esk3401_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | ~ esk3596_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1942,axiom,
    ( p(X18)
    | ~ esk3635_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3440_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1943,axiom,
    ( esk5989_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6119_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_1944,axiom,
    ( esk5623_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | ~ esk5688_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_1945,axiom,
    ( ~ esk2777_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2972_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_1946,axiom,
    ( esk1927_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2057_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_1947,axiom,
    ( esk2530_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2595_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_1948,axiom,
    ( ~ p(X23)
    | esk4585_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4455_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_1949,axiom,
    ( p(X26)
    | esk5095_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5030_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_1950,axiom,
    ( esk6252_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6187_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_1951,axiom,
    ( ~ esk2812_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk3007_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_1952,axiom,
    ( p(X17)
    | ~ esk3379_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3314_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1953,axiom,
    ( ~ p(X9)
    | esk1781_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1586_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1954,axiom,
    ( p(X12)
    | esk2383_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2318_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_1955,axiom,
    ( ~ esk2206_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2141_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_1956,axiom,
    ( ~ p(X19)
    | esk3689_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3819_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1957,axiom,
    ( ~ p(X7)
    | esk1177_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1372_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1958,axiom,
    ( esk1286_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1156_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_1959,axiom,
    ( esk867_4(X1,X2,X3,X4)
    | ~ esk1062_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_1960,axiom,
    ( ~ esk5965_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5835_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_1961,axiom,
    ( ~ esk3986_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3856_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_1962,axiom,
    ( esk5868_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6063_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_1963,axiom,
    ( ~ p(X16)
    | ~ esk3087_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3217_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_1964,axiom,
    ( ~ p(X2)
    | esk335_1(X1)
    | ~ esk465_2(X1,X2) ) ).

cnf(i_0_1965,axiom,
    ( ~ esk4828_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4958_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_1966,axiom,
    ( ~ p(X19)
    | esk3791_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3661_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_1967,axiom,
    ( ~ esk428_2(X1,X2)
    | ~ p(X3)
    | esk623_3(X1,X2,X3) ) ).

cnf(i_0_1968,axiom,
    ( p(X3)
    | esk516_2(X1,X2)
    | ~ esk711_3(X1,X2,X3) ) ).

cnf(i_0_1969,axiom,
    ( ~ p(X19)
    | esk3539_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3734_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1970,axiom,
    ( ~ p(X17)
    | ~ esk3264_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3394_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1971,axiom,
    ( ~ esk4892_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | esk5087_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_1972,axiom,
    ( p(X8)
    | esk1605_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1540_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1973,axiom,
    ( ~ esk2902_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3032_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_1974,axiom,
    ( esk1579_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1774_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_1975,axiom,
    ( esk1364_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1429_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_1976,axiom,
    ( ~ p(X9)
    | ~ esk1851_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1721_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1977,axiom,
    ( ~ esk3207_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3402_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_1978,axiom,
    ( ~ esk4972_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4777_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_1979,axiom,
    ( esk1064_5(X1,X2,X3,X4,X5)
    | ~ esk869_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_1980,axiom,
    ( esk5001_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4806_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_1981,axiom,
    ( ~ p(X21)
    | esk4050_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4180_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1982,axiom,
    ( ~ esk2468_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2273_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_1983,axiom,
    ( ~ esk4306_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | esk4241_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_1984,axiom,
    ( p(X20)
    | esk3859_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3924_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_1985,axiom,
    ( esk1291_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk1096_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1986,axiom,
    ( ~ esk3030_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2835_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_1987,axiom,
    ( esk2264_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | ~ esk2459_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1988,axiom,
    ( ~ p(X19)
    | esk3530_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3725_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_1989,axiom,
    ( esk3618_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3813_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_1990,axiom,
    ( ~ esk4587_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4782_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_1991,axiom,
    ( esk1057_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1252_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_1992,axiom,
    ( esk5216_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5281_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_1993,axiom,
    ( esk974_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk1039_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_1994,axiom,
    ( esk5693_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5628_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_1995,axiom,
    ( ~ p(X9)
    | ~ esk1814_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1619_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_1996,axiom,
    ( esk4313_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4118_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_1997,axiom,
    ( ~ esk5217_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | esk5347_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_1998,axiom,
    ( ~ esk2146_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | esk2341_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_1999,axiom,
    ( esk616_3(X1,X2,X3)
    | ~ esk811_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_2000,axiom,
    ( esk5610_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5675_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_2001,axiom,
    ( p(X23)
    | esk4577_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4382_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2002,axiom,
    ( esk1302_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1432_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2003,axiom,
    ( esk6284_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6251_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6349_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2004,axiom,
    ( esk1510_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk1575_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2005,axiom,
    ( p(X5)
    | ~ esk1030_5(X1,X2,X3,X4,X5)
    | esk965_4(X1,X2,X3,X4) ) ).

cnf(i_0_2006,axiom,
    ( ~ esk5513_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5318_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2007,axiom,
    ( ~ esk2141_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2271_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2008,axiom,
    ( ~ esk967_4(X1,X2,X3,X4)
    | p(X5)
    | esk1032_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2009,axiom,
    ( p(X7)
    | ~ esk1324_6(X1,X2,X3,X4,X5,X6)
    | esk1389_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2010,axiom,
    ( ~ esk5112_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4917_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_2011,axiom,
    ( ~ esk3407_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3277_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_2012,axiom,
    ( ~ esk1240_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk1110_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2013,axiom,
    ( ~ p(X19)
    | ~ esk3682_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3812_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2014,axiom,
    ( ~ p(X8)
    | ~ esk1369_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1564_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2015,axiom,
    ( p(X20)
    | esk3835_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4030_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2016,axiom,
    ( p(X27)
    | ~ esk5241_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5306_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2017,axiom,
    ( esk5768_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5573_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2018,axiom,
    ( ~ esk2287_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2417_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_2019,axiom,
    ( ~ esk4531_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4466_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2020,axiom,
    ( esk3290_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3420_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_2021,axiom,
    ( ~ esk734_3(X1,X2,X3)
    | ~ p(X4)
    | esk864_4(X1,X2,X3,X4) ) ).

cnf(i_0_2022,axiom,
    ( esk5341_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5211_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2023,axiom,
    ( p(X30)
    | esk5858_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5793_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2024,axiom,
    ( ~ p(X22)
    | ~ esk4255_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4385_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2025,axiom,
    ( esk5391_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5261_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_2026,axiom,
    ( p(X29)
    | ~ esk5632_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5697_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2027,axiom,
    ( ~ p(X14)
    | esk2778_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2583_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2028,axiom,
    ( p(X12)
    | ~ esk2216_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2411_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2029,axiom,
    ( esk1405_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1210_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_2030,axiom,
    ( esk4810_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | ~ esk4615_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2031,axiom,
    ( esk6198_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6328_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2032,axiom,
    ( ~ esk6260_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6261_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6293_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2033,axiom,
    ( esk6161_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6031_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_2034,axiom,
    ( esk3929_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20)
    | ~ esk3734_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2035,axiom,
    ( p(X11)
    | esk2234_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2039_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2036,axiom,
    ( ~ p(X17)
    | ~ esk3408_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3278_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2037,axiom,
    ( ~ esk3508_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3573_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_2038,axiom,
    ( esk3807_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3612_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_2039,axiom,
    ( ~ esk1282_6(X1,X2,X3,X4,X5,X6)
    | esk1477_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_2040,axiom,
    ( esk555_2(X1,X2)
    | p(X3)
    | ~ esk620_3(X1,X2,X3) ) ).

cnf(i_0_2041,axiom,
    ( ~ p(X14)
    | ~ esk2563_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2758_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2042,axiom,
    ( esk448_2(X1,X2)
    | ~ esk253_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2043,axiom,
    ( ~ p(X5)
    | ~ esk791_4(X1,X2,X3,X4)
    | esk986_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2044,axiom,
    ( ~ p(X25)
    | esk4864_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4994_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2045,axiom,
    ( ~ esk1880_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2075_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2046,axiom,
    ( esk2472_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2537_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2047,axiom,
    ( esk1839_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1709_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2048,axiom,
    ( esk321_1(X1)
    | p(X2)
    | ~ esk516_2(X1,X2) ) ).

cnf(i_0_2049,axiom,
    ( esk3441_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3636_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_2050,axiom,
    ( esk189_0
    | p(X1)
    | ~ esk254_1(X1) ) ).

cnf(i_0_2051,axiom,
    ( ~ p(X22)
    | ~ esk4385_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4255_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2052,axiom,
    ( esk5438_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5568_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2053,axiom,
    ( p(X20)
    | esk3927_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3862_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2054,axiom,
    ( ~ esk4319_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4514_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_2055,axiom,
    ( ~ p(X21)
    | esk3910_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4105_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2056,axiom,
    ( ~ esk3932_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3867_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_2057,axiom,
    ( ~ esk3628_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | esk3433_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2058,axiom,
    ( esk480_2(X1,X2)
    | ~ esk350_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2059,axiom,
    ( esk5098_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5293_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2060,axiom,
    ( esk668_3(X1,X2,X3)
    | p(X3)
    | ~ esk473_2(X1,X2) ) ).

cnf(i_0_2061,axiom,
    ( ~ p(X7)
    | esk1213_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1408_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2062,axiom,
    ( ~ p(X9)
    | ~ esk1762_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1567_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2063,axiom,
    ( esk5416_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | ~ esk5481_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2064,axiom,
    ( esk571_2(X1,X2)
    | ~ p(X3)
    | ~ esk701_3(X1,X2,X3) ) ).

cnf(i_0_2065,axiom,
    ( esk3039_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2844_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_2066,axiom,
    ( ~ esk3588_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3783_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2067,axiom,
    ( esk4125_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4060_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_2068,axiom,
    ( ~ esk2175_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1980_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_2069,axiom,
    ( esk5257_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5387_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2070,axiom,
    ( ~ p(X13)
    | esk2343_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2538_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2071,axiom,
    ( ~ esk1066_5(X1,X2,X3,X4,X5)
    | esk871_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_2072,axiom,
    ( esk3678_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3808_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2073,axiom,
    ( ~ p(X12)
    | ~ esk2448_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2318_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2074,axiom,
    ( ~ p(X5)
    | esk997_5(X1,X2,X3,X4,X5)
    | ~ esk802_4(X1,X2,X3,X4) ) ).

cnf(i_0_2075,axiom,
    ( ~ esk1036_5(X1,X2,X3,X4,X5)
    | esk1231_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_2076,axiom,
    ( p(X3)
    | esk603_3(X1,X2,X3)
    | ~ esk538_2(X1,X2) ) ).

cnf(i_0_2077,axiom,
    ( p(X5)
    | esk956_4(X1,X2,X3,X4)
    | ~ esk1021_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2078,axiom,
    ( esk5131_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk4936_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2079,axiom,
    ( esk4282_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4347_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_2080,axiom,
    ( esk586_3(X1,X2,X3)
    | ~ esk521_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2081,axiom,
    ( p(X2)
    | esk420_2(X1,X2)
    | ~ esk355_1(X1) ) ).

cnf(i_0_2082,axiom,
    ( esk5827_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5957_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2083,axiom,
    ( esk2739_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2934_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_2084,axiom,
    ( p(X14)
    | esk2747_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2682_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2085,axiom,
    ( esk6110_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5915_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_2086,axiom,
    ( p(X15)
    | ~ esk3027_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2832_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2087,axiom,
    ( esk4844_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4974_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_2088,axiom,
    ( esk5401_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | ~ esk5466_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2089,axiom,
    ( esk1210_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1405_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2090,axiom,
    ( esk2353_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2288_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_2091,axiom,
    ( ~ esk1889_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1954_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2092,axiom,
    ( ~ esk1186_6(X1,X2,X3,X4,X5,X6)
    | esk1121_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_2093,axiom,
    ( esk3237_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3432_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_2094,axiom,
    ( p(X14)
    | esk2721_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2786_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2095,axiom,
    ( ~ esk4312_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4507_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_2096,axiom,
    ( ~ esk1179_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk1114_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2097,axiom,
    ( esk2028_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2223_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2098,axiom,
    ( esk4147_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3952_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_2099,axiom,
    ( p(X1)
    | esk325_1(X1)
    | ~ esk130_0 ) ).

cnf(i_0_2100,axiom,
    ( ~ esk2354_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2289_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2101,axiom,
    ( ~ esk3547_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3742_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_2102,axiom,
    ( ~ esk6173_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5978_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2103,axiom,
    ( esk1150_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk1280_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2104,axiom,
    ~ esk46_0 ).

cnf(i_0_2105,axiom,
    ( ~ esk5572_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | esk5377_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2106,axiom,
    ( ~ p(X3)
    | ~ esk406_2(X1,X2)
    | esk601_3(X1,X2,X3) ) ).

cnf(i_0_2107,axiom,
    ( p(X27)
    | esk5262_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5327_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2108,axiom,
    ( ~ esk6285_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | esk6090_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2109,axiom,
    ( ~ p(X26)
    | ~ esk5127_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4932_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2110,axiom,
    ( ~ p(X5)
    | ~ esk928_4(X1,X2,X3,X4)
    | esk1058_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2111,axiom,
    ( p(X26)
    | ~ esk5123_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5058_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2112,axiom,
    ( esk5824_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5889_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_2113,axiom,
    ( esk5423_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5553_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2114,axiom,
    ( esk563_2(X1,X2)
    | p(X3)
    | ~ esk628_3(X1,X2,X3) ) ).

cnf(i_0_2115,axiom,
    ( esk3693_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3823_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2116,axiom,
    ( ~ p(X29)
    | ~ esk5689_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5494_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2117,axiom,
    ( ~ p(X21)
    | ~ esk4082_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4212_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2118,axiom,
    ( esk3135_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3070_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_2119,axiom,
    ( p(X9)
    | esk1646_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1841_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2120,axiom,
    ( esk5215_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5345_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_2121,axiom,
    ( esk6347_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6282_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6249_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2122,axiom,
    ( esk2548_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2353_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_2123,axiom,
    ( ~ esk678_3(X1,X2,X3)
    | ~ p(X3)
    | esk548_2(X1,X2) ) ).

cnf(i_0_2124,axiom,
    ( ~ esk4547_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4482_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_2125,axiom,
    ( p(X6)
    | ~ esk1257_6(X1,X2,X3,X4,X5,X6)
    | esk1062_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2126,axiom,
    ( ~ p(X29)
    | esk5490_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5685_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2127,axiom,
    ( esk3234_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3104_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2128,axiom,
    ( ~ esk2181_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1986_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_2129,axiom,
    ( p(X11)
    | ~ esk2084_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2149_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2130,axiom,
    ( ~ esk5928_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5733_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_2131,axiom,
    ( p(X25)
    | ~ esk4954_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4759_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2132,axiom,
    ( esk3122_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3317_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_2133,axiom,
    ( ~ esk5971_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5841_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_2134,axiom,
    ( esk3601_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3471_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_2135,axiom,
    ( ~ esk2427_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2622_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_2136,axiom,
    ( ~ esk5530_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5400_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2137,axiom,
    ( ~ esk1382_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1317_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_2138,axiom,
    ( ~ esk4005_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4200_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_2139,axiom,
    ( ~ esk4262_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4327_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2140,axiom,
    ( p(X17)
    | ~ esk3199_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3394_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2141,axiom,
    ( ~ esk5855_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5660_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_2142,axiom,
    ( ~ p(X2)
    | esk427_2(X1,X2)
    | ~ esk232_1(X1) ) ).

cnf(i_0_2143,axiom,
    ( esk198_1(X1)
    | ~ esk3_0
    | ~ p(X1) ) ).

cnf(i_0_2144,axiom,
    ( ~ p(X25)
    | ~ esk4907_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4712_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2145,axiom,
    ( ~ esk2650_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2520_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_2146,axiom,
    ( esk1361_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1426_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2147,axiom,
    ( ~ esk5615_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5680_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2148,axiom,
    ( ~ esk1547_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk1677_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2149,axiom,
    ( esk4719_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4524_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2150,axiom,
    ( esk5886_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6081_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_2151,axiom,
    ( ~ esk5802_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5932_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_2152,axiom,
    ( ~ esk5479_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5284_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2153,axiom,
    ( ~ p(X14)
    | ~ esk2768_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2573_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2154,axiom,
    ( ~ esk2365_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2300_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_2155,axiom,
    ( ~ p(X4)
    | ~ esk615_3(X1,X2,X3)
    | esk810_4(X1,X2,X3,X4) ) ).

cnf(i_0_2156,axiom,
    ( ~ p(X3)
    | esk632_3(X1,X2,X3)
    | ~ esk437_2(X1,X2) ) ).

cnf(i_0_2157,axiom,
    ( p(X6)
    | esk1288_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1093_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2158,axiom,
    ( ~ esk424_2(X1,X2)
    | p(X2)
    | esk359_1(X1) ) ).

cnf(i_0_2159,axiom,
    ( esk856_4(X1,X2,X3,X4)
    | ~ esk726_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_2160,axiom,
    ( esk619_3(X1,X2,X3)
    | ~ esk554_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2161,axiom,
    ( ~ esk4920_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4855_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_2162,axiom,
    ( ~ esk4735_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4930_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2163,axiom,
    ( esk1073_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk943_4(X1,X2,X3,X4) ) ).

cnf(i_0_2164,axiom,
    ( esk343_1(X1)
    | ~ esk473_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_2165,axiom,
    ( esk1346_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1476_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2166,axiom,
    ( ~ esk5506_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5311_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_2167,axiom,
    ( esk2429_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2299_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_2168,axiom,
    ( esk6036_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6166_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_2169,axiom,
    ( ~ esk4294_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4489_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_2170,axiom,
    ( esk5373_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5568_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_2171,axiom,
    ( esk5761_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5956_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_2172,axiom,
    ( ~ esk5594_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5659_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2173,axiom,
    ( ~ esk2777_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2582_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2174,axiom,
    ( esk2917_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3047_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_2175,axiom,
    ( esk4817_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4882_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2176,axiom,
    ( ~ p(X20)
    | ~ esk3948_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3753_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2177,axiom,
    ( ~ esk5179_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk5049_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2178,axiom,
    ( esk3376_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3181_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_2179,axiom,
    ( esk5073_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5268_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2180,axiom,
    ( ~ esk5578_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5773_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_2181,axiom,
    ( esk3552_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3357_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2182,axiom,
    ( ~ esk3690_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3820_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2183,axiom,
    ( ~ esk2077_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1947_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_2184,axiom,
    ( p(X4)
    | ~ esk775_3(X1,X2,X3)
    | esk840_4(X1,X2,X3,X4) ) ).

cnf(i_0_2185,axiom,
    ( p(X5)
    | esk1017_5(X1,X2,X3,X4,X5)
    | ~ esk952_4(X1,X2,X3,X4) ) ).

cnf(i_0_2186,axiom,
    ( esk5962_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5767_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_2187,axiom,
    ( ~ p(X3)
    | ~ esk654_3(X1,X2,X3)
    | esk524_2(X1,X2) ) ).

cnf(i_0_2188,axiom,
    ( ~ esk6120_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6315_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_2189,axiom,
    ( ~ esk4869_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4934_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_2190,axiom,
    ( ~ p(X19)
    | ~ esk3729_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3534_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2191,axiom,
    ( p(X4)
    | ~ esk864_4(X1,X2,X3,X4)
    | esk669_3(X1,X2,X3) ) ).

cnf(i_0_2192,axiom,
    ( esk5135_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk4940_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2193,axiom,
    ( ~ esk6286_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | esk6221_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2194,axiom,
    ( esk5825_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5955_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_2195,axiom,
    ( esk1702_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1832_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_2196,axiom,
    ( p(X14)
    | ~ esk2751_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2686_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2197,axiom,
    ( ~ esk3252_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3382_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_2198,axiom,
    ( ~ p(X1)
    | esk231_1(X1)
    | ~ esk36_0 ) ).

cnf(i_0_2199,axiom,
    ( p(X21)
    | ~ esk4121_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4056_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2200,axiom,
    ( p(X15)
    | esk2884_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2949_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2201,axiom,
    ( esk5548_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | ~ esk5418_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2202,axiom,
    ( ~ esk1799_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1604_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2203,axiom,
    ( p(X11)
    | ~ esk2182_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2117_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2204,axiom,
    ( esk4689_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4494_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_2205,axiom,
    ( ~ esk3623_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3428_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_2206,axiom,
    ( ~ p(X1)
    | esk185_0
    | ~ esk315_1(X1) ) ).

cnf(i_0_2207,axiom,
    ( ~ esk4226_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4291_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_2208,axiom,
    ( ~ esk4809_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk5004_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2209,axiom,
    ( ~ p(X29)
    | esk5614_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5744_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2210,axiom,
    ( ~ esk3810_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3615_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2211,axiom,
    ( esk1824_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2019_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2212,axiom,
    ( p(X25)
    | ~ esk4756_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4951_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2213,axiom,
    ( ~ esk1463_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1268_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_2214,axiom,
    ( ~ esk3144_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2949_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_2215,axiom,
    ( ~ esk804_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk999_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2216,axiom,
    ( ~ p(X18)
    | ~ esk3578_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3448_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2217,axiom,
    ( esk3438_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | ~ esk3633_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2218,axiom,
    ( esk3296_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3361_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_2219,axiom,
    ( esk3123_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3058_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_2220,axiom,
    ( ~ p(X17)
    | ~ esk3133_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3328_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2221,axiom,
    ( ~ esk412_2(X1,X2)
    | esk347_1(X1)
    | p(X2) ) ).

cnf(i_0_2222,axiom,
    ( esk5925_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5795_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2223,axiom,
    ( esk1306_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1436_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2224,axiom,
    ( esk129_0
    | ~ esk324_1(X1)
    | p(X1) ) ).

cnf(i_0_2225,axiom,
    ( esk5628_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5693_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_2226,axiom,
    ( ~ esk2263_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2133_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_2227,axiom,
    ( ~ p(X10)
    | esk1766_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1961_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2228,axiom,
    ( ~ esk4859_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4924_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2229,axiom,
    ( esk5531_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | ~ esk5336_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2230,axiom,
    ( p(X25)
    | esk4879_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4814_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2231,axiom,
    ( ~ p(X6)
    | ~ esk1290_6(X1,X2,X3,X4,X5,X6)
    | esk1160_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2232,axiom,
    ( ~ p(X20)
    | esk3921_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3726_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2233,axiom,
    ( esk3632_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3502_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2234,axiom,
    ( ~ p(X32)
    | esk6219_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6349_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2235,axiom,
    ( ~ esk1676_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | esk1871_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2236,axiom,
    ( esk729_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk859_4(X1,X2,X3,X4) ) ).

cnf(i_0_2237,axiom,
    ( esk4609_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4479_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_2238,axiom,
    ( p(X2)
    | ~ esk513_2(X1,X2)
    | esk318_1(X1) ) ).

cnf(i_0_2239,axiom,
    ( esk4476_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4541_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_2240,axiom,
    ( esk1176_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1371_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_2241,axiom,
    ~ esk40_0 ).

cnf(i_0_2242,axiom,
    ( ~ p(X17)
    | ~ esk3282_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3412_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2243,axiom,
    ( p(X5)
    | ~ esk1064_5(X1,X2,X3,X4,X5)
    | esk869_4(X1,X2,X3,X4) ) ).

cnf(i_0_2244,axiom,
    ( ~ p(X27)
    | ~ esk5275_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5080_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2245,axiom,
    ( ~ p(X15)
    | esk3053_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2923_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2246,axiom,
    ( esk4503_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4698_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_2247,axiom,
    ( ~ esk3036_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2906_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_2248,axiom,
    ( ~ p(X2)
    | ~ esk205_1(X1)
    | esk400_2(X1,X2) ) ).

cnf(i_0_2249,axiom,
    ( esk3879_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4009_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_2250,axiom,
    ( esk885_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk755_3(X1,X2,X3) ) ).

cnf(i_0_2251,axiom,
    ( ~ p(X26)
    | ~ esk5145_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5015_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2252,axiom,
    ( p(X13)
    | esk2641_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2446_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2253,axiom,
    ( p(X21)
    | esk3989_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4184_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2254,axiom,
    ( esk1967_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1902_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_2255,axiom,
    ( ~ p(X22)
    | ~ esk4247_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4377_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2256,axiom,
    ( p(X22)
    | ~ esk4325_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4260_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2257,axiom,
    ( ~ esk1051_5(X1,X2,X3,X4,X5)
    | esk921_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_2258,axiom,
    ( ~ esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6286_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2259,axiom,
    ( esk1760_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk1955_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2260,axiom,
    ( esk4220_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4415_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_2261,axiom,
    ( p(X28)
    | ~ esk5564_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5369_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2262,axiom,
    ( ~ esk2069_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1874_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2263,axiom,
    ( ~ esk6129_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5934_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2264,axiom,
    ( ~ esk3181_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2986_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_2265,axiom,
    ( esk2137_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2267_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_2266,axiom,
    ( ~ esk996_5(X1,X2,X3,X4,X5)
    | esk931_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_2267,axiom,
    ( ~ p(X29)
    | esk5511_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5706_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2268,axiom,
    ( ~ esk4496_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4301_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_2269,axiom,
    ( esk1020_5(X1,X2,X3,X4,X5)
    | ~ esk825_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_2270,axiom,
    ( p(X21)
    | esk4110_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4045_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2271,axiom,
    ( ~ esk4126_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | esk3931_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2272,axiom,
    ( esk6050_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6245_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2273,axiom,
    ( esk3963_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3898_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_2274,axiom,
    ( p(X23)
    | ~ esk4470_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4535_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2275,axiom,
    ( ~ p(X9)
    | esk1827_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1697_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2276,axiom,
    ( esk4746_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | ~ esk4551_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2277,axiom,
    ( ~ esk3758_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3693_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2278,axiom,
    ( esk1156_5(X1,X2,X3,X4,X5)
    | ~ esk1221_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_2279,axiom,
    ( ~ p(X14)
    | ~ esk2858_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2728_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2280,axiom,
    ( p(X20)
    | ~ esk3817_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4012_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2281,axiom,
    ( ~ p(X15)
    | esk2932_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2737_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2282,axiom,
    ( ~ esk4026_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3896_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_2283,axiom,
    ( ~ p(X29)
    | esk5624_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5754_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2284,axiom,
    ( ~ esk5337_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | esk5532_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2285,axiom,
    ( esk2309_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2374_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_2286,axiom,
    ( ~ esk668_3(X1,X2,X3)
    | p(X3)
    | esk473_2(X1,X2) ) ).

cnf(i_0_2287,axiom,
    ( ~ esk4173_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk3978_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2288,axiom,
    ( esk5371_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5566_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_2289,axiom,
    ( p(X17)
    | ~ esk3401_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3206_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2290,axiom,
    ( ~ esk476_2(X1,X2)
    | esk346_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2291,axiom,
    ( esk5185_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | ~ esk4990_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2292,axiom,
    ( esk2921_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | ~ esk2986_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2293,axiom,
    ( ~ esk4095_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4160_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_2294,axiom,
    ( p(X24)
    | ~ esk4761_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4566_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2295,axiom,
    ( ~ esk2055_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2250_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_2296,axiom,
    ( esk3718_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3523_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_2297,axiom,
    ( ~ esk363_1(X1)
    | esk493_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_2298,axiom,
    ( esk5757_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5562_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_2299,axiom,
    ( esk447_2(X1,X2)
    | ~ p(X3)
    | ~ esk642_3(X1,X2,X3) ) ).

cnf(i_0_2300,axiom,
    ( ~ esk2064_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1934_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_2301,axiom,
    ( ~ esk4423_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4553_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_2302,axiom,
    ( esk1060_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk865_4(X1,X2,X3,X4) ) ).

cnf(i_0_2303,axiom,
    ( ~ esk4361_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | esk4166_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2304,axiom,
    ( ~ esk208_1(X1)
    | p(X1)
    | esk143_0 ) ).

cnf(i_0_2305,axiom,
    ( p(X31)
    | ~ esk6162_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5967_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2306,axiom,
    ( ~ p(X25)
    | esk4893_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4698_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2307,axiom,
    ( ~ esk2635_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2440_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_2308,axiom,
    ( esk5435_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5565_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_2309,axiom,
    ( ~ esk4692_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4887_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2310,axiom,
    ( esk236_1(X1)
    | ~ esk171_0
    | p(X1) ) ).

cnf(i_0_2311,axiom,
    ( ~ esk4783_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | esk4653_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2312,axiom,
    ( ~ p(X32)
    | ~ esk6228_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6358_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2313,axiom,
    ( p(X23)
    | ~ esk4530_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4465_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2314,axiom,
    ( ~ p(X18)
    | esk3499_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3629_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2315,axiom,
    ( ~ p(X8)
    | ~ esk1419_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1614_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2316,axiom,
    ( ~ esk699_3(X1,X2,X3)
    | ~ p(X3)
    | esk569_2(X1,X2) ) ).

cnf(i_0_2317,axiom,
    ( esk584_2(X1,X2)
    | p(X3)
    | ~ esk649_3(X1,X2,X3) ) ).

cnf(i_0_2318,axiom,
    ( esk3846_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3911_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_2319,axiom,
    ( esk3011_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2881_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_2320,axiom,
    ( p(X17)
    | ~ esk3198_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3393_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2321,axiom,
    ( p(X1)
    | ~ esk286_1(X1)
    | esk91_0 ) ).

cnf(i_0_2322,axiom,
    ( ~ esk4998_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5193_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_2323,axiom,
    ( ~ esk5066_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5131_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_2324,axiom,
    ( p(X1)
    | ~ esk297_1(X1)
    | esk102_0 ) ).

cnf(i_0_2325,axiom,
    ( esk5351_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5156_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_2326,axiom,
    ( ~ p(X20)
    | esk3891_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4021_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2327,axiom,
    ( ~ esk4452_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4582_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_2328,axiom,
    ( esk1489_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1684_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_2329,axiom,
    ( ~ p(X21)
    | esk4076_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4206_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2330,axiom,
    ( ~ esk1000_5(X1,X2,X3,X4,X5)
    | esk805_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_2331,axiom,
    ( ~ p(X23)
    | ~ esk4490_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4295_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2332,axiom,
    ( p(X10)
    | esk1827_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2022_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2333,axiom,
    ( esk2152_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk1957_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2334,axiom,
    ( ~ esk5059_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5124_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_2335,axiom,
    ( esk4401_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4206_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_2336,axiom,
    ( ~ esk6086_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5891_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_2337,axiom,
    ( ~ esk3909_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4104_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_2338,axiom,
    ( p(X23)
    | ~ esk4589_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4394_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2339,axiom,
    ( ~ p(X27)
    | ~ esk5300_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5105_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2340,axiom,
    ( esk3888_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3953_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_2341,axiom,
    ( ~ p(X17)
    | esk3147_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3342_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2342,axiom,
    ( p(X6)
    | ~ esk1121_5(X1,X2,X3,X4,X5)
    | esk1186_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2343,axiom,
    ( ~ esk2308_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2438_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_2344,axiom,
    ( esk1960_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1765_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2345,axiom,
    ( esk5413_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5478_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_2346,axiom,
    ( p(X24)
    | esk4574_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4769_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2347,axiom,
    ( esk980_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk785_4(X1,X2,X3,X4) ) ).

cnf(i_0_2348,axiom,
    ( ~ p(X12)
    | ~ esk2434_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2304_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2349,axiom,
    ( p(X14)
    | esk2826_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2631_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2350,axiom,
    ( esk320_1(X1)
    | ~ p(X1)
    | ~ esk190_0 ) ).

cnf(i_0_2351,axiom,
    ( esk1078_5(X1,X2,X3,X4,X5)
    | ~ esk1273_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_2352,axiom,
    ( esk2815_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2620_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2353,axiom,
    ( ~ esk4874_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4939_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_2354,axiom,
    ( ~ esk323_1(X1)
    | esk518_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_2355,axiom,
    ( ~ esk5428_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | esk5493_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2356,axiom,
    ( p(X16)
    | esk3183_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3118_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2357,axiom,
    ( esk287_1(X1)
    | ~ esk157_0
    | ~ p(X1) ) ).

cnf(i_0_2358,axiom,
    ( esk2259_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | ~ esk2454_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2359,axiom,
    ( p(X17)
    | ~ esk3338_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3273_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2360,axiom,
    ( esk2381_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | ~ esk2576_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2361,axiom,
    ( ~ esk4657_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4722_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_2362,axiom,
    ( ~ p(X21)
    | ~ esk4088_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4218_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2363,axiom,
    ( ~ esk6212_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6342_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_2364,axiom,
    ( esk4075_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4205_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_2365,axiom,
    ( ~ esk1125_5(X1,X2,X3,X4,X5)
    | esk1190_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_2366,axiom,
    ( p(X13)
    | ~ esk2614_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2419_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2367,axiom,
    ( p(X14)
    | ~ esk2659_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2854_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2368,axiom,
    ( ~ esk2682_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2812_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2369,axiom,
    ( p(X15)
    | esk2936_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2871_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2370,axiom,
    ( p(X4)
    | ~ esk903_4(X1,X2,X3,X4)
    | esk708_3(X1,X2,X3) ) ).

cnf(i_0_2371,axiom,
    ( esk4723_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4918_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_2372,axiom,
    ( ~ esk5099_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | esk5034_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2373,axiom,
    ( esk2086_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2151_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_2374,axiom,
    ( esk4032_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4162_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2375,axiom,
    ( ~ esk540_2(X1,X2)
    | ~ p(X3)
    | esk670_3(X1,X2,X3) ) ).

cnf(i_0_2376,axiom,
    ( ~ esk276_1(X1)
    | ~ p(X1)
    | esk146_0 ) ).

cnf(i_0_2377,axiom,
    ( esk2002_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1937_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_2378,axiom,
    ( p(X15)
    | ~ esk2817_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3012_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2379,axiom,
    ( ~ esk2825_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2695_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2380,axiom,
    ( esk1449_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk1319_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2381,axiom,
    ( ~ esk3435_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3630_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2382,axiom,
    ( p(X4)
    | ~ esk705_3(X1,X2,X3)
    | esk900_4(X1,X2,X3,X4) ) ).

cnf(i_0_2383,axiom,
    ( ~ esk2822_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk3017_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2384,axiom,
    ( ~ p(X23)
    | ~ esk4539_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4344_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2385,axiom,
    ( ~ p(X15)
    | ~ esk2878_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3008_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2386,axiom,
    ( esk5274_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5469_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_2387,axiom,
    ( ~ esk6194_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6324_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_2388,axiom,
    ( ~ esk5206_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | esk5336_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2389,axiom,
    ( esk3428_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3298_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_2390,axiom,
    ( esk3508_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3573_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_2391,axiom,
    ( ~ esk2063_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1868_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2392,axiom,
    ( ~ esk4679_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4744_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2393,axiom,
    ( p(X13)
    | ~ esk2481_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2546_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2394,axiom,
    ( esk4004_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3809_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2395,axiom,
    ( p(X30)
    | ~ esk5810_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5875_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2396,axiom,
    ( ~ esk4544_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4739_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_2397,axiom,
    ( p(X13)
    | ~ esk2478_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2543_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2398,axiom,
    ( ~ esk2459_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2654_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_2399,axiom,
    ( esk4365_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | ~ esk4235_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2400,axiom,
    ( ~ p(X5)
    | esk1048_5(X1,X2,X3,X4,X5)
    | ~ esk918_4(X1,X2,X3,X4) ) ).

cnf(i_0_2401,axiom,
    ( ~ esk400_2(X1,X2)
    | ~ p(X3)
    | esk595_3(X1,X2,X3) ) ).

cnf(i_0_2402,axiom,
    ( p(X31)
    | ~ esk6138_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5943_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2403,axiom,
    ( ~ esk1011_5(X1,X2,X3,X4,X5)
    | esk1206_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_2404,axiom,
    ( ~ esk2728_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2793_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_2405,axiom,
    ( ~ p(X17)
    | ~ esk3147_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3342_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2406,axiom,
    ( esk2806_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2676_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2407,axiom,
    ( esk4744_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4549_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_2408,axiom,
    ( ~ esk4645_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4710_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2409,axiom,
    ( esk852_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk722_3(X1,X2,X3) ) ).

cnf(i_0_2410,axiom,
    ( ~ p(X6)
    | esk1215_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1020_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2411,axiom,
    ( esk1080_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk885_4(X1,X2,X3,X4) ) ).

cnf(i_0_2412,axiom,
    ( esk992_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk927_4(X1,X2,X3,X4) ) ).

cnf(i_0_2413,axiom,
    ( p(X1)
    | esk269_1(X1)
    | ~ esk74_0 ) ).

cnf(i_0_2414,axiom,
    ( p(X20)
    | esk3777_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3972_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2415,axiom,
    ( esk5302_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5237_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2416,axiom,
    ( p(X4)
    | esk875_4(X1,X2,X3,X4)
    | ~ esk680_3(X1,X2,X3) ) ).

cnf(i_0_2417,axiom,
    ( esk1522_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk1587_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2418,axiom,
    ( esk6064_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6259_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2419,axiom,
    ( ~ esk1367_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1562_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_2420,axiom,
    ( ~ esk505_2(X1,X2)
    | esk700_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_2421,axiom,
    ( ~ esk1318_6(X1,X2,X3,X4,X5,X6)
    | esk1383_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_2422,axiom,
    ( esk1589_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1524_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_2423,axiom,
    ( ~ esk4622_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4687_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2424,axiom,
    ( ~ p(X24)
    | esk4541_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4736_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2425,axiom,
    ( p(X23)
    | ~ esk4418_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4613_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2426,axiom,
    ( ~ esk3923_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3858_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_2427,axiom,
    ( ~ p(X22)
    | esk4345_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4150_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2428,axiom,
    ( ~ p(X17)
    | ~ esk3285_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3415_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2429,axiom,
    ( esk2591_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2526_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_2430,axiom,
    ( esk900_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk770_3(X1,X2,X3) ) ).

cnf(i_0_2431,axiom,
    ( ~ esk1778_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1973_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_2432,axiom,
    ( esk1753_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1883_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2433,axiom,
    ( esk1265_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1460_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2434,axiom,
    ( p(X17)
    | ~ esk3422_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3227_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2435,axiom,
    ( esk3530_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3465_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_2436,axiom,
    ( esk641_3(X1,X2,X3)
    | ~ esk576_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2437,axiom,
    ( esk4647_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4777_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_2438,axiom,
    ( ~ esk6350_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6318_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6317_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2439,axiom,
    ( p(X21)
    | esk4147_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4082_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2440,axiom,
    ( esk4070_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4135_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_2441,axiom,
    ( ~ p(X4)
    | ~ esk893_4(X1,X2,X3,X4)
    | esk763_3(X1,X2,X3) ) ).

cnf(i_0_2442,axiom,
    ( esk5346_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5216_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2443,axiom,
    ( ~ esk2430_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2300_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2444,axiom,
    ( ~ esk2939_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2874_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_2445,axiom,
    ( ~ esk3215_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | esk3020_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2446,axiom,
    ( esk2460_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2265_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2447,axiom,
    ( ~ esk6261_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6260_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2448,axiom,
    ( esk1421_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1616_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_2449,axiom,
    ( ~ esk3788_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3593_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2450,axiom,
    ( esk5975_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6170_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2451,axiom,
    ( p(X15)
    | ~ esk2852_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3047_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2452,axiom,
    ( p(X24)
    | esk4679_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4744_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2453,axiom,
    ( ~ p(X11)
    | ~ esk2212_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2082_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2454,axiom,
    ( esk1928_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2058_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_2455,axiom,
    ( ~ esk5746_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5941_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2456,axiom,
    ( ~ esk6153_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5958_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2457,axiom,
    ( esk534_2(X1,X2)
    | p(X3)
    | ~ esk599_3(X1,X2,X3) ) ).

cnf(i_0_2458,axiom,
    ( esk3549_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3354_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2459,axiom,
    ( ~ p(X3)
    | esk550_2(X1,X2)
    | ~ esk680_3(X1,X2,X3) ) ).

cnf(i_0_2460,axiom,
    ( ~ esk3459_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3524_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2461,axiom,
    ( esk1853_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1723_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_2462,axiom,
    ( ~ esk3046_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2916_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_2463,axiom,
    ( p(X22)
    | esk4261_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4326_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2464,axiom,
    ( ~ esk3228_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3033_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_2465,axiom,
    ( p(X31)
    | esk6062_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5997_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2466,axiom,
    ( ~ esk525_2(X1,X2)
    | ~ p(X3)
    | esk655_3(X1,X2,X3) ) ).

cnf(i_0_2467,axiom,
    ( esk3762_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3697_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2468,axiom,
    ( esk1867_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1672_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_2469,axiom,
    ( ~ esk1011_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk816_4(X1,X2,X3,X4) ) ).

cnf(i_0_2470,axiom,
    ( ~ p(X5)
    | esk790_4(X1,X2,X3,X4)
    | ~ esk985_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2471,axiom,
    ( p(X13)
    | esk2549_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2484_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2472,axiom,
    ( ~ esk6311_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | esk6181_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2473,axiom,
    ( p(X14)
    | ~ esk2624_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2819_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2474,axiom,
    ( p(X23)
    | ~ esk4369_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4564_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2475,axiom,
    ( ~ p(X8)
    | esk1412_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1607_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2476,axiom,
    ( esk1785_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk1980_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2477,axiom,
    ( ~ esk666_3(X1,X2,X3)
    | esk471_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2478,axiom,
    ( esk1791_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk1986_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2479,axiom,
    ( ~ esk2549_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | esk2484_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2480,axiom,
    ( ~ esk5551_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | esk5356_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2481,axiom,
    ( p(X15)
    | esk3053_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2858_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2482,axiom,
    ( esk4851_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4916_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_2483,axiom,
    ( esk3908_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3843_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_2484,axiom,
    ( ~ esk4210_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4405_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2485,axiom,
    ( ~ p(X15)
    | ~ esk2922_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3052_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2486,axiom,
    ( ~ esk2119_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2249_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_2487,axiom,
    ( p(X26)
    | esk5189_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4994_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2488,axiom,
    ( esk3362_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | ~ esk3167_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2489,axiom,
    ( ~ esk4676_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4741_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_2490,axiom,
    ( ~ esk6364_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6266_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6299_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2491,axiom,
    ( ~ esk3202_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3072_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_2492,axiom,
    ( ~ esk555_2(X1,X2)
    | esk685_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_2493,axiom,
    ( ~ p(X6)
    | ~ esk1185_6(X1,X2,X3,X4,X5,X6)
    | esk990_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2494,axiom,
    ( ~ esk3171_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3366_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2495,axiom,
    ( ~ esk1980_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2175_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_2496,axiom,
    ( ~ esk866_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk736_3(X1,X2,X3) ) ).

cnf(i_0_2497,axiom,
    ( ~ esk374_1(X1)
    | p(X2)
    | esk439_2(X1,X2) ) ).

cnf(i_0_2498,axiom,
    ( ~ esk5659_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5594_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_2499,axiom,
    ( p(X27)
    | esk5155_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5350_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2500,axiom,
    ( p(X9)
    | ~ esk1847_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1652_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2501,axiom,
    ( p(X29)
    | esk5553_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5748_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2502,axiom,
    ( ~ esk646_3(X1,X2,X3)
    | esk841_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_2503,axiom,
    ( esk5196_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5391_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_2504,axiom,
    ( esk902_4(X1,X2,X3,X4)
    | ~ esk1097_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_2505,axiom,
    ( ~ p(X5)
    | ~ esk1062_5(X1,X2,X3,X4,X5)
    | esk932_4(X1,X2,X3,X4) ) ).

cnf(i_0_2506,axiom,
    ( ~ esk1310_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk1440_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2507,axiom,
    ( p(X3)
    | esk680_3(X1,X2,X3)
    | ~ esk485_2(X1,X2) ) ).

cnf(i_0_2508,axiom,
    ( ~ esk1545_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1675_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_2509,axiom,
    ( esk613_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk808_4(X1,X2,X3,X4) ) ).

cnf(i_0_2510,axiom,
    ( ~ esk5619_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5749_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2511,axiom,
    ( ~ esk4767_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4637_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_2512,axiom,
    ( ~ esk2730_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2860_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_2513,axiom,
    ( ~ p(X30)
    | ~ esk5797_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5927_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2514,axiom,
    ( esk961_4(X1,X2,X3,X4)
    | ~ esk1091_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_2515,axiom,
    ( ~ p(X29)
    | ~ esk5484_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5679_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2516,axiom,
    ( ~ esk5143_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk5013_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2517,axiom,
    ( esk423_2(X1,X2)
    | ~ p(X3)
    | ~ esk618_3(X1,X2,X3) ) ).

cnf(i_0_2518,axiom,
    ( esk4301_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4236_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_2519,axiom,
    ( p(X15)
    | ~ esk2928_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2863_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2520,axiom,
    ( esk847_4(X1,X2,X3,X4)
    | ~ esk717_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_2521,axiom,
    ( ~ esk1880_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | esk1685_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2522,axiom,
    ( esk5735_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5605_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_2523,axiom,
    ( esk6330_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6331_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2524,axiom,
    ( esk4223_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | ~ esk4093_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2525,axiom,
    ( esk455_2(X1,X2)
    | ~ esk260_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2526,axiom,
    ( p(X2)
    | esk520_2(X1,X2)
    | ~ esk325_1(X1) ) ).

cnf(i_0_2527,axiom,
    ( p(X2)
    | esk513_2(X1,X2)
    | ~ esk318_1(X1) ) ).

cnf(i_0_2528,axiom,
    ( p(X17)
    | esk3429_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3234_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2529,axiom,
    ( esk3328_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3263_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2530,axiom,
    ( ~ esk3203_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3008_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_2531,axiom,
    ( ~ esk3663_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3793_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2532,axiom,
    ( ~ p(X19)
    | ~ esk3698_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3828_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2533,axiom,
    ( esk6164_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6034_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_2534,axiom,
    ( esk3616_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3486_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2535,axiom,
    ( ~ esk2722_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2787_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_2536,axiom,
    ( p(X25)
    | esk4980_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4785_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2537,axiom,
    ( ~ p(X10)
    | ~ esk2007_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1812_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2538,axiom,
    ( esk2943_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3138_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_2539,axiom,
    ( esk3175_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk2980_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2540,axiom,
    ( p(X3)
    | ~ esk527_2(X1,X2)
    | esk592_3(X1,X2,X3) ) ).

cnf(i_0_2541,axiom,
    ( p(X32)
    | esk6368_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6173_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2542,axiom,
    ( p(X29)
    | esk5587_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5782_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2543,axiom,
    ( p(X2)
    | ~ esk314_1(X1)
    | esk509_2(X1,X2) ) ).

cnf(i_0_2544,axiom,
    ( esk3823_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3693_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_2545,axiom,
    ( esk2445_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2250_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2546,axiom,
    ( esk5025_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5090_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2547,axiom,
    ( ~ p(X21)
    | ~ esk3929_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4124_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2548,axiom,
    ( ~ esk3934_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3739_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_2549,axiom,
    ( ~ esk567_2(X1,X2)
    | ~ p(X3)
    | esk697_3(X1,X2,X3) ) ).

cnf(i_0_2550,axiom,
    ( esk5824_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5954_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2551,axiom,
    ( p(X10)
    | ~ esk1924_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1989_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2552,axiom,
    ( esk1689_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1884_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9) ) ).

cnf(i_0_2553,axiom,
    ( ~ esk6123_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6318_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2554,axiom,
    ( ~ esk5178_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | esk4983_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2555,axiom,
    ( p(X21)
    | ~ esk4100_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4035_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2556,axiom,
    ( esk4068_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4198_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2557,axiom,
    ( esk3620_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3490_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2558,axiom,
    ( esk1883_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2078_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2559,axiom,
    ( ~ p(X27)
    | ~ esk5258_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5388_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2560,axiom,
    ( ~ esk4183_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4378_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2561,axiom,
    ( esk5687_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5622_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2562,axiom,
    ( esk1656_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1461_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_2563,axiom,
    ( ~ p(X9)
    | esk1840_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1710_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2564,axiom,
    ( esk4670_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | ~ esk4735_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2565,axiom,
    ( esk1494_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1689_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_2566,axiom,
    ( esk5830_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5960_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2567,axiom,
    ( p(X14)
    | ~ esk2604_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2799_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2568,axiom,
    ( ~ esk2405_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2210_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2569,axiom,
    ( esk4526_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4461_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2570,axiom,
    ( esk1927_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1992_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2571,axiom,
    ( esk2727_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2857_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2572,axiom,
    ( ~ esk6260_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6293_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6358_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2573,axiom,
    ( ~ esk3735_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3670_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_2574,axiom,
    ( esk2662_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | ~ esk2857_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2575,axiom,
    ( ~ p(X21)
    | ~ esk4167_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4037_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2576,axiom,
    ( ~ p(X3)
    | esk615_3(X1,X2,X3)
    | ~ esk420_2(X1,X2) ) ).

cnf(i_0_2577,axiom,
    ( p(X11)
    | esk2111_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2176_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2578,axiom,
    ( p(X28)
    | ~ esk5541_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5346_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2579,axiom,
    ( ~ esk5329_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5264_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2580,axiom,
    ( ~ p(X14)
    | esk2735_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2540_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2581,axiom,
    ( esk5364_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | ~ esk5559_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2582,axiom,
    ( esk6358_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6163_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_2583,axiom,
    ( ~ p(X9)
    | ~ esk1699_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1829_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2584,axiom,
    ( ~ p(X22)
    | esk4117_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4312_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2585,axiom,
    ( esk5113_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5308_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_2586,axiom,
    ( esk5716_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5651_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2587,axiom,
    ( ~ esk2403_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2598_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2588,axiom,
    ( ~ p(X5)
    | ~ esk988_5(X1,X2,X3,X4,X5)
    | esk793_4(X1,X2,X3,X4) ) ).

cnf(i_0_2589,axiom,
    ( esk1460_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1265_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_2590,axiom,
    ( esk6243_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6275_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6242_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2591,axiom,
    ( ~ esk3941_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | esk4136_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2592,axiom,
    ( p(X12)
    | ~ esk2375_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2310_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2593,axiom,
    ( esk1930_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2060_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_2594,axiom,
    ( ~ esk4983_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | esk4853_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2595,axiom,
    ( esk4774_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4969_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_2596,axiom,
    ( ~ p(X21)
    | ~ esk3936_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4131_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2597,axiom,
    ( ~ p(X27)
    | ~ esk5133_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5328_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2598,axiom,
    ( esk5018_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | ~ esk5148_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2599,axiom,
    esk66_0 ).

cnf(i_0_2600,axiom,
    ( ~ esk413_2(X1,X2)
    | esk218_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2601,axiom,
    ( ~ esk2637_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | esk2832_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2602,axiom,
    ( esk1390_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1585_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_2603,axiom,
    ( ~ esk3487_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3552_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_2604,axiom,
    ( esk5550_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5355_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_2605,axiom,
    ( p(X7)
    | esk1455_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1260_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2606,axiom,
    ( p(X18)
    | esk3450_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3515_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2607,axiom,
    ( esk5228_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5293_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2608,axiom,
    ( esk6291_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6259_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2609,axiom,
    ( ~ esk5759_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5564_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_2610,axiom,
    ( ~ esk1393_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1588_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_2611,axiom,
    ( esk327_1(X1)
    | ~ esk457_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_2612,axiom,
    ( ~ p(X24)
    | esk4620_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4750_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2613,axiom,
    ( esk1604_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1539_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2614,axiom,
    ( esk134_0
    | p(X1)
    | ~ esk199_1(X1) ) ).

cnf(i_0_2615,axiom,
    ( ~ esk3372_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3307_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2616,axiom,
    ( ~ p(X9)
    | esk1565_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1760_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2617,axiom,
    ( esk1563_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1758_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2618,axiom,
    ( ~ esk1788_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk1983_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2619,axiom,
    ( p(X23)
    | esk4415_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4610_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2620,axiom,
    ( ~ esk5368_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5173_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2621,axiom,
    ( p(X2)
    | ~ esk336_1(X1)
    | esk401_2(X1,X2) ) ).

cnf(i_0_2622,axiom,
    ( ~ esk1908_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1973_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2623,axiom,
    ( ~ p(X30)
    | ~ esk5712_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5907_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2624,axiom,
    ( ~ p(X31)
    | ~ esk6067_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5872_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2625,axiom,
    ( ~ p(X22)
    | esk4279_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4409_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2626,axiom,
    ( ~ esk1763_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1568_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2627,axiom,
    ( esk1273_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | ~ esk1078_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2628,axiom,
    ( ~ esk608_3(X1,X2,X3)
    | p(X3)
    | esk543_2(X1,X2) ) ).

cnf(i_0_2629,axiom,
    ( p(X4)
    | ~ esk696_3(X1,X2,X3)
    | esk891_4(X1,X2,X3,X4) ) ).

cnf(i_0_2630,axiom,
    ( ~ p(X4)
    | esk835_4(X1,X2,X3,X4)
    | ~ esk640_3(X1,X2,X3) ) ).

cnf(i_0_2631,axiom,
    ( esk1858_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1728_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_2632,axiom,
    ( esk2683_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | ~ esk2748_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2633,axiom,
    ( ~ p(X8)
    | ~ esk1648_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1518_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2634,axiom,
    ( ~ esk696_3(X1,X2,X3)
    | esk501_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2635,axiom,
    ( ~ esk969_4(X1,X2,X3,X4)
    | p(X5)
    | esk1034_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2636,axiom,
    ( p(X30)
    | ~ esk5904_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5839_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2637,axiom,
    ( ~ p(X19)
    | esk3831_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3701_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2638,axiom,
    ( ~ esk4029_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | esk3834_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2639,axiom,
    ( esk6171_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6366_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2640,axiom,
    ( esk886_4(X1,X2,X3,X4)
    | ~ esk691_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_2641,axiom,
    ( esk1999_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | ~ esk2194_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2642,axiom,
    ( p(X18)
    | ~ esk3512_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3447_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2643,axiom,
    ( esk1367_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1172_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_2644,axiom,
    ( esk3766_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | ~ esk3571_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2645,axiom,
    ( ~ p(X32)
    | ~ esk6333_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6203_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2646,axiom,
    ( esk2047_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2242_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_2647,axiom,
    ( esk1529_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1659_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2648,axiom,
    ( esk6329_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6330_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2649,axiom,
    ( p(X9)
    | ~ esk1812_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1747_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2650,axiom,
    ( ~ p(X13)
    | ~ esk2610_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2480_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2651,axiom,
    ( esk1668_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1863_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2652,axiom,
    ( esk3515_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3320_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2653,axiom,
    ( ~ p(X30)
    | ~ esk5826_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5956_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2654,axiom,
    ( esk2953_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2888_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2655,axiom,
    ( ~ esk1962_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2157_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2656,axiom,
    ( ~ esk4864_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4994_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_2657,axiom,
    ( ~ esk1212_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk1407_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2658,axiom,
    ( ~ p(X7)
    | esk1375_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1180_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2659,axiom,
    ( ~ esk640_3(X1,X2,X3)
    | esk575_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2660,axiom,
    ( ~ esk1621_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1426_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_2661,axiom,
    ( esk6032_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6162_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2662,axiom,
    ( ~ esk3376_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | esk3181_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2663,axiom,
    ( ~ esk5029_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5094_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_2664,axiom,
    ( p(X4)
    | ~ esk725_3(X1,X2,X3)
    | esk790_4(X1,X2,X3,X4) ) ).

cnf(i_0_2665,axiom,
    ( esk2694_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2759_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_2666,axiom,
    ( p(X20)
    | esk3946_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3881_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2667,axiom,
    ( ~ p(X18)
    | esk3519_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3324_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2668,axiom,
    ( esk5342_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5212_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2669,axiom,
    ( p(X21)
    | ~ esk4193_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3998_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2670,axiom,
    ( esk6330_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6135_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_2671,axiom,
    ( ~ esk465_2(X1,X2)
    | p(X3)
    | esk660_3(X1,X2,X3) ) ).

cnf(i_0_2672,axiom,
    ( p(X8)
    | ~ esk1593_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1528_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2673,axiom,
    ( esk5308_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5243_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_2674,axiom,
    ( ~ esk5367_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | esk5237_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2675,axiom,
    ( esk922_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk987_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2676,axiom,
    ( ~ esk2086_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2216_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_2677,axiom,
    ( esk1988_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | ~ esk1923_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2678,axiom,
    ( ~ esk846_4(X1,X2,X3,X4)
    | esk651_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_2679,axiom,
    ( ~ p(X3)
    | esk625_3(X1,X2,X3)
    | ~ esk430_2(X1,X2) ) ).

cnf(i_0_2680,axiom,
    ( ~ p(X23)
    | esk4475_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4605_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2681,axiom,
    ( ~ p(X27)
    | esk5390_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5260_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2682,axiom,
    ( esk422_2(X1,X2)
    | ~ esk227_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2683,axiom,
    ( esk4623_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4753_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2684,axiom,
    ( ~ p(X7)
    | ~ esk1354_6(X1,X2,X3,X4,X5,X6)
    | esk1484_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2685,axiom,
    ( esk6159_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6354_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2686,axiom,
    ( esk2380_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2315_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2687,axiom,
    ( p(X8)
    | ~ esk1602_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1537_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2688,axiom,
    ( p(X31)
    | ~ esk6104_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6039_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2689,axiom,
    ( ~ p(X8)
    | esk1400_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1595_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2690,axiom,
    ( ~ p(X18)
    | ~ esk3468_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3598_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2691,axiom,
    ( ~ esk6352_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6320_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6319_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2692,axiom,
    ( ~ esk6122_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5992_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_2693,axiom,
    ( ~ esk3678_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3743_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2694,axiom,
    ( esk177_0
    | ~ esk242_1(X1)
    | p(X1) ) ).

cnf(i_0_2695,axiom,
    ( p(X9)
    | ~ esk1735_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1800_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2696,axiom,
    ( ~ p(X21)
    | ~ esk3945_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4140_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2697,axiom,
    ( ~ esk2630_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2435_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_2698,axiom,
    ( ~ esk2119_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2184_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_2699,axiom,
    ( p(X14)
    | esk2661_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2856_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2700,axiom,
    ( ~ esk4728_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | esk4533_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2701,axiom,
    ( ~ p(X15)
    | ~ esk2919_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3049_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2702,axiom,
    ( esk3584_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3454_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2703,axiom,
    ( esk3000_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2805_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_2704,axiom,
    ( p(X32)
    | esk6293_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6228_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2705,axiom,
    ( ~ esk955_4(X1,X2,X3,X4)
    | esk1020_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_2706,axiom,
    ( esk901_4(X1,X2,X3,X4)
    | ~ esk706_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_2707,axiom,
    ( ~ esk3147_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk2952_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2708,axiom,
    ( p(X19)
    | ~ esk3807_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3612_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2709,axiom,
    ( ~ p(X1)
    | esk42_0
    | ~ esk237_1(X1) ) ).

cnf(i_0_2710,axiom,
    ( ~ p(X10)
    | esk2014_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1819_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2711,axiom,
    ( esk2399_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2334_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2712,axiom,
    ( ~ esk4273_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4403_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_2713,axiom,
    ( ~ esk275_1(X1)
    | p(X1)
    | esk80_0 ) ).

cnf(i_0_2714,axiom,
    ( ~ esk1331_6(X1,X2,X3,X4,X5,X6)
    | esk1461_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_2715,axiom,
    ( esk4695_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4630_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_2716,axiom,
    ( p(X19)
    | esk3731_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3666_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2717,axiom,
    ( ~ esk3767_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3962_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2718,axiom,
    ( esk397_2(X1,X2)
    | ~ esk202_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_2719,axiom,
    ( ~ esk3559_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3364_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2720,axiom,
    ( ~ esk1781_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk1976_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2721,axiom,
    ( esk5304_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5239_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2722,axiom,
    ( ~ p(X24)
    | esk4668_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4798_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2723,axiom,
    ( esk1134_5(X1,X2,X3,X4,X5)
    | ~ esk1199_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_2724,axiom,
    ( esk488_2(X1,X2)
    | p(X3)
    | ~ esk683_3(X1,X2,X3) ) ).

cnf(i_0_2725,axiom,
    ( ~ esk1976_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1781_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_2726,axiom,
    ( esk1501_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1631_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2727,axiom,
    ( ~ esk1174_6(X1,X2,X3,X4,X5,X6)
    | esk979_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_2728,axiom,
    ( esk2786_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk2981_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2729,axiom,
    ( ~ p(X14)
    | esk2539_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2734_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2730,axiom,
    ( esk753_3(X1,X2,X3)
    | ~ esk818_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_2731,axiom,
    ( p(X11)
    | esk2187_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2122_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2732,axiom,
    ( esk1709_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1839_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_2733,axiom,
    ( ~ esk5648_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5713_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2734,axiom,
    ( ~ p(X6)
    | esk1126_5(X1,X2,X3,X4,X5)
    | ~ esk1256_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2735,axiom,
    ( esk5316_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5511_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2736,axiom,
    ( ~ esk3650_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3715_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2737,axiom,
    ( ~ p(X31)
    | esk5897_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6092_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2738,axiom,
    ( ~ esk2654_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2459_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_2739,axiom,
    ( ~ p(X26)
    | ~ esk5129_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4934_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2740,axiom,
    ( ~ esk4096_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4291_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_2741,axiom,
    ( esk2164_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | ~ esk2359_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2742,axiom,
    ( p(X5)
    | ~ esk1094_5(X1,X2,X3,X4,X5)
    | esk899_4(X1,X2,X3,X4) ) ).

cnf(i_0_2743,axiom,
    ( ~ p(X16)
    | esk3169_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2974_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2744,axiom,
    ( ~ esk5062_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | esk5127_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2745,axiom,
    ( esk3347_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3282_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2746,axiom,
    ( esk5813_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | ~ esk5878_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2747,axiom,
    ( ~ esk4852_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4917_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2748,axiom,
    ( ~ p(X27)
    | ~ esk5383_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5253_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2749,axiom,
    ( esk6291_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | ~ esk6226_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2750,axiom,
    ( ~ p(X23)
    | ~ esk4438_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4568_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2751,axiom,
    ( ~ esk2352_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2157_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2752,axiom,
    ( p(X21)
    | ~ esk4033_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4098_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2753,axiom,
    ( esk3707_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | ~ esk3512_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2754,axiom,
    ( esk2412_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2607_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2755,axiom,
    ( esk5714_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5649_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2756,axiom,
    ( esk519_2(X1,X2)
    | ~ esk714_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_2757,axiom,
    ( esk2568_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2503_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_2758,axiom,
    ( ~ p(X11)
    | ~ esk2174_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1979_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2759,axiom,
    ( ~ esk3091_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3221_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_2760,axiom,
    ( esk5168_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4973_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_2761,axiom,
    ( esk2823_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2693_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_2762,axiom,
    ( ~ p(X6)
    | esk1197_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1002_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2763,axiom,
    ( esk3037_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2907_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2764,axiom,
    ( esk4919_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | ~ esk4724_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2765,axiom,
    ( esk6280_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6248_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2766,axiom,
    ( ~ esk1040_5(X1,X2,X3,X4,X5)
    | esk845_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_2767,axiom,
    ( ~ p(X25)
    | esk4811_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4941_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2768,axiom,
    ( esk461_2(X1,X2)
    | ~ esk266_1(X1)
    | p(X2) ) ).

cnf(i_0_2769,axiom,
    ( esk5430_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5495_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_2770,axiom,
    ( p(X23)
    | esk4605_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4410_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2771,axiom,
    ( esk4719_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4654_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_2772,axiom,
    ( p(X17)
    | esk3352_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3287_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2773,axiom,
    ( p(X5)
    | ~ esk982_5(X1,X2,X3,X4,X5)
    | esk917_4(X1,X2,X3,X4) ) ).

cnf(i_0_2774,axiom,
    ( esk2972_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3167_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_2775,axiom,
    ( ~ p(X10)
    | esk1806_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2001_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2776,axiom,
    ( ~ p(X21)
    | ~ esk4062_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4192_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2777,axiom,
    ( esk2165_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | ~ esk2100_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2778,axiom,
    ( ~ esk512_2(X1,X2)
    | esk707_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_2779,axiom,
    ( ~ p(X26)
    | esk4892_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5087_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2780,axiom,
    ( esk6255_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6256_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2781,axiom,
    ( esk2909_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | ~ esk2974_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2782,axiom,
    ( ~ esk3314_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3379_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_2783,axiom,
    ( p(X32)
    | ~ esk6301_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6236_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2784,axiom,
    ( esk5167_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5362_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2785,axiom,
    ( p(X14)
    | esk2633_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2828_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2786,axiom,
    ( esk4829_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4959_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2787,axiom,
    ( esk772_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk902_4(X1,X2,X3,X4) ) ).

cnf(i_0_2788,axiom,
    ( ~ esk4419_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4289_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_2789,axiom,
    ( esk787_4(X1,X2,X3,X4)
    | ~ esk982_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_2790,axiom,
    ( esk3752_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3947_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_2791,axiom,
    ( esk6245_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6343_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6278_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2792,axiom,
    ( ~ esk1823_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1628_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_2793,axiom,
    ( esk2822_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | ~ esk3017_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2794,axiom,
    ( ~ esk496_2(X1,X2)
    | esk301_1(X1)
    | p(X2) ) ).

cnf(i_0_2795,axiom,
    ( esk2490_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2555_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2796,axiom,
    ( p(X18)
    | esk3526_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3461_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2797,axiom,
    ( esk4994_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4799_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_2798,axiom,
    ( ~ esk4652_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | esk4782_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2799,axiom,
    ( ~ p(X16)
    | ~ esk3071_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3201_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_2800,axiom,
    ( ~ esk4706_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | esk4511_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2801,axiom,
    ( p(X26)
    | ~ esk5033_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5098_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2802,axiom,
    ( ~ p(X8)
    | esk1657_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1527_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2803,axiom,
    ( esk2188_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | ~ esk2123_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2804,axiom,
    ( esk1429_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1364_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_2805,axiom,
    ( ~ esk653_3(X1,X2,X3)
    | esk458_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_2806,axiom,
    ( p(X25)
    | esk4979_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4784_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2807,axiom,
    ( esk5613_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | ~ esk5743_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2808,axiom,
    ( ~ p(X3)
    | ~ esk446_2(X1,X2)
    | esk641_3(X1,X2,X3) ) ).

cnf(i_0_2809,axiom,
    ( ~ esk3821_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3626_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_2810,axiom,
    ( esk279_1(X1)
    | p(X2)
    | ~ esk474_2(X1,X2) ) ).

cnf(i_0_2811,axiom,
    ( ~ p(X13)
    | ~ esk2646_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2516_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2812,axiom,
    ( esk4945_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4815_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_2813,axiom,
    ( ~ p(X9)
    | ~ esk1594_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1789_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2814,axiom,
    ( ~ p(X6)
    | ~ esk989_5(X1,X2,X3,X4,X5)
    | esk1184_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2815,axiom,
    ( esk5437_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | ~ esk5502_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2816,axiom,
    ( ~ esk4104_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3909_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_2817,axiom,
    ( ~ esk5185_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5380_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_2818,axiom,
    ( ~ p(X3)
    | ~ esk436_2(X1,X2)
    | esk631_3(X1,X2,X3) ) ).

cnf(i_0_2819,axiom,
    ( ~ esk1430_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk1625_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2820,axiom,
    ( p(X4)
    | esk838_4(X1,X2,X3,X4)
    | ~ esk773_3(X1,X2,X3) ) ).

cnf(i_0_2821,axiom,
    ( ~ esk3153_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2958_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_2822,axiom,
    ( esk6088_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6023_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_2823,axiom,
    ( esk1405_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk1340_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2824,axiom,
    ( ~ esk2429_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | esk2624_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2825,axiom,
    ( esk6075_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6270_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2826,axiom,
    ( esk693_3(X1,X2,X3)
    | p(X3)
    | ~ esk498_2(X1,X2) ) ).

cnf(i_0_2827,axiom,
    ( esk4170_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4040_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_2828,axiom,
    ( ~ esk50_0
    | ~ p(X1)
    | esk245_1(X1) ) ).

cnf(i_0_2829,axiom,
    ( esk4521_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4716_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_2830,axiom,
    ( ~ esk3590_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3785_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2831,axiom,
    ( esk5044_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5109_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2832,axiom,
    ( ~ esk5565_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5760_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2833,axiom,
    ( esk829_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk1024_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2834,axiom,
    ( ~ esk3146_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | esk3081_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2835,axiom,
    ( esk128_0
    | p(X1)
    | ~ esk323_1(X1) ) ).

cnf(i_0_2836,axiom,
    ( ~ p(X26)
    | ~ esk5039_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5169_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2837,axiom,
    ( p(X21)
    | esk4163_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3968_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2838,axiom,
    ( ~ esk1360_6(X1,X2,X3,X4,X5,X6)
    | esk1490_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_2839,axiom,
    ( esk639_3(X1,X2,X3)
    | ~ esk834_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_2840,axiom,
    ( ~ esk1291_6(X1,X2,X3,X4,X5,X6)
    | esk1486_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_2841,axiom,
    ( esk6119_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6314_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_2842,axiom,
    ( esk2412_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2282_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2843,axiom,
    ( esk2612_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | ~ esk2807_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2844,axiom,
    ( ~ esk106_0
    | esk301_1(X1)
    | p(X1) ) ).

cnf(i_0_2845,axiom,
    ( ~ esk1520_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1585_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_2846,axiom,
    ( esk5298_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5233_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2847,axiom,
    ( esk5279_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5474_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_2848,axiom,
    ( ~ esk3864_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3994_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_2849,axiom,
    ( ~ esk1024_5(X1,X2,X3,X4,X5)
    | esk1219_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_2850,axiom,
    ( esk3701_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3766_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_2851,axiom,
    ( esk1095_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk965_4(X1,X2,X3,X4) ) ).

cnf(i_0_2852,axiom,
    ( esk3604_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3474_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_2853,axiom,
    ( p(X22)
    | esk4330_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4265_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2854,axiom,
    ( esk2751_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2556_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_2855,axiom,
    ( ~ esk3863_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3993_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2856,axiom,
    ( ~ esk3562_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3367_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_2857,axiom,
    ( p(X16)
    | ~ esk3219_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3024_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2858,axiom,
    ( esk1038_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk973_4(X1,X2,X3,X4) ) ).

cnf(i_0_2859,axiom,
    ( ~ p(X20)
    | esk3935_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3740_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2860,axiom,
    ( p(X30)
    | esk5860_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5795_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2861,axiom,
    ( ~ esk5286_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | esk5481_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2862,axiom,
    ( p(X7)
    | esk1385_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1320_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2863,axiom,
    ( ~ esk1550_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk1615_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2864,axiom,
    ( esk2547_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2482_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_2865,axiom,
    ( ~ p(X16)
    | esk3171_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2976_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2866,axiom,
    ( esk125_0
    | p(X1)
    | ~ esk320_1(X1) ) ).

cnf(i_0_2867,axiom,
    ( esk446_2(X1,X2)
    | ~ p(X2)
    | ~ esk251_1(X1) ) ).

cnf(i_0_2868,axiom,
    ( esk4505_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4310_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2869,axiom,
    ( p(X22)
    | ~ esk4390_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4195_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2870,axiom,
    ( ~ esk2666_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2796_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2871,axiom,
    ( p(X9)
    | esk1834_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1639_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2872,axiom,
    ( p(X14)
    | esk2722_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2787_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2873,axiom,
    ( ~ esk2096_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2226_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2874,axiom,
    ( ~ p(X23)
    | ~ esk4600_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4470_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2875,axiom,
    ( esk5804_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5934_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2876,axiom,
    ( esk5345_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5215_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_2877,axiom,
    ( p(X31)
    | ~ esk6033_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6098_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2878,axiom,
    ( esk4023_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4218_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_2879,axiom,
    ( esk4235_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4365_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_2880,axiom,
    ( ~ esk1368_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1173_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2881,axiom,
    ( p(X24)
    | esk4663_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4728_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2882,axiom,
    ( esk2334_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2464_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_2883,axiom,
    ( esk5538_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | ~ esk5733_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2884,axiom,
    ( ~ esk6342_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6244_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6277_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2885,axiom,
    ( esk3819_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3624_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2886,axiom,
    ( esk2240_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2110_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2887,axiom,
    ( p(X29)
    | esk5715_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5650_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_2888,axiom,
    ( esk3559_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3754_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2889,axiom,
    ( esk6291_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6096_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_2890,axiom,
    ( ~ p(X28)
    | ~ esk5516_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5321_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2891,axiom,
    ( esk4367_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4237_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_2892,axiom,
    ( ~ esk3028_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2898_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_2893,axiom,
    ( esk837_4(X1,X2,X3,X4)
    | ~ esk1032_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_2894,axiom,
    ( ~ p(X12)
    | esk2194_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2389_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2895,axiom,
    ( esk3416_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3286_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_2896,axiom,
    ( ~ p(X18)
    | ~ esk3482_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3612_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2897,axiom,
    ( esk1832_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1637_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_2898,axiom,
    ( ~ p(X9)
    | ~ esk1817_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1622_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_2899,axiom,
    ( esk2356_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2161_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_2900,axiom,
    ( p(X11)
    | ~ esk2067_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2262_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2901,axiom,
    ( ~ p(X21)
    | ~ esk4143_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3948_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2902,axiom,
    ( esk3760_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3695_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2903,axiom,
    ( ~ p(X11)
    | ~ esk2232_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2102_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2904,axiom,
    ( esk2311_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2441_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_2905,axiom,
    ( p(X3)
    | esk662_3(X1,X2,X3)
    | ~ esk467_2(X1,X2) ) ).

cnf(i_0_2906,axiom,
    ( esk5859_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5664_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2907,axiom,
    ( ~ esk3377_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3572_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2908,axiom,
    ( ~ esk3241_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk3111_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2909,axiom,
    ( esk4921_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25)
    | ~ esk4856_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2910,axiom,
    ( esk2159_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | ~ esk2094_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2911,axiom,
    ( esk6347_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6152_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_2912,axiom,
    ( p(X18)
    | ~ esk3530_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3465_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2913,axiom,
    ( ~ esk3973_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3778_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_2914,axiom,
    ( ~ esk1931_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1996_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_2915,axiom,
    ( ~ esk3274_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3339_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_2916,axiom,
    ( ~ p(X20)
    | ~ esk3997_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3867_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2917,axiom,
    ( ~ esk3448_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3578_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_2918,axiom,
    ( esk1694_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1824_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2919,axiom,
    ( p(X30)
    | ~ esk5923_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5728_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2920,axiom,
    ( esk3131_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3326_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_2921,axiom,
    ( ~ esk3440_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3310_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_2922,axiom,
    ( ~ esk5913_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6108_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_2923,axiom,
    ( ~ p(X32)
    | esk6357_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6227_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2924,axiom,
    ( ~ esk6084_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | esk6279_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2925,axiom,
    ( esk1006_5(X1,X2,X3,X4,X5)
    | ~ esk811_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_2926,axiom,
    ( ~ esk1988_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1923_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_2927,axiom,
    ( ~ p(X27)
    | esk5280_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5085_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2928,axiom,
    ( ~ esk746_3(X1,X2,X3)
    | esk811_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_2929,axiom,
    ( ~ esk2453_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2258_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_2930,axiom,
    ( ~ esk3905_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4100_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_2931,axiom,
    ( ~ esk3402_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3272_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_2932,axiom,
    ( p(X11)
    | esk2169_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2104_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2933,axiom,
    ( ~ esk73_0
    | p(X1)
    | esk268_1(X1) ) ).

cnf(i_0_2934,axiom,
    ( esk498_2(X1,X2)
    | p(X3)
    | ~ esk693_3(X1,X2,X3) ) ).

cnf(i_0_2935,axiom,
    ( ~ esk1035_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk840_4(X1,X2,X3,X4) ) ).

cnf(i_0_2936,axiom,
    ( esk3162_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3097_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2937,axiom,
    ( p(X14)
    | esk2732_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2667_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_2938,axiom,
    ( p(X11)
    | ~ esk2120_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2185_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2939,axiom,
    ( p(X27)
    | esk5337_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5142_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2940,axiom,
    ( ~ esk2663_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2858_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_2941,axiom,
    ( esk3583_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3778_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_2942,axiom,
    ( ~ esk4662_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4727_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_2943,axiom,
    ( ~ esk1003_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk808_4(X1,X2,X3,X4) ) ).

cnf(i_0_2944,axiom,
    ( p(X30)
    | ~ esk5849_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5914_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2945,axiom,
    ( p(X29)
    | esk5652_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5717_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_2946,axiom,
    ( esk5021_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | ~ esk5086_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_2947,axiom,
    ( ~ esk3932_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3737_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_2948,axiom,
    ( p(X7)
    | esk1387_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1322_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2949,axiom,
    ( esk513_2(X1,X2)
    | ~ esk708_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_2950,axiom,
    ( esk5746_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5941_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_2951,axiom,
    ( ~ p(X5)
    | ~ esk1088_5(X1,X2,X3,X4,X5)
    | esk958_4(X1,X2,X3,X4) ) ).

cnf(i_0_2952,axiom,
    ( ~ p(X13)
    | esk2559_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2364_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2953,axiom,
    ( p(X5)
    | esk961_4(X1,X2,X3,X4)
    | ~ esk1026_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2954,axiom,
    ( ~ esk6068_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | esk5873_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_2955,axiom,
    ( p(X24)
    | ~ esk4726_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4661_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2956,axiom,
    ( p(X1)
    | esk188_0
    | ~ esk253_1(X1) ) ).

cnf(i_0_2957,axiom,
    ( ~ p(X19)
    | esk3535_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3730_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2958,axiom,
    ( ~ esk5497_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5432_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_2959,axiom,
    ( ~ esk3634_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3829_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2960,axiom,
    ( esk4223_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4418_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_2961,axiom,
    ( p(X24)
    | esk4809_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4614_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2962,axiom,
    ( ~ p(X5)
    | esk819_4(X1,X2,X3,X4)
    | ~ esk1014_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2963,axiom,
    ( p(X6)
    | esk1106_5(X1,X2,X3,X4,X5)
    | ~ esk1171_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_2964,axiom,
    ( ~ p(X11)
    | ~ esk2120_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2250_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2965,axiom,
    ( ~ esk5662_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5857_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_2966,axiom,
    ( ~ esk3220_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk3090_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2967,axiom,
    ( ~ esk5720_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5655_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_2968,axiom,
    ( p(X23)
    | esk4595_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4400_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2969,axiom,
    ( ~ esk1665_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk1535_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_2970,axiom,
    ( ~ esk4413_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | esk4608_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_2971,axiom,
    ( esk1270_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk1140_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2972,axiom,
    ( ~ esk5836_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5966_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_2973,axiom,
    ( esk2710_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2840_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_2974,axiom,
    ( p(X26)
    | esk5172_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4977_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2975,axiom,
    ( esk4283_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | ~ esk4413_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_2976,axiom,
    ( ~ esk6055_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6250_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_2977,axiom,
    ( ~ p(X13)
    | ~ esk2637_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2507_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_2978,axiom,
    ( ~ p(X15)
    | esk2775_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2970_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_2979,axiom,
    ( esk6253_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6252_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6285_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_2980,axiom,
    ( esk825_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk1020_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_2981,axiom,
    ( esk6314_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6119_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_2982,axiom,
    ( ~ esk5465_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5270_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_2983,axiom,
    ( ~ esk2162_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2097_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_2984,axiom,
    ( ~ esk5144_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4949_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_2985,axiom,
    ( ~ esk4098_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk4033_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_2986,axiom,
    ( ~ esk2163_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2098_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2987,axiom,
    ( ~ esk2116_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2181_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_2988,axiom,
    ( p(X11)
    | esk2266_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2071_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_2989,axiom,
    ( ~ esk1160_5(X1,X2,X3,X4,X5)
    | esk1225_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_2990,axiom,
    ( p(X20)
    | ~ esk3936_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3871_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_2991,axiom,
    ( ~ esk978_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | esk783_4(X1,X2,X3,X4) ) ).

cnf(i_0_2992,axiom,
    ( ~ esk1616_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1811_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_2993,axiom,
    ( ~ esk3374_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3569_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_2994,axiom,
    ( ~ p(X21)
    | ~ esk3942_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4137_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_2995,axiom,
    ( ~ esk3603_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3408_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_2996,axiom,
    ( esk3653_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3783_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_2997,axiom,
    ( esk5993_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6058_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_2998,axiom,
    ( esk4736_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4931_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_2999,axiom,
    ( p(X1)
    | ~ esk116_0
    | esk311_1(X1) ) ).

cnf(i_0_3000,axiom,
    ( ~ esk5218_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5283_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_3001,axiom,
    ( ~ esk3223_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3093_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_3002,axiom,
    ( p(X19)
    | esk3752_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3687_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3003,axiom,
    ( ~ esk3647_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3712_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_3004,axiom,
    ( ~ esk1018_5(X1,X2,X3,X4,X5)
    | esk1213_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_3005,axiom,
    ( ~ esk3344_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3539_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_3006,axiom,
    ( ~ esk5308_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5243_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3007,axiom,
    ( esk2069_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | ~ esk1874_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3008,axiom,
    ( p(X26)
    | ~ esk5177_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4982_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3009,axiom,
    ( ~ esk3671_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3801_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3010,axiom,
    ( ~ esk5465_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | esk5660_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3011,axiom,
    ( esk5807_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5937_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3012,axiom,
    ( ~ p(X27)
    | ~ esk5319_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5124_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3013,axiom,
    ( esk6109_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6304_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3014,axiom,
    ( ~ esk6360_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6230_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_3015,axiom,
    ( esk4716_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4911_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_3016,axiom,
    ( esk1568_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1503_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_3017,axiom,
    ( ~ esk162_0
    | esk292_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_3018,axiom,
    ( ~ p(X30)
    | esk5712_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5907_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3019,axiom,
    ( p(X3)
    | ~ esk634_3(X1,X2,X3)
    | esk569_2(X1,X2) ) ).

cnf(i_0_3020,axiom,
    ( esk3696_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3826_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_3021,axiom,
    ( p(X12)
    | ~ esk2308_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2373_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3022,axiom,
    ( esk4478_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4608_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3023,axiom,
    ( p(X5)
    | esk895_4(X1,X2,X3,X4)
    | ~ esk1090_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3024,axiom,
    ( ~ p(X20)
    | esk3763_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3958_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3025,axiom,
    ( esk5447_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5577_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_3026,axiom,
    ( esk1804_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | ~ esk1739_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3027,axiom,
    ( esk5784_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | ~ esk5654_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3028,axiom,
    ( esk2328_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2458_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_3029,axiom,
    ( p(X25)
    | esk4756_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4951_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3030,axiom,
    ( ~ esk6339_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6144_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_3031,axiom,
    ( ~ esk3318_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3253_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3032,axiom,
    ( esk5509_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5314_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_3033,axiom,
    ( p(X3)
    | ~ esk679_3(X1,X2,X3)
    | esk484_2(X1,X2) ) ).

cnf(i_0_3034,axiom,
    ( p(X6)
    | ~ esk1118_5(X1,X2,X3,X4,X5)
    | esk1183_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3035,axiom,
    ( ~ p(X13)
    | ~ esk2575_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2380_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3036,axiom,
    ( p(X9)
    | esk1798_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1733_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3037,axiom,
    ( esk4043_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4173_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_3038,axiom,
    ( ~ p(X20)
    | esk3908_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3713_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3039,axiom,
    ( ~ p(X20)
    | esk3729_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3924_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3040,axiom,
    ( p(X18)
    | ~ esk3470_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3535_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3041,axiom,
    ( esk1475_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1345_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_3042,axiom,
    ( ~ p(X10)
    | ~ esk1787_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1982_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3043,axiom,
    ( ~ p(X2)
    | ~ esk468_2(X1,X2)
    | esk338_1(X1) ) ).

cnf(i_0_3044,axiom,
    ( esk2259_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk2129_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3045,axiom,
    ( p(X15)
    | ~ esk2943_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2878_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3046,axiom,
    ( ~ p(X11)
    | esk2262_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2132_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3047,axiom,
    ( esk2063_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | ~ esk1868_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3048,axiom,
    ( esk2856_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2726_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_3049,axiom,
    ( esk4632_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4762_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_3050,axiom,
    ( esk4542_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4347_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_3051,axiom,
    ( p(X6)
    | ~ esk1245_6(X1,X2,X3,X4,X5,X6)
    | esk1050_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3052,axiom,
    ( ~ esk673_3(X1,X2,X3)
    | p(X4)
    | esk868_4(X1,X2,X3,X4) ) ).

cnf(i_0_3053,axiom,
    ( ~ esk2716_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | esk2781_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3054,axiom,
    ( esk296_1(X1)
    | ~ esk166_0
    | ~ p(X1) ) ).

cnf(i_0_3055,axiom,
    ( ~ p(X13)
    | ~ esk2612_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2482_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3056,axiom,
    ( p(X12)
    | ~ esk2346_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2281_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3057,axiom,
    ( p(X24)
    | ~ esk4663_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4728_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3058,axiom,
    ( ~ p(X24)
    | esk4743_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4548_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3059,axiom,
    ( esk5991_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6056_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3060,axiom,
    ( p(X28)
    | ~ esk5527_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5332_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3061,axiom,
    ( p(X31)
    | ~ esk6051_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5986_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3062,axiom,
    ( esk416_2(X1,X2)
    | ~ esk351_1(X1)
    | p(X2) ) ).

cnf(i_0_3063,axiom,
    ( esk1767_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk1962_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3064,axiom,
    ( esk5223_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5353_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3065,axiom,
    ( p(X2)
    | esk345_1(X1)
    | ~ esk410_2(X1,X2) ) ).

cnf(i_0_3066,axiom,
    ( ~ esk6159_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | esk6029_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3067,axiom,
    ( ~ esk2245_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2050_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3068,axiom,
    ( esk3632_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3437_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_3069,axiom,
    ( esk1370_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk1175_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3070,axiom,
    ( ~ esk5613_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | esk5678_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3071,axiom,
    ( ~ esk2399_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2334_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3072,axiom,
    ( esk2574_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2769_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_3073,axiom,
    ( ~ esk2831_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3026_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_3074,axiom,
    ( p(X9)
    | ~ esk1776_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1711_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3075,axiom,
    ( ~ esk409_2(X1,X2)
    | p(X2)
    | esk344_1(X1) ) ).

cnf(i_0_3076,axiom,
    ( esk3432_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3237_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_3077,axiom,
    ( esk2900_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk3030_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3078,axiom,
    ( ~ esk5319_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5514_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_3079,axiom,
    ( p(X32)
    | esk6164_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6359_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3080,axiom,
    ( p(X32)
    | esk6212_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6277_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3081,axiom,
    ( ~ esk4224_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk4029_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3082,axiom,
    ( esk3379_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3574_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3083,axiom,
    ( esk475_2(X1,X2)
    | ~ esk670_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_3084,axiom,
    ( ~ p(X9)
    | ~ esk1815_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1620_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3085,axiom,
    ( esk4764_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4634_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3086,axiom,
    ( esk4512_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4447_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_3087,axiom,
    ( ~ esk4540_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4345_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_3088,axiom,
    ( esk500_2(X1,X2)
    | ~ p(X2)
    | ~ esk370_1(X1) ) ).

cnf(i_0_3089,axiom,
    ( ~ esk4359_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4164_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_3090,axiom,
    ( ~ esk4819_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4949_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3091,axiom,
    ( ~ esk5224_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5289_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_3092,axiom,
    ( ~ esk3718_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3523_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_3093,axiom,
    ( p(X17)
    | esk3202_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3397_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3094,axiom,
    ( esk5977_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | ~ esk5782_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3095,axiom,
    ( ~ p(X24)
    | esk4649_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4779_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3096,axiom,
    ( ~ esk3847_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3912_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3097,axiom,
    ( ~ esk3422_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3292_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_3098,axiom,
    ( p(X30)
    | ~ esk5966_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5771_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3099,axiom,
    ( p(X14)
    | ~ esk2638_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2833_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3100,axiom,
    ( ~ p(X3)
    | esk683_3(X1,X2,X3)
    | ~ esk553_2(X1,X2) ) ).

cnf(i_0_3101,axiom,
    ( ~ esk6287_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6255_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3102,axiom,
    ( esk3291_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3356_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_3103,axiom,
    ( esk4031_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4161_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3104,axiom,
    ( p(X14)
    | ~ esk2619_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2814_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3105,axiom,
    ( ~ esk4990_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4795_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_3106,axiom,
    ( ~ p(X2)
    | esk519_2(X1,X2)
    | ~ esk389_1(X1) ) ).

cnf(i_0_3107,axiom,
    ( ~ esk2208_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2143_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3108,axiom,
    ( ~ p(X15)
    | esk3026_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2896_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3109,axiom,
    ( ~ esk291_1(X1)
    | esk96_0
    | p(X1) ) ).

cnf(i_0_3110,axiom,
    ( ~ esk1410_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1215_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3111,axiom,
    ( ~ p(X1)
    | ~ esk258_1(X1)
    | esk63_0 ) ).

cnf(i_0_3112,axiom,
    ( esk371_1(X1)
    | p(X2)
    | ~ esk436_2(X1,X2) ) ).

cnf(i_0_3113,axiom,
    ( esk4884_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | ~ esk4689_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3114,axiom,
    ( p(X32)
    | esk6281_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6216_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3115,axiom,
    ( ~ esk4372_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4242_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3116,axiom,
    ( esk3751_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3946_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_3117,axiom,
    ( ~ p(X11)
    | esk2182_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk1987_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3118,axiom,
    ( ~ p(X28)
    | esk5396_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5526_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3119,axiom,
    ( ~ esk1223_6(X1,X2,X3,X4,X5,X6)
    | esk1028_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_3120,axiom,
    ( esk6125_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6320_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3121,axiom,
    ( ~ p(X4)
    | ~ esk772_3(X1,X2,X3)
    | esk902_4(X1,X2,X3,X4) ) ).

cnf(i_0_3122,axiom,
    ( ~ esk4932_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | esk4737_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3123,axiom,
    ( esk5220_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5350_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_3124,axiom,
    ( esk3122_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3057_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_3125,axiom,
    ( ~ esk793_4(X1,X2,X3,X4)
    | esk598_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3126,axiom,
    ( ~ esk4522_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | esk4717_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3127,axiom,
    ( ~ esk5676_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | esk5871_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3128,axiom,
    ( esk5861_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6056_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3129,axiom,
    ( esk4656_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4721_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_3130,axiom,
    ( ~ esk1617_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1812_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3131,axiom,
    ( p(X26)
    | ~ esk5153_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4958_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3132,axiom,
    ( p(X18)
    | ~ esk3575_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3510_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3133,axiom,
    ( p(X28)
    | ~ esk5379_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5574_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3134,axiom,
    ( esk6295_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6263_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3135,axiom,
    ( esk5776_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | ~ esk5971_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3136,axiom,
    ( ~ esk3771_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3576_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_3137,axiom,
    ( ~ p(X10)
    | ~ esk1912_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2042_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3138,axiom,
    ( ~ esk1526_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1591_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_3139,axiom,
    ( ~ esk751_3(X1,X2,X3)
    | p(X4)
    | esk816_4(X1,X2,X3,X4) ) ).

cnf(i_0_3140,axiom,
    ( ~ p(X31)
    | esk6025_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6155_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3141,axiom,
    ( ~ esk2162_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2357_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_3142,axiom,
    ( esk506_2(X1,X2)
    | ~ esk311_1(X1)
    | p(X2) ) ).

cnf(i_0_3143,axiom,
    ( p(X7)
    | ~ esk1323_6(X1,X2,X3,X4,X5,X6)
    | esk1388_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3144,axiom,
    ( esk3585_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | ~ esk3390_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3145,axiom,
    ( ~ p(X6)
    | esk1142_5(X1,X2,X3,X4,X5)
    | ~ esk1272_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3146,axiom,
    ( p(X16)
    | ~ esk3172_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3107_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3147,axiom,
    ( p(X8)
    | ~ esk1560_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1625_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3148,axiom,
    ( ~ p(X22)
    | ~ esk4301_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4106_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3149,axiom,
    ( esk3905_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3840_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_3150,axiom,
    ( ~ p(X11)
    | ~ esk2204_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2009_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3151,axiom,
    ( ~ esk4844_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4974_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3152,axiom,
    ( ~ esk4364_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4169_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_3153,axiom,
    ( p(X13)
    | esk2437_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2632_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3154,axiom,
    ( esk565_2(X1,X2)
    | ~ p(X3)
    | ~ esk695_3(X1,X2,X3) ) ).

cnf(i_0_3155,axiom,
    ( p(X12)
    | esk2270_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2465_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3156,axiom,
    ( esk5052_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | ~ esk5182_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3157,axiom,
    ( esk447_2(X1,X2)
    | p(X2)
    | ~ esk382_1(X1) ) ).

cnf(i_0_3158,axiom,
    ( p(X32)
    | esk6148_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6343_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3159,axiom,
    ( esk3668_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3798_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_3160,axiom,
    ( ~ esk6334_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6366_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3161,axiom,
    ( ~ p(X17)
    | ~ esk3418_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3288_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3162,axiom,
    ( esk580_2(X1,X2)
    | ~ p(X3)
    | ~ esk710_3(X1,X2,X3) ) ).

cnf(i_0_3163,axiom,
    ( ~ esk4084_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4149_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_3164,axiom,
    ( esk6101_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5906_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_3165,axiom,
    ( ~ p(X11)
    | esk2191_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk1996_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3166,axiom,
    ( esk2560_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | ~ esk2365_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3167,axiom,
    ( ~ esk1594_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1399_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_3168,axiom,
    ( p(X23)
    | esk4393_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4588_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3169,axiom,
    ( esk2156_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2091_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_3170,axiom,
    ( esk5287_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5482_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_3171,axiom,
    ( esk2878_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3008_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_3172,axiom,
    ( ~ esk4103_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3908_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_3173,axiom,
    ( p(X5)
    | ~ esk964_4(X1,X2,X3,X4)
    | esk1029_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3174,axiom,
    ( ~ esk211_1(X1)
    | ~ p(X2)
    | esk406_2(X1,X2) ) ).

cnf(i_0_3175,axiom,
    ( p(X27)
    | esk5285_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5220_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3176,axiom,
    ( ~ esk2379_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2574_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3177,axiom,
    ( p(X3)
    | esk464_2(X1,X2)
    | ~ esk659_3(X1,X2,X3) ) ).

cnf(i_0_3178,axiom,
    ( ~ p(X29)
    | esk5770_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5640_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3179,axiom,
    ( p(X26)
    | ~ esk5106_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5041_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3180,axiom,
    ( esk3948_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3883_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3181,axiom,
    ( ~ esk1774_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1969_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_3182,axiom,
    ( p(X20)
    | ~ esk3827_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4022_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3183,axiom,
    ( p(X26)
    | esk5005_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5200_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3184,axiom,
    ( ~ p(X28)
    | esk5536_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5406_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3185,axiom,
    ( esk254_1(X1)
    | p(X1)
    | ~ esk189_0 ) ).

cnf(i_0_3186,axiom,
    ( p(X24)
    | ~ esk4675_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4740_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3187,axiom,
    ( ~ p(X30)
    | ~ esk5940_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5810_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3188,axiom,
    ( p(X22)
    | ~ esk4290_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4355_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3189,axiom,
    ( ~ esk2356_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2291_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_3190,axiom,
    ( p(X28)
    | esk5540_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5345_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3191,axiom,
    ( ~ esk5367_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5172_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3192,axiom,
    ( ~ esk4130_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4065_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_3193,axiom,
    ( esk3075_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3205_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3194,axiom,
    ( ~ esk4585_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4455_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_3195,axiom,
    ( ~ p(X2)
    | ~ esk408_2(X1,X2)
    | esk213_1(X1) ) ).

cnf(i_0_3196,axiom,
    ( esk1462_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | ~ esk1332_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3197,axiom,
    ( ~ p(X4)
    | esk795_4(X1,X2,X3,X4)
    | ~ esk600_3(X1,X2,X3) ) ).

cnf(i_0_3198,axiom,
    ( esk2149_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk1954_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_3199,axiom,
    ( ~ esk3601_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3471_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_3200,axiom,
    ( esk5216_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5346_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_3201,axiom,
    ( esk1831_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2026_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_3202,axiom,
    ( esk358_1(X1)
    | ~ p(X2)
    | ~ esk488_2(X1,X2) ) ).

cnf(i_0_3203,axiom,
    ( esk6221_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6351_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_3204,axiom,
    ( esk5795_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | ~ esk5860_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3205,axiom,
    ( ~ esk285_1(X1)
    | esk90_0
    | p(X1) ) ).

cnf(i_0_3206,axiom,
    ( p(X11)
    | esk2168_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2103_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3207,axiom,
    ( ~ esk2277_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | esk2407_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3208,axiom,
    ( esk1792_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | ~ esk1597_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3209,axiom,
    ( ~ esk4328_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4523_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3210,axiom,
    ( esk5491_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5426_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_3211,axiom,
    ( ~ esk2404_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2599_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3212,axiom,
    ( esk188_0
    | ~ p(X1)
    | ~ esk318_1(X1) ) ).

cnf(i_0_3213,axiom,
    ( esk2390_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2585_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_3214,axiom,
    ( ~ esk2229_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2034_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3215,axiom,
    ( esk4353_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | ~ esk4158_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3216,axiom,
    ( esk1272_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk1142_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3217,axiom,
    ( ~ p(X20)
    | esk3900_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4030_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3218,axiom,
    ( ~ esk5015_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5080_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_3219,axiom,
    ( ~ esk1609_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk1414_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3220,axiom,
    ( p(X3)
    | ~ esk580_2(X1,X2)
    | esk645_3(X1,X2,X3) ) ).

cnf(i_0_3221,axiom,
    ( p(X29)
    | esk5725_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5530_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3222,axiom,
    ( ~ esk3556_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3361_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_3223,axiom,
    ( esk6301_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6269_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3224,axiom,
    ( ~ p(X7)
    | ~ esk1362_6(X1,X2,X3,X4,X5,X6)
    | esk1492_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3225,axiom,
    ( ~ esk1631_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1436_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3226,axiom,
    ( p(X9)
    | ~ esk1869_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1674_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3227,axiom,
    ( p(X17)
    | esk3245_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3440_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3228,axiom,
    ( p(X14)
    | esk2764_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2699_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3229,axiom,
    ( ~ esk623_3(X1,X2,X3)
    | ~ p(X3)
    | esk428_2(X1,X2) ) ).

cnf(i_0_3230,axiom,
    ( p(X31)
    | esk5963_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6158_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3231,axiom,
    ( esk3683_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | ~ esk3748_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3232,axiom,
    ( ~ esk3068_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3133_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_3233,axiom,
    ( esk2142_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2207_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3234,axiom,
    ( ~ esk2689_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | esk2754_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3235,axiom,
    ( esk2820_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3015_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_3236,axiom,
    ( ~ p(X15)
    | ~ esk3002_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2872_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3237,axiom,
    ( p(X4)
    | ~ esk788_4(X1,X2,X3,X4)
    | esk723_3(X1,X2,X3) ) ).

cnf(i_0_3238,axiom,
    ( ~ esk2637_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2442_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_3239,axiom,
    ( esk1983_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | ~ esk1918_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3240,axiom,
    ( p(X14)
    | ~ esk2717_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2782_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3241,axiom,
    ( ~ p(X4)
    | ~ esk721_3(X1,X2,X3)
    | esk851_4(X1,X2,X3,X4) ) ).

cnf(i_0_3242,axiom,
    ( esk2422_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2617_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_3243,axiom,
    ( p(X23)
    | esk4529_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4464_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3244,axiom,
    ( esk4713_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4908_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_3245,axiom,
    ( ~ esk853_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk723_3(X1,X2,X3) ) ).

cnf(i_0_3246,axiom,
    ( esk1435_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1305_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_3247,axiom,
    ( p(X6)
    | ~ esk1241_6(X1,X2,X3,X4,X5,X6)
    | esk1046_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3248,axiom,
    ( ~ p(X28)
    | ~ esk5283_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5478_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3249,axiom,
    ( ~ p(X15)
    | ~ esk3019_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2889_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3250,axiom,
    ( p(X18)
    | ~ esk3538_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3473_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3251,axiom,
    ( p(X12)
    | esk2362_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2297_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3252,axiom,
    ( ~ esk4515_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4320_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3253,axiom,
    ( ~ esk3367_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3562_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_3254,axiom,
    ( esk1737_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1802_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3255,axiom,
    ( ~ esk785_4(X1,X2,X3,X4)
    | esk590_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3256,axiom,
    ( ~ esk4527_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4332_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_3257,axiom,
    ( ~ esk6257_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6192_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_3258,axiom,
    ( ~ esk1812_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk2007_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3259,axiom,
    ( ~ p(X13)
    | esk2505_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2635_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3260,axiom,
    ( esk3129_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3324_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_3261,axiom,
    ( esk4519_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4714_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_3262,axiom,
    ( ~ p(X18)
    | ~ esk3331_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3526_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3263,axiom,
    ( esk1097_5(X1,X2,X3,X4,X5)
    | ~ esk1292_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_3264,axiom,
    ( esk5687_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5882_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_3265,axiom,
    ( ~ p(X27)
    | esk5109_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5304_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3266,axiom,
    ( ~ p(X21)
    | ~ esk4069_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4199_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3267,axiom,
    ( p(X2)
    | ~ esk511_2(X1,X2)
    | esk316_1(X1) ) ).

cnf(i_0_3268,axiom,
    ( ~ p(X31)
    | esk6091_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5896_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3269,axiom,
    ( ~ p(X31)
    | esk5991_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6121_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3270,axiom,
    ( esk2439_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2244_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3271,axiom,
    ( ~ esk1649_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | esk1519_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3272,axiom,
    ( esk3196_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3066_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3273,axiom,
    ( ~ esk2188_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1993_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_3274,axiom,
    ( esk4487_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4292_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_3275,axiom,
    ( ~ esk5885_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | esk5820_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3276,axiom,
    ( p(X15)
    | esk2914_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2979_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3277,axiom,
    ( ~ esk177_0
    | esk307_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_3278,axiom,
    ( ~ p(X7)
    | esk1193_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1388_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3279,axiom,
    ( ~ esk4542_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4347_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3280,axiom,
    ( esk3538_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3343_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_3281,axiom,
    ( esk2570_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2765_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3282,axiom,
    ( p(X19)
    | esk3810_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3615_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3283,axiom,
    ( ~ p(X6)
    | ~ esk1268_6(X1,X2,X3,X4,X5,X6)
    | esk1138_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3284,axiom,
    ( ~ esk660_3(X1,X2,X3)
    | esk530_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_3285,axiom,
    ( p(X25)
    | ~ esk4846_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4911_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3286,axiom,
    ( ~ p(X8)
    | ~ esk1571_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1376_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3287,axiom,
    ( p(X5)
    | ~ esk989_5(X1,X2,X3,X4,X5)
    | esk924_4(X1,X2,X3,X4) ) ).

cnf(i_0_3288,axiom,
    ( ~ esk6103_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6298_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_3289,axiom,
    ( esk4492_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4427_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3290,axiom,
    ( esk5306_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5111_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3291,axiom,
    ( ~ p(X18)
    | ~ esk3346_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3541_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3292,axiom,
    ( p(X8)
    | esk1515_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1580_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3293,axiom,
    ( ~ p(X20)
    | ~ esk3916_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3721_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3294,axiom,
    ( ~ esk529_2(X1,X2)
    | p(X3)
    | esk594_3(X1,X2,X3) ) ).

cnf(i_0_3295,axiom,
    ( ~ esk3133_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2938_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_3296,axiom,
    ( esk4562_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4432_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3297,axiom,
    ( esk6050_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5855_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_3298,axiom,
    ( ~ esk1254_6(X1,X2,X3,X4,X5,X6)
    | esk1124_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_3299,axiom,
    ( ~ esk4138_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4073_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_3300,axiom,
    ( ~ p(X32)
    | ~ esk6063_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6258_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3301,axiom,
    ( esk1281_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk1151_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3302,axiom,
    ( ~ p(X2)
    | ~ esk515_2(X1,X2)
    | esk385_1(X1) ) ).

cnf(i_0_3303,axiom,
    ( esk3644_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3774_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3304,axiom,
    ( esk3160_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3095_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_3305,axiom,
    ( esk2559_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2494_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3306,axiom,
    ( ~ esk818_4(X1,X2,X3,X4)
    | esk623_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3307,axiom,
    ( esk3227_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3097_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3308,axiom,
    ( p(X2)
    | ~ esk517_2(X1,X2)
    | esk322_1(X1) ) ).

cnf(i_0_3309,axiom,
    ( p(X29)
    | esk5750_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5555_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3310,axiom,
    ( ~ esk6261_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6294_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6359_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3311,axiom,
    ( ~ p(X15)
    | esk2999_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2869_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3312,axiom,
    ( esk5752_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5947_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_3313,axiom,
    ( p(X9)
    | ~ esk1684_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1879_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3314,axiom,
    ( esk2952_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2757_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3315,axiom,
    ( esk3603_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3408_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_3316,axiom,
    ( esk5641_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | ~ esk5706_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3317,axiom,
    ( ~ esk5916_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6111_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31) ) ).

cnf(i_0_3318,axiom,
    ( esk4004_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | ~ esk4199_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3319,axiom,
    ( p(X6)
    | ~ esk1286_6(X1,X2,X3,X4,X5,X6)
    | esk1091_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3320,axiom,
    ( ~ p(X27)
    | ~ esk5233_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5363_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3321,axiom,
    ( p(X24)
    | ~ esk4686_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4621_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3322,axiom,
    ( ~ esk3935_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | esk3870_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3323,axiom,
    ( esk4381_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4576_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3324,axiom,
    ( esk740_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk870_4(X1,X2,X3,X4) ) ).

cnf(i_0_3325,axiom,
    ( ~ esk2599_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2794_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3326,axiom,
    ( ~ esk750_3(X1,X2,X3)
    | p(X4)
    | esk815_4(X1,X2,X3,X4) ) ).

cnf(i_0_3327,axiom,
    ( p(X11)
    | esk2268_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2073_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3328,axiom,
    ( esk73_0
    | ~ esk268_1(X1)
    | p(X1) ) ).

cnf(i_0_3329,axiom,
    ( ~ esk4500_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4435_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_3330,axiom,
    ( p(X21)
    | ~ esk4026_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4221_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3331,axiom,
    ( ~ esk4671_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4736_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_3332,axiom,
    ( esk6294_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6262_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3333,axiom,
    ( ~ esk5874_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6069_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_3334,axiom,
    ( esk5910_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5715_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3335,axiom,
    ( esk5459_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5589_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3336,axiom,
    ( esk6249_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6282_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6347_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3337,axiom,
    ( ~ p(X31)
    | ~ esk5867_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6062_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3338,axiom,
    ( ~ p(X31)
    | ~ esk6016_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6146_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3339,axiom,
    ( esk6119_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5989_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_3340,axiom,
    ( p(X19)
    | esk3582_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3777_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3341,axiom,
    ( ~ p(X32)
    | esk6305_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6110_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3342,axiom,
    ( ~ esk2942_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3137_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3343,axiom,
    ( esk4422_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4552_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3344,axiom,
    ( esk348_1(X1)
    | ~ esk413_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_3345,axiom,
    ( ~ esk2344_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2539_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_3346,axiom,
    ( ~ p(X30)
    | esk5719_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5914_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3347,axiom,
    ( ~ p(X24)
    | ~ esk4732_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4537_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3348,axiom,
    ( ~ esk3985_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | esk4180_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3349,axiom,
    ( ~ esk1515_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1645_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_3350,axiom,
    ( ~ p(X20)
    | ~ esk4022_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3892_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3351,axiom,
    ( ~ esk2786_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2591_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_3352,axiom,
    ( esk5271_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5466_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3353,axiom,
    ( ~ esk4107_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4302_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_3354,axiom,
    ( p(X21)
    | ~ esk4031_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4096_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3355,axiom,
    ( ~ esk3462_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3527_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_3356,axiom,
    ( ~ esk2523_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2588_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_3357,axiom,
    ( ~ p(X16)
    | ~ esk3178_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2983_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3358,axiom,
    ( esk4305_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4110_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_3359,axiom,
    ( ~ esk4121_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3926_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_3360,axiom,
    ( ~ p(X31)
    | esk6055_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5860_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3361,axiom,
    ( esk3334_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3529_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_3362,axiom,
    ( p(X14)
    | esk2607_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2802_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3363,axiom,
    ( esk2971_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2776_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3364,axiom,
    ( ~ esk314_1(X1)
    | esk184_0
    | ~ p(X1) ) ).

cnf(i_0_3365,axiom,
    ( esk2985_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2920_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3366,axiom,
    ( ~ esk4361_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4231_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_3367,axiom,
    ( ~ esk3912_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4107_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_3368,axiom,
    ( esk4682_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | ~ esk4877_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3369,axiom,
    ( esk5727_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5532_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_3370,axiom,
    ( ~ esk1471_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1341_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3371,axiom,
    ( ~ p(X24)
    | ~ esk4808_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4678_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3372,axiom,
    ( ~ p(X24)
    | ~ esk4704_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4509_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3373,axiom,
    ( p(X31)
    | esk5981_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6046_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3374,axiom,
    ( p(X29)
    | esk5618_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5683_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3375,axiom,
    ( ~ esk2258_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2063_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_3376,axiom,
    ( ~ esk6253_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6252_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3377,axiom,
    ( ~ p(X17)
    | esk3287_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3417_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3378,axiom,
    ( ~ p(X4)
    | esk829_4(X1,X2,X3,X4)
    | ~ esk634_3(X1,X2,X3) ) ).

cnf(i_0_3379,axiom,
    ( ~ esk6014_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6144_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_3380,axiom,
    ( esk5753_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5558_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_3381,axiom,
    ( esk2260_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2130_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_3382,axiom,
    ( esk1994_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2189_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_3383,axiom,
    ( esk4472_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | ~ esk4602_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3384,axiom,
    ( p(X25)
    | ~ esk4901_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4836_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3385,axiom,
    ( esk1881_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | ~ esk2076_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3386,axiom,
    ( ~ esk3021_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2891_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_3387,axiom,
    ( ~ esk169_0
    | esk299_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_3388,axiom,
    ( esk5988_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6053_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31) ) ).

cnf(i_0_3389,axiom,
    ( ~ esk4171_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4041_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_3390,axiom,
    ( esk5909_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5844_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_3391,axiom,
    ( esk4578_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4773_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_3392,axiom,
    ( ~ esk5904_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | esk6099_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3393,axiom,
    ( p(X6)
    | ~ esk1074_5(X1,X2,X3,X4,X5)
    | esk1269_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3394,axiom,
    ( ~ p(X17)
    | esk3430_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3300_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3395,axiom,
    ( esk727_3(X1,X2,X3)
    | ~ esk792_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_3396,axiom,
    ( ~ esk371_1(X1)
    | esk501_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_3397,axiom,
    ( esk3507_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | ~ esk3637_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3398,axiom,
    ( p(X19)
    | ~ esk3746_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3681_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3399,axiom,
    ( esk4732_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4537_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3400,axiom,
    ( p(X23)
    | esk4522_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4457_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3401,axiom,
    ( ~ p(X12)
    | esk2197_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2392_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3402,axiom,
    ( ~ p(X21)
    | ~ esk4154_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3959_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3403,axiom,
    ( esk2925_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2990_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_3404,axiom,
    ( esk2612_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2417_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3405,axiom,
    ( ~ esk1639_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1444_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_3406,axiom,
    ( ~ p(X18)
    | ~ esk3484_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3614_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3407,axiom,
    ( ~ p(X21)
    | esk4097_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3902_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3408,axiom,
    ( ~ esk2925_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2990_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3409,axiom,
    ( ~ esk4286_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4351_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3410,axiom,
    ( ~ p(X21)
    | esk4088_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4218_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3411,axiom,
    ( ~ esk818_4(X1,X2,X3,X4)
    | ~ p(X5)
    | esk1013_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3412,axiom,
    ( ~ p(X8)
    | ~ esk1587_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1392_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3413,axiom,
    ( esk1050_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk920_4(X1,X2,X3,X4) ) ).

cnf(i_0_3414,axiom,
    ( ~ p(X18)
    | esk3329_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3524_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3415,axiom,
    ( ~ esk4142_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3947_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_3416,axiom,
    ( ~ p(X12)
    | ~ esk2433_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2303_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3417,axiom,
    ( esk5717_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5652_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29) ) ).

cnf(i_0_3418,axiom,
    ( ~ esk3103_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | esk3168_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3419,axiom,
    ( p(X5)
    | esk882_4(X1,X2,X3,X4)
    | ~ esk1077_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3420,axiom,
    ( ~ esk420_2(X1,X2)
    | esk355_1(X1)
    | p(X2) ) ).

cnf(i_0_3421,axiom,
    ( ~ esk1531_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1596_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_3422,axiom,
    ( esk5884_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6079_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_3423,axiom,
    ( p(X28)
    | esk5562_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5367_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3424,axiom,
    ( ~ esk1222_6(X1,X2,X3,X4,X5,X6)
    | esk1157_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_3425,axiom,
    ( p(X14)
    | esk2778_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2713_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3426,axiom,
    ( ~ p(X12)
    | ~ esk2382_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2187_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3427,axiom,
    ( p(X4)
    | ~ esk875_4(X1,X2,X3,X4)
    | esk680_3(X1,X2,X3) ) ).

cnf(i_0_3428,axiom,
    ( ~ esk2835_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2705_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3429,axiom,
    ( ~ esk1373_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1308_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_3430,axiom,
    ( ~ esk3877_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4007_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_3431,axiom,
    ( ~ p(X24)
    | ~ esk4791_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4661_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3432,axiom,
    ( ~ esk5226_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | esk5356_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3433,axiom,
    ( ~ esk449_2(X1,X2)
    | ~ p(X3)
    | esk644_3(X1,X2,X3) ) ).

cnf(i_0_3434,axiom,
    ( esk3770_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3575_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_3435,axiom,
    ( ~ p(X27)
    | ~ esk5280_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5085_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3436,axiom,
    ( ~ esk1395_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1330_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_3437,axiom,
    ( ~ p(X17)
    | esk3426_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3296_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3438,axiom,
    ( esk2451_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2256_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_3439,axiom,
    ( p(X5)
    | ~ esk938_4(X1,X2,X3,X4)
    | esk1003_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3440,axiom,
    ( esk1591_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1786_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3441,axiom,
    ( ~ esk6345_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6280_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6247_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3442,axiom,
    ( esk3849_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3914_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_3443,axiom,
    ( p(X1)
    | ~ esk185_0
    | esk250_1(X1) ) ).

cnf(i_0_3444,axiom,
    ( esk6183_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6248_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_3445,axiom,
    ( ~ esk5960_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5765_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_3446,axiom,
    ( esk3306_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | ~ esk3371_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3447,axiom,
    ( esk2769_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2704_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_3448,axiom,
    ( esk2575_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2770_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_3449,axiom,
    ( ~ esk2618_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2813_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_3450,axiom,
    ( esk3188_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3058_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3451,axiom,
    ( ~ p(X26)
    | ~ esk5166_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5036_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3452,axiom,
    ( ~ p(X16)
    | ~ esk3226_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3096_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3453,axiom,
    ( ~ esk5405_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5470_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_3454,axiom,
    ( esk5890_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | ~ esk5825_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3455,axiom,
    ( ~ esk2135_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2265_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_3456,axiom,
    ( ~ esk3942_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3877_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_3457,axiom,
    ( p(X2)
    | ~ esk512_2(X1,X2)
    | esk317_1(X1) ) ).

cnf(i_0_3458,axiom,
    ( ~ esk3691_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3756_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3459,axiom,
    ( ~ p(X1)
    | esk12_0
    | ~ esk207_1(X1) ) ).

cnf(i_0_3460,axiom,
    ( ~ esk4562_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4367_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_3461,axiom,
    ( ~ esk5877_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5812_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_3462,axiom,
    ( ~ esk3664_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3729_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_3463,axiom,
    ( p(X10)
    | ~ esk2031_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1836_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3464,axiom,
    ( ~ esk5729_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5924_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3465,axiom,
    ( ~ p(X14)
    | esk2723_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2853_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3466,axiom,
    ( ~ esk3974_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4169_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21) ) ).

cnf(i_0_3467,axiom,
    ( esk5097_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5032_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_3468,axiom,
    ( esk3843_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3908_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_3469,axiom,
    ( ~ esk4365_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4560_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_3470,axiom,
    ( p(X13)
    | esk2664_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2469_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3471,axiom,
    ( ~ esk6161_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5966_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_3472,axiom,
    ( esk6255_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | ~ esk6060_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3473,axiom,
    ( esk1253_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1448_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_3474,axiom,
    ( esk6275_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6340_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6242_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3475,axiom,
    ( ~ esk1584_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1389_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_3476,axiom,
    ( ~ p(X32)
    | esk6055_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6250_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3477,axiom,
    ( ~ p(X23)
    | esk4579_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4449_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3478,axiom,
    ( ~ esk4133_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4328_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3479,axiom,
    ( ~ p(X31)
    | ~ esk6147_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6017_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3480,axiom,
    ( ~ esk1822_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | esk2017_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3481,axiom,
    ( ~ esk181_0
    | esk311_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_3482,axiom,
    ( ~ p(X19)
    | ~ esk3805_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3675_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3483,axiom,
    ( ~ esk5329_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | esk5524_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3484,axiom,
    ( ~ esk2636_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | esk2441_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3485,axiom,
    ( ~ esk3125_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2930_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_3486,axiom,
    ( p(X21)
    | ~ esk4162_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3967_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3487,axiom,
    ( esk4017_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3887_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_3488,axiom,
    ( ~ esk5564_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5759_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_3489,axiom,
    ( esk1430_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1625_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3490,axiom,
    ( ~ p(X15)
    | ~ esk2974_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2779_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3491,axiom,
    ( ~ esk2930_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2865_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3492,axiom,
    ( esk3042_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | ~ esk2912_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3493,axiom,
    ( ~ esk5979_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | esk6174_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3494,axiom,
    ( p(X27)
    | esk5354_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5159_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3495,axiom,
    ( esk1336_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1401_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_3496,axiom,
    ( esk2677_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2807_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3497,axiom,
    ( esk4096_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3901_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_3498,axiom,
    ( ~ p(X6)
    | esk1198_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1003_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3499,axiom,
    ( ~ esk1898_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2028_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_3500,axiom,
    ( ~ p(X27)
    | esk5204_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5334_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3501,axiom,
    ( p(X9)
    | ~ esk1741_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1806_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3502,axiom,
    ( p(X1)
    | esk300_1(X1)
    | ~ esk105_0 ) ).

cnf(i_0_3503,axiom,
    ( ~ p(X14)
    | esk2594_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2789_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3504,axiom,
    ( ~ esk4612_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4482_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3505,axiom,
    ( ~ p(X12)
    | esk2436_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2306_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3506,axiom,
    ( ~ esk2616_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | esk2421_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3507,axiom,
    ( ~ esk3783_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3588_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_3508,axiom,
    ( esk5971_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5841_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_3509,axiom,
    ( ~ esk3848_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3913_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3510,axiom,
    ( ~ p(X13)
    | esk2585_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2390_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3511,axiom,
    ( esk273_1(X1)
    | p(X2)
    | ~ esk468_2(X1,X2) ) ).

cnf(i_0_3512,axiom,
    ( esk6028_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6093_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3513,axiom,
    ( esk5803_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5933_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3514,axiom,
    ( ~ p(X27)
    | ~ esk5267_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5072_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3515,axiom,
    ( p(X26)
    | ~ esk5121_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5056_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3516,axiom,
    ( ~ esk271_1(X1)
    | p(X2)
    | esk466_2(X1,X2) ) ).

cnf(i_0_3517,axiom,
    ( ~ esk3967_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3772_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_3518,axiom,
    ( ~ esk2764_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2569_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3519,axiom,
    ( esk3755_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3690_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3520,axiom,
    ( ~ p(X6)
    | esk1131_5(X1,X2,X3,X4,X5)
    | ~ esk1261_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3521,axiom,
    ( esk1169_5(X1,X2,X3,X4,X5)
    | ~ esk1299_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_3522,axiom,
    ( p(X24)
    | ~ esk4593_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4788_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3523,axiom,
    ( esk1176_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk981_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3524,axiom,
    ( p(X23)
    | esk4494_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4429_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3525,axiom,
    ( ~ esk3944_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4139_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_3526,axiom,
    ( ~ p(X26)
    | ~ esk4934_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5129_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3527,axiom,
    ( esk2393_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2588_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_3528,axiom,
    ( ~ esk5780_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5650_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_3529,axiom,
    ( ~ esk5149_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | esk4954_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3530,axiom,
    ( ~ esk2592_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | esk2527_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3531,axiom,
    ( esk5226_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5291_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_3532,axiom,
    ( p(X3)
    | esk712_3(X1,X2,X3)
    | ~ esk517_2(X1,X2) ) ).

cnf(i_0_3533,axiom,
    ( p(X23)
    | ~ esk4540_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4475_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3534,axiom,
    ( ~ p(X13)
    | esk2555_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2360_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3535,axiom,
    ( ~ p(X25)
    | ~ esk4960_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4830_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3536,axiom,
    ( esk4846_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4911_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3537,axiom,
    ( esk5699_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5504_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_3538,axiom,
    ( ~ esk2847_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2717_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3539,axiom,
    ( p(X26)
    | esk5126_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5061_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3540,axiom,
    ( esk2770_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2705_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3541,axiom,
    ( ~ esk3639_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3509_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_3542,axiom,
    ( ~ esk1966_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1901_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_3543,axiom,
    ( esk3575_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3380_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3544,axiom,
    ( ~ p(X18)
    | ~ esk3494_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3624_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3545,axiom,
    ( ~ esk5973_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5843_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_3546,axiom,
    ( p(X5)
    | ~ esk1079_5(X1,X2,X3,X4,X5)
    | esk884_4(X1,X2,X3,X4) ) ).

cnf(i_0_3547,axiom,
    ( ~ p(X26)
    | esk5038_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5168_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3548,axiom,
    ( ~ p(X7)
    | esk1353_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1483_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3549,axiom,
    ( ~ p(X24)
    | ~ esk4780_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4650_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3550,axiom,
    ( ~ esk6264_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6296_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3551,axiom,
    ( ~ p(X13)
    | esk2521_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2651_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3552,axiom,
    ( ~ esk4210_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4080_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_3553,axiom,
    ( ~ esk3992_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | esk3797_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3554,axiom,
    ( esk2469_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2339_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3555,axiom,
    ( esk2383_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | ~ esk2578_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3556,axiom,
    ( p(X19)
    | esk3608_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3803_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3557,axiom,
    ( ~ p(X24)
    | esk4642_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4772_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3558,axiom,
    ( ~ esk5999_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6129_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_3559,axiom,
    ( esk4195_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | ~ esk4000_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3560,axiom,
    ( ~ p(X8)
    | ~ esk1630_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1500_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3561,axiom,
    ( ~ p(X1)
    | esk165_0
    | ~ esk295_1(X1) ) ).

cnf(i_0_3562,axiom,
    ( ~ esk1911_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | esk1976_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3563,axiom,
    ( esk3802_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk3997_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3564,axiom,
    ( esk3408_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3278_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_3565,axiom,
    ( ~ esk5079_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | esk4884_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3566,axiom,
    ( esk5176_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5046_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_3567,axiom,
    ( esk430_2(X1,X2)
    | ~ esk625_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_3568,axiom,
    ( ~ esk2809_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2614_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_3569,axiom,
    ( ~ p(X27)
    | ~ esk5307_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5112_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3570,axiom,
    ( ~ esk3028_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2833_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3571,axiom,
    ( ~ p(X10)
    | ~ esk1966_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1771_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3572,axiom,
    ( p(X12)
    | ~ esk2408_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2213_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3573,axiom,
    ( p(X6)
    | ~ esk1136_5(X1,X2,X3,X4,X5)
    | esk1201_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3574,axiom,
    ( ~ esk4744_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4939_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3575,axiom,
    ( esk1746_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1811_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9) ) ).

cnf(i_0_3576,axiom,
    ( ~ esk4684_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4489_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_3577,axiom,
    ( esk3221_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16)
    | ~ esk3026_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3578,axiom,
    ( ~ esk1121_5(X1,X2,X3,X4,X5)
    | esk1251_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_3579,axiom,
    ( ~ p(X22)
    | esk4394_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4264_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3580,axiom,
    ( ~ esk3059_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3189_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3581,axiom,
    ( esk4556_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4751_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_3582,axiom,
    ( ~ esk4016_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3821_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_3583,axiom,
    ( esk843_4(X1,X2,X3,X4)
    | ~ esk778_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_3584,axiom,
    ( p(X4)
    | esk787_4(X1,X2,X3,X4)
    | ~ esk722_3(X1,X2,X3) ) ).

cnf(i_0_3585,axiom,
    ( ~ esk3121_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk2926_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3586,axiom,
    ( ~ p(X12)
    | esk2191_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2386_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3587,axiom,
    ( esk4763_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4633_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_3588,axiom,
    ( p(X21)
    | ~ esk3995_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4190_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3589,axiom,
    ( ~ esk5043_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5108_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_3590,axiom,
    ( p(X15)
    | ~ esk3004_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2809_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3591,axiom,
    ( ~ esk6072_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | esk5877_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3592,axiom,
    ( ~ esk2464_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2269_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_3593,axiom,
    ( p(X17)
    | esk3377_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3312_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3594,axiom,
    ( ~ p(X2)
    | esk481_2(X1,X2)
    | ~ esk351_1(X1) ) ).

cnf(i_0_3595,axiom,
    ( p(X4)
    | ~ esk759_3(X1,X2,X3)
    | esk824_4(X1,X2,X3,X4) ) ).

cnf(i_0_3596,axiom,
    ( esk1724_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1854_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3597,axiom,
    ( ~ esk1063_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk1258_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3598,axiom,
    ( p(X30)
    | ~ esk5784_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5979_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3599,axiom,
    ( ~ esk1178_6(X1,X2,X3,X4,X5,X6)
    | esk1373_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_3600,axiom,
    ( ~ esk3364_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | esk3169_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3601,axiom,
    ( esk912_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk1042_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3602,axiom,
    ( ~ esk3239_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3044_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_3603,axiom,
    ( ~ esk2788_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2593_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3604,axiom,
    ( esk3050_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3245_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_3605,axiom,
    ( esk4024_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3894_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_3606,axiom,
    ( ~ esk1456_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1326_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3607,axiom,
    ( esk6097_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | ~ esk5902_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3608,axiom,
    ( ~ esk291_1(X1)
    | ~ p(X1)
    | esk161_0 ) ).

cnf(i_0_3609,axiom,
    ( esk3957_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3892_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3610,axiom,
    ( esk3744_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3679_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_3611,axiom,
    ( ~ esk2921_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | esk3051_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3612,axiom,
    ( p(X11)
    | esk2223_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2028_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3613,axiom,
    ( p(X9)
    | esk1718_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1783_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3614,axiom,
    ( ~ esk745_3(X1,X2,X3)
    | esk810_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_3615,axiom,
    ( ~ esk4923_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5118_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_3616,axiom,
    ( esk2727_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | ~ esk2792_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3617,axiom,
    ( esk4966_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4836_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_3618,axiom,
    ( ~ esk4965_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5160_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_3619,axiom,
    ( ~ esk104_0
    | p(X1)
    | esk299_1(X1) ) ).

cnf(i_0_3620,axiom,
    ( ~ esk683_3(X1,X2,X3)
    | ~ p(X3)
    | esk553_2(X1,X2) ) ).

cnf(i_0_3621,axiom,
    ( ~ p(X14)
    | esk2670_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2800_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3622,axiom,
    ( esk1220_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1025_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_3623,axiom,
    ( esk6311_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6312_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3624,axiom,
    ( ~ esk4927_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4732_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_3625,axiom,
    ( ~ esk2105_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2170_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_3626,axiom,
    ( esk4750_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4620_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3627,axiom,
    ( esk4535_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4730_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3628,axiom,
    ( ~ esk679_3(X1,X2,X3)
    | p(X4)
    | esk874_4(X1,X2,X3,X4) ) ).

cnf(i_0_3629,axiom,
    ( esk1899_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1964_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_3630,axiom,
    ( p(X9)
    | ~ esk1629_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1824_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3631,axiom,
    ( p(X32)
    | ~ esk6175_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6370_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3632,axiom,
    ( p(X8)
    | esk1546_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1611_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3633,axiom,
    ( esk3174_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | ~ esk3369_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3634,axiom,
    ( ~ esk3447_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3577_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3635,axiom,
    ( ~ esk5385_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | esk5255_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3636,axiom,
    ( ~ esk4434_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4564_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3637,axiom,
    ( esk1858_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1663_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_3638,axiom,
    ( esk3360_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3295_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3639,axiom,
    ( ~ esk2541_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2346_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_3640,axiom,
    ( ~ esk571_2(X1,X2)
    | ~ p(X3)
    | esk701_3(X1,X2,X3) ) ).

cnf(i_0_3641,axiom,
    ( esk2924_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | ~ esk3054_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3642,axiom,
    ( ~ p(X22)
    | esk4103_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4298_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3643,axiom,
    ( esk4184_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | ~ esk4054_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3644,axiom,
    ( ~ esk4054_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | esk4119_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3645,axiom,
    ( esk2385_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2190_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3646,axiom,
    ( ~ esk5411_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5541_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_3647,axiom,
    ( p(X12)
    | ~ esk2243_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2438_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3648,axiom,
    ( ~ esk4614_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4419_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3649,axiom,
    ( ~ p(X19)
    | ~ esk3525_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3720_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3650,axiom,
    ( p(X29)
    | esk5719_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5654_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3651,axiom,
    ( esk5575_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X29)
    | ~ esk5770_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3652,axiom,
    ( esk5639_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5769_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_3653,axiom,
    ( ~ esk1202_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk1397_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3654,axiom,
    ( ~ p(X14)
    | ~ esk2811_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2681_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3655,axiom,
    ( p(X12)
    | ~ esk2389_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2324_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3656,axiom,
    ( esk3659_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3789_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3657,axiom,
    ( esk2722_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2852_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3658,axiom,
    ( ~ esk866_4(X1,X2,X3,X4)
    | esk671_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_3659,axiom,
    ( ~ p(X10)
    | esk2062_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1932_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3660,axiom,
    ( p(X23)
    | esk4583_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4388_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3661,axiom,
    ( p(X21)
    | ~ esk4043_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4108_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3662,axiom,
    ( p(X19)
    | ~ esk3782_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3587_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3663,axiom,
    ( ~ p(X31)
    | ~ esk6099_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5904_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3664,axiom,
    ( ~ esk2210_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2015_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_3665,axiom,
    ( ~ esk825_4(X1,X2,X3,X4)
    | p(X4)
    | esk760_3(X1,X2,X3) ) ).

cnf(i_0_3666,axiom,
    ( esk842_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk647_3(X1,X2,X3) ) ).

cnf(i_0_3667,axiom,
    ( esk612_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk807_4(X1,X2,X3,X4) ) ).

cnf(i_0_3668,axiom,
    ( ~ p(X26)
    | esk4911_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5106_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3669,axiom,
    ( ~ esk3446_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3576_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3670,axiom,
    ( ~ p(X16)
    | esk3091_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3221_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3671,axiom,
    ( esk1627_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1822_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3672,axiom,
    ( ~ p(X26)
    | ~ esk5016_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5146_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3673,axiom,
    ( p(X15)
    | ~ esk2856_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3051_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3674,axiom,
    ( esk684_3(X1,X2,X3)
    | p(X4)
    | ~ esk879_4(X1,X2,X3,X4) ) ).

cnf(i_0_3675,axiom,
    ( ~ esk6243_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6244_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6276_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3676,axiom,
    ( esk2715_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | ~ esk2780_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3677,axiom,
    ( p(X22)
    | ~ esk4209_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4404_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3678,axiom,
    ( ~ p(X17)
    | ~ esk3251_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3381_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3679,axiom,
    ( ~ p(X3)
    | ~ esk414_2(X1,X2)
    | esk609_3(X1,X2,X3) ) ).

cnf(i_0_3680,axiom,
    ( esk5805_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5870_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_3681,axiom,
    ( ~ p(X17)
    | esk3371_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3176_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3682,axiom,
    ( ~ p(X16)
    | ~ esk2938_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3133_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3683,axiom,
    ( esk4438_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4503_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3684,axiom,
    ( ~ esk6276_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6243_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6341_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3685,axiom,
    ( ~ esk4789_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | esk4594_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3686,axiom,
    ( ~ esk3048_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | esk2918_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3687,axiom,
    ( ~ p(X8)
    | ~ esk1505_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1635_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3688,axiom,
    ( ~ esk3476_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3541_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3689,axiom,
    ( ~ esk6332_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | esk6202_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3690,axiom,
    ( esk2054_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2249_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_3691,axiom,
    ( p(X28)
    | ~ esk5448_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5513_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3692,axiom,
    ( ~ esk3395_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3200_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3693,axiom,
    ( ~ esk5559_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5429_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3694,axiom,
    ( ~ esk6287_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6352_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3695,axiom,
    ( ~ p(X20)
    | ~ esk3840_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3970_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3696,axiom,
    ( ~ esk1494_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1689_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8) ) ).

cnf(i_0_3697,axiom,
    ( esk4555_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4360_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_3698,axiom,
    ( esk1047_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1242_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3699,axiom,
    ( ~ esk164_0
    | p(X1)
    | esk229_1(X1) ) ).

cnf(i_0_3700,axiom,
    ( ~ p(X17)
    | esk3286_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3416_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3701,axiom,
    ( ~ p(X5)
    | esk976_5(X1,X2,X3,X4,X5)
    | ~ esk781_4(X1,X2,X3,X4) ) ).

cnf(i_0_3702,axiom,
    ( ~ esk4410_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4215_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_3703,axiom,
    ( p(X22)
    | ~ esk4200_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4395_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3704,axiom,
    ( esk2461_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2656_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_3705,axiom,
    ( esk1119_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1184_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3706,axiom,
    ( ~ p(X30)
    | ~ esk5952_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5822_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3707,axiom,
    ( esk521_2(X1,X2)
    | p(X3)
    | ~ esk586_3(X1,X2,X3) ) ).

cnf(i_0_3708,axiom,
    ( p(X3)
    | esk530_2(X1,X2)
    | ~ esk595_3(X1,X2,X3) ) ).

cnf(i_0_3709,axiom,
    ( p(X15)
    | ~ esk3044_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2849_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3710,axiom,
    ( ~ esk1816_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1621_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_3711,axiom,
    ( ~ p(X22)
    | ~ esk4108_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4303_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3712,axiom,
    ( esk509_2(X1,X2)
    | ~ esk379_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_3713,axiom,
    ( ~ esk6094_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6289_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_3714,axiom,
    ( esk2138_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2203_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_3715,axiom,
    ( esk92_0
    | ~ esk287_1(X1)
    | p(X1) ) ).

cnf(i_0_3716,axiom,
    ( ~ p(X5)
    | esk969_4(X1,X2,X3,X4)
    | ~ esk1099_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3717,axiom,
    ( p(X11)
    | ~ esk2169_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2104_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3718,axiom,
    ( p(X5)
    | ~ esk946_4(X1,X2,X3,X4)
    | esk1011_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3719,axiom,
    ( ~ esk4640_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | esk4770_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3720,axiom,
    ( p(X27)
    | ~ esk5372_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5177_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3721,axiom,
    ( ~ esk3689_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3819_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_3722,axiom,
    ( ~ esk4319_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | esk4254_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3723,axiom,
    ( p(X2)
    | esk437_2(X1,X2)
    | ~ esk372_1(X1) ) ).

cnf(i_0_3724,axiom,
    ( esk153_0
    | ~ esk218_1(X1)
    | p(X1) ) ).

cnf(i_0_3725,axiom,
    ( esk75_0
    | p(X1)
    | ~ esk270_1(X1) ) ).

cnf(i_0_3726,axiom,
    ( ~ esk4594_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | esk4464_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3727,axiom,
    ( p(X22)
    | esk4345_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4280_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3728,axiom,
    ( ~ esk5311_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5506_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_3729,axiom,
    ( ~ p(X30)
    | ~ esk5919_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5789_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_3730,axiom,
    ( ~ esk3081_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3211_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3731,axiom,
    ( p(X29)
    | esk5681_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5616_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3732,axiom,
    ( ~ p(X21)
    | esk4161_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4031_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3733,axiom,
    ( p(X31)
    | esk6147_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5952_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3734,axiom,
    ( p(X27)
    | esk5392_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5197_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3735,axiom,
    ( ~ p(X7)
    | esk1439_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1309_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3736,axiom,
    ( esk5578_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5383_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_3737,axiom,
    ( ~ p(X4)
    | esk889_4(X1,X2,X3,X4)
    | ~ esk759_3(X1,X2,X3) ) ).

cnf(i_0_3738,axiom,
    ( p(X27)
    | ~ esk5251_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5316_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3739,axiom,
    ( esk1564_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1499_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3740,axiom,
    ( esk1738_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1803_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3741,axiom,
    ( p(X31)
    | esk5979_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6174_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3742,axiom,
    ( esk4428_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4493_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3743,axiom,
    ( ~ p(X17)
    | ~ esk3393_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3263_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3744,axiom,
    ( esk1570_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1505_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3745,axiom,
    ( ~ p(X14)
    | ~ esk2725_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2855_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3746,axiom,
    ( ~ esk2700_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2765_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14) ) ).

cnf(i_0_3747,axiom,
    ( ~ esk4871_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk5001_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3748,axiom,
    ( esk1099_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1294_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3749,axiom,
    ( ~ p(X2)
    | esk238_1(X1)
    | ~ esk433_2(X1,X2) ) ).

cnf(i_0_3750,axiom,
    ( ~ esk4334_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4269_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_3751,axiom,
    ( esk4793_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4988_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3752,axiom,
    ( ~ esk2216_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | esk2086_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3753,axiom,
    ( esk6285_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | ~ esk6090_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3754,axiom,
    ( ~ esk3629_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3824_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3755,axiom,
    ( ~ esk1225_6(X1,X2,X3,X4,X5,X6)
    | esk1420_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_3756,axiom,
    ( esk6136_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6331_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_3757,axiom,
    ( esk4363_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4233_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_3758,axiom,
    ( esk4413_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4283_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_3759,axiom,
    ( ~ esk804_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk609_3(X1,X2,X3) ) ).

cnf(i_0_3760,axiom,
    ( ~ p(X4)
    | esk618_3(X1,X2,X3)
    | ~ esk813_4(X1,X2,X3,X4) ) ).

cnf(i_0_3761,axiom,
    ( p(X5)
    | ~ esk1093_5(X1,X2,X3,X4,X5)
    | esk898_4(X1,X2,X3,X4) ) ).

cnf(i_0_3762,axiom,
    ( p(X2)
    | esk472_2(X1,X2)
    | ~ esk277_1(X1) ) ).

cnf(i_0_3763,axiom,
    ( esk3967_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3772_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_3764,axiom,
    ( esk228_1(X1)
    | ~ esk423_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_3765,axiom,
    ( esk4807_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4677_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3766,axiom,
    ( esk319_1(X1)
    | ~ esk189_0
    | ~ p(X1) ) ).

cnf(i_0_3767,axiom,
    ( esk3542_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3737_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3768,axiom,
    ( ~ esk5358_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5228_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_3769,axiom,
    ( ~ esk5417_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | esk5547_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3770,axiom,
    ( ~ esk4968_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4838_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_3771,axiom,
    ( esk789_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk594_3(X1,X2,X3) ) ).

cnf(i_0_3772,axiom,
    ( esk2014_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1949_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_3773,axiom,
    ( ~ p(X8)
    | esk1666_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1536_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3774,axiom,
    ( ~ esk5324_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5129_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_3775,axiom,
    ( esk6369_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6174_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_3776,axiom,
    ( p(X6)
    | ~ esk1158_5(X1,X2,X3,X4,X5)
    | esk1223_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3777,axiom,
    ( ~ esk561_2(X1,X2)
    | esk691_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_3778,axiom,
    ( esk3599_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | ~ esk3469_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3779,axiom,
    ( ~ esk2620_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2425_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_3780,axiom,
    ( p(X13)
    | ~ esk2535_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2600_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3781,axiom,
    ( ~ esk3659_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3789_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3782,axiom,
    ( p(X4)
    | esk695_3(X1,X2,X3)
    | ~ esk890_4(X1,X2,X3,X4) ) ).

cnf(i_0_3783,axiom,
    ( ~ p(X9)
    | esk1854_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1724_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3784,axiom,
    ( esk5816_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5946_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_3785,axiom,
    ( esk6074_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6009_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_3786,axiom,
    ( p(X22)
    | ~ esk4357_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4162_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3787,axiom,
    ( ~ esk930_4(X1,X2,X3,X4)
    | esk995_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_3788,axiom,
    ( esk1891_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1956_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_3789,axiom,
    ( esk717_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk847_4(X1,X2,X3,X4) ) ).

cnf(i_0_3790,axiom,
    ( esk2597_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2402_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_3791,axiom,
    ( esk515_2(X1,X2)
    | p(X3)
    | ~ esk710_3(X1,X2,X3) ) ).

cnf(i_0_3792,axiom,
    ( p(X14)
    | esk2739_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2674_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3793,axiom,
    ( ~ esk4750_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | esk4555_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3794,axiom,
    ( esk4878_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | ~ esk4683_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3795,axiom,
    ( esk6256_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6289_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6354_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3796,axiom,
    ( p(X23)
    | esk4464_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4529_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3797,axiom,
    ( ~ p(X8)
    | ~ esk1596_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1401_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3798,axiom,
    ( esk2569_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2504_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3799,axiom,
    ( esk299_1(X1)
    | p(X2)
    | ~ esk494_2(X1,X2) ) ).

cnf(i_0_3800,axiom,
    ( ~ esk2201_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2006_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_3801,axiom,
    ( ~ esk3158_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2963_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_3802,axiom,
    ( ~ p(X28)
    | ~ esk5540_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5410_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3803,axiom,
    ( ~ p(X12)
    | ~ esk2408_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2278_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3804,axiom,
    ( p(X31)
    | ~ esk6103_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6038_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3805,axiom,
    ~ esk44_0 ).

cnf(i_0_3806,axiom,
    ( esk6322_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | ~ esk6127_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3807,axiom,
    ( esk3552_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3747_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_3808,axiom,
    ( esk3065_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3195_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_3809,axiom,
    ( esk1358_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1488_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_3810,axiom,
    ( esk474_2(X1,X2)
    | ~ esk669_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_3811,axiom,
    ( ~ esk1373_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk1568_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3812,axiom,
    ( ~ esk6240_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | esk6370_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3813,axiom,
    ( ~ esk2546_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | esk2481_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3814,axiom,
    ( ~ p(X20)
    | esk3916_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3721_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3815,axiom,
    ( esk2482_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2547_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3816,axiom,
    ( esk5197_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | ~ esk5002_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3817,axiom,
    ( p(X4)
    | ~ esk702_3(X1,X2,X3)
    | esk897_4(X1,X2,X3,X4) ) ).

cnf(i_0_3818,axiom,
    ( ~ p(X26)
    | ~ esk4928_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5123_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3819,axiom,
    ( ~ esk2186_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2381_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_3820,axiom,
    ( p(X2)
    | esk456_2(X1,X2)
    | ~ esk261_1(X1) ) ).

cnf(i_0_3821,axiom,
    ( esk905_4(X1,X2,X3,X4)
    | ~ esk775_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3822,axiom,
    ( ~ esk1107_5(X1,X2,X3,X4,X5)
    | esk1237_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_3823,axiom,
    ( ~ esk5152_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5022_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_3824,axiom,
    ( ~ p(X11)
    | ~ esk2000_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2195_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3825,axiom,
    ( esk3853_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk3918_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3826,axiom,
    ( ~ esk3979_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20)
    | esk3849_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3827,axiom,
    ( ~ esk2214_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2409_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3828,axiom,
    ( p(X31)
    | esk5927_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6122_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3829,axiom,
    ( p(X19)
    | esk3694_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3759_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3830,axiom,
    ( esk2804_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2609_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_3831,axiom,
    ( ~ esk4678_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4743_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_3832,axiom,
    ( ~ esk6283_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6088_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_3833,axiom,
    ( ~ esk4739_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | esk4544_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3834,axiom,
    ( esk1920_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1985_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_3835,axiom,
    ( ~ p(X7)
    | esk1225_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1420_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3836,axiom,
    ( p(X17)
    | esk3318_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3253_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3837,axiom,
    ( p(X15)
    | esk2879_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2944_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3838,axiom,
    ( ~ esk1965_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1900_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3839,axiom,
    ( esk6328_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6329_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3840,axiom,
    ( ~ esk5831_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5896_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_3841,axiom,
    ( ~ esk2047_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1917_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_3842,axiom,
    ( ~ esk3274_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3404_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3843,axiom,
    ( ~ esk2442_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2247_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3844,axiom,
    ( ~ esk2633_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2503_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_3845,axiom,
    ( ~ esk2370_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2175_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3846,axiom,
    ( p(X17)
    | esk3357_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3292_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3847,axiom,
    ( ~ esk6365_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6235_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_3848,axiom,
    ( ~ esk6362_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6297_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6264_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3849,axiom,
    ( ~ esk6257_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6290_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6258_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3850,axiom,
    ( ~ p(X19)
    | esk3677_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3807_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3851,axiom,
    ( p(X6)
    | ~ esk1164_5(X1,X2,X3,X4,X5)
    | esk1229_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3852,axiom,
    ( esk279_1(X1)
    | p(X1)
    | ~ esk84_0 ) ).

cnf(i_0_3853,axiom,
    ( ~ esk6308_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | esk6113_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3854,axiom,
    ( p(X15)
    | ~ esk3045_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2850_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3855,axiom,
    ( esk3265_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3395_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_3856,axiom,
    ( ~ esk559_2(X1,X2)
    | esk624_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_3857,axiom,
    ( ~ esk3182_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3117_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_3858,axiom,
    ( ~ esk4506_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4701_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_3859,axiom,
    ( esk660_3(X1,X2,X3)
    | ~ p(X3)
    | ~ esk530_2(X1,X2) ) ).

cnf(i_0_3860,axiom,
    ( ~ esk6234_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6299_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_3861,axiom,
    ( ~ esk1095_5(X1,X2,X3,X4,X5)
    | esk1290_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_3862,axiom,
    ( p(X27)
    | ~ esk5338_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5143_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3863,axiom,
    ( ~ esk2589_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | esk2394_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3864,axiom,
    ( ~ esk6263_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6296_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6361_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3865,axiom,
    ( esk1207_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1402_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_3866,axiom,
    ( ~ p(X25)
    | esk4968_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4838_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_3867,axiom,
    ( p(X17)
    | esk3275_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3340_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3868,axiom,
    ( ~ esk4125_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | esk3930_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3869,axiom,
    ( esk3100_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3230_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3870,axiom,
    ( esk1082_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1277_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3871,axiom,
    ( ~ esk5688_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5493_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_3872,axiom,
    ( ~ esk1031_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk1226_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3873,axiom,
    ( ~ esk3555_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3750_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3874,axiom,
    ( p(X32)
    | esk6276_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6211_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_3875,axiom,
    ( ~ p(X9)
    | ~ esk1782_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1587_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3876,axiom,
    ( esk1428_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1233_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_3877,axiom,
    ( ~ p(X5)
    | ~ esk789_4(X1,X2,X3,X4)
    | esk984_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_3878,axiom,
    ( ~ p(X11)
    | ~ esk2250_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2120_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3879,axiom,
    ( ~ p(X4)
    | ~ esk833_4(X1,X2,X3,X4)
    | esk638_3(X1,X2,X3) ) ).

cnf(i_0_3880,axiom,
    ( p(X10)
    | esk1938_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2003_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3881,axiom,
    ( p(X21)
    | esk4021_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4216_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3882,axiom,
    ( ~ esk886_4(X1,X2,X3,X4)
    | esk756_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3883,axiom,
    ( esk2395_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2330_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3884,axiom,
    ( p(X12)
    | ~ esk2394_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2329_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3885,axiom,
    ( ~ p(X8)
    | esk1632_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1502_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_3886,axiom,
    ( ~ esk3331_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3266_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3887,axiom,
    ( ~ esk276_1(X1)
    | esk471_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_3888,axiom,
    ( ~ p(X20)
    | esk3837_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3967_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3889,axiom,
    ( ~ p(X22)
    | ~ esk4324_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4129_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3890,axiom,
    ( ~ esk2569_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2504_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13) ) ).

cnf(i_0_3891,axiom,
    ( ~ esk3032_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2837_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3892,axiom,
    ( ~ esk2098_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2163_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_3893,axiom,
    ( p(X23)
    | ~ esk4358_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4553_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3894,axiom,
    ( ~ esk869_4(X1,X2,X3,X4)
    | p(X4)
    | esk674_3(X1,X2,X3) ) ).

cnf(i_0_3895,axiom,
    ( ~ esk4938_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5133_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_3896,axiom,
    ( p(X12)
    | ~ esk2321_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2386_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3897,axiom,
    ( esk5219_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5349_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3898,axiom,
    ( esk4098_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | ~ esk4293_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3899,axiom,
    ( ~ esk3121_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3056_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_3900,axiom,
    ( esk2528_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | ~ esk2658_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3901,axiom,
    ( ~ esk3822_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3627_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3902,axiom,
    ( esk5081_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk4886_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3903,axiom,
    ( p(X22)
    | esk4278_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4343_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3904,axiom,
    ( ~ esk4554_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4359_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3905,axiom,
    ( esk505_2(X1,X2)
    | ~ esk375_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_3906,axiom,
    ( ~ esk4451_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4581_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3907,axiom,
    ( p(X3)
    | ~ esk623_3(X1,X2,X3)
    | esk558_2(X1,X2) ) ).

cnf(i_0_3908,axiom,
    ( ~ esk5038_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5168_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_3909,axiom,
    ( p(X22)
    | ~ esk4412_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4217_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3910,axiom,
    ( ~ p(X4)
    | esk601_3(X1,X2,X3)
    | ~ esk796_4(X1,X2,X3,X4) ) ).

cnf(i_0_3911,axiom,
    ( esk1546_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1676_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_3912,axiom,
    ( esk600_3(X1,X2,X3)
    | p(X3)
    | ~ esk535_2(X1,X2) ) ).

cnf(i_0_3913,axiom,
    ( ~ esk1682_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1487_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_3914,axiom,
    ( ~ esk5769_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | esk5574_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_3915,axiom,
    ( ~ esk5663_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5468_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_3916,axiom,
    ( esk4972_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4842_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_3917,axiom,
    ( p(X9)
    | esk1829_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1634_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_3918,axiom,
    ( ~ p(X9)
    | esk1570_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1765_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3919,axiom,
    ( ~ p(X18)
    | ~ esk3527_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3332_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3920,axiom,
    ( esk5171_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4976_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_3921,axiom,
    ( esk488_2(X1,X2)
    | ~ esk293_1(X1)
    | p(X2) ) ).

cnf(i_0_3922,axiom,
    ( ~ p(X3)
    | ~ esk575_2(X1,X2)
    | esk705_3(X1,X2,X3) ) ).

cnf(i_0_3923,axiom,
    ( p(X6)
    | ~ esk1144_5(X1,X2,X3,X4,X5)
    | esk1209_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3924,axiom,
    ( esk1603_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | ~ esk1798_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3925,axiom,
    ( esk1810_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2005_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_3926,axiom,
    ( ~ p(X4)
    | ~ esk607_3(X1,X2,X3)
    | esk802_4(X1,X2,X3,X4) ) ).

cnf(i_0_3927,axiom,
    ( ~ esk892_4(X1,X2,X3,X4)
    | esk762_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3928,axiom,
    ( ~ esk584_2(X1,X2)
    | esk649_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_3929,axiom,
    ( ~ esk4187_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4382_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3930,axiom,
    ( esk1100_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1295_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_3931,axiom,
    ( p(X2)
    | ~ esk396_2(X1,X2)
    | esk331_1(X1) ) ).

cnf(i_0_3932,axiom,
    ( p(X2)
    | esk276_1(X1)
    | ~ esk471_2(X1,X2) ) ).

cnf(i_0_3933,axiom,
    ( ~ esk389_1(X1)
    | p(X2)
    | esk454_2(X1,X2) ) ).

cnf(i_0_3934,axiom,
    ( ~ p(X5)
    | esk1000_5(X1,X2,X3,X4,X5)
    | ~ esk805_4(X1,X2,X3,X4) ) ).

cnf(i_0_3935,axiom,
    ( ~ p(X22)
    | esk4360_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4230_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3936,axiom,
    ( ~ p(X20)
    | esk3967_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3837_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3937,axiom,
    ( esk3875_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4005_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_3938,axiom,
    ( ~ esk3008_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3203_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_3939,axiom,
    ( ~ esk282_1(X1)
    | esk477_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_3940,axiom,
    ( ~ p(X17)
    | ~ esk3383_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3253_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_3941,axiom,
    ( ~ p(X13)
    | esk2491_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2621_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3942,axiom,
    ( esk3237_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3107_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3943,axiom,
    ( ~ esk1435_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1305_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_3944,axiom,
    ( ~ esk6193_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6258_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3945,axiom,
    ( ~ esk1377_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1182_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7) ) ).

cnf(i_0_3946,axiom,
    ( ~ esk829_4(X1,X2,X3,X4)
    | esk764_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_3947,axiom,
    ( ~ esk3149_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk2954_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3948,axiom,
    ( ~ p(X19)
    | esk3751_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3556_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3949,axiom,
    ( ~ p(X14)
    | esk2691_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2821_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3950,axiom,
    ( esk4950_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4820_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_3951,axiom,
    ( p(X1)
    | esk150_0
    | ~ esk215_1(X1) ) ).

cnf(i_0_3952,axiom,
    ( ~ p(X27)
    | ~ esk5228_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5358_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_3953,axiom,
    ( esk2101_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2166_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_3954,axiom,
    ( esk3767_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3702_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3955,axiom,
    ( p(X30)
    | ~ esk5832_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5897_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_3956,axiom,
    ( p(X27)
    | esk5333_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5138_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3957,axiom,
    ( p(X14)
    | esk2658_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2853_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3958,axiom,
    ( ~ esk3548_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | esk3483_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_3959,axiom,
    ( p(X27)
    | esk5269_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5204_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3960,axiom,
    ( ~ esk5168_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | esk4973_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_3961,axiom,
    ( esk744_3(X1,X2,X3)
    | ~ esk809_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_3962,axiom,
    ( esk3387_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3192_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_3963,axiom,
    ( esk1975_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1910_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_3964,axiom,
    ( ~ p(X10)
    | esk1966_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1771_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3965,axiom,
    ( esk3536_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3731_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_3966,axiom,
    ( esk4589_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4394_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_3967,axiom,
    ( ~ p(X19)
    | esk3709_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3514_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_3968,axiom,
    ( p(X1)
    | ~ esk262_1(X1)
    | esk67_0 ) ).

cnf(i_0_3969,axiom,
    ( ~ esk4168_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | esk4038_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3970,axiom,
    ( esk4341_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4536_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3971,axiom,
    ( esk2454_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2259_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_3972,axiom,
    ( p(X26)
    | esk5019_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5084_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3973,axiom,
    ( esk2783_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2718_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_3974,axiom,
    ( ~ p(X12)
    | esk2293_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2423_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3975,axiom,
    ( ~ esk2346_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2541_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_3976,axiom,
    ( ~ esk4532_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4727_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_3977,axiom,
    ( esk4473_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4603_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_3978,axiom,
    ( p(X1)
    | esk93_0
    | ~ esk288_1(X1) ) ).

cnf(i_0_3979,axiom,
    ( ~ esk298_1(X1)
    | p(X1)
    | esk103_0 ) ).

cnf(i_0_3980,axiom,
    ( esk6166_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6361_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3981,axiom,
    ( ~ p(X21)
    | ~ esk3916_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4111_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3982,axiom,
    ( ~ esk1998_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1803_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_3983,axiom,
    ( esk4116_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4311_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_3984,axiom,
    ( ~ esk4367_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | esk4172_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_3985,axiom,
    ( ~ esk622_3(X1,X2,X3)
    | ~ p(X3)
    | esk427_2(X1,X2) ) ).

cnf(i_0_3986,axiom,
    ( p(X15)
    | ~ esk3034_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2839_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_3987,axiom,
    ( ~ esk6245_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6278_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6343_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_3988,axiom,
    ( p(X15)
    | esk2860_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3055_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_3989,axiom,
    ( ~ p(X9)
    | esk1741_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1871_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_3990,axiom,
    ( ~ esk2032_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1902_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_3991,axiom,
    ( esk1946_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk2076_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_3992,axiom,
    ( ~ p(X13)
    | esk2642_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2512_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_3993,axiom,
    ( p(X21)
    | esk4178_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3983_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3994,axiom,
    ( ~ esk4459_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | esk4524_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3995,axiom,
    ( p(X21)
    | esk4174_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3979_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_3996,axiom,
    ( esk863_4(X1,X2,X3,X4)
    | ~ esk733_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_3997,axiom,
    ( ~ p(X23)
    | ~ esk4457_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4587_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_3998,axiom,
    ( p(X26)
    | ~ esk5008_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5073_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_3999,axiom,
    ( p(X26)
    | ~ esk5113_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5048_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4000,axiom,
    ( ~ p(X32)
    | esk6336_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6206_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4001,axiom,
    ( esk5497_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | ~ esk5432_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4002,axiom,
    ( ~ esk5162_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5357_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4003,axiom,
    ( ~ p(X24)
    | ~ esk4746_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4616_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4004,axiom,
    ( ~ esk4296_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | esk4491_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4005,axiom,
    ( ~ p(X7)
    | ~ esk1313_6(X1,X2,X3,X4,X5,X6)
    | esk1443_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4006,axiom,
    ( ~ esk1181_6(X1,X2,X3,X4,X5,X6)
    | p(X6)
    | esk1116_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4007,axiom,
    ( esk5706_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | ~ esk5511_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4008,axiom,
    ( ~ esk3649_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3714_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4009,axiom,
    ( ~ esk3570_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3375_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4010,axiom,
    ( p(X12)
    | esk2214_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2409_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4011,axiom,
    ( ~ p(X29)
    | esk5733_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5603_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4012,axiom,
    ( ~ p(X9)
    | esk1785_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1590_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4013,axiom,
    ( esk4296_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4231_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4014,axiom,
    ( ~ esk2355_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2160_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_4015,axiom,
    ( p(X2)
    | ~ esk508_2(X1,X2)
    | esk313_1(X1) ) ).

cnf(i_0_4016,axiom,
    ( p(X29)
    | esk5556_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5751_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4017,axiom,
    ( ~ esk4734_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4929_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_4018,axiom,
    ( p(X4)
    | ~ esk700_3(X1,X2,X3)
    | esk895_4(X1,X2,X3,X4) ) ).

cnf(i_0_4019,axiom,
    ( ~ esk2514_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13)
    | esk2644_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4020,axiom,
    ( esk2430_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2235_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4021,axiom,
    ( ~ p(X15)
    | ~ esk3010_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2880_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4022,axiom,
    ( esk4870_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk5000_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_4023,axiom,
    ( esk4346_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4281_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4024,axiom,
    ( esk2073_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1943_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4025,axiom,
    ( ~ p(X29)
    | esk5689_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5494_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4026,axiom,
    ( ~ esk3289_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3419_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4027,axiom,
    ( ~ p(X32)
    | ~ esk6182_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6312_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4028,axiom,
    ( ~ p(X8)
    | esk1565_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1370_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4029,axiom,
    ( ~ esk3531_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3726_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_4030,axiom,
    ( ~ p(X28)
    | esk5467_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5272_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4031,axiom,
    ( esk5170_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5365_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4032,axiom,
    ( esk2991_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2796_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4033,axiom,
    ( ~ esk168_0
    | p(X1)
    | esk233_1(X1) ) ).

cnf(i_0_4034,axiom,
    ( ~ esk1104_5(X1,X2,X3,X4,X5)
    | esk1299_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_4035,axiom,
    ( ~ esk5679_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5484_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_4036,axiom,
    ( ~ esk671_3(X1,X2,X3)
    | esk541_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_4037,axiom,
    ( ~ esk692_3(X1,X2,X3)
    | esk887_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_4038,axiom,
    ( esk4225_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | ~ esk4095_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4039,axiom,
    ( ~ p(X25)
    | esk4814_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4944_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4040,axiom,
    ( p(X7)
    | esk1437_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1242_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4041,axiom,
    ( esk5520_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | ~ esk5455_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4042,axiom,
    ( esk2345_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2150_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4043,axiom,
    ( ~ esk2401_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2336_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4044,axiom,
    ( esk2408_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2278_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_4045,axiom,
    ( ~ p(X5)
    | ~ esk1071_5(X1,X2,X3,X4,X5)
    | esk941_4(X1,X2,X3,X4) ) ).

cnf(i_0_4046,axiom,
    ( p(X3)
    | esk483_2(X1,X2)
    | ~ esk678_3(X1,X2,X3) ) ).

cnf(i_0_4047,axiom,
    ( ~ esk803_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk608_3(X1,X2,X3) ) ).

cnf(i_0_4048,axiom,
    ( ~ esk5301_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5236_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4049,axiom,
    ( p(X18)
    | esk3619_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3424_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4050,axiom,
    ( ~ p(X4)
    | ~ esk740_3(X1,X2,X3)
    | esk870_4(X1,X2,X3,X4) ) ).

cnf(i_0_4051,axiom,
    ( ~ esk850_4(X1,X2,X3,X4)
    | esk655_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_4052,axiom,
    ( esk4572_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4377_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4053,axiom,
    ( p(X24)
    | esk4676_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4741_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4054,axiom,
    ( esk1404_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1339_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4055,axiom,
    ( ~ p(X3)
    | ~ esk398_2(X1,X2)
    | esk593_3(X1,X2,X3) ) ).

cnf(i_0_4056,axiom,
    ( esk1236_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1431_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_4057,axiom,
    ( p(X6)
    | esk1069_5(X1,X2,X3,X4,X5)
    | ~ esk1264_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4058,axiom,
    ( ~ p(X5)
    | esk928_4(X1,X2,X3,X4)
    | ~ esk1058_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4059,axiom,
    ( ~ p(X27)
    | esk5249_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5379_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4060,axiom,
    ( esk2024_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1894_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_4061,axiom,
    ( p(X24)
    | esk4704_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4639_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4062,axiom,
    ( ~ p(X26)
    | ~ esk4885_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5080_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4063,axiom,
    ( ~ esk54_0
    | esk249_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_4064,axiom,
    ( ~ esk4201_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk4006_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4065,axiom,
    ( ~ esk5045_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5175_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_4066,axiom,
    ( esk5671_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | ~ esk5606_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4067,axiom,
    ( esk5291_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5226_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_4068,axiom,
    ( p(X18)
    | esk3582_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3387_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4069,axiom,
    ( esk5159_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4964_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_4070,axiom,
    ( ~ p(X9)
    | esk1852_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1722_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4071,axiom,
    ( ~ esk2763_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | esk2698_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4072,axiom,
    ( esk5959_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5829_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4073,axiom,
    ( ~ p(X8)
    | esk1628_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1498_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4074,axiom,
    ( esk3054_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3249_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_4075,axiom,
    ( p(X29)
    | ~ esk5591_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5656_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4076,axiom,
    ( ~ esk3547_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3352_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4077,axiom,
    ( p(X2)
    | ~ esk460_2(X1,X2)
    | esk265_1(X1) ) ).

cnf(i_0_4078,axiom,
    ( ~ esk5811_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5876_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4079,axiom,
    ( ~ esk4495_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | esk4690_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4080,axiom,
    ( ~ esk2080_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2275_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4081,axiom,
    ( ~ esk475_2(X1,X2)
    | p(X2)
    | esk280_1(X1) ) ).

cnf(i_0_4082,axiom,
    ( ~ p(X29)
    | ~ esk5495_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5690_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4083,axiom,
    ( p(X17)
    | esk3274_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3339_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4084,axiom,
    ( esk784_4(X1,X2,X3,X4)
    | ~ esk719_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_4085,axiom,
    ( esk6178_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6308_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_4086,axiom,
    ( p(X27)
    | esk5203_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5268_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4087,axiom,
    ( esk1475_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1280_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4088,axiom,
    ( ~ esk300_1(X1)
    | esk495_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_4089,axiom,
    ( p(X11)
    | ~ esk2275_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2080_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4090,axiom,
    ( ~ esk3323_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3258_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_4091,axiom,
    ( esk2510_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2575_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4092,axiom,
    ( p(X7)
    | ~ esk1437_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1242_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4093,axiom,
    ( ~ p(X2)
    | ~ esk357_1(X1)
    | esk487_2(X1,X2) ) ).

cnf(i_0_4094,axiom,
    ( esk4219_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4024_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_4095,axiom,
    ( ~ p(X6)
    | ~ esk1143_5(X1,X2,X3,X4,X5)
    | esk1273_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4096,axiom,
    ( ~ p(X25)
    | ~ esk4687_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4882_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4097,axiom,
    ( esk4874_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4939_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4098,axiom,
    ( esk3233_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3103_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4099,axiom,
    ( esk4612_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4417_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4100,axiom,
    ( esk655_3(X1,X2,X3)
    | p(X3)
    | ~ esk460_2(X1,X2) ) ).

cnf(i_0_4101,axiom,
    ( ~ p(X8)
    | ~ esk1647_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1517_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4102,axiom,
    ( ~ esk5854_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | esk6049_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4103,axiom,
    ( ~ esk6140_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | esk6010_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4104,axiom,
    ( ~ p(X10)
    | ~ esk1756_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1951_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4105,axiom,
    ( p(X21)
    | ~ esk4017_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4212_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4106,axiom,
    ( p(X21)
    | esk4215_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4020_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4107,axiom,
    ( esk5851_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6046_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4108,axiom,
    ( esk2033_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1903_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4109,axiom,
    ( p(X17)
    | ~ esk3223_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3418_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4110,axiom,
    ( ~ esk4149_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4344_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_4111,axiom,
    ( ~ esk3348_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | esk3153_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4112,axiom,
    ( esk3011_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2816_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4113,axiom,
    ( esk4164_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3969_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_4114,axiom,
    ( p(X15)
    | ~ esk3029_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2834_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4115,axiom,
    ( esk781_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk976_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4116,axiom,
    ( ~ esk2919_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2984_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_4117,axiom,
    ( esk1676_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | ~ esk1871_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4118,axiom,
    ( esk1384_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1319_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4119,axiom,
    ( esk2417_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2612_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_4120,axiom,
    ( esk1329_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1459_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4121,axiom,
    ( ~ esk5265_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5395_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_4122,axiom,
    ( esk1791_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9)
    | ~ esk1726_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4123,axiom,
    ( ~ esk5621_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5751_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_4124,axiom,
    ( p(X7)
    | esk1468_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1273_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4125,axiom,
    ( esk3414_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3284_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_4126,axiom,
    ( ~ p(X26)
    | ~ esk5153_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5023_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4127,axiom,
    ( ~ esk4882_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5077_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_4128,axiom,
    ( ~ esk6354_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6321_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6322_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4129,axiom,
    ( esk1015_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk820_4(X1,X2,X3,X4) ) ).

cnf(i_0_4130,axiom,
    ( esk4990_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | ~ esk4860_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4131,axiom,
    ( ~ esk6296_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6231_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_4132,axiom,
    ( ~ esk3846_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3911_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_4133,axiom,
    ( ~ p(X7)
    | esk1494_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1364_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4134,axiom,
    ( ~ esk3933_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4128_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_4135,axiom,
    ( esk4350_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | ~ esk4545_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4136,axiom,
    ( ~ esk3089_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3219_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_4137,axiom,
    ( ~ p(X21)
    | esk3912_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4107_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4138,axiom,
    ( ~ esk544_2(X1,X2)
    | esk674_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_4139,axiom,
    ( esk2931_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3126_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4140,axiom,
    ( p(X6)
    | ~ esk1213_6(X1,X2,X3,X4,X5,X6)
    | esk1148_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4141,axiom,
    ( ~ esk4528_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4723_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_4142,axiom,
    ( p(X29)
    | ~ esk5680_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5615_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4143,axiom,
    ( esk1770_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1965_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_4144,axiom,
    ( esk3874_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk3939_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4145,axiom,
    ( ~ esk4338_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4533_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_4146,axiom,
    ( p(X30)
    | ~ esk5864_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5799_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4147,axiom,
    ( ~ esk3599_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19)
    | esk3794_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4148,axiom,
    ( ~ esk4189_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4384_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4149,axiom,
    ( ~ esk249_1(X1)
    | ~ p(X2)
    | esk444_2(X1,X2) ) ).

cnf(i_0_4150,axiom,
    ( esk6021_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6086_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4151,axiom,
    ( esk5381_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5186_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4152,axiom,
    ( esk6097_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | ~ esk6032_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4153,axiom,
    ( ~ esk6213_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6278_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4154,axiom,
    ( p(X9)
    | ~ esk1796_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1731_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4155,axiom,
    ( esk2660_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2465_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4156,axiom,
    ( esk4054_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4184_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_4157,axiom,
    ( ~ esk4791_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4986_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_4158,axiom,
    ( ~ esk4311_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4246_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_4159,axiom,
    ( ~ esk1579_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1514_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_4160,axiom,
    ( p(X11)
    | esk2222_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2027_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4161,axiom,
    ( esk4504_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23)
    | ~ esk4309_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4162,axiom,
    ( p(X24)
    | ~ esk4668_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4733_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4163,axiom,
    ( esk5156_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5351_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_4164,axiom,
    ( esk4788_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4983_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4165,axiom,
    ( esk6171_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | ~ esk5976_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4166,axiom,
    ( esk4145_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4080_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_4167,axiom,
    ( p(X15)
    | esk2968_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2903_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4168,axiom,
    ( ~ p(X3)
    | ~ esk564_2(X1,X2)
    | esk694_3(X1,X2,X3) ) ).

cnf(i_0_4169,axiom,
    ( p(X31)
    | ~ esk6145_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5950_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4170,axiom,
    ( ~ esk3773_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3968_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4171,axiom,
    ( ~ esk5684_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29)
    | esk5619_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4172,axiom,
    ( ~ esk5198_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5393_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27) ) ).

cnf(i_0_4173,axiom,
    ( ~ esk1770_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1575_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4174,axiom,
    ( ~ esk827_4(X1,X2,X3,X4)
    | esk1022_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_4175,axiom,
    ( esk5837_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5902_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_4176,axiom,
    ( ~ esk3819_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | esk3624_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4177,axiom,
    ( esk2844_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2649_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_4178,axiom,
    ( ~ p(X2)
    | ~ esk453_2(X1,X2)
    | esk258_1(X1) ) ).

cnf(i_0_4179,axiom,
    ( esk3833_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk4028_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4180,axiom,
    ( ~ esk1419_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk1354_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4181,axiom,
    ( ~ esk4405_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | esk4600_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4182,axiom,
    ( ~ esk4178_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3983_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_4183,axiom,
    ( ~ esk6270_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6303_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6368_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4184,axiom,
    ( esk2616_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | ~ esk2486_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4185,axiom,
    ( p(X24)
    | ~ esk4681_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4616_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4186,axiom,
    ( esk349_1(X1)
    | ~ p(X2)
    | ~ esk479_2(X1,X2) ) ).

cnf(i_0_4187,axiom,
    ( ~ p(X5)
    | ~ esk1059_5(X1,X2,X3,X4,X5)
    | esk929_4(X1,X2,X3,X4) ) ).

cnf(i_0_4188,axiom,
    ( esk5362_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28)
    | ~ esk5557_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4189,axiom,
    ( ~ p(X5)
    | esk796_4(X1,X2,X3,X4)
    | ~ esk991_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4190,axiom,
    ( ~ esk4007_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | esk4202_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4191,axiom,
    ( p(X22)
    | esk4320_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4255_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4192,axiom,
    ( ~ esk5703_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | esk5508_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4193,axiom,
    ( esk1288_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1158_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_4194,axiom,
    ( esk1880_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | ~ esk2075_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4195,axiom,
    ( ~ esk5640_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5705_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_4196,axiom,
    ( ~ p(X21)
    | esk3945_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4140_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4197,axiom,
    ( esk3464_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | ~ esk3529_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4198,axiom,
    ( ~ esk2634_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | esk2829_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4199,axiom,
    ( p(X12)
    | esk2227_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2422_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4200,axiom,
    ( p(X30)
    | esk5832_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5897_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4201,axiom,
    ( p(X25)
    | ~ esk4873_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4938_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4202,axiom,
    ( esk3851_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | ~ esk3916_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4203,axiom,
    ( ~ esk3000_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2805_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_4204,axiom,
    ( esk2073_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2268_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11) ) ).

cnf(i_0_4205,axiom,
    ( ~ esk5116_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5311_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_4206,axiom,
    ( p(X2)
    | ~ esk285_1(X1)
    | esk480_2(X1,X2) ) ).

cnf(i_0_4207,axiom,
    ( esk3396_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3266_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_4208,axiom,
    ( esk4725_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | ~ esk4530_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4209,axiom,
    ( esk1464_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1269_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4210,axiom,
    ( ~ p(X13)
    | ~ esk2660_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2530_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4211,axiom,
    ( ~ p(X23)
    | ~ esk4421_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4551_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4212,axiom,
    ( ~ p(X30)
    | esk5915_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5720_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4213,axiom,
    ( esk576_2(X1,X2)
    | ~ esk641_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_4214,axiom,
    ( esk5507_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | ~ esk5312_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4215,axiom,
    ( esk6045_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6175_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4216,axiom,
    ( ~ esk1161_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk1291_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4217,axiom,
    ( esk2558_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2493_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4218,axiom,
    ( ~ p(X24)
    | ~ esk4758_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4628_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4219,axiom,
    ( ~ esk3525_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3460_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_4220,axiom,
    ( p(X29)
    | esk5542_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5737_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4221,axiom,
    ( ~ esk463_2(X1,X2)
    | ~ p(X2)
    | esk333_1(X1) ) ).

cnf(i_0_4222,axiom,
    ( ~ esk882_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk752_3(X1,X2,X3) ) ).

cnf(i_0_4223,axiom,
    ( ~ esk5098_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5293_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_4224,axiom,
    ( ~ p(X7)
    | esk1398_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1203_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4225,axiom,
    ( p(X3)
    | esk683_3(X1,X2,X3)
    | ~ esk488_2(X1,X2) ) ).

cnf(i_0_4226,axiom,
    ( ~ p(X31)
    | esk6084_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5889_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4227,axiom,
    ( ~ esk5963_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5833_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_4228,axiom,
    ( ~ esk4127_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4322_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_4229,axiom,
    ( p(X23)
    | ~ esk4375_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4570_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4230,axiom,
    ( p(X2)
    | esk292_1(X1)
    | ~ esk487_2(X1,X2) ) ).

cnf(i_0_4231,axiom,
    ( p(X16)
    | ~ esk3074_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3139_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4232,axiom,
    ( esk5698_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5893_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_4233,axiom,
    ( ~ p(X15)
    | ~ esk2936_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2741_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4234,axiom,
    ( ~ p(X13)
    | ~ esk2355_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2550_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4235,axiom,
    ( esk4366_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4171_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_4236,axiom,
    ( ~ esk2353_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2288_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4237,axiom,
    ( esk1274_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1144_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_4238,axiom,
    ( ~ esk3495_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3560_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18) ) ).

cnf(i_0_4239,axiom,
    ( esk4273_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4338_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_4240,axiom,
    ( p(X29)
    | esk5644_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5709_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4241,axiom,
    ( ~ esk6195_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6260_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4242,axiom,
    ( ~ p(X4)
    | ~ esk781_4(X1,X2,X3,X4)
    | esk586_3(X1,X2,X3) ) ).

cnf(i_0_4243,axiom,
    ( ~ esk2929_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2734_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_4244,axiom,
    ( ~ p(X21)
    | esk4160_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3965_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4245,axiom,
    ( ~ esk2147_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1952_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_4246,axiom,
    ( p(X1)
    | ~ esk259_1(X1)
    | esk194_0 ) ).

cnf(i_0_4247,axiom,
    ( esk1381_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1576_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4248,axiom,
    ( ~ esk1169_5(X1,X2,X3,X4,X5)
    | esk1299_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_4249,axiom,
    ( esk3517_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3452_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_4250,axiom,
    ( ~ p(X14)
    | ~ esk2805_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2675_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4251,axiom,
    ( p(X29)
    | esk5586_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5781_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4252,axiom,
    ( esk1998_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2193_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_4253,axiom,
    ( esk2603_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2408_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4254,axiom,
    ( ~ esk5452_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5517_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_4255,axiom,
    ( ~ esk3903_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4098_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21) ) ).

cnf(i_0_4256,axiom,
    ( ~ p(X30)
    | ~ esk5911_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5716_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4257,axiom,
    ( p(X9)
    | esk1651_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1846_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4258,axiom,
    ( ~ esk4206_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4011_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21) ) ).

cnf(i_0_4259,axiom,
    ( p(X4)
    | esk827_4(X1,X2,X3,X4)
    | ~ esk762_3(X1,X2,X3) ) ).

cnf(i_0_4260,axiom,
    ( esk3769_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | ~ esk3574_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4261,axiom,
    ( esk3564_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | ~ esk3499_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4262,axiom,
    ( ~ esk200_1(X1)
    | esk135_0
    | p(X1) ) ).

cnf(i_0_4263,axiom,
    ( ~ esk2200_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2135_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4264,axiom,
    ( esk3618_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3488_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_4265,axiom,
    ( esk1627_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | ~ esk1497_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4266,axiom,
    ( ~ esk666_3(X1,X2,X3)
    | ~ p(X3)
    | esk536_2(X1,X2) ) ).

cnf(i_0_4267,axiom,
    ( p(X31)
    | esk6002_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6067_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4268,axiom,
    ( ~ p(X9)
    | esk1884_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1754_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4269,axiom,
    ( esk1028_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk833_4(X1,X2,X3,X4) ) ).

cnf(i_0_4270,axiom,
    ( p(X3)
    | esk611_3(X1,X2,X3)
    | ~ esk546_2(X1,X2) ) ).

cnf(i_0_4271,axiom,
    ( ~ esk5337_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5207_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_4272,axiom,
    ( ~ esk6064_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X31)
    | esk5999_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4273,axiom,
    ( ~ p(X24)
    | ~ esk4654_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4784_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4274,axiom,
    ( ~ p(X21)
    | esk4069_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4199_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4275,axiom,
    ( ~ p(X32)
    | ~ esk6185_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6315_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4276,axiom,
    ( p(X28)
    | esk5547_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5352_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4277,axiom,
    ( p(X16)
    | esk3084_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3149_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4278,axiom,
    ( esk5187_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4992_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_4279,axiom,
    ( ~ esk2649_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | esk2519_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4280,axiom,
    ( p(X8)
    | ~ esk1463_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1658_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4281,axiom,
    ( p(X6)
    | ~ esk1073_5(X1,X2,X3,X4,X5)
    | esk1268_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4282,axiom,
    ( p(X20)
    | esk3885_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3950_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4283,axiom,
    ( ~ esk4446_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | esk4576_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4284,axiom,
    ( ~ esk1078_5(X1,X2,X3,X4,X5)
    | esk883_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_4285,axiom,
    ( p(X3)
    | ~ esk459_2(X1,X2)
    | esk654_3(X1,X2,X3) ) ).

cnf(i_0_4286,axiom,
    ( ~ esk3966_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3771_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20) ) ).

cnf(i_0_4287,axiom,
    ( esk3441_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3246_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4288,axiom,
    ( p(X11)
    | esk2193_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2128_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4289,axiom,
    ( esk460_2(X1,X2)
    | ~ esk655_3(X1,X2,X3)
    | p(X3) ) ).

cnf(i_0_4290,axiom,
    ( ~ esk4516_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4711_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_4291,axiom,
    ( ~ esk3337_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3142_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_4292,axiom,
    ( ~ p(X25)
    | esk4986_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4856_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4293,axiom,
    ( ~ esk5853_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5658_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_4294,axiom,
    ( p(X4)
    | esk879_4(X1,X2,X3,X4)
    | ~ esk684_3(X1,X2,X3) ) ).

cnf(i_0_4295,axiom,
    ( esk2999_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | ~ esk3194_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4296,axiom,
    ( ~ esk1224_6(X1,X2,X3,X4,X5,X6)
    | esk1419_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_4297,axiom,
    ( ~ esk6346_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | esk6216_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4298,axiom,
    ( esk2246_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2051_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4299,axiom,
    ( ~ p(X13)
    | ~ esk2652_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2522_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4300,axiom,
    ( esk4165_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4035_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_4301,axiom,
    ( ~ esk5317_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5122_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_4302,axiom,
    ( ~ esk4707_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4512_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_4303,axiom,
    ( p(X8)
    | esk1664_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1469_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4304,axiom,
    ( ~ esk4127_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | esk3932_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4305,axiom,
    ( ~ esk1573_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1378_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_4306,axiom,
    ( esk3143_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | ~ esk3338_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4307,axiom,
    ( esk351_1(X1)
    | p(X2)
    | ~ esk416_2(X1,X2) ) ).

cnf(i_0_4308,axiom,
    ( esk3725_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3660_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_4309,axiom,
    ( esk1953_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1758_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4310,axiom,
    ( esk4981_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5176_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_4311,axiom,
    ( p(X4)
    | ~ esk735_3(X1,X2,X3)
    | esk800_4(X1,X2,X3,X4) ) ).

cnf(i_0_4312,axiom,
    ( esk5666_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5861_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4313,axiom,
    ( esk4304_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | ~ esk4109_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4314,axiom,
    ( ~ esk854_4(X1,X2,X3,X4)
    | p(X4)
    | esk659_3(X1,X2,X3) ) ).

cnf(i_0_4315,axiom,
    ( esk2421_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2291_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_4316,axiom,
    ( p(X11)
    | ~ esk2265_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2070_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4317,axiom,
    ( esk5994_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6124_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_4318,axiom,
    ( esk403_2(X1,X2)
    | ~ esk338_1(X1)
    | p(X2) ) ).

cnf(i_0_4319,axiom,
    ( p(X3)
    | ~ esk689_3(X1,X2,X3)
    | esk494_2(X1,X2) ) ).

cnf(i_0_4320,axiom,
    ( ~ p(X6)
    | esk1221_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1026_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4321,axiom,
    ( ~ p(X19)
    | esk3825_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3695_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4322,axiom,
    ( esk1617_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1422_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_4323,axiom,
    ( p(X3)
    | esk546_2(X1,X2)
    | ~ esk611_3(X1,X2,X3) ) ).

cnf(i_0_4324,axiom,
    ( esk1370_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1565_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4325,axiom,
    ( esk5905_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | ~ esk5710_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4326,axiom,
    ( ~ esk4681_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24)
    | esk4486_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4327,axiom,
    ( ~ p(X29)
    | ~ esk5720_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5525_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4328,axiom,
    ( esk767_3(X1,X2,X3)
    | ~ esk832_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_4329,axiom,
    ( ~ esk1132_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | esk1262_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4330,axiom,
    ( ~ esk6087_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6282_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_4331,axiom,
    ( p(X30)
    | ~ esk5965_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5770_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4332,axiom,
    ( ~ esk2281_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2346_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4333,axiom,
    ( esk517_2(X1,X2)
    | ~ p(X2)
    | ~ esk387_1(X1) ) ).

cnf(i_0_4334,axiom,
    ( esk4020_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | ~ esk4215_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4335,axiom,
    ( esk3437_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3307_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17) ) ).

cnf(i_0_4336,axiom,
    ( p(X24)
    | ~ esk4729_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4664_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4337,axiom,
    ( ~ esk1127_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk1192_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4338,axiom,
    ( p(X23)
    | esk4504_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4439_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4339,axiom,
    ( esk6271_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6303_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6270_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4340,axiom,
    ( p(X13)
    | ~ esk2646_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2451_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4341,axiom,
    ( esk1849_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk2044_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_4342,axiom,
    ( ~ p(X28)
    | ~ esk5427_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5557_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4343,axiom,
    ( esk5198_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5003_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_4344,axiom,
    ( esk6112_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31)
    | ~ esk5982_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4345,axiom,
    ( esk3950_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3885_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4346,axiom,
    ( esk728_3(X1,X2,X3)
    | ~ p(X4)
    | ~ esk858_4(X1,X2,X3,X4) ) ).

cnf(i_0_4347,axiom,
    ( ~ p(X10)
    | ~ esk1797_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1992_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4348,axiom,
    ( ~ p(X12)
    | esk2428_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2298_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4349,axiom,
    ( ~ esk4442_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | esk4572_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4350,axiom,
    ( p(X32)
    | esk6150_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6345_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4351,axiom,
    ( p(X4)
    | esk731_3(X1,X2,X3)
    | ~ esk796_4(X1,X2,X3,X4) ) ).

cnf(i_0_4352,axiom,
    ( p(X10)
    | ~ esk1984_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1919_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4353,axiom,
    ( esk4707_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4642_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_4354,axiom,
    ( ~ esk5256_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5321_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4355,axiom,
    ( ~ esk1122_5(X1,X2,X3,X4,X5)
    | esk1252_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_4356,axiom,
    ( esk1654_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1459_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4357,axiom,
    ( p(X18)
    | ~ esk3615_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3420_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4358,axiom,
    ( ~ p(X14)
    | esk2820_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2690_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4359,axiom,
    ( ~ p(X7)
    | esk1211_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1406_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4360,axiom,
    ( ~ esk5251_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5381_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_4361,axiom,
    ( p(X6)
    | esk1113_5(X1,X2,X3,X4,X5)
    | ~ esk1178_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4362,axiom,
    ( ~ p(X22)
    | ~ esk4388_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4258_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4363,axiom,
    ( ~ esk3579_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18)
    | esk3449_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4364,axiom,
    ( ~ esk631_3(X1,X2,X3)
    | esk566_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_4365,axiom,
    ( esk2307_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2372_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_4366,axiom,
    ( ~ esk543_2(X1,X2)
    | ~ p(X3)
    | esk673_3(X1,X2,X3) ) ).

cnf(i_0_4367,axiom,
    ( p(X20)
    | esk3878_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3943_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4368,axiom,
    ( esk491_2(X1,X2)
    | p(X3)
    | ~ esk686_3(X1,X2,X3) ) ).

cnf(i_0_4369,axiom,
    ( ~ esk229_1(X1)
    | esk164_0
    | p(X1) ) ).

cnf(i_0_4370,axiom,
    ( ~ esk4747_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | esk4552_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4371,axiom,
    ( ~ esk1565_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1500_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_4372,axiom,
    ( ~ esk1698_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | esk1763_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4373,axiom,
    ( esk6140_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6010_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_4374,axiom,
    ( ~ esk2190_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2125_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4375,axiom,
    ( ~ esk5556_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | esk5361_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4376,axiom,
    ( ~ p(X7)
    | ~ esk1186_6(X1,X2,X3,X4,X5,X6)
    | esk1381_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4377,axiom,
    ( ~ esk5961_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5766_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30) ) ).

cnf(i_0_4378,axiom,
    ( ~ esk3002_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | esk2807_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4379,axiom,
    ( p(X3)
    | ~ esk567_2(X1,X2)
    | esk632_3(X1,X2,X3) ) ).

cnf(i_0_4380,axiom,
    ( ~ p(X28)
    | esk5440_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5570_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4381,axiom,
    ( p(X27)
    | ~ esk5339_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5144_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4382,axiom,
    ( ~ esk1897_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2027_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10) ) ).

cnf(i_0_4383,axiom,
    ( ~ esk5555_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5360_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_4384,axiom,
    ( esk3923_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3728_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_4385,axiom,
    ( esk2767_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2962_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_4386,axiom,
    ( esk1175_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | ~ esk1370_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4387,axiom,
    ( esk6004_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6069_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4388,axiom,
    ( p(X31)
    | esk5955_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6150_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4389,axiom,
    ( ~ p(X14)
    | esk2562_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2757_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4390,axiom,
    ( ~ esk4142_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4337_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4391,axiom,
    ( ~ esk5037_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | esk5102_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4392,axiom,
    ( ~ esk6160_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6030_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_4393,axiom,
    ( esk2306_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2371_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_4394,axiom,
    ( p(X22)
    | esk4264_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4329_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4395,axiom,
    ( esk4769_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4639_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_4396,axiom,
    ( ~ esk3348_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3543_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4397,axiom,
    ( esk1508_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1638_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4398,axiom,
    ( p(X8)
    | esk1601_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1536_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4399,axiom,
    ( ~ esk3084_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | esk3149_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4400,axiom,
    ( esk141_0
    | p(X1)
    | ~ esk206_1(X1) ) ).

cnf(i_0_4401,axiom,
    ( esk473_2(X1,X2)
    | ~ esk278_1(X1)
    | p(X2) ) ).

cnf(i_0_4402,axiom,
    ( p(X17)
    | esk3230_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3425_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4403,axiom,
    ( esk5167_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk5037_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4404,axiom,
    ( p(X7)
    | esk1258_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1453_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4405,axiom,
    ( esk5316_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5121_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_4406,axiom,
    ( esk2589_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2784_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4407,axiom,
    ( ~ esk2415_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2220_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4408,axiom,
    ( ~ p(X22)
    | esk4316_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4121_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4409,axiom,
    ( ~ esk5040_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5170_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_4410,axiom,
    ( ~ esk3638_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3508_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_4411,axiom,
    ( esk5527_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28)
    | ~ esk5332_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4412,axiom,
    ( ~ p(X13)
    | esk2373_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2568_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4413,axiom,
    ( ~ esk3020_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2890_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_4414,axiom,
    ( ~ p(X5)
    | esk1077_5(X1,X2,X3,X4,X5)
    | ~ esk947_4(X1,X2,X3,X4) ) ).

cnf(i_0_4415,axiom,
    ( esk2194_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11)
    | ~ esk1999_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4416,axiom,
    ( esk5282_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5087_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4417,axiom,
    ( ~ esk3338_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3533_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4418,axiom,
    ( esk6299_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6267_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4419,axiom,
    ( p(X21)
    | ~ esk4156_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4091_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4420,axiom,
    ( p(X13)
    | ~ esk2488_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2553_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4421,axiom,
    ( esk730_3(X1,X2,X3)
    | p(X4)
    | ~ esk795_4(X1,X2,X3,X4) ) ).

cnf(i_0_4422,axiom,
    ( ~ esk3806_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3676_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19) ) ).

cnf(i_0_4423,axiom,
    ( ~ esk6253_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6351_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6286_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4424,axiom,
    ( ~ esk6204_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6269_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_4425,axiom,
    ( esk5606_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5736_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_4426,axiom,
    ( ~ esk3129_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2934_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_4427,axiom,
    ( p(X25)
    | esk4789_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4984_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4428,axiom,
    ( esk5559_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5364_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X28) ) ).

cnf(i_0_4429,axiom,
    ( ~ esk2620_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | esk2490_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4430,axiom,
    ( p(X3)
    | ~ esk472_2(X1,X2)
    | esk667_3(X1,X2,X3) ) ).

cnf(i_0_4431,axiom,
    ( esk3158_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2963_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_4432,axiom,
    ( ~ esk1707_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1772_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9) ) ).

cnf(i_0_4433,axiom,
    ( p(X8)
    | esk1458_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1653_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4434,axiom,
    ( esk200_1(X1)
    | ~ esk135_0
    | p(X1) ) ).

cnf(i_0_4435,axiom,
    ( ~ esk4717_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4652_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_4436,axiom,
    ( esk812_4(X1,X2,X3,X4)
    | ~ esk617_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_4437,axiom,
    ( ~ esk4276_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22)
    | esk4341_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4438,axiom,
    ( esk3757_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3952_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_4439,axiom,
    ( esk5273_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5208_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4440,axiom,
    ( ~ esk5768_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5638_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_4441,axiom,
    ( esk3826_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | ~ esk3696_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4442,axiom,
    ( esk1052_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk922_4(X1,X2,X3,X4) ) ).

cnf(i_0_4443,axiom,
    ( esk4663_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4793_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4444,axiom,
    ( esk2387_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2582_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_4445,axiom,
    ( ~ esk3055_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15)
    | esk2925_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4446,axiom,
    ( ~ esk1552_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk1617_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4447,axiom,
    ( esk4398_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4203_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_4448,axiom,
    ( esk5103_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26)
    | ~ esk5038_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4449,axiom,
    ( esk5325_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5520_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_4450,axiom,
    ( esk1380_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1315_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4451,axiom,
    ( esk4135_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4330_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_4452,axiom,
    ( esk578_2(X1,X2)
    | p(X3)
    | ~ esk643_3(X1,X2,X3) ) ).

cnf(i_0_4453,axiom,
    ( ~ esk3224_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17)
    | esk3419_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4454,axiom,
    ( esk1249_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | ~ esk1444_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4455,axiom,
    ( ~ esk1071_5(X1,X2,X3,X4,X5)
    | esk1266_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_4456,axiom,
    ( p(X9)
    | esk1739_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1804_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4457,axiom,
    ( esk2184_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2379_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_4458,axiom,
    ( p(X6)
    | esk1264_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1069_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4459,axiom,
    ( esk6158_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6353_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4460,axiom,
    ( ~ esk1922_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1987_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_4461,axiom,
    ( esk6020_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6085_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4462,axiom,
    ( p(X2)
    | esk289_1(X1)
    | ~ esk484_2(X1,X2) ) ).

cnf(i_0_4463,axiom,
    ( ~ esk1994_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1799_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_4464,axiom,
    ( esk3864_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3929_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_4465,axiom,
    ( ~ esk1985_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2180_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4466,axiom,
    ( ~ esk4481_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | esk4611_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4467,axiom,
    ( ~ p(X23)
    | esk4557_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4427_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4468,axiom,
    ( p(X15)
    | esk2797_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2992_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4469,axiom,
    ( ~ p(X16)
    | esk3224_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3094_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4470,axiom,
    ( esk2989_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2794_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_4471,axiom,
    ( ~ p(X25)
    | esk4925_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4730_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4472,axiom,
    ( p(X10)
    | ~ esk1973_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1908_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4473,axiom,
    ( p(X23)
    | esk4426_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4491_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4474,axiom,
    ( esk2997_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2867_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_4475,axiom,
    ( esk978_5(X1,X2,X3,X4,X5)
    | p(X5)
    | ~ esk913_4(X1,X2,X3,X4) ) ).

cnf(i_0_4476,axiom,
    ( ~ esk1230_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk1035_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4477,axiom,
    ( ~ esk4979_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5174_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_4478,axiom,
    ( esk4796_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | ~ esk4601_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4479,axiom,
    ( ~ p(X25)
    | ~ esk4991_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4861_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4480,axiom,
    ( ~ esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6253_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4481,axiom,
    ( esk3823_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3628_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4482,axiom,
    ( ~ esk2306_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12)
    | esk2371_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4483,axiom,
    ( esk5335_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | ~ esk5140_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4484,axiom,
    ( ~ p(X13)
    | esk2512_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2642_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4485,axiom,
    ( esk4799_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4604_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_4486,axiom,
    ( p(X13)
    | esk2587_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2522_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4487,axiom,
    ( ~ p(X21)
    | esk4074_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4204_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4488,axiom,
    ( ~ esk4788_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | esk4593_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4489,axiom,
    ( esk6111_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5981_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31) ) ).

cnf(i_0_4490,axiom,
    ( p(X14)
    | ~ esk2826_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2631_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4491,axiom,
    ( p(X30)
    | ~ esk5815_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5880_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4492,axiom,
    ( esk4430_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4495_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23) ) ).

cnf(i_0_4493,axiom,
    ( ~ p(X31)
    | esk5885_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6080_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4494,axiom,
    ( esk4958_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4763_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_4495,axiom,
    ( ~ esk1381_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | esk1316_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4496,axiom,
    ( ~ esk3171_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2976_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16) ) ).

cnf(i_0_4497,axiom,
    ( ~ esk78_0
    | esk273_1(X1)
    | p(X1) ) ).

cnf(i_0_4498,axiom,
    ( ~ esk4249_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4379_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_4499,axiom,
    ( esk4805_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4610_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_4500,axiom,
    ( esk5416_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5546_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4501,axiom,
    ( esk3519_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | ~ esk3454_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4502,axiom,
    ( p(X4)
    | ~ esk897_4(X1,X2,X3,X4)
    | esk702_3(X1,X2,X3) ) ).

cnf(i_0_4503,axiom,
    ( ~ p(X6)
    | ~ esk1154_5(X1,X2,X3,X4,X5)
    | esk1284_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4504,axiom,
    ~ esk50_0 ).

cnf(i_0_4505,axiom,
    ( esk1525_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1655_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4506,axiom,
    ( ~ p(X22)
    | ~ esk4139_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4334_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4507,axiom,
    ( esk4980_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4850_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_4508,axiom,
    ( esk712_3(X1,X2,X3)
    | p(X4)
    | ~ esk907_4(X1,X2,X3,X4) ) ).

cnf(i_0_4509,axiom,
    ( p(X21)
    | ~ esk4160_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4095_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4510,axiom,
    ( ~ esk1971_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1906_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4511,axiom,
    ( ~ esk1769_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1574_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4512,axiom,
    ( ~ esk436_2(X1,X2)
    | esk241_1(X1)
    | ~ p(X2) ) ).

cnf(i_0_4513,axiom,
    ( esk2000_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1805_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_4514,axiom,
    ( ~ esk5173_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5043_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_4515,axiom,
    ( esk4390_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4195_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X22) ) ).

cnf(i_0_4516,axiom,
    ( ~ esk5543_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | esk5413_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4517,axiom,
    ( esk3048_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2918_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15) ) ).

cnf(i_0_4518,axiom,
    ( ~ p(X1)
    | ~ esk265_1(X1)
    | esk135_0 ) ).

cnf(i_0_4519,axiom,
    ( esk3182_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | ~ esk3377_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4520,axiom,
    ( ~ esk633_3(X1,X2,X3)
    | esk828_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_4521,axiom,
    ( ~ p(X5)
    | esk943_4(X1,X2,X3,X4)
    | ~ esk1073_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4522,axiom,
    ( p(X2)
    | esk352_1(X1)
    | ~ esk417_2(X1,X2) ) ).

cnf(i_0_4523,axiom,
    ( ~ p(X28)
    | esk5326_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5521_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4524,axiom,
    ( ~ esk990_5(X1,X2,X3,X4,X5)
    | esk1185_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_4525,axiom,
    ( esk4643_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24)
    | ~ esk4773_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4526,axiom,
    ( esk2795_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2990_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_4527,axiom,
    ( esk5077_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5272_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4528,axiom,
    ( esk3687_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3817_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19) ) ).

cnf(i_0_4529,axiom,
    ( ~ p(X31)
    | esk6175_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6045_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4530,axiom,
    ( esk4384_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | ~ esk4254_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4531,axiom,
    ( ~ esk5256_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5386_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_4532,axiom,
    ( ~ esk4916_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | esk4721_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4533,axiom,
    ( ~ p(X12)
    | ~ esk2154_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2349_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4534,axiom,
    ( ~ esk5811_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | esk5941_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4535,axiom,
    ( esk1111_5(X1,X2,X3,X4,X5)
    | p(X6)
    | ~ esk1176_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4536,axiom,
    ( ~ p(X25)
    | esk4743_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4938_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4537,axiom,
    ( ~ esk1767_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1572_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4538,axiom,
    ( ~ p(X30)
    | ~ esk5944_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5814_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4539,axiom,
    ( ~ esk4826_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4956_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_4540,axiom,
    ( esk1833_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1638_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_4541,axiom,
    ( esk4153_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3958_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_4542,axiom,
    ( ~ esk2396_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2331_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4543,axiom,
    ( p(X31)
    | ~ esk6027_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6092_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4544,axiom,
    ( p(X16)
    | ~ esk3162_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3097_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4545,axiom,
    ( p(X21)
    | ~ esk4191_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk3996_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4546,axiom,
    ( p(X26)
    | esk5022_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5087_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4547,axiom,
    ( esk741_3(X1,X2,X3)
    | ~ esk871_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_4548,axiom,
    ( ~ esk3552_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3487_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_4549,axiom,
    ( esk1274_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1469_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_4550,axiom,
    ( esk5528_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | ~ esk5398_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4551,axiom,
    ( ~ esk5615_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5745_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_4552,axiom,
    ( p(X25)
    | ~ esk4995_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4800_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4553,axiom,
    ( ~ p(X28)
    | ~ esk5457_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5587_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4554,axiom,
    ( esk5090_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5285_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4555,axiom,
    ( p(X17)
    | ~ esk3281_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3346_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4556,axiom,
    ( p(X7)
    | esk1295_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1490_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4557,axiom,
    ( ~ esk616_3(X1,X2,X3)
    | esk551_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_4558,axiom,
    ( ~ esk3785_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3980_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4559,axiom,
    ( p(X2)
    | ~ esk486_2(X1,X2)
    | esk291_1(X1) ) ).

cnf(i_0_4560,axiom,
    ( ~ esk2462_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2332_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_4561,axiom,
    ( ~ esk2077_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1882_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4562,axiom,
    ( ~ p(X22)
    | esk4351_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4156_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4563,axiom,
    ( ~ esk5808_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | esk5873_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4564,axiom,
    ( p(X20)
    | ~ esk3835_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4030_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4565,axiom,
    ( ~ esk1545_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | esk1610_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4566,axiom,
    ( esk5326_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5131_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_4567,axiom,
    ( esk2837_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2642_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_4568,axiom,
    ( ~ esk2874_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk2939_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4569,axiom,
    ( esk375_1(X1)
    | ~ p(X2)
    | ~ esk505_2(X1,X2) ) ).

cnf(i_0_4570,axiom,
    ( ~ p(X24)
    | esk4670_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4800_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4571,axiom,
    ( esk4375_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4570_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4572,axiom,
    ( ~ esk4147_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk4082_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4573,axiom,
    ( esk4551_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4746_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24) ) ).

cnf(i_0_4574,axiom,
    ( esk5135_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5330_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4575,axiom,
    ( esk3204_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3399_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_4576,axiom,
    ( ~ p(X22)
    | esk4338_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4143_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4577,axiom,
    ( ~ p(X26)
    | esk5039_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5169_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4578,axiom,
    ( ~ p(X9)
    | ~ esk1846_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1716_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4579,axiom,
    ( ~ esk2570_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2765_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4580,axiom,
    ( ~ esk1037_5(X1,X2,X3,X4,X5)
    | esk842_4(X1,X2,X3,X4)
    | ~ p(X5) ) ).

cnf(i_0_4581,axiom,
    ( ~ esk2680_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2810_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4582,axiom,
    ( esk1192_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | ~ esk997_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4583,axiom,
    ( ~ p(X22)
    | esk4380_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4250_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4584,axiom,
    ( ~ p(X28)
    | esk5405_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5535_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4585,axiom,
    ( esk5755_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | ~ esk5625_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4586,axiom,
    ( p(X28)
    | ~ esk5536_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5341_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4587,axiom,
    ( ~ esk1849_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1654_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_4588,axiom,
    ( ~ esk3813_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk4008_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_4589,axiom,
    ( ~ esk2854_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15)
    | esk3049_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4590,axiom,
    ( esk5247_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | ~ esk5312_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4591,axiom,
    ( ~ esk1518_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | esk1648_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4592,axiom,
    ( ~ esk2402_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | esk2337_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4593,axiom,
    ( p(X17)
    | esk3364_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3299_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4594,axiom,
    ( p(X3)
    | esk571_2(X1,X2)
    | ~ esk636_3(X1,X2,X3) ) ).

cnf(i_0_4595,axiom,
    ( p(X15)
    | ~ esk2917_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2982_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4596,axiom,
    ( ~ esk166_0
    | p(X1)
    | esk231_1(X1) ) ).

cnf(i_0_4597,axiom,
    ( ~ esk2793_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | esk2988_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4598,axiom,
    ( ~ esk4827_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | esk4892_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4599,axiom,
    ( esk4296_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4101_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_4600,axiom,
    ( ~ esk747_3(X1,X2,X3)
    | esk877_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_4601,axiom,
    ( ~ esk6179_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6244_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4602,axiom,
    ( ~ esk1673_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1478_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_4603,axiom,
    ( esk3188_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3383_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_4604,axiom,
    ( ~ esk5177_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5372_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4605,axiom,
    ( esk5576_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5446_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28) ) ).

cnf(i_0_4606,axiom,
    ( ~ esk3142_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk2947_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4607,axiom,
    ( p(X26)
    | ~ esk5127_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5062_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4608,axiom,
    ( esk2614_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2484_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_4609,axiom,
    ( esk1941_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk2071_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4610,axiom,
    ( ~ p(X15)
    | esk2751_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2946_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4611,axiom,
    ( p(X7)
    | esk1449_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1254_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4612,axiom,
    ( esk3359_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3554_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_4613,axiom,
    ( ~ p(X8)
    | esk1513_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1643_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4614,axiom,
    ( esk3548_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3483_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_4615,axiom,
    ( ~ esk3391_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3586_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4616,axiom,
    ( ~ p(X29)
    | esk5512_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5707_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4617,axiom,
    ( esk2390_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2325_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4618,axiom,
    ( p(X15)
    | esk2917_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2982_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4619,axiom,
    ( ~ p(X20)
    | esk3746_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3941_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4620,axiom,
    ( esk6240_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6370_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_4621,axiom,
    ( p(X20)
    | esk3787_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3982_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4622,axiom,
    ( ~ esk3346_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | esk3151_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4623,axiom,
    ( ~ p(X2)
    | ~ esk394_2(X1,X2)
    | esk199_1(X1) ) ).

cnf(i_0_4624,axiom,
    ( ~ esk2014_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | esk1819_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4625,axiom,
    ( ~ p(X21)
    | ~ esk4077_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4207_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4626,axiom,
    ( ~ p(X18)
    | esk3502_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3632_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4627,axiom,
    ( ~ esk5438_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5503_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_4628,axiom,
    ( ~ esk1618_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1553_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4629,axiom,
    ( ~ esk4996_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26)
    | esk5191_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4630,axiom,
    ( p(X17)
    | ~ esk3437_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3242_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4631,axiom,
    ( ~ esk4029_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X21)
    | esk4224_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4632,axiom,
    ( p(X19)
    | esk3830_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3635_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4633,axiom,
    ( esk1616_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | ~ esk1551_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4634,axiom,
    ( ~ esk607_3(X1,X2,X3)
    | p(X3)
    | esk542_2(X1,X2) ) ).

cnf(i_0_4635,axiom,
    ( ~ p(X5)
    | ~ esk921_4(X1,X2,X3,X4)
    | esk1051_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4636,axiom,
    ( p(X29)
    | esk5604_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5669_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4637,axiom,
    ( esk4604_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | ~ esk4409_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4638,axiom,
    ( p(X29)
    | ~ esk5631_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5696_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4639,axiom,
    ( esk6290_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | ~ esk6225_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4640,axiom,
    ( ~ esk2319_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2384_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_4641,axiom,
    ( esk3935_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3870_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4642,axiom,
    ( esk4149_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4344_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_4643,axiom,
    ( ~ esk940_4(X1,X2,X3,X4)
    | esk1070_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_4644,axiom,
    ( ~ esk67_0
    | esk262_1(X1)
    | p(X1) ) ).

cnf(i_0_4645,axiom,
    ( ~ esk1657_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1527_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8) ) ).

cnf(i_0_4646,axiom,
    ( ~ p(X15)
    | esk2754_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2949_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4647,axiom,
    ( ~ esk1889_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk2019_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4648,axiom,
    ( esk1842_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10)
    | ~ esk2037_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4649,axiom,
    ( ~ esk3060_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3190_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_4650,axiom,
    ( esk1409_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7)
    | ~ esk1344_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4651,axiom,
    ( p(X11)
    | ~ esk2124_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2189_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4652,axiom,
    ( ~ esk3757_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3952_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4653,axiom,
    ( p(X15)
    | ~ esk2971_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2906_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4654,axiom,
    ( ~ esk2100_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11)
    | esk2230_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4655,axiom,
    ( ~ esk2016_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10)
    | esk1821_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4656,axiom,
    ( ~ esk4163_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | esk4033_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4657,axiom,
    ( ~ esk6233_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6363_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_4658,axiom,
    ( ~ p(X22)
    | ~ esk4290_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4420_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4659,axiom,
    ( ~ esk3517_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | esk3712_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4660,axiom,
    ( ~ esk1022_5(X1,X2,X3,X4,X5)
    | esk1217_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_4661,axiom,
    ( ~ p(X1)
    | esk306_1(X1)
    | ~ esk176_0 ) ).

cnf(i_0_4662,axiom,
    ( ~ esk3712_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3907_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X20) ) ).

cnf(i_0_4663,axiom,
    ( esk4648_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4778_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_4664,axiom,
    ( esk2676_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2806_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14) ) ).

cnf(i_0_4665,axiom,
    ( ~ esk6124_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | esk6319_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4666,axiom,
    ( p(X25)
    | ~ esk4775_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4970_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4667,axiom,
    ( p(X26)
    | ~ esk5085_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5020_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4668,axiom,
    ( esk3139_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3334_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_4669,axiom,
    ( esk2905_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2970_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_4670,axiom,
    ( ~ esk685_3(X1,X2,X3)
    | esk555_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_4671,axiom,
    ( ~ esk4414_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4284_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4672,axiom,
    ( esk673_3(X1,X2,X3)
    | p(X3)
    | ~ esk478_2(X1,X2) ) ).

cnf(i_0_4673,axiom,
    ( esk3435_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | ~ esk3240_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4674,axiom,
    ( esk410_2(X1,X2)
    | ~ p(X3)
    | ~ esk605_3(X1,X2,X3) ) ).

cnf(i_0_4675,axiom,
    ( ~ esk5253_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27)
    | esk5318_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4676,axiom,
    ( esk3798_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3603_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_4677,axiom,
    ( p(X6)
    | ~ esk1151_5(X1,X2,X3,X4,X5)
    | esk1216_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4678,axiom,
    ( esk1468_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk1663_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4679,axiom,
    ( esk2507_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X13)
    | ~ esk2572_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4680,axiom,
    ( ~ p(X1)
    | ~ esk281_1(X1)
    | esk151_0 ) ).

cnf(i_0_4681,axiom,
    ( esk4690_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X24)
    | ~ esk4625_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4682,axiom,
    ( ~ p(X1)
    | esk144_0
    | ~ esk274_1(X1) ) ).

cnf(i_0_4683,axiom,
    ( p(X17)
    | ~ esk3267_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3332_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4684,axiom,
    ( ~ p(X10)
    | esk2001_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1806_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4685,axiom,
    ( p(X11)
    | ~ esk2204_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2139_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4686,axiom,
    ( ~ esk2932_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2867_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X15) ) ).

cnf(i_0_4687,axiom,
    ( esk6259_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | ~ esk6064_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4688,axiom,
    ( ~ esk2909_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X15)
    | esk3039_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4689,axiom,
    ( esk4490_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4295_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23) ) ).

cnf(i_0_4690,axiom,
    ( esk1282_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1152_5(X1,X2,X3,X4,X5)
    | ~ p(X6) ) ).

cnf(i_0_4691,axiom,
    ( esk914_4(X1,X2,X3,X4)
    | ~ p(X5)
    | ~ esk1044_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4692,axiom,
    ( esk3907_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4102_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4693,axiom,
    ( esk394_2(X1,X2)
    | ~ esk329_1(X1)
    | p(X2) ) ).

cnf(i_0_4694,axiom,
    ( esk5178_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk4983_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_4695,axiom,
    ( ~ p(X30)
    | ~ esk5863_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5668_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4696,axiom,
    ( p(X8)
    | ~ esk1490_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1685_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4697,axiom,
    ( esk1235_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1170_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_4698,axiom,
    ( esk1624_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1559_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_4699,axiom,
    ( esk6306_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | ~ esk6111_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4700,axiom,
    ( ~ p(X21)
    | ~ esk4037_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4167_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4701,axiom,
    ( ~ esk1301_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk1366_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4702,axiom,
    ( ~ esk1681_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X8)
    | esk1486_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4703,axiom,
    ( p(X12)
    | ~ esk2350_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2285_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4704,axiom,
    ( esk915_4(X1,X2,X3,X4)
    | ~ esk1045_5(X1,X2,X3,X4,X5)
    | ~ p(X5) ) ).

cnf(i_0_4705,axiom,
    ( p(X32)
    | ~ esk6367_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6172_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4706,axiom,
    ( p(X12)
    | ~ esk2391_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2326_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4707,axiom,
    ( ~ esk392_2(X1,X2)
    | ~ p(X3)
    | esk587_3(X1,X2,X3) ) ).

cnf(i_0_4708,axiom,
    ( esk2199_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | ~ esk2134_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4709,axiom,
    ( ~ p(X16)
    | esk3151_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk2956_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4710,axiom,
    ( p(X2)
    | ~ esk378_1(X1)
    | esk443_2(X1,X2) ) ).

cnf(i_0_4711,axiom,
    ( ~ esk5753_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | esk5623_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4712,axiom,
    ( esk1088_5(X1,X2,X3,X4,X5)
    | ~ esk1283_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_4713,axiom,
    ( p(X19)
    | ~ esk3592_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3787_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4714,axiom,
    ( ~ p(X14)
    | esk2536_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2731_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4715,axiom,
    ( ~ esk5333_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5528_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_4716,axiom,
    ( esk4840_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4905_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25) ) ).

cnf(i_0_4717,axiom,
    ( ~ esk6028_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | esk6158_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4718,axiom,
    ( ~ esk1970_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1905_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_4719,axiom,
    ( ~ esk1703_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9)
    | esk1768_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4720,axiom,
    ( esk3347_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3542_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_4721,axiom,
    ( ~ esk83_0
    | p(X1)
    | esk278_1(X1) ) ).

cnf(i_0_4722,axiom,
    ( p(X18)
    | esk3509_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3574_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4723,axiom,
    ( ~ esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6352_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6287_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4724,axiom,
    ( p(X13)
    | esk2505_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2570_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4725,axiom,
    ( ~ p(X19)
    | esk3804_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3674_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4726,axiom,
    ( p(X23)
    | esk4534_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4469_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4727,axiom,
    ( esk6133_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5938_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_4728,axiom,
    ( esk4339_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4144_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_4729,axiom,
    ( esk1522_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X8)
    | ~ esk1652_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4730,axiom,
    ( ~ p(X22)
    | ~ esk4412_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4282_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4731,axiom,
    ( ~ esk4404_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | esk4209_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4732,axiom,
    ( ~ p(X2)
    | ~ esk497_2(X1,X2)
    | esk367_1(X1) ) ).

cnf(i_0_4733,axiom,
    ( ~ esk3210_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | esk3080_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4734,axiom,
    ( ~ p(X5)
    | ~ esk913_4(X1,X2,X3,X4)
    | esk1043_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4735,axiom,
    ( ~ esk3186_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk2991_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_4736,axiom,
    ( esk1893_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1958_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_4737,axiom,
    ( ~ esk5888_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | esk5693_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4738,axiom,
    ( ~ p(X28)
    | ~ esk5330_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5525_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4739,axiom,
    ( p(X13)
    | ~ esk2460_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2655_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4740,axiom,
    ( esk4626_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4756_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X24) ) ).

cnf(i_0_4741,axiom,
    ( p(X8)
    | ~ esk1627_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1432_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4742,axiom,
    ( ~ esk2360_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | esk2165_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4743,axiom,
    ( ~ esk2812_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | esk2617_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4744,axiom,
    ( ~ esk3412_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17)
    | esk3282_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4745,axiom,
    ( esk5450_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X28)
    | ~ esk5580_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4746,axiom,
    ( ~ esk5189_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4994_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_4747,axiom,
    ( ~ p(X31)
    | ~ esk5895_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6090_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4748,axiom,
    ( esk996_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk801_4(X1,X2,X3,X4) ) ).

cnf(i_0_4749,axiom,
    ( esk2827_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | ~ esk2632_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4750,axiom,
    ( esk1769_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1574_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_4751,axiom,
    ( ~ esk1433_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1238_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4752,axiom,
    ( p(X13)
    | esk2659_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2464_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4753,axiom,
    ( ~ esk6192_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | esk6322_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4754,axiom,
    ( ~ p(X21)
    | ~ esk3956_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4151_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4755,axiom,
    ( ~ esk3429_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17)
    | esk3234_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4756,axiom,
    ( ~ esk1805_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1610_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9) ) ).

cnf(i_0_4757,axiom,
    ( ~ esk1137_5(X1,X2,X3,X4,X5)
    | esk1267_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_4758,axiom,
    ( ~ esk1085_5(X1,X2,X3,X4,X5)
    | p(X6)
    | esk1280_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4759,axiom,
    ( esk2301_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2431_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_4760,axiom,
    ( p(X11)
    | ~ esk2174_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2109_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4761,axiom,
    ( esk4375_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22)
    | ~ esk4180_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4762,axiom,
    ( ~ esk1428_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7)
    | esk1233_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4763,axiom,
    ( ~ esk885_4(X1,X2,X3,X4)
    | esk690_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_4764,axiom,
    ( esk2072_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X10)
    | ~ esk1942_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4765,axiom,
    ( ~ p(X5)
    | esk949_4(X1,X2,X3,X4)
    | ~ esk1079_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4766,axiom,
    ( ~ esk1785_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1590_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4767,axiom,
    ( ~ esk1231_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk1036_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4768,axiom,
    ( esk5822_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ esk5887_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_4769,axiom,
    ( esk2027_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2222_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4770,axiom,
    ( ~ esk4811_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25)
    | esk4941_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4771,axiom,
    ( p(X24)
    | esk4699_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4634_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4772,axiom,
    ( esk3966_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3771_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4773,axiom,
    ( esk5359_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27)
    | ~ esk5229_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4774,axiom,
    ( esk4965_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4770_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25) ) ).

cnf(i_0_4775,axiom,
    ( esk2064_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1869_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_4776,axiom,
    ( p(X20)
    | ~ esk3996_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3801_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4777,axiom,
    ( ~ esk4417_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4287_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22) ) ).

cnf(i_0_4778,axiom,
    ( esk6323_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | ~ esk6128_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4779,axiom,
    ( esk4102_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3907_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_4780,axiom,
    ( p(X15)
    | ~ esk3020_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2825_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4781,axiom,
    ( p(X9)
    | ~ esk1685_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1880_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4782,axiom,
    ( ~ esk207_1(X1)
    | esk402_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_4783,axiom,
    ( p(X6)
    | esk1282_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1087_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4784,axiom,
    ( esk5681_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5876_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4785,axiom,
    ( ~ p(X3)
    | ~ esk594_3(X1,X2,X3)
    | esk399_2(X1,X2) ) ).

cnf(i_0_4786,axiom,
    ( esk2412_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2217_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4787,axiom,
    ( ~ esk490_2(X1,X2)
    | p(X3)
    | esk685_3(X1,X2,X3) ) ).

cnf(i_0_4788,axiom,
    ( esk411_2(X1,X2)
    | ~ esk606_3(X1,X2,X3)
    | ~ p(X3) ) ).

cnf(i_0_4789,axiom,
    ( esk1068_5(X1,X2,X3,X4,X5)
    | ~ esk873_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_4790,axiom,
    ( esk4321_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4516_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X23) ) ).

cnf(i_0_4791,axiom,
    ( esk202_1(X1)
    | ~ esk397_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_4792,axiom,
    ( esk6220_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6350_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4793,axiom,
    ( ~ p(X7)
    | esk1388_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1193_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4794,axiom,
    ( ~ esk3513_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3318_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_4795,axiom,
    ( p(X19)
    | esk3782_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3587_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4796,axiom,
    ( ~ esk2159_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2094_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4797,axiom,
    ( ~ esk515_2(X1,X2)
    | esk320_1(X1)
    | p(X2) ) ).

cnf(i_0_4798,axiom,
    ( esk617_3(X1,X2,X3)
    | ~ esk812_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_4799,axiom,
    ( esk6118_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32)
    | ~ esk6313_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4800,axiom,
    ( esk4179_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4049_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_4801,axiom,
    ( ~ esk1188_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk1383_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4802,axiom,
    ( ~ esk6214_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6279_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_4803,axiom,
    ( esk6001_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6131_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4804,axiom,
    ( ~ esk2155_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2090_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4805,axiom,
    ( esk5708_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29)
    | ~ esk5513_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4806,axiom,
    ( ~ p(X11)
    | esk2000_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2195_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4807,axiom,
    ( esk2382_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2187_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4808,axiom,
    ( esk2584_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2779_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4809,axiom,
    ( ~ esk5884_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6079_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_4810,axiom,
    ( ~ esk3460_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3590_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_4811,axiom,
    ( ~ esk2457_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2652_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_4812,axiom,
    ( ~ p(X31)
    | ~ esk6033_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6163_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4813,axiom,
    ( p(X22)
    | ~ esk4369_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4174_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4814,axiom,
    ( p(X26)
    | esk4965_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5160_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4815,axiom,
    ( ~ esk6342_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6309_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6310_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4816,axiom,
    ( ~ esk1193_6(X1,X2,X3,X4,X5,X6)
    | esk1128_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_4817,axiom,
    ( ~ esk6260_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6292_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4818,axiom,
    ( ~ esk885_4(X1,X2,X3,X4)
    | esk755_3(X1,X2,X3)
    | ~ p(X4) ) ).

cnf(i_0_4819,axiom,
    ( esk3666_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X19)
    | ~ esk3796_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4820,axiom,
    ( p(X31)
    | ~ esk5951_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6146_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4821,axiom,
    ( ~ esk5285_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5220_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4822,axiom,
    ( p(X13)
    | ~ esk2562_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2497_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4823,axiom,
    ( ~ p(X7)
    | esk1317_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1447_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4824,axiom,
    ( esk3732_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19)
    | ~ esk3667_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4825,axiom,
    ( ~ esk683_3(X1,X2,X3)
    | p(X4)
    | esk878_4(X1,X2,X3,X4) ) ).

cnf(i_0_4826,axiom,
    ( p(X14)
    | esk2624_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2819_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4827,axiom,
    ( ~ p(X28)
    | esk5473_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5278_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4828,axiom,
    ( ~ p(X21)
    | esk4134_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk3939_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4829,axiom,
    ( ~ esk3541_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X18)
    | esk3476_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4830,axiom,
    ( ~ esk3589_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3459_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_4831,axiom,
    ( esk5972_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6167_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4832,axiom,
    ( p(X19)
    | esk3739_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3674_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4833,axiom,
    ( ~ p(X27)
    | esk5238_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5368_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4834,axiom,
    ( ~ p(X28)
    | ~ esk5536_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5406_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4835,axiom,
    ( ~ esk1997_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2192_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_4836,axiom,
    ( ~ esk4398_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4268_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4837,axiom,
    ( p(X19)
    | ~ esk3643_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3708_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4838,axiom,
    ( ~ esk3710_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3645_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_4839,axiom,
    ( ~ esk2651_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | esk2846_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4840,axiom,
    ( ~ esk1255_6(X1,X2,X3,X4,X5,X6)
    | esk1450_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X7) ) ).

cnf(i_0_4841,axiom,
    ( esk6363_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6168_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_4842,axiom,
    ( ~ esk3160_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3355_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4843,axiom,
    ( p(X27)
    | ~ esk5346_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5151_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4844,axiom,
    ( esk2260_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | ~ esk2065_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4845,axiom,
    ( ~ esk5943_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30)
    | esk5748_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4846,axiom,
    ( ~ esk254_1(X1)
    | esk59_0
    | ~ p(X1) ) ).

cnf(i_0_4847,axiom,
    ( esk5633_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29)
    | ~ esk5763_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4848,axiom,
    ( ~ esk776_3(X1,X2,X3)
    | esk841_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_4849,axiom,
    ( esk5391_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5586_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | p(X28) ) ).

cnf(i_0_4850,axiom,
    ( esk201_1(X1)
    | ~ esk396_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_4851,axiom,
    ( ~ p(X28)
    | ~ esk5508_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5313_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4852,axiom,
    ( esk2600_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2405_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_4853,axiom,
    ( ~ esk645_3(X1,X2,X3)
    | esk840_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_4854,axiom,
    ( esk4977_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5172_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_4855,axiom,
    ( ~ p(X3)
    | esk578_2(X1,X2)
    | ~ esk708_3(X1,X2,X3) ) ).

cnf(i_0_4856,axiom,
    ( ~ p(X31)
    | ~ esk5875_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6070_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4857,axiom,
    ( ~ p(X21)
    | ~ esk3921_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4116_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4858,axiom,
    ( p(X21)
    | ~ esk4068_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4133_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4859,axiom,
    ( ~ p(X2)
    | esk518_2(X1,X2)
    | ~ esk388_1(X1) ) ).

cnf(i_0_4860,axiom,
    ( esk2437_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2242_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X12) ) ).

cnf(i_0_4861,axiom,
    ( ~ esk5370_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | p(X27)
    | esk5175_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4862,axiom,
    ( esk383_1(X1)
    | ~ p(X2)
    | ~ esk513_2(X1,X2) ) ).

cnf(i_0_4863,axiom,
    ( ~ p(X10)
    | esk1986_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1791_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4864,axiom,
    ( esk5182_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk5052_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4865,axiom,
    ( ~ esk1800_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9)
    | esk1605_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4866,axiom,
    ( ~ esk2839_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2709_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4867,axiom,
    ( esk286_1(X1)
    | ~ esk156_0
    | ~ p(X1) ) ).

cnf(i_0_4868,axiom,
    ( ~ esk3811_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3616_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_4869,axiom,
    ( esk3238_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3433_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X17) ) ).

cnf(i_0_4870,axiom,
    ( p(X15)
    | ~ esk3001_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2806_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4871,axiom,
    ( p(X27)
    | ~ esk5330_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5265_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4872,axiom,
    ( esk2319_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2449_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12) ) ).

cnf(i_0_4873,axiom,
    ( ~ esk649_3(X1,X2,X3)
    | esk454_2(X1,X2)
    | ~ p(X3) ) ).

cnf(i_0_4874,axiom,
    ( ~ esk3158_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X17)
    | esk3353_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17) ) ).

cnf(i_0_4875,axiom,
    ( ~ esk4906_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25)
    | esk4711_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4876,axiom,
    ( ~ esk2745_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | esk2680_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4877,axiom,
    ( ~ p(X28)
    | ~ esk5460_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5590_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4878,axiom,
    ( p(X5)
    | ~ esk1004_5(X1,X2,X3,X4,X5)
    | esk939_4(X1,X2,X3,X4) ) ).

cnf(i_0_4879,axiom,
    ( esk1965_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2160_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_4880,axiom,
    ( ~ esk5108_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk4913_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26) ) ).

cnf(i_0_4881,axiom,
    ( p(X8)
    | esk1479_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1674_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4882,axiom,
    ( ~ esk1263_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk1133_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4883,axiom,
    ( p(X25)
    | ~ esk4780_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4975_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4884,axiom,
    ( p(X4)
    | esk689_3(X1,X2,X3)
    | ~ esk884_4(X1,X2,X3,X4) ) ).

cnf(i_0_4885,axiom,
    ( ~ p(X15)
    | ~ esk2901_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3031_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_4886,axiom,
    ( esk5612_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ esk5677_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_4887,axiom,
    ( ~ p(X8)
    | esk1676_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1546_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4888,axiom,
    ( esk2437_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X12)
    | ~ esk2307_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4889,axiom,
    ( p(X15)
    | esk3038_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2843_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4890,axiom,
    ( p(X14)
    | esk2718_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2783_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4891,axiom,
    ( esk802_4(X1,X2,X3,X4)
    | ~ esk737_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_4892,axiom,
    ( ~ esk6298_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6265_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6363_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4893,axiom,
    ( ~ p(X6)
    | ~ esk1232_6(X1,X2,X3,X4,X5,X6)
    | esk1037_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_4894,axiom,
    ( ~ esk2798_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | p(X14)
    | esk2603_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4895,axiom,
    ( p(X29)
    | ~ esk5723_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5528_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_4896,axiom,
    ( esk6008_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X31)
    | ~ esk6138_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4897,axiom,
    ( esk4910_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X25)
    | ~ esk4845_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4898,axiom,
    ( esk6071_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6266_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4899,axiom,
    ( esk4964_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5159_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_4900,axiom,
    ( esk4790_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4595_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24) ) ).

cnf(i_0_4901,axiom,
    ( esk3820_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3625_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_4902,axiom,
    ( ~ p(X13)
    | ~ esk2597_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2402_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4903,axiom,
    ( p(X30)
    | ~ esk5745_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5940_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4904,axiom,
    ( ~ esk2383_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2188_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_4905,axiom,
    ( ~ p(X27)
    | ~ esk5244_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5374_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4906,axiom,
    ( ~ esk4379_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22)
    | esk4249_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4907,axiom,
    ( esk2590_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | ~ esk2785_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4908,axiom,
    ( ~ esk6318_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6188_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32) ) ).

cnf(i_0_4909,axiom,
    ( esk3954_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3759_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_4910,axiom,
    ( esk5106_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5301_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_4911,axiom,
    ( p(X19)
    | esk3590_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3785_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_4912,axiom,
    ( esk2813_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2683_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4913,axiom,
    ( esk6295_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6262_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6360_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4914,axiom,
    ( esk4912_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4717_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_4915,axiom,
    ( ~ esk2670_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14)
    | esk2735_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4916,axiom,
    ( p(X17)
    | ~ esk3443_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3248_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4917,axiom,
    ( esk2812_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2617_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X14) ) ).

cnf(i_0_4918,axiom,
    ( esk272_1(X1)
    | ~ esk467_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_4919,axiom,
    ( ~ esk2147_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2082_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4920,axiom,
    ( esk319_1(X1)
    | ~ esk514_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_4921,axiom,
    ( p(X11)
    | ~ esk2175_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2110_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4922,axiom,
    ( ~ p(X24)
    | ~ esk4782_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4652_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4923,axiom,
    ( ~ p(X26)
    | esk5025_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5155_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4924,axiom,
    ( p(X9)
    | esk1709_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1774_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_4925,axiom,
    ( ~ esk1427_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1362_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4926,axiom,
    ( ~ esk5681_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5486_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X29) ) ).

cnf(i_0_4927,axiom,
    ( esk5856_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5661_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30) ) ).

cnf(i_0_4928,axiom,
    ( p(X27)
    | ~ esk5232_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5297_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4929,axiom,
    ( esk253_1(X1)
    | ~ esk188_0
    | p(X1) ) ).

cnf(i_0_4930,axiom,
    ( p(X25)
    | ~ esk4796_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4991_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4931,axiom,
    ( p(X27)
    | esk5252_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5317_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4932,axiom,
    ( esk2827_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | ~ esk2697_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4933,axiom,
    ( ~ p(X24)
    | esk4726_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4531_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4934,axiom,
    ( p(X7)
    | esk1421_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1356_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_4935,axiom,
    ( p(X28)
    | ~ esk5548_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5353_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4936,axiom,
    ( esk4575_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | ~ esk4770_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4937,axiom,
    ( ~ esk3588_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3458_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18) ) ).

cnf(i_0_4938,axiom,
    ( p(X8)
    | ~ esk1535_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1600_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_4939,axiom,
    ( ~ esk868_4(X1,X2,X3,X4)
    | esk1063_5(X1,X2,X3,X4,X5)
    | p(X5) ) ).

cnf(i_0_4940,axiom,
    ( ~ p(X7)
    | esk1222_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1417_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4941,axiom,
    ( p(X24)
    | esk4684_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4619_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4942,axiom,
    ( p(X27)
    | ~ esk5272_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5207_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4943,axiom,
    ( ~ p(X5)
    | ~ esk1081_5(X1,X2,X3,X4,X5)
    | esk951_4(X1,X2,X3,X4) ) ).

cnf(i_0_4944,axiom,
    ( ~ esk648_3(X1,X2,X3)
    | p(X3)
    | esk583_2(X1,X2) ) ).

cnf(i_0_4945,axiom,
    ( ~ p(X32)
    | esk6194_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6324_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_4946,axiom,
    ( esk4703_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4508_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_4947,axiom,
    ( esk4203_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4398_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_4948,axiom,
    ( ~ esk898_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk768_3(X1,X2,X3) ) ).

cnf(i_0_4949,axiom,
    ( esk1452_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1257_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_4950,axiom,
    ( ~ p(X11)
    | ~ esk2259_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2129_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4951,axiom,
    ( ~ esk4228_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X22)
    | esk4358_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4952,axiom,
    ( ~ esk5389_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5194_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_4953,axiom,
    ( esk235_1(X1)
    | p(X1)
    | ~ esk170_0 ) ).

cnf(i_0_4954,axiom,
    ( p(X25)
    | ~ esk4919_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4854_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4955,axiom,
    ( p(X3)
    | ~ esk600_3(X1,X2,X3)
    | esk535_2(X1,X2) ) ).

cnf(i_0_4956,axiom,
    ( esk5004_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4874_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ p(X25) ) ).

cnf(i_0_4957,axiom,
    ( ~ esk2598_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2403_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ p(X13) ) ).

cnf(i_0_4958,axiom,
    ( ~ p(X14)
    | esk2769_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2574_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_4959,axiom,
    ( p(X22)
    | ~ esk4373_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | esk4178_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_4960,axiom,
    ( p(X31)
    | esk6142_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5947_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_4961,axiom,
    ( esk1599_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1534_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8) ) ).

cnf(i_0_4962,axiom,
    ( ~ esk1893_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | esk2023_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4963,axiom,
    ( ~ esk738_3(X1,X2,X3)
    | p(X4)
    | esk803_4(X1,X2,X3,X4) ) ).

cnf(i_0_4964,axiom,
    ( p(X24)
    | ~ esk4708_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4643_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_4965,axiom,
    ( ~ esk4289_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4419_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_4966,axiom,
    ( esk2128_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk2258_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_4967,axiom,
    ( esk3006_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15)
    | ~ esk2811_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_4968,axiom,
    ( esk5072_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5007_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | p(X26) ) ).

cnf(i_0_4969,axiom,
    ( p(X10)
    | ~ esk1832_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2027_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_4970,axiom,
    ( esk1643_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8)
    | ~ esk1513_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_4971,axiom,
    ( ~ p(X25)
    | esk4840_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4970_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4972,axiom,
    ( esk2446_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2251_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_4973,axiom,
    ( ~ esk3005_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16)
    | esk3200_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_4974,axiom,
    ( p(X25)
    | esk4864_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4929_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_4975,axiom,
    ( esk789_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk724_3(X1,X2,X3) ) ).

cnf(i_0_4976,axiom,
    ( ~ p(X25)
    | ~ esk4942_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk4812_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4977,axiom,
    ( ~ esk3404_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18)
    | esk3599_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_4978,axiom,
    ( esk2221_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2026_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4979,axiom,
    ( ~ esk6294_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32)
    | esk6229_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_4980,axiom,
    ( esk2191_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2126_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11) ) ).

cnf(i_0_4981,axiom,
    ( p(X26)
    | ~ esk5045_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5110_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4982,axiom,
    ( ~ p(X30)
    | ~ esk5908_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk5713_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4983,axiom,
    ( ~ esk390_1(X1)
    | esk520_2(X1,X2)
    | ~ p(X2) ) ).

cnf(i_0_4984,axiom,
    ( ~ esk2271_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk2141_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_4985,axiom,
    ( p(X27)
    | esk5213_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5278_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_4986,axiom,
    ( ~ esk2829_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk3024_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X15) ) ).

cnf(i_0_4987,axiom,
    ( esk2016_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1821_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X10) ) ).

cnf(i_0_4988,axiom,
    ( ~ esk2590_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13)
    | esk2395_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_4989,axiom,
    ( p(X20)
    | ~ esk3872_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3937_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_4990,axiom,
    ( ~ esk1708_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1773_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | p(X9) ) ).

cnf(i_0_4991,axiom,
    ( ~ esk5070_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5200_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26) ) ).

cnf(i_0_4992,axiom,
    ( ~ esk4931_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X26)
    | esk5126_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_4993,axiom,
    ( ~ esk5945_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30)
    | esk5815_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_4994,axiom,
    ( esk4259_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4324_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X22) ) ).

cnf(i_0_4995,axiom,
    ( esk2312_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2377_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12) ) ).

cnf(i_0_4996,axiom,
    ( p(X25)
    | esk4933_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk4868_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_4997,axiom,
    ( ~ esk4515_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X23)
    | esk4450_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4998,axiom,
    ( ~ p(X22)
    | esk4107_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4302_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_4999,axiom,
    ( p(X31)
    | ~ esk6113_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk5918_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_5000,axiom,
    ( ~ esk832_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk637_3(X1,X2,X3) ) ).

cnf(i_0_5001,axiom,
    ( esk657_3(X1,X2,X3)
    | ~ esk462_2(X1,X2)
    | p(X3) ) ).

cnf(i_0_5002,axiom,
    ( esk929_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk994_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_5003,axiom,
    ( esk2970_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | ~ esk3165_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_5004,axiom,
    ( esk4500_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4435_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_5005,axiom,
    ( ~ p(X23)
    | ~ esk4592_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4462_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_5006,axiom,
    ( esk2648_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13)
    | ~ esk2453_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_5007,axiom,
    ( p(X22)
    | esk4298_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4233_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_5008,axiom,
    ( esk4760_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4630_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_5009,axiom,
    ( esk4827_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4957_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ p(X25) ) ).

cnf(i_0_5010,axiom,
    ( ~ esk5699_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5894_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_5011,axiom,
    ( ~ p(X18)
    | ~ esk3323_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3518_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_5012,axiom,
    ( ~ esk2029_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2224_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5013,axiom,
    ( ~ esk3435_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | esk3240_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_5014,axiom,
    ( ~ p(X19)
    | ~ esk3764_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3569_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_5015,axiom,
    ( esk1081_5(X1,X2,X3,X4,X5)
    | ~ p(X5)
    | ~ esk951_4(X1,X2,X3,X4) ) ).

cnf(i_0_5016,axiom,
    ( esk43_0
    | ~ esk238_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_5017,axiom,
    ( ~ esk2107_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | esk2172_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5018,axiom,
    ( esk3936_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk3741_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20) ) ).

cnf(i_0_5019,axiom,
    ( esk3939_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | ~ esk4134_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_5020,axiom,
    ( esk3554_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3489_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | p(X18) ) ).

cnf(i_0_5021,axiom,
    ( p(X2)
    | esk408_2(X1,X2)
    | ~ esk343_1(X1) ) ).

cnf(i_0_5022,axiom,
    ( p(X6)
    | ~ esk1135_5(X1,X2,X3,X4,X5)
    | esk1200_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_5023,axiom,
    ( esk6198_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6263_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_5024,axiom,
    ( esk2435_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | p(X12)
    | ~ esk2240_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5025,axiom,
    ( esk3178_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ esk3113_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_5026,axiom,
    ( ~ p(X7)
    | esk1424_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1229_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_5027,axiom,
    ( ~ p(X32)
    | ~ esk6362_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6232_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_5028,axiom,
    ( ~ esk820_4(X1,X2,X3,X4)
    | esk755_3(X1,X2,X3)
    | p(X4) ) ).

cnf(i_0_5029,axiom,
    ( p(X21)
    | esk4046_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ esk4111_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_5030,axiom,
    ( ~ esk6247_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32)
    | esk6052_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_5031,axiom,
    ( ~ esk3122_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3317_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X17) ) ).

cnf(i_0_5032,axiom,
    ( esk3229_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16)
    | ~ esk3099_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_5033,axiom,
    ( ~ esk1042_5(X1,X2,X3,X4,X5)
    | esk1237_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_5034,axiom,
    ( ~ p(X13)
    | ~ esk2596_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2401_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_5035,axiom,
    ( esk4159_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ p(X21)
    | ~ esk3964_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5036,axiom,
    ( ~ esk5538_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5733_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X29) ) ).

cnf(i_0_5037,axiom,
    ( ~ esk4172_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4042_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_5038,axiom,
    ( ~ p(X24)
    | esk4530_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ esk4725_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_5039,axiom,
    ( esk593_3(X1,X2,X3)
    | p(X3)
    | ~ esk528_2(X1,X2) ) ).

cnf(i_0_5040,axiom,
    ( ~ esk2266_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | p(X11)
    | esk2071_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_5041,axiom,
    ( ~ p(X14)
    | ~ esk2843_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2713_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_5042,axiom,
    ( esk3345_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3280_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X17) ) ).

cnf(i_0_5043,axiom,
    ( ~ esk1188_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6)
    | esk993_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_5044,axiom,
    ( ~ p(X1)
    | ~ esk142_0
    | esk272_1(X1) ) ).

cnf(i_0_5045,axiom,
    ( ~ esk5135_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5330_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_5046,axiom,
    ( ~ p(X14)
    | esk2831_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2701_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_5047,axiom,
    ( ~ esk200_1(X1)
    | ~ p(X1)
    | esk5_0 ) ).

cnf(i_0_5048,axiom,
    ( esk2824_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk2694_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14) ) ).

cnf(i_0_5049,axiom,
    ( esk6005_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk6135_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X31) ) ).

cnf(i_0_5050,axiom,
    ( p(X6)
    | ~ esk1130_5(X1,X2,X3,X4,X5)
    | esk1195_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_5051,axiom,
    ( p(X15)
    | esk3016_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk2821_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_5052,axiom,
    ( p(X10)
    | ~ esk1887_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1952_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_5053,axiom,
    ( esk6254_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6189_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | p(X32) ) ).

cnf(i_0_5054,axiom,
    ( ~ esk4137_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | p(X21)
    | esk4072_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5055,axiom,
    ( ~ esk2161_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | esk1966_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_5056,axiom,
    ( ~ p(X15)
    | ~ esk3040_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk2910_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_5057,axiom,
    ( ~ esk5302_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5497_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28) ) ).

cnf(i_0_5058,axiom,
    ( esk875_4(X1,X2,X3,X4)
    | p(X5)
    | ~ esk1070_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_5059,axiom,
    ( esk6121_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk5926_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_5060,axiom,
    ( esk4763_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | p(X25)
    | ~ esk4958_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_5061,axiom,
    ( ~ esk1201_6(X1,X2,X3,X4,X5,X6)
    | esk1396_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ p(X7) ) ).

cnf(i_0_5062,axiom,
    ( esk2022_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2217_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5063,axiom,
    ( ~ esk2546_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X14)
    | esk2741_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14) ) ).

cnf(i_0_5064,axiom,
    ( ~ p(X3)
    | ~ esk448_2(X1,X2)
    | esk643_3(X1,X2,X3) ) ).

cnf(i_0_5065,axiom,
    ( ~ p(X11)
    | ~ esk2099_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2229_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5066,axiom,
    ( esk1788_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1723_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_5067,axiom,
    ( ~ esk2814_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ p(X14)
    | esk2684_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_5068,axiom,
    ( p(X22)
    | esk4228_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | ~ esk4293_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22) ) ).

cnf(i_0_5069,axiom,
    ( ~ p(X8)
    | ~ esk1614_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1419_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_5070,axiom,
    ( esk2886_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | ~ esk3016_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X15) ) ).

cnf(i_0_5071,axiom,
    ( esk5093_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X26)
    | ~ esk4898_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_5072,axiom,
    ( p(X21)
    | ~ esk4041_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk4106_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_5073,axiom,
    ( esk6243_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6341_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6276_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_5074,axiom,
    ( esk2461_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2331_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12) ) ).

cnf(i_0_5075,axiom,
    ( esk2199_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2004_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ p(X11) ) ).

cnf(i_0_5076,axiom,
    ( ~ esk168_0
    | esk298_1(X1)
    | ~ p(X1) ) ).

cnf(i_0_5077,axiom,
    ( p(X20)
    | ~ esk3968_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | esk3773_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_5078,axiom,
    ( ~ p(X7)
    | esk1457_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1327_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_5079,axiom,
    ( esk1926_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1991_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X10) ) ).

cnf(i_0_5080,axiom,
    ( ~ p(X9)
    | ~ esk1833_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1703_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_5081,axiom,
    ( ~ esk1738_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X9)
    | esk1868_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_5082,axiom,
    ( p(X6)
    | ~ esk1287_6(X1,X2,X3,X4,X5,X6)
    | esk1092_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_5083,axiom,
    ( ~ esk3065_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ p(X16)
    | esk3195_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_5084,axiom,
    ( ~ p(X9)
    | ~ esk1776_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk1581_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_5085,axiom,
    ( ~ esk3914_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21)
    | esk4109_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21) ) ).

cnf(i_0_5086,axiom,
    ( p(X26)
    | ~ esk5014_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | esk5079_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26) ) ).

cnf(i_0_5087,axiom,
    ( ~ esk4712_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4517_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | ~ p(X24) ) ).

cnf(i_0_5088,axiom,
    ( esk6191_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6321_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ p(X32) ) ).

cnf(i_0_5089,axiom,
    ( esk1516_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1646_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_5090,axiom,
    ( ~ p(X16)
    | ~ esk2982_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3177_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_5091,axiom,
    ( ~ esk6316_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6349_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6317_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_5092,axiom,
    ( ~ esk1964_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk1769_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10) ) ).

cnf(i_0_5093,axiom,
    ( esk6057_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ p(X32)
    | ~ esk6252_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_5094,axiom,
    ( ~ esk2320_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X12)
    | esk2450_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_5095,axiom,
    ( ~ p(X24)
    | ~ esk4754_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4624_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_5096,axiom,
    ( p(X5)
    | ~ esk1044_5(X1,X2,X3,X4,X5)
    | esk849_4(X1,X2,X3,X4) ) ).

cnf(i_0_5097,axiom,
    ( esk6370_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | esk6272_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6305_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_5098,axiom,
    ~ esk34_0 ).

cnf(i_0_5099,axiom,
    ( ~ p(X2)
    | ~ esk332_1(X1)
    | esk462_2(X1,X2) ) ).

cnf(i_0_5100,axiom,
    ( ~ esk524_2(X1,X2)
    | p(X3)
    | esk589_3(X1,X2,X3) ) ).

cnf(i_0_5101,axiom,
    ( ~ esk4197_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4067_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | ~ p(X21) ) ).

cnf(i_0_5102,axiom,
    ( ~ p(X6)
    | esk1174_6(X1,X2,X3,X4,X5,X6)
    | ~ esk979_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_5103,axiom,
    ( ~ p(X15)
    | ~ esk2755_14(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14)
    | esk2950_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15) ) ).

cnf(i_0_5104,axiom,
    ( p(X20)
    | esk3879_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3944_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5105,axiom,
    ( esk2479_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | ~ esk2544_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | p(X13) ) ).

cnf(i_0_5106,axiom,
    ( ~ esk5365_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5235_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_5107,axiom,
    ( esk5793_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X30)
    | ~ esk5923_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_5108,axiom,
    ( esk6289_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | ~ esk6257_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32) ) ).

cnf(i_0_5109,axiom,
    ( ~ esk5242_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | esk5372_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_5110,axiom,
    ( ~ esk5306_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5111_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27) ) ).

cnf(i_0_5111,axiom,
    ( esk1175_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1110_5(X1,X2,X3,X4,X5)
    | p(X6) ) ).

cnf(i_0_5112,axiom,
    ( ~ p(X20)
    | esk3895_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk4025_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5113,axiom,
    ( ~ esk3745_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X20)
    | esk3940_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5114,axiom,
    ( esk5347_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ esk5152_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X27) ) ).

cnf(i_0_5115,axiom,
    ( ~ esk857_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk727_3(X1,X2,X3) ) ).

cnf(i_0_5116,axiom,
    ( ~ p(X9)
    | ~ esk1741_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | esk1871_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_5117,axiom,
    ( esk327_1(X1)
    | p(X2)
    | ~ esk392_2(X1,X2) ) ).

cnf(i_0_5118,axiom,
    ( esk6082_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | ~ esk6017_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31) ) ).

cnf(i_0_5119,axiom,
    ( esk197_1(X1)
    | ~ p(X2)
    | ~ esk392_2(X1,X2) ) ).

cnf(i_0_5120,axiom,
    ( ~ esk5760_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5955_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X30) ) ).

cnf(i_0_5121,axiom,
    ( esk4427_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X23)
    | ~ esk4557_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_5122,axiom,
    ( esk5823_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | p(X30)
    | ~ esk5888_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_5123,axiom,
    ( ~ esk5843_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | esk5973_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ p(X30) ) ).

cnf(i_0_5124,axiom,
    ( ~ p(X28)
    | ~ esk5413_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | esk5543_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28) ) ).

cnf(i_0_5125,axiom,
    ( esk5260_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ p(X27)
    | ~ esk5390_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_5126,axiom,
    ( p(X20)
    | esk3854_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ esk3919_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5127,axiom,
    ( ~ esk1054_5(X1,X2,X3,X4,X5)
    | esk1249_6(X1,X2,X3,X4,X5,X6)
    | p(X6) ) ).

cnf(i_0_5128,axiom,
    ( esk294_1(X1)
    | ~ esk489_2(X1,X2)
    | p(X2) ) ).

cnf(i_0_5129,axiom,
    ( p(X13)
    | ~ esk2604_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | esk2409_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_5130,axiom,
    ( ~ esk1491_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1296_6(X1,X2,X3,X4,X5,X6)
    | p(X7) ) ).

cnf(i_0_5131,axiom,
    ( esk5995_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | p(X31)
    | ~ esk6060_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_5132,axiom,
    ( ~ esk5652_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5782_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29)
    | ~ p(X29) ) ).

cnf(i_0_5133,axiom,
    ( ~ p(X11)
    | ~ esk1978_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2173_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5134,axiom,
    ( ~ p(X28)
    | ~ esk5517_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5322_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_5135,axiom,
    ( esk1813_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ esk1748_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | p(X9) ) ).

cnf(i_0_5136,axiom,
    ( esk1942_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X10)
    | ~ esk2072_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_5137,axiom,
    ( ~ esk4285_21(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21)
    | esk4415_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ p(X22) ) ).

cnf(i_0_5138,axiom,
    ( ~ p(X25)
    | esk4832_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | ~ esk4962_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_5139,axiom,
    ( ~ p(X2)
    | esk206_1(X1)
    | ~ esk401_2(X1,X2) ) ).

cnf(i_0_5140,axiom,
    ( esk1471_7(X1,X2,X3,X4,X5,X6,X7)
    | p(X8)
    | ~ esk1666_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_5141,axiom,
    ( ~ esk4673_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | p(X24)
    | esk4738_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24) ) ).

cnf(i_0_5142,axiom,
    ( ~ p(X30)
    | esk5940_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5810_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_5143,axiom,
    ( ~ esk51_0
    | ~ p(X1)
    | esk246_1(X1) ) ).

cnf(i_0_5144,axiom,
    ( ~ p(X1)
    | ~ esk246_1(X1)
    | esk51_0 ) ).

cnf(i_0_5145,axiom,
    ( ~ esk3131_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | esk3066_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | p(X16) ) ).

cnf(i_0_5146,axiom,
    ( ~ p(X29)
    | ~ esk5502_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | esk5697_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_5147,axiom,
    ( ~ esk855_4(X1,X2,X3,X4)
    | p(X4)
    | esk660_3(X1,X2,X3) ) ).

cnf(i_0_5148,axiom,
    ( ~ esk6136_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6331_32(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31,X32)
    | p(X32) ) ).

cnf(i_0_5149,axiom,
    ( esk3450_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3580_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ p(X18) ) ).

cnf(i_0_5150,axiom,
    ( esk3636_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | ~ esk3831_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_5151,axiom,
    ( ~ esk3078_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | esk3208_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | ~ p(X16) ) ).

cnf(i_0_5152,axiom,
    ( esk54_0
    | ~ p(X1)
    | ~ esk249_1(X1) ) ).

cnf(i_0_5153,axiom,
    ( p(X3)
    | esk663_3(X1,X2,X3)
    | ~ esk468_2(X1,X2) ) ).

cnf(i_0_5154,axiom,
    ( esk4020_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | ~ esk3825_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_5155,axiom,
    ( ~ p(X17)
    | esk3440_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ esk3310_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16) ) ).

cnf(i_0_5156,axiom,
    ( ~ esk3855_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3920_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20) ) ).

cnf(i_0_5157,axiom,
    ( ~ p(X1)
    | esk283_1(X1)
    | ~ esk153_0 ) ).

cnf(i_0_5158,axiom,
    ( esk4365_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23)
    | ~ esk4560_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_5159,axiom,
    ( ~ esk3684_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3749_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X19) ) ).

cnf(i_0_5160,axiom,
    ( ~ esk3764_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3699_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | p(X19) ) ).

cnf(i_0_5161,axiom,
    ( ~ esk2368_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2563_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ p(X13) ) ).

cnf(i_0_5162,axiom,
    ( ~ esk1012_5(X1,X2,X3,X4,X5)
    | esk947_4(X1,X2,X3,X4)
    | p(X5) ) ).

cnf(i_0_5163,axiom,
    ( ~ esk3777_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | ~ p(X19)
    | esk3647_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_5164,axiom,
    ( ~ esk3794_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | p(X20)
    | esk3989_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5165,axiom,
    ( ~ p(X9)
    | esk1754_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1884_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_5166,axiom,
    ( ~ p(X8)
    | esk1382_7(X1,X2,X3,X4,X5,X6,X7)
    | ~ esk1577_8(X1,X2,X3,X4,X5,X6,X7,X8) ) ).

cnf(i_0_5167,axiom,
    ( ~ p(X23)
    | esk4352_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | ~ esk4547_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_5168,axiom,
    ( esk4985_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25)
    | ~ esk5180_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | p(X26) ) ).

cnf(i_0_5169,axiom,
    ( ~ esk4005_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20)
    | p(X20)
    | esk3810_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_5170,axiom,
    ( p(X19)
    | ~ esk3627_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18)
    | esk3822_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19) ) ).

cnf(i_0_5171,axiom,
    ( ~ esk1227_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X7)
    | esk1422_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_5172,axiom,
    ( esk1024_5(X1,X2,X3,X4,X5)
    | ~ esk1219_6(X1,X2,X3,X4,X5,X6)
    | ~ p(X6) ) ).

cnf(i_0_5173,axiom,
    ( ~ p(X13)
    | ~ esk2387_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12)
    | esk2582_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13) ) ).

cnf(i_0_5174,axiom,
    ( ~ p(X20)
    | ~ esk3725_19(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19)
    | esk3920_20(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20) ) ).

cnf(i_0_5175,axiom,
    ( p(X10)
    | ~ esk1852_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | esk2047_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_5176,axiom,
    ( esk1731_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ esk1861_9(X1,X2,X3,X4,X5,X6,X7,X8,X9)
    | ~ p(X9) ) ).

cnf(i_0_5177,axiom,
    ( p(X30)
    | esk5930_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | ~ esk5735_29(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29) ) ).

cnf(i_0_5178,axiom,
    ( ~ p(X24)
    | ~ esk4743_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4548_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23) ) ).

cnf(i_0_5179,axiom,
    ( esk5118_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | ~ esk5313_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_5180,axiom,
    ( p(X11)
    | esk2243_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ esk2048_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10) ) ).

cnf(i_0_5181,axiom,
    ( esk196_1(X1)
    | ~ p(X1)
    | ~ esk1_0 ) ).

cnf(i_0_5182,axiom,
    ( p(X25)
    | ~ esk4848_24(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24)
    | esk4913_25(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25) ) ).

cnf(i_0_5183,axiom,
    ( ~ esk3325_17(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17)
    | ~ p(X18)
    | esk3520_18(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18) ) ).

cnf(i_0_5184,axiom,
    ( esk2049_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | p(X11)
    | ~ esk2244_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11) ) ).

cnf(i_0_5185,axiom,
    ( p(X13)
    | esk2590_13(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13)
    | ~ esk2525_12(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12) ) ).

cnf(i_0_5186,axiom,
    ( p(X10)
    | esk1994_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | ~ esk1929_9(X1,X2,X3,X4,X5,X6,X7,X8,X9) ) ).

cnf(i_0_5187,axiom,
    ( p(X31)
    | ~ esk5919_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30)
    | esk6114_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31) ) ).

cnf(i_0_5188,axiom,
    ( ~ esk1955_10(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10)
    | esk2150_11(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11)
    | ~ p(X11) ) ).

cnf(i_0_5189,axiom,
    ( ~ esk1368_7(X1,X2,X3,X4,X5,X6,X7)
    | esk1563_8(X1,X2,X3,X4,X5,X6,X7,X8)
    | ~ p(X8) ) ).

cnf(i_0_5190,axiom,
    ( esk3016_15(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15)
    | ~ esk3211_16(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16)
    | p(X16) ) ).

cnf(i_0_5191,axiom,
    ( esk5554_28(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28)
    | ~ p(X28)
    | ~ esk5424_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27) ) ).

cnf(i_0_5192,axiom,
    ( ~ esk395_2(X1,X2)
    | p(X2)
    | esk330_1(X1) ) ).

cnf(i_0_5193,axiom,
    ( ~ esk5076_26(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26)
    | esk5271_27(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27)
    | ~ p(X27) ) ).

cnf(i_0_5194,axiom,
    ( esk1027_5(X1,X2,X3,X4,X5)
    | ~ p(X6)
    | ~ esk1222_6(X1,X2,X3,X4,X5,X6) ) ).

cnf(i_0_5195,axiom,
    ( p(X31)
    | ~ esk6084_31(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30,X31)
    | esk6019_30(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23,X24,X25,X26,X27,X28,X29,X30) ) ).

cnf(i_0_5196,axiom,
    ( ~ p(X6)
    | esk1271_6(X1,X2,X3,X4,X5,X6)
    | ~ esk1141_5(X1,X2,X3,X4,X5) ) ).

cnf(i_0_5197,axiom,
    ( ~ esk4514_23(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22,X23)
    | esk4449_22(X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15,X16,X17,X18,X19,X20,X21,X22)
    | p(X23) ) ).

cnf(i_0_5198,axiom,
    ( ~ esk1310_6(X1,X2,X3,X4,X5,X6)
    | p(X7)
    | esk1375_7(X1,X2,X3,X4,X5,X6,X7) ) ).

cnf(i_0_5199,axiom,
    ( ~ p(X1)
 