%------------------------------------------------------------------------------
% File     : HWV062-1 : TPTP v9.2.0. Bugfixed v5.5.1.
% Domain   : Hardware Verification
% Problem  : QBFLib problem from the BMC family
% Version  : Especial.
% English  : The BMC family consists of instances of Bounded Model Checking, 
%            where different properties are being checked for several circuits 
%            and different bounds.

% Refs     : [Sei12] Seidl (2012), Email to Geoff Sutcliffe
%          : [SLB12] Seidl et al. (2012), Tool for Generating EPR Formulas
% Source   : [Sei12]
% Names    : c4_BMC_p1_k1024-shuffled [Sei12]

% Status   : Satisfiable
% Rating   : 0.29 v9.1.0, 0.25 v9.0.0, 0.33 v8.2.0, 0.40 v8.1.0, 0.20 v7.5.0, 0.25 v7.0.0, 0.00 v6.2.0, 0.50 v6.1.0, 0.60 v6.0.0
% Syntax   : Number of clauses     : 39513 (  69 unt;14888 nHn;28421 RR)
%            Number of literals    : 95533 (   1 equ;46615 neg)
%            Maximal clause size   :    6 (   2 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of predicates  : 15310 (15309 usr; 332 prp; 0-4 aty)
%            Number of functors    :    2 (   2 usr;   2 con; 0-0 aty)
%            Number of variables   : 158032 ( 256 sgn)
% SPC      : CNF_SAT_EPR_EQU_NUE

% Comments :
% Bugfixes : v5.5.1 - Fixed rule_true and rule_false, added true_not_false
%------------------------------------------------------------------------------
cnf(i_0_1,axiom,
    ( ~ esk5294_4(X1,X2,X3,X4)
    | esk5552_4(X1,X2,X3,X4) ) ).

cnf(i_0_2,axiom,
    ( esk12180_4(X1,X2,X3,X4)
    | ~ esk12215_4(X1,X2,X3,X4) ) ).

cnf(i_0_3,axiom,
    ( esk1997_4(X1,X2,X3,X4)
    | esk2030_4(X1,X2,X3,X4) ) ).

cnf(i_0_4,axiom,
    ( esk14597_4(X1,X2,X3,X4)
    | esk14630_4(X1,X2,X3,X4) ) ).

cnf(i_0_5,axiom,
    ( ~ esk12505_4(X1,X2,X3,X4)
    | ~ esk12504_4(X1,X2,X3,X4)
    | esk12506_4(X1,X2,X3,X4) ) ).

cnf(i_0_6,axiom,
    ( ~ esk12791_4(X1,X2,X3,X4)
    | ~ esk12843_4(X1,X2,X3,X4)
    | ~ esk12810_4(X1,X2,X3,X4) ) ).

cnf(i_0_7,axiom,
    ( esk8902_4(X1,X2,X3,X4)
    | ~ esk8904_4(X1,X2,X3,X4) ) ).

cnf(i_0_8,axiom,
    ( esk13769_4(X1,X2,X3,X4)
    | ~ esk13761_4(X1,X2,X3,X4) ) ).

cnf(i_0_9,axiom,
    ( ~ esk13128_4(X1,X2,X3,X4)
    | ~ esk13121_4(X1,X2,X3,X4)
    | ~ esk12975_4(X1,X2,X3,X4) ) ).

cnf(i_0_10,axiom,
    ( esk15597_4(X1,X2,X3,X4)
    | ~ esk15593_4(X1,X2,X3,X4)
    | esk15573_4(X1,X2,X3,X4) ) ).

cnf(i_0_11,axiom,
    ( ~ esk2233_4(X1,X2,X3,X4)
    | ~ esk2232_4(X1,X2,X3,X4) ) ).

cnf(i_0_12,axiom,
    ( esk15196_4(X1,X2,X3,X4)
    | ~ esk15203_4(X1,X2,X3,X4)
    | esk15152_4(X1,X2,X3,X4) ) ).

cnf(i_0_13,axiom,
    ( ~ esk546_4(X1,X2,X3,X4)
    | ~ esk537_4(X1,X2,X3,X4) ) ).

cnf(i_0_14,axiom,
    ( esk14623_4(X1,X2,X3,X4)
    | esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_15,axiom,
    ( esk12898_4(X1,X2,X3,X4)
    | esk12811_4(X1,X2,X3,X4) ) ).

cnf(i_0_16,axiom,
    ( esk15711_4(X1,X2,X3,X4)
    | esk15743_4(X1,X2,X3,X4) ) ).

cnf(i_0_17,axiom,
    ( ~ esk13821_4(X1,X2,X3,X4)
    | ~ esk13922_4(X1,X2,X3,X4)
    | ~ esk13837_4(X1,X2,X3,X4) ) ).

cnf(i_0_18,axiom,
    ( esk4338_4(X1,X2,X3,X4)
    | esk4297_4(X1,X2,X3,X4) ) ).

cnf(i_0_19,axiom,
    ( ~ esk9664_4(X1,X2,X3,X4)
    | esk9678_4(X1,X2,X3,X4) ) ).

cnf(i_0_20,axiom,
    ( ~ esk7898_4(X1,X2,X3,X4)
    | ~ esk7929_4(X1,X2,X3,X4)
    | ~ esk7930_4(X1,X2,X3,X4) ) ).

cnf(i_0_21,axiom,
    ( ~ esk15306_4(X1,X2,X3,X4)
    | esk15427_4(X1,X2,X3,X4) ) ).

cnf(i_0_22,axiom,
    ( esk3732_4(X1,X2,X3,X4)
    | ~ esk3746_4(X1,X2,X3,X4)
    | ~ esk3856_4(X1,X2,X3,X4) ) ).

cnf(i_0_23,axiom,
    ( esk11298_4(X1,X2,X3,X4)
    | ~ esk11241_4(X1,X2,X3,X4) ) ).

cnf(i_0_24,axiom,
    ( ~ esk1403_4(X1,X2,X3,X4)
    | esk1465_4(X1,X2,X3,X4) ) ).

cnf(i_0_25,axiom,
    ( esk6396_4(X1,X2,X3,X4)
    | esk6352_4(X1,X2,X3,X4) ) ).

cnf(i_0_26,axiom,
    ( ~ esk1129_4(X1,X2,X3,X4)
    | esk1164_4(X1,X2,X3,X4) ) ).

cnf(i_0_27,axiom,
    ( esk16709_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X1)
    | ~ esk285_0
    | p(X3)
    | p(X4) ) ).

cnf(i_0_28,axiom,
    ( ~ esk10411_4(X1,X2,X3,X4)
    | esk10386_4(X1,X2,X3,X4) ) ).

cnf(i_0_29,axiom,
    ( esk12566_4(X1,X2,X3,X4)
    | esk12519_4(X1,X2,X3,X4) ) ).

cnf(i_0_30,axiom,
    ( esk16629_4(X1,X2,X3,X4)
    | esk16718_4(X1,X2,X3,X4) ) ).

cnf(i_0_31,axiom,
    ( ~ esk3526_4(X1,X2,X3,X4)
    | ~ esk3566_4(X1,X2,X3,X4)
    | ~ esk3567_4(X1,X2,X3,X4) ) ).

cnf(i_0_32,axiom,
    ( esk12524_4(X1,X2,X3,X4)
    | esk12556_4(X1,X2,X3,X4) ) ).

cnf(i_0_33,axiom,
    ( esk15103_4(X1,X2,X3,X4)
    | esk15107_4(X1,X2,X3,X4) ) ).

cnf(i_0_34,axiom,
    ( esk1434_4(X1,X2,X3,X4)
    | esk1381_4(X1,X2,X3,X4) ) ).

cnf(i_0_35,axiom,
    ( esk8681_4(X1,X2,X3,X4)
    | esk8699_4(X1,X2,X3,X4) ) ).

cnf(i_0_36,axiom,
    ( esk2089_4(X1,X2,X3,X4)
    | esk2088_4(X1,X2,X3,X4)
    | esk2087_4(X1,X2,X3,X4)
    | esk2128_4(X1,X2,X3,X4) ) ).

cnf(i_0_37,axiom,
    ( esk13593_4(X1,X2,X3,X4)
    | esk13626_4(X1,X2,X3,X4) ) ).

cnf(i_0_38,axiom,
    ( ~ esk11340_4(X1,X2,X3,X4)
    | ~ esk11301_4(X1,X2,X3,X4) ) ).

cnf(i_0_39,axiom,
    ( ~ esk1850_4(X1,X2,X3,X4)
    | ~ esk1872_4(X1,X2,X3,X4) ) ).

cnf(i_0_40,axiom,
    ( esk10450_4(X1,X2,X3,X4)
    | ~ esk10449_4(X1,X2,X3,X4)
    | ~ esk10448_4(X1,X2,X3,X4) ) ).

cnf(i_0_41,axiom,
    ( ~ p(X4)
    | p(X2)
    | p(X1)
    | ~ p(X3)
    | esk16605_4(X1,X2,X3,X4)
    | ~ esk36_0 ) ).

cnf(i_0_42,axiom,
    ( esk7481_4(X1,X2,X3,X4)
    | esk7483_4(X1,X2,X3,X4)
    | esk7482_4(X1,X2,X3,X4) ) ).

cnf(i_0_43,axiom,
    ( ~ esk1873_4(X1,X2,X3,X4)
    | ~ esk1863_4(X1,X2,X3,X4) ) ).

cnf(i_0_44,axiom,
    ( esk6402_4(X1,X2,X3,X4)
    | ~ esk6305_4(X1,X2,X3,X4) ) ).

cnf(i_0_45,axiom,
    ( esk6385_4(X1,X2,X3,X4)
    | esk6357_4(X1,X2,X3,X4) ) ).

cnf(i_0_46,axiom,
    ( ~ esk6711_4(X1,X2,X3,X4)
    | ~ esk6681_4(X1,X2,X3,X4)
    | ~ esk6709_4(X1,X2,X3,X4)
    | ~ esk6683_4(X1,X2,X3,X4) ) ).

cnf(i_0_47,axiom,
    ( ~ esk10600_4(X1,X2,X3,X4)
    | ~ esk10480_4(X1,X2,X3,X4)
    | ~ esk10486_4(X1,X2,X3,X4) ) ).

cnf(i_0_48,axiom,
    ( ~ esk2856_4(X1,X2,X3,X4)
    | ~ esk2877_4(X1,X2,X3,X4)
    | ~ esk2855_4(X1,X2,X3,X4) ) ).

cnf(i_0_49,axiom,
    ( ~ esk2333_4(X1,X2,X3,X4)
    | ~ esk2234_4(X1,X2,X3,X4) ) ).

cnf(i_0_50,axiom,
    ( ~ esk513_4(X1,X2,X3,X4)
    | ~ esk455_4(X1,X2,X3,X4)
    | ~ esk480_4(X1,X2,X3,X4) ) ).

cnf(i_0_51,axiom,
    ( ~ esk15125_4(X1,X2,X3,X4)
    | ~ esk15126_4(X1,X2,X3,X4)
    | ~ esk15094_4(X1,X2,X3,X4) ) ).

cnf(i_0_52,axiom,
    ( ~ esk904_4(X1,X2,X3,X4)
    | esk1027_4(X1,X2,X3,X4) ) ).

cnf(i_0_53,axiom,
    ( esk6463_4(X1,X2,X3,X4)
    | esk6488_4(X1,X2,X3,X4)
    | ~ esk6462_4(X1,X2,X3,X4) ) ).

cnf(i_0_54,axiom,
    ( esk15954_4(X1,X2,X3,X4)
    | esk15955_4(X1,X2,X3,X4) ) ).

cnf(i_0_55,axiom,
    ( ~ esk4421_4(X1,X2,X3,X4)
    | ~ esk4370_4(X1,X2,X3,X4)
    | ~ esk4396_4(X1,X2,X3,X4) ) ).

cnf(i_0_56,axiom,
    ( esk11490_4(X1,X2,X3,X4)
    | esk11540_4(X1,X2,X3,X4) ) ).

cnf(i_0_57,axiom,
    ( ~ esk1783_4(X1,X2,X3,X4)
    | esk2041_4(X1,X2,X3,X4) ) ).

cnf(i_0_58,axiom,
    ( ~ esk3384_4(X1,X2,X3,X4)
    | esk3413_4(X1,X2,X3,X4)
    | esk3364_4(X1,X2,X3,X4) ) ).

cnf(i_0_59,axiom,
    ( esk3572_4(X1,X2,X3,X4)
    | esk3523_4(X1,X2,X3,X4) ) ).

cnf(i_0_60,axiom,
    ( esk6200_4(X1,X2,X3,X4)
    | ~ esk6214_4(X1,X2,X3,X4)
    | esk6213_4(X1,X2,X3,X4) ) ).

cnf(i_0_61,axiom,
    ( ~ esk6310_4(X1,X2,X3,X4)
    | esk6316_4(X1,X2,X3,X4) ) ).

cnf(i_0_62,axiom,
    ( esk11567_4(X1,X2,X3,X4)
    | ~ esk11492_4(X1,X2,X3,X4) ) ).

cnf(i_0_63,axiom,
    ( esk4527_4(X1,X2,X3,X4)
    | esk4528_4(X1,X2,X3,X4) ) ).

cnf(i_0_64,axiom,
    ( esk5400_4(X1,X2,X3,X4)
    | ~ esk5142_4(X1,X2,X3,X4) ) ).

cnf(i_0_65,axiom,
    ( ~ esk15937_4(X1,X2,X3,X4)
    | esk15989_4(X1,X2,X3,X4) ) ).

cnf(i_0_66,axiom,
    ( esk2714_4(X1,X2,X3,X4)
    | esk2768_4(X1,X2,X3,X4)
    | esk2748_4(X1,X2,X3,X4) ) ).

cnf(i_0_67,axiom,
    ( esk801_4(X1,X2,X3,X4)
    | esk800_4(X1,X2,X3,X4)
    | esk799_4(X1,X2,X3,X4) ) ).

cnf(i_0_68,axiom,
    ( esk14383_4(X1,X2,X3,X4)
    | ~ esk14125_4(X1,X2,X3,X4) ) ).

cnf(i_0_69,axiom,
    ( esk7495_4(X1,X2,X3,X4)
    | ~ esk7494_4(X1,X2,X3,X4) ) ).

cnf(i_0_70,axiom,
    ( ~ esk13514_4(X1,X2,X3,X4)
    | ~ esk13487_4(X1,X2,X3,X4) ) ).

cnf(i_0_71,axiom,
    ( esk6656_4(X1,X2,X3,X4)
    | esk6607_4(X1,X2,X3,X4) ) ).

cnf(i_0_72,axiom,
    ( esk15063_4(X1,X2,X3,X4)
    | ~ esk15321_4(X1,X2,X3,X4) ) ).

cnf(i_0_73,axiom,
    ( ~ esk7357_4(X1,X2,X3,X4)
    | esk7361_4(X1,X2,X3,X4) ) ).

cnf(i_0_74,axiom,
    ( esk1008_4(X1,X2,X3,X4)
    | ~ esk966_4(X1,X2,X3,X4) ) ).

cnf(i_0_75,axiom,
    ( esk7104_4(X1,X2,X3,X4)
    | ~ esk7098_4(X1,X2,X3,X4) ) ).

cnf(i_0_76,axiom,
    ( esk16072_4(X1,X2,X3,X4)
    | ~ esk16048_4(X1,X2,X3,X4) ) ).

cnf(i_0_77,axiom,
    ( p(X2)
    | ~ p(X1)
    | p(X4)
    | p(X3)
    | ~ esk266_0
    | esk16707_4(X1,X2,X3,X4) ) ).

cnf(i_0_78,axiom,
    ( ~ esk181_0
    | ~ p(X1)
    | esk505_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X2)
    | p(X4) ) ).

cnf(i_0_79,axiom,
    ( esk12341_4(X1,X2,X3,X4)
    | esk12308_4(X1,X2,X3,X4) ) ).

cnf(i_0_80,axiom,
    ( esk3105_4(X1,X2,X3,X4)
    | esk3098_4(X1,X2,X3,X4) ) ).

cnf(i_0_81,axiom,
    ( ~ esk13504_4(X1,X2,X3,X4)
    | esk13604_4(X1,X2,X3,X4) ) ).

cnf(i_0_82,axiom,
    ( esk1078_4(X1,X2,X3,X4)
    | ~ esk1057_4(X1,X2,X3,X4)
    | esk1056_4(X1,X2,X3,X4) ) ).

cnf(i_0_83,axiom,
    ( ~ esk6191_4(X1,X2,X3,X4)
    | ~ esk6199_4(X1,X2,X3,X4) ) ).

cnf(i_0_84,axiom,
    ( esk3468_4(X1,X2,X3,X4)
    | ~ esk3520_4(X1,X2,X3,X4) ) ).

cnf(i_0_85,axiom,
    ( esk16401_4(X1,X2,X3,X4)
    | esk16384_4(X1,X2,X3,X4) ) ).

cnf(i_0_86,axiom,
    ( esk9715_4(X1,X2,X3,X4)
    | esk9709_4(X1,X2,X3,X4) ) ).

cnf(i_0_87,axiom,
    ( esk5651_4(X1,X2,X3,X4)
    | ~ esk5529_4(X1,X2,X3,X4) ) ).

cnf(i_0_88,axiom,
    ( esk10050_4(X1,X2,X3,X4)
    | ~ esk10024_4(X1,X2,X3,X4)
    | esk10075_4(X1,X2,X3,X4) ) ).

cnf(i_0_89,axiom,
    ( ~ esk2456_4(X1,X2,X3,X4)
    | esk2577_4(X1,X2,X3,X4) ) ).

cnf(i_0_90,axiom,
    ( ~ esk1518_4(X1,X2,X3,X4)
    | esk1482_4(X1,X2,X3,X4) ) ).

cnf(i_0_91,axiom,
    ( esk5889_4(X1,X2,X3,X4)
    | ~ esk6147_4(X1,X2,X3,X4) ) ).

cnf(i_0_92,axiom,
    ( esk12856_4(X1,X2,X3,X4)
    | ~ esk12775_4(X1,X2,X3,X4) ) ).

cnf(i_0_93,axiom,
    ( ~ esk1578_4(X1,X2,X3,X4)
    | ~ esk1527_4(X1,X2,X3,X4)
    | ~ esk1607_4(X1,X2,X3,X4) ) ).

cnf(i_0_94,axiom,
    ( ~ esk14676_4(X1,X2,X3,X4)
    | ~ esk14675_4(X1,X2,X3,X4) ) ).

cnf(i_0_95,axiom,
    ( esk4517_4(X1,X2,X3,X4)
    | ~ esk4502_4(X1,X2,X3,X4) ) ).

cnf(i_0_96,axiom,
    ( esk5036_4(X1,X2,X3,X4)
    | ~ esk4778_4(X1,X2,X3,X4) ) ).

cnf(i_0_97,axiom,
    ( esk10737_4(X1,X2,X3,X4)
    | esk10767_4(X1,X2,X3,X4) ) ).

cnf(i_0_98,axiom,
    ( esk1444_4(X1,X2,X3,X4)
    | esk1447_4(X1,X2,X3,X4)
    | esk1441_4(X1,X2,X3,X4)
    | esk1445_4(X1,X2,X3,X4) ) ).

cnf(i_0_99,axiom,
    ( ~ esk8760_4(X1,X2,X3,X4)
    | ~ esk8745_4(X1,X2,X3,X4) ) ).

cnf(i_0_100,axiom,
    ( ~ esk8009_4(X1,X2,X3,X4)
    | esk8008_4(X1,X2,X3,X4)
    | esk7958_4(X1,X2,X3,X4) ) ).

cnf(i_0_101,axiom,
    ( ~ esk14182_4(X1,X2,X3,X4)
    | ~ esk14181_4(X1,X2,X3,X4)
    | esk14183_4(X1,X2,X3,X4) ) ).

cnf(i_0_102,axiom,
    ( ~ esk2975_4(X1,X2,X3,X4)
    | esk2957_4(X1,X2,X3,X4)
    | ~ esk3077_4(X1,X2,X3,X4) ) ).

cnf(i_0_103,axiom,
    ( ~ esk9712_4(X1,X2,X3,X4)
    | ~ esk9705_4(X1,X2,X3,X4)
    | ~ esk9713_4(X1,X2,X3,X4) ) ).

cnf(i_0_104,axiom,
    ( esk10505_4(X1,X2,X3,X4)
    | esk10478_4(X1,X2,X3,X4) ) ).

cnf(i_0_105,axiom,
    ( ~ esk5104_4(X1,X2,X3,X4)
    | ~ esk5081_4(X1,X2,X3,X4)
    | ~ esk5137_4(X1,X2,X3,X4) ) ).

cnf(i_0_106,axiom,
    ( ~ esk12391_4(X1,X2,X3,X4)
    | ~ esk12390_4(X1,X2,X3,X4)
    | esk12392_4(X1,X2,X3,X4) ) ).

cnf(i_0_107,axiom,
    ( esk15859_4(X1,X2,X3,X4)
    | esk15909_4(X1,X2,X3,X4) ) ).

cnf(i_0_108,axiom,
    ( ~ esk2204_4(X1,X2,X3,X4)
    | esk2196_4(X1,X2,X3,X4)
    | ~ esk2296_4(X1,X2,X3,X4) ) ).

cnf(i_0_109,axiom,
    ( esk12592_4(X1,X2,X3,X4)
    | esk12622_4(X1,X2,X3,X4) ) ).

cnf(i_0_110,axiom,
    ( esk8485_4(X1,X2,X3,X4)
    | ~ esk8743_4(X1,X2,X3,X4) ) ).

cnf(i_0_111,axiom,
    ( ~ esk15330_4(X1,X2,X3,X4)
    | esk15331_4(X1,X2,X3,X4) ) ).

cnf(i_0_112,axiom,
    ( ~ esk16679_4(X1,X2,X3,X4)
    | ~ esk16712_4(X1,X2,X3,X4)
    | ~ esk16646_4(X1,X2,X3,X4) ) ).

cnf(i_0_113,axiom,
    ( p(X3)
    | esk82_0
    | ~ p(X2)
    | p(X1)
    | ~ esk493_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_114,axiom,
    ( esk9976_4(X1,X2,X3,X4)
    | esk10088_4(X1,X2,X3,X4) ) ).

cnf(i_0_115,axiom,
    ( ~ esk2187_4(X1,X2,X3,X4)
    | esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_116,axiom,
    ( esk16148_4(X1,X2,X3,X4)
    | esk16231_4(X1,X2,X3,X4) ) ).

cnf(i_0_117,axiom,
    ( esk1961_4(X1,X2,X3,X4)
    | esk1955_4(X1,X2,X3,X4)
    | esk1959_4(X1,X2,X3,X4)
    | esk1958_4(X1,X2,X3,X4) ) ).

cnf(i_0_118,axiom,
    ( esk7727_4(X1,X2,X3,X4)
    | ~ esk7570_4(X1,X2,X3,X4) ) ).

cnf(i_0_119,axiom,
    ( esk5145_4(X1,X2,X3,X4)
    | ~ esk5019_4(X1,X2,X3,X4) ) ).

cnf(i_0_120,axiom,
    ( ~ esk6155_4(X1,X2,X3,X4)
    | esk5897_4(X1,X2,X3,X4) ) ).

cnf(i_0_121,axiom,
    ( ~ esk6842_4(X1,X2,X3,X4)
    | ~ esk6838_4(X1,X2,X3,X4) ) ).

cnf(i_0_122,axiom,
    ( esk8515_4(X1,X2,X3,X4)
    | esk8547_4(X1,X2,X3,X4) ) ).

cnf(i_0_123,axiom,
    ( esk4183_4(X1,X2,X3,X4)
    | ~ esk4176_4(X1,X2,X3,X4)
    | esk4095_4(X1,X2,X3,X4) ) ).

cnf(i_0_124,axiom,
    ( esk2800_4(X1,X2,X3,X4)
    | esk2887_4(X1,X2,X3,X4) ) ).

cnf(i_0_125,axiom,
    ( esk16615_4(X1,X2,X3,X4)
    | esk16604_4(X1,X2,X3,X4)
    | ~ esk16616_4(X1,X2,X3,X4) ) ).

cnf(i_0_126,axiom,
    ( ~ esk16485_4(X1,X2,X3,X4)
    | ~ esk16429_4(X1,X2,X3,X4) ) ).

cnf(i_0_127,axiom,
    ( ~ esk11585_4(X1,X2,X3,X4)
    | ~ esk11486_4(X1,X2,X3,X4) ) ).

cnf(i_0_128,axiom,
    ( esk7701_4(X1,X2,X3,X4)
    | ~ esk7582_4(X1,X2,X3,X4) ) ).

cnf(i_0_129,axiom,
    ( ~ esk4162_4(X1,X2,X3,X4)
    | esk4141_4(X1,X2,X3,X4)
    | esk4140_4(X1,X2,X3,X4) ) ).

cnf(i_0_130,axiom,
    ( ~ esk5128_4(X1,X2,X3,X4)
    | esk5074_4(X1,X2,X3,X4) ) ).

cnf(i_0_131,axiom,
    ( esk7409_4(X1,X2,X3,X4)
    | esk7394_4(X1,X2,X3,X4) ) ).

cnf(i_0_132,axiom,
    ( ~ esk16468_4(X1,X2,X3,X4)
    | ~ esk16370_4(X1,X2,X3,X4)
    | ~ esk16461_4(X1,X2,X3,X4) ) ).

cnf(i_0_133,axiom,
    ( ~ esk15901_4(X1,X2,X3,X4)
    | ~ esk15877_4(X1,X2,X3,X4)
    | ~ esk16007_4(X1,X2,X3,X4) ) ).

cnf(i_0_134,axiom,
    ( esk2820_4(X1,X2,X3,X4)
    | ~ esk2874_4(X1,X2,X3,X4)
    | esk2858_4(X1,X2,X3,X4) ) ).

cnf(i_0_135,axiom,
    ( esk16113_4(X1,X2,X3,X4)
    | ~ esk16061_4(X1,X2,X3,X4) ) ).

cnf(i_0_136,axiom,
    ( ~ esk6675_4(X1,X2,X3,X4)
    | ~ esk6573_4(X1,X2,X3,X4)
    | esk6555_4(X1,X2,X3,X4) ) ).

cnf(i_0_137,axiom,
    ( esk14370_4(X1,X2,X3,X4)
    | ~ esk14628_4(X1,X2,X3,X4) ) ).

cnf(i_0_138,axiom,
    ( esk11339_4(X1,X2,X3,X4)
    | esk11338_4(X1,X2,X3,X4) ) ).

cnf(i_0_139,axiom,
    ( esk1228_4(X1,X2,X3,X4)
    | esk1244_4(X1,X2,X3,X4) ) ).

cnf(i_0_140,axiom,
    ( esk11721_4(X1,X2,X3,X4)
    | esk11727_4(X1,X2,X3,X4)
    | esk11726_4(X1,X2,X3,X4) ) ).

cnf(i_0_141,axiom,
    ( esk2025_4(X1,X2,X3,X4)
    | esk2108_4(X1,X2,X3,X4) ) ).

cnf(i_0_142,axiom,
    ( ~ esk5030_4(X1,X2,X3,X4)
    | ~ esk5148_4(X1,X2,X3,X4) ) ).

cnf(i_0_143,axiom,
    ( esk2861_4(X1,X2,X3,X4)
    | esk2860_4(X1,X2,X3,X4) ) ).

cnf(i_0_144,axiom,
    ( ~ esk10223_4(X1,X2,X3,X4)
    | ~ esk10332_4(X1,X2,X3,X4)
    | ~ esk10249_4(X1,X2,X3,X4) ) ).

cnf(i_0_145,axiom,
    ( esk7617_4(X1,X2,X3,X4)
    | ~ esk7619_4(X1,X2,X3,X4) ) ).

cnf(i_0_146,axiom,
    ( esk6635_4(X1,X2,X3,X4)
    | esk6747_4(X1,X2,X3,X4) ) ).

cnf(i_0_147,axiom,
    ( esk13047_4(X1,X2,X3,X4)
    | esk13051_4(X1,X2,X3,X4) ) ).

cnf(i_0_148,axiom,
    ( p(X1)
    | ~ p(X3)
    | ~ p(X2)
    | ~ esk278_0
    | p(X4)
    | esk519_4(X1,X2,X3,X4) ) ).

cnf(i_0_149,axiom,
    ( esk16168_4(X1,X2,X3,X4)
    | esk16135_4(X1,X2,X3,X4) ) ).

cnf(i_0_150,axiom,
    ( ~ esk8006_4(X1,X2,X3,X4)
    | ~ esk8005_4(X1,X2,X3,X4) ) ).

cnf(i_0_151,axiom,
    ( esk1995_4(X1,X2,X3,X4)
    | ~ esk2034_4(X1,X2,X3,X4) ) ).

cnf(i_0_152,axiom,
    ( esk1504_4(X1,X2,X3,X4)
    | esk1473_4(X1,X2,X3,X4) ) ).

cnf(i_0_153,axiom,
    ( ~ esk1574_4(X1,X2,X3,X4)
    | esk1588_4(X1,X2,X3,X4) ) ).

cnf(i_0_154,axiom,
    ( ~ esk2532_4(X1,X2,X3,X4)
    | ~ esk2501_4(X1,X2,X3,X4)
    | ~ esk2533_4(X1,X2,X3,X4) ) ).

cnf(i_0_155,axiom,
    ( ~ esk6091_4(X1,X2,X3,X4)
    | esk6029_4(X1,X2,X3,X4) ) ).

cnf(i_0_156,axiom,
    ( esk15168_4(X1,X2,X3,X4)
    | esk15135_4(X1,X2,X3,X4) ) ).

cnf(i_0_157,axiom,
    ( ~ esk2191_4(X1,X2,X3,X4)
    | esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_158,axiom,
    ( ~ esk13770_4(X1,X2,X3,X4)
    | ~ esk13772_4(X1,X2,X3,X4) ) ).

cnf(i_0_159,axiom,
    ( esk2638_4(X1,X2,X3,X4)
    | ~ esk2639_4(X1,X2,X3,X4) ) ).

cnf(i_0_160,axiom,
    ( esk9526_4(X1,X2,X3,X4)
    | ~ esk9399_4(X1,X2,X3,X4) ) ).

cnf(i_0_161,axiom,
    ( esk47_0
    | ~ p(X4)
    | ~ p(X2)
    | ~ p(X1)
    | ~ esk415_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_162,axiom,
    ( ~ esk669_4(X1,X2,X3,X4)
    | esk411_4(X1,X2,X3,X4) ) ).

cnf(i_0_163,axiom,
    ( esk16477_4(X1,X2,X3,X4)
    | esk16498_4(X1,X2,X3,X4)
    | ~ esk16476_4(X1,X2,X3,X4) ) ).

cnf(i_0_164,axiom,
    ( ~ esk4103_4(X1,X2,X3,X4)
    | ~ esk4184_4(X1,X2,X3,X4) ) ).

cnf(i_0_165,axiom,
    ( esk6415_4(X1,X2,X3,X4)
    | ~ esk6673_4(X1,X2,X3,X4) ) ).

cnf(i_0_166,axiom,
    ( ~ esk5554_4(X1,X2,X3,X4)
    | esk5563_4(X1,X2,X3,X4) ) ).

cnf(i_0_167,axiom,
    ( ~ esk14274_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4) ) ).

cnf(i_0_168,axiom,
    ( ~ esk4525_4(X1,X2,X3,X4)
    | ~ esk4524_4(X1,X2,X3,X4) ) ).

cnf(i_0_169,axiom,
    ( esk442_4(X1,X2,X3,X4)
    | ~ esk514_4(X1,X2,X3,X4) ) ).

cnf(i_0_170,axiom,
    ( ~ esk2222_4(X1,X2,X3,X4)
    | esk2221_4(X1,X2,X3,X4) ) ).

cnf(i_0_171,axiom,
    ( esk3556_4(X1,X2,X3,X4)
    | esk3539_4(X1,X2,X3,X4) ) ).

cnf(i_0_172,axiom,
    ( esk11753_4(X1,X2,X3,X4)
    | esk11785_4(X1,X2,X3,X4) ) ).

cnf(i_0_173,axiom,
    ( esk7332_4(X1,X2,X3,X4)
    | ~ esk7297_4(X1,X2,X3,X4) ) ).

cnf(i_0_174,axiom,
    ( ~ esk14198_4(X1,X2,X3,X4)
    | esk14172_4(X1,X2,X3,X4)
    | esk14173_4(X1,X2,X3,X4) ) ).

cnf(i_0_175,axiom,
    ( ~ esk1164_4(X1,X2,X3,X4)
    | esk1290_4(X1,X2,X3,X4) ) ).

cnf(i_0_176,axiom,
    ( esk8160_4(X1,X2,X3,X4)
    | esk8177_4(X1,X2,X3,X4) ) ).

cnf(i_0_177,axiom,
    ( esk1426_4(X1,X2,X3,X4)
    | ~ esk1396_4(X1,X2,X3,X4) ) ).

cnf(i_0_178,axiom,
    ( esk14402_4(X1,X2,X3,X4)
    | ~ esk14282_4(X1,X2,X3,X4) ) ).

cnf(i_0_179,axiom,
    ( ~ esk3485_4(X1,X2,X3,X4)
    | ~ esk3540_4(X1,X2,X3,X4) ) ).

cnf(i_0_180,axiom,
    ( esk15687_4(X1,X2,X3,X4)
    | ~ esk15688_4(X1,X2,X3,X4) ) ).

cnf(i_0_181,axiom,
    ( esk5633_4(X1,X2,X3,X4)
    | ~ esk5375_4(X1,X2,X3,X4) ) ).

cnf(i_0_182,axiom,
    ( ~ esk10437_4(X1,X2,X3,X4)
    | esk10446_4(X1,X2,X3,X4) ) ).

cnf(i_0_183,axiom,
    ( esk8422_4(X1,X2,X3,X4)
    | esk8439_4(X1,X2,X3,X4) ) ).

cnf(i_0_184,axiom,
    ( ~ esk7723_4(X1,X2,X3,X4)
    | esk7719_4(X1,X2,X3,X4) ) ).

cnf(i_0_185,axiom,
    ( p(X3)
    | p(X1)
    | p(X4)
    | p(X2)
    | ~ esk16701_4(X1,X2,X3,X4)
    | esk213_0 ) ).

cnf(i_0_186,axiom,
    ( esk8911_4(X1,X2,X3,X4)
    | ~ esk8915_4(X1,X2,X3,X4) ) ).

cnf(i_0_187,axiom,
    ( ~ esk7410_4(X1,X2,X3,X4)
    | ~ esk7387_4(X1,X2,X3,X4)
    | ~ esk7409_4(X1,X2,X3,X4) ) ).

cnf(i_0_188,axiom,
    ( ~ esk13127_4(X1,X2,X3,X4)
    | esk12869_4(X1,X2,X3,X4) ) ).

cnf(i_0_189,axiom,
    ( esk13517_4(X1,X2,X3,X4)
    | ~ esk13259_4(X1,X2,X3,X4) ) ).

cnf(i_0_190,axiom,
    ( esk9876_4(X1,X2,X3,X4)
    | ~ esk9908_4(X1,X2,X3,X4) ) ).

cnf(i_0_191,axiom,
    ( ~ esk9312_4(X1,X2,X3,X4)
    | esk9310_4(X1,X2,X3,X4) ) ).

cnf(i_0_192,axiom,
    ( ~ esk4260_4(X1,X2,X3,X4)
    | ~ esk4372_4(X1,X2,X3,X4)
    | esk4247_4(X1,X2,X3,X4) ) ).

cnf(i_0_193,axiom,
    ( esk8466_4(X1,X2,X3,X4)
    | ~ esk8517_4(X1,X2,X3,X4)
    | esk8546_4(X1,X2,X3,X4) ) ).

cnf(i_0_194,axiom,
    ( ~ esk14142_4(X1,X2,X3,X4)
    | ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14109_4(X1,X2,X3,X4) ) ).

cnf(i_0_195,axiom,
    ( ~ esk8205_4(X1,X2,X3,X4)
    | ~ esk8261_4(X1,X2,X3,X4) ) ).

cnf(i_0_196,axiom,
    ( esk11562_4(X1,X2,X3,X4)
    | esk11529_4(X1,X2,X3,X4) ) ).

cnf(i_0_197,axiom,
    ( esk9579_4(X1,X2,X3,X4)
    | esk9536_4(X1,X2,X3,X4) ) ).

cnf(i_0_198,axiom,
    ( ~ esk10955_4(X1,X2,X3,X4)
    | ~ esk10956_4(X1,X2,X3,X4) ) ).

cnf(i_0_199,axiom,
    ( ~ esk10429_4(X1,X2,X3,X4)
    | ~ esk10431_4(X1,X2,X3,X4) ) ).

cnf(i_0_200,axiom,
    ( esk11368_4(X1,X2,X3,X4)
    | esk11281_4(X1,X2,X3,X4) ) ).

cnf(i_0_201,axiom,
    ( ~ esk4618_4(X1,X2,X3,X4)
    | esk4876_4(X1,X2,X3,X4) ) ).

cnf(i_0_202,axiom,
    ( esk1276_4(X1,X2,X3,X4)
    | esk1326_4(X1,X2,X3,X4)
    | ~ esk1327_4(X1,X2,X3,X4) ) ).

cnf(i_0_203,axiom,
    ( esk16147_4(X1,X2,X3,X4)
    | esk16180_4(X1,X2,X3,X4) ) ).

cnf(i_0_204,axiom,
    ( ~ esk4531_4(X1,X2,X3,X4)
    | ~ esk4536_4(X1,X2,X3,X4) ) ).

cnf(i_0_205,axiom,
    ( ~ esk5172_4(X1,X2,X3,X4)
    | esk5186_4(X1,X2,X3,X4) ) ).

cnf(i_0_206,axiom,
    ( esk15908_4(X1,X2,X3,X4)
    | esk15859_4(X1,X2,X3,X4) ) ).

cnf(i_0_207,axiom,
    ( ~ esk11072_4(X1,X2,X3,X4)
    | ~ esk11071_4(X1,X2,X3,X4) ) ).

cnf(i_0_208,axiom,
    ( esk7158_4(X1,X2,X3,X4)
    | esk7127_4(X1,X2,X3,X4) ) ).

cnf(i_0_209,axiom,
    ( ~ esk2074_4(X1,X2,X3,X4)
    | esk2075_4(X1,X2,X3,X4) ) ).

cnf(i_0_210,axiom,
    ( ~ esk9195_4(X1,X2,X3,X4)
    | ~ esk9317_4(X1,X2,X3,X4)
    | ~ esk9205_4(X1,X2,X3,X4) ) ).

cnf(i_0_211,axiom,
    ( esk4684_4(X1,X2,X3,X4)
    | ~ esk4683_4(X1,X2,X3,X4) ) ).

cnf(i_0_212,axiom,
    ( ~ esk517_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X2)
    | p(X4)
    | p(X3)
    | esk261_0 ) ).

cnf(i_0_213,axiom,
    ( esk14962_4(X1,X2,X3,X4)
    | ~ esk14961_4(X1,X2,X3,X4)
    | ~ esk14960_4(X1,X2,X3,X4) ) ).

cnf(i_0_214,axiom,
    ( ~ esk5291_4(X1,X2,X3,X4)
    | ~ esk5289_4(X1,X2,X3,X4) ) ).

cnf(i_0_215,axiom,
    ( esk3083_4(X1,X2,X3,X4)
    | ~ esk2825_4(X1,X2,X3,X4) ) ).

cnf(i_0_216,axiom,
    ( esk7864_4(X1,X2,X3,X4)
    | ~ esk8122_4(X1,X2,X3,X4) ) ).

cnf(i_0_217,axiom,
    ( ~ esk555_4(X1,X2,X3,X4)
    | ~ esk537_4(X1,X2,X3,X4) ) ).

cnf(i_0_218,axiom,
    ( ~ esk4310_4(X1,X2,X3,X4)
    | ~ esk4290_4(X1,X2,X3,X4) ) ).

cnf(i_0_219,axiom,
    ( ~ esk10223_4(X1,X2,X3,X4)
    | ~ esk10222_4(X1,X2,X3,X4) ) ).

cnf(i_0_220,axiom,
    ( esk5896_4(X1,X2,X3,X4)
    | ~ esk5638_4(X1,X2,X3,X4) ) ).

cnf(i_0_221,axiom,
    ( esk5689_4(X1,X2,X3,X4)
    | esk5688_4(X1,X2,X3,X4)
    | esk5690_4(X1,X2,X3,X4) ) ).

cnf(i_0_222,axiom,
    ( ~ esk4004_4(X1,X2,X3,X4)
    | ~ esk4002_4(X1,X2,X3,X4) ) ).

cnf(i_0_223,axiom,
    ( esk5210_4(X1,X2,X3,X4)
    | esk5139_4(X1,X2,X3,X4)
    | ~ esk5191_4(X1,X2,X3,X4) ) ).

cnf(i_0_224,axiom,
    ( esk1519_4(X1,X2,X3,X4)
    | ~ esk1261_4(X1,X2,X3,X4) ) ).

cnf(i_0_225,axiom,
    ( ~ esk13682_4(X1,X2,X3,X4)
    | esk13598_4(X1,X2,X3,X4)
    | esk13645_4(X1,X2,X3,X4) ) ).

cnf(i_0_226,axiom,
    ( esk6193_4(X1,X2,X3,X4)
    | ~ esk6223_4(X1,X2,X3,X4)
    | esk6171_4(X1,X2,X3,X4) ) ).

cnf(i_0_227,axiom,
    ( ~ esk3025_4(X1,X2,X3,X4)
    | ~ esk3028_4(X1,X2,X3,X4)
    | ~ esk3061_4(X1,X2,X3,X4) ) ).

cnf(i_0_228,axiom,
    ( esk5916_4(X1,X2,X3,X4)
    | esk5933_4(X1,X2,X3,X4)
    | ~ esk5970_4(X1,X2,X3,X4) ) ).

cnf(i_0_229,axiom,
    ( ~ esk7563_4(X1,X2,X3,X4)
    | esk7595_4(X1,X2,X3,X4) ) ).

cnf(i_0_230,axiom,
    ( ~ esk12980_4(X1,X2,X3,X4)
    | esk12998_4(X1,X2,X3,X4) ) ).

cnf(i_0_231,axiom,
    ( esk6671_4(X1,X2,X3,X4)
    | ~ esk6553_4(X1,X2,X3,X4) ) ).

cnf(i_0_232,axiom,
    ( esk2571_4(X1,X2,X3,X4)
    | ~ esk2622_4(X1,X2,X3,X4)
    | esk2597_4(X1,X2,X3,X4) ) ).

cnf(i_0_233,axiom,
    ( esk1222_4(X1,X2,X3,X4)
    | esk1235_4(X1,X2,X3,X4) ) ).

cnf(i_0_234,axiom,
    ( ~ esk15902_4(X1,X2,X3,X4)
    | ~ esk15903_4(X1,X2,X3,X4)
    | ~ esk15862_4(X1,X2,X3,X4) ) ).

cnf(i_0_235,axiom,
    ( esk7989_4(X1,X2,X3,X4)
    | esk7974_4(X1,X2,X3,X4) ) ).

cnf(i_0_236,axiom,
    ( esk9546_4(X1,X2,X3,X4)
    | ~ esk9572_4(X1,X2,X3,X4)
    | esk9547_4(X1,X2,X3,X4) ) ).

cnf(i_0_237,axiom,
    ( ~ esk5301_4(X1,X2,X3,X4)
    | ~ esk5302_4(X1,X2,X3,X4) ) ).

cnf(i_0_238,axiom,
    ( esk12811_4(X1,X2,X3,X4)
    | esk12782_4(X1,X2,X3,X4) ) ).

cnf(i_0_239,axiom,
    ( ~ esk5131_4(X1,X2,X3,X4)
    | esk4873_4(X1,X2,X3,X4) ) ).

cnf(i_0_240,axiom,
    ( esk12005_4(X1,X2,X3,X4)
    | esk12052_4(X1,X2,X3,X4) ) ).

cnf(i_0_241,axiom,
    ( ~ esk9492_4(X1,X2,X3,X4)
    | ~ esk9450_4(X1,X2,X3,X4)
    | ~ esk9459_4(X1,X2,X3,X4) ) ).

cnf(i_0_242,axiom,
    ( ~ esk11505_4(X1,X2,X3,X4)
    | esk11541_4(X1,X2,X3,X4) ) ).

cnf(i_0_243,axiom,
    ( ~ esk1767_4(X1,X2,X3,X4)
    | ~ esk1800_4(X1,X2,X3,X4)
    | ~ esk1740_4(X1,X2,X3,X4) ) ).

cnf(i_0_244,axiom,
    ( ~ esk3108_4(X1,X2,X3,X4)
    | esk3123_4(X1,X2,X3,X4) ) ).

cnf(i_0_245,axiom,
    ( esk4699_4(X1,X2,X3,X4)
    | esk4677_4(X1,X2,X3,X4) ) ).

cnf(i_0_246,axiom,
    ( esk11459_4(X1,X2,X3,X4)
    | ~ esk11454_4(X1,X2,X3,X4) ) ).

cnf(i_0_247,axiom,
    ( esk15150_4(X1,X2,X3,X4)
    | esk15117_4(X1,X2,X3,X4) ) ).

cnf(i_0_248,axiom,
    ( esk11317_4(X1,X2,X3,X4)
    | ~ esk11316_4(X1,X2,X3,X4) ) ).

cnf(i_0_249,axiom,
    ( ~ esk6481_4(X1,X2,X3,X4)
    | esk6480_4(X1,X2,X3,X4) ) ).

cnf(i_0_250,axiom,
    ( esk4147_4(X1,X2,X3,X4)
    | ~ esk4179_4(X1,X2,X3,X4)
    | esk4178_4(X1,X2,X3,X4) ) ).

cnf(i_0_251,axiom,
    ( ~ esk6677_4(X1,X2,X3,X4)
    | esk6731_4(X1,X2,X3,X4)
    | esk6712_4(X1,X2,X3,X4) ) ).

cnf(i_0_252,axiom,
    ( ~ esk11315_4(X1,X2,X3,X4)
    | ~ esk11282_4(X1,X2,X3,X4)
    | ~ esk11249_4(X1,X2,X3,X4) ) ).

cnf(i_0_253,axiom,
    ( ~ esk10776_4(X1,X2,X3,X4)
    | esk11034_4(X1,X2,X3,X4) ) ).

cnf(i_0_254,axiom,
    ( esk9801_4(X1,X2,X3,X4)
    | esk9802_4(X1,X2,X3,X4)
    | esk9800_4(X1,X2,X3,X4) ) ).

cnf(i_0_255,axiom,
    ( esk3541_4(X1,X2,X3,X4)
    | esk3543_4(X1,X2,X3,X4) ) ).

cnf(i_0_256,axiom,
    ( esk9164_4(X1,X2,X3,X4)
    | ~ esk9150_4(X1,X2,X3,X4) ) ).

cnf(i_0_257,axiom,
    ( esk12862_4(X1,X2,X3,X4)
    | ~ esk13120_4(X1,X2,X3,X4) ) ).

cnf(i_0_258,axiom,
    ( ~ esk8581_4(X1,X2,X3,X4)
    | esk8624_4(X1,X2,X3,X4) ) ).

cnf(i_0_259,axiom,
    ( ~ esk10288_4(X1,X2,X3,X4)
    | ~ esk10170_4(X1,X2,X3,X4) ) ).

cnf(i_0_260,axiom,
    ( ~ esk919_4(X1,X2,X3,X4)
    | ~ esk1009_4(X1,X2,X3,X4)
    | esk910_4(X1,X2,X3,X4) ) ).

cnf(i_0_261,axiom,
    ( ~ esk1409_4(X1,X2,X3,X4)
    | ~ esk1432_4(X1,X2,X3,X4) ) ).

cnf(i_0_262,axiom,
    ( esk10480_4(X1,X2,X3,X4)
    | esk10479_4(X1,X2,X3,X4)
    | esk10458_4(X1,X2,X3,X4) ) ).

cnf(i_0_263,axiom,
    ( esk1737_4(X1,X2,X3,X4)
    | ~ esk1779_4(X1,X2,X3,X4) ) ).

cnf(i_0_264,axiom,
    ( esk10987_4(X1,X2,X3,X4)
    | esk11003_4(X1,X2,X3,X4) ) ).

cnf(i_0_265,axiom,
    ( ~ esk1013_4(X1,X2,X3,X4)
    | ~ esk969_4(X1,X2,X3,X4)
    | ~ esk980_4(X1,X2,X3,X4) ) ).

cnf(i_0_266,axiom,
    ( esk8630_4(X1,X2,X3,X4)
    | esk8631_4(X1,X2,X3,X4) ) ).

cnf(i_0_267,axiom,
    ( ~ esk4132_4(X1,X2,X3,X4)
    | ~ esk4035_4(X1,X2,X3,X4) ) ).

cnf(i_0_268,axiom,
    ( esk1018_4(X1,X2,X3,X4)
    | ~ esk961_4(X1,X2,X3,X4) ) ).

cnf(i_0_269,axiom,
    ( esk12793_4(X1,X2,X3,X4)
    | esk12817_4(X1,X2,X3,X4) ) ).

cnf(i_0_270,axiom,
    ( ~ esk9659_4(X1,X2,X3,X4)
    | ~ esk9629_4(X1,X2,X3,X4) ) ).

cnf(i_0_271,axiom,
    ( esk9796_4(X1,X2,X3,X4)
    | ~ esk9815_4(X1,X2,X3,X4)
    | esk9761_4(X1,X2,X3,X4) ) ).

cnf(i_0_272,axiom,
    ( p(X2)
    | p(X1)
    | esk433_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ esk49_0
    | p(X4) ) ).

cnf(i_0_273,axiom,
    ( esk16772_4(X1,X2,X3,X4)
    | ~ esk16771_4(X1,X2,X3,X4) ) ).

cnf(i_0_274,axiom,
    ( ~ esk9496_4(X1,X2,X3,X4)
    | esk9238_4(X1,X2,X3,X4) ) ).

cnf(i_0_275,axiom,
    ( esk16039_4(X1,X2,X3,X4)
    | ~ esk16066_4(X1,X2,X3,X4) ) ).

cnf(i_0_276,axiom,
    ( ~ esk11455_4(X1,X2,X3,X4)
    | ~ esk11457_4(X1,X2,X3,X4) ) ).

cnf(i_0_277,axiom,
    ( ~ esk15978_4(X1,X2,X3,X4)
    | esk15977_4(X1,X2,X3,X4) ) ).

cnf(i_0_278,axiom,
    ( ~ esk11007_4(X1,X2,X3,X4)
    | ~ esk10985_4(X1,X2,X3,X4)
    | ~ esk11008_4(X1,X2,X3,X4) ) ).

cnf(i_0_279,axiom,
    ( esk4756_4(X1,X2,X3,X4)
    | ~ esk4733_4(X1,X2,X3,X4) ) ).

cnf(i_0_280,axiom,
    ( ~ p(X4)
    | p(X3)
    | ~ esk151_0
    | esk16691_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X1) ) ).

cnf(i_0_281,axiom,
    ( esk14017_4(X1,X2,X3,X4)
    | ~ esk13991_4(X1,X2,X3,X4) ) ).

cnf(i_0_282,axiom,
    ( ~ esk6235_4(X1,X2,X3,X4)
    | esk6203_4(X1,X2,X3,X4)
    | esk6234_4(X1,X2,X3,X4) ) ).

cnf(i_0_283,axiom,
    ( ~ esk2724_4(X1,X2,X3,X4)
    | esk2740_4(X1,X2,X3,X4) ) ).

cnf(i_0_284,axiom,
    ( ~ esk5013_4(X1,X2,X3,X4)
    | esk4990_4(X1,X2,X3,X4) ) ).

cnf(i_0_285,axiom,
    ( ~ esk15825_4(X1,X2,X3,X4)
    | ~ esk15911_4(X1,X2,X3,X4)
    | esk15814_4(X1,X2,X3,X4) ) ).

cnf(i_0_286,axiom,
    ( esk9610_4(X1,X2,X3,X4)
    | ~ esk9645_4(X1,X2,X3,X4) ) ).

cnf(i_0_287,axiom,
    ( ~ esk12543_4(X1,X2,X3,X4)
    | ~ esk12544_4(X1,X2,X3,X4)
    | ~ esk12530_4(X1,X2,X3,X4) ) ).

cnf(i_0_288,axiom,
    ( ~ esk11495_4(X1,X2,X3,X4)
    | ~ esk11529_4(X1,X2,X3,X4)
    | ~ esk11530_4(X1,X2,X3,X4) ) ).

cnf(i_0_289,axiom,
    ( esk14603_4(X1,X2,X3,X4)
    | esk14584_4(X1,X2,X3,X4) ) ).

cnf(i_0_290,axiom,
    ( esk5188_4(X1,X2,X3,X4)
    | ~ esk5186_4(X1,X2,X3,X4)
    | ~ esk5187_4(X1,X2,X3,X4) ) ).

cnf(i_0_291,axiom,
    ( ~ esk6169_4(X1,X2,X3,X4)
    | ~ esk6109_4(X1,X2,X3,X4)
    | ~ esk6136_4(X1,X2,X3,X4) ) ).

cnf(i_0_292,axiom,
    ( ~ esk7012_4(X1,X2,X3,X4)
    | ~ esk6990_4(X1,X2,X3,X4) ) ).

cnf(i_0_293,axiom,
    ( ~ esk12631_4(X1,X2,X3,X4)
    | ~ esk12632_4(X1,X2,X3,X4) ) ).

cnf(i_0_294,axiom,
    ( ~ esk4754_4(X1,X2,X3,X4)
    | esk4774_4(X1,X2,X3,X4) ) ).

cnf(i_0_295,axiom,
    ( esk3276_4(X1,X2,X3,X4)
    | esk3295_4(X1,X2,X3,X4) ) ).

cnf(i_0_296,axiom,
    ( esk6277_4(X1,X2,X3,X4)
    | ~ esk6296_4(X1,X2,X3,X4) ) ).

cnf(i_0_297,axiom,
    ( ~ esk8876_4(X1,X2,X3,X4)
    | esk8852_4(X1,X2,X3,X4) ) ).

cnf(i_0_298,axiom,
    ( ~ esk10820_4(X1,X2,X3,X4)
    | ~ esk10821_4(X1,X2,X3,X4) ) ).

cnf(i_0_299,axiom,
    ( esk13427_4(X1,X2,X3,X4)
    | esk13313_4(X1,X2,X3,X4) ) ).

cnf(i_0_300,axiom,
    ( esk15571_4(X1,X2,X3,X4)
    | esk15569_4(X1,X2,X3,X4) ) ).

cnf(i_0_301,axiom,
    ( esk13813_4(X1,X2,X3,X4)
    | esk13832_4(X1,X2,X3,X4) ) ).

cnf(i_0_302,axiom,
    ( esk9765_4(X1,X2,X3,X4)
    | esk9795_4(X1,X2,X3,X4) ) ).

cnf(i_0_303,axiom,
    ( ~ esk4003_4(X1,X2,X3,X4)
    | ~ esk4109_4(X1,X2,X3,X4)
    | esk3987_4(X1,X2,X3,X4) ) ).

cnf(i_0_304,axiom,
    ( esk7396_4(X1,X2,X3,X4)
    | esk7416_4(X1,X2,X3,X4) ) ).

cnf(i_0_305,axiom,
    ( esk15825_4(X1,X2,X3,X4)
    | ~ esk15807_4(X1,X2,X3,X4) ) ).

cnf(i_0_306,axiom,
    ( ~ esk13512_4(X1,X2,X3,X4)
    | esk13503_4(X1,X2,X3,X4)
    | ~ esk13602_4(X1,X2,X3,X4) ) ).

cnf(i_0_307,axiom,
    ( ~ esk8681_4(X1,X2,X3,X4)
    | ~ esk8697_4(X1,X2,X3,X4)
    | ~ esk8782_4(X1,X2,X3,X4) ) ).

cnf(i_0_308,axiom,
    ( ~ esk12341_4(X1,X2,X3,X4)
    | ~ esk12343_4(X1,X2,X3,X4)
    | ~ esk12361_4(X1,X2,X3,X4) ) ).

cnf(i_0_309,axiom,
    ( ~ esk13994_4(X1,X2,X3,X4)
    | esk14145_4(X1,X2,X3,X4) ) ).

cnf(i_0_310,axiom,
    ( esk14901_4(X1,X2,X3,X4)
    | ~ esk14955_4(X1,X2,X3,X4)
    | esk14936_4(X1,X2,X3,X4) ) ).

cnf(i_0_311,axiom,
    ( esk5579_4(X1,X2,X3,X4)
    | esk5629_4(X1,X2,X3,X4) ) ).

cnf(i_0_312,axiom,
    ( ~ esk8663_4(X1,X2,X3,X4)
    | ~ esk8713_4(X1,X2,X3,X4)
    | ~ esk8712_4(X1,X2,X3,X4) ) ).

cnf(i_0_313,axiom,
    ( esk11369_4(X1,X2,X3,X4)
    | esk11253_4(X1,X2,X3,X4) ) ).

cnf(i_0_314,axiom,
    ( esk7267_4(X1,X2,X3,X4)
    | ~ esk7260_4(X1,X2,X3,X4)
    | esk7179_4(X1,X2,X3,X4) ) ).

cnf(i_0_315,axiom,
    ( esk12458_4(X1,X2,X3,X4)
    | esk12459_4(X1,X2,X3,X4)
    | esk12456_4(X1,X2,X3,X4)
    | esk12486_4(X1,X2,X3,X4)
    | esk12434_4(X1,X2,X3,X4) ) ).

cnf(i_0_316,axiom,
    ( esk13153_4(X1,X2,X3,X4)
    | ~ esk13139_4(X1,X2,X3,X4) ) ).

cnf(i_0_317,axiom,
    ( esk5568_4(X1,X2,X3,X4)
    | esk5550_4(X1,X2,X3,X4) ) ).

cnf(i_0_318,axiom,
    ( ~ esk3585_4(X1,X2,X3,X4)
    | esk3327_4(X1,X2,X3,X4) ) ).

cnf(i_0_319,axiom,
    ( ~ esk13160_4(X1,X2,X3,X4)
    | ~ esk13132_4(X1,X2,X3,X4) ) ).

cnf(i_0_320,axiom,
    ( esk14873_4(X1,X2,X3,X4)
    | esk14835_4(X1,X2,X3,X4) ) ).

cnf(i_0_321,axiom,
    ( ~ esk4076_4(X1,X2,X3,X4)
    | ~ esk4042_4(X1,X2,X3,X4)
    | ~ esk4077_4(X1,X2,X3,X4) ) ).

cnf(i_0_322,axiom,
    ( ~ esk14321_4(X1,X2,X3,X4)
    | ~ esk14359_4(X1,X2,X3,X4)
    | ~ esk14358_4(X1,X2,X3,X4) ) ).

cnf(i_0_323,axiom,
    ( ~ esk11309_4(X1,X2,X3,X4)
    | esk11185_4(X1,X2,X3,X4)
    | ~ esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_324,axiom,
    ( esk13637_4(X1,X2,X3,X4)
    | ~ esk13635_4(X1,X2,X3,X4) ) ).

cnf(i_0_325,axiom,
    ( esk9977_4(X1,X2,X3,X4)
    | esk10010_4(X1,X2,X3,X4) ) ).

cnf(i_0_326,axiom,
    ( esk7743_4(X1,X2,X3,X4)
    | esk7699_4(X1,X2,X3,X4)
    | ~ esk7750_4(X1,X2,X3,X4) ) ).

cnf(i_0_327,axiom,
    ( ~ esk16436_4(X1,X2,X3,X4)
    | esk16382_4(X1,X2,X3,X4) ) ).

cnf(i_0_328,axiom,
    ( esk9657_4(X1,X2,X3,X4)
    | ~ esk9646_4(X1,X2,X3,X4) ) ).

cnf(i_0_329,axiom,
    ( ~ esk5549_4(X1,X2,X3,X4)
    | esk5571_4(X1,X2,X3,X4) ) ).

cnf(i_0_330,axiom,
    ( ~ esk8254_4(X1,X2,X3,X4)
    | ~ esk8273_4(X1,X2,X3,X4)
    | ~ esk8219_4(X1,X2,X3,X4) ) ).

cnf(i_0_331,axiom,
    ( ~ esk754_4(X1,X2,X3,X4)
    | ~ esk662_4(X1,X2,X3,X4)
    | esk654_4(X1,X2,X3,X4) ) ).

cnf(i_0_332,axiom,
    ( esk466_4(X1,X2,X3,X4)
    | esk455_4(X1,X2,X3,X4) ) ).

cnf(i_0_333,axiom,
    ( esk3698_4(X1,X2,X3,X4)
    | ~ esk3741_4(X1,X2,X3,X4) ) ).

cnf(i_0_334,axiom,
    ( esk13620_4(X1,X2,X3,X4)
    | ~ esk13362_4(X1,X2,X3,X4) ) ).

cnf(i_0_335,axiom,
    ( esk388_4(X1,X2,X3,X4)
    | ~ esk509_4(X1,X2,X3,X4)
    | ~ esk405_4(X1,X2,X3,X4) ) ).

cnf(i_0_336,axiom,
    ( esk6425_4(X1,X2,X3,X4)
    | ~ esk6683_4(X1,X2,X3,X4) ) ).

cnf(i_0_337,axiom,
    ( esk4834_4(X1,X2,X3,X4)
    | esk4957_4(X1,X2,X3,X4) ) ).

cnf(i_0_338,axiom,
    ( ~ esk3287_4(X1,X2,X3,X4)
    | ~ esk3288_4(X1,X2,X3,X4)
    | ~ esk3280_4(X1,X2,X3,X4) ) ).

cnf(i_0_339,axiom,
    ( ~ esk15446_4(X1,X2,X3,X4)
    | ~ esk15447_4(X1,X2,X3,X4) ) ).

cnf(i_0_340,axiom,
    ( esk1538_4(X1,X2,X3,X4)
    | ~ esk1472_4(X1,X2,X3,X4) ) ).

cnf(i_0_341,axiom,
    ( esk3653_4(X1,X2,X3,X4)
    | ~ esk3654_4(X1,X2,X3,X4) ) ).

cnf(i_0_342,axiom,
    ( ~ esk8809_4(X1,X2,X3,X4)
    | esk8802_4(X1,X2,X3,X4)
    | esk8721_4(X1,X2,X3,X4) ) ).

cnf(i_0_343,axiom,
    ( esk13898_4(X1,X2,X3,X4)
    | esk13801_4(X1,X2,X3,X4)
    | esk13802_4(X1,X2,X3,X4) ) ).

cnf(i_0_344,axiom,
    ( esk11093_4(X1,X2,X3,X4)
    | ~ esk11092_4(X1,X2,X3,X4) ) ).

cnf(i_0_345,axiom,
    ( ~ esk2819_4(X1,X2,X3,X4)
    | esk3077_4(X1,X2,X3,X4) ) ).

cnf(i_0_346,axiom,
    ( ~ esk6816_4(X1,X2,X3,X4)
    | esk6940_4(X1,X2,X3,X4) ) ).

cnf(i_0_347,axiom,
    ( ~ esk4671_4(X1,X2,X3,X4)
    | esk4672_4(X1,X2,X3,X4) ) ).

cnf(i_0_348,axiom,
    ( esk10767_4(X1,X2,X3,X4)
    | esk10720_4(X1,X2,X3,X4) ) ).

cnf(i_0_349,axiom,
    ( esk16443_4(X1,X2,X3,X4)
    | esk16479_4(X1,X2,X3,X4) ) ).

cnf(i_0_350,axiom,
    ( ~ esk13663_4(X1,X2,X3,X4)
    | esk13665_4(X1,X2,X3,X4)
    | ~ esk13664_4(X1,X2,X3,X4) ) ).

cnf(i_0_351,axiom,
    ( esk7910_4(X1,X2,X3,X4)
    | esk7926_4(X1,X2,X3,X4) ) ).

cnf(i_0_352,axiom,
    ( ~ esk14847_4(X1,X2,X3,X4)
    | ~ esk14903_4(X1,X2,X3,X4)
    | ~ esk14870_4(X1,X2,X3,X4) ) ).

cnf(i_0_353,axiom,
    ( esk1937_4(X1,X2,X3,X4)
    | ~ esk1913_4(X1,X2,X3,X4) ) ).

cnf(i_0_354,axiom,
    ( ~ esk2956_4(X1,X2,X3,X4)
    | esk2975_4(X1,X2,X3,X4) ) ).

cnf(i_0_355,axiom,
    ( ~ esk1740_4(X1,X2,X3,X4)
    | ~ esk1763_4(X1,X2,X3,X4)
    | ~ esk1796_4(X1,X2,X3,X4) ) ).

cnf(i_0_356,axiom,
    ( esk3506_4(X1,X2,X3,X4)
    | ~ esk3502_4(X1,X2,X3,X4) ) ).

cnf(i_0_357,axiom,
    ( esk3573_4(X1,X2,X3,X4)
    | esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_358,axiom,
    ( ~ esk11552_4(X1,X2,X3,X4)
    | ~ esk11600_4(X1,X2,X3,X4) ) ).

cnf(i_0_359,axiom,
    ( esk16717_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1)
    | ~ esk304_0
    | p(X2)
    | ~ p(X4) ) ).

cnf(i_0_360,axiom,
    ( ~ esk3439_4(X1,X2,X3,X4)
    | ~ esk3491_4(X1,X2,X3,X4) ) ).

cnf(i_0_361,axiom,
    ( ~ esk4405_4(X1,X2,X3,X4)
    | ~ esk4403_4(X1,X2,X3,X4) ) ).

cnf(i_0_362,axiom,
    ( esk13399_4(X1,X2,X3,X4)
    | esk13351_4(X1,X2,X3,X4) ) ).

cnf(i_0_363,axiom,
    ( ~ esk919_4(X1,X2,X3,X4)
    | ~ esk1011_4(X1,X2,X3,X4)
    | esk911_4(X1,X2,X3,X4) ) ).

cnf(i_0_364,axiom,
    ( ~ esk8259_4(X1,X2,X3,X4)
    | esk8291_4(X1,X2,X3,X4) ) ).

cnf(i_0_365,axiom,
    ( esk15447_4(X1,X2,X3,X4)
    | esk15421_4(X1,X2,X3,X4)
    | ~ esk15472_4(X1,X2,X3,X4) ) ).

cnf(i_0_366,axiom,
    ( ~ esk7352_4(X1,X2,X3,X4)
    | ~ esk7357_4(X1,X2,X3,X4) ) ).

cnf(i_0_367,axiom,
    ( esk3237_4(X1,X2,X3,X4)
    | esk3255_4(X1,X2,X3,X4) ) ).

cnf(i_0_368,axiom,
    ( ~ esk13881_4(X1,X2,X3,X4)
    | ~ esk13904_4(X1,X2,X3,X4) ) ).

cnf(i_0_369,axiom,
    ( esk3144_4(X1,X2,X3,X4)
    | ~ esk3142_4(X1,X2,X3,X4)
    | ~ esk3143_4(X1,X2,X3,X4) ) ).

cnf(i_0_370,axiom,
    ( esk7672_4(X1,X2,X3,X4)
    | esk7651_4(X1,X2,X3,X4) ) ).

cnf(i_0_371,axiom,
    ( esk15821_4(X1,X2,X3,X4)
    | esk15875_4(X1,X2,X3,X4)
    | esk15855_4(X1,X2,X3,X4) ) ).

cnf(i_0_372,axiom,
    ( ~ esk12614_4(X1,X2,X3,X4)
    | ~ esk12607_4(X1,X2,X3,X4)
    | ~ esk12461_4(X1,X2,X3,X4) ) ).

cnf(i_0_373,axiom,
    ( esk7351_4(X1,X2,X3,X4)
    | ~ esk7093_4(X1,X2,X3,X4) ) ).

cnf(i_0_374,axiom,
    ( ~ esk10441_4(X1,X2,X3,X4)
    | esk10445_4(X1,X2,X3,X4) ) ).

cnf(i_0_375,axiom,
    ( ~ esk7993_4(X1,X2,X3,X4)
    | ~ esk7994_4(X1,X2,X3,X4) ) ).

cnf(i_0_376,axiom,
    ( ~ esk5196_4(X1,X2,X3,X4)
    | esk5195_4(X1,X2,X3,X4) ) ).

cnf(i_0_377,axiom,
    ( ~ esk6180_4(X1,X2,X3,X4)
    | esk6438_4(X1,X2,X3,X4) ) ).

cnf(i_0_378,axiom,
    ( ~ esk9096_4(X1,X2,X3,X4)
    | esk9131_4(X1,X2,X3,X4) ) ).

cnf(i_0_379,axiom,
    ( ~ esk1689_4(X1,X2,X3,X4)
    | ~ esk1666_4(X1,X2,X3,X4) ) ).

cnf(i_0_380,axiom,
    ( esk3107_4(X1,X2,X3,X4)
    | ~ esk3127_4(X1,X2,X3,X4)
    | esk3156_4(X1,X2,X3,X4) ) ).

cnf(i_0_381,axiom,
    ( esk6462_4(X1,X2,X3,X4)
    | esk6463_4(X1,X2,X3,X4)
    | ~ esk6488_4(X1,X2,X3,X4) ) ).

cnf(i_0_382,axiom,
    ( esk8608_4(X1,X2,X3,X4)
    | ~ esk8660_4(X1,X2,X3,X4) ) ).

cnf(i_0_383,axiom,
    ( esk2251_4(X1,X2,X3,X4)
    | esk2261_4(X1,X2,X3,X4) ) ).

cnf(i_0_384,axiom,
    ( ~ esk14544_4(X1,X2,X3,X4)
    | esk14802_4(X1,X2,X3,X4) ) ).

cnf(i_0_385,axiom,
    ( esk16136_4(X1,X2,X3,X4)
    | esk16131_4(X1,X2,X3,X4) ) ).

cnf(i_0_386,axiom,
    ( esk8077_4(X1,X2,X3,X4)
    | ~ esk8109_4(X1,X2,X3,X4) ) ).

cnf(i_0_387,axiom,
    ( esk3298_4(X1,X2,X3,X4)
    | esk3381_4(X1,X2,X3,X4) ) ).

cnf(i_0_388,axiom,
    ( esk584_4(X1,X2,X3,X4)
    | ~ esk565_4(X1,X2,X3,X4)
    | esk513_4(X1,X2,X3,X4) ) ).

cnf(i_0_389,axiom,
    ( esk11193_4(X1,X2,X3,X4)
    | ~ esk11161_4(X1,X2,X3,X4) ) ).

cnf(i_0_390,axiom,
    ( esk4832_4(X1,X2,X3,X4)
    | esk4946_4(X1,X2,X3,X4) ) ).

cnf(i_0_391,axiom,
    ( esk797_4(X1,X2,X3,X4)
    | esk774_4(X1,X2,X3,X4) ) ).

cnf(i_0_392,axiom,
    ( ~ esk4731_4(X1,X2,X3,X4)
    | esk4758_4(X1,X2,X3,X4) ) ).

cnf(i_0_393,axiom,
    ( ~ esk5287_4(X1,X2,X3,X4)
    | ~ esk5289_4(X1,X2,X3,X4) ) ).

cnf(i_0_394,axiom,
    ( esk1444_4(X1,X2,X3,X4)
    | ~ esk1450_4(X1,X2,X3,X4)
    | esk1446_4(X1,X2,X3,X4) ) ).

cnf(i_0_395,axiom,
    ( esk714_4(X1,X2,X3,X4)
    | esk736_4(X1,X2,X3,X4) ) ).

cnf(i_0_396,axiom,
    ( esk823_4(X1,X2,X3,X4)
    | esk740_4(X1,X2,X3,X4) ) ).

cnf(i_0_397,axiom,
    ( esk11060_4(X1,X2,X3,X4)
    | ~ esk11059_4(X1,X2,X3,X4) ) ).

cnf(i_0_398,axiom,
    ( esk8492_4(X1,X2,X3,X4)
    | ~ esk8493_4(X1,X2,X3,X4) ) ).

cnf(i_0_399,axiom,
    ( esk1471_4(X1,X2,X3,X4)
    | ~ esk1540_4(X1,X2,X3,X4) ) ).

cnf(i_0_400,axiom,
    ( esk11750_4(X1,X2,X3,X4)
    | esk11790_4(X1,X2,X3,X4) ) ).

cnf(i_0_401,axiom,
    ( ~ esk4374_4(X1,X2,X3,X4)
    | ~ esk4376_4(X1,X2,X3,X4)
    | ~ esk4394_4(X1,X2,X3,X4) ) ).

cnf(i_0_402,axiom,
    ( esk12737_4(X1,X2,X3,X4)
    | ~ esk12753_4(X1,X2,X3,X4)
    | ~ esk12773_4(X1,X2,X3,X4) ) ).

cnf(i_0_403,axiom,
    ( p(X3)
    | ~ esk501_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4)
    | ~ p(X1)
    | esk145_0 ) ).

cnf(i_0_404,axiom,
    ( esk6415_4(X1,X2,X3,X4)
    | ~ esk6358_4(X1,X2,X3,X4) ) ).

cnf(i_0_405,axiom,
    ( ~ esk14686_4(X1,X2,X3,X4)
    | ~ esk14687_4(X1,X2,X3,X4)
    | ~ esk14712_4(X1,X2,X3,X4) ) ).

cnf(i_0_406,axiom,
    ( ~ esk8681_4(X1,X2,X3,X4)
    | ~ esk8705_4(X1,X2,X3,X4)
    | ~ esk8811_4(X1,X2,X3,X4) ) ).

cnf(i_0_407,axiom,
    ( esk14615_4(X1,X2,X3,X4)
    | esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_408,axiom,
    ( ~ esk11975_4(X1,X2,X3,X4)
    | esk11995_4(X1,X2,X3,X4) ) ).

cnf(i_0_409,axiom,
    ( esk1180_4(X1,X2,X3,X4)
    | ~ esk1438_4(X1,X2,X3,X4) ) ).

cnf(i_0_410,axiom,
    ( ~ esk8466_4(X1,X2,X3,X4)
    | ~ esk8433_4(X1,X2,X3,X4)
    | ~ esk8422_4(X1,X2,X3,X4) ) ).

cnf(i_0_411,axiom,
    ( ~ esk8640_4(X1,X2,X3,X4)
    | ~ esk8641_4(X1,X2,X3,X4) ) ).

cnf(i_0_412,axiom,
    ( ~ esk15599_4(X1,X2,X3,X4)
    | esk15547_4(X1,X2,X3,X4) ) ).

cnf(i_0_413,axiom,
    ( esk8942_4(X1,X2,X3,X4)
    | esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_414,axiom,
    ( esk16660_4(X1,X2,X3,X4)
    | esk16640_4(X1,X2,X3,X4) ) ).

cnf(i_0_415,axiom,
    ( esk16120_4(X1,X2,X3,X4)
    | ~ esk16189_4(X1,X2,X3,X4) ) ).

cnf(i_0_416,axiom,
    ( esk479_4(X1,X2,X3,X4)
    | esk457_4(X1,X2,X3,X4) ) ).

cnf(i_0_417,axiom,
    ( ~ esk7234_4(X1,X2,X3,X4)
    | ~ esk7235_4(X1,X2,X3,X4) ) ).

cnf(i_0_418,axiom,
    ( ~ esk3092_4(X1,X2,X3,X4)
    | esk3093_4(X1,X2,X3,X4) ) ).

cnf(i_0_419,axiom,
    ( ~ esk11554_4(X1,X2,X3,X4)
    | ~ esk11598_4(X1,X2,X3,X4)
    | ~ esk11599_4(X1,X2,X3,X4) ) ).

cnf(i_0_420,axiom,
    ( esk9803_4(X1,X2,X3,X4)
    | esk9805_4(X1,X2,X3,X4)
    | esk9804_4(X1,X2,X3,X4) ) ).

cnf(i_0_421,axiom,
    ( ~ esk10557_4(X1,X2,X3,X4)
    | esk10299_4(X1,X2,X3,X4) ) ).

cnf(i_0_422,axiom,
    ( esk9094_4(X1,X2,X3,X4)
    | esk9144_4(X1,X2,X3,X4) ) ).

cnf(i_0_423,axiom,
    ( esk8551_4(X1,X2,X3,X4)
    | esk8508_4(X1,X2,X3,X4) ) ).

cnf(i_0_424,axiom,
    ( esk14425_4(X1,X2,X3,X4)
    | esk14381_4(X1,X2,X3,X4)
    | ~ esk14432_4(X1,X2,X3,X4) ) ).

cnf(i_0_425,axiom,
    ( esk10295_4(X1,X2,X3,X4)
    | esk10294_4(X1,X2,X3,X4)
    | ~ esk10296_4(X1,X2,X3,X4) ) ).

cnf(i_0_426,axiom,
    ( esk1738_4(X1,X2,X3,X4)
    | esk1746_4(X1,X2,X3,X4) ) ).

cnf(i_0_427,axiom,
    ( esk4672_4(X1,X2,X3,X4)
    | ~ esk4674_4(X1,X2,X3,X4) ) ).

cnf(i_0_428,axiom,
    ( ~ esk4134_4(X1,X2,X3,X4)
    | ~ esk4119_4(X1,X2,X3,X4) ) ).

cnf(i_0_429,axiom,
    ( ~ esk11205_4(X1,X2,X3,X4)
    | esk11463_4(X1,X2,X3,X4) ) ).

cnf(i_0_430,axiom,
    ( ~ esk5536_4(X1,X2,X3,X4)
    | esk5545_4(X1,X2,X3,X4) ) ).

cnf(i_0_431,axiom,
    ( ~ esk12226_4(X1,X2,X3,X4)
    | esk12346_4(X1,X2,X3,X4) ) ).

cnf(i_0_432,axiom,
    ( ~ esk6952_4(X1,X2,X3,X4)
    | ~ esk6860_4(X1,X2,X3,X4) ) ).

cnf(i_0_433,axiom,
    ( ~ esk5602_4(X1,X2,X3,X4)
    | ~ esk5603_4(X1,X2,X3,X4)
    | ~ esk5592_4(X1,X2,X3,X4) ) ).

cnf(i_0_434,axiom,
    ( esk16688_4(X1,X2,X3,X4)
    | ~ esk16776_4(X1,X2,X3,X4)
    | esk16769_4(X1,X2,X3,X4) ) ).

cnf(i_0_435,axiom,
    ( esk5289_4(X1,X2,X3,X4)
    | esk5239_4(X1,X2,X3,X4) ) ).

cnf(i_0_436,axiom,
    ( ~ esk16500_4(X1,X2,X3,X4)
    | esk16449_4(X1,X2,X3,X4)
    | esk16475_4(X1,X2,X3,X4) ) ).

cnf(i_0_437,axiom,
    ( ~ esk7890_4(X1,X2,X3,X4)
    | ~ esk7987_4(X1,X2,X3,X4) ) ).

cnf(i_0_438,axiom,
    ( ~ esk1597_4(X1,X2,X3,X4)
    | esk1545_4(X1,X2,X3,X4)
    | esk1567_4(X1,X2,X3,X4) ) ).

cnf(i_0_439,axiom,
    ( esk16175_4(X1,X2,X3,X4)
    | ~ esk16127_4(X1,X2,X3,X4) ) ).

cnf(i_0_440,axiom,
    ( esk10552_4(X1,X2,X3,X4)
    | ~ esk10553_4(X1,X2,X3,X4)
    | esk10551_4(X1,X2,X3,X4) ) ).

cnf(i_0_441,axiom,
    ( ~ esk11974_4(X1,X2,X3,X4)
    | esk11996_4(X1,X2,X3,X4) ) ).

cnf(i_0_442,axiom,
    ( esk12902_4(X1,X2,X3,X4)
    | ~ esk12851_4(X1,X2,X3,X4)
    | esk12877_4(X1,X2,X3,X4) ) ).

cnf(i_0_443,axiom,
    ( esk3027_4(X1,X2,X3,X4)
    | esk3041_4(X1,X2,X3,X4) ) ).

cnf(i_0_444,axiom,
    ( ~ esk5712_4(X1,X2,X3,X4)
    | ~ esk5713_4(X1,X2,X3,X4)
    | esk5714_4(X1,X2,X3,X4) ) ).

cnf(i_0_445,axiom,
    ( ~ p(X4)
    | esk16697_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X3)
    | ~ esk190_0
    | ~ p(X2) ) ).

cnf(i_0_446,axiom,
    ( ~ esk11546_4(X1,X2,X3,X4)
    | ~ esk11602_4(X1,X2,X3,X4) ) ).

cnf(i_0_447,axiom,
    ( esk11202_4(X1,X2,X3,X4)
    | esk11200_4(X1,X2,X3,X4) ) ).

cnf(i_0_448,axiom,
    ( ~ esk11371_4(X1,X2,X3,X4)
    | esk11345_4(X1,X2,X3,X4)
    | esk11346_4(X1,X2,X3,X4) ) ).

cnf(i_0_449,axiom,
    ( p(X3)
    | ~ p(X4)
    | p(X1)
    | esk67_0
    | ~ p(X2)
    | ~ esk491_4(X1,X2,X3,X4) ) ).

cnf(i_0_450,axiom,
    ( esk16427_4(X1,X2,X3,X4)
    | esk16487_4(X1,X2,X3,X4)
    | ~ esk16510_4(X1,X2,X3,X4) ) ).

cnf(i_0_451,axiom,
    ( esk11254_4(X1,X2,X3,X4)
    | esk11287_4(X1,X2,X3,X4) ) ).

cnf(i_0_452,axiom,
    ( ~ esk8371_4(X1,X2,X3,X4)
    | ~ esk8489_4(X1,X2,X3,X4) ) ).

cnf(i_0_453,axiom,
    ( esk13539_4(X1,X2,X3,X4)
    | ~ esk13797_4(X1,X2,X3,X4) ) ).

cnf(i_0_454,axiom,
    ( ~ esk9557_4(X1,X2,X3,X4)
    | esk9555_4(X1,X2,X3,X4) ) ).

cnf(i_0_455,axiom,
    ( ~ esk8962_4(X1,X2,X3,X4)
    | ~ esk8938_4(X1,X2,X3,X4)
    | ~ esk9068_4(X1,X2,X3,X4) ) ).

cnf(i_0_456,axiom,
    ( ~ esk4906_4(X1,X2,X3,X4)
    | ~ esk4914_4(X1,X2,X3,X4) ) ).

cnf(i_0_457,axiom,
    ( ~ esk15438_4(X1,X2,X3,X4)
    | esk15436_4(X1,X2,X3,X4) ) ).

cnf(i_0_458,axiom,
    ( esk7646_4(X1,X2,X3,X4)
    | esk7663_4(X1,X2,X3,X4) ) ).

cnf(i_0_459,axiom,
    ( esk13571_4(X1,X2,X3,X4)
    | esk13558_4(X1,X2,X3,X4) ) ).

cnf(i_0_460,axiom,
    ( ~ esk10966_4(X1,X2,X3,X4)
    | esk10965_4(X1,X2,X3,X4)
    | esk10970_4(X1,X2,X3,X4) ) ).

cnf(i_0_461,axiom,
    ( esk7966_4(X1,X2,X3,X4)
    | ~ esk7708_4(X1,X2,X3,X4) ) ).

cnf(i_0_462,axiom,
    ( ~ esk11981_4(X1,X2,X3,X4)
    | ~ esk11982_4(X1,X2,X3,X4) ) ).

cnf(i_0_463,axiom,
    ( ~ esk15315_4(X1,X2,X3,X4)
    | esk15337_4(X1,X2,X3,X4) ) ).

cnf(i_0_464,axiom,
    ( ~ esk14639_4(X1,X2,X3,X4)
    | esk14897_4(X1,X2,X3,X4) ) ).

cnf(i_0_465,axiom,
    ( esk4254_4(X1,X2,X3,X4)
    | ~ esk4260_4(X1,X2,X3,X4)
    | ~ esk4356_4(X1,X2,X3,X4) ) ).

cnf(i_0_466,axiom,
    ( esk2289_4(X1,X2,X3,X4)
    | ~ esk2547_4(X1,X2,X3,X4) ) ).

cnf(i_0_467,axiom,
    ( esk3603_4(X1,X2,X3,X4)
    | ~ esk3657_4(X1,X2,X3,X4)
    | esk3620_4(X1,X2,X3,X4) ) ).

cnf(i_0_468,axiom,
    ( ~ esk1429_4(X1,X2,X3,X4)
    | ~ esk1484_4(X1,X2,X3,X4) ) ).

cnf(i_0_469,axiom,
    ( ~ esk12869_4(X1,X2,X3,X4)
    | esk13127_4(X1,X2,X3,X4) ) ).

cnf(i_0_470,axiom,
    ( ~ esk15307_4(X1,X2,X3,X4)
    | ~ esk15362_4(X1,X2,X3,X4) ) ).

cnf(i_0_471,axiom,
    ( ~ esk14539_4(X1,X2,X3,X4)
    | ~ esk14516_4(X1,X2,X3,X4) ) ).

cnf(i_0_472,axiom,
    ( ~ esk3213_4(X1,X2,X3,X4)
    | esk3192_4(X1,X2,X3,X4) ) ).

cnf(i_0_473,axiom,
    ( ~ esk11882_4(X1,X2,X3,X4)
    | esk11881_4(X1,X2,X3,X4) ) ).

cnf(i_0_474,axiom,
    ( esk515_4(X1,X2,X3,X4)
    | esk482_4(X1,X2,X3,X4) ) ).

cnf(i_0_475,axiom,
    ( esk11864_4(X1,X2,X3,X4)
    | ~ esk11813_4(X1,X2,X3,X4) ) ).

cnf(i_0_476,axiom,
    ( ~ esk971_4(X1,X2,X3,X4)
    | ~ esk1076_4(X1,X2,X3,X4)
    | ~ esk989_4(X1,X2,X3,X4) ) ).

cnf(i_0_477,axiom,
    ( ~ esk7972_4(X1,X2,X3,X4)
    | ~ esk7992_4(X1,X2,X3,X4)
    | ~ esk7974_4(X1,X2,X3,X4) ) ).

cnf(i_0_478,axiom,
    ( esk4060_4(X1,X2,X3,X4)
    | esk4053_4(X1,X2,X3,X4) ) ).

cnf(i_0_479,axiom,
    ( esk5410_4(X1,X2,X3,X4)
    | ~ esk5152_4(X1,X2,X3,X4) ) ).

cnf(i_0_480,axiom,
    ( esk4517_4(X1,X2,X3,X4)
    | ~ esk4507_4(X1,X2,X3,X4) ) ).

cnf(i_0_481,axiom,
    ( ~ esk12798_4(X1,X2,X3,X4)
    | ~ esk12791_4(X1,X2,X3,X4)
    | ~ esk12831_4(X1,X2,X3,X4) ) ).

cnf(i_0_482,axiom,
    ( esk14590_4(X1,X2,X3,X4)
    | esk14609_4(X1,X2,X3,X4) ) ).

cnf(i_0_483,axiom,
    ( esk15708_4(X1,X2,X3,X4)
    | esk15672_4(X1,X2,X3,X4) ) ).

cnf(i_0_484,axiom,
    ( ~ esk6855_4(X1,X2,X3,X4)
    | esk6859_4(X1,X2,X3,X4)
    | esk6835_4(X1,X2,X3,X4) ) ).

cnf(i_0_485,axiom,
    ( ~ esk9275_4(X1,X2,X3,X4)
    | ~ esk9293_4(X1,X2,X3,X4) ) ).

cnf(i_0_486,axiom,
    ( ~ esk11803_4(X1,X2,X3,X4)
    | ~ esk11763_4(X1,X2,X3,X4)
    | ~ esk11770_4(X1,X2,X3,X4) ) ).

cnf(i_0_487,axiom,
    ( esk10249_4(X1,X2,X3,X4)
    | esk10208_4(X1,X2,X3,X4) ) ).

cnf(i_0_488,axiom,
    ( ~ esk13758_4(X1,X2,X3,X4)
    | esk13855_4(X1,X2,X3,X4) ) ).

cnf(i_0_489,axiom,
    ( ~ esk12785_4(X1,X2,X3,X4)
    | esk12836_4(X1,X2,X3,X4) ) ).

cnf(i_0_490,axiom,
    ( ~ esk6097_4(X1,X2,X3,X4)
    | esk6166_4(X1,X2,X3,X4) ) ).

cnf(i_0_491,axiom,
    ( esk11516_4(X1,X2,X3,X4)
    | esk11639_4(X1,X2,X3,X4) ) ).

cnf(i_0_492,axiom,
    ( p(X3)
    | ~ p(X1)
    | ~ esk180_0
    | ~ p(X2)
    | p(X4)
    | esk16695_4(X1,X2,X3,X4) ) ).

cnf(i_0_493,axiom,
    ( esk6400_4(X1,X2,X3,X4)
    | esk6350_4(X1,X2,X3,X4) ) ).

cnf(i_0_494,axiom,
    ( esk5976_4(X1,X2,X3,X4)
    | esk5947_4(X1,X2,X3,X4)
    | ~ esk5896_4(X1,X2,X3,X4) ) ).

cnf(i_0_495,axiom,
    ( esk3087_4(X1,X2,X3,X4)
    | ~ esk3139_4(X1,X2,X3,X4)
    | esk3109_4(X1,X2,X3,X4) ) ).

cnf(i_0_496,axiom,
    ( esk11035_4(X1,X2,X3,X4)
    | ~ esk11293_4(X1,X2,X3,X4) ) ).

cnf(i_0_497,axiom,
    esk12995_4(X1,X2,X3,X4) ).

cnf(i_0_498,axiom,
    ( ~ esk1015_4(X1,X2,X3,X4)
    | ~ esk982_4(X1,X2,X3,X4)
    | ~ esk969_4(X1,X2,X3,X4) ) ).

cnf(i_0_499,axiom,
    ( ~ esk15291_4(X1,X2,X3,X4)
    | esk15272_4(X1,X2,X3,X4) ) ).

cnf(i_0_500,axiom,
    ( ~ esk13159_4(X1,X2,X3,X4)
    | ~ esk13076_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_501,axiom,
    ( esk11619_4(X1,X2,X3,X4)
    | ~ esk11591_4(X1,X2,X3,X4) ) ).

cnf(i_0_502,axiom,
    ( ~ esk4132_4(X1,X2,X3,X4)
    | ~ esk4034_4(X1,X2,X3,X4)
    | ~ esk4125_4(X1,X2,X3,X4) ) ).

cnf(i_0_503,axiom,
    ( ~ esk9221_4(X1,X2,X3,X4)
    | ~ esk9195_4(X1,X2,X3,X4)
    | ~ esk9304_4(X1,X2,X3,X4) ) ).

cnf(i_0_504,axiom,
    ( esk11227_4(X1,X2,X3,X4)
    | esk11222_4(X1,X2,X3,X4)
    | ~ esk11223_4(X1,X2,X3,X4) ) ).

cnf(i_0_505,axiom,
    ( ~ esk11249_4(X1,X2,X3,X4)
    | ~ esk11295_4(X1,X2,X3,X4)
    | ~ esk11262_4(X1,X2,X3,X4) ) ).

cnf(i_0_506,axiom,
    ( ~ esk1994_4(X1,X2,X3,X4)
    | esk2036_4(X1,X2,X3,X4) ) ).

cnf(i_0_507,axiom,
    ( ~ esk11249_4(X1,X2,X3,X4)
    | ~ esk11307_4(X1,X2,X3,X4)
    | ~ esk11274_4(X1,X2,X3,X4) ) ).

cnf(i_0_508,axiom,
    ( ~ esk368_4(X1,X2,X3,X4)
    | esk398_4(X1,X2,X3,X4) ) ).

cnf(i_0_509,axiom,
    ( ~ esk1548_4(X1,X2,X3,X4)
    | esk1806_4(X1,X2,X3,X4) ) ).

cnf(i_0_510,axiom,
    ( esk1472_4(X1,X2,X3,X4)
    | esk1506_4(X1,X2,X3,X4) ) ).

cnf(i_0_511,axiom,
    ( ~ esk2178_4(X1,X2,X3,X4)
    | ~ esk2206_4(X1,X2,X3,X4) ) ).

cnf(i_0_512,axiom,
    ( ~ esk15035_4(X1,X2,X3,X4)
    | esk15154_4(X1,X2,X3,X4) ) ).

cnf(i_0_513,axiom,
    ( ~ esk3111_4(X1,X2,X3,X4)
    | ~ esk3085_4(X1,X2,X3,X4)
    | ~ esk3083_4(X1,X2,X3,X4)
    | ~ esk3113_4(X1,X2,X3,X4) ) ).

cnf(i_0_514,axiom,
    ( ~ p(X4)
    | esk509_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ esk212_0
    | ~ p(X2)
    | ~ p(X3) ) ).

cnf(i_0_515,axiom,
    ( esk12056_4(X1,X2,X3,X4)
    | esk12103_4(X1,X2,X3,X4)
    | ~ esk12140_4(X1,X2,X3,X4) ) ).

cnf(i_0_516,axiom,
    ( esk11319_4(X1,X2,X3,X4)
    | ~ esk11320_4(X1,X2,X3,X4) ) ).

cnf(i_0_517,axiom,
    ( esk6097_4(X1,X2,X3,X4)
    | esk6135_4(X1,X2,X3,X4) ) ).

cnf(i_0_518,axiom,
    ( ~ esk16213_4(X1,X2,X3,X4)
    | esk16250_4(X1,X2,X3,X4) ) ).

cnf(i_0_519,axiom,
    ( esk13273_4(X1,X2,X3,X4)
    | ~ esk13264_4(X1,X2,X3,X4) ) ).

cnf(i_0_520,axiom,
    ( esk834_4(X1,X2,X3,X4)
    | esk720_4(X1,X2,X3,X4) ) ).

cnf(i_0_521,axiom,
    ( ~ esk6406_4(X1,X2,X3,X4)
    | esk6307_4(X1,X2,X3,X4)
    | ~ esk6316_4(X1,X2,X3,X4) ) ).

cnf(i_0_522,axiom,
    ( ~ esk8107_4(X1,X2,X3,X4)
    | esk8079_4(X1,X2,X3,X4) ) ).

cnf(i_0_523,axiom,
    ( ~ esk8511_4(X1,X2,X3,X4)
    | ~ esk8509_4(X1,X2,X3,X4) ) ).

cnf(i_0_524,axiom,
    ( ~ esk1272_4(X1,X2,X3,X4)
    | esk1014_4(X1,X2,X3,X4) ) ).

cnf(i_0_525,axiom,
    ( ~ esk1356_4(X1,X2,X3,X4)
    | ~ esk1270_4(X1,X2,X3,X4)
    | ~ esk1321_4(X1,X2,X3,X4) ) ).

cnf(i_0_526,axiom,
    ( ~ esk7522_4(X1,X2,X3,X4)
    | ~ esk7396_4(X1,X2,X3,X4)
    | ~ esk7408_4(X1,X2,X3,X4) ) ).

cnf(i_0_527,axiom,
    ( esk12775_4(X1,X2,X3,X4)
    | esk12825_4(X1,X2,X3,X4) ) ).

cnf(i_0_528,axiom,
    ( esk8982_4(X1,X2,X3,X4)
    | esk8949_4(X1,X2,X3,X4) ) ).

cnf(i_0_529,axiom,
    ( ~ esk4005_4(X1,X2,X3,X4)
    | ~ esk3977_4(X1,X2,X3,X4) ) ).

cnf(i_0_530,axiom,
    ( esk4795_4(X1,X2,X3,X4)
    | ~ esk4796_4(X1,X2,X3,X4) ) ).

cnf(i_0_531,axiom,
    ( esk8422_4(X1,X2,X3,X4)
    | esk8453_4(X1,X2,X3,X4) ) ).

cnf(i_0_532,axiom,
    ( p(X4)
    | esk433_4(X1,X2,X3,X4)
    | p(X1)
    | p(X3)
    | ~ esk1_0
    | p(X2) ) ).

cnf(i_0_533,axiom,
    ( ~ esk9047_4(X1,X2,X3,X4)
    | ~ esk8996_4(X1,X2,X3,X4)
    | ~ esk9022_4(X1,X2,X3,X4) ) ).

cnf(i_0_534,axiom,
    ( ~ esk722_4(X1,X2,X3,X4)
    | ~ esk714_4(X1,X2,X3,X4)
    | ~ esk845_4(X1,X2,X3,X4) ) ).

cnf(i_0_535,axiom,
    ( ~ esk7090_4(X1,X2,X3,X4)
    | ~ esk7088_4(X1,X2,X3,X4) ) ).

cnf(i_0_536,axiom,
    ( ~ esk2230_4(X1,X2,X3,X4)
    | esk2229_4(X1,X2,X3,X4) ) ).

cnf(i_0_537,axiom,
    ( ~ esk5767_4(X1,X2,X3,X4)
    | esk5793_4(X1,X2,X3,X4) ) ).

cnf(i_0_538,axiom,
    ( ~ esk8424_4(X1,X2,X3,X4)
    | ~ esk8541_4(X1,X2,X3,X4)
    | ~ esk8454_4(X1,X2,X3,X4) ) ).

cnf(i_0_539,axiom,
    ( esk5087_4(X1,X2,X3,X4)
    | esk5079_4(X1,X2,X3,X4) ) ).

cnf(i_0_540,axiom,
    ( ~ esk9143_4(X1,X2,X3,X4)
    | esk9130_4(X1,X2,X3,X4)
    | ~ esk9255_4(X1,X2,X3,X4) ) ).

cnf(i_0_541,axiom,
    ( ~ esk11476_4(X1,X2,X3,X4)
    | esk11464_4(X1,X2,X3,X4)
    | esk11475_4(X1,X2,X3,X4) ) ).

cnf(i_0_542,axiom,
    ( ~ esk3057_4(X1,X2,X3,X4)
    | ~ esk3010_4(X1,X2,X3,X4)
    | ~ esk3056_4(X1,X2,X3,X4) ) ).

cnf(i_0_543,axiom,
    ( ~ esk15043_4(X1,X2,X3,X4)
    | esk15021_4(X1,X2,X3,X4) ) ).

cnf(i_0_544,axiom,
    ( ~ esk6841_4(X1,X2,X3,X4)
    | ~ esk6840_4(X1,X2,X3,X4) ) ).

cnf(i_0_545,axiom,
    ( esk14639_4(X1,X2,X3,X4)
    | ~ esk14897_4(X1,X2,X3,X4) ) ).

cnf(i_0_546,axiom,
    ( ~ esk1188_4(X1,X2,X3,X4)
    | ~ esk1187_4(X1,X2,X3,X4) ) ).

cnf(i_0_547,axiom,
    ( ~ esk14206_4(X1,X2,X3,X4)
    | ~ esk14120_4(X1,X2,X3,X4)
    | ~ esk14171_4(X1,X2,X3,X4) ) ).

cnf(i_0_548,axiom,
    ( ~ esk2546_4(X1,X2,X3,X4)
    | esk2804_4(X1,X2,X3,X4) ) ).

cnf(i_0_549,axiom,
    ( ~ esk13255_4(X1,X2,X3,X4)
    | esk13258_4(X1,X2,X3,X4) ) ).

cnf(i_0_550,axiom,
    ( esk5258_4(X1,X2,X3,X4)
    | ~ esk5320_4(X1,X2,X3,X4) ) ).

cnf(i_0_551,axiom,
    ( esk9110_4(X1,X2,X3,X4)
    | ~ esk9132_4(X1,X2,X3,X4) ) ).

cnf(i_0_552,axiom,
    ( esk16605_4(X1,X2,X3,X4)
    | ~ esk47_0
    | ~ p(X3)
    | ~ p(X1)
    | p(X4)
    | ~ p(X2) ) ).

cnf(i_0_553,axiom,
    ( esk16611_4(X1,X2,X3,X4)
    | esk16609_4(X1,X2,X3,X4) ) ).

cnf(i_0_554,axiom,
    ( esk5876_4(X1,X2,X3,X4)
    | esk5854_4(X1,X2,X3,X4) ) ).

cnf(i_0_555,axiom,
    ( esk581_4(X1,X2,X3,X4)
    | ~ esk580_4(X1,X2,X3,X4) ) ).

cnf(i_0_556,axiom,
    ( esk2037_4(X1,X2,X3,X4)
    | ~ esk1938_4(X1,X2,X3,X4) ) ).

cnf(i_0_557,axiom,
    ( ~ esk3367_4(X1,X2,X3,X4)
    | esk3395_4(X1,X2,X3,X4) ) ).

cnf(i_0_558,axiom,
    ( esk46_0
    | ~ p(X2)
    | ~ p(X4)
    | ~ esk16605_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X1) ) ).

cnf(i_0_559,axiom,
    ( esk15144_4(X1,X2,X3,X4)
    | ~ esk15045_4(X1,X2,X3,X4) ) ).

cnf(i_0_560,axiom,
    ( ~ esk2345_4(X1,X2,X3,X4)
    | esk2359_4(X1,X2,X3,X4) ) ).

cnf(i_0_561,axiom,
    ( ~ esk1525_4(X1,X2,X3,X4)
    | ~ esk1433_4(X1,X2,X3,X4)
    | esk1425_4(X1,X2,X3,X4) ) ).

cnf(i_0_562,axiom,
    ( esk6358_4(X1,X2,X3,X4)
    | esk6384_4(X1,X2,X3,X4) ) ).

cnf(i_0_563,axiom,
    ( esk15144_4(X1,X2,X3,X4)
    | esk15200_4(X1,X2,X3,X4) ) ).

cnf(i_0_564,axiom,
    ( esk1816_4(X1,X2,X3,X4)
    | ~ esk1659_4(X1,X2,X3,X4) ) ).

cnf(i_0_565,axiom,
    ( esk14357_4(X1,X2,X3,X4)
    | esk14442_4(X1,X2,X3,X4) ) ).

cnf(i_0_566,axiom,
    ( esk712_4(X1,X2,X3,X4)
    | esk737_4(X1,X2,X3,X4) ) ).

cnf(i_0_567,axiom,
    ( esk3089_4(X1,X2,X3,X4)
    | ~ esk2831_4(X1,X2,X3,X4) ) ).

cnf(i_0_568,axiom,
    ( ~ esk1639_4(X1,X2,X3,X4)
    | ~ esk1691_4(X1,X2,X3,X4)
    | ~ esk1638_4(X1,X2,X3,X4)
    | ~ esk1692_4(X1,X2,X3,X4)
    | ~ esk1641_4(X1,X2,X3,X4) ) ).

cnf(i_0_569,axiom,
    ( esk4101_4(X1,X2,X3,X4)
    | esk4146_4(X1,X2,X3,X4) ) ).

cnf(i_0_570,axiom,
    ( esk11372_4(X1,X2,X3,X4)
    | ~ esk11379_4(X1,X2,X3,X4)
    | esk11291_4(X1,X2,X3,X4) ) ).

cnf(i_0_571,axiom,
    ( esk14078_4(X1,X2,X3,X4)
    | esk14082_4(X1,X2,X3,X4) ) ).

cnf(i_0_572,axiom,
    ( esk4549_4(X1,X2,X3,X4)
    | esk4646_4(X1,X2,X3,X4)
    | esk4550_4(X1,X2,X3,X4) ) ).

cnf(i_0_573,axiom,
    ( esk9221_4(X1,X2,X3,X4)
    | esk9180_4(X1,X2,X3,X4) ) ).

cnf(i_0_574,axiom,
    ( esk7651_4(X1,X2,X3,X4)
    | esk7662_4(X1,X2,X3,X4) ) ).

cnf(i_0_575,axiom,
    ( ~ esk4888_4(X1,X2,X3,X4)
    | ~ esk4890_4(X1,X2,X3,X4)
    | ~ esk4908_4(X1,X2,X3,X4) ) ).

cnf(i_0_576,axiom,
    ( esk2704_4(X1,X2,X3,X4)
    | ~ esk2673_4(X1,X2,X3,X4) ) ).

cnf(i_0_577,axiom,
    ( esk5823_4(X1,X2,X3,X4)
    | ~ esk5824_4(X1,X2,X3,X4) ) ).

cnf(i_0_578,axiom,
    ( esk1752_4(X1,X2,X3,X4)
    | esk1742_4(X1,X2,X3,X4) ) ).

cnf(i_0_579,axiom,
    ( ~ esk12767_4(X1,X2,X3,X4)
    | esk12766_4(X1,X2,X3,X4) ) ).

cnf(i_0_580,axiom,
    ( ~ esk3572_4(X1,X2,X3,X4)
    | ~ esk3523_4(X1,X2,X3,X4)
    | ~ esk3573_4(X1,X2,X3,X4) ) ).

cnf(i_0_581,axiom,
    ( esk12082_4(X1,X2,X3,X4)
    | esk12049_4(X1,X2,X3,X4) ) ).

cnf(i_0_582,axiom,
    ( esk1778_4(X1,X2,X3,X4)
    | ~ esk1823_4(X1,X2,X3,X4) ) ).

cnf(i_0_583,axiom,
    ( esk10725_4(X1,X2,X3,X4)
    | esk10756_4(X1,X2,X3,X4) ) ).

cnf(i_0_584,axiom,
    ( esk4572_4(X1,X2,X3,X4)
    | esk4605_4(X1,X2,X3,X4) ) ).

cnf(i_0_585,axiom,
    ( ~ esk4879_4(X1,X2,X3,X4)
    | esk4813_4(X1,X2,X3,X4) ) ).

cnf(i_0_586,axiom,
    ( ~ esk7706_4(X1,X2,X3,X4)
    | esk7640_4(X1,X2,X3,X4) ) ).

cnf(i_0_587,axiom,
    ( esk6688_4(X1,X2,X3,X4)
    | ~ esk6946_4(X1,X2,X3,X4) ) ).

cnf(i_0_588,axiom,
    ( esk5665_4(X1,X2,X3,X4)
    | ~ esk5663_4(X1,X2,X3,X4)
    | ~ esk5664_4(X1,X2,X3,X4) ) ).

cnf(i_0_589,axiom,
    ( ~ esk4260_4(X1,X2,X3,X4)
    | esk4248_4(X1,X2,X3,X4)
    | ~ esk4374_4(X1,X2,X3,X4) ) ).

cnf(i_0_590,axiom,
    ( ~ esk519_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ p(X2)
    | p(X3)
    | esk284_0
    | p(X4) ) ).

cnf(i_0_591,axiom,
    ( esk12977_4(X1,X2,X3,X4)
    | ~ esk13029_4(X1,X2,X3,X4) ) ).

cnf(i_0_592,axiom,
    ( esk11273_4(X1,X2,X3,X4)
    | esk11238_4(X1,X2,X3,X4) ) ).

cnf(i_0_593,axiom,
    ( ~ esk12185_4(X1,X2,X3,X4)
    | esk12210_4(X1,X2,X3,X4) ) ).

cnf(i_0_594,axiom,
    ( esk14967_4(X1,X2,X3,X4)
    | esk14851_4(X1,X2,X3,X4) ) ).

cnf(i_0_595,axiom,
    ( esk7302_4(X1,X2,X3,X4)
    | ~ esk7327_4(X1,X2,X3,X4) ) ).

cnf(i_0_596,axiom,
    ( esk6712_4(X1,X2,X3,X4)
    | esk6710_4(X1,X2,X3,X4)
    | esk6711_4(X1,X2,X3,X4) ) ).

cnf(i_0_597,axiom,
    ( esk3667_4(X1,X2,X3,X4)
    | esk3553_4(X1,X2,X3,X4) ) ).

cnf(i_0_598,axiom,
    ( esk16434_4(X1,X2,X3,X4)
    | ~ esk16383_4(X1,X2,X3,X4) ) ).

cnf(i_0_599,axiom,
    ( p(X1)
    | ~ esk232_0
    | p(X4)
    | ~ p(X2)
    | esk16703_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_600,axiom,
    ( esk15294_4(X1,X2,X3,X4)
    | ~ esk15415_4(X1,X2,X3,X4)
    | ~ esk15311_4(X1,X2,X3,X4) ) ).

cnf(i_0_601,axiom,
    ( esk15234_4(X1,X2,X3,X4)
    | esk15148_4(X1,X2,X3,X4) ) ).

cnf(i_0_602,axiom,
    ( esk2045_4(X1,X2,X3,X4)
    | esk2012_4(X1,X2,X3,X4) ) ).

cnf(i_0_603,axiom,
    ( esk14146_4(X1,X2,X3,X4)
    | ~ esk14147_4(X1,X2,X3,X4) ) ).

cnf(i_0_604,axiom,
    ( ~ esk7268_4(X1,X2,X3,X4)
    | ~ esk7229_4(X1,X2,X3,X4) ) ).

cnf(i_0_605,axiom,
    ( ~ esk2806_4(X1,X2,X3,X4)
    | esk2866_4(X1,X2,X3,X4)
    | esk2889_4(X1,X2,X3,X4) ) ).

cnf(i_0_606,axiom,
    ( esk3055_4(X1,X2,X3,X4)
    | esk3140_4(X1,X2,X3,X4) ) ).

cnf(i_0_607,axiom,
    ( ~ esk10324_4(X1,X2,X3,X4)
    | esk10322_4(X1,X2,X3,X4) ) ).

cnf(i_0_608,axiom,
    ( ~ esk9556_4(X1,X2,X3,X4)
    | esk9502_4(X1,X2,X3,X4)
    | esk9540_4(X1,X2,X3,X4) ) ).

cnf(i_0_609,axiom,
    ( esk16217_4(X1,X2,X3,X4)
    | ~ esk16245_4(X1,X2,X3,X4)
    | esk16244_4(X1,X2,X3,X4) ) ).

cnf(i_0_610,axiom,
    ( esk12871_4(X1,X2,X3,X4)
    | esk12870_4(X1,X2,X3,X4) ) ).

cnf(i_0_611,axiom,
    ( ~ esk8019_4(X1,X2,X3,X4)
    | ~ esk7994_4(X1,X2,X3,X4)
    | ~ esk7968_4(X1,X2,X3,X4) ) ).

cnf(i_0_612,axiom,
    ( esk4565_4(X1,X2,X3,X4)
    | esk4573_4(X1,X2,X3,X4) ) ).

cnf(i_0_613,axiom,
    ( esk4884_4(X1,X2,X3,X4)
    | esk4851_4(X1,X2,X3,X4) ) ).

cnf(i_0_614,axiom,
    ( ~ esk9790_4(X1,X2,X3,X4)
    | ~ esk9743_4(X1,X2,X3,X4)
    | ~ esk9827_4(X1,X2,X3,X4) ) ).

cnf(i_0_615,axiom,
    ( esk12616_4(X1,X2,X3,X4)
    | esk12624_4(X1,X2,X3,X4)
    | esk12625_4(X1,X2,X3,X4) ) ).

cnf(i_0_616,axiom,
    ( ~ esk4342_4(X1,X2,X3,X4)
    | ~ esk4312_4(X1,X2,X3,X4)
    | ~ esk4429_4(X1,X2,X3,X4) ) ).

cnf(i_0_617,axiom,
    ( esk7455_4(X1,X2,X3,X4)
    | ~ esk7713_4(X1,X2,X3,X4) ) ).

cnf(i_0_618,axiom,
    ( esk12770_4(X1,X2,X3,X4)
    | ~ esk12768_4(X1,X2,X3,X4) ) ).

cnf(i_0_619,axiom,
    ( esk11309_4(X1,X2,X3,X4)
    | esk11337_4(X1,X2,X3,X4) ) ).

cnf(i_0_620,axiom,
    ( ~ esk1022_4(X1,X2,X3,X4)
    | esk1280_4(X1,X2,X3,X4) ) ).

cnf(i_0_621,axiom,
    ( ~ esk9656_4(X1,X2,X3,X4)
    | esk9776_4(X1,X2,X3,X4) ) ).

cnf(i_0_622,axiom,
    ( ~ esk8745_4(X1,X2,X3,X4)
    | ~ esk8629_4(X1,X2,X3,X4)
    | esk8624_4(X1,X2,X3,X4) ) ).

cnf(i_0_623,axiom,
    ( ~ esk10498_4(X1,X2,X3,X4)
    | ~ esk10480_4(X1,X2,X3,X4)
    | ~ esk10585_4(X1,X2,X3,X4) ) ).

cnf(i_0_624,axiom,
    ( ~ esk12368_4(X1,X2,X3,X4)
    | esk12382_4(X1,X2,X3,X4) ) ).

cnf(i_0_625,axiom,
    ( ~ esk13307_4(X1,X2,X3,X4)
    | ~ esk13323_4(X1,X2,X3,X4)
    | ~ esk13408_4(X1,X2,X3,X4) ) ).

cnf(i_0_626,axiom,
    ( esk9479_4(X1,X2,X3,X4)
    | esk9450_4(X1,X2,X3,X4) ) ).

cnf(i_0_627,axiom,
    ( esk4010_4(X1,X2,X3,X4)
    | esk4011_4(X1,X2,X3,X4) ) ).

cnf(i_0_628,axiom,
    ( ~ esk8681_4(X1,X2,X3,X4)
    | ~ esk8709_4(X1,X2,X3,X4)
    | ~ esk8794_4(X1,X2,X3,X4) ) ).

cnf(i_0_629,axiom,
    ( esk10387_4(X1,X2,X3,X4)
    | ~ esk10410_4(X1,X2,X3,X4) ) ).

cnf(i_0_630,axiom,
    ( ~ esk16455_4(X1,X2,X3,X4)
    | ~ esk16470_4(X1,X2,X3,X4) ) ).

cnf(i_0_631,axiom,
    ( ~ esk11088_4(X1,X2,X3,X4)
    | ~ esk11032_4(X1,X2,X3,X4) ) ).

cnf(i_0_632,axiom,
    ( ~ esk15961_4(X1,X2,X3,X4)
    | ~ esk15935_4(X1,X2,X3,X4)
    | ~ esk16004_4(X1,X2,X3,X4) ) ).

cnf(i_0_633,axiom,
    ( esk5888_4(X1,X2,X3,X4)
    | esk5972_4(X1,X2,X3,X4)
    | ~ esk5935_4(X1,X2,X3,X4) ) ).

cnf(i_0_634,axiom,
    ( esk4312_4(X1,X2,X3,X4)
    | esk4320_4(X1,X2,X3,X4) ) ).

cnf(i_0_635,axiom,
    ( ~ esk3369_4(X1,X2,X3,X4)
    | ~ esk3371_4(X1,X2,X3,X4) ) ).

cnf(i_0_636,axiom,
    ( ~ esk798_4(X1,X2,X3,X4)
    | ~ esk772_4(X1,X2,X3,X4)
    | ~ esk823_4(X1,X2,X3,X4) ) ).

cnf(i_0_637,axiom,
    ( esk5525_4(X1,X2,X3,X4)
    | ~ esk5545_4(X1,X2,X3,X4)
    | ~ esk5643_4(X1,X2,X3,X4) ) ).

cnf(i_0_638,axiom,
    ( ~ esk12771_4(X1,X2,X3,X4)
    | ~ esk12870_4(X1,X2,X3,X4) ) ).

cnf(i_0_639,axiom,
    ( ~ esk13547_4(X1,X2,X3,X4)
    | ~ esk13593_4(X1,X2,X3,X4)
    | ~ esk13594_4(X1,X2,X3,X4) ) ).

cnf(i_0_640,axiom,
    ( ~ esk4242_4(X1,X2,X3,X4)
    | esk4219_4(X1,X2,X3,X4) ) ).

cnf(i_0_641,axiom,
    ( ~ esk8165_4(X1,X2,X3,X4)
    | ~ esk8111_4(X1,X2,X3,X4) ) ).

cnf(i_0_642,axiom,
    ( esk2167_4(X1,X2,X3,X4)
    | ~ esk2197_4(X1,X2,X3,X4) ) ).

cnf(i_0_643,axiom,
    ( esk10309_4(X1,X2,X3,X4)
    | esk10307_4(X1,X2,X3,X4) ) ).

cnf(i_0_644,axiom,
    ( esk6182_4(X1,X2,X3,X4)
    | esk6189_4(X1,X2,X3,X4) ) ).

cnf(i_0_645,axiom,
    ( esk3138_4(X1,X2,X3,X4)
    | ~ esk3137_4(X1,X2,X3,X4) ) ).

cnf(i_0_646,axiom,
    ( ~ esk13872_4(X1,X2,X3,X4)
    | esk14130_4(X1,X2,X3,X4) ) ).

cnf(i_0_647,axiom,
    ( esk10276_4(X1,X2,X3,X4)
    | ~ esk10534_4(X1,X2,X3,X4) ) ).

cnf(i_0_648,axiom,
    ( esk14626_4(X1,X2,X3,X4)
    | ~ esk14673_4(X1,X2,X3,X4)
    | esk14710_4(X1,X2,X3,X4) ) ).

cnf(i_0_649,axiom,
    ( esk7650_4(X1,X2,X3,X4)
    | ~ esk7686_4(X1,X2,X3,X4) ) ).

cnf(i_0_650,axiom,
    ( esk4608_4(X1,X2,X3,X4)
    | ~ esk4866_4(X1,X2,X3,X4) ) ).

cnf(i_0_651,axiom,
    ( p(X2)
    | ~ esk4_0
    | esk410_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1)
    | p(X4) ) ).

cnf(i_0_652,axiom,
    ( ~ esk16220_4(X1,X2,X3,X4)
    | esk16219_4(X1,X2,X3,X4)
    | esk16241_4(X1,X2,X3,X4) ) ).

cnf(i_0_653,axiom,
    ( esk4336_4(X1,X2,X3,X4)
    | esk4442_4(X1,X2,X3,X4) ) ).

cnf(i_0_654,axiom,
    ( esk8482_4(X1,X2,X3,X4)
    | esk8508_4(X1,X2,X3,X4)
    | ~ esk8533_4(X1,X2,X3,X4) ) ).

cnf(i_0_655,axiom,
    ( ~ esk13513_4(X1,X2,X3,X4)
    | ~ esk13511_4(X1,X2,X3,X4) ) ).

cnf(i_0_656,axiom,
    ( esk8862_4(X1,X2,X3,X4)
    | esk8887_4(X1,X2,X3,X4)
    | esk8885_4(X1,X2,X3,X4) ) ).

cnf(i_0_657,axiom,
    ( esk7883_4(X1,X2,X3,X4)
    | ~ esk7884_4(X1,X2,X3,X4) ) ).

cnf(i_0_658,axiom,
    ( esk12560_4(X1,X2,X3,X4)
    | esk12536_4(X1,X2,X3,X4) ) ).

cnf(i_0_659,axiom,
    ( esk14841_4(X1,X2,X3,X4)
    | ~ esk14892_4(X1,X2,X3,X4) ) ).

cnf(i_0_660,axiom,
    ( esk15469_4(X1,X2,X3,X4)
    | ~ esk15415_4(X1,X2,X3,X4)
    | esk15450_4(X1,X2,X3,X4) ) ).

cnf(i_0_661,axiom,
    ( esk5340_4(X1,X2,X3,X4)
    | esk5356_4(X1,X2,X3,X4) ) ).

cnf(i_0_662,axiom,
    ( ~ esk14648_4(X1,X2,X3,X4)
    | esk14700_4(X1,X2,X3,X4)
    | esk14719_4(X1,X2,X3,X4) ) ).

cnf(i_0_663,axiom,
    ( ~ esk2557_4(X1,X2,X3,X4)
    | esk2299_4(X1,X2,X3,X4) ) ).

cnf(i_0_664,axiom,
    ( ~ esk7397_4(X1,X2,X3,X4)
    | ~ esk7430_4(X1,X2,X3,X4)
    | ~ esk7394_4(X1,X2,X3,X4) ) ).

cnf(i_0_665,axiom,
    ( esk3854_4(X1,X2,X3,X4)
    | ~ esk3596_4(X1,X2,X3,X4) ) ).

cnf(i_0_666,axiom,
    ( esk14926_4(X1,X2,X3,X4)
    | ~ esk14668_4(X1,X2,X3,X4) ) ).

cnf(i_0_667,axiom,
    ( esk2901_4(X1,X2,X3,X4)
    | esk2778_4(X1,X2,X3,X4) ) ).

cnf(i_0_668,axiom,
    ( ~ esk6407_4(X1,X2,X3,X4)
    | esk6665_4(X1,X2,X3,X4) ) ).

cnf(i_0_669,axiom,
    ( ~ esk11207_4(X1,X2,X3,X4)
    | esk11219_4(X1,X2,X3,X4) ) ).

cnf(i_0_670,axiom,
    ( esk11206_4(X1,X2,X3,X4)
    | ~ esk10948_4(X1,X2,X3,X4) ) ).

cnf(i_0_671,axiom,
    ( ~ esk12868_4(X1,X2,X3,X4)
    | esk12869_4(X1,X2,X3,X4) ) ).

cnf(i_0_672,axiom,
    ( esk16760_4(X1,X2,X3,X4)
    | ~ esk16761_4(X1,X2,X3,X4) ) ).

cnf(i_0_673,axiom,
    ( esk6846_4(X1,X2,X3,X4)
    | ~ esk6845_4(X1,X2,X3,X4) ) ).

cnf(i_0_674,axiom,
    ( esk13011_4(X1,X2,X3,X4)
    | esk13009_4(X1,X2,X3,X4)
    | ~ esk13015_4(X1,X2,X3,X4) ) ).

cnf(i_0_675,axiom,
    ( ~ esk11506_4(X1,X2,X3,X4)
    | ~ esk11537_4(X1,X2,X3,X4)
    | ~ esk11570_4(X1,X2,X3,X4) ) ).

cnf(i_0_676,axiom,
    ( ~ esk6786_4(X1,X2,X3,X4)
    | esk6815_4(X1,X2,X3,X4) ) ).

cnf(i_0_677,axiom,
    ( p(X2)
    | esk282_0
    | ~ esk16709_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X3)
    | ~ p(X4) ) ).

cnf(i_0_678,axiom,
    ( ~ p(X2)
    | ~ p(X3)
    | p(X4)
    | p(X1)
    | esk293_0
    | ~ esk521_4(X1,X2,X3,X4) ) ).

cnf(i_0_679,axiom,
    ( esk13039_4(X1,X2,X3,X4)
    | ~ esk13099_4(X1,X2,X3,X4) ) ).

cnf(i_0_680,axiom,
    ( ~ esk8028_4(X1,X2,X3,X4)
    | ~ esk7944_4(X1,X2,X3,X4)
    | ~ esk7991_4(X1,X2,X3,X4) ) ).

cnf(i_0_681,axiom,
    ( esk4593_4(X1,X2,X3,X4)
    | esk4699_4(X1,X2,X3,X4) ) ).

cnf(i_0_682,axiom,
    ( ~ esk1800_4(X1,X2,X3,X4)
    | ~ esk1826_4(X1,X2,X3,X4)
    | ~ esk1851_4(X1,X2,X3,X4) ) ).

cnf(i_0_683,axiom,
    ( ~ esk13677_4(X1,X2,X3,X4)
    | esk13675_4(X1,X2,X3,X4) ) ).

cnf(i_0_684,axiom,
    esk10168_4(X1,X2,X3,X4) ).

cnf(i_0_685,axiom,
    ( esk12144_4(X1,X2,X3,X4)
    | esk12032_4(X1,X2,X3,X4) ) ).

cnf(i_0_686,axiom,
    ( ~ esk10301_4(X1,X2,X3,X4)
    | ~ esk10148_4(X1,X2,X3,X4)
    | ~ esk10294_4(X1,X2,X3,X4) ) ).

cnf(i_0_687,axiom,
    ( ~ p(X1)
    | ~ p(X3)
    | esk17_0
    | p(X4)
    | ~ esk16600_4(X1,X2,X3,X4)
    | ~ p(X2) ) ).

cnf(i_0_688,axiom,
    ( esk9672_4(X1,X2,X3,X4)
    | esk9667_4(X1,X2,X3,X4)
    | ~ esk9673_4(X1,X2,X3,X4) ) ).

cnf(i_0_689,axiom,
    ( ~ esk8774_4(X1,X2,X3,X4)
    | ~ esk8773_4(X1,X2,X3,X4) ) ).

cnf(i_0_690,axiom,
    ( esk1552_4(X1,X2,X3,X4)
    | ~ esk1432_4(X1,X2,X3,X4) ) ).

cnf(i_0_691,axiom,
    ( esk4501_4(X1,X2,X3,X4)
    | ~ esk4623_4(X1,X2,X3,X4)
    | ~ esk4517_4(X1,X2,X3,X4) ) ).

cnf(i_0_692,axiom,
    ( esk3131_4(X1,X2,X3,X4)
    | ~ esk3132_4(X1,X2,X3,X4) ) ).

cnf(i_0_693,axiom,
    ( esk11262_4(X1,X2,X3,X4)
    | esk11249_4(X1,X2,X3,X4) ) ).

cnf(i_0_694,axiom,
    ( esk4406_4(X1,X2,X3,X4)
    | esk4350_4(X1,X2,X3,X4) ) ).

cnf(i_0_695,axiom,
    ( esk15058_4(X1,X2,X3,X4)
    | ~ esk15080_4(X1,X2,X3,X4) ) ).

cnf(i_0_696,axiom,
    ( esk8152_4(X1,X2,X3,X4)
    | esk8193_4(X1,X2,X3,X4) ) ).

cnf(i_0_697,axiom,
    ( ~ esk2871_4(X1,X2,X3,X4)
    | esk2869_4(X1,X2,X3,X4) ) ).

cnf(i_0_698,axiom,
    ( ~ esk13369_4(X1,X2,X3,X4)
    | esk13243_4(X1,X2,X3,X4)
    | ~ esk13255_4(X1,X2,X3,X4) ) ).

cnf(i_0_699,axiom,
    ( ~ esk3364_4(X1,X2,X3,X4)
    | ~ esk3382_4(X1,X2,X3,X4) ) ).

cnf(i_0_700,axiom,
    ( esk7177_4(X1,X2,X3,X4)
    | esk7233_4(X1,X2,X3,X4) ) ).

cnf(i_0_701,axiom,
    ( esk11882_4(X1,X2,X3,X4)
    | ~ esk11880_4(X1,X2,X3,X4)
    | ~ esk11881_4(X1,X2,X3,X4) ) ).

cnf(i_0_702,axiom,
    ( esk11323_4(X1,X2,X3,X4)
    | ~ esk11324_4(X1,X2,X3,X4)
    | esk11322_4(X1,X2,X3,X4) ) ).

cnf(i_0_703,axiom,
    ( esk1183_4(X1,X2,X3,X4)
    | ~ esk925_4(X1,X2,X3,X4) ) ).

cnf(i_0_704,axiom,
    ( ~ esk5782_4(X1,X2,X3,X4)
    | esk5763_4(X1,X2,X3,X4) ) ).

cnf(i_0_705,axiom,
    ( ~ esk2070_4(X1,X2,X3,X4)
    | ~ esk2077_4(X1,X2,X3,X4)
    | ~ esk1924_4(X1,X2,X3,X4) ) ).

cnf(i_0_706,axiom,
    ( ~ esk3888_4(X1,X2,X3,X4)
    | ~ esk3844_4(X1,X2,X3,X4)
    | ~ esk3889_4(X1,X2,X3,X4) ) ).

cnf(i_0_707,axiom,
    ( p(X3)
    | ~ p(X2)
    | esk195_0
    | ~ esk507_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_708,axiom,
    ( esk4267_4(X1,X2,X3,X4)
    | esk4268_4(X1,X2,X3,X4) ) ).

cnf(i_0_709,axiom,
    ( ~ esk10254_4(X1,X2,X3,X4)
    | ~ esk10205_4(X1,X2,X3,X4)
    | ~ esk10255_4(X1,X2,X3,X4) ) ).

cnf(i_0_710,axiom,
    ( esk5173_4(X1,X2,X3,X4)
    | ~ esk5129_4(X1,X2,X3,X4)
    | esk5180_4(X1,X2,X3,X4) ) ).

cnf(i_0_711,axiom,
    ( esk12530_4(X1,X2,X3,X4)
    | ~ esk12575_4(X1,X2,X3,X4) ) ).

cnf(i_0_712,axiom,
    ( esk10235_4(X1,X2,X3,X4)
    | esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_713,axiom,
    ( ~ esk5933_4(X1,X2,X3,X4)
    | ~ esk5918_4(X1,X2,X3,X4) ) ).

cnf(i_0_714,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12215_4(X1,X2,X3,X4) ) ).

cnf(i_0_715,axiom,
    ( ~ esk1422_4(X1,X2,X3,X4)
    | esk1433_4(X1,X2,X3,X4) ) ).

cnf(i_0_716,axiom,
    ( esk7174_4(X1,X2,X3,X4)
    | ~ esk7432_4(X1,X2,X3,X4) ) ).

cnf(i_0_717,axiom,
    ( esk4292_4(X1,X2,X3,X4)
    | ~ esk4256_4(X1,X2,X3,X4) ) ).

cnf(i_0_718,axiom,
    ( esk9549_4(X1,X2,X3,X4)
    | esk9466_4(X1,X2,X3,X4) ) ).

cnf(i_0_719,axiom,
    ( esk14461_4(X1,X2,X3,X4)
    | esk14347_4(X1,X2,X3,X4) ) ).

cnf(i_0_720,axiom,
    ( esk6370_4(X1,X2,X3,X4)
    | esk6368_4(X1,X2,X3,X4) ) ).

cnf(i_0_721,axiom,
    ( esk11343_4(X1,X2,X3,X4)
    | esk11295_4(X1,X2,X3,X4) ) ).

cnf(i_0_722,axiom,
    ( ~ esk7518_4(X1,X2,X3,X4)
    | ~ esk7489_4(X1,X2,X3,X4)
    | ~ esk7438_4(X1,X2,X3,X4) ) ).

cnf(i_0_723,axiom,
    ( esk9974_4(X1,X2,X3,X4)
    | esk9960_4(X1,X2,X3,X4) ) ).

cnf(i_0_724,axiom,
    ( esk9931_4(X1,X2,X3,X4)
    | ~ esk9927_4(X1,X2,X3,X4) ) ).

cnf(i_0_725,axiom,
    ( ~ esk6734_4(X1,X2,X3,X4)
    | esk6709_4(X1,X2,X3,X4)
    | esk6683_4(X1,X2,X3,X4) ) ).

cnf(i_0_726,axiom,
    ( esk7774_4(X1,X2,X3,X4)
    | esk7781_4(X1,X2,X3,X4)
    | ~ esk7693_4(X1,X2,X3,X4) ) ).

cnf(i_0_727,axiom,
    ( ~ esk2039_4(X1,X2,X3,X4)
    | esk2127_4(X1,X2,X3,X4)
    | esk2120_4(X1,X2,X3,X4) ) ).

cnf(i_0_728,axiom,
    ( esk5569_4(X1,X2,X3,X4)
    | ~ esk5571_4(X1,X2,X3,X4) ) ).

cnf(i_0_729,axiom,
    ( esk7397_4(X1,X2,X3,X4)
    | esk7394_4(X1,X2,X3,X4) ) ).

cnf(i_0_730,axiom,
    ( ~ esk12979_4(X1,X2,X3,X4)
    | esk13098_4(X1,X2,X3,X4) ) ).

cnf(i_0_731,axiom,
    ( esk16369_4(X1,X2,X3,X4)
    | esk16468_4(X1,X2,X3,X4)
    | esk16461_4(X1,X2,X3,X4) ) ).

cnf(i_0_732,axiom,
    ( ~ esk921_4(X1,X2,X3,X4)
    | ~ esk894_4(X1,X2,X3,X4) ) ).

cnf(i_0_733,axiom,
    ( esk7381_4(X1,X2,X3,X4)
    | ~ esk7453_4(X1,X2,X3,X4) ) ).

cnf(i_0_734,axiom,
    ( ~ esk8657_4(X1,X2,X3,X4)
    | esk8399_4(X1,X2,X3,X4) ) ).

cnf(i_0_735,axiom,
    ( ~ esk9947_4(X1,X2,X3,X4)
    | ~ esk10036_4(X1,X2,X3,X4) ) ).

cnf(i_0_736,axiom,
    ( esk737_4(X1,X2,X3,X4)
    | esk770_4(X1,X2,X3,X4) ) ).

cnf(i_0_737,axiom,
    ( esk14914_4(X1,X2,X3,X4)
    | esk14919_4(X1,X2,X3,X4)
    | ~ esk14915_4(X1,X2,X3,X4) ) ).

cnf(i_0_738,axiom,
    ( esk16685_4(X1,X2,X3,X4)
    | ~ esk16643_4(X1,X2,X3,X4) ) ).

cnf(i_0_739,axiom,
    ( esk6973_4(X1,X2,X3,X4)
    | esk6972_4(X1,X2,X3,X4) ) ).

cnf(i_0_740,axiom,
    ( esk5896_4(X1,X2,X3,X4)
    | esk5949_4(X1,X2,X3,X4) ) ).

cnf(i_0_741,axiom,
    ( ~ esk11076_4(X1,X2,X3,X4)
    | esk11106_4(X1,X2,X3,X4) ) ).

cnf(i_0_742,axiom,
    ( p(X2)
    | esk16709_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X3)
    | ~ esk282_0
    | ~ p(X1) ) ).

cnf(i_0_743,axiom,
    ( ~ esk16774_4(X1,X2,X3,X4)
    | esk16773_4(X1,X2,X3,X4) ) ).

cnf(i_0_744,axiom,
    ( esk13514_4(X1,X2,X3,X4)
    | esk13513_4(X1,X2,X3,X4) ) ).

cnf(i_0_745,axiom,
    ( ~ esk12448_4(X1,X2,X3,X4)
    | esk12476_4(X1,X2,X3,X4) ) ).

cnf(i_0_746,axiom,
    ( esk3750_4(X1,X2,X3,X4)
    | ~ esk4008_4(X1,X2,X3,X4) ) ).

cnf(i_0_747,axiom,
    ( esk6593_4(X1,X2,X3,X4)
    | ~ esk6595_4(X1,X2,X3,X4) ) ).

cnf(i_0_748,axiom,
    ( esk16365_4(X1,X2,X3,X4)
    | ~ esk16343_4(X1,X2,X3,X4) ) ).

cnf(i_0_749,axiom,
    ( esk8953_4(X1,X2,X3,X4)
    | esk8986_4(X1,X2,X3,X4) ) ).

cnf(i_0_750,axiom,
    ( ~ esk5592_4(X1,X2,X3,X4)
    | esk5634_4(X1,X2,X3,X4) ) ).

cnf(i_0_751,axiom,
    ( esk4407_4(X1,X2,X3,X4)
    | esk4406_4(X1,X2,X3,X4)
    | ~ esk4432_4(X1,X2,X3,X4) ) ).

cnf(i_0_752,axiom,
    ( ~ esk6889_4(X1,X2,X3,X4)
    | ~ esk6922_4(X1,X2,X3,X4)
    | ~ esk6880_4(X1,X2,X3,X4) ) ).

cnf(i_0_753,axiom,
    ( esk5344_4(X1,X2,X3,X4)
    | esk5459_4(X1,X2,X3,X4) ) ).

cnf(i_0_754,axiom,
    ( esk12498_4(X1,X2,X3,X4)
    | esk12503_4(X1,X2,X3,X4) ) ).

cnf(i_0_755,axiom,
    ( ~ esk15794_4(X1,X2,X3,X4)
    | esk15951_4(X1,X2,X3,X4) ) ).

cnf(i_0_756,axiom,
    ( ~ esk7450_4(X1,X2,X3,X4)
    | ~ esk7481_4(X1,X2,X3,X4) ) ).

cnf(i_0_757,axiom,
    ( esk3806_4(X1,X2,X3,X4)
    | esk3798_4(X1,X2,X3,X4) ) ).

cnf(i_0_758,axiom,
    ( ~ esk14788_4(X1,X2,X3,X4)
    | esk14762_4(X1,X2,X3,X4) ) ).

cnf(i_0_759,axiom,
    ( ~ esk12375_4(X1,X2,X3,X4)
    | ~ esk12374_4(X1,X2,X3,X4) ) ).

cnf(i_0_760,axiom,
    ( esk8435_4(X1,X2,X3,X4)
    | esk8468_4(X1,X2,X3,X4) ) ).

cnf(i_0_761,axiom,
    ( esk3130_4(X1,X2,X3,X4)
    | ~ esk3132_4(X1,X2,X3,X4) ) ).

cnf(i_0_762,axiom,
    ( esk501_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X3)
    | p(X4)
    | ~ esk143_0
    | p(X1) ) ).

cnf(i_0_763,axiom,
    ( ~ esk13133_4(X1,X2,X3,X4)
    | ~ esk13110_4(X1,X2,X3,X4) ) ).

cnf(i_0_764,axiom,
    ( esk574_4(X1,X2,X3,X4)
    | ~ esk572_4(X1,X2,X3,X4)
    | ~ esk573_4(X1,X2,X3,X4) ) ).

cnf(i_0_765,axiom,
    ( ~ esk3072_4(X1,X2,X3,X4)
    | esk3018_4(X1,X2,X3,X4) ) ).

cnf(i_0_766,axiom,
    ( esk5910_4(X1,X2,X3,X4)
    | esk5962_4(X1,X2,X3,X4)
    | ~ esk5981_4(X1,X2,X3,X4) ) ).

cnf(i_0_767,axiom,
    ( ~ esk4957_4(X1,X2,X3,X4)
    | ~ esk4947_4(X1,X2,X3,X4) ) ).

cnf(i_0_768,axiom,
    ( esk15397_4(X1,X2,X3,X4)
    | ~ esk15139_4(X1,X2,X3,X4) ) ).

cnf(i_0_769,axiom,
    ( ~ esk3895_4(X1,X2,X3,X4)
    | esk3844_4(X1,X2,X3,X4)
    | esk3888_4(X1,X2,X3,X4) ) ).

cnf(i_0_770,axiom,
    ( esk14940_4(X1,X2,X3,X4)
    | ~ esk14974_4(X1,X2,X3,X4)
    | esk14893_4(X1,X2,X3,X4) ) ).

cnf(i_0_771,axiom,
    ( ~ esk16624_4(X1,X2,X3,X4)
    | esk16620_4(X1,X2,X3,X4) ) ).

cnf(i_0_772,axiom,
    ( ~ esk462_4(X1,X2,X3,X4)
    | ~ esk455_4(X1,X2,X3,X4)
    | ~ esk495_4(X1,X2,X3,X4) ) ).

cnf(i_0_773,axiom,
    ( esk15908_4(X1,X2,X3,X4)
    | esk15875_4(X1,X2,X3,X4) ) ).

cnf(i_0_774,axiom,
    ( ~ esk2212_4(X1,X2,X3,X4)
    | ~ esk2216_4(X1,X2,X3,X4) ) ).

cnf(i_0_775,axiom,
    ( esk1991_4(X1,X2,X3,X4)
    | ~ esk2042_4(X1,X2,X3,X4) ) ).

cnf(i_0_776,axiom,
    ( esk16117_4(X1,X2,X3,X4)
    | esk16164_4(X1,X2,X3,X4) ) ).

cnf(i_0_777,axiom,
    ( esk14891_4(X1,X2,X3,X4)
    | esk14971_4(X1,X2,X3,X4)
    | ~ esk14942_4(X1,X2,X3,X4) ) ).

cnf(i_0_778,axiom,
    ( esk11796_4(X1,X2,X3,X4)
    | esk11829_4(X1,X2,X3,X4) ) ).

cnf(i_0_779,axiom,
    ( ~ esk10750_4(X1,X2,X3,X4)
    | ~ esk10783_4(X1,X2,X3,X4)
    | ~ esk10735_4(X1,X2,X3,X4) ) ).

cnf(i_0_780,axiom,
    ( esk13293_4(X1,X2,X3,X4)
    | ~ esk13362_4(X1,X2,X3,X4) ) ).

cnf(i_0_781,axiom,
    ( ~ esk7640_4(X1,X2,X3,X4)
    | ~ esk7674_4(X1,X2,X3,X4)
    | ~ esk7675_4(X1,X2,X3,X4) ) ).

cnf(i_0_782,axiom,
    ( ~ esk10723_4(X1,X2,X3,X4)
    | ~ esk10761_4(X1,X2,X3,X4)
    | ~ esk10760_4(X1,X2,X3,X4) ) ).

cnf(i_0_783,axiom,
    ( ~ esk2754_4(X1,X2,X3,X4)
    | esk2829_4(X1,X2,X3,X4) ) ).

cnf(i_0_784,axiom,
    ( ~ esk1677_4(X1,X2,X3,X4)
    | esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_785,axiom,
    ( esk9093_4(X1,X2,X3,X4)
    | esk9145_4(X1,X2,X3,X4)
    | esk9117_4(X1,X2,X3,X4)
    | esk9118_4(X1,X2,X3,X4)
    | esk9115_4(X1,X2,X3,X4) ) ).

cnf(i_0_786,axiom,
    ( esk7830_4(X1,X2,X3,X4)
    | esk7833_4(X1,X2,X3,X4)
    | esk7808_4(X1,X2,X3,X4)
    | esk7860_4(X1,X2,X3,X4)
    | esk7832_4(X1,X2,X3,X4) ) ).

cnf(i_0_787,axiom,
    ( esk13904_4(X1,X2,X3,X4)
    | esk13881_4(X1,X2,X3,X4) ) ).

cnf(i_0_788,axiom,
    ( ~ esk4093_4(X1,X2,X3,X4)
    | ~ esk4149_4(X1,X2,X3,X4) ) ).

cnf(i_0_789,axiom,
    ( ~ esk9480_4(X1,X2,X3,X4)
    | ~ esk9436_4(X1,X2,X3,X4)
    | ~ esk9479_4(X1,X2,X3,X4) ) ).

cnf(i_0_790,axiom,
    ( esk1601_4(X1,X2,X3,X4)
    | ~ esk1547_4(X1,X2,X3,X4) ) ).

cnf(i_0_791,axiom,
    ( esk12502_4(X1,X2,X3,X4)
    | ~ esk12500_4(X1,X2,X3,X4)
    | ~ esk12501_4(X1,X2,X3,X4) ) ).

cnf(i_0_792,axiom,
    ( esk3514_4(X1,X2,X3,X4)
    | ~ esk3515_4(X1,X2,X3,X4) ) ).

cnf(i_0_793,axiom,
    ( ~ esk7129_4(X1,X2,X3,X4)
    | esk7186_4(X1,X2,X3,X4) ) ).

cnf(i_0_794,axiom,
    ( ~ esk3328_4(X1,X2,X3,X4)
    | ~ esk3232_4(X1,X2,X3,X4)
    | esk3226_4(X1,X2,X3,X4) ) ).

cnf(i_0_795,axiom,
    ( esk3794_4(X1,X2,X3,X4)
    | ~ esk3833_4(X1,X2,X3,X4) ) ).

cnf(i_0_796,axiom,
    ( esk15672_4(X1,X2,X3,X4)
    | ~ esk15551_4(X1,X2,X3,X4) ) ).

cnf(i_0_797,axiom,
    ( ~ esk4694_4(X1,X2,X3,X4)
    | ~ esk4693_4(X1,X2,X3,X4)
    | esk4695_4(X1,X2,X3,X4) ) ).

cnf(i_0_798,axiom,
    ( esk15663_4(X1,X2,X3,X4)
    | ~ esk15921_4(X1,X2,X3,X4) ) ).

cnf(i_0_799,axiom,
    ( ~ esk4883_4(X1,X2,X3,X4)
    | esk4811_4(X1,X2,X3,X4) ) ).

cnf(i_0_800,axiom,
    ( ~ esk13618_4(X1,X2,X3,X4)
    | ~ esk13649_4(X1,X2,X3,X4) ) ).

cnf(i_0_801,axiom,
    ( ~ esk9752_4(X1,X2,X3,X4)
    | esk10010_4(X1,X2,X3,X4) ) ).

cnf(i_0_802,axiom,
    ( ~ esk10433_4(X1,X2,X3,X4)
    | esk10175_4(X1,X2,X3,X4) ) ).

cnf(i_0_803,axiom,
    ( ~ esk13360_4(X1,X2,X3,X4)
    | esk13618_4(X1,X2,X3,X4) ) ).

cnf(i_0_804,axiom,
    ( esk9945_4(X1,X2,X3,X4)
    | esk10036_4(X1,X2,X3,X4) ) ).

cnf(i_0_805,axiom,
    ( ~ esk14681_4(X1,X2,X3,X4)
    | ~ esk14642_4(X1,X2,X3,X4) ) ).

cnf(i_0_806,axiom,
    ( esk5854_4(X1,X2,X3,X4)
    | esk5884_4(X1,X2,X3,X4) ) ).

cnf(i_0_807,axiom,
    ( ~ esk11495_4(X1,X2,X3,X4)
    | esk11561_4(X1,X2,X3,X4) ) ).

cnf(i_0_808,axiom,
    ( esk4607_4(X1,X2,X3,X4)
    | ~ esk4508_4(X1,X2,X3,X4) ) ).

cnf(i_0_809,axiom,
    ( esk4244_4(X1,X2,X3,X4)
    | ~ esk4366_4(X1,X2,X3,X4)
    | ~ esk4260_4(X1,X2,X3,X4) ) ).

cnf(i_0_810,axiom,
    ( esk16196_4(X1,X2,X3,X4)
    | ~ esk16070_4(X1,X2,X3,X4) ) ).

cnf(i_0_811,axiom,
    ( ~ esk9516_4(X1,X2,X3,X4)
    | esk9258_4(X1,X2,X3,X4) ) ).

cnf(i_0_812,axiom,
    ( ~ esk9634_4(X1,X2,X3,X4)
    | ~ esk9780_4(X1,X2,X3,X4)
    | ~ esk9787_4(X1,X2,X3,X4) ) ).

cnf(i_0_813,axiom,
    ( esk2507_4(X1,X2,X3,X4)
    | esk2521_4(X1,X2,X3,X4) ) ).

cnf(i_0_814,axiom,
    ( esk13489_4(X1,X2,X3,X4)
    | esk13635_4(X1,X2,X3,X4) ) ).

cnf(i_0_815,axiom,
    ( esk14371_4(X1,X2,X3,X4)
    | ~ esk14273_4(X1,X2,X3,X4) ) ).

cnf(i_0_816,axiom,
    ( ~ esk13082_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4)
    | ~ esk13129_4(X1,X2,X3,X4) ) ).

cnf(i_0_817,axiom,
    ( esk1907_4(X1,X2,X3,X4)
    | ~ esk1928_4(X1,X2,X3,X4) ) ).

cnf(i_0_818,axiom,
    ( ~ p(X4)
    | p(X3)
    | p(X1)
    | esk128_0
    | ~ esk16689_4(X1,X2,X3,X4)
    | ~ p(X2) ) ).

cnf(i_0_819,axiom,
    ( esk13035_4(X1,X2,X3,X4)
    | esk13076_4(X1,X2,X3,X4) ) ).

cnf(i_0_820,axiom,
    ( esk1655_4(X1,X2,X3,X4)
    | ~ esk1681_4(X1,X2,X3,X4) ) ).

cnf(i_0_821,axiom,
    ( esk12250_4(X1,X2,X3,X4)
    | esk12255_4(X1,X2,X3,X4)
    | ~ esk12251_4(X1,X2,X3,X4) ) ).

cnf(i_0_822,axiom,
    ( esk3284_4(X1,X2,X3,X4)
    | esk3290_4(X1,X2,X3,X4) ) ).

cnf(i_0_823,axiom,
    ( ~ esk8097_4(X1,X2,X3,X4)
    | esk8074_4(X1,X2,X3,X4) ) ).

cnf(i_0_824,axiom,
    ( esk12184_4(X1,X2,X3,X4)
    | ~ esk12211_4(X1,X2,X3,X4) ) ).

cnf(i_0_825,axiom,
    ( ~ esk28_0
    | ~ p(X1)
    | ~ p(X3)
    | esk16602_4(X1,X2,X3,X4)
    | p(X4)
    | p(X2) ) ).

cnf(i_0_826,axiom,
    ( ~ esk6903_4(X1,X2,X3,X4)
    | ~ esk6904_4(X1,X2,X3,X4)
    | ~ esk6869_4(X1,X2,X3,X4) ) ).

cnf(i_0_827,axiom,
    ( esk5272_4(X1,X2,X3,X4)
    | ~ esk5245_4(X1,X2,X3,X4) ) ).

cnf(i_0_828,axiom,
    ( esk15094_4(X1,X2,X3,X4)
    | ~ esk15157_4(X1,X2,X3,X4) ) ).

cnf(i_0_829,axiom,
    ( esk9514_4(X1,X2,X3,X4)
    | ~ esk9256_4(X1,X2,X3,X4) ) ).

cnf(i_0_830,axiom,
    ( ~ esk12279_4(X1,X2,X3,X4)
    | ~ esk12297_4(X1,X2,X3,X4)
    | ~ esk12384_4(X1,X2,X3,X4) ) ).

cnf(i_0_831,axiom,
    ( ~ esk587_4(X1,X2,X3,X4)
    | ~ esk481_4(X1,X2,X3,X4)
    | ~ esk457_4(X1,X2,X3,X4) ) ).

cnf(i_0_832,axiom,
    ( ~ esk14688_4(X1,X2,X3,X4)
    | ~ esk14687_4(X1,X2,X3,X4) ) ).

cnf(i_0_833,axiom,
    ( ~ esk6983_4(X1,X2,X3,X4)
    | esk6981_4(X1,X2,X3,X4) ) ).

cnf(i_0_834,axiom,
    ( esk11034_4(X1,X2,X3,X4)
    | esk11089_4(X1,X2,X3,X4) ) ).

cnf(i_0_835,axiom,
    ( ~ esk4115_4(X1,X2,X3,X4)
    | esk3857_4(X1,X2,X3,X4) ) ).

cnf(i_0_836,axiom,
    ( esk7168_4(X1,X2,X3,X4)
    | esk7137_4(X1,X2,X3,X4) ) ).

cnf(i_0_837,axiom,
    ( esk4774_4(X1,X2,X3,X4)
    | ~ esk4759_4(X1,X2,X3,X4) ) ).

cnf(i_0_838,axiom,
    ( esk4215_4(X1,X2,X3,X4)
    | ~ esk4246_4(X1,X2,X3,X4) ) ).

cnf(i_0_839,axiom,
    ( esk11842_4(X1,X2,X3,X4)
    | esk11744_4(X1,X2,X3,X4) ) ).

cnf(i_0_840,axiom,
    ( ~ esk15583_4(X1,X2,X3,X4)
    | ~ esk15581_4(X1,X2,X3,X4) ) ).

cnf(i_0_841,axiom,
    ( esk9917_4(X1,X2,X3,X4)
    | ~ esk9912_4(X1,X2,X3,X4) ) ).

cnf(i_0_842,axiom,
    ( ~ esk1740_4(X1,X2,X3,X4)
    | ~ esk1686_4(X1,X2,X3,X4) ) ).

cnf(i_0_843,axiom,
    ( esk9825_4(X1,X2,X3,X4)
    | ~ esk9771_4(X1,X2,X3,X4) ) ).

cnf(i_0_844,axiom,
    ( ~ esk6393_4(X1,X2,X3,X4)
    | ~ esk6426_4(X1,X2,X3,X4)
    | ~ esk6366_4(X1,X2,X3,X4) ) ).

cnf(i_0_845,axiom,
    ( esk6311_4(X1,X2,X3,X4)
    | ~ esk6268_4(X1,X2,X3,X4) ) ).

cnf(i_0_846,axiom,
    ( esk6573_4(X1,X2,X3,X4)
    | ~ esk6562_4(X1,X2,X3,X4) ) ).

cnf(i_0_847,axiom,
    ( esk12272_4(X1,X2,X3,X4)
    | esk12289_4(X1,X2,X3,X4) ) ).

cnf(i_0_848,axiom,
    ( ~ esk11789_4(X1,X2,X3,X4)
    | ~ esk11765_4(X1,X2,X3,X4)
    | ~ esk11895_4(X1,X2,X3,X4) ) ).

cnf(i_0_849,axiom,
    ( esk10514_4(X1,X2,X3,X4)
    | esk10598_4(X1,X2,X3,X4)
    | ~ esk10561_4(X1,X2,X3,X4) ) ).

cnf(i_0_850,axiom,
    ( esk15554_4(X1,X2,X3,X4)
    | ~ esk15523_4(X1,X2,X3,X4) ) ).

cnf(i_0_851,axiom,
    ( ~ esk1958_4(X1,X2,X3,X4)
    | ~ esk1957_4(X1,X2,X3,X4) ) ).

cnf(i_0_852,axiom,
    ( esk1603_4(X1,X2,X3,X4)
    | esk1487_4(X1,X2,X3,X4) ) ).

cnf(i_0_853,axiom,
    ( ~ esk7363_4(X1,X2,X3,X4)
    | esk7364_4(X1,X2,X3,X4) ) ).

cnf(i_0_854,axiom,
    ( ~ esk442_4(X1,X2,X3,X4)
    | ~ esk482_4(X1,X2,X3,X4)
    | ~ esk483_4(X1,X2,X3,X4) ) ).

cnf(i_0_855,axiom,
    ( esk6390_4(X1,X2,X3,X4)
    | esk6355_4(X1,X2,X3,X4) ) ).

cnf(i_0_856,axiom,
    ( p(X4)
    | ~ esk11_0
    | p(X3)
    | esk16600_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_857,axiom,
    ( ~ esk10832_4(X1,X2,X3,X4)
    | ~ esk10857_4(X1,X2,X3,X4)
    | ~ esk10831_4(X1,X2,X3,X4) ) ).

cnf(i_0_858,axiom,
    ( esk12147_4(X1,X2,X3,X4)
    | ~ esk12066_4(X1,X2,X3,X4) ) ).

cnf(i_0_859,axiom,
    ( esk6376_4(X1,X2,X3,X4)
    | esk6499_4(X1,X2,X3,X4) ) ).

cnf(i_0_860,axiom,
    ( ~ esk7830_4(X1,X2,X3,X4)
    | ~ esk7860_4(X1,X2,X3,X4) ) ).

cnf(i_0_861,axiom,
    ( ~ esk14414_4(X1,X2,X3,X4)
    | esk14451_4(X1,X2,X3,X4) ) ).

cnf(i_0_862,axiom,
    ( ~ esk11638_4(X1,X2,X3,X4)
    | ~ esk11616_4(X1,X2,X3,X4) ) ).

cnf(i_0_863,axiom,
    ( ~ esk2359_4(X1,X2,X3,X4)
    | esk2361_4(X1,X2,X3,X4)
    | ~ esk2360_4(X1,X2,X3,X4) ) ).

cnf(i_0_864,axiom,
    ( ~ esk14954_4(X1,X2,X3,X4)
    | ~ esk14867_4(X1,X2,X3,X4)
    | ~ esk14849_4(X1,X2,X3,X4) ) ).

cnf(i_0_865,axiom,
    ( ~ esk1730_4(X1,X2,X3,X4)
    | esk1793_4(X1,X2,X3,X4) ) ).

cnf(i_0_866,axiom,
    ( ~ esk6363_4(X1,X2,X3,X4)
    | esk6405_4(X1,X2,X3,X4) ) ).

cnf(i_0_867,axiom,
    ( ~ esk12284_4(X1,X2,X3,X4)
    | ~ esk12285_4(X1,X2,X3,X4)
    | ~ esk12274_4(X1,X2,X3,X4) ) ).

cnf(i_0_868,axiom,
    ( esk10221_4(X1,X2,X3,X4)
    | esk10228_4(X1,X2,X3,X4) ) ).

cnf(i_0_869,axiom,
    ( esk463_4(X1,X2,X3,X4)
    | esk577_4(X1,X2,X3,X4) ) ).

cnf(i_0_870,axiom,
    ( esk12527_4(X1,X2,X3,X4)
    | esk12550_4(X1,X2,X3,X4) ) ).

cnf(i_0_871,axiom,
    ( esk3232_4(X1,X2,X3,X4)
    | ~ esk3212_4(X1,X2,X3,X4) ) ).

cnf(i_0_872,axiom,
    ( esk3597_4(X1,X2,X3,X4)
    | ~ esk3668_4(X1,X2,X3,X4)
    | esk3649_4(X1,X2,X3,X4) ) ).

cnf(i_0_873,axiom,
    ( ~ esk8938_4(X1,X2,X3,X4)
    | ~ esk9058_4(X1,X2,X3,X4)
    | ~ esk8944_4(X1,X2,X3,X4) ) ).

cnf(i_0_874,axiom,
    ( ~ esk10020_4(X1,X2,X3,X4)
    | ~ esk10051_4(X1,X2,X3,X4) ) ).

cnf(i_0_875,axiom,
    ( esk13805_4(X1,X2,X3,X4)
    | esk13848_4(X1,X2,X3,X4) ) ).

cnf(i_0_876,axiom,
    ( ~ esk6111_4(X1,X2,X3,X4)
    | ~ esk6137_4(X1,X2,X3,X4)
    | ~ esk6220_4(X1,X2,X3,X4) ) ).

cnf(i_0_877,axiom,
    ( ~ esk14236_4(X1,X2,X3,X4)
    | esk14271_4(X1,X2,X3,X4) ) ).

cnf(i_0_878,axiom,
    ( ~ esk14881_4(X1,X2,X3,X4)
    | ~ esk14831_4(X1,X2,X3,X4)
    | ~ esk14880_4(X1,X2,X3,X4) ) ).

cnf(i_0_879,axiom,
    ( ~ esk12227_4(X1,X2,X3,X4)
    | esk12210_4(X1,X2,X3,X4)
    | ~ esk12331_4(X1,X2,X3,X4) ) ).

cnf(i_0_880,axiom,
    ( esk14540_4(X1,X2,X3,X4)
    | ~ esk14530_4(X1,X2,X3,X4) ) ).

cnf(i_0_881,axiom,
    ( esk2372_4(X1,X2,X3,X4)
    | ~ esk2318_4(X1,X2,X3,X4) ) ).

cnf(i_0_882,axiom,
    ( ~ esk15068_4(X1,X2,X3,X4)
    | esk15075_4(X1,X2,X3,X4) ) ).

cnf(i_0_883,axiom,
    ( esk4869_4(X1,X2,X3,X4)
    | ~ esk5127_4(X1,X2,X3,X4) ) ).

cnf(i_0_884,axiom,
    ( esk14159_4(X1,X2,X3,X4)
    | ~ esk14114_4(X1,X2,X3,X4)
    | ~ esk14174_4(X1,X2,X3,X4) ) ).

cnf(i_0_885,axiom,
    ( esk5108_4(X1,X2,X3,X4)
    | esk5141_4(X1,X2,X3,X4) ) ).

cnf(i_0_886,axiom,
    ( ~ esk10478_4(X1,X2,X3,X4)
    | ~ esk10544_4(X1,X2,X3,X4)
    | ~ esk10511_4(X1,X2,X3,X4) ) ).

cnf(i_0_887,axiom,
    ( ~ esk13500_4(X1,X2,X3,X4)
    | esk13465_4(X1,X2,X3,X4) ) ).

cnf(i_0_888,axiom,
    ( ~ esk6688_4(X1,X2,X3,X4)
    | esk6607_4(X1,X2,X3,X4) ) ).

cnf(i_0_889,axiom,
    ( ~ esk6307_4(X1,X2,X3,X4)
    | esk6316_4(X1,X2,X3,X4) ) ).

cnf(i_0_890,axiom,
    ( esk12287_4(X1,X2,X3,X4)
    | esk12273_4(X1,X2,X3,X4) ) ).

cnf(i_0_891,axiom,
    ( ~ esk15421_4(X1,X2,X3,X4)
    | esk15163_4(X1,X2,X3,X4) ) ).

cnf(i_0_892,axiom,
    ( ~ esk15738_4(X1,X2,X3,X4)
    | ~ esk15622_4(X1,X2,X3,X4)
    | ~ esk15620_4(X1,X2,X3,X4) ) ).

cnf(i_0_893,axiom,
    ( ~ esk12106_4(X1,X2,X3,X4)
    | esk12131_4(X1,X2,X3,X4)
    | esk12080_4(X1,X2,X3,X4) ) ).

cnf(i_0_894,axiom,
    ( esk3883_4(X1,X2,X3,X4)
    | esk3884_4(X1,X2,X3,X4)
    | esk3885_4(X1,X2,X3,X4) ) ).

cnf(i_0_895,axiom,
    ( ~ esk6319_4(X1,X2,X3,X4)
    | esk6316_4(X1,X2,X3,X4)
    | ~ esk6292_4(X1,X2,X3,X4) ) ).

cnf(i_0_896,axiom,
    ( esk16681_4(X1,X2,X3,X4)
    | ~ esk74_0
    | ~ p(X1)
    | p(X2)
    | ~ p(X4)
    | ~ p(X3) ) ).

cnf(i_0_897,axiom,
    ( ~ esk11307_4(X1,X2,X3,X4)
    | esk11049_4(X1,X2,X3,X4) ) ).

cnf(i_0_898,axiom,
    ( ~ esk6591_4(X1,X2,X3,X4)
    | esk6590_4(X1,X2,X3,X4) ) ).

cnf(i_0_899,axiom,
    ( ~ esk5690_4(X1,X2,X3,X4)
    | ~ esk5692_4(X1,X2,X3,X4)
    | ~ esk5639_4(X1,X2,X3,X4)
    | ~ esk5637_4(X1,X2,X3,X4) ) ).

cnf(i_0_900,axiom,
    ( ~ esk2099_4(X1,X2,X3,X4)
    | esk2128_4(X1,X2,X3,X4)
    | esk2079_4(X1,X2,X3,X4) ) ).

cnf(i_0_901,axiom,
    ( ~ esk15568_4(X1,X2,X3,X4)
    | esk15555_4(X1,X2,X3,X4)
    | ~ esk15680_4(X1,X2,X3,X4) ) ).

cnf(i_0_902,axiom,
    ( esk12031_4(X1,X2,X3,X4)
    | esk12020_4(X1,X2,X3,X4) ) ).

cnf(i_0_903,axiom,
    ( ~ esk6131_4(X1,X2,X3,X4)
    | ~ esk6099_4(X1,X2,X3,X4)
    | ~ esk6130_4(X1,X2,X3,X4) ) ).

cnf(i_0_904,axiom,
    ( esk6659_4(X1,X2,X3,X4)
    | esk6626_4(X1,X2,X3,X4) ) ).

cnf(i_0_905,axiom,
    ( ~ esk15337_4(X1,X2,X3,X4)
    | esk15336_4(X1,X2,X3,X4) ) ).

cnf(i_0_906,axiom,
    ( esk14971_4(X1,X2,X3,X4)
    | esk14942_4(X1,X2,X3,X4)
    | ~ esk14891_4(X1,X2,X3,X4) ) ).

cnf(i_0_907,axiom,
    ( esk16718_4(X1,X2,X3,X4)
    | ~ esk16460_4(X1,X2,X3,X4) ) ).

cnf(i_0_908,axiom,
    ( ~ esk666_4(X1,X2,X3,X4)
    | esk924_4(X1,X2,X3,X4) ) ).

cnf(i_0_909,axiom,
    ( ~ esk10477_4(X1,X2,X3,X4)
    | esk10513_4(X1,X2,X3,X4) ) ).

cnf(i_0_910,axiom,
    ( esk687_4(X1,X2,X3,X4)
    | ~ esk688_4(X1,X2,X3,X4) ) ).

cnf(i_0_911,axiom,
    ( ~ esk426_4(X1,X2,X3,X4)
    | esk427_4(X1,X2,X3,X4)
    | ~ esk425_4(X1,X2,X3,X4) ) ).

cnf(i_0_912,axiom,
    ( esk3587_4(X1,X2,X3,X4)
    | esk3554_4(X1,X2,X3,X4) ) ).

cnf(i_0_913,axiom,
    ( esk14551_4(X1,X2,X3,X4)
    | esk14553_4(X1,X2,X3,X4)
    | ~ esk14557_4(X1,X2,X3,X4) ) ).

cnf(i_0_914,axiom,
    ( esk16404_4(X1,X2,X3,X4)
    | esk16382_4(X1,X2,X3,X4) ) ).

cnf(i_0_915,axiom,
    ( esk3275_4(X1,X2,X3,X4)
    | esk3298_4(X1,X2,X3,X4) ) ).

cnf(i_0_916,axiom,
    ( ~ esk10559_4(X1,X2,X3,X4)
    | ~ esk10544_4(X1,X2,X3,X4) ) ).

cnf(i_0_917,axiom,
    ( ~ esk8544_4(X1,X2,X3,X4)
    | ~ esk8424_4(X1,X2,X3,X4)
    | ~ esk8430_4(X1,X2,X3,X4) ) ).

cnf(i_0_918,axiom,
    ( ~ esk2994_4(X1,X2,X3,X4)
    | esk2995_4(X1,X2,X3,X4) ) ).

cnf(i_0_919,axiom,
    ( esk1671_4(X1,X2,X3,X4)
    | ~ esk1690_4(X1,X2,X3,X4)
    | ~ esk1790_4(X1,X2,X3,X4) ) ).

cnf(i_0_920,axiom,
    ( esk6657_4(X1,X2,X3,X4)
    | esk6625_4(X1,X2,X3,X4) ) ).

cnf(i_0_921,axiom,
    ( esk6372_4(X1,X2,X3,X4)
    | esk6364_4(X1,X2,X3,X4) ) ).

cnf(i_0_922,axiom,
    ( esk13562_4(X1,X2,X3,X4)
    | esk13567_4(X1,X2,X3,X4) ) ).

cnf(i_0_923,axiom,
    ( ~ esk10045_4(X1,X2,X3,X4)
    | ~ esk10030_4(X1,X2,X3,X4) ) ).

cnf(i_0_924,axiom,
    ( esk4956_4(X1,X2,X3,X4)
    | esk4850_4(X1,X2,X3,X4) ) ).

cnf(i_0_925,axiom,
    ( esk15645_4(X1,X2,X3,X4)
    | esk15605_4(X1,X2,X3,X4) ) ).

cnf(i_0_926,axiom,
    ( ~ esk5595_4(X1,X2,X3,X4)
    | ~ esk5616_4(X1,X2,X3,X4)
    | ~ esk5649_4(X1,X2,X3,X4) ) ).

cnf(i_0_927,axiom,
    ( ~ esk9961_4(X1,X2,X3,X4)
    | esk10003_4(X1,X2,X3,X4) ) ).

cnf(i_0_928,axiom,
    ( esk7141_4(X1,X2,X3,X4)
    | esk7257_4(X1,X2,X3,X4) ) ).

cnf(i_0_929,axiom,
    ( esk10338_4(X1,X2,X3,X4)
    | ~ esk10287_4(X1,X2,X3,X4) ) ).

cnf(i_0_930,axiom,
    ( ~ esk10938_4(X1,X2,X3,X4)
    | esk10954_4(X1,X2,X3,X4) ) ).

cnf(i_0_931,axiom,
    ( ~ esk566_4(X1,X2,X3,X4)
    | ~ esk457_4(X1,X2,X3,X4)
    | ~ esk483_4(X1,X2,X3,X4) ) ).

cnf(i_0_932,axiom,
    ( ~ esk8642_4(X1,X2,X3,X4)
    | ~ esk8643_4(X1,X2,X3,X4) ) ).

cnf(i_0_933,axiom,
    ( ~ esk14269_4(X1,X2,X3,X4)
    | esk14393_4(X1,X2,X3,X4) ) ).

cnf(i_0_934,axiom,
    ( esk11221_4(X1,X2,X3,X4)
    | ~ esk11205_4(X1,X2,X3,X4) ) ).

cnf(i_0_935,axiom,
    ( esk8949_4(X1,X2,X3,X4)
    | esk8930_4(X1,X2,X3,X4) ) ).

cnf(i_0_936,axiom,
    ( esk7748_4(X1,X2,X3,X4)
    | esk7749_4(X1,X2,X3,X4)
    | esk7747_4(X1,X2,X3,X4) ) ).

cnf(i_0_937,axiom,
    ( ~ esk9901_4(X1,X2,X3,X4)
    | esk9868_4(X1,X2,X3,X4) ) ).

cnf(i_0_938,axiom,
    ( ~ esk6233_4(X1,X2,X3,X4)
    | esk6204_4(X1,X2,X3,X4)
    | esk6153_4(X1,X2,X3,X4) ) ).

cnf(i_0_939,axiom,
    ( esk13891_4(X1,X2,X3,X4)
    | ~ esk13633_4(X1,X2,X3,X4) ) ).

cnf(i_0_940,axiom,
    ( esk12551_4(X1,X2,X3,X4)
    | esk12526_4(X1,X2,X3,X4) ) ).

cnf(i_0_941,axiom,
    ( ~ esk10006_4(X1,X2,X3,X4)
    | ~ esk10059_4(X1,X2,X3,X4)
    | ~ esk10061_4(X1,X2,X3,X4)
    | ~ esk10008_4(X1,X2,X3,X4) ) ).

cnf(i_0_942,axiom,
    ( ~ esk3216_4(X1,X2,X3,X4)
    | esk3232_4(X1,X2,X3,X4) ) ).

cnf(i_0_943,axiom,
    ( ~ esk7258_4(X1,X2,X3,X4)
    | esk7175_4(X1,X2,X3,X4)
    | esk7235_4(X1,X2,X3,X4) ) ).

cnf(i_0_944,axiom,
    ( ~ esk14280_4(X1,X2,X3,X4)
    | esk14281_4(X1,X2,X3,X4)
    | ~ esk14286_4(X1,X2,X3,X4) ) ).

cnf(i_0_945,axiom,
    ( esk10753_4(X1,X2,X3,X4)
    | esk10737_4(X1,X2,X3,X4) ) ).

cnf(i_0_946,axiom,
    ( esk13910_4(X1,X2,X3,X4)
    | esk13871_4(X1,X2,X3,X4) ) ).

cnf(i_0_947,axiom,
    ( ~ esk1349_4(X1,X2,X3,X4)
    | ~ esk1359_4(X1,X2,X3,X4) ) ).

cnf(i_0_948,axiom,
    ( esk14148_4(X1,X2,X3,X4)
    | esk14155_4(X1,X2,X3,X4)
    | esk14056_4(X1,X2,X3,X4) ) ).

cnf(i_0_949,axiom,
    ( ~ esk4614_4(X1,X2,X3,X4)
    | esk4872_4(X1,X2,X3,X4) ) ).

cnf(i_0_950,axiom,
    ( esk14617_4(X1,X2,X3,X4)
    | esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_951,axiom,
    ( esk5131_4(X1,X2,X3,X4)
    | esk5212_4(X1,X2,X3,X4) ) ).

cnf(i_0_952,axiom,
    ( esk10769_4(X1,X2,X3,X4)
    | esk10737_4(X1,X2,X3,X4) ) ).

cnf(i_0_953,axiom,
    ( ~ esk14715_4(X1,X2,X3,X4)
    | esk14716_4(X1,X2,X3,X4) ) ).

cnf(i_0_954,axiom,
    ( esk15311_4(X1,X2,X3,X4)
    | ~ esk15305_4(X1,X2,X3,X4) ) ).

cnf(i_0_955,axiom,
    ( esk4916_4(X1,X2,X3,X4)
    | ~ esk4923_4(X1,X2,X3,X4)
    | esk4872_4(X1,X2,X3,X4) ) ).

cnf(i_0_956,axiom,
    ( ~ esk2864_4(X1,X2,X3,X4)
    | ~ esk2890_4(X1,X2,X3,X4)
    | ~ esk2865_4(X1,X2,X3,X4) ) ).

cnf(i_0_957,axiom,
    ( ~ esk8237_4(X1,X2,X3,X4)
    | ~ esk8148_4(X1,X2,X3,X4) ) ).

cnf(i_0_958,axiom,
    ( ~ esk7296_4(X1,X2,X3,X4)
    | esk7339_4(X1,X2,X3,X4) ) ).

cnf(i_0_959,axiom,
    ( esk4226_4(X1,X2,X3,X4)
    | ~ esk4250_4(X1,X2,X3,X4) ) ).

cnf(i_0_960,axiom,
    ( esk6781_4(X1,X2,X3,X4)
    | esk6831_4(X1,X2,X3,X4) ) ).

cnf(i_0_961,axiom,
    ( esk2559_4(X1,X2,X3,X4)
    | esk2604_4(X1,X2,X3,X4) ) ).

cnf(i_0_962,axiom,
    ( ~ esk14266_4(X1,X2,X3,X4)
    | esk14387_4(X1,X2,X3,X4) ) ).

cnf(i_0_963,axiom,
    ( ~ esk11016_4(X1,X2,X3,X4)
    | ~ esk10994_4(X1,X2,X3,X4)
    | ~ esk11101_4(X1,X2,X3,X4) ) ).

cnf(i_0_964,axiom,
    ( ~ esk3393_4(X1,X2,X3,X4)
    | ~ esk3342_4(X1,X2,X3,X4)
    | ~ esk3368_4(X1,X2,X3,X4) ) ).

cnf(i_0_965,axiom,
    ( ~ esk10993_4(X1,X2,X3,X4)
    | ~ esk10938_4(X1,X2,X3,X4) ) ).

cnf(i_0_966,axiom,
    ( ~ esk15886_4(X1,X2,X3,X4)
    | ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15919_4(X1,X2,X3,X4) ) ).

cnf(i_0_967,axiom,
    ( esk16128_4(X1,X2,X3,X4)
    | esk16141_4(X1,X2,X3,X4) ) ).

cnf(i_0_968,axiom,
    ( ~ esk16581_4(X1,X2,X3,X4)
    | esk16552_4(X1,X2,X3,X4) ) ).

cnf(i_0_969,axiom,
    ( ~ esk14295_4(X1,X2,X3,X4)
    | ~ esk14297_4(X1,X2,X3,X4) ) ).

cnf(i_0_970,axiom,
    ( ~ p(X2)
    | ~ esk167_0
    | ~ p(X4)
    | ~ p(X1)
    | esk503_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_971,axiom,
    ( esk11202_4(X1,X2,X3,X4)
    | ~ esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_972,axiom,
    ( esk6458_4(X1,X2,X3,X4)
    | esk6459_4(X1,X2,X3,X4) ) ).

cnf(i_0_973,axiom,
    ( esk11002_4(X1,X2,X3,X4)
    | esk11125_4(X1,X2,X3,X4) ) ).

cnf(i_0_974,axiom,
    ( esk5335_4(X1,X2,X3,X4)
    | esk5345_4(X1,X2,X3,X4) ) ).

cnf(i_0_975,axiom,
    ( esk14417_4(X1,X2,X3,X4)
    | esk14419_4(X1,X2,X3,X4)
    | esk14418_4(X1,X2,X3,X4) ) ).

cnf(i_0_976,axiom,
    ( esk7147_4(X1,X2,X3,X4)
    | esk7270_4(X1,X2,X3,X4) ) ).

cnf(i_0_977,axiom,
    ( esk5187_4(X1,X2,X3,X4)
    | ~ esk5171_4(X1,X2,X3,X4) ) ).

cnf(i_0_978,axiom,
    ( ~ esk3730_4(X1,X2,X3,X4)
    | esk3746_4(X1,X2,X3,X4) ) ).

cnf(i_0_979,axiom,
    ( esk15582_4(X1,X2,X3,X4)
    | esk15587_4(X1,X2,X3,X4) ) ).

cnf(i_0_980,axiom,
    ( esk13788_4(X1,X2,X3,X4)
    | esk13783_4(X1,X2,X3,X4) ) ).

cnf(i_0_981,axiom,
    ( esk5352_4(X1,X2,X3,X4)
    | esk5340_4(X1,X2,X3,X4) ) ).

cnf(i_0_982,axiom,
    ( ~ esk9363_4(X1,X2,X3,X4)
    | esk9393_4(X1,X2,X3,X4) ) ).

cnf(i_0_983,axiom,
    ( ~ esk13227_4(X1,X2,X3,X4)
    | ~ esk13257_4(X1,X2,X3,X4) ) ).

cnf(i_0_984,axiom,
    ( esk16685_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X2)
    | p(X4)
    | ~ p(X1)
    | ~ esk103_0 ) ).

cnf(i_0_985,axiom,
    ( esk12613_4(X1,X2,X3,X4)
    | esk12514_4(X1,X2,X3,X4)
    | esk12606_4(X1,X2,X3,X4) ) ).

cnf(i_0_986,axiom,
    ( esk7935_4(X1,X2,X3,X4)
    | esk7968_4(X1,X2,X3,X4) ) ).

cnf(i_0_987,axiom,
    ( ~ esk1416_4(X1,X2,X3,X4)
    | esk1433_4(X1,X2,X3,X4) ) ).

cnf(i_0_988,axiom,
    ( ~ esk13032_4(X1,X2,X3,X4)
    | ~ esk13081_4(X1,X2,X3,X4)
    | ~ esk13082_4(X1,X2,X3,X4) ) ).

cnf(i_0_989,axiom,
    ( esk780_4(X1,X2,X3,X4)
    | ~ esk784_4(X1,X2,X3,X4) ) ).

cnf(i_0_990,axiom,
    ( ~ esk6022_4(X1,X2,X3,X4)
    | esk6052_4(X1,X2,X3,X4) ) ).

cnf(i_0_991,axiom,
    ( ~ esk12023_4(X1,X2,X3,X4)
    | ~ esk12024_4(X1,X2,X3,X4)
    | ~ esk12019_4(X1,X2,X3,X4) ) ).

cnf(i_0_992,axiom,
    ( esk14315_4(X1,X2,X3,X4)
    | ~ esk14253_4(X1,X2,X3,X4) ) ).

cnf(i_0_993,axiom,
    ( esk2717_4(X1,X2,X3,X4)
    | esk2835_4(X1,X2,X3,X4) ) ).

cnf(i_0_994,axiom,
    ( ~ esk15118_4(X1,X2,X3,X4)
    | ~ esk15117_4(X1,X2,X3,X4)
    | ~ esk15098_4(X1,X2,X3,X4) ) ).

cnf(i_0_995,axiom,
    ( esk16770_4(X1,X2,X3,X4)
    | ~ esk16690_4(X1,X2,X3,X4)
    | esk16741_4(X1,X2,X3,X4) ) ).

cnf(i_0_996,axiom,
    ( ~ esk11566_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4)
    | esk11442_4(X1,X2,X3,X4) ) ).

cnf(i_0_997,axiom,
    ( ~ esk8422_4(X1,X2,X3,X4)
    | ~ esk8447_4(X1,X2,X3,X4)
    | ~ esk8480_4(X1,X2,X3,X4) ) ).

cnf(i_0_998,axiom,
    ( esk4772_4(X1,X2,X3,X4)
    | ~ esk4752_4(X1,X2,X3,X4) ) ).

cnf(i_0_999,axiom,
    ( ~ esk6111_4(X1,X2,X3,X4)
    | ~ esk6089_4(X1,X2,X3,X4) ) ).

cnf(i_0_1000,axiom,
    ( esk8774_4(X1,X2,X3,X4)
    | esk8776_4(X1,X2,X3,X4) ) ).

cnf(i_0_1001,axiom,
    ( esk1819_4(X1,X2,X3,X4)
    | esk1723_4(X1,X2,X3,X4)
    | esk1722_4(X1,X2,X3,X4) ) ).

cnf(i_0_1002,axiom,
    ( esk2087_4(X1,X2,X3,X4)
    | esk2088_4(X1,X2,X3,X4)
    | esk2079_4(X1,X2,X3,X4) ) ).

cnf(i_0_1003,axiom,
    ( ~ esk13173_4(X1,X2,X3,X4)
    | ~ esk13141_4(X1,X2,X3,X4) ) ).

cnf(i_0_1004,axiom,
    ( esk8971_4(X1,X2,X3,X4)
    | ~ esk9229_4(X1,X2,X3,X4) ) ).

cnf(i_0_1005,axiom,
    ( ~ esk13253_4(X1,X2,X3,X4)
    | esk13258_4(X1,X2,X3,X4) ) ).

cnf(i_0_1006,axiom,
    ( esk15653_4(X1,X2,X3,X4)
    | ~ esk15617_4(X1,X2,X3,X4) ) ).

cnf(i_0_1007,axiom,
    ( esk10128_4(X1,X2,X3,X4)
    | ~ esk10155_4(X1,X2,X3,X4) ) ).

cnf(i_0_1008,axiom,
    ( ~ esk4586_4(X1,X2,X3,X4)
    | ~ esk4567_4(X1,X2,X3,X4)
    | ~ esk4619_4(X1,X2,X3,X4) ) ).

cnf(i_0_1009,axiom,
    ( ~ esk12760_4(X1,X2,X3,X4)
    | ~ esk12755_4(X1,X2,X3,X4) ) ).

cnf(i_0_1010,axiom,
    ( esk9755_4(X1,X2,X3,X4)
    | ~ esk9497_4(X1,X2,X3,X4) ) ).

cnf(i_0_1011,axiom,
    ( esk1214_4(X1,X2,X3,X4)
    | esk1251_4(X1,X2,X3,X4) ) ).

cnf(i_0_1012,axiom,
    ( esk9900_4(X1,X2,X3,X4)
    | ~ esk9869_4(X1,X2,X3,X4) ) ).

cnf(i_0_1013,axiom,
    ( esk5909_4(X1,X2,X3,X4)
    | ~ esk6167_4(X1,X2,X3,X4) ) ).

cnf(i_0_1014,axiom,
    ( ~ esk12378_4(X1,X2,X3,X4)
    | esk12380_4(X1,X2,X3,X4)
    | ~ esk12379_4(X1,X2,X3,X4) ) ).

cnf(i_0_1015,axiom,
    ( ~ esk1019_4(X1,X2,X3,X4)
    | esk761_4(X1,X2,X3,X4) ) ).

cnf(i_0_1016,axiom,
    ( esk14847_4(X1,X2,X3,X4)
    | esk14860_4(X1,X2,X3,X4) ) ).

cnf(i_0_1017,axiom,
    ( esk16734_4(X1,X2,X3,X4)
    | esk16704_4(X1,X2,X3,X4) ) ).

cnf(i_0_1018,axiom,
    ( ~ esk10934_4(X1,X2,X3,X4)
    | esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_1019,axiom,
    ( esk6351_4(X1,X2,X3,X4)
    | esk6398_4(X1,X2,X3,X4) ) ).

cnf(i_0_1020,axiom,
    ( ~ esk12904_4(X1,X2,X3,X4)
    | ~ esk12905_4(X1,X2,X3,X4)
    | esk12906_4(X1,X2,X3,X4) ) ).

cnf(i_0_1021,axiom,
    ( ~ esk4349_4(X1,X2,X3,X4)
    | esk4607_4(X1,X2,X3,X4) ) ).

cnf(i_0_1022,axiom,
    ( esk2130_4(X1,X2,X3,X4)
    | esk2007_4(X1,X2,X3,X4) ) ).

cnf(i_0_1023,axiom,
    ( ~ esk11833_4(X1,X2,X3,X4)
    | esk11831_4(X1,X2,X3,X4) ) ).

cnf(i_0_1024,axiom,
    ( esk10205_4(X1,X2,X3,X4)
    | ~ esk10286_4(X1,X2,X3,X4) ) ).

cnf(i_0_1025,axiom,
    ( ~ esk2966_4(X1,X2,X3,X4)
    | esk2940_4(X1,X2,X3,X4) ) ).

cnf(i_0_1026,axiom,
    ( esk11779_4(X1,X2,X3,X4)
    | esk11862_4(X1,X2,X3,X4) ) ).

cnf(i_0_1027,axiom,
    ( ~ esk15649_4(X1,X2,X3,X4)
    | ~ esk15650_4(X1,X2,X3,X4)
    | ~ esk15603_4(X1,X2,X3,X4) ) ).

cnf(i_0_1028,axiom,
    ( esk6861_4(X1,X2,X3,X4)
    | esk6952_4(X1,X2,X3,X4) ) ).

cnf(i_0_1029,axiom,
    ( esk3248_4(X1,X2,X3,X4)
    | ~ esk3242_4(X1,X2,X3,X4) ) ).

cnf(i_0_1030,axiom,
    ( esk10938_4(X1,X2,X3,X4)
    | esk10993_4(X1,X2,X3,X4) ) ).

cnf(i_0_1031,axiom,
    ( ~ esk7596_4(X1,X2,X3,X4)
    | esk7553_4(X1,X2,X3,X4) ) ).

cnf(i_0_1032,axiom,
    ( esk15923_4(X1,X2,X3,X4)
    | esk15968_4(X1,X2,X3,X4) ) ).

cnf(i_0_1033,axiom,
    ( ~ esk5944_4(X1,X2,X3,X4)
    | ~ esk5951_4(X1,X2,X3,X4)
    | ~ esk5900_4(X1,X2,X3,X4) ) ).

cnf(i_0_1034,axiom,
    ( esk455_4(X1,X2,X3,X4)
    | esk474_4(X1,X2,X3,X4) ) ).

cnf(i_0_1035,axiom,
    ( esk5155_4(X1,X2,X3,X4)
    | esk5030_4(X1,X2,X3,X4) ) ).

cnf(i_0_1036,axiom,
    ( esk4160_4(X1,X2,X3,X4)
    | esk4073_4(X1,X2,X3,X4) ) ).

cnf(i_0_1037,axiom,
    ( ~ esk2348_4(X1,X2,X3,X4)
    | esk2380_4(X1,X2,X3,X4) ) ).

cnf(i_0_1038,axiom,
    ( ~ esk10452_4(X1,X2,X3,X4)
    | esk10451_4(X1,X2,X3,X4)
    | esk10456_4(X1,X2,X3,X4) ) ).

cnf(i_0_1039,axiom,
    ( esk12777_4(X1,X2,X3,X4)
    | esk12820_4(X1,X2,X3,X4) ) ).

cnf(i_0_1040,axiom,
    ( ~ esk11485_4(X1,X2,X3,X4)
    | esk11481_4(X1,X2,X3,X4) ) ).

cnf(i_0_1041,axiom,
    ( esk14840_4(X1,X2,X3,X4)
    | esk14862_4(X1,X2,X3,X4) ) ).

cnf(i_0_1042,axiom,
    ( esk10206_4(X1,X2,X3,X4)
    | esk10253_4(X1,X2,X3,X4) ) ).

cnf(i_0_1043,axiom,
    ( ~ esk1605_4(X1,X2,X3,X4)
    | ~ esk1580_4(X1,X2,X3,X4)
    | ~ esk1579_4(X1,X2,X3,X4) ) ).

cnf(i_0_1044,axiom,
    ( ~ esk4117_4(X1,X2,X3,X4)
    | ~ esk4003_4(X1,X2,X3,X4)
    | esk3991_4(X1,X2,X3,X4) ) ).

cnf(i_0_1045,axiom,
    ( esk2087_4(X1,X2,X3,X4)
    | esk2049_4(X1,X2,X3,X4)
    | ~ esk2103_4(X1,X2,X3,X4) ) ).

cnf(i_0_1046,axiom,
    ( esk8282_4(X1,X2,X3,X4)
    | ~ esk8231_4(X1,X2,X3,X4) ) ).

cnf(i_0_1047,axiom,
    ( esk4152_4(X1,X2,X3,X4)
    | esk4101_4(X1,X2,X3,X4)
    | ~ esk4145_4(X1,X2,X3,X4) ) ).

cnf(i_0_1048,axiom,
    ( ~ esk3958_4(X1,X2,X3,X4)
    | esk3989_4(X1,X2,X3,X4) ) ).

cnf(i_0_1049,axiom,
    ( esk1094_4(X1,X2,X3,X4)
    | esk1063_4(X1,X2,X3,X4)
    | ~ esk1095_4(X1,X2,X3,X4) ) ).

cnf(i_0_1050,axiom,
    ( esk3533_4(X1,X2,X3,X4)
    | esk3552_4(X1,X2,X3,X4) ) ).

cnf(i_0_1051,axiom,
    ( ~ esk16692_4(X1,X2,X3,X4)
    | esk16434_4(X1,X2,X3,X4) ) ).

cnf(i_0_1052,axiom,
    ( ~ esk13045_4(X1,X2,X3,X4)
    | esk13087_4(X1,X2,X3,X4) ) ).

cnf(i_0_1053,axiom,
    ( ~ esk4526_4(X1,X2,X3,X4)
    | esk4535_4(X1,X2,X3,X4) ) ).

cnf(i_0_1054,axiom,
    ( ~ esk16058_4(X1,X2,X3,X4)
    | ~ esk16081_4(X1,X2,X3,X4) ) ).

cnf(i_0_1055,axiom,
    ( ~ esk2295_4(X1,X2,X3,X4)
    | esk2250_4(X1,X2,X3,X4) ) ).

cnf(i_0_1056,axiom,
    ( esk14114_4(X1,X2,X3,X4)
    | ~ esk14159_4(X1,X2,X3,X4) ) ).

cnf(i_0_1057,axiom,
    ( esk10766_4(X1,X2,X3,X4)
    | esk10735_4(X1,X2,X3,X4) ) ).

cnf(i_0_1058,axiom,
    ( ~ esk15621_4(X1,X2,X3,X4)
    | ~ esk15654_4(X1,X2,X3,X4)
    | ~ esk15618_4(X1,X2,X3,X4) ) ).

cnf(i_0_1059,axiom,
    ( ~ esk2383_4(X1,X2,X3,X4)
    | ~ esk2312_4(X1,X2,X3,X4)
    | ~ esk2364_4(X1,X2,X3,X4) ) ).

cnf(i_0_1060,axiom,
    ( ~ esk676_4(X1,X2,X3,X4)
    | ~ esk667_4(X1,X2,X3,X4)
    | ~ esk690_4(X1,X2,X3,X4) ) ).

cnf(i_0_1061,axiom,
    ( ~ esk8366_4(X1,X2,X3,X4)
    | esk8334_4(X1,X2,X3,X4) ) ).

cnf(i_0_1062,axiom,
    ( esk12989_4(X1,X2,X3,X4)
    | ~ esk12963_4(X1,X2,X3,X4) ) ).

cnf(i_0_1063,axiom,
    ( ~ esk6870_4(X1,X2,X3,X4)
    | esk6933_4(X1,X2,X3,X4) ) ).

cnf(i_0_1064,axiom,
    ( esk3746_4(X1,X2,X3,X4)
    | ~ esk3738_4(X1,X2,X3,X4) ) ).

cnf(i_0_1065,axiom,
    ( ~ esk15568_4(X1,X2,X3,X4)
    | esk15557_4(X1,X2,X3,X4)
    | ~ esk15654_4(X1,X2,X3,X4) ) ).

cnf(i_0_1066,axiom,
    ( ~ p(X2)
    | esk1_0
    | ~ p(X3)
    | ~ esk16605_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_1067,axiom,
    ( esk5641_4(X1,X2,X3,X4)
    | ~ esk5383_4(X1,X2,X3,X4) ) ).

cnf(i_0_1068,axiom,
    ( ~ esk3079_4(X1,X2,X3,X4)
    | esk2821_4(X1,X2,X3,X4) ) ).

cnf(i_0_1069,axiom,
    ( ~ esk10691_4(X1,X2,X3,X4)
    | esk10707_4(X1,X2,X3,X4) ) ).

cnf(i_0_1070,axiom,
    ( esk2846_4(X1,X2,X3,X4)
    | ~ esk3104_4(X1,X2,X3,X4) ) ).

cnf(i_0_1071,axiom,
    ( esk6687_4(X1,X2,X3,X4)
    | ~ esk6561_4(X1,X2,X3,X4) ) ).

cnf(i_0_1072,axiom,
    ( esk6915_4(X1,X2,X3,X4)
    | ~ esk7173_4(X1,X2,X3,X4) ) ).

cnf(i_0_1073,axiom,
    ( esk13151_4(X1,X2,X3,X4)
    | esk13066_4(X1,X2,X3,X4) ) ).

cnf(i_0_1074,axiom,
    ( ~ esk13096_4(X1,X2,X3,X4)
    | ~ esk13141_4(X1,X2,X3,X4)
    | ~ esk13140_4(X1,X2,X3,X4) ) ).

cnf(i_0_1075,axiom,
    ( ~ esk9238_4(X1,X2,X3,X4)
    | esk9496_4(X1,X2,X3,X4) ) ).

cnf(i_0_1076,axiom,
    ( ~ esk9515_4(X1,X2,X3,X4)
    | esk9773_4(X1,X2,X3,X4) ) ).

cnf(i_0_1077,axiom,
    ( esk5444_4(X1,X2,X3,X4)
    | ~ esk5428_4(X1,X2,X3,X4) ) ).

cnf(i_0_1078,axiom,
    ( esk11978_4(X1,X2,X3,X4)
    | esk11983_4(X1,X2,X3,X4)
    | esk11984_4(X1,X2,X3,X4) ) ).

cnf(i_0_1079,axiom,
    ( esk16508_4(X1,X2,X3,X4)
    | esk16421_4(X1,X2,X3,X4) ) ).

cnf(i_0_1080,axiom,
    ( esk756_4(X1,X2,X3,X4)
    | esk842_4(X1,X2,X3,X4) ) ).

cnf(i_0_1081,axiom,
    ( esk15875_4(X1,X2,X3,X4)
    | esk15900_4(X1,X2,X3,X4) ) ).

cnf(i_0_1082,axiom,
    ( ~ esk14183_4(X1,X2,X3,X4)
    | esk14181_4(X1,X2,X3,X4) ) ).

cnf(i_0_1083,axiom,
    ( esk8422_4(X1,X2,X3,X4)
    | esk8441_4(X1,X2,X3,X4) ) ).

cnf(i_0_1084,axiom,
    ( ~ esk9277_4(X1,X2,X3,X4)
    | ~ esk9305_4(X1,X2,X3,X4) ) ).

cnf(i_0_1085,axiom,
    ( ~ esk11952_4(X1,X2,X3,X4)
    | esk11929_4(X1,X2,X3,X4) ) ).

cnf(i_0_1086,axiom,
    ( ~ esk14971_4(X1,X2,X3,X4)
    | esk14891_4(X1,X2,X3,X4)
    | esk14942_4(X1,X2,X3,X4) ) ).

cnf(i_0_1087,axiom,
    ( p(X1)
    | ~ p(X3)
    | ~ esk200_0
    | esk16699_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4) ) ).

cnf(i_0_1088,axiom,
    ( esk13171_4(X1,X2,X3,X4)
    | esk13181_4(X1,X2,X3,X4) ) ).

cnf(i_0_1089,axiom,
    ( ~ esk1789_4(X1,X2,X3,X4)
    | esk1732_4(X1,X2,X3,X4) ) ).

cnf(i_0_1090,axiom,
    ( ~ p(X3)
    | esk433_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X2)
    | ~ esk54_0
    | p(X1) ) ).

cnf(i_0_1091,axiom,
    ( ~ esk13905_4(X1,X2,X3,X4)
    | ~ esk13930_4(X1,X2,X3,X4)
    | ~ esk13879_4(X1,X2,X3,X4) ) ).

cnf(i_0_1092,axiom,
    ( ~ esk1233_4(X1,X2,X3,X4)
    | ~ esk1266_4(X1,X2,X3,X4)
    | ~ esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_1093,axiom,
    ( esk13557_4(X1,X2,X3,X4)
    | ~ esk13605_4(X1,X2,X3,X4) ) ).

cnf(i_0_1094,axiom,
    ( esk10417_4(X1,X2,X3,X4)
    | ~ esk10395_4(X1,X2,X3,X4) ) ).

cnf(i_0_1095,axiom,
    ( esk2243_4(X1,X2,X3,X4)
    | esk2278_4(X1,X2,X3,X4) ) ).

cnf(i_0_1096,axiom,
    ( esk3541_4(X1,X2,X3,X4)
    | esk3569_4(X1,X2,X3,X4) ) ).

cnf(i_0_1097,axiom,
    ( ~ esk13320_4(X1,X2,X3,X4)
    | ~ esk13321_4(X1,X2,X3,X4)
    | ~ esk13298_4(X1,X2,X3,X4) ) ).

cnf(i_0_1098,axiom,
    ( esk5597_4(X1,X2,X3,X4)
    | esk5603_4(X1,X2,X3,X4) ) ).

cnf(i_0_1099,axiom,
    ( esk4069_4(X1,X2,X3,X4)
    | esk4055_4(X1,X2,X3,X4) ) ).

cnf(i_0_1100,axiom,
    ( esk1561_4(X1,X2,X3,X4)
    | ~ esk1560_4(X1,X2,X3,X4) ) ).

cnf(i_0_1101,axiom,
    ( esk13150_4(X1,X2,X3,X4)
    | ~ esk13130_4(X1,X2,X3,X4) ) ).

cnf(i_0_1102,axiom,
    ( esk12632_4(X1,X2,X3,X4)
    | ~ esk12617_4(X1,X2,X3,X4) ) ).

cnf(i_0_1103,axiom,
    ( esk12045_4(X1,X2,X3,X4)
    | esk12020_4(X1,X2,X3,X4) ) ).

cnf(i_0_1104,axiom,
    ( ~ esk6587_4(X1,X2,X3,X4)
    | ~ esk6578_4(X1,X2,X3,X4)
    | ~ esk6601_4(X1,X2,X3,X4) ) ).

cnf(i_0_1105,axiom,
    ( ~ esk386_4(X1,X2,X3,X4)
    | esk505_4(X1,X2,X3,X4) ) ).

cnf(i_0_1106,axiom,
    ( esk3080_4(X1,X2,X3,X4)
    | ~ esk3014_4(X1,X2,X3,X4) ) ).

cnf(i_0_1107,axiom,
    ( esk14407_4(X1,X2,X3,X4)
    | esk14282_4(X1,X2,X3,X4) ) ).

cnf(i_0_1108,axiom,
    ( ~ esk12474_4(X1,X2,X3,X4)
    | esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_1109,axiom,
    ( esk3115_4(X1,X2,X3,X4)
    | esk3129_4(X1,X2,X3,X4) ) ).

cnf(i_0_1110,axiom,
    ( ~ esk13564_4(X1,X2,X3,X4)
    | ~ esk13542_4(X1,X2,X3,X4) ) ).

cnf(i_0_1111,axiom,
    ( esk10201_4(X1,X2,X3,X4)
    | esk10223_4(X1,X2,X3,X4)
    | esk10222_4(X1,X2,X3,X4) ) ).

cnf(i_0_1112,axiom,
    ( esk1960_4(X1,X2,X3,X4)
    | esk1962_4(X1,X2,X3,X4) ) ).

cnf(i_0_1113,axiom,
    ( ~ esk14428_4(X1,X2,X3,X4)
    | ~ esk14427_4(X1,X2,X3,X4) ) ).

cnf(i_0_1114,axiom,
    ( esk12338_4(X1,X2,X3,X4)
    | ~ esk12263_4(X1,X2,X3,X4) ) ).

cnf(i_0_1115,axiom,
    ( p(X2)
    | ~ p(X4)
    | p(X1)
    | esk19_0
    | ~ esk16602_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_1116,axiom,
    ( esk15982_4(X1,X2,X3,X4)
    | esk15895_4(X1,X2,X3,X4) ) ).

cnf(i_0_1117,axiom,
    ( ~ esk14379_4(X1,X2,X3,X4)
    | esk14460_4(X1,X2,X3,X4) ) ).

cnf(i_0_1118,axiom,
    ( esk15307_4(X1,X2,X3,X4)
    | esk15362_4(X1,X2,X3,X4) ) ).

cnf(i_0_1119,axiom,
    ( ~ esk9015_4(X1,X2,X3,X4)
    | ~ esk9008_4(X1,X2,X3,X4)
    | ~ esk8917_4(X1,X2,X3,X4) ) ).

cnf(i_0_1120,axiom,
    ( ~ esk11794_4(X1,X2,X3,X4)
    | ~ esk11748_4(X1,X2,X3,X4)
    | ~ esk11795_4(X1,X2,X3,X4) ) ).

cnf(i_0_1121,axiom,
    ( esk4327_4(X1,X2,X3,X4)
    | esk4302_4(X1,X2,X3,X4) ) ).

cnf(i_0_1122,axiom,
    ( esk6901_4(X1,X2,X3,X4)
    | esk6870_4(X1,X2,X3,X4) ) ).

cnf(i_0_1123,axiom,
    ( ~ esk4840_4(X1,X2,X3,X4)
    | ~ esk4923_4(X1,X2,X3,X4)
    | ~ esk4826_4(X1,X2,X3,X4) ) ).

cnf(i_0_1124,axiom,
    ( esk12536_4(X1,X2,X3,X4)
    | esk12542_4(X1,X2,X3,X4) ) ).

cnf(i_0_1125,axiom,
    ( p(X1)
    | p(X2)
    | p(X4)
    | ~ esk50_0
    | esk16623_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_1126,axiom,
    ( ~ esk6824_4(X1,X2,X3,X4)
    | esk6830_4(X1,X2,X3,X4) ) ).

cnf(i_0_1127,axiom,
    ( esk15824_4(X1,X2,X3,X4)
    | esk15942_4(X1,X2,X3,X4) ) ).

cnf(i_0_1128,axiom,
    ( esk3353_4(X1,X2,X3,X4)
    | ~ esk3352_4(X1,X2,X3,X4) ) ).

cnf(i_0_1129,axiom,
    ( ~ esk15905_4(X1,X2,X3,X4)
    | ~ esk15877_4(X1,X2,X3,X4)
    | ~ esk15990_4(X1,X2,X3,X4) ) ).

cnf(i_0_1130,axiom,
    ( esk12909_4(X1,X2,X3,X4)
    | ~ esk12872_4(X1,X2,X3,X4) ) ).

cnf(i_0_1131,axiom,
    ( esk13369_4(X1,X2,X3,X4)
    | ~ esk13111_4(X1,X2,X3,X4) ) ).

cnf(i_0_1132,axiom,
    ( ~ esk13646_4(X1,X2,X3,X4)
    | ~ esk13648_4(X1,X2,X3,X4) ) ).

cnf(i_0_1133,axiom,
    ( ~ esk12072_4(X1,X2,X3,X4)
    | ~ esk12020_4(X1,X2,X3,X4)
    | ~ esk12039_4(X1,X2,X3,X4) ) ).

cnf(i_0_1134,axiom,
    ( ~ esk11289_4(X1,X2,X3,X4)
    | ~ esk11345_4(X1,X2,X3,X4) ) ).

cnf(i_0_1135,axiom,
    ( esk7639_4(X1,X2,X3,X4)
    | esk7677_4(X1,X2,X3,X4) ) ).

cnf(i_0_1136,axiom,
    ( ~ esk10502_4(X1,X2,X3,X4)
    | ~ esk10480_4(X1,X2,X3,X4)
    | ~ esk10587_4(X1,X2,X3,X4) ) ).

cnf(i_0_1137,axiom,
    ( ~ esk10048_4(X1,X2,X3,X4)
    | ~ esk10050_4(X1,X2,X3,X4) ) ).

cnf(i_0_1138,axiom,
    ( ~ p(X3)
    | ~ esk16683_4(X1,X2,X3,X4)
    | p(X2)
    | esk80_0
    | p(X4)
    | p(X1) ) ).

cnf(i_0_1139,axiom,
    ( ~ esk5932_4(X1,X2,X3,X4)
    | ~ esk5931_4(X1,X2,X3,X4) ) ).

cnf(i_0_1140,axiom,
    ( ~ esk1854_4(X1,X2,X3,X4)
    | esk1824_4(X1,X2,X3,X4)
    | esk1802_4(X1,X2,X3,X4) ) ).

cnf(i_0_1141,axiom,
    ( ~ esk9576_4(X1,X2,X3,X4)
    | esk9578_4(X1,X2,X3,X4)
    | ~ esk9577_4(X1,X2,X3,X4) ) ).

cnf(i_0_1142,axiom,
    ( ~ esk12014_4(X1,X2,X3,X4)
    | esk12065_4(X1,X2,X3,X4) ) ).

cnf(i_0_1143,axiom,
    ( ~ esk6922_4(X1,X2,X3,X4)
    | ~ esk6924_4(X1,X2,X3,X4)
    | ~ esk6977_4(X1,X2,X3,X4)
    | ~ esk6975_4(X1,X2,X3,X4) ) ).

cnf(i_0_1144,axiom,
    ( esk15682_4(X1,X2,X3,X4)
    | esk15702_4(X1,X2,X3,X4) ) ).

cnf(i_0_1145,axiom,
    ( esk13782_4(X1,X2,X3,X4)
    | ~ esk13786_4(X1,X2,X3,X4)
    | esk13780_4(X1,X2,X3,X4) ) ).

cnf(i_0_1146,axiom,
    ( ~ p(X2)
    | ~ p(X4)
    | ~ esk16602_4(X1,X2,X3,X4)
    | p(X1)
    | esk23_0
    | p(X3) ) ).

cnf(i_0_1147,axiom,
    ( esk1946_4(X1,X2,X3,X4)
    | esk2071_4(X1,X2,X3,X4) ) ).

cnf(i_0_1148,axiom,
    ( ~ esk12593_4(X1,X2,X3,X4)
    | esk12851_4(X1,X2,X3,X4) ) ).

cnf(i_0_1149,axiom,
    ( esk4825_4(X1,X2,X3,X4)
    | esk4770_4(X1,X2,X3,X4) ) ).

cnf(i_0_1150,axiom,
    ( ~ esk9724_4(X1,X2,X3,X4)
    | ~ esk9707_4(X1,X2,X3,X4)
    | ~ esk9757_4(X1,X2,X3,X4) ) ).

cnf(i_0_1151,axiom,
    ( esk2827_4(X1,X2,X3,X4)
    | ~ esk2755_4(X1,X2,X3,X4) ) ).

cnf(i_0_1152,axiom,
    ( esk12857_4(X1,X2,X3,X4)
    | esk12875_4(X1,X2,X3,X4) ) ).

cnf(i_0_1153,axiom,
    ( esk9573_4(X1,X2,X3,X4)
    | esk9580_4(X1,X2,X3,X4)
    | ~ esk9492_4(X1,X2,X3,X4) ) ).

cnf(i_0_1154,axiom,
    ( ~ esk14007_4(X1,X2,X3,X4)
    | esk14026_4(X1,X2,X3,X4) ) ).

cnf(i_0_1155,axiom,
    ( ~ esk10708_4(X1,X2,X3,X4)
    | esk10709_4(X1,X2,X3,X4) ) ).

cnf(i_0_1156,axiom,
    ( ~ esk13286_4(X1,X2,X3,X4)
    | ~ esk13377_4(X1,X2,X3,X4)
    | ~ esk13384_4(X1,X2,X3,X4) ) ).

cnf(i_0_1157,axiom,
    ( esk4143_4(X1,X2,X3,X4)
    | esk4157_4(X1,X2,X3,X4) ) ).

cnf(i_0_1158,axiom,
    ( esk13126_4(X1,X2,X3,X4)
    | ~ esk13125_4(X1,X2,X3,X4) ) ).

cnf(i_0_1159,axiom,
    ( ~ esk3798_4(X1,X2,X3,X4)
    | ~ esk3903_4(X1,X2,X3,X4)
    | ~ esk3816_4(X1,X2,X3,X4) ) ).

cnf(i_0_1160,axiom,
    ( esk10218_4(X1,X2,X3,X4)
    | ~ esk10260_4(X1,X2,X3,X4) ) ).

cnf(i_0_1161,axiom,
    ( esk7484_4(X1,X2,X3,X4)
    | esk7448_4(X1,X2,X3,X4) ) ).

cnf(i_0_1162,axiom,
    ( ~ esk12080_4(X1,X2,X3,X4)
    | ~ esk12106_4(X1,X2,X3,X4)
    | ~ esk12078_4(X1,X2,X3,X4)
    | ~ esk12108_4(X1,X2,X3,X4) ) ).

cnf(i_0_1163,axiom,
    ( ~ esk12272_4(X1,X2,X3,X4)
    | esk12320_4(X1,X2,X3,X4) ) ).

cnf(i_0_1164,axiom,
    ( ~ esk13759_4(X1,X2,X3,X4)
    | esk13857_4(X1,X2,X3,X4) ) ).

cnf(i_0_1165,axiom,
    ( ~ esk6319_4(X1,X2,X3,X4)
    | ~ esk6317_4(X1,X2,X3,X4) ) ).

cnf(i_0_1166,axiom,
    ( ~ esk2583_4(X1,X2,X3,X4)
    | ~ esk2590_4(X1,X2,X3,X4)
    | ~ esk2492_4(X1,X2,X3,X4) ) ).

cnf(i_0_1167,axiom,
    ( esk4097_4(X1,X2,X3,X4)
    | esk4150_4(X1,X2,X3,X4) ) ).

cnf(i_0_1168,axiom,
    ( ~ esk4414_4(X1,X2,X3,X4)
    | esk4415_4(X1,X2,X3,X4) ) ).

cnf(i_0_1169,axiom,
    ( ~ esk12836_4(X1,X2,X3,X4)
    | esk13094_4(X1,X2,X3,X4) ) ).

cnf(i_0_1170,axiom,
    ( ~ esk6161_4(X1,X2,X3,X4)
    | esk6215_4(X1,X2,X3,X4) ) ).

cnf(i_0_1171,axiom,
    ( esk5406_4(X1,X2,X3,X4)
    | ~ esk5405_4(X1,X2,X3,X4) ) ).

cnf(i_0_1172,axiom,
    ( esk5169_4(X1,X2,X3,X4)
    | esk5141_4(X1,X2,X3,X4) ) ).

cnf(i_0_1173,axiom,
    ( ~ esk10013_4(X1,X2,X3,X4)
    | esk10271_4(X1,X2,X3,X4) ) ).

cnf(i_0_1174,axiom,
    ( esk11591_4(X1,X2,X3,X4)
    | esk11592_4(X1,X2,X3,X4)
    | esk11590_4(X1,X2,X3,X4) ) ).

cnf(i_0_1175,axiom,
    ( ~ esk4163_4(X1,X2,X3,X4)
    | ~ esk4111_4(X1,X2,X3,X4)
    | ~ esk4182_4(X1,X2,X3,X4) ) ).

cnf(i_0_1176,axiom,
    ( esk11877_4(X1,X2,X3,X4)
    | ~ esk11847_4(X1,X2,X3,X4) ) ).

cnf(i_0_1177,axiom,
    ( esk2542_4(X1,X2,X3,X4)
    | esk2511_4(X1,X2,X3,X4) ) ).

cnf(i_0_1178,axiom,
    ( ~ esk1264_4(X1,X2,X3,X4)
    | ~ esk1347_4(X1,X2,X3,X4)
    | ~ esk1324_4(X1,X2,X3,X4) ) ).

cnf(i_0_1179,axiom,
    ( esk12639_4(X1,X2,X3,X4)
    | ~ esk12625_4(X1,X2,X3,X4) ) ).

cnf(i_0_1180,axiom,
    ( esk622_4(X1,X2,X3,X4)
    | ~ esk643_4(X1,X2,X3,X4) ) ).

cnf(i_0_1181,axiom,
    ( ~ esk8703_4(X1,X2,X3,X4)
    | ~ esk8681_4(X1,X2,X3,X4)
    | ~ esk8788_4(X1,X2,X3,X4) ) ).

cnf(i_0_1182,axiom,
    ( esk12069_4(X1,X2,X3,X4)
    | ~ esk12327_4(X1,X2,X3,X4) ) ).

cnf(i_0_1183,axiom,
    ( esk12634_4(X1,X2,X3,X4)
    | esk12584_4(X1,X2,X3,X4)
    | ~ esk12635_4(X1,X2,X3,X4) ) ).

cnf(i_0_1184,axiom,
    ( esk3111_4(X1,X2,X3,X4)
    | esk3113_4(X1,X2,X3,X4) ) ).

cnf(i_0_1185,axiom,
    ( esk733_4(X1,X2,X3,X4)
    | esk702_4(X1,X2,X3,X4) ) ).

cnf(i_0_1186,axiom,
    ( ~ esk16733_4(X1,X2,X3,X4)
    | ~ esk16735_4(X1,X2,X3,X4) ) ).

cnf(i_0_1187,axiom,
    ( esk4779_4(X1,X2,X3,X4)
    | ~ esk4521_4(X1,X2,X3,X4) ) ).

cnf(i_0_1188,axiom,
    ( esk6584_4(X1,X2,X3,X4)
    | esk6586_4(X1,X2,X3,X4)
    | ~ esk6590_4(X1,X2,X3,X4) ) ).

cnf(i_0_1189,axiom,
    ( esk496_4(X1,X2,X3,X4)
    | ~ esk754_4(X1,X2,X3,X4) ) ).

cnf(i_0_1190,axiom,
    ( esk15976_4(X1,X2,X3,X4)
    | ~ esk15978_4(X1,X2,X3,X4) ) ).

cnf(i_0_1191,axiom,
    ( esk11478_4(X1,X2,X3,X4)
    | ~ esk11462_4(X1,X2,X3,X4) ) ).

cnf(i_0_1192,axiom,
    ( ~ esk15701_4(X1,X2,X3,X4)
    | esk15654_4(X1,X2,X3,X4)
    | esk15738_4(X1,X2,X3,X4) ) ).

cnf(i_0_1193,axiom,
    ( ~ esk4097_4(X1,X2,X3,X4)
    | ~ esk4148_4(X1,X2,X3,X4)
    | ~ esk4183_4(X1,X2,X3,X4) ) ).

cnf(i_0_1194,axiom,
    ( esk13365_4(X1,X2,X3,X4)
    | ~ esk13241_4(X1,X2,X3,X4) ) ).

cnf(i_0_1195,axiom,
    ( ~ esk12545_4(X1,X2,X3,X4)
    | ~ esk12578_4(X1,X2,X3,X4)
    | ~ esk12534_4(X1,X2,X3,X4) ) ).

cnf(i_0_1196,axiom,
    ( esk11490_4(X1,X2,X3,X4)
    | esk11539_4(X1,X2,X3,X4) ) ).

cnf(i_0_1197,axiom,
    ( ~ esk4261_4(X1,X2,X3,X4)
    | ~ esk4259_4(X1,X2,X3,X4) ) ).

cnf(i_0_1198,axiom,
    ( esk14320_4(X1,X2,X3,X4)
    | esk14360_4(X1,X2,X3,X4) ) ).

cnf(i_0_1199,axiom,
    ( ~ esk4002_4(X1,X2,X3,X4)
    | ~ esk3979_4(X1,X2,X3,X4) ) ).

cnf(i_0_1200,axiom,
    ( esk5236_4(X1,X2,X3,X4)
    | esk5289_4(X1,X2,X3,X4) ) ).

cnf(i_0_1201,axiom,
    ( esk11163_4(X1,X2,X3,X4)
    | ~ esk11191_4(X1,X2,X3,X4) ) ).

cnf(i_0_1202,axiom,
    ( esk14118_4(X1,X2,X3,X4)
    | ~ esk14018_4(X1,X2,X3,X4) ) ).

cnf(i_0_1203,axiom,
    ( esk16115_4(X1,X2,X3,X4)
    | esk16211_4(X1,X2,X3,X4)
    | esk16114_4(X1,X2,X3,X4) ) ).

cnf(i_0_1204,axiom,
    ( ~ esk3796_4(X1,X2,X3,X4)
    | ~ esk3799_4(X1,X2,X3,X4)
    | ~ esk3832_4(X1,X2,X3,X4) ) ).

cnf(i_0_1205,axiom,
    ( esk15407_4(X1,X2,X3,X4)
    | esk15455_4(X1,X2,X3,X4) ) ).

cnf(i_0_1206,axiom,
    ( ~ esk4330_4(X1,X2,X3,X4)
    | ~ esk4417_4(X1,X2,X3,X4)
    | ~ esk4312_4(X1,X2,X3,X4) ) ).

cnf(i_0_1207,axiom,
    ( esk6429_4(X1,X2,X3,X4)
    | ~ esk6351_4(X1,X2,X3,X4) ) ).

cnf(i_0_1208,axiom,
    ( esk12505_4(X1,X2,X3,X4)
    | ~ esk12498_4(X1,X2,X3,X4) ) ).

cnf(i_0_1209,axiom,
    ( ~ esk5194_4(X1,X2,X3,X4)
    | esk5166_4(X1,X2,X3,X4)
    | esk5193_4(X1,X2,X3,X4) ) ).

cnf(i_0_1210,axiom,
    ( ~ esk8747_4(X1,X2,X3,X4)
    | esk8746_4(X1,X2,X3,X4)
    | esk8751_4(X1,X2,X3,X4) ) ).

cnf(i_0_1211,axiom,
    ( esk4036_4(X1,X2,X3,X4)
    | esk4125_4(X1,X2,X3,X4) ) ).

cnf(i_0_1212,axiom,
    ( ~ esk5296_4(X1,X2,X3,X4)
    | ~ esk5301_4(X1,X2,X3,X4) ) ).

cnf(i_0_1213,axiom,
    ( esk12363_4(X1,X2,X3,X4)
    | esk12365_4(X1,X2,X3,X4) ) ).

cnf(i_0_1214,axiom,
    ( esk11825_4(X1,X2,X3,X4)
    | ~ esk11567_4(X1,X2,X3,X4) ) ).

cnf(i_0_1215,axiom,
    ( esk7258_4(X1,X2,X3,X4)
    | esk7175_4(X1,X2,X3,X4)
    | ~ esk7235_4(X1,X2,X3,X4) ) ).

cnf(i_0_1216,axiom,
    ( esk5804_4(X1,X2,X3,X4)
    | esk5803_4(X1,X2,X3,X4) ) ).

cnf(i_0_1217,axiom,
    ( ~ esk13844_4(X1,X2,X3,X4)
    | ~ esk13807_4(X1,X2,X3,X4)
    | ~ esk13845_4(X1,X2,X3,X4) ) ).

cnf(i_0_1218,axiom,
    ( esk10094_4(X1,X2,X3,X4)
    | esk10059_4(X1,X2,X3,X4) ) ).

cnf(i_0_1219,axiom,
    ( esk16698_4(X1,X2,X3,X4)
    | esk16737_4(X1,X2,X3,X4) ) ).

cnf(i_0_1220,axiom,
    ( ~ esk13674_4(X1,X2,X3,X4)
    | ~ esk13646_4(X1,X2,X3,X4) ) ).

cnf(i_0_1221,axiom,
    ( esk14935_4(X1,X2,X3,X4)
    | esk14905_4(X1,X2,X3,X4) ) ).

cnf(i_0_1222,axiom,
    ( esk5610_4(X1,X2,X3,X4)
    | esk5595_4(X1,X2,X3,X4) ) ).

cnf(i_0_1223,axiom,
    ( esk16478_4(X1,X2,X3,X4)
    | esk16443_4(X1,X2,X3,X4)
    | ~ esk16497_4(X1,X2,X3,X4) ) ).

cnf(i_0_1224,axiom,
    esk7855_4(X1,X2,X3,X4) ).

cnf(i_0_1225,axiom,
    ( ~ esk7929_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4)
    | ~ esk7962_4(X1,X2,X3,X4) ) ).

cnf(i_0_1226,axiom,
    ( esk10692_4(X1,X2,X3,X4)
    | ~ esk10706_4(X1,X2,X3,X4)
    | esk10699_4(X1,X2,X3,X4) ) ).

cnf(i_0_1227,axiom,
    ( esk9877_4(X1,X2,X3,X4)
    | ~ esk9907_4(X1,X2,X3,X4) ) ).

cnf(i_0_1228,axiom,
    ( esk7703_4(X1,X2,X3,X4)
    | ~ esk7445_4(X1,X2,X3,X4) ) ).

cnf(i_0_1229,axiom,
    ( ~ esk14784_4(X1,X2,X3,X4)
    | esk14909_4(X1,X2,X3,X4) ) ).

cnf(i_0_1230,axiom,
    ( esk1015_4(X1,X2,X3,X4)
    | ~ esk757_4(X1,X2,X3,X4) ) ).

cnf(i_0_1231,axiom,
    ( esk8681_4(X1,X2,X3,X4)
    | esk8685_4(X1,X2,X3,X4) ) ).

cnf(i_0_1232,axiom,
    ( ~ esk5850_4(X1,X2,X3,X4)
    | esk5889_4(X1,X2,X3,X4) ) ).

cnf(i_0_1233,axiom,
    ( ~ esk9779_4(X1,X2,X3,X4)
    | ~ esk9690_4(X1,X2,X3,X4) ) ).

cnf(i_0_1234,axiom,
    ( esk1298_4(X1,X2,X3,X4)
    | esk1209_4(X1,X2,X3,X4) ) ).

cnf(i_0_1235,axiom,
    ( esk9036_4(X1,X2,X3,X4)
    | esk9018_4(X1,X2,X3,X4) ) ).

cnf(i_0_1236,axiom,
    ( esk7727_4(X1,X2,X3,X4)
    | ~ esk7600_4(X1,X2,X3,X4) ) ).

cnf(i_0_1237,axiom,
    ( esk11597_4(X1,X2,X3,X4)
    | esk11596_4(X1,X2,X3,X4)
    | esk11588_4(X1,X2,X3,X4) ) ).

cnf(i_0_1238,axiom,
    ( esk7138_4(X1,X2,X3,X4)
    | esk7117_4(X1,X2,X3,X4)
    | esk7139_4(X1,X2,X3,X4) ) ).

cnf(i_0_1239,axiom,
    ( esk7719_4(X1,X2,X3,X4)
    | ~ esk7721_4(X1,X2,X3,X4) ) ).

cnf(i_0_1240,axiom,
    ( ~ esk11836_4(X1,X2,X3,X4)
    | esk11838_4(X1,X2,X3,X4) ) ).

cnf(i_0_1241,axiom,
    ( esk3328_4(X1,X2,X3,X4)
    | ~ esk3226_4(X1,X2,X3,X4) ) ).

cnf(i_0_1242,axiom,
    ( ~ p(X3)
    | p(X1)
    | ~ esk16707_4(X1,X2,X3,X4)
    | esk264_0
    | ~ p(X2)
    | p(X4) ) ).

cnf(i_0_1243,axiom,
    ( ~ esk6240_4(X1,X2,X3,X4)
    | ~ esk6159_4(X1,X2,X3,X4) ) ).

cnf(i_0_1244,axiom,
    ( ~ esk5288_4(X1,X2,X3,X4)
    | esk5291_4(X1,X2,X3,X4) ) ).

cnf(i_0_1245,axiom,
    ( ~ esk11229_4(X1,X2,X3,X4)
    | ~ esk11328_4(X1,X2,X3,X4) ) ).

cnf(i_0_1246,axiom,
    ( ~ esk6477_4(X1,X2,X3,X4)
    | ~ esk6368_4(X1,X2,X3,X4)
    | ~ esk6394_4(X1,X2,X3,X4) ) ).

cnf(i_0_1247,axiom,
    ( esk7968_4(X1,X2,X3,X4)
    | ~ esk7710_4(X1,X2,X3,X4) ) ).

cnf(i_0_1248,axiom,
    ( ~ esk1602_4(X1,X2,X3,X4)
    | esk1601_4(X1,X2,X3,X4) ) ).

cnf(i_0_1249,axiom,
    ( esk7700_4(X1,X2,X3,X4)
    | ~ esk7643_4(X1,X2,X3,X4) ) ).

cnf(i_0_1250,axiom,
    ( ~ esk12555_4(X1,X2,X3,X4)
    | ~ esk12534_4(X1,X2,X3,X4)
    | ~ esk12588_4(X1,X2,X3,X4) ) ).

cnf(i_0_1251,axiom,
    ( esk8110_4(X1,X2,X3,X4)
    | ~ esk8067_4(X1,X2,X3,X4) ) ).

cnf(i_0_1252,axiom,
    ( ~ esk14005_4(X1,X2,X3,X4)
    | esk14057_4(X1,X2,X3,X4) ) ).

cnf(i_0_1253,axiom,
    ( ~ esk8269_4(X1,X2,X3,X4)
    | esk8270_4(X1,X2,X3,X4) ) ).

cnf(i_0_1254,axiom,
    ( ~ esk7228_4(X1,X2,X3,X4)
    | ~ esk7189_4(X1,X2,X3,X4) ) ).

cnf(i_0_1255,axiom,
    ( esk13070_4(X1,X2,X3,X4)
    | esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_1256,axiom,
    ( esk519_4(X1,X2,X3,X4)
    | ~ esk393_4(X1,X2,X3,X4) ) ).

cnf(i_0_1257,axiom,
    ( ~ esk7232_4(X1,X2,X3,X4)
    | ~ esk7261_4(X1,X2,X3,X4)
    | ~ esk7181_4(X1,X2,X3,X4) ) ).

cnf(i_0_1258,axiom,
    ( ~ esk11052_4(X1,X2,X3,X4)
    | ~ esk11050_4(X1,X2,X3,X4)
    | ~ esk11078_4(X1,X2,X3,X4)
    | ~ esk11080_4(X1,X2,X3,X4) ) ).

cnf(i_0_1259,axiom,
    ( ~ p(X3)
    | ~ p(X4)
    | ~ esk517_4(X1,X2,X3,X4)
    | p(X1)
    | esk264_0
    | ~ p(X2) ) ).

cnf(i_0_1260,axiom,
    ( esk16654_4(X1,X2,X3,X4)
    | esk16768_4(X1,X2,X3,X4) ) ).

cnf(i_0_1261,axiom,
    ( ~ esk9237_4(X1,X2,X3,X4)
    | esk8979_4(X1,X2,X3,X4) ) ).

cnf(i_0_1262,axiom,
    ( esk13395_4(X1,X2,X3,X4)
    | esk13357_4(X1,X2,X3,X4)
    | ~ esk13411_4(X1,X2,X3,X4) ) ).

cnf(i_0_1263,axiom,
    ( ~ esk5924_4(X1,X2,X3,X4)
    | esk5920_4(X1,X2,X3,X4) ) ).

cnf(i_0_1264,axiom,
    ( esk11370_4(X1,X2,X3,X4)
    | ~ esk11347_4(X1,X2,X3,X4)
    | esk11287_4(X1,X2,X3,X4) ) ).

cnf(i_0_1265,axiom,
    ( esk14434_4(X1,X2,X3,X4)
    | ~ esk14433_4(X1,X2,X3,X4) ) ).

cnf(i_0_1266,axiom,
    ( ~ esk3866_4(X1,X2,X3,X4)
    | esk3864_4(X1,X2,X3,X4) ) ).

cnf(i_0_1267,axiom,
    ( ~ esk11964_4(X1,X2,X3,X4)
    | esk11932_4(X1,X2,X3,X4) ) ).

cnf(i_0_1268,axiom,
    ( p(X2)
    | ~ esk95_0
    | ~ p(X3)
    | esk495_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X1) ) ).

cnf(i_0_1269,axiom,
    ( esk7655_4(X1,X2,X3,X4)
    | esk7650_4(X1,X2,X3,X4) ) ).

cnf(i_0_1270,axiom,
    ( ~ esk11723_4(X1,X2,X3,X4)
    | ~ esk11724_4(X1,X2,X3,X4) ) ).

cnf(i_0_1271,axiom,
    ( esk10164_4(X1,X2,X3,X4)
    | ~ esk10134_4(X1,X2,X3,X4) ) ).

cnf(i_0_1272,axiom,
    ( esk2593_4(X1,X2,X3,X4)
    | esk2601_4(X1,X2,X3,X4)
    | esk2602_4(X1,X2,X3,X4) ) ).

cnf(i_0_1273,axiom,
    ( ~ esk8378_4(X1,X2,X3,X4)
    | esk8394_4(X1,X2,X3,X4) ) ).

cnf(i_0_1274,axiom,
    ( ~ esk10829_4(X1,X2,X3,X4)
    | ~ esk10830_4(X1,X2,X3,X4) ) ).

cnf(i_0_1275,axiom,
    ( ~ esk16732_4(X1,X2,X3,X4)
    | ~ esk16775_4(X1,X2,X3,X4)
    | ~ esk16706_4(X1,X2,X3,X4) ) ).

cnf(i_0_1276,axiom,
    ( esk12946_4(X1,X2,X3,X4)
    | esk12999_4(X1,X2,X3,X4) ) ).

cnf(i_0_1277,axiom,
    ( esk5918_4(X1,X2,X3,X4)
    | ~ esk5797_4(X1,X2,X3,X4) ) ).

cnf(i_0_1278,axiom,
    ( esk14407_4(X1,X2,X3,X4)
    | esk14406_4(X1,X2,X3,X4)
    | ~ esk14408_4(X1,X2,X3,X4) ) ).

cnf(i_0_1279,axiom,
    ( esk10942_4(X1,X2,X3,X4)
    | ~ esk10926_4(X1,X2,X3,X4) ) ).

cnf(i_0_1280,axiom,
    ( esk3372_4(X1,X2,X3,X4)
    | esk3413_4(X1,X2,X3,X4)
    | esk3373_4(X1,X2,X3,X4)
    | esk3374_4(X1,X2,X3,X4) ) ).

cnf(i_0_1281,axiom,
    ( ~ esk13903_4(X1,X2,X3,X4)
    | ~ esk13885_4(X1,X2,X3,X4)
    | ~ esk13883_4(X1,X2,X3,X4) ) ).

cnf(i_0_1282,axiom,
    ( esk10943_4(X1,X2,X3,X4)
    | esk10891_4(X1,X2,X3,X4) ) ).

cnf(i_0_1283,axiom,
    ( ~ esk16582_4(X1,X2,X3,X4)
    | esk16706_4(X1,X2,X3,X4) ) ).

cnf(i_0_1284,axiom,
    ( ~ esk7220_4(X1,X2,X3,X4)
    | esk7175_4(X1,X2,X3,X4) ) ).

cnf(i_0_1285,axiom,
    ( ~ esk7619_4(X1,X2,X3,X4)
    | esk7610_4(X1,X2,X3,X4) ) ).

cnf(i_0_1286,axiom,
    ( esk9239_4(X1,X2,X3,X4)
    | ~ esk9137_4(X1,X2,X3,X4) ) ).

cnf(i_0_1287,axiom,
    ( ~ esk14275_4(X1,X2,X3,X4)
    | esk14247_4(X1,X2,X3,X4) ) ).

cnf(i_0_1288,axiom,
    ( ~ esk5582_4(X1,X2,X3,X4)
    | esk5654_4(X1,X2,X3,X4) ) ).

cnf(i_0_1289,axiom,
    ( ~ esk6464_4(X1,X2,X3,X4)
    | esk6404_4(X1,X2,X3,X4)
    | esk6487_4(X1,X2,X3,X4) ) ).

cnf(i_0_1290,axiom,
    ( esk2898_4(X1,X2,X3,X4)
    | esk2863_4(X1,X2,X3,X4) ) ).

cnf(i_0_1291,axiom,
    ( esk1091_4(X1,X2,X3,X4)
    | esk1065_4(X1,X2,X3,X4)
    | ~ esk1066_4(X1,X2,X3,X4) ) ).

cnf(i_0_1292,axiom,
    ( ~ esk13003_4(X1,X2,X3,X4)
    | esk12745_4(X1,X2,X3,X4) ) ).

cnf(i_0_1293,axiom,
    ( esk16621_4(X1,X2,X3,X4)
    | ~ esk16622_4(X1,X2,X3,X4) ) ).

cnf(i_0_1294,axiom,
    ( esk6921_4(X1,X2,X3,X4)
    | ~ esk7179_4(X1,X2,X3,X4) ) ).

cnf(i_0_1295,axiom,
    ( esk15089_4(X1,X2,X3,X4)
    | esk15135_4(X1,X2,X3,X4) ) ).

cnf(i_0_1296,axiom,
    ( esk2813_4(X1,X2,X3,X4)
    | ~ esk3071_4(X1,X2,X3,X4) ) ).

cnf(i_0_1297,axiom,
    ( esk13676_4(X1,X2,X3,X4)
    | ~ esk13677_4(X1,X2,X3,X4) ) ).

cnf(i_0_1298,axiom,
    ( esk5566_4(X1,X2,X3,X4)
    | ~ esk5552_4(X1,X2,X3,X4) ) ).

cnf(i_0_1299,axiom,
    ( ~ esk7382_4(X1,X2,X3,X4)
    | ~ esk7419_4(X1,X2,X3,X4)
    | ~ esk7420_4(X1,X2,X3,X4) ) ).

cnf(i_0_1300,axiom,
    ( ~ esk13142_4(X1,X2,X3,X4)
    | esk13174_4(X1,X2,X3,X4) ) ).

cnf(i_0_1301,axiom,
    ( ~ esk10273_4(X1,X2,X3,X4)
    | ~ esk10312_4(X1,X2,X3,X4) ) ).

cnf(i_0_1302,axiom,
    ( esk16722_4(X1,X2,X3,X4)
    | ~ esk16723_4(X1,X2,X3,X4) ) ).

cnf(i_0_1303,axiom,
    ( esk15365_4(X1,X2,X3,X4)
    | esk15363_4(X1,X2,X3,X4) ) ).

cnf(i_0_1304,axiom,
    ( esk7668_4(X1,X2,X3,X4)
    | esk7651_4(X1,X2,X3,X4) ) ).

cnf(i_0_1305,axiom,
    ( esk7497_4(X1,X2,X3,X4)
    | ~ esk7495_4(X1,X2,X3,X4)
    | ~ esk7496_4(X1,X2,X3,X4) ) ).

cnf(i_0_1306,axiom,
    ( esk14335_4(X1,X2,X3,X4)
    | esk14349_4(X1,X2,X3,X4) ) ).

cnf(i_0_1307,axiom,
    ( ~ esk7974_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4)
    | ~ esk7941_4(X1,X2,X3,X4) ) ).

cnf(i_0_1308,axiom,
    ( esk7249_4(X1,X2,X3,X4)
    | esk7221_4(X1,X2,X3,X4) ) ).

cnf(i_0_1309,axiom,
    ( ~ esk8501_4(X1,X2,X3,X4)
    | esk8243_4(X1,X2,X3,X4) ) ).

cnf(i_0_1310,axiom,
    ( ~ esk8926_4(X1,X2,X3,X4)
    | esk8989_4(X1,X2,X3,X4) ) ).

cnf(i_0_1311,axiom,
    ( ~ esk2456_4(X1,X2,X3,X4)
    | esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_1312,axiom,
    ( ~ p(X4)
    | p(X1)
    | p(X2)
    | ~ esk170_0
    | esk505_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_1313,axiom,
    ( esk8690_4(X1,X2,X3,X4)
    | esk8723_4(X1,X2,X3,X4) ) ).

cnf(i_0_1314,axiom,
    ( esk6896_4(X1,X2,X3,X4)
    | esk6873_4(X1,X2,X3,X4) ) ).

cnf(i_0_1315,axiom,
    ( ~ esk3342_4(X1,X2,X3,X4)
    | esk3368_4(X1,X2,X3,X4)
    | esk3393_4(X1,X2,X3,X4) ) ).

cnf(i_0_1316,axiom,
    ( ~ esk9043_4(X1,X2,X3,X4)
    | ~ esk8938_4(X1,X2,X3,X4)
    | ~ esk8956_4(X1,X2,X3,X4) ) ).

cnf(i_0_1317,axiom,
    ( esk7727_4(X1,X2,X3,X4)
    | ~ esk7728_4(X1,X2,X3,X4) ) ).

cnf(i_0_1318,axiom,
    ( esk9615_4(X1,X2,X3,X4)
    | ~ esk9640_4(X1,X2,X3,X4) ) ).

cnf(i_0_1319,axiom,
    ( esk2527_4(X1,X2,X3,X4)
    | esk2504_4(X1,X2,X3,X4) ) ).

cnf(i_0_1320,axiom,
    ( esk4520_4(X1,X2,X3,X4)
    | esk4518_4(X1,X2,X3,X4) ) ).

cnf(i_0_1321,axiom,
    ( ~ esk6403_4(X1,X2,X3,X4)
    | esk6364_4(X1,X2,X3,X4) ) ).

cnf(i_0_1322,axiom,
    ( esk7504_4(X1,X2,X3,X4)
    | ~ esk7452_4(X1,X2,X3,X4)
    | esk7523_4(X1,X2,X3,X4) ) ).

cnf(i_0_1323,axiom,
    ( ~ esk11846_4(X1,X2,X3,X4)
    | esk11883_4(X1,X2,X3,X4)
    | esk11799_4(X1,X2,X3,X4) ) ).

cnf(i_0_1324,axiom,
    ( esk1012_4(X1,X2,X3,X4)
    | ~ esk1270_4(X1,X2,X3,X4) ) ).

cnf(i_0_1325,axiom,
    ( esk7631_4(X1,X2,X3,X4)
    | esk7597_4(X1,X2,X3,X4)
    | esk7651_4(X1,X2,X3,X4) ) ).

cnf(i_0_1326,axiom,
    ( esk6153_4(X1,X2,X3,X4)
    | esk6239_4(X1,X2,X3,X4) ) ).

cnf(i_0_1327,axiom,
    ( esk9391_4(X1,X2,X3,X4)
    | ~ esk9400_4(X1,X2,X3,X4)
    | ~ esk9490_4(X1,X2,X3,X4) ) ).

cnf(i_0_1328,axiom,
    ( ~ esk11526_4(X1,X2,X3,X4)
    | ~ esk11508_4(X1,X2,X3,X4)
    | ~ esk11613_4(X1,X2,X3,X4) ) ).

cnf(i_0_1329,axiom,
    ( esk11515_4(X1,X2,X3,X4)
    | esk11548_4(X1,X2,X3,X4) ) ).

cnf(i_0_1330,axiom,
    ( ~ esk2083_4(X1,X2,X3,X4)
    | ~ esk2057_4(X1,X2,X3,X4)
    | ~ esk2108_4(X1,X2,X3,X4) ) ).

cnf(i_0_1331,axiom,
    ( esk2062_4(X1,X2,X3,X4)
    | ~ esk1981_4(X1,X2,X3,X4) ) ).

cnf(i_0_1332,axiom,
    ( esk7709_4(X1,X2,X3,X4)
    | esk7761_4(X1,X2,X3,X4)
    | ~ esk7780_4(X1,X2,X3,X4) ) ).

cnf(i_0_1333,axiom,
    ( esk11758_4(X1,X2,X3,X4)
    | ~ esk11806_4(X1,X2,X3,X4) ) ).

cnf(i_0_1334,axiom,
    ( ~ esk805_4(X1,X2,X3,X4)
    | ~ esk760_4(X1,X2,X3,X4)
    | ~ esk804_4(X1,X2,X3,X4) ) ).

cnf(i_0_1335,axiom,
    ( esk13247_4(X1,X2,X3,X4)
    | ~ esk13347_4(X1,X2,X3,X4)
    | ~ esk13255_4(X1,X2,X3,X4) ) ).

cnf(i_0_1336,axiom,
    ( ~ esk4370_4(X1,X2,X3,X4)
    | ~ esk4337_4(X1,X2,X3,X4)
    | ~ esk4310_4(X1,X2,X3,X4) ) ).

cnf(i_0_1337,axiom,
    ( ~ esk4535_4(X1,X2,X3,X4)
    | esk4533_4(X1,X2,X3,X4) ) ).

cnf(i_0_1338,axiom,
    ( ~ esk9541_4(X1,X2,X3,X4)
    | ~ esk9502_4(X1,X2,X3,X4) ) ).

cnf(i_0_1339,axiom,
    ( esk1080_4(X1,X2,X3,X4)
    | esk997_4(X1,X2,X3,X4) ) ).

cnf(i_0_1340,axiom,
    ( esk15947_4(X1,X2,X3,X4)
    | esk15855_4(X1,X2,X3,X4)
    | esk15954_4(X1,X2,X3,X4) ) ).

cnf(i_0_1341,axiom,
    ( esk8733_4(X1,X2,X3,X4)
    | ~ esk8475_4(X1,X2,X3,X4) ) ).

cnf(i_0_1342,axiom,
    ( ~ p(X1)
    | esk212_0
    | ~ esk509_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X2)
    | ~ p(X3) ) ).

cnf(i_0_1343,axiom,
    ( ~ esk5167_4(X1,X2,X3,X4)
    | ~ esk5141_4(X1,X2,X3,X4)
    | ~ esk5210_4(X1,X2,X3,X4) ) ).

cnf(i_0_1344,axiom,
    ( esk16648_4(X1,X2,X3,X4)
    | esk16670_4(X1,X2,X3,X4) ) ).

cnf(i_0_1345,axiom,
    ( esk3544_4(X1,X2,X3,X4)
    | esk3537_4(X1,X2,X3,X4) ) ).

cnf(i_0_1346,axiom,
    ( ~ esk1701_4(X1,X2,X3,X4)
    | ~ esk1702_4(X1,X2,X3,X4) ) ).

cnf(i_0_1347,axiom,
    ( esk3405_4(X1,X2,X3,X4)
    | esk3415_4(X1,X2,X3,X4) ) ).

cnf(i_0_1348,axiom,
    ( esk14202_4(X1,X2,X3,X4)
    | ~ esk14201_4(X1,X2,X3,X4) ) ).

cnf(i_0_1349,axiom,
    ( esk10753_4(X1,X2,X3,X4)
    | esk10727_4(X1,X2,X3,X4) ) ).

cnf(i_0_1350,axiom,
    ( ~ p(X4)
    | esk16605_4(X1,X2,X3,X4)
    | ~ esk1_0
    | ~ p(X3)
    | ~ p(X2)
    | ~ p(X1) ) ).

cnf(i_0_1351,axiom,
    ( esk8005_4(X1,X2,X3,X4)
    | ~ esk8030_4(X1,X2,X3,X4)
    | esk8004_4(X1,X2,X3,X4) ) ).

cnf(i_0_1352,axiom,
    ( ~ esk662_4(X1,X2,X3,X4)
    | esk638_4(X1,X2,X3,X4) ) ).

cnf(i_0_1353,axiom,
    ( ~ esk2325_4(X1,X2,X3,X4)
    | esk2324_4(X1,X2,X3,X4) ) ).

cnf(i_0_1354,axiom,
    ( esk5557_4(X1,X2,X3,X4)
    | esk5559_4(X1,X2,X3,X4)
    | esk5556_4(X1,X2,X3,X4)
    | esk5553_4(X1,X2,X3,X4) ) ).

cnf(i_0_1355,axiom,
    ( ~ esk14059_4(X1,X2,X3,X4)
    | ~ esk14058_4(X1,X2,X3,X4) ) ).

cnf(i_0_1356,axiom,
    ( ~ esk3845_4(X1,X2,X3,X4)
    | esk3788_4(X1,X2,X3,X4) ) ).

cnf(i_0_1357,axiom,
    ( ~ esk14431_4(X1,X2,X3,X4)
    | ~ esk14371_4(X1,X2,X3,X4)
    | ~ esk14454_4(X1,X2,X3,X4) ) ).

cnf(i_0_1358,axiom,
    ( esk5597_4(X1,X2,X3,X4)
    | esk5611_4(X1,X2,X3,X4) ) ).

cnf(i_0_1359,axiom,
    ( ~ esk15869_4(X1,X2,X3,X4)
    | ~ esk15889_4(X1,X2,X3,X4)
    | ~ esk15888_4(X1,X2,X3,X4) ) ).

cnf(i_0_1360,axiom,
    ( esk13909_4(X1,X2,X3,X4)
    | esk13873_4(X1,X2,X3,X4) ) ).

cnf(i_0_1361,axiom,
    ( esk5174_4(X1,X2,X3,X4)
    | esk5176_4(X1,X2,X3,X4)
    | esk5175_4(X1,X2,X3,X4) ) ).

cnf(i_0_1362,axiom,
    ( esk1254_4(X1,X2,X3,X4)
    | esk1213_4(X1,X2,X3,X4) ) ).

cnf(i_0_1363,axiom,
    ( ~ esk3498_4(X1,X2,X3,X4)
    | esk3756_4(X1,X2,X3,X4) ) ).

cnf(i_0_1364,axiom,
    ( ~ esk8795_4(X1,X2,X3,X4)
    | esk8796_4(X1,X2,X3,X4) ) ).

cnf(i_0_1365,axiom,
    ( esk2033_4(X1,X2,X3,X4)
    | ~ esk1775_4(X1,X2,X3,X4) ) ).

cnf(i_0_1366,axiom,
    ( ~ esk2511_4(X1,X2,X3,X4)
    | ~ esk2457_4(X1,X2,X3,X4) ) ).

cnf(i_0_1367,axiom,
    ( ~ esk10572_4(X1,X2,X3,X4)
    | ~ esk10524_4(X1,X2,X3,X4) ) ).

cnf(i_0_1368,axiom,
    ( esk4284_4(X1,X2,X3,X4)
    | ~ esk4288_4(X1,X2,X3,X4) ) ).

cnf(i_0_1369,axiom,
    ( esk7181_4(X1,X2,X3,X4)
    | esk7261_4(X1,X2,X3,X4)
    | ~ esk7232_4(X1,X2,X3,X4) ) ).

cnf(i_0_1370,axiom,
    ( esk11300_4(X1,X2,X3,X4)
    | ~ esk11240_4(X1,X2,X3,X4) ) ).

cnf(i_0_1371,axiom,
    ( esk1796_4(X1,X2,X3,X4)
    | esk1827_4(X1,X2,X3,X4) ) ).

cnf(i_0_1372,axiom,
    ( esk732_4(X1,X2,X3,X4)
    | esk714_4(X1,X2,X3,X4) ) ).

cnf(i_0_1373,axiom,
    ( ~ esk8006_4(X1,X2,X3,X4)
    | ~ esk8029_4(X1,X2,X3,X4)
    | ~ esk7946_4(X1,X2,X3,X4) ) ).

cnf(i_0_1374,axiom,
    ( ~ esk1167_4(X1,X2,X3,X4)
    | esk1266_4(X1,X2,X3,X4) ) ).

cnf(i_0_1375,axiom,
    ( esk12397_4(X1,X2,X3,X4)
    | esk12281_4(X1,X2,X3,X4) ) ).

cnf(i_0_1376,axiom,
    ( ~ esk11727_4(X1,X2,X3,X4)
    | esk11734_4(X1,X2,X3,X4) ) ).

cnf(i_0_1377,axiom,
    ( ~ esk9059_4(X1,X2,X3,X4)
    | ~ esk9066_4(X1,X2,X3,X4)
    | ~ esk8978_4(X1,X2,X3,X4) ) ).

cnf(i_0_1378,axiom,
    ( ~ esk909_4(X1,X2,X3,X4)
    | esk919_4(X1,X2,X3,X4) ) ).

cnf(i_0_1379,axiom,
    ( ~ esk3567_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4)
    | ~ esk3650_4(X1,X2,X3,X4) ) ).

cnf(i_0_1380,axiom,
    ( ~ p(X2)
    | ~ p(X3)
    | ~ esk158_0
    | p(X1)
    | p(X4)
    | esk503_4(X1,X2,X3,X4) ) ).

cnf(i_0_1381,axiom,
    ( ~ esk2814_4(X1,X2,X3,X4)
    | ~ esk2862_4(X1,X2,X3,X4) ) ).

cnf(i_0_1382,axiom,
    ( ~ esk14022_4(X1,X2,X3,X4)
    | ~ esk14077_4(X1,X2,X3,X4) ) ).

cnf(i_0_1383,axiom,
    ( esk1069_4(X1,X2,X3,X4)
    | esk1051_4(X1,X2,X3,X4) ) ).

cnf(i_0_1384,axiom,
    ( esk2977_4(X1,X2,X3,X4)
    | esk2976_4(X1,X2,X3,X4) ) ).

cnf(i_0_1385,axiom,
    ( ~ esk9283_4(X1,X2,X3,X4)
    | ~ esk9285_4(X1,X2,X3,X4) ) ).

cnf(i_0_1386,axiom,
    ( p(X4)
    | ~ esk114_0
    | ~ p(X2)
    | ~ p(X3)
    | esk16687_4(X1,X2,X3,X4)
    | p(X1) ) ).

cnf(i_0_1387,axiom,
    ( esk14872_4(X1,X2,X3,X4)
    | esk14835_4(X1,X2,X3,X4) ) ).

cnf(i_0_1388,axiom,
    ( ~ esk9400_4(X1,X2,X3,X4)
    | esk9376_4(X1,X2,X3,X4) ) ).

cnf(i_0_1389,axiom,
    ( esk1447_4(X1,X2,X3,X4)
    | esk1446_4(X1,X2,X3,X4)
    | esk1441_4(X1,X2,X3,X4) ) ).

cnf(i_0_1390,axiom,
    ( ~ esk2296_4(X1,X2,X3,X4)
    | esk2384_4(X1,X2,X3,X4)
    | esk2377_4(X1,X2,X3,X4) ) ).

cnf(i_0_1391,axiom,
    ( esk13888_4(X1,X2,X3,X4)
    | ~ esk13768_4(X1,X2,X3,X4) ) ).

cnf(i_0_1392,axiom,
    ( esk9680_4(X1,X2,X3,X4)
    | esk9662_4(X1,X2,X3,X4) ) ).

cnf(i_0_1393,axiom,
    ( ~ esk6591_4(X1,X2,X3,X4)
    | esk6589_4(X1,X2,X3,X4) ) ).

cnf(i_0_1394,axiom,
    ( esk2211_4(X1,X2,X3,X4)
    | esk2212_4(X1,X2,X3,X4) ) ).

cnf(i_0_1395,axiom,
    ( ~ esk2872_4(X1,X2,X3,X4)
    | ~ esk2858_4(X1,X2,X3,X4) ) ).

cnf(i_0_1396,axiom,
    ( esk4316_4(X1,X2,X3,X4)
    | esk4312_4(X1,X2,X3,X4) ) ).

cnf(i_0_1397,axiom,
    ( esk5545_4(X1,X2,X3,X4)
    | ~ esk5535_4(X1,X2,X3,X4) ) ).

cnf(i_0_1398,axiom,
    ( ~ esk1947_4(X1,X2,X3,X4)
    | esk1939_4(X1,X2,X3,X4)
    | ~ esk2039_4(X1,X2,X3,X4) ) ).

cnf(i_0_1399,axiom,
    ( esk8712_4(X1,X2,X3,X4)
    | esk8745_4(X1,X2,X3,X4) ) ).

cnf(i_0_1400,axiom,
    ( ~ esk12762_4(X1,X2,X3,X4)
    | esk12755_4(X1,X2,X3,X4)
    | esk12748_4(X1,X2,X3,X4) ) ).

cnf(i_0_1401,axiom,
    ( ~ esk8886_4(X1,X2,X3,X4)
    | esk8862_4(X1,X2,X3,X4) ) ).

cnf(i_0_1402,axiom,
    ( esk14400_4(X1,X2,X3,X4)
    | esk14282_4(X1,X2,X3,X4) ) ).

cnf(i_0_1403,axiom,
    ( esk11035_4(X1,X2,X3,X4)
    | ~ esk10987_4(X1,X2,X3,X4) ) ).

cnf(i_0_1404,axiom,
    ( esk13748_4(X1,X2,X3,X4)
    | ~ esk13800_4(X1,X2,X3,X4) ) ).

cnf(i_0_1405,axiom,
    ( ~ esk10541_4(X1,X2,X3,X4)
    | esk10799_4(X1,X2,X3,X4) ) ).

cnf(i_0_1406,axiom,
    ( esk5683_4(X1,X2,X3,X4)
    | esk5653_4(X1,X2,X3,X4) ) ).

cnf(i_0_1407,axiom,
    ( esk16468_4(X1,X2,X3,X4)
    | ~ esk16210_4(X1,X2,X3,X4) ) ).

cnf(i_0_1408,axiom,
    ( ~ esk9452_4(X1,X2,X3,X4)
    | ~ esk9569_4(X1,X2,X3,X4)
    | ~ esk9482_4(X1,X2,X3,X4) ) ).

cnf(i_0_1409,axiom,
    ( esk3611_4(X1,X2,X3,X4)
    | ~ esk3607_4(X1,X2,X3,X4)
    | esk3606_4(X1,X2,X3,X4) ) ).

cnf(i_0_1410,axiom,
    ( esk15617_4(X1,X2,X3,X4)
    | esk15621_4(X1,X2,X3,X4) ) ).

cnf(i_0_1411,axiom,
    ( ~ esk8671_4(X1,X2,X3,X4)
    | ~ esk8697_4(X1,X2,X3,X4)
    | ~ esk8696_4(X1,X2,X3,X4) ) ).

cnf(i_0_1412,axiom,
    ( esk15904_4(X1,X2,X3,X4)
    | esk15937_4(X1,X2,X3,X4) ) ).

cnf(i_0_1413,axiom,
    ( esk8952_4(X1,X2,X3,X4)
    | esk9035_4(X1,X2,X3,X4) ) ).

cnf(i_0_1414,axiom,
    ( ~ esk4569_4(X1,X2,X3,X4)
    | ~ esk4591_4(X1,X2,X3,X4)
    | ~ esk4676_4(X1,X2,X3,X4) ) ).

cnf(i_0_1415,axiom,
    ( ~ esk9025_4(X1,X2,X3,X4)
    | ~ esk9023_4(X1,X2,X3,X4) ) ).

cnf(i_0_1416,axiom,
    ( ~ esk6420_4(X1,X2,X3,X4)
    | ~ esk6455_4(X1,X2,X3,X4)
    | ~ esk6456_4(X1,X2,X3,X4) ) ).

cnf(i_0_1417,axiom,
    ( esk7088_4(X1,X2,X3,X4)
    | esk7035_4(X1,X2,X3,X4) ) ).

cnf(i_0_1418,axiom,
    ( ~ esk2463_4(X1,X2,X3,X4)
    | ~ esk2435_4(X1,X2,X3,X4) ) ).

cnf(i_0_1419,axiom,
    ( esk16066_4(X1,X2,X3,X4)
    | ~ esk16082_4(X1,X2,X3,X4)
    | ~ esk16188_4(X1,X2,X3,X4) ) ).

cnf(i_0_1420,axiom,
    ( ~ esk4909_4(X1,X2,X3,X4)
    | esk4937_4(X1,X2,X3,X4) ) ).

cnf(i_0_1421,axiom,
    ( esk9199_4(X1,X2,X3,X4)
    | esk9314_4(X1,X2,X3,X4) ) ).

cnf(i_0_1422,axiom,
    ( esk11870_4(X1,X2,X3,X4)
    | ~ esk11869_4(X1,X2,X3,X4)
    | ~ esk11868_4(X1,X2,X3,X4) ) ).

cnf(i_0_1423,axiom,
    ( esk5612_4(X1,X2,X3,X4)
    | esk5595_4(X1,X2,X3,X4) ) ).

cnf(i_0_1424,axiom,
    ( ~ esk6982_4(X1,X2,X3,X4)
    | esk6983_4(X1,X2,X3,X4)
    | ~ esk6981_4(X1,X2,X3,X4) ) ).

cnf(i_0_1425,axiom,
    ( esk11577_4(X1,X2,X3,X4)
    | ~ esk11835_4(X1,X2,X3,X4) ) ).

cnf(i_0_1426,axiom,
    ( esk3226_4(X1,X2,X3,X4)
    | ~ esk3194_4(X1,X2,X3,X4) ) ).

cnf(i_0_1427,axiom,
    ( esk2345_4(X1,X2,X3,X4)
    | esk2306_4(X1,X2,X3,X4) ) ).

cnf(i_0_1428,axiom,
    ( esk5127_4(X1,X2,X3,X4)
    | ~ esk4869_4(X1,X2,X3,X4) ) ).

cnf(i_0_1429,axiom,
    ( esk2204_4(X1,X2,X3,X4)
    | ~ esk2193_4(X1,X2,X3,X4) ) ).

cnf(i_0_1430,axiom,
    ( ~ esk10797_4(X1,X2,X3,X4)
    | ~ esk10735_4(X1,X2,X3,X4)
    | ~ esk10764_4(X1,X2,X3,X4) ) ).

cnf(i_0_1431,axiom,
    ( ~ esk12282_4(X1,X2,X3,X4)
    | ~ esk12315_4(X1,X2,X3,X4)
    | ~ esk12277_4(X1,X2,X3,X4) ) ).

cnf(i_0_1432,axiom,
    ( ~ esk4180_4(X1,X2,X3,X4)
    | ~ esk4179_4(X1,X2,X3,X4)
    | esk4181_4(X1,X2,X3,X4) ) ).

cnf(i_0_1433,axiom,
    ( esk16265_4(X1,X2,X3,X4)
    | esk16142_4(X1,X2,X3,X4) ) ).

cnf(i_0_1434,axiom,
    ( esk662_4(X1,X2,X3,X4)
    | ~ esk642_4(X1,X2,X3,X4) ) ).

cnf(i_0_1435,axiom,
    ( p(X4)
    | ~ p(X3)
    | ~ p(X2)
    | esk16705_4(X1,X2,X3,X4)
    | p(X1)
    | ~ esk249_0 ) ).

cnf(i_0_1436,axiom,
    ( ~ esk16332_4(X1,X2,X3,X4)
    | esk16339_4(X1,X2,X3,X4) ) ).

cnf(i_0_1437,axiom,
    ( esk3059_4(X1,X2,X3,X4)
    | esk3027_4(X1,X2,X3,X4) ) ).

cnf(i_0_1438,axiom,
    ( esk16480_4(X1,X2,X3,X4)
    | esk16441_4(X1,X2,X3,X4) ) ).

cnf(i_0_1439,axiom,
    ( esk8182_4(X1,X2,X3,X4)
    | esk8157_4(X1,X2,X3,X4) ) ).

cnf(i_0_1440,axiom,
    ( ~ esk9302_4(X1,X2,X3,X4)
    | ~ esk9217_4(X1,X2,X3,X4)
    | ~ esk9195_4(X1,X2,X3,X4) ) ).

cnf(i_0_1441,axiom,
    ( ~ esk10573_4(X1,X2,X3,X4)
    | ~ esk10522_4(X1,X2,X3,X4)
    | ~ esk10602_4(X1,X2,X3,X4) ) ).

cnf(i_0_1442,axiom,
    ( ~ esk431_4(X1,X2,X3,X4)
    | esk430_4(X1,X2,X3,X4) ) ).

cnf(i_0_1443,axiom,
    ( ~ esk7182_4(X1,X2,X3,X4)
    | esk7440_4(X1,X2,X3,X4) ) ).

cnf(i_0_1444,axiom,
    ( esk7337_4(X1,X2,X3,X4)
    | ~ esk7344_4(X1,X2,X3,X4)
    | ~ esk7438_4(X1,X2,X3,X4) ) ).

cnf(i_0_1445,axiom,
    ( esk4669_4(X1,X2,X3,X4)
    | ~ esk4670_4(X1,X2,X3,X4) ) ).

cnf(i_0_1446,axiom,
    ( esk13270_4(X1,X2,X3,X4)
    | esk13268_4(X1,X2,X3,X4) ) ).

cnf(i_0_1447,axiom,
    ( esk3637_4(X1,X2,X3,X4)
    | ~ esk3660_4(X1,X2,X3,X4)
    | esk3577_4(X1,X2,X3,X4) ) ).

cnf(i_0_1448,axiom,
    ( esk5305_4(X1,X2,X3,X4)
    | ~ esk5306_4(X1,X2,X3,X4) ) ).

cnf(i_0_1449,axiom,
    ( esk2594_4(X1,X2,X3,X4)
    | ~ esk2609_4(X1,X2,X3,X4)
    | ~ esk2549_4(X1,X2,X3,X4) ) ).

cnf(i_0_1450,axiom,
    ( ~ esk1565_4(X1,X2,X3,X4)
    | esk1585_4(X1,X2,X3,X4) ) ).

cnf(i_0_1451,axiom,
    ( ~ esk14745_4(X1,X2,X3,X4)
    | ~ esk14746_4(X1,X2,X3,X4)
    | ~ esk14748_4(X1,X2,X3,X4)
    | ~ esk14799_4(X1,X2,X3,X4)
    | ~ esk14798_4(X1,X2,X3,X4) ) ).

cnf(i_0_1452,axiom,
    ( ~ esk8899_4(X1,X2,X3,X4)
    | ~ esk8894_4(X1,X2,X3,X4) ) ).

cnf(i_0_1453,axiom,
    ( ~ esk16639_4(X1,X2,X3,X4)
    | esk16693_4(X1,X2,X3,X4) ) ).

cnf(i_0_1454,axiom,
    ( ~ esk13654_4(X1,X2,X3,X4)
    | ~ esk13610_4(X1,X2,X3,X4)
    | ~ esk13661_4(X1,X2,X3,X4) ) ).

cnf(i_0_1455,axiom,
    ( esk11720_4(X1,X2,X3,X4)
    | ~ esk11462_4(X1,X2,X3,X4) ) ).

cnf(i_0_1456,axiom,
    ( ~ esk3746_4(X1,X2,X3,X4)
    | ~ esk3850_4(X1,X2,X3,X4)
    | esk3729_4(X1,X2,X3,X4) ) ).

cnf(i_0_1457,axiom,
    ( esk5894_4(X1,X2,X3,X4)
    | ~ esk5794_4(X1,X2,X3,X4) ) ).

cnf(i_0_1458,axiom,
    ( ~ esk12629_4(X1,X2,X3,X4)
    | esk12658_4(X1,X2,X3,X4)
    | esk12578_4(X1,X2,X3,X4) ) ).

cnf(i_0_1459,axiom,
    ( ~ esk16292_4(X1,X2,X3,X4)
    | esk16327_4(X1,X2,X3,X4) ) ).

cnf(i_0_1460,axiom,
    ( ~ esk495_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X1)
    | ~ p(X4)
    | esk101_0
    | p(X2) ) ).

cnf(i_0_1461,axiom,
    ( ~ esk13656_4(X1,X2,X3,X4)
    | esk13688_4(X1,X2,X3,X4) ) ).

cnf(i_0_1462,axiom,
    ( ~ esk16340_4(X1,X2,X3,X4)
    | ~ esk16342_4(X1,X2,X3,X4) ) ).

cnf(i_0_1463,axiom,
    ( esk13610_4(X1,X2,X3,X4)
    | esk13654_4(X1,X2,X3,X4)
    | ~ esk13661_4(X1,X2,X3,X4) ) ).

cnf(i_0_1464,axiom,
    ( esk4557_4(X1,X2,X3,X4)
    | esk4589_4(X1,X2,X3,X4) ) ).

cnf(i_0_1465,axiom,
    ( esk7978_4(X1,X2,X3,X4)
    | ~ esk7977_4(X1,X2,X3,X4)
    | ~ esk7976_4(X1,X2,X3,X4) ) ).

cnf(i_0_1466,axiom,
    ( esk16129_4(X1,X2,X3,X4)
    | esk16139_4(X1,X2,X3,X4) ) ).

cnf(i_0_1467,axiom,
    ( p(X2)
    | p(X4)
    | p(X3)
    | p(X1)
    | ~ esk1_0
    | esk501_4(X1,X2,X3,X4) ) ).

cnf(i_0_1468,axiom,
    ( ~ esk10833_4(X1,X2,X3,X4)
    | ~ esk10832_4(X1,X2,X3,X4) ) ).

cnf(i_0_1469,axiom,
    ( ~ esk3517_4(X1,X2,X3,X4)
    | esk3259_4(X1,X2,X3,X4) ) ).

cnf(i_0_1470,axiom,
    ( esk7072_4(X1,X2,X3,X4)
    | ~ esk7043_4(X1,X2,X3,X4) ) ).

cnf(i_0_1471,axiom,
    ( ~ p(X4)
    | ~ esk433_4(X1,X2,X3,X4)
    | p(X2)
    | p(X1)
    | ~ p(X3)
    | esk50_0 ) ).

cnf(i_0_1472,axiom,
    ( esk9618_4(X1,X2,X3,X4)
    | ~ esk9637_4(X1,X2,X3,X4) ) ).

cnf(i_0_1473,axiom,
    ( esk2452_4(X1,X2,X3,X4)
    | ~ esk2551_4(X1,X2,X3,X4)
    | ~ esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_1474,axiom,
    ( ~ esk3746_4(X1,X2,X3,X4)
    | ~ esk3834_4(X1,X2,X3,X4)
    | esk3736_4(X1,X2,X3,X4) ) ).

cnf(i_0_1475,axiom,
    ( esk1900_4(X1,X2,X3,X4)
    | ~ esk1935_4(X1,X2,X3,X4) ) ).

cnf(i_0_1476,axiom,
    ( ~ esk3368_4(X1,X2,X3,X4)
    | ~ esk3366_4(X1,X2,X3,X4) ) ).

cnf(i_0_1477,axiom,
    ( esk16683_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X2)
    | ~ p(X4)
    | ~ p(X3)
    | ~ esk89_0 ) ).

cnf(i_0_1478,axiom,
    ( esk5606_4(X1,X2,X3,X4)
    | esk5590_4(X1,X2,X3,X4) ) ).

cnf(i_0_1479,axiom,
    ( ~ esk3817_4(X1,X2,X3,X4)
    | ~ esk3850_4(X1,X2,X3,X4)
    | ~ esk3796_4(X1,X2,X3,X4) ) ).

cnf(i_0_1480,axiom,
    ( ~ esk4658_4(X1,X2,X3,X4)
    | ~ esk4659_4(X1,X2,X3,X4) ) ).

cnf(i_0_1481,axiom,
    ( ~ esk13804_4(X1,X2,X3,X4)
    | esk13882_4(X1,X2,X3,X4) ) ).

cnf(i_0_1482,axiom,
    ( ~ esk12131_4(X1,X2,X3,X4)
    | ~ esk12022_4(X1,X2,X3,X4)
    | ~ esk12048_4(X1,X2,X3,X4) ) ).

cnf(i_0_1483,axiom,
    ( ~ esk7439_4(X1,X2,X3,X4)
    | esk7388_4(X1,X2,X3,X4) ) ).

cnf(i_0_1484,axiom,
    ( esk3618_4(X1,X2,X3,X4)
    | ~ esk3360_4(X1,X2,X3,X4) ) ).

cnf(i_0_1485,axiom,
    ( esk6276_4(X1,X2,X3,X4)
    | ~ esk6297_4(X1,X2,X3,X4) ) ).

cnf(i_0_1486,axiom,
    ( ~ esk15407_4(X1,X2,X3,X4)
    | ~ esk15311_4(X1,X2,X3,X4)
    | esk15305_4(X1,X2,X3,X4) ) ).

cnf(i_0_1487,axiom,
    ( esk4530_4(X1,X2,X3,X4)
    | ~ esk4534_4(X1,X2,X3,X4)
    | esk4528_4(X1,X2,X3,X4) ) ).

cnf(i_0_1488,axiom,
    ( esk11039_4(X1,X2,X3,X4)
    | ~ esk10985_4(X1,X2,X3,X4) ) ).

cnf(i_0_1489,axiom,
    ( ~ esk5597_4(X1,X2,X3,X4)
    | ~ esk5698_4(X1,X2,X3,X4)
    | ~ esk5613_4(X1,X2,X3,X4) ) ).

cnf(i_0_1490,axiom,
    ( ~ esk15857_4(X1,X2,X3,X4)
    | ~ esk15837_4(X1,X2,X3,X4)
    | esk15821_4(X1,X2,X3,X4) ) ).

cnf(i_0_1491,axiom,
    ( ~ esk12492_4(X1,X2,X3,X4)
    | esk12504_4(X1,X2,X3,X4) ) ).

cnf(i_0_1492,axiom,
    ( esk6107_4(X1,X2,X3,X4)
    | esk6115_4(X1,X2,X3,X4) ) ).

cnf(i_0_1493,axiom,
    ( esk7645_4(X1,X2,X3,X4)
    | ~ esk7696_4(X1,X2,X3,X4) ) ).

cnf(i_0_1494,axiom,
    ( esk8810_4(X1,X2,X3,X4)
    | ~ esk8781_4(X1,X2,X3,X4)
    | esk8761_4(X1,X2,X3,X4) ) ).

cnf(i_0_1495,axiom,
    ( esk9206_4(X1,X2,X3,X4)
    | esk9187_4(X1,X2,X3,X4) ) ).

cnf(i_0_1496,axiom,
    ( esk1160_4(X1,X2,X3,X4)
    | ~ esk1176_4(X1,X2,X3,X4)
    | ~ esk1282_4(X1,X2,X3,X4) ) ).

cnf(i_0_1497,axiom,
    ( ~ esk2185_4(X1,X2,X3,X4)
    | esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_1498,axiom,
    ( esk3814_4(X1,X2,X3,X4)
    | esk3788_4(X1,X2,X3,X4) ) ).

cnf(i_0_1499,axiom,
    ( esk561_4(X1,X2,X3,X4)
    | ~ esk507_4(X1,X2,X3,X4) ) ).

cnf(i_0_1500,axiom,
    ( ~ esk12324_4(X1,X2,X3,X4)
    | esk12582_4(X1,X2,X3,X4) ) ).

cnf(i_0_1501,axiom,
    ( ~ esk1433_4(X1,X2,X3,X4)
    | esk1436_4(X1,X2,X3,X4) ) ).

cnf(i_0_1502,axiom,
    ( ~ esk712_4(X1,X2,X3,X4)
    | ~ esk727_4(X1,X2,X3,X4)
    | ~ esk760_4(X1,X2,X3,X4) ) ).

cnf(i_0_1503,axiom,
    ( esk6949_4(X1,X2,X3,X4)
    | ~ esk6829_4(X1,X2,X3,X4) ) ).

cnf(i_0_1504,axiom,
    ( esk2489_4(X1,X2,X3,X4)
    | ~ esk2485_4(X1,X2,X3,X4)
    | esk2484_4(X1,X2,X3,X4) ) ).

cnf(i_0_1505,axiom,
    ( esk13000_4(X1,X2,X3,X4)
    | esk12972_4(X1,X2,X3,X4)
    | esk12973_4(X1,X2,X3,X4)
    | esk12948_4(X1,X2,X3,X4)
    | esk12970_4(X1,X2,X3,X4) ) ).

cnf(i_0_1506,axiom,
    ( esk12028_4(X1,X2,X3,X4)
    | esk12142_4(X1,X2,X3,X4) ) ).

cnf(i_0_1507,axiom,
    ( esk14244_4(X1,X2,X3,X4)
    | ~ esk14263_4(X1,X2,X3,X4) ) ).

cnf(i_0_1508,axiom,
    ( esk8759_4(X1,X2,X3,X4)
    | esk8758_4(X1,X2,X3,X4) ) ).

cnf(i_0_1509,axiom,
    ( esk14683_4(X1,X2,X3,X4)
    | esk14715_4(X1,X2,X3,X4) ) ).

cnf(i_0_1510,axiom,
    ( p(X3)
    | ~ p(X1)
    | ~ esk132_0
    | ~ p(X4)
    | p(X2)
    | esk16689_4(X1,X2,X3,X4) ) ).

cnf(i_0_1511,axiom,
    ( ~ esk14941_4(X1,X2,X3,X4)
    | esk14973_4(X1,X2,X3,X4) ) ).

cnf(i_0_1512,axiom,
    ( ~ esk4942_4(X1,X2,X3,X4)
    | ~ esk4941_4(X1,X2,X3,X4)
    | esk4943_4(X1,X2,X3,X4) ) ).

cnf(i_0_1513,axiom,
    ( esk13650_4(X1,X2,X3,X4)
    | esk13648_4(X1,X2,X3,X4) ) ).

cnf(i_0_1514,axiom,
    ( esk5609_4(X1,X2,X3,X4)
    | esk5723_4(X1,X2,X3,X4) ) ).

cnf(i_0_1515,axiom,
    ( ~ esk15158_4(X1,X2,X3,X4)
    | esk14900_4(X1,X2,X3,X4) ) ).

cnf(i_0_1516,axiom,
    ( esk2380_4(X1,X2,X3,X4)
    | ~ esk2379_4(X1,X2,X3,X4) ) ).

cnf(i_0_1517,axiom,
    ( ~ esk3618_4(X1,X2,X3,X4)
    | esk3360_4(X1,X2,X3,X4) ) ).

cnf(i_0_1518,axiom,
    ( esk769_4(X1,X2,X3,X4)
    | ~ esk700_4(X1,X2,X3,X4) ) ).

cnf(i_0_1519,axiom,
    ( esk9924_4(X1,X2,X3,X4)
    | esk9925_4(X1,X2,X3,X4) ) ).

cnf(i_0_1520,axiom,
    ( esk11308_4(X1,X2,X3,X4)
    | ~ esk11236_4(X1,X2,X3,X4) ) ).

cnf(i_0_1521,axiom,
    ( esk9498_4(X1,X2,X3,X4)
    | esk9543_4(X1,X2,X3,X4) ) ).

cnf(i_0_1522,axiom,
    ( esk5279_4(X1,X2,X3,X4)
    | ~ esk5253_4(X1,X2,X3,X4) ) ).

cnf(i_0_1523,axiom,
    ( ~ esk6269_4(X1,X2,X3,X4)
    | esk6304_4(X1,X2,X3,X4) ) ).

cnf(i_0_1524,axiom,
    ( esk10844_4(X1,X2,X3,X4)
    | ~ esk10823_4(X1,X2,X3,X4)
    | esk10822_4(X1,X2,X3,X4) ) ).

cnf(i_0_1525,axiom,
    ( ~ esk2204_4(X1,X2,X3,X4)
    | esk2191_4(X1,X2,X3,X4)
    | ~ esk2316_4(X1,X2,X3,X4) ) ).

cnf(i_0_1526,axiom,
    ( esk12355_4(X1,X2,X3,X4)
    | ~ esk12613_4(X1,X2,X3,X4) ) ).

cnf(i_0_1527,axiom,
    ( esk9433_4(X1,X2,X3,X4)
    | esk9522_4(X1,X2,X3,X4) ) ).

cnf(i_0_1528,axiom,
    ( esk4511_4(X1,X2,X3,X4)
    | ~ esk4613_4(X1,X2,X3,X4)
    | ~ esk4517_4(X1,X2,X3,X4) ) ).

cnf(i_0_1529,axiom,
    ( ~ esk9766_4(X1,X2,X3,X4)
    | esk9694_4(X1,X2,X3,X4) ) ).

cnf(i_0_1530,axiom,
    ( ~ esk14506_4(X1,X2,X3,X4)
    | esk14530_4(X1,X2,X3,X4) ) ).

cnf(i_0_1531,axiom,
    ( esk16716_4(X1,X2,X3,X4)
    | ~ esk16717_4(X1,X2,X3,X4) ) ).

cnf(i_0_1532,axiom,
    ( ~ esk7498_4(X1,X2,X3,X4)
    | esk7499_4(X1,X2,X3,X4) ) ).

cnf(i_0_1533,axiom,
    ( ~ esk7079_4(X1,X2,X3,X4)
    | esk7051_4(X1,X2,X3,X4) ) ).

cnf(i_0_1534,axiom,
    ( ~ esk12520_4(X1,X2,X3,X4)
    | esk12595_4(X1,X2,X3,X4) ) ).

cnf(i_0_1535,axiom,
    ( esk10048_4(X1,X2,X3,X4)
    | esk10028_4(X1,X2,X3,X4) ) ).

cnf(i_0_1536,axiom,
    ( esk4797_4(X1,X2,X3,X4)
    | esk4779_4(X1,X2,X3,X4) ) ).

cnf(i_0_1537,axiom,
    ( esk10692_4(X1,X2,X3,X4)
    | ~ esk10434_4(X1,X2,X3,X4) ) ).

cnf(i_0_1538,axiom,
    ( ~ esk15822_4(X1,X2,X3,X4)
    | ~ esk15828_4(X1,X2,X3,X4)
    | esk15823_4(X1,X2,X3,X4) ) ).

cnf(i_0_1539,axiom,
    ( ~ esk14017_4(X1,X2,X3,X4)
    | esk13991_4(X1,X2,X3,X4) ) ).

cnf(i_0_1540,axiom,
    ( ~ esk15828_4(X1,X2,X3,X4)
    | ~ esk15826_4(X1,X2,X3,X4) ) ).

cnf(i_0_1541,axiom,
    ( ~ esk2988_4(X1,X2,X3,X4)
    | ~ esk2989_4(X1,X2,X3,X4) ) ).

cnf(i_0_1542,axiom,
    ( ~ esk7737_4(X1,X2,X3,X4)
    | ~ esk7736_4(X1,X2,X3,X4) ) ).

cnf(i_0_1543,axiom,
    ( ~ esk16187_4(X1,X2,X3,X4)
    | esk16445_4(X1,X2,X3,X4) ) ).

cnf(i_0_1544,axiom,
    ( esk3086_4(X1,X2,X3,X4)
    | ~ esk3344_4(X1,X2,X3,X4) ) ).

cnf(i_0_1545,axiom,
    ( esk7435_4(X1,X2,X3,X4)
    | ~ esk7390_4(X1,X2,X3,X4) ) ).

cnf(i_0_1546,axiom,
    ( esk7174_4(X1,X2,X3,X4)
    | ~ esk7135_4(X1,X2,X3,X4) ) ).

cnf(i_0_1547,axiom,
    ( esk9277_4(X1,X2,X3,X4)
    | esk9257_4(X1,X2,X3,X4) ) ).

cnf(i_0_1548,axiom,
    ( ~ esk13784_4(X1,X2,X3,X4)
    | ~ esk13782_4(X1,X2,X3,X4) ) ).

cnf(i_0_1549,axiom,
    ( esk6205_4(X1,X2,X3,X4)
    | esk6207_4(X1,X2,X3,X4)
    | esk6206_4(X1,X2,X3,X4) ) ).

cnf(i_0_1550,axiom,
    ( ~ esk10964_4(X1,X2,X3,X4)
    | esk10948_4(X1,X2,X3,X4) ) ).

cnf(i_0_1551,axiom,
    ( esk10280_4(X1,X2,X3,X4)
    | ~ esk10208_4(X1,X2,X3,X4) ) ).

cnf(i_0_1552,axiom,
    ( esk5600_4(X1,X2,X3,X4)
    | esk5633_4(X1,X2,X3,X4) ) ).

cnf(i_0_1553,axiom,
    ( ~ esk6623_4(X1,X2,X3,X4)
    | ~ esk6683_4(X1,X2,X3,X4)
    | ~ esk6650_4(X1,X2,X3,X4) ) ).

cnf(i_0_1554,axiom,
    ( esk12399_4(X1,X2,X3,X4)
    | esk12285_4(X1,X2,X3,X4) ) ).

cnf(i_0_1555,axiom,
    ( ~ esk2520_4(X1,X2,X3,X4)
    | ~ esk2511_4(X1,X2,X3,X4)
    | ~ esk2553_4(X1,X2,X3,X4) ) ).

cnf(i_0_1556,axiom,
    ( ~ esk12659_4(X1,X2,X3,X4)
    | ~ esk12627_4(X1,X2,X3,X4) ) ).

cnf(i_0_1557,axiom,
    ( esk7246_4(X1,X2,X3,X4)
    | esk7161_4(X1,X2,X3,X4) ) ).

cnf(i_0_1558,axiom,
    ( ~ esk3157_4(X1,X2,X3,X4)
    | ~ esk3135_4(X1,X2,X3,X4) ) ).

cnf(i_0_1559,axiom,
    ( ~ esk8873_4(X1,X2,X3,X4)
    | esk8840_4(X1,X2,X3,X4) ) ).

cnf(i_0_1560,axiom,
    ( ~ esk412_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ p(X4)
    | esk28_0
    | p(X2)
    | ~ p(X3) ) ).

cnf(i_0_1561,axiom,
    ( ~ esk5801_4(X1,X2,X3,X4)
    | esk5921_4(X1,X2,X3,X4) ) ).

cnf(i_0_1562,axiom,
    ( esk13819_4(X1,X2,X3,X4)
    | esk13844_4(X1,X2,X3,X4) ) ).

cnf(i_0_1563,axiom,
    ( ~ esk15723_4(X1,X2,X3,X4)
    | esk15725_4(X1,X2,X3,X4)
    | ~ esk15724_4(X1,X2,X3,X4) ) ).

cnf(i_0_1564,axiom,
    ( ~ esk7586_4(X1,X2,X3,X4)
    | esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_1565,axiom,
    ( esk5724_4(X1,X2,X3,X4)
    | ~ esk5705_4(X1,X2,X3,X4)
    | esk5653_4(X1,X2,X3,X4) ) ).

cnf(i_0_1566,axiom,
    ( ~ esk11829_4(X1,X2,X3,X4)
    | ~ esk11844_4(X1,X2,X3,X4) ) ).

cnf(i_0_1567,axiom,
    ( ~ esk587_4(X1,X2,X3,X4)
    | ~ esk565_4(X1,X2,X3,X4) ) ).

cnf(i_0_1568,axiom,
    ( esk2126_4(X1,X2,X3,X4)
    | esk2107_4(X1,X2,X3,X4)
    | ~ esk2055_4(X1,X2,X3,X4) ) ).

cnf(i_0_1569,axiom,
    ( esk491_4(X1,X2,X3,X4)
    | p(X1)
    | p(X2)
    | p(X4)
    | p(X3)
    | ~ esk1_0 ) ).

cnf(i_0_1570,axiom,
    ( esk5432_4(X1,X2,X3,X4)
    | esk5384_4(X1,X2,X3,X4) ) ).

cnf(i_0_1571,axiom,
    ( ~ esk8488_4(X1,X2,X3,X4)
    | esk8367_4(X1,X2,X3,X4)
    | ~ esk8372_4(X1,X2,X3,X4) ) ).

cnf(i_0_1572,axiom,
    ( ~ esk4429_4(X1,X2,X3,X4)
    | esk4427_4(X1,X2,X3,X4) ) ).

cnf(i_0_1573,axiom,
    ( esk6551_4(X1,X2,X3,X4)
    | ~ esk6571_4(X1,X2,X3,X4) ) ).

cnf(i_0_1574,axiom,
    ( esk11186_4(X1,X2,X3,X4)
    | ~ esk11311_4(X1,X2,X3,X4)
    | ~ esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_1575,axiom,
    ( ~ esk3284_4(X1,X2,X3,X4)
    | ~ esk3286_4(X1,X2,X3,X4)
    | ~ esk3402_4(X1,X2,X3,X4) ) ).

cnf(i_0_1576,axiom,
    ( ~ esk5778_4(X1,X2,X3,X4)
    | ~ esk5801_4(X1,X2,X3,X4) ) ).

cnf(i_0_1577,axiom,
    ( esk9064_4(X1,X2,X3,X4)
    | esk8950_4(X1,X2,X3,X4) ) ).

cnf(i_0_1578,axiom,
    ( esk984_4(X1,X2,X3,X4)
    | esk969_4(X1,X2,X3,X4) ) ).

cnf(i_0_1579,axiom,
    ( ~ esk15669_4(X1,X2,X3,X4)
    | esk15927_4(X1,X2,X3,X4) ) ).

cnf(i_0_1580,axiom,
    ( ~ esk11858_4(X1,X2,X3,X4)
    | ~ esk11807_4(X1,X2,X3,X4)
    | ~ esk11887_4(X1,X2,X3,X4) ) ).

cnf(i_0_1581,axiom,
    ( ~ esk1952_4(X1,X2,X3,X4)
    | esk1694_4(X1,X2,X3,X4) ) ).

cnf(i_0_1582,axiom,
    ( esk14284_4(X1,X2,X3,X4)
    | esk14285_4(X1,X2,X3,X4) ) ).

cnf(i_0_1583,axiom,
    ( ~ esk7966_4(X1,X2,X3,X4)
    | esk7708_4(X1,X2,X3,X4) ) ).

cnf(i_0_1584,axiom,
    ( esk15958_4(X1,X2,X3,X4)
    | ~ esk15973_4(X1,X2,X3,X4)
    | ~ esk15913_4(X1,X2,X3,X4) ) ).

cnf(i_0_1585,axiom,
    ( ~ esk11970_4(X1,X2,X3,X4)
    | ~ esk12080_4(X1,X2,X3,X4)
    | esk11956_4(X1,X2,X3,X4) ) ).

cnf(i_0_1586,axiom,
    ( ~ esk11164_4(X1,X2,X3,X4)
    | esk11190_4(X1,X2,X3,X4) ) ).

cnf(i_0_1587,axiom,
    ( ~ esk5139_4(X1,X2,X3,X4)
    | ~ esk5081_4(X1,X2,X3,X4)
    | ~ esk5106_4(X1,X2,X3,X4) ) ).

cnf(i_0_1588,axiom,
    ( esk11836_4(X1,X2,X3,X4)
    | esk11837_4(X1,X2,X3,X4)
    | ~ esk11838_4(X1,X2,X3,X4) ) ).

cnf(i_0_1589,axiom,
    ( ~ esk16475_4(X1,X2,X3,X4)
    | ~ esk16518_4(X1,X2,X3,X4)
    | ~ esk16449_4(X1,X2,X3,X4) ) ).

cnf(i_0_1590,axiom,
    ( ~ esk10152_4(X1,X2,X3,X4)
    | esk10171_4(X1,X2,X3,X4) ) ).

cnf(i_0_1591,axiom,
    ( esk2205_4(X1,X2,X3,X4)
    | esk2206_4(X1,X2,X3,X4) ) ).

cnf(i_0_1592,axiom,
    ( esk4865_4(X1,X2,X3,X4)
    | ~ esk4820_4(X1,X2,X3,X4) ) ).

cnf(i_0_1593,axiom,
    ( ~ esk8951_4(X1,X2,X3,X4)
    | ~ esk8952_4(X1,X2,X3,X4)
    | ~ esk8929_4(X1,X2,X3,X4) ) ).

cnf(i_0_1594,axiom,
    ( ~ esk1485_4(X1,X2,X3,X4)
    | ~ esk1594_4(X1,X2,X3,X4)
    | ~ esk1511_4(X1,X2,X3,X4) ) ).

cnf(i_0_1595,axiom,
    ( esk8434_4(X1,X2,X3,X4)
    | esk8417_4(X1,X2,X3,X4) ) ).

cnf(i_0_1596,axiom,
    ( esk12879_4(X1,X2,X3,X4)
    | esk12877_4(X1,X2,X3,X4) ) ).

cnf(i_0_1597,axiom,
    esk6313_4(X1,X2,X3,X4) ).

cnf(i_0_1598,axiom,
    ( ~ esk10728_4(X1,X2,X3,X4)
    | ~ esk10751_4(X1,X2,X3,X4)
    | ~ esk10750_4(X1,X2,X3,X4) ) ).

cnf(i_0_1599,axiom,
    ( ~ esk2963_4(X1,X2,X3,X4)
    | esk2928_4(X1,X2,X3,X4) ) ).

cnf(i_0_1600,axiom,
    ( esk4123_4(X1,X2,X3,X4)
    | ~ esk4124_4(X1,X2,X3,X4) ) ).

cnf(i_0_1601,axiom,
    ( esk8669_4(X1,X2,X3,X4)
    | esk8700_4(X1,X2,X3,X4) ) ).

cnf(i_0_1602,axiom,
    ( ~ esk16481_4(X1,X2,X3,X4)
    | ~ esk16479_4(X1,X2,X3,X4) ) ).

cnf(i_0_1603,axiom,
    ( ~ esk2726_4(X1,X2,X3,X4)
    | ~ esk2731_4(X1,X2,X3,X4) ) ).

cnf(i_0_1604,axiom,
    ( esk3746_4(X1,X2,X3,X4)
    | ~ esk3729_4(X1,X2,X3,X4) ) ).

cnf(i_0_1605,axiom,
    ( ~ esk5191_4(X1,X2,X3,X4)
    | ~ esk5210_4(X1,X2,X3,X4)
    | ~ esk5139_4(X1,X2,X3,X4) ) ).

cnf(i_0_1606,axiom,
    ( esk10133_4(X1,X2,X3,X4)
    | ~ esk10165_4(X1,X2,X3,X4) ) ).

cnf(i_0_1607,axiom,
    ( ~ esk11562_4(X1,X2,X3,X4)
    | esk11304_4(X1,X2,X3,X4) ) ).

cnf(i_0_1608,axiom,
    ( ~ esk11506_4(X1,X2,X3,X4)
    | ~ esk11529_4(X1,X2,X3,X4)
    | ~ esk11562_4(X1,X2,X3,X4) ) ).

cnf(i_0_1609,axiom,
    ( ~ esk13495_4(X1,X2,X3,X4)
    | esk13512_4(X1,X2,X3,X4) ) ).

cnf(i_0_1610,axiom,
    ( ~ esk166_0
    | ~ p(X1)
    | p(X3)
    | ~ p(X4)
    | esk16693_4(X1,X2,X3,X4)
    | ~ p(X2) ) ).

cnf(i_0_1611,axiom,
    ( esk7962_4(X1,X2,X3,X4)
    | esk7929_4(X1,X2,X3,X4) ) ).

cnf(i_0_1612,axiom,
    ( esk12523_4(X1,X2,X3,X4)
    | ~ esk12589_4(X1,X2,X3,X4) ) ).

cnf(i_0_1613,axiom,
    ( esk14275_4(X1,X2,X3,X4)
    | ~ esk14247_4(X1,X2,X3,X4) ) ).

cnf(i_0_1614,axiom,
    ( ~ esk14553_4(X1,X2,X3,X4)
    | ~ esk14554_4(X1,X2,X3,X4) ) ).

cnf(i_0_1615,axiom,
    ( ~ esk5636_4(X1,X2,X3,X4)
    | esk5894_4(X1,X2,X3,X4) ) ).

cnf(i_0_1616,axiom,
    ( esk1833_4(X1,X2,X3,X4)
    | esk1788_4(X1,X2,X3,X4) ) ).

cnf(i_0_1617,axiom,
    ( esk16204_4(X1,X2,X3,X4)
    | ~ esk16200_4(X1,X2,X3,X4)
    | esk16199_4(X1,X2,X3,X4) ) ).

cnf(i_0_1618,axiom,
    ( ~ esk4518_4(X1,X2,X3,X4)
    | ~ esk4468_4(X1,X2,X3,X4)
    | ~ esk4519_4(X1,X2,X3,X4)
    | ~ esk4465_4(X1,X2,X3,X4)
    | ~ esk4466_4(X1,X2,X3,X4) ) ).

cnf(i_0_1619,axiom,
    ( ~ esk9644_4(X1,X2,X3,X4)
    | esk9769_4(X1,X2,X3,X4) ) ).

cnf(i_0_1620,axiom,
    ( esk12386_4(X1,X2,X3,X4)
    | esk12365_4(X1,X2,X3,X4)
    | ~ esk12364_4(X1,X2,X3,X4) ) ).

cnf(i_0_1621,axiom,
    ( esk1062_4(X1,X2,X3,X4)
    | esk1064_4(X1,X2,X3,X4)
    | esk1063_4(X1,X2,X3,X4) ) ).

cnf(i_0_1622,axiom,
    ( esk8980_4(X1,X2,X3,X4)
    | ~ esk8879_4(X1,X2,X3,X4) ) ).

cnf(i_0_1623,axiom,
    ( ~ esk14570_4(X1,X2,X3,X4)
    | ~ esk14662_4(X1,X2,X3,X4) ) ).

cnf(i_0_1624,axiom,
    ( ~ esk14115_4(X1,X2,X3,X4)
    | esk14373_4(X1,X2,X3,X4) ) ).

cnf(i_0_1625,axiom,
    ( ~ esk13739_4(X1,X2,X3,X4)
    | esk13801_4(X1,X2,X3,X4) ) ).

cnf(i_0_1626,axiom,
    ( esk15195_4(X1,X2,X3,X4)
    | esk15156_4(X1,X2,X3,X4) ) ).

cnf(i_0_1627,axiom,
    ( ~ esk11852_4(X1,X2,X3,X4)
    | esk11817_4(X1,X2,X3,X4)
    | esk11871_4(X1,X2,X3,X4) ) ).

cnf(i_0_1628,axiom,
    ( esk4085_4(X1,X2,X3,X4)
    | esk4038_4(X1,X2,X3,X4) ) ).

cnf(i_0_1629,axiom,
    ( esk9254_4(X1,X2,X3,X4)
    | ~ esk9512_4(X1,X2,X3,X4) ) ).

cnf(i_0_1630,axiom,
    ( esk10540_4(X1,X2,X3,X4)
    | ~ esk10282_4(X1,X2,X3,X4) ) ).

cnf(i_0_1631,axiom,
    ( ~ esk1612_4(X1,X2,X3,X4)
    | ~ esk1569_4(X1,X2,X3,X4)
    | ~ esk1543_4(X1,X2,X3,X4) ) ).

cnf(i_0_1632,axiom,
    ( esk6595_4(X1,X2,X3,X4)
    | ~ esk6579_4(X1,X2,X3,X4) ) ).

cnf(i_0_1633,axiom,
    ( ~ esk5557_4(X1,X2,X3,X4)
    | ~ esk5553_4(X1,X2,X3,X4) ) ).

cnf(i_0_1634,axiom,
    ( ~ esk13827_4(X1,X2,X3,X4)
    | ~ esk13816_4(X1,X2,X3,X4)
    | ~ esk13826_4(X1,X2,X3,X4) ) ).

cnf(i_0_1635,axiom,
    ( esk3550_4(X1,X2,X3,X4)
    | esk3539_4(X1,X2,X3,X4) ) ).

cnf(i_0_1636,axiom,
    ( ~ esk6980_4(X1,X2,X3,X4)
    | ~ esk6962_4(X1,X2,X3,X4) ) ).

cnf(i_0_1637,axiom,
    ( ~ esk12748_4(X1,X2,X3,X4)
    | esk12490_4(X1,X2,X3,X4) ) ).

cnf(i_0_1638,axiom,
    ( ~ esk7351_4(X1,X2,X3,X4)
    | esk7093_4(X1,X2,X3,X4) ) ).

cnf(i_0_1639,axiom,
    ( ~ esk40_0
    | ~ p(X3)
    | esk16605_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X4)
    | ~ p(X2) ) ).

cnf(i_0_1640,axiom,
    ( ~ esk5550_4(X1,X2,X3,X4)
    | esk5292_4(X1,X2,X3,X4) ) ).

cnf(i_0_1641,axiom,
    ( esk6223_4(X1,X2,X3,X4)
    | ~ esk6193_4(X1,X2,X3,X4) ) ).

cnf(i_0_1642,axiom,
    ( ~ esk14132_4(X1,X2,X3,X4)
    | esk13874_4(X1,X2,X3,X4) ) ).

cnf(i_0_1643,axiom,
    ( esk1247_4(X1,X2,X3,X4)
    | esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_1644,axiom,
    ( esk2569_4(X1,X2,X3,X4)
    | esk2536_4(X1,X2,X3,X4) ) ).

cnf(i_0_1645,axiom,
    esk14280_4(X1,X2,X3,X4) ).

cnf(i_0_1646,axiom,
    ( ~ esk1969_4(X1,X2,X3,X4)
    | esk1953_4(X1,X2,X3,X4) ) ).

cnf(i_0_1647,axiom,
    ( ~ esk16691_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4)
    | ~ p(X1)
    | esk146_0
    | p(X3) ) ).

cnf(i_0_1648,axiom,
    ( esk6573_4(X1,X2,X3,X4)
    | ~ esk6555_4(X1,X2,X3,X4) ) ).

cnf(i_0_1649,axiom,
    ( esk13347_4(X1,X2,X3,X4)
    | esk13435_4(X1,X2,X3,X4)
    | ~ esk13428_4(X1,X2,X3,X4) ) ).

cnf(i_0_1650,axiom,
    ( esk15215_4(X1,X2,X3,X4)
    | esk15132_4(X1,X2,X3,X4) ) ).

cnf(i_0_1651,axiom,
    ( ~ esk9153_4(X1,X2,X3,X4)
    | esk9159_4(X1,X2,X3,X4) ) ).

cnf(i_0_1652,axiom,
    ( esk2220_4(X1,X2,X3,X4)
    | ~ esk2219_4(X1,X2,X3,X4) ) ).

cnf(i_0_1653,axiom,
    ( ~ esk7925_4(X1,X2,X3,X4)
    | ~ esk7958_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_1654,axiom,
    ( ~ esk10949_4(X1,X2,X3,X4)
    | esk10963_4(X1,X2,X3,X4) ) ).

cnf(i_0_1655,axiom,
    ( esk933_4(X1,X2,X3,X4)
    | esk947_4(X1,X2,X3,X4) ) ).

cnf(i_0_1656,axiom,
    ( ~ esk5829_4(X1,X2,X3,X4)
    | esk5831_4(X1,X2,X3,X4) ) ).

cnf(i_0_1657,axiom,
    ( ~ esk11266_4(X1,X2,X3,X4)
    | ~ esk11241_4(X1,X2,X3,X4)
    | ~ esk11267_4(X1,X2,X3,X4) ) ).

cnf(i_0_1658,axiom,
    ( ~ p(X1)
    | p(X4)
    | esk221_0
    | p(X3)
    | p(X2)
    | ~ esk16701_4(X1,X2,X3,X4) ) ).

cnf(i_0_1659,axiom,
    ( ~ esk11997_4(X1,X2,X3,X4)
    | esk11999_4(X1,X2,X3,X4) ) ).

cnf(i_0_1660,axiom,
    ( ~ esk6180_4(X1,X2,X3,X4)
    | esk6179_4(X1,X2,X3,X4) ) ).

cnf(i_0_1661,axiom,
    ( esk4140_4(X1,X2,X3,X4)
    | esk4162_4(X1,X2,X3,X4)
    | ~ esk4141_4(X1,X2,X3,X4) ) ).

cnf(i_0_1662,axiom,
    ( ~ esk8211_4(X1,X2,X3,X4)
    | esk7953_4(X1,X2,X3,X4) ) ).

cnf(i_0_1663,axiom,
    ( ~ esk14169_4(X1,X2,X3,X4)
    | ~ esk14171_4(X1,X2,X3,X4) ) ).

cnf(i_0_1664,axiom,
    ( ~ esk8768_4(X1,X2,X3,X4)
    | esk8733_4(X1,X2,X3,X4)
    | esk8787_4(X1,X2,X3,X4) ) ).

cnf(i_0_1665,axiom,
    ( esk6422_4(X1,X2,X3,X4)
    | esk6453_4(X1,X2,X3,X4) ) ).

cnf(i_0_1666,axiom,
    ( esk14592_4(X1,X2,X3,X4)
    | esk14598_4(X1,X2,X3,X4) ) ).

cnf(i_0_1667,axiom,
    ( ~ esk404_4(X1,X2,X3,X4)
    | ~ esk522_4(X1,X2,X3,X4) ) ).

cnf(i_0_1668,axiom,
    ( ~ esk3586_4(X1,X2,X3,X4)
    | esk3844_4(X1,X2,X3,X4) ) ).

cnf(i_0_1669,axiom,
    ( esk5100_4(X1,X2,X3,X4)
    | esk5133_4(X1,X2,X3,X4) ) ).

cnf(i_0_1670,axiom,
    ( esk6896_4(X1,X2,X3,X4)
    | esk6882_4(X1,X2,X3,X4) ) ).

cnf(i_0_1671,axiom,
    ( ~ esk13692_4(X1,X2,X3,X4)
    | ~ esk13657_4(X1,X2,X3,X4)
    | ~ esk13606_4(X1,X2,X3,X4) ) ).

cnf(i_0_1672,axiom,
    ( ~ esk13771_4(X1,X2,X3,X4)
    | ~ esk13719_4(X1,X2,X3,X4) ) ).

cnf(i_0_1673,axiom,
    ( esk4049_4(X1,X2,X3,X4)
    | ~ esk4094_4(X1,X2,X3,X4) ) ).

cnf(i_0_1674,axiom,
    ( esk16596_4(X1,X2,X3,X4)
    | ~ esk16587_4(X1,X2,X3,X4) ) ).

cnf(i_0_1675,axiom,
    ( ~ esk6134_4(X1,X2,X3,X4)
    | ~ esk6097_4(X1,X2,X3,X4)
    | ~ esk6135_4(X1,X2,X3,X4) ) ).

cnf(i_0_1676,axiom,
    ( esk13174_4(X1,X2,X3,X4)
    | ~ esk13173_4(X1,X2,X3,X4) ) ).

cnf(i_0_1677,axiom,
    ( esk11497_4(X1,X2,X3,X4)
    | esk11526_4(X1,X2,X3,X4) ) ).

cnf(i_0_1678,axiom,
    ( esk12610_4(X1,X2,X3,X4)
    | ~ esk12453_4(X1,X2,X3,X4) ) ).

cnf(i_0_1679,axiom,
    ( esk14314_4(X1,X2,X3,X4)
    | ~ esk14262_4(X1,X2,X3,X4) ) ).

cnf(i_0_1680,axiom,
    ( esk16231_4(X1,X2,X3,X4)
    | esk16180_4(X1,X2,X3,X4)
    | ~ esk16224_4(X1,X2,X3,X4) ) ).

cnf(i_0_1681,axiom,
    ( esk11251_4(X1,X2,X3,X4)
    | esk11253_4(X1,X2,X3,X4) ) ).

cnf(i_0_1682,axiom,
    ( esk1495_4(X1,X2,X3,X4)
    | esk1485_4(X1,X2,X3,X4) ) ).

cnf(i_0_1683,axiom,
    ( ~ esk16618_4(X1,X2,X3,X4)
    | esk16602_4(X1,X2,X3,X4) ) ).

cnf(i_0_1684,axiom,
    ( esk582_4(X1,X2,X3,X4)
    | ~ esk548_4(X1,X2,X3,X4) ) ).

cnf(i_0_1685,axiom,
    ( esk9839_4(X1,X2,X3,X4)
    | esk9733_4(X1,X2,X3,X4) ) ).

cnf(i_0_1686,axiom,
    ( esk2892_4(X1,X2,X3,X4)
    | esk2780_4(X1,X2,X3,X4) ) ).

cnf(i_0_1687,axiom,
    ( p(X2)
    | esk503_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk153_0
    | p(X3)
    | p(X1) ) ).

cnf(i_0_1688,axiom,
    ( esk7647_4(X1,X2,X3,X4)
    | esk7661_4(X1,X2,X3,X4) ) ).

cnf(i_0_1689,axiom,
    ( esk12820_4(X1,X2,X3,X4)
    | esk12853_4(X1,X2,X3,X4) ) ).

cnf(i_0_1690,axiom,
    ( esk8946_4(X1,X2,X3,X4)
    | esk9069_4(X1,X2,X3,X4) ) ).

cnf(i_0_1691,axiom,
    ( ~ esk4003_4(X1,X2,X3,X4)
    | ~ esk4101_4(X1,X2,X3,X4)
    | esk3983_4(X1,X2,X3,X4) ) ).

cnf(i_0_1692,axiom,
    ( esk8674_4(X1,X2,X3,X4)
    | ~ esk8722_4(X1,X2,X3,X4) ) ).

cnf(i_0_1693,axiom,
    ( ~ esk2086_4(X1,X2,X3,X4)
    | ~ esk2084_4(X1,X2,X3,X4) ) ).

cnf(i_0_1694,axiom,
    ( esk5077_4(X1,X2,X3,X4)
    | esk5090_4(X1,X2,X3,X4) ) ).

cnf(i_0_1695,axiom,
    ( esk16494_4(X1,X2,X3,X4)
    | ~ esk16480_4(X1,X2,X3,X4) ) ).

cnf(i_0_1696,axiom,
    ( esk5470_4(X1,X2,X3,X4)
    | esk5364_4(X1,X2,X3,X4) ) ).

cnf(i_0_1697,axiom,
    ( ~ esk3391_4(X1,X2,X3,X4)
    | ~ esk3284_4(X1,X2,X3,X4)
    | ~ esk3306_4(X1,X2,X3,X4) ) ).

cnf(i_0_1698,axiom,
    ( esk6524_4(X1,X2,X3,X4)
    | esk6574_4(X1,X2,X3,X4) ) ).

cnf(i_0_1699,axiom,
    ( esk4260_4(X1,X2,X3,X4)
    | ~ esk4236_4(X1,X2,X3,X4)
    | ~ esk4263_4(X1,X2,X3,X4) ) ).

cnf(i_0_1700,axiom,
    ( ~ esk8463_4(X1,X2,X3,X4)
    | esk8721_4(X1,X2,X3,X4) ) ).

cnf(i_0_1701,axiom,
    ( ~ esk2302_4(X1,X2,X3,X4)
    | esk2184_4(X1,X2,X3,X4)
    | ~ esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_1702,axiom,
    ( esk6959_4(X1,X2,X3,X4)
    | ~ esk6701_4(X1,X2,X3,X4) ) ).

cnf(i_0_1703,axiom,
    ( ~ esk16050_4(X1,X2,X3,X4)
    | esk16201_4(X1,X2,X3,X4) ) ).

cnf(i_0_1704,axiom,
    ( ~ esk12303_4(X1,X2,X3,X4)
    | ~ esk12302_4(X1,X2,X3,X4)
    | ~ esk12265_4(X1,X2,X3,X4) ) ).

cnf(i_0_1705,axiom,
    ( esk12815_4(X1,X2,X3,X4)
    | esk12780_4(X1,X2,X3,X4) ) ).

cnf(i_0_1706,axiom,
    ( esk16497_4(X1,X2,X3,X4)
    | esk16443_4(X1,X2,X3,X4)
    | ~ esk16478_4(X1,X2,X3,X4) ) ).

cnf(i_0_1707,axiom,
    ( ~ esk9214_4(X1,X2,X3,X4)
    | ~ esk9247_4(X1,X2,X3,X4)
    | ~ esk9193_4(X1,X2,X3,X4) ) ).

cnf(i_0_1708,axiom,
    ( esk3094_4(X1,X2,X3,X4)
    | ~ esk2943_4(X1,X2,X3,X4) ) ).

cnf(i_0_1709,axiom,
    ( esk12279_4(X1,X2,X3,X4)
    | esk12287_4(X1,X2,X3,X4) ) ).

cnf(i_0_1710,axiom,
    ( ~ esk4545_4(X1,X2,X3,X4)
    | esk4541_4(X1,X2,X3,X4) ) ).

cnf(i_0_1711,axiom,
    ( esk5647_4(X1,X2,X3,X4)
    | ~ esk5389_4(X1,X2,X3,X4) ) ).

cnf(i_0_1712,axiom,
    ( ~ esk8167_4(X1,X2,X3,X4)
    | ~ esk8298_4(X1,X2,X3,X4)
    | ~ esk8175_4(X1,X2,X3,X4) ) ).

cnf(i_0_1713,axiom,
    ( ~ esk10300_4(X1,X2,X3,X4)
    | ~ esk10301_4(X1,X2,X3,X4) ) ).

cnf(i_0_1714,axiom,
    ( esk6855_4(X1,X2,X3,X4)
    | ~ esk6859_4(X1,X2,X3,X4) ) ).

cnf(i_0_1715,axiom,
    ( ~ esk15288_4(X1,X2,X3,X4)
    | ~ esk15434_4(X1,X2,X3,X4)
    | ~ esk15441_4(X1,X2,X3,X4) ) ).

cnf(i_0_1716,axiom,
    ( esk4700_4(X1,X2,X3,X4)
    | esk4690_4(X1,X2,X3,X4) ) ).

cnf(i_0_1717,axiom,
    ( esk12920_4(X1,X2,X3,X4)
    | esk12877_4(X1,X2,X3,X4) ) ).

cnf(i_0_1718,axiom,
    ( ~ esk11359_4(X1,X2,X3,X4)
    | ~ esk11381_4(X1,X2,X3,X4) ) ).

cnf(i_0_1719,axiom,
    ( esk9806_4(X1,X2,X3,X4)
    | esk9723_4(X1,X2,X3,X4) ) ).

cnf(i_0_1720,axiom,
    ( esk7009_4(X1,X2,X3,X4)
    | esk6938_4(X1,X2,X3,X4)
    | ~ esk6990_4(X1,X2,X3,X4) ) ).

cnf(i_0_1721,axiom,
    ( esk16442_4(X1,X2,X3,X4)
    | ~ esk16700_4(X1,X2,X3,X4) ) ).

cnf(i_0_1722,axiom,
    ( esk14371_4(X1,X2,X3,X4)
    | esk14338_4(X1,X2,X3,X4) ) ).

cnf(i_0_1723,axiom,
    ( esk9739_4(X1,X2,X3,X4)
    | esk9826_4(X1,X2,X3,X4) ) ).

cnf(i_0_1724,axiom,
    ( ~ esk8400_4(X1,X2,X3,X4)
    | esk8142_4(X1,X2,X3,X4) ) ).

cnf(i_0_1725,axiom,
    ( esk3043_4(X1,X2,X3,X4)
    | esk3017_4(X1,X2,X3,X4) ) ).

cnf(i_0_1726,axiom,
    ( esk11456_4(X1,X2,X3,X4)
    | ~ esk11446_4(X1,X2,X3,X4) ) ).

cnf(i_0_1727,axiom,
    ( esk8885_4(X1,X2,X3,X4)
    | esk9010_4(X1,X2,X3,X4) ) ).

cnf(i_0_1728,axiom,
    ( ~ esk15672_4(X1,X2,X3,X4)
    | esk15414_4(X1,X2,X3,X4) ) ).

cnf(i_0_1729,axiom,
    ( ~ esk2043_4(X1,X2,X3,X4)
    | esk2124_4(X1,X2,X3,X4) ) ).

cnf(i_0_1730,axiom,
    ( esk3061_4(X1,X2,X3,X4)
    | esk3028_4(X1,X2,X3,X4) ) ).

cnf(i_0_1731,axiom,
    ( ~ esk14157_4(X1,X2,X3,X4)
    | esk14194_4(X1,X2,X3,X4) ) ).

cnf(i_0_1732,axiom,
    ( ~ esk1177_4(X1,X2,X3,X4)
    | ~ esk1175_4(X1,X2,X3,X4) ) ).

cnf(i_0_1733,axiom,
    ( esk12893_4(X1,X2,X3,X4)
    | ~ esk12873_4(X1,X2,X3,X4) ) ).

cnf(i_0_1734,axiom,
    ( esk2832_4(X1,X2,X3,X4)
    | ~ esk2706_4(X1,X2,X3,X4) ) ).

cnf(i_0_1735,axiom,
    ( ~ esk7593_4(X1,X2,X3,X4)
    | esk7565_4(X1,X2,X3,X4) ) ).

cnf(i_0_1736,axiom,
    ( ~ esk2832_4(X1,X2,X3,X4)
    | ~ esk2834_4(X1,X2,X3,X4)
    | ~ esk2852_4(X1,X2,X3,X4) ) ).

cnf(i_0_1737,axiom,
    ( esk4618_4(X1,X2,X3,X4)
    | ~ esk4558_4(X1,X2,X3,X4) ) ).

cnf(i_0_1738,axiom,
    ( esk14416_4(X1,X2,X3,X4)
    | esk14369_4(X1,X2,X3,X4)
    | ~ esk14453_4(X1,X2,X3,X4) ) ).

cnf(i_0_1739,axiom,
    ( ~ esk13996_4(X1,X2,X3,X4)
    | esk14058_4(X1,X2,X3,X4) ) ).

cnf(i_0_1740,axiom,
    ( esk1235_4(X1,X2,X3,X4)
    | esk1268_4(X1,X2,X3,X4) ) ).

cnf(i_0_1741,axiom,
    ( p(X4)
    | ~ esk521_4(X1,X2,X3,X4)
    | p(X2)
    | p(X3)
    | esk1_0
    | p(X1) ) ).

cnf(i_0_1742,axiom,
    ( ~ esk3469_4(X1,X2,X3,X4)
    | esk3489_4(X1,X2,X3,X4) ) ).

cnf(i_0_1743,axiom,
    ( esk2960_4(X1,X2,X3,X4)
    | ~ esk2931_4(X1,X2,X3,X4) ) ).

cnf(i_0_1744,axiom,
    ( ~ esk11556_4(X1,X2,X3,X4)
    | esk11437_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_1745,axiom,
    ( esk10773_4(X1,X2,X3,X4)
    | esk10856_4(X1,X2,X3,X4)
    | ~ esk10833_4(X1,X2,X3,X4) ) ).

cnf(i_0_1746,axiom,
    ( esk4840_4(X1,X2,X3,X4)
    | esk4923_4(X1,X2,X3,X4) ) ).

cnf(i_0_1747,axiom,
    ( ~ esk3391_4(X1,X2,X3,X4)
    | esk3370_4(X1,X2,X3,X4)
    | esk3369_4(X1,X2,X3,X4) ) ).

cnf(i_0_1748,axiom,
    ( ~ esk16158_4(X1,X2,X3,X4)
    | ~ esk16120_4(X1,X2,X3,X4)
    | ~ esk16157_4(X1,X2,X3,X4) ) ).

cnf(i_0_1749,axiom,
    ( esk5055_4(X1,X2,X3,X4)
    | ~ esk5057_4(X1,X2,X3,X4) ) ).

cnf(i_0_1750,axiom,
    ( ~ esk664_4(X1,X2,X3,X4)
    | ~ esk636_4(X1,X2,X3,X4) ) ).

cnf(i_0_1751,axiom,
    ( esk5948_4(X1,X2,X3,X4)
    | esk5892_4(X1,X2,X3,X4) ) ).

cnf(i_0_1752,axiom,
    ( esk16127_4(X1,X2,X3,X4)
    | esk16143_4(X1,X2,X3,X4) ) ).

cnf(i_0_1753,axiom,
    ( esk2640_4(X1,X2,X3,X4)
    | esk2621_4(X1,X2,X3,X4)
    | ~ esk2569_4(X1,X2,X3,X4) ) ).

cnf(i_0_1754,axiom,
    ( ~ esk16598_4(X1,X2,X3,X4)
    | ~ esk16571_4(X1,X2,X3,X4) ) ).

cnf(i_0_1755,axiom,
    ( ~ esk14134_4(X1,X2,X3,X4)
    | ~ esk14101_4(X1,X2,X3,X4)
    | ~ esk14076_4(X1,X2,X3,X4) ) ).

cnf(i_0_1756,axiom,
    ( esk2471_4(X1,X2,X3,X4)
    | esk2472_4(X1,X2,X3,X4) ) ).

cnf(i_0_1757,axiom,
    ( ~ esk11180_4(X1,X2,X3,X4)
    | esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_1758,axiom,
    ( esk392_4(X1,X2,X3,X4)
    | ~ esk517_4(X1,X2,X3,X4)
    | ~ esk405_4(X1,X2,X3,X4) ) ).

cnf(i_0_1759,axiom,
    ( ~ esk14207_4(X1,X2,X3,X4)
    | ~ esk14168_4(X1,X2,X3,X4) ) ).

cnf(i_0_1760,axiom,
    ( esk4921_4(X1,X2,X3,X4)
    | esk4868_4(X1,X2,X3,X4) ) ).

cnf(i_0_1761,axiom,
    ( esk8240_4(X1,X2,X3,X4)
    | ~ esk8238_4(X1,X2,X3,X4) ) ).

cnf(i_0_1762,axiom,
    ( esk9309_4(X1,X2,X3,X4)
    | esk9257_4(X1,X2,X3,X4) ) ).

cnf(i_0_1763,axiom,
    ( esk2878_4(X1,X2,X3,X4)
    | ~ esk2897_4(X1,X2,X3,X4)
    | esk2826_4(X1,X2,X3,X4) ) ).

cnf(i_0_1764,axiom,
    ( ~ esk13556_4(X1,X2,X3,X4)
    | ~ esk13575_4(X1,X2,X3,X4)
    | ~ esk13576_4(X1,X2,X3,X4) ) ).

cnf(i_0_1765,axiom,
    ( ~ esk13645_4(X1,X2,X3,X4)
    | esk13660_4(X1,X2,X3,X4) ) ).

cnf(i_0_1766,axiom,
    ( esk4884_4(X1,X2,X3,X4)
    | ~ esk4626_4(X1,X2,X3,X4) ) ).

cnf(i_0_1767,axiom,
    ( ~ esk3226_4(X1,X2,X3,X4)
    | esk3194_4(X1,X2,X3,X4) ) ).

cnf(i_0_1768,axiom,
    ( ~ p(X2)
    | esk16703_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X4)
    | ~ esk240_0
    | p(X3) ) ).

cnf(i_0_1769,axiom,
    ( esk6884_4(X1,X2,X3,X4)
    | esk6882_4(X1,X2,X3,X4) ) ).

cnf(i_0_1770,axiom,
    ( esk13115_4(X1,X2,X3,X4)
    | esk12997_4(X1,X2,X3,X4) ) ).

cnf(i_0_1771,axiom,
    ( ~ esk11239_4(X1,X2,X3,X4)
    | ~ esk11271_4(X1,X2,X3,X4)
    | ~ esk11270_4(X1,X2,X3,X4) ) ).

cnf(i_0_1772,axiom,
    ( ~ esk2459_4(X1,X2,X3,X4)
    | esk2439_4(X1,X2,X3,X4) ) ).

cnf(i_0_1773,axiom,
    ( esk14092_4(X1,X2,X3,X4)
    | esk14078_4(X1,X2,X3,X4) ) ).

cnf(i_0_1774,axiom,
    ( esk8719_4(X1,X2,X3,X4)
    | ~ esk8461_4(X1,X2,X3,X4) ) ).

cnf(i_0_1775,axiom,
    ( ~ esk3852_4(X1,X2,X3,X4)
    | ~ esk3883_4(X1,X2,X3,X4) ) ).

cnf(i_0_1776,axiom,
    ( esk487_4(X1,X2,X3,X4)
    | esk574_4(X1,X2,X3,X4) ) ).

cnf(i_0_1777,axiom,
    ( esk8134_4(X1,X2,X3,X4)
    | esk8129_4(X1,X2,X3,X4) ) ).

cnf(i_0_1778,axiom,
    ( ~ esk12110_4(X1,X2,X3,X4)
    | ~ esk12102_4(X1,X2,X3,X4) ) ).

cnf(i_0_1779,axiom,
    ( ~ esk3746_4(X1,X2,X3,X4)
    | esk3734_4(X1,X2,X3,X4)
    | ~ esk3860_4(X1,X2,X3,X4) ) ).

cnf(i_0_1780,axiom,
    ( esk12263_4(X1,X2,X3,X4)
    | esk12306_4(X1,X2,X3,X4) ) ).

cnf(i_0_1781,axiom,
    ( ~ esk3634_4(X1,X2,X3,X4)
    | ~ esk3669_4(X1,X2,X3,X4)
    | ~ esk3583_4(X1,X2,X3,X4) ) ).

cnf(i_0_1782,axiom,
    ( esk9820_4(X1,X2,X3,X4)
    | ~ esk9792_4(X1,X2,X3,X4) ) ).

cnf(i_0_1783,axiom,
    ( ~ esk2820_4(X1,X2,X3,X4)
    | ~ esk2768_4(X1,X2,X3,X4)
    | ~ esk2787_4(X1,X2,X3,X4) ) ).

cnf(i_0_1784,axiom,
    ( ~ esk2889_4(X1,X2,X3,X4)
    | esk2866_4(X1,X2,X3,X4)
    | esk2806_4(X1,X2,X3,X4) ) ).

cnf(i_0_1785,axiom,
    ( esk9837_4(X1,X2,X3,X4)
    | esk9751_4(X1,X2,X3,X4) ) ).

cnf(i_0_1786,axiom,
    ( ~ esk14613_4(X1,X2,X3,X4)
    | ~ esk14579_4(X1,X2,X3,X4)
    | ~ esk14614_4(X1,X2,X3,X4) ) ).

cnf(i_0_1787,axiom,
    ( esk13155_4(X1,X2,X3,X4)
    | esk13068_4(X1,X2,X3,X4) ) ).

cnf(i_0_1788,axiom,
    ( ~ esk7486_4(X1,X2,X3,X4)
    | ~ esk7442_4(X1,X2,X3,X4)
    | ~ esk7487_4(X1,X2,X3,X4) ) ).

cnf(i_0_1789,axiom,
    ( esk13648_4(X1,X2,X3,X4)
    | ~ esk13622_4(X1,X2,X3,X4)
    | esk13673_4(X1,X2,X3,X4) ) ).

cnf(i_0_1790,axiom,
    ( esk10379_4(X1,X2,X3,X4)
    | esk10429_4(X1,X2,X3,X4) ) ).

cnf(i_0_1791,axiom,
    ( ~ esk14389_4(X1,X2,X3,X4)
    | ~ esk14420_4(X1,X2,X3,X4) ) ).

cnf(i_0_1792,axiom,
    ( esk11440_4(X1,X2,X3,X4)
    | ~ esk11562_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_1793,axiom,
    ( esk10607_4(X1,X2,X3,X4)
    | esk10588_4(X1,X2,X3,X4)
    | ~ esk10536_4(X1,X2,X3,X4) ) ).

cnf(i_0_1794,axiom,
    ( ~ esk16648_4(X1,X2,X3,X4)
    | ~ esk16668_4(X1,X2,X3,X4)
    | ~ esk16754_4(X1,X2,X3,X4) ) ).

cnf(i_0_1795,axiom,
    ( ~ esk4577_4(X1,X2,X3,X4)
    | ~ esk4576_4(X1,X2,X3,X4)
    | ~ esk4563_4(X1,X2,X3,X4) ) ).

cnf(i_0_1796,axiom,
    ( ~ esk6830_4(X1,X2,X3,X4)
    | esk6824_4(X1,X2,X3,X4)
    | ~ esk6926_4(X1,X2,X3,X4) ) ).

cnf(i_0_1797,axiom,
    ( ~ esk12580_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4)
    | esk12478_4(X1,X2,X3,X4) ) ).

cnf(i_0_1798,axiom,
    ( esk14054_4(X1,X2,X3,X4)
    | esk14049_4(X1,X2,X3,X4)
    | ~ esk14050_4(X1,X2,X3,X4) ) ).

cnf(i_0_1799,axiom,
    ( ~ esk14632_4(X1,X2,X3,X4)
    | esk14374_4(X1,X2,X3,X4) ) ).

cnf(i_0_1800,axiom,
    ( esk4569_4(X1,X2,X3,X4)
    | esk4585_4(X1,X2,X3,X4) ) ).

cnf(i_0_1801,axiom,
    ( esk8886_4(X1,X2,X3,X4)
    | ~ esk8867_4(X1,X2,X3,X4) ) ).

cnf(i_0_1802,axiom,
    ( ~ esk7884_4(X1,X2,X3,X4)
    | esk7862_4(X1,X2,X3,X4) ) ).

cnf(i_0_1803,axiom,
    ( esk6646_4(X1,X2,X3,X4)
    | esk6623_4(X1,X2,X3,X4) ) ).

cnf(i_0_1804,axiom,
    ( esk1192_4(X1,X2,X3,X4)
    | ~ esk1186_4(X1,X2,X3,X4) ) ).

cnf(i_0_1805,axiom,
    ( esk3305_4(X1,X2,X3,X4)
    | esk3338_4(X1,X2,X3,X4) ) ).

cnf(i_0_1806,axiom,
    ( esk11319_4(X1,X2,X3,X4)
    | ~ esk11318_4(X1,X2,X3,X4)
    | ~ esk11317_4(X1,X2,X3,X4) ) ).

cnf(i_0_1807,axiom,
    ( esk14545_4(X1,X2,X3,X4)
    | ~ esk14287_4(X1,X2,X3,X4) ) ).

cnf(i_0_1808,axiom,
    ( esk15821_4(X1,X2,X3,X4)
    | esk15876_4(X1,X2,X3,X4) ) ).

cnf(i_0_1809,axiom,
    ( ~ esk8004_4(X1,X2,X3,X4)
    | ~ esk8005_4(X1,X2,X3,X4)
    | ~ esk8030_4(X1,X2,X3,X4) ) ).

cnf(i_0_1810,axiom,
    ( esk7886_4(X1,X2,X3,X4)
    | ~ esk7882_4(X1,X2,X3,X4)
    | esk7881_4(X1,X2,X3,X4) ) ).

cnf(i_0_1811,axiom,
    ( ~ esk13231_4(X1,X2,X3,X4)
    | ~ esk13258_4(X1,X2,X3,X4)
    | esk13255_4(X1,X2,X3,X4) ) ).

cnf(i_0_1812,axiom,
    ( esk11508_4(X1,X2,X3,X4)
    | esk11534_4(X1,X2,X3,X4) ) ).

cnf(i_0_1813,axiom,
    ( ~ esk10058_4(X1,X2,X3,X4)
    | ~ esk10010_4(X1,X2,X3,X4) ) ).

cnf(i_0_1814,axiom,
    ( esk15582_4(X1,X2,X3,X4)
    | esk15573_4(X1,X2,X3,X4) ) ).

cnf(i_0_1815,axiom,
    ( esk10694_4(X1,X2,X3,X4)
    | ~ esk10952_4(X1,X2,X3,X4) ) ).

cnf(i_0_1816,axiom,
    ( esk3297_4(X1,X2,X3,X4)
    | esk3330_4(X1,X2,X3,X4) ) ).

cnf(i_0_1817,axiom,
    ( esk16189_4(X1,X2,X3,X4)
    | ~ esk16447_4(X1,X2,X3,X4) ) ).

cnf(i_0_1818,axiom,
    ( ~ esk1065_4(X1,X2,X3,X4)
    | ~ esk1009_4(X1,X2,X3,X4) ) ).

cnf(i_0_1819,axiom,
    ( ~ esk8913_4(X1,X2,X3,X4)
    | esk8915_4(X1,X2,X3,X4) ) ).

cnf(i_0_1820,axiom,
    ( esk3396_4(X1,X2,X3,X4)
    | ~ esk3344_4(X1,X2,X3,X4) ) ).

cnf(i_0_1821,axiom,
    ( esk13691_4(X1,X2,X3,X4)
    | esk13648_4(X1,X2,X3,X4) ) ).

cnf(i_0_1822,axiom,
    ( ~ esk11947_4(X1,X2,X3,X4)
    | ~ esk12093_4(X1,X2,X3,X4)
    | ~ esk12100_4(X1,X2,X3,X4) ) ).

cnf(i_0_1823,axiom,
    ( esk9799_4(X1,X2,X3,X4)
    | esk9800_4(X1,X2,X3,X4) ) ).

cnf(i_0_1824,axiom,
    ( ~ esk8972_4(X1,X2,X3,X4)
    | ~ esk8886_4(X1,X2,X3,X4)
    | esk8875_4(X1,X2,X3,X4) ) ).

cnf(i_0_1825,axiom,
    ( ~ esk12085_4(X1,X2,X3,X4)
    | esk12004_4(X1,X2,X3,X4) ) ).

cnf(i_0_1826,axiom,
    ( esk10829_4(X1,X2,X3,X4)
    | esk10860_4(X1,X2,X3,X4)
    | ~ esk10861_4(X1,X2,X3,X4) ) ).

cnf(i_0_1827,axiom,
    ( esk7765_4(X1,X2,X3,X4)
    | ~ esk7735_4(X1,X2,X3,X4) ) ).

cnf(i_0_1828,axiom,
    ( ~ esk6553_4(X1,X2,X3,X4)
    | esk6573_4(X1,X2,X3,X4) ) ).

cnf(i_0_1829,axiom,
    ( esk1911_4(X1,X2,X3,X4)
    | ~ esk1939_4(X1,X2,X3,X4) ) ).

cnf(i_0_1830,axiom,
    ( esk9029_4(X1,X2,X3,X4)
    | esk9028_4(X1,X2,X3,X4) ) ).

cnf(i_0_1831,axiom,
    ( esk14335_4(X1,X2,X3,X4)
    | esk14353_4(X1,X2,X3,X4) ) ).

cnf(i_0_1832,axiom,
    ( esk11298_4(X1,X2,X3,X4)
    | ~ esk11556_4(X1,X2,X3,X4) ) ).

cnf(i_0_1833,axiom,
    ( esk10779_4(X1,X2,X3,X4)
    | ~ esk10521_4(X1,X2,X3,X4) ) ).

cnf(i_0_1834,axiom,
    ( esk12547_4(X1,X2,X3,X4)
    | esk12534_4(X1,X2,X3,X4) ) ).

cnf(i_0_1835,axiom,
    ( ~ esk2171_4(X1,X2,X3,X4)
    | esk2193_4(X1,X2,X3,X4) ) ).

cnf(i_0_1836,axiom,
    ( ~ esk3025_4(X1,X2,X3,X4)
    | ~ esk3032_4(X1,X2,X3,X4)
    | ~ esk3065_4(X1,X2,X3,X4) ) ).

cnf(i_0_1837,axiom,
    ( ~ esk8875_4(X1,X2,X3,X4)
    | esk8972_4(X1,X2,X3,X4) ) ).

cnf(i_0_1838,axiom,
    ( esk4091_4(X1,X2,X3,X4)
    | ~ esk4136_4(X1,X2,X3,X4) ) ).

cnf(i_0_1839,axiom,
    ( esk13134_4(X1,X2,X3,X4)
    | esk13136_4(X1,X2,X3,X4) ) ).

cnf(i_0_1840,axiom,
    ( esk564_4(X1,X2,X3,X4)
    | esk543_4(X1,X2,X3,X4)
    | ~ esk542_4(X1,X2,X3,X4) ) ).

cnf(i_0_1841,axiom,
    ( esk754_4(X1,X2,X3,X4)
    | esk721_4(X1,X2,X3,X4) ) ).

cnf(i_0_1842,axiom,
    ( ~ esk407_4(X1,X2,X3,X4)
    | ~ esk355_4(X1,X2,X3,X4) ) ).

cnf(i_0_1843,axiom,
    ( ~ esk2336_4(X1,X2,X3,X4)
    | ~ esk2345_4(X1,X2,X3,X4) ) ).

cnf(i_0_1844,axiom,
    ( ~ esk9195_4(X1,X2,X3,X4)
    | ~ esk9197_4(X1,X2,X3,X4)
    | ~ esk9313_4(X1,X2,X3,X4) ) ).

cnf(i_0_1845,axiom,
    ( esk10433_4(X1,X2,X3,X4)
    | ~ esk10453_4(X1,X2,X3,X4)
    | esk10457_4(X1,X2,X3,X4) ) ).

cnf(i_0_1846,axiom,
    ( esk16698_4(X1,X2,X3,X4)
    | esk16665_4(X1,X2,X3,X4) ) ).

cnf(i_0_1847,axiom,
    ( ~ esk11954_4(X1,X2,X3,X4)
    | esk11970_4(X1,X2,X3,X4) ) ).

cnf(i_0_1848,axiom,
    ( esk13545_4(X1,X2,X3,X4)
    | esk13641_4(X1,X2,X3,X4)
    | esk13544_4(X1,X2,X3,X4) ) ).

cnf(i_0_1849,axiom,
    ( ~ esk8912_4(X1,X2,X3,X4)
    | esk8890_4(X1,X2,X3,X4) ) ).

cnf(i_0_1850,axiom,
    ( esk14791_4(X1,X2,X3,X4)
    | ~ esk14893_4(X1,X2,X3,X4)
    | ~ esk14797_4(X1,X2,X3,X4) ) ).

cnf(i_0_1851,axiom,
    ( ~ esk2770_4(X1,X2,X3,X4)
    | ~ esk2780_4(X1,X2,X3,X4)
    | ~ esk2892_4(X1,X2,X3,X4) ) ).

cnf(i_0_1852,axiom,
    ( esk16347_4(X1,X2,X3,X4)
    | esk16346_4(X1,X2,X3,X4) ) ).

cnf(i_0_1853,axiom,
    ( ~ esk6225_4(X1,X2,X3,X4)
    | ~ esk6173_4(X1,X2,X3,X4) ) ).

cnf(i_0_1854,axiom,
    ( esk11021_4(X1,X2,X3,X4)
    | esk10992_4(X1,X2,X3,X4) ) ).

cnf(i_0_1855,axiom,
    ( esk14910_4(X1,X2,X3,X4)
    | ~ esk15168_4(X1,X2,X3,X4) ) ).

cnf(i_0_1856,axiom,
    ( esk2814_4(X1,X2,X3,X4)
    | esk2862_4(X1,X2,X3,X4) ) ).

cnf(i_0_1857,axiom,
    ( ~ esk14205_4(X1,X2,X3,X4)
    | esk14186_4(X1,X2,X3,X4)
    | esk14134_4(X1,X2,X3,X4) ) ).

cnf(i_0_1858,axiom,
    ( ~ esk1284_4(X1,X2,X3,X4)
    | esk1355_4(X1,X2,X3,X4)
    | esk1336_4(X1,X2,X3,X4) ) ).

cnf(i_0_1859,axiom,
    ( esk16137_4(X1,X2,X3,X4)
    | esk16130_4(X1,X2,X3,X4) ) ).

cnf(i_0_1860,axiom,
    ( esk2855_4(X1,X2,X3,X4)
    | esk2824_4(X1,X2,X3,X4) ) ).

cnf(i_0_1861,axiom,
    ( esk10941_4(X1,X2,X3,X4)
    | ~ esk11068_4(X1,X2,X3,X4)
    | esk10911_4(X1,X2,X3,X4) ) ).

cnf(i_0_1862,axiom,
    ( esk16730_4(X1,X2,X3,X4)
    | ~ esk16760_4(X1,X2,X3,X4)
    | esk16708_4(X1,X2,X3,X4) ) ).

cnf(i_0_1863,axiom,
    ( ~ esk5854_4(X1,X2,X3,X4)
    | ~ esk5853_4(X1,X2,X3,X4) ) ).

cnf(i_0_1864,axiom,
    ( ~ esk14562_4(X1,X2,X3,X4)
    | esk14546_4(X1,X2,X3,X4) ) ).

cnf(i_0_1865,axiom,
    ( ~ esk16222_4(X1,X2,X3,X4)
    | ~ esk16224_4(X1,X2,X3,X4) ) ).

cnf(i_0_1866,axiom,
    ( esk10026_4(X1,X2,X3,X4)
    | ~ esk9768_4(X1,X2,X3,X4) ) ).

cnf(i_0_1867,axiom,
    ( ~ esk6202_4(X1,X2,X3,X4)
    | ~ esk6201_4(X1,X2,X3,X4)
    | ~ esk6157_4(X1,X2,X3,X4) ) ).

cnf(i_0_1868,axiom,
    ( esk7507_4(X1,X2,X3,X4)
    | ~ esk7509_4(X1,X2,X3,X4) ) ).

cnf(i_0_1869,axiom,
    ( esk13003_4(X1,X2,X3,X4)
    | esk13021_4(X1,X2,X3,X4) ) ).

cnf(i_0_1870,axiom,
    ( esk7842_4(X1,X2,X3,X4)
    | ~ esk7815_4(X1,X2,X3,X4) ) ).

cnf(i_0_1871,axiom,
    ( esk13003_4(X1,X2,X3,X4)
    | esk13027_4(X1,X2,X3,X4)
    | ~ esk13023_4(X1,X2,X3,X4) ) ).

cnf(i_0_1872,axiom,
    ( esk15160_4(X1,X2,X3,X4)
    | ~ esk15038_4(X1,X2,X3,X4) ) ).

cnf(i_0_1873,axiom,
    ( esk13028_4(X1,X2,X3,X4)
    | esk12994_4(X1,X2,X3,X4)
    | esk13048_4(X1,X2,X3,X4) ) ).

cnf(i_0_1874,axiom,
    ( ~ esk13722_4(X1,X2,X3,X4)
    | esk13757_4(X1,X2,X3,X4) ) ).

cnf(i_0_1875,axiom,
    ( p(X1)
    | ~ esk509_4(X1,X2,X3,X4)
    | esk199_0
    | p(X2)
    | p(X4)
    | ~ p(X3) ) ).

cnf(i_0_1876,axiom,
    ( ~ esk5274_4(X1,X2,X3,X4)
    | esk5398_4(X1,X2,X3,X4) ) ).

cnf(i_0_1877,axiom,
    ( ~ esk11230_4(X1,X2,X3,X4)
    | ~ esk11328_4(X1,X2,X3,X4)
    | ~ esk11321_4(X1,X2,X3,X4) ) ).

cnf(i_0_1878,axiom,
    ( ~ esk15225_4(X1,X2,X3,X4)
    | ~ esk15106_4(X1,X2,X3,X4)
    | ~ esk15110_4(X1,X2,X3,X4) ) ).

cnf(i_0_1879,axiom,
    ( esk15082_4(X1,X2,X3,X4)
    | ~ esk14824_4(X1,X2,X3,X4) ) ).

cnf(i_0_1880,axiom,
    ( ~ esk9312_4(X1,X2,X3,X4)
    | esk9311_4(X1,X2,X3,X4) ) ).

cnf(i_0_1881,axiom,
    ( esk14337_4(X1,X2,X3,X4)
    | esk14332_4(X1,X2,X3,X4) ) ).

cnf(i_0_1882,axiom,
    ( ~ esk14158_4(X1,X2,X3,X4)
    | ~ esk14167_4(X1,X2,X3,X4) ) ).

cnf(i_0_1883,axiom,
    ( esk11531_4(X1,X2,X3,X4)
    | esk11506_4(X1,X2,X3,X4) ) ).

cnf(i_0_1884,axiom,
    ( ~ esk4905_4(X1,X2,X3,X4)
    | esk4942_4(X1,X2,X3,X4) ) ).

cnf(i_0_1885,axiom,
    ( ~ esk4023_4(X1,X2,X3,X4)
    | esk4011_4(X1,X2,X3,X4)
    | esk4022_4(X1,X2,X3,X4) ) ).

cnf(i_0_1886,axiom,
    ( esk16646_4(X1,X2,X3,X4)
    | esk16651_4(X1,X2,X3,X4) ) ).

cnf(i_0_1887,axiom,
    ( esk13863_4(X1,X2,X3,X4)
    | esk13949_4(X1,X2,X3,X4) ) ).

cnf(i_0_1888,axiom,
    ( esk11509_4(X1,X2,X3,X4)
    | esk11505_4(X1,X2,X3,X4) ) ).

cnf(i_0_1889,axiom,
    ( ~ esk1791_4(X1,X2,X3,X4)
    | esk2049_4(X1,X2,X3,X4) ) ).

cnf(i_0_1890,axiom,
    ( ~ esk2246_4(X1,X2,X3,X4)
    | esk2303_4(X1,X2,X3,X4) ) ).

cnf(i_0_1891,axiom,
    ( esk15054_4(X1,X2,X3,X4)
    | ~ esk15040_4(X1,X2,X3,X4) ) ).

cnf(i_0_1892,axiom,
    ( ~ esk3257_4(X1,X2,X3,X4)
    | ~ esk3256_4(X1,X2,X3,X4)
    | esk3258_4(X1,X2,X3,X4) ) ).

cnf(i_0_1893,axiom,
    ( esk15575_4(X1,X2,X3,X4)
    | ~ esk15317_4(X1,X2,X3,X4) ) ).

cnf(i_0_1894,axiom,
    ( ~ esk8272_4(X1,X2,X3,X4)
    | esk8270_4(X1,X2,X3,X4) ) ).

cnf(i_0_1895,axiom,
    ( esk6592_4(X1,X2,X3,X4)
    | esk6587_4(X1,X2,X3,X4) ) ).

cnf(i_0_1896,axiom,
    ( ~ esk9803_4(X1,X2,X3,X4)
    | ~ esk9747_4(X1,X2,X3,X4) ) ).

cnf(i_0_1897,axiom,
    ( ~ esk4690_4(X1,X2,X3,X4)
    | ~ esk4700_4(X1,X2,X3,X4) ) ).

cnf(i_0_1898,axiom,
    ( esk16402_4(X1,X2,X3,X4)
    | esk16435_4(X1,X2,X3,X4) ) ).

cnf(i_0_1899,axiom,
    ( esk10504_4(X1,X2,X3,X4)
    | esk10466_4(X1,X2,X3,X4) ) ).

cnf(i_0_1900,axiom,
    ( ~ esk1178_4(X1,X2,X3,X4)
    | ~ esk1151_4(X1,X2,X3,X4) ) ).

cnf(i_0_1901,axiom,
    ( esk6580_4(X1,X2,X3,X4)
    | ~ esk6322_4(X1,X2,X3,X4) ) ).

cnf(i_0_1902,axiom,
    ( esk11038_4(X1,X2,X3,X4)
    | ~ esk11119_4(X1,X2,X3,X4)
    | esk11085_4(X1,X2,X3,X4) ) ).

cnf(i_0_1903,axiom,
    ( esk499_4(X1,X2,X3,X4)
    | ~ esk398_4(X1,X2,X3,X4) ) ).

cnf(i_0_1904,axiom,
    ( esk6139_4(X1,X2,X3,X4)
    | esk6111_4(X1,X2,X3,X4) ) ).

cnf(i_0_1905,axiom,
    ( esk6703_4(X1,X2,X3,X4)
    | esk6696_4(X1,X2,X3,X4) ) ).

cnf(i_0_1906,axiom,
    ( esk2016_4(X1,X2,X3,X4)
    | esk2049_4(X1,X2,X3,X4) ) ).

cnf(i_0_1907,axiom,
    ( esk16179_4(X1,X2,X3,X4)
    | ~ esk16437_4(X1,X2,X3,X4) ) ).

cnf(i_0_1908,axiom,
    ( ~ esk6667_4(X1,X2,X3,X4)
    | ~ esk6720_4(X1,X2,X3,X4)
    | ~ esk6718_4(X1,X2,X3,X4)
    | ~ esk6665_4(X1,X2,X3,X4) ) ).

cnf(i_0_1909,axiom,
    ( esk524_4(X1,X2,X3,X4)
    | ~ esk404_4(X1,X2,X3,X4) ) ).

cnf(i_0_1910,axiom,
    ( esk14556_4(X1,X2,X3,X4)
    | ~ esk14558_4(X1,X2,X3,X4) ) ).

cnf(i_0_1911,axiom,
    ( esk14562_4(X1,X2,X3,X4)
    | ~ esk14546_4(X1,X2,X3,X4) ) ).

cnf(i_0_1912,axiom,
    ( ~ esk7580_4(X1,X2,X3,X4)
    | esk7632_4(X1,X2,X3,X4) ) ).

cnf(i_0_1913,axiom,
    ( ~ esk9324_4(X1,X2,X3,X4)
    | ~ esk9285_4(X1,X2,X3,X4) ) ).

cnf(i_0_1914,axiom,
    ( ~ esk11442_4(X1,X2,X3,X4)
    | esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_1915,axiom,
    ( esk14963_4(X1,X2,X3,X4)
    | ~ esk14964_4(X1,X2,X3,X4)
    | esk14913_4(X1,X2,X3,X4) ) ).

cnf(i_0_1916,axiom,
    ( esk13861_4(X1,X2,X3,X4)
    | esk13949_4(X1,X2,X3,X4)
    | ~ esk13942_4(X1,X2,X3,X4) ) ).

cnf(i_0_1917,axiom,
    ( esk12755_4(X1,X2,X3,X4)
    | esk12760_4(X1,X2,X3,X4) ) ).

cnf(i_0_1918,axiom,
    ( esk5842_4(X1,X2,X3,X4)
    | ~ esk5905_4(X1,X2,X3,X4) ) ).

cnf(i_0_1919,axiom,
    ( esk16229_4(X1,X2,X3,X4)
    | ~ esk16254_4(X1,X2,X3,X4)
    | esk16228_4(X1,X2,X3,X4) ) ).

cnf(i_0_1920,axiom,
    ( esk6046_4(X1,X2,X3,X4)
    | ~ esk6059_4(X1,X2,X3,X4)
    | ~ esk6171_4(X1,X2,X3,X4) ) ).

cnf(i_0_1921,axiom,
    ( esk3078_4(X1,X2,X3,X4)
    | ~ esk3336_4(X1,X2,X3,X4) ) ).

cnf(i_0_1922,axiom,
    ( ~ esk11322_4(X1,X2,X3,X4)
    | ~ esk11329_4(X1,X2,X3,X4)
    | ~ esk11176_4(X1,X2,X3,X4) ) ).

cnf(i_0_1923,axiom,
    ( esk7709_4(X1,X2,X3,X4)
    | esk7739_4(X1,X2,X3,X4) ) ).

cnf(i_0_1924,axiom,
    ( ~ esk11458_4(X1,X2,X3,X4)
    | ~ esk11428_4(X1,X2,X3,X4) ) ).

cnf(i_0_1925,axiom,
    ( ~ esk1937_4(X1,X2,X3,X4)
    | esk2035_4(X1,X2,X3,X4) ) ).

cnf(i_0_1926,axiom,
    ( esk4630_4(X1,X2,X3,X4)
    | ~ esk4888_4(X1,X2,X3,X4) ) ).

cnf(i_0_1927,axiom,
    ( ~ esk12901_4(X1,X2,X3,X4)
    | ~ esk12923_4(X1,X2,X3,X4) ) ).

cnf(i_0_1928,axiom,
    ( ~ esk10441_4(X1,X2,X3,X4)
    | ~ esk10436_4(X1,X2,X3,X4) ) ).

cnf(i_0_1929,axiom,
    ( ~ esk2859_4(X1,X2,X3,X4)
    | ~ esk2850_4(X1,X2,X3,X4) ) ).

cnf(i_0_1930,axiom,
    ( ~ esk8886_4(X1,X2,X3,X4)
    | esk8874_4(X1,X2,X3,X4)
    | ~ esk9000_4(X1,X2,X3,X4) ) ).

cnf(i_0_1931,axiom,
    ( esk13254_4(X1,X2,X3,X4)
    | esk13231_4(X1,X2,X3,X4)
    | esk13256_4(X1,X2,X3,X4) ) ).

cnf(i_0_1932,axiom,
    ( ~ esk7358_4(X1,X2,X3,X4)
    | ~ esk7356_4(X1,X2,X3,X4) ) ).

cnf(i_0_1933,axiom,
    ( esk11199_4(X1,X2,X3,X4)
    | ~ esk11179_4(X1,X2,X3,X4) ) ).

cnf(i_0_1934,axiom,
    ( esk6960_4(X1,X2,X3,X4)
    | esk6953_4(X1,X2,X3,X4) ) ).

cnf(i_0_1935,axiom,
    ( ~ esk6202_4(X1,X2,X3,X4)
    | ~ esk6204_4(X1,X2,X3,X4) ) ).

cnf(i_0_1936,axiom,
    ( esk9439_4(X1,X2,X3,X4)
    | ~ esk9505_4(X1,X2,X3,X4) ) ).

cnf(i_0_1937,axiom,
    ( ~ esk16165_4(X1,X2,X3,X4)
    | ~ esk16198_4(X1,X2,X3,X4)
    | ~ esk16132_4(X1,X2,X3,X4) ) ).

cnf(i_0_1938,axiom,
    ( ~ esk16779_4(X1,X2,X3,X4)
    | ~ esk16656_4(X1,X2,X3,X4)
    | ~ esk16648_4(X1,X2,X3,X4) ) ).

cnf(i_0_1939,axiom,
    ( ~ esk2057_4(X1,X2,X3,X4)
    | ~ esk2126_4(X1,X2,X3,X4)
    | ~ esk2083_4(X1,X2,X3,X4) ) ).

cnf(i_0_1940,axiom,
    ( esk5805_4(X1,X2,X3,X4)
    | esk5803_4(X1,X2,X3,X4) ) ).

cnf(i_0_1941,axiom,
    ( ~ esk14552_4(X1,X2,X3,X4)
    | ~ esk14551_4(X1,X2,X3,X4) ) ).

cnf(i_0_1942,axiom,
    ( esk4610_4(X1,X2,X3,X4)
    | ~ esk4562_4(X1,X2,X3,X4) ) ).

cnf(i_0_1943,axiom,
    ( esk7740_4(X1,X2,X3,X4)
    | ~ esk7759_4(X1,X2,X3,X4)
    | esk7705_4(X1,X2,X3,X4) ) ).

cnf(i_0_1944,axiom,
    ( ~ esk13336_4(X1,X2,X3,X4)
    | ~ esk13290_4(X1,X2,X3,X4)
    | ~ esk13337_4(X1,X2,X3,X4) ) ).

cnf(i_0_1945,axiom,
    ( esk9296_4(X1,X2,X3,X4)
    | esk9211_4(X1,X2,X3,X4) ) ).

cnf(i_0_1946,axiom,
    ( ~ esk2608_4(X1,X2,X3,X4)
    | ~ esk2609_4(X1,X2,X3,X4) ) ).

cnf(i_0_1947,axiom,
    ( ~ esk14193_4(X1,X2,X3,X4)
    | esk14195_4(X1,X2,X3,X4)
    | ~ esk14194_4(X1,X2,X3,X4) ) ).

cnf(i_0_1948,axiom,
    ( ~ esk13266_4(X1,X2,X3,X4)
    | ~ esk13267_4(X1,X2,X3,X4) ) ).

cnf(i_0_1949,axiom,
    ( ~ esk16559_4(X1,X2,X3,X4)
    | esk16589_4(X1,X2,X3,X4) ) ).

cnf(i_0_1950,axiom,
    ( esk12998_4(X1,X2,X3,X4)
    | ~ esk12993_4(X1,X2,X3,X4) ) ).

cnf(i_0_1951,axiom,
    ( esk12274_4(X1,X2,X3,X4)
    | esk12285_4(X1,X2,X3,X4) ) ).

cnf(i_0_1952,axiom,
    ( esk4326_4(X1,X2,X3,X4)
    | esk4312_4(X1,X2,X3,X4) ) ).

cnf(i_0_1953,axiom,
    ( esk9820_4(X1,X2,X3,X4)
    | ~ esk9819_4(X1,X2,X3,X4) ) ).

cnf(i_0_1954,axiom,
    ( ~ esk3066_4(X1,X2,X3,X4)
    | esk3021_4(X1,X2,X3,X4) ) ).

cnf(i_0_1955,axiom,
    ( ~ esk12653_4(X1,X2,X3,X4)
    | esk12652_4(X1,X2,X3,X4) ) ).

cnf(i_0_1956,axiom,
    ( ~ esk4757_4(X1,X2,X3,X4)
    | esk4774_4(X1,X2,X3,X4) ) ).

cnf(i_0_1957,axiom,
    ( esk11542_4(X1,X2,X3,X4)
    | ~ esk11284_4(X1,X2,X3,X4) ) ).

cnf(i_0_1958,axiom,
    ( ~ esk16230_4(X1,X2,X3,X4)
    | esk16215_4(X1,X2,X3,X4)
    | ~ esk16170_4(X1,X2,X3,X4) ) ).

cnf(i_0_1959,axiom,
    ( esk9482_4(X1,X2,X3,X4)
    | esk9452_4(X1,X2,X3,X4) ) ).

cnf(i_0_1960,axiom,
    ( esk1954_4(X1,X2,X3,X4)
    | ~ esk1696_4(X1,X2,X3,X4) ) ).

cnf(i_0_1961,axiom,
    ( ~ esk5043_4(X1,X2,X3,X4)
    | ~ esk5063_4(X1,X2,X3,X4)
    | esk5027_4(X1,X2,X3,X4) ) ).

cnf(i_0_1962,axiom,
    ( esk8735_4(X1,X2,X3,X4)
    | esk8766_4(X1,X2,X3,X4) ) ).

cnf(i_0_1963,axiom,
    ( esk8974_4(X1,X2,X3,X4)
    | ~ esk9057_4(X1,X2,X3,X4)
    | esk9034_4(X1,X2,X3,X4) ) ).

cnf(i_0_1964,axiom,
    ( esk675_4(X1,X2,X3,X4)
    | esk677_4(X1,X2,X3,X4) ) ).

cnf(i_0_1965,axiom,
    ( p(X3)
    | esk252_0
    | ~ p(X1)
    | ~ esk16705_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X4) ) ).

cnf(i_0_1966,axiom,
    ( esk16672_4(X1,X2,X3,X4)
    | esk16648_4(X1,X2,X3,X4) ) ).

cnf(i_0_1967,axiom,
    ( ~ esk927_4(X1,X2,X3,X4)
    | ~ esk926_4(X1,X2,X3,X4) ) ).

cnf(i_0_1968,axiom,
    ( esk12237_4(X1,X2,X3,X4)
    | esk12238_4(X1,X2,X3,X4) ) ).

cnf(i_0_1969,axiom,
    ( esk13902_4(X1,X2,X3,X4)
    | ~ esk13917_4(X1,X2,X3,X4)
    | ~ esk13857_4(X1,X2,X3,X4) ) ).

cnf(i_0_1970,axiom,
    ( esk13582_4(X1,X2,X3,X4)
    | esk13669_4(X1,X2,X3,X4) ) ).

cnf(i_0_1971,axiom,
    ( ~ esk15359_4(X1,X2,X3,X4)
    | esk15398_4(X1,X2,X3,X4) ) ).

cnf(i_0_1972,axiom,
    ( ~ esk14671_4(X1,X2,X3,X4)
    | esk14708_4(X1,X2,X3,X4) ) ).

cnf(i_0_1973,axiom,
    ( ~ esk15694_4(X1,X2,X3,X4)
    | esk15695_4(X1,X2,X3,X4)
    | ~ esk15693_4(X1,X2,X3,X4) ) ).

cnf(i_0_1974,axiom,
    ( ~ esk2330_4(X1,X2,X3,X4)
    | esk2331_4(X1,X2,X3,X4)
    | ~ esk2329_4(X1,X2,X3,X4) ) ).

cnf(i_0_1975,axiom,
    ( ~ esk1947_4(X1,X2,X3,X4)
    | ~ esk2045_4(X1,X2,X3,X4)
    | esk1927_4(X1,X2,X3,X4) ) ).

cnf(i_0_1976,axiom,
    ( esk2296_4(X1,X2,X3,X4)
    | ~ esk2384_4(X1,X2,X3,X4)
    | esk2377_4(X1,X2,X3,X4) ) ).

cnf(i_0_1977,axiom,
    ( esk4322_4(X1,X2,X3,X4)
    | esk4434_4(X1,X2,X3,X4) ) ).

cnf(i_0_1978,axiom,
    ( esk6366_4(X1,X2,X3,X4)
    | esk6369_4(X1,X2,X3,X4) ) ).

cnf(i_0_1979,axiom,
    ( esk14383_4(X1,X2,X3,X4)
    | ~ esk14264_4(X1,X2,X3,X4) ) ).

cnf(i_0_1980,axiom,
    ( ~ esk6436_4(X1,X2,X3,X4)
    | esk6434_4(X1,X2,X3,X4) ) ).

cnf(i_0_1981,axiom,
    ( esk8879_4(X1,X2,X3,X4)
    | ~ esk8849_4(X1,X2,X3,X4) ) ).

cnf(i_0_1982,axiom,
    ( ~ esk15069_4(X1,X2,X3,X4)
    | esk15070_4(X1,X2,X3,X4) ) ).

cnf(i_0_1983,axiom,
    ( esk12483_4(X1,X2,X3,X4)
    | esk12601_4(X1,X2,X3,X4) ) ).

cnf(i_0_1984,axiom,
    ( esk14548_4(X1,X2,X3,X4)
    | esk14559_4(X1,X2,X3,X4)
    | ~ esk14560_4(X1,X2,X3,X4) ) ).

cnf(i_0_1985,axiom,
    ( esk1770_4(X1,X2,X3,X4)
    | esk1855_4(X1,X2,X3,X4) ) ).

cnf(i_0_1986,axiom,
    ( ~ esk16127_4(X1,X2,X3,X4)
    | ~ esk16144_4(X1,X2,X3,X4)
    | ~ esk16143_4(X1,X2,X3,X4) ) ).

cnf(i_0_1987,axiom,
    ( esk8806_4(X1,X2,X3,X4)
    | ~ esk8807_4(X1,X2,X3,X4) ) ).

cnf(i_0_1988,axiom,
    ( esk4784_4(X1,X2,X3,X4)
    | esk4785_4(X1,X2,X3,X4) ) ).

cnf(i_0_1989,axiom,
    ( esk4921_4(X1,X2,X3,X4)
    | esk4866_4(X1,X2,X3,X4) ) ).

cnf(i_0_1990,axiom,
    ( esk11428_4(X1,X2,X3,X4)
    | esk11431_4(X1,X2,X3,X4)
    | esk11406_4(X1,X2,X3,X4)
    | esk11430_4(X1,X2,X3,X4)
    | esk11458_4(X1,X2,X3,X4) ) ).

cnf(i_0_1991,axiom,
    ( ~ esk8750_4(X1,X2,X3,X4)
    | esk9008_4(X1,X2,X3,X4) ) ).

cnf(i_0_1992,axiom,
    ( esk6853_4(X1,X2,X3,X4)
    | esk6835_4(X1,X2,X3,X4) ) ).

cnf(i_0_1993,axiom,
    ( ~ esk10834_4(X1,X2,X3,X4)
    | ~ esk10783_4(X1,X2,X3,X4)
    | ~ esk10827_4(X1,X2,X3,X4) ) ).

cnf(i_0_1994,axiom,
    ( ~ esk7174_4(X1,X2,X3,X4)
    | esk7135_4(X1,X2,X3,X4) ) ).

cnf(i_0_1995,axiom,
    ( esk2242_4(X1,X2,X3,X4)
    | ~ esk2311_4(X1,X2,X3,X4) ) ).

cnf(i_0_1996,axiom,
    ( ~ esk12277_4(X1,X2,X3,X4)
    | ~ esk12317_4(X1,X2,X3,X4)
    | ~ esk12284_4(X1,X2,X3,X4) ) ).

cnf(i_0_1997,axiom,
    ( esk6716_4(X1,X2,X3,X4)
    | esk6748_4(X1,X2,X3,X4) ) ).

cnf(i_0_1998,axiom,
    ( ~ esk2958_4(X1,X2,X3,X4)
    | esk3079_4(X1,X2,X3,X4) ) ).

cnf(i_0_1999,axiom,
    ( ~ esk10994_4(X1,X2,X3,X4)
    | ~ esk10993_4(X1,X2,X3,X4) ) ).

cnf(i_0_2000,axiom,
    ( ~ esk10956_4(X1,X2,X3,X4)
    | ~ esk10954_4(X1,X2,X3,X4) ) ).

cnf(i_0_2001,axiom,
    ( p(X3)
    | esk505_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X1)
    | p(X4)
    | ~ esk179_0 ) ).

cnf(i_0_2002,axiom,
    ( esk1868_4(X1,X2,X3,X4)
    | esk1754_4(X1,X2,X3,X4) ) ).

cnf(i_0_2003,axiom,
    ( esk9705_4(X1,X2,X3,X4)
    | ~ esk9744_4(X1,X2,X3,X4) ) ).

cnf(i_0_2004,axiom,
    ( esk15488_4(X1,X2,X3,X4)
    | ~ esk15454_4(X1,X2,X3,X4) ) ).

cnf(i_0_2005,axiom,
    ( esk16196_4(X1,X2,X3,X4)
    | ~ esk15938_4(X1,X2,X3,X4) ) ).

cnf(i_0_2006,axiom,
    ( esk6961_4(X1,X2,X3,X4)
    | esk6914_4(X1,X2,X3,X4) ) ).

cnf(i_0_2007,axiom,
    ( ~ esk2891_4(X1,X2,X3,X4)
    | ~ esk2810_4(X1,X2,X3,X4)
    | ~ esk2898_4(X1,X2,X3,X4) ) ).

cnf(i_0_2008,axiom,
    ( esk1483_4(X1,X2,X3,X4)
    | esk1492_4(X1,X2,X3,X4) ) ).

cnf(i_0_2009,axiom,
    ( ~ esk1962_4(X1,X2,X3,X4)
    | ~ esk1960_4(X1,X2,X3,X4) ) ).

cnf(i_0_2010,axiom,
    ( ~ esk6395_4(X1,X2,X3,X4)
    | ~ esk6352_4(X1,X2,X3,X4)
    | ~ esk6396_4(X1,X2,X3,X4) ) ).

cnf(i_0_2011,axiom,
    ( esk4378_4(X1,X2,X3,X4)
    | ~ esk4382_4(X1,X2,X3,X4) ) ).

cnf(i_0_2012,axiom,
    ( ~ esk10303_4(X1,X2,X3,X4)
    | ~ esk10311_4(X1,X2,X3,X4) ) ).

cnf(i_0_2013,axiom,
    ( esk11508_4(X1,X2,X3,X4)
    | esk11532_4(X1,X2,X3,X4) ) ).

cnf(i_0_2014,axiom,
    ( esk2021_4(X1,X2,X3,X4)
    | esk2106_4(X1,X2,X3,X4) ) ).

cnf(i_0_2015,axiom,
    ( ~ p(X3)
    | p(X1)
    | esk114_0
    | p(X4)
    | ~ esk16687_4(X1,X2,X3,X4)
    | ~ p(X2) ) ).

cnf(i_0_2016,axiom,
    ( ~ esk6862_4(X1,X2,X3,X4)
    | ~ esk6959_4(X1,X2,X3,X4) ) ).

cnf(i_0_2017,axiom,
    ( esk12742_4(X1,X2,X3,X4)
    | esk12690_4(X1,X2,X3,X4) ) ).

cnf(i_0_2018,axiom,
    ( ~ esk14896_4(X1,X2,X3,X4)
    | esk15154_4(X1,X2,X3,X4) ) ).

cnf(i_0_2019,axiom,
    ( esk10418_4(X1,X2,X3,X4)
    | ~ esk10516_4(X1,X2,X3,X4)
    | ~ esk10428_4(X1,X2,X3,X4) ) ).

cnf(i_0_2020,axiom,
    ( esk4321_4(X1,X2,X3,X4)
    | esk4310_4(X1,X2,X3,X4) ) ).

cnf(i_0_2021,axiom,
    ( esk1187_4(X1,X2,X3,X4)
    | esk1184_4(X1,X2,X3,X4)
    | esk1190_4(X1,X2,X3,X4)
    | esk1188_4(X1,X2,X3,X4) ) ).

cnf(i_0_2022,axiom,
    ( esk6729_4(X1,X2,X3,X4)
    | ~ esk6730_4(X1,X2,X3,X4) ) ).

cnf(i_0_2023,axiom,
    ( ~ esk26_0
    | p(X2)
    | esk412_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_2024,axiom,
    ( ~ esk10239_4(X1,X2,X3,X4)
    | ~ esk10324_4(X1,X2,X3,X4)
    | ~ esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_2025,axiom,
    ( ~ esk9972_4(X1,X2,X3,X4)
    | ~ esk9966_4(X1,X2,X3,X4)
    | ~ esk10086_4(X1,X2,X3,X4) ) ).

cnf(i_0_2026,axiom,
    ( ~ esk7136_4(X1,X2,X3,X4)
    | esk7172_4(X1,X2,X3,X4) ) ).

cnf(i_0_2027,axiom,
    ( esk3467_4(X1,X2,X3,X4)
    | ~ esk3487_4(X1,X2,X3,X4) ) ).

cnf(i_0_2028,axiom,
    ( p(X4)
    | ~ p(X3)
    | ~ p(X2)
    | esk16703_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ esk242_0 ) ).

cnf(i_0_2029,axiom,
    ( esk9566_4(X1,X2,X3,X4)
    | esk9516_4(X1,X2,X3,X4)
    | ~ esk9567_4(X1,X2,X3,X4) ) ).

cnf(i_0_2030,axiom,
    ( esk6133_4(X1,X2,X3,X4)
    | esk6218_4(X1,X2,X3,X4) ) ).

cnf(i_0_2031,axiom,
    ( ~ esk13355_4(X1,X2,X3,X4)
    | ~ esk13436_4(X1,X2,X3,X4) ) ).

cnf(i_0_2032,axiom,
    ( ~ esk8141_4(X1,X2,X3,X4)
    | esk8119_4(X1,X2,X3,X4) ) ).

cnf(i_0_2033,axiom,
    ( ~ esk8374_4(X1,X2,X3,X4)
    | ~ esk8346_4(X1,X2,X3,X4) ) ).

cnf(i_0_2034,axiom,
    ( ~ esk5033_4(X1,X2,X3,X4)
    | ~ esk5003_4(X1,X2,X3,X4) ) ).

cnf(i_0_2035,axiom,
    ( esk3113_4(X1,X2,X3,X4)
    | esk3085_4(X1,X2,X3,X4) ) ).

cnf(i_0_2036,axiom,
    ( ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10855_4(X1,X2,X3,X4)
    | ~ esk10739_4(X1,X2,X3,X4) ) ).

cnf(i_0_2037,axiom,
    ( ~ esk412_4(X1,X2,X3,X4)
    | esk1_0
    | p(X3)
    | p(X4)
    | p(X1)
    | p(X2) ) ).

cnf(i_0_2038,axiom,
    ( esk4931_4(X1,X2,X3,X4)
    | esk4844_4(X1,X2,X3,X4) ) ).

cnf(i_0_2039,axiom,
    ( ~ esk2051_4(X1,X2,X3,X4)
    | esk2105_4(X1,X2,X3,X4)
    | esk2086_4(X1,X2,X3,X4) ) ).

cnf(i_0_2040,axiom,
    ( ~ esk1023_4(X1,X2,X3,X4)
    | ~ esk990_4(X1,X2,X3,X4)
    | ~ esk969_4(X1,X2,X3,X4) ) ).

cnf(i_0_2041,axiom,
    ( esk3483_4(X1,X2,X3,X4)
    | ~ esk3585_4(X1,X2,X3,X4)
    | ~ esk3489_4(X1,X2,X3,X4) ) ).

cnf(i_0_2042,axiom,
    ( ~ esk12518_4(X1,X2,X3,X4)
    | esk12599_4(X1,X2,X3,X4) ) ).

cnf(i_0_2043,axiom,
    ( esk10407_4(X1,X2,X3,X4)
    | ~ esk10459_4(X1,X2,X3,X4) ) ).

cnf(i_0_2044,axiom,
    ( esk6412_4(X1,X2,X3,X4)
    | esk6460_4(X1,X2,X3,X4) ) ).

cnf(i_0_2045,axiom,
    ( esk2713_4(X1,X2,X3,X4)
    | ~ esk2718_4(X1,X2,X3,X4)
    | ~ esk2834_4(X1,X2,X3,X4) ) ).

cnf(i_0_2046,axiom,
    ( esk3377_4(X1,X2,X3,X4)
    | esk3376_4(X1,X2,X3,X4)
    | esk3375_4(X1,X2,X3,X4) ) ).

cnf(i_0_2047,axiom,
    ( esk42_0
    | p(X2)
    | p(X4)
    | ~ p(X3)
    | ~ p(X1)
    | ~ esk415_4(X1,X2,X3,X4) ) ).

cnf(i_0_2048,axiom,
    ( esk808_4(X1,X2,X3,X4)
    | esk810_4(X1,X2,X3,X4)
    | esk809_4(X1,X2,X3,X4) ) ).

cnf(i_0_2049,axiom,
    ( esk4564_4(X1,X2,X3,X4)
    | esk4574_4(X1,X2,X3,X4) ) ).

cnf(i_0_2050,axiom,
    ( esk12056_4(X1,X2,X3,X4)
    | esk12140_4(X1,X2,X3,X4)
    | ~ esk12103_4(X1,X2,X3,X4) ) ).

cnf(i_0_2051,axiom,
    ( ~ esk5557_4(X1,X2,X3,X4)
    | ~ esk5556_4(X1,X2,X3,X4) ) ).

cnf(i_0_2052,axiom,
    ( ~ esk12259_4(X1,X2,X3,X4)
    | ~ esk12239_4(X1,X2,X3,X4)
    | esk12223_4(X1,X2,X3,X4) ) ).

cnf(i_0_2053,axiom,
    ( esk5081_4(X1,X2,X3,X4)
    | esk5098_4(X1,X2,X3,X4) ) ).

cnf(i_0_2054,axiom,
    ( esk8667_4(X1,X2,X3,X4)
    | esk8704_4(X1,X2,X3,X4) ) ).

cnf(i_0_2055,axiom,
    ( esk5203_4(X1,X2,X3,X4)
    | ~ esk5177_4(X1,X2,X3,X4)
    | esk5178_4(X1,X2,X3,X4) ) ).

cnf(i_0_2056,axiom,
    ( esk5081_4(X1,X2,X3,X4)
    | esk5104_4(X1,X2,X3,X4) ) ).

cnf(i_0_2057,axiom,
    ( ~ esk4650_4(X1,X2,X3,X4)
    | esk4605_4(X1,X2,X3,X4) ) ).

cnf(i_0_2058,axiom,
    ( ~ esk684_4(X1,X2,X3,X4)
    | esk682_4(X1,X2,X3,X4) ) ).

cnf(i_0_2059,axiom,
    ( esk6561_4(X1,X2,X3,X4)
    | ~ esk6526_4(X1,X2,X3,X4) ) ).

cnf(i_0_2060,axiom,
    ( esk1204_4(X1,X2,X3,X4)
    | ~ esk946_4(X1,X2,X3,X4) ) ).

cnf(i_0_2061,axiom,
    ( ~ esk1756_4(X1,X2,X3,X4)
    | ~ esk1733_4(X1,X2,X3,X4)
    | ~ esk1755_4(X1,X2,X3,X4) ) ).

cnf(i_0_2062,axiom,
    ( esk2198_4(X1,X2,X3,X4)
    | ~ esk2166_4(X1,X2,X3,X4) ) ).

cnf(i_0_2063,axiom,
    ( esk14321_4(X1,X2,X3,X4)
    | esk14358_4(X1,X2,X3,X4) ) ).

cnf(i_0_2064,axiom,
    ( ~ esk1078_4(X1,X2,X3,X4)
    | ~ esk1056_4(X1,X2,X3,X4)
    | ~ esk1057_4(X1,X2,X3,X4) ) ).

cnf(i_0_2065,axiom,
    ( esk15750_4(X1,X2,X3,X4)
    | esk15728_4(X1,X2,X3,X4) ) ).

cnf(i_0_2066,axiom,
    ( esk4808_4(X1,X2,X3,X4)
    | esk4857_4(X1,X2,X3,X4) ) ).

cnf(i_0_2067,axiom,
    ( esk12545_4(X1,X2,X3,X4)
    | esk12534_4(X1,X2,X3,X4) ) ).

cnf(i_0_2068,axiom,
    ( ~ esk2876_4(X1,X2,X3,X4)
    | esk2822_4(X1,X2,X3,X4)
    | esk2857_4(X1,X2,X3,X4) ) ).

cnf(i_0_2069,axiom,
    ( ~ esk6617_4(X1,X2,X3,X4)
    | ~ esk6637_4(X1,X2,X3,X4)
    | ~ esk6636_4(X1,X2,X3,X4) ) ).

cnf(i_0_2070,axiom,
    ( esk12554_4(X1,X2,X3,X4)
    | esk12536_4(X1,X2,X3,X4) ) ).

cnf(i_0_2071,axiom,
    ( ~ esk2980_4(X1,X2,X3,X4)
    | esk2722_4(X1,X2,X3,X4) ) ).

cnf(i_0_2072,axiom,
    ( ~ esk4765_4(X1,X2,X3,X4)
    | esk4864_4(X1,X2,X3,X4) ) ).

cnf(i_0_2073,axiom,
    ( p(X3)
    | ~ p(X2)
    | ~ p(X1)
    | esk519_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk284_0 ) ).

cnf(i_0_2074,axiom,
    ( esk9025_4(X1,X2,X3,X4)
    | esk8990_4(X1,X2,X3,X4)
    | ~ esk9044_4(X1,X2,X3,X4) ) ).

cnf(i_0_2075,axiom,
    ( esk1496_4(X1,X2,X3,X4)
    | esk1477_4(X1,X2,X3,X4) ) ).

cnf(i_0_2076,axiom,
    ( ~ esk12495_4(X1,X2,X3,X4)
    | ~ esk12496_4(X1,X2,X3,X4) ) ).

cnf(i_0_2077,axiom,
    ( esk1551_4(X1,X2,X3,X4)
    | ~ esk1555_4(X1,X2,X3,X4) ) ).

cnf(i_0_2078,axiom,
    ( esk6465_4(X1,X2,X3,X4)
    | esk6382_4(X1,X2,X3,X4) ) ).

cnf(i_0_2079,axiom,
    ( ~ esk8503_4(X1,X2,X3,X4)
    | ~ esk8456_4(X1,X2,X3,X4)
    | ~ esk8424_4(X1,X2,X3,X4) ) ).

cnf(i_0_2080,axiom,
    ( esk900_4(X1,X2,X3,X4)
    | ~ esk1019_4(X1,X2,X3,X4)
    | ~ esk919_4(X1,X2,X3,X4) ) ).

cnf(i_0_2081,axiom,
    ( ~ esk11448_4(X1,X2,X3,X4)
    | esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_2082,axiom,
    ( esk7379_4(X1,X2,X3,X4)
    | esk7425_4(X1,X2,X3,X4) ) ).

cnf(i_0_2083,axiom,
    ( ~ esk3856_4(X1,X2,X3,X4)
    | ~ esk3884_4(X1,X2,X3,X4)
    | ~ esk3854_4(X1,X2,X3,X4)
    | ~ esk3882_4(X1,X2,X3,X4) ) ).

cnf(i_0_2084,axiom,
    ( ~ esk3634_4(X1,X2,X3,X4)
    | ~ esk3632_4(X1,X2,X3,X4) ) ).

cnf(i_0_2085,axiom,
    ( p(X1)
    | esk129_0
    | ~ p(X3)
    | ~ esk499_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X2) ) ).

cnf(i_0_2086,axiom,
    ( ~ esk10168_4(X1,X2,X3,X4)
    | esk10169_4(X1,X2,X3,X4)
    | ~ esk10174_4(X1,X2,X3,X4) ) ).

cnf(i_0_2087,axiom,
    ( esk12006_4(X1,X2,X3,X4)
    | esk12050_4(X1,X2,X3,X4) ) ).

cnf(i_0_2088,axiom,
    ( ~ esk6929_4(X1,X2,X3,X4)
    | esk6872_4(X1,X2,X3,X4) ) ).

cnf(i_0_2089,axiom,
    ( ~ esk11455_4(X1,X2,X3,X4)
    | ~ esk11580_4(X1,X2,X3,X4) ) ).

cnf(i_0_2090,axiom,
    ( ~ esk14189_4(X1,X2,X3,X4)
    | esk14161_4(X1,X2,X3,X4)
    | esk14188_4(X1,X2,X3,X4) ) ).

cnf(i_0_2091,axiom,
    ( ~ esk9099_4(X1,X2,X3,X4)
    | esk9128_4(X1,X2,X3,X4) ) ).

cnf(i_0_2092,axiom,
    ( esk12223_4(X1,X2,X3,X4)
    | esk12277_4(X1,X2,X3,X4)
    | esk12257_4(X1,X2,X3,X4) ) ).

cnf(i_0_2093,axiom,
    ( ~ esk10674_4(X1,X2,X3,X4)
    | esk10771_4(X1,X2,X3,X4) ) ).

cnf(i_0_2094,axiom,
    ( ~ esk3577_4(X1,X2,X3,X4)
    | esk3660_4(X1,X2,X3,X4)
    | esk3637_4(X1,X2,X3,X4) ) ).

cnf(i_0_2095,axiom,
    ( esk14836_4(X1,X2,X3,X4)
    | esk14870_4(X1,X2,X3,X4) ) ).

cnf(i_0_2096,axiom,
    ( esk1703_4(X1,X2,X3,X4)
    | esk1705_4(X1,X2,X3,X4) ) ).

cnf(i_0_2097,axiom,
    ( esk13783_4(X1,X2,X3,X4)
    | esk13782_4(X1,X2,X3,X4)
    | esk13777_4(X1,X2,X3,X4) ) ).

cnf(i_0_2098,axiom,
    ( ~ esk521_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X1)
    | ~ p(X2)
    | ~ p(X3)
    | esk302_0 ) ).

cnf(i_0_2099,axiom,
    ( ~ esk452_4(X1,X2,X3,X4)
    | ~ esk462_4(X1,X2,X3,X4)
    | ~ esk463_4(X1,X2,X3,X4) ) ).

cnf(i_0_2100,axiom,
    ( ~ esk3155_4(X1,X2,X3,X4)
    | esk3148_4(X1,X2,X3,X4)
    | esk3067_4(X1,X2,X3,X4) ) ).

cnf(i_0_2101,axiom,
    ( esk4776_4(X1,X2,X3,X4)
    | esk4775_4(X1,X2,X3,X4) ) ).

cnf(i_0_2102,axiom,
    ( ~ esk7882_4(X1,X2,X3,X4)
    | esk7884_4(X1,X2,X3,X4)
    | ~ esk7883_4(X1,X2,X3,X4) ) ).

cnf(i_0_2103,axiom,
    ( ~ esk16451_4(X1,X2,X3,X4)
    | esk16503_4(X1,X2,X3,X4) ) ).

cnf(i_0_2104,axiom,
    ( ~ esk12268_4(X1,X2,X3,X4)
    | ~ esk12297_4(X1,X2,X3,X4)
    | ~ esk12296_4(X1,X2,X3,X4) ) ).

cnf(i_0_2105,axiom,
    ( ~ esk7195_4(X1,X2,X3,X4)
    | ~ esk7266_4(X1,X2,X3,X4)
    | ~ esk7247_4(X1,X2,X3,X4) ) ).

cnf(i_0_2106,axiom,
    ( esk16703_4(X1,X2,X3,X4)
    | p(X4)
    | ~ esk228_0
    | p(X3)
    | p(X2)
    | p(X1) ) ).

cnf(i_0_2107,axiom,
    ( esk14373_4(X1,X2,X3,X4)
    | ~ esk14274_4(X1,X2,X3,X4) ) ).

cnf(i_0_2108,axiom,
    ( esk11559_4(X1,X2,X3,X4)
    | ~ esk11817_4(X1,X2,X3,X4) ) ).

cnf(i_0_2109,axiom,
    ( esk11670_4(X1,X2,X3,X4)
    | ~ esk11697_4(X1,X2,X3,X4) ) ).

cnf(i_0_2110,axiom,
    ( ~ esk1555_4(X1,X2,X3,X4)
    | ~ esk1463_4(X1,X2,X3,X4) ) ).

cnf(i_0_2111,axiom,
    ( ~ esk16458_4(X1,X2,X3,X4)
    | ~ esk16457_4(X1,X2,X3,X4)
    | esk16459_4(X1,X2,X3,X4) ) ).

cnf(i_0_2112,axiom,
    ( esk15693_4(X1,X2,X3,X4)
    | ~ esk15691_4(X1,X2,X3,X4) ) ).

cnf(i_0_2113,axiom,
    ( ~ esk6985_4(X1,X2,X3,X4)
    | ~ esk6986_4(X1,X2,X3,X4)
    | esk6987_4(X1,X2,X3,X4) ) ).

cnf(i_0_2114,axiom,
    ( esk11008_4(X1,X2,X3,X4)
    | esk10994_4(X1,X2,X3,X4) ) ).

cnf(i_0_2115,axiom,
    ( esk4884_4(X1,X2,X3,X4)
    | ~ esk4760_4(X1,X2,X3,X4) ) ).

cnf(i_0_2116,axiom,
    ( esk15065_4(X1,X2,X3,X4)
    | esk15068_4(X1,X2,X3,X4)
    | esk15066_4(X1,X2,X3,X4)
    | esk15062_4(X1,X2,X3,X4) ) ).

cnf(i_0_2117,axiom,
    ( esk5285_4(X1,X2,X3,X4)
    | ~ esk5286_4(X1,X2,X3,X4) ) ).

cnf(i_0_2118,axiom,
    ( ~ esk1544_4(X1,X2,X3,X4)
    | esk1802_4(X1,X2,X3,X4) ) ).

cnf(i_0_2119,axiom,
    ( esk11580_4(X1,X2,X3,X4)
    | esk11455_4(X1,X2,X3,X4) ) ).

cnf(i_0_2120,axiom,
    ( esk6718_4(X1,X2,X3,X4)
    | esk6716_4(X1,X2,X3,X4)
    | esk6717_4(X1,X2,X3,X4) ) ).

cnf(i_0_2121,axiom,
    ( ~ esk8106_4(X1,X2,X3,X4)
    | esk8080_4(X1,X2,X3,X4) ) ).

cnf(i_0_2122,axiom,
    ( esk9968_4(X1,X2,X3,X4)
    | esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_2123,axiom,
    ( ~ esk10836_4(X1,X2,X3,X4)
    | esk10835_4(X1,X2,X3,X4)
    | esk10785_4(X1,X2,X3,X4) ) ).

cnf(i_0_2124,axiom,
    ( ~ esk5780_4(X1,X2,X3,X4)
    | esk5800_4(X1,X2,X3,X4) ) ).

cnf(i_0_2125,axiom,
    ( esk12110_4(X1,X2,X3,X4)
    | esk12109_4(X1,X2,X3,X4) ) ).

cnf(i_0_2126,axiom,
    ( esk11970_4(X1,X2,X3,X4)
    | ~ esk11959_4(X1,X2,X3,X4) ) ).

cnf(i_0_2127,axiom,
    ( esk6916_4(X1,X2,X3,X4)
    | ~ esk6658_4(X1,X2,X3,X4) ) ).

cnf(i_0_2128,axiom,
    ( esk2709_4(X1,X2,X3,X4)
    | ~ esk2683_4(X1,X2,X3,X4) ) ).

cnf(i_0_2129,axiom,
    ( ~ esk10183_4(X1,X2,X3,X4)
    | esk10167_4(X1,X2,X3,X4)
    | ~ esk10203_4(X1,X2,X3,X4) ) ).

cnf(i_0_2130,axiom,
    ( esk7730_4(X1,X2,X3,X4)
    | esk7723_4(X1,X2,X3,X4)
    | esk7631_4(X1,X2,X3,X4) ) ).

cnf(i_0_2131,axiom,
    ( esk13132_4(X1,X2,X3,X4)
    | esk13160_4(X1,X2,X3,X4) ) ).

cnf(i_0_2132,axiom,
    ( ~ esk4382_4(X1,X2,X3,X4)
    | ~ esk4293_4(X1,X2,X3,X4) ) ).

cnf(i_0_2133,axiom,
    ( ~ esk12624_4(X1,X2,X3,X4)
    | ~ esk12588_4(X1,X2,X3,X4)
    | ~ esk12623_4(X1,X2,X3,X4) ) ).

cnf(i_0_2134,axiom,
    ( esk4613_4(X1,X2,X3,X4)
    | ~ esk4511_4(X1,X2,X3,X4) ) ).

cnf(i_0_2135,axiom,
    ( esk8633_4(X1,X2,X3,X4)
    | ~ esk8891_4(X1,X2,X3,X4) ) ).

cnf(i_0_2136,axiom,
    ( ~ esk9793_4(X1,X2,X3,X4)
    | ~ esk9791_4(X1,X2,X3,X4) ) ).

cnf(i_0_2137,axiom,
    ( esk1966_4(X1,X2,X3,X4)
    | esk1955_4(X1,X2,X3,X4)
    | ~ esk1967_4(X1,X2,X3,X4) ) ).

cnf(i_0_2138,axiom,
    ( esk5325_4(X1,X2,X3,X4)
    | esk5366_4(X1,X2,X3,X4) ) ).

cnf(i_0_2139,axiom,
    ( esk13629_4(X1,X2,X3,X4)
    | esk13511_4(X1,X2,X3,X4) ) ).

cnf(i_0_2140,axiom,
    ( esk4405_4(X1,X2,X3,X4)
    | esk4440_4(X1,X2,X3,X4) ) ).

cnf(i_0_2141,axiom,
    ( esk11519_4(X1,X2,X3,X4)
    | esk11500_4(X1,X2,X3,X4) ) ).

cnf(i_0_2142,axiom,
    ( esk15958_4(X1,X2,X3,X4)
    | ~ esk15911_4(X1,X2,X3,X4)
    | esk15995_4(X1,X2,X3,X4) ) ).

cnf(i_0_2143,axiom,
    ( esk15123_4(X1,X2,X3,X4)
    | esk15156_4(X1,X2,X3,X4) ) ).

cnf(i_0_2144,axiom,
    ( ~ esk13544_4(X1,X2,X3,X4)
    | ~ esk13641_4(X1,X2,X3,X4) ) ).

cnf(i_0_2145,axiom,
    ( ~ esk3374_4(X1,X2,X3,X4)
    | ~ esk3330_4(X1,X2,X3,X4)
    | ~ esk3381_4(X1,X2,X3,X4) ) ).

cnf(i_0_2146,axiom,
    ( ~ esk1947_4(X1,X2,X3,X4)
    | esk1940_4(X1,X2,X3,X4)
    | ~ esk2041_4(X1,X2,X3,X4) ) ).

cnf(i_0_2147,axiom,
    ( esk7134_4(X1,X2,X3,X4)
    | esk7145_4(X1,X2,X3,X4) ) ).

cnf(i_0_2148,axiom,
    ( esk16220_4(X1,X2,X3,X4)
    | esk16192_4(X1,X2,X3,X4) ) ).

cnf(i_0_2149,axiom,
    ( esk5953_4(X1,X2,X3,X4)
    | ~ esk5955_4(X1,X2,X3,X4) ) ).

cnf(i_0_2150,axiom,
    ( ~ esk7588_4(X1,X2,X3,X4)
    | esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_2151,axiom,
    ( ~ esk10285_4(X1,X2,X3,X4)
    | ~ esk10287_4(X1,X2,X3,X4)
    | ~ esk10305_4(X1,X2,X3,X4) ) ).

cnf(i_0_2152,axiom,
    ( ~ esk16134_4(X1,X2,X3,X4)
    | ~ esk16148_4(X1,X2,X3,X4)
    | ~ esk16231_4(X1,X2,X3,X4) ) ).

cnf(i_0_2153,axiom,
    ( ~ esk9399_4(X1,X2,X3,X4)
    | esk9519_4(X1,X2,X3,X4) ) ).

cnf(i_0_2154,axiom,
    ( esk13910_4(X1,X2,X3,X4)
    | esk13911_4(X1,X2,X3,X4)
    | esk13950_4(X1,X2,X3,X4)
    | esk13909_4(X1,X2,X3,X4) ) ).

cnf(i_0_2155,axiom,
    ( ~ esk8948_4(X1,X2,X3,X4)
    | ~ esk9060_4(X1,X2,X3,X4)
    | ~ esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_2156,axiom,
    ( esk1033_4(X1,X2,X3,X4)
    | esk1053_4(X1,X2,X3,X4) ) ).

cnf(i_0_2157,axiom,
    ( esk1849_4(X1,X2,X3,X4)
    | esk1764_4(X1,X2,X3,X4) ) ).

cnf(i_0_2158,axiom,
    ( esk844_4(X1,X2,X3,X4)
    | esk822_4(X1,X2,X3,X4) ) ).

cnf(i_0_2159,axiom,
    ( esk1200_4(X1,X2,X3,X4)
    | ~ esk1199_4(X1,X2,X3,X4) ) ).

cnf(i_0_2160,axiom,
    ( esk15322_4(X1,X2,X3,X4)
    | esk15321_4(X1,X2,X3,X4) ) ).

cnf(i_0_2161,axiom,
    ( ~ esk6315_4(X1,X2,X3,X4)
    | esk6435_4(X1,X2,X3,X4) ) ).

cnf(i_0_2162,axiom,
    ( esk6210_4(X1,X2,X3,X4)
    | ~ esk6212_4(X1,X2,X3,X4) ) ).

cnf(i_0_2163,axiom,
    ( ~ esk1563_4(X1,X2,X3,X4)
    | ~ esk1556_4(X1,X2,X3,X4)
    | ~ esk1410_4(X1,X2,X3,X4) ) ).

cnf(i_0_2164,axiom,
    ( ~ esk661_4(X1,X2,X3,X4)
    | esk781_4(X1,X2,X3,X4) ) ).

cnf(i_0_2165,axiom,
    ( ~ esk15747_4(X1,X2,X3,X4)
    | esk15728_4(X1,X2,X3,X4)
    | esk15676_4(X1,X2,X3,X4) ) ).

cnf(i_0_2166,axiom,
    ( ~ esk6957_4(X1,X2,X3,X4)
    | esk6955_4(X1,X2,X3,X4) ) ).

cnf(i_0_2167,axiom,
    ( esk13401_4(X1,X2,X3,X4)
    | ~ esk13402_4(X1,X2,X3,X4)
    | esk13427_4(X1,X2,X3,X4) ) ).

cnf(i_0_2168,axiom,
    ( ~ esk15574_4(X1,X2,X3,X4)
    | esk15832_4(X1,X2,X3,X4) ) ).

cnf(i_0_2169,axiom,
    ( esk5699_4(X1,X2,X3,X4)
    | ~ esk5700_4(X1,X2,X3,X4)
    | esk5686_4(X1,X2,X3,X4) ) ).

cnf(i_0_2170,axiom,
    ( esk7138_4(X1,X2,X3,X4)
    | esk7083_4(X1,X2,X3,X4) ) ).

cnf(i_0_2171,axiom,
    ( esk10278_4(X1,X2,X3,X4)
    | ~ esk10209_4(X1,X2,X3,X4) ) ).

cnf(i_0_2172,axiom,
    ( ~ esk7139_4(X1,X2,X3,X4)
    | ~ esk7261_4(X1,X2,X3,X4)
    | ~ esk7149_4(X1,X2,X3,X4) ) ).

cnf(i_0_2173,axiom,
    ( ~ esk3613_4(X1,X2,X3,X4)
    | esk3614_4(X1,X2,X3,X4) ) ).

cnf(i_0_2174,axiom,
    ( ~ esk8267_4(X1,X2,X3,X4)
    | esk8268_4(X1,X2,X3,X4)
    | ~ esk8266_4(X1,X2,X3,X4) ) ).

cnf(i_0_2175,axiom,
    ( esk6344_4(X1,X2,X3,X4)
    | ~ esk6340_4(X1,X2,X3,X4)
    | esk6339_4(X1,X2,X3,X4) ) ).

cnf(i_0_2176,axiom,
    ( esk108_0
    | p(X2)
    | ~ esk16687_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1)
    | p(X4) ) ).

cnf(i_0_2177,axiom,
    ( esk16648_4(X1,X2,X3,X4)
    | esk16668_4(X1,X2,X3,X4) ) ).

cnf(i_0_2178,axiom,
    ( ~ esk8287_4(X1,X2,X3,X4)
    | ~ esk8262_4(X1,X2,X3,X4)
    | ~ esk8261_4(X1,X2,X3,X4) ) ).

cnf(i_0_2179,axiom,
    ( ~ esk13821_4(X1,X2,X3,X4)
    | ~ esk13849_4(X1,X2,X3,X4)
    | ~ esk13934_4(X1,X2,X3,X4) ) ).

cnf(i_0_2180,axiom,
    ( esk14904_4(X1,X2,X3,X4)
    | ~ esk14835_4(X1,X2,X3,X4) ) ).

cnf(i_0_2181,axiom,
    ( ~ esk4496_4(X1,X2,X3,X4)
    | esk4548_4(X1,X2,X3,X4) ) ).

cnf(i_0_2182,axiom,
    ( esk10485_4(X1,X2,X3,X4)
    | esk10478_4(X1,X2,X3,X4) ) ).

cnf(i_0_2183,axiom,
    ( esk11278_4(X1,X2,X3,X4)
    | esk11311_4(X1,X2,X3,X4) ) ).

cnf(i_0_2184,axiom,
    ( ~ esk1227_4(X1,X2,X3,X4)
    | ~ esk1228_4(X1,X2,X3,X4) ) ).

cnf(i_0_2185,axiom,
    ( esk1420_4(X1,X2,X3,X4)
    | ~ esk1545_4(X1,X2,X3,X4)
    | ~ esk1433_4(X1,X2,X3,X4) ) ).

cnf(i_0_2186,axiom,
    ( ~ esk9644_4(X1,X2,X3,X4)
    | esk9657_4(X1,X2,X3,X4) ) ).

cnf(i_0_2187,axiom,
    ( ~ esk4357_4(X1,X2,X3,X4)
    | esk4615_4(X1,X2,X3,X4) ) ).

cnf(i_0_2188,axiom,
    ( esk11557_4(X1,X2,X3,X4)
    | ~ esk11815_4(X1,X2,X3,X4) ) ).

cnf(i_0_2189,axiom,
    ( ~ esk11225_4(X1,X2,X3,X4)
    | esk11224_4(X1,X2,X3,X4) ) ).

cnf(i_0_2190,axiom,
    ( esk4874_4(X1,X2,X3,X4)
    | esk4955_4(X1,X2,X3,X4) ) ).

cnf(i_0_2191,axiom,
    ( ~ esk1303_4(X1,X2,X3,X4)
    | esk1301_4(X1,X2,X3,X4) ) ).

cnf(i_0_2192,axiom,
    ( ~ esk12038_4(X1,X2,X3,X4)
    | ~ esk12123_4(X1,X2,X3,X4)
    | ~ esk12022_4(X1,X2,X3,X4) ) ).

cnf(i_0_2193,axiom,
    ( esk7928_4(X1,X2,X3,X4)
    | esk7899_4(X1,X2,X3,X4) ) ).

cnf(i_0_2194,axiom,
    ( ~ esk11703_4(X1,X2,X3,X4)
    | esk11801_4(X1,X2,X3,X4) ) ).

cnf(i_0_2195,axiom,
    ( esk2351_4(X1,X2,X3,X4)
    | esk2298_4(X1,X2,X3,X4) ) ).

cnf(i_0_2196,axiom,
    ( esk10801_4(X1,X2,X3,X4)
    | esk10816_4(X1,X2,X3,X4) ) ).

cnf(i_0_2197,axiom,
    ( esk14164_4(X1,X2,X3,X4)
    | esk14162_4(X1,X2,X3,X4) ) ).

cnf(i_0_2198,axiom,
    ( ~ esk12741_4(X1,X2,X3,X4)
    | esk12724_4(X1,X2,X3,X4)
    | ~ esk12845_4(X1,X2,X3,X4) ) ).

cnf(i_0_2199,axiom,
    ( ~ esk15662_4(X1,X2,X3,X4)
    | esk15404_4(X1,X2,X3,X4) ) ).

cnf(i_0_2200,axiom,
    ( esk3785_4(X1,X2,X3,X4)
    | ~ esk3851_4(X1,X2,X3,X4) ) ).

cnf(i_0_2201,axiom,
    ( esk6939_4(X1,X2,X3,X4)
    | ~ esk6867_4(X1,X2,X3,X4) ) ).

cnf(i_0_2202,axiom,
    ( esk2281_4(X1,X2,X3,X4)
    | esk2241_4(X1,X2,X3,X4) ) ).

cnf(i_0_2203,axiom,
    ( esk15947_4(X1,X2,X3,X4)
    | esk15856_4(X1,X2,X3,X4) ) ).

cnf(i_0_2204,axiom,
    ( esk5881_4(X1,X2,X3,X4)
    | esk5838_4(X1,X2,X3,X4) ) ).

cnf(i_0_2205,axiom,
    ( esk4695_4(X1,X2,X3,X4)
    | esk4581_4(X1,X2,X3,X4) ) ).

cnf(i_0_2206,axiom,
    ( esk460_4(X1,X2,X3,X4)
    | esk493_4(X1,X2,X3,X4) ) ).

cnf(i_0_2207,axiom,
    ( ~ esk12078_4(X1,X2,X3,X4)
    | esk11820_4(X1,X2,X3,X4) ) ).

cnf(i_0_2208,axiom,
    ( esk6282_4(X1,X2,X3,X4)
    | ~ esk6306_4(X1,X2,X3,X4) ) ).

cnf(i_0_2209,axiom,
    ( ~ esk197_0
    | ~ p(X4)
    | ~ p(X2)
    | ~ p(X1)
    | esk507_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_2210,axiom,
    ( ~ esk4840_4(X1,X2,X3,X4)
    | ~ esk4817_4(X1,X2,X3,X4)
    | ~ esk4839_4(X1,X2,X3,X4) ) ).

cnf(i_0_2211,axiom,
    ( ~ esk2887_4(X1,X2,X3,X4)
    | esk2886_4(X1,X2,X3,X4) ) ).

cnf(i_0_2212,axiom,
    ( ~ esk13871_4(X1,X2,X3,X4)
    | ~ esk13910_4(X1,X2,X3,X4) ) ).

cnf(i_0_2213,axiom,
    ( esk14104_4(X1,X2,X3,X4)
    | esk14078_4(X1,X2,X3,X4) ) ).

cnf(i_0_2214,axiom,
    ( esk4139_4(X1,X2,X3,X4)
    | esk4141_4(X1,X2,X3,X4) ) ).

cnf(i_0_2215,axiom,
    ( esk1353_4(X1,X2,X3,X4)
    | ~ esk1354_4(X1,X2,X3,X4) ) ).

cnf(i_0_2216,axiom,
    ( esk16097_4(X1,X2,X3,X4)
    | esk16095_4(X1,X2,X3,X4) ) ).

cnf(i_0_2217,axiom,
    ( ~ p(X4)
    | esk501_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ esk144_0
    | ~ p(X3)
    | p(X1) ) ).

cnf(i_0_2218,axiom,
    ( esk4344_4(X1,X2,X3,X4)
    | esk4294_4(X1,X2,X3,X4) ) ).

cnf(i_0_2219,axiom,
    ( ~ esk4055_4(X1,X2,X3,X4)
    | ~ esk4077_4(X1,X2,X3,X4)
    | ~ esk4162_4(X1,X2,X3,X4) ) ).

cnf(i_0_2220,axiom,
    ( esk8477_4(X1,X2,X3,X4)
    | ~ esk8735_4(X1,X2,X3,X4) ) ).

cnf(i_0_2221,axiom,
    ( esk14127_4(X1,X2,X3,X4)
    | ~ esk14067_4(X1,X2,X3,X4) ) ).

cnf(i_0_2222,axiom,
    ( ~ esk9195_4(X1,X2,X3,X4)
    | ~ esk9215_4(X1,X2,X3,X4)
    | ~ esk9301_4(X1,X2,X3,X4) ) ).

cnf(i_0_2223,axiom,
    ( esk14381_4(X1,X2,X3,X4)
    | ~ esk14263_4(X1,X2,X3,X4) ) ).

cnf(i_0_2224,axiom,
    ( ~ esk11835_4(X1,X2,X3,X4)
    | ~ esk11743_4(X1,X2,X3,X4) ) ).

cnf(i_0_2225,axiom,
    ( ~ esk7257_4(X1,X2,X3,X4)
    | ~ esk7141_4(X1,X2,X3,X4)
    | ~ esk7139_4(X1,X2,X3,X4) ) ).

cnf(i_0_2226,axiom,
    ( esk15494_4(X1,X2,X3,X4)
    | esk15371_4(X1,X2,X3,X4) ) ).

cnf(i_0_2227,axiom,
    ( ~ esk2513_4(X1,X2,X3,X4)
    | ~ esk2491_4(X1,X2,X3,X4) ) ).

cnf(i_0_2228,axiom,
    ( ~ esk11801_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4)
    | esk11703_4(X1,X2,X3,X4) ) ).

cnf(i_0_2229,axiom,
    ( esk12106_4(X1,X2,X3,X4)
    | esk12108_4(X1,X2,X3,X4) ) ).

cnf(i_0_2230,axiom,
    ( ~ esk6323_4(X1,X2,X3,X4)
    | esk6337_4(X1,X2,X3,X4) ) ).

cnf(i_0_2231,axiom,
    ( esk1715_4(X1,X2,X3,X4)
    | ~ esk1695_4(X1,X2,X3,X4) ) ).

cnf(i_0_2232,axiom,
    ( esk4820_4(X1,X2,X3,X4)
    | esk4834_4(X1,X2,X3,X4) ) ).

cnf(i_0_2233,axiom,
    ( esk4580_4(X1,X2,X3,X4)
    | esk4567_4(X1,X2,X3,X4) ) ).

cnf(i_0_2234,axiom,
    ( esk7853_4(X1,X2,X3,X4)
    | ~ esk7810_4(X1,X2,X3,X4) ) ).

cnf(i_0_2235,axiom,
    ( esk2547_4(X1,X2,X3,X4)
    | esk2514_4(X1,X2,X3,X4) ) ).

cnf(i_0_2236,axiom,
    ( esk11783_4(X1,X2,X3,X4)
    | esk11870_4(X1,X2,X3,X4) ) ).

cnf(i_0_2237,axiom,
    ( esk12833_4(X1,X2,X3,X4)
    | esk12800_4(X1,X2,X3,X4) ) ).

cnf(i_0_2238,axiom,
    ( ~ esk14947_4(X1,X2,X3,X4)
    | esk14948_4(X1,X2,X3,X4) ) ).

cnf(i_0_2239,axiom,
    ( ~ esk10078_4(X1,X2,X3,X4)
    | ~ esk10077_4(X1,X2,X3,X4)
    | esk10079_4(X1,X2,X3,X4) ) ).

cnf(i_0_2240,axiom,
    ( esk1817_4(X1,X2,X3,X4)
    | ~ esk1818_4(X1,X2,X3,X4) ) ).

cnf(i_0_2241,axiom,
    ( esk8277_4(X1,X2,X3,X4)
    | esk8249_4(X1,X2,X3,X4) ) ).

cnf(i_0_2242,axiom,
    ( ~ esk4278_4(X1,X2,X3,X4)
    | esk4277_4(X1,X2,X3,X4) ) ).

cnf(i_0_2243,axiom,
    ( ~ esk237_0
    | ~ p(X3)
    | ~ p(X1)
    | p(X4)
    | p(X2)
    | esk513_4(X1,X2,X3,X4) ) ).

cnf(i_0_2244,axiom,
    ( esk11508_4(X1,X2,X3,X4)
    | esk11540_4(X1,X2,X3,X4) ) ).

cnf(i_0_2245,axiom,
    ( ~ esk11863_4(X1,X2,X3,X4)
    | esk11864_4(X1,X2,X3,X4) ) ).

cnf(i_0_2246,axiom,
    ( esk5934_4(X1,X2,X3,X4)
    | ~ esk5954_4(X1,X2,X3,X4)
    | esk5983_4(X1,X2,X3,X4) ) ).

cnf(i_0_2247,axiom,
    ( esk16703_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ esk241_0
    | ~ p(X2)
    | p(X3)
    | ~ p(X4) ) ).

cnf(i_0_2248,axiom,
    ( ~ esk16419_4(X1,X2,X3,X4)
    | ~ esk16504_4(X1,X2,X3,X4)
    | ~ esk16391_4(X1,X2,X3,X4) ) ).

cnf(i_0_2249,axiom,
    ( esk5081_4(X1,X2,X3,X4)
    | esk5027_4(X1,X2,X3,X4)
    | esk5061_4(X1,X2,X3,X4) ) ).

cnf(i_0_2250,axiom,
    ( ~ esk13524_4(X1,X2,X3,X4)
    | ~ esk13526_4(X1,X2,X3,X4) ) ).

cnf(i_0_2251,axiom,
    ( ~ esk13047_4(X1,X2,X3,X4)
    | ~ esk13051_4(X1,X2,X3,X4)
    | ~ esk13052_4(X1,X2,X3,X4) ) ).

cnf(i_0_2252,axiom,
    ( esk14290_4(X1,X2,X3,X4)
    | ~ esk14032_4(X1,X2,X3,X4) ) ).

cnf(i_0_2253,axiom,
    ( esk11295_4(X1,X2,X3,X4)
    | ~ esk11193_4(X1,X2,X3,X4) ) ).

cnf(i_0_2254,axiom,
    ( ~ esk9049_4(X1,X2,X3,X4)
    | ~ esk9050_4(X1,X2,X3,X4)
    | esk9051_4(X1,X2,X3,X4) ) ).

cnf(i_0_2255,axiom,
    ( esk12020_4(X1,X2,X3,X4)
    | esk12029_4(X1,X2,X3,X4) ) ).

cnf(i_0_2256,axiom,
    ( ~ esk5530_4(X1,X2,X3,X4)
    | esk5545_4(X1,X2,X3,X4) ) ).

cnf(i_0_2257,axiom,
    ( esk11948_4(X1,X2,X3,X4)
    | ~ esk11968_4(X1,X2,X3,X4) ) ).

cnf(i_0_2258,axiom,
    ( ~ esk13901_4(X1,X2,X3,X4)
    | ~ esk13909_4(X1,X2,X3,X4) ) ).

cnf(i_0_2259,axiom,
    ( esk15633_4(X1,X2,X3,X4)
    | esk15611_4(X1,X2,X3,X4) ) ).

cnf(i_0_2260,axiom,
    ( esk5580_4(X1,X2,X3,X4)
    | esk5626_4(X1,X2,X3,X4) ) ).

cnf(i_0_2261,axiom,
    ( esk1819_4(X1,X2,X3,X4)
    | ~ esk1561_4(X1,X2,X3,X4) ) ).

cnf(i_0_2262,axiom,
    ( ~ esk2703_4(X1,X2,X3,X4)
    | esk2718_4(X1,X2,X3,X4) ) ).

cnf(i_0_2263,axiom,
    ( ~ esk9148_4(X1,X2,X3,X4)
    | ~ esk9166_4(X1,X2,X3,X4) ) ).

cnf(i_0_2264,axiom,
    ( esk12998_4(X1,X2,X3,X4)
    | ~ esk12974_4(X1,X2,X3,X4)
    | ~ esk13001_4(X1,X2,X3,X4) ) ).

cnf(i_0_2265,axiom,
    ( ~ esk14017_4(X1,X2,X3,X4)
    | esk14116_4(X1,X2,X3,X4) ) ).

cnf(i_0_2266,axiom,
    ( esk1593_4(X1,X2,X3,X4)
    | ~ esk1541_4(X1,X2,X3,X4)
    | esk1612_4(X1,X2,X3,X4) ) ).

cnf(i_0_2267,axiom,
    ( esk7081_4(X1,X2,X3,X4)
    | ~ esk7049_4(X1,X2,X3,X4) ) ).

cnf(i_0_2268,axiom,
    ( esk9230_4(X1,X2,X3,X4)
    | ~ esk9488_4(X1,X2,X3,X4) ) ).

cnf(i_0_2269,axiom,
    ( esk8609_4(X1,X2,X3,X4)
    | ~ esk8629_4(X1,X2,X3,X4)
    | ~ esk8727_4(X1,X2,X3,X4) ) ).

cnf(i_0_2270,axiom,
    ( esk10573_4(X1,X2,X3,X4)
    | esk10572_4(X1,X2,X3,X4)
    | esk10571_4(X1,X2,X3,X4) ) ).

cnf(i_0_2271,axiom,
    ( esk15413_4(X1,X2,X3,X4)
    | ~ esk15293_4(X1,X2,X3,X4) ) ).

cnf(i_0_2272,axiom,
    ( esk11026_4(X1,X2,X3,X4)
    | esk11073_4(X1,X2,X3,X4) ) ).

cnf(i_0_2273,axiom,
    ( ~ esk5026_4(X1,X2,X3,X4)
    | esk4983_4(X1,X2,X3,X4) ) ).

cnf(i_0_2274,axiom,
    ( ~ esk5787_4(X1,X2,X3,X4)
    | esk5910_4(X1,X2,X3,X4) ) ).

cnf(i_0_2275,axiom,
    ( esk2274_4(X1,X2,X3,X4)
    | esk2361_4(X1,X2,X3,X4) ) ).

cnf(i_0_2276,axiom,
    ( esk14691_4(X1,X2,X3,X4)
    | ~ esk14640_4(X1,X2,X3,X4) ) ).

cnf(i_0_2277,axiom,
    ( ~ esk4935_4(X1,X2,X3,X4)
    | ~ esk4852_4(X1,X2,X3,X4)
    | ~ esk4826_4(X1,X2,X3,X4) ) ).

cnf(i_0_2278,axiom,
    ( esk15825_4(X1,X2,X3,X4)
    | ~ esk15812_4(X1,X2,X3,X4) ) ).

cnf(i_0_2279,axiom,
    ( esk3573_4(X1,X2,X3,X4)
    | esk3523_4(X1,X2,X3,X4) ) ).

cnf(i_0_2280,axiom,
    ( ~ esk5083_4(X1,X2,X3,X4)
    | ~ esk5180_4(X1,X2,X3,X4)
    | ~ esk5097_4(X1,X2,X3,X4) ) ).

cnf(i_0_2281,axiom,
    ( esk10524_4(X1,X2,X3,X4)
    | esk10491_4(X1,X2,X3,X4) ) ).

cnf(i_0_2282,axiom,
    ( ~ esk11321_4(X1,X2,X3,X4)
    | esk11317_4(X1,X2,X3,X4) ) ).

cnf(i_0_2283,axiom,
    ( esk14547_4(X1,X2,X3,X4)
    | ~ esk14289_4(X1,X2,X3,X4) ) ).

cnf(i_0_2284,axiom,
    ( esk8373_4(X1,X2,X3,X4)
    | esk8323_4(X1,X2,X3,X4) ) ).

cnf(i_0_2285,axiom,
    ( ~ esk3108_4(X1,X2,X3,X4)
    | ~ esk3061_4(X1,X2,X3,X4)
    | ~ esk3145_4(X1,X2,X3,X4) ) ).

cnf(i_0_2286,axiom,
    ( esk12315_4(X1,X2,X3,X4)
    | esk12282_4(X1,X2,X3,X4) ) ).

cnf(i_0_2287,axiom,
    ( esk15603_4(X1,X2,X3,X4)
    | esk15649_4(X1,X2,X3,X4) ) ).

cnf(i_0_2288,axiom,
    ( ~ esk50_0
    | ~ p(X3)
    | p(X1)
    | ~ p(X4)
    | esk433_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_2289,axiom,
    ( esk12241_4(X1,X2,X3,X4)
    | esk12255_4(X1,X2,X3,X4) ) ).

cnf(i_0_2290,axiom,
    ( ~ esk16682_4(X1,X2,X3,X4)
    | ~ esk16729_4(X1,X2,X3,X4)
    | ~ esk16766_4(X1,X2,X3,X4) ) ).

cnf(i_0_2291,axiom,
    ( ~ esk16383_4(X1,X2,X3,X4)
    | ~ esk16403_4(X1,X2,X3,X4)
    | ~ esk16402_4(X1,X2,X3,X4) ) ).

cnf(i_0_2292,axiom,
    ( ~ esk3919_4(X1,X2,X3,X4)
    | esk3926_4(X1,X2,X3,X4)
    | esk3838_4(X1,X2,X3,X4) ) ).

cnf(i_0_2293,axiom,
    ( ~ esk11552_4(X1,X2,X3,X4)
    | esk11294_4(X1,X2,X3,X4) ) ).

cnf(i_0_2294,axiom,
    ( esk6112_4(X1,X2,X3,X4)
    | esk6109_4(X1,X2,X3,X4) ) ).

cnf(i_0_2295,axiom,
    ( ~ esk15155_4(X1,X2,X3,X4)
    | esk15095_4(X1,X2,X3,X4) ) ).

cnf(i_0_2296,axiom,
    ( ~ esk4746_4(X1,X2,X3,X4)
    | ~ esk4776_4(X1,X2,X3,X4) ) ).

cnf(i_0_2297,axiom,
    ( ~ esk841_4(X1,X2,X3,X4)
    | esk822_4(X1,X2,X3,X4)
    | esk770_4(X1,X2,X3,X4) ) ).

cnf(i_0_2298,axiom,
    ( esk7452_4(X1,X2,X3,X4)
    | esk7482_4(X1,X2,X3,X4) ) ).

cnf(i_0_2299,axiom,
    ( ~ esk9623_4(X1,X2,X3,X4)
    | esk9647_4(X1,X2,X3,X4) ) ).

cnf(i_0_2300,axiom,
    ( esk2528_4(X1,X2,X3,X4)
    | esk2503_4(X1,X2,X3,X4) ) ).

cnf(i_0_2301,axiom,
    ( esk5600_4(X1,X2,X3,X4)
    | esk5593_4(X1,X2,X3,X4) ) ).

cnf(i_0_2302,axiom,
    ( esk1399_4(X1,X2,X3,X4)
    | ~ esk1423_4(X1,X2,X3,X4) ) ).

cnf(i_0_2303,axiom,
    ( esk5661_4(X1,X2,X3,X4)
    | esk5628_4(X1,X2,X3,X4) ) ).

cnf(i_0_2304,axiom,
    ( esk9568_4(X1,X2,X3,X4)
    | ~ esk9514_4(X1,X2,X3,X4) ) ).

cnf(i_0_2305,axiom,
    ( ~ esk7992_4(X1,X2,X3,X4)
    | esk8022_4(X1,X2,X3,X4) ) ).

cnf(i_0_2306,axiom,
    ( esk11857_4(X1,X2,X3,X4)
    | esk11809_4(X1,X2,X3,X4) ) ).

cnf(i_0_2307,axiom,
    ( esk3503_4(X1,X2,X3,X4)
    | esk3502_4(X1,X2,X3,X4)
    | esk3497_4(X1,X2,X3,X4) ) ).

cnf(i_0_2308,axiom,
    ( ~ esk10666_4(X1,X2,X3,X4)
    | esk10645_4(X1,X2,X3,X4) ) ).

cnf(i_0_2309,axiom,
    ( ~ esk10971_4(X1,X2,X3,X4)
    | ~ esk10970_4(X1,X2,X3,X4) ) ).

cnf(i_0_2310,axiom,
    ( esk13297_4(X1,X2,X3,X4)
    | esk13323_4(X1,X2,X3,X4) ) ).

cnf(i_0_2311,axiom,
    ( esk6155_4(X1,X2,X3,X4)
    | esk6203_4(X1,X2,X3,X4) ) ).

cnf(i_0_2312,axiom,
    ( esk8027_4(X1,X2,X3,X4)
    | esk7940_4(X1,X2,X3,X4) ) ).

cnf(i_0_2313,axiom,
    ( ~ esk5783_4(X1,X2,X3,X4)
    | esk5802_4(X1,X2,X3,X4) ) ).

cnf(i_0_2314,axiom,
    ( esk4609_4(X1,X2,X3,X4)
    | esk4576_4(X1,X2,X3,X4) ) ).

cnf(i_0_2315,axiom,
    ( esk2090_4(X1,X2,X3,X4)
    | esk2122_4(X1,X2,X3,X4) ) ).

cnf(i_0_2316,axiom,
    ( esk9824_4(X1,X2,X3,X4)
    | ~ esk9826_4(X1,X2,X3,X4) ) ).

cnf(i_0_2317,axiom,
    ( esk13255_4(X1,X2,X3,X4)
    | ~ esk13235_4(X1,X2,X3,X4) ) ).

cnf(i_0_2318,axiom,
    ( esk8735_4(X1,X2,X3,X4)
    | ~ esk8613_4(X1,X2,X3,X4) ) ).

cnf(i_0_2319,axiom,
    ( esk3825_4(X1,X2,X3,X4)
    | esk3796_4(X1,X2,X3,X4) ) ).

cnf(i_0_2320,axiom,
    ( esk15925_4(X1,X2,X3,X4)
    | esk15975_4(X1,X2,X3,X4)
    | ~ esk15976_4(X1,X2,X3,X4) ) ).

cnf(i_0_2321,axiom,
    ( ~ esk10021_4(X1,X2,X3,X4)
    | esk10279_4(X1,X2,X3,X4) ) ).

cnf(i_0_2322,axiom,
    ( ~ esk9665_4(X1,X2,X3,X4)
    | ~ esk9669_4(X1,X2,X3,X4) ) ).

cnf(i_0_2323,axiom,
    ( ~ esk13669_4(X1,X2,X3,X4)
    | esk13667_4(X1,X2,X3,X4) ) ).

cnf(i_0_2324,axiom,
    ( esk446_4(X1,X2,X3,X4)
    | esk475_4(X1,X2,X3,X4) ) ).

cnf(i_0_2325,axiom,
    ( ~ esk16204_4(X1,X2,X3,X4)
    | esk16200_4(X1,X2,X3,X4) ) ).

cnf(i_0_2326,axiom,
    ( ~ esk11458_4(X1,X2,X3,X4)
    | ~ esk11430_4(X1,X2,X3,X4) ) ).

cnf(i_0_2327,axiom,
    ( esk11228_4(X1,X2,X3,X4)
    | ~ esk11224_4(X1,X2,X3,X4)
    | esk11204_4(X1,X2,X3,X4) ) ).

cnf(i_0_2328,axiom,
    ( ~ esk2287_4(X1,X2,X3,X4)
    | ~ esk2254_4(X1,X2,X3,X4)
    | ~ esk2320_4(X1,X2,X3,X4) ) ).

cnf(i_0_2329,axiom,
    ( ~ esk5287_4(X1,X2,X3,X4)
    | esk5407_4(X1,X2,X3,X4) ) ).

cnf(i_0_2330,axiom,
    ( ~ esk1353_4(X1,X2,X3,X4)
    | esk1354_4(X1,X2,X3,X4)
    | ~ esk1352_4(X1,X2,X3,X4) ) ).

cnf(i_0_2331,axiom,
    ( ~ esk5648_4(X1,X2,X3,X4)
    | esk5585_4(X1,X2,X3,X4) ) ).

cnf(i_0_2332,axiom,
    ( ~ esk2750_4(X1,X2,X3,X4)
    | esk2714_4(X1,X2,X3,X4)
    | ~ esk2730_4(X1,X2,X3,X4) ) ).

cnf(i_0_2333,axiom,
    ( esk11977_4(X1,X2,X3,X4)
    | ~ esk11719_4(X1,X2,X3,X4) ) ).

cnf(i_0_2334,axiom,
    ( esk6711_4(X1,X2,X3,X4)
    | esk6681_4(X1,X2,X3,X4) ) ).

cnf(i_0_2335,axiom,
    ( ~ esk5677_4(X1,X2,X3,X4)
    | ~ esk5686_4(X1,X2,X3,X4) ) ).

cnf(i_0_2336,axiom,
    ( esk8531_4(X1,X2,X3,X4)
    | esk8446_4(X1,X2,X3,X4) ) ).

cnf(i_0_2337,axiom,
    ( esk5177_4(X1,X2,X3,X4)
    | esk5203_4(X1,X2,X3,X4)
    | ~ esk5178_4(X1,X2,X3,X4) ) ).

cnf(i_0_2338,axiom,
    ( esk11199_4(X1,X2,X3,X4)
    | ~ esk11184_4(X1,X2,X3,X4) ) ).

cnf(i_0_2339,axiom,
    ( esk8531_4(X1,X2,X3,X4)
    | ~ esk8509_4(X1,X2,X3,X4)
    | esk8510_4(X1,X2,X3,X4) ) ).

cnf(i_0_2340,axiom,
    ( esk13137_4(X1,X2,X3,X4)
    | esk13135_4(X1,X2,X3,X4)
    | esk13136_4(X1,X2,X3,X4) ) ).

cnf(i_0_2341,axiom,
    ( ~ esk4291_4(X1,X2,X3,X4)
    | esk4239_4(X1,X2,X3,X4) ) ).

cnf(i_0_2342,axiom,
    ( esk11796_4(X1,X2,X3,X4)
    | esk11763_4(X1,X2,X3,X4) ) ).

cnf(i_0_2343,axiom,
    ( esk13177_4(X1,X2,X3,X4)
    | ~ esk13106_4(X1,X2,X3,X4)
    | esk13158_4(X1,X2,X3,X4) ) ).

cnf(i_0_2344,axiom,
    ( ~ esk16777_4(X1,X2,X3,X4)
    | ~ esk16696_4(X1,X2,X3,X4) ) ).

cnf(i_0_2345,axiom,
    ( esk6878_4(X1,X2,X3,X4)
    | esk6886_4(X1,X2,X3,X4) ) ).

cnf(i_0_2346,axiom,
    ( esk8729_4(X1,X2,X3,X4)
    | ~ esk8471_4(X1,X2,X3,X4) ) ).

cnf(i_0_2347,axiom,
    ( esk1272_4(X1,X2,X3,X4)
    | esk1319_4(X1,X2,X3,X4)
    | ~ esk1353_4(X1,X2,X3,X4) ) ).

cnf(i_0_2348,axiom,
    ( esk10927_4(X1,X2,X3,X4)
    | ~ esk10898_4(X1,X2,X3,X4) ) ).

cnf(i_0_2349,axiom,
    ( esk8204_4(X1,X2,X3,X4)
    | ~ esk8162_4(X1,X2,X3,X4) ) ).

cnf(i_0_2350,axiom,
    ( ~ esk14172_4(X1,X2,X3,X4)
    | ~ esk14198_4(X1,X2,X3,X4)
    | ~ esk14173_4(X1,X2,X3,X4) ) ).

cnf(i_0_2351,axiom,
    ( ~ esk14539_4(X1,X2,X3,X4)
    | esk14666_4(X1,X2,X3,X4) ) ).

cnf(i_0_2352,axiom,
    ( ~ esk9806_4(X1,X2,X3,X4)
    | ~ esk9799_4(X1,X2,X3,X4)
    | ~ esk9755_4(X1,X2,X3,X4) ) ).

cnf(i_0_2353,axiom,
    ( esk6424_4(X1,X2,X3,X4)
    | esk6495_4(X1,X2,X3,X4)
    | ~ esk6476_4(X1,X2,X3,X4) ) ).

cnf(i_0_2354,axiom,
    ( ~ esk11832_4(X1,X2,X3,X4)
    | esk11712_4(X1,X2,X3,X4)
    | esk11681_4(X1,X2,X3,X4) ) ).

cnf(i_0_2355,axiom,
    ( ~ esk7097_4(X1,X2,X3,X4)
    | ~ esk7098_4(X1,X2,X3,X4) ) ).

cnf(i_0_2356,axiom,
    ( esk4183_4(X1,X2,X3,X4)
    | esk4148_4(X1,X2,X3,X4) ) ).

cnf(i_0_2357,axiom,
    ( esk497_4(X1,X2,X3,X4)
    | ~ esk397_4(X1,X2,X3,X4) ) ).

cnf(i_0_2358,axiom,
    ( esk8373_4(X1,X2,X3,X4)
    | esk8375_4(X1,X2,X3,X4) ) ).

cnf(i_0_2359,axiom,
    ( esk4344_4(X1,X2,X3,X4)
    | esk4391_4(X1,X2,X3,X4) ) ).

cnf(i_0_2360,axiom,
    ( ~ esk15065_4(X1,X2,X3,X4)
    | ~ esk15064_4(X1,X2,X3,X4) ) ).

cnf(i_0_2361,axiom,
    ( ~ esk6109_4(X1,X2,X3,X4)
    | ~ esk6089_4(X1,X2,X3,X4) ) ).

cnf(i_0_2362,axiom,
    ( ~ esk5452_4(X1,X2,X3,X4)
    | ~ esk5451_4(X1,X2,X3,X4)
    | esk5453_4(X1,X2,X3,X4) ) ).

cnf(i_0_2363,axiom,
    ( esk7817_4(X1,X2,X3,X4)
    | ~ esk7840_4(X1,X2,X3,X4) ) ).

cnf(i_0_2364,axiom,
    ( ~ esk15702_4(X1,X2,X3,X4)
    | ~ esk15684_4(X1,X2,X3,X4)
    | ~ esk15682_4(X1,X2,X3,X4) ) ).

cnf(i_0_2365,axiom,
    ( esk16162_4(X1,X2,X3,X4)
    | esk16247_4(X1,X2,X3,X4) ) ).

cnf(i_0_2366,axiom,
    ( esk15154_4(X1,X2,X3,X4)
    | esk15235_4(X1,X2,X3,X4) ) ).

cnf(i_0_2367,axiom,
    ( esk11695_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4)
    | ~ esk11815_4(X1,X2,X3,X4) ) ).

cnf(i_0_2368,axiom,
    ( p(X1)
    | ~ p(X3)
    | ~ p(X4)
    | ~ esk66_0
    | p(X2)
    | esk16681_4(X1,X2,X3,X4) ) ).

cnf(i_0_2369,axiom,
    ( esk9707_4(X1,X2,X3,X4)
    | esk9720_4(X1,X2,X3,X4) ) ).

cnf(i_0_2370,axiom,
    ( esk11724_4(X1,X2,X3,X4)
    | esk11723_4(X1,X2,X3,X4) ) ).

cnf(i_0_2371,axiom,
    ( esk6093_4(X1,X2,X3,X4)
    | ~ esk6174_4(X1,X2,X3,X4) ) ).

cnf(i_0_2372,axiom,
    ( esk16623_4(X1,X2,X3,X4)
    | ~ esk16625_4(X1,X2,X3,X4) ) ).

cnf(i_0_2373,axiom,
    ( esk2806_4(X1,X2,X3,X4)
    | ~ esk2851_4(X1,X2,X3,X4) ) ).

cnf(i_0_2374,axiom,
    ( ~ esk5417_4(X1,X2,X3,X4)
    | ~ esk5418_4(X1,X2,X3,X4) ) ).

cnf(i_0_2375,axiom,
    ( esk10427_4(X1,X2,X3,X4)
    | esk10396_4(X1,X2,X3,X4)
    | ~ esk10547_4(X1,X2,X3,X4) ) ).

cnf(i_0_2376,axiom,
    ( esk455_4(X1,X2,X3,X4)
    | esk401_4(X1,X2,X3,X4)
    | esk435_4(X1,X2,X3,X4) ) ).

cnf(i_0_2377,axiom,
    ( ~ esk2732_4(X1,X2,X3,X4)
    | ~ esk2737_4(X1,X2,X3,X4) ) ).

cnf(i_0_2378,axiom,
    ( ~ esk12232_4(X1,X2,X3,X4)
    | esk11974_4(X1,X2,X3,X4) ) ).

cnf(i_0_2379,axiom,
    ( esk15690_4(X1,X2,X3,X4)
    | ~ esk15432_4(X1,X2,X3,X4) ) ).

cnf(i_0_2380,axiom,
    ( esk1776_4(X1,X2,X3,X4)
    | ~ esk1860_4(X1,X2,X3,X4)
    | esk1823_4(X1,X2,X3,X4) ) ).

cnf(i_0_2381,axiom,
    ( esk4688_4(X1,X2,X3,X4)
    | ~ esk4665_4(X1,X2,X3,X4)
    | esk4605_4(X1,X2,X3,X4) ) ).

cnf(i_0_2382,axiom,
    ( esk10791_4(X1,X2,X3,X4)
    | ~ esk10533_4(X1,X2,X3,X4) ) ).

cnf(i_0_2383,axiom,
    ( esk16132_4(X1,X2,X3,X4)
    | esk16155_4(X1,X2,X3,X4) ) ).

cnf(i_0_2384,axiom,
    ( esk8954_4(X1,X2,X3,X4)
    | esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_2385,axiom,
    ( ~ esk10851_4(X1,X2,X3,X4)
    | ~ esk10799_4(X1,X2,X3,X4) ) ).

cnf(i_0_2386,axiom,
    ( ~ esk10587_4(X1,X2,X3,X4)
    | ~ esk10566_4(X1,X2,X3,X4)
    | ~ esk10565_4(X1,X2,X3,X4) ) ).

cnf(i_0_2387,axiom,
    ( ~ esk7939_4(X1,X2,X3,X4)
    | ~ esk7972_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_2388,axiom,
    ( ~ esk6611_4(X1,X2,X3,X4)
    | esk6680_4(X1,X2,X3,X4) ) ).

cnf(i_0_2389,axiom,
    ( esk4333_4(X1,X2,X3,X4)
    | esk4366_4(X1,X2,X3,X4) ) ).

cnf(i_0_2390,axiom,
    ( esk11276_4(X1,X2,X3,X4)
    | esk11249_4(X1,X2,X3,X4) ) ).

cnf(i_0_2391,axiom,
    ( esk12849_4(X1,X2,X3,X4)
    | esk12879_4(X1,X2,X3,X4) ) ).

cnf(i_0_2392,axiom,
    ( ~ esk6059_4(X1,X2,X3,X4)
    | esk6042_4(X1,X2,X3,X4)
    | ~ esk6163_4(X1,X2,X3,X4) ) ).

cnf(i_0_2393,axiom,
    ( esk3379_4(X1,X2,X3,X4)
    | esk3377_4(X1,X2,X3,X4) ) ).

cnf(i_0_2394,axiom,
    ( ~ esk5070_4(X1,X2,X3,X4)
    | esk5136_4(X1,X2,X3,X4) ) ).

cnf(i_0_2395,axiom,
    ( ~ esk13587_4(X1,X2,X3,X4)
    | ~ esk13620_4(X1,X2,X3,X4)
    | ~ esk13562_4(X1,X2,X3,X4) ) ).

cnf(i_0_2396,axiom,
    ( ~ esk5894_4(X1,X2,X3,X4)
    | esk5982_4(X1,X2,X3,X4)
    | esk5975_4(X1,X2,X3,X4) ) ).

cnf(i_0_2397,axiom,
    ( ~ esk10166_4(X1,X2,X3,X4)
    | esk10171_4(X1,X2,X3,X4) ) ).

cnf(i_0_2398,axiom,
    ( esk11718_4(X1,X2,X3,X4)
    | ~ esk11460_4(X1,X2,X3,X4) ) ).

cnf(i_0_2399,axiom,
    ( esk5659_4(X1,X2,X3,X4)
    | esk5679_4(X1,X2,X3,X4) ) ).

cnf(i_0_2400,axiom,
    ( esk8693_4(X1,X2,X3,X4)
    | esk8673_4(X1,X2,X3,X4) ) ).

cnf(i_0_2401,axiom,
    ( esk750_4(X1,X2,X3,X4)
    | esk833_4(X1,X2,X3,X4)
    | ~ esk810_4(X1,X2,X3,X4) ) ).

cnf(i_0_2402,axiom,
    ( esk10057_4(X1,X2,X3,X4)
    | esk10056_4(X1,X2,X3,X4) ) ).

cnf(i_0_2403,axiom,
    ( esk1502_4(X1,X2,X3,X4)
    | esk1474_4(X1,X2,X3,X4) ) ).

cnf(i_0_2404,axiom,
    ( esk3545_4(X1,X2,X3,X4)
    | esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_2405,axiom,
    ( p(X2)
    | esk179_0
    | ~ esk16695_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_2406,axiom,
    ( esk3629_4(X1,X2,X3,X4)
    | esk3628_4(X1,X2,X3,X4) ) ).

cnf(i_0_2407,axiom,
    ( ~ esk13832_4(X1,X2,X3,X4)
    | ~ esk13819_4(X1,X2,X3,X4)
    | ~ esk13865_4(X1,X2,X3,X4) ) ).

cnf(i_0_2408,axiom,
    ( ~ esk6058_4(X1,X2,X3,X4)
    | esk6185_4(X1,X2,X3,X4) ) ).

cnf(i_0_2409,axiom,
    ( ~ esk11551_4(X1,X2,X3,X4)
    | esk11500_4(X1,X2,X3,X4) ) ).

cnf(i_0_2410,axiom,
    ( ~ esk15375_4(X1,X2,X3,X4)
    | ~ esk15489_4(X1,X2,X3,X4)
    | ~ esk15363_4(X1,X2,X3,X4) ) ).

cnf(i_0_2411,axiom,
    ( ~ esk12022_4(X1,X2,X3,X4)
    | ~ esk12034_4(X1,X2,X3,X4)
    | ~ esk12148_4(X1,X2,X3,X4) ) ).

cnf(i_0_2412,axiom,
    ( esk11733_4(X1,X2,X3,X4)
    | ~ esk11735_4(X1,X2,X3,X4) ) ).

cnf(i_0_2413,axiom,
    ( esk16195_4(X1,X2,X3,X4)
    | ~ esk16453_4(X1,X2,X3,X4) ) ).

cnf(i_0_2414,axiom,
    ( ~ esk16493_4(X1,X2,X3,X4)
    | ~ esk16479_4(X1,X2,X3,X4) ) ).

cnf(i_0_2415,axiom,
    ( esk16325_4(X1,X2,X3,X4)
    | ~ esk16449_4(X1,X2,X3,X4)
    | ~ esk16339_4(X1,X2,X3,X4) ) ).

cnf(i_0_2416,axiom,
    ( esk1252_4(X1,X2,X3,X4)
    | esk1358_4(X1,X2,X3,X4) ) ).

cnf(i_0_2417,axiom,
    ( esk15445_4(X1,X2,X3,X4)
    | esk15427_4(X1,X2,X3,X4) ) ).

cnf(i_0_2418,axiom,
    ( ~ esk7880_4(X1,X2,X3,X4)
    | esk7879_4(X1,X2,X3,X4) ) ).

cnf(i_0_2419,axiom,
    ( esk2073_4(X1,X2,X3,X4)
    | ~ esk2074_4(X1,X2,X3,X4) ) ).

cnf(i_0_2420,axiom,
    ( esk985_4(X1,X2,X3,X4)
    | esk1068_4(X1,X2,X3,X4) ) ).

cnf(i_0_2421,axiom,
    ( esk1960_4(X1,X2,X3,X4)
    | esk1958_4(X1,X2,X3,X4)
    | ~ esk1964_4(X1,X2,X3,X4) ) ).

cnf(i_0_2422,axiom,
    ( ~ esk2203_4(X1,X2,X3,X4)
    | ~ esk2180_4(X1,X2,X3,X4) ) ).

cnf(i_0_2423,axiom,
    ( ~ esk14758_4(X1,X2,X3,X4)
    | esk14777_4(X1,X2,X3,X4) ) ).

cnf(i_0_2424,axiom,
    ( ~ esk12152_4(X1,X2,X3,X4)
    | ~ esk12022_4(X1,X2,X3,X4)
    | ~ esk12046_4(X1,X2,X3,X4) ) ).

cnf(i_0_2425,axiom,
    ( ~ esk5904_4(X1,X2,X3,X4)
    | esk5958_4(X1,X2,X3,X4) ) ).

cnf(i_0_2426,axiom,
    ( esk16474_4(X1,X2,X3,X4)
    | esk16451_4(X1,X2,X3,X4) ) ).

cnf(i_0_2427,axiom,
    ( esk5342_4(X1,X2,X3,X4)
    | esk5340_4(X1,X2,X3,X4) ) ).

cnf(i_0_2428,axiom,
    ( esk4310_4(X1,X2,X3,X4)
    | esk4315_4(X1,X2,X3,X4) ) ).

cnf(i_0_2429,axiom,
    ( ~ esk11339_4(X1,X2,X3,X4)
    | ~ esk11338_4(X1,X2,X3,X4)
    | ~ esk11303_4(X1,X2,X3,X4) ) ).

cnf(i_0_2430,axiom,
    ( ~ esk1179_4(X1,X2,X3,X4)
    | ~ esk1152_4(X1,X2,X3,X4)
    | esk1176_4(X1,X2,X3,X4) ) ).

cnf(i_0_2431,axiom,
    ( ~ esk2455_4(X1,X2,X3,X4)
    | esk2423_4(X1,X2,X3,X4) ) ).

cnf(i_0_2432,axiom,
    ( esk2306_4(X1,X2,X3,X4)
    | ~ esk2048_4(X1,X2,X3,X4) ) ).

cnf(i_0_2433,axiom,
    ( esk2047_4(X1,X2,X3,X4)
    | esk2014_4(X1,X2,X3,X4) ) ).

cnf(i_0_2434,axiom,
    ( ~ esk16738_4(X1,X2,X3,X4)
    | ~ esk16694_4(X1,X2,X3,X4)
    | ~ esk16739_4(X1,X2,X3,X4) ) ).

cnf(i_0_2435,axiom,
    ( esk4480_4(X1,X2,X3,X4)
    | ~ esk4510_4(X1,X2,X3,X4) ) ).

cnf(i_0_2436,axiom,
    ( esk10472_4(X1,X2,X3,X4)
    | esk10491_4(X1,X2,X3,X4) ) ).

cnf(i_0_2437,axiom,
    ( ~ esk6087_4(X1,X2,X3,X4)
    | ~ esk6073_4(X1,X2,X3,X4)
    | ~ esk6064_4(X1,X2,X3,X4) ) ).

cnf(i_0_2438,axiom,
    ( ~ esk8213_4(X1,X2,X3,X4)
    | esk8264_4(X1,X2,X3,X4)
    | esk8257_4(X1,X2,X3,X4) ) ).

cnf(i_0_2439,axiom,
    ( esk8940_4(X1,X2,X3,X4)
    | esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_2440,axiom,
    ( esk5351_4(X1,X2,X3,X4)
    | esk5384_4(X1,X2,X3,X4) ) ).

cnf(i_0_2441,axiom,
    ( ~ esk15590_4(X1,X2,X3,X4)
    | esk15588_4(X1,X2,X3,X4) ) ).

cnf(i_0_2442,axiom,
    ( esk6322_4(X1,X2,X3,X4)
    | ~ esk6580_4(X1,X2,X3,X4) ) ).

cnf(i_0_2443,axiom,
    ( esk3051_4(X1,X2,X3,X4)
    | esk3013_4(X1,X2,X3,X4) ) ).

cnf(i_0_2444,axiom,
    ( ~ esk6162_4(X1,X2,X3,X4)
    | esk6420_4(X1,X2,X3,X4) ) ).

cnf(i_0_2445,axiom,
    ( esk4059_4(X1,X2,X3,X4)
    | esk4174_4(X1,X2,X3,X4) ) ).

cnf(i_0_2446,axiom,
    ( ~ esk9362_4(X1,X2,X3,X4)
    | esk9394_4(X1,X2,X3,X4) ) ).

cnf(i_0_2447,axiom,
    ( ~ esk13651_4(X1,X2,X3,X4)
    | ~ esk13616_4(X1,X2,X3,X4)
    | ~ esk13652_4(X1,X2,X3,X4) ) ).

cnf(i_0_2448,axiom,
    ( esk2097_4(X1,X2,X3,X4)
    | ~ esk2098_4(X1,X2,X3,X4)
    | esk2047_4(X1,X2,X3,X4) ) ).

cnf(i_0_2449,axiom,
    ( ~ esk11344_4(X1,X2,X3,X4)
    | esk11373_4(X1,X2,X3,X4)
    | esk11293_4(X1,X2,X3,X4) ) ).

cnf(i_0_2450,axiom,
    ( esk13864_4(X1,X2,X3,X4)
    | ~ esk13813_4(X1,X2,X3,X4) ) ).

cnf(i_0_2451,axiom,
    ( ~ esk15095_4(X1,X2,X3,X4)
    | esk15155_4(X1,X2,X3,X4) ) ).

cnf(i_0_2452,axiom,
    ( ~ esk6042_4(X1,X2,X3,X4)
    | esk6059_4(X1,X2,X3,X4) ) ).

cnf(i_0_2453,axiom,
    ( esk16658_4(X1,X2,X3,X4)
    | esk16770_4(X1,X2,X3,X4) ) ).

cnf(i_0_2454,axiom,
    ( ~ esk13031_4(X1,X2,X3,X4)
    | ~ esk13030_4(X1,X2,X3,X4) ) ).

cnf(i_0_2455,axiom,
    ( ~ esk15830_4(X1,X2,X3,X4)
    | esk15572_4(X1,X2,X3,X4) ) ).

cnf(i_0_2456,axiom,
    ( ~ esk12878_4(X1,X2,X3,X4)
    | ~ esk12900_4(X1,X2,X3,X4)
    | ~ esk12879_4(X1,X2,X3,X4) ) ).

cnf(i_0_2457,axiom,
    ( ~ esk1041_4(X1,X2,X3,X4)
    | esk1037_4(X1,X2,X3,X4) ) ).

cnf(i_0_2458,axiom,
    ( esk9007_4(X1,X2,X3,X4)
    | ~ esk9006_4(X1,X2,X3,X4) ) ).

cnf(i_0_2459,axiom,
    ( esk15110_4(X1,X2,X3,X4)
    | esk15102_4(X1,X2,X3,X4) ) ).

cnf(i_0_2460,axiom,
    ( ~ esk14454_4(X1,X2,X3,X4)
    | esk14371_4(X1,X2,X3,X4)
    | esk14431_4(X1,X2,X3,X4) ) ).

cnf(i_0_2461,axiom,
    ( esk9009_4(X1,X2,X3,X4)
    | esk9016_4(X1,X2,X3,X4) ) ).

cnf(i_0_2462,axiom,
    ( esk3830_4(X1,X2,X3,X4)
    | esk3877_4(X1,X2,X3,X4) ) ).

cnf(i_0_2463,axiom,
    ( esk16691_4(X1,X2,X3,X4)
    | ~ esk143_0
    | ~ p(X4)
    | p(X1)
    | ~ p(X2)
    | p(X3) ) ).

cnf(i_0_2464,axiom,
    ( ~ esk110_0
    | esk497_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X2)
    | ~ p(X3)
    | p(X1) ) ).

cnf(i_0_2465,axiom,
    ( esk7752_4(X1,X2,X3,X4)
    | ~ esk7751_4(X1,X2,X3,X4) ) ).

cnf(i_0_2466,axiom,
    ( ~ esk938_4(X1,X2,X3,X4)
    | ~ esk933_4(X1,X2,X3,X4) ) ).

cnf(i_0_2467,axiom,
    ( ~ esk14044_4(X1,X2,X3,X4)
    | esk14042_4(X1,X2,X3,X4) ) ).

cnf(i_0_2468,axiom,
    ( ~ esk11707_4(X1,X2,X3,X4)
    | esk11809_4(X1,X2,X3,X4) ) ).

cnf(i_0_2469,axiom,
    ( ~ esk1228_4(X1,X2,X3,X4)
    | ~ esk1354_4(X1,X2,X3,X4)
    | ~ esk1240_4(X1,X2,X3,X4) ) ).

cnf(i_0_2470,axiom,
    ( esk1219_4(X1,X2,X3,X4)
    | esk1242_4(X1,X2,X3,X4) ) ).

cnf(i_0_2471,axiom,
    ( ~ esk15092_4(X1,X2,X3,X4)
    | esk15161_4(X1,X2,X3,X4) ) ).

cnf(i_0_2472,axiom,
    ( ~ esk7954_4(X1,X2,X3,X4)
    | ~ esk7921_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_2473,axiom,
    ( ~ esk3927_4(X1,X2,X3,X4)
    | ~ esk3846_4(X1,X2,X3,X4) ) ).

cnf(i_0_2474,axiom,
    ( esk14615_4(X1,X2,X3,X4)
    | esk14648_4(X1,X2,X3,X4) ) ).

cnf(i_0_2475,axiom,
    ( esk1981_4(X1,X2,X3,X4)
    | ~ esk2062_4(X1,X2,X3,X4) ) ).

cnf(i_0_2476,axiom,
    ( esk2447_4(X1,X2,X3,X4)
    | ~ esk2416_4(X1,X2,X3,X4) ) ).

cnf(i_0_2477,axiom,
    ( esk12952_4(X1,X2,X3,X4)
    | ~ esk12985_4(X1,X2,X3,X4) ) ).

cnf(i_0_2478,axiom,
    ( ~ esk16334_4(X1,X2,X3,X4)
    | esk16291_4(X1,X2,X3,X4) ) ).

cnf(i_0_2479,axiom,
    ( esk15992_4(X1,X2,X3,X4)
    | ~ esk15941_4(X1,X2,X3,X4) ) ).

cnf(i_0_2480,axiom,
    ( esk7250_4(X1,X2,X3,X4)
    | ~ esk7222_4(X1,X2,X3,X4) ) ).

cnf(i_0_2481,axiom,
    ( ~ esk4126_4(X1,X2,X3,X4)
    | ~ esk3980_4(X1,X2,X3,X4)
    | ~ esk4133_4(X1,X2,X3,X4) ) ).

cnf(i_0_2482,axiom,
    ( esk14341_4(X1,X2,X3,X4)
    | esk14335_4(X1,X2,X3,X4) ) ).

cnf(i_0_2483,axiom,
    ( ~ esk5035_4(X1,X2,X3,X4)
    | esk5293_4(X1,X2,X3,X4) ) ).

cnf(i_0_2484,axiom,
    ( esk10461_4(X1,X2,X3,X4)
    | esk10550_4(X1,X2,X3,X4) ) ).

cnf(i_0_2485,axiom,
    ( esk10749_4(X1,X2,X3,X4)
    | esk10729_4(X1,X2,X3,X4) ) ).

cnf(i_0_2486,axiom,
    ( esk12536_4(X1,X2,X3,X4)
    | esk12540_4(X1,X2,X3,X4) ) ).

cnf(i_0_2487,axiom,
    ( esk7863_4(X1,X2,X3,X4)
    | ~ esk7605_4(X1,X2,X3,X4) ) ).

cnf(i_0_2488,axiom,
    ( esk4259_4(X1,X2,X3,X4)
    | esk4228_4(X1,X2,X3,X4)
    | ~ esk4379_4(X1,X2,X3,X4) ) ).

cnf(i_0_2489,axiom,
    ( ~ esk11289_4(X1,X2,X3,X4)
    | esk11031_4(X1,X2,X3,X4) ) ).

cnf(i_0_2490,axiom,
    ( ~ esk10432_4(X1,X2,X3,X4)
    | esk10454_4(X1,X2,X3,X4) ) ).

cnf(i_0_2491,axiom,
    ( esk4021_4(X1,X2,X3,X4)
    | ~ esk4020_4(X1,X2,X3,X4)
    | ~ esk4019_4(X1,X2,X3,X4) ) ).

cnf(i_0_2492,axiom,
    ( ~ esk918_4(X1,X2,X3,X4)
    | esk1045_4(X1,X2,X3,X4) ) ).

cnf(i_0_2493,axiom,
    ( esk16667_4(X1,X2,X3,X4)
    | esk16700_4(X1,X2,X3,X4) ) ).

cnf(i_0_2494,axiom,
    ( esk4263_4(X1,X2,X3,X4)
    | ~ esk4260_4(X1,X2,X3,X4) ) ).

cnf(i_0_2495,axiom,
    ( esk2876_4(X1,X2,X3,X4)
    | ~ esk2822_4(X1,X2,X3,X4)
    | esk2857_4(X1,X2,X3,X4) ) ).

cnf(i_0_2496,axiom,
    ( esk1189_4(X1,X2,X3,X4)
    | esk1184_4(X1,X2,X3,X4)
    | esk1190_4(X1,X2,X3,X4) ) ).

cnf(i_0_2497,axiom,
    ( esk13262_4(X1,X2,X3,X4)
    | esk13263_4(X1,X2,X3,X4) ) ).

cnf(i_0_2498,axiom,
    ( ~ esk13178_4(X1,X2,X3,X4)
    | esk13090_4(X1,X2,X3,X4)
    | esk13171_4(X1,X2,X3,X4) ) ).

cnf(i_0_2499,axiom,
    ( esk11597_4(X1,X2,X3,X4)
    | esk11558_4(X1,X2,X3,X4) ) ).

cnf(i_0_2500,axiom,
    ( esk2555_4(X1,X2,X3,X4)
    | ~ esk2454_4(X1,X2,X3,X4) ) ).

cnf(i_0_2501,axiom,
    ( esk15319_4(X1,X2,X3,X4)
    | esk15330_4(X1,X2,X3,X4)
    | ~ esk15331_4(X1,X2,X3,X4) ) ).

cnf(i_0_2502,axiom,
    ( ~ esk1282_4(X1,X2,X3,X4)
    | ~ esk1313_4(X1,X2,X3,X4) ) ).

cnf(i_0_2503,axiom,
    ( esk12519_4(X1,X2,X3,X4)
    | esk12565_4(X1,X2,X3,X4) ) ).

cnf(i_0_2504,axiom,
    ( ~ p(X1)
    | p(X2)
    | p(X4)
    | esk12_0
    | ~ esk410_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_2505,axiom,
    ( esk8218_4(X1,X2,X3,X4)
    | ~ esk8476_4(X1,X2,X3,X4) ) ).

cnf(i_0_2506,axiom,
    ( ~ esk7698_4(X1,X2,X3,X4)
    | esk7956_4(X1,X2,X3,X4) ) ).

cnf(i_0_2507,axiom,
    ( esk13586_4(X1,X2,X3,X4)
    | esk13671_4(X1,X2,X3,X4) ) ).

cnf(i_0_2508,axiom,
    ( esk2178_4(X1,X2,X3,X4)
    | esk2154_4(X1,X2,X3,X4)
    | esk2179_4(X1,X2,X3,X4)
    | esk2206_4(X1,X2,X3,X4)
    | esk2176_4(X1,X2,X3,X4) ) ).

cnf(i_0_2509,axiom,
    ( ~ esk1018_4(X1,X2,X3,X4)
    | esk961_4(X1,X2,X3,X4) ) ).

cnf(i_0_2510,axiom,
    ( ~ esk7185_4(X1,X2,X3,X4)
    | ~ esk7229_4(X1,X2,X3,X4)
    | ~ esk7230_4(X1,X2,X3,X4) ) ).

cnf(i_0_2511,axiom,
    ( ~ esk13550_4(X1,X2,X3,X4)
    | ~ esk13588_4(X1,X2,X3,X4)
    | ~ esk13587_4(X1,X2,X3,X4) ) ).

cnf(i_0_2512,axiom,
    ( ~ esk3631_4(X1,X2,X3,X4)
    | ~ esk3587_4(X1,X2,X3,X4)
    | ~ esk3632_4(X1,X2,X3,X4) ) ).

cnf(i_0_2513,axiom,
    ( esk7296_4(X1,X2,X3,X4)
    | ~ esk7339_4(X1,X2,X3,X4) ) ).

cnf(i_0_2514,axiom,
    ( ~ esk1446_4(X1,X2,X3,X4)
    | esk1450_4(X1,X2,X3,X4) ) ).

cnf(i_0_2515,axiom,
    ( esk13398_4(X1,X2,X3,X4)
    | esk13430_4(X1,X2,X3,X4) ) ).

cnf(i_0_2516,axiom,
    ( p(X1)
    | ~ p(X3)
    | esk16701_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ esk219_0
    | p(X4) ) ).

cnf(i_0_2517,axiom,
    esk916_4(X1,X2,X3,X4) ).

cnf(i_0_2518,axiom,
    ( ~ esk5596_4(X1,X2,X3,X4)
    | ~ esk5541_4(X1,X2,X3,X4) ) ).

cnf(i_0_2519,axiom,
    ( esk13638_4(X1,X2,X3,X4)
    | ~ esk13481_4(X1,X2,X3,X4) ) ).

cnf(i_0_2520,axiom,
    ( esk10961_4(X1,X2,X3,X4)
    | esk10956_4(X1,X2,X3,X4) ) ).

cnf(i_0_2521,axiom,
    ( ~ esk2511_4(X1,X2,X3,X4)
    | ~ esk2524_4(X1,X2,X3,X4)
    | ~ esk2557_4(X1,X2,X3,X4) ) ).

cnf(i_0_2522,axiom,
    ( esk7241_4(X1,X2,X3,X4)
    | esk7227_4(X1,X2,X3,X4) ) ).

cnf(i_0_2523,axiom,
    ( esk8210_4(X1,X2,X3,X4)
    | ~ esk8468_4(X1,X2,X3,X4) ) ).

cnf(i_0_2524,axiom,
    ( esk5425_4(X1,X2,X3,X4)
    | esk5426_4(X1,X2,X3,X4)
    | ~ esk5447_4(X1,X2,X3,X4) ) ).

cnf(i_0_2525,axiom,
    ( esk11213_4(X1,X2,X3,X4)
    | esk11204_4(X1,X2,X3,X4) ) ).

cnf(i_0_2526,axiom,
    ( esk14241_4(X1,X2,X3,X4)
    | ~ esk14266_4(X1,X2,X3,X4) ) ).

cnf(i_0_2527,axiom,
    ( esk11444_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4)
    | ~ esk11570_4(X1,X2,X3,X4) ) ).

cnf(i_0_2528,axiom,
    ( esk4346_4(X1,X2,X3,X4)
    | esk4393_4(X1,X2,X3,X4)
    | ~ esk4430_4(X1,X2,X3,X4) ) ).

cnf(i_0_2529,axiom,
    ( esk9193_4(X1,X2,X3,X4)
    | esk9204_4(X1,X2,X3,X4) ) ).

cnf(i_0_2530,axiom,
    ( ~ esk1013_4(X1,X2,X3,X4)
    | esk755_4(X1,X2,X3,X4) ) ).

cnf(i_0_2531,axiom,
    ( esk12468_4(X1,X2,X3,X4)
    | ~ esk12590_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_2532,axiom,
    ( esk14168_4(X1,X2,X3,X4)
    | esk14175_4(X1,X2,X3,X4)
    | ~ esk14124_4(X1,X2,X3,X4) ) ).

cnf(i_0_2533,axiom,
    ( esk11175_4(X1,X2,X3,X4)
    | ~ esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_2534,axiom,
    ( ~ esk4512_4(X1,X2,X3,X4)
    | esk4633_4(X1,X2,X3,X4) ) ).

cnf(i_0_2535,axiom,
    ( esk3672_4(X1,X2,X3,X4)
    | esk3662_4(X1,X2,X3,X4) ) ).

cnf(i_0_2536,axiom,
    ( esk15386_4(X1,X2,X3,X4)
    | esk15361_4(X1,X2,X3,X4) ) ).

cnf(i_0_2537,axiom,
    ( ~ esk15146_4(X1,X2,X3,X4)
    | ~ esk15113_4(X1,X2,X3,X4)
    | ~ esk15104_4(X1,X2,X3,X4) ) ).

cnf(i_0_2538,axiom,
    ( esk15477_4(X1,X2,X3,X4)
    | ~ esk15478_4(X1,X2,X3,X4)
    | esk15427_4(X1,X2,X3,X4) ) ).

cnf(i_0_2539,axiom,
    ( ~ esk3994_4(X1,X2,X3,X4)
    | esk4003_4(X1,X2,X3,X4) ) ).

cnf(i_0_2540,axiom,
    ( ~ esk919_4(X1,X2,X3,X4)
    | esk904_4(X1,X2,X3,X4)
    | ~ esk1027_4(X1,X2,X3,X4) ) ).

cnf(i_0_2541,axiom,
    ( ~ esk15229_4(X1,X2,X3,X4)
    | ~ esk15197_4(X1,X2,X3,X4) ) ).

cnf(i_0_2542,axiom,
    ( esk7503_4(X1,X2,X3,X4)
    | esk7481_4(X1,X2,X3,X4)
    | ~ esk7482_4(X1,X2,X3,X4) ) ).

cnf(i_0_2543,axiom,
    ( esk8434_4(X1,X2,X3,X4)
    | esk8546_4(X1,X2,X3,X4) ) ).

cnf(i_0_2544,axiom,
    ( esk13569_4(X1,X2,X3,X4)
    | esk13562_4(X1,X2,X3,X4) ) ).

cnf(i_0_2545,axiom,
    ( esk8157_4(X1,X2,X3,X4)
    | ~ esk8214_4(X1,X2,X3,X4) ) ).

cnf(i_0_2546,axiom,
    ( ~ esk6574_4(X1,X2,X3,X4)
    | ~ esk6524_4(X1,X2,X3,X4)
    | ~ esk6575_4(X1,X2,X3,X4)
    | ~ esk6522_4(X1,X2,X3,X4)
    | ~ esk6521_4(X1,X2,X3,X4) ) ).

cnf(i_0_2547,axiom,
    ( esk5087_4(X1,X2,X3,X4)
    | esk5083_4(X1,X2,X3,X4) ) ).

cnf(i_0_2548,axiom,
    ( esk9501_4(X1,X2,X3,X4)
    | ~ esk9759_4(X1,X2,X3,X4) ) ).

cnf(i_0_2549,axiom,
    ( esk11879_4(X1,X2,X3,X4)
    | esk11827_4(X1,X2,X3,X4) ) ).

cnf(i_0_2550,axiom,
    ( esk7421_4(X1,X2,X3,X4)
    | esk7381_4(X1,X2,X3,X4) ) ).

cnf(i_0_2551,axiom,
    ( esk13139_4(X1,X2,X3,X4)
    | esk13130_4(X1,X2,X3,X4)
    | esk13138_4(X1,X2,X3,X4) ) ).

cnf(i_0_2552,axiom,
    ( esk12404_4(X1,X2,X3,X4)
    | ~ esk12405_4(X1,X2,X3,X4) ) ).

cnf(i_0_2553,axiom,
    ( esk7944_4(X1,X2,X3,X4)
    | ~ esk8028_4(X1,X2,X3,X4)
    | esk7991_4(X1,X2,X3,X4) ) ).

cnf(i_0_2554,axiom,
    ( ~ esk6595_4(X1,X2,X3,X4)
    | esk6579_4(X1,X2,X3,X4) ) ).

cnf(i_0_2555,axiom,
    ( esk15268_4(X1,X2,X3,X4)
    | ~ esk15295_4(X1,X2,X3,X4) ) ).

cnf(i_0_2556,axiom,
    ( esk15443_4(X1,X2,X3,X4)
    | esk15451_4(X1,X2,X3,X4)
    | esk15452_4(X1,X2,X3,X4) ) ).

cnf(i_0_2557,axiom,
    ( esk12344_4(X1,X2,X3,X4)
    | ~ esk12345_4(X1,X2,X3,X4)
    | esk12349_4(X1,X2,X3,X4) ) ).

cnf(i_0_2558,axiom,
    ( esk2724_4(X1,X2,X3,X4)
    | ~ esk2740_4(X1,X2,X3,X4) ) ).

cnf(i_0_2559,axiom,
    ( ~ esk10269_4(X1,X2,X3,X4)
    | ~ esk10171_4(X1,X2,X3,X4)
    | esk10151_4(X1,X2,X3,X4) ) ).

cnf(i_0_2560,axiom,
    ( esk5504_4(X1,X2,X3,X4)
    | ~ esk5527_4(X1,X2,X3,X4) ) ).

cnf(i_0_2561,axiom,
    ( esk16581_4(X1,X2,X3,X4)
    | ~ esk16552_4(X1,X2,X3,X4) ) ).

cnf(i_0_2562,axiom,
    ( ~ esk11468_4(X1,X2,X3,X4)
    | ~ esk11470_4(X1,X2,X3,X4) ) ).

cnf(i_0_2563,axiom,
    ( esk13044_4(X1,X2,X3,X4)
    | ~ esk13089_4(X1,X2,X3,X4) ) ).

cnf(i_0_2564,axiom,
    ( ~ esk7448_4(X1,X2,X3,X4)
    | esk7190_4(X1,X2,X3,X4) ) ).

cnf(i_0_2565,axiom,
    ( esk14408_4(X1,X2,X3,X4)
    | ~ esk14407_4(X1,X2,X3,X4) ) ).

cnf(i_0_2566,axiom,
    ( ~ esk11194_4(X1,X2,X3,X4)
    | esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_2567,axiom,
    ( ~ esk16732_4(X1,X2,X3,X4)
    | ~ esk16730_4(X1,X2,X3,X4) ) ).

cnf(i_0_2568,axiom,
    ( ~ esk2927_4(X1,X2,X3,X4)
    | esk2970_4(X1,X2,X3,X4) ) ).

cnf(i_0_2569,axiom,
    ( esk9022_4(X1,X2,X3,X4)
    | esk8996_4(X1,X2,X3,X4)
    | ~ esk9047_4(X1,X2,X3,X4) ) ).

cnf(i_0_2570,axiom,
    ( ~ esk15437_4(X1,X2,X3,X4)
    | esk15438_4(X1,X2,X3,X4)
    | ~ esk15436_4(X1,X2,X3,X4) ) ).

cnf(i_0_2571,axiom,
    ( esk10223_4(X1,X2,X3,X4)
    | esk10241_4(X1,X2,X3,X4) ) ).

cnf(i_0_2572,axiom,
    ( esk10181_4(X1,X2,X3,X4)
    | ~ esk9923_4(X1,X2,X3,X4) ) ).

cnf(i_0_2573,axiom,
    ( esk13060_4(X1,X2,X3,X4)
    | esk13043_4(X1,X2,X3,X4) ) ).

cnf(i_0_2574,axiom,
    ( esk15180_4(X1,X2,X3,X4)
    | ~ esk15023_4(X1,X2,X3,X4) ) ).

cnf(i_0_2575,axiom,
    ( ~ esk5316_4(X1,X2,X3,X4)
    | esk5312_4(X1,X2,X3,X4) ) ).

cnf(i_0_2576,axiom,
    ( ~ esk15588_4(X1,X2,X3,X4)
    | esk15590_4(X1,X2,X3,X4)
    | ~ esk15589_4(X1,X2,X3,X4) ) ).

cnf(i_0_2577,axiom,
    ( ~ esk16690_4(X1,X2,X3,X4)
    | ~ esk16657_4(X1,X2,X3,X4)
    | ~ esk16646_4(X1,X2,X3,X4) ) ).

cnf(i_0_2578,axiom,
    ( ~ esk7256_4(X1,X2,X3,X4)
    | esk7255_4(X1,X2,X3,X4) ) ).

cnf(i_0_2579,axiom,
    ( ~ esk6854_4(X1,X2,X3,X4)
    | esk6856_4(X1,X2,X3,X4)
    | ~ esk6855_4(X1,X2,X3,X4) ) ).

cnf(i_0_2580,axiom,
    ( ~ esk11178_4(X1,X2,X3,X4)
    | esk11230_4(X1,X2,X3,X4) ) ).

cnf(i_0_2581,axiom,
    ( ~ esk8675_4(X1,X2,X3,X4)
    | ~ esk8688_4(X1,X2,X3,X4)
    | ~ esk8689_4(X1,X2,X3,X4) ) ).

cnf(i_0_2582,axiom,
    ( ~ esk14842_4(X1,X2,X3,X4)
    | ~ esk14858_4(X1,X2,X3,X4)
    | ~ esk14859_4(X1,X2,X3,X4) ) ).

cnf(i_0_2583,axiom,
    ( ~ esk12090_4(X1,X2,X3,X4)
    | esk12088_4(X1,X2,X3,X4) ) ).

cnf(i_0_2584,axiom,
    ( esk5340_4(X1,X2,X3,X4)
    | esk5350_4(X1,X2,X3,X4) ) ).

cnf(i_0_2585,axiom,
    ( ~ esk14618_4(X1,X2,X3,X4)
    | ~ esk14592_4(X1,X2,X3,X4)
    | ~ esk14701_4(X1,X2,X3,X4) ) ).

cnf(i_0_2586,axiom,
    ( esk15195_4(X1,X2,X3,X4)
    | esk15194_4(X1,X2,X3,X4)
    | esk15235_4(X1,X2,X3,X4)
    | esk15196_4(X1,X2,X3,X4) ) ).

cnf(i_0_2587,axiom,
    ( ~ esk3392_4(X1,X2,X3,X4)
    | ~ esk3414_4(X1,X2,X3,X4) ) ).

cnf(i_0_2588,axiom,
    ( esk1270_4(X1,X2,X3,X4)
    | esk1323_4(X1,X2,X3,X4) ) ).

cnf(i_0_2589,axiom,
    ( esk1997_4(X1,X2,X3,X4)
    | esk2014_4(X1,X2,X3,X4) ) ).

cnf(i_0_2590,axiom,
    ( esk9830_4(X1,X2,X3,X4)
    | esk9837_4(X1,X2,X3,X4)
    | ~ esk9749_4(X1,X2,X3,X4) ) ).

cnf(i_0_2591,axiom,
    ( esk10428_4(X1,X2,X3,X4)
    | ~ esk10411_4(X1,X2,X3,X4) ) ).

cnf(i_0_2592,axiom,
    ( esk3108_4(X1,X2,X3,X4)
    | ~ esk3061_4(X1,X2,X3,X4)
    | esk3145_4(X1,X2,X3,X4) ) ).

cnf(i_0_2593,axiom,
    ( esk2608_4(X1,X2,X3,X4)
    | ~ esk2607_4(X1,X2,X3,X4)
    | esk2633_4(X1,X2,X3,X4) ) ).

cnf(i_0_2594,axiom,
    ( esk9200_4(X1,X2,X3,X4)
    | esk9190_4(X1,X2,X3,X4) ) ).

cnf(i_0_2595,axiom,
    ( esk6314_4(X1,X2,X3,X4)
    | ~ esk6294_4(X1,X2,X3,X4) ) ).

cnf(i_0_2596,axiom,
    ( esk8414_4(X1,X2,X3,X4)
    | esk8440_4(X1,X2,X3,X4) ) ).

cnf(i_0_2597,axiom,
    ( ~ esk7456_4(X1,X2,X3,X4)
    | esk7198_4(X1,X2,X3,X4) ) ).

cnf(i_0_2598,axiom,
    ( ~ esk16684_4(X1,X2,X3,X4)
    | esk16426_4(X1,X2,X3,X4) ) ).

cnf(i_0_2599,axiom,
    ( esk8292_4(X1,X2,X3,X4)
    | ~ esk8258_4(X1,X2,X3,X4) ) ).

cnf(i_0_2600,axiom,
    ( esk669_4(X1,X2,X3,X4)
    | esk670_4(X1,X2,X3,X4) ) ).

cnf(i_0_2601,axiom,
    ( esk14539_4(X1,X2,X3,X4)
    | esk14657_4(X1,X2,X3,X4) ) ).

cnf(i_0_2602,axiom,
    ( esk1986_4(X1,X2,X3,X4)
    | esk2020_4(X1,X2,X3,X4) ) ).

cnf(i_0_2603,axiom,
    ( ~ esk15152_4(X1,X2,X3,X4)
    | ~ esk15203_4(X1,X2,X3,X4)
    | ~ esk15196_4(X1,X2,X3,X4) ) ).

cnf(i_0_2604,axiom,
    ( esk12587_4(X1,X2,X3,X4)
    | ~ esk12845_4(X1,X2,X3,X4) ) ).

cnf(i_0_2605,axiom,
    ( esk12277_4(X1,X2,X3,X4)
    | esk12302_4(X1,X2,X3,X4) ) ).

cnf(i_0_2606,axiom,
    ( ~ esk4567_4(X1,X2,X3,X4)
    | ~ esk4629_4(X1,X2,X3,X4)
    | ~ esk4596_4(X1,X2,X3,X4) ) ).

cnf(i_0_2607,axiom,
    ( ~ esk6961_4(X1,X2,X3,X4)
    | ~ esk6946_4(X1,X2,X3,X4) ) ).

cnf(i_0_2608,axiom,
    ( p(X3)
    | esk330_0
    | ~ p(X1)
    | ~ p(X2)
    | p(X4)
    | ~ esk16724_4(X1,X2,X3,X4) ) ).

cnf(i_0_2609,axiom,
    ( esk12022_4(X1,X2,X3,X4)
    | esk12036_4(X1,X2,X3,X4) ) ).

cnf(i_0_2610,axiom,
    ( esk14307_4(X1,X2,X3,X4)
    | ~ esk14306_4(X1,X2,X3,X4) ) ).

cnf(i_0_2611,axiom,
    ( ~ esk13878_4(X1,X2,X3,X4)
    | esk14136_4(X1,X2,X3,X4) ) ).

cnf(i_0_2612,axiom,
    ( esk14592_4(X1,X2,X3,X4)
    | esk14591_4(X1,X2,X3,X4)
    | esk14570_4(X1,X2,X3,X4) ) ).

cnf(i_0_2613,axiom,
    ( esk2365_4(X1,X2,X3,X4)
    | ~ esk2314_4(X1,X2,X3,X4)
    | esk2340_4(X1,X2,X3,X4) ) ).

cnf(i_0_2614,axiom,
    ( ~ esk13217_4(X1,X2,X3,X4)
    | esk13249_4(X1,X2,X3,X4) ) ).

cnf(i_0_2615,axiom,
    ( ~ esk16703_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X2)
    | esk233_0
    | ~ p(X4)
    | p(X3) ) ).

cnf(i_0_2616,axiom,
    ( esk2196_4(X1,X2,X3,X4)
    | ~ esk2168_4(X1,X2,X3,X4) ) ).

cnf(i_0_2617,axiom,
    ( ~ esk2170_4(X1,X2,X3,X4)
    | esk2194_4(X1,X2,X3,X4) ) ).

cnf(i_0_2618,axiom,
    ( esk11629_4(X1,X2,X3,X4)
    | ~ esk11636_4(X1,X2,X3,X4)
    | esk11548_4(X1,X2,X3,X4) ) ).

cnf(i_0_2619,axiom,
    ( ~ esk5943_4(X1,X2,X3,X4)
    | ~ esk5944_4(X1,X2,X3,X4) ) ).

cnf(i_0_2620,axiom,
    ( p(X3)
    | ~ p(X2)
    | ~ esk519_4(X1,X2,X3,X4)
    | esk276_0
    | p(X1)
    | p(X4) ) ).

cnf(i_0_2621,axiom,
    ( ~ esk756_4(X1,X2,X3,X4)
    | ~ esk723_4(X1,X2,X3,X4)
    | ~ esk712_4(X1,X2,X3,X4) ) ).

cnf(i_0_2622,axiom,
    ( ~ esk11849_4(X1,X2,X3,X4)
    | ~ esk11848_4(X1,X2,X3,X4) ) ).

cnf(i_0_2623,axiom,
    ( ~ esk7502_4(X1,X2,X3,X4)
    | ~ esk7483_4(X1,X2,X3,X4)
    | ~ esk7448_4(X1,X2,X3,X4) ) ).

cnf(i_0_2624,axiom,
    ( esk7687_4(X1,X2,X3,X4)
    | ~ esk7429_4(X1,X2,X3,X4) ) ).

cnf(i_0_2625,axiom,
    ( esk5560_4(X1,X2,X3,X4)
    | esk5558_4(X1,X2,X3,X4) ) ).

cnf(i_0_2626,axiom,
    ( ~ esk5124_4(X1,X2,X3,X4)
    | esk5382_4(X1,X2,X3,X4) ) ).

cnf(i_0_2627,axiom,
    ( ~ esk11312_4(X1,X2,X3,X4)
    | esk11570_4(X1,X2,X3,X4) ) ).

cnf(i_0_2628,axiom,
    ( ~ esk969_4(X1,X2,X3,X4)
    | ~ esk974_4(X1,X2,X3,X4)
    | ~ esk1007_4(X1,X2,X3,X4) ) ).

cnf(i_0_2629,axiom,
    ( esk1212_4(X1,X2,X3,X4)
    | esk1255_4(X1,X2,X3,X4) ) ).

cnf(i_0_2630,axiom,
    ( ~ esk1186_4(X1,X2,X3,X4)
    | ~ esk1187_4(X1,X2,X3,X4) ) ).

cnf(i_0_2631,axiom,
    ( ~ esk2337_4(X1,X2,X3,X4)
    | esk2352_4(X1,X2,X3,X4) ) ).

cnf(i_0_2632,axiom,
    ( esk511_4(X1,X2,X3,X4)
    | ~ esk222_0
    | ~ p(X3)
    | p(X4)
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_2633,axiom,
    ( esk8785_4(X1,X2,X3,X4)
    | ~ esk8731_4(X1,X2,X3,X4) ) ).

cnf(i_0_2634,axiom,
    ( esk955_4(X1,X2,X3,X4)
    | ~ esk1030_4(X1,X2,X3,X4) ) ).

cnf(i_0_2635,axiom,
    ( p(X1)
    | p(X4)
    | ~ esk82_0
    | ~ p(X2)
    | p(X3)
    | esk16683_4(X1,X2,X3,X4) ) ).

cnf(i_0_2636,axiom,
    ( ~ esk7398_4(X1,X2,X3,X4)
    | ~ esk7396_4(X1,X2,X3,X4)
    | ~ esk7514_4(X1,X2,X3,X4) ) ).

cnf(i_0_2637,axiom,
    ( esk15932_4(X1,X2,X3,X4)
    | ~ esk16190_4(X1,X2,X3,X4) ) ).

cnf(i_0_2638,axiom,
    ( ~ esk9194_4(X1,X2,X3,X4)
    | ~ esk9139_4(X1,X2,X3,X4) ) ).

cnf(i_0_2639,axiom,
    ( esk14838_4(X1,X2,X3,X4)
    | esk14867_4(X1,X2,X3,X4) ) ).

cnf(i_0_2640,axiom,
    ( esk1215_4(X1,X2,X3,X4)
    | esk1250_4(X1,X2,X3,X4) ) ).

cnf(i_0_2641,axiom,
    ( esk2713_4(X1,X2,X3,X4)
    | ~ esk2670_4(X1,X2,X3,X4) ) ).

cnf(i_0_2642,axiom,
    ( esk15049_4(X1,X2,X3,X4)
    | ~ esk15054_4(X1,X2,X3,X4)
    | ~ esk15170_4(X1,X2,X3,X4) ) ).

cnf(i_0_2643,axiom,
    ( esk9287_4(X1,X2,X3,X4)
    | esk9239_4(X1,X2,X3,X4) ) ).

cnf(i_0_2644,axiom,
    ( esk4777_4(X1,X2,X3,X4)
    | esk4775_4(X1,X2,X3,X4) ) ).

cnf(i_0_2645,axiom,
    ( ~ esk7978_4(X1,X2,X3,X4)
    | esk7977_4(X1,X2,X3,X4) ) ).

cnf(i_0_2646,axiom,
    ( ~ esk9045_4(X1,X2,X3,X4)
    | ~ esk9023_4(X1,X2,X3,X4)
    | ~ esk9024_4(X1,X2,X3,X4) ) ).

cnf(i_0_2647,axiom,
    ( esk2007_4(X1,X2,X3,X4)
    | esk1999_4(X1,X2,X3,X4) ) ).

cnf(i_0_2648,axiom,
    ( esk8698_4(X1,X2,X3,X4)
    | esk8670_4(X1,X2,X3,X4) ) ).

cnf(i_0_2649,axiom,
    ( esk2476_4(X1,X2,X3,X4)
    | esk2474_4(X1,X2,X3,X4) ) ).

cnf(i_0_2650,axiom,
    ( esk3215_4(X1,X2,X3,X4)
    | ~ esk3190_4(X1,X2,X3,X4) ) ).

cnf(i_0_2651,axiom,
    ( esk10516_4(X1,X2,X3,X4)
    | ~ esk10258_4(X1,X2,X3,X4) ) ).

cnf(i_0_2652,axiom,
    ( esk10006_4(X1,X2,X3,X4)
    | esk9973_4(X1,X2,X3,X4) ) ).

cnf(i_0_2653,axiom,
    ( esk13433_4(X1,X2,X3,X4)
    | esk13319_4(X1,X2,X3,X4) ) ).

cnf(i_0_2654,axiom,
    ( ~ esk3781_4(X1,X2,X3,X4)
    | esk3859_4(X1,X2,X3,X4) ) ).

cnf(i_0_2655,axiom,
    ( ~ esk2783_4(X1,X2,X3,X4)
    | ~ esk2768_4(X1,X2,X3,X4)
    | ~ esk2816_4(X1,X2,X3,X4) ) ).

cnf(i_0_2656,axiom,
    ( ~ esk6497_4(X1,X2,X3,X4)
    | ~ esk6416_4(X1,X2,X3,X4) ) ).

cnf(i_0_2657,axiom,
    ( esk16180_4(X1,X2,X3,X4)
    | ~ esk16062_4(X1,X2,X3,X4) ) ).

cnf(i_0_2658,axiom,
    ( esk12240_4(X1,X2,X3,X4)
    | esk12242_4(X1,X2,X3,X4) ) ).

cnf(i_0_2659,axiom,
    ( ~ esk13065_4(X1,X2,X3,X4)
    | ~ esk13048_4(X1,X2,X3,X4)
    | ~ esk13098_4(X1,X2,X3,X4) ) ).

cnf(i_0_2660,axiom,
    ( ~ esk10611_4(X1,X2,X3,X4)
    | ~ esk10601_4(X1,X2,X3,X4) ) ).

cnf(i_0_2661,axiom,
    ( esk11276_4(X1,X2,X3,X4)
    | esk11309_4(X1,X2,X3,X4) ) ).

cnf(i_0_2662,axiom,
    ( esk511_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X4)
    | ~ p(X1)
    | ~ esk221_0
    | p(X3) ) ).

cnf(i_0_2663,axiom,
    ( ~ esk12585_4(X1,X2,X3,X4)
    | esk12525_4(X1,X2,X3,X4) ) ).

cnf(i_0_2664,axiom,
    ( ~ esk13015_4(X1,X2,X3,X4)
    | esk13016_4(X1,X2,X3,X4)
    | ~ esk13014_4(X1,X2,X3,X4) ) ).

cnf(i_0_2665,axiom,
    ( ~ esk3663_4(X1,X2,X3,X4)
    | ~ esk3583_4(X1,X2,X3,X4)
    | ~ esk3634_4(X1,X2,X3,X4) ) ).

cnf(i_0_2666,axiom,
    ( ~ esk5151_4(X1,X2,X3,X4)
    | esk5149_4(X1,X2,X3,X4) ) ).

cnf(i_0_2667,axiom,
    ( esk13345_4(X1,X2,X3,X4)
    | esk13401_4(X1,X2,X3,X4) ) ).

cnf(i_0_2668,axiom,
    ( esk12375_4(X1,X2,X3,X4)
    | esk12315_4(X1,X2,X3,X4)
    | ~ esk12398_4(X1,X2,X3,X4) ) ).

cnf(i_0_2669,axiom,
    ( ~ esk5428_4(X1,X2,X3,X4)
    | ~ esk5442_4(X1,X2,X3,X4) ) ).

cnf(i_0_2670,axiom,
    ( esk14857_4(X1,X2,X3,X4)
    | esk14849_4(X1,X2,X3,X4) ) ).

cnf(i_0_2671,axiom,
    ( esk971_4(X1,X2,X3,X4)
    | esk1003_4(X1,X2,X3,X4) ) ).

cnf(i_0_2672,axiom,
    ( ~ esk11046_4(X1,X2,X3,X4)
    | esk10788_4(X1,X2,X3,X4) ) ).

cnf(i_0_2673,axiom,
    ( esk11506_4(X1,X2,X3,X4)
    | esk11535_4(X1,X2,X3,X4) ) ).

cnf(i_0_2674,axiom,
    ( esk6625_4(X1,X2,X3,X4)
    | esk6635_4(X1,X2,X3,X4) ) ).

cnf(i_0_2675,axiom,
    ( ~ esk6840_4(X1,X2,X3,X4)
    | esk6582_4(X1,X2,X3,X4) ) ).

cnf(i_0_2676,axiom,
    ( ~ esk14950_4(X1,X2,X3,X4)
    | esk14949_4(X1,X2,X3,X4) ) ).

cnf(i_0_2677,axiom,
    ( esk2719_4(X1,X2,X3,X4)
    | esk2666_4(X1,X2,X3,X4) ) ).

cnf(i_0_2678,axiom,
    ( esk9938_4(X1,X2,X3,X4)
    | ~ esk9937_4(X1,X2,X3,X4) ) ).

cnf(i_0_2679,axiom,
    ( ~ esk14773_4(X1,X2,X3,X4)
    | ~ esk14800_4(X1,X2,X3,X4)
    | esk14797_4(X1,X2,X3,X4) ) ).

cnf(i_0_2680,axiom,
    ( ~ esk15041_4(X1,X2,X3,X4)
    | esk15054_4(X1,X2,X3,X4) ) ).

cnf(i_0_2681,axiom,
    ( esk14350_4(X1,X2,X3,X4)
    | esk14325_4(X1,X2,X3,X4) ) ).

cnf(i_0_2682,axiom,
    ( ~ esk796_4(X1,X2,X3,X4)
    | ~ esk776_4(X1,X2,X3,X4)
    | ~ esk778_4(X1,X2,X3,X4) ) ).

cnf(i_0_2683,axiom,
    ( esk8671_4(X1,X2,X3,X4)
    | esk8696_4(X1,X2,X3,X4) ) ).

cnf(i_0_2684,axiom,
    ( esk2077_4(X1,X2,X3,X4)
    | esk2076_4(X1,X2,X3,X4) ) ).

cnf(i_0_2685,axiom,
    ( esk8116_4(X1,X2,X3,X4)
    | esk8064_4(X1,X2,X3,X4) ) ).

cnf(i_0_2686,axiom,
    ( ~ esk3034_4(X1,X2,X3,X4)
    | ~ esk3021_4(X1,X2,X3,X4)
    | ~ esk3035_4(X1,X2,X3,X4) ) ).

cnf(i_0_2687,axiom,
    ( esk9207_4(X1,X2,X3,X4)
    | esk9187_4(X1,X2,X3,X4) ) ).

cnf(i_0_2688,axiom,
    ( p(X4)
    | ~ p(X3)
    | esk257_0
    | ~ p(X1)
    | ~ p(X2)
    | ~ esk16705_4(X1,X2,X3,X4) ) ).

cnf(i_0_2689,axiom,
    ( esk11765_4(X1,X2,X3,X4)
    | esk11767_4(X1,X2,X3,X4) ) ).

cnf(i_0_2690,axiom,
    ( ~ esk3082_4(X1,X2,X3,X4)
    | esk3340_4(X1,X2,X3,X4) ) ).

cnf(i_0_2691,axiom,
    ( esk15354_4(X1,X2,X3,X4)
    | esk15377_4(X1,X2,X3,X4) ) ).

cnf(i_0_2692,axiom,
    ( esk11111_4(X1,X2,X3,X4)
    | esk11024_4(X1,X2,X3,X4) ) ).

cnf(i_0_2693,axiom,
    ( ~ esk14926_4(X1,X2,X3,X4)
    | ~ esk14919_4(X1,X2,X3,X4)
    | ~ esk14828_4(X1,X2,X3,X4) ) ).

cnf(i_0_2694,axiom,
    ( esk9721_4(X1,X2,X3,X4)
    | esk9709_4(X1,X2,X3,X4) ) ).

cnf(i_0_2695,axiom,
    ( esk10646_4(X1,X2,X3,X4)
    | ~ esk10665_4(X1,X2,X3,X4) ) ).

cnf(i_0_2696,axiom,
    ( ~ esk5260_4(X1,X2,X3,X4)
    | ~ esk5290_4(X1,X2,X3,X4) ) ).

cnf(i_0_2697,axiom,
    ( esk2069_4(X1,X2,X3,X4)
    | ~ esk1811_4(X1,X2,X3,X4) ) ).

cnf(i_0_2698,axiom,
    ( ~ esk3065_4(X1,X2,X3,X4)
    | ~ esk3121_4(X1,X2,X3,X4) ) ).

cnf(i_0_2699,axiom,
    ( esk15882_4(X1,X2,X3,X4)
    | esk15915_4(X1,X2,X3,X4) ) ).

cnf(i_0_2700,axiom,
    ( ~ esk12105_4(X1,X2,X3,X4)
    | ~ esk12106_4(X1,X2,X3,X4) ) ).

cnf(i_0_2701,axiom,
    ( esk3818_4(X1,X2,X3,X4)
    | esk3798_4(X1,X2,X3,X4) ) ).

cnf(i_0_2702,axiom,
    ( ~ esk10514_4(X1,X2,X3,X4)
    | ~ esk10428_4(X1,X2,X3,X4)
    | esk10417_4(X1,X2,X3,X4) ) ).

cnf(i_0_2703,axiom,
    ( esk3790_4(X1,X2,X3,X4)
    | esk3809_4(X1,X2,X3,X4) ) ).

cnf(i_0_2704,axiom,
    ( p(X1)
    | p(X2)
    | esk433_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X3)
    | ~ esk48_0 ) ).

cnf(i_0_2705,axiom,
    ( ~ esk1433_4(X1,X2,X3,X4)
    | esk1428_4(X1,X2,X3,X4)
    | ~ esk1549_4(X1,X2,X3,X4) ) ).

cnf(i_0_2706,axiom,
    ( ~ esk14625_4(X1,X2,X3,X4)
    | esk14589_4(X1,X2,X3,X4) ) ).

cnf(i_0_2707,axiom,
    ( ~ esk12831_4(X1,X2,X3,X4)
    | esk12573_4(X1,X2,X3,X4) ) ).

cnf(i_0_2708,axiom,
    ( esk9137_4(X1,X2,X3,X4)
    | ~ esk9239_4(X1,X2,X3,X4)
    | ~ esk9143_4(X1,X2,X3,X4) ) ).

cnf(i_0_2709,axiom,
    ( esk16353_4(X1,X2,X3,X4)
    | esk16367_4(X1,X2,X3,X4) ) ).

cnf(i_0_2710,axiom,
    ( ~ esk13341_4(X1,X2,X3,X4)
    | ~ esk13305_4(X1,X2,X3,X4)
    | ~ esk13308_4(X1,X2,X3,X4) ) ).

cnf(i_0_2711,axiom,
    ( esk11102_4(X1,X2,X3,X4)
    | esk11121_4(X1,X2,X3,X4)
    | ~ esk11050_4(X1,X2,X3,X4) ) ).

cnf(i_0_2712,axiom,
    ( esk5570_4(X1,X2,X3,X4)
    | ~ esk5571_4(X1,X2,X3,X4) ) ).

cnf(i_0_2713,axiom,
    ( esk440_4(X1,X2,X3,X4)
    | ~ esk518_4(X1,X2,X3,X4) ) ).

cnf(i_0_2714,axiom,
    ( esk1775_4(X1,X2,X3,X4)
    | ~ esk1739_4(X1,X2,X3,X4) ) ).

cnf(i_0_2715,axiom,
    ( esk12209_4(X1,X2,X3,X4)
    | ~ esk12186_4(X1,X2,X3,X4) ) ).

cnf(i_0_2716,axiom,
    ( esk4913_4(X1,X2,X3,X4)
    | esk4914_4(X1,X2,X3,X4) ) ).

cnf(i_0_2717,axiom,
    ( esk15124_4(X1,X2,X3,X4)
    | esk15106_4(X1,X2,X3,X4) ) ).

cnf(i_0_2718,axiom,
    ( esk13923_4(X1,X2,X3,X4)
    | esk13909_4(X1,X2,X3,X4) ) ).

cnf(i_0_2719,axiom,
    ( esk12893_4(X1,X2,X3,X4)
    | ~ esk12922_4(X1,X2,X3,X4) ) ).

cnf(i_0_2720,axiom,
    ( ~ esk9505_4(X1,X2,X3,X4)
    | esk9763_4(X1,X2,X3,X4) ) ).

cnf(i_0_2721,axiom,
    ( esk6997_4(X1,X2,X3,X4)
    | ~ esk6946_4(X1,X2,X3,X4) ) ).

cnf(i_0_2722,axiom,
    ( esk16414_4(X1,X2,X3,X4)
    | esk16377_4(X1,X2,X3,X4) ) ).

cnf(i_0_2723,axiom,
    ( ~ esk1855_4(X1,X2,X3,X4)
    | esk1854_4(X1,X2,X3,X4) ) ).

cnf(i_0_2724,axiom,
    ( esk1003_4(X1,X2,X3,X4)
    | esk953_4(X1,X2,X3,X4) ) ).

cnf(i_0_2725,axiom,
    ( esk15163_4(X1,X2,X3,X4)
    | ~ esk15091_4(X1,X2,X3,X4) ) ).

cnf(i_0_2726,axiom,
    ( esk1990_4(X1,X2,X3,X4)
    | ~ esk2044_4(X1,X2,X3,X4) ) ).

cnf(i_0_2727,axiom,
    ( esk1531_4(X1,X2,X3,X4)
    | ~ esk1575_4(X1,X2,X3,X4)
    | esk1582_4(X1,X2,X3,X4) ) ).

cnf(i_0_2728,axiom,
    ( esk9707_4(X1,X2,X3,X4)
    | esk9738_4(X1,X2,X3,X4) ) ).

cnf(i_0_2729,axiom,
    ( esk3465_4(X1,X2,X3,X4)
    | ~ esk3489_4(X1,X2,X3,X4) ) ).

cnf(i_0_2730,axiom,
    ( esk1264_4(X1,X2,X3,X4)
    | esk1231_4(X1,X2,X3,X4) ) ).

cnf(i_0_2731,axiom,
    ( ~ esk3077_4(X1,X2,X3,X4)
    | ~ esk3116_4(X1,X2,X3,X4) ) ).

cnf(i_0_2732,axiom,
    ( p(X3)
    | esk16724_4(X1,X2,X3,X4)
    | ~ esk322_0
    | p(X1)
    | ~ p(X2)
    | p(X4) ) ).

cnf(i_0_2733,axiom,
    ( ~ esk7478_4(X1,X2,X3,X4)
    | ~ esk7460_4(X1,X2,X3,X4)
    | ~ esk7458_4(X1,X2,X3,X4) ) ).

cnf(i_0_2734,axiom,
    ( esk1713_4(X1,X2,X3,X4)
    | esk1695_4(X1,X2,X3,X4) ) ).

cnf(i_0_2735,axiom,
    ( esk12816_4(X1,X2,X3,X4)
    | esk12779_4(X1,X2,X3,X4) ) ).

cnf(i_0_2736,axiom,
    ( ~ esk9735_4(X1,X2,X3,X4)
    | ~ esk9734_4(X1,X2,X3,X4)
    | ~ esk9694_4(X1,X2,X3,X4) ) ).

cnf(i_0_2737,axiom,
    ( esk7651_4(X1,X2,X3,X4)
    | esk7654_4(X1,X2,X3,X4) ) ).

cnf(i_0_2738,axiom,
    ( ~ esk3318_4(X1,X2,X3,X4)
    | esk3060_4(X1,X2,X3,X4) ) ).

cnf(i_0_2739,axiom,
    ( ~ esk8769_4(X1,X2,X3,X4)
    | ~ esk8771_4(X1,X2,X3,X4) ) ).

cnf(i_0_2740,axiom,
    ( esk12589_4(X1,X2,X3,X4)
    | ~ esk12847_4(X1,X2,X3,X4) ) ).

cnf(i_0_2741,axiom,
    ( esk3025_4(X1,X2,X3,X4)
    | esk3028_4(X1,X2,X3,X4) ) ).

cnf(i_0_2742,axiom,
    ( esk273_0
    | p(X3)
    | p(X1)
    | p(X2)
    | ~ esk16709_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_2743,axiom,
    ( esk12552_4(X1,X2,X3,X4)
    | esk12637_4(X1,X2,X3,X4) ) ).

cnf(i_0_2744,axiom,
    ( esk6752_4(X1,X2,X3,X4)
    | esk6683_4(X1,X2,X3,X4) ) ).

cnf(i_0_2745,axiom,
    ( ~ esk15164_4(X1,X2,X3,X4)
    | ~ esk15162_4(X1,X2,X3,X4)
    | ~ esk15190_4(X1,X2,X3,X4)
    | ~ esk15192_4(X1,X2,X3,X4) ) ).

cnf(i_0_2746,axiom,
    ( ~ esk16683_4(X1,X2,X3,X4)
    | esk90_0
    | ~ p(X1)
    | ~ p(X2)
    | p(X4)
    | p(X3) ) ).

cnf(i_0_2747,axiom,
    ( ~ esk6426_4(X1,X2,X3,X4)
    | ~ esk6495_4(X1,X2,X3,X4)
    | ~ esk6452_4(X1,X2,X3,X4) ) ).

cnf(i_0_2748,axiom,
    ( ~ esk13410_4(X1,X2,X3,X4)
    | esk13409_4(X1,X2,X3,X4)
    | esk13396_4(X1,X2,X3,X4) ) ).

cnf(i_0_2749,axiom,
    ( esk7920_4(X1,X2,X3,X4)
    | esk8032_4(X1,X2,X3,X4) ) ).

cnf(i_0_2750,axiom,
    ( esk14693_4(X1,X2,X3,X4)
    | esk14608_4(X1,X2,X3,X4) ) ).

cnf(i_0_2751,axiom,
    ( esk13296_4(X1,X2,X3,X4)
    | ~ esk13356_4(X1,X2,X3,X4) ) ).

cnf(i_0_2752,axiom,
    ( esk16711_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X4)
    | p(X1)
    | ~ esk291_0
    | ~ p(X3) ) ).

cnf(i_0_2753,axiom,
    ( esk11815_4(X1,X2,X3,X4)
    | esk11853_4(X1,X2,X3,X4)
    | ~ esk11869_4(X1,X2,X3,X4) ) ).

cnf(i_0_2754,axiom,
    ( esk3579_4(X1,X2,X3,X4)
    | esk3635_4(X1,X2,X3,X4) ) ).

cnf(i_0_2755,axiom,
    ( ~ esk15056_4(X1,X2,X3,X4)
    | ~ esk15026_4(X1,X2,X3,X4) ) ).

cnf(i_0_2756,axiom,
    ( ~ esk1013_4(X1,X2,X3,X4)
    | ~ esk1064_4(X1,X2,X3,X4)
    | ~ esk1093_4(X1,X2,X3,X4) ) ).

cnf(i_0_2757,axiom,
    ( esk3284_4(X1,X2,X3,X4)
    | esk3296_4(X1,X2,X3,X4) ) ).

cnf(i_0_2758,axiom,
    ( ~ esk10221_4(X1,X2,X3,X4)
    | ~ esk10265_4(X1,X2,X3,X4)
    | ~ esk10232_4(X1,X2,X3,X4) ) ).

cnf(i_0_2759,axiom,
    ( esk15362_4(X1,X2,X3,X4)
    | esk15363_4(X1,X2,X3,X4)
    | esk15341_4(X1,X2,X3,X4) ) ).

cnf(i_0_2760,axiom,
    ( esk6681_4(X1,X2,X3,X4)
    | ~ esk6558_4(X1,X2,X3,X4) ) ).

cnf(i_0_2761,axiom,
    ( esk3445_4(X1,X2,X3,X4)
    | ~ esk3474_4(X1,X2,X3,X4) ) ).

cnf(i_0_2762,axiom,
    ( esk534_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X2)
    | ~ p(X3)
    | ~ p(X4)
    | ~ esk324_0 ) ).

cnf(i_0_2763,axiom,
    ( ~ esk3734_4(X1,X2,X3,X4)
    | esk3699_4(X1,X2,X3,X4) ) ).

cnf(i_0_2764,axiom,
    ( ~ esk6216_4(X1,X2,X3,X4)
    | esk6215_4(X1,X2,X3,X4) ) ).

cnf(i_0_2765,axiom,
    ( esk14628_4(X1,X2,X3,X4)
    | ~ esk14530_4(X1,X2,X3,X4) ) ).

cnf(i_0_2766,axiom,
    ( esk12596_4(X1,X2,X3,X4)
    | ~ esk12648_4(X1,X2,X3,X4)
    | esk12618_4(X1,X2,X3,X4) ) ).

cnf(i_0_2767,axiom,
    ( esk6127_4(X1,X2,X3,X4)
    | esk6111_4(X1,X2,X3,X4) ) ).

cnf(i_0_2768,axiom,
    ( ~ esk11756_4(X1,X2,X3,X4)
    | esk11810_4(X1,X2,X3,X4) ) ).

cnf(i_0_2769,axiom,
    ( esk7116_4(X1,X2,X3,X4)
    | esk7115_4(X1,X2,X3,X4) ) ).

cnf(i_0_2770,axiom,
    ( esk8285_4(X1,X2,X3,X4)
    | ~ esk8201_4(X1,X2,X3,X4)
    | esk8248_4(X1,X2,X3,X4) ) ).

cnf(i_0_2771,axiom,
    ( ~ p(X3)
    | p(X1)
    | ~ esk16681_4(X1,X2,X3,X4)
    | p(X2)
    | esk65_0
    | p(X4) ) ).

cnf(i_0_2772,axiom,
    ( ~ esk11088_4(X1,X2,X3,X4)
    | ~ esk11090_4(X1,X2,X3,X4) ) ).

cnf(i_0_2773,axiom,
    ( ~ esk1431_4(X1,X2,X3,X4)
    | esk1436_4(X1,X2,X3,X4) ) ).

cnf(i_0_2774,axiom,
    ( ~ esk4140_4(X1,X2,X3,X4)
    | ~ esk4142_4(X1,X2,X3,X4) ) ).

cnf(i_0_2775,axiom,
    ( ~ esk15064_4(X1,X2,X3,X4)
    | esk15070_4(X1,X2,X3,X4) ) ).

cnf(i_0_2776,axiom,
    ( esk5313_4(X1,X2,X3,X4)
    | ~ esk5314_4(X1,X2,X3,X4) ) ).

cnf(i_0_2777,axiom,
    ( esk8629_4(X1,X2,X3,X4)
    | ~ esk8616_4(X1,X2,X3,X4) ) ).

cnf(i_0_2778,axiom,
    ( ~ esk8970_4(X1,X2,X3,X4)
    | ~ esk9017_4(X1,X2,X3,X4)
    | ~ esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_2779,axiom,
    ( ~ esk12222_4(X1,X2,X3,X4)
    | esk12343_4(X1,X2,X3,X4) ) ).

cnf(i_0_2780,axiom,
    ( esk8252_4(X1,X2,X3,X4)
    | esk8254_4(X1,X2,X3,X4)
    | esk8253_4(X1,X2,X3,X4) ) ).

cnf(i_0_2781,axiom,
    ( esk3922_4(X1,X2,X3,X4)
    | ~ esk3921_4(X1,X2,X3,X4) ) ).

cnf(i_0_2782,axiom,
    ( esk15573_4(X1,X2,X3,X4)
    | esk15591_4(X1,X2,X3,X4) ) ).

cnf(i_0_2783,axiom,
    ( esk10778_4(X1,X2,X3,X4)
    | ~ esk10730_4(X1,X2,X3,X4) ) ).

cnf(i_0_2784,axiom,
    ( esk11513_4(X1,X2,X3,X4)
    | esk11503_4(X1,X2,X3,X4) ) ).

cnf(i_0_2785,axiom,
    ( ~ esk5392_4(X1,X2,X3,X4)
    | esk5134_4(X1,X2,X3,X4) ) ).

cnf(i_0_2786,axiom,
    ( esk93_0
    | p(X4)
    | p(X2)
    | ~ esk16685_4(X1,X2,X3,X4)
    | p(X1)
    | p(X3) ) ).

cnf(i_0_2787,axiom,
    ( ~ esk1179_4(X1,X2,X3,X4)
    | esk1174_4(X1,X2,X3,X4)
    | ~ esk1173_4(X1,X2,X3,X4) ) ).

cnf(i_0_2788,axiom,
    ( ~ esk5671_4(X1,X2,X3,X4)
    | esk5544_4(X1,X2,X3,X4)
    | esk5514_4(X1,X2,X3,X4) ) ).

cnf(i_0_2789,axiom,
    ( esk1327_4(X1,X2,X3,X4)
    | ~ esk1276_4(X1,X2,X3,X4) ) ).

cnf(i_0_2790,axiom,
    ( esk10598_4(X1,X2,X3,X4)
    | esk10482_4(X1,X2,X3,X4) ) ).

cnf(i_0_2791,axiom,
    ( esk11198_4(X1,X2,X3,X4)
    | esk11316_4(X1,X2,X3,X4) ) ).

cnf(i_0_2792,axiom,
    ( esk9701_4(X1,X2,X3,X4)
    | ~ esk9752_4(X1,X2,X3,X4) ) ).

cnf(i_0_2793,axiom,
    ( esk10345_4(X1,X2,X3,X4)
    | esk10233_4(X1,X2,X3,X4) ) ).

cnf(i_0_2794,axiom,
    ( esk10580_4(X1,X2,X3,X4)
    | ~ esk10560_4(X1,X2,X3,X4) ) ).

cnf(i_0_2795,axiom,
    ( esk16157_4(X1,X2,X3,X4)
    | esk16190_4(X1,X2,X3,X4) ) ).

cnf(i_0_2796,axiom,
    ( ~ esk4506_4(X1,X2,X3,X4)
    | esk4484_4(X1,X2,X3,X4) ) ).

cnf(i_0_2797,axiom,
    ( esk6366_4(X1,X2,X3,X4)
    | esk6399_4(X1,X2,X3,X4) ) ).

cnf(i_0_2798,axiom,
    ( ~ esk6155_4(X1,X2,X3,X4)
    | ~ esk6203_4(X1,X2,X3,X4) ) ).

cnf(i_0_2799,axiom,
    ( ~ esk9687_4(X1,X2,X3,X4)
    | ~ esk9709_4(X1,X2,X3,X4) ) ).

cnf(i_0_2800,axiom,
    ( esk14118_4(X1,X2,X3,X4)
    | esk14085_4(X1,X2,X3,X4) ) ).

cnf(i_0_2801,axiom,
    ( esk16107_4(X1,X2,X3,X4)
    | ~ esk16087_4(X1,X2,X3,X4) ) ).

cnf(i_0_2802,axiom,
    ( ~ esk9803_4(X1,X2,X3,X4)
    | ~ esk9804_4(X1,X2,X3,X4)
    | ~ esk9829_4(X1,X2,X3,X4) ) ).

cnf(i_0_2803,axiom,
    ( ~ esk3081_4(X1,X2,X3,X4)
    | ~ esk3112_4(X1,X2,X3,X4) ) ).

cnf(i_0_2804,axiom,
    ( ~ esk1928_4(X1,X2,X3,X4)
    | esk2047_4(X1,X2,X3,X4) ) ).

cnf(i_0_2805,axiom,
    ( ~ esk13908_4(X1,X2,X3,X4)
    | esk13927_4(X1,X2,X3,X4)
    | esk13873_4(X1,X2,X3,X4) ) ).

cnf(i_0_2806,axiom,
    ( esk11960_4(X1,X2,X3,X4)
    | ~ esk11936_4(X1,X2,X3,X4) ) ).

cnf(i_0_2807,axiom,
    ( esk7124_4(X1,X2,X3,X4)
    | esk7164_4(X1,X2,X3,X4) ) ).

cnf(i_0_2808,axiom,
    ( ~ esk13852_4(X1,X2,X3,X4)
    | ~ esk13853_4(X1,X2,X3,X4)
    | ~ esk13803_4(X1,X2,X3,X4) ) ).

cnf(i_0_2809,axiom,
    ( esk10286_4(X1,X2,X3,X4)
    | ~ esk10544_4(X1,X2,X3,X4) ) ).

cnf(i_0_2810,axiom,
    ( ~ esk13905_4(X1,X2,X3,X4)
    | ~ esk13904_4(X1,X2,X3,X4) ) ).

cnf(i_0_2811,axiom,
    ( esk12809_4(X1,X2,X3,X4)
    | esk12783_4(X1,X2,X3,X4) ) ).

cnf(i_0_2812,axiom,
    ( ~ esk10808_4(X1,X2,X3,X4)
    | ~ esk10662_4(X1,X2,X3,X4)
    | ~ esk10815_4(X1,X2,X3,X4) ) ).

cnf(i_0_2813,axiom,
    ( esk2360_4(X1,X2,X3,X4)
    | ~ esk2306_4(X1,X2,X3,X4) ) ).

cnf(i_0_2814,axiom,
    ( ~ esk2559_4(X1,X2,X3,X4)
    | esk2301_4(X1,X2,X3,X4) ) ).

cnf(i_0_2815,axiom,
    ( esk7221_4(X1,X2,X3,X4)
    | esk7203_4(X1,X2,X3,X4) ) ).

cnf(i_0_2816,axiom,
    ( p(X1)
    | ~ esk16709_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | esk278_0
    | ~ p(X4) ) ).

cnf(i_0_2817,axiom,
    ( esk6815_4(X1,X2,X3,X4)
    | ~ esk6830_4(X1,X2,X3,X4)
    | ~ esk6938_4(X1,X2,X3,X4) ) ).

cnf(i_0_2818,axiom,
    ( ~ esk10480_4(X1,X2,X3,X4)
    | ~ esk10504_4(X1,X2,X3,X4)
    | ~ esk10610_4(X1,X2,X3,X4) ) ).

cnf(i_0_2819,axiom,
    ( esk8289_4(X1,X2,X3,X4)
    | esk8177_4(X1,X2,X3,X4) ) ).

cnf(i_0_2820,axiom,
    ( ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1290_4(X1,X2,X3,X4)
    | ~ esk1257_4(X1,X2,X3,X4) ) ).

cnf(i_0_2821,axiom,
    ( ~ p(X3)
    | p(X1)
    | esk81_0
    | p(X2)
    | ~ esk16683_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_2822,axiom,
    ( ~ esk12996_4(X1,X2,X3,X4)
    | esk13001_4(X1,X2,X3,X4) ) ).

cnf(i_0_2823,axiom,
    ( esk11984_4(X1,X2,X3,X4)
    | esk11998_4(X1,X2,X3,X4) ) ).

cnf(i_0_2824,axiom,
    ( ~ esk11807_4(X1,X2,X3,X4)
    | ~ esk11774_4(X1,X2,X3,X4)
    | ~ esk11763_4(X1,X2,X3,X4) ) ).

cnf(i_0_2825,axiom,
    ( ~ esk10026_4(X1,X2,X3,X4)
    | ~ esk9993_4(X1,X2,X3,X4)
    | ~ esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_2826,axiom,
    ( esk14535_4(X1,X2,X3,X4)
    | ~ esk14656_4(X1,X2,X3,X4)
    | ~ esk14540_4(X1,X2,X3,X4) ) ).

cnf(i_0_2827,axiom,
    ( ~ esk10773_4(X1,X2,X3,X4)
    | ~ esk10740_4(X1,X2,X3,X4)
    | ~ esk10735_4(X1,X2,X3,X4) ) ).

cnf(i_0_2828,axiom,
    ( esk10676_4(X1,X2,X3,X4)
    | ~ esk10775_4(X1,X2,X3,X4)
    | ~ esk10685_4(X1,X2,X3,X4) ) ).

cnf(i_0_2829,axiom,
    ( esk5902_4(X1,X2,X3,X4)
    | ~ esk5953_4(X1,X2,X3,X4)
    | esk5952_4(X1,X2,X3,X4) ) ).

cnf(i_0_2830,axiom,
    ( esk15152_4(X1,X2,X3,X4)
    | esk15119_4(X1,X2,X3,X4) ) ).

cnf(i_0_2831,axiom,
    ( esk12827_4(X1,X2,X3,X4)
    | esk12794_4(X1,X2,X3,X4) ) ).

cnf(i_0_2832,axiom,
    ( ~ esk12660_4(X1,X2,X3,X4)
    | esk12659_4(X1,X2,X3,X4)
    | esk12628_4(X1,X2,X3,X4) ) ).

cnf(i_0_2833,axiom,
    ( ~ esk15618_4(X1,X2,X3,X4)
    | ~ esk15666_4(X1,X2,X3,X4)
    | ~ esk15633_4(X1,X2,X3,X4) ) ).

cnf(i_0_2834,axiom,
    ( ~ esk8723_4(X1,X2,X3,X4)
    | ~ esk8679_4(X1,X2,X3,X4)
    | ~ esk8690_4(X1,X2,X3,X4) ) ).

cnf(i_0_2835,axiom,
    ( ~ esk12350_4(X1,X2,X3,X4)
    | ~ esk12357_4(X1,X2,X3,X4)
    | ~ esk12204_4(X1,X2,X3,X4) ) ).

cnf(i_0_2836,axiom,
    ( esk16233_4(X1,X2,X3,X4)
    | ~ esk16235_4(X1,X2,X3,X4) ) ).

cnf(i_0_2837,axiom,
    ( ~ esk5281_4(X1,X2,X3,X4)
    | esk5251_4(X1,X2,X3,X4) ) ).

cnf(i_0_2838,axiom,
    ( ~ esk2063_4(X1,X2,X3,X4)
    | esk2114_4(X1,X2,X3,X4) ) ).

cnf(i_0_2839,axiom,
    ( esk1181_4(X1,X2,X3,X4)
    | esk1199_4(X1,X2,X3,X4) ) ).

cnf(i_0_2840,axiom,
    ( ~ esk1941_4(X1,X2,X3,X4)
    | esk1909_4(X1,X2,X3,X4) ) ).

cnf(i_0_2841,axiom,
    ( ~ esk11434_4(X1,X2,X3,X4)
    | esk11454_4(X1,X2,X3,X4) ) ).

cnf(i_0_2842,axiom,
    ( ~ esk16259_4(X1,X2,X3,X4)
    | ~ esk16258_4(X1,X2,X3,X4)
    | esk16260_4(X1,X2,X3,X4) ) ).

cnf(i_0_2843,axiom,
    ( ~ p(X2)
    | ~ esk1_0
    | ~ p(X1)
    | ~ p(X4)
    | ~ p(X3)
    | esk16703_4(X1,X2,X3,X4) ) ).

cnf(i_0_2844,axiom,
    ( esk582_4(X1,X2,X3,X4)
    | ~ esk583_4(X1,X2,X3,X4) ) ).

cnf(i_0_2845,axiom,
    ( ~ esk13788_4(X1,X2,X3,X4)
    | esk13789_4(X1,X2,X3,X4) ) ).

cnf(i_0_2846,axiom,
    ( ~ esk16346_4(X1,X2,X3,X4)
    | ~ esk16347_4(X1,X2,X3,X4) ) ).

cnf(i_0_2847,axiom,
    ( esk8759_4(X1,X2,X3,X4)
    | esk8752_4(X1,X2,X3,X4) ) ).

cnf(i_0_2848,axiom,
    ( ~ esk4999_4(X1,X2,X3,X4)
    | esk5150_4(X1,X2,X3,X4) ) ).

cnf(i_0_2849,axiom,
    ( esk1475_4(X1,X2,X3,X4)
    | esk1501_4(X1,X2,X3,X4) ) ).

cnf(i_0_2850,axiom,
    ( ~ esk4916_4(X1,X2,X3,X4)
    | ~ esk4915_4(X1,X2,X3,X4) ) ).

cnf(i_0_2851,axiom,
    ( esk7704_4(X1,X2,X3,X4)
    | ~ esk7962_4(X1,X2,X3,X4) ) ).

cnf(i_0_2852,axiom,
    ( ~ esk13114_4(X1,X2,X3,X4)
    | ~ esk13112_4(X1,X2,X3,X4)
    | ~ esk13132_4(X1,X2,X3,X4) ) ).

cnf(i_0_2853,axiom,
    ( esk10500_4(X1,X2,X3,X4)
    | esk10480_4(X1,X2,X3,X4) ) ).

cnf(i_0_2854,axiom,
    ( ~ esk12605_4(X1,X2,X3,X4)
    | esk12863_4(X1,X2,X3,X4) ) ).

cnf(i_0_2855,axiom,
    ( esk15877_4(X1,X2,X3,X4)
    | esk15899_4(X1,X2,X3,X4) ) ).

cnf(i_0_2856,axiom,
    ( ~ esk4881_4(X1,X2,X3,X4)
    | esk5139_4(X1,X2,X3,X4) ) ).

cnf(i_0_2857,axiom,
    ( esk4173_4(X1,X2,X3,X4)
    | esk4136_4(X1,X2,X3,X4)
    | ~ esk4089_4(X1,X2,X3,X4) ) ).

cnf(i_0_2858,axiom,
    ( ~ esk13900_4(X1,X2,X3,X4)
    | esk13937_4(X1,X2,X3,X4) ) ).

cnf(i_0_2859,axiom,
    ( esk14560_4(X1,X2,X3,X4)
    | ~ esk14548_4(X1,X2,X3,X4) ) ).

cnf(i_0_2860,axiom,
    ( esk13522_4(X1,X2,X3,X4)
    | ~ esk13264_4(X1,X2,X3,X4) ) ).

cnf(i_0_2861,axiom,
    ( esk6913_4(X1,X2,X3,X4)
    | esk6880_4(X1,X2,X3,X4) ) ).

cnf(i_0_2862,axiom,
    ( ~ esk14632_4(X1,X2,X3,X4)
    | ~ esk14540_4(X1,X2,X3,X4)
    | esk14532_4(X1,X2,X3,X4) ) ).

cnf(i_0_2863,axiom,
    ( esk163_0
    | ~ p(X4)
    | ~ p(X3)
    | p(X2)
    | ~ p(X1)
    | ~ esk503_4(X1,X2,X3,X4) ) ).

cnf(i_0_2864,axiom,
    ( ~ esk3379_4(X1,X2,X3,X4)
    | ~ esk3377_4(X1,X2,X3,X4)
    | ~ esk3324_4(X1,X2,X3,X4)
    | ~ esk3326_4(X1,X2,X3,X4) ) ).

cnf(i_0_2865,axiom,
    ( ~ esk15412_4(X1,X2,X3,X4)
    | esk15352_4(X1,X2,X3,X4) ) ).

cnf(i_0_2866,axiom,
    ( esk13585_4(X1,X2,X3,X4)
    | esk13551_4(X1,X2,X3,X4) ) ).

cnf(i_0_2867,axiom,
    ( esk691_4(X1,X2,X3,X4)
    | ~ esk687_4(X1,X2,X3,X4)
    | esk667_4(X1,X2,X3,X4) ) ).

cnf(i_0_2868,axiom,
    ( ~ esk14435_4(X1,X2,X3,X4)
    | ~ esk14434_4(X1,X2,X3,X4)
    | esk14436_4(X1,X2,X3,X4) ) ).

cnf(i_0_2869,axiom,
    ( esk15632_4(X1,X2,X3,X4)
    | esk15612_4(X1,X2,X3,X4) ) ).

cnf(i_0_2870,axiom,
    ( esk8926_4(X1,X2,X3,X4)
    | ~ esk8989_4(X1,X2,X3,X4) ) ).

cnf(i_0_2871,axiom,
    ( ~ esk2512_4(X1,X2,X3,X4)
    | ~ esk2457_4(X1,X2,X3,X4) ) ).

cnf(i_0_2872,axiom,
    ( ~ esk8290_4(X1,X2,X3,X4)
    | ~ esk8258_4(X1,X2,X3,X4) ) ).

cnf(i_0_2873,axiom,
    ( ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14097_4(X1,X2,X3,X4)
    | ~ esk14130_4(X1,X2,X3,X4) ) ).

cnf(i_0_2874,axiom,
    ( esk5821_4(X1,X2,X3,X4)
    | esk5816_4(X1,X2,X3,X4) ) ).

cnf(i_0_2875,axiom,
    ( esk7424_4(X1,X2,X3,X4)
    | esk7396_4(X1,X2,X3,X4) ) ).

cnf(i_0_2876,axiom,
    ( esk14333_4(X1,X2,X3,X4)
    | esk14344_4(X1,X2,X3,X4) ) ).

cnf(i_0_2877,axiom,
    ( esk11248_4(X1,X2,X3,X4)
    | esk11253_4(X1,X2,X3,X4) ) ).

cnf(i_0_2878,axiom,
    ( esk5324_4(X1,X2,X3,X4)
    | ~ esk5399_4(X1,X2,X3,X4) ) ).

cnf(i_0_2879,axiom,
    ( ~ esk16573_4(X1,X2,X3,X4)
    | ~ esk16726_4(X1,X2,X3,X4)
    | ~ esk16719_4(X1,X2,X3,X4) ) ).

cnf(i_0_2880,axiom,
    ( ~ esk12696_4(X1,X2,X3,X4)
    | esk12727_4(X1,X2,X3,X4) ) ).

cnf(i_0_2881,axiom,
    ( ~ esk6238_4(X1,X2,X3,X4)
    | ~ esk6167_4(X1,X2,X3,X4)
    | ~ esk6219_4(X1,X2,X3,X4) ) ).

cnf(i_0_2882,axiom,
    ( esk3127_4(X1,X2,X3,X4)
    | ~ esk3128_4(X1,X2,X3,X4) ) ).

cnf(i_0_2883,axiom,
    ( ~ esk7352_4(X1,X2,X3,X4)
    | ~ esk7356_4(X1,X2,X3,X4) ) ).

cnf(i_0_2884,axiom,
    ( ~ esk4374_4(X1,X2,X3,X4)
    | esk4116_4(X1,X2,X3,X4) ) ).

cnf(i_0_2885,axiom,
    ( esk9181_4(X1,X2,X3,X4)
    | esk9218_4(X1,X2,X3,X4) ) ).

cnf(i_0_2886,axiom,
    ( ~ esk13781_4(X1,X2,X3,X4)
    | esk13765_4(X1,X2,X3,X4)
    | ~ esk13801_4(X1,X2,X3,X4) ) ).

cnf(i_0_2887,axiom,
    ( esk7460_4(X1,X2,X3,X4)
    | esk7475_4(X1,X2,X3,X4) ) ).

cnf(i_0_2888,axiom,
    ( ~ esk4788_4(X1,X2,X3,X4)
    | ~ esk4787_4(X1,X2,X3,X4) ) ).

cnf(i_0_2889,axiom,
    ( esk7970_4(X1,X2,X3,X4)
    | ~ esk7845_4(X1,X2,X3,X4) ) ).

cnf(i_0_2890,axiom,
    ( ~ esk8288_4(X1,X2,X3,X4)
    | esk8295_4(X1,X2,X3,X4)
    | esk8207_4(X1,X2,X3,X4) ) ).

cnf(i_0_2891,axiom,
    ( esk5711_4(X1,X2,X3,X4)
    | esk5659_4(X1,X2,X3,X4) ) ).

cnf(i_0_2892,axiom,
    ( ~ esk12506_4(X1,X2,X3,X4)
    | esk12490_4(X1,X2,X3,X4) ) ).

cnf(i_0_2893,axiom,
    ( esk15846_4(X1,X2,X3,X4)
    | ~ esk15832_4(X1,X2,X3,X4) ) ).

cnf(i_0_2894,axiom,
    ( ~ esk9528_4(X1,X2,X3,X4)
    | esk9786_4(X1,X2,X3,X4) ) ).

cnf(i_0_2895,axiom,
    ( esk4317_4(X1,X2,X3,X4)
    | esk4350_4(X1,X2,X3,X4) ) ).

cnf(i_0_2896,axiom,
    ( ~ esk4503_4(X1,X2,X3,X4)
    | esk4517_4(X1,X2,X3,X4) ) ).

cnf(i_0_2897,axiom,
    ( ~ esk2624_4(X1,X2,X3,X4)
    | ~ esk2625_4(X1,X2,X3,X4)
    | esk2626_4(X1,X2,X3,X4) ) ).

cnf(i_0_2898,axiom,
    ( esk2239_4(X1,X2,X3,X4)
    | ~ esk2317_4(X1,X2,X3,X4) ) ).

cnf(i_0_2899,axiom,
    ( esk14563_4(X1,X2,X3,X4)
    | ~ esk14564_4(X1,X2,X3,X4)
    | esk14568_4(X1,X2,X3,X4) ) ).

cnf(i_0_2900,axiom,
    ( esk13787_4(X1,X2,X3,X4)
    | ~ esk13785_4(X1,X2,X3,X4)
    | ~ esk13786_4(X1,X2,X3,X4) ) ).

cnf(i_0_2901,axiom,
    ( esk13863_4(X1,X2,X3,X4)
    | esk13914_4(X1,X2,X3,X4)
    | ~ esk13943_4(X1,X2,X3,X4) ) ).

cnf(i_0_2902,axiom,
    ( esk4826_4(X1,X2,X3,X4)
    | esk4858_4(X1,X2,X3,X4) ) ).

cnf(i_0_2903,axiom,
    ( esk2850_4(X1,X2,X3,X4)
    | esk2868_4(X1,X2,X3,X4) ) ).

cnf(i_0_2904,axiom,
    ( esk16132_4(X1,X2,X3,X4)
    | esk16153_4(X1,X2,X3,X4) ) ).

cnf(i_0_2905,axiom,
    ( ~ esk971_4(X1,X2,X3,X4)
    | ~ esk1001_4(X1,X2,X3,X4)
    | ~ esk1088_4(X1,X2,X3,X4) ) ).

cnf(i_0_2906,axiom,
    ( ~ esk10550_4(X1,X2,X3,X4)
    | ~ esk10461_4(X1,X2,X3,X4) ) ).

cnf(i_0_2907,axiom,
    ( ~ esk16347_4(X1,X2,X3,X4)
    | esk16359_4(X1,X2,X3,X4) ) ).

cnf(i_0_2908,axiom,
    ( ~ esk3963_4(X1,X2,X3,X4)
    | esk3984_4(X1,X2,X3,X4) ) ).

cnf(i_0_2909,axiom,
    ( esk6442_4(X1,X2,X3,X4)
    | ~ esk6315_4(X1,X2,X3,X4) ) ).

cnf(i_0_2910,axiom,
    ( ~ esk2765_4(X1,X2,X3,X4)
    | ~ esk2775_4(X1,X2,X3,X4)
    | ~ esk2776_4(X1,X2,X3,X4) ) ).

cnf(i_0_2911,axiom,
    ( esk8229_4(X1,X2,X3,X4)
    | esk8281_4(X1,X2,X3,X4) ) ).

cnf(i_0_2912,axiom,
    ( esk4510_4(X1,X2,X3,X4)
    | ~ esk4480_4(X1,X2,X3,X4) ) ).

cnf(i_0_2913,axiom,
    ( esk5083_4(X1,X2,X3,X4)
    | esk5113_4(X1,X2,X3,X4) ) ).

cnf(i_0_2914,axiom,
    ( ~ esk2745_4(X1,X2,X3,X4)
    | esk2747_4(X1,X2,X3,X4) ) ).

cnf(i_0_2915,axiom,
    ( esk16714_4(X1,X2,X3,X4)
    | ~ esk16713_4(X1,X2,X3,X4) ) ).

cnf(i_0_2916,axiom,
    ( esk12772_4(X1,X2,X3,X4)
    | esk12870_4(X1,X2,X3,X4) ) ).

cnf(i_0_2917,axiom,
    ( esk13623_4(X1,X2,X3,X4)
    | ~ esk13548_4(X1,X2,X3,X4) ) ).

cnf(i_0_2918,axiom,
    ( esk2381_4(X1,X2,X3,X4)
    | ~ esk2347_4(X1,X2,X3,X4) ) ).

cnf(i_0_2919,axiom,
    ( esk13141_4(X1,X2,X3,X4)
    | ~ esk13175_4(X1,X2,X3,X4)
    | esk13094_4(X1,X2,X3,X4) ) ).

cnf(i_0_2920,axiom,
    ( esk8517_4(X1,X2,X3,X4)
    | ~ esk8466_4(X1,X2,X3,X4)
    | esk8546_4(X1,X2,X3,X4) ) ).

cnf(i_0_2921,axiom,
    ( ~ esk55_0
    | esk433_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X3)
    | p(X4)
    | p(X2) ) ).

cnf(i_0_2922,axiom,
    ( ~ esk11857_4(X1,X2,X3,X4)
    | ~ esk11858_4(X1,X2,X3,X4) ) ).

cnf(i_0_2923,axiom,
    ( esk7942_4(X1,X2,X3,X4)
    | esk7910_4(X1,X2,X3,X4) ) ).

cnf(i_0_2924,axiom,
    ( ~ esk9022_4(X1,X2,X3,X4)
    | esk9047_4(X1,X2,X3,X4)
    | esk8996_4(X1,X2,X3,X4) ) ).

cnf(i_0_2925,axiom,
    ( esk9946_4(X1,X2,X3,X4)
    | ~ esk9910_4(X1,X2,X3,X4) ) ).

cnf(i_0_2926,axiom,
    ( ~ esk10018_4(X1,X2,X3,X4)
    | ~ esk10072_4(X1,X2,X3,X4)
    | ~ esk10053_4(X1,X2,X3,X4) ) ).

cnf(i_0_2927,axiom,
    ( ~ esk11983_4(X1,X2,X3,X4)
    | ~ esk11984_4(X1,X2,X3,X4) ) ).

cnf(i_0_2928,axiom,
    ( esk1198_4(X1,X2,X3,X4)
    | ~ esk1182_4(X1,X2,X3,X4) ) ).

cnf(i_0_2929,axiom,
    ( esk3351_4(X1,X2,X3,X4)
    | ~ esk3231_4(X1,X2,X3,X4) ) ).

cnf(i_0_2930,axiom,
    ( esk5205_4(X1,X2,X3,X4)
    | esk5093_4(X1,X2,X3,X4) ) ).

cnf(i_0_2931,axiom,
    ( ~ esk16648_4(X1,X2,X3,X4)
    | ~ esk16672_4(X1,X2,X3,X4)
    | ~ esk16778_4(X1,X2,X3,X4) ) ).

cnf(i_0_2932,axiom,
    ( ~ esk2778_4(X1,X2,X3,X4)
    | ~ esk2764_4(X1,X2,X3,X4)
    | ~ esk2777_4(X1,X2,X3,X4) ) ).

cnf(i_0_2933,axiom,
    ( esk10722_4(X1,X2,X3,X4)
    | esk10762_4(X1,X2,X3,X4) ) ).

cnf(i_0_2934,axiom,
    ( esk958_4(X1,X2,X3,X4)
    | ~ esk1024_4(X1,X2,X3,X4) ) ).

cnf(i_0_2935,axiom,
    ( ~ esk1230_4(X1,X2,X3,X4)
    | ~ esk1346_4(X1,X2,X3,X4)
    | ~ esk1228_4(X1,X2,X3,X4) ) ).

cnf(i_0_2936,axiom,
    ( esk4112_4(X1,X2,X3,X4)
    | ~ esk4040_4(X1,X2,X3,X4) ) ).

cnf(i_0_2937,axiom,
    ( ~ esk3587_4(X1,X2,X3,X4)
    | esk3638_4(X1,X2,X3,X4)
    | esk3631_4(X1,X2,X3,X4) ) ).

cnf(i_0_2938,axiom,
    ( ~ esk3071_4(X1,X2,X3,X4)
    | ~ esk3119_4(X1,X2,X3,X4) ) ).

cnf(i_0_2939,axiom,
    ( esk6966_4(X1,X2,X3,X4)
    | ~ esk6940_4(X1,X2,X3,X4)
    | esk6991_4(X1,X2,X3,X4) ) ).

cnf(i_0_2940,axiom,
    ( esk13852_4(X1,X2,X3,X4)
    | esk13885_4(X1,X2,X3,X4) ) ).

cnf(i_0_2941,axiom,
    ( ~ esk4812_4(X1,X2,X3,X4)
    | ~ esk4849_4(X1,X2,X3,X4)
    | ~ esk4850_4(X1,X2,X3,X4) ) ).

cnf(i_0_2942,axiom,
    ( esk14645_4(X1,X2,X3,X4)
    | ~ esk14579_4(X1,X2,X3,X4) ) ).

cnf(i_0_2943,axiom,
    ( esk11329_4(X1,X2,X3,X4)
    | esk11328_4(X1,X2,X3,X4) ) ).

cnf(i_0_2944,axiom,
    ( esk8285_4(X1,X2,X3,X4)
    | esk8169_4(X1,X2,X3,X4) ) ).

cnf(i_0_2945,axiom,
    ( ~ esk4363_4(X1,X2,X3,X4)
    | esk4621_4(X1,X2,X3,X4) ) ).

cnf(i_0_2946,axiom,
    ( ~ esk11200_4(X1,X2,X3,X4)
    | ~ esk11202_4(X1,X2,X3,X4) ) ).

cnf(i_0_2947,axiom,
    ( esk5045_4(X1,X2,X3,X4)
    | esk5036_4(X1,X2,X3,X4) ) ).

cnf(i_0_2948,axiom,
    ( esk8947_4(X1,X2,X3,X4)
    | esk8980_4(X1,X2,X3,X4) ) ).

cnf(i_0_2949,axiom,
    ( esk989_4(X1,X2,X3,X4)
    | esk971_4(X1,X2,X3,X4) ) ).

cnf(i_0_2950,axiom,
    ( esk9367_4(X1,X2,X3,X4)
    | ~ esk9389_4(X1,X2,X3,X4) ) ).

cnf(i_0_2951,axiom,
    ( ~ esk1436_4(X1,X2,X3,X4)
    | ~ esk1434_4(X1,X2,X3,X4) ) ).

cnf(i_0_2952,axiom,
    ( ~ esk3232_4(X1,X2,X3,X4)
    | esk3219_4(X1,X2,X3,X4)
    | ~ esk3344_4(X1,X2,X3,X4) ) ).

cnf(i_0_2953,axiom,
    ( esk13234_4(X1,X2,X3,X4)
    | ~ esk13286_4(X1,X2,X3,X4) ) ).

cnf(i_0_2954,axiom,
    ( ~ esk11879_4(X1,X2,X3,X4)
    | esk11880_4(X1,X2,X3,X4) ) ).

cnf(i_0_2955,axiom,
    ( ~ esk6196_4(X1,X2,X3,X4)
    | ~ esk6218_4(X1,X2,X3,X4)
    | ~ esk6197_4(X1,X2,X3,X4) ) ).

cnf(i_0_2956,axiom,
    ( ~ esk11485_4(X1,X2,X3,X4)
    | ~ esk11484_4(X1,X2,X3,X4) ) ).

cnf(i_0_2957,axiom,
    ( esk16632_4(X1,X2,X3,X4)
    | esk16676_4(X1,X2,X3,X4) ) ).

cnf(i_0_2958,axiom,
    ( ~ esk1797_4(X1,X2,X3,X4)
    | esk2055_4(X1,X2,X3,X4) ) ).

cnf(i_0_2959,axiom,
    ( esk15611_4(X1,X2,X3,X4)
    | esk15634_4(X1,X2,X3,X4) ) ).

cnf(i_0_2960,axiom,
    ( ~ esk11456_4(X1,X2,X3,X4)
    | esk11459_4(X1,X2,X3,X4) ) ).

cnf(i_0_2961,axiom,
    ( esk15692_4(X1,X2,X3,X4)
    | ~ esk15693_4(X1,X2,X3,X4)
    | esk15691_4(X1,X2,X3,X4) ) ).

cnf(i_0_2962,axiom,
    ( ~ esk1228_4(X1,X2,X3,X4)
    | ~ esk1234_4(X1,X2,X3,X4)
    | ~ esk1348_4(X1,X2,X3,X4) ) ).

cnf(i_0_2963,axiom,
    ( esk12086_4(X1,X2,X3,X4)
    | esk12101_4(X1,X2,X3,X4) ) ).

cnf(i_0_2964,axiom,
    ( ~ esk2770_4(X1,X2,X3,X4)
    | ~ esk2875_4(X1,X2,X3,X4)
    | ~ esk2788_4(X1,X2,X3,X4) ) ).

cnf(i_0_2965,axiom,
    ( ~ esk11113_4(X1,X2,X3,X4)
    | esk11090_4(X1,X2,X3,X4)
    | esk11030_4(X1,X2,X3,X4) ) ).

cnf(i_0_2966,axiom,
    ( esk13096_4(X1,X2,X3,X4)
    | ~ esk13140_4(X1,X2,X3,X4)
    | esk13147_4(X1,X2,X3,X4) ) ).

cnf(i_0_2967,axiom,
    ( p(X2)
    | ~ esk1_0
    | p(X4)
    | esk493_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1) ) ).

cnf(i_0_2968,axiom,
    ( ~ esk5790_4(X1,X2,X3,X4)
    | esk5755_4(X1,X2,X3,X4) ) ).

cnf(i_0_2969,axiom,
    ( ~ esk2003_4(X1,X2,X3,X4)
    | ~ esk1995_4(X1,X2,X3,X4)
    | ~ esk2002_4(X1,X2,X3,X4) ) ).

cnf(i_0_2970,axiom,
    ( esk13082_4(X1,X2,X3,X4)
    | esk13032_4(X1,X2,X3,X4) ) ).

cnf(i_0_2971,axiom,
    ( esk13173_4(X1,X2,X3,X4)
    | esk13141_4(X1,X2,X3,X4) ) ).

cnf(i_0_2972,axiom,
    ( ~ esk7499_4(X1,X2,X3,X4)
    | esk7498_4(X1,X2,X3,X4)
    | esk7485_4(X1,X2,X3,X4) ) ).

cnf(i_0_2973,axiom,
    ( esk3565_4(X1,X2,X3,X4)
    | esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_2974,axiom,
    ( ~ p(X3)
    | esk1_0
    | ~ esk16697_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X1)
    | ~ p(X2) ) ).

cnf(i_0_2975,axiom,
    ( p(X4)
    | p(X1)
    | ~ p(X2)
    | esk143_0
    | ~ p(X3)
    | ~ esk501_4(X1,X2,X3,X4) ) ).

cnf(i_0_2976,axiom,
    ( ~ esk7826_4(X1,X2,X3,X4)
    | esk7977_4(X1,X2,X3,X4) ) ).

cnf(i_0_2977,axiom,
    ( esk10060_4(X1,X2,X3,X4)
    | ~ esk10061_4(X1,X2,X3,X4)
    | esk10086_4(X1,X2,X3,X4) ) ).

cnf(i_0_2978,axiom,
    ( esk13920_4(X1,X2,X3,X4)
    | ~ esk13922_4(X1,X2,X3,X4) ) ).

cnf(i_0_2979,axiom,
    ( esk14466_4(X1,X2,X3,X4)
    | esk14456_4(X1,X2,X3,X4) ) ).

cnf(i_0_2980,axiom,
    ( ~ esk14336_4(X1,X2,X3,X4)
    | ~ esk14337_4(X1,X2,X3,X4)
    | ~ esk14332_4(X1,X2,X3,X4) ) ).

cnf(i_0_2981,axiom,
    ( esk11520_4(X1,X2,X3,X4)
    | esk11508_4(X1,X2,X3,X4) ) ).

cnf(i_0_2982,axiom,
    ( esk11315_4(X1,X2,X3,X4)
    | esk11333_4(X1,X2,X3,X4) ) ).

cnf(i_0_2983,axiom,
    ( ~ esk15054_4(X1,X2,X3,X4)
    | ~ esk15160_4(X1,X2,X3,X4)
    | esk15038_4(X1,X2,X3,X4) ) ).

cnf(i_0_2984,axiom,
    ( ~ esk6623_4(X1,X2,X3,X4)
    | ~ esk6569_4(X1,X2,X3,X4) ) ).

cnf(i_0_2985,axiom,
    ( esk5277_4(X1,X2,X3,X4)
    | ~ esk5374_4(X1,X2,X3,X4)
    | ~ esk5288_4(X1,X2,X3,X4) ) ).

cnf(i_0_2986,axiom,
    ( ~ esk10185_4(X1,X2,X3,X4)
    | esk10192_4(X1,X2,X3,X4) ) ).

cnf(i_0_2987,axiom,
    ( ~ esk2983_4(X1,X2,X3,X4)
    | ~ esk2982_4(X1,X2,X3,X4) ) ).

cnf(i_0_2988,axiom,
    ( esk2975_4(X1,X2,X3,X4)
    | ~ esk2966_4(X1,X2,X3,X4) ) ).

cnf(i_0_2989,axiom,
    ( ~ esk10329_4(X1,X2,X3,X4)
    | esk10275_4(X1,X2,X3,X4)
    | esk10310_4(X1,X2,X3,X4) ) ).

cnf(i_0_2990,axiom,
    ( esk13592_4(X1,X2,X3,X4)
    | esk13564_4(X1,X2,X3,X4) ) ).

cnf(i_0_2991,axiom,
    ( esk15195_4(X1,X2,X3,X4)
    | esk15186_4(X1,X2,X3,X4)
    | esk15194_4(X1,X2,X3,X4) ) ).

cnf(i_0_2992,axiom,
    ( esk9771_4(X1,X2,X3,X4)
    | esk9738_4(X1,X2,X3,X4) ) ).

cnf(i_0_2993,axiom,
    ( ~ esk11830_4(X1,X2,X3,X4)
    | esk11831_4(X1,X2,X3,X4) ) ).

cnf(i_0_2994,axiom,
    ( esk5080_4(X1,X2,X3,X4)
    | esk5085_4(X1,X2,X3,X4) ) ).

cnf(i_0_2995,axiom,
    ( ~ esk12347_4(X1,X2,X3,X4)
    | esk12346_4(X1,X2,X3,X4) ) ).

cnf(i_0_2996,axiom,
    ( esk4936_4(X1,X2,X3,X4)
    | ~ esk4937_4(X1,X2,X3,X4)
    | esk4909_4(X1,X2,X3,X4) ) ).

cnf(i_0_2997,axiom,
    ( ~ esk15067_4(X1,X2,X3,X4)
    | ~ esk15062_4(X1,X2,X3,X4) ) ).

cnf(i_0_2998,axiom,
    ( ~ esk6212_4(X1,X2,X3,X4)
    | esk6211_4(X1,X2,X3,X4) ) ).

cnf(i_0_2999,axiom,
    ( esk11562_4(X1,X2,X3,X4)
    | ~ esk11304_4(X1,X2,X3,X4) ) ).

cnf(i_0_3000,axiom,
    ( ~ esk6858_4(X1,X2,X3,X4)
    | ~ esk6859_4(X1,X2,X3,X4) ) ).

cnf(i_0_3001,axiom,
    ( ~ esk4053_4(X1,X2,X3,X4)
    | ~ esk4082_4(X1,X2,X3,X4)
    | ~ esk4115_4(X1,X2,X3,X4) ) ).

cnf(i_0_3002,axiom,
    ( ~ esk4769_4(X1,X2,X3,X4)
    | esk4726_4(X1,X2,X3,X4) ) ).

cnf(i_0_3003,axiom,
    ( ~ esk4835_4(X1,X2,X3,X4)
    | ~ esk4824_4(X1,X2,X3,X4)
    | ~ esk4868_4(X1,X2,X3,X4) ) ).

cnf(i_0_3004,axiom,
    ( ~ esk14412_4(X1,X2,X3,X4)
    | ~ esk14413_4(X1,X2,X3,X4) ) ).

cnf(i_0_3005,axiom,
    ( esk4640_4(X1,X2,X3,X4)
    | esk4494_4(X1,X2,X3,X4) ) ).

cnf(i_0_3006,axiom,
    ( esk6857_4(X1,X2,X3,X4)
    | ~ esk6859_4(X1,X2,X3,X4) ) ).

cnf(i_0_3007,axiom,
    ( ~ p(X2)
    | esk513_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ esk233_0
    | p(X1)
    | p(X4) ) ).

cnf(i_0_3008,axiom,
    ( esk6695_4(X1,X2,X3,X4)
    | esk6690_4(X1,X2,X3,X4)
    | ~ esk6691_4(X1,X2,X3,X4) ) ).

cnf(i_0_3009,axiom,
    ( esk4911_4(X1,X2,X3,X4)
    | ~ esk4933_4(X1,X2,X3,X4)
    | esk4912_4(X1,X2,X3,X4) ) ).

cnf(i_0_3010,axiom,
    ( esk8914_4(X1,X2,X3,X4)
    | ~ esk8656_4(X1,X2,X3,X4) ) ).

cnf(i_0_3011,axiom,
    ( esk67_0
    | p(X1)
    | p(X3)
    | ~ p(X2)
    | p(X4)
    | ~ esk16681_4(X1,X2,X3,X4) ) ).

cnf(i_0_3012,axiom,
    ( esk11587_4(X1,X2,X3,X4)
    | esk11570_4(X1,X2,X3,X4)
    | ~ esk11624_4(X1,X2,X3,X4) ) ).

cnf(i_0_3013,axiom,
    ( esk7913_4(X1,X2,X3,X4)
    | esk7946_4(X1,X2,X3,X4) ) ).

cnf(i_0_3014,axiom,
    ( ~ esk11256_4(X1,X2,X3,X4)
    | ~ esk11246_4(X1,X2,X3,X4)
    | ~ esk11257_4(X1,X2,X3,X4) ) ).

cnf(i_0_3015,axiom,
    ( esk11181_4(X1,X2,X3,X4)
    | ~ esk11199_4(X1,X2,X3,X4)
    | ~ esk11301_4(X1,X2,X3,X4) ) ).

cnf(i_0_3016,axiom,
    ( esk2225_4(X1,X2,X3,X4)
    | ~ esk2211_4(X1,X2,X3,X4) ) ).

cnf(i_0_3017,axiom,
    ( esk11008_4(X1,X2,X3,X4)
    | esk11091_4(X1,X2,X3,X4) ) ).

cnf(i_0_3018,axiom,
    ( esk9836_4(X1,X2,X3,X4)
    | esk9767_4(X1,X2,X3,X4) ) ).

cnf(i_0_3019,axiom,
    ( esk1023_4(X1,X2,X3,X4)
    | esk1077_4(X1,X2,X3,X4)
    | ~ esk1058_4(X1,X2,X3,X4) ) ).

cnf(i_0_3020,axiom,
    ( esk13656_4(X1,X2,X3,X4)
    | esk13608_4(X1,X2,X3,X4) ) ).

cnf(i_0_3021,axiom,
    ( ~ esk3035_4(X1,X2,X3,X4)
    | ~ esk3027_4(X1,X2,X3,X4)
    | ~ esk3158_4(X1,X2,X3,X4) ) ).

cnf(i_0_3022,axiom,
    ( esk14333_4(X1,X2,X3,X4)
    | esk14362_4(X1,X2,X3,X4) ) ).

cnf(i_0_3023,axiom,
    ( esk15168_4(X1,X2,X3,X4)
    | ~ esk15222_4(X1,X2,X3,X4)
    | esk15185_4(X1,X2,X3,X4) ) ).

cnf(i_0_3024,axiom,
    ( esk10520_4(X1,X2,X3,X4)
    | ~ esk10262_4(X1,X2,X3,X4) ) ).

cnf(i_0_3025,axiom,
    ( ~ esk7007_4(X1,X2,X3,X4)
    | esk7008_4(X1,X2,X3,X4)
    | ~ esk7006_4(X1,X2,X3,X4) ) ).

cnf(i_0_3026,axiom,
    ( esk2478_4(X1,X2,X3,X4)
    | ~ esk2472_4(X1,X2,X3,X4) ) ).

cnf(i_0_3027,axiom,
    ( esk7240_4(X1,X2,X3,X4)
    | esk7155_4(X1,X2,X3,X4) ) ).

cnf(i_0_3028,axiom,
    ( esk9494_4(X1,X2,X3,X4)
    | esk9574_4(X1,X2,X3,X4)
    | ~ esk9545_4(X1,X2,X3,X4) ) ).

cnf(i_0_3029,axiom,
    ( ~ esk13777_4(X1,X2,X3,X4)
    | esk13789_4(X1,X2,X3,X4) ) ).

cnf(i_0_3030,axiom,
    ( esk8144_4(X1,X2,X3,X4)
    | esk8143_4(X1,X2,X3,X4) ) ).

cnf(i_0_3031,axiom,
    ( ~ esk15701_4(X1,X2,X3,X4)
    | esk15656_4(X1,X2,X3,X4) ) ).

cnf(i_0_3032,axiom,
    ( ~ esk11212_4(X1,X2,X3,X4)
    | ~ esk11214_4(X1,X2,X3,X4) ) ).

cnf(i_0_3033,axiom,
    ( ~ esk12793_4(X1,X2,X3,X4)
    | ~ esk12792_4(X1,X2,X3,X4) ) ).

cnf(i_0_3034,axiom,
    ( ~ esk14429_4(X1,X2,X3,X4)
    | ~ esk14373_4(X1,X2,X3,X4) ) ).

cnf(i_0_3035,axiom,
    ( esk5630_4(X1,X2,X3,X4)
    | ~ esk5888_4(X1,X2,X3,X4) ) ).

cnf(i_0_3036,axiom,
    ( esk9568_4(X1,X2,X3,X4)
    | ~ esk9569_4(X1,X2,X3,X4) ) ).

cnf(i_0_3037,axiom,
    ( esk11671_4(X1,X2,X3,X4)
    | ~ esk11696_4(X1,X2,X3,X4) ) ).

cnf(i_0_3038,axiom,
    ( ~ esk14577_4(X1,X2,X3,X4)
    | ~ esk14618_4(X1,X2,X3,X4)
    | ~ esk14617_4(X1,X2,X3,X4) ) ).

cnf(i_0_3039,axiom,
    ( esk8763_4(X1,X2,X3,X4)
    | esk8791_4(X1,X2,X3,X4) ) ).

cnf(i_0_3040,axiom,
    ( ~ esk14263_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4) ) ).

cnf(i_0_3041,axiom,
    ( ~ esk11595_4(X1,X2,X3,X4)
    | ~ esk11593_4(X1,X2,X3,X4) ) ).

cnf(i_0_3042,axiom,
    ( ~ esk10179_4(X1,X2,X3,X4)
    | ~ esk10178_4(X1,X2,X3,X4) ) ).

cnf(i_0_3043,axiom,
    ( esk772_4(X1,X2,X3,X4)
    | esk798_4(X1,X2,X3,X4)
    | ~ esk823_4(X1,X2,X3,X4) ) ).

cnf(i_0_3044,axiom,
    ( esk16602_4(X1,X2,X3,X4)
    | ~ esk26_0
    | p(X2)
    | ~ p(X1)
    | p(X3)
    | p(X4) ) ).

cnf(i_0_3045,axiom,
    ( ~ p(X1)
    | esk16697_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | ~ esk195_0
    | p(X4) ) ).

cnf(i_0_3046,axiom,
    ( esk14590_4(X1,X2,X3,X4)
    | esk14597_4(X1,X2,X3,X4) ) ).

cnf(i_0_3047,axiom,
    ( ~ esk9814_4(X1,X2,X3,X4)
    | esk9813_4(X1,X2,X3,X4) ) ).

cnf(i_0_3048,axiom,
    ( esk11857_4(X1,X2,X3,X4)
    | esk11856_4(X1,X2,X3,X4)
    | esk11858_4(X1,X2,X3,X4) ) ).

cnf(i_0_3049,axiom,
    ( ~ esk16183_4(X1,X2,X3,X4)
    | esk16441_4(X1,X2,X3,X4) ) ).

cnf(i_0_3050,axiom,
    ( esk10574_4(X1,X2,X3,X4)
    | esk10518_4(X1,X2,X3,X4) ) ).

cnf(i_0_3051,axiom,
    ( esk1740_4(X1,X2,X3,X4)
    | esk1751_4(X1,X2,X3,X4) ) ).

cnf(i_0_3052,axiom,
    ( esk9442_4(X1,X2,X3,X4)
    | esk9467_4(X1,X2,X3,X4) ) ).

cnf(i_0_3053,axiom,
    ( esk13788_4(X1,X2,X3,X4)
    | ~ esk13789_4(X1,X2,X3,X4)
    | esk13777_4(X1,X2,X3,X4) ) ).

cnf(i_0_3054,axiom,
    ( esk509_4(X1,X2,X3,X4)
    | ~ esk388_4(X1,X2,X3,X4) ) ).

cnf(i_0_3055,axiom,
    ( esk14541_4(X1,X2,X3,X4)
    | esk14488_4(X1,X2,X3,X4) ) ).

cnf(i_0_3056,axiom,
    ( ~ esk1543_4(X1,X2,X3,X4)
    | esk1285_4(X1,X2,X3,X4) ) ).

cnf(i_0_3057,axiom,
    ( esk6238_4(X1,X2,X3,X4)
    | ~ esk6219_4(X1,X2,X3,X4)
    | esk6167_4(X1,X2,X3,X4) ) ).

cnf(i_0_3058,axiom,
    ( esk5854_4(X1,X2,X3,X4)
    | esk5866_4(X1,X2,X3,X4) ) ).

cnf(i_0_3059,axiom,
    ( esk8594_4(X1,X2,X3,X4)
    | ~ esk8620_4(X1,X2,X3,X4) ) ).

cnf(i_0_3060,axiom,
    ( esk11621_4(X1,X2,X3,X4)
    | esk11536_4(X1,X2,X3,X4) ) ).

cnf(i_0_3061,axiom,
    ( esk14100_4(X1,X2,X3,X4)
    | esk14185_4(X1,X2,X3,X4) ) ).

cnf(i_0_3062,axiom,
    ( ~ esk13512_4(X1,X2,X3,X4)
    | esk13488_4(X1,X2,X3,X4) ) ).

cnf(i_0_3063,axiom,
    ( esk2601_4(X1,X2,X3,X4)
    | esk2565_4(X1,X2,X3,X4) ) ).

cnf(i_0_3064,axiom,
    ( ~ esk10782_4(X1,X2,X3,X4)
    | esk10728_4(X1,X2,X3,X4) ) ).

cnf(i_0_3065,axiom,
    ( esk712_4(X1,X2,X3,X4)
    | esk735_4(X1,X2,X3,X4) ) ).

cnf(i_0_3066,axiom,
    ( ~ p(X4)
    | p(X3)
    | ~ esk318_0
    | p(X2)
    | p(X1)
    | esk534_4(X1,X2,X3,X4) ) ).

cnf(i_0_3067,axiom,
    ( p(X2)
    | p(X4)
    | p(X1)
    | ~ p(X3)
    | esk517_4(X1,X2,X3,X4)
    | ~ esk259_0 ) ).

cnf(i_0_3068,axiom,
    ( esk4616_4(X1,X2,X3,X4)
    | ~ esk4559_4(X1,X2,X3,X4) ) ).

cnf(i_0_3069,axiom,
    ( esk9068_4(X1,X2,X3,X4)
    | esk9046_4(X1,X2,X3,X4) ) ).

cnf(i_0_3070,axiom,
    ( esk12489_4(X1,X2,X3,X4)
    | esk12507_4(X1,X2,X3,X4) ) ).

cnf(i_0_3071,axiom,
    ( esk3373_4(X1,X2,X3,X4)
    | esk3334_4(X1,X2,X3,X4) ) ).

cnf(i_0_3072,axiom,
    ( esk9966_4(X1,X2,X3,X4)
    | esk9978_4(X1,X2,X3,X4) ) ).

cnf(i_0_3073,axiom,
    ( esk15834_4(X1,X2,X3,X4)
    | ~ esk16092_4(X1,X2,X3,X4) ) ).

cnf(i_0_3074,axiom,
    ( ~ esk2591_4(X1,X2,X3,X4)
    | ~ esk2590_4(X1,X2,X3,X4) ) ).

cnf(i_0_3075,axiom,
    ( ~ esk10490_4(X1,X2,X3,X4)
    | ~ esk10602_4(X1,X2,X3,X4)
    | ~ esk10480_4(X1,X2,X3,X4) ) ).

cnf(i_0_3076,axiom,
    ( ~ esk11069_4(X1,X2,X3,X4)
    | esk11068_4(X1,X2,X3,X4) ) ).

cnf(i_0_3077,axiom,
    ( esk10996_4(X1,X2,X3,X4)
    | esk10991_4(X1,X2,X3,X4) ) ).

cnf(i_0_3078,axiom,
    ( esk6999_4(X1,X2,X3,X4)
    | esk6912_4(X1,X2,X3,X4) ) ).

cnf(i_0_3079,axiom,
    ( ~ esk11814_4(X1,X2,X3,X4)
    | esk12072_4(X1,X2,X3,X4) ) ).

cnf(i_0_3080,axiom,
    ( ~ esk14465_4(X1,X2,X3,X4)
    | ~ esk14443_4(X1,X2,X3,X4) ) ).

cnf(i_0_3081,axiom,
    ( esk13905_4(X1,X2,X3,X4)
    | esk13904_4(X1,X2,X3,X4)
    | esk13903_4(X1,X2,X3,X4) ) ).

cnf(i_0_3082,axiom,
    ( p(X1)
    | ~ p(X4)
    | ~ p(X2)
    | esk16687_4(X1,X2,X3,X4)
    | ~ esk115_0
    | ~ p(X3) ) ).

cnf(i_0_3083,axiom,
    ( ~ esk1059_4(X1,X2,X3,X4)
    | esk1075_4(X1,X2,X3,X4) ) ).

cnf(i_0_3084,axiom,
    ( esk2241_4(X1,X2,X3,X4)
    | ~ esk2313_4(X1,X2,X3,X4) ) ).

cnf(i_0_3085,axiom,
    ( esk5850_4(X1,X2,X3,X4)
    | esk5857_4(X1,X2,X3,X4) ) ).

cnf(i_0_3086,axiom,
    ( ~ esk5798_4(X1,X2,X3,X4)
    | ~ esk5853_4(X1,X2,X3,X4) ) ).

cnf(i_0_3087,axiom,
    ( esk9952_4(X1,X2,X3,X4)
    | ~ esk10021_4(X1,X2,X3,X4) ) ).

cnf(i_0_3088,axiom,
    esk16079_4(X1,X2,X3,X4) ).

cnf(i_0_3089,axiom,
    ( ~ esk5624_4(X1,X2,X3,X4)
    | ~ esk5595_4(X1,X2,X3,X4)
    | ~ esk5657_4(X1,X2,X3,X4) ) ).

cnf(i_0_3090,axiom,
    ( esk15915_4(X1,X2,X3,X4)
    | ~ esk15657_4(X1,X2,X3,X4) ) ).

cnf(i_0_3091,axiom,
    ( ~ esk6942_4(X1,X2,X3,X4)
    | ~ esk6965_4(X1,X2,X3,X4) ) ).

cnf(i_0_3092,axiom,
    esk4771_4(X1,X2,X3,X4) ).

cnf(i_0_3093,axiom,
    ( ~ esk9253_4(X1,X2,X3,X4)
    | ~ esk9193_4(X1,X2,X3,X4)
    | ~ esk9220_4(X1,X2,X3,X4) ) ).

cnf(i_0_3094,axiom,
    ( esk14047_4(X1,X2,X3,X4)
    | ~ esk14040_4(X1,X2,X3,X4) ) ).

cnf(i_0_3095,axiom,
    ( esk6067_4(X1,X2,X3,X4)
    | esk6066_4(X1,X2,X3,X4) ) ).

cnf(i_0_3096,axiom,
    ( ~ esk5154_4(X1,X2,X3,X4)
    | esk5156_4(X1,X2,X3,X4) ) ).

cnf(i_0_3097,axiom,
    ( ~ esk4323_4(X1,X2,X3,X4)
    | ~ esk4310_4(X1,X2,X3,X4)
    | ~ esk4356_4(X1,X2,X3,X4) ) ).

cnf(i_0_3098,axiom,
    ( ~ esk7633_4(X1,X2,X3,X4)
    | ~ esk7613_4(X1,X2,X3,X4)
    | esk7597_4(X1,X2,X3,X4) ) ).

cnf(i_0_3099,axiom,
    ( esk3747_4(X1,X2,X3,X4)
    | esk3748_4(X1,X2,X3,X4) ) ).

cnf(i_0_3100,axiom,
    ( esk14883_4(X1,X2,X3,X4)
    | ~ esk14625_4(X1,X2,X3,X4) ) ).

cnf(i_0_3101,axiom,
    ( esk8253_4(X1,X2,X3,X4)
    | esk8274_4(X1,X2,X3,X4)
    | ~ esk8252_4(X1,X2,X3,X4) ) ).

cnf(i_0_3102,axiom,
    ( ~ esk4336_4(X1,X2,X3,X4)
    | ~ esk4335_4(X1,X2,X3,X4)
    | ~ esk4298_4(X1,X2,X3,X4) ) ).

cnf(i_0_3103,axiom,
    ( ~ esk5321_4(X1,X2,X3,X4)
    | ~ esk5410_4(X1,X2,X3,X4) ) ).

cnf(i_0_3104,axiom,
    ( ~ esk3753_4(X1,X2,X3,X4)
    | ~ esk3754_4(X1,X2,X3,X4) ) ).

cnf(i_0_3105,axiom,
    ( esk6393_4(X1,X2,X3,X4)
    | esk6366_4(X1,X2,X3,X4) ) ).

cnf(i_0_3106,axiom,
    ( esk15979_4(X1,X2,X3,X4)
    | ~ esk15980_4(X1,X2,X3,X4)
    | esk15966_4(X1,X2,X3,X4) ) ).

cnf(i_0_3107,axiom,
    ( esk10482_4(X1,X2,X3,X4)
    | esk10480_4(X1,X2,X3,X4) ) ).

cnf(i_0_3108,axiom,
    ( esk3836_4(X1,X2,X3,X4)
    | ~ esk3578_4(X1,X2,X3,X4) ) ).

cnf(i_0_3109,axiom,
    ( esk552_4(X1,X2,X3,X4)
    | esk497_4(X1,X2,X3,X4) ) ).

cnf(i_0_3110,axiom,
    ( esk10489_4(X1,X2,X3,X4)
    | esk10522_4(X1,X2,X3,X4) ) ).

cnf(i_0_3111,axiom,
    ( esk10723_4(X1,X2,X3,X4)
    | esk10760_4(X1,X2,X3,X4) ) ).

cnf(i_0_3112,axiom,
    ( esk646_4(X1,X2,X3,X4)
    | ~ esk619_4(X1,X2,X3,X4) ) ).

cnf(i_0_3113,axiom,
    ( esk6135_4(X1,X2,X3,X4)
    | esk6241_4(X1,X2,X3,X4) ) ).

cnf(i_0_3114,axiom,
    ( esk11970_4(X1,X2,X3,X4)
    | ~ esk11973_4(X1,X2,X3,X4)
    | ~ esk11946_4(X1,X2,X3,X4) ) ).

cnf(i_0_3115,axiom,
    ( ~ esk5667_4(X1,X2,X3,X4)
    | ~ esk5578_4(X1,X2,X3,X4) ) ).

cnf(i_0_3116,axiom,
    ( esk14602_4(X1,X2,X3,X4)
    | esk14592_4(X1,X2,X3,X4) ) ).

cnf(i_0_3117,axiom,
    ( esk2682_4(X1,X2,X3,X4)
    | ~ esk2710_4(X1,X2,X3,X4) ) ).

cnf(i_0_3118,axiom,
    ( esk10225_4(X1,X2,X3,X4)
    | esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_3119,axiom,
    ( esk9492_4(X1,X2,X3,X4)
    | esk9459_4(X1,X2,X3,X4) ) ).

cnf(i_0_3120,axiom,
    ( esk7902_4(X1,X2,X3,X4)
    | ~ esk7953_4(X1,X2,X3,X4) ) ).

cnf(i_0_3121,axiom,
    ( esk1196_4(X1,X2,X3,X4)
    | ~ esk1198_4(X1,X2,X3,X4) ) ).

cnf(i_0_3122,axiom,
    ( esk9156_4(X1,X2,X3,X4)
    | esk9151_4(X1,X2,X3,X4)
    | esk9157_4(X1,X2,X3,X4) ) ).

cnf(i_0_3123,axiom,
    ( esk6643_4(X1,X2,X3,X4)
    | esk6625_4(X1,X2,X3,X4) ) ).

cnf(i_0_3124,axiom,
    ( esk14166_4(X1,X2,X3,X4)
    | esk14180_4(X1,X2,X3,X4) ) ).

cnf(i_0_3125,axiom,
    ( esk1065_4(X1,X2,X3,X4)
    | esk1066_4(X1,X2,X3,X4)
    | ~ esk1091_4(X1,X2,X3,X4) ) ).

cnf(i_0_3126,axiom,
    ( ~ esk15656_4(X1,X2,X3,X4)
    | esk15701_4(X1,X2,X3,X4)
    | ~ esk15716_4(X1,X2,X3,X4) ) ).

cnf(i_0_3127,axiom,
    ( esk7344_4(X1,X2,X3,X4)
    | ~ esk7332_4(X1,X2,X3,X4) ) ).

cnf(i_0_3128,axiom,
    ( esk13500_4(X1,X2,X3,X4)
    | ~ esk13512_4(X1,X2,X3,X4)
    | ~ esk13626_4(X1,X2,X3,X4) ) ).

cnf(i_0_3129,axiom,
    ( ~ esk14302_4(X1,X2,X3,X4)
    | ~ esk14297_4(X1,X2,X3,X4) ) ).

cnf(i_0_3130,axiom,
    ( ~ esk8772_4(X1,X2,X3,X4)
    | ~ esk8774_4(X1,X2,X3,X4) ) ).

cnf(i_0_3131,axiom,
    ( ~ esk517_4(X1,X2,X3,X4)
    | esk259_0
    | p(X4)
    | p(X2)
    | p(X1)
    | ~ p(X3) ) ).

cnf(i_0_3132,axiom,
    ( ~ esk4615_4(X1,X2,X3,X4)
    | ~ esk4666_4(X1,X2,X3,X4)
    | ~ esk4659_4(X1,X2,X3,X4) ) ).

cnf(i_0_3133,axiom,
    ( esk7087_4(X1,X2,X3,X4)
    | ~ esk7076_4(X1,X2,X3,X4) ) ).

cnf(i_0_3134,axiom,
    ( ~ esk15530_4(X1,X2,X3,X4)
    | esk15562_4(X1,X2,X3,X4) ) ).

cnf(i_0_3135,axiom,
    ( esk1791_4(X1,X2,X3,X4)
    | ~ esk2049_4(X1,X2,X3,X4) ) ).

cnf(i_0_3136,axiom,
    ( ~ esk4914_4(X1,X2,X3,X4)
    | ~ esk4928_4(X1,X2,X3,X4) ) ).

cnf(i_0_3137,axiom,
    ( esk13254_4(X1,X2,X3,X4)
    | ~ esk13374_4(X1,X2,X3,X4)
    | esk13223_4(X1,X2,X3,X4) ) ).

cnf(i_0_3138,axiom,
    ( esk2207_4(X1,X2,X3,X4)
    | esk2205_4(X1,X2,X3,X4) ) ).

cnf(i_0_3139,axiom,
    ( esk1229_4(X1,X2,X3,X4)
    | esk1262_4(X1,X2,X3,X4) ) ).

cnf(i_0_3140,axiom,
    ( esk8289_4(X1,X2,X3,X4)
    | ~ esk8209_4(X1,X2,X3,X4)
    | esk8260_4(X1,X2,X3,X4) ) ).

cnf(i_0_3141,axiom,
    ( ~ esk2993_4(X1,X2,X3,X4)
    | esk2992_4(X1,X2,X3,X4) ) ).

cnf(i_0_3142,axiom,
    ( ~ esk806_4(X1,X2,X3,X4)
    | esk838_4(X1,X2,X3,X4) ) ).

cnf(i_0_3143,axiom,
    ( esk9540_4(X1,X2,X3,X4)
    | esk9554_4(X1,X2,X3,X4) ) ).

cnf(i_0_3144,axiom,
    ( esk16749_4(X1,X2,X3,X4)
    | esk16664_4(X1,X2,X3,X4) ) ).

cnf(i_0_3145,axiom,
    ( ~ esk1723_4(X1,X2,X3,X4)
    | ~ esk1812_4(X1,X2,X3,X4) ) ).

cnf(i_0_3146,axiom,
    ( ~ esk4178_4(X1,X2,X3,X4)
    | ~ esk4146_4(X1,X2,X3,X4) ) ).

cnf(i_0_3147,axiom,
    ( esk15680_4(X1,X2,X3,X4)
    | esk15703_4(X1,X2,X3,X4) ) ).

cnf(i_0_3148,axiom,
    ( esk12078_4(X1,X2,X3,X4)
    | ~ esk11955_4(X1,X2,X3,X4) ) ).

cnf(i_0_3149,axiom,
    ( esk9262_4(X1,X2,X3,X4)
    | ~ esk9111_4(X1,X2,X3,X4) ) ).

cnf(i_0_3150,axiom,
    ( esk10608_4(X1,X2,X3,X4)
    | esk10520_4(X1,X2,X3,X4)
    | ~ esk10601_4(X1,X2,X3,X4) ) ).

cnf(i_0_3151,axiom,
    ( ~ esk12508_4(X1,X2,X3,X4)
    | ~ esk12509_4(X1,X2,X3,X4)
    | esk12510_4(X1,X2,X3,X4) ) ).

cnf(i_0_3152,axiom,
    ( ~ esk13343_4(X1,X2,X3,X4)
    | esk13085_4(X1,X2,X3,X4) ) ).

cnf(i_0_3153,axiom,
    ( esk9819_4(X1,X2,X3,X4)
    | ~ esk9820_4(X1,X2,X3,X4)
    | esk9792_4(X1,X2,X3,X4) ) ).

cnf(i_0_3154,axiom,
    ( esk934_4(X1,X2,X3,X4)
    | esk929_4(X1,X2,X3,X4)
    | ~ esk935_4(X1,X2,X3,X4) ) ).

cnf(i_0_3155,axiom,
    ( esk3396_4(X1,X2,X3,X4)
    | ~ esk3397_4(X1,X2,X3,X4) ) ).

cnf(i_0_3156,axiom,
    ( esk13936_4(X1,X2,X3,X4)
    | ~ esk13938_4(X1,X2,X3,X4) ) ).

cnf(i_0_3157,axiom,
    ( esk16653_4(X1,X2,X3,X4)
    | esk16643_4(X1,X2,X3,X4) ) ).

cnf(i_0_3158,axiom,
    ( esk8256_4(X1,X2,X3,X4)
    | esk8217_4(X1,X2,X3,X4) ) ).

cnf(i_0_3159,axiom,
    ( ~ p(X4)
    | esk107_0
    | ~ p(X2)
    | ~ p(X3)
    | ~ esk495_4(X1,X2,X3,X4)
    | ~ p(X1) ) ).

cnf(i_0_3160,axiom,
    ( ~ esk8284_4(X1,X2,X3,X4)
    | ~ esk8167_4(X1,X2,X3,X4)
    | ~ esk8197_4(X1,X2,X3,X4) ) ).

cnf(i_0_3161,axiom,
    ( esk4352_4(X1,X2,X3,X4)
    | esk4319_4(X1,X2,X3,X4) ) ).

cnf(i_0_3162,axiom,
    ( esk919_4(X1,X2,X3,X4)
    | ~ esk911_4(X1,X2,X3,X4) ) ).

cnf(i_0_3163,axiom,
    ( esk10724_4(X1,X2,X3,X4)
    | esk10759_4(X1,X2,X3,X4) ) ).

cnf(i_0_3164,axiom,
    ( ~ esk7666_4(X1,X2,X3,X4)
    | ~ esk7651_4(X1,X2,X3,X4)
    | ~ esk7699_4(X1,X2,X3,X4) ) ).

cnf(i_0_3165,axiom,
    ( ~ esk16473_4(X1,X2,X3,X4)
    | ~ esk16475_4(X1,X2,X3,X4) ) ).

cnf(i_0_3166,axiom,
    ( esk11116_4(X1,X2,X3,X4)
    | ~ esk11036_4(X1,X2,X3,X4)
    | esk11087_4(X1,X2,X3,X4) ) ).

cnf(i_0_3167,axiom,
    ( ~ esk9253_4(X1,X2,X3,X4)
    | esk9304_4(X1,X2,X3,X4)
    | esk9279_4(X1,X2,X3,X4) ) ).

cnf(i_0_3168,axiom,
    ( ~ esk14750_4(X1,X2,X3,X4)
    | esk14785_4(X1,X2,X3,X4) ) ).

cnf(i_0_3169,axiom,
    ( esk2762_4(X1,X2,X3,X4)
    | esk2781_4(X1,X2,X3,X4) ) ).

cnf(i_0_3170,axiom,
    ( ~ esk6913_4(X1,X2,X3,X4)
    | ~ esk6880_4(X1,X2,X3,X4)
    | ~ esk6946_4(X1,X2,X3,X4) ) ).

cnf(i_0_3171,axiom,
    ( esk14976_4(X1,X2,X3,X4)
    | esk14905_4(X1,X2,X3,X4)
    | ~ esk14957_4(X1,X2,X3,X4) ) ).

cnf(i_0_3172,axiom,
    ( ~ esk266_0
    | p(X3)
    | esk517_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ p(X4)
    | p(X2) ) ).

cnf(i_0_3173,axiom,
    ( esk1483_4(X1,X2,X3,X4)
    | esk1488_4(X1,X2,X3,X4) ) ).

cnf(i_0_3174,axiom,
    ( esk12407_4(X1,X2,X3,X4)
    | esk12321_4(X1,X2,X3,X4) ) ).

cnf(i_0_3175,axiom,
    ( ~ esk14083_4(X1,X2,X3,X4)
    | ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14116_4(X1,X2,X3,X4) ) ).

cnf(i_0_3176,axiom,
    ( ~ esk10696_4(X1,X2,X3,X4)
    | ~ esk10695_4(X1,X2,X3,X4) ) ).

cnf(i_0_3177,axiom,
    ( esk999_4(X1,X2,X3,X4)
    | esk971_4(X1,X2,X3,X4) ) ).

cnf(i_0_3178,axiom,
    ( ~ esk16595_4(X1,X2,X3,X4)
    | ~ esk16572_4(X1,X2,X3,X4) ) ).

cnf(i_0_3179,axiom,
    ( esk6708_4(X1,X2,X3,X4)
    | esk6707_4(X1,X2,X3,X4)
    | esk6709_4(X1,X2,X3,X4) ) ).

cnf(i_0_3180,axiom,
    ( esk11239_4(X1,X2,X3,X4)
    | ~ esk11302_4(X1,X2,X3,X4) ) ).

cnf(i_0_3181,axiom,
    ( ~ esk11287_4(X1,X2,X3,X4)
    | esk11029_4(X1,X2,X3,X4) ) ).

cnf(i_0_3182,axiom,
    ( ~ esk13909_4(X1,X2,X3,X4)
    | ~ esk13911_4(X1,X2,X3,X4) ) ).

cnf(i_0_3183,axiom,
    ( esk14862_4(X1,X2,X3,X4)
    | esk14895_4(X1,X2,X3,X4) ) ).

cnf(i_0_3184,axiom,
    ( ~ esk9917_4(X1,X2,X3,X4)
    | esk9914_4(X1,X2,X3,X4)
    | ~ esk9890_4(X1,X2,X3,X4) ) ).

cnf(i_0_3185,axiom,
    ( ~ esk478_4(X1,X2,X3,X4)
    | ~ esk479_4(X1,X2,X3,X4)
    | ~ esk444_4(X1,X2,X3,X4) ) ).

cnf(i_0_3186,axiom,
    ( ~ esk13358_4(X1,X2,X3,X4)
    | esk13295_4(X1,X2,X3,X4) ) ).

cnf(i_0_3187,axiom,
    ( ~ p(X2)
    | p(X4)
    | ~ esk60_0
    | esk16623_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X1) ) ).

cnf(i_0_3188,axiom,
    ( esk5595_4(X1,X2,X3,X4)
    | esk5620_4(X1,X2,X3,X4) ) ).

cnf(i_0_3189,axiom,
    ( esk3017_4(X1,X2,X3,X4)
    | esk3042_4(X1,X2,X3,X4) ) ).

cnf(i_0_3190,axiom,
    ( ~ esk8490_4(X1,X2,X3,X4)
    | esk8489_4(X1,X2,X3,X4)
    | esk8494_4(X1,X2,X3,X4) ) ).

cnf(i_0_3191,axiom,
    ( ~ esk6920_4(X1,X2,X3,X4)
    | ~ esk6830_4(X1,X2,X3,X4)
    | esk6821_4(X1,X2,X3,X4) ) ).

cnf(i_0_3192,axiom,
    ( ~ esk1_0
    | p(X4)
    | p(X2)
    | p(X1)
    | p(X3)
    | esk509_4(X1,X2,X3,X4) ) ).

cnf(i_0_3193,axiom,
    ( ~ esk4091_4(X1,X2,X3,X4)
    | ~ esk4058_4(X1,X2,X3,X4)
    | ~ esk4053_4(X1,X2,X3,X4) ) ).

cnf(i_0_3194,axiom,
    ( esk5803_4(X1,X2,X3,X4)
    | esk5751_4(X1,X2,X3,X4) ) ).

cnf(i_0_3195,axiom,
    ( ~ esk8177_4(X1,X2,X3,X4)
    | ~ esk8176_4(X1,X2,X3,X4)
    | ~ esk8160_4(X1,X2,X3,X4) ) ).

cnf(i_0_3196,axiom,
    ( ~ esk13950_4(X1,X2,X3,X4)
    | ~ esk13911_4(X1,X2,X3,X4) ) ).

cnf(i_0_3197,axiom,
    ( esk11784_4(X1,X2,X3,X4)
    | esk11753_4(X1,X2,X3,X4) ) ).

cnf(i_0_3198,axiom,
    ( esk2773_4(X1,X2,X3,X4)
    | esk2768_4(X1,X2,X3,X4) ) ).

cnf(i_0_3199,axiom,
    ( ~ esk16698_4(X1,X2,X3,X4)
    | ~ esk16596_4(X1,X2,X3,X4)
    | esk16578_4(X1,X2,X3,X4) ) ).

cnf(i_0_3200,axiom,
    ( esk14421_4(X1,X2,X3,X4)
    | ~ esk14420_4(X1,X2,X3,X4)
    | esk14442_4(X1,X2,X3,X4) ) ).

cnf(i_0_3201,axiom,
    ( esk14957_4(X1,X2,X3,X4)
    | esk14905_4(X1,X2,X3,X4)
    | ~ esk14976_4(X1,X2,X3,X4) ) ).

cnf(i_0_3202,axiom,
    ( esk8169_4(X1,X2,X3,X4)
    | esk8167_4(X1,X2,X3,X4) ) ).

cnf(i_0_3203,axiom,
    ( esk15610_4(X1,X2,X3,X4)
    | ~ esk15667_4(X1,X2,X3,X4) ) ).

cnf(i_0_3204,axiom,
    ( ~ esk7438_4(X1,X2,X3,X4)
    | esk7518_4(X1,X2,X3,X4)
    | esk7489_4(X1,X2,X3,X4) ) ).

cnf(i_0_3205,axiom,
    ( esk14356_4(X1,X2,X3,X4)
    | esk14333_4(X1,X2,X3,X4) ) ).

cnf(i_0_3206,axiom,
    ( esk2764_4(X1,X2,X3,X4)
    | esk2778_4(X1,X2,X3,X4) ) ).

cnf(i_0_3207,axiom,
    ( ~ esk9866_4(X1,X2,X3,X4)
    | esk9909_4(X1,X2,X3,X4) ) ).

cnf(i_0_3208,axiom,
    ( ~ esk13255_4(X1,X2,X3,X4)
    | ~ esk13363_4(X1,X2,X3,X4)
    | esk13240_4(X1,X2,X3,X4) ) ).

cnf(i_0_3209,axiom,
    ( ~ esk5597_4(X1,X2,X3,X4)
    | ~ esk5607_4(X1,X2,X3,X4)
    | ~ esk5719_4(X1,X2,X3,X4) ) ).

cnf(i_0_3210,axiom,
    ( esk12447_4(X1,X2,X3,X4)
    | ~ esk12477_4(X1,X2,X3,X4) ) ).

cnf(i_0_3211,axiom,
    ( esk3350_4(X1,X2,X3,X4)
    | ~ esk3352_4(X1,X2,X3,X4) ) ).

cnf(i_0_3212,axiom,
    ( esk12053_4(X1,X2,X3,X4)
    | esk12004_4(X1,X2,X3,X4) ) ).

cnf(i_0_3213,axiom,
    ( esk3282_4(X1,X2,X3,X4)
    | esk3305_4(X1,X2,X3,X4) ) ).

cnf(i_0_3214,axiom,
    ( esk10333_4(X1,X2,X3,X4)
    | esk10305_4(X1,X2,X3,X4) ) ).

cnf(i_0_3215,axiom,
    ( p(X3)
    | ~ esk412_4(X1,X2,X3,X4)
    | p(X4)
    | p(X2)
    | esk25_0
    | ~ p(X1) ) ).

cnf(i_0_3216,axiom,
    ( esk1723_4(X1,X2,X3,X4)
    | esk1812_4(X1,X2,X3,X4) ) ).

cnf(i_0_3217,axiom,
    ( ~ esk10161_4(X1,X2,X3,X4)
    | esk10137_4(X1,X2,X3,X4) ) ).

cnf(i_0_3218,axiom,
    ( ~ esk9829_4(X1,X2,X3,X4)
    | esk9804_4(X1,X2,X3,X4)
    | esk9803_4(X1,X2,X3,X4) ) ).

cnf(i_0_3219,axiom,
    ( ~ esk2102_4(X1,X2,X3,X4)
    | esk2104_4(X1,X2,X3,X4)
    | ~ esk2103_4(X1,X2,X3,X4) ) ).

cnf(i_0_3220,axiom,
    ( ~ esk14286_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4)
    | ~ esk14259_4(X1,X2,X3,X4) ) ).

cnf(i_0_3221,axiom,
    ( esk13373_4(X1,X2,X3,X4)
    | ~ esk13375_4(X1,X2,X3,X4) ) ).

cnf(i_0_3222,axiom,
    ( ~ esk4525_4(X1,X2,X3,X4)
    | esk4537_4(X1,X2,X3,X4) ) ).

cnf(i_0_3223,axiom,
    ( esk11467_4(X1,X2,X3,X4)
    | esk11470_4(X1,X2,X3,X4)
    | esk11468_4(X1,X2,X3,X4)
    | esk11464_4(X1,X2,X3,X4) ) ).

cnf(i_0_3224,axiom,
    ( ~ esk2076_4(X1,X2,X3,X4)
    | ~ esk1979_4(X1,X2,X3,X4) ) ).

cnf(i_0_3225,axiom,
    ( p(X3)
    | p(X2)
    | ~ esk16695_4(X1,X2,X3,X4)
    | esk177_0
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_3226,axiom,
    ( esk16397_4(X1,X2,X3,X4)
    | esk16511_4(X1,X2,X3,X4) ) ).

cnf(i_0_3227,axiom,
    ( esk4313_4(X1,X2,X3,X4)
    | esk4309_4(X1,X2,X3,X4) ) ).

cnf(i_0_3228,axiom,
    ( esk3558_4(X1,X2,X3,X4)
    | esk3530_4(X1,X2,X3,X4) ) ).

cnf(i_0_3229,axiom,
    ( esk11302_4(X1,X2,X3,X4)
    | ~ esk11239_4(X1,X2,X3,X4) ) ).

cnf(i_0_3230,axiom,
    ( esk16151_4(X1,X2,X3,X4)
    | esk16123_4(X1,X2,X3,X4) ) ).

cnf(i_0_3231,axiom,
    ( esk8461_4(X1,X2,X3,X4)
    | ~ esk8419_4(X1,X2,X3,X4) ) ).

cnf(i_0_3232,axiom,
    ( esk8873_4(X1,X2,X3,X4)
    | ~ esk8840_4(X1,X2,X3,X4) ) ).

cnf(i_0_3233,axiom,
    ( ~ esk10209_4(X1,X2,X3,X4)
    | ~ esk10246_4(X1,X2,X3,X4)
    | ~ esk10247_4(X1,X2,X3,X4) ) ).

cnf(i_0_3234,axiom,
    ( esk3532_4(X1,X2,X3,X4)
    | esk3554_4(X1,X2,X3,X4) ) ).

cnf(i_0_3235,axiom,
    ( esk12835_4(X1,X2,X3,X4)
    | esk12888_4(X1,X2,X3,X4) ) ).

cnf(i_0_3236,axiom,
    ( esk3846_4(X1,X2,X3,X4)
    | esk3813_4(X1,X2,X3,X4) ) ).

cnf(i_0_3237,axiom,
    ( ~ esk1166_4(X1,X2,X3,X4)
    | esk1176_4(X1,X2,X3,X4) ) ).

cnf(i_0_3238,axiom,
    ( ~ esk3494_4(X1,X2,X3,X4)
    | esk3514_4(X1,X2,X3,X4) ) ).

cnf(i_0_3239,axiom,
    ( ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10850_4(X1,X2,X3,X4)
    | ~ esk10765_4(X1,X2,X3,X4) ) ).

cnf(i_0_3240,axiom,
    ( ~ esk14631_4(X1,X2,X3,X4)
    | esk14586_4(X1,X2,X3,X4) ) ).

cnf(i_0_3241,axiom,
    ( ~ esk14053_4(X1,X2,X3,X4)
    | esk14055_4(X1,X2,X3,X4) ) ).

cnf(i_0_3242,axiom,
    ( esk3618_4(X1,X2,X3,X4)
    | esk3519_4(X1,X2,X3,X4)
    | esk3611_4(X1,X2,X3,X4) ) ).

cnf(i_0_3243,axiom,
    ( esk4629_4(X1,X2,X3,X4)
    | ~ esk4371_4(X1,X2,X3,X4) ) ).

cnf(i_0_3244,axiom,
    ( ~ esk6240_4(X1,X2,X3,X4)
    | esk6211_4(X1,X2,X3,X4) ) ).

cnf(i_0_3245,axiom,
    ( ~ esk13419_4(X1,X2,X3,X4)
    | esk13420_4(X1,X2,X3,X4)
    | ~ esk13418_4(X1,X2,X3,X4) ) ).

cnf(i_0_3246,axiom,
    ( ~ esk11242_4(X1,X2,X3,X4)
    | esk11296_4(X1,X2,X3,X4) ) ).

cnf(i_0_3247,axiom,
    ( ~ esk1745_4(X1,X2,X3,X4)
    | ~ esk1740_4(X1,X2,X3,X4)
    | ~ esk1778_4(X1,X2,X3,X4) ) ).

cnf(i_0_3248,axiom,
    ( esk6880_4(X1,X2,X3,X4)
    | esk6909_4(X1,X2,X3,X4) ) ).

cnf(i_0_3249,axiom,
    ( ~ esk8936_4(X1,X2,X3,X4)
    | ~ esk8951_4(X1,X2,X3,X4)
    | ~ esk8984_4(X1,X2,X3,X4) ) ).

cnf(i_0_3250,axiom,
    ( esk4503_4(X1,X2,X3,X4)
    | ~ esk4472_4(X1,X2,X3,X4) ) ).

cnf(i_0_3251,axiom,
    ( ~ esk8886_4(X1,X2,X3,X4)
    | esk8880_4(X1,X2,X3,X4)
    | ~ esk8982_4(X1,X2,X3,X4) ) ).

cnf(i_0_3252,axiom,
    ( ~ esk5725_4(X1,X2,X3,X4)
    | ~ esk5690_4(X1,X2,X3,X4)
    | ~ esk5639_4(X1,X2,X3,X4) ) ).

cnf(i_0_3253,axiom,
    ( ~ esk4549_4(X1,X2,X3,X4)
    | esk4487_4(X1,X2,X3,X4) ) ).

cnf(i_0_3254,axiom,
    ( ~ esk16341_4(X1,X2,X3,X4)
    | ~ esk16311_4(X1,X2,X3,X4) ) ).

cnf(i_0_3255,axiom,
    ( ~ esk16260_4(X1,X2,X3,X4)
    | esk16259_4(X1,X2,X3,X4) ) ).

cnf(i_0_3256,axiom,
    ( esk13025_4(X1,X2,X3,X4)
    | ~ esk13283_4(X1,X2,X3,X4) ) ).

cnf(i_0_3257,axiom,
    ( esk7990_4(X1,X2,X3,X4)
    | esk8008_4(X1,X2,X3,X4) ) ).

cnf(i_0_3258,axiom,
    ( p(X2)
    | ~ esk16703_4(X1,X2,X3,X4)
    | esk236_0
    | p(X4)
    | ~ p(X1)
    | p(X3) ) ).

cnf(i_0_3259,axiom,
    ( ~ esk3372_4(X1,X2,X3,X4)
    | ~ esk3386_4(X1,X2,X3,X4) ) ).

cnf(i_0_3260,axiom,
    ( ~ esk16440_4(X1,X2,X3,X4)
    | esk16380_4(X1,X2,X3,X4) ) ).

cnf(i_0_3261,axiom,
    ( esk13936_4(X1,X2,X3,X4)
    | ~ esk13885_4(X1,X2,X3,X4) ) ).

cnf(i_0_3262,axiom,
    ( esk1_0
    | p(X2)
    | p(X1)
    | ~ esk501_4(X1,X2,X3,X4)
    | p(X3)
    | p(X4) ) ).

cnf(i_0_3263,axiom,
    ( p(X1)
    | ~ p(X2)
    | esk519_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X4)
    | ~ esk277_0 ) ).

cnf(i_0_3264,axiom,
    ( esk7432_4(X1,X2,X3,X4)
    | esk7399_4(X1,X2,X3,X4) ) ).

cnf(i_0_3265,axiom,
    ( esk10351_4(X1,X2,X3,X4)
    | esk10316_4(X1,X2,X3,X4) ) ).

cnf(i_0_3266,axiom,
    ( ~ esk16454_4(X1,X2,X3,X4)
    | esk16712_4(X1,X2,X3,X4) ) ).

cnf(i_0_3267,axiom,
    ( ~ esk15205_4(X1,X2,X3,X4)
    | ~ esk15206_4(X1,X2,X3,X4)
    | esk15207_4(X1,X2,X3,X4) ) ).

cnf(i_0_3268,axiom,
    ( ~ esk8939_4(X1,X2,X3,X4)
    | ~ esk8940_4(X1,X2,X3,X4)
    | ~ esk8935_4(X1,X2,X3,X4) ) ).

cnf(i_0_3269,axiom,
    ( esk13772_4(X1,X2,X3,X4)
    | esk13770_4(X1,X2,X3,X4) ) ).

cnf(i_0_3270,axiom,
    ( ~ esk3258_4(X1,X2,X3,X4)
    | esk3257_4(X1,X2,X3,X4) ) ).

cnf(i_0_3271,axiom,
    ( ~ esk2095_4(X1,X2,X3,X4)
    | ~ esk2118_4(X1,X2,X3,X4)
    | ~ esk2035_4(X1,X2,X3,X4) ) ).

cnf(i_0_3272,axiom,
    ( ~ esk4120_4(X1,X2,X3,X4)
    | esk4121_4(X1,X2,X3,X4) ) ).

cnf(i_0_3273,axiom,
    ( esk2701_4(X1,X2,X3,X4)
    | ~ esk2676_4(X1,X2,X3,X4) ) ).

cnf(i_0_3274,axiom,
    ( esk14745_4(X1,X2,X3,X4)
    | esk14798_4(X1,X2,X3,X4) ) ).

cnf(i_0_3275,axiom,
    ( esk9235_4(X1,X2,X3,X4)
    | esk9323_4(X1,X2,X3,X4)
    | ~ esk9316_4(X1,X2,X3,X4) ) ).

cnf(i_0_3276,axiom,
    ( ~ p(X4)
    | ~ esk534_4(X1,X2,X3,X4)
    | ~ p(X3)
    | esk320_0
    | p(X2)
    | p(X1) ) ).

cnf(i_0_3277,axiom,
    ( esk11082_4(X1,X2,X3,X4)
    | esk11096_4(X1,X2,X3,X4) ) ).

cnf(i_0_3278,axiom,
    ( ~ esk14078_4(X1,X2,X3,X4)
    | ~ esk14096_4(X1,X2,X3,X4)
    | ~ esk14183_4(X1,X2,X3,X4) ) ).

cnf(i_0_3279,axiom,
    ( esk5609_4(X1,X2,X3,X4)
    | esk5589_4(X1,X2,X3,X4) ) ).

cnf(i_0_3280,axiom,
    ( esk10267_4(X1,X2,X3,X4)
    | esk10234_4(X1,X2,X3,X4) ) ).

cnf(i_0_3281,axiom,
    ( esk11432_4(X1,X2,X3,X4)
    | esk11455_4(X1,X2,X3,X4)
    | esk11457_4(X1,X2,X3,X4) ) ).

cnf(i_0_3282,axiom,
    ( ~ esk77_0
    | p(X4)
    | esk16681_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X1)
    | ~ p(X3) ) ).

cnf(i_0_3283,axiom,
    ( ~ esk1806_4(X1,X2,X3,X4)
    | ~ esk1821_4(X1,X2,X3,X4) ) ).

cnf(i_0_3284,axiom,
    ( ~ esk13864_4(X1,X2,X3,X4)
    | esk13813_4(X1,X2,X3,X4) ) ).

cnf(i_0_3285,axiom,
    ( ~ esk10409_4(X1,X2,X3,X4)
    | esk10428_4(X1,X2,X3,X4) ) ).

cnf(i_0_3286,axiom,
    ( esk1999_4(X1,X2,X3,X4)
    | esk2029_4(X1,X2,X3,X4) ) ).

cnf(i_0_3287,axiom,
    ( ~ esk14684_4(X1,X2,X3,X4)
    | ~ esk14636_4(X1,X2,X3,X4) ) ).

cnf(i_0_3288,axiom,
    ( esk11981_4(X1,X2,X3,X4)
    | esk11982_4(X1,X2,X3,X4)
    | esk11984_4(X1,X2,X3,X4)
    | esk11978_4(X1,X2,X3,X4) ) ).

cnf(i_0_3289,axiom,
    ( ~ esk5912_4(X1,X2,X3,X4)
    | ~ esk5963_4(X1,X2,X3,X4)
    | ~ esk5938_4(X1,X2,X3,X4) ) ).

cnf(i_0_3290,axiom,
    ( esk6649_4(X1,X2,X3,X4)
    | esk6755_4(X1,X2,X3,X4) ) ).

cnf(i_0_3291,axiom,
    ( ~ esk4531_4(X1,X2,X3,X4)
    | ~ esk4529_4(X1,X2,X3,X4) ) ).

cnf(i_0_3292,axiom,
    ( esk10171_4(X1,X2,X3,X4)
    | ~ esk10162_4(X1,X2,X3,X4) ) ).

cnf(i_0_3293,axiom,
    ( ~ esk4907_4(X1,X2,X3,X4)
    | ~ esk4860_4(X1,X2,X3,X4)
    | ~ esk4944_4(X1,X2,X3,X4) ) ).

cnf(i_0_3294,axiom,
    ( esk14525_4(X1,X2,X3,X4)
    | ~ esk14496_4(X1,X2,X3,X4) ) ).

cnf(i_0_3295,axiom,
    ( ~ esk4006_4(X1,X2,X3,X4)
    | ~ esk4004_4(X1,X2,X3,X4) ) ).

cnf(i_0_3296,axiom,
    ( esk13404_4(X1,X2,X3,X4)
    | ~ esk13397_4(X1,X2,X3,X4)
    | esk13353_4(X1,X2,X3,X4) ) ).

cnf(i_0_3297,axiom,
    ( esk11603_4(X1,X2,X3,X4)
    | esk11604_4(X1,X2,X3,X4)
    | esk11602_4(X1,X2,X3,X4) ) ).

cnf(i_0_3298,axiom,
    ( ~ esk11854_4(X1,X2,X3,X4)
    | esk11868_4(X1,X2,X3,X4) ) ).

cnf(i_0_3299,axiom,
    ( esk5388_4(X1,X2,X3,X4)
    | esk5355_4(X1,X2,X3,X4) ) ).

cnf(i_0_3300,axiom,
    ( esk3588_4(X1,X2,X3,X4)
    | ~ esk3846_4(X1,X2,X3,X4) ) ).

cnf(i_0_3301,axiom,
    ( ~ esk11506_4(X1,X2,X3,X4)
    | ~ esk11509_4(X1,X2,X3,X4)
    | ~ esk11542_4(X1,X2,X3,X4) ) ).

cnf(i_0_3302,axiom,
    ( esk6702_4(X1,X2,X3,X4)
    | ~ esk6444_4(X1,X2,X3,X4) ) ).

cnf(i_0_3303,axiom,
    ( ~ esk14375_4(X1,X2,X3,X4)
    | esk14463_4(X1,X2,X3,X4)
    | esk14456_4(X1,X2,X3,X4) ) ).

cnf(i_0_3304,axiom,
    ( ~ esk9384_4(X1,X2,X3,X4)
    | esk9357_4(X1,X2,X3,X4) ) ).

cnf(i_0_3305,axiom,
    ( ~ esk3294_4(X1,X2,X3,X4)
    | ~ esk3406_4(X1,X2,X3,X4)
    | ~ esk3284_4(X1,X2,X3,X4) ) ).

cnf(i_0_3306,axiom,
    ( ~ esk10262_4(X1,X2,X3,X4)
    | esk10217_4(X1,X2,X3,X4) ) ).

cnf(i_0_3307,axiom,
    ( ~ esk10313_4(X1,X2,X3,X4)
    | ~ esk10312_4(X1,X2,X3,X4) ) ).

cnf(i_0_3308,axiom,
    ( ~ esk8472_4(X1,X2,X3,X4)
    | esk8523_4(X1,X2,X3,X4) ) ).

cnf(i_0_3309,axiom,
    ( ~ esk15670_4(X1,X2,X3,X4)
    | esk15412_4(X1,X2,X3,X4) ) ).

cnf(i_0_3310,axiom,
    ( ~ esk8165_4(X1,X2,X3,X4)
    | ~ esk8180_4(X1,X2,X3,X4)
    | ~ esk8213_4(X1,X2,X3,X4) ) ).

cnf(i_0_3311,axiom,
    ( ~ esk6942_4(X1,X2,X3,X4)
    | esk6684_4(X1,X2,X3,X4) ) ).

cnf(i_0_3312,axiom,
    ( ~ esk13248_4(X1,X2,X3,X4)
    | esk13349_4(X1,X2,X3,X4) ) ).

cnf(i_0_3313,axiom,
    ( ~ esk6938_4(X1,X2,X3,X4)
    | esk6680_4(X1,X2,X3,X4) ) ).

cnf(i_0_3314,axiom,
    ( ~ esk9025_4(X1,X2,X3,X4)
    | esk8990_4(X1,X2,X3,X4)
    | esk9044_4(X1,X2,X3,X4) ) ).

cnf(i_0_3315,axiom,
    ( esk4611_4(X1,X2,X3,X4)
    | ~ esk4691_4(X1,X2,X3,X4)
    | esk4662_4(X1,X2,X3,X4) ) ).

cnf(i_0_3316,axiom,
    ( esk1695_4(X1,X2,X3,X4)
    | ~ esk1437_4(X1,X2,X3,X4) ) ).

cnf(i_0_3317,axiom,
    ( ~ esk13468_4(X1,X2,X3,X4)
    | esk13497_4(X1,X2,X3,X4) ) ).

cnf(i_0_3318,axiom,
    ( esk12271_4(X1,X2,X3,X4)
    | ~ esk12322_4(X1,X2,X3,X4) ) ).

cnf(i_0_3319,axiom,
    ( esk10733_4(X1,X2,X3,X4)
    | ~ esk10772_4(X1,X2,X3,X4) ) ).

cnf(i_0_3320,axiom,
    ( ~ esk6726_4(X1,X2,X3,X4)
    | ~ esk6625_4(X1,X2,X3,X4)
    | ~ esk6641_4(X1,X2,X3,X4) ) ).

cnf(i_0_3321,axiom,
    ( ~ esk6221_4(X1,X2,X3,X4)
    | ~ esk6193_4(X1,X2,X3,X4) ) ).

cnf(i_0_3322,axiom,
    ( esk5108_4(X1,X2,X3,X4)
    | esk5081_4(X1,X2,X3,X4) ) ).

cnf(i_0_3323,axiom,
    ( ~ esk10345_4(X1,X2,X3,X4)
    | esk10316_4(X1,X2,X3,X4)
    | esk10265_4(X1,X2,X3,X4) ) ).

cnf(i_0_3324,axiom,
    ( ~ esk11628_4(X1,X2,X3,X4)
    | esk11603_4(X1,X2,X3,X4)
    | esk11602_4(X1,X2,X3,X4) ) ).

cnf(i_0_3325,axiom,
    ( esk13045_4(X1,X2,X3,X4)
    | esk13055_4(X1,X2,X3,X4) ) ).

cnf(i_0_3326,axiom,
    ( esk1193_4(X1,X2,X3,X4)
    | ~ esk1194_4(X1,X2,X3,X4) ) ).

cnf(i_0_3327,axiom,
    ( esk58_0
    | p(X4)
    | p(X2)
    | ~ p(X3)
    | ~ p(X1)
    | ~ esk16623_4(X1,X2,X3,X4) ) ).

cnf(i_0_3328,axiom,
    ( esk555_4(X1,X2,X3,X4)
    | esk537_4(X1,X2,X3,X4) ) ).

cnf(i_0_3329,axiom,
    ( ~ esk15690_4(X1,X2,X3,X4)
    | esk15432_4(X1,X2,X3,X4) ) ).

cnf(i_0_3330,axiom,
    ( ~ p(X3)
    | p(X4)
    | esk312_0
    | ~ esk527_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_3331,axiom,
    ( esk6059_4(X1,X2,X3,X4)
    | ~ esk6052_4(X1,X2,X3,X4) ) ).

cnf(i_0_3332,axiom,
    ( ~ esk8118_4(X1,X2,X3,X4)
    | esk8113_4(X1,X2,X3,X4)
    | ~ esk8112_4(X1,X2,X3,X4) ) ).

cnf(i_0_3333,axiom,
    ( esk7595_4(X1,X2,X3,X4)
    | ~ esk7697_4(X1,X2,X3,X4)
    | ~ esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_3334,axiom,
    ( esk9400_4(X1,X2,X3,X4)
    | ~ esk9390_4(X1,X2,X3,X4) ) ).

cnf(i_0_3335,axiom,
    ( esk6875_4(X1,X2,X3,X4)
    | esk6891_4(X1,X2,X3,X4) ) ).

cnf(i_0_3336,axiom,
    ( ~ esk8081_4(X1,X2,X3,X4)
    | esk8105_4(X1,X2,X3,X4) ) ).

cnf(i_0_3337,axiom,
    ( ~ esk7591_4(X1,X2,X3,X4)
    | esk7689_4(X1,X2,X3,X4) ) ).

cnf(i_0_3338,axiom,
    ( esk7685_4(X1,X2,X3,X4)
    | esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_3339,axiom,
    ( esk15167_4(X1,X2,X3,X4)
    | ~ esk15425_4(X1,X2,X3,X4) ) ).

cnf(i_0_3340,axiom,
    ( esk4850_4(X1,X2,X3,X4)
    | esk4812_4(X1,X2,X3,X4) ) ).

cnf(i_0_3341,axiom,
    ( ~ p(X1)
    | esk415_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X3)
    | ~ esk47_0
    | ~ p(X2) ) ).

cnf(i_0_3342,axiom,
    ( esk4028_4(X1,X2,X3,X4)
    | ~ esk4029_4(X1,X2,X3,X4) ) ).

cnf(i_0_3343,axiom,
    ( esk5592_4(X1,X2,X3,X4)
    | ~ esk5634_4(X1,X2,X3,X4) ) ).

cnf(i_0_3344,axiom,
    ( esk16185_4(X1,X2,X3,X4)
    | ~ esk16122_4(X1,X2,X3,X4) ) ).

cnf(i_0_3345,axiom,
    ( ~ esk16218_4(X1,X2,X3,X4)
    | ~ esk16261_4(X1,X2,X3,X4)
    | ~ esk16192_4(X1,X2,X3,X4) ) ).

cnf(i_0_3346,axiom,
    ( esk12505_4(X1,X2,X3,X4)
    | ~ esk12506_4(X1,X2,X3,X4) ) ).

cnf(i_0_3347,axiom,
    ( esk5978_4(X1,X2,X3,X4)
    | ~ esk5980_4(X1,X2,X3,X4) ) ).

cnf(i_0_3348,axiom,
    ( ~ esk14322_4(X1,X2,X3,X4)
    | esk14388_4(X1,X2,X3,X4) ) ).

cnf(i_0_3349,axiom,
    ( esk11306_4(X1,X2,X3,X4)
    | ~ esk11237_4(X1,X2,X3,X4) ) ).

cnf(i_0_3350,axiom,
    ( esk5125_4(X1,X2,X3,X4)
    | ~ esk5024_4(X1,X2,X3,X4) ) ).

cnf(i_0_3351,axiom,
    ( ~ esk15104_4(X1,X2,X3,X4)
    | ~ esk15131_4(X1,X2,X3,X4)
    | ~ esk15164_4(X1,X2,X3,X4) ) ).

cnf(i_0_3352,axiom,
    ( esk6926_4(X1,X2,X3,X4)
    | esk6893_4(X1,X2,X3,X4) ) ).

cnf(i_0_3353,axiom,
    ( esk5382_4(X1,X2,X3,X4)
    | ~ esk5433_4(X1,X2,X3,X4)
    | esk5462_4(X1,X2,X3,X4) ) ).

cnf(i_0_3354,axiom,
    ( ~ esk16075_4(X1,X2,X3,X4)
    | esk16045_4(X1,X2,X3,X4) ) ).

cnf(i_0_3355,axiom,
    ( esk10178_4(X1,X2,X3,X4)
    | esk10179_4(X1,X2,X3,X4) ) ).

cnf(i_0_3356,axiom,
    ( esk3321_4(X1,X2,X3,X4)
    | ~ esk3279_4(X1,X2,X3,X4) ) ).

cnf(i_0_3357,axiom,
    ( esk15146_4(X1,X2,X3,X4)
    | esk15227_4(X1,X2,X3,X4)
    | ~ esk15234_4(X1,X2,X3,X4) ) ).

cnf(i_0_3358,axiom,
    ( ~ esk15326_4(X1,X2,X3,X4)
    | ~ esk15324_4(X1,X2,X3,X4) ) ).

cnf(i_0_3359,axiom,
    ( esk9091_4(X1,X2,X3,X4)
    | esk9144_4(X1,X2,X3,X4) ) ).

cnf(i_0_3360,axiom,
    ( esk11238_4(X1,X2,X3,X4)
    | ~ esk11304_4(X1,X2,X3,X4) ) ).

cnf(i_0_3361,axiom,
    ( ~ esk4647_4(X1,X2,X3,X4)
    | ~ esk4646_4(X1,X2,X3,X4) ) ).

cnf(i_0_3362,axiom,
    ( ~ esk10532_4(X1,X2,X3,X4)
    | esk10274_4(X1,X2,X3,X4) ) ).

cnf(i_0_3363,axiom,
    ( ~ esk13400_4(X1,X2,X3,X4)
    | ~ esk13402_4(X1,X2,X3,X4)
    | ~ esk13349_4(X1,X2,X3,X4)
    | ~ esk13347_4(X1,X2,X3,X4) ) ).

cnf(i_0_3364,axiom,
    ( esk12377_4(X1,X2,X3,X4)
    | esk12359_4(X1,X2,X3,X4) ) ).

cnf(i_0_3365,axiom,
    ( ~ esk3838_4(X1,X2,X3,X4)
    | ~ esk3926_4(X1,X2,X3,X4)
    | ~ esk3919_4(X1,X2,X3,X4) ) ).

cnf(i_0_3366,axiom,
    ( esk13530_4(X1,X2,X3,X4)
    | ~ esk13521_4(X1,X2,X3,X4) ) ).

cnf(i_0_3367,axiom,
    ( ~ esk5132_4(X1,X2,X3,X4)
    | esk5072_4(X1,X2,X3,X4) ) ).

cnf(i_0_3368,axiom,
    ( esk6220_4(X1,X2,X3,X4)
    | esk6137_4(X1,X2,X3,X4) ) ).

cnf(i_0_3369,axiom,
    ( esk13349_4(X1,X2,X3,X4)
    | esk13435_4(X1,X2,X3,X4) ) ).

cnf(i_0_3370,axiom,
    ( esk2093_4(X1,X2,X3,X4)
    | esk2037_4(X1,X2,X3,X4) ) ).

cnf(i_0_3371,axiom,
    ( ~ esk6067_4(X1,X2,X3,X4)
    | ~ esk6071_4(X1,X2,X3,X4) ) ).

cnf(i_0_3372,axiom,
    ( ~ esk5911_4(X1,X2,X3,X4)
    | esk5839_4(X1,X2,X3,X4) ) ).

cnf(i_0_3373,axiom,
    ( esk7733_4(X1,X2,X3,X4)
    | esk7751_4(X1,X2,X3,X4) ) ).

cnf(i_0_3374,axiom,
    ( ~ esk11713_4(X1,X2,X3,X4)
    | esk11704_4(X1,X2,X3,X4)
    | ~ esk11803_4(X1,X2,X3,X4) ) ).

cnf(i_0_3375,axiom,
    ( ~ esk3114_4(X1,X2,X3,X4)
    | ~ esk3112_4(X1,X2,X3,X4) ) ).

cnf(i_0_3376,axiom,
    ( ~ esk295_0
    | ~ p(X3)
    | p(X1)
    | esk16711_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X2) ) ).

cnf(i_0_3377,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12219_4(X1,X2,X3,X4) ) ).

cnf(i_0_3378,axiom,
    ( p(X4)
    | ~ p(X3)
    | ~ p(X2)
    | ~ esk16623_4(X1,X2,X3,X4)
    | esk54_0
    | p(X1) ) ).

cnf(i_0_3379,axiom,
    ( esk6667_4(X1,X2,X3,X4)
    | ~ esk6409_4(X1,X2,X3,X4) ) ).

cnf(i_0_3380,axiom,
    ( esk7314_4(X1,X2,X3,X4)
    | ~ esk7376_4(X1,X2,X3,X4) ) ).

cnf(i_0_3381,axiom,
    ( ~ esk13005_4(X1,X2,X3,X4)
    | esk13019_4(X1,X2,X3,X4) ) ).

cnf(i_0_3382,axiom,
    ( esk2702_4(X1,X2,X3,X4)
    | ~ esk2675_4(X1,X2,X3,X4) ) ).

cnf(i_0_3383,axiom,
    ( ~ esk8617_4(X1,X2,X3,X4)
    | esk8582_4(X1,X2,X3,X4) ) ).

cnf(i_0_3384,axiom,
    ( esk11713_4(X1,X2,X3,X4)
    | ~ esk11707_4(X1,X2,X3,X4) ) ).

cnf(i_0_3385,axiom,
    ( esk2836_4(X1,X2,X3,X4)
    | ~ esk2840_4(X1,X2,X3,X4) ) ).

cnf(i_0_3386,axiom,
    ( esk3906_4(X1,X2,X3,X4)
    | esk3928_4(X1,X2,X3,X4) ) ).

cnf(i_0_3387,axiom,
    ( esk8894_4(X1,X2,X3,X4)
    | esk8893_4(X1,X2,X3,X4) ) ).

cnf(i_0_3388,axiom,
    ( ~ p(X1)
    | ~ p(X4)
    | ~ p(X3)
    | ~ esk257_0
    | ~ p(X2)
    | esk515_4(X1,X2,X3,X4) ) ).

cnf(i_0_3389,axiom,
    ( esk5320_4(X1,X2,X3,X4)
    | esk5321_4(X1,X2,X3,X4)
    | esk5417_4(X1,X2,X3,X4) ) ).

cnf(i_0_3390,axiom,
    ( ~ esk7603_4(X1,X2,X3,X4)
    | ~ esk7573_4(X1,X2,X3,X4) ) ).

cnf(i_0_3391,axiom,
    ( esk6109_4(X1,X2,X3,X4)
    | esk6128_4(X1,X2,X3,X4) ) ).

cnf(i_0_3392,axiom,
    ( ~ esk11840_4(X1,X2,X3,X4)
    | esk11841_4(X1,X2,X3,X4) ) ).

cnf(i_0_3393,axiom,
    ( ~ esk1809_4(X1,X2,X3,X4)
    | ~ esk1808_4(X1,X2,X3,X4)
    | esk1810_4(X1,X2,X3,X4) ) ).

cnf(i_0_3394,axiom,
    ( ~ esk8881_4(X1,X2,X3,X4)
    | esk9002_4(X1,X2,X3,X4) ) ).

cnf(i_0_3395,axiom,
    ( ~ esk1169_4(X1,X2,X3,X4)
    | esk1270_4(X1,X2,X3,X4) ) ).

cnf(i_0_3396,axiom,
    ( esk9662_4(X1,X2,X3,X4)
    | esk9671_4(X1,X2,X3,X4) ) ).

cnf(i_0_3397,axiom,
    ( p(X1)
    | ~ esk16600_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk10_0
    | ~ p(X2)
    | ~ p(X3) ) ).

cnf(i_0_3398,axiom,
    ( ~ esk10685_4(X1,X2,X3,X4)
    | esk10688_4(X1,X2,X3,X4) ) ).

cnf(i_0_3399,axiom,
    ( ~ esk5980_4(X1,X2,X3,X4)
    | esk5979_4(X1,X2,X3,X4) ) ).

cnf(i_0_3400,axiom,
    ( ~ esk14793_4(X1,X2,X3,X4)
    | ~ esk14847_4(X1,X2,X3,X4) ) ).

cnf(i_0_3401,axiom,
    ( ~ esk9408_4(X1,X2,X3,X4)
    | ~ esk9413_4(X1,X2,X3,X4) ) ).

cnf(i_0_3402,axiom,
    ( esk5423_4(X1,X2,X3,X4)
    | esk5400_4(X1,X2,X3,X4) ) ).

cnf(i_0_3403,axiom,
    ( esk3924_4(X1,X2,X3,X4)
    | esk3810_4(X1,X2,X3,X4) ) ).

cnf(i_0_3404,axiom,
    ( esk3603_4(X1,X2,X3,X4)
    | esk3623_4(X1,X2,X3,X4) ) ).

cnf(i_0_3405,axiom,
    ( ~ esk10263_4(X1,X2,X3,X4)
    | ~ esk10344_4(X1,X2,X3,X4)
    | ~ esk10351_4(X1,X2,X3,X4) ) ).

cnf(i_0_3406,axiom,
    ( ~ esk4517_4(X1,X2,X3,X4)
    | esk4504_4(X1,X2,X3,X4)
    | ~ esk4629_4(X1,X2,X3,X4) ) ).

cnf(i_0_3407,axiom,
    ( ~ esk11352_4(X1,X2,X3,X4)
    | ~ esk11251_4(X1,X2,X3,X4)
    | ~ esk11267_4(X1,X2,X3,X4) ) ).

cnf(i_0_3408,axiom,
    ( esk3798_4(X1,X2,X3,X4)
    | esk3810_4(X1,X2,X3,X4) ) ).

cnf(i_0_3409,axiom,
    ( ~ esk14078_4(X1,X2,X3,X4)
    | ~ esk14056_4(X1,X2,X3,X4) ) ).

cnf(i_0_3410,axiom,
    ( ~ esk5453_4(X1,X2,X3,X4)
    | esk5452_4(X1,X2,X3,X4) ) ).

cnf(i_0_3411,axiom,
    ( ~ esk9199_4(X1,X2,X3,X4)
    | ~ esk9314_4(X1,X2,X3,X4)
    | ~ esk9195_4(X1,X2,X3,X4) ) ).

cnf(i_0_3412,axiom,
    ( esk13112_4(X1,X2,X3,X4)
    | ~ esk12986_4(X1,X2,X3,X4) ) ).

cnf(i_0_3413,axiom,
    ( ~ esk1533_4(X1,X2,X3,X4)
    | ~ esk1614_4(X1,X2,X3,X4) ) ).

cnf(i_0_3414,axiom,
    ( ~ esk4648_4(X1,X2,X3,X4)
    | ~ esk4633_4(X1,X2,X3,X4) ) ).

cnf(i_0_3415,axiom,
    ( ~ esk5290_4(X1,X2,X3,X4)
    | ~ esk5262_4(X1,X2,X3,X4) ) ).

cnf(i_0_3416,axiom,
    ( esk3055_4(X1,X2,X3,X4)
    | esk3011_4(X1,X2,X3,X4) ) ).

cnf(i_0_3417,axiom,
    ( esk13320_4(X1,X2,X3,X4)
    | esk13298_4(X1,X2,X3,X4) ) ).

cnf(i_0_3418,axiom,
    ( esk10511_4(X1,X2,X3,X4)
    | esk10478_4(X1,X2,X3,X4) ) ).

cnf(i_0_3419,axiom,
    ( esk1442_4(X1,X2,X3,X4)
    | ~ esk1451_4(X1,X2,X3,X4) ) ).

cnf(i_0_3420,axiom,
    ( ~ esk12347_4(X1,X2,X3,X4)
    | esk12345_4(X1,X2,X3,X4) ) ).

cnf(i_0_3421,axiom,
    ( ~ esk2373_4(X1,X2,X3,X4)
    | esk2371_4(X1,X2,X3,X4) ) ).

cnf(i_0_3422,axiom,
    ( ~ esk16740_4(X1,X2,X3,X4)
    | ~ esk16741_4(X1,X2,X3,X4) ) ).

cnf(i_0_3423,axiom,
    ( esk14918_4(X1,X2,X3,X4)
    | ~ esk14917_4(X1,X2,X3,X4) ) ).

cnf(i_0_3424,axiom,
    ( esk1690_4(X1,X2,X3,X4)
    | ~ esk1673_4(X1,X2,X3,X4) ) ).

cnf(i_0_3425,axiom,
    ( ~ esk3531_4(X1,X2,X3,X4)
    | ~ esk3556_4(X1,X2,X3,X4)
    | ~ esk3557_4(X1,X2,X3,X4) ) ).

cnf(i_0_3426,axiom,
    ( ~ esk3091_4(X1,X2,X3,X4)
    | ~ esk3025_4(X1,X2,X3,X4)
    | ~ esk3058_4(X1,X2,X3,X4) ) ).

cnf(i_0_3427,axiom,
    ( ~ esk1228_4(X1,X2,X3,X4)
    | ~ esk1334_4(X1,X2,X3,X4)
    | ~ esk1248_4(X1,X2,X3,X4) ) ).

cnf(i_0_3428,axiom,
    ( esk3573_4(X1,X2,X3,X4)
    | esk3620_4(X1,X2,X3,X4) ) ).

cnf(i_0_3429,axiom,
    ( esk2083_4(X1,X2,X3,X4)
    | esk2081_4(X1,X2,X3,X4)
    | esk2082_4(X1,X2,X3,X4) ) ).

cnf(i_0_3430,axiom,
    ( esk10265_4(X1,X2,X3,X4)
    | esk10318_4(X1,X2,X3,X4) ) ).

cnf(i_0_3431,axiom,
    ( ~ esk6089_4(X1,X2,X3,X4)
    | ~ esk6188_4(X1,X2,X3,X4) ) ).

cnf(i_0_3432,axiom,
    ( ~ esk11505_4(X1,X2,X3,X4)
    | ~ esk11510_4(X1,X2,X3,X4)
    | ~ esk11509_4(X1,X2,X3,X4) ) ).

cnf(i_0_3433,axiom,
    ( ~ esk16578_4(X1,X2,X3,X4)
    | esk16698_4(X1,X2,X3,X4) ) ).

cnf(i_0_3434,axiom,
    ( esk4799_4(X1,X2,X3,X4)
    | ~ esk4800_4(X1,X2,X3,X4) ) ).

cnf(i_0_3435,axiom,
    ( ~ esk14379_4(X1,X2,X3,X4)
    | esk14121_4(X1,X2,X3,X4) ) ).

cnf(i_0_3436,axiom,
    ( esk2126_4(X1,X2,X3,X4)
    | esk2083_4(X1,X2,X3,X4) ) ).

cnf(i_0_3437,axiom,
    ( esk82_0
    | p(X3)
    | ~ p(X2)
    | p(X4)
    | p(X1)
    | ~ esk16683_4(X1,X2,X3,X4) ) ).

cnf(i_0_3438,axiom,
    ( esk3395_4(X1,X2,X3,X4)
    | ~ esk3394_4(X1,X2,X3,X4) ) ).

cnf(i_0_3439,axiom,
    ( esk1433_4(X1,X2,X3,X4)
    | ~ esk1426_4(X1,X2,X3,X4) ) ).

cnf(i_0_3440,axiom,
    ( esk16683_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X4)
    | p(X3)
    | p(X1)
    | ~ esk83_0 ) ).

cnf(i_0_3441,axiom,
    ( esk8109_4(X1,X2,X3,X4)
    | ~ esk8077_4(X1,X2,X3,X4) ) ).

cnf(i_0_3442,axiom,
    ( esk8158_4(X1,X2,X3,X4)
    | ~ esk8212_4(X1,X2,X3,X4) ) ).

cnf(i_0_3443,axiom,
    ( ~ esk10201_4(X1,X2,X3,X4)
    | ~ esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_3444,axiom,
    ( ~ esk7937_4(X1,X2,X3,X4)
    | ~ esk7894_4(X1,X2,X3,X4)
    | ~ esk7938_4(X1,X2,X3,X4) ) ).

cnf(i_0_3445,axiom,
    ( esk14013_4(X1,X2,X3,X4)
    | ~ esk13980_4(X1,X2,X3,X4) ) ).

cnf(i_0_3446,axiom,
    ( esk11123_4(X1,X2,X3,X4)
    | esk11083_4(X1,X2,X3,X4)
    | esk11082_4(X1,X2,X3,X4)
    | esk11084_4(X1,X2,X3,X4) ) ).

cnf(i_0_3447,axiom,
    ( esk14190_4(X1,X2,X3,X4)
    | ~ esk14138_4(X1,X2,X3,X4) ) ).

cnf(i_0_3448,axiom,
    ( ~ esk3476_4(X1,X2,X3,X4)
    | esk3489_4(X1,X2,X3,X4) ) ).

cnf(i_0_3449,axiom,
    ( esk14896_4(X1,X2,X3,X4)
    | ~ esk15154_4(X1,X2,X3,X4) ) ).

cnf(i_0_3450,axiom,
    ( ~ esk3988_4(X1,X2,X3,X4)
    | esk4111_4(X1,X2,X3,X4) ) ).

cnf(i_0_3451,axiom,
    ( ~ esk6368_4(X1,X2,X3,X4)
    | ~ esk6380_4(X1,X2,X3,X4)
    | ~ esk6494_4(X1,X2,X3,X4) ) ).

cnf(i_0_3452,axiom,
    ( ~ esk8769_4(X1,X2,X3,X4)
    | ~ esk8761_4(X1,X2,X3,X4) ) ).

cnf(i_0_3453,axiom,
    ( ~ esk6877_4(X1,X2,X3,X4)
    | ~ esk6887_4(X1,X2,X3,X4)
    | ~ esk6888_4(X1,X2,X3,X4) ) ).

cnf(i_0_3454,axiom,
    ( esk12638_4(X1,X2,X3,X4)
    | esk12624_4(X1,X2,X3,X4) ) ).

cnf(i_0_3455,axiom,
    ( ~ esk2896_4(X1,X2,X3,X4)
    | esk2895_4(X1,X2,X3,X4) ) ).

cnf(i_0_3456,axiom,
    ( esk14540_4(X1,X2,X3,X4)
    | ~ esk14532_4(X1,X2,X3,X4) ) ).

cnf(i_0_3457,axiom,
    ( esk838_4(X1,X2,X3,X4)
    | ~ esk840_4(X1,X2,X3,X4) ) ).

cnf(i_0_3458,axiom,
    ( esk14088_4(X1,X2,X3,X4)
    | esk14071_4(X1,X2,X3,X4) ) ).

cnf(i_0_3459,axiom,
    ( ~ esk12802_4(X1,X2,X3,X4)
    | ~ esk12786_4(X1,X2,X3,X4)
    | ~ esk12803_4(X1,X2,X3,X4) ) ).

cnf(i_0_3460,axiom,
    ( esk5852_4(X1,X2,X3,X4)
    | esk5871_4(X1,X2,X3,X4) ) ).

cnf(i_0_3461,axiom,
    ( ~ esk7385_4(X1,X2,X3,X4)
    | esk7445_4(X1,X2,X3,X4) ) ).

cnf(i_0_3462,axiom,
    ( ~ esk15615_4(X1,X2,X3,X4)
    | esk15657_4(X1,X2,X3,X4) ) ).

cnf(i_0_3463,axiom,
    ( esk2837_4(X1,X2,X3,X4)
    | ~ esk2717_4(X1,X2,X3,X4) ) ).

cnf(i_0_3464,axiom,
    ( ~ esk10428_4(X1,X2,X3,X4)
    | esk10408_4(X1,X2,X3,X4)
    | ~ esk10526_4(X1,X2,X3,X4) ) ).

cnf(i_0_3465,axiom,
    ( ~ esk3564_4(X1,X2,X3,X4)
    | ~ esk3527_4(X1,X2,X3,X4)
    | ~ esk3565_4(X1,X2,X3,X4) ) ).

cnf(i_0_3466,axiom,
    ( ~ esk16112_4(X1,X2,X3,X4)
    | ~ esk16211_4(X1,X2,X3,X4) ) ).

cnf(i_0_3467,axiom,
    ( esk6696_4(X1,X2,X3,X4)
    | esk6550_4(X1,X2,X3,X4) ) ).

cnf(i_0_3468,axiom,
    ( ~ esk5031_4(X1,X2,X3,X4)
    | esk5019_4(X1,X2,X3,X4)
    | ~ esk5145_4(X1,X2,X3,X4) ) ).

cnf(i_0_3469,axiom,
    ( esk11805_4(X1,X2,X3,X4)
    | esk11893_4(X1,X2,X3,X4)
    | ~ esk11886_4(X1,X2,X3,X4) ) ).

cnf(i_0_3470,axiom,
    ( ~ esk3608_4(X1,X2,X3,X4)
    | esk3457_4(X1,X2,X3,X4)
    | esk3488_4(X1,X2,X3,X4) ) ).

cnf(i_0_3471,axiom,
    ( esk7992_4(X1,X2,X3,X4)
    | esk7994_4(X1,X2,X3,X4)
    | esk7993_4(X1,X2,X3,X4) ) ).

cnf(i_0_3472,axiom,
    ( esk8462_4(X1,X2,X3,X4)
    | esk8429_4(X1,X2,X3,X4) ) ).

cnf(i_0_3473,axiom,
    ( ~ esk8936_4(X1,X2,X3,X4)
    | ~ esk8916_4(X1,X2,X3,X4) ) ).

cnf(i_0_3474,axiom,
    ( ~ esk8242_4(X1,X2,X3,X4)
    | esk8241_4(X1,X2,X3,X4) ) ).

cnf(i_0_3475,axiom,
    ( esk16477_4(X1,X2,X3,X4)
    | esk16449_4(X1,X2,X3,X4) ) ).

cnf(i_0_3476,axiom,
    ( esk12577_4(X1,X2,X3,X4)
    | ~ esk12529_4(X1,X2,X3,X4) ) ).

cnf(i_0_3477,axiom,
    ( esk946_4(X1,X2,X3,X4)
    | ~ esk1204_4(X1,X2,X3,X4) ) ).

cnf(i_0_3478,axiom,
    ( esk5459_4(X1,X2,X3,X4)
    | ~ esk5436_4(X1,X2,X3,X4)
    | esk5376_4(X1,X2,X3,X4) ) ).

cnf(i_0_3479,axiom,
    ( ~ esk7685_4(X1,X2,X3,X4)
    | ~ esk7653_4(X1,X2,X3,X4)
    | ~ esk7732_4(X1,X2,X3,X4) ) ).

cnf(i_0_3480,axiom,
    ( ~ esk2744_4(X1,X2,X3,X4)
    | esk2743_4(X1,X2,X3,X4) ) ).

cnf(i_0_3481,axiom,
    ( esk383_4(X1,X2,X3,X4)
    | ~ esk403_4(X1,X2,X3,X4) ) ).

cnf(i_0_3482,axiom,
    ( esk12348_4(X1,X2,X3,X4)
    | ~ esk12347_4(X1,X2,X3,X4) ) ).

cnf(i_0_3483,axiom,
    ( esk6970_4(X1,X2,X3,X4)
    | esk6984_4(X1,X2,X3,X4) ) ).

cnf(i_0_3484,axiom,
    ( esk10477_4(X1,X2,X3,X4)
    | esk10482_4(X1,X2,X3,X4) ) ).

cnf(i_0_3485,axiom,
    ( esk10221_4(X1,X2,X3,X4)
    | esk10230_4(X1,X2,X3,X4) ) ).

cnf(i_0_3486,axiom,
    ( esk14655_4(X1,X2,X3,X4)
    | ~ esk14913_4(X1,X2,X3,X4) ) ).

cnf(i_0_3487,axiom,
    ( ~ esk8687_4(X1,X2,X3,X4)
    | ~ esk8676_4(X1,X2,X3,X4)
    | ~ esk8686_4(X1,X2,X3,X4) ) ).

cnf(i_0_3488,axiom,
    ( esk7480_4(X1,X2,X3,X4)
    | ~ esk7454_4(X1,X2,X3,X4)
    | esk7505_4(X1,X2,X3,X4) ) ).

cnf(i_0_3489,axiom,
    ( ~ esk10451_4(X1,X2,X3,X4)
    | esk10452_4(X1,X2,X3,X4) ) ).

cnf(i_0_3490,axiom,
    ( ~ esk1778_4(X1,X2,X3,X4)
    | esk1520_4(X1,X2,X3,X4) ) ).

cnf(i_0_3491,axiom,
    ( ~ esk8650_4(X1,X2,X3,X4)
    | esk8636_4(X1,X2,X3,X4)
    | esk8643_4(X1,X2,X3,X4) ) ).

cnf(i_0_3492,axiom,
    ( esk16130_4(X1,X2,X3,X4)
    | ~ esk16169_4(X1,X2,X3,X4) ) ).

cnf(i_0_3493,axiom,
    ( ~ esk8026_4(X1,X2,X3,X4)
    | ~ esk8025_4(X1,X2,X3,X4)
    | esk8027_4(X1,X2,X3,X4) ) ).

cnf(i_0_3494,axiom,
    ( ~ esk13857_4(X1,X2,X3,X4)
    | esk13599_4(X1,X2,X3,X4) ) ).

cnf(i_0_3495,axiom,
    ( ~ esk14636_4(X1,X2,X3,X4)
    | esk14717_4(X1,X2,X3,X4) ) ).

cnf(i_0_3496,axiom,
    ( ~ esk3593_4(X1,X2,X3,X4)
    | ~ esk3628_4(X1,X2,X3,X4)
    | ~ esk3629_4(X1,X2,X3,X4) ) ).

cnf(i_0_3497,axiom,
    ( esk5184_4(X1,X2,X3,X4)
    | esk5099_4(X1,X2,X3,X4) ) ).

cnf(i_0_3498,axiom,
    ( esk1586_4(X1,X2,X3,X4)
    | ~ esk1585_4(X1,X2,X3,X4)
    | ~ esk1584_4(X1,X2,X3,X4) ) ).

cnf(i_0_3499,axiom,
    ( ~ esk2496_4(X1,X2,X3,X4)
    | esk2574_4(X1,X2,X3,X4) ) ).

cnf(i_0_3500,axiom,
    ( ~ esk12011_4(X1,X2,X3,X4)
    | esk12071_4(X1,X2,X3,X4) ) ).

cnf(i_0_3501,axiom,
    ( esk2486_4(X1,X2,X3,X4)
    | ~ esk2487_4(X1,X2,X3,X4) ) ).

cnf(i_0_3502,axiom,
    ( ~ esk448_4(X1,X2,X3,X4)
    | esk502_4(X1,X2,X3,X4) ) ).

cnf(i_0_3503,axiom,
    ( ~ esk3585_4(X1,X2,X3,X4)
    | ~ esk3552_4(X1,X2,X3,X4)
    | ~ esk3539_4(X1,X2,X3,X4) ) ).

cnf(i_0_3504,axiom,
    ( ~ esk5822_4(X1,X2,X3,X4)
    | esk5810_4(X1,X2,X3,X4)
    | esk5821_4(X1,X2,X3,X4) ) ).

cnf(i_0_3505,axiom,
    ( esk11007_4(X1,X2,X3,X4)
    | esk10992_4(X1,X2,X3,X4) ) ).

cnf(i_0_3506,axiom,
    ( ~ esk3519_4(X1,X2,X3,X4)
    | ~ esk3618_4(X1,X2,X3,X4) ) ).

cnf(i_0_3507,axiom,
    ( esk12147_4(X1,X2,X3,X4)
    | ~ esk12113_4(X1,X2,X3,X4) ) ).

cnf(i_0_3508,axiom,
    ( esk13254_4(X1,X2,X3,X4)
    | esk13379_4(X1,X2,X3,X4) ) ).

cnf(i_0_3509,axiom,
    ( ~ esk5156_4(X1,X2,X3,X4)
    | esk5154_4(X1,X2,X3,X4)
    | esk5155_4(X1,X2,X3,X4) ) ).

cnf(i_0_3510,axiom,
    ( ~ esk3305_4(X1,X2,X3,X4)
    | ~ esk3338_4(X1,X2,X3,X4)
    | ~ esk3282_4(X1,X2,X3,X4) ) ).

cnf(i_0_3511,axiom,
    ( ~ esk15312_4(X1,X2,X3,X4)
    | ~ esk15313_4(X1,X2,X3,X4)
    | ~ esk15260_4(X1,X2,X3,X4)
    | ~ esk15259_4(X1,X2,X3,X4)
    | ~ esk15262_4(X1,X2,X3,X4) ) ).

cnf(i_0_3512,axiom,
    ( esk7773_4(X1,X2,X3,X4)
    | esk7659_4(X1,X2,X3,X4) ) ).

cnf(i_0_3513,axiom,
    ( ~ esk7396_4(X1,X2,X3,X4)
    | ~ esk7505_4(X1,X2,X3,X4)
    | ~ esk7422_4(X1,X2,X3,X4) ) ).

cnf(i_0_3514,axiom,
    ( ~ esk14419_4(X1,X2,X3,X4)
    | ~ esk14393_4(X1,X2,X3,X4)
    | ~ esk14444_4(X1,X2,X3,X4) ) ).

cnf(i_0_3515,axiom,
    ( ~ p(X3)
    | ~ p(X1)
    | ~ esk433_4(X1,X2,X3,X4)
    | p(X2)
    | esk58_0
    | ~ p(X4) ) ).

cnf(i_0_3516,axiom,
    ( esk700_4(X1,X2,X3,X4)
    | esk737_4(X1,X2,X3,X4) ) ).

cnf(i_0_3517,axiom,
    ( esk13418_4(X1,X2,X3,X4)
    | ~ esk13417_4(X1,X2,X3,X4) ) ).

cnf(i_0_3518,axiom,
    ( esk3489_4(X1,X2,X3,X4)
    | ~ esk3472_4(X1,X2,X3,X4) ) ).

cnf(i_0_3519,axiom,
    ( esk4933_4(X1,X2,X3,X4)
    | esk4848_4(X1,X2,X3,X4) ) ).

cnf(i_0_3520,axiom,
    ( esk16773_4(X1,X2,X3,X4)
    | ~ esk16692_4(X1,X2,X3,X4) ) ).

cnf(i_0_3521,axiom,
    ( ~ esk1693_4(X1,X2,X3,X4)
    | ~ esk1691_4(X1,X2,X3,X4) ) ).

cnf(i_0_3522,axiom,
    ( ~ esk9011_4(X1,X2,X3,X4)
    | esk9013_4(X1,X2,X3,X4)
    | ~ esk9012_4(X1,X2,X3,X4) ) ).

cnf(i_0_3523,axiom,
    ( ~ esk1583_4(X1,X2,X3,X4)
    | ~ esk1565_4(X1,X2,X3,X4) ) ).

cnf(i_0_3524,axiom,
    ( esk5981_4(X1,X2,X3,X4)
    | esk5912_4(X1,X2,X3,X4) ) ).

cnf(i_0_3525,axiom,
    ( ~ esk5080_4(X1,X2,X3,X4)
    | esk5116_4(X1,X2,X3,X4) ) ).

cnf(i_0_3526,axiom,
    ( esk9693_4(X1,X2,X3,X4)
    | ~ esk9768_4(X1,X2,X3,X4) ) ).

cnf(i_0_3527,axiom,
    ( esk3309_4(X1,X2,X3,X4)
    | esk3282_4(X1,X2,X3,X4) ) ).

cnf(i_0_3528,axiom,
    ( esk7181_4(X1,X2,X3,X4)
    | esk7267_4(X1,X2,X3,X4) ) ).

cnf(i_0_3529,axiom,
    ( ~ esk6711_4(X1,X2,X3,X4)
    | esk6732_4(X1,X2,X3,X4)
    | esk6710_4(X1,X2,X3,X4) ) ).

cnf(i_0_3530,axiom,
    ( esk14585_4(X1,X2,X3,X4)
    | esk14601_4(X1,X2,X3,X4) ) ).

cnf(i_0_3531,axiom,
    ( esk6964_4(X1,X2,X3,X4)
    | esk6946_4(X1,X2,X3,X4) ) ).

cnf(i_0_3532,axiom,
    ( esk1064_4(X1,X2,X3,X4)
    | esk1066_4(X1,X2,X3,X4) ) ).

cnf(i_0_3533,axiom,
    ( esk8886_4(X1,X2,X3,X4)
    | ~ esk8876_4(X1,X2,X3,X4) ) ).

cnf(i_0_3534,axiom,
    ( ~ esk12288_4(X1,X2,X3,X4)
    | ~ esk12289_4(X1,X2,X3,X4)
    | ~ esk12272_4(X1,X2,X3,X4) ) ).

cnf(i_0_3535,axiom,
    ( ~ esk6207_4(X1,X2,X3,X4)
    | ~ esk6147_4(X1,X2,X3,X4)
    | ~ esk6230_4(X1,X2,X3,X4) ) ).

cnf(i_0_3536,axiom,
    ( ~ esk6348_4(X1,X2,X3,X4)
    | esk6312_4(X1,X2,X3,X4)
    | ~ esk6328_4(X1,X2,X3,X4) ) ).

cnf(i_0_3537,axiom,
    ( esk7205_4(X1,X2,X3,X4)
    | ~ esk7207_4(X1,X2,X3,X4) ) ).

cnf(i_0_3538,axiom,
    ( esk3609_4(X1,X2,X3,X4)
    | ~ esk3610_4(X1,X2,X3,X4) ) ).

cnf(i_0_3539,axiom,
    ( esk6734_4(X1,X2,X3,X4)
    | ~ esk6683_4(X1,X2,X3,X4)
    | esk6709_4(X1,X2,X3,X4) ) ).

cnf(i_0_3540,axiom,
    ( ~ esk3551_4(X1,X2,X3,X4)
    | ~ esk3663_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_3541,axiom,
    ( esk15961_4(X1,X2,X3,X4)
    | esk15963_4(X1,X2,X3,X4) ) ).

cnf(i_0_3542,axiom,
    ( ~ esk2668_4(X1,X2,X3,X4)
    | ~ esk2720_4(X1,X2,X3,X4) ) ).

cnf(i_0_3543,axiom,
    ( esk8735_4(X1,X2,X3,X4)
    | ~ esk8477_4(X1,X2,X3,X4) ) ).

cnf(i_0_3544,axiom,
    ( ~ esk10968_4(X1,X2,X3,X4)
    | esk10966_4(X1,X2,X3,X4) ) ).

cnf(i_0_3545,axiom,
    ( esk7378_4(X1,X2,X3,X4)
    | ~ esk7459_4(X1,X2,X3,X4) ) ).

cnf(i_0_3546,axiom,
    ( esk14335_4(X1,X2,X3,X4)
    | esk14337_4(X1,X2,X3,X4) ) ).

cnf(i_0_3547,axiom,
    ( esk8619_4(X1,X2,X3,X4)
    | ~ esk8595_4(X1,X2,X3,X4) ) ).

cnf(i_0_3548,axiom,
    ( esk15832_4(X1,X2,X3,X4)
    | ~ esk15846_4(X1,X2,X3,X4)
    | esk15839_4(X1,X2,X3,X4) ) ).

cnf(i_0_3549,axiom,
    ( esk12857_4(X1,X2,X3,X4)
    | esk12872_4(X1,X2,X3,X4) ) ).

cnf(i_0_3550,axiom,
    ( esk8239_4(X1,X2,X3,X4)
    | esk8114_4(X1,X2,X3,X4) ) ).

cnf(i_0_3551,axiom,
    ( esk3381_4(X1,X2,X3,X4)
    | ~ esk3374_4(X1,X2,X3,X4)
    | esk3330_4(X1,X2,X3,X4) ) ).

cnf(i_0_3552,axiom,
    ( esk14683_4(X1,X2,X3,X4)
    | esk14685_4(X1,X2,X3,X4)
    | esk14684_4(X1,X2,X3,X4) ) ).

cnf(i_0_3553,axiom,
    ( ~ esk8501_4(X1,X2,X3,X4)
    | ~ esk8494_4(X1,X2,X3,X4)
    | ~ esk8403_4(X1,X2,X3,X4) ) ).

cnf(i_0_3554,axiom,
    ( esk8725_4(X1,X2,X3,X4)
    | ~ esk8623_4(X1,X2,X3,X4) ) ).

cnf(i_0_3555,axiom,
    ( ~ esk3295_4(X1,X2,X3,X4)
    | ~ esk3328_4(X1,X2,X3,X4)
    | ~ esk3282_4(X1,X2,X3,X4) ) ).

cnf(i_0_3556,axiom,
    ( esk13915_4(X1,X2,X3,X4)
    | esk13941_4(X1,X2,X3,X4)
    | ~ esk13916_4(X1,X2,X3,X4) ) ).

cnf(i_0_3557,axiom,
    ( esk9066_4(X1,X2,X3,X4)
    | esk9031_4(X1,X2,X3,X4) ) ).

cnf(i_0_3558,axiom,
    ( ~ esk10992_4(X1,X2,X3,X4)
    | ~ esk11017_4(X1,X2,X3,X4)
    | ~ esk11050_4(X1,X2,X3,X4) ) ).

cnf(i_0_3559,axiom,
    ( esk5416_4(X1,X2,X3,X4)
    | ~ esk5415_4(X1,X2,X3,X4) ) ).

cnf(i_0_3560,axiom,
    ( esk12389_4(X1,X2,X3,X4)
    | esk12362_4(X1,X2,X3,X4)
    | ~ esk12390_4(X1,X2,X3,X4) ) ).

cnf(i_0_3561,axiom,
    ( esk507_4(X1,X2,X3,X4)
    | ~ esk387_4(X1,X2,X3,X4) ) ).

cnf(i_0_3562,axiom,
    ( ~ esk2859_4(X1,X2,X3,X4)
    | ~ esk2820_4(X1,X2,X3,X4) ) ).

cnf(i_0_3563,axiom,
    ( ~ esk5173_4(X1,X2,X3,X4)
    | ~ esk5180_4(X1,X2,X3,X4)
    | ~ esk5129_4(X1,X2,X3,X4) ) ).

cnf(i_0_3564,axiom,
    ( esk16366_4(X1,X2,X3,X4)
    | ~ esk16368_4(X1,X2,X3,X4) ) ).

cnf(i_0_3565,axiom,
    ( esk6301_4(X1,X2,X3,X4)
    | ~ esk6272_4(X1,X2,X3,X4) ) ).

cnf(i_0_3566,axiom,
    ( p(X3)
    | ~ p(X1)
    | p(X2)
    | ~ esk326_0
    | esk534_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_3567,axiom,
    ( esk12341_4(X1,X2,X3,X4)
    | ~ esk12395_4(X1,X2,X3,X4)
    | esk12358_4(X1,X2,X3,X4) ) ).

cnf(i_0_3568,axiom,
    esk3743_4(X1,X2,X3,X4) ).

cnf(i_0_3569,axiom,
    ( esk14086_4(X1,X2,X3,X4)
    | esk14078_4(X1,X2,X3,X4) ) ).

cnf(i_0_3570,axiom,
    ( esk13361_4(X1,X2,X3,X4)
    | esk13392_4(X1,X2,X3,X4) ) ).

cnf(i_0_3571,axiom,
    ( esk12333_4(X1,X2,X3,X4)
    | ~ esk12211_4(X1,X2,X3,X4) ) ).

cnf(i_0_3572,axiom,
    ( ~ esk3265_4(X1,X2,X3,X4)
    | ~ esk3354_4(X1,X2,X3,X4) ) ).

cnf(i_0_3573,axiom,
    ( ~ esk10524_4(X1,X2,X3,X4)
    | ~ esk10491_4(X1,X2,X3,X4)
    | ~ esk10478_4(X1,X2,X3,X4) ) ).

cnf(i_0_3574,axiom,
    ( ~ esk11195_4(X1,X2,X3,X4)
    | ~ esk11249_4(X1,X2,X3,X4) ) ).

cnf(i_0_3575,axiom,
    ( esk2457_4(X1,X2,X3,X4)
    | ~ esk2493_4(X1,X2,X3,X4)
    | ~ esk2473_4(X1,X2,X3,X4) ) ).

cnf(i_0_3576,axiom,
    ( esk11028_4(X1,X2,X3,X4)
    | ~ esk10770_4(X1,X2,X3,X4) ) ).

cnf(i_0_3577,axiom,
    ( ~ esk11491_4(X1,X2,X3,X4)
    | esk11569_4(X1,X2,X3,X4) ) ).

cnf(i_0_3578,axiom,
    ( ~ esk1692_4(X1,X2,X3,X4)
    | ~ esk1662_4(X1,X2,X3,X4) ) ).

cnf(i_0_3579,axiom,
    ( ~ esk3086_4(X1,X2,X3,X4)
    | esk3344_4(X1,X2,X3,X4) ) ).

cnf(i_0_3580,axiom,
    ( ~ esk4111_4(X1,X2,X3,X4)
    | ~ esk4003_4(X1,X2,X3,X4)
    | esk3988_4(X1,X2,X3,X4) ) ).

cnf(i_0_3581,axiom,
    ( esk9915_4(X1,X2,X3,X4)
    | esk9913_4(X1,X2,X3,X4)
    | esk9890_4(X1,X2,X3,X4) ) ).

cnf(i_0_3582,axiom,
    ( ~ esk5206_4(X1,X2,X3,X4)
    | ~ esk5174_4(X1,X2,X3,X4) ) ).

cnf(i_0_3583,axiom,
    ( esk16447_4(X1,X2,X3,X4)
    | esk16477_4(X1,X2,X3,X4) ) ).

cnf(i_0_3584,axiom,
    ( ~ esk10465_4(X1,X2,X3,X4)
    | esk10537_4(X1,X2,X3,X4) ) ).

cnf(i_0_3585,axiom,
    ( ~ esk4017_4(X1,X2,X3,X4)
    | ~ esk4016_4(X1,X2,X3,X4) ) ).

cnf(i_0_3586,axiom,
    ( esk12599_4(X1,X2,X3,X4)
    | ~ esk12857_4(X1,X2,X3,X4) ) ).

cnf(i_0_3587,axiom,
    ( esk12978_4(X1,X2,X3,X4)
    | ~ esk13096_4(X1,X2,X3,X4)
    | ~ esk12998_4(X1,X2,X3,X4) ) ).

cnf(i_0_3588,axiom,
    ( ~ esk5429_4(X1,X2,X3,X4)
    | ~ esk5420_4(X1,X2,X3,X4) ) ).

cnf(i_0_3589,axiom,
    ( esk6735_4(X1,X2,X3,X4)
    | esk6707_4(X1,X2,X3,X4) ) ).

cnf(i_0_3590,axiom,
    ( esk10908_4(X1,X2,X3,X4)
    | ~ esk10932_4(X1,X2,X3,X4) ) ).

cnf(i_0_3591,axiom,
    ( esk7601_4(X1,X2,X3,X4)
    | ~ esk7582_4(X1,X2,X3,X4) ) ).

cnf(i_0_3592,axiom,
    ( ~ p(X2)
    | ~ p(X4)
    | esk16695_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X1)
    | ~ esk1_0 ) ).

cnf(i_0_3593,axiom,
    ( ~ esk9867_4(X1,X2,X3,X4)
    | esk9902_4(X1,X2,X3,X4) ) ).

cnf(i_0_3594,axiom,
    ( ~ esk16087_4(X1,X2,X3,X4)
    | ~ esk16105_4(X1,X2,X3,X4) ) ).

cnf(i_0_3595,axiom,
    ( esk15374_4(X1,X2,X3,X4)
    | esk15355_4(X1,X2,X3,X4) ) ).

cnf(i_0_3596,axiom,
    ( esk2268_4(X1,X2,X3,X4)
    | esk2382_4(X1,X2,X3,X4) ) ).

cnf(i_0_3597,axiom,
    ( esk1769_4(X1,X2,X3,X4)
    | esk1740_4(X1,X2,X3,X4) ) ).

cnf(i_0_3598,axiom,
    ( esk7604_4(X1,X2,X3,X4)
    | ~ esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_3599,axiom,
    ( ~ esk13238_4(X1,X2,X3,X4)
    | esk13213_4(X1,X2,X3,X4) ) ).

cnf(i_0_3600,axiom,
    ( ~ esk12524_4(X1,X2,X3,X4)
    | esk12587_4(X1,X2,X3,X4) ) ).

cnf(i_0_3601,axiom,
    ( ~ esk1407_4(X1,X2,X3,X4)
    | ~ esk1435_4(X1,X2,X3,X4) ) ).

cnf(i_0_3602,axiom,
    ( ~ esk12754_4(X1,X2,X3,X4)
    | ~ esk12755_4(X1,X2,X3,X4) ) ).

cnf(i_0_3603,axiom,
    ( esk3585_4(X1,X2,X3,X4)
    | esk3552_4(X1,X2,X3,X4) ) ).

cnf(i_0_3604,axiom,
    ( esk4395_4(X1,X2,X3,X4)
    | esk4372_4(X1,X2,X3,X4) ) ).

cnf(i_0_3605,axiom,
    ( ~ esk15114_4(X1,X2,X3,X4)
    | ~ esk15100_4(X1,X2,X3,X4)
    | ~ esk15113_4(X1,X2,X3,X4) ) ).

cnf(i_0_3606,axiom,
    ( esk1860_4(X1,X2,X3,X4)
    | esk1744_4(X1,X2,X3,X4) ) ).

cnf(i_0_3607,axiom,
    ( esk7662_4(X1,X2,X3,X4)
    | esk7695_4(X1,X2,X3,X4) ) ).

cnf(i_0_3608,axiom,
    ( ~ esk15198_4(X1,X2,X3,X4)
    | esk15230_4(X1,X2,X3,X4) ) ).

cnf(i_0_3609,axiom,
    ( p(X3)
    | p(X4)
    | esk16711_4(X1,X2,X3,X4)
    | ~ esk296_0
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_3610,axiom,
    ( ~ esk4755_4(X1,X2,X3,X4)
    | esk4734_4(X1,X2,X3,X4) ) ).

cnf(i_0_3611,axiom,
    ( ~ esk10718_4(X1,X2,X3,X4)
    | ~ esk10807_4(X1,X2,X3,X4) ) ).

cnf(i_0_3612,axiom,
    ( esk9033_4(X1,X2,X3,X4)
    | esk9032_4(X1,X2,X3,X4)
    | esk9034_4(X1,X2,X3,X4) ) ).

cnf(i_0_3613,axiom,
    ( esk2628_4(X1,X2,X3,X4)
    | ~ esk2627_4(X1,X2,X3,X4) ) ).

cnf(i_0_3614,axiom,
    ( ~ esk11730_4(X1,X2,X3,X4)
    | esk11731_4(X1,X2,X3,X4)
    | ~ esk11729_4(X1,X2,X3,X4) ) ).

cnf(i_0_3615,axiom,
    ( ~ esk6414_4(X1,X2,X3,X4)
    | esk6458_4(X1,X2,X3,X4)
    | esk6465_4(X1,X2,X3,X4) ) ).

cnf(i_0_3616,axiom,
    ( esk3546_4(X1,X2,X3,X4)
    | esk3536_4(X1,X2,X3,X4) ) ).

cnf(i_0_3617,axiom,
    ( ~ esk9519_4(X1,X2,X3,X4)
    | esk9399_4(X1,X2,X3,X4)
    | esk9368_4(X1,X2,X3,X4) ) ).

cnf(i_0_3618,axiom,
    ( ~ esk10864_4(X1,X2,X3,X4)
    | ~ esk10845_4(X1,X2,X3,X4)
    | ~ esk10793_4(X1,X2,X3,X4) ) ).

cnf(i_0_3619,axiom,
    ( ~ esk457_4(X1,X2,X3,X4)
    | ~ esk473_4(X1,X2,X3,X4)
    | ~ esk558_4(X1,X2,X3,X4) ) ).

cnf(i_0_3620,axiom,
    ( esk1081_4(X1,X2,X3,X4)
    | esk1054_4(X1,X2,X3,X4)
    | ~ esk1082_4(X1,X2,X3,X4) ) ).

cnf(i_0_3621,axiom,
    ( ~ esk13643_4(X1,X2,X3,X4)
    | ~ esk13628_4(X1,X2,X3,X4) ) ).

cnf(i_0_3622,axiom,
    ( ~ esk12213_4(X1,X2,X3,X4)
    | esk12182_4(X1,X2,X3,X4) ) ).

cnf(i_0_3623,axiom,
    ( esk14382_4(X1,X2,X3,X4)
    | ~ esk14640_4(X1,X2,X3,X4) ) ).

cnf(i_0_3624,axiom,
    ( ~ esk13549_4(X1,X2,X3,X4)
    | ~ esk13589_4(X1,X2,X3,X4)
    | ~ esk13590_4(X1,X2,X3,X4) ) ).

cnf(i_0_3625,axiom,
    ( esk14582_4(X1,X2,X3,X4)
    | esk14607_4(X1,X2,X3,X4) ) ).

cnf(i_0_3626,axiom,
    ( esk5973_4(X1,X2,X3,X4)
    | ~ esk5950_4(X1,X2,X3,X4)
    | esk5890_4(X1,X2,X3,X4) ) ).

cnf(i_0_3627,axiom,
    ( esk5854_4(X1,X2,X3,X4)
    | esk5870_4(X1,X2,X3,X4) ) ).

cnf(i_0_3628,axiom,
    ( ~ esk11207_4(X1,X2,X3,X4)
    | ~ esk11211_4(X1,X2,X3,X4) ) ).

cnf(i_0_3629,axiom,
    ( p(X2)
    | ~ p(X4)
    | ~ esk511_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X1)
    | esk223_0 ) ).

cnf(i_0_3630,axiom,
    ( esk2464_4(X1,X2,X3,X4)
    | ~ esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_3631,axiom,
    ( esk8120_4(X1,X2,X3,X4)
    | esk8144_4(X1,X2,X3,X4)
    | ~ esk8140_4(X1,X2,X3,X4) ) ).

cnf(i_0_3632,axiom,
    ( esk2203_4(X1,X2,X3,X4)
    | ~ esk2330_4(X1,X2,X3,X4)
    | esk2173_4(X1,X2,X3,X4) ) ).

cnf(i_0_3633,axiom,
    ( ~ esk11058_4(X1,X2,X3,X4)
    | esk11109_4(X1,X2,X3,X4) ) ).

cnf(i_0_3634,axiom,
    ( esk4520_4(X1,X2,X3,X4)
    | ~ esk4517_4(X1,X2,X3,X4) ) ).

cnf(i_0_3635,axiom,
    ( esk9182_4(X1,X2,X3,X4)
    | esk9217_4(X1,X2,X3,X4) ) ).

cnf(i_0_3636,axiom,
    ( esk5777_4(X1,X2,X3,X4)
    | esk5774_4(X1,X2,X3,X4)
    | esk5776_4(X1,X2,X3,X4)
    | esk5752_4(X1,X2,X3,X4)
    | esk5804_4(X1,X2,X3,X4) ) ).

cnf(i_0_3637,axiom,
    ( esk2446_4(X1,X2,X3,X4)
    | ~ esk2461_4(X1,X2,X3,X4)
    | ~ esk2569_4(X1,X2,X3,X4) ) ).

cnf(i_0_3638,axiom,
    ( esk9382_4(X1,X2,X3,X4)
    | ~ esk9359_4(X1,X2,X3,X4) ) ).

cnf(i_0_3639,axiom,
    ( ~ p(X1)
    | p(X2)
    | p(X4)
    | ~ p(X3)
    | esk16683_4(X1,X2,X3,X4)
    | ~ esk88_0 ) ).

cnf(i_0_3640,axiom,
    ( esk8877_4(X1,X2,X3,X4)
    | ~ esk8851_4(X1,X2,X3,X4) ) ).

cnf(i_0_3641,axiom,
    ( ~ esk3878_4(X1,X2,X3,X4)
    | ~ esk3886_4(X1,X2,X3,X4) ) ).

cnf(i_0_3642,axiom,
    ( esk12309_4(X1,X2,X3,X4)
    | esk12396_4(X1,X2,X3,X4) ) ).

cnf(i_0_3643,axiom,
    ( esk5456_4(X1,X2,X3,X4)
    | ~ esk5402_4(X1,X2,X3,X4) ) ).

cnf(i_0_3644,axiom,
    ( ~ esk13950_4(X1,X2,X3,X4)
    | ~ esk13869_4(X1,X2,X3,X4) ) ).

cnf(i_0_3645,axiom,
    ( esk9426_4(X1,X2,X3,X4)
    | ~ esk9425_4(X1,X2,X3,X4)
    | ~ esk9424_4(X1,X2,X3,X4) ) ).

cnf(i_0_3646,axiom,
    ( esk9666_4(X1,X2,X3,X4)
    | ~ esk9675_4(X1,X2,X3,X4) ) ).

cnf(i_0_3647,axiom,
    ( ~ esk11201_4(X1,X2,X3,X4)
    | ~ esk11147_4(X1,X2,X3,X4)
    | ~ esk11200_4(X1,X2,X3,X4)
    | ~ esk11150_4(X1,X2,X3,X4)
    | ~ esk11148_4(X1,X2,X3,X4) ) ).

cnf(i_0_3648,axiom,
    ( ~ esk5942_4(X1,X2,X3,X4)
    | esk5958_4(X1,X2,X3,X4) ) ).

cnf(i_0_3649,axiom,
    ( esk4724_4(X1,X2,X3,X4)
    | esk4748_4(X1,X2,X3,X4)
    | esk4749_4(X1,X2,X3,X4)
    | esk4776_4(X1,X2,X3,X4)
    | esk4746_4(X1,X2,X3,X4) ) ).

cnf(i_0_3650,axiom,
    ( esk14238_4(X1,X2,X3,X4)
    | ~ esk14269_4(X1,X2,X3,X4) ) ).

cnf(i_0_3651,axiom,
    ( esk7347_4(X1,X2,X3,X4)
    | ~ esk7342_4(X1,X2,X3,X4) ) ).

cnf(i_0_3652,axiom,
    ( ~ esk7230_4(X1,X2,X3,X4)
    | ~ esk7262_4(X1,X2,X3,X4) ) ).

cnf(i_0_3653,axiom,
    ( esk14878_4(X1,X2,X3,X4)
    | esk14832_4(X1,X2,X3,X4) ) ).

cnf(i_0_3654,axiom,
    ( ~ esk3609_4(X1,X2,X3,X4)
    | esk3608_4(X1,X2,X3,X4) ) ).

cnf(i_0_3655,axiom,
    ( ~ esk3234_4(X1,X2,X3,X4)
    | ~ esk3206_4(X1,X2,X3,X4) ) ).

cnf(i_0_3656,axiom,
    ( esk4750_4(X1,X2,X3,X4)
    | ~ esk4774_4(X1,X2,X3,X4) ) ).

cnf(i_0_3657,axiom,
    ( esk11281_4(X1,X2,X3,X4)
    | esk11251_4(X1,X2,X3,X4) ) ).

cnf(i_0_3658,axiom,
    ( ~ esk1194_4(X1,X2,X3,X4)
    | esk1185_4(X1,X2,X3,X4) ) ).

cnf(i_0_3659,axiom,
    ( esk2502_4(X1,X2,X3,X4)
    | ~ esk2562_4(X1,X2,X3,X4) ) ).

cnf(i_0_3660,axiom,
    ( ~ esk5793_4(X1,X2,X3,X4)
    | esk5767_4(X1,X2,X3,X4) ) ).

cnf(i_0_3661,axiom,
    ( ~ esk5388_4(X1,X2,X3,X4)
    | ~ esk5288_4(X1,X2,X3,X4)
    | esk5269_4(X1,X2,X3,X4) ) ).

cnf(i_0_3662,axiom,
    ( ~ esk10492_4(X1,X2,X3,X4)
    | ~ esk10472_4(X1,X2,X3,X4)
    | ~ esk10491_4(X1,X2,X3,X4) ) ).

cnf(i_0_3663,axiom,
    ( ~ esk12221_4(X1,X2,X3,X4)
    | esk12323_4(X1,X2,X3,X4) ) ).

cnf(i_0_3664,axiom,
    ( esk13050_4(X1,X2,X3,X4)
    | esk13066_4(X1,X2,X3,X4) ) ).

cnf(i_0_3665,axiom,
    ( ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1272_4(X1,X2,X3,X4)
    | ~ esk1239_4(X1,X2,X3,X4) ) ).

cnf(i_0_3666,axiom,
    ( ~ esk5912_4(X1,X2,X3,X4)
    | esk5654_4(X1,X2,X3,X4) ) ).

cnf(i_0_3667,axiom,
    ( ~ esk16687_4(X1,X2,X3,X4)
    | esk118_0
    | p(X2)
    | p(X4)
    | ~ p(X1)
    | ~ p(X3) ) ).

cnf(i_0_3668,axiom,
    ( esk10441_4(X1,X2,X3,X4)
    | esk10439_4(X1,X2,X3,X4)
    | ~ esk10445_4(X1,X2,X3,X4) ) ).

cnf(i_0_3669,axiom,
    ( ~ esk16134_4(X1,X2,X3,X4)
    | ~ esk16166_4(X1,X2,X3,X4)
    | ~ esk16213_4(X1,X2,X3,X4) ) ).

cnf(i_0_3670,axiom,
    ( esk4080_4(X1,X2,X3,X4)
    | esk4053_4(X1,X2,X3,X4) ) ).

cnf(i_0_3671,axiom,
    ( esk12080_4(X1,X2,X3,X4)
    | ~ esk11822_4(X1,X2,X3,X4) ) ).

cnf(i_0_3672,axiom,
    ( ~ esk14932_4(X1,X2,X3,X4)
    | ~ esk14909_4(X1,X2,X3,X4) ) ).

cnf(i_0_3673,axiom,
    ( esk11552_4(X1,X2,X3,X4)
    | ~ esk11450_4(X1,X2,X3,X4) ) ).

cnf(i_0_3674,axiom,
    ( ~ esk1316_4(X1,X2,X3,X4)
    | ~ esk1308_4(X1,X2,X3,X4) ) ).

cnf(i_0_3675,axiom,
    ( esk16476_4(X1,X2,X3,X4)
    | ~ esk16477_4(X1,X2,X3,X4)
    | esk16498_4(X1,X2,X3,X4) ) ).

cnf(i_0_3676,axiom,
    ( ~ esk3553_4(X1,X2,X3,X4)
    | ~ esk3667_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_3677,axiom,
    ( esk13849_4(X1,X2,X3,X4)
    | esk13934_4(X1,X2,X3,X4) ) ).

cnf(i_0_3678,axiom,
    ( esk11046_4(X1,X2,X3,X4)
    | esk11013_4(X1,X2,X3,X4) ) ).

cnf(i_0_3679,axiom,
    ( ~ esk15016_4(X1,X2,X3,X4)
    | esk15048_4(X1,X2,X3,X4) ) ).

cnf(i_0_3680,axiom,
    ( esk15909_4(X1,X2,X3,X4)
    | esk15877_4(X1,X2,X3,X4) ) ).

cnf(i_0_3681,axiom,
    ( ~ esk4286_4(X1,X2,X3,X4)
    | esk4264_4(X1,X2,X3,X4) ) ).

cnf(i_0_3682,axiom,
    ( esk11763_4(X1,X2,X3,X4)
    | esk11780_4(X1,X2,X3,X4) ) ).

cnf(i_0_3683,axiom,
    ( ~ esk5802_4(X1,X2,X3,X4)
    | esk5778_4(X1,X2,X3,X4) ) ).

cnf(i_0_3684,axiom,
    ( ~ esk14931_4(X1,X2,X3,X4)
    | esk14961_4(X1,X2,X3,X4) ) ).

cnf(i_0_3685,axiom,
    ( esk6163_4(X1,X2,X3,X4)
    | esk6217_4(X1,X2,X3,X4)
    | ~ esk6198_4(X1,X2,X3,X4) ) ).

cnf(i_0_3686,axiom,
    ( esk3828_4(X1,X2,X3,X4)
    | esk3798_4(X1,X2,X3,X4) ) ).

cnf(i_0_3687,axiom,
    ( ~ esk2093_4(X1,X2,X3,X4)
    | ~ esk2095_4(X1,X2,X3,X4) ) ).

cnf(i_0_3688,axiom,
    ( ~ esk4512_4(X1,X2,X3,X4)
    | esk4469_4(X1,X2,X3,X4) ) ).

cnf(i_0_3689,axiom,
    ( esk8963_4(X1,X2,X3,X4)
    | esk8923_4(X1,X2,X3,X4) ) ).

cnf(i_0_3690,axiom,
    ( esk10026_4(X1,X2,X3,X4)
    | esk10048_4(X1,X2,X3,X4)
    | ~ esk10078_4(X1,X2,X3,X4) ) ).

cnf(i_0_3691,axiom,
    ( ~ esk16593_4(X1,X2,X3,X4)
    | esk16594_4(X1,X2,X3,X4)
    | ~ esk16599_4(X1,X2,X3,X4) ) ).

cnf(i_0_3692,axiom,
    ( ~ esk16400_4(X1,X2,X3,X4)
    | ~ esk16389_4(X1,X2,X3,X4)
    | ~ esk16433_4(X1,X2,X3,X4) ) ).

cnf(i_0_3693,axiom,
    ( esk14845_4(X1,X2,X3,X4)
    | esk14852_4(X1,X2,X3,X4) ) ).

cnf(i_0_3694,axiom,
    ( ~ esk5130_4(X1,X2,X3,X4)
    | esk5388_4(X1,X2,X3,X4) ) ).

cnf(i_0_3695,axiom,
    ( esk12410_4(X1,X2,X3,X4)
    | esk12287_4(X1,X2,X3,X4) ) ).

cnf(i_0_3696,axiom,
    ( ~ esk2386_4(X1,X2,X3,X4)
    | ~ esk2364_4(X1,X2,X3,X4) ) ).

cnf(i_0_3697,axiom,
    ( esk5896_4(X1,X2,X3,X4)
    | esk5863_4(X1,X2,X3,X4) ) ).

cnf(i_0_3698,axiom,
    ( ~ p(X4)
    | ~ esk113_0
    | ~ p(X2)
    | esk16687_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1) ) ).

cnf(i_0_3699,axiom,
    ( esk9997_4(X1,X2,X3,X4)
    | esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_3700,axiom,
    ( ~ esk4315_4(X1,X2,X3,X4)
    | ~ esk4348_4(X1,X2,X3,X4)
    | ~ esk4310_4(X1,X2,X3,X4) ) ).

cnf(i_0_3701,axiom,
    ( esk10851_4(X1,X2,X3,X4)
    | esk10799_4(X1,X2,X3,X4) ) ).

cnf(i_0_3702,axiom,
    ( esk5621_4(X1,X2,X3,X4)
    | esk5583_4(X1,X2,X3,X4) ) ).

cnf(i_0_3703,axiom,
    ( ~ esk5597_4(X1,X2,X3,X4)
    | ~ esk5627_4(X1,X2,X3,X4)
    | ~ esk5714_4(X1,X2,X3,X4) ) ).

cnf(i_0_3704,axiom,
    ( esk3504_4(X1,X2,X3,X4)
    | esk3502_4(X1,X2,X3,X4) ) ).

cnf(i_0_3705,axiom,
    ( esk1826_4(X1,X2,X3,X4)
    | esk1869_4(X1,X2,X3,X4) ) ).

cnf(i_0_3706,axiom,
    ( esk9068_4(X1,X2,X3,X4)
    | esk8962_4(X1,X2,X3,X4) ) ).

cnf(i_0_3707,axiom,
    ( ~ esk900_4(X1,X2,X3,X4)
    | esk919_4(X1,X2,X3,X4) ) ).

cnf(i_0_3708,axiom,
    ( esk919_4(X1,X2,X3,X4)
    | ~ esk906_4(X1,X2,X3,X4) ) ).

cnf(i_0_3709,axiom,
    ( ~ esk9452_4(X1,X2,X3,X4)
    | ~ esk9468_4(X1,X2,X3,X4)
    | ~ esk9553_4(X1,X2,X3,X4) ) ).

cnf(i_0_3710,axiom,
    ( ~ esk8428_4(X1,X2,X3,X4)
    | ~ esk8424_4(X1,X2,X3,X4)
    | ~ esk8543_4(X1,X2,X3,X4) ) ).

cnf(i_0_3711,axiom,
    ( ~ esk8756_4(X1,X2,X3,X4)
    | esk8754_4(X1,X2,X3,X4) ) ).

cnf(i_0_3712,axiom,
    ( ~ esk646_4(X1,X2,X3,X4)
    | esk662_4(X1,X2,X3,X4) ) ).

cnf(i_0_3713,axiom,
    ( ~ esk7858_4(X1,X2,X3,X4)
    | ~ esk7966_4(X1,X2,X3,X4)
    | esk7843_4(X1,X2,X3,X4) ) ).

cnf(i_0_3714,axiom,
    ( esk9802_4(X1,X2,X3,X4)
    | ~ esk9831_4(X1,X2,X3,X4)
    | esk9751_4(X1,X2,X3,X4) ) ).

cnf(i_0_3715,axiom,
    ( ~ esk11763_4(X1,X2,X3,X4)
    | ~ esk11766_4(X1,X2,X3,X4)
    | ~ esk11799_4(X1,X2,X3,X4) ) ).

cnf(i_0_3716,axiom,
    ( ~ esk8936_4(X1,X2,X3,X4)
    | ~ esk8963_4(X1,X2,X3,X4)
    | ~ esk8996_4(X1,X2,X3,X4) ) ).

cnf(i_0_3717,axiom,
    ( esk11700_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4)
    | ~ esk11825_4(X1,X2,X3,X4) ) ).

cnf(i_0_3718,axiom,
    ( esk1416_4(X1,X2,X3,X4)
    | ~ esk1433_4(X1,X2,X3,X4)
    | ~ esk1537_4(X1,X2,X3,X4) ) ).

cnf(i_0_3719,axiom,
    ( esk12754_4(X1,X2,X3,X4)
    | esk12755_4(X1,X2,X3,X4)
    | esk12749_4(X1,X2,X3,X4) ) ).

cnf(i_0_3720,axiom,
    ( esk6830_4(X1,X2,X3,X4)
    | ~ esk6810_4(X1,X2,X3,X4) ) ).

cnf(i_0_3721,axiom,
    ( esk4757_4(X1,X2,X3,X4)
    | ~ esk4878_4(X1,X2,X3,X4)
    | ~ esk4774_4(X1,X2,X3,X4) ) ).

cnf(i_0_3722,axiom,
    ( esk5545_4(X1,X2,X3,X4)
    | ~ esk5526_4(X1,X2,X3,X4) ) ).

cnf(i_0_3723,axiom,
    ( ~ esk12491_4(X1,X2,X3,X4)
    | esk12233_4(X1,X2,X3,X4) ) ).

cnf(i_0_3724,axiom,
    ( ~ esk369_4(X1,X2,X3,X4)
    | esk397_4(X1,X2,X3,X4) ) ).

cnf(i_0_3725,axiom,
    ( ~ esk508_4(X1,X2,X3,X4)
    | esk445_4(X1,X2,X3,X4) ) ).

cnf(i_0_3726,axiom,
    ( esk9255_4(X1,X2,X3,X4)
    | esk9277_4(X1,X2,X3,X4)
    | ~ esk9307_4(X1,X2,X3,X4) ) ).

cnf(i_0_3727,axiom,
    ( ~ p(X2)
    | ~ esk16602_4(X1,X2,X3,X4)
    | esk22_0
    | p(X3)
    | p(X1)
    | p(X4) ) ).

cnf(i_0_3728,axiom,
    ( ~ esk6957_4(X1,X2,X3,X4)
    | esk6956_4(X1,X2,X3,X4) ) ).

cnf(i_0_3729,axiom,
    ( ~ esk7304_4(X1,X2,X3,X4)
    | esk7325_4(X1,X2,X3,X4) ) ).

cnf(i_0_3730,axiom,
    ( esk11310_4(X1,X2,X3,X4)
    | ~ esk11568_4(X1,X2,X3,X4) ) ).

cnf(i_0_3731,axiom,
    ( ~ esk14640_4(X1,X2,X3,X4)
    | ~ esk14721_4(X1,X2,X3,X4) ) ).

cnf(i_0_3732,axiom,
    ( esk8580_4(X1,X2,X3,X4)
    | esk8630_4(X1,X2,X3,X4) ) ).

cnf(i_0_3733,axiom,
    ( esk7882_4(X1,X2,X3,X4)
    | ~ esk7881_4(X1,X2,X3,X4) ) ).

cnf(i_0_3734,axiom,
    ( ~ esk16454_4(X1,X2,X3,X4)
    | esk16373_4(X1,X2,X3,X4) ) ).

cnf(i_0_3735,axiom,
    ( esk9289_4(X1,X2,X3,X4)
    | esk9233_4(X1,X2,X3,X4) ) ).

cnf(i_0_3736,axiom,
    ( esk15829_4(X1,X2,X3,X4)
    | ~ esk15851_4(X1,X2,X3,X4) ) ).

cnf(i_0_3737,axiom,
    ( ~ esk330_0
    | ~ p(X2)
    | p(X3)
    | p(X4)
    | ~ p(X1)
    | esk16724_4(X1,X2,X3,X4) ) ).

cnf(i_0_3738,axiom,
    ( ~ esk6964_4(X1,X2,X3,X4)
    | ~ esk6966_4(X1,X2,X3,X4) ) ).

cnf(i_0_3739,axiom,
    ( esk8424_4(X1,X2,X3,X4)
    | esk8430_4(X1,X2,X3,X4) ) ).

cnf(i_0_3740,axiom,
    ( ~ esk2469_4(X1,X2,X3,X4)
    | esk2481_4(X1,X2,X3,X4) ) ).

cnf(i_0_3741,axiom,
    ( esk15213_4(X1,X2,X3,X4)
    | ~ esk15191_4(X1,X2,X3,X4)
    | esk15192_4(X1,X2,X3,X4) ) ).

cnf(i_0_3742,axiom,
    ( esk5912_4(X1,X2,X3,X4)
    | ~ esk5963_4(X1,X2,X3,X4)
    | esk5938_4(X1,X2,X3,X4) ) ).

cnf(i_0_3743,axiom,
    ( ~ esk10824_4(X1,X2,X3,X4)
    | ~ esk10822_4(X1,X2,X3,X4) ) ).

cnf(i_0_3744,axiom,
    ( esk9914_4(X1,X2,X3,X4)
    | ~ esk9903_4(X1,X2,X3,X4) ) ).

cnf(i_0_3745,axiom,
    ( ~ esk11472_4(X1,X2,X3,X4)
    | esk11471_4(X1,X2,X3,X4)
    | esk11466_4(X1,X2,X3,X4) ) ).

cnf(i_0_3746,axiom,
    ( ~ esk14039_4(X1,X2,X3,X4)
    | ~ esk14041_4(X1,X2,X3,X4) ) ).

cnf(i_0_3747,axiom,
    ( esk15173_4(X1,X2,X3,X4)
    | ~ esk15053_4(X1,X2,X3,X4) ) ).

cnf(i_0_3748,axiom,
    ( ~ p(X1)
    | ~ p(X2)
    | p(X3)
    | ~ esk120_0
    | esk16687_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_3749,axiom,
    ( ~ esk14648_4(X1,X2,X3,X4)
    | esk14390_4(X1,X2,X3,X4) ) ).

cnf(i_0_3750,axiom,
    ( ~ esk15963_4(X1,X2,X3,X4)
    | ~ esk15964_4(X1,X2,X3,X4) ) ).

cnf(i_0_3751,axiom,
    ( esk6424_4(X1,X2,X3,X4)
    | esk6391_4(X1,X2,X3,X4) ) ).

cnf(i_0_3752,axiom,
    ( p(X4)
    | p(X2)
    | ~ p(X1)
    | ~ p(X3)
    | esk132_0
    | ~ esk499_4(X1,X2,X3,X4) ) ).

cnf(i_0_3753,axiom,
    ( ~ esk16137_4(X1,X2,X3,X4)
    | ~ esk16132_4(X1,X2,X3,X4)
    | ~ esk16170_4(X1,X2,X3,X4) ) ).

cnf(i_0_3754,axiom,
    ( esk4836_4(X1,X2,X3,X4)
    | esk4948_4(X1,X2,X3,X4) ) ).

cnf(i_0_3755,axiom,
    ( ~ esk14656_4(X1,X2,X3,X4)
    | esk14707_4(X1,X2,X3,X4) ) ).

cnf(i_0_3756,axiom,
    esk8112_4(X1,X2,X3,X4) ).

cnf(i_0_3757,axiom,
    ( ~ esk5651_4(X1,X2,X3,X4)
    | ~ esk5682_4(X1,X2,X3,X4) ) ).

cnf(i_0_3758,axiom,
    ( esk5724_4(X1,X2,X3,X4)
    | esk5655_4(X1,X2,X3,X4) ) ).

cnf(i_0_3759,axiom,
    ( esk13752_4(X1,X2,X3,X4)
    | ~ esk13727_4(X1,X2,X3,X4) ) ).

cnf(i_0_3760,axiom,
    ( ~ esk14313_4(X1,X2,X3,X4)
    | ~ esk14412_4(X1,X2,X3,X4) ) ).

cnf(i_0_3761,axiom,
    ( ~ esk254_0
    | p(X3)
    | ~ p(X2)
    | esk515_4(X1,X2,X3,X4)
    | p(X4)
    | ~ p(X1) ) ).

cnf(i_0_3762,axiom,
    ( esk696_4(X1,X2,X3,X4)
    | esk745_4(X1,X2,X3,X4) ) ).

cnf(i_0_3763,axiom,
    ( esk8658_4(X1,X2,X3,X4)
    | ~ esk8656_4(X1,X2,X3,X4) ) ).

cnf(i_0_3764,axiom,
    ( ~ esk9540_4(X1,X2,X3,X4)
    | ~ esk9532_4(X1,X2,X3,X4) ) ).

cnf(i_0_3765,axiom,
    ( ~ esk6073_4(X1,X2,X3,X4)
    | ~ esk6071_4(X1,X2,X3,X4) ) ).

cnf(i_0_3766,axiom,
    ( esk12905_4(X1,X2,X3,X4)
    | ~ esk12853_4(X1,X2,X3,X4) ) ).

cnf(i_0_3767,axiom,
    ( esk4804_4(X1,X2,X3,X4)
    | esk4896_4(X1,X2,X3,X4)
    | esk4903_4(X1,X2,X3,X4) ) ).

cnf(i_0_3768,axiom,
    ( esk6753_4(X1,X2,X3,X4)
    | esk6667_4(X1,X2,X3,X4) ) ).

cnf(i_0_3769,axiom,
    ( esk6937_4(X1,X2,X3,X4)
    | ~ esk6868_4(X1,X2,X3,X4) ) ).

cnf(i_0_3770,axiom,
    ( esk6115_4(X1,X2,X3,X4)
    | esk6230_4(X1,X2,X3,X4) ) ).

cnf(i_0_3771,axiom,
    ( ~ esk12321_4(X1,X2,X3,X4)
    | ~ esk12374_4(X1,X2,X3,X4)
    | ~ esk12372_4(X1,X2,X3,X4)
    | ~ esk12319_4(X1,X2,X3,X4) ) ).

cnf(i_0_3772,axiom,
    ( ~ esk2737_4(X1,X2,X3,X4)
    | esk2738_4(X1,X2,X3,X4) ) ).

cnf(i_0_3773,axiom,
    ( ~ esk2006_4(X1,X2,X3,X4)
    | ~ esk2007_4(X1,X2,X3,X4)
    | ~ esk1993_4(X1,X2,X3,X4) ) ).

cnf(i_0_3774,axiom,
    ( esk6654_4(X1,X2,X3,X4)
    | esk6608_4(X1,X2,X3,X4) ) ).

cnf(i_0_3775,axiom,
    ( esk15350_4(X1,X2,X3,X4)
    | ~ esk15416_4(X1,X2,X3,X4) ) ).

cnf(i_0_3776,axiom,
    ( ~ esk13687_4(X1,X2,X3,X4)
    | esk13688_4(X1,X2,X3,X4) ) ).

cnf(i_0_3777,axiom,
    ( p(X1)
    | p(X4)
    | ~ p(X2)
    | esk129_0
    | ~ p(X3)
    | ~ esk16689_4(X1,X2,X3,X4) ) ).

cnf(i_0_3778,axiom,
    ( esk15702_4(X1,X2,X3,X4)
    | esk15684_4(X1,X2,X3,X4) ) ).

cnf(i_0_3779,axiom,
    ( ~ esk12510_4(X1,X2,X3,X4)
    | esk12509_4(X1,X2,X3,X4) ) ).

cnf(i_0_3780,axiom,
    ( esk3461_4(X1,X2,X3,X4)
    | esk3439_4(X1,X2,X3,X4)
    | esk3464_4(X1,X2,X3,X4)
    | esk3491_4(X1,X2,X3,X4)
    | esk3463_4(X1,X2,X3,X4) ) ).

cnf(i_0_3781,axiom,
    ( ~ esk11970_4(X1,X2,X3,X4)
    | esk11946_4(X1,X2,X3,X4) ) ).

cnf(i_0_3782,axiom,
    ( esk1213_4(X1,X2,X3,X4)
    | esk1253_4(X1,X2,X3,X4) ) ).

cnf(i_0_3783,axiom,
    ( esk3840_4(X1,X2,X3,X4)
    | ~ esk3582_4(X1,X2,X3,X4) ) ).

cnf(i_0_3784,axiom,
    ( ~ esk16646_4(X1,X2,X3,X4)
    | ~ esk16677_4(X1,X2,X3,X4)
    | ~ esk16710_4(X1,X2,X3,X4) ) ).

cnf(i_0_3785,axiom,
    ( esk7776_4(X1,X2,X3,X4)
    | ~ esk7777_4(X1,X2,X3,X4)
    | esk7745_4(X1,X2,X3,X4) ) ).

cnf(i_0_3786,axiom,
    ( esk10966_4(X1,X2,X3,X4)
    | ~ esk10970_4(X1,X2,X3,X4) ) ).

cnf(i_0_3787,axiom,
    ( esk15592_4(X1,X2,X3,X4)
    | ~ esk15594_4(X1,X2,X3,X4) ) ).

cnf(i_0_3788,axiom,
    ( esk2517_4(X1,X2,X3,X4)
    | esk2509_4(X1,X2,X3,X4) ) ).

cnf(i_0_3789,axiom,
    ( ~ esk9919_4(X1,X2,X3,X4)
    | ~ esk9937_4(X1,X2,X3,X4) ) ).

cnf(i_0_3790,axiom,
    ( esk2308_4(X1,X2,X3,X4)
    | ~ esk2050_4(X1,X2,X3,X4) ) ).

cnf(i_0_3791,axiom,
    ( ~ esk14044_4(X1,X2,X3,X4)
    | esk14035_4(X1,X2,X3,X4) ) ).

cnf(i_0_3792,axiom,
    ( ~ esk3527_4(X1,X2,X3,X4)
    | esk3596_4(X1,X2,X3,X4) ) ).

cnf(i_0_3793,axiom,
    ( esk1541_4(X1,X2,X3,X4)
    | ~ esk1283_4(X1,X2,X3,X4) ) ).

cnf(i_0_3794,axiom,
    ( esk13394_4(X1,X2,X3,X4)
    | esk13395_4(X1,X2,X3,X4) ) ).

cnf(i_0_3795,axiom,
    ( esk8192_4(X1,X2,X3,X4)
    | esk8165_4(X1,X2,X3,X4) ) ).

cnf(i_0_3796,axiom,
    ( esk5782_4(X1,X2,X3,X4)
    | ~ esk5900_4(X1,X2,X3,X4)
    | ~ esk5802_4(X1,X2,X3,X4) ) ).

cnf(i_0_3797,axiom,
    ( esk15618_4(X1,X2,X3,X4)
    | esk15627_4(X1,X2,X3,X4) ) ).

cnf(i_0_3798,axiom,
    ( esk10918_4(X1,X2,X3,X4)
    | ~ esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_3799,axiom,
    ( ~ esk805_4(X1,X2,X3,X4)
    | ~ esk837_4(X1,X2,X3,X4) ) ).

cnf(i_0_3800,axiom,
    ( esk11351_4(X1,X2,X3,X4)
    | ~ esk11331_4(X1,X2,X3,X4) ) ).

cnf(i_0_3801,axiom,
    ( ~ esk4006_4(X1,X2,X3,X4)
    | esk4001_4(X1,X2,X3,X4)
    | ~ esk4000_4(X1,X2,X3,X4) ) ).

cnf(i_0_3802,axiom,
    ( ~ esk14134_4(X1,X2,X3,X4)
    | esk14205_4(X1,X2,X3,X4)
    | esk14186_4(X1,X2,X3,X4) ) ).

cnf(i_0_3803,axiom,
    ( esk2984_4(X1,X2,X3,X4)
    | ~ esk2993_4(X1,X2,X3,X4) ) ).

cnf(i_0_3804,axiom,
    ( esk14524_4(X1,X2,X3,X4)
    | ~ esk14497_4(X1,X2,X3,X4) ) ).

cnf(i_0_3805,axiom,
    ( ~ esk10288_4(X1,X2,X3,X4)
    | esk10289_4(X1,X2,X3,X4) ) ).

cnf(i_0_3806,axiom,
    ( esk7906_4(X1,X2,X3,X4)
    | esk7913_4(X1,X2,X3,X4) ) ).

cnf(i_0_3807,axiom,
    ( ~ esk10171_4(X1,X2,X3,X4)
    | ~ esk10271_4(X1,X2,X3,X4)
    | esk10152_4(X1,X2,X3,X4) ) ).

cnf(i_0_3808,axiom,
    ( ~ esk12476_4(X1,X2,X3,X4)
    | esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_3809,axiom,
    ( esk11030_4(X1,X2,X3,X4)
    | ~ esk11075_4(X1,X2,X3,X4) ) ).

cnf(i_0_3810,axiom,
    ( esk1059_4(X1,X2,X3,X4)
    | esk1051_4(X1,X2,X3,X4)
    | esk1060_4(X1,X2,X3,X4) ) ).

cnf(i_0_3811,axiom,
    ( esk15614_4(X1,X2,X3,X4)
    | esk15628_4(X1,X2,X3,X4) ) ).

cnf(i_0_3812,axiom,
    ( ~ esk9611_4(X1,X2,X3,X4)
    | esk9644_4(X1,X2,X3,X4) ) ).

cnf(i_0_3813,axiom,
    ( ~ esk14861_4(X1,X2,X3,X4)
    | ~ esk14975_4(X1,X2,X3,X4)
    | ~ esk14849_4(X1,X2,X3,X4) ) ).

cnf(i_0_3814,axiom,
    ( esk4860_4(X1,X2,X3,X4)
    | ~ esk4944_4(X1,X2,X3,X4)
    | esk4907_4(X1,X2,X3,X4) ) ).

cnf(i_0_3815,axiom,
    ( esk3379_4(X1,X2,X3,X4)
    | esk3324_4(X1,X2,X3,X4) ) ).

cnf(i_0_3816,axiom,
    ( esk6646_4(X1,X2,X3,X4)
    | esk6679_4(X1,X2,X3,X4) ) ).

cnf(i_0_3817,axiom,
    ( esk13377_4(X1,X2,X3,X4)
    | ~ esk13119_4(X1,X2,X3,X4) ) ).

cnf(i_0_3818,axiom,
    ( esk4009_4(X1,X2,X3,X4)
    | ~ esk4267_4(X1,X2,X3,X4) ) ).

cnf(i_0_3819,axiom,
    ( esk12662_4(X1,X2,X3,X4)
    | esk12548_4(X1,X2,X3,X4) ) ).

cnf(i_0_3820,axiom,
    ( ~ esk9048_4(X1,X2,X3,X4)
    | ~ esk9020_4(X1,X2,X3,X4) ) ).

cnf(i_0_3821,axiom,
    ( esk1192_4(X1,X2,X3,X4)
    | ~ esk1191_4(X1,X2,X3,X4) ) ).

cnf(i_0_3822,axiom,
    ( ~ esk15582_4(X1,X2,X3,X4)
    | ~ esk15587_4(X1,X2,X3,X4) ) ).

cnf(i_0_3823,axiom,
    ( ~ esk12046_4(X1,X2,X3,X4)
    | ~ esk12008_4(X1,X2,X3,X4)
    | ~ esk12045_4(X1,X2,X3,X4) ) ).

cnf(i_0_3824,axiom,
    ( esk11373_4(X1,X2,X3,X4)
    | esk11344_4(X1,X2,X3,X4)
    | ~ esk11293_4(X1,X2,X3,X4) ) ).

cnf(i_0_3825,axiom,
    ( esk5119_4(X1,X2,X3,X4)
    | esk5086_4(X1,X2,X3,X4) ) ).

cnf(i_0_3826,axiom,
    ( p(X4)
    | ~ esk264_0
    | ~ p(X2)
    | esk16707_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X3) ) ).

cnf(i_0_3827,axiom,
    ( esk8741_4(X1,X2,X3,X4)
    | esk8708_4(X1,X2,X3,X4) ) ).

cnf(i_0_3828,axiom,
    ( ~ esk12576_4(X1,X2,X3,X4)
    | ~ esk12657_4(X1,X2,X3,X4)
    | ~ esk12664_4(X1,X2,X3,X4) ) ).

cnf(i_0_3829,axiom,
    ( esk4854_4(X1,X2,X3,X4)
    | esk4826_4(X1,X2,X3,X4) ) ).

cnf(i_0_3830,axiom,
    ( ~ esk3576_4(X1,X2,X3,X4)
    | esk3537_4(X1,X2,X3,X4) ) ).

cnf(i_0_3831,axiom,
    ( ~ esk16172_4(X1,X2,X3,X4)
    | ~ esk16228_4(X1,X2,X3,X4) ) ).

cnf(i_0_3832,axiom,
    ( esk14349_4(X1,X2,X3,X4)
    | esk14432_4(X1,X2,X3,X4) ) ).

cnf(i_0_3833,axiom,
    ( ~ esk5975_4(X1,X2,X3,X4)
    | esk5894_4(X1,X2,X3,X4)
    | esk5982_4(X1,X2,X3,X4) ) ).

cnf(i_0_3834,axiom,
    ( esk11098_4(X1,X2,X3,X4)
    | ~ esk11044_4(X1,X2,X3,X4) ) ).

cnf(i_0_3835,axiom,
    ( esk1733_4(X1,X2,X3,X4)
    | ~ esk1787_4(X1,X2,X3,X4) ) ).

cnf(i_0_3836,axiom,
    ( ~ esk4252_4(X1,X2,X3,X4)
    | esk4224_4(X1,X2,X3,X4) ) ).

cnf(i_0_3837,axiom,
    ( esk3898_4(X1,X2,X3,X4)
    | ~ esk3927_4(X1,X2,X3,X4) ) ).

cnf(i_0_3838,axiom,
    esk2715_4(X1,X2,X3,X4) ).

cnf(i_0_3839,axiom,
    ( esk11078_4(X1,X2,X3,X4)
    | esk11121_4(X1,X2,X3,X4) ) ).

cnf(i_0_3840,axiom,
    ( esk16775_4(X1,X2,X3,X4)
    | esk16732_4(X1,X2,X3,X4) ) ).

cnf(i_0_3841,axiom,
    ( ~ p(X1)
    | esk194_0
    | ~ esk507_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | p(X4) ) ).

cnf(i_0_3842,axiom,
    ( esk4260_4(X1,X2,X3,X4)
    | ~ esk4248_4(X1,X2,X3,X4) ) ).

cnf(i_0_3843,axiom,
    ( ~ esk3202_4(X1,X2,X3,X4)
    | esk3264_4(X1,X2,X3,X4) ) ).

cnf(i_0_3844,axiom,
    ( ~ esk14282_4(X1,X2,X3,X4)
    | ~ esk14284_4(X1,X2,X3,X4) ) ).

cnf(i_0_3845,axiom,
    ( ~ esk3025_4(X1,X2,X3,X4)
    | ~ esk3075_4(X1,X2,X3,X4)
    | ~ esk3042_4(X1,X2,X3,X4) ) ).

cnf(i_0_3846,axiom,
    ( esk9046_4(X1,X2,X3,X4)
    | ~ esk8994_4(X1,X2,X3,X4)
    | esk9065_4(X1,X2,X3,X4) ) ).

cnf(i_0_3847,axiom,
    ( ~ esk16232_4(X1,X2,X3,X4)
    | ~ esk16214_4(X1,X2,X3,X4) ) ).

cnf(i_0_3848,axiom,
    ( esk8205_4(X1,X2,X3,X4)
    | esk8172_4(X1,X2,X3,X4) ) ).

cnf(i_0_3849,axiom,
    ( ~ esk12483_4(X1,X2,X3,X4)
    | ~ esk12485_4(X1,X2,X3,X4) ) ).

cnf(i_0_3850,axiom,
    ( ~ esk10079_4(X1,X2,X3,X4)
    | ~ esk9994_4(X1,X2,X3,X4)
    | ~ esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_3851,axiom,
    ( ~ esk9914_4(X1,X2,X3,X4)
    | esk9899_4(X1,X2,X3,X4)
    | ~ esk10022_4(X1,X2,X3,X4) ) ).

cnf(i_0_3852,axiom,
    ( ~ esk471_4(X1,X2,X3,X4)
    | ~ esk554_4(X1,X2,X3,X4)
    | ~ esk457_4(X1,X2,X3,X4) ) ).

cnf(i_0_3853,axiom,
    ( ~ esk7946_4(X1,X2,X3,X4)
    | esk8006_4(X1,X2,X3,X4)
    | esk8029_4(X1,X2,X3,X4) ) ).

cnf(i_0_3854,axiom,
    ( esk6840_4(X1,X2,X3,X4)
    | ~ esk6582_4(X1,X2,X3,X4) ) ).

cnf(i_0_3855,axiom,
    ( esk16634_4(X1,X2,X3,X4)
    | ~ esk16703_4(X1,X2,X3,X4) ) ).

cnf(i_0_3856,axiom,
    ( ~ esk969_4(X1,X2,X3,X4)
    | ~ esk1029_4(X1,X2,X3,X4)
    | ~ esk996_4(X1,X2,X3,X4) ) ).

cnf(i_0_3857,axiom,
    ( ~ esk4097_4(X1,X2,X3,X4)
    | esk4148_4(X1,X2,X3,X4)
    | esk4177_4(X1,X2,X3,X4) ) ).

cnf(i_0_3858,axiom,
    ( ~ esk11100_4(X1,X2,X3,X4)
    | ~ esk11046_4(X1,X2,X3,X4)
    | ~ esk11081_4(X1,X2,X3,X4) ) ).

cnf(i_0_3859,axiom,
    ( ~ esk1083_4(X1,X2,X3,X4)
    | esk1031_4(X1,X2,X3,X4)
    | esk1053_4(X1,X2,X3,X4) ) ).

cnf(i_0_3860,axiom,
    ( esk7926_4(X1,X2,X3,X4)
    | esk7900_4(X1,X2,X3,X4) ) ).

cnf(i_0_3861,axiom,
    ( esk10062_4(X1,X2,X3,X4)
    | ~ esk10047_4(X1,X2,X3,X4) ) ).

cnf(i_0_3862,axiom,
    ( esk6991_4(X1,X2,X3,X4)
    | esk6940_4(X1,X2,X3,X4)
    | ~ esk6966_4(X1,X2,X3,X4) ) ).

cnf(i_0_3863,axiom,
    ( esk6167_4(X1,X2,X3,X4)
    | ~ esk5909_4(X1,X2,X3,X4) ) ).

cnf(i_0_3864,axiom,
    ( esk16450_4(X1,X2,X3,X4)
    | ~ esk16375_4(X1,X2,X3,X4) ) ).

cnf(i_0_3865,axiom,
    ( ~ esk1833_4(X1,X2,X3,X4)
    | esk1867_4(X1,X2,X3,X4) ) ).

cnf(i_0_3866,axiom,
    ( esk6115_4(X1,X2,X3,X4)
    | esk6111_4(X1,X2,X3,X4) ) ).

cnf(i_0_3867,axiom,
    ( esk13682_4(X1,X2,X3,X4)
    | esk13566_4(X1,X2,X3,X4) ) ).

cnf(i_0_3868,axiom,
    ( ~ esk5087_4(X1,X2,X3,X4)
    | ~ esk5083_4(X1,X2,X3,X4)
    | ~ esk5202_4(X1,X2,X3,X4) ) ).

cnf(i_0_3869,axiom,
    ( esk4142_4(X1,X2,X3,X4)
    | esk4107_4(X1,X2,X3,X4)
    | ~ esk4161_4(X1,X2,X3,X4) ) ).

cnf(i_0_3870,axiom,
    ( ~ esk1650_4(X1,X2,X3,X4)
    | esk1671_4(X1,X2,X3,X4) ) ).

cnf(i_0_3871,axiom,
    ( esk7164_4(X1,X2,X3,X4)
    | esk7137_4(X1,X2,X3,X4) ) ).

cnf(i_0_3872,axiom,
    ( esk11213_4(X1,X2,X3,X4)
    | esk11227_4(X1,X2,X3,X4) ) ).

cnf(i_0_3873,axiom,
    ( p(X2)
    | ~ p(X1)
    | ~ p(X4)
    | esk118_0
    | ~ p(X3)
    | ~ esk497_4(X1,X2,X3,X4) ) ).

cnf(i_0_3874,axiom,
    ( ~ esk12203_4(X1,X2,X3,X4)
    | ~ esk12226_4(X1,X2,X3,X4) ) ).

cnf(i_0_3875,axiom,
    ( ~ esk11084_4(X1,X2,X3,X4)
    | ~ esk11083_4(X1,X2,X3,X4) ) ).

cnf(i_0_3876,axiom,
    ( ~ esk1782_4(X1,X2,X3,X4)
    | esk1863_4(X1,X2,X3,X4)
    | esk1870_4(X1,X2,X3,X4) ) ).

cnf(i_0_3877,axiom,
    ( ~ esk16562_4(X1,X2,X3,X4)
    | esk16586_4(X1,X2,X3,X4) ) ).

cnf(i_0_3878,axiom,
    ( esk11240_4(X1,X2,X3,X4)
    | esk11269_4(X1,X2,X3,X4) ) ).

cnf(i_0_3879,axiom,
    ( ~ esk1190_4(X1,X2,X3,X4)
    | ~ esk1181_4(X1,X2,X3,X4)
    | ~ esk1204_4(X1,X2,X3,X4) ) ).

cnf(i_0_3880,axiom,
    ( esk15584_4(X1,X2,X3,X4)
    | ~ esk15578_4(X1,X2,X3,X4) ) ).

cnf(i_0_3881,axiom,
    ( ~ esk8791_4(X1,X2,X3,X4)
    | ~ esk8763_4(X1,X2,X3,X4) ) ).

cnf(i_0_3882,axiom,
    ( ~ esk1188_4(X1,X2,X3,X4)
    | ~ esk1208_4(X1,X2,X3,X4)
    | esk1172_4(X1,X2,X3,X4) ) ).

cnf(i_0_3883,axiom,
    ( ~ esk3322_4(X1,X2,X3,X4)
    | ~ esk3378_4(X1,X2,X3,X4) ) ).

cnf(i_0_3884,axiom,
    ( ~ esk11817_4(X1,X2,X3,X4)
    | ~ esk11784_4(X1,X2,X3,X4)
    | ~ esk11763_4(X1,X2,X3,X4) ) ).

cnf(i_0_3885,axiom,
    ( ~ esk2125_4(X1,X2,X3,X4)
    | esk2124_4(X1,X2,X3,X4) ) ).

cnf(i_0_3886,axiom,
    ( esk4385_4(X1,X2,X3,X4)
    | ~ esk4387_4(X1,X2,X3,X4) ) ).

cnf(i_0_3887,axiom,
    ( ~ esk15839_4(X1,X2,X3,X4)
    | esk15846_4(X1,X2,X3,X4) ) ).

cnf(i_0_3888,axiom,
    ( ~ esk10314_4(X1,X2,X3,X4)
    | ~ esk10313_4(X1,X2,X3,X4)
    | ~ esk10269_4(X1,X2,X3,X4) ) ).

cnf(i_0_3889,axiom,
    ( ~ esk12062_4(X1,X2,X3,X4)
    | ~ esk11970_4(X1,X2,X3,X4)
    | esk11962_4(X1,X2,X3,X4) ) ).

cnf(i_0_3890,axiom,
    ( ~ esk3296_4(X1,X2,X3,X4)
    | ~ esk3284_4(X1,X2,X3,X4)
    | ~ esk3410_4(X1,X2,X3,X4) ) ).

cnf(i_0_3891,axiom,
    ( ~ esk8578_4(X1,X2,X3,X4)
    | ~ esk8580_4(X1,X2,X3,X4)
    | ~ esk8577_4(X1,X2,X3,X4)
    | ~ esk8630_4(X1,X2,X3,X4)
    | ~ esk8631_4(X1,X2,X3,X4) ) ).

cnf(i_0_3892,axiom,
    ( esk10068_4(X1,X2,X3,X4)
    | ~ esk10069_4(X1,X2,X3,X4)
    | esk10055_4(X1,X2,X3,X4) ) ).

cnf(i_0_3893,axiom,
    ( ~ esk5859_4(X1,X2,X3,X4)
    | ~ esk5892_4(X1,X2,X3,X4)
    | ~ esk5852_4(X1,X2,X3,X4) ) ).

cnf(i_0_3894,axiom,
    ( ~ esk1337_4(X1,X2,X3,X4)
    | ~ esk1228_4(X1,X2,X3,X4)
    | ~ esk1254_4(X1,X2,X3,X4) ) ).

cnf(i_0_3895,axiom,
    ( ~ esk6461_4(X1,X2,X3,X4)
    | ~ esk6459_4(X1,X2,X3,X4) ) ).

cnf(i_0_3896,axiom,
    ( ~ esk3024_4(X1,X2,X3,X4)
    | esk3060_4(X1,X2,X3,X4) ) ).

cnf(i_0_3897,axiom,
    ( esk8838_4(X1,X2,X3,X4)
    | ~ esk8881_4(X1,X2,X3,X4) ) ).

cnf(i_0_3898,axiom,
    ( ~ esk1554_4(X1,X2,X3,X4)
    | esk1812_4(X1,X2,X3,X4) ) ).

cnf(i_0_3899,axiom,
    ( ~ esk11086_4(X1,X2,X3,X4)
    | esk11118_4(X1,X2,X3,X4) ) ).

cnf(i_0_3900,axiom,
    ( ~ esk14038_4(X1,X2,X3,X4)
    | ~ esk14040_4(X1,X2,X3,X4) ) ).

cnf(i_0_3901,axiom,
    ( ~ esk4871_4(X1,X2,X3,X4)
    | esk4817_4(X1,X2,X3,X4) ) ).

cnf(i_0_3902,axiom,
    ( ~ esk16362_4(X1,X2,X3,X4)
    | esk16363_4(X1,X2,X3,X4) ) ).

cnf(i_0_3903,axiom,
    ( esk5604_4(X1,X2,X3,X4)
    | esk5637_4(X1,X2,X3,X4) ) ).

cnf(i_0_3904,axiom,
    ( esk5861_4(X1,X2,X3,X4)
    | esk5894_4(X1,X2,X3,X4) ) ).

cnf(i_0_3905,axiom,
    ( ~ esk762_4(X1,X2,X3,X4)
    | ~ esk662_4(X1,X2,X3,X4)
    | esk643_4(X1,X2,X3,X4) ) ).

cnf(i_0_3906,axiom,
    ( esk5931_4(X1,X2,X3,X4)
    | esk5833_4(X1,X2,X3,X4) ) ).

cnf(i_0_3907,axiom,
    ( ~ esk15825_4(X1,X2,X3,X4)
    | esk15815_4(X1,X2,X3,X4)
    | ~ esk15913_4(X1,X2,X3,X4) ) ).

cnf(i_0_3908,axiom,
    ( esk6368_4(X1,X2,X3,X4)
    | esk6374_4(X1,X2,X3,X4) ) ).

cnf(i_0_3909,axiom,
    ( ~ esk13598_4(X1,X2,X3,X4)
    | esk13501_4(X1,X2,X3,X4)
    | ~ esk13512_4(X1,X2,X3,X4) ) ).

cnf(i_0_3910,axiom,
    ( esk1092_4(X1,X2,X3,X4)
    | esk1011_4(X1,X2,X3,X4)
    | ~ esk1099_4(X1,X2,X3,X4) ) ).

cnf(i_0_3911,axiom,
    ( esk2218_4(X1,X2,X3,X4)
    | esk2209_4(X1,X2,X3,X4) ) ).

cnf(i_0_3912,axiom,
    ( ~ esk925_4(X1,X2,X3,X4)
    | esk941_4(X1,X2,X3,X4) ) ).

cnf(i_0_3913,axiom,
    ( esk12131_4(X1,X2,X3,X4)
    | esk12048_4(X1,X2,X3,X4) ) ).

cnf(i_0_3914,axiom,
    ( esk7320_4(X1,X2,X3,X4)
    | ~ esk7344_4(X1,X2,X3,X4) ) ).

cnf(i_0_3915,axiom,
    ( esk7205_4(X1,X2,X3,X4)
    | ~ esk7209_4(X1,X2,X3,X4) ) ).

cnf(i_0_3916,axiom,
    ( esk2811_4(X1,X2,X3,X4)
    | ~ esk3069_4(X1,X2,X3,X4) ) ).

cnf(i_0_3917,axiom,
    ( esk2465_4(X1,X2,X3,X4)
    | ~ esk2487_4(X1,X2,X3,X4) ) ).

cnf(i_0_3918,axiom,
    ( esk10521_4(X1,X2,X3,X4)
    | ~ esk10473_4(X1,X2,X3,X4) ) ).

cnf(i_0_3919,axiom,
    ( ~ p(X3)
    | ~ esk493_4(X1,X2,X3,X4)
    | esk84_0
    | ~ p(X4)
    | ~ p(X2)
    | p(X1) ) ).

cnf(i_0_3920,axiom,
    ( esk4633_4(X1,X2,X3,X4)
    | ~ esk4375_4(X1,X2,X3,X4) ) ).

cnf(i_0_3921,axiom,
    ( esk8715_4(X1,X2,X3,X4)
    | esk8799_4(X1,X2,X3,X4)
    | ~ esk8762_4(X1,X2,X3,X4) ) ).

cnf(i_0_3922,axiom,
    ( esk12881_4(X1,X2,X3,X4)
    | esk12880_4(X1,X2,X3,X4) ) ).

cnf(i_0_3923,axiom,
    ( esk1778_4(X1,X2,X3,X4)
    | ~ esk1680_4(X1,X2,X3,X4) ) ).

cnf(i_0_3924,axiom,
    ( ~ esk2242_4(X1,X2,X3,X4)
    | ~ esk2280_4(X1,X2,X3,X4)
    | ~ esk2279_4(X1,X2,X3,X4) ) ).

cnf(i_0_3925,axiom,
    ( esk13646_4(X1,X2,X3,X4)
    | esk13647_4(X1,X2,X3,X4)
    | esk13648_4(X1,X2,X3,X4) ) ).

cnf(i_0_3926,axiom,
    ( p(X1)
    | p(X3)
    | ~ esk183_0
    | p(X4)
    | esk16697_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_3927,axiom,
    ( esk10287_4(X1,X2,X3,X4)
    | esk10302_4(X1,X2,X3,X4) ) ).

cnf(i_0_3928,axiom,
    ( ~ esk905_4(X1,X2,X3,X4)
    | esk874_4(X1,X2,X3,X4) ) ).

cnf(i_0_3929,axiom,
    ( ~ esk5531_4(X1,X2,X3,X4)
    | esk5500_4(X1,X2,X3,X4) ) ).

cnf(i_0_3930,axiom,
    ( esk15086_4(X1,X2,X3,X4)
    | ~ esk15050_4(X1,X2,X3,X4) ) ).

cnf(i_0_3931,axiom,
    ( ~ esk15311_4(X1,X2,X3,X4)
    | ~ esk15423_4(X1,X2,X3,X4)
    | esk15298_4(X1,X2,X3,X4) ) ).

cnf(i_0_3932,axiom,
    ( ~ esk15905_4(X1,X2,X3,X4)
    | ~ esk15861_4(X1,X2,X3,X4)
    | ~ esk15904_4(X1,X2,X3,X4) ) ).

cnf(i_0_3933,axiom,
    ( ~ esk738_4(X1,X2,X3,X4)
    | ~ esk844_4(X1,X2,X3,X4)
    | ~ esk714_4(X1,X2,X3,X4) ) ).

cnf(i_0_3934,axiom,
    ( esk1238_4(X1,X2,X3,X4)
    | esk1350_4(X1,X2,X3,X4) ) ).

cnf(i_0_3935,axiom,
    ( ~ esk13859_4(X1,X2,X3,X4)
    | ~ esk13819_4(X1,X2,X3,X4)
    | ~ esk13826_4(X1,X2,X3,X4) ) ).

cnf(i_0_3936,axiom,
    ( esk5056_4(X1,X2,X3,X4)
    | ~ esk5060_4(X1,X2,X3,X4) ) ).

cnf(i_0_3937,axiom,
    ( ~ esk15400_4(X1,X2,X3,X4)
    | esk15658_4(X1,X2,X3,X4) ) ).

cnf(i_0_3938,axiom,
    ( esk13796_4(X1,X2,X3,X4)
    | ~ esk14054_4(X1,X2,X3,X4) ) ).

cnf(i_0_3939,axiom,
    ( ~ esk15996_4(X1,X2,X3,X4)
    | ~ esk15913_4(X1,X2,X3,X4)
    | ~ esk15973_4(X1,X2,X3,X4) ) ).

cnf(i_0_3940,axiom,
    ( ~ esk4249_4(X1,X2,X3,X4)
    | esk4346_4(X1,X2,X3,X4) ) ).

cnf(i_0_3941,axiom,
    ( esk3393_4(X1,X2,X3,X4)
    | esk3310_4(X1,X2,X3,X4) ) ).

cnf(i_0_3942,axiom,
    ( ~ esk9037_4(X1,X2,X3,X4)
    | esk9039_4(X1,X2,X3,X4)
    | ~ esk9038_4(X1,X2,X3,X4) ) ).

cnf(i_0_3943,axiom,
    ( esk1748_4(X1,X2,X3,X4)
    | esk1862_4(X1,X2,X3,X4) ) ).

cnf(i_0_3944,axiom,
    ( ~ p(X3)
    | esk208_0
    | ~ p(X1)
    | ~ esk509_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X2) ) ).

cnf(i_0_3945,axiom,
    ( ~ esk14719_4(X1,X2,X3,X4)
    | ~ esk14700_4(X1,X2,X3,X4)
    | ~ esk14648_4(X1,X2,X3,X4) ) ).

cnf(i_0_3946,axiom,
    ( esk12849_4(X1,X2,X3,X4)
    | ~ esk12726_4(X1,X2,X3,X4) ) ).

cnf(i_0_3947,axiom,
    ( ~ esk4138_4(X1,X2,X3,X4)
    | esk4166_4(X1,X2,X3,X4) ) ).

cnf(i_0_3948,axiom,
    ( ~ esk4751_4(X1,X2,X3,X4)
    | ~ esk4904_4(X1,X2,X3,X4)
    | ~ esk4897_4(X1,X2,X3,X4) ) ).

cnf(i_0_3949,axiom,
    ( esk12390_4(X1,X2,X3,X4)
    | ~ esk12389_4(X1,X2,X3,X4) ) ).

cnf(i_0_3950,axiom,
    ( esk6239_4(X1,X2,X3,X4)
    | esk6232_4(X1,X2,X3,X4)
    | ~ esk6151_4(X1,X2,X3,X4) ) ).

cnf(i_0_3951,axiom,
    ( esk83_0
    | ~ esk16683_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X2)
    | p(X3)
    | p(X1) ) ).

cnf(i_0_3952,axiom,
    ( esk763_4(X1,X2,X3,X4)
    | ~ esk1021_4(X1,X2,X3,X4) ) ).

cnf(i_0_3953,axiom,
    ( ~ esk2807_4(X1,X2,X3,X4)
    | esk2765_4(X1,X2,X3,X4) ) ).

cnf(i_0_3954,axiom,
    ( ~ esk145_0
    | ~ p(X4)
    | ~ p(X3)
    | ~ p(X2)
    | esk16691_4(X1,X2,X3,X4)
    | p(X1) ) ).

cnf(i_0_3955,axiom,
    ( esk10016_4(X1,X2,X3,X4)
    | ~ esk9758_4(X1,X2,X3,X4) ) ).

cnf(i_0_3956,axiom,
    ( esk12508_4(X1,X2,X3,X4)
    | ~ esk12512_4(X1,X2,X3,X4) ) ).

cnf(i_0_3957,axiom,
    ( esk8450_4(X1,X2,X3,X4)
    | esk8533_4(X1,X2,X3,X4) ) ).

cnf(i_0_3958,axiom,
    ( esk4569_4(X1,X2,X3,X4)
    | esk4597_4(X1,X2,X3,X4) ) ).

cnf(i_0_3959,axiom,
    ( ~ esk6633_4(X1,X2,X3,X4)
    | ~ esk6619_4(X1,X2,X3,X4)
    | ~ esk6632_4(X1,X2,X3,X4) ) ).

cnf(i_0_3960,axiom,
    ( ~ esk13912_4(X1,X2,X3,X4)
    | ~ esk13911_4(X1,X2,X3,X4)
    | ~ esk13867_4(X1,X2,X3,X4) ) ).

cnf(i_0_3961,axiom,
    ( ~ esk1171_4(X1,X2,X3,X4)
    | esk1176_4(X1,X2,X3,X4) ) ).

cnf(i_0_3962,axiom,
    ( ~ esk11295_4(X1,X2,X3,X4)
    | ~ esk11343_4(X1,X2,X3,X4) ) ).

cnf(i_0_3963,axiom,
    ( esk12534_4(X1,X2,X3,X4)
    | esk12543_4(X1,X2,X3,X4) ) ).

cnf(i_0_3964,axiom,
    ( esk2579_4(X1,X2,X3,X4)
    | ~ esk2581_4(X1,X2,X3,X4) ) ).

cnf(i_0_3965,axiom,
    ( esk14599_4(X1,X2,X3,X4)
    | esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_3966,axiom,
    ( esk2214_4(X1,X2,X3,X4)
    | ~ esk1956_4(X1,X2,X3,X4) ) ).

cnf(i_0_3967,axiom,
    ( esk16337_4(X1,X2,X3,X4)
    | ~ esk16317_4(X1,X2,X3,X4) ) ).

cnf(i_0_3968,axiom,
    ( esk9033_4(X1,X2,X3,X4)
    | esk8978_4(X1,X2,X3,X4) ) ).

cnf(i_0_3969,axiom,
    ( ~ esk9396_4(X1,X2,X3,X4)
    | ~ esk9450_4(X1,X2,X3,X4) ) ).

cnf(i_0_3970,axiom,
    ( esk11983_4(X1,X2,X3,X4)
    | esk11985_4(X1,X2,X3,X4) ) ).

cnf(i_0_3971,axiom,
    ( esk10974_4(X1,X2,X3,X4)
    | ~ esk10912_4(X1,X2,X3,X4) ) ).

cnf(i_0_3972,axiom,
    ( esk6702_4(X1,X2,X3,X4)
    | esk6603_4(X1,X2,X3,X4)
    | esk6695_4(X1,X2,X3,X4) ) ).

cnf(i_0_3973,axiom,
    ( esk9193_4(X1,X2,X3,X4)
    | esk9210_4(X1,X2,X3,X4) ) ).

cnf(i_0_3974,axiom,
    ( ~ esk10635_4(X1,X2,X3,X4)
    | ~ esk10687_4(X1,X2,X3,X4) ) ).

cnf(i_0_3975,axiom,
    ( ~ esk3320_4(X1,X2,X3,X4)
    | esk3222_4(X1,X2,X3,X4)
    | ~ esk3232_4(X1,X2,X3,X4) ) ).

cnf(i_0_3976,axiom,
    ( esk5946_4(X1,X2,X3,X4)
    | ~ esk5978_4(X1,X2,X3,X4)
    | esk5977_4(X1,X2,X3,X4) ) ).

cnf(i_0_3977,axiom,
    ( esk12033_4(X1,X2,X3,X4)
    | esk12014_4(X1,X2,X3,X4) ) ).

cnf(i_0_3978,axiom,
    ( ~ esk15104_4(X1,X2,X3,X4)
    | ~ esk15121_4(X1,X2,X3,X4)
    | ~ esk15154_4(X1,X2,X3,X4) ) ).

cnf(i_0_3979,axiom,
    ( ~ esk446_4(X1,X2,X3,X4)
    | ~ esk474_4(X1,X2,X3,X4)
    | ~ esk475_4(X1,X2,X3,X4) ) ).

cnf(i_0_3980,axiom,
    ( esk11877_4(X1,X2,X3,X4)
    | ~ esk11878_4(X1,X2,X3,X4) ) ).

cnf(i_0_3981,axiom,
    ( esk5093_4(X1,X2,X3,X4)
    | esk5076_4(X1,X2,X3,X4) ) ).

cnf(i_0_3982,axiom,
    ( esk15368_4(X1,X2,X3,X4)
    | esk15401_4(X1,X2,X3,X4) ) ).

cnf(i_0_3983,axiom,
    ( esk10734_4(X1,X2,X3,X4)
    | esk10738_4(X1,X2,X3,X4) ) ).

cnf(i_0_3984,axiom,
    ( ~ esk5684_4(X1,X2,X3,X4)
    | esk5703_4(X1,X2,X3,X4)
    | esk5649_4(X1,X2,X3,X4) ) ).

cnf(i_0_3985,axiom,
    ( ~ esk947_4(X1,X2,X3,X4)
    | ~ esk924_4(X1,X2,X3,X4)
    | ~ esk933_4(X1,X2,X3,X4) ) ).

cnf(i_0_3986,axiom,
    ( ~ esk10418_4(X1,X2,X3,X4)
    | esk10428_4(X1,X2,X3,X4) ) ).

cnf(i_0_3987,axiom,
    ( ~ esk16592_4(X1,X2,X3,X4)
    | ~ esk16646_4(X1,X2,X3,X4) ) ).

cnf(i_0_3988,axiom,
    ( esk10942_4(X1,X2,X3,X4)
    | ~ esk10929_4(X1,X2,X3,X4) ) ).

cnf(i_0_3989,axiom,
    ( ~ esk16137_4(X1,X2,X3,X4)
    | ~ esk16138_4(X1,X2,X3,X4)
    | ~ esk16130_4(X1,X2,X3,X4) ) ).

cnf(i_0_3990,axiom,
    ( ~ esk8865_4(X1,X2,X3,X4)
    | esk8917_4(X1,X2,X3,X4) ) ).

cnf(i_0_3991,axiom,
    ( ~ esk2525_4(X1,X2,X3,X4)
    | ~ esk2524_4(X1,X2,X3,X4)
    | ~ esk2505_4(X1,X2,X3,X4) ) ).

cnf(i_0_3992,axiom,
    ( esk16719_4(X1,X2,X3,X4)
    | ~ esk16721_4(X1,X2,X3,X4)
    | esk16720_4(X1,X2,X3,X4) ) ).

cnf(i_0_3993,axiom,
    ( ~ esk5362_4(X1,X2,X3,X4)
    | ~ esk5447_4(X1,X2,X3,X4)
    | ~ esk5340_4(X1,X2,X3,X4) ) ).

cnf(i_0_3994,axiom,
    ( ~ esk5894_4(X1,X2,X3,X4)
    | ~ esk5802_4(X1,X2,X3,X4)
    | esk5794_4(X1,X2,X3,X4) ) ).

cnf(i_0_3995,axiom,
    ( ~ esk13476_4(X1,X2,X3,X4)
    | esk13504_4(X1,X2,X3,X4) ) ).

cnf(i_0_3996,axiom,
    ( esk9278_4(X1,X2,X3,X4)
    | esk9277_4(X1,X2,X3,X4)
    | esk9279_4(X1,X2,X3,X4) ) ).

cnf(i_0_3997,axiom,
    ( esk8224_4(X1,X2,X3,X4)
    | ~ esk8482_4(X1,X2,X3,X4) ) ).

cnf(i_0_3998,axiom,
    ( ~ esk6719_4(X1,X2,X3,X4)
    | ~ esk6663_4(X1,X2,X3,X4) ) ).

cnf(i_0_3999,axiom,
    ( esk13169_4(X1,X2,X3,X4)
    | ~ esk13146_4(X1,X2,X3,X4)
    | esk13086_4(X1,X2,X3,X4) ) ).

cnf(i_0_4000,axiom,
    ( esk7823_4(X1,X2,X3,X4)
    | ~ esk7849_4(X1,X2,X3,X4) ) ).

cnf(i_0_4001,axiom,
    ( ~ esk7268_4(X1,X2,X3,X4)
    | ~ esk7187_4(X1,X2,X3,X4) ) ).

cnf(i_0_4002,axiom,
    ( esk13178_4(X1,X2,X3,X4)
    | esk13092_4(X1,X2,X3,X4) ) ).

cnf(i_0_4003,axiom,
    ( esk5860_4(X1,X2,X3,X4)
    | esk5974_4(X1,X2,X3,X4) ) ).

cnf(i_0_4004,axiom,
    ( ~ esk5584_4(X1,X2,X3,X4)
    | esk5650_4(X1,X2,X3,X4) ) ).

cnf(i_0_4005,axiom,
    ( ~ esk11689_4(X1,X2,X3,X4)
    | ~ esk11716_4(X1,X2,X3,X4)
    | esk11713_4(X1,X2,X3,X4) ) ).

cnf(i_0_4006,axiom,
    ( ~ esk11980_4(X1,X2,X3,X4)
    | ~ esk11981_4(X1,X2,X3,X4) ) ).

cnf(i_0_4007,axiom,
    ( esk13336_4(X1,X2,X3,X4)
    | esk13305_4(X1,X2,X3,X4) ) ).

cnf(i_0_4008,axiom,
    ( ~ esk9146_4(X1,X2,X3,X4)
    | ~ esk9140_4(X1,X2,X3,X4)
    | esk9141_4(X1,X2,X3,X4) ) ).

cnf(i_0_4009,axiom,
    ( esk4653_4(X1,X2,X3,X4)
    | esk4696_4(X1,X2,X3,X4) ) ).

cnf(i_0_4010,axiom,
    ( esk9942_4(X1,X2,X3,X4)
    | esk9928_4(X1,X2,X3,X4) ) ).

cnf(i_0_4011,axiom,
    ( esk7243_4(X1,X2,X3,X4)
    | ~ esk7189_4(X1,X2,X3,X4) ) ).

cnf(i_0_4012,axiom,
    ( esk11012_4(X1,X2,X3,X4)
    | esk10994_4(X1,X2,X3,X4) ) ).

cnf(i_0_4013,axiom,
    ( ~ esk10271_4(X1,X2,X3,X4)
    | esk10013_4(X1,X2,X3,X4) ) ).

cnf(i_0_4014,axiom,
    ( esk12624_4(X1,X2,X3,X4)
    | ~ esk12640_4(X1,X2,X3,X4)
    | esk12586_4(X1,X2,X3,X4) ) ).

cnf(i_0_4015,axiom,
    ( esk13535_4(X1,X2,X3,X4)
    | esk13540_4(X1,X2,X3,X4)
    | ~ esk13536_4(X1,X2,X3,X4) ) ).

cnf(i_0_4016,axiom,
    ( esk7370_4(X1,X2,X3,X4)
    | ~ esk7368_4(X1,X2,X3,X4)
    | ~ esk7369_4(X1,X2,X3,X4) ) ).

cnf(i_0_4017,axiom,
    ( esk6124_4(X1,X2,X3,X4)
    | esk6102_4(X1,X2,X3,X4) ) ).

cnf(i_0_4018,axiom,
    ( esk1319_4(X1,X2,X3,X4)
    | esk1274_4(X1,X2,X3,X4) ) ).

cnf(i_0_4019,axiom,
    ( esk11594_4(X1,X2,X3,X4)
    | esk11592_4(X1,X2,X3,X4) ) ).

cnf(i_0_4020,axiom,
    ( ~ esk11804_4(X1,X2,X3,X4)
    | esk11759_4(X1,X2,X3,X4) ) ).

cnf(i_0_4021,axiom,
    ( esk3796_4(X1,X2,X3,X4)
    | esk3823_4(X1,X2,X3,X4) ) ).

cnf(i_0_4022,axiom,
    ( esk11362_4(X1,X2,X3,X4)
    | ~ esk11361_4(X1,X2,X3,X4) ) ).

cnf(i_0_4023,axiom,
    ( ~ esk13060_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4)
    | ~ esk13172_4(X1,X2,X3,X4) ) ).

cnf(i_0_4024,axiom,
    ( esk2634_4(X1,X2,X3,X4)
    | esk2644_4(X1,X2,X3,X4) ) ).

cnf(i_0_4025,axiom,
    ( esk7137_4(X1,X2,X3,X4)
    | esk7166_4(X1,X2,X3,X4) ) ).

cnf(i_0_4026,axiom,
    ( esk12564_4(X1,X2,X3,X4)
    | esk12520_4(X1,X2,X3,X4) ) ).

cnf(i_0_4027,axiom,
    ( ~ esk13544_4(X1,X2,X3,X4)
    | ~ esk13545_4(X1,X2,X3,X4) ) ).

cnf(i_0_4028,axiom,
    ( ~ esk2106_4(X1,X2,X3,X4)
    | ~ esk1999_4(X1,X2,X3,X4)
    | ~ esk2021_4(X1,X2,X3,X4) ) ).

cnf(i_0_4029,axiom,
    ( esk12651_4(X1,X2,X3,X4)
    | ~ esk12600_4(X1,X2,X3,X4) ) ).

cnf(i_0_4030,axiom,
    ( esk6928_4(X1,X2,X3,X4)
    | esk6895_4(X1,X2,X3,X4) ) ).

cnf(i_0_4031,axiom,
    ( esk6830_4(X1,X2,X3,X4)
    | ~ esk6820_4(X1,X2,X3,X4) ) ).

cnf(i_0_4032,axiom,
    ( esk3791_4(X1,X2,X3,X4)
    | esk3808_4(X1,X2,X3,X4) ) ).

cnf(i_0_4033,axiom,
    ( esk564_4(X1,X2,X3,X4)
    | esk479_4(X1,X2,X3,X4) ) ).

cnf(i_0_4034,axiom,
    ( ~ esk1832_4(X1,X2,X3,X4)
    | ~ esk1830_4(X1,X2,X3,X4) ) ).

cnf(i_0_4035,axiom,
    ( esk5140_4(X1,X2,X3,X4)
    | ~ esk5398_4(X1,X2,X3,X4) ) ).

cnf(i_0_4036,axiom,
    ( ~ esk943_4(X1,X2,X3,X4)
    | esk945_4(X1,X2,X3,X4)
    | ~ esk944_4(X1,X2,X3,X4) ) ).

cnf(i_0_4037,axiom,
    ( esk14410_4(X1,X2,X3,X4)
    | ~ esk14411_4(X1,X2,X3,X4) ) ).

cnf(i_0_4038,axiom,
    ( ~ esk10343_4(X1,X2,X3,X4)
    | ~ esk10229_4(X1,X2,X3,X4)
    | ~ esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_4039,axiom,
    ( ~ esk6235_4(X1,X2,X3,X4)
    | esk6237_4(X1,X2,X3,X4)
    | ~ esk6236_4(X1,X2,X3,X4) ) ).

cnf(i_0_4040,axiom,
    ( esk1947_4(X1,X2,X3,X4)
    | ~ esk1933_4(X1,X2,X3,X4) ) ).

cnf(i_0_4041,axiom,
    ( esk16210_4(X1,X2,X3,X4)
    | ~ esk16209_4(X1,X2,X3,X4) ) ).

cnf(i_0_4042,axiom,
    ( ~ esk3083_4(X1,X2,X3,X4)
    | esk2960_4(X1,X2,X3,X4)
    | ~ esk2975_4(X1,X2,X3,X4) ) ).

cnf(i_0_4043,axiom,
    ( ~ esk12847_4(X1,X2,X3,X4)
    | ~ esk12878_4(X1,X2,X3,X4) ) ).

cnf(i_0_4044,axiom,
    ( esk3134_4(X1,X2,X3,X4)
    | esk3049_4(X1,X2,X3,X4) ) ).

cnf(i_0_4045,axiom,
    ( ~ esk8367_4(X1,X2,X3,X4)
    | esk8372_4(X1,X2,X3,X4) ) ).

cnf(i_0_4046,axiom,
    ( ~ esk995_4(X1,X2,X3,X4)
    | ~ esk994_4(X1,X2,X3,X4)
    | ~ esk957_4(X1,X2,X3,X4) ) ).

cnf(i_0_4047,axiom,
    ( esk8644_4(X1,X2,X3,X4)
    | esk8642_4(X1,X2,X3,X4) ) ).

cnf(i_0_4048,axiom,
    ( ~ esk10666_4(X1,X2,X3,X4)
    | esk10685_4(X1,X2,X3,X4) ) ).

cnf(i_0_4049,axiom,
    ( ~ esk4609_4(X1,X2,X3,X4)
    | esk4690_4(X1,X2,X3,X4)
    | esk4697_4(X1,X2,X3,X4) ) ).

cnf(i_0_4050,axiom,
    ( ~ esk9700_4(X1,X2,X3,X4)
    | esk9754_4(X1,X2,X3,X4) ) ).

cnf(i_0_4051,axiom,
    ( ~ esk1141_4(X1,X2,X3,X4)
    | esk1167_4(X1,X2,X3,X4) ) ).

cnf(i_0_4052,axiom,
    ( esk5885_4(X1,X2,X3,X4)
    | esk5852_4(X1,X2,X3,X4) ) ).

cnf(i_0_4053,axiom,
    ( ~ esk8882_4(X1,X2,X3,X4)
    | esk8918_4(X1,X2,X3,X4) ) ).

cnf(i_0_4054,axiom,
    ( esk1944_4(X1,X2,X3,X4)
    | ~ esk1945_4(X1,X2,X3,X4) ) ).

cnf(i_0_4055,axiom,
    ( esk795_4(X1,X2,X3,X4)
    | ~ esk750_4(X1,X2,X3,X4)
    | ~ esk810_4(X1,X2,X3,X4) ) ).

cnf(i_0_4056,axiom,
    ( esk12809_4(X1,X2,X3,X4)
    | esk12894_4(X1,X2,X3,X4) ) ).

cnf(i_0_4057,axiom,
    ( esk16769_4(X1,X2,X3,X4)
    | esk16776_4(X1,X2,X3,X4)
    | ~ esk16688_4(X1,X2,X3,X4) ) ).

cnf(i_0_4058,axiom,
    ( ~ esk1562_4(X1,X2,X3,X4)
    | ~ esk1463_4(X1,X2,X3,X4) ) ).

cnf(i_0_4059,axiom,
    ( esk6631_4(X1,X2,X3,X4)
    | esk6745_4(X1,X2,X3,X4) ) ).

cnf(i_0_4060,axiom,
    ( ~ esk233_0
    | p(X3)
    | esk16703_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X1)
    | ~ p(X2) ) ).

cnf(i_0_4061,axiom,
    ( ~ esk6169_4(X1,X2,X3,X4)
    | esk6220_4(X1,X2,X3,X4)
    | esk6195_4(X1,X2,X3,X4) ) ).

cnf(i_0_4062,axiom,
    ( p(X3)
    | p(X4)
    | esk120_0
    | ~ p(X2)
    | ~ p(X1)
    | ~ esk16687_4(X1,X2,X3,X4) ) ).

cnf(i_0_4063,axiom,
    ( esk572_4(X1,X2,X3,X4)
    | ~ esk574_4(X1,X2,X3,X4) ) ).

cnf(i_0_4064,axiom,
    ( esk5325_4(X1,X2,X3,X4)
    | esk5365_4(X1,X2,X3,X4) ) ).

cnf(i_0_4065,axiom,
    ( esk6379_4(X1,X2,X3,X4)
    | esk6360_4(X1,X2,X3,X4) ) ).

cnf(i_0_4066,axiom,
    ( esk7145_4(X1,X2,X3,X4)
    | esk7139_4(X1,X2,X3,X4) ) ).

cnf(i_0_4067,axiom,
    ( ~ esk13329_4(X1,X2,X3,X4)
    | ~ esk13328_4(X1,X2,X3,X4)
    | ~ esk13294_4(X1,X2,X3,X4) ) ).

cnf(i_0_4068,axiom,
    ( ~ esk4556_4(X1,X2,X3,X4)
    | esk4622_4(X1,X2,X3,X4) ) ).

cnf(i_0_4069,axiom,
    ( ~ esk9245_4(X1,X2,X3,X4)
    | esk9125_4(X1,X2,X3,X4)
    | ~ esk9143_4(X1,X2,X3,X4) ) ).

cnf(i_0_4070,axiom,
    ( esk2272_4(X1,X2,X3,X4)
    | esk2246_4(X1,X2,X3,X4) ) ).

cnf(i_0_4071,axiom,
    ( ~ esk8651_4(X1,X2,X3,X4)
    | esk8650_4(X1,X2,X3,X4) ) ).

cnf(i_0_4072,axiom,
    ( esk7487_4(X1,X2,X3,X4)
    | esk7442_4(X1,X2,X3,X4) ) ).

cnf(i_0_4073,axiom,
    ( esk1988_4(X1,X2,X3,X4)
    | esk2016_4(X1,X2,X3,X4) ) ).

cnf(i_0_4074,axiom,
    ( esk13405_4(X1,X2,X3,X4)
    | esk13387_4(X1,X2,X3,X4) ) ).

cnf(i_0_4075,axiom,
    ( esk7184_4(X1,X2,X3,X4)
    | ~ esk7130_4(X1,X2,X3,X4) ) ).

cnf(i_0_4076,axiom,
    ( ~ esk4653_4(X1,X2,X3,X4)
    | ~ esk4652_4(X1,X2,X3,X4) ) ).

cnf(i_0_4077,axiom,
    ( esk10432_4(X1,X2,X3,X4)
    | ~ esk10690_4(X1,X2,X3,X4) ) ).

cnf(i_0_4078,axiom,
    ( esk13255_4(X1,X2,X3,X4)
    | ~ esk13238_4(X1,X2,X3,X4) ) ).

cnf(i_0_4079,axiom,
    ( esk5884_4(X1,X2,X3,X4)
    | esk5837_4(X1,X2,X3,X4) ) ).

cnf(i_0_4080,axiom,
    ( esk12800_4(X1,X2,X3,X4)
    | esk12791_4(X1,X2,X3,X4) ) ).

cnf(i_0_4081,axiom,
    ( ~ esk760_4(X1,X2,X3,X4)
    | ~ esk804_4(X1,X2,X3,X4)
    | ~ esk811_4(X1,X2,X3,X4) ) ).

cnf(i_0_4082,axiom,
    ( esk10691_4(X1,X2,X3,X4)
    | ~ esk10949_4(X1,X2,X3,X4) ) ).

cnf(i_0_4083,axiom,
    ( ~ esk13839_4(X1,X2,X3,X4)
    | ~ esk13810_4(X1,X2,X3,X4)
    | ~ esk13838_4(X1,X2,X3,X4) ) ).

cnf(i_0_4084,axiom,
    ( ~ esk1336_4(X1,X2,X3,X4)
    | esk1355_4(X1,X2,X3,X4)
    | esk1284_4(X1,X2,X3,X4) ) ).

cnf(i_0_4085,axiom,
    ( ~ esk7917_4(X1,X2,X3,X4)
    | ~ esk7950_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_4086,axiom,
    ( ~ esk6621_4(X1,X2,X3,X4)
    | ~ esk6629_4(X1,X2,X3,X4)
    | ~ esk6628_4(X1,X2,X3,X4) ) ).

cnf(i_0_4087,axiom,
    ( esk2087_4(X1,X2,X3,X4)
    | esk2086_4(X1,X2,X3,X4) ) ).

cnf(i_0_4088,axiom,
    ( ~ esk812_4(X1,X2,X3,X4)
    | esk813_4(X1,X2,X3,X4) ) ).

cnf(i_0_4089,axiom,
    ( ~ esk2957_4(X1,X2,X3,X4)
    | esk3077_4(X1,X2,X3,X4) ) ).

cnf(i_0_4090,axiom,
    ( ~ esk16587_4(X1,X2,X3,X4)
    | esk16686_4(X1,X2,X3,X4) ) ).

cnf(i_0_4091,axiom,
    ( esk3380_4(X1,X2,X3,X4)
    | esk3403_4(X1,X2,X3,X4)
    | ~ esk3320_4(X1,X2,X3,X4) ) ).

cnf(i_0_4092,axiom,
    ( ~ esk1933_4(X1,X2,X3,X4)
    | esk2057_4(X1,X2,X3,X4) ) ).

cnf(i_0_4093,axiom,
    ( ~ esk658_4(X1,X2,X3,X4)
    | ~ esk713_4(X1,X2,X3,X4) ) ).

cnf(i_0_4094,axiom,
    ( ~ esk5323_4(X1,X2,X3,X4)
    | esk5401_4(X1,X2,X3,X4) ) ).

cnf(i_0_4095,axiom,
    ( ~ esk11856_4(X1,X2,X3,X4)
    | ~ esk11888_4(X1,X2,X3,X4) ) ).

cnf(i_0_4096,axiom,
    ( ~ esk10140_4(X1,X2,X3,X4)
    | esk10297_4(X1,X2,X3,X4) ) ).

cnf(i_0_4097,axiom,
    ( ~ esk9169_4(X1,X2,X3,X4)
    | esk9168_4(X1,X2,X3,X4) ) ).

cnf(i_0_4098,axiom,
    ( ~ esk15476_4(X1,X2,X3,X4)
    | esk15474_4(X1,X2,X3,X4) ) ).

cnf(i_0_4099,axiom,
    ( ~ p(X1)
    | ~ p(X2)
    | p(X3)
    | ~ p(X4)
    | esk286_0
    | ~ esk16709_4(X1,X2,X3,X4) ) ).

cnf(i_0_4100,axiom,
    ( esk9970_4(X1,X2,X3,X4)
    | esk10085_4(X1,X2,X3,X4) ) ).

cnf(i_0_4101,axiom,
    ( ~ esk15605_4(X1,X2,X3,X4)
    | esk15677_4(X1,X2,X3,X4) ) ).

cnf(i_0_4102,axiom,
    ( ~ esk16223_4(X1,X2,X3,X4)
    | ~ esk16214_4(X1,X2,X3,X4) ) ).

cnf(i_0_4103,axiom,
    ( esk8469_4(X1,X2,X3,X4)
    | ~ esk8727_4(X1,X2,X3,X4) ) ).

cnf(i_0_4104,axiom,
    ( esk2534_4(X1,X2,X3,X4)
    | esk2567_4(X1,X2,X3,X4) ) ).

cnf(i_0_4105,axiom,
    ( esk9295_4(X1,X2,X3,X4)
    | ~ esk9275_4(X1,X2,X3,X4) ) ).

cnf(i_0_4106,axiom,
    ( ~ esk9420_4(X1,X2,X3,X4)
    | esk9419_4(X1,X2,X3,X4)
    | esk9408_4(X1,X2,X3,X4) ) ).

cnf(i_0_4107,axiom,
    ( ~ esk11992_4(X1,X2,X3,X4)
    | esk11976_4(X1,X2,X3,X4) ) ).

cnf(i_0_4108,axiom,
    ( ~ esk2604_4(X1,X2,X3,X4)
    | ~ esk2606_4(X1,X2,X3,X4) ) ).

cnf(i_0_4109,axiom,
    ( esk497_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X2)
    | ~ p(X4)
    | p(X3)
    | ~ esk112_0 ) ).

cnf(i_0_4110,axiom,
    ( esk14915_4(X1,X2,X3,X4)
    | ~ esk14914_4(X1,X2,X3,X4) ) ).

cnf(i_0_4111,axiom,
    ( esk9898_4(X1,X2,X3,X4)
    | ~ esk9871_4(X1,X2,X3,X4) ) ).

cnf(i_0_4112,axiom,
    ( esk3801_4(X1,X2,X3,X4)
    | esk3794_4(X1,X2,X3,X4) ) ).

cnf(i_0_4113,axiom,
    ( esk15132_4(X1,X2,X3,X4)
    | esk15106_4(X1,X2,X3,X4) ) ).

cnf(i_0_4114,axiom,
    ( esk4093_4(X1,X2,X3,X4)
    | esk4149_4(X1,X2,X3,X4) ) ).

cnf(i_0_4115,axiom,
    ( ~ esk13865_4(X1,X2,X3,X4)
    | esk13946_4(X1,X2,X3,X4) ) ).

cnf(i_0_4116,axiom,
    ( ~ p(X1)
    | esk1_0
    | ~ p(X4)
    | ~ esk16685_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X2) ) ).

cnf(i_0_4117,axiom,
    ( ~ esk2477_4(X1,X2,X3,X4)
    | ~ esk2478_4(X1,X2,X3,X4)
    | esk2479_4(X1,X2,X3,X4) ) ).

cnf(i_0_4118,axiom,
    ( ~ esk2032_4(X1,X2,X3,X4)
    | esk2290_4(X1,X2,X3,X4) ) ).

cnf(i_0_4119,axiom,
    ( esk14155_4(X1,X2,X3,X4)
    | ~ esk13897_4(X1,X2,X3,X4) ) ).

cnf(i_0_4120,axiom,
    ( ~ esk1736_4(X1,X2,X3,X4)
    | esk1781_4(X1,X2,X3,X4) ) ).

cnf(i_0_4121,axiom,
    ( esk14940_4(X1,X2,X3,X4)
    | esk14941_4(X1,X2,X3,X4)
    | esk14942_4(X1,X2,X3,X4) ) ).

cnf(i_0_4122,axiom,
    ( ~ esk12619_4(X1,X2,X3,X4)
    | ~ esk12596_4(X1,X2,X3,X4) ) ).

cnf(i_0_4123,axiom,
    ( ~ esk7185_4(X1,X2,X3,X4)
    | esk7229_4(X1,X2,X3,X4)
    | esk7236_4(X1,X2,X3,X4) ) ).

cnf(i_0_4124,axiom,
    ( esk14668_4(X1,X2,X3,X4)
    | ~ esk14926_4(X1,X2,X3,X4) ) ).

cnf(i_0_4125,axiom,
    ( ~ esk4310_4(X1,X2,X3,X4)
    | ~ esk4346_4(X1,X2,X3,X4)
    | ~ esk4313_4(X1,X2,X3,X4) ) ).

cnf(i_0_4126,axiom,
    ( esk13048_4(X1,X2,X3,X4)
    | esk13063_4(X1,X2,X3,X4) ) ).

cnf(i_0_4127,axiom,
    ( esk6274_4(X1,X2,X3,X4)
    | ~ esk6299_4(X1,X2,X3,X4) ) ).

cnf(i_0_4128,axiom,
    ( ~ esk139_0
    | p(X1)
    | p(X4)
    | ~ p(X3)
    | esk501_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_4129,axiom,
    ( esk15561_4(X1,X2,X3,X4)
    | ~ esk15531_4(X1,X2,X3,X4) ) ).

cnf(i_0_4130,axiom,
    ( ~ p(X1)
    | p(X3)
    | p(X2)
    | p(X4)
    | ~ esk499_4(X1,X2,X3,X4)
    | esk130_0 ) ).

cnf(i_0_4131,axiom,
    ( esk12073_4(X1,X2,X3,X4)
    | ~ esk12010_4(X1,X2,X3,X4) ) ).

cnf(i_0_4132,axiom,
    ( esk5053_4(X1,X2,X3,X4)
    | ~ esk5037_4(X1,X2,X3,X4) ) ).

cnf(i_0_4133,axiom,
    ( ~ esk9926_4(X1,X2,X3,X4)
    | esk9910_4(X1,X2,X3,X4)
    | ~ esk9946_4(X1,X2,X3,X4) ) ).

cnf(i_0_4134,axiom,
    ( ~ esk9143_4(X1,X2,X3,X4)
    | esk9129_4(X1,X2,X3,X4)
    | ~ esk9253_4(X1,X2,X3,X4) ) ).

cnf(i_0_4135,axiom,
    ( ~ esk5402_4(X1,X2,X3,X4)
    | esk5144_4(X1,X2,X3,X4) ) ).

cnf(i_0_4136,axiom,
    ( esk4078_4(X1,X2,X3,X4)
    | esk4053_4(X1,X2,X3,X4) ) ).

cnf(i_0_4137,axiom,
    ( ~ esk5211_4(X1,X2,X3,X4)
    | esk5204_4(X1,X2,X3,X4)
    | esk5123_4(X1,X2,X3,X4) ) ).

cnf(i_0_4138,axiom,
    ( esk13086_4(X1,X2,X3,X4)
    | ~ esk13169_4(X1,X2,X3,X4)
    | esk13146_4(X1,X2,X3,X4) ) ).

cnf(i_0_4139,axiom,
    ( esk4138_4(X1,X2,X3,X4)
    | esk4137_4(X1,X2,X3,X4)
    | esk4139_4(X1,X2,X3,X4) ) ).

cnf(i_0_4140,axiom,
    ( ~ esk1682_4(X1,X2,X3,X4)
    | esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_4141,axiom,
    ( esk5947_4(X1,X2,X3,X4)
    | esk5896_4(X1,X2,X3,X4)
    | ~ esk5976_4(X1,X2,X3,X4) ) ).

cnf(i_0_4142,axiom,
    ( ~ esk14638_4(X1,X2,X3,X4)
    | esk14682_4(X1,X2,X3,X4)
    | esk14689_4(X1,X2,X3,X4) ) ).

cnf(i_0_4143,axiom,
    ( ~ esk15914_4(X1,X2,X3,X4)
    | esk16172_4(X1,X2,X3,X4) ) ).

cnf(i_0_4144,axiom,
    ( esk5147_4(X1,X2,X3,X4)
    | esk5114_4(X1,X2,X3,X4) ) ).

cnf(i_0_4145,axiom,
    ( esk5607_4(X1,X2,X3,X4)
    | esk5590_4(X1,X2,X3,X4) ) ).

cnf(i_0_4146,axiom,
    ( esk7414_4(X1,X2,X3,X4)
    | esk7385_4(X1,X2,X3,X4) ) ).

cnf(i_0_4147,axiom,
    ( esk12916_4(X1,X2,X3,X4)
    | ~ esk12917_4(X1,X2,X3,X4)
    | esk12885_4(X1,X2,X3,X4) ) ).

cnf(i_0_4148,axiom,
    ( esk5498_4(X1,X2,X3,X4)
    | ~ esk5533_4(X1,X2,X3,X4) ) ).

cnf(i_0_4149,axiom,
    ( ~ esk11637_4(X1,X2,X3,X4)
    | esk11608_4(X1,X2,X3,X4) ) ).

cnf(i_0_4150,axiom,
    ( esk10275_4(X1,X2,X3,X4)
    | esk10329_4(X1,X2,X3,X4)
    | ~ esk10310_4(X1,X2,X3,X4) ) ).

cnf(i_0_4151,axiom,
    ( esk6839_4(X1,X2,X3,X4)
    | ~ esk7097_4(X1,X2,X3,X4) ) ).

cnf(i_0_4152,axiom,
    ( esk7689_4(X1,X2,X3,X4)
    | ~ esk7749_4(X1,X2,X3,X4)
    | esk7772_4(X1,X2,X3,X4) ) ).

cnf(i_0_4153,axiom,
    ( ~ esk12097_4(X1,X2,X3,X4)
    | esk12096_4(X1,X2,X3,X4) ) ).

cnf(i_0_4154,axiom,
    ( esk14086_4(X1,X2,X3,X4)
    | esk14209_4(X1,X2,X3,X4) ) ).

cnf(i_0_4155,axiom,
    ( ~ esk12017_4(X1,X2,X3,X4)
    | ~ esk12027_4(X1,X2,X3,X4)
    | ~ esk12028_4(X1,X2,X3,X4) ) ).

cnf(i_0_4156,axiom,
    ( esk5035_4(X1,X2,X3,X4)
    | ~ esk5293_4(X1,X2,X3,X4) ) ).

cnf(i_0_4157,axiom,
    ( ~ esk15086_4(X1,X2,X3,X4)
    | ~ esk15087_4(X1,X2,X3,X4) ) ).

cnf(i_0_4158,axiom,
    ( esk5635_4(X1,X2,X3,X4)
    | ~ esk5536_4(X1,X2,X3,X4) ) ).

cnf(i_0_4159,axiom,
    ( ~ esk2217_4(X1,X2,X3,X4)
    | ~ esk2218_4(X1,X2,X3,X4) ) ).

cnf(i_0_4160,axiom,
    ( ~ esk2951_4(X1,X2,X3,X4)
    | ~ esk2974_4(X1,X2,X3,X4) ) ).

cnf(i_0_4161,axiom,
    ( esk15643_4(X1,X2,X3,X4)
    | esk15676_4(X1,X2,X3,X4) ) ).

cnf(i_0_4162,axiom,
    ( ~ esk11071_4(X1,X2,X3,X4)
    | ~ esk10972_4(X1,X2,X3,X4) ) ).

cnf(i_0_4163,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12213_4(X1,X2,X3,X4) ) ).

cnf(i_0_4164,axiom,
    ( ~ esk13285_4(X1,X2,X3,X4)
    | ~ esk13384_4(X1,X2,X3,X4) ) ).

cnf(i_0_4165,axiom,
    ( esk7871_4(X1,X2,X3,X4)
    | ~ esk7875_4(X1,X2,X3,X4)
    | esk7869_4(X1,X2,X3,X4) ) ).

cnf(i_0_4166,axiom,
    ( esk16192_4(X1,X2,X3,X4)
    | esk16159_4(X1,X2,X3,X4) ) ).

cnf(i_0_4167,axiom,
    ( esk3893_4(X1,X2,X3,X4)
    | esk3891_4(X1,X2,X3,X4) ) ).

cnf(i_0_4168,axiom,
    ( esk13242_4(X1,X2,X3,X4)
    | ~ esk13367_4(X1,X2,X3,X4)
    | ~ esk13255_4(X1,X2,X3,X4) ) ).

cnf(i_0_4169,axiom,
    ( ~ esk7807_4(X1,X2,X3,X4)
    | ~ esk7859_4(X1,X2,X3,X4)
    | ~ esk7809_4(X1,X2,X3,X4)
    | ~ esk7806_4(X1,X2,X3,X4)
    | ~ esk7860_4(X1,X2,X3,X4) ) ).

cnf(i_0_4170,axiom,
    ( esk5109_4(X1,X2,X3,X4)
    | esk5083_4(X1,X2,X3,X4) ) ).

cnf(i_0_4171,axiom,
    ( esk8401_4(X1,X2,X3,X4)
    | ~ esk8399_4(X1,X2,X3,X4) ) ).

cnf(i_0_4172,axiom,
    ( esk10750_4(X1,X2,X3,X4)
    | esk10735_4(X1,X2,X3,X4) ) ).

cnf(i_0_4173,axiom,
    ( ~ esk2158_4(X1,X2,X3,X4)
    | esk2191_4(X1,X2,X3,X4) ) ).

cnf(i_0_4174,axiom,
    ( esk10777_4(X1,X2,X3,X4)
    | ~ esk10519_4(X1,X2,X3,X4) ) ).

cnf(i_0_4175,axiom,
    ( esk7390_4(X1,X2,X3,X4)
    | esk7403_4(X1,X2,X3,X4) ) ).

cnf(i_0_4176,axiom,
    ( esk14078_4(X1,X2,X3,X4)
    | esk14106_4(X1,X2,X3,X4) ) ).

cnf(i_0_4177,axiom,
    ( esk3758_4(X1,X2,X3,X4)
    | esk3757_4(X1,X2,X3,X4)
    | esk3754_4(X1,X2,X3,X4)
    | esk3760_4(X1,X2,X3,X4) ) ).

cnf(i_0_4178,axiom,
    ( ~ esk5376_4(X1,X2,X3,X4)
    | esk5118_4(X1,X2,X3,X4) ) ).

cnf(i_0_4179,axiom,
    ( ~ esk5125_4(X1,X2,X3,X4)
    | ~ esk5176_4(X1,X2,X3,X4)
    | ~ esk5211_4(X1,X2,X3,X4) ) ).

cnf(i_0_4180,axiom,
    ( esk9712_4(X1,X2,X3,X4)
    | esk9745_4(X1,X2,X3,X4) ) ).

cnf(i_0_4181,axiom,
    ( ~ esk9277_4(X1,X2,X3,X4)
    | esk9307_4(X1,X2,X3,X4) ) ).

cnf(i_0_4182,axiom,
    ( esk15576_4(X1,X2,X3,X4)
    | esk15581_4(X1,X2,X3,X4)
    | esk15582_4(X1,X2,X3,X4) ) ).

cnf(i_0_4183,axiom,
    ( esk8231_4(X1,X2,X3,X4)
    | ~ esk8110_4(X1,X2,X3,X4) ) ).

cnf(i_0_4184,axiom,
    ( ~ esk13009_4(X1,X2,X3,X4)
    | ~ esk13010_4(X1,X2,X3,X4) ) ).

cnf(i_0_4185,axiom,
    ( esk13114_4(X1,X2,X3,X4)
    | esk13132_4(X1,X2,X3,X4) ) ).

cnf(i_0_4186,axiom,
    ( ~ esk660_4(X1,X2,X3,X4)
    | esk665_4(X1,X2,X3,X4) ) ).

cnf(i_0_4187,axiom,
    ( esk2043_4(X1,X2,X3,X4)
    | ~ esk1785_4(X1,X2,X3,X4) ) ).

cnf(i_0_4188,axiom,
    ( esk16696_4(X1,X2,X3,X4)
    | esk16777_4(X1,X2,X3,X4) ) ).

cnf(i_0_4189,axiom,
    ( esk1321_4(X1,X2,X3,X4)
    | esk1350_4(X1,X2,X3,X4)
    | ~ esk1270_4(X1,X2,X3,X4) ) ).

cnf(i_0_4190,axiom,
    ( esk15911_4(X1,X2,X3,X4)
    | esk15878_4(X1,X2,X3,X4) ) ).

cnf(i_0_4191,axiom,
    ( ~ esk5527_4(X1,X2,X3,X4)
    | esk5545_4(X1,X2,X3,X4) ) ).

cnf(i_0_4192,axiom,
    ( esk7078_4(X1,X2,X3,X4)
    | ~ esk7052_4(X1,X2,X3,X4) ) ).

cnf(i_0_4193,axiom,
    ( esk15036_4(X1,X2,X3,X4)
    | ~ esk15013_4(X1,X2,X3,X4) ) ).

cnf(i_0_4194,axiom,
    ( ~ esk13287_4(X1,X2,X3,X4)
    | ~ esk13288_4(X1,X2,X3,X4) ) ).

cnf(i_0_4195,axiom,
    ( esk11025_4(X1,X2,X3,X4)
    | esk10976_4(X1,X2,X3,X4) ) ).

cnf(i_0_4196,axiom,
    ( ~ p(X3)
    | esk16707_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X1)
    | ~ esk265_0
    | ~ p(X2) ) ).

cnf(i_0_4197,axiom,
    ( ~ esk4481_4(X1,X2,X3,X4)
    | esk4509_4(X1,X2,X3,X4) ) ).

cnf(i_0_4198,axiom,
    ( esk8171_4(X1,X2,X3,X4)
    | esk8286_4(X1,X2,X3,X4) ) ).

cnf(i_0_4199,axiom,
    ( ~ esk10070_4(X1,X2,X3,X4)
    | ~ esk10069_4(X1,X2,X3,X4)
    | esk10071_4(X1,X2,X3,X4) ) ).

cnf(i_0_4200,axiom,
    ( esk7514_4(X1,X2,X3,X4)
    | ~ esk7430_4(X1,X2,X3,X4)
    | esk7477_4(X1,X2,X3,X4) ) ).

cnf(i_0_4201,axiom,
    ( esk6454_4(X1,X2,X3,X4)
    | esk6475_4(X1,X2,X3,X4)
    | ~ esk6453_4(X1,X2,X3,X4) ) ).

cnf(i_0_4202,axiom,
    ( ~ esk5047_4(X1,X2,X3,X4)
    | esk5049_4(X1,X2,X3,X4)
    | ~ esk5048_4(X1,X2,X3,X4) ) ).

cnf(i_0_4203,axiom,
    ( esk3810_4(X1,X2,X3,X4)
    | esk3790_4(X1,X2,X3,X4) ) ).

cnf(i_0_4204,axiom,
    ( esk16771_4(X1,X2,X3,X4)
    | esk16739_4(X1,X2,X3,X4) ) ).

cnf(i_0_4205,axiom,
    ( esk6729_4(X1,X2,X3,X4)
    | ~ esk6675_4(X1,X2,X3,X4) ) ).

cnf(i_0_4206,axiom,
    ( esk11629_4(X1,X2,X3,X4)
    | ~ esk11548_4(X1,X2,X3,X4)
    | esk11636_4(X1,X2,X3,X4) ) ).

cnf(i_0_4207,axiom,
    ( esk9966_4(X1,X2,X3,X4)
    | esk9976_4(X1,X2,X3,X4) ) ).

cnf(i_0_4208,axiom,
    ( ~ p(X1)
    | p(X4)
    | p(X3)
    | ~ p(X2)
    | ~ esk517_4(X1,X2,X3,X4)
    | esk269_0 ) ).

cnf(i_0_4209,axiom,
    ( esk2053_4(X1,X2,X3,X4)
    | esk2020_4(X1,X2,X3,X4) ) ).

cnf(i_0_4210,axiom,
    ( ~ esk3343_4(X1,X2,X3,X4)
    | esk3268_4(X1,X2,X3,X4) ) ).

cnf(i_0_4211,axiom,
    ( esk5640_4(X1,X2,X3,X4)
    | ~ esk5589_4(X1,X2,X3,X4) ) ).

cnf(i_0_4212,axiom,
    ( p(X4)
    | ~ esk119_0
    | p(X3)
    | ~ p(X1)
    | ~ p(X2)
    | esk497_4(X1,X2,X3,X4) ) ).

cnf(i_0_4213,axiom,
    ( ~ esk12042_4(X1,X2,X3,X4)
    | ~ esk12128_4(X1,X2,X3,X4)
    | ~ esk12022_4(X1,X2,X3,X4) ) ).

cnf(i_0_4214,axiom,
    ( ~ esk6839_4(X1,X2,X3,X4)
    | esk6848_4(X1,X2,X3,X4) ) ).

cnf(i_0_4215,axiom,
    ( ~ esk11827_4(X1,X2,X3,X4)
    | ~ esk11847_4(X1,X2,X3,X4)
    | ~ esk11829_4(X1,X2,X3,X4) ) ).

cnf(i_0_4216,axiom,
    ( ~ esk12101_4(X1,X2,X3,X4)
    | esk12138_4(X1,X2,X3,X4) ) ).

cnf(i_0_4217,axiom,
    ( esk10637_4(X1,X2,X3,X4)
    | ~ esk10680_4(X1,X2,X3,X4) ) ).

cnf(i_0_4218,axiom,
    ( ~ esk15280_4(X1,X2,X3,X4)
    | esk15437_4(X1,X2,X3,X4) ) ).

cnf(i_0_4219,axiom,
    ( esk14571_4(X1,X2,X3,X4)
    | esk14662_4(X1,X2,X3,X4) ) ).

cnf(i_0_4220,axiom,
    ( esk12319_4(X1,X2,X3,X4)
    | esk12286_4(X1,X2,X3,X4) ) ).

cnf(i_0_4221,axiom,
    ( ~ esk658_4(X1,X2,X3,X4)
    | esk674_4(X1,X2,X3,X4) ) ).

cnf(i_0_4222,axiom,
    ( esk1202_4(X1,X2,X3,X4)
    | ~ esk1200_4(X1,X2,X3,X4)
    | ~ esk1201_4(X1,X2,X3,X4) ) ).

cnf(i_0_4223,axiom,
    ( esk15839_4(X1,X2,X3,X4)
    | esk15833_4(X1,X2,X3,X4)
    | esk15838_4(X1,X2,X3,X4) ) ).

cnf(i_0_4224,axiom,
    ( esk14889_4(X1,X2,X3,X4)
    | ~ esk14789_4(X1,X2,X3,X4) ) ).

cnf(i_0_4225,axiom,
    ( esk1002_4(X1,X2,X3,X4)
    | esk953_4(X1,X2,X3,X4) ) ).

cnf(i_0_4226,axiom,
    ( ~ esk14955_4(X1,X2,X3,X4)
    | ~ esk14936_4(X1,X2,X3,X4)
    | ~ esk14901_4(X1,X2,X3,X4) ) ).

cnf(i_0_4227,axiom,
    ( ~ esk527_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4)
    | p(X3)
    | esk1_0
    | p(X1) ) ).

cnf(i_0_4228,axiom,
    ( ~ esk11175_4(X1,X2,X3,X4)
    | ~ esk11198_4(X1,X2,X3,X4) ) ).

cnf(i_0_4229,axiom,
    ( ~ esk9646_4(X1,X2,X3,X4)
    | esk9624_4(X1,X2,X3,X4) ) ).

cnf(i_0_4230,axiom,
    ( ~ esk777_4(X1,X2,X3,X4)
    | esk696_4(X1,X2,X3,X4) ) ).

cnf(i_0_4231,axiom,
    ( esk12307_4(X1,X2,X3,X4)
    | esk12392_4(X1,X2,X3,X4) ) ).

cnf(i_0_4232,axiom,
    ( ~ esk9745_4(X1,X2,X3,X4)
    | ~ esk9805_4(X1,X2,X3,X4)
    | ~ esk9828_4(X1,X2,X3,X4) ) ).

cnf(i_0_4233,axiom,
    ( esk16070_4(X1,X2,X3,X4)
    | ~ esk16035_4(X1,X2,X3,X4) ) ).

cnf(i_0_4234,axiom,
    ( ~ esk3232_4(X1,X2,X3,X4)
    | ~ esk3332_4(X1,X2,X3,X4)
    | esk3213_4(X1,X2,X3,X4) ) ).

cnf(i_0_4235,axiom,
    ( ~ esk10125_4(X1,X2,X3,X4)
    | esk10158_4(X1,X2,X3,X4) ) ).

cnf(i_0_4236,axiom,
    ( esk3067_4(X1,X2,X3,X4)
    | ~ esk3148_4(X1,X2,X3,X4)
    | esk3155_4(X1,X2,X3,X4) ) ).

cnf(i_0_4237,axiom,
    ( esk13385_4(X1,X2,X3,X4)
    | esk13378_4(X1,X2,X3,X4) ) ).

cnf(i_0_4238,axiom,
    ( esk4657_4(X1,X2,X3,X4)
    | esk4671_4(X1,X2,X3,X4) ) ).

cnf(i_0_4239,axiom,
    ( esk5563_4(X1,X2,X3,X4)
    | ~ esk5562_4(X1,X2,X3,X4)
    | ~ esk5561_4(X1,X2,X3,X4) ) ).

cnf(i_0_4240,axiom,
    ( ~ esk9296_4(X1,X2,X3,X4)
    | ~ esk9211_4(X1,X2,X3,X4)
    | ~ esk9195_4(X1,X2,X3,X4) ) ).

cnf(i_0_4241,axiom,
    ( esk7963_4(X1,X2,X3,X4)
    | ~ esk7897_4(X1,X2,X3,X4) ) ).

cnf(i_0_4242,axiom,
    ( ~ esk9247_4(X1,X2,X3,X4)
    | esk9301_4(X1,X2,X3,X4)
    | esk9282_4(X1,X2,X3,X4) ) ).

cnf(i_0_4243,axiom,
    ( esk3778_4(X1,X2,X3,X4)
    | ~ esk3716_4(X1,X2,X3,X4) ) ).

cnf(i_0_4244,axiom,
    ( ~ esk5417_4(X1,X2,X3,X4)
    | ~ esk5319_4(X1,X2,X3,X4)
    | ~ esk5410_4(X1,X2,X3,X4) ) ).

cnf(i_0_4245,axiom,
    ( esk12104_4(X1,X2,X3,X4)
    | esk12084_4(X1,X2,X3,X4) ) ).

cnf(i_0_4246,axiom,
    ( ~ esk441_4(X1,X2,X3,X4)
    | ~ esk484_4(X1,X2,X3,X4)
    | ~ esk485_4(X1,X2,X3,X4) ) ).

cnf(i_0_4247,axiom,
    ( ~ esk15263_4(X1,X2,X3,X4)
    | esk15306_4(X1,X2,X3,X4) ) ).

cnf(i_0_4248,axiom,
    ( esk11113_4(X1,X2,X3,X4)
    | esk10998_4(X1,X2,X3,X4) ) ).

cnf(i_0_4249,axiom,
    ( esk4600_4(X1,X2,X3,X4)
    | esk4567_4(X1,X2,X3,X4) ) ).

cnf(i_0_4250,axiom,
    ( esk9445_4(X1,X2,X3,X4)
    | ~ esk9493_4(X1,X2,X3,X4) ) ).

cnf(i_0_4251,axiom,
    ( esk8375_4(X1,X2,X3,X4)
    | ~ esk8370_4(X1,X2,X3,X4) ) ).

cnf(i_0_4252,axiom,
    ( ~ esk15338_4(X1,X2,X3,X4)
    | esk15340_4(X1,X2,X3,X4) ) ).

cnf(i_0_4253,axiom,
    ( esk11245_4(X1,X2,X3,X4)
    | esk11258_4(X1,X2,X3,X4) ) ).

cnf(i_0_4254,axiom,
    ( ~ esk7216_4(X1,X2,X3,X4)
    | ~ esk7119_4(X1,X2,X3,X4) ) ).

cnf(i_0_4255,axiom,
    ( ~ esk5074_4(X1,X2,X3,X4)
    | esk5128_4(X1,X2,X3,X4) ) ).

cnf(i_0_4256,axiom,
    ( ~ esk8207_4(X1,X2,X3,X4)
    | esk7949_4(X1,X2,X3,X4) ) ).

cnf(i_0_4257,axiom,
    ( esk2461_4(X1,X2,X3,X4)
    | ~ esk2453_4(X1,X2,X3,X4) ) ).

cnf(i_0_4258,axiom,
    ( ~ esk3839_4(X1,X2,X3,X4)
    | esk4097_4(X1,X2,X3,X4) ) ).

cnf(i_0_4259,axiom,
    ( esk1243_4(X1,X2,X3,X4)
    | esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_4260,axiom,
    ( ~ esk12886_4(X1,X2,X3,X4)
    | esk12915_4(X1,X2,X3,X4)
    | esk12835_4(X1,X2,X3,X4) ) ).

cnf(i_0_4261,axiom,
    ( esk4556_4(X1,X2,X3,X4)
    | esk4591_4(X1,X2,X3,X4) ) ).

cnf(i_0_4262,axiom,
    ( esk513_4(X1,X2,X3,X4)
    | esk480_4(X1,X2,X3,X4) ) ).

cnf(i_0_4263,axiom,
    ( ~ esk4612_4(X1,X2,X3,X4)
    | esk4870_4(X1,X2,X3,X4) ) ).

cnf(i_0_4264,axiom,
    ( ~ esk4634_4(X1,X2,X3,X4)
    | esk4635_4(X1,X2,X3,X4) ) ).

cnf(i_0_4265,axiom,
    ( esk2122_4(X1,X2,X3,X4)
    | esk2091_4(X1,X2,X3,X4)
    | ~ esk2123_4(X1,X2,X3,X4) ) ).

cnf(i_0_4266,axiom,
    ( ~ esk5400_4(X1,X2,X3,X4)
    | esk5142_4(X1,X2,X3,X4) ) ).

cnf(i_0_4267,axiom,
    ( esk7753_4(X1,X2,X3,X4)
    | ~ esk7754_4(X1,X2,X3,X4) ) ).

cnf(i_0_4268,axiom,
    ( esk8952_4(X1,X2,X3,X4)
    | esk8929_4(X1,X2,X3,X4) ) ).

cnf(i_0_4269,axiom,
    ( ~ esk1309_4(X1,X2,X3,X4)
    | esk1346_4(X1,X2,X3,X4)
    | esk1262_4(X1,X2,X3,X4) ) ).

cnf(i_0_4270,axiom,
    ( esk14926_4(X1,X2,X3,X4)
    | esk14927_4(X1,X2,X3,X4) ) ).

cnf(i_0_4271,axiom,
    ( esk14656_4(X1,X2,X3,X4)
    | ~ esk14398_4(X1,X2,X3,X4) ) ).

cnf(i_0_4272,axiom,
    ( esk7671_4(X1,X2,X3,X4)
    | esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_4273,axiom,
    ( ~ esk11180_4(X1,X2,X3,X4)
    | esk11159_4(X1,X2,X3,X4) ) ).

cnf(i_0_4274,axiom,
    ( esk5426_4(X1,X2,X3,X4)
    | esk5424_4(X1,X2,X3,X4) ) ).

cnf(i_0_4275,axiom,
    ( ~ esk7960_4(X1,X2,X3,X4)
    | ~ esk7927_4(X1,X2,X3,X4)
    | ~ esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_4276,axiom,
    ( esk15579_4(X1,X2,X3,X4)
    | esk15578_4(X1,X2,X3,X4) ) ).

cnf(i_0_4277,axiom,
    ( ~ esk14464_4(X1,X2,X3,X4)
    | ~ esk14425_4(X1,X2,X3,X4) ) ).

cnf(i_0_4278,axiom,
    ( ~ esk11588_4(X1,X2,X3,X4)
    | ~ esk11606_4(X1,X2,X3,X4) ) ).

cnf(i_0_4279,axiom,
    ( esk3374_4(X1,X2,X3,X4)
    | esk3375_4(X1,X2,X3,X4) ) ).

cnf(i_0_4280,axiom,
    ( esk2182_4(X1,X2,X3,X4)
    | ~ esk2202_4(X1,X2,X3,X4) ) ).

cnf(i_0_4281,axiom,
    ( esk15191_4(X1,X2,X3,X4)
    | esk15192_4(X1,X2,X3,X4)
    | ~ esk15213_4(X1,X2,X3,X4) ) ).

cnf(i_0_4282,axiom,
    ( ~ esk4996_4(X1,X2,X3,X4)
    | esk5022_4(X1,X2,X3,X4) ) ).

cnf(i_0_4283,axiom,
    ( ~ esk9753_4(X1,X2,X3,X4)
    | esk9495_4(X1,X2,X3,X4) ) ).

cnf(i_0_4284,axiom,
    ( esk11545_4(X1,X2,X3,X4)
    | ~ esk11803_4(X1,X2,X3,X4) ) ).

cnf(i_0_4285,axiom,
    ( ~ esk928_4(X1,X2,X3,X4)
    | esk937_4(X1,X2,X3,X4) ) ).

cnf(i_0_4286,axiom,
    ( ~ esk12339_4(X1,X2,X3,X4)
    | esk12081_4(X1,X2,X3,X4) ) ).

cnf(i_0_4287,axiom,
    ( p(X4)
    | esk503_4(X1,X2,X3,X4)
    | p(X3)
    | p(X2)
    | p(X1)
    | ~ esk1_0 ) ).

cnf(i_0_4288,axiom,
    ( ~ esk1524_4(X1,X2,X3,X4)
    | esk1782_4(X1,X2,X3,X4) ) ).

cnf(i_0_4289,axiom,
    ( ~ esk937_4(X1,X2,X3,X4)
    | esk928_4(X1,X2,X3,X4) ) ).

cnf(i_0_4290,axiom,
    ( esk11340_4(X1,X2,X3,X4)
    | esk11301_4(X1,X2,X3,X4) ) ).

cnf(i_0_4291,axiom,
    ( esk13348_4(X1,X2,X3,X4)
    | ~ esk13300_4(X1,X2,X3,X4) ) ).

cnf(i_0_4292,axiom,
    ( esk11767_4(X1,X2,X3,X4)
    | esk11883_4(X1,X2,X3,X4) ) ).

cnf(i_0_4293,axiom,
    ( esk15403_4(X1,X2,X3,X4)
    | ~ esk15491_4(X1,X2,X3,X4)
    | esk15484_4(X1,X2,X3,X4) ) ).

cnf(i_0_4294,axiom,
    ( ~ esk16475_4(X1,X2,X3,X4)
    | ~ esk16474_4(X1,X2,X3,X4) ) ).

cnf(i_0_4295,axiom,
    ( esk4151_4(X1,X2,X3,X4)
    | esk4149_4(X1,X2,X3,X4)
    | esk4150_4(X1,X2,X3,X4) ) ).

cnf(i_0_4296,axiom,
    ( ~ esk1758_4(X1,X2,X3,X4)
    | ~ esk1742_4(X1,X2,X3,X4)
    | ~ esk1843_4(X1,X2,X3,X4) ) ).

cnf(i_0_4297,axiom,
    ( ~ esk16616_4(X1,X2,X3,X4)
    | esk16618_4(X1,X2,X3,X4)
    | ~ esk16617_4(X1,X2,X3,X4) ) ).

cnf(i_0_4298,axiom,
    ( esk2978_4(X1,X2,X3,X4)
    | ~ esk2975_4(X1,X2,X3,X4) ) ).

cnf(i_0_4299,axiom,
    ( esk12229_4(X1,X2,X3,X4)
    | esk12201_4(X1,X2,X3,X4)
    | esk12177_4(X1,X2,X3,X4)
    | esk12199_4(X1,X2,X3,X4)
    | esk12202_4(X1,X2,X3,X4) ) ).

cnf(i_0_4300,axiom,
    ( esk10589_4(X1,X2,X3,X4)
    | esk10538_4(X1,X2,X3,X4)
    | ~ esk10564_4(X1,X2,X3,X4) ) ).

cnf(i_0_4301,axiom,
    ( ~ esk10030_4(X1,X2,X3,X4)
    | ~ esk10048_4(X1,X2,X3,X4)
    | ~ esk10028_4(X1,X2,X3,X4) ) ).

cnf(i_0_4302,axiom,
    ( ~ esk5917_4(X1,X2,X3,X4)
    | esk5836_4(X1,X2,X3,X4) ) ).

cnf(i_0_4303,axiom,
    ( ~ esk2294_4(X1,X2,X3,X4)
    | ~ esk2254_4(X1,X2,X3,X4)
    | ~ esk2261_4(X1,X2,X3,X4) ) ).

cnf(i_0_4304,axiom,
    ( esk14572_4(X1,X2,X3,X4)
    | ~ esk14536_4(X1,X2,X3,X4) ) ).

cnf(i_0_4305,axiom,
    ( ~ esk72_0
    | p(X4)
    | p(X2)
    | esk491_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X1) ) ).

cnf(i_0_4306,axiom,
    ( ~ esk13054_4(X1,X2,X3,X4)
    | ~ esk13169_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_4307,axiom,
    ( esk712_4(X1,X2,X3,X4)
    | esk743_4(X1,X2,X3,X4) ) ).

cnf(i_0_4308,axiom,
    ( esk14307_4(X1,X2,X3,X4)
    | ~ esk14311_4(X1,X2,X3,X4) ) ).

cnf(i_0_4309,axiom,
    ( ~ esk9825_4(X1,X2,X3,X4)
    | esk9788_4(X1,X2,X3,X4)
    | esk9771_4(X1,X2,X3,X4) ) ).

cnf(i_0_4310,axiom,
    ( esk13819_4(X1,X2,X3,X4)
    | esk13852_4(X1,X2,X3,X4) ) ).

cnf(i_0_4311,axiom,
    ( esk16512_4(X1,X2,X3,X4)
    | esk16431_4(X1,X2,X3,X4)
    | ~ esk16519_4(X1,X2,X3,X4) ) ).

cnf(i_0_4312,axiom,
    ( esk7344_4(X1,X2,X3,X4)
    | ~ esk7325_4(X1,X2,X3,X4) ) ).

cnf(i_0_4313,axiom,
    ( esk13040_4(X1,X2,X3,X4)
    | esk13065_4(X1,X2,X3,X4) ) ).

cnf(i_0_4314,axiom,
    ( ~ esk1137_4(X1,X2,X3,X4)
    | esk1156_4(X1,X2,X3,X4) ) ).

cnf(i_0_4315,axiom,
    ( esk10921_4(X1,X2,X3,X4)
    | ~ esk10973_4(X1,X2,X3,X4) ) ).

cnf(i_0_4316,axiom,
    ( ~ esk14807_4(X1,X2,X3,X4)
    | esk14813_4(X1,X2,X3,X4) ) ).

cnf(i_0_4317,axiom,
    ( esk8908_4(X1,X2,X3,X4)
    | ~ esk8892_4(X1,X2,X3,X4) ) ).

cnf(i_0_4318,axiom,
    ( esk16755_4(X1,X2,X3,X4)
    | ~ esk16734_4(X1,X2,X3,X4)
    | esk16733_4(X1,X2,X3,X4) ) ).

cnf(i_0_4319,axiom,
    ( esk1051_4(X1,X2,X3,X4)
    | ~ esk1071_4(X1,X2,X3,X4)
    | esk1100_4(X1,X2,X3,X4) ) ).

cnf(i_0_4320,axiom,
    ( esk1497_4(X1,X2,X3,X4)
    | esk1485_4(X1,X2,X3,X4) ) ).

cnf(i_0_4321,axiom,
    ( ~ esk4886_4(X1,X2,X3,X4)
    | ~ esk4774_4(X1,X2,X3,X4)
    | esk4761_4(X1,X2,X3,X4) ) ).

cnf(i_0_4322,axiom,
    ( ~ esk12644_4(X1,X2,X3,X4)
    | esk12663_4(X1,X2,X3,X4)
    | esk12592_4(X1,X2,X3,X4) ) ).

cnf(i_0_4323,axiom,
    ( ~ esk10062_4(X1,X2,X3,X4)
    | esk10085_4(X1,X2,X3,X4)
    | esk10002_4(X1,X2,X3,X4) ) ).

cnf(i_0_4324,axiom,
    ( esk2021_4(X1,X2,X3,X4)
    | esk1999_4(X1,X2,X3,X4) ) ).

cnf(i_0_4325,axiom,
    ( ~ esk16333_4(X1,X2,X3,X4)
    | esk16435_4(X1,X2,X3,X4) ) ).

cnf(i_0_4326,axiom,
    ( esk493_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X1)
    | ~ p(X2)
    | p(X4)
    | ~ esk91_0 ) ).

cnf(i_0_4327,axiom,
    ( esk7161_4(X1,X2,X3,X4)
    | esk7139_4(X1,X2,X3,X4) ) ).

cnf(i_0_4328,axiom,
    ( esk1249_4(X1,X2,X3,X4)
    | esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_4329,axiom,
    ( ~ esk1831_4(X1,X2,X3,X4)
    | ~ esk1792_4(X1,X2,X3,X4) ) ).

cnf(i_0_4330,axiom,
    ( esk16487_4(X1,X2,X3,X4)
    | esk16485_4(X1,X2,X3,X4)
    | esk16486_4(X1,X2,X3,X4) ) ).

cnf(i_0_4331,axiom,
    ( ~ esk12241_4(X1,X2,X3,X4)
    | esk12248_4(X1,X2,X3,X4) ) ).

cnf(i_0_4332,axiom,
    ( ~ esk3153_4(X1,X2,X3,X4)
    | esk3152_4(X1,X2,X3,X4) ) ).

cnf(i_0_4333,axiom,
    ( ~ esk778_4(X1,X2,X3,X4)
    | ~ esk662_4(X1,X2,X3,X4)
    | esk657_4(X1,X2,X3,X4) ) ).

cnf(i_0_4334,axiom,
    ( esk14630_4(X1,X2,X3,X4)
    | ~ esk14372_4(X1,X2,X3,X4) ) ).

cnf(i_0_4335,axiom,
    ( ~ esk11925_4(X1,X2,X3,X4)
    | esk11956_4(X1,X2,X3,X4) ) ).

cnf(i_0_4336,axiom,
    ( ~ esk6167_4(X1,X2,X3,X4)
    | esk6219_4(X1,X2,X3,X4)
    | esk6238_4(X1,X2,X3,X4) ) ).

cnf(i_0_4337,axiom,
    ( ~ esk1693_4(X1,X2,X3,X4)
    | ~ esk1666_4(X1,X2,X3,X4)
    | esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_4338,axiom,
    ( esk5799_4(X1,X2,X3,X4)
    | ~ esk5800_4(X1,X2,X3,X4) ) ).

cnf(i_0_4339,axiom,
    ( esk11474_4(X1,X2,X3,X4)
    | ~ esk11465_4(X1,X2,X3,X4) ) ).

cnf(i_0_4340,axiom,
    ( esk13810_4(X1,X2,X3,X4)
    | esk13839_4(X1,X2,X3,X4) ) ).

cnf(i_0_4341,axiom,
    ( ~ esk15652_4(X1,X2,X3,X4)
    | ~ esk15699_4(X1,X2,X3,X4)
    | ~ esk15620_4(X1,X2,X3,X4) ) ).

cnf(i_0_4342,axiom,
    ( esk6973_4(X1,X2,X3,X4)
    | ~ esk7007_4(X1,X2,X3,X4)
    | esk6926_4(X1,X2,X3,X4) ) ).

cnf(i_0_4343,axiom,
    ( ~ esk6646_4(X1,X2,X3,X4)
    | ~ esk6679_4(X1,X2,X3,X4)
    | ~ esk6623_4(X1,X2,X3,X4) ) ).

cnf(i_0_4344,axiom,
    ( esk15054_4(X1,X2,X3,X4)
    | ~ esk15048_4(X1,X2,X3,X4) ) ).

cnf(i_0_4345,axiom,
    ( ~ esk16045_4(X1,X2,X3,X4)
    | esk16075_4(X1,X2,X3,X4) ) ).

cnf(i_0_4346,axiom,
    ( ~ esk1342_4(X1,X2,X3,X4)
    | esk1343_4(X1,X2,X3,X4) ) ).

cnf(i_0_4347,axiom,
    ( esk9964_4(X1,X2,X3,X4)
    | esk9973_4(X1,X2,X3,X4) ) ).

cnf(i_0_4348,axiom,
    ( esk3049_4(X1,X2,X3,X4)
    | esk3014_4(X1,X2,X3,X4) ) ).

cnf(i_0_4349,axiom,
    ( ~ esk5902_4(X1,X2,X3,X4)
    | ~ esk5983_4(X1,X2,X3,X4) ) ).

cnf(i_0_4350,axiom,
    ( ~ esk10754_4(X1,X2,X3,X4)
    | ~ esk10755_4(X1,X2,X3,X4)
    | ~ esk10726_4(X1,X2,X3,X4) ) ).

cnf(i_0_4351,axiom,
    ( esk1156_4(X1,X2,X3,X4)
    | ~ esk1176_4(X1,X2,X3,X4)
    | ~ esk1274_4(X1,X2,X3,X4) ) ).

cnf(i_0_4352,axiom,
    ( esk2748_4(X1,X2,X3,X4)
    | esk2840_4(X1,X2,X3,X4)
    | esk2847_4(X1,X2,X3,X4) ) ).

cnf(i_0_4353,axiom,
    ( esk14276_4(X1,X2,X3,X4)
    | ~ esk14246_4(X1,X2,X3,X4) ) ).

cnf(i_0_4354,axiom,
    ( ~ esk14160_4(X1,X2,X3,X4)
    | ~ esk14142_4(X1,X2,X3,X4)
    | ~ esk14140_4(X1,X2,X3,X4) ) ).

cnf(i_0_4355,axiom,
    ( ~ esk1665_4(X1,X2,X3,X4)
    | ~ esk1692_4(X1,X2,X3,X4) ) ).

cnf(i_0_4356,axiom,
    ( ~ esk2321_4(X1,X2,X3,X4)
    | esk2322_4(X1,X2,X3,X4) ) ).

cnf(i_0_4357,axiom,
    ( ~ esk4665_4(X1,X2,X3,X4)
    | ~ esk4664_4(X1,X2,X3,X4) ) ).

cnf(i_0_4358,axiom,
    ( esk3448_4(X1,X2,X3,X4)
    | ~ esk3471_4(X1,X2,X3,X4) ) ).

cnf(i_0_4359,axiom,
    ( ~ esk16134_4(X1,X2,X3,X4)
    | ~ esk16112_4(X1,X2,X3,X4) ) ).

cnf(i_0_4360,axiom,
    ( esk6706_4(X1,X2,X3,X4)
    | ~ esk6661_4(X1,X2,X3,X4)
    | ~ esk6721_4(X1,X2,X3,X4) ) ).

cnf(i_0_4361,axiom,
    ( esk10967_4(X1,X2,X3,X4)
    | ~ esk10968_4(X1,X2,X3,X4) ) ).

cnf(i_0_4362,axiom,
    ( ~ esk13030_4(X1,X2,X3,X4)
    | esk12968_4(X1,X2,X3,X4) ) ).

cnf(i_0_4363,axiom,
    ( esk4520_4(X1,X2,X3,X4)
    | ~ esk4515_4(X1,X2,X3,X4) ) ).

cnf(i_0_4364,axiom,
    ( ~ esk9156_4(X1,X2,X3,X4)
    | ~ esk9158_4(X1,X2,X3,X4) ) ).

cnf(i_0_4365,axiom,
    ( esk14882_4(X1,X2,X3,X4)
    | ~ esk14846_4(X1,X2,X3,X4) ) ).

cnf(i_0_4366,axiom,
    ( ~ esk14674_4(X1,X2,X3,X4)
    | ~ esk14654_4(X1,X2,X3,X4)
    | ~ esk14656_4(X1,X2,X3,X4) ) ).

cnf(i_0_4367,axiom,
    ( ~ esk5171_4(X1,X2,X3,X4)
    | ~ esk5170_4(X1,X2,X3,X4)
    | ~ esk5135_4(X1,X2,X3,X4) ) ).

cnf(i_0_4368,axiom,
    ( ~ esk1068_4(X1,X2,X3,X4)
    | ~ esk1061_4(X1,X2,X3,X4)
    | ~ esk1017_4(X1,X2,X3,X4) ) ).

cnf(i_0_4369,axiom,
    ( esk393_4(X1,X2,X3,X4)
    | ~ esk358_4(X1,X2,X3,X4) ) ).

cnf(i_0_4370,axiom,
    ( esk6059_4(X1,X2,X3,X4)
    | ~ esk6044_4(X1,X2,X3,X4) ) ).

cnf(i_0_4371,axiom,
    ( ~ esk9691_4(X1,X2,X3,X4)
    | ~ esk9741_4(X1,X2,X3,X4)
    | ~ esk9740_4(X1,X2,X3,X4) ) ).

cnf(i_0_4372,axiom,
    ( ~ esk15395_4(X1,X2,X3,X4)
    | ~ esk15394_4(X1,X2,X3,X4)
    | ~ esk15345_4(X1,X2,X3,X4) ) ).

cnf(i_0_4373,axiom,
    ( esk7619_4(X1,X2,X3,X4)
    | ~ esk7610_4(X1,X2,X3,X4) ) ).

cnf(i_0_4374,axiom,
    ( esk3110_4(X1,X2,X3,X4)
    | esk3087_4(X1,X2,X3,X4) ) ).

cnf(i_0_4375,axiom,
    ( esk9248_4(X1,X2,X3,X4)
    | ~ esk9506_4(X1,X2,X3,X4) ) ).

cnf(i_0_4376,axiom,
    ( esk15884_4(X1,X2,X3,X4)
    | esk15917_4(X1,X2,X3,X4) ) ).

cnf(i_0_4377,axiom,
    ( ~ esk11928_4(X1,X2,X3,X4)
    | esk11953_4(X1,X2,X3,X4) ) ).

cnf(i_0_4378,axiom,
    ( ~ esk3791_4(X1,X2,X3,X4)
    | esk3839_4(X1,X2,X3,X4) ) ).

cnf(i_0_4379,axiom,
    ( ~ esk1023_4(X1,X2,X3,X4)
    | ~ esk1077_4(X1,X2,X3,X4)
    | ~ esk1058_4(X1,X2,X3,X4) ) ).

cnf(i_0_4380,axiom,
    ( esk16110_4(X1,X2,X3,X4)
    | esk16111_4(X1,X2,X3,X4) ) ).

cnf(i_0_4381,axiom,
    ( ~ esk15600_4(X1,X2,X3,X4)
    | ~ esk15697_4(X1,X2,X3,X4) ) ).

cnf(i_0_4382,axiom,
    ( ~ esk2497_4(X1,X2,X3,X4)
    | esk2572_4(X1,X2,X3,X4) ) ).

cnf(i_0_4383,axiom,
    ( ~ esk7213_4(X1,X2,X3,X4)
    | esk7086_4(X1,X2,X3,X4)
    | esk7056_4(X1,X2,X3,X4) ) ).

cnf(i_0_4384,axiom,
    ( esk4828_4(X1,X2,X3,X4)
    | esk4826_4(X1,X2,X3,X4) ) ).

cnf(i_0_4385,axiom,
    ( esk11445_4(X1,X2,X3,X4)
    | ~ esk11542_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_4386,axiom,
    ( esk11824_4(X1,X2,X3,X4)
    | ~ esk11749_4(X1,X2,X3,X4) ) ).

cnf(i_0_4387,axiom,
    ( esk7748_4(X1,X2,X3,X4)
    | esk7693_4(X1,X2,X3,X4) ) ).

cnf(i_0_4388,axiom,
    ( esk15585_4(X1,X2,X3,X4)
    | ~ esk15579_4(X1,X2,X3,X4) ) ).

cnf(i_0_4389,axiom,
    ( esk14847_4(X1,X2,X3,X4)
    | esk14854_4(X1,X2,X3,X4) ) ).

cnf(i_0_4390,axiom,
    ( ~ esk5471_4(X1,X2,X3,X4)
    | ~ esk5348_4(X1,X2,X3,X4)
    | ~ esk5340_4(X1,X2,X3,X4) ) ).

cnf(i_0_4391,axiom,
    ( ~ esk14853_4(X1,X2,X3,X4)
    | ~ esk14849_4(X1,X2,X3,X4)
    | ~ esk14968_4(X1,X2,X3,X4) ) ).

cnf(i_0_4392,axiom,
    ( esk7641_4(X1,X2,X3,X4)
    | esk7673_4(X1,X2,X3,X4) ) ).

cnf(i_0_4393,axiom,
    ( esk3031_4(X1,X2,X3,X4)
    | esk3146_4(X1,X2,X3,X4) ) ).

cnf(i_0_4394,axiom,
    ( ~ esk9302_4(X1,X2,X3,X4)
    | ~ esk9281_4(X1,X2,X3,X4)
    | ~ esk9280_4(X1,X2,X3,X4) ) ).

cnf(i_0_4395,axiom,
    ( esk5848_4(X1,X2,X3,X4)
    | ~ esk5893_4(X1,X2,X3,X4) ) ).

cnf(i_0_4396,axiom,
    ( ~ esk4525_4(X1,X2,X3,X4)
    | ~ esk4530_4(X1,X2,X3,X4) ) ).

cnf(i_0_4397,axiom,
    ( ~ esk2093_4(X1,X2,X3,X4)
    | esk2119_4(X1,X2,X3,X4)
    | esk2094_4(X1,X2,X3,X4) ) ).

cnf(i_0_4398,axiom,
    ( esk13826_4(X1,X2,X3,X4)
    | esk13859_4(X1,X2,X3,X4) ) ).

cnf(i_0_4399,axiom,
    ( ~ esk13498_4(X1,X2,X3,X4)
    | esk13512_4(X1,X2,X3,X4) ) ).

cnf(i_0_4400,axiom,
    ( esk488_4(X1,X2,X3,X4)
    | esk521_4(X1,X2,X3,X4) ) ).

cnf(i_0_4401,axiom,
    ( esk760_4(X1,X2,X3,X4)
    | esk805_4(X1,X2,X3,X4) ) ).

cnf(i_0_4402,axiom,
    ( ~ esk10279_4(X1,X2,X3,X4)
    | esk10021_4(X1,X2,X3,X4) ) ).

cnf(i_0_4403,axiom,
    ( ~ esk6377_4(X1,X2,X3,X4)
    | ~ esk6378_4(X1,X2,X3,X4)
    | ~ esk6361_4(X1,X2,X3,X4) ) ).

cnf(i_0_4404,axiom,
    ( esk14833_4(X1,X2,X3,X4)
    | esk14876_4(X1,X2,X3,X4) ) ).

cnf(i_0_4405,axiom,
    ( ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15904_4(X1,X2,X3,X4)
    | ~ esk15937_4(X1,X2,X3,X4) ) ).

cnf(i_0_4406,axiom,
    ( ~ esk14282_4(X1,X2,X3,X4)
    | ~ esk14400_4(X1,X2,X3,X4) ) ).

cnf(i_0_4407,axiom,
    ( esk16692_4(X1,X2,X3,X4)
    | esk16739_4(X1,X2,X3,X4)
    | ~ esk16773_4(X1,X2,X3,X4) ) ).

cnf(i_0_4408,axiom,
    ( ~ esk10438_4(X1,X2,X3,X4)
    | esk10180_4(X1,X2,X3,X4) ) ).

cnf(i_0_4409,axiom,
    ( ~ esk6404_4(X1,X2,X3,X4)
    | ~ esk6464_4(X1,X2,X3,X4)
    | esk6449_4(X1,X2,X3,X4) ) ).

cnf(i_0_4410,axiom,
    ( ~ esk9180_4(X1,X2,X3,X4)
    | esk9252_4(X1,X2,X3,X4) ) ).

cnf(i_0_4411,axiom,
    ( esk11519_4(X1,X2,X3,X4)
    | esk11552_4(X1,X2,X3,X4) ) ).

cnf(i_0_4412,axiom,
    ( ~ esk16699_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | esk210_0
    | p(X4)
    | ~ p(X1) ) ).

cnf(i_0_4413,axiom,
    ( esk16408_4(X1,X2,X3,X4)
    | esk16441_4(X1,X2,X3,X4) ) ).

cnf(i_0_4414,axiom,
    ( ~ esk1452_4(X1,X2,X3,X4)
    | ~ esk1447_4(X1,X2,X3,X4) ) ).

cnf(i_0_4415,axiom,
    ( esk2670_4(X1,X2,X3,X4)
    | ~ esk2713_4(X1,X2,X3,X4) ) ).

cnf(i_0_4416,axiom,
    ( ~ esk6565_4(X1,X2,X3,X4)
    | esk6537_4(X1,X2,X3,X4) ) ).

cnf(i_0_4417,axiom,
    ( ~ esk4538_4(X1,X2,X3,X4)
    | esk4531_4(X1,X2,X3,X4)
    | esk4524_4(X1,X2,X3,X4) ) ).

cnf(i_0_4418,axiom,
    ( esk12469_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4)
    | ~ esk12592_4(X1,X2,X3,X4) ) ).

cnf(i_0_4419,axiom,
    ( ~ esk14780_4(X1,X2,X3,X4)
    | esk14797_4(X1,X2,X3,X4) ) ).

cnf(i_0_4420,axiom,
    ( ~ esk11809_4(X1,X2,X3,X4)
    | ~ esk11857_4(X1,X2,X3,X4) ) ).

cnf(i_0_4421,axiom,
    ( p(X1)
    | ~ p(X2)
    | ~ esk232_0
    | esk513_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X3) ) ).

cnf(i_0_4422,axiom,
    ( ~ esk4860_4(X1,X2,X3,X4)
    | ~ esk4774_4(X1,X2,X3,X4)
    | esk4763_4(X1,X2,X3,X4) ) ).

cnf(i_0_4423,axiom,
    ( esk8255_4(X1,X2,X3,X4)
    | esk8254_4(X1,X2,X3,X4) ) ).

cnf(i_0_4424,axiom,
    ( ~ esk14819_4(X1,X2,X3,X4)
    | esk14818_4(X1,X2,X3,X4) ) ).

cnf(i_0_4425,axiom,
    ( esk13414_4(X1,X2,X3,X4)
    | ~ esk13392_4(X1,X2,X3,X4)
    | esk13393_4(X1,X2,X3,X4) ) ).

cnf(i_0_4426,axiom,
    ( ~ esk4134_4(X1,X2,X3,X4)
    | esk4171_4(X1,X2,X3,X4) ) ).

cnf(i_0_4427,axiom,
    ( ~ esk14269_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4) ) ).

cnf(i_0_4428,axiom,
    ( esk7084_4(X1,X2,X3,X4)
    | ~ esk7085_4(X1,X2,X3,X4) ) ).

cnf(i_0_4429,axiom,
    ( esk12187_4(X1,X2,X3,X4)
    | ~ esk12208_4(X1,X2,X3,X4) ) ).

cnf(i_0_4430,axiom,
    ( esk1060_4(X1,X2,X3,X4)
    | esk1061_4(X1,X2,X3,X4)
    | esk1100_4(X1,X2,X3,X4)
    | esk1059_4(X1,X2,X3,X4) ) ).

cnf(i_0_4431,axiom,
    ( ~ esk3337_4(X1,X2,X3,X4)
    | esk3595_4(X1,X2,X3,X4) ) ).

cnf(i_0_4432,axiom,
    ( ~ esk12207_4(X1,X2,X3,X4)
    | esk12227_4(X1,X2,X3,X4) ) ).

cnf(i_0_4433,axiom,
    ( ~ esk2199_4(X1,X2,X3,X4)
    | esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_4434,axiom,
    ( esk455_4(X1,X2,X3,X4)
    | esk480_4(X1,X2,X3,X4) ) ).

cnf(i_0_4435,axiom,
    ( esk8531_4(X1,X2,X3,X4)
    | ~ esk8510_4(X1,X2,X3,X4)
    | esk8509_4(X1,X2,X3,X4) ) ).

cnf(i_0_4436,axiom,
    ( ~ esk977_4(X1,X2,X3,X4)
    | ~ esk966_4(X1,X2,X3,X4)
    | ~ esk976_4(X1,X2,X3,X4) ) ).

cnf(i_0_4437,axiom,
    ( esk5635_4(X1,X2,X3,X4)
    | esk5602_4(X1,X2,X3,X4) ) ).

cnf(i_0_4438,axiom,
    ( esk9660_4(X1,X2,X3,X4)
    | ~ esk9657_4(X1,X2,X3,X4) ) ).

cnf(i_0_4439,axiom,
    ( esk6622_4(X1,X2,X3,X4)
    | esk6627_4(X1,X2,X3,X4) ) ).

cnf(i_0_4440,axiom,
    ( ~ esk15151_4(X1,X2,X3,X4)
    | esk15097_4(X1,X2,X3,X4) ) ).

cnf(i_0_4441,axiom,
    ( esk15863_4(X1,X2,X3,X4)
    | esk15900_4(X1,X2,X3,X4) ) ).

cnf(i_0_4442,axiom,
    ( ~ esk1570_4(X1,X2,X3,X4)
    | ~ esk1539_4(X1,X2,X3,X4) ) ).

cnf(i_0_4443,axiom,
    ( ~ esk9702_4(X1,X2,X3,X4)
    | esk9750_4(X1,X2,X3,X4) ) ).

cnf(i_0_4444,axiom,
    ( esk3282_4(X1,X2,X3,X4)
    | esk3301_4(X1,X2,X3,X4) ) ).

cnf(i_0_4445,axiom,
    ( esk3886_4(X1,X2,X3,X4)
    | esk3878_4(X1,X2,X3,X4)
    | esk3887_4(X1,X2,X3,X4) ) ).

cnf(i_0_4446,axiom,
    ( ~ esk2224_4(X1,X2,X3,X4)
    | esk2226_4(X1,X2,X3,X4)
    | ~ esk2225_4(X1,X2,X3,X4) ) ).

cnf(i_0_4447,axiom,
    ( p(X4)
    | esk173_0
    | p(X1)
    | ~ esk505_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X3) ) ).

cnf(i_0_4448,axiom,
    ( ~ esk6602_4(X1,X2,X3,X4)
    | esk6598_4(X1,X2,X3,X4) ) ).

cnf(i_0_4449,axiom,
    ( ~ esk14146_4(X1,X2,X3,X4)
    | esk14144_4(X1,X2,X3,X4) ) ).

cnf(i_0_4450,axiom,
    ( ~ esk13316_4(X1,X2,X3,X4)
    | ~ esk13317_4(X1,X2,X3,X4)
    | ~ esk13300_4(X1,X2,X3,X4) ) ).

cnf(i_0_4451,axiom,
    ( esk9695_4(X1,X2,X3,X4)
    | esk9732_4(X1,X2,X3,X4) ) ).

cnf(i_0_4452,axiom,
    ( esk899_4(X1,X2,X3,X4)
    | ~ esk880_4(X1,X2,X3,X4) ) ).

cnf(i_0_4453,axiom,
    ( esk15958_4(X1,X2,X3,X4)
    | ~ esk15995_4(X1,X2,X3,X4)
    | esk15911_4(X1,X2,X3,X4) ) ).

cnf(i_0_4454,axiom,
    ( esk2064_4(X1,X2,X3,X4)
    | ~ esk2065_4(X1,X2,X3,X4)
    | esk2069_4(X1,X2,X3,X4) ) ).

cnf(i_0_4455,axiom,
    ( esk13553_4(X1,X2,X3,X4)
    | esk13582_4(X1,X2,X3,X4) ) ).

cnf(i_0_4456,axiom,
    ( ~ esk11251_4(X1,X2,X3,X4)
    | ~ esk11263_4(X1,X2,X3,X4)
    | ~ esk11377_4(X1,X2,X3,X4) ) ).

cnf(i_0_4457,axiom,
    ( esk1305_4(X1,X2,X3,X4)
    | ~ esk1047_4(X1,X2,X3,X4) ) ).

cnf(i_0_4458,axiom,
    ( esk1830_4(X1,X2,X3,X4)
    | esk1829_4(X1,X2,X3,X4) ) ).

cnf(i_0_4459,axiom,
    ( esk15174_4(X1,X2,X3,X4)
    | ~ esk15175_4(X1,X2,X3,X4) ) ).

cnf(i_0_4460,axiom,
    ( esk2847_4(X1,X2,X3,X4)
    | esk2848_4(X1,X2,X3,X4) ) ).

cnf(i_0_4461,axiom,
    ( ~ p(X2)
    | ~ esk165_0
    | p(X3)
    | ~ p(X4)
    | esk503_4(X1,X2,X3,X4)
    | ~ p(X1) ) ).

cnf(i_0_4462,axiom,
    ( esk699_4(X1,X2,X3,X4)
    | ~ esk771_4(X1,X2,X3,X4) ) ).

cnf(i_0_4463,axiom,
    ( esk16418_4(X1,X2,X3,X4)
    | esk16375_4(X1,X2,X3,X4) ) ).

cnf(i_0_4464,axiom,
    ( esk16287_4(X1,X2,X3,X4)
    | esk16340_4(X1,X2,X3,X4) ) ).

cnf(i_0_4465,axiom,
    ( ~ esk11992_4(X1,X2,X3,X4)
    | esk11990_4(X1,X2,X3,X4) ) ).

cnf(i_0_4466,axiom,
    ( esk11924_4(X1,X2,X3,X4)
    | ~ esk11957_4(X1,X2,X3,X4) ) ).

cnf(i_0_4467,axiom,
    ( ~ esk16358_4(X1,X2,X3,X4)
    | ~ esk16353_4(X1,X2,X3,X4) ) ).

cnf(i_0_4468,axiom,
    ( ~ esk10197_4(X1,X2,X3,X4)
    | esk10175_4(X1,X2,X3,X4) ) ).

cnf(i_0_4469,axiom,
    ( esk15646_4(X1,X2,X3,X4)
    | esk15605_4(X1,X2,X3,X4) ) ).

cnf(i_0_4470,axiom,
    ( ~ esk3744_4(X1,X2,X3,X4)
    | esk3724_4(X1,X2,X3,X4) ) ).

cnf(i_0_4471,axiom,
    ( esk6234_4(X1,X2,X3,X4)
    | esk6202_4(X1,X2,X3,X4) ) ).

cnf(i_0_4472,axiom,
    ( esk16103_4(X1,X2,X3,X4)
    | ~ esk16104_4(X1,X2,X3,X4) ) ).

cnf(i_0_4473,axiom,
    ( esk5940_4(X1,X2,X3,X4)
    | esk5938_4(X1,X2,X3,X4) ) ).

cnf(i_0_4474,axiom,
    ( esk3840_4(X1,X2,X3,X4)
    | esk3807_4(X1,X2,X3,X4) ) ).

cnf(i_0_4475,axiom,
    ( esk13886_4(X1,X2,X3,X4)
    | esk13768_4(X1,X2,X3,X4) ) ).

cnf(i_0_4476,axiom,
    ( esk15620_4(X1,X2,X3,X4)
    | esk15632_4(X1,X2,X3,X4) ) ).

cnf(i_0_4477,axiom,
    ( ~ esk14020_4(X1,X2,X3,X4)
    | esk14026_4(X1,X2,X3,X4) ) ).

cnf(i_0_4478,axiom,
    ( esk16471_4(X1,X2,X3,X4)
    | esk16489_4(X1,X2,X3,X4) ) ).

cnf(i_0_4479,axiom,
    ( ~ p(X1)
    | p(X3)
    | p(X2)
    | ~ p(X4)
    | esk266_0
    | ~ esk517_4(X1,X2,X3,X4) ) ).

cnf(i_0_4480,axiom,
    ( esk15717_4(X1,X2,X3,X4)
    | ~ esk15666_4(X1,X2,X3,X4)
    | esk15710_4(X1,X2,X3,X4) ) ).

cnf(i_0_4481,axiom,
    ( ~ esk4952_4(X1,X2,X3,X4)
    | esk4951_4(X1,X2,X3,X4) ) ).

cnf(i_0_4482,axiom,
    ( esk7709_4(X1,X2,X3,X4)
    | ~ esk7451_4(X1,X2,X3,X4) ) ).

cnf(i_0_4483,axiom,
    ( esk12258_4(X1,X2,X3,X4)
    | esk12349_4(X1,X2,X3,X4) ) ).

cnf(i_0_4484,axiom,
    ( ~ esk12886_4(X1,X2,X3,X4)
    | ~ esk12835_4(X1,X2,X3,X4)
    | ~ esk12921_4(X1,X2,X3,X4) ) ).

cnf(i_0_4485,axiom,
    ( esk10212_4(X1,X2,X3,X4)
    | esk10240_4(X1,X2,X3,X4) ) ).

cnf(i_0_4486,axiom,
    ( esk3327_4(X1,X2,X3,X4)
    | ~ esk3276_4(X1,X2,X3,X4) ) ).

cnf(i_0_4487,axiom,
    ( ~ esk8380_4(X1,X2,X3,X4)
    | ~ esk8379_4(X1,X2,X3,X4) ) ).

cnf(i_0_4488,axiom,
    ( ~ esk10535_4(X1,X2,X3,X4)
    | esk10466_4(X1,X2,X3,X4) ) ).

cnf(i_0_4489,axiom,
    ( ~ esk15039_4(X1,X2,X3,X4)
    | esk15162_4(X1,X2,X3,X4) ) ).

cnf(i_0_4490,axiom,
    ( ~ esk13646_4(X1,X2,X3,X4)
    | ~ esk13626_4(X1,X2,X3,X4)
    | ~ esk13628_4(X1,X2,X3,X4) ) ).

cnf(i_0_4491,axiom,
    ( ~ esk507_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X2)
    | p(X3)
    | p(X4)
    | esk190_0 ) ).

cnf(i_0_4492,axiom,
    ( esk5981_4(X1,X2,X3,X4)
    | esk5938_4(X1,X2,X3,X4) ) ).

cnf(i_0_4493,axiom,
    ( esk7587_4(X1,X2,X3,X4)
    | ~ esk7711_4(X1,X2,X3,X4)
    | ~ esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_4494,axiom,
    ( ~ esk6424_4(X1,X2,X3,X4)
    | esk6301_4(X1,X2,X3,X4)
    | ~ esk6316_4(X1,X2,X3,X4) ) ).

cnf(i_0_4495,axiom,
    ( ~ esk1955_4(X1,X2,X3,X4)
    | esk1967_4(X1,X2,X3,X4) ) ).

cnf(i_0_4496,axiom,
    ( esk9963_4(X1,X2,X3,X4)
    | esk9968_4(X1,X2,X3,X4) ) ).

cnf(i_0_4497,axiom,
    ( ~ esk11253_4(X1,X2,X3,X4)
    | ~ esk11369_4(X1,X2,X3,X4)
    | ~ esk11251_4(X1,X2,X3,X4) ) ).

cnf(i_0_4498,axiom,
    ( ~ esk5661_4(X1,X2,X3,X4)
    | esk5712_4(X1,X2,X3,X4) ) ).

cnf(i_0_4499,axiom,
    ( ~ esk6046_4(X1,X2,X3,X4)
    | esk6013_4(X1,X2,X3,X4) ) ).

cnf(i_0_4500,axiom,
    ( esk6869_4(X1,X2,X3,X4)
    | ~ esk6935_4(X1,X2,X3,X4) ) ).

cnf(i_0_4501,axiom,
    ( esk15375_4(X1,X2,X3,X4)
    | esk15355_4(X1,X2,X3,X4) ) ).

cnf(i_0_4502,axiom,
    ( esk9431_4(X1,X2,X3,X4)
    | esk9529_4(X1,X2,X3,X4) ) ).

cnf(i_0_4503,axiom,
    ( ~ esk1667_4(X1,X2,X3,X4)
    | ~ esk1820_4(X1,X2,X3,X4)
    | ~ esk1813_4(X1,X2,X3,X4) ) ).

cnf(i_0_4504,axiom,
    ( ~ esk13879_4(X1,X2,X3,X4)
    | ~ esk13877_4(X1,X2,X3,X4)
    | ~ esk13905_4(X1,X2,X3,X4)
    | ~ esk13907_4(X1,X2,X3,X4) ) ).

cnf(i_0_4505,axiom,
    ( esk14584_4(X1,X2,X3,X4)
    | ~ esk14635_4(X1,X2,X3,X4) ) ).

cnf(i_0_4506,axiom,
    ( ~ esk5345_4(X1,X2,X3,X4)
    | ~ esk5346_4(X1,X2,X3,X4)
    | ~ esk5335_4(X1,X2,X3,X4) ) ).

cnf(i_0_4507,axiom,
    ( esk6105_4(X1,X2,X3,X4)
    | ~ esk6150_4(X1,X2,X3,X4) ) ).

cnf(i_0_4508,axiom,
    ( ~ esk1287_4(X1,X2,X3,X4)
    | esk1212_4(X1,X2,X3,X4) ) ).

cnf(i_0_4509,axiom,
    ( p(X1)
    | p(X3)
    | ~ esk503_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4)
    | esk1_0 ) ).

cnf(i_0_4510,axiom,
    ( ~ p(X3)
    | ~ esk505_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X2)
    | ~ p(X4)
    | esk178_0 ) ).

cnf(i_0_4511,axiom,
    ( ~ esk14423_4(X1,X2,X3,X4)
    | ~ esk14425_4(X1,X2,X3,X4) ) ).

cnf(i_0_4512,axiom,
    ( esk13162_4(X1,X2,X3,X4)
    | ~ esk13132_4(X1,X2,X3,X4) ) ).

cnf(i_0_4513,axiom,
    ( ~ esk10423_4(X1,X2,X3,X4)
    | esk10380_4(X1,X2,X3,X4) ) ).

cnf(i_0_4514,axiom,
    ( ~ esk68_0
    | ~ p(X3)
    | p(X1)
    | p(X4)
    | ~ p(X2)
    | esk491_4(X1,X2,X3,X4) ) ).

cnf(i_0_4515,axiom,
    ( esk5597_4(X1,X2,X3,X4)
    | esk5623_4(X1,X2,X3,X4) ) ).

cnf(i_0_4516,axiom,
    ( esk6980_4(X1,X2,X3,X4)
    | esk6962_4(X1,X2,X3,X4) ) ).

cnf(i_0_4517,axiom,
    ( ~ esk15176_4(X1,X2,X3,X4)
    | ~ esk15087_4(X1,X2,X3,X4) ) ).

cnf(i_0_4518,axiom,
    ( esk15941_4(X1,X2,X3,X4)
    | esk15908_4(X1,X2,X3,X4) ) ).

cnf(i_0_4519,axiom,
    ( esk4256_4(X1,X2,X3,X4)
    | esk4311_4(X1,X2,X3,X4) ) ).

cnf(i_0_4520,axiom,
    ( ~ esk968_4(X1,X2,X3,X4)
    | esk1004_4(X1,X2,X3,X4) ) ).

cnf(i_0_4521,axiom,
    ( esk10717_4(X1,X2,X3,X4)
    | ~ esk10681_4(X1,X2,X3,X4) ) ).

cnf(i_0_4522,axiom,
    ( esk745_4(X1,X2,X3,X4)
    | esk778_4(X1,X2,X3,X4) ) ).

cnf(i_0_4523,axiom,
    ( ~ esk6970_4(X1,X2,X3,X4)
    | ~ esk6962_4(X1,X2,X3,X4) ) ).

cnf(i_0_4524,axiom,
    ( esk1548_4(X1,X2,X3,X4)
    | ~ esk1467_4(X1,X2,X3,X4) ) ).

cnf(i_0_4525,axiom,
    esk6056_4(X1,X2,X3,X4) ).

cnf(i_0_4526,axiom,
    ( ~ esk3764_4(X1,X2,X3,X4)
    | esk3762_4(X1,X2,X3,X4) ) ).

cnf(i_0_4527,axiom,
    ( ~ esk6603_4(X1,X2,X3,X4)
    | ~ esk6625_4(X1,X2,X3,X4) ) ).

cnf(i_0_4528,axiom,
    ( ~ esk9046_4(X1,X2,X3,X4)
    | esk9065_4(X1,X2,X3,X4)
    | esk8994_4(X1,X2,X3,X4) ) ).

cnf(i_0_4529,axiom,
    ( ~ esk7751_4(X1,X2,X3,X4)
    | ~ esk7733_4(X1,X2,X3,X4) ) ).

cnf(i_0_4530,axiom,
    ( esk15450_4(X1,X2,X3,X4)
    | esk15451_4(X1,X2,X3,X4) ) ).

cnf(i_0_4531,axiom,
    ( esk6617_4(X1,X2,X3,X4)
    | esk6636_4(X1,X2,X3,X4) ) ).

cnf(i_0_4532,axiom,
    ( ~ esk6170_4(X1,X2,X3,X4)
    | esk6095_4(X1,X2,X3,X4) ) ).

cnf(i_0_4533,axiom,
    ( esk2975_4(X1,X2,X3,X4)
    | ~ esk2963_4(X1,X2,X3,X4) ) ).

cnf(i_0_4534,axiom,
    ( ~ esk7486_4(X1,X2,X3,X4)
    | ~ esk7484_4(X1,X2,X3,X4) ) ).

cnf(i_0_4535,axiom,
    ( ~ esk16751_4(X1,X2,X3,X4)
    | esk16737_4(X1,X2,X3,X4)
    | esk16750_4(X1,X2,X3,X4) ) ).

cnf(i_0_4536,axiom,
    ( esk15550_4(X1,X2,X3,X4)
    | ~ esk15527_4(X1,X2,X3,X4) ) ).

cnf(i_0_4537,axiom,
    ( esk2188_4(X1,X2,X3,X4)
    | ~ esk2161_4(X1,X2,X3,X4) ) ).

cnf(i_0_4538,axiom,
    ( esk7485_4(X1,X2,X3,X4)
    | esk7476_4(X1,X2,X3,X4)
    | esk7484_4(X1,X2,X3,X4) ) ).

cnf(i_0_4539,axiom,
    ( ~ esk6120_4(X1,X2,X3,X4)
    | ~ esk6104_4(X1,X2,X3,X4)
    | ~ esk6121_4(X1,X2,X3,X4) ) ).

cnf(i_0_4540,axiom,
    ( ~ esk2491_4(X1,X2,X3,X4)
    | ~ esk2511_4(X1,X2,X3,X4) ) ).

cnf(i_0_4541,axiom,
    ( ~ esk8370_4(X1,X2,X3,X4)
    | esk8350_4(X1,X2,X3,X4) ) ).

cnf(i_0_4542,axiom,
    ( esk3322_4(X1,X2,X3,X4)
    | esk3378_4(X1,X2,X3,X4) ) ).

cnf(i_0_4543,axiom,
    ( ~ esk12486_4(X1,X2,X3,X4)
    | ~ esk12456_4(X1,X2,X3,X4) ) ).

cnf(i_0_4544,axiom,
    ( esk4040_4(X1,X2,X3,X4)
    | ~ esk4112_4(X1,X2,X3,X4) ) ).

cnf(i_0_4545,axiom,
    ( esk8422_4(X1,X2,X3,X4)
    | esk8425_4(X1,X2,X3,X4) ) ).

cnf(i_0_4546,axiom,
    ( ~ esk6703_4(X1,X2,X3,X4)
    | ~ esk6702_4(X1,X2,X3,X4) ) ).

cnf(i_0_4547,axiom,
    ( ~ esk1310_4(X1,X2,X3,X4)
    | esk1340_4(X1,X2,X3,X4) ) ).

cnf(i_0_4548,axiom,
    ( ~ esk15735_4(X1,X2,X3,X4)
    | ~ esk15736_4(X1,X2,X3,X4)
    | esk15737_4(X1,X2,X3,X4) ) ).

cnf(i_0_4549,axiom,
    ( esk2026_4(X1,X2,X3,X4)
    | esk2059_4(X1,X2,X3,X4) ) ).

cnf(i_0_4550,axiom,
    ( esk15698_4(X1,X2,X3,X4)
    | esk15697_4(X1,X2,X3,X4) ) ).

cnf(i_0_4551,axiom,
    ( ~ esk9893_4(X1,X2,X3,X4)
    | esk9945_4(X1,X2,X3,X4) ) ).

cnf(i_0_4552,axiom,
    ( ~ esk6432_4(X1,X2,X3,X4)
    | ~ esk6366_4(X1,X2,X3,X4)
    | ~ esk6399_4(X1,X2,X3,X4) ) ).

cnf(i_0_4553,axiom,
    ( esk6894_4(X1,X2,X3,X4)
    | esk6882_4(X1,X2,X3,X4) ) ).

cnf(i_0_4554,axiom,
    ( esk9171_4(X1,X2,X3,X4)
    | ~ esk9167_4(X1,X2,X3,X4)
    | esk9166_4(X1,X2,X3,X4) ) ).

cnf(i_0_4555,axiom,
    ( esk16139_4(X1,X2,X3,X4)
    | esk16172_4(X1,X2,X3,X4) ) ).

cnf(i_0_4556,axiom,
    ( esk15129_4(X1,X2,X3,X4)
    | esk15162_4(X1,X2,X3,X4) ) ).

cnf(i_0_4557,axiom,
    ( esk986_4(X1,X2,X3,X4)
    | esk1019_4(X1,X2,X3,X4) ) ).

cnf(i_0_4558,axiom,
    ( ~ esk5133_4(X1,X2,X3,X4)
    | esk5187_4(X1,X2,X3,X4) ) ).

cnf(i_0_4559,axiom,
    ( esk697_4(X1,X2,X3,X4)
    | ~ esk775_4(X1,X2,X3,X4) ) ).

cnf(i_0_4560,axiom,
    ( esk3041_4(X1,X2,X3,X4)
    | esk3018_4(X1,X2,X3,X4) ) ).

cnf(i_0_4561,axiom,
    ( ~ esk9454_4(X1,X2,X3,X4)
    | ~ esk9452_4(X1,X2,X3,X4)
    | ~ esk9570_4(X1,X2,X3,X4) ) ).

cnf(i_0_4562,axiom,
    ( ~ esk5517_4(X1,X2,X3,X4)
    | ~ esk5547_4(X1,X2,X3,X4) ) ).

cnf(i_0_4563,axiom,
    ( ~ esk8888_4(X1,X2,X3,X4)
    | ~ esk8860_4(X1,X2,X3,X4) ) ).

cnf(i_0_4564,axiom,
    ( esk15392_4(X1,X2,X3,X4)
    | esk15361_4(X1,X2,X3,X4) ) ).

cnf(i_0_4565,axiom,
    ( esk2330_4(X1,X2,X3,X4)
    | ~ esk2203_4(X1,X2,X3,X4) ) ).

cnf(i_0_4566,axiom,
    ( esk6716_4(X1,X2,X3,X4)
    | esk6671_4(X1,X2,X3,X4) ) ).

cnf(i_0_4567,axiom,
    ( ~ p(X4)
    | ~ p(X3)
    | ~ p(X1)
    | esk1_0
    | ~ p(X2)
    | ~ esk16703_4(X1,X2,X3,X4) ) ).

cnf(i_0_4568,axiom,
    ( p(X4)
    | esk517_4(X1,X2,X3,X4)
    | p(X3)
    | ~ esk265_0
    | ~ p(X1)
    | p(X2) ) ).

cnf(i_0_4569,axiom,
    ( esk10853_4(X1,X2,X3,X4)
    | ~ esk10854_4(X1,X2,X3,X4) ) ).

cnf(i_0_4570,axiom,
    ( ~ esk14540_4(X1,X2,X3,X4)
    | esk14530_4(X1,X2,X3,X4)
    | ~ esk14628_4(X1,X2,X3,X4) ) ).

cnf(i_0_4571,axiom,
    ( ~ esk5852_4(X1,X2,X3,X4)
    | ~ esk5881_4(X1,X2,X3,X4)
    | ~ esk5914_4(X1,X2,X3,X4) ) ).

cnf(i_0_4572,axiom,
    ( ~ esk14190_4(X1,X2,X3,X4)
    | ~ esk14189_4(X1,X2,X3,X4)
    | esk14191_4(X1,X2,X3,X4) ) ).

cnf(i_0_4573,axiom,
    ( ~ esk8974_4(X1,X2,X3,X4)
    | ~ esk9034_4(X1,X2,X3,X4)
    | ~ esk9057_4(X1,X2,X3,X4) ) ).

cnf(i_0_4574,axiom,
    ( esk14965_4(X1,X2,X3,X4)
    | ~ esk14928_4(X1,X2,X3,X4) ) ).

cnf(i_0_4575,axiom,
    ( esk8585_4(X1,X2,X3,X4)
    | ~ esk8614_4(X1,X2,X3,X4) ) ).

cnf(i_0_4576,axiom,
    ( ~ esk15429_4(X1,X2,X3,X4)
    | ~ esk15430_4(X1,X2,X3,X4)
    | esk15431_4(X1,X2,X3,X4) ) ).

cnf(i_0_4577,axiom,
    ( esk12647_4(X1,X2,X3,X4)
    | ~ esk12619_4(X1,X2,X3,X4) ) ).

cnf(i_0_4578,axiom,
    ( ~ esk2352_4(X1,X2,X3,X4)
    | ~ esk2351_4(X1,X2,X3,X4) ) ).

cnf(i_0_4579,axiom,
    ( esk13050_4(X1,X2,X3,X4)
    | esk13064_4(X1,X2,X3,X4) ) ).

cnf(i_0_4580,axiom,
    ( esk9915_4(X1,X2,X3,X4)
    | esk9862_4(X1,X2,X3,X4) ) ).

cnf(i_0_4581,axiom,
    ( esk3607_4(X1,X2,X3,X4)
    | ~ esk3609_4(X1,X2,X3,X4) ) ).

cnf(i_0_4582,axiom,
    ( esk1608_4(X1,X2,X3,X4)
    | esk1576_4(X1,X2,X3,X4) ) ).

cnf(i_0_4583,axiom,
    ( ~ esk10687_4(X1,X2,X3,X4)
    | ~ esk10657_4(X1,X2,X3,X4) ) ).

cnf(i_0_4584,axiom,
    ( esk6865_4(X1,X2,X3,X4)
    | esk6911_4(X1,X2,X3,X4) ) ).

cnf(i_0_4585,axiom,
    ( esk7241_4(X1,X2,X3,X4)
    | ~ esk7242_4(X1,X2,X3,X4)
    | esk7228_4(X1,X2,X3,X4) ) ).

cnf(i_0_4586,axiom,
    ( ~ p(X1)
    | ~ p(X2)
    | p(X3)
    | ~ esk509_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk210_0 ) ).

cnf(i_0_4587,axiom,
    ( ~ esk2455_4(X1,X2,X3,X4)
    | esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_4588,axiom,
    ( esk13349_4(X1,X2,X3,X4)
    | esk13402_4(X1,X2,X3,X4) ) ).

cnf(i_0_4589,axiom,
    ( esk9827_4(X1,X2,X3,X4)
    | ~ esk9743_4(X1,X2,X3,X4)
    | esk9790_4(X1,X2,X3,X4) ) ).

cnf(i_0_4590,axiom,
    ( ~ esk6843_4(X1,X2,X3,X4)
    | ~ esk6844_4(X1,X2,X3,X4) ) ).

cnf(i_0_4591,axiom,
    ( esk12277_4(X1,X2,X3,X4)
    | esk12292_4(X1,X2,X3,X4) ) ).

cnf(i_0_4592,axiom,
    ( ~ esk15618_4(X1,X2,X3,X4)
    | ~ esk15564_4(X1,X2,X3,X4) ) ).

cnf(i_0_4593,axiom,
    ( esk2980_4(X1,X2,X3,X4)
    | ~ esk2722_4(X1,X2,X3,X4) ) ).

cnf(i_0_4594,axiom,
    ( ~ esk1039_4(X1,X2,X3,X4)
    | esk1038_4(X1,X2,X3,X4) ) ).

cnf(i_0_4595,axiom,
    ( ~ esk16090_4(X1,X2,X3,X4)
    | ~ esk16089_4(X1,X2,X3,X4) ) ).

cnf(i_0_4596,axiom,
    ( esk531_4(X1,X2,X3,X4)
    | ~ esk532_4(X1,X2,X3,X4) ) ).

cnf(i_0_4597,axiom,
    ( ~ esk16224_4(X1,X2,X3,X4)
    | ~ esk16223_4(X1,X2,X3,X4) ) ).

cnf(i_0_4598,axiom,
    ( esk6341_4(X1,X2,X3,X4)
    | ~ esk6345_4(X1,X2,X3,X4) ) ).

cnf(i_0_4599,axiom,
    ( ~ esk14447_4(X1,X2,X3,X4)
    | esk14448_4(X1,X2,X3,X4)
    | ~ esk14446_4(X1,X2,X3,X4) ) ).

cnf(i_0_4600,axiom,
    ( esk15081_4(X1,X2,X3,X4)
    | ~ esk15083_4(X1,X2,X3,X4) ) ).

cnf(i_0_4601,axiom,
    ( esk12013_4(X1,X2,X3,X4)
    | esk12035_4(X1,X2,X3,X4) ) ).

cnf(i_0_4602,axiom,
    ( esk12991_4(X1,X2,X3,X4)
    | ~ esk12998_4(X1,X2,X3,X4)
    | ~ esk13092_4(X1,X2,X3,X4) ) ).

cnf(i_0_4603,axiom,
    ( esk8672_4(X1,X2,X3,X4)
    | esk8694_4(X1,X2,X3,X4) ) ).

cnf(i_0_4604,axiom,
    ( ~ esk15143_4(X1,X2,X3,X4)
    | esk15401_4(X1,X2,X3,X4) ) ).

cnf(i_0_4605,axiom,
    ( esk7007_4(X1,X2,X3,X4)
    | ~ esk7008_4(X1,X2,X3,X4) ) ).

cnf(i_0_4606,axiom,
    ( esk12091_4(X1,X2,X3,X4)
    | ~ esk12349_4(X1,X2,X3,X4) ) ).

cnf(i_0_4607,axiom,
    ( esk6683_4(X1,X2,X3,X4)
    | ~ esk6709_4(X1,X2,X3,X4)
    | esk6734_4(X1,X2,X3,X4) ) ).

cnf(i_0_4608,axiom,
    ( esk14579_4(X1,X2,X3,X4)
    | esk14614_4(X1,X2,X3,X4) ) ).

cnf(i_0_4609,axiom,
    ( esk10238_4(X1,X2,X3,X4)
    | esk10271_4(X1,X2,X3,X4) ) ).

cnf(i_0_4610,axiom,
    ( esk3749_4(X1,X2,X3,X4)
    | ~ esk3744_4(X1,X2,X3,X4) ) ).

cnf(i_0_4611,axiom,
    ( ~ esk13597_4(X1,X2,X3,X4)
    | esk13561_4(X1,X2,X3,X4) ) ).

cnf(i_0_4612,axiom,
    ( ~ esk4516_4(X1,X2,X3,X4)
    | ~ esk4518_4(X1,X2,X3,X4) ) ).

cnf(i_0_4613,axiom,
    ( esk6163_4(X1,X2,X3,X4)
    | ~ esk5905_4(X1,X2,X3,X4) ) ).

cnf(i_0_4614,axiom,
    ( esk11829_4(X1,X2,X3,X4)
    | esk11847_4(X1,X2,X3,X4) ) ).

cnf(i_0_4615,axiom,
    ( esk14126_4(X1,X2,X3,X4)
    | esk14093_4(X1,X2,X3,X4) ) ).

cnf(i_0_4616,axiom,
    ( ~ esk10715_4(X1,X2,X3,X4)
    | ~ esk10737_4(X1,X2,X3,X4) ) ).

cnf(i_0_4617,axiom,
    ( esk12026_4(X1,X2,X3,X4)
    | esk12018_4(X1,X2,X3,X4) ) ).

cnf(i_0_4618,axiom,
    ( ~ esk3894_4(X1,X2,X3,X4)
    | ~ esk3893_4(X1,X2,X3,X4) ) ).

cnf(i_0_4619,axiom,
    ( ~ esk6173_4(X1,X2,X3,X4)
    | esk5915_4(X1,X2,X3,X4) ) ).

cnf(i_0_4620,axiom,
    ( ~ esk16140_4(X1,X2,X3,X4)
    | ~ esk16139_4(X1,X2,X3,X4)
    | ~ esk16129_4(X1,X2,X3,X4) ) ).

cnf(i_0_4621,axiom,
    ( ~ esk5185_4(X1,X2,X3,X4)
    | ~ esk5171_4(X1,X2,X3,X4) ) ).

cnf(i_0_4622,axiom,
    ( esk4268_4(X1,X2,X3,X4)
    | ~ esk4280_4(X1,X2,X3,X4)
    | esk4279_4(X1,X2,X3,X4) ) ).

cnf(i_0_4623,axiom,
    ( ~ esk12922_4(X1,X2,X3,X4)
    | ~ esk12841_4(X1,X2,X3,X4) ) ).

cnf(i_0_4624,axiom,
    ( esk9629_4(X1,X2,X3,X4)
    | esk9607_4(X1,X2,X3,X4)
    | esk9632_4(X1,X2,X3,X4)
    | esk9659_4(X1,X2,X3,X4)
    | esk9631_4(X1,X2,X3,X4) ) ).

cnf(i_0_4625,axiom,
    ( esk10980_4(X1,X2,X3,X4)
    | esk11018_4(X1,X2,X3,X4) ) ).

cnf(i_0_4626,axiom,
    ( esk15568_4(X1,X2,X3,X4)
    | ~ esk15557_4(X1,X2,X3,X4) ) ).

cnf(i_0_4627,axiom,
    ( esk7253_4(X1,X2,X3,X4)
    | esk7201_4(X1,X2,X3,X4) ) ).

cnf(i_0_4628,axiom,
    ( esk14297_4(X1,X2,X3,X4)
    | esk14311_4(X1,X2,X3,X4) ) ).

cnf(i_0_4629,axiom,
    ( ~ p(X2)
    | ~ p(X1)
    | ~ p(X3)
    | esk137_0
    | ~ esk499_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_4630,axiom,
    ( ~ esk4314_4(X1,X2,X3,X4)
    | ~ esk4312_4(X1,X2,X3,X4)
    | ~ esk4430_4(X1,X2,X3,X4) ) ).

cnf(i_0_4631,axiom,
    ( ~ esk5433_4(X1,X2,X3,X4)
    | ~ esk5431_4(X1,X2,X3,X4) ) ).

cnf(i_0_4632,axiom,
    ( esk4954_4(X1,X2,X3,X4)
    | esk4947_4(X1,X2,X3,X4)
    | ~ esk4866_4(X1,X2,X3,X4) ) ).

cnf(i_0_4633,axiom,
    ( esk2224_4(X1,X2,X3,X4)
    | ~ esk2226_4(X1,X2,X3,X4) ) ).

cnf(i_0_4634,axiom,
    ( esk974_4(X1,X2,X3,X4)
    | esk1007_4(X1,X2,X3,X4) ) ).

cnf(i_0_4635,axiom,
    ( ~ esk16389_4(X1,X2,X3,X4)
    | ~ esk16404_4(X1,X2,X3,X4)
    | ~ esk16437_4(X1,X2,X3,X4) ) ).

cnf(i_0_4636,axiom,
    ( ~ esk7265_4(X1,X2,X3,X4)
    | ~ esk7139_4(X1,X2,X3,X4)
    | ~ esk7151_4(X1,X2,X3,X4) ) ).

cnf(i_0_4637,axiom,
    ( ~ esk14826_4(X1,X2,X3,X4)
    | esk14822_4(X1,X2,X3,X4) ) ).

cnf(i_0_4638,axiom,
    ( esk11432_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_4639,axiom,
    ( esk15388_4(X1,X2,X3,X4)
    | esk15421_4(X1,X2,X3,X4) ) ).

cnf(i_0_4640,axiom,
    ( ~ esk11976_4(X1,X2,X3,X4)
    | esk11992_4(X1,X2,X3,X4) ) ).

cnf(i_0_4641,axiom,
    ( ~ esk15233_4(X1,X2,X3,X4)
    | ~ esk15164_4(X1,X2,X3,X4)
    | ~ esk15190_4(X1,X2,X3,X4) ) ).

cnf(i_0_4642,axiom,
    ( esk5347_4(X1,X2,X3,X4)
    | esk5334_4(X1,X2,X3,X4) ) ).

cnf(i_0_4643,axiom,
    ( ~ esk14893_4(X1,X2,X3,X4)
    | esk14635_4(X1,X2,X3,X4) ) ).

cnf(i_0_4644,axiom,
    ( esk548_4(X1,X2,X3,X4)
    | esk503_4(X1,X2,X3,X4) ) ).

cnf(i_0_4645,axiom,
    ( esk14701_4(X1,X2,X3,X4)
    | ~ esk14650_4(X1,X2,X3,X4)
    | esk14676_4(X1,X2,X3,X4) ) ).

cnf(i_0_4646,axiom,
    ( ~ p(X2)
    | ~ esk99_0
    | esk495_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X1)
    | ~ p(X3) ) ).

cnf(i_0_4647,axiom,
    ( esk2613_4(X1,X2,X3,X4)
    | ~ esk2593_4(X1,X2,X3,X4) ) ).

cnf(i_0_4648,axiom,
    ( p(X4)
    | p(X2)
    | ~ esk94_0
    | p(X1)
    | esk495_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_4649,axiom,
    ( ~ esk3339_4(X1,X2,X3,X4)
    | esk3597_4(X1,X2,X3,X4) ) ).

cnf(i_0_4650,axiom,
    ( ~ esk14590_4(X1,X2,X3,X4)
    | ~ esk14613_4(X1,X2,X3,X4)
    | ~ esk14646_4(X1,X2,X3,X4) ) ).

cnf(i_0_4651,axiom,
    ( esk13774_4(X1,X2,X3,X4)
    | ~ esk13516_4(X1,X2,X3,X4) ) ).

cnf(i_0_4652,axiom,
    ( esk4979_4(X1,X2,X3,X4)
    | esk5032_4(X1,X2,X3,X4) ) ).

cnf(i_0_4653,axiom,
    ( esk3920_4(X1,X2,X3,X4)
    | esk3891_4(X1,X2,X3,X4)
    | ~ esk3840_4(X1,X2,X3,X4) ) ).

cnf(i_0_4654,axiom,
    ( esk12651_4(X1,X2,X3,X4)
    | ~ esk12650_4(X1,X2,X3,X4) ) ).

cnf(i_0_4655,axiom,
    ( esk2735_4(X1,X2,X3,X4)
    | ~ esk2731_4(X1,X2,X3,X4) ) ).

cnf(i_0_4656,axiom,
    ( ~ esk14536_4(X1,X2,X3,X4)
    | ~ esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_4657,axiom,
    ( ~ esk8000_4(X1,X2,X3,X4)
    | ~ esk7998_4(X1,X2,X3,X4) ) ).

cnf(i_0_4658,axiom,
    ( esk16213_4(X1,X2,X3,X4)
    | esk16166_4(X1,X2,X3,X4) ) ).

cnf(i_0_4659,axiom,
    ( esk4569_4(X1,X2,X3,X4)
    | esk4571_4(X1,X2,X3,X4) ) ).

cnf(i_0_4660,axiom,
    ( ~ esk4606_4(X1,X2,X3,X4)
    | esk4864_4(X1,X2,X3,X4) ) ).

cnf(i_0_4661,axiom,
    ( ~ esk521_4(X1,X2,X3,X4)
    | esk400_4(X1,X2,X3,X4)
    | ~ esk405_4(X1,X2,X3,X4) ) ).

cnf(i_0_4662,axiom,
    ( esk4957_4(X1,X2,X3,X4)
    | esk4947_4(X1,X2,X3,X4) ) ).

cnf(i_0_4663,axiom,
    ( p(X1)
    | ~ p(X2)
    | esk53_0
    | ~ esk16623_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X4) ) ).

cnf(i_0_4664,axiom,
    ( esk15329_4(X1,X2,X3,X4)
    | ~ esk15320_4(X1,X2,X3,X4) ) ).

cnf(i_0_4665,axiom,
    ( esk8028_4(X1,X2,X3,X4)
    | ~ esk7991_4(X1,X2,X3,X4)
    | esk7944_4(X1,X2,X3,X4) ) ).

cnf(i_0_4666,axiom,
    ( esk6333_4(X1,X2,X3,X4)
    | ~ esk6334_4(X1,X2,X3,X4) ) ).

cnf(i_0_4667,axiom,
    ( esk6604_4(X1,X2,X3,X4)
    | esk6695_4(X1,X2,X3,X4) ) ).

cnf(i_0_4668,axiom,
    ( esk4274_4(X1,X2,X3,X4)
    | esk4279_4(X1,X2,X3,X4) ) ).

cnf(i_0_4669,axiom,
    ( esk14318_4(X1,X2,X3,X4)
    | esk14364_4(X1,X2,X3,X4) ) ).

cnf(i_0_4670,axiom,
    ( ~ esk888_4(X1,X2,X3,X4)
    | esk1045_4(X1,X2,X3,X4) ) ).

cnf(i_0_4671,axiom,
    ( ~ esk15879_4(X1,X2,X3,X4)
    | ~ esk15874_4(X1,X2,X3,X4)
    | ~ esk15878_4(X1,X2,X3,X4) ) ).

cnf(i_0_4672,axiom,
    ( esk14547_4(X1,X2,X3,X4)
    | esk14554_4(X1,X2,X3,X4)
    | ~ esk14561_4(X1,X2,X3,X4) ) ).

cnf(i_0_4673,axiom,
    ( ~ esk15662_4(X1,X2,X3,X4)
    | ~ esk15618_4(X1,X2,X3,X4)
    | ~ esk15629_4(X1,X2,X3,X4) ) ).

cnf(i_0_4674,axiom,
    ( ~ esk748_4(X1,X2,X3,X4)
    | ~ esk795_4(X1,X2,X3,X4)
    | ~ esk832_4(X1,X2,X3,X4) ) ).

cnf(i_0_4675,axiom,
    ( ~ esk12754_4(X1,X2,X3,X4)
    | ~ esk12756_4(X1,X2,X3,X4) ) ).

cnf(i_0_4676,axiom,
    ( ~ esk4808_4(X1,X2,X3,X4)
    | esk4889_4(X1,X2,X3,X4) ) ).

cnf(i_0_4677,axiom,
    ( ~ esk1786_4(X1,X2,X3,X4)
    | esk1684_4(X1,X2,X3,X4)
    | ~ esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_4678,axiom,
    ( ~ esk2254_4(X1,X2,X3,X4)
    | ~ esk2259_4(X1,X2,X3,X4)
    | ~ esk2292_4(X1,X2,X3,X4) ) ).

cnf(i_0_4679,axiom,
    ( ~ esk3404_4(X1,X2,X3,X4)
    | ~ esk3290_4(X1,X2,X3,X4)
    | ~ esk3284_4(X1,X2,X3,X4) ) ).

cnf(i_0_4680,axiom,
    ( ~ esk565_4(X1,X2,X3,X4)
    | ~ esk584_4(X1,X2,X3,X4)
    | ~ esk513_4(X1,X2,X3,X4) ) ).

cnf(i_0_4681,axiom,
    ( esk8439_4(X1,X2,X3,X4)
    | esk8472_4(X1,X2,X3,X4) ) ).

cnf(i_0_4682,axiom,
    ( esk11312_4(X1,X2,X3,X4)
    | ~ esk11234_4(X1,X2,X3,X4) ) ).

cnf(i_0_4683,axiom,
    ( esk11692_4(X1,X2,X3,X4)
    | ~ esk11744_4(X1,X2,X3,X4) ) ).

cnf(i_0_4684,axiom,
    ( ~ esk2617_4(X1,X2,X3,X4)
    | esk2563_4(X1,X2,X3,X4)
    | esk2601_4(X1,X2,X3,X4) ) ).

cnf(i_0_4685,axiom,
    ( esk12899_4(X1,X2,X3,X4)
    | esk12813_4(X1,X2,X3,X4) ) ).

cnf(i_0_4686,axiom,
    ( esk3819_4(X1,X2,X3,X4)
    | esk3785_4(X1,X2,X3,X4) ) ).

cnf(i_0_4687,axiom,
    ( ~ esk7878_4(X1,X2,X3,X4)
    | esk7880_4(X1,X2,X3,X4)
    | ~ esk7879_4(X1,X2,X3,X4) ) ).

cnf(i_0_4688,axiom,
    ( esk3872_4(X1,X2,X3,X4)
    | ~ esk3873_4(X1,X2,X3,X4) ) ).

cnf(i_0_4689,axiom,
    ( esk5648_4(X1,X2,X3,X4)
    | ~ esk5585_4(X1,X2,X3,X4) ) ).

cnf(i_0_4690,axiom,
    ( ~ esk13880_4(X1,X2,X3,X4)
    | esk14138_4(X1,X2,X3,X4) ) ).

cnf(i_0_4691,axiom,
    ( ~ esk12489_4(X1,X2,X3,X4)
    | ~ esk12498_4(X1,X2,X3,X4)
    | ~ esk12512_4(X1,X2,X3,X4) ) ).

cnf(i_0_4692,axiom,
    ( ~ esk5178_4(X1,X2,X3,X4)
    | ~ esk5179_4(X1,X2,X3,X4) ) ).

cnf(i_0_4693,axiom,
    ( ~ esk12006_4(X1,X2,X3,X4)
    | ~ esk12049_4(X1,X2,X3,X4)
    | ~ esk12050_4(X1,X2,X3,X4) ) ).

cnf(i_0_4694,axiom,
    ( esk9966_4(X1,X2,X3,X4)
    | esk9992_4(X1,X2,X3,X4) ) ).

cnf(i_0_4695,axiom,
    ( esk14804_4(X1,X2,X3,X4)
    | esk14805_4(X1,X2,X3,X4) ) ).

cnf(i_0_4696,axiom,
    ( ~ esk14043_4(X1,X2,X3,X4)
    | ~ esk14042_4(X1,X2,X3,X4)
    | esk14044_4(X1,X2,X3,X4) ) ).

cnf(i_0_4697,axiom,
    ( esk9261_4(X1,X2,X3,X4)
    | ~ esk9265_4(X1,X2,X3,X4) ) ).

cnf(i_0_4698,axiom,
    ( esk12999_4(X1,X2,X3,X4)
    | esk12949_4(X1,X2,X3,X4) ) ).

cnf(i_0_4699,axiom,
    ( ~ esk10526_4(X1,X2,X3,X4)
    | esk10268_4(X1,X2,X3,X4) ) ).

cnf(i_0_4700,axiom,
    ( esk10094_4(X1,X2,X3,X4)
    | ~ esk10006_4(X1,X2,X3,X4)
    | esk10087_4(X1,X2,X3,X4) ) ).

cnf(i_0_4701,axiom,
    ( ~ esk15993_4(X1,X2,X3,X4)
    | ~ esk15992_4(X1,X2,X3,X4)
    | esk15994_4(X1,X2,X3,X4) ) ).

cnf(i_0_4702,axiom,
    ( esk11333_4(X1,X2,X3,X4)
    | ~ esk11363_4(X1,X2,X3,X4)
    | esk11311_4(X1,X2,X3,X4) ) ).

cnf(i_0_4703,axiom,
    ( esk3123_4(X1,X2,X3,X4)
    | esk3122_4(X1,X2,X3,X4)
    | esk3121_4(X1,X2,X3,X4) ) ).

cnf(i_0_4704,axiom,
    ( esk3068_4(X1,X2,X3,X4)
    | ~ esk3326_4(X1,X2,X3,X4) ) ).

cnf(i_0_4705,axiom,
    ( ~ esk15265_4(X1,X2,X3,X4)
    | esk15298_4(X1,X2,X3,X4) ) ).

cnf(i_0_4706,axiom,
    ( ~ esk3237_4(X1,X2,X3,X4)
    | ~ esk3260_4(X1,X2,X3,X4)
    | ~ esk3246_4(X1,X2,X3,X4) ) ).

cnf(i_0_4707,axiom,
    ( ~ esk730_4(X1,X2,X3,X4)
    | ~ esk729_4(X1,X2,X3,X4)
    | ~ esk704_4(X1,X2,X3,X4) ) ).

cnf(i_0_4708,axiom,
    ( esk2976_4(X1,X2,X3,X4)
    | esk2923_4(X1,X2,X3,X4) ) ).

cnf(i_0_4709,axiom,
    ( ~ esk12059_4(X1,X2,X3,X4)
    | esk12017_4(X1,X2,X3,X4) ) ).

cnf(i_0_4710,axiom,
    ( esk680_4(X1,X2,X3,X4)
    | ~ esk671_4(X1,X2,X3,X4) ) ).

cnf(i_0_4711,axiom,
    ( esk7219_4(X1,X2,X3,X4)
    | ~ esk7239_4(X1,X2,X3,X4)
    | esk7268_4(X1,X2,X3,X4) ) ).

cnf(i_0_4712,axiom,
    ( ~ esk12329_4(X1,X2,X3,X4)
    | ~ esk12227_4(X1,X2,X3,X4)
    | esk12209_4(X1,X2,X3,X4) ) ).

cnf(i_0_4713,axiom,
    ( esk8453_4(X1,X2,X3,X4)
    | esk8407_4(X1,X2,X3,X4) ) ).

cnf(i_0_4714,axiom,
    ( esk3488_4(X1,X2,X3,X4)
    | ~ esk3615_4(X1,X2,X3,X4)
    | esk3458_4(X1,X2,X3,X4) ) ).

cnf(i_0_4715,axiom,
    ( ~ esk7199_4(X1,X2,X3,X4)
    | esk7251_4(X1,X2,X3,X4) ) ).

cnf(i_0_4716,axiom,
    ( ~ esk12855_4(X1,X2,X3,X4)
    | ~ esk12741_4(X1,X2,X3,X4)
    | esk12729_4(X1,X2,X3,X4) ) ).

cnf(i_0_4717,axiom,
    ( ~ esk15671_4(X1,X2,X3,X4)
    | esk15608_4(X1,X2,X3,X4) ) ).

cnf(i_0_4718,axiom,
    ( esk2741_4(X1,X2,X3,X4)
    | esk2723_4(X1,X2,X3,X4) ) ).

cnf(i_0_4719,axiom,
    ( esk2595_4(X1,X2,X3,X4)
    | esk2575_4(X1,X2,X3,X4) ) ).

cnf(i_0_4720,axiom,
    ( ~ esk4525_4(X1,X2,X3,X4)
    | ~ esk4529_4(X1,X2,X3,X4) ) ).

cnf(i_0_4721,axiom,
    ( ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14118_4(X1,X2,X3,X4)
    | ~ esk14085_4(X1,X2,X3,X4) ) ).

cnf(i_0_4722,axiom,
    ( ~ esk9533_4(X1,X2,X3,X4)
    | ~ esk9486_4(X1,X2,X3,X4)
    | ~ esk9570_4(X1,X2,X3,X4) ) ).

cnf(i_0_4723,axiom,
    ( ~ esk15319_4(X1,X2,X3,X4)
    | ~ esk15324_4(X1,X2,X3,X4) ) ).

cnf(i_0_4724,axiom,
    ( esk9814_4(X1,X2,X3,X4)
    | esk9727_4(X1,X2,X3,X4) ) ).

cnf(i_0_4725,axiom,
    ( esk4934_4(X1,X2,X3,X4)
    | ~ esk4953_4(X1,X2,X3,X4)
    | esk4882_4(X1,X2,X3,X4) ) ).

cnf(i_0_4726,axiom,
    ( ~ p(X2)
    | p(X4)
    | ~ esk412_4(X1,X2,X3,X4)
    | esk31_0
    | ~ p(X1)
    | ~ p(X3) ) ).

cnf(i_0_4727,axiom,
    ( ~ esk7993_4(X1,X2,X3,X4)
    | ~ esk7970_4(X1,X2,X3,X4) ) ).

cnf(i_0_4728,axiom,
    ( esk16079_4(X1,X2,X3,X4)
    | ~ esk16080_4(X1,X2,X3,X4) ) ).

cnf(i_0_4729,axiom,
    ( esk10301_4(X1,X2,X3,X4)
    | esk10300_4(X1,X2,X3,X4) ) ).

cnf(i_0_4730,axiom,
    ( esk9400_4(X1,X2,X3,X4)
    | ~ esk9383_4(X1,X2,X3,X4) ) ).

cnf(i_0_4731,axiom,
    ( esk10351_4(X1,X2,X3,X4)
    | ~ esk10344_4(X1,X2,X3,X4)
    | esk10263_4(X1,X2,X3,X4) ) ).

cnf(i_0_4732,axiom,
    ( ~ esk653_4(X1,X2,X3,X4)
    | esk752_4(X1,X2,X3,X4) ) ).

cnf(i_0_4733,axiom,
    ( esk4099_4(X1,X2,X3,X4)
    | esk4066_4(X1,X2,X3,X4) ) ).

cnf(i_0_4734,axiom,
    ( ~ esk8429_4(X1,X2,X3,X4)
    | ~ esk8419_4(X1,X2,X3,X4)
    | ~ esk8430_4(X1,X2,X3,X4) ) ).

cnf(i_0_4735,axiom,
    ( esk11825_4(X1,X2,X3,X4)
    | esk11848_4(X1,X2,X3,X4) ) ).

cnf(i_0_4736,axiom,
    ( ~ esk10041_4(X1,X2,X3,X4)
    | esk10042_4(X1,X2,X3,X4) ) ).

cnf(i_0_4737,axiom,
    ( esk10859_4(X1,X2,X3,X4)
    | esk10747_4(X1,X2,X3,X4) ) ).

cnf(i_0_4738,axiom,
    ( ~ esk6950_4(X1,X2,X3,X4)
    | esk6951_4(X1,X2,X3,X4) ) ).

cnf(i_0_4739,axiom,
    ( ~ esk13423_4(X1,X2,X3,X4)
    | esk13424_4(X1,X2,X3,X4)
    | ~ esk13422_4(X1,X2,X3,X4) ) ).

cnf(i_0_4740,axiom,
    ( esk5859_4(X1,X2,X3,X4)
    | esk5849_4(X1,X2,X3,X4) ) ).

cnf(i_0_4741,axiom,
    ( ~ p(X1)
    | p(X3)
    | ~ p(X4)
    | esk499_4(X1,X2,X3,X4)
    | p(X2)
    | ~ esk131_0 ) ).

cnf(i_0_4742,axiom,
    ( esk3030_4(X1,X2,X3,X4)
    | esk3063_4(X1,X2,X3,X4) ) ).

cnf(i_0_4743,axiom,
    ( esk3760_4(X1,X2,X3,X4)
    | esk3751_4(X1,X2,X3,X4) ) ).

cnf(i_0_4744,axiom,
    ( esk4276_4(X1,X2,X3,X4)
    | ~ esk4278_4(X1,X2,X3,X4) ) ).

cnf(i_0_4745,axiom,
    ( ~ esk13567_4(X1,X2,X3,X4)
    | ~ esk13562_4(X1,X2,X3,X4)
    | ~ esk13600_4(X1,X2,X3,X4) ) ).

cnf(i_0_4746,axiom,
    ( esk6634_4(X1,X2,X3,X4)
    | esk6623_4(X1,X2,X3,X4) ) ).

cnf(i_0_4747,axiom,
    ( ~ esk7619_4(X1,X2,X3,X4)
    | esk7618_4(X1,X2,X3,X4) ) ).

cnf(i_0_4748,axiom,
    ( esk1329_4(X1,X2,X3,X4)
    | esk1244_4(X1,X2,X3,X4) ) ).

cnf(i_0_4749,axiom,
    ( ~ esk10014_4(X1,X2,X3,X4)
    | esk9756_4(X1,X2,X3,X4) ) ).

cnf(i_0_4750,axiom,
    ( ~ esk15739_4(X1,X2,X3,X4)
    | ~ esk15656_4(X1,X2,X3,X4)
    | ~ esk15716_4(X1,X2,X3,X4) ) ).

cnf(i_0_4751,axiom,
    ( esk12365_4(X1,X2,X3,X4)
    | esk12335_4(X1,X2,X3,X4) ) ).

cnf(i_0_4752,axiom,
    ( ~ esk11500_4(X1,X2,X3,X4)
    | ~ esk11520_4(X1,X2,X3,X4)
    | ~ esk11519_4(X1,X2,X3,X4) ) ).

cnf(i_0_4753,axiom,
    ( esk7937_4(X1,X2,X3,X4)
    | esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_4754,axiom,
    ( ~ esk15361_4(X1,X2,X3,X4)
    | ~ esk15341_4(X1,X2,X3,X4) ) ).

cnf(i_0_4755,axiom,
    ( esk313_0
    | p(X2)
    | ~ p(X3)
    | p(X4)
    | ~ esk16717_4(X1,X2,X3,X4)
    | ~ p(X1) ) ).

cnf(i_0_4756,axiom,
    ( esk2347_4(X1,X2,X3,X4)
    | esk2346_4(X1,X2,X3,X4) ) ).

cnf(i_0_4757,axiom,
    ( esk1804_4(X1,X2,X3,X4)
    | esk1856_4(X1,X2,X3,X4) ) ).

cnf(i_0_4758,axiom,
    ( esk15947_4(X1,X2,X3,X4)
    | ~ esk15943_4(X1,X2,X3,X4)
    | esk15942_4(X1,X2,X3,X4) ) ).

cnf(i_0_4759,axiom,
    ( ~ esk3013_4(X1,X2,X3,X4)
    | ~ esk3051_4(X1,X2,X3,X4)
    | ~ esk3050_4(X1,X2,X3,X4) ) ).

cnf(i_0_4760,axiom,
    ( ~ esk12798_4(X1,X2,X3,X4)
    | ~ esk12788_4(X1,X2,X3,X4)
    | ~ esk12799_4(X1,X2,X3,X4) ) ).

cnf(i_0_4761,axiom,
    ( ~ esk14538_4(X1,X2,X3,X4)
    | esk14537_4(X1,X2,X3,X4) ) ).

cnf(i_0_4762,axiom,
    ( esk15387_4(X1,X2,X3,X4)
    | esk15493_4(X1,X2,X3,X4) ) ).

cnf(i_0_4763,axiom,
    ( esk15564_4(X1,X2,X3,X4)
    | esk15619_4(X1,X2,X3,X4) ) ).

cnf(i_0_4764,axiom,
    ( esk2632_4(X1,X2,X3,X4)
    | ~ esk2609_4(X1,X2,X3,X4)
    | esk2549_4(X1,X2,X3,X4) ) ).

cnf(i_0_4765,axiom,
    ( esk10904_4(X1,X2,X3,X4)
    | ~ esk10936_4(X1,X2,X3,X4) ) ).

cnf(i_0_4766,axiom,
    ( esk2256_4(X1,X2,X3,X4)
    | esk2280_4(X1,X2,X3,X4) ) ).

cnf(i_0_4767,axiom,
    ( esk1497_4(X1,X2,X3,X4)
    | esk1477_4(X1,X2,X3,X4) ) ).

cnf(i_0_4768,axiom,
    ( esk12383_4(X1,X2,X3,X4)
    | ~ esk12367_4(X1,X2,X3,X4) ) ).

cnf(i_0_4769,axiom,
    ( esk10899_4(X1,X2,X3,X4)
    | ~ esk10926_4(X1,X2,X3,X4) ) ).

cnf(i_0_4770,axiom,
    ( ~ esk3070_4(X1,X2,X3,X4)
    | esk3328_4(X1,X2,X3,X4) ) ).

cnf(i_0_4771,axiom,
    ( esk6091_4(X1,X2,X3,X4)
    | ~ esk6055_4(X1,X2,X3,X4) ) ).

cnf(i_0_4772,axiom,
    ( ~ esk3319_4(X1,X2,X3,X4)
    | esk3577_4(X1,X2,X3,X4) ) ).

cnf(i_0_4773,axiom,
    ( ~ esk6717_4(X1,X2,X3,X4)
    | esk6749_4(X1,X2,X3,X4) ) ).

cnf(i_0_4774,axiom,
    ( ~ esk6433_4(X1,X2,X3,X4)
    | esk6434_4(X1,X2,X3,X4) ) ).

cnf(i_0_4775,axiom,
    ( esk2718_4(X1,X2,X3,X4)
    | ~ esk2700_4(X1,X2,X3,X4) ) ).

cnf(i_0_4776,axiom,
    ( esk5174_4(X1,X2,X3,X4)
    | esk5173_4(X1,X2,X3,X4) ) ).

cnf(i_0_4777,axiom,
    ( ~ esk4124_4(X1,X2,X3,X4)
    | esk4382_4(X1,X2,X3,X4) ) ).

cnf(i_0_4778,axiom,
    ( esk7918_4(X1,X2,X3,X4)
    | esk7904_4(X1,X2,X3,X4) ) ).

cnf(i_0_4779,axiom,
    ( ~ esk5179_4(X1,X2,X3,X4)
    | ~ esk5177_4(X1,X2,X3,X4) ) ).

cnf(i_0_4780,axiom,
    esk4000_4(X1,X2,X3,X4) ).

cnf(i_0_4781,axiom,
    ( esk10185_4(X1,X2,X3,X4)
    | esk10184_4(X1,X2,X3,X4)
    | esk10179_4(X1,X2,X3,X4) ) ).

cnf(i_0_4782,axiom,
    ( ~ esk492_4(X1,X2,X3,X4)
    | esk453_4(X1,X2,X3,X4) ) ).

cnf(i_0_4783,axiom,
    ( esk1645_4(X1,X2,X3,X4)
    | ~ esk1676_4(X1,X2,X3,X4) ) ).

cnf(i_0_4784,axiom,
    ( ~ esk7366_4(X1,X2,X3,X4)
    | esk7350_4(X1,X2,X3,X4) ) ).

cnf(i_0_4785,axiom,
    ( ~ esk750_4(X1,X2,X3,X4)
    | ~ esk833_4(X1,X2,X3,X4)
    | ~ esk810_4(X1,X2,X3,X4) ) ).

cnf(i_0_4786,axiom,
    ( ~ esk12732_4(X1,X2,X3,X4)
    | esk12706_4(X1,X2,X3,X4) ) ).

cnf(i_0_4787,axiom,
    ( ~ esk1017_4(X1,X2,X3,X4)
    | ~ esk1062_4(X1,X2,X3,X4)
    | ~ esk1061_4(X1,X2,X3,X4) ) ).

cnf(i_0_4788,axiom,
    ( esk795_4(X1,X2,X3,X4)
    | ~ esk748_4(X1,X2,X3,X4)
    | esk832_4(X1,X2,X3,X4) ) ).

cnf(i_0_4789,axiom,
    ( ~ esk1416_4(X1,X2,X3,X4)
    | esk1391_4(X1,X2,X3,X4) ) ).

cnf(i_0_4790,axiom,
    ( ~ esk11550_4(X1,X2,X3,X4)
    | ~ esk11548_4(X1,X2,X3,X4)
    | ~ esk11603_4(X1,X2,X3,X4)
    | ~ esk11601_4(X1,X2,X3,X4) ) ).

cnf(i_0_4791,axiom,
    ( esk452_4(X1,X2,X3,X4)
    | ~ esk494_4(X1,X2,X3,X4) ) ).

cnf(i_0_4792,axiom,
    ( ~ esk10687_4(X1,X2,X3,X4)
    | ~ esk10660_4(X1,X2,X3,X4) ) ).

cnf(i_0_4793,axiom,
    ( ~ esk1831_4(X1,X2,X3,X4)
    | esk1845_4(X1,X2,X3,X4) ) ).

cnf(i_0_4794,axiom,
    ( ~ esk9036_4(X1,X2,X3,X4)
    | esk9037_4(X1,X2,X3,X4) ) ).

cnf(i_0_4795,axiom,
    ( ~ esk4809_4(X1,X2,X3,X4)
    | ~ esk4856_4(X1,X2,X3,X4)
    | ~ esk4855_4(X1,X2,X3,X4) ) ).

cnf(i_0_4796,axiom,
    ( ~ esk14335_4(X1,X2,X3,X4)
    | ~ esk14361_4(X1,X2,X3,X4)
    | ~ esk14444_4(X1,X2,X3,X4) ) ).

cnf(i_0_4797,axiom,
    ( ~ esk14631_4(X1,X2,X3,X4)
    | esk14889_4(X1,X2,X3,X4) ) ).

cnf(i_0_4798,axiom,
    ( ~ esk7715_4(X1,X2,X3,X4)
    | esk7457_4(X1,X2,X3,X4) ) ).

cnf(i_0_4799,axiom,
    ( esk10564_4(X1,X2,X3,X4)
    | ~ esk10589_4(X1,X2,X3,X4)
    | esk10538_4(X1,X2,X3,X4) ) ).

cnf(i_0_4800,axiom,
    ( ~ esk16687_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X2)
    | esk111_0
    | ~ p(X3)
    | p(X1) ) ).

cnf(i_0_4801,axiom,
    ( ~ esk13036_4(X1,X2,X3,X4)
    | esk13105_4(X1,X2,X3,X4) ) ).

cnf(i_0_4802,axiom,
    ( esk8003_4(X1,X2,X3,X4)
    | esk8005_4(X1,X2,X3,X4) ) ).

cnf(i_0_4803,axiom,
    ( ~ esk7560_4(X1,X2,X3,X4)
    | esk7583_4(X1,X2,X3,X4) ) ).

cnf(i_0_4804,axiom,
    ( esk2760_4(X1,X2,X3,X4)
    | ~ esk2817_4(X1,X2,X3,X4) ) ).

cnf(i_0_4805,axiom,
    ( esk15096_4(X1,X2,X3,X4)
    | esk15121_4(X1,X2,X3,X4) ) ).

cnf(i_0_4806,axiom,
    ( p(X4)
    | ~ esk503_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1)
    | p(X2)
    | esk154_0 ) ).

cnf(i_0_4807,axiom,
    ( ~ esk9028_4(X1,X2,X3,X4)
    | esk8984_4(X1,X2,X3,X4)
    | esk9035_4(X1,X2,X3,X4) ) ).

cnf(i_0_4808,axiom,
    ( ~ esk3507_4(X1,X2,X3,X4)
    | esk3505_4(X1,X2,X3,X4) ) ).

cnf(i_0_4809,axiom,
    ( ~ esk7587_4(X1,X2,X3,X4)
    | esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_4810,axiom,
    ( esk4655_4(X1,X2,X3,X4)
    | ~ esk4676_4(X1,X2,X3,X4)
    | esk4654_4(X1,X2,X3,X4) ) ).

cnf(i_0_4811,axiom,
    ( ~ esk7711_4(X1,X2,X3,X4)
    | esk7453_4(X1,X2,X3,X4) ) ).

cnf(i_0_4812,axiom,
    ( esk13891_4(X1,X2,X3,X4)
    | esk13886_4(X1,X2,X3,X4)
    | ~ esk13887_4(X1,X2,X3,X4) ) ).

cnf(i_0_4813,axiom,
    ( esk16713_4(X1,X2,X3,X4)
    | esk16595_4(X1,X2,X3,X4) ) ).

cnf(i_0_4814,axiom,
    ( ~ esk6567_4(X1,X2,X3,X4)
    | esk6573_4(X1,X2,X3,X4) ) ).

cnf(i_0_4815,axiom,
    ( esk16690_4(X1,X2,X3,X4)
    | esk16657_4(X1,X2,X3,X4) ) ).

cnf(i_0_4816,axiom,
    ( esk16420_4(X1,X2,X3,X4)
    | esk16453_4(X1,X2,X3,X4) ) ).

cnf(i_0_4817,axiom,
    ( ~ esk16072_4(X1,X2,X3,X4)
    | esk16170_4(X1,X2,X3,X4) ) ).

cnf(i_0_4818,axiom,
    ( ~ esk1172_4(X1,X2,X3,X4)
    | esk1188_4(X1,X2,X3,X4) ) ).

cnf(i_0_4819,axiom,
    ( ~ esk4939_4(X1,X2,X3,X4)
    | esk4938_4(X1,X2,X3,X4) ) ).

cnf(i_0_4820,axiom,
    ( ~ esk16252_4(X1,X2,X3,X4)
    | esk16168_4(X1,X2,X3,X4)
    | esk16215_4(X1,X2,X3,X4) ) ).

cnf(i_0_4821,axiom,
    ( ~ p(X1)
    | ~ p(X3)
    | ~ p(X2)
    | ~ p(X4)
    | ~ esk1_0
    | esk16689_4(X1,X2,X3,X4) ) ).

cnf(i_0_4822,axiom,
    ( ~ esk3404_4(X1,X2,X3,X4)
    | esk3379_4(X1,X2,X3,X4)
    | esk3378_4(X1,X2,X3,X4) ) ).

cnf(i_0_4823,axiom,
    ( ~ esk1274_4(X1,X2,X3,X4)
    | esk1016_4(X1,X2,X3,X4) ) ).

cnf(i_0_4824,axiom,
    ( ~ esk4878_4(X1,X2,X3,X4)
    | ~ esk4913_4(X1,X2,X3,X4)
    | ~ esk4932_4(X1,X2,X3,X4) ) ).

cnf(i_0_4825,axiom,
    ( esk10737_4(X1,X2,X3,X4)
    | esk10757_4(X1,X2,X3,X4) ) ).

cnf(i_0_4826,axiom,
    ( esk15152_4(X1,X2,X3,X4)
    | ~ esk15196_4(X1,X2,X3,X4)
    | esk15203_4(X1,X2,X3,X4) ) ).

cnf(i_0_4827,axiom,
    ( ~ esk15996_4(X1,X2,X3,X4)
    | ~ esk15881_4(X1,X2,X3,X4)
    | ~ esk15877_4(X1,X2,X3,X4) ) ).

cnf(i_0_4828,axiom,
    ( esk5083_4(X1,X2,X3,X4)
    | esk5085_4(X1,X2,X3,X4) ) ).

cnf(i_0_4829,axiom,
    ( ~ esk4469_4(X1,X2,X3,X4)
    | esk4512_4(X1,X2,X3,X4) ) ).

cnf(i_0_4830,axiom,
    ( ~ esk4656_4(X1,X2,X3,X4)
    | ~ esk4654_4(X1,X2,X3,X4) ) ).

cnf(i_0_4831,axiom,
    ( ~ esk7857_4(X1,X2,X3,X4)
    | ~ esk7859_4(X1,X2,X3,X4) ) ).

cnf(i_0_4832,axiom,
    ( esk8383_4(X1,X2,X3,X4)
    | esk8382_4(X1,X2,X3,X4) ) ).

cnf(i_0_4833,axiom,
    ( ~ esk6721_4(X1,X2,X3,X4)
    | ~ esk6720_4(X1,X2,X3,X4) ) ).

cnf(i_0_4834,axiom,
    ( esk6914_4(X1,X2,X3,X4)
    | esk6864_4(X1,X2,X3,X4) ) ).

cnf(i_0_4835,axiom,
    ( esk13594_4(X1,X2,X3,X4)
    | esk13681_4(X1,X2,X3,X4) ) ).

cnf(i_0_4836,axiom,
    ( ~ esk5546_4(X1,X2,X3,X4)
    | ~ esk5544_4(X1,X2,X3,X4) ) ).

cnf(i_0_4837,axiom,
    ( ~ esk15812_4(X1,X2,X3,X4)
    | esk15779_4(X1,X2,X3,X4) ) ).

cnf(i_0_4838,axiom,
    ( esk4866_4(X1,X2,X3,X4)
    | esk4833_4(X1,X2,X3,X4) ) ).

cnf(i_0_4839,axiom,
    ( ~ p(X3)
    | ~ p(X4)
    | esk1_0
    | ~ p(X1)
    | ~ p(X2)
    | ~ esk16689_4(X1,X2,X3,X4) ) ).

cnf(i_0_4840,axiom,
    ( ~ esk1997_4(X1,X2,X3,X4)
    | ~ esk2000_4(X1,X2,X3,X4)
    | ~ esk2033_4(X1,X2,X3,X4) ) ).

cnf(i_0_4841,axiom,
    ( ~ esk10427_4(X1,X2,X3,X4)
    | ~ esk10545_4(X1,X2,X3,X4) ) ).

cnf(i_0_4842,axiom,
    ( esk13518_4(X1,X2,X3,X4)
    | ~ esk13776_4(X1,X2,X3,X4) ) ).

cnf(i_0_4843,axiom,
    ( ~ esk10226_4(X1,X2,X3,X4)
    | ~ esk10219_4(X1,X2,X3,X4)
    | ~ esk10227_4(X1,X2,X3,X4) ) ).

cnf(i_0_4844,axiom,
    ( esk3113_4(X1,X2,X3,X4)
    | esk3134_4(X1,X2,X3,X4)
    | ~ esk3112_4(X1,X2,X3,X4) ) ).

cnf(i_0_4845,axiom,
    ( ~ esk8987_4(X1,X2,X3,X4)
    | esk8927_4(X1,X2,X3,X4) ) ).

cnf(i_0_4846,axiom,
    ( esk420_4(X1,X2,X3,X4)
    | esk418_4(X1,X2,X3,X4) ) ).

cnf(i_0_4847,axiom,
    ( esk15932_4(X1,X2,X3,X4)
    | ~ esk15863_4(X1,X2,X3,X4) ) ).

cnf(i_0_4848,axiom,
    ( esk1206_4(X1,X2,X3,X4)
    | esk1228_4(X1,X2,X3,X4)
    | esk1227_4(X1,X2,X3,X4) ) ).

cnf(i_0_4849,axiom,
    ( esk4111_4(X1,X2,X3,X4)
    | ~ esk3853_4(X1,X2,X3,X4) ) ).

cnf(i_0_4850,axiom,
    ( ~ esk14078_4(X1,X2,X3,X4)
    | ~ esk14110_4(X1,X2,X3,X4)
    | ~ esk14157_4(X1,X2,X3,X4) ) ).

cnf(i_0_4851,axiom,
    ( esk6839_4(X1,X2,X3,X4)
    | ~ esk6848_4(X1,X2,X3,X4) ) ).

cnf(i_0_4852,axiom,
    ( ~ esk13937_4(X1,X2,X3,X4)
    | ~ esk13936_4(X1,X2,X3,X4)
    | esk13938_4(X1,X2,X3,X4) ) ).

cnf(i_0_4853,axiom,
    ( ~ esk1278_4(X1,X2,X3,X4)
    | ~ esk1317_4(X1,X2,X3,X4) ) ).

cnf(i_0_4854,axiom,
    ( ~ esk6560_4(X1,X2,X3,X4)
    | esk6573_4(X1,X2,X3,X4) ) ).

cnf(i_0_4855,axiom,
    ( esk13050_4(X1,X2,X3,X4)
    | esk13052_4(X1,X2,X3,X4) ) ).

cnf(i_0_4856,axiom,
    ( ~ esk10535_4(X1,X2,X3,X4)
    | esk10793_4(X1,X2,X3,X4) ) ).

cnf(i_0_4857,axiom,
    ( esk5179_4(X1,X2,X3,X4)
    | esk5119_4(X1,X2,X3,X4)
    | ~ esk5202_4(X1,X2,X3,X4) ) ).

cnf(i_0_4858,axiom,
    ( ~ esk16182_4(X1,X2,X3,X4)
    | esk16233_4(X1,X2,X3,X4) ) ).

cnf(i_0_4859,axiom,
    ( esk780_4(X1,X2,X3,X4)
    | ~ esk779_4(X1,X2,X3,X4) ) ).

cnf(i_0_4860,axiom,
    ( ~ esk3243_4(X1,X2,X3,X4)
    | esk3249_4(X1,X2,X3,X4) ) ).

cnf(i_0_4861,axiom,
    ( ~ esk15572_4(X1,X2,X3,X4)
    | esk15594_4(X1,X2,X3,X4) ) ).

cnf(i_0_4862,axiom,
    ( ~ esk772_4(X1,X2,X3,X4)
    | esk648_4(X1,X2,X3,X4)
    | ~ esk662_4(X1,X2,X3,X4) ) ).

cnf(i_0_4863,axiom,
    ( ~ esk9914_4(X1,X2,X3,X4)
    | ~ esk10002_4(X1,X2,X3,X4)
    | esk9904_4(X1,X2,X3,X4) ) ).

cnf(i_0_4864,axiom,
    ( ~ esk6486_4(X1,X2,X3,X4)
    | esk6402_4(X1,X2,X3,X4)
    | esk6449_4(X1,X2,X3,X4) ) ).

cnf(i_0_4865,axiom,
    ( esk13112_4(X1,X2,X3,X4)
    | ~ esk13166_4(X1,X2,X3,X4)
    | esk13129_4(X1,X2,X3,X4) ) ).

cnf(i_0_4866,axiom,
    ( ~ esk3561_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4)
    | ~ esk3647_4(X1,X2,X3,X4) ) ).

cnf(i_0_4867,axiom,
    ( esk9997_4(X1,X2,X3,X4)
    | esk10030_4(X1,X2,X3,X4) ) ).

cnf(i_0_4868,axiom,
    ( ~ esk9832_4(X1,X2,X3,X4)
    | ~ esk9800_4(X1,X2,X3,X4) ) ).

cnf(i_0_4869,axiom,
    ( esk14626_4(X1,X2,X3,X4)
    | ~ esk14529_4(X1,X2,X3,X4) ) ).

cnf(i_0_4870,axiom,
    ( ~ esk14597_4(X1,X2,X3,X4)
    | ~ esk14587_4(X1,X2,X3,X4)
    | ~ esk14598_4(X1,X2,X3,X4) ) ).

cnf(i_0_4871,axiom,
    ( ~ esk6999_4(X1,X2,X3,X4)
    | esk6998_4(X1,X2,X3,X4) ) ).

cnf(i_0_4872,axiom,
    ( ~ esk5660_4(X1,X2,X3,X4)
    | esk5918_4(X1,X2,X3,X4) ) ).

cnf(i_0_4873,axiom,
    ( esk1048_4(X1,X2,X3,X4)
    | esk952_4(X1,X2,X3,X4)
    | esk951_4(X1,X2,X3,X4) ) ).

cnf(i_0_4874,axiom,
    ( esk12526_4(X1,X2,X3,X4)
    | ~ esk12583_4(X1,X2,X3,X4) ) ).

cnf(i_0_4875,axiom,
    ( esk10725_4(X1,X2,X3,X4)
    | ~ esk10788_4(X1,X2,X3,X4) ) ).

cnf(i_0_4876,axiom,
    ( ~ esk3644_4(X1,X2,X3,X4)
    | esk3646_4(X1,X2,X3,X4)
    | ~ esk3645_4(X1,X2,X3,X4) ) ).

cnf(i_0_4877,axiom,
    ( ~ esk16077_4(X1,X2,X3,X4)
    | esk16198_4(X1,X2,X3,X4) ) ).

cnf(i_0_4878,axiom,
    ( ~ esk12248_4(X1,X2,X3,X4)
    | esk12241_4(X1,X2,X3,X4)
    | esk12234_4(X1,X2,X3,X4) ) ).

cnf(i_0_4879,axiom,
    ( esk2787_4(X1,X2,X3,X4)
    | esk2768_4(X1,X2,X3,X4) ) ).

cnf(i_0_4880,axiom,
    ( esk14308_4(X1,X2,X3,X4)
    | ~ esk14312_4(X1,X2,X3,X4) ) ).

cnf(i_0_4881,axiom,
    ( ~ esk8733_4(X1,X2,X3,X4)
    | ~ esk8629_4(X1,X2,X3,X4)
    | esk8612_4(X1,X2,X3,X4) ) ).

cnf(i_0_4882,axiom,
    ( esk1831_4(X1,X2,X3,X4)
    | esk1792_4(X1,X2,X3,X4) ) ).

cnf(i_0_4883,axiom,
    ( esk8467_4(X1,X2,X3,X4)
    | ~ esk8416_4(X1,X2,X3,X4) ) ).

cnf(i_0_4884,axiom,
    ( esk1303_4(X1,X2,X3,X4)
    | ~ esk1304_4(X1,X2,X3,X4) ) ).

cnf(i_0_4885,axiom,
    ( esk8760_4(X1,X2,X3,X4)
    | esk8745_4(X1,X2,X3,X4) ) ).

cnf(i_0_4886,axiom,
    ( ~ esk7186_4(X1,X2,X3,X4)
    | esk7129_4(X1,X2,X3,X4) ) ).

cnf(i_0_4887,axiom,
    ( esk2218_4(X1,X2,X3,X4)
    | esk2232_4(X1,X2,X3,X4) ) ).

cnf(i_0_4888,axiom,
    ( esk11303_4(X1,X2,X3,X4)
    | ~ esk11045_4(X1,X2,X3,X4) ) ).

cnf(i_0_4889,axiom,
    ( ~ esk13562_4(X1,X2,X3,X4)
    | ~ esk13602_4(X1,X2,X3,X4)
    | ~ esk13569_4(X1,X2,X3,X4) ) ).

cnf(i_0_4890,axiom,
    ( ~ esk3541_4(X1,X2,X3,X4)
    | ~ esk3661_4(X1,X2,X3,X4)
    | ~ esk3547_4(X1,X2,X3,X4) ) ).

cnf(i_0_4891,axiom,
    ( esk1284_4(X1,X2,X3,X4)
    | ~ esk1161_4(X1,X2,X3,X4) ) ).

cnf(i_0_4892,axiom,
    ( esk8203_4(X1,X2,X3,X4)
    | esk8170_4(X1,X2,X3,X4) ) ).

cnf(i_0_4893,axiom,
    ( esk9623_4(X1,X2,X3,X4)
    | ~ esk9647_4(X1,X2,X3,X4) ) ).

cnf(i_0_4894,axiom,
    ( esk16212_4(X1,X2,X3,X4)
    | esk16205_4(X1,X2,X3,X4) ) ).

cnf(i_0_4895,axiom,
    ( ~ esk16326_4(X1,X2,X3,X4)
    | esk16339_4(X1,X2,X3,X4) ) ).

cnf(i_0_4896,axiom,
    ( esk7596_4(X1,X2,X3,X4)
    | ~ esk7553_4(X1,X2,X3,X4) ) ).

cnf(i_0_4897,axiom,
    ( ~ p(X2)
    | p(X1)
    | ~ p(X4)
    | ~ esk280_0
    | esk16709_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_4898,axiom,
    ( esk16339_4(X1,X2,X3,X4)
    | ~ esk16333_4(X1,X2,X3,X4) ) ).

cnf(i_0_4899,axiom,
    ( ~ esk9289_4(X1,X2,X3,X4)
    | ~ esk9291_4(X1,X2,X3,X4) ) ).

cnf(i_0_4900,axiom,
    ( esk6177_4(X1,X2,X3,X4)
    | ~ esk6179_4(X1,X2,X3,X4) ) ).

cnf(i_0_4901,axiom,
    ( esk4927_4(X1,X2,X3,X4)
    | esk4842_4(X1,X2,X3,X4) ) ).

cnf(i_0_4902,axiom,
    ( esk14577_4(X1,X2,X3,X4)
    | esk14618_4(X1,X2,X3,X4) ) ).

cnf(i_0_4903,axiom,
    ( esk7630_4(X1,X2,X3,X4)
    | ~ esk7628_4(X1,X2,X3,X4) ) ).

cnf(i_0_4904,axiom,
    ( ~ esk12263_4(X1,X2,X3,X4)
    | ~ esk12306_4(X1,X2,X3,X4)
    | ~ esk12307_4(X1,X2,X3,X4) ) ).

cnf(i_0_4905,axiom,
    ( esk6615_4(X1,X2,X3,X4)
    | esk6641_4(X1,X2,X3,X4) ) ).

cnf(i_0_4906,axiom,
    ( esk13657_4(X1,X2,X3,X4)
    | esk13692_4(X1,X2,X3,X4) ) ).

cnf(i_0_4907,axiom,
    ( esk8729_4(X1,X2,X3,X4)
    | ~ esk8610_4(X1,X2,X3,X4) ) ).

cnf(i_0_4908,axiom,
    ( esk12128_4(X1,X2,X3,X4)
    | esk12042_4(X1,X2,X3,X4) ) ).

cnf(i_0_4909,axiom,
    ( esk5052_4(X1,X2,X3,X4)
    | ~ esk5038_4(X1,X2,X3,X4) ) ).

cnf(i_0_4910,axiom,
    ( esk6625_4(X1,X2,X3,X4)
    | esk6653_4(X1,X2,X3,X4) ) ).

cnf(i_0_4911,axiom,
    ( esk4916_4(X1,X2,X3,X4)
    | esk4917_4(X1,X2,X3,X4) ) ).

cnf(i_0_4912,axiom,
    ( ~ esk14788_4(X1,X2,X3,X4)
    | esk14797_4(X1,X2,X3,X4) ) ).

cnf(i_0_4913,axiom,
    ( esk14110_4(X1,X2,X3,X4)
    | esk14078_4(X1,X2,X3,X4) ) ).

cnf(i_0_4914,axiom,
    ( ~ esk6099_4(X1,X2,X3,X4)
    | esk6162_4(X1,X2,X3,X4) ) ).

cnf(i_0_4915,axiom,
    ( esk521_4(X1,X2,X3,X4)
    | ~ esk298_0
    | ~ p(X4)
    | ~ p(X3)
    | ~ p(X1)
    | p(X2) ) ).

cnf(i_0_4916,axiom,
    ( esk12726_4(X1,X2,X3,X4)
    | ~ esk12697_4(X1,X2,X3,X4) ) ).

cnf(i_0_4917,axiom,
    ( esk3774_4(X1,X2,X3,X4)
    | esk3760_4(X1,X2,X3,X4) ) ).

cnf(i_0_4918,axiom,
    ( ~ esk700_4(X1,X2,X3,X4)
    | ~ esk738_4(X1,X2,X3,X4)
    | ~ esk737_4(X1,X2,X3,X4) ) ).

cnf(i_0_4919,axiom,
    ( esk13520_4(X1,X2,X3,X4)
    | esk13524_4(X1,X2,X3,X4)
    | esk13523_4(X1,X2,X3,X4)
    | esk13526_4(X1,X2,X3,X4) ) ).

cnf(i_0_4920,axiom,
    ( esk12531_4(X1,X2,X3,X4)
    | esk12542_4(X1,X2,X3,X4) ) ).

cnf(i_0_4921,axiom,
    ( esk2767_4(X1,X2,X3,X4)
    | ~ esk2803_4(X1,X2,X3,X4) ) ).

cnf(i_0_4922,axiom,
    ( esk6205_4(X1,X2,X3,X4)
    | esk6149_4(X1,X2,X3,X4) ) ).

cnf(i_0_4923,axiom,
    ( ~ esk14693_4(X1,X2,X3,X4)
    | esk14691_4(X1,X2,X3,X4) ) ).

cnf(i_0_4924,axiom,
    ( esk14283_4(X1,X2,X3,X4)
    | ~ esk14267_4(X1,X2,X3,X4) ) ).

cnf(i_0_4925,axiom,
    ( esk16429_4(X1,X2,X3,X4)
    | ~ esk16171_4(X1,X2,X3,X4) ) ).

cnf(i_0_4926,axiom,
    ( esk10723_4(X1,X2,X3,X4)
    | esk10761_4(X1,X2,X3,X4) ) ).

cnf(i_0_4927,axiom,
    ( ~ esk11608_4(X1,X2,X3,X4)
    | esk11588_4(X1,X2,X3,X4)
    | esk11637_4(X1,X2,X3,X4) ) ).

cnf(i_0_4928,axiom,
    ( esk6952_4(X1,X2,X3,X4)
    | esk6863_4(X1,X2,X3,X4) ) ).

cnf(i_0_4929,axiom,
    ( ~ esk12042_4(X1,X2,X3,X4)
    | ~ esk12010_4(X1,X2,X3,X4)
    | ~ esk12041_4(X1,X2,X3,X4) ) ).

cnf(i_0_4930,axiom,
    ( ~ esk9978_4(X1,X2,X3,X4)
    | ~ esk9958_4(X1,X2,X3,X4)
    | ~ esk9977_4(X1,X2,X3,X4) ) ).

cnf(i_0_4931,axiom,
    ( esk6966_4(X1,X2,X3,X4)
    | esk6965_4(X1,X2,X3,X4)
    | esk6964_4(X1,X2,X3,X4) ) ).

cnf(i_0_4932,axiom,
    ( ~ esk3484_4(X1,X2,X3,X4)
    | esk3441_4(X1,X2,X3,X4) ) ).

cnf(i_0_4933,axiom,
    ( esk13299_4(X1,X2,X3,X4)
    | esk13318_4(X1,X2,X3,X4) ) ).

cnf(i_0_4934,axiom,
    ( esk8944_4(X1,X2,X3,X4)
    | esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_4935,axiom,
    ( esk7223_4(X1,X2,X3,X4)
    | esk7197_4(X1,X2,X3,X4)
    | ~ esk7248_4(X1,X2,X3,X4) ) ).

cnf(i_0_4936,axiom,
    ( esk12896_4(X1,X2,X3,X4)
    | ~ esk12898_4(X1,X2,X3,X4) ) ).

cnf(i_0_4937,axiom,
    ( p(X1)
    | esk115_0
    | ~ p(X4)
    | ~ esk16687_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X3) ) ).

cnf(i_0_4938,axiom,
    ( ~ esk2219_4(X1,X2,X3,X4)
    | ~ esk2217_4(X1,X2,X3,X4) ) ).

cnf(i_0_4939,axiom,
    ( esk13343_4(X1,X2,X3,X4)
    | esk13426_4(X1,X2,X3,X4)
    | ~ esk13403_4(X1,X2,X3,X4) ) ).

cnf(i_0_4940,axiom,
    ( esk1731_4(X1,X2,X3,X4)
    | esk1760_4(X1,X2,X3,X4) ) ).

cnf(i_0_4941,axiom,
    ( ~ esk13674_4(X1,X2,X3,X4)
    | esk13675_4(X1,X2,X3,X4) ) ).

cnf(i_0_4942,axiom,
    ( ~ esk10096_4(X1,X2,X3,X4)
    | ~ esk10074_4(X1,X2,X3,X4) ) ).

cnf(i_0_4943,axiom,
    ( esk1569_4(X1,X2,X3,X4)
    | esk1568_4(X1,X2,X3,X4)
    | esk1567_4(X1,X2,X3,X4) ) ).

cnf(i_0_4944,axiom,
    ( esk12082_4(X1,X2,X3,X4)
    | ~ esk11957_4(X1,X2,X3,X4) ) ).

cnf(i_0_4945,axiom,
    ( ~ esk10971_4(X1,X2,X3,X4)
    | esk10969_4(X1,X2,X3,X4) ) ).

cnf(i_0_4946,axiom,
    ( ~ esk12319_4(X1,X2,X3,X4)
    | esk12061_4(X1,X2,X3,X4) ) ).

cnf(i_0_4947,axiom,
    ( esk10339_4(X1,X2,X3,X4)
    | ~ esk10340_4(X1,X2,X3,X4) ) ).

cnf(i_0_4948,axiom,
    ( ~ esk16431_4(X1,X2,X3,X4)
    | ~ esk16398_4(X1,X2,X3,X4)
    | ~ esk16389_4(X1,X2,X3,X4) ) ).

cnf(i_0_4949,axiom,
    ( esk2828_4(X1,X2,X3,X4)
    | ~ esk2570_4(X1,X2,X3,X4) ) ).

cnf(i_0_4950,axiom,
    ( esk13775_4(X1,X2,X3,X4)
    | ~ esk13791_4(X1,X2,X3,X4) ) ).

cnf(i_0_4951,axiom,
    ( esk15859_4(X1,X2,X3,X4)
    | ~ esk15940_4(X1,X2,X3,X4) ) ).

cnf(i_0_4952,axiom,
    ( esk13218_4(X1,X2,X3,X4)
    | ~ esk13248_4(X1,X2,X3,X4) ) ).

cnf(i_0_4953,axiom,
    ( ~ esk13115_4(X1,X2,X3,X4)
    | esk13116_4(X1,X2,X3,X4) ) ).

cnf(i_0_4954,axiom,
    ( esk10927_4(X1,X2,X3,X4)
    | ~ esk11050_4(X1,X2,X3,X4)
    | ~ esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_4955,axiom,
    ( ~ esk14409_4(X1,X2,X3,X4)
    | ~ esk14408_4(X1,X2,X3,X4)
    | esk14410_4(X1,X2,X3,X4) ) ).

cnf(i_0_4956,axiom,
    ( esk9210_4(X1,X2,X3,X4)
    | esk9243_4(X1,X2,X3,X4) ) ).

cnf(i_0_4957,axiom,
    ( esk16102_4(X1,X2,X3,X4)
    | ~ esk16101_4(X1,X2,X3,X4) ) ).

cnf(i_0_4958,axiom,
    ( esk10727_4(X1,X2,X3,X4)
    | ~ esk10784_4(X1,X2,X3,X4) ) ).

cnf(i_0_4959,axiom,
    ( esk9026_4(X1,X2,X3,X4)
    | esk9040_4(X1,X2,X3,X4) ) ).

cnf(i_0_4960,axiom,
    ( esk7988_4(X1,X2,X3,X4)
    | esk7987_4(X1,X2,X3,X4) ) ).

cnf(i_0_4961,axiom,
    ( ~ esk2200_4(X1,X2,X3,X4)
    | esk2236_4(X1,X2,X3,X4) ) ).

cnf(i_0_4962,axiom,
    ( esk8672_4(X1,X2,X3,X4)
    | esk8695_4(X1,X2,X3,X4) ) ).

cnf(i_0_4963,axiom,
    ( esk1161_4(X1,X2,X3,X4)
    | ~ esk1176_4(X1,X2,X3,X4)
    | ~ esk1284_4(X1,X2,X3,X4) ) ).

cnf(i_0_4964,axiom,
    ( ~ esk9531_4(X1,X2,X3,X4)
    | ~ esk9452_4(X1,X2,X3,X4)
    | ~ esk9484_4(X1,X2,X3,X4) ) ).

cnf(i_0_4965,axiom,
    ( ~ esk15166_4(X1,X2,X3,X4)
    | ~ esk15104_4(X1,X2,X3,X4)
    | ~ esk15133_4(X1,X2,X3,X4) ) ).

cnf(i_0_4966,axiom,
    ( esk2898_4(X1,X2,X3,X4)
    | esk2812_4(X1,X2,X3,X4) ) ).

cnf(i_0_4967,axiom,
    ( esk15708_4(X1,X2,X3,X4)
    | esk15722_4(X1,X2,X3,X4) ) ).

cnf(i_0_4968,axiom,
    ( esk11420_4(X1,X2,X3,X4)
    | ~ esk11448_4(X1,X2,X3,X4) ) ).

cnf(i_0_4969,axiom,
    ( esk14007_4(X1,X2,X3,X4)
    | ~ esk14026_4(X1,X2,X3,X4)
    | ~ esk14126_4(X1,X2,X3,X4) ) ).

cnf(i_0_4970,axiom,
    ( esk2011_4(X1,X2,X3,X4)
    | esk1999_4(X1,X2,X3,X4) ) ).

cnf(i_0_4971,axiom,
    ( esk12576_4(X1,X2,X3,X4)
    | ~ esk12476_4(X1,X2,X3,X4) ) ).

cnf(i_0_4972,axiom,
    ( esk3340_4(X1,X2,X3,X4)
    | esk3370_4(X1,X2,X3,X4) ) ).

cnf(i_0_4973,axiom,
    ( esk12998_4(X1,X2,X3,X4)
    | ~ esk12986_4(X1,X2,X3,X4) ) ).

cnf(i_0_4974,axiom,
    ( ~ esk6320_4(X1,X2,X3,X4)
    | esk6342_4(X1,X2,X3,X4) ) ).

cnf(i_0_4975,axiom,
    ( esk11335_4(X1,X2,X3,X4)
    | esk11378_4(X1,X2,X3,X4) ) ).

cnf(i_0_4976,axiom,
    ( esk14417_4(X1,X2,X3,X4)
    | ~ esk14447_4(X1,X2,X3,X4)
    | esk14395_4(X1,X2,X3,X4) ) ).

cnf(i_0_4977,axiom,
    ( esk14446_4(X1,X2,X3,X4)
    | ~ esk14418_4(X1,X2,X3,X4) ) ).

cnf(i_0_4978,axiom,
    ( ~ esk2954_4(X1,X2,X3,X4)
    | esk3006_4(X1,X2,X3,X4) ) ).

cnf(i_0_4979,axiom,
    ( ~ esk11708_4(X1,X2,X3,X4)
    | esk11713_4(X1,X2,X3,X4) ) ).

cnf(i_0_4980,axiom,
    ( ~ esk15712_4(X1,X2,X3,X4)
    | ~ esk15713_4(X1,X2,X3,X4) ) ).

cnf(i_0_4981,axiom,
    ( esk13562_4(X1,X2,X3,X4)
    | esk13571_4(X1,X2,X3,X4) ) ).

cnf(i_0_4982,axiom,
    ( esk12791_4(X1,X2,X3,X4)
    | esk12812_4(X1,X2,X3,X4) ) ).

cnf(i_0_4983,axiom,
    ( ~ esk13400_4(X1,X2,X3,X4)
    | esk13349_4(X1,X2,X3,X4)
    | esk13429_4(X1,X2,X3,X4) ) ).

cnf(i_0_4984,axiom,
    ( p(X1)
    | esk18_0
    | p(X3)
    | p(X2)
    | ~ esk16602_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_4985,axiom,
    ( ~ esk6804_4(X1,X2,X3,X4)
    | ~ esk6832_4(X1,X2,X3,X4) ) ).

cnf(i_0_4986,axiom,
    ( esk9715_4(X1,X2,X3,X4)
    | esk9829_4(X1,X2,X3,X4) ) ).

cnf(i_0_4987,axiom,
    ( esk2731_4(X1,X2,X3,X4)
    | esk2729_4(X1,X2,X3,X4)
    | ~ esk2735_4(X1,X2,X3,X4) ) ).

cnf(i_0_4988,axiom,
    ( ~ p(X4)
    | esk1_0
    | ~ p(X1)
    | ~ p(X2)
    | ~ esk16693_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_4989,axiom,
    ( esk12824_4(X1,X2,X3,X4)
    | esk12775_4(X1,X2,X3,X4) ) ).

cnf(i_0_4990,axiom,
    ( esk2492_4(X1,X2,X3,X4)
    | esk2590_4(X1,X2,X3,X4) ) ).

cnf(i_0_4991,axiom,
    ( ~ esk11082_4(X1,X2,X3,X4)
    | ~ esk11096_4(X1,X2,X3,X4) ) ).

cnf(i_0_4992,axiom,
    ( ~ esk6353_4(X1,X2,X3,X4)
    | esk6425_4(X1,X2,X3,X4) ) ).

cnf(i_0_4993,axiom,
    ( ~ esk10557_4(X1,X2,X3,X4)
    | ~ esk10460_4(X1,X2,X3,X4) ) ).

cnf(i_0_4994,axiom,
    ( ~ esk5545_4(X1,X2,X3,X4)
    | ~ esk5651_4(X1,X2,X3,X4)
    | esk5529_4(X1,X2,X3,X4) ) ).

cnf(i_0_4995,axiom,
    ( esk12513_4(X1,X2,X3,X4)
    | ~ esk12511_4(X1,X2,X3,X4) ) ).

cnf(i_0_4996,axiom,
    ( esk16546_4(X1,X2,X3,X4)
    | esk16571_4(X1,X2,X3,X4)
    | esk16570_4(X1,X2,X3,X4)
    | esk16568_4(X1,X2,X3,X4)
    | esk16598_4(X1,X2,X3,X4) ) ).

cnf(i_0_4997,axiom,
    ( ~ esk5939_4(X1,X2,X3,X4)
    | ~ esk5961_4(X1,X2,X3,X4)
    | ~ esk5940_4(X1,X2,X3,X4) ) ).

cnf(i_0_4998,axiom,
    ( esk11155_4(X1,X2,X3,X4)
    | ~ esk11184_4(X1,X2,X3,X4) ) ).

cnf(i_0_4999,axiom,
    ( esk4875_4(X1,X2,X3,X4)
    | ~ esk5133_4(X1,X2,X3,X4) ) ).

cnf(i_0_5000,axiom,
    ( esk753_4(X1,X2,X3,X4)
    | ~ esk1011_4(X1,X2,X3,X4) ) ).

cnf(i_0_5001,axiom,
    ( esk12226_4(X1,X2,X3,X4)
    | ~ esk12346_4(X1,X2,X3,X4)
    | esk12195_4(X1,X2,X3,X4) ) ).

cnf(i_0_5002,axiom,
    ( esk12854_4(X1,X2,X3,X4)
    | ~ esk13112_4(X1,X2,X3,X4) ) ).

cnf(i_0_5003,axiom,
    ( esk4053_4(X1,X2,X3,X4)
    | esk4033_4(X1,X2,X3,X4)
    | esk3999_4(X1,X2,X3,X4) ) ).

cnf(i_0_5004,axiom,
    ( ~ esk5919_4(X1,X2,X3,X4)
    | ~ esk5801_4(X1,X2,X3,X4) ) ).

cnf(i_0_5005,axiom,
    ( ~ esk5834_4(X1,X2,X3,X4)
    | ~ esk5835_4(X1,X2,X3,X4) ) ).

cnf(i_0_5006,axiom,
    ( ~ esk3500_4(X1,X2,X3,X4)
    | esk3506_4(X1,X2,X3,X4) ) ).

cnf(i_0_5007,axiom,
    ( esk12208_4(X1,X2,X3,X4)
    | ~ esk12187_4(X1,X2,X3,X4) ) ).

cnf(i_0_5008,axiom,
    ( ~ esk14335_4(X1,X2,X3,X4)
    | ~ esk14339_4(X1,X2,X3,X4)
    | ~ esk14454_4(X1,X2,X3,X4) ) ).

cnf(i_0_5009,axiom,
    ( esk12882_4(X1,X2,X3,X4)
    | esk12843_4(X1,X2,X3,X4) ) ).

cnf(i_0_5010,axiom,
    ( esk7415_4(X1,X2,X3,X4)
    | esk7394_4(X1,X2,X3,X4) ) ).

cnf(i_0_5011,axiom,
    ( esk16005_4(X1,X2,X3,X4)
    | esk15919_4(X1,X2,X3,X4) ) ).

cnf(i_0_5012,axiom,
    ( ~ esk8421_4(X1,X2,X3,X4)
    | esk8457_4(X1,X2,X3,X4) ) ).

cnf(i_0_5013,axiom,
    ( ~ esk11228_4(X1,X2,X3,X4)
    | esk11226_4(X1,X2,X3,X4) ) ).

cnf(i_0_5014,axiom,
    ( esk10711_4(X1,X2,X3,X4)
    | ~ esk10689_4(X1,X2,X3,X4) ) ).

cnf(i_0_5015,axiom,
    ( ~ esk12031_4(X1,X2,X3,X4)
    | ~ esk12020_4(X1,X2,X3,X4)
    | ~ esk12064_4(X1,X2,X3,X4) ) ).

cnf(i_0_5016,axiom,
    ( esk569_4(X1,X2,X3,X4)
    | ~ esk539_4(X1,X2,X3,X4) ) ).

cnf(i_0_5017,axiom,
    ( esk11156_4(X1,X2,X3,X4)
    | ~ esk11183_4(X1,X2,X3,X4) ) ).

cnf(i_0_5018,axiom,
    ( ~ esk5059_4(X1,X2,X3,X4)
    | ~ esk5060_4(X1,X2,X3,X4) ) ).

cnf(i_0_5019,axiom,
    ( esk16382_4(X1,X2,X3,X4)
    | esk16405_4(X1,X2,X3,X4) ) ).

cnf(i_0_5020,axiom,
    ( ~ esk11856_4(X1,X2,X3,X4)
    | esk11890_4(X1,X2,X3,X4) ) ).

cnf(i_0_5021,axiom,
    ( esk733_4(X1,X2,X3,X4)
    | esk712_4(X1,X2,X3,X4) ) ).

cnf(i_0_5022,axiom,
    ( ~ esk1720_4(X1,X2,X3,X4)
    | ~ esk1740_4(X1,X2,X3,X4) ) ).

cnf(i_0_5023,axiom,
    ( esk9639_4(X1,X2,X3,X4)
    | ~ esk9616_4(X1,X2,X3,X4) ) ).

cnf(i_0_5024,axiom,
    ( esk9159_4(X1,X2,X3,X4)
    | ~ esk9158_4(X1,X2,X3,X4) ) ).

cnf(i_0_5025,axiom,
    ( ~ esk12597_4(X1,X2,X3,X4)
    | esk12855_4(X1,X2,X3,X4) ) ).

cnf(i_0_5026,axiom,
    ( esk15666_4(X1,X2,X3,X4)
    | ~ esk15548_4(X1,X2,X3,X4) ) ).

cnf(i_0_5027,axiom,
    ( ~ esk8933_4(X1,X2,X3,X4)
    | esk8975_4(X1,X2,X3,X4) ) ).

cnf(i_0_5028,axiom,
    ( esk1233_4(X1,X2,X3,X4)
    | esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_5029,axiom,
    ( esk14819_4(X1,X2,X3,X4)
    | ~ esk14803_4(X1,X2,X3,X4) ) ).

cnf(i_0_5030,axiom,
    ( ~ esk7994_4(X1,X2,X3,X4)
    | esk8019_4(X1,X2,X3,X4)
    | esk7968_4(X1,X2,X3,X4) ) ).

cnf(i_0_5031,axiom,
    ( ~ esk11287_4(X1,X2,X3,X4)
    | ~ esk11347_4(X1,X2,X3,X4)
    | ~ esk11370_4(X1,X2,X3,X4) ) ).

cnf(i_0_5032,axiom,
    ( ~ esk8664_4(X1,X2,X3,X4)
    | ~ esk8711_4(X1,X2,X3,X4)
    | ~ esk8710_4(X1,X2,X3,X4) ) ).

cnf(i_0_5033,axiom,
    ( esk1707_4(X1,X2,X3,X4)
    | ~ esk1708_4(X1,X2,X3,X4) ) ).

cnf(i_0_5034,axiom,
    ( ~ esk3371_4(X1,X2,X3,X4)
    | ~ esk3336_4(X1,X2,X3,X4)
    | ~ esk3372_4(X1,X2,X3,X4) ) ).

cnf(i_0_5035,axiom,
    ( esk5319_4(X1,X2,X3,X4)
    | esk5417_4(X1,X2,X3,X4) ) ).

cnf(i_0_5036,axiom,
    ( esk7358_4(X1,X2,X3,X4)
    | esk7356_4(X1,X2,X3,X4)
    | esk7352_4(X1,X2,X3,X4)
    | esk7355_4(X1,X2,X3,X4) ) ).

cnf(i_0_5037,axiom,
    ( ~ esk9450_4(X1,X2,X3,X4)
    | ~ esk9430_4(X1,X2,X3,X4) ) ).

cnf(i_0_5038,axiom,
    ( esk5982_4(X1,X2,X3,X4)
    | esk5896_4(X1,X2,X3,X4) ) ).

cnf(i_0_5039,axiom,
    ( ~ esk905_4(X1,X2,X3,X4)
    | esk919_4(X1,X2,X3,X4) ) ).

cnf(i_0_5040,axiom,
    ( ~ esk11091_4(X1,X2,X3,X4)
    | esk11084_4(X1,X2,X3,X4)
    | esk11040_4(X1,X2,X3,X4) ) ).

cnf(i_0_5041,axiom,
    ( esk14363_4(X1,X2,X3,X4)
    | esk14335_4(X1,X2,X3,X4) ) ).

cnf(i_0_5042,axiom,
    ( ~ esk16758_4(X1,X2,X3,X4)
    | esk16759_4(X1,X2,X3,X4) ) ).

cnf(i_0_5043,axiom,
    ( ~ p(X3)
    | ~ p(X4)
    | ~ esk1_0
    | ~ p(X1)
    | esk16699_4(X1,X2,X3,X4)
    | ~ p(X2) ) ).

cnf(i_0_5044,axiom,
    ( esk8897_4(X1,X2,X3,X4)
    | esk8896_4(X1,X2,X3,X4) ) ).

cnf(i_0_5045,axiom,
    ( ~ esk8506_4(X1,X2,X3,X4)
    | ~ esk8486_4(X1,X2,X3,X4)
    | ~ esk8488_4(X1,X2,X3,X4) ) ).

cnf(i_0_5046,axiom,
    ( ~ esk13149_4(X1,X2,X3,X4)
    | ~ esk13150_4(X1,X2,X3,X4)
    | esk13151_4(X1,X2,X3,X4) ) ).

cnf(i_0_5047,axiom,
    ( ~ esk433_4(X1,X2,X3,X4)
    | ~ esk419_4(X1,X2,X3,X4)
    | ~ esk410_4(X1,X2,X3,X4) ) ).

cnf(i_0_5048,axiom,
    ( ~ esk10145_4(X1,X2,X3,X4)
    | ~ esk10173_4(X1,X2,X3,X4) ) ).

cnf(i_0_5049,axiom,
    ( ~ esk7556_4(X1,X2,X3,X4)
    | esk7587_4(X1,X2,X3,X4) ) ).

cnf(i_0_5050,axiom,
    ( esk12098_4(X1,X2,X3,X4)
    | ~ esk12356_4(X1,X2,X3,X4) ) ).

cnf(i_0_5051,axiom,
    ( ~ esk3837_4(X1,X2,X3,X4)
    | esk3792_4(X1,X2,X3,X4) ) ).

cnf(i_0_5052,axiom,
    ( ~ esk13515_4(X1,X2,X3,X4)
    | ~ esk13513_4(X1,X2,X3,X4) ) ).

cnf(i_0_5053,axiom,
    ( ~ p(X3)
    | ~ esk279_0
    | esk16709_4(X1,X2,X3,X4)
    | p(X4)
    | p(X1)
    | ~ p(X2) ) ).

cnf(i_0_5054,axiom,
    ( esk15237_4(X1,X2,X3,X4)
    | esk15114_4(X1,X2,X3,X4) ) ).

cnf(i_0_5055,axiom,
    ( ~ p(X1)
    | esk271_0
    | ~ esk16707_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | ~ p(X4) ) ).

cnf(i_0_5056,axiom,
    ( ~ esk14019_4(X1,X2,X3,X4)
    | esk13989_4(X1,X2,X3,X4) ) ).

cnf(i_0_5057,axiom,
    ( esk12313_4(X1,X2,X3,X4)
    | ~ esk12055_4(X1,X2,X3,X4) ) ).

cnf(i_0_5058,axiom,
    ( esk14944_4(X1,X2,X3,X4)
    | esk14942_4(X1,X2,X3,X4) ) ).

cnf(i_0_5059,axiom,
    ( esk13344_4(X1,X2,X3,X4)
    | ~ esk13602_4(X1,X2,X3,X4) ) ).

cnf(i_0_5060,axiom,
    ( esk6316_4(X1,X2,X3,X4)
    | ~ esk6301_4(X1,X2,X3,X4) ) ).

cnf(i_0_5061,axiom,
    ( esk1805_4(X1,X2,X3,X4)
    | ~ esk1724_4(X1,X2,X3,X4) ) ).

cnf(i_0_5062,axiom,
    ( esk3111_4(X1,X2,X3,X4)
    | esk3110_4(X1,X2,X3,X4)
    | esk3109_4(X1,X2,X3,X4) ) ).

cnf(i_0_5063,axiom,
    ( ~ esk8900_4(X1,X2,X3,X4)
    | ~ esk8905_4(X1,X2,X3,X4) ) ).

cnf(i_0_5064,axiom,
    ( esk10565_4(X1,X2,X3,X4)
    | esk10534_4(X1,X2,X3,X4) ) ).

cnf(i_0_5065,axiom,
    ( ~ esk2816_4(X1,X2,X3,X4)
    | esk2867_4(X1,X2,X3,X4)
    | esk2860_4(X1,X2,X3,X4) ) ).

cnf(i_0_5066,axiom,
    ( ~ esk2473_4(X1,X2,X3,X4)
    | ~ esk2475_4(X1,X2,X3,X4) ) ).

cnf(i_0_5067,axiom,
    ( ~ esk3239_4(X1,X2,X3,X4)
    | esk2981_4(X1,X2,X3,X4) ) ).

cnf(i_0_5068,axiom,
    ( esk12998_4(X1,X2,X3,X4)
    | ~ esk12985_4(X1,X2,X3,X4) ) ).

cnf(i_0_5069,axiom,
    ( ~ esk2122_4(X1,X2,X3,X4)
    | ~ esk2090_4(X1,X2,X3,X4) ) ).

cnf(i_0_5070,axiom,
    ( esk15912_4(X1,X2,X3,X4)
    | ~ esk15873_4(X1,X2,X3,X4) ) ).

cnf(i_0_5071,axiom,
    ( ~ esk5811_4(X1,X2,X3,X4)
    | esk6069_4(X1,X2,X3,X4) ) ).

cnf(i_0_5072,axiom,
    ( ~ esk5268_4(X1,X2,X3,X4)
    | esk5386_4(X1,X2,X3,X4) ) ).

cnf(i_0_5073,axiom,
    ( esk8751_4(X1,X2,X3,X4)
    | ~ esk8493_4(X1,X2,X3,X4) ) ).

cnf(i_0_5074,axiom,
    ( ~ esk3132_4(X1,X2,X3,X4)
    | ~ esk3045_4(X1,X2,X3,X4)
    | ~ esk3027_4(X1,X2,X3,X4) ) ).

cnf(i_0_5075,axiom,
    ( ~ esk10802_4(X1,X2,X3,X4)
    | ~ esk10684_4(X1,X2,X3,X4) ) ).

cnf(i_0_5076,axiom,
    ( ~ esk389_4(X1,X2,X3,X4)
    | esk405_4(X1,X2,X3,X4) ) ).

cnf(i_0_5077,axiom,
    ( esk9017_4(X1,X2,X3,X4)
    | esk9002_4(X1,X2,X3,X4) ) ).

cnf(i_0_5078,axiom,
    ( esk10093_4(X1,X2,X3,X4)
    | esk10022_4(X1,X2,X3,X4)
    | ~ esk10074_4(X1,X2,X3,X4) ) ).

cnf(i_0_5079,axiom,
    ( esk14847_4(X1,X2,X3,X4)
    | esk14864_4(X1,X2,X3,X4) ) ).

cnf(i_0_5080,axiom,
    ( esk11875_4(X1,X2,X3,X4)
    | esk11847_4(X1,X2,X3,X4) ) ).

cnf(i_0_5081,axiom,
    ( ~ esk15231_4(X1,X2,X3,X4)
    | ~ esk15230_4(X1,X2,X3,X4)
    | esk15232_4(X1,X2,X3,X4) ) ).

cnf(i_0_5082,axiom,
    ( ~ esk10275_4(X1,X2,X3,X4)
    | ~ esk10310_4(X1,X2,X3,X4)
    | ~ esk10311_4(X1,X2,X3,X4) ) ).

cnf(i_0_5083,axiom,
    ( ~ esk11180_4(X1,X2,X3,X4)
    | esk11299_4(X1,X2,X3,X4) ) ).

cnf(i_0_5084,axiom,
    ( esk8909_4(X1,X2,X3,X4)
    | esk8891_4(X1,X2,X3,X4) ) ).

cnf(i_0_5085,axiom,
    ( ~ esk5099_4(X1,X2,X3,X4)
    | ~ esk5098_4(X1,X2,X3,X4)
    | ~ esk5073_4(X1,X2,X3,X4) ) ).

cnf(i_0_5086,axiom,
    ( ~ esk14422_4(X1,X2,X3,X4)
    | ~ esk14387_4(X1,X2,X3,X4)
    | ~ esk14423_4(X1,X2,X3,X4) ) ).

cnf(i_0_5087,axiom,
    ( esk5945_4(X1,X2,X3,X4)
    | esk5947_4(X1,X2,X3,X4)
    | esk5946_4(X1,X2,X3,X4) ) ).

cnf(i_0_5088,axiom,
    ( esk7908_4(X1,X2,X3,X4)
    | esk7935_4(X1,X2,X3,X4) ) ).

cnf(i_0_5089,axiom,
    ( esk12877_4(X1,X2,X3,X4)
    | esk12851_4(X1,X2,X3,X4)
    | ~ esk12902_4(X1,X2,X3,X4) ) ).

cnf(i_0_5090,axiom,
    ( ~ esk4095_4(X1,X2,X3,X4)
    | ~ esk4003_4(X1,X2,X3,X4)
    | esk3995_4(X1,X2,X3,X4) ) ).

cnf(i_0_5091,axiom,
    ( ~ esk8267_4(X1,X2,X3,X4)
    | esk8296_4(X1,X2,X3,X4)
    | esk8247_4(X1,X2,X3,X4) ) ).

cnf(i_0_5092,axiom,
    ( ~ esk2619_4(X1,X2,X3,X4)
    | esk2565_4(X1,X2,X3,X4)
    | esk2600_4(X1,X2,X3,X4) ) ).

cnf(i_0_5093,axiom,
    ( esk6444_4(X1,X2,X3,X4)
    | ~ esk6702_4(X1,X2,X3,X4) ) ).

cnf(i_0_5094,axiom,
    ( ~ esk14255_4(X1,X2,X3,X4)
    | ~ esk14285_4(X1,X2,X3,X4) ) ).

cnf(i_0_5095,axiom,
    ( esk14893_4(X1,X2,X3,X4)
    | ~ esk14635_4(X1,X2,X3,X4) ) ).

cnf(i_0_5096,axiom,
    ( esk1508_4(X1,X2,X3,X4)
    | esk1541_4(X1,X2,X3,X4) ) ).

cnf(i_0_5097,axiom,
    ( esk8225_4(X1,X2,X3,X4)
    | ~ esk8101_4(X1,X2,X3,X4) ) ).

cnf(i_0_5098,axiom,
    ( ~ esk8249_4(X1,X2,X3,X4)
    | ~ esk8251_4(X1,X2,X3,X4) ) ).

cnf(i_0_5099,axiom,
    esk11453_4(X1,X2,X3,X4) ).

cnf(i_0_5100,axiom,
    ( p(X1)
    | ~ esk33_0
    | p(X3)
    | p(X4)
    | esk16605_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_5101,axiom,
    ( ~ esk6144_4(X1,X2,X3,X4)
    | esk6402_4(X1,X2,X3,X4) ) ).

cnf(i_0_5102,axiom,
    ( esk1575_4(X1,X2,X3,X4)
    | esk1582_4(X1,X2,X3,X4)
    | ~ esk1531_4(X1,X2,X3,X4) ) ).

cnf(i_0_5103,axiom,
    ( esk15709_4(X1,X2,X3,X4)
    | esk15670_4(X1,X2,X3,X4) ) ).

cnf(i_0_5104,axiom,
    ( ~ esk16360_4(X1,X2,X3,X4)
    | ~ esk16359_4(X1,X2,X3,X4)
    | esk16361_4(X1,X2,X3,X4) ) ).

cnf(i_0_5105,axiom,
    ( ~ esk3297_4(X1,X2,X3,X4)
    | ~ esk3275_4(X1,X2,X3,X4)
    | ~ esk3298_4(X1,X2,X3,X4) ) ).

cnf(i_0_5106,axiom,
    ( esk507_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X2)
    | p(X4)
    | p(X1)
    | ~ esk188_0 ) ).

cnf(i_0_5107,axiom,
    ( esk8373_4(X1,X2,X3,X4)
    | esk8321_4(X1,X2,X3,X4) ) ).

cnf(i_0_5108,axiom,
    ( ~ esk9751_4(X1,X2,X3,X4)
    | esk9650_4(X1,X2,X3,X4)
    | ~ esk9657_4(X1,X2,X3,X4) ) ).

cnf(i_0_5109,axiom,
    ( esk6746_4(X1,X2,X3,X4)
    | esk6753_4(X1,X2,X3,X4)
    | ~ esk6665_4(X1,X2,X3,X4) ) ).

cnf(i_0_5110,axiom,
    ( ~ esk6625_4(X1,X2,X3,X4)
    | ~ esk6731_4(X1,X2,X3,X4)
    | ~ esk6645_4(X1,X2,X3,X4) ) ).

cnf(i_0_5111,axiom,
    ( ~ esk1857_4(X1,X2,X3,X4)
    | ~ esk1858_4(X1,X2,X3,X4)
    | esk1859_4(X1,X2,X3,X4) ) ).

cnf(i_0_5112,axiom,
    ( esk5031_4(X1,X2,X3,X4)
    | ~ esk5011_4(X1,X2,X3,X4) ) ).

cnf(i_0_5113,axiom,
    ( ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15935_4(X1,X2,X3,X4)
    | ~ esk15902_4(X1,X2,X3,X4) ) ).

cnf(i_0_5114,axiom,
    ( esk10643_4(X1,X2,X3,X4)
    | ~ esk10668_4(X1,X2,X3,X4) ) ).

cnf(i_0_5115,axiom,
    ( ~ esk10814_4(X1,X2,X3,X4)
    | ~ esk10807_4(X1,X2,X3,X4)
    | ~ esk10716_4(X1,X2,X3,X4) ) ).

cnf(i_0_5116,axiom,
    ( ~ esk7447_4(X1,X2,X3,X4)
    | esk7705_4(X1,X2,X3,X4) ) ).

cnf(i_0_5117,axiom,
    ( esk9907_4(X1,X2,X3,X4)
    | ~ esk9914_4(X1,X2,X3,X4)
    | ~ esk10008_4(X1,X2,X3,X4) ) ).

cnf(i_0_5118,axiom,
    ( ~ esk3084_4(X1,X2,X3,X4)
    | esk3342_4(X1,X2,X3,X4) ) ).

cnf(i_0_5119,axiom,
    ( ~ esk12182_4(X1,X2,X3,X4)
    | esk12213_4(X1,X2,X3,X4) ) ).

cnf(i_0_5120,axiom,
    ( ~ esk10569_4(X1,X2,X3,X4)
    | ~ esk10570_4(X1,X2,X3,X4) ) ).

cnf(i_0_5121,axiom,
    ( ~ esk5715_4(X1,X2,X3,X4)
    | ~ esk5599_4(X1,X2,X3,X4)
    | ~ esk5597_4(X1,X2,X3,X4) ) ).

cnf(i_0_5122,axiom,
    ( ~ esk11562_4(X1,X2,X3,X4)
    | ~ esk11593_4(X1,X2,X3,X4) ) ).

cnf(i_0_5123,axiom,
    ( esk15009_4(X1,X2,X3,X4)
    | ~ esk15040_4(X1,X2,X3,X4) ) ).

cnf(i_0_5124,axiom,
    ( esk6985_4(X1,X2,X3,X4)
    | ~ esk6971_4(X1,X2,X3,X4) ) ).

cnf(i_0_5125,axiom,
    ( ~ p(X3)
    | esk128_0
    | p(X1)
    | p(X4)
    | ~ p(X2)
    | ~ esk499_4(X1,X2,X3,X4) ) ).

cnf(i_0_5126,axiom,
    ( esk13494_4(X1,X2,X3,X4)
    | ~ esk13471_4(X1,X2,X3,X4) ) ).

cnf(i_0_5127,axiom,
    ( esk1740_4(X1,X2,X3,X4)
    | esk1757_4(X1,X2,X3,X4) ) ).

cnf(i_0_5128,axiom,
    ( esk15451_4(X1,X2,X3,X4)
    | ~ esk15467_4(X1,X2,X3,X4)
    | esk15413_4(X1,X2,X3,X4) ) ).

cnf(i_0_5129,axiom,
    ( esk3496_4(X1,X2,X3,X4)
    | esk3497_4(X1,X2,X3,X4) ) ).

cnf(i_0_5130,axiom,
    ( esk1931_4(X1,X2,X3,X4)
    | ~ esk1904_4(X1,X2,X3,X4) ) ).

cnf(i_0_5131,axiom,
    ( esk7778_4(X1,X2,X3,X4)
    | ~ esk7744_4(X1,X2,X3,X4) ) ).

cnf(i_0_5132,axiom,
    ( esk7231_4(X1,X2,X3,X4)
    | ~ esk7263_4(X1,X2,X3,X4)
    | esk7262_4(X1,X2,X3,X4) ) ).

cnf(i_0_5133,axiom,
    ( ~ esk15432_4(X1,X2,X3,X4)
    | esk15431_4(X1,X2,X3,X4) ) ).

cnf(i_0_5134,axiom,
    ( ~ esk6882_4(X1,X2,X3,X4)
    | ~ esk6902_4(X1,X2,X3,X4)
    | ~ esk6988_4(X1,X2,X3,X4) ) ).

cnf(i_0_5135,axiom,
    ( esk2569_4(X1,X2,X3,X4)
    | esk2599_4(X1,X2,X3,X4) ) ).

cnf(i_0_5136,axiom,
    ( esk11893_4(X1,X2,X3,X4)
    | esk11858_4(X1,X2,X3,X4) ) ).

cnf(i_0_5137,axiom,
    ( ~ esk5707_4(X1,X2,X3,X4)
    | esk5708_4(X1,X2,X3,X4) ) ).

cnf(i_0_5138,axiom,
    ( ~ esk6232_4(X1,X2,X3,X4)
    | ~ esk6242_4(X1,X2,X3,X4) ) ).

cnf(i_0_5139,axiom,
    ( esk5903_4(X1,X2,X3,X4)
    | ~ esk6161_4(X1,X2,X3,X4) ) ).

cnf(i_0_5140,axiom,
    ( esk8227_4(X1,X2,X3,X4)
    | ~ esk7969_4(X1,X2,X3,X4) ) ).

cnf(i_0_5141,axiom,
    ( ~ esk6059_4(X1,X2,X3,X4)
    | ~ esk6155_4(X1,X2,X3,X4)
    | esk6053_4(X1,X2,X3,X4) ) ).

cnf(i_0_5142,axiom,
    ( ~ esk9235_4(X1,X2,X3,X4)
    | ~ esk9202_4(X1,X2,X3,X4)
    | ~ esk9193_4(X1,X2,X3,X4) ) ).

cnf(i_0_5143,axiom,
    ( esk15380_4(X1,X2,X3,X4)
    | esk15361_4(X1,X2,X3,X4) ) ).

cnf(i_0_5144,axiom,
    ( ~ esk11829_4(X1,X2,X3,X4)
    | esk11708_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4) ) ).

cnf(i_0_5145,axiom,
    ( esk12761_4(X1,X2,X3,X4)
    | ~ esk12763_4(X1,X2,X3,X4) ) ).

cnf(i_0_5146,axiom,
    ( esk7245_4(X1,X2,X3,X4)
    | ~ esk7191_4(X1,X2,X3,X4)
    | esk7226_4(X1,X2,X3,X4) ) ).

cnf(i_0_5147,axiom,
    ( ~ esk16183_4(X1,X2,X3,X4)
    | esk16123_4(X1,X2,X3,X4) ) ).

cnf(i_0_5148,axiom,
    ( ~ esk8087_4(X1,X2,X3,X4)
    | ~ esk8117_4(X1,X2,X3,X4) ) ).

cnf(i_0_5149,axiom,
    ( esk4515_4(X1,X2,X3,X4)
    | ~ esk4514_4(X1,X2,X3,X4)
    | ~ esk4520_4(X1,X2,X3,X4) ) ).

cnf(i_0_5150,axiom,
    ( esk4947_4(X1,X2,X3,X4)
    | esk4866_4(X1,X2,X3,X4)
    | ~ esk4954_4(X1,X2,X3,X4) ) ).

cnf(i_0_5151,axiom,
    ( esk4064_4(X1,X2,X3,X4)
    | esk4097_4(X1,X2,X3,X4) ) ).

cnf(i_0_5152,axiom,
    ( esk16216_4(X1,X2,X3,X4)
    | esk16196_4(X1,X2,X3,X4) ) ).

cnf(i_0_5153,axiom,
    ( esk971_4(X1,X2,X3,X4)
    | esk991_4(X1,X2,X3,X4) ) ).

cnf(i_0_5154,axiom,
    ( ~ esk13137_4(X1,X2,X3,X4)
    | ~ esk13136_4(X1,X2,X3,X4) ) ).

cnf(i_0_5155,axiom,
    ( esk9704_4(X1,X2,X3,X4)
    | esk9715_4(X1,X2,X3,X4) ) ).

cnf(i_0_5156,axiom,
    ( esk8493_4(X1,X2,X3,X4)
    | ~ esk8751_4(X1,X2,X3,X4) ) ).

cnf(i_0_5157,axiom,
    ( ~ esk9942_4(X1,X2,X3,X4)
    | ~ esk9943_4(X1,X2,X3,X4) ) ).

cnf(i_0_5158,axiom,
    ( esk5902_4(X1,X2,X3,X4)
    | esk5869_4(X1,X2,X3,X4) ) ).

cnf(i_0_5159,axiom,
    ( esk4729_4(X1,X2,X3,X4)
    | ~ esk4760_4(X1,X2,X3,X4) ) ).

cnf(i_0_5160,axiom,
    ( esk12804_4(X1,X2,X3,X4)
    | esk12785_4(X1,X2,X3,X4) ) ).

cnf(i_0_5161,axiom,
    ( ~ esk8994_4(X1,X2,X3,X4)
    | esk8736_4(X1,X2,X3,X4) ) ).

cnf(i_0_5162,axiom,
    ( esk1539_4(X1,X2,X3,X4)
    | ~ esk1417_4(X1,X2,X3,X4) ) ).

cnf(i_0_5163,axiom,
    ( esk4912_4(X1,X2,X3,X4)
    | esk4910_4(X1,X2,X3,X4) ) ).

cnf(i_0_5164,axiom,
    ( esk16427_4(X1,X2,X3,X4)
    | ~ esk16329_4(X1,X2,X3,X4) ) ).

cnf(i_0_5165,axiom,
    ( esk11592_4(X1,X2,X3,X4)
    | esk11617_4(X1,X2,X3,X4)
    | ~ esk11566_4(X1,X2,X3,X4) ) ).

cnf(i_0_5166,axiom,
    ( ~ esk2087_4(X1,X2,X3,X4)
    | ~ esk2079_4(X1,X2,X3,X4) ) ).

cnf(i_0_5167,axiom,
    ( esk9822_4(X1,X2,X3,X4)
    | esk9737_4(X1,X2,X3,X4) ) ).

cnf(i_0_5168,axiom,
    ( esk6571_4(X1,X2,X3,X4)
    | ~ esk6551_4(X1,X2,X3,X4) ) ).

cnf(i_0_5169,axiom,
    ( esk11362_4(X1,X2,X3,X4)
    | ~ esk11364_4(X1,X2,X3,X4) ) ).

cnf(i_0_5170,axiom,
    ( ~ esk15304_4(X1,X2,X3,X4)
    | esk15274_4(X1,X2,X3,X4) ) ).

cnf(i_0_5171,axiom,
    ( esk8483_4(X1,X2,X3,X4)
    | ~ esk8408_4(X1,X2,X3,X4) ) ).

cnf(i_0_5172,axiom,
    ( ~ esk16195_4(X1,X2,X3,X4)
    | esk16117_4(X1,X2,X3,X4) ) ).

cnf(i_0_5173,axiom,
    ( ~ esk3301_4(X1,X2,X3,X4)
    | ~ esk3334_4(X1,X2,X3,X4)
    | ~ esk3282_4(X1,X2,X3,X4) ) ).

cnf(i_0_5174,axiom,
    ( esk4829_4(X1,X2,X3,X4)
    | esk4822_4(X1,X2,X3,X4) ) ).

cnf(i_0_5175,axiom,
    ( esk11849_4(X1,X2,X3,X4)
    | esk11823_4(X1,X2,X3,X4)
    | ~ esk11874_4(X1,X2,X3,X4) ) ).

cnf(i_0_5176,axiom,
    ( esk2352_4(X1,X2,X3,X4)
    | esk2375_4(X1,X2,X3,X4)
    | ~ esk2292_4(X1,X2,X3,X4) ) ).

cnf(i_0_5177,axiom,
    ( ~ esk9284_4(X1,X2,X3,X4)
    | ~ esk9275_4(X1,X2,X3,X4) ) ).

cnf(i_0_5178,axiom,
    ( esk13135_4(X1,X2,X3,X4)
    | esk13136_4(X1,X2,X3,X4)
    | ~ esk13157_4(X1,X2,X3,X4) ) ).

cnf(i_0_5179,axiom,
    ( ~ esk14508_4(X1,X2,X3,X4)
    | esk14659_4(X1,X2,X3,X4) ) ).

cnf(i_0_5180,axiom,
    ( ~ esk14328_4(X1,X2,X3,X4)
    | ~ esk14345_4(X1,X2,X3,X4)
    | ~ esk14344_4(X1,X2,X3,X4) ) ).

cnf(i_0_5181,axiom,
    ( ~ esk377_4(X1,X2,X3,X4)
    | ~ esk407_4(X1,X2,X3,X4) ) ).

cnf(i_0_5182,axiom,
    ( esk6454_4(X1,X2,X3,X4)
    | esk6424_4(X1,X2,X3,X4) ) ).

cnf(i_0_5183,axiom,
    ( esk10073_4(X1,X2,X3,X4)
    | ~ esk10052_4(X1,X2,X3,X4)
    | esk10051_4(X1,X2,X3,X4) ) ).

cnf(i_0_5184,axiom,
    ( esk2944_4(X1,X2,X3,X4)
    | esk2974_4(X1,X2,X3,X4)
    | ~ esk3101_4(X1,X2,X3,X4) ) ).

cnf(i_0_5185,axiom,
    ( ~ esk11188_4(X1,X2,X3,X4)
    | esk11166_4(X1,X2,X3,X4) ) ).

cnf(i_0_5186,axiom,
    ( esk13769_4(X1,X2,X3,X4)
    | ~ esk13750_4(X1,X2,X3,X4) ) ).

cnf(i_0_5187,axiom,
    ( ~ esk12321_4(X1,X2,X3,X4)
    | esk12220_4(X1,X2,X3,X4)
    | ~ esk12227_4(X1,X2,X3,X4) ) ).

cnf(i_0_5188,axiom,
    ( esk2775_4(X1,X2,X3,X4)
    | esk2808_4(X1,X2,X3,X4) ) ).

cnf(i_0_5189,axiom,
    ( esk13255_4(X1,X2,X3,X4)
    | ~ esk13241_4(X1,X2,X3,X4) ) ).

cnf(i_0_5190,axiom,
    ( ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15929_4(X1,X2,X3,X4)
    | ~ esk15896_4(X1,X2,X3,X4) ) ).

cnf(i_0_5191,axiom,
    ( ~ esk11970_4(X1,X2,X3,X4)
    | ~ esk12072_4(X1,X2,X3,X4)
    | esk11952_4(X1,X2,X3,X4) ) ).

cnf(i_0_5192,axiom,
    ( esk10327_4(X1,X2,X3,X4)
    | ~ esk10273_4(X1,X2,X3,X4) ) ).

cnf(i_0_5193,axiom,
    ( ~ esk13255_4(X1,X2,X3,X4)
    | ~ esk13365_4(X1,X2,X3,X4)
    | esk13241_4(X1,X2,X3,X4) ) ).

cnf(i_0_5194,axiom,
    ( ~ esk12053_4(X1,X2,X3,X4)
    | ~ esk12004_4(X1,X2,X3,X4)
    | ~ esk12054_4(X1,X2,X3,X4) ) ).

cnf(i_0_5195,axiom,
    ( ~ esk9650_4(X1,X2,X3,X4)
    | esk9751_4(X1,X2,X3,X4) ) ).

cnf(i_0_5196,axiom,
    ( ~ esk1812_4(X1,X2,X3,X4)
    | ~ esk1819_4(X1,X2,X3,X4)
    | ~ esk1721_4(X1,X2,X3,X4) ) ).

cnf(i_0_5197,axiom,
    ( ~ esk11319_4(X1,X2,X3,X4)
    | esk11320_4(X1,X2,X3,X4) ) ).

cnf(i_0_5198,axiom,
    ( esk2081_4(X1,X2,X3,X4)
    | esk2109_4(X1,X2,X3,X4) ) ).

cnf(i_0_5199,axiom,
    ( esk16219_4(X1,X2,X3,X4)
    | esk16220_4(X1,X2,X3,X4)
    | ~ esk16241_4(X1,X2,X3,X4) ) ).

cnf(i_0_5200,axiom,
    ( esk277_0
    | ~ esk519_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1)
    | ~ p(X4)
    | ~ p(X2) ) ).

cnf(i_0_5201,axiom,
    ( esk14061_4(X1,X2,X3,X4)
    | esk14108_4(X1,X2,X3,X4) ) ).

cnf(i_0_5202,axiom,
    ( esk15054_4(X1,X2,X3,X4)
    | ~ esk15049_4(X1,X2,X3,X4) ) ).

cnf(i_0_5203,axiom,
    ( ~ esk6436_4(X1,X2,X3,X4)
    | esk6437_4(X1,X2,X3,X4) ) ).

cnf(i_0_5204,axiom,
    ( ~ esk5269_4(X1,X2,X3,X4)
    | esk5388_4(X1,X2,X3,X4) ) ).

cnf(i_0_5205,axiom,
    ( esk9722_4(X1,X2,X3,X4)
    | esk9700_4(X1,X2,X3,X4) ) ).

cnf(i_0_5206,axiom,
    ( esk15934_4(X1,X2,X3,X4)
    | ~ esk16192_4(X1,X2,X3,X4) ) ).

cnf(i_0_5207,axiom,
    ( esk9400_4(X1,X2,X3,X4)
    | ~ esk9395_4(X1,X2,X3,X4) ) ).

cnf(i_0_5208,axiom,
    ( esk5338_4(X1,X2,X3,X4)
    | esk5363_4(X1,X2,X3,X4) ) ).

cnf(i_0_5209,axiom,
    ( esk9819_4(X1,X2,X3,X4)
    | esk9791_4(X1,X2,X3,X4) ) ).

cnf(i_0_5210,axiom,
    ( ~ esk14277_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4) ) ).

cnf(i_0_5211,axiom,
    ( ~ esk15415_4(X1,X2,X3,X4)
    | ~ esk15451_4(X1,X2,X3,X4)
    | ~ esk15450_4(X1,X2,X3,X4) ) ).

cnf(i_0_5212,axiom,
    ( esk7359_4(X1,X2,X3,X4)
    | esk7357_4(X1,X2,X3,X4) ) ).

cnf(i_0_5213,axiom,
    ( ~ esk15568_4(X1,X2,X3,X4)
    | esk15556_4(X1,X2,X3,X4)
    | ~ esk15682_4(X1,X2,X3,X4) ) ).

cnf(i_0_5214,axiom,
    ( esk15704_4(X1,X2,X3,X4)
    | esk15678_4(X1,X2,X3,X4)
    | ~ esk15729_4(X1,X2,X3,X4) ) ).

cnf(i_0_5215,axiom,
    ( ~ esk5898_4(X1,X2,X3,X4)
    | ~ esk5802_4(X1,X2,X3,X4)
    | esk5796_4(X1,X2,X3,X4) ) ).

cnf(i_0_5216,axiom,
    ( ~ esk12040_4(X1,X2,X3,X4)
    | ~ esk12022_4(X1,X2,X3,X4)
    | ~ esk12127_4(X1,X2,X3,X4) ) ).

cnf(i_0_5217,axiom,
    ( ~ esk10038_4(X1,X2,X3,X4)
    | ~ esk9913_4(X1,X2,X3,X4) ) ).

cnf(i_0_5218,axiom,
    ( esk14895_4(X1,X2,X3,X4)
    | ~ esk14939_4(X1,X2,X3,X4)
    | esk14946_4(X1,X2,X3,X4) ) ).

cnf(i_0_5219,axiom,
    ( esk14646_4(X1,X2,X3,X4)
    | ~ esk14388_4(X1,X2,X3,X4) ) ).

cnf(i_0_5220,axiom,
    ( esk15637_4(X1,X2,X3,X4)
    | esk15609_4(X1,X2,X3,X4) ) ).

cnf(i_0_5221,axiom,
    ( esk842_4(X1,X2,X3,X4)
    | ~ esk754_4(X1,X2,X3,X4)
    | esk835_4(X1,X2,X3,X4) ) ).

cnf(i_0_5222,axiom,
    ( esk10469_4(X1,X2,X3,X4)
    | esk10498_4(X1,X2,X3,X4) ) ).

cnf(i_0_5223,axiom,
    ( ~ esk13021_4(X1,X2,X3,X4)
    | ~ esk13003_4(X1,X2,X3,X4) ) ).

cnf(i_0_5224,axiom,
    ( esk12304_4(X1,X2,X3,X4)
    | esk12264_4(X1,X2,X3,X4) ) ).

cnf(i_0_5225,axiom,
    ( ~ esk5019_4(X1,X2,X3,X4)
    | esk4984_4(X1,X2,X3,X4) ) ).

cnf(i_0_5226,axiom,
    ( esk15379_4(X1,X2,X3,X4)
    | esk15353_4(X1,X2,X3,X4) ) ).

cnf(i_0_5227,axiom,
    ( ~ esk10163_4(X1,X2,X3,X4)
    | esk10263_4(X1,X2,X3,X4) ) ).

cnf(i_0_5228,axiom,
    ( esk3451_4(X1,X2,X3,X4)
    | ~ esk3483_4(X1,X2,X3,X4) ) ).

cnf(i_0_5229,axiom,
    ( ~ esk12985_4(X1,X2,X3,X4)
    | esk13110_4(X1,X2,X3,X4) ) ).

cnf(i_0_5230,axiom,
    ( ~ esk1742_4(X1,X2,X3,X4)
    | ~ esk1741_4(X1,X2,X3,X4) ) ).

cnf(i_0_5231,axiom,
    ( ~ esk6978_4(X1,X2,X3,X4)
    | ~ esk6977_4(X1,X2,X3,X4) ) ).

cnf(i_0_5232,axiom,
    ( esk6199_4(X1,X2,X3,X4)
    | esk6213_4(X1,X2,X3,X4) ) ).

cnf(i_0_5233,axiom,
    ( ~ esk8614_4(X1,X2,X3,X4)
    | esk8629_4(X1,X2,X3,X4) ) ).

cnf(i_0_5234,axiom,
    ( esk1027_4(X1,X2,X3,X4)
    | esk994_4(X1,X2,X3,X4) ) ).

cnf(i_0_5235,axiom,
    ( ~ esk11339_4(X1,X2,X3,X4)
    | ~ esk11331_4(X1,X2,X3,X4) ) ).

cnf(i_0_5236,axiom,
    esk3229_4(X1,X2,X3,X4) ).

cnf(i_0_5237,axiom,
    ( esk6873_4(X1,X2,X3,X4)
    | esk6895_4(X1,X2,X3,X4) ) ).

cnf(i_0_5238,axiom,
    ( ~ esk4287_4(X1,X2,X3,X4)
    | esk4545_4(X1,X2,X3,X4) ) ).

cnf(i_0_5239,axiom,
    ( esk2304_4(X1,X2,X3,X4)
    | ~ esk2185_4(X1,X2,X3,X4) ) ).

cnf(i_0_5240,axiom,
    ( esk13909_4(X1,X2,X3,X4)
    | esk13908_4(X1,X2,X3,X4) ) ).

cnf(i_0_5241,axiom,
    ( esk9522_4(X1,X2,X3,X4)
    | esk9430_4(X1,X2,X3,X4)
    | esk9529_4(X1,X2,X3,X4) ) ).

cnf(i_0_5242,axiom,
    ( ~ esk12356_4(X1,X2,X3,X4)
    | ~ esk12258_4(X1,X2,X3,X4)
    | ~ esk12349_4(X1,X2,X3,X4) ) ).

cnf(i_0_5243,axiom,
    ( ~ esk10833_4(X1,X2,X3,X4)
    | ~ esk10831_4(X1,X2,X3,X4) ) ).

cnf(i_0_5244,axiom,
    ( ~ esk14761_4(X1,X2,X3,X4)
    | esk14789_4(X1,X2,X3,X4) ) ).

cnf(i_0_5245,axiom,
    ( esk9322_4(X1,X2,X3,X4)
    | esk9253_4(X1,X2,X3,X4) ) ).

cnf(i_0_5246,axiom,
    ( esk15916_4(X1,X2,X3,X4)
    | ~ esk16174_4(X1,X2,X3,X4) ) ).

cnf(i_0_5247,axiom,
    ( ~ esk7393_4(X1,X2,X3,X4)
    | ~ esk7397_4(X1,X2,X3,X4)
    | ~ esk7398_4(X1,X2,X3,X4) ) ).

cnf(i_0_5248,axiom,
    ( esk15221_4(X1,X2,X3,X4)
    | ~ esk15223_4(X1,X2,X3,X4) ) ).

cnf(i_0_5249,axiom,
    ( esk10192_4(X1,X2,X3,X4)
    | ~ esk10193_4(X1,X2,X3,X4) ) ).

cnf(i_0_5250,axiom,
    ( ~ esk14282_4(X1,X2,X3,X4)
    | esk14409_4(X1,X2,X3,X4) ) ).

cnf(i_0_5251,axiom,
    ( esk11631_4(X1,X2,X3,X4)
    | esk11599_4(X1,X2,X3,X4) ) ).

cnf(i_0_5252,axiom,
    ( esk15072_4(X1,X2,X3,X4)
    | ~ esk15070_4(X1,X2,X3,X4)
    | ~ esk15071_4(X1,X2,X3,X4) ) ).

cnf(i_0_5253,axiom,
    ( esk14723_4(X1,X2,X3,X4)
    | esk14713_4(X1,X2,X3,X4) ) ).

cnf(i_0_5254,axiom,
    ( esk10592_4(X1,X2,X3,X4)
    | ~ esk10562_4(X1,X2,X3,X4) ) ).

cnf(i_0_5255,axiom,
    ( esk13636_4(X1,X2,X3,X4)
    | esk13511_4(X1,X2,X3,X4) ) ).

cnf(i_0_5256,axiom,
    ( ~ esk14124_4(X1,X2,X3,X4)
    | ~ esk14168_4(X1,X2,X3,X4)
    | ~ esk14175_4(X1,X2,X3,X4) ) ).

cnf(i_0_5257,axiom,
    ( ~ esk3241_4(X1,X2,X3,X4)
    | esk3250_4(X1,X2,X3,X4) ) ).

cnf(i_0_5258,axiom,
    ( esk9919_4(X1,X2,X3,X4)
    | ~ esk9661_4(X1,X2,X3,X4) ) ).

cnf(i_0_5259,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12220_4(X1,X2,X3,X4) ) ).

cnf(i_0_5260,axiom,
    ( esk2102_4(X1,X2,X3,X4)
    | ~ esk2101_4(X1,X2,X3,X4) ) ).

cnf(i_0_5261,axiom,
    ( esk1467_4(X1,X2,X3,X4)
    | esk1516_4(X1,X2,X3,X4) ) ).

cnf(i_0_5262,axiom,
    ( ~ esk7766_4(X1,X2,X3,X4)
    | ~ esk7681_4(X1,X2,X3,X4)
    | ~ esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_5263,axiom,
    ( esk12013_4(X1,X2,X3,X4)
    | ~ esk12067_4(X1,X2,X3,X4) ) ).

cnf(i_0_5264,axiom,
    ( esk4432_4(X1,X2,X3,X4)
    | ~ esk4407_4(X1,X2,X3,X4)
    | esk4406_4(X1,X2,X3,X4) ) ).

cnf(i_0_5265,axiom,
    ( ~ esk13112_4(X1,X2,X3,X4)
    | esk13166_4(X1,X2,X3,X4) ) ).

cnf(i_0_5266,axiom,
    ( esk10247_4(X1,X2,X3,X4)
    | esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_5267,axiom,
    ( esk10332_4(X1,X2,X3,X4)
    | esk10249_4(X1,X2,X3,X4) ) ).

cnf(i_0_5268,axiom,
    ( esk14055_4(X1,X2,X3,X4)
    | ~ esk14051_4(X1,X2,X3,X4)
    | esk14031_4(X1,X2,X3,X4) ) ).

cnf(i_0_5269,axiom,
    ( ~ esk2929_4(X1,X2,X3,X4)
    | esk2962_4(X1,X2,X3,X4) ) ).

cnf(i_0_5270,axiom,
    ( esk16236_4(X1,X2,X3,X4)
    | esk16222_4(X1,X2,X3,X4) ) ).

cnf(i_0_5271,axiom,
    ( ~ esk422_4(X1,X2,X3,X4)
    | ~ esk421_4(X1,X2,X3,X4)
    | esk423_4(X1,X2,X3,X4) ) ).

cnf(i_0_5272,axiom,
    ( ~ esk8389_4(X1,X2,X3,X4)
    | ~ esk8388_4(X1,X2,X3,X4)
    | esk8390_4(X1,X2,X3,X4) ) ).

cnf(i_0_5273,axiom,
    ( esk5981_4(X1,X2,X3,X4)
    | ~ esk5962_4(X1,X2,X3,X4)
    | esk5910_4(X1,X2,X3,X4) ) ).

cnf(i_0_5274,axiom,
    ( ~ esk1844_4(X1,X2,X3,X4)
    | ~ esk1830_4(X1,X2,X3,X4) ) ).

cnf(i_0_5275,axiom,
    ( ~ esk11933_4(X1,X2,X3,X4)
    | esk11963_4(X1,X2,X3,X4) ) ).

cnf(i_0_5276,axiom,
    ( esk1737_4(X1,X2,X3,X4)
    | esk1747_4(X1,X2,X3,X4) ) ).

cnf(i_0_5277,axiom,
    ( ~ esk6856_4(X1,X2,X3,X4)
    | esk6855_4(X1,X2,X3,X4) ) ).

cnf(i_0_5278,axiom,
    ( esk14805_4(X1,X2,X3,X4)
    | esk14808_4(X1,X2,X3,X4)
    | esk14811_4(X1,X2,X3,X4)
    | esk14809_4(X1,X2,X3,X4) ) ).

cnf(i_0_5279,axiom,
    ( ~ esk3858_4(X1,X2,X3,X4)
    | ~ esk3881_4(X1,X2,X3,X4) ) ).

cnf(i_0_5280,axiom,
    ( ~ esk13607_4(X1,X2,X3,X4)
    | esk13556_4(X1,X2,X3,X4) ) ).

cnf(i_0_5281,axiom,
    ( esk15057_4(X1,X2,X3,X4)
    | ~ esk15054_4(X1,X2,X3,X4) ) ).

cnf(i_0_5282,axiom,
    ( esk6231_4(X1,X2,X3,X4)
    | ~ esk6206_4(X1,X2,X3,X4)
    | esk6205_4(X1,X2,X3,X4) ) ).

cnf(i_0_5283,axiom,
    ( ~ esk15984_4(X1,X2,X3,X4)
    | ~ esk15899_4(X1,X2,X3,X4)
    | ~ esk15877_4(X1,X2,X3,X4) ) ).

cnf(i_0_5284,axiom,
    ( esk5083_4(X1,X2,X3,X4)
    | esk5107_4(X1,X2,X3,X4) ) ).

cnf(i_0_5285,axiom,
    ( ~ esk12617_4(X1,X2,X3,X4)
    | esk12572_4(X1,X2,X3,X4) ) ).

cnf(i_0_5286,axiom,
    ( ~ esk4280_4(X1,X2,X3,X4)
    | ~ esk4281_4(X1,X2,X3,X4)
    | esk4282_4(X1,X2,X3,X4) ) ).

cnf(i_0_5287,axiom,
    ( esk5611_4(X1,X2,X3,X4)
    | esk5588_4(X1,X2,X3,X4) ) ).

cnf(i_0_5288,axiom,
    ( ~ p(X2)
    | p(X1)
    | esk16685_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk98_0
    | p(X3) ) ).

cnf(i_0_5289,axiom,
    ( p(X1)
    | ~ esk16711_4(X1,X2,X3,X4)
    | p(X4)
    | esk292_0
    | p(X3)
    | ~ p(X2) ) ).

cnf(i_0_5290,axiom,
    ( ~ esk7258_4(X1,X2,X3,X4)
    | ~ esk7235_4(X1,X2,X3,X4)
    | ~ esk7175_4(X1,X2,X3,X4) ) ).

cnf(i_0_5291,axiom,
    ( esk16699_4(X1,X2,X3,X4)
    | ~ esk16636_4(X1,X2,X3,X4) ) ).

cnf(i_0_5292,axiom,
    ( esk6985_4(X1,X2,X3,X4)
    | ~ esk6984_4(X1,X2,X3,X4) ) ).

cnf(i_0_5293,axiom,
    ( esk14451_4(X1,X2,X3,X4)
    | ~ esk14452_4(X1,X2,X3,X4) ) ).

cnf(i_0_5294,axiom,
    ( ~ esk14944_4(X1,X2,X3,X4)
    | ~ esk14945_4(X1,X2,X3,X4) ) ).

cnf(i_0_5295,axiom,
    ( ~ esk3865_4(X1,X2,X3,X4)
    | esk3866_4(X1,X2,X3,X4)
    | ~ esk3864_4(X1,X2,X3,X4) ) ).

cnf(i_0_5296,axiom,
    ( esk881_4(X1,X2,X3,X4)
    | ~ esk913_4(X1,X2,X3,X4) ) ).

cnf(i_0_5297,axiom,
    ( esk6417_4(X1,X2,X3,X4)
    | ~ esk6675_4(X1,X2,X3,X4) ) ).

cnf(i_0_5298,axiom,
    ( ~ esk6290_4(X1,X2,X3,X4)
    | ~ esk6318_4(X1,X2,X3,X4) ) ).

cnf(i_0_5299,axiom,
    ( ~ esk2895_4(X1,X2,X3,X4)
    | esk2861_4(X1,X2,X3,X4)
    | esk2814_4(X1,X2,X3,X4) ) ).

cnf(i_0_5300,axiom,
    ( esk5081_4(X1,X2,X3,X4)
    | esk5114_4(X1,X2,X3,X4) ) ).

cnf(i_0_5301,axiom,
    ( ~ esk6443_4(X1,X2,X3,X4)
    | esk6441_4(X1,X2,X3,X4) ) ).

cnf(i_0_5302,axiom,
    ( esk12471_4(X1,X2,X3,X4)
    | ~ esk12438_4(X1,X2,X3,X4) ) ).

cnf(i_0_5303,axiom,
    ( ~ esk15747_4(X1,X2,X3,X4)
    | ~ esk15676_4(X1,X2,X3,X4)
    | ~ esk15728_4(X1,X2,X3,X4) ) ).

cnf(i_0_5304,axiom,
    ( ~ esk5519_4(X1,X2,X3,X4)
    | ~ esk5547_4(X1,X2,X3,X4) ) ).

cnf(i_0_5305,axiom,
    ( p(X4)
    | esk33_0
    | p(X1)
    | ~ esk16605_4(X1,X2,X3,X4)
    | p(X2)
    | p(X3) ) ).

cnf(i_0_5306,axiom,
    ( esk5652_4(X1,X2,X3,X4)
    | ~ esk5583_4(X1,X2,X3,X4) ) ).

cnf(i_0_5307,axiom,
    ( ~ esk15866_4(X1,X2,X3,X4)
    | esk15926_4(X1,X2,X3,X4) ) ).

cnf(i_0_5308,axiom,
    ( ~ esk14796_4(X1,X2,X3,X4)
    | esk14916_4(X1,X2,X3,X4) ) ).

cnf(i_0_5309,axiom,
    ( ~ esk4878_4(X1,X2,X3,X4)
    | esk4913_4(X1,X2,X3,X4)
    | esk4932_4(X1,X2,X3,X4) ) ).

cnf(i_0_5310,axiom,
    ( esk9726_4(X1,X2,X3,X4)
    | esk9707_4(X1,X2,X3,X4) ) ).

cnf(i_0_5311,axiom,
    ( esk5597_4(X1,X2,X3,X4)
    | esk5609_4(X1,X2,X3,X4) ) ).

cnf(i_0_5312,axiom,
    ( ~ esk14155_4(X1,X2,X3,X4)
    | ~ esk14156_4(X1,X2,X3,X4) ) ).

cnf(i_0_5313,axiom,
    ( esk12500_4(X1,X2,X3,X4)
    | ~ esk12494_4(X1,X2,X3,X4) ) ).

cnf(i_0_5314,axiom,
    ( esk7394_4(X1,X2,X3,X4)
    | esk7340_4(X1,X2,X3,X4)
    | esk7374_4(X1,X2,X3,X4) ) ).

cnf(i_0_5315,axiom,
    ( ~ esk12088_4(X1,X2,X3,X4)
    | ~ esk12089_4(X1,X2,X3,X4)
    | esk12090_4(X1,X2,X3,X4) ) ).

cnf(i_0_5316,axiom,
    ( ~ esk8774_4(X1,X2,X3,X4)
    | esk8803_4(X1,X2,X3,X4)
    | esk8723_4(X1,X2,X3,X4) ) ).

cnf(i_0_5317,axiom,
    ( esk12501_4(X1,X2,X3,X4)
    | ~ esk12502_4(X1,X2,X3,X4) ) ).

cnf(i_0_5318,axiom,
    ( ~ esk14799_4(X1,X2,X3,X4)
    | ~ esk14747_4(X1,X2,X3,X4) ) ).

cnf(i_0_5319,axiom,
    ( ~ esk5428_4(X1,X2,X3,X4)
    | ~ esk5430_4(X1,X2,X3,X4) ) ).

cnf(i_0_5320,axiom,
    ( ~ esk4003_4(X1,X2,X3,X4)
    | esk3979_4(X1,X2,X3,X4) ) ).

cnf(i_0_5321,axiom,
    ( esk16136_4(X1,X2,X3,X4)
    | esk16134_4(X1,X2,X3,X4) ) ).

cnf(i_0_5322,axiom,
    ( ~ esk4504_4(X1,X2,X3,X4)
    | esk4517_4(X1,X2,X3,X4) ) ).

cnf(i_0_5323,axiom,
    ( esk10700_4(X1,X2,X3,X4)
    | esk10695_4(X1,X2,X3,X4)
    | ~ esk10701_4(X1,X2,X3,X4) ) ).

cnf(i_0_5324,axiom,
    ( esk14205_4(X1,X2,X3,X4)
    | esk14162_4(X1,X2,X3,X4) ) ).

cnf(i_0_5325,axiom,
    ( ~ esk8015_4(X1,X2,X3,X4)
    | esk8013_4(X1,X2,X3,X4) ) ).

cnf(i_0_5326,axiom,
    ( ~ esk5125_4(X1,X2,X3,X4)
    | esk4867_4(X1,X2,X3,X4) ) ).

cnf(i_0_5327,axiom,
    ( esk2768_4(X1,X2,X3,X4)
    | esk2771_4(X1,X2,X3,X4) ) ).

cnf(i_0_5328,axiom,
    ( esk6059_4(X1,X2,X3,X4)
    | ~ esk6047_4(X1,X2,X3,X4) ) ).

cnf(i_0_5329,axiom,
    ( esk14813_4(X1,X2,X3,X4)
    | ~ esk14812_4(X1,X2,X3,X4) ) ).

cnf(i_0_5330,axiom,
    ( ~ esk5702_4(X1,X2,X3,X4)
    | esk5701_4(X1,X2,X3,X4) ) ).

cnf(i_0_5331,axiom,
    ( esk4260_4(X1,X2,X3,X4)
    | ~ esk4252_4(X1,X2,X3,X4) ) ).

cnf(i_0_5332,axiom,
    ( esk5546_4(X1,X2,X3,X4)
    | esk5494_4(X1,X2,X3,X4) ) ).

cnf(i_0_5333,axiom,
    ( ~ esk3549_4(X1,X2,X3,X4)
    | ~ esk3672_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_5334,axiom,
    ( esk10511_4(X1,X2,X3,X4)
    | esk10462_4(X1,X2,X3,X4) ) ).

cnf(i_0_5335,axiom,
    ( ~ esk15083_4(X1,X2,X3,X4)
    | esk15079_4(X1,X2,X3,X4) ) ).

cnf(i_0_5336,axiom,
    ( esk3510_4(X1,X2,X3,X4)
    | ~ esk3511_4(X1,X2,X3,X4) ) ).

cnf(i_0_5337,axiom,
    ( esk430_4(X1,X2,X3,X4)
    | ~ esk410_4(X1,X2,X3,X4) ) ).

cnf(i_0_5338,axiom,
    ( ~ esk9422_4(X1,X2,X3,X4)
    | esk9421_4(X1,X2,X3,X4) ) ).

cnf(i_0_5339,axiom,
    ( ~ esk10955_4(X1,X2,X3,X4)
    | esk10959_4(X1,X2,X3,X4) ) ).

cnf(i_0_5340,axiom,
    ( esk12248_4(X1,X2,X3,X4)
    | ~ esk12234_4(X1,X2,X3,X4) ) ).

cnf(i_0_5341,axiom,
    ( ~ esk919_4(X1,X2,X3,X4)
    | esk906_4(X1,X2,X3,X4)
    | ~ esk1031_4(X1,X2,X3,X4) ) ).

cnf(i_0_5342,axiom,
    ( esk4847_4(X1,X2,X3,X4)
    | esk4824_4(X1,X2,X3,X4) ) ).

cnf(i_0_5343,axiom,
    ( esk10026_4(X1,X2,X3,X4)
    | esk10049_4(X1,X2,X3,X4) ) ).

cnf(i_0_5344,axiom,
    ( esk14606_4(X1,X2,X3,X4)
    | esk14583_4(X1,X2,X3,X4) ) ).

cnf(i_0_5345,axiom,
    ( esk3856_4(X1,X2,X3,X4)
    | esk3925_4(X1,X2,X3,X4) ) ).

cnf(i_0_5346,axiom,
    ( esk15130_4(X1,X2,X3,X4)
    | esk15092_4(X1,X2,X3,X4) ) ).

cnf(i_0_5347,axiom,
    ( esk4774_4(X1,X2,X3,X4)
    | ~ esk4763_4(X1,X2,X3,X4) ) ).

cnf(i_0_5348,axiom,
    ( esk13150_4(X1,X2,X3,X4)
    | ~ esk13151_4(X1,X2,X3,X4) ) ).

cnf(i_0_5349,axiom,
    ( esk1101_4(X1,X2,X3,X4)
    | esk1079_4(X1,X2,X3,X4) ) ).

cnf(i_0_5350,axiom,
    ( esk2584_4(X1,X2,X3,X4)
    | ~ esk2586_4(X1,X2,X3,X4)
    | esk2585_4(X1,X2,X3,X4) ) ).

cnf(i_0_5351,axiom,
    ( esk1971_4(X1,X2,X3,X4)
    | ~ esk1975_4(X1,X2,X3,X4) ) ).

cnf(i_0_5352,axiom,
    ( esk1698_4(X1,X2,X3,X4)
    | esk1697_4(X1,X2,X3,X4) ) ).

cnf(i_0_5353,axiom,
    ( ~ esk3962_4(X1,X2,X3,X4)
    | esk3985_4(X1,X2,X3,X4) ) ).

cnf(i_0_5354,axiom,
    ( esk6360_4(X1,X2,X3,X4)
    | ~ esk6411_4(X1,X2,X3,X4) ) ).

cnf(i_0_5355,axiom,
    ( esk12487_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_5356,axiom,
    ( esk6109_4(X1,X2,X3,X4)
    | esk6140_4(X1,X2,X3,X4) ) ).

cnf(i_0_5357,axiom,
    ( esk14338_4(X1,X2,X3,X4)
    | esk14333_4(X1,X2,X3,X4) ) ).

cnf(i_0_5358,axiom,
    ( esk3858_4(X1,X2,X3,X4)
    | ~ esk3733_4(X1,X2,X3,X4) ) ).

cnf(i_0_5359,axiom,
    ( ~ esk7488_4(X1,X2,X3,X4)
    | ~ esk7440_4(X1,X2,X3,X4) ) ).

cnf(i_0_5360,axiom,
    ( esk4932_4(X1,X2,X3,X4)
    | esk4846_4(X1,X2,X3,X4) ) ).

cnf(i_0_5361,axiom,
    ( esk1569_4(X1,X2,X3,X4)
    | esk1612_4(X1,X2,X3,X4) ) ).

cnf(i_0_5362,axiom,
    ( esk9180_4(X1,X2,X3,X4)
    | ~ esk9252_4(X1,X2,X3,X4) ) ).

cnf(i_0_5363,axiom,
    ( ~ esk8796_4(X1,X2,X3,X4)
    | esk8798_4(X1,X2,X3,X4)
    | ~ esk8797_4(X1,X2,X3,X4) ) ).

cnf(i_0_5364,axiom,
    ( p(X2)
    | ~ esk169_0
    | p(X4)
    | esk505_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1) ) ).

cnf(i_0_5365,axiom,
    ( ~ esk3998_4(X1,X2,X3,X4)
    | esk4119_4(X1,X2,X3,X4) ) ).

cnf(i_0_5366,axiom,
    ( esk5878_4(X1,X2,X3,X4)
    | esk5854_4(X1,X2,X3,X4) ) ).

cnf(i_0_5367,axiom,
    ( esk13316_4(X1,X2,X3,X4)
    | esk13305_4(X1,X2,X3,X4) ) ).

cnf(i_0_5368,axiom,
    ( esk6877_4(X1,X2,X3,X4)
    | ~ esk6919_4(X1,X2,X3,X4) ) ).

cnf(i_0_5369,axiom,
    ( ~ esk13114_4(X1,X2,X3,X4)
    | esk13165_4(X1,X2,X3,X4) ) ).

cnf(i_0_5370,axiom,
    ( ~ esk8590_4(X1,X2,X3,X4)
    | esk8609_4(X1,X2,X3,X4) ) ).

cnf(i_0_5371,axiom,
    ( esk7204_4(X1,X2,X3,X4)
    | esk7209_4(X1,X2,X3,X4)
    | ~ esk7205_4(X1,X2,X3,X4) ) ).

cnf(i_0_5372,axiom,
    ( esk1456_4(X1,X2,X3,X4)
    | esk1461_4(X1,X2,X3,X4)
    | ~ esk1457_4(X1,X2,X3,X4) ) ).

cnf(i_0_5373,axiom,
    ( esk2937_4(X1,X2,X3,X4)
    | ~ esk2969_4(X1,X2,X3,X4) ) ).

cnf(i_0_5374,axiom,
    ( esk9247_4(X1,X2,X3,X4)
    | ~ esk9126_4(X1,X2,X3,X4) ) ).

cnf(i_0_5375,axiom,
    ( ~ esk12070_4(X1,X2,X3,X4)
    | esk12121_4(X1,X2,X3,X4) ) ).

cnf(i_0_5376,axiom,
    ( esk6341_4(X1,X2,X3,X4)
    | ~ esk6342_4(X1,X2,X3,X4) ) ).

cnf(i_0_5377,axiom,
    ( ~ esk3384_4(X1,X2,X3,X4)
    | ~ esk3383_4(X1,X2,X3,X4)
    | esk3385_4(X1,X2,X3,X4) ) ).

cnf(i_0_5378,axiom,
    ( esk13694_4(X1,X2,X3,X4)
    | esk13588_4(X1,X2,X3,X4) ) ).

cnf(i_0_5379,axiom,
    ( esk16705_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk254_0
    | ~ p(X3)
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_5380,axiom,
    ( ~ esk666_4(X1,X2,X3,X4)
    | esk688_4(X1,X2,X3,X4) ) ).

cnf(i_0_5381,axiom,
    ( esk14164_4(X1,X2,X3,X4)
    | esk14134_4(X1,X2,X3,X4) ) ).

cnf(i_0_5382,axiom,
    ( esk3598_4(X1,X2,X3,X4)
    | ~ esk3856_4(X1,X2,X3,X4) ) ).

cnf(i_0_5383,axiom,
    ( ~ p(X4)
    | ~ esk148_0
    | ~ p(X1)
    | p(X2)
    | esk501_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_5384,axiom,
    ( ~ esk2059_4(X1,X2,X3,X4)
    | esk2111_4(X1,X2,X3,X4) ) ).

cnf(i_0_5385,axiom,
    ( ~ esk6710_4(X1,X2,X3,X4)
    | ~ esk6712_4(X1,X2,X3,X4) ) ).

cnf(i_0_5386,axiom,
    ( ~ esk6473_4(X1,X2,X3,X4)
    | esk6471_4(X1,X2,X3,X4) ) ).

cnf(i_0_5387,axiom,
    ( esk8234_4(X1,X2,X3,X4)
    | ~ esk8235_4(X1,X2,X3,X4) ) ).

cnf(i_0_5388,axiom,
    ( esk7858_4(X1,X2,X3,X4)
    | ~ esk7853_4(X1,X2,X3,X4) ) ).

cnf(i_0_5389,axiom,
    ( ~ esk14091_4(X1,X2,X3,X4)
    | ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14124_4(X1,X2,X3,X4) ) ).

cnf(i_0_5390,axiom,
    ( ~ esk9899_4(X1,X2,X3,X4)
    | esk9870_4(X1,X2,X3,X4) ) ).

cnf(i_0_5391,axiom,
    ( ~ esk10594_4(X1,X2,X3,X4)
    | esk10595_4(X1,X2,X3,X4) ) ).

cnf(i_0_5392,axiom,
    ( esk13583_4(X1,X2,X3,X4)
    | esk13562_4(X1,X2,X3,X4) ) ).

cnf(i_0_5393,axiom,
    ( esk6889_4(X1,X2,X3,X4)
    | esk6880_4(X1,X2,X3,X4) ) ).

cnf(i_0_5394,axiom,
    ( ~ esk15831_4(X1,X2,X3,X4)
    | esk15847_4(X1,X2,X3,X4) ) ).

cnf(i_0_5395,axiom,
    ( esk2505_4(X1,X2,X3,X4)
    | ~ esk2556_4(X1,X2,X3,X4) ) ).

cnf(i_0_5396,axiom,
    ( esk13426_4(X1,X2,X3,X4)
    | ~ esk13343_4(X1,X2,X3,X4)
    | esk13403_4(X1,X2,X3,X4) ) ).

cnf(i_0_5397,axiom,
    ( ~ esk2199_4(X1,X2,X3,X4)
    | esk2320_4(X1,X2,X3,X4) ) ).

cnf(i_0_5398,axiom,
    ( ~ esk13078_4(X1,X2,X3,X4)
    | ~ esk13034_4(X1,X2,X3,X4)
    | ~ esk13077_4(X1,X2,X3,X4) ) ).

cnf(i_0_5399,axiom,
    ( ~ esk8514_4(X1,X2,X3,X4)
    | esk8521_4(X1,X2,X3,X4)
    | esk8470_4(X1,X2,X3,X4) ) ).

cnf(i_0_5400,axiom,
    ( ~ esk13620_4(X1,X2,X3,X4)
    | ~ esk13512_4(X1,X2,X3,X4)
    | esk13497_4(X1,X2,X3,X4) ) ).

cnf(i_0_5401,axiom,
    ( ~ esk12535_4(X1,X2,X3,X4)
    | ~ esk12536_4(X1,X2,X3,X4) ) ).

cnf(i_0_5402,axiom,
    ( ~ esk3613_4(X1,X2,X3,X4)
    | ~ esk3488_4(X1,X2,X3,X4) ) ).

cnf(i_0_5403,axiom,
    ( esk14611_4(X1,X2,X3,X4)
    | esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_5404,axiom,
    ( ~ esk11763_4(X1,X2,X3,X4)
    | ~ esk11709_4(X1,X2,X3,X4) ) ).

cnf(i_0_5405,axiom,
    ( ~ esk1027_4(X1,X2,X3,X4)
    | esk769_4(X1,X2,X3,X4) ) ).

cnf(i_0_5406,axiom,
    ( esk8772_4(X1,X2,X3,X4)
    | esk8804_4(X1,X2,X3,X4) ) ).

cnf(i_0_5407,axiom,
    ( esk817_4(X1,X2,X3,X4)
    | ~ esk816_4(X1,X2,X3,X4) ) ).

cnf(i_0_5408,axiom,
    ( esk3528_4(X1,X2,X3,X4)
    | esk3563_4(X1,X2,X3,X4) ) ).

cnf(i_0_5409,axiom,
    ( esk12022_4(X1,X2,X3,X4)
    | esk12030_4(X1,X2,X3,X4) ) ).

cnf(i_0_5410,axiom,
    ( ~ esk5777_4(X1,X2,X3,X4)
    | ~ esk5804_4(X1,X2,X3,X4) ) ).

cnf(i_0_5411,axiom,
    ( ~ esk14565_4(X1,X2,X3,X4)
    | ~ esk14564_4(X1,X2,X3,X4)
    | esk14566_4(X1,X2,X3,X4) ) ).

cnf(i_0_5412,axiom,
    ( ~ esk5714_4(X1,X2,X3,X4)
    | esk5713_4(X1,X2,X3,X4) ) ).

cnf(i_0_5413,axiom,
    ( ~ esk10281_4(X1,X2,X3,X4)
    | esk10307_4(X1,X2,X3,X4)
    | esk10332_4(X1,X2,X3,X4) ) ).

cnf(i_0_5414,axiom,
    ( esk15700_4(X1,X2,X3,X4)
    | esk15718_4(X1,X2,X3,X4) ) ).

cnf(i_0_5415,axiom,
    ( ~ esk14723_4(X1,X2,X3,X4)
    | ~ esk14713_4(X1,X2,X3,X4) ) ).

cnf(i_0_5416,axiom,
    ( ~ esk11841_4(X1,X2,X3,X4)
    | esk11840_4(X1,X2,X3,X4) ) ).

cnf(i_0_5417,axiom,
    ( esk994_4(X1,X2,X3,X4)
    | esk969_4(X1,X2,X3,X4) ) ).

cnf(i_0_5418,axiom,
    ( esk3087_4(X1,X2,X3,X4)
    | esk3054_4(X1,X2,X3,X4) ) ).

cnf(i_0_5419,axiom,
    ( ~ esk14463_4(X1,X2,X3,X4)
    | esk14375_4(X1,X2,X3,X4)
    | esk14456_4(X1,X2,X3,X4) ) ).

cnf(i_0_5420,axiom,
    ( esk14625_4(X1,X2,X3,X4)
    | ~ esk14589_4(X1,X2,X3,X4) ) ).

cnf(i_0_5421,axiom,
    ( ~ esk979_4(X1,X2,X3,X4)
    | ~ esk965_4(X1,X2,X3,X4)
    | ~ esk978_4(X1,X2,X3,X4) ) ).

cnf(i_0_5422,axiom,
    ( esk10570_4(X1,X2,X3,X4)
    | esk10571_4(X1,X2,X3,X4) ) ).

cnf(i_0_5423,axiom,
    ( ~ esk15276_4(X1,X2,X3,X4)
    | esk15302_4(X1,X2,X3,X4) ) ).

cnf(i_0_5424,axiom,
    ( esk13814_4(X1,X2,X3,X4)
    | esk13830_4(X1,X2,X3,X4) ) ).

cnf(i_0_5425,axiom,
    ( ~ esk10952_4(X1,X2,X3,X4)
    | esk10958_4(X1,X2,X3,X4) ) ).

cnf(i_0_5426,axiom,
    ( esk14818_4(X1,X2,X3,X4)
    | ~ esk14811_4(X1,X2,X3,X4) ) ).

cnf(i_0_5427,axiom,
    ( ~ esk9227_4(X1,X2,X3,X4)
    | ~ esk9226_4(X1,X2,X3,X4)
    | ~ esk9177_4(X1,X2,X3,X4) ) ).

cnf(i_0_5428,axiom,
    ( esk13635_4(X1,X2,X3,X4)
    | esk13642_4(X1,X2,X3,X4) ) ).

cnf(i_0_5429,axiom,
    ( esk3102_4(X1,X2,X3,X4)
    | ~ esk3103_4(X1,X2,X3,X4) ) ).

cnf(i_0_5430,axiom,
    ( ~ esk12997_4(X1,X2,X3,X4)
    | esk13117_4(X1,X2,X3,X4) ) ).

cnf(i_0_5431,axiom,
    ( ~ esk10018_4(X1,X2,X3,X4)
    | ~ esk10054_4(X1,X2,X3,X4)
    | ~ esk10053_4(X1,X2,X3,X4) ) ).

cnf(i_0_5432,axiom,
    ( ~ esk16240_4(X1,X2,X3,X4)
    | ~ esk16221_4(X1,X2,X3,X4)
    | ~ esk16186_4(X1,X2,X3,X4) ) ).

cnf(i_0_5433,axiom,
    ( esk5447_4(X1,X2,X3,X4)
    | esk5362_4(X1,X2,X3,X4) ) ).

cnf(i_0_5434,axiom,
    ( ~ esk2444_4(X1,X2,X3,X4)
    | esk2565_4(X1,X2,X3,X4) ) ).

cnf(i_0_5435,axiom,
    ( esk4775_4(X1,X2,X3,X4)
    | esk4722_4(X1,X2,X3,X4) ) ).

cnf(i_0_5436,axiom,
    ( ~ esk11208_4(X1,X2,X3,X4)
    | esk11466_4(X1,X2,X3,X4) ) ).

cnf(i_0_5437,axiom,
    ( esk15382_4(X1,X2,X3,X4)
    | esk15415_4(X1,X2,X3,X4) ) ).

cnf(i_0_5438,axiom,
    ( esk13849_4(X1,X2,X3,X4)
    | esk13821_4(X1,X2,X3,X4) ) ).

cnf(i_0_5439,axiom,
    ( ~ esk16435_4(X1,X2,X3,X4)
    | esk16516_4(X1,X2,X3,X4) ) ).

cnf(i_0_5440,axiom,
    ( ~ esk7253_4(X1,X2,X3,X4)
    | ~ esk7201_4(X1,X2,X3,X4) ) ).

cnf(i_0_5441,axiom,
    ( ~ esk327_0
    | ~ p(X4)
    | p(X2)
    | p(X3)
    | esk16724_4(X1,X2,X3,X4)
    | ~ p(X1) ) ).

cnf(i_0_5442,axiom,
    ( ~ esk6587_4(X1,X2,X3,X4)
    | ~ esk6586_4(X1,X2,X3,X4) ) ).

cnf(i_0_5443,axiom,
    ( ~ esk14933_4(X1,X2,X3,X4)
    | ~ esk14907_4(X1,X2,X3,X4)
    | ~ esk14976_4(X1,X2,X3,X4) ) ).

cnf(i_0_5444,axiom,
    ( ~ esk8246_4(X1,X2,X3,X4)
    | ~ esk8167_4(X1,X2,X3,X4)
    | ~ esk8199_4(X1,X2,X3,X4) ) ).

cnf(i_0_5445,axiom,
    ( esk5908_4(X1,X2,X3,X4)
    | ~ esk5650_4(X1,X2,X3,X4) ) ).

cnf(i_0_5446,axiom,
    ( ~ esk11813_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4)
    | esk11694_4(X1,X2,X3,X4) ) ).

cnf(i_0_5447,axiom,
    ( ~ esk14370_4(X1,X2,X3,X4)
    | esk14331_4(X1,X2,X3,X4) ) ).

cnf(i_0_5448,axiom,
    ( ~ esk12787_4(X1,X2,X3,X4)
    | esk12832_4(X1,X2,X3,X4) ) ).

cnf(i_0_5449,axiom,
    ( ~ esk7361_4(X1,X2,X3,X4)
    | ~ esk7360_4(X1,X2,X3,X4)
    | esk7362_4(X1,X2,X3,X4) ) ).

cnf(i_0_5450,axiom,
    ( esk13533_4(X1,X2,X3,X4)
    | ~ esk13534_4(X1,X2,X3,X4) ) ).

cnf(i_0_5451,axiom,
    ( esk13341_4(X1,X2,X3,X4)
    | ~ esk13083_4(X1,X2,X3,X4) ) ).

cnf(i_0_5452,axiom,
    ( esk524_4(X1,X2,X3,X4)
    | ~ esk525_4(X1,X2,X3,X4) ) ).

cnf(i_0_5453,axiom,
    ( ~ esk1704_4(X1,X2,X3,X4)
    | esk1711_4(X1,X2,X3,X4) ) ).

cnf(i_0_5454,axiom,
    ( p(X2)
    | p(X4)
    | p(X1)
    | esk16705_4(X1,X2,X3,X4)
    | ~ esk243_0
    | p(X3) ) ).

cnf(i_0_5455,axiom,
    ( esk15356_4(X1,X2,X3,X4)
    | esk15372_4(X1,X2,X3,X4) ) ).

cnf(i_0_5456,axiom,
    ( esk2757_4(X1,X2,X3,X4)
    | esk2792_4(X1,X2,X3,X4) ) ).

cnf(i_0_5457,axiom,
    ( esk16407_4(X1,X2,X3,X4)
    | esk16391_4(X1,X2,X3,X4) ) ).

cnf(i_0_5458,axiom,
    ( esk1152_4(X1,X2,X3,X4)
    | ~ esk1176_4(X1,X2,X3,X4) ) ).

cnf(i_0_5459,axiom,
    ( ~ esk16363_4(X1,X2,X3,X4)
    | esk16362_4(X1,X2,X3,X4)
    | esk16367_4(X1,X2,X3,X4) ) ).

cnf(i_0_5460,axiom,
    ( esk475_4(X1,X2,X3,X4)
    | esk562_4(X1,X2,X3,X4) ) ).

cnf(i_0_5461,axiom,
    ( esk4435_4(X1,X2,X3,X4)
    | esk4403_4(X1,X2,X3,X4) ) ).

cnf(i_0_5462,axiom,
    ( ~ esk10435_4(X1,X2,X3,X4)
    | esk10177_4(X1,X2,X3,X4) ) ).

cnf(i_0_5463,axiom,
    ( esk10096_4(X1,X2,X3,X4)
    | esk10074_4(X1,X2,X3,X4) ) ).

cnf(i_0_5464,axiom,
    ( ~ esk7589_4(X1,X2,X3,X4)
    | esk7554_4(X1,X2,X3,X4) ) ).

cnf(i_0_5465,axiom,
    ( esk9716_4(X1,X2,X3,X4)
    | esk9707_4(X1,X2,X3,X4) ) ).

cnf(i_0_5466,axiom,
    ( esk3836_4(X1,X2,X3,X4)
    | esk3892_4(X1,X2,X3,X4) ) ).

cnf(i_0_5467,axiom,
    ( esk585_4(X1,X2,X3,X4)
    | esk578_4(X1,X2,X3,X4)
    | ~ esk497_4(X1,X2,X3,X4) ) ).

cnf(i_0_5468,axiom,
    ( ~ p(X3)
    | esk177_0
    | ~ p(X1)
    | p(X4)
    | p(X2)
    | ~ esk505_4(X1,X2,X3,X4) ) ).

cnf(i_0_5469,axiom,
    ( esk1440_4(X1,X2,X3,X4)
    | esk1441_4(X1,X2,X3,X4) ) ).

cnf(i_0_5470,axiom,
    ( esk4824_4(X1,X2,X3,X4)
    | esk4843_4(X1,X2,X3,X4) ) ).

cnf(i_0_5471,axiom,
    ( esk1316_4(X1,X2,X3,X4)
    | esk1330_4(X1,X2,X3,X4) ) ).

cnf(i_0_5472,axiom,
    ( ~ esk2623_4(X1,X2,X3,X4)
    | ~ esk2595_4(X1,X2,X3,X4) ) ).

cnf(i_0_5473,axiom,
    ( ~ esk3731_4(X1,X2,X3,X4)
    | esk3746_4(X1,X2,X3,X4) ) ).

cnf(i_0_5474,axiom,
    ( ~ esk11216_4(X1,X2,X3,X4)
    | ~ esk11215_4(X1,X2,X3,X4)
    | esk11217_4(X1,X2,X3,X4) ) ).

cnf(i_0_5475,axiom,
    ( esk10702_4(X1,X2,X3,X4)
    | ~ esk10698_4(X1,X2,X3,X4) ) ).

cnf(i_0_5476,axiom,
    ( esk6197_4(X1,X2,X3,X4)
    | esk6169_4(X1,X2,X3,X4) ) ).

cnf(i_0_5477,axiom,
    ( esk2579_4(X1,X2,X3,X4)
    | ~ esk2583_4(X1,X2,X3,X4) ) ).

cnf(i_0_5478,axiom,
    ( esk2874_4(X1,X2,X3,X4)
    | ~ esk2875_4(X1,X2,X3,X4) ) ).

cnf(i_0_5479,axiom,
    ( ~ esk10986_4(X1,X2,X3,X4)
    | ~ esk11005_4(X1,X2,X3,X4)
    | ~ esk11006_4(X1,X2,X3,X4) ) ).

cnf(i_0_5480,axiom,
    ( ~ esk4475_4(X1,X2,X3,X4)
    | esk4500_4(X1,X2,X3,X4) ) ).

cnf(i_0_5481,axiom,
    ( esk3106_4(X1,X2,X3,X4)
    | ~ esk3143_4(X1,X2,X3,X4)
    | esk3089_4(X1,X2,X3,X4) ) ).

cnf(i_0_5482,axiom,
    ( esk6972_4(X1,X2,X3,X4)
    | esk7011_4(X1,X2,X3,X4)
    | esk6970_4(X1,X2,X3,X4)
    | esk6971_4(X1,X2,X3,X4) ) ).

cnf(i_0_5483,axiom,
    ( esk10336_4(X1,X2,X3,X4)
    | ~ esk10335_4(X1,X2,X3,X4)
    | ~ esk10334_4(X1,X2,X3,X4) ) ).

cnf(i_0_5484,axiom,
    ( ~ esk3906_4(X1,X2,X3,X4)
    | ~ esk3928_4(X1,X2,X3,X4) ) ).

cnf(i_0_5485,axiom,
    ( ~ esk3326_4(X1,X2,X3,X4)
    | ~ esk3377_4(X1,X2,X3,X4)
    | ~ esk3412_4(X1,X2,X3,X4) ) ).

cnf(i_0_5486,axiom,
    ( ~ esk10159_4(X1,X2,X3,X4)
    | esk10171_4(X1,X2,X3,X4) ) ).

cnf(i_0_5487,axiom,
    ( esk3912_4(X1,X2,X3,X4)
    | esk3860_4(X1,X2,X3,X4) ) ).

cnf(i_0_5488,axiom,
    ( esk2218_4(X1,X2,X3,X4)
    | ~ esk2225_4(X1,X2,X3,X4)
    | esk2211_4(X1,X2,X3,X4) ) ).

cnf(i_0_5489,axiom,
    ( ~ esk10291_4(X1,X2,X3,X4)
    | esk10290_4(X1,X2,X3,X4) ) ).

cnf(i_0_5490,axiom,
    ( ~ esk9251_4(X1,X2,X3,X4)
    | ~ esk9279_4(X1,X2,X3,X4)
    | ~ esk9281_4(X1,X2,X3,X4)
    | ~ esk9253_4(X1,X2,X3,X4) ) ).

cnf(i_0_5491,axiom,
    ( ~ esk14121_4(X1,X2,X3,X4)
    | esk14070_4(X1,X2,X3,X4) ) ).

cnf(i_0_5492,axiom,
    ( ~ esk16184_4(X1,X2,X3,X4)
    | esk16238_4(X1,X2,X3,X4) ) ).

cnf(i_0_5493,axiom,
    ( ~ esk15441_4(X1,X2,X3,X4)
    | ~ esk15440_4(X1,X2,X3,X4) ) ).

cnf(i_0_5494,axiom,
    ( esk5386_4(X1,X2,X3,X4)
    | ~ esk5128_4(X1,X2,X3,X4) ) ).

cnf(i_0_5495,axiom,
    ( ~ esk4824_4(X1,X2,X3,X4)
    | ~ esk4874_4(X1,X2,X3,X4)
    | ~ esk4841_4(X1,X2,X3,X4) ) ).

cnf(i_0_5496,axiom,
    ( esk2270_4(X1,X2,X3,X4)
    | esk2256_4(X1,X2,X3,X4) ) ).

cnf(i_0_5497,axiom,
    ( ~ esk7558_4(X1,X2,X3,X4)
    | esk7585_4(X1,X2,X3,X4) ) ).

cnf(i_0_5498,axiom,
    ( ~ esk12211_4(X1,X2,X3,X4)
    | esk12227_4(X1,X2,X3,X4) ) ).

cnf(i_0_5499,axiom,
    ( ~ esk8896_4(X1,X2,X3,X4)
    | ~ esk8897_4(X1,X2,X3,X4) ) ).

cnf(i_0_5500,axiom,
    ( esk1271_4(X1,X2,X3,X4)
    | ~ esk1529_4(X1,X2,X3,X4) ) ).

cnf(i_0_5501,axiom,
    ( ~ esk15277_4(X1,X2,X3,X4)
    | esk15301_4(X1,X2,X3,X4) ) ).

cnf(i_0_5502,axiom,
    ( esk10259_4(X1,X2,X3,X4)
    | ~ esk10342_4(X1,X2,X3,X4)
    | esk10319_4(X1,X2,X3,X4) ) ).

cnf(i_0_5503,axiom,
    ( esk14849_4(X1,X2,X3,X4)
    | esk14869_4(X1,X2,X3,X4) ) ).

cnf(i_0_5504,axiom,
    ( esk2605_4(X1,X2,X3,X4)
    | esk2604_4(X1,X2,X3,X4)
    | esk2606_4(X1,X2,X3,X4) ) ).

cnf(i_0_5505,axiom,
    ( ~ esk2466_4(X1,X2,X3,X4)
    | esk2208_4(X1,X2,X3,X4) ) ).

cnf(i_0_5506,axiom,
    ( ~ esk11630_4(X1,X2,X3,X4)
    | esk11601_4(X1,X2,X3,X4)
    | esk11550_4(X1,X2,X3,X4) ) ).

cnf(i_0_5507,axiom,
    ( esk3505_4(X1,X2,X3,X4)
    | ~ esk3499_4(X1,X2,X3,X4) ) ).

cnf(i_0_5508,axiom,
    ( esk16712_4(X1,X2,X3,X4)
    | esk16679_4(X1,X2,X3,X4) ) ).

cnf(i_0_5509,axiom,
    ( ~ esk14204_4(X1,X2,X3,X4)
    | ~ esk14078_4(X1,X2,X3,X4)
    | ~ esk14090_4(X1,X2,X3,X4) ) ).

cnf(i_0_5510,axiom,
    ( ~ esk9523_4(X1,X2,X3,X4)
    | esk9525_4(X1,X2,X3,X4) ) ).

cnf(i_0_5511,axiom,
    ( esk7520_4(X1,X2,X3,X4)
    | ~ esk7522_4(X1,X2,X3,X4) ) ).

cnf(i_0_5512,axiom,
    ( esk4657_4(X1,X2,X3,X4)
    | esk4659_4(X1,X2,X3,X4)
    | esk4698_4(X1,X2,X3,X4)
    | esk4658_4(X1,X2,X3,X4) ) ).

cnf(i_0_5513,axiom,
    ( ~ esk12734_4(X1,X2,X3,X4)
    | esk12741_4(X1,X2,X3,X4) ) ).

cnf(i_0_5514,axiom,
    ( esk4868_4(X1,X2,X3,X4)
    | ~ esk4610_4(X1,X2,X3,X4) ) ).

cnf(i_0_5515,axiom,
    ( esk16170_4(X1,X2,X3,X4)
    | ~ esk16215_4(X1,X2,X3,X4) ) ).

cnf(i_0_5516,axiom,
    ( ~ esk4313_4(X1,X2,X3,X4)
    | ~ esk4314_4(X1,X2,X3,X4)
    | ~ esk4309_4(X1,X2,X3,X4) ) ).

cnf(i_0_5517,axiom,
    ( ~ esk4774_4(X1,X2,X3,X4)
    | esk4768_4(X1,X2,X3,X4)
    | ~ esk4870_4(X1,X2,X3,X4) ) ).

cnf(i_0_5518,axiom,
    ( esk13844_4(X1,X2,X3,X4)
    | esk13807_4(X1,X2,X3,X4) ) ).

cnf(i_0_5519,axiom,
    ( ~ esk12275_4(X1,X2,X3,X4)
    | esk12314_4(X1,X2,X3,X4) ) ).

cnf(i_0_5520,axiom,
    ( esk5652_4(X1,X2,X3,X4)
    | ~ esk5910_4(X1,X2,X3,X4) ) ).

cnf(i_0_5521,axiom,
    ( esk16771_4(X1,X2,X3,X4)
    | esk16740_4(X1,X2,X3,X4)
    | ~ esk16772_4(X1,X2,X3,X4) ) ).

cnf(i_0_5522,axiom,
    ( esk714_4(X1,X2,X3,X4)
    | esk742_4(X1,X2,X3,X4) ) ).

cnf(i_0_5523,axiom,
    ( esk15311_4(X1,X2,X3,X4)
    | ~ esk15297_4(X1,X2,X3,X4) ) ).

cnf(i_0_5524,axiom,
    ( esk5408_4(X1,X2,X3,X4)
    | ~ esk5409_4(X1,X2,X3,X4) ) ).

cnf(i_0_5525,axiom,
    ( p(X1)
    | p(X3)
    | ~ p(X2)
    | esk507_4(X1,X2,X3,X4)
    | ~ esk186_0
    | p(X4) ) ).

cnf(i_0_5526,axiom,
    ( ~ esk12277_4(X1,X2,X3,X4)
    | ~ esk12304_4(X1,X2,X3,X4)
    | ~ esk12337_4(X1,X2,X3,X4) ) ).

cnf(i_0_5527,axiom,
    ( ~ p(X2)
    | ~ p(X4)
    | esk270_0
    | ~ p(X1)
    | ~ esk517_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_5528,axiom,
    ( esk15403_4(X1,X2,X3,X4)
    | ~ esk15145_4(X1,X2,X3,X4) ) ).

cnf(i_0_5529,axiom,
    ( ~ esk3325_4(X1,X2,X3,X4)
    | esk3583_4(X1,X2,X3,X4) ) ).

cnf(i_0_5530,axiom,
    ( ~ esk4545_4(X1,X2,X3,X4)
    | ~ esk4546_4(X1,X2,X3,X4) ) ).

cnf(i_0_5531,axiom,
    ( esk14005_4(X1,X2,X3,X4)
    | ~ esk14057_4(X1,X2,X3,X4) ) ).

cnf(i_0_5532,axiom,
    ( esk4004_4(X1,X2,X3,X4)
    | esk3952_4(X1,X2,X3,X4) ) ).

cnf(i_0_5533,axiom,
    ( ~ esk13143_4(X1,X2,X3,X4)
    | ~ esk13142_4(X1,X2,X3,X4) ) ).

cnf(i_0_5534,axiom,
    ( ~ esk10571_4(X1,X2,X3,X4)
    | esk10605_4(X1,X2,X3,X4) ) ).

cnf(i_0_5535,axiom,
    ( ~ esk15176_4(X1,X2,X3,X4)
    | ~ esk15085_4(X1,X2,X3,X4)
    | ~ esk15183_4(X1,X2,X3,X4) ) ).

cnf(i_0_5536,axiom,
    ( ~ esk10270_4(X1,X2,X3,X4)
    | esk10213_4(X1,X2,X3,X4) ) ).

cnf(i_0_5537,axiom,
    ( esk12022_4(X1,X2,X3,X4)
    | esk12052_4(X1,X2,X3,X4) ) ).

cnf(i_0_5538,axiom,
    ( esk7417_4(X1,X2,X3,X4)
    | esk7394_4(X1,X2,X3,X4) ) ).

cnf(i_0_5539,axiom,
    ( ~ esk3543_4(X1,X2,X3,X4)
    | ~ esk3659_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4) ) ).

cnf(i_0_5540,axiom,
    ( ~ esk15296_4(X1,X2,X3,X4)
    | esk15311_4(X1,X2,X3,X4) ) ).

cnf(i_0_5541,axiom,
    ( esk6391_4(X1,X2,X3,X4)
    | esk6354_4(X1,X2,X3,X4) ) ).

cnf(i_0_5542,axiom,
    ( ~ esk5471_4(X1,X2,X3,X4)
    | ~ esk5461_4(X1,X2,X3,X4) ) ).

cnf(i_0_5543,axiom,
    ( esk13153_4(X1,X2,X3,X4)
    | ~ esk13152_4(X1,X2,X3,X4) ) ).

cnf(i_0_5544,axiom,
    ( ~ esk12396_4(X1,X2,X3,X4)
    | ~ esk12309_4(X1,X2,X3,X4)
    | ~ esk12279_4(X1,X2,X3,X4) ) ).

cnf(i_0_5545,axiom,
    ( esk6945_4(X1,X2,X3,X4)
    | ~ esk7203_4(X1,X2,X3,X4) ) ).

cnf(i_0_5546,axiom,
    ( ~ esk6533_4(X1,X2,X3,X4)
    | esk6554_4(X1,X2,X3,X4) ) ).

cnf(i_0_5547,axiom,
    ( ~ esk8664_4(X1,X2,X3,X4)
    | esk8742_4(X1,X2,X3,X4) ) ).

cnf(i_0_5548,axiom,
    ( esk14397_4(X1,X2,X3,X4)
    | ~ esk14271_4(X1,X2,X3,X4) ) ).

cnf(i_0_5549,axiom,
    ( ~ esk7972_4(X1,X2,X3,X4)
    | ~ esk8024_4(X1,X2,X3,X4) ) ).

cnf(i_0_5550,axiom,
    ( ~ esk14391_4(X1,X2,X3,X4)
    | ~ esk14462_4(X1,X2,X3,X4)
    | ~ esk14443_4(X1,X2,X3,X4) ) ).

cnf(i_0_5551,axiom,
    ( ~ esk2816_4(X1,X2,X3,X4)
    | ~ esk2718_4(X1,X2,X3,X4)
    | esk2698_4(X1,X2,X3,X4) ) ).

cnf(i_0_5552,axiom,
    ( ~ esk9051_4(X1,X2,X3,X4)
    | esk9050_4(X1,X2,X3,X4) ) ).

cnf(i_0_5553,axiom,
    ( esk4755_4(X1,X2,X3,X4)
    | ~ esk4734_4(X1,X2,X3,X4) ) ).

cnf(i_0_5554,axiom,
    ( ~ esk11812_4(X1,X2,X3,X4)
    | esk12070_4(X1,X2,X3,X4) ) ).

cnf(i_0_5555,axiom,
    ( ~ esk16205_4(X1,X2,X3,X4)
    | esk16207_4(X1,X2,X3,X4) ) ).

cnf(i_0_5556,axiom,
    ( ~ esk2515_4(X1,X2,X3,X4)
    | ~ esk2631_4(X1,X2,X3,X4)
    | ~ esk2513_4(X1,X2,X3,X4) ) ).

cnf(i_0_5557,axiom,
    ( ~ esk5805_4(X1,X2,X3,X4)
    | esk5800_4(X1,X2,X3,X4)
    | ~ esk5799_4(X1,X2,X3,X4) ) ).

cnf(i_0_5558,axiom,
    ( ~ esk12476_4(X1,X2,X3,X4)
    | esk12448_4(X1,X2,X3,X4) ) ).

cnf(i_0_5559,axiom,
    ( esk1250_4(X1,X2,X3,X4)
    | esk1228_4(X1,X2,X3,X4) ) ).

cnf(i_0_5560,axiom,
    ( esk5668_4(X1,X2,X3,X4)
    | esk5675_4(X1,X2,X3,X4) ) ).

cnf(i_0_5561,axiom,
    ( esk15825_4(X1,X2,X3,X4)
    | ~ esk15806_4(X1,X2,X3,X4) ) ).

cnf(i_0_5562,axiom,
    ( esk6831_4(X1,X2,X3,X4)
    | esk6833_4(X1,X2,X3,X4) ) ).

cnf(i_0_5563,axiom,
    ( ~ esk4002_4(X1,X2,X3,X4)
    | ~ esk4120_4(X1,X2,X3,X4) ) ).

cnf(i_0_5564,axiom,
    ( esk13680_4(X1,X2,X3,X4)
    | ~ esk13681_4(X1,X2,X3,X4) ) ).

cnf(i_0_5565,axiom,
    ( ~ esk6992_4(X1,X2,X3,X4)
    | ~ esk6964_4(X1,X2,X3,X4) ) ).

cnf(i_0_5566,axiom,
    ( ~ esk1606_4(X1,X2,X3,X4)
    | ~ esk1613_4(X1,X2,X3,X4)
    | ~ esk1525_4(X1,X2,X3,X4) ) ).

cnf(i_0_5567,axiom,
    ( ~ esk10773_4(X1,X2,X3,X4)
    | esk10818_4(X1,X2,X3,X4)
    | ~ esk10833_4(X1,X2,X3,X4) ) ).

cnf(i_0_5568,axiom,
    ( ~ esk3630_4(X1,X2,X3,X4)
    | ~ esk3591_4(X1,X2,X3,X4) ) ).

cnf(i_0_5569,axiom,
    ( esk5921_4(X1,X2,X3,X4)
    | ~ esk5770_4(X1,X2,X3,X4) ) ).

cnf(i_0_5570,axiom,
    ( esk12610_4(X1,X2,X3,X4)
    | ~ esk12611_4(X1,X2,X3,X4) ) ).

cnf(i_0_5571,axiom,
    ( esk9657_4(X1,X2,X3,X4)
    | ~ esk9639_4(X1,X2,X3,X4) ) ).

cnf(i_0_5572,axiom,
    ( ~ esk11582_4(X1,X2,X3,X4)
    | ~ esk11581_4(X1,X2,X3,X4)
    | esk11583_4(X1,X2,X3,X4) ) ).

cnf(i_0_5573,axiom,
    ( ~ esk14811_4(X1,X2,X3,X4)
    | ~ esk14825_4(X1,X2,X3,X4)
    | ~ esk14802_4(X1,X2,X3,X4) ) ).

cnf(i_0_5574,axiom,
    ( esk16370_4(X1,X2,X3,X4)
    | esk16461_4(X1,X2,X3,X4) ) ).

cnf(i_0_5575,axiom,
    ( esk14273_4(X1,X2,X3,X4)
    | ~ esk14249_4(X1,X2,X3,X4) ) ).

cnf(i_0_5576,axiom,
    ( esk9047_4(X1,X2,X3,X4)
    | esk9022_4(X1,X2,X3,X4)
    | ~ esk8996_4(X1,X2,X3,X4) ) ).

cnf(i_0_5577,axiom,
    ( ~ esk3060_4(X1,X2,X3,X4)
    | esk3024_4(X1,X2,X3,X4) ) ).

cnf(i_0_5578,axiom,
    ( esk1459_4(X1,X2,X3,X4)
    | ~ esk1457_4(X1,X2,X3,X4)
    | ~ esk1458_4(X1,X2,X3,X4) ) ).

cnf(i_0_5579,axiom,
    ( ~ esk4818_4(X1,X2,X3,X4)
    | esk4869_4(X1,X2,X3,X4) ) ).

cnf(i_0_5580,axiom,
    ( ~ esk4237_4(X1,X2,X3,X4)
    | ~ esk4390_4(X1,X2,X3,X4)
    | ~ esk4383_4(X1,X2,X3,X4) ) ).

cnf(i_0_5581,axiom,
    ( esk11882_4(X1,X2,X3,X4)
    | esk11795_4(X1,X2,X3,X4) ) ).

cnf(i_0_5582,axiom,
    ( esk3073_4(X1,X2,X3,X4)
    | ~ esk2955_4(X1,X2,X3,X4) ) ).

cnf(i_0_5583,axiom,
    ( ~ esk4352_4(X1,X2,X3,X4)
    | ~ esk4354_4(X1,X2,X3,X4)
    | ~ esk4407_4(X1,X2,X3,X4)
    | ~ esk4405_4(X1,X2,X3,X4) ) ).

cnf(i_0_5584,axiom,
    ( esk3510_4(X1,X2,X3,X4)
    | ~ esk3503_4(X1,X2,X3,X4) ) ).

cnf(i_0_5585,axiom,
    ( esk14554_4(X1,X2,X3,X4)
    | esk14568_4(X1,X2,X3,X4) ) ).

cnf(i_0_5586,axiom,
    ( ~ esk3612_4(X1,X2,X3,X4)
    | ~ esk3466_4(X1,X2,X3,X4)
    | ~ esk3619_4(X1,X2,X3,X4) ) ).

cnf(i_0_5587,axiom,
    ( esk1029_4(X1,X2,X3,X4)
    | ~ esk905_4(X1,X2,X3,X4) ) ).

cnf(i_0_5588,axiom,
    ( esk9150_4(X1,X2,X3,X4)
    | ~ esk8892_4(X1,X2,X3,X4) ) ).

cnf(i_0_5589,axiom,
    ( ~ esk14654_4(X1,X2,X3,X4)
    | esk14708_4(X1,X2,X3,X4) ) ).

cnf(i_0_5590,axiom,
    ( ~ esk13353_4(X1,X2,X3,X4)
    | ~ esk13397_4(X1,X2,X3,X4)
    | ~ esk13404_4(X1,X2,X3,X4) ) ).

cnf(i_0_5591,axiom,
    ( esk16221_4(X1,X2,X3,X4)
    | esk16222_4(X1,X2,X3,X4) ) ).

cnf(i_0_5592,axiom,
    ( ~ esk4274_4(X1,X2,X3,X4)
    | ~ esk4288_4(X1,X2,X3,X4)
    | ~ esk4265_4(X1,X2,X3,X4) ) ).

cnf(i_0_5593,axiom,
    ( ~ esk16701_4(X1,X2,X3,X4)
    | p(X3)
    | esk214_0
    | p(X1)
    | p(X2)
    | ~ p(X4) ) ).

cnf(i_0_5594,axiom,
    ( esk7042_4(X1,X2,X3,X4)
    | ~ esk7073_4(X1,X2,X3,X4) ) ).

cnf(i_0_5595,axiom,
    ( ~ esk6752_4(X1,X2,X3,X4)
    | esk6681_4(X1,X2,X3,X4)
    | esk6733_4(X1,X2,X3,X4) ) ).

cnf(i_0_5596,axiom,
    ( ~ esk3919_4(X1,X2,X3,X4)
    | ~ esk3929_4(X1,X2,X3,X4) ) ).

cnf(i_0_5597,axiom,
    ( ~ esk3630_4(X1,X2,X3,X4)
    | ~ esk3631_4(X1,X2,X3,X4) ) ).

cnf(i_0_5598,axiom,
    ( esk5269_4(X1,X2,X3,X4)
    | ~ esk5248_4(X1,X2,X3,X4) ) ).

cnf(i_0_5599,axiom,
    ( esk5937_4(X1,X2,X3,X4)
    | esk5914_4(X1,X2,X3,X4) ) ).

cnf(i_0_5600,axiom,
    ( ~ esk13844_4(X1,X2,X3,X4)
    | ~ esk13819_4(X1,X2,X3,X4)
    | ~ esk13877_4(X1,X2,X3,X4) ) ).

cnf(i_0_5601,axiom,
    ( esk15226_4(X1,X2,X3,X4)
    | esk15112_4(X1,X2,X3,X4) ) ).

cnf(i_0_5602,axiom,
    ( ~ esk16192_4(X1,X2,X3,X4)
    | esk16218_4(X1,X2,X3,X4)
    | esk16243_4(X1,X2,X3,X4) ) ).

cnf(i_0_5603,axiom,
    ( ~ esk10578_4(X1,X2,X3,X4)
    | esk10579_4(X1,X2,X3,X4) ) ).

cnf(i_0_5604,axiom,
    ( ~ esk11986_4(X1,X2,X3,X4)
    | esk11988_4(X1,X2,X3,X4)
    | ~ esk11987_4(X1,X2,X3,X4) ) ).

cnf(i_0_5605,axiom,
    ( esk7980_4(X1,X2,X3,X4)
    | esk7891_4(X1,X2,X3,X4) ) ).

cnf(i_0_5606,axiom,
    ( ~ esk8170_4(X1,X2,X3,X4)
    | ~ esk8203_4(X1,X2,X3,X4)
    | ~ esk8165_4(X1,X2,X3,X4) ) ).

cnf(i_0_5607,axiom,
    ( esk14648_4(X1,X2,X3,X4)
    | ~ esk14390_4(X1,X2,X3,X4) ) ).

cnf(i_0_5608,axiom,
    ( ~ esk11953_4(X1,X2,X3,X4)
    | esk11970_4(X1,X2,X3,X4) ) ).

cnf(i_0_5609,axiom,
    ( esk13332_4(X1,X2,X3,X4)
    | esk13292_4(X1,X2,X3,X4) ) ).

cnf(i_0_5610,axiom,
    ( ~ esk11288_4(X1,X2,X3,X4)
    | esk11246_4(X1,X2,X3,X4) ) ).

cnf(i_0_5611,axiom,
    ( esk997_4(X1,X2,X3,X4)
    | esk956_4(X1,X2,X3,X4) ) ).

cnf(i_0_5612,axiom,
    ( ~ esk2487_4(X1,X2,X3,X4)
    | esk2485_4(X1,X2,X3,X4) ) ).

cnf(i_0_5613,axiom,
    ( ~ esk10790_4(X1,X2,X3,X4)
    | esk10724_4(X1,X2,X3,X4) ) ).

cnf(i_0_5614,axiom,
    ( esk16065_4(X1,X2,X3,X4)
    | ~ esk16186_4(X1,X2,X3,X4)
    | ~ esk16082_4(X1,X2,X3,X4) ) ).

cnf(i_0_5615,axiom,
    ( ~ esk15576_4(X1,X2,X3,X4)
    | ~ esk15580_4(X1,X2,X3,X4) ) ).

cnf(i_0_5616,axiom,
    ( ~ esk910_4(X1,X2,X3,X4)
    | esk884_4(X1,X2,X3,X4) ) ).

cnf(i_0_5617,axiom,
    ( esk12532_4(X1,X2,X3,X4)
    | esk12540_4(X1,X2,X3,X4) ) ).

cnf(i_0_5618,axiom,
    ( esk11564_4(X1,X2,X3,X4)
    | esk11594_4(X1,X2,X3,X4) ) ).

cnf(i_0_5619,axiom,
    ( ~ esk10179_4(X1,X2,X3,X4)
    | ~ esk10184_4(X1,X2,X3,X4) ) ).

cnf(i_0_5620,axiom,
    ( esk9144_4(X1,X2,X3,X4)
    | esk9146_4(X1,X2,X3,X4) ) ).

cnf(i_0_5621,axiom,
    ( esk8229_4(X1,X2,X3,X4)
    | esk8196_4(X1,X2,X3,X4) ) ).

cnf(i_0_5622,axiom,
    ( ~ esk12534_4(X1,X2,X3,X4)
    | ~ esk12547_4(X1,X2,X3,X4)
    | ~ esk12580_4(X1,X2,X3,X4) ) ).

cnf(i_0_5623,axiom,
    ( esk15266_4(X1,X2,X3,X4)
    | ~ esk15297_4(X1,X2,X3,X4) ) ).

cnf(i_0_5624,axiom,
    ( esk8775_4(X1,X2,X3,X4)
    | ~ esk8801_4(X1,X2,X3,X4)
    | esk8776_4(X1,X2,X3,X4) ) ).

cnf(i_0_5625,axiom,
    ( esk7159_4(X1,X2,X3,X4)
    | esk7127_4(X1,X2,X3,X4) ) ).

cnf(i_0_5626,axiom,
    ( esk10783_4(X1,X2,X3,X4)
    | ~ esk10665_4(X1,X2,X3,X4) ) ).

cnf(i_0_5627,axiom,
    ( esk4358_4(X1,X2,X3,X4)
    | ~ esk4100_4(X1,X2,X3,X4) ) ).

cnf(i_0_5628,axiom,
    ( esk2539_4(X1,X2,X3,X4)
    | esk2498_4(X1,X2,X3,X4) ) ).

cnf(i_0_5629,axiom,
    ( esk15697_4(X1,X2,X3,X4)
    | esk15598_4(X1,X2,X3,X4)
    | esk15690_4(X1,X2,X3,X4) ) ).

cnf(i_0_5630,axiom,
    ( esk16263_4(X1,X2,X3,X4)
    | esk16223_4(X1,X2,X3,X4)
    | esk16224_4(X1,X2,X3,X4)
    | esk16222_4(X1,X2,X3,X4) ) ).

cnf(i_0_5631,axiom,
    ( esk2561_4(X1,X2,X3,X4)
    | esk2611_4(X1,X2,X3,X4)
    | ~ esk2612_4(X1,X2,X3,X4) ) ).

cnf(i_0_5632,axiom,
    ( esk15367_4(X1,X2,X3,X4)
    | esk15359_4(X1,X2,X3,X4) ) ).

cnf(i_0_5633,axiom,
    ( esk4676_4(X1,X2,X3,X4)
    | ~ esk4654_4(X1,X2,X3,X4)
    | esk4655_4(X1,X2,X3,X4) ) ).

cnf(i_0_5634,axiom,
    ( ~ esk8680_4(X1,X2,X3,X4)
    | ~ esk8625_4(X1,X2,X3,X4) ) ).

cnf(i_0_5635,axiom,
    ( ~ esk2316_4(X1,X2,X3,X4)
    | esk2058_4(X1,X2,X3,X4) ) ).

cnf(i_0_5636,axiom,
    ( ~ esk9028_4(X1,X2,X3,X4)
    | ~ esk9026_4(X1,X2,X3,X4) ) ).

cnf(i_0_5637,axiom,
    ( esk6272_4(X1,X2,X3,X4)
    | ~ esk6301_4(X1,X2,X3,X4) ) ).

cnf(i_0_5638,axiom,
    ( ~ esk13151_4(X1,X2,X3,X4)
    | ~ esk13066_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_5639,axiom,
    ( esk16147_4(X1,X2,X3,X4)
    | esk16125_4(X1,X2,X3,X4) ) ).

cnf(i_0_5640,axiom,
    ( esk2602_4(X1,X2,X3,X4)
    | esk2642_4(X1,X2,X3,X4)
    | esk2603_4(X1,X2,X3,X4)
    | esk2601_4(X1,X2,X3,X4) ) ).

cnf(i_0_5641,axiom,
    ( esk12856_4(X1,X2,X3,X4)
    | ~ esk13114_4(X1,X2,X3,X4) ) ).

cnf(i_0_5642,axiom,
    ( ~ esk16380_4(X1,X2,X3,X4)
    | ~ esk16408_4(X1,X2,X3,X4)
    | ~ esk16409_4(X1,X2,X3,X4) ) ).

cnf(i_0_5643,axiom,
    ( ~ esk11750_4(X1,X2,X3,X4)
    | esk11822_4(X1,X2,X3,X4) ) ).

cnf(i_0_5644,axiom,
    ( ~ esk3353_4(X1,X2,X3,X4)
    | esk3611_4(X1,X2,X3,X4) ) ).

cnf(i_0_5645,axiom,
    ( esk4731_4(X1,X2,X3,X4)
    | ~ esk4758_4(X1,X2,X3,X4) ) ).

cnf(i_0_5646,axiom,
    ( ~ esk14319_4(X1,X2,X3,X4)
    | esk14394_4(X1,X2,X3,X4) ) ).

cnf(i_0_5647,axiom,
    ( esk10247_4(X1,X2,X3,X4)
    | esk10209_4(X1,X2,X3,X4) ) ).

cnf(i_0_5648,axiom,
    ( ~ esk799_4(X1,X2,X3,X4)
    | ~ esk821_4(X1,X2,X3,X4)
    | ~ esk800_4(X1,X2,X3,X4) ) ).

cnf(i_0_5649,axiom,
    ( ~ p(X3)
    | ~ p(X4)
    | ~ esk269_0
    | ~ p(X1)
    | esk16707_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_5650,axiom,
    ( esk2460_4(X1,X2,X3,X4)
    | ~ esk2580_4(X1,X2,X3,X4)
    | esk2429_4(X1,X2,X3,X4) ) ).

cnf(i_0_5651,axiom,
    ( esk6572_4(X1,X2,X3,X4)
    | ~ esk6699_4(X1,X2,X3,X4)
    | esk6542_4(X1,X2,X3,X4) ) ).

cnf(i_0_5652,axiom,
    ( esk2832_4(X1,X2,X3,X4)
    | esk2884_4(X1,X2,X3,X4) ) ).

cnf(i_0_5653,axiom,
    ( ~ esk9361_4(X1,X2,X3,X4)
    | esk9380_4(X1,X2,X3,X4) ) ).

cnf(i_0_5654,axiom,
    ( esk10721_4(X1,X2,X3,X4)
    | esk10764_4(X1,X2,X3,X4) ) ).

cnf(i_0_5655,axiom,
    ( esk4376_4(X1,X2,X3,X4)
    | esk4394_4(X1,X2,X3,X4) ) ).

cnf(i_0_5656,axiom,
    ( esk6901_4(X1,X2,X3,X4)
    | esk6934_4(X1,X2,X3,X4) ) ).

cnf(i_0_5657,axiom,
    ( ~ esk7156_4(X1,X2,X3,X4)
    | ~ esk7137_4(X1,X2,X3,X4)
    | ~ esk7189_4(X1,X2,X3,X4) ) ).

cnf(i_0_5658,axiom,
    ( ~ esk12526_4(X1,X2,X3,X4)
    | esk12583_4(X1,X2,X3,X4) ) ).

cnf(i_0_5659,axiom,
    ( ~ esk3115_4(X1,X2,X3,X4)
    | ~ esk3079_4(X1,X2,X3,X4)
    | ~ esk3114_4(X1,X2,X3,X4) ) ).

cnf(i_0_5660,axiom,
    ( esk11727_4(X1,X2,X3,X4)
    | esk11741_4(X1,X2,X3,X4) ) ).

cnf(i_0_5661,axiom,
    ( ~ esk16328_4(X1,X2,X3,X4)
    | esk16339_4(X1,X2,X3,X4) ) ).

cnf(i_0_5662,axiom,
    ( esk15210_4(X1,X2,X3,X4)
    | ~ esk15194_4(X1,X2,X3,X4) ) ).

cnf(i_0_5663,axiom,
    ( ~ esk13593_4(X1,X2,X3,X4)
    | ~ esk13626_4(X1,X2,X3,X4)
    | ~ esk13562_4(X1,X2,X3,X4) ) ).

cnf(i_0_5664,axiom,
    ( ~ esk2521_4(X1,X2,X3,X4)
    | ~ esk2507_4(X1,X2,X3,X4)
    | ~ esk2520_4(X1,X2,X3,X4) ) ).

cnf(i_0_5665,axiom,
    ( ~ esk11057_4(X1,X2,X3,X4)
    | esk10976_4(X1,X2,X3,X4) ) ).

cnf(i_0_5666,axiom,
    ( ~ esk9424_4(X1,X2,X3,X4)
    | esk9423_4(X1,X2,X3,X4)
    | esk9428_4(X1,X2,X3,X4) ) ).

cnf(i_0_5667,axiom,
    ( esk7457_4(X1,X2,X3,X4)
    | ~ esk7379_4(X1,X2,X3,X4) ) ).

cnf(i_0_5668,axiom,
    ( esk13597_4(X1,X2,X3,X4)
    | ~ esk13561_4(X1,X2,X3,X4) ) ).

cnf(i_0_5669,axiom,
    ( esk11970_4(X1,X2,X3,X4)
    | ~ esk11950_4(X1,X2,X3,X4) ) ).

cnf(i_0_5670,axiom,
    ( ~ esk8629_4(X1,X2,X3,X4)
    | ~ esk8739_4(X1,X2,X3,X4)
    | esk8615_4(X1,X2,X3,X4) ) ).

cnf(i_0_5671,axiom,
    ( esk3586_4(X1,X2,X3,X4)
    | ~ esk3532_4(X1,X2,X3,X4) ) ).

cnf(i_0_5672,axiom,
    ( esk8388_4(X1,X2,X3,X4)
    | ~ esk8382_4(X1,X2,X3,X4) ) ).

cnf(i_0_5673,axiom,
    ( esk10520_4(X1,X2,X3,X4)
    | esk10575_4(X1,X2,X3,X4) ) ).

cnf(i_0_5674,axiom,
    ( esk14798_4(X1,X2,X3,X4)
    | esk14746_4(X1,X2,X3,X4) ) ).

cnf(i_0_5675,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12214_4(X1,X2,X3,X4) ) ).

cnf(i_0_5676,axiom,
    ( esk9143_4(X1,X2,X3,X4)
    | ~ esk9133_4(X1,X2,X3,X4) ) ).

cnf(i_0_5677,axiom,
    ( esk3317_4(X1,X2,X3,X4)
    | ~ esk3575_4(X1,X2,X3,X4) ) ).

cnf(i_0_5678,axiom,
    ( ~ esk4091_4(X1,X2,X3,X4)
    | esk3993_4(X1,X2,X3,X4)
    | ~ esk4003_4(X1,X2,X3,X4) ) ).

cnf(i_0_5679,axiom,
    ( ~ esk5237_4(X1,X2,X3,X4)
    | ~ esk5289_4(X1,X2,X3,X4)
    | ~ esk5290_4(X1,X2,X3,X4)
    | ~ esk5236_4(X1,X2,X3,X4)
    | ~ esk5239_4(X1,X2,X3,X4) ) ).

cnf(i_0_5680,axiom,
    ( ~ esk6435_4(X1,X2,X3,X4)
    | esk6315_4(X1,X2,X3,X4)
    | esk6284_4(X1,X2,X3,X4) ) ).

cnf(i_0_5681,axiom,
    ( ~ p(X1)
    | ~ p(X4)
    | ~ esk16724_4(X1,X2,X3,X4)
    | ~ p(X2)
    | esk331_0
    | p(X3) ) ).

cnf(i_0_5682,axiom,
    ( esk10494_4(X1,X2,X3,X4)
    | esk10480_4(X1,X2,X3,X4) ) ).

cnf(i_0_5683,axiom,
    ( ~ esk2731_4(X1,X2,X3,X4)
    | ~ esk2732_4(X1,X2,X3,X4) ) ).

cnf(i_0_5684,axiom,
    ( esk503_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1)
    | ~ p(X4)
    | ~ esk155_0
    | p(X2) ) ).

cnf(i_0_5685,axiom,
    ( esk12299_4(X1,X2,X3,X4)
    | esk12385_4(X1,X2,X3,X4) ) ).

cnf(i_0_5686,axiom,
    ( esk9750_4(X1,X2,X3,X4)
    | ~ esk10008_4(X1,X2,X3,X4) ) ).

cnf(i_0_5687,axiom,
    ( ~ esk9026_4(X1,X2,X3,X4)
    | ~ esk9025_4(X1,X2,X3,X4)
    | ~ esk8990_4(X1,X2,X3,X4) ) ).

cnf(i_0_5688,axiom,
    ( ~ esk3550_4(X1,X2,X3,X4)
    | ~ esk3583_4(X1,X2,X3,X4)
    | ~ esk3539_4(X1,X2,X3,X4) ) ).

cnf(i_0_5689,axiom,
    ( esk6047_4(X1,X2,X3,X4)
    | ~ esk6059_4(X1,X2,X3,X4)
    | ~ esk6173_4(X1,X2,X3,X4) ) ).

cnf(i_0_5690,axiom,
    ( esk3534_4(X1,X2,X3,X4)
    | esk3550_4(X1,X2,X3,X4) ) ).

cnf(i_0_5691,axiom,
    ( ~ esk14657_4(X1,X2,X3,X4)
    | ~ esk14539_4(X1,X2,X3,X4) ) ).

cnf(i_0_5692,axiom,
    ( esk9257_4(X1,X2,X3,X4)
    | ~ esk8999_4(X1,X2,X3,X4) ) ).

cnf(i_0_5693,axiom,
    ( esk4085_4(X1,X2,X3,X4)
    | esk4172_4(X1,X2,X3,X4) ) ).

cnf(i_0_5694,axiom,
    ( esk6946_4(X1,X2,X3,X4)
    | ~ esk6688_4(X1,X2,X3,X4) ) ).

cnf(i_0_5695,axiom,
    ( esk6424_4(X1,X2,X3,X4)
    | ~ esk6301_4(X1,X2,X3,X4) ) ).

cnf(i_0_5696,axiom,
    ( esk9279_4(X1,X2,X3,X4)
    | ~ esk9304_4(X1,X2,X3,X4)
    | esk9253_4(X1,X2,X3,X4) ) ).

cnf(i_0_5697,axiom,
    ( ~ esk12313_4(X1,X2,X3,X4)
    | ~ esk12397_4(X1,X2,X3,X4)
    | ~ esk12360_4(X1,X2,X3,X4) ) ).

cnf(i_0_5698,axiom,
    ( esk8512_4(X1,X2,X3,X4)
    | esk8526_4(X1,X2,X3,X4) ) ).

cnf(i_0_5699,axiom,
    ( ~ esk15838_4(X1,X2,X3,X4)
    | ~ esk15840_4(X1,X2,X3,X4) ) ).

cnf(i_0_5700,axiom,
    ( ~ esk4642_4(X1,X2,X3,X4)
    | esk4640_4(X1,X2,X3,X4)
    | esk4641_4(X1,X2,X3,X4) ) ).

cnf(i_0_5701,axiom,
    ( esk4270_4(X1,X2,X3,X4)
    | esk4275_4(X1,X2,X3,X4)
    | ~ esk4276_4(X1,X2,X3,X4) ) ).

cnf(i_0_5702,axiom,
    ( esk1866_4(X1,X2,X3,X4)
    | ~ esk1868_4(X1,X2,X3,X4) ) ).

cnf(i_0_5703,axiom,
    ( ~ esk1296_4(X1,X2,X3,X4)
    | esk1297_4(X1,X2,X3,X4) ) ).

cnf(i_0_5704,axiom,
    ( esk9747_4(X1,X2,X3,X4)
    | esk9714_4(X1,X2,X3,X4) ) ).

cnf(i_0_5705,axiom,
    ( ~ esk7394_4(X1,X2,X3,X4)
    | ~ esk7454_4(X1,X2,X3,X4)
    | ~ esk7421_4(X1,X2,X3,X4) ) ).

cnf(i_0_5706,axiom,
    ( p(X3)
    | ~ p(X4)
    | p(X2)
    | ~ esk297_0
    | ~ p(X1)
    | esk16711_4(X1,X2,X3,X4) ) ).

cnf(i_0_5707,axiom,
    ( esk3644_4(X1,X2,X3,X4)
    | ~ esk3643_4(X1,X2,X3,X4) ) ).

cnf(i_0_5708,axiom,
    ( esk1306_4(X1,X2,X3,X4)
    | esk1299_4(X1,X2,X3,X4) ) ).

cnf(i_0_5709,axiom,
    ( esk7442_4(X1,X2,X3,X4)
    | esk7486_4(X1,X2,X3,X4)
    | ~ esk7493_4(X1,X2,X3,X4) ) ).

cnf(i_0_5710,axiom,
    ( ~ esk4497_4(X1,X2,X3,X4)
    | esk4478_4(X1,X2,X3,X4) ) ).

cnf(i_0_5711,axiom,
    ( ~ esk9729_4(X1,X2,X3,X4)
    | ~ esk9815_4(X1,X2,X3,X4)
    | ~ esk9709_4(X1,X2,X3,X4) ) ).

cnf(i_0_5712,axiom,
    ( ~ esk11168_4(X1,X2,X3,X4)
    | esk11325_4(X1,X2,X3,X4) ) ).

cnf(i_0_5713,axiom,
    ( ~ esk8208_4(X1,X2,X3,X4)
    | esk8160_4(X1,X2,X3,X4) ) ).

cnf(i_0_5714,axiom,
    ( ~ esk5340_4(X1,X2,X3,X4)
    | ~ esk5368_4(X1,X2,X3,X4)
    | ~ esk5453_4(X1,X2,X3,X4) ) ).

cnf(i_0_5715,axiom,
    ( esk2596_4(X1,X2,X3,X4)
    | esk2597_4(X1,X2,X3,X4)
    | esk2595_4(X1,X2,X3,X4) ) ).

cnf(i_0_5716,axiom,
    ( esk16433_4(X1,X2,X3,X4)
    | ~ esk16332_4(X1,X2,X3,X4) ) ).

cnf(i_0_5717,axiom,
    ( ~ esk3819_4(X1,X2,X3,X4)
    | ~ esk3852_4(X1,X2,X3,X4)
    | ~ esk3796_4(X1,X2,X3,X4) ) ).

cnf(i_0_5718,axiom,
    ( ~ esk4079_4(X1,X2,X3,X4)
    | ~ esk4055_4(X1,X2,X3,X4)
    | ~ esk4185_4(X1,X2,X3,X4) ) ).

cnf(i_0_5719,axiom,
    ( ~ esk7184_4(X1,X2,X3,X4)
    | esk7130_4(X1,X2,X3,X4) ) ).

cnf(i_0_5720,axiom,
    ( esk15054_4(X1,X2,X3,X4)
    | ~ esk15043_4(X1,X2,X3,X4) ) ).

cnf(i_0_5721,axiom,
    ( ~ esk4894_4(X1,X2,X3,X4)
    | esk4895_4(X1,X2,X3,X4) ) ).

cnf(i_0_5722,axiom,
    ( esk11285_4(X1,X2,X3,X4)
    | ~ esk11188_4(X1,X2,X3,X4) ) ).

cnf(i_0_5723,axiom,
    ( ~ esk2040_4(X1,X2,X3,X4)
    | esk1992_4(X1,X2,X3,X4) ) ).

cnf(i_0_5724,axiom,
    ( ~ esk4091_4(X1,X2,X3,X4)
    | esk3833_4(X1,X2,X3,X4) ) ).

cnf(i_0_5725,axiom,
    ( ~ esk1177_4(X1,X2,X3,X4)
    | ~ esk1124_4(X1,X2,X3,X4)
    | ~ esk1125_4(X1,X2,X3,X4)
    | ~ esk1127_4(X1,X2,X3,X4)
    | ~ esk1178_4(X1,X2,X3,X4) ) ).

cnf(i_0_5726,axiom,
    ( esk10428_4(X1,X2,X3,X4)
    | ~ esk10420_4(X1,X2,X3,X4) ) ).

cnf(i_0_5727,axiom,
    ( esk14844_4(X1,X2,X3,X4)
    | esk14855_4(X1,X2,X3,X4) ) ).

cnf(i_0_5728,axiom,
    ( esk6658_4(X1,X2,X3,X4)
    | ~ esk6622_4(X1,X2,X3,X4) ) ).

cnf(i_0_5729,axiom,
    ( esk8173_4(X1,X2,X3,X4)
    | esk8167_4(X1,X2,X3,X4) ) ).

cnf(i_0_5730,axiom,
    ( ~ p(X4)
    | ~ p(X1)
    | ~ esk515_4(X1,X2,X3,X4)
    | p(X3)
    | esk255_0
    | ~ p(X2) ) ).

cnf(i_0_5731,axiom,
    ( ~ esk5698_4(X1,X2,X3,X4)
    | esk5696_4(X1,X2,X3,X4) ) ).

cnf(i_0_5732,axiom,
    ( esk795_4(X1,X2,X3,X4)
    | ~ esk832_4(X1,X2,X3,X4)
    | esk748_4(X1,X2,X3,X4) ) ).

cnf(i_0_5733,axiom,
    ( ~ esk11456_4(X1,X2,X3,X4)
    | esk11446_4(X1,X2,X3,X4)
    | ~ esk11544_4(X1,X2,X3,X4) ) ).

cnf(i_0_5734,axiom,
    ( esk15456_4(X1,X2,X3,X4)
    | esk15455_4(X1,X2,X3,X4)
    | esk15454_4(X1,X2,X3,X4) ) ).

cnf(i_0_5735,axiom,
    ( ~ esk15594_4(X1,X2,X3,X4)
    | esk15593_4(X1,X2,X3,X4) ) ).

cnf(i_0_5736,axiom,
    ( esk12022_4(X1,X2,X3,X4)
    | esk12050_4(X1,X2,X3,X4) ) ).

cnf(i_0_5737,axiom,
    ( ~ esk8207_4(X1,X2,X3,X4)
    | esk8288_4(X1,X2,X3,X4)
    | esk8295_4(X1,X2,X3,X4) ) ).

cnf(i_0_5738,axiom,
    ( ~ esk8993_4(X1,X2,X3,X4)
    | esk8924_4(X1,X2,X3,X4) ) ).

cnf(i_0_5739,axiom,
    ( ~ esk7356_4(X1,X2,X3,X4)
    | ~ esk7355_4(X1,X2,X3,X4) ) ).

cnf(i_0_5740,axiom,
    ( ~ esk8194_4(X1,X2,X3,X4)
    | ~ esk8151_4(X1,X2,X3,X4)
    | ~ esk8195_4(X1,X2,X3,X4) ) ).

cnf(i_0_5741,axiom,
    ( esk13356_4(X1,X2,X3,X4)
    | ~ esk13296_4(X1,X2,X3,X4) ) ).

cnf(i_0_5742,axiom,
    ( ~ esk984_4(X1,X2,X3,X4)
    | ~ esk969_4(X1,X2,X3,X4)
    | ~ esk1017_4(X1,X2,X3,X4) ) ).

cnf(i_0_5743,axiom,
    ( esk5957_4(X1,X2,X3,X4)
    | ~ esk5943_4(X1,X2,X3,X4) ) ).

cnf(i_0_5744,axiom,
    ( ~ esk2463_4(X1,X2,X3,X4)
    | ~ esk2411_4(X1,X2,X3,X4) ) ).

cnf(i_0_5745,axiom,
    ( ~ esk4546_4(X1,X2,X3,X4)
    | esk4542_4(X1,X2,X3,X4) ) ).

cnf(i_0_5746,axiom,
    ( ~ esk1189_4(X1,X2,X3,X4)
    | ~ esk1191_4(X1,X2,X3,X4) ) ).

cnf(i_0_5747,axiom,
    ( esk6192_4(X1,X2,X3,X4)
    | ~ esk6145_4(X1,X2,X3,X4)
    | esk6229_4(X1,X2,X3,X4) ) ).

cnf(i_0_5748,axiom,
    ( ~ esk3616_4(X1,X2,X3,X4)
    | esk3614_4(X1,X2,X3,X4) ) ).

cnf(i_0_5749,axiom,
    ( esk14076_4(X1,X2,X3,X4)
    | esk14056_4(X1,X2,X3,X4)
    | esk14022_4(X1,X2,X3,X4) ) ).

cnf(i_0_5750,axiom,
    ( ~ esk7184_4(X1,X2,X3,X4)
    | esk7442_4(X1,X2,X3,X4) ) ).

cnf(i_0_5751,axiom,
    ( esk8835_4(X1,X2,X3,X4)
    | esk8887_4(X1,X2,X3,X4) ) ).

cnf(i_0_5752,axiom,
    ( esk14528_4(X1,X2,X3,X4)
    | ~ esk14540_4(X1,X2,X3,X4)
    | ~ esk14654_4(X1,X2,X3,X4) ) ).

cnf(i_0_5753,axiom,
    ( ~ esk11694_4(X1,X2,X3,X4)
    | esk11673_4(X1,X2,X3,X4) ) ).

cnf(i_0_5754,axiom,
    ( ~ esk5081_4(X1,X2,X3,X4)
    | ~ esk5127_4(X1,X2,X3,X4)
    | ~ esk5094_4(X1,X2,X3,X4) ) ).

cnf(i_0_5755,axiom,
    ( esk3005_4(X1,X2,X3,X4)
    | esk3025_4(X1,X2,X3,X4)
    | esk2971_4(X1,X2,X3,X4) ) ).

cnf(i_0_5756,axiom,
    ( ~ esk12309_4(X1,X2,X3,X4)
    | ~ esk12262_4(X1,X2,X3,X4)
    | ~ esk12308_4(X1,X2,X3,X4) ) ).

cnf(i_0_5757,axiom,
    ( ~ esk3155_4(X1,X2,X3,X4)
    | ~ esk3120_4(X1,X2,X3,X4)
    | ~ esk3069_4(X1,X2,X3,X4) ) ).

cnf(i_0_5758,axiom,
    ( ~ esk7858_4(X1,X2,X3,X4)
    | esk7834_4(X1,X2,X3,X4) ) ).

cnf(i_0_5759,axiom,
    ( ~ esk564_4(X1,X2,X3,X4)
    | esk542_4(X1,X2,X3,X4)
    | esk543_4(X1,X2,X3,X4) ) ).

cnf(i_0_5760,axiom,
    ( ~ esk7113_4(X1,X2,X3,X4)
    | esk7111_4(X1,X2,X3,X4) ) ).

cnf(i_0_5761,axiom,
    ( esk9611_4(X1,X2,X3,X4)
    | ~ esk9644_4(X1,X2,X3,X4) ) ).

cnf(i_0_5762,axiom,
    ( esk8480_4(X1,X2,X3,X4)
    | esk8532_4(X1,X2,X3,X4)
    | ~ esk8551_4(X1,X2,X3,X4) ) ).

cnf(i_0_5763,axiom,
    ( esk1433_4(X1,X2,X3,X4)
    | ~ esk1425_4(X1,X2,X3,X4) ) ).

cnf(i_0_5764,axiom,
    ( ~ esk14656_4(X1,X2,X3,X4)
    | ~ esk14671_4(X1,X2,X3,X4) ) ).

cnf(i_0_5765,axiom,
    ( esk7907_4(X1,X2,X3,X4)
    | ~ esk7943_4(X1,X2,X3,X4) ) ).

cnf(i_0_5766,axiom,
    ( esk10708_4(X1,X2,X3,X4)
    | esk10690_4(X1,X2,X3,X4) ) ).

cnf(i_0_5767,axiom,
    ( ~ esk3910_4(X1,X2,X3,X4)
    | esk3858_4(X1,X2,X3,X4)
    | esk3880_4(X1,X2,X3,X4) ) ).

cnf(i_0_5768,axiom,
    ( ~ esk9430_4(X1,X2,X3,X4)
    | ~ esk9522_4(X1,X2,X3,X4) ) ).

cnf(i_0_5769,axiom,
    ( ~ esk3598_4(X1,X2,X3,X4)
    | esk3526_4(X1,X2,X3,X4) ) ).

cnf(i_0_5770,axiom,
    ( ~ esk1025_4(X1,X2,X3,X4)
    | ~ esk919_4(X1,X2,X3,X4)
    | esk903_4(X1,X2,X3,X4) ) ).

cnf(i_0_5771,axiom,
    ( ~ esk2346_4(X1,X2,X3,X4)
    | ~ esk2385_4(X1,X2,X3,X4) ) ).

cnf(i_0_5772,axiom,
    ( ~ esk15582_4(X1,X2,X3,X4)
    | ~ esk15580_4(X1,X2,X3,X4) ) ).

cnf(i_0_5773,axiom,
    ( esk4060_4(X1,X2,X3,X4)
    | esk4050_4(X1,X2,X3,X4) ) ).

cnf(i_0_5774,axiom,
    ( esk9195_4(X1,X2,X3,X4)
    | esk9217_4(X1,X2,X3,X4) ) ).

cnf(i_0_5775,axiom,
    ( esk3027_4(X1,X2,X3,X4)
    | esk3037_4(X1,X2,X3,X4) ) ).

cnf(i_0_5776,axiom,
    ( esk3065_4(X1,X2,X3,X4)
    | esk3032_4(X1,X2,X3,X4) ) ).

cnf(i_0_5777,axiom,
    ( ~ esk12997_4(X1,X2,X3,X4)
    | ~ esk12974_4(X1,X2,X3,X4) ) ).

cnf(i_0_5778,axiom,
    ( ~ esk7463_4(X1,X2,X3,X4)
    | esk7312_4(X1,X2,X3,X4)
    | esk7343_4(X1,X2,X3,X4) ) ).

cnf(i_0_5779,axiom,
    ( esk8681_4(X1,X2,X3,X4)
    | esk8697_4(X1,X2,X3,X4) ) ).

cnf(i_0_5780,axiom,
    ( esk9502_4(X1,X2,X3,X4)
    | ~ esk9244_4(X1,X2,X3,X4) ) ).

cnf(i_0_5781,axiom,
    ( ~ esk211_0
    | ~ p(X2)
    | esk509_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X4)
    | ~ p(X3) ) ).

cnf(i_0_5782,axiom,
    ( ~ esk4433_4(X1,X2,X3,X4)
    | ~ esk4443_4(X1,X2,X3,X4) ) ).

cnf(i_0_5783,axiom,
    ( ~ esk13328_4(X1,X2,X3,X4)
    | ~ esk13361_4(X1,X2,X3,X4)
    | ~ esk13305_4(X1,X2,X3,X4) ) ).

cnf(i_0_5784,axiom,
    ( ~ esk5126_4(X1,X2,X3,X4)
    | esk5075_4(X1,X2,X3,X4) ) ).

cnf(i_0_5785,axiom,
    ( esk7691_4(X1,X2,X3,X4)
    | esk7658_4(X1,X2,X3,X4) ) ).

cnf(i_0_5786,axiom,
    ( ~ esk15712_4(X1,X2,X3,X4)
    | ~ esk15664_4(X1,X2,X3,X4) ) ).

cnf(i_0_5787,axiom,
    ( ~ esk6472_4(X1,X2,X3,X4)
    | esk6418_4(X1,X2,X3,X4)
    | esk6456_4(X1,X2,X3,X4) ) ).

cnf(i_0_5788,axiom,
    ( ~ esk7675_4(X1,X2,X3,X4)
    | ~ esk7760_4(X1,X2,X3,X4)
    | ~ esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_5789,axiom,
    ( esk2252_4(X1,X2,X3,X4)
    | esk2259_4(X1,X2,X3,X4) ) ).

cnf(i_0_5790,axiom,
    ( esk15291_4(X1,X2,X3,X4)
    | ~ esk15311_4(X1,X2,X3,X4)
    | ~ esk15409_4(X1,X2,X3,X4) ) ).

cnf(i_0_5791,axiom,
    ( esk9979_4(X1,X2,X3,X4)
    | esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_5792,axiom,
    ( ~ esk8783_4(X1,X2,X3,X4)
    | esk8784_4(X1,X2,X3,X4) ) ).

cnf(i_0_5793,axiom,
    ( esk2220_4(X1,X2,X3,X4)
    | ~ esk2222_4(X1,X2,X3,X4) ) ).

cnf(i_0_5794,axiom,
    ( ~ esk16216_4(X1,X2,X3,X4)
    | esk16246_4(X1,X2,X3,X4) ) ).

cnf(i_0_5795,axiom,
    ( esk13401_4(X1,X2,X3,X4)
    | esk13403_4(X1,X2,X3,X4)
    | esk13402_4(X1,X2,X3,X4) ) ).

cnf(i_0_5796,axiom,
    ( esk13887_4(X1,X2,X3,X4)
    | ~ esk13889_4(X1,X2,X3,X4) ) ).

cnf(i_0_5797,axiom,
    ( esk6160_4(X1,X2,X3,X4)
    | ~ esk6418_4(X1,X2,X3,X4) ) ).

cnf(i_0_5798,axiom,
    ( ~ esk2721_4(X1,X2,X3,X4)
    | ~ esk2715_4(X1,X2,X3,X4)
    | esk2716_4(X1,X2,X3,X4) ) ).

cnf(i_0_5799,axiom,
    ( esk460_4(X1,X2,X3,X4)
    | esk455_4(X1,X2,X3,X4) ) ).

cnf(i_0_5800,axiom,
    ( ~ esk11357_4(X1,X2,X3,X4)
    | ~ esk11251_4(X1,X2,X3,X4)
    | ~ esk11271_4(X1,X2,X3,X4) ) ).

cnf(i_0_5801,axiom,
    ( ~ esk10035_4(X1,X2,X3,X4)
    | esk10293_4(X1,X2,X3,X4) ) ).

cnf(i_0_5802,axiom,
    ( esk9270_4(X1,X2,X3,X4)
    | ~ esk9271_4(X1,X2,X3,X4) ) ).

cnf(i_0_5803,axiom,
    ( ~ esk14013_4(X1,X2,X3,X4)
    | esk14138_4(X1,X2,X3,X4) ) ).

cnf(i_0_5804,axiom,
    ( esk2023_4(X1,X2,X3,X4)
    | esk1999_4(X1,X2,X3,X4) ) ).

cnf(i_0_5805,axiom,
    ( esk3828_4(X1,X2,X3,X4)
    | esk3915_4(X1,X2,X3,X4) ) ).

cnf(i_0_5806,axiom,
    ( esk9944_4(X1,X2,X3,X4)
    | esk10036_4(X1,X2,X3,X4)
    | esk10043_4(X1,X2,X3,X4) ) ).

cnf(i_0_5807,axiom,
    ( esk14178_4(X1,X2,X3,X4)
    | ~ esk14207_4(X1,X2,X3,X4) ) ).

cnf(i_0_5808,axiom,
    ( esk11379_4(X1,X2,X3,X4)
    | esk11344_4(X1,X2,X3,X4) ) ).

cnf(i_0_5809,axiom,
    ( esk10006_4(X1,X2,X3,X4)
    | esk10061_4(X1,X2,X3,X4) ) ).

cnf(i_0_5810,axiom,
    ( ~ esk6266_4(X1,X2,X3,X4)
    | ~ esk6318_4(X1,X2,X3,X4) ) ).

cnf(i_0_5811,axiom,
    ( ~ esk2441_4(X1,X2,X3,X4)
    | esk2422_4(X1,X2,X3,X4) ) ).

cnf(i_0_5812,axiom,
    ( ~ esk7185_4(X1,X2,X3,X4)
    | ~ esk7236_4(X1,X2,X3,X4)
    | ~ esk7229_4(X1,X2,X3,X4) ) ).

cnf(i_0_5813,axiom,
    ( ~ esk2107_4(X1,X2,X3,X4)
    | esk2055_4(X1,X2,X3,X4)
    | esk2126_4(X1,X2,X3,X4) ) ).

cnf(i_0_5814,axiom,
    ( esk12739_4(X1,X2,X3,X4)
    | ~ esk12719_4(X1,X2,X3,X4) ) ).

cnf(i_0_5815,axiom,
    ( esk7615_4(X1,X2,X3,X4)
    | esk7608_4(X1,X2,X3,X4)
    | ~ esk7622_4(X1,X2,X3,X4) ) ).

cnf(i_0_5816,axiom,
    ( esk5835_4(X1,X2,X3,X4)
    | esk5924_4(X1,X2,X3,X4) ) ).

cnf(i_0_5817,axiom,
    ( esk13877_4(X1,X2,X3,X4)
    | ~ esk13754_4(X1,X2,X3,X4) ) ).

cnf(i_0_5818,axiom,
    ( ~ esk16132_4(X1,X2,X3,X4)
    | ~ esk16161_4(X1,X2,X3,X4)
    | ~ esk16194_4(X1,X2,X3,X4) ) ).

cnf(i_0_5819,axiom,
    ( ~ esk9719_4(X1,X2,X3,X4)
    | ~ esk9831_4(X1,X2,X3,X4)
    | ~ esk9709_4(X1,X2,X3,X4) ) ).

cnf(i_0_5820,axiom,
    ( ~ esk15681_4(X1,X2,X3,X4)
    | esk15603_4(X1,X2,X3,X4) ) ).

cnf(i_0_5821,axiom,
    ( esk7908_4(X1,X2,X3,X4)
    | esk7919_4(X1,X2,X3,X4) ) ).

cnf(i_0_5822,axiom,
    ( ~ esk3370_4(X1,X2,X3,X4)
    | esk3369_4(X1,X2,X3,X4)
    | esk3391_4(X1,X2,X3,X4) ) ).

cnf(i_0_5823,axiom,
    ( esk4623_4(X1,X2,X3,X4)
    | esk4654_4(X1,X2,X3,X4) ) ).

cnf(i_0_5824,axiom,
    ( esk9879_4(X1,X2,X3,X4)
    | ~ esk9905_4(X1,X2,X3,X4) ) ).

cnf(i_0_5825,axiom,
    ( ~ esk10725_4(X1,X2,X3,X4)
    | esk10788_4(X1,X2,X3,X4) ) ).

cnf(i_0_5826,axiom,
    ( esk2766_4(X1,X2,X3,X4)
    | esk2773_4(X1,X2,X3,X4) ) ).

cnf(i_0_5827,axiom,
    ( ~ esk4132_4(X1,X2,X3,X4)
    | ~ esk4133_4(X1,X2,X3,X4) ) ).

cnf(i_0_5828,axiom,
    ( ~ esk7887_4(X1,X2,X3,X4)
    | esk7885_4(X1,X2,X3,X4) ) ).

cnf(i_0_5829,axiom,
    ( esk13425_4(X1,X2,X3,X4)
    | esk13309_4(X1,X2,X3,X4) ) ).

cnf(i_0_5830,axiom,
    ( esk10786_4(X1,X2,X3,X4)
    | ~ esk10726_4(X1,X2,X3,X4) ) ).

cnf(i_0_5831,axiom,
    ( ~ esk5427_4(X1,X2,X3,X4)
    | ~ esk5426_4(X1,X2,X3,X4) ) ).

cnf(i_0_5832,axiom,
    ( ~ esk10192_4(X1,X2,X3,X4)
    | esk10185_4(X1,X2,X3,X4)
    | esk10178_4(X1,X2,X3,X4) ) ).

cnf(i_0_5833,axiom,
    ( esk13819_4(X1,X2,X3,X4)
    | esk13826_4(X1,X2,X3,X4) ) ).

cnf(i_0_5834,axiom,
    ( esk3365_4(X1,X2,X3,X4)
    | ~ esk3320_4(X1,X2,X3,X4)
    | ~ esk3380_4(X1,X2,X3,X4) ) ).

cnf(i_0_5835,axiom,
    ( ~ esk3854_4(X1,X2,X3,X4)
    | esk3906_4(X1,X2,X3,X4)
    | esk3925_4(X1,X2,X3,X4) ) ).

cnf(i_0_5836,axiom,
    ( esk7445_4(X1,X2,X3,X4)
    | ~ esk7703_4(X1,X2,X3,X4) ) ).

cnf(i_0_5837,axiom,
    ( ~ esk13143_4(X1,X2,X3,X4)
    | ~ esk13141_4(X1,X2,X3,X4) ) ).

cnf(i_0_5838,axiom,
    ( esk7112_4(X1,X2,X3,X4)
    | ~ esk7113_4(X1,X2,X3,X4) ) ).

cnf(i_0_5839,axiom,
    ( esk10207_4(X1,X2,X3,X4)
    | ~ esk10282_4(X1,X2,X3,X4) ) ).

cnf(i_0_5840,axiom,
    ( esk1205_4(X1,X2,X3,X4)
    | ~ esk1203_4(X1,X2,X3,X4) ) ).

cnf(i_0_5841,axiom,
    ( esk7966_4(X1,X2,X3,X4)
    | esk8018_4(X1,X2,X3,X4)
    | ~ esk8037_4(X1,X2,X3,X4) ) ).

cnf(i_0_5842,axiom,
    ( esk9780_4(X1,X2,X3,X4)
    | esk9634_4(X1,X2,X3,X4) ) ).

cnf(i_0_5843,axiom,
    ( ~ esk6109_4(X1,X2,X3,X4)
    | ~ esk6120_4(X1,X2,X3,X4)
    | ~ esk6153_4(X1,X2,X3,X4) ) ).

cnf(i_0_5844,axiom,
    ( esk10336_4(X1,X2,X3,X4)
    | esk10251_4(X1,X2,X3,X4) ) ).

cnf(i_0_5845,axiom,
    ( esk405_4(X1,X2,X3,X4)
    | ~ esk395_4(X1,X2,X3,X4) ) ).

cnf(i_0_5846,axiom,
    ( ~ esk1485_4(X1,X2,X3,X4)
    | ~ esk1491_4(X1,X2,X3,X4)
    | ~ esk1605_4(X1,X2,X3,X4) ) ).

cnf(i_0_5847,axiom,
    ( ~ esk10297_4(X1,X2,X3,X4)
    | esk10170_4(X1,X2,X3,X4)
    | esk10140_4(X1,X2,X3,X4) ) ).

cnf(i_0_5848,axiom,
    ( esk12645_4(X1,X2,X3,X4)
    | esk12594_4(X1,X2,X3,X4)
    | ~ esk12620_4(X1,X2,X3,X4) ) ).

cnf(i_0_5849,axiom,
    ( ~ esk15884_4(X1,X2,X3,X4)
    | ~ esk15885_4(X1,X2,X3,X4)
    | ~ esk15871_4(X1,X2,X3,X4) ) ).

cnf(i_0_5850,axiom,
    ( esk5400_4(X1,X2,X3,X4)
    | ~ esk5275_4(X1,X2,X3,X4) ) ).

cnf(i_0_5851,axiom,
    ( ~ esk12151_4(X1,X2,X3,X4)
    | esk12122_4(X1,X2,X3,X4) ) ).

cnf(i_0_5852,axiom,
    ( esk11036_4(X1,X2,X3,X4)
    | esk11087_4(X1,X2,X3,X4)
    | ~ esk11116_4(X1,X2,X3,X4) ) ).

cnf(i_0_5853,axiom,
    ( esk15343_4(X1,X2,X3,X4)
    | ~ esk15307_4(X1,X2,X3,X4) ) ).

cnf(i_0_5854,axiom,
    ( ~ esk2281_4(X1,X2,X3,X4)
    | ~ esk2254_4(X1,X2,X3,X4)
    | ~ esk2314_4(X1,X2,X3,X4) ) ).

cnf(i_0_5855,axiom,
    ( ~ esk3128_4(X1,X2,X3,X4)
    | esk3126_4(X1,X2,X3,X4) ) ).

cnf(i_0_5856,axiom,
    ( esk13516_4(X1,X2,X3,X4)
    | ~ esk13774_4(X1,X2,X3,X4) ) ).

cnf(i_0_5857,axiom,
    ( ~ esk15828_4(X1,X2,X3,X4)
    | esk15825_4(X1,X2,X3,X4)
    | ~ esk15801_4(X1,X2,X3,X4) ) ).

cnf(i_0_5858,axiom,
    ( esk2889_4(X1,X2,X3,X4)
    | esk2774_4(X1,X2,X3,X4) ) ).

cnf(i_0_5859,axiom,
    ( esk9937_4(X1,X2,X3,X4)
    | esk9919_4(X1,X2,X3,X4) ) ).

cnf(i_0_5860,axiom,
    ( ~ esk10933_4(X1,X2,X3,X4)
    | esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_5861,axiom,
    ( esk6192_4(X1,X2,X3,X4)
    | ~ esk6147_4(X1,X2,X3,X4)
    | ~ esk6207_4(X1,X2,X3,X4) ) ).

cnf(i_0_5862,axiom,
    ( ~ esk15682_4(X1,X2,X3,X4)
    | ~ esk15734_4(X1,X2,X3,X4) ) ).

cnf(i_0_5863,axiom,
    ( ~ esk517_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X1)
    | p(X2)
    | ~ p(X4)
    | esk268_0 ) ).

cnf(i_0_5864,axiom,
    ( esk566_4(X1,X2,X3,X4)
    | esk483_4(X1,X2,X3,X4) ) ).

cnf(i_0_5865,axiom,
    ( esk12749_4(X1,X2,X3,X4)
    | esk12760_4(X1,X2,X3,X4)
    | ~ esk12761_4(X1,X2,X3,X4) ) ).

cnf(i_0_5866,axiom,
    ( ~ esk3626_4(X1,X2,X3,X4)
    | ~ esk3595_4(X1,X2,X3,X4) ) ).

cnf(i_0_5867,axiom,
    ( ~ esk15549_4(X1,X2,X3,X4)
    | esk15528_4(X1,X2,X3,X4) ) ).

cnf(i_0_5868,axiom,
    ( esk8115_4(X1,X2,X3,X4)
    | ~ esk8096_4(X1,X2,X3,X4) ) ).

cnf(i_0_5869,axiom,
    ( esk56_0
    | ~ p(X1)
    | p(X3)
    | ~ p(X4)
    | ~ esk433_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_5870,axiom,
    ( ~ esk3990_4(X1,X2,X3,X4)
    | esk3957_4(X1,X2,X3,X4) ) ).

cnf(i_0_5871,axiom,
    ( esk8524_4(X1,X2,X3,X4)
    | ~ esk8553_4(X1,X2,X3,X4) ) ).

cnf(i_0_5872,axiom,
    ( ~ esk14925_4(X1,X2,X3,X4)
    | esk15183_4(X1,X2,X3,X4) ) ).

cnf(i_0_5873,axiom,
    ( ~ esk5801_4(X1,X2,X3,X4)
    | esk5928_4(X1,X2,X3,X4) ) ).

cnf(i_0_5874,axiom,
    ( esk16484_4(X1,X2,X3,X4)
    | esk16433_4(X1,X2,X3,X4)
    | ~ esk16513_4(X1,X2,X3,X4) ) ).

cnf(i_0_5875,axiom,
    ( esk702_4(X1,X2,X3,X4)
    | ~ esk765_4(X1,X2,X3,X4) ) ).

cnf(i_0_5876,axiom,
    ( ~ esk15577_4(X1,X2,X3,X4)
    | esk15835_4(X1,X2,X3,X4) ) ).

cnf(i_0_5877,axiom,
    ( esk15944_4(X1,X2,X3,X4)
    | ~ esk15824_4(X1,X2,X3,X4) ) ).

cnf(i_0_5878,axiom,
    ( ~ esk14592_4(X1,X2,X3,X4)
    | ~ esk14622_4(X1,X2,X3,X4)
    | ~ esk14709_4(X1,X2,X3,X4) ) ).

cnf(i_0_5879,axiom,
    ( esk920_4(X1,X2,X3,X4)
    | esk868_4(X1,X2,X3,X4) ) ).

cnf(i_0_5880,axiom,
    ( ~ esk16191_4(X1,X2,X3,X4)
    | esk16119_4(X1,X2,X3,X4) ) ).

cnf(i_0_5881,axiom,
    ( esk7268_4(X1,X2,X3,X4)
    | esk7187_4(X1,X2,X3,X4) ) ).

cnf(i_0_5882,axiom,
    ( ~ esk3290_4(X1,X2,X3,X4)
    | ~ esk3289_4(X1,X2,X3,X4)
    | ~ esk3279_4(X1,X2,X3,X4) ) ).

cnf(i_0_5883,axiom,
    ( ~ esk4127_4(X1,X2,X3,X4)
    | ~ esk4002_4(X1,X2,X3,X4) ) ).

cnf(i_0_5884,axiom,
    ( esk791_4(X1,X2,X3,X4)
    | esk693_4(X1,X2,X3,X4) ) ).

cnf(i_0_5885,axiom,
    ( esk2004_4(X1,X2,X3,X4)
    | esk1994_4(X1,X2,X3,X4) ) ).

cnf(i_0_5886,axiom,
    ( ~ esk15700_4(X1,X2,X3,X4)
    | esk15720_4(X1,X2,X3,X4) ) ).

cnf(i_0_5887,axiom,
    ( esk13725_4(X1,X2,X3,X4)
    | ~ esk13754_4(X1,X2,X3,X4) ) ).

cnf(i_0_5888,axiom,
    ( esk4540_4(X1,X2,X3,X4)
    | esk4545_4(X1,X2,X3,X4)
    | ~ esk4541_4(X1,X2,X3,X4) ) ).

cnf(i_0_5889,axiom,
    ( esk15311_4(X1,X2,X3,X4)
    | ~ esk15300_4(X1,X2,X3,X4) ) ).

cnf(i_0_5890,axiom,
    ( ~ esk6987_4(X1,X2,X3,X4)
    | esk6985_4(X1,X2,X3,X4) ) ).

cnf(i_0_5891,axiom,
    ( ~ esk1676_4(X1,X2,X3,X4)
    | esk1800_4(X1,X2,X3,X4) ) ).

cnf(i_0_5892,axiom,
    ( ~ esk15825_4(X1,X2,X3,X4)
    | esk15828_4(X1,X2,X3,X4) ) ).

cnf(i_0_5893,axiom,
    ( esk6938_4(X1,X2,X3,X4)
    | esk6905_4(X1,X2,X3,X4) ) ).

cnf(i_0_5894,axiom,
    ( ~ esk13159_4(X1,X2,X3,X4)
    | esk13108_4(X1,X2,X3,X4)
    | esk13134_4(X1,X2,X3,X4) ) ).

cnf(i_0_5895,axiom,
    ( esk9568_4(X1,X2,X3,X4)
    | ~ esk9531_4(X1,X2,X3,X4) ) ).

cnf(i_0_5896,axiom,
    ( ~ esk1821_4(X1,X2,X3,X4)
    | esk1858_4(X1,X2,X3,X4) ) ).

cnf(i_0_5897,axiom,
    ( esk4593_4(X1,X2,X3,X4)
    | esk4555_4(X1,X2,X3,X4) ) ).

cnf(i_0_5898,axiom,
    ( esk8865_4(X1,X2,X3,X4)
    | ~ esk8917_4(X1,X2,X3,X4) ) ).

cnf(i_0_5899,axiom,
    ( esk9930_4(X1,X2,X3,X4)
    | ~ esk9924_4(X1,X2,X3,X4) ) ).

cnf(i_0_5900,axiom,
    ( ~ esk1499_4(X1,X2,X3,X4)
    | ~ esk1498_4(X1,X2,X3,X4)
    | ~ esk1476_4(X1,X2,X3,X4) ) ).

cnf(i_0_5901,axiom,
    ( ~ esk6900_4(X1,X2,X3,X4)
    | ~ esk6987_4(X1,X2,X3,X4)
    | ~ esk6882_4(X1,X2,X3,X4) ) ).

cnf(i_0_5902,axiom,
    ( esk645_4(X1,X2,X3,X4)
    | ~ esk620_4(X1,X2,X3,X4) ) ).

cnf(i_0_5903,axiom,
    ( ~ esk12271_4(X1,X2,X3,X4)
    | esk12322_4(X1,X2,X3,X4) ) ).

cnf(i_0_5904,axiom,
    ( ~ esk6997_4(X1,X2,X3,X4)
    | ~ esk6998_4(X1,X2,X3,X4)
    | esk6999_4(X1,X2,X3,X4) ) ).

cnf(i_0_5905,axiom,
    ( ~ esk5054_4(X1,X2,X3,X4)
    | ~ esk5036_4(X1,X2,X3,X4) ) ).

cnf(i_0_5906,axiom,
    ( esk919_4(X1,X2,X3,X4)
    | ~ esk903_4(X1,X2,X3,X4) ) ).

cnf(i_0_5907,axiom,
    ( ~ esk9737_4(X1,X2,X3,X4)
    | ~ esk9709_4(X1,X2,X3,X4)
    | ~ esk9822_4(X1,X2,X3,X4) ) ).

cnf(i_0_5908,axiom,
    ( esk14075_4(X1,X2,X3,X4)
    | ~ esk14111_4(X1,X2,X3,X4) ) ).

cnf(i_0_5909,axiom,
    ( esk9612_4(X1,X2,X3,X4)
    | ~ esk9643_4(X1,X2,X3,X4) ) ).

cnf(i_0_5910,axiom,
    ( esk5435_4(X1,X2,X3,X4)
    | esk5433_4(X1,X2,X3,X4) ) ).

cnf(i_0_5911,axiom,
    ( ~ esk16626_4(X1,X2,X3,X4)
    | ~ esk16718_4(X1,X2,X3,X4) ) ).

cnf(i_0_5912,axiom,
    ( ~ esk1651_4(X1,X2,X3,X4)
    | esk1670_4(X1,X2,X3,X4) ) ).

cnf(i_0_5913,axiom,
    ( ~ esk5816_4(X1,X2,X3,X4)
    | esk5823_4(X1,X2,X3,X4) ) ).

cnf(i_0_5914,axiom,
    ( ~ esk5543_4(X1,X2,X3,X4)
    | esk5542_4(X1,X2,X3,X4) ) ).

cnf(i_0_5915,axiom,
    ( esk7905_4(X1,X2,X3,X4)
    | ~ esk7947_4(X1,X2,X3,X4) ) ).

cnf(i_0_5916,axiom,
    ( ~ esk11356_4(X1,X2,X3,X4)
    | esk11354_4(X1,X2,X3,X4) ) ).

cnf(i_0_5917,axiom,
    ( ~ esk4768_4(X1,X2,X3,X4)
    | esk4736_4(X1,X2,X3,X4) ) ).

cnf(i_0_5918,axiom,
    ( ~ esk8458_4(X1,X2,X3,X4)
    | ~ esk8542_4(X1,X2,X3,X4)
    | ~ esk8505_4(X1,X2,X3,X4) ) ).

cnf(i_0_5919,axiom,
    ( ~ esk4798_4(X1,X2,X3,X4)
    | ~ esk4799_4(X1,X2,X3,X4)
    | esk4800_4(X1,X2,X3,X4) ) ).

cnf(i_0_5920,axiom,
    ( esk4569_4(X1,X2,X3,X4)
    | esk4575_4(X1,X2,X3,X4) ) ).

cnf(i_0_5921,axiom,
    ( esk4662_4(X1,X2,X3,X4)
    | esk4664_4(X1,X2,X3,X4) ) ).

cnf(i_0_5922,axiom,
    ( esk16082_4(X1,X2,X3,X4)
    | ~ esk16063_4(X1,X2,X3,X4) ) ).

cnf(i_0_5923,axiom,
    ( esk1496_4(X1,X2,X3,X4)
    | esk1483_4(X1,X2,X3,X4) ) ).

cnf(i_0_5924,axiom,
    ( ~ esk16597_4(X1,X2,X3,X4)
    | ~ esk16544_4(X1,X2,X3,X4)
    | ~ esk16545_4(X1,X2,X3,X4)
    | ~ esk16598_4(X1,X2,X3,X4)
    | ~ esk16547_4(X1,X2,X3,X4) ) ).

cnf(i_0_5925,axiom,
    ( ~ esk3064_4(X1,X2,X3,X4)
    | esk3322_4(X1,X2,X3,X4) ) ).

cnf(i_0_5926,axiom,
    ( esk1722_4(X1,X2,X3,X4)
    | ~ esk1686_4(X1,X2,X3,X4) ) ).

cnf(i_0_5927,axiom,
    ( ~ esk7206_4(X1,X2,X3,X4)
    | esk7207_4(X1,X2,X3,X4)
    | ~ esk7205_4(X1,X2,X3,X4) ) ).

cnf(i_0_5928,axiom,
    ( ~ esk10562_4(X1,X2,X3,X4)
    | ~ esk10542_4(X1,X2,X3,X4)
    | ~ esk10544_4(X1,X2,X3,X4) ) ).

cnf(i_0_5929,axiom,
    ( esk11527_4(X1,X2,X3,X4)
    | esk11560_4(X1,X2,X3,X4) ) ).

cnf(i_0_5930,axiom,
    ( ~ esk7004_4(X1,X2,X3,X4)
    | ~ esk6924_4(X1,X2,X3,X4)
    | ~ esk6975_4(X1,X2,X3,X4) ) ).

cnf(i_0_5931,axiom,
    ( ~ esk6076_4(X1,X2,X3,X4)
    | esk6077_4(X1,X2,X3,X4)
    | ~ esk6075_4(X1,X2,X3,X4) ) ).

cnf(i_0_5932,axiom,
    ( ~ esk15427_4(X1,X2,X3,X4)
    | esk15169_4(X1,X2,X3,X4) ) ).

cnf(i_0_5933,axiom,
    ( esk14182_4(X1,X2,X3,X4)
    | ~ esk14183_4(X1,X2,X3,X4) ) ).

cnf(i_0_5934,axiom,
    ( esk13990_4(X1,X2,X3,X4)
    | ~ esk14018_4(X1,X2,X3,X4) ) ).

cnf(i_0_5935,axiom,
    ( ~ esk7169_4(X1,X2,X3,X4)
    | ~ esk7122_4(X1,X2,X3,X4)
    | ~ esk7168_4(X1,X2,X3,X4) ) ).

cnf(i_0_5936,axiom,
    ( ~ esk6580_4(X1,X2,X3,X4)
    | esk6594_4(X1,X2,X3,X4) ) ).

cnf(i_0_5937,axiom,
    ( ~ esk12317_4(X1,X2,X3,X4)
    | esk12059_4(X1,X2,X3,X4) ) ).

cnf(i_0_5938,axiom,
    ( ~ esk6700_4(X1,X2,X3,X4)
    | esk6701_4(X1,X2,X3,X4) ) ).

cnf(i_0_5939,axiom,
    ( ~ esk9432_4(X1,X2,X3,X4)
    | esk9370_4(X1,X2,X3,X4) ) ).

cnf(i_0_5940,axiom,
    ( ~ esk15704_4(X1,X2,X3,X4)
    | ~ esk15729_4(X1,X2,X3,X4)
    | ~ esk15678_4(X1,X2,X3,X4) ) ).

cnf(i_0_5941,axiom,
    ( esk12356_4(X1,X2,X3,X4)
    | esk12349_4(X1,X2,X3,X4)
    | esk12257_4(X1,X2,X3,X4) ) ).

cnf(i_0_5942,axiom,
    ( esk16074_4(X1,X2,X3,X4)
    | ~ esk16082_4(X1,X2,X3,X4)
    | ~ esk16174_4(X1,X2,X3,X4) ) ).

cnf(i_0_5943,axiom,
    ( ~ esk1716_4(X1,X2,X3,X4)
    | esk1694_4(X1,X2,X3,X4) ) ).

cnf(i_0_5944,axiom,
    ( esk4051_4(X1,X2,X3,X4)
    | ~ esk4090_4(X1,X2,X3,X4) ) ).

cnf(i_0_5945,axiom,
    ( esk6609_4(X1,X2,X3,X4)
    | esk6652_4(X1,X2,X3,X4) ) ).

cnf(i_0_5946,axiom,
    ( ~ esk16091_4(X1,X2,X3,X4)
    | esk16349_4(X1,X2,X3,X4) ) ).

cnf(i_0_5947,axiom,
    ( ~ esk15446_4(X1,X2,X3,X4)
    | ~ esk15423_4(X1,X2,X3,X4) ) ).

cnf(i_0_5948,axiom,
    ( esk2817_4(X1,X2,X3,X4)
    | ~ esk3075_4(X1,X2,X3,X4) ) ).

cnf(i_0_5949,axiom,
    ( esk15596_4(X1,X2,X3,X4)
    | ~ esk15338_4(X1,X2,X3,X4) ) ).

cnf(i_0_5950,axiom,
    ( ~ esk14377_4(X1,X2,X3,X4)
    | esk14428_4(X1,X2,X3,X4)
    | esk14457_4(X1,X2,X3,X4) ) ).

cnf(i_0_5951,axiom,
    ( esk3725_4(X1,X2,X3,X4)
    | ~ esk3777_4(X1,X2,X3,X4) ) ).

cnf(i_0_5952,axiom,
    ( esk1679_4(X1,X2,X3,X4)
    | ~ esk1690_4(X1,X2,X3,X4)
    | ~ esk1776_4(X1,X2,X3,X4) ) ).

cnf(i_0_5953,axiom,
    ( ~ esk2573_4(X1,X2,X3,X4)
    | esk2448_4(X1,X2,X3,X4)
    | ~ esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_5954,axiom,
    ( esk4774_4(X1,X2,X3,X4)
    | ~ esk4766_4(X1,X2,X3,X4) ) ).

cnf(i_0_5955,axiom,
    ( esk4872_4(X1,X2,X3,X4)
    | esk4917_4(X1,X2,X3,X4) ) ).

cnf(i_0_5956,axiom,
    ( esk12841_4(X1,X2,X3,X4)
    | esk12922_4(X1,X2,X3,X4) ) ).

cnf(i_0_5957,axiom,
    ( esk9435_4(X1,X2,X3,X4)
    | esk9482_4(X1,X2,X3,X4) ) ).

cnf(i_0_5958,axiom,
    ( esk4619_4(X1,X2,X3,X4)
    | ~ esk4673_4(X1,X2,X3,X4)
    | esk4657_4(X1,X2,X3,X4) ) ).

cnf(i_0_5959,axiom,
    ( ~ esk4139_4(X1,X2,X3,X4)
    | ~ esk4137_4(X1,X2,X3,X4) ) ).

cnf(i_0_5960,axiom,
    ( ~ esk14456_4(X1,X2,X3,X4)
    | esk14463_4(X1,X2,X3,X4)
    | esk14375_4(X1,X2,X3,X4) ) ).

cnf(i_0_5961,axiom,
    ( ~ esk5558_4(X1,X2,X3,X4)
    | ~ esk5553_4(X1,X2,X3,X4) ) ).

cnf(i_0_5962,axiom,
    ( ~ esk7159_4(X1,X2,X3,X4)
    | ~ esk7158_4(X1,X2,X3,X4)
    | ~ esk7127_4(X1,X2,X3,X4) ) ).

cnf(i_0_5963,axiom,
    ( esk9452_4(X1,X2,X3,X4)
    | esk9478_4(X1,X2,X3,X4) ) ).

cnf(i_0_5964,axiom,
    ( esk6173_4(X1,X2,X3,X4)
    | esk6140_4(X1,X2,X3,X4) ) ).

cnf(i_0_5965,axiom,
    ( esk7948_4(X1,X2,X3,X4)
    | ~ esk7849_4(X1,X2,X3,X4) ) ).

cnf(i_0_5966,axiom,
    ( ~ esk7483_4(X1,X2,X3,X4)
    | ~ esk7481_4(X1,X2,X3,X4) ) ).

cnf(i_0_5967,axiom,
    ( esk14064_4(X1,X2,X3,X4)
    | esk14102_4(X1,X2,X3,X4) ) ).

cnf(i_0_5968,axiom,
    ( ~ esk7172_4(X1,X2,X3,X4)
    | esk7430_4(X1,X2,X3,X4) ) ).

cnf(i_0_5969,axiom,
    ( ~ esk15456_4(X1,X2,X3,X4)
    | ~ esk15455_4(X1,X2,X3,X4) ) ).

cnf(i_0_5970,axiom,
    ( ~ esk10302_4(X1,X2,X3,X4)
    | ~ esk10223_4(X1,X2,X3,X4)
    | ~ esk10255_4(X1,X2,X3,X4) ) ).

cnf(i_0_5971,axiom,
    ( esk9985_4(X1,X2,X3,X4)
    | esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_5972,axiom,
    ( esk10737_4(X1,X2,X3,X4)
    | esk10763_4(X1,X2,X3,X4) ) ).

cnf(i_0_5973,axiom,
    ( esk527_4(X1,X2,X3,X4)
    | p(X1)
    | p(X4)
    | p(X3)
    | ~ esk1_0
    | p(X2) ) ).

cnf(i_0_5974,axiom,
    ( esk2244_4(X1,X2,X3,X4)
    | ~ esk2307_4(X1,X2,X3,X4) ) ).

cnf(i_0_5975,axiom,
    ( esk457_4(X1,X2,X3,X4)
    | esk473_4(X1,X2,X3,X4) ) ).

cnf(i_0_5976,axiom,
    ( esk5153_4(X1,X2,X3,X4)
    | ~ esk4895_4(X1,X2,X3,X4) ) ).

cnf(i_0_5977,axiom,
    ( esk10037_4(X1,X2,X3,X4)
    | esk10044_4(X1,X2,X3,X4) ) ).

cnf(i_0_5978,axiom,
    ( esk3012_4(X1,X2,X3,X4)
    | esk3053_4(X1,X2,X3,X4) ) ).

cnf(i_0_5979,axiom,
    ( esk9829_4(X1,X2,X3,X4)
    | ~ esk9804_4(X1,X2,X3,X4)
    | esk9803_4(X1,X2,X3,X4) ) ).

cnf(i_0_5980,axiom,
    ( ~ esk3468_4(X1,X2,X3,X4)
    | esk3520_4(X1,X2,X3,X4) ) ).

cnf(i_0_5981,axiom,
    ( esk3862_4(X1,X2,X3,X4)
    | esk3880_4(X1,X2,X3,X4) ) ).

cnf(i_0_5982,axiom,
    ( esk13068_4(X1,X2,X3,X4)
    | esk13039_4(X1,X2,X3,X4) ) ).

cnf(i_0_5983,axiom,
    ( esk3244_4(X1,X2,X3,X4)
    | ~ esk3228_4(X1,X2,X3,X4) ) ).

cnf(i_0_5984,axiom,
    ( esk14173_4(X1,X2,X3,X4)
    | esk14118_4(X1,X2,X3,X4) ) ).

cnf(i_0_5985,axiom,
    ( ~ esk11202_4(X1,X2,X3,X4)
    | ~ esk11175_4(X1,X2,X3,X4)
    | esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_5986,axiom,
    ( esk16122_4(X1,X2,X3,X4)
    | esk16153_4(X1,X2,X3,X4) ) ).

cnf(i_0_5987,axiom,
    ( ~ esk11020_4(X1,X2,X3,X4)
    | ~ esk10979_4(X1,X2,X3,X4)
    | ~ esk11019_4(X1,X2,X3,X4) ) ).

cnf(i_0_5988,axiom,
    ( ~ esk12791_4(X1,X2,X3,X4)
    | ~ esk12839_4(X1,X2,X3,X4)
    | ~ esk12806_4(X1,X2,X3,X4) ) ).

cnf(i_0_5989,axiom,
    ( ~ esk2575_4(X1,X2,X3,X4)
    | esk2317_4(X1,X2,X3,X4) ) ).

cnf(i_0_5990,axiom,
    ( ~ esk10745_4(X1,X2,X3,X4)
    | ~ esk10744_4(X1,X2,X3,X4)
    | ~ esk10731_4(X1,X2,X3,X4) ) ).

cnf(i_0_5991,axiom,
    ( esk3813_4(X1,X2,X3,X4)
    | esk3796_4(X1,X2,X3,X4) ) ).

cnf(i_0_5992,axiom,
    ( esk13518_4(X1,X2,X3,X4)
    | ~ esk13534_4(X1,X2,X3,X4) ) ).

cnf(i_0_5993,axiom,
    ( ~ esk6916_4(X1,X2,X3,X4)
    | ~ esk6880_4(X1,X2,X3,X4)
    | ~ esk6883_4(X1,X2,X3,X4) ) ).

cnf(i_0_5994,axiom,
    ( esk8984_4(X1,X2,X3,X4)
    | ~ esk8726_4(X1,X2,X3,X4) ) ).

cnf(i_0_5995,axiom,
    ( esk13305_4(X1,X2,X3,X4)
    | esk13326_4(X1,X2,X3,X4) ) ).

cnf(i_0_5996,axiom,
    ( ~ esk5374_4(X1,X2,X3,X4)
    | ~ esk5338_4(X1,X2,X3,X4)
    | ~ esk5341_4(X1,X2,X3,X4) ) ).

cnf(i_0_5997,axiom,
    ( esk450_4(X1,X2,X3,X4)
    | ~ esk498_4(X1,X2,X3,X4) ) ).

cnf(i_0_5998,axiom,
    ( esk14929_4(X1,X2,X3,X4)
    | esk14947_4(X1,X2,X3,X4) ) ).

cnf(i_0_5999,axiom,
    ( esk3039_4(X1,X2,X3,X4)
    | esk3027_4(X1,X2,X3,X4) ) ).

cnf(i_0_6000,axiom,
    ( esk15117_4(X1,X2,X3,X4)
    | esk15098_4(X1,X2,X3,X4) ) ).

cnf(i_0_6001,axiom,
    ( ~ esk9186_4(X1,X2,X3,X4)
    | esk9240_4(X1,X2,X3,X4) ) ).

cnf(i_0_6002,axiom,
    ( ~ esk11309_4(X1,X2,X3,X4)
    | ~ esk11276_4(X1,X2,X3,X4)
    | ~ esk11249_4(X1,X2,X3,X4) ) ).

cnf(i_0_6003,axiom,
    ( esk15634_4(X1,X2,X3,X4)
    | esk15620_4(X1,X2,X3,X4) ) ).

cnf(i_0_6004,axiom,
    ( esk683_4(X1,X2,X3,X4)
    | ~ esk669_4(X1,X2,X3,X4) ) ).

cnf(i_0_6005,axiom,
    ( ~ esk9996_4(X1,X2,X3,X4)
    | ~ esk9995_4(X1,X2,X3,X4)
    | ~ esk9949_4(X1,X2,X3,X4) ) ).

cnf(i_0_6006,axiom,
    ( esk13729_4(X1,X2,X3,X4)
    | ~ esk13750_4(X1,X2,X3,X4) ) ).

cnf(i_0_6007,axiom,
    ( ~ esk3027_4(X1,X2,X3,X4)
    | ~ esk3157_4(X1,X2,X3,X4)
    | ~ esk3051_4(X1,X2,X3,X4) ) ).

cnf(i_0_6008,axiom,
    ( ~ esk3786_4(X1,X2,X3,X4)
    | esk3849_4(X1,X2,X3,X4) ) ).

cnf(i_0_6009,axiom,
    ( ~ esk5864_4(X1,X2,X3,X4)
    | ~ esk5854_4(X1,X2,X3,X4)
    | ~ esk5976_4(X1,X2,X3,X4) ) ).

cnf(i_0_6010,axiom,
    ( esk15047_4(X1,X2,X3,X4)
    | ~ esk15017_4(X1,X2,X3,X4) ) ).

cnf(i_0_6011,axiom,
    ( esk14915_4(X1,X2,X3,X4)
    | ~ esk14917_4(X1,X2,X3,X4) ) ).

cnf(i_0_6012,axiom,
    ( ~ esk15596_4(X1,X2,X3,X4)
    | esk15592_4(X1,X2,X3,X4) ) ).

cnf(i_0_6013,axiom,
    ( ~ esk15938_4(X1,X2,X3,X4)
    | esk15860_4(X1,X2,X3,X4) ) ).

cnf(i_0_6014,axiom,
    ( esk12655_4(X1,X2,X3,X4)
    | esk12632_4(X1,X2,X3,X4)
    | ~ esk12572_4(X1,X2,X3,X4) ) ).

cnf(i_0_6015,axiom,
    ( ~ esk12337_4(X1,X2,X3,X4)
    | esk12213_4(X1,X2,X3,X4)
    | ~ esk12227_4(X1,X2,X3,X4) ) ).

cnf(i_0_6016,axiom,
    ( esk8785_4(X1,X2,X3,X4)
    | ~ esk8769_4(X1,X2,X3,X4) ) ).

cnf(i_0_6017,axiom,
    ( ~ esk9996_4(X1,X2,X3,X4)
    | ~ esk10083_4(X1,X2,X3,X4)
    | ~ esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_6018,axiom,
    ( esk12606_4(X1,X2,X3,X4)
    | esk12515_4(X1,X2,X3,X4) ) ).

cnf(i_0_6019,axiom,
    ( ~ esk5017_4(X1,X2,X3,X4)
    | esk5031_4(X1,X2,X3,X4) ) ).

cnf(i_0_6020,axiom,
    ( ~ esk14297_4(X1,X2,X3,X4)
    | esk14304_4(X1,X2,X3,X4) ) ).

cnf(i_0_6021,axiom,
    ( ~ esk6623_4(X1,X2,X3,X4)
    | ~ esk6642_4(X1,X2,X3,X4)
    | ~ esk6675_4(X1,X2,X3,X4) ) ).

cnf(i_0_6022,axiom,
    ( esk2200_4(X1,X2,X3,X4)
    | ~ esk2236_4(X1,X2,X3,X4)
    | ~ esk2216_4(X1,X2,X3,X4) ) ).

cnf(i_0_6023,axiom,
    ( ~ esk627_4(X1,X2,X3,X4)
    | esk653_4(X1,X2,X3,X4) ) ).

cnf(i_0_6024,axiom,
    ( ~ esk15900_4(X1,X2,X3,X4)
    | ~ esk15933_4(X1,X2,X3,X4)
    | ~ esk15875_4(X1,X2,X3,X4) ) ).

cnf(i_0_6025,axiom,
    ( ~ esk7203_4(X1,X2,X3,X4)
    | ~ esk7201_4(X1,X2,X3,X4)
    | ~ esk7221_4(X1,X2,X3,X4) ) ).

cnf(i_0_6026,axiom,
    ( esk9765_4(X1,X2,X3,X4)
    | esk9732_4(X1,X2,X3,X4) ) ).

cnf(i_0_6027,axiom,
    ( esk12594_4(X1,X2,X3,X4)
    | ~ esk12645_4(X1,X2,X3,X4)
    | esk12620_4(X1,X2,X3,X4) ) ).

cnf(i_0_6028,axiom,
    ( esk11291_4(X1,X2,X3,X4)
    | esk11346_4(X1,X2,X3,X4) ) ).

cnf(i_0_6029,axiom,
    ( esk6964_4(X1,X2,X3,X4)
    | esk6992_4(X1,X2,X3,X4) ) ).

cnf(i_0_6030,axiom,
    ( esk8978_4(X1,X2,X3,X4)
    | ~ esk8720_4(X1,X2,X3,X4) ) ).

cnf(i_0_6031,axiom,
    ( ~ esk5805_4(X1,X2,X3,X4)
    | ~ esk5803_4(X1,X2,X3,X4) ) ).

cnf(i_0_6032,axiom,
    ( esk15604_4(X1,X2,X3,X4)
    | ~ esk15679_4(X1,X2,X3,X4) ) ).

cnf(i_0_6033,axiom,
    ( ~ esk9964_4(X1,X2,X3,X4)
    | ~ esk9910_4(X1,X2,X3,X4) ) ).

cnf(i_0_6034,axiom,
    ( esk5143_4(X1,X2,X3,X4)
    | esk5166_4(X1,X2,X3,X4) ) ).

cnf(i_0_6035,axiom,
    ( ~ esk5537_4(X1,X2,X3,X4)
    | esk5545_4(X1,X2,X3,X4) ) ).

cnf(i_0_6036,axiom,
    esk7084_4(X1,X2,X3,X4) ).

cnf(i_0_6037,axiom,
    ( ~ esk4910_4(X1,X2,X3,X4)
    | ~ esk4953_4(X1,X2,X3,X4)
    | ~ esk4884_4(X1,X2,X3,X4) ) ).

cnf(i_0_6038,axiom,
    ( esk7137_4(X1,X2,X3,X4)
    | esk7140_4(X1,X2,X3,X4) ) ).

cnf(i_0_6039,axiom,
    ( esk3132_4(X1,X2,X3,X4)
    | ~ esk3131_4(X1,X2,X3,X4)
    | ~ esk3130_4(X1,X2,X3,X4) ) ).

cnf(i_0_6040,axiom,
    ( ~ esk2880_4(X1,X2,X3,X4)
    | esk2881_4(X1,X2,X3,X4) ) ).

cnf(i_0_6041,axiom,
    ( esk13302_4(X1,X2,X3,X4)
    | ~ esk13344_4(X1,X2,X3,X4) ) ).

cnf(i_0_6042,axiom,
    ( esk4893_4(X1,X2,X3,X4)
    | ~ esk4894_4(X1,X2,X3,X4) ) ).

cnf(i_0_6043,axiom,
    ( esk10232_4(X1,X2,X3,X4)
    | esk10265_4(X1,X2,X3,X4) ) ).

cnf(i_0_6044,axiom,
    ( esk13088_4(X1,X2,X3,X4)
    | esk13144_4(X1,X2,X3,X4) ) ).

cnf(i_0_6045,axiom,
    ( esk10461_4(X1,X2,X3,X4)
    | esk10557_4(X1,X2,X3,X4)
    | esk10460_4(X1,X2,X3,X4) ) ).

cnf(i_0_6046,axiom,
    ( esk12374_4(X1,X2,X3,X4)
    | esk12375_4(X1,X2,X3,X4)
    | esk12373_4(X1,X2,X3,X4) ) ).

cnf(i_0_6047,axiom,
    ( ~ esk4431_4(X1,X2,X3,X4)
    | ~ esk4312_4(X1,X2,X3,X4)
    | ~ esk4316_4(X1,X2,X3,X4) ) ).

cnf(i_0_6048,axiom,
    ( esk5583_4(X1,X2,X3,X4)
    | esk5620_4(X1,X2,X3,X4) ) ).

cnf(i_0_6049,axiom,
    ( esk14945_4(X1,X2,X3,X4)
    | ~ esk14930_4(X1,X2,X3,X4) ) ).

cnf(i_0_6050,axiom,
    ( esk10813_4(X1,X2,X3,X4)
    | ~ esk11071_4(X1,X2,X3,X4) ) ).

cnf(i_0_6051,axiom,
    ( ~ esk4569_4(X1,X2,X3,X4)
    | ~ esk4675_4(X1,X2,X3,X4)
    | ~ esk4589_4(X1,X2,X3,X4) ) ).

cnf(i_0_6052,axiom,
    ( esk16765_4(X1,X2,X3,X4)
    | esk16678_4(X1,X2,X3,X4) ) ).

cnf(i_0_6053,axiom,
    ( p(X4)
    | ~ p(X3)
    | ~ p(X1)
    | ~ esk503_4(X1,X2,X3,X4)
    | esk162_0
    | p(X2) ) ).

cnf(i_0_6054,axiom,
    ( esk8717_4(X1,X2,X3,X4)
    | ~ esk8459_4(X1,X2,X3,X4) ) ).

cnf(i_0_6055,axiom,
    ( esk3372_4(X1,X2,X3,X4)
    | ~ esk3388_4(X1,X2,X3,X4)
    | esk3334_4(X1,X2,X3,X4) ) ).

cnf(i_0_6056,axiom,
    ( esk12798_4(X1,X2,X3,X4)
    | esk12831_4(X1,X2,X3,X4) ) ).

cnf(i_0_6057,axiom,
    ( esk5171_4(X1,X2,X3,X4)
    | esk5170_4(X1,X2,X3,X4) ) ).

cnf(i_0_6058,axiom,
    ( ~ esk6985_4(X1,X2,X3,X4)
    | esk6984_4(X1,X2,X3,X4)
    | esk6971_4(X1,X2,X3,X4) ) ).

cnf(i_0_6059,axiom,
    ( esk3059_4(X1,X2,X3,X4)
    | esk3106_4(X1,X2,X3,X4) ) ).

cnf(i_0_6060,axiom,
    ( esk5314_4(X1,X2,X3,X4)
    | ~ esk5312_4(X1,X2,X3,X4)
    | ~ esk5313_4(X1,X2,X3,X4) ) ).

cnf(i_0_6061,axiom,
    ( ~ esk6709_4(X1,X2,X3,X4)
    | ~ esk6707_4(X1,X2,X3,X4) ) ).

cnf(i_0_6062,axiom,
    ( ~ esk4617_4(X1,X2,X3,X4)
    | esk4668_4(X1,X2,X3,X4) ) ).

cnf(i_0_6063,axiom,
    ( ~ esk16549_4(X1,X2,X3,X4)
    | esk16584_4(X1,X2,X3,X4) ) ).

cnf(i_0_6064,axiom,
    ( ~ esk6677_4(X1,X2,X3,X4)
    | ~ esk6573_4(X1,X2,X3,X4)
    | esk6556_4(X1,X2,X3,X4) ) ).

cnf(i_0_6065,axiom,
    ( ~ esk15826_4(X1,X2,X3,X4)
    | ~ esk15824_4(X1,X2,X3,X4) ) ).

cnf(i_0_6066,axiom,
    ( ~ esk9479_4(X1,X2,X3,X4)
    | ~ esk9512_4(X1,X2,X3,X4)
    | ~ esk9450_4(X1,X2,X3,X4) ) ).

cnf(i_0_6067,axiom,
    ( esk6904_4(X1,X2,X3,X4)
    | esk6882_4(X1,X2,X3,X4) ) ).

cnf(i_0_6068,axiom,
    ( esk4081_4(X1,X2,X3,X4)
    | esk4040_4(X1,X2,X3,X4) ) ).

cnf(i_0_6069,axiom,
    ( ~ esk12514_4(X1,X2,X3,X4)
    | ~ esk12613_4(X1,X2,X3,X4) ) ).

cnf(i_0_6070,axiom,
    ( ~ esk12960_4(X1,X2,X3,X4)
    | esk12992_4(X1,X2,X3,X4) ) ).

cnf(i_0_6071,axiom,
    ( ~ esk7707_4(X1,X2,X3,X4)
    | ~ esk7601_4(X1,X2,X3,X4)
    | esk7585_4(X1,X2,X3,X4) ) ).

cnf(i_0_6072,axiom,
    ( esk11536_4(X1,X2,X3,X4)
    | esk11508_4(X1,X2,X3,X4) ) ).

cnf(i_0_6073,axiom,
    ( esk8181_4(X1,X2,X3,X4)
    | esk8158_4(X1,X2,X3,X4) ) ).

cnf(i_0_6074,axiom,
    ( ~ esk16352_4(X1,X2,X3,X4)
    | ~ esk16354_4(X1,X2,X3,X4) ) ).

cnf(i_0_6075,axiom,
    ( esk15096_4(X1,X2,X3,X4)
    | esk15122_4(X1,X2,X3,X4) ) ).

cnf(i_0_6076,axiom,
    ( ~ esk12318_4(X1,X2,X3,X4)
    | esk12576_4(X1,X2,X3,X4) ) ).

cnf(i_0_6077,axiom,
    ( ~ esk3246_4(X1,X2,X3,X4)
    | esk3253_4(X1,X2,X3,X4) ) ).

cnf(i_0_6078,axiom,
    ( ~ esk14058_4(X1,X2,X3,X4)
    | ~ esk14155_4(X1,X2,X3,X4) ) ).

cnf(i_0_6079,axiom,
    ( esk15375_4(X1,X2,X3,X4)
    | esk15489_4(X1,X2,X3,X4) ) ).

cnf(i_0_6080,axiom,
    ( esk9995_4(X1,X2,X3,X4)
    | esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_6081,axiom,
    ( ~ esk5607_4(X1,X2,X3,X4)
    | ~ esk5590_4(X1,X2,X3,X4)
    | ~ esk5606_4(X1,X2,X3,X4) ) ).

cnf(i_0_6082,axiom,
    ( ~ esk7487_4(X1,X2,X3,X4)
    | ~ esk7519_4(X1,X2,X3,X4) ) ).

cnf(i_0_6083,axiom,
    ( ~ esk3375_4(X1,X2,X3,X4)
    | ~ esk3407_4(X1,X2,X3,X4) ) ).

cnf(i_0_6084,axiom,
    ( esk7344_4(X1,X2,X3,X4)
    | ~ esk7328_4(X1,X2,X3,X4) ) ).

cnf(i_0_6085,axiom,
    ( ~ esk11812_4(X1,X2,X3,X4)
    | esk11755_4(X1,X2,X3,X4) ) ).

cnf(i_0_6086,axiom,
    ( ~ esk13625_4(X1,X2,X3,X4)
    | esk13883_4(X1,X2,X3,X4) ) ).

cnf(i_0_6087,axiom,
    ( ~ esk14838_4(X1,X2,X3,X4)
    | esk14898_4(X1,X2,X3,X4) ) ).

cnf(i_0_6088,axiom,
    ( esk6455_4(X1,X2,X3,X4)
    | esk6456_4(X1,X2,X3,X4) ) ).

cnf(i_0_6089,axiom,
    ( ~ esk3499_4(X1,X2,X3,X4)
    | esk3241_4(X1,X2,X3,X4) ) ).

cnf(i_0_6090,axiom,
    ( esk11201_4(X1,X2,X3,X4)
    | esk11149_4(X1,X2,X3,X4)
    | esk11171_4(X1,X2,X3,X4)
    | esk11174_4(X1,X2,X3,X4)
    | esk11173_4(X1,X2,X3,X4) ) ).

cnf(i_0_6091,axiom,
    ( ~ esk6820_4(X1,X2,X3,X4)
    | esk6918_4(X1,X2,X3,X4) ) ).

cnf(i_0_6092,axiom,
    ( ~ esk7763_4(X1,X2,X3,X4)
    | ~ esk7735_4(X1,X2,X3,X4) ) ).

cnf(i_0_6093,axiom,
    ( ~ esk5061_4(X1,X2,X3,X4)
    | ~ esk5153_4(X1,X2,X3,X4) ) ).

cnf(i_0_6094,axiom,
    ( ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14138_4(X1,X2,X3,X4)
    | ~ esk14105_4(X1,X2,X3,X4) ) ).

cnf(i_0_6095,axiom,
    ( esk1972_4(X1,X2,X3,X4)
    | ~ esk1952_4(X1,X2,X3,X4) ) ).

cnf(i_0_6096,axiom,
    ( ~ esk6976_4(X1,X2,X3,X4)
    | ~ esk6920_4(X1,X2,X3,X4) ) ).

cnf(i_0_6097,axiom,
    esk11710_4(X1,X2,X3,X4) ).

cnf(i_0_6098,axiom,
    ( esk9031_4(X1,X2,X3,X4)
    | ~ esk9060_4(X1,X2,X3,X4)
    | esk8980_4(X1,X2,X3,X4) ) ).

cnf(i_0_6099,axiom,
    ( ~ esk16439_4(X1,X2,X3,X4)
    | esk16181_4(X1,X2,X3,X4) ) ).

cnf(i_0_6100,axiom,
    ( esk16391_4(X1,X2,X3,X4)
    | esk16423_4(X1,X2,X3,X4) ) ).

cnf(i_0_6101,axiom,
    ( ~ esk3117_4(X1,X2,X3,X4)
    | esk3124_4(X1,X2,X3,X4)
    | esk3073_4(X1,X2,X3,X4) ) ).

cnf(i_0_6102,axiom,
    ( esk1460_4(X1,X2,X3,X4)
    | ~ esk1462_4(X1,X2,X3,X4) ) ).

cnf(i_0_6103,axiom,
    ( ~ esk8786_4(X1,X2,X3,X4)
    | esk8785_4(X1,X2,X3,X4) ) ).

cnf(i_0_6104,axiom,
    ( ~ esk6484_4(X1,X2,X3,X4)
    | esk6485_4(X1,X2,X3,X4)
    | ~ esk6483_4(X1,X2,X3,X4) ) ).

cnf(i_0_6105,axiom,
    ( ~ esk13856_4(X1,X2,X3,X4)
    | esk14114_4(X1,X2,X3,X4) ) ).

cnf(i_0_6106,axiom,
    ( esk16601_4(X1,X2,X3,X4)
    | esk16610_4(X1,X2,X3,X4) ) ).

cnf(i_0_6107,axiom,
    ( p(X3)
    | p(X1)
    | ~ p(X4)
    | p(X2)
    | esk288_0
    | ~ esk521_4(X1,X2,X3,X4) ) ).

cnf(i_0_6108,axiom,
    ( esk13595_4(X1,X2,X3,X4)
    | esk13628_4(X1,X2,X3,X4) ) ).

cnf(i_0_6109,axiom,
    ( esk15729_4(X1,X2,X3,X4)
    | esk15646_4(X1,X2,X3,X4) ) ).

cnf(i_0_6110,axiom,
    ( ~ esk15061_4(X1,X2,X3,X4)
    | ~ esk15062_4(X1,X2,X3,X4) ) ).

cnf(i_0_6111,axiom,
    ( esk16627_4(X1,X2,X3,X4)
    | ~ esk16575_4(X1,X2,X3,X4) ) ).

cnf(i_0_6112,axiom,
    ( ~ esk3045_4(X1,X2,X3,X4)
    | ~ esk3044_4(X1,X2,X3,X4)
    | ~ esk3016_4(X1,X2,X3,X4) ) ).

cnf(i_0_6113,axiom,
    ( ~ esk3074_4(X1,X2,X3,X4)
    | esk3332_4(X1,X2,X3,X4) ) ).

cnf(i_0_6114,axiom,
    ( esk1153_4(X1,X2,X3,X4)
    | esk1299_4(X1,X2,X3,X4) ) ).

cnf(i_0_6115,axiom,
    ( ~ esk5558_4(X1,X2,X3,X4)
    | ~ esk5559_4(X1,X2,X3,X4) ) ).

cnf(i_0_6116,axiom,
    ( ~ esk5276_4(X1,X2,X3,X4)
    | esk5288_4(X1,X2,X3,X4) ) ).

cnf(i_0_6117,axiom,
    ( ~ esk13510_4(X1,X2,X3,X4)
    | esk13490_4(X1,X2,X3,X4) ) ).

cnf(i_0_6118,axiom,
    ( esk15105_4(X1,X2,X3,X4)
    | esk15084_4(X1,X2,X3,X4)
    | esk15106_4(X1,X2,X3,X4) ) ).

cnf(i_0_6119,axiom,
    ( ~ esk16219_4(X1,X2,X3,X4)
    | ~ esk16221_4(X1,X2,X3,X4) ) ).

cnf(i_0_6120,axiom,
    ( ~ esk7387_4(X1,X2,X3,X4)
    | esk7441_4(X1,X2,X3,X4) ) ).

cnf(i_0_6121,axiom,
    ( esk10438_4(X1,X2,X3,X4)
    | esk10439_4(X1,X2,X3,X4) ) ).

cnf(i_0_6122,axiom,
    ( ~ esk5398_4(X1,X2,X3,X4)
    | esk5449_4(X1,X2,X3,X4)
    | esk5424_4(X1,X2,X3,X4) ) ).

cnf(i_0_6123,axiom,
    ( esk13122_4(X1,X2,X3,X4)
    | esk12997_4(X1,X2,X3,X4) ) ).

cnf(i_0_6124,axiom,
    ( ~ esk10673_4(X1,X2,X3,X4)
    | esk10638_4(X1,X2,X3,X4) ) ).

cnf(i_0_6125,axiom,
    ( esk6854_4(X1,X2,X3,X4)
    | ~ esk6858_4(X1,X2,X3,X4) ) ).

cnf(i_0_6126,axiom,
    ( esk1085_4(X1,X2,X3,X4)
    | esk1033_4(X1,X2,X3,X4) ) ).

cnf(i_0_6127,axiom,
    ( ~ esk13945_4(X1,X2,X3,X4)
    | esk13913_4(X1,X2,X3,X4)
    | esk13944_4(X1,X2,X3,X4) ) ).

cnf(i_0_6128,axiom,
    ( ~ esk8184_4(X1,X2,X3,X4)
    | ~ esk8165_4(X1,X2,X3,X4)
    | ~ esk8217_4(X1,X2,X3,X4) ) ).

cnf(i_0_6129,axiom,
    ( ~ esk3774_4(X1,X2,X3,X4)
    | esk3516_4(X1,X2,X3,X4) ) ).

cnf(i_0_6130,axiom,
    ( esk1568_4(X1,X2,X3,X4)
    | esk1595_4(X1,X2,X3,X4)
    | ~ esk1596_4(X1,X2,X3,X4) ) ).

cnf(i_0_6131,axiom,
    ( ~ esk13133_4(X1,X2,X3,X4)
    | ~ esk13134_4(X1,X2,X3,X4) ) ).

cnf(i_0_6132,axiom,
    ( esk4426_4(X1,X2,X3,X4)
    | esk4374_4(X1,X2,X3,X4) ) ).

cnf(i_0_6133,axiom,
    ( esk3296_4(X1,X2,X3,X4)
    | esk3276_4(X1,X2,X3,X4) ) ).

cnf(i_0_6134,axiom,
    ( esk5343_4(X1,X2,X3,X4)
    | esk5336_4(X1,X2,X3,X4) ) ).

cnf(i_0_6135,axiom,
    ( esk1690_4(X1,X2,X3,X4)
    | ~ esk1683_4(X1,X2,X3,X4) ) ).

cnf(i_0_6136,axiom,
    ( ~ esk9678_4(X1,X2,X3,X4)
    | esk9679_4(X1,X2,X3,X4)
    | ~ esk9677_4(X1,X2,X3,X4) ) ).

cnf(i_0_6137,axiom,
    ( ~ esk13116_4(X1,X2,X3,X4)
    | esk13115_4(X1,X2,X3,X4)
    | esk13120_4(X1,X2,X3,X4) ) ).

cnf(i_0_6138,axiom,
    ( esk14689_4(X1,X2,X3,X4)
    | esk14606_4(X1,X2,X3,X4) ) ).

cnf(i_0_6139,axiom,
    ( ~ esk9438_4(X1,X2,X3,X4)
    | ~ esk9475_4(X1,X2,X3,X4)
    | ~ esk9476_4(X1,X2,X3,X4) ) ).

cnf(i_0_6140,axiom,
    ( esk9802_4(X1,X2,X3,X4)
    | esk9804_4(X1,X2,X3,X4) ) ).

cnf(i_0_6141,axiom,
    ( esk12077_4(X1,X2,X3,X4)
    | ~ esk12008_4(X1,X2,X3,X4) ) ).

cnf(i_0_6142,axiom,
    ( ~ esk3598_4(X1,X2,X3,X4)
    | esk3856_4(X1,X2,X3,X4) ) ).

cnf(i_0_6143,axiom,
    ( ~ esk421_4(X1,X2,X3,X4)
    | esk415_4(X1,X2,X3,X4)
    | esk420_4(X1,X2,X3,X4) ) ).

cnf(i_0_6144,axiom,
    ( esk1034_4(X1,X2,X3,X4)
    | ~ esk1292_4(X1,X2,X3,X4) ) ).

cnf(i_0_6145,axiom,
    ( esk9409_4(X1,X2,X3,X4)
    | ~ esk9667_4(X1,X2,X3,X4) ) ).

cnf(i_0_6146,axiom,
    ( esk16030_4(X1,X2,X3,X4)
    | esk16083_4(X1,X2,X3,X4) ) ).

cnf(i_0_6147,axiom,
    ( ~ esk13865_4(X1,X2,X3,X4)
    | ~ esk13769_4(X1,X2,X3,X4)
    | esk13763_4(X1,X2,X3,X4) ) ).

cnf(i_0_6148,axiom,
    ( ~ esk11990_4(X1,X2,X3,X4)
    | esk11978_4(X1,X2,X3,X4)
    | esk11989_4(X1,X2,X3,X4) ) ).

cnf(i_0_6149,axiom,
    ( esk6337_4(X1,X2,X3,X4)
    | ~ esk6338_4(X1,X2,X3,X4) ) ).

cnf(i_0_6150,axiom,
    ( ~ esk1824_4(X1,X2,X3,X4)
    | ~ esk1852_4(X1,X2,X3,X4) ) ).

cnf(i_0_6151,axiom,
    ( esk1464_4(X1,X2,X3,X4)
    | esk1562_4(X1,X2,X3,X4) ) ).

cnf(i_0_6152,axiom,
    ( ~ esk12749_4(X1,X2,X3,X4)
    | ~ esk12748_4(X1,X2,X3,X4) ) ).

cnf(i_0_6153,axiom,
    ( ~ esk6009_4(X1,X2,X3,X4)
    | ~ esk6061_4(X1,X2,X3,X4) ) ).

cnf(i_0_6154,axiom,
    ( ~ esk14877_4(X1,X2,X3,X4)
    | ~ esk14833_4(X1,X2,X3,X4)
    | ~ esk14876_4(X1,X2,X3,X4) ) ).

cnf(i_0_6155,axiom,
    ( ~ esk8288_4(X1,X2,X3,X4)
    | ~ esk8298_4(X1,X2,X3,X4) ) ).

cnf(i_0_6156,axiom,
    ( ~ esk5602_4(X1,X2,X3,X4)
    | ~ esk5635_4(X1,X2,X3,X4)
    | ~ esk5595_4(X1,X2,X3,X4) ) ).

cnf(i_0_6157,axiom,
    ( esk15618_4(X1,X2,X3,X4)
    | esk15649_4(X1,X2,X3,X4) ) ).

cnf(i_0_6158,axiom,
    ( ~ esk5575_4(X1,X2,X3,X4)
    | ~ esk5597_4(X1,X2,X3,X4) ) ).

cnf(i_0_6159,axiom,
    ( ~ esk7194_4(X1,X2,X3,X4)
    | esk7452_4(X1,X2,X3,X4) ) ).

cnf(i_0_6160,axiom,
    ( ~ esk2781_4(X1,X2,X3,X4)
    | ~ esk2814_4(X1,X2,X3,X4)
    | ~ esk2768_4(X1,X2,X3,X4) ) ).

cnf(i_0_6161,axiom,
    ( ~ esk3412_4(X1,X2,X3,X4)
    | ~ esk3405_4(X1,X2,X3,X4)
    | ~ esk3324_4(X1,X2,X3,X4) ) ).

cnf(i_0_6162,axiom,
    ( esk12889_4(X1,X2,X3,X4)
    | ~ esk12912_4(X1,X2,X3,X4)
    | esk12829_4(X1,X2,X3,X4) ) ).

cnf(i_0_6163,axiom,
    ( ~ esk5752_4(X1,X2,X3,X4)
    | ~ esk5804_4(X1,X2,X3,X4) ) ).

cnf(i_0_6164,axiom,
    ( esk12339_4(X1,X2,X3,X4)
    | esk12306_4(X1,X2,X3,X4) ) ).

cnf(i_0_6165,axiom,
    ( esk11148_4(X1,X2,X3,X4)
    | esk11200_4(X1,X2,X3,X4) ) ).

cnf(i_0_6166,axiom,
    ( ~ esk15067_4(X1,X2,X3,X4)
    | ~ esk15068_4(X1,X2,X3,X4) ) ).

cnf(i_0_6167,axiom,
    ( ~ esk3328_4(X1,X2,X3,X4)
    | esk3070_4(X1,X2,X3,X4) ) ).

cnf(i_0_6168,axiom,
    ( ~ esk15272_4(X1,X2,X3,X4)
    | esk15291_4(X1,X2,X3,X4) ) ).

cnf(i_0_6169,axiom,
    ( esk15606_4(X1,X2,X3,X4)
    | ~ esk15675_4(X1,X2,X3,X4) ) ).

cnf(i_0_6170,axiom,
    ( ~ esk14353_4(X1,X2,X3,X4)
    | ~ esk14352_4(X1,X2,X3,X4)
    | ~ esk14324_4(X1,X2,X3,X4) ) ).

cnf(i_0_6171,axiom,
    ( ~ esk5526_4(X1,X2,X3,X4)
    | esk5645_4(X1,X2,X3,X4) ) ).

cnf(i_0_6172,axiom,
    ( esk11895_4(X1,X2,X3,X4)
    | esk11789_4(X1,X2,X3,X4) ) ).

cnf(i_0_6173,axiom,
    ( ~ esk942_4(X1,X2,X3,X4)
    | ~ esk924_4(X1,X2,X3,X4) ) ).

cnf(i_0_6174,axiom,
    ( ~ esk11960_4(X1,X2,X3,X4)
    | esk12058_4(X1,X2,X3,X4) ) ).

cnf(i_0_6175,axiom,
    ( esk6599_4(X1,X2,X3,X4)
    | ~ esk6597_4(X1,X2,X3,X4)
    | ~ esk6598_4(X1,X2,X3,X4) ) ).

cnf(i_0_6176,axiom,
    ( ~ esk11464_4(X1,X2,X3,X4)
    | esk11476_4(X1,X2,X3,X4) ) ).

cnf(i_0_6177,axiom,
    ( esk4569_4(X1,X2,X3,X4)
    | esk4587_4(X1,X2,X3,X4) ) ).

cnf(i_0_6178,axiom,
    ( esk14823_4(X1,X2,X3,X4)
    | ~ esk14801_4(X1,X2,X3,X4) ) ).

cnf(i_0_6179,axiom,
    ( ~ esk14776_4(X1,X2,X3,X4)
    | esk14828_4(X1,X2,X3,X4) ) ).

cnf(i_0_6180,axiom,
    ( ~ esk5574_4(X1,X2,X3,X4)
    | esk5572_4(X1,X2,X3,X4) ) ).

cnf(i_0_6181,axiom,
    ( esk4597_4(X1,X2,X3,X4)
    | esk4682_4(X1,X2,X3,X4) ) ).

cnf(i_0_6182,axiom,
    ( esk5326_4(X1,X2,X3,X4)
    | esk5363_4(X1,X2,X3,X4) ) ).

cnf(i_0_6183,axiom,
    ( esk1953_4(X1,X2,X3,X4)
    | ~ esk2211_4(X1,X2,X3,X4) ) ).

cnf(i_0_6184,axiom,
    ( ~ esk7784_4(X1,X2,X3,X4)
    | ~ esk7661_4(X1,X2,X3,X4)
    | ~ esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_6185,axiom,
    ( esk9686_4(X1,X2,X3,X4)
    | ~ esk9684_4(X1,X2,X3,X4) ) ).

cnf(i_0_6186,axiom,
    ( ~ esk7363_4(X1,X2,X3,X4)
    | ~ esk7358_4(X1,X2,X3,X4) ) ).

cnf(i_0_6187,axiom,
    ( ~ esk6911_4(X1,X2,X3,X4)
    | ~ esk6912_4(X1,X2,X3,X4)
    | ~ esk6865_4(X1,X2,X3,X4) ) ).

cnf(i_0_6188,axiom,
    ( esk7896_4(X1,X2,X3,X4)
    | esk7934_4(X1,X2,X3,X4) ) ).

cnf(i_0_6189,axiom,
    ( ~ esk12752_4(X1,X2,X3,X4)
    | esk12758_4(X1,X2,X3,X4) ) ).

cnf(i_0_6190,axiom,
    ( p(X2)
    | ~ p(X1)
    | p(X3)
    | ~ p(X4)
    | ~ esk116_0
    | esk497_4(X1,X2,X3,X4) ) ).

cnf(i_0_6191,axiom,
    ( ~ esk3484_4(X1,X2,X3,X4)
    | esk3605_4(X1,X2,X3,X4) ) ).

cnf(i_0_6192,axiom,
    ( ~ esk457_4(X1,X2,X3,X4)
    | ~ esk570_4(X1,X2,X3,X4)
    | ~ esk485_4(X1,X2,X3,X4) ) ).

cnf(i_0_6193,axiom,
    ( esk4651_4(X1,X2,X3,X4)
    | esk4679_4(X1,X2,X3,X4) ) ).

cnf(i_0_6194,axiom,
    ( ~ esk2728_4(X1,X2,X3,X4)
    | esk2470_4(X1,X2,X3,X4) ) ).

cnf(i_0_6195,axiom,
    ( ~ esk11755_4(X1,X2,X3,X4)
    | esk11812_4(X1,X2,X3,X4) ) ).

cnf(i_0_6196,axiom,
    ( esk11207_4(X1,X2,X3,X4)
    | esk11206_4(X1,X2,X3,X4) ) ).

cnf(i_0_6197,axiom,
    ( esk10544_4(X1,X2,X3,X4)
    | esk10511_4(X1,X2,X3,X4) ) ).

cnf(i_0_6198,axiom,
    ( ~ esk14303_4(X1,X2,X3,X4)
    | ~ esk14304_4(X1,X2,X3,X4)
    | esk14305_4(X1,X2,X3,X4) ) ).

cnf(i_0_6199,axiom,
    ( ~ esk3879_4(X1,X2,X3,X4)
    | esk3834_4(X1,X2,X3,X4) ) ).

cnf(i_0_6200,axiom,
    ( ~ esk758_4(X1,X2,X3,X4)
    | ~ esk806_4(X1,X2,X3,X4) ) ).

cnf(i_0_6201,axiom,
    ( ~ esk16725_4(X1,X2,X3,X4)
    | ~ esk16718_4(X1,X2,X3,X4)
    | ~ esk16627_4(X1,X2,X3,X4) ) ).

cnf(i_0_6202,axiom,
    ( esk1805_4(X1,X2,X3,X4)
    | ~ esk2063_4(X1,X2,X3,X4) ) ).

cnf(i_0_6203,axiom,
    ( ~ p(X3)
    | esk32_0
    | ~ p(X1)
    | ~ esk16602_4(X1,X2,X3,X4)
    | ~ p(X2)
    | p(X4) ) ).

cnf(i_0_6204,axiom,
    ( esk6724_4(X1,X2,X3,X4)
    | ~ esk6723_4(X1,X2,X3,X4) ) ).

cnf(i_0_6205,axiom,
    ( ~ esk4025_4(X1,X2,X3,X4)
    | esk4024_4(X1,X2,X3,X4) ) ).

cnf(i_0_6206,axiom,
    ( ~ esk3050_4(X1,X2,X3,X4)
    | ~ esk3025_4(X1,X2,X3,X4)
    | ~ esk3083_4(X1,X2,X3,X4) ) ).

cnf(i_0_6207,axiom,
    ( esk5265_4(X1,X2,X3,X4)
    | esk5411_4(X1,X2,X3,X4) ) ).

cnf(i_0_6208,axiom,
    ( ~ esk16691_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk139_0
    | p(X1)
    | p(X2)
    | p(X3) ) ).

cnf(i_0_6209,axiom,
    ( esk8513_4(X1,X2,X3,X4)
    | esk8526_4(X1,X2,X3,X4)
    | ~ esk8527_4(X1,X2,X3,X4) ) ).

cnf(i_0_6210,axiom,
    ( esk80_0
    | p(X2)
    | ~ p(X4)
    | ~ p(X3)
    | ~ esk493_4(X1,X2,X3,X4)
    | p(X1) ) ).

cnf(i_0_6211,axiom,
    ( esk11495_4(X1,X2,X3,X4)
    | esk11529_4(X1,X2,X3,X4) ) ).

cnf(i_0_6212,axiom,
    ( esk14713_4(X1,X2,X3,X4)
    | esk14720_4(X1,X2,X3,X4)
    | ~ esk14632_4(X1,X2,X3,X4) ) ).

cnf(i_0_6213,axiom,
    ( ~ esk1285_4(X1,X2,X3,X4)
    | esk1213_4(X1,X2,X3,X4) ) ).

cnf(i_0_6214,axiom,
    ( ~ esk11301_4(X1,X2,X3,X4)
    | esk11043_4(X1,X2,X3,X4) ) ).

cnf(i_0_6215,axiom,
    ( esk10478_4(X1,X2,X3,X4)
    | esk10487_4(X1,X2,X3,X4) ) ).

cnf(i_0_6216,axiom,
    ( esk3339_4(X1,X2,X3,X4)
    | ~ esk3597_4(X1,X2,X3,X4) ) ).

cnf(i_0_6217,axiom,
    ( ~ esk12142_4(X1,X2,X3,X4)
    | esk12117_4(X1,X2,X3,X4)
    | esk12116_4(X1,X2,X3,X4) ) ).

cnf(i_0_6218,axiom,
    ( esk5803_4(X1,X2,X3,X4)
    | esk5753_4(X1,X2,X3,X4) ) ).

cnf(i_0_6219,axiom,
    ( ~ esk7197_4(X1,X2,X3,X4)
    | ~ esk7164_4(X1,X2,X3,X4)
    | ~ esk7137_4(X1,X2,X3,X4) ) ).

cnf(i_0_6220,axiom,
    ( p(X4)
    | ~ p(X1)
    | ~ p(X3)
    | ~ esk107_0
    | ~ p(X2)
    | esk16685_4(X1,X2,X3,X4) ) ).

cnf(i_0_6221,axiom,
    ( ~ esk11004_4(X1,X2,X3,X4)
    | ~ esk11003_4(X1,X2,X3,X4)
    | ~ esk10987_4(X1,X2,X3,X4) ) ).

cnf(i_0_6222,axiom,
    ( ~ esk11190_4(X1,X2,X3,X4)
    | esk11289_4(X1,X2,X3,X4) ) ).

cnf(i_0_6223,axiom,
    ( esk12323_4(X1,X2,X3,X4)
    | esk12371_4(X1,X2,X3,X4) ) ).

cnf(i_0_6224,axiom,
    ( ~ esk9324_4(X1,X2,X3,X4)
    | ~ esk9243_4(X1,X2,X3,X4) ) ).

cnf(i_0_6225,axiom,
    ( esk15370_4(X1,X2,X3,X4)
    | esk15357_4(X1,X2,X3,X4) ) ).

cnf(i_0_6226,axiom,
    ( esk9753_4(X1,X2,X3,X4)
    | ~ esk9651_4(X1,X2,X3,X4) ) ).

cnf(i_0_6227,axiom,
    ( esk6039_4(X1,X2,X3,X4)
    | ~ esk6157_4(X1,X2,X3,X4)
    | ~ esk6059_4(X1,X2,X3,X4) ) ).

cnf(i_0_6228,axiom,
    ( ~ esk14790_4(X1,X2,X3,X4)
    | esk14797_4(X1,X2,X3,X4) ) ).

cnf(i_0_6229,axiom,
    ( ~ esk7396_4(X1,X2,X3,X4)
    | ~ esk7475_4(X1,X2,X3,X4)
    | ~ esk7428_4(X1,X2,X3,X4) ) ).

cnf(i_0_6230,axiom,
    ( esk15394_4(X1,X2,X3,X4)
    | esk15361_4(X1,X2,X3,X4) ) ).

cnf(i_0_6231,axiom,
    ( esk4566_4(X1,X2,X3,X4)
    | esk4571_4(X1,X2,X3,X4) ) ).

cnf(i_0_6232,axiom,
    ( esk2039_4(X1,X2,X3,X4)
    | ~ esk2120_4(X1,X2,X3,X4)
    | esk2127_4(X1,X2,X3,X4) ) ).

cnf(i_0_6233,axiom,
    ( esk7609_4(X1,X2,X3,X4)
    | esk7620_4(X1,X2,X3,X4)
    | ~ esk7621_4(X1,X2,X3,X4) ) ).

cnf(i_0_6234,axiom,
    ( ~ esk2595_4(X1,X2,X3,X4)
    | ~ esk2577_4(X1,X2,X3,X4)
    | ~ esk2575_4(X1,X2,X3,X4) ) ).

cnf(i_0_6235,axiom,
    ( esk7651_4(X1,X2,X3,X4)
    | esk7656_4(X1,X2,X3,X4) ) ).

cnf(i_0_6236,axiom,
    ( ~ esk12145_4(X1,X2,X3,X4)
    | esk12146_4(X1,X2,X3,X4) ) ).

cnf(i_0_6237,axiom,
    ( esk2542_4(X1,X2,X3,X4)
    | esk2496_4(X1,X2,X3,X4) ) ).

cnf(i_0_6238,axiom,
    ( ~ esk5816_4(X1,X2,X3,X4)
    | ~ esk5821_4(X1,X2,X3,X4) ) ).

cnf(i_0_6239,axiom,
    ( esk10712_4(X1,X2,X3,X4)
    | ~ esk10970_4(X1,X2,X3,X4) ) ).

cnf(i_0_6240,axiom,
    ( ~ esk14094_4(X1,X2,X3,X4)
    | ~ esk14078_4(X1,X2,X3,X4)
    | ~ esk14179_4(X1,X2,X3,X4) ) ).

cnf(i_0_6241,axiom,
    ( esk7467_4(X1,X2,X3,X4)
    | esk7321_4(X1,X2,X3,X4) ) ).

cnf(i_0_6242,axiom,
    ( esk4399_4(X1,X2,X3,X4)
    | ~ esk4364_4(X1,X2,X3,X4)
    | esk4418_4(X1,X2,X3,X4) ) ).

cnf(i_0_6243,axiom,
    ( esk7086_4(X1,X2,X3,X4)
    | ~ esk7206_4(X1,X2,X3,X4)
    | esk7055_4(X1,X2,X3,X4) ) ).

cnf(i_0_6244,axiom,
    ( ~ esk6880_4(X1,X2,X3,X4)
    | ~ esk6934_4(X1,X2,X3,X4)
    | ~ esk6901_4(X1,X2,X3,X4) ) ).

cnf(i_0_6245,axiom,
    ( ~ esk14166_4(X1,X2,X3,X4)
    | ~ esk14168_4(X1,X2,X3,X4) ) ).

cnf(i_0_6246,axiom,
    ( ~ esk5683_4(X1,X2,X3,X4)
    | ~ esk5684_4(X1,X2,X3,X4) ) ).

cnf(i_0_6247,axiom,
    ( esk13138_4(X1,X2,X3,X4)
    | esk13140_4(X1,X2,X3,X4)
    | esk13139_4(X1,X2,X3,X4)
    | esk13179_4(X1,X2,X3,X4) ) ).

cnf(i_0_6248,axiom,
    ( esk9714_4(X1,X2,X3,X4)
    | esk9704_4(X1,X2,X3,X4) ) ).

cnf(i_0_6249,axiom,
    ( esk5936_4(X1,X2,X3,X4)
    | esk5964_4(X1,X2,X3,X4) ) ).

cnf(i_0_6250,axiom,
    ( ~ esk7481_4(X1,X2,X3,X4)
    | esk7482_4(X1,X2,X3,X4)
    | esk7503_4(X1,X2,X3,X4) ) ).

cnf(i_0_6251,axiom,
    ( esk5958_4(X1,X2,X3,X4)
    | ~ esk5959_4(X1,X2,X3,X4) ) ).

cnf(i_0_6252,axiom,
    ( esk14625_4(X1,X2,X3,X4)
    | ~ esk14883_4(X1,X2,X3,X4) ) ).

cnf(i_0_6253,axiom,
    ( ~ esk8682_4(X1,X2,X3,X4)
    | ~ esk8679_4(X1,X2,X3,X4)
    | ~ esk8715_4(X1,X2,X3,X4) ) ).

cnf(i_0_6254,axiom,
    ( ~ esk14404_4(X1,X2,X3,X4)
    | esk14662_4(X1,X2,X3,X4) ) ).

cnf(i_0_6255,axiom,
    ( ~ esk493_4(X1,X2,X3,X4)
    | esk79_0
    | ~ p(X3)
    | p(X1)
    | p(X2)
    | p(X4) ) ).

cnf(i_0_6256,axiom,
    ( ~ esk4305_4(X1,X2,X3,X4)
    | esk4353_4(X1,X2,X3,X4) ) ).

cnf(i_0_6257,axiom,
    ( ~ p(X1)
    | p(X4)
    | ~ p(X2)
    | esk16691_4(X1,X2,X3,X4)
    | ~ esk150_0
    | p(X3) ) ).

cnf(i_0_6258,axiom,
    ( esk12057_4(X1,X2,X3,X4)
    | ~ esk12315_4(X1,X2,X3,X4) ) ).

cnf(i_0_6259,axiom,
    ( ~ esk499_4(X1,X2,X3,X4)
    | esk579_4(X1,X2,X3,X4)
    | esk550_4(X1,X2,X3,X4) ) ).

cnf(i_0_6260,axiom,
    ( esk7735_4(X1,X2,X3,X4)
    | esk7763_4(X1,X2,X3,X4) ) ).

cnf(i_0_6261,axiom,
    ( ~ esk4301_4(X1,X2,X3,X4)
    | esk4361_4(X1,X2,X3,X4) ) ).

cnf(i_0_6262,axiom,
    ( esk10737_4(X1,X2,X3,X4)
    | esk10739_4(X1,X2,X3,X4) ) ).

cnf(i_0_6263,axiom,
    ( esk5617_4(X1,X2,X3,X4)
    | esk5703_4(X1,X2,X3,X4) ) ).

cnf(i_0_6264,axiom,
    ( esk2511_4(X1,X2,X3,X4)
    | esk2528_4(X1,X2,X3,X4) ) ).

cnf(i_0_6265,axiom,
    ( esk1351_4(X1,X2,X3,X4)
    | esk1320_4(X1,X2,X3,X4)
    | ~ esk1352_4(X1,X2,X3,X4) ) ).

cnf(i_0_6266,axiom,
    ( ~ esk14821_4(X1,X2,X3,X4)
    | ~ esk14822_4(X1,X2,X3,X4)
    | esk14823_4(X1,X2,X3,X4) ) ).

cnf(i_0_6267,axiom,
    ( ~ esk10998_4(X1,X2,X3,X4)
    | ~ esk11113_4(X1,X2,X3,X4)
    | ~ esk10994_4(X1,X2,X3,X4) ) ).

cnf(i_0_6268,axiom,
    ( ~ esk16502_4(X1,X2,X3,X4)
    | esk16474_4(X1,X2,X3,X4)
    | esk16501_4(X1,X2,X3,X4) ) ).

cnf(i_0_6269,axiom,
    ( esk7592_4(X1,X2,X3,X4)
    | ~ esk7566_4(X1,X2,X3,X4) ) ).

cnf(i_0_6270,axiom,
    ( ~ esk784_4(X1,X2,X3,X4)
    | esk526_4(X1,X2,X3,X4) ) ).

cnf(i_0_6271,axiom,
    ( esk7739_4(X1,X2,X3,X4)
    | esk7738_4(X1,X2,X3,X4)
    | ~ esk7760_4(X1,X2,X3,X4) ) ).

cnf(i_0_6272,axiom,
    ( esk4356_4(X1,X2,X3,X4)
    | ~ esk4098_4(X1,X2,X3,X4) ) ).

cnf(i_0_6273,axiom,
    ( ~ esk2441_4(X1,X2,X3,X4)
    | esk2559_4(X1,X2,X3,X4) ) ).

cnf(i_0_6274,axiom,
    ( ~ esk5338_4(X1,X2,X3,X4)
    | ~ esk5349_4(X1,X2,X3,X4)
    | ~ esk5382_4(X1,X2,X3,X4) ) ).

cnf(i_0_6275,axiom,
    ( esk5365_4(X1,X2,X3,X4)
    | esk5338_4(X1,X2,X3,X4) ) ).

cnf(i_0_6276,axiom,
    ( ~ esk11198_4(X1,X2,X3,X4)
    | ~ esk11316_4(X1,X2,X3,X4) ) ).

cnf(i_0_6277,axiom,
    ( esk14343_4(X1,X2,X3,X4)
    | esk14329_4(X1,X2,X3,X4) ) ).

cnf(i_0_6278,axiom,
    ( ~ esk8327_4(X1,X2,X3,X4)
    | esk8358_4(X1,X2,X3,X4) ) ).

cnf(i_0_6279,axiom,
    ( ~ esk12692_4(X1,X2,X3,X4)
    | ~ esk12690_4(X1,X2,X3,X4)
    | ~ esk12743_4(X1,X2,X3,X4)
    | ~ esk12689_4(X1,X2,X3,X4)
    | ~ esk12742_4(X1,X2,X3,X4) ) ).

cnf(i_0_6280,axiom,
    ( ~ esk11808_4(X1,X2,X3,X4)
    | esk12066_4(X1,X2,X3,X4) ) ).

cnf(i_0_6281,axiom,
    ( esk10082_4(X1,X2,X3,X4)
    | ~ esk10083_4(X1,X2,X3,X4) ) ).

cnf(i_0_6282,axiom,
    ( ~ esk14668_4(X1,X2,X3,X4)
    | esk14667_4(X1,X2,X3,X4) ) ).

cnf(i_0_6283,axiom,
    ( esk15449_4(X1,X2,X3,X4)
    | esk15421_4(X1,X2,X3,X4) ) ).

cnf(i_0_6284,axiom,
    ( ~ esk8517_4(X1,X2,X3,X4)
    | ~ esk8516_4(X1,X2,X3,X4) ) ).

cnf(i_0_6285,axiom,
    ( esk2204_4(X1,X2,X3,X4)
    | ~ esk2189_4(X1,X2,X3,X4) ) ).

cnf(i_0_6286,axiom,
    ( esk1543_4(X1,X2,X3,X4)
    | esk1571_4(X1,X2,X3,X4) ) ).

cnf(i_0_6287,axiom,
    ( esk16622_4(X1,X2,X3,X4)
    | ~ esk16600_4(X1,X2,X3,X4) ) ).

cnf(i_0_6288,axiom,
    ( ~ esk7565_4(X1,X2,X3,X4)
    | esk7593_4(X1,X2,X3,X4) ) ).

cnf(i_0_6289,axiom,
    ( ~ esk1447_4(X1,X2,X3,X4)
    | ~ esk1446_4(X1,X2,X3,X4) ) ).

cnf(i_0_6290,axiom,
    ( ~ esk10052_4(X1,X2,X3,X4)
    | ~ esk10022_4(X1,X2,X3,X4)
    | ~ esk10024_4(X1,X2,X3,X4)
    | ~ esk10050_4(X1,X2,X3,X4) ) ).

cnf(i_0_6291,axiom,
    ( esk12803_4(X1,X2,X3,X4)
    | esk12786_4(X1,X2,X3,X4) ) ).

cnf(i_0_6292,axiom,
    ( esk11275_4(X1,X2,X3,X4)
    | esk11237_4(X1,X2,X3,X4) ) ).

cnf(i_0_6293,axiom,
    ( ~ esk2863_4(X1,X2,X3,X4)
    | ~ esk2862_4(X1,X2,X3,X4) ) ).

cnf(i_0_6294,axiom,
    ( ~ esk2052_4(X1,X2,X3,X4)
    | esk2310_4(X1,X2,X3,X4) ) ).

cnf(i_0_6295,axiom,
    ( ~ esk7347_4(X1,X2,X3,X4)
    | esk7344_4(X1,X2,X3,X4)
    | ~ esk7320_4(X1,X2,X3,X4) ) ).

cnf(i_0_6296,axiom,
    ( ~ esk14025_4(X1,X2,X3,X4)
    | ~ esk14150_4(X1,X2,X3,X4) ) ).

cnf(i_0_6297,axiom,
    ( esk9214_4(X1,X2,X3,X4)
    | esk9183_4(X1,X2,X3,X4) ) ).

cnf(i_0_6298,axiom,
    ( ~ esk8480_4(X1,X2,X3,X4)
    | ~ esk8510_4(X1,X2,X3,X4)
    | ~ esk8482_4(X1,X2,X3,X4)
    | ~ esk8508_4(X1,X2,X3,X4) ) ).

cnf(i_0_6299,axiom,
    ( ~ esk10187_4(X1,X2,X3,X4)
    | esk10189_4(X1,X2,X3,X4)
    | ~ esk10188_4(X1,X2,X3,X4) ) ).

cnf(i_0_6300,axiom,
    ( ~ esk3120_4(X1,X2,X3,X4)
    | esk3149_4(X1,X2,X3,X4)
    | esk3069_4(X1,X2,X3,X4) ) ).

cnf(i_0_6301,axiom,
    ( ~ esk16753_4(X1,X2,X3,X4)
    | esk16751_4(X1,X2,X3,X4) ) ).

cnf(i_0_6302,axiom,
    ( esk3928_4(X1,X2,X3,X4)
    | esk3822_4(X1,X2,X3,X4) ) ).

cnf(i_0_6303,axiom,
    ( esk1966_4(X1,X2,X3,X4)
    | esk1961_4(X1,X2,X3,X4) ) ).

cnf(i_0_6304,axiom,
    ( ~ esk12339_4(X1,X2,X3,X4)
    | esk12391_4(X1,X2,X3,X4) ) ).

cnf(i_0_6305,axiom,
    ( esk6934_4(X1,X2,X3,X4)
    | ~ esk6969_4(X1,X2,X3,X4)
    | esk6988_4(X1,X2,X3,X4) ) ).

cnf(i_0_6306,axiom,
    ( ~ esk1744_4(X1,X2,X3,X4)
    | ~ esk1739_4(X1,X2,X3,X4)
    | ~ esk1743_4(X1,X2,X3,X4) ) ).

cnf(i_0_6307,axiom,
    ( ~ esk6581_4(X1,X2,X3,X4)
    | ~ esk6585_4(X1,X2,X3,X4) ) ).

cnf(i_0_6308,axiom,
    ( esk16154_4(X1,X2,X3,X4)
    | esk16240_4(X1,X2,X3,X4) ) ).

cnf(i_0_6309,axiom,
    ( ~ esk1652_4(X1,X2,X3,X4)
    | esk1684_4(X1,X2,X3,X4) ) ).

cnf(i_0_6310,axiom,
    ( ~ esk4153_4(X1,X2,X3,X4)
    | ~ esk4135_4(X1,X2,X3,X4) ) ).

cnf(i_0_6311,axiom,
    ( esk4517_4(X1,X2,X3,X4)
    | ~ esk4498_4(X1,X2,X3,X4) ) ).

cnf(i_0_6312,axiom,
    ( ~ esk16188_4(X1,X2,X3,X4)
    | esk15930_4(X1,X2,X3,X4) ) ).

cnf(i_0_6313,axiom,
    ( esk10777_4(X1,X2,X3,X4)
    | esk10858_4(X1,X2,X3,X4)
    | ~ esk10865_4(X1,X2,X3,X4) ) ).

cnf(i_0_6314,axiom,
    ( ~ esk12336_4(X1,X2,X3,X4)
    | esk12594_4(X1,X2,X3,X4) ) ).

cnf(i_0_6315,axiom,
    ( esk776_4(X1,X2,X3,X4)
    | esk796_4(X1,X2,X3,X4) ) ).

cnf(i_0_6316,axiom,
    ( esk5667_4(X1,X2,X3,X4)
    | ~ esk5663_4(X1,X2,X3,X4)
    | esk5662_4(X1,X2,X3,X4) ) ).

cnf(i_0_6317,axiom,
    ( esk1599_4(X1,X2,X3,X4)
    | esk1549_4(X1,X2,X3,X4)
    | ~ esk1600_4(X1,X2,X3,X4) ) ).

cnf(i_0_6318,axiom,
    ( esk3889_4(X1,X2,X3,X4)
    | esk3842_4(X1,X2,X3,X4)
    | ~ esk3923_4(X1,X2,X3,X4) ) ).

cnf(i_0_6319,axiom,
    ( esk11993_4(X1,X2,X3,X4)
    | esk11975_4(X1,X2,X3,X4) ) ).

cnf(i_0_6320,axiom,
    ( esk14802_4(X1,X2,X3,X4)
    | esk14811_4(X1,X2,X3,X4) ) ).

cnf(i_0_6321,axiom,
    ( esk11472_4(X1,X2,X3,X4)
    | ~ esk11471_4(X1,X2,X3,X4) ) ).

cnf(i_0_6322,axiom,
    ( esk3499_4(X1,X2,X3,X4)
    | ~ esk3241_4(X1,X2,X3,X4) ) ).

cnf(i_0_6323,axiom,
    ( ~ esk12858_4(X1,X2,X3,X4)
    | ~ esk12740_4(X1,X2,X3,X4) ) ).

cnf(i_0_6324,axiom,
    ( esk586_4(X1,X2,X3,X4)
    | esk547_4(X1,X2,X3,X4)
    | esk546_4(X1,X2,X3,X4)
    | esk545_4(X1,X2,X3,X4) ) ).

cnf(i_0_6325,axiom,
    ( esk4379_4(X1,X2,X3,X4)
    | ~ esk4380_4(X1,X2,X3,X4) ) ).

cnf(i_0_6326,axiom,
    ( esk9941_4(X1,X2,X3,X4)
    | ~ esk10199_4(X1,X2,X3,X4) ) ).

cnf(i_0_6327,axiom,
    ( ~ esk7087_4(X1,X2,X3,X4)
    | ~ esk7203_4(X1,X2,X3,X4)
    | esk7082_4(X1,X2,X3,X4) ) ).

cnf(i_0_6328,axiom,
    ( ~ esk4581_4(X1,X2,X3,X4)
    | ~ esk4695_4(X1,X2,X3,X4)
    | ~ esk4569_4(X1,X2,X3,X4) ) ).

cnf(i_0_6329,axiom,
    ( esk14291_4(X1,X2,X3,X4)
    | esk14297_4(X1,X2,X3,X4)
    | esk14296_4(X1,X2,X3,X4) ) ).

cnf(i_0_6330,axiom,
    ( esk11537_4(X1,X2,X3,X4)
    | esk11570_4(X1,X2,X3,X4) ) ).

cnf(i_0_6331,axiom,
    ( esk15995_4(X1,X2,X3,X4)
    | esk15879_4(X1,X2,X3,X4) ) ).

cnf(i_0_6332,axiom,
    ( esk7872_4(X1,X2,X3,X4)
    | esk7869_4(X1,X2,X3,X4)
    | esk7866_4(X1,X2,X3,X4)
    | esk7870_4(X1,X2,X3,X4) ) ).

cnf(i_0_6333,axiom,
    ( esk13056_4(X1,X2,X3,X4)
    | esk13045_4(X1,X2,X3,X4) ) ).

cnf(i_0_6334,axiom,
    ( ~ esk8661_4(X1,X2,X3,X4)
    | ~ esk8758_4(X1,X2,X3,X4) ) ).

cnf(i_0_6335,axiom,
    ( esk440_4(X1,X2,X3,X4)
    | esk486_4(X1,X2,X3,X4) ) ).

cnf(i_0_6336,axiom,
    ( esk4391_4(X1,X2,X3,X4)
    | esk4376_4(X1,X2,X3,X4) ) ).

cnf(i_0_6337,axiom,
    ( ~ esk8673_4(X1,X2,X3,X4)
    | ~ esk8692_4(X1,X2,X3,X4)
    | ~ esk8693_4(X1,X2,X3,X4) ) ).

cnf(i_0_6338,axiom,
    ( ~ esk13885_4(X1,X2,X3,X4)
    | ~ esk13819_4(X1,X2,X3,X4)
    | ~ esk13852_4(X1,X2,X3,X4) ) ).

cnf(i_0_6339,axiom,
    ( ~ esk2817_4(X1,X2,X3,X4)
    | esk3075_4(X1,X2,X3,X4) ) ).

cnf(i_0_6340,axiom,
    ( ~ esk1314_4(X1,X2,X3,X4)
    | esk1313_4(X1,X2,X3,X4)
    | esk1335_4(X1,X2,X3,X4) ) ).

cnf(i_0_6341,axiom,
    ( esk15633_4(X1,X2,X3,X4)
    | esk15666_4(X1,X2,X3,X4) ) ).

cnf(i_0_6342,axiom,
    ( ~ esk13478_4(X1,X2,X3,X4)
    | esk13502_4(X1,X2,X3,X4) ) ).

cnf(i_0_6343,axiom,
    ( ~ esk6687_4(X1,X2,X3,X4)
    | esk6741_4(X1,X2,X3,X4) ) ).

cnf(i_0_6344,axiom,
    ( ~ esk11336_4(X1,X2,X3,X4)
    | ~ esk11338_4(X1,X2,X3,X4) ) ).

cnf(i_0_6345,axiom,
    ( esk13905_4(X1,X2,X3,X4)
    | esk13948_4(X1,X2,X3,X4) ) ).

cnf(i_0_6346,axiom,
    ( esk15334_4(X1,X2,X3,X4)
    | esk15339_4(X1,X2,X3,X4)
    | ~ esk15335_4(X1,X2,X3,X4) ) ).

cnf(i_0_6347,axiom,
    ( esk14179_4(X1,X2,X3,X4)
    | esk14094_4(X1,X2,X3,X4) ) ).

cnf(i_0_6348,axiom,
    ( ~ esk7629_4(X1,X2,X3,X4)
    | esk7625_4(X1,X2,X3,X4) ) ).

cnf(i_0_6349,axiom,
    ( esk10279_4(X1,X2,X3,X4)
    | esk10309_4(X1,X2,X3,X4) ) ).

cnf(i_0_6350,axiom,
    ( esk3813_4(X1,X2,X3,X4)
    | esk3788_4(X1,X2,X3,X4) ) ).

cnf(i_0_6351,axiom,
    ( ~ esk6716_4(X1,X2,X3,X4)
    | ~ esk6671_4(X1,X2,X3,X4)
    | ~ esk6715_4(X1,X2,X3,X4) ) ).

cnf(i_0_6352,axiom,
    ( esk7653_4(X1,X2,X3,X4)
    | esk7669_4(X1,X2,X3,X4) ) ).

cnf(i_0_6353,axiom,
    ( ~ esk2081_4(X1,X2,X3,X4)
    | esk2111_4(X1,X2,X3,X4) ) ).

cnf(i_0_6354,axiom,
    ( esk11827_4(X1,X2,X3,X4)
    | esk11847_4(X1,X2,X3,X4) ) ).

cnf(i_0_6355,axiom,
    ( esk7970_4(X1,X2,X3,X4)
    | esk7993_4(X1,X2,X3,X4) ) ).

cnf(i_0_6356,axiom,
    ( esk13606_4(X1,X2,X3,X4)
    | ~ esk13348_4(X1,X2,X3,X4) ) ).

cnf(i_0_6357,axiom,
    ( esk1314_4(X1,X2,X3,X4)
    | esk1286_4(X1,X2,X3,X4) ) ).

cnf(i_0_6358,axiom,
    ( ~ esk4868_4(X1,X2,X3,X4)
    | esk4767_4(X1,X2,X3,X4)
    | ~ esk4774_4(X1,X2,X3,X4) ) ).

cnf(i_0_6359,axiom,
    ( esk817_4(X1,X2,X3,X4)
    | ~ esk819_4(X1,X2,X3,X4) ) ).

cnf(i_0_6360,axiom,
    ( esk12328_4(X1,X2,X3,X4)
    | ~ esk12586_4(X1,X2,X3,X4) ) ).

cnf(i_0_6361,axiom,
    ( esk13952_4(X1,X2,X3,X4)
    | esk13829_4(X1,X2,X3,X4) ) ).

cnf(i_0_6362,axiom,
    ( esk10769_4(X1,X2,X3,X4)
    | esk10719_4(X1,X2,X3,X4) ) ).

cnf(i_0_6363,axiom,
    ( ~ esk4567_4(X1,X2,X3,X4)
    | ~ esk4605_4(X1,X2,X3,X4)
    | ~ esk4572_4(X1,X2,X3,X4) ) ).

cnf(i_0_6364,axiom,
    ( esk16412_4(X1,X2,X3,X4)
    | esk16378_4(X1,X2,X3,X4) ) ).

cnf(i_0_6365,axiom,
    ( esk10596_4(X1,X2,X3,X4)
    | ~ esk10542_4(X1,X2,X3,X4) ) ).

cnf(i_0_6366,axiom,
    ( ~ esk13734_4(X1,X2,X3,X4)
    | esk13760_4(X1,X2,X3,X4) ) ).

cnf(i_0_6367,axiom,
    ( esk12988_4(X1,X2,X3,X4)
    | ~ esk12964_4(X1,X2,X3,X4) ) ).

cnf(i_0_6368,axiom,
    ( esk1228_4(X1,X2,X3,X4)
    | esk1258_4(X1,X2,X3,X4) ) ).

cnf(i_0_6369,axiom,
    ( ~ esk2768_4(X1,X2,X3,X4)
    | ~ esk2748_4(X1,X2,X3,X4) ) ).

cnf(i_0_6370,axiom,
    ( ~ esk10819_4(X1,X2,X3,X4)
    | ~ esk10821_4(X1,X2,X3,X4) ) ).

cnf(i_0_6371,axiom,
    ( esk6940_4(X1,X2,X3,X4)
    | esk6907_4(X1,X2,X3,X4) ) ).

cnf(i_0_6372,axiom,
    ( esk15803_4(X1,X2,X3,X4)
    | ~ esk15823_4(X1,X2,X3,X4) ) ).

cnf(i_0_6373,axiom,
    ( ~ esk5164_4(X1,X2,X3,X4)
    | esk5119_4(X1,X2,X3,X4) ) ).

cnf(i_0_6374,axiom,
    ( ~ esk13284_4(X1,X2,X3,X4)
    | esk13282_4(X1,X2,X3,X4) ) ).

cnf(i_0_6375,axiom,
    ( esk4596_4(X1,X2,X3,X4)
    | esk4629_4(X1,X2,X3,X4) ) ).

cnf(i_0_6376,axiom,
    ( ~ esk2889_4(X1,X2,X3,X4)
    | ~ esk2866_4(X1,X2,X3,X4)
    | ~ esk2806_4(X1,X2,X3,X4) ) ).

cnf(i_0_6377,axiom,
    ( esk4538_4(X1,X2,X3,X4)
    | ~ esk4539_4(X1,X2,X3,X4) ) ).

cnf(i_0_6378,axiom,
    ( esk1495_4(X1,X2,X3,X4)
    | esk1607_4(X1,X2,X3,X4) ) ).

cnf(i_0_6379,axiom,
    ( esk6885_4(X1,X2,X3,X4)
    | esk6918_4(X1,X2,X3,X4) ) ).

cnf(i_0_6380,axiom,
    ( esk6123_4(X1,X2,X3,X4)
    | esk6237_4(X1,X2,X3,X4) ) ).

cnf(i_0_6381,axiom,
    ( esk2859_4(X1,X2,X3,X4)
    | esk2872_4(X1,X2,X3,X4)
    | ~ esk2873_4(X1,X2,X3,X4) ) ).

cnf(i_0_6382,axiom,
    ( ~ esk12189_4(X1,X2,X3,X4)
    | esk12221_4(X1,X2,X3,X4) ) ).

cnf(i_0_6383,axiom,
    ( esk7191_4(X1,X2,X3,X4)
    | ~ esk7245_4(X1,X2,X3,X4)
    | esk7226_4(X1,X2,X3,X4) ) ).

cnf(i_0_6384,axiom,
    ( ~ esk11105_4(X1,X2,X3,X4)
    | esk11107_4(X1,X2,X3,X4)
    | ~ esk11106_4(X1,X2,X3,X4) ) ).

cnf(i_0_6385,axiom,
    ( esk13343_4(X1,X2,X3,X4)
    | ~ esk13245_4(X1,X2,X3,X4) ) ).

cnf(i_0_6386,axiom,
    ( esk5275_4(X1,X2,X3,X4)
    | ~ esk5242_4(X1,X2,X3,X4) ) ).

cnf(i_0_6387,axiom,
    ( esk13890_4(X1,X2,X3,X4)
    | ~ esk14148_4(X1,X2,X3,X4) ) ).

cnf(i_0_6388,axiom,
    ( ~ esk16692_4(X1,X2,X3,X4)
    | ~ esk16596_4(X1,X2,X3,X4)
    | esk16590_4(X1,X2,X3,X4) ) ).

cnf(i_0_6389,axiom,
    ( esk15415_4(X1,X2,X3,X4)
    | esk15469_4(X1,X2,X3,X4)
    | ~ esk15450_4(X1,X2,X3,X4) ) ).

cnf(i_0_6390,axiom,
    ( esk12406_4(X1,X2,X3,X4)
    | esk12335_4(X1,X2,X3,X4)
    | ~ esk12387_4(X1,X2,X3,X4) ) ).

cnf(i_0_6391,axiom,
    ( esk12215_4(X1,X2,X3,X4)
    | ~ esk12180_4(X1,X2,X3,X4) ) ).

cnf(i_0_6392,axiom,
    ( esk15938_4(X1,X2,X3,X4)
    | ~ esk16196_4(X1,X2,X3,X4) ) ).

cnf(i_0_6393,axiom,
    ( esk9530_4(X1,X2,X3,X4)
    | esk9523_4(X1,X2,X3,X4) ) ).

cnf(i_0_6394,axiom,
    ( esk10820_4(X1,X2,X3,X4)
    | esk10797_4(X1,X2,X3,X4) ) ).

cnf(i_0_6395,axiom,
    ( ~ esk12277_4(X1,X2,X3,X4)
    | ~ esk12341_4(X1,X2,X3,X4)
    | ~ esk12308_4(X1,X2,X3,X4) ) ).

cnf(i_0_6396,axiom,
    ( esk15353_4(X1,X2,X3,X4)
    | ~ esk15410_4(X1,X2,X3,X4) ) ).

cnf(i_0_6397,axiom,
    ( esk14653_4(X1,X2,X3,X4)
    | ~ esk14911_4(X1,X2,X3,X4) ) ).

cnf(i_0_6398,axiom,
    ( esk11566_4(X1,X2,X3,X4)
    | ~ esk11617_4(X1,X2,X3,X4)
    | esk11592_4(X1,X2,X3,X4) ) ).

cnf(i_0_6399,axiom,
    ( esk12637_4(X1,X2,X3,X4)
    | ~ esk12635_4(X1,X2,X3,X4)
    | ~ esk12636_4(X1,X2,X3,X4) ) ).

cnf(i_0_6400,axiom,
    ( esk14393_4(X1,X2,X3,X4)
    | esk14419_4(X1,X2,X3,X4)
    | ~ esk14444_4(X1,X2,X3,X4) ) ).

cnf(i_0_6401,axiom,
    ( esk3490_4(X1,X2,X3,X4)
    | esk3492_4(X1,X2,X3,X4) ) ).

cnf(i_0_6402,axiom,
    ( esk9197_4(X1,X2,X3,X4)
    | esk9313_4(X1,X2,X3,X4) ) ).

cnf(i_0_6403,axiom,
    ( ~ esk10932_4(X1,X2,X3,X4)
    | esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_6404,axiom,
    ( ~ esk10185_4(X1,X2,X3,X4)
    | ~ esk10184_4(X1,X2,X3,X4) ) ).

cnf(i_0_6405,axiom,
    ( esk16738_4(X1,X2,X3,X4)
    | esk16736_4(X1,X2,X3,X4)
    | esk16777_4(X1,X2,X3,X4)
    | esk16737_4(X1,X2,X3,X4) ) ).

cnf(i_0_6406,axiom,
    ( esk6343_4(X1,X2,X3,X4)
    | ~ esk6601_4(X1,X2,X3,X4) ) ).

cnf(i_0_6407,axiom,
    ( esk10775_4(X1,X2,X3,X4)
    | esk10831_4(X1,X2,X3,X4) ) ).

cnf(i_0_6408,axiom,
    ( ~ esk13072_4(X1,X2,X3,X4)
    | ~ esk13037_4(X1,X2,X3,X4)
    | ~ esk13071_4(X1,X2,X3,X4) ) ).

cnf(i_0_6409,axiom,
    ( ~ esk4955_4(X1,X2,X3,X4)
    | ~ esk4874_4(X1,X2,X3,X4) ) ).

cnf(i_0_6410,axiom,
    ( p(X2)
    | ~ esk19_0
    | p(X1)
    | p(X3)
    | ~ p(X4)
    | esk16602_4(X1,X2,X3,X4) ) ).

cnf(i_0_6411,axiom,
    ( ~ esk11589_4(X1,X2,X3,X4)
    | esk11604_4(X1,X2,X3,X4) ) ).

cnf(i_0_6412,axiom,
    esk15051_4(X1,X2,X3,X4) ).

cnf(i_0_6413,axiom,
    ( esk3512_4(X1,X2,X3,X4)
    | esk3517_4(X1,X2,X3,X4)
    | ~ esk3513_4(X1,X2,X3,X4) ) ).

cnf(i_0_6414,axiom,
    ( ~ esk13302_4(X1,X2,X3,X4)
    | ~ esk13313_4(X1,X2,X3,X4)
    | ~ esk13312_4(X1,X2,X3,X4) ) ).

cnf(i_0_6415,axiom,
    ( esk14000_4(X1,X2,X3,X4)
    | esk13976_4(X1,X2,X3,X4)
    | esk14001_4(X1,X2,X3,X4)
    | esk13998_4(X1,X2,X3,X4)
    | esk14028_4(X1,X2,X3,X4) ) ).

cnf(i_0_6416,axiom,
    ( ~ esk7775_4(X1,X2,X3,X4)
    | ~ esk7695_4(X1,X2,X3,X4)
    | ~ esk7746_4(X1,X2,X3,X4) ) ).

cnf(i_0_6417,axiom,
    ( esk15818_4(X1,X2,X3,X4)
    | ~ esk15919_4(X1,X2,X3,X4)
    | ~ esk15825_4(X1,X2,X3,X4) ) ).

cnf(i_0_6418,axiom,
    ( ~ esk3797_4(X1,X2,X3,X4)
    | ~ esk3798_4(X1,X2,X3,X4) ) ).

cnf(i_0_6419,axiom,
    ( ~ esk13307_4(X1,X2,X3,X4)
    | ~ esk13335_4(X1,X2,X3,X4)
    | ~ esk13420_4(X1,X2,X3,X4) ) ).

cnf(i_0_6420,axiom,
    ( ~ esk12600_4(X1,X2,X3,X4)
    | ~ esk12615_4(X1,X2,X3,X4) ) ).

cnf(i_0_6421,axiom,
    ( esk15174_4(X1,X2,X3,X4)
    | ~ esk15172_4(X1,X2,X3,X4)
    | ~ esk15173_4(X1,X2,X3,X4) ) ).

cnf(i_0_6422,axiom,
    ( esk9390_4(X1,X2,X3,X4)
    | ~ esk9366_4(X1,X2,X3,X4) ) ).

cnf(i_0_6423,axiom,
    ( ~ esk932_4(X1,X2,X3,X4)
    | ~ esk934_4(X1,X2,X3,X4) ) ).

cnf(i_0_6424,axiom,
    ( esk10473_4(X1,X2,X3,X4)
    | esk10490_4(X1,X2,X3,X4) ) ).

cnf(i_0_6425,axiom,
    ( esk4634_4(X1,X2,X3,X4)
    | esk4516_4(X1,X2,X3,X4) ) ).

cnf(i_0_6426,axiom,
    ( esk1182_4(X1,X2,X3,X4)
    | ~ esk1440_4(X1,X2,X3,X4) ) ).

cnf(i_0_6427,axiom,
    ( esk2718_4(X1,X2,X3,X4)
    | ~ esk2694_4(X1,X2,X3,X4)
    | ~ esk2721_4(X1,X2,X3,X4) ) ).

cnf(i_0_6428,axiom,
    ( ~ esk9414_4(X1,X2,X3,X4)
    | ~ esk9412_4(X1,X2,X3,X4) ) ).

cnf(i_0_6429,axiom,
    ( esk1080_4(X1,X2,X3,X4)
    | esk1055_4(X1,X2,X3,X4)
    | ~ esk1029_4(X1,X2,X3,X4) ) ).

cnf(i_0_6430,axiom,
    ( esk12625_4(X1,X2,X3,X4)
    | esk12586_4(X1,X2,X3,X4) ) ).

cnf(i_0_6431,axiom,
    ( ~ esk13564_4(X1,X2,X3,X4)
    | ~ esk13592_4(X1,X2,X3,X4)
    | ~ esk13677_4(X1,X2,X3,X4) ) ).

cnf(i_0_6432,axiom,
    ( ~ esk12708_4(X1,X2,X3,X4)
    | esk12730_4(X1,X2,X3,X4) ) ).

cnf(i_0_6433,axiom,
    ( esk5398_4(X1,X2,X3,X4)
    | ~ esk5140_4(X1,X2,X3,X4) ) ).

cnf(i_0_6434,axiom,
    ( esk7994_4(X1,X2,X3,X4)
    | esk8037_4(X1,X2,X3,X4) ) ).

cnf(i_0_6435,axiom,
    ( esk5084_4(X1,X2,X3,X4)
    | esk5117_4(X1,X2,X3,X4) ) ).

cnf(i_0_6436,axiom,
    ( esk10455_4(X1,X2,X3,X4)
    | ~ esk10713_4(X1,X2,X3,X4) ) ).

cnf(i_0_6437,axiom,
    ( ~ esk9117_4(X1,X2,X3,X4)
    | ~ esk9145_4(X1,X2,X3,X4) ) ).

cnf(i_0_6438,axiom,
    ( esk13879_4(X1,X2,X3,X4)
    | esk13930_4(X1,X2,X3,X4)
    | ~ esk13905_4(X1,X2,X3,X4) ) ).

cnf(i_0_6439,axiom,
    ( esk2566_4(X1,X2,X3,X4)
    | ~ esk2824_4(X1,X2,X3,X4) ) ).

cnf(i_0_6440,axiom,
    ( ~ esk13821_4(X1,X2,X3,X4)
    | ~ esk13847_4(X1,X2,X3,X4)
    | ~ esk13930_4(X1,X2,X3,X4) ) ).

cnf(i_0_6441,axiom,
    ( esk12012_4(X1,X2,X3,X4)
    | esk12038_4(X1,X2,X3,X4) ) ).

cnf(i_0_6442,axiom,
    ( ~ esk7981_4(X1,X2,X3,X4)
    | ~ esk7988_4(X1,X2,X3,X4)
    | ~ esk7835_4(X1,X2,X3,X4) ) ).

cnf(i_0_6443,axiom,
    ( esk5435_4(X1,X2,X3,X4)
    | esk5460_4(X1,X2,X3,X4)
    | ~ esk5434_4(X1,X2,X3,X4) ) ).

cnf(i_0_6444,axiom,
    ( esk2025_4(X1,X2,X3,X4)
    | esk1999_4(X1,X2,X3,X4) ) ).

cnf(i_0_6445,axiom,
    ( esk799_4(X1,X2,X3,X4)
    | esk768_4(X1,X2,X3,X4) ) ).

cnf(i_0_6446,axiom,
    ( esk6158_4(X1,X2,X3,X4)
    | ~ esk6101_4(X1,X2,X3,X4) ) ).

cnf(i_0_6447,axiom,
    ( ~ esk9_0
    | ~ p(X3)
    | esk16600_4(X1,X2,X3,X4)
    | p(X1)
    | p(X4)
    | ~ p(X2) ) ).

cnf(i_0_6448,axiom,
    ( esk10263_4(X1,X2,X3,X4)
    | esk10230_4(X1,X2,X3,X4) ) ).

cnf(i_0_6449,axiom,
    ( esk6121_4(X1,X2,X3,X4)
    | esk6233_4(X1,X2,X3,X4) ) ).

cnf(i_0_6450,axiom,
    ( esk12236_4(X1,X2,X3,X4)
    | ~ esk12494_4(X1,X2,X3,X4) ) ).

cnf(i_0_6451,axiom,
    ( ~ esk11324_4(X1,X2,X3,X4)
    | ~ esk11325_4(X1,X2,X3,X4)
    | esk11326_4(X1,X2,X3,X4) ) ).

cnf(i_0_6452,axiom,
    ( esk11099_4(X1,X2,X3,X4)
    | esk11012_4(X1,X2,X3,X4) ) ).

cnf(i_0_6453,axiom,
    ( esk4517_4(X1,X2,X3,X4)
    | ~ esk4511_4(X1,X2,X3,X4) ) ).

cnf(i_0_6454,axiom,
    ( esk6968_4(X1,X2,X3,X4)
    | esk6989_4(X1,X2,X3,X4)
    | ~ esk6967_4(X1,X2,X3,X4) ) ).

cnf(i_0_6455,axiom,
    ( ~ esk16691_4(X1,X2,X3,X4)
    | esk151_0
    | ~ p(X4)
    | ~ p(X2)
    | p(X3)
    | ~ p(X1) ) ).

cnf(i_0_6456,axiom,
    ( esk2863_4(X1,X2,X3,X4)
    | esk2812_4(X1,X2,X3,X4)
    | ~ esk2892_4(X1,X2,X3,X4) ) ).

cnf(i_0_6457,axiom,
    ( esk2257_4(X1,X2,X3,X4)
    | esk2290_4(X1,X2,X3,X4) ) ).

cnf(i_0_6458,axiom,
    ( esk6637_4(X1,X2,X3,X4)
    | esk6625_4(X1,X2,X3,X4) ) ).

cnf(i_0_6459,axiom,
    ( esk5868_4(X1,X2,X3,X4)
    | esk5854_4(X1,X2,X3,X4) ) ).

cnf(i_0_6460,axiom,
    ( esk6142_4(X1,X2,X3,X4)
    | esk6175_4(X1,X2,X3,X4) ) ).

cnf(i_0_6461,axiom,
    ( esk8206_4(X1,X2,X3,X4)
    | ~ esk8464_4(X1,X2,X3,X4) ) ).

cnf(i_0_6462,axiom,
    ( ~ esk10641_4(X1,X2,X3,X4)
    | esk10670_4(X1,X2,X3,X4) ) ).

cnf(i_0_6463,axiom,
    ( esk11940_4(X1,X2,X3,X4)
    | ~ esk12002_4(X1,X2,X3,X4) ) ).

cnf(i_0_6464,axiom,
    ( ~ esk6716_4(X1,X2,X3,X4)
    | ~ esk6748_4(X1,X2,X3,X4) ) ).

cnf(i_0_6465,axiom,
    ( ~ esk623_4(X1,X2,X3,X4)
    | esk642_4(X1,X2,X3,X4) ) ).

cnf(i_0_6466,axiom,
    ( esk3318_4(X1,X2,X3,X4)
    | ~ esk3221_4(X1,X2,X3,X4) ) ).

cnf(i_0_6467,axiom,
    ( esk16225_4(X1,X2,X3,X4)
    | esk16178_4(X1,X2,X3,X4)
    | ~ esk16259_4(X1,X2,X3,X4) ) ).

cnf(i_0_6468,axiom,
    ( esk97_0
    | ~ p(X2)
    | ~ esk16685_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1)
    | p(X4) ) ).

cnf(i_0_6469,axiom,
    ( ~ esk10809_4(X1,X2,X3,X4)
    | ~ esk10684_4(X1,X2,X3,X4) ) ).

cnf(i_0_6470,axiom,
    ( esk3288_4(X1,X2,X3,X4)
    | esk3284_4(X1,X2,X3,X4) ) ).

cnf(i_0_6471,axiom,
    ( ~ esk5167_4(X1,X2,X3,X4)
    | ~ esk5139_4(X1,X2,X3,X4)
    | ~ esk5141_4(X1,X2,X3,X4)
    | ~ esk5169_4(X1,X2,X3,X4) ) ).

cnf(i_0_6472,axiom,
    ( esk405_4(X1,X2,X3,X4)
    | ~ esk388_4(X1,X2,X3,X4) ) ).

cnf(i_0_6473,axiom,
    ( ~ esk648_4(X1,X2,X3,X4)
    | esk662_4(X1,X2,X3,X4) ) ).

cnf(i_0_6474,axiom,
    ( esk9786_4(X1,X2,X3,X4)
    | esk9787_4(X1,X2,X3,X4) ) ).

cnf(i_0_6475,axiom,
    ( ~ esk16184_4(X1,X2,X3,X4)
    | esk15926_4(X1,X2,X3,X4) ) ).

cnf(i_0_6476,axiom,
    ( ~ esk279_0
    | p(X1)
    | ~ p(X3)
    | ~ p(X4)
    | ~ p(X2)
    | esk519_4(X1,X2,X3,X4) ) ).

cnf(i_0_6477,axiom,
    ( esk2588_4(X1,X2,X3,X4)
    | ~ esk2589_4(X1,X2,X3,X4) ) ).

cnf(i_0_6478,axiom,
    ( ~ esk6023_4(X1,X2,X3,X4)
    | esk6051_4(X1,X2,X3,X4) ) ).

cnf(i_0_6479,axiom,
    ( esk2207_4(X1,X2,X3,X4)
    | ~ esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_6480,axiom,
    ( p(X3)
    | ~ esk203_0
    | ~ p(X4)
    | esk16699_4(X1,X2,X3,X4)
    | ~ p(X2)
    | p(X1) ) ).

cnf(i_0_6481,axiom,
    ( ~ esk4322_4(X1,X2,X3,X4)
    | ~ esk4321_4(X1,X2,X3,X4)
    | ~ esk4305_4(X1,X2,X3,X4) ) ).

cnf(i_0_6482,axiom,
    ( ~ esk6825_4(X1,X2,X3,X4)
    | esk6830_4(X1,X2,X3,X4) ) ).

cnf(i_0_6483,axiom,
    ( esk9703_4(X1,X2,X3,X4)
    | ~ esk9748_4(X1,X2,X3,X4) ) ).

cnf(i_0_6484,axiom,
    ( ~ esk4602_4(X1,X2,X3,X4)
    | esk4566_4(X1,X2,X3,X4) ) ).

cnf(i_0_6485,axiom,
    ( ~ esk10723_4(X1,X2,X3,X4)
    | esk10792_4(X1,X2,X3,X4) ) ).

cnf(i_0_6486,axiom,
    ( ~ p(X1)
    | p(X2)
    | esk327_0
    | p(X3)
    | ~ p(X4)
    | ~ esk16724_4(X1,X2,X3,X4) ) ).

cnf(i_0_6487,axiom,
    ( ~ esk10758_4(X1,X2,X3,X4)
    | ~ esk10791_4(X1,X2,X3,X4)
    | ~ esk10735_4(X1,X2,X3,X4) ) ).

cnf(i_0_6488,axiom,
    ( esk1195_4(X1,X2,X3,X4)
    | esk1190_4(X1,X2,X3,X4) ) ).

cnf(i_0_6489,axiom,
    ( ~ esk6578_4(X1,X2,X3,X4)
    | esk6598_4(X1,X2,X3,X4) ) ).

cnf(i_0_6490,axiom,
    ( ~ esk9679_4(X1,X2,X3,X4)
    | esk9663_4(X1,X2,X3,X4) ) ).

cnf(i_0_6491,axiom,
    ( ~ p(X3)
    | p(X2)
    | p(X4)
    | esk493_4(X1,X2,X3,X4)
    | ~ esk87_0
    | ~ p(X1) ) ).

cnf(i_0_6492,axiom,
    ( ~ esk9203_4(X1,X2,X3,X4)
    | ~ esk9326_4(X1,X2,X3,X4)
    | ~ esk9195_4(X1,X2,X3,X4) ) ).

cnf(i_0_6493,axiom,
    ( esk2824_4(X1,X2,X3,X4)
    | ~ esk2702_4(X1,X2,X3,X4) ) ).

cnf(i_0_6494,axiom,
    ( esk588_4(X1,X2,X3,X4)
    | esk578_4(X1,X2,X3,X4) ) ).

cnf(i_0_6495,axiom,
    ( p(X1)
    | esk217_0
    | p(X3)
    | ~ p(X4)
    | ~ p(X2)
    | ~ esk511_4(X1,X2,X3,X4) ) ).

cnf(i_0_6496,axiom,
    ( esk5645_4(X1,X2,X3,X4)
    | ~ esk5387_4(X1,X2,X3,X4) ) ).

cnf(i_0_6497,axiom,
    ( ~ esk7389_4(X1,X2,X3,X4)
    | ~ esk7405_4(X1,X2,X3,X4)
    | ~ esk7406_4(X1,X2,X3,X4) ) ).

cnf(i_0_6498,axiom,
    ( ~ esk16081_4(X1,X2,X3,X4)
    | esk16208_4(X1,X2,X3,X4) ) ).

cnf(i_0_6499,axiom,
    ( ~ esk14566_4(X1,X2,X3,X4)
    | esk14544_4(X1,X2,X3,X4) ) ).

cnf(i_0_6500,axiom,
    ( esk845_4(X1,X2,X3,X4)
    | esk722_4(X1,X2,X3,X4) ) ).

cnf(i_0_6501,axiom,
    ( esk5553_4(X1,X2,X3,X4)
    | esk5552_4(X1,X2,X3,X4) ) ).

cnf(i_0_6502,axiom,
    ( esk5320_4(X1,X2,X3,X4)
    | ~ esk5258_4(X1,X2,X3,X4) ) ).

cnf(i_0_6503,axiom,
    ( p(X3)
    | ~ p(X1)
    | p(X2)
    | ~ esk191_0
    | esk16697_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_6504,axiom,
    ( esk4130_4(X1,X2,X3,X4)
    | ~ esk4131_4(X1,X2,X3,X4) ) ).

cnf(i_0_6505,axiom,
    ( ~ esk9987_4(X1,X2,X3,X4)
    | ~ esk9964_4(X1,X2,X3,X4)
    | ~ esk10020_4(X1,X2,X3,X4) ) ).

cnf(i_0_6506,axiom,
    ( p(X4)
    | ~ esk16707_4(X1,X2,X3,X4)
    | esk268_0
    | ~ p(X1)
    | ~ p(X3)
    | p(X2) ) ).

cnf(i_0_6507,axiom,
    ( ~ esk15068_4(X1,X2,X3,X4)
    | ~ esk15073_4(X1,X2,X3,X4) ) ).

cnf(i_0_6508,axiom,
    ( ~ esk6862_4(X1,X2,X3,X4)
    | esk6826_4(X1,X2,X3,X4)
    | ~ esk6842_4(X1,X2,X3,X4) ) ).

cnf(i_0_6509,axiom,
    ( ~ esk837_4(X1,X2,X3,X4)
    | esk838_4(X1,X2,X3,X4) ) ).

cnf(i_0_6510,axiom,
    ( esk252_0
    | ~ p(X1)
    | ~ p(X3)
    | p(X4)
    | p(X2)
    | ~ esk515_4(X1,X2,X3,X4) ) ).

cnf(i_0_6511,axiom,
    ( esk9919_4(X1,X2,X3,X4)
    | esk9928_4(X1,X2,X3,X4) ) ).

cnf(i_0_6512,axiom,
    ( ~ esk9402_4(X1,X2,X3,X4)
    | ~ esk9401_4(X1,X2,X3,X4)
    | ~ esk9351_4(X1,X2,X3,X4)
    | ~ esk9348_4(X1,X2,X3,X4)
    | ~ esk9349_4(X1,X2,X3,X4) ) ).

cnf(i_0_6513,axiom,
    ( esk4061_4(X1,X2,X3,X4)
    | esk4050_4(X1,X2,X3,X4) ) ).

cnf(i_0_6514,axiom,
    ( ~ esk9165_4(X1,X2,X3,X4)
    | esk9164_4(X1,X2,X3,X4) ) ).

cnf(i_0_6515,axiom,
    ( ~ esk12296_4(X1,X2,X3,X4)
    | ~ esk12329_4(X1,X2,X3,X4)
    | ~ esk12277_4(X1,X2,X3,X4) ) ).

cnf(i_0_6516,axiom,
    ( esk3413_4(X1,X2,X3,X4)
    | esk3332_4(X1,X2,X3,X4) ) ).

cnf(i_0_6517,axiom,
    ( ~ esk5938_4(X1,X2,X3,X4)
    | ~ esk5936_4(X1,X2,X3,X4) ) ).

cnf(i_0_6518,axiom,
    ( esk12888_4(X1,X2,X3,X4)
    | esk12913_4(X1,X2,X3,X4)
    | ~ esk12887_4(X1,X2,X3,X4) ) ).

cnf(i_0_6519,axiom,
    ( esk13914_4(X1,X2,X3,X4)
    | esk13916_4(X1,X2,X3,X4) ) ).

cnf(i_0_6520,axiom,
    ( ~ esk7331_4(X1,X2,X3,X4)
    | esk7344_4(X1,X2,X3,X4) ) ).

cnf(i_0_6521,axiom,
    ( esk880_4(X1,X2,X3,X4)
    | ~ esk899_4(X1,X2,X3,X4) ) ).

cnf(i_0_6522,axiom,
    ( ~ esk12769_4(X1,X2,X3,X4)
    | esk12765_4(X1,X2,X3,X4) ) ).

cnf(i_0_6523,axiom,
    ( esk13632_4(X1,X2,X3,X4)
    | ~ esk13633_4(X1,X2,X3,X4) ) ).

cnf(i_0_6524,axiom,
    ( ~ esk7394_4(X1,X2,X3,X4)
    | ~ esk7409_4(X1,X2,X3,X4)
    | ~ esk7442_4(X1,X2,X3,X4) ) ).

cnf(i_0_6525,axiom,
    ( esk11865_4(X1,X2,X3,X4)
    | ~ esk11845_4(X1,X2,X3,X4) ) ).

cnf(i_0_6526,axiom,
    ( ~ esk10066_4(X1,X2,X3,X4)
    | ~ esk10065_4(X1,X2,X3,X4)
    | esk10067_4(X1,X2,X3,X4) ) ).

cnf(i_0_6527,axiom,
    ( esk14920_4(X1,X2,X3,X4)
    | esk14774_4(X1,X2,X3,X4) ) ).

cnf(i_0_6528,axiom,
    ( esk2270_4(X1,X2,X3,X4)
    | esk2353_4(X1,X2,X3,X4) ) ).

cnf(i_0_6529,axiom,
    ( ~ esk9786_4(X1,X2,X3,X4)
    | esk9528_4(X1,X2,X3,X4) ) ).

cnf(i_0_6530,axiom,
    ( esk5885_4(X1,X2,X3,X4)
    | esk5918_4(X1,X2,X3,X4) ) ).

cnf(i_0_6531,axiom,
    ( esk11971_4(X1,X2,X3,X4)
    | esk11972_4(X1,X2,X3,X4) ) ).

cnf(i_0_6532,axiom,
    ( ~ esk7963_4(X1,X2,X3,X4)
    | esk7897_4(X1,X2,X3,X4) ) ).

cnf(i_0_6533,axiom,
    ( esk3142_4(X1,X2,X3,X4)
    | ~ esk3141_4(X1,X2,X3,X4) ) ).

cnf(i_0_6534,axiom,
    ( esk9239_4(X1,X2,X3,X4)
    | esk9206_4(X1,X2,X3,X4) ) ).

cnf(i_0_6535,axiom,
    ( ~ esk1975_4(X1,X2,X3,X4)
    | ~ esk1976_4(X1,X2,X3,X4) ) ).

cnf(i_0_6536,axiom,
    ( esk11620_4(X1,X2,X3,X4)
    | ~ esk11590_4(X1,X2,X3,X4) ) ).

cnf(i_0_6537,axiom,
    ( ~ esk5340_4(X1,X2,X3,X4)
    | ~ esk5372_4(X1,X2,X3,X4)
    | ~ esk5419_4(X1,X2,X3,X4) ) ).

cnf(i_0_6538,axiom,
    ( ~ esk8482_4(X1,X2,X3,X4)
    | ~ esk8372_4(X1,X2,X3,X4)
    | esk8358_4(X1,X2,X3,X4) ) ).

cnf(i_0_6539,axiom,
    ( ~ esk2941_4(X1,X2,X3,X4)
    | esk2965_4(X1,X2,X3,X4) ) ).

cnf(i_0_6540,axiom,
    ( esk11508_4(X1,X2,X3,X4)
    | esk11518_4(X1,X2,X3,X4) ) ).

cnf(i_0_6541,axiom,
    ( ~ esk9032_4(X1,X2,X3,X4)
    | ~ esk9034_4(X1,X2,X3,X4) ) ).

cnf(i_0_6542,axiom,
    ( ~ esk2578_4(X1,X2,X3,X4)
    | ~ esk2460_4(X1,X2,X3,X4) ) ).

cnf(i_0_6543,axiom,
    ( ~ esk2730_4(X1,X2,X3,X4)
    | ~ esk2729_4(X1,X2,X3,X4) ) ).

cnf(i_0_6544,axiom,
    ( ~ esk12487_4(X1,X2,X3,X4)
    | ~ esk12485_4(X1,X2,X3,X4) ) ).

cnf(i_0_6545,axiom,
    ( esk5438_4(X1,X2,X3,X4)
    | esk5388_4(X1,X2,X3,X4)
    | ~ esk5439_4(X1,X2,X3,X4) ) ).

cnf(i_0_6546,axiom,
    ( ~ esk1004_4(X1,X2,X3,X4)
    | esk1262_4(X1,X2,X3,X4) ) ).

cnf(i_0_6547,axiom,
    ( esk11933_4(X1,X2,X3,X4)
    | ~ esk11963_4(X1,X2,X3,X4) ) ).

cnf(i_0_6548,axiom,
    ( esk5178_4(X1,X2,X3,X4)
    | esk5176_4(X1,X2,X3,X4) ) ).

cnf(i_0_6549,axiom,
    ( esk11853_4(X1,X2,X3,X4)
    | esk11817_4(X1,X2,X3,X4) ) ).

cnf(i_0_6550,axiom,
    ( esk1503_4(X1,X2,X3,X4)
    | esk1590_4(X1,X2,X3,X4) ) ).

cnf(i_0_6551,axiom,
    ( esk781_4(X1,X2,X3,X4)
    | ~ esk782_4(X1,X2,X3,X4) ) ).

cnf(i_0_6552,axiom,
    ( esk714_4(X1,X2,X3,X4)
    | esk726_4(X1,X2,X3,X4) ) ).

cnf(i_0_6553,axiom,
    ( esk15897_4(X1,X2,X3,X4)
    | esk15865_4(X1,X2,X3,X4) ) ).

cnf(i_0_6554,axiom,
    ( esk8751_4(X1,X2,X3,X4)
    | esk8660_4(X1,X2,X3,X4) ) ).

cnf(i_0_6555,axiom,
    ( esk13114_4(X1,X2,X3,X4)
    | esk13129_4(X1,X2,X3,X4) ) ).

cnf(i_0_6556,axiom,
    ( esk8681_4(X1,X2,X3,X4)
    | esk8695_4(X1,X2,X3,X4) ) ).

cnf(i_0_6557,axiom,
    ( ~ esk5538_4(X1,X2,X3,X4)
    | esk5508_4(X1,X2,X3,X4) ) ).

cnf(i_0_6558,axiom,
    ( esk5855_4(X1,X2,X3,X4)
    | esk5852_4(X1,X2,X3,X4) ) ).

cnf(i_0_6559,axiom,
    ( esk9206_4(X1,X2,X3,X4)
    | esk9193_4(X1,X2,X3,X4) ) ).

cnf(i_0_6560,axiom,
    ( ~ esk10154_4(X1,X2,X3,X4)
    | esk10129_4(X1,X2,X3,X4) ) ).

cnf(i_0_6561,axiom,
    ( esk13415_4(X1,X2,X3,X4)
    | ~ esk13434_4(X1,X2,X3,X4)
    | esk13363_4(X1,X2,X3,X4) ) ).

cnf(i_0_6562,axiom,
    esk12224_4(X1,X2,X3,X4) ).

cnf(i_0_6563,axiom,
    ( esk8695_4(X1,X2,X3,X4)
    | esk8778_4(X1,X2,X3,X4) ) ).

cnf(i_0_6564,axiom,
    ( esk12020_4(X1,X2,X3,X4)
    | esk12033_4(X1,X2,X3,X4) ) ).

cnf(i_0_6565,axiom,
    ( esk14391_4(X1,X2,X3,X4)
    | ~ esk14268_4(X1,X2,X3,X4) ) ).

cnf(i_0_6566,axiom,
    ( esk3561_4(X1,X2,X3,X4)
    | esk3529_4(X1,X2,X3,X4) ) ).

cnf(i_0_6567,axiom,
    ( esk14030_4(X1,X2,X3,X4)
    | ~ esk14288_4(X1,X2,X3,X4) ) ).

cnf(i_0_6568,axiom,
    ( esk6357_4(X1,X2,X3,X4)
    | esk6386_4(X1,X2,X3,X4) ) ).

cnf(i_0_6569,axiom,
    ( ~ esk5166_4(X1,X2,X3,X4)
    | ~ esk5143_4(X1,X2,X3,X4) ) ).

cnf(i_0_6570,axiom,
    ( ~ esk6714_4(X1,X2,X3,X4)
    | esk6728_4(X1,X2,X3,X4) ) ).

cnf(i_0_6571,axiom,
    ( ~ esk10574_4(X1,X2,X3,X4)
    | esk10575_4(X1,X2,X3,X4)
    | esk10600_4(X1,X2,X3,X4) ) ).

cnf(i_0_6572,axiom,
    ( ~ esk7852_4(X1,X2,X3,X4)
    | esk7820_4(X1,X2,X3,X4) ) ).

cnf(i_0_6573,axiom,
    ( esk2288_4(X1,X2,X3,X4)
    | esk2335_4(X1,X2,X3,X4) ) ).

cnf(i_0_6574,axiom,
    ( esk10934_4(X1,X2,X3,X4)
    | ~ esk11034_4(X1,X2,X3,X4)
    | ~ esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_6575,axiom,
    ( ~ esk3142_4(X1,X2,X3,X4)
    | esk3141_4(X1,X2,X3,X4)
    | esk3091_4(X1,X2,X3,X4) ) ).

cnf(i_0_6576,axiom,
    ( ~ esk3583_4(X1,X2,X3,X4)
    | ~ esk3581_4(X1,X2,X3,X4)
    | ~ esk3634_4(X1,X2,X3,X4)
    | ~ esk3636_4(X1,X2,X3,X4) ) ).

cnf(i_0_6577,axiom,
    ( ~ esk3626_4(X1,X2,X3,X4)
    | esk3648_4(X1,X2,X3,X4)
    | esk3627_4(X1,X2,X3,X4) ) ).

cnf(i_0_6578,axiom,
    ( esk13800_4(X1,X2,X3,X4)
    | ~ esk13748_4(X1,X2,X3,X4) ) ).

cnf(i_0_6579,axiom,
    ( esk966_4(X1,X2,X3,X4)
    | esk977_4(X1,X2,X3,X4) ) ).

cnf(i_0_6580,axiom,
    esk16593_4(X1,X2,X3,X4) ).

cnf(i_0_6581,axiom,
    ( ~ esk5367_4(X1,X2,X3,X4)
    | ~ esk5324_4(X1,X2,X3,X4)
    | ~ esk5368_4(X1,X2,X3,X4) ) ).

cnf(i_0_6582,axiom,
    ( ~ esk10564_4(X1,X2,X3,X4)
    | ~ esk10563_4(X1,X2,X3,X4) ) ).

cnf(i_0_6583,axiom,
    ( esk13015_4(X1,X2,X3,X4)
    | ~ esk13016_4(X1,X2,X3,X4) ) ).

cnf(i_0_6584,axiom,
    ( esk15190_4(X1,X2,X3,X4)
    | esk15164_4(X1,X2,X3,X4)
    | ~ esk15215_4(X1,X2,X3,X4) ) ).

cnf(i_0_6585,axiom,
    ( esk13546_4(X1,X2,X3,X4)
    | esk13596_4(X1,X2,X3,X4) ) ).

cnf(i_0_6586,axiom,
    ( esk14789_4(X1,X2,X3,X4)
    | ~ esk14797_4(X1,X2,X3,X4)
    | ~ esk14889_4(X1,X2,X3,X4) ) ).

cnf(i_0_6587,axiom,
    ( ~ esk16671_4(X1,X2,X3,X4)
    | ~ esk16646_4(X1,X2,X3,X4)
    | ~ esk16704_4(X1,X2,X3,X4) ) ).

cnf(i_0_6588,axiom,
    ( esk5211_4(X1,X2,X3,X4)
    | ~ esk5204_4(X1,X2,X3,X4)
    | esk5123_4(X1,X2,X3,X4) ) ).

cnf(i_0_6589,axiom,
    ( esk6144_4(X1,X2,X3,X4)
    | ~ esk6402_4(X1,X2,X3,X4) ) ).

cnf(i_0_6590,axiom,
    ( esk5436_4(X1,X2,X3,X4)
    | ~ esk5459_4(X1,X2,X3,X4)
    | esk5376_4(X1,X2,X3,X4) ) ).

cnf(i_0_6591,axiom,
    ( esk10562_4(X1,X2,X3,X4)
    | esk10540_4(X1,X2,X3,X4)
    | ~ esk10592_4(X1,X2,X3,X4) ) ).

cnf(i_0_6592,axiom,
    ( esk12283_4(X1,X2,X3,X4)
    | esk12279_4(X1,X2,X3,X4) ) ).

cnf(i_0_6593,axiom,
    ( p(X4)
    | ~ esk16687_4(X1,X2,X3,X4)
    | ~ p(X3)
    | esk110_0
    | p(X2)
    | p(X1) ) ).

cnf(i_0_6594,axiom,
    ( ~ esk4928_4(X1,X2,X3,X4)
    | esk4929_4(X1,X2,X3,X4) ) ).

cnf(i_0_6595,axiom,
    ( ~ esk6856_4(X1,X2,X3,X4)
    | esk6854_4(X1,X2,X3,X4) ) ).

cnf(i_0_6596,axiom,
    ( ~ esk6628_4(X1,X2,X3,X4)
    | ~ esk6661_4(X1,X2,X3,X4)
    | ~ esk6623_4(X1,X2,X3,X4) ) ).

cnf(i_0_6597,axiom,
    ( ~ esk14395_4(X1,X2,X3,X4)
    | ~ esk14418_4(X1,X2,X3,X4) ) ).

cnf(i_0_6598,axiom,
    ( ~ esk14649_4(X1,X2,X3,X4)
    | esk14577_4(X1,X2,X3,X4) ) ).

cnf(i_0_6599,axiom,
    ( esk13774_4(X1,X2,X3,X4)
    | esk13792_4(X1,X2,X3,X4) ) ).

cnf(i_0_6600,axiom,
    ( esk14006_4(X1,X2,X3,X4)
    | ~ esk13987_4(X1,X2,X3,X4) ) ).

cnf(i_0_6601,axiom,
    ( esk6221_4(X1,X2,X3,X4)
    | esk6193_4(X1,X2,X3,X4) ) ).

cnf(i_0_6602,axiom,
    ( esk13779_4(X1,X2,X3,X4)
    | ~ esk13785_4(X1,X2,X3,X4)
    | esk13784_4(X1,X2,X3,X4) ) ).

cnf(i_0_6603,axiom,
    ( ~ esk11745_4(X1,X2,X3,X4)
    | ~ esk11725_4(X1,X2,X3,X4)
    | esk11709_4(X1,X2,X3,X4) ) ).

cnf(i_0_6604,axiom,
    ( esk3284_4(X1,X2,X3,X4)
    | esk3294_4(X1,X2,X3,X4) ) ).

cnf(i_0_6605,axiom,
    ( esk9408_4(X1,X2,X3,X4)
    | esk9407_4(X1,X2,X3,X4) ) ).

cnf(i_0_6606,axiom,
    ( ~ esk873_4(X1,X2,X3,X4)
    | esk906_4(X1,X2,X3,X4) ) ).

cnf(i_0_6607,axiom,
    ( ~ esk11552_4(X1,X2,X3,X4)
    | esk11633_4(X1,X2,X3,X4) ) ).

cnf(i_0_6608,axiom,
    ( ~ esk13025_4(X1,X2,X3,X4)
    | esk13027_4(X1,X2,X3,X4) ) ).

cnf(i_0_6609,axiom,
    ( esk12293_4(X1,X2,X3,X4)
    | esk12279_4(X1,X2,X3,X4) ) ).

cnf(i_0_6610,axiom,
    ( esk15034_4(X1,X2,X3,X4)
    | ~ esk15015_4(X1,X2,X3,X4) ) ).

cnf(i_0_6611,axiom,
    ( ~ esk4773_4(X1,X2,X3,X4)
    | esk4900_4(X1,X2,X3,X4) ) ).

cnf(i_0_6612,axiom,
    ( ~ esk12349_4(X1,X2,X3,X4)
    | esk12345_4(X1,X2,X3,X4) ) ).

cnf(i_0_6613,axiom,
    ( esk3232_4(X1,X2,X3,X4)
    | ~ esk3219_4(X1,X2,X3,X4) ) ).

cnf(i_0_6614,axiom,
    ( esk11059_4(X1,X2,X3,X4)
    | esk10941_4(X1,X2,X3,X4) ) ).

cnf(i_0_6615,axiom,
    ( ~ esk5410_4(X1,X2,X3,X4)
    | esk5152_4(X1,X2,X3,X4) ) ).

cnf(i_0_6616,axiom,
    ( ~ esk9511_4(X1,X2,X3,X4)
    | esk9769_4(X1,X2,X3,X4) ) ).

cnf(i_0_6617,axiom,
    ( esk3079_4(X1,X2,X3,X4)
    | ~ esk2821_4(X1,X2,X3,X4) ) ).

cnf(i_0_6618,axiom,
    ( esk15373_4(X1,X2,X3,X4)
    | esk15363_4(X1,X2,X3,X4) ) ).

cnf(i_0_6619,axiom,
    ( esk16004_4(X1,X2,X3,X4)
    | esk15935_4(X1,X2,X3,X4) ) ).

cnf(i_0_6620,axiom,
    ( esk8403_4(X1,X2,X3,X4)
    | esk8501_4(X1,X2,X3,X4) ) ).

cnf(i_0_6621,axiom,
    ( esk7898_4(X1,X2,X3,X4)
    | esk7930_4(X1,X2,X3,X4) ) ).

cnf(i_0_6622,axiom,
    ( ~ esk5125_4(X1,X2,X3,X4)
    | ~ esk5092_4(X1,X2,X3,X4)
    | ~ esk5081_4(X1,X2,X3,X4) ) ).

cnf(i_0_6623,axiom,
    ( esk3799_4(X1,X2,X3,X4)
    | esk3796_4(X1,X2,X3,X4) ) ).

cnf(i_0_6624,axiom,
    ( esk4323_4(X1,X2,X3,X4)
    | esk4356_4(X1,X2,X3,X4) ) ).

cnf(i_0_6625,axiom,
    ( ~ esk1838_4(X1,X2,X3,X4)
    | ~ esk1837_4(X1,X2,X3,X4) ) ).

cnf(i_0_6626,axiom,
    ( ~ esk6234_4(X1,X2,X3,X4)
    | ~ esk6202_4(X1,X2,X3,X4) ) ).

cnf(i_0_6627,axiom,
    ( ~ p(X2)
    | ~ p(X4)
    | p(X3)
    | p(X1)
    | ~ esk521_4(X1,X2,X3,X4)
    | esk292_0 ) ).

cnf(i_0_6628,axiom,
    ( esk8021_4(X1,X2,X3,X4)
    | ~ esk8023_4(X1,X2,X3,X4) ) ).

cnf(i_0_6629,axiom,
    ( ~ esk16215_4(X1,X2,X3,X4)
    | ~ esk16252_4(X1,X2,X3,X4)
    | ~ esk16168_4(X1,X2,X3,X4) ) ).

cnf(i_0_6630,axiom,
    ( esk9536_4(X1,X2,X3,X4)
    | esk9538_4(X1,X2,X3,X4) ) ).

cnf(i_0_6631,axiom,
    ( ~ esk1003_4(X1,X2,X3,X4)
    | ~ esk1050_4(X1,X2,X3,X4)
    | ~ esk971_4(X1,X2,X3,X4) ) ).

cnf(i_0_6632,axiom,
    ( ~ esk3760_4(X1,X2,X3,X4)
    | ~ esk3758_4(X1,X2,X3,X4) ) ).

cnf(i_0_6633,axiom,
    ( esk6378_4(X1,X2,X3,X4)
    | esk6368_4(X1,X2,X3,X4) ) ).

cnf(i_0_6634,axiom,
    ( esk6345_4(X1,X2,X3,X4)
    | ~ esk6343_4(X1,X2,X3,X4) ) ).

cnf(i_0_6635,axiom,
    ( ~ esk13237_4(X1,X2,X3,X4)
    | esk13214_4(X1,X2,X3,X4) ) ).

cnf(i_0_6636,axiom,
    ( ~ esk14283_4(X1,X2,X3,X4)
    | ~ esk14383_4(X1,X2,X3,X4)
    | esk14264_4(X1,X2,X3,X4) ) ).

cnf(i_0_6637,axiom,
    ( ~ esk10440_4(X1,X2,X3,X4)
    | ~ esk10439_4(X1,X2,X3,X4) ) ).

cnf(i_0_6638,axiom,
    ( ~ esk10685_4(X1,X2,X3,X4)
    | ~ esk10791_4(X1,X2,X3,X4)
    | esk10669_4(X1,X2,X3,X4) ) ).

cnf(i_0_6639,axiom,
    ( esk4024_4(X1,X2,X3,X4)
    | ~ esk4017_4(X1,X2,X3,X4) ) ).

cnf(i_0_6640,axiom,
    ( esk12014_4(X1,X2,X3,X4)
    | ~ esk12065_4(X1,X2,X3,X4) ) ).

cnf(i_0_6641,axiom,
    ( esk8407_4(X1,X2,X3,X4)
    | esk8454_4(X1,X2,X3,X4) ) ).

cnf(i_0_6642,axiom,
    ( ~ esk4984_4(X1,X2,X3,X4)
    | esk5019_4(X1,X2,X3,X4) ) ).

cnf(i_0_6643,axiom,
    ( ~ esk6581_4(X1,X2,X3,X4)
    | esk6593_4(X1,X2,X3,X4) ) ).

cnf(i_0_6644,axiom,
    ( ~ esk11365_4(X1,X2,X3,X4)
    | ~ esk11313_4(X1,X2,X3,X4) ) ).

cnf(i_0_6645,axiom,
    ( ~ esk7736_4(X1,X2,X3,X4)
    | esk7764_4(X1,X2,X3,X4) ) ).

cnf(i_0_6646,axiom,
    ( ~ esk16058_4(X1,X2,X3,X4)
    | esk16082_4(X1,X2,X3,X4)
    | ~ esk16085_4(X1,X2,X3,X4) ) ).

cnf(i_0_6647,axiom,
    ( esk2856_4(X1,X2,X3,X4)
    | esk2826_4(X1,X2,X3,X4) ) ).

cnf(i_0_6648,axiom,
    ( esk2255_4(X1,X2,X3,X4)
    | esk2200_4(X1,X2,X3,X4) ) ).

cnf(i_0_6649,axiom,
    ( esk4943_4(X1,X2,X3,X4)
    | esk4856_4(X1,X2,X3,X4) ) ).

cnf(i_0_6650,axiom,
    ( ~ esk1274_4(X1,X2,X3,X4)
    | ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1241_4(X1,X2,X3,X4) ) ).

cnf(i_0_6651,axiom,
    ( ~ esk16741_4(X1,X2,X3,X4)
    | ~ esk16776_4(X1,X2,X3,X4)
    | ~ esk16690_4(X1,X2,X3,X4) ) ).

cnf(i_0_6652,axiom,
    ( ~ esk9779_4(X1,X2,X3,X4)
    | ~ esk9688_4(X1,X2,X3,X4)
    | ~ esk9786_4(X1,X2,X3,X4) ) ).

cnf(i_0_6653,axiom,
    ( esk11995_4(X1,X2,X3,X4)
    | ~ esk11999_4(X1,X2,X3,X4) ) ).

cnf(i_0_6654,axiom,
    ( esk6603_4(X1,X2,X3,X4)
    | esk6623_4(X1,X2,X3,X4)
    | esk6569_4(X1,X2,X3,X4) ) ).

cnf(i_0_6655,axiom,
    ( esk12522_4(X1,X2,X3,X4)
    | ~ esk12591_4(X1,X2,X3,X4) ) ).

cnf(i_0_6656,axiom,
    ( ~ esk15845_4(X1,X2,X3,X4)
    | esk15833_4(X1,X2,X3,X4)
    | esk15844_4(X1,X2,X3,X4) ) ).

cnf(i_0_6657,axiom,
    ( ~ esk9429_4(X1,X2,X3,X4)
    | esk9425_4(X1,X2,X3,X4) ) ).

cnf(i_0_6658,axiom,
    ( ~ esk16618_4(X1,X2,X3,X4)
    | esk16617_4(X1,X2,X3,X4) ) ).

cnf(i_0_6659,axiom,
    ( ~ esk11463_4(X1,X2,X3,X4)
    | esk11205_4(X1,X2,X3,X4) ) ).

cnf(i_0_6660,axiom,
    ( esk16502_4(X1,X2,X3,X4)
    | ~ esk16474_4(X1,X2,X3,X4) ) ).

cnf(i_0_6661,axiom,
    ( ~ esk15805_4(X1,X2,X3,X4)
    | esk15786_4(X1,X2,X3,X4) ) ).

cnf(i_0_6662,axiom,
    ( ~ esk16697_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1)
    | p(X2)
    | p(X4)
    | esk183_0 ) ).

cnf(i_0_6663,axiom,
    ( esk9685_4(X1,X2,X3,X4)
    | ~ esk9427_4(X1,X2,X3,X4) ) ).

cnf(i_0_6664,axiom,
    ( esk4178_4(X1,X2,X3,X4)
    | esk4146_4(X1,X2,X3,X4) ) ).

cnf(i_0_6665,axiom,
    ( esk12912_4(X1,X2,X3,X4)
    | esk12797_4(X1,X2,X3,X4) ) ).

cnf(i_0_6666,axiom,
    ( esk8127_4(X1,X2,X3,X4)
    | esk8126_4(X1,X2,X3,X4)
    | esk8129_4(X1,X2,X3,X4)
    | esk8123_4(X1,X2,X3,X4) ) ).

cnf(i_0_6667,axiom,
    ( ~ esk1062_4(X1,X2,X3,X4)
    | esk1096_4(X1,X2,X3,X4) ) ).

cnf(i_0_6668,axiom,
    ( esk11538_4(X1,X2,X3,X4)
    | esk11625_4(X1,X2,X3,X4) ) ).

cnf(i_0_6669,axiom,
    ( esk8426_4(X1,X2,X3,X4)
    | esk8421_4(X1,X2,X3,X4) ) ).

cnf(i_0_6670,axiom,
    ( ~ esk9105_4(X1,X2,X3,X4)
    | esk9137_4(X1,X2,X3,X4) ) ).

cnf(i_0_6671,axiom,
    ( ~ esk15039_4(X1,X2,X3,X4)
    | esk15010_4(X1,X2,X3,X4) ) ).

cnf(i_0_6672,axiom,
    ( ~ esk3234_4(X1,X2,X3,X4)
    | ~ esk3204_4(X1,X2,X3,X4) ) ).

cnf(i_0_6673,axiom,
    ( esk15106_4(X1,X2,X3,X4)
    | esk15120_4(X1,X2,X3,X4) ) ).

cnf(i_0_6674,axiom,
    ( ~ esk5631_4(X1,X2,X3,X4)
    | ~ esk5598_4(X1,X2,X3,X4)
    | ~ esk5595_4(X1,X2,X3,X4) ) ).

cnf(i_0_6675,axiom,
    ( esk11277_4(X1,X2,X3,X4)
    | esk11236_4(X1,X2,X3,X4) ) ).

cnf(i_0_6676,axiom,
    ( esk15197_4(X1,X2,X3,X4)
    | esk15199_4(X1,X2,X3,X4)
    | esk15198_4(X1,X2,X3,X4) ) ).

cnf(i_0_6677,axiom,
    ( ~ esk4362_4(X1,X2,X3,X4)
    | ~ esk4401_4(X1,X2,X3,X4) ) ).

cnf(i_0_6678,axiom,
    ( esk11498_4(X1,X2,X3,X4)
    | esk11523_4(X1,X2,X3,X4) ) ).

cnf(i_0_6679,axiom,
    ( ~ esk9000_4(X1,X2,X3,X4)
    | esk9054_4(X1,X2,X3,X4) ) ).

cnf(i_0_6680,axiom,
    ( ~ esk7956_4(X1,X2,X3,X4)
    | esk7698_4(X1,X2,X3,X4) ) ).

cnf(i_0_6681,axiom,
    ( esk6184_4(X1,X2,X3,X4)
    | ~ esk6182_4(X1,X2,X3,X4) ) ).

cnf(i_0_6682,axiom,
    ( ~ esk12728_4(X1,X2,X3,X4)
    | esk12695_4(X1,X2,X3,X4) ) ).

cnf(i_0_6683,axiom,
    ( ~ esk6151_4(X1,X2,X3,X4)
    | ~ esk6206_4(X1,X2,X3,X4)
    | ~ esk6204_4(X1,X2,X3,X4)
    | ~ esk6153_4(X1,X2,X3,X4) ) ).

cnf(i_0_6684,axiom,
    ( ~ esk1864_4(X1,X2,X3,X4)
    | ~ esk1742_4(X1,X2,X3,X4)
    | ~ esk1752_4(X1,X2,X3,X4) ) ).

cnf(i_0_6685,axiom,
    ( ~ esk13610_4(X1,X2,X3,X4)
    | ~ esk13654_4(X1,X2,X3,X4)
    | ~ esk13655_4(X1,X2,X3,X4) ) ).

cnf(i_0_6686,axiom,
    ( esk12497_4(X1,X2,X3,X4)
    | esk12499_4(X1,X2,X3,X4) ) ).

cnf(i_0_6687,axiom,
    ( ~ esk4772_4(X1,X2,X3,X4)
    | esk4777_4(X1,X2,X3,X4) ) ).

cnf(i_0_6688,axiom,
    ( ~ esk6874_4(X1,X2,X3,X4)
    | esk6925_4(X1,X2,X3,X4) ) ).

cnf(i_0_6689,axiom,
    ( ~ esk2117_4(X1,X2,X3,X4)
    | esk2080_4(X1,X2,X3,X4)
    | esk2033_4(X1,X2,X3,X4) ) ).

cnf(i_0_6690,axiom,
    ( ~ p(X4)
    | p(X2)
    | esk216_0
    | ~ esk16701_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1) ) ).

cnf(i_0_6691,axiom,
    ( esk11368_4(X1,X2,X3,X4)
    | ~ esk11367_4(X1,X2,X3,X4)
    | ~ esk11366_4(X1,X2,X3,X4) ) ).

cnf(i_0_6692,axiom,
    ( esk1536_4(X1,X2,X3,X4)
    | ~ esk1794_4(X1,X2,X3,X4) ) ).

cnf(i_0_6693,axiom,
    ( ~ esk1947_4(X1,X2,X3,X4)
    | esk1950_4(X1,X2,X3,X4) ) ).

cnf(i_0_6694,axiom,
    ( ~ esk668_4(X1,X2,X3,X4)
    | esk926_4(X1,X2,X3,X4) ) ).

cnf(i_0_6695,axiom,
    ( esk4561_4(X1,X2,X3,X4)
    | esk4580_4(X1,X2,X3,X4) ) ).

cnf(i_0_6696,axiom,
    ( ~ esk16471_4(X1,X2,X3,X4)
    | ~ esk16479_4(X1,X2,X3,X4) ) ).

cnf(i_0_6697,axiom,
    ( ~ esk10412_4(X1,X2,X3,X4)
    | esk10534_4(X1,X2,X3,X4) ) ).

cnf(i_0_6698,axiom,
    ( esk15553_4(X1,X2,X3,X4)
    | ~ esk15524_4(X1,X2,X3,X4) ) ).

cnf(i_0_6699,axiom,
    ( ~ esk15076_4(X1,X2,X3,X4)
    | esk15075_4(X1,X2,X3,X4) ) ).

cnf(i_0_6700,axiom,
    ( ~ esk12323_4(X1,X2,X3,X4)
    | esk12065_4(X1,X2,X3,X4) ) ).

cnf(i_0_6701,axiom,
    ( ~ esk10093_4(X1,X2,X3,X4)
    | ~ esk10050_4(X1,X2,X3,X4)
    | ~ esk10024_4(X1,X2,X3,X4) ) ).

cnf(i_0_6702,axiom,
    ( ~ esk9411_4(X1,X2,X3,X4)
    | ~ esk9412_4(X1,X2,X3,X4) ) ).

cnf(i_0_6703,axiom,
    ( esk16413_4(X1,X2,X3,X4)
    | esk16378_4(X1,X2,X3,X4) ) ).

cnf(i_0_6704,axiom,
    ( ~ esk7672_4(X1,X2,X3,X4)
    | ~ esk7641_4(X1,X2,X3,X4)
    | ~ esk7673_4(X1,X2,X3,X4) ) ).

cnf(i_0_6705,axiom,
    ( esk14563_4(X1,X2,X3,X4)
    | esk14545_4(X1,X2,X3,X4) ) ).

cnf(i_0_6706,axiom,
    ( ~ esk1912_4(X1,X2,X3,X4)
    | esk1938_4(X1,X2,X3,X4) ) ).

cnf(i_0_6707,axiom,
    ( ~ esk2560_4(X1,X2,X3,X4)
    | esk2503_4(X1,X2,X3,X4) ) ).

cnf(i_0_6708,axiom,
    ( ~ esk9144_4(X1,X2,X3,X4)
    | ~ esk9094_4(X1,X2,X3,X4)
    | ~ esk9091_4(X1,X2,X3,X4)
    | ~ esk9092_4(X1,X2,X3,X4)
    | ~ esk9145_4(X1,X2,X3,X4) ) ).

cnf(i_0_6709,axiom,
    ( ~ esk3076_4(X1,X2,X3,X4)
    | esk3334_4(X1,X2,X3,X4) ) ).

cnf(i_0_6710,axiom,
    ( ~ esk14626_4(X1,X2,X3,X4)
    | ~ esk14673_4(X1,X2,X3,X4)
    | ~ esk14710_4(X1,X2,X3,X4) ) ).

cnf(i_0_6711,axiom,
    ( esk14169_4(X1,X2,X3,X4)
    | esk14201_4(X1,X2,X3,X4) ) ).

cnf(i_0_6712,axiom,
    ( ~ esk9464_4(X1,X2,X3,X4)
    | ~ esk9463_4(X1,X2,X3,X4)
    | ~ esk9444_4(X1,X2,X3,X4) ) ).

cnf(i_0_6713,axiom,
    ( ~ esk16738_4(X1,X2,X3,X4)
    | ~ esk16777_4(X1,X2,X3,X4) ) ).

cnf(i_0_6714,axiom,
    ( ~ esk14852_4(X1,X2,X3,X4)
    | ~ esk14845_4(X1,X2,X3,X4)
    | ~ esk14853_4(X1,X2,X3,X4) ) ).

cnf(i_0_6715,axiom,
    ( ~ esk1423_4(X1,X2,X3,X4)
    | esk1521_4(X1,X2,X3,X4) ) ).

cnf(i_0_6716,axiom,
    ( esk10789_4(X1,X2,X3,X4)
    | esk10756_4(X1,X2,X3,X4) ) ).

cnf(i_0_6717,axiom,
    ( esk6269_4(X1,X2,X3,X4)
    | ~ esk6304_4(X1,X2,X3,X4) ) ).

cnf(i_0_6718,axiom,
    ( ~ esk9577_4(X1,X2,X3,X4)
    | esk9543_4(X1,X2,X3,X4)
    | esk9496_4(X1,X2,X3,X4) ) ).

cnf(i_0_6719,axiom,
    ( esk2256_4(X1,X2,X3,X4)
    | esk2282_4(X1,X2,X3,X4) ) ).

cnf(i_0_6720,axiom,
    ( ~ esk7893_4(X1,X2,X3,X4)
    | esk7971_4(X1,X2,X3,X4) ) ).

cnf(i_0_6721,axiom,
    ( ~ esk13138_4(X1,X2,X3,X4)
    | ~ esk13152_4(X1,X2,X3,X4) ) ).

cnf(i_0_6722,axiom,
    ( ~ esk8495_4(X1,X2,X3,X4)
    | esk8497_4(X1,X2,X3,X4) ) ).

cnf(i_0_6723,axiom,
    ( esk11496_4(X1,X2,X3,X4)
    | esk11528_4(X1,X2,X3,X4) ) ).

cnf(i_0_6724,axiom,
    ( ~ esk11555_4(X1,X2,X3,X4)
    | esk11498_4(X1,X2,X3,X4) ) ).

cnf(i_0_6725,axiom,
    ( ~ esk11363_4(X1,X2,X3,X4)
    | ~ esk11362_4(X1,X2,X3,X4)
    | esk11364_4(X1,X2,X3,X4) ) ).

cnf(i_0_6726,axiom,
    ( ~ esk12924_4(X1,X2,X3,X4)
    | ~ esk12914_4(X1,X2,X3,X4) ) ).

cnf(i_0_6727,axiom,
    ( esk9497_4(X1,X2,X3,X4)
    | ~ esk9755_4(X1,X2,X3,X4) ) ).

cnf(i_0_6728,axiom,
    ( esk5687_4(X1,X2,X3,X4)
    | esk5643_4(X1,X2,X3,X4)
    | ~ esk5694_4(X1,X2,X3,X4) ) ).

cnf(i_0_6729,axiom,
    ( esk6064_4(X1,X2,X3,X4)
    | esk6073_4(X1,X2,X3,X4) ) ).

cnf(i_0_6730,axiom,
    ( esk3884_4(X1,X2,X3,X4)
    | ~ esk3883_4(X1,X2,X3,X4)
    | esk3905_4(X1,X2,X3,X4) ) ).

cnf(i_0_6731,axiom,
    ( ~ esk11040_4(X1,X2,X3,X4)
    | ~ esk11091_4(X1,X2,X3,X4)
    | ~ esk11084_4(X1,X2,X3,X4) ) ).

cnf(i_0_6732,axiom,
    ( esk9993_4(X1,X2,X3,X4)
    | esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_6733,axiom,
    ( esk9216_4(X1,X2,X3,X4)
    | esk9193_4(X1,X2,X3,X4) ) ).

cnf(i_0_6734,axiom,
    ( esk15564_4(X1,X2,X3,X4)
    | esk15618_4(X1,X2,X3,X4)
    | esk15598_4(X1,X2,X3,X4) ) ).

cnf(i_0_6735,axiom,
    ( ~ esk1840_4(X1,X2,X3,X4)
    | ~ esk1822_4(X1,X2,X3,X4) ) ).

cnf(i_0_6736,axiom,
    ( esk12226_4(X1,X2,X3,X4)
    | esk12344_4(X1,X2,X3,X4) ) ).

cnf(i_0_6737,axiom,
    ( esk9361_4(X1,X2,X3,X4)
    | ~ esk9380_4(X1,X2,X3,X4) ) ).

cnf(i_0_6738,axiom,
    ( ~ esk7011_4(X1,X2,X3,X4)
    | esk6982_4(X1,X2,X3,X4) ) ).

cnf(i_0_6739,axiom,
    ( ~ esk14389_4(X1,X2,X3,X4)
    | esk14131_4(X1,X2,X3,X4) ) ).

cnf(i_0_6740,axiom,
    ( esk15325_4(X1,X2,X3,X4)
    | esk15339_4(X1,X2,X3,X4) ) ).

cnf(i_0_6741,axiom,
    ( esk5113_4(X1,X2,X3,X4)
    | esk5200_4(X1,X2,X3,X4) ) ).

cnf(i_0_6742,axiom,
    ( esk5469_4(X1,X2,X3,X4)
    | esk5429_4(X1,X2,X3,X4)
    | esk5430_4(X1,X2,X3,X4)
    | esk5428_4(X1,X2,X3,X4) ) ).

cnf(i_0_6743,axiom,
    ( ~ esk550_4(X1,X2,X3,X4)
    | esk499_4(X1,X2,X3,X4)
    | esk579_4(X1,X2,X3,X4) ) ).

cnf(i_0_6744,axiom,
    ( esk7995_4(X1,X2,X3,X4)
    | esk7964_4(X1,X2,X3,X4) ) ).

cnf(i_0_6745,axiom,
    ( esk13132_4(X1,X2,X3,X4)
    | esk13112_4(X1,X2,X3,X4) ) ).

cnf(i_0_6746,axiom,
    ( ~ esk13563_4(X1,X2,X3,X4)
    | ~ esk13508_4(X1,X2,X3,X4) ) ).

cnf(i_0_6747,axiom,
    ( esk16443_4(X1,X2,X3,X4)
    | esk16410_4(X1,X2,X3,X4) ) ).

cnf(i_0_6748,axiom,
    ( esk13512_4(X1,X2,X3,X4)
    | ~ esk13504_4(X1,X2,X3,X4) ) ).

cnf(i_0_6749,axiom,
    ( esk1774_4(X1,X2,X3,X4)
    | esk1724_4(X1,X2,X3,X4) ) ).

cnf(i_0_6750,axiom,
    ( esk9431_4(X1,X2,X3,X4)
    | ~ esk9379_4(X1,X2,X3,X4) ) ).

cnf(i_0_6751,axiom,
    ( esk8504_4(X1,X2,X3,X4)
    | esk8522_4(X1,X2,X3,X4) ) ).

cnf(i_0_6752,axiom,
    ( ~ esk1079_4(X1,X2,X3,X4)
    | ~ esk1101_4(X1,X2,X3,X4) ) ).

cnf(i_0_6753,axiom,
    ( esk12494_4(X1,X2,X3,X4)
    | esk12495_4(X1,X2,X3,X4) ) ).

cnf(i_0_6754,axiom,
    ( esk3115_4(X1,X2,X3,X4)
    | esk3114_4(X1,X2,X3,X4) ) ).

cnf(i_0_6755,axiom,
    ( esk15896_4(X1,X2,X3,X4)
    | esk15875_4(X1,X2,X3,X4) ) ).

cnf(i_0_6756,axiom,
    ( ~ esk6069_4(X1,X2,X3,X4)
    | ~ esk6070_4(X1,X2,X3,X4) ) ).

cnf(i_0_6757,axiom,
    ( esk15879_4(X1,X2,X3,X4)
    | esk15874_4(X1,X2,X3,X4) ) ).

cnf(i_0_6758,axiom,
    ( ~ esk16225_4(X1,X2,X3,X4)
    | esk16259_4(X1,X2,X3,X4) ) ).

cnf(i_0_6759,axiom,
    ( ~ esk5129_4(X1,X2,X3,X4)
    | esk4871_4(X1,X2,X3,X4) ) ).

cnf(i_0_6760,axiom,
    ( ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1172_4(X1,X2,X3,X4) ) ).

cnf(i_0_6761,axiom,
    ( esk4863_4(X1,X2,X3,X4)
    | ~ esk5121_4(X1,X2,X3,X4) ) ).

cnf(i_0_6762,axiom,
    ( ~ esk11228_4(X1,X2,X3,X4)
    | ~ esk11227_4(X1,X2,X3,X4) ) ).

cnf(i_0_6763,axiom,
    ( ~ esk5867_4(X1,X2,X3,X4)
    | ~ esk5852_4(X1,X2,X3,X4)
    | ~ esk5900_4(X1,X2,X3,X4) ) ).

cnf(i_0_6764,axiom,
    ( esk3127_4(X1,X2,X3,X4)
    | ~ esk3107_4(X1,X2,X3,X4) ) ).

cnf(i_0_6765,axiom,
    ( ~ esk3147_4(X1,X2,X3,X4)
    | esk3122_4(X1,X2,X3,X4)
    | esk3121_4(X1,X2,X3,X4) ) ).

cnf(i_0_6766,axiom,
    ( ~ esk9271_4(X1,X2,X3,X4)
    | esk9529_4(X1,X2,X3,X4) ) ).

cnf(i_0_6767,axiom,
    ( esk11732_4(X1,X2,X3,X4)
    | esk11727_4(X1,X2,X3,X4) ) ).

cnf(i_0_6768,axiom,
    ( ~ esk16679_4(X1,X2,X3,X4)
    | ~ esk16680_4(X1,X2,X3,X4)
    | ~ esk16630_4(X1,X2,X3,X4) ) ).

cnf(i_0_6769,axiom,
    ( esk7709_4(X1,X2,X3,X4)
    | esk7676_4(X1,X2,X3,X4) ) ).

cnf(i_0_6770,axiom,
    ( esk12335_4(X1,X2,X3,X4)
    | esk12302_4(X1,X2,X3,X4) ) ).

cnf(i_0_6771,axiom,
    ( esk7944_4(X1,X2,X3,X4)
    | ~ esk7686_4(X1,X2,X3,X4) ) ).

cnf(i_0_6772,axiom,
    ( ~ esk6335_4(X1,X2,X3,X4)
    | ~ esk6330_4(X1,X2,X3,X4) ) ).

cnf(i_0_6773,axiom,
    ( esk9001_4(X1,X2,X3,X4)
    | ~ esk8920_4(X1,X2,X3,X4) ) ).

cnf(i_0_6774,axiom,
    ( esk16165_4(X1,X2,X3,X4)
    | esk16132_4(X1,X2,X3,X4) ) ).

cnf(i_0_6775,axiom,
    ( esk4605_4(X1,X2,X3,X4)
    | ~ esk4507_4(X1,X2,X3,X4) ) ).

cnf(i_0_6776,axiom,
    ( p(X1)
    | ~ esk433_4(X1,X2,X3,X4)
    | p(X3)
    | esk48_0
    | p(X2)
    | ~ p(X4) ) ).

cnf(i_0_6777,axiom,
    ( esk495_4(X1,X2,X3,X4)
    | esk551_4(X1,X2,X3,X4) ) ).

cnf(i_0_6778,axiom,
    ( ~ esk8096_4(X1,X2,X3,X4)
    | esk8075_4(X1,X2,X3,X4) ) ).

cnf(i_0_6779,axiom,
    ( esk7365_4(X1,X2,X3,X4)
    | ~ esk7358_4(X1,X2,X3,X4) ) ).

cnf(i_0_6780,axiom,
    ( esk12790_4(X1,X2,X3,X4)
    | esk12795_4(X1,X2,X3,X4) ) ).

cnf(i_0_6781,axiom,
    ( ~ esk14936_4(X1,X2,X3,X4)
    | ~ esk14901_4(X1,X2,X3,X4)
    | ~ esk14937_4(X1,X2,X3,X4) ) ).

cnf(i_0_6782,axiom,
    ( esk12359_4(X1,X2,X3,X4)
    | esk12368_4(X1,X2,X3,X4)
    | esk12367_4(X1,X2,X3,X4) ) ).

cnf(i_0_6783,axiom,
    ( esk6267_4(X1,X2,X3,X4)
    | esk6317_4(X1,X2,X3,X4) ) ).

cnf(i_0_6784,axiom,
    ( esk11990_4(X1,X2,X3,X4)
    | ~ esk11989_4(X1,X2,X3,X4) ) ).

cnf(i_0_6785,axiom,
    ( esk2980_4(X1,X2,X3,X4)
    | esk2998_4(X1,X2,X3,X4) ) ).

cnf(i_0_6786,axiom,
    ( ~ esk10930_4(X1,X2,X3,X4)
    | esk11056_4(X1,X2,X3,X4) ) ).

cnf(i_0_6787,axiom,
    ( ~ esk13020_4(X1,X2,X3,X4)
    | esk13019_4(X1,X2,X3,X4) ) ).

cnf(i_0_6788,axiom,
    ( ~ esk3403_4(X1,X2,X3,X4)
    | ~ esk3320_4(X1,X2,X3,X4)
    | ~ esk3380_4(X1,X2,X3,X4) ) ).

cnf(i_0_6789,axiom,
    ( esk6389_4(X1,X2,X3,X4)
    | esk6366_4(X1,X2,X3,X4) ) ).

cnf(i_0_6790,axiom,
    ( ~ esk14966_4(X1,X2,X3,X4)
    | esk14965_4(X1,X2,X3,X4) ) ).

cnf(i_0_6791,axiom,
    ( ~ esk531_4(X1,X2,X3,X4)
    | esk404_4(X1,X2,X3,X4)
    | esk374_4(X1,X2,X3,X4) ) ).

cnf(i_0_6792,axiom,
    ( ~ esk7362_4(X1,X2,X3,X4)
    | esk7360_4(X1,X2,X3,X4) ) ).

cnf(i_0_6793,axiom,
    ( esk705_4(X1,X2,X3,X4)
    | esk728_4(X1,X2,X3,X4) ) ).

cnf(i_0_6794,axiom,
    ( ~ esk15089_4(X1,X2,X3,X4)
    | esk15167_4(X1,X2,X3,X4) ) ).

cnf(i_0_6795,axiom,
    ( esk7848_4(X1,X2,X3,X4)
    | ~ esk7824_4(X1,X2,X3,X4) ) ).

cnf(i_0_6796,axiom,
    ( esk1209_4(X1,X2,X3,X4)
    | esk1208_4(X1,X2,X3,X4)
    | esk1305_4(X1,X2,X3,X4) ) ).

cnf(i_0_6797,axiom,
    ( ~ esk13495_4(X1,X2,X3,X4)
    | esk13616_4(X1,X2,X3,X4) ) ).

cnf(i_0_6798,axiom,
    ( esk7420_4(X1,X2,X3,X4)
    | esk7526_4(X1,X2,X3,X4) ) ).

cnf(i_0_6799,axiom,
    ( ~ esk13729_4(X1,X2,X3,X4)
    | esk13750_4(X1,X2,X3,X4) ) ).

cnf(i_0_6800,axiom,
    ( ~ esk3543_4(X1,X2,X3,X4)
    | ~ esk3538_4(X1,X2,X3,X4)
    | ~ esk3542_4(X1,X2,X3,X4) ) ).

cnf(i_0_6801,axiom,
    ( esk3046_4(X1,X2,X3,X4)
    | esk3025_4(X1,X2,X3,X4) ) ).

cnf(i_0_6802,axiom,
    ( esk7619_4(X1,X2,X3,X4)
    | ~ esk7617_4(X1,X2,X3,X4)
    | ~ esk7618_4(X1,X2,X3,X4) ) ).

cnf(i_0_6803,axiom,
    ( esk10437_4(X1,X2,X3,X4)
    | ~ esk10446_4(X1,X2,X3,X4) ) ).

cnf(i_0_6804,axiom,
    ( ~ esk15228_4(X1,X2,X3,X4)
    | ~ esk15106_4(X1,X2,X3,X4)
    | ~ esk15116_4(X1,X2,X3,X4) ) ).

cnf(i_0_6805,axiom,
    ( esk15416_4(X1,X2,X3,X4)
    | ~ esk15674_4(X1,X2,X3,X4) ) ).

cnf(i_0_6806,axiom,
    ( ~ esk11570_4(X1,X2,X3,X4)
    | ~ esk11622_4(X1,X2,X3,X4) ) ).

cnf(i_0_6807,axiom,
    ( esk7093_4(X1,X2,X3,X4)
    | ~ esk7109_4(X1,X2,X3,X4) ) ).

cnf(i_0_6808,axiom,
    ( ~ esk7630_4(X1,X2,X3,X4)
    | esk7626_4(X1,X2,X3,X4) ) ).

cnf(i_0_6809,axiom,
    ( ~ esk6404_4(X1,X2,X3,X4)
    | esk6146_4(X1,X2,X3,X4) ) ).

cnf(i_0_6810,axiom,
    ( esk15236_4(X1,X2,X3,X4)
    | esk15214_4(X1,X2,X3,X4) ) ).

cnf(i_0_6811,axiom,
    ( ~ esk12977_4(X1,X2,X3,X4)
    | esk13029_4(X1,X2,X3,X4) ) ).

cnf(i_0_6812,axiom,
    ( ~ esk412_4(X1,X2,X3,X4)
    | esk426_4(X1,X2,X3,X4) ) ).

cnf(i_0_6813,axiom,
    ( ~ esk9376_4(X1,X2,X3,X4)
    | esk9400_4(X1,X2,X3,X4)
    | ~ esk9403_4(X1,X2,X3,X4) ) ).

cnf(i_0_6814,axiom,
    ( ~ esk4240_4(X1,X2,X3,X4)
    | esk4260_4(X1,X2,X3,X4) ) ).

cnf(i_0_6815,axiom,
    ( ~ esk2310_4(X1,X2,X3,X4)
    | esk2052_4(X1,X2,X3,X4) ) ).

cnf(i_0_6816,axiom,
    ( ~ esk585_4(X1,X2,X3,X4)
    | esk497_4(X1,X2,X3,X4)
    | esk578_4(X1,X2,X3,X4) ) ).

cnf(i_0_6817,axiom,
    ( ~ esk16060_4(X1,X2,X3,X4)
    | esk16080_4(X1,X2,X3,X4) ) ).

cnf(i_0_6818,axiom,
    ( ~ esk14455_4(X1,X2,X3,X4)
    | ~ esk14430_4(X1,X2,X3,X4)
    | ~ esk14429_4(X1,X2,X3,X4) ) ).

cnf(i_0_6819,axiom,
    ( esk4057_4(X1,X2,X3,X4)
    | esk4173_4(X1,X2,X3,X4) ) ).

cnf(i_0_6820,axiom,
    ( p(X2)
    | ~ esk511_4(X1,X2,X3,X4)
    | p(X1)
    | esk214_0
    | ~ p(X3)
    | p(X4) ) ).

cnf(i_0_6821,axiom,
    ( ~ esk9018_4(X1,X2,X3,X4)
    | ~ esk9026_4(X1,X2,X3,X4) ) ).

cnf(i_0_6822,axiom,
    ( esk13064_4(X1,X2,X3,X4)
    | esk13147_4(X1,X2,X3,X4) ) ).

cnf(i_0_6823,axiom,
    ( esk16113_4(X1,X2,X3,X4)
    | esk16204_4(X1,X2,X3,X4) ) ).

cnf(i_0_6824,axiom,
    ( esk4673_4(X1,X2,X3,X4)
    | ~ esk4619_4(X1,X2,X3,X4) ) ).

cnf(i_0_6825,axiom,
    ( ~ esk12321_4(X1,X2,X3,X4)
    | esk12063_4(X1,X2,X3,X4) ) ).

cnf(i_0_6826,axiom,
    ( ~ esk8229_4(X1,X2,X3,X4)
    | ~ esk8281_4(X1,X2,X3,X4) ) ).

cnf(i_0_6827,axiom,
    ( esk7629_4(X1,X2,X3,X4)
    | ~ esk7371_4(X1,X2,X3,X4) ) ).

cnf(i_0_6828,axiom,
    ( ~ esk16174_4(X1,X2,X3,X4)
    | esk16255_4(X1,X2,X3,X4)
    | esk16262_4(X1,X2,X3,X4) ) ).

cnf(i_0_6829,axiom,
    ( ~ p(X1)
    | ~ p(X4)
    | esk16699_4(X1,X2,X3,X4)
    | ~ p(X2)
    | p(X3)
    | ~ esk211_0 ) ).

cnf(i_0_6830,axiom,
    ( esk8040_4(X1,X2,X3,X4)
    | esk7934_4(X1,X2,X3,X4) ) ).

cnf(i_0_6831,axiom,
    ( ~ esk2326_4(X1,X2,X3,X4)
    | esk2068_4(X1,X2,X3,X4) ) ).

cnf(i_0_6832,axiom,
    ( esk15409_4(X1,X2,X3,X4)
    | esk15454_4(X1,X2,X3,X4) ) ).

cnf(i_0_6833,axiom,
    ( esk14395_4(X1,X2,X3,X4)
    | ~ esk14270_4(X1,X2,X3,X4) ) ).

cnf(i_0_6834,axiom,
    ( esk9459_4(X1,X2,X3,X4)
    | esk9446_4(X1,X2,X3,X4) ) ).

cnf(i_0_6835,axiom,
    ( esk10943_4(X1,X2,X3,X4)
    | esk10945_4(X1,X2,X3,X4) ) ).

cnf(i_0_6836,axiom,
    ( ~ esk3494_4(X1,X2,X3,X4)
    | ~ esk3512_4(X1,X2,X3,X4) ) ).

cnf(i_0_6837,axiom,
    ( esk3452_4(X1,X2,X3,X4)
    | ~ esk3482_4(X1,X2,X3,X4) ) ).

cnf(i_0_6838,axiom,
    ( ~ esk2936_4(X1,X2,X3,X4)
    | esk2955_4(X1,X2,X3,X4) ) ).

cnf(i_0_6839,axiom,
    ( ~ esk2688_4(X1,X2,X3,X4)
    | esk2750_4(X1,X2,X3,X4) ) ).

cnf(i_0_6840,axiom,
    ( esk10582_4(X1,X2,X3,X4)
    | esk10568_4(X1,X2,X3,X4) ) ).

cnf(i_0_6841,axiom,
    ( esk3799_4(X1,X2,X3,X4)
    | esk3832_4(X1,X2,X3,X4) ) ).

cnf(i_0_6842,axiom,
    ( ~ esk672_4(X1,X2,X3,X4)
    | esk678_4(X1,X2,X3,X4) ) ).

cnf(i_0_6843,axiom,
    ( esk1898_4(X1,X2,X3,X4)
    | esk1948_4(X1,X2,X3,X4) ) ).

cnf(i_0_6844,axiom,
    ( esk7358_4(X1,X2,X3,X4)
    | esk7363_4(X1,X2,X3,X4) ) ).

cnf(i_0_6845,axiom,
    ( esk13591_4(X1,X2,X3,X4)
    | esk13624_4(X1,X2,X3,X4) ) ).

cnf(i_0_6846,axiom,
    ( esk11726_4(X1,X2,X3,X4)
    | esk11728_4(X1,X2,X3,X4) ) ).

cnf(i_0_6847,axiom,
    ( esk3627_4(X1,X2,X3,X4)
    | esk3599_4(X1,X2,X3,X4) ) ).

cnf(i_0_6848,axiom,
    ( esk1755_4(X1,X2,X3,X4)
    | esk1788_4(X1,X2,X3,X4) ) ).

cnf(i_0_6849,axiom,
    ( esk7481_4(X1,X2,X3,X4)
    | esk7450_4(X1,X2,X3,X4) ) ).

cnf(i_0_6850,axiom,
    ( esk2364_4(X1,X2,X3,X4)
    | esk2383_4(X1,X2,X3,X4)
    | ~ esk2312_4(X1,X2,X3,X4) ) ).

cnf(i_0_6851,axiom,
    ( ~ esk12498_4(X1,X2,X3,X4)
    | ~ esk12503_4(X1,X2,X3,X4) ) ).

cnf(i_0_6852,axiom,
    ( esk10433_4(X1,X2,X3,X4)
    | ~ esk10175_4(X1,X2,X3,X4) ) ).

cnf(i_0_6853,axiom,
    ( esk15620_4(X1,X2,X3,X4)
    | esk15626_4(X1,X2,X3,X4) ) ).

cnf(i_0_6854,axiom,
    ( ~ esk3318_4(X1,X2,X3,X4)
    | ~ esk3285_4(X1,X2,X3,X4)
    | ~ esk3282_4(X1,X2,X3,X4) ) ).

cnf(i_0_6855,axiom,
    ( ~ esk714_4(X1,X2,X3,X4)
    | ~ esk820_4(X1,X2,X3,X4)
    | ~ esk734_4(X1,X2,X3,X4) ) ).

cnf(i_0_6856,axiom,
    ( esk457_4(X1,X2,X3,X4)
    | esk487_4(X1,X2,X3,X4) ) ).

cnf(i_0_6857,axiom,
    ( ~ esk12886_4(X1,X2,X3,X4)
    | ~ esk12885_4(X1,X2,X3,X4) ) ).

cnf(i_0_6858,axiom,
    ( esk13533_4(X1,X2,X3,X4)
    | ~ esk13519_4(X1,X2,X3,X4) ) ).

cnf(i_0_6859,axiom,
    ( esk14419_4(X1,X2,X3,X4)
    | esk14462_4(X1,X2,X3,X4) ) ).

cnf(i_0_6860,axiom,
    ( ~ esk16226_4(X1,X2,X3,X4)
    | ~ esk16178_4(X1,X2,X3,X4) ) ).

cnf(i_0_6861,axiom,
    ( ~ p(X2)
    | ~ esk515_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X4)
    | esk249_0
    | ~ p(X3) ) ).

cnf(i_0_6862,axiom,
    ( esk11504_4(X1,X2,X3,X4)
    | esk11512_4(X1,X2,X3,X4) ) ).

cnf(i_0_6863,axiom,
    ( ~ esk14576_4(X1,X2,X3,X4)
    | esk14651_4(X1,X2,X3,X4) ) ).

cnf(i_0_6864,axiom,
    ( ~ esk8550_4(X1,X2,X3,X4)
    | esk8549_4(X1,X2,X3,X4) ) ).

cnf(i_0_6865,axiom,
    ( esk954_4(X1,X2,X3,X4)
    | esk1001_4(X1,X2,X3,X4) ) ).

cnf(i_0_6866,axiom,
    ( ~ esk13791_4(X1,X2,X3,X4)
    | esk13789_4(X1,X2,X3,X4) ) ).

cnf(i_0_6867,axiom,
    ( esk12303_4(X1,X2,X3,X4)
    | esk12409_4(X1,X2,X3,X4) ) ).

cnf(i_0_6868,axiom,
    ( ~ esk13273_4(X1,X2,X3,X4)
    | esk13271_4(X1,X2,X3,X4) ) ).

cnf(i_0_6869,axiom,
    ( ~ esk11751_4(X1,X2,X3,X4)
    | esk11820_4(X1,X2,X3,X4) ) ).

cnf(i_0_6870,axiom,
    ( ~ esk7232_4(X1,X2,X3,X4)
    | ~ esk7231_4(X1,X2,X3,X4) ) ).

cnf(i_0_6871,axiom,
    ( esk4920_4(X1,X2,X3,X4)
    | esk4864_4(X1,X2,X3,X4) ) ).

cnf(i_0_6872,axiom,
    ( ~ esk5340_4(X1,X2,X3,X4)
    | ~ esk5350_4(X1,X2,X3,X4)
    | ~ esk5462_4(X1,X2,X3,X4) ) ).

cnf(i_0_6873,axiom,
    ( esk13345_4(X1,X2,X3,X4)
    | esk13312_4(X1,X2,X3,X4) ) ).

cnf(i_0_6874,axiom,
    ( p(X1)
    | p(X3)
    | esk246_0
    | ~ p(X2)
    | ~ esk515_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_6875,axiom,
    ( esk14331_4(X1,X2,X3,X4)
    | esk14338_4(X1,X2,X3,X4) ) ).

cnf(i_0_6876,axiom,
    ( ~ esk10837_4(X1,X2,X3,X4)
    | esk10817_4(X1,X2,X3,X4)
    | esk10866_4(X1,X2,X3,X4) ) ).

cnf(i_0_6877,axiom,
    ( ~ esk8427_4(X1,X2,X3,X4)
    | ~ esk8422_4(X1,X2,X3,X4)
    | ~ esk8460_4(X1,X2,X3,X4) ) ).

cnf(i_0_6878,axiom,
    ( esk10800_4(X1,X2,X3,X4)
    | ~ esk10719_4(X1,X2,X3,X4) ) ).

cnf(i_0_6879,axiom,
    ( esk10559_4(X1,X2,X3,X4)
    | esk10512_4(X1,X2,X3,X4) ) ).

cnf(i_0_6880,axiom,
    ( esk6430_4(X1,X2,X3,X4)
    | esk6450_4(X1,X2,X3,X4) ) ).

cnf(i_0_6881,axiom,
    ( esk3860_4(X1,X2,X3,X4)
    | ~ esk3734_4(X1,X2,X3,X4) ) ).

cnf(i_0_6882,axiom,
    ( ~ esk15428_4(X1,X2,X3,X4)
    | ~ esk15310_4(X1,X2,X3,X4) ) ).

cnf(i_0_6883,axiom,
    ( esk13396_4(X1,X2,X3,X4)
    | esk13357_4(X1,X2,X3,X4) ) ).

cnf(i_0_6884,axiom,
    ( esk2204_4(X1,X2,X3,X4)
    | ~ esk2186_4(X1,X2,X3,X4) ) ).

cnf(i_0_6885,axiom,
    ( ~ esk1573_4(X1,X2,X3,X4)
    | ~ esk1572_4(X1,X2,X3,X4)
    | ~ esk1537_4(X1,X2,X3,X4) ) ).

cnf(i_0_6886,axiom,
    ( esk5906_4(X1,X2,X3,X4)
    | ~ esk5648_4(X1,X2,X3,X4) ) ).

cnf(i_0_6887,axiom,
    ( p(X4)
    | p(X1)
    | ~ p(X3)
    | ~ p(X2)
    | esk174_0
    | ~ esk16695_4(X1,X2,X3,X4) ) ).

cnf(i_0_6888,axiom,
    ( esk2551_4(X1,X2,X3,X4)
    | ~ esk2452_4(X1,X2,X3,X4) ) ).

cnf(i_0_6889,axiom,
    ( esk7865_4(X1,X2,X3,X4)
    | ~ esk7607_4(X1,X2,X3,X4) ) ).

cnf(i_0_6890,axiom,
    ( esk13545_4(X1,X2,X3,X4)
    | esk13634_4(X1,X2,X3,X4) ) ).

cnf(i_0_6891,axiom,
    ( esk720_4(X1,X2,X3,X4)
    | esk714_4(X1,X2,X3,X4) ) ).

cnf(i_0_6892,axiom,
    ( ~ esk12750_4(X1,X2,X3,X4)
    | esk13008_4(X1,X2,X3,X4) ) ).

cnf(i_0_6893,axiom,
    ( ~ esk13127_4(X1,X2,X3,X4)
    | ~ esk13128_4(X1,X2,X3,X4) ) ).

cnf(i_0_6894,axiom,
    ( ~ esk8224_4(X1,X2,X3,X4)
    | esk8152_4(X1,X2,X3,X4) ) ).

cnf(i_0_6895,axiom,
    ( esk15147_4(X1,X2,X3,X4)
    | ~ esk15099_4(X1,X2,X3,X4) ) ).

cnf(i_0_6896,axiom,
    ( esk11089_4(X1,X2,X3,X4)
    | esk11087_4(X1,X2,X3,X4) ) ).

cnf(i_0_6897,axiom,
    ( ~ esk13043_4(X1,X2,X3,X4)
    | esk13091_4(X1,X2,X3,X4) ) ).

cnf(i_0_6898,axiom,
    ( esk1033_4(X1,X2,X3,X4)
    | ~ esk775_4(X1,X2,X3,X4) ) ).

cnf(i_0_6899,axiom,
    ( esk2034_4(X1,X2,X3,X4)
    | ~ esk2292_4(X1,X2,X3,X4) ) ).

cnf(i_0_6900,axiom,
    ( esk13671_4(X1,X2,X3,X4)
    | esk13650_4(X1,X2,X3,X4)
    | ~ esk13649_4(X1,X2,X3,X4) ) ).

cnf(i_0_6901,axiom,
    ( esk9714_4(X1,X2,X3,X4)
    | esk9707_4(X1,X2,X3,X4) ) ).

cnf(i_0_6902,axiom,
    ( esk15918_4(X1,X2,X3,X4)
    | ~ esk16176_4(X1,X2,X3,X4) ) ).

cnf(i_0_6903,axiom,
    ( esk15480_4(X1,X2,X3,X4)
    | ~ esk15478_4(X1,X2,X3,X4)
    | ~ esk15479_4(X1,X2,X3,X4) ) ).

cnf(i_0_6904,axiom,
    ( esk9000_4(X1,X2,X3,X4)
    | esk8967_4(X1,X2,X3,X4) ) ).

cnf(i_0_6905,axiom,
    ( esk11461_4(X1,X2,X3,X4)
    | esk11470_4(X1,X2,X3,X4) ) ).

cnf(i_0_6906,axiom,
    ( esk6153_4(X1,X2,X3,X4)
    | esk6120_4(X1,X2,X3,X4) ) ).

cnf(i_0_6907,axiom,
    ( esk8990_4(X1,X2,X3,X4)
    | ~ esk8869_4(X1,X2,X3,X4) ) ).

cnf(i_0_6908,axiom,
    ( esk2627_4(X1,X2,X3,X4)
    | esk2577_4(X1,X2,X3,X4)
    | ~ esk2628_4(X1,X2,X3,X4) ) ).

cnf(i_0_6909,axiom,
    ( ~ esk5896_4(X1,X2,X3,X4)
    | ~ esk5947_4(X1,X2,X3,X4)
    | ~ esk5982_4(X1,X2,X3,X4) ) ).

cnf(i_0_6910,axiom,
    ( esk5070_4(X1,X2,X3,X4)
    | esk5104_4(X1,X2,X3,X4) ) ).

cnf(i_0_6911,axiom,
    ( esk6456_4(X1,X2,X3,X4)
    | esk6457_4(X1,X2,X3,X4)
    | esk6448_4(X1,X2,X3,X4) ) ).

cnf(i_0_6912,axiom,
    ( ~ esk7851_4(X1,X2,X3,X4)
    | esk7821_4(X1,X2,X3,X4) ) ).

cnf(i_0_6913,axiom,
    ( esk11798_4(X1,X2,X3,X4)
    | ~ esk11762_4(X1,X2,X3,X4) ) ).

cnf(i_0_6914,axiom,
    ( ~ esk15202_4(X1,X2,X3,X4)
    | ~ esk15201_4(X1,X2,X3,X4) ) ).

cnf(i_0_6915,axiom,
    ( ~ p(X3)
    | p(X2)
    | ~ esk260_0
    | esk517_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X1) ) ).

cnf(i_0_6916,axiom,
    ( esk14644_4(X1,X2,X3,X4)
    | ~ esk14386_4(X1,X2,X3,X4) ) ).

cnf(i_0_6917,axiom,
    ( esk3996_4(X1,X2,X3,X4)
    | ~ esk3966_4(X1,X2,X3,X4) ) ).

cnf(i_0_6918,axiom,
    ( esk5368_4(X1,X2,X3,X4)
    | esk5324_4(X1,X2,X3,X4) ) ).

cnf(i_0_6919,axiom,
    ( esk7185_4(X1,X2,X3,X4)
    | ~ esk7067_4(X1,X2,X3,X4) ) ).

cnf(i_0_6920,axiom,
    ( ~ esk16414_4(X1,X2,X3,X4)
    | ~ esk16415_4(X1,X2,X3,X4)
    | ~ esk16377_4(X1,X2,X3,X4) ) ).

cnf(i_0_6921,axiom,
    ( esk2158_4(X1,X2,X3,X4)
    | ~ esk2191_4(X1,X2,X3,X4) ) ).

cnf(i_0_6922,axiom,
    ( esk15824_4(X1,X2,X3,X4)
    | esk15794_4(X1,X2,X3,X4)
    | ~ esk15951_4(X1,X2,X3,X4) ) ).

cnf(i_0_6923,axiom,
    ( esk2558_4(X1,X2,X3,X4)
    | ~ esk2816_4(X1,X2,X3,X4) ) ).

cnf(i_0_6924,axiom,
    ( ~ esk8354_4(X1,X2,X3,X4)
    | esk8331_4(X1,X2,X3,X4) ) ).

cnf(i_0_6925,axiom,
    ( ~ esk2805_4(X1,X2,X3,X4)
    | esk3063_4(X1,X2,X3,X4) ) ).

cnf(i_0_6926,axiom,
    ( esk9548_4(X1,X2,X3,X4)
    | ~ esk9533_4(X1,X2,X3,X4) ) ).

cnf(i_0_6927,axiom,
    ( esk5034_4(X1,X2,X3,X4)
    | ~ esk5029_4(X1,X2,X3,X4) ) ).

cnf(i_0_6928,axiom,
    ( ~ esk5033_4(X1,X2,X3,X4)
    | ~ esk5006_4(X1,X2,X3,X4) ) ).

cnf(i_0_6929,axiom,
    ( ~ esk2707_4(X1,X2,X3,X4)
    | esk2804_4(X1,X2,X3,X4) ) ).

cnf(i_0_6930,axiom,
    ( ~ esk6736_4(X1,X2,X3,X4)
    | esk6735_4(X1,X2,X3,X4)
    | esk6708_4(X1,X2,X3,X4) ) ).

cnf(i_0_6931,axiom,
    ( esk4352_4(X1,X2,X3,X4)
    | ~ esk4094_4(X1,X2,X3,X4) ) ).

cnf(i_0_6932,axiom,
    ( ~ esk14884_4(X1,X2,X3,X4)
    | esk14845_4(X1,X2,X3,X4) ) ).

cnf(i_0_6933,axiom,
    ( esk9971_4(X1,X2,X3,X4)
    | esk9961_4(X1,X2,X3,X4) ) ).

cnf(i_0_6934,axiom,
    ( esk1735_4(X1,X2,X3,X4)
    | esk1752_4(X1,X2,X3,X4) ) ).

cnf(i_0_6935,axiom,
    ( ~ esk3855_4(X1,X2,X3,X4)
    | esk3783_4(X1,X2,X3,X4) ) ).

cnf(i_0_6936,axiom,
    ( ~ esk15322_4(X1,X2,X3,X4)
    | ~ esk15321_4(X1,X2,X3,X4) ) ).

cnf(i_0_6937,axiom,
    ( ~ esk7344_4(X1,X2,X3,X4)
    | esk7324_4(X1,X2,X3,X4)
    | ~ esk7442_4(X1,X2,X3,X4) ) ).

cnf(i_0_6938,axiom,
    ( esk16677_4(X1,X2,X3,X4)
    | esk16631_4(X1,X2,X3,X4) ) ).

cnf(i_0_6939,axiom,
    ( ~ esk8498_4(X1,X2,X3,X4)
    | esk8371_4(X1,X2,X3,X4)
    | esk8341_4(X1,X2,X3,X4) ) ).

cnf(i_0_6940,axiom,
    ( ~ esk4408_4(X1,X2,X3,X4)
    | ~ esk4407_4(X1,X2,X3,X4) ) ).

cnf(i_0_6941,axiom,
    ( esk3604_4(X1,X2,X3,X4)
    | ~ esk3862_4(X1,X2,X3,X4) ) ).

cnf(i_0_6942,axiom,
    ( esk5148_4(X1,X2,X3,X4)
    | esk5030_4(X1,X2,X3,X4) ) ).

cnf(i_0_6943,axiom,
    ( esk9966_4(X1,X2,X3,X4)
    | esk9996_4(X1,X2,X3,X4) ) ).

cnf(i_0_6944,axiom,
    ( ~ esk4621_4(X1,X2,X3,X4)
    | ~ esk4675_4(X1,X2,X3,X4)
    | ~ esk4656_4(X1,X2,X3,X4) ) ).

cnf(i_0_6945,axiom,
    ( esk2280_4(X1,X2,X3,X4)
    | esk2386_4(X1,X2,X3,X4) ) ).

cnf(i_0_6946,axiom,
    ( esk15648_4(X1,X2,X3,X4)
    | esk15733_4(X1,X2,X3,X4) ) ).

cnf(i_0_6947,axiom,
    ( ~ esk8839_4(X1,X2,X3,X4)
    | esk8874_4(X1,X2,X3,X4) ) ).

cnf(i_0_6948,axiom,
    ( ~ esk11574_4(X1,X2,X3,X4)
    | esk11578_4(X1,X2,X3,X4)
    | esk11573_4(X1,X2,X3,X4) ) ).

cnf(i_0_6949,axiom,
    ( ~ esk5841_4(X1,X2,X3,X4)
    | ~ esk5876_4(X1,X2,X3,X4)
    | ~ esk5875_4(X1,X2,X3,X4) ) ).

cnf(i_0_6950,axiom,
    ( esk774_4(X1,X2,X3,X4)
    | ~ esk649_4(X1,X2,X3,X4) ) ).

cnf(i_0_6951,axiom,
    ( esk10947_4(X1,X2,X3,X4)
    | ~ esk10967_4(X1,X2,X3,X4)
    | esk10971_4(X1,X2,X3,X4) ) ).

cnf(i_0_6952,axiom,
    ( esk1092_4(X1,X2,X3,X4)
    | esk1102_4(X1,X2,X3,X4) ) ).

cnf(i_0_6953,axiom,
    ( esk1782_4(X1,X2,X3,X4)
    | ~ esk1682_4(X1,X2,X3,X4) ) ).

cnf(i_0_6954,axiom,
    ( esk12355_4(X1,X2,X3,X4)
    | ~ esk12354_4(X1,X2,X3,X4) ) ).

cnf(i_0_6955,axiom,
    ( esk14366_4(X1,X2,X3,X4)
    | esk14399_4(X1,X2,X3,X4) ) ).

cnf(i_0_6956,axiom,
    ( esk10426_4(X1,X2,X3,X4)
    | ~ esk10406_4(X1,X2,X3,X4) ) ).

cnf(i_0_6957,axiom,
    ( esk7471_4(X1,X2,X3,X4)
    | ~ esk7472_4(X1,X2,X3,X4) ) ).

cnf(i_0_6958,axiom,
    ( esk15620_4(X1,X2,X3,X4)
    | esk15644_4(X1,X2,X3,X4) ) ).

cnf(i_0_6959,axiom,
    ( esk10052_4(X1,X2,X3,X4)
    | esk10053_4(X1,X2,X3,X4)
    | esk10051_4(X1,X2,X3,X4) ) ).

cnf(i_0_6960,axiom,
    ( esk10823_4(X1,X2,X3,X4)
    | esk10821_4(X1,X2,X3,X4) ) ).

cnf(i_0_6961,axiom,
    ( ~ esk5083_4(X1,X2,X3,X4)
    | ~ esk5188_4(X1,X2,X3,X4)
    | ~ esk5101_4(X1,X2,X3,X4) ) ).

cnf(i_0_6962,axiom,
    ( ~ esk13397_4(X1,X2,X3,X4)
    | ~ esk13395_4(X1,X2,X3,X4) ) ).

cnf(i_0_6963,axiom,
    ( ~ esk11313_4(X1,X2,X3,X4)
    | esk11367_4(X1,X2,X3,X4) ) ).

cnf(i_0_6964,axiom,
    ( esk12085_4(X1,X2,X3,X4)
    | ~ esk12343_4(X1,X2,X3,X4) ) ).

cnf(i_0_6965,axiom,
    ( ~ esk6438_4(X1,X2,X3,X4)
    | esk6180_4(X1,X2,X3,X4) ) ).

cnf(i_0_6966,axiom,
    ( esk1610_4(X1,X2,X3,X4)
    | ~ esk1611_4(X1,X2,X3,X4) ) ).

cnf(i_0_6967,axiom,
    ( esk6740_4(X1,X2,X3,X4)
    | ~ esk6742_4(X1,X2,X3,X4) ) ).

cnf(i_0_6968,axiom,
    ( esk7974_4(X1,X2,X3,X4)
    | ~ esk7853_4(X1,X2,X3,X4) ) ).

cnf(i_0_6969,axiom,
    ( ~ esk2263_4(X1,X2,X3,X4)
    | ~ esk2250_4(X1,X2,X3,X4)
    | ~ esk2264_4(X1,X2,X3,X4) ) ).

cnf(i_0_6970,axiom,
    ( ~ esk16309_4(X1,X2,X3,X4)
    | esk16371_4(X1,X2,X3,X4) ) ).

cnf(i_0_6971,axiom,
    ( ~ esk3458_4(X1,X2,X3,X4)
    | esk3615_4(X1,X2,X3,X4) ) ).

cnf(i_0_6972,axiom,
    ( ~ esk15728_4(X1,X2,X3,X4)
    | ~ esk15750_4(X1,X2,X3,X4) ) ).

cnf(i_0_6973,axiom,
    ( esk6145_4(X1,X2,X3,X4)
    | ~ esk6048_4(X1,X2,X3,X4) ) ).

cnf(i_0_6974,axiom,
    ( ~ esk15152_4(X1,X2,X3,X4)
    | esk15203_4(X1,X2,X3,X4)
    | esk15196_4(X1,X2,X3,X4) ) ).

cnf(i_0_6975,axiom,
    ( esk9204_4(X1,X2,X3,X4)
    | esk9237_4(X1,X2,X3,X4) ) ).

cnf(i_0_6976,axiom,
    ( esk1867_4(X1,X2,X3,X4)
    | ~ esk1868_4(X1,X2,X3,X4) ) ).

cnf(i_0_6977,axiom,
    ( esk15197_4(X1,X2,X3,X4)
    | esk15229_4(X1,X2,X3,X4) ) ).

cnf(i_0_6978,axiom,
    ( esk11058_4(X1,X2,X3,X4)
    | esk11076_4(X1,X2,X3,X4) ) ).

cnf(i_0_6979,axiom,
    ( esk3824_4(X1,X2,X3,X4)
    | esk3798_4(X1,X2,X3,X4) ) ).

cnf(i_0_6980,axiom,
    ( esk7603_4(X1,X2,X3,X4)
    | esk7573_4(X1,X2,X3,X4)
    | esk7551_4(X1,X2,X3,X4)
    | esk7576_4(X1,X2,X3,X4)
    | esk7575_4(X1,X2,X3,X4) ) ).

cnf(i_0_6981,axiom,
    ( esk5193_4(X1,X2,X3,X4)
    | esk5165_4(X1,X2,X3,X4) ) ).

cnf(i_0_6982,axiom,
    ( esk6126_4(X1,X2,X3,X4)
    | esk6159_4(X1,X2,X3,X4) ) ).

cnf(i_0_6983,axiom,
    ( esk15183_4(X1,X2,X3,X4)
    | esk15085_4(X1,X2,X3,X4) ) ).

cnf(i_0_6984,axiom,
    ( ~ esk5974_4(X1,X2,X3,X4)
    | ~ esk5948_4(X1,X2,X3,X4)
    | ~ esk5949_4(X1,X2,X3,X4) ) ).

cnf(i_0_6985,axiom,
    ( esk12509_4(X1,X2,X3,X4)
    | ~ esk12513_4(X1,X2,X3,X4) ) ).

cnf(i_0_6986,axiom,
    ( esk15522_4(X1,X2,X3,X4)
    | ~ esk15555_4(X1,X2,X3,X4) ) ).

cnf(i_0_6987,axiom,
    ( ~ esk7665_4(X1,X2,X3,X4)
    | ~ esk7664_4(X1,X2,X3,X4)
    | ~ esk7645_4(X1,X2,X3,X4) ) ).

cnf(i_0_6988,axiom,
    ( esk9199_4(X1,X2,X3,X4)
    | esk9191_4(X1,X2,X3,X4) ) ).

cnf(i_0_6989,axiom,
    ( esk8938_4(X1,X2,X3,X4)
    | esk8962_4(X1,X2,X3,X4) ) ).

cnf(i_0_6990,axiom,
    ( ~ esk9403_4(X1,X2,X3,X4)
    | ~ esk9401_4(X1,X2,X3,X4) ) ).

cnf(i_0_6991,axiom,
    ( esk5725_4(X1,X2,X3,X4)
    | ~ esk5637_4(X1,X2,X3,X4)
    | esk5718_4(X1,X2,X3,X4) ) ).

cnf(i_0_6992,axiom,
    ( esk8424_4(X1,X2,X3,X4)
    | esk8444_4(X1,X2,X3,X4) ) ).

cnf(i_0_6993,axiom,
    ( esk16711_4(X1,X2,X3,X4)
    | ~ esk288_0
    | p(X1)
    | p(X4)
    | p(X2)
    | p(X3) ) ).

cnf(i_0_6994,axiom,
    ( ~ esk5935_4(X1,X2,X3,X4)
    | esk5890_4(X1,X2,X3,X4) ) ).

cnf(i_0_6995,axiom,
    ( ~ esk1974_4(X1,X2,X3,X4)
    | esk1976_4(X1,X2,X3,X4) ) ).

cnf(i_0_6996,axiom,
    ( ~ esk12460_4(X1,X2,X3,X4)
    | esk12484_4(X1,X2,X3,X4)
    | ~ esk12487_4(X1,X2,X3,X4) ) ).

cnf(i_0_6997,axiom,
    ( esk4053_4(X1,X2,X3,X4)
    | esk4058_4(X1,X2,X3,X4) ) ).

cnf(i_0_6998,axiom,
    ( ~ esk3135_4(X1,X2,X3,X4)
    | ~ esk3154_4(X1,X2,X3,X4)
    | ~ esk3083_4(X1,X2,X3,X4) ) ).

cnf(i_0_6999,axiom,
    ( esk4633_4(X1,X2,X3,X4)
    | esk4600_4(X1,X2,X3,X4) ) ).

cnf(i_0_7000,axiom,
    ( esk2550_4(X1,X2,X3,X4)
    | ~ esk2508_4(X1,X2,X3,X4) ) ).

cnf(i_0_7001,axiom,
    ( esk11313_4(X1,X2,X3,X4)
    | esk11333_4(X1,X2,X3,X4) ) ).

cnf(i_0_7002,axiom,
    ( ~ esk11940_4(X1,X2,X3,X4)
    | esk12002_4(X1,X2,X3,X4) ) ).

cnf(i_0_7003,axiom,
    ( esk10685_4(X1,X2,X3,X4)
    | ~ esk10669_4(X1,X2,X3,X4) ) ).

cnf(i_0_7004,axiom,
    ( ~ esk6369_4(X1,X2,X3,X4)
    | ~ esk6370_4(X1,X2,X3,X4)
    | ~ esk6365_4(X1,X2,X3,X4) ) ).

cnf(i_0_7005,axiom,
    ( ~ esk14805_4(X1,X2,X3,X4)
    | esk14817_4(X1,X2,X3,X4) ) ).

cnf(i_0_7006,axiom,
    ( esk4808_4(X1,X2,X3,X4)
    | ~ esk4889_4(X1,X2,X3,X4) ) ).

cnf(i_0_7007,axiom,
    ( esk8496_4(X1,X2,X3,X4)
    | esk8371_4(X1,X2,X3,X4) ) ).

cnf(i_0_7008,axiom,
    ( esk6411_4(X1,X2,X3,X4)
    | ~ esk6360_4(X1,X2,X3,X4) ) ).

cnf(i_0_7009,axiom,
    ( esk16670_4(X1,X2,X3,X4)
    | esk16635_4(X1,X2,X3,X4) ) ).

cnf(i_0_7010,axiom,
    ( ~ esk2251_4(X1,X2,X3,X4)
    | esk2293_4(X1,X2,X3,X4) ) ).

cnf(i_0_7011,axiom,
    ( ~ esk3282_4(X1,X2,X3,X4)
    | ~ esk3315_4(X1,X2,X3,X4)
    | ~ esk3348_4(X1,X2,X3,X4) ) ).

cnf(i_0_7012,axiom,
    ( esk3547_4(X1,X2,X3,X4)
    | esk3536_4(X1,X2,X3,X4) ) ).

cnf(i_0_7013,axiom,
    ( esk3025_4(X1,X2,X3,X4)
    | esk3034_4(X1,X2,X3,X4) ) ).

cnf(i_0_7014,axiom,
    ( esk6916_4(X1,X2,X3,X4)
    | ~ esk6963_4(X1,X2,X3,X4)
    | esk7000_4(X1,X2,X3,X4) ) ).

cnf(i_0_7015,axiom,
    ( esk14698_4(X1,X2,X3,X4)
    | esk14612_4(X1,X2,X3,X4) ) ).

cnf(i_0_7016,axiom,
    ( esk8924_4(X1,X2,X3,X4)
    | esk8962_4(X1,X2,X3,X4) ) ).

cnf(i_0_7017,axiom,
    ( esk14397_4(X1,X2,X3,X4)
    | esk14364_4(X1,X2,X3,X4) ) ).

cnf(i_0_7018,axiom,
    ( esk5939_4(X1,X2,X3,X4)
    | ~ esk5940_4(X1,X2,X3,X4)
    | esk5961_4(X1,X2,X3,X4) ) ).

cnf(i_0_7019,axiom,
    ( ~ esk8167_4(X1,X2,X3,X4)
    | ~ esk8181_4(X1,X2,X3,X4)
    | ~ esk8264_4(X1,X2,X3,X4) ) ).

cnf(i_0_7020,axiom,
    ( esk13353_4(X1,X2,X3,X4)
    | esk13398_4(X1,X2,X3,X4) ) ).

cnf(i_0_7021,axiom,
    ( esk12641_4(X1,X2,X3,X4)
    | esk12554_4(X1,X2,X3,X4) ) ).

cnf(i_0_7022,axiom,
    ( esk6236_4(X1,X2,X3,X4)
    | ~ esk6155_4(X1,X2,X3,X4) ) ).

cnf(i_0_7023,axiom,
    ( esk10536_4(X1,X2,X3,X4)
    | ~ esk10278_4(X1,X2,X3,X4) ) ).

cnf(i_0_7024,axiom,
    ( ~ esk1781_4(X1,X2,X3,X4)
    | esk1736_4(X1,X2,X3,X4) ) ).

cnf(i_0_7025,axiom,
    ( esk7757_4(X1,X2,X3,X4)
    | ~ esk7703_4(X1,X2,X3,X4) ) ).

cnf(i_0_7026,axiom,
    ( ~ esk5507_4(X1,X2,X3,X4)
    | esk5539_4(X1,X2,X3,X4) ) ).

cnf(i_0_7027,axiom,
    ( ~ esk14179_4(X1,X2,X3,X4)
    | esk14177_4(X1,X2,X3,X4) ) ).

cnf(i_0_7028,axiom,
    ( ~ esk13363_4(X1,X2,X3,X4)
    | esk13415_4(X1,X2,X3,X4)
    | esk13434_4(X1,X2,X3,X4) ) ).

cnf(i_0_7029,axiom,
    ( ~ esk16003_4(X1,X2,X3,X4)
    | esk16001_4(X1,X2,X3,X4) ) ).

cnf(i_0_7030,axiom,
    ( esk9706_4(X1,X2,X3,X4)
    | esk9710_4(X1,X2,X3,X4) ) ).

cnf(i_0_7031,axiom,
    ( ~ esk2528_4(X1,X2,X3,X4)
    | ~ esk2561_4(X1,X2,X3,X4)
    | ~ esk2511_4(X1,X2,X3,X4) ) ).

cnf(i_0_7032,axiom,
    ( ~ esk4053_4(X1,X2,X3,X4)
    | ~ esk4072_4(X1,X2,X3,X4)
    | ~ esk4105_4(X1,X2,X3,X4) ) ).

cnf(i_0_7033,axiom,
    ( ~ p(X1)
    | esk224_0
    | p(X3)
    | ~ p(X2)
    | ~ esk511_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_7034,axiom,
    ( ~ esk3322_4(X1,X2,X3,X4)
    | esk3064_4(X1,X2,X3,X4) ) ).

cnf(i_0_7035,axiom,
    ( ~ esk16225_4(X1,X2,X3,X4)
    | ~ esk16224_4(X1,X2,X3,X4)
    | ~ esk16180_4(X1,X2,X3,X4) ) ).

cnf(i_0_7036,axiom,
    ( ~ esk1433_4(X1,X2,X3,X4)
    | esk1421_4(X1,X2,X3,X4)
    | ~ esk1547_4(X1,X2,X3,X4) ) ).

cnf(i_0_7037,axiom,
    ( esk7493_4(X1,X2,X3,X4)
    | esk7486_4(X1,X2,X3,X4)
    | ~ esk7442_4(X1,X2,X3,X4) ) ).

cnf(i_0_7038,axiom,
    ( ~ esk14278_4(X1,X2,X3,X4)
    | esk14235_4(X1,X2,X3,X4) ) ).

cnf(i_0_7039,axiom,
    ( esk10845_4(X1,X2,X3,X4)
    | esk10864_4(X1,X2,X3,X4)
    | ~ esk10793_4(X1,X2,X3,X4) ) ).

cnf(i_0_7040,axiom,
    ( ~ esk16705_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X4)
    | esk253_0
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_7041,axiom,
    ( esk1639_4(X1,X2,X3,X4)
    | esk1691_4(X1,X2,X3,X4) ) ).

cnf(i_0_7042,axiom,
    ( ~ esk13768_4(X1,X2,X3,X4)
    | ~ esk13770_4(X1,X2,X3,X4) ) ).

cnf(i_0_7043,axiom,
    ( ~ esk5119_4(X1,X2,X3,X4)
    | esk4861_4(X1,X2,X3,X4) ) ).

cnf(i_0_7044,axiom,
    ( esk4885_4(X1,X2,X3,X4)
    | ~ esk5143_4(X1,X2,X3,X4) ) ).

cnf(i_0_7045,axiom,
    ( ~ esk16693_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X4)
    | esk164_0
    | ~ p(X1)
    | ~ p(X3) ) ).

cnf(i_0_7046,axiom,
    ( ~ esk15356_4(X1,X2,X3,X4)
    | esk15404_4(X1,X2,X3,X4) ) ).

cnf(i_0_7047,axiom,
    ( ~ esk10781_4(X1,X2,X3,X4)
    | esk10862_4(X1,X2,X3,X4) ) ).

cnf(i_0_7048,axiom,
    ( esk500_4(X1,X2,X3,X4)
    | ~ esk449_4(X1,X2,X3,X4) ) ).

cnf(i_0_7049,axiom,
    ( esk11709_4(X1,X2,X3,X4)
    | esk11764_4(X1,X2,X3,X4) ) ).

cnf(i_0_7050,axiom,
    ( ~ esk4392_4(X1,X2,X3,X4)
    | ~ esk4410_4(X1,X2,X3,X4) ) ).

cnf(i_0_7051,axiom,
    ( esk909_4(X1,X2,X3,X4)
    | ~ esk885_4(X1,X2,X3,X4) ) ).

cnf(i_0_7052,axiom,
    ( ~ esk13657_4(X1,X2,X3,X4)
    | esk13686_4(X1,X2,X3,X4)
    | esk13606_4(X1,X2,X3,X4) ) ).

cnf(i_0_7053,axiom,
    ( ~ esk8394_4(X1,X2,X3,X4)
    | esk8392_4(X1,X2,X3,X4) ) ).

cnf(i_0_7054,axiom,
    ( esk3778_4(X1,X2,X3,X4)
    | ~ esk3742_4(X1,X2,X3,X4) ) ).

cnf(i_0_7055,axiom,
    ( esk1226_4(X1,X2,X3,X4)
    | esk1253_4(X1,X2,X3,X4) ) ).

cnf(i_0_7056,axiom,
    ( esk14564_4(X1,X2,X3,X4)
    | ~ esk14563_4(X1,X2,X3,X4) ) ).

cnf(i_0_7057,axiom,
    ( esk1_0
    | ~ p(X3)
    | ~ p(X2)
    | ~ p(X1)
    | ~ p(X4)
    | ~ esk16602_4(X1,X2,X3,X4) ) ).

cnf(i_0_7058,axiom,
    ( esk9509_4(X1,X2,X3,X4)
    | ~ esk9437_4(X1,X2,X3,X4) ) ).

cnf(i_0_7059,axiom,
    ( esk12091_4(X1,X2,X3,X4)
    | ~ esk12090_4(X1,X2,X3,X4) ) ).

cnf(i_0_7060,axiom,
    ( ~ esk12582_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4)
    | esk12464_4(X1,X2,X3,X4) ) ).

cnf(i_0_7061,axiom,
    ( esk10384_4(X1,X2,X3,X4)
    | ~ esk10413_4(X1,X2,X3,X4) ) ).

cnf(i_0_7062,axiom,
    ( esk14957_4(X1,X2,X3,X4)
    | esk14979_4(X1,X2,X3,X4) ) ).

cnf(i_0_7063,axiom,
    ( ~ esk7631_4(X1,X2,X3,X4)
    | ~ esk7730_4(X1,X2,X3,X4) ) ).

cnf(i_0_7064,axiom,
    ( esk11611_4(X1,X2,X3,X4)
    | ~ esk11597_4(X1,X2,X3,X4) ) ).

cnf(i_0_7065,axiom,
    ( esk14944_4(X1,X2,X3,X4)
    | esk14889_4(X1,X2,X3,X4) ) ).

cnf(i_0_7066,axiom,
    ( ~ esk5690_4(X1,X2,X3,X4)
    | esk5719_4(X1,X2,X3,X4)
    | esk5639_4(X1,X2,X3,X4) ) ).

cnf(i_0_7067,axiom,
    ( esk4879_4(X1,X2,X3,X4)
    | ~ esk4813_4(X1,X2,X3,X4) ) ).

cnf(i_0_7068,axiom,
    ( ~ esk10974_4(X1,X2,X3,X4)
    | esk10912_4(X1,X2,X3,X4) ) ).

cnf(i_0_7069,axiom,
    ( esk16133_4(X1,X2,X3,X4)
    | esk16078_4(X1,X2,X3,X4) ) ).

cnf(i_0_7070,axiom,
    ( esk5141_4(X1,X2,X3,X4)
    | ~ esk5192_4(X1,X2,X3,X4)
    | esk5167_4(X1,X2,X3,X4) ) ).

cnf(i_0_7071,axiom,
    ( ~ esk5579_4(X1,X2,X3,X4)
    | ~ esk5628_4(X1,X2,X3,X4)
    | ~ esk5629_4(X1,X2,X3,X4) ) ).

cnf(i_0_7072,axiom,
    ( ~ esk6562_4(X1,X2,X3,X4)
    | esk6659_4(X1,X2,X3,X4) ) ).

cnf(i_0_7073,axiom,
    ( esk15729_4(X1,X2,X3,X4)
    | esk15704_4(X1,X2,X3,X4)
    | ~ esk15678_4(X1,X2,X3,X4) ) ).

cnf(i_0_7074,axiom,
    ( ~ esk4277_4(X1,X2,X3,X4)
    | ~ esk4276_4(X1,X2,X3,X4)
    | esk4278_4(X1,X2,X3,X4) ) ).

cnf(i_0_7075,axiom,
    ( esk6966_4(X1,X2,X3,X4)
    | esk6968_4(X1,X2,X3,X4) ) ).

cnf(i_0_7076,axiom,
    ( ~ esk9014_4(X1,X2,X3,X4)
    | esk9272_4(X1,X2,X3,X4) ) ).

cnf(i_0_7077,axiom,
    ( esk419_4(X1,X2,X3,X4)
    | ~ esk426_4(X1,X2,X3,X4)
    | esk412_4(X1,X2,X3,X4) ) ).

cnf(i_0_7078,axiom,
    ( ~ esk1345_4(X1,X2,X3,X4)
    | esk1343_4(X1,X2,X3,X4) ) ).

cnf(i_0_7079,axiom,
    ( esk10562_4(X1,X2,X3,X4)
    | esk10542_4(X1,X2,X3,X4) ) ).

cnf(i_0_7080,axiom,
    ( ~ esk3601_4(X1,X2,X3,X4)
    | esk3653_4(X1,X2,X3,X4) ) ).

cnf(i_0_7081,axiom,
    ( ~ esk2701_4(X1,X2,X3,X4)
    | esk2718_4(X1,X2,X3,X4) ) ).

cnf(i_0_7082,axiom,
    ( esk2573_4(X1,X2,X3,X4)
    | ~ esk2448_4(X1,X2,X3,X4) ) ).

cnf(i_0_7083,axiom,
    ( esk14658_4(X1,X2,X3,X4)
    | ~ esk14662_4(X1,X2,X3,X4) ) ).

cnf(i_0_7084,axiom,
    ( esk6157_4(X1,X2,X3,X4)
    | ~ esk5899_4(X1,X2,X3,X4) ) ).

cnf(i_0_7085,axiom,
    ( ~ esk16176_4(X1,X2,X3,X4)
    | ~ esk16256_4(X1,X2,X3,X4)
    | ~ esk16227_4(X1,X2,X3,X4) ) ).

cnf(i_0_7086,axiom,
    ( esk2795_4(X1,X2,X3,X4)
    | esk2755_4(X1,X2,X3,X4) ) ).

cnf(i_0_7087,axiom,
    ( esk11532_4(X1,X2,X3,X4)
    | esk11494_4(X1,X2,X3,X4) ) ).

cnf(i_0_7088,axiom,
    ( ~ esk12018_4(X1,X2,X3,X4)
    | esk12057_4(X1,X2,X3,X4) ) ).

cnf(i_0_7089,axiom,
    ( ~ esk16700_4(X1,X2,X3,X4)
    | ~ esk16735_4(X1,X2,X3,X4)
    | ~ esk16754_4(X1,X2,X3,X4) ) ).

cnf(i_0_7090,axiom,
    ( esk14877_4(X1,X2,X3,X4)
    | esk14833_4(X1,X2,X3,X4) ) ).

cnf(i_0_7091,axiom,
    ( ~ esk5506_4(X1,X2,X3,X4)
    | esk5525_4(X1,X2,X3,X4) ) ).

cnf(i_0_7092,axiom,
    ( ~ esk1707_4(X1,X2,X3,X4)
    | esk1708_4(X1,X2,X3,X4)
    | ~ esk1706_4(X1,X2,X3,X4) ) ).

cnf(i_0_7093,axiom,
    ( esk8577_4(X1,X2,X3,X4)
    | esk8630_4(X1,X2,X3,X4) ) ).

cnf(i_0_7094,axiom,
    ( esk13428_4(X1,X2,X3,X4)
    | ~ esk13347_4(X1,X2,X3,X4)
    | esk13435_4(X1,X2,X3,X4) ) ).

cnf(i_0_7095,axiom,
    ( esk15448_4(X1,X2,X3,X4)
    | ~ esk15449_4(X1,X2,X3,X4)
    | esk15470_4(X1,X2,X3,X4) ) ).

cnf(i_0_7096,axiom,
    ( esk1067_4(X1,X2,X3,X4)
    | ~ esk1052_4(X1,X2,X3,X4) ) ).

cnf(i_0_7097,axiom,
    ( ~ esk12489_4(X1,X2,X3,X4)
    | ~ esk12507_4(X1,X2,X3,X4) ) ).

cnf(i_0_7098,axiom,
    ( esk9430_4(X1,X2,X3,X4)
    | esk9396_4(X1,X2,X3,X4)
    | esk9450_4(X1,X2,X3,X4) ) ).

cnf(i_0_7099,axiom,
    ( esk15134_4(X1,X2,X3,X4)
    | esk15106_4(X1,X2,X3,X4) ) ).

cnf(i_0_7100,axiom,
    ( ~ esk4631_4(X1,X2,X3,X4)
    | esk4685_4(X1,X2,X3,X4) ) ).

cnf(i_0_7101,axiom,
    ( ~ esk9786_4(X1,X2,X3,X4)
    | ~ esk9689_4(X1,X2,X3,X4) ) ).

cnf(i_0_7102,axiom,
    ( esk3747_4(X1,X2,X3,X4)
    | esk3695_4(X1,X2,X3,X4) ) ).

cnf(i_0_7103,axiom,
    ( esk16733_4(X1,X2,X3,X4)
    | esk16702_4(X1,X2,X3,X4) ) ).

cnf(i_0_7104,axiom,
    ( esk8688_4(X1,X2,X3,X4)
    | esk8679_4(X1,X2,X3,X4) ) ).

cnf(i_0_7105,axiom,
    ( ~ esk9657_4(X1,X2,X3,X4)
    | esk9642_4(X1,X2,X3,X4)
    | ~ esk9765_4(X1,X2,X3,X4) ) ).

cnf(i_0_7106,axiom,
    ( ~ esk5333_4(X1,X2,X3,X4)
    | ~ esk5350_4(X1,X2,X3,X4)
    | ~ esk5349_4(X1,X2,X3,X4) ) ).

cnf(i_0_7107,axiom,
    ( ~ esk11824_4(X1,X2,X3,X4)
    | esk12082_4(X1,X2,X3,X4) ) ).

cnf(i_0_7108,axiom,
    ( esk2632_4(X1,X2,X3,X4)
    | esk2517_4(X1,X2,X3,X4) ) ).

cnf(i_0_7109,axiom,
    ( esk7133_4(X1,X2,X3,X4)
    | esk7146_4(X1,X2,X3,X4) ) ).

cnf(i_0_7110,axiom,
    ( ~ esk2696_4(X1,X2,X3,X4)
    | esk2716_4(X1,X2,X3,X4) ) ).

cnf(i_0_7111,axiom,
    ( esk9492_4(X1,X2,X3,X4)
    | ~ esk9392_4(X1,X2,X3,X4) ) ).

cnf(i_0_7112,axiom,
    ( esk15003_4(X1,X2,X3,X4)
    | esk15055_4(X1,X2,X3,X4) ) ).

cnf(i_0_7113,axiom,
    ( ~ esk16602_4(X1,X2,X3,X4)
    | p(X4)
    | p(X1)
    | esk24_0
    | ~ p(X3)
    | ~ p(X2) ) ).

cnf(i_0_7114,axiom,
    ( ~ esk14568_4(X1,X2,X3,X4)
    | ~ esk14569_4(X1,X2,X3,X4) ) ).

cnf(i_0_7115,axiom,
    ( ~ esk1988_4(X1,X2,X3,X4)
    | esk2048_4(X1,X2,X3,X4) ) ).

cnf(i_0_7116,axiom,
    ( esk9188_4(X1,X2,X3,X4)
    | ~ esk9236_4(X1,X2,X3,X4) ) ).

cnf(i_0_7117,axiom,
    ( ~ esk8916_4(X1,X2,X3,X4)
    | ~ esk9015_4(X1,X2,X3,X4) ) ).

cnf(i_0_7118,axiom,
    ( ~ esk8949_4(X1,X2,X3,X4)
    | ~ esk8936_4(X1,X2,X3,X4)
    | ~ esk8982_4(X1,X2,X3,X4) ) ).

cnf(i_0_7119,axiom,
    ( ~ esk4225_4(X1,X2,X3,X4)
    | esk4251_4(X1,X2,X3,X4) ) ).

cnf(i_0_7120,axiom,
    ( ~ esk11251_4(X1,X2,X3,X4)
    | ~ esk11275_4(X1,X2,X3,X4)
    | ~ esk11381_4(X1,X2,X3,X4) ) ).

cnf(i_0_7121,axiom,
    ( ~ esk6557_4(X1,X2,X3,X4)
    | esk6530_4(X1,X2,X3,X4) ) ).

cnf(i_0_7122,axiom,
    ( ~ esk12606_4(X1,X2,X3,X4)
    | esk12348_4(X1,X2,X3,X4) ) ).

cnf(i_0_7123,axiom,
    ( ~ esk16724_4(X1,X2,X3,X4)
    | esk16723_4(X1,X2,X3,X4) ) ).

cnf(i_0_7124,axiom,
    ( esk7704_4(X1,X2,X3,X4)
    | ~ esk7641_4(X1,X2,X3,X4) ) ).

cnf(i_0_7125,axiom,
    ( ~ esk8517_4(X1,X2,X3,X4)
    | ~ esk8515_4(X1,X2,X3,X4) ) ).

cnf(i_0_7126,axiom,
    ( esk8911_4(X1,X2,X3,X4)
    | ~ esk8912_4(X1,X2,X3,X4) ) ).

cnf(i_0_7127,axiom,
    ( esk15409_4(X1,X2,X3,X4)
    | esk15460_4(X1,X2,X3,X4)
    | ~ esk15453_4(X1,X2,X3,X4) ) ).

cnf(i_0_7128,axiom,
    ( esk15598_4(X1,X2,X3,X4)
    | esk15620_4(X1,X2,X3,X4)
    | esk15619_4(X1,X2,X3,X4) ) ).

cnf(i_0_7129,axiom,
    ( esk14_0
    | ~ p(X1)
    | ~ esk16600_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X2)
    | ~ p(X4) ) ).

cnf(i_0_7130,axiom,
    ( ~ esk10263_4(X1,X2,X3,X4)
    | esk10344_4(X1,X2,X3,X4)
    | esk10351_4(X1,X2,X3,X4) ) ).

cnf(i_0_7131,axiom,
    ( esk2367_4(X1,X2,X3,X4)
    | ~ esk2366_4(X1,X2,X3,X4) ) ).

cnf(i_0_7132,axiom,
    ( esk1246_4(X1,X2,X3,X4)
    | esk1333_4(X1,X2,X3,X4) ) ).

cnf(i_0_7133,axiom,
    ( esk12757_4(X1,X2,X3,X4)
    | ~ esk12751_4(X1,X2,X3,X4) ) ).

cnf(i_0_7134,axiom,
    ( esk8338_4(X1,X2,X3,X4)
    | ~ esk8362_4(X1,X2,X3,X4) ) ).

cnf(i_0_7135,axiom,
    ( esk14096_4(X1,X2,X3,X4)
    | esk14183_4(X1,X2,X3,X4) ) ).

cnf(i_0_7136,axiom,
    ( esk1260_4(X1,X2,X3,X4)
    | esk1210_4(X1,X2,X3,X4) ) ).

cnf(i_0_7137,axiom,
    ( esk14133_4(X1,X2,X3,X4)
    | ~ esk14391_4(X1,X2,X3,X4) ) ).

cnf(i_0_7138,axiom,
    ( ~ esk6880_4(X1,X2,X3,X4)
    | ~ esk6924_4(X1,X2,X3,X4)
    | ~ esk6891_4(X1,X2,X3,X4) ) ).

cnf(i_0_7139,axiom,
    ( ~ esk14155_4(X1,X2,X3,X4)
    | ~ esk14148_4(X1,X2,X3,X4)
    | ~ esk14057_4(X1,X2,X3,X4) ) ).

cnf(i_0_7140,axiom,
    ( ~ esk11959_4(X1,X2,X3,X4)
    | esk12056_4(X1,X2,X3,X4) ) ).

cnf(i_0_7141,axiom,
    ( ~ esk11249_4(X1,X2,X3,X4)
    | ~ esk11305_4(X1,X2,X3,X4)
    | ~ esk11272_4(X1,X2,X3,X4) ) ).

cnf(i_0_7142,axiom,
    ( esk3275_4(X1,X2,X3,X4)
    | ~ esk3329_4(X1,X2,X3,X4) ) ).

cnf(i_0_7143,axiom,
    ( ~ esk9237_4(X1,X2,X3,X4)
    | ~ esk9288_4(X1,X2,X3,X4)
    | ~ esk9323_4(X1,X2,X3,X4) ) ).

cnf(i_0_7144,axiom,
    ( ~ esk14098_4(X1,X2,X3,X4)
    | ~ esk14078_4(X1,X2,X3,X4)
    | ~ esk14184_4(X1,X2,X3,X4) ) ).

cnf(i_0_7145,axiom,
    ( ~ esk4920_4(X1,X2,X3,X4)
    | ~ esk4922_4(X1,X2,X3,X4) ) ).

cnf(i_0_7146,axiom,
    ( esk15855_4(X1,X2,X3,X4)
    | esk15877_4(X1,X2,X3,X4)
    | esk15876_4(X1,X2,X3,X4) ) ).

cnf(i_0_7147,axiom,
    ( esk478_4(X1,X2,X3,X4)
    | esk511_4(X1,X2,X3,X4) ) ).

cnf(i_0_7148,axiom,
    ( esk15678_4(X1,X2,X3,X4)
    | esk15645_4(X1,X2,X3,X4) ) ).

cnf(i_0_7149,axiom,
    ( esk4051_4(X1,X2,X3,X4)
    | esk4059_4(X1,X2,X3,X4) ) ).

cnf(i_0_7150,axiom,
    ( ~ esk12237_4(X1,X2,X3,X4)
    | esk12243_4(X1,X2,X3,X4) ) ).

cnf(i_0_7151,axiom,
    ( esk15325_4(X1,X2,X3,X4)
    | esk15318_4(X1,X2,X3,X4)
    | ~ esk15332_4(X1,X2,X3,X4) ) ).

cnf(i_0_7152,axiom,
    ( ~ esk5369_4(X1,X2,X3,X4)
    | ~ esk5370_4(X1,X2,X3,X4)
    | ~ esk5323_4(X1,X2,X3,X4) ) ).

cnf(i_0_7153,axiom,
    ( ~ esk15341_4(X1,X2,X3,X4)
    | ~ esk15433_4(X1,X2,X3,X4) ) ).

cnf(i_0_7154,axiom,
    ( ~ esk9000_4(X1,X2,X3,X4)
    | esk8742_4(X1,X2,X3,X4) ) ).

cnf(i_0_7155,axiom,
    ( esk8661_4(X1,X2,X3,X4)
    | ~ esk8599_4(X1,X2,X3,X4) ) ).

cnf(i_0_7156,axiom,
    ( esk13942_4(X1,X2,X3,X4)
    | esk13861_4(X1,X2,X3,X4)
    | ~ esk13949_4(X1,X2,X3,X4) ) ).

cnf(i_0_7157,axiom,
    ( esk15317_4(X1,X2,X3,X4)
    | ~ esk15575_4(X1,X2,X3,X4) ) ).

cnf(i_0_7158,axiom,
    ( esk8638_4(X1,X2,X3,X4)
    | ~ esk8896_4(X1,X2,X3,X4) ) ).

cnf(i_0_7159,axiom,
    ( ~ esk4557_4(X1,X2,X3,X4)
    | esk4620_4(X1,X2,X3,X4) ) ).

cnf(i_0_7160,axiom,
    ( ~ esk15175_4(X1,X2,X3,X4)
    | esk15433_4(X1,X2,X3,X4) ) ).

cnf(i_0_7161,axiom,
    ( esk10709_4(X1,X2,X3,X4)
    | ~ esk10711_4(X1,X2,X3,X4) ) ).

cnf(i_0_7162,axiom,
    ( ~ esk5665_4(X1,X2,X3,X4)
    | esk5663_4(X1,X2,X3,X4) ) ).

cnf(i_0_7163,axiom,
    ( esk3735_4(X1,X2,X3,X4)
    | ~ esk3713_4(X1,X2,X3,X4) ) ).

cnf(i_0_7164,axiom,
    ( esk1_0
    | p(X4)
    | p(X1)
    | p(X3)
    | ~ esk534_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_7165,axiom,
    ( esk723_4(X1,X2,X3,X4)
    | esk712_4(X1,X2,X3,X4) ) ).

cnf(i_0_7166,axiom,
    ( ~ esk1690_4(X1,X2,X3,X4)
    | esk1693_4(X1,X2,X3,X4) ) ).

cnf(i_0_7167,axiom,
    ( esk3538_4(X1,X2,X3,X4)
    | ~ esk3574_4(X1,X2,X3,X4) ) ).

cnf(i_0_7168,axiom,
    ( ~ esk13112_4(X1,X2,X3,X4)
    | ~ esk12998_4(X1,X2,X3,X4)
    | esk12986_4(X1,X2,X3,X4) ) ).

cnf(i_0_7169,axiom,
    ( esk9728_4(X1,X2,X3,X4)
    | esk9707_4(X1,X2,X3,X4) ) ).

cnf(i_0_7170,axiom,
    ( esk14604_4(X1,X2,X3,X4)
    | esk14592_4(X1,X2,X3,X4) ) ).

cnf(i_0_7171,axiom,
    ( esk978_4(X1,X2,X3,X4)
    | esk969_4(X1,X2,X3,X4) ) ).

cnf(i_0_7172,axiom,
    ( esk4827_4(X1,X2,X3,X4)
    | esk4860_4(X1,X2,X3,X4) ) ).

cnf(i_0_7173,axiom,
    ( esk2809_4(X1,X2,X3,X4)
    | ~ esk3067_4(X1,X2,X3,X4) ) ).

cnf(i_0_7174,axiom,
    ( ~ esk14445_4(X1,X2,X3,X4)
    | ~ esk14417_4(X1,X2,X3,X4) ) ).

cnf(i_0_7175,axiom,
    ( esk11328_4(X1,X2,X3,X4)
    | ~ esk11070_4(X1,X2,X3,X4) ) ).

cnf(i_0_7176,axiom,
    ( esk15518_4(X1,X2,X3,X4)
    | esk15570_4(X1,X2,X3,X4)
    | esk15543_4(X1,X2,X3,X4)
    | esk15542_4(X1,X2,X3,X4)
    | esk15540_4(X1,X2,X3,X4) ) ).

cnf(i_0_7177,axiom,
    ( esk13843_4(X1,X2,X3,X4)
    | esk13808_4(X1,X2,X3,X4) ) ).

cnf(i_0_7178,axiom,
    ( esk11742_4(X1,X2,X3,X4)
    | esk11741_4(X1,X2,X3,X4) ) ).

cnf(i_0_7179,axiom,
    ( ~ esk10793_4(X1,X2,X3,X4)
    | ~ esk10735_4(X1,X2,X3,X4)
    | ~ esk10760_4(X1,X2,X3,X4) ) ).

cnf(i_0_7180,axiom,
    ( esk9136_4(X1,X2,X3,X4)
    | ~ esk9143_4(X1,X2,X3,X4)
    | ~ esk9237_4(X1,X2,X3,X4) ) ).

cnf(i_0_7181,axiom,
    ( esk2952_4(X1,X2,X3,X4)
    | esk3098_4(X1,X2,X3,X4) ) ).

cnf(i_0_7182,axiom,
    ( ~ esk4173_4(X1,X2,X3,X4)
    | ~ esk4055_4(X1,X2,X3,X4)
    | ~ esk4057_4(X1,X2,X3,X4) ) ).

cnf(i_0_7183,axiom,
    ( esk10480_4(X1,X2,X3,X4)
    | esk10506_4(X1,X2,X3,X4) ) ).

cnf(i_0_7184,axiom,
    ( ~ esk15309_4(X1,X2,X3,X4)
    | esk15314_4(X1,X2,X3,X4) ) ).

cnf(i_0_7185,axiom,
    ( ~ esk2321_4(X1,X2,X3,X4)
    | ~ esk2203_4(X1,X2,X3,X4) ) ).

cnf(i_0_7186,axiom,
    ( esk14950_4(X1,X2,X3,X4)
    | esk14865_4(X1,X2,X3,X4) ) ).

cnf(i_0_7187,axiom,
    ( ~ esk3129_4(X1,X2,X3,X4)
    | esk3130_4(X1,X2,X3,X4) ) ).

cnf(i_0_7188,axiom,
    ( esk3047_4(X1,X2,X3,X4)
    | esk3027_4(X1,X2,X3,X4) ) ).

cnf(i_0_7189,axiom,
    ( ~ esk4279_4(X1,X2,X3,X4)
    | esk4280_4(X1,X2,X3,X4) ) ).

cnf(i_0_7190,axiom,
    ( ~ esk5949_4(X1,X2,X3,X4)
    | ~ esk5950_4(X1,X2,X3,X4) ) ).

cnf(i_0_7191,axiom,
    ( esk11463_4(X1,X2,X3,X4)
    | esk11470_4(X1,X2,X3,X4)
    | ~ esk11477_4(X1,X2,X3,X4) ) ).

cnf(i_0_7192,axiom,
    ( ~ esk8778_4(X1,X2,X3,X4)
    | ~ esk8695_4(X1,X2,X3,X4)
    | ~ esk8681_4(X1,X2,X3,X4) ) ).

cnf(i_0_7193,axiom,
    ( esk1229_4(X1,X2,X3,X4)
    | esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_7194,axiom,
    ( esk4046_4(X1,X2,X3,X4)
    | esk4069_4(X1,X2,X3,X4) ) ).

cnf(i_0_7195,axiom,
    ( esk12874_4(X1,X2,X3,X4)
    | esk12911_4(X1,X2,X3,X4)
    | ~ esk12827_4(X1,X2,X3,X4) ) ).

cnf(i_0_7196,axiom,
    ( ~ esk12764_4(X1,X2,X3,X4)
    | esk12765_4(X1,X2,X3,X4) ) ).

cnf(i_0_7197,axiom,
    ( esk15960_4(X1,X2,X3,X4)
    | esk15937_4(X1,X2,X3,X4) ) ).

cnf(i_0_7198,axiom,
    ( ~ esk13144_4(X1,X2,X3,X4)
    | ~ esk13146_4(X1,X2,X3,X4) ) ).

cnf(i_0_7199,axiom,
    ( esk6368_4(X1,X2,X3,X4)
    | esk6372_4(X1,X2,X3,X4) ) ).

cnf(i_0_7200,axiom,
    ( esk12633_4(X1,X2,X3,X4)
    | ~ esk12582_4(X1,X2,X3,X4)
    | esk12626_4(X1,X2,X3,X4) ) ).

cnf(i_0_7201,axiom,
    ( ~ esk8165_4(X1,X2,X3,X4)
    | ~ esk8219_4(X1,X2,X3,X4)
    | ~ esk8186_4(X1,X2,X3,X4) ) ).

cnf(i_0_7202,axiom,
    ( esk8750_4(X1,X2,X3,X4)
    | ~ esk8749_4(X1,X2,X3,X4) ) ).

cnf(i_0_7203,axiom,
    ( ~ esk2620_4(X1,X2,X3,X4)
    | ~ esk2599_4(X1,X2,X3,X4)
    | ~ esk2598_4(X1,X2,X3,X4) ) ).

cnf(i_0_7204,axiom,
    ( ~ esk215_0
    | ~ p(X3)
    | p(X1)
    | ~ p(X4)
    | esk511_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_7205,axiom,
    ( ~ esk7552_4(X1,X2,X3,X4)
    | ~ esk7549_4(X1,X2,X3,X4)
    | ~ esk7602_4(X1,X2,X3,X4)
    | ~ esk7550_4(X1,X2,X3,X4)
    | ~ esk7603_4(X1,X2,X3,X4) ) ).

cnf(i_0_7206,axiom,
    ( esk7197_4(X1,X2,X3,X4)
    | ~ esk7223_4(X1,X2,X3,X4)
    | esk7248_4(X1,X2,X3,X4) ) ).

cnf(i_0_7207,axiom,
    ( p(X2)
    | ~ p(X4)
    | ~ esk16683_4(X1,X2,X3,X4)
    | esk87_0
    | p(X3)
    | ~ p(X1) ) ).

cnf(i_0_7208,axiom,
    ( esk2042_4(X1,X2,X3,X4)
    | ~ esk1991_4(X1,X2,X3,X4) ) ).

cnf(i_0_7209,axiom,
    ( esk5344_4(X1,X2,X3,X4)
    | esk5336_4(X1,X2,X3,X4) ) ).

cnf(i_0_7210,axiom,
    ( esk5612_4(X1,X2,X3,X4)
    | esk5645_4(X1,X2,X3,X4) ) ).

cnf(i_0_7211,axiom,
    ( esk9483_4(X1,X2,X3,X4)
    | esk9450_4(X1,X2,X3,X4) ) ).

cnf(i_0_7212,axiom,
    ( esk7266_4(X1,X2,X3,X4)
    | esk7223_4(X1,X2,X3,X4) ) ).

cnf(i_0_7213,axiom,
    ( esk3854_4(X1,X2,X3,X4)
    | ~ esk3731_4(X1,X2,X3,X4) ) ).

cnf(i_0_7214,axiom,
    ( esk14038_4(X1,X2,X3,X4)
    | esk14040_4(X1,X2,X3,X4)
    | esk14034_4(X1,X2,X3,X4)
    | esk14037_4(X1,X2,X3,X4) ) ).

cnf(i_0_7215,axiom,
    ( ~ esk8120_4(X1,X2,X3,X4)
    | esk8140_4(X1,X2,X3,X4) ) ).

cnf(i_0_7216,axiom,
    ( ~ esk15592_4(X1,X2,X3,X4)
    | esk15596_4(X1,X2,X3,X4)
    | esk15591_4(X1,X2,X3,X4) ) ).

cnf(i_0_7217,axiom,
    ( esk6654_4(X1,X2,X3,X4)
    | esk6687_4(X1,X2,X3,X4) ) ).

cnf(i_0_7218,axiom,
    ( ~ esk9683_4(X1,X2,X3,X4)
    | esk9661_4(X1,X2,X3,X4) ) ).

cnf(i_0_7219,axiom,
    ( esk781_4(X1,X2,X3,X4)
    | ~ esk630_4(X1,X2,X3,X4) ) ).

cnf(i_0_7220,axiom,
    ( esk12536_4(X1,X2,X3,X4)
    | esk12548_4(X1,X2,X3,X4) ) ).

cnf(i_0_7221,axiom,
    ( ~ esk6410_4(X1,X2,X3,X4)
    | ~ esk6461_4(X1,X2,X3,X4)
    | ~ esk6463_4(X1,X2,X3,X4)
    | ~ esk6408_4(X1,X2,X3,X4) ) ).

cnf(i_0_7222,axiom,
    ( ~ esk16654_4(X1,X2,X3,X4)
    | ~ esk16648_4(X1,X2,X3,X4)
    | ~ esk16768_4(X1,X2,X3,X4) ) ).

cnf(i_0_7223,axiom,
    ( ~ esk1019_4(X1,X2,X3,X4)
    | ~ esk1100_4(X1,X2,X3,X4) ) ).

cnf(i_0_7224,axiom,
    ( esk6169_4(X1,X2,X3,X4)
    | esk6136_4(X1,X2,X3,X4) ) ).

cnf(i_0_7225,axiom,
    ( esk13556_4(X1,X2,X3,X4)
    | esk13576_4(X1,X2,X3,X4) ) ).

cnf(i_0_7226,axiom,
    ( ~ esk11368_4(X1,X2,X3,X4)
    | esk11367_4(X1,X2,X3,X4) ) ).

cnf(i_0_7227,axiom,
    ( esk5112_4(X1,X2,X3,X4)
    | esk5066_4(X1,X2,X3,X4) ) ).

cnf(i_0_7228,axiom,
    ( esk7187_4(X1,X2,X3,X4)
    | esk7237_4(X1,X2,X3,X4)
    | ~ esk7238_4(X1,X2,X3,X4) ) ).

cnf(i_0_7229,axiom,
    ( esk5141_4(X1,X2,X3,X4)
    | ~ esk5017_4(X1,X2,X3,X4) ) ).

cnf(i_0_7230,axiom,
    ( ~ esk6972_4(X1,X2,X3,X4)
    | ~ esk6928_4(X1,X2,X3,X4)
    | ~ esk6973_4(X1,X2,X3,X4) ) ).

cnf(i_0_7231,axiom,
    ( ~ esk12196_4(X1,X2,X3,X4)
    | esk12353_4(X1,X2,X3,X4) ) ).

cnf(i_0_7232,axiom,
    ( ~ esk3798_4(X1,X2,X3,X4)
    | ~ esk3899_4(X1,X2,X3,X4)
    | ~ esk3814_4(X1,X2,X3,X4) ) ).

cnf(i_0_7233,axiom,
    ( ~ esk6811_4(X1,X2,X3,X4)
    | esk6930_4(X1,X2,X3,X4) ) ).

cnf(i_0_7234,axiom,
    ( ~ esk10339_4(X1,X2,X3,X4)
    | esk10302_4(X1,X2,X3,X4)
    | esk10285_4(X1,X2,X3,X4) ) ).

cnf(i_0_7235,axiom,
    ( esk2022_4(X1,X2,X3,X4)
    | esk1997_4(X1,X2,X3,X4) ) ).

cnf(i_0_7236,axiom,
    ( ~ esk9709_4(X1,X2,X3,X4)
    | ~ esk9739_4(X1,X2,X3,X4)
    | ~ esk9826_4(X1,X2,X3,X4) ) ).

cnf(i_0_7237,axiom,
    ( esk14094_4(X1,X2,X3,X4)
    | esk14068_4(X1,X2,X3,X4) ) ).

cnf(i_0_7238,axiom,
    ( esk3884_4(X1,X2,X3,X4)
    | esk3854_4(X1,X2,X3,X4) ) ).

cnf(i_0_7239,axiom,
    ( ~ esk3326_4(X1,X2,X3,X4)
    | ~ esk3377_4(X1,X2,X3,X4)
    | ~ esk3406_4(X1,X2,X3,X4) ) ).

cnf(i_0_7240,axiom,
    ( ~ p(X1)
    | p(X2)
    | ~ p(X3)
    | esk491_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ esk73_0 ) ).

cnf(i_0_7241,axiom,
    ( ~ esk4412_4(X1,X2,X3,X4)
    | esk4392_4(X1,X2,X3,X4)
    | esk4441_4(X1,X2,X3,X4) ) ).

cnf(i_0_7242,axiom,
    ( esk15440_4(X1,X2,X3,X4)
    | esk15344_4(X1,X2,X3,X4)
    | esk15343_4(X1,X2,X3,X4) ) ).

cnf(i_0_7243,axiom,
    ( ~ esk13904_4(X1,X2,X3,X4)
    | esk13932_4(X1,X2,X3,X4) ) ).

cnf(i_0_7244,axiom,
    ( esk474_4(X1,X2,X3,X4)
    | esk446_4(X1,X2,X3,X4) ) ).

cnf(i_0_7245,axiom,
    ( ~ esk15596_4(X1,X2,X3,X4)
    | ~ esk15597_4(X1,X2,X3,X4) ) ).

cnf(i_0_7246,axiom,
    ( esk15100_4(X1,X2,X3,X4)
    | esk15113_4(X1,X2,X3,X4) ) ).

cnf(i_0_7247,axiom,
    ( ~ esk15926_4(X1,X2,X3,X4)
    | esk16184_4(X1,X2,X3,X4) ) ).

cnf(i_0_7248,axiom,
    ( ~ esk12279_4(X1,X2,X3,X4)
    | ~ esk12392_4(X1,X2,X3,X4)
    | ~ esk12307_4(X1,X2,X3,X4) ) ).

cnf(i_0_7249,axiom,
    ( ~ esk4638_4(X1,X2,X3,X4)
    | esk4896_4(X1,X2,X3,X4) ) ).

cnf(i_0_7250,axiom,
    ( esk6197_4(X1,X2,X3,X4)
    | esk6198_4(X1,X2,X3,X4)
    | esk6196_4(X1,X2,X3,X4) ) ).

cnf(i_0_7251,axiom,
    ( esk9032_4(X1,X2,X3,X4)
    | esk9058_4(X1,X2,X3,X4)
    | ~ esk9033_4(X1,X2,X3,X4) ) ).

cnf(i_0_7252,axiom,
    ( ~ esk14806_4(X1,X2,X3,X4)
    | esk14815_4(X1,X2,X3,X4) ) ).

cnf(i_0_7253,axiom,
    ( ~ esk10058_4(X1,X2,X3,X4)
    | ~ esk10059_4(X1,X2,X3,X4) ) ).

cnf(i_0_7254,axiom,
    ( ~ esk16737_4(X1,X2,X3,X4)
    | ~ esk16698_4(X1,X2,X3,X4) ) ).

cnf(i_0_7255,axiom,
    ( ~ esk15438_4(X1,X2,X3,X4)
    | esk15439_4(X1,X2,X3,X4) ) ).

cnf(i_0_7256,axiom,
    ( ~ esk3888_4(X1,X2,X3,X4)
    | ~ esk3887_4(X1,X2,X3,X4) ) ).

cnf(i_0_7257,axiom,
    ( p(X2)
    | p(X4)
    | ~ esk86_0
    | ~ p(X1)
    | esk16683_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_7258,axiom,
    ( esk11265_4(X1,X2,X3,X4)
    | esk11242_4(X1,X2,X3,X4) ) ).

cnf(i_0_7259,axiom,
    ( esk3635_4(X1,X2,X3,X4)
    | esk3636_4(X1,X2,X3,X4)
    | ~ esk3661_4(X1,X2,X3,X4) ) ).

cnf(i_0_7260,axiom,
    ( ~ esk7492_4(X1,X2,X3,X4)
    | ~ esk7490_4(X1,X2,X3,X4) ) ).

cnf(i_0_7261,axiom,
    ( esk1074_4(X1,X2,X3,X4)
    | ~ esk1076_4(X1,X2,X3,X4) ) ).

cnf(i_0_7262,axiom,
    ( esk12228_4(X1,X2,X3,X4)
    | esk12230_4(X1,X2,X3,X4) ) ).

cnf(i_0_7263,axiom,
    ( esk2324_4(X1,X2,X3,X4)
    | ~ esk2322_4(X1,X2,X3,X4)
    | ~ esk2323_4(X1,X2,X3,X4) ) ).

cnf(i_0_7264,axiom,
    ( esk1256_4(X1,X2,X3,X4)
    | esk1228_4(X1,X2,X3,X4) ) ).

cnf(i_0_7265,axiom,
    ( esk14353_4(X1,X2,X3,X4)
    | esk14440_4(X1,X2,X3,X4) ) ).

cnf(i_0_7266,axiom,
    ( esk8998_4(X1,X2,X3,X4)
    | ~ esk8740_4(X1,X2,X3,X4) ) ).

cnf(i_0_7267,axiom,
    ( esk14370_4(X1,X2,X3,X4)
    | ~ esk14331_4(X1,X2,X3,X4) ) ).

cnf(i_0_7268,axiom,
    ( esk11342_4(X1,X2,X3,X4)
    | ~ esk11376_4(X1,X2,X3,X4)
    | esk11295_4(X1,X2,X3,X4) ) ).

cnf(i_0_7269,axiom,
    ( ~ esk1726_4(X1,X2,X3,X4)
    | ~ esk1769_4(X1,X2,X3,X4)
    | ~ esk1770_4(X1,X2,X3,X4) ) ).

cnf(i_0_7270,axiom,
    ( esk10959_4(X1,X2,X3,X4)
    | ~ esk10960_4(X1,X2,X3,X4) ) ).

cnf(i_0_7271,axiom,
    ( ~ p(X4)
    | ~ esk503_4(X1,X2,X3,X4)
    | esk153_0
    | p(X1)
    | p(X2)
    | p(X3) ) ).

cnf(i_0_7272,axiom,
    ( ~ esk7690_4(X1,X2,X3,X4)
    | esk7648_4(X1,X2,X3,X4) ) ).

cnf(i_0_7273,axiom,
    ( ~ esk12337_4(X1,X2,X3,X4)
    | esk12363_4(X1,X2,X3,X4)
    | esk12388_4(X1,X2,X3,X4) ) ).

cnf(i_0_7274,axiom,
    ( esk8956_4(X1,X2,X3,X4)
    | esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_7275,axiom,
    ( ~ esk12104_4(X1,X2,X3,X4)
    | esk12134_4(X1,X2,X3,X4) ) ).

cnf(i_0_7276,axiom,
    ( ~ esk6062_4(X1,X2,X3,X4)
    | ~ esk6060_4(X1,X2,X3,X4) ) ).

cnf(i_0_7277,axiom,
    ( esk7725_4(X1,X2,X3,X4)
    | esk7600_4(X1,X2,X3,X4) ) ).

cnf(i_0_7278,axiom,
    ( ~ esk11574_4(X1,X2,X3,X4)
    | ~ esk11575_4(X1,X2,X3,X4)
    | esk11576_4(X1,X2,X3,X4) ) ).

cnf(i_0_7279,axiom,
    ( ~ esk6944_4(X1,X2,X3,X4)
    | esk6998_4(X1,X2,X3,X4) ) ).

cnf(i_0_7280,axiom,
    ( esk9249_4(X1,X2,X3,X4)
    | ~ esk8991_4(X1,X2,X3,X4) ) ).

cnf(i_0_7281,axiom,
    ( esk5555_4(X1,X2,X3,X4)
    | ~ esk5297_4(X1,X2,X3,X4) ) ).

cnf(i_0_7282,axiom,
    ( esk1009_4(X1,X2,X3,X4)
    | esk976_4(X1,X2,X3,X4) ) ).

cnf(i_0_7283,axiom,
    ( esk6908_4(X1,X2,X3,X4)
    | esk6991_4(X1,X2,X3,X4) ) ).

cnf(i_0_7284,axiom,
    ( ~ esk4656_4(X1,X2,X3,X4)
    | ~ esk4657_4(X1,X2,X3,X4)
    | ~ esk4621_4(X1,X2,X3,X4) ) ).

cnf(i_0_7285,axiom,
    ( esk15693_4(X1,X2,X3,X4)
    | ~ esk15692_4(X1,X2,X3,X4) ) ).

cnf(i_0_7286,axiom,
    ( ~ esk13540_4(X1,X2,X3,X4)
    | ~ esk13526_4(X1,X2,X3,X4)
    | ~ esk13517_4(X1,X2,X3,X4) ) ).

cnf(i_0_7287,axiom,
    ( esk2298_4(X1,X2,X3,X4)
    | esk2265_4(X1,X2,X3,X4) ) ).

cnf(i_0_7288,axiom,
    ( ~ esk15815_4(X1,X2,X3,X4)
    | esk15913_4(X1,X2,X3,X4) ) ).

cnf(i_0_7289,axiom,
    ( ~ esk5830_4(X1,X2,X3,X4)
    | ~ esk5831_4(X1,X2,X3,X4) ) ).

cnf(i_0_7290,axiom,
    ( esk1433_4(X1,X2,X3,X4)
    | ~ esk1427_4(X1,X2,X3,X4) ) ).

cnf(i_0_7291,axiom,
    ( ~ esk7193_4(X1,X2,X3,X4)
    | ~ esk7224_4(X1,X2,X3,X4) ) ).

cnf(i_0_7292,axiom,
    ( esk4567_4(X1,X2,X3,X4)
    | esk4513_4(X1,X2,X3,X4)
    | esk4547_4(X1,X2,X3,X4) ) ).

cnf(i_0_7293,axiom,
    ( esk10318_4(X1,X2,X3,X4)
    | esk10263_4(X1,X2,X3,X4) ) ).

cnf(i_0_7294,axiom,
    ( ~ esk8098_4(X1,X2,X3,X4)
    | esk8219_4(X1,X2,X3,X4) ) ).

cnf(i_0_7295,axiom,
    ( ~ esk8871_4(X1,X2,X3,X4)
    | esk8994_4(X1,X2,X3,X4) ) ).

cnf(i_0_7296,axiom,
    ( esk7260_4(X1,X2,X3,X4)
    | esk7270_4(X1,X2,X3,X4) ) ).

cnf(i_0_7297,axiom,
    ( esk15063_4(X1,X2,X3,X4)
    | ~ esk15072_4(X1,X2,X3,X4) ) ).

cnf(i_0_7298,axiom,
    ( esk15387_4(X1,X2,X3,X4)
    | esk15349_4(X1,X2,X3,X4) ) ).

cnf(i_0_7299,axiom,
    ( esk8597_4(X1,X2,X3,X4)
    | esk8628_4(X1,X2,X3,X4)
    | ~ esk8748_4(X1,X2,X3,X4) ) ).

cnf(i_0_7300,axiom,
    ( ~ esk13624_4(X1,X2,X3,X4)
    | esk13366_4(X1,X2,X3,X4) ) ).

cnf(i_0_7301,axiom,
    ( ~ esk2597_4(X1,X2,X3,X4)
    | esk2622_4(X1,X2,X3,X4)
    | esk2571_4(X1,X2,X3,X4) ) ).

cnf(i_0_7302,axiom,
    ( esk11851_4(X1,X2,X3,X4)
    | esk11823_4(X1,X2,X3,X4) ) ).

cnf(i_0_7303,axiom,
    ( ~ esk6202_4(X1,X2,X3,X4)
    | esk6236_4(X1,X2,X3,X4) ) ).

cnf(i_0_7304,axiom,
    ( ~ esk5169_4(X1,X2,X3,X4)
    | ~ esk5168_4(X1,X2,X3,X4)
    | ~ esk5190_4(X1,X2,X3,X4) ) ).

cnf(i_0_7305,axiom,
    ( esk31_0
    | ~ p(X1)
    | ~ p(X2)
    | ~ p(X4)
    | ~ esk16602_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_7306,axiom,
    ( esk2626_4(X1,X2,X3,X4)
    | esk2541_4(X1,X2,X3,X4) ) ).

cnf(i_0_7307,axiom,
    ( ~ esk13814_4(X1,X2,X3,X4)
    | esk13862_4(X1,X2,X3,X4) ) ).

cnf(i_0_7308,axiom,
    ( esk5533_4(X1,X2,X3,X4)
    | ~ esk5545_4(X1,X2,X3,X4)
    | ~ esk5659_4(X1,X2,X3,X4) ) ).

cnf(i_0_7309,axiom,
    ( ~ esk11706_4(X1,X2,X3,X4)
    | esk11807_4(X1,X2,X3,X4) ) ).

cnf(i_0_7310,axiom,
    ( esk6874_4(X1,X2,X3,X4)
    | esk6894_4(X1,X2,X3,X4) ) ).

cnf(i_0_7311,axiom,
    ( esk5097_4(X1,X2,X3,X4)
    | esk5083_4(X1,X2,X3,X4) ) ).

cnf(i_0_7312,axiom,
    ( esk16734_4(X1,X2,X3,X4)
    | esk16733_4(X1,X2,X3,X4)
    | esk16735_4(X1,X2,X3,X4) ) ).

cnf(i_0_7313,axiom,
    ( ~ esk11880_4(X1,X2,X3,X4)
    | esk11829_4(X1,X2,X3,X4)
    | esk11879_4(X1,X2,X3,X4) ) ).

cnf(i_0_7314,axiom,
    ( esk971_4(X1,X2,X3,X4)
    | esk995_4(X1,X2,X3,X4) ) ).

cnf(i_0_7315,axiom,
    ( esk4893_4(X1,X2,X3,X4)
    | ~ esk4773_4(X1,X2,X3,X4) ) ).

cnf(i_0_7316,axiom,
    ( esk8743_4(X1,X2,X3,X4)
    | ~ esk8485_4(X1,X2,X3,X4) ) ).

cnf(i_0_7317,axiom,
    ( esk16626_4(X1,X2,X3,X4)
    | esk16646_4(X1,X2,X3,X4)
    | esk16592_4(X1,X2,X3,X4) ) ).

cnf(i_0_7318,axiom,
    ( esk11451_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4)
    | ~ esk11572_4(X1,X2,X3,X4) ) ).

cnf(i_0_7319,axiom,
    ( esk3342_4(X1,X2,X3,X4)
    | esk3393_4(X1,X2,X3,X4)
    | ~ esk3368_4(X1,X2,X3,X4) ) ).

cnf(i_0_7320,axiom,
    ( ~ esk3022_4(X1,X2,X3,X4)
    | ~ esk3033_4(X1,X2,X3,X4)
    | ~ esk3032_4(X1,X2,X3,X4) ) ).

cnf(i_0_7321,axiom,
    ( esk12329_4(X1,X2,X3,X4)
    | ~ esk12209_4(X1,X2,X3,X4) ) ).

cnf(i_0_7322,axiom,
    ( esk7644_4(X1,X2,X3,X4)
    | ~ esk7698_4(X1,X2,X3,X4) ) ).

cnf(i_0_7323,axiom,
    ( esk2821_4(X1,X2,X3,X4)
    | ~ esk2758_4(X1,X2,X3,X4) ) ).

cnf(i_0_7324,axiom,
    ( ~ esk13428_4(X1,X2,X3,X4)
    | ~ esk13438_4(X1,X2,X3,X4) ) ).

cnf(i_0_7325,axiom,
    ( ~ esk5912_4(X1,X2,X3,X4)
    | ~ esk5879_4(X1,X2,X3,X4)
    | ~ esk5852_4(X1,X2,X3,X4) ) ).

cnf(i_0_7326,axiom,
    ( esk2801_4(X1,X2,X3,X4)
    | esk2834_4(X1,X2,X3,X4) ) ).

cnf(i_0_7327,axiom,
    ( esk15586_4(X1,X2,X3,X4)
    | ~ esk15585_4(X1,X2,X3,X4)
    | ~ esk15584_4(X1,X2,X3,X4) ) ).

cnf(i_0_7328,axiom,
    ( esk4558_4(X1,X2,X3,X4)
    | ~ esk4618_4(X1,X2,X3,X4) ) ).

cnf(i_0_7329,axiom,
    ( esk10772_4(X1,X2,X3,X4)
    | ~ esk11030_4(X1,X2,X3,X4) ) ).

cnf(i_0_7330,axiom,
    ( esk6349_4(X1,X2,X3,X4)
    | esk6438_4(X1,X2,X3,X4) ) ).

cnf(i_0_7331,axiom,
    ( ~ esk13502_4(X1,X2,X3,X4)
    | esk13478_4(X1,X2,X3,X4) ) ).

cnf(i_0_7332,axiom,
    ( ~ esk4526_4(X1,X2,X3,X4)
    | esk4784_4(X1,X2,X3,X4) ) ).

cnf(i_0_7333,axiom,
    ( esk4425_4(X1,X2,X3,X4)
    | ~ esk4423_4(X1,X2,X3,X4)
    | ~ esk4424_4(X1,X2,X3,X4) ) ).

cnf(i_0_7334,axiom,
    ( ~ esk15623_4(X1,X2,X3,X4)
    | ~ esk15624_4(X1,X2,X3,X4)
    | ~ esk15616_4(X1,X2,X3,X4) ) ).

cnf(i_0_7335,axiom,
    ( esk7875_4(X1,X2,X3,X4)
    | ~ esk7869_4(X1,X2,X3,X4) ) ).

cnf(i_0_7336,axiom,
    ( esk10339_4(X1,X2,X3,X4)
    | ~ esk10302_4(X1,X2,X3,X4) ) ).

cnf(i_0_7337,axiom,
    ( esk14810_4(X1,X2,X3,X4)
    | esk14812_4(X1,X2,X3,X4) ) ).

cnf(i_0_7338,axiom,
    ( ~ esk10430_4(X1,X2,X3,X4)
    | ~ esk10402_4(X1,X2,X3,X4) ) ).

cnf(i_0_7339,axiom,
    ( esk3316_4(X1,X2,X3,X4)
    | esk3266_4(X1,X2,X3,X4) ) ).

cnf(i_0_7340,axiom,
    ( ~ esk16141_4(X1,X2,X3,X4)
    | ~ esk16142_4(X1,X2,X3,X4)
    | ~ esk16128_4(X1,X2,X3,X4) ) ).

cnf(i_0_7341,axiom,
    ( esk4392_4(X1,X2,X3,X4)
    | esk4410_4(X1,X2,X3,X4) ) ).

cnf(i_0_7342,axiom,
    ( ~ esk16725_4(X1,X2,X3,X4)
    | ~ esk16628_4(X1,X2,X3,X4) ) ).

cnf(i_0_7343,axiom,
    ( ~ esk1398_4(X1,X2,X3,X4)
    | esk1424_4(X1,X2,X3,X4) ) ).

cnf(i_0_7344,axiom,
    ( ~ esk16067_4(X1,X2,X3,X4)
    | esk16082_4(X1,X2,X3,X4) ) ).

cnf(i_0_7345,axiom,
    ( ~ esk4310_4(X1,X2,X3,X4)
    | ~ esk4366_4(X1,X2,X3,X4)
    | ~ esk4333_4(X1,X2,X3,X4) ) ).

cnf(i_0_7346,axiom,
    ( esk13769_4(X1,X2,X3,X4)
    | ~ esk13757_4(X1,X2,X3,X4) ) ).

cnf(i_0_7347,axiom,
    ( esk3851_4(X1,X2,X3,X4)
    | ~ esk4109_4(X1,X2,X3,X4) ) ).

cnf(i_0_7348,axiom,
    ( ~ esk6436_4(X1,X2,X3,X4)
    | esk6435_4(X1,X2,X3,X4) ) ).

cnf(i_0_7349,axiom,
    ( esk6970_4(X1,X2,X3,X4)
    | esk6969_4(X1,X2,X3,X4) ) ).

cnf(i_0_7350,axiom,
    ( ~ esk11095_4(X1,X2,X3,X4)
    | esk11093_4(X1,X2,X3,X4) ) ).

cnf(i_0_7351,axiom,
    ( ~ esk8284_4(X1,X2,X3,X4)
    | esk8283_4(X1,X2,X3,X4) ) ).

cnf(i_0_7352,axiom,
    ( esk10390_4(X1,X2,X3,X4)
    | ~ esk10422_4(X1,X2,X3,X4) ) ).

cnf(i_0_7353,axiom,
    ( esk7908_4(X1,X2,X3,X4)
    | esk7941_4(X1,X2,X3,X4) ) ).

cnf(i_0_7354,axiom,
    ( esk8083_4(X1,X2,X3,X4)
    | esk8114_4(X1,X2,X3,X4)
    | ~ esk8234_4(X1,X2,X3,X4) ) ).

cnf(i_0_7355,axiom,
    ( ~ esk10992_4(X1,X2,X3,X4)
    | ~ esk11005_4(X1,X2,X3,X4)
    | ~ esk11038_4(X1,X2,X3,X4) ) ).

cnf(i_0_7356,axiom,
    ( esk13863_4(X1,X2,X3,X4)
    | ~ esk13605_4(X1,X2,X3,X4) ) ).

cnf(i_0_7357,axiom,
    ( ~ esk14796_4(X1,X2,X3,X4)
    | ~ esk14914_4(X1,X2,X3,X4) ) ).

cnf(i_0_7358,axiom,
    ( esk4251_4(X1,X2,X3,X4)
    | ~ esk4350_4(X1,X2,X3,X4)
    | ~ esk4260_4(X1,X2,X3,X4) ) ).

cnf(i_0_7359,axiom,
    ( ~ esk13434_4(X1,X2,X3,X4)
    | ~ esk13391_4(X1,X2,X3,X4)
    | ~ esk13365_4(X1,X2,X3,X4) ) ).

cnf(i_0_7360,axiom,
    ( esk14714_4(X1,X2,X3,X4)
    | esk14685_4(X1,X2,X3,X4)
    | ~ esk14634_4(X1,X2,X3,X4) ) ).

cnf(i_0_7361,axiom,
    ( ~ esk5908_4(X1,X2,X3,X4)
    | ~ esk5939_4(X1,X2,X3,X4) ) ).

cnf(i_0_7362,axiom,
    ( ~ esk13343_4(X1,X2,X3,X4)
    | esk13245_4(X1,X2,X3,X4)
    | ~ esk13255_4(X1,X2,X3,X4) ) ).

cnf(i_0_7363,axiom,
    ( esk13806_4(X1,X2,X3,X4)
    | ~ esk13878_4(X1,X2,X3,X4) ) ).

cnf(i_0_7364,axiom,
    ( ~ esk5688_4(X1,X2,X3,X4)
    | ~ esk5687_4(X1,X2,X3,X4)
    | ~ esk5643_4(X1,X2,X3,X4) ) ).

cnf(i_0_7365,axiom,
    ( esk11760_4(X1,X2,X3,X4)
    | ~ esk11802_4(X1,X2,X3,X4) ) ).

cnf(i_0_7366,axiom,
    ( ~ esk6651_4(X1,X2,X3,X4)
    | ~ esk6610_4(X1,X2,X3,X4)
    | ~ esk6650_4(X1,X2,X3,X4) ) ).

cnf(i_0_7367,axiom,
    ( esk3765_4(X1,X2,X3,X4)
    | ~ esk3766_4(X1,X2,X3,X4)
    | esk3754_4(X1,X2,X3,X4) ) ).

cnf(i_0_7368,axiom,
    ( ~ esk8445_4(X1,X2,X3,X4)
    | ~ esk8478_4(X1,X2,X3,X4)
    | ~ esk8422_4(X1,X2,X3,X4) ) ).

cnf(i_0_7369,axiom,
    ( esk14078_4(X1,X2,X3,X4)
    | esk14090_4(X1,X2,X3,X4) ) ).

cnf(i_0_7370,axiom,
    ( ~ esk8619_4(X1,X2,X3,X4)
    | esk8595_4(X1,X2,X3,X4) ) ).

cnf(i_0_7371,axiom,
    ( ~ esk8994_4(X1,X2,X3,X4)
    | ~ esk9046_4(X1,X2,X3,X4)
    | ~ esk9065_4(X1,X2,X3,X4) ) ).

cnf(i_0_7372,axiom,
    ( esk1529_4(X1,X2,X3,X4)
    | ~ esk1427_4(X1,X2,X3,X4) ) ).

cnf(i_0_7373,axiom,
    ( ~ esk15425_4(X1,X2,X3,X4)
    | ~ esk15427_4(X1,X2,X3,X4)
    | ~ esk15445_4(X1,X2,X3,X4) ) ).

cnf(i_0_7374,axiom,
    ( ~ esk1297_4(X1,X2,X3,X4)
    | esk1555_4(X1,X2,X3,X4) ) ).

cnf(i_0_7375,axiom,
    ( ~ esk8253_4(X1,X2,X3,X4)
    | esk8252_4(X1,X2,X3,X4)
    | esk8274_4(X1,X2,X3,X4) ) ).

cnf(i_0_7376,axiom,
    ( ~ esk15534_4(X1,X2,X3,X4)
    | esk15558_4(X1,X2,X3,X4) ) ).

cnf(i_0_7377,axiom,
    ( ~ esk12099_4(X1,X2,X3,X4)
    | ~ esk12100_4(X1,X2,X3,X4) ) ).

cnf(i_0_7378,axiom,
    ( ~ esk4384_4(X1,X2,X3,X4)
    | esk4385_4(X1,X2,X3,X4) ) ).

cnf(i_0_7379,axiom,
    ( ~ esk8888_4(X1,X2,X3,X4)
    | ~ esk8837_4(X1,X2,X3,X4)
    | ~ esk8834_4(X1,X2,X3,X4)
    | ~ esk8835_4(X1,X2,X3,X4)
    | ~ esk8887_4(X1,X2,X3,X4) ) ).

cnf(i_0_7380,axiom,
    ( ~ esk14882_4(X1,X2,X3,X4)
    | esk15140_4(X1,X2,X3,X4) ) ).

cnf(i_0_7381,axiom,
    ( esk8931_4(X1,X2,X3,X4)
    | esk8948_4(X1,X2,X3,X4) ) ).

cnf(i_0_7382,axiom,
    ( esk8275_4(X1,X2,X3,X4)
    | ~ esk8223_4(X1,X2,X3,X4)
    | esk8294_4(X1,X2,X3,X4) ) ).

cnf(i_0_7383,axiom,
    ( ~ esk8534_4(X1,X2,X3,X4)
    | esk8535_4(X1,X2,X3,X4) ) ).

cnf(i_0_7384,axiom,
    ( ~ esk5540_4(X1,X2,X3,X4)
    | esk5545_4(X1,X2,X3,X4) ) ).

cnf(i_0_7385,axiom,
    ( ~ esk8424_4(X1,X2,X3,X4)
    | ~ esk8521_4(X1,X2,X3,X4)
    | ~ esk8438_4(X1,X2,X3,X4) ) ).

cnf(i_0_7386,axiom,
    ( ~ esk16330_4(X1,X2,X3,X4)
    | esk16304_4(X1,X2,X3,X4) ) ).

cnf(i_0_7387,axiom,
    ( ~ esk12516_4(X1,X2,X3,X4)
    | esk12454_4(X1,X2,X3,X4) ) ).

cnf(i_0_7388,axiom,
    ( esk4903_4(X1,X2,X3,X4)
    | esk4904_4(X1,X2,X3,X4) ) ).

cnf(i_0_7389,axiom,
    ( ~ esk6838_4(X1,X2,X3,X4)
    | ~ esk6843_4(X1,X2,X3,X4) ) ).

cnf(i_0_7390,axiom,
    ( ~ esk9206_4(X1,X2,X3,X4)
    | ~ esk9193_4(X1,X2,X3,X4)
    | ~ esk9239_4(X1,X2,X3,X4) ) ).

cnf(i_0_7391,axiom,
    ( ~ esk16217_4(X1,X2,X3,X4)
    | esk16245_4(X1,X2,X3,X4) ) ).

cnf(i_0_7392,axiom,
    ( ~ esk8236_4(X1,X2,X3,X4)
    | esk8235_4(X1,X2,X3,X4) ) ).

cnf(i_0_7393,axiom,
    ( ~ esk12890_4(X1,X2,X3,X4)
    | ~ esk12839_4(X1,X2,X3,X4)
    | ~ esk12883_4(X1,X2,X3,X4) ) ).

cnf(i_0_7394,axiom,
    ( esk936_4(X1,X2,X3,X4)
    | ~ esk937_4(X1,X2,X3,X4) ) ).

cnf(i_0_7395,axiom,
    ( esk9498_4(X1,X2,X3,X4)
    | ~ esk9380_4(X1,X2,X3,X4) ) ).

cnf(i_0_7396,axiom,
    ( ~ esk513_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X3)
    | esk236_0
    | p(X2)
    | ~ p(X4) ) ).

cnf(i_0_7397,axiom,
    ( ~ esk1286_4(X1,X2,X3,X4)
    | ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1253_4(X1,X2,X3,X4) ) ).

cnf(i_0_7398,axiom,
    ( ~ esk16622_4(X1,X2,X3,X4)
    | esk16600_4(X1,X2,X3,X4) ) ).

cnf(i_0_7399,axiom,
    ( esk517_4(X1,X2,X3,X4)
    | ~ esk264_0
    | p(X1)
    | ~ p(X2)
    | ~ p(X3)
    | ~ p(X4) ) ).

cnf(i_0_7400,axiom,
    ( esk803_4(X1,X2,X3,X4)
    | esk794_4(X1,X2,X3,X4)
    | esk802_4(X1,X2,X3,X4) ) ).

cnf(i_0_7401,axiom,
    ( ~ esk4542_4(X1,X2,X3,X4)
    | ~ esk4541_4(X1,X2,X3,X4)
    | esk4543_4(X1,X2,X3,X4) ) ).

cnf(i_0_7402,axiom,
    ( ~ esk13529_4(X1,X2,X3,X4)
    | ~ esk13528_4(X1,X2,X3,X4)
    | esk13530_4(X1,X2,X3,X4) ) ).

cnf(i_0_7403,axiom,
    ( esk16211_4(X1,X2,X3,X4)
    | esk16204_4(X1,X2,X3,X4)
    | esk16112_4(X1,X2,X3,X4) ) ).

cnf(i_0_7404,axiom,
    ( esk14847_4(X1,X2,X3,X4)
    | esk14876_4(X1,X2,X3,X4) ) ).

cnf(i_0_7405,axiom,
    ( ~ esk5046_4(X1,X2,X3,X4)
    | ~ esk5044_4(X1,X2,X3,X4) ) ).

cnf(i_0_7406,axiom,
    ( esk3779_4(X1,X2,X3,X4)
    | esk3868_4(X1,X2,X3,X4) ) ).

cnf(i_0_7407,axiom,
    ( ~ esk7326_4(X1,X2,X3,X4)
    | esk7303_4(X1,X2,X3,X4) ) ).

cnf(i_0_7408,axiom,
    ( esk2306_4(X1,X2,X3,X4)
    | ~ esk2186_4(X1,X2,X3,X4) ) ).

cnf(i_0_7409,axiom,
    ( esk15471_4(X1,X2,X3,X4)
    | ~ esk15419_4(X1,X2,X3,X4)
    | esk15490_4(X1,X2,X3,X4) ) ).

cnf(i_0_7410,axiom,
    ( esk2483_4(X1,X2,X3,X4)
    | ~ esk2482_4(X1,X2,X3,X4)
    | ~ esk2481_4(X1,X2,X3,X4) ) ).

cnf(i_0_7411,axiom,
    ( ~ esk12085_4(X1,X2,X3,X4)
    | esk12343_4(X1,X2,X3,X4) ) ).

cnf(i_0_7412,axiom,
    ( esk9279_4(X1,X2,X3,X4)
    | esk9281_4(X1,X2,X3,X4) ) ).

cnf(i_0_7413,axiom,
    ( ~ esk7717_4(X1,X2,X3,X4)
    | ~ esk7732_4(X1,X2,X3,X4) ) ).

cnf(i_0_7414,axiom,
    ( esk10493_4(X1,X2,X3,X4)
    | esk10478_4(X1,X2,X3,X4) ) ).

cnf(i_0_7415,axiom,
    ( esk12403_4(X1,X2,X3,X4)
    | ~ esk12402_4(X1,X2,X3,X4) ) ).

cnf(i_0_7416,axiom,
    ( esk6143_4(X1,X2,X3,X4)
    | esk6190_4(X1,X2,X3,X4) ) ).

cnf(i_0_7417,axiom,
    ( esk5467_4(X1,X2,X3,X4)
    | esk5424_4(X1,X2,X3,X4) ) ).

cnf(i_0_7418,axiom,
    ( ~ esk14965_4(X1,X2,X3,X4)
    | esk14928_4(X1,X2,X3,X4)
    | esk14911_4(X1,X2,X3,X4) ) ).

cnf(i_0_7419,axiom,
    ( esk2935_4(X1,X2,X3,X4)
    | ~ esk2956_4(X1,X2,X3,X4) ) ).

cnf(i_0_7420,axiom,
    ( esk2567_4(X1,X2,X3,X4)
    | ~ esk2445_4(X1,X2,X3,X4) ) ).

cnf(i_0_7421,axiom,
    ( ~ esk751_4(X1,X2,X3,X4)
    | esk709_4(X1,X2,X3,X4) ) ).

cnf(i_0_7422,axiom,
    ( esk14388_4(X1,X2,X3,X4)
    | ~ esk14646_4(X1,X2,X3,X4) ) ).

cnf(i_0_7423,axiom,
    ( ~ esk9321_4(X1,X2,X3,X4)
    | esk9319_4(X1,X2,X3,X4) ) ).

cnf(i_0_7424,axiom,
    ( ~ esk697_4(X1,X2,X3,X4)
    | esk775_4(X1,X2,X3,X4) ) ).

cnf(i_0_7425,axiom,
    ( ~ esk7857_4(X1,X2,X3,X4)
    | esk7984_4(X1,X2,X3,X4) ) ).

cnf(i_0_7426,axiom,
    ( esk7858_4(X1,X2,X3,X4)
    | ~ esk7849_4(X1,X2,X3,X4) ) ).

cnf(i_0_7427,axiom,
    ( ~ esk10480_4(X1,X2,X3,X4)
    | ~ esk10577_4(X1,X2,X3,X4)
    | ~ esk10494_4(X1,X2,X3,X4) ) ).

cnf(i_0_7428,axiom,
    ( esk4360_4(X1,X2,X3,X4)
    | ~ esk4241_4(X1,X2,X3,X4) ) ).

cnf(i_0_7429,axiom,
    ( ~ esk11353_4(X1,X2,X3,X4)
    | esk11354_4(X1,X2,X3,X4) ) ).

cnf(i_0_7430,axiom,
    ( esk11749_4(X1,X2,X3,X4)
    | esk11793_4(X1,X2,X3,X4) ) ).

cnf(i_0_7431,axiom,
    ( esk1088_4(X1,X2,X3,X4)
    | esk1001_4(X1,X2,X3,X4) ) ).

cnf(i_0_7432,axiom,
    ( ~ esk1090_4(X1,X2,X3,X4)
    | ~ esk971_4(X1,X2,X3,X4)
    | ~ esk975_4(X1,X2,X3,X4) ) ).

cnf(i_0_7433,axiom,
    ( esk14540_4(X1,X2,X3,X4)
    | ~ esk14523_4(X1,X2,X3,X4) ) ).

cnf(i_0_7434,axiom,
    ( esk1832_4(X1,X2,X3,X4)
    | esk1831_4(X1,X2,X3,X4)
    | esk1871_4(X1,X2,X3,X4)
    | esk1830_4(X1,X2,X3,X4) ) ).

cnf(i_0_7435,axiom,
    ( ~ esk9553_4(X1,X2,X3,X4)
    | esk9551_4(X1,X2,X3,X4) ) ).

cnf(i_0_7436,axiom,
    ( esk12855_4(X1,X2,X3,X4)
    | ~ esk12729_4(X1,X2,X3,X4) ) ).

cnf(i_0_7437,axiom,
    ( ~ esk14293_4(X1,X2,X3,X4)
    | esk14299_4(X1,X2,X3,X4) ) ).

cnf(i_0_7438,axiom,
    ( ~ esk6056_4(X1,X2,X3,X4)
    | esk6057_4(X1,X2,X3,X4)
    | ~ esk6062_4(X1,X2,X3,X4) ) ).

cnf(i_0_7439,axiom,
    ( esk1573_4(X1,X2,X3,X4)
    | esk1574_4(X1,X2,X3,X4)
    | esk1565_4(X1,X2,X3,X4) ) ).

cnf(i_0_7440,axiom,
    ( esk10221_4(X1,X2,X3,X4)
    | esk10254_4(X1,X2,X3,X4) ) ).

cnf(i_0_7441,axiom,
    ( esk7768_4(X1,X2,X3,X4)
    | ~ esk7717_4(X1,X2,X3,X4) ) ).

cnf(i_0_7442,axiom,
    ( ~ esk12227_4(X1,X2,X3,X4)
    | ~ esk12327_4(X1,X2,X3,X4)
    | esk12208_4(X1,X2,X3,X4) ) ).

cnf(i_0_7443,axiom,
    ( esk13935_4(X1,X2,X3,X4)
    | ~ esk13936_4(X1,X2,X3,X4)
    | esk13885_4(X1,X2,X3,X4) ) ).

cnf(i_0_7444,axiom,
    ( ~ esk2816_4(X1,X2,X3,X4)
    | ~ esk2867_4(X1,X2,X3,X4)
    | ~ esk2860_4(X1,X2,X3,X4) ) ).

cnf(i_0_7445,axiom,
    ( esk12762_4(X1,X2,X3,X4)
    | ~ esk12755_4(X1,X2,X3,X4) ) ).

cnf(i_0_7446,axiom,
    ( ~ esk7225_4(X1,X2,X3,X4)
    | ~ esk7197_4(X1,X2,X3,X4)
    | ~ esk7195_4(X1,X2,X3,X4)
    | ~ esk7223_4(X1,X2,X3,X4) ) ).

cnf(i_0_7447,axiom,
    ( ~ esk4321_4(X1,X2,X3,X4)
    | ~ esk4310_4(X1,X2,X3,X4)
    | ~ esk4354_4(X1,X2,X3,X4) ) ).

cnf(i_0_7448,axiom,
    ( ~ esk10832_4(X1,X2,X3,X4)
    | esk10857_4(X1,X2,X3,X4)
    | esk10831_4(X1,X2,X3,X4) ) ).

cnf(i_0_7449,axiom,
    ( ~ esk7053_4(X1,X2,X3,X4)
    | esk7077_4(X1,X2,X3,X4) ) ).

cnf(i_0_7450,axiom,
    ( esk5327_4(X1,X2,X3,X4)
    | esk5361_4(X1,X2,X3,X4) ) ).

cnf(i_0_7451,axiom,
    ( esk11194_4(X1,X2,X3,X4)
    | ~ esk11151_4(X1,X2,X3,X4) ) ).

cnf(i_0_7452,axiom,
    ( esk13086_4(X1,X2,X3,X4)
    | esk13053_4(X1,X2,X3,X4) ) ).

cnf(i_0_7453,axiom,
    ( ~ esk4699_4(X1,X2,X3,X4)
    | ~ esk4677_4(X1,X2,X3,X4) ) ).

cnf(i_0_7454,axiom,
    ( ~ esk14644_4(X1,X2,X3,X4)
    | esk14386_4(X1,X2,X3,X4) ) ).

cnf(i_0_7455,axiom,
    ( ~ esk397_4(X1,X2,X3,X4)
    | esk369_4(X1,X2,X3,X4) ) ).

cnf(i_0_7456,axiom,
    ( ~ esk10961_4(X1,X2,X3,X4)
    | esk10962_4(X1,X2,X3,X4) ) ).

cnf(i_0_7457,axiom,
    ( ~ esk13347_4(X1,X2,X3,X4)
    | ~ esk13428_4(X1,X2,X3,X4)
    | ~ esk13435_4(X1,X2,X3,X4) ) ).

cnf(i_0_7458,axiom,
    ( esk11936_4(X1,X2,X3,X4)
    | ~ esk11960_4(X1,X2,X3,X4) ) ).

cnf(i_0_7459,axiom,
    ( esk1739_4(X1,X2,X3,X4)
    | esk1743_4(X1,X2,X3,X4) ) ).

cnf(i_0_7460,axiom,
    ( esk5139_4(X1,X2,X3,X4)
    | esk5169_4(X1,X2,X3,X4) ) ).

cnf(i_0_7461,axiom,
    ( esk8886_4(X1,X2,X3,X4)
    | ~ esk8877_4(X1,X2,X3,X4) ) ).

cnf(i_0_7462,axiom,
    ( ~ esk4413_4(X1,X2,X3,X4)
    | esk4411_4(X1,X2,X3,X4) ) ).

cnf(i_0_7463,axiom,
    ( ~ esk8518_4(X1,X2,X3,X4)
    | ~ esk8462_4(X1,X2,X3,X4) ) ).

cnf(i_0_7464,axiom,
    ( esk10832_4(X1,X2,X3,X4)
    | esk10779_4(X1,X2,X3,X4) ) ).

cnf(i_0_7465,axiom,
    ( esk15286_4(X1,X2,X3,X4)
    | esk15285_4(X1,X2,X3,X4)
    | esk15261_4(X1,X2,X3,X4)
    | esk15283_4(X1,X2,X3,X4)
    | esk15313_4(X1,X2,X3,X4) ) ).

cnf(i_0_7466,axiom,
    ( ~ esk13165_4(X1,X2,X3,X4)
    | ~ esk13166_4(X1,X2,X3,X4)
    | esk13167_4(X1,X2,X3,X4) ) ).

cnf(i_0_7467,axiom,
    ( ~ esk11335_4(X1,X2,X3,X4)
    | ~ esk11333_4(X1,X2,X3,X4) ) ).

cnf(i_0_7468,axiom,
    ( esk14377_4(X1,X2,X3,X4)
    | ~ esk14428_4(X1,X2,X3,X4)
    | esk14457_4(X1,X2,X3,X4) ) ).

cnf(i_0_7469,axiom,
    ( ~ esk5141_4(X1,X2,X3,X4)
    | esk5167_4(X1,X2,X3,X4)
    | esk5192_4(X1,X2,X3,X4) ) ).

cnf(i_0_7470,axiom,
    ( ~ esk9435_4(X1,X2,X3,X4)
    | esk9513_4(X1,X2,X3,X4) ) ).

cnf(i_0_7471,axiom,
    ( esk8922_4(X1,X2,X3,X4)
    | ~ esk8997_4(X1,X2,X3,X4) ) ).

cnf(i_0_7472,axiom,
    ( esk2529_4(X1,X2,X3,X4)
    | esk2513_4(X1,X2,X3,X4) ) ).

cnf(i_0_7473,axiom,
    ( ~ esk8474_4(X1,X2,X3,X4)
    | esk8528_4(X1,X2,X3,X4) ) ).

cnf(i_0_7474,axiom,
    ( ~ esk3851_4(X1,X2,X3,X4)
    | esk4109_4(X1,X2,X3,X4) ) ).

cnf(i_0_7475,axiom,
    ( esk12353_4(X1,X2,X3,X4)
    | ~ esk12226_4(X1,X2,X3,X4) ) ).

cnf(i_0_7476,axiom,
    ( esk4897_4(X1,X2,X3,X4)
    | ~ esk4899_4(X1,X2,X3,X4)
    | esk4898_4(X1,X2,X3,X4) ) ).

cnf(i_0_7477,axiom,
    ( ~ esk5296_4(X1,X2,X3,X4)
    | ~ esk5295_4(X1,X2,X3,X4) ) ).

cnf(i_0_7478,axiom,
    ( ~ esk10269_4(X1,X2,X3,X4)
    | ~ esk10313_4(X1,X2,X3,X4)
    | ~ esk10320_4(X1,X2,X3,X4) ) ).

cnf(i_0_7479,axiom,
    ( ~ p(X4)
    | p(X1)
    | ~ p(X3)
    | p(X2)
    | ~ esk16703_4(X1,X2,X3,X4)
    | esk231_0 ) ).

cnf(i_0_7480,axiom,
    ( esk7663_4(X1,X2,X3,X4)
    | esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_7481,axiom,
    ( ~ esk9676_4(X1,X2,X3,X4)
    | esk9677_4(X1,X2,X3,X4) ) ).

cnf(i_0_7482,axiom,
    ( esk3200_4(X1,X2,X3,X4)
    | esk3231_4(X1,X2,X3,X4)
    | ~ esk3351_4(X1,X2,X3,X4) ) ).

cnf(i_0_7483,axiom,
    ( ~ esk13357_4(X1,X2,X3,X4)
    | esk13411_4(X1,X2,X3,X4) ) ).

cnf(i_0_7484,axiom,
    ( ~ esk7957_4(X1,X2,X3,X4)
    | esk7900_4(X1,X2,X3,X4) ) ).

cnf(i_0_7485,axiom,
    ( esk3057_4(X1,X2,X3,X4)
    | esk3144_4(X1,X2,X3,X4) ) ).

cnf(i_0_7486,axiom,
    ( ~ esk13877_4(X1,X2,X3,X4)
    | ~ esk13948_4(X1,X2,X3,X4)
    | ~ esk13929_4(X1,X2,X3,X4) ) ).

cnf(i_0_7487,axiom,
    ( esk10275_4(X1,X2,X3,X4)
    | ~ esk10017_4(X1,X2,X3,X4) ) ).

cnf(i_0_7488,axiom,
    ( esk1562_4(X1,X2,X3,X4)
    | esk1563_4(X1,X2,X3,X4) ) ).

cnf(i_0_7489,axiom,
    ( ~ esk971_4(X1,X2,X3,X4)
    | ~ esk1084_4(X1,X2,X3,X4)
    | ~ esk999_4(X1,X2,X3,X4) ) ).

cnf(i_0_7490,axiom,
    ( esk13819_4(X1,X2,X3,X4)
    | esk13824_4(X1,X2,X3,X4) ) ).

cnf(i_0_7491,axiom,
    ( ~ esk9235_4(X1,X2,X3,X4)
    | ~ esk9323_4(X1,X2,X3,X4)
    | ~ esk9316_4(X1,X2,X3,X4) ) ).

cnf(i_0_7492,axiom,
    ( esk2802_4(X1,X2,X3,X4)
    | esk2770_4(X1,X2,X3,X4) ) ).

cnf(i_0_7493,axiom,
    ( ~ esk15713_4(X1,X2,X3,X4)
    | ~ esk15662_4(X1,X2,X3,X4)
    | ~ esk15742_4(X1,X2,X3,X4) ) ).

cnf(i_0_7494,axiom,
    ( esk12078_4(X1,X2,X3,X4)
    | esk12045_4(X1,X2,X3,X4) ) ).

cnf(i_0_7495,axiom,
    ( esk7119_4(X1,X2,X3,X4)
    | ~ esk7057_4(X1,X2,X3,X4) ) ).

cnf(i_0_7496,axiom,
    ( ~ esk8263_4(X1,X2,X3,X4)
    | ~ esk8203_4(X1,X2,X3,X4)
    | ~ esk8286_4(X1,X2,X3,X4) ) ).

cnf(i_0_7497,axiom,
    ( esk16594_4(X1,X2,X3,X4)
    | ~ esk16574_4(X1,X2,X3,X4) ) ).

cnf(i_0_7498,axiom,
    ( ~ esk15560_4(X1,X2,X3,X4)
    | esk15532_4(X1,X2,X3,X4) ) ).

cnf(i_0_7499,axiom,
    ( esk3894_4(X1,X2,X3,X4)
    | esk3893_4(X1,X2,X3,X4)
    | esk3892_4(X1,X2,X3,X4) ) ).

cnf(i_0_7500,axiom,
    ( esk3784_4(X1,X2,X3,X4)
    | esk3821_4(X1,X2,X3,X4) ) ).

cnf(i_0_7501,axiom,
    ( esk9452_4(X1,X2,X3,X4)
    | esk9456_4(X1,X2,X3,X4) ) ).

cnf(i_0_7502,axiom,
    ( ~ esk16170_4(X1,X2,X3,X4)
    | esk15912_4(X1,X2,X3,X4) ) ).

cnf(i_0_7503,axiom,
    ( ~ esk4773_4(X1,X2,X3,X4)
    | ~ esk4891_4(X1,X2,X3,X4) ) ).

cnf(i_0_7504,axiom,
    ( esk4522_4(X1,X2,X3,X4)
    | esk4531_4(X1,X2,X3,X4) ) ).

cnf(i_0_7505,axiom,
    ( esk4165_4(X1,X2,X3,X4)
    | esk4137_4(X1,X2,X3,X4) ) ).

cnf(i_0_7506,axiom,
    ( ~ esk4728_4(X1,X2,X3,X4)
    | esk4761_4(X1,X2,X3,X4) ) ).

cnf(i_0_7507,axiom,
    ( ~ esk11595_4(X1,X2,X3,X4)
    | esk11560_4(X1,X2,X3,X4)
    | esk11614_4(X1,X2,X3,X4) ) ).

cnf(i_0_7508,axiom,
    ( ~ esk9143_4(X1,X2,X3,X4)
    | esk9119_4(X1,X2,X3,X4) ) ).

cnf(i_0_7509,axiom,
    ( esk2869_4(X1,X2,X3,X4)
    | ~ esk2868_4(X1,X2,X3,X4) ) ).

cnf(i_0_7510,axiom,
    ( esk1007_4(X1,X2,X3,X4)
    | esk1067_4(X1,X2,X3,X4)
    | ~ esk1090_4(X1,X2,X3,X4) ) ).

cnf(i_0_7511,axiom,
    ( esk1313_4(X1,X2,X3,X4)
    | esk1282_4(X1,X2,X3,X4) ) ).

cnf(i_0_7512,axiom,
    ( ~ esk16606_4(X1,X2,X3,X4)
    | esk16348_4(X1,X2,X3,X4) ) ).

cnf(i_0_7513,axiom,
    ( esk1061_4(X1,X2,X3,X4)
    | esk1017_4(X1,X2,X3,X4)
    | ~ esk1068_4(X1,X2,X3,X4) ) ).

cnf(i_0_7514,axiom,
    ( ~ esk8725_4(X1,X2,X3,X4)
    | ~ esk8629_4(X1,X2,X3,X4)
    | esk8623_4(X1,X2,X3,X4) ) ).

cnf(i_0_7515,axiom,
    ( ~ esk5588_4(X1,X2,X3,X4)
    | ~ esk5610_4(X1,X2,X3,X4)
    | ~ esk5611_4(X1,X2,X3,X4) ) ).

cnf(i_0_7516,axiom,
    ( esk10540_4(X1,X2,X3,X4)
    | ~ esk10415_4(X1,X2,X3,X4) ) ).

cnf(i_0_7517,axiom,
    ( esk2845_4(X1,X2,X3,X4)
    | ~ esk2846_4(X1,X2,X3,X4) ) ).

cnf(i_0_7518,axiom,
    ( ~ esk10642_4(X1,X2,X3,X4)
    | esk10669_4(X1,X2,X3,X4) ) ).

cnf(i_0_7519,axiom,
    ( esk8641_4(X1,X2,X3,X4)
    | ~ esk8625_4(X1,X2,X3,X4) ) ).

cnf(i_0_7520,axiom,
    ( esk8186_4(X1,X2,X3,X4)
    | esk8219_4(X1,X2,X3,X4) ) ).

cnf(i_0_7521,axiom,
    ( p(X2)
    | p(X3)
    | esk288_0
    | p(X1)
    | p(X4)
    | ~ esk16711_4(X1,X2,X3,X4) ) ).

cnf(i_0_7522,axiom,
    ( ~ esk5681_4(X1,X2,X3,X4)
    | ~ esk5680_4(X1,X2,X3,X4) ) ).

cnf(i_0_7523,axiom,
    ( esk15886_4(X1,X2,X3,X4)
    | esk15870_4(X1,X2,X3,X4) ) ).

cnf(i_0_7524,axiom,
    ( esk15568_4(X1,X2,X3,X4)
    | ~ esk15549_4(X1,X2,X3,X4) ) ).

cnf(i_0_7525,axiom,
    ( esk5392_4(X1,X2,X3,X4)
    | esk5359_4(X1,X2,X3,X4) ) ).

cnf(i_0_7526,axiom,
    ( esk16174_4(X1,X2,X3,X4)
    | esk16229_4(X1,X2,X3,X4) ) ).

cnf(i_0_7527,axiom,
    ( ~ esk5639_4(X1,X2,X3,X4)
    | esk5381_4(X1,X2,X3,X4) ) ).

cnf(i_0_7528,axiom,
    ( ~ esk7232_4(X1,X2,X3,X4)
    | ~ esk7181_4(X1,X2,X3,X4)
    | ~ esk7267_4(X1,X2,X3,X4) ) ).

cnf(i_0_7529,axiom,
    ( esk3112_4(X1,X2,X3,X4)
    | esk3081_4(X1,X2,X3,X4) ) ).

cnf(i_0_7530,axiom,
    ( esk11477_4(X1,X2,X3,X4)
    | ~ esk11478_4(X1,X2,X3,X4) ) ).

cnf(i_0_7531,axiom,
    ( esk1533_4(X1,X2,X3,X4)
    | esk1500_4(X1,X2,X3,X4) ) ).

cnf(i_0_7532,axiom,
    ( ~ esk4215_4(X1,X2,X3,X4)
    | esk4246_4(X1,X2,X3,X4) ) ).

cnf(i_0_7533,axiom,
    ( ~ esk4550_4(X1,X2,X3,X4)
    | ~ esk4639_4(X1,X2,X3,X4) ) ).

cnf(i_0_7534,axiom,
    ( esk3374_4(X1,X2,X3,X4)
    | ~ esk3381_4(X1,X2,X3,X4)
    | esk3330_4(X1,X2,X3,X4) ) ).

cnf(i_0_7535,axiom,
    ( esk517_4(X1,X2,X3,X4)
    | esk540_4(X1,X2,X3,X4) ) ).

cnf(i_0_7536,axiom,
    ( ~ esk9054_4(X1,X2,X3,X4)
    | esk9017_4(X1,X2,X3,X4)
    | esk9000_4(X1,X2,X3,X4) ) ).

cnf(i_0_7537,axiom,
    ( ~ esk10633_4(X1,X2,X3,X4)
    | ~ esk10636_4(X1,X2,X3,X4)
    | ~ esk10634_4(X1,X2,X3,X4)
    | ~ esk10686_4(X1,X2,X3,X4)
    | ~ esk10687_4(X1,X2,X3,X4) ) ).

cnf(i_0_7538,axiom,
    ( ~ esk7950_4(X1,X2,X3,X4)
    | ~ esk8031_4(X1,X2,X3,X4)
    | ~ esk8038_4(X1,X2,X3,X4) ) ).

cnf(i_0_7539,axiom,
    ( esk3483_4(X1,X2,X3,X4)
    | ~ esk3451_4(X1,X2,X3,X4) ) ).

cnf(i_0_7540,axiom,
    ( esk3527_4(X1,X2,X3,X4)
    | esk3564_4(X1,X2,X3,X4) ) ).

cnf(i_0_7541,axiom,
    ( esk4129_4(X1,X2,X3,X4)
    | ~ esk3972_4(X1,X2,X3,X4) ) ).

cnf(i_0_7542,axiom,
    ( esk7501_4(X1,X2,X3,X4)
    | esk7414_4(X1,X2,X3,X4) ) ).

cnf(i_0_7543,axiom,
    ( ~ esk12804_4(X1,X2,X3,X4)
    | ~ esk12805_4(X1,X2,X3,X4)
    | ~ esk12785_4(X1,X2,X3,X4) ) ).

cnf(i_0_7544,axiom,
    ( esk2599_4(X1,X2,X3,X4)
    | esk2620_4(X1,X2,X3,X4)
    | ~ esk2598_4(X1,X2,X3,X4) ) ).

cnf(i_0_7545,axiom,
    ( esk6118_4(X1,X2,X3,X4)
    | esk6151_4(X1,X2,X3,X4) ) ).

cnf(i_0_7546,axiom,
    ( esk15215_4(X1,X2,X3,X4)
    | esk15164_4(X1,X2,X3,X4)
    | ~ esk15190_4(X1,X2,X3,X4) ) ).

cnf(i_0_7547,axiom,
    ( esk2975_4(X1,X2,X3,X4)
    | ~ esk2959_4(X1,X2,X3,X4) ) ).

cnf(i_0_7548,axiom,
    ( esk13590_4(X1,X2,X3,X4)
    | esk13564_4(X1,X2,X3,X4) ) ).

cnf(i_0_7549,axiom,
    ( esk14194_4(X1,X2,X3,X4)
    | ~ esk14140_4(X1,X2,X3,X4) ) ).

cnf(i_0_7550,axiom,
    ( ~ esk4506_4(X1,X2,X3,X4)
    | esk4517_4(X1,X2,X3,X4) ) ).

cnf(i_0_7551,axiom,
    ( esk2567_4(X1,X2,X3,X4)
    | esk2598_4(X1,X2,X3,X4) ) ).

cnf(i_0_7552,axiom,
    ( ~ esk13634_4(X1,X2,X3,X4)
    | ~ esk13542_4(X1,X2,X3,X4) ) ).

cnf(i_0_7553,axiom,
    ( esk2314_4(X1,X2,X3,X4)
    | esk2340_4(X1,X2,X3,X4)
    | ~ esk2365_4(X1,X2,X3,X4) ) ).

cnf(i_0_7554,axiom,
    ( esk2266_4(X1,X2,X3,X4)
    | esk2256_4(X1,X2,X3,X4) ) ).

cnf(i_0_7555,axiom,
    ( ~ esk16648_4(X1,X2,X3,X4)
    | ~ esk16749_4(X1,X2,X3,X4)
    | ~ esk16664_4(X1,X2,X3,X4) ) ).

cnf(i_0_7556,axiom,
    ( esk10432_4(X1,X2,X3,X4)
    | ~ esk10454_4(X1,X2,X3,X4) ) ).

cnf(i_0_7557,axiom,
    ( esk1278_4(X1,X2,X3,X4)
    | esk1245_4(X1,X2,X3,X4) ) ).

cnf(i_0_7558,axiom,
    ( esk8936_4(X1,X2,X3,X4)
    | esk8969_4(X1,X2,X3,X4) ) ).

cnf(i_0_7559,axiom,
    ( ~ esk6686_4(X1,X2,X3,X4)
    | esk6608_4(X1,X2,X3,X4) ) ).

cnf(i_0_7560,axiom,
    ( esk4055_4(X1,X2,X3,X4)
    | esk4075_4(X1,X2,X3,X4) ) ).

cnf(i_0_7561,axiom,
    ( esk9294_4(X1,X2,X3,X4)
    | ~ esk9293_4(X1,X2,X3,X4) ) ).

cnf(i_0_7562,axiom,
    ( esk3095_4(X1,X2,X3,X4)
    | ~ esk3096_4(X1,X2,X3,X4) ) ).

cnf(i_0_7563,axiom,
    ( esk8551_4(X1,X2,X3,X4)
    | esk8480_4(X1,X2,X3,X4)
    | ~ esk8532_4(X1,X2,X3,X4) ) ).

cnf(i_0_7564,axiom,
    ( ~ esk1581_4(X1,X2,X3,X4)
    | ~ esk1580_4(X1,X2,X3,X4) ) ).

cnf(i_0_7565,axiom,
    ( ~ esk714_4(X1,X2,X3,X4)
    | ~ esk831_4(X1,X2,X3,X4)
    | ~ esk744_4(X1,X2,X3,X4) ) ).

cnf(i_0_7566,axiom,
    ( ~ esk9992_4(X1,X2,X3,X4)
    | ~ esk10075_4(X1,X2,X3,X4)
    | ~ esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_7567,axiom,
    ( ~ esk8422_4(X1,X2,X3,X4)
    | ~ esk8470_4(X1,X2,X3,X4)
    | ~ esk8437_4(X1,X2,X3,X4) ) ).

cnf(i_0_7568,axiom,
    ( ~ esk9233_4(X1,X2,X3,X4)
    | ~ esk9143_4(X1,X2,X3,X4)
    | esk9134_4(X1,X2,X3,X4) ) ).

cnf(i_0_7569,axiom,
    ( esk15330_4(X1,X2,X3,X4)
    | esk15325_4(X1,X2,X3,X4) ) ).

cnf(i_0_7570,axiom,
    ( esk1311_4(X1,X2,X3,X4)
    | esk1288_4(X1,X2,X3,X4) ) ).

cnf(i_0_7571,axiom,
    ( esk10979_4(X1,X2,X3,X4)
    | ~ esk11051_4(X1,X2,X3,X4) ) ).

cnf(i_0_7572,axiom,
    ( esk10186_4(X1,X2,X3,X4)
    | esk10181_4(X1,X2,X3,X4)
    | ~ esk10187_4(X1,X2,X3,X4) ) ).

cnf(i_0_7573,axiom,
    ( esk784_4(X1,X2,X3,X4)
    | esk695_4(X1,X2,X3,X4) ) ).

cnf(i_0_7574,axiom,
    ( esk14797_4(X1,X2,X3,X4)
    | ~ esk14778_4(X1,X2,X3,X4) ) ).

cnf(i_0_7575,axiom,
    ( ~ esk16204_4(X1,X2,X3,X4)
    | esk15946_4(X1,X2,X3,X4) ) ).

cnf(i_0_7576,axiom,
    ( ~ esk5398_4(X1,X2,X3,X4)
    | ~ esk5467_4(X1,X2,X3,X4)
    | ~ esk5424_4(X1,X2,X3,X4) ) ).

cnf(i_0_7577,axiom,
    ( esk7738_4(X1,X2,X3,X4)
    | esk7707_4(X1,X2,X3,X4) ) ).

cnf(i_0_7578,axiom,
    ( ~ esk9894_4(X1,X2,X3,X4)
    | esk10012_4(X1,X2,X3,X4) ) ).

cnf(i_0_7579,axiom,
    ( ~ esk7980_4(X1,X2,X3,X4)
    | ~ esk7891_4(X1,X2,X3,X4) ) ).

cnf(i_0_7580,axiom,
    ( esk13143_4(X1,X2,X3,X4)
    | esk13178_4(X1,X2,X3,X4) ) ).

cnf(i_0_7581,axiom,
    ( esk6717_4(X1,X2,X3,X4)
    | ~ esk6749_4(X1,X2,X3,X4)
    | esk6748_4(X1,X2,X3,X4) ) ).

cnf(i_0_7582,axiom,
    ( ~ esk12486_4(X1,X2,X3,X4)
    | ~ esk12434_4(X1,X2,X3,X4) ) ).

cnf(i_0_7583,axiom,
    ( ~ esk13125_4(X1,X2,X3,X4)
    | esk13123_4(X1,X2,X3,X4) ) ).

cnf(i_0_7584,axiom,
    ( ~ esk7181_4(X1,X2,X3,X4)
    | esk7080_4(X1,X2,X3,X4)
    | ~ esk7087_4(X1,X2,X3,X4) ) ).

cnf(i_0_7585,axiom,
    ( ~ esk9288_4(X1,X2,X3,X4)
    | ~ esk9287_4(X1,X2,X3,X4) ) ).

cnf(i_0_7586,axiom,
    ( esk3309_4(X1,X2,X3,X4)
    | esk3342_4(X1,X2,X3,X4) ) ).

cnf(i_0_7587,axiom,
    ( ~ p(X1)
    | esk534_4(X1,X2,X3,X4)
    | p(X4)
    | ~ p(X2)
    | ~ p(X3)
    | ~ esk331_0 ) ).

cnf(i_0_7588,axiom,
    ( esk6326_4(X1,X2,X3,X4)
    | ~ esk6068_4(X1,X2,X3,X4) ) ).

cnf(i_0_7589,axiom,
    ( esk11235_4(X1,X2,X3,X4)
    | ~ esk11310_4(X1,X2,X3,X4) ) ).

cnf(i_0_7590,axiom,
    ( ~ esk13745_4(X1,X2,X3,X4)
    | ~ esk13768_4(X1,X2,X3,X4) ) ).

cnf(i_0_7591,axiom,
    ( ~ esk12342_4(X1,X2,X3,X4)
    | esk12600_4(X1,X2,X3,X4) ) ).

cnf(i_0_7592,axiom,
    ( esk11351_4(X1,X2,X3,X4)
    | ~ esk11380_4(X1,X2,X3,X4) ) ).

cnf(i_0_7593,axiom,
    ( ~ esk10532_4(X1,X2,X3,X4)
    | ~ esk10567_4(X1,X2,X3,X4)
    | ~ esk10568_4(X1,X2,X3,X4) ) ).

cnf(i_0_7594,axiom,
    ( ~ p(X1)
    | ~ p(X2)
    | ~ esk509_4(X1,X2,X3,X4)
    | esk211_0
    | p(X4)
    | ~ p(X3) ) ).

cnf(i_0_7595,axiom,
    ( ~ esk8510_4(X1,X2,X3,X4)
    | ~ esk8531_4(X1,X2,X3,X4)
    | ~ esk8509_4(X1,X2,X3,X4) ) ).

cnf(i_0_7596,axiom,
    ( ~ esk6240_4(X1,X2,X3,X4)
    | ~ esk6201_4(X1,X2,X3,X4) ) ).

cnf(i_0_7597,axiom,
    ( esk3745_4(X1,X2,X3,X4)
    | esk3863_4(X1,X2,X3,X4) ) ).

cnf(i_0_7598,axiom,
    ( ~ esk1323_4(X1,X2,X3,X4)
    | ~ esk1348_4(X1,X2,X3,X4)
    | ~ esk1322_4(X1,X2,X3,X4) ) ).

cnf(i_0_7599,axiom,
    ( esk2266_4(X1,X2,X3,X4)
    | esk2249_4(X1,X2,X3,X4) ) ).

cnf(i_0_7600,axiom,
    ( esk8596_4(X1,X2,X3,X4)
    | ~ esk8618_4(X1,X2,X3,X4) ) ).

cnf(i_0_7601,axiom,
    ( ~ esk2976_4(X1,X2,X3,X4)
    | ~ esk2977_4(X1,X2,X3,X4)
    | ~ esk2923_4(X1,X2,X3,X4)
    | ~ esk2924_4(X1,X2,X3,X4)
    | ~ esk2926_4(X1,X2,X3,X4) ) ).

cnf(i_0_7602,axiom,
    ( ~ esk13000_4(X1,X2,X3,X4)
    | ~ esk12972_4(X1,X2,X3,X4) ) ).

cnf(i_0_7603,axiom,
    ( esk2254_4(X1,X2,X3,X4)
    | esk2261_4(X1,X2,X3,X4) ) ).

cnf(i_0_7604,axiom,
    ( ~ esk541_4(X1,X2,X3,X4)
    | ~ esk540_4(X1,X2,X3,X4) ) ).

cnf(i_0_7605,axiom,
    ( ~ esk13625_4(X1,X2,X3,X4)
    | esk13547_4(X1,X2,X3,X4) ) ).

cnf(i_0_7606,axiom,
    ( ~ esk11627_4(X1,X2,X3,X4)
    | ~ esk11604_4(X1,X2,X3,X4)
    | ~ esk11544_4(X1,X2,X3,X4) ) ).

cnf(i_0_7607,axiom,
    ( ~ esk6538_4(X1,X2,X3,X4)
    | esk6564_4(X1,X2,X3,X4) ) ).

cnf(i_0_7608,axiom,
    ( esk13110_4(X1,X2,X3,X4)
    | esk13133_4(X1,X2,X3,X4) ) ).

cnf(i_0_7609,axiom,
    ( ~ esk14271_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4) ) ).

cnf(i_0_7610,axiom,
    ( esk11239_4(X1,X2,X3,X4)
    | esk11270_4(X1,X2,X3,X4) ) ).

cnf(i_0_7611,axiom,
    ( esk7858_4(X1,X2,X3,X4)
    | ~ esk7842_4(X1,X2,X3,X4) ) ).

cnf(i_0_7612,axiom,
    ( esk4727_4(X1,X2,X3,X4)
    | ~ esk4762_4(X1,X2,X3,X4) ) ).

cnf(i_0_7613,axiom,
    ( ~ esk12092_4(X1,X2,X3,X4)
    | esk12088_4(X1,X2,X3,X4) ) ).

cnf(i_0_7614,axiom,
    ( esk15826_4(X1,X2,X3,X4)
    | esk15774_4(X1,X2,X3,X4) ) ).

cnf(i_0_7615,axiom,
    ( esk2790_4(X1,X2,X3,X4)
    | esk2876_4(X1,X2,X3,X4) ) ).

cnf(i_0_7616,axiom,
    ( esk2676_4(X1,X2,X3,X4)
    | ~ esk2701_4(X1,X2,X3,X4) ) ).

cnf(i_0_7617,axiom,
    ( ~ esk1680_4(X1,X2,X3,X4)
    | esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_7618,axiom,
    ( esk3798_4(X1,X2,X3,X4)
    | esk3830_4(X1,X2,X3,X4) ) ).

cnf(i_0_7619,axiom,
    ( esk2202_4(X1,X2,X3,X4)
    | ~ esk2201_4(X1,X2,X3,X4)
    | ~ esk2207_4(X1,X2,X3,X4) ) ).

cnf(i_0_7620,axiom,
    ( esk2079_4(X1,X2,X3,X4)
    | esk2097_4(X1,X2,X3,X4) ) ).

cnf(i_0_7621,axiom,
    ( ~ esk5922_4(X1,X2,X3,X4)
    | esk5923_4(X1,X2,X3,X4) ) ).

cnf(i_0_7622,axiom,
    ( esk9928_4(X1,X2,X3,X4)
    | esk9927_4(X1,X2,X3,X4)
    | esk9922_4(X1,X2,X3,X4) ) ).

cnf(i_0_7623,axiom,
    ( esk14169_4(X1,X2,X3,X4)
    | esk14124_4(X1,X2,X3,X4) ) ).

cnf(i_0_7624,axiom,
    ( ~ esk13011_4(X1,X2,X3,X4)
    | ~ esk13012_4(X1,X2,X3,X4) ) ).

cnf(i_0_7625,axiom,
    ( ~ esk10417_4(X1,X2,X3,X4)
    | esk10395_4(X1,X2,X3,X4) ) ).

cnf(i_0_7626,axiom,
    ( ~ esk517_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X3)
    | esk260_0
    | ~ p(X4)
    | p(X1) ) ).

cnf(i_0_7627,axiom,
    ( esk11265_4(X1,X2,X3,X4)
    | esk11348_4(X1,X2,X3,X4) ) ).

cnf(i_0_7628,axiom,
    ( p(X1)
    | ~ esk275_0
    | esk519_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X3)
    | p(X2) ) ).

cnf(i_0_7629,axiom,
    ( esk5402_4(X1,X2,X3,X4)
    | esk5369_4(X1,X2,X3,X4) ) ).

cnf(i_0_7630,axiom,
    ( ~ esk7606_4(X1,X2,X3,X4)
    | esk7348_4(X1,X2,X3,X4) ) ).

cnf(i_0_7631,axiom,
    ( esk7683_4(X1,X2,X3,X4)
    | esk7653_4(X1,X2,X3,X4) ) ).

cnf(i_0_7632,axiom,
    ( esk301_0
    | p(X3)
    | ~ p(X4)
    | ~ p(X2)
    | ~ p(X1)
    | ~ esk16711_4(X1,X2,X3,X4) ) ).

cnf(i_0_7633,axiom,
    ( esk6639_4(X1,X2,X3,X4)
    | esk6625_4(X1,X2,X3,X4) ) ).

cnf(i_0_7634,axiom,
    ( esk9143_4(X1,X2,X3,X4)
    | ~ esk9125_4(X1,X2,X3,X4) ) ).

cnf(i_0_7635,axiom,
    ( ~ esk9183_4(X1,X2,X3,X4)
    | esk9246_4(X1,X2,X3,X4) ) ).

cnf(i_0_7636,axiom,
    ( esk15870_4(X1,X2,X3,X4)
    | ~ esk15918_4(X1,X2,X3,X4) ) ).

cnf(i_0_7637,axiom,
    ( ~ esk1672_4(X1,X2,X3,X4)
    | esk1649_4(X1,X2,X3,X4) ) ).

cnf(i_0_7638,axiom,
    ( ~ esk2055_4(X1,X2,X3,X4)
    | ~ esk2107_4(X1,X2,X3,X4)
    | ~ esk2126_4(X1,X2,X3,X4) ) ).

cnf(i_0_7639,axiom,
    ( esk6059_4(X1,X2,X3,X4)
    | ~ esk6048_4(X1,X2,X3,X4) ) ).

cnf(i_0_7640,axiom,
    ( ~ esk405_4(X1,X2,X3,X4)
    | ~ esk499_4(X1,X2,X3,X4)
    | esk398_4(X1,X2,X3,X4) ) ).

cnf(i_0_7641,axiom,
    ( esk320_0
    | ~ p(X3)
    | p(X2)
    | ~ esk16724_4(X1,X2,X3,X4)
    | p(X4)
    | p(X1) ) ).

cnf(i_0_7642,axiom,
    ( ~ esk10729_4(X1,X2,X3,X4)
    | esk10780_4(X1,X2,X3,X4) ) ).

cnf(i_0_7643,axiom,
    ( ~ esk647_4(X1,X2,X3,X4)
    | esk770_4(X1,X2,X3,X4) ) ).

cnf(i_0_7644,axiom,
    ( ~ esk12600_4(X1,X2,X3,X4)
    | esk12342_4(X1,X2,X3,X4) ) ).

cnf(i_0_7645,axiom,
    ( ~ esk15082_4(X1,X2,X3,X4)
    | esk15078_4(X1,X2,X3,X4) ) ).

cnf(i_0_7646,axiom,
    ( esk14307_4(X1,X2,X3,X4)
    | ~ esk14309_4(X1,X2,X3,X4) ) ).

cnf(i_0_7647,axiom,
    ( esk12526_4(X1,X2,X3,X4)
    | esk12552_4(X1,X2,X3,X4) ) ).

cnf(i_0_7648,axiom,
    ( ~ esk408_4(X1,X2,X3,X4)
    | ~ esk406_4(X1,X2,X3,X4) ) ).

cnf(i_0_7649,axiom,
    ( ~ esk15877_4(X1,X2,X3,X4)
    | ~ esk15876_4(X1,X2,X3,X4) ) ).

cnf(i_0_7650,axiom,
    ( esk9964_4(X1,X2,X3,X4)
    | esk9981_4(X1,X2,X3,X4) ) ).

cnf(i_0_7651,axiom,
    ( ~ esk10556_4(X1,X2,X3,X4)
    | esk10555_4(X1,X2,X3,X4) ) ).

cnf(i_0_7652,axiom,
    ( ~ esk1676_4(X1,X2,X3,X4)
    | esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_7653,axiom,
    ( ~ esk12987_4(X1,X2,X3,X4)
    | esk13084_4(X1,X2,X3,X4) ) ).

cnf(i_0_7654,axiom,
    ( esk1185_4(X1,X2,X3,X4)
    | ~ esk1443_4(X1,X2,X3,X4) ) ).

cnf(i_0_7655,axiom,
    ( ~ esk2856_4(X1,X2,X3,X4)
    | ~ esk2857_4(X1,X2,X3,X4) ) ).

cnf(i_0_7656,axiom,
    ( esk5883_4(X1,X2,X3,X4)
    | esk5852_4(X1,X2,X3,X4) ) ).

cnf(i_0_7657,axiom,
    ( esk1512_4(X1,X2,X3,X4)
    | esk1469_4(X1,X2,X3,X4) ) ).

cnf(i_0_7658,axiom,
    ( esk9699_4(X1,X2,X3,X4)
    | esk9725_4(X1,X2,X3,X4) ) ).

cnf(i_0_7659,axiom,
    ( esk3342_4(X1,X2,X3,X4)
    | esk3411_4(X1,X2,X3,X4) ) ).

cnf(i_0_7660,axiom,
    ( esk12286_4(X1,X2,X3,X4)
    | esk12273_4(X1,X2,X3,X4) ) ).

cnf(i_0_7661,axiom,
    ( ~ esk6327_4(X1,X2,X3,X4)
    | ~ esk6328_4(X1,X2,X3,X4) ) ).

cnf(i_0_7662,axiom,
    ( esk15672_4(X1,X2,X3,X4)
    | ~ esk15414_4(X1,X2,X3,X4) ) ).

cnf(i_0_7663,axiom,
    ( esk6873_4(X1,X2,X3,X4)
    | ~ esk6927_4(X1,X2,X3,X4) ) ).

cnf(i_0_7664,axiom,
    ( esk11971_4(X1,X2,X3,X4)
    | esk11921_4(X1,X2,X3,X4) ) ).

cnf(i_0_7665,axiom,
    ( esk4428_4(X1,X2,X3,X4)
    | ~ esk4391_4(X1,X2,X3,X4) ) ).

cnf(i_0_7666,axiom,
    ( ~ esk6879_4(X1,X2,X3,X4)
    | ~ esk6883_4(X1,X2,X3,X4)
    | ~ esk6884_4(X1,X2,X3,X4) ) ).

cnf(i_0_7667,axiom,
    ( ~ esk14038_4(X1,X2,X3,X4)
    | ~ esk14037_4(X1,X2,X3,X4) ) ).

cnf(i_0_7668,axiom,
    ( esk1574_4(X1,X2,X3,X4)
    | esk1535_4(X1,X2,X3,X4) ) ).

cnf(i_0_7669,axiom,
    ( ~ esk15984_4(X1,X2,X3,X4)
    | ~ esk15963_4(X1,X2,X3,X4)
    | ~ esk15962_4(X1,X2,X3,X4) ) ).

cnf(i_0_7670,axiom,
    ( esk5052_4(X1,X2,X3,X4)
    | ~ esk5053_4(X1,X2,X3,X4) ) ).

cnf(i_0_7671,axiom,
    ( ~ esk6673_4(X1,X2,X3,X4)
    | esk6724_4(X1,X2,X3,X4) ) ).

cnf(i_0_7672,axiom,
    ( esk4805_4(X1,X2,X3,X4)
    | ~ esk4753_4(X1,X2,X3,X4) ) ).

cnf(i_0_7673,axiom,
    ( esk9153_4(X1,X2,X3,X4)
    | esk9154_4(X1,X2,X3,X4) ) ).

cnf(i_0_7674,axiom,
    ( esk9557_4(X1,X2,X3,X4)
    | esk9470_4(X1,X2,X3,X4) ) ).

cnf(i_0_7675,axiom,
    ( esk8038_4(X1,X2,X3,X4)
    | esk7950_4(X1,X2,X3,X4)
    | ~ esk8031_4(X1,X2,X3,X4) ) ).

cnf(i_0_7676,axiom,
    ( ~ esk13792_4(X1,X2,X3,X4)
    | esk13793_4(X1,X2,X3,X4) ) ).

cnf(i_0_7677,axiom,
    ( ~ esk1817_4(X1,X2,X3,X4)
    | esk1816_4(X1,X2,X3,X4) ) ).

cnf(i_0_7678,axiom,
    ( ~ esk13617_4(X1,X2,X3,X4)
    | esk13875_4(X1,X2,X3,X4) ) ).

cnf(i_0_7679,axiom,
    ( ~ esk1170_4(X1,X2,X3,X4)
    | esk1138_4(X1,X2,X3,X4) ) ).

cnf(i_0_7680,axiom,
    ( ~ esk15991_4(X1,X2,X3,X4)
    | esk15992_4(X1,X2,X3,X4) ) ).

cnf(i_0_7681,axiom,
    ( esk15107_4(X1,X2,X3,X4)
    | esk15140_4(X1,X2,X3,X4) ) ).

cnf(i_0_7682,axiom,
    ( esk16719_4(X1,X2,X3,X4)
    | esk16726_4(X1,X2,X3,X4) ) ).

cnf(i_0_7683,axiom,
    ( ~ esk15397_4(X1,X2,X3,X4)
    | esk15139_4(X1,X2,X3,X4) ) ).

cnf(i_0_7684,axiom,
    ( esk8457_4(X1,X2,X3,X4)
    | ~ esk8715_4(X1,X2,X3,X4) ) ).

cnf(i_0_7685,axiom,
    ( ~ esk5100_4(X1,X2,X3,X4)
    | ~ esk5081_4(X1,X2,X3,X4)
    | ~ esk5133_4(X1,X2,X3,X4) ) ).

cnf(i_0_7686,axiom,
    ( esk13106_4(X1,X2,X3,X4)
    | esk13073_4(X1,X2,X3,X4) ) ).

cnf(i_0_7687,axiom,
    ( ~ esk6474_4(X1,X2,X3,X4)
    | ~ esk6368_4(X1,X2,X3,X4)
    | ~ esk6388_4(X1,X2,X3,X4) ) ).

cnf(i_0_7688,axiom,
    ( esk11379_4(X1,X2,X3,X4)
    | esk11293_4(X1,X2,X3,X4) ) ).

cnf(i_0_7689,axiom,
    ( ~ esk2803_4(X1,X2,X3,X4)
    | esk3061_4(X1,X2,X3,X4) ) ).

cnf(i_0_7690,axiom,
    ( ~ esk9818_4(X1,X2,X3,X4)
    | esk9793_4(X1,X2,X3,X4)
    | esk9767_4(X1,X2,X3,X4) ) ).

cnf(i_0_7691,axiom,
    ( esk16507_4(X1,X2,X3,X4)
    | ~ esk16508_4(X1,X2,X3,X4) ) ).

cnf(i_0_7692,axiom,
    ( esk10200_4(X1,X2,X3,X4)
    | ~ esk10198_4(X1,X2,X3,X4) ) ).

cnf(i_0_7693,axiom,
    ( ~ esk505_4(X1,X2,X3,X4)
    | ~ esk586_4(X1,X2,X3,X4) ) ).

cnf(i_0_7694,axiom,
    ( p(X2)
    | ~ esk162_0
    | p(X4)
    | ~ p(X1)
    | ~ p(X3)
    | esk503_4(X1,X2,X3,X4) ) ).

cnf(i_0_7695,axiom,
    ( esk10571_4(X1,X2,X3,X4)
    | esk10526_4(X1,X2,X3,X4) ) ).

cnf(i_0_7696,axiom,
    ( esk15935_4(X1,X2,X3,X4)
    | esk15902_4(X1,X2,X3,X4) ) ).

cnf(i_0_7697,axiom,
    ( ~ esk10462_4(X1,X2,X3,X4)
    | esk10543_4(X1,X2,X3,X4) ) ).

cnf(i_0_7698,axiom,
    ( ~ esk15461_4(X1,X2,X3,X4)
    | ~ esk15443_4(X1,X2,X3,X4) ) ).

cnf(i_0_7699,axiom,
    ( esk3232_4(X1,X2,X3,X4)
    | ~ esk3227_4(X1,X2,X3,X4) ) ).

cnf(i_0_7700,axiom,
    ( ~ esk8197_4(X1,X2,X3,X4)
    | ~ esk8150_4(X1,X2,X3,X4)
    | ~ esk8196_4(X1,X2,X3,X4) ) ).

cnf(i_0_7701,axiom,
    ( ~ esk4261_4(X1,X2,X3,X4)
    | ~ esk4263_4(X1,X2,X3,X4) ) ).

cnf(i_0_7702,axiom,
    ( ~ esk9642_4(X1,X2,X3,X4)
    | esk9613_4(X1,X2,X3,X4) ) ).

cnf(i_0_7703,axiom,
    ( esk5582_4(X1,X2,X3,X4)
    | esk5623_4(X1,X2,X3,X4) ) ).

cnf(i_0_7704,axiom,
    ( ~ esk13267_4(X1,X2,X3,X4)
    | esk13251_4(X1,X2,X3,X4)
    | ~ esk13287_4(X1,X2,X3,X4) ) ).

cnf(i_0_7705,axiom,
    ( esk10685_4(X1,X2,X3,X4)
    | ~ esk10680_4(X1,X2,X3,X4) ) ).

cnf(i_0_7706,axiom,
    ( esk9389_4(X1,X2,X3,X4)
    | ~ esk9400_4(X1,X2,X3,X4)
    | ~ esk9486_4(X1,X2,X3,X4) ) ).

cnf(i_0_7707,axiom,
    ( esk1922_4(X1,X2,X3,X4)
    | esk1897_4(X1,X2,X3,X4)
    | esk1921_4(X1,X2,X3,X4)
    | esk1949_4(X1,X2,X3,X4)
    | esk1919_4(X1,X2,X3,X4) ) ).

cnf(i_0_7708,axiom,
    ( esk16513_4(X1,X2,X3,X4)
    | ~ esk16484_4(X1,X2,X3,X4)
    | esk16433_4(X1,X2,X3,X4) ) ).

cnf(i_0_7709,axiom,
    ( esk16624_4(X1,X2,X3,X4)
    | esk16619_4(X1,X2,X3,X4)
    | ~ esk16620_4(X1,X2,X3,X4) ) ).

cnf(i_0_7710,axiom,
    ( ~ esk14899_4(X1,X2,X3,X4)
    | esk14953_4(X1,X2,X3,X4) ) ).

cnf(i_0_7711,axiom,
    ( esk13106_4(X1,X2,X3,X4)
    | ~ esk12983_4(X1,X2,X3,X4) ) ).

cnf(i_0_7712,axiom,
    ( ~ esk582_4(X1,X2,X3,X4)
    | esk583_4(X1,X2,X3,X4)
    | ~ esk581_4(X1,X2,X3,X4) ) ).

cnf(i_0_7713,axiom,
    ( esk8407_4(X1,X2,X3,X4)
    | ~ esk8485_4(X1,X2,X3,X4) ) ).

cnf(i_0_7714,axiom,
    ( esk7074_4(X1,X2,X3,X4)
    | ~ esk7199_4(X1,X2,X3,X4)
    | ~ esk7087_4(X1,X2,X3,X4) ) ).

cnf(i_0_7715,axiom,
    ( ~ esk15379_4(X1,X2,X3,X4)
    | ~ esk15353_4(X1,X2,X3,X4)
    | ~ esk15378_4(X1,X2,X3,X4) ) ).

cnf(i_0_7716,axiom,
    ( ~ esk12740_4(X1,X2,X3,X4)
    | ~ esk12717_4(X1,X2,X3,X4) ) ).

cnf(i_0_7717,axiom,
    ( ~ esk2374_4(X1,X2,X3,X4)
    | ~ esk2256_4(X1,X2,X3,X4)
    | ~ esk2258_4(X1,X2,X3,X4) ) ).

cnf(i_0_7718,axiom,
    ( ~ esk3778_4(X1,X2,X3,X4)
    | ~ esk3875_4(X1,X2,X3,X4) ) ).

cnf(i_0_7719,axiom,
    ( esk15574_4(X1,X2,X3,X4)
    | ~ esk15590_4(X1,X2,X3,X4) ) ).

cnf(i_0_7720,axiom,
    ( esk2029_4(X1,X2,X3,X4)
    | esk2116_4(X1,X2,X3,X4) ) ).

cnf(i_0_7721,axiom,
    ( ~ esk15814_4(X1,X2,X3,X4)
    | esk15825_4(X1,X2,X3,X4) ) ).

cnf(i_0_7722,axiom,
    ( esk9182_4(X1,X2,X3,X4)
    | ~ esk9248_4(X1,X2,X3,X4) ) ).

cnf(i_0_7723,axiom,
    ( esk6596_4(X1,X2,X3,X4)
    | esk6578_4(X1,X2,X3,X4) ) ).

cnf(i_0_7724,axiom,
    ( ~ esk7129_4(X1,X2,X3,X4)
    | ~ esk7155_4(X1,X2,X3,X4)
    | ~ esk7154_4(X1,X2,X3,X4) ) ).

cnf(i_0_7725,axiom,
    ( esk3274_4(X1,X2,X3,X4)
    | ~ esk3331_4(X1,X2,X3,X4) ) ).

cnf(i_0_7726,axiom,
    ( ~ esk14680_4(X1,X2,X3,X4)
    | esk14696_4(X1,X2,X3,X4) ) ).

cnf(i_0_7727,axiom,
    ( esk16579_4(X1,X2,X3,X4)
    | ~ esk16554_4(X1,X2,X3,X4) ) ).

cnf(i_0_7728,axiom,
    ( ~ esk14313_4(X1,X2,X3,X4)
    | ~ esk14335_4(X1,X2,X3,X4) ) ).

cnf(i_0_7729,axiom,
    ( esk13078_4(X1,X2,X3,X4)
    | esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_7730,axiom,
    ( ~ esk1865_4(X1,X2,X3,X4)
    | ~ esk1833_4(X1,X2,X3,X4) ) ).

cnf(i_0_7731,axiom,
    ( esk4671_4(X1,X2,X3,X4)
    | esk4658_4(X1,X2,X3,X4)
    | ~ esk4672_4(X1,X2,X3,X4) ) ).

cnf(i_0_7732,axiom,
    ( ~ esk9718_4(X1,X2,X3,X4)
    | ~ esk9707_4(X1,X2,X3,X4)
    | ~ esk9751_4(X1,X2,X3,X4) ) ).

cnf(i_0_7733,axiom,
    ( esk15064_4(X1,X2,X3,X4)
    | esk15065_4(X1,X2,X3,X4) ) ).

cnf(i_0_7734,axiom,
    ( ~ esk1252_4(X1,X2,X3,X4)
    | ~ esk1358_4(X1,X2,X3,X4)
    | ~ esk1228_4(X1,X2,X3,X4) ) ).

cnf(i_0_7735,axiom,
    ( esk10453_4(X1,X2,X3,X4)
    | ~ esk10433_4(X1,X2,X3,X4) ) ).

cnf(i_0_7736,axiom,
    ( ~ esk3880_4(X1,X2,X3,X4)
    | ~ esk3860_4(X1,X2,X3,X4)
    | ~ esk3862_4(X1,X2,X3,X4) ) ).

cnf(i_0_7737,axiom,
    ( esk15260_4(X1,X2,X3,X4)
    | esk15312_4(X1,X2,X3,X4) ) ).

cnf(i_0_7738,axiom,
    ( ~ esk6442_4(X1,X2,X3,X4)
    | esk6443_4(X1,X2,X3,X4)
    | ~ esk6441_4(X1,X2,X3,X4) ) ).

cnf(i_0_7739,axiom,
    ( esk15411_4(X1,X2,X3,X4)
    | esk15492_4(X1,X2,X3,X4) ) ).

cnf(i_0_7740,axiom,
    ( ~ esk1291_4(X1,X2,X3,X4)
    | esk1210_4(X1,X2,X3,X4) ) ).

cnf(i_0_7741,axiom,
    ( esk10793_4(X1,X2,X3,X4)
    | esk10823_4(X1,X2,X3,X4) ) ).

cnf(i_0_7742,axiom,
    ( esk10223_4(X1,X2,X3,X4)
    | esk10239_4(X1,X2,X3,X4) ) ).

cnf(i_0_7743,axiom,
    ( esk765_4(X1,X2,X3,X4)
    | ~ esk1023_4(X1,X2,X3,X4) ) ).

cnf(i_0_7744,axiom,
    ( ~ esk11461_4(X1,X2,X3,X4)
    | esk11481_4(X1,X2,X3,X4) ) ).

cnf(i_0_7745,axiom,
    ( ~ esk10785_4(X1,X2,X3,X4)
    | esk10836_4(X1,X2,X3,X4) ) ).

cnf(i_0_7746,axiom,
    ( esk8704_4(X1,X2,X3,X4)
    | esk8737_4(X1,X2,X3,X4) ) ).

cnf(i_0_7747,axiom,
    ( ~ esk12836_4(X1,X2,X3,X4)
    | esk12785_4(X1,X2,X3,X4) ) ).

cnf(i_0_7748,axiom,
    ( ~ esk10772_4(X1,X2,X3,X4)
    | esk11030_4(X1,X2,X3,X4) ) ).

cnf(i_0_7749,axiom,
    ( ~ esk13568_4(X1,X2,X3,X4)
    | ~ esk13564_4(X1,X2,X3,X4)
    | ~ esk13683_4(X1,X2,X3,X4) ) ).

cnf(i_0_7750,axiom,
    ( esk7376_4(X1,X2,X3,X4)
    | ~ esk7340_4(X1,X2,X3,X4) ) ).

cnf(i_0_7751,axiom,
    ( esk5854_4(X1,X2,X3,X4)
    | esk5856_4(X1,X2,X3,X4) ) ).

cnf(i_0_7752,axiom,
    ( esk12066_4(X1,X2,X3,X4)
    | ~ esk11964_4(X1,X2,X3,X4) ) ).

cnf(i_0_7753,axiom,
    ( esk4055_4(X1,X2,X3,X4)
    | esk4059_4(X1,X2,X3,X4) ) ).

cnf(i_0_7754,axiom,
    ( ~ esk4389_4(X1,X2,X3,X4)
    | ~ esk4390_4(X1,X2,X3,X4) ) ).

cnf(i_0_7755,axiom,
    ( ~ esk16689_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | esk135_0
    | ~ p(X1)
    | p(X4) ) ).

cnf(i_0_7756,axiom,
    ( esk13256_4(X1,X2,X3,X4)
    | esk13257_4(X1,X2,X3,X4) ) ).

cnf(i_0_7757,axiom,
    ( esk16397_4(X1,X2,X3,X4)
    | esk16386_4(X1,X2,X3,X4) ) ).

cnf(i_0_7758,axiom,
    ( esk8938_4(X1,X2,X3,X4)
    | esk8946_4(X1,X2,X3,X4) ) ).

cnf(i_0_7759,axiom,
    ( esk3539_4(X1,X2,X3,X4)
    | esk3519_4(X1,X2,X3,X4)
    | esk3485_4(X1,X2,X3,X4) ) ).

cnf(i_0_7760,axiom,
    ( esk5202_4(X1,X2,X3,X4)
    | esk5087_4(X1,X2,X3,X4) ) ).

cnf(i_0_7761,axiom,
    ( esk9929_4(X1,X2,X3,X4)
    | esk9927_4(X1,X2,X3,X4) ) ).

cnf(i_0_7762,axiom,
    ( ~ esk13640_4(X1,X2,X3,X4)
    | esk13898_4(X1,X2,X3,X4) ) ).

cnf(i_0_7763,axiom,
    ( esk3923_4(X1,X2,X3,X4)
    | ~ esk3924_4(X1,X2,X3,X4) ) ).

cnf(i_0_7764,axiom,
    ( esk2886_4(X1,X2,X3,X4)
    | ~ esk2832_4(X1,X2,X3,X4) ) ).

cnf(i_0_7765,axiom,
    ( ~ esk528_4(X1,X2,X3,X4)
    | esk530_4(X1,X2,X3,X4) ) ).

cnf(i_0_7766,axiom,
    ( esk10901_4(X1,X2,X3,X4)
    | ~ esk10924_4(X1,X2,X3,X4) ) ).

cnf(i_0_7767,axiom,
    ( ~ esk3662_4(X1,X2,X3,X4)
    | ~ esk3581_4(X1,X2,X3,X4)
    | ~ esk3669_4(X1,X2,X3,X4) ) ).

cnf(i_0_7768,axiom,
    ( esk11701_4(X1,X2,X3,X4)
    | ~ esk11666_4(X1,X2,X3,X4) ) ).

cnf(i_0_7769,axiom,
    ( esk10782_4(X1,X2,X3,X4)
    | ~ esk11040_4(X1,X2,X3,X4) ) ).

cnf(i_0_7770,axiom,
    ( ~ esk6811_4(X1,X2,X3,X4)
    | esk6830_4(X1,X2,X3,X4) ) ).

cnf(i_0_7771,axiom,
    ( ~ esk546_4(X1,X2,X3,X4)
    | ~ esk547_4(X1,X2,X3,X4) ) ).

cnf(i_0_7772,axiom,
    ( esk12232_4(X1,X2,X3,X4)
    | esk12241_4(X1,X2,X3,X4) ) ).

cnf(i_0_7773,axiom,
    ( esk7653_4(X1,X2,X3,X4)
    | esk7673_4(X1,X2,X3,X4) ) ).

cnf(i_0_7774,axiom,
    ( ~ esk5688_4(X1,X2,X3,X4)
    | ~ esk5720_4(X1,X2,X3,X4) ) ).

cnf(i_0_7775,axiom,
    ( ~ esk8731_4(X1,X2,X3,X4)
    | ~ esk8770_4(X1,X2,X3,X4) ) ).

cnf(i_0_7776,axiom,
    ( ~ esk5612_4(X1,X2,X3,X4)
    | ~ esk5613_4(X1,X2,X3,X4)
    | ~ esk5587_4(X1,X2,X3,X4) ) ).

cnf(i_0_7777,axiom,
    ( ~ esk7743_4(X1,X2,X3,X4)
    | ~ esk7744_4(X1,X2,X3,X4)
    | ~ esk7699_4(X1,X2,X3,X4) ) ).

cnf(i_0_7778,axiom,
    ( esk15686_4(X1,X2,X3,X4)
    | ~ esk15690_4(X1,X2,X3,X4) ) ).

cnf(i_0_7779,axiom,
    ( esk10573_4(X1,X2,X3,X4)
    | esk10575_4(X1,X2,X3,X4) ) ).

cnf(i_0_7780,axiom,
    ( esk9306_4(X1,X2,X3,X4)
    | ~ esk9308_4(X1,X2,X3,X4) ) ).

cnf(i_0_7781,axiom,
    ( ~ esk8032_4(X1,X2,X3,X4)
    | ~ esk7910_4(X1,X2,X3,X4)
    | ~ esk7920_4(X1,X2,X3,X4) ) ).

cnf(i_0_7782,axiom,
    ( esk8167_4(X1,X2,X3,X4)
    | esk8193_4(X1,X2,X3,X4) ) ).

cnf(i_0_7783,axiom,
    ( ~ esk4375_4(X1,X2,X3,X4)
    | esk4294_4(X1,X2,X3,X4) ) ).

cnf(i_0_7784,axiom,
    ( ~ esk8920_4(X1,X2,X3,X4)
    | ~ esk8970_4(X1,X2,X3,X4)
    | ~ esk8969_4(X1,X2,X3,X4) ) ).

cnf(i_0_7785,axiom,
    ( esk4439_4(X1,X2,X3,X4)
    | esk4396_4(X1,X2,X3,X4) ) ).

cnf(i_0_7786,axiom,
    ( esk3471_4(X1,X2,X3,X4)
    | ~ esk3591_4(X1,X2,X3,X4)
    | ~ esk3489_4(X1,X2,X3,X4) ) ).

cnf(i_0_7787,axiom,
    ( ~ esk15357_4(X1,X2,X3,X4)
    | esk15402_4(X1,X2,X3,X4) ) ).

cnf(i_0_7788,axiom,
    ( ~ p(X1)
    | p(X2)
    | ~ p(X3)
    | ~ esk534_4(X1,X2,X3,X4)
    | ~ p(X4)
    | esk328_0 ) ).

cnf(i_0_7789,axiom,
    ( esk10517_4(X1,X2,X3,X4)
    | ~ esk10775_4(X1,X2,X3,X4) ) ).

cnf(i_0_7790,axiom,
    ( ~ esk15191_4(X1,X2,X3,X4)
    | ~ esk15193_4(X1,X2,X3,X4) ) ).

cnf(i_0_7791,axiom,
    ( ~ esk3982_4(X1,X2,X3,X4)
    | esk4034_4(X1,X2,X3,X4) ) ).

cnf(i_0_7792,axiom,
    ( ~ esk15737_4(X1,X2,X3,X4)
    | ~ esk15620_4(X1,X2,X3,X4)
    | ~ esk15650_4(X1,X2,X3,X4) ) ).

cnf(i_0_7793,axiom,
    ( esk3392_4(X1,X2,X3,X4)
    | ~ esk3411_4(X1,X2,X3,X4)
    | esk3340_4(X1,X2,X3,X4) ) ).

cnf(i_0_7794,axiom,
    ( ~ esk2627_4(X1,X2,X3,X4)
    | ~ esk2575_4(X1,X2,X3,X4) ) ).

cnf(i_0_7795,axiom,
    ( esk5340_4(X1,X2,X3,X4)
    | esk5344_4(X1,X2,X3,X4) ) ).

cnf(i_0_7796,axiom,
    ( esk2613_4(X1,X2,X3,X4)
    | ~ esk2614_4(X1,X2,X3,X4) ) ).

cnf(i_0_7797,axiom,
    ( ~ esk2292_4(X1,X2,X3,X4)
    | ~ esk2352_4(X1,X2,X3,X4)
    | esk2337_4(X1,X2,X3,X4) ) ).

cnf(i_0_7798,axiom,
    ( ~ esk4802_4(X1,X2,X3,X4)
    | esk4544_4(X1,X2,X3,X4) ) ).

cnf(i_0_7799,axiom,
    ( esk13294_4(X1,X2,X3,X4)
    | esk13328_4(X1,X2,X3,X4) ) ).

cnf(i_0_7800,axiom,
    ( esk2257_4(X1,X2,X3,X4)
    | esk2254_4(X1,X2,X3,X4) ) ).

cnf(i_0_7801,axiom,
    ( ~ esk2451_4(X1,X2,X3,X4)
    | esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_7802,axiom,
    ( esk11506_4(X1,X2,X3,X4)
    | esk11529_4(X1,X2,X3,X4) ) ).

cnf(i_0_7803,axiom,
    ( ~ esk1572_4(X1,X2,X3,X4)
    | esk1537_4(X1,X2,X3,X4)
    | esk1591_4(X1,X2,X3,X4) ) ).

cnf(i_0_7804,axiom,
    ( ~ esk2444_4(X1,X2,X3,X4)
    | esk2419_4(X1,X2,X3,X4) ) ).

cnf(i_0_7805,axiom,
    ( ~ esk1483_4(X1,X2,X3,X4)
    | ~ esk1490_4(X1,X2,X3,X4)
    | ~ esk1523_4(X1,X2,X3,X4) ) ).

cnf(i_0_7806,axiom,
    ( ~ esk11333_4(X1,X2,X3,X4)
    | esk11363_4(X1,X2,X3,X4) ) ).

cnf(i_0_7807,axiom,
    ( ~ esk5540_4(X1,X2,X3,X4)
    | esk5497_4(X1,X2,X3,X4) ) ).

cnf(i_0_7808,axiom,
    ( esk6296_4(X1,X2,X3,X4)
    | ~ esk6277_4(X1,X2,X3,X4) ) ).

cnf(i_0_7809,axiom,
    ( ~ esk1228_4(X1,X2,X3,X4)
    | ~ esk1250_4(X1,X2,X3,X4)
    | ~ esk1335_4(X1,X2,X3,X4) ) ).

cnf(i_0_7810,axiom,
    ( ~ esk11589_4(X1,X2,X3,X4)
    | esk11542_4(X1,X2,X3,X4)
    | esk11626_4(X1,X2,X3,X4) ) ).

cnf(i_0_7811,axiom,
    ( esk421_4(X1,X2,X3,X4)
    | ~ esk415_4(X1,X2,X3,X4) ) ).

cnf(i_0_7812,axiom,
    ( ~ esk13156_4(X1,X2,X3,X4)
    | ~ esk13070_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_7813,axiom,
    ( esk9688_4(X1,X2,X3,X4)
    | esk9779_4(X1,X2,X3,X4) ) ).

cnf(i_0_7814,axiom,
    ( ~ esk10685_4(X1,X2,X3,X4)
    | esk10673_4(X1,X2,X3,X4)
    | ~ esk10799_4(X1,X2,X3,X4) ) ).

cnf(i_0_7815,axiom,
    ( ~ esk7908_4(X1,X2,X3,X4)
    | ~ esk7888_4(X1,X2,X3,X4) ) ).

cnf(i_0_7816,axiom,
    ( ~ esk1135_4(X1,X2,X3,X4)
    | esk1158_4(X1,X2,X3,X4) ) ).

cnf(i_0_7817,axiom,
    ( ~ esk5911_4(X1,X2,X3,X4)
    | esk6169_4(X1,X2,X3,X4) ) ).

cnf(i_0_7818,axiom,
    ( ~ esk13430_4(X1,X2,X3,X4)
    | ~ esk13398_4(X1,X2,X3,X4) ) ).

cnf(i_0_7819,axiom,
    ( ~ esk5062_4(X1,X2,X3,X4)
    | ~ esk5160_4(X1,X2,X3,X4)
    | ~ esk5153_4(X1,X2,X3,X4) ) ).

cnf(i_0_7820,axiom,
    ( ~ esk12794_4(X1,X2,X3,X4)
    | ~ esk12795_4(X1,X2,X3,X4)
    | ~ esk12790_4(X1,X2,X3,X4) ) ).

cnf(i_0_7821,axiom,
    ( esk12596_4(X1,X2,X3,X4)
    | ~ esk12471_4(X1,X2,X3,X4) ) ).

cnf(i_0_7822,axiom,
    ( esk1833_4(X1,X2,X3,X4)
    | esk1834_4(X1,X2,X3,X4)
    | esk1835_4(X1,X2,X3,X4) ) ).

cnf(i_0_7823,axiom,
    ( esk10208_4(X1,X2,X3,X4)
    | ~ esk10280_4(X1,X2,X3,X4) ) ).

cnf(i_0_7824,axiom,
    ( ~ esk9536_4(X1,X2,X3,X4)
    | ~ esk9579_4(X1,X2,X3,X4)
    | ~ esk9510_4(X1,X2,X3,X4) ) ).

cnf(i_0_7825,axiom,
    ( esk6087_4(X1,X2,X3,X4)
    | esk6073_4(X1,X2,X3,X4) ) ).

cnf(i_0_7826,axiom,
    ( ~ esk14289_4(X1,X2,X3,X4)
    | esk14305_4(X1,X2,X3,X4) ) ).

cnf(i_0_7827,axiom,
    ( esk9682_4(X1,X2,X3,X4)
    | ~ esk9683_4(X1,X2,X3,X4) ) ).

cnf(i_0_7828,axiom,
    ( ~ esk12603_4(X1,X2,X3,X4)
    | ~ esk12602_4(X1,X2,X3,X4)
    | esk12604_4(X1,X2,X3,X4) ) ).

cnf(i_0_7829,axiom,
    ( esk12025_4(X1,X2,X3,X4)
    | esk12018_4(X1,X2,X3,X4) ) ).

cnf(i_0_7830,axiom,
    ( ~ esk1220_4(X1,X2,X3,X4)
    | esk1271_4(X1,X2,X3,X4) ) ).

cnf(i_0_7831,axiom,
    ( ~ esk8277_4(X1,X2,X3,X4)
    | ~ esk8249_4(X1,X2,X3,X4) ) ).

cnf(i_0_7832,axiom,
    ( esk2505_4(X1,X2,X3,X4)
    | esk2524_4(X1,X2,X3,X4) ) ).

cnf(i_0_7833,axiom,
    ( esk6439_4(X1,X2,X3,X4)
    | esk6293_4(X1,X2,X3,X4) ) ).

cnf(i_0_7834,axiom,
    ( esk5015_4(X1,X2,X3,X4)
    | ~ esk4988_4(X1,X2,X3,X4) ) ).

cnf(i_0_7835,axiom,
    ( esk12572_4(X1,X2,X3,X4)
    | esk12655_4(X1,X2,X3,X4)
    | ~ esk12632_4(X1,X2,X3,X4) ) ).

cnf(i_0_7836,axiom,
    ( esk9542_4(X1,X2,X3,X4)
    | esk9498_4(X1,X2,X3,X4)
    | ~ esk9549_4(X1,X2,X3,X4) ) ).

cnf(i_0_7837,axiom,
    ( ~ esk11027_4(X1,X2,X3,X4)
    | esk11285_4(X1,X2,X3,X4) ) ).

cnf(i_0_7838,axiom,
    ( esk6949_4(X1,X2,X3,X4)
    | ~ esk6798_4(X1,X2,X3,X4) ) ).

cnf(i_0_7839,axiom,
    ( ~ esk5798_4(X1,X2,X3,X4)
    | esk5814_4(X1,X2,X3,X4) ) ).

cnf(i_0_7840,axiom,
    ( ~ esk11804_4(X1,X2,X3,X4)
    | esk12062_4(X1,X2,X3,X4) ) ).

cnf(i_0_7841,axiom,
    ( esk10158_4(X1,X2,X3,X4)
    | ~ esk10171_4(X1,X2,X3,X4)
    | ~ esk10283_4(X1,X2,X3,X4) ) ).

cnf(i_0_7842,axiom,
    ( esk15189_4(X1,X2,X3,X4)
    | esk15216_4(X1,X2,X3,X4)
    | ~ esk15217_4(X1,X2,X3,X4) ) ).

cnf(i_0_7843,axiom,
    ( esk4410_4(X1,X2,X3,X4)
    | ~ esk4411_4(X1,X2,X3,X4)
    | esk4360_4(X1,X2,X3,X4) ) ).

cnf(i_0_7844,axiom,
    ( ~ esk2848_4(X1,X2,X3,X4)
    | ~ esk2695_4(X1,X2,X3,X4)
    | ~ esk2841_4(X1,X2,X3,X4) ) ).

cnf(i_0_7845,axiom,
    ( esk11064_4(X1,X2,X3,X4)
    | ~ esk10806_4(X1,X2,X3,X4) ) ).

cnf(i_0_7846,axiom,
    ( ~ esk13799_4(X1,X2,X3,X4)
    | ~ esk13819_4(X1,X2,X3,X4) ) ).

cnf(i_0_7847,axiom,
    ( esk10480_4(X1,X2,X3,X4)
    | esk10508_4(X1,X2,X3,X4) ) ).

cnf(i_0_7848,axiom,
    ( ~ esk10749_4(X1,X2,X3,X4)
    | ~ esk10729_4(X1,X2,X3,X4)
    | ~ esk10748_4(X1,X2,X3,X4) ) ).

cnf(i_0_7849,axiom,
    ( ~ esk10514_4(X1,X2,X3,X4)
    | esk10256_4(X1,X2,X3,X4) ) ).

cnf(i_0_7850,axiom,
    ( esk2975_4(X1,X2,X3,X4)
    | ~ esk2964_4(X1,X2,X3,X4) ) ).

cnf(i_0_7851,axiom,
    ( esk7490_4(X1,X2,X3,X4)
    | esk7491_4(X1,X2,X3,X4)
    | esk7492_4(X1,X2,X3,X4) ) ).

cnf(i_0_7852,axiom,
    ( esk10531_4(X1,X2,X3,X4)
    | ~ esk10789_4(X1,X2,X3,X4) ) ).

cnf(i_0_7853,axiom,
    ( ~ esk9764_4(X1,X2,X3,X4)
    | esk10022_4(X1,X2,X3,X4) ) ).

cnf(i_0_7854,axiom,
    ( esk8422_4(X1,X2,X3,X4)
    | esk8449_4(X1,X2,X3,X4) ) ).

cnf(i_0_7855,axiom,
    ( ~ esk11345_4(X1,X2,X3,X4)
    | esk11371_4(X1,X2,X3,X4)
    | esk11346_4(X1,X2,X3,X4) ) ).

cnf(i_0_7856,axiom,
    ( ~ esk390_4(X1,X2,X3,X4)
    | esk361_4(X1,X2,X3,X4) ) ).

cnf(i_0_7857,axiom,
    ( esk11599_4(X1,X2,X3,X4)
    | esk11554_4(X1,X2,X3,X4) ) ).

cnf(i_0_7858,axiom,
    ( ~ esk10678_4(X1,X2,X3,X4)
    | esk10648_4(X1,X2,X3,X4) ) ).

cnf(i_0_7859,axiom,
    ( ~ esk8681_4(X1,X2,X3,X4)
    | ~ esk8799_4(X1,X2,X3,X4)
    | ~ esk8683_4(X1,X2,X3,X4) ) ).

cnf(i_0_7860,axiom,
    ( esk3056_4(X1,X2,X3,X4)
    | esk3010_4(X1,X2,X3,X4) ) ).

cnf(i_0_7861,axiom,
    ( ~ esk13807_4(X1,X2,X3,X4)
    | esk13876_4(X1,X2,X3,X4) ) ).

cnf(i_0_7862,axiom,
    ( ~ esk12886_4(X1,X2,X3,X4)
    | ~ esk12884_4(X1,X2,X3,X4) ) ).

cnf(i_0_7863,axiom,
    ( ~ esk16712_4(X1,X2,X3,X4)
    | esk16763_4(X1,X2,X3,X4) ) ).

cnf(i_0_7864,axiom,
    ( esk463_4(X1,X2,X3,X4)
    | esk452_4(X1,X2,X3,X4) ) ).

cnf(i_0_7865,axiom,
    ( ~ esk11249_4(X1,X2,X3,X4)
    | ~ esk11229_4(X1,X2,X3,X4) ) ).

cnf(i_0_7866,axiom,
    ( esk8165_4(X1,X2,X3,X4)
    | esk8180_4(X1,X2,X3,X4) ) ).

cnf(i_0_7867,axiom,
    ( esk3593_4(X1,X2,X3,X4)
    | esk3560_4(X1,X2,X3,X4) ) ).

cnf(i_0_7868,axiom,
    ( esk14081_4(X1,X2,X3,X4)
    | esk14074_4(X1,X2,X3,X4) ) ).

cnf(i_0_7869,axiom,
    ( ~ esk16092_4(X1,X2,X3,X4)
    | esk16098_4(X1,X2,X3,X4) ) ).

cnf(i_0_7870,axiom,
    ( p(X2)
    | p(X1)
    | ~ esk64_0
    | p(X4)
    | ~ p(X3)
    | esk491_4(X1,X2,X3,X4) ) ).

cnf(i_0_7871,axiom,
    ( ~ esk1564_4(X1,X2,X3,X4)
    | esk1601_4(X1,X2,X3,X4) ) ).

cnf(i_0_7872,axiom,
    ( ~ esk9501_4(X1,X2,X3,X4)
    | esk9759_4(X1,X2,X3,X4) ) ).

cnf(i_0_7873,axiom,
    ( ~ esk13558_4(X1,X2,X3,X4)
    | esk13603_4(X1,X2,X3,X4) ) ).

cnf(i_0_7874,axiom,
    ( esk6180_4(X1,X2,X3,X4)
    | ~ esk6179_4(X1,X2,X3,X4) ) ).

cnf(i_0_7875,axiom,
    ( ~ esk11850_4(X1,X2,X3,X4)
    | ~ esk11852_4(X1,X2,X3,X4) ) ).

cnf(i_0_7876,axiom,
    ( esk12481_4(X1,X2,X3,X4)
    | ~ esk12482_4(X1,X2,X3,X4) ) ).

cnf(i_0_7877,axiom,
    ( ~ esk11763_4(X1,X2,X3,X4)
    | ~ esk11815_4(X1,X2,X3,X4)
    | ~ esk11782_4(X1,X2,X3,X4) ) ).

cnf(i_0_7878,axiom,
    ( ~ esk11775_4(X1,X2,X3,X4)
    | ~ esk11765_4(X1,X2,X3,X4)
    | ~ esk11887_4(X1,X2,X3,X4) ) ).

cnf(i_0_7879,axiom,
    ( ~ esk1249_4(X1,X2,X3,X4)
    | ~ esk1282_4(X1,X2,X3,X4)
    | ~ esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_7880,axiom,
    ( ~ esk7237_4(X1,X2,X3,X4)
    | ~ esk7219_4(X1,X2,X3,X4) ) ).

cnf(i_0_7881,axiom,
    ( esk491_4(X1,X2,X3,X4)
    | p(X4)
    | ~ p(X1)
    | ~ esk70_0
    | p(X3)
    | p(X2) ) ).

cnf(i_0_7882,axiom,
    ( ~ esk14374_4(X1,X2,X3,X4)
    | esk14329_4(X1,X2,X3,X4) ) ).

cnf(i_0_7883,axiom,
    ( esk9744_4(X1,X2,X3,X4)
    | ~ esk10002_4(X1,X2,X3,X4) ) ).

cnf(i_0_7884,axiom,
    ( ~ esk16065_4(X1,X2,X3,X4)
    | esk16082_4(X1,X2,X3,X4) ) ).

cnf(i_0_7885,axiom,
    ( p(X2)
    | ~ p(X1)
    | ~ p(X3)
    | p(X4)
    | esk282_0
    | ~ esk519_4(X1,X2,X3,X4) ) ).

cnf(i_0_7886,axiom,
    ( esk4555_4(X1,X2,X3,X4)
    | ~ esk4624_4(X1,X2,X3,X4) ) ).

cnf(i_0_7887,axiom,
    ( esk12768_4(X1,X2,X3,X4)
    | ~ esk12770_4(X1,X2,X3,X4) ) ).

cnf(i_0_7888,axiom,
    ( esk8263_4(X1,X2,X3,X4)
    | ~ esk8248_4(X1,X2,X3,X4) ) ).

cnf(i_0_7889,axiom,
    ( esk14428_4(X1,X2,X3,X4)
    | esk14430_4(X1,X2,X3,X4) ) ).

cnf(i_0_7890,axiom,
    ( esk10127_4(X1,X2,X3,X4)
    | ~ esk10156_4(X1,X2,X3,X4) ) ).

cnf(i_0_7891,axiom,
    ( esk15068_4(X1,X2,X3,X4)
    | esk15082_4(X1,X2,X3,X4) ) ).

cnf(i_0_7892,axiom,
    ( esk13546_4(X1,X2,X3,X4)
    | ~ esk13627_4(X1,X2,X3,X4) ) ).

cnf(i_0_7893,axiom,
    ( ~ esk6929_4(X1,X2,X3,X4)
    | esk7187_4(X1,X2,X3,X4) ) ).

cnf(i_0_7894,axiom,
    ( esk2506_4(X1,X2,X3,X4)
    | ~ esk2554_4(X1,X2,X3,X4) ) ).

cnf(i_0_7895,axiom,
    ( esk12272_4(X1,X2,X3,X4)
    | esk12288_4(X1,X2,X3,X4) ) ).

cnf(i_0_7896,axiom,
    ( ~ esk16689_4(X1,X2,X3,X4)
    | p(X2)
    | p(X1)
    | esk124_0
    | p(X3)
    | ~ p(X4) ) ).

cnf(i_0_7897,axiom,
    ( ~ esk10843_4(X1,X2,X3,X4)
    | ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10757_4(X1,X2,X3,X4) ) ).

cnf(i_0_7898,axiom,
    ( esk9926_4(X1,X2,X3,X4)
    | esk9922_4(X1,X2,X3,X4)
    | esk9925_4(X1,X2,X3,X4)
    | esk9928_4(X1,X2,X3,X4) ) ).

cnf(i_0_7899,axiom,
    ( ~ esk11358_4(X1,X2,X3,X4)
    | esk11336_4(X1,X2,X3,X4)
    | esk11337_4(X1,X2,X3,X4) ) ).

cnf(i_0_7900,axiom,
    ( esk3860_4(X1,X2,X3,X4)
    | ~ esk3914_4(X1,X2,X3,X4)
    | esk3877_4(X1,X2,X3,X4) ) ).

cnf(i_0_7901,axiom,
    ( esk14561_4(X1,X2,X3,X4)
    | ~ esk14554_4(X1,X2,X3,X4) ) ).

cnf(i_0_7902,axiom,
    ( ~ esk16319_4(X1,X2,X3,X4)
    | esk16437_4(X1,X2,X3,X4) ) ).

cnf(i_0_7903,axiom,
    ( ~ esk14112_4(X1,X2,X3,X4)
    | esk14015_4(X1,X2,X3,X4)
    | ~ esk14026_4(X1,X2,X3,X4) ) ).

cnf(i_0_7904,axiom,
    ( esk2208_4(X1,X2,X3,X4)
    | ~ esk2230_4(X1,X2,X3,X4) ) ).

cnf(i_0_7905,axiom,
    ( ~ esk2273_4(X1,X2,X3,X4)
    | ~ esk2306_4(X1,X2,X3,X4)
    | ~ esk2254_4(X1,X2,X3,X4) ) ).

cnf(i_0_7906,axiom,
    ( ~ esk4797_4(X1,X2,X3,X4)
    | esk4798_4(X1,X2,X3,X4) ) ).

cnf(i_0_7907,axiom,
    ( esk1999_4(X1,X2,X3,X4)
    | esk2005_4(X1,X2,X3,X4) ) ).

cnf(i_0_7908,axiom,
    ( esk12360_4(X1,X2,X3,X4)
    | ~ esk12375_4(X1,X2,X3,X4)
    | ~ esk12315_4(X1,X2,X3,X4) ) ).

cnf(i_0_7909,axiom,
    ( p(X1)
    | p(X3)
    | ~ esk16724_4(X1,X2,X3,X4)
    | p(X4)
    | p(X2)
    | esk318_0 ) ).

cnf(i_0_7910,axiom,
    ( ~ esk14898_4(X1,X2,X3,X4)
    | esk14838_4(X1,X2,X3,X4) ) ).

cnf(i_0_7911,axiom,
    ( ~ esk9017_4(X1,X2,X3,X4)
    | ~ esk9002_4(X1,X2,X3,X4) ) ).

cnf(i_0_7912,axiom,
    ( esk3779_4(X1,X2,X3,X4)
    | esk3875_4(X1,X2,X3,X4)
    | esk3778_4(X1,X2,X3,X4) ) ).

cnf(i_0_7913,axiom,
    ( esk11984_4(X1,X2,X3,X4)
    | esk11975_4(X1,X2,X3,X4) ) ).

cnf(i_0_7914,axiom,
    ( esk1859_4(X1,X2,X3,X4)
    | esk1772_4(X1,X2,X3,X4) ) ).

cnf(i_0_7915,axiom,
    ( esk5284_4(X1,X2,X3,X4)
    | esk5339_4(X1,X2,X3,X4) ) ).

cnf(i_0_7916,axiom,
    ( esk6041_4(X1,X2,X3,X4)
    | ~ esk6161_4(X1,X2,X3,X4)
    | ~ esk6059_4(X1,X2,X3,X4) ) ).

cnf(i_0_7917,axiom,
    ( ~ esk11821_4(X1,X2,X3,X4)
    | esk11563_4(X1,X2,X3,X4) ) ).

cnf(i_0_7918,axiom,
    esk11967_4(X1,X2,X3,X4) ).

cnf(i_0_7919,axiom,
    ( ~ esk16735_4(X1,X2,X3,X4)
    | ~ esk16734_4(X1,X2,X3,X4) ) ).

cnf(i_0_7920,axiom,
    ( esk12109_4(X1,X2,X3,X4)
    | esk12107_4(X1,X2,X3,X4)
    | esk12108_4(X1,X2,X3,X4) ) ).

cnf(i_0_7921,axiom,
    ( ~ esk1_0
    | p(X2)
    | esk415_4(X1,X2,X3,X4)
    | p(X3)
    | p(X1)
    | p(X4) ) ).

cnf(i_0_7922,axiom,
    ( ~ esk4271_4(X1,X2,X3,X4)
    | esk4277_4(X1,X2,X3,X4) ) ).

cnf(i_0_7923,axiom,
    ( esk15119_4(X1,X2,X3,X4)
    | esk15097_4(X1,X2,X3,X4) ) ).

cnf(i_0_7924,axiom,
    ( ~ esk13570_4(X1,X2,X3,X4)
    | ~ esk13564_4(X1,X2,X3,X4)
    | ~ esk13684_4(X1,X2,X3,X4) ) ).

cnf(i_0_7925,axiom,
    ( esk11699_4(X1,X2,X3,X4)
    | ~ esk11668_4(X1,X2,X3,X4) ) ).

cnf(i_0_7926,axiom,
    ( ~ esk545_4(X1,X2,X3,X4)
    | ~ esk559_4(X1,X2,X3,X4) ) ).

cnf(i_0_7927,axiom,
    ( ~ esk7074_4(X1,X2,X3,X4)
    | esk7087_4(X1,X2,X3,X4) ) ).

cnf(i_0_7928,axiom,
    ( esk6099_4(X1,X2,X3,X4)
    | esk6131_4(X1,X2,X3,X4) ) ).

cnf(i_0_7929,axiom,
    ( ~ esk4552_4(X1,X2,X3,X4)
    | ~ esk4598_4(X1,X2,X3,X4)
    | ~ esk4599_4(X1,X2,X3,X4) ) ).

cnf(i_0_7930,axiom,
    ( ~ esk9282_4(X1,X2,X3,X4)
    | ~ esk9280_4(X1,X2,X3,X4) ) ).

cnf(i_0_7931,axiom,
    ( ~ esk6549_4(X1,X2,X3,X4)
    | esk6573_4(X1,X2,X3,X4)
    | ~ esk6576_4(X1,X2,X3,X4) ) ).

cnf(i_0_7932,axiom,
    ( esk14535_4(X1,X2,X3,X4)
    | ~ esk14492_4(X1,X2,X3,X4) ) ).

cnf(i_0_7933,axiom,
    ( ~ esk8371_4(X1,X2,X3,X4)
    | ~ esk8348_4(X1,X2,X3,X4) ) ).

cnf(i_0_7934,axiom,
    ( ~ esk4929_4(X1,X2,X3,X4)
    | esk4928_4(X1,X2,X3,X4)
    | esk4915_4(X1,X2,X3,X4) ) ).

cnf(i_0_7935,axiom,
    ( ~ esk6931_4(X1,X2,X3,X4)
    | esk6871_4(X1,X2,X3,X4) ) ).

cnf(i_0_7936,axiom,
    ( esk15179_4(X1,X2,X3,X4)
    | ~ esk15177_4(X1,X2,X3,X4) ) ).

cnf(i_0_7937,axiom,
    ( esk289_0
    | ~ esk16711_4(X1,X2,X3,X4)
    | p(X2)
    | p(X1)
    | ~ p(X4)
    | p(X3) ) ).

cnf(i_0_7938,axiom,
    ( ~ esk12776_4(X1,X2,X3,X4)
    | ~ esk12823_4(X1,X2,X3,X4)
    | ~ esk12822_4(X1,X2,X3,X4) ) ).

cnf(i_0_7939,axiom,
    ( esk5862_4(X1,X2,X3,X4)
    | esk5848_4(X1,X2,X3,X4) ) ).

cnf(i_0_7940,axiom,
    ( esk11080_4(X1,X2,X3,X4)
    | esk11101_4(X1,X2,X3,X4)
    | ~ esk11079_4(X1,X2,X3,X4) ) ).

cnf(i_0_7941,axiom,
    ( ~ esk3332_4(X1,X2,X3,X4)
    | esk3383_4(X1,X2,X3,X4) ) ).

cnf(i_0_7942,axiom,
    ( esk12600_4(X1,X2,X3,X4)
    | esk12615_4(X1,X2,X3,X4) ) ).

cnf(i_0_7943,axiom,
    ( esk3089_4(X1,X2,X3,X4)
    | esk3141_4(X1,X2,X3,X4) ) ).

cnf(i_0_7944,axiom,
    ( ~ esk9386_4(X1,X2,X3,X4)
    | esk9510_4(X1,X2,X3,X4) ) ).

cnf(i_0_7945,axiom,
    ( esk9521_4(X1,X2,X3,X4)
    | ~ esk9779_4(X1,X2,X3,X4) ) ).

cnf(i_0_7946,axiom,
    ( esk11087_4(X1,X2,X3,X4)
    | esk11122_4(X1,X2,X3,X4) ) ).

cnf(i_0_7947,axiom,
    ( esk8353_4(X1,X2,X3,X4)
    | ~ esk8472_4(X1,X2,X3,X4)
    | ~ esk8372_4(X1,X2,X3,X4) ) ).

cnf(i_0_7948,axiom,
    ( esk5147_4(X1,X2,X3,X4)
    | esk5165_4(X1,X2,X3,X4) ) ).

cnf(i_0_7949,axiom,
    ( esk5185_4(X1,X2,X3,X4)
    | ~ esk5186_4(X1,X2,X3,X4)
    | esk5172_4(X1,X2,X3,X4) ) ).

cnf(i_0_7950,axiom,
    ( ~ esk10928_4(X1,X2,X3,X4)
    | esk11052_4(X1,X2,X3,X4) ) ).

cnf(i_0_7951,axiom,
    ( ~ esk2602_4(X1,X2,X3,X4)
    | ~ esk2603_4(X1,X2,X3,X4) ) ).

cnf(i_0_7952,axiom,
    ( esk5338_4(X1,X2,X3,X4)
    | esk5371_4(X1,X2,X3,X4) ) ).

cnf(i_0_7953,axiom,
    ( esk3265_4(X1,X2,X3,X4)
    | esk3354_4(X1,X2,X3,X4) ) ).

cnf(i_0_7954,axiom,
    ( esk1812_4(X1,X2,X3,X4)
    | esk1720_4(X1,X2,X3,X4)
    | esk1819_4(X1,X2,X3,X4) ) ).

cnf(i_0_7955,axiom,
    ( ~ p(X2)
    | esk294_0
    | p(X1)
    | ~ esk521_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X3) ) ).

cnf(i_0_7956,axiom,
    ( ~ esk3330_4(X1,X2,X3,X4)
    | esk3072_4(X1,X2,X3,X4) ) ).

cnf(i_0_7957,axiom,
    ( esk13067_4(X1,X2,X3,X4)
    | esk13048_4(X1,X2,X3,X4) ) ).

cnf(i_0_7958,axiom,
    ( esk14565_4(X1,X2,X3,X4)
    | ~ esk14566_4(X1,X2,X3,X4) ) ).

cnf(i_0_7959,axiom,
    ( esk4117_4(X1,X2,X3,X4)
    | ~ esk3859_4(X1,X2,X3,X4) ) ).

cnf(i_0_7960,axiom,
    ( esk16424_4(X1,X2,X3,X4)
    | ~ esk16388_4(X1,X2,X3,X4) ) ).

cnf(i_0_7961,axiom,
    ( ~ esk10756_4(X1,X2,X3,X4)
    | ~ esk10725_4(X1,X2,X3,X4)
    | ~ esk10757_4(X1,X2,X3,X4) ) ).

cnf(i_0_7962,axiom,
    ( esk11772_4(X1,X2,X3,X4)
    | esk11763_4(X1,X2,X3,X4) ) ).

cnf(i_0_7963,axiom,
    ( esk9021_4(X1,X2,X3,X4)
    | esk8998_4(X1,X2,X3,X4) ) ).

cnf(i_0_7964,axiom,
    ( ~ esk9810_4(X1,X2,X3,X4)
    | esk9809_4(X1,X2,X3,X4) ) ).

cnf(i_0_7965,axiom,
    ( ~ esk12235_4(X1,X2,X3,X4)
    | ~ esk12240_4(X1,X2,X3,X4) ) ).

cnf(i_0_7966,axiom,
    ( esk9400_4(X1,X2,X3,X4)
    | ~ esk9385_4(X1,X2,X3,X4) ) ).

cnf(i_0_7967,axiom,
    ( esk5089_4(X1,X2,X3,X4)
    | esk5083_4(X1,X2,X3,X4) ) ).

cnf(i_0_7968,axiom,
    ( ~ esk2461_4(X1,X2,X3,X4)
    | ~ esk2567_4(X1,X2,X3,X4)
    | esk2445_4(X1,X2,X3,X4) ) ).

cnf(i_0_7969,axiom,
    ( ~ esk11125_4(X1,X2,X3,X4)
    | ~ esk10994_4(X1,X2,X3,X4)
    | ~ esk11002_4(X1,X2,X3,X4) ) ).

cnf(i_0_7970,axiom,
    ( ~ esk409_4(X1,X2,X3,X4)
    | esk667_4(X1,X2,X3,X4) ) ).

cnf(i_0_7971,axiom,
    ( ~ esk7743_4(X1,X2,X3,X4)
    | ~ esk7741_4(X1,X2,X3,X4) ) ).

cnf(i_0_7972,axiom,
    ( esk5942_4(X1,X2,X3,X4)
    | esk5941_4(X1,X2,X3,X4) ) ).

cnf(i_0_7973,axiom,
    ( esk15423_4(X1,X2,X3,X4)
    | ~ esk15475_4(X1,X2,X3,X4)
    | esk15445_4(X1,X2,X3,X4) ) ).

cnf(i_0_7974,axiom,
    ( ~ esk3113_4(X1,X2,X3,X4)
    | esk3134_4(X1,X2,X3,X4)
    | esk3112_4(X1,X2,X3,X4) ) ).

cnf(i_0_7975,axiom,
    ( esk12521_4(X1,X2,X3,X4)
    | esk12561_4(X1,X2,X3,X4) ) ).

cnf(i_0_7976,axiom,
    ( ~ esk12594_4(X1,X2,X3,X4)
    | ~ esk12645_4(X1,X2,X3,X4)
    | ~ esk12620_4(X1,X2,X3,X4) ) ).

cnf(i_0_7977,axiom,
    ( esk12237_4(X1,X2,X3,X4)
    | ~ esk11979_4(X1,X2,X3,X4) ) ).

cnf(i_0_7978,axiom,
    ( ~ esk14419_4(X1,X2,X3,X4)
    | ~ esk14418_4(X1,X2,X3,X4) ) ).

cnf(i_0_7979,axiom,
    ( ~ esk8768_4(X1,X2,X3,X4)
    | ~ esk8767_4(X1,X2,X3,X4) ) ).

cnf(i_0_7980,axiom,
    ( esk8136_4(X1,X2,X3,X4)
    | ~ esk8122_4(X1,X2,X3,X4) ) ).

cnf(i_0_7981,axiom,
    ( esk7394_4(X1,X2,X3,X4)
    | esk7427_4(X1,X2,X3,X4) ) ).

cnf(i_0_7982,axiom,
    ( esk1483_4(X1,X2,X3,X4)
    | esk1490_4(X1,X2,X3,X4) ) ).

cnf(i_0_7983,axiom,
    ( esk3896_4(X1,X2,X3,X4)
    | esk3846_4(X1,X2,X3,X4)
    | ~ esk3897_4(X1,X2,X3,X4) ) ).

cnf(i_0_7984,axiom,
    ( ~ esk2194_4(X1,X2,X3,X4)
    | esk2170_4(X1,X2,X3,X4) ) ).

cnf(i_0_7985,axiom,
    ( ~ esk3230_4(X1,X2,X3,X4)
    | esk3229_4(X1,X2,X3,X4) ) ).

cnf(i_0_7986,axiom,
    ( ~ esk13366_4(X1,X2,X3,X4)
    | esk13291_4(X1,X2,X3,X4) ) ).

cnf(i_0_7987,axiom,
    ( esk15276_4(X1,X2,X3,X4)
    | ~ esk15302_4(X1,X2,X3,X4) ) ).

cnf(i_0_7988,axiom,
    ( esk13623_4(X1,X2,X3,X4)
    | ~ esk13881_4(X1,X2,X3,X4) ) ).

cnf(i_0_7989,axiom,
    ( esk3804_4(X1,X2,X3,X4)
    | esk3793_4(X1,X2,X3,X4) ) ).

cnf(i_0_7990,axiom,
    ( esk1435_4(X1,X2,X3,X4)
    | esk1434_4(X1,X2,X3,X4) ) ).

cnf(i_0_7991,axiom,
    ( ~ esk11742_4(X1,X2,X3,X4)
    | esk11740_4(X1,X2,X3,X4) ) ).

cnf(i_0_7992,axiom,
    ( esk1096_4(X1,X2,X3,X4)
    | ~ esk1097_4(X1,X2,X3,X4) ) ).

cnf(i_0_7993,axiom,
    ( ~ esk9963_4(X1,X2,X3,X4)
    | ~ esk9967_4(X1,X2,X3,X4)
    | ~ esk9968_4(X1,X2,X3,X4) ) ).

cnf(i_0_7994,axiom,
    ( esk6529_4(X1,X2,X3,X4)
    | ~ esk6558_4(X1,X2,X3,X4) ) ).

cnf(i_0_7995,axiom,
    ( ~ esk15363_4(X1,X2,X3,X4)
    | ~ esk15393_4(X1,X2,X3,X4)
    | ~ esk15480_4(X1,X2,X3,X4) ) ).

cnf(i_0_7996,axiom,
    ( esk11689_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4) ) ).

cnf(i_0_7997,axiom,
    ( ~ esk6366_4(X1,X2,X3,X4)
    | ~ esk6414_4(X1,X2,X3,X4)
    | ~ esk6381_4(X1,X2,X3,X4) ) ).

cnf(i_0_7998,axiom,
    ( esk12485_4(X1,X2,X3,X4)
    | esk12487_4(X1,X2,X3,X4) ) ).

cnf(i_0_7999,axiom,
    ( esk9931_4(X1,X2,X3,X4)
    | ~ esk9932_4(X1,X2,X3,X4) ) ).

cnf(i_0_8000,axiom,
    ( esk15568_4(X1,X2,X3,X4)
    | ~ esk15550_4(X1,X2,X3,X4) ) ).

cnf(i_0_8001,axiom,
    ( ~ esk14153_4(X1,X2,X3,X4)
    | esk14151_4(X1,X2,X3,X4) ) ).

cnf(i_0_8002,axiom,
    ( ~ esk10549_4(X1,X2,X3,X4)
    | esk10807_4(X1,X2,X3,X4) ) ).

cnf(i_0_8003,axiom,
    ( ~ esk5878_4(X1,X2,X3,X4)
    | ~ esk5984_4(X1,X2,X3,X4)
    | ~ esk5854_4(X1,X2,X3,X4) ) ).

cnf(i_0_8004,axiom,
    ( esk11894_4(X1,X2,X3,X4)
    | ~ esk11865_4(X1,X2,X3,X4)
    | esk11845_4(X1,X2,X3,X4) ) ).

cnf(i_0_8005,axiom,
    ( ~ esk14369_4(X1,X2,X3,X4)
    | ~ esk14336_4(X1,X2,X3,X4)
    | ~ esk14333_4(X1,X2,X3,X4) ) ).

cnf(i_0_8006,axiom,
    ( esk9056_4(X1,X2,X3,X4)
    | ~ esk8972_4(X1,X2,X3,X4)
    | esk9019_4(X1,X2,X3,X4) ) ).

cnf(i_0_8007,axiom,
    ( ~ esk5240_4(X1,X2,X3,X4)
    | esk5283_4(X1,X2,X3,X4) ) ).

cnf(i_0_8008,axiom,
    ( ~ esk7726_4(X1,X2,X3,X4)
    | esk7724_4(X1,X2,X3,X4)
    | esk7725_4(X1,X2,X3,X4) ) ).

cnf(i_0_8009,axiom,
    ( esk13061_4(X1,X2,X3,X4)
    | esk13048_4(X1,X2,X3,X4) ) ).

cnf(i_0_8010,axiom,
    ( esk3982_4(X1,X2,X3,X4)
    | ~ esk4034_4(X1,X2,X3,X4) ) ).

cnf(i_0_8011,axiom,
    ( esk13817_4(X1,X2,X3,X4)
    | esk13825_4(X1,X2,X3,X4) ) ).

cnf(i_0_8012,axiom,
    ( esk5031_4(X1,X2,X3,X4)
    | ~ esk5016_4(X1,X2,X3,X4) ) ).

cnf(i_0_8013,axiom,
    ( ~ esk2060_4(X1,X2,X3,X4)
    | esk1982_4(X1,X2,X3,X4) ) ).

cnf(i_0_8014,axiom,
    ( esk12084_4(X1,X2,X3,X4)
    | ~ esk11826_4(X1,X2,X3,X4) ) ).

cnf(i_0_8015,axiom,
    ( esk1093_4(X1,X2,X3,X4)
    | ~ esk1064_4(X1,X2,X3,X4)
    | esk1013_4(X1,X2,X3,X4) ) ).

cnf(i_0_8016,axiom,
    ( esk10805_4(X1,X2,X3,X4)
    | ~ esk10803_4(X1,X2,X3,X4)
    | ~ esk10804_4(X1,X2,X3,X4) ) ).

cnf(i_0_8017,axiom,
    ( ~ esk12882_4(X1,X2,X3,X4)
    | esk12896_4(X1,X2,X3,X4) ) ).

cnf(i_0_8018,axiom,
    ( ~ esk13030_4(X1,X2,X3,X4)
    | ~ esk13127_4(X1,X2,X3,X4) ) ).

cnf(i_0_8019,axiom,
    ( esk2233_4(X1,X2,X3,X4)
    | esk2232_4(X1,X2,X3,X4) ) ).

cnf(i_0_8020,axiom,
    ( ~ esk10428_4(X1,X2,X3,X4)
    | esk10411_4(X1,X2,X3,X4)
    | ~ esk10532_4(X1,X2,X3,X4) ) ).

cnf(i_0_8021,axiom,
    ( esk14427_4(X1,X2,X3,X4)
    | ~ esk14459_4(X1,X2,X3,X4)
    | esk14458_4(X1,X2,X3,X4) ) ).

cnf(i_0_8022,axiom,
    ( ~ esk8964_4(X1,X2,X3,X4)
    | ~ esk8963_4(X1,X2,X3,X4)
    | ~ esk8923_4(X1,X2,X3,X4) ) ).

cnf(i_0_8023,axiom,
    ( esk919_4(X1,X2,X3,X4)
    | ~ esk922_4(X1,X2,X3,X4)
    | ~ esk895_4(X1,X2,X3,X4) ) ).

cnf(i_0_8024,axiom,
    ( esk1692_4(X1,X2,X3,X4)
    | esk1691_4(X1,X2,X3,X4) ) ).

cnf(i_0_8025,axiom,
    ( esk9174_4(X1,X2,X3,X4)
    | esk9265_4(X1,X2,X3,X4) ) ).

cnf(i_0_8026,axiom,
    ( esk16433_4(X1,X2,X3,X4)
    | esk16519_4(X1,X2,X3,X4) ) ).

cnf(i_0_8027,axiom,
    ( esk12146_4(X1,X2,X3,X4)
    | ~ esk12148_4(X1,X2,X3,X4) ) ).

cnf(i_0_8028,axiom,
    ( esk14647_4(X1,X2,X3,X4)
    | ~ esk14905_4(X1,X2,X3,X4) ) ).

cnf(i_0_8029,axiom,
    ( ~ esk836_4(X1,X2,X3,X4)
    | esk807_4(X1,X2,X3,X4)
    | esk756_4(X1,X2,X3,X4) ) ).

cnf(i_0_8030,axiom,
    ( esk6862_4(X1,X2,X3,X4)
    | ~ esk6826_4(X1,X2,X3,X4) ) ).

cnf(i_0_8031,axiom,
    ( ~ esk2300_4(X1,X2,X3,X4)
    | ~ esk2348_4(X1,X2,X3,X4) ) ).

cnf(i_0_8032,axiom,
    ( ~ esk8372_4(X1,X2,X3,X4)
    | esk8354_4(X1,X2,X3,X4)
    | ~ esk8474_4(X1,X2,X3,X4) ) ).

cnf(i_0_8033,axiom,
    ( esk13624_4(X1,X2,X3,X4)
    | ~ esk13366_4(X1,X2,X3,X4) ) ).

cnf(i_0_8034,axiom,
    ( ~ esk12652_4(X1,X2,X3,X4)
    | ~ esk12651_4(X1,X2,X3,X4)
    | esk12653_4(X1,X2,X3,X4) ) ).

cnf(i_0_8035,axiom,
    ( ~ esk15711_4(X1,X2,X3,X4)
    | ~ esk15713_4(X1,X2,X3,X4) ) ).

cnf(i_0_8036,axiom,
    ( esk7979_4(X1,X2,X3,X4)
    | ~ esk8237_4(X1,X2,X3,X4) ) ).

cnf(i_0_8037,axiom,
    ( esk8972_4(X1,X2,X3,X4)
    | esk8939_4(X1,X2,X3,X4) ) ).

cnf(i_0_8038,axiom,
    ( esk11042_4(X1,X2,X3,X4)
    | esk11009_4(X1,X2,X3,X4) ) ).

cnf(i_0_8039,axiom,
    ( ~ esk11858_4(X1,X2,X3,X4)
    | ~ esk11807_4(X1,X2,X3,X4)
    | ~ esk11893_4(X1,X2,X3,X4) ) ).

cnf(i_0_8040,axiom,
    ( esk7775_4(X1,X2,X3,X4)
    | ~ esk7746_4(X1,X2,X3,X4)
    | esk7695_4(X1,X2,X3,X4) ) ).

cnf(i_0_8041,axiom,
    ( ~ esk10570_4(X1,X2,X3,X4)
    | ~ esk10568_4(X1,X2,X3,X4) ) ).

cnf(i_0_8042,axiom,
    ( ~ esk10293_4(X1,X2,X3,X4)
    | esk10289_4(X1,X2,X3,X4) ) ).

cnf(i_0_8043,axiom,
    ( esk11061_4(X1,X2,X3,X4)
    | ~ esk10941_4(X1,X2,X3,X4) ) ).

cnf(i_0_8044,axiom,
    ( ~ esk16486_4(X1,X2,X3,X4)
    | ~ esk16433_4(X1,X2,X3,X4)
    | ~ esk16484_4(X1,X2,X3,X4)
    | ~ esk16431_4(X1,X2,X3,X4) ) ).

cnf(i_0_8045,axiom,
    ( esk4041_4(X1,X2,X3,X4)
    | esk4079_4(X1,X2,X3,X4) ) ).

cnf(i_0_8046,axiom,
    ( ~ esk6820_4(X1,X2,X3,X4)
    | esk6796_4(X1,X2,X3,X4) ) ).

cnf(i_0_8047,axiom,
    ( esk6990_4(X1,X2,X3,X4)
    | ~ esk7009_4(X1,X2,X3,X4)
    | esk6938_4(X1,X2,X3,X4) ) ).

cnf(i_0_8048,axiom,
    ( ~ esk14405_4(X1,X2,X3,X4)
    | ~ esk14316_4(X1,X2,X3,X4) ) ).

cnf(i_0_8049,axiom,
    ( esk6161_4(X1,X2,X3,X4)
    | esk6200_4(X1,X2,X3,X4) ) ).

cnf(i_0_8050,axiom,
    ( esk11273_4(X1,X2,X3,X4)
    | esk11251_4(X1,X2,X3,X4) ) ).

cnf(i_0_8051,axiom,
    ( esk7900_4(X1,X2,X3,X4)
    | esk7925_4(X1,X2,X3,X4) ) ).

cnf(i_0_8052,axiom,
    ( ~ esk11938_4(X1,X2,X3,X4)
    | esk12089_4(X1,X2,X3,X4) ) ).

cnf(i_0_8053,axiom,
    ( esk12534_4(X1,X2,X3,X4)
    | esk12541_4(X1,X2,X3,X4) ) ).

cnf(i_0_8054,axiom,
    ( ~ esk15715_4(X1,X2,X3,X4)
    | ~ esk15714_4(X1,X2,X3,X4)
    | ~ esk15740_4(X1,X2,X3,X4) ) ).

cnf(i_0_8055,axiom,
    ( ~ esk11336_4(X1,X2,X3,X4)
    | ~ esk11337_4(X1,X2,X3,X4)
    | ~ esk11358_4(X1,X2,X3,X4) ) ).

cnf(i_0_8056,axiom,
    ( esk10418_4(X1,X2,X3,X4)
    | ~ esk10394_4(X1,X2,X3,X4) ) ).

cnf(i_0_8057,axiom,
    ( esk4811_4(X1,X2,X3,X4)
    | esk4852_4(X1,X2,X3,X4) ) ).

cnf(i_0_8058,axiom,
    ( ~ esk7106_4(X1,X2,X3,X4)
    | ~ esk7101_4(X1,X2,X3,X4) ) ).

cnf(i_0_8059,axiom,
    ( ~ esk13077_4(X1,X2,X3,X4)
    | ~ esk13048_4(X1,X2,X3,X4)
    | ~ esk13110_4(X1,X2,X3,X4) ) ).

cnf(i_0_8060,axiom,
    ( esk14977_4(X1,X2,X3,X4)
    | esk14942_4(X1,X2,X3,X4) ) ).

cnf(i_0_8061,axiom,
    ( ~ esk11882_4(X1,X2,X3,X4)
    | esk11880_4(X1,X2,X3,X4) ) ).

cnf(i_0_8062,axiom,
    ( esk527_4(X1,X2,X3,X4)
    | esk438_4(X1,X2,X3,X4) ) ).

cnf(i_0_8063,axiom,
    ( ~ esk14335_4(X1,X2,X3,X4)
    | ~ esk14334_4(X1,X2,X3,X4) ) ).

cnf(i_0_8064,axiom,
    ( ~ esk6428_4(X1,X2,X3,X4)
    | esk6480_4(X1,X2,X3,X4) ) ).

cnf(i_0_8065,axiom,
    ( esk1433_4(X1,X2,X3,X4)
    | ~ esk1424_4(X1,X2,X3,X4) ) ).

cnf(i_0_8066,axiom,
    ( ~ esk9542_4(X1,X2,X3,X4)
    | esk9498_4(X1,X2,X3,X4)
    | esk9549_4(X1,X2,X3,X4) ) ).

cnf(i_0_8067,axiom,
    ( esk7147_4(X1,X2,X3,X4)
    | esk7133_4(X1,X2,X3,X4) ) ).

cnf(i_0_8068,axiom,
    ( esk3608_4(X1,X2,X3,X4)
    | ~ esk3488_4(X1,X2,X3,X4) ) ).

cnf(i_0_8069,axiom,
    ( esk985_4(X1,X2,X3,X4)
    | esk962_4(X1,X2,X3,X4) ) ).

cnf(i_0_8070,axiom,
    ( esk10563_4(X1,X2,X3,X4)
    | esk10564_4(X1,X2,X3,X4)
    | esk10562_4(X1,X2,X3,X4) ) ).

cnf(i_0_8071,axiom,
    ( ~ esk14158_4(X1,X2,X3,X4)
    | ~ esk14176_4(X1,X2,X3,X4) ) ).

cnf(i_0_8072,axiom,
    ( ~ esk5633_4(X1,X2,X3,X4)
    | ~ esk5545_4(X1,X2,X3,X4)
    | esk5535_4(X1,X2,X3,X4) ) ).

cnf(i_0_8073,axiom,
    ( p(X1)
    | ~ esk260_0
    | p(X4)
    | ~ p(X3)
    | p(X2)
    | esk16707_4(X1,X2,X3,X4) ) ).

cnf(i_0_8074,axiom,
    ( esk4079_4(X1,X2,X3,X4)
    | esk4055_4(X1,X2,X3,X4) ) ).

cnf(i_0_8075,axiom,
    ( ~ esk2215_4(X1,X2,X3,X4)
    | esk2221_4(X1,X2,X3,X4) ) ).

cnf(i_0_8076,axiom,
    ( esk14847_4(X1,X2,X3,X4)
    | esk14870_4(X1,X2,X3,X4) ) ).

cnf(i_0_8077,axiom,
    ( esk16187_4(X1,X2,X3,X4)
    | ~ esk16121_4(X1,X2,X3,X4) ) ).

cnf(i_0_8078,axiom,
    ( esk10281_4(X1,X2,X3,X4)
    | ~ esk10157_4(X1,X2,X3,X4) ) ).

cnf(i_0_8079,axiom,
    ( p(X2)
    | p(X4)
    | ~ esk16707_4(X1,X2,X3,X4)
    | esk260_0
    | ~ p(X3)
    | p(X1) ) ).

cnf(i_0_8080,axiom,
    ( esk740_4(X1,X2,X3,X4)
    | esk714_4(X1,X2,X3,X4) ) ).

cnf(i_0_8081,axiom,
    ( ~ esk6895_4(X1,X2,X3,X4)
    | ~ esk6880_4(X1,X2,X3,X4)
    | ~ esk6928_4(X1,X2,X3,X4) ) ).

cnf(i_0_8082,axiom,
    ( esk11255_4(X1,X2,X3,X4)
    | esk11251_4(X1,X2,X3,X4) ) ).

cnf(i_0_8083,axiom,
    ( ~ esk4417_4(X1,X2,X3,X4)
    | esk4415_4(X1,X2,X3,X4) ) ).

cnf(i_0_8084,axiom,
    ( esk7621_4(X1,X2,X3,X4)
    | ~ esk7623_4(X1,X2,X3,X4) ) ).

cnf(i_0_8085,axiom,
    ( ~ esk8986_4(X1,X2,X3,X4)
    | esk8728_4(X1,X2,X3,X4) ) ).

cnf(i_0_8086,axiom,
    ( esk4886_4(X1,X2,X3,X4)
    | ~ esk4761_4(X1,X2,X3,X4) ) ).

cnf(i_0_8087,axiom,
    ( esk10806_4(X1,X2,X3,X4)
    | ~ esk10805_4(X1,X2,X3,X4) ) ).

cnf(i_0_8088,axiom,
    ( esk7375_4(X1,X2,X3,X4)
    | ~ esk7323_4(X1,X2,X3,X4) ) ).

cnf(i_0_8089,axiom,
    ( ~ esk13050_4(X1,X2,X3,X4)
    | ~ esk13028_4(X1,X2,X3,X4) ) ).

cnf(i_0_8090,axiom,
    ( esk3379_4(X1,X2,X3,X4)
    | esk3380_4(X1,X2,X3,X4)
    | esk3378_4(X1,X2,X3,X4) ) ).

cnf(i_0_8091,axiom,
    ( ~ esk7936_4(X1,X2,X3,X4)
    | ~ esk7935_4(X1,X2,X3,X4)
    | ~ esk7895_4(X1,X2,X3,X4) ) ).

cnf(i_0_8092,axiom,
    ( esk2601_4(X1,X2,X3,X4)
    | esk2615_4(X1,X2,X3,X4) ) ).

cnf(i_0_8093,axiom,
    ( esk548_4(X1,X2,X3,X4)
    | esk547_4(X1,X2,X3,X4) ) ).

cnf(i_0_8094,axiom,
    ( esk9567_4(X1,X2,X3,X4)
    | ~ esk9569_4(X1,X2,X3,X4) ) ).

cnf(i_0_8095,axiom,
    ( ~ esk547_4(X1,X2,X3,X4)
    | esk503_4(X1,X2,X3,X4)
    | esk554_4(X1,X2,X3,X4) ) ).

cnf(i_0_8096,axiom,
    ( ~ esk9404_4(X1,X2,X3,X4)
    | esk9662_4(X1,X2,X3,X4) ) ).

cnf(i_0_8097,axiom,
    ( ~ esk11073_4(X1,X2,X3,X4)
    | esk11110_4(X1,X2,X3,X4) ) ).

cnf(i_0_8098,axiom,
    ( ~ esk5903_4(X1,X2,X3,X4)
    | esk5843_4(X1,X2,X3,X4) ) ).

cnf(i_0_8099,axiom,
    ( esk4674_4(X1,X2,X3,X4)
    | ~ esk4673_4(X1,X2,X3,X4)
    | ~ esk4672_4(X1,X2,X3,X4) ) ).

cnf(i_0_8100,axiom,
    ( ~ esk113_0
    | esk497_4(X1,X2,X3,X4)
    | ~ p(X2)
    | p(X1)
    | p(X4)
    | ~ p(X3) ) ).

cnf(i_0_8101,axiom,
    ( ~ esk14020_4(X1,X2,X3,X4)
    | esk13988_4(X1,X2,X3,X4) ) ).

cnf(i_0_8102,axiom,
    ( esk5098_4(X1,X2,X3,X4)
    | esk5131_4(X1,X2,X3,X4) ) ).

cnf(i_0_8103,axiom,
    ( esk4780_4(X1,X2,X3,X4)
    | ~ esk4796_4(X1,X2,X3,X4) ) ).

cnf(i_0_8104,axiom,
    ( esk6408_4(X1,X2,X3,X4)
    | esk6489_4(X1,X2,X3,X4)
    | ~ esk6496_4(X1,X2,X3,X4) ) ).

cnf(i_0_8105,axiom,
    ( ~ esk8499_4(X1,X2,X3,X4)
    | esk8498_4(X1,X2,X3,X4) ) ).

cnf(i_0_8106,axiom,
    ( esk8016_4(X1,X2,X3,X4)
    | esk7962_4(X1,X2,X3,X4)
    | ~ esk7997_4(X1,X2,X3,X4) ) ).

cnf(i_0_8107,axiom,
    ( ~ esk6346_4(X1,X2,X3,X4)
    | ~ esk6445_4(X1,X2,X3,X4) ) ).

cnf(i_0_8108,axiom,
    ( esk4323_4(X1,X2,X3,X4)
    | esk4304_4(X1,X2,X3,X4) ) ).

cnf(i_0_8109,axiom,
    ( ~ esk15162_4(X1,X2,X3,X4)
    | esk15039_4(X1,X2,X3,X4)
    | ~ esk15054_4(X1,X2,X3,X4) ) ).

cnf(i_0_8110,axiom,
    ( ~ esk10030_4(X1,X2,X3,X4)
    | esk10081_4(X1,X2,X3,X4) ) ).

cnf(i_0_8111,axiom,
    ( esk16666_4(X1,X2,X3,X4)
    | esk16753_4(X1,X2,X3,X4) ) ).

cnf(i_0_8112,axiom,
    ( ~ esk2097_4(X1,X2,X3,X4)
    | ~ esk2079_4(X1,X2,X3,X4) ) ).

cnf(i_0_8113,axiom,
    ( ~ esk9924_4(X1,X2,X3,X4)
    | ~ esk9925_4(X1,X2,X3,X4) ) ).

cnf(i_0_8114,axiom,
    ( ~ esk10524_4(X1,X2,X3,X4)
    | esk10266_4(X1,X2,X3,X4) ) ).

cnf(i_0_8115,axiom,
    ( ~ esk15964_4(X1,X2,X3,X4)
    | ~ esk15965_4(X1,X2,X3,X4)
    | ~ esk15929_4(X1,X2,X3,X4) ) ).

cnf(i_0_8116,axiom,
    ( ~ esk12872_4(X1,X2,X3,X4)
    | ~ esk12857_4(X1,X2,X3,X4) ) ).

cnf(i_0_8117,axiom,
    ( ~ esk1949_4(X1,X2,X3,X4)
    | ~ esk1922_4(X1,X2,X3,X4) ) ).

cnf(i_0_8118,axiom,
    ( ~ esk4882_4(X1,X2,X3,X4)
    | ~ esk4849_4(X1,X2,X3,X4)
    | ~ esk4824_4(X1,X2,X3,X4) ) ).

cnf(i_0_8119,axiom,
    ( ~ esk14645_4(X1,X2,X3,X4)
    | esk14903_4(X1,X2,X3,X4) ) ).

cnf(i_0_8120,axiom,
    ( esk10057_4(X1,X2,X3,X4)
    | esk10010_4(X1,X2,X3,X4)
    | ~ esk10091_4(X1,X2,X3,X4) ) ).

cnf(i_0_8121,axiom,
    ( ~ esk6416_4(X1,X2,X3,X4)
    | esk6467_4(X1,X2,X3,X4) ) ).

cnf(i_0_8122,axiom,
    ( ~ esk801_4(X1,X2,X3,X4)
    | ~ esk820_4(X1,X2,X3,X4)
    | ~ esk766_4(X1,X2,X3,X4) ) ).

cnf(i_0_8123,axiom,
    ( ~ esk9295_4(X1,X2,X3,X4)
    | ~ esk9294_4(X1,X2,X3,X4)
    | esk9296_4(X1,X2,X3,X4) ) ).

cnf(i_0_8124,axiom,
    ( ~ esk6220_4(X1,X2,X3,X4)
    | esk6169_4(X1,X2,X3,X4)
    | esk6195_4(X1,X2,X3,X4) ) ).

cnf(i_0_8125,axiom,
    ( esk2885_4(X1,X2,X3,X4)
    | ~ esk2834_4(X1,X2,X3,X4) ) ).

cnf(i_0_8126,axiom,
    ( esk10009_4(X1,X2,X3,X4)
    | ~ esk10267_4(X1,X2,X3,X4) ) ).

cnf(i_0_8127,axiom,
    ( esk16338_4(X1,X2,X3,X4)
    | esk16463_4(X1,X2,X3,X4) ) ).

cnf(i_0_8128,axiom,
    ( esk2039_4(X1,X2,X3,X4)
    | ~ esk1939_4(X1,X2,X3,X4) ) ).

cnf(i_0_8129,axiom,
    ( ~ esk15146_4(X1,X2,X3,X4)
    | ~ esk15227_4(X1,X2,X3,X4)
    | ~ esk15234_4(X1,X2,X3,X4) ) ).

cnf(i_0_8130,axiom,
    ( esk10301_4(X1,X2,X3,X4)
    | esk10294_4(X1,X2,X3,X4) ) ).

cnf(i_0_8131,axiom,
    ( ~ p(X1)
    | ~ p(X2)
    | p(X4)
    | p(X3)
    | ~ esk135_0
    | esk16689_4(X1,X2,X3,X4) ) ).

cnf(i_0_8132,axiom,
    ( ~ esk14707_4(X1,X2,X3,X4)
    | esk14709_4(X1,X2,X3,X4)
    | ~ esk14708_4(X1,X2,X3,X4) ) ).

cnf(i_0_8133,axiom,
    ( esk405_4(X1,X2,X3,X4)
    | ~ esk397_4(X1,X2,X3,X4) ) ).

cnf(i_0_8134,axiom,
    ( ~ esk13553_4(X1,X2,X3,X4)
    | ~ esk13582_4(X1,X2,X3,X4)
    | ~ esk13581_4(X1,X2,X3,X4) ) ).

cnf(i_0_8135,axiom,
    ( esk10521_4(X1,X2,X3,X4)
    | ~ esk10779_4(X1,X2,X3,X4) ) ).

cnf(i_0_8136,axiom,
    ( ~ esk4147_4(X1,X2,X3,X4)
    | ~ esk4148_4(X1,X2,X3,X4) ) ).

cnf(i_0_8137,axiom,
    ( esk5977_4(X1,X2,X3,X4)
    | esk5945_4(X1,X2,X3,X4) ) ).

cnf(i_0_8138,axiom,
    ( ~ esk9278_4(X1,X2,X3,X4)
    | ~ esk9279_4(X1,X2,X3,X4) ) ).

cnf(i_0_8139,axiom,
    ( ~ esk5338_4(X1,X2,X3,X4)
    | ~ esk5284_4(X1,X2,X3,X4) ) ).

cnf(i_0_8140,axiom,
    ( ~ esk10248_4(X1,X2,X3,X4)
    | ~ esk10208_4(X1,X2,X3,X4)
    | ~ esk10249_4(X1,X2,X3,X4) ) ).

cnf(i_0_8141,axiom,
    ( ~ esk9668_4(X1,X2,X3,X4)
    | esk9674_4(X1,X2,X3,X4) ) ).

cnf(i_0_8142,axiom,
    ( ~ esk13565_4(X1,X2,X3,X4)
    | ~ esk13598_4(X1,X2,X3,X4)
    | ~ esk13562_4(X1,X2,X3,X4) ) ).

cnf(i_0_8143,axiom,
    ( esk10838_4(X1,X2,X3,X4)
    | ~ esk10837_4(X1,X2,X3,X4)
    | ~ esk10836_4(X1,X2,X3,X4) ) ).

cnf(i_0_8144,axiom,
    ( ~ esk1482_4(X1,X2,X3,X4)
    | esk1518_4(X1,X2,X3,X4) ) ).

cnf(i_0_8145,axiom,
    ( ~ esk5631_4(X1,X2,X3,X4)
    | ~ esk5678_4(X1,X2,X3,X4)
    | ~ esk5715_4(X1,X2,X3,X4) ) ).

cnf(i_0_8146,axiom,
    ( esk1813_4(X1,X2,X3,X4)
    | esk1820_4(X1,X2,X3,X4) ) ).

cnf(i_0_8147,axiom,
    ( esk8183_4(X1,X2,X3,X4)
    | esk8157_4(X1,X2,X3,X4) ) ).

cnf(i_0_8148,axiom,
    ( esk13074_4(X1,X2,X3,X4)
    | esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_8149,axiom,
    ( esk16200_4(X1,X2,X3,X4)
    | ~ esk16202_4(X1,X2,X3,X4) ) ).

cnf(i_0_8150,axiom,
    ( ~ esk5858_4(X1,X2,X3,X4)
    | ~ esk5850_4(X1,X2,X3,X4)
    | ~ esk5857_4(X1,X2,X3,X4) ) ).

cnf(i_0_8151,axiom,
    ( esk972_4(X1,X2,X3,X4)
    | esk968_4(X1,X2,X3,X4) ) ).

cnf(i_0_8152,axiom,
    ( esk14959_4(X1,X2,X3,X4)
    | esk14931_4(X1,X2,X3,X4) ) ).

cnf(i_0_8153,axiom,
    ( ~ esk6934_4(X1,X2,X3,X4)
    | esk6813_4(X1,X2,X3,X4)
    | ~ esk6830_4(X1,X2,X3,X4) ) ).

cnf(i_0_8154,axiom,
    ( ~ esk9422_4(X1,X2,X3,X4)
    | esk9406_4(X1,X2,X3,X4) ) ).

cnf(i_0_8155,axiom,
    ( esk6942_4(X1,X2,X3,X4)
    | esk6965_4(X1,X2,X3,X4) ) ).

cnf(i_0_8156,axiom,
    ( esk10055_4(X1,X2,X3,X4)
    | esk10016_4(X1,X2,X3,X4) ) ).

cnf(i_0_8157,axiom,
    ( esk4055_4(X1,X2,X3,X4)
    | esk4087_4(X1,X2,X3,X4) ) ).

cnf(i_0_8158,axiom,
    ( ~ esk3328_4(X1,X2,X3,X4)
    | esk3409_4(X1,X2,X3,X4) ) ).

cnf(i_0_8159,axiom,
    ( esk13263_4(X1,X2,X3,X4)
    | esk13269_4(X1,X2,X3,X4)
    | esk13268_4(X1,X2,X3,X4) ) ).

cnf(i_0_8160,axiom,
    ( esk8982_4(X1,X2,X3,X4)
    | esk9030_4(X1,X2,X3,X4) ) ).

cnf(i_0_8161,axiom,
    ( esk936_4(X1,X2,X3,X4)
    | ~ esk930_4(X1,X2,X3,X4) ) ).

cnf(i_0_8162,axiom,
    ( esk15368_4(X1,X2,X3,X4)
    | esk15358_4(X1,X2,X3,X4) ) ).

cnf(i_0_8163,axiom,
    ( esk8013_4(X1,X2,X3,X4)
    | ~ esk7999_4(X1,X2,X3,X4) ) ).

cnf(i_0_8164,axiom,
    ( esk2859_4(X1,X2,X3,X4)
    | esk2899_4(X1,X2,X3,X4)
    | esk2858_4(X1,X2,X3,X4)
    | esk2860_4(X1,X2,X3,X4) ) ).

cnf(i_0_8165,axiom,
    ( ~ esk132_0
    | ~ p(X1)
    | ~ p(X3)
    | esk499_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4) ) ).

cnf(i_0_8166,axiom,
    ( esk16763_4(X1,X2,X3,X4)
    | ~ esk16765_4(X1,X2,X3,X4) ) ).

cnf(i_0_8167,axiom,
    ( esk7946_4(X1,X2,X3,X4)
    | ~ esk7688_4(X1,X2,X3,X4) ) ).

cnf(i_0_8168,axiom,
    ( p(X1)
    | ~ esk491_4(X1,X2,X3,X4)
    | esk66_0
    | ~ p(X2)
    | p(X4)
    | p(X3) ) ).

cnf(i_0_8169,axiom,
    ( esk11382_4(X1,X2,X3,X4)
    | esk11372_4(X1,X2,X3,X4) ) ).

cnf(i_0_8170,axiom,
    ( ~ esk1997_4(X1,X2,X3,X4)
    | ~ esk2051_4(X1,X2,X3,X4)
    | ~ esk2018_4(X1,X2,X3,X4) ) ).

cnf(i_0_8171,axiom,
    ( ~ esk14143_4(X1,X2,X3,X4)
    | esk14144_4(X1,X2,X3,X4) ) ).

cnf(i_0_8172,axiom,
    ( esk12727_4(X1,X2,X3,X4)
    | ~ esk12741_4(X1,X2,X3,X4)
    | ~ esk12851_4(X1,X2,X3,X4) ) ).

cnf(i_0_8173,axiom,
    ( esk15830_4(X1,X2,X3,X4)
    | ~ esk15572_4(X1,X2,X3,X4) ) ).

cnf(i_0_8174,axiom,
    ( ~ esk16322_4(X1,X2,X3,X4)
    | esk16297_4(X1,X2,X3,X4) ) ).

cnf(i_0_8175,axiom,
    ( esk1212_4(X1,X2,X3,X4)
    | esk1256_4(X1,X2,X3,X4) ) ).

cnf(i_0_8176,axiom,
    ( esk1947_4(X1,X2,X3,X4)
    | ~ esk1950_4(X1,X2,X3,X4)
    | ~ esk1923_4(X1,X2,X3,X4) ) ).

cnf(i_0_8177,axiom,
    ( ~ esk11446_4(X1,X2,X3,X4)
    | esk11544_4(X1,X2,X3,X4) ) ).

cnf(i_0_8178,axiom,
    ( esk1296_4(X1,X2,X3,X4)
    | ~ esk1297_4(X1,X2,X3,X4) ) ).

cnf(i_0_8179,axiom,
    ( esk5665_4(X1,X2,X3,X4)
    | ~ esk5666_4(X1,X2,X3,X4) ) ).

cnf(i_0_8180,axiom,
    ( ~ esk11858_4(X1,X2,X3,X4)
    | esk11887_4(X1,X2,X3,X4)
    | esk11807_4(X1,X2,X3,X4) ) ).

cnf(i_0_8181,axiom,
    ( esk9914_4(X1,X2,X3,X4)
    | ~ esk9908_4(X1,X2,X3,X4) ) ).

cnf(i_0_8182,axiom,
    ( ~ esk15135_4(X1,X2,X3,X4)
    | ~ esk15089_4(X1,X2,X3,X4)
    | ~ esk15136_4(X1,X2,X3,X4) ) ).

cnf(i_0_8183,axiom,
    ( esk988_4(X1,X2,X3,X4)
    | esk1021_4(X1,X2,X3,X4) ) ).

cnf(i_0_8184,axiom,
    ( ~ esk14362_4(X1,X2,X3,X4)
    | ~ esk14333_4(X1,X2,X3,X4)
    | ~ esk14395_4(X1,X2,X3,X4) ) ).

cnf(i_0_8185,axiom,
    ( esk7008_4(X1,X2,X3,X4)
    | esk6894_4(X1,X2,X3,X4) ) ).

cnf(i_0_8186,axiom,
    ( esk13368_4(X1,X2,X3,X4)
    | ~ esk13290_4(X1,X2,X3,X4) ) ).

cnf(i_0_8187,axiom,
    ( ~ esk15880_4(X1,X2,X3,X4)
    | ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15913_4(X1,X2,X3,X4) ) ).

cnf(i_0_8188,axiom,
    ( esk1767_4(X1,X2,X3,X4)
    | esk1800_4(X1,X2,X3,X4) ) ).

cnf(i_0_8189,axiom,
    ( esk13622_4(X1,X2,X3,X4)
    | ~ esk13364_4(X1,X2,X3,X4) ) ).

cnf(i_0_8190,axiom,
    ( ~ esk12809_4(X1,X2,X3,X4)
    | ~ esk12808_4(X1,X2,X3,X4)
    | ~ esk12783_4(X1,X2,X3,X4) ) ).

cnf(i_0_8191,axiom,
    ( esk12087_4(X1,X2,X3,X4)
    | esk12092_4(X1,X2,X3,X4)
    | ~ esk12088_4(X1,X2,X3,X4) ) ).

cnf(i_0_8192,axiom,
    ( esk1866_4(X1,X2,X3,X4)
    | ~ esk1834_4(X1,X2,X3,X4) ) ).

cnf(i_0_8193,axiom,
    ( esk14120_4(X1,X2,X3,X4)
    | ~ esk14019_4(X1,X2,X3,X4) ) ).

cnf(i_0_8194,axiom,
    ( esk8163_4(X1,X2,X3,X4)
    | ~ esk8202_4(X1,X2,X3,X4) ) ).

cnf(i_0_8195,axiom,
    ( esk15466_4(X1,X2,X3,X4)
    | ~ esk15465_4(X1,X2,X3,X4) ) ).

cnf(i_0_8196,axiom,
    ( esk14654_4(X1,X2,X3,X4)
    | esk14706_4(X1,X2,X3,X4) ) ).

cnf(i_0_8197,axiom,
    ( ~ esk14387_4(X1,X2,X3,X4)
    | ~ esk14283_4(X1,X2,X3,X4)
    | esk14266_4(X1,X2,X3,X4) ) ).

cnf(i_0_8198,axiom,
    ( ~ esk7249_4(X1,X2,X3,X4)
    | esk7250_4(X1,X2,X3,X4) ) ).

cnf(i_0_8199,axiom,
    ( esk6572_4(X1,X2,X3,X4)
    | esk6549_4(X1,X2,X3,X4)
    | esk6574_4(X1,X2,X3,X4) ) ).

cnf(i_0_8200,axiom,
    ( esk14137_4(X1,X2,X3,X4)
    | ~ esk14395_4(X1,X2,X3,X4) ) ).

cnf(i_0_8201,axiom,
    ( esk12764_4(X1,X2,X3,X4)
    | ~ esk12765_4(X1,X2,X3,X4)
    | esk12769_4(X1,X2,X3,X4) ) ).

cnf(i_0_8202,axiom,
    ( ~ esk12759_4(X1,X2,X3,X4)
    | esk12757_4(X1,X2,X3,X4) ) ).

cnf(i_0_8203,axiom,
    ( esk9795_4(X1,X2,X3,X4)
    | esk9796_4(X1,X2,X3,X4)
    | esk9794_4(X1,X2,X3,X4) ) ).

cnf(i_0_8204,axiom,
    ( esk927_4(X1,X2,X3,X4)
    | esk926_4(X1,X2,X3,X4) ) ).

cnf(i_0_8205,axiom,
    ( ~ esk4063_4(X1,X2,X3,X4)
    | ~ esk4055_4(X1,X2,X3,X4)
    | ~ esk4186_4(X1,X2,X3,X4) ) ).

cnf(i_0_8206,axiom,
    ( esk11807_4(X1,X2,X3,X4)
    | esk11860_4(X1,X2,X3,X4) ) ).

cnf(i_0_8207,axiom,
    ( ~ esk5846_4(X1,X2,X3,X4)
    | esk5897_4(X1,X2,X3,X4) ) ).

cnf(i_0_8208,axiom,
    ( esk14632_4(X1,X2,X3,X4)
    | esk14599_4(X1,X2,X3,X4) ) ).

cnf(i_0_8209,axiom,
    ( ~ esk10568_4(X1,X2,X3,X4)
    | ~ esk10560_4(X1,X2,X3,X4) ) ).

cnf(i_0_8210,axiom,
    ( ~ esk9727_4(X1,X2,X3,X4)
    | ~ esk9814_4(X1,X2,X3,X4)
    | ~ esk9709_4(X1,X2,X3,X4) ) ).

cnf(i_0_8211,axiom,
    ( esk14140_4(X1,X2,X3,X4)
    | ~ esk14014_4(X1,X2,X3,X4) ) ).

cnf(i_0_8212,axiom,
    ( ~ esk8227_4(X1,X2,X3,X4)
    | esk8279_4(X1,X2,X3,X4) ) ).

cnf(i_0_8213,axiom,
    ( p(X4)
    | ~ p(X1)
    | ~ p(X3)
    | esk193_0
    | ~ esk16697_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_8214,axiom,
    ( ~ esk10852_4(X1,X2,X3,X4)
    | esk10801_4(X1,X2,X3,X4)
    | esk10851_4(X1,X2,X3,X4) ) ).

cnf(i_0_8215,axiom,
    ( esk5455_4(X1,X2,X3,X4)
    | ~ esk5404_4(X1,X2,X3,X4) ) ).

cnf(i_0_8216,axiom,
    ( esk4592_4(X1,X2,X3,X4)
    | esk4625_4(X1,X2,X3,X4) ) ).

cnf(i_0_8217,axiom,
    ( ~ esk4522_4(X1,X2,X3,X4)
    | esk4264_4(X1,X2,X3,X4) ) ).

cnf(i_0_8218,axiom,
    ( ~ esk14546_4(X1,X2,X3,X4)
    | esk14804_4(X1,X2,X3,X4) ) ).

cnf(i_0_8219,axiom,
    ( ~ esk14383_4(X1,X2,X3,X4)
    | ~ esk14464_4(X1,X2,X3,X4) ) ).

cnf(i_0_8220,axiom,
    ( esk14591_4(X1,X2,X3,X4)
    | esk14536_4(X1,X2,X3,X4) ) ).

cnf(i_0_8221,axiom,
    ( ~ esk4956_4(X1,X2,X3,X4)
    | ~ esk4850_4(X1,X2,X3,X4)
    | ~ esk4826_4(X1,X2,X3,X4) ) ).

cnf(i_0_8222,axiom,
    ( ~ esk1201_4(X1,X2,X3,X4)
    | esk1181_4(X1,X2,X3,X4)
    | esk1205_4(X1,X2,X3,X4) ) ).

cnf(i_0_8223,axiom,
    ( ~ esk6410_4(X1,X2,X3,X4)
    | esk6152_4(X1,X2,X3,X4) ) ).

cnf(i_0_8224,axiom,
    ( ~ esk3592_4(X1,X2,X3,X4)
    | esk3529_4(X1,X2,X3,X4) ) ).

cnf(i_0_8225,axiom,
    ( ~ esk313_0
    | p(X4)
    | ~ p(X3)
    | ~ p(X1)
    | esk16717_4(X1,X2,X3,X4)
    | p(X2) ) ).

cnf(i_0_8226,axiom,
    ( ~ esk11735_4(X1,X2,X3,X4)
    | esk11719_4(X1,X2,X3,X4) ) ).

cnf(i_0_8227,axiom,
    ( esk7511_4(X1,X2,X3,X4)
    | ~ esk7460_4(X1,X2,X3,X4) ) ).

cnf(i_0_8228,axiom,
    ( esk2078_4(X1,X2,X3,X4)
    | esk2031_4(X1,X2,X3,X4) ) ).

cnf(i_0_8229,axiom,
    ( esk13819_4(X1,X2,X3,X4)
    | esk13836_4(X1,X2,X3,X4) ) ).

cnf(i_0_8230,axiom,
    ( esk3375_4(X1,X2,X3,X4)
    | esk3330_4(X1,X2,X3,X4) ) ).

cnf(i_0_8231,axiom,
    ( ~ p(X3)
    | ~ esk58_0
    | p(X4)
    | esk16623_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X2) ) ).

cnf(i_0_8232,axiom,
    ( ~ esk12588_4(X1,X2,X3,X4)
    | esk12330_4(X1,X2,X3,X4) ) ).

cnf(i_0_8233,axiom,
    ( esk10097_4(X1,X2,X3,X4)
    | esk9974_4(X1,X2,X3,X4) ) ).

cnf(i_0_8234,axiom,
    ( ~ esk3535_4(X1,X2,X3,X4)
    | esk3580_4(X1,X2,X3,X4) ) ).

cnf(i_0_8235,axiom,
    ( esk3257_4(X1,X2,X3,X4)
    | ~ esk3237_4(X1,X2,X3,X4) ) ).

cnf(i_0_8236,axiom,
    ( ~ esk12735_4(X1,X2,X3,X4)
    | esk12703_4(X1,X2,X3,X4) ) ).

cnf(i_0_8237,axiom,
    ( ~ esk9965_4(X1,X2,X3,X4)
    | ~ esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_8238,axiom,
    ( ~ esk4534_4(X1,X2,X3,X4)
    | ~ esk4533_4(X1,X2,X3,X4)
    | esk4535_4(X1,X2,X3,X4) ) ).

cnf(i_0_8239,axiom,
    ( esk14449_4(X1,X2,X3,X4)
    | esk14397_4(X1,X2,X3,X4) ) ).

cnf(i_0_8240,axiom,
    ( ~ esk13893_4(X1,X2,X3,X4)
    | ~ esk13768_4(X1,X2,X3,X4) ) ).

cnf(i_0_8241,axiom,
    ( ~ esk5916_4(X1,X2,X3,X4)
    | ~ esk5936_4(X1,X2,X3,X4)
    | ~ esk5918_4(X1,X2,X3,X4) ) ).

cnf(i_0_8242,axiom,
    ( ~ esk15672_4(X1,X2,X3,X4)
    | esk15551_4(X1,X2,X3,X4)
    | ~ esk15568_4(X1,X2,X3,X4) ) ).

cnf(i_0_8243,axiom,
    ( ~ esk161_0
    | p(X4)
    | p(X3)
    | esk16693_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X2) ) ).

cnf(i_0_8244,axiom,
    ( ~ esk15425_4(X1,X2,X3,X4)
    | esk15479_4(X1,X2,X3,X4) ) ).

cnf(i_0_8245,axiom,
    ( esk5728_4(X1,X2,X3,X4)
    | esk5605_4(X1,X2,X3,X4) ) ).

cnf(i_0_8246,axiom,
    ( esk4111_4(X1,X2,X3,X4)
    | esk4078_4(X1,X2,X3,X4) ) ).

cnf(i_0_8247,axiom,
    ( ~ esk7896_4(X1,X2,X3,X4)
    | ~ esk7934_4(X1,X2,X3,X4)
    | ~ esk7933_4(X1,X2,X3,X4) ) ).

cnf(i_0_8248,axiom,
    ( esk2224_4(X1,X2,X3,X4)
    | ~ esk2223_4(X1,X2,X3,X4) ) ).

cnf(i_0_8249,axiom,
    ( ~ esk1997_4(X1,X2,X3,X4)
    | ~ esk2049_4(X1,X2,X3,X4)
    | ~ esk2016_4(X1,X2,X3,X4) ) ).

cnf(i_0_8250,axiom,
    ( ~ esk9400_4(X1,X2,X3,X4)
    | esk9385_4(X1,X2,X3,X4)
    | ~ esk9508_4(X1,X2,X3,X4) ) ).

cnf(i_0_8251,axiom,
    ( esk9793_4(X1,X2,X3,X4)
    | esk9792_4(X1,X2,X3,X4)
    | esk9791_4(X1,X2,X3,X4) ) ).

cnf(i_0_8252,axiom,
    ( esk13011_4(X1,X2,X3,X4)
    | esk13013_4(X1,X2,X3,X4) ) ).

cnf(i_0_8253,axiom,
    ( ~ esk4007_4(X1,X2,X3,X4)
    | esk4029_4(X1,X2,X3,X4) ) ).

cnf(i_0_8254,axiom,
    ( esk9287_4(X1,X2,X3,X4)
    | esk9286_4(X1,X2,X3,X4)
    | esk9288_4(X1,X2,X3,X4) ) ).

cnf(i_0_8255,axiom,
    ( ~ esk1773_4(X1,X2,X3,X4)
    | ~ esk1774_4(X1,X2,X3,X4)
    | ~ esk1724_4(X1,X2,X3,X4) ) ).

cnf(i_0_8256,axiom,
    ( esk5105_4(X1,X2,X3,X4)
    | esk5070_4(X1,X2,X3,X4) ) ).

cnf(i_0_8257,axiom,
    ( ~ esk1537_4(X1,X2,X3,X4)
    | ~ esk1483_4(X1,X2,X3,X4)
    | ~ esk1504_4(X1,X2,X3,X4) ) ).

cnf(i_0_8258,axiom,
    ( esk12281_4(X1,X2,X3,X4)
    | esk12276_4(X1,X2,X3,X4) ) ).

cnf(i_0_8259,axiom,
    ( ~ esk12606_4(X1,X2,X3,X4)
    | ~ esk12515_4(X1,X2,X3,X4)
    | ~ esk12613_4(X1,X2,X3,X4) ) ).

cnf(i_0_8260,axiom,
    ( ~ esk12998_4(X1,X2,X3,X4)
    | esk12993_4(X1,X2,X3,X4)
    | ~ esk13114_4(X1,X2,X3,X4) ) ).

cnf(i_0_8261,axiom,
    ( esk12142_4(X1,X2,X3,X4)
    | esk12117_4(X1,X2,X3,X4)
    | ~ esk12116_4(X1,X2,X3,X4) ) ).

cnf(i_0_8262,axiom,
    ( esk3279_4(X1,X2,X3,X4)
    | ~ esk3321_4(X1,X2,X3,X4) ) ).

cnf(i_0_8263,axiom,
    ( esk6151_4(X1,X2,X3,X4)
    | ~ esk5893_4(X1,X2,X3,X4) ) ).

cnf(i_0_8264,axiom,
    ( ~ esk13090_4(X1,X2,X3,X4)
    | esk12832_4(X1,X2,X3,X4) ) ).

cnf(i_0_8265,axiom,
    ( ~ esk8000_4(X1,X2,X3,X4)
    | ~ esk8039_4(X1,X2,X3,X4) ) ).

cnf(i_0_8266,axiom,
    ( esk16339_4(X1,X2,X3,X4)
    | ~ esk16329_4(X1,X2,X3,X4) ) ).

cnf(i_0_8267,axiom,
    ( ~ esk5397_4(X1,X2,X3,X4)
    | esk5325_4(X1,X2,X3,X4) ) ).

cnf(i_0_8268,axiom,
    ( ~ esk3088_4(X1,X2,X3,X4)
    | esk3010_4(X1,X2,X3,X4) ) ).

cnf(i_0_8269,axiom,
    ( ~ esk10826_4(X1,X2,X3,X4)
    | ~ esk10817_4(X1,X2,X3,X4) ) ).

cnf(i_0_8270,axiom,
    ( esk4647_4(X1,X2,X3,X4)
    | esk4640_4(X1,X2,X3,X4) ) ).

cnf(i_0_8271,axiom,
    ( ~ esk3393_4(X1,X2,X3,X4)
    | esk3368_4(X1,X2,X3,X4)
    | esk3342_4(X1,X2,X3,X4) ) ).

cnf(i_0_8272,axiom,
    ( ~ esk7218_4(X1,X2,X3,X4)
    | ~ esk7203_4(X1,X2,X3,X4) ) ).

cnf(i_0_8273,axiom,
    ( ~ p(X4)
    | ~ esk507_4(X1,X2,X3,X4)
    | p(X1)
    | esk189_0
    | ~ p(X2)
    | ~ p(X3) ) ).

cnf(i_0_8274,axiom,
    ( esk1197_4(X1,X2,X3,X4)
    | ~ esk1183_4(X1,X2,X3,X4) ) ).

cnf(i_0_8275,axiom,
    ( esk3979_4(X1,X2,X3,X4)
    | esk4004_4(X1,X2,X3,X4)
    | esk4002_4(X1,X2,X3,X4) ) ).

cnf(i_0_8276,axiom,
    ( esk13422_4(X1,X2,X3,X4)
    | ~ esk13421_4(X1,X2,X3,X4) ) ).

cnf(i_0_8277,axiom,
    ( ~ esk8636_4(X1,X2,X3,X4)
    | ~ esk8637_4(X1,X2,X3,X4) ) ).

cnf(i_0_8278,axiom,
    ( esk117_0
    | ~ p(X1)
    | p(X2)
    | ~ p(X3)
    | ~ esk497_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_8279,axiom,
    ( esk5881_4(X1,X2,X3,X4)
    | esk5914_4(X1,X2,X3,X4) ) ).

cnf(i_0_8280,axiom,
    ( esk12829_4(X1,X2,X3,X4)
    | ~ esk12731_4(X1,X2,X3,X4) ) ).

cnf(i_0_8281,axiom,
    ( esk1557_4(X1,X2,X3,X4)
    | esk1556_4(X1,X2,X3,X4)
    | ~ esk1558_4(X1,X2,X3,X4) ) ).

cnf(i_0_8282,axiom,
    ( ~ esk10152_4(X1,X2,X3,X4)
    | esk10271_4(X1,X2,X3,X4) ) ).

cnf(i_0_8283,axiom,
    ( esk16686_4(X1,X2,X3,X4)
    | esk16742_4(X1,X2,X3,X4) ) ).

cnf(i_0_8284,axiom,
    ( esk671_4(X1,X2,X3,X4)
    | ~ esk929_4(X1,X2,X3,X4) ) ).

cnf(i_0_8285,axiom,
    ( esk8636_4(X1,X2,X3,X4)
    | esk8637_4(X1,X2,X3,X4) ) ).

cnf(i_0_8286,axiom,
    ( esk12829_4(X1,X2,X3,X4)
    | ~ esk12571_4(X1,X2,X3,X4) ) ).

cnf(i_0_8287,axiom,
    ( esk10237_4(X1,X2,X3,X4)
    | esk10223_4(X1,X2,X3,X4) ) ).

cnf(i_0_8288,axiom,
    ( ~ esk5201_4(X1,X2,X3,X4)
    | ~ esk5085_4(X1,X2,X3,X4)
    | ~ esk5083_4(X1,X2,X3,X4) ) ).

cnf(i_0_8289,axiom,
    ( ~ esk10034_4(X1,X2,X3,X4)
    | esk10032_4(X1,X2,X3,X4) ) ).

cnf(i_0_8290,axiom,
    ( esk15968_4(X1,X2,X3,X4)
    | esk16000_4(X1,X2,X3,X4) ) ).

cnf(i_0_8291,axiom,
    ( ~ esk4292_4(X1,X2,X3,X4)
    | esk4230_4(X1,X2,X3,X4) ) ).

cnf(i_0_8292,axiom,
    ( ~ esk14885_4(X1,X2,X3,X4)
    | ~ esk14847_4(X1,X2,X3,X4)
    | ~ esk14852_4(X1,X2,X3,X4) ) ).

cnf(i_0_8293,axiom,
    ( esk9134_4(X1,X2,X3,X4)
    | ~ esk9108_4(X1,X2,X3,X4) ) ).

cnf(i_0_8294,axiom,
    ( esk7396_4(X1,X2,X3,X4)
    | esk7410_4(X1,X2,X3,X4) ) ).

cnf(i_0_8295,axiom,
    ( ~ esk9389_4(X1,X2,X3,X4)
    | esk9400_4(X1,X2,X3,X4) ) ).

cnf(i_0_8296,axiom,
    ( ~ esk12270_4(X1,X2,X3,X4)
    | esk12324_4(X1,X2,X3,X4) ) ).

cnf(i_0_8297,axiom,
    ( esk10509_4(X1,X2,X3,X4)
    | esk10542_4(X1,X2,X3,X4) ) ).

cnf(i_0_8298,axiom,
    ( ~ esk7730_4(X1,X2,X3,X4)
    | ~ esk7731_4(X1,X2,X3,X4) ) ).

cnf(i_0_8299,axiom,
    ( esk13576_4(X1,X2,X3,X4)
    | esk13690_4(X1,X2,X3,X4) ) ).

cnf(i_0_8300,axiom,
    ( esk13903_4(X1,X2,X3,X4)
    | esk13885_4(X1,X2,X3,X4) ) ).

cnf(i_0_8301,axiom,
    ( esk9488_4(X1,X2,X3,X4)
    | ~ esk9390_4(X1,X2,X3,X4) ) ).

cnf(i_0_8302,axiom,
    ( esk9742_4(X1,X2,X3,X4)
    | ~ esk9706_4(X1,X2,X3,X4) ) ).

cnf(i_0_8303,axiom,
    ( esk11859_4(X1,X2,X3,X4)
    | esk11861_4(X1,X2,X3,X4)
    | esk11860_4(X1,X2,X3,X4) ) ).

cnf(i_0_8304,axiom,
    ( ~ esk16146_4(X1,X2,X3,X4)
    | ~ esk16134_4(X1,X2,X3,X4)
    | ~ esk16260_4(X1,X2,X3,X4) ) ).

cnf(i_0_8305,axiom,
    ( ~ esk6204_4(X1,X2,X3,X4)
    | ~ esk6153_4(X1,X2,X3,X4)
    | ~ esk6239_4(X1,X2,X3,X4) ) ).

cnf(i_0_8306,axiom,
    ( esk10735_4(X1,X2,X3,X4)
    | esk10762_4(X1,X2,X3,X4) ) ).

cnf(i_0_8307,axiom,
    ( esk7365_4(X1,X2,X3,X4)
    | ~ esk7351_4(X1,X2,X3,X4) ) ).

cnf(i_0_8308,axiom,
    ( ~ esk9143_4(X1,X2,X3,X4)
    | ~ esk9247_4(X1,X2,X3,X4)
    | esk9126_4(X1,X2,X3,X4) ) ).

cnf(i_0_8309,axiom,
    ( esk13830_4(X1,X2,X3,X4)
    | esk13863_4(X1,X2,X3,X4) ) ).

cnf(i_0_8310,axiom,
    ( esk7921_4(X1,X2,X3,X4)
    | esk7902_4(X1,X2,X3,X4) ) ).

cnf(i_0_8311,axiom,
    ( esk7475_4(X1,X2,X3,X4)
    | esk7428_4(X1,X2,X3,X4) ) ).

cnf(i_0_8312,axiom,
    ( esk12775_4(X1,X2,X3,X4)
    | ~ esk12856_4(X1,X2,X3,X4) ) ).

cnf(i_0_8313,axiom,
    ( ~ esk13801_4(X1,X2,X3,X4)
    | ~ esk13898_4(X1,X2,X3,X4) ) ).

cnf(i_0_8314,axiom,
    ( esk2753_4(X1,X2,X3,X4)
    | esk2799_4(X1,X2,X3,X4) ) ).

cnf(i_0_8315,axiom,
    ( esk5851_4(X1,X2,X3,X4)
    | esk5855_4(X1,X2,X3,X4) ) ).

cnf(i_0_8316,axiom,
    ( ~ esk6078_4(X1,X2,X3,X4)
    | esk6079_4(X1,X2,X3,X4) ) ).

cnf(i_0_8317,axiom,
    ( esk9798_4(X1,X2,X3,X4)
    | ~ esk9812_4(X1,X2,X3,X4)
    | esk9811_4(X1,X2,X3,X4) ) ).

cnf(i_0_8318,axiom,
    ( esk1932_4(X1,X2,X3,X4)
    | ~ esk1947_4(X1,X2,X3,X4)
    | ~ esk2055_4(X1,X2,X3,X4) ) ).

cnf(i_0_8319,axiom,
    ( esk10331_4(X1,X2,X3,X4)
    | esk10353_4(X1,X2,X3,X4) ) ).

cnf(i_0_8320,axiom,
    ( esk11609_4(X1,X2,X3,X4)
    | ~ esk11607_4(X1,X2,X3,X4)
    | ~ esk11608_4(X1,X2,X3,X4) ) ).

cnf(i_0_8321,axiom,
    ( esk14174_4(X1,X2,X3,X4)
    | esk14172_4(X1,X2,X3,X4)
    | esk14173_4(X1,X2,X3,X4) ) ).

cnf(i_0_8322,axiom,
    ( esk2246_4(X1,X2,X3,X4)
    | ~ esk2303_4(X1,X2,X3,X4) ) ).

cnf(i_0_8323,axiom,
    ( ~ esk9903_4(X1,X2,X3,X4)
    | esk9881_4(X1,X2,X3,X4) ) ).

cnf(i_0_8324,axiom,
    ( esk4570_4(X1,X2,X3,X4)
    | esk4566_4(X1,X2,X3,X4) ) ).

cnf(i_0_8325,axiom,
    ( esk16399_4(X1,X2,X3,X4)
    | esk16385_4(X1,X2,X3,X4) ) ).

cnf(i_0_8326,axiom,
    ( esk16180_4(X1,X2,X3,X4)
    | esk16224_4(X1,X2,X3,X4)
    | ~ esk16231_4(X1,X2,X3,X4) ) ).

cnf(i_0_8327,axiom,
    ( ~ esk14466_4(X1,X2,X3,X4)
    | ~ esk14456_4(X1,X2,X3,X4) ) ).

cnf(i_0_8328,axiom,
    ( ~ esk4538_4(X1,X2,X3,X4)
    | esk4539_4(X1,X2,X3,X4)
    | ~ esk4537_4(X1,X2,X3,X4) ) ).

cnf(i_0_8329,axiom,
    ( ~ p(X2)
    | ~ p(X1)
    | ~ esk503_4(X1,X2,X3,X4)
    | p(X4)
    | esk166_0
    | ~ p(X3) ) ).

cnf(i_0_8330,axiom,
    ( esk16512_4(X1,X2,X3,X4)
    | esk16519_4(X1,X2,X3,X4)
    | ~ esk16431_4(X1,X2,X3,X4) ) ).

cnf(i_0_8331,axiom,
    ( ~ esk14509_4(X1,X2,X3,X4)
    | esk14666_4(X1,X2,X3,X4) ) ).

cnf(i_0_8332,axiom,
    ( ~ esk5310_4(X1,X2,X3,X4)
    | esk5309_4(X1,X2,X3,X4) ) ).

cnf(i_0_8333,axiom,
    ( ~ esk1289_4(X1,X2,X3,X4)
    | esk1211_4(X1,X2,X3,X4) ) ).

cnf(i_0_8334,axiom,
    ( esk7351_4(X1,X2,X3,X4)
    | esk7352_4(X1,X2,X3,X4) ) ).

cnf(i_0_8335,axiom,
    ( esk16141_4(X1,X2,X3,X4)
    | esk16174_4(X1,X2,X3,X4) ) ).

cnf(i_0_8336,axiom,
    ( esk14015_4(X1,X2,X3,X4)
    | ~ esk13993_4(X1,X2,X3,X4) ) ).

cnf(i_0_8337,axiom,
    ( ~ esk5422_4(X1,X2,X3,X4)
    | ~ esk5450_4(X1,X2,X3,X4) ) ).

cnf(i_0_8338,axiom,
    ( ~ esk8096_4(X1,X2,X3,X4)
    | esk8215_4(X1,X2,X3,X4) ) ).

cnf(i_0_8339,axiom,
    ( esk9992_4(X1,X2,X3,X4)
    | esk9951_4(X1,X2,X3,X4) ) ).

cnf(i_0_8340,axiom,
    ( ~ esk16340_4(X1,X2,X3,X4)
    | ~ esk16290_4(X1,X2,X3,X4)
    | ~ esk16287_4(X1,X2,X3,X4)
    | ~ esk16341_4(X1,X2,X3,X4)
    | ~ esk16288_4(X1,X2,X3,X4) ) ).

cnf(i_0_8341,axiom,
    ( esk13604_4(X1,X2,X3,X4)
    | esk13659_4(X1,X2,X3,X4) ) ).

cnf(i_0_8342,axiom,
    ( esk13797_4(X1,X2,X3,X4)
    | ~ esk13539_4(X1,X2,X3,X4) ) ).

cnf(i_0_8343,axiom,
    ( ~ esk12221_4(X1,X2,X3,X4)
    | esk12227_4(X1,X2,X3,X4) ) ).

cnf(i_0_8344,axiom,
    ( esk9011_4(X1,X2,X3,X4)
    | ~ esk9010_4(X1,X2,X3,X4) ) ).

cnf(i_0_8345,axiom,
    ( esk5931_4(X1,X2,X3,X4)
    | esk5835_4(X1,X2,X3,X4)
    | esk5834_4(X1,X2,X3,X4) ) ).

cnf(i_0_8346,axiom,
    ( esk1348_4(X1,X2,X3,X4)
    | esk1322_4(X1,X2,X3,X4)
    | ~ esk1323_4(X1,X2,X3,X4) ) ).

cnf(i_0_8347,axiom,
    ( esk443_4(X1,X2,X3,X4)
    | ~ esk512_4(X1,X2,X3,X4) ) ).

cnf(i_0_8348,axiom,
    ( esk9969_4(X1,X2,X3,X4)
    | esk9964_4(X1,X2,X3,X4) ) ).

cnf(i_0_8349,axiom,
    ( esk3077_4(X1,X2,X3,X4)
    | esk3044_4(X1,X2,X3,X4) ) ).

cnf(i_0_8350,axiom,
    ( ~ esk16476_4(X1,X2,X3,X4)
    | ~ esk16498_4(X1,X2,X3,X4)
    | ~ esk16477_4(X1,X2,X3,X4) ) ).

cnf(i_0_8351,axiom,
    ( esk12884_4(X1,X2,X3,X4)
    | esk12837_4(X1,X2,X3,X4)
    | ~ esk12918_4(X1,X2,X3,X4) ) ).

cnf(i_0_8352,axiom,
    ( ~ esk1084_4(X1,X2,X3,X4)
    | esk1082_4(X1,X2,X3,X4) ) ).

cnf(i_0_8353,axiom,
    ( esk1263_4(X1,X2,X3,X4)
    | ~ esk1224_4(X1,X2,X3,X4) ) ).

cnf(i_0_8354,axiom,
    ( ~ p(X4)
    | esk16689_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X2)
    | ~ esk128_0
    | p(X1) ) ).

cnf(i_0_8355,axiom,
    ( ~ esk10669_4(X1,X2,X3,X4)
    | esk10642_4(X1,X2,X3,X4) ) ).

cnf(i_0_8356,axiom,
    ( esk15982_4(X1,X2,X3,X4)
    | ~ esk15980_4(X1,X2,X3,X4)
    | ~ esk15981_4(X1,X2,X3,X4) ) ).

cnf(i_0_8357,axiom,
    ( ~ esk10735_4(X1,X2,X3,X4)
    | ~ esk10715_4(X1,X2,X3,X4) ) ).

cnf(i_0_8358,axiom,
    ( esk7626_4(X1,X2,X3,X4)
    | ~ esk7606_4(X1,X2,X3,X4) ) ).

cnf(i_0_8359,axiom,
    ( ~ esk9046_4(X1,X2,X3,X4)
    | ~ esk9068_4(X1,X2,X3,X4) ) ).

cnf(i_0_8360,axiom,
    ( ~ esk11467_4(X1,X2,X3,X4)
    | ~ esk11466_4(X1,X2,X3,X4) ) ).

cnf(i_0_8361,axiom,
    ( esk12785_4(X1,X2,X3,X4)
    | esk12805_4(X1,X2,X3,X4) ) ).

cnf(i_0_8362,axiom,
    ( esk9157_4(X1,X2,X3,X4)
    | esk9171_4(X1,X2,X3,X4) ) ).

cnf(i_0_8363,axiom,
    ( esk5282_4(X1,X2,X3,X4)
    | ~ esk5250_4(X1,X2,X3,X4) ) ).

cnf(i_0_8364,axiom,
    ( ~ esk10591_4(X1,X2,X3,X4)
    | ~ esk10592_4(X1,X2,X3,X4)
    | esk10593_4(X1,X2,X3,X4) ) ).

cnf(i_0_8365,axiom,
    ( esk7130_4(X1,X2,X3,X4)
    | esk7153_4(X1,X2,X3,X4) ) ).

cnf(i_0_8366,axiom,
    ( esk13406_4(X1,X2,X3,X4)
    | ~ esk13405_4(X1,X2,X3,X4) ) ).

cnf(i_0_8367,axiom,
    ( ~ esk644_4(X1,X2,X3,X4)
    | esk621_4(X1,X2,X3,X4) ) ).

cnf(i_0_8368,axiom,
    ( ~ esk9755_4(X1,X2,X3,X4)
    | esk9806_4(X1,X2,X3,X4)
    | esk9799_4(X1,X2,X3,X4) ) ).

cnf(i_0_8369,axiom,
    ( esk8629_4(X1,X2,X3,X4)
    | ~ esk8617_4(X1,X2,X3,X4) ) ).

cnf(i_0_8370,axiom,
    ( ~ esk6659_4(X1,X2,X3,X4)
    | esk6706_4(X1,X2,X3,X4)
    | esk6743_4(X1,X2,X3,X4) ) ).

cnf(i_0_8371,axiom,
    ( ~ p(X3)
    | esk497_4(X1,X2,X3,X4)
    | p(X4)
    | p(X1)
    | ~ esk109_0
    | p(X2) ) ).

cnf(i_0_8372,axiom,
    ( ~ esk16434_4(X1,X2,X3,X4)
    | esk16383_4(X1,X2,X3,X4) ) ).

cnf(i_0_8373,axiom,
    ( esk13057_4(X1,X2,X3,X4)
    | esk13044_4(X1,X2,X3,X4) ) ).

cnf(i_0_8374,axiom,
    ( ~ p(X3)
    | p(X2)
    | p(X1)
    | esk16697_4(X1,X2,X3,X4)
    | ~ esk186_0
    | ~ p(X4) ) ).

cnf(i_0_8375,axiom,
    ( esk4058_4(X1,X2,X3,X4)
    | esk4091_4(X1,X2,X3,X4) ) ).

cnf(i_0_8376,axiom,
    ( ~ esk3796_4(X1,X2,X3,X4)
    | ~ esk3858_4(X1,X2,X3,X4)
    | ~ esk3825_4(X1,X2,X3,X4) ) ).

cnf(i_0_8377,axiom,
    ( esk16596_4(X1,X2,X3,X4)
    | ~ esk16580_4(X1,X2,X3,X4) ) ).

cnf(i_0_8378,axiom,
    ( esk8161_4(X1,X2,X3,X4)
    | ~ esk8206_4(X1,X2,X3,X4) ) ).

cnf(i_0_8379,axiom,
    ( esk10820_4(X1,X2,X3,X4)
    | ~ esk10848_4(X1,X2,X3,X4)
    | esk10847_4(X1,X2,X3,X4) ) ).

cnf(i_0_8380,axiom,
    ( ~ esk2710_4(X1,X2,X3,X4)
    | esk2718_4(X1,X2,X3,X4) ) ).

cnf(i_0_8381,axiom,
    ( esk5070_4(X1,X2,X3,X4)
    | ~ esk5136_4(X1,X2,X3,X4) ) ).

cnf(i_0_8382,axiom,
    ( esk14841_4(X1,X2,X3,X4)
    | esk14861_4(X1,X2,X3,X4) ) ).

cnf(i_0_8383,axiom,
    ( ~ esk2041_4(X1,X2,X3,X4)
    | ~ esk2127_4(X1,X2,X3,X4)
    | ~ esk2092_4(X1,X2,X3,X4) ) ).

cnf(i_0_8384,axiom,
    ( ~ esk1694_4(X1,X2,X3,X4)
    | esk1716_4(X1,X2,X3,X4) ) ).

cnf(i_0_8385,axiom,
    ( esk2985_4(X1,X2,X3,X4)
    | ~ esk2727_4(X1,X2,X3,X4) ) ).

cnf(i_0_8386,axiom,
    ( esk3578_4(X1,X2,X3,X4)
    | ~ esk3836_4(X1,X2,X3,X4) ) ).

cnf(i_0_8387,axiom,
    ( esk13801_4(X1,X2,X3,X4)
    | ~ esk13765_4(X1,X2,X3,X4) ) ).

cnf(i_0_8388,axiom,
    ( esk13526_4(X1,X2,X3,X4)
    | esk13519_4(X1,X2,X3,X4)
    | ~ esk13533_4(X1,X2,X3,X4) ) ).

cnf(i_0_8389,axiom,
    ( ~ esk5810_4(X1,X2,X3,X4)
    | ~ esk5809_4(X1,X2,X3,X4) ) ).

cnf(i_0_8390,axiom,
    ( esk5709_4(X1,X2,X3,X4)
    | ~ esk5679_4(X1,X2,X3,X4) ) ).

cnf(i_0_8391,axiom,
    ( esk747_4(X1,X2,X3,X4)
    | ~ esk711_4(X1,X2,X3,X4) ) ).

cnf(i_0_8392,axiom,
    ( esk12773_4(X1,X2,X3,X4)
    | esk12870_4(X1,X2,X3,X4)
    | esk12774_4(X1,X2,X3,X4) ) ).

cnf(i_0_8393,axiom,
    ( ~ esk1351_4(X1,X2,X3,X4)
    | esk1352_4(X1,X2,X3,X4) ) ).

cnf(i_0_8394,axiom,
    ( esk1228_4(X1,X2,X3,X4)
    | esk1246_4(X1,X2,X3,X4) ) ).

cnf(i_0_8395,axiom,
    ( esk10062_4(X1,X2,X3,X4)
    | ~ esk10085_4(X1,X2,X3,X4)
    | esk10002_4(X1,X2,X3,X4) ) ).

cnf(i_0_8396,axiom,
    ( ~ esk7330_4(X1,X2,X3,X4)
    | esk7454_4(X1,X2,X3,X4) ) ).

cnf(i_0_8397,axiom,
    ( esk1788_4(X1,X2,X3,X4)
    | ~ esk1832_4(X1,X2,X3,X4)
    | esk1839_4(X1,X2,X3,X4) ) ).

cnf(i_0_8398,axiom,
    ( ~ esk6324_4(X1,X2,X3,X4)
    | ~ esk6329_4(X1,X2,X3,X4) ) ).

cnf(i_0_8399,axiom,
    ( ~ esk11300_4(X1,X2,X3,X4)
    | esk11240_4(X1,X2,X3,X4) ) ).

cnf(i_0_8400,axiom,
    ( esk6880_4(X1,X2,X3,X4)
    | esk6905_4(X1,X2,X3,X4) ) ).

cnf(i_0_8401,axiom,
    ( esk14878_4(X1,X2,X3,X4)
    | esk14911_4(X1,X2,X3,X4) ) ).

cnf(i_0_8402,axiom,
    ( ~ esk7086_4(X1,X2,X3,X4)
    | ~ esk7088_4(X1,X2,X3,X4) ) ).

cnf(i_0_8403,axiom,
    ( esk15638_4(X1,X2,X3,X4)
    | esk15609_4(X1,X2,X3,X4) ) ).

cnf(i_0_8404,axiom,
    ( esk15631_4(X1,X2,X3,X4)
    | esk15618_4(X1,X2,X3,X4) ) ).

cnf(i_0_8405,axiom,
    ( ~ esk9381_4(X1,X2,X3,X4)
    | esk9500_4(X1,X2,X3,X4) ) ).

cnf(i_0_8406,axiom,
    ( ~ esk16693_4(X1,X2,X3,X4)
    | esk16639_4(X1,X2,X3,X4) ) ).

cnf(i_0_8407,axiom,
    ( esk8010_4(X1,X2,X3,X4)
    | ~ esk8039_4(X1,X2,X3,X4) ) ).

cnf(i_0_8408,axiom,
    ( esk10665_4(X1,X2,X3,X4)
    | ~ esk10685_4(X1,X2,X3,X4)
    | ~ esk10783_4(X1,X2,X3,X4) ) ).

cnf(i_0_8409,axiom,
    ( esk2357_4(X1,X2,X3,X4)
    | ~ esk2355_4(X1,X2,X3,X4)
    | ~ esk2356_4(X1,X2,X3,X4) ) ).

cnf(i_0_8410,axiom,
    ( esk8664_4(X1,X2,X3,X4)
    | esk8711_4(X1,X2,X3,X4) ) ).

cnf(i_0_8411,axiom,
    ( esk10683_4(X1,X2,X3,X4)
    | ~ esk10663_4(X1,X2,X3,X4) ) ).

cnf(i_0_8412,axiom,
    ( esk11268_4(X1,X2,X3,X4)
    | esk11301_4(X1,X2,X3,X4) ) ).

cnf(i_0_8413,axiom,
    ( esk2700_4(X1,X2,X3,X4)
    | ~ esk2718_4(X1,X2,X3,X4)
    | ~ esk2820_4(X1,X2,X3,X4) ) ).

cnf(i_0_8414,axiom,
    ( esk4670_4(X1,X2,X3,X4)
    | ~ esk4668_4(X1,X2,X3,X4)
    | ~ esk4669_4(X1,X2,X3,X4) ) ).

cnf(i_0_8415,axiom,
    ( ~ esk3899_4(X1,X2,X3,X4)
    | esk3898_4(X1,X2,X3,X4) ) ).

cnf(i_0_8416,axiom,
    ( ~ esk11730_4(X1,X2,X3,X4)
    | esk11726_4(X1,X2,X3,X4)
    | esk11724_4(X1,X2,X3,X4) ) ).

cnf(i_0_8417,axiom,
    ( ~ esk6566_4(X1,X2,X3,X4)
    | esk6667_4(X1,X2,X3,X4) ) ).

cnf(i_0_8418,axiom,
    ( ~ esk14273_4(X1,X2,X3,X4)
    | esk14283_4(X1,X2,X3,X4) ) ).

cnf(i_0_8419,axiom,
    ( esk9479_4(X1,X2,X3,X4)
    | esk9512_4(X1,X2,X3,X4) ) ).

cnf(i_0_8420,axiom,
    ( esk12778_4(X1,X2,X3,X4)
    | esk12819_4(X1,X2,X3,X4) ) ).

cnf(i_0_8421,axiom,
    ( esk447_4(X1,X2,X3,X4)
    | ~ esk504_4(X1,X2,X3,X4) ) ).

cnf(i_0_8422,axiom,
    ( ~ esk15806_4(X1,X2,X3,X4)
    | esk15925_4(X1,X2,X3,X4) ) ).

cnf(i_0_8423,axiom,
    ( esk8545_4(X1,X2,X3,X4)
    | esk8555_4(X1,X2,X3,X4) ) ).

cnf(i_0_8424,axiom,
    ( ~ esk13437_4(X1,X2,X3,X4)
    | ~ esk13415_4(X1,X2,X3,X4) ) ).

cnf(i_0_8425,axiom,
    ( ~ esk11332_4(X1,X2,X3,X4)
    | esk11285_4(X1,X2,X3,X4)
    | esk11369_4(X1,X2,X3,X4) ) ).

cnf(i_0_8426,axiom,
    ( ~ esk13929_4(X1,X2,X3,X4)
    | esk13948_4(X1,X2,X3,X4)
    | esk13877_4(X1,X2,X3,X4) ) ).

cnf(i_0_8427,axiom,
    ( esk6113_4(X1,X2,X3,X4)
    | esk6111_4(X1,X2,X3,X4) ) ).

cnf(i_0_8428,axiom,
    ( ~ esk15721_4(X1,X2,X3,X4)
    | esk15720_4(X1,X2,X3,X4) ) ).

cnf(i_0_8429,axiom,
    ( ~ esk16637_4(X1,X2,X3,X4)
    | esk16697_4(X1,X2,X3,X4) ) ).

cnf(i_0_8430,axiom,
    ( esk10748_4(X1,X2,X3,X4)
    | esk10729_4(X1,X2,X3,X4) ) ).

cnf(i_0_8431,axiom,
    ( esk5288_4(X1,X2,X3,X4)
    | ~ esk5273_4(X1,X2,X3,X4) ) ).

cnf(i_0_8432,axiom,
    ( esk6114_4(X1,X2,X3,X4)
    | esk6147_4(X1,X2,X3,X4) ) ).

cnf(i_0_8433,axiom,
    ( esk11493_4(X1,X2,X3,X4)
    | ~ esk11565_4(X1,X2,X3,X4) ) ).

cnf(i_0_8434,axiom,
    ( esk15875_4(X1,X2,X3,X4)
    | esk15906_4(X1,X2,X3,X4) ) ).

cnf(i_0_8435,axiom,
    ( ~ esk4769_4(X1,X2,X3,X4)
    | esk4774_4(X1,X2,X3,X4) ) ).

cnf(i_0_8436,axiom,
    ( ~ esk405_4(X1,X2,X3,X4)
    | ~ esk501_4(X1,X2,X3,X4)
    | esk399_4(X1,X2,X3,X4) ) ).

cnf(i_0_8437,axiom,
    ( esk10849_4(X1,X2,X3,X4)
    | ~ esk10819_4(X1,X2,X3,X4) ) ).

cnf(i_0_8438,axiom,
    ( ~ esk8004_4(X1,X2,X3,X4)
    | ~ esk7948_4(X1,X2,X3,X4) ) ).

cnf(i_0_8439,axiom,
    ( ~ esk4044_4(X1,X2,X3,X4)
    | esk4104_4(X1,X2,X3,X4) ) ).

cnf(i_0_8440,axiom,
    ( ~ esk4272_4(X1,X2,X3,X4)
    | ~ esk4274_4(X1,X2,X3,X4) ) ).

cnf(i_0_8441,axiom,
    ( esk3282_4(X1,X2,X3,X4)
    | esk3228_4(X1,X2,X3,X4)
    | esk3262_4(X1,X2,X3,X4) ) ).

cnf(i_0_8442,axiom,
    ( esk11123_4(X1,X2,X3,X4)
    | ~ esk11094_4(X1,X2,X3,X4)
    | esk11074_4(X1,X2,X3,X4) ) ).

cnf(i_0_8443,axiom,
    ( p(X3)
    | p(X4)
    | ~ p(X1)
    | ~ esk493_4(X1,X2,X3,X4)
    | ~ p(X2)
    | esk89_0 ) ).

cnf(i_0_8444,axiom,
    ( esk6324_4(X1,X2,X3,X4)
    | esk6323_4(X1,X2,X3,X4) ) ).

cnf(i_0_8445,axiom,
    ( esk12277_4(X1,X2,X3,X4)
    | esk12290_4(X1,X2,X3,X4) ) ).

cnf(i_0_8446,axiom,
    ( ~ esk16358_4(X1,X2,X3,X4)
    | esk16359_4(X1,X2,X3,X4) ) ).

cnf(i_0_8447,axiom,
    ( esk16685_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ esk104_0
    | p(X2)
    | ~ p(X3)
    | ~ p(X4) ) ).

cnf(i_0_8448,axiom,
    ( ~ esk4625_4(X1,X2,X3,X4)
    | esk4696_4(X1,X2,X3,X4)
    | esk4677_4(X1,X2,X3,X4) ) ).

cnf(i_0_8449,axiom,
    ( esk13499_4(X1,X2,X3,X4)
    | ~ esk13466_4(X1,X2,X3,X4) ) ).

cnf(i_0_8450,axiom,
    ( esk2746_4(X1,X2,X3,X4)
    | ~ esk2488_4(X1,X2,X3,X4) ) ).

cnf(i_0_8451,axiom,
    ( ~ esk6868_4(X1,X2,X3,X4)
    | ~ esk6906_4(X1,X2,X3,X4)
    | ~ esk6905_4(X1,X2,X3,X4) ) ).

cnf(i_0_8452,axiom,
    ( esk13893_4(X1,X2,X3,X4)
    | esk13768_4(X1,X2,X3,X4) ) ).

cnf(i_0_8453,axiom,
    ( ~ esk1157_4(X1,X2,X3,X4)
    | esk1176_4(X1,X2,X3,X4) ) ).

cnf(i_0_8454,axiom,
    ( ~ esk3494_4(X1,X2,X3,X4)
    | ~ esk3503_4(X1,X2,X3,X4)
    | ~ esk3517_4(X1,X2,X3,X4) ) ).

cnf(i_0_8455,axiom,
    ( esk3269_4(X1,X2,X3,X4)
    | ~ esk3341_4(X1,X2,X3,X4) ) ).

cnf(i_0_8456,axiom,
    ( p(X4)
    | p(X3)
    | ~ p(X1)
    | ~ esk16724_4(X1,X2,X3,X4)
    | p(X2)
    | esk326_0 ) ).

cnf(i_0_8457,axiom,
    ( ~ esk8762_4(X1,X2,X3,X4)
    | esk8777_4(X1,X2,X3,X4) ) ).

cnf(i_0_8458,axiom,
    ( esk7711_4(X1,X2,X3,X4)
    | esk7678_4(X1,X2,X3,X4) ) ).

cnf(i_0_8459,axiom,
    ( ~ esk14553_4(X1,X2,X3,X4)
    | ~ esk14555_4(X1,X2,X3,X4) ) ).

cnf(i_0_8460,axiom,
    ( esk13921_4(X1,X2,X3,X4)
    | ~ esk13901_4(X1,X2,X3,X4) ) ).

cnf(i_0_8461,axiom,
    ( ~ esk2983_4(X1,X2,X3,X4)
    | esk2995_4(X1,X2,X3,X4) ) ).

cnf(i_0_8462,axiom,
    ( esk5660_4(X1,X2,X3,X4)
    | ~ esk5918_4(X1,X2,X3,X4) ) ).

cnf(i_0_8463,axiom,
    ( ~ esk3646_4(X1,X2,X3,X4)
    | esk3644_4(X1,X2,X3,X4) ) ).

cnf(i_0_8464,axiom,
    ( ~ esk3374_4(X1,X2,X3,X4)
    | ~ esk3375_4(X1,X2,X3,X4)
    | ~ esk3330_4(X1,X2,X3,X4) ) ).

cnf(i_0_8465,axiom,
    ( p(X4)
    | ~ esk433_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X3)
    | ~ p(X2)
    | esk53_0 ) ).

cnf(i_0_8466,axiom,
    ( ~ esk10039_4(X1,X2,X3,X4)
    | esk10041_4(X1,X2,X3,X4)
    | ~ esk10040_4(X1,X2,X3,X4) ) ).

cnf(i_0_8467,axiom,
    ( ~ esk4140_4(X1,X2,X3,X4)
    | ~ esk4109_4(X1,X2,X3,X4) ) ).

cnf(i_0_8468,axiom,
    ( esk6857_4(X1,X2,X3,X4)
    | ~ esk7115_4(X1,X2,X3,X4) ) ).

cnf(i_0_8469,axiom,
    ( ~ esk8187_4(X1,X2,X3,X4)
    | ~ esk8167_4(X1,X2,X3,X4)
    | ~ esk8273_4(X1,X2,X3,X4) ) ).

cnf(i_0_8470,axiom,
    ( ~ esk4900_4(X1,X2,X3,X4)
    | esk4743_4(X1,X2,X3,X4)
    | esk4773_4(X1,X2,X3,X4) ) ).

cnf(i_0_8471,axiom,
    ( esk9195_4(X1,X2,X3,X4)
    | esk9221_4(X1,X2,X3,X4) ) ).

cnf(i_0_8472,axiom,
    ( esk13035_4(X1,X2,X3,X4)
    | esk13075_4(X1,X2,X3,X4) ) ).

cnf(i_0_8473,axiom,
    ( ~ esk1424_4(X1,X2,X3,X4)
    | esk1398_4(X1,X2,X3,X4) ) ).

cnf(i_0_8474,axiom,
    ( ~ esk2513_4(X1,X2,X3,X4)
    | ~ esk2517_4(X1,X2,X3,X4)
    | ~ esk2632_4(X1,X2,X3,X4) ) ).

cnf(i_0_8475,axiom,
    ( ~ esk9446_4(X1,X2,X3,X4)
    | ~ esk9460_4(X1,X2,X3,X4)
    | ~ esk9459_4(X1,X2,X3,X4) ) ).

cnf(i_0_8476,axiom,
    ( esk6675_4(X1,X2,X3,X4)
    | esk6714_4(X1,X2,X3,X4) ) ).

cnf(i_0_8477,axiom,
    ( esk3900_4(X1,X2,X3,X4)
    | esk3886_4(X1,X2,X3,X4) ) ).

cnf(i_0_8478,axiom,
    ( ~ esk5539_4(X1,X2,X3,X4)
    | esk5641_4(X1,X2,X3,X4) ) ).

cnf(i_0_8479,axiom,
    ( ~ esk13315_4(X1,X2,X3,X4)
    | ~ esk13307_4(X1,X2,X3,X4)
    | ~ esk13438_4(X1,X2,X3,X4) ) ).

cnf(i_0_8480,axiom,
    ( esk10000_4(X1,X2,X3,X4)
    | ~ esk9903_4(X1,X2,X3,X4) ) ).

cnf(i_0_8481,axiom,
    ( ~ esk9129_4(X1,X2,X3,X4)
    | esk9098_4(X1,X2,X3,X4) ) ).

cnf(i_0_8482,axiom,
    ( ~ esk10305_4(X1,X2,X3,X4)
    | ~ esk10307_4(X1,X2,X3,X4) ) ).

cnf(i_0_8483,axiom,
    ( esk6623_4(X1,X2,X3,X4)
    | esk6630_4(X1,X2,X3,X4) ) ).

cnf(i_0_8484,axiom,
    ( esk15714_4(X1,X2,X3,X4)
    | esk15716_4(X1,X2,X3,X4)
    | esk15715_4(X1,X2,X3,X4) ) ).

cnf(i_0_8485,axiom,
    ( ~ esk3589_4(X1,X2,X3,X4)
    | esk3331_4(X1,X2,X3,X4) ) ).

cnf(i_0_8486,axiom,
    ( esk12279_4(X1,X2,X3,X4)
    | esk12257_4(X1,X2,X3,X4)
    | esk12278_4(X1,X2,X3,X4) ) ).

cnf(i_0_8487,axiom,
    ( ~ esk2199_4(X1,X2,X3,X4)
    | esk2156_4(X1,X2,X3,X4) ) ).

cnf(i_0_8488,axiom,
    ( esk6360_4(X1,X2,X3,X4)
    | esk6380_4(X1,X2,X3,X4) ) ).

cnf(i_0_8489,axiom,
    ( esk3368_4(X1,X2,X3,X4)
    | esk3370_4(X1,X2,X3,X4) ) ).

cnf(i_0_8490,axiom,
    ( ~ esk4177_4(X1,X2,X3,X4)
    | ~ esk4148_4(X1,X2,X3,X4)
    | ~ esk4097_4(X1,X2,X3,X4) ) ).

cnf(i_0_8491,axiom,
    ( esk10706_4(X1,X2,X3,X4)
    | ~ esk10699_4(X1,X2,X3,X4) ) ).

cnf(i_0_8492,axiom,
    ( ~ esk15553_4(X1,X2,X3,X4)
    | esk15568_4(X1,X2,X3,X4) ) ).

cnf(i_0_8493,axiom,
    ( esk5444_4(X1,X2,X3,X4)
    | ~ esk5390_4(X1,X2,X3,X4) ) ).

cnf(i_0_8494,axiom,
    ( esk14461_4(X1,X2,X3,X4)
    | ~ esk14459_4(X1,X2,X3,X4)
    | ~ esk14460_4(X1,X2,X3,X4) ) ).

cnf(i_0_8495,axiom,
    ( ~ esk9535_4(X1,X2,X3,X4)
    | esk9563_4(X1,X2,X3,X4) ) ).

cnf(i_0_8496,axiom,
    ( ~ esk13668_4(X1,X2,X3,X4)
    | esk13669_4(X1,X2,X3,X4)
    | ~ esk13667_4(X1,X2,X3,X4) ) ).

cnf(i_0_8497,axiom,
    ( esk1021_4(X1,X2,X3,X4)
    | esk1060_4(X1,X2,X3,X4) ) ).

cnf(i_0_8498,axiom,
    ( esk16217_4(X1,X2,X3,X4)
    | esk16216_4(X1,X2,X3,X4)
    | esk16218_4(X1,X2,X3,X4) ) ).

cnf(i_0_8499,axiom,
    ( esk5754_4(X1,X2,X3,X4)
    | ~ esk5797_4(X1,X2,X3,X4) ) ).

cnf(i_0_8500,axiom,
    ( esk8356_4(X1,X2,X3,X4)
    | ~ esk8329_4(X1,X2,X3,X4) ) ).

cnf(i_0_8501,axiom,
    ( esk8253_4(X1,X2,X3,X4)
    | esk8251_4(X1,X2,X3,X4) ) ).

cnf(i_0_8502,axiom,
    ( ~ esk7137_4(X1,X2,X3,X4)
    | ~ esk7142_4(X1,X2,X3,X4)
    | ~ esk7175_4(X1,X2,X3,X4) ) ).

cnf(i_0_8503,axiom,
    ( ~ esk16184_4(X1,X2,X3,X4)
    | ~ esk16223_4(X1,X2,X3,X4) ) ).

cnf(i_0_8504,axiom,
    ( ~ esk9779_4(X1,X2,X3,X4)
    | esk9775_4(X1,X2,X3,X4) ) ).

cnf(i_0_8505,axiom,
    ( ~ esk4630_4(X1,X2,X3,X4)
    | esk4552_4(X1,X2,X3,X4) ) ).

cnf(i_0_8506,axiom,
    ( ~ esk651_4(X1,X2,X3,X4)
    | esk662_4(X1,X2,X3,X4) ) ).

cnf(i_0_8507,axiom,
    ( esk6872_4(X1,X2,X3,X4)
    | esk6898_4(X1,X2,X3,X4) ) ).

cnf(i_0_8508,axiom,
    ( esk4617_4(X1,X2,X3,X4)
    | ~ esk4359_4(X1,X2,X3,X4) ) ).

cnf(i_0_8509,axiom,
    ( ~ esk6126_4(X1,X2,X3,X4)
    | ~ esk6109_4(X1,X2,X3,X4)
    | ~ esk6159_4(X1,X2,X3,X4) ) ).

cnf(i_0_8510,axiom,
    ( esk2051_4(X1,X2,X3,X4)
    | ~ esk2086_4(X1,X2,X3,X4)
    | esk2105_4(X1,X2,X3,X4) ) ).

cnf(i_0_8511,axiom,
    ( ~ esk16093_4(X1,X2,X3,X4)
    | ~ esk16094_4(X1,X2,X3,X4) ) ).

cnf(i_0_8512,axiom,
    ( ~ esk2048_4(X1,X2,X3,X4)
    | esk1988_4(X1,X2,X3,X4) ) ).

cnf(i_0_8513,axiom,
    ( ~ esk2938_4(X1,X2,X3,X4)
    | esk2968_4(X1,X2,X3,X4) ) ).

cnf(i_0_8514,axiom,
    ( ~ esk8681_4(X1,X2,X3,X4)
    | ~ esk8687_4(X1,X2,X3,X4)
    | ~ esk8801_4(X1,X2,X3,X4) ) ).

cnf(i_0_8515,axiom,
    ( esk2244_4(X1,X2,X3,X4)
    | esk2275_4(X1,X2,X3,X4) ) ).

cnf(i_0_8516,axiom,
    ( esk7107_4(X1,X2,X3,X4)
    | ~ esk7109_4(X1,X2,X3,X4) ) ).

cnf(i_0_8517,axiom,
    ( ~ esk13433_4(X1,X2,X3,X4)
    | ~ esk13319_4(X1,X2,X3,X4)
    | ~ esk13307_4(X1,X2,X3,X4) ) ).

cnf(i_0_8518,axiom,
    ( esk10122_4(X1,X2,X3,X4)
    | esk10172_4(X1,X2,X3,X4) ) ).

cnf(i_0_8519,axiom,
    ( esk1129_4(X1,X2,X3,X4)
    | ~ esk1164_4(X1,X2,X3,X4) ) ).

cnf(i_0_8520,axiom,
    ( esk15383_4(X1,X2,X3,X4)
    | esk15363_4(X1,X2,X3,X4) ) ).

cnf(i_0_8521,axiom,
    ( esk13269_4(X1,X2,X3,X4)
    | ~ esk13276_4(X1,X2,X3,X4)
    | esk13262_4(X1,X2,X3,X4) ) ).

cnf(i_0_8522,axiom,
    ( ~ esk4157_4(X1,X2,X3,X4)
    | ~ esk4143_4(X1,X2,X3,X4) ) ).

cnf(i_0_8523,axiom,
    ( ~ esk13638_4(X1,X2,X3,X4)
    | esk13481_4(X1,X2,X3,X4)
    | esk13511_4(X1,X2,X3,X4) ) ).

cnf(i_0_8524,axiom,
    ( ~ esk1081_4(X1,X2,X3,X4)
    | esk1082_4(X1,X2,X3,X4) ) ).

cnf(i_0_8525,axiom,
    ( esk12331_4(X1,X2,X3,X4)
    | esk12298_4(X1,X2,X3,X4) ) ).

cnf(i_0_8526,axiom,
    ( esk7133_4(X1,X2,X3,X4)
    | ~ esk7178_4(X1,X2,X3,X4) ) ).

cnf(i_0_8527,axiom,
    ( esk7128_4(X1,X2,X3,X4)
    | esk7157_4(X1,X2,X3,X4) ) ).

cnf(i_0_8528,axiom,
    ( ~ esk16479_4(X1,X2,X3,X4)
    | ~ esk16443_4(X1,X2,X3,X4)
    | ~ esk16478_4(X1,X2,X3,X4) ) ).

cnf(i_0_8529,axiom,
    ( esk887_4(X1,X2,X3,X4)
    | ~ esk1038_4(X1,X2,X3,X4)
    | esk918_4(X1,X2,X3,X4) ) ).

cnf(i_0_8530,axiom,
    ( ~ p(X1)
    | p(X3)
    | p(X4)
    | esk517_4(X1,X2,X3,X4)
    | ~ esk269_0
    | ~ p(X2) ) ).

cnf(i_0_8531,axiom,
    ( esk1578_4(X1,X2,X3,X4)
    | esk1580_4(X1,X2,X3,X4) ) ).

cnf(i_0_8532,axiom,
    ( esk10830_4(X1,X2,X3,X4)
    | esk10832_4(X1,X2,X3,X4) ) ).

cnf(i_0_8533,axiom,
    ( esk9980_4(X1,X2,X3,X4)
    | esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_8534,axiom,
    ( p(X2)
    | esk16691_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1)
    | ~ esk141_0
    | ~ p(X4) ) ).

cnf(i_0_8535,axiom,
    ( esk13210_4(X1,X2,X3,X4)
    | ~ esk13241_4(X1,X2,X3,X4) ) ).

cnf(i_0_8536,axiom,
    ( ~ esk7604_4(X1,X2,X3,X4)
    | esk7599_4(X1,X2,X3,X4)
    | ~ esk7598_4(X1,X2,X3,X4) ) ).

cnf(i_0_8537,axiom,
    ( esk16725_4(X1,X2,X3,X4)
    | esk16628_4(X1,X2,X3,X4)
    | esk16629_4(X1,X2,X3,X4) ) ).

cnf(i_0_8538,axiom,
    ( esk11733_4(X1,X2,X3,X4)
    | ~ esk11732_4(X1,X2,X3,X4) ) ).

cnf(i_0_8539,axiom,
    ( esk8906_4(X1,X2,X3,X4)
    | ~ esk8905_4(X1,X2,X3,X4) ) ).

cnf(i_0_8540,axiom,
    ( esk10663_4(X1,X2,X3,X4)
    | ~ esk10683_4(X1,X2,X3,X4) ) ).

cnf(i_0_8541,axiom,
    ( ~ esk7451_4(X1,X2,X3,X4)
    | esk7382_4(X1,X2,X3,X4) ) ).

cnf(i_0_8542,axiom,
    ( esk8349_4(X1,X2,X3,X4)
    | esk8495_4(X1,X2,X3,X4) ) ).

cnf(i_0_8543,axiom,
    ( esk16196_4(X1,X2,X3,X4)
    | esk16213_4(X1,X2,X3,X4)
    | ~ esk16250_4(X1,X2,X3,X4) ) ).

cnf(i_0_8544,axiom,
    ( esk14423_4(X1,X2,X3,X4)
    | esk14387_4(X1,X2,X3,X4) ) ).

cnf(i_0_8545,axiom,
    ( esk13839_4(X1,X2,X3,X4)
    | esk13821_4(X1,X2,X3,X4) ) ).

cnf(i_0_8546,axiom,
    ( esk5942_4(X1,X2,X3,X4)
    | esk5906_4(X1,X2,X3,X4) ) ).

cnf(i_0_8547,axiom,
    ( esk572_4(X1,X2,X3,X4)
    | ~ esk521_4(X1,X2,X3,X4) ) ).

cnf(i_0_8548,axiom,
    ( ~ esk1428_4(X1,X2,X3,X4)
    | esk1433_4(X1,X2,X3,X4) ) ).

cnf(i_0_8549,axiom,
    ( esk666_4(X1,X2,X3,X4)
    | ~ esk924_4(X1,X2,X3,X4) ) ).

cnf(i_0_8550,axiom,
    ( esk8800_4(X1,X2,X3,X4)
    | esk8685_4(X1,X2,X3,X4) ) ).

cnf(i_0_8551,axiom,
    ( ~ esk4909_4(X1,X2,X3,X4)
    | ~ esk4886_4(X1,X2,X3,X4) ) ).

cnf(i_0_8552,axiom,
    ( esk14324_4(X1,X2,X3,X4)
    | esk14353_4(X1,X2,X3,X4) ) ).

cnf(i_0_8553,axiom,
    ( ~ esk11691_4(X1,X2,X3,X4)
    | esk11711_4(X1,X2,X3,X4) ) ).

cnf(i_0_8554,axiom,
    ( ~ esk10165_4(X1,X2,X3,X4)
    | esk10171_4(X1,X2,X3,X4) ) ).

cnf(i_0_8555,axiom,
    ( esk13327_4(X1,X2,X3,X4)
    | esk13413_4(X1,X2,X3,X4) ) ).

cnf(i_0_8556,axiom,
    ( esk12277_4(X1,X2,X3,X4)
    | esk12306_4(X1,X2,X3,X4) ) ).

cnf(i_0_8557,axiom,
    ( ~ esk9384_4(X1,X2,X3,X4)
    | esk9400_4(X1,X2,X3,X4) ) ).

cnf(i_0_8558,axiom,
    ( ~ esk15646_4(X1,X2,X3,X4)
    | ~ esk15645_4(X1,X2,X3,X4)
    | ~ esk15605_4(X1,X2,X3,X4) ) ).

cnf(i_0_8559,axiom,
    ( p(X2)
    | esk275_0
    | p(X1)
    | ~ p(X3)
    | ~ esk16709_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_8560,axiom,
    ( ~ esk14617_4(X1,X2,X3,X4)
    | ~ esk14590_4(X1,X2,X3,X4)
    | ~ esk14650_4(X1,X2,X3,X4) ) ).

cnf(i_0_8561,axiom,
    ( ~ esk15842_4(X1,X2,X3,X4)
    | ~ esk15841_4(X1,X2,X3,X4)
    | esk15843_4(X1,X2,X3,X4) ) ).

cnf(i_0_8562,axiom,
    ( ~ esk2353_4(X1,X2,X3,X4)
    | ~ esk2270_4(X1,X2,X3,X4)
    | ~ esk2256_4(X1,X2,X3,X4) ) ).

cnf(i_0_8563,axiom,
    ( ~ esk16303_4(X1,X2,X3,X4)
    | esk16331_4(X1,X2,X3,X4) ) ).

cnf(i_0_8564,axiom,
    ( ~ esk10531_4(X1,X2,X3,X4)
    | esk10789_4(X1,X2,X3,X4) ) ).

cnf(i_0_8565,axiom,
    ( esk6112_4(X1,X2,X3,X4)
    | esk6145_4(X1,X2,X3,X4) ) ).

cnf(i_0_8566,axiom,
    ( ~ esk6595_4(X1,X2,X3,X4)
    | esk6594_4(X1,X2,X3,X4) ) ).

cnf(i_0_8567,axiom,
    ( esk4109_4(X1,X2,X3,X4)
    | esk4140_4(X1,X2,X3,X4) ) ).

cnf(i_0_8568,axiom,
    ( esk7404_4(X1,X2,X3,X4)
    | esk7527_4(X1,X2,X3,X4) ) ).

cnf(i_0_8569,axiom,
    ( esk15206_4(X1,X2,X3,X4)
    | ~ esk15207_4(X1,X2,X3,X4) ) ).

cnf(i_0_8570,axiom,
    ( ~ esk9655_4(X1,X2,X3,X4)
    | esk9660_4(X1,X2,X3,X4) ) ).

cnf(i_0_8571,axiom,
    ( ~ esk3282_4(X1,X2,X3,X4)
    | ~ esk3322_4(X1,X2,X3,X4)
    | ~ esk3289_4(X1,X2,X3,X4) ) ).

cnf(i_0_8572,axiom,
    ( ~ esk3908_4(X1,X2,X3,X4)
    | esk3909_4(X1,X2,X3,X4) ) ).

cnf(i_0_8573,axiom,
    ( esk9508_4(X1,X2,X3,X4)
    | esk9475_4(X1,X2,X3,X4) ) ).

cnf(i_0_8574,axiom,
    ( ~ esk13602_4(X1,X2,X3,X4)
    | ~ esk13658_4(X1,X2,X3,X4) ) ).

cnf(i_0_8575,axiom,
    ( ~ esk16105_4(X1,X2,X3,X4)
    | esk16106_4(X1,X2,X3,X4) ) ).

cnf(i_0_8576,axiom,
    ( ~ esk12617_4(X1,X2,X3,X4)
    | ~ esk12570_4(X1,X2,X3,X4)
    | ~ esk12654_4(X1,X2,X3,X4) ) ).

cnf(i_0_8577,axiom,
    ( esk6190_4(X1,X2,X3,X4)
    | ~ esk6227_4(X1,X2,X3,X4)
    | esk6173_4(X1,X2,X3,X4) ) ).

cnf(i_0_8578,axiom,
    ( esk11713_4(X1,X2,X3,X4)
    | ~ esk11701_4(X1,X2,X3,X4) ) ).

cnf(i_0_8579,axiom,
    ( ~ p(X3)
    | ~ esk501_4(X1,X2,X3,X4)
    | esk148_0
    | p(X2)
    | ~ p(X1)
    | ~ p(X4) ) ).

cnf(i_0_8580,axiom,
    ( ~ esk2465_4(X1,X2,X3,X4)
    | esk2723_4(X1,X2,X3,X4) ) ).

cnf(i_0_8581,axiom,
    ( esk2101_4(X1,X2,X3,X4)
    | esk2087_4(X1,X2,X3,X4) ) ).

cnf(i_0_8582,axiom,
    ( esk2852_4(X1,X2,X3,X4)
    | esk2832_4(X1,X2,X3,X4) ) ).

cnf(i_0_8583,axiom,
    ( esk4514_4(X1,X2,X3,X4)
    | ~ esk4515_4(X1,X2,X3,X4) ) ).

cnf(i_0_8584,axiom,
    ( ~ esk8516_4(X1,X2,X3,X4)
    | esk8548_4(X1,X2,X3,X4) ) ).

cnf(i_0_8585,axiom,
    ( esk1734_4(X1,X2,X3,X4)
    | ~ esk1785_4(X1,X2,X3,X4) ) ).

cnf(i_0_8586,axiom,
    ( esk1974_4(X1,X2,X3,X4)
    | ~ esk2232_4(X1,X2,X3,X4) ) ).

cnf(i_0_8587,axiom,
    ( esk3870_4(X1,X2,X3,X4)
    | esk3745_4(X1,X2,X3,X4) ) ).

cnf(i_0_8588,axiom,
    ( ~ esk12550_4(X1,X2,X3,X4)
    | ~ esk12536_4(X1,X2,X3,X4)
    | ~ esk12633_4(X1,X2,X3,X4) ) ).

cnf(i_0_8589,axiom,
    ( ~ esk9285_4(X1,X2,X3,X4)
    | ~ esk9284_4(X1,X2,X3,X4) ) ).

cnf(i_0_8590,axiom,
    ( esk5058_4(X1,X2,X3,X4)
    | ~ esk5060_4(X1,X2,X3,X4) ) ).

cnf(i_0_8591,axiom,
    ( ~ esk2326_4(X1,X2,X3,X4)
    | esk2322_4(X1,X2,X3,X4) ) ).

cnf(i_0_8592,axiom,
    ( ~ esk1029_4(X1,X2,X3,X4)
    | ~ esk919_4(X1,X2,X3,X4)
    | esk905_4(X1,X2,X3,X4) ) ).

cnf(i_0_8593,axiom,
    ( esk2823_4(X1,X2,X3,X4)
    | ~ esk3081_4(X1,X2,X3,X4) ) ).

cnf(i_0_8594,axiom,
    ( esk11964_4(X1,X2,X3,X4)
    | ~ esk11932_4(X1,X2,X3,X4) ) ).

cnf(i_0_8595,axiom,
    ( esk12613_4(X1,X2,X3,X4)
    | esk12515_4(X1,X2,X3,X4) ) ).

cnf(i_0_8596,axiom,
    ( esk979_4(X1,X2,X3,X4)
    | esk1102_4(X1,X2,X3,X4) ) ).

cnf(i_0_8597,axiom,
    ( esk6904_4(X1,X2,X3,X4)
    | esk6989_4(X1,X2,X3,X4) ) ).

cnf(i_0_8598,axiom,
    ( ~ esk1030_4(X1,X2,X3,X4)
    | esk1288_4(X1,X2,X3,X4) ) ).

cnf(i_0_8599,axiom,
    ( esk11889_4(X1,X2,X3,X4)
    | ~ esk11888_4(X1,X2,X3,X4) ) ).

cnf(i_0_8600,axiom,
    ( esk8486_4(X1,X2,X3,X4)
    | esk8506_4(X1,X2,X3,X4) ) ).

cnf(i_0_8601,axiom,
    ( esk10820_4(X1,X2,X3,X4)
    | esk10819_4(X1,X2,X3,X4)
    | esk10821_4(X1,X2,X3,X4) ) ).

cnf(i_0_8602,axiom,
    ( ~ esk1015_4(X1,X2,X3,X4)
    | ~ esk1063_4(X1,X2,X3,X4) ) ).

cnf(i_0_8603,axiom,
    ( ~ esk15316_4(X1,X2,X3,X4)
    | esk15336_4(X1,X2,X3,X4) ) ).

cnf(i_0_8604,axiom,
    ( esk5288_4(X1,X2,X3,X4)
    | ~ esk5283_4(X1,X2,X3,X4) ) ).

cnf(i_0_8605,axiom,
    ( ~ esk16757_4(X1,X2,X3,X4)
    | ~ esk16674_4(X1,X2,X3,X4)
    | ~ esk16648_4(X1,X2,X3,X4) ) ).

cnf(i_0_8606,axiom,
    ( esk978_4(X1,X2,X3,X4)
    | esk965_4(X1,X2,X3,X4) ) ).

cnf(i_0_8607,axiom,
    ( esk3841_4(X1,X2,X3,X4)
    | ~ esk3790_4(X1,X2,X3,X4) ) ).

cnf(i_0_8608,axiom,
    ( esk10758_4(X1,X2,X3,X4)
    | esk10724_4(X1,X2,X3,X4) ) ).

cnf(i_0_8609,axiom,
    ( esk15100_4(X1,X2,X3,X4)
    | esk15114_4(X1,X2,X3,X4) ) ).

cnf(i_0_8610,axiom,
    ( ~ esk10044_4(X1,X2,X3,X4)
    | ~ esk10037_4(X1,X2,X3,X4)
    | ~ esk9891_4(X1,X2,X3,X4) ) ).

cnf(i_0_8611,axiom,
    ( ~ esk1598_4(X1,X2,X3,X4)
    | ~ esk1485_4(X1,X2,X3,X4)
    | ~ esk1513_4(X1,X2,X3,X4) ) ).

cnf(i_0_8612,axiom,
    ( ~ esk10177_4(X1,X2,X3,X4)
    | esk10193_4(X1,X2,X3,X4) ) ).

cnf(i_0_8613,axiom,
    ( ~ esk2712_4(X1,X2,X3,X4)
    | esk2680_4(X1,X2,X3,X4) ) ).

cnf(i_0_8614,axiom,
    ( ~ esk2810_4(X1,X2,X3,X4)
    | esk2898_4(X1,X2,X3,X4)
    | esk2891_4(X1,X2,X3,X4) ) ).

cnf(i_0_8615,axiom,
    ( ~ esk14630_4(X1,X2,X3,X4)
    | ~ esk14597_4(X1,X2,X3,X4)
    | ~ esk14590_4(X1,X2,X3,X4) ) ).

cnf(i_0_8616,axiom,
    ( esk12545_4(X1,X2,X3,X4)
    | esk12529_4(X1,X2,X3,X4) ) ).

cnf(i_0_8617,axiom,
    ( esk10567_4(X1,X2,X3,X4)
    | esk10568_4(X1,X2,X3,X4) ) ).

cnf(i_0_8618,axiom,
    ( ~ esk2079_4(X1,X2,X3,X4)
    | esk2099_4(X1,X2,X3,X4) ) ).

cnf(i_0_8619,axiom,
    ( ~ esk13307_4(X1,X2,X3,X4)
    | ~ esk13339_4(X1,X2,X3,X4)
    | ~ esk13386_4(X1,X2,X3,X4) ) ).

cnf(i_0_8620,axiom,
    ( esk4678_4(X1,X2,X3,X4)
    | ~ esk4627_4(X1,X2,X3,X4)
    | esk4653_4(X1,X2,X3,X4) ) ).

cnf(i_0_8621,axiom,
    ( ~ esk8270_4(X1,X2,X3,X4)
    | esk8269_4(X1,X2,X3,X4)
    | esk8256_4(X1,X2,X3,X4) ) ).

cnf(i_0_8622,axiom,
    ( esk15389_4(X1,X2,X3,X4)
    | esk15348_4(X1,X2,X3,X4) ) ).

cnf(i_0_8623,axiom,
    ( ~ esk2046_4(X1,X2,X3,X4)
    | esk2304_4(X1,X2,X3,X4) ) ).

cnf(i_0_8624,axiom,
    ( esk14054_4(X1,X2,X3,X4)
    | esk14055_4(X1,X2,X3,X4) ) ).

cnf(i_0_8625,axiom,
    ( esk16700_4(X1,X2,X3,X4)
    | ~ esk16754_4(X1,X2,X3,X4)
    | esk16735_4(X1,X2,X3,X4) ) ).

cnf(i_0_8626,axiom,
    ( esk15708_4(X1,X2,X3,X4)
    | esk15700_4(X1,X2,X3,X4)
    | esk15709_4(X1,X2,X3,X4) ) ).

cnf(i_0_8627,axiom,
    ( esk10585_4(X1,X2,X3,X4)
    | esk10498_4(X1,X2,X3,X4) ) ).

cnf(i_0_8628,axiom,
    ( esk6398_4(X1,X2,X3,X4)
    | esk6485_4(X1,X2,X3,X4) ) ).

cnf(i_0_8629,axiom,
    ( esk6168_4(X1,X2,X3,X4)
    | ~ esk6096_4(X1,X2,X3,X4) ) ).

cnf(i_0_8630,axiom,
    ( ~ esk15237_4(X1,X2,X3,X4)
    | ~ esk15227_4(X1,X2,X3,X4) ) ).

cnf(i_0_8631,axiom,
    ( ~ esk11338_4(X1,X2,X3,X4)
    | ~ esk11357_4(X1,X2,X3,X4)
    | ~ esk11303_4(X1,X2,X3,X4) ) ).

cnf(i_0_8632,axiom,
    ( ~ esk16041_4(X1,X2,X3,X4)
    | esk16064_4(X1,X2,X3,X4) ) ).

cnf(i_0_8633,axiom,
    ( esk6135_4(X1,X2,X3,X4)
    | esk6111_4(X1,X2,X3,X4) ) ).

cnf(i_0_8634,axiom,
    ( esk16401_4(X1,X2,X3,X4)
    | esk16513_4(X1,X2,X3,X4) ) ).

cnf(i_0_8635,axiom,
    ( esk3889_4(X1,X2,X3,X4)
    | esk3844_4(X1,X2,X3,X4) ) ).

cnf(i_0_8636,axiom,
    ( esk13552_4(X1,X2,X3,X4)
    | esk13583_4(X1,X2,X3,X4) ) ).

cnf(i_0_8637,axiom,
    ( esk14025_4(X1,X2,X3,X4)
    | esk13994_4(X1,X2,X3,X4)
    | ~ esk14145_4(X1,X2,X3,X4) ) ).

cnf(i_0_8638,axiom,
    ( ~ esk2732_4(X1,X2,X3,X4)
    | ~ esk2730_4(X1,X2,X3,X4) ) ).

cnf(i_0_8639,axiom,
    ( esk12076_4(X1,X2,X3,X4)
    | esk12107_4(X1,X2,X3,X4) ) ).

cnf(i_0_8640,axiom,
    ( esk1006_4(X1,X2,X3,X4)
    | ~ esk1264_4(X1,X2,X3,X4) ) ).

cnf(i_0_8641,axiom,
    ( esk3027_4(X1,X2,X3,X4)
    | esk3053_4(X1,X2,X3,X4) ) ).

cnf(i_0_8642,axiom,
    ( esk8342_4(X1,X2,X3,X4)
    | ~ esk8404_4(X1,X2,X3,X4) ) ).

cnf(i_0_8643,axiom,
    ( ~ esk7091_4(X1,X2,X3,X4)
    | esk7113_4(X1,X2,X3,X4) ) ).

cnf(i_0_8644,axiom,
    ( p(X2)
    | p(X4)
    | p(X1)
    | esk230_0
    | ~ p(X3)
    | ~ esk16703_4(X1,X2,X3,X4) ) ).

cnf(i_0_8645,axiom,
    ( esk13551_4(X1,X2,X3,X4)
    | esk13586_4(X1,X2,X3,X4) ) ).

cnf(i_0_8646,axiom,
    ( esk16685_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X4)
    | p(X3)
    | ~ esk94_0
    | p(X2) ) ).

cnf(i_0_8647,axiom,
    ( esk12667_4(X1,X2,X3,X4)
    | esk12657_4(X1,X2,X3,X4) ) ).

cnf(i_0_8648,axiom,
    ( esk3225_4(X1,X2,X3,X4)
    | ~ esk3232_4(X1,X2,X3,X4)
    | ~ esk3326_4(X1,X2,X3,X4) ) ).

cnf(i_0_8649,axiom,
    ( esk16086_4(X1,X2,X3,X4)
    | ~ esk16108_4(X1,X2,X3,X4) ) ).

cnf(i_0_8650,axiom,
    ( esk6642_4(X1,X2,X3,X4)
    | esk6675_4(X1,X2,X3,X4) ) ).

cnf(i_0_8651,axiom,
    ( esk2051_4(X1,X2,X3,X4)
    | ~ esk1793_4(X1,X2,X3,X4) ) ).

cnf(i_0_8652,axiom,
    ( ~ esk9018_4(X1,X2,X3,X4)
    | esk9038_4(X1,X2,X3,X4) ) ).

cnf(i_0_8653,axiom,
    ( ~ esk9426_4(X1,X2,X3,X4)
    | esk9404_4(X1,X2,X3,X4) ) ).

cnf(i_0_8654,axiom,
    ( ~ esk790_4(X1,X2,X3,X4)
    | esk789_4(X1,X2,X3,X4) ) ).

cnf(i_0_8655,axiom,
    ( esk16502_4(X1,X2,X3,X4)
    | ~ esk16504_4(X1,X2,X3,X4) ) ).

cnf(i_0_8656,axiom,
    ( esk15393_4(X1,X2,X3,X4)
    | esk15363_4(X1,X2,X3,X4) ) ).

cnf(i_0_8657,axiom,
    ( ~ esk4011_4(X1,X2,X3,X4)
    | ~ esk4016_4(X1,X2,X3,X4) ) ).

cnf(i_0_8658,axiom,
    ( esk8987_4(X1,X2,X3,X4)
    | ~ esk9245_4(X1,X2,X3,X4) ) ).

cnf(i_0_8659,axiom,
    ( ~ esk15458_4(X1,X2,X3,X4)
    | ~ esk15459_4(X1,X2,X3,X4) ) ).

cnf(i_0_8660,axiom,
    ( esk3259_4(X1,X2,X3,X4)
    | ~ esk3261_4(X1,X2,X3,X4) ) ).

cnf(i_0_8661,axiom,
    ( ~ esk14285_4(X1,X2,X3,X4)
    | ~ esk14258_4(X1,X2,X3,X4) ) ).

cnf(i_0_8662,axiom,
    ( ~ esk4018_4(X1,X2,X3,X4)
    | esk4019_4(X1,X2,X3,X4) ) ).

cnf(i_0_8663,axiom,
    ( ~ esk5597_4(X1,X2,X3,X4)
    | ~ esk5629_4(X1,X2,X3,X4)
    | ~ esk5676_4(X1,X2,X3,X4) ) ).

cnf(i_0_8664,axiom,
    ( ~ esk3378_4(X1,X2,X3,X4)
    | ~ esk3404_4(X1,X2,X3,X4)
    | ~ esk3379_4(X1,X2,X3,X4) ) ).

cnf(i_0_8665,axiom,
    ( esk15170_4(X1,X2,X3,X4)
    | ~ esk15049_4(X1,X2,X3,X4) ) ).

cnf(i_0_8666,axiom,
    ( ~ esk3955_4(X1,X2,X3,X4)
    | esk3998_4(X1,X2,X3,X4) ) ).

cnf(i_0_8667,axiom,
    ( ~ esk14290_4(X1,X2,X3,X4)
    | ~ esk14291_4(X1,X2,X3,X4) ) ).

cnf(i_0_8668,axiom,
    ( esk1550_4(X1,X2,X3,X4)
    | esk1432_4(X1,X2,X3,X4) ) ).

cnf(i_0_8669,axiom,
    ( esk467_4(X1,X2,X3,X4)
    | esk579_4(X1,X2,X3,X4) ) ).

cnf(i_0_8670,axiom,
    ( ~ esk10201_4(X1,X2,X3,X4)
    | ~ esk10293_4(X1,X2,X3,X4) ) ).

cnf(i_0_8671,axiom,
    ( ~ esk12141_4(X1,X2,X3,X4)
    | ~ esk12022_4(X1,X2,X3,X4)
    | ~ esk12026_4(X1,X2,X3,X4) ) ).

cnf(i_0_8672,axiom,
    ( esk7742_4(X1,X2,X3,X4)
    | esk7703_4(X1,X2,X3,X4) ) ).

cnf(i_0_8673,axiom,
    ( esk14109_4(X1,X2,X3,X4)
    | esk14060_4(X1,X2,X3,X4) ) ).

cnf(i_0_8674,axiom,
    ( esk8180_4(X1,X2,X3,X4)
    | esk8213_4(X1,X2,X3,X4) ) ).

cnf(i_0_8675,axiom,
    ( esk4180_4(X1,X2,X3,X4)
    | ~ esk4181_4(X1,X2,X3,X4) ) ).

cnf(i_0_8676,axiom,
    ( ~ esk3034_4(X1,X2,X3,X4)
    | ~ esk3067_4(X1,X2,X3,X4)
    | ~ esk3025_4(X1,X2,X3,X4) ) ).

cnf(i_0_8677,axiom,
    ( esk6738_4(X1,X2,X3,X4)
    | esk6653_4(X1,X2,X3,X4) ) ).

cnf(i_0_8678,axiom,
    ( esk965_4(X1,X2,X3,X4)
    | ~ esk1010_4(X1,X2,X3,X4) ) ).

cnf(i_0_8679,axiom,
    ( ~ esk15475_4(X1,X2,X3,X4)
    | esk15476_4(X1,X2,X3,X4)
    | ~ esk15474_4(X1,X2,X3,X4) ) ).

cnf(i_0_8680,axiom,
    ( esk7601_4(X1,X2,X3,X4)
    | ~ esk7589_4(X1,X2,X3,X4) ) ).

cnf(i_0_8681,axiom,
    ( ~ esk1248_4(X1,X2,X3,X4)
    | ~ esk1247_4(X1,X2,X3,X4)
    | ~ esk1216_4(X1,X2,X3,X4) ) ).

cnf(i_0_8682,axiom,
    ( ~ esk4886_4(X1,X2,X3,X4)
    | ~ esk4824_4(X1,X2,X3,X4)
    | ~ esk4853_4(X1,X2,X3,X4) ) ).

cnf(i_0_8683,axiom,
    ( ~ esk15968_4(X1,X2,X3,X4)
    | esk16002_4(X1,X2,X3,X4) ) ).

cnf(i_0_8684,axiom,
    ( ~ esk4913_4(X1,X2,X3,X4)
    | ~ esk4912_4(X1,X2,X3,X4) ) ).

cnf(i_0_8685,axiom,
    ( ~ esk1447_4(X1,X2,X3,X4)
    | ~ esk1445_4(X1,X2,X3,X4) ) ).

cnf(i_0_8686,axiom,
    ( esk10051_4(X1,X2,X3,X4)
    | ~ esk10073_4(X1,X2,X3,X4)
    | esk10052_4(X1,X2,X3,X4) ) ).

cnf(i_0_8687,axiom,
    ( ~ esk13589_4(X1,X2,X3,X4)
    | ~ esk13622_4(X1,X2,X3,X4)
    | ~ esk13562_4(X1,X2,X3,X4) ) ).

cnf(i_0_8688,axiom,
    ( esk7739_4(X1,X2,X3,X4)
    | esk7740_4(X1,X2,X3,X4)
    | esk7738_4(X1,X2,X3,X4) ) ).

cnf(i_0_8689,axiom,
    ( p(X2)
    | ~ esk1_0
    | p(X1)
    | p(X4)
    | esk412_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_8690,axiom,
    ( esk13015_4(X1,X2,X3,X4)
    | ~ esk13009_4(X1,X2,X3,X4) ) ).

cnf(i_0_8691,axiom,
    ( esk9974_4(X1,X2,X3,X4)
    | esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_8692,axiom,
    ( esk2768_4(X1,X2,X3,X4)
    | esk2797_4(X1,X2,X3,X4) ) ).

cnf(i_0_8693,axiom,
    ( esk13012_4(X1,X2,X3,X4)
    | esk13011_4(X1,X2,X3,X4)
    | esk13006_4(X1,X2,X3,X4) ) ).

cnf(i_0_8694,axiom,
    ( ~ esk2113_4(X1,X2,X3,X4)
    | ~ esk2061_4(X1,X2,X3,X4) ) ).

cnf(i_0_8695,axiom,
    ( ~ esk14769_4(X1,X2,X3,X4)
    | ~ esk14799_4(X1,X2,X3,X4) ) ).

cnf(i_0_8696,axiom,
    ( ~ esk8677_4(X1,X2,X3,X4)
    | ~ esk8685_4(X1,X2,X3,X4)
    | ~ esk8684_4(X1,X2,X3,X4) ) ).

cnf(i_0_8697,axiom,
    ( esk15127_4(X1,X2,X3,X4)
    | esk15160_4(X1,X2,X3,X4) ) ).

cnf(i_0_8698,axiom,
    ( ~ esk7583_4(X1,X2,X3,X4)
    | esk7560_4(X1,X2,X3,X4) ) ).

cnf(i_0_8699,axiom,
    ( esk4816_4(X1,X2,X3,X4)
    | esk4841_4(X1,X2,X3,X4) ) ).

cnf(i_0_8700,axiom,
    ( ~ esk9613_4(X1,X2,X3,X4)
    | esk9642_4(X1,X2,X3,X4) ) ).

cnf(i_0_8701,axiom,
    ( esk1923_4(X1,X2,X3,X4)
    | ~ esk1947_4(X1,X2,X3,X4) ) ).

cnf(i_0_8702,axiom,
    ( ~ esk3659_4(X1,X2,X3,X4)
    | ~ esk3575_4(X1,X2,X3,X4)
    | ~ esk3622_4(X1,X2,X3,X4) ) ).

cnf(i_0_8703,axiom,
    ( esk975_4(X1,X2,X3,X4)
    | esk971_4(X1,X2,X3,X4) ) ).

cnf(i_0_8704,axiom,
    ( esk4053_4(X1,X2,X3,X4)
    | esk4072_4(X1,X2,X3,X4) ) ).

cnf(i_0_8705,axiom,
    ( ~ esk13772_4(X1,X2,X3,X4)
    | ~ esk13766_4(X1,X2,X3,X4)
    | esk13767_4(X1,X2,X3,X4) ) ).

cnf(i_0_8706,axiom,
    ( esk11872_4(X1,X2,X3,X4)
    | esk11787_4(X1,X2,X3,X4) ) ).

cnf(i_0_8707,axiom,
    ( esk12032_4(X1,X2,X3,X4)
    | esk12022_4(X1,X2,X3,X4) ) ).

cnf(i_0_8708,axiom,
    ( esk12568_4(X1,X2,X3,X4)
    | esk12518_4(X1,X2,X3,X4) ) ).

cnf(i_0_8709,axiom,
    ( ~ esk16227_4(X1,X2,X3,X4)
    | esk16176_4(X1,X2,X3,X4)
    | esk16256_4(X1,X2,X3,X4) ) ).

cnf(i_0_8710,axiom,
    ( esk8198_4(X1,X2,X3,X4)
    | esk8231_4(X1,X2,X3,X4) ) ).

cnf(i_0_8711,axiom,
    ( esk6451_4(X1,X2,X3,X4)
    | esk6452_4(X1,X2,X3,X4)
    | esk6450_4(X1,X2,X3,X4) ) ).

cnf(i_0_8712,axiom,
    ( ~ esk14394_4(X1,X2,X3,X4)
    | esk14319_4(X1,X2,X3,X4) ) ).

cnf(i_0_8713,axiom,
    ( esk14881_4(X1,X2,X3,X4)
    | esk14928_4(X1,X2,X3,X4) ) ).

cnf(i_0_8714,axiom,
    ( ~ esk2254_4(X1,X2,X3,X4)
    | ~ esk2234_4(X1,X2,X3,X4) ) ).

cnf(i_0_8715,axiom,
    ( ~ esk8606_4(X1,X2,X3,X4)
    | ~ esk8759_4(X1,X2,X3,X4)
    | ~ esk8752_4(X1,X2,X3,X4) ) ).

cnf(i_0_8716,axiom,
    ( esk5854_4(X1,X2,X3,X4)
    | esk5858_4(X1,X2,X3,X4) ) ).

cnf(i_0_8717,axiom,
    ( esk11161_4(X1,X2,X3,X4)
    | ~ esk11193_4(X1,X2,X3,X4) ) ).

cnf(i_0_8718,axiom,
    ( ~ esk10271_4(X1,X2,X3,X4)
    | esk10322_4(X1,X2,X3,X4) ) ).

cnf(i_0_8719,axiom,
    ( esk3776_4(X1,X2,X3,X4)
    | esk3742_4(X1,X2,X3,X4)
    | esk3796_4(X1,X2,X3,X4) ) ).

cnf(i_0_8720,axiom,
    ( esk8475_4(X1,X2,X3,X4)
    | ~ esk8412_4(X1,X2,X3,X4) ) ).

cnf(i_0_8721,axiom,
    ( esk3983_4(X1,X2,X3,X4)
    | ~ esk3964_4(X1,X2,X3,X4) ) ).

cnf(i_0_8722,axiom,
    ( esk3025_4(X1,X2,X3,X4)
    | esk3054_4(X1,X2,X3,X4) ) ).

cnf(i_0_8723,axiom,
    ( ~ esk15540_4(X1,X2,X3,X4)
    | ~ esk15570_4(X1,X2,X3,X4) ) ).

cnf(i_0_8724,axiom,
    ( esk13331_4(X1,X2,X3,X4)
    | esk13293_4(X1,X2,X3,X4) ) ).

cnf(i_0_8725,axiom,
    ( esk8126_4(X1,X2,X3,X4)
    | esk8125_4(X1,X2,X3,X4) ) ).

cnf(i_0_8726,axiom,
    ( esk1672_4(X1,X2,X3,X4)
    | ~ esk1649_4(X1,X2,X3,X4) ) ).

cnf(i_0_8727,axiom,
    ( ~ esk13879_4(X1,X2,X3,X4)
    | ~ esk13846_4(X1,X2,X3,X4)
    | ~ esk13819_4(X1,X2,X3,X4) ) ).

cnf(i_0_8728,axiom,
    ( esk4611_4(X1,X2,X3,X4)
    | esk4691_4(X1,X2,X3,X4)
    | ~ esk4662_4(X1,X2,X3,X4) ) ).

cnf(i_0_8729,axiom,
    ( ~ esk11443_4(X1,X2,X3,X4)
    | esk11410_4(X1,X2,X3,X4) ) ).

cnf(i_0_8730,axiom,
    ( esk4046_4(X1,X2,X3,X4)
    | esk4068_4(X1,X2,X3,X4) ) ).

cnf(i_0_8731,axiom,
    ( ~ esk12469_4(X1,X2,X3,X4)
    | esk12440_4(X1,X2,X3,X4) ) ).

cnf(i_0_8732,axiom,
    ( ~ esk4096_4(X1,X2,X3,X4)
    | esk4048_4(X1,X2,X3,X4) ) ).

cnf(i_0_8733,axiom,
    ( ~ esk8265_4(X1,X2,X3,X4)
    | ~ esk8247_4(X1,X2,X3,X4) ) ).

cnf(i_0_8734,axiom,
    ( esk2302_4(X1,X2,X3,X4)
    | esk2269_4(X1,X2,X3,X4) ) ).

cnf(i_0_8735,axiom,
    ( ~ p(X2)
    | p(X1)
    | ~ esk293_0
    | p(X3)
    | ~ p(X4)
    | esk16711_4(X1,X2,X3,X4) ) ).

cnf(i_0_8736,axiom,
    ( esk11165_4(X1,X2,X3,X4)
    | ~ esk11189_4(X1,X2,X3,X4) ) ).

cnf(i_0_8737,axiom,
    ( p(X3)
    | ~ esk136_0
    | ~ p(X4)
    | esk16689_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ p(X2) ) ).

cnf(i_0_8738,axiom,
    ( ~ esk5528_4(X1,X2,X3,X4)
    | esk5649_4(X1,X2,X3,X4) ) ).

cnf(i_0_8739,axiom,
    ( ~ esk15908_4(X1,X2,X3,X4)
    | ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15941_4(X1,X2,X3,X4) ) ).

cnf(i_0_8740,axiom,
    ( esk7882_4(X1,X2,X3,X4)
    | ~ esk7886_4(X1,X2,X3,X4) ) ).

cnf(i_0_8741,axiom,
    ( esk433_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ esk62_0
    | ~ p(X3)
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_8742,axiom,
    ( esk10566_4(X1,X2,X3,X4)
    | esk10564_4(X1,X2,X3,X4) ) ).

cnf(i_0_8743,axiom,
    ( esk432_4(X1,X2,X3,X4)
    | ~ esk434_4(X1,X2,X3,X4) ) ).

cnf(i_0_8744,axiom,
    ( esk6461_4(X1,X2,X3,X4)
    | esk6460_4(X1,X2,X3,X4)
    | esk6459_4(X1,X2,X3,X4) ) ).

cnf(i_0_8745,axiom,
    ( esk8854_4(X1,X2,X3,X4)
    | ~ esk9005_4(X1,X2,X3,X4)
    | esk8885_4(X1,X2,X3,X4) ) ).

cnf(i_0_8746,axiom,
    ( esk16727_4(X1,X2,X3,X4)
    | esk16680_4(X1,X2,X3,X4) ) ).

cnf(i_0_8747,axiom,
    ( esk706_4(X1,X2,X3,X4)
    | esk725_4(X1,X2,X3,X4) ) ).

cnf(i_0_8748,axiom,
    ( esk8681_4(X1,X2,X3,X4)
    | esk8691_4(X1,X2,X3,X4) ) ).

cnf(i_0_8749,axiom,
    ( ~ esk15973_4(X1,X2,X3,X4)
    | ~ esk15972_4(X1,X2,X3,X4) ) ).

cnf(i_0_8750,axiom,
    ( esk10833_4(X1,X2,X3,X4)
    | ~ esk10818_4(X1,X2,X3,X4) ) ).

cnf(i_0_8751,axiom,
    ( esk12619_4(X1,X2,X3,X4)
    | esk12596_4(X1,X2,X3,X4) ) ).

cnf(i_0_8752,axiom,
    ( ~ esk2567_4(X1,X2,X3,X4)
    | ~ esk2511_4(X1,X2,X3,X4)
    | ~ esk2534_4(X1,X2,X3,X4) ) ).

cnf(i_0_8753,axiom,
    ( esk4143_4(X1,X2,X3,X4)
    | esk4144_4(X1,X2,X3,X4)
    | esk4184_4(X1,X2,X3,X4)
    | esk4145_4(X1,X2,X3,X4) ) ).

cnf(i_0_8754,axiom,
    ( ~ esk5412_4(X1,X2,X3,X4)
    | ~ esk5287_4(X1,X2,X3,X4) ) ).

cnf(i_0_8755,axiom,
    ( esk12212_4(X1,X2,X3,X4)
    | ~ esk12183_4(X1,X2,X3,X4) ) ).

cnf(i_0_8756,axiom,
    ( ~ esk12194_4(X1,X2,X3,X4)
    | esk12216_4(X1,X2,X3,X4) ) ).

cnf(i_0_8757,axiom,
    ( ~ esk2093_4(X1,X2,X3,X4)
    | ~ esk2037_4(X1,X2,X3,X4) ) ).

cnf(i_0_8758,axiom,
    ( esk4274_4(X1,X2,X3,X4)
    | ~ esk4281_4(X1,X2,X3,X4)
    | esk4267_4(X1,X2,X3,X4) ) ).

cnf(i_0_8759,axiom,
    ( esk7683_4(X1,X2,X3,X4)
    | esk7770_4(X1,X2,X3,X4) ) ).

cnf(i_0_8760,axiom,
    ( ~ esk14291_4(X1,X2,X3,X4)
    | ~ esk14295_4(X1,X2,X3,X4) ) ).

cnf(i_0_8761,axiom,
    ( ~ esk8259_4(X1,X2,X3,X4)
    | ~ esk8260_4(X1,X2,X3,X4) ) ).

cnf(i_0_8762,axiom,
    ( ~ esk391_4(X1,X2,X3,X4)
    | esk360_4(X1,X2,X3,X4) ) ).

cnf(i_0_8763,axiom,
    ( esk16356_4(X1,X2,X3,X4)
    | ~ esk16352_4(X1,X2,X3,X4) ) ).

cnf(i_0_8764,axiom,
    ( ~ esk6812_4(X1,X2,X3,X4)
    | esk6789_4(X1,X2,X3,X4) ) ).

cnf(i_0_8765,axiom,
    ( ~ esk12694_4(X1,X2,X3,X4)
    | esk12729_4(X1,X2,X3,X4) ) ).

cnf(i_0_8766,axiom,
    ( esk11010_4(X1,X2,X3,X4)
    | esk10994_4(X1,X2,X3,X4) ) ).

cnf(i_0_8767,axiom,
    ( ~ esk16713_4(X1,X2,X3,X4)
    | ~ esk16595_4(X1,X2,X3,X4) ) ).

cnf(i_0_8768,axiom,
    esk9140_4(X1,X2,X3,X4) ).

cnf(i_0_8769,axiom,
    ( ~ esk675_4(X1,X2,X3,X4)
    | ~ esk677_4(X1,X2,X3,X4) ) ).

cnf(i_0_8770,axiom,
    ( esk13798_4(X1,X2,X3,X4)
    | ~ esk13796_4(X1,X2,X3,X4) ) ).

cnf(i_0_8771,axiom,
    ( ~ esk4567_4(X1,X2,X3,X4)
    | ~ esk4580_4(X1,X2,X3,X4)
    | ~ esk4613_4(X1,X2,X3,X4) ) ).

cnf(i_0_8772,axiom,
    ( esk2802_4(X1,X2,X3,X4)
    | esk2849_4(X1,X2,X3,X4) ) ).

cnf(i_0_8773,axiom,
    ( ~ esk5789_4(X1,X2,X3,X4)
    | esk5802_4(X1,X2,X3,X4) ) ).

cnf(i_0_8774,axiom,
    ( esk14863_4(X1,X2,X3,X4)
    | esk14946_4(X1,X2,X3,X4) ) ).

cnf(i_0_8775,axiom,
    ( ~ esk4157_4(X1,X2,X3,X4)
    | esk4158_4(X1,X2,X3,X4) ) ).

cnf(i_0_8776,axiom,
    ( ~ esk5918_4(X1,X2,X3,X4)
    | esk5969_4(X1,X2,X3,X4) ) ).

cnf(i_0_8777,axiom,
    ( ~ esk3625_4(X1,X2,X3,X4)
    | ~ esk3668_4(X1,X2,X3,X4)
    | ~ esk3599_4(X1,X2,X3,X4) ) ).

cnf(i_0_8778,axiom,
    ( ~ esk2257_4(X1,X2,X3,X4)
    | ~ esk2290_4(X1,X2,X3,X4)
    | ~ esk2254_4(X1,X2,X3,X4) ) ).

cnf(i_0_8779,axiom,
    ( esk9062_4(X1,X2,X3,X4)
    | ~ esk9064_4(X1,X2,X3,X4) ) ).

cnf(i_0_8780,axiom,
    ( ~ esk6694_4(X1,X2,X3,X4)
    | esk6952_4(X1,X2,X3,X4) ) ).

cnf(i_0_8781,axiom,
    ( ~ esk5338_4(X1,X2,X3,X4)
    | ~ esk5363_4(X1,X2,X3,X4)
    | ~ esk5396_4(X1,X2,X3,X4) ) ).

cnf(i_0_8782,axiom,
    ( ~ esk10173_4(X1,X2,X3,X4)
    | ~ esk10143_4(X1,X2,X3,X4) ) ).

cnf(i_0_8783,axiom,
    ( esk15193_4(X1,X2,X3,X4)
    | esk15194_4(X1,X2,X3,X4) ) ).

cnf(i_0_8784,axiom,
    ( ~ esk5049_4(X1,X2,X3,X4)
    | esk5047_4(X1,X2,X3,X4) ) ).

cnf(i_0_8785,axiom,
    ( ~ esk12734_4(X1,X2,X3,X4)
    | esk12835_4(X1,X2,X3,X4) ) ).

cnf(i_0_8786,axiom,
    ( ~ esk10223_4(X1,X2,X3,X4)
    | ~ esk10353_4(X1,X2,X3,X4)
    | ~ esk10247_4(X1,X2,X3,X4) ) ).

cnf(i_0_8787,axiom,
    ( esk2043_4(X1,X2,X3,X4)
    | ~ esk2124_4(X1,X2,X3,X4)
    | esk2090_4(X1,X2,X3,X4) ) ).

cnf(i_0_8788,axiom,
    ( esk1702_4(X1,X2,X3,X4)
    | ~ esk1686_4(X1,X2,X3,X4) ) ).

cnf(i_0_8789,axiom,
    ( esk2272_4(X1,X2,X3,X4)
    | esk2256_4(X1,X2,X3,X4) ) ).

cnf(i_0_8790,axiom,
    ( esk8679_4(X1,X2,X3,X4)
    | esk8694_4(X1,X2,X3,X4) ) ).

cnf(i_0_8791,axiom,
    ( esk5418_4(X1,X2,X3,X4)
    | esk5417_4(X1,X2,X3,X4) ) ).

cnf(i_0_8792,axiom,
    ( ~ esk8379_4(X1,X2,X3,X4)
    | esk8121_4(X1,X2,X3,X4) ) ).

cnf(i_0_8793,axiom,
    ( ~ esk7742_4(X1,X2,X3,X4)
    | esk7756_4(X1,X2,X3,X4) ) ).

cnf(i_0_8794,axiom,
    ( ~ esk404_4(X1,X2,X3,X4)
    | ~ esk406_4(X1,X2,X3,X4) ) ).

cnf(i_0_8795,axiom,
    ( ~ esk9800_4(X1,X2,X3,X4)
    | esk9834_4(X1,X2,X3,X4) ) ).

cnf(i_0_8796,axiom,
    ( esk2072_4(X1,X2,X3,X4)
    | ~ esk2070_4(X1,X2,X3,X4) ) ).

cnf(i_0_8797,axiom,
    ( p(X2)
    | esk11_0
    | ~ p(X1)
    | p(X4)
    | p(X3)
    | ~ esk16600_4(X1,X2,X3,X4) ) ).

cnf(i_0_8798,axiom,
    ( esk9815_4(X1,X2,X3,X4)
    | esk9729_4(X1,X2,X3,X4) ) ).

cnf(i_0_8799,axiom,
    ( esk12228_4(X1,X2,X3,X4)
    | esk12178_4(X1,X2,X3,X4) ) ).

cnf(i_0_8800,axiom,
    ( esk7921_4(X1,X2,X3,X4)
    | esk7908_4(X1,X2,X3,X4) ) ).

cnf(i_0_8801,axiom,
    ( ~ esk9617_4(X1,X2,X3,X4)
    | esk9638_4(X1,X2,X3,X4) ) ).

cnf(i_0_8802,axiom,
    ( ~ esk4555_4(X1,X2,X3,X4)
    | ~ esk4592_4(X1,X2,X3,X4)
    | ~ esk4593_4(X1,X2,X3,X4) ) ).

cnf(i_0_8803,axiom,
    ( esk1292_4(X1,X2,X3,X4)
    | ~ esk1171_4(X1,X2,X3,X4) ) ).

cnf(i_0_8804,axiom,
    ( ~ esk7651_4(X1,X2,X3,X4)
    | ~ esk7680_4(X1,X2,X3,X4)
    | ~ esk7713_4(X1,X2,X3,X4) ) ).

cnf(i_0_8805,axiom,
    ( esk13052_4(X1,X2,X3,X4)
    | esk13168_4(X1,X2,X3,X4) ) ).

cnf(i_0_8806,axiom,
    ( ~ p(X4)
    | esk180_0
    | ~ esk505_4(X1,X2,X3,X4)
    | ~ p(X2)
    | ~ p(X1)
    | p(X3) ) ).

cnf(i_0_8807,axiom,
    ( ~ esk4021_4(X1,X2,X3,X4)
    | esk4012_4(X1,X2,X3,X4) ) ).

cnf(i_0_8808,axiom,
    ( esk1797_4(X1,X2,X3,X4)
    | ~ esk1728_4(X1,X2,X3,X4) ) ).

cnf(i_0_8809,axiom,
    ( esk4392_4(X1,X2,X3,X4)
    | esk4401_4(X1,X2,X3,X4)
    | esk4400_4(X1,X2,X3,X4) ) ).

cnf(i_0_8810,axiom,
    ( ~ esk2764_4(X1,X2,X3,X4)
    | esk2809_4(X1,X2,X3,X4) ) ).

cnf(i_0_8811,axiom,
    ( esk16345_4(X1,X2,X3,X4)
    | ~ esk16361_4(X1,X2,X3,X4) ) ).

cnf(i_0_8812,axiom,
    ( esk15914_4(X1,X2,X3,X4)
    | ~ esk16172_4(X1,X2,X3,X4) ) ).

cnf(i_0_8813,axiom,
    ( esk2601_4(X1,X2,X3,X4)
    | esk2600_4(X1,X2,X3,X4) ) ).

cnf(i_0_8814,axiom,
    ( ~ esk10212_4(X1,X2,X3,X4)
    | ~ esk10241_4(X1,X2,X3,X4)
    | ~ esk10240_4(X1,X2,X3,X4) ) ).

cnf(i_0_8815,axiom,
    ( esk4143_4(X1,X2,X3,X4)
    | esk4107_4(X1,X2,X3,X4) ) ).

cnf(i_0_8816,axiom,
    ( ~ esk4434_4(X1,X2,X3,X4)
    | ~ esk4405_4(X1,X2,X3,X4)
    | ~ esk4354_4(X1,X2,X3,X4) ) ).

cnf(i_0_8817,axiom,
    ( ~ p(X1)
    | ~ esk272_0
    | ~ p(X3)
    | ~ p(X2)
    | ~ p(X4)
    | esk517_4(X1,X2,X3,X4) ) ).

cnf(i_0_8818,axiom,
    ( esk9099_4(X1,X2,X3,X4)
    | ~ esk9128_4(X1,X2,X3,X4) ) ).

cnf(i_0_8819,axiom,
    ( ~ esk5404_4(X1,X2,X3,X4)
    | esk5146_4(X1,X2,X3,X4) ) ).

cnf(i_0_8820,axiom,
    ( esk16682_4(X1,X2,X3,X4)
    | esk16649_4(X1,X2,X3,X4) ) ).

cnf(i_0_8821,axiom,
    ( esk4145_4(X1,X2,X3,X4)
    | esk4146_4(X1,X2,X3,X4) ) ).

cnf(i_0_8822,axiom,
    ( esk16747_4(X1,X2,X3,X4)
    | ~ esk16749_4(X1,X2,X3,X4) ) ).

cnf(i_0_8823,axiom,
    ( esk6926_4(X1,X2,X3,X4)
    | ~ esk6824_4(X1,X2,X3,X4) ) ).

cnf(i_0_8824,axiom,
    ( ~ esk4366_4(X1,X2,X3,X4)
    | esk4108_4(X1,X2,X3,X4) ) ).

cnf(i_0_8825,axiom,
    ( ~ esk6111_4(X1,X2,X3,X4)
    | ~ esk6110_4(X1,X2,X3,X4) ) ).

cnf(i_0_8826,axiom,
    ( esk1483_4(X1,X2,X3,X4)
    | esk1494_4(X1,X2,X3,X4) ) ).

cnf(i_0_8827,axiom,
    ( esk3882_4(X1,X2,X3,X4)
    | esk3884_4(X1,X2,X3,X4) ) ).

cnf(i_0_8828,axiom,
    ( esk12867_4(X1,X2,X3,X4)
    | ~ esk12710_4(X1,X2,X3,X4) ) ).

cnf(i_0_8829,axiom,
    ( ~ esk9789_4(X1,X2,X3,X4)
    | ~ esk9797_4(X1,X2,X3,X4) ) ).

cnf(i_0_8830,axiom,
    ( esk2820_4(X1,X2,X3,X4)
    | esk2859_4(X1,X2,X3,X4) ) ).

cnf(i_0_8831,axiom,
    ( esk1483_4(X1,X2,X3,X4)
    | esk1498_4(X1,X2,X3,X4) ) ).

cnf(i_0_8832,axiom,
    ( esk11766_4(X1,X2,X3,X4)
    | esk11762_4(X1,X2,X3,X4) ) ).

cnf(i_0_8833,axiom,
    ( ~ esk530_4(X1,X2,X3,X4)
    | esk532_4(X1,X2,X3,X4)
    | ~ esk531_4(X1,X2,X3,X4) ) ).

cnf(i_0_8834,axiom,
    ( ~ esk11743_4(X1,X2,X3,X4)
    | ~ esk11842_4(X1,X2,X3,X4) ) ).

cnf(i_0_8835,axiom,
    ( ~ esk3587_4(X1,X2,X3,X4)
    | esk3329_4(X1,X2,X3,X4) ) ).

cnf(i_0_8836,axiom,
    ( esk8808_4(X1,X2,X3,X4)
    | esk8765_4(X1,X2,X3,X4) ) ).

cnf(i_0_8837,axiom,
    ( ~ esk4908_4(X1,X2,X3,X4)
    | ~ esk4936_4(X1,X2,X3,X4) ) ).

cnf(i_0_8838,axiom,
    ( esk7601_4(X1,X2,X3,X4)
    | ~ esk7595_4(X1,X2,X3,X4) ) ).

cnf(i_0_8839,axiom,
    ( esk708_4(X1,X2,X3,X4)
    | esk722_4(X1,X2,X3,X4) ) ).

cnf(i_0_8840,axiom,
    ( ~ esk1722_4(X1,X2,X3,X4)
    | ~ esk1723_4(X1,X2,X3,X4) ) ).

cnf(i_0_8841,axiom,
    ( p(X3)
    | p(X1)
    | ~ p(X2)
    | ~ p(X4)
    | esk16602_4(X1,X2,X3,X4)
    | ~ esk23_0 ) ).

cnf(i_0_8842,axiom,
    ( esk10696_4(X1,X2,X3,X4)
    | esk10695_4(X1,X2,X3,X4) ) ).

cnf(i_0_8843,axiom,
    ( ~ esk10528_4(X1,X2,X3,X4)
    | ~ esk10428_4(X1,X2,X3,X4)
    | esk10409_4(X1,X2,X3,X4) ) ).

cnf(i_0_8844,axiom,
    ( ~ esk7228_4(X1,X2,X3,X4)
    | esk7242_4(X1,X2,X3,X4) ) ).

cnf(i_0_8845,axiom,
    ( esk16717_4(X1,X2,X3,X4)
    | ~ esk309_0
    | p(X1)
    | ~ p(X3)
    | p(X4)
    | ~ p(X2) ) ).

cnf(i_0_8846,axiom,
    ( ~ esk2852_4(X1,X2,X3,X4)
    | ~ esk2880_4(X1,X2,X3,X4) ) ).

cnf(i_0_8847,axiom,
    ( esk16605_4(X1,X2,X3,X4)
    | p(X3)
    | ~ esk37_0
    | ~ p(X2)
    | p(X1)
    | p(X4) ) ).

cnf(i_0_8848,axiom,
    ( esk8120_4(X1,X2,X3,X4)
    | esk8129_4(X1,X2,X3,X4) ) ).

cnf(i_0_8849,axiom,
    ( esk5765_4(X1,X2,X3,X4)
    | ~ esk5795_4(X1,X2,X3,X4) ) ).

cnf(i_0_8850,axiom,
    ( ~ esk9667_4(X1,X2,X3,X4)
    | esk9673_4(X1,X2,X3,X4) ) ).

cnf(i_0_8851,axiom,
    ( ~ esk12881_4(X1,X2,X3,X4)
    | ~ esk12880_4(X1,X2,X3,X4)
    | ~ esk12845_4(X1,X2,X3,X4) ) ).

cnf(i_0_8852,axiom,
    ( ~ esk2091_4(X1,X2,X3,X4)
    | ~ esk2043_4(X1,X2,X3,X4) ) ).

cnf(i_0_8853,axiom,
    ( esk6350_4(X1,X2,X3,X4)
    | esk6399_4(X1,X2,X3,X4) ) ).

cnf(i_0_8854,axiom,
    ( ~ esk15109_4(X1,X2,X3,X4)
    | ~ esk15102_4(X1,X2,X3,X4)
    | ~ esk15110_4(X1,X2,X3,X4) ) ).

cnf(i_0_8855,axiom,
    ( esk11817_4(X1,X2,X3,X4)
    | ~ esk11559_4(X1,X2,X3,X4) ) ).

cnf(i_0_8856,axiom,
    ( esk14499_4(X1,X2,X3,X4)
    | ~ esk14522_4(X1,X2,X3,X4) ) ).

cnf(i_0_8857,axiom,
    ( esk8386_4(X1,X2,X3,X4)
    | esk8400_4(X1,X2,X3,X4) ) ).

cnf(i_0_8858,axiom,
    ( esk1073_4(X1,X2,X3,X4)
    | esk1059_4(X1,X2,X3,X4) ) ).

cnf(i_0_8859,axiom,
    ( esk14678_4(X1,X2,X3,X4)
    | esk14677_4(X1,X2,X3,X4)
    | ~ esk14699_4(X1,X2,X3,X4) ) ).

cnf(i_0_8860,axiom,
    ( esk7470_4(X1,X2,X3,X4)
    | ~ esk7313_4(X1,X2,X3,X4) ) ).

cnf(i_0_8861,axiom,
    ( esk5840_4(X1,X2,X3,X4)
    | esk5878_4(X1,X2,X3,X4) ) ).

cnf(i_0_8862,axiom,
    ( esk7148_4(X1,X2,X3,X4)
    | esk7137_4(X1,X2,X3,X4) ) ).

cnf(i_0_8863,axiom,
    ( ~ esk14500_4(X1,X2,X3,X4)
    | esk14521_4(X1,X2,X3,X4) ) ).

cnf(i_0_8864,axiom,
    ( esk2705_4(X1,X2,X3,X4)
    | ~ esk2718_4(X1,X2,X3,X4)
    | ~ esk2830_4(X1,X2,X3,X4) ) ).

cnf(i_0_8865,axiom,
    ( esk16462_4(X1,X2,X3,X4)
    | esk16469_4(X1,X2,X3,X4) ) ).

cnf(i_0_8866,axiom,
    ( esk10535_4(X1,X2,X3,X4)
    | ~ esk10793_4(X1,X2,X3,X4) ) ).

cnf(i_0_8867,axiom,
    ( esk16238_4(X1,X2,X3,X4)
    | ~ esk16222_4(X1,X2,X3,X4) ) ).

cnf(i_0_8868,axiom,
    ( ~ esk11507_4(X1,X2,X3,X4)
    | ~ esk11508_4(X1,X2,X3,X4) ) ).

cnf(i_0_8869,axiom,
    ( esk6644_4(X1,X2,X3,X4)
    | esk6623_4(X1,X2,X3,X4) ) ).

cnf(i_0_8870,axiom,
    ( esk15327_4(X1,X2,X3,X4)
    | ~ esk15329_4(X1,X2,X3,X4) ) ).

cnf(i_0_8871,axiom,
    ( esk10721_4(X1,X2,X3,X4)
    | ~ esk10796_4(X1,X2,X3,X4) ) ).

cnf(i_0_8872,axiom,
    ( esk5243_4(X1,X2,X3,X4)
    | ~ esk5274_4(X1,X2,X3,X4) ) ).

cnf(i_0_8873,axiom,
    ( ~ esk13216_4(X1,X2,X3,X4)
    | esk13235_4(X1,X2,X3,X4) ) ).

cnf(i_0_8874,axiom,
    ( esk8372_4(X1,X2,X3,X4)
    | ~ esk8355_4(X1,X2,X3,X4) ) ).

cnf(i_0_8875,axiom,
    ( ~ esk7396_4(X1,X2,X3,X4)
    | ~ esk7395_4(X1,X2,X3,X4) ) ).

cnf(i_0_8876,axiom,
    ( esk5295_4(X1,X2,X3,X4)
    | ~ esk5037_4(X1,X2,X3,X4) ) ).

cnf(i_0_8877,axiom,
    ( ~ esk9448_4(X1,X2,X3,X4)
    | ~ esk9455_4(X1,X2,X3,X4)
    | ~ esk9456_4(X1,X2,X3,X4) ) ).

cnf(i_0_8878,axiom,
    ( esk663_4(X1,X2,X3,X4)
    | esk610_4(X1,X2,X3,X4) ) ).

cnf(i_0_8879,axiom,
    ( esk16613_4(X1,X2,X3,X4)
    | ~ esk16614_4(X1,X2,X3,X4) ) ).

cnf(i_0_8880,axiom,
    ( esk15679_4(X1,X2,X3,X4)
    | ~ esk15604_4(X1,X2,X3,X4) ) ).

cnf(i_0_8881,axiom,
    ( ~ esk12871_4(X1,X2,X3,X4)
    | ~ esk12870_4(X1,X2,X3,X4) ) ).

cnf(i_0_8882,axiom,
    ( ~ esk2583_4(X1,X2,X3,X4)
    | esk2325_4(X1,X2,X3,X4) ) ).

cnf(i_0_8883,axiom,
    ( ~ p(X2)
    | ~ p(X3)
    | ~ esk16691_4(X1,X2,X3,X4)
    | esk1_0
    | ~ p(X1)
    | ~ p(X4) ) ).

cnf(i_0_8884,axiom,
    ( ~ esk10997_4(X1,X2,X3,X4)
    | ~ esk10992_4(X1,X2,X3,X4)
    | ~ esk11030_4(X1,X2,X3,X4) ) ).

cnf(i_0_8885,axiom,
    ( esk767_4(X1,X2,X3,X4)
    | ~ esk701_4(X1,X2,X3,X4) ) ).

cnf(i_0_8886,axiom,
    ( esk251_0
    | ~ esk16705_4(X1,X2,X3,X4)
    | p(X4)
    | ~ p(X1)
    | p(X2)
    | p(X3) ) ).

cnf(i_0_8887,axiom,
    ( esk3812_4(X1,X2,X3,X4)
    | esk3895_4(X1,X2,X3,X4) ) ).

cnf(i_0_8888,axiom,
    ( ~ esk16051_4(X1,X2,X3,X4)
    | esk16208_4(X1,X2,X3,X4) ) ).

cnf(i_0_8889,axiom,
    ( ~ esk7252_4(X1,X2,X3,X4)
    | esk7251_4(X1,X2,X3,X4) ) ).

cnf(i_0_8890,axiom,
    ( ~ esk3016_4(X1,X2,X3,X4)
    | esk3076_4(X1,X2,X3,X4) ) ).

cnf(i_0_8891,axiom,
    ( ~ esk15144_4(X1,X2,X3,X4)
    | ~ esk15200_4(X1,X2,X3,X4) ) ).

cnf(i_0_8892,axiom,
    ( esk8178_4(X1,X2,X3,X4)
    | esk8159_4(X1,X2,X3,X4) ) ).

cnf(i_0_8893,axiom,
    ( esk7470_4(X1,X2,X3,X4)
    | ~ esk7471_4(X1,X2,X3,X4) ) ).

cnf(i_0_8894,axiom,
    ( ~ esk11251_4(X1,X2,X3,X4)
    | ~ esk11279_4(X1,X2,X3,X4)
    | ~ esk11364_4(X1,X2,X3,X4) ) ).

cnf(i_0_8895,axiom,
    ( ~ esk16439_4(X1,X2,X3,X4)
    | ~ esk16520_4(X1,X2,X3,X4) ) ).

cnf(i_0_8896,axiom,
    ( ~ esk5595_4(X1,X2,X3,X4)
    | ~ esk5575_4(X1,X2,X3,X4) ) ).

cnf(i_0_8897,axiom,
    ( esk13828_4(X1,X2,X3,X4)
    | esk13819_4(X1,X2,X3,X4) ) ).

cnf(i_0_8898,axiom,
    ( esk3117_4(X1,X2,X3,X4)
    | esk3156_4(X1,X2,X3,X4)
    | esk3115_4(X1,X2,X3,X4)
    | esk3116_4(X1,X2,X3,X4) ) ).

cnf(i_0_8899,axiom,
    ( ~ esk947_4(X1,X2,X3,X4)
    | esk689_4(X1,X2,X3,X4) ) ).

cnf(i_0_8900,axiom,
    ( esk16399_4(X1,X2,X3,X4)
    | esk16391_4(X1,X2,X3,X4) ) ).

cnf(i_0_8901,axiom,
    ( esk13498_4(X1,X2,X3,X4)
    | ~ esk13467_4(X1,X2,X3,X4) ) ).

cnf(i_0_8902,axiom,
    ( ~ esk917_4(X1,X2,X3,X4)
    | esk922_4(X1,X2,X3,X4) ) ).

cnf(i_0_8903,axiom,
    ( ~ esk1684_4(X1,X2,X3,X4)
    | esk1690_4(X1,X2,X3,X4) ) ).

cnf(i_0_8904,axiom,
    ( ~ esk1718_4(X1,X2,X3,X4)
    | esk1460_4(X1,X2,X3,X4) ) ).

cnf(i_0_8905,axiom,
    ( ~ esk1425_4(X1,X2,X3,X4)
    | esk1525_4(X1,X2,X3,X4) ) ).

cnf(i_0_8906,axiom,
    ( ~ esk13865_4(X1,X2,X3,X4)
    | esk13607_4(X1,X2,X3,X4) ) ).

cnf(i_0_8907,axiom,
    ( esk9024_4(X1,X2,X3,X4)
    | esk8996_4(X1,X2,X3,X4) ) ).

cnf(i_0_8908,axiom,
    ( ~ esk16589_4(X1,X2,X3,X4)
    | esk16559_4(X1,X2,X3,X4) ) ).

cnf(i_0_8909,axiom,
    ( ~ esk10994_4(X1,X2,X3,X4)
    | ~ esk11107_4(X1,X2,X3,X4)
    | ~ esk11022_4(X1,X2,X3,X4) ) ).

cnf(i_0_8910,axiom,
    ( esk10828_4(X1,X2,X3,X4)
    | esk10783_4(X1,X2,X3,X4) ) ).

cnf(i_0_8911,axiom,
    ( esk8230_4(X1,X2,X3,X4)
    | ~ esk8149_4(X1,X2,X3,X4) ) ).

cnf(i_0_8912,axiom,
    ( esk6716_4(X1,X2,X3,X4)
    | esk6715_4(X1,X2,X3,X4) ) ).

cnf(i_0_8913,axiom,
    ( ~ esk13277_4(X1,X2,X3,X4)
    | esk13276_4(X1,X2,X3,X4) ) ).

cnf(i_0_8914,axiom,
    ( ~ esk8551_4(X1,X2,X3,X4)
    | ~ esk8532_4(X1,X2,X3,X4)
    | ~ esk8480_4(X1,X2,X3,X4) ) ).

cnf(i_0_8915,axiom,
    ( ~ esk6311_4(X1,X2,X3,X4)
    | esk6268_4(X1,X2,X3,X4) ) ).

cnf(i_0_8916,axiom,
    ( ~ esk3115_4(X1,X2,X3,X4)
    | ~ esk3117_4(X1,X2,X3,X4) ) ).

cnf(i_0_8917,axiom,
    ( ~ esk15361_4(X1,X2,X3,X4)
    | ~ esk15368_4(X1,X2,X3,X4)
    | ~ esk15401_4(X1,X2,X3,X4) ) ).

cnf(i_0_8918,axiom,
    ( ~ esk8115_4(X1,X2,X3,X4)
    | ~ esk8217_4(X1,X2,X3,X4)
    | esk8097_4(X1,X2,X3,X4) ) ).

cnf(i_0_8919,axiom,
    ( ~ esk7440_4(X1,X2,X3,X4)
    | ~ esk7407_4(X1,X2,X3,X4)
    | ~ esk7394_4(X1,X2,X3,X4) ) ).

cnf(i_0_8920,axiom,
    ( ~ esk9698_4(X1,X2,X3,X4)
    | esk9758_4(X1,X2,X3,X4) ) ).

cnf(i_0_8921,axiom,
    ( esk11518_4(X1,X2,X3,X4)
    | esk11630_4(X1,X2,X3,X4) ) ).

cnf(i_0_8922,axiom,
    ( ~ esk16401_4(X1,X2,X3,X4)
    | ~ esk16391_4(X1,X2,X3,X4)
    | ~ esk16513_4(X1,X2,X3,X4) ) ).

cnf(i_0_8923,axiom,
    ( ~ esk14309_4(X1,X2,X3,X4)
    | esk14287_4(X1,X2,X3,X4) ) ).

cnf(i_0_8924,axiom,
    ( ~ esk7386_4(X1,X2,X3,X4)
    | esk7443_4(X1,X2,X3,X4) ) ).

cnf(i_0_8925,axiom,
    ( ~ esk6860_4(X1,X2,X3,X4)
    | ~ esk6959_4(X1,X2,X3,X4) ) ).

cnf(i_0_8926,axiom,
    ( esk2298_4(X1,X2,X3,X4)
    | esk2384_4(X1,X2,X3,X4) ) ).

cnf(i_0_8927,axiom,
    ( ~ esk12741_4(X1,X2,X3,X4)
    | esk12744_4(X1,X2,X3,X4) ) ).

cnf(i_0_8928,axiom,
    ( ~ esk9574_4(X1,X2,X3,X4)
    | ~ esk9462_4(X1,X2,X3,X4)
    | ~ esk9452_4(X1,X2,X3,X4) ) ).

cnf(i_0_8929,axiom,
    ( esk11461_4(X1,X2,X3,X4)
    | ~ esk11203_4(X1,X2,X3,X4) ) ).

cnf(i_0_8930,axiom,
    ( ~ esk6432_4(X1,X2,X3,X4)
    | ~ esk6447_4(X1,X2,X3,X4) ) ).

cnf(i_0_8931,axiom,
    ( ~ esk10796_4(X1,X2,X3,X4)
    | esk11054_4(X1,X2,X3,X4) ) ).

cnf(i_0_8932,axiom,
    ( esk16692_4(X1,X2,X3,X4)
    | ~ esk16590_4(X1,X2,X3,X4) ) ).

cnf(i_0_8933,axiom,
    ( ~ esk12031_4(X1,X2,X3,X4)
    | ~ esk12032_4(X1,X2,X3,X4)
    | ~ esk12015_4(X1,X2,X3,X4) ) ).

cnf(i_0_8934,axiom,
    ( ~ esk15961_4(X1,X2,X3,X4)
    | ~ esk15986_4(X1,X2,X3,X4)
    | ~ esk15935_4(X1,X2,X3,X4) ) ).

cnf(i_0_8935,axiom,
    ( esk16642_4(X1,X2,X3,X4)
    | esk16656_4(X1,X2,X3,X4) ) ).

cnf(i_0_8936,axiom,
    ( ~ esk5055_4(X1,X2,X3,X4)
    | esk5054_4(X1,X2,X3,X4)
    | esk5059_4(X1,X2,X3,X4) ) ).

cnf(i_0_8937,axiom,
    ( esk12068_4(X1,X2,X3,X4)
    | ~ esk11810_4(X1,X2,X3,X4) ) ).

cnf(i_0_8938,axiom,
    ( esk6072_4(X1,X2,X3,X4)
    | esk6073_4(X1,X2,X3,X4)
    | esk6067_4(X1,X2,X3,X4) ) ).

cnf(i_0_8939,axiom,
    ( ~ esk8097_4(X1,X2,X3,X4)
    | esk8115_4(X1,X2,X3,X4) ) ).

cnf(i_0_8940,axiom,
    ( ~ esk9410_4(X1,X2,X3,X4)
    | ~ esk9411_4(X1,X2,X3,X4) ) ).

cnf(i_0_8941,axiom,
    ( esk10566_4(X1,X2,X3,X4)
    | esk10567_4(X1,X2,X3,X4)
    | esk10565_4(X1,X2,X3,X4) ) ).

cnf(i_0_8942,axiom,
    ( esk15644_4(X1,X2,X3,X4)
    | esk15606_4(X1,X2,X3,X4) ) ).

cnf(i_0_8943,axiom,
    ( ~ esk6218_4(X1,X2,X3,X4)
    | esk6197_4(X1,X2,X3,X4)
    | esk6196_4(X1,X2,X3,X4) ) ).

cnf(i_0_8944,axiom,
    ( ~ esk14298_4(X1,X2,X3,X4)
    | ~ esk14296_4(X1,X2,X3,X4) ) ).

cnf(i_0_8945,axiom,
    ( ~ esk12958_4(X1,X2,X3,X4)
    | esk12979_4(X1,X2,X3,X4) ) ).

cnf(i_0_8946,axiom,
    ( ~ esk6602_4(X1,X2,X3,X4)
    | esk6600_4(X1,X2,X3,X4) ) ).

cnf(i_0_8947,axiom,
    ( ~ esk12539_4(X1,X2,X3,X4)
    | ~ esk12532_4(X1,X2,X3,X4)
    | ~ esk12540_4(X1,X2,X3,X4) ) ).

cnf(i_0_8948,axiom,
    ( esk12466_4(X1,X2,X3,X4)
    | ~ esk12586_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_8949,axiom,
    ( esk6590_4(X1,X2,X3,X4)
    | ~ esk6584_4(X1,X2,X3,X4) ) ).

cnf(i_0_8950,axiom,
    ( esk8200_4(X1,X2,X3,X4)
    | ~ esk8458_4(X1,X2,X3,X4) ) ).

cnf(i_0_8951,axiom,
    ( ~ p(X1)
    | p(X4)
    | p(X3)
    | ~ p(X2)
    | esk225_0
    | ~ esk16701_4(X1,X2,X3,X4) ) ).

cnf(i_0_8952,axiom,
    ( esk5852_4(X1,X2,X3,X4)
    | esk5865_4(X1,X2,X3,X4) ) ).

cnf(i_0_8953,axiom,
    ( esk10415_4(X1,X2,X3,X4)
    | ~ esk10428_4(X1,X2,X3,X4)
    | ~ esk10540_4(X1,X2,X3,X4) ) ).

cnf(i_0_8954,axiom,
    ( ~ esk16694_4(X1,X2,X3,X4)
    | ~ esk16596_4(X1,X2,X3,X4)
    | esk16576_4(X1,X2,X3,X4) ) ).

cnf(i_0_8955,axiom,
    ( ~ esk4773_4(X1,X2,X3,X4)
    | ~ esk4775_4(X1,X2,X3,X4) ) ).

cnf(i_0_8956,axiom,
    ( esk9799_4(X1,X2,X3,X4)
    | ~ esk9806_4(X1,X2,X3,X4)
    | esk9755_4(X1,X2,X3,X4) ) ).

cnf(i_0_8957,axiom,
    ( ~ esk3026_4(X1,X2,X3,X4)
    | ~ esk2971_4(X1,X2,X3,X4) ) ).

cnf(i_0_8958,axiom,
    ( ~ esk3885_4(X1,X2,X3,X4)
    | ~ esk3884_4(X1,X2,X3,X4) ) ).

cnf(i_0_8959,axiom,
    ( ~ esk14682_4(X1,X2,X3,X4)
    | ~ esk14681_4(X1,X2,X3,X4) ) ).

cnf(i_0_8960,axiom,
    ( ~ esk9445_4(X1,X2,X3,X4)
    | ~ esk9462_4(X1,X2,X3,X4)
    | ~ esk9461_4(X1,X2,X3,X4) ) ).

cnf(i_0_8961,axiom,
    ( esk15864_4(X1,X2,X3,X4)
    | esk15899_4(X1,X2,X3,X4) ) ).

cnf(i_0_8962,axiom,
    ( esk12014_4(X1,X2,X3,X4)
    | esk12034_4(X1,X2,X3,X4) ) ).

cnf(i_0_8963,axiom,
    ( ~ esk12849_4(X1,X2,X3,X4)
    | ~ esk12920_4(X1,X2,X3,X4)
    | ~ esk12901_4(X1,X2,X3,X4) ) ).

cnf(i_0_8964,axiom,
    ( esk13560_4(X1,X2,X3,X4)
    | esk13567_4(X1,X2,X3,X4) ) ).

cnf(i_0_8965,axiom,
    ( esk8189_4(X1,X2,X3,X4)
    | esk8274_4(X1,X2,X3,X4) ) ).

cnf(i_0_8966,axiom,
    ( ~ esk5173_4(X1,X2,X3,X4)
    | ~ esk5171_4(X1,X2,X3,X4) ) ).

cnf(i_0_8967,axiom,
    ( ~ esk15567_4(X1,X2,X3,X4)
    | ~ esk15544_4(X1,X2,X3,X4) ) ).

cnf(i_0_8968,axiom,
    ( ~ esk16338_4(X1,X2,X3,X4)
    | esk16458_4(X1,X2,X3,X4) ) ).

cnf(i_0_8969,axiom,
    ( ~ esk6747_4(X1,X2,X3,X4)
    | ~ esk6635_4(X1,X2,X3,X4)
    | ~ esk6625_4(X1,X2,X3,X4) ) ).

cnf(i_0_8970,axiom,
    ( esk12020_4(X1,X2,X3,X4)
    | esk12047_4(X1,X2,X3,X4) ) ).

cnf(i_0_8971,axiom,
    ( ~ esk2195_4(X1,X2,X3,X4)
    | esk2204_4(X1,X2,X3,X4) ) ).

cnf(i_0_8972,axiom,
    ( ~ esk14829_4(X1,X2,X3,X4)
    | ~ esk14926_4(X1,X2,X3,X4) ) ).

cnf(i_0_8973,axiom,
    ( ~ esk8763_4(X1,X2,X3,X4)
    | ~ esk8745_4(X1,X2,X3,X4)
    | ~ esk8743_4(X1,X2,X3,X4) ) ).

cnf(i_0_8974,axiom,
    ( esk14529_4(X1,X2,X3,X4)
    | ~ esk14540_4(X1,X2,X3,X4)
    | ~ esk14626_4(X1,X2,X3,X4) ) ).

cnf(i_0_8975,axiom,
    ( esk539_4(X1,X2,X3,X4)
    | esk519_4(X1,X2,X3,X4) ) ).

cnf(i_0_8976,axiom,
    ( ~ esk7776_4(X1,X2,X3,X4)
    | esk7777_4(X1,X2,X3,X4) ) ).

cnf(i_0_8977,axiom,
    ( ~ esk15666_4(X1,X2,X3,X4)
    | esk15408_4(X1,X2,X3,X4) ) ).

cnf(i_0_8978,axiom,
    ( ~ esk4053_4(X1,X2,X3,X4)
    | ~ esk4070_4(X1,X2,X3,X4)
    | ~ esk4103_4(X1,X2,X3,X4) ) ).

cnf(i_0_8979,axiom,
    ( esk13340_4(X1,X2,X3,X4)
    | ~ esk13304_4(X1,X2,X3,X4) ) ).

cnf(i_0_8980,axiom,
    ( esk15193_4(X1,X2,X3,X4)
    | ~ esk15158_4(X1,X2,X3,X4)
    | esk15212_4(X1,X2,X3,X4) ) ).

cnf(i_0_8981,axiom,
    ( ~ esk4397_4(X1,X2,X3,X4)
    | ~ esk4399_4(X1,X2,X3,X4) ) ).

cnf(i_0_8982,axiom,
    ( esk944_4(X1,X2,X3,X4)
    | ~ esk924_4(X1,X2,X3,X4) ) ).

cnf(i_0_8983,axiom,
    ( ~ esk10998_4(X1,X2,X3,X4)
    | ~ esk10997_4(X1,X2,X3,X4)
    | ~ esk10990_4(X1,X2,X3,X4) ) ).

cnf(i_0_8984,axiom,
    ( ~ esk415_4(X1,X2,X3,X4)
    | ~ esk416_4(X1,X2,X3,X4) ) ).

cnf(i_0_8985,axiom,
    ( ~ esk1039_4(X1,X2,X3,X4)
    | esk1040_4(X1,X2,X3,X4) ) ).

cnf(i_0_8986,axiom,
    ( ~ esk14528_4(X1,X2,X3,X4)
    | esk14493_4(X1,X2,X3,X4) ) ).

cnf(i_0_8987,axiom,
    ( ~ esk7180_4(X1,X2,X3,X4)
    | esk7132_4(X1,X2,X3,X4) ) ).

cnf(i_0_8988,axiom,
    ( esk14348_4(X1,X2,X3,X4)
    | esk14326_4(X1,X2,X3,X4) ) ).

cnf(i_0_8989,axiom,
    ( esk16689_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X4)
    | ~ esk124_0
    | p(X1)
    | p(X3) ) ).

cnf(i_0_8990,axiom,
    ( ~ esk5326_4(X1,X2,X3,X4)
    | ~ esk5363_4(X1,X2,X3,X4)
    | ~ esk5364_4(X1,X2,X3,X4) ) ).

cnf(i_0_8991,axiom,
    ( esk13512_4(X1,X2,X3,X4)
    | ~ esk13506_4(X1,X2,X3,X4) ) ).

cnf(i_0_8992,axiom,
    ( ~ esk4442_4(X1,X2,X3,X4)
    | ~ esk4420_4(X1,X2,X3,X4) ) ).

cnf(i_0_8993,axiom,
    ( esk3564_4(X1,X2,X3,X4)
    | esk3597_4(X1,X2,X3,X4) ) ).

cnf(i_0_8994,axiom,
    ( p(X4)
    | ~ esk1_0
    | p(X3)
    | p(X2)
    | p(X1)
    | esk495_4(X1,X2,X3,X4) ) ).

cnf(i_0_8995,axiom,
    ( ~ esk16198_4(X1,X2,X3,X4)
    | esk15940_4(X1,X2,X3,X4) ) ).

cnf(i_0_8996,axiom,
    ( ~ esk12879_4(X1,X2,X3,X4)
    | ~ esk12877_4(X1,X2,X3,X4)
    | ~ esk12849_4(X1,X2,X3,X4)
    | ~ esk12851_4(X1,X2,X3,X4) ) ).

cnf(i_0_8997,axiom,
    ( ~ esk6326_4(X1,X2,X3,X4)
    | esk6332_4(X1,X2,X3,X4) ) ).

cnf(i_0_8998,axiom,
    ( ~ esk9442_4(X1,X2,X3,X4)
    | ~ esk9468_4(X1,X2,X3,X4)
    | ~ esk9467_4(X1,X2,X3,X4) ) ).

cnf(i_0_8999,axiom,
    ( esk4341_4(X1,X2,X3,X4)
    | esk4374_4(X1,X2,X3,X4) ) ).

cnf(i_0_9000,axiom,
    ( esk9462_4(X1,X2,X3,X4)
    | esk9445_4(X1,X2,X3,X4) ) ).

cnf(i_0_9001,axiom,
    ( ~ esk1000_4(X1,X2,X3,X4)
    | ~ esk954_4(X1,X2,X3,X4)
    | ~ esk1001_4(X1,X2,X3,X4) ) ).

cnf(i_0_9002,axiom,
    ( esk4604_4(X1,X2,X3,X4)
    | ~ esk4565_4(X1,X2,X3,X4) ) ).

cnf(i_0_9003,axiom,
    ( esk4667_4(X1,X2,X3,X4)
    | esk4649_4(X1,X2,X3,X4) ) ).

cnf(i_0_9004,axiom,
    ( ~ esk16725_4(X1,X2,X3,X4)
    | esk16467_4(X1,X2,X3,X4) ) ).

cnf(i_0_9005,axiom,
    ( ~ esk13276_4(X1,X2,X3,X4)
    | ~ esk13275_4(X1,X2,X3,X4)
    | esk13277_4(X1,X2,X3,X4) ) ).

cnf(i_0_9006,axiom,
    ( esk4337_4(X1,X2,X3,X4)
    | esk4370_4(X1,X2,X3,X4) ) ).

cnf(i_0_9007,axiom,
    ( esk2059_4(X1,X2,X3,X4)
    | ~ esk2111_4(X1,X2,X3,X4)
    | esk2081_4(X1,X2,X3,X4) ) ).

cnf(i_0_9008,axiom,
    ( ~ esk14377_4(X1,X2,X3,X4)
    | ~ esk14428_4(X1,X2,X3,X4)
    | ~ esk14457_4(X1,X2,X3,X4) ) ).

cnf(i_0_9009,axiom,
    ( esk10476_4(X1,X2,X3,X4)
    | esk10484_4(X1,X2,X3,X4) ) ).

cnf(i_0_9010,axiom,
    ( esk7524_4(X1,X2,X3,X4)
    | esk7438_4(X1,X2,X3,X4) ) ).

cnf(i_0_9011,axiom,
    ( ~ esk9020_4(X1,X2,X3,X4)
    | esk9050_4(X1,X2,X3,X4) ) ).

cnf(i_0_9012,axiom,
    ( ~ esk12327_4(X1,X2,X3,X4)
    | ~ esk12408_4(X1,X2,X3,X4) ) ).

cnf(i_0_9013,axiom,
    ( ~ esk1517_4(X1,X2,X3,X4)
    | ~ esk1516_4(X1,X2,X3,X4)
    | ~ esk1467_4(X1,X2,X3,X4) ) ).

cnf(i_0_9014,axiom,
    ( ~ esk11098_4(X1,X2,X3,X4)
    | esk11099_4(X1,X2,X3,X4)
    | ~ esk11097_4(X1,X2,X3,X4) ) ).

cnf(i_0_9015,axiom,
    ( ~ esk9478_4(X1,X2,X3,X4)
    | ~ esk9477_4(X1,X2,X3,X4)
    | ~ esk9437_4(X1,X2,X3,X4) ) ).

cnf(i_0_9016,axiom,
    ( esk9448_4(X1,X2,X3,X4)
    | esk9456_4(X1,X2,X3,X4) ) ).

cnf(i_0_9017,axiom,
    ( esk995_4(X1,X2,X3,X4)
    | esk1101_4(X1,X2,X3,X4) ) ).

cnf(i_0_9018,axiom,
    ( ~ esk10717_4(X1,X2,X3,X4)
    | ~ esk10697_4(X1,X2,X3,X4)
    | esk10681_4(X1,X2,X3,X4) ) ).

cnf(i_0_9019,axiom,
    ( esk11110_4(X1,X2,X3,X4)
    | ~ esk11056_4(X1,X2,X3,X4) ) ).

cnf(i_0_9020,axiom,
    ( esk6386_4(X1,X2,X3,X4)
    | esk6368_4(X1,X2,X3,X4) ) ).

cnf(i_0_9021,axiom,
    ( esk4310_4(X1,X2,X3,X4)
    | esk4313_4(X1,X2,X3,X4) ) ).

cnf(i_0_9022,axiom,
    ( ~ esk5400_4(X1,X2,X3,X4)
    | ~ esk5288_4(X1,X2,X3,X4)
    | esk5275_4(X1,X2,X3,X4) ) ).

cnf(i_0_9023,axiom,
    ( esk10539_4(X1,X2,X3,X4)
    | ~ esk10797_4(X1,X2,X3,X4) ) ).

cnf(i_0_9024,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12203_4(X1,X2,X3,X4)
    | ~ esk12230_4(X1,X2,X3,X4) ) ).

cnf(i_0_9025,axiom,
    ( esk16339_4(X1,X2,X3,X4)
    | ~ esk16331_4(X1,X2,X3,X4) ) ).

cnf(i_0_9026,axiom,
    ( esk7764_4(X1,X2,X3,X4)
    | ~ esk7766_4(X1,X2,X3,X4) ) ).

cnf(i_0_9027,axiom,
    ( esk8328_4(X1,X2,X3,X4)
    | ~ esk8357_4(X1,X2,X3,X4) ) ).

cnf(i_0_9028,axiom,
    ( ~ esk1604_4(X1,X2,X3,X4)
    | ~ esk1581_4(X1,X2,X3,X4)
    | ~ esk1521_4(X1,X2,X3,X4) ) ).

cnf(i_0_9029,axiom,
    ( ~ esk10714_4(X1,X2,X3,X4)
    | esk10712_4(X1,X2,X3,X4) ) ).

cnf(i_0_9030,axiom,
    ( esk1978_4(X1,X2,X3,X4)
    | ~ esk1926_4(X1,X2,X3,X4) ) ).

cnf(i_0_9031,axiom,
    ( esk8111_4(X1,X2,X3,X4)
    | ~ esk8127_4(X1,X2,X3,X4)
    | ~ esk8147_4(X1,X2,X3,X4) ) ).

cnf(i_0_9032,axiom,
    ( ~ esk14137_4(X1,X2,X3,X4)
    | esk14395_4(X1,X2,X3,X4) ) ).

cnf(i_0_9033,axiom,
    ( ~ esk15661_4(X1,X2,X3,X4)
    | esk15613_4(X1,X2,X3,X4) ) ).

cnf(i_0_9034,axiom,
    ( ~ esk5336_4(X1,X2,X3,X4)
    | esk5375_4(X1,X2,X3,X4) ) ).

cnf(i_0_9035,axiom,
    ( ~ esk7978_4(X1,X2,X3,X4)
    | esk7976_4(X1,X2,X3,X4) ) ).

cnf(i_0_9036,axiom,
    ( esk15684_4(X1,X2,X3,X4)
    | ~ esk15563_4(X1,X2,X3,X4) ) ).

cnf(i_0_9037,axiom,
    ( esk9378_4(X1,X2,X3,X4)
    | ~ esk9398_4(X1,X2,X3,X4) ) ).

cnf(i_0_9038,axiom,
    ( ~ esk6660_4(X1,X2,X3,X4)
    | esk6621_4(X1,X2,X3,X4) ) ).

cnf(i_0_9039,axiom,
    ( esk16744_4(X1,X2,X3,X4)
    | esk16743_4(X1,X2,X3,X4)
    | esk16742_4(X1,X2,X3,X4) ) ).

cnf(i_0_9040,axiom,
    ( ~ esk11728_4(X1,X2,X3,X4)
    | ~ esk11726_4(X1,X2,X3,X4) ) ).

cnf(i_0_9041,axiom,
    ( ~ esk9161_4(X1,X2,X3,X4)
    | esk9152_4(X1,X2,X3,X4) ) ).

cnf(i_0_9042,axiom,
    ( esk4113_4(X1,X2,X3,X4)
    | esk4141_4(X1,X2,X3,X4) ) ).

cnf(i_0_9043,axiom,
    ( ~ esk15082_4(X1,X2,X3,X4)
    | ~ esk15083_4(X1,X2,X3,X4) ) ).

cnf(i_0_9044,axiom,
    ( esk1184_4(X1,X2,X3,X4)
    | esk1183_4(X1,X2,X3,X4) ) ).

cnf(i_0_9045,axiom,
    ( ~ esk5173_4(X1,X2,X3,X4)
    | ~ esk5212_4(X1,X2,X3,X4) ) ).

cnf(i_0_9046,axiom,
    ( ~ esk6903_4(X1,X2,X3,X4)
    | ~ esk6936_4(X1,X2,X3,X4)
    | ~ esk6880_4(X1,X2,X3,X4) ) ).

cnf(i_0_9047,axiom,
    ( ~ esk13870_4(X1,X2,X3,X4)
    | esk14128_4(X1,X2,X3,X4) ) ).

cnf(i_0_9048,axiom,
    ( esk2518_4(X1,X2,X3,X4)
    | esk2511_4(X1,X2,X3,X4) ) ).

cnf(i_0_9049,axiom,
    ( esk5943_4(X1,X2,X3,X4)
    | esk5944_4(X1,X2,X3,X4)
    | esk5983_4(X1,X2,X3,X4)
    | esk5942_4(X1,X2,X3,X4) ) ).

cnf(i_0_9050,axiom,
    ( ~ esk11171_4(X1,X2,X3,X4)
    | ~ esk11201_4(X1,X2,X3,X4) ) ).

cnf(i_0_9051,axiom,
    ( ~ esk10390_4(X1,X2,X3,X4)
    | esk10422_4(X1,X2,X3,X4) ) ).

cnf(i_0_9052,axiom,
    ( esk7118_4(X1,X2,X3,X4)
    | esk7209_4(X1,X2,X3,X4) ) ).

cnf(i_0_9053,axiom,
    ( esk3926_4(X1,X2,X3,X4)
    | esk3919_4(X1,X2,X3,X4)
    | ~ esk3838_4(X1,X2,X3,X4) ) ).

cnf(i_0_9054,axiom,
    ( esk5288_4(X1,X2,X3,X4)
    | ~ esk5274_4(X1,X2,X3,X4) ) ).

cnf(i_0_9055,axiom,
    ( esk13075_4(X1,X2,X3,X4)
    | esk13108_4(X1,X2,X3,X4) ) ).

cnf(i_0_9056,axiom,
    ( ~ esk8923_4(X1,X2,X3,X4)
    | esk8995_4(X1,X2,X3,X4) ) ).

cnf(i_0_9057,axiom,
    ( ~ esk2983_4(X1,X2,X3,X4)
    | ~ esk2988_4(X1,X2,X3,X4) ) ).

cnf(i_0_9058,axiom,
    ( ~ esk14654_4(X1,X2,X3,X4)
    | ~ esk14590_4(X1,X2,X3,X4)
    | ~ esk14621_4(X1,X2,X3,X4) ) ).

cnf(i_0_9059,axiom,
    ( esk481_4(X1,X2,X3,X4)
    | esk443_4(X1,X2,X3,X4) ) ).

cnf(i_0_9060,axiom,
    ( ~ esk2970_4(X1,X2,X3,X4)
    | esk2975_4(X1,X2,X3,X4) ) ).

cnf(i_0_9061,axiom,
    ( esk13162_4(X1,X2,X3,X4)
    | ~ esk13163_4(X1,X2,X3,X4) ) ).

cnf(i_0_9062,axiom,
    ( esk15350_4(X1,X2,X3,X4)
    | esk15385_4(X1,X2,X3,X4) ) ).

cnf(i_0_9063,axiom,
    ( esk10600_4(X1,X2,X3,X4)
    | ~ esk10575_4(X1,X2,X3,X4)
    | esk10574_4(X1,X2,X3,X4) ) ).

cnf(i_0_9064,axiom,
    ( esk2557_4(X1,X2,X3,X4)
    | esk2605_4(X1,X2,X3,X4) ) ).

cnf(i_0_9065,axiom,
    ( esk12920_4(X1,X2,X3,X4)
    | ~ esk12849_4(X1,X2,X3,X4)
    | esk12901_4(X1,X2,X3,X4) ) ).

cnf(i_0_9066,axiom,
    ( esk5727_4(X1,X2,X3,X4)
    | esk5621_4(X1,X2,X3,X4) ) ).

cnf(i_0_9067,axiom,
    ( ~ esk15777_4(X1,X2,X3,X4)
    | esk15820_4(X1,X2,X3,X4) ) ).

cnf(i_0_9068,axiom,
    ( ~ esk10574_4(X1,X2,X3,X4)
    | ~ esk10575_4(X1,X2,X3,X4)
    | ~ esk10600_4(X1,X2,X3,X4) ) ).

cnf(i_0_9069,axiom,
    ( ~ esk4801_4(X1,X2,X3,X4)
    | esk5059_4(X1,X2,X3,X4) ) ).

cnf(i_0_9070,axiom,
    ( esk15864_4(X1,X2,X3,X4)
    | esk15898_4(X1,X2,X3,X4) ) ).

cnf(i_0_9071,axiom,
    ( esk8148_4(X1,X2,X3,X4)
    | esk8237_4(X1,X2,X3,X4) ) ).

cnf(i_0_9072,axiom,
    ( ~ esk12825_4(X1,X2,X3,X4)
    | ~ esk12872_4(X1,X2,X3,X4)
    | ~ esk12793_4(X1,X2,X3,X4) ) ).

cnf(i_0_9073,axiom,
    ( ~ esk7899_4(X1,X2,X3,X4)
    | esk7959_4(X1,X2,X3,X4) ) ).

cnf(i_0_9074,axiom,
    ( ~ esk3545_4(X1,X2,X3,X4)
    | ~ esk3541_4(X1,X2,X3,X4)
    | ~ esk3660_4(X1,X2,X3,X4) ) ).

cnf(i_0_9075,axiom,
    ( ~ esk7782_4(X1,X2,X3,X4)
    | ~ esk7743_4(X1,X2,X3,X4) ) ).

cnf(i_0_9076,axiom,
    ( ~ esk6064_4(X1,X2,X3,X4)
    | ~ esk6082_4(X1,X2,X3,X4) ) ).

cnf(i_0_9077,axiom,
    ( ~ esk10303_4(X1,X2,X3,X4)
    | ~ esk10312_4(X1,X2,X3,X4) ) ).

cnf(i_0_9078,axiom,
    ( esk9875_4(X1,X2,X3,X4)
    | ~ esk9894_4(X1,X2,X3,X4) ) ).

cnf(i_0_9079,axiom,
    ( ~ esk2768_4(X1,X2,X3,X4)
    | ~ esk2801_4(X1,X2,X3,X4)
    | ~ esk2834_4(X1,X2,X3,X4) ) ).

cnf(i_0_9080,axiom,
    ( esk9250_4(X1,X2,X3,X4)
    | ~ esk9508_4(X1,X2,X3,X4) ) ).

cnf(i_0_9081,axiom,
    ( esk12608_4(X1,X2,X3,X4)
    | esk12483_4(X1,X2,X3,X4) ) ).

cnf(i_0_9082,axiom,
    ( esk2483_4(X1,X2,X3,X4)
    | ~ esk2467_4(X1,X2,X3,X4) ) ).

cnf(i_0_9083,axiom,
    ( esk3027_4(X1,X2,X3,X4)
    | esk3049_4(X1,X2,X3,X4) ) ).

cnf(i_0_9084,axiom,
    ( ~ esk8909_4(X1,X2,X3,X4)
    | esk8910_4(X1,X2,X3,X4) ) ).

cnf(i_0_9085,axiom,
    ( esk2461_4(X1,X2,X3,X4)
    | ~ esk2447_4(X1,X2,X3,X4) ) ).

cnf(i_0_9086,axiom,
    ( ~ esk13798_4(X1,X2,X3,X4)
    | esk13794_4(X1,X2,X3,X4) ) ).

cnf(i_0_9087,axiom,
    ( esk9452_4(X1,X2,X3,X4)
    | esk9462_4(X1,X2,X3,X4) ) ).

cnf(i_0_9088,axiom,
    ( esk4862_4(X1,X2,X3,X4)
    | esk4945_4(X1,X2,X3,X4)
    | ~ esk4922_4(X1,X2,X3,X4) ) ).

cnf(i_0_9089,axiom,
    ( ~ esk9272_4(X1,X2,X3,X4)
    | ~ esk9175_4(X1,X2,X3,X4) ) ).

cnf(i_0_9090,axiom,
    ( ~ esk6866_4(X1,X2,X3,X4)
    | esk6941_4(X1,X2,X3,X4) ) ).

cnf(i_0_9091,axiom,
    ( ~ esk16001_4(X1,X2,X3,X4)
    | esk16003_4(X1,X2,X3,X4)
    | ~ esk16002_4(X1,X2,X3,X4) ) ).

cnf(i_0_9092,axiom,
    ( esk7665_4(X1,X2,X3,X4)
    | esk7645_4(X1,X2,X3,X4) ) ).

cnf(i_0_9093,axiom,
    ( ~ esk8371_4(X1,X2,X3,X4)
    | ~ esk8373_4(X1,X2,X3,X4) ) ).

cnf(i_0_9094,axiom,
    ( ~ esk3732_4(X1,X2,X3,X4)
    | esk3701_4(X1,X2,X3,X4) ) ).

cnf(i_0_9095,axiom,
    ( ~ esk13375_4(X1,X2,X3,X4)
    | esk13374_4(X1,X2,X3,X4) ) ).

cnf(i_0_9096,axiom,
    ( ~ esk14782_4(X1,X2,X3,X4)
    | esk14905_4(X1,X2,X3,X4) ) ).

cnf(i_0_9097,axiom,
    ( ~ esk10281_4(X1,X2,X3,X4)
    | esk10023_4(X1,X2,X3,X4) ) ).

cnf(i_0_9098,axiom,
    ( esk6330_4(X1,X2,X3,X4)
    | esk6321_4(X1,X2,X3,X4) ) ).

cnf(i_0_9099,axiom,
    ( ~ esk4633_4(X1,X2,X3,X4)
    | esk4684_4(X1,X2,X3,X4) ) ).

cnf(i_0_9100,axiom,
    ( ~ esk10238_4(X1,X2,X3,X4)
    | ~ esk10271_4(X1,X2,X3,X4)
    | ~ esk10221_4(X1,X2,X3,X4) ) ).

cnf(i_0_9101,axiom,
    ( esk402_4(X1,X2,X3,X4)
    | ~ esk403_4(X1,X2,X3,X4) ) ).

cnf(i_0_9102,axiom,
    ( esk1712_4(X1,X2,X3,X4)
    | ~ esk1696_4(X1,X2,X3,X4) ) ).

cnf(i_0_9103,axiom,
    ( ~ esk12584_4(X1,X2,X3,X4)
    | ~ esk12534_4(X1,X2,X3,X4)
    | ~ esk12551_4(X1,X2,X3,X4) ) ).

cnf(i_0_9104,axiom,
    ( ~ esk1174_4(X1,X2,X3,X4)
    | esk1173_4(X1,X2,X3,X4) ) ).

cnf(i_0_9105,axiom,
    ( esk15616_4(X1,X2,X3,X4)
    | ~ esk15655_4(X1,X2,X3,X4) ) ).

cnf(i_0_9106,axiom,
    ( esk11118_4(X1,X2,X3,X4)
    | ~ esk11117_4(X1,X2,X3,X4) ) ).

cnf(i_0_9107,axiom,
    ( esk10496_4(X1,X2,X3,X4)
    | esk10581_4(X1,X2,X3,X4) ) ).

cnf(i_0_9108,axiom,
    ( ~ esk4517_4(X1,X2,X3,X4)
    | ~ esk4617_4(X1,X2,X3,X4)
    | esk4498_4(X1,X2,X3,X4) ) ).

cnf(i_0_9109,axiom,
    ( ~ esk16248_4(X1,X2,X3,X4)
    | esk16249_4(X1,X2,X3,X4) ) ).

cnf(i_0_9110,axiom,
    ( ~ esk15703_4(X1,X2,X3,X4)
    | ~ esk15680_4(X1,X2,X3,X4) ) ).

cnf(i_0_9111,axiom,
    ( esk14159_4(X1,X2,X3,X4)
    | esk14196_4(X1,X2,X3,X4)
    | ~ esk14112_4(X1,X2,X3,X4) ) ).

cnf(i_0_9112,axiom,
    ( esk2643_4(X1,X2,X3,X4)
    | esk2537_4(X1,X2,X3,X4) ) ).

cnf(i_0_9113,axiom,
    ( p(X4)
    | p(X1)
    | ~ p(X3)
    | ~ esk513_4(X1,X2,X3,X4)
    | p(X2)
    | esk229_0 ) ).

cnf(i_0_9114,axiom,
    ( ~ esk507_4(X1,X2,X3,X4)
    | ~ esk474_4(X1,X2,X3,X4)
    | ~ esk455_4(X1,X2,X3,X4) ) ).

cnf(i_0_9115,axiom,
    ( esk8920_4(X1,X2,X3,X4)
    | esk8969_4(X1,X2,X3,X4) ) ).

cnf(i_0_9116,axiom,
    ( esk1447_4(X1,X2,X3,X4)
    | esk1440_4(X1,X2,X3,X4)
    | ~ esk1454_4(X1,X2,X3,X4) ) ).

cnf(i_0_9117,axiom,
    ( esk9542_4(X1,X2,X3,X4)
    | esk9543_4(X1,X2,X3,X4) ) ).

cnf(i_0_9118,axiom,
    ( esk4849_4(X1,X2,X3,X4)
    | esk4824_4(X1,X2,X3,X4) ) ).

cnf(i_0_9119,axiom,
    ( ~ esk13251_4(X1,X2,X3,X4)
    | ~ esk13306_4(X1,X2,X3,X4) ) ).

cnf(i_0_9120,axiom,
    ( esk8966_4(X1,X2,X3,X4)
    | esk9051_4(X1,X2,X3,X4) ) ).

cnf(i_0_9121,axiom,
    ( ~ esk13064_4(X1,X2,X3,X4)
    | ~ esk13050_4(X1,X2,X3,X4)
    | ~ esk13147_4(X1,X2,X3,X4) ) ).

cnf(i_0_9122,axiom,
    ( ~ esk12478_4(X1,X2,X3,X4)
    | esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_9123,axiom,
    ( ~ esk7137_4(X1,X2,X3,X4)
    | ~ esk7148_4(X1,X2,X3,X4)
    | ~ esk7181_4(X1,X2,X3,X4) ) ).

cnf(i_0_9124,axiom,
    ( ~ esk13010_4(X1,X2,X3,X4)
    | ~ esk13012_4(X1,X2,X3,X4) ) ).

cnf(i_0_9125,axiom,
    ( ~ esk11743_4(X1,X2,X3,X4)
    | ~ esk11765_4(X1,X2,X3,X4) ) ).

cnf(i_0_9126,axiom,
    ( ~ esk12981_4(X1,X2,X3,X4)
    | esk12998_4(X1,X2,X3,X4) ) ).

cnf(i_0_9127,axiom,
    ( ~ esk447_4(X1,X2,X3,X4)
    | esk504_4(X1,X2,X3,X4) ) ).

cnf(i_0_9128,axiom,
    ( esk9562_4(X1,X2,X3,X4)
    | esk9535_4(X1,X2,X3,X4)
    | ~ esk9563_4(X1,X2,X3,X4) ) ).

cnf(i_0_9129,axiom,
    ( ~ esk12261_4(X1,X2,X3,X4)
    | ~ esk12311_4(X1,X2,X3,X4)
    | ~ esk12310_4(X1,X2,X3,X4) ) ).

cnf(i_0_9130,axiom,
    ( esk5631_4(X1,X2,X3,X4)
    | ~ esk5715_4(X1,X2,X3,X4)
    | esk5678_4(X1,X2,X3,X4) ) ).

cnf(i_0_9131,axiom,
    ( esk15086_4(X1,X2,X3,X4)
    | ~ esk15024_4(X1,X2,X3,X4) ) ).

cnf(i_0_9132,axiom,
    ( esk14911_4(X1,X2,X3,X4)
    | esk14963_4(X1,X2,X3,X4) ) ).

cnf(i_0_9133,axiom,
    ( esk9526_4(X1,X2,X3,X4)
    | ~ esk9369_4(X1,X2,X3,X4) ) ).

cnf(i_0_9134,axiom,
    ( ~ esk8766_4(X1,X2,X3,X4)
    | esk8767_4(X1,X2,X3,X4)
    | esk8788_4(X1,X2,X3,X4) ) ).

cnf(i_0_9135,axiom,
    ( ~ esk8640_4(X1,X2,X3,X4)
    | ~ esk8639_4(X1,X2,X3,X4) ) ).

cnf(i_0_9136,axiom,
    ( ~ esk9256_4(X1,X2,X3,X4)
    | esk9178_4(X1,X2,X3,X4) ) ).

cnf(i_0_9137,axiom,
    ( ~ esk14134_4(X1,X2,X3,X4)
    | ~ esk14164_4(X1,X2,X3,X4)
    | ~ esk14136_4(X1,X2,X3,X4)
    | ~ esk14162_4(X1,X2,X3,X4) ) ).

cnf(i_0_9138,axiom,
    ( ~ esk8219_4(X1,X2,X3,X4)
    | ~ esk8115_4(X1,X2,X3,X4)
    | esk8098_4(X1,X2,X3,X4) ) ).

cnf(i_0_9139,axiom,
    ( ~ esk8967_4(X1,X2,X3,X4)
    | ~ esk8921_4(X1,X2,X3,X4)
    | ~ esk8968_4(X1,X2,X3,X4) ) ).

cnf(i_0_9140,axiom,
    ( ~ esk515_4(X1,X2,X3,X4)
    | ~ esk455_4(X1,X2,X3,X4)
    | ~ esk482_4(X1,X2,X3,X4) ) ).

cnf(i_0_9141,axiom,
    ( esk15662_4(X1,X2,X3,X4)
    | esk15713_4(X1,X2,X3,X4)
    | ~ esk15742_4(X1,X2,X3,X4) ) ).

cnf(i_0_9142,axiom,
    ( ~ esk2188_4(X1,X2,X3,X4)
    | esk2161_4(X1,X2,X3,X4) ) ).

cnf(i_0_9143,axiom,
    ( esk8217_4(X1,X2,X3,X4)
    | ~ esk7959_4(X1,X2,X3,X4) ) ).

cnf(i_0_9144,axiom,
    ( esk10720_4(X1,X2,X3,X4)
    | esk10766_4(X1,X2,X3,X4) ) ).

cnf(i_0_9145,axiom,
    ( ~ esk5852_4(X1,X2,X3,X4)
    | ~ esk5857_4(X1,X2,X3,X4)
    | ~ esk5890_4(X1,X2,X3,X4) ) ).

cnf(i_0_9146,axiom,
    ( ~ esk9761_4(X1,X2,X3,X4)
    | esk9640_4(X1,X2,X3,X4)
    | ~ esk9657_4(X1,X2,X3,X4) ) ).

cnf(i_0_9147,axiom,
    ( ~ esk8253_4(X1,X2,X3,X4)
    | ~ esk8254_4(X1,X2,X3,X4) ) ).

cnf(i_0_9148,axiom,
    ( esk16611_4(X1,X2,X3,X4)
    | esk16606_4(X1,X2,X3,X4)
    | ~ esk16612_4(X1,X2,X3,X4) ) ).

cnf(i_0_9149,axiom,
    ( ~ p(X1)
    | esk16703_4(X1,X2,X3,X4)
    | p(X4)
    | p(X3)
    | ~ esk236_0
    | p(X2) ) ).

cnf(i_0_9150,axiom,
    ( esk1485_4(X1,X2,X3,X4)
    | esk1493_4(X1,X2,X3,X4) ) ).

cnf(i_0_9151,axiom,
    ( esk9400_4(X1,X2,X3,X4)
    | ~ esk9392_4(X1,X2,X3,X4) ) ).

cnf(i_0_9152,axiom,
    ( ~ esk2442_4(X1,X2,X3,X4)
    | esk2461_4(X1,X2,X3,X4) ) ).

cnf(i_0_9153,axiom,
    ( esk8393_4(X1,X2,X3,X4)
    | ~ esk8386_4(X1,X2,X3,X4) ) ).

cnf(i_0_9154,axiom,
    ( esk13020_4(X1,X2,X3,X4)
    | ~ esk13018_4(X1,X2,X3,X4)
    | ~ esk13019_4(X1,X2,X3,X4) ) ).

cnf(i_0_9155,axiom,
    ( ~ esk4352_4(X1,X2,X3,X4)
    | esk4440_4(X1,X2,X3,X4)
    | esk4433_4(X1,X2,X3,X4) ) ).

cnf(i_0_9156,axiom,
    ( ~ esk15448_4(X1,X2,X3,X4)
    | ~ esk15417_4(X1,X2,X3,X4) ) ).

cnf(i_0_9157,axiom,
    ( esk12480_4(X1,X2,X3,X4)
    | esk12514_4(X1,X2,X3,X4)
    | esk12534_4(X1,X2,X3,X4) ) ).

cnf(i_0_9158,axiom,
    ( esk13365_4(X1,X2,X3,X4)
    | ~ esk13107_4(X1,X2,X3,X4) ) ).

cnf(i_0_9159,axiom,
    ( esk7706_4(X1,X2,X3,X4)
    | ~ esk7964_4(X1,X2,X3,X4) ) ).

cnf(i_0_9160,axiom,
    ( esk2896_4(X1,X2,X3,X4)
    | esk2782_4(X1,X2,X3,X4) ) ).

cnf(i_0_9161,axiom,
    ( ~ esk4679_4(X1,X2,X3,X4)
    | esk4680_4(X1,X2,X3,X4) ) ).

cnf(i_0_9162,axiom,
    ( esk12576_4(X1,X2,X3,X4)
    | esk12543_4(X1,X2,X3,X4) ) ).

cnf(i_0_9163,axiom,
    ( esk15353_4(X1,X2,X3,X4)
    | esk15378_4(X1,X2,X3,X4) ) ).

cnf(i_0_9164,axiom,
    ( esk8671_4(X1,X2,X3,X4)
    | ~ esk8728_4(X1,X2,X3,X4) ) ).

cnf(i_0_9165,axiom,
    ( ~ esk2749_4(X1,X2,X3,X4)
    | ~ esk2840_4(X1,X2,X3,X4)
    | ~ esk2847_4(X1,X2,X3,X4) ) ).

cnf(i_0_9166,axiom,
    ( esk11605_4(X1,X2,X3,X4)
    | esk11522_4(X1,X2,X3,X4) ) ).

cnf(i_0_9167,axiom,
    ( esk8115_4(X1,X2,X3,X4)
    | ~ esk8103_4(X1,X2,X3,X4) ) ).

cnf(i_0_9168,axiom,
    ( ~ esk6712_4(X1,X2,X3,X4)
    | ~ esk6711_4(X1,X2,X3,X4) ) ).

cnf(i_0_9169,axiom,
    ( esk7185_4(X1,X2,X3,X4)
    | esk7236_4(X1,X2,X3,X4)
    | ~ esk7229_4(X1,X2,X3,X4) ) ).

cnf(i_0_9170,axiom,
    ( esk6161_4(X1,X2,X3,X4)
    | ~ esk6041_4(X1,X2,X3,X4) ) ).

cnf(i_0_9171,axiom,
    ( ~ p(X3)
    | ~ esk13_0
    | esk16600_4(X1,X2,X3,X4)
    | p(X2)
    | p(X4)
    | ~ p(X1) ) ).

cnf(i_0_9172,axiom,
    ( esk3627_4(X1,X2,X3,X4)
    | esk3626_4(X1,X2,X3,X4)
    | esk3628_4(X1,X2,X3,X4) ) ).

cnf(i_0_9173,axiom,
    ( ~ esk6188_4(X1,X2,X3,X4)
    | ~ esk6091_4(X1,X2,X3,X4) ) ).

cnf(i_0_9174,axiom,
    ( esk2590_4(X1,X2,X3,X4)
    | ~ esk2332_4(X1,X2,X3,X4) ) ).

cnf(i_0_9175,axiom,
    ( esk1302_4(X1,X2,X3,X4)
    | ~ esk1145_4(X1,X2,X3,X4) ) ).

cnf(i_0_9176,axiom,
    ( esk7354_4(X1,X2,X3,X4)
    | ~ esk7360_4(X1,X2,X3,X4)
    | esk7359_4(X1,X2,X3,X4) ) ).

cnf(i_0_9177,axiom,
    ( esk2084_4(X1,X2,X3,X4)
    | esk2106_4(X1,X2,X3,X4)
    | ~ esk2085_4(X1,X2,X3,X4) ) ).

cnf(i_0_9178,axiom,
    ( ~ esk2228_4(X1,X2,X3,X4)
    | esk2227_4(X1,X2,X3,X4)
    | esk2232_4(X1,X2,X3,X4) ) ).

cnf(i_0_9179,axiom,
    ( ~ esk5427_4(X1,X2,X3,X4)
    | ~ esk5392_4(X1,X2,X3,X4)
    | ~ esk5428_4(X1,X2,X3,X4) ) ).

cnf(i_0_9180,axiom,
    ( ~ esk9067_4(X1,X2,X3,X4)
    | ~ esk8986_4(X1,X2,X3,X4) ) ).

cnf(i_0_9181,axiom,
    ( esk14206_4(X1,X2,X3,X4)
    | esk14120_4(X1,X2,X3,X4) ) ).

cnf(i_0_9182,axiom,
    ( esk969_4(X1,X2,X3,X4)
    | esk1000_4(X1,X2,X3,X4) ) ).

cnf(i_0_9183,axiom,
    ( ~ esk11046_4(X1,X2,X3,X4)
    | ~ esk10942_4(X1,X2,X3,X4)
    | esk10925_4(X1,X2,X3,X4) ) ).

cnf(i_0_9184,axiom,
    ( esk5137_4(X1,X2,X3,X4)
    | esk5168_4(X1,X2,X3,X4) ) ).

cnf(i_0_9185,axiom,
    ( esk13564_4(X1,X2,X3,X4)
    | esk13563_4(X1,X2,X3,X4)
    | esk13542_4(X1,X2,X3,X4) ) ).

cnf(i_0_9186,axiom,
    ( ~ esk4254_4(X1,X2,X3,X4)
    | esk4260_4(X1,X2,X3,X4) ) ).

cnf(i_0_9187,axiom,
    ( ~ p(X2)
    | ~ esk16695_4(X1,X2,X3,X4)
    | p(X3)
    | ~ p(X4)
    | ~ p(X1)
    | esk181_0 ) ).

cnf(i_0_9188,axiom,
    ( ~ esk9043_4(X1,X2,X3,X4)
    | esk9041_4(X1,X2,X3,X4) ) ).

cnf(i_0_9189,axiom,
    ( ~ esk14937_4(X1,X2,X3,X4)
    | esk14953_4(X1,X2,X3,X4) ) ).

cnf(i_0_9190,axiom,
    ( ~ esk8364_4(X1,X2,X3,X4)
    | esk8464_4(X1,X2,X3,X4) ) ).

cnf(i_0_9191,axiom,
    ( ~ esk4577_4(X1,X2,X3,X4)
    | ~ esk4700_4(X1,X2,X3,X4)
    | ~ esk4569_4(X1,X2,X3,X4) ) ).

cnf(i_0_9192,axiom,
    ( ~ esk13113_4(X1,X2,X3,X4)
    | esk13371_4(X1,X2,X3,X4) ) ).

cnf(i_0_9193,axiom,
    ( esk9219_4(X1,X2,X3,X4)
    | esk9195_4(X1,X2,X3,X4) ) ).

cnf(i_0_9194,axiom,
    ( ~ esk12464_4(X1,X2,X3,X4)
    | esk12582_4(X1,X2,X3,X4) ) ).

cnf(i_0_9195,axiom,
    ( ~ esk16706_4(X1,X2,X3,X4)
    | ~ esk16673_4(X1,X2,X3,X4)
    | ~ esk16646_4(X1,X2,X3,X4) ) ).

cnf(i_0_9196,axiom,
    ( ~ esk6589_4(X1,X2,X3,X4)
    | esk6583_4(X1,X2,X3,X4)
    | esk6588_4(X1,X2,X3,X4) ) ).

cnf(i_0_9197,axiom,
    ( ~ esk1927_4(X1,X2,X3,X4)
    | esk2045_4(X1,X2,X3,X4) ) ).

cnf(i_0_9198,axiom,
    ( ~ esk3225_4(X1,X2,X3,X4)
    | esk3232_4(X1,X2,X3,X4) ) ).

cnf(i_0_9199,axiom,
    ( ~ esk1595_4(X1,X2,X3,X4)
    | esk1596_4(X1,X2,X3,X4) ) ).

cnf(i_0_9200,axiom,
    ( esk9676_4(X1,X2,X3,X4)
    | esk9671_4(X1,X2,X3,X4) ) ).

cnf(i_0_9201,axiom,
    ( esk9788_4(X1,X2,X3,X4)
    | esk9773_4(X1,X2,X3,X4) ) ).

cnf(i_0_9202,axiom,
    ( esk13826_4(X1,X2,X3,X4)
    | esk13816_4(X1,X2,X3,X4) ) ).

cnf(i_0_9203,axiom,
    ( ~ esk15392_4(X1,X2,X3,X4)
    | ~ esk15425_4(X1,X2,X3,X4)
    | ~ esk15361_4(X1,X2,X3,X4) ) ).

cnf(i_0_9204,axiom,
    ( esk8907_4(X1,X2,X3,X4)
    | ~ esk8893_4(X1,X2,X3,X4) ) ).

cnf(i_0_9205,axiom,
    ( ~ esk4889_4(X1,X2,X3,X4)
    | esk5147_4(X1,X2,X3,X4) ) ).

cnf(i_0_9206,axiom,
    ( esk2205_4(X1,X2,X3,X4)
    | esk2152_4(X1,X2,X3,X4) ) ).

cnf(i_0_9207,axiom,
    ( esk16739_4(X1,X2,X3,X4)
    | esk16738_4(X1,X2,X3,X4) ) ).

cnf(i_0_9208,axiom,
    ( ~ esk9720_4(X1,X2,X3,X4)
    | ~ esk9721_4(X1,X2,X3,X4)
    | ~ esk9701_4(X1,X2,X3,X4) ) ).

cnf(i_0_9209,axiom,
    ( ~ esk13634_4(X1,X2,X3,X4)
    | esk13630_4(X1,X2,X3,X4) ) ).

cnf(i_0_9210,axiom,
    ( esk14948_4(X1,X2,X3,X4)
    | ~ esk14897_4(X1,X2,X3,X4) ) ).

cnf(i_0_9211,axiom,
    ( esk9895_4(X1,X2,X3,X4)
    | ~ esk10014_4(X1,X2,X3,X4)
    | ~ esk9914_4(X1,X2,X3,X4) ) ).

cnf(i_0_9212,axiom,
    ( esk3035_4(X1,X2,X3,X4)
    | esk3158_4(X1,X2,X3,X4) ) ).

cnf(i_0_9213,axiom,
    ( p(X4)
    | ~ p(X3)
    | ~ p(X2)
    | ~ p(X1)
    | esk16687_4(X1,X2,X3,X4)
    | ~ esk122_0 ) ).

cnf(i_0_9214,axiom,
    ( ~ esk15464_4(X1,X2,X3,X4)
    | esk15463_4(X1,X2,X3,X4) ) ).

cnf(i_0_9215,axiom,
    ( esk8853_4(X1,X2,X3,X4)
    | ~ esk8875_4(X1,X2,X3,X4) ) ).

cnf(i_0_9216,axiom,
    ( ~ esk218_0
    | p(X4)
    | p(X1)
    | esk511_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X2) ) ).

cnf(i_0_9217,axiom,
    ( esk8662_4(X1,X2,X3,X4)
    | esk8661_4(X1,X2,X3,X4)
    | esk8758_4(X1,X2,X3,X4) ) ).

cnf(i_0_9218,axiom,
    ( ~ esk3230_4(X1,X2,X3,X4)
    | esk3210_4(X1,X2,X3,X4) ) ).

cnf(i_0_9219,axiom,
    ( ~ esk7455_4(X1,X2,X3,X4)
    | esk7713_4(X1,X2,X3,X4) ) ).

cnf(i_0_9220,axiom,
    ( esk2779_4(X1,X2,X3,X4)
    | esk2768_4(X1,X2,X3,X4) ) ).

cnf(i_0_9221,axiom,
    ( esk5169_4(X1,X2,X3,X4)
    | esk5167_4(X1,X2,X3,X4) ) ).

cnf(i_0_9222,axiom,
    ( esk764_4(X1,X2,X3,X4)
    | ~ esk506_4(X1,X2,X3,X4) ) ).

cnf(i_0_9223,axiom,
    ( esk9286_4(X1,X2,X3,X4)
    | esk9318_4(X1,X2,X3,X4) ) ).

cnf(i_0_9224,axiom,
    ( esk10284_4(X1,X2,X3,X4)
    | ~ esk10206_4(X1,X2,X3,X4) ) ).

cnf(i_0_9225,axiom,
    ( esk6994_4(X1,X2,X3,X4)
    | ~ esk6942_4(X1,X2,X3,X4) ) ).

cnf(i_0_9226,axiom,
    ( esk1948_4(X1,X2,X3,X4)
    | esk1896_4(X1,X2,X3,X4) ) ).

cnf(i_0_9227,axiom,
    ( esk1740_4(X1,X2,X3,X4)
    | esk1761_4(X1,X2,X3,X4) ) ).

cnf(i_0_9228,axiom,
    ( esk718_4(X1,X2,X3,X4)
    | esk714_4(X1,X2,X3,X4) ) ).

cnf(i_0_9229,axiom,
    ( ~ esk15156_4(X1,X2,X3,X4)
    | ~ esk15195_4(X1,X2,X3,X4) ) ).

cnf(i_0_9230,axiom,
    ( ~ esk5626_4(X1,X2,X3,X4)
    | ~ esk5627_4(X1,X2,X3,X4)
    | ~ esk5580_4(X1,X2,X3,X4) ) ).

cnf(i_0_9231,axiom,
    ( esk13869_4(X1,X2,X3,X4)
    | esk13836_4(X1,X2,X3,X4) ) ).

cnf(i_0_9232,axiom,
    ( ~ p(X3)
    | esk412_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X1)
    | p(X4)
    | ~ esk27_0 ) ).

cnf(i_0_9233,axiom,
    ( esk9942_4(X1,X2,X3,X4)
    | esk9943_4(X1,X2,X3,X4) ) ).

cnf(i_0_9234,axiom,
    ( ~ esk6456_4(X1,X2,X3,X4)
    | ~ esk6470_4(X1,X2,X3,X4) ) ).

cnf(i_0_9235,axiom,
    ( esk8708_4(X1,X2,X3,X4)
    | esk8665_4(X1,X2,X3,X4) ) ).

cnf(i_0_9236,axiom,
    ( esk10804_4(X1,X2,X3,X4)
    | ~ esk10805_4(X1,X2,X3,X4) ) ).

cnf(i_0_9237,axiom,
    ( esk14880_4(X1,X2,X3,X4)
    | esk14831_4(X1,X2,X3,X4) ) ).

cnf(i_0_9238,axiom,
    ( esk7396_4(X1,X2,X3,X4)
    | esk7408_4(X1,X2,X3,X4) ) ).

cnf(i_0_9239,axiom,
    ( ~ esk9276_4(X1,X2,X3,X4)
    | esk9313_4(X1,X2,X3,X4)
    | esk9229_4(X1,X2,X3,X4) ) ).

cnf(i_0_9240,axiom,
    ( esk4367_4(X1,X2,X3,X4)
    | ~ esk4298_4(X1,X2,X3,X4) ) ).

cnf(i_0_9241,axiom,
    ( esk14093_4(X1,X2,X3,X4)
    | esk14076_4(X1,X2,X3,X4) ) ).

cnf(i_0_9242,axiom,
    ( ~ esk10351_4(X1,X2,X3,X4)
    | ~ esk10265_4(X1,X2,X3,X4)
    | ~ esk10316_4(X1,X2,X3,X4) ) ).

cnf(i_0_9243,axiom,
    ( ~ esk11713_4(X1,X2,X3,X4)
    | ~ esk11823_4(X1,X2,X3,X4)
    | esk11699_4(X1,X2,X3,X4) ) ).

cnf(i_0_9244,axiom,
    ( esk4008_4(X1,X2,X3,X4)
    | esk4026_4(X1,X2,X3,X4) ) ).

cnf(i_0_9245,axiom,
    ( esk6306_4(X1,X2,X3,X4)
    | ~ esk6404_4(X1,X2,X3,X4)
    | ~ esk6316_4(X1,X2,X3,X4) ) ).

cnf(i_0_9246,axiom,
    ( esk6900_4(X1,X2,X3,X4)
    | esk6882_4(X1,X2,X3,X4) ) ).

cnf(i_0_9247,axiom,
    ( esk10059_4(X1,X2,X3,X4)
    | esk10061_4(X1,X2,X3,X4) ) ).

cnf(i_0_9248,axiom,
    ( esk8185_4(X1,X2,X3,X4)
    | esk8272_4(X1,X2,X3,X4) ) ).

cnf(i_0_9249,axiom,
    ( ~ esk10337_4(X1,X2,X3,X4)
    | esk10338_4(X1,X2,X3,X4) ) ).

cnf(i_0_9250,axiom,
    ( esk14860_4(X1,X2,X3,X4)
    | esk14893_4(X1,X2,X3,X4) ) ).

cnf(i_0_9251,axiom,
    ( ~ esk13522_4(X1,X2,X3,X4)
    | esk13528_4(X1,X2,X3,X4) ) ).

cnf(i_0_9252,axiom,
    ( esk10718_4(X1,X2,X3,X4)
    | esk10717_4(X1,X2,X3,X4)
    | esk10814_4(X1,X2,X3,X4) ) ).

cnf(i_0_9253,axiom,
    ( esk5539_4(X1,X2,X3,X4)
    | ~ esk5641_4(X1,X2,X3,X4)
    | ~ esk5545_4(X1,X2,X3,X4) ) ).

cnf(i_0_9254,axiom,
    ( esk12059_4(X1,X2,X3,X4)
    | ~ esk12017_4(X1,X2,X3,X4) ) ).

cnf(i_0_9255,axiom,
    ( ~ esk13064_4(X1,X2,X3,X4)
    | ~ esk13063_4(X1,X2,X3,X4)
    | ~ esk13041_4(X1,X2,X3,X4) ) ).

cnf(i_0_9256,axiom,
    ( ~ esk11508_4(X1,X2,X3,X4)
    | ~ esk11615_4(X1,X2,X3,X4)
    | ~ esk11530_4(X1,X2,X3,X4) ) ).

cnf(i_0_9257,axiom,
    ( ~ esk1207_4(X1,X2,X3,X4)
    | esk1155_4(X1,X2,X3,X4) ) ).

cnf(i_0_9258,axiom,
    ( esk15397_4(X1,X2,X3,X4)
    | ~ esk15300_4(X1,X2,X3,X4) ) ).

cnf(i_0_9259,axiom,
    ( esk7956_4(X1,X2,X3,X4)
    | esk8001_4(X1,X2,X3,X4) ) ).

cnf(i_0_9260,axiom,
    ( ~ esk3628_4(X1,X2,X3,X4)
    | esk3593_4(X1,X2,X3,X4)
    | esk3647_4(X1,X2,X3,X4) ) ).

cnf(i_0_9261,axiom,
    ( esk10862_4(X1,X2,X3,X4)
    | ~ esk10828_4(X1,X2,X3,X4) ) ).

cnf(i_0_9262,axiom,
    ( ~ esk9781_4(X1,X2,X3,X4)
    | ~ esk9656_4(X1,X2,X3,X4) ) ).

cnf(i_0_9263,axiom,
    ( esk5716_4(X1,X2,X3,X4)
    | esk5601_4(X1,X2,X3,X4) ) ).

cnf(i_0_9264,axiom,
    ( esk9914_4(X1,X2,X3,X4)
    | ~ esk9895_4(X1,X2,X3,X4) ) ).

cnf(i_0_9265,axiom,
    ( esk13274_4(X1,X2,X3,X4)
    | esk13263_4(X1,X2,X3,X4)
    | ~ esk13275_4(X1,X2,X3,X4) ) ).

cnf(i_0_9266,axiom,
    ( esk16146_4(X1,X2,X3,X4)
    | esk16260_4(X1,X2,X3,X4) ) ).

cnf(i_0_9267,axiom,
    ( ~ esk8514_4(X1,X2,X3,X4)
    | ~ esk8521_4(X1,X2,X3,X4)
    | ~ esk8470_4(X1,X2,X3,X4) ) ).

cnf(i_0_9268,axiom,
    ( ~ esk9706_4(X1,X2,X3,X4)
    | ~ esk9711_4(X1,X2,X3,X4)
    | ~ esk9710_4(X1,X2,X3,X4) ) ).

cnf(i_0_9269,axiom,
    ( ~ esk10992_4(X1,X2,X3,X4)
    | ~ esk11058_4(X1,X2,X3,X4)
    | ~ esk11025_4(X1,X2,X3,X4) ) ).

cnf(i_0_9270,axiom,
    ( ~ esk9546_4(X1,X2,X3,X4)
    | ~ esk9548_4(X1,X2,X3,X4) ) ).

cnf(i_0_9271,axiom,
    ( esk12998_4(X1,X2,X3,X4)
    | ~ esk12979_4(X1,X2,X3,X4) ) ).

cnf(i_0_9272,axiom,
    ( esk16389_4(X1,X2,X3,X4)
    | esk16404_4(X1,X2,X3,X4) ) ).

cnf(i_0_9273,axiom,
    ( esk1784_4(X1,X2,X3,X4)
    | esk1751_4(X1,X2,X3,X4) ) ).

cnf(i_0_9274,axiom,
    ( esk5670_4(X1,X2,X3,X4)
    | ~ esk5672_4(X1,X2,X3,X4) ) ).

cnf(i_0_9275,axiom,
    ( esk15474_4(X1,X2,X3,X4)
    | ~ esk15473_4(X1,X2,X3,X4) ) ).

cnf(i_0_9276,axiom,
    ( esk410_4(X1,X2,X3,X4)
    | esk419_4(X1,X2,X3,X4) ) ).

cnf(i_0_9277,axiom,
    ( ~ esk1590_4(X1,X2,X3,X4)
    | ~ esk1503_4(X1,X2,X3,X4)
    | ~ esk1485_4(X1,X2,X3,X4) ) ).

cnf(i_0_9278,axiom,
    ( ~ esk14830_4(X1,X2,X3,X4)
    | ~ esk14829_4(X1,X2,X3,X4) ) ).

cnf(i_0_9279,axiom,
    ( esk12250_4(X1,X2,X3,X4)
    | esk12232_4(X1,X2,X3,X4) ) ).

cnf(i_0_9280,axiom,
    ( esk4385_4(X1,X2,X3,X4)
    | ~ esk4383_4(X1,X2,X3,X4) ) ).

cnf(i_0_9281,axiom,
    ( esk15133_4(X1,X2,X3,X4)
    | esk15104_4(X1,X2,X3,X4) ) ).

cnf(i_0_9282,axiom,
    ( ~ esk11474_4(X1,X2,X3,X4)
    | esk11465_4(X1,X2,X3,X4) ) ).

cnf(i_0_9283,axiom,
    ( esk6942_4(X1,X2,X3,X4)
    | esk6909_4(X1,X2,X3,X4) ) ).

cnf(i_0_9284,axiom,
    ( ~ esk10157_4(X1,X2,X3,X4)
    | esk10171_4(X1,X2,X3,X4) ) ).

cnf(i_0_9285,axiom,
    ( p(X2)
    | ~ esk320_0
    | p(X1)
    | ~ p(X3)
    | p(X4)
    | esk16724_4(X1,X2,X3,X4) ) ).

cnf(i_0_9286,axiom,
    ( ~ esk3475_4(X1,X2,X3,X4)
    | esk3489_4(X1,X2,X3,X4) ) ).

cnf(i_0_9287,axiom,
    ( esk7088_4(X1,X2,X3,X4)
    | esk7089_4(X1,X2,X3,X4) ) ).

cnf(i_0_9288,axiom,
    ( esk13929_4(X1,X2,X3,X4)
    | esk13877_4(X1,X2,X3,X4)
    | ~ esk13948_4(X1,X2,X3,X4) ) ).

cnf(i_0_9289,axiom,
    ( ~ esk3258_4(X1,X2,X3,X4)
    | esk3256_4(X1,X2,X3,X4) ) ).

cnf(i_0_9290,axiom,
    ( esk767_4(X1,X2,X3,X4)
    | ~ esk1025_4(X1,X2,X3,X4) ) ).

cnf(i_0_9291,axiom,
    ( ~ esk3884_4(X1,X2,X3,X4)
    | ~ esk3905_4(X1,X2,X3,X4)
    | ~ esk3883_4(X1,X2,X3,X4) ) ).

cnf(i_0_9292,axiom,
    ( esk7432_4(X1,X2,X3,X4)
    | esk7492_4(X1,X2,X3,X4)
    | ~ esk7515_4(X1,X2,X3,X4) ) ).

cnf(i_0_9293,axiom,
    ( esk9957_4(X1,X2,X3,X4)
    | esk9979_4(X1,X2,X3,X4) ) ).

cnf(i_0_9294,axiom,
    ( ~ esk4302_4(X1,X2,X3,X4)
    | esk4359_4(X1,X2,X3,X4) ) ).

cnf(i_0_9295,axiom,
    ( esk6627_4(X1,X2,X3,X4)
    | esk6743_4(X1,X2,X3,X4) ) ).

cnf(i_0_9296,axiom,
    ( esk1176_4(X1,X2,X3,X4)
    | ~ esk1170_4(X1,X2,X3,X4) ) ).

cnf(i_0_9297,axiom,
    ( esk14690_4(X1,X2,X3,X4)
    | esk14672_4(X1,X2,X3,X4) ) ).

cnf(i_0_9298,axiom,
    ( esk14139_4(X1,X2,X3,X4)
    | ~ esk14061_4(X1,X2,X3,X4) ) ).

cnf(i_0_9299,axiom,
    ( esk7266_4(X1,X2,X3,X4)
    | esk7197_4(X1,X2,X3,X4) ) ).

cnf(i_0_9300,axiom,
    ( esk14332_4(X1,X2,X3,X4)
    | esk14336_4(X1,X2,X3,X4) ) ).

cnf(i_0_9301,axiom,
    ( esk1996_4(X1,X2,X3,X4)
    | esk2001_4(X1,X2,X3,X4) ) ).

cnf(i_0_9302,axiom,
    ( esk13849_4(X1,X2,X3,X4)
    | esk13805_4(X1,X2,X3,X4) ) ).

cnf(i_0_9303,axiom,
    ( ~ esk3850_4(X1,X2,X3,X4)
    | ~ esk3885_4(X1,X2,X3,X4)
    | ~ esk3886_4(X1,X2,X3,X4) ) ).

cnf(i_0_9304,axiom,
    ( esk7644_4(X1,X2,X3,X4)
    | esk7666_4(X1,X2,X3,X4) ) ).

cnf(i_0_9305,axiom,
    ( esk1268_4(X1,X2,X3,X4)
    | ~ esk1010_4(X1,X2,X3,X4) ) ).

cnf(i_0_9306,axiom,
    ( ~ p(X4)
    | ~ esk309_0
    | esk527_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X3)
    | ~ p(X2) ) ).

cnf(i_0_9307,axiom,
    ( ~ esk5597_4(X1,X2,X3,X4)
    | ~ esk5623_4(X1,X2,X3,X4)
    | ~ esk5706_4(X1,X2,X3,X4) ) ).

cnf(i_0_9308,axiom,
    ( esk534_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X1)
    | p(X3)
    | ~ esk325_0
    | p(X4) ) ).

cnf(i_0_9309,axiom,
    ( esk16694_4(X1,X2,X3,X4)
    | esk16739_4(X1,X2,X3,X4) ) ).

cnf(i_0_9310,axiom,
    ( ~ esk15308_4(X1,X2,X3,X4)
    | ~ esk15314_4(X1,X2,X3,X4)
    | esk15309_4(X1,X2,X3,X4) ) ).

cnf(i_0_9311,axiom,
    ( ~ esk779_4(X1,X2,X3,X4)
    | ~ esk661_4(X1,X2,X3,X4) ) ).

cnf(i_0_9312,axiom,
    ( esk12152_4(X1,X2,X3,X4)
    | esk12046_4(X1,X2,X3,X4) ) ).

cnf(i_0_9313,axiom,
    ( ~ esk7182_4(X1,X2,X3,X4)
    | esk7131_4(X1,X2,X3,X4) ) ).

cnf(i_0_9314,axiom,
    ( ~ esk15877_4(X1,X2,X3,X4)
    | ~ esk15883_4(X1,X2,X3,X4)
    | ~ esk15997_4(X1,X2,X3,X4) ) ).

cnf(i_0_9315,axiom,
    ( esk8986_4(X1,X2,X3,X4)
    | esk9067_4(X1,X2,X3,X4) ) ).

cnf(i_0_9316,axiom,
    ( esk7653_4(X1,X2,X3,X4)
    | esk7679_4(X1,X2,X3,X4) ) ).

cnf(i_0_9317,axiom,
    ( esk113_0
    | p(X1)
    | ~ p(X2)
    | p(X4)
    | ~ esk497_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_9318,axiom,
    ( ~ esk11077_4(X1,X2,X3,X4)
    | esk11105_4(X1,X2,X3,X4) ) ).

cnf(i_0_9319,axiom,
    ( esk1947_4(X1,X2,X3,X4)
    | ~ esk1942_4(X1,X2,X3,X4) ) ).

cnf(i_0_9320,axiom,
    ( esk7111_4(X1,X2,X3,X4)
    | ~ esk7115_4(X1,X2,X3,X4) ) ).

cnf(i_0_9321,axiom,
    ( esk9543_4(X1,X2,X3,X4)
    | esk9575_4(X1,X2,X3,X4) ) ).

cnf(i_0_9322,axiom,
    ( esk9400_4(X1,X2,X3,X4)
    | ~ esk9387_4(X1,X2,X3,X4) ) ).

cnf(i_0_9323,axiom,
    ( ~ esk9318_4(X1,X2,X3,X4)
    | ~ esk9286_4(X1,X2,X3,X4) ) ).

cnf(i_0_9324,axiom,
    ( ~ esk8229_4(X1,X2,X3,X4)
    | ~ esk8115_4(X1,X2,X3,X4)
    | esk8103_4(X1,X2,X3,X4) ) ).

cnf(i_0_9325,axiom,
    ( ~ esk15181_4(X1,X2,X3,X4)
    | esk15179_4(X1,X2,X3,X4) ) ).

cnf(i_0_9326,axiom,
    ( ~ esk14682_4(X1,X2,X3,X4)
    | ~ esk14683_4(X1,X2,X3,X4)
    | ~ esk14638_4(X1,X2,X3,X4) ) ).

cnf(i_0_9327,axiom,
    ( ~ esk13911_4(X1,X2,X3,X4)
    | ~ esk13867_4(X1,X2,X3,X4)
    | ~ esk13918_4(X1,X2,X3,X4) ) ).

cnf(i_0_9328,axiom,
    ( esk3767_4(X1,X2,X3,X4)
    | ~ esk3768_4(X1,X2,X3,X4) ) ).

cnf(i_0_9329,axiom,
    ( ~ esk11328_4(X1,X2,X3,X4)
    | esk11070_4(X1,X2,X3,X4) ) ).

cnf(i_0_9330,axiom,
    ( esk13047_4(X1,X2,X3,X4)
    | ~ esk13083_4(X1,X2,X3,X4) ) ).

cnf(i_0_9331,axiom,
    ( ~ esk8636_4(X1,X2,X3,X4)
    | esk8650_4(X1,X2,X3,X4) ) ).

cnf(i_0_9332,axiom,
    ( ~ esk4091_4(X1,X2,X3,X4)
    | esk4151_4(X1,X2,X3,X4)
    | esk4174_4(X1,X2,X3,X4) ) ).

cnf(i_0_9333,axiom,
    ( esk16258_4(X1,X2,X3,X4)
    | ~ esk16257_4(X1,X2,X3,X4) ) ).

cnf(i_0_9334,axiom,
    ( ~ esk7325_4(X1,X2,X3,X4)
    | esk7304_4(X1,X2,X3,X4) ) ).

cnf(i_0_9335,axiom,
    ( ~ esk10763_4(X1,X2,X3,X4)
    | ~ esk10846_4(X1,X2,X3,X4)
    | ~ esk10737_4(X1,X2,X3,X4) ) ).

cnf(i_0_9336,axiom,
    ( esk5425_4(X1,X2,X3,X4)
    | esk5394_4(X1,X2,X3,X4) ) ).

cnf(i_0_9337,axiom,
    ( ~ esk1053_4(X1,X2,X3,X4)
    | ~ esk1035_4(X1,X2,X3,X4)
    | ~ esk1033_4(X1,X2,X3,X4) ) ).

cnf(i_0_9338,axiom,
    ( esk4554_4(X1,X2,X3,X4)
    | ~ esk4626_4(X1,X2,X3,X4) ) ).

cnf(i_0_9339,axiom,
    ( ~ esk8424_4(X1,X2,X3,X4)
    | ~ esk8531_4(X1,X2,X3,X4)
    | ~ esk8446_4(X1,X2,X3,X4) ) ).

cnf(i_0_9340,axiom,
    ( ~ esk4786_4(X1,X2,X3,X4)
    | ~ esk4785_4(X1,X2,X3,X4) ) ).

cnf(i_0_9341,axiom,
    ( esk5090_4(X1,X2,X3,X4)
    | esk5081_4(X1,X2,X3,X4) ) ).

cnf(i_0_9342,axiom,
    ( esk8747_4(X1,X2,X3,X4)
    | ~ esk8751_4(X1,X2,X3,X4) ) ).

cnf(i_0_9343,axiom,
    ( esk5693_4(X1,X2,X3,X4)
    | ~ esk5678_4(X1,X2,X3,X4) ) ).

cnf(i_0_9344,axiom,
    ( ~ esk2084_4(X1,X2,X3,X4)
    | esk2106_4(X1,X2,X3,X4)
    | esk2085_4(X1,X2,X3,X4) ) ).

cnf(i_0_9345,axiom,
    ( ~ esk7711_4(X1,X2,X3,X4)
    | esk7737_4(X1,X2,X3,X4)
    | esk7762_4(X1,X2,X3,X4) ) ).

cnf(i_0_9346,axiom,
    ( ~ esk3036_4(X1,X2,X3,X4)
    | ~ esk3069_4(X1,X2,X3,X4)
    | ~ esk3025_4(X1,X2,X3,X4) ) ).

cnf(i_0_9347,axiom,
    ( ~ esk2975_4(X1,X2,X3,X4)
    | ~ esk3063_4(X1,X2,X3,X4)
    | esk2965_4(X1,X2,X3,X4) ) ).

cnf(i_0_9348,axiom,
    ( ~ esk2337_4(X1,X2,X3,X4)
    | esk2374_4(X1,X2,X3,X4)
    | esk2290_4(X1,X2,X3,X4) ) ).

cnf(i_0_9349,axiom,
    ( ~ esk11251_4(X1,X2,X3,X4)
    | ~ esk11229_4(X1,X2,X3,X4) ) ).

cnf(i_0_9350,axiom,
    ( ~ esk1_0
    | ~ p(X2)
    | esk16705_4(X1,X2,X3,X4)
    | ~ p(X3)
    | ~ p(X1)
    | ~ p(X4) ) ).

cnf(i_0_9351,axiom,
    ( esk10907_4(X1,X2,X3,X4)
    | ~ esk10933_4(X1,X2,X3,X4) ) ).

cnf(i_0_9352,axiom,
    ( esk14540_4(X1,X2,X3,X4)
    | ~ esk14529_4(X1,X2,X3,X4) ) ).

cnf(i_0_9353,axiom,
    ( esk14849_4(X1,X2,X3,X4)
    | esk14875_4(X1,X2,X3,X4) ) ).

cnf(i_0_9354,axiom,
    ( esk15133_4(X1,X2,X3,X4)
    | esk15166_4(X1,X2,X3,X4) ) ).

cnf(i_0_9355,axiom,
    ( ~ esk11741_4(X1,X2,X3,X4)
    | ~ esk11742_4(X1,X2,X3,X4) ) ).

cnf(i_0_9356,axiom,
    ( ~ esk8938_4(X1,X2,X3,X4)
    | ~ esk8937_4(X1,X2,X3,X4) ) ).

cnf(i_0_9357,axiom,
    ( esk13564_4(X1,X2,X3,X4)
    | esk13584_4(X1,X2,X3,X4) ) ).

cnf(i_0_9358,axiom,
    ( ~ esk9544_4(X1,X2,X3,X4)
    | esk9576_4(X1,X2,X3,X4) ) ).

cnf(i_0_9359,axiom,
    ( esk11292_4(X1,X2,X3,X4)
    | ~ esk11550_4(X1,X2,X3,X4) ) ).

cnf(i_0_9360,axiom,
    ( ~ esk5388_4(X1,X2,X3,X4)
    | esk5130_4(X1,X2,X3,X4) ) ).

cnf(i_0_9361,axiom,
    ( ~ esk13982_4(X1,X2,X3,X4)
    | esk14011_4(X1,X2,X3,X4) ) ).

cnf(i_0_9362,axiom,
    ( esk11462_4(X1,X2,X3,X4)
    | ~ esk11720_4(X1,X2,X3,X4) ) ).

cnf(i_0_9363,axiom,
    ( esk4647_4(X1,X2,X3,X4)
    | esk4646_4(X1,X2,X3,X4) ) ).

cnf(i_0_9364,axiom,
    ( esk10734_4(X1,X2,X3,X4)
    | esk10739_4(X1,X2,X3,X4) ) ).

cnf(i_0_9365,axiom,
    ( esk16640_4(X1,X2,X3,X4)
    | esk16659_4(X1,X2,X3,X4) ) ).

cnf(i_0_9366,axiom,
    ( esk1255_4(X1,X2,X3,X4)
    | esk1226_4(X1,X2,X3,X4) ) ).

cnf(i_0_9367,axiom,
    ( esk8519_4(X1,X2,X3,X4)
    | esk8518_4(X1,X2,X3,X4)
    | ~ esk8544_4(X1,X2,X3,X4) ) ).

cnf(i_0_9368,axiom,
    ( ~ esk12755_4(X1,X2,X3,X4)
    | ~ esk12746_4(X1,X2,X3,X4)
    | ~ esk12769_4(X1,X2,X3,X4) ) ).

cnf(i_0_9369,axiom,
    ( esk1724_4(X1,X2,X3,X4)
    | ~ esk1805_4(X1,X2,X3,X4) ) ).

cnf(i_0_9370,axiom,
    ( ~ esk10057_4(X1,X2,X3,X4)
    | ~ esk10012_4(X1,X2,X3,X4)
    | ~ esk10056_4(X1,X2,X3,X4) ) ).

cnf(i_0_9371,axiom,
    ( esk15451_4(X1,X2,X3,X4)
    | esk15415_4(X1,X2,X3,X4) ) ).

cnf(i_0_9372,axiom,
    ( esk15361_4(X1,X2,X3,X4)
    | esk15364_4(X1,X2,X3,X4) ) ).

cnf(i_0_9373,axiom,
    ( ~ esk9231_4(X1,X2,X3,X4)
    | esk8973_4(X1,X2,X3,X4) ) ).

cnf(i_0_9374,axiom,
    ( ~ esk11611_4(X1,X2,X3,X4)
    | ~ esk11612_4(X1,X2,X3,X4)
    | esk11613_4(X1,X2,X3,X4) ) ).

cnf(i_0_9375,axiom,
    ( ~ esk2176_4(X1,X2,X3,X4)
    | ~ esk2206_4(X1,X2,X3,X4) ) ).

cnf(i_0_9376,axiom,
    ( esk682_4(X1,X2,X3,X4)
    | ~ esk670_4(X1,X2,X3,X4) ) ).

cnf(i_0_9377,axiom,
    ( esk13635_4(X1,X2,X3,X4)
    | esk13636_4(X1,X2,X3,X4)
    | ~ esk13637_4(X1,X2,X3,X4) ) ).

cnf(i_0_9378,axiom,
    ( esk9984_4(X1,X2,X3,X4)
    | esk9955_4(X1,X2,X3,X4) ) ).

cnf(i_0_9379,axiom,
    ( esk3263_4(X1,X2,X3,X4)
    | esk3354_4(X1,X2,X3,X4) ) ).

cnf(i_0_9380,axiom,
    ( ~ esk9285_4(X1,X2,X3,X4)
    | ~ esk9286_4(X1,X2,X3,X4)
    | ~ esk9241_4(X1,X2,X3,X4) ) ).

cnf(i_0_9381,axiom,
    ( esk12479_4(X1,X2,X3,X4)
    | ~ esk12600_4(X1,X2,X3,X4)
    | ~ esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_9382,axiom,
    ( esk9043_4(X1,X2,X3,X4)
    | esk8956_4(X1,X2,X3,X4) ) ).

cnf(i_0_9383,axiom,
    ( esk13178_4(X1,X2,X3,X4)
    | esk13171_4(X1,X2,X3,X4)
    | ~ esk13090_4(X1,X2,X3,X4) ) ).

cnf(i_0_9384,axiom,
    ( ~ esk9170_4(X1,X2,X3,X4)
    | esk9428_4(X1,X2,X3,X4) ) ).

cnf(i_0_9385,axiom,
    ( ~ esk15707_4(X1,X2,X3,X4)
    | ~ esk15672_4(X1,X2,X3,X4)
    | ~ esk15726_4(X1,X2,X3,X4) ) ).

cnf(i_0_9386,axiom,
    ( esk16730_4(X1,X2,X3,X4)
    | esk16710_4(X1,X2,X3,X4) ) ).

cnf(i_0_9387,axiom,
    ( esk5037_4(X1,X2,X3,X4)
    | ~ esk5295_4(X1,X2,X3,X4) ) ).

cnf(i_0_9388,axiom,
    ( ~ esk12738_4(X1,X2,X3,X4)
    | ~ esk12744_4(X1,X2,X3,X4)
    | esk12739_4(X1,X2,X3,X4) ) ).

cnf(i_0_9389,axiom,
    ( esk12886_4(X1,X2,X3,X4)
    | ~ esk12915_4(X1,X2,X3,X4)
    | esk12835_4(X1,X2,X3,X4) ) ).

cnf(i_0_9390,axiom,
    ( esk14283_4(X1,X2,X3,X4)
    | ~ esk14270_4(X1,X2,X3,X4) ) ).

cnf(i_0_9391,axiom,
    ( esk12920_4(X1,X2,X3,X4)
    | ~ esk12901_4(X1,X2,X3,X4)
    | esk12849_4(X1,X2,X3,X4) ) ).

cnf(i_0_9392,axiom,
    ( ~ esk419_4(X1,X2,X3,X4)
    | ~ esk424_4(X1,X2,X3,X4) ) ).

cnf(i_0_9393,axiom,
    ( ~ esk10337_4(X1,X2,X3,X4)
    | ~ esk10285_4(X1,X2,X3,X4) ) ).

cnf(i_0_9394,axiom,
    ( ~ esk12465_4(X1,X2,X3,X4)
    | esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_9395,axiom,
    ( esk6050_4(X1,X2,X3,X4)
    | ~ esk6024_4(X1,X2,X3,X4) ) ).

cnf(i_0_9396,axiom,
    ( esk10518_4(X1,X2,X3,X4)
    | ~ esk10260_4(X1,X2,X3,X4) ) ).

cnf(i_0_9397,axiom,
    ( esk10533_4(X1,X2,X3,X4)
    | ~ esk10791_4(X1,X2,X3,X4) ) ).

cnf(i_0_9398,axiom,
    ( ~ esk5639_4(X1,X2,X3,X4)
    | ~ esk5719_4(X1,X2,X3,X4)
    | ~ esk5690_4(X1,X2,X3,X4) ) ).

cnf(i_0_9399,axiom,
    ( ~ esk14015_4(X1,X2,X3,X4)
    | esk13993_4(X1,X2,X3,X4) ) ).

cnf(i_0_9400,axiom,
    ( ~ esk5935_4(X1,X2,X3,X4)
    | ~ esk5888_4(X1,X2,X3,X4)
    | ~ esk5972_4(X1,X2,X3,X4) ) ).

cnf(i_0_9401,axiom,
    ( esk13910_4(X1,X2,X3,X4)
    | esk13909_4(X1,X2,X3,X4)
    | esk13901_4(X1,X2,X3,X4) ) ).

cnf(i_0_9402,axiom,
    ( ~ esk7092_4(X1,X2,X3,X4)
    | esk6834_4(X1,X2,X3,X4) ) ).

cnf(i_0_9403,axiom,
    ( ~ esk4169_4(X1,X2,X3,X4)
    | ~ esk4117_4(X1,X2,X3,X4) ) ).

cnf(i_0_9404,axiom,
    ( ~ esk5181_4(X1,X2,X3,X4)
    | esk5182_4(X1,X2,X3,X4) ) ).

cnf(i_0_9405,axiom,
    ( ~ esk1997_4(X1,X2,X3,X4)
    | ~ esk2020_4(X1,X2,X3,X4)
    | ~ esk2053_4(X1,X2,X3,X4) ) ).

cnf(i_0_9406,axiom,
    ( esk5573_4(X1,X2,X3,X4)
    | esk5559_4(X1,X2,X3,X4) ) ).

cnf(i_0_9407,axiom,
    ( esk9245_4(X1,X2,X3,X4)
    | ~ esk9125_4(X1,X2,X3,X4) ) ).

cnf(i_0_9408,axiom,
    ( ~ esk1946_4(X1,X2,X3,X4)
    | ~ esk2071_4(X1,X2,X3,X4) ) ).

cnf(i_0_9409,axiom,
    ( ~ esk16481_4(X1,X2,X3,X4)
    | ~ esk16480_4(X1,X2,X3,X4) ) ).

cnf(i_0_9410,axiom,
    ( esk10671_4(X1,X2,X3,X4)
    | ~ esk10795_4(X1,X2,X3,X4)
    | ~ esk10685_4(X1,X2,X3,X4) ) ).

cnf(i_0_9411,axiom,
    ( ~ esk3111_4(X1,X2,X3,X4)
    | esk3136_4(X1,X2,X3,X4)
    | esk3085_4(X1,X2,X3,X4) ) ).

cnf(i_0_9412,axiom,
    ( ~ esk12833_4(X1,X2,X3,X4)
    | esk12733_4(X1,X2,X3,X4)
    | ~ esk12741_4(X1,X2,X3,X4) ) ).

cnf(i_0_9413,axiom,
    ( esk2411_4(X1,X2,X3,X4)
    | esk2433_4(X1,X2,X3,X4)
    | esk2436_4(X1,X2,X3,X4)
    | esk2463_4(X1,X2,X3,X4)
    | esk2435_4(X1,X2,X3,X4) ) ).

cnf(i_0_9414,axiom,
    ( esk15222_4(X1,X2,X3,X4)
    | ~ esk15185_4(X1,X2,X3,X4) ) ).

cnf(i_0_9415,axiom,
    ( esk15407_4(X1,X2,X3,X4)
    | esk15454_4(X1,X2,X3,X4)
    | ~ esk15488_4(X1,X2,X3,X4) ) ).

cnf(i_0_9416,axiom,
    ( ~ esk3232_4(X1,X2,X3,X4)
    | esk3218_4(X1,X2,X3,X4)
    | ~ esk3342_4(X1,X2,X3,X4) ) ).

cnf(i_0_9417,axiom,
    ( esk13903_4(X1,X2,X3,X4)
    | esk13931_4(X1,X2,X3,X4) ) ).

cnf(i_0_9418,axiom,
    ( ~ esk15316_4(X1,X2,X3,X4)
    | esk15058_4(X1,X2,X3,X4) ) ).

cnf(i_0_9419,axiom,
    ( ~ esk15444_4(X1,X2,X3,X4)
    | esk15459_4(X1,X2,X3,X4) ) ).

cnf(i_0_9420,axiom,
    ( ~ esk10022_4(X1,X2,X3,X4)
    | ~ esk10074_4(X1,X2,X3,X4)
    | ~ esk10093_4(X1,X2,X3,X4) ) ).

cnf(i_0_9421,axiom,
    ( esk11528_4(X1,X2,X3,X4)
    | esk11508_4(X1,X2,X3,X4) ) ).

cnf(i_0_9422,axiom,
    ( ~ esk3123_4(X1,X2,X3,X4)
    | ~ esk3121_4(X1,X2,X3,X4) ) ).

cnf(i_0_9423,axiom,
    ( esk8104_4(X1,X2,X3,X4)
    | ~ esk8115_4(X1,X2,X3,X4)
    | ~ esk8201_4(X1,X2,X3,X4) ) ).

cnf(i_0_9424,axiom,
    ( esk13540_4(X1,X2,X3,X4)
    | esk13526_4(X1,X2,X3,X4) ) ).

cnf(i_0_9425,axiom,
    ( esk6383_4(X1,X2,X3,X4)
    | esk6366_4(X1,X2,X3,X4) ) ).

cnf(i_0_9426,axiom,
    ( ~ esk11237_4(X1,X2,X3,X4)
    | ~ esk11274_4(X1,X2,X3,X4)
    | ~ esk11275_4(X1,X2,X3,X4) ) ).

cnf(i_0_9427,axiom,
    ( esk13869_4(X1,X2,X3,X4)
    | esk13950_4(X1,X2,X3,X4) ) ).

cnf(i_0_9428,axiom,
    ( ~ esk16420_4(X1,X2,X3,X4)
    | ~ esk16453_4(X1,X2,X3,X4)
    | ~ esk16389_4(X1,X2,X3,X4) ) ).

cnf(i_0_9429,axiom,
    ( esk16686_4(X1,X2,X3,X4)
    | ~ esk16428_4(X1,X2,X3,X4) ) ).

cnf(i_0_9430,axiom,
    ( esk4590_4(X1,X2,X3,X4)
    | esk4567_4(X1,X2,X3,X4) ) ).

cnf(i_0_9431,axiom,
    ( ~ esk1742_4(X1,X2,X3,X4)
    | ~ esk1872_4(X1,X2,X3,X4)
    | ~ esk1766_4(X1,X2,X3,X4) ) ).

cnf(i_0_9432,axiom,
    ( ~ esk2304_4(X1,X2,X3,X4)
    | ~ esk2385_4(X1,X2,X3,X4) ) ).

cnf(i_0_9433,axiom,
    ( esk9139_4(X1,X2,X3,X4)
    | esk9173_4(X1,X2,X3,X4)
    | esk9193_4(X1,X2,X3,X4) ) ).

cnf(i_0_9434,axiom,
    ( esk13633_4(X1,X2,X3,X4)
    | ~ esk13632_4(X1,X2,X3,X4) ) ).

cnf(i_0_9435,axiom,
    ( ~ esk7430_4(X1,X2,X3,X4)
    | ~ esk7514_4(X1,X2,X3,X4)
    | ~ esk7477_4(X1,X2,X3,X4) ) ).

cnf(i_0_9436,axiom,
    ( ~ esk12362_4(X1,X2,X3,X4)
    | esk12390_4(X1,X2,X3,X4) ) ).

cnf(i_0_9437,axiom,
    ( esk5125_4(X1,X2,X3,X4)
    | esk5092_4(X1,X2,X3,X4) ) ).

cnf(i_0_9438,axiom,
    ( ~ esk12782_4(X1,X2,X3,X4)
    | esk12842_4(X1,X2,X3,X4) ) ).

cnf(i_0_9439,axiom,
    ( esk7415_4(X1,X2,X3,X4)
    | esk7384_4(X1,X2,X3,X4) ) ).

cnf(i_0_9440,axiom,
    ( ~ esk14531_4(X1,X2,X3,X4)
    | esk14540_4(X1,X2,X3,X4) ) ).

cnf(i_0_9441,axiom,
    ( esk4109_4(X1,X2,X3,X4)
    | ~ esk3987_4(X1,X2,X3,X4) ) ).

cnf(i_0_9442,axiom,
    ( ~ esk11544_4(X1,X2,X3,X4)
    | ~ esk11506_4(X1,X2,X3,X4)
    | ~ esk11511_4(X1,X2,X3,X4) ) ).

cnf(i_0_9443,axiom,
    ( esk11207_4(X1,X2,X3,X4)
    | esk11218_4(X1,X2,X3,X4)
    | ~ esk11219_4(X1,X2,X3,X4) ) ).

cnf(i_0_9444,axiom,
    ( ~ esk3350_4(X1,X2,X3,X4)
    | esk3354_4(X1,X2,X3,X4)
    | esk3349_4(X1,X2,X3,X4) ) ).

cnf(i_0_9445,axiom,
    ( ~ esk1280_4(X1,X2,X3,X4)
    | esk1022_4(X1,X2,X3,X4) ) ).

cnf(i_0_9446,axiom,
    ( esk10685_4(X1,X2,X3,X4)
    | ~ esk10670_4(X1,X2,X3,X4) ) ).

cnf(i_0_9447,axiom,
    ( esk12379_4(X1,X2,X3,X4)
    | ~ esk12359_4(X1,X2,X3,X4) ) ).

cnf(i_0_9448,axiom,
    ( ~ esk417_4(X1,X2,X3,X4)
    | ~ esk413_4(X1,X2,X3,X4) ) ).

cnf(i_0_9449,axiom,
    ( ~ esk8211_4(X1,X2,X3,X4)
    | ~ esk8259_4(X1,X2,X3,X4) ) ).

cnf(i_0_9450,axiom,
    ( esk16339_4(X1,X2,X3,X4)
    | ~ esk16324_4(X1,X2,X3,X4) ) ).

cnf(i_0_9451,axiom,
    ( esk12576_4(X1,X2,X3,X4)
    | ~ esk12657_4(X1,X2,X3,X4)
    | esk12664_4(X1,X2,X3,X4) ) ).

cnf(i_0_9452,axiom,
    ( ~ esk6733_4(X1,X2,X3,X4)
    | ~ esk6755_4(X1,X2,X3,X4) ) ).

cnf(i_0_9453,axiom,
    ( esk11279_4(X1,X2,X3,X4)
    | esk11251_4(X1,X2,X3,X4) ) ).

cnf(i_0_9454,axiom,
    ( esk10832_4(X1,X2,X3,X4)
    | esk10777_4(X1,X2,X3,X4) ) ).

cnf(i_0_9455,axiom,
    ( esk3007_4(X1,X2,X3,X4)
    | ~ esk2971_4(X1,X2,X3,X4) ) ).

cnf(i_0_9456,axiom,
    ( ~ esk2347_4(X1,X2,X3,X4)
    | ~ esk2379_4(X1,X2,X3,X4) ) ).

cnf(i_0_9457,axiom,
    ( ~ esk13039_4(X1,X2,X3,X4)
    | ~ esk13068_4(X1,X2,X3,X4)
    | ~ esk13067_4(X1,X2,X3,X4) ) ).

cnf(i_0_9458,axiom,
    ( ~ esk15323_4(X1,X2,X3,X4)
    | esk15307_4(X1,X2,X3,X4)
    | ~ esk15343_4(X1,X2,X3,X4) ) ).

cnf(i_0_9459,axiom,
    ( ~ esk6962_4(X1,X2,X3,X4)
    | ~ esk6971_4(X1,X2,X3,X4) ) ).

cnf(i_0_9460,axiom,
    ( esk5900_4(X1,X2,X3,X4)
    | esk5945_4(X1,X2,X3,X4) ) ).

cnf(i_0_9461,axiom,
    ( ~ esk8476_4(X1,X2,X3,X4)
    | ~ esk8530_4(X1,X2,X3,X4)
    | ~ esk8511_4(X1,X2,X3,X4) ) ).

cnf(i_0_9462,axiom,
    ( esk8182_4(X1,X2,X3,X4)
    | esk8215_4(X1,X2,X3,X4) ) ).

cnf(i_0_9463,axiom,
    ( esk16670_4(X1,X2,X3,X4)
    | esk16755_4(X1,X2,X3,X4) ) ).

cnf(i_0_9464,axiom,
    ( esk13832_4(X1,X2,X3,X4)
    | esk13819_4(X1,X2,X3,X4) ) ).

cnf(i_0_9465,axiom,
    ( esk11228_4(X1,X2,X3,X4)
    | ~ esk11226_4(X1,X2,X3,X4) ) ).

cnf(i_0_9466,axiom,
    ( esk1768_4(X1,X2,X3,X4)
    | esk1727_4(X1,X2,X3,X4) ) ).

cnf(i_0_9467,axiom,
    ( esk2067_4(X1,X2,X3,X4)
    | ~ esk2066_4(X1,X2,X3,X4)
    | ~ esk2065_4(X1,X2,X3,X4) ) ).

cnf(i_0_9468,axiom,
    ( esk15150_4(X1,X2,X3,X4)
    | ~ esk14892_4(X1,X2,X3,X4) ) ).

cnf(i_0_9469,axiom,
    ( ~ esk10397_4(X1,X2,X3,X4)
    | esk10554_4(X1,X2,X3,X4) ) ).

cnf(i_0_9470,axiom,
    ( esk10682_4(X1,X2,X3,X4)
    | ~ esk10683_4(X1,X2,X3,X4) ) ).

cnf(i_0_9471,axiom,
    ( esk2830_4(X1,X2,X3,X4)
    | ~ esk2705_4(X1,X2,X3,X4) ) ).

cnf(i_0_9472,axiom,
    ( ~ esk12796_4(X1,X2,X3,X4)
    | ~ esk12789_4(X1,X2,X3,X4)
    | ~ esk12797_4(X1,X2,X3,X4) ) ).

cnf(i_0_9473,axiom,
    ( esk4798_4(X1,X2,X3,X4)
    | ~ esk4802_4(X1,X2,X3,X4) ) ).

cnf(i_0_9474,axiom,
    ( esk14910_4(X1,X2,X3,X4)
    | ~ esk14832_4(X1,X2,X3,X4) ) ).

cnf(i_0_9475,axiom,
    ( ~ p(X2)
    | esk499_4(X1,X2,X3,X4)
    | ~ p(X3)
    | p(X1)
    | ~ esk129_0
    | ~ p(X4) ) ).

cnf(i_0_9476,axiom,
    ( ~ esk10842_4(X1,X2,X3,X4)
    | ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10755_4(X1,X2,X3,X4) ) ).

cnf(i_0_9477,axiom,
    ( esk1310_4(X1,X2,X3,X4)
    | esk1290_4(X1,X2,X3,X4) ) ).

cnf(i_0_9478,axiom,
    ( esk7577_4(X1,X2,X3,X4)
    | ~ esk7601_4(X1,X2,X3,X4) ) ).

cnf(i_0_9479,axiom,
    ( ~ esk7115_4(X1,X2,X3,X4)
    | ~ esk7116_4(X1,X2,X3,X4) ) ).

cnf(i_0_9480,axiom,
    ( ~ esk5411_4(X1,X2,X3,X4)
    | esk5413_4(X1,X2,X3,X4) ) ).

cnf(i_0_9481,axiom,
    ( ~ esk5367_4(X1,X2,X3,X4)
    | ~ esk5400_4(X1,X2,X3,X4)
    | ~ esk5338_4(X1,X2,X3,X4) ) ).

cnf(i_0_9482,axiom,
    ( esk3747_4(X1,X2,X3,X4)
    | esk3697_4(X1,X2,X3,X4) ) ).

cnf(i_0_9483,axiom,
    ( esk5270_4(X1,X2,X3,X4)
    | ~ esk5288_4(X1,X2,X3,X4)
    | ~ esk5390_4(X1,X2,X3,X4) ) ).

cnf(i_0_9484,axiom,
    ( esk12327_4(X1,X2,X3,X4)
    | esk12408_4(X1,X2,X3,X4) ) ).

cnf(i_0_9485,axiom,
    ( ~ esk5117_4(X1,X2,X3,X4)
    | esk4859_4(X1,X2,X3,X4) ) ).

cnf(i_0_9486,axiom,
    ( esk6919_4(X1,X2,X3,X4)
    | ~ esk7177_4(X1,X2,X3,X4) ) ).

cnf(i_0_9487,axiom,
    ( p(X1)
    | ~ esk16693_4(X1,X2,X3,X4)
    | esk156_0
    | ~ p(X4)
    | ~ p(X3)
    | p(X2) ) ).

cnf(i_0_9488,axiom,
    ( esk10027_4(X1,X2,X3,X4)
    | ~ esk10285_4(X1,X2,X3,X4) ) ).

cnf(i_0_9489,axiom,
    ( esk6157_4(X1,X2,X3,X4)
    | esk6202_4(X1,X2,X3,X4) ) ).

cnf(i_0_9490,axiom,
    ( ~ esk3561_4(X1,X2,X3,X4)
    | ~ esk3529_4(X1,X2,X3,X4)
    | ~ esk3560_4(X1,X2,X3,X4) ) ).

cnf(i_0_9491,axiom,
    ( ~ esk15877_4(X1,X2,X3,X4)
    | ~ esk15994_4(X1,X2,X3,X4)
    | ~ esk15907_4(X1,X2,X3,X4) ) ).

cnf(i_0_9492,axiom,
    ( ~ esk15825_4(X1,X2,X3,X4)
    | ~ esk15929_4(X1,X2,X3,X4)
    | esk15808_4(X1,X2,X3,X4) ) ).

cnf(i_0_9493,axiom,
    ( esk4422_4(X1,X2,X3,X4)
    | esk4394_4(X1,X2,X3,X4) ) ).

cnf(i_0_9494,axiom,
    ( esk4626_4(X1,X2,X3,X4)
    | ~ esk4884_4(X1,X2,X3,X4) ) ).

cnf(i_0_9495,axiom,
    ( esk8719_4(X1,X2,X3,X4)
    | ~ esk8620_4(X1,X2,X3,X4) ) ).

cnf(i_0_9496,axiom,
    ( esk5791_4(X1,X2,X3,X4)
    | ~ esk5769_4(X1,X2,X3,X4) ) ).

cnf(i_0_9497,axiom,
    ( ~ esk7119_4(X1,X2,X3,X4)
    | ~ esk7120_4(X1,X2,X3,X4) ) ).

cnf(i_0_9498,axiom,
    ( ~ esk14937_4(X1,X2,X3,X4)
    | ~ esk14929_4(X1,X2,X3,X4) ) ).

cnf(i_0_9499,axiom,
    ( esk13883_4(X1,X2,X3,X4)
    | ~ esk13757_4(X1,X2,X3,X4) ) ).

cnf(i_0_9500,axiom,
    ( esk8109_4(X1,X2,X3,X4)
    | ~ esk8211_4(X1,X2,X3,X4)
    | ~ esk8115_4(X1,X2,X3,X4) ) ).

cnf(i_0_9501,axiom,
    ( esk15680_4(X1,X2,X3,X4)
    | esk15647_4(X1,X2,X3,X4) ) ).

cnf(i_0_9502,axiom,
    ( esk16438_4(X1,X2,X3,X4)
    | ~ esk16696_4(X1,X2,X3,X4) ) ).

cnf(i_0_9503,axiom,
    ( ~ esk7394_4(X1,X2,X3,X4)
    | ~ esk7438_4(X1,X2,X3,X4)
    | ~ esk7405_4(X1,X2,X3,X4) ) ).

cnf(i_0_9504,axiom,
    ( esk8760_4(X1,X2,X3,X4)
    | esk8743_4(X1,X2,X3,X4)
    | ~ esk8797_4(X1,X2,X3,X4) ) ).

cnf(i_0_9505,axiom,
    ( esk11053_4(X1,X2,X3,X4)
    | ~ esk10978_4(X1,X2,X3,X4) ) ).

cnf(i_0_9506,axiom,
    ( ~ esk8930_4(X1,X2,X3,X4)
    | esk8981_4(X1,X2,X3,X4) ) ).

cnf(i_0_9507,axiom,
    ( ~ esk5546_4(X1,X2,X3,X4)
    | ~ esk5548_4(X1,X2,X3,X4) ) ).

cnf(i_0_9508,axiom,
    ( ~ esk13547_4(X1,X2,X3,X4)
    | esk13625_4(X1,X2,X3,X4) ) ).

cnf(i_0_9509,axiom,
    ( esk9181_4(X1,X2,X3,X4)
    | ~ esk9250_4(X1,X2,X3,X4) ) ).

cnf(i_0_9510,axiom,
    ( ~ esk11927_4(X1,X2,X3,X4)
    | esk11954_4(X1,X2,X3,X4) ) ).

cnf(i_0_9511,axiom,
    ( ~ esk4223_4(X1,X2,X3,X4)
    | esk4253_4(X1,X2,X3,X4) ) ).

cnf(i_0_9512,axiom,
    ( esk14383_4(X1,X2,X3,X4)
    | esk14350_4(X1,X2,X3,X4) ) ).

cnf(i_0_9513,axiom,
    ( ~ esk14840_4(X1,X2,X3,X4)
    | esk14894_4(X1,X2,X3,X4) ) ).

cnf(i_0_9514,axiom,
    ( ~ esk13632_4(X1,X2,X3,X4)
    | esk13630_4(X1,X2,X3,X4) ) ).

cnf(i_0_9515,axiom,
    ( esk1997_4(X1,X2,X3,X4)
    | esk2028_4(X1,X2,X3,X4) ) ).

cnf(i_0_9516,axiom,
    ( esk16134_4(X1,X2,X3,X4)
    | esk16152_4(X1,X2,X3,X4) ) ).

cnf(i_0_9517,axiom,
    ( esk2308_4(X1,X2,X3,X4)
    | esk2344_4(X1,X2,X3,X4) ) ).

cnf(i_0_9518,axiom,
    ( esk6088_4(X1,X2,X3,X4)
    | esk6087_4(X1,X2,X3,X4) ) ).

cnf(i_0_9519,axiom,
    ( esk8431_4(X1,X2,X3,X4)
    | esk8418_4(X1,X2,X3,X4) ) ).

cnf(i_0_9520,axiom,
    ( ~ esk12179_4(X1,X2,X3,X4)
    | esk12222_4(X1,X2,X3,X4) ) ).

cnf(i_0_9521,axiom,
    ( ~ esk16109_4(X1,X2,X3,X4)
    | esk16367_4(X1,X2,X3,X4) ) ).

cnf(i_0_9522,axiom,
    ( ~ esk8978_4(X1,X2,X3,X4)
    | ~ esk8945_4(X1,X2,X3,X4)
    | ~ esk8936_4(X1,X2,X3,X4) ) ).

cnf(i_0_9523,axiom,
    ( ~ esk14604_4(X1,X2,X3,X4)
    | ~ esk14603_4(X1,X2,X3,X4)
    | ~ esk14584_4(X1,X2,X3,X4) ) ).

cnf(i_0_9524,axiom,
    ( esk12980_4(X1,X2,X3,X4)
    | ~ esk12957_4(X1,X2,X3,X4) ) ).

cnf(i_0_9525,axiom,
    ( ~ esk3627_4(X1,X2,X3,X4)
    | ~ esk3628_4(X1,X2,X3,X4) ) ).

cnf(i_0_9526,axiom,
    ( ~ esk108_0
    | p(X4)
    | p(X1)
    | p(X2)
    | esk16687_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_9527,axiom,
    ( ~ esk8771_4(X1,X2,X3,X4)
    | ~ esk8810_4(X1,X2,X3,X4) ) ).

cnf(i_0_9528,axiom,
    ( ~ esk12641_4(X1,X2,X3,X4)
    | ~ esk12536_4(X1,X2,X3,X4)
    | ~ esk12554_4(X1,X2,X3,X4) ) ).

cnf(i_0_9529,axiom,
    ( ~ esk7079_4(X1,X2,X3,X4)
    | esk7087_4(X1,X2,X3,X4) ) ).

cnf(i_0_9530,axiom,
    ( esk9759_4(X1,X2,X3,X4)
    | esk9798_4(X1,X2,X3,X4) ) ).

cnf(i_0_9531,axiom,
    ( ~ esk2797_4(X1,X2,X3,X4)
    | ~ esk2798_4(X1,X2,X3,X4)
    | ~ esk2754_4(X1,X2,X3,X4) ) ).

cnf(i_0_9532,axiom,
    ( esk4839_4(X1,X2,X3,X4)
    | esk4817_4(X1,X2,X3,X4) ) ).

cnf(i_0_9533,axiom,
    ( esk2000_4(X1,X2,X3,X4)
    | esk1997_4(X1,X2,X3,X4) ) ).

cnf(i_0_9534,axiom,
    ( esk5399_4(X1,X2,X3,X4)
    | ~ esk5324_4(X1,X2,X3,X4) ) ).

cnf(i_0_9535,axiom,
    ( ~ esk9498_4(X1,X2,X3,X4)
    | esk9542_4(X1,X2,X3,X4)
    | esk9549_4(X1,X2,X3,X4) ) ).

cnf(i_0_9536,axiom,
    ( esk13562_4(X1,X2,X3,X4)
    | esk13589_4(X1,X2,X3,X4) ) ).

cnf(i_0_9537,axiom,
    ( esk8369_4(X1,X2,X3,X4)
    | ~ esk8370_4(X1,X2,X3,X4) ) ).

cnf(i_0_9538,axiom,
    ( esk1091_4(X1,X2,X3,X4)
    | esk977_4(X1,X2,X3,X4) ) ).

cnf(i_0_9539,axiom,
    ( ~ esk3125_4(X1,X2,X3,X4)
    | esk3126_4(X1,X2,X3,X4) ) ).

cnf(i_0_9540,axiom,
    ( esk7911_4(X1,X2,X3,X4)
    | esk7907_4(X1,X2,X3,X4) ) ).

cnf(i_0_9541,axiom,
    ( ~ esk13621_4(X1,X2,X3,X4)
    | esk13549_4(X1,X2,X3,X4) ) ).

cnf(i_0_9542,axiom,
    ( esk9024_4(X1,X2,X3,X4)
    | ~ esk9045_4(X1,X2,X3,X4)
    | esk9023_4(X1,X2,X3,X4) ) ).

cnf(i_0_9543,axiom,
    ( ~ esk15706_4(X1,X2,X3,X4)
    | ~ esk15678_4(X1,X2,X3,X4)
    | ~ esk15704_4(X1,X2,X3,X4)
    | ~ esk15676_4(X1,X2,X3,X4) ) ).

cnf(i_0_9544,axiom,
    ( esk1731_4(X1,X2,X3,X4)
    | ~ esk1791_4(X1,X2,X3,X4) ) ).

cnf(i_0_9545,axiom,
    ( esk6700_4(X1,X2,X3,X4)
    | ~ esk6701_4(X1,X2,X3,X4) ) ).

cnf(i_0_9546,axiom,
    ( esk15694_4(X1,X2,X3,X4)
    | ~ esk15695_4(X1,X2,X3,X4) ) ).

cnf(i_0_9547,axiom,
    ( ~ esk9827_4(X1,X2,X3,X4)
    | esk9790_4(X1,X2,X3,X4)
    | esk9743_4(X1,X2,X3,X4) ) ).

cnf(i_0_9548,axiom,
    ( esk11112_4(X1,X2,X3,X4)
    | esk11075_4(X1,X2,X3,X4)
    | ~ esk11028_4(X1,X2,X3,X4) ) ).

cnf(i_0_9549,axiom,
    ( ~ esk16390_4(X1,X2,X3,X4)
    | ~ esk16391_4(X1,X2,X3,X4) ) ).

cnf(i_0_9550,axiom,
    ( esk4098_4(X1,X2,X3,X4)
    | ~ esk4047_4(X1,X2,X3,X4) ) ).

cnf(i_0_9551,axiom,
    ( ~ esk14636_4(X1,X2,X3,X4)
    | esk14378_4(X1,X2,X3,X4) ) ).

cnf(i_0_9552,axiom,
    ( esk13861_4(X1,X2,X3,X4)
    | esk13916_4(X1,X2,X3,X4) ) ).

cnf(i_0_9553,axiom,
    ( ~ esk1742_4(X1,X2,X3,X4)
    | ~ esk1754_4(X1,X2,X3,X4)
    | ~ esk1868_4(X1,X2,X3,X4) ) ).

cnf(i_0_9554,axiom,
    ( esk4295_4(X1,X2,X3,X4)
    | esk4342_4(X1,X2,X3,X4) ) ).

cnf(i_0_9555,axiom,
    ( ~ esk3893_4(X1,X2,X3,X4)
    | ~ esk3892_4(X1,X2,X3,X4)
    | ~ esk3918_4(X1,X2,X3,X4) ) ).

cnf(i_0_9556,axiom,
    ( ~ esk13541_4(X1,X2,X3,X4)
    | esk13537_4(X1,X2,X3,X4) ) ).

cnf(i_0_9557,axiom,
    ( esk10091_4(X1,X2,X3,X4)
    | ~ esk10057_4(X1,X2,X3,X4) ) ).

cnf(i_0_9558,axiom,
    ( esk8339_4(X1,X2,X3,X4)
    | ~ esk8361_4(X1,X2,X3,X4) ) ).

cnf(i_0_9559,axiom,
    ( esk14164_4(X1,X2,X3,X4)
    | esk14163_4(X1,X2,X3,X4)
    | esk14165_4(X1,X2,X3,X4) ) ).

cnf(i_0_9560,axiom,
    ( ~ esk11489_4(X1,X2,X3,X4)
    | ~ esk11578_4(X1,X2,X3,X4) ) ).

cnf(i_0_9561,axiom,
    ( ~ esk9921_4(X1,X2,X3,X4)
    | esk9663_4(X1,X2,X3,X4) ) ).

cnf(i_0_9562,axiom,
    ( ~ esk14112_4(X1,X2,X3,X4)
    | esk13854_4(X1,X2,X3,X4) ) ).

cnf(i_0_9563,axiom,
    ( esk14051_4(X1,X2,X3,X4)
    | ~ esk14052_4(X1,X2,X3,X4) ) ).

cnf(i_0_9564,axiom,
    ( ~ esk3654_4(X1,X2,X3,X4)
    | esk3652_4(X1,X2,X3,X4) ) ).

cnf(i_0_9565,axiom,
    ( esk13608_4(X1,X2,X3,X4)
    | ~ esk13350_4(X1,X2,X3,X4) ) ).

cnf(i_0_9566,axiom,
    ( ~ esk11856_4(X1,X2,X3,X4)
    | ~ esk11858_4(X1,X2,X3,X4) ) ).

cnf(i_0_9567,axiom,
    ( ~ esk16095_4(X1,X2,X3,X4)
    | ~ esk16097_4(X1,X2,X3,X4) ) ).

cnf(i_0_9568,axiom,
    ( ~ esk14868_4(X1,X2,X3,X4)
    | ~ esk14869_4(X1,X2,X3,X4)
    | ~ esk14837_4(X1,X2,X3,X4) ) ).

cnf(i_0_9569,axiom,
    ( esk405_4(X1,X2,X3,X4)
    | ~ esk400_4(X1,X2,X3,X4) ) ).

cnf(i_0_9570,axiom,
    ( esk14565_4(X1,X2,X3,X4)
    | ~ esk14569_4(X1,X2,X3,X4) ) ).

cnf(i_0_9571,axiom,
    ( esk6122_4(X1,X2,X3,X4)
    | esk6103_4(X1,X2,X3,X4) ) ).

cnf(i_0_9572,axiom,
    ( ~ esk14797_4(X1,X2,X3,X4)
    | esk14782_4(X1,X2,X3,X4)
    | ~ esk14905_4(X1,X2,X3,X4) ) ).

cnf(i_0_9573,axiom,
    ( ~ esk9322_4(X1,X2,X3,X4)
    | ~ esk9253_4(X1,X2,X3,X4)
    | ~ esk9279_4(X1,X2,X3,X4) ) ).

cnf(i_0_9574,axiom,
    ( esk10526_4(X1,X2,X3,X4)
    | esk10577_4(X1,X2,X3,X4)
    | ~ esk10570_4(X1,X2,X3,X4) ) ).

cnf(i_0_9575,axiom,
    ( esk7409_4(X1,X2,X3,X4)
    | esk7442_4(X1,X2,X3,X4) ) ).

cnf(i_0_9576,axiom,
    ( ~ esk6844_4(X1,X2,X3,X4)
    | ~ esk6842_4(X1,X2,X3,X4) ) ).

cnf(i_0_9577,axiom,
    ( esk491_4(X1,X2,X3,X4)
    | p(X3)
    | ~ esk71_0
    | ~ p(X4)
    | p(X2)
    | ~ p(X1) ) ).

cnf(i_0_9578,axiom,
    ( ~ esk8804_4(X1,X2,X3,X4)
    | esk8805_4(X1,X2,X3,X4) ) ).

cnf(i_0_9579,axiom,
    ( ~ esk11581_4(X1,X2,X3,X4)
    | esk11579_4(X1,X2,X3,X4)
    | esk11580_4(X1,X2,X3,X4) ) ).

cnf(i_0_9580,axiom,
    ( ~ esk14554_4(X1,X2,X3,X4)
    | ~ esk14552_4(X1,X2,X3,X4) ) ).

cnf(i_0_9581,axiom,
    ( esk8246_4(X1,X2,X3,X4)
    | esk8199_4(X1,X2,X3,X4) ) ).

cnf(i_0_9582,axiom,
    ( ~ esk14126_4(X1,X2,X3,X4)
    | ~ esk14076_4(X1,X2,X3,X4)
    | ~ esk14093_4(X1,X2,X3,X4) ) ).

cnf(i_0_9583,axiom,
    ( ~ esk6568_4(X1,X2,X3,X4)
    | esk6573_4(X1,X2,X3,X4) ) ).

cnf(i_0_9584,axiom,
    ( esk10287_4(X1,X2,X3,X4)
    | ~ esk10029_4(X1,X2,X3,X4) ) ).

cnf(i_0_9585,axiom,
    ( esk16155_4(X1,X2,X3,X4)
    | esk16188_4(X1,X2,X3,X4) ) ).

cnf(i_0_9586,axiom,
    ( esk8739_4(X1,X2,X3,X4)
    | esk8808_4(X1,X2,X3,X4) ) ).

cnf(i_0_9587,axiom,
    ( esk2026_4(X1,X2,X3,X4)
    | esk1997_4(X1,X2,X3,X4) ) ).

cnf(i_0_9588,axiom,
    ( esk14193_4(X1,X2,X3,X4)
    | ~ esk14142_4(X1,X2,X3,X4) ) ).

cnf(i_0_9589,axiom,
    ( ~ esk5674_4(X1,X2,X3,X4)
    | esk5416_4(X1,X2,X3,X4) ) ).

cnf(i_0_9590,axiom,
    ( ~ esk9668_4(X1,X2,X3,X4)
    | ~ esk9667_4(X1,X2,X3,X4) ) ).

cnf(i_0_9591,axiom,
    ( ~ esk12110_4(X1,X2,X3,X4)
    | esk12126_4(X1,X2,X3,X4) ) ).

cnf(i_0_9592,axiom,
    ( ~ esk4352_4(X1,X2,X3,X4)
    | ~ esk4433_4(X1,X2,X3,X4)
    | ~ esk4440_4(X1,X2,X3,X4) ) ).

cnf(i_0_9593,axiom,
    ( esk13655_4(X1,X2,X3,X4)
    | esk13608_4(X1,X2,X3,X4)
    | ~ esk13689_4(X1,X2,X3,X4) ) ).

cnf(i_0_9594,axiom,
    ( esk9259_4(X1,X2,X3,X4)
    | ~ esk9138_4(X1,X2,X3,X4) ) ).

cnf(i_0_9595,axiom,
    ( esk11751_4(X1,X2,X3,X4)
    | esk11789_4(X1,X2,X3,X4) ) ).

cnf(i_0_9596,axiom,
    ( ~ esk15447_4(X1,X2,X3,X4)
    | ~ esk15472_4(X1,X2,X3,X4)
    | ~ esk15421_4(X1,X2,X3,X4) ) ).

cnf(i_0_9597,axiom,
    ( esk157_0
    | p(X4)
    | p(X3)
    | p(X1)
    | ~ p(X2)
    | ~ esk16693_4(X1,X2,X3,X4) ) ).

cnf(i_0_9598,axiom,
    ( esk1252_4(X1,X2,X3,X4)
    | esk1228_4(X1,X2,X3,X4) ) ).

cnf(i_0_9599,axiom,
    ( ~ esk9707_4(X1,X2,X3,X4)
    | ~ esk9722_4(X1,X2,X3,X4)
    | ~ esk9755_4(X1,X2,X3,X4) ) ).

cnf(i_0_9600,axiom,
    ( ~ esk660_4(X1,X2,X3,X4)
    | esk659_4(X1,X2,X3,X4) ) ).

cnf(i_0_9601,axiom,
    ( ~ esk567_4(X1,X2,X3,X4)
    | esk568_4(X1,X2,X3,X4) ) ).

cnf(i_0_9602,axiom,
    ( ~ esk5064_4(X1,X2,X3,X4)
    | ~ esk5153_4(X1,X2,X3,X4) ) ).

cnf(i_0_9603,axiom,
    ( ~ esk6159_4(X1,X2,X3,X4)
    | esk5901_4(X1,X2,X3,X4) ) ).

cnf(i_0_9604,axiom,
    ( esk11455_4(X1,X2,X3,X4)
    | esk11424_4(X1,X2,X3,X4)
    | ~ esk11575_4(X1,X2,X3,X4) ) ).

cnf(i_0_9605,axiom,
    ( esk4497_4(X1,X2,X3,X4)
    | ~ esk4478_4(X1,X2,X3,X4) ) ).

cnf(i_0_9606,axiom,
    ( ~ esk11082_4(X1,X2,X3,X4)
    | ~ esk11084_4(X1,X2,X3,X4) ) ).

cnf(i_0_9607,axiom,
    ( ~ esk10009_4(X1,X2,X3,X4)
    | esk9958_4(X1,X2,X3,X4) ) ).

cnf(i_0_9608,axiom,
    ( ~ esk8727_4(X1,X2,X3,X4)
    | ~ esk8679_4(X1,X2,X3,X4)
    | ~ esk8694_4(X1,X2,X3,X4) ) ).

cnf(i_0_9609,axiom,
    ( ~ esk10686_4(X1,X2,X3,X4)
    | ~ esk10688_4(X1,X2,X3,X4) ) ).

cnf(i_0_9610,axiom,
    ( ~ esk6067_4(X1,X2,X3,X4)
    | ~ esk6066_4(X1,X2,X3,X4) ) ).

cnf(i_0_9611,axiom,
    ( esk11081_4(X1,X2,X3,X4)
    | esk11080_4(X1,X2,X3,X4)
    | esk11079_4(X1,X2,X3,X4) ) ).

cnf(i_0_9612,axiom,
    ( esk13120_4(X1,X2,X3,X4)
    | esk13031_4(X1,X2,X3,X4) ) ).

cnf(i_0_9613,axiom,
    ( ~ esk16078_4(X1,X2,X3,X4)
    | esk16114_4(X1,X2,X3,X4) ) ).

cnf(i_0_9614,axiom,
    ( esk9251_4(X1,X2,X3,X4)
    | ~ esk9128_4(X1,X2,X3,X4) ) ).

cnf(i_0_9615,axiom,
    ( ~ esk10456_4(X1,X2,X3,X4)
    | ~ esk10457_4(X1,X2,X3,X4) ) ).

cnf(i_0_9616,axiom,
    ( ~ esk2635_4(X1,X2,X3,X4)
    | esk2606_4(X1,X2,X3,X4)
    | esk2555_4(X1,X2,X3,X4) ) ).

cnf(i_0_9617,axiom,
    ( esk15326_4(X1,X2,X3,X4)
    | ~ esk15327_4(X1,X2,X3,X4)
    | esk15321_4(X1,X2,X3,X4) ) ).

cnf(i_0_9618,axiom,
    ( esk8325_4(X1,X2,X3,X4)
    | ~ esk8360_4(X1,X2,X3,X4) ) ).

cnf(i_0_9619,axiom,
    ( ~ esk10073_4(X1,X2,X3,X4)
    | ~ esk9988_4(X1,X2,X3,X4)
    | ~ esk9966_4(X1,X2,X3,X4) ) ).

cnf(i_0_9620,axiom,
    ( ~ p(X1)
    | ~ p(X3)
    | esk16711_4(X1,X2,X3,X4)
    | ~ p(X4)
    | ~ p(X2)
    | ~ esk1_0 ) ).

cnf(i_0_9621,axiom,
    ( esk4912_4(X1,X2,X3,X4)
    | esk4884_4(X1,X2,X3,X4) ) ).

cnf(i_0_9622,axiom,
    ( ~ esk5280_4(X1,X2,X3,X4)
    | esk5252_4(X1,X2,X3,X4) ) ).

cnf(i_0_9623,axiom,
    ( esk1334_4(X1,X2,X3,X4)
    | esk1248_4(X1,X2,X3,X4) ) ).

cnf(i_0_9624,axiom,
    ( ~ esk12987_4(X1,X2,X3,X4)
    | esk12998_4(X1,X2,X3,X4) ) ).

cnf(i_0_9625,axiom,
    ( ~ esk9497_4(X1,X2,X3,X4)
    | esk9443_4(X1,X2,X3,X4) ) ).

cnf(i_0_9626,axiom,
    ( esk12394_4(X1,X2,X3,X4)
    | ~ esk12343_4(X1,X2,X3,X4) ) ).

cnf(i_0_9627,axiom,
    ( esk11456_4(X1,X2,X3,X4)
    | ~ esk11441_4(X1,X2,X3,X4) ) ).

cnf(i_0_9628,axiom,
    ( esk13002_4(X1,X2,X3,X4)
    | ~ esk13260_4(X1,X2,X3,X4) ) ).

cnf(i_0_9629,axiom,
    ( esk9932_4(X1,X2,X3,X4)
    | ~ esk9923_4(X1,X2,X3,X4) ) ).

cnf(i_0_9630,axiom,
    ( ~ esk13530_4(X1,X2,X3,X4)
    | esk13528_4(X1,X2,X3,X4) ) ).

cnf(i_0_9631,axiom,
    ( esk4851_4(X1,X2,X3,X4)
    | esk4811_4(X1,X2,X3,X4) ) ).

cnf(i_0_9632,axiom,
    ( ~ esk3317_4(X1,X2,X3,X4)
    | esk3575_4(X1,X2,X3,X4) ) ).

cnf(i_0_9633,axiom,
    ( ~ esk2174_4(X1,X2,X3,X4)
    | esk2236_4(X1,X2,X3,X4) ) ).

cnf(i_0_9634,axiom,
    ( esk8195_4(X1,X2,X3,X4)
    | esk8151_4(X1,X2,X3,X4) ) ).

cnf(i_0_9635,axiom,
    ( esk3783_4(X1,X2,X3,X4)
    | esk3823_4(X1,X2,X3,X4) ) ).

cnf(i_0_9636,axiom,
    ( ~ esk10058_4(X1,X2,X3,X4)
    | esk10090_4(X1,X2,X3,X4) ) ).

cnf(i_0_9637,axiom,
    ( ~ esk16582_4(X1,X2,X3,X4)
    | esk16551_4(X1,X2,X3,X4) ) ).

cnf(i_0_9638,axiom,
    ( esk1837_4(X1,X2,X3,X4)
    | ~ esk1862_4(X1,X2,X3,X4)
    | esk1836_4(X1,X2,X3,X4) ) ).

cnf(i_0_9639,axiom,
    ( esk1011_4(X1,X2,X3,X4)
    | ~ esk911_4(X1,X2,X3,X4) ) ).

cnf(i_0_9640,axiom,
    ( esk16216_4(X1,X2,X3,X4)
    | ~ esk16246_4(X1,X2,X3,X4)
    | esk16194_4(X1,X2,X3,X4) ) ).

cnf(i_0_9641,axiom,
    ( ~ esk9319_4(X1,X2,X3,X4)
    | esk9321_4(X1,X2,X3,X4)
    | ~ esk9320_4(X1,X2,X3,X4) ) ).

cnf(i_0_9642,axiom,
    ( esk13551_4(X1,X2,X3,X4)
    | ~ esk13617_4(X1,X2,X3,X4) ) ).

cnf(i_0_9643,axiom,
    ( esk10134_4(X1,X2,X3,X4)
    | ~ esk10164_4(X1,X2,X3,X4) ) ).

cnf(i_0_9644,axiom,
    ( esk9771_4(X1,X2,X3,X4)
    | ~ esk9645_4(X1,X2,X3,X4) ) ).

cnf(i_0_9645,axiom,
    ( esk2934_4(X1,X2,X3,X4)
    | ~ esk2957_4(X1,X2,X3,X4) ) ).

cnf(i_0_9646,axiom,
    ( esk13325_4(X1,X2,X3,X4)
    | esk13412_4(X1,X2,X3,X4) ) ).

cnf(i_0_9647,axiom,
    ( esk5288_4(X1,X2,X3,X4)
    | ~ esk5269_4(X1,X2,X3,X4) ) ).

cnf(i_0_9648,axiom,
    ( ~ esk14148_4(X1,X2,X3,X4)
    | ~ esk14056_4(X1,X2,X3,X4) ) ).

cnf(i_0_9649,axiom,
    ( esk9998_4(X1,X2,X3,X4)
    | esk10045_4(X1,X2,X3,X4) ) ).

cnf(i_0_9650,axiom,
    ( esk5338_4(X1,X2,X3,X4)
    | esk5341_4(X1,X2,X3,X4) ) ).

cnf(i_0_9651,axiom,
    ( ~ esk11699_4(X1,X2,X3,X4)
    | esk11668_4(X1,X2,X3,X4) ) ).

cnf(i_0_9652,axiom,
    ( esk12383_4(X1,X2,X3,X4)
    | ~ esk12329_4(X1,X2,X3,X4) ) ).

cnf(i_0_9653,axiom,
    ( esk12265_4(X1,X2,X3,X4)
    | ~ esk12334_4(X1,X2,X3,X4) ) ).

cnf(i_0_9654,axiom,
    ( esk1088_4(X1,X2,X3,X4)
    | ~ esk1086_4(X1,X2,X3,X4)
    | ~ esk1087_4(X1,X2,X3,X4) ) ).

cnf(i_0_9655,axiom,
    ( ~ esk13342_4(X1,X2,X3,X4)
    | esk13303_4(X1,X2,X3,X4) ) ).

cnf(i_0_9656,axiom,
    ( esk2897_4(X1,X2,X3,X4)
    | esk2854_4(X1,X2,X3,X4) ) ).

cnf(i_0_9657,axiom,
    ( esk5688_4(X1,X2,X3,X4)
    | esk5720_4(X1,X2,X3,X4) ) ).

cnf(i_0_9658,axiom,
    ( ~ esk2217_4(X1,X2,X3,X4)
    | esk2221_4(X1,X2,X3,X4) ) ).

cnf(i_0_9659,axiom,
    ( esk477_4(X1,X2,X3,X4)
    | esk445_4(X1,X2,X3,X4) ) ).

cnf(i_0_9660,axiom,
    ( esk13291_4(X1,X2,X3,X4)
    | esk13335_4(X1,X2,X3,X4) ) ).

cnf(i_0_9661,axiom,
    ( esk7493_4(X1,X2,X3,X4)
    | esk7410_4(X1,X2,X3,X4) ) ).

cnf(i_0_9662,axiom,
    ( esk12089_4(X1,X2,X3,X4)
    | ~ esk12090_4(X1,X2,X3,X4) ) ).

cnf(i_0_9663,axiom,
    ( p(X3)
    | ~ esk213_0
    | p(X2)
    | ~ p(X4)
    | esk511_4(X1,X2,X3,X4)
    | p(X1) ) ).

cnf(i_0_9664,axiom,
    ( ~ esk11189_4(X1,X2,X3,X4)
    | esk11287_4(X1,X2,X3,X4) ) ).

cnf(i_0_9665,axiom,
    ( ~ esk5335_4(X1,X2,X3,X4)
    | esk5377_4(X1,X2,X3,X4) ) ).

cnf(i_0_9666,axiom,
    ( ~ esk16675_4(X1,X2,X3,X4)
    | ~ esk16676_4(X1,X2,X3,X4)
    | ~ esk16632_4(X1,X2,X3,X4) ) ).

cnf(i_0_9667,axiom,
    ( esk7175_4(X1,X2,X3,X4)
    | ~ esk7077_4(X1,X2,X3,X4) ) ).

cnf(i_0_9668,axiom,
    ( esk5931_4(X1,X2,X3,X4)
    | ~ esk5673_4(X1,X2,X3,X4) ) ).

cnf(i_0_9669,axiom,
    ( esk11169_4(X1,X2,X3,X4)
    | ~ esk11231_4(X1,X2,X3,X4) ) ).

cnf(i_0_9670,axiom,
    ( ~ esk16071_4(X1,X2,X3,X4)
    | esk16082_4(X1,X2,X3,X4) ) ).

cnf(i_0_9671,axiom,
    ( esk7629_4(X1,X2,X3,X4)
    | esk7615_4(X1,X2,X3,X4) ) ).

cnf(i_0_9672,axiom,
    ( ~ esk4757_4(X1,X2,X3,X4)
    | esk4878_4(X1,X2,X3,X4) ) ).

cnf(i_0_9673,axiom,
    ( ~ esk12835_4(X1,X2,X3,X4)
    | ~ esk12886_4(X1,X2,X3,X4)
    | ~ esk12833_4(X1,X2,X3,X4)
    | ~ esk12888_4(X1,X2,X3,X4) ) ).

cnf(i_0_9674,axiom,
    ( esk2475_4(X1,X2,X3,X4)
    | esk2466_4(X1,X2,X3,X4) ) ).

cnf(i_0_9675,axiom,
    ( ~ esk2247_4(X1,X2,X3,X4)
    | ~ esk2269_4(X1,X2,X3,X4)
    | ~ esk2270_4(X1,X2,X3,X4) ) ).

cnf(i_0_9676,axiom,
    ( ~ esk12831_4(X1,X2,X3,X4)
    | esk12732_4(X1,X2,X3,X4)
    | ~ esk12741_4(X1,X2,X3,X4) ) ).

cnf(i_0_9677,axiom,
    ( ~ esk16737_4(X1,X2,X3,X4)
    | ~ esk16728_4(X1,X2,X3,X4) ) ).

cnf(i_0_9678,axiom,
    ( esk8992_4(X1,X2,X3,X4)
    | esk8959_4(X1,X2,X3,X4) ) ).

cnf(i_0_9679,axiom,
    ( esk11558_4(X1,X2,X3,X4)
    | ~ esk11300_4(X1,X2,X3,X4) ) ).

cnf(i_0_9680,axiom,
    ( esk12614_4(X1,X2,X3,X4)
    | esk12607_4(X1,X2,X3,X4) ) ).

cnf(i_0_9681,axiom,
    ( ~ esk12020_4(X1,X2,X3,X4)
    | ~ esk12027_4(X1,X2,X3,X4)
    | ~ esk12060_4(X1,X2,X3,X4) ) ).

cnf(i_0_9682,axiom,
    ( ~ esk7954_4(X1,X2,X3,X4)
    | ~ esk8002_4(X1,X2,X3,X4) ) ).

cnf(i_0_9683,axiom,
    ( ~ esk8233_4(X1,X2,X3,X4)
    | esk8235_4(X1,X2,X3,X4)
    | ~ esk8234_4(X1,X2,X3,X4) ) ).

cnf(i_0_9684,axiom,
    ( esk10840_4(X1,X2,X3,X4)
    | ~ esk10842_4(X1,X2,X3,X4) ) ).

cnf(i_0_9685,axiom,
    ( esk11622_4(X1,X2,X3,X4)
    | esk11570_4(X1,X2,X3,X4) ) ).

cnf(i_0_9686,axiom,
    ( ~ esk7199_4(X1,X2,X3,X4)
    | ~ esk7137_4(X1,X2,X3,X4)
    | ~ esk7166_4(X1,X2,X3,X4) ) ).

cnf(i_0_9687,axiom,
    ( ~ esk3869_4(X1,X2,X3,X4)
    | ~ esk3723_4(X1,X2,X3,X4)
    | ~ esk3876_4(X1,X2,X3,X4) ) ).

cnf(i_0_9688,axiom,
    ( ~ esk5131_4(X1,X2,X3,X4)
    | ~ esk5212_4(X1,X2,X3,X4) ) ).

cnf(i_0_9689,axiom,
    ( ~ esk1802_4(X1,X2,X3,X4)
    | esk1544_4(X1,X2,X3,X4) ) ).

cnf(i_0_9690,axiom,
    ( esk6434_4(X1,X2,X3,X4)
    | ~ esk6438_4(X1,X2,X3,X4) ) ).

cnf(i_0_9691,axiom,
    ( esk16226_4(X1,X2,X3,X4)
    | esk16178_4(X1,X2,X3,X4) ) ).

cnf(i_0_9692,axiom,
    ( esk2784_4(X1,X2,X3,X4)
    | esk2867_4(X1,X2,X3,X4) ) ).

cnf(i_0_9693,axiom,
    ( esk2189_4(X1,X2,X3,X4)
    | ~ esk2160_4(X1,X2,X3,X4) ) ).

cnf(i_0_9694,axiom,
    ( esk678_4(X1,X2,X3,X4)
    | ~ esk680_4(X1,X2,X3,X4) ) ).

cnf(i_0_9695,axiom,
    ( esk14572_4(X1,X2,X3,X4)
    | ~ esk14510_4(X1,X2,X3,X4) ) ).

cnf(i_0_9696,axiom,
    ( esk2844_4(X1,X2,X3,X4)
    | ~ esk2717_4(X1,X2,X3,X4) ) ).

cnf(i_0_9697,axiom,
    ( esk8554_4(X1,X2,X3,X4)
    | esk8448_4(X1,X2,X3,X4) ) ).

cnf(i_0_9698,axiom,
    ( esk16678_4(X1,X2,X3,X4)
    | esk16648_4(X1,X2,X3,X4) ) ).

cnf(i_0_9699,axiom,
    ( ~ esk12760_4(X1,X2,X3,X4)
    | esk12761_4(X1,X2,X3,X4) ) ).

cnf(i_0_9700,axiom,
    ( ~ esk15205_4(X1,X2,X3,X4)
    | esk15204_4(X1,X2,X3,X4)
    | esk15154_4(X1,X2,X3,X4) ) ).

cnf(i_0_9701,axiom,
    ( ~ esk8280_4(X1,X2,X3,X4)
    | esk8279_4(X1,X2,X3,X4) ) ).

cnf(i_0_9702,axiom,
    ( ~ esk530_4(X1,X2,X3,X4)
    | esk529_4(X1,X2,X3,X4)
    | esk528_4(X1,X2,X3,X4) ) ).

cnf(i_0_9703,axiom,
    ( ~ esk8386_4(X1,X2,X3,X4)
    | ~ esk8385_4(X1,X2,X3,X4) ) ).

cnf(i_0_9704,axiom,
    ( ~ esk5417_4(X1,X2,X3,X4)
    | esk5159_4(X1,X2,X3,X4) ) ).

cnf(i_0_9705,axiom,
    ( ~ esk11585_4(X1,X2,X3,X4)
    | esk11327_4(X1,X2,X3,X4) ) ).

cnf(i_0_9706,axiom,
    ( esk9005_4(X1,X2,X3,X4)
    | ~ esk8885_4(X1,X2,X3,X4) ) ).

cnf(i_0_9707,axiom,
    ( esk13269_4(X1,X2,X3,X4)
    | esk13266_4(X1,X2,X3,X4)
    | esk13267_4(X1,X2,X3,X4)
    | esk13263_4(X1,X2,X3,X4) ) ).

cnf(i_0_9708,axiom,
    ( ~ esk3332_4(X1,X2,X3,X4)
    | ~ esk3413_4(X1,X2,X3,X4) ) ).

cnf(i_0_9709,axiom,
    ( ~ esk11076_4(X1,X2,X3,X4)
    | ~ esk11058_4(X1,X2,X3,X4)
    | ~ esk11056_4(X1,X2,X3,X4) ) ).

cnf(i_0_9710,axiom,
    ( esk16668_4(X1,X2,X3,X4)
    | esk16636_4(X1,X2,X3,X4) ) ).

cnf(i_0_9711,axiom,
    ( ~ esk15439_4(X1,X2,X3,X4)
    | esk15697_4(X1,X2,X3,X4) ) ).

cnf(i_0_9712,axiom,
    ( esk7484_4(X1,X2,X3,X4)
    | esk7483_4(X1,X2,X3,X4) ) ).

cnf(i_0_9713,axiom,
    ( ~ esk1298_4(X1,X2,X3,X4)
    | esk1040_4(X1,X2,X3,X4) ) ).

cnf(i_0_9714,axiom,
    ( esk436_4(X1,X2,X3,X4)
    | ~ esk384_4(X1,X2,X3,X4) ) ).

cnf(i_0_9715,axiom,
    ( ~ esk15722_4(X1,X2,X3,X4)
    | esk15723_4(X1,X2,X3,X4) ) ).

cnf(i_0_9716,axiom,
    ( ~ esk451_4(X1,X2,X3,X4)
    | esk496_4(X1,X2,X3,X4) ) ).

cnf(i_0_9717,axiom,
    ( ~ esk16112_4(X1,X2,X3,X4)
    | ~ esk16132_4(X1,X2,X3,X4) ) ).

cnf(i_0_9718,axiom,
    ( esk13149_4(X1,X2,X3,X4)
    | ~ esk13098_4(X1,X2,X3,X4) ) ).

cnf(i_0_9719,axiom,
    ( esk4906_4(X1,X2,X3,X4)
    | esk4924_4(X1,X2,X3,X4) ) ).

cnf(i_0_9720,axiom,
    ( ~ esk778_4(X1,X2,X3,X4)
    | esk829_4(X1,X2,X3,X4) ) ).

cnf(i_0_9721,axiom,
    ( ~ esk8584_4(X1,X2,X3,X4)
    | esk8615_4(X1,X2,X3,X4) ) ).

cnf(i_0_9722,axiom,
    ( ~ esk4145_4(X1,X2,X3,X4)
    | ~ esk4184_4(X1,X2,X3,X4) ) ).

cnf(i_0_9723,axiom,
    ( esk5286_4(X1,X2,X3,X4)
    | ~ esk5291_4(X1,X2,X3,X4)
    | ~ esk5285_4(X1,X2,X3,X4) ) ).

cnf(i_0_9724,axiom,
    ( esk11995_4(X1,X2,X3,X4)
    | ~ esk11996_4(X1,X2,X3,X4) ) ).

cnf(i_0_9725,axiom,
    ( esk11121_4(X1,X2,X3,X4)
    | ~ esk11102_4(X1,X2,X3,X4)
    | esk11050_4(X1,X2,X3,X4) ) ).

cnf(i_0_9726,axiom,
    ( esk10187_4(X1,X2,X3,X4)
    | ~ esk10181_4(X1,X2,X3,X4) ) ).

cnf(i_0_9727,axiom,
    ( esk1317_4(X1,X2,X3,X4)
    | esk1278_4(X1,X2,X3,X4) ) ).

cnf(i_0_9728,axiom,
    ( esk993_4(X1,X2,X3,X4)
    | esk958_4(X1,X2,X3,X4) ) ).

cnf(i_0_9729,axiom,
    ( esk6694_4(X1,X2,X3,X4)
    | ~ esk6952_4(X1,X2,X3,X4) ) ).

cnf(i_0_9730,axiom,
    ( esk4807_4(X1,X2,X3,X4)
    | esk4806_4(X1,X2,X3,X4)
    | esk4903_4(X1,X2,X3,X4) ) ).

cnf(i_0_9731,axiom,
    ( ~ esk8424_4(X1,X2,X3,X4)
    | ~ esk8554_4(X1,X2,X3,X4)
    | ~ esk8448_4(X1,X2,X3,X4) ) ).

cnf(i_0_9732,axiom,
    ( ~ esk10419_4(X1,X2,X3,X4)
    | esk10518_4(X1,X2,X3,X4) ) ).

cnf(i_0_9733,axiom,
    ( ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1262_4(X1,X2,X3,X4)
    | ~ esk1229_4(X1,X2,X3,X4) ) ).

cnf(i_0_9734,axiom,
    ( p(X1)
    | ~ esk64_0
    | p(X2)
    | ~ p(X4)
    | esk16681_4(X1,X2,X3,X4)
    | p(X3) ) ).

cnf(i_0_9735,axiom,
    ( esk4563_4(X1,X2,X3,X4)
    | esk4576_4(X1,X2,X3,X4) ) ).

cnf(i_0_9736,axiom,
    ( ~ esk4528_4(X1,X2,X3,X4)
    | ~ esk4527_4(X1,X2,X3,X4) ) ).

cnf(i_0_9737,axiom,
    ( ~ esk6936_4(X1,X2,X3,X4)
    | ~ esk6830_4(X1,X2,X3,X4)
    | esk6814_4(X1,X2,X3,X4) ) ).

cnf(i_0_9738,axiom,
    ( esk10164_4(X1,X2,X3,X4)
    | ~ esk10171_4(X1,X2,X3,X4)
    | ~ esk10265_4(X1,X2,X3,X4) ) ).

cnf(i_0_9739,axiom,
    ( esk10221_4(X1,X2,X3,X4)
    | esk10234_4(X1,X2,X3,X4) ) ).

cnf(i_0_9740,axiom,
    ( ~ esk14374_4(X1,X2,X3,X4)
    | esk14632_4(X1,X2,X3,X4) ) ).

cnf(i_0_9741,axiom,
    ( ~ esk11481_4(X1,X2,X3,X4)
    | esk11461_4(X1,X2,X3,X4)
    | esk11485_4(X1,X2,X3,X4) ) ).

cnf(i_0_9742,axiom,
    ( esk11324_4(X1,X2,X3,X4)
    | ~ esk11323_4(X1,X2,X3,X4) ) ).

cnf(i_0_9743,axiom,
    ( ~ esk9746_4(X1,X2,X3,X4)
    | esk10004_4(X1,X2,X3,X4) ) ).

cnf(i_0_9744,axiom,
    ( esk3284_4(X1,X2,X3,X4)
    | esk3302_4(X1,X2,X3,X4) ) ).

cnf(i_0_9745,axiom,
    ( esk15061_4(X1,X2,X3,X4)
    | esk15062_4(X1,X2,X3,X4) ) ).

cnf(i_0_9746,axiom,
    ( esk3403_4(X1,X2,X3,X4)
    | ~ esk3380_4(X1,X2,X3,X4)
    | esk3320_4(X1,X2,X3,X4) ) ).

cnf(i_0_9747,axiom,
    ( ~ esk7638_4(X1,X2,X3,X4)
    | ~ esk7678_4(X1,X2,X3,X4)
    | ~ esk7679_4(X1,X2,X3,X4) ) ).

cnf(i_0_9748,axiom,
    ( esk16110_4(X1,X2,X3,X4)
    | ~ esk15852_4(X1,X2,X3,X4) ) ).

cnf(i_0_9749,axiom,
    ( esk3133_4(X1,X2,X3,X4)
    | esk3047_4(X1,X2,X3,X4) ) ).

cnf(i_0_9750,axiom,
    ( esk11089_4(X1,X2,X3,X4)
    | ~ esk11114_4(X1,X2,X3,X4)
    | esk11088_4(X1,X2,X3,X4) ) ).

cnf(i_0_9751,axiom,
    ( esk14973_4(X1,X2,X3,X4)
    | ~ esk14972_4(X1,X2,X3,X4) ) ).

cnf(i_0_9752,axiom,
    ( ~ esk13518_4(X1,X2,X3,X4)
    | esk13776_4(X1,X2,X3,X4) ) ).

cnf(i_0_9753,axiom,
    ( esk8756_4(X1,X2,X3,X4)
    | ~ esk8755_4(X1,X2,X3,X4)
    | ~ esk8754_4(X1,X2,X3,X4) ) ).

cnf(i_0_9754,axiom,
    ( esk1221_4(X1,X2,X3,X4)
    | esk1238_4(X1,X2,X3,X4) ) ).

cnf(i_0_9755,axiom,
    ( esk14931_4(X1,X2,X3,X4)
    | esk14913_4(X1,X2,X3,X4) ) ).

cnf(i_0_9756,axiom,
    ( esk12437_4(X1,X2,X3,X4)
    | ~ esk12472_4(X1,X2,X3,X4) ) ).

cnf(i_0_9757,axiom,
    ( esk1754_4(X1,X2,X3,X4)
    | esk1742_4(X1,X2,X3,X4) ) ).

cnf(i_0_9758,axiom,
    ( esk4818_4(X1,X2,X3,X4)
    | ~ esk4869_4(X1,X2,X3,X4) ) ).

cnf(i_0_9759,axiom,
    ( esk9143_4(X1,X2,X3,X4)
    | ~ esk9132_4(X1,X2,X3,X4) ) ).

cnf(i_0_9760,axiom,
    ( ~ esk6935_4(X1,X2,X3,X4)
    | esk7193_4(X1,X2,X3,X4) ) ).

cnf(i_0_9761,axiom,
    ( ~ esk5689_4(X1,X2,X3,X4)
    | esk5721_4(X1,X2,X3,X4) ) ).

cnf(i_0_9762,axiom,
    ( ~ esk16052_4(X1,X2,X3,X4)
    | esk16114_4(X1,X2,X3,X4) ) ).

cnf(i_0_9763,axiom,
    ( ~ esk13819_4(X1,X2,X3,X4)
    | ~ esk13765_4(X1,X2,X3,X4) ) ).

cnf(i_0_9764,axiom,
    ( ~ esk7344_4(X1,X2,X3,X4)
    | ~ esk7436_4(X1,X2,X3,X4)
    | esk7336_4(X1,X2,X3,X4) ) ).

cnf(i_0_9765,axiom,
    ( ~ esk14503_4(X1,X2,X3,X4)
    | esk14533_4(X1,X2,X3,X4) ) ).

cnf(i_0_9766,axiom,
    ( esk7154_4(X1,X2,X3,X4)
    | esk7137_4(X1,X2,X3,X4) ) ).

cnf(i_0_9767,axiom,
    ( esk10456_4(X1,X2,X3,X4)
    | esk10457_4(X1,X2,X3,X4) ) ).

cnf(i_0_9768,axiom,
    ( esk14604_4(X1,X2,X3,X4)
    | esk14718_4(X1,X2,X3,X4) ) ).

cnf(i_0_9769,axiom,
    ( ~ esk10530_4(X1,X2,X3,X4)
    | esk10584_4(X1,X2,X3,X4) ) ).

cnf(i_0_9770,axiom,
    ( ~ esk14292_4(X1,X2,X3,X4)
    | esk14550_4(X1,X2,X3,X4) ) ).

cnf(i_0_9771,axiom,
    ( ~ esk15688_4(X1,X2,X3,X4)
    | esk15689_4(X1,X2,X3,X4) ) ).

cnf(i_0_9772,axiom,
    ( ~ esk12745_4(X1,X2,X3,X4)
    | esk12767_4(X1,X2,X3,X4) ) ).

cnf(i_0_9773,axiom,
    ( ~ esk9098_4(X1,X2,X3,X4)
    | esk9129_4(X1,X2,X3,X4) ) ).

cnf(i_0_9774,axiom,
    ( ~ esk9731_4(X1,X2,X3,X4)
    | ~ esk9696_4(X1,X2,X3,X4)
    | ~ esk9730_4(X1,X2,X3,X4) ) ).

cnf(i_0_9775,axiom,
    ( ~ esk10189_4(X1,X2,X3,X4)
    | esk10188_4(X1,X2,X3,X4) ) ).

cnf(i_0_9776,axiom,
    ( esk2608_4(X1,X2,X3,X4)
    | esk2555_4(X1,X2,X3,X4) ) ).

cnf(i_0_9777,axiom,
    ( ~ esk1535_4(X1,X2,X3,X4)
    | ~ esk1433_4(X1,X2,X3,X4)
    | esk1415_4(X1,X2,X3,X4) ) ).

cnf(i_0_9778,axiom,
    ( esk14160_4(X1,X2,X3,X4)
    | esk14188_4(X1,X2,X3,X4) ) ).

cnf(i_0_9779,axiom,
    ( esk5595_4(X1,X2,X3,X4)
    | esk5606_4(X1,X2,X3,X4) ) ).

cnf(i_0_9780,axiom,
    ( ~ esk15990_4(X1,X2,X3,X4)
    | esk15988_4(X1,X2,X3,X4) ) ).

cnf(i_0_9781,axiom,
    ( esk16142_4(X1,X2,X3,X4)
    | esk16128_4(X1,X2,X3,X4) ) ).

cnf(i_0_9782,axiom,
    ( esk3629_4(X1,X2,X3,X4)
    | esk3643_4(X1,X2,X3,X4) ) ).

cnf(i_0_9783,axiom,
    ( ~ esk493_4(X1,X2,X3,X4)
    | ~ p(X1)
    | esk85_0
    | p(X4)
    | p(X3)
    | p(X2) ) ).

cnf(i_0_9784,axiom,
    ( ~ esk14017_4(X1,X2,X3,X4)
    | esk14026_4(X1,X2,X3,X4) ) ).

cnf(i_0_9785,axiom,
    ( ~ esk14430_4(X1,X2,X3,X4)
    | ~ esk14375_4(X1,X2,X3,X4)
    | ~ esk14377_4(X1,X2,X3,X4)
    | ~ esk14428_4(X1,X2,X3,X4) ) ).

cnf(i_0_9786,axiom,
    ( esk3222_4(X1,X2,X3,X4)
    | ~ esk3198_4(X1,X2,X3,X4) ) ).

cnf(i_0_9787,axiom,
    ( ~ esk6491_4(X1,X2,X3,X4)
    | esk6492_4(X1,X2,X3,X4) ) ).

cnf(i_0_9788,axiom,
    ( esk2523_4(X1,X2,X3,X4)
    | esk2513_4(X1,X2,X3,X4) ) ).

cnf(i_0_9789,axiom,
    ( ~ esk14177_4(X1,X2,X3,X4)
    | esk14176_4(X1,X2,X3,X4)
    | esk14126_4(X1,X2,X3,X4) ) ).

cnf(i_0_9790,axiom,
    ( ~ esk4432_4(X1,X2,X3,X4)
    | ~ esk4318_4(X1,X2,X3,X4)
    | ~ esk4312_4(X1,X2,X3,X4) ) ).

cnf(i_0_9791,axiom,
    ( ~ esk11968_4(X1,X2,X3,X4)
    | esk11967_4(X1,X2,X3,X4) ) ).

cnf(i_0_9792,axiom,
    ( esk7446_4(X1,X2,X3,X4)
    | esk7485_4(X1,X2,X3,X4) ) ).

cnf(i_0_9793,axiom,
    ( ~ esk3144_4(X1,X2,X3,X4)
    | esk3142_4(X1,X2,X3,X4) ) ).

cnf(i_0_9794,axiom,
    ( esk14124_4(X1,X2,X3,X4)
    | ~ esk14175_4(X1,X2,X3,X4)
    | esk14168_4(X1,X2,X3,X4) ) ).

cnf(i_0_9795,axiom,
    ( esk3348_4(X1,X2,X3,X4)
    | ~ esk3399_4(X1,X2,X3,X4)
    | esk3398_4(X1,X2,X3,X4) ) ).

cnf(i_0_9796,axiom,
    ( esk6155_4(X1,X2,X3,X4)
    | ~ esk5897_4(X1,X2,X3,X4) ) ).

cnf(i_0_9797,axiom,
    ( ~ esk12363_4(X1,X2,X3,X4)
    | ~ esk12337_4(X1,X2,X3,X4)
    | ~ esk12388_4(X1,X2,X3,X4) ) ).

cnf(i_0_9798,axiom,
    ( esk4268_4(X1,X2,X3,X4)
    | esk4273_4(X1,X2,X3,X4)
    | esk4274_4(X1,X2,X3,X4) ) ).

cnf(i_0_9799,axiom,
    ( ~ esk9669_4(X1,X2,X3,X4)
    | ~ esk9671_4(X1,X2,X3,X4) ) ).

cnf(i_0_9800,axiom,
    ( esk12884_4(X1,X2,X3,X4)
    | esk12916_4(X1,X2,X3,X4) ) ).

cnf(i_0_9801,axiom,
    ( ~ esk12126_4(X1,X2,X3,X4)
    | esk12072_4(X1,X2,X3,X4)
    | esk12110_4(X1,X2,X3,X4) ) ).

cnf(i_0_9802,axiom,
    ( ~ esk14800_4(X1,X2,X3,X4)
    | ~ esk14798_4(X1,X2,X3,X4) ) ).

cnf(i_0_9803,axiom,
    ( ~ esk12829_4(X1,X2,X3,X4)
    | esk12874_4(X1,X2,X3,X4)
    | ~ esk12889_4(X1,X2,X3,X4) ) ).

cnf(i_0_9804,axiom,
    ( esk14869_4(X1,X2,X3,X4)
    | esk14955_4(X1,X2,X3,X4) ) ).

cnf(i_0_9805,axiom,
    ( ~ esk6782_4(X1,X2,X3,X4)
    | esk6825_4(X1,X2,X3,X4) ) ).

cnf(i_0_9806,axiom,
    ( ~ esk4870_4(X1,X2,X3,X4)
    | esk4951_4(X1,X2,X3,X4) ) ).

cnf(i_0_9807,axiom,
    ( ~ esk6706_4(X1,X2,X3,X4)
    | esk6721_4(X1,X2,X3,X4) ) ).

cnf(i_0_9808,axiom,
    ( ~ esk16387_4(X1,X2,X3,X4)
    | esk16426_4(X1,X2,X3,X4) ) ).

cnf(i_0_9809,axiom,
    ( ~ esk9253_4(X1,X2,X3,X4)
    | ~ esk9304_4(X1,X2,X3,X4)
    | ~ esk9279_4(X1,X2,X3,X4) ) ).

cnf(i_0_9810,axiom,
    ( ~ p(X3)
    | p(X2)
    | ~ p(X4)
    | p(X1)
    | esk35_0
    | ~ esk415_4(X1,X2,X3,X4) ) ).

cnf(i_0_9811,axiom,
    ( ~ esk13172_4(X1,X2,X3,X4)
    | ~ esk13143_4(X1,X2,X3,X4)
    | ~ esk13092_4(X1,X2,X3,X4) ) ).

cnf(i_0_9812,axiom,
    ( esk10428_4(X1,X2,X3,X4)
    | ~ esk10421_4(X1,X2,X3,X4) ) ).

cnf(i_0_9813,axiom,
    ( ~ esk14524_4(X1,X2,X3,X4)
    | esk14540_4(X1,X2,X3,X4) ) ).

cnf(i_0_9814,axiom,
    ( ~ esk7683_4(X1,X2,X3,X4)
    | ~ esk7636_4(X1,X2,X3,X4)
    | ~ esk7682_4(X1,X2,X3,X4) ) ).

cnf(i_0_9815,axiom,
    ( ~ esk491_4(X1,X2,X3,X4)
    | ~ p(X1)
    | ~ p(X3)
    | ~ p(X4)
    | p(X2)
    | esk73_0 ) ).

cnf(i_0_9816,axiom,
    ( ~ esk3123_4(X1,X2,X3,X4)
    | esk3063_4(X1,X2,X3,X4)
    | esk3146_4(X1,X2,X3,X4) ) ).

cnf(i_0_9817,axiom,
    ( esk5819_4(X1,X2,X3,X4)
    | ~ esk5815_4(X1,X2,X3,X4) ) ).

cnf(i_0_9818,axiom,
    ( esk7674_4(X1,X2,X3,X4)
    | esk7651_4(X1,X2,X3,X4) ) ).

cnf(i_0_9819,axiom,
    ( ~ esk10741_4(X1,X2,X3,X4)
    | ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10856_4(X1,X2,X3,X4) ) ).

cnf(i_0_9820,axiom,
    ( ~ esk10816_4(X1,X2,X3,X4)
    | ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10769_4(X1,X2,X3,X4) ) ).

cnf(i_0_9821,axiom,
    ( esk1867_4(X1,X2,X3,X4)
    | ~ esk1786_4(X1,X2,X3,X4) ) ).

cnf(i_0_9822,axiom,
    ( ~ esk7416_4(X1,X2,X3,X4)
    | ~ esk7384_4(X1,X2,X3,X4)
    | ~ esk7415_4(X1,X2,X3,X4) ) ).

cnf(i_0_9823,axiom,
    ( esk7910_4(X1,X2,X3,X4)
    | esk7930_4(X1,X2,X3,X4) ) ).

cnf(i_0_9824,axiom,
    ( esk9558_4(X1,X2,X3,X4)
    | ~ esk9539_4(X1,X2,X3,X4)
    | esk9504_4(X1,X2,X3,X4) ) ).

cnf(i_0_9825,axiom,
    ( esk8994_4(X1,X2,X3,X4)
    | esk9024_4(X1,X2,X3,X4) ) ).

cnf(i_0_9826,axiom,
    ( ~ esk1315_4(X1,X2,X3,X4)
    | ~ esk1280_4(X1,X2,X3,X4)
    | ~ esk1316_4(X1,X2,X3,X4) ) ).

cnf(i_0_9827,axiom,
    ( esk4439_4(X1,X2,X3,X4)
    | esk4370_4(X1,X2,X3,X4) ) ).

cnf(i_0_9828,axiom,
    ( esk5434_4(X1,X2,X3,X4)
    | esk5435_4(X1,X2,X3,X4)
    | esk5436_4(X1,X2,X3,X4) ) ).

cnf(i_0_9829,axiom,
    ( ~ esk513_4(X1,X2,X3,X4)
    | ~ p(X2)
    | esk240_0
    | p(X3)
    | ~ p(X4)
    | ~ p(X1) ) ).

cnf(i_0_9830,axiom,
    ( ~ esk14921_4(X1,X2,X3,X4)
    | ~ esk14796_4(X1,X2,X3,X4) ) ).

cnf(i_0_9831,axiom,
    ( esk14972_4(X1,X2,X3,X4)
    | esk14940_4(X1,X2,X3,X4) ) ).

cnf(i_0_9832,axiom,
    ( ~ esk6414_4(X1,X2,X3,X4)
    | ~ esk6458_4(X1,X2,X3,X4)
    | ~ esk6465_4(X1,X2,X3,X4) ) ).

cnf(i_0_9833,axiom,
    ( ~ esk9915_4(X1,X2,X3,X4)
    | ~ esk9913_4(X1,X2,X3,X4) ) ).

cnf(i_0_9834,axiom,
    ( ~ esk12277_4(X1,X2,X3,X4)
    | ~ esk12257_4(X1,X2,X3,X4) ) ).

cnf(i_0_9835,axiom,
    ( ~ esk14544_4(X1,X2,X3,X4)
    | esk14566_4(X1,X2,X3,X4) ) ).

cnf(i_0_9836,axiom,
    ( ~ esk14275_4(X1,X2,X3,X4)
    | esk14375_4(X1,X2,X3,X4) ) ).

cnf(i_0_9837,axiom,
    ( esk511_4(X1,X2,X3,X4)
    | esk542_4(X1,X2,X3,X4) ) ).

cnf(i_0_9838,axiom,
    ( esk10240_4(X1,X2,X3,X4)
    | esk10273_4(X1,X2,X3,X4) ) ).

cnf(i_0_9839,axiom,
    ( ~ esk3874_4(X1,X2,X3,X4)
    | esk4132_4(X1,X2,X3,X4) ) ).

cnf(i_0_9840,axiom,
    ( esk4638_4(X1,X2,X3,X4)
    | ~ esk4637_4(X1,X2,X3,X4) ) ).

cnf(i_0_9841,axiom,
    ( esk8258_4(X1,X2,X3,X4)
    | esk8290_4(X1,X2,X3,X4) ) ).

cnf(i_0_9842,axiom,
    ( ~ esk2711_4(X1,X2,X3,X4)
    | esk2681_4(X1,X2,X3,X4) ) ).

cnf(i_0_9843,axiom,
    ( ~ esk919_4(X1,X2,X3,X4)
    | esk901_4(X1,X2,X3,X4)
    | ~ esk1021_4(X1,X2,X3,X4) ) ).

cnf(i_0_9844,axiom,
    ( esk3796_4(X1,X2,X3,X4)
    | esk3815_4(X1,X2,X3,X4) ) ).

cnf(i_0_9845,axiom,
    ( esk15430_4(X1,X2,X3,X4)
    | ~ esk15431_4(X1,X2,X3,X4) ) ).

cnf(i_0_9846,axiom,
    ( ~ esk10171_4(X1,X2,X3,X4)
    | ~ esk10287_4(X1,X2,X3,X4)
    | esk10166_4(X1,X2,X3,X4) ) ).

cnf(i_0_9847,axiom,
    ( esk4436_4(X1,X2,X3,X4)
    | ~ esk4404_4(X1,X2,X3,X4) ) ).

cnf(i_0_9848,axiom,
    ( esk10261_4(X1,X2,X3,X4)
    | esk10317_4(X1,X2,X3,X4) ) ).

cnf(i_0_9849,axiom,
    ( ~ esk14533_4(X1,X2,X3,X4)
    | esk14503_4(X1,X2,X3,X4) ) ).

cnf(i_0_9850,axiom,
    ( esk14279_4(X1,X2,X3,X4)
    | esk14334_4(X1,X2,X3,X4) ) ).

cnf(i_0_9851,axiom,
    ( esk2516_4(X1,X2,X3,X4)
    | esk2511_4(X1,X2,X3,X4) ) ).

cnf(i_0_9852,axiom,
    ( esk8427_4(X1,X2,X3,X4)
    | esk8422_4(X1,X2,X3,X4) ) ).

cnf(i_0_9853,axiom,
    ( ~ esk8515_4(X1,X2,X3,X4)
    | esk8549_4(X1,X2,X3,X4) ) ).

cnf(i_0_9854,axiom,
    ( esk5422_4(X1,X2,X3,X4)
    | esk5404_4(X1,X2,X3,X4) ) ).

cnf(i_0_9855,axiom,
    ( esk4538_4(X1,X2,X3,X4)
    | ~ esk4531_4(X1,X2,X3,X4) ) ).

cnf(i_0_9856,axiom,
    ( esk10701_4(X1,X2,X3,X4)
    | ~ esk10695_4(X1,X2,X3,X4) ) ).

cnf(i_0_9857,axiom,
    ( esk5933_4(X1,X2,X3,X4)
    | esk5886_4(X1,X2,X3,X4) ) ).

cnf(i_0_9858,axiom,
    ( esk11119_4(X1,X2,X3,X4)
    | ~ esk11120_4(X1,X2,X3,X4) ) ).

cnf(i_0_9859,axiom,
    ( esk11249_4(X1,X2,X3,X4)
    | esk11258_4(X1,X2,X3,X4) ) ).

cnf(i_0_9860,axiom,
    ( esk7400_4(X1,X2,X3,X4)
    | esk7392_4(X1,X2,X3,X4) ) ).

cnf(i_0_9861,axiom,
    ( ~ esk5293_4(X1,X2,X3,X4)
    | esk5313_4(X1,X2,X3,X4) ) ).

cnf(i_0_9862,axiom,
    ( esk16648_4(X1,X2,X3,X4)
    | esk16652_4(X1,X2,X3,X4) ) ).

cnf(i_0_9863,axiom,
    ( ~ p(X1)
    | ~ esk491_4(X1,X2,X3,X4)
    | ~ p(X4)
    | p(X3)
    | ~ p(X2)
    | esk75_0 ) ).

cnf(i_0_9864,axiom,
    ( ~ esk5813_4(X1,X2,X3,X4)
    | esk5819_4(X1,X2,X3,X4) ) ).

cnf(i_0_9865,axiom,
    ( ~ esk15875_4(X1,X2,X3,X4)
    | ~ esk15931_4(X1,X2,X3,X4)
    | ~ esk15898_4(X1,X2,X3,X4) ) ).

cnf(i_0_9866,axiom,
    ( esk1658_4(X1,X2,X3,X4)
    | ~ esk1809_4(X1,X2,X3,X4)
    | esk1689_4(X1,X2,X3,X4) ) ).

cnf(i_0_9867,axiom,
    ( esk3988_4(X1,X2,X3,X4)
    | ~ esk3959_4(X1,X2,X3,X4) ) ).

cnf(i_0_9868,axiom,
    ( ~ esk16774_4(X1,X2,X3,X4)
    | esk16772_4(X1,X2,X3,X4) ) ).

cnf(i_0_9869,axiom,
    ( ~ esk412_4(X1,X2,X3,X4)
    | ~ p(X1)
    | esk26_0
    | p(X2)
    | ~ p(X4)
    | p(X3) ) ).

cnf(i_0_9870,axiom,
    ( esk7320_4(X1,X2,X3,X4)
    | esk7343_4(X1,X2,X3,X4)
    | esk7345_4(X1,X2,X3,X4) ) ).

cnf(i_0_9871,axiom,
    ( esk7426_4(X1,X2,X3,X4)
    | esk7513_4(X1,X2,X3,X4) ) ).

cnf(i_0_9872,axiom,
    ( esk4810_4(X1,X2,X3,X4)
    | esk4853_4(X1,X2,X3,X4) ) ).

cnf(i_0_9873,axiom,
    ( ~ esk10698_4(X1,X2,X3,X4)
    | ~ esk10700_4(X1,X2,X3,X4) ) ).

cnf(i_0_9874,axiom,
    ( ~ esk5380_4(X1,X2,X3,X4)
    | ~ esk5382_4(X1,X2,X3,X4)
    | ~ esk5435_4(X1,X2,X3,X4)
    | ~ esk5433_4(X1,X2,X3,X4) ) ).

cnf(i_0_9875,axiom,
    ( esk948_4(X1,X2,X3,X4)
    | esk947_4(X1,X2,X3,X4) ) ).

cnf(i_0_9876,axiom,
    ( esk4390_4(X1,X2,X3,X4)
    | esk4389_4(X1,X2,X3,X4) ) ).

cnf(i_0_9877,axiom,
    ( ~ esk3124_4(X1,X2,X3,X4)
    | esk3117_4(X1,X2,X3,X4)
    | esk3073_4(X1,X2,X3,X4) ) ).

cnf(i_0_9878,axiom,
    ( ~ esk10250_4(X1,X2,X3,X4)
    | ~ esk10207_4(X1,X2,X3,X4)
    | ~ esk10251_4(X1,X2,X3,X4) ) ).

cnf(i_0_9879,axiom,
    ( ~ esk3775_4(X1,X2,X3,X4)
    | esk3771_4(X1,X2,X3,X4) ) ).

cnf(i_0_9880,axiom,
    ( p(X4)
    | ~ esk493_4(X1,X2,X3,X4)
    | p(X1)
    | ~ p(X2)
    | ~ p(X3)
    | esk83_0 ) ).

cnf(i_0_9881,axiom,
    ( esk16701_4(X1,X2,X3,X4)
    | p(X1)
    | ~ esk216_0
    | ~ p(X3)
    | ~ p(X4)
    | p(X2) ) ).

cnf(i_0_9882,axiom,
    ( ~ esk9064_4(X1,X2,X3,X4)
    | esk9063_4(X1,X2,X3,X4) ) ).

cnf(i_0_9883,axiom,
    ( ~ esk5645_4(X1,X2,X3,X4)
    | ~ esk5726_4(X1,X2,X3,X4) ) ).

cnf(i_0_9884,axiom,
    ( esk2606_4(X1,X2,X3,X4)
    | esk2641_4(X1,X2,X3,X4) ) ).

cnf(i_0_9885,axiom,
    ( esk11444_4(X1,X2,X3,X4)
    | ~ esk11409_4(X1,X2,X3,X4) ) ).

cnf(i_0_9886,axiom,
    ( esk1067_4(X1,X2,X3,X4)
    | esk1090_4(X1,X2,X3,X4)
    | ~ esk1007_4(X1,X2,X3,X4) ) ).

cnf(i_0_9887,axiom,
    ( ~ esk2453_4(X1,X2,X3,X4)
    | esk2425_4(X1,X2,X3,X4) ) ).

cnf(i_0_9888,axiom,
    ( ~ esk12752_4(X1,X2,X3,X4)
    | ~ esk12751_4(X1,X2,X3,X4) ) ).

cnf(i_0_9889,axiom,
    ( esk8396_4(X1,X2,X3,X4)
    | ~ esk8398_4(X1,X2,X3,X4) ) ).

cnf(i_0_9890,axiom,
    ( ~ esk3207_4(X1,X2,X3,X4)
    | ~ esk3234_4(X1,X2,X3,X4) ) ).

cnf(i_0_9891,axiom,
    ( esk9556_4(X1,X2,X3,X4)
    | ~ esk9557_4(X1,X2,X3,X4) ) ).

cnf(i_0_9892,axiom,
    ( esk8259_4(X1,X2,X3,X4)
    | esk8211_4(X1,X2,X3,X4) ) ).

cnf(i_0_9893,axiom,
    ( esk10850_4(X1,X2,X3,X4)
    | ~ esk10848_4(X1,X2,X3,X4)
    | ~ esk10849_4(X1,X2,X3,X4) ) ).

cnf(i_0_9894,axiom,
    ( ~ esk11181_4(X1,X2,X3,X4)
    | esk11301_4(X1,X2,X3,X4) ) ).

cnf(i_0_9895,axiom,
    ( esk1798_4(X1,X2,X3,X4)
    | ~ esk1540_4(X1,X2,X3,X4) ) ).

cnf(i_0_9896,axiom,
    ( esk4262_4(X1,X2,X3,X4)
    | esk4261_4(X1,X2,X3,X4) ) ).

cnf(i_0_9897,axiom,
    ( ~ esk6830_4(X1,X2,X3,X4)
    | esk6806_4(X1,X2,X3,X4) ) ).

cnf(i_0_9898,axiom,
    ( esk4396_4(X1,X2,X3,X4)
    | esk4398_4(X1,X2,X3,X4) ) ).

cnf(i_0_9899,axiom,
    ( ~ esk1556_4(X1,X2,X3,X4)
    | esk1558_4(X1,X2,X3,X4) ) ).

cnf(i_0_9900,axiom,
    ( ~ esk3756_4(X1,X2,X3,X4)
    | esk3498_4(X1,X2,X3,X4) ) ).

cnf(i_0_9901,axiom,
    ( ~ esk4844_4(X1,X2,X3,X4)
    | ~ esk4826_4(X1,X2,X3,X4)
    | ~ esk4931_4(X1,X2,X3,X4) ) ).

cnf(i_0_9902,axiom,
    ( ~ esk13634_4(X1,X2,X3,X4)
    | esk13376_4(X1,X2,X3,X4) ) ).

cnf(i_0_9903,axiom,
    ( ~ esk12212_4(X1,X2,X3,X4)
    | esk12335_4(X1,X2,X3,X4) ) ).

cnf(i_0_9904,axiom,
    ( ~ esk7934_4(X1,X2,X3,X4)
    | ~ esk7910_4(X1,X2,X3,X4)
    | ~ esk8040_4(X1,X2,X3,X4) ) ).

cnf(i_0_9905,axiom,
    ( esk3978_4(X1,X2,X3,X4)
    | esk3975_4(X1,X2,X3,X4)
    | esk4005_4(X1,X2,X3,X4)
    | esk3977_4(X1,X2,X3,X4)
    | esk3953_4(X1,X2,X3,X4) ) ).

cnf(i_0_9906,axiom,
    ( ~ esk13355_4(X1,X2,X3,X4)
    | esk13097_4(X1,X2,X3,X4) ) ).

cnf(i_0_9907,axiom,
    ( esk6338_4(X1,X2,X3,X4)
    | ~ esk6337_4(X1,X2,X3,X4)
    | ~ esk6336_4(X1,X2,X3,X4) ) ).

cnf(i_0_9908,axiom,
    ( esk4627_4(X1,X2,X3,X4)
    | esk4653_4(X1,X2,X3,X4)
    | ~ esk4678_4(X1,X2,X3,X4) ) ).

cnf(i_0_9909,axiom,
    ( ~ esk6708_4(X1,X2,X3,X4)
    | ~ esk6685_4(X1,X2,X3,X4) ) ).

cnf(i_0_9910,axiom,
    ( esk8629_4(X1,X2,X3,X4)
    | ~ esk8613_4(X1,X2,X3,X4) ) ).

cnf(i_0_9911,axiom,
    ( ~ esk14815_4(X1,X2,X3,X4)
    | esk14813_4(X1,X2,X3,X4) ) ).

cnf(i_0_9912,axiom,
    ( esk13120_4(X1,X2,X3,X4)
    | ~ esk12862_4(X1,X2,X3,X4) ) ).

cnf(i_0_9913,axiom,
    ( esk13581_4(X1,X2,X3,X4)
    | esk13553_4(X1,X2,X3,X4) ) ).

cnf(i_0_9914,axiom,
    ( esk1417_4(X1,X2,X3,X4)
    | ~ esk1390_4(X1,X2,X3,X4) ) ).

cnf(i_0_9915,axiom,
    ( esk13684_4(X1,X2,X3,X4)
    | esk13570_4(X1,X2,X3,X4) ) ).

cnf(i_0_9916,axiom,
    ( esk7960_4(X1,X2,X3,X4)
    | esk7999_4(X1,X2,X3,X4) ) ).

cnf(i_0_9917,axiom,
    ( ~ esk6731_4(X1,X2,X3,X4)
    | ~ esk6677_4(X1,X2,X3,X4)
    | ~ esk6712_4(X1,X2,X3,X4) ) ).

cnf(i_0_9918,axiom,
    ( esk6951_4(X1,X2,X3,X4)
    | ~ esk7209_4(X1,X2,X3,X4) ) ).

cnf(i_0_9919,axiom,
    ( esk14569_4(X1,X2,X3,X4)
    | esk14568_4(X1,X2,X3,X4) ) ).

cnf(i_0_9920,axiom,
    ( esk10538_4(X1,X2,X3,X4)
    | ~ esk10280_4(X1,X2,X3,X4) ) ).

cnf(i_0_9921,axiom,
    ( ~ esk12250_4(X1,X2,X3,X4)
    | esk12251_4(X1,X2,X3,X4) ) ).

cnf(i_0_9922,axiom,
    ( esk957_4(X1,X2,X3,X4)
    | ~ esk1026_4(X1,X2,X3,X4) ) ).

cnf(i_0_9923,axiom,
    ( esk11763_4(X1,X2,X3,X4)
    | esk11784_4(X1,X2,X3,X4) ) ).

cnf(i_0_9924,axiom,
    ( esk15107_4(X1,X2,X3,X4)
    | esk15104_4(X1,X2,X3,X4) ) ).

cnf(i_0_9925,axiom,
    ( ~ esk11793_4(X1,X2,X3,X4)
    | ~ esk11878_4(X1,X2,X3,X4)
    | ~ esk11765_4(X1,X2,X3,X4) ) ).

cnf(i_0_9926,axiom,
    ( ~ esk2811_4(X1,X2,X3,X4)
    | esk3069_4(X1,X2,X3,X4) ) ).

cnf(i_0_9927,axiom,
    ( esk8032_4(X1,X2,X3,X4)
    | esk7952_4(X1,X2,X3,X4)
    | ~ esk8003_4(X1,X2,X3,X4) ) ).

cnf(i_0_9928,axiom,
    ( esk3498_4(X1,X2,X3,X4)
    | ~ esk3507_4(X1,X2,X3,X4) ) ).

cnf(i_0_9929,axiom,
    ( esk7735_4(X1,X2,X3,X4)
    | esk7717_4(X1,X2,X3,X4) ) ).

cnf(i_0_9930,axiom,
    ( ~ p(X2)
    | esk270_0
    | p(X3)
    | ~ esk16707_4(X1,X2,X3,X4)
    | ~ p(X1)
    | p(X4) ) ).

cnf(i_0_9931,axiom,
    ( esk6559_4(X1,X2,X3,X4)
    | ~ esk6528_4(X1,X2,X3,X4) ) ).

cnf(i_0_9932,axiom,
    ( esk14614_4(X1,X2,X3,X4)
    | esk14592_4(X1,X2,X3,X4) ) ).

cnf(i_0_9933,axiom,
    ( esk6156_4(X1,X2,X3,X4)
    | ~ esk6102_4(X1,X2,X3,X4) ) ).

cnf(i_0_9934,axiom,
    ( ~ esk14505_4(X1,X2,X3,X4)
    | esk14531_4(X1,X2,X3,X4) ) ).

cnf(i_0_9935,axiom,
    ( esk13100_4(X1,X2,X3,X4)
    | ~ esk12842_4(X1,X2,X3,X4) ) ).

cnf(i_0_9936,axiom,
    ( esk7344_4(X1,X2,X3,X4)
    | ~ esk7329_4(X1,X2,X3,X4) ) ).

cnf(i_0_9937,axiom,
    ( esk12144_4(X1,X2,X3,X4)
    | esk12064_4(X1,X2,X3,X4)
    | ~ esk12115_4(X1,X2,X3,X4) ) ).

cnf(i_0_9938,axiom,
    ( ~ esk12948_4(X1,X2,X3,X4)
    | ~ esk13000_4(X1,X2,X3,X4) ) ).

cnf(i_0_9939,axiom,
    ( esk8422_4(X1,X2,X3,X4)
    | esk8445_4(X1,X2,X3,X4) ) ).

cnf(i_0_9940,axiom,
    ( esk3273_4(X1,X2,X3,X4)
    | ~ esk3333_4(X1,X2,X3,X4) ) ).

cnf(i_0_9941,axiom,
    ( esk14560_4(X1,X2,X3,X4)
    | ~ esk14559_4(X1,X2,X3,X4) ) ).

cnf(i_0_9942,axiom,
    ( esk14951_4(X1,X2,X3,X4)
    | esk14937_4(X1,X2,X3,X4) ) ).

cnf(i_0_9943,axiom,
    ( esk6087_4(X1,X2,X3,X4)
    | ~ esk5829_4(X1,X2,X3,X4) ) ).

cnf(i_0_9944,axiom,
    ( ~ esk3122_4(X1,X2,X3,X4)
    | ~ esk3067_4(X1,X2,X3,X4)
    | ~ esk3120_4(X1,X2,X3,X4)
    | ~ esk3069_4(X1,X2,X3,X4) ) ).

cnf(i_0_9945,axiom,
    ( ~ esk14326_4(X1,X2,X3,X4)
    | esk14380_4(X1,X2,X3,X4) ) ).

cnf(i_0_9946,axiom,
    ( ~ esk5027_4(X1,X2,X3,X4)
    | ~ esk5082_4(X1,X2,X3,X4) ) ).

cnf(i_0_9947,axiom,
    ( esk3828_4(X1,X2,X3,X4)
    | esk3781_4(X1,X2,X3,X4) ) ).

cnf(i_0_9948,axiom,
    ( esk6303_4(X1,X2,X3,X4)
    | ~ esk6270_4(X1,X2,X3,X4) ) ).

cnf(i_0_9949,axiom,
    ( ~ esk5176_4(X1,X2,X3,X4)
    | ~ esk5125_4(X1,X2,X3,X4)
    | ~ esk5205_4(X1,X2,X3,X4) ) ).

cnf(i_0_9950,axiom,
    ( esk1284_4(X1,X2,X3,X4)
    | esk1314_4(X1,X2,X3,X4) ) ).

cnf(i_0_9951,axiom,
    ( esk2204_4(X1,X2,X3,X4)
    | ~ esk2196_4(X1,X2,X3,X4) ) ).

cnf(i_0_9952,axiom,
    ( ~ esk11087_4(X1,X2,X3,X4)
    | ~ esk11086_4(X1,X2,X3,X4) ) ).

cnf(i_0_9953,axiom,
    ( ~ esk5545_4(X1,X2,X3,X4)
    | esk5537_4(X1,X2,X3,X4)
    | ~ esk5637_4(X1,X2,X3,X4) ) ).

cnf(i_0_9954,axiom,
    ( ~ esk4872_4(X1,X2,X3,X4)
    | esk4614_4(X1,X2,X3,X4) ) ).

cnf(i_0_9955,axiom,
    ( esk7524_4(X1,X2,X3,X4)
    | esk7489_4(X1,X2,X3,X4) ) ).

cnf(i_0_9956,axiom,
    ( esk15162_4(X1,X2,X3,X4)
    | esk15192_4(X1,X2,X3,X4) ) ).

cnf(i_0_9957,axiom,
    ( esk14682_4(X1,X2,X3,X4)
    | esk14683_4(X1,X2,X3,X4) ) ).

cnf(i_0_9958,axiom,
    ( ~ esk6821_4(X1,X2,X3,X4)
    | esk6830_4(X1,X2,X3,X4) ) ).

cnf(i_0_9959,axiom,
    ( ~ esk13298_4(X1,X2,X3,X4)
    | esk13352_4(X1,X2,X3,X4) ) ).

cnf(i_0_9960,axiom,
    ( esk16207_4(X1,X2,X3,X4)
    | ~ esk16206_4(X1,X2,X3,X4) ) ).

cnf(i_0_9961,axiom,
    ( ~ esk2692_4(X1,X2,X3,X4)
    | ~ esk2720_4(X1,X2,X3,X4) ) ).

cnf(i_0_9962,axiom,
    ( ~ esk9801_4(X1,X2,X3,X4)
    | ~ esk9802_4(X1,X2,X3,X4) ) ).

cnf(i_0_9963,axiom,
    ( esk450_4(X1,X2,X3,X4)
    | esk466_4(X1,X2,X3,X4) ) ).

cnf(i_0_9964,axiom,
    ( esk6167_4(X1,X2,X3,X4)
    | esk6134_4(X1,X2,X3,X4) ) ).

cnf(i_0_9965,axiom,
    ( ~ esk14816_4(X1,X2,X3,X4)
    | esk14817_4(X1,X2,X3,X4) ) ).

cnf(i_0_9966,axiom,
    ( esk3232_4(X1,X2,X3,X4)
    | ~ esk3208_4(X1,X2,X3,X4)
    | ~ esk3235_4(X1,X2,X3,X4) ) ).

cnf(i_0_9967,axiom,
    ( ~ esk8255_4(X1,X2,X3,X4)
    | esk8271_4(X1,X2,X3,X4) ) ).

cnf(i_0_9968,axiom,
    ( ~ esk101_0
    | ~ p(X4)
    | esk495_4(X1,X2,X3,X4)
    | p(X2)
    | p(X3)
    | ~ p(X1) ) ).

cnf(i_0_9969,axiom,
    ( esk15385_4(X1,X2,X3,X4)
    | esk15363_4(X1,X2,X3,X4) ) ).

cnf(i_0_9970,axiom,
    ( ~ esk2718_4(X1,X2,X3,X4)
    | ~ esk2812_4(X1,X2,X3,X4)
    | esk2711_4(X1,X2,X3,X4) ) ).

cnf(i_0_9971,axiom,
    ( ~ esk1558_4(X1,X2,X3,X4)
    | esk1560_4(X1,X2,X3,X4)
    | ~ esk1559_4(X1,X2,X3,X4) ) ).

cnf(i_0_9972,axiom,
    ( esk14340_4(X1,X2,X3,X4)
    | esk14333_4(X1,X2,X3,X4) ) ).

cnf(i_0_9973,axiom,
    ( esk12227_4(X1,X2,X3,X4)
    | ~ esk12222_4(X1,X2,X3,X4) ) ).

cnf(i_0_9974,axiom,
    ( esk551_4(X1,X2,X3,X4)
    | esk552_4(X1,X2,X3,X4)
    | esk553_4(X1,X2,X3,X4) ) ).

cnf(i_0_9975,axiom,
    ( ~ esk13048_4(X1,X2,X3,X4)
    | ~ esk13053_4(X1,X2,X3,X4)
    | ~ esk13086_4(X1,X2,X3,X4) ) ).

cnf(i_0_9976,axiom,
    ( esk12546_4(X1,X2,X3,X4)
    | esk12658_4(X1,X2,X3,X4) ) ).

cnf(i_0_9977,axiom,
    ( esk8205_4(X1,X2,X3,X4)
    | ~ esk8106_4(X1,X2,X3,X4) ) ).

cnf(i_0_9978,axiom,
    ( ~ esk1264_4(X1,X2,X3,X4)
    | esk1166_4(X1,X2,X3,X4)
    | ~ esk1176_4(X1,X2,X3,X4) ) ).

cnf(i_0_9979,axiom,
    ( ~ esk1709_4(X1,X2,X3,X4)
    | esk1710_4(X1,X2,X3,X4) ) ).

cnf(i_0_9980,axiom,
    ( ~ esk1591_4(X1,X2,X3,X4)
    | ~ esk1505_4(X1,X2,X3,X4)
    | ~ esk1485_4(X1,X2,X3,X4) ) ).

cnf(i_0_9981,axiom,
    ( esk2515_4(X1,X2,X3,X4)
    | esk2631_4(X1,X2,X3,X4) ) ).

cnf(i_0_9982,axiom,
    ( esk8794_4(X1,X2,X3,X4)
    | esk8709_4(X1,X2,X3,X4) ) ).

cnf(i_0_9983,axiom,
    ( esk15746_4(X1,X2,X3,X4)
    | ~ esk15744_4(X1,X2,X3,X4)
    | ~ esk15745_4(X1,X2,X3,X4) ) ).

cnf(i_0_9984,axiom,
    ( esk12047_4(X1,X2,X3,X4)
    | esk12080_4(X1,X2,X3,X4) ) ).

cnf(i_0_9985,axiom,
    ( ~ esk13879_4(X1,X2,X3,X4)
    | esk13621_4(X1,X2,X3,X4) ) ).

cnf(i_0_9986,axiom,
    ( ~ esk8462_4(X1,X2,X3,X4)
    | esk8363_4(X1,X2,X3,X4)
    | ~ esk8372_4(X1,X2,X3,X4) ) ).

cnf(i_0_9987,axiom,
    ( ~ esk366_4(X1,X2,X3,X4)
    | esk385_4(X1,X2,X3,X4) ) ).

cnf(i_0_9988,axiom,
    ( esk4868_4(X1,X2,X3,X4)
    | ~ esk4767_4(X1,X2,X3,X4) ) ).

cnf(i_0_9989,axiom,
    ( esk791_4(X1,X2,X3,X4)
    | esk695_4(X1,X2,X3,X4)
    | esk694_4(X1,X2,X3,X4) ) ).

cnf(i_0_9990,axiom,
    ( ~ esk2899_4(X1,X2,X3,X4)
    | ~ esk2860_4(X1,X2,X3,X4) ) ).

cnf(i_0_9991,axiom,
    ( ~ esk9838_4(X1,X2,X3,X4)
    | ~ esk9799_4(X1,X2,X3,X4) ) ).

cnf(i_0_9992,axiom,
    ( ~ esk13914_4(X1,X2,X3,X4)
    | ~ esk13912_4(X1,X2,X3,X4) ) ).

cnf(i_0_9993,axiom,
    ( esk14757_4(X1,X2,X3,X4)
    | ~ esk14778_4(X1,X2,X3,X4) ) ).

cnf(i_0_9994,axiom,
    ( ~ esk8631_4(X1,X2,X3,X4)
    | ~ esk8604_4(X1,X2,X3,X4) ) ).

cnf(i_0_9995,axiom,
    ( esk10802_4(X1,X2,X3,X4)
    | esk10684_4(X1,X2,X3,X4) ) ).

cnf(i_0_9996,axiom,
    ( esk10078_4(X1,X2,X3,X4)
    | ~ esk10048_4(X1,X2,X3,X4) ) ).

cnf(i_0_9997,axiom,
    ( esk12062_4(X1,X2,X3,X4)
    | ~ esk12143_4(X1,X2,X3,X4)
    | esk12150_4(X1,X2,X3,X4) ) ).

cnf(i_0_9998,axiom,
    ( ~ esk758_4(X1,X2,X3,X4)
    | esk839_4(X1,X2,X3,X4) ) ).

cnf(i_0_9999,axiom,
    ( esk13384_4(X1,X2,X3,X4)
    | ~ esk13126_4(X1,X2,X3,X4) ) ).

cnf(i_0_10000,axiom,
    ( ~ esk9494_4(X1,X2,X3,X4)
    | ~ esk9400_4(X1,X2,X3,X4)
    | esk9393_4(X1,X2,X3,X4) ) ).

cnf(i_0_10001,axiom,
    ( ~ esk16556_4(X1,X2,X3,X4)
    | esk16577_4(X1,X2,X3,X4) ) ).

cnf(i_0_10002,axiom,
    ( ~ esk7748_4(X1,X2,X3,X4)
    | esk7747_4(X1,X2,X3,X4)
    | esk7773_4(X1,X2,X3,X4) ) ).

cnf(i_0_10003,axiom,
    ( ~ esk11568_4(X1,X2,X3,X4)
    | esk11443_4(X1,X2,X3,X4)
    | ~ esk11456_4(X1,X2,X3,X4) ) ).

cnf(i_0_10004,axiom,
    ( esk9960_4(X1,X2,X3,X4)
    | esk9973_4(X1,X2,X3,X4) ) ).

cnf(i_0_10005,axiom,
    ( ~ esk11481_4(X1,X2,X3,X4)
    | esk11482_4(X1,X2,X3,X4)
    | ~ esk11480_4(X1,X2,X3,X4) ) ).

cnf(i_0_10006,axiom,
    ( esk14562_4(X1,X2,X3,X4)
    | ~ esk14560_4(X1,X2,X3,X4)
    | ~ esk14561_4(X1,X2,X3,X4) ) ).

cnf(i_0_10007,axiom,
    ( ~ esk14026_4(X1,X2,X3,X4)
    | esk14021_4(X1,X2,X3,X4)
    | ~ esk14142_4(X1,X2,X3,X4) ) ).

cnf(i_0_10008,axiom,
    ( ~ esk4503_4(X1,X2,X3,X4)
    | esk4472_4(X1,X2,X3,X4) ) ).

cnf(i_0_10009,axiom,
    ( esk7071_4(X1,X2,X3,X4)
    | ~ esk7044_4(X1,X2,X3,X4) ) ).

cnf(i_0_10010,axiom,
    ( ~ esk5340_4(X1,X2,X3,X4)
    | ~ esk5360_4(X1,X2,X3,X4)
    | ~ esk5446_4(X1,X2,X3,X4) ) ).

cnf(i_0_10011,axiom,
    ( esk11970_4(X1,X2,X3,X4)
    | ~ esk11962_4(X1,X2,X3,X4) ) ).

cnf(i_0_10012,axiom,
    ( ~ esk7329_4(X1,X2,X3,X4)
    | esk7300_4(X1,X2,X3,X4) ) ).

cnf(i_0_10013,axiom,
    ( esk967_4(X1,X2,X3,X4)
    | ~ esk1006_4(X1,X2,X3,X4) ) ).

cnf(i_0_10014,axiom,
    ( esk14650_4(X1,X2,X3,X4)
    | esk14678_4(X1,X2,X3,X4) ) ).

cnf(i_0_10015,axiom,
    ( ~ esk12819_4(X1,X2,X3,X4)
    | ~ esk12778_4(X1,X2,X3,X4)
    | ~ esk12818_4(X1,X2,X3,X4) ) ).

cnf(i_0_10016,axiom,
    ( ~ esk8520_4(X1,X2,X3,X4)
    | esk8543_4(X1,X2,X3,X4)
    | esk8460_4(X1,X2,X3,X4) ) ).

cnf(i_0_10017,axiom,
    ( esk13588_4(X1,X2,X3,X4)
    | esk13564_4(X1,X2,X3,X4) ) ).

cnf(i_0_10018,axiom,
    ( ~ esk2581_4(X1,X2,X3,X4)
    | esk2580_4(X1,X2,X3,X4) ) ).

cnf(i_0_10019,axiom,
    ( esk9526_4(X1,X2,X3,X4)
    | ~ esk9527_4(X1,X2,X3,X4) ) ).

cnf(i_0_10020,axiom,
    ( esk1573_4(X1,X2,X3,X4)
    | esk1572_4(X1,X2,X3,X4) ) ).

cnf(i_0_10021,axiom,
    ( esk1409_4(X1,X2,X3,X4)
    | ~ esk1433_4(X1,X2,X3,X4) ) ).

cnf(i_0_10022,axiom,
    ( esk493_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X1)
    | p(X3)
    | ~ esk85_0
    | p(X4) ) ).

cnf(i_0_10023,axiom,
    ( ~ esk10786_4(X1,X2,X3,X4)
    | esk11044_4(X1,X2,X3,X4) ) ).

cnf(i_0_10024,axiom,
    ( esk16729_4(X1,X2,X3,X4)
    | esk16766_4(X1,X2,X3,X4)
    | ~ esk16682_4(X1,X2,X3,X4) ) ).

cnf(i_0_10025,axiom,
    ( esk12070_4(X1,X2,X3,X4)
    | esk12037_4(X1,X2,X3,X4) ) ).

cnf(i_0_10026,axiom,
    ( ~ esk10184_4(X1,X2,X3,X4)
    | ~ esk10186_4(X1,X2,X3,X4) ) ).

cnf(i_0_10027,axiom,
    ( ~ esk10024_4(X1,X2,X3,X4)
    | ~ esk10050_4(X1,X2,X3,X4)
    | ~ esk10075_4(X1,X2,X3,X4) ) ).

cnf(i_0_10028,axiom,
    ( ~ esk15053_4(X1,X2,X3,X4)
    | ~ esk15178_4(X1,X2,X3,X4) ) ).

cnf(i_0_10029,axiom,
    ( ~ esk13935_4(X1,X2,X3,X4)
    | ~ esk13883_4(X1,X2,X3,X4) ) ).

cnf(i_0_10030,axiom,
    ( ~ esk12471_4(X1,X2,X3,X4)
    | esk12484_4(X1,X2,X3,X4) ) ).

cnf(i_0_10031,axiom,
    ( ~ esk10480_4(X1,X2,X3,X4)
    | ~ esk10510_4(X1,X2,X3,X4)
    | ~ esk10597_4(X1,X2,X3,X4) ) ).

cnf(i_0_10032,axiom,
    ( esk2254_4(X1,X2,X3,X4)
    | esk2283_4(X1,X2,X3,X4) ) ).

cnf(i_0_10033,axiom,
    ( esk1252_4(X1,X2,X3,X4)
    | esk1214_4(X1,X2,X3,X4) ) ).

cnf(i_0_10034,axiom,
    ( ~ esk2932_4(X1,X2,X3,X4)
    | esk2959_4(X1,X2,X3,X4) ) ).

cnf(i_0_10035,axiom,
    ( ~ esk7779_4(X1,X2,X3,X4)
    | ~ esk7653_4(X1,X2,X3,X4)
    | ~ esk7665_4(X1,X2,X3,X4) ) ).

cnf(i_0_10036,axiom,
    ( esk9308_4(X1,X2,X3,X4)
    | esk9223_4(X1,X2,X3,X4) ) ).

cnf(i_0_10037,axiom,
    ( esk12119_4(X1,X2,X3,X4)
    | ~ esk12112_4(X1,X2,X3,X4)
    | esk12068_4(X1,X2,X3,X4) ) ).

cnf(i_0_10038,axiom,
    ( esk1816_4(X1,X2,X3,X4)
    | ~ esk1689_4(X1,X2,X3,X4) ) ).

cnf(i_0_10039,axiom,
    ( esk16671_4(X1,X2,X3,X4)
    | esk16646_4(X1,X2,X3,X4) ) ).

cnf(i_0_10040,axiom,
    ( ~ esk14660_4(X1,X2,X3,X4)
    | esk14661_4(X1,X2,X3,X4) ) ).

cnf(i_0_10041,axiom,
    ( ~ esk12984_4(X1,X2,X3,X4)
    | esk12953_4(X1,X2,X3,X4) ) ).

cnf(i_0_10042,axiom,
    ( ~ esk14797_4(X1,X2,X3,X4)
    | esk14778_4(X1,X2,X3,X4)
    | ~ esk14897_4(X1,X2,X3,X4) ) ).

cnf(i_0_10043,axiom,
    ( esk4868_4(X1,X2,X3,X4)
    | esk4919_4(X1,X2,X3,X4)
    | ~ esk4948_4(X1,X2,X3,X4) ) ).

cnf(i_0_10044,axiom,
    ( ~ esk2733_4(X1,X2,X3,X4)
    | ~ esk2731_4(X1,X2,X3,X4) ) ).

cnf(i_0_10045,axiom,
    ( esk8336_4(X1,X2,X3,X4)
    | ~ esk8364_4(X1,X2,X3,X4) ) ).

cnf(i_0_10046,axiom,
    ( ~ esk10737_4(X1,X2,X3,X4)
    | ~ esk10736_4(X1,X2,X3,X4) ) ).

cnf(i_0_10047,axiom,
    ( ~ esk4902_4(X1,X2,X3,X4)
    | esk5160_4(X1,X2,X3,X4) ) ).

cnf(i_0_10048,axiom,
    ( esk14393_4(X1,X2,X3,X4)
    | esk14421_4(X1,X2,X3,X4) ) ).

cnf(i_0_10049,axiom,
    ( ~ esk7846_4(X1,X2,X3,X4)
    | esk7858_4(X1,X2,X3,X4) ) ).

cnf(i_0_10050,axiom,
    ( esk11032_4(X1,X2,X3,X4)
    | ~ esk10933_4(X1,X2,X3,X4) ) ).

cnf(i_0_10051,axiom,
    ( ~ p(X1)
    | esk209_0
    | p(X2)
    | ~ p(X4)
    | ~ p(X3)
    | ~ esk16699_4(X1,X2,X3,X4) ) ).

cnf(i_0_10052,axiom,
    ( ~ esk7576_4(X1,X2,X3,X4)
    | ~ esk7603_4(X1,X2,X3,X4) ) ).

cnf(i_0_10053,axiom,
    ( ~ esk4608_4(X1,X2,X3,X4)
    | esk4866_4(X1,X2,X3,X4) ) ).

cnf(i_0_10054,axiom,
    ( esk13745_4(X1,X2,X3,X4)
    | ~ esk13769_4(X1,X2,X3,X4) ) ).

cnf(i_0_10055,axiom,
    ( ~ esk1041_4(X1,X2,X3,X4)
    | ~ esk1048_4(X1,X2,X3,X4)
    | ~ esk950_4(X1,X2,X3,X4) ) ).

cnf(i_0_10056,axiom,
    ( esk5923_4(X1,X2,X3,X4)
    | ~ esk6181_4(X1,X2,X3,X4) ) ).

cnf(i_0_10057,axiom,
    ( esk14690_4(X1,X2,X3,X4)
    | ~ esk14691_4(X1,X2,X3,X4)
    | esk14640_4(X1,X2,X3,X4) ) ).

cnf(i_0_10058,axiom,
    ( ~ esk8135_4(X1,X2,X3,X4)
    | esk8123_4(X1,X2,X3,X4)
    | esk8134_4(X1,X2,X3,X4) ) ).

cnf(i_0_10059,axiom,
    ( esk6872_4(X1,X2,X3,X4)
    | esk6897_4(X1,X2,X3,X4) ) ).

cnf(i_0_10060,axiom,
    ( esk10808_4(X1,X2,X3,X4)
    | esk10815_4(X1,X2,X3,X4) ) ).

cnf(i_0_10061,axiom,
    ( esk12908_4(X1,X2,X3,X4)
    | ~ esk12910_4(X1,X2,X3,X4) ) ).

cnf(i_0_10062,axiom,
    ( ~ esk16159_4(X1,X2,X3,X4)
    | ~ esk16119_4(X1,X2,X3,X4)
    | ~ esk16160_4(X1,X2,X3,X4) ) ).

cnf(i_0_10063,axiom,
    ( esk16446_4(X1,X2,X3,X4)
    | ~ esk16377_4(X1,X2,X3,X4) ) ).

cnf(i_0_10064,axiom,
    ( ~ esk4882_4(X1,X2,X3,X4)
    | esk4934_4(X1,X2,X3,X4)
    | esk4953_4(X1,X2,X3,X4) ) ).

cnf(i_0_10065,axiom,
    ( esk11926_4(X1,X2,X3,X4)
    | ~ esk11955_4(X1,X2,X3,X4) ) ).

cnf(i_0_10066,axiom,
    ( esk12756_4(X1,X2,X3,X4)
    | ~ esk12757_4(X1,X2,X3,X4)
    | esk12751_4(X1,X2,X3,X4) ) ).

cnf(i_0_10067,axiom,
    ( esk6226_4(X1,X2,X3,X4)
    | ~ esk6225_4(X1,X2,X3,X4) ) ).

cnf(i_0_10068,axiom,
    ( ~ esk5031_4(X1,X2,X3,X4)
    | esk5021_4(X1,X2,X3,X4)
    | ~ esk5119_4(X1,X2,X3,X4) ) ).

cnf(i_0_10069,axiom,
    ( esk12269_4(X1,X2,X3,X4)
    | ~ esk12326_4(X1,X2,X3,X4) ) ).

cnf(i_0_10070,axiom,
    ( ~ esk2620_4(X1,X2,X3,X4)
    | esk2599_4(X1,X2,X3,X4)
    | esk2598_4(X1,X2,X3,X4) ) ).

cnf(i_0_10071,axiom,
    ( esk5469_4(X1,X2,X3,X4)
    | ~ esk5440_4(X1,X2,X3,X4)
    | esk5420_4(X1,X2,X3,X4) ) ).

cnf(i_0_10072,axiom,
    ( esk10209_4(X1,X2,X3,X4)
    | esk10246_4(X1,X2,X3,X4) ) ).

cnf(i_0_10073,axiom,
    ( esk2523_4(X1,X2,X3,X4)
    | esk2635_4(X1,X2,X3,X4) ) ).

cnf(i_0_10074,axiom,
    ( esk263_0
    | ~ p(X2)
    | p(X1)
    | p(X4)
    | ~ esk517_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_10075,axiom,
    ( esk11340_4(X1,X2,X3,X4)
    | esk11331_4(X1,X2,X3,X4)
    | esk11339_4(X1,X2,X3,X4) ) ).

cnf(i_0_10076,axiom,
    ( esk14654_4(X1,X2,X3,X4)
    | ~ esk14396_4(X1,X2,X3,X4) ) ).

cnf(i_0_10077,axiom,
    ( esk12559_4(X1,X2,X3,X4)
    | esk12534_4(X1,X2,X3,X4) ) ).

cnf(i_0_10078,axiom,
    ( esk10787_4(X1,X2,X3,X4)
    | esk10754_4(X1,X2,X3,X4) ) ).

cnf(i_0_10079,axiom,
    ( esk9826_4(X1,X2,X3,X4)
    | ~ esk9824_4(X1,X2,X3,X4)
    | ~ esk9825_4(X1,X2,X3,X4) ) ).

cnf(i_0_10080,axiom,
    ( ~ esk2826_4(X1,X2,X3,X4)
    | ~ esk2793_4(X1,X2,X3,X4)
    | ~ esk2768_4(X1,X2,X3,X4) ) ).

cnf(i_0_10081,axiom,
    ( ~ esk3866_4(X1,X2,X3,X4)
    | esk3865_4(X1,X2,X3,X4) ) ).

cnf(i_0_10082,axiom,
    ( esk13654_4(X1,X2,X3,X4)
    | esk13693_4(X1,X2,X3,X4)
    | esk13653_4(X1,X2,X3,X4)
    | esk13652_4(X1,X2,X3,X4) ) ).

cnf(i_0_10083,axiom,
    ( esk12001_4(X1,X2,X3,X4)
    | esk12092_4(X1,X2,X3,X4) ) ).

cnf(i_0_10084,axiom,
    ( ~ esk9064_4(X1,X2,X3,X4)
    | ~ esk8950_4(X1,X2,X3,X4)
    | ~ esk8938_4(X1,X2,X3,X4) ) ).

cnf(i_0_10085,axiom,
    ( ~ esk9193_4(X1,X2,X3,X4)
    | ~ esk9139_4(X1,X2,X3,X4) ) ).

cnf(i_0_10086,axiom,
    ( esk7726_4(X1,X2,X3,X4)
    | ~ esk7724_4(X1,X2,X3,X4) ) ).

cnf(i_0_10087,axiom,
    ( esk5657_4(X1,X2,X3,X4)
    | ~ esk5399_4(X1,X2,X3,X4) ) ).

cnf(i_0_10088,axiom,
    ( ~ esk15057_4(X1,X2,X3,X4)
    | ~ esk15051_4(X1,X2,X3,X4)
    | esk15052_4(X1,X2,X3,X4) ) ).

cnf(i_0_10089,axiom,
    ( ~ esk9243_4(X1,X2,X3,X4)
    | esk8985_4(X1,X2,X3,X4) ) ).

cnf(i_0_10090,axiom,
    ( esk3325_4(X1,X2,X3,X4)
    | ~ esk3583_4(X1,X2,X3,X4) ) ).

cnf(i_0_10091,axiom,
    ( esk9012_4(X1,X2,X3,X4)
    | ~ esk8855_4(X1,X2,X3,X4) ) ).

cnf(i_0_10092,axiom,
    ( esk11325_4(X1,X2,X3,X4)
    | ~ esk11326_4(X1,X2,X3,X4) ) ).

cnf(i_0_10093,axiom,
    ( esk7103_4(X1,X2,X3,X4)
    | ~ esk7097_4(X1,X2,X3,X4) ) ).

cnf(i_0_10094,axiom,
    ( esk10560_4(X1,X2,X3,X4)
    | esk10578_4(X1,X2,X3,X4) ) ).

cnf(i_0_10095,axiom,
    ( esk2815_4(X1,X2,X3,X4)
    | ~ esk2761_4(X1,X2,X3,X4) ) ).

cnf(i_0_10096,axiom,
    ( ~ esk6064_4(X1,X2,X3,X4)
    | esk6084_4(X1,X2,X3,X4) ) ).

cnf(i_0_10097,axiom,
    ( ~ esk16646_4(X1,X2,X3,X4)
    | ~ esk16626_4(X1,X2,X3,X4) ) ).

cnf(i_0_10098,axiom,
    ( esk2761_4(X1,X2,X3,X4)
    | ~ esk2815_4(X1,X2,X3,X4) ) ).

cnf(i_0_10099,axiom,
    ( ~ esk15561_4(X1,X2,X3,X4)
    | esk15568_4(X1,X2,X3,X4) ) ).

cnf(i_0_10100,axiom,
    ( ~ esk2217_4(X1,X2,X3,X4)
    | ~ esk2212_4(X1,X2,X3,X4) ) ).

cnf(i_0_10101,axiom,
    ( esk10255_4(X1,X2,X3,X4)
    | esk10205_4(X1,X2,X3,X4) ) ).

cnf(i_0_10102,axiom,
    ( ~ esk15939_4(X1,X2,X3,X4)
    | ~ esk15991_4(X1,X2,X3,X4) ) ).

cnf(i_0_10103,axiom,
    ( esk12913_4(X1,X2,X3,X4)
    | esk12799_4(X1,X2,X3,X4) ) ).

cnf(i_0_10104,axiom,
    ( esk16710_4(X1,X2,X3,X4)
    | ~ esk16452_4(X1,X2,X3,X4) ) ).

cnf(i_0_10105,axiom,
    ( esk5119_4(X1,X2,X3,X4)
    | ~ esk4861_4(X1,X2,X3,X4) ) ).

cnf(i_0_10106,axiom,
    ( esk9734_4(X1,X2,X3,X4)
    | esk9767_4(X1,X2,X3,X4) ) ).

cnf(i_0_10107,axiom,
    ( esk15902_4(X1,X2,X3,X4)
    | esk15862_4(X1,X2,X3,X4) ) ).

cnf(i_0_10108,axiom,
    ( esk6421_4(X1,X2,X3,X4)
    | ~ esk6355_4(X1,X2,X3,X4) ) ).

cnf(i_0_10109,axiom,
    ( esk3268_4(X1,X2,X3,X4)
    | esk3312_4(X1,X2,X3,X4) ) ).

cnf(i_0_10110,axiom,
    ( esk971_4(X1,X2,X3,X4)
    | esk981_4(X1,X2,X3,X4) ) ).

cnf(i_0_10111,axiom,
    ( ~ esk13391_4(X1,X2,X3,X4)
    | esk13365_4(X1,X2,X3,X4)
    | esk13416_4(X1,X2,X3,X4) ) ).

cnf(i_0_10112,axiom,
    ( ~ esk8064_4(X1,X2,X3,X4)
    | ~ esk8116_4(X1,X2,X3,X4)
    | ~ esk8117_4(X1,X2,X3,X4)
    | ~ esk8066_4(X1,X2,X3,X4)
    | ~ esk8063_4(X1,X2,X3,X4) ) ).

cnf(i_0_10113,axiom,
    ( ~ esk4262_4(X1,X2,X3,X4)
    | ~ esk4210_4(X1,X2,X3,X4) ) ).

cnf(i_0_10114,axiom,
    ( esk11434_4(X1,X2,X3,X4)
    | ~ esk11454_4(X1,X2,X3,X4) ) ).

cnf(i_0_10115,axiom,
    ( ~ esk3836_4(X1,X2,X3,X4)
    | ~ esk3892_4(X1,X2,X3,X4) ) ).

cnf(i_0_10116,axiom,
    ( esk13090_4(X1,X2,X3,X4)
    | ~ esk12990_4(X1,X2,X3,X4) ) ).

cnf(i_0_10117,axiom,
    ( esk4834_4(X1,X2,X3,X4)
    | esk4826_4(X1,X2,X3,X4) ) ).

cnf(i_0_10118,axiom,
    ( ~ esk11284_4(X1,X2,X3,X4)
    | esk11248_4(X1,X2,X3,X4) ) ).

cnf(i_0_10119,axiom,
    ( ~ esk15464_4(X1,X2,X3,X4)
    | esk15462_4(X1,X2,X3,X4) ) ).

cnf(i_0_10120,axiom,
    ( esk5575_4(X1,X2,X3,X4)
    | esk5597_4(X1,X2,X3,X4)
    | esk5596_4(X1,X2,X3,X4) ) ).

cnf(i_0_10121,axiom,
    ( esk6377_4(X1,X2,X3,X4)
    | esk6410_4(X1,X2,X3,X4) ) ).

cnf(i_0_10122,axiom,
    ( ~ esk1226_4(X1,X2,X3,X4)
    | ~ esk1278_4(X1,X2,X3,X4)
    | ~ esk1245_4(X1,X2,X3,X4) ) ).

cnf(i_0_10123,axiom,
    ( ~ esk11850_4(X1,X2,X3,X4)
    | ~ esk11819_4(X1,X2,X3,X4) ) ).

cnf(i_0_10124,axiom,
    ( ~ esk8615_4(X1,X2,X3,X4)
    | esk8584_4(X1,X2,X3,X4) ) ).

cnf(i_0_10125,axiom,
    ( esk1259_4(X1,X2,X3,X4)
    | esk1210_4(X1,X2,X3,X4) ) ).

cnf(i_0_10126,axiom,
    ( esk7465_4(X1,X2,X3,X4)
    | ~ esk7464_4(X1,X2,X3,X4) ) ).

cnf(i_0_10127,axiom,
    ( esk11045_4(X1,X2,X3,X4)
    | ~ esk11303_4(X1,X2,X3,X4) ) ).

cnf(i_0_10128,axiom,
    ( ~ esk574_4(X1,X2,X3,X4)
    | esk573_4(X1,X2,X3,X4) ) ).

cnf(i_0_10129,axiom,
    ( ~ esk5966_4(X1,X2,X3,X4)
    | esk5914_4(X1,X2,X3,X4)
    | esk5936_4(X1,X2,X3,X4) ) ).

cnf(i_0_10130,axiom,
    ( esk4567_4(X1,X2,X3,X4)
    | esk4576_4(X1,X2,X3,X4) ) ).

cnf(i_0_10131,axiom,
    ( esk9175_4(X1,X2,X3,X4)
    | esk9272_4(X1,X2,X3,X4)
    | esk9176_4(X1,X2,X3,X4) ) ).

cnf(i_0_10132,axiom,
    ( ~ esk16579_4(X1,X2,X3,X4)
    | esk16700_4(X1,X2,X3,X4) ) ).

cnf(i_0_10133,axiom,
    ( esk7468_4(X1,X2,X3,X4)
    | esk7343_4(X1,X2,X3,X4) ) ).

cnf(i_0_10134,axiom,
    ( esk1845_4(X1,X2,X3,X4)
    | ~ esk1847_4(X1,X2,X3,X4) ) ).

cnf(i_0_10135,axiom,
    ( ~ esk13048_4(X1,X2,X3,X4)
    | ~ esk13088_4(X1,X2,X3,X4)
    | ~ esk13055_4(X1,X2,X3,X4) ) ).

cnf(i_0_10136,axiom,
    ( ~ esk3748_4(X1,X2,X3,X4)
    | ~ esk3720_4(X1,X2,X3,X4) ) ).

cnf(i_0_10137,axiom,
    ( esk16106_4(X1,X2,X3,X4)
    | ~ esk16110_4(X1,X2,X3,X4) ) ).

cnf(i_0_10138,axiom,
    ( esk3913_4(X1,X2,X3,X4)
    | ~ esk3912_4(X1,X2,X3,X4) ) ).

cnf(i_0_10139,axiom,
    ( esk14080_4(X1,X2,X3,X4)
    | esk14196_4(X1,X2,X3,X4) ) ).

cnf(i_0_10140,axiom,
    ( ~ esk10685_4(X1,X2,X3,X4)
    | esk10661_4(X1,X2,X3,X4) ) ).

cnf(i_0_10141,axiom,
    ( ~ esk14333_4(X1,X2,X3,X4)
    | ~ esk14279_4(X1,X2,X3,X4) ) ).

cnf(i_0_10142,axiom,
    ( esk4057_4(X1,X2,X3,X4)
    | esk4052_4(X1,X2,X3,X4) ) ).

cnf(i_0_10143,axiom,
    ( ~ esk3361_4(X1,X2,X3,X4)
    | esk3103_4(X1,X2,X3,X4) ) ).

cnf(i_0_10144,axiom,
    ( ~ esk14957_4(X1,X2,X3,X4)
    | ~ esk14905_4(X1,X2,X3,X4)
    | ~ esk14976_4(X1,X2,X3,X4) ) ).

cnf(i_0_10145,axiom,
    ( ~ esk7914_4(X1,X2,X3,X4)
    | ~ esk7910_4(X1,X2,X3,X4)
    | ~ esk8029_4(X1,X2,X3,X4) ) ).

cnf(i_0_10146,axiom,
    ( esk11594_4(X1,X2,X3,X4)
    | esk11566_4(X1,X2,X3,X4) ) ).

cnf(i_0_10147,axiom,
    ( ~ esk9093_4(X1,X2,X3,X4)
    | ~ esk9145_4(X1,X2,X3,X4) ) ).

cnf(i_0_10148,axiom,
    ( ~ esk16236_4(X1,X2,X3,X4)
    | ~ esk16222_4(X1,X2,X3,X4) ) ).

cnf(i_0_10149,axiom,
    ( esk10325_4(X1,X2,X3,X4)
    | esk10311_4(X1,X2,X3,X4) ) ).

cnf(i_0_10150,axiom,
    ( ~ esk15084_4(X1,X2,X3,X4)
    | ~ esk15104_4(X1,X2,X3,X4) ) ).

cnf(i_0_10151,axiom,
    ( ~ esk14040_4(X1,X2,X3,X4)
    | ~ esk14039_4(X1,X2,X3,X4) ) ).

cnf(i_0_10152,axiom,
    ( esk455_4(X1,X2,X3,X4)
    | esk470_4(X1,X2,X3,X4) ) ).

cnf(i_0_10153,axiom,
    ( ~ esk9757_4(X1,X2,X3,X4)
    | esk9638_4(X1,X2,X3,X4)
    | ~ esk9657_4(X1,X2,X3,X4) ) ).

cnf(i_0_10154,axiom,
    ( ~ esk12225_4(X1,X2,X3,X4)
    | esk12230_4(X1,X2,X3,X4) ) ).

cnf(i_0_10155,axiom,
    ( ~ esk11307_4(X1,X2,X3,X4)
    | esk11184_4(X1,X2,X3,X4)
    | ~ esk11199_4(X1,X2,X3,X4) ) ).

cnf(i_0_10156,axiom,
    ( ~ esk12586_4(X1,X2,X3,X4)
    | ~ esk12625_4(X1,X2,X3,X4) ) ).

cnf(i_0_10157,axiom,
    ( esk3008_4(X1,X2,X3,X4)
    | esk3097_4(X1,X2,X3,X4) ) ).

cnf(i_0_10158,axiom,
    ( esk12870_4(X1,X2,X3,X4)
    | ~ esk12612_4(X1,X2,X3,X4) ) ).

cnf(i_0_10159,axiom,
    ( esk672_4(X1,X2,X3,X4)
    | esk673_4(X1,X2,X3,X4) ) ).

cnf(i_0_10160,axiom,
    ( esk3073_4(X1,X2,X3,X4)
    | esk3040_4(X1,X2,X3,X4) ) ).

cnf(i_0_10161,axiom,
    ( esk2895_4(X1,X2,X3,X4)
    | ~ esk2814_4(X1,X2,X3,X4) ) ).

cnf(i_0_10162,axiom,
    ( ~ esk8618_4(X1,X2,X3,X4)
    | esk8629_4(X1,X2,X3,X4) ) ).

cnf(i_0_10163,axiom,
    ( esk15036_4(X1,X2,X3,X4)
    | ~ esk15156_4(X1,X2,X3,X4)
    | ~ esk15054_4(X1,X2,X3,X4) ) ).

cnf(i_0_10164,axiom,
    ( esk10592_4(X1,X2,X3,X4)
    | ~ esk10593_4(X1,X2,X3,X4) ) ).

cnf(i_0_10165,axiom,
    ( ~ esk2806_4(X1,X2,X3,X4)
    | esk2548_4(X1,X2,X3,X4) ) ).

cnf(i_0_10166,axiom,
    ( ~ esk15867_4(X1,X2,X3,X4)
    | esk15924_4(X1,X2,X3,X4) ) ).

cnf(i_0_10167,axiom,
    ( esk9548_4(X1,X2,X3,X4)
    | esk9571_4(X1,X2,X3,X4)
    | ~ esk9488_4(X1,X2,X3,X4) ) ).

cnf(i_0_10168,axiom,
    ( ~ esk13552_4(X1,X2,X3,X4)
    | esk13615_4(X1,X2,X3,X4) ) ).

cnf(i_0_10169,axiom,
    ( esk7866_4(X1,X2,X3,X4)
    | esk7865_4(X1,X2,X3,X4) ) ).

cnf(i_0_10170,axiom,
    ( esk9579_4(X1,X2,X3,X4)
    | esk9560_4(X1,X2,X3,X4)
    | ~ esk9508_4(X1,X2,X3,X4) ) ).

cnf(i_0_10171,axiom,
    ( ~ esk1697_4(X1,X2,X3,X4)
    | esk1439_4(X1,X2,X3,X4) ) ).

cnf(i_0_10172,axiom,
    ( esk1751_4(X1,X2,X3,X4)
    | esk1735_4(X1,X2,X3,X4) ) ).

cnf(i_0_10173,axiom,
    ( ~ esk10264_4(X1,X2,X3,X4)
    | esk10522_4(X1,X2,X3,X4) ) ).

cnf(i_0_10174,axiom,
    ( ~ esk16341_4(X1,X2,X3,X4)
    | ~ esk16313_4(X1,X2,X3,X4) ) ).

cnf(i_0_10175,axiom,
    ( esk14295_4(X1,X2,X3,X4)
    | ~ esk14279_4(X1,X2,X3,X4) ) ).

cnf(i_0_10176,axiom,
    ( ~ esk5645_4(X1,X2,X3,X4)
    | ~ esk5545_4(X1,X2,X3,X4)
    | esk5526_4(X1,X2,X3,X4) ) ).

cnf(i_0_10177,axiom,
    ( ~ esk16699_4(X1,X2,X3,X4)
    | esk16636_4(X1,X2,X3,X4) ) ).

cnf(i_0_10178,axiom,
    ( ~ esk11196_4(X1,X2,X3,X4)
    | ~ esk11202_4(X1,X2,X3,X4)
    | esk11197_4(X1,X2,X3,X4) ) ).

cnf(i_0_10179,axiom,
    ( esk13329_4(X1,X2,X3,X4)
    | esk13294_4(X1,X2,X3,X4) ) ).

cnf(i_0_10180,axiom,
    ( ~ esk1804_4(X1,X2,X3,X4)
    | esk1546_4(X1,X2,X3,X4) ) ).

cnf(i_0_10181,axiom,
    ( esk8164_4(X1,X2,X3,X4)
    | esk8169_4(X1,X2,X3,X4) ) ).

cnf(i_0_10182,axiom,
    ( ~ esk4530_4(X1,X2,X3,X4)
    | ~ esk4531_4(X1,X2,X3,X4) ) ).

cnf(i_0_10183,axiom,
    ( ~ esk8249_4(X1,X2,X3,X4)
    | ~ esk8229_4(X1,X2,X3,X4)
    | ~ esk8231_4(X1,X2,X3,X4) ) ).

cnf(i_0_10184,axiom,
    ( esk2511_4(X1,X2,X3,X4)
    | esk2544_4(X1,X2,X3,X4) ) ).

cnf(i_0_10185,axiom,
    ( esk15449_4(X1,X2,X3,X4)
    | esk15447_4(X1,X2,X3,X4) ) ).

cnf(i_0_10186,axiom,
    ( esk16059_4(X1,X2,X3,X4)
    | esk16205_4(X1,X2,X3,X4) ) ).

cnf(i_0_10187,axiom,
    ( esk16127_4(X1,X2,X3,X4)
    | ~ esk16175_4(X1,X2,X3,X4) ) ).

cnf(i_0_10188,axiom,
    ( esk2292_4(X1,X2,X3,X4)
    | ~ esk2194_4(X1,X2,X3,X4) ) ).

cnf(i_0_10189,axiom,
    ( esk1390_4(X1,X2,X3,X4)
    | ~ esk1417_4(X1,X2,X3,X4) ) ).

cnf(i_0_10190,axiom,
    ( esk8467_4(X1,X2,X3,X4)
    | ~ esk8725_4(X1,X2,X3,X4) ) ).

cnf(i_0_10191,axiom,
    ( ~ esk15713_4(X1,X2,X3,X4)
    | ~ esk15662_4(X1,X2,X3,X4)
    | ~ esk15715_4(X1,X2,X3,X4)
    | ~ esk15660_4(X1,X2,X3,X4) ) ).

cnf(i_0_10192,axiom,
    ( esk16134_4(X1,X2,X3,X4)
    | esk16156_4(X1,X2,X3,X4) ) ).

cnf(i_0_10193,axiom,
    ( ~ esk2377_4(X1,X2,X3,X4)
    | esk2296_4(X1,X2,X3,X4)
    | esk2384_4(X1,X2,X3,X4) ) ).

cnf(i_0_10194,axiom,
    ( esk9045_4(X1,X2,X3,X4)
    | esk8960_4(X1,X2,X3,X4) ) ).

cnf(i_0_10195,axiom,
    ( esk14887_4(X1,X2,X3,X4)
    | esk14854_4(X1,X2,X3,X4) ) ).

cnf(i_0_10196,axiom,
    ( esk14901_4(X1,X2,X3,X4)
    | esk14868_4(X1,X2,X3,X4) ) ).

cnf(i_0_10197,axiom,
    ( esk15325_4(X1,X2,X3,X4)
    | esk15323_4(X1,X2,X3,X4)
    | esk15319_4(X1,X2,X3,X4)
    | esk15322_4(X1,X2,X3,X4) ) ).

cnf(i_0_10198,axiom,
    ( esk10721_4(X1,X2,X3,X4)
    | esk10765_4(X1,X2,X3,X4) ) ).

cnf(i_0_10199,axiom,
    ( ~ esk6821_4(X1,X2,X3,X4)
    | esk6795_4(X1,X2,X3,X4) ) ).

cnf(i_0_10200,axiom,
    ( esk833_4(X1,X2,X3,X4)
    | esk718_4(X1,X2,X3,X4) ) ).

cnf(i_0_10201,axiom,
    ( esk5094_4(X1,X2,X3,X4)
    | esk5075_4(X1,X2,X3,X4) ) ).

cnf(i_0_10202,axiom,
    ( ~ esk4003_4(X1,X2,X3,X4)
    | esk4006_4(X1,X2,X3,X4) ) ).

cnf(i_0_10203,axiom,
    ( ~ esk1806_4(X1,X2,X3,X4)
    | esk1548_4(X1,X2,X3,X4) ) ).

cnf(i_0_10204,axiom,
    ( ~ esk12486_4(X1,X2,X3,X4)
    | ~ esk12458_4(X1,X2,X3,X4) ) ).

cnf(i_0_10205,axiom,
    ( esk15126_4(X1,X2,X3,X4)
    | esk15094_4(X1,X2,X3,X4) ) ).

cnf(i_0_10206,axiom,
    ( esk14018_4(X1,X2,X3,X4)
    | ~ esk13990_4(X1,X2,X3,X4) ) ).

cnf(i_0_10207,axiom,
    ( ~ esk15947_4(X1,X2,X3,X4)
    | ~ esk15858_4(X1,X2,X3,X4) ) ).

cnf(i_0_10208,axiom,
    ( ~ esk10942_4(X1,X2,X3,X4)
    | ~ esk11056_4(X1,X2,X3,X4)
    | esk10930_4(X1,X2,X3,X4) ) ).

cnf(i_0_10209,axiom,
    ( esk16044_4(X1,X2,X3,X4)
    | ~ esk16076_4(X1,X2,X3,X4) ) ).

cnf(i_0_10210,axiom,
    ( esk9545_4(X1,X2,X3,X4)
    | esk9547_4(X1,X2,X3,X4) ) ).

cnf(i_0_10211,axiom,
    ( ~ esk11817_4(X1,X2,X3,X4)
    | ~ esk11852_4(X1,X2,X3,X4)
    | ~ esk11871_4(X1,X2,X3,X4) ) ).

cnf(i_0_10212,axiom,
    ( ~ p(X1)
    | esk107_0
    | ~ p(X3)
    | ~ p(X2)
    | ~ esk16685_4(X1,X2,X3,X4)
    | p(X4) ) ).

cnf(i_0_10213,axiom,
    ( ~ esk8936_4(X1,X2,X3,X4)
    | ~ esk8882_4(X1,X2,X3,X4) ) ).

cnf(i_0_10214,axiom,
    ( ~ esk11827_4(X1,X2,X3,X4)
    | ~ esk11713_4(X1,X2,X3,X4)
    | esk11701_4(X1,X2,X3,X4) ) ).

cnf(i_0_10215,axiom,
    ( ~ esk7325_4(X1,X2,X3,X4)
    | esk7444_4(X1,X2,X3,X4) ) ).

cnf(i_0_10216,axiom,
    ( esk2248_4(X1,X2,X3,X4)
    | esk2267_4(X1,X2,X3,X4) ) ).

cnf(i_0_10217,axiom,
    ( ~ esk6448_4(X1,X2,X3,X4)
    | ~ esk6457_4(X1,X2,X3,X4) ) ).

cnf(i_0_10218,axiom,
    ( ~ esk209_0
    | ~ p(X4)
    | p(X2)
    | ~ p(X1)
    | esk16699_4(X1,X2,X3,X4)
    | ~ p(X3) ) ).

cnf(i_0_10219,axiom,
    ( esk5638_4(X1,X2,X3,X4)
    | ~ esk5590_4(X1,X2,X3,X4) ) ).

cnf(i_0_10220,axiom,
    ( esk1043_4(X1,X2,X3,X4)
    | ~ esk1044_4(X1,X2,X3,X4)
    | esk1042_4(X1,X2,X3,X4) ) ).

cnf(i_0_10221,axiom,
    ( esk7563_4(X1,X2,X3,X4)
    | ~ esk7595_4(X1,X2,X3,X4) ) ).

cnf(i_0_10222,axiom,
    ( esk10182_4(X1,X2,X3,X4)
    | esk10179_4(X1,X2,X3,X4)
    | esk10185_4(X1,X2,X3,X4)
    | esk10183_4(X1,X2,X3,X4) ) ).

cnf(i_0_10223,axiom,
    ( ~ esk1775_4(X1,X2,X3,X4)
    | esk1739_4(X1,X2,X3,X4) ) ).

cnf(i_0_10224,axiom,
    ( ~ esk9134_4(X1,X2,X3,X4)
    | esk9233_4(X1,X2,X3,X4) ) ).

cnf(i_0_10225,axiom,
    ( ~ esk8616_4(X1,X2,X3,X4)
    | esk8741_4(X1,X2,X3,X4) ) ).

cnf(i_0_10226,axiom,
    ( ~ esk12061_4(X1,X2,X3,X4)
    | esk12319_4(X1,X2,X3,X4) ) ).

cnf(i_0_10227,axiom,
    ( esk3276_4(X1,X2,X3,X4)
    | ~ esk3327_4(X1,X2,X3,X4) ) ).

cnf(i_0_10228,axiom,
    ( esk13610_4(X1,X2,X3,X4)
    | ~ esk13654_4(X1,X2,X3,X4)
    | esk13661_4(X1,X2,X3,X4) ) ).

cnf(i_0_10229,axiom,
    ( esk11821_4(X1,X2,X3,X4)
    | ~ esk11892_4(X1,X2,X3,X4)
    | esk11873_4(X1,X2,X3,X4) ) ).

cnf(i_0_10230,axiom,
    ( ~ esk16662_4(X1,X2,X3,X4)
    | ~ esk16648_4(X1,X2,X3,X4)
    | ~ esk16745_4(X1,X2,X3,X4) ) ).

cnf(i_0_10231,axiom,
    ( ~ esk14035_4(X1,X2,X3,X4)
    | esk14044_4(X1,X2,X3,X4) ) ).

cnf(i_0_10232,axiom,
    ( esk7149_4(X1,X2,X3,X4)
    | esk7261_4(X1,X2,X3,X4) ) ).

cnf(i_0_10233,axiom,
    ( esk9436_4(X1,X2,X3,X4)
    | ~ esk9511_4(X1,X2,X3,X4) ) ).

cnf(i_0_10234,axiom,
    ( ~ esk16739_4(X1,X2,X3,X4)
    | ~ esk16741_4(X1,X2,X3,X4) ) ).

cnf(i_0_10235,axiom,
    ( ~ esk8017_4(X1,X2,X3,X4)
    | ~ esk7996_4(X1,X2,X3,X4)
    | ~ esk7995_4(X1,X2,X3,X4) ) ).

cnf(i_0_10236,axiom,
    ( esk15218_4(X1,X2,X3,X4)
    | ~ esk15219_4(X1,X2,X3,X4) ) ).

cnf(i_0_10237,axiom,
    ( ~ esk2502_4(X1,X2,X3,X4)
    | esk2562_4(X1,X2,X3,X4) ) ).

cnf(i_0_10238,axiom,
    ( ~ esk1230_4(X1,X2,X3,X4)
    | ~ esk1225_4(X1,X2,X3,X4)
    | ~ esk1229_4(X1,X2,X3,X4) ) ).

cnf(i_0_10239,axiom,
    ( ~ esk5443_4(X1,X2,X3,X4)
    | esk5445_4(X1,X2,X3,X4)
    | ~ esk5444_4(X1,X2,X3,X4) ) ).

cnf(i_0_10240,axiom,
    ( esk2010_4(X1,X2,X3,X4)
    | esk1991_4(X1,X2,X3,X4) ) ).

cnf(i_0_10241,axiom,
    ( esk3025_4(X1,X2,X3,X4)
    | esk3042_4(X1,X2,X3,X4) ) ).

cnf(i_0_10242,axiom,
    ( esk2516_4(X1,X2,X3,X4)
    | esk2509_4(X1,X2,X3,X4) ) ).

cnf(i_0_10243,axiom,
    ( ~ esk3580_4(X1,X2,X3,X4)
    | esk3535_4(X1,X2,X3,X4) ) ).

cnf(i_0_10244,axiom,
    ( ~ esk667_4(X1,X2,X3,X4)
    | ~ esk685_4(X1,X2,X3,X4) ) ).

cnf(i_0_10245,axiom,
    ( ~ esk11732_4(X1,X2,X3,X4)
    | ~ esk11727_4(X1,X2,X3,X4) ) ).

cnf(i_0_10246,axiom,
    ( ~ esk3106_4(X1,X2,X3,X4)
    | ~ esk3027_4(X1,X2,X3,X4)
    | ~ esk3059_4(X1,X2,X3,X4) ) ).

cnf(i_0_10247,axiom,
    ( ~ esk1455_4(X1,X2,X3,X4)
    | esk1453_4(X1,X2,X3,X4) ) ).

cnf(i_0_10248,axiom,
    ( esk15433_4(X1,X2,X3,X4)
    | esk15342_4(X1,X2,X3,X4) ) ).

cnf(i_0_10249,axiom,
    ( esk7848_4(X1,X2,X3,X4)
    | ~ esk7946_4(X1,X2,X3,X4)
    | ~ esk7858_4(X1,X2,X3,X4) ) ).

cnf(i_0_10250,axiom,
    ( esk15160_4(X1,X2,X3,X4)
    | ~ esk14902_4(X1,X2,X3,X4) ) ).

cnf(i_0_10251,axiom,
    ( esk16614_4(X1,X2,X3,X4)
    | ~ esk16605_4(X1,X2,X3,X4) ) ).

cnf(i_0_10252,axiom,
    ( ~ esk10430_4(X1,X2,X3,X4)
    | ~ esk10400_4(X1,X2,X3,X4) ) ).

cnf(i_0_10253,axiom,
    ( ~ esk11235_4(X1,X2,X3,X4)
    | esk11310_4(X1,X2,X3,X4) ) ).

cnf(i_0_10254,axiom,
    ( ~ esk1204_4(X1,X2,X3,X4)
    | ~ esk1205_4(X1,X2,X3,X4) ) ).

cnf(i_0_10255,axiom,
    ( ~ esk11448_4(X1,X2,X3,X4)
    | esk11548_4(X1,X2,X3,X4) ) ).

cnf(i_0_10256,axiom,
    ( esk14011_4(X1,X2,X3,X4)
    | ~ esk14134_4(X1,X2,X3,X4)
    | ~ esk14026_4(X1,X2,X3,X4) ) ).

cnf(i_0_10257,axiom,
    ( esk12249_4(X1,X2,X3,X4)
    | ~ esk12233_4(X1,X2,X3,X4) ) ).

cnf(i_0_10258,axiom,
    ( esk12280_4(X1,X2,X3,X4)
    | esk12276_4(X1,X2,X3,X4) ) ).

cnf(i_0_10259,axiom,
    ( esk12360_4(X1,X2,X3,X4)
    | ~ esk12397_4(X1,X2,X3,X4)
    | esk12313_4(X1,X2,X3,X4) ) ).

cnf(i_0_10260,axiom,
    ( esk15468_4(X1,X2,X3,X4)
    | esk15381_4(X1,X2,X3,X4) ) ).

cnf(i_0_10261,axiom,
    ( esk3535_4(X1,X2,X3,X4)
    | esk3549_4(X1,X2,X3,X4) ) ).

cnf(i_0_10262,axiom,
    ( esk455_4(X1,X2,X3,X4)
    | esk468_4(X1,X2,X3,X4) ) ).

cnf(i_0_10263,axiom,
    ( esk14173_4(X1,X2,X3,X4)
    | esk14171_4(X1,X2,X3,X4) ) ).

cnf(i_0_10264,axiom,
    ( ~ esk2711_4(X1,X2,X3,X4)
    | esk2718_4(X1,X2,X3,X4) ) ).

cnf(i_0_10265,axiom,
    ( esk9437_4(X1,X2,X3,X4)
    | esk9477_4(X1,X2,X3,X4) ) ).

cnf(i_0_10266,axiom,
    ( ~ esk10928_4(X1,X2,X3,X4)
    | esk10942_4(X1,X2,X3,X4) ) ).

cnf(i_0_10267,axiom,
    ( esk9437_4(X1,X2,X3,X4)
    | esk9478_4(X1,X2,X3,X4) ) ).

cnf(i_0_10268,axiom,
    ( esk6563_4(X1,X2,X3,X4)
    | ~ esk6573_4(X1,X2,X3,X4)
    | ~ esk6661_4(X1,X2,X3,X4) ) ).

cnf(i_0_10269,axiom,
    ( ~ esk14512_4(X1,X2,X3,X4)
    | ~ esk14542_4(X1,X2,X3,X4) ) ).

cnf(i_0_10270,axiom,
    ( esk8015_4(X1,X2,X3,X4)
    | esk7928_4(X1,X2,X3,X4) ) ).

cnf(i_0_10271,axiom,
    ( esk1538_4(X1,X2,X3,X4)
    | ~ esk1796_4(X1,X2,X3,X4) ) ).

cnf(i_0_10272,axiom,
    ( ~ esk519_4(X1,X2,X3,X4)
    | ~ esk521_4(X1,X2,X3,X4)
    | ~ esk539_4(X1,X2,X3,X4) ) ).

cnf(i_0_10273,axiom,
    ( esk10476_4(X1,X2,X3,X4)
    | esk10483_4(X1,X2,X3,X4) ) ).

cnf(i_0_10274,axiom,
    ( esk7473_4(X1,X2,X3,X4)
    | ~ esk7215_4(X1,X2,X3,X4) ) ).

cnf(i_0_10275,axiom,
    ( ~ esk5545_4(X1,X2,X3,X4)
    | esk5521_4(X1,X2,X3,X4) ) ).

cnf(i_0_10276,axiom,
    ( ~ esk15111_4(X1,X2,X3,X4)
    | ~ esk15104_4(X1,X2,X3,X4)
    | ~ esk15144_4(X1,X2,X3,X4) ) ).

cnf(i_0_10277,axiom,
    ( ~ esk6109_4(X1,X2,X3,X4)
    | ~ esk6114_4(X1,X2,X3,X4)
    | ~ esk6147_4(X1,X2,X3,X4) ) ).

cnf(i_0_10278,axiom,
    ( ~ esk9161_4(X1,X2,X3,X4)
    | esk9159_4(X1,X2,X3,X4) ) ).

cnf(i_0_10279,axiom,
    ( ~ esk9365_4(X1,X2,X3,X4)
    | esk9391_4(X1,X2,X3,X4) ) ).

cnf(i_0_10280,axiom,
    ( ~ esk14129_4(X1,X2,X3,X4)
    | esk14066_4(X1,X2,X3,X4) ) ).

cnf(i_0_10281,axiom,
    ( esk1763_4(X1,X2,X3,X4)
    | esk1740_4(X1,X2,X3,X4) ) ).

cnf(i_0_10282,axiom,
    ( esk12833_4(X1,X2,X3,X4)
    | ~ esk12733_4(X1,X2,X3,X4) ) ).

cnf(i_0_10283,axiom,
    ( ~ esk13896_4(X1,X2,X3,X4)
    | esk13897_4(X1,X2,X3,X4) ) ).

cnf(i_0_10284,axiom,
    ( esk1510_4(X1,X2,X3,X4)
    | esk1470_4(X1,X2,X3,X4) ) ).

cnf(i_0_10285,axiom,
    ( ~ esk2977_4(X1,X2,X3,X4)
    | ~ esk2950_4(X1,X2,X3,X4) ) ).

cnf(i_0_10286,axiom,
    ( esk1296_4(X1,X2,X3,X4)
    | ~ esk1294_4(X1,X2,X3,X4)
    | ~ esk1295_4(X1,X2,X3,X4) ) ).

cnf(i_0_10287,axiom,
    ( esk16475_4(X1,X2,X3,X4)
    | esk16518_4(X1,X2,X3,X4) ) ).

cnf(i_0_10288,axiom,
    ( esk9670_4(X1,X2,X3,X4)
    | ~ esk9674_4(X1,X2,X3,X4)
    | esk9668_4(X1,X2,X3,X4) ) ).

cnf(i_0_10289,axiom,
    ( esk7088_4(X1,X2,X3,X4)
    | esk7038_4(X1,X2,X3,X4) ) ).

cnf(i_0_10290,axiom,
    ( esk1190_4(X1,X2,X3,X4)
    | ~ esk1197_4(X1,X2,X3,X4)
    | esk1183_4(X1,X2,X3,X4) ) ).

cnf(i_0_10291,axiom,
    ( esk11582_4(X1,X2,X3,X4)
    | ~ esk11455_4(X1,X2,X3,X4) ) ).

cnf(i_0_10292,axiom,
    ( ~ esk1059_4(X1,X2,X3,X4)
    | ~ esk1061_4(X1,X2,X3,X4) ) ).

cnf(i_0_10293,axiom,
    ( esk12401_4(X1,X2,X3,X4)
    | esk12372_4(X1,X2,X3,X4)
    | ~ esk12321_4(X1,X2,X3,X4) ) ).

cnf(i_0_10294,axiom,
    ( esk4527_4(X1,X2,X3,X4)
    | ~ esk4269_4(X1,X2,X3,X4) ) ).

cnf(i_0_10295,axiom,
    ( esk8107_4(X1,X2,X3,X4)
    | ~ esk8115_4(X1,X2,X3,X4)
    | ~ esk8207_4(X1,X2,X3,X4) ) ).

cnf(i_0_10296,axiom,
    ( ~ esk8499_4(X1,X2,X3,X4)
    | esk8497_4(X1,X2,X3,X4) ) ).

cnf(i_0_10297,axiom,
    ( ~ esk1533_4(X1,X2,X3,X4)
    | esk1584_4(X1,X2,X3,X4) ) ).

cnf(i_0_10298,axiom,
    ( esk10430_4(X1,X2,X3,X4)
    | esk10429_4(X1,X2,X3,X4) ) ).

cnf(i_0_10299,axiom,
    ( ~ esk4499_4(X1,X2,X3,X4)
    | esk4476_4(X1,X2,X3,X4) ) ).

cnf(i_0_10300,axiom,
    ( ~ esk7100_4(X1,X2,X3,X4)
    | ~ esk7095_4(X1,X2,X3,X4) ) ).

cnf(i_0_10301,axiom,
    ( ~ esk15566_4(X1,X2,X3,X4)
    | esk15571_4(X1,X2,X3,X4) ) ).

cnf(i_0_10302,axiom,
    ( ~ esk8810_4(X1,X2,X3,X4)
    | esk8781_4(X1,X2,X3,X4) ) ).

cnf(i_0_10303,axiom,
    ( ~ esk12372_4(X1,X2,X3,X4)
    | ~ esk12371_4(X1,X2,X3,X4) ) ).

cnf(i_0_10304,axiom,
    ( ~ esk13249_4(X1,X2,X3,X4)
    | esk13217_4(X1,X2,X3,X4) ) ).

cnf(i_0_10305,axiom,
    ( esk6395_4(X1,X2,X3,X4)
    | esk6352_4(X1,X2,X3,X4) ) ).

cnf(i_0_10306,axiom,
    ( esk2216_4(X1,X2,X3,X4)
    | esk2215_4(X1,X2,X3,X4)
    | esk2218_4(X1,X2,X3,X4)
    | esk2212_4(X1,X2,X3,X4) ) ).

cnf(i_0_10307,axiom,
    ( esk5674_4(X1,X2,X3,X4)
    | ~ esk5416_4(X1,X2,X3,X4) ) ).

cnf(i_0_10308,axiom,
    ( esk4357_4(X1,X2,X3,X4)
    | ~ esk4303_4(X1,X2,X3,X4) ) ).

cnf(i_0_10309,axiom,
    ( ~ esk12650_4(X1,X2,X3,X4)
    | ~ esk12598_4(X1,X2,X3,X4) ) ).

cnf(i_0_10310,axiom,
    ( esk4095_4(X1,X2,X3,X4)
    | esk4062_4(X1,X2,X3,X4) ) ).

cnf(i_0_10311,axiom,
    ( ~ esk6206_4(X1,X2,X3,X4)
    | ~ esk6207_4(X1,X2,X3,X4) ) ).

cnf(i_0_10312,axiom,
    ( esk774_4(X1,X2,X3,X4)
    | esk796_4(X1,X2,X3,X4)
    | ~ esk826_4(X1,X2,X3,X4) ) ).

cnf(i_0_10313,axiom,
    ( esk3079_4(X1,X2,X3,X4)
    | esk3046_4(X1,X2,X3,X4) ) ).

cnf(i_0_10314,axiom,
    ( esk8161_4(X1,X2,X3,X4)
    | esk8174_4(X1,X2,X3,X4) ) ).

cnf(i_0_10315,axiom,
    ( esk16477_4(X1,X2,X3,X4)
    | esk16476_4(X1,X2,X3,X4)
    | esk16478_4(X1,X2,X3,X4) ) ).

cnf(i_0_10316,axiom,
    ( ~ esk15962_4(X1,X2,X3,X4)
    | esk15963_4(X1,X2,X3,X4)
    | esk15984_4(X1,X2,X3,X4) ) ).

cnf(i_0_10317,axiom,
    ( p(X3)
    | p(X2)
    | ~ esk27_0
    | ~ p(X1)
    | esk16602_4(X1,X2,X3,X4)
    | ~ p(X4) ) ).

cnf(i_0_10318,axiom,
    ( ~ esk6666_4(X1,X2,X3,X4)
    | esk6924_4(X1,X2,X3,X4) ) ).

cnf(i_0_10319,axiom,
    ( ~ esk11745_4(X1,X2,X3,X4)
    | ~ esk11746_4(X1,X2,X3,X4) ) ).

cnf(i_0_10320,axiom,
    ( esk11713_4(X1,X2,X3,X4)
    | ~ esk11694_4(X1,X2,X3,X4) ) ).

cnf(i_0_10321,axiom,
    ( esk3290_4(X1,X2,X3,X4)
    | esk3404_4(X1,X2,X3,X4) ) ).

cnf(i_0_10322,axiom,
    ( esk12555_4(X1,X2,X3,X4)
    | esk12534_4(X1,X2,X3,X4) ) ).

cnf(i_0_10323,axiom,
    ( ~ esk3577_4(X1,X2,X3,X4)
    | ~ esk3544_4(X1,X2,X3,X4)
    | ~ esk3539_4(X1,X2,X3,X4) ) ).

cnf(i_0_10324,axiom,
    ( ~ esk10068_4(X1,X2,X3,X4)
    | ~ esk10054_4(X1,X2,X3,X4) ) ).

cnf(i_0_10325,axiom,
    ( ~ esk15292_4(X1,X2,X3,X4)
    | esk15311_4(X1,X2,X3,X4) ) ).

cnf(i_0_10326,axiom,
    ( ~ esk5208_4(X1,X2,X3,X4)
    | esk5174_4(X1,X2,X3,X4)
    | esk5127_4(X1,X2,X3,X4) ) ).

cnf(i_0_10327,axiom,
    ( esk13082_4(X1,X2,X3,X4)
    | esk13050_4(X1,X2,X3,X4) ) ).

cnf(i_0_10328,axiom,
    ( esk13837_4(X1,X2,X3,X4)
    | esk13922_4(X1,X2,X3,X4) ) ).

cnf(i_0_10329,axiom,
    ( ~ esk4587_4(X1,X2,X3,X4)
    | ~ esk4569_4(X1,X2,X3,X4)
    | ~ esk4674_4(X1,X2,X3,X4) ) ).

cnf(i_0_10330,axiom,
    ( esk2057_4(X1,X2,X3,X4)
    | esk2085_4(X1,X2,X3,X4) ) ).

cnf(i_0_10331,axiom,
    ( ~ esk12208_4(X1,X2,X3,X4)
    | esk12227_4(X1,X2,X3,X4) ) ).

cnf(i_0_10332,axiom,
    ( esk16091_4(X1,X2,X3,X4)
    | ~ esk16349_4(X1,X2,X3,X4) ) ).

cnf(i_0_10333,axiom,
    ( esk12578_4(X1,X2,X3,X4)
    | esk12629_4(X1,X2,X3,X4)
    | ~ esk12658_4(X1,X2,X3,X4) ) ).

cnf(i_0_10334,axiom,
    ( esk238_0
    | ~ esk513_4(X1,X2,X3,X4)
    | p(X2)
    | ~ p(X3)
    | ~ p(X1)
    | ~ p(X4) ) ).

cnf(i_0_10335,axiom,
    ( esk3990_4(X1,X2,X3,X4)
    | ~ esk4003_4(X1,X2,X3,X4)
    | ~ esk4115_4(X1,X2,X3,X4) ) ).

cnf(i_0_10336,axiom,
    ( ~ esk4775_4(X1,X2,X3,X4)
    | ~ esk4777_4(X1,X2,X3,X4) ) ).

cnf(i_0_10337,axiom,
    ( ~ esk12771_4(X1,X2,X3,X4)
    | ~ esk12793_4(X1,X2,X3,X4) ) ).

cnf(i_0_10338,axiom,
    ( ~ esk12499_4(X1,X2,X3,X4)
    | ~ esk12497_4(X1,X2,X3,X4) ) ).

cnf(i_0_10339,axiom,
    ( esk457_4(X1,X2,X3,X4)
    | esk481_4(X1,X2,X3,X4) ) ).

cnf(i_0_10340,axiom,
    ( ~ esk509_4(X1,X2,X3,X4)
    | esk207_0
    | ~ p(X1)
    | p(X4)
    | p(X2)
    | ~ p(X3) ) ).

cnf(i_0_10341,axiom,
    ( ~ esk7615_4(X1,X2,X3,X4)
    | ~ esk7613_4(X1,X2,X3,X4) ) ).

cnf(i_0_10342,axiom,
    ( ~ esk1871_4(X1,X2,X3,X4)
    | ~ esk1790_4(X1,X2,X3,X4) ) ).

cnf(i_0_10343,axiom,
    ( ~ esk2965_4(X1,X2,X3,X4)
    | esk2941_4(X1,X2,X3,X4) ) ).

cnf(i_0_10344,axiom,
    ( ~ esk8779_4(X1,X2,X3,X4)
    | ~ esk8761_4(X1,X2,X3,X4) ) ).

cnf(i_0_10345,axiom,
    ( esk2338_4(X1,X2,X3,X4)
    | esk2339_4(X1,X2,X3,X4)
    | esk2340_4(X1,X2,X3,X4) ) ).

cnf(i_0_10346,axiom,
    ( esk539_4(X1,X2,X3,X4)
    | ~ esk569_4(X1,X2,X3,X4)
    | esk517_4(X1,X2,X3,X4) ) ).

cnf(i_0_10347,axiom,
    ( ~ esk746_4(X1,X2,X3,X4)
    | ~ esk793_4(X1,X2,X3,X4)
    | ~ esk714_4(X1,X2,X3,X4) ) ).

cnf(i_0_10348,axiom,
    ( ~ esk11206_4(X1,X2,X3,X4)
    | esk11220_4(X1,X2,X3,X4) ) ).

cnf(i_0_10349,axiom,
    ( esk8192_4(X1,X2,X3,X4)
    | esk8225_4(X1,X2,X3,X4) ) ).

cnf(i_0_10350,axiom,
    ( esk14663_4(X1,X2,X3,X4)
    | esk14670_4(X1,X2,X3,X4) ) ).

cnf(i_0_10351,axiom,
    ( ~ esk2085_4(X1,X2,X3,X4)
    | ~ esk2086_4(X1,X2,X3,X4) ) ).

cnf(i_0_10352,axiom,
    ( esk2012_4(X1,X2,X3,X4)
    | esk1997_4(X1,X2,X3,X4) ) ).

cnf(i_0_10353,axiom,
    ( p(X3)
    | ~ esk63_0
    | esk16681_4(X1,X2,X3,X4)
    | p(X4)
    | p(X2)
    | p(X1) ) ).

cnf(i_0_10354,axiom,
    ( ~ esk725_4(X1,X2,X3,X4)
    | ~ esk706_4(X1,X2,X3,X4)
    | ~ esk726_4(X1,X2,X3,X4) ) ).

cnf(i_0_10355,axiom,
    ( ~ esk16350_4(X1,X2,X3,X4)
    | ~ esk16349_4(X1,X2,X3,X4) ) ).

cnf(i_0_10356,axiom,
    ( ~ esk16037_4(X1,X2,X3,X4)
    | esk16068_4(X1,X2,X3,X4) ) ).

cnf(i_0_10357,axiom,
    ( esk9274_4(X1,X2,X3,X4)
    | esk9259_4(X1,X2,X3,X4) ) ).

cnf(i_0_10358,axiom,
    ( esk363_4(X1,X2,X3,X4)
    | ~ esk388_4(X1,X2,X3,X4) ) ).

cnf(i_0_10359,axiom,
    ( esk12645_4(X1,X2,X3,X4)
    | ~ esk12594_4(X1,X2,X3,X4)
    | esk12620_4(X1,X2,X3,X4) ) ).

cnf(i_0_10360,axiom,
    ( esk10200_4(X1,X2,X3,X4)
    | ~ esk10196_4(X1,X2,X3,X4)
    