%--------------------------------------------------------------------------
% File     : HWV023-1 : TPTP v9.2.0. Released v2.5.0.
% Domain   : Hardware Verification
% Problem  : Safelogic VHDL design verification obligation
% Version  : [Mar02] axioms : Especial.
% English  :

% Refs     : [CHM02] Claessen et al. (2002), Verification of Hardware Systems
%          : [Mar02] Martensson (2002), Email to G. Sutcliffe
% Source   : [Mar02]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.05 v9.0.0, 0.10 v8.1.0, 0.05 v7.5.0, 0.11 v7.4.0, 0.06 v7.3.0, 0.08 v7.1.0, 0.00 v7.0.0, 0.07 v6.4.0, 0.00 v6.3.0, 0.09 v6.2.0, 0.10 v6.1.0, 0.21 v6.0.0, 0.10 v5.5.0, 0.25 v5.3.0, 0.22 v5.2.0, 0.25 v5.1.0, 0.24 v5.0.0, 0.14 v4.1.0, 0.23 v4.0.1, 0.27 v4.0.0, 0.18 v3.7.0, 0.00 v3.3.0, 0.07 v3.2.0, 0.15 v3.1.0, 0.09 v2.7.0, 0.08 v2.6.0, 0.12 v2.5.0
% Syntax   : Number of clauses     :   95 (  11 unt;  64 nHn;  86 RR)
%            Number of literals    :  374 (  51 equ; 158 neg)
%            Maximal clause size   :    7 (   3 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   11 (  11 usr;   4 con; 0-2 aty)
%            Number of variables   :  139 (   5 sgn)
% SPC      : CNF_UNS_RFO_SEQ_NHN

% Comments :
%--------------------------------------------------------------------------
%----Include equality
%----Include VHDL design axioms
include('Axioms/HWV003-0.ax').
%--------------------------------------------------------------------------
cnf(quest_1,negated_conjecture,
    level(t_139) = n1 ).

cnf(quest_2,negated_conjecture,
    ~ p_Wr(t_139) ).

cnf(quest_3,negated_conjecture,
    p_Rd(t_139) ).

cnf(quest_4,negated_conjecture,
    ~ p_Reset(t_139) ).

cnf(quest_5,negated_conjecture,
    ~ p_Empty(plus(t_139,n1)) ).

%--------------------------------------------------------------------------
