%--------------------------------------------------------------------------
% File     : HWV008-2.002 : TPTP v9.2.0. Bugfixed v2.7.0.
% Domain   : Hardware Verification
% Problem  : 2 bit ripple carry adder
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.00 v7.5.0, 0.17 v7.4.0, 0.00 v7.0.0, 0.12 v6.3.0, 0.14 v6.2.0, 0.00 v3.1.0, 0.17 v2.7.0
% Syntax   : Number of clauses     :   74 (  12 unt;   5 nHn;  74 RR)
%            Number of literals    :  163 (   0 equ;  91 neg)
%            Maximal clause size   :    4 (   2 avg)
%            Maximal term depth    :    4 (   2 avg)
%            Number of predicates  :   13 (  13 usr;   0 prp; 1-2 aty)
%            Number of functors    :   20 (  20 usr;   1 con; 0-1 aty)
%            Number of variables   :   66 (   0 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
% Bugfixes : v2.2.0 - Missing conjecture clauses added.
%          : v2.7.0 - Bugfix in HWV002-0.ax
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV002-0.ax').
%----Include model of halfadder
include('Axioms/HWV002-1.ax').
%----Include model of fulladder
include('Axioms/HWV002-2.ax').
%--------------------------------------------------------------------------
%----Composition of 2-bit adder
cnf(nbit_adder_fulladder1,axiom,
    ( ~ nbit_adder2(X)
    | fulladder(f1(X)) ) ).

cnf(nbit_adder_fulladder2,axiom,
    ( ~ nbit_adder2(X)
    | fulladder(f2(X)) ) ).

%----Connections of 2-bit adder
cnf(nbit_adder_connection_out1_out1f1,axiom,
    ( ~ nbit_adder2(X)
    | connection(out1(X),out1(f1(X))) ) ).

cnf(nbit_adder_connection_out2_out1f2,axiom,
    ( ~ nbit_adder2(X)
    | connection(out2(X),out1(f2(X))) ) ).

cnf(nbit_adder_connection_outc_outcf1,axiom,
    ( ~ nbit_adder2(X)
    | connection(outc(X),outc(f2(X))) ) ).

cnf(nbit_adder_connection_ina1_in1f1,axiom,
    ( ~ nbit_adder2(X)
    | connection(ina1(X),in1(f1(X))) ) ).

cnf(nbit_adder_connection_inb1_in2f1,axiom,
    ( ~ nbit_adder2(X)
    | connection(inb1(X),in2(f1(X))) ) ).

cnf(nbit_adder_connection_ina2_in1f2,axiom,
    ( ~ nbit_adder2(X)
    | connection(ina2(X),in1(f2(X))) ) ).

cnf(nbit_adder_connection_inb2_in2f2,axiom,
    ( ~ nbit_adder2(X)
    | connection(inb2(X),in2(f2(X))) ) ).

cnf(nbit_adder_connection_inc_incf1,axiom,
    ( ~ nbit_adder2(X)
    | connection(outc(f1(X)),inc(f2(X))) ) ).

cnf(nbit_adder_connection_inc_incf2,axiom,
    ( ~ nbit_adder2(X)
    | connection(inc(X),inc(f1(X))) ) ).

%----Observations
cnf(a_isa_2bit_adder,hypothesis,
    nbit_adder2(a) ).

cnf(ina1_0,hypothesis,
    zero(ina1(a)) ).

cnf(ina2_0,hypothesis,
    zero(ina2(a)) ).

cnf(inb1_0,hypothesis,
    zero(inb1(a)) ).

cnf(inb2_0,hypothesis,
    zero(inb2(a)) ).

cnf(inc_0,hypothesis,
    zero(inc(a)) ).

cnf(out1_0,hypothesis,
    zero(out1(a)) ).

cnf(out2_0,hypothesis,
    zero(out2(a)) ).

cnf(outc_1,hypothesis,
    one(outc(a)) ).

%----Minimal diagnosis
cnf(diagnosis_or1f2a,negated_conjecture,
    ~ abnormal(or1(f2(a))) ).

cnf(diagnosis_and2h1f2a,negated_conjecture,
    ~ abnormal(and2(h1(f2(a)))) ).

cnf(diagnosis_and2h2f2a,negated_conjecture,
    ~ abnormal(and2(h2(f2(a)))) ).

%--------------------------------------------------------------------------
