%--------------------------------------------------------------------------
% File     : HWV008-2.001 : TPTP v9.2.0. Bugfixed v2.7.0.
% Domain   : Hardware Verification
% Problem  : 1 bit ripple carry adder
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.00 v7.5.0, 0.17 v7.4.0, 0.00 v6.3.0, 0.14 v6.2.0, 0.00 v3.1.0, 0.17 v2.7.0
% Syntax   : Number of clauses     :   66 (   9 unt;   5 nHn;  66 RR)
%            Number of literals    :  150 (   0 equ;  86 neg)
%            Maximal clause size   :    4 (   2 avg)
%            Maximal term depth    :    4 (   2 avg)
%            Number of predicates  :   13 (  13 usr;   0 prp; 1-2 aty)
%            Number of functors    :   16 (  16 usr;   1 con; 0-1 aty)
%            Number of variables   :   61 (   0 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
% Bugfixes : v2.7.0 - Bugfix in HWV002-0.ax
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV002-0.ax').
%----Include model of halfadder
include('Axioms/HWV002-1.ax').
%----Include model of fulladder
include('Axioms/HWV002-2.ax').
%--------------------------------------------------------------------------
%----Composition of 1-bit adder
cnf(nbit_adder_fulladder1,axiom,
    ( ~ nbit_adder1(X)
    | fulladder(f1(X)) ) ).

%----Connections of 1-bit adder
cnf(nbit_adder_connection_out1_out1f1,axiom,
    ( ~ nbit_adder1(X)
    | connection(out1(X),outs(f1(X))) ) ).

cnf(nbit_adder_connection_outc_outcf1,axiom,
    ( ~ nbit_adder1(X)
    | connection(outc(X),outc(f1(X))) ) ).

cnf(nbit_adder_connection_ina1_in1f1,axiom,
    ( ~ nbit_adder1(X)
    | connection(ina1(X),in1(f1(X))) ) ).

cnf(nbit_adder_connection_inb1_in2f1,axiom,
    ( ~ nbit_adder1(X)
    | connection(inb1(X),in2(f1(X))) ) ).

cnf(nbit_adder_connection_inc_incf1,axiom,
    ( ~ nbit_adder1(X)
    | connection(inc(X),inc(f1(X))) ) ).

%----Observations
cnf(a_isa_1bit_adder,hypothesis,
    nbit_adder1(a) ).

cnf(ina1_0,hypothesis,
    zero(ina1(a)) ).

cnf(inb1_0,hypothesis,
    zero(inb1(a)) ).

cnf(inc_0,hypothesis,
    zero(inc(a)) ).

cnf(out1_0,hypothesis,
    zero(out1(a)) ).

cnf(outc_0,hypothesis,
    one(outc(a)) ).

%----Minimal diagnosis
cnf(diagnosis_or1f1,negated_conjecture,
    ~ abnormal(or1(f1(a))) ).

cnf(diagnosis_and2h1f1,negated_conjecture,
    ~ abnormal(and2(h1(f1(a)))) ).

cnf(diagnosis_and2h2f1,negated_conjecture,
    ~ abnormal(and2(h2(f1(a)))) ).

%--------------------------------------------------------------------------
