%--------------------------------------------------------------------------
% File     : HWV008-1.002 : TPTP v9.2.0. Bugfixed v2.2.0.
% Domain   : Hardware Verification
% Problem  : 2 bit ripple carry adder
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.08 v9.1.0, 0.09 v9.0.0, 0.08 v8.2.0, 0.14 v8.1.0, 0.00 v7.5.0, 0.17 v7.4.0, 0.00 v7.0.0, 0.25 v6.3.0, 0.29 v6.2.0, 0.11 v6.1.0, 0.00 v5.0.0, 0.14 v4.1.0, 0.12 v4.0.1, 0.20 v4.0.0, 0.14 v3.4.0, 0.25 v3.3.0, 0.00 v3.1.0, 0.17 v2.7.0, 0.12 v2.6.0, 0.00 v2.2.1
% Syntax   : Number of clauses     :   68 (  14 unt;   3 nHn;  68 RR)
%            Number of literals    :  158 (   0 equ;  93 neg)
%            Maximal clause size   :    5 (   2 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :    5 (   5 usr;   0 prp; 2-2 aty)
%            Number of functors    :   27 (  27 usr;  17 con; 0-2 aty)
%            Number of variables   :   63 (   3 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
% Bugfixes : v2.2.0 - Missing conjecture clauses added.
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV001-0.ax').
%----Include model of halfadder
include('Axioms/HWV001-1.ax').
%----Include model of fulladder
include('Axioms/HWV001-2.ax').
%--------------------------------------------------------------------------
%----Composition of 2-bit adder
cnf(nbit_adder_fulladder1,axiom,
    ( ~ type(X,nbit_adder(n2))
    | type(f(n1,X),fulladder) ) ).

cnf(nbit_adder_fulladder2,axiom,
    ( ~ type(X,nbit_adder(n2))
    | type(f(n2,X),fulladder) ) ).

%----Connections of 2-bit adder
cnf(nbit_adder_connection_out1_out1f1,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(out(n1,X),out(n1,f(n1,X))) ) ).

cnf(nbit_adder_connection_out2_out1f2,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(out(n2,X),out(n1,f(n2,X))) ) ).

cnf(nbit_adder_connection_outc_outcf1,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(out(c,X),out(c,f(n2,X))) ) ).

cnf(nbit_adder_connection_ina1_in1f1,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(in(a1,X),in(n1,f(n1,X))) ) ).

cnf(nbit_adder_connection_inb1_in2f1,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(in(b1,X),in(n2,f(n1,X))) ) ).

cnf(nbit_adder_connection_ina2_in1f2,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(in(a2,X),in(n1,f(n2,X))) ) ).

cnf(nbit_adder_connection_inb2_in2f2,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(in(b2,X),in(n2,f(n2,X))) ) ).

cnf(nbit_adder_connection_inc_incf1,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(out(c,f(n1,X)),in(c,f(n2,X))) ) ).

cnf(nbit_adder_connection_inc_incf2,axiom,
    ( ~ type(X,nbit_adder(n2))
    | connection(in(c,X),in(c,f(n1,X))) ) ).

%----Observations
cnf(a_isa_2bit_adder,hypothesis,
    type(a,nbit_adder(n2)) ).

cnf(ina1_0,hypothesis,
    value(in(a1,a),n0) ).

cnf(ina2_0,hypothesis,
    value(in(a2,a),n0) ).

cnf(inb1_0,hypothesis,
    value(in(b1,a),n0) ).

cnf(inb2_0,hypothesis,
    value(in(b2,a),n0) ).

cnf(inc_0,hypothesis,
    value(in(c,a),n0) ).

cnf(out1_0,hypothesis,
    value(out(n1,a),n0) ).

cnf(out2_0,hypothesis,
    value(out(n2,a),n0) ).

cnf(outc_1,hypothesis,
    value(out(c,a),n1) ).

%----Minimal diagnosis
cnf(diagnosis_or1f2a,negated_conjecture,
    ~ mode(or1(f(n2,a)),abnormal) ).

cnf(diagnosis_and2h2f2a,negated_conjecture,
    ~ mode(and2(h1(f(n2,a))),abnormal) ).

cnf(diagnosis_and2h1f2a,negated_conjecture,
    ~ mode(and2(h2(f(n2,a))),abnormal) ).

%--------------------------------------------------------------------------
