%--------------------------------------------------------------------------
% File     : HWV008-1.001 : TPTP v9.2.0. Released v2.1.0.
% Domain   : Hardware Verification
% Problem  : 1 bit ripple carry adder
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.08 v9.1.0, 0.09 v9.0.0, 0.08 v8.2.0, 0.14 v8.1.0, 0.00 v7.5.0, 0.17 v7.4.0, 0.00 v7.1.0, 0.17 v7.0.0, 0.38 v6.3.0, 0.14 v6.2.0, 0.11 v6.1.0, 0.00 v5.0.0, 0.14 v4.1.0, 0.12 v4.0.1, 0.20 v4.0.0, 0.14 v3.4.0, 0.25 v3.3.0, 0.00 v3.1.0, 0.17 v2.7.0, 0.12 v2.6.0, 0.00 v2.2.1, 0.33 v2.1.0
% Syntax   : Number of clauses     :   60 (  11 unt;   3 nHn;  60 RR)
%            Number of literals    :  145 (   0 equ;  88 neg)
%            Maximal clause size   :    5 (   2 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of predicates  :    5 (   5 usr;   0 prp; 2-2 aty)
%            Number of functors    :   25 (  25 usr;  15 con; 0-2 aty)
%            Number of variables   :   58 (   3 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV001-0.ax').
%----Include model of halfadder
include('Axioms/HWV001-1.ax').
%----Include model of fulladder
include('Axioms/HWV001-2.ax').
%--------------------------------------------------------------------------
%----Composition of 1-bit adder
cnf(nbit_adder_fulladder1,axiom,
    ( ~ type(X,nbit_adder(n1))
    | type(v(n1,X),fulladder) ) ).

%----Connections of 1-bit adder
cnf(nbit_adder_connection_out1_out1v1,axiom,
    ( ~ type(X,nbit_adder(n1))
    | connection(out(n1,X),out(s,v(n1,X))) ) ).

cnf(nbit_adder_connection_outc_outcv1,axiom,
    ( ~ type(X,nbit_adder(n1))
    | connection(out(c,X),out(c,v(n1,X))) ) ).

cnf(nbit_adder_connection_ina1_in1v1,axiom,
    ( ~ type(X,nbit_adder(n1))
    | connection(in(a1,X),in(n1,v(n1,X))) ) ).

cnf(nbit_adder_connection_inb1_in2v1,axiom,
    ( ~ type(X,nbit_adder(n1))
    | connection(in(b1,X),in(n2,v(n1,X))) ) ).

cnf(nbit_adder_connection_inc_incv1,axiom,
    ( ~ type(X,nbit_adder(n1))
    | connection(in(c,X),in(c,v(n1,X))) ) ).

%----Observations
cnf(a_isa_1bit_adder,hypothesis,
    type(a,nbit_adder(n1)) ).

cnf(ina1_0,hypothesis,
    value(in(a1,a),n0) ).

cnf(inb1_0,hypothesis,
    value(in(b1,a),n0) ).

cnf(inc_0,hypothesis,
    value(in(c,a),n0) ).

cnf(out1_0,hypothesis,
    value(out(n1,a),n0) ).

cnf(outc_0,hypothesis,
    value(out(c,a),n1) ).

%----Minimal diagnosis
cnf(diagnosis_or1v1,negated_conjecture,
    ~ mode(or1(v(n1,a)),abnormal) ).

cnf(diagnosis_and2h1v1,negated_conjecture,
    ~ mode(and2(h1(v(n1,a))),abnormal) ).

cnf(diagnosis_and2h2v1,negated_conjecture,
    ~ mode(and2(h2(v(n1,a))),abnormal) ).

%--------------------------------------------------------------------------
