%--------------------------------------------------------------------------
% File     : HWV007-2 : TPTP v9.2.0. Bugfixed v2.7.0.
% Domain   : Hardware Verification
% Problem  : A fulladder built from two halfadders and an or gate
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.00 v7.1.0, 0.17 v7.0.0, 0.12 v6.3.0, 0.14 v6.2.0, 0.00 v2.7.0
% Syntax   : Number of clauses     :   62 (   7 unt;   5 nHn;  62 RR)
%            Number of literals    :  144 (   0 equ;  86 neg)
%            Maximal clause size   :    4 (   2 avg)
%            Maximal term depth    :    3 (   2 avg)
%            Number of predicates  :   12 (  12 usr;   0 prp; 1-2 aty)
%            Number of functors    :   13 (  13 usr;   1 con; 0-1 aty)
%            Number of variables   :   55 (   0 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
% Bugfixes : v2.7.0 - Bugfix in HWV002-0.ax
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV002-0.ax').
%----Include model of halfadder
include('Axioms/HWV002-1.ax').
%----Include model of fulladder
include('Axioms/HWV002-2.ax').
%--------------------------------------------------------------------------
%----Observations
cnf(f_isa_fulladder,hypothesis,
    fulladder(f) ).

cnf(in1_1,hypothesis,
    zero(in1(f)) ).

cnf(in2_0,hypothesis,
    one(in2(f)) ).

cnf(inc_1,hypothesis,
    one(inc(f)) ).

cnf(outs_1,hypothesis,
    one(outs(f)) ).

cnf(outc_0,hypothesis,
    zero(outc(f)) ).

%----Minimal diagnosis
cnf(diagnosis_and2h1,negated_conjecture,
    ~ abnormal(and2(h1(f))) ).

cnf(diagnosis_or1_and1h1,negated_conjecture,
    ( ~ abnormal(or1(f))
    | ~ abnormal(and1(h1(f))) ) ).

cnf(diagnosis_or1_not1h1,negated_conjecture,
    ( ~ abnormal(or1(f))
    | ~ abnormal(not1(h1(f))) ) ).

cnf(diagnosis_or1_and1h2,negated_conjecture,
    ( ~ abnormal(or1(f))
    | ~ abnormal(and1(h2(f))) ) ).

cnf(diagnosis_or1_or1h2,negated_conjecture,
    ( ~ abnormal(or1(f))
    | ~ abnormal(or1(h2(f))) ) ).

%--------------------------------------------------------------------------
