%--------------------------------------------------------------------------
% File     : HWV007-1 : TPTP v9.2.0. Released v2.1.0.
% Domain   : Hardware Verification
% Problem  : A fulladder built from two halfadders and an or gate
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.08 v9.1.0, 0.09 v9.0.0, 0.08 v8.2.0, 0.14 v8.1.0, 0.00 v7.0.0, 0.25 v6.4.0, 0.12 v6.3.0, 0.29 v6.2.0, 0.11 v6.1.0, 0.00 v5.2.0, 0.10 v5.1.0, 0.09 v5.0.0, 0.14 v4.1.0, 0.12 v4.0.1, 0.20 v4.0.0, 0.14 v3.4.0, 0.25 v3.3.0, 0.00 v2.6.0, 0.33 v2.5.0, 0.20 v2.4.0, 0.00 v2.2.1, 0.33 v2.1.0
% Syntax   : Number of clauses     :   56 (   9 unt;   3 nHn;  56 RR)
%            Number of literals    :  139 (   0 equ;  88 neg)
%            Maximal clause size   :    5 (   2 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    5 (   5 usr;   0 prp; 2-2 aty)
%            Number of functors    :   21 (  21 usr;  13 con; 0-2 aty)
%            Number of variables   :   52 (   3 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV001-0.ax').
%----Include model of halfadder
include('Axioms/HWV001-1.ax').
%----Include model of fulladder
include('Axioms/HWV001-2.ax').
%--------------------------------------------------------------------------
%----Observations
cnf(f_isa_fulladder,hypothesis,
    type(f,fulladder) ).

cnf(in1_1,hypothesis,
    value(in(n1,f),n0) ).

cnf(in2_0,hypothesis,
    value(in(n2,f),n1) ).

cnf(inc_1,hypothesis,
    value(in(c,f),n1) ).

cnf(outs_1,hypothesis,
    value(out(s,f),n1) ).

cnf(outc_0,hypothesis,
    value(out(c,f),n0) ).

%----Minimal diagnosis
cnf(diagnosis_and2h1,negated_conjecture,
    ~ mode(and2(h1(f)),abnormal) ).

cnf(diagnosis_or1_and1h1,negated_conjecture,
    ( ~ mode(or1(f),abnormal)
    | ~ mode(and1(h1(f)),abnormal) ) ).

cnf(diagnosis_or1_not1h1,negated_conjecture,
    ( ~ mode(or1(f),abnormal)
    | ~ mode(not1(h1(f)),abnormal) ) ).

cnf(diagnosis_or1_and1h2,negated_conjecture,
    ( ~ mode(or1(f),abnormal)
    | ~ mode(and1(h2(f)),abnormal) ) ).

cnf(diagnosis_or1_or1h2,negated_conjecture,
    ( ~ mode(or1(f),abnormal)
    | ~ mode(or1(h2(f)),abnormal) ) ).

%--------------------------------------------------------------------------
