%--------------------------------------------------------------------------
% File     : HWV005-2 : TPTP v9.2.0. Bugfixed v2.7.0.
% Domain   : Hardware Verification
% Problem  : A halfadder built from and, or and not gates
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.00 v2.7.0
% Syntax   : Number of clauses     :   48 (   8 unt;   5 nHn;  48 RR)
%            Number of literals    :  115 (   0 equ;  69 neg)
%            Maximal clause size   :    4 (   2 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :   11 (  11 usr;   0 prp; 1-2 aty)
%            Number of functors    :   10 (  10 usr;   1 con; 0-1 aty)
%            Number of variables   :   44 (   0 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
% Bugfixes : v2.7.0 - Bugfix in HWV002-0.ax
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV002-0.ax').
%----Include model of halfadder
include('Axioms/HWV002-1.ax').
%--------------------------------------------------------------------------
%----Observations
cnf(h_isa_halfadder,hypothesis,
    halfadder(h) ).

cnf(in1_1,hypothesis,
    one(in1(h)) ).

cnf(in2_0,hypothesis,
    zero(in2(h)) ).

cnf(outs_0,hypothesis,
    zero(outs(h)) ).

cnf(outc_0,hypothesis,
    zero(outc(h)) ).

cnf(diagnosis_and1,negated_conjecture,
    ~ abnormal(and1(h)) ).

cnf(diagnosis_not1,negated_conjecture,
    ~ abnormal(not1(h)) ).

cnf(diagnosis_or1,negated_conjecture,
    ~ abnormal(or1(h)) ).

%--------------------------------------------------------------------------
