%--------------------------------------------------------------------------
% File     : HWV005-1 : TPTP v9.2.0. Released v2.1.0.
% Domain   : Hardware Verification
% Problem  : A halfadder built from and, or and not gates
% Version  : [Gei96] axioms.
% English  :

% Refs     : [Gei96] Geisler (1996), Email to G. Sutcliffe
% Source   : [Gei96]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.00 v7.1.0, 0.17 v7.0.0, 0.12 v6.3.0, 0.14 v6.2.0, 0.00 v2.1.0
% Syntax   : Number of clauses     :   42 (  10 unt;   3 nHn;  42 RR)
%            Number of literals    :  110 (   0 equ;  71 neg)
%            Maximal clause size   :    5 (   2 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    5 (   5 usr;   0 prp; 2-2 aty)
%            Number of functors    :   18 (  18 usr;  12 con; 0-2 aty)
%            Number of variables   :   41 (   3 sgn)
% SPC      : CNF_UNS_RFO_NEQ_NHN

% Comments :
%--------------------------------------------------------------------------
%----Include basic diagnosis axioms
include('Axioms/HWV001-0.ax').
%----Include model of halfadder
include('Axioms/HWV001-1.ax').
%--------------------------------------------------------------------------
%----Observations
cnf(h_isa_halfadder,hypothesis,
    type(h,halfadder) ).

cnf(in1_1,hypothesis,
    value(in(n1,h),n1) ).

cnf(in2_0,hypothesis,
    value(in(n2,h),n0) ).

cnf(outs_0,hypothesis,
    value(out(s,h),n0) ).

cnf(outc_0,hypothesis,
    value(out(c,h),n0) ).

cnf(diagnosis_and1,negated_conjecture,
    ~ mode(and1(h),abnormal) ).

cnf(diagnosis_not1,negated_conjecture,
    ~ mode(not1(h),abnormal) ).

cnf(diagnosis_or1,negated_conjecture,
    ~ mode(or1(h),abnormal) ).

%--------------------------------------------------------------------------
