%--------------------------------------------------------------------------
% File     : GRP181-1 : TPTP v9.2.0. Bugfixed v1.2.1.
% Domain   : Group Theory (Lattice Ordered)
% Problem  : Distributivity of a lattice
% Version  : [Fuc94] (equality) axioms.
% English  :

% Refs     : [Fuc94] Fuchs (1994), The Application of Goal-Orientated Heuri
%          : [Sch95] Schulz (1995), Explanation Based Learning for Distribu
% Source   : [TPTP]
% Names    :

% Status   : Unsatisfiable
% Rating   : 0.65 v9.1.0, 0.68 v8.2.0, 0.67 v8.1.0, 0.65 v7.5.0, 0.62 v7.4.0, 0.65 v7.3.0, 0.63 v7.1.0, 0.56 v7.0.0, 0.63 v6.4.0, 0.68 v6.3.0, 0.65 v6.2.0, 0.64 v6.1.0, 0.81 v5.5.0, 0.89 v5.4.0, 0.87 v5.3.0, 0.75 v5.2.0, 0.79 v5.1.0, 0.73 v5.0.0, 0.71 v4.1.0, 0.55 v4.0.1, 0.64 v4.0.0, 0.62 v3.7.0, 0.56 v3.4.0, 0.75 v3.3.0, 0.71 v3.1.0, 0.56 v2.7.0, 0.55 v2.6.0, 0.67 v2.5.0, 0.50 v2.4.0, 0.00 v2.2.1, 0.89 v2.2.0, 0.86 v2.1.0, 1.00 v2.0.0
% Syntax   : Number of clauses     :   18 (  18 unt;   0 nHn;   3 RR)
%            Number of literals    :   18 (  18 equ;   1 neg)
%            Maximal clause size   :    1 (   1 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number of predicates  :    1 (   0 usr;   0 prp; 2-2 aty)
%            Number of functors    :    8 (   8 usr;   4 con; 0-2 aty)
%            Number of variables   :   33 (   2 sgn)
% SPC      : CNF_UNS_RFO_PEQ_UEQ

% Comments : ORDERING LPO inverse > product > greatest_lower_bound >
%            least_upper_bound > identity > a > b > c
%          : ORDERING LPO greatest_lower_bound > least_upper_bound >
%            inverse > product > identity > a > b > c
%          : This is a standardized version of the problem that appears in
%            [Sch95].
% Bugfixes : v1.2.1 - Duplicate axioms in GRP004-2.ax removed.
%--------------------------------------------------------------------------
%----Include equality group theory axioms
include('Axioms/GRP004-0.ax').
%----Include Lattice ordered group (equality) axioms
include('Axioms/GRP004-2.ax').
%--------------------------------------------------------------------------
cnf(p12_1,hypothesis,
    greatest_lower_bound(a,c) = greatest_lower_bound(b,c) ).

cnf(p12_2,hypothesis,
    least_upper_bound(a,c) = least_upper_bound(b,c) ).

cnf(prove_p12,negated_conjecture,
    a != b ).

%--------------------------------------------------------------------------
