%--------------------------------------------------------------------------
% File     : GRP088-1 : TPTP v9.2.0. Bugfixed v2.7.0.
% Domain   : Group Theory (Abelian)
% Problem  : Single axiom for Abelian group theory, in division
% Version  : [McC93] (equality) axioms.
% English  : This is a single axiom for Abelian group theory, in terms
%            of division

% Refs     : [Tar38] Tarski (1938), Ein Beitrag zur Axiomatik der Abelschen
%          : [McC93] McCune (1993), Single Axioms for Groups and Abelian Gr
% Source   : [McC93]
% Names    : Axiom 2.3 [McC93]

% Status   : Unsatisfiable
% Rating   : 0.18 v9.1.0, 0.33 v9.0.0, 0.27 v8.2.0, 0.25 v8.1.0, 0.16 v7.5.0, 0.24 v7.4.0, 0.29 v7.3.0, 0.31 v7.2.0, 0.33 v7.1.0, 0.27 v7.0.0, 0.15 v6.4.0, 0.29 v6.3.0, 0.10 v6.2.0, 0.30 v6.1.0, 0.27 v6.0.0, 0.29 v5.5.0, 0.38 v5.4.0, 0.22 v5.3.0, 0.40 v5.2.0, 0.25 v5.1.0, 0.33 v5.0.0, 0.30 v4.1.0, 0.33 v4.0.1, 0.38 v4.0.0, 0.29 v3.7.0, 0.14 v3.4.0, 0.00 v3.3.0, 0.22 v3.2.0, 0.11 v3.1.0, 0.00 v2.7.0
% Syntax   : Number of clauses     :    4 (   3 unt;   0 nHn;   1 RR)
%            Number of literals    :    7 (   7 equ;   4 neg)
%            Maximal clause size   :    4 (   1 avg)
%            Maximal term depth    :    5 (   2 avg)
%            Number of predicates  :    1 (   0 usr;   0 prp; 2-2 aty)
%            Number of functors    :   12 (  12 usr;   9 con; 0-2 aty)
%            Number of variables   :    8 (   0 sgn)
% SPC      : CNF_UNS_RFO_PEQ_NUE

% Comments :
% Bugfixes : v2.3.0 - Deleted division, added multiply and inverse.
%          : v2.7.0 - Grounded conjecture
%--------------------------------------------------------------------------
cnf(single_axiom,axiom,
    divide(X,divide(Y,divide(Z,divide(X,Y)))) = Z ).

%----Definition of multiply
cnf(multiply,axiom,
    multiply(X,Y) = divide(X,divide(divide(Z,Z),Y)) ).

%----Definition of inverse
cnf(inverse,axiom,
    inverse(X) = divide(divide(Z,Z),X) ).

cnf(prove_these_axioms,negated_conjecture,
    ( multiply(inverse(a1),a1) != multiply(inverse(b1),b1)
    | multiply(multiply(inverse(b2),b2),a2) != a2
    | multiply(multiply(a3,b3),c3) != multiply(a3,multiply(b3,c3))
    | multiply(a4,b4) != multiply(b4,a4) ) ).

%--------------------------------------------------------------------------
