%------------------------------------------------------------------------------
% File     : GEO209+2 : TPTP v9.2.0. Released v3.3.0.
% Domain   : Geometry (Constructive)
% Problem  : Pont and three parallel lines
% Version  : [vPl95] axioms : Reduced > Especial.
% English  : If the point A is apart from the line L, but incident with the
%            lines M and N, and L is parallel to M and N, then M and N are
%            equal.

% Refs     : [vPl95] von Plato (1995), The Axioms of Constructive Geometry
%          : [Li97]  Li (1997), Replacing the Axioms for Connecting Lines a
%          : [Li98]  Li (1998), A Shorter and Intuitive Axiom to Replace th
%          : [ROK06] Raths et al. (2006), The ILTP Problem Library for Intu
% Source   : [ILTP]
% Names    :

% Status   : Theorem
% Rating   : 0.00 v9.1.0, 0.07 v9.0.0, 0.00 v6.1.0, 0.04 v6.0.0, 0.25 v5.5.0, 0.08 v5.4.0, 0.09 v5.3.0, 0.17 v5.2.0, 0.14 v5.0.0, 0.05 v4.1.0, 0.06 v4.0.1, 0.05 v3.7.0, 0.00 v3.3.0
% Syntax   : Number of formulae    :   16 (   5 unt;   0 def)
%            Number of atoms       :   46 (   0 equ)
%            Maximal formula atoms :    6 (   2 avg)
%            Number of connectives :   40 (  10   ~;  11   |;   6   &)
%                                         (   0 <=>;  13  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   6 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :    4 (   4 usr;   0 prp; 2-2 aty)
%            Number of functors    :    3 (   3 usr;   0 con; 2-2 aty)
%            Number of variables   :   41 (  41   !;   0   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments :  Definitions unfolded, hence Especial.
%------------------------------------------------------------------------------
include('Axioms/GEO008+0.ax').
include('Axioms/GEO006+2.ax').
%------------------------------------------------------------------------------
fof(con,conjecture,
    ! [A,L,M,N] :
      ( ( apart_point_and_line(A,L)
        & ~ apart_point_and_line(A,M)
        & ~ apart_point_and_line(A,N)
        & ~ convergent_lines(M,L)
        & ~ convergent_lines(N,L) )
     => ~ distinct_lines(M,N) ) ).

%------------------------------------------------------------------------------
