%------------------------------------------------------------------------------
% File     : CSR311_1 : TPTP v9.2.0. Released v9.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Water level is 3 at time 4
% Version  : [Mue04] axioms : Especial.
% English  :

% Refs     : [MS05]  Mueller & Sutcliffe (2005), Reasoning in the Event Cal
%          : [Mue04] Mueller (2004), A Tool for Satisfiability-based Common
%          : [MS02]  Miller & Shanahan (2002), Some Alternative Formulation
% Source   : [MS05]
% Names    :

% Status   : Theorem
% Rating   : 0.50 v9.1.0
% Syntax   : Number of formulae    :   52 (  12 unt;  20 typ;   0 def)
%            Number of atoms       :  101 (  27 equ)
%            Maximal formula atoms :   11 (   3 avg)
%            Number of connectives :   94 (  25   ~;   8   |;  42   &)
%                                         (   7 <=>;  12  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Maximal term depth    :    3 (   1 avg)
%            Number arithmetic     :   81 (   6 atm;  15 fun;  23 num;  37 var)
%            Number of types       :    5 (   3 usr;   1 ari)
%            Number of type conns  :   31 (  12   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  10 usr;   0 prp; 2-4 aty)
%            Number of functors    :   11 (   7 usr;   8 con; 0-2 aty)
%            Number of variables   :   70 (  59   !;  11   ?;  70   :)
% SPC      : TF0_THM_EQU_ARI

% Comments :
%------------------------------------------------------------------------------
%----Include event calculus axioms
include('Axioms/CSR001_0.ax').
%----Include kitchen sink axioms
include('Axioms/CSR001_1.ax').
%------------------------------------------------------------------------------
tff(happens_all_defn,axiom,
    ! [Event: event,Time: $int] :
      ( happens(Event,at_time(Time))
    <=> ( ( ( Event = tapOn )
          & ( Time = 0 ) )
        | ( holdsAt(waterLevel(3),at_time(Time))
          & holdsAt(filling,at_time(Time))
          & ( Event = overflow ) ) ) ) ).

tff(waterLevel_0,axiom,
    holdsAt(waterLevel(0),at_time(0)) ).

tff(not_filling_0,axiom,
    ~ holdsAt(filling,at_time(0)) ).

tff(not_spilling_0,axiom,
    ~ holdsAt(spilling,at_time(0)) ).

tff(not_released_waterLevel_0,axiom,
    ! [Height:$int] : ~ releasedAt(waterLevel(Height),at_time(0)) ).

tff(not_released_filling_0,axiom,
    ~ releasedAt(filling,at_time(0)) ).

tff(not_released_spilling_0,axiom,
    ~ releasedAt(spilling,at_time(0)) ).

tff(filling_or_spilling,conjecture,
    ( holdsAt(filling,at_time(3))
    | holdsAt(spilling,at_time(3)) ) ).

%------------------------------------------------------------------------------
