%------------------------------------------------------------------------------
% File     : CSR117+1 : TPTP v9.2.0. Released v4.1.0.
% Domain   : Commonsense Reasoning
% Problem  : Flooding Copenhagen
% Version  : Especial.
% English  : Find an OECD country whose capital is at the same latitude as 
%            Moscow, rounded to the nearest degree, and that can be flooded.

% Refs     : [SS+10] Sutcliffe et al. (2010), Progress Towards Effective Au
% Source   : [TPTP]
% Names    :

% Status   : Theorem
% Rating   : 0.30 v9.0.0, 0.33 v8.2.0, 0.39 v7.5.0, 0.41 v7.4.0, 0.33 v7.3.0, 0.38 v7.1.0, 0.35 v7.0.0, 0.37 v6.4.0, 0.42 v6.3.0, 0.38 v6.2.0, 0.44 v6.1.0, 0.53 v6.0.0, 0.57 v5.5.0, 0.59 v5.4.0, 0.57 v5.3.0, 0.59 v5.2.0, 0.45 v5.1.0, 0.48 v5.0.0, 0.58 v4.1.0
% Syntax   : Number of formulae    :  269 ( 226 unt;   0 def)
%            Number of atoms       :  332 (  17 equ)
%            Maximal formula atoms :   18 (   1 avg)
%            Number of connectives :   93 (  30   ~;   0   |;  19   &)
%                                         (   0 <=>;  44  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   29 (   2 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of predicates  :   24 (  23 usr;   0 prp; 1-5 aty)
%            Number of functors    :  122 ( 122 usr; 121 con; 0-1 aty)
%            Number of variables   :   71 (  43   !;  28   ?)
% SPC      : FOF_THM_RFO_SEQ

% Comments : Created by TFF to FOF conversion of the TFF problem. Some axioms
%            come from SUMO, some from XDB sources, and some are internal.
%            Arithmetic has been converted to non-numeric terms.
%------------------------------------------------------------------------------
fof(s__SetOrClass_type,axiom,
    ? [A] : s__SetOrClass(A) ).

fof(s__Entity_type,axiom,
    ? [A] : s__Entity(A) ).

fof(s__Object_type,axiom,
    ? [A] : s__Object(A) ).

fof(s__Region_type,axiom,
    ? [A] : s__Region(A) ).

fof(s__GeographicArea_type,axiom,
    ? [A] : s__GeopoliticalArea(A) ).

fof(s__Nation_type,axiom,
    ? [A] : s__Nation(A) ).

fof(s__City_type,axiom,
    ? [A] : s__City(A) ).

fof(s__WaterArea_type,axiom,
    ? [A] : s__WaterArea(A) ).

fof(s__BodyOfWater_type,axiom,
    ? [A] : s__BodyOfWater(A) ).

fof(s__Sea_type,axiom,
    ? [A] : s__Sea(A) ).

fof(s__PositionalAttribute_type,axiom,
    ? [A] : s__PositionalAttribute(A) ).

fof(s__SymmetricPositionalAttribute_type,axiom,
    ? [A] : s__SymmetricPositionalAttribute(A) ).

fof(s__CaseRole_type,axiom,
    ? [A] : s__CaseRole(A) ).

fof(s__SymbolicString_type,axiom,
    ? [A] : s__SymbolicString(A) ).

fof(kb_SUMO_MILO_701,axiom,
    ! [A] :
      ( s__Region(A)
     => s__Object(A) ) ).

fof(kb_SUMO_MILO_6365,axiom,
    ! [A] :
      ( s__GeographicArea(A)
     => s__Region(A) ) ).

fof(kb_SUMO_MILO_6345,axiom,
    ! [A] :
      ( s__GeopoliticalArea(A)
     => s__GeographicArea(A) ) ).

fof(kb_SUMO_MILO_6428,axiom,
    ! [A] :
      ( s__Nation(A)
     => s__GeopoliticalArea(A) ) ).

fof(kb_SUMO_MILO_6437,axiom,
    ! [A] :
      ( s__City(A)
     => s__GeopoliticalArea(A) ) ).

fof(kb_SUMO_MILO_6391,axiom,
    ! [A] :
      ( s__WaterArea(A)
     => s__GeographicArea(A) ) ).

fof(kb_SUMO_MILO_Domains_9582,axiom,
    ! [A] :
      ( s__BodyOfWater(A)
     => s__WaterArea(A) ) ).

fof(kb_SUMO_MILO_Domains_9679,axiom,
    ! [A] :
      ( s__Sea(A)
     => s__BodyOfWater(A) ) ).

fof(kb_SUMO_MILO_7458,axiom,
    ! [A] :
      ( s__SymmetricPositionalAttribute(A)
     => s__PositionalAttribute(A) ) ).

fof(kb_SUMO_MILO_7487,axiom,
    s__SymmetricPositionalAttribute(s__Near) ).

fof(kb_SUMO_MILO_12059,axiom,
    s__SetOrClass(s__Flooding__t) ).

fof(s__located__m_type,axiom,
    s__CaseRole(s__located__m) ).

fof(coastal_cities_near_water,axiom,
    ! [City] :
      ( s__City(City)
     => ( is_instance(City,s__CoastalCitiesClass)
       => ? [Sea] :
            ( s__Sea(Sea)
            & s__orientation(City,Sea,s__Near) ) ) ) ).

fof(flood_near_water,axiom,
    ! [W,C] :
      ( ( s__WaterArea(W)
        & s__City(C) )
     => ( s__orientation(C,W,s__Near)
       => s__capability(s__Flooding__t,s__located__m,C) ) ) ).

fof(where,conjecture,
    ? [City,Nation,CityLat,CityLong,CityName,CityNation,Latitude,MoscowLat,MoscowLong,MoscowName,MoscowNation] :
      ( s__Object(City)
      & s__Object(Nation)
      & real(CityLat)
      & real(CityLong)
      & s__SymbolicString(CityName)
      & s__SymbolicString(CityNation)
      & int(Latitude)
      & real(MoscowLat)
      & real(MoscowLong)
      & s__SymbolicString(MoscowName)
      & s__SymbolicString(MoscowNation)
      & is_instance(Nation,s__OECDMemberEconomiesClass)
      & capital_city(City,Nation)
      & look_different(City,s__Moscow)
      & latlong(City,CityLat,CityLong,CityName,CityNation)
      & latlong(s__Moscow,MoscowLat,MoscowLong,MoscowName,MoscowNation)
      & to_int(CityLat) = to_int(MoscowLat)
      & s__capability(s__Flooding__t,s__located__m,City) ) ).

fof(real_type,axiom,
    ? [A] : real(A) ).

fof(int_type,axiom,
    ? [A] : int(A) ).

fof(coastal_cities_type,axiom,
    s__Object(s__CoastalCitiesClass) ).

fof(s__Moscow_type,axiom,
    s__City(s__Moscow) ).

fof(copenhagen_coastal,axiom,
    is_instance(s__Copenhagen,s__CoastalCitiesClass) ).

fof(to_int_type,axiom,
    ! [A] :
      ( real(A)
     => int(to_int(A)) ) ).

fof(oecd_type,axiom,
    s__Object(s__OECDMemberEconomiesClass) ).

fof(s__CzechRepublic_type,axiom,
    s__Nation(s__CzechRepublic) ).

fof(s__CzechRepublic_OECD,axiom,
    is_instance(s__CzechRepublic,s__OECDMemberEconomiesClass) ).

fof(s__Denmark_type,axiom,
    s__Nation(s__Denmark) ).

fof(s__Denmark_OECD,axiom,
    is_instance(s__Denmark,s__OECDMemberEconomiesClass) ).

fof(s__Finland_type,axiom,
    s__Nation(s__Finland) ).

fof(s__Finland_OECD,axiom,
    is_instance(s__Finland,s__OECDMemberEconomiesClass) ).

fof(s__Germany_type,axiom,
    s__Nation(s__Germany) ).

fof(s__Germany_OECD,axiom,
    is_instance(s__Germany,s__OECDMemberEconomiesClass) ).

fof(s__Greece_type,axiom,
    s__Nation(s__Greece) ).

fof(s__Greece_OECD,axiom,
    is_instance(s__Greece,s__OECDMemberEconomiesClass) ).

fof(s__Hungary_type,axiom,
    s__Nation(s__Hungary) ).

fof(s__Hungary_OECD,axiom,
    is_instance(s__Hungary,s__OECDMemberEconomiesClass) ).

fof(s__Italy_type,axiom,
    s__Nation(s__Italy) ).

fof(s__Italy_OECD,axiom,
    is_instance(s__Italy,s__OECDMemberEconomiesClass) ).

fof(s__Luxembourg_type,axiom,
    s__Nation(s__Luxembourg) ).

fof(s__Luxembourg_OECD,axiom,
    is_instance(s__Luxembourg,s__OECDMemberEconomiesClass) ).

fof(s__Mexico_type,axiom,
    s__Nation(s__Mexico) ).

fof(s__Mexico_OECD,axiom,
    is_instance(s__Mexico,s__OECDMemberEconomiesClass) ).

fof(s__NewZealand_type,axiom,
    s__Nation(s__NewZealand) ).

fof(s__NewZealand_OECD,axiom,
    is_instance(s__NewZealand,s__OECDMemberEconomiesClass) ).

fof(s__Poland_type,axiom,
    s__Nation(s__Poland) ).

fof(s__Poland_OECD,axiom,
    is_instance(s__Poland,s__OECDMemberEconomiesClass) ).

fof(s__Sweden_type,axiom,
    s__Nation(s__Sweden) ).

fof(s__Sweden_OECD,axiom,
    is_instance(s__Sweden,s__OECDMemberEconomiesClass) ).

fof(s__SouthKorea_type,axiom,
    s__Nation(s__SouthKorea) ).

fof(s__SouthKorea_OECD,axiom,
    is_instance(s__SouthKorea,s__OECDMemberEconomiesClass) ).

fof(s__Slovakia_type,axiom,
    s__Nation(s__Slovakia) ).

fof(s__Slovakia_OECD,axiom,
    is_instance(s__Slovakia,s__OECDMemberEconomiesClass) ).

fof(s__Spain_type,axiom,
    s__Nation(s__Spain) ).

fof(s__Spain_OECD,axiom,
    is_instance(s__Spain,s__OECDMemberEconomiesClass) ).

fof(s__Switzerland_type,axiom,
    s__Nation(s__Switzerland) ).

fof(s__Switzerland_OECD,axiom,
    is_instance(s__Switzerland,s__OECDMemberEconomiesClass) ).

fof(s__UnitedKingdom_type,axiom,
    s__Nation(s__UnitedKingdom) ).

fof(s__UnitedKingdom_OECD,axiom,
    is_instance(s__UnitedKingdom,s__OECDMemberEconomiesClass) ).

fof(s__UnitedStates_type,axiom,
    s__Nation(s__UnitedStates) ).

fof(s__UnitedStates_OECD,axiom,
    is_instance(s__UnitedStates,s__OECDMemberEconomiesClass) ).

fof(s__Portugal_type,axiom,
    s__Nation(s__Portugal) ).

fof(s__Portugal_OECD,axiom,
    is_instance(s__Portugal,s__OECDMemberEconomiesClass) ).

fof(s__Norway_type,axiom,
    s__Nation(s__Norway) ).

fof(s__Norway_OECD,axiom,
    is_instance(s__Norway,s__OECDMemberEconomiesClass) ).

fof(s__Netherlands_type,axiom,
    s__Nation(s__Netherlands) ).

fof(s__Netherlands_OECD,axiom,
    is_instance(s__Netherlands,s__OECDMemberEconomiesClass) ).

fof(s__Iceland_type,axiom,
    s__Nation(s__Iceland) ).

fof(s__Iceland_OECD,axiom,
    is_instance(s__Iceland,s__OECDMemberEconomiesClass) ).

fof(s__Belgium_type,axiom,
    s__Nation(s__Belgium) ).

fof(s__Belgium_OECD,axiom,
    is_instance(s__Belgium,s__OECDMemberEconomiesClass) ).

fof(s__France_type,axiom,
    s__Nation(s__France) ).

fof(s__France_OECD,axiom,
    is_instance(s__France,s__OECDMemberEconomiesClass) ).

fof(s__Australia_type,axiom,
    s__Nation(s__Australia) ).

fof(s__Australia_OECD,axiom,
    is_instance(s__Australia,s__OECDMemberEconomiesClass) ).

fof(s__Austria_type,axiom,
    s__Nation(s__Austria) ).

fof(s__Austria_OECD,axiom,
    is_instance(s__Austria,s__OECDMemberEconomiesClass) ).

fof(s__Athens_type,axiom,
    s__City(s__Athens) ).

fof(s__Athens_s__Greece,axiom,
    capital_city(s__Athens,s__Greece) ).

fof(s__Berlin_type,axiom,
    s__City(s__Berlin) ).

fof(s__Berlin_s__Germany,axiom,
    capital_city(s__Berlin,s__Germany) ).

fof(s__Bratislava_type,axiom,
    s__City(s__Bratislava) ).

fof(s__Bratislava_s__Slovakia,axiom,
    capital_city(s__Bratislava,s__Slovakia) ).

fof(s__Brussels_type,axiom,
    s__City(s__Brussels) ).

fof(s__Brussels_s__Belgium,axiom,
    capital_city(s__Brussels,s__Belgium) ).

fof(s__Budapest_type,axiom,
    s__City(s__Budapest) ).

fof(s__Budapest_s__Hungary,axiom,
    capital_city(s__Budapest,s__Hungary) ).

fof(s__Canberra_type,axiom,
    s__City(s__Canberra) ).

fof(s__Canberra_s__Australia,axiom,
    capital_city(s__Canberra,s__Australia) ).

fof(s__Copenhagen_type,axiom,
    s__City(s__Copenhagen) ).

fof(s__Copenhagen_s__Denmark,axiom,
    capital_city(s__Copenhagen,s__Denmark) ).

fof(s__Helsinki_type,axiom,
    s__City(s__Helsinki) ).

fof(s__Helsinki_s__Finland,axiom,
    capital_city(s__Helsinki,s__Finland) ).

fof(s__Lisbon_type,axiom,
    s__City(s__Lisbon) ).

fof(s__Lisbon_s__Portugal,axiom,
    capital_city(s__Lisbon,s__Portugal) ).

fof(s__Luxembourg_City_type,axiom,
    s__City(s__Luxembourg_City) ).

fof(s__Luxembourg_City_s__Luxembourg,axiom,
    capital_city(s__Luxembourg_City,s__Luxembourg) ).

fof(s__Paris_type,axiom,
    s__City(s__Paris) ).

fof(s__Paris_s__France,axiom,
    capital_city(s__Paris,s__France) ).

fof(s__Prague_type,axiom,
    s__City(s__Prague) ).

fof(s__Prague_s__CzechRepublic,axiom,
    capital_city(s__Prague,s__CzechRepublic) ).

fof(s__Seoul_type,axiom,
    s__City(s__Seoul) ).

fof(s__Seoul_s__SouthKorea,axiom,
    capital_city(s__Seoul,s__SouthKorea) ).

fof(s__Vienna_type,axiom,
    s__City(s__Vienna) ).

fof(s__Vienna_s__Austria,axiom,
    capital_city(s__Vienna,s__Austria) ).

fof(s__Warsaw_type,axiom,
    s__City(s__Warsaw) ).

fof(s__Warsaw_s__Poland,axiom,
    capital_city(s__Warsaw,s__Poland) ).

fof(athens_lat_type,axiom,
    real('37.97615') ).

fof(athens_long_type,axiom,
    real('23.736415') ).

fof(athens_type,axiom,
    s__SymbolicString(athens) ).

fof(gr_type,axiom,
    s__SymbolicString(gr) ).

fof(latlong_s__Athens,axiom,
    latlong(s__Athens,'37.97615','23.736415',athens,gr) ).

fof(berlin_lat_type,axiom,
    real('52.516074') ).

fof(berlin_long_type,axiom,
    real('13.376987') ).

fof(berlin_type,axiom,
    s__SymbolicString(berlin) ).

fof(de_type,axiom,
    s__SymbolicString(de) ).

fof(latlong_s__Berlin,axiom,
    latlong(s__Berlin,'52.516074','13.376987',berlin,de) ).

fof(bratislava_lat_type,axiom,
    real('48.149245') ).

fof(bratislava_long_type,axiom,
    real('17.107005') ).

fof(bratislava_type,axiom,
    s__SymbolicString(bratislava) ).

fof(sk_type,axiom,
    s__SymbolicString(sk) ).

fof(latlong_s__Bratislava,axiom,
    latlong(s__Bratislava,'48.149245','17.107005',bratislava,sk) ).

fof(brussels_lat_type,axiom,
    real('50.848385') ).

fof(brussels_long_type,axiom,
    real('4.349685') ).

fof(brussels_type,axiom,
    s__SymbolicString(brussels) ).

fof(be_type,axiom,
    s__SymbolicString(be) ).

fof(latlong_s__Brussels,axiom,
    latlong(s__Brussels,'50.848385','4.349685',brussels,be) ).

fof(budapest_lat_type,axiom,
    real('47.506225') ).

fof(budapest_long_type,axiom,
    real('19.06482') ).

fof(budapest_type,axiom,
    s__SymbolicString(budapest) ).

fof(hu_type,axiom,
    s__SymbolicString(hu) ).

fof(latlong_s__Budapest,axiom,
    latlong(s__Budapest,'47.506225','19.06482',budapest,hu) ).

fof(canberra_lat_type,axiom,
    real('-35.306541') ).

fof(canberra_long_type,axiom,
    real('149.126556') ).

fof(canberra_type,axiom,
    s__SymbolicString(canberra) ).

fof(au_type,axiom,
    s__SymbolicString(au) ).

fof(latlong_s__Canberra,axiom,
    latlong(s__Canberra,'-35.306541','149.126556',canberra,au) ).

fof(copenhagen_lat_type,axiom,
    real('55.67631') ).

fof(copenhagen_long_type,axiom,
    real('12.569355') ).

fof(copenhagen_type,axiom,
    s__SymbolicString(copenhagen) ).

fof(dk_type,axiom,
    s__SymbolicString(dk) ).

fof(latlong_s__Copenhagen,axiom,
    latlong(s__Copenhagen,'55.67631','12.569355',copenhagen,dk) ).

fof(helsinki_lat_type,axiom,
    real('60.17116') ).

fof(helsinki_long_type,axiom,
    real('24.93258') ).

fof(helsinki_type,axiom,
    s__SymbolicString(helsinki) ).

fof(fi_type,axiom,
    s__SymbolicString(fi) ).

fof(latlong_s__Helsinki,axiom,
    latlong(s__Helsinki,'60.17116','24.93258',helsinki,fi) ).

fof(lisbon_lat_type,axiom,
    real('38.725679') ).

fof(lisbon_long_type,axiom,
    real('-9.150371') ).

fof(lisbon_type,axiom,
    s__SymbolicString(lisbon) ).

fof(pt_type,axiom,
    s__SymbolicString(pt) ).

fof(latlong_s__Lisbon,axiom,
    latlong(s__Lisbon,'38.725679','-9.150371',lisbon,pt) ).

fof(luxembourg_city_lat_type,axiom,
    real('49.609531') ).

fof(luxembourg_city_long_type,axiom,
    real('6.12997') ).

fof(luxembourg_city_type,axiom,
    s__SymbolicString(luxembourg_city) ).

fof(lu_type,axiom,
    s__SymbolicString(lu) ).

fof(latlong_s__Luxembourg_City,axiom,
    latlong(s__Luxembourg_City,'49.609531','6.12997',luxembourg_city,lu) ).

fof(moscow_lat_type,axiom,
    real('55.75695') ).

fof(moscow_long_type,axiom,
    real('37.614975') ).

fof(moscow_type,axiom,
    s__SymbolicString(moscow) ).

fof(ru_type,axiom,
    s__SymbolicString(ru) ).

fof(latlong_s__Moscow,axiom,
    latlong(s__Moscow,'55.75695','37.614975',moscow,ru) ).

fof(paris_lat_type,axiom,
    real('48.856925') ).

fof(paris_long_type,axiom,
    real('2.34121') ).

fof(paris_type,axiom,
    s__SymbolicString(paris) ).

fof(fr_type,axiom,
    s__SymbolicString(fr) ).

fof(latlong_s__Paris,axiom,
    latlong(s__Paris,'48.856925','2.34121',paris,fr) ).

fof(prague_lat_type,axiom,
    real('50.079083') ).

fof(prague_long_type,axiom,
    real('14.43323') ).

fof(prague_type,axiom,
    s__SymbolicString(prague) ).

fof(cz_type,axiom,
    s__SymbolicString(cz) ).

fof(latlong_s__Prague,axiom,
    latlong(s__Prague,'50.079083','14.43323',prague,cz) ).

fof(seoul_lat_type,axiom,
    real('37.557121') ).

fof(seoul_long_type,axiom,
    real('126.977379') ).

fof(seoul_type,axiom,
    s__SymbolicString(seoul) ).

fof(kr_type,axiom,
    s__SymbolicString(kr) ).

fof(latlong_s__Seoul,axiom,
    latlong(s__Seoul,'37.557121','126.977379',seoul,kr) ).

fof(vienna_lat_type,axiom,
    real('48.202548') ).

fof(vienna_long_type,axiom,
    real('16.368805') ).

fof(vienna_type,axiom,
    s__SymbolicString(vienna) ).

fof(at_type,axiom,
    s__SymbolicString(at) ).

fof(latlong_s__Vienna,axiom,
    latlong(s__Vienna,'48.202548','16.368805',vienna,at) ).

fof(warsaw_lat_type,axiom,
    real('52.23537') ).

fof(warsaw_long_type,axiom,
    real('21.009485') ).

fof(warsaw_type,axiom,
    s__SymbolicString(warsaw) ).

fof(pl_type,axiom,
    s__SymbolicString(pl) ).

fof(latlong_s__Warsaw,axiom,
    latlong(s__Warsaw,'52.23537','21.009485',warsaw,pl) ).

fof(s__Athens_not_s__Moscow,axiom,
    look_different(s__Athens,s__Moscow) ).

fof(s__Berlin_not_s__Moscow,axiom,
    look_different(s__Berlin,s__Moscow) ).

fof(s__Bratislava_not_s__Moscow,axiom,
    look_different(s__Bratislava,s__Moscow) ).

fof(s__Brussels_not_s__Moscow,axiom,
    look_different(s__Brussels,s__Moscow) ).

fof(s__Budapest_not_s__Moscow,axiom,
    look_different(s__Budapest,s__Moscow) ).

fof(s__Canberra_not_s__Moscow,axiom,
    look_different(s__Canberra,s__Moscow) ).

fof(s__Copenhagen_not_s__Moscow,axiom,
    look_different(s__Copenhagen,s__Moscow) ).

fof(s__Helsinki_not_s__Moscow,axiom,
    look_different(s__Helsinki,s__Moscow) ).

fof(s__Lisbon_not_s__Moscow,axiom,
    look_different(s__Lisbon,s__Moscow) ).

fof(s__Luxembourg_City_not_s__Moscow,axiom,
    look_different(s__Luxembourg_City,s__Moscow) ).

fof(s__Paris_not_s__Moscow,axiom,
    look_different(s__Paris,s__Moscow) ).

fof(s__Prague_not_s__Moscow,axiom,
    look_different(s__Prague,s__Moscow) ).

fof(s__Seoul_not_s__Moscow,axiom,
    look_different(s__Seoul,s__Moscow) ).

fof(s__Vienna_not_s__Moscow,axiom,
    look_different(s__Vienna,s__Moscow) ).

fof(s__Warsaw_not_s__Moscow,axiom,
    look_different(s__Warsaw,s__Moscow) ).

fof('-35_type',axiom,
    int('-35') ).

fof('-35.306541_-35',axiom,
    to_int('-35.306541') = '-35' ).

fof('37_type',axiom,
    int('37') ).

fof('37.557121_37',axiom,
    to_int('37.557121') = '37' ).

fof('37.97615_37',axiom,
    to_int('37.97615') = '37' ).

fof('38_type',axiom,
    int('38') ).

fof('38.725679_38',axiom,
    to_int('38.725679') = '38' ).

fof('47_type',axiom,
    int('47') ).

fof('47.506225_47',axiom,
    to_int('47.506225') = '47' ).

fof('48_type',axiom,
    int('48') ).

fof('48.149245_48',axiom,
    to_int('48.149245') = '48' ).

fof('48.202548_48',axiom,
    to_int('48.202548') = '48' ).

fof('48.856925_48',axiom,
    to_int('48.856925') = '48' ).

fof('49_type',axiom,
    int('49') ).

fof('49.609531_49',axiom,
    to_int('49.609531') = '49' ).

fof('50_type',axiom,
    int('50') ).

fof('50.079083_50',axiom,
    to_int('50.079083') = '50' ).

fof('50.848385_50',axiom,
    to_int('50.848385') = '50' ).

fof('52_type',axiom,
    int('52') ).

fof('52.23537_52',axiom,
    to_int('52.23537') = '52' ).

fof('52.516074_52',axiom,
    to_int('52.516074') = '52' ).

fof('55_type',axiom,
    int('55') ).

fof('55.67631_55',axiom,
    to_int('55.67631') = '55' ).

fof('55.75695_55',axiom,
    to_int('55.75695') = '55' ).

fof('60_type',axiom,
    int('60') ).

fof('60.17116_60',axiom,
    to_int('60.17116') = '60' ).

fof(int_not_real,axiom,
    ! [A] :
      ( int(A)
     => ~ real(A) ) ).

fof(int_not_s__SymbolicString,axiom,
    ! [A] :
      ( int(A)
     => ~ s__SymbolicString(A) ) ).

fof(int_not_s__CaseRole,axiom,
    ! [A] :
      ( int(A)
     => ~ s__CaseRole(A) ) ).

fof(int_not_s__PositionalAttribute,axiom,
    ! [A] :
      ( int(A)
     => ~ s__PositionalAttribute(A) ) ).

fof(int_not_s__Object,axiom,
    ! [A] :
      ( int(A)
     => ~ s__Object(A) ) ).

fof(int_not_s__Entity,axiom,
    ! [A] :
      ( int(A)
     => ~ s__Entity(A) ) ).

fof(int_not_s__SetOrClass,axiom,
    ! [A] :
      ( int(A)
     => ~ s__SetOrClass(A) ) ).

fof(real_not_s__SymbolicString,axiom,
    ! [A] :
      ( real(A)
     => ~ s__SymbolicString(A) ) ).

fof(real_not_s__CaseRole,axiom,
    ! [A] :
      ( real(A)
     => ~ s__CaseRole(A) ) ).

fof(real_not_s__PositionalAttribute,axiom,
    ! [A] :
      ( real(A)
     => ~ s__PositionalAttribute(A) ) ).

fof(real_not_s__Object,axiom,
    ! [A] :
      ( real(A)
     => ~ s__Object(A) ) ).

fof(real_not_s__Entity,axiom,
    ! [A] :
      ( real(A)
     => ~ s__Entity(A) ) ).

fof(real_not_s__SetOrClass,axiom,
    ! [A] :
      ( real(A)
     => ~ s__SetOrClass(A) ) ).

fof(s__SymbolicString_not_s__CaseRole,axiom,
    ! [A] :
      ( s__SymbolicString(A)
     => ~ s__CaseRole(A) ) ).

fof(s__SymbolicString_not_s__PositionalAttribute,axiom,
    ! [A] :
      ( s__SymbolicString(A)
     => ~ s__PositionalAttribute(A) ) ).

fof(s__SymbolicString_not_s__Object,axiom,
    ! [A] :
      ( s__SymbolicString(A)
     => ~ s__Object(A) ) ).

fof(s__SymbolicString_not_s__Entity,axiom,
    ! [A] :
      ( s__SymbolicString(A)
     => ~ s__Entity(A) ) ).

fof(s__SymbolicString_not_s__SetOrClass,axiom,
    ! [A] :
      ( s__SymbolicString(A)
     => ~ s__SetOrClass(A) ) ).

fof(s__CaseRole_not_s__PositionalAttribute,axiom,
    ! [A] :
      ( s__CaseRole(A)
     => ~ s__PositionalAttribute(A) ) ).

fof(s__CaseRole_not_s__Object,axiom,
    ! [A] :
      ( s__CaseRole(A)
     => ~ s__Object(A) ) ).

fof(s__CaseRole_not_s__Entity,axiom,
    ! [A] :
      ( s__CaseRole(A)
     => ~ s__Entity(A) ) ).

fof(s__CaseRole_not_s__SetOrClass,axiom,
    ! [A] :
      ( s__CaseRole(A)
     => ~ s__SetOrClass(A) ) ).

fof(s__PositionalAttribute_not_s__Object,axiom,
    ! [A] :
      ( s__PositionalAttribute(A)
     => ~ s__Object(A) ) ).

fof(s__PositionalAttribute_not_s__Entity,axiom,
    ! [A] :
      ( s__PositionalAttribute(A)
     => ~ s__Entity(A) ) ).

fof(s__PositionalAttribute_not_s__SetOrClass,axiom,
    ! [A] :
      ( s__PositionalAttribute(A)
     => ~ s__SetOrClass(A) ) ).

fof(s__Object_not_s__Entity,axiom,
    ! [A] :
      ( s__Object(A)
     => ~ s__Entity(A) ) ).

fof(s__Object_not_s__SetOrClass,axiom,
    ! [A] :
      ( s__Object(A)
     => ~ s__SetOrClass(A) ) ).

fof(s__Entity_not_s__SetOrClass,axiom,
    ! [A] :
      ( s__Entity(A)
     => ~ s__SetOrClass(A) ) ).

fof(s__GeopoliticalArea_not_s__WaterArea,axiom,
    ! [A] :
      ( s__GeopoliticalArea(A)
     => ~ s__WaterArea(A) ) ).

fof(s__Nation_not_s__City,axiom,
    ! [A] :
      ( s__Nation(A)
     => ~ s__City(A) ) ).

%------------------------------------------------------------------------------
