%------------------------------------------------------------------------------
% File     : CSR116+9 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1638_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10943 (   0 equ)
%            Maximal formula atoms :  231 (   1 avg)
%            Number of connectives :  754 (   0   ~;  18   |; 610   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  231 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16661 (16661 usr;16660 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1638,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1638,hypothesis,
    ( pred(c260,pr__344sident_1_1)
    & attch(c265,c260)
    & attr(c265,c266)
    & sub(c265,land_1_1)
    & sub(c266,name_1_1)
    & val(c266,s__374dafrika_0)
    & attr(c270,c271)
    & sub(c270,land_1_1)
    & sub(c271,name_1_1)
    & val(c271,simbabwe_0)
    & attr(c275,c276)
    & attr(c275,c277)
    & sub(c275,mensch_1_1)
    & sub(c276,eigenname_1_1)
    & val(c276,nelson_0)
    & sub(c277,familiename_1_1)
    & val(c277,mandela_0)
    & attr(c282,c283)
    & attr(c282,c284)
    & sub(c282,mensch_1_1)
    & sub(c283,eigenname_1_1)
    & val(c283,robert_0)
    & sub(c284,familiename_1_1)
    & val(c284,mugabe_0)
    & prop(c290,milit__344risch_1_1)
    & subs(c290,eingreifen_2_1)
    & attr(c312,c313)
    & sub(c312,kleinstaat_1_1)
    & sub(c313,name_1_1)
    & val(c313,lesotho_0)
    & tupl_p7(c351,c260,c270,c275,c282,c290,c312)
    & assoc(kleinstaat_1_1,klein_1_1)
    & sub(kleinstaat_1_1,land_1_1)
    & sort(c260,d)
    & card(c260,cons(x_constant,cons(int1,nil)))
    & etype(c260,int1)
    & fact(c260,real)
    & gener(c260,sp)
    & quant(c260,mult)
    & refer(c260,det)
    & varia(c260,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c265,d)
    & sort(c265,io)
    & card(c265,int1)
    & etype(c265,int0)
    & fact(c265,real)
    & gener(c265,sp)
    & quant(c265,one)
    & refer(c265,det)
    & varia(c265,con)
    & sort(c266,na)
    & card(c266,int1)
    & etype(c266,int0)
    & fact(c266,real)
    & gener(c266,sp)
    & quant(c266,one)
    & refer(c266,indet)
    & varia(c266,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c270,d)
    & sort(c270,io)
    & card(c270,int1)
    & etype(c270,int0)
    & fact(c270,real)
    & gener(c270,sp)
    & quant(c270,one)
    & refer(c270,det)
    & varia(c270,con)
    & sort(c271,na)
    & card(c271,int1)
    & etype(c271,int0)
    & fact(c271,real)
    & gener(c271,sp)
    & quant(c271,one)
    & refer(c271,indet)
    & varia(c271,varia_c)
    & sort(simbabwe_0,fe)
    & sort(c275,d)
    & card(c275,int1)
    & etype(c275,int0)
    & fact(c275,real)
    & gener(c275,sp)
    & quant(c275,one)
    & refer(c275,det)
    & varia(c275,con)
    & sort(c276,na)
    & card(c276,int1)
    & etype(c276,int0)
    & fact(c276,real)
    & gener(c276,sp)
    & quant(c276,one)
    & refer(c276,indet)
    & varia(c276,varia_c)
    & sort(c277,na)
    & card(c277,int1)
    & etype(c277,int0)
    & fact(c277,real)
    & gener(c277,sp)
    & quant(c277,one)
    & refer(c277,indet)
    & varia(c277,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c282,d)
    & card(c282,int1)
    & etype(c282,int0)
    & fact(c282,real)
    & gener(c282,sp)
    & quant(c282,one)
    & refer(c282,det)
    & varia(c282,con)
    & sort(c283,na)
    & card(c283,int1)
    & etype(c283,int0)
    & fact(c283,real)
    & gener(c283,sp)
    & quant(c283,one)
    & refer(c283,indet)
    & varia(c283,varia_c)
    & sort(c284,na)
    & card(c284,int1)
    & etype(c284,int0)
    & fact(c284,real)
    & gener(c284,sp)
    & quant(c284,one)
    & refer(c284,indet)
    & varia(c284,varia_c)
    & sort(robert_0,fe)
    & sort(mugabe_0,fe)
    & sort(c290,ad)
    & card(c290,int1)
    & etype(c290,int0)
    & fact(c290,real)
    & gener(c290,sp)
    & quant(c290,one)
    & refer(c290,indet)
    & varia(c290,varia_c)
    & sort(milit__344risch_1_1,nq)
    & sort(eingreifen_2_1,ad)
    & card(eingreifen_2_1,int1)
    & etype(eingreifen_2_1,int0)
    & fact(eingreifen_2_1,real)
    & gener(eingreifen_2_1,ge)
    & quant(eingreifen_2_1,one)
    & refer(eingreifen_2_1,refer_c)
    & varia(eingreifen_2_1,varia_c)
    & sort(c312,d)
    & sort(c312,io)
    & card(c312,int1)
    & etype(c312,int0)
    & fact(c312,real)
    & gener(c312,sp)
    & quant(c312,one)
    & refer(c312,det)
    & varia(c312,con)
    & sort(c313,na)
    & card(c313,int1)
    & etype(c313,int0)
    & fact(c313,real)
    & gener(c313,sp)
    & quant(c313,one)
    & refer(c313,indet)
    & varia(c313,varia_c)
    & sort(kleinstaat_1_1,d)
    & sort(kleinstaat_1_1,io)
    & card(kleinstaat_1_1,int1)
    & etype(kleinstaat_1_1,int0)
    & fact(kleinstaat_1_1,real)
    & gener(kleinstaat_1_1,ge)
    & quant(kleinstaat_1_1,one)
    & refer(kleinstaat_1_1,refer_c)
    & varia(kleinstaat_1_1,varia_c)
    & sort(lesotho_0,fe)
    & sort(c351,ent)
    & card(c351,card_c)
    & etype(c351,etype_c)
    & fact(c351,real)
    & gener(c351,gener_c)
    & quant(c351,quant_c)
    & refer(c351,refer_c)
    & varia(c351,varia_c)
    & sort(klein_1_1,mq) ) ).

%------------------------------------------------------------------------------
