%------------------------------------------------------------------------------
% File     : CSR116+8 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1624_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.43 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.65 v4.1.0, 0.72 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11089 (   0 equ)
%            Maximal formula atoms :  376 (   1 avg)
%            Number of connectives :  900 (   0   ~;  18   |; 756   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  376 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16674 (16674 usr;16673 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1624,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1624,hypothesis,
    ( pmod(c1,ehemalig_1_1,kolonie_1_1)
    & attr(c11,c12)
    & sub(c11,stadt__1_1)
    & sub(c12,name_1_1)
    & val(c12,windhoek_0)
    & attr(c18,c19)
    & attr(c18,c20)
    & sub(c19,tag_1_1)
    & val(c19,c16)
    & sub(c20,monat_1_1)
    & val(c20,c17)
    & tupl(c25,c11,c18)
    & assoc(c37,c76)
    & obj(c37,c53)
    & scar(c37,c39)
    & subs(c37,haben_1_1)
    & temp(c37,c43)
    & attr(c39,c40)
    & sub(c39,land_1_1)
    & sub(c40,name_1_1)
    & val(c40,namibia_0)
    & sub(c43,dienstag__1_1)
    & attr(c53,c54)
    & attr(c53,c55)
    & prop(c53,s__374dafrikanisch_1_1)
    & purp(c53,c63)
    & sub(c53,pr__344sident_1_1)
    & sub(c54,eigenname_1_1)
    & val(c54,nelson_0)
    & sub(c55,familiename_1_1)
    & val(c55,mandela_0)
    & agt(c63,c39)
    & obj(c63,c75)
    & subs(c63,c66)
    & pmod(c66,erst_1_1,staatgast_1_1)
    & prop(c75,bundesdeutsch_1_1)
    & sub(c75,c1)
    & sub(c76,suedwest_1_1)
    & obj(c87,c89)
    & semrel(c87,c37)
    & subs(c87,empfangen_1_1)
    & attr(c89,c90)
    & sub(c89,gebietsinstitution_1_1)
    & sub(c90,name_1_1)
    & val(c90,afrika_0)
    & assoc(staatgast_1_1,land_1_1)
    & subs(staatgast_1_1,besuch_1_1)
    & assoc(suedwest_1_1,sued_1_1)
    & sub(suedwest_1_1,west__1_1)
    & sort(c1,ent)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,fact_c)
    & gener(c1,gener_c)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(ehemalig_1_1,tq)
    & sort(kolonie_1_1,d)
    & card(kolonie_1_1,int1)
    & etype(kolonie_1_1,int0)
    & fact(kolonie_1_1,real)
    & gener(kolonie_1_1,ge)
    & quant(kolonie_1_1,one)
    & refer(kolonie_1_1,refer_c)
    & varia(kolonie_1_1,varia_c)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(windhoek_0,fe)
    & sort(c18,t)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,me)
    & sort(c19,oa)
    & sort(c19,ta)
    & card(c19,card_c)
    & etype(c19,etype_c)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,quant_c)
    & refer(c19,refer_c)
    & varia(c19,varia_c)
    & sort(c20,me)
    & sort(c20,oa)
    & sort(c20,ta)
    & card(c20,card_c)
    & etype(c20,etype_c)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,quant_c)
    & refer(c20,refer_c)
    & varia(c20,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int9)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c17,nu)
    & card(c17,int8)
    & sort(c25,ent)
    & card(c25,card_c)
    & etype(c25,etype_c)
    & fact(c25,real)
    & gener(c25,gener_c)
    & quant(c25,quant_c)
    & refer(c25,refer_c)
    & varia(c25,varia_c)
    & sort(c37,st)
    & fact(c37,real)
    & gener(c37,sp)
    & sort(c76,d)
    & sort(c76,io)
    & card(c76,int1)
    & etype(c76,int0)
    & fact(c76,real)
    & gener(c76,gener_c)
    & quant(c76,one)
    & refer(c76,refer_c)
    & varia(c76,varia_c)
    & sort(c53,d)
    & card(c53,int1)
    & etype(c53,int0)
    & fact(c53,real)
    & gener(c53,sp)
    & quant(c53,one)
    & refer(c53,det)
    & varia(c53,con)
    & sort(c39,d)
    & sort(c39,io)
    & card(c39,int1)
    & etype(c39,int0)
    & fact(c39,real)
    & gener(c39,sp)
    & quant(c39,one)
    & refer(c39,det)
    & varia(c39,con)
    & sort(haben_1_1,st)
    & fact(haben_1_1,real)
    & gener(haben_1_1,ge)
    & sort(c43,ta)
    & card(c43,int1)
    & etype(c43,int0)
    & fact(c43,real)
    & gener(c43,sp)
    & quant(c43,one)
    & refer(c43,det)
    & varia(c43,con)
    & sort(c40,na)
    & card(c40,int1)
    & etype(c40,int0)
    & fact(c40,real)
    & gener(c40,sp)
    & quant(c40,one)
    & refer(c40,indet)
    & varia(c40,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(namibia_0,fe)
    & sort(dienstag__1_1,ta)
    & card(dienstag__1_1,int1)
    & etype(dienstag__1_1,int0)
    & fact(dienstag__1_1,real)
    & gener(dienstag__1_1,ge)
    & quant(dienstag__1_1,one)
    & refer(dienstag__1_1,refer_c)
    & varia(dienstag__1_1,varia_c)
    & sort(c54,na)
    & card(c54,int1)
    & etype(c54,int0)
    & fact(c54,real)
    & gener(c54,sp)
    & quant(c54,one)
    & refer(c54,indet)
    & varia(c54,varia_c)
    & sort(c55,na)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,indet)
    & varia(c55,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(c63,ad)
    & sort(c63,as)
    & card(c63,int1)
    & etype(c63,int0)
    & fact(c63,real)
    & gener(c63,sp)
    & quant(c63,one)
    & refer(c63,det)
    & varia(c63,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c75,d)
    & card(c75,int1)
    & etype(c75,int0)
    & fact(c75,real)
    & gener(c75,sp)
    & quant(c75,one)
    & refer(c75,det)
    & varia(c75,con)
    & sort(c66,ad)
    & sort(c66,as)
    & card(c66,int1)
    & etype(c66,int0)
    & fact(c66,real)
    & gener(c66,ge)
    & quant(c66,one)
    & refer(c66,refer_c)
    & varia(c66,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(staatgast_1_1,ad)
    & sort(staatgast_1_1,as)
    & card(staatgast_1_1,int1)
    & etype(staatgast_1_1,int0)
    & fact(staatgast_1_1,real)
    & gener(staatgast_1_1,ge)
    & quant(staatgast_1_1,one)
    & refer(staatgast_1_1,refer_c)
    & varia(staatgast_1_1,varia_c)
    & sort(bundesdeutsch_1_1,tq)
    & sort(suedwest_1_1,d)
    & sort(suedwest_1_1,io)
    & card(suedwest_1_1,int1)
    & etype(suedwest_1_1,int0)
    & fact(suedwest_1_1,real)
    & gener(suedwest_1_1,ge)
    & quant(suedwest_1_1,one)
    & refer(suedwest_1_1,refer_c)
    & varia(suedwest_1_1,varia_c)
    & sort(c87,dn)
    & fact(c87,real)
    & gener(c87,sp)
    & sort(c89,d)
    & sort(c89,io)
    & card(c89,int1)
    & etype(c89,int0)
    & fact(c89,real)
    & gener(c89,sp)
    & quant(c89,one)
    & refer(c89,det)
    & varia(c89,con)
    & sort(empfangen_1_1,dn)
    & fact(empfangen_1_1,real)
    & gener(empfangen_1_1,ge)
    & sort(c90,na)
    & card(c90,int1)
    & etype(c90,int0)
    & fact(c90,real)
    & gener(c90,sp)
    & quant(c90,one)
    & refer(c90,indet)
    & varia(c90,varia_c)
    & sort(gebietsinstitution_1_1,d)
    & sort(gebietsinstitution_1_1,io)
    & card(gebietsinstitution_1_1,int1)
    & etype(gebietsinstitution_1_1,int0)
    & fact(gebietsinstitution_1_1,real)
    & gener(gebietsinstitution_1_1,ge)
    & quant(gebietsinstitution_1_1,one)
    & refer(gebietsinstitution_1_1,refer_c)
    & varia(gebietsinstitution_1_1,varia_c)
    & sort(afrika_0,fe)
    & sort(besuch_1_1,ad)
    & sort(besuch_1_1,as)
    & card(besuch_1_1,int1)
    & etype(besuch_1_1,int0)
    & fact(besuch_1_1,real)
    & gener(besuch_1_1,ge)
    & quant(besuch_1_1,one)
    & refer(besuch_1_1,refer_c)
    & varia(besuch_1_1,varia_c)
    & sort(sued_1_1,oa)
    & card(sued_1_1,int1)
    & etype(sued_1_1,int0)
    & fact(sued_1_1,real)
    & gener(sued_1_1,ge)
    & quant(sued_1_1,one)
    & refer(sued_1_1,refer_c)
    & varia(sued_1_1,varia_c)
    & sort(west__1_1,d)
    & sort(west__1_1,io)
    & card(west__1_1,int1)
    & etype(west__1_1,int0)
    & fact(west__1_1,real)
    & gener(west__1_1,ge)
    & quant(west__1_1,one)
    & refer(west__1_1,refer_c)
    & varia(west__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
