%------------------------------------------------------------------------------
% File     : CSR116+7 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1614_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.33 v7.4.0, 0.19 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.44 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10879 (   0 equ)
%            Maximal formula atoms :  165 (   1 avg)
%            Number of connectives :  690 (   0   ~;  18   |; 546   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  165 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16654 (16654 usr;16653 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1614,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & rslt(X7,X3)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & subr(X3,rprs_0)
      & subs(X7,w__344hlen_1_2)
      & val(X1,mandela_0)
      & val(X2,nelson_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1614,hypothesis,
    ( attr(c12,c13)
    & attr(c12,c14)
    & sub(c12,mensch_1_1)
    & sub(c13,eigenname_1_1)
    & val(c13,nelson_0)
    & sub(c14,familiename_1_1)
    & val(c14,mandela_0)
    & prop(c18,neugew__344hlt_1_1)
    & sub(c18,abgeordneten_haus_1_2)
    & prop(c25,schwarz_1_1)
    & sub(c25,c27)
    & pmod(c27,erst_1_1,pr__344sident_1_1)
    & attch(c33,c25)
    & sub(c33,land_1_1)
    & agt(c38,c18)
    & obj(c38,c12)
    & rslt(c38,c47)
    & subs(c38,w__344hlen_1_2)
    & temp(c38,c5)
    & arg1(c47,c12)
    & arg2(c47,c25)
    & subr(c47,rprs_0)
    & sub(c5,montag__1_1)
    & sort(c12,d)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,det)
    & varia(c12,con)
    & sort(c13,na)
    & card(c13,int1)
    & etype(c13,int0)
    & fact(c13,real)
    & gener(c13,sp)
    & quant(c13,one)
    & refer(c13,indet)
    & varia(c13,varia_c)
    & sort(c14,na)
    & card(c14,int1)
    & etype(c14,int0)
    & fact(c14,real)
    & gener(c14,sp)
    & quant(c14,one)
    & refer(c14,indet)
    & varia(c14,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c18,d)
    & sort(c18,io)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(neugew__344hlt_1_1,gq)
    & sort(abgeordneten_haus_1_2,d)
    & sort(abgeordneten_haus_1_2,io)
    & card(abgeordneten_haus_1_2,int1)
    & etype(abgeordneten_haus_1_2,int0)
    & fact(abgeordneten_haus_1_2,real)
    & gener(abgeordneten_haus_1_2,ge)
    & quant(abgeordneten_haus_1_2,one)
    & refer(abgeordneten_haus_1_2,refer_c)
    & varia(abgeordneten_haus_1_2,varia_c)
    & sort(c25,d)
    & card(c25,int1)
    & etype(c25,int0)
    & fact(c25,real)
    & gener(c25,sp)
    & quant(c25,one)
    & refer(c25,det)
    & varia(c25,con)
    & sort(schwarz_1_1,tq)
    & sort(c27,d)
    & card(c27,int1)
    & etype(c27,int0)
    & fact(c27,real)
    & gener(c27,ge)
    & quant(c27,one)
    & refer(c27,refer_c)
    & varia(c27,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c33,d)
    & sort(c33,io)
    & card(c33,int1)
    & etype(c33,int0)
    & fact(c33,real)
    & gener(c33,sp)
    & quant(c33,one)
    & refer(c33,det)
    & varia(c33,con)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(c38,da)
    & fact(c38,real)
    & gener(c38,sp)
    & sort(c47,st)
    & fact(c47,real)
    & gener(c47,sp)
    & sort(w__344hlen_1_2,da)
    & fact(w__344hlen_1_2,real)
    & gener(w__344hlen_1_2,ge)
    & sort(c5,ta)
    & card(c5,int1)
    & etype(c5,int0)
    & fact(c5,real)
    & gener(c5,sp)
    & quant(c5,one)
    & refer(c5,det)
    & varia(c5,con)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(montag__1_1,ta)
    & card(montag__1_1,int1)
    & etype(montag__1_1,int0)
    & fact(montag__1_1,real)
    & gener(montag__1_1,ge)
    & quant(montag__1_1,one)
    & refer(montag__1_1,refer_c)
    & varia(montag__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
