%------------------------------------------------------------------------------
% File     : CSR116+6 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1607_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.76 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11146 (   0 equ)
%            Maximal formula atoms :  433 (   1 avg)
%            Number of connectives :  957 (   0   ~;  18   |; 813   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  433 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16685 (16685 usr;16684 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1607,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1607,hypothesis,
    ( assoc(amtantritt_1_1,amt_1_2)
    & assoc(apartheid_1_1,rasse_1_1)
    & subs(apartheid_1_1,trennung_1_1)
    & preds(c103,c105)
    & prop(c103,allgemein_1_1)
    & pmod(c105,erst_1_1,wahl_1_1)
    & sub(c108,abschlu__337_1_1)
    & assoc(c109,c108)
    & sub(c109,april__1_1)
    & agt(c11,c17)
    & mode(c11,c6)
    & obj(c11,c21)
    & sourc(c11,c28)
    & subs(c11,ziehen_1_1)
    & subs(c115,amtantritt_1_1)
    & attch(c124,c163)
    & attr(c124,c125)
    & attr(c124,c126)
    & prop(c124,neo_1_1)
    & sub(c124,pr__344sident_1_1)
    & sub(c125,eigenname_1_1)
    & val(c125,nelson_0)
    & sub(c126,familiename_1_1)
    & val(c126,mandela_0)
    & poss(c14,c6)
    & attch(c146,c163)
    & attr(c146,c147)
    & prop(c146,afrikanisch__1_1)
    & sub(c146,nationalkongre__337_1_1)
    & sub(c146,schwarzen_organisation_1_1)
    & sub(c147,name_1_1)
    & val(c147,anc_0)
    & cstr(c150,c103)
    & obj(c150,c38)
    & subs(c150,besiegeln_1_1)
    & itms(c163,c109,c115)
    & attch(c163,c103)
    & in(c165,c38)
    & sub(c17,sicherheitrat_1_1)
    & sub(c21,konsequenz_1_1)
    & sub(c28,abschlu__337_1_1)
    & attch(c32,c28)
    & loc(c32,c165)
    & subs(c32,apartheid_1_1)
    & attr(c38,c39)
    & sub(c38,land_1_1)
    & sub(c39,name_1_1)
    & val(c39,s__374dafrika_0)
    & pred(c6,beschlu__337_1_1)
    & assoc(nationalkongre__337_1_1,national__1_1)
    & sub(nationalkongre__337_1_1,kongre__337_1_1)
    & assoc(schwarzen_organisation_1_1,schwarzen_0)
    & sub(schwarzen_organisation_1_1,organisation_1_1)
    & assoc(sicherheitrat_1_1,sicherheit_1_1)
    & sub(sicherheitrat_1_1,rat_2_1)
    & sort(amtantritt_1_1,ad)
    & card(amtantritt_1_1,int1)
    & etype(amtantritt_1_1,int0)
    & fact(amtantritt_1_1,real)
    & gener(amtantritt_1_1,ge)
    & quant(amtantritt_1_1,one)
    & refer(amtantritt_1_1,refer_c)
    & varia(amtantritt_1_1,varia_c)
    & sort(amt_1_2,ad)
    & sort(amt_1_2,io)
    & card(amt_1_2,int1)
    & etype(amt_1_2,int0)
    & fact(amt_1_2,real)
    & gener(amt_1_2,ge)
    & quant(amt_1_2,one)
    & refer(amt_1_2,refer_c)
    & varia(amt_1_2,varia_c)
    & sort(apartheid_1_1,ad)
    & card(apartheid_1_1,int1)
    & etype(apartheid_1_1,int0)
    & fact(apartheid_1_1,real)
    & gener(apartheid_1_1,ge)
    & quant(apartheid_1_1,one)
    & refer(apartheid_1_1,refer_c)
    & varia(apartheid_1_1,varia_c)
    & sort(rasse_1_1,io)
    & card(rasse_1_1,int1)
    & etype(rasse_1_1,int0)
    & fact(rasse_1_1,real)
    & gener(rasse_1_1,ge)
    & quant(rasse_1_1,one)
    & refer(rasse_1_1,refer_c)
    & varia(rasse_1_1,varia_c)
    & sort(trennung_1_1,ad)
    & card(trennung_1_1,int1)
    & etype(trennung_1_1,int0)
    & fact(trennung_1_1,real)
    & gener(trennung_1_1,ge)
    & quant(trennung_1_1,one)
    & refer(trennung_1_1,refer_c)
    & varia(trennung_1_1,varia_c)
    & sort(c103,ad)
    & card(c103,cons(x_constant,cons(int1,nil)))
    & etype(c103,int1)
    & fact(c103,real)
    & gener(c103,sp)
    & quant(c103,mult)
    & refer(c103,det)
    & varia(c103,con)
    & sort(c105,ad)
    & card(c105,int1)
    & etype(c105,int0)
    & fact(c105,real)
    & gener(c105,ge)
    & quant(c105,one)
    & refer(c105,refer_c)
    & varia(c105,varia_c)
    & sort(allgemein_1_1,nq)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c108,ad)
    & sort(c108,io)
    & card(c108,int1)
    & etype(c108,int0)
    & fact(c108,real)
    & gener(c108,gener_c)
    & quant(c108,one)
    & refer(c108,refer_c)
    & varia(c108,varia_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c)
    & sort(c109,ta)
    & card(c109,int1)
    & etype(c109,int0)
    & fact(c109,real)
    & gener(c109,gener_c)
    & quant(c109,one)
    & refer(c109,refer_c)
    & varia(c109,varia_c)
    & sort(april__1_1,ta)
    & card(april__1_1,int1)
    & etype(april__1_1,int0)
    & fact(april__1_1,real)
    & gener(april__1_1,ge)
    & quant(april__1_1,one)
    & refer(april__1_1,refer_c)
    & varia(april__1_1,varia_c)
    & sort(c11,da)
    & fact(c11,real)
    & gener(c11,sp)
    & sort(c17,io)
    & card(c17,int1)
    & etype(c17,int1)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c6,ad)
    & sort(c6,d)
    & sort(c6,io)
    & card(c6,cons(x_constant,cons(int1,nil)))
    & etype(c6,int1)
    & fact(c6,real)
    & gener(c6,sp)
    & quant(c6,mult)
    & refer(c6,det)
    & varia(c6,varia_c)
    & sort(c21,ad)
    & sort(c21,io)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,det)
    & varia(c21,con)
    & sort(c28,ad)
    & sort(c28,io)
    & card(c28,int1)
    & etype(c28,int0)
    & fact(c28,real)
    & gener(c28,sp)
    & quant(c28,one)
    & refer(c28,det)
    & varia(c28,con)
    & sort(ziehen_1_1,da)
    & fact(ziehen_1_1,real)
    & gener(ziehen_1_1,ge)
    & sort(c115,ad)
    & card(c115,int1)
    & etype(c115,int0)
    & fact(c115,real)
    & gener(c115,sp)
    & quant(c115,one)
    & refer(c115,det)
    & varia(c115,con)
    & sort(c124,d)
    & card(c124,int1)
    & etype(c124,int0)
    & fact(c124,real)
    & gener(c124,sp)
    & quant(c124,one)
    & refer(c124,det)
    & varia(c124,con)
    & sort(c163,ab)
    & card(c163,int2)
    & etype(c163,int1)
    & fact(c163,real)
    & gener(c163,gener_c)
    & quant(c163,nfquant)
    & refer(c163,refer_c)
    & varia(c163,varia_c)
    & sort(c125,na)
    & card(c125,int1)
    & etype(c125,int0)
    & fact(c125,real)
    & gener(c125,sp)
    & quant(c125,one)
    & refer(c125,indet)
    & varia(c125,varia_c)
    & sort(c126,na)
    & card(c126,int1)
    & etype(c126,int0)
    & fact(c126,real)
    & gener(c126,sp)
    & quant(c126,one)
    & refer(c126,indet)
    & varia(c126,varia_c)
    & sort(neo_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c14,o)
    & card(c14,int1)
    & etype(c14,int0)
    & fact(c14,real)
    & gener(c14,sp)
    & quant(c14,one)
    & refer(c14,det)
    & varia(c14,varia_c)
    & sort(c146,d)
    & sort(c146,io)
    & card(c146,int1)
    & etype(c146,int1)
    & fact(c146,real)
    & gener(c146,sp)
    & quant(c146,one)
    & refer(c146,det)
    & varia(c146,con)
    & sort(c147,na)
    & card(c147,int1)
    & etype(c147,int0)
    & fact(c147,real)
    & gener(c147,sp)
    & quant(c147,one)
    & refer(c147,indet)
    & varia(c147,varia_c)
    & sort(afrikanisch__1_1,nq)
    & sort(nationalkongre__337_1_1,d)
    & sort(nationalkongre__337_1_1,io)
    & card(nationalkongre__337_1_1,int1)
    & etype(nationalkongre__337_1_1,int0)
    & fact(nationalkongre__337_1_1,real)
    & gener(nationalkongre__337_1_1,ge)
    & quant(nationalkongre__337_1_1,one)
    & refer(nationalkongre__337_1_1,refer_c)
    & varia(nationalkongre__337_1_1,varia_c)
    & sort(schwarzen_organisation_1_1,d)
    & sort(schwarzen_organisation_1_1,io)
    & card(schwarzen_organisation_1_1,card_c)
    & etype(schwarzen_organisation_1_1,int1)
    & fact(schwarzen_organisation_1_1,real)
    & gener(schwarzen_organisation_1_1,ge)
    & quant(schwarzen_organisation_1_1,quant_c)
    & refer(schwarzen_organisation_1_1,refer_c)
    & varia(schwarzen_organisation_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(anc_0,fe)
    & sort(c150,da)
    & fact(c150,real)
    & gener(c150,sp)
    & sort(c38,d)
    & sort(c38,io)
    & card(c38,int1)
    & etype(c38,int0)
    & fact(c38,real)
    & gener(c38,sp)
    & quant(c38,one)
    & refer(c38,det)
    & varia(c38,con)
    & sort(besiegeln_1_1,da)
    & fact(besiegeln_1_1,real)
    & gener(besiegeln_1_1,ge)
    & sort(c165,l)
    & card(c165,int1)
    & etype(c165,int0)
    & fact(c165,real)
    & gener(c165,sp)
    & quant(c165,one)
    & refer(c165,det)
    & varia(c165,con)
    & sort(sicherheitrat_1_1,io)
    & card(sicherheitrat_1_1,card_c)
    & etype(sicherheitrat_1_1,int1)
    & fact(sicherheitrat_1_1,real)
    & gener(sicherheitrat_1_1,ge)
    & quant(sicherheitrat_1_1,quant_c)
    & refer(sicherheitrat_1_1,refer_c)
    & varia(sicherheitrat_1_1,varia_c)
    & sort(konsequenz_1_1,ad)
    & sort(konsequenz_1_1,io)
    & card(konsequenz_1_1,int1)
    & etype(konsequenz_1_1,int0)
    & fact(konsequenz_1_1,real)
    & gener(konsequenz_1_1,ge)
    & quant(konsequenz_1_1,one)
    & refer(konsequenz_1_1,refer_c)
    & varia(konsequenz_1_1,varia_c)
    & sort(c32,ad)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,one)
    & refer(c32,det)
    & varia(c32,con)
    & sort(c39,na)
    & card(c39,int1)
    & etype(c39,int0)
    & fact(c39,real)
    & gener(c39,sp)
    & quant(c39,one)
    & refer(c39,indet)
    & varia(c39,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(beschlu__337_1_1,ad)
    & sort(beschlu__337_1_1,d)
    & sort(beschlu__337_1_1,io)
    & card(beschlu__337_1_1,int1)
    & etype(beschlu__337_1_1,int0)
    & fact(beschlu__337_1_1,real)
    & gener(beschlu__337_1_1,ge)
    & quant(beschlu__337_1_1,one)
    & refer(beschlu__337_1_1,refer_c)
    & varia(beschlu__337_1_1,varia_c)
    & sort(national__1_1,nq)
    & sort(kongre__337_1_1,d)
    & sort(kongre__337_1_1,io)
    & card(kongre__337_1_1,int1)
    & etype(kongre__337_1_1,int0)
    & fact(kongre__337_1_1,real)
    & gener(kongre__337_1_1,ge)
    & quant(kongre__337_1_1,one)
    & refer(kongre__337_1_1,refer_c)
    & varia(kongre__337_1_1,varia_c)
    & sort(schwarzen_0,fe)
    & sort(organisation_1_1,d)
    & sort(organisation_1_1,io)
    & card(organisation_1_1,card_c)
    & etype(organisation_1_1,int1)
    & fact(organisation_1_1,real)
    & gener(organisation_1_1,ge)
    & quant(organisation_1_1,quant_c)
    & refer(organisation_1_1,refer_c)
    & varia(organisation_1_1,varia_c)
    & sort(sicherheit_1_1,as)
    & sort(sicherheit_1_1,io)
    & card(sicherheit_1_1,int1)
    & etype(sicherheit_1_1,int0)
    & fact(sicherheit_1_1,real)
    & gener(sicherheit_1_1,ge)
    & quant(sicherheit_1_1,one)
    & refer(sicherheit_1_1,refer_c)
    & varia(sicherheit_1_1,varia_c)
    & sort(rat_2_1,d)
    & sort(rat_2_1,io)
    & card(rat_2_1,card_c)
    & etype(rat_2_1,int1)
    & fact(rat_2_1,real)
    & gener(rat_2_1,ge)
    & quant(rat_2_1,quant_c)
    & refer(rat_2_1,refer_c)
    & varia(rat_2_1,varia_c) ) ).

%------------------------------------------------------------------------------
