%------------------------------------------------------------------------------
% File     : CSR116+5 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1606_a671_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.48 v7.4.0, 0.25 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.60 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.65 v5.2.0, 0.43 v5.0.0, 0.50 v4.1.0, 0.61 v4.0.1, 0.53 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10875 (   0 equ)
%            Maximal formula atoms :  162 (   1 avg)
%            Number of connectives :  686 (   0   ~;  18   |; 542   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  162 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1606_a671,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & rslt(X7,X3)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1606_a671,hypothesis,
    ( agt(c15,c3)
    & obj(c15,c345)
    & rslt(c15,c394)
    & subs(c15,erkl__344ren_1_4)
    & attr(c345,c346)
    & attr(c345,c348)
    & sub(c345,mensch_1_1)
    & sub(c346,eigenname_1_1)
    & val(c346,c347)
    & tupl(c347,nelson_0,rolihlahla_0)
    & sub(c348,familiename_1_1)
    & val(c348,mandela_0)
    & prop(c381,c382)
    & sub(c381,pr__344sident_1_1)
    & modp(c382,amtlich_1_1,c1)
    & attch(c391,c381)
    & attr(c391,c392)
    & sub(c391,republik__1_1)
    & sub(c392,name_1_1)
    & val(c392,s__374dafrika_0)
    & arg1(c394,c345)
    & arg2(c394,c381)
    & subr(c394,rprs_0)
    & sub(republik__1_1,land_1_1)
    & chsp2(w__344hlen_1_2,c1)
    & sort(c15,da)
    & fact(c15,real)
    & gener(c15,sp)
    & sort(c3,d)
    & card(c3,int1)
    & etype(c3,int0)
    & fact(c3,real)
    & gener(c3,sp)
    & quant(c3,one)
    & refer(c3,det)
    & varia(c3,varia_c)
    & sort(c345,d)
    & card(c345,int1)
    & etype(c345,int0)
    & fact(c345,real)
    & gener(c345,sp)
    & quant(c345,one)
    & refer(c345,det)
    & varia(c345,con)
    & sort(c394,st)
    & fact(c394,real)
    & gener(c394,sp)
    & sort(erkl__344ren_1_4,da)
    & fact(erkl__344ren_1_4,real)
    & gener(erkl__344ren_1_4,ge)
    & sort(c346,na)
    & card(c346,int1)
    & etype(c346,int0)
    & fact(c346,real)
    & gener(c346,sp)
    & quant(c346,one)
    & refer(c346,indet)
    & varia(c346,varia_c)
    & sort(c348,na)
    & card(c348,int1)
    & etype(c348,int0)
    & fact(c348,real)
    & gener(c348,sp)
    & quant(c348,one)
    & refer(c348,indet)
    & varia(c348,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(c347,fe)
    & sort(nelson_0,fe)
    & sort(rolihlahla_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c381,d)
    & card(c381,int1)
    & etype(c381,int0)
    & fact(c381,real)
    & gener(c381,sp)
    & quant(c381,one)
    & refer(c381,det)
    & varia(c381,con)
    & sort(c382,tq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(amtlich_1_1,tq)
    & sort(c1,tq)
    & sort(c391,d)
    & sort(c391,io)
    & card(c391,int1)
    & etype(c391,int0)
    & fact(c391,real)
    & gener(c391,sp)
    & quant(c391,one)
    & refer(c391,det)
    & varia(c391,con)
    & sort(c392,na)
    & card(c392,int1)
    & etype(c392,int0)
    & fact(c392,real)
    & gener(c392,sp)
    & quant(c392,one)
    & refer(c392,indet)
    & varia(c392,varia_c)
    & sort(republik__1_1,d)
    & sort(republik__1_1,io)
    & card(republik__1_1,int1)
    & etype(republik__1_1,int0)
    & fact(republik__1_1,real)
    & gener(republik__1_1,ge)
    & quant(republik__1_1,one)
    & refer(republik__1_1,refer_c)
    & varia(republik__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(land_1_1,ent)
    & card(land_1_1,card_c)
    & etype(land_1_1,etype_c)
    & fact(land_1_1,real)
    & gener(land_1_1,gener_c)
    & quant(land_1_1,quant_c)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(w__344hlen_1_2,da)
    & fact(w__344hlen_1_2,real)
    & gener(w__344hlen_1_2,ge) ) ).

%------------------------------------------------------------------------------
