%------------------------------------------------------------------------------
% File     : CSR116+47 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_qapn_176_a671_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11061 (   0 equ)
%            Maximal formula atoms :  348 (   1 avg)
%            Number of connectives :  872 (   0   ~;  18   |; 728   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  348 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16674 (16674 usr;16673 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_qapn_176_a671,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_qapn_176_a671,hypothesis,
    ( attr(c14,c15)
    & prop(c14,afrikanisch__1_1)
    & sub(c14,nationalkongre__337_1_1)
    & sub(c15,name_1_1)
    & val(c15,anc_0)
    & attch(c22,c14)
    & attr(c22,c23)
    & attr(c22,c24)
    & sub(c22,mensch_1_1)
    & sub(c23,eigenname_1_1)
    & val(c23,nelson_0)
    & sub(c24,familiename_1_1)
    & val(c24,mandela_0)
    & circ(c273,c946)
    & mcont(c273,c969)
    & obj(c273,c14)
    & subs(c273,gelten_1_4)
    & sub(c36,allianz_1_1)
    & pred(c41,kommunist_1_1)
    & preds(c47,wahl_1_1)
    & agt(c48,c22)
    & assoc(c48,c41)
    & ctxt(c48,c36)
    & purp(c48,c47)
    & subs(c48,antreten_2_1)
    & prop(c938,wahrscheinlich_2_1)
    & sub(c938,wahlgewinner_1_1)
    & ctxt(c946,c953)
    & preds(c946,c950)
    & prop(c946,allgemein_1_1)
    & pmod(c950,erst_1_1,wahl_1_1)
    & agt(c953,c959)
    & subs(c953,beteiligung_1_1)
    & loc(c959,c968)
    & pred(c959,mohr_1_1)
    & attr(c965,c966)
    & sub(c965,land_1_1)
    & sub(c966,name_1_1)
    & val(c966,s__374dafrika_0)
    & in(c968,c965)
    & arg1(c969,c14)
    & arg2(c969,c938)
    & subr(c969,rprs_0)
    & exp(c970,c938)
    & subs(c970,gewinnen_1_1)
    & assoc(nationalkongre__337_1_1,national__1_1)
    & sub(nationalkongre__337_1_1,einrichtung_1_2)
    & sub(nationalkongre__337_1_1,kongre__337_1_1)
    & assoc(wahlgewinner_1_1,auswahl_1_1)
    & sub(wahlgewinner_1_1,gewinner__1_1)
    & sort(c14,d)
    & sort(c14,io)
    & card(c14,int1)
    & etype(c14,int0)
    & fact(c14,real)
    & gener(c14,sp)
    & quant(c14,one)
    & refer(c14,det)
    & varia(c14,con)
    & sort(c15,na)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,indet)
    & varia(c15,varia_c)
    & sort(afrikanisch__1_1,nq)
    & sort(nationalkongre__337_1_1,d)
    & sort(nationalkongre__337_1_1,io)
    & card(nationalkongre__337_1_1,int1)
    & etype(nationalkongre__337_1_1,int0)
    & fact(nationalkongre__337_1_1,real)
    & gener(nationalkongre__337_1_1,ge)
    & quant(nationalkongre__337_1_1,one)
    & refer(nationalkongre__337_1_1,refer_c)
    & varia(nationalkongre__337_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(anc_0,fe)
    & sort(c22,d)
    & card(c22,int1)
    & etype(c22,int0)
    & fact(c22,real)
    & gener(c22,sp)
    & quant(c22,one)
    & refer(c22,det)
    & varia(c22,con)
    & sort(c23,na)
    & card(c23,int1)
    & etype(c23,int0)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,one)
    & refer(c23,indet)
    & varia(c23,varia_c)
    & sort(c24,na)
    & card(c24,int1)
    & etype(c24,int0)
    & fact(c24,real)
    & gener(c24,sp)
    & quant(c24,one)
    & refer(c24,indet)
    & varia(c24,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c273,st)
    & fact(c273,real)
    & gener(c273,sp)
    & sort(c946,ad)
    & card(c946,cons(x_constant,cons(int1,nil)))
    & etype(c946,int1)
    & fact(c946,real)
    & gener(c946,sp)
    & quant(c946,mult)
    & refer(c946,det)
    & varia(c946,con)
    & sort(c969,st)
    & fact(c969,hypo)
    & gener(c969,sp)
    & sort(gelten_1_4,st)
    & fact(gelten_1_4,real)
    & gener(gelten_1_4,ge)
    & sort(c36,io)
    & card(c36,int1)
    & etype(c36,int0)
    & fact(c36,real)
    & gener(c36,gener_c)
    & quant(c36,one)
    & refer(c36,refer_c)
    & varia(c36,varia_c)
    & sort(allianz_1_1,io)
    & card(allianz_1_1,int1)
    & etype(allianz_1_1,int0)
    & fact(allianz_1_1,real)
    & gener(allianz_1_1,ge)
    & quant(allianz_1_1,one)
    & refer(allianz_1_1,refer_c)
    & varia(allianz_1_1,varia_c)
    & sort(c41,d)
    & card(c41,cons(x_constant,cons(int1,nil)))
    & etype(c41,int1)
    & fact(c41,real)
    & gener(c41,sp)
    & quant(c41,mult)
    & refer(c41,det)
    & varia(c41,con)
    & sort(kommunist_1_1,d)
    & card(kommunist_1_1,int1)
    & etype(kommunist_1_1,int0)
    & fact(kommunist_1_1,real)
    & gener(kommunist_1_1,ge)
    & quant(kommunist_1_1,one)
    & refer(kommunist_1_1,refer_c)
    & varia(kommunist_1_1,varia_c)
    & sort(c47,ad)
    & card(c47,cons(x_constant,cons(int1,nil)))
    & etype(c47,int1)
    & fact(c47,real)
    & gener(c47,sp)
    & quant(c47,mult)
    & refer(c47,det)
    & varia(c47,con)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c48,da)
    & fact(c48,real)
    & gener(c48,sp)
    & sort(antreten_2_1,da)
    & fact(antreten_2_1,real)
    & gener(antreten_2_1,ge)
    & sort(c938,d)
    & sort(c938,io)
    & card(c938,int1)
    & etype(c938,int0)
    & fact(c938,real)
    & gener(c938,sp)
    & quant(c938,one)
    & refer(c938,det)
    & varia(c938,con)
    & sort(wahrscheinlich_2_1,nq)
    & sort(wahlgewinner_1_1,d)
    & sort(wahlgewinner_1_1,io)
    & card(wahlgewinner_1_1,int1)
    & etype(wahlgewinner_1_1,int0)
    & fact(wahlgewinner_1_1,real)
    & gener(wahlgewinner_1_1,ge)
    & quant(wahlgewinner_1_1,one)
    & refer(wahlgewinner_1_1,refer_c)
    & varia(wahlgewinner_1_1,varia_c)
    & sort(c953,ad)
    & card(c953,int1)
    & etype(c953,int0)
    & fact(c953,real)
    & gener(c953,sp)
    & quant(c953,one)
    & refer(c953,det)
    & varia(c953,varia_c)
    & sort(c950,ad)
    & card(c950,int1)
    & etype(c950,int0)
    & fact(c950,real)
    & gener(c950,ge)
    & quant(c950,one)
    & refer(c950,refer_c)
    & varia(c950,varia_c)
    & sort(allgemein_1_1,nq)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(c959,d)
    & card(c959,cons(x_constant,cons(int1,nil)))
    & etype(c959,int1)
    & fact(c959,real)
    & gener(c959,sp)
    & quant(c959,mult)
    & refer(c959,det)
    & varia(c959,con)
    & sort(beteiligung_1_1,ad)
    & card(beteiligung_1_1,int1)
    & etype(beteiligung_1_1,int0)
    & fact(beteiligung_1_1,real)
    & gener(beteiligung_1_1,ge)
    & quant(beteiligung_1_1,one)
    & refer(beteiligung_1_1,refer_c)
    & varia(beteiligung_1_1,varia_c)
    & sort(c968,l)
    & card(c968,int1)
    & etype(c968,int0)
    & fact(c968,real)
    & gener(c968,sp)
    & quant(c968,one)
    & refer(c968,det)
    & varia(c968,con)
    & sort(mohr_1_1,d)
    & card(mohr_1_1,int1)
    & etype(mohr_1_1,int0)
    & fact(mohr_1_1,real)
    & gener(mohr_1_1,ge)
    & quant(mohr_1_1,one)
    & refer(mohr_1_1,refer_c)
    & varia(mohr_1_1,varia_c)
    & sort(c965,d)
    & sort(c965,io)
    & card(c965,int1)
    & etype(c965,int0)
    & fact(c965,real)
    & gener(c965,sp)
    & quant(c965,one)
    & refer(c965,det)
    & varia(c965,con)
    & sort(c966,na)
    & card(c966,int1)
    & etype(c966,int0)
    & fact(c966,real)
    & gener(c966,sp)
    & quant(c966,one)
    & refer(c966,indet)
    & varia(c966,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(c970,dn)
    & fact(c970,real)
    & gener(c970,sp)
    & sort(gewinnen_1_1,dn)
    & fact(gewinnen_1_1,real)
    & gener(gewinnen_1_1,ge)
    & sort(national__1_1,nq)
    & sort(einrichtung_1_2,ent)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,etype_c)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,gener_c)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(kongre__337_1_1,d)
    & sort(kongre__337_1_1,io)
    & card(kongre__337_1_1,int1)
    & etype(kongre__337_1_1,int0)
    & fact(kongre__337_1_1,real)
    & gener(kongre__337_1_1,ge)
    & quant(kongre__337_1_1,one)
    & refer(kongre__337_1_1,refer_c)
    & varia(kongre__337_1_1,varia_c)
    & sort(auswahl_1_1,as)
    & card(auswahl_1_1,int1)
    & etype(auswahl_1_1,int0)
    & fact(auswahl_1_1,real)
    & gener(auswahl_1_1,ge)
    & quant(auswahl_1_1,one)
    & refer(auswahl_1_1,refer_c)
    & varia(auswahl_1_1,varia_c)
    & sort(gewinner__1_1,d)
    & sort(gewinner__1_1,io)
    & card(gewinner__1_1,int1)
    & etype(gewinner__1_1,int0)
    & fact(gewinner__1_1,real)
    & gener(gewinner__1_1,ge)
    & quant(gewinner__1_1,one)
    & refer(gewinner__1_1,refer_c)
    & varia(gewinner__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
