%------------------------------------------------------------------------------
% File     : CSR116+46 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_qapn_175_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11062 (   0 equ)
%            Maximal formula atoms :  350 (   1 avg)
%            Number of connectives :  873 (   0   ~;  18   |; 729   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  350 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-11 aty)
%            Number of functors    : 16673 (16673 usr;16672 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_qapn_175,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_qapn_175,hypothesis,
    ( attch(c101,c85)
    & preds(c109,c111)
    & prop(c109,demokratisch__1_1)
    & pmod(c111,erst_1_1,wahl_1_1)
    & attr(c130,c131)
    & sub(c130,land_1_1)
    & sub(c131,name_1_1)
    & val(c131,s__374dafrika_0)
    & sub(c26,an_f__374hrer_1_1)
    & tupl_p11(c287,c26,c34,c43,c53,c59,c67,c76,c85,c109,c130)
    & attch(c30,c26)
    & sub(c30,inkatha_1_1)
    & sub(c34,freiheitspartei_1_1)
    & attr(c43,c44)
    & attr(c43,c45)
    & sub(c43,mensch_1_1)
    & sub(c44,eigenname_1_1)
    & val(c44,mangosuthu_0)
    & sub(c45,familiename_1_1)
    & val(c45,buthelezi_0)
    & subs(c53,treffen_3_1)
    & sub(c59,pr__344sident_1_1)
    & attch(c63,c59)
    & prop(c63,afrikanisch__1_1)
    & sub(c63,national_2_1)
    & sub(c67,kongre__337_1_1)
    & attr(c76,c77)
    & attr(c76,c78)
    & sub(c76,mensch_1_1)
    & sub(c77,eigenname_1_1)
    & val(c77,nelson_0)
    & sub(c78,familiename_1_1)
    & val(c78,mandela_0)
    & subs(c85,absicht_1_1)
    & assoc(demokratisch__1_1,demokratie__1_1)
    & assoc(freiheitspartei_1_1,freiheit_1_1)
    & sub(freiheitspartei_1_1,partei_1_1)
    & sort(c101,o)
    & card(c101,int1)
    & etype(c101,int0)
    & fact(c101,real)
    & gener(c101,sp)
    & quant(c101,one)
    & refer(c101,det)
    & varia(c101,varia_c)
    & sort(c85,as)
    & card(c85,int1)
    & etype(c85,int0)
    & fact(c85,real)
    & gener(c85,sp)
    & quant(c85,one)
    & refer(c85,det)
    & varia(c85,varia_c)
    & sort(c109,ad)
    & card(c109,cons(x_constant,cons(int1,nil)))
    & etype(c109,int1)
    & fact(c109,real)
    & gener(c109,sp)
    & quant(c109,mult)
    & refer(c109,det)
    & varia(c109,con)
    & sort(c111,ad)
    & card(c111,int1)
    & etype(c111,int0)
    & fact(c111,real)
    & gener(c111,ge)
    & quant(c111,one)
    & refer(c111,refer_c)
    & varia(c111,varia_c)
    & sort(demokratisch__1_1,nq)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c130,d)
    & sort(c130,io)
    & card(c130,int1)
    & etype(c130,int0)
    & fact(c130,real)
    & gener(c130,sp)
    & quant(c130,one)
    & refer(c130,det)
    & varia(c130,con)
    & sort(c131,na)
    & card(c131,int1)
    & etype(c131,int0)
    & fact(c131,real)
    & gener(c131,sp)
    & quant(c131,one)
    & refer(c131,indet)
    & varia(c131,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c26,d)
    & card(c26,int1)
    & etype(c26,int0)
    & fact(c26,real)
    & gener(c26,sp)
    & quant(c26,one)
    & refer(c26,det)
    & varia(c26,con)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c)
    & sort(c287,ent)
    & card(c287,card_c)
    & etype(c287,etype_c)
    & fact(c287,real)
    & gener(c287,gener_c)
    & quant(c287,quant_c)
    & refer(c287,refer_c)
    & varia(c287,varia_c)
    & sort(c34,d)
    & sort(c34,io)
    & card(c34,int1)
    & etype(c34,int1)
    & fact(c34,real)
    & gener(c34,gener_c)
    & quant(c34,one)
    & refer(c34,refer_c)
    & varia(c34,varia_c)
    & sort(c43,d)
    & card(c43,int1)
    & etype(c43,int0)
    & fact(c43,real)
    & gener(c43,sp)
    & quant(c43,one)
    & refer(c43,det)
    & varia(c43,con)
    & sort(c53,ad)
    & card(c53,int1)
    & etype(c53,int0)
    & fact(c53,real)
    & gener(c53,sp)
    & quant(c53,one)
    & refer(c53,indet)
    & varia(c53,varia_c)
    & sort(c59,d)
    & card(c59,int1)
    & etype(c59,int0)
    & fact(c59,real)
    & gener(c59,sp)
    & quant(c59,one)
    & refer(c59,det)
    & varia(c59,con)
    & sort(c67,d)
    & sort(c67,io)
    & card(c67,int1)
    & etype(c67,int0)
    & fact(c67,real)
    & gener(c67,gener_c)
    & quant(c67,one)
    & refer(c67,refer_c)
    & varia(c67,varia_c)
    & sort(c76,d)
    & card(c76,int1)
    & etype(c76,int0)
    & fact(c76,real)
    & gener(c76,sp)
    & quant(c76,one)
    & refer(c76,det)
    & varia(c76,con)
    & sort(c30,o)
    & card(c30,int1)
    & etype(c30,int0)
    & fact(c30,real)
    & gener(c30,sp)
    & quant(c30,one)
    & refer(c30,det)
    & varia(c30,con)
    & sort(inkatha_1_1,o)
    & card(inkatha_1_1,int1)
    & etype(inkatha_1_1,int0)
    & fact(inkatha_1_1,real)
    & gener(inkatha_1_1,ge)
    & quant(inkatha_1_1,one)
    & refer(inkatha_1_1,refer_c)
    & varia(inkatha_1_1,varia_c)
    & sort(freiheitspartei_1_1,d)
    & sort(freiheitspartei_1_1,io)
    & card(freiheitspartei_1_1,card_c)
    & etype(freiheitspartei_1_1,int1)
    & fact(freiheitspartei_1_1,real)
    & gener(freiheitspartei_1_1,ge)
    & quant(freiheitspartei_1_1,quant_c)
    & refer(freiheitspartei_1_1,refer_c)
    & varia(freiheitspartei_1_1,varia_c)
    & sort(c44,na)
    & card(c44,int1)
    & etype(c44,int0)
    & fact(c44,real)
    & gener(c44,sp)
    & quant(c44,one)
    & refer(c44,indet)
    & varia(c44,varia_c)
    & sort(c45,na)
    & card(c45,int1)
    & etype(c45,int0)
    & fact(c45,real)
    & gener(c45,sp)
    & quant(c45,one)
    & refer(c45,indet)
    & varia(c45,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(mangosuthu_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(buthelezi_0,fe)
    & sort(treffen_3_1,ad)
    & card(treffen_3_1,int1)
    & etype(treffen_3_1,int0)
    & fact(treffen_3_1,real)
    & gener(treffen_3_1,ge)
    & quant(treffen_3_1,one)
    & refer(treffen_3_1,refer_c)
    & varia(treffen_3_1,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c63,o)
    & card(c63,int1)
    & etype(c63,int0)
    & fact(c63,real)
    & gener(c63,sp)
    & quant(c63,one)
    & refer(c63,det)
    & varia(c63,con)
    & sort(afrikanisch__1_1,nq)
    & sort(national_2_1,o)
    & card(national_2_1,int1)
    & etype(national_2_1,int0)
    & fact(national_2_1,real)
    & gener(national_2_1,ge)
    & quant(national_2_1,one)
    & refer(national_2_1,refer_c)
    & varia(national_2_1,varia_c)
    & sort(kongre__337_1_1,d)
    & sort(kongre__337_1_1,io)
    & card(kongre__337_1_1,int1)
    & etype(kongre__337_1_1,int0)
    & fact(kongre__337_1_1,real)
    & gener(kongre__337_1_1,ge)
    & quant(kongre__337_1_1,one)
    & refer(kongre__337_1_1,refer_c)
    & varia(kongre__337_1_1,varia_c)
    & sort(c77,na)
    & card(c77,int1)
    & etype(c77,int0)
    & fact(c77,real)
    & gener(c77,sp)
    & quant(c77,one)
    & refer(c77,indet)
    & varia(c77,varia_c)
    & sort(c78,na)
    & card(c78,int1)
    & etype(c78,int0)
    & fact(c78,real)
    & gener(c78,sp)
    & quant(c78,one)
    & refer(c78,indet)
    & varia(c78,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(absicht_1_1,as)
    & card(absicht_1_1,int1)
    & etype(absicht_1_1,int0)
    & fact(absicht_1_1,real)
    & gener(absicht_1_1,ge)
    & quant(absicht_1_1,one)
    & refer(absicht_1_1,refer_c)
    & varia(absicht_1_1,varia_c)
    & sort(demokratie__1_1,io)
    & card(demokratie__1_1,int1)
    & etype(demokratie__1_1,int0)
    & fact(demokratie__1_1,real)
    & gener(demokratie__1_1,ge)
    & quant(demokratie__1_1,one)
    & refer(demokratie__1_1,refer_c)
    & varia(demokratie__1_1,varia_c)
    & sort(freiheit_1_1,as)
    & sort(freiheit_1_1,io)
    & card(freiheit_1_1,int1)
    & etype(freiheit_1_1,int0)
    & fact(freiheit_1_1,real)
    & gener(freiheit_1_1,ge)
    & quant(freiheit_1_1,one)
    & refer(freiheit_1_1,refer_c)
    & varia(freiheit_1_1,varia_c)
    & sort(partei_1_1,d)
    & sort(partei_1_1,io)
    & card(partei_1_1,card_c)
    & etype(partei_1_1,int1)
    & fact(partei_1_1,real)
    & gener(partei_1_1,ge)
    & quant(partei_1_1,quant_c)
    & refer(partei_1_1,refer_c)
    & varia(partei_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
