%------------------------------------------------------------------------------
% File     : CSR116+44 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mn3_310_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.29 v7.4.0, 0.19 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.44 v6.0.0, 0.50 v5.4.0, 0.48 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.40 v4.1.0, 0.50 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10887 (   0 equ)
%            Maximal formula atoms :  173 (   1 avg)
%            Number of connectives :  698 (   0   ~;  18   |; 554   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  173 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16652 (16652 usr;16651 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mn3_310,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & rslt(X7,X3)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mn3_310,hypothesis,
    ( sub(c16,montag__1_1)
    & prop(c23,schwarz_1_1)
    & sub(c23,c25)
    & pmod(c25,erst_1_1,staatpr__344sident_1_1)
    & obj(c27,c6)
    & rslt(c27,c42)
    & subs(c27,ernennen_1_2)
    & temp(c27,c16)
    & attch(c37,c23)
    & attr(c37,c38)
    & sub(c37,land_1_1)
    & sub(c38,name_1_1)
    & val(c38,s__374dafrika_0)
    & arg1(c42,c6)
    & arg2(c42,c23)
    & subr(c42,rprs_0)
    & attr(c6,c7)
    & attr(c6,c8)
    & sub(c6,mensch_1_1)
    & sub(c7,eigenname_1_1)
    & val(c7,nelson_0)
    & sub(c8,familiename_1_1)
    & val(c8,mandela_0)
    & assoc(staatpr__344sident_1_1,land_1_1)
    & sub(staatpr__344sident_1_1,pr__344sident_1_1)
    & sort(c16,ta)
    & card(c16,int1)
    & etype(c16,int0)
    & fact(c16,real)
    & gener(c16,sp)
    & quant(c16,one)
    & refer(c16,det)
    & varia(c16,con)
    & sort(montag__1_1,ta)
    & card(montag__1_1,int1)
    & etype(montag__1_1,int0)
    & fact(montag__1_1,real)
    & gener(montag__1_1,ge)
    & quant(montag__1_1,one)
    & refer(montag__1_1,refer_c)
    & varia(montag__1_1,varia_c)
    & sort(c23,d)
    & card(c23,int1)
    & etype(c23,int0)
    & fact(c23,real)
    & gener(c23,sp)
    & quant(c23,one)
    & refer(c23,det)
    & varia(c23,con)
    & sort(schwarz_1_1,tq)
    & sort(c25,d)
    & card(c25,int1)
    & etype(c25,int0)
    & fact(c25,real)
    & gener(c25,ge)
    & quant(c25,one)
    & refer(c25,refer_c)
    & varia(c25,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(staatpr__344sident_1_1,d)
    & card(staatpr__344sident_1_1,int1)
    & etype(staatpr__344sident_1_1,int0)
    & fact(staatpr__344sident_1_1,real)
    & gener(staatpr__344sident_1_1,ge)
    & quant(staatpr__344sident_1_1,one)
    & refer(staatpr__344sident_1_1,refer_c)
    & varia(staatpr__344sident_1_1,varia_c)
    & sort(c27,da)
    & fact(c27,real)
    & gener(c27,sp)
    & sort(c6,d)
    & card(c6,int1)
    & etype(c6,int0)
    & fact(c6,real)
    & gener(c6,sp)
    & quant(c6,one)
    & refer(c6,det)
    & varia(c6,con)
    & sort(c42,st)
    & fact(c42,real)
    & gener(c42,sp)
    & sort(ernennen_1_2,da)
    & fact(ernennen_1_2,real)
    & gener(ernennen_1_2,ge)
    & sort(c37,d)
    & sort(c37,io)
    & card(c37,int1)
    & etype(c37,int0)
    & fact(c37,real)
    & gener(c37,sp)
    & quant(c37,one)
    & refer(c37,det)
    & varia(c37,con)
    & sort(c38,na)
    & card(c38,int1)
    & etype(c38,int0)
    & fact(c38,real)
    & gener(c38,sp)
    & quant(c38,one)
    & refer(c38,indet)
    & varia(c38,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(c7,na)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,indet)
    & varia(c7,varia_c)
    & sort(c8,na)
    & card(c8,int1)
    & etype(c8,int0)
    & fact(c8,real)
    & gener(c8,sp)
    & quant(c8,one)
    & refer(c8,indet)
    & varia(c8,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
