%------------------------------------------------------------------------------
% File     : CSR116+43 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mn3_287_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10999 (   0 equ)
%            Maximal formula atoms :  286 (   1 avg)
%            Number of connectives :  810 (   0   ~;  18   |; 666   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  286 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16663 (16663 usr;16662 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mn3_287,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mn3_287,hypothesis,
    ( pmod(c1,ehemalig_1_1,kolonie_1_1)
    & attr(c19,c20)
    & attr(c19,c21)
    & prop(c19,s__374dafrikanisch_1_1)
    & purp(c19,c29)
    & sub(c19,pr__344sident_1_1)
    & sub(c20,eigenname_1_1)
    & val(c20,nelson_0)
    & sub(c21,familiename_1_1)
    & val(c21,mandela_0)
    & agt(c29,c5)
    & obj(c29,c41)
    & subs(c29,c32)
    & assoc(c3,c42)
    & obj(c3,c19)
    & scar(c3,c5)
    & subs(c3,haben_1_1)
    & temp(c3,c9)
    & pmod(c32,erst_1_1,staatgast_1_1)
    & prop(c41,bundesdeutsch_1_1)
    & sub(c41,c1)
    & sub(c42,suedwest_1_1)
    & attr(c5,c6)
    & sub(c5,land_1_1)
    & obj(c53,c55)
    & semrel(c53,c3)
    & subs(c53,empfangen_1_1)
    & attr(c55,c56)
    & sub(c55,gebietsinstitution_1_1)
    & sub(c56,name_1_1)
    & val(c56,afrika_0)
    & sub(c6,name_1_1)
    & val(c6,namibia_0)
    & sub(c9,dienstag__1_1)
    & sub(pr__344sident_1_1,mensch_1_1)
    & assoc(staatgast_1_1,land_1_1)
    & subs(staatgast_1_1,besuch_1_1)
    & assoc(suedwest_1_1,sued_1_1)
    & sub(suedwest_1_1,west__1_1)
    & sort(c1,ent)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,fact_c)
    & gener(c1,gener_c)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(ehemalig_1_1,tq)
    & sort(kolonie_1_1,d)
    & card(kolonie_1_1,int1)
    & etype(kolonie_1_1,int0)
    & fact(kolonie_1_1,real)
    & gener(kolonie_1_1,ge)
    & quant(kolonie_1_1,one)
    & refer(kolonie_1_1,refer_c)
    & varia(kolonie_1_1,varia_c)
    & sort(c19,d)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,det)
    & varia(c19,con)
    & sort(c20,na)
    & card(c20,int1)
    & etype(c20,int0)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,one)
    & refer(c20,indet)
    & varia(c20,varia_c)
    & sort(c21,na)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,indet)
    & varia(c21,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(c29,ad)
    & sort(c29,as)
    & card(c29,int1)
    & etype(c29,int0)
    & fact(c29,real)
    & gener(c29,sp)
    & quant(c29,one)
    & refer(c29,det)
    & varia(c29,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c5,o)
    & card(c5,int1)
    & etype(c5,int0)
    & fact(c5,real)
    & gener(c5,sp)
    & quant(c5,one)
    & refer(c5,det)
    & varia(c5,varia_c)
    & sort(c41,d)
    & card(c41,int1)
    & etype(c41,int0)
    & fact(c41,real)
    & gener(c41,sp)
    & quant(c41,one)
    & refer(c41,det)
    & varia(c41,con)
    & sort(c32,ad)
    & sort(c32,as)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,ge)
    & quant(c32,one)
    & refer(c32,refer_c)
    & varia(c32,varia_c)
    & sort(c3,st)
    & fact(c3,real)
    & gener(c3,sp)
    & sort(c42,d)
    & sort(c42,io)
    & card(c42,int1)
    & etype(c42,int0)
    & fact(c42,real)
    & gener(c42,gener_c)
    & quant(c42,one)
    & refer(c42,refer_c)
    & varia(c42,varia_c)
    & sort(haben_1_1,st)
    & fact(haben_1_1,real)
    & gener(haben_1_1,ge)
    & sort(c9,ta)
    & card(c9,int1)
    & etype(c9,int0)
    & fact(c9,real)
    & gener(c9,sp)
    & quant(c9,one)
    & refer(c9,det)
    & varia(c9,con)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(staatgast_1_1,ad)
    & sort(staatgast_1_1,as)
    & card(staatgast_1_1,int1)
    & etype(staatgast_1_1,int0)
    & fact(staatgast_1_1,real)
    & gener(staatgast_1_1,ge)
    & quant(staatgast_1_1,one)
    & refer(staatgast_1_1,refer_c)
    & varia(staatgast_1_1,varia_c)
    & sort(bundesdeutsch_1_1,tq)
    & sort(suedwest_1_1,d)
    & sort(suedwest_1_1,io)
    & card(suedwest_1_1,int1)
    & etype(suedwest_1_1,int0)
    & fact(suedwest_1_1,real)
    & gener(suedwest_1_1,ge)
    & quant(suedwest_1_1,one)
    & refer(suedwest_1_1,refer_c)
    & varia(suedwest_1_1,varia_c)
    & sort(c6,na)
    & card(c6,int1)
    & etype(c6,int0)
    & fact(c6,real)
    & gener(c6,sp)
    & quant(c6,one)
    & refer(c6,indet)
    & varia(c6,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(c53,dn)
    & fact(c53,real)
    & gener(c53,sp)
    & sort(c55,d)
    & sort(c55,io)
    & card(c55,int1)
    & etype(c55,int0)
    & fact(c55,real)
    & gener(c55,sp)
    & quant(c55,one)
    & refer(c55,det)
    & varia(c55,con)
    & sort(empfangen_1_1,dn)
    & fact(empfangen_1_1,real)
    & gener(empfangen_1_1,ge)
    & sort(c56,na)
    & card(c56,int1)
    & etype(c56,int0)
    & fact(c56,real)
    & gener(c56,sp)
    & quant(c56,one)
    & refer(c56,indet)
    & varia(c56,varia_c)
    & sort(gebietsinstitution_1_1,d)
    & sort(gebietsinstitution_1_1,io)
    & card(gebietsinstitution_1_1,int1)
    & etype(gebietsinstitution_1_1,int0)
    & fact(gebietsinstitution_1_1,real)
    & gener(gebietsinstitution_1_1,ge)
    & quant(gebietsinstitution_1_1,one)
    & refer(gebietsinstitution_1_1,refer_c)
    & varia(gebietsinstitution_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(afrika_0,fe)
    & sort(namibia_0,fe)
    & sort(dienstag__1_1,ta)
    & card(dienstag__1_1,int1)
    & etype(dienstag__1_1,int0)
    & fact(dienstag__1_1,real)
    & gener(dienstag__1_1,ge)
    & quant(dienstag__1_1,one)
    & refer(dienstag__1_1,refer_c)
    & varia(dienstag__1_1,varia_c)
    & sort(mensch_1_1,ent)
    & card(mensch_1_1,card_c)
    & etype(mensch_1_1,etype_c)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,gener_c)
    & quant(mensch_1_1,quant_c)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(besuch_1_1,ad)
    & sort(besuch_1_1,as)
    & card(besuch_1_1,int1)
    & etype(besuch_1_1,int0)
    & fact(besuch_1_1,real)
    & gener(besuch_1_1,ge)
    & quant(besuch_1_1,one)
    & refer(besuch_1_1,refer_c)
    & varia(besuch_1_1,varia_c)
    & sort(sued_1_1,oa)
    & card(sued_1_1,int1)
    & etype(sued_1_1,int0)
    & fact(sued_1_1,real)
    & gener(sued_1_1,ge)
    & quant(sued_1_1,one)
    & refer(sued_1_1,refer_c)
    & varia(sued_1_1,varia_c)
    & sort(west__1_1,d)
    & sort(west__1_1,io)
    & card(west__1_1,int1)
    & etype(west__1_1,int0)
    & fact(west__1_1,real)
    & gener(west__1_1,ge)
    & quant(west__1_1,one)
    & refer(west__1_1,refer_c)
    & varia(west__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
