%------------------------------------------------------------------------------
% File     : CSR116+42 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mn3_286_a671_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10910 (   0 equ)
%            Maximal formula atoms :  198 (   1 avg)
%            Number of connectives :  721 (   0   ~;  18   |; 577   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  198 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16657 (16657 usr;16656 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mn3_286_a671,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mn3_286_a671,hypothesis,
    ( attr(c294,c295)
    & attr(c294,c296)
    & attr(c294,c301)
    & sub(c294,mensch_1_1)
    & sub(c295,eigenname_1_1)
    & val(c295,nelson_0)
    & sub(c296,familiename_1_1)
    & val(c296,mandela_0)
    & sub(c301,familiename_1_1)
    & val(c301,mandela_0)
    & sub(c303,pr__344sident_1_1)
    & attch(c313,c303)
    & attr(c313,c314)
    & sub(c313,land_1_1)
    & sub(c314,name_1_1)
    & val(c314,s__374dafrika_0)
    & name(c324,zukunft_in_w__374rde_und_vertrauen_0)
    & pred(c330,landesleute_1_1)
    & sub(c332,gehaltsangabe_1_1)
    & tupl_p7(c459,c294,c294,c303,c324,c330,c332)
    & assoc(landesleute_1_1,land_2_1)
    & sub(landesleute_1_1,leute_1_1)
    & sort(c294,d)
    & card(c294,int1)
    & etype(c294,int0)
    & fact(c294,real)
    & gener(c294,sp)
    & quant(c294,one)
    & refer(c294,det)
    & varia(c294,con)
    & sort(c295,na)
    & card(c295,int1)
    & etype(c295,int0)
    & fact(c295,real)
    & gener(c295,sp)
    & quant(c295,one)
    & refer(c295,indet)
    & varia(c295,varia_c)
    & sort(c296,na)
    & card(c296,int1)
    & etype(c296,int0)
    & fact(c296,real)
    & gener(c296,sp)
    & quant(c296,one)
    & refer(c296,indet)
    & varia(c296,varia_c)
    & sort(c301,na)
    & card(c301,int1)
    & etype(c301,int0)
    & fact(c301,real)
    & gener(c301,sp)
    & quant(c301,one)
    & refer(c301,indet)
    & varia(c301,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c303,d)
    & card(c303,int1)
    & etype(c303,int0)
    & fact(c303,real)
    & gener(c303,sp)
    & quant(c303,one)
    & refer(c303,det)
    & varia(c303,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c313,d)
    & sort(c313,io)
    & card(c313,int1)
    & etype(c313,int0)
    & fact(c313,real)
    & gener(c313,sp)
    & quant(c313,one)
    & refer(c313,det)
    & varia(c313,con)
    & sort(c314,na)
    & card(c314,int1)
    & etype(c314,int0)
    & fact(c314,real)
    & gener(c314,sp)
    & quant(c314,one)
    & refer(c314,indet)
    & varia(c314,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c324,o)
    & card(c324,int1)
    & etype(c324,int0)
    & fact(c324,real)
    & gener(c324,gener_c)
    & quant(c324,one)
    & refer(c324,refer_c)
    & varia(c324,varia_c)
    & sort(zukunft_in_w__374rde_und_vertrauen_0,fe)
    & sort(c330,d)
    & card(c330,cons(x_constant,cons(int1,nil)))
    & etype(c330,int1)
    & fact(c330,real)
    & gener(c330,gener_c)
    & quant(c330,all)
    & refer(c330,det)
    & varia(c330,con)
    & sort(landesleute_1_1,d)
    & card(landesleute_1_1,int1)
    & etype(landesleute_1_1,int0)
    & fact(landesleute_1_1,real)
    & gener(landesleute_1_1,ge)
    & quant(landesleute_1_1,one)
    & refer(landesleute_1_1,refer_c)
    & varia(landesleute_1_1,varia_c)
    & sort(c332,d)
    & sort(c332,io)
    & card(c332,int1)
    & etype(c332,int0)
    & fact(c332,real)
    & gener(c332,gener_c)
    & quant(c332,one)
    & refer(c332,refer_c)
    & varia(c332,varia_c)
    & sort(gehaltsangabe_1_1,d)
    & sort(gehaltsangabe_1_1,io)
    & card(gehaltsangabe_1_1,int1)
    & etype(gehaltsangabe_1_1,int0)
    & fact(gehaltsangabe_1_1,real)
    & gener(gehaltsangabe_1_1,ge)
    & quant(gehaltsangabe_1_1,one)
    & refer(gehaltsangabe_1_1,refer_c)
    & varia(gehaltsangabe_1_1,varia_c)
    & sort(c459,ent)
    & card(c459,card_c)
    & etype(c459,etype_c)
    & fact(c459,real)
    & gener(c459,gener_c)
    & quant(c459,quant_c)
    & refer(c459,refer_c)
    & varia(c459,varia_c)
    & sort(land_2_1,d)
    & card(land_2_1,int1)
    & etype(land_2_1,int0)
    & fact(land_2_1,real)
    & gener(land_2_1,ge)
    & quant(land_2_1,one)
    & refer(land_2_1,refer_c)
    & varia(land_2_1,varia_c)
    & sort(leute_1_1,d)
    & card(leute_1_1,int1)
    & etype(leute_1_1,int0)
    & fact(leute_1_1,real)
    & gener(leute_1_1,ge)
    & quant(leute_1_1,one)
    & refer(leute_1_1,refer_c)
    & varia(leute_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
