%------------------------------------------------------------------------------
% File     : CSR116+41 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mn3_283_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.38 v8.2.0, 0.33 v8.1.0, 0.43 v7.5.0, 0.52 v7.4.0, 0.44 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.43 v6.4.0, 0.57 v6.3.0, 0.54 v6.2.0, 0.73 v6.1.0, 0.76 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.61 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10961 (   0 equ)
%            Maximal formula atoms :  247 (   1 avg)
%            Number of connectives :  772 (   0   ~;  18   |; 628   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  247 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16662 (16662 usr;16661 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mn3_283,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mn3_283,hypothesis,
    ( equ(c11,c11)
    & obj(c11,c161)
    & prop(c11,afrikanisch__1_1)
    & subs(c11,feier__1_1)
    & subs(c11,vereidigung_1_1)
    & temp(c11,c167)
    & pmod(c151,erst_1_1,pr__344sident_1_1)
    & attch(c155,c161)
    & attr(c155,c156)
    & sub(c155,land_1_1)
    & sub(c156,name_1_1)
    & val(c156,s__374dafrika_0)
    & attr(c161,c162)
    & attr(c161,c163)
    & loc(c161,c180)
    & prop(c161,schwarz_1_1)
    & sub(c161,c151)
    & sub(c162,eigenname_1_1)
    & val(c162,nelson_0)
    & sub(c163,familiename_1_1)
    & val(c163,mandela_0)
    & sub(c167,dienstag__1_1)
    & attr(c177,c178)
    & sub(c177,hauptsstadt_1_1)
    & sub(c178,name_1_1)
    & val(c178,pretoria_0)
    & in(c180,c177)
    & attch(c20,c11)
    & prop(c20,ausgelassen_1_1)
    & subs(c20,freude_1_1)
    & arg1(c23,c11)
    & arg2(c23,c11)
    & subr(c23,equ_0)
    & sub(hauptsstadt_1_1,stadt__1_1)
    & sub(pr__344sident_1_1,mensch_1_1)
    & sort(c11,ad)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,indet)
    & varia(c11,varia_c)
    & sort(c161,d)
    & card(c161,int1)
    & etype(c161,int0)
    & fact(c161,real)
    & gener(c161,sp)
    & quant(c161,one)
    & refer(c161,det)
    & varia(c161,con)
    & sort(afrikanisch__1_1,nq)
    & sort(feier__1_1,ad)
    & card(feier__1_1,int1)
    & etype(feier__1_1,int0)
    & fact(feier__1_1,real)
    & gener(feier__1_1,ge)
    & quant(feier__1_1,one)
    & refer(feier__1_1,refer_c)
    & varia(feier__1_1,varia_c)
    & sort(vereidigung_1_1,ad)
    & card(vereidigung_1_1,int1)
    & etype(vereidigung_1_1,int0)
    & fact(vereidigung_1_1,real)
    & gener(vereidigung_1_1,ge)
    & quant(vereidigung_1_1,one)
    & refer(vereidigung_1_1,refer_c)
    & varia(vereidigung_1_1,varia_c)
    & sort(c167,ta)
    & card(c167,int1)
    & etype(c167,int0)
    & fact(c167,real)
    & gener(c167,sp)
    & quant(c167,one)
    & refer(c167,det)
    & varia(c167,con)
    & sort(c151,d)
    & card(c151,int1)
    & etype(c151,int0)
    & fact(c151,real)
    & gener(c151,ge)
    & quant(c151,one)
    & refer(c151,refer_c)
    & varia(c151,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c155,d)
    & sort(c155,io)
    & card(c155,int1)
    & etype(c155,int0)
    & fact(c155,real)
    & gener(c155,sp)
    & quant(c155,one)
    & refer(c155,det)
    & varia(c155,con)
    & sort(c156,na)
    & card(c156,int1)
    & etype(c156,int0)
    & fact(c156,real)
    & gener(c156,sp)
    & quant(c156,one)
    & refer(c156,indet)
    & varia(c156,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c162,na)
    & card(c162,int1)
    & etype(c162,int0)
    & fact(c162,real)
    & gener(c162,sp)
    & quant(c162,one)
    & refer(c162,indet)
    & varia(c162,varia_c)
    & sort(c163,na)
    & card(c163,int1)
    & etype(c163,int0)
    & fact(c163,real)
    & gener(c163,sp)
    & quant(c163,one)
    & refer(c163,indet)
    & varia(c163,varia_c)
    & sort(c180,l)
    & card(c180,int1)
    & etype(c180,int0)
    & fact(c180,real)
    & gener(c180,sp)
    & quant(c180,one)
    & refer(c180,det)
    & varia(c180,con)
    & sort(schwarz_1_1,tq)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(dienstag__1_1,ta)
    & card(dienstag__1_1,int1)
    & etype(dienstag__1_1,int0)
    & fact(dienstag__1_1,real)
    & gener(dienstag__1_1,ge)
    & quant(dienstag__1_1,one)
    & refer(dienstag__1_1,refer_c)
    & varia(dienstag__1_1,varia_c)
    & sort(c177,d)
    & sort(c177,io)
    & card(c177,int1)
    & etype(c177,int0)
    & fact(c177,real)
    & gener(c177,sp)
    & quant(c177,one)
    & refer(c177,det)
    & varia(c177,con)
    & sort(c178,na)
    & card(c178,int1)
    & etype(c178,int0)
    & fact(c178,real)
    & gener(c178,sp)
    & quant(c178,one)
    & refer(c178,indet)
    & varia(c178,varia_c)
    & sort(hauptsstadt_1_1,d)
    & sort(hauptsstadt_1_1,io)
    & card(hauptsstadt_1_1,int1)
    & etype(hauptsstadt_1_1,int0)
    & fact(hauptsstadt_1_1,real)
    & gener(hauptsstadt_1_1,ge)
    & quant(hauptsstadt_1_1,one)
    & refer(hauptsstadt_1_1,refer_c)
    & varia(hauptsstadt_1_1,varia_c)
    & sort(pretoria_0,fe)
    & sort(c20,ad)
    & card(c20,int1)
    & etype(c20,int0)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,one)
    & refer(c20,det)
    & varia(c20,con)
    & sort(ausgelassen_1_1,ql)
    & sort(freude_1_1,ad)
    & card(freude_1_1,int1)
    & etype(freude_1_1,int0)
    & fact(freude_1_1,real)
    & gener(freude_1_1,ge)
    & quant(freude_1_1,one)
    & refer(freude_1_1,refer_c)
    & varia(freude_1_1,varia_c)
    & sort(c23,st)
    & fact(c23,real)
    & gener(c23,sp)
    & sort(equ_0,st)
    & fact(equ_0,real)
    & gener(equ_0,gener_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(mensch_1_1,ent)
    & card(mensch_1_1,card_c)
    & etype(mensch_1_1,etype_c)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,gener_c)
    & quant(mensch_1_1,quant_c)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
