%------------------------------------------------------------------------------
% File     : CSR116+40 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mn3_278_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.29 v7.5.0, 0.48 v7.4.0, 0.31 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.36 v6.4.0, 0.29 v6.3.0, 0.31 v6.2.0, 0.45 v6.1.0, 0.56 v6.0.0, 0.50 v5.5.0, 0.58 v5.4.0, 0.57 v5.3.0, 0.70 v5.2.0, 0.43 v5.0.0, 0.55 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10905 (   0 equ)
%            Maximal formula atoms :  192 (   1 avg)
%            Number of connectives :  716 (   0   ~;  18   |; 572   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  192 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-4 aty)
%            Number of functors    : 16653 (16653 usr;16652 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mn3_278,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mn3_278,hypothesis,
    ( sspe(c338,c451)
    & subs(c338,kr__366nung_1_2)
    & sub(c451,lebenswerk_1_1)
    & attr(c461,c462)
    & attr(c461,c463)
    & sub(c461,mensch_1_1)
    & sub(c462,eigenname_1_1)
    & val(c462,nelson_0)
    & sub(c463,familiename_1_1)
    & val(c463,mandela_0)
    & prop(c474,schwarz_1_1)
    & sub(c474,c476)
    & pmod(c476,erst_1_1,pr__344sident_1_1)
    & attch(c481,c474)
    & attr(c481,c482)
    & sub(c481,land_1_1)
    & sub(c482,name_1_1)
    & val(c482,s__374dafrika_0)
    & tupl_p4(c485,c338,c461,c474)
    & assoc(lebenswerk_1_1,leben_1_1)
    & sub(lebenswerk_1_1,artefakt_1_1)
    & sort(c338,as)
    & card(c338,int1)
    & etype(c338,int0)
    & fact(c338,real)
    & gener(c338,sp)
    & quant(c338,one)
    & refer(c338,det)
    & varia(c338,con)
    & sort(c451,d)
    & sort(c451,io)
    & card(c451,int1)
    & etype(c451,int0)
    & fact(c451,real)
    & gener(c451,sp)
    & quant(c451,one)
    & refer(c451,indet)
    & varia(c451,varia_c)
    & sort(kr__366nung_1_2,as)
    & card(kr__366nung_1_2,int1)
    & etype(kr__366nung_1_2,int0)
    & fact(kr__366nung_1_2,real)
    & gener(kr__366nung_1_2,ge)
    & quant(kr__366nung_1_2,one)
    & refer(kr__366nung_1_2,refer_c)
    & varia(kr__366nung_1_2,varia_c)
    & sort(lebenswerk_1_1,d)
    & sort(lebenswerk_1_1,io)
    & card(lebenswerk_1_1,int1)
    & etype(lebenswerk_1_1,int0)
    & fact(lebenswerk_1_1,real)
    & gener(lebenswerk_1_1,ge)
    & quant(lebenswerk_1_1,one)
    & refer(lebenswerk_1_1,refer_c)
    & varia(lebenswerk_1_1,varia_c)
    & sort(c461,d)
    & card(c461,int1)
    & etype(c461,int0)
    & fact(c461,real)
    & gener(c461,sp)
    & quant(c461,one)
    & refer(c461,det)
    & varia(c461,con)
    & sort(c462,na)
    & card(c462,int1)
    & etype(c462,int0)
    & fact(c462,real)
    & gener(c462,sp)
    & quant(c462,one)
    & refer(c462,indet)
    & varia(c462,varia_c)
    & sort(c463,na)
    & card(c463,int1)
    & etype(c463,int0)
    & fact(c463,real)
    & gener(c463,sp)
    & quant(c463,one)
    & refer(c463,indet)
    & varia(c463,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c474,d)
    & card(c474,int1)
    & etype(c474,int0)
    & fact(c474,real)
    & gener(c474,sp)
    & quant(c474,one)
    & refer(c474,det)
    & varia(c474,con)
    & sort(schwarz_1_1,tq)
    & sort(c476,d)
    & card(c476,int1)
    & etype(c476,int0)
    & fact(c476,real)
    & gener(c476,ge)
    & quant(c476,one)
    & refer(c476,refer_c)
    & varia(c476,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c481,d)
    & sort(c481,io)
    & card(c481,int1)
    & etype(c481,int0)
    & fact(c481,real)
    & gener(c481,sp)
    & quant(c481,one)
    & refer(c481,det)
    & varia(c481,con)
    & sort(c482,na)
    & card(c482,int1)
    & etype(c482,int0)
    & fact(c482,real)
    & gener(c482,sp)
    & quant(c482,one)
    & refer(c482,indet)
    & varia(c482,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c485,ent)
    & card(c485,card_c)
    & etype(c485,etype_c)
    & fact(c485,real)
    & gener(c485,gener_c)
    & quant(c485,quant_c)
    & refer(c485,refer_c)
    & varia(c485,varia_c)
    & sort(leben_1_1,ad)
    & card(leben_1_1,int1)
    & etype(leben_1_1,int0)
    & fact(leben_1_1,real)
    & gener(leben_1_1,ge)
    & quant(leben_1_1,one)
    & refer(leben_1_1,refer_c)
    & varia(leben_1_1,varia_c)
    & sort(artefakt_1_1,d)
    & sort(artefakt_1_1,io)
    & card(artefakt_1_1,int1)
    & etype(artefakt_1_1,int0)
    & fact(artefakt_1_1,real)
    & gener(artefakt_1_1,ge)
    & quant(artefakt_1_1,one)
    & refer(artefakt_1_1,refer_c)
    & varia(artefakt_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
