%------------------------------------------------------------------------------
% File     : CSR116+4 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1604_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10899 (   0 equ)
%            Maximal formula atoms :  187 (   1 avg)
%            Number of connectives :  710 (   0   ~;  18   |; 566   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  187 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16656 (16656 usr;16655 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1604,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1604,hypothesis,
    ( attr(c290,c291)
    & attr(c290,c292)
    & sub(c290,mensch_1_1)
    & sub(c291,eigenname_1_1)
    & val(c291,nelson_0)
    & sub(c292,familiename_1_1)
    & val(c292,mandela_0)
    & sub(c295,pr__344sident_1_1)
    & attch(c305,c295)
    & attr(c305,c306)
    & sub(c305,land_1_1)
    & sub(c306,name_1_1)
    & val(c306,s__374dafrika_0)
    & name(c316,zukunft_in_w__374rde_und_vertrauen_0)
    & pred(c322,landesleute_1_1)
    & sub(c324,gehaltsangabe_1_1)
    & tupl_p6(c451,c290,c295,c316,c322,c324)
    & assoc(landesleute_1_1,land_2_1)
    & sub(landesleute_1_1,leute_1_1)
    & sort(c290,d)
    & card(c290,int1)
    & etype(c290,int0)
    & fact(c290,real)
    & gener(c290,sp)
    & quant(c290,one)
    & refer(c290,det)
    & varia(c290,con)
    & sort(c291,na)
    & card(c291,int1)
    & etype(c291,int0)
    & fact(c291,real)
    & gener(c291,sp)
    & quant(c291,one)
    & refer(c291,indet)
    & varia(c291,varia_c)
    & sort(c292,na)
    & card(c292,int1)
    & etype(c292,int0)
    & fact(c292,real)
    & gener(c292,sp)
    & quant(c292,one)
    & refer(c292,indet)
    & varia(c292,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c295,d)
    & card(c295,int1)
    & etype(c295,int0)
    & fact(c295,real)
    & gener(c295,sp)
    & quant(c295,one)
    & refer(c295,det)
    & varia(c295,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c305,d)
    & sort(c305,io)
    & card(c305,int1)
    & etype(c305,int0)
    & fact(c305,real)
    & gener(c305,sp)
    & quant(c305,one)
    & refer(c305,det)
    & varia(c305,con)
    & sort(c306,na)
    & card(c306,int1)
    & etype(c306,int0)
    & fact(c306,real)
    & gener(c306,sp)
    & quant(c306,one)
    & refer(c306,indet)
    & varia(c306,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c316,o)
    & card(c316,int1)
    & etype(c316,int0)
    & fact(c316,real)
    & gener(c316,gener_c)
    & quant(c316,one)
    & refer(c316,refer_c)
    & varia(c316,varia_c)
    & sort(zukunft_in_w__374rde_und_vertrauen_0,fe)
    & sort(c322,d)
    & card(c322,cons(x_constant,cons(int1,nil)))
    & etype(c322,int1)
    & fact(c322,real)
    & gener(c322,gener_c)
    & quant(c322,all)
    & refer(c322,det)
    & varia(c322,con)
    & sort(landesleute_1_1,d)
    & card(landesleute_1_1,int1)
    & etype(landesleute_1_1,int0)
    & fact(landesleute_1_1,real)
    & gener(landesleute_1_1,ge)
    & quant(landesleute_1_1,one)
    & refer(landesleute_1_1,refer_c)
    & varia(landesleute_1_1,varia_c)
    & sort(c324,d)
    & sort(c324,io)
    & card(c324,int1)
    & etype(c324,int0)
    & fact(c324,real)
    & gener(c324,gener_c)
    & quant(c324,one)
    & refer(c324,refer_c)
    & varia(c324,varia_c)
    & sort(gehaltsangabe_1_1,d)
    & sort(gehaltsangabe_1_1,io)
    & card(gehaltsangabe_1_1,int1)
    & etype(gehaltsangabe_1_1,int0)
    & fact(gehaltsangabe_1_1,real)
    & gener(gehaltsangabe_1_1,ge)
    & quant(gehaltsangabe_1_1,one)
    & refer(gehaltsangabe_1_1,refer_c)
    & varia(gehaltsangabe_1_1,varia_c)
    & sort(c451,ent)
    & card(c451,card_c)
    & etype(c451,etype_c)
    & fact(c451,real)
    & gener(c451,gener_c)
    & quant(c451,quant_c)
    & refer(c451,refer_c)
    & varia(c451,varia_c)
    & sort(land_2_1,d)
    & card(land_2_1,int1)
    & etype(land_2_1,int0)
    & fact(land_2_1,real)
    & gener(land_2_1,ge)
    & quant(land_2_1,one)
    & refer(land_2_1,refer_c)
    & varia(land_2_1,varia_c)
    & sort(leute_1_1,d)
    & card(leute_1_1,int1)
    & etype(leute_1_1,int0)
    & fact(leute_1_1,real)
    & gener(leute_1_1,ge)
    & quant(leute_1_1,one)
    & refer(leute_1_1,refer_c)
    & varia(leute_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
