%------------------------------------------------------------------------------
% File     : CSR116+39 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_744_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.53 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.70 v4.1.0, 0.72 v4.0.1, 0.79 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11078 (   0 equ)
%            Maximal formula atoms :  365 (   1 avg)
%            Number of connectives :  889 (   0   ~;  18   |; 745   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  365 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-15 aty)
%            Number of functors    : 16674 (16674 usr;16673 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_744,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_744,hypothesis,
    ( tupl_p15(c10336,c9650,c9664,c9669,c9669,c9697,c9692,c9714,c9715,c9714,c9743,c9738,c9745,c9746,c9753)
    & sub(c9650,name_1_1)
    & attr(c9664,c9665)
    & sub(c9664,mensch_1_1)
    & sub(c9665,familiename_1_1)
    & val(c9665,mandela_0)
    & attr(c9669,c9679)
    & attr(c9669,c9680)
    & prop(c9669,s__374dafrikanisch_1_1)
    & sub(c9669,friedensnobelpreistr__344ger_1_1)
    & sub(c9669,pr__344sident_1_1)
    & sub(c9679,eigenname_1_1)
    & val(c9679,nelson_0)
    & sub(c9680,familiename_1_1)
    & val(c9680,mandela_0)
    & attr(c9692,c9705)
    & sub(c9692,mensch_1_1)
    & attr(c9697,c9698)
    & attr(c9697,c9699)
    & prop(c9697,s__374dafrikanisch_1_1)
    & sub(c9697,politikerin_1_1)
    & sub(c9698,eigenname_1_1)
    & val(c9698,winnie_0)
    & sub(c9699,familiename_1_1)
    & val(c9699,madikizela_0)
    & sub(c9705,familiename_1_1)
    & val(c9705,mandela_0)
    & attr(c9714,c9722)
    & prop(c9714,s__374dafrikanisch_1_1)
    & sub(c9714,advokat_1_1)
    & sub(c9714,mensch_1_1)
    & sub(c9715,makgatho_1_1)
    & sub(c9722,familiename_1_1)
    & val(c9722,mandela_0)
    & sub(c9738,provinz_1_1)
    & attr(c9743,c9744)
    & sub(c9743,gemeinde_1_1)
    & sub(c9744,name_1_1)
    & val(c9744,rom_0)
    & sub(c9745,gebiet_1_1)
    & sub(c9746,latium_1_1)
    & attr(c9753,c9754)
    & sub(c9753,land_1_1)
    & sub(c9754,name_1_1)
    & val(c9754,italien_0)
    & assoc(friedensnobelpreistr__344ger_1_1,friede_1_1)
    & sub(friedensnobelpreistr__344ger_1_1,nobelpreistraeger_1_1)
    & sort(c10336,ent)
    & card(c10336,card_c)
    & etype(c10336,etype_c)
    & fact(c10336,real)
    & gener(c10336,gener_c)
    & quant(c10336,quant_c)
    & refer(c10336,refer_c)
    & varia(c10336,varia_c)
    & sort(c9650,na)
    & card(c9650,int1)
    & etype(c9650,int0)
    & fact(c9650,real)
    & gener(c9650,sp)
    & quant(c9650,one)
    & refer(c9650,det)
    & varia(c9650,con)
    & sort(c9664,d)
    & card(c9664,int1)
    & etype(c9664,int0)
    & fact(c9664,real)
    & gener(c9664,sp)
    & quant(c9664,one)
    & refer(c9664,det)
    & varia(c9664,con)
    & sort(c9669,d)
    & card(c9669,int1)
    & etype(c9669,int0)
    & fact(c9669,real)
    & gener(c9669,sp)
    & quant(c9669,one)
    & refer(c9669,det)
    & varia(c9669,con)
    & sort(c9697,d)
    & card(c9697,int1)
    & etype(c9697,int0)
    & fact(c9697,real)
    & gener(c9697,sp)
    & quant(c9697,one)
    & refer(c9697,det)
    & varia(c9697,con)
    & sort(c9692,d)
    & card(c9692,int1)
    & etype(c9692,int0)
    & fact(c9692,real)
    & gener(c9692,sp)
    & quant(c9692,one)
    & refer(c9692,det)
    & varia(c9692,con)
    & sort(c9714,d)
    & card(c9714,int1)
    & etype(c9714,int0)
    & fact(c9714,real)
    & gener(c9714,sp)
    & quant(c9714,one)
    & refer(c9714,det)
    & varia(c9714,con)
    & sort(c9715,o)
    & card(c9715,int1)
    & etype(c9715,int0)
    & fact(c9715,real)
    & gener(c9715,gener_c)
    & quant(c9715,one)
    & refer(c9715,refer_c)
    & varia(c9715,varia_c)
    & sort(c9743,d)
    & sort(c9743,io)
    & card(c9743,int1)
    & etype(c9743,int0)
    & fact(c9743,real)
    & gener(c9743,sp)
    & quant(c9743,one)
    & refer(c9743,indet)
    & varia(c9743,varia_c)
    & sort(c9738,d)
    & sort(c9738,io)
    & card(c9738,int1)
    & etype(c9738,int0)
    & fact(c9738,real)
    & gener(c9738,sp)
    & quant(c9738,one)
    & refer(c9738,det)
    & varia(c9738,con)
    & sort(c9745,d)
    & card(c9745,int1)
    & etype(c9745,int0)
    & fact(c9745,real)
    & gener(c9745,gener_c)
    & quant(c9745,one)
    & refer(c9745,refer_c)
    & varia(c9745,varia_c)
    & sort(c9746,o)
    & card(c9746,int1)
    & etype(c9746,int0)
    & fact(c9746,real)
    & gener(c9746,gener_c)
    & quant(c9746,one)
    & refer(c9746,refer_c)
    & varia(c9746,varia_c)
    & sort(c9753,d)
    & sort(c9753,io)
    & card(c9753,int1)
    & etype(c9753,int0)
    & fact(c9753,real)
    & gener(c9753,sp)
    & quant(c9753,one)
    & refer(c9753,det)
    & varia(c9753,con)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(c9665,na)
    & card(c9665,int1)
    & etype(c9665,int0)
    & fact(c9665,real)
    & gener(c9665,sp)
    & quant(c9665,one)
    & refer(c9665,indet)
    & varia(c9665,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c9679,na)
    & card(c9679,int1)
    & etype(c9679,int0)
    & fact(c9679,real)
    & gener(c9679,sp)
    & quant(c9679,one)
    & refer(c9679,indet)
    & varia(c9679,varia_c)
    & sort(c9680,na)
    & card(c9680,int1)
    & etype(c9680,int0)
    & fact(c9680,real)
    & gener(c9680,sp)
    & quant(c9680,one)
    & refer(c9680,det)
    & varia(c9680,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(friedensnobelpreistr__344ger_1_1,d)
    & card(friedensnobelpreistr__344ger_1_1,int1)
    & etype(friedensnobelpreistr__344ger_1_1,int0)
    & fact(friedensnobelpreistr__344ger_1_1,real)
    & gener(friedensnobelpreistr__344ger_1_1,ge)
    & quant(friedensnobelpreistr__344ger_1_1,one)
    & refer(friedensnobelpreistr__344ger_1_1,refer_c)
    & varia(friedensnobelpreistr__344ger_1_1,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(c9705,na)
    & card(c9705,int1)
    & etype(c9705,int0)
    & fact(c9705,real)
    & gener(c9705,sp)
    & quant(c9705,one)
    & refer(c9705,indet)
    & varia(c9705,varia_c)
    & sort(c9698,na)
    & card(c9698,int1)
    & etype(c9698,int0)
    & fact(c9698,real)
    & gener(c9698,sp)
    & quant(c9698,one)
    & refer(c9698,indet)
    & varia(c9698,varia_c)
    & sort(c9699,na)
    & card(c9699,int1)
    & etype(c9699,int0)
    & fact(c9699,real)
    & gener(c9699,sp)
    & quant(c9699,one)
    & refer(c9699,indet)
    & varia(c9699,varia_c)
    & sort(politikerin_1_1,d)
    & card(politikerin_1_1,int1)
    & etype(politikerin_1_1,int0)
    & fact(politikerin_1_1,real)
    & gener(politikerin_1_1,ge)
    & quant(politikerin_1_1,one)
    & refer(politikerin_1_1,refer_c)
    & varia(politikerin_1_1,varia_c)
    & sort(winnie_0,fe)
    & sort(madikizela_0,fe)
    & sort(c9722,na)
    & card(c9722,int1)
    & etype(c9722,int0)
    & fact(c9722,real)
    & gener(c9722,sp)
    & quant(c9722,one)
    & refer(c9722,indet)
    & varia(c9722,varia_c)
    & sort(advokat_1_1,d)
    & card(advokat_1_1,int1)
    & etype(advokat_1_1,int0)
    & fact(advokat_1_1,real)
    & gener(advokat_1_1,ge)
    & quant(advokat_1_1,one)
    & refer(advokat_1_1,refer_c)
    & varia(advokat_1_1,varia_c)
    & sort(makgatho_1_1,o)
    & card(makgatho_1_1,int1)
    & etype(makgatho_1_1,int0)
    & fact(makgatho_1_1,real)
    & gener(makgatho_1_1,ge)
    & quant(makgatho_1_1,one)
    & refer(makgatho_1_1,refer_c)
    & varia(makgatho_1_1,varia_c)
    & sort(provinz_1_1,d)
    & sort(provinz_1_1,io)
    & card(provinz_1_1,int1)
    & etype(provinz_1_1,int0)
    & fact(provinz_1_1,real)
    & gener(provinz_1_1,ge)
    & quant(provinz_1_1,one)
    & refer(provinz_1_1,refer_c)
    & varia(provinz_1_1,varia_c)
    & sort(c9744,na)
    & card(c9744,int1)
    & etype(c9744,int0)
    & fact(c9744,real)
    & gener(c9744,sp)
    & quant(c9744,one)
    & refer(c9744,indet)
    & varia(c9744,varia_c)
    & sort(gemeinde_1_1,d)
    & sort(gemeinde_1_1,io)
    & card(gemeinde_1_1,int1)
    & etype(gemeinde_1_1,int0)
    & fact(gemeinde_1_1,real)
    & gener(gemeinde_1_1,ge)
    & quant(gemeinde_1_1,one)
    & refer(gemeinde_1_1,refer_c)
    & varia(gemeinde_1_1,varia_c)
    & sort(rom_0,fe)
    & sort(gebiet_1_1,d)
    & card(gebiet_1_1,int1)
    & etype(gebiet_1_1,int0)
    & fact(gebiet_1_1,real)
    & gener(gebiet_1_1,ge)
    & quant(gebiet_1_1,one)
    & refer(gebiet_1_1,refer_c)
    & varia(gebiet_1_1,varia_c)
    & sort(latium_1_1,o)
    & card(latium_1_1,int1)
    & etype(latium_1_1,int0)
    & fact(latium_1_1,real)
    & gener(latium_1_1,ge)
    & quant(latium_1_1,one)
    & refer(latium_1_1,refer_c)
    & varia(latium_1_1,varia_c)
    & sort(c9754,na)
    & card(c9754,int1)
    & etype(c9754,int0)
    & fact(c9754,real)
    & gener(c9754,sp)
    & quant(c9754,one)
    & refer(c9754,indet)
    & varia(c9754,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(italien_0,fe)
    & sort(friede_1_1,as)
    & sort(friede_1_1,io)
    & card(friede_1_1,int1)
    & etype(friede_1_1,int0)
    & fact(friede_1_1,real)
    & gener(friede_1_1,ge)
    & quant(friede_1_1,one)
    & refer(friede_1_1,refer_c)
    & varia(friede_1_1,varia_c)
    & sort(nobelpreistraeger_1_1,d)
    & card(nobelpreistraeger_1_1,int1)
    & etype(nobelpreistraeger_1_1,int0)
    & fact(nobelpreistraeger_1_1,real)
    & gener(nobelpreistraeger_1_1,ge)
    & quant(nobelpreistraeger_1_1,one)
    & refer(nobelpreistraeger_1_1,refer_c)
    & varia(nobelpreistraeger_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
