%------------------------------------------------------------------------------
% File     : CSR116+38 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_726_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.53 v9.0.0, 0.38 v8.2.0, 0.27 v8.1.0, 0.43 v7.5.0, 0.48 v7.4.0, 0.38 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.57 v6.4.0, 0.50 v6.3.0, 0.46 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.64 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10994 (   0 equ)
%            Maximal formula atoms :  282 (   1 avg)
%            Number of connectives :  805 (   0   ~;  18   |; 661   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  282 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16670 (16670 usr;16669 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_726,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_726,hypothesis,
    ( pred(c102,weizen__1_1)
    & subs(c120,wahl_1_1)
    & pmod(c128,erst_1_1,pr__344sident_1_1)
    & attch(c132,c120)
    & attr(c132,c133)
    & attr(c132,c134)
    & prop(c132,schwarz_1_1)
    & sub(c132,c128)
    & sub(c133,eigenname_1_1)
    & val(c133,nelson_0)
    & sub(c134,familiename_1_1)
    & val(c134,mandela_0)
    & pred(c142,sanktion_1_1)
    & prop(c169,erdweit_1_1)
    & sub(c169,l__344ndergemeinschaft_1_1)
    & sub(c176,land_1_1)
    & tupl_p10(c217,c78,c87,c97,c102,c120,c142,c145,c169,c176)
    & preds(c78,c81)
    & pmod(c81,erst_1_1,wahl_1_1)
    & attr(c87,c88)
    & attr(c87,c89)
    & sub(c88,monat_1_1)
    & val(c88,c86)
    & sub(c89,jahr__1_1)
    & val(c89,c85)
    & pred(c97,nicht_2_1)
    & assoc(l__344ndergemeinschaft_1_1,land_1_1)
    & sub(l__344ndergemeinschaft_1_1,gemeinschaft_1_1)
    & sort(c102,d)
    & card(c102,cons(x_constant,cons(int1,nil)))
    & etype(c102,int1)
    & fact(c102,real)
    & gener(c102,gener_c)
    & quant(c102,mult)
    & refer(c102,indet)
    & varia(c102,varia_c)
    & sort(weizen__1_1,d)
    & card(weizen__1_1,int1)
    & etype(weizen__1_1,int0)
    & fact(weizen__1_1,real)
    & gener(weizen__1_1,ge)
    & quant(weizen__1_1,one)
    & refer(weizen__1_1,refer_c)
    & varia(weizen__1_1,varia_c)
    & sort(c120,ad)
    & card(c120,int1)
    & etype(c120,int0)
    & fact(c120,real)
    & gener(c120,sp)
    & quant(c120,one)
    & refer(c120,det)
    & varia(c120,con)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c128,d)
    & card(c128,int1)
    & etype(c128,int0)
    & fact(c128,real)
    & gener(c128,ge)
    & quant(c128,one)
    & refer(c128,refer_c)
    & varia(c128,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c132,d)
    & card(c132,int1)
    & etype(c132,int0)
    & fact(c132,real)
    & gener(c132,sp)
    & quant(c132,one)
    & refer(c132,det)
    & varia(c132,con)
    & sort(c133,na)
    & card(c133,int1)
    & etype(c133,int0)
    & fact(c133,real)
    & gener(c133,sp)
    & quant(c133,one)
    & refer(c133,indet)
    & varia(c133,varia_c)
    & sort(c134,na)
    & card(c134,int1)
    & etype(c134,int0)
    & fact(c134,real)
    & gener(c134,sp)
    & quant(c134,one)
    & refer(c134,indet)
    & varia(c134,varia_c)
    & sort(schwarz_1_1,tq)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c142,ad)
    & sort(c142,io)
    & card(c142,cons(x_constant,cons(int1,nil)))
    & etype(c142,int1)
    & fact(c142,real)
    & gener(c142,gener_c)
    & quant(c142,most)
    & refer(c142,refer_c)
    & varia(c142,varia_c)
    & sort(sanktion_1_1,ad)
    & sort(sanktion_1_1,io)
    & card(sanktion_1_1,int1)
    & etype(sanktion_1_1,int0)
    & fact(sanktion_1_1,real)
    & gener(sanktion_1_1,ge)
    & quant(sanktion_1_1,one)
    & refer(sanktion_1_1,refer_c)
    & varia(sanktion_1_1,varia_c)
    & sort(c169,d)
    & card(c169,int1)
    & etype(c169,int1)
    & fact(c169,real)
    & gener(c169,sp)
    & quant(c169,one)
    & refer(c169,det)
    & varia(c169,con)
    & sort(erdweit_1_1,tq)
    & sort(l__344ndergemeinschaft_1_1,d)
    & card(l__344ndergemeinschaft_1_1,card_c)
    & etype(l__344ndergemeinschaft_1_1,int1)
    & fact(l__344ndergemeinschaft_1_1,real)
    & gener(l__344ndergemeinschaft_1_1,ge)
    & quant(l__344ndergemeinschaft_1_1,quant_c)
    & refer(l__344ndergemeinschaft_1_1,refer_c)
    & varia(l__344ndergemeinschaft_1_1,varia_c)
    & sort(c176,d)
    & sort(c176,io)
    & card(c176,int1)
    & etype(c176,int0)
    & fact(c176,real)
    & gener(c176,sp)
    & quant(c176,one)
    & refer(c176,det)
    & varia(c176,con)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(c217,ent)
    & card(c217,card_c)
    & etype(c217,etype_c)
    & fact(c217,real)
    & gener(c217,gener_c)
    & quant(c217,quant_c)
    & refer(c217,refer_c)
    & varia(c217,varia_c)
    & sort(c78,ad)
    & card(c78,cons(x_constant,cons(int1,nil)))
    & etype(c78,int1)
    & fact(c78,real)
    & gener(c78,sp)
    & quant(c78,mult)
    & refer(c78,det)
    & varia(c78,con)
    & sort(c87,t)
    & card(c87,int1)
    & etype(c87,int0)
    & fact(c87,real)
    & gener(c87,sp)
    & quant(c87,one)
    & refer(c87,det)
    & varia(c87,con)
    & sort(c97,o)
    & card(c97,cons(x_constant,cons(int1,nil)))
    & etype(c97,int1)
    & fact(c97,real)
    & gener(c97,gener_c)
    & quant(c97,mult)
    & refer(c97,indet)
    & varia(c97,varia_c)
    & sort(c145,o)
    & card(c145,int1)
    & etype(c145,int0)
    & fact(c145,real)
    & gener(c145,sp)
    & quant(c145,one)
    & refer(c145,det)
    & varia(c145,varia_c)
    & sort(c81,ad)
    & card(c81,int1)
    & etype(c81,int0)
    & fact(c81,real)
    & gener(c81,ge)
    & quant(c81,one)
    & refer(c81,refer_c)
    & varia(c81,varia_c)
    & sort(c88,me)
    & sort(c88,oa)
    & sort(c88,ta)
    & card(c88,card_c)
    & etype(c88,etype_c)
    & fact(c88,real)
    & gener(c88,sp)
    & quant(c88,quant_c)
    & refer(c88,refer_c)
    & varia(c88,varia_c)
    & sort(c89,me)
    & sort(c89,oa)
    & sort(c89,ta)
    & card(c89,card_c)
    & etype(c89,etype_c)
    & fact(c89,real)
    & gener(c89,sp)
    & quant(c89,quant_c)
    & refer(c89,refer_c)
    & varia(c89,varia_c)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c86,nu)
    & card(c86,int4)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c85,nu)
    & card(c85,int1994)
    & sort(nicht_2_1,o)
    & card(nicht_2_1,int1)
    & etype(nicht_2_1,int0)
    & fact(nicht_2_1,real)
    & gener(nicht_2_1,ge)
    & quant(nicht_2_1,one)
    & refer(nicht_2_1,refer_c)
    & varia(nicht_2_1,varia_c)
    & sort(gemeinschaft_1_1,d)
    & card(gemeinschaft_1_1,card_c)
    & etype(gemeinschaft_1_1,int1)
    & fact(gemeinschaft_1_1,real)
    & gener(gemeinschaft_1_1,ge)
    & quant(gemeinschaft_1_1,quant_c)
    & refer(gemeinschaft_1_1,refer_c)
    & varia(gemeinschaft_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
