%------------------------------------------------------------------------------
% File     : CSR116+37 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_720_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10867 (   0 equ)
%            Maximal formula atoms :  154 (   1 avg)
%            Number of connectives :  678 (   0   ~;  18   |; 534   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  154 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16655 (16655 usr;16654 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_720,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_720,hypothesis,
    ( pmod(c1,fr__374h_1_1,pr__344sident_1_1)
    & equ(c3,c588)
    & sub(c3,einh__366hepunkt_1_1)
    & subs(c588,auftritt_1_1)
    & attch(c598,c588)
    & attr(c598,c599)
    & attr(c598,c600)
    & prop(c598,s__374dafrikanisch_1_1)
    & sub(c598,c1)
    & sub(c599,eigenname_1_1)
    & val(c599,nelson_0)
    & sub(c600,familiename_1_1)
    & val(c600,mandela_0)
    & sub(c627,ansprache_1_1)
    & benf(c630,c598)
    & purp(c630,c627)
    & subs(c630,einladen_2_1)
    & arg1(c7,c3)
    & arg2(c7,c588)
    & subr(c7,equ_0)
    & assoc(einh__366hepunkt_1_1,ein_4_1)
    & sub(einh__366hepunkt_1_1,h__366hepunkt_1_1)
    & sort(c1,ent)
    & card(c1,card_c)
    & etype(c1,etype_c)
    & fact(c1,fact_c)
    & gener(c1,gener_c)
    & quant(c1,quant_c)
    & refer(c1,refer_c)
    & varia(c1,varia_c)
    & sort(fr__374h_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c3,io)
    & card(c3,int1)
    & etype(c3,int0)
    & fact(c3,real)
    & gener(c3,gener_c)
    & quant(c3,one)
    & refer(c3,refer_c)
    & varia(c3,varia_c)
    & sort(c588,ad)
    & card(c588,int1)
    & etype(c588,int0)
    & fact(c588,real)
    & gener(c588,sp)
    & quant(c588,one)
    & refer(c588,det)
    & varia(c588,con)
    & sort(einh__366hepunkt_1_1,io)
    & card(einh__366hepunkt_1_1,int1)
    & etype(einh__366hepunkt_1_1,int0)
    & fact(einh__366hepunkt_1_1,real)
    & gener(einh__366hepunkt_1_1,ge)
    & quant(einh__366hepunkt_1_1,one)
    & refer(einh__366hepunkt_1_1,refer_c)
    & varia(einh__366hepunkt_1_1,varia_c)
    & sort(auftritt_1_1,ad)
    & card(auftritt_1_1,int1)
    & etype(auftritt_1_1,int0)
    & fact(auftritt_1_1,real)
    & gener(auftritt_1_1,ge)
    & quant(auftritt_1_1,one)
    & refer(auftritt_1_1,refer_c)
    & varia(auftritt_1_1,varia_c)
    & sort(c598,d)
    & card(c598,int1)
    & etype(c598,int0)
    & fact(c598,real)
    & gener(c598,sp)
    & quant(c598,one)
    & refer(c598,det)
    & varia(c598,con)
    & sort(c599,na)
    & card(c599,int1)
    & etype(c599,int0)
    & fact(c599,real)
    & gener(c599,sp)
    & quant(c599,one)
    & refer(c599,indet)
    & varia(c599,varia_c)
    & sort(c600,na)
    & card(c600,int1)
    & etype(c600,int0)
    & fact(c600,real)
    & gener(c600,sp)
    & quant(c600,one)
    & refer(c600,indet)
    & varia(c600,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c627,ad)
    & sort(c627,io)
    & card(c627,int1)
    & etype(c627,int0)
    & fact(c627,real)
    & gener(c627,sp)
    & quant(c627,one)
    & refer(c627,indet)
    & varia(c627,varia_c)
    & sort(ansprache_1_1,ad)
    & sort(ansprache_1_1,io)
    & card(ansprache_1_1,int1)
    & etype(ansprache_1_1,int0)
    & fact(ansprache_1_1,real)
    & gener(ansprache_1_1,ge)
    & quant(ansprache_1_1,one)
    & refer(ansprache_1_1,refer_c)
    & varia(ansprache_1_1,varia_c)
    & sort(c630,da)
    & fact(c630,real)
    & gener(c630,sp)
    & sort(einladen_2_1,da)
    & fact(einladen_2_1,real)
    & gener(einladen_2_1,ge)
    & sort(c7,st)
    & fact(c7,real)
    & gener(c7,sp)
    & sort(equ_0,st)
    & fact(equ_0,real)
    & gener(equ_0,gener_c)
    & sort(ein_4_1,nu)
    & card(ein_4_1,int1)
    & sort(h__366hepunkt_1_1,io)
    & card(h__366hepunkt_1_1,int1)
    & etype(h__366hepunkt_1_1,int0)
    & fact(h__366hepunkt_1_1,real)
    & gener(h__366hepunkt_1_1,ge)
    & quant(h__366hepunkt_1_1,one)
    & refer(h__366hepunkt_1_1,refer_c)
    & varia(h__366hepunkt_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
