%------------------------------------------------------------------------------
% File     : CSR116+36 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_716_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.53 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.71 v5.4.0, 0.70 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.65 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10924 (   0 equ)
%            Maximal formula atoms :  211 (   1 avg)
%            Number of connectives :  735 (   0   ~;  18   |; 591   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  211 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_716,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_716,hypothesis,
    ( sub(c11,hauptagentur_1_1)
    & attch(c15,c11)
    & loc(c15,c32)
    & prop(c15,s__374dafrikanisch_1_1)
    & sub(c15,pr__344sident_1_1)
    & attr(c21,c22)
    & sub(c21,stadt__1_1)
    & sub(c22,name_1_1)
    & val(c22,kapstadt_0)
    & agt(c26,c5)
    & init(c26,c34)
    & obj(c26,c11)
    & rslt(c26,c33)
    & subs(c26,umbenennen_1_1)
    & attr(c28,c29)
    & sub(c28,stadt__1_1)
    & sub(c29,name_1_1)
    & val(c29,genadendal_0)
    & in(c32,c21)
    & arg1(c33,c11)
    & arg2(c33,c28)
    & subr(c33,name_0)
    & arg1(c34,c11)
    & subr(c34,name_0)
    & attr(c5,c6)
    & attr(c5,c7)
    & sub(c5,mensch_1_1)
    & sub(c6,eigenname_1_1)
    & val(c6,nelson_0)
    & sub(c7,familiename_1_1)
    & val(c7,mandela_0)
    & assoc(hauptagentur_1_1,haupt_1_1)
    & sub(hauptagentur_1_1,b__374ro_1_1)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(hauptagentur_1_1,d)
    & sort(hauptagentur_1_1,io)
    & card(hauptagentur_1_1,int1)
    & etype(hauptagentur_1_1,int0)
    & fact(hauptagentur_1_1,real)
    & gener(hauptagentur_1_1,ge)
    & quant(hauptagentur_1_1,one)
    & refer(hauptagentur_1_1,refer_c)
    & varia(hauptagentur_1_1,varia_c)
    & sort(c15,d)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,det)
    & varia(c15,con)
    & sort(c32,l)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,one)
    & refer(c32,det)
    & varia(c32,con)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c21,d)
    & sort(c21,io)
    & card(c21,int1)
    & etype(c21,int0)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,one)
    & refer(c21,det)
    & varia(c21,con)
    & sort(c22,na)
    & card(c22,int1)
    & etype(c22,int0)
    & fact(c22,real)
    & gener(c22,sp)
    & quant(c22,one)
    & refer(c22,indet)
    & varia(c22,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(kapstadt_0,fe)
    & sort(c26,da)
    & fact(c26,real)
    & gener(c26,sp)
    & sort(c5,d)
    & card(c5,int1)
    & etype(c5,int0)
    & fact(c5,real)
    & gener(c5,sp)
    & quant(c5,one)
    & refer(c5,det)
    & varia(c5,con)
    & sort(c34,st)
    & fact(c34,real)
    & gener(c34,sp)
    & sort(c33,st)
    & fact(c33,real)
    & gener(c33,sp)
    & sort(umbenennen_1_1,da)
    & fact(umbenennen_1_1,real)
    & gener(umbenennen_1_1,ge)
    & sort(c28,d)
    & sort(c28,io)
    & card(c28,int1)
    & etype(c28,int0)
    & fact(c28,real)
    & gener(c28,sp)
    & quant(c28,one)
    & refer(c28,det)
    & varia(c28,con)
    & sort(c29,na)
    & card(c29,int1)
    & etype(c29,int0)
    & fact(c29,real)
    & gener(c29,sp)
    & quant(c29,one)
    & refer(c29,indet)
    & varia(c29,varia_c)
    & sort(genadendal_0,fe)
    & sort(name_0,st)
    & fact(name_0,real)
    & gener(name_0,gener_c)
    & sort(c6,na)
    & card(c6,int1)
    & etype(c6,int0)
    & fact(c6,real)
    & gener(c6,sp)
    & quant(c6,one)
    & refer(c6,indet)
    & varia(c6,varia_c)
    & sort(c7,na)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,indet)
    & varia(c7,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(haupt_1_1,d)
    & card(haupt_1_1,int1)
    & etype(haupt_1_1,int0)
    & fact(haupt_1_1,real)
    & gener(haupt_1_1,ge)
    & quant(haupt_1_1,one)
    & refer(haupt_1_1,refer_c)
    & varia(haupt_1_1,varia_c)
    & sort(b__374ro_1_1,d)
    & sort(b__374ro_1_1,io)
    & card(b__374ro_1_1,int1)
    & etype(b__374ro_1_1,int0)
    & fact(b__374ro_1_1,real)
    & gener(b__374ro_1_1,ge)
    & quant(b__374ro_1_1,one)
    & refer(b__374ro_1_1,refer_c)
    & varia(b__374ro_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
