%------------------------------------------------------------------------------
% File     : CSR116+35 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_714_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.71 v7.2.0, 0.67 v7.1.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.70 v5.2.0, 0.50 v5.0.0, 0.65 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10873 (   0 equ)
%            Maximal formula atoms :  160 (   1 avg)
%            Number of connectives :  684 (   0   ~;  18   |; 540   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  160 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_714,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_714,hypothesis,
    ( assoc(amtszeit__1_1,amt_1_2)
    & sub(amtszeit__1_1,zeit_1_1)
    & attch(c16,c7)
    & attr(c16,c17)
    & attr(c16,c18)
    & prop(c16,s__374dafrikanisch_1_1)
    & sub(c16,pr__344sident_1_1)
    & sub(c17,eigenname_1_1)
    & val(c17,nelson_0)
    & sub(c18,familiename_1_1)
    & val(c18,mandela_0)
    & pred(c24,mehrere_2_1)
    & pred(c34,mensch_1_1)
    & just(c38,c40)
    & sub(c38,geisterglaube_1_1)
    & aff(c40,c24)
    & benf(c40,c34)
    & subs(c40,abmurksen_1_1)
    & temp(c40,c7)
    & sub(c7,amtszeit__1_1)
    & sort(amtszeit__1_1,ta)
    & card(amtszeit__1_1,int1)
    & etype(amtszeit__1_1,int0)
    & fact(amtszeit__1_1,real)
    & gener(amtszeit__1_1,ge)
    & quant(amtszeit__1_1,one)
    & refer(amtszeit__1_1,refer_c)
    & varia(amtszeit__1_1,varia_c)
    & sort(amt_1_2,ad)
    & sort(amt_1_2,io)
    & card(amt_1_2,int1)
    & etype(amt_1_2,int0)
    & fact(amt_1_2,real)
    & gener(amt_1_2,ge)
    & quant(amt_1_2,one)
    & refer(amt_1_2,refer_c)
    & varia(amt_1_2,varia_c)
    & sort(zeit_1_1,ta)
    & card(zeit_1_1,int1)
    & etype(zeit_1_1,int0)
    & fact(zeit_1_1,real)
    & gener(zeit_1_1,ge)
    & quant(zeit_1_1,one)
    & refer(zeit_1_1,refer_c)
    & varia(zeit_1_1,varia_c)
    & sort(c16,d)
    & card(c16,int1)
    & etype(c16,int0)
    & fact(c16,real)
    & gener(c16,sp)
    & quant(c16,one)
    & refer(c16,det)
    & varia(c16,con)
    & sort(c7,ta)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,det)
    & varia(c7,con)
    & sort(c17,na)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,indet)
    & varia(c17,varia_c)
    & sort(c18,na)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,indet)
    & varia(c18,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c24,o)
    & card(c24,cons(x_constant,cons(int1,nil)))
    & etype(c24,int1)
    & etype(c24,int2)
    & etype(c24,int3)
    & fact(c24,real)
    & gener(c24,sp)
    & quant(c24,mult)
    & refer(c24,indet)
    & varia(c24,varia_c)
    & sort(mehrere_2_1,o)
    & card(mehrere_2_1,cons(x_constant,cons(int1,nil)))
    & etype(mehrere_2_1,int1)
    & fact(mehrere_2_1,real)
    & gener(mehrere_2_1,gener_c)
    & quant(mehrere_2_1,mult)
    & refer(mehrere_2_1,refer_c)
    & varia(mehrere_2_1,varia_c)
    & sort(c34,d)
    & card(c34,int100)
    & etype(c34,int1)
    & fact(c34,real)
    & gener(c34,sp)
    & quant(c34,nfquant)
    & refer(c34,indet)
    & varia(c34,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(c38,o)
    & card(c38,int1)
    & etype(c38,int0)
    & fact(c38,real)
    & gener(c38,gener_c)
    & quant(c38,one)
    & refer(c38,refer_c)
    & varia(c38,varia_c)
    & sort(c40,da)
    & fact(c40,real)
    & gener(c40,sp)
    & sort(geisterglaube_1_1,o)
    & card(geisterglaube_1_1,int1)
    & etype(geisterglaube_1_1,int0)
    & fact(geisterglaube_1_1,real)
    & gener(geisterglaube_1_1,ge)
    & quant(geisterglaube_1_1,one)
    & refer(geisterglaube_1_1,refer_c)
    & varia(geisterglaube_1_1,varia_c)
    & sort(abmurksen_1_1,da)
    & fact(abmurksen_1_1,real)
    & gener(abmurksen_1_1,ge) ) ).

%------------------------------------------------------------------------------
