%------------------------------------------------------------------------------
% File     : CSR116+34 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_712_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.35 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10976 (   0 equ)
%            Maximal formula atoms :  264 (   1 avg)
%            Number of connectives :  787 (   0   ~;  18   |; 643   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  264 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-8 aty)
%            Number of functors    : 16664 (16664 usr;16663 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_712,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_712,hypothesis,
    ( attr(c177,c178)
    & sub(c177,mensch_1_1)
    & sub(c178,familiename_1_1)
    & val(c178,samora_0)
    & attch(c181,c183)
    & attr(c181,c182)
    & sub(c181,mensch_1_1)
    & sub(c182,familiename_1_1)
    & val(c182,machel_0)
    & sub(c183,c186)
    & sub(c185,gra__347a_1_1)
    & pmod(c186,zweit_1_1,frau_1_1)
    & attr(c193,c194)
    & sub(c193,mensch_1_1)
    & sub(c194,familiename_1_1)
    & val(c194,machel_0)
    & attr(c198,c199)
    & sub(c199,jahr__1_1)
    & val(c199,c195)
    & sub(c200,pr__344sident_1_1)
    & attch(c206,c210)
    & attr(c206,c207)
    & sub(c206,land_1_1)
    & sub(c207,name_1_1)
    & val(c207,s__374dafrika_0)
    & attr(c210,c211)
    & attr(c210,c212)
    & sub(c210,mensch_1_1)
    & sub(c211,eigenname_1_1)
    & val(c211,nelson_0)
    & sub(c212,familiename_1_1)
    & val(c212,mandela_0)
    & tupl_p8(c275,c177,c183,c185,c193,c198,c200,c210)
    & sort(c177,d)
    & card(c177,int1)
    & etype(c177,int0)
    & fact(c177,real)
    & gener(c177,sp)
    & quant(c177,one)
    & refer(c177,det)
    & varia(c177,con)
    & sort(c178,na)
    & card(c178,int1)
    & etype(c178,int0)
    & fact(c178,real)
    & gener(c178,sp)
    & quant(c178,one)
    & refer(c178,indet)
    & varia(c178,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(samora_0,fe)
    & sort(c181,d)
    & card(c181,int1)
    & etype(c181,int0)
    & fact(c181,real)
    & gener(c181,sp)
    & quant(c181,one)
    & refer(c181,det)
    & varia(c181,con)
    & sort(c183,d)
    & card(c183,int1)
    & etype(c183,int0)
    & fact(c183,real)
    & gener(c183,sp)
    & quant(c183,one)
    & refer(c183,det)
    & varia(c183,varia_c)
    & sort(c182,na)
    & card(c182,int1)
    & etype(c182,int0)
    & fact(c182,real)
    & gener(c182,sp)
    & quant(c182,one)
    & refer(c182,indet)
    & varia(c182,varia_c)
    & sort(machel_0,fe)
    & sort(c186,d)
    & card(c186,int1)
    & etype(c186,int0)
    & fact(c186,real)
    & gener(c186,ge)
    & quant(c186,one)
    & refer(c186,refer_c)
    & varia(c186,varia_c)
    & sort(c185,o)
    & card(c185,int1)
    & etype(c185,int0)
    & fact(c185,real)
    & gener(c185,gener_c)
    & quant(c185,one)
    & refer(c185,refer_c)
    & varia(c185,varia_c)
    & sort(gra__347a_1_1,o)
    & card(gra__347a_1_1,int1)
    & etype(gra__347a_1_1,int0)
    & fact(gra__347a_1_1,real)
    & gener(gra__347a_1_1,ge)
    & quant(gra__347a_1_1,one)
    & refer(gra__347a_1_1,refer_c)
    & varia(gra__347a_1_1,varia_c)
    & sort(zweit_1_1,oq)
    & card(zweit_1_1,int2)
    & sort(frau_1_1,d)
    & card(frau_1_1,int1)
    & etype(frau_1_1,int0)
    & fact(frau_1_1,real)
    & gener(frau_1_1,ge)
    & quant(frau_1_1,one)
    & refer(frau_1_1,refer_c)
    & varia(frau_1_1,varia_c)
    & sort(c193,d)
    & card(c193,int1)
    & etype(c193,int0)
    & fact(c193,real)
    & gener(c193,sp)
    & quant(c193,one)
    & refer(c193,det)
    & varia(c193,con)
    & sort(c194,na)
    & card(c194,int1)
    & etype(c194,int0)
    & fact(c194,real)
    & gener(c194,sp)
    & quant(c194,one)
    & refer(c194,indet)
    & varia(c194,varia_c)
    & sort(c198,t)
    & card(c198,int1)
    & etype(c198,int0)
    & fact(c198,real)
    & gener(c198,sp)
    & quant(c198,one)
    & refer(c198,det)
    & varia(c198,con)
    & sort(c199,me)
    & sort(c199,oa)
    & sort(c199,ta)
    & card(c199,card_c)
    & etype(c199,etype_c)
    & fact(c199,real)
    & gener(c199,sp)
    & quant(c199,quant_c)
    & refer(c199,refer_c)
    & varia(c199,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c195,nu)
    & card(c195,int1998)
    & sort(c200,d)
    & card(c200,int1)
    & etype(c200,int0)
    & fact(c200,real)
    & gener(c200,sp)
    & quant(c200,one)
    & refer(c200,det)
    & varia(c200,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c206,d)
    & sort(c206,io)
    & card(c206,int1)
    & etype(c206,int0)
    & fact(c206,real)
    & gener(c206,sp)
    & quant(c206,one)
    & refer(c206,det)
    & varia(c206,con)
    & sort(c210,d)
    & card(c210,int1)
    & etype(c210,int0)
    & fact(c210,real)
    & gener(c210,sp)
    & quant(c210,one)
    & refer(c210,det)
    & varia(c210,con)
    & sort(c207,na)
    & card(c207,int1)
    & etype(c207,int0)
    & fact(c207,real)
    & gener(c207,sp)
    & quant(c207,one)
    & refer(c207,indet)
    & varia(c207,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c211,na)
    & card(c211,int1)
    & etype(c211,int0)
    & fact(c211,real)
    & gener(c211,sp)
    & quant(c211,one)
    & refer(c211,indet)
    & varia(c211,varia_c)
    & sort(c212,na)
    & card(c212,int1)
    & etype(c212,int0)
    & fact(c212,real)
    & gener(c212,sp)
    & quant(c212,one)
    & refer(c212,indet)
    & varia(c212,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(c275,ent)
    & card(c275,card_c)
    & etype(c275,etype_c)
    & fact(c275,real)
    & gener(c275,gener_c)
    & quant(c275,quant_c)
    & refer(c275,refer_c)
    & varia(c275,varia_c) ) ).

%------------------------------------------------------------------------------
