%------------------------------------------------------------------------------
% File     : CSR116+33 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_676_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.29 v7.4.0, 0.19 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.52 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.61 v5.2.0, 0.43 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10946 (   0 equ)
%            Maximal formula atoms :  231 (   1 avg)
%            Number of connectives :  757 (   0   ~;  18   |; 613   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  231 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16660 (16660 usr;16659 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_676,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & rslt(X8,X3)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & subs(X8,w__344hlen_1_2)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_676,hypothesis,
    ( attr(c13,c14)
    & sub(c13,einrichtung_1_2)
    & sub(c14,name_1_1)
    & val(c14,anc_0)
    & loc(c20,c54)
    & preds(c20,c22)
    & prop(c20,demokratisch__1_1)
    & pmod(c22,erst_1_1,wahl_1_1)
    & attr(c28,c29)
    & sub(c28,land_1_1)
    & sub(c29,name_1_1)
    & val(c29,s__374dafrika_0)
    & attr(c33,c34)
    & attr(c33,c35)
    & sub(c33,mensch_1_1)
    & sub(c34,eigenname_1_1)
    & val(c34,nelson_0)
    & sub(c35,familiename_1_1)
    & val(c35,mandela_0)
    & sub(c38,pr__344sident_1_1)
    & obj(c43,c33)
    & rslt(c43,c55)
    & subs(c43,w__344hlen_1_2)
    & in(c54,c28)
    & arg1(c55,c33)
    & arg2(c55,c38)
    & subr(c55,rprs_0)
    & ante(c7,c43)
    & circ(c7,c20)
    & exp(c7,c13)
    & subs(c7,gewinn_2_1)
    & assoc(demokratisch__1_1,demokratie__1_1)
    & sort(c13,d)
    & sort(c13,io)
    & card(c13,int1)
    & etype(c13,int1)
    & fact(c13,real)
    & gener(c13,sp)
    & quant(c13,one)
    & refer(c13,det)
    & varia(c13,con)
    & sort(c14,na)
    & card(c14,int1)
    & etype(c14,int0)
    & fact(c14,real)
    & gener(c14,sp)
    & quant(c14,one)
    & refer(c14,indet)
    & varia(c14,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(anc_0,fe)
    & sort(c20,ad)
    & card(c20,cons(x_constant,cons(int1,nil)))
    & etype(c20,int1)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,mult)
    & refer(c20,det)
    & varia(c20,con)
    & sort(c54,l)
    & card(c54,int1)
    & etype(c54,int0)
    & fact(c54,real)
    & gener(c54,sp)
    & quant(c54,one)
    & refer(c54,det)
    & varia(c54,con)
    & sort(c22,ad)
    & card(c22,int1)
    & etype(c22,int0)
    & fact(c22,real)
    & gener(c22,ge)
    & quant(c22,one)
    & refer(c22,refer_c)
    & varia(c22,varia_c)
    & sort(demokratisch__1_1,nq)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(c28,d)
    & sort(c28,io)
    & card(c28,int1)
    & etype(c28,int0)
    & fact(c28,real)
    & gener(c28,sp)
    & quant(c28,one)
    & refer(c28,det)
    & varia(c28,con)
    & sort(c29,na)
    & card(c29,int1)
    & etype(c29,int0)
    & fact(c29,real)
    & gener(c29,sp)
    & quant(c29,one)
    & refer(c29,indet)
    & varia(c29,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c33,d)
    & card(c33,int1)
    & etype(c33,int0)
    & fact(c33,real)
    & gener(c33,sp)
    & quant(c33,one)
    & refer(c33,det)
    & varia(c33,con)
    & sort(c34,na)
    & card(c34,int1)
    & etype(c34,int0)
    & fact(c34,real)
    & gener(c34,sp)
    & quant(c34,one)
    & refer(c34,indet)
    & varia(c34,varia_c)
    & sort(c35,na)
    & card(c35,int1)
    & etype(c35,int0)
    & fact(c35,real)
    & gener(c35,sp)
    & quant(c35,one)
    & refer(c35,indet)
    & varia(c35,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c38,d)
    & card(c38,int1)
    & etype(c38,int0)
    & fact(c38,real)
    & gener(c38,sp)
    & quant(c38,one)
    & refer(c38,det)
    & varia(c38,con)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c43,da)
    & fact(c43,real)
    & gener(c43,sp)
    & sort(c55,st)
    & fact(c55,real)
    & gener(c55,sp)
    & sort(w__344hlen_1_2,da)
    & fact(w__344hlen_1_2,real)
    & gener(w__344hlen_1_2,ge)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(c7,ad)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,det)
    & varia(c7,con)
    & sort(gewinn_2_1,ad)
    & card(gewinn_2_1,int1)
    & etype(gewinn_2_1,int0)
    & fact(gewinn_2_1,real)
    & gener(gewinn_2_1,ge)
    & quant(gewinn_2_1,one)
    & refer(gewinn_2_1,refer_c)
    & varia(gewinn_2_1,varia_c)
    & sort(demokratie__1_1,io)
    & card(demokratie__1_1,int1)
    & etype(demokratie__1_1,int0)
    & fact(demokratie__1_1,real)
    & gener(demokratie__1_1,ge)
    & quant(demokratie__1_1,one)
    & refer(demokratie__1_1,refer_c)
    & varia(demokratie__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
