%------------------------------------------------------------------------------
% File     : CSR116+31 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_wp_673_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.25 v9.1.0, 0.20 v9.0.0, 0.19 v8.2.0, 0.13 v8.1.0, 0.14 v7.5.0, 0.33 v7.4.0, 0.19 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.21 v6.4.0, 0.14 v6.3.0, 0.23 v6.2.0, 0.27 v6.1.0, 0.48 v6.0.0, 0.50 v5.5.0, 0.54 v5.4.0, 0.52 v5.3.0, 0.57 v5.2.0, 0.36 v5.0.0, 0.45 v4.1.0, 0.56 v4.0.1, 0.47 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10933 (   0 equ)
%            Maximal formula atoms :  217 (   1 avg)
%            Number of connectives :  744 (   0   ~;  18   |; 600   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  217 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16658 (16658 usr;16657 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_wp_673,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & rslt(X7,X3)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & subs(X7,w__344hlen_1_2)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_wp_673,hypothesis,
    ( attch(c11,c7)
    & sub(c11,apartheid_1_1)
    & attr(c18,c19)
    & attr(c18,c20)
    & sub(c18,mensch_1_1)
    & sub(c19,eigenname_1_1)
    & val(c19,nelson_0)
    & sub(c20,familiename_1_1)
    & val(c20,mandela_0)
    & prop(c26,schwarz_1_1)
    & sub(c26,c28)
    & pmod(c28,erst_1_1,pr__344sident_1_1)
    & obj(c34,c18)
    & rslt(c34,c55)
    & subs(c34,w__344hlen_1_2)
    & temp(c34,c52)
    & attch(c48,c26)
    & attr(c48,c49)
    & sub(c48,land_1_1)
    & sub(c49,name_1_1)
    & val(c49,s__374dafrika_0)
    & attr(c52,c53)
    & sub(c53,jahr__1_1)
    & val(c53,c50)
    & arg1(c55,c18)
    & arg2(c55,c26)
    & subr(c55,rprs_0)
    & ante(c7,c34)
    & sub(c7,abschlu__337_1_1)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c7,ad)
    & sort(c7,io)
    & card(c7,int1)
    & etype(c7,int0)
    & fact(c7,real)
    & gener(c7,sp)
    & quant(c7,one)
    & refer(c7,det)
    & varia(c7,con)
    & sort(apartheid_1_1,io)
    & card(apartheid_1_1,int1)
    & etype(apartheid_1_1,int0)
    & fact(apartheid_1_1,real)
    & gener(apartheid_1_1,ge)
    & quant(apartheid_1_1,one)
    & refer(apartheid_1_1,refer_c)
    & varia(apartheid_1_1,varia_c)
    & sort(c18,d)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,det)
    & varia(c18,con)
    & sort(c19,na)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,indet)
    & varia(c19,varia_c)
    & sort(c20,na)
    & card(c20,int1)
    & etype(c20,int0)
    & fact(c20,real)
    & gener(c20,sp)
    & quant(c20,one)
    & refer(c20,indet)
    & varia(c20,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c26,d)
    & card(c26,int1)
    & etype(c26,int0)
    & fact(c26,real)
    & gener(c26,sp)
    & quant(c26,one)
    & refer(c26,det)
    & varia(c26,con)
    & sort(schwarz_1_1,tq)
    & sort(c28,d)
    & card(c28,int1)
    & etype(c28,int0)
    & fact(c28,real)
    & gener(c28,ge)
    & quant(c28,one)
    & refer(c28,refer_c)
    & varia(c28,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c34,da)
    & fact(c34,real)
    & gener(c34,sp)
    & sort(c55,st)
    & fact(c55,real)
    & gener(c55,sp)
    & sort(w__344hlen_1_2,da)
    & fact(w__344hlen_1_2,real)
    & gener(w__344hlen_1_2,ge)
    & sort(c52,t)
    & card(c52,int1)
    & etype(c52,int0)
    & fact(c52,real)
    & gener(c52,sp)
    & quant(c52,one)
    & refer(c52,det)
    & varia(c52,con)
    & sort(c48,d)
    & sort(c48,io)
    & card(c48,int1)
    & etype(c48,int0)
    & fact(c48,real)
    & gener(c48,sp)
    & quant(c48,one)
    & refer(c48,det)
    & varia(c48,con)
    & sort(c49,na)
    & card(c49,int1)
    & etype(c49,int0)
    & fact(c49,real)
    & gener(c49,sp)
    & quant(c49,one)
    & refer(c49,indet)
    & varia(c49,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c53,me)
    & sort(c53,oa)
    & sort(c53,ta)
    & card(c53,card_c)
    & etype(c53,etype_c)
    & fact(c53,real)
    & gener(c53,sp)
    & quant(c53,quant_c)
    & refer(c53,refer_c)
    & varia(c53,varia_c)
    & sort(jahr__1_1,me)
    & sort(jahr__1_1,oa)
    & sort(jahr__1_1,ta)
    & card(jahr__1_1,card_c)
    & etype(jahr__1_1,etype_c)
    & fact(jahr__1_1,real)
    & gener(jahr__1_1,ge)
    & quant(jahr__1_1,quant_c)
    & refer(jahr__1_1,refer_c)
    & varia(jahr__1_1,varia_c)
    & sort(c50,nu)
    & card(c50,int1995)
    & sort(rprs_0,st)
    & fact(rprs_0,real)
    & gener(rprs_0,gener_c)
    & sort(abschlu__337_1_1,ad)
    & sort(abschlu__337_1_1,io)
    & card(abschlu__337_1_1,int1)
    & etype(abschlu__337_1_1,int0)
    & fact(abschlu__337_1_1,real)
    & gener(abschlu__337_1_1,ge)
    & quant(abschlu__337_1_1,one)
    & refer(abschlu__337_1_1,refer_c)
    & varia(abschlu__337_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
