%------------------------------------------------------------------------------
% File     : CSR116+3 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1596_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.53 v9.0.0, 0.38 v8.2.0, 0.33 v8.1.0, 0.43 v7.5.0, 0.52 v7.4.0, 0.44 v7.3.0, 0.43 v7.2.0, 0.33 v7.1.0, 0.25 v7.0.0, 0.50 v6.4.0, 0.57 v6.3.0, 0.62 v6.2.0, 0.82 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.61 v4.0.1, 0.63 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11031 (   0 equ)
%            Maximal formula atoms :  317 (   1 avg)
%            Number of connectives :  842 (   0   ~;  18   |; 698   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  317 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16671 (16671 usr;16670 con; 0-2 aty)
%            Number of variables   :  477 ( 405   !;  72   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1596,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8] :
      ( pmod(X8,erst_1_1,pr__344sident_1_1)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X5,X6)
      & obj(X7,X0)
      & prop(X4,schwarz_1_1)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X8)
      & sub(X6,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X6,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1596,hypothesis,
    ( attr(c11,c12)
    & attr(c11,c210)
    & sub(c11,hauptsstadt_1_1)
    & sub(c11,stadt__1_1)
    & sub(c12,name_1_1)
    & val(c12,pretoria_0)
    & attr(c17,c18)
    & attr(c17,c19)
    & sub(c18,tag_1_1)
    & val(c18,c15)
    & pmod(c183,erst_1_1,pr__344sident_1_1)
    & attch(c187,c193)
    & attr(c187,c188)
    & sub(c187,land_1_1)
    & sub(c188,name_1_1)
    & val(c188,s__374dafrika_0)
    & sub(c19,monat_1_1)
    & val(c19,c16)
    & attr(c193,c194)
    & attr(c193,c195)
    & loc(c193,c212)
    & prop(c193,schwarz_1_1)
    & sub(c193,c183)
    & sub(c194,eigenname_1_1)
    & val(c194,nelson_0)
    & sub(c195,familiename_1_1)
    & val(c195,mandela_0)
    & sub(c199,dienstag__1_1)
    & sub(c210,name_1_1)
    & val(c210,pretoria_0)
    & in(c212,c11)
    & tupl(c31,c11,c17)
    & equ(c43,c43)
    & obj(c43,c193)
    & prop(c43,afrikanisch__1_1)
    & subs(c43,feier__1_1)
    & subs(c43,vereidigung_1_1)
    & temp(c43,c199)
    & attch(c52,c43)
    & prop(c52,ausgelassen_1_1)
    & subs(c52,freude_1_1)
    & arg1(c55,c43)
    & arg2(c55,c43)
    & subr(c55,equ_0)
    & sub(hauptsstadt_1_1,stadt__1_1)
    & sort(c11,d)
    & sort(c11,io)
    & card(c11,int1)
    & etype(c11,int0)
    & fact(c11,real)
    & gener(c11,sp)
    & quant(c11,one)
    & refer(c11,det)
    & varia(c11,con)
    & sort(c12,na)
    & card(c12,int1)
    & etype(c12,int0)
    & fact(c12,real)
    & gener(c12,sp)
    & quant(c12,one)
    & refer(c12,indet)
    & varia(c12,varia_c)
    & sort(c210,na)
    & card(c210,int1)
    & etype(c210,int0)
    & fact(c210,real)
    & gener(c210,sp)
    & quant(c210,one)
    & refer(c210,indet)
    & varia(c210,varia_c)
    & sort(hauptsstadt_1_1,d)
    & sort(hauptsstadt_1_1,io)
    & card(hauptsstadt_1_1,int1)
    & etype(hauptsstadt_1_1,int0)
    & fact(hauptsstadt_1_1,real)
    & gener(hauptsstadt_1_1,ge)
    & quant(hauptsstadt_1_1,one)
    & refer(hauptsstadt_1_1,refer_c)
    & varia(hauptsstadt_1_1,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(pretoria_0,fe)
    & sort(c17,t)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c18,me)
    & sort(c18,oa)
    & sort(c18,ta)
    & card(c18,card_c)
    & etype(c18,etype_c)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,quant_c)
    & refer(c18,refer_c)
    & varia(c18,varia_c)
    & sort(c19,me)
    & sort(c19,oa)
    & sort(c19,ta)
    & card(c19,card_c)
    & etype(c19,etype_c)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,quant_c)
    & refer(c19,refer_c)
    & varia(c19,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c15,nu)
    & card(c15,int10)
    & sort(c183,d)
    & card(c183,int1)
    & etype(c183,int0)
    & fact(c183,real)
    & gener(c183,ge)
    & quant(c183,one)
    & refer(c183,refer_c)
    & varia(c183,varia_c)
    & sort(erst_1_1,oq)
    & card(erst_1_1,int1)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(c187,d)
    & sort(c187,io)
    & card(c187,int1)
    & etype(c187,int0)
    & fact(c187,real)
    & gener(c187,sp)
    & quant(c187,one)
    & refer(c187,det)
    & varia(c187,con)
    & sort(c193,d)
    & card(c193,int1)
    & etype(c193,int0)
    & fact(c193,real)
    & gener(c193,sp)
    & quant(c193,one)
    & refer(c193,det)
    & varia(c193,con)
    & sort(c188,na)
    & card(c188,int1)
    & etype(c188,int0)
    & fact(c188,real)
    & gener(c188,sp)
    & quant(c188,one)
    & refer(c188,indet)
    & varia(c188,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c16,nu)
    & card(c16,int5)
    & sort(c194,na)
    & card(c194,int1)
    & etype(c194,int0)
    & fact(c194,real)
    & gener(c194,sp)
    & quant(c194,one)
    & refer(c194,indet)
    & varia(c194,varia_c)
    & sort(c195,na)
    & card(c195,int1)
    & etype(c195,int0)
    & fact(c195,real)
    & gener(c195,sp)
    & quant(c195,one)
    & refer(c195,indet)
    & varia(c195,varia_c)
    & sort(c212,l)
    & card(c212,int1)
    & etype(c212,int0)
    & fact(c212,real)
    & gener(c212,sp)
    & quant(c212,one)
    & refer(c212,det)
    & varia(c212,con)
    & sort(schwarz_1_1,tq)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c199,ta)
    & card(c199,int1)
    & etype(c199,int0)
    & fact(c199,real)
    & gener(c199,sp)
    & quant(c199,one)
    & refer(c199,det)
    & varia(c199,con)
    & sort(dienstag__1_1,ta)
    & card(dienstag__1_1,int1)
    & etype(dienstag__1_1,int0)
    & fact(dienstag__1_1,real)
    & gener(dienstag__1_1,ge)
    & quant(dienstag__1_1,one)
    & refer(dienstag__1_1,refer_c)
    & varia(dienstag__1_1,varia_c)
    & sort(c31,ent)
    & card(c31,card_c)
    & etype(c31,etype_c)
    & fact(c31,real)
    & gener(c31,gener_c)
    & quant(c31,quant_c)
    & refer(c31,refer_c)
    & varia(c31,varia_c)
    & sort(c43,ad)
    & card(c43,int1)
    & etype(c43,int0)
    & fact(c43,real)
    & gener(c43,sp)
    & quant(c43,one)
    & refer(c43,det)
    & varia(c43,con)
    & sort(afrikanisch__1_1,nq)
    & sort(feier__1_1,ad)
    & card(feier__1_1,int1)
    & etype(feier__1_1,int0)
    & fact(feier__1_1,real)
    & gener(feier__1_1,ge)
    & quant(feier__1_1,one)
    & refer(feier__1_1,refer_c)
    & varia(feier__1_1,varia_c)
    & sort(vereidigung_1_1,ad)
    & card(vereidigung_1_1,int1)
    & etype(vereidigung_1_1,int0)
    & fact(vereidigung_1_1,real)
    & gener(vereidigung_1_1,ge)
    & quant(vereidigung_1_1,one)
    & refer(vereidigung_1_1,refer_c)
    & varia(vereidigung_1_1,varia_c)
    & sort(c52,ad)
    & card(c52,int1)
    & etype(c52,int0)
    & fact(c52,real)
    & gener(c52,sp)
    & quant(c52,one)
    & refer(c52,det)
    & varia(c52,con)
    & sort(ausgelassen_1_1,ql)
    & sort(freude_1_1,ad)
    & card(freude_1_1,int1)
    & etype(freude_1_1,int0)
    & fact(freude_1_1,real)
    & gener(freude_1_1,ge)
    & quant(freude_1_1,one)
    & refer(freude_1_1,refer_c)
    & varia(freude_1_1,varia_c)
    & sort(c55,st)
    & fact(c55,real)
    & gener(c55,sp)
    & sort(equ_0,st)
    & fact(equ_0,real)
    & gener(equ_0,gener_c) ) ).

%------------------------------------------------------------------------------
