%------------------------------------------------------------------------------
% File     : CSR116+29 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1824_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.43 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.70 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11083 (   0 equ)
%            Maximal formula atoms :  370 (   1 avg)
%            Number of connectives :  894 (   0   ~;  18   |; 750   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  370 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-12 aty)
%            Number of functors    : 16676 (16676 usr;16675 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1824,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1824,hypothesis,
    ( sub(c9434,abkommen_1_1)
    & pred(c9443,verfechter_1_1)
    & attch(c9448,c9443)
    & prop(c9448,angolanisch_1_1)
    & sub(c9448,regierung_1_1)
    & attr(c9456,c9457)
    & sub(c9456,einrichtung_1_2)
    & sub(c9457,name_1_1)
    & val(c9457,unita_0)
    & pred(c9458,meuterer_1_1)
    & sub(c9464,druck_1_1)
    & attr(c9473,c9464)
    & attr(c9473,c9474)
    & attr(c9473,c9475)
    & prop(c9473,s__374dafrikanisch_1_1)
    & sub(c9473,pr__344sident_1_1)
    & sub(c9474,eigenname_1_1)
    & val(c9474,nelson_0)
    & sub(c9475,familiename_1_1)
    & val(c9475,mandela_0)
    & attr(c9484,c9485)
    & sub(c9484,land_1_1)
    & sub(c9485,name_1_1)
    & val(c9485,simbabwe_0)
    & attr(c9488,c9489)
    & attr(c9488,c9490)
    & sub(c9488,pr__344sident_1_1)
    & sub(c9489,eigenname_1_1)
    & val(c9489,robert_0)
    & sub(c9490,familiename_1_1)
    & val(c9490,mugabe_0)
    & pred(c9495,garantiemacht_1_2)
    & attr(c9500,c9501)
    & sub(c9500,land_1_1)
    & sub(c9501,name_1_1)
    & val(c9501,usa_0)
    & attr(c9505,c9506)
    & sub(c9505,land_1_1)
    & sub(c9506,name_1_1)
    & val(c9506,portugal_0)
    & attr(c9518,c9519)
    & sub(c9518,land_1_1)
    & sub(c9519,name_1_1)
    & val(c9519,russland_0)
    & tupl_p12(c9590,c9434,c9443,c9456,c9458,c9464,c9488,c9484,c9495,c9500,c9505,c9518)
    & assoc(garantiemacht_1_2,b__374rgschaft_1_1)
    & sub(garantiemacht_1_2,macht_1_2)
    & sort(c9434,d)
    & sort(c9434,io)
    & card(c9434,int1)
    & etype(c9434,int0)
    & fact(c9434,real)
    & gener(c9434,sp)
    & quant(c9434,one)
    & refer(c9434,det)
    & varia(c9434,con)
    & sort(abkommen_1_1,d)
    & sort(abkommen_1_1,io)
    & card(abkommen_1_1,int1)
    & etype(abkommen_1_1,int0)
    & fact(abkommen_1_1,real)
    & gener(abkommen_1_1,ge)
    & quant(abkommen_1_1,one)
    & refer(abkommen_1_1,refer_c)
    & varia(abkommen_1_1,varia_c)
    & sort(c9443,d)
    & sort(c9443,io)
    & card(c9443,cons(x_constant,cons(int1,nil)))
    & etype(c9443,int1)
    & fact(c9443,real)
    & gener(c9443,sp)
    & quant(c9443,mult)
    & refer(c9443,indet)
    & varia(c9443,varia_c)
    & sort(verfechter_1_1,d)
    & sort(verfechter_1_1,io)
    & card(verfechter_1_1,int1)
    & etype(verfechter_1_1,int0)
    & fact(verfechter_1_1,real)
    & gener(verfechter_1_1,ge)
    & quant(verfechter_1_1,one)
    & refer(verfechter_1_1,refer_c)
    & varia(verfechter_1_1,varia_c)
    & sort(c9448,d)
    & sort(c9448,io)
    & card(c9448,int1)
    & etype(c9448,int1)
    & fact(c9448,real)
    & gener(c9448,sp)
    & quant(c9448,one)
    & refer(c9448,det)
    & varia(c9448,con)
    & sort(angolanisch_1_1,nq)
    & sort(regierung_1_1,d)
    & sort(regierung_1_1,io)
    & card(regierung_1_1,card_c)
    & etype(regierung_1_1,int1)
    & fact(regierung_1_1,real)
    & gener(regierung_1_1,ge)
    & quant(regierung_1_1,quant_c)
    & refer(regierung_1_1,refer_c)
    & varia(regierung_1_1,varia_c)
    & sort(c9456,d)
    & sort(c9456,io)
    & card(c9456,int1)
    & etype(c9456,int1)
    & fact(c9456,real)
    & gener(c9456,sp)
    & quant(c9456,one)
    & refer(c9456,det)
    & varia(c9456,con)
    & sort(c9457,na)
    & card(c9457,int1)
    & etype(c9457,int0)
    & fact(c9457,real)
    & gener(c9457,sp)
    & quant(c9457,one)
    & refer(c9457,indet)
    & varia(c9457,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(unita_0,fe)
    & sort(c9458,d)
    & card(c9458,cons(x_constant,cons(int1,nil)))
    & etype(c9458,int1)
    & fact(c9458,real)
    & gener(c9458,gener_c)
    & quant(c9458,mult)
    & refer(c9458,indet)
    & varia(c9458,varia_c)
    & sort(meuterer_1_1,d)
    & card(meuterer_1_1,int1)
    & etype(meuterer_1_1,int0)
    & fact(meuterer_1_1,real)
    & gener(meuterer_1_1,ge)
    & quant(meuterer_1_1,one)
    & refer(meuterer_1_1,refer_c)
    & varia(meuterer_1_1,varia_c)
    & sort(c9464,oa)
    & card(c9464,int1)
    & etype(c9464,int0)
    & fact(c9464,real)
    & gener(c9464,sp)
    & quant(c9464,one)
    & refer(c9464,det)
    & varia(c9464,varia_c)
    & sort(druck_1_1,oa)
    & card(druck_1_1,int1)
    & etype(druck_1_1,int0)
    & fact(druck_1_1,real)
    & gener(druck_1_1,ge)
    & quant(druck_1_1,one)
    & refer(druck_1_1,refer_c)
    & varia(druck_1_1,varia_c)
    & sort(c9473,d)
    & card(c9473,int1)
    & etype(c9473,int0)
    & fact(c9473,real)
    & gener(c9473,sp)
    & quant(c9473,one)
    & refer(c9473,det)
    & varia(c9473,con)
    & sort(c9474,na)
    & card(c9474,int1)
    & etype(c9474,int0)
    & fact(c9474,real)
    & gener(c9474,sp)
    & quant(c9474,one)
    & refer(c9474,indet)
    & varia(c9474,varia_c)
    & sort(c9475,na)
    & card(c9475,int1)
    & etype(c9475,int0)
    & fact(c9475,real)
    & gener(c9475,sp)
    & quant(c9475,one)
    & refer(c9475,indet)
    & varia(c9475,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c9484,d)
    & sort(c9484,io)
    & card(c9484,int1)
    & etype(c9484,int0)
    & fact(c9484,real)
    & gener(c9484,sp)
    & quant(c9484,one)
    & refer(c9484,det)
    & varia(c9484,con)
    & sort(c9485,na)
    & card(c9485,int1)
    & etype(c9485,int0)
    & fact(c9485,real)
    & gener(c9485,sp)
    & quant(c9485,one)
    & refer(c9485,indet)
    & varia(c9485,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(simbabwe_0,fe)
    & sort(c9488,d)
    & card(c9488,int1)
    & etype(c9488,int0)
    & fact(c9488,real)
    & gener(c9488,sp)
    & quant(c9488,one)
    & refer(c9488,det)
    & varia(c9488,con)
    & sort(c9489,na)
    & card(c9489,int1)
    & etype(c9489,int0)
    & fact(c9489,real)
    & gener(c9489,sp)
    & quant(c9489,one)
    & refer(c9489,indet)
    & varia(c9489,varia_c)
    & sort(c9490,na)
    & card(c9490,int1)
    & etype(c9490,int0)
    & fact(c9490,real)
    & gener(c9490,sp)
    & quant(c9490,one)
    & refer(c9490,indet)
    & varia(c9490,varia_c)
    & sort(robert_0,fe)
    & sort(mugabe_0,fe)
    & sort(c9495,d)
    & sort(c9495,io)
    & card(c9495,int3)
    & etype(c9495,int1)
    & fact(c9495,real)
    & gener(c9495,sp)
    & quant(c9495,nfquant)
    & refer(c9495,det)
    & varia(c9495,con)
    & sort(garantiemacht_1_2,d)
    & sort(garantiemacht_1_2,io)
    & card(garantiemacht_1_2,int1)
    & etype(garantiemacht_1_2,int0)
    & fact(garantiemacht_1_2,real)
    & gener(garantiemacht_1_2,ge)
    & quant(garantiemacht_1_2,one)
    & refer(garantiemacht_1_2,refer_c)
    & varia(garantiemacht_1_2,varia_c)
    & sort(c9500,d)
    & sort(c9500,io)
    & card(c9500,int1)
    & etype(c9500,int0)
    & fact(c9500,real)
    & gener(c9500,sp)
    & quant(c9500,one)
    & refer(c9500,det)
    & varia(c9500,con)
    & sort(c9501,na)
    & card(c9501,int1)
    & etype(c9501,int0)
    & fact(c9501,real)
    & gener(c9501,sp)
    & quant(c9501,one)
    & refer(c9501,indet)
    & varia(c9501,varia_c)
    & sort(usa_0,fe)
    & sort(c9505,d)
    & sort(c9505,io)
    & card(c9505,int1)
    & etype(c9505,int0)
    & fact(c9505,real)
    & gener(c9505,sp)
    & quant(c9505,one)
    & refer(c9505,det)
    & varia(c9505,con)
    & sort(c9506,na)
    & card(c9506,int1)
    & etype(c9506,int0)
    & fact(c9506,real)
    & gener(c9506,sp)
    & quant(c9506,one)
    & refer(c9506,indet)
    & varia(c9506,varia_c)
    & sort(portugal_0,fe)
    & sort(c9518,d)
    & sort(c9518,io)
    & card(c9518,int1)
    & etype(c9518,int0)
    & fact(c9518,real)
    & gener(c9518,sp)
    & quant(c9518,one)
    & refer(c9518,det)
    & varia(c9518,con)
    & sort(c9519,na)
    & card(c9519,int1)
    & etype(c9519,int0)
    & fact(c9519,real)
    & gener(c9519,sp)
    & quant(c9519,one)
    & refer(c9519,indet)
    & varia(c9519,varia_c)
    & sort(russland_0,fe)
    & sort(c9590,ent)
    & card(c9590,card_c)
    & etype(c9590,etype_c)
    & fact(c9590,real)
    & gener(c9590,gener_c)
    & quant(c9590,quant_c)
    & refer(c9590,refer_c)
    & varia(c9590,varia_c)
    & sort(b__374rgschaft_1_1,io)
    & card(b__374rgschaft_1_1,int1)
    & etype(b__374rgschaft_1_1,int0)
    & fact(b__374rgschaft_1_1,real)
    & gener(b__374rgschaft_1_1,ge)
    & quant(b__374rgschaft_1_1,one)
    & refer(b__374rgschaft_1_1,refer_c)
    & varia(b__374rgschaft_1_1,varia_c)
    & sort(macht_1_2,d)
    & sort(macht_1_2,io)
    & card(macht_1_2,int1)
    & etype(macht_1_2,int0)
    & fact(macht_1_2,real)
    & gener(macht_1_2,ge)
    & quant(macht_1_2,one)
    & refer(macht_1_2,refer_c)
    & varia(macht_1_2,varia_c) ) ).

%------------------------------------------------------------------------------
