%------------------------------------------------------------------------------
% File     : CSR116+28 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1818_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.40 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.43 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.72 v6.0.0, 0.50 v5.5.0, 0.71 v5.4.0, 0.70 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.70 v4.1.0, 0.72 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10966 (   0 equ)
%            Maximal formula atoms :  253 (   1 avg)
%            Number of connectives :  777 (   0   ~;  18   |; 633   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  253 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   88 (  88 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16661 (16661 usr;16660 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1818,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1818,hypothesis,
    ( chsp1(anschlie__337en_1_1,c0)
    & attch(c17,c8)
    & attr(c17,c18)
    & attr(c17,c19)
    & prop(c17,s__374dafrikanisch_1_1)
    & sub(c17,pr__344sident_1_1)
    & sub(c18,eigenname_1_1)
    & val(c18,nelson_0)
    & sub(c19,familiename_1_1)
    & val(c19,mandela_0)
    & pred(c21,tuinhuys_1_1)
    & sub(c26,k__366nigin_1_1)
    & sub(c277,verdienstorden_1_1)
    & agt(c284,c26)
    & assoc(c284,c277)
    & loc(c284,c288)
    & mannr(c284,c0)
    & ornt(c284,c29)
    & subs(c284,auszeichnen_1_1)
    & in(c287,c21)
    & in(c288,c8)
    & sub(c29,landesvater_1_1)
    & attch(c31,c26)
    & attr(c31,c32)
    & sub(c31,land_1_1)
    & sub(c32,name_1_1)
    & val(c32,s__374dafrika_0)
    & loc(c8,c287)
    & sub(c8,residenz__1_1)
    & assoc(landesvater_1_1,land_1_1)
    & sub(landesvater_1_1,an_f__374hrer_1_1)
    & assoc(verdienstorden_1_1,verdienst_2_1)
    & sub(verdienstorden_1_1,orden_1_1)
    & sort(anschlie__337en_1_1,da)
    & fact(anschlie__337en_1_1,real)
    & gener(anschlie__337en_1_1,ge)
    & sort(c0,tq)
    & sort(c17,d)
    & card(c17,int1)
    & etype(c17,int0)
    & fact(c17,real)
    & gener(c17,sp)
    & quant(c17,one)
    & refer(c17,det)
    & varia(c17,con)
    & sort(c8,d)
    & card(c8,int1)
    & etype(c8,int0)
    & fact(c8,real)
    & gener(c8,sp)
    & quant(c8,one)
    & refer(c8,det)
    & varia(c8,con)
    & sort(c18,na)
    & card(c18,int1)
    & etype(c18,int0)
    & fact(c18,real)
    & gener(c18,sp)
    & quant(c18,one)
    & refer(c18,indet)
    & varia(c18,varia_c)
    & sort(c19,na)
    & card(c19,int1)
    & etype(c19,int0)
    & fact(c19,real)
    & gener(c19,sp)
    & quant(c19,one)
    & refer(c19,indet)
    & varia(c19,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c21,o)
    & card(c21,cons(x_constant,cons(int1,nil)))
    & etype(c21,int1)
    & fact(c21,real)
    & gener(c21,sp)
    & quant(c21,mult)
    & refer(c21,indet)
    & varia(c21,varia_c)
    & sort(tuinhuys_1_1,o)
    & card(tuinhuys_1_1,int1)
    & etype(tuinhuys_1_1,int0)
    & fact(tuinhuys_1_1,real)
    & gener(tuinhuys_1_1,ge)
    & quant(tuinhuys_1_1,one)
    & refer(tuinhuys_1_1,refer_c)
    & varia(tuinhuys_1_1,varia_c)
    & sort(c26,d)
    & card(c26,int1)
    & etype(c26,int0)
    & fact(c26,real)
    & gener(c26,sp)
    & quant(c26,one)
    & refer(c26,det)
    & varia(c26,con)
    & sort(k__366nigin_1_1,d)
    & card(k__366nigin_1_1,int1)
    & etype(k__366nigin_1_1,int0)
    & fact(k__366nigin_1_1,real)
    & gener(k__366nigin_1_1,ge)
    & quant(k__366nigin_1_1,one)
    & refer(k__366nigin_1_1,refer_c)
    & varia(k__366nigin_1_1,varia_c)
    & sort(c277,d)
    & sort(c277,io)
    & card(c277,int1)
    & etype(c277,int1)
    & fact(c277,real)
    & gener(c277,sp)
    & quant(c277,one)
    & refer(c277,det)
    & varia(c277,con)
    & sort(verdienstorden_1_1,d)
    & sort(verdienstorden_1_1,io)
    & card(verdienstorden_1_1,card_c)
    & etype(verdienstorden_1_1,int1)
    & fact(verdienstorden_1_1,real)
    & gener(verdienstorden_1_1,ge)
    & quant(verdienstorden_1_1,quant_c)
    & refer(verdienstorden_1_1,refer_c)
    & varia(verdienstorden_1_1,varia_c)
    & sort(c284,da)
    & fact(c284,real)
    & gener(c284,sp)
    & sort(c288,l)
    & card(c288,int1)
    & etype(c288,int0)
    & fact(c288,real)
    & gener(c288,sp)
    & quant(c288,one)
    & refer(c288,det)
    & varia(c288,con)
    & sort(c29,d)
    & card(c29,int1)
    & etype(c29,int0)
    & fact(c29,real)
    & gener(c29,sp)
    & quant(c29,one)
    & refer(c29,refer_c)
    & varia(c29,varia_c)
    & sort(auszeichnen_1_1,da)
    & fact(auszeichnen_1_1,real)
    & gener(auszeichnen_1_1,ge)
    & sort(c287,l)
    & card(c287,cons(x_constant,cons(int1,nil)))
    & etype(c287,int1)
    & fact(c287,real)
    & gener(c287,sp)
    & quant(c287,mult)
    & refer(c287,indet)
    & varia(c287,varia_c)
    & sort(landesvater_1_1,d)
    & card(landesvater_1_1,int1)
    & etype(landesvater_1_1,int0)
    & fact(landesvater_1_1,real)
    & gener(landesvater_1_1,ge)
    & quant(landesvater_1_1,one)
    & refer(landesvater_1_1,refer_c)
    & varia(landesvater_1_1,varia_c)
    & sort(c31,d)
    & sort(c31,io)
    & card(c31,int1)
    & etype(c31,int0)
    & fact(c31,real)
    & gener(c31,sp)
    & quant(c31,one)
    & refer(c31,det)
    & varia(c31,con)
    & sort(c32,na)
    & card(c32,int1)
    & etype(c32,int0)
    & fact(c32,real)
    & gener(c32,sp)
    & quant(c32,one)
    & refer(c32,indet)
    & varia(c32,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(residenz__1_1,d)
    & card(residenz__1_1,int1)
    & etype(residenz__1_1,int0)
    & fact(residenz__1_1,real)
    & gener(residenz__1_1,ge)
    & quant(residenz__1_1,one)
    & refer(residenz__1_1,refer_c)
    & varia(residenz__1_1,varia_c)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c)
    & sort(verdienst_2_1,as)
    & sort(verdienst_2_1,io)
    & card(verdienst_2_1,int1)
    & etype(verdienst_2_1,int0)
    & fact(verdienst_2_1,real)
    & gener(verdienst_2_1,ge)
    & quant(verdienst_2_1,one)
    & refer(verdienst_2_1,refer_c)
    & varia(verdienst_2_1,varia_c)
    & sort(orden_1_1,d)
    & sort(orden_1_1,io)
    & card(orden_1_1,card_c)
    & etype(orden_1_1,int1)
    & fact(orden_1_1,real)
    & gener(orden_1_1,ge)
    & quant(orden_1_1,quant_c)
    & refer(orden_1_1,refer_c)
    & varia(orden_1_1,varia_c) ) ).

%------------------------------------------------------------------------------
