%------------------------------------------------------------------------------
% File     : CSR116+26 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1797_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.53 v9.0.0, 0.31 v8.2.0, 0.27 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.70 v5.2.0, 0.57 v5.0.0, 0.65 v4.1.0, 0.67 v4.0.1, 0.68 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10976 (   0 equ)
%            Maximal formula atoms :  263 (   1 avg)
%            Number of connectives :  787 (   0   ~;  18   |; 643   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  263 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-10 aty)
%            Number of functors    : 16661 (16661 usr;16660 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1797,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1797,hypothesis,
    ( attr(c2816,c2817)
    & sub(c2816,mensch_1_1)
    & sub(c2817,familiename_1_1)
    & val(c2817,clinton_0)
    & sub(c2822,sonnentag_1_1)
    & subs(c2823,treffen_3_1)
    & attr(c2836,c2837)
    & attr(c2836,c2838)
    & prop(c2836,s__374dafrikanisch_1_1)
    & sub(c2836,ministerpr__344sident_1_1)
    & sub(c2836,pr__344sident_1_1)
    & sub(c2837,eigenname_1_1)
    & val(c2837,nelson_0)
    & sub(c2838,familiename_1_1)
    & val(c2838,mandela_0)
    & attr(c2849,c2850)
    & sub(c2849,land_1_1)
    & sub(c2850,name_1_1)
    & val(c2850,slowenien_0)
    & sub(c2856,pr__344sident_1_1)
    & attr(c2862,c2863)
    & sub(c2862,land_1_1)
    & sub(c2863,name_1_1)
    & val(c2863,n344thiopien_0)
    & attr(c2868,c2869)
    & sub(c2868,land_1_1)
    & sub(c2869,name_1_1)
    & val(c2869,eritrea_0)
    & sub(c2873,programm_1_1)
    & tupl_p10(c3504,c2816,c2822,c2823,c2836,c2849,c2856,c2862,c2868,c2873)
    & assoc(ministerpr__344sident_1_1,minister__1_1)
    & sub(ministerpr__344sident_1_1,pr__344sident_1_1)
    & sort(c2816,d)
    & card(c2816,int1)
    & etype(c2816,int0)
    & fact(c2816,real)
    & gener(c2816,sp)
    & quant(c2816,one)
    & refer(c2816,det)
    & varia(c2816,con)
    & sort(c2817,na)
    & card(c2817,int1)
    & etype(c2817,int0)
    & fact(c2817,real)
    & gener(c2817,sp)
    & quant(c2817,one)
    & refer(c2817,indet)
    & varia(c2817,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(clinton_0,fe)
    & sort(c2822,ta)
    & card(c2822,int1)
    & etype(c2822,int0)
    & fact(c2822,real)
    & gener(c2822,gener_c)
    & quant(c2822,one)
    & refer(c2822,refer_c)
    & varia(c2822,varia_c)
    & sort(sonnentag_1_1,ta)
    & card(sonnentag_1_1,int1)
    & etype(sonnentag_1_1,int0)
    & fact(sonnentag_1_1,real)
    & gener(sonnentag_1_1,ge)
    & quant(sonnentag_1_1,one)
    & refer(sonnentag_1_1,refer_c)
    & varia(sonnentag_1_1,varia_c)
    & sort(c2823,ad)
    & card(c2823,int1)
    & etype(c2823,int0)
    & fact(c2823,real)
    & gener(c2823,gener_c)
    & quant(c2823,one)
    & refer(c2823,refer_c)
    & varia(c2823,varia_c)
    & sort(treffen_3_1,ad)
    & card(treffen_3_1,int1)
    & etype(treffen_3_1,int0)
    & fact(treffen_3_1,real)
    & gener(treffen_3_1,ge)
    & quant(treffen_3_1,one)
    & refer(treffen_3_1,refer_c)
    & varia(treffen_3_1,varia_c)
    & sort(c2836,d)
    & card(c2836,int1)
    & etype(c2836,int0)
    & fact(c2836,real)
    & gener(c2836,sp)
    & quant(c2836,one)
    & refer(c2836,det)
    & varia(c2836,con)
    & sort(c2837,na)
    & card(c2837,int1)
    & etype(c2837,int0)
    & fact(c2837,real)
    & gener(c2837,sp)
    & quant(c2837,one)
    & refer(c2837,indet)
    & varia(c2837,varia_c)
    & sort(c2838,na)
    & card(c2838,int1)
    & etype(c2838,int0)
    & fact(c2838,real)
    & gener(c2838,sp)
    & quant(c2838,one)
    & refer(c2838,indet)
    & varia(c2838,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(ministerpr__344sident_1_1,d)
    & card(ministerpr__344sident_1_1,int1)
    & etype(ministerpr__344sident_1_1,int0)
    & fact(ministerpr__344sident_1_1,real)
    & gener(ministerpr__344sident_1_1,ge)
    & quant(ministerpr__344sident_1_1,one)
    & refer(ministerpr__344sident_1_1,refer_c)
    & varia(ministerpr__344sident_1_1,varia_c)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(mandela_0,fe)
    & sort(c2849,d)
    & sort(c2849,io)
    & card(c2849,int1)
    & etype(c2849,int0)
    & fact(c2849,real)
    & gener(c2849,sp)
    & quant(c2849,one)
    & refer(c2849,det)
    & varia(c2849,con)
    & sort(c2850,na)
    & card(c2850,int1)
    & etype(c2850,int0)
    & fact(c2850,real)
    & gener(c2850,sp)
    & quant(c2850,one)
    & refer(c2850,indet)
    & varia(c2850,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(slowenien_0,fe)
    & sort(c2856,d)
    & card(c2856,int1)
    & etype(c2856,int0)
    & fact(c2856,real)
    & gener(c2856,sp)
    & quant(c2856,one)
    & refer(c2856,det)
    & varia(c2856,con)
    & sort(c2862,d)
    & sort(c2862,io)
    & card(c2862,int1)
    & etype(c2862,int0)
    & fact(c2862,real)
    & gener(c2862,sp)
    & quant(c2862,one)
    & refer(c2862,det)
    & varia(c2862,con)
    & sort(c2863,na)
    & card(c2863,int1)
    & etype(c2863,int0)
    & fact(c2863,real)
    & gener(c2863,sp)
    & quant(c2863,one)
    & refer(c2863,indet)
    & varia(c2863,varia_c)
    & sort(n344thiopien_0,fe)
    & sort(c2868,d)
    & sort(c2868,io)
    & card(c2868,int1)
    & etype(c2868,int0)
    & fact(c2868,real)
    & gener(c2868,sp)
    & quant(c2868,one)
    & refer(c2868,det)
    & varia(c2868,con)
    & sort(c2869,na)
    & card(c2869,int1)
    & etype(c2869,int0)
    & fact(c2869,real)
    & gener(c2869,sp)
    & quant(c2869,one)
    & refer(c2869,indet)
    & varia(c2869,varia_c)
    & sort(eritrea_0,fe)
    & sort(c2873,ad)
    & sort(c2873,d)
    & sort(c2873,io)
    & card(c2873,int1)
    & etype(c2873,int0)
    & fact(c2873,real)
    & gener(c2873,sp)
    & quant(c2873,one)
    & refer(c2873,det)
    & varia(c2873,con)
    & sort(programm_1_1,ad)
    & sort(programm_1_1,d)
    & sort(programm_1_1,io)
    & card(programm_1_1,int1)
    & etype(programm_1_1,int0)
    & fact(programm_1_1,real)
    & gener(programm_1_1,ge)
    & quant(programm_1_1,one)
    & refer(programm_1_1,refer_c)
    & varia(programm_1_1,varia_c)
    & sort(c3504,ent)
    & card(c3504,card_c)
    & etype(c3504,etype_c)
    & fact(c3504,real)
    & gener(c3504,gener_c)
    & quant(c3504,quant_c)
    & refer(c3504,refer_c)
    & varia(c3504,varia_c)
    & sort(minister__1_1,d)
    & card(minister__1_1,int1)
    & etype(minister__1_1,int0)
    & fact(minister__1_1,real)
    & gener(minister__1_1,ge)
    & quant(minister__1_1,one)
    & refer(minister__1_1,refer_c)
    & varia(minister__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
