%------------------------------------------------------------------------------
% File     : CSR116+25 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1794_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.45 v9.1.0, 0.47 v9.0.0, 0.25 v8.2.0, 0.27 v8.1.0, 0.43 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.57 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.62 v5.4.0, 0.61 v5.3.0, 0.74 v5.2.0, 0.50 v5.0.0, 0.70 v4.1.0, 0.72 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 11132 (   0 equ)
%            Maximal formula atoms :  419 (   1 avg)
%            Number of connectives :  943 (   0   ~;  18   |; 799   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  419 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   89 (  89 usr;   0 prp; 2-7 aty)
%            Number of functors    : 16684 (16684 usr;16683 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1794,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1794,hypothesis,
    ( tupl_p5(c156,c69,c75,c85,c91)
    & prop(c661,afrikanisch__1_1)
    & subs(c661,nationalkongre__337_2_1)
    & attr(c667,c668)
    & sub(c667,einrichtung_1_2)
    & sub(c668,name_1_1)
    & val(c668,anc_0)
    & attr(c676,c677)
    & attr(c676,c678)
    & prop(c676,s__374dafrikanisch_1_1)
    & sub(c676,pr__344sident_1_1)
    & sub(c677,eigenname_1_1)
    & val(c677,nelson_0)
    & sub(c678,familiename_1_1)
    & val(c678,mandela_0)
    & pred(c69,wahlgewinner_1_1)
    & attr(c691,c692)
    & attr(c691,c693)
    & sub(c692,tag_1_1)
    & val(c692,c689)
    & sub(c693,monat_1_1)
    & val(c693,c690)
    & subm(c696,c701)
    & preds(c701,stimme_1_1)
    & attch(c71,c69)
    & attr(c71,c72)
    & sub(c71,einrichtung_1_2)
    & sub(c72,name_1_1)
    & val(c72,anc_0)
    & tupl_p7(c732,c661,c667,c676,c75,c691,c696)
    & preds(c75,kommunalswahl_1_1)
    & attch(c81,c85)
    & attr(c81,c82)
    & sub(c81,land_1_1)
    & sub(c82,name_1_1)
    & val(c82,s__374dafrika_0)
    & attr(c85,c86)
    & sub(c85,stadt__1_1)
    & sub(c86,name_1_1)
    & val(c86,johannesburg_0)
    & attr(c91,c92)
    & attr(c91,c93)
    & sub(c92,tag_1_1)
    & val(c92,c89)
    & sub(c93,monat_1_1)
    & val(c93,c90)
    & assoc(kommunalswahl_1_1,gemeindlich_1_1)
    & subs(kommunalswahl_1_1,wahl_1_1)
    & assoc(nationalkongre__337_2_1,national__1_1)
    & subs(nationalkongre__337_2_1,kongre__337_2_1)
    & assoc(wahlgewinner_1_1,auswahl_1_1)
    & sub(wahlgewinner_1_1,sieger__1_1)
    & sort(c156,ent)
    & card(c156,card_c)
    & etype(c156,etype_c)
    & fact(c156,real)
    & gener(c156,gener_c)
    & quant(c156,quant_c)
    & refer(c156,refer_c)
    & varia(c156,varia_c)
    & sort(c69,d)
    & sort(c69,io)
    & card(c69,cons(x_constant,cons(int1,nil)))
    & etype(c69,int1)
    & fact(c69,real)
    & gener(c69,sp)
    & quant(c69,mult)
    & refer(c69,indet)
    & varia(c69,varia_c)
    & sort(c75,ad)
    & card(c75,cons(x_constant,cons(int1,nil)))
    & etype(c75,int1)
    & fact(c75,real)
    & gener(c75,gener_c)
    & quant(c75,mult)
    & refer(c75,indet)
    & varia(c75,varia_c)
    & sort(c85,d)
    & sort(c85,io)
    & card(c85,int1)
    & etype(c85,int0)
    & fact(c85,real)
    & gener(c85,sp)
    & quant(c85,one)
    & refer(c85,det)
    & varia(c85,con)
    & sort(c91,t)
    & card(c91,int1)
    & etype(c91,int0)
    & fact(c91,real)
    & gener(c91,sp)
    & quant(c91,one)
    & refer(c91,det)
    & varia(c91,con)
    & sort(c661,ad)
    & card(c661,int1)
    & etype(c661,int0)
    & fact(c661,real)
    & gener(c661,sp)
    & quant(c661,one)
    & refer(c661,det)
    & varia(c661,con)
    & sort(afrikanisch__1_1,nq)
    & sort(nationalkongre__337_2_1,ad)
    & card(nationalkongre__337_2_1,int1)
    & etype(nationalkongre__337_2_1,int0)
    & fact(nationalkongre__337_2_1,real)
    & gener(nationalkongre__337_2_1,ge)
    & quant(nationalkongre__337_2_1,one)
    & refer(nationalkongre__337_2_1,refer_c)
    & varia(nationalkongre__337_2_1,varia_c)
    & sort(c667,d)
    & sort(c667,io)
    & card(c667,int1)
    & etype(c667,int1)
    & fact(c667,real)
    & gener(c667,sp)
    & quant(c667,one)
    & refer(c667,det)
    & varia(c667,con)
    & sort(c668,na)
    & card(c668,int1)
    & etype(c668,int0)
    & fact(c668,real)
    & gener(c668,sp)
    & quant(c668,one)
    & refer(c668,indet)
    & varia(c668,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(anc_0,fe)
    & sort(c676,d)
    & card(c676,int1)
    & etype(c676,int0)
    & fact(c676,real)
    & gener(c676,sp)
    & quant(c676,one)
    & refer(c676,det)
    & varia(c676,con)
    & sort(c677,na)
    & card(c677,int1)
    & etype(c677,int0)
    & fact(c677,real)
    & gener(c677,sp)
    & quant(c677,one)
    & refer(c677,indet)
    & varia(c677,varia_c)
    & sort(c678,na)
    & card(c678,int1)
    & etype(c678,int0)
    & fact(c678,real)
    & gener(c678,sp)
    & quant(c678,one)
    & refer(c678,indet)
    & varia(c678,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(wahlgewinner_1_1,d)
    & sort(wahlgewinner_1_1,io)
    & card(wahlgewinner_1_1,int1)
    & etype(wahlgewinner_1_1,int0)
    & fact(wahlgewinner_1_1,real)
    & gener(wahlgewinner_1_1,ge)
    & quant(wahlgewinner_1_1,one)
    & refer(wahlgewinner_1_1,refer_c)
    & varia(wahlgewinner_1_1,varia_c)
    & sort(c691,t)
    & card(c691,int1)
    & etype(c691,int0)
    & fact(c691,real)
    & gener(c691,sp)
    & quant(c691,one)
    & refer(c691,det)
    & varia(c691,con)
    & sort(c692,me)
    & sort(c692,oa)
    & sort(c692,ta)
    & card(c692,card_c)
    & etype(c692,etype_c)
    & fact(c692,real)
    & gener(c692,sp)
    & quant(c692,quant_c)
    & refer(c692,refer_c)
    & varia(c692,varia_c)
    & sort(c693,me)
    & sort(c693,oa)
    & sort(c693,ta)
    & card(c693,card_c)
    & etype(c693,etype_c)
    & fact(c693,real)
    & gener(c693,sp)
    & quant(c693,quant_c)
    & refer(c693,refer_c)
    & varia(c693,varia_c)
    & sort(tag_1_1,me)
    & sort(tag_1_1,oa)
    & sort(tag_1_1,ta)
    & card(tag_1_1,card_c)
    & etype(tag_1_1,etype_c)
    & fact(tag_1_1,real)
    & gener(tag_1_1,ge)
    & quant(tag_1_1,quant_c)
    & refer(tag_1_1,refer_c)
    & varia(tag_1_1,varia_c)
    & sort(c689,nu)
    & card(c689,int1)
    & sort(monat_1_1,me)
    & sort(monat_1_1,oa)
    & sort(monat_1_1,ta)
    & card(monat_1_1,card_c)
    & etype(monat_1_1,etype_c)
    & fact(monat_1_1,real)
    & gener(monat_1_1,ge)
    & quant(monat_1_1,quant_c)
    & refer(monat_1_1,refer_c)
    & varia(monat_1_1,varia_c)
    & sort(c690,nu)
    & card(c690,int11)
    & sort(c696,ad)
    & card(c696,float0_6666666666)
    & etype(c696,int1)
    & fact(c696,real)
    & gener(c696,sp)
    & quant(c696,nfquant)
    & refer(c696,det)
    & varia(c696,varia_c)
    & sort(c701,ad)
    & card(c701,cons(x_constant,cons(int1,nil)))
    & etype(c701,int1)
    & fact(c701,real)
    & gener(c701,sp)
    & quant(c701,mult)
    & refer(c701,det)
    & varia(c701,con)
    & sort(stimme_1_1,ad)
    & card(stimme_1_1,int1)
    & etype(stimme_1_1,int0)
    & fact(stimme_1_1,real)
    & gener(stimme_1_1,ge)
    & quant(stimme_1_1,one)
    & refer(stimme_1_1,refer_c)
    & varia(stimme_1_1,varia_c)
    & sort(c71,d)
    & sort(c71,io)
    & card(c71,int1)
    & etype(c71,int1)
    & fact(c71,real)
    & gener(c71,sp)
    & quant(c71,one)
    & refer(c71,det)
    & varia(c71,con)
    & sort(c72,na)
    & card(c72,int1)
    & etype(c72,int0)
    & fact(c72,real)
    & gener(c72,sp)
    & quant(c72,one)
    & refer(c72,indet)
    & varia(c72,varia_c)
    & sort(c732,ent)
    & card(c732,card_c)
    & etype(c732,etype_c)
    & fact(c732,real)
    & gener(c732,gener_c)
    & quant(c732,quant_c)
    & refer(c732,refer_c)
    & varia(c732,varia_c)
    & sort(kommunalswahl_1_1,ad)
    & card(kommunalswahl_1_1,int1)
    & etype(kommunalswahl_1_1,int0)
    & fact(kommunalswahl_1_1,real)
    & gener(kommunalswahl_1_1,ge)
    & quant(kommunalswahl_1_1,one)
    & refer(kommunalswahl_1_1,refer_c)
    & varia(kommunalswahl_1_1,varia_c)
    & sort(c81,d)
    & sort(c81,io)
    & card(c81,int1)
    & etype(c81,int0)
    & fact(c81,real)
    & gener(c81,sp)
    & quant(c81,one)
    & refer(c81,det)
    & varia(c81,con)
    & sort(c82,na)
    & card(c82,int1)
    & etype(c82,int0)
    & fact(c82,real)
    & gener(c82,sp)
    & quant(c82,one)
    & refer(c82,indet)
    & varia(c82,varia_c)
    & sort(land_1_1,d)
    & sort(land_1_1,io)
    & card(land_1_1,int1)
    & etype(land_1_1,int0)
    & fact(land_1_1,real)
    & gener(land_1_1,ge)
    & quant(land_1_1,one)
    & refer(land_1_1,refer_c)
    & varia(land_1_1,varia_c)
    & sort(s__374dafrika_0,fe)
    & sort(c86,na)
    & card(c86,int1)
    & etype(c86,int0)
    & fact(c86,real)
    & gener(c86,sp)
    & quant(c86,one)
    & refer(c86,indet)
    & varia(c86,varia_c)
    & sort(stadt__1_1,d)
    & sort(stadt__1_1,io)
    & card(stadt__1_1,int1)
    & etype(stadt__1_1,int0)
    & fact(stadt__1_1,real)
    & gener(stadt__1_1,ge)
    & quant(stadt__1_1,one)
    & refer(stadt__1_1,refer_c)
    & varia(stadt__1_1,varia_c)
    & sort(johannesburg_0,fe)
    & sort(c92,me)
    & sort(c92,oa)
    & sort(c92,ta)
    & card(c92,card_c)
    & etype(c92,etype_c)
    & fact(c92,real)
    & gener(c92,sp)
    & quant(c92,quant_c)
    & refer(c92,refer_c)
    & varia(c92,varia_c)
    & sort(c93,me)
    & sort(c93,oa)
    & sort(c93,ta)
    & card(c93,card_c)
    & etype(c93,etype_c)
    & fact(c93,real)
    & gener(c93,sp)
    & quant(c93,quant_c)
    & refer(c93,refer_c)
    & varia(c93,varia_c)
    & sort(c89,nu)
    & card(c89,int5)
    & sort(c90,nu)
    & card(c90,int11)
    & sort(gemeindlich_1_1,tq)
    & sort(wahl_1_1,ad)
    & card(wahl_1_1,int1)
    & etype(wahl_1_1,int0)
    & fact(wahl_1_1,real)
    & gener(wahl_1_1,ge)
    & quant(wahl_1_1,one)
    & refer(wahl_1_1,refer_c)
    & varia(wahl_1_1,varia_c)
    & sort(national__1_1,nq)
    & sort(kongre__337_2_1,ad)
    & card(kongre__337_2_1,int1)
    & etype(kongre__337_2_1,int0)
    & fact(kongre__337_2_1,real)
    & gener(kongre__337_2_1,ge)
    & quant(kongre__337_2_1,one)
    & refer(kongre__337_2_1,refer_c)
    & varia(kongre__337_2_1,varia_c)
    & sort(auswahl_1_1,as)
    & card(auswahl_1_1,int1)
    & etype(auswahl_1_1,int0)
    & fact(auswahl_1_1,real)
    & gener(auswahl_1_1,ge)
    & quant(auswahl_1_1,one)
    & refer(auswahl_1_1,refer_c)
    & varia(auswahl_1_1,varia_c)
    & sort(sieger__1_1,d)
    & sort(sieger__1_1,io)
    & card(sieger__1_1,int1)
    & etype(sieger__1_1,int0)
    & fact(sieger__1_1,real)
    & gener(sieger__1_1,ge)
    & quant(sieger__1_1,one)
    & refer(sieger__1_1,refer_c)
    & varia(sieger__1_1,varia_c) ) ).

%------------------------------------------------------------------------------
