%------------------------------------------------------------------------------
% File     : CSR116+24 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1788_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.47 v9.0.0, 0.19 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.64 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.71 v5.4.0, 0.70 v5.2.0, 0.50 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10846 (   0 equ)
%            Maximal formula atoms :  133 (   1 avg)
%            Number of connectives :  657 (   0   ~;  18   |; 513   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  133 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   86 (  86 usr;   0 prp; 2-3 aty)
%            Number of functors    : 16651 (16651 usr;16650 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1788,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1788,hypothesis,
    ( origl(c15,c323)
    & sub(c15,an_f__374hrer_1_1)
    & sub(c15,c15)
    & sub(c15,hirte_1_1)
    & arg1(c19,c15)
    & arg2(c19,c15)
    & subr(c19,sub_0)
    & pred(c307,autobiographie_1_1)
    & attch(c316,c307)
    & attr(c316,c317)
    & attr(c316,c318)
    & prop(c316,s__374dafrikanisch_1_1)
    & sub(c316,pr__344sident_1_1)
    & sub(c317,eigenname_1_1)
    & val(c317,nelson_0)
    & sub(c318,familiename_1_1)
    & val(c318,mandela_0)
    & flp(c323,c307)
    & agt(c324,c15)
    & subs(c324,f__374hren_1_1)
    & sort(c15,d)
    & card(c15,int1)
    & etype(c15,int0)
    & fact(c15,real)
    & gener(c15,sp)
    & quant(c15,one)
    & refer(c15,indet)
    & varia(c15,varia_c)
    & sort(c323,l)
    & card(c323,cons(x_constant,cons(int1,nil)))
    & etype(c323,int1)
    & fact(c323,real)
    & gener(c323,sp)
    & quant(c323,mult)
    & refer(c323,det)
    & varia(c323,con)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c)
    & sort(hirte_1_1,d)
    & card(hirte_1_1,int1)
    & etype(hirte_1_1,int0)
    & fact(hirte_1_1,real)
    & gener(hirte_1_1,ge)
    & quant(hirte_1_1,one)
    & refer(hirte_1_1,refer_c)
    & varia(hirte_1_1,varia_c)
    & sort(c19,st)
    & fact(c19,real)
    & gener(c19,sp)
    & sort(sub_0,st)
    & fact(sub_0,real)
    & gener(sub_0,gener_c)
    & sort(c307,d)
    & sort(c307,io)
    & card(c307,cons(x_constant,cons(int1,nil)))
    & etype(c307,int1)
    & fact(c307,real)
    & gener(c307,sp)
    & quant(c307,mult)
    & refer(c307,det)
    & varia(c307,con)
    & sort(autobiographie_1_1,d)
    & sort(autobiographie_1_1,io)
    & card(autobiographie_1_1,int1)
    & etype(autobiographie_1_1,int0)
    & fact(autobiographie_1_1,real)
    & gener(autobiographie_1_1,ge)
    & quant(autobiographie_1_1,one)
    & refer(autobiographie_1_1,refer_c)
    & varia(autobiographie_1_1,varia_c)
    & sort(c316,d)
    & card(c316,int1)
    & etype(c316,int0)
    & fact(c316,real)
    & gener(c316,sp)
    & quant(c316,one)
    & refer(c316,det)
    & varia(c316,con)
    & sort(c317,na)
    & card(c317,int1)
    & etype(c317,int0)
    & fact(c317,real)
    & gener(c317,sp)
    & quant(c317,one)
    & refer(c317,indet)
    & varia(c317,varia_c)
    & sort(c318,na)
    & card(c318,int1)
    & etype(c318,int0)
    & fact(c318,real)
    & gener(c318,sp)
    & quant(c318,one)
    & refer(c318,indet)
    & varia(c318,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(c324,da)
    & fact(c324,real)
    & gener(c324,sp)
    & sort(f__374hren_1_1,da)
    & fact(f__374hren_1_1,real)
    & gener(f__374hren_1_1,ge) ) ).

%------------------------------------------------------------------------------
