%------------------------------------------------------------------------------
% File     : CSR116+23 : TPTP v9.2.0. Released v4.0.0.
% Domain   : Commonsense Reasoning
% Problem  : Who was the first black president elected in South Africa?
% Version  : [Pel09] axioms.
% English  :

% Refs     : [Glo07] Gloeckner (2007), University of Hagen at CLEF 2007: An
%          : [PW07]  Pelzer & Wernhard (2007), System Description: E-KRHype
%          : [FG+08] Furbach et al. (2008), LogAnswer - A Deduction-Based Q
%          : [Pel09] Pelzer (2009), Email to Geoff Sutcliffe
% Source   : [Pel09]
% Names    : synth_qa07_010_mira_news_1786_tptp [Pel09]

% Status   : Theorem
% Rating   : 0.30 v9.1.0, 0.40 v9.0.0, 0.25 v8.2.0, 0.20 v8.1.0, 0.36 v7.5.0, 0.52 v7.4.0, 0.38 v7.3.0, 0.57 v7.2.0, 0.50 v7.0.0, 0.43 v6.4.0, 0.36 v6.3.0, 0.38 v6.2.0, 0.55 v6.1.0, 0.68 v6.0.0, 0.50 v5.5.0, 0.67 v5.4.0, 0.65 v5.3.0, 0.74 v5.2.0, 0.57 v5.0.0, 0.60 v4.1.0, 0.67 v4.0.1, 0.74 v4.0.0
% Syntax   : Number of formulae    : 10189 (10061 unt;   0 def)
%            Number of atoms       : 10936 (   0 equ)
%            Maximal formula atoms :  223 (   1 avg)
%            Number of connectives :  747 (   0   ~;  18   |; 603   &)
%                                         (   0 <=>; 126  =>;   0  <=;   0 <~>)
%            Maximal formula depth :  223 (   1 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of predicates  :   87 (  87 usr;   0 prp; 2-6 aty)
%            Number of functors    : 16660 (16660 usr;16659 con; 0-2 aty)
%            Number of variables   :  478 ( 405   !;  73   ?)
% SPC      : FOF_THM_RFO_NEQ

% Comments : The different versions of this problem stem from the use of
%            different text snippet retrieval modules, and different snippets
%            being found. The problem tries to prove the questions from the
%            snippet and the background knowledge.
%------------------------------------------------------------------------------
%----Include LogAnswer axioms
include('Axioms/CSR004+0.ax').
%------------------------------------------------------------------------------
fof(synth_qa07_010_mira_news_1786,conjecture,
    ? [X0,X1,X2,X3,X4,X5,X6,X7,X8,X9] :
      ( in(X5,X6)
      & arg1(X3,X0)
      & arg2(X3,X4)
      & attr(X0,X1)
      & attr(X0,X2)
      & attr(X6,X7)
      & obj(X8,X0)
      & sub(X1,familiename_1_1)
      & sub(X2,eigenname_1_1)
      & sub(X4,X9)
      & sub(X7,name_1_1)
      & subr(X3,rprs_0)
      & val(X1,mandela_0)
      & val(X2,nelson_0)
      & val(X7,s__374dafrika_0) ) ).

fof(ave07_era5_synth_qa07_010_mira_news_1786,hypothesis,
    ( attr(c186,c222)
    & sub(c186,an_f__374hrer_1_1)
    & sub(c186,mensch_1_1)
    & attch(c191,c194)
    & attr(c191,c192)
    & sub(c191,einrichtung_1_2)
    & sub(c192,name_1_1)
    & val(c192,ist_0)
    & sub(c194,hirte_1_1)
    & attch(c196,c194)
    & attr(c196,c197)
    & sub(c196,einrichtung_1_2)
    & sub(c197,name_1_1)
    & val(c197,ein_0)
    & sub(c201,aus_3_1)
    & pred(c205,autobiographie_1_1)
    & attch(c214,c205)
    & attr(c214,c215)
    & attr(c214,c216)
    & prop(c214,s__374dafrikanisch_1_1)
    & sub(c214,pr__344sident_1_1)
    & sub(c215,eigenname_1_1)
    & val(c215,nelson_0)
    & sub(c216,familiename_1_1)
    & val(c216,mandela_0)
    & sub(c222,eigenname_1_1)
    & val(c222,ii_0)
    & tupl_p6(c300,c186,c194,c201,c205,c186)
    & sort(c186,d)
    & card(c186,int1)
    & etype(c186,int0)
    & fact(c186,real)
    & gener(c186,sp)
    & quant(c186,one)
    & refer(c186,indet)
    & varia(c186,varia_c)
    & sort(c222,na)
    & card(c222,int1)
    & etype(c222,int0)
    & fact(c222,real)
    & gener(c222,sp)
    & quant(c222,one)
    & refer(c222,indet)
    & varia(c222,varia_c)
    & sort(an_f__374hrer_1_1,d)
    & card(an_f__374hrer_1_1,int1)
    & etype(an_f__374hrer_1_1,int0)
    & fact(an_f__374hrer_1_1,real)
    & gener(an_f__374hrer_1_1,ge)
    & quant(an_f__374hrer_1_1,one)
    & refer(an_f__374hrer_1_1,refer_c)
    & varia(an_f__374hrer_1_1,varia_c)
    & sort(mensch_1_1,d)
    & card(mensch_1_1,int1)
    & etype(mensch_1_1,int0)
    & fact(mensch_1_1,real)
    & gener(mensch_1_1,ge)
    & quant(mensch_1_1,one)
    & refer(mensch_1_1,refer_c)
    & varia(mensch_1_1,varia_c)
    & sort(c191,d)
    & sort(c191,io)
    & card(c191,int1)
    & etype(c191,int1)
    & fact(c191,real)
    & gener(c191,sp)
    & quant(c191,one)
    & refer(c191,det)
    & varia(c191,con)
    & sort(c194,d)
    & card(c194,int1)
    & etype(c194,int0)
    & fact(c194,real)
    & gener(c194,sp)
    & quant(c194,one)
    & refer(c194,det)
    & varia(c194,varia_c)
    & sort(c192,na)
    & card(c192,int1)
    & etype(c192,int0)
    & fact(c192,real)
    & gener(c192,sp)
    & quant(c192,one)
    & refer(c192,indet)
    & varia(c192,varia_c)
    & sort(einrichtung_1_2,d)
    & sort(einrichtung_1_2,io)
    & card(einrichtung_1_2,card_c)
    & etype(einrichtung_1_2,int1)
    & fact(einrichtung_1_2,real)
    & gener(einrichtung_1_2,ge)
    & quant(einrichtung_1_2,quant_c)
    & refer(einrichtung_1_2,refer_c)
    & varia(einrichtung_1_2,varia_c)
    & sort(name_1_1,na)
    & card(name_1_1,int1)
    & etype(name_1_1,int0)
    & fact(name_1_1,real)
    & gener(name_1_1,ge)
    & quant(name_1_1,one)
    & refer(name_1_1,refer_c)
    & varia(name_1_1,varia_c)
    & sort(ist_0,fe)
    & sort(hirte_1_1,d)
    & card(hirte_1_1,int1)
    & etype(hirte_1_1,int0)
    & fact(hirte_1_1,real)
    & gener(hirte_1_1,ge)
    & quant(hirte_1_1,one)
    & refer(hirte_1_1,refer_c)
    & varia(hirte_1_1,varia_c)
    & sort(c196,d)
    & sort(c196,io)
    & card(c196,int1)
    & etype(c196,int1)
    & fact(c196,real)
    & gener(c196,sp)
    & quant(c196,one)
    & refer(c196,det)
    & varia(c196,con)
    & sort(c197,na)
    & card(c197,int1)
    & etype(c197,int0)
    & fact(c197,real)
    & gener(c197,sp)
    & quant(c197,one)
    & refer(c197,indet)
    & varia(c197,varia_c)
    & sort(ein_0,fe)
    & sort(c201,io)
    & card(c201,int1)
    & etype(c201,int0)
    & fact(c201,real)
    & gener(c201,gener_c)
    & quant(c201,one)
    & refer(c201,refer_c)
    & varia(c201,varia_c)
    & sort(aus_3_1,io)
    & card(aus_3_1,int1)
    & etype(aus_3_1,int0)
    & fact(aus_3_1,real)
    & gener(aus_3_1,ge)
    & quant(aus_3_1,one)
    & refer(aus_3_1,refer_c)
    & varia(aus_3_1,varia_c)
    & sort(c205,d)
    & sort(c205,io)
    & card(c205,cons(x_constant,cons(int1,nil)))
    & etype(c205,int1)
    & fact(c205,real)
    & gener(c205,sp)
    & quant(c205,mult)
    & refer(c205,det)
    & varia(c205,con)
    & sort(autobiographie_1_1,d)
    & sort(autobiographie_1_1,io)
    & card(autobiographie_1_1,int1)
    & etype(autobiographie_1_1,int0)
    & fact(autobiographie_1_1,real)
    & gener(autobiographie_1_1,ge)
    & quant(autobiographie_1_1,one)
    & refer(autobiographie_1_1,refer_c)
    & varia(autobiographie_1_1,varia_c)
    & sort(c214,d)
    & card(c214,int1)
    & etype(c214,int0)
    & fact(c214,real)
    & gener(c214,sp)
    & quant(c214,one)
    & refer(c214,det)
    & varia(c214,con)
    & sort(c215,na)
    & card(c215,int1)
    & etype(c215,int0)
    & fact(c215,real)
    & gener(c215,sp)
    & quant(c215,one)
    & refer(c215,indet)
    & varia(c215,varia_c)
    & sort(c216,na)
    & card(c216,int1)
    & etype(c216,int0)
    & fact(c216,real)
    & gener(c216,sp)
    & quant(c216,one)
    & refer(c216,indet)
    & varia(c216,varia_c)
    & sort(s__374dafrikanisch_1_1,nq)
    & sort(pr__344sident_1_1,d)
    & card(pr__344sident_1_1,int1)
    & etype(pr__344sident_1_1,int0)
    & fact(pr__344sident_1_1,real)
    & gener(pr__344sident_1_1,ge)
    & quant(pr__344sident_1_1,one)
    & refer(pr__344sident_1_1,refer_c)
    & varia(pr__344sident_1_1,varia_c)
    & sort(eigenname_1_1,na)
    & card(eigenname_1_1,int1)
    & etype(eigenname_1_1,int0)
    & fact(eigenname_1_1,real)
    & gener(eigenname_1_1,ge)
    & quant(eigenname_1_1,one)
    & refer(eigenname_1_1,refer_c)
    & varia(eigenname_1_1,varia_c)
    & sort(nelson_0,fe)
    & sort(familiename_1_1,na)
    & card(familiename_1_1,int1)
    & etype(familiename_1_1,int0)
    & fact(familiename_1_1,real)
    & gener(familiename_1_1,ge)
    & quant(familiename_1_1,one)
    & refer(familiename_1_1,refer_c)
    & varia(familiename_1_1,varia_c)
    & sort(mandela_0,fe)
    & sort(ii_0,fe)
    & sort(c300,ent)
    & card(c300,card_c)
    & etype(c300,etype_c)
    & fact(c300,real)
    & gener(c300,gener_c)
    & quant(c300,quant_c)
    & refer(c300,refer_c)
    & varia(c300,varia_c) ) ).

%------------------------------------------------------------------------------
